/* ----------------------------------------------------------------------------
 *         SAM Software Package License 
 * ----------------------------------------------------------------------------
 * Copyright (c) 2013, Atmel Corporation
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

/**
 * \file
 */

/*------------------------------------------------------------------------------
 *         Headers
 *------------------------------------------------------------------------------*/

#include "board.h"

/*------------------------------------------------------------------------------
 *         Local Variables
 *------------------------------------------------------------------------------*/

const struct ov_reg ov5640_yuv_vga[]= {
    {0x3103, 0x11},
    {0x3008, 0x82},
    {0xFFFF, 0x05},
    {0x3008, 0x42},
    {0x3103, 0x03}, 
    {0x3017, 0xff},
    {0x3018, 0xff},

    {0x3034, 0x1a},
    {0x3035, 0x11},
    {0x3036, 0x5b},
    {0x3037, 0x13},
    {0x3108, 0x01},
    {0x303d, 0x20},

    {0x3630, 0x36},
    {0x3631, 0x0e},
    {0x3632, 0xe2},
    {0x3633, 0x12},
    {0x3621, 0xe0},
    {0x3704, 0xa0},
    {0x3703, 0x5a},
    {0x3715, 0x78},
    {0x3717, 0x01},
    {0x370b, 0x60},
    {0x3705, 0x1a},
    {0x3905, 0x02},
    {0x3906, 0x10},
    {0x3901, 0x0a},
    {0x3731, 0x12},
    {0x3600, 0x08},
    {0x3601, 0x33},
    {0x302d, 0x60},
    {0x3620, 0x52},
    {0x371b, 0x20},
    {0x471c, 0x50},
    {0x3a13, 0x43},
    {0x3a18, 0x00},
    {0x3a19, 0xf8},
    {0x3635, 0x13},
    {0x3636, 0x03},
    {0x3634, 0x40},
    {0x3622, 0x01},
    {0x3c01, 0x34},
    {0x3c04, 0x28},
    {0x3c05, 0x98},
    {0x3c06, 0x00},
    {0x3c07, 0x08},
    {0x3c08, 0x00},
    {0x3c09, 0x1c},
    {0x3c0a, 0x9c},
    {0x3c0b, 0x40},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3800, 0x00},
    {0x3801, 0x00},
    {0x3802, 0x00},
    {0x3803, 0x04},
    {0x3804, 0x0a},
    {0x3805, 0x3f},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x02},
    {0x3809, 0x80},
    {0x380a, 0x01},
    {0x380b, 0xe0},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x03},
    {0x380f, 0xd8},
    {0x3810, 0x00},
    {0x3811, 0x10},
    {0x3812, 0x00},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3708, 0x64},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a08, 0x01},
    {0x3a09, 0x27},
    {0x3a0a, 0x00},
    {0x3a0b, 0xf6},
    {0x3a0e, 0x03},
    {0x3a0d, 0x04},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4001, 0x02},
    {0x4004, 0x02},
    {0x3000, 0x00},
    {0x3002, 0x1c},
    {0x3004, 0xff},
    {0x3006, 0xc3},
    {0x300e, 0x58},
    {0x302e, 0x00},
    {0x4300, 0x30},
    {0x501f, 0x00},
    {0x4713, 0x03},
    {0x4407, 0x04},
    {0x440e, 0x00},
    {0x460b, 0x35},
    {0x460c, 0x22},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5000, 0xa7},
    {0x5001, 0xa3},
    {0x5180, 0xff},
    {0x5181, 0xf2},
    {0x5182, 0x00},
    {0x5183, 0x14},
    {0x5184, 0x25},
    {0x5185, 0x24},
    {0x5186, 0x09},
    {0x5187, 0x09},
    {0x5188, 0x09},
    {0x5189, 0x75},
    {0x518a, 0x54},
    {0x518b, 0xe0},
    {0x518c, 0xb2},
    {0x518d, 0x42},
    {0x518e, 0x3d},
    {0x518f, 0x56},
    {0x5190, 0x46},
    {0x5191, 0xf8},
    {0x5192, 0x04},
    {0x5193, 0x70},
    {0x5194, 0xf0},
    {0x5195, 0xf0},
    {0x5196, 0x03},
    {0x5197, 0x01},
    {0x5198, 0x04},
    {0x5199, 0x12},
    {0x519a, 0x04},
    {0x519b, 0x00},
    {0x519c, 0x06},
    {0x519d, 0x82},
    {0x519e, 0x38},
    {0x5381, 0x1e},
    {0x5382, 0x5b},
    {0x5383, 0x08},
    {0x5384, 0x0a},
    {0x5385, 0x7e},
    {0x5386, 0x88},
    {0x5387, 0x7c},
    {0x5388, 0x6c},
    {0x5389, 0x10},
    {0x538a, 0x01},
    {0x538b, 0x98},
    {0x5300, 0x08},
    {0x5301, 0x30},
    {0x5302, 0x10},
    {0x5303, 0x00},
    {0x5304, 0x08},
    {0x5305, 0x30},
    {0x5306, 0x08},
    {0x5307, 0x16},
    {0x5309, 0x08},
    {0x530a, 0x30},
    {0x530b, 0x04},
    {0x530c, 0x06},
    {0x5480, 0x01},
    {0x5481, 0x08},
    {0x5482, 0x14},
    {0x5483, 0x28},
    {0x5484, 0x51},
    {0x5485, 0x65},
    {0x5486, 0x71},
    {0x5487, 0x7d},
    {0x5488, 0x87},
    {0x5489, 0x91},
    {0x548a, 0x9a},
    {0x548b, 0xaa},
    {0x548c, 0xb8},
    {0x548d, 0xcd},
    {0x548e, 0xdd},
    {0x548f, 0xea},
    {0x5490, 0x1d},
    {0x5580, 0x02},
    {0x5583, 0x40},
    {0x5584, 0x10},
    {0x5589, 0x10},
    {0x558a, 0x00},
    {0x558b, 0xf8},
    {0x5800, 0x23},
    {0x5801, 0x14},
    {0x5802, 0x0f},
    {0x5803, 0x0f},
    {0x5804, 0x12},
    {0x5805, 0x26},
    {0x5806, 0x0c},
    {0x5807, 0x08},
    {0x5808, 0x05},
    {0x5809, 0x05},
    {0x580a, 0x08},
    {0x580b, 0x0d},
    {0x580c, 0x08},
    {0x580d, 0x03},
    {0x580e, 0x00},
    {0x580f, 0x00},
    {0x5810, 0x03},
    {0x5811, 0x09},
    {0x5812, 0x07},
    {0x5813, 0x03},
    {0x5814, 0x00},
    {0x5815, 0x01},
    {0x5816, 0x03},
    {0x5817, 0x08},
    {0x5818, 0x0d},
    {0x5819, 0x08},
    {0x581a, 0x05},
    {0x581b, 0x06},
    {0x581c, 0x08},
    {0x581d, 0x0e},
    {0x581e, 0x29},
    {0x581f, 0x17},
    {0x5820, 0x11},
    {0x5821, 0x11},
    {0x5822, 0x15},
    {0x5823, 0x28},
    {0x5824, 0x46},
    {0x5825, 0x26},
    {0x5826, 0x08},
    {0x5827, 0x26},
    {0x5828, 0x64},
    {0x5829, 0x26},
    {0x582a, 0x24},
    {0x582b, 0x22},
    {0x582c, 0x24},
    {0x582d, 0x24},
    {0x582e, 0x06},
    {0x582f, 0x22},
    {0x5830, 0x40},
    {0x5831, 0x42},
    {0x5832, 0x24},
    {0x5833, 0x26},
    {0x5834, 0x24},
    {0x5835, 0x22},
    {0x5836, 0x22},
    {0x5837, 0x26},
    {0x5838, 0x44},
    {0x5839, 0x24},
    {0x583a, 0x26},
    {0x583b, 0x28},
    {0x583c, 0x42},
    {0x583d, 0xce},
    {0x5025, 0x00},
    {0x3a0f, 0x30},
    {0x3a10, 0x28},
    {0x3a1b, 0x30},
    {0x3a1e, 0x26},
    {0x3a11, 0x60},
    {0x3a1f, 0x14},
    {0x3008, 0x02},
#if 1
    {0x3503, 0x00},
    {0x3c07, 0x08},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3803, 0x04},
    {0x3807, 0x9b},
    {0x3808, 0x02},
    {0x3809, 0x80},
    {0x380a, 0x01},
    {0x380b, 0xe0},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x03},
    {0x380f, 0xd8},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3708, 0x62},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a0e, 0x03},
    {0x3a0d, 0x04},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4004, 0x02},
    {0x4713, 0x03},
    {0x4407, 0x04},
    {0x460b, 0x35},
    {0x460c, 0x22},
    {0x3824, 0x02},
    {0x5001, 0xa3},

#endif
    {0xFF, 0xFF}
};

const struct ov_reg ov5640_yuv_sxga[]= {
    {0x3103, 0x11},
    {0x3008, 0x82},
    {0xFFFF, 0x05},
    {0x3008, 0x42},
    {0x3103, 0x03}, 
    {0x3017, 0xff},
    {0x3018, 0xff},
#if 0
    {0x3034, 0x1a},
    {0x3035, 0x11},
    {0x3036, 0x27},
    {0x3037, 0x12},
    {0x3108, 0x01},
#endif

    {0x3034, 0x1a},
    {0x3035, 0x11},
    {0x3036, 0x5b},
    {0x3037, 0x13},
    {0x3108, 0x01},
    {0x303d, 0x20},

    {0x3630, 0x36},
    {0x3631, 0x0e},
    {0x3632, 0xe2},
    {0x3633, 0x12},
    {0x3621, 0xe0},
    {0x3704, 0xa0},
    {0x3703, 0x5a},
    {0x3715, 0x78},
    {0x3717, 0x01},
    {0x370b, 0x60},
    {0x3705, 0x1a},
    {0x3905, 0x02},
    {0x3906, 0x10},
    {0x3901, 0x0a},
    {0x3731, 0x12},
    {0x3600, 0x08},
    {0x3601, 0x33},
    {0x302d, 0x60},
    {0x3620, 0x52},
    {0x371b, 0x20},
    {0x471c, 0x50},
    {0x3a13, 0x43},
    {0x3a18, 0x00},
    {0x3a19, 0xf8},
    {0x3635, 0x13},
    {0x3636, 0x03},
    {0x3634, 0x40},
    {0x3622, 0x01},
    {0x3c01, 0x34},
    {0x3c04, 0x28},
    {0x3c05, 0x98},
    {0x3c06, 0x00},
    {0x3c07, 0x08},
    {0x3c08, 0x00},
    {0x3c09, 0x1c},
    {0x3c0a, 0x9c},
    {0x3c0b, 0x40},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3800, 0x00},
    {0x3801, 0x00},
    {0x3802, 0x00},
    {0x3803, 0x04},
    {0x3804, 0x0a},
    {0x3805, 0x3f},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x02},
    {0x3809, 0x80},
    {0x380a, 0x01},
    {0x380b, 0xe0},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x03},
    {0x380f, 0xd8},
    {0x3810, 0x00},
    {0x3811, 0x10},
    {0x3812, 0x00},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3708, 0x64},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a08, 0x01},
    {0x3a09, 0x27},
    {0x3a0a, 0x00},
    {0x3a0b, 0xf6},
    {0x3a0e, 0x03},
    {0x3a0d, 0x04},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4001, 0x02},
    {0x4004, 0x02},
    {0x3000, 0x00},
    {0x3002, 0x1c},
    {0x3004, 0xff},
    {0x3006, 0xc3},
    {0x300e, 0x58},
    {0x302e, 0x00},
    {0x4300, 0x30},
    {0x501f, 0x00},
    {0x4713, 0x03},
    {0x4407, 0x04},
    {0x440e, 0x00},
    {0x460b, 0x35},
    {0x460c, 0x22},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5000, 0xa7},
    {0x5001, 0xa3},
    {0x5180, 0xff},
    {0x5181, 0xf2},
    {0x5182, 0x00},
    {0x5183, 0x14},
    {0x5184, 0x25},
    {0x5185, 0x24},
    {0x5186, 0x09},
    {0x5187, 0x09},
    {0x5188, 0x09},
    {0x5189, 0x75},
    {0x518a, 0x54},
    {0x518b, 0xe0},
    {0x518c, 0xb2},
    {0x518d, 0x42},
    {0x518e, 0x3d},
    {0x518f, 0x56},
    {0x5190, 0x46},
    {0x5191, 0xf8},
    {0x5192, 0x04},
    {0x5193, 0x70},
    {0x5194, 0xf0},
    {0x5195, 0xf0},
    {0x5196, 0x03},
    {0x5197, 0x01},
    {0x5198, 0x04},
    {0x5199, 0x12},
    {0x519a, 0x04},
    {0x519b, 0x00},
    {0x519c, 0x06},
    {0x519d, 0x82},
    {0x519e, 0x38},
    {0x5381, 0x1e},
    {0x5382, 0x5b},
    {0x5383, 0x08},
    {0x5384, 0x0a},
    {0x5385, 0x7e},
    {0x5386, 0x88},
    {0x5387, 0x7c},
    {0x5388, 0x6c},
    {0x5389, 0x10},
    {0x538a, 0x01},
    {0x538b, 0x98},
    {0x5300, 0x08},
    {0x5301, 0x30},
    {0x5302, 0x10},
    {0x5303, 0x00},
    {0x5304, 0x08},
    {0x5305, 0x30},
    {0x5306, 0x08},
    {0x5307, 0x16},
    {0x5309, 0x08},
    {0x530a, 0x30},
    {0x530b, 0x04},
    {0x530c, 0x06},
    {0x5480, 0x01},
    {0x5481, 0x08},
    {0x5482, 0x14},
    {0x5483, 0x28},
    {0x5484, 0x51},
    {0x5485, 0x65},
    {0x5486, 0x71},
    {0x5487, 0x7d},
    {0x5488, 0x87},
    {0x5489, 0x91},
    {0x548a, 0x9a},
    {0x548b, 0xaa},
    {0x548c, 0xb8},
    {0x548d, 0xcd},
    {0x548e, 0xdd},
    {0x548f, 0xea},
    {0x5490, 0x1d},
    {0x5580, 0x02},
    {0x5583, 0x40},
    {0x5584, 0x10},
    {0x5589, 0x10},
    {0x558a, 0x00},
    {0x558b, 0xf8},
    {0x5800, 0x23},
    {0x5801, 0x14},
    {0x5802, 0x0f},
    {0x5803, 0x0f},
    {0x5804, 0x12},
    {0x5805, 0x26},
    {0x5806, 0x0c},
    {0x5807, 0x08},
    {0x5808, 0x05},
    {0x5809, 0x05},
    {0x580a, 0x08},
    {0x580b, 0x0d},
    {0x580c, 0x08},
    {0x580d, 0x03},
    {0x580e, 0x00},
    {0x580f, 0x00},
    {0x5810, 0x03},
    {0x5811, 0x09},
    {0x5812, 0x07},
    {0x5813, 0x03},
    {0x5814, 0x00},
    {0x5815, 0x01},
    {0x5816, 0x03},
    {0x5817, 0x08},
    {0x5818, 0x0d},
    {0x5819, 0x08},
    {0x581a, 0x05},
    {0x581b, 0x06},
    {0x581c, 0x08},
    {0x581d, 0x0e},
    {0x581e, 0x29},
    {0x581f, 0x17},
    {0x5820, 0x11},
    {0x5821, 0x11},
    {0x5822, 0x15},
    {0x5823, 0x28},
    {0x5824, 0x46},
    {0x5825, 0x26},
    {0x5826, 0x08},
    {0x5827, 0x26},
    {0x5828, 0x64},
    {0x5829, 0x26},
    {0x582a, 0x24},
    {0x582b, 0x22},
    {0x582c, 0x24},
    {0x582d, 0x24},
    {0x582e, 0x06},
    {0x582f, 0x22},
    {0x5830, 0x40},
    {0x5831, 0x42},
    {0x5832, 0x24},
    {0x5833, 0x26},
    {0x5834, 0x24},
    {0x5835, 0x22},
    {0x5836, 0x22},
    {0x5837, 0x26},
    {0x5838, 0x44},
    {0x5839, 0x24},
    {0x583a, 0x26},
    {0x583b, 0x28},
    {0x583c, 0x42},
    {0x583d, 0xce},
    {0x5025, 0x00},
    {0x3a0f, 0x30},
    {0x3a10, 0x28},
    {0x3a1b, 0x30},
    {0x3a1e, 0x26},
    {0x3a11, 0x60},
    {0x3a1f, 0x14},
    {0x3008, 0x02},
 
#if 1
    {0x3503, 0x00},
    {0x3c07, 0x08},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3803, 0x04},
    {0x3807, 0x9b},
    {0x3808, 0x02},
    {0x3809, 0x80},
    {0x380a, 0x01},
    {0x380b, 0xe0},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x03},
    {0x380f, 0xd8},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3708, 0x62},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a0e, 0x03},
    {0x3a0d, 0x04},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4004, 0x02},
    {0x4713, 0x03},
    {0x4407, 0x04},
    {0x460b, 0x35},
    {0x460c, 0x22},
    {0x3824, 0x02},
    {0x5001, 0xa3},
#endif
    {0x3c07,0x08},
  {0x3820,0x41},
  {0x3821,0x07},
  {0x3800,0x00},
  {0x3801,0x00},
  {0x3802,0x00},
  {0x3803,0x04},
  {0x3804,0x0a},
  {0x3805,0x3f},
  {0x3806,0x07},
  {0x3807,0x9b},
  {0x3808,0x05},
  {0x3809,0x00},
  {0x380a,0x02},
  {0x380b,0xd0},
  {0x380c,0x07},
  {0x380d,0x68},
  {0x380e,0x03},
  {0x380f,0xd8},
  {0x3810,0x00},
  {0x3811,0x10},
  {0x3812,0x00},
  {0x3813,0x7e},
  {0x3814,0x31},
  {0x3815,0x31},
  {0x3618,0x00},
  {0x3612,0x29},
  {0x3709,0x52},
  {0x370c,0x03},
  {0x3a02,0x0b},
  {0x3a03,0x88},
  {0x3a14,0x0b},
  {0x3a15,0x88},
  {0x4004,0x02},
  {0x3002,0x1c},
  {0x3006,0xc3},
  {0x4713,0x03},
  {0x4407,0x04},
  {0x460b,0x35},
  {0x460c,0x20},
  {0x4837,0x22},
  {0x3824,0x02},
  {0x5001,0xa3},
  {0x3034,0x1a},
  {0x3035,0x11},
  {0x3036,0x46},
  {0x3037,0x13},
  {0x3503,0x03},
    {0xFF, 0xFF}
};

const struct ov_reg ov5640_afc[]= {
{0x3000 ,0x20 },
{0x8000 ,0x02 },
{0x8001 ,0x0f },
{0x8002 ,0xe0 },
{0x8003 ,0x02 },
{0x8004 ,0x09 },
{0x8005 ,0x28 },
{0x8006 ,0xc2 },
{0x8007 ,0x01 },
{0x8008 ,0x22 },
{0x8009 ,0x22 },
{0x800a ,0x00 },
{0x800b ,0x02 },
{0x800c ,0x0d },
{0x800d ,0xea },
{0x800e ,0x30 },
{0x800f ,0x01 },
{0x8010 ,0x03 },
{0x8011 ,0x02 },
{0x8012 ,0x02 },
{0x8013 ,0xa6 },
{0x8014 ,0x30 },
{0x8015 ,0x02 },
{0x8016 ,0x03 },
{0x8017 ,0x02 },
{0x8018 ,0x02 },
{0x8019 ,0xa6 },
{0x801a ,0x90 },
{0x801b ,0x51 },
{0x801c ,0xa5 },
{0x801d ,0xe0 },
{0x801e ,0x78 },
{0x801f ,0x93 },
{0x8020 ,0xf6 },
{0x8021 ,0xa3 },
{0x8022 ,0xe0 },
{0x8023 ,0x08 },
{0x8024 ,0xf6 },
{0x8025 ,0xa3 },
{0x8026 ,0xe0 },
{0x8027 ,0x08 },
{0x8028 ,0xf6 },
{0x8029 ,0xe5 },
{0x802a ,0x1f },
{0x802b ,0x70 },
{0x802c ,0x4f },
{0x802d ,0x75 },
{0x802e ,0x1e },
{0x802f ,0x20 },
{0x8030 ,0xd2 },
{0x8031 ,0x35 },
{0x8032 ,0xd3 },
{0x8033 ,0x78 },
{0x8034 ,0x4f },
{0x8035 ,0xe6 },
{0x8036 ,0x94 },
{0x8037 ,0x00 },
{0x8038 ,0x18 },
{0x8039 ,0xe6 },
{0x803a ,0x94 },
{0x803b ,0x00 },
{0x803c ,0x40 },
{0x803d ,0x07 },
{0x803e ,0xe6 },
{0x803f ,0xfe },
{0x8040 ,0x08 },
{0x8041 ,0xe6 },
{0x8042 ,0xff },
{0x8043 ,0x80 },
{0x8044 ,0x03 },
{0x8045 ,0x12 },
{0x8046 ,0x0c },
{0x8047 ,0x67 },
{0x8048 ,0x78 },
{0x8049 ,0x7e },
{0x804a ,0xa6 },
{0x804b ,0x06 },
{0x804c ,0x08 },
{0x804d ,0xa6 },
{0x804e ,0x07 },
{0x804f ,0x78 },
{0x8050 ,0x8b },
{0x8051 ,0xa6 },
{0x8052 ,0x09 },
{0x8053 ,0x18 },
{0x8054 ,0x76 },
{0x8055 ,0x01 },
{0x8056 ,0x12 },
{0x8057 ,0x0c },
{0x8058 ,0x67 },
{0x8059 ,0x78 },
{0x805a ,0x4e },
{0x805b ,0xa6 },
{0x805c ,0x06 },
{0x805d ,0x08 },
{0x805e ,0xa6 },
{0x805f ,0x07 },
{0x8060 ,0x78 },
{0x8061 ,0x8b },
{0x8062 ,0xe6 },
{0x8063 ,0x78 },
{0x8064 ,0x6e },
{0x8065 ,0xf6 },
{0x8066 ,0x75 },
{0x8067 ,0x1f },
{0x8068 ,0x01 },
{0x8069 ,0x78 },
{0x806a ,0x93 },
{0x806b ,0xe6 },
{0x806c ,0x78 },
{0x806d ,0x90 },
{0x806e ,0xf6 },
{0x806f ,0x78 },
{0x8070 ,0x94 },
{0x8071 ,0xe6 },
{0x8072 ,0x78 },
{0x8073 ,0x91 },
{0x8074 ,0xf6 },
{0x8075 ,0x78 },
{0x8076 ,0x95 },
{0x8077 ,0xe6 },
{0x8078 ,0x78 },
{0x8079 ,0x92 },
{0x807a ,0xf6 },
{0x807b ,0x22 },
{0x807c ,0x79 },
{0x807d ,0x90 },
{0x807e ,0xe7 },
{0x807f ,0xd3 },
{0x8080 ,0x78 },
{0x8081 ,0x93 },
{0x8082 ,0x96 },
{0x8083 ,0x40 },
{0x8084 ,0x05 },
{0x8085 ,0xe7 },
{0x8086 ,0x96 },
{0x8087 ,0xff },
{0x8088 ,0x80 },
{0x8089 ,0x08 },
{0x808a ,0xc3 },
{0x808b ,0x79 },
{0x808c ,0x93 },
{0x808d ,0xe7 },
{0x808e ,0x78 },
{0x808f ,0x90 },
{0x8090 ,0x96 },
{0x8091 ,0xff },
{0x8092 ,0x78 },
{0x8093 ,0x88 },
{0x8094 ,0x76 },
{0x8095 ,0x00 },
{0x8096 ,0x08 },
{0x8097 ,0xa6 },
{0x8098 ,0x07 },
{0x8099 ,0x79 },
{0x809a ,0x91 },
{0x809b ,0xe7 },
{0x809c ,0xd3 },
{0x809d ,0x78 },
{0x809e ,0x94 },
{0x809f ,0x96 },
{0x80a0 ,0x40 },
{0x80a1 ,0x05 },
{0x80a2 ,0xe7 },
{0x80a3 ,0x96 },
{0x80a4 ,0xff },
{0x80a5 ,0x80 },
{0x80a6 ,0x08 },
{0x80a7 ,0xc3 },
{0x80a8 ,0x79 },
{0x80a9 ,0x94 },
{0x80aa ,0xe7 },
{0x80ab ,0x78 },
{0x80ac ,0x91 },
{0x80ad ,0x96 },
{0x80ae ,0xff },
{0x80af ,0x12 },
{0x80b0 ,0x0c },
{0x80b1 ,0xb0 },
{0x80b2 ,0x79 },
{0x80b3 ,0x92 },
{0x80b4 ,0xe7 },
{0x80b5 ,0xd3 },
{0x80b6 ,0x78 },
{0x80b7 ,0x95 },
{0x80b8 ,0x96 },
{0x80b9 ,0x40 },
{0x80ba ,0x05 },
{0x80bb ,0xe7 },
{0x80bc ,0x96 },
{0x80bd ,0xff },
{0x80be ,0x80 },
{0x80bf ,0x08 },
{0x80c0 ,0xc3 },
{0x80c1 ,0x79 },
{0x80c2 ,0x95 },
{0x80c3 ,0xe7 },
{0x80c4 ,0x78 },
{0x80c5 ,0x92 },
{0x80c6 ,0x96 },
{0x80c7 ,0xff },
{0x80c8 ,0x12 },
{0x80c9 ,0x0c },
{0x80ca ,0xb0 },
{0x80cb ,0x12 },
{0x80cc ,0x0c },
{0x80cd ,0x67 },
{0x80ce ,0x78 },
{0x80cf ,0x8a },
{0x80d0 ,0xe6 },
{0x80d1 ,0x25 },
{0x80d2 ,0xe0 },
{0x80d3 ,0x24 },
{0x80d4 ,0x4e },
{0x80d5 ,0xf8 },
{0x80d6 ,0xa6 },
{0x80d7 ,0x06 },
{0x80d8 ,0x08 },
{0x80d9 ,0xa6 },
{0x80da ,0x07 },
{0x80db ,0x78 },
{0x80dc ,0x8a },
{0x80dd ,0xe6 },
{0x80de ,0x24 },
{0x80df ,0x6e },
{0x80e0 ,0xf8 },
{0x80e1 ,0xa6 },
{0x80e2 ,0x09 },
{0x80e3 ,0x90 },
{0x80e4 ,0x0e },
{0x80e5 ,0x93 },
{0x80e6 ,0xe4 },
{0x80e7 ,0x93 },
{0x80e8 ,0x24 },
{0x80e9 ,0xff },
{0x80ea ,0xff },
{0x80eb ,0xe4 },
{0x80ec ,0x34 },
{0x80ed ,0xff },
{0x80ee ,0xfe },
{0x80ef ,0x78 },
{0x80f0 ,0x8a },
{0x80f1 ,0xe6 },
{0x80f2 ,0x24 },
{0x80f3 ,0x01 },
{0x80f4 ,0xfd },
{0x80f5 ,0xe4 },
{0x80f6 ,0x33 },
{0x80f7 ,0xfc },
{0x80f8 ,0xd3 },
{0x80f9 ,0xed },
{0x80fa ,0x9f },
{0x80fb ,0xee },
{0x80fc ,0x64 },
{0x80fd ,0x80 },
{0x80fe ,0xf8 },
{0x80ff ,0xec },
{0x8100 ,0x64 },
{0x8101 ,0x80 },
{0x8102 ,0x98 },
{0x8103 ,0x40 },
{0x8104 ,0x04 },
{0x8105 ,0x7f },
{0x8106 ,0x00 },
{0x8107 ,0x80 },
{0x8108 ,0x05 },
{0x8109 ,0x78 },
{0x810a ,0x8a },
{0x810b ,0xe6 },
{0x810c ,0x04 },
{0x810d ,0xff },
{0x810e ,0x78 },
{0x810f ,0x8a },
{0x8110 ,0xa6 },
{0x8111 ,0x07 },
{0x8112 ,0xe5 },
{0x8113 ,0x1f },
{0x8114 ,0xb4 },
{0x8115 ,0x01 },
{0x8116 ,0x0a },
{0x8117 ,0xe6 },
{0x8118 ,0x60 },
{0x8119 ,0x03 },
{0x811a ,0x02 },
{0x811b ,0x02 },
{0x811c ,0xa6 },
{0x811d ,0x75 },
{0x811e ,0x1f },
{0x811f ,0x02 },
{0x8120 ,0x22 },
{0x8121 ,0x78 },
{0x8122 ,0x4e },
{0x8123 ,0xe6 },
{0x8124 ,0xfe },
{0x8125 ,0x08 },
{0x8126 ,0xe6 },
{0x8127 ,0xff },
{0x8128 ,0x78 },
{0x8129 ,0x80 },
{0x812a ,0xa6 },
{0x812b ,0x06 },
{0x812c ,0x08 },
{0x812d ,0xa6 },
{0x812e ,0x07 },
{0x812f ,0x78 },
{0x8130 ,0x4e },
{0x8131 ,0xe6 },
{0x8132 ,0xfe },
{0x8133 ,0x08 },
{0x8134 ,0xe6 },
{0x8135 ,0xff },
{0x8136 ,0x78 },
{0x8137 ,0x82 },
{0x8138 ,0xa6 },
{0x8139 ,0x06 },
{0x813a ,0x08 },
{0x813b ,0xa6 },
{0x813c ,0x07 },
{0x813d ,0x78 },
{0x813e ,0x6e },
{0x813f ,0xe6 },
{0x8140 ,0x78 },
{0x8141 ,0x8c },
{0x8142 ,0xf6 },
{0x8143 ,0x78 },
{0x8144 ,0x6e },
{0x8145 ,0xe6 },
{0x8146 ,0x78 },
{0x8147 ,0x8d },
{0x8148 ,0xf6 },
{0x8149 ,0x7f },
{0x814a ,0x01 },
{0x814b ,0x90 },
{0x814c ,0x0e },
{0x814d ,0x93 },
{0x814e ,0xe4 },
{0x814f ,0x93 },
{0x8150 ,0xfe },
{0x8151 ,0xef },
{0x8152 ,0xc3 },
{0x8153 ,0x9e },
{0x8154 ,0x50 },
{0x8155 ,0x5f },
{0x8156 ,0xef },
{0x8157 ,0x25 },
{0x8158 ,0xe0 },
{0x8159 ,0x24 },
{0x815a ,0x4f },
{0x815b ,0xf9 },
{0x815c ,0xc3 },
{0x815d ,0x78 },
{0x815e ,0x81 },
{0x815f ,0xe6 },
{0x8160 ,0x97 },
{0x8161 ,0x18 },
{0x8162 ,0xe6 },
{0x8163 ,0x19 },
{0x8164 ,0x97 },
{0x8165 ,0x50 },
{0x8166 ,0x0a },
{0x8167 ,0x12 },
{0x8168 ,0x0c },
{0x8169 ,0x98 },
{0x816a ,0x78 },
{0x816b ,0x80 },
{0x816c ,0xa6 },
{0x816d ,0x04 },
{0x816e ,0x08 },
{0x816f ,0xa6 },
{0x8170 ,0x05 },
{0x8171 ,0x74 },
{0x8172 ,0x6e },
{0x8173 ,0x2f },
{0x8174 ,0xf9 },
{0x8175 ,0x78 },
{0x8176 ,0x8c },
{0x8177 ,0xe6 },
{0x8178 ,0xc3 },
{0x8179 ,0x97 },
{0x817a ,0x50 },
{0x817b ,0x08 },
{0x817c ,0x74 },
{0x817d ,0x6e },
{0x817e ,0x2f },
{0x817f ,0xf8 },
{0x8180 ,0xe6 },
{0x8181 ,0x78 },
{0x8182 ,0x8c },
{0x8183 ,0xf6 },
{0x8184 ,0xef },
{0x8185 ,0x25 },
{0x8186 ,0xe0 },
{0x8187 ,0x24 },
{0x8188 ,0x4f },
{0x8189 ,0xf9 },
{0x818a ,0xd3 },
{0x818b ,0x78 },
{0x818c ,0x83 },
{0x818d ,0xe6 },
{0x818e ,0x97 },
{0x818f ,0x18 },
{0x8190 ,0xe6 },
{0x8191 ,0x19 },
{0x8192 ,0x97 },
{0x8193 ,0x40 },
{0x8194 ,0x0a },
{0x8195 ,0x12 },
{0x8196 ,0x0c },
{0x8197 ,0x98 },
{0x8198 ,0x78 },
{0x8199 ,0x82 },
{0x819a ,0xa6 },
{0x819b ,0x04 },
{0x819c ,0x08 },
{0x819d ,0xa6 },
{0x819e ,0x05 },
{0x819f ,0x74 },
{0x81a0 ,0x6e },
{0x81a1 ,0x2f },
{0x81a2 ,0xf9 },
{0x81a3 ,0x78 },
{0x81a4 ,0x8d },
{0x81a5 ,0xe6 },
{0x81a6 ,0xd3 },
{0x81a7 ,0x97 },
{0x81a8 ,0x40 },
{0x81a9 ,0x08 },
{0x81aa ,0x74 },
{0x81ab ,0x6e },
{0x81ac ,0x2f },
{0x81ad ,0xf8 },
{0x81ae ,0xe6 },
{0x81af ,0x78 },
{0x81b0 ,0x8d },
{0x81b1 ,0xf6 },
{0x81b2 ,0x0f },
{0x81b3 ,0x80 },
{0x81b4 ,0x96 },
{0x81b5 ,0xc3 },
{0x81b6 ,0x79 },
{0x81b7 ,0x81 },
{0x81b8 ,0xe7 },
{0x81b9 ,0x78 },
{0x81ba ,0x83 },
{0x81bb ,0x96 },
{0x81bc ,0xff },
{0x81bd ,0x19 },
{0x81be ,0xe7 },
{0x81bf ,0x18 },
{0x81c0 ,0x96 },
{0x81c1 ,0x78 },
{0x81c2 ,0x84 },
{0x81c3 ,0xf6 },
{0x81c4 ,0x08 },
{0x81c5 ,0xa6 },
{0x81c6 ,0x07 },
{0x81c7 ,0xc3 },
{0x81c8 ,0x79 },
{0x81c9 ,0x8c },
{0x81ca ,0xe7 },
{0x81cb ,0x78 },
{0x81cc ,0x8d },
{0x81cd ,0x96 },
{0x81ce ,0x08 },
{0x81cf ,0xf6 },
{0x81d0 ,0x12 },
{0x81d1 ,0x0c },
{0x81d2 ,0xa4 },
{0x81d3 ,0x40 },
{0x81d4 ,0x05 },
{0x81d5 ,0x09 },
{0x81d6 ,0xe7 },
{0x81d7 ,0x08 },
{0x81d8 ,0x80 },
{0x81d9 ,0x06 },
{0x81da ,0xc3 },
{0x81db ,0x79 },
{0x81dc ,0x7f },
{0x81dd ,0xe7 },
{0x81de ,0x78 },
{0x81df ,0x81 },
{0x81e0 ,0x96 },
{0x81e1 ,0xff },
{0x81e2 ,0x19 },
{0x81e3 ,0xe7 },
{0x81e4 ,0x18 },
{0x81e5 ,0x96 },
{0x81e6 ,0xfe },
{0x81e7 ,0x78 },
{0x81e8 ,0x86 },
{0x81e9 ,0xa6 },
{0x81ea ,0x06 },
{0x81eb ,0x08 },
{0x81ec ,0xa6 },
{0x81ed ,0x07 },
{0x81ee ,0x79 },
{0x81ef ,0x8c },
{0x81f0 ,0xe7 },
{0x81f1 ,0xd3 },
{0x81f2 ,0x78 },
{0x81f3 ,0x8b },
{0x81f4 ,0x96 },
{0x81f5 ,0x40 },
{0x81f6 ,0x05 },
{0x81f7 ,0xe7 },
{0x81f8 ,0x96 },
{0x81f9 ,0xff },
{0x81fa ,0x80 },
{0x81fb ,0x08 },
{0x81fc ,0xc3 },
{0x81fd ,0x79 },
{0x81fe ,0x8b },
{0x81ff ,0xe7 },
{0x8200 ,0x78 },
{0x8201 ,0x8c },
{0x8202 ,0x96 },
{0x8203 ,0xff },
{0x8204 ,0x78 },
{0x8205 ,0x8f },
{0x8206 ,0xa6 },
{0x8207 ,0x07 },
{0x8208 ,0xe5 },
{0x8209 ,0x1f },
{0x820a ,0x64 },
{0x820b ,0x02 },
{0x820c ,0x60 },
{0x820d ,0x03 },
{0x820e ,0x02 },
{0x820f ,0x02 },
{0x8210 ,0x92 },
{0x8211 ,0x90 },
{0x8212 ,0x0e },
{0x8213 ,0x91 },
{0x8214 ,0x93 },
{0x8215 ,0xff },
{0x8216 ,0x18 },
{0x8217 ,0xe6 },
{0x8218 ,0xc3 },
{0x8219 ,0x9f },
{0x821a ,0x40 },
{0x821b ,0x03 },
{0x821c ,0x02 },
{0x821d ,0x02 },
{0x821e ,0xa6 },
{0x821f ,0x78 },
{0x8220 ,0x84 },
{0x8221 ,0x12 },
{0x8222 ,0x0c },
{0x8223 ,0x89 },
{0x8224 ,0x12 },
{0x8225 ,0x0c },
{0x8226 ,0x5e },
{0x8227 ,0x90 },
{0x8228 ,0x0e },
{0x8229 ,0x8e },
{0x822a ,0x12 },
{0x822b ,0x0c },
{0x822c ,0x77 },
{0x822d ,0x78 },
{0x822e ,0x80 },
{0x822f ,0xe6 },
{0x8230 ,0xfe },
{0x8231 ,0x08 },
{0x8232 ,0xe6 },
{0x8233 ,0xff },
{0x8234 ,0x12 },
{0x8235 ,0x0c },
{0x8236 ,0xba },
{0x8237 ,0x7b },
{0x8238 ,0x04 },
{0x8239 ,0x12 },
{0x823a ,0x0c },
{0x823b ,0x4c },
{0x823c ,0xc3 },
{0x823d ,0x12 },
{0x823e ,0x06 },
{0x823f ,0xa6 },
{0x8240 ,0x50 },
{0x8241 ,0x64 },
{0x8242 ,0x90 },
{0x8243 ,0x0e },
{0x8244 ,0x92 },
{0x8245 ,0xe4 },
{0x8246 ,0x93 },
{0x8247 ,0xff },
{0x8248 ,0x78 },
{0x8249 ,0x8f },
{0x824a ,0xe6 },
{0x824b ,0x9f },
{0x824c ,0x40 },
{0x824d ,0x02 },
{0x824e ,0x80 },
{0x824f ,0x11 },
{0x8250 ,0x90 },
{0x8251 ,0x0e },
{0x8252 ,0x90 },
{0x8253 ,0xe4 },
{0x8254 ,0x93 },
{0x8255 ,0xff },
{0x8256 ,0xd3 },
{0x8257 ,0x78 },
{0x8258 ,0x89 },
{0x8259 ,0xe6 },
{0x825a ,0x9f },
{0x825b ,0x18 },
{0x825c ,0xe6 },
{0x825d ,0x94 },
{0x825e ,0x00 },
{0x825f ,0x40 },
{0x8260 ,0x03 },
{0x8261 ,0x75 },
{0x8262 ,0x1f },
{0x8263 ,0x05 },
{0x8264 ,0x78 },
{0x8265 ,0x86 },
{0x8266 ,0x12 },
{0x8267 ,0x0c },
{0x8268 ,0x89 },
{0x8269 ,0x12 },
{0x826a ,0x0c },
{0x826b ,0x5e },
{0x826c ,0x90 },
{0x826d ,0x0e },
{0x826e ,0x8f },
{0x826f ,0x12 },
{0x8270 ,0x0c },
{0x8271 ,0x77 },
{0x8272 ,0x12 },
{0x8273 ,0x0c },
{0x8274 ,0xa4 },
{0x8275 ,0x40 },
{0x8276 ,0x02 },
{0x8277 ,0x80 },
{0x8278 ,0x02 },
{0x8279 ,0x78 },
{0x827a ,0x80 },
{0x827b ,0xe6 },
{0x827c ,0xfe },
{0x827d ,0x08 },
{0x827e ,0xe6 },
{0x827f ,0xff },
{0x8280 ,0x12 },
{0x8281 ,0x0c },
{0x8282 ,0xba },
{0x8283 ,0x7b },
{0x8284 ,0x10 },
{0x8285 ,0x12 },
{0x8286 ,0x0c },
{0x8287 ,0x4c },
{0x8288 ,0xd3 },
{0x8289 ,0x12 },
{0x828a ,0x06 },
{0x828b ,0xa6 },
{0x828c ,0x40 },
{0x828d ,0x18 },
{0x828e ,0x75 },
{0x828f ,0x1f },
{0x8290 ,0x05 },
{0x8291 ,0x22 },
{0x8292 ,0xe5 },
{0x8293 ,0x1f },
{0x8294 ,0xb4 },
{0x8295 ,0x05 },
{0x8296 ,0x0f },
{0x8297 ,0xd2 },
{0x8298 ,0x01 },
{0x8299 ,0xc2 },
{0x829a ,0x02 },
{0x829b ,0xe4 },
{0x829c ,0xf5 },
{0x829d ,0x1f },
{0x829e ,0xf5 },
{0x829f ,0x1e },
{0x82a0 ,0xd2 },
{0x82a1 ,0x35 },
{0x82a2 ,0xd2 },
{0x82a3 ,0x33 },
{0x82a4 ,0xd2 },
{0x82a5 ,0x36 },
{0x82a6 ,0x22 },
{0x82a7 ,0xe5 },
{0x82a8 ,0x1f },
{0x82a9 ,0x70 },
{0x82aa ,0x72 },
{0x82ab ,0xf5 },
{0x82ac ,0x1e },
{0x82ad ,0xd2 },
{0x82ae ,0x35 },
{0x82af ,0xff },
{0x82b0 ,0xef },
{0x82b1 ,0x25 },
{0x82b2 ,0xe0 },
{0x82b3 ,0x24 },
{0x82b4 ,0x4e },
{0x82b5 ,0xf8 },
{0x82b6 ,0xe4 },
{0x82b7 ,0xf6 },
{0x82b8 ,0x08 },
{0x82b9 ,0xf6 },
{0x82ba ,0x0f },
{0x82bb ,0xbf },
{0x82bc ,0x34 },
{0x82bd ,0xf2 },
{0x82be ,0x90 },
{0x82bf ,0x0e },
{0x82c0 ,0x94 },
{0x82c1 ,0xe4 },
{0x82c2 ,0x93 },
{0x82c3 ,0xff },
{0x82c4 ,0xe5 },
{0x82c5 ,0x4b },
{0x82c6 ,0xc3 },
{0x82c7 ,0x9f },
{0x82c8 ,0x50 },
{0x82c9 ,0x04 },
{0x82ca ,0x7f },
{0x82cb ,0x05 },
{0x82cc ,0x80 },
{0x82cd ,0x02 },
{0x82ce ,0x7f },
{0x82cf ,0xfb },
{0x82d0 ,0x78 },
{0x82d1 ,0xbd },
{0x82d2 ,0xa6 },
{0x82d3 ,0x07 },
{0x82d4 ,0x12 },
{0x82d5 ,0x0e },
{0x82d6 ,0xb1 },
{0x82d7 ,0x40 },
{0x82d8 ,0x04 },
{0x82d9 ,0x7f },
{0x82da ,0x03 },
{0x82db ,0x80 },
{0x82dc ,0x02 },
{0x82dd ,0x7f },
{0x82de ,0x30 },
{0x82df ,0x78 },
{0x82e0 ,0xbc },
{0x82e1 ,0xa6 },
{0x82e2 ,0x07 },
{0x82e3 ,0xe6 },
{0x82e4 ,0x18 },
{0x82e5 ,0xf6 },
{0x82e6 ,0x08 },
{0x82e7 ,0xe6 },
{0x82e8 ,0x78 },
{0x82e9 ,0xb9 },
{0x82ea ,0xf6 },
{0x82eb ,0x78 },
{0x82ec ,0xbc },
{0x82ed ,0xe6 },
{0x82ee ,0x78 },
{0x82ef ,0xba },
{0x82f0 ,0xf6 },
{0x82f1 ,0x78 },
{0x82f2 ,0xbf },
{0x82f3 ,0x76 },
{0x82f4 ,0x33 },
{0x82f5 ,0xe4 },
{0x82f6 ,0x08 },
{0x82f7 ,0xf6 },
{0x82f8 ,0x78 },
{0x82f9 ,0xb8 },
{0x82fa ,0x76 },
{0x82fb ,0x01 },
{0x82fc ,0x75 },
{0x82fd ,0x4a },
{0x82fe ,0x02 },
{0x82ff ,0x78 },
{0x8300 ,0xb6 },
{0x8301 ,0xf6 },
{0x8302 ,0x08 },
{0x8303 ,0xf6 },
{0x8304 ,0x74 },
{0x8305 ,0xff },
{0x8306 ,0x78 },
{0x8307 ,0xc1 },
{0x8308 ,0xf6 },
{0x8309 ,0x08 },
{0x830a ,0xf6 },
{0x830b ,0x75 },
{0x830c ,0x1f },
{0x830d ,0x01 },
{0x830e ,0x78 },
{0x830f ,0xbc },
{0x8310 ,0xe6 },
{0x8311 ,0x75 },
{0x8312 ,0xf0 },
{0x8313 ,0x05 },
{0x8314 ,0xa4 },
{0x8315 ,0xf5 },
{0x8316 ,0x4b },
{0x8317 ,0x12 },
{0x8318 ,0x0b },
{0x8319 ,0x39 },
{0x831a ,0xc2 },
{0x831b ,0x37 },
{0x831c ,0x22 },
{0x831d ,0x78 },
{0x831e ,0xb8 },
{0x831f ,0xe6 },
{0x8320 ,0xd3 },
{0x8321 ,0x94 },
{0x8322 ,0x00 },
{0x8323 ,0x40 },
{0x8324 ,0x02 },
{0x8325 ,0x16 },
{0x8326 ,0x22 },
{0x8327 ,0xe5 },
{0x8328 ,0x1f },
{0x8329 ,0xb4 },
{0x832a ,0x05 },
{0x832b ,0x23 },
{0x832c ,0xe4 },
{0x832d ,0xf5 },
{0x832e ,0x1f },
{0x832f ,0xc2 },
{0x8330 ,0x01 },
{0x8331 ,0x78 },
{0x8332 ,0xb6 },
{0x8333 ,0xe6 },
{0x8334 ,0xfe },
{0x8335 ,0x08 },
{0x8336 ,0xe6 },
{0x8337 ,0xff },
{0x8338 ,0x78 },
{0x8339 ,0x4e },
{0x833a ,0xa6 },
{0x833b ,0x06 },
{0x833c ,0x08 },
{0x833d ,0xa6 },
{0x833e ,0x07 },
{0x833f ,0xa2 },
{0x8340 ,0x37 },
{0x8341 ,0xe4 },
{0x8342 ,0x33 },
{0x8343 ,0xf5 },
{0x8344 ,0x3c },
{0x8345 ,0x90 },
{0x8346 ,0x30 },
{0x8347 ,0x28 },
{0x8348 ,0xf0 },
{0x8349 ,0x75 },
{0x834a ,0x1e },
{0x834b ,0x10 },
{0x834c ,0xd2 },
{0x834d ,0x35 },
{0x834e ,0x22 },
{0x834f ,0xe5 },
{0x8350 ,0x4b },
{0x8351 ,0x75 },
{0x8352 ,0xf0 },
{0x8353 ,0x05 },
{0x8354 ,0x84 },
{0x8355 ,0x78 },
{0x8356 ,0xbc },
{0x8357 ,0xf6 },
{0x8358 ,0x90 },
{0x8359 ,0x0e },
{0x835a ,0x8c },
{0x835b ,0xe4 },
{0x835c ,0x93 },
{0x835d ,0xff },
{0x835e ,0x25 },
{0x835f ,0xe0 },
{0x8360 ,0x24 },
{0x8361 ,0x0a },
{0x8362 ,0xf8 },
{0x8363 ,0xe6 },
{0x8364 ,0xfc },
{0x8365 ,0x08 },
{0x8366 ,0xe6 },
{0x8367 ,0xfd },
{0x8368 ,0x78 },
{0x8369 ,0xbc },
{0x836a ,0xe6 },
{0x836b ,0x25 },
{0x836c ,0xe0 },
{0x836d ,0x24 },
{0x836e ,0x4e },
{0x836f ,0xf8 },
{0x8370 ,0xa6 },
{0x8371 ,0x04 },
{0x8372 ,0x08 },
{0x8373 ,0xa6 },
{0x8374 ,0x05 },
{0x8375 ,0xef },
{0x8376 ,0x12 },
{0x8377 ,0x0e },
{0x8378 ,0xf5 },
{0x8379 ,0xd3 },
{0x837a ,0x78 },
{0x837b ,0xb7 },
{0x837c ,0x96 },
{0x837d ,0xee },
{0x837e ,0x18 },
{0x837f ,0x96 },
{0x8380 ,0x40 },
{0x8381 ,0x0d },
{0x8382 ,0x78 },
{0x8383 ,0xbc },
{0x8384 ,0xe6 },
{0x8385 ,0x78 },
{0x8386 ,0xb9 },
{0x8387 ,0xf6 },
{0x8388 ,0x78 },
{0x8389 ,0xb6 },
{0x838a ,0xa6 },
{0x838b ,0x06 },
{0x838c ,0x08 },
{0x838d ,0xa6 },
{0x838e ,0x07 },
{0x838f ,0x90 },
{0x8390 ,0x0e },
{0x8391 ,0x8c },
{0x8392 ,0xe4 },
{0x8393 ,0x93 },
{0x8394 ,0x12 },
{0x8395 ,0x0e },
{0x8396 ,0xf5 },
{0x8397 ,0xc3 },
{0x8398 ,0x78 },
{0x8399 ,0xc2 },
{0x839a ,0x96 },
{0x839b ,0xee },
{0x839c ,0x18 },
{0x839d ,0x96 },
{0x839e ,0x50 },
{0x839f ,0x0d },
{0x83a0 ,0x78 },
{0x83a1 ,0xbc },
{0x83a2 ,0xe6 },
{0x83a3 ,0x78 },
{0x83a4 ,0xba },
{0x83a5 ,0xf6 },
{0x83a6 ,0x78 },
{0x83a7 ,0xc1 },
{0x83a8 ,0xa6 },
{0x83a9 ,0x06 },
{0x83aa ,0x08 },
{0x83ab ,0xa6 },
{0x83ac ,0x07 },
{0x83ad ,0x78 },
{0x83ae ,0xb6 },
{0x83af ,0xe6 },
{0x83b0 ,0xfe },
{0x83b1 ,0x08 },
{0x83b2 ,0xe6 },
{0x83b3 ,0xc3 },
{0x83b4 ,0x78 },
{0x83b5 ,0xc2 },
{0x83b6 ,0x96 },
{0x83b7 ,0xff },
{0x83b8 ,0xee },
{0x83b9 ,0x18 },
{0x83ba ,0x96 },
{0x83bb ,0x78 },
{0x83bc ,0xc3 },
{0x83bd ,0xf6 },
{0x83be ,0x08 },
{0x83bf ,0xa6 },
{0x83c0 ,0x07 },
{0x83c1 ,0x90 },
{0x83c2 ,0x0e },
{0x83c3 ,0x96 },
{0x83c4 ,0xe4 },
{0x83c5 ,0x18 },
{0x83c6 ,0x12 },
{0x83c7 ,0x0e },
{0x83c8 ,0xb8 },
{0x83c9 ,0x40 },
{0x83ca ,0x02 },
{0x83cb ,0xd2 },
{0x83cc ,0x37 },
{0x83cd ,0x78 },
{0x83ce ,0xbc },
{0x83cf ,0xe6 },
{0x83d0 ,0x08 },
{0x83d1 ,0x26 },
{0x83d2 ,0x08 },
{0x83d3 ,0xf6 },
{0x83d4 ,0xe5 },
{0x83d5 ,0x1f },
{0x83d6 ,0x64 },
{0x83d7 ,0x01 },
{0x83d8 ,0x70 },
{0x83d9 ,0x7a },
{0x83da ,0xe6 },
{0x83db ,0xc3 },
{0x83dc ,0x78 },
{0x83dd ,0xc0 },
{0x83de ,0x12 },
{0x83df ,0x0e },
{0x83e0 ,0xa1 },
{0x83e1 ,0x40 },
{0x83e2 ,0x08 },
{0x83e3 ,0x12 },
{0x83e4 ,0x0e },
{0x83e5 ,0x9c },
{0x83e6 ,0x50 },
{0x83e7 ,0x03 },
{0x83e8 ,0x02 },
{0x83e9 ,0x04 },
{0x83ea ,0xf1 },
{0x83eb ,0x12 },
{0x83ec ,0x0e },
{0x83ed ,0xaf },
{0x83ee ,0x40 },
{0x83ef ,0x04 },
{0x83f0 ,0x7f },
{0x83f1 ,0xfe },
{0x83f2 ,0x80 },
{0x83f3 ,0x02 },
{0x83f4 ,0x7f },
{0x83f5 ,0x02 },
{0x83f6 ,0x78 },
{0x83f7 ,0xbd },
{0x83f8 ,0xa6 },
{0x83f9 ,0x07 },
{0x83fa ,0x78 },
{0x83fb ,0xb9 },
{0x83fc ,0xe6 },
{0x83fd ,0x24 },
{0x83fe ,0x03 },
{0x83ff ,0x78 },
{0x8400 ,0xbf },
{0x8401 ,0xf6 },
{0x8402 ,0x78 },
{0x8403 ,0xb9 },
{0x8404 ,0xe6 },
{0x8405 ,0x24 },
{0x8406 ,0xfd },
{0x8407 ,0x78 },
{0x8408 ,0xc0 },
{0x8409 ,0xf6 },
{0x840a ,0x18 },
{0x840b ,0x12 },
{0x840c ,0x0e },
{0x840d ,0xb1 },
{0x840e ,0x40 },
{0x840f ,0x04 },
{0x8410 ,0xe6 },
{0x8411 ,0xff },
{0x8412 ,0x80 },
{0x8413 ,0x02 },
{0x8414 ,0x7f },
{0x8415 ,0x00 },
{0x8416 ,0x12 },
{0x8417 ,0x0e },
{0x8418 ,0xd1 },
{0x8419 ,0x40 },
{0x841a ,0x04 },
{0x841b ,0xe6 },
{0x841c ,0xff },
{0x841d ,0x80 },
{0x841e ,0x02 },
{0x841f ,0x7f },
{0x8420 ,0x00 },
{0x8421 ,0x12 },
{0x8422 ,0x0e },
{0x8423 ,0xdd },
{0x8424 ,0x50 },
{0x8425 ,0x04 },
{0x8426 ,0xe6 },
{0x8427 ,0xff },
{0x8428 ,0x80 },
{0x8429 ,0x02 },
{0x842a ,0x7f },
{0x842b ,0x33 },
{0x842c ,0x12 },
{0x842d ,0x0e },
{0x842e ,0xe9 },
{0x842f ,0x50 },
{0x8430 ,0x04 },
{0x8431 ,0xe6 },
{0x8432 ,0xff },
{0x8433 ,0x80 },
{0x8434 ,0x02 },
{0x8435 ,0x7f },
{0x8436 ,0x33 },
{0x8437 ,0x12 },
{0x8438 ,0x0e },
{0x8439 ,0xab },
{0x843a ,0x40 },
{0x843b ,0x06 },
{0x843c ,0x78 },
{0x843d ,0xc0 },
{0x843e ,0xe6 },
{0x843f ,0xff },
{0x8440 ,0x80 },
{0x8441 ,0x04 },
{0x8442 ,0x78 },
{0x8443 ,0xbf },
{0x8444 ,0xe6 },
{0x8445 ,0xff },
{0x8446 ,0x78 },
{0x8447 ,0xbe },
{0x8448 ,0xa6 },
{0x8449 ,0x07 },
{0x844a ,0x75 },
{0x844b ,0x1f },
{0x844c ,0x02 },
{0x844d ,0x78 },
{0x844e ,0xb8 },
{0x844f ,0x76 },
{0x8450 ,0x01 },
{0x8451 ,0x02 },
{0x8452 ,0x04 },
{0x8453 ,0xf1 },
{0x8454 ,0xe5 },
{0x8455 ,0x1f },
{0x8456 ,0x64 },
{0x8457 ,0x02 },
{0x8458 ,0x70 },
{0x8459 ,0x77 },
{0x845a ,0x78 },
{0x845b ,0xbe },
{0x845c ,0xe6 },
{0x845d ,0xff },
{0x845e ,0xc3 },
{0x845f ,0x78 },
{0x8460 ,0xc0 },
{0x8461 ,0x12 },
{0x8462 ,0x0e },
{0x8463 ,0xa2 },
{0x8464 ,0x40 },
{0x8465 ,0x05 },
{0x8466 ,0x12 },
{0x8467 ,0x0e },
{0x8468 ,0x9c },
{0x8469 ,0x40 },
{0x846a ,0x64 },
{0x846b ,0x12 },
{0x846c ,0x0e },
{0x846d ,0xaf },
{0x846e ,0x40 },
{0x846f ,0x04 },
{0x8470 ,0x7f },
{0x8471 ,0xff },
{0x8472 ,0x80 },
{0x8473 ,0x02 },
{0x8474 ,0x7f },
{0x8475 ,0x01 },
{0x8476 ,0x78 },
{0x8477 ,0xbd },
{0x8478 ,0xa6 },
{0x8479 ,0x07 },
{0x847a ,0x78 },
{0x847b ,0xb9 },
{0x847c ,0xe6 },
{0x847d ,0x04 },
{0x847e ,0x78 },
{0x847f ,0xbf },
{0x8480 ,0xf6 },
{0x8481 ,0x78 },
{0x8482 ,0xb9 },
{0x8483 ,0xe6 },
{0x8484 ,0x14 },
{0x8485 ,0x78 },
{0x8486 ,0xc0 },
{0x8487 ,0xf6 },
{0x8488 ,0x18 },
{0x8489 ,0x12 },
{0x848a ,0x0e },
{0x848b ,0xd6 },
{0x848c ,0x40 },
{0x848d ,0x04 },
{0x848e ,0xe6 },
{0x848f ,0xff },
{0x8490 ,0x80 },
{0x8491 ,0x02 },
{0x8492 ,0x7f },
{0x8493 ,0x00 },
{0x8494 ,0x12 },
{0x8495 ,0x0e },
{0x8496 ,0xd1 },
{0x8497 ,0x40 },
{0x8498 ,0x04 },
{0x8499 ,0xe6 },
{0x849a ,0xff },
{0x849b ,0x80 },
{0x849c ,0x02 },
{0x849d ,0x7f },
{0x849e ,0x00 },
{0x849f ,0x12 },
{0x84a0 ,0x0e },
{0x84a1 ,0xdd },
{0x84a2 ,0x50 },
{0x84a3 ,0x04 },
{0x84a4 ,0xe6 },
{0x84a5 ,0xff },
{0x84a6 ,0x80 },
{0x84a7 ,0x02 },
{0x84a8 ,0x7f },
{0x84a9 ,0x33 },
{0x84aa ,0x12 },
{0x84ab ,0x0e },
{0x84ac ,0xe9 },
{0x84ad ,0x50 },
{0x84ae ,0x04 },
{0x84af ,0xe6 },
{0x84b0 ,0xff },
{0x84b1 ,0x80 },
{0x84b2 ,0x02 },
{0x84b3 ,0x7f },
{0x84b4 ,0x33 },
{0x84b5 ,0x12 },
{0x84b6 ,0x0e },
{0x84b7 ,0xab },
{0x84b8 ,0x40 },
{0x84b9 ,0x06 },
{0x84ba ,0x78 },
{0x84bb ,0xc0 },
{0x84bc ,0xe6 },
{0x84bd ,0xff },
{0x84be ,0x80 },
{0x84bf ,0x04 },
{0x84c0 ,0x78 },
{0x84c1 ,0xbf },
{0x84c2 ,0xe6 },
{0x84c3 ,0xff },
{0x84c4 ,0x78 },
{0x84c5 ,0xbe },
{0x84c6 ,0xa6 },
{0x84c7 ,0x07 },
{0x84c8 ,0x75 },
{0x84c9 ,0x1f },
{0x84ca ,0x03 },
{0x84cb ,0x78 },
{0x84cc ,0xb8 },
{0x84cd ,0x76 },
{0x84ce ,0x01 },
{0x84cf ,0x80 },
{0x84d0 ,0x20 },
{0x84d1 ,0xe5 },
{0x84d2 ,0x1f },
{0x84d3 ,0x64 },
{0x84d4 ,0x03 },
{0x84d5 ,0x70 },
{0x84d6 ,0x26 },
{0x84d7 ,0x78 },
{0x84d8 ,0xbe },
{0x84d9 ,0xe6 },
{0x84da ,0xff },
{0x84db ,0xc3 },
{0x84dc ,0x78 },
{0x84dd ,0xc0 },
{0x84de ,0x12 },
{0x84df ,0x0e },
{0x84e0 ,0xa2 },
{0x84e1 ,0x40 },
{0x84e2 ,0x05 },
{0x84e3 ,0x12 },
{0x84e4 ,0x0e },
{0x84e5 ,0x9c },
{0x84e6 ,0x40 },
{0x84e7 ,0x09 },
{0x84e8 ,0x78 },
{0x84e9 ,0xb9 },
{0x84ea ,0xe6 },
{0x84eb ,0x78 },
{0x84ec ,0xbe },
{0x84ed ,0xf6 },
{0x84ee ,0x75 },
{0x84ef ,0x1f },
{0x84f0 ,0x04 },
{0x84f1 ,0x78 },
{0x84f2 ,0xbe },
{0x84f3 ,0xe6 },
{0x84f4 ,0x75 },
{0x84f5 ,0xf0 },
{0x84f6 ,0x05 },
{0x84f7 ,0xa4 },
{0x84f8 ,0xf5 },
{0x84f9 ,0x4b },
{0x84fa ,0x02 },
{0x84fb ,0x0b },
{0x84fc ,0x39 },
{0x84fd ,0xe5 },
{0x84fe ,0x1f },
{0x84ff ,0x64 },
{0x8500 ,0x04 },
{0x8501 ,0x70 },
{0x8502 ,0x1e },
{0x8503 ,0x90 },
{0x8504 ,0x0e },
{0x8505 ,0x95 },
{0x8506 ,0x78 },
{0x8507 ,0xc3 },
{0x8508 ,0x12 },
{0x8509 ,0x0e },
{0x850a ,0xb8 },
{0x850b ,0x40 },
{0x850c ,0x04 },
{0x850d ,0xd2 },
{0x850e ,0x37 },
{0x850f ,0x80 },
{0x8510 ,0x0d },
{0x8511 ,0x90 },
{0x8512 ,0x0e },
{0x8513 ,0x97 },
{0x8514 ,0xe4 },
{0x8515 ,0x93 },
{0x8516 ,0xff },
{0x8517 ,0x60 },
{0x8518 ,0x05 },
{0x8519 ,0xf5 },
{0x851a ,0x4b },
{0x851b ,0x12 },
{0x851c ,0x0b },
{0x851d ,0x39 },
{0x851e ,0x75 },
{0x851f ,0x1f },
{0x8520 ,0x05 },
{0x8521 ,0x22 },
{0x8522 ,0xef },
{0x8523 ,0x8d },
{0x8524 ,0xf0 },
{0x8525 ,0xa4 },
{0x8526 ,0xa8 },
{0x8527 ,0xf0 },
{0x8528 ,0xcf },
{0x8529 ,0x8c },
{0x852a ,0xf0 },
{0x852b ,0xa4 },
{0x852c ,0x28 },
{0x852d ,0xce },
{0x852e ,0x8d },
{0x852f ,0xf0 },
{0x8530 ,0xa4 },
{0x8531 ,0x2e },
{0x8532 ,0xfe },
{0x8533 ,0x22 },
{0x8534 ,0xbc },
{0x8535 ,0x00 },
{0x8536 ,0x0b },
{0x8537 ,0xbe },
{0x8538 ,0x00 },
{0x8539 ,0x29 },
{0x853a ,0xef },
{0x853b ,0x8d },
{0x853c ,0xf0 },
{0x853d ,0x84 },
{0x853e ,0xff },
{0x853f ,0xad },
{0x8540 ,0xf0 },
{0x8541 ,0x22 },
{0x8542 ,0xe4 },
{0x8543 ,0xcc },
{0x8544 ,0xf8 },
{0x8545 ,0x75 },
{0x8546 ,0xf0 },
{0x8547 ,0x08 },
{0x8548 ,0xef },
{0x8549 ,0x2f },
{0x854a ,0xff },
{0x854b ,0xee },
{0x854c ,0x33 },
{0x854d ,0xfe },
{0x854e ,0xec },
{0x854f ,0x33 },
{0x8550 ,0xfc },
{0x8551 ,0xee },
{0x8552 ,0x9d },
{0x8553 ,0xec },
{0x8554 ,0x98 },
{0x8555 ,0x40 },
{0x8556 ,0x05 },
{0x8557 ,0xfc },
{0x8558 ,0xee },
{0x8559 ,0x9d },
{0x855a ,0xfe },
{0x855b ,0x0f },
{0x855c ,0xd5 },
{0x855d ,0xf0 },
{0x855e ,0xe9 },
{0x855f ,0xe4 },
{0x8560 ,0xce },
{0x8561 ,0xfd },
{0x8562 ,0x22 },
{0x8563 ,0xed },
{0x8564 ,0xf8 },
{0x8565 ,0xf5 },
{0x8566 ,0xf0 },
{0x8567 ,0xee },
{0x8568 ,0x84 },
{0x8569 ,0x20 },
{0x856a ,0xd2 },
{0x856b ,0x1c },
{0x856c ,0xfe },
{0x856d ,0xad },
{0x856e ,0xf0 },
{0x856f ,0x75 },
{0x8570 ,0xf0 },
{0x8571 ,0x08 },
{0x8572 ,0xef },
{0x8573 ,0x2f },
{0x8574 ,0xff },
{0x8575 ,0xed },
{0x8576 ,0x33 },
{0x8577 ,0xfd },
{0x8578 ,0x40 },
{0x8579 ,0x07 },
{0x857a ,0x98 },
{0x857b ,0x50 },
{0x857c ,0x06 },
{0x857d ,0xd5 },
{0x857e ,0xf0 },
{0x857f ,0xf2 },
{0x8580 ,0x22 },
{0x8581 ,0xc3 },
{0x8582 ,0x98 },
{0x8583 ,0xfd },
{0x8584 ,0x0f },
{0x8585 ,0xd5 },
{0x8586 ,0xf0 },
{0x8587 ,0xea },
{0x8588 ,0x22 },
{0x8589 ,0xe8 },
{0x858a ,0x8f },
{0x858b ,0xf0 },
{0x858c ,0xa4 },
{0x858d ,0xcc },
{0x858e ,0x8b },
{0x858f ,0xf0 },
{0x8590 ,0xa4 },
{0x8591 ,0x2c },
{0x8592 ,0xfc },
{0x8593 ,0xe9 },
{0x8594 ,0x8e },
{0x8595 ,0xf0 },
{0x8596 ,0xa4 },
{0x8597 ,0x2c },
{0x8598 ,0xfc },
{0x8599 ,0x8a },
{0x859a ,0xf0 },
{0x859b ,0xed },
{0x859c ,0xa4 },
{0x859d ,0x2c },
{0x859e ,0xfc },
{0x859f ,0xea },
{0x85a0 ,0x8e },
{0x85a1 ,0xf0 },
{0x85a2 ,0xa4 },
{0x85a3 ,0xcd },
{0x85a4 ,0xa8 },
{0x85a5 ,0xf0 },
{0x85a6 ,0x8b },
{0x85a7 ,0xf0 },
{0x85a8 ,0xa4 },
{0x85a9 ,0x2d },
{0x85aa ,0xcc },
{0x85ab ,0x38 },
{0x85ac ,0x25 },
{0x85ad ,0xf0 },
{0x85ae ,0xfd },
{0x85af ,0xe9 },
{0x85b0 ,0x8f },
{0x85b1 ,0xf0 },
{0x85b2 ,0xa4 },
{0x85b3 ,0x2c },
{0x85b4 ,0xcd },
{0x85b5 ,0x35 },
{0x85b6 ,0xf0 },
{0x85b7 ,0xfc },
{0x85b8 ,0xeb },
{0x85b9 ,0x8e },
{0x85ba ,0xf0 },
{0x85bb ,0xa4 },
{0x85bc ,0xfe },
{0x85bd ,0xa9 },
{0x85be ,0xf0 },
{0x85bf ,0xeb },
{0x85c0 ,0x8f },
{0x85c1 ,0xf0 },
{0x85c2 ,0xa4 },
{0x85c3 ,0xcf },
{0x85c4 ,0xc5 },
{0x85c5 ,0xf0 },
{0x85c6 ,0x2e },
{0x85c7 ,0xcd },
{0x85c8 ,0x39 },
{0x85c9 ,0xfe },
{0x85ca ,0xe4 },
{0x85cb ,0x3c },
{0x85cc ,0xfc },
{0x85cd ,0xea },
{0x85ce ,0xa4 },
{0x85cf ,0x2d },
{0x85d0 ,0xce },
{0x85d1 ,0x35 },
{0x85d2 ,0xf0 },
{0x85d3 ,0xfd },
{0x85d4 ,0xe4 },
{0x85d5 ,0x3c },
{0x85d6 ,0xfc },
{0x85d7 ,0x22 },
{0x85d8 ,0x75 },
{0x85d9 ,0xf0 },
{0x85da ,0x08 },
{0x85db ,0x75 },
{0x85dc ,0x82 },
{0x85dd ,0x00 },
{0x85de ,0xef },
{0x85df ,0x2f },
{0x85e0 ,0xff },
{0x85e1 ,0xee },
{0x85e2 ,0x33 },
{0x85e3 ,0xfe },
{0x85e4 ,0xcd },
{0x85e5 ,0x33 },
{0x85e6 ,0xcd },
{0x85e7 ,0xcc },
{0x85e8 ,0x33 },
{0x85e9 ,0xcc },
{0x85ea ,0xc5 },
{0x85eb ,0x82 },
{0x85ec ,0x33 },
{0x85ed ,0xc5 },
{0x85ee ,0x82 },
{0x85ef ,0x9b },
{0x85f0 ,0xed },
{0x85f1 ,0x9a },
{0x85f2 ,0xec },
{0x85f3 ,0x99 },
{0x85f4 ,0xe5 },
{0x85f5 ,0x82 },
{0x85f6 ,0x98 },
{0x85f7 ,0x40 },
{0x85f8 ,0x0c },
{0x85f9 ,0xf5 },
{0x85fa ,0x82 },
{0x85fb ,0xee },
{0x85fc ,0x9b },
{0x85fd ,0xfe },
{0x85fe ,0xed },
{0x85ff ,0x9a },
{0x8600 ,0xfd },
{0x8601 ,0xec },
{0x8602 ,0x99 },
{0x8603 ,0xfc },
{0x8604 ,0x0f },
{0x8605 ,0xd5 },
{0x8606 ,0xf0 },
{0x8607 ,0xd6 },
{0x8608 ,0xe4 },
{0x8609 ,0xce },
{0x860a ,0xfb },
{0x860b ,0xe4 },
{0x860c ,0xcd },
{0x860d ,0xfa },
{0x860e ,0xe4 },
{0x860f ,0xcc },
{0x8610 ,0xf9 },
{0x8611 ,0xa8 },
{0x8612 ,0x82 },
{0x8613 ,0x22 },
{0x8614 ,0xb8 },
{0x8615 ,0x00 },
{0x8616 ,0xc1 },
{0x8617 ,0xb9 },
{0x8618 ,0x00 },
{0x8619 ,0x59 },
{0x861a ,0xba },
{0x861b ,0x00 },
{0x861c ,0x2d },
{0x861d ,0xec },
{0x861e ,0x8b },
{0x861f ,0xf0 },
{0x8620 ,0x84 },
{0x8621 ,0xcf },
{0x8622 ,0xce },
{0x8623 ,0xcd },
{0x8624 ,0xfc },
{0x8625 ,0xe5 },
{0x8626 ,0xf0 },
{0x8627 ,0xcb },
{0x8628 ,0xf9 },
{0x8629 ,0x78 },
{0x862a ,0x18 },
{0x862b ,0xef },
{0x862c ,0x2f },
{0x862d ,0xff },
{0x862e ,0xee },
{0x862f ,0x33 },
{0x8630 ,0xfe },
{0x8631 ,0xed },
{0x8632 ,0x33 },
{0x8633 ,0xfd },
{0x8634 ,0xec },
{0x8635 ,0x33 },
{0x8636 ,0xfc },
{0x8637 ,0xeb },
{0x8638 ,0x33 },
{0x8639 ,0xfb },
{0x863a ,0x10 },
{0x863b ,0xd7 },
{0x863c ,0x03 },
{0x863d ,0x99 },
{0x863e ,0x40 },
{0x863f ,0x04 },
{0x8640 ,0xeb },
{0x8641 ,0x99 },
{0x8642 ,0xfb },
{0x8643 ,0x0f },
{0x8644 ,0xd8 },
{0x8645 ,0xe5 },
{0x8646 ,0xe4 },
{0x8647 ,0xf9 },
{0x8648 ,0xfa },
{0x8649 ,0x22 },
{0x864a ,0x78 },
{0x864b ,0x18 },
{0x864c ,0xef },
{0x864d ,0x2f },
{0x864e ,0xff },
{0x864f ,0xee },
{0x8650 ,0x33 },
{0x8651 ,0xfe },
{0x8652 ,0xed },
{0x8653 ,0x33 },
{0x8654 ,0xfd },
{0x8655 ,0xec },
{0x8656 ,0x33 },
{0x8657 ,0xfc },
{0x8658 ,0xc9 },
{0x8659 ,0x33 },
{0x865a ,0xc9 },
{0x865b ,0x10 },
{0x865c ,0xd7 },
{0x865d ,0x05 },
{0x865e ,0x9b },
{0x865f ,0xe9 },
{0x8660 ,0x9a },
{0x8661 ,0x40 },
{0x8662 ,0x07 },
{0x8663 ,0xec },
{0x8664 ,0x9b },
{0x8665 ,0xfc },
{0x8666 ,0xe9 },
{0x8667 ,0x9a },
{0x8668 ,0xf9 },
{0x8669 ,0x0f },
{0x866a ,0xd8 },
{0x866b ,0xe0 },
{0x866c ,0xe4 },
{0x866d ,0xc9 },
{0x866e ,0xfa },
{0x866f ,0xe4 },
{0x8670 ,0xcc },
{0x8671 ,0xfb },
{0x8672 ,0x22 },
{0x8673 ,0x75 },
{0x8674 ,0xf0 },
{0x8675 ,0x10 },
{0x8676 ,0xef },
{0x8677 ,0x2f },
{0x8678 ,0xff },
{0x8679 ,0xee },
{0x867a ,0x33 },
{0x867b ,0xfe },
{0x867c ,0xed },
{0x867d ,0x33 },
{0x867e ,0xfd },
{0x867f ,0xcc },
{0x8680 ,0x33 },
{0x8681 ,0xcc },
{0x8682 ,0xc8 },
{0x8683 ,0x33 },
{0x8684 ,0xc8 },
{0x8685 ,0x10 },
{0x8686 ,0xd7 },
{0x8687 ,0x07 },
{0x8688 ,0x9b },
{0x8689 ,0xec },
{0x868a ,0x9a },
{0x868b ,0xe8 },
{0x868c ,0x99 },
{0x868d ,0x40 },
{0x868e ,0x0a },
{0x868f ,0xed },
{0x8690 ,0x9b },
{0x8691 ,0xfd },
{0x8692 ,0xec },
{0x8693 ,0x9a },
{0x8694 ,0xfc },
{0x8695 ,0xe8 },
{0x8696 ,0x99 },
{0x8697 ,0xf8 },
{0x8698 ,0x0f },
{0x8699 ,0xd5 },
{0x869a ,0xf0 },
{0x869b ,0xda },
{0x869c ,0xe4 },
{0x869d ,0xcd },
{0x869e ,0xfb },
{0x869f ,0xe4 },
{0x86a0 ,0xcc },
{0x86a1 ,0xfa },
{0x86a2 ,0xe4 },
{0x86a3 ,0xc8 },
{0x86a4 ,0xf9 },
{0x86a5 ,0x22 },
{0x86a6 ,0xeb },
{0x86a7 ,0x9f },
{0x86a8 ,0xf5 },
{0x86a9 ,0xf0 },
{0x86aa ,0xea },
{0x86ab ,0x9e },
{0x86ac ,0x42 },
{0x86ad ,0xf0 },
{0x86ae ,0xe9 },
{0x86af ,0x9d },
{0x86b0 ,0x42 },
{0x86b1 ,0xf0 },
{0x86b2 ,0xe8 },
{0x86b3 ,0x9c },
{0x86b4 ,0x45 },
{0x86b5 ,0xf0 },
{0x86b6 ,0x22 },
{0x86b7 ,0xe8 },
{0x86b8 ,0x60 },
{0x86b9 ,0x0f },
{0x86ba ,0xec },
{0x86bb ,0xc3 },
{0x86bc ,0x13 },
{0x86bd ,0xfc },
{0x86be ,0xed },
{0x86bf ,0x13 },
{0x86c0 ,0xfd },
{0x86c1 ,0xee },
{0x86c2 ,0x13 },
{0x86c3 ,0xfe },
{0x86c4 ,0xef },
{0x86c5 ,0x13 },
{0x86c6 ,0xff },
{0x86c7 ,0xd8 },
{0x86c8 ,0xf1 },
{0x86c9 ,0x22 },
{0x86ca ,0xe8 },
{0x86cb ,0x60 },
{0x86cc ,0x0f },
{0x86cd ,0xef },
{0x86ce ,0xc3 },
{0x86cf ,0x33 },
{0x86d0 ,0xff },
{0x86d1 ,0xee },
{0x86d2 ,0x33 },
{0x86d3 ,0xfe },
{0x86d4 ,0xed },
{0x86d5 ,0x33 },
{0x86d6 ,0xfd },
{0x86d7 ,0xec },
{0x86d8 ,0x33 },
{0x86d9 ,0xfc },
{0x86da ,0xd8 },
{0x86db ,0xf1 },
{0x86dc ,0x22 },
{0x86dd ,0xe4 },
{0x86de ,0x93 },
{0x86df ,0xfc },
{0x86e0 ,0x74 },
{0x86e1 ,0x01 },
{0x86e2 ,0x93 },
{0x86e3 ,0xfd },
{0x86e4 ,0x74 },
{0x86e5 ,0x02 },
{0x86e6 ,0x93 },
{0x86e7 ,0xfe },
{0x86e8 ,0x74 },
{0x86e9 ,0x03 },
{0x86ea ,0x93 },
{0x86eb ,0xff },
{0x86ec ,0x22 },
{0x86ed ,0xe6 },
{0x86ee ,0xfb },
{0x86ef ,0x08 },
{0x86f0 ,0xe6 },
{0x86f1 ,0xf9 },
{0x86f2 ,0x08 },
{0x86f3 ,0xe6 },
{0x86f4 ,0xfa },
{0x86f5 ,0x08 },
{0x86f6 ,0xe6 },
{0x86f7 ,0xcb },
{0x86f8 ,0xf8 },
{0x86f9 ,0x22 },
{0x86fa ,0xec },
{0x86fb ,0xf6 },
{0x86fc ,0x08 },
{0x86fd ,0xed },
{0x86fe ,0xf6 },
{0x86ff ,0x08 },
{0x8700 ,0xee },
{0x8701 ,0xf6 },
{0x8702 ,0x08 },
{0x8703 ,0xef },
{0x8704 ,0xf6 },
{0x8705 ,0x22 },
{0x8706 ,0xa4 },
{0x8707 ,0x25 },
{0x8708 ,0x82 },
{0x8709 ,0xf5 },
{0x870a ,0x82 },
{0x870b ,0xe5 },
{0x870c ,0xf0 },
{0x870d ,0x35 },
{0x870e ,0x83 },
{0x870f ,0xf5 },
{0x8710 ,0x83 },
{0x8711 ,0x22 },
{0x8712 ,0xd0 },
{0x8713 ,0x83 },
{0x8714 ,0xd0 },
{0x8715 ,0x82 },
{0x8716 ,0xf8 },
{0x8717 ,0xe4 },
{0x8718 ,0x93 },
{0x8719 ,0x70 },
{0x871a ,0x12 },
{0x871b ,0x74 },
{0x871c ,0x01 },
{0x871d ,0x93 },
{0x871e ,0x70 },
{0x871f ,0x0d },
{0x8720 ,0xa3 },
{0x8721 ,0xa3 },
{0x8722 ,0x93 },
{0x8723 ,0xf8 },
{0x8724 ,0x74 },
{0x8725 ,0x01 },
{0x8726 ,0x93 },
{0x8727 ,0xf5 },
{0x8728 ,0x82 },
{0x8729 ,0x88 },
{0x872a ,0x83 },
{0x872b ,0xe4 },
{0x872c ,0x73 },
{0x872d ,0x74 },
{0x872e ,0x02 },
{0x872f ,0x93 },
{0x8730 ,0x68 },
{0x8731 ,0x60 },
{0x8732 ,0xef },
{0x8733 ,0xa3 },
{0x8734 ,0xa3 },
{0x8735 ,0xa3 },
{0x8736 ,0x80 },
{0x8737 ,0xdf },
{0x8738 ,0x90 },
{0x8739 ,0x38 },
{0x873a ,0x04 },
{0x873b ,0x78 },
{0x873c ,0x52 },
{0x873d ,0x12 },
{0x873e ,0x0b },
{0x873f ,0x0f },
{0x8740 ,0x90 },
{0x8741 ,0x38 },
{0x8742 ,0x00 },
{0x8743 ,0xe0 },
{0x8744 ,0xfe },
{0x8745 ,0xa3 },
{0x8746 ,0xe0 },
{0x8747 ,0xfd },
{0x8748 ,0xed },
{0x8749 ,0xff },
{0x874a ,0xc3 },
{0x874b ,0x12 },
{0x874c ,0x0a },
{0x874d ,0xb0 },
{0x874e ,0x90 },
{0x874f ,0x38 },
{0x8750 ,0x10 },
{0x8751 ,0x12 },
{0x8752 ,0x0a },
{0x8753 ,0xa4 },
{0x8754 ,0x90 },
{0x8755 ,0x38 },
{0x8756 ,0x06 },
{0x8757 ,0x78 },
{0x8758 ,0x54 },
{0x8759 ,0x12 },
{0x875a ,0x0b },
{0x875b ,0x0f },
{0x875c ,0x90 },
{0x875d ,0x38 },
{0x875e ,0x02 },
{0x875f ,0xe0 },
{0x8760 ,0xfe },
{0x8761 ,0xa3 },
{0x8762 ,0xe0 },
{0x8763 ,0xfd },
{0x8764 ,0xed },
{0x8765 ,0xff },
{0x8766 ,0xc3 },
{0x8767 ,0x12 },
{0x8768 ,0x0a },
{0x8769 ,0xb0 },
{0x876a ,0x90 },
{0x876b ,0x38 },
{0x876c ,0x12 },
{0x876d ,0x12 },
{0x876e ,0x0a },
{0x876f ,0xa4 },
{0x8770 ,0xa3 },
{0x8771 ,0xe0 },
{0x8772 ,0xb4 },
{0x8773 ,0x31 },
{0x8774 ,0x07 },
{0x8775 ,0x78 },
{0x8776 ,0x52 },
{0x8777 ,0x79 },
{0x8778 ,0x52 },
{0x8779 ,0x12 },
{0x877a ,0x0b },
{0x877b ,0x2f },
{0x877c ,0x90 },
{0x877d ,0x38 },
{0x877e ,0x14 },
{0x877f ,0xe0 },
{0x8780 ,0xb4 },
{0x8781 ,0x71 },
{0x8782 ,0x15 },
{0x8783 ,0x78 },
{0x8784 ,0x52 },
{0x8785 ,0xe6 },
{0x8786 ,0xfe },
{0x8787 ,0x08 },
{0x8788 ,0xe6 },
{0x8789 ,0x78 },
{0x878a ,0x02 },
{0x878b ,0xce },
{0x878c ,0xc3 },
{0x878d ,0x13 },
{0x878e ,0xce },
{0x878f ,0x13 },
{0x8790 ,0xd8 },
{0x8791 ,0xf9 },
{0x8792 ,0x79 },
{0x8793 ,0x53 },
{0x8794 ,0xf7 },
{0x8795 ,0xee },
{0x8796 ,0x19 },
{0x8797 ,0xf7 },
{0x8798 ,0x90 },
{0x8799 ,0x38 },
{0x879a ,0x15 },
{0x879b ,0xe0 },
{0x879c ,0xb4 },
{0x879d ,0x31 },
{0x879e ,0x07 },
{0x879f ,0x78 },
{0x87a0 ,0x54 },
{0x87a1 ,0x79 },
{0x87a2 ,0x54 },
{0x87a3 ,0x12 },
{0x87a4 ,0x0b },
{0x87a5 ,0x2f },
{0x87a6 ,0x90 },
{0x87a7 ,0x38 },
{0x87a8 ,0x15 },
{0x87a9 ,0xe0 },
{0x87aa ,0xb4 },
{0x87ab ,0x71 },
{0x87ac ,0x15 },
{0x87ad ,0x78 },
{0x87ae ,0x54 },
{0x87af ,0xe6 },
{0x87b0 ,0xfe },
{0x87b1 ,0x08 },
{0x87b2 ,0xe6 },
{0x87b3 ,0x78 },
{0x87b4 ,0x02 },
{0x87b5 ,0xce },
{0x87b6 ,0xc3 },
{0x87b7 ,0x13 },
{0x87b8 ,0xce },
{0x87b9 ,0x13 },
{0x87ba ,0xd8 },
{0x87bb ,0xf9 },
{0x87bc ,0x79 },
{0x87bd ,0x55 },
{0x87be ,0xf7 },
{0x87bf ,0xee },
{0x87c0 ,0x19 },
{0x87c1 ,0xf7 },
{0x87c2 ,0x79 },
{0x87c3 ,0x52 },
{0x87c4 ,0x12 },
{0x87c5 ,0x0a },
{0x87c6 ,0xeb },
{0x87c7 ,0x09 },
{0x87c8 ,0x12 },
{0x87c9 ,0x0a },
{0x87ca ,0xeb },
{0x87cb ,0xaf },
{0x87cc ,0x47 },
{0x87cd ,0x12 },
{0x87ce ,0x0a },
{0x87cf ,0xc4 },
{0x87d0 ,0xe5 },
{0x87d1 ,0x44 },
{0x87d2 ,0xfb },
{0x87d3 ,0x7a },
{0x87d4 ,0x00 },
{0x87d5 ,0xfd },
{0x87d6 ,0x7c },
{0x87d7 ,0x00 },
{0x87d8 ,0x12 },
{0x87d9 ,0x05 },
{0x87da ,0x34 },
{0x87db ,0x78 },
{0x87dc ,0x5a },
{0x87dd ,0xa6 },
{0x87de ,0x06 },
{0x87df ,0x08 },
{0x87e0 ,0xa6 },
{0x87e1 ,0x07 },
{0x87e2 ,0xaf },
{0x87e3 ,0x45 },
{0x87e4 ,0x12 },
{0x87e5 ,0x0a },
{0x87e6 ,0xc4 },
{0x87e7 ,0xad },
{0x87e8 ,0x03 },
{0x87e9 ,0x7c },
{0x87ea ,0x00 },
{0x87eb ,0x12 },
{0x87ec ,0x05 },
{0x87ed ,0x34 },
{0x87ee ,0x78 },
{0x87ef ,0x56 },
{0x87f0 ,0xa6 },
{0x87f1 ,0x06 },
{0x87f2 ,0x08 },
{0x87f3 ,0xa6 },
{0x87f4 ,0x07 },
{0x87f5 ,0xaf },
{0x87f6 ,0x48 },
{0x87f7 ,0x78 },
{0x87f8 ,0x54 },
{0x87f9 ,0x12 },
{0x87fa ,0x0a },
{0x87fb ,0xc6 },
{0x87fc ,0xe5 },
{0x87fd ,0x43 },
{0x87fe ,0xfb },
{0x87ff ,0xfd },
{0x8800 ,0x7c },
{0x8801 ,0x00 },
{0x8802 ,0x12 },
{0x8803 ,0x05 },
{0x8804 ,0x34 },
{0x8805 ,0x78 },
{0x8806 ,0x5c },
{0x8807 ,0xa6 },
{0x8808 ,0x06 },
{0x8809 ,0x08 },
{0x880a ,0xa6 },
{0x880b ,0x07 },
{0x880c ,0xaf },
{0x880d ,0x46 },
{0x880e ,0x7e },
{0x880f ,0x00 },
{0x8810 ,0x78 },
{0x8811 ,0x54 },
{0x8812 ,0x12 },
{0x8813 ,0x0a },
{0x8814 ,0xc8 },
{0x8815 ,0xad },
{0x8816 ,0x03 },
{0x8817 ,0x7c },
{0x8818 ,0x00 },
{0x8819 ,0x12 },
{0x881a ,0x05 },
{0x881b ,0x34 },
{0x881c ,0x78 },
{0x881d ,0x58 },
{0x881e ,0xa6 },
{0x881f ,0x06 },
{0x8820 ,0x08 },
{0x8821 ,0xa6 },
{0x8822 ,0x07 },
{0x8823 ,0xc3 },
{0x8824 ,0x78 },
{0x8825 ,0x5b },
{0x8826 ,0xe6 },
{0x8827 ,0x94 },
{0x8828 ,0x08 },
{0x8829 ,0x18 },
{0x882a ,0xe6 },
{0x882b ,0x94 },
{0x882c ,0x00 },
{0x882d ,0x50 },
{0x882e ,0x05 },
{0x882f ,0x76 },
{0x8830 ,0x00 },
{0x8831 ,0x08 },
{0x8832 ,0x76 },
{0x8833 ,0x08 },
{0x8834 ,0xc3 },
{0x8835 ,0x78 },
{0x8836 ,0x5d },
{0x8837 ,0xe6 },
{0x8838 ,0x94 },
{0x8839 ,0x08 },
{0x883a ,0x18 },
{0x883b ,0xe6 },
{0x883c ,0x94 },
{0x883d ,0x00 },
{0x883e ,0x50 },
{0x883f ,0x05 },
{0x8840 ,0x76 },
{0x8841 ,0x00 },
{0x8842 ,0x08 },
{0x8843 ,0x76 },
{0x8844 ,0x08 },
{0x8845 ,0x78 },
{0x8846 ,0x5a },
{0x8847 ,0x12 },
{0x8848 ,0x0a },
{0x8849 ,0xd8 },
{0x884a ,0xff },
{0x884b ,0xd3 },
{0x884c ,0x78 },
{0x884d ,0x57 },
{0x884e ,0xe6 },
{0x884f ,0x9f },
{0x8850 ,0x18 },
{0x8851 ,0xe6 },
{0x8852 ,0x9e },
{0x8853 ,0x40 },
{0x8854 ,0x0e },
{0x8855 ,0x78 },
{0x8856 ,0x5a },
{0x8857 ,0xe6 },
{0x8858 ,0x13 },
{0x8859 ,0xfe },
{0x885a ,0x08 },
{0x885b ,0xe6 },
{0x885c ,0x78 },
{0x885d ,0x57 },
{0x885e ,0x12 },
{0x885f ,0x0b },
{0x8860 ,0x1a },
{0x8861 ,0x80 },
{0x8862 ,0x04 },
{0x8863 ,0x7e },
{0x8864 ,0x00 },
{0x8865 ,0x7f },
{0x8866 ,0x00 },
{0x8867 ,0x78 },
{0x8868 ,0x5e },
{0x8869 ,0x12 },
{0x886a ,0x0a },
{0x886b ,0xd0 },
{0x886c ,0xff },
{0x886d ,0xd3 },
{0x886e ,0x78 },
{0x886f ,0x59 },
{0x8870 ,0xe6 },
{0x8871 ,0x9f },
{0x8872 ,0x18 },
{0x8873 ,0xe6 },
{0x8874 ,0x9e },
{0x8875 ,0x40 },
{0x8876 ,0x0e },
{0x8877 ,0x78 },
{0x8878 ,0x5c },
{0x8879 ,0xe6 },
{0x887a ,0x13 },
{0x887b ,0xfe },
{0x887c ,0x08 },
{0x887d ,0xe6 },
{0x887e ,0x78 },
{0x887f ,0x59 },
{0x8880 ,0x12 },
{0x8881 ,0x0b },
{0x8882 ,0x1a },
{0x8883 ,0x80 },
{0x8884 ,0x04 },
{0x8885 ,0x7e },
{0x8886 ,0x00 },
{0x8887 ,0x7f },
{0x8888 ,0x00 },
{0x8889 ,0xe4 },
{0x888a ,0xfc },
{0x888b ,0xfd },
{0x888c ,0x78 },
{0x888d ,0x62 },
{0x888e ,0x12 },
{0x888f ,0x06 },
{0x8890 ,0xfa },
{0x8891 ,0x78 },
{0x8892 ,0x5a },
{0x8893 ,0x12 },
{0x8894 ,0x0a },
{0x8895 ,0xd8 },
{0x8896 ,0x78 },
{0x8897 ,0x57 },
{0x8898 ,0x26 },
{0x8899 ,0xff },
{0x889a ,0xee },
{0x889b ,0x18 },
{0x889c ,0x36 },
{0x889d ,0xfe },
{0x889e ,0x78 },
{0x889f ,0x66 },
{0x88a0 ,0x12 },
{0x88a1 ,0x0a },
{0x88a2 ,0xd0 },
{0x88a3 ,0x78 },
{0x88a4 ,0x59 },
{0x88a5 ,0x26 },
{0x88a6 ,0xff },
{0x88a7 ,0xee },
{0x88a8 ,0x18 },
{0x88a9 ,0x36 },
{0x88aa ,0xfe },
{0x88ab ,0xe4 },
{0x88ac ,0xfc },
{0x88ad ,0xfd },
{0x88ae ,0x78 },
{0x88af ,0x6a },
{0x88b0 ,0x12 },
{0x88b1 ,0x06 },
{0x88b2 ,0xfa },
{0x88b3 ,0x12 },
{0x88b4 ,0x0a },
{0x88b5 ,0xe0 },
{0x88b6 ,0x78 },
{0x88b7 ,0x66 },
{0x88b8 ,0x12 },
{0x88b9 ,0x06 },
{0x88ba ,0xed },
{0x88bb ,0xd3 },
{0x88bc ,0x12 },
{0x88bd ,0x06 },
{0x88be ,0xa6 },
{0x88bf ,0x40 },
{0x88c0 ,0x08 },
{0x88c1 ,0x12 },
{0x88c2 ,0x0a },
{0x88c3 ,0xe0 },
{0x88c4 ,0x78 },
{0x88c5 ,0x66 },
{0x88c6 ,0x12 },
{0x88c7 ,0x06 },
{0x88c8 ,0xfa },
{0x88c9 ,0x78 },
{0x88ca ,0x54 },
{0x88cb ,0x12 },
{0x88cc ,0x0a },
{0x88cd ,0xe2 },
{0x88ce ,0x78 },
{0x88cf ,0x6a },
{0x88d0 ,0x12 },
{0x88d1 ,0x06 },
{0x88d2 ,0xed },
{0x88d3 ,0xd3 },
{0x88d4 ,0x12 },
{0x88d5 ,0x06 },
{0x88d6 ,0xa6 },
{0x88d7 ,0x40 },
{0x88d8 ,0x0a },
{0x88d9 ,0x78 },
{0x88da ,0x54 },
{0x88db ,0x12 },
{0x88dc ,0x0a },
{0x88dd ,0xe2 },
{0x88de ,0x78 },
{0x88df ,0x6a },
{0x88e0 ,0x12 },
{0x88e1 ,0x06 },
{0x88e2 ,0xfa },
{0x88e3 ,0x78 },
{0x88e4 ,0x61 },
{0x88e5 ,0xe6 },
{0x88e6 ,0x90 },
{0x88e7 ,0x60 },
{0x88e8 ,0x01 },
{0x88e9 ,0xf0 },
{0x88ea ,0x78 },
{0x88eb ,0x65 },
{0x88ec ,0xe6 },
{0x88ed ,0xa3 },
{0x88ee ,0xf0 },
{0x88ef ,0x78 },
{0x88f0 ,0x69 },
{0x88f1 ,0xe6 },
{0x88f2 ,0xa3 },
{0x88f3 ,0xf0 },
{0x88f4 ,0x78 },
{0x88f5 ,0x55 },
{0x88f6 ,0xe6 },
{0x88f7 ,0xa3 },
{0x88f8 ,0xf0 },
{0x88f9 ,0x7d },
{0x88fa ,0x01 },
{0x88fb ,0x78 },
{0x88fc ,0x61 },
{0x88fd ,0x12 },
{0x88fe ,0x0a },
{0x88ff ,0xfb },
{0x8900 ,0x24 },
{0x8901 ,0x01 },
{0x8902 ,0x12 },
{0x8903 ,0x0a },
{0x8904 ,0xb8 },
{0x8905 ,0x78 },
{0x8906 ,0x65 },
{0x8907 ,0x12 },
{0x8908 ,0x0a },
{0x8909 ,0xfb },
{0x890a ,0x24 },
{0x890b ,0x02 },
{0x890c ,0x12 },
{0x890d ,0x0a },
{0x890e ,0xb8 },
{0x890f ,0x78 },
{0x8910 ,0x69 },
{0x8911 ,0x12 },
{0x8912 ,0x0a },
{0x8913 ,0xfb },
{0x8914 ,0x24 },
{0x8915 ,0x03 },
{0x8916 ,0x12 },
{0x8917 ,0x0a },
{0x8918 ,0xb8 },
{0x8919 ,0x78 },
{0x891a ,0x6d },
{0x891b ,0x12 },
{0x891c ,0x0a },
{0x891d ,0xfb },
{0x891e ,0x24 },
{0x891f ,0x04 },
{0x8920 ,0x12 },
{0x8921 ,0x0a },
{0x8922 ,0xb8 },
{0x8923 ,0x0d },
{0x8924 ,0xbd },
{0x8925 ,0x05 },
{0x8926 ,0xd4 },
{0x8927 ,0x22 },
{0x8928 ,0xc0 },
{0x8929 ,0xe0 },
{0x892a ,0xc0 },
{0x892b ,0x83 },
{0x892c ,0xc0 },
{0x892d ,0x82 },
{0x892e ,0xc0 },
{0x892f ,0xd0 },
{0x8930 ,0x90 },
{0x8931 ,0x3f },
{0x8932 ,0x0c },
{0x8933 ,0xe0 },
{0x8934 ,0xf5 },
{0x8935 ,0x32 },
{0x8936 ,0xe5 },
{0x8937 ,0x32 },
{0x8938 ,0x30 },
{0x8939 ,0xe3 },
{0x893a ,0x74 },
{0x893b ,0x30 },
{0x893c ,0x36 },
{0x893d ,0x66 },
{0x893e ,0x90 },
{0x893f ,0x60 },
{0x8940 ,0x19 },
{0x8941 ,0xe0 },
{0x8942 ,0xf5 },
{0x8943 ,0x0a },
{0x8944 ,0xa3 },
{0x8945 ,0xe0 },
{0x8946 ,0xf5 },
{0x8947 ,0x0b },
{0x8948 ,0x90 },
{0x8949 ,0x60 },
{0x894a ,0x1d },
{0x894b ,0xe0 },
{0x894c ,0xf5 },
{0x894d ,0x14 },
{0x894e ,0xa3 },
{0x894f ,0xe0 },
{0x8950 ,0xf5 },
{0x8951 ,0x15 },
{0x8952 ,0x90 },
{0x8953 ,0x60 },
{0x8954 ,0x21 },
{0x8955 ,0xe0 },
{0x8956 ,0xf5 },
{0x8957 ,0x0c },
{0x8958 ,0xa3 },
{0x8959 ,0xe0 },
{0x895a ,0xf5 },
{0x895b ,0x0d },
{0x895c ,0x90 },
{0x895d ,0x60 },
{0x895e ,0x29 },
{0x895f ,0xe0 },
{0x8960 ,0xf5 },
{0x8961 ,0x0e },
{0x8962 ,0xa3 },
{0x8963 ,0xe0 },
{0x8964 ,0xf5 },
{0x8965 ,0x0f },
{0x8966 ,0x90 },
{0x8967 ,0x60 },
{0x8968 ,0x31 },
{0x8969 ,0xe0 },
{0x896a ,0xf5 },
{0x896b ,0x10 },
{0x896c ,0xa3 },
{0x896d ,0xe0 },
{0x896e ,0xf5 },
{0x896f ,0x11 },
{0x8970 ,0x90 },
{0x8971 ,0x60 },
{0x8972 ,0x39 },
{0x8973 ,0xe0 },
{0x8974 ,0xf5 },
{0x8975 ,0x12 },
{0x8976 ,0xa3 },
{0x8977 ,0xe0 },
{0x8978 ,0xf5 },
{0x8979 ,0x13 },
{0x897a ,0x30 },
{0x897b ,0x01 },
{0x897c ,0x06 },
{0x897d ,0x30 },
{0x897e ,0x33 },
{0x897f ,0x03 },
{0x8980 ,0xd3 },
{0x8981 ,0x80 },
{0x8982 ,0x01 },
{0x8983 ,0xc3 },
{0x8984 ,0x92 },
{0x8985 ,0x09 },
{0x8986 ,0x30 },
{0x8987 ,0x02 },
{0x8988 ,0x06 },
{0x8989 ,0x30 },
{0x898a ,0x33 },
{0x898b ,0x03 },
{0x898c ,0xd3 },
{0x898d ,0x80 },
{0x898e ,0x01 },
{0x898f ,0xc3 },
{0x8990 ,0x92 },
{0x8991 ,0x0a },
{0x8992 ,0x30 },
{0x8993 ,0x33 },
{0x8994 ,0x0c },
{0x8995 ,0x30 },
{0x8996 ,0x03 },
{0x8997 ,0x09 },
{0x8998 ,0x20 },
{0x8999 ,0x02 },
{0x899a ,0x06 },
{0x899b ,0x20 },
{0x899c ,0x01 },
{0x899d ,0x03 },
{0x899e ,0xd3 },
{0x899f ,0x80 },
{0x89a0 ,0x01 },
{0x89a1 ,0xc3 },
{0x89a2 ,0x92 },
{0x89a3 ,0x0b },
{0x89a4 ,0x90 },
{0x89a5 ,0x30 },
{0x89a6 ,0x01 },
{0x89a7 ,0xe0 },
{0x89a8 ,0x44 },
{0x89a9 ,0x40 },
{0x89aa ,0xf0 },
{0x89ab ,0xe0 },
{0x89ac ,0x54 },
{0x89ad ,0xbf },
{0x89ae ,0xf0 },
{0x89af ,0xe5 },
{0x89b0 ,0x32 },
{0x89b1 ,0x30 },
{0x89b2 ,0xe1 },
{0x89b3 ,0x14 },
{0x89b4 ,0x30 },
{0x89b5 ,0x34 },
{0x89b6 ,0x11 },
{0x89b7 ,0x90 },
{0x89b8 ,0x30 },
{0x89b9 ,0x22 },
{0x89ba ,0xe0 },
{0x89bb ,0xf5 },
{0x89bc ,0x08 },
{0x89bd ,0xe4 },
{0x89be ,0xf0 },
{0x89bf ,0x30 },
{0x89c0 ,0x00 },
{0x89c1 ,0x03 },
{0x89c2 ,0xd3 },
{0x89c3 ,0x80 },
{0x89c4 ,0x01 },
{0x89c5 ,0xc3 },
{0x89c6 ,0x92 },
{0x89c7 ,0x08 },
{0x89c8 ,0xe5 },
{0x89c9 ,0x32 },
{0x89ca ,0x30 },
{0x89cb ,0xe5 },
{0x89cc ,0x12 },
{0x89cd ,0x90 },
{0x89ce ,0x56 },
{0x89cf ,0xa1 },
{0x89d0 ,0xe0 },
{0x89d1 ,0xf5 },
{0x89d2 ,0x09 },
{0x89d3 ,0x30 },
{0x89d4 ,0x31 },
{0x89d5 ,0x09 },
{0x89d6 ,0x30 },
{0x89d7 ,0x05 },
{0x89d8 ,0x03 },
{0x89d9 ,0xd3 },
{0x89da ,0x80 },
{0x89db ,0x01 },
{0x89dc ,0xc3 },
{0x89dd ,0x92 },
{0x89de ,0x0d },
{0x89df ,0x90 },
{0x89e0 ,0x3f },
{0x89e1 ,0x0c },
{0x89e2 ,0xe5 },
{0x89e3 ,0x32 },
{0x89e4 ,0xf0 },
{0x89e5 ,0xd0 },
{0x89e6 ,0xd0 },
{0x89e7 ,0xd0 },
{0x89e8 ,0x82 },
{0x89e9 ,0xd0 },
{0x89ea ,0x83 },
{0x89eb ,0xd0 },
{0x89ec ,0xe0 },
{0x89ed ,0x32 },
{0x89ee ,0x85 },
{0x89ef ,0x08 },
{0x89f0 ,0x41 },
{0x89f1 ,0x90 },
{0x89f2 ,0x30 },
{0x89f3 ,0x24 },
{0x89f4 ,0xe0 },
{0x89f5 ,0xf5 },
{0x89f6 ,0x3d },
{0x89f7 ,0xa3 },
{0x89f8 ,0xe0 },
{0x89f9 ,0xf5 },
{0x89fa ,0x3e },
{0x89fb ,0xa3 },
{0x89fc ,0xe0 },
{0x89fd ,0xf5 },
{0x89fe ,0x3f },
{0x89ff ,0xa3 },
{0x8a00 ,0xe0 },
{0x8a01 ,0xf5 },
{0x8a02 ,0x40 },
{0x8a03 ,0xa3 },
{0x8a04 ,0xe0 },
{0x8a05 ,0xf5 },
{0x8a06 ,0x3c },
{0x8a07 ,0xd2 },
{0x8a08 ,0x34 },
{0x8a09 ,0xe5 },
{0x8a0a ,0x41 },
{0x8a0b ,0x12 },
{0x8a0c ,0x07 },
{0x8a0d ,0x12 },
{0x8a0e ,0x0a },
{0x8a0f ,0x33 },
{0x8a10 ,0x03 },
{0x8a11 ,0x0a },
{0x8a12 ,0x40 },
{0x8a13 ,0x04 },
{0x8a14 ,0x0a },
{0x8a15 ,0x51 },
{0x8a16 ,0x05 },
{0x8a17 ,0x0a },
{0x8a18 ,0x54 },
{0x8a19 ,0x06 },
{0x8a1a ,0x0a },
{0x8a1b ,0x5d },
{0x8a1c ,0x08 },
{0x8a1d ,0x0a },
{0x8a1e ,0x6d },
{0x8a1f ,0x12 },
{0x8a20 ,0x0a },
{0x8a21 ,0x72 },
{0x8a22 ,0x1a },
{0x8a23 ,0x0a },
{0x8a24 ,0x7d },
{0x8a25 ,0x1b },
{0x8a26 ,0x0a },
{0x8a27 ,0x6d },
{0x8a28 ,0x80 },
{0x8a29 ,0x0a },
{0x8a2a ,0x6d },
{0x8a2b ,0x81 },
{0x8a2c ,0x0a },
{0x8a2d ,0x85 },
{0x8a2e ,0xec },
{0x8a2f ,0x00 },
{0x8a30 ,0x00 },
{0x8a31 ,0x0a },
{0x8a32 ,0xa3 },
{0x8a33 ,0x12 },
{0x8a34 ,0x0f },
{0x8a35 ,0xd2 },
{0x8a36 ,0xd2 },
{0x8a37 ,0x36 },
{0x8a38 ,0xd2 },
{0x8a39 ,0x01 },
{0x8a3a ,0xc2 },
{0x8a3b ,0x02 },
{0x8a3c ,0x12 },
{0x8a3d ,0x0f },
{0x8a3e ,0xd7 },
{0x8a3f ,0x22 },
{0x8a40 ,0xd2 },
{0x8a41 ,0x33 },
{0x8a42 ,0xd2 },
{0x8a43 ,0x36 },
{0x8a44 ,0xe5 },
{0x8a45 ,0x3d },
{0x8a46 ,0xd3 },
{0x8a47 ,0x94 },
{0x8a48 ,0x00 },
{0x8a49 ,0x40 },
{0x8a4a ,0x03 },
{0x8a4b ,0x12 },
{0x8a4c ,0x0f },
{0x8a4d ,0xd2 },
{0x8a4e ,0xd2 },
{0x8a4f ,0x03 },
{0x8a50 ,0x22 },
{0x8a51 ,0xd2 },
{0x8a52 ,0x03 },
{0x8a53 ,0x22 },
{0x8a54 ,0xc2 },
{0x8a55 ,0x03 },
{0x8a56 ,0x20 },
{0x8a57 ,0x01 },
{0x8a58 ,0x4a },
{0x8a59 ,0x30 },
{0x8a5a ,0x02 },
{0x8a5b ,0x2c },
{0x8a5c ,0x22 },
{0x8a5d ,0xc2 },
{0x8a5e ,0x01 },
{0x8a5f ,0xc2 },
{0x8a60 ,0x02 },
{0x8a61 ,0xc2 },
{0x8a62 ,0x03 },
{0x8a63 ,0x12 },
{0x8a64 ,0x0d },
{0x8a65 ,0x39 },
{0x8a66 ,0x75 },
{0x8a67 ,0x1e },
{0x8a68 ,0x70 },
{0x8a69 ,0xd2 },
{0x8a6a ,0x35 },
{0x8a6b ,0x80 },
{0x8a6c ,0x1b },
{0x8a6d ,0x12 },
{0x8a6e ,0x0b },
{0x8a6f ,0xcc },
{0x8a70 ,0x80 },
{0x8a71 ,0x16 },
{0x8a72 ,0x85 },
{0x8a73 ,0x40 },
{0x8a74 ,0x4a },
{0x8a75 ,0x85 },
{0x8a76 ,0x3c },
{0x8a77 ,0x4b },
{0x8a78 ,0x12 },
{0x8a79 ,0x0b },
{0x8a7a ,0x39 },
{0x8a7b ,0x80 },
{0x8a7c ,0x0b },
{0x8a7d ,0x85 },
{0x8a7e ,0x4a },
{0x8a7f ,0x40 },
{0x8a80 ,0x85 },
{0x8a81 ,0x4b },
{0x8a82 ,0x3c },
{0x8a83 ,0x80 },
{0x8a84 ,0x03 },
{0x8a85 ,0x12 },
{0x8a86 ,0x0f },
{0x8a87 ,0x00 },
{0x8a88 ,0x90 },
{0x8a89 ,0x30 },
{0x8a8a ,0x24 },
{0x8a8b ,0xe5 },
{0x8a8c ,0x3d },
{0x8a8d ,0xf0 },
{0x8a8e ,0xa3 },
{0x8a8f ,0xe5 },
{0x8a90 ,0x3e },
{0x8a91 ,0xf0 },
{0x8a92 ,0xa3 },
{0x8a93 ,0xe5 },
{0x8a94 ,0x3f },
{0x8a95 ,0xf0 },
{0x8a96 ,0xa3 },
{0x8a97 ,0xe5 },
{0x8a98 ,0x40 },
{0x8a99 ,0xf0 },
{0x8a9a ,0xa3 },
{0x8a9b ,0xe5 },
{0x8a9c ,0x3c },
{0x8a9d ,0xf0 },
{0x8a9e ,0x90 },
{0x8a9f ,0x30 },
{0x8aa0 ,0x23 },
{0x8aa1 ,0xe4 },
{0x8aa2 ,0xf0 },
{0x8aa3 ,0x22 },
{0x8aa4 ,0xe0 },
{0x8aa5 ,0xa3 },
{0x8aa6 ,0xe0 },
{0x8aa7 ,0x75 },
{0x8aa8 ,0xf0 },
{0x8aa9 ,0x02 },
{0x8aaa ,0xa4 },
{0x8aab ,0xff },
{0x8aac ,0xae },
{0x8aad ,0xf0 },
{0x8aae ,0xc3 },
{0x8aaf ,0x08 },
{0x8ab0 ,0xe6 },
{0x8ab1 ,0x9f },
{0x8ab2 ,0xf6 },
{0x8ab3 ,0x18 },
{0x8ab4 ,0xe6 },
{0x8ab5 ,0x9e },
{0x8ab6 ,0xf6 },
{0x8ab7 ,0x22 },
{0x8ab8 ,0xff },
{0x8ab9 ,0xe5 },
{0x8aba ,0xf0 },
{0x8abb ,0x34 },
{0x8abc ,0x60 },
{0x8abd ,0x8f },
{0x8abe ,0x82 },
{0x8abf ,0xf5 },
{0x8ac0 ,0x83 },
{0x8ac1 ,0xec },
{0x8ac2 ,0xf0 },
{0x8ac3 ,0x22 },
{0x8ac4 ,0x78 },
{0x8ac5 ,0x52 },
{0x8ac6 ,0x7e },
{0x8ac7 ,0x00 },
{0x8ac8 ,0xe6 },
{0x8ac9 ,0xfc },
{0x8aca ,0x08 },
{0x8acb ,0xe6 },
{0x8acc ,0xfd },
{0x8acd ,0x02 },
{0x8ace ,0x05 },
{0x8acf ,0x22 },
{0x8ad0 ,0xe4 },
{0x8ad1 ,0xfc },
{0x8ad2 ,0xfd },
{0x8ad3 ,0x12 },
{0x8ad4 ,0x06 },
{0x8ad5 ,0xfa },
{0x8ad6 ,0x78 },
{0x8ad7 ,0x5c },
{0x8ad8 ,0xe6 },
{0x8ad9 ,0xc3 },
{0x8ada ,0x13 },
{0x8adb ,0xfe },
{0x8adc ,0x08 },
{0x8add ,0xe6 },
{0x8ade ,0x13 },
{0x8adf ,0x22 },
{0x8ae0 ,0x78 },
{0x8ae1 ,0x52 },
{0x8ae2 ,0xe6 },
{0x8ae3 ,0xfe },
{0x8ae4 ,0x08 },
{0x8ae5 ,0xe6 },
{0x8ae6 ,0xff },
{0x8ae7 ,0xe4 },
{0x8ae8 ,0xfc },
{0x8ae9 ,0xfd },
{0x8aea ,0x22 },
{0x8aeb ,0xe7 },
{0x8aec ,0xc4 },
{0x8aed ,0xf8 },
{0x8aee ,0x54 },
{0x8aef ,0xf0 },
{0x8af0 ,0xc8 },
{0x8af1 ,0x68 },
{0x8af2 ,0xf7 },
{0x8af3 ,0x09 },
{0x8af4 ,0xe7 },
{0x8af5 ,0xc4 },
{0x8af6 ,0x54 },
{0x8af7 ,0x0f },
{0x8af8 ,0x48 },
{0x8af9 ,0xf7 },
{0x8afa ,0x22 },
{0x8afb ,0xe6 },
{0x8afc ,0xfc },
{0x8afd ,0xed },
{0x8afe ,0x75 },
{0x8aff ,0xf0 },
{0x8b00 ,0x04 },
{0x8b01 ,0xa4 },
{0x8b02 ,0x22 },
{0x8b03 ,0x12 },
{0x8b04 ,0x06 },
{0x8b05 ,0xdd },
{0x8b06 ,0x8f },
{0x8b07 ,0x48 },
{0x8b08 ,0x8e },
{0x8b09 ,0x47 },
{0x8b0a ,0x8d },
{0x8b0b ,0x46 },
{0x8b0c ,0x8c },
{0x8b0d ,0x45 },
{0x8b0e ,0x22 },
{0x8b0f ,0xe0 },
{0x8b10 ,0xfe },
{0x8b11 ,0xa3 },
{0x8b12 ,0xe0 },
{0x8b13 ,0xfd },
{0x8b14 ,0xee },
{0x8b15 ,0xf6 },
{0x8b16 ,0xed },
{0x8b17 ,0x08 },
{0x8b18 ,0xf6 },
{0x8b19 ,0x22 },
{0x8b1a ,0x13 },
{0x8b1b ,0xff },
{0x8b1c ,0xc3 },
{0x8b1d ,0xe6 },
{0x8b1e ,0x9f },
{0x8b1f ,0xff },
{0x8b20 ,0x18 },
{0x8b21 ,0xe6 },
{0x8b22 ,0x9e },
{0x8b23 ,0xfe },
{0x8b24 ,0x22 },
{0x8b25 ,0xfb },
{0x8b26 ,0xd3 },
{0x8b27 ,0xed },
{0x8b28 ,0x9b },
{0x8b29 ,0x74 },
{0x8b2a ,0x80 },
{0x8b2b ,0xf8 },
{0x8b2c ,0x6c },
{0x8b2d ,0x98 },
{0x8b2e ,0x22 },
{0x8b2f ,0xe6 },
{0x8b30 ,0xc3 },
{0x8b31 ,0x13 },
{0x8b32 ,0xf7 },
{0x8b33 ,0x08 },
{0x8b34 ,0xe6 },
{0x8b35 ,0x13 },
{0x8b36 ,0x09 },
{0x8b37 ,0xf7 },
{0x8b38 ,0x22 },
{0x8b39 ,0x90 },
{0x8b3a ,0x0e },
{0x8b3b ,0x7e },
{0x8b3c ,0xe4 },
{0x8b3d ,0x93 },
{0x8b3e ,0xfe },
{0x8b3f ,0x74 },
{0x8b40 ,0x01 },
{0x8b41 ,0x93 },
{0x8b42 ,0xff },
{0x8b43 ,0xc3 },
{0x8b44 ,0x90 },
{0x8b45 ,0x0e },
{0x8b46 ,0x7c },
{0x8b47 ,0x74 },
{0x8b48 ,0x01 },
{0x8b49 ,0x93 },
{0x8b4a ,0x9f },
{0x8b4b ,0xff },
{0x8b4c ,0xe4 },
{0x8b4d ,0x93 },
{0x8b4e ,0x9e },
{0x8b4f ,0xfe },
{0x8b50 ,0xe4 },
{0x8b51 ,0x8f },
{0x8b52 ,0x3b },
{0x8b53 ,0x8e },
{0x8b54 ,0x3a },
{0x8b55 ,0xf5 },
{0x8b56 ,0x39 },
{0x8b57 ,0xf5 },
{0x8b58 ,0x38 },
{0x8b59 ,0xab },
{0x8b5a ,0x3b },
{0x8b5b ,0xaa },
{0x8b5c ,0x3a },
{0x8b5d ,0xa9 },
{0x8b5e ,0x39 },
{0x8b5f ,0xa8 },
{0x8b60 ,0x38 },
{0x8b61 ,0xaf },
{0x8b62 ,0x4b },
{0x8b63 ,0xfc },
{0x8b64 ,0xfd },
{0x8b65 ,0xfe },
{0x8b66 ,0x12 },
{0x8b67 ,0x05 },
{0x8b68 ,0x89 },
{0x8b69 ,0x12 },
{0x8b6a ,0x0f },
{0x8b6b ,0x91 },
{0x8b6c ,0xe4 },
{0x8b6d ,0x7b },
{0x8b6e ,0xff },
{0x8b6f ,0xfa },
{0x8b70 ,0xf9 },
{0x8b71 ,0xf8 },
{0x8b72 ,0x12 },
{0x8b73 ,0x06 },
{0x8b74 ,0x14 },
{0x8b75 ,0x12 },
{0x8b76 ,0x0f },
{0x8b77 ,0x91 },
{0x8b78 ,0x90 },
{0x8b79 ,0x0e },
{0x8b7a ,0x69 },
{0x8b7b ,0xe4 },
{0x8b7c ,0x12 },
{0x8b7d ,0x0f },
{0x8b7e ,0xa6 },
{0x8b7f ,0x12 },
{0x8b80 ,0x0f },
{0x8b81 ,0x91 },
{0x8b82 ,0xe4 },
{0x8b83 ,0x85 },
{0x8b84 ,0x4a },
{0x8b85 ,0x37 },
{0x8b86 ,0xf5 },
{0x8b87 ,0x36 },
{0x8b88 ,0xf5 },
{0x8b89 ,0x35 },
{0x8b8a ,0xf5 },
{0x8b8b ,0x34 },
{0x8b8c ,0xaf },
{0x8b8d ,0x37 },
{0x8b8e ,0xae },
{0x8b8f ,0x36 },
{0x8b90 ,0xad },
{0x8b91 ,0x35 },
{0x8b92 ,0xac },
{0x8b93 ,0x34 },
{0x8b94 ,0xa3 },
{0x8b95 ,0x12 },
{0x8b96 ,0x0f },
{0x8b97 ,0xa6 },
{0x8b98 ,0x8f },
{0x8b99 ,0x37 },
{0x8b9a ,0x8e },
{0x8b9b ,0x36 },
{0x8b9c ,0x8d },
{0x8b9d ,0x35 },
{0x8b9e ,0x8c },
{0x8b9f ,0x34 },
{0x8ba0 ,0xe5 },
{0x8ba1 ,0x3b },
{0x8ba2 ,0x45 },
{0x8ba3 ,0x37 },
{0x8ba4 ,0xf5 },
{0x8ba5 ,0x3b },
{0x8ba6 ,0xe5 },
{0x8ba7 ,0x3a },
{0x8ba8 ,0x45 },
{0x8ba9 ,0x36 },
{0x8baa ,0xf5 },
{0x8bab ,0x3a },
{0x8bac ,0xe5 },
{0x8bad ,0x39 },
{0x8bae ,0x45 },
{0x8baf ,0x35 },
{0x8bb0 ,0xf5 },
{0x8bb1 ,0x39 },
{0x8bb2 ,0xe5 },
{0x8bb3 ,0x38 },
{0x8bb4 ,0x45 },
{0x8bb5 ,0x34 },
{0x8bb6 ,0xf5 },
{0x8bb7 ,0x38 },
{0x8bb8 ,0xe4 },
{0x8bb9 ,0xf5 },
{0x8bba ,0x22 },
{0x8bbb ,0xf5 },
{0x8bbc ,0x23 },
{0x8bbd ,0x85 },
{0x8bbe ,0x3b },
{0x8bbf ,0x31 },
{0x8bc0 ,0x85 },
{0x8bc1 ,0x3a },
{0x8bc2 ,0x30 },
{0x8bc3 ,0x85 },
{0x8bc4 ,0x39 },
{0x8bc5 ,0x2f },
{0x8bc6 ,0x85 },
{0x8bc7 ,0x38 },
{0x8bc8 ,0x2e },
{0x8bc9 ,0x02 },
{0x8bca ,0x0f },
{0x8bcb ,0x63 },
{0x8bcc ,0xe5 },
{0x8bcd ,0x3c },
{0x8bce ,0xd3 },
{0x8bcf ,0x94 },
{0x8bd0 ,0x01 },
{0x8bd1 ,0x40 },
{0x8bd2 ,0x0b },
{0x8bd3 ,0x90 },
{0x8bd4 ,0x0e },
{0x8bd5 ,0x88 },
{0x8bd6 ,0x12 },
{0x8bd7 ,0x0b },
{0x8bd8 ,0x03 },
{0x8bd9 ,0x90 },
{0x8bda ,0x0e },
{0x8bdb ,0x86 },
{0x8bdc ,0x80 },
{0x8bdd ,0x09 },
{0x8bde ,0x90 },
{0x8bdf ,0x0e },
{0x8be0 ,0x82 },
{0x8be1 ,0x12 },
{0x8be2 ,0x0b },
{0x8be3 ,0x03 },
{0x8be4 ,0x90 },
{0x8be5 ,0x0e },
{0x8be6 ,0x80 },
{0x8be7 ,0xe4 },
{0x8be8 ,0x93 },
{0x8be9 ,0xf5 },
{0x8bea ,0x44 },
{0x8beb ,0xa3 },
{0x8bec ,0xe4 },
{0x8bed ,0x93 },
{0x8bee ,0xf5 },
{0x8bef ,0x43 },
{0x8bf0 ,0xe5 },
{0x8bf1 ,0x3c },
{0x8bf2 ,0xd3 },
{0x8bf3 ,0x94 },
{0x8bf4 ,0x00 },
{0x8bf5 ,0x40 },
{0x8bf6 ,0x06 },
{0x8bf7 ,0x85 },
{0x8bf8 ,0x3d },
{0x8bf9 ,0x45 },
{0x8bfa ,0x85 },
{0x8bfb ,0x3e },
{0x8bfc ,0x46 },
{0x8bfd ,0xe5 },
{0x8bfe ,0x47 },
{0x8bff ,0xc3 },
{0x8c00 ,0x13 },
{0x8c01 ,0xff },
{0x8c02 ,0xe5 },
{0x8c03 ,0x45 },
{0x8c04 ,0xc3 },
{0x8c05 ,0x9f },
{0x8c06 ,0x50 },
{0x8c07 ,0x02 },
{0x8c08 ,0x8f },
{0x8c09 ,0x45 },
{0x8c0a ,0xe5 },
{0x8c0b ,0x48 },
{0x8c0c ,0xc3 },
{0x8c0d ,0x13 },
{0x8c0e ,0xff },
{0x8c0f ,0xe5 },
{0x8c10 ,0x46 },
{0x8c11 ,0xc3 },
{0x8c12 ,0x9f },
{0x8c13 ,0x50 },
{0x8c14 ,0x02 },
{0x8c15 ,0x8f },
{0x8c16 ,0x46 },
{0x8c17 ,0xe5 },
{0x8c18 ,0x47 },
{0x8c19 ,0xc3 },
{0x8c1a ,0x13 },
{0x8c1b ,0xff },
{0x8c1c ,0xfd },
{0x8c1d ,0xe5 },
{0x8c1e ,0x45 },
{0x8c1f ,0x2d },
{0x8c20 ,0xfd },
{0x8c21 ,0xe4 },
{0x8c22 ,0x33 },
{0x8c23 ,0xfc },
{0x8c24 ,0xe5 },
{0x8c25 ,0x44 },
{0x8c26 ,0x12 },
{0x8c27 ,0x0b },
{0x8c28 ,0x25 },
{0x8c29 ,0x40 },
{0x8c2a ,0x05 },
{0x8c2b ,0xe5 },
{0x8c2c ,0x44 },
{0x8c2d ,0x9f },
{0x8c2e ,0xf5 },
{0x8c2f ,0x45 },
{0x8c30 ,0xe5 },
{0x8c31 ,0x48 },
{0x8c32 ,0xc3 },
{0x8c33 ,0x13 },
{0x8c34 ,0xff },
{0x8c35 ,0xfd },
{0x8c36 ,0xe5 },
{0x8c37 ,0x46 },
{0x8c38 ,0x2d },
{0x8c39 ,0xfd },
{0x8c3a ,0xe4 },
{0x8c3b ,0x33 },
{0x8c3c ,0xfc },
{0x8c3d ,0xe5 },
{0x8c3e ,0x43 },
{0x8c3f ,0x12 },
{0x8c40 ,0x0b },
{0x8c41 ,0x25 },
{0x8c42 ,0x40 },
{0x8c43 ,0x05 },
{0x8c44 ,0xe5 },
{0x8c45 ,0x43 },
{0x8c46 ,0x9f },
{0x8c47 ,0xf5 },
{0x8c48 ,0x46 },
{0x8c49 ,0x02 },
{0x8c4a ,0x07 },
{0x8c4b ,0x38 },
{0x8c4c ,0xad },
{0x8c4d ,0x39 },
{0x8c4e ,0xac },
{0x8c4f ,0x38 },
{0x8c50 ,0xfa },
{0x8c51 ,0xf9 },
{0x8c52 ,0xf8 },
{0x8c53 ,0x12 },
{0x8c54 ,0x05 },
{0x8c55 ,0x89 },
{0x8c56 ,0x8f },
{0x8c57 ,0x3b },
{0x8c58 ,0x8e },
{0x8c59 ,0x3a },
{0x8c5a ,0x8d },
{0x8c5b ,0x39 },
{0x8c5c ,0x8c },
{0x8c5d ,0x38 },
{0x8c5e ,0xab },
{0x8c5f ,0x37 },
{0x8c60 ,0xaa },
{0x8c61 ,0x36 },
{0x8c62 ,0xa9 },
{0x8c63 ,0x35 },
{0x8c64 ,0xa8 },
{0x8c65 ,0x34 },
{0x8c66 ,0x22 },
{0x8c67 ,0x90 },
{0x8c68 ,0x0e },
{0x8c69 ,0x8c },
{0x8c6a ,0xe4 },
{0x8c6b ,0x93 },
{0x8c6c ,0x25 },
{0x8c6d ,0xe0 },
{0x8c6e ,0x24 },
{0x8c6f ,0x0a },
{0x8c70 ,0xf8 },
{0x8c71 ,0xe6 },
{0x8c72 ,0xfe },
{0x8c73 ,0x08 },
{0x8c74 ,0xe6 },
{0x8c75 ,0xff },
{0x8c76 ,0x22 },
{0x8c77 ,0x93 },
{0x8c78 ,0xff },
{0x8c79 ,0xe4 },
{0x8c7a ,0xfc },
{0x8c7b ,0xfd },
{0x8c7c ,0xfe },
{0x8c7d ,0x12 },
{0x8c7e ,0x05 },
{0x8c7f ,0x89 },
{0x8c80 ,0x8f },
{0x8c81 ,0x37 },
{0x8c82 ,0x8e },
{0x8c83 ,0x36 },
{0x8c84 ,0x8d },
{0x8c85 ,0x35 },
{0x8c86 ,0x8c },
{0x8c87 ,0x34 },
{0x8c88 ,0x22 },
{0x8c89 ,0xe6 },
{0x8c8a ,0xfe },
{0x8c8b ,0x08 },
{0x8c8c ,0xe6 },
{0x8c8d ,0xff },
{0x8c8e ,0xe4 },
{0x8c8f ,0x8f },
{0x8c90 ,0x37 },
{0x8c91 ,0x8e },
{0x8c92 ,0x36 },
{0x8c93 ,0xf5 },
{0x8c94 ,0x35 },
{0x8c95 ,0xf5 },
{0x8c96 ,0x34 },
{0x8c97 ,0x22 },
{0x8c98 ,0xef },
{0x8c99 ,0x25 },
{0x8c9a ,0xe0 },
{0x8c9b ,0x24 },
{0x8c9c ,0x4e },
{0x8c9d ,0xf8 },
{0x8c9e ,0xe6 },
{0x8c9f ,0xfc },
{0x8ca0 ,0x08 },
{0x8ca1 ,0xe6 },
{0x8ca2 ,0xfd },
{0x8ca3 ,0x22 },
{0x8ca4 ,0xd3 },
{0x8ca5 ,0x79 },
{0x8ca6 ,0x81 },
{0x8ca7 ,0xe7 },
{0x8ca8 ,0x78 },
{0x8ca9 ,0x7f },
{0x8caa ,0x96 },
{0x8cab ,0x19 },
{0x8cac ,0xe7 },
{0x8cad ,0x18 },
{0x8cae ,0x96 },
{0x8caf ,0x22 },
{0x8cb0 ,0x78 },
{0x8cb1 ,0x89 },
{0x8cb2 ,0xef },
{0x8cb3 ,0x26 },
{0x8cb4 ,0xf6 },
{0x8cb5 ,0x18 },
{0x8cb6 ,0xe4 },
{0x8cb7 ,0x36 },
{0x8cb8 ,0xf6 },
{0x8cb9 ,0x22 },
{0x8cba ,0xe4 },
{0x8cbb ,0x8f },
{0x8cbc ,0x3b },
{0x8cbd ,0x8e },
{0x8cbe ,0x3a },
{0x8cbf ,0xf5 },
{0x8cc0 ,0x39 },
{0x8cc1 ,0xf5 },
{0x8cc2 ,0x38 },
{0x8cc3 ,0x22 },
{0x8cc4 ,0x75 },
{0x8cc5 ,0x89 },
{0x8cc6 ,0x03 },
{0x8cc7 ,0x75 },
{0x8cc8 ,0xa8 },
{0x8cc9 ,0x01 },
{0x8cca ,0x75 },
{0x8ccb ,0xb8 },
{0x8ccc ,0x04 },
{0x8ccd ,0x75 },
{0x8cce ,0x34 },
{0x8ccf ,0xff },
{0x8cd0 ,0x75 },
{0x8cd1 ,0x35 },
{0x8cd2 ,0x0e },
{0x8cd3 ,0x75 },
{0x8cd4 ,0x36 },
{0x8cd5 ,0x15 },
{0x8cd6 ,0x75 },
{0x8cd7 ,0x37 },
{0x8cd8 ,0x0d },
{0x8cd9 ,0x12 },
{0x8cda ,0x0d },
{0x8cdb ,0xaa },
{0x8cdc ,0x12 },
{0x8cdd ,0x00 },
{0x8cde ,0x09 },
{0x8cdf ,0x12 },
{0x8ce0 ,0x0b },
{0x8ce1 ,0xcc },
{0x8ce2 ,0x12 },
{0x8ce3 ,0x00 },
{0x8ce4 ,0x06 },
{0x8ce5 ,0xd2 },
{0x8ce6 ,0x00 },
{0x8ce7 ,0xd2 },
{0x8ce8 ,0x34 },
{0x8ce9 ,0xd2 },
{0x8cea ,0xaf },
{0x8ceb ,0x75 },
{0x8cec ,0x34 },
{0x8ced ,0xff },
{0x8cee ,0x75 },
{0x8cef ,0x35 },
{0x8cf0 ,0x0e },
{0x8cf1 ,0x75 },
{0x8cf2 ,0x36 },
{0x8cf3 ,0x49 },
{0x8cf4 ,0x75 },
{0x8cf5 ,0x37 },
{0x8cf6 ,0x03 },
{0x8cf7 ,0x12 },
{0x8cf8 ,0x0d },
{0x8cf9 ,0xaa },
{0x8cfa ,0x30 },
{0x8cfb ,0x08 },
{0x8cfc ,0x09 },
{0x8cfd ,0xc2 },
{0x8cfe ,0x34 },
{0x8cff ,0x12 },
{0x8d00 ,0x09 },
{0x8d01 ,0xee },
{0x8d02 ,0xc2 },
{0x8d03 ,0x08 },
{0x8d04 ,0xd2 },
{0x8d05 ,0x34 },
{0x8d06 ,0x30 },
{0x8d07 ,0x0b },
{0x8d08 ,0x09 },
{0x8d09 ,0xc2 },
{0x8d0a ,0x36 },
{0x8d0b ,0x12 },
{0x8d0c ,0x00 },
{0x8d0d ,0x0e },
{0x8d0e ,0xc2 },
{0x8d0f ,0x0b },
{0x8d10 ,0xd2 },
{0x8d11 ,0x36 },
{0x8d12 ,0x30 },
{0x8d13 ,0x09 },
{0x8d14 ,0x09 },
{0x8d15 ,0xc2 },
{0x8d16 ,0x36 },
{0x8d17 ,0x12 },
{0x8d18 ,0x02 },
{0x8d19 ,0xa7 },
{0x8d1a ,0xc2 },
{0x8d1b ,0x09 },
{0x8d1c ,0xd2 },
{0x8d1d ,0x36 },
{0x8d1e ,0x30 },
{0x8d1f ,0x0e },
{0x8d20 ,0x03 },
{0x8d21 ,0x12 },
{0x8d22 ,0x07 },
{0x8d23 ,0x38 },
{0x8d24 ,0x30 },
{0x8d25 ,0x35 },
{0x8d26 ,0xd3 },
{0x8d27 ,0x90 },
{0x8d28 ,0x30 },
{0x8d29 ,0x29 },
{0x8d2a ,0xe5 },
{0x8d2b ,0x1e },
{0x8d2c ,0xf0 },
{0x8d2d ,0xb4 },
{0x8d2e ,0x10 },
{0x8d2f ,0x05 },
{0x8d30 ,0x90 },
{0x8d31 ,0x30 },
{0x8d32 ,0x23 },
{0x8d33 ,0xe4 },
{0x8d34 ,0xf0 },
{0x8d35 ,0xc2 },
{0x8d36 ,0x35 },
{0x8d37 ,0x80 },
{0x8d38 ,0xc1 },
{0x8d39 ,0xe4 },
{0x8d3a ,0xf5 },
{0x8d3b ,0x4b },
{0x8d3c ,0x90 },
{0x8d3d ,0x0e },
{0x8d3e ,0x7a },
{0x8d3f ,0x93 },
{0x8d40 ,0xff },
{0x8d41 ,0xe4 },
{0x8d42 ,0x8f },
{0x8d43 ,0x37 },
{0x8d44 ,0xf5 },
{0x8d45 ,0x36 },
{0x8d46 ,0xf5 },
{0x8d47 ,0x35 },
{0x8d48 ,0xf5 },
{0x8d49 ,0x34 },
{0x8d4a ,0xaf },
{0x8d4b ,0x37 },
{0x8d4c ,0xae },
{0x8d4d ,0x36 },
{0x8d4e ,0xad },
{0x8d4f ,0x35 },
{0x8d50 ,0xac },
{0x8d51 ,0x34 },
{0x8d52 ,0x90 },
{0x8d53 ,0x0e },
{0x8d54 ,0x6a },
{0x8d55 ,0x12 },
{0x8d56 ,0x0f },
{0x8d57 ,0xa6 },
{0x8d58 ,0x8f },
{0x8d59 ,0x37 },
{0x8d5a ,0x8e },
{0x8d5b ,0x36 },
{0x8d5c ,0x8d },
{0x8d5d ,0x35 },
{0x8d5e ,0x8c },
{0x8d5f ,0x34 },
{0x8d60 ,0x90 },
{0x8d61 ,0x0e },
{0x8d62 ,0x72 },
{0x8d63 ,0x12 },
{0x8d64 ,0x06 },
{0x8d65 ,0xdd },
{0x8d66 ,0xef },
{0x8d67 ,0x45 },
{0x8d68 ,0x37 },
{0x8d69 ,0xf5 },
{0x8d6a ,0x37 },
{0x8d6b ,0xee },
{0x8d6c ,0x45 },
{0x8d6d ,0x36 },
{0x8d6e ,0xf5 },
{0x8d6f ,0x36 },
{0x8d70 ,0xed },
{0x8d71 ,0x45 },
{0x8d72 ,0x35 },
{0x8d73 ,0xf5 },
{0x8d74 ,0x35 },
{0x8d75 ,0xec },
{0x8d76 ,0x45 },
{0x8d77 ,0x34 },
{0x8d78 ,0xf5 },
{0x8d79 ,0x34 },
{0x8d7a ,0xe4 },
{0x8d7b ,0xf5 },
{0x8d7c ,0x22 },
{0x8d7d ,0xf5 },
{0x8d7e ,0x23 },
{0x8d7f ,0x85 },
{0x8d80 ,0x37 },
{0x8d81 ,0x31 },
{0x8d82 ,0x85 },
{0x8d83 ,0x36 },
{0x8d84 ,0x30 },
{0x8d85 ,0x85 },
{0x8d86 ,0x35 },
{0x8d87 ,0x2f },
{0x8d88 ,0x85 },
{0x8d89 ,0x34 },
{0x8d8a ,0x2e },
{0x8d8b ,0x12 },
{0x8d8c ,0x0f },
{0x8d8d ,0x63 },
{0x8d8e ,0xe4 },
{0x8d8f ,0xf5 },
{0x8d90 ,0x22 },
{0x8d91 ,0xf5 },
{0x8d92 ,0x23 },
{0x8d93 ,0x90 },
{0x8d94 ,0x0e },
{0x8d95 ,0x72 },
{0x8d96 ,0x12 },
{0x8d97 ,0x0f },
{0x8d98 ,0x9a },
{0x8d99 ,0x12 },
{0x8d9a ,0x0f },
{0x8d9b ,0x63 },
{0x8d9c ,0xe4 },
{0x8d9d ,0xf5 },
{0x8d9e ,0x22 },
{0x8d9f ,0xf5 },
{0x8da0 ,0x23 },
{0x8da1 ,0x90 },
{0x8da2 ,0x0e },
{0x8da3 ,0x6e },
{0x8da4 ,0x12 },
{0x8da5 ,0x0f },
{0x8da6 ,0x9a },
{0x8da7 ,0x02 },
{0x8da8 ,0x0f },
{0x8da9 ,0x63 },
{0x8daa ,0xae },
{0x8dab ,0x35 },
{0x8dac ,0xaf },
{0x8dad ,0x36 },
{0x8dae ,0xe4 },
{0x8daf ,0xfd },
{0x8db0 ,0xed },
{0x8db1 ,0xc3 },
{0x8db2 ,0x95 },
{0x8db3 ,0x37 },
{0x8db4 ,0x50 },
{0x8db5 ,0x33 },
{0x8db6 ,0x12 },
{0x8db7 ,0x0f },
{0x8db8 ,0xec },
{0x8db9 ,0xe4 },
{0x8dba ,0x93 },
{0x8dbb ,0xf5 },
{0x8dbc ,0x38 },
{0x8dbd ,0x74 },
{0x8dbe ,0x01 },
{0x8dbf ,0x93 },
{0x8dc0 ,0xf5 },
{0x8dc1 ,0x39 },
{0x8dc2 ,0x45 },
{0x8dc3 ,0x38 },
{0x8dc4 ,0x60 },
{0x8dc5 ,0x23 },
{0x8dc6 ,0x85 },
{0x8dc7 ,0x39 },
{0x8dc8 ,0x82 },
{0x8dc9 ,0x85 },
{0x8dca ,0x38 },
{0x8dcb ,0x83 },
{0x8dcc ,0xe0 },
{0x8dcd ,0xfc },
{0x8dce ,0x12 },
{0x8dcf ,0x0f },
{0x8dd0 ,0xec },
{0x8dd1 ,0x74 },
{0x8dd2 ,0x03 },
{0x8dd3 ,0x93 },
{0x8dd4 ,0x52 },
{0x8dd5 ,0x04 },
{0x8dd6 ,0x12 },
{0x8dd7 ,0x0f },
{0x8dd8 ,0xec },
{0x8dd9 ,0x74 },
{0x8dda ,0x02 },
{0x8ddb ,0x93 },
{0x8ddc ,0x42 },
{0x8ddd ,0x04 },
{0x8dde ,0x85 },
{0x8ddf ,0x39 },
{0x8de0 ,0x82 },
{0x8de1 ,0x85 },
{0x8de2 ,0x38 },
{0x8de3 ,0x83 },
{0x8de4 ,0xec },
{0x8de5 ,0xf0 },
{0x8de6 ,0x0d },
{0x8de7 ,0x80 },
{0x8de8 ,0xc7 },
{0x8de9 ,0x22 },
{0x8dea ,0xc0 },
{0x8deb ,0xe0 },
{0x8dec ,0xc0 },
{0x8ded ,0x83 },
{0x8dee ,0xc0 },
{0x8def ,0x82 },
{0x8df0 ,0x90 },
{0x8df1 ,0x3f },
{0x8df2 ,0x0d },
{0x8df3 ,0xe0 },
{0x8df4 ,0xf5 },
{0x8df5 ,0x33 },
{0x8df6 ,0xe5 },
{0x8df7 ,0x33 },
{0x8df8 ,0xf0 },
{0x8df9 ,0xd0 },
{0x8dfa ,0x82 },
{0x8dfb ,0xd0 },
{0x8dfc ,0x83 },
{0x8dfd ,0xd0 },
{0x8dfe ,0xe0 },
{0x8dff ,0x32 },
{0x8e00 ,0x12 },
{0x8e01 ,0x04 },
{0x8e02 ,0x13 },
{0x8e03 ,0x10 },
{0x8e04 ,0x01 },
{0x8e05 ,0x03 },
{0x8e06 ,0x4f },
{0x8e07 ,0x56 },
{0x8e08 ,0x54 },
{0x8e09 ,0x20 },
{0x8e0a ,0x20 },
{0x8e0b ,0x20 },
{0x8e0c ,0x20 },
{0x8e0d ,0x20 },
{0x8e0e ,0x13 },
{0x8e0f ,0x01 },
{0x8e10 ,0x10 },
{0x8e11 ,0x01 },
{0x8e12 ,0x56 },
{0x8e13 ,0x40 },
{0x8e14 ,0x1a },
{0x8e15 ,0x30 },
{0x8e16 ,0x29 },
{0x8e17 ,0x7e },
{0x8e18 ,0x00 },
{0x8e19 ,0x30 },
{0x8e1a ,0x04 },
{0x8e1b ,0x20 },
{0x8e1c ,0xdf },
{0x8e1d ,0x30 },
{0x8e1e ,0x05 },
{0x8e1f ,0x40 },
{0x8e20 ,0xbf },
{0x8e21 ,0x50 },
{0x8e22 ,0x03 },
{0x8e23 ,0x00 },
{0x8e24 ,0xfd },
{0x8e25 ,0x50 },
{0x8e26 ,0x27 },
{0x8e27 ,0x01 },
{0x8e28 ,0xfe },
{0x8e29 ,0x60 },
{0x8e2a ,0x00 },
{0x8e2b ,0x11 },
{0x8e2c ,0x00 },
{0x8e2d ,0x3f },
{0x8e2e ,0x05 },
{0x8e2f ,0x30 },
{0x8e30 ,0x00 },
{0x8e31 ,0x3f },
{0x8e32 ,0x06 },
{0x8e33 ,0x22 },
{0x8e34 ,0x00 },
{0x8e35 ,0x3f },
{0x8e36 ,0x01 },
{0x8e37 ,0x2a },
{0x8e38 ,0x00 },
{0x8e39 ,0x3f },
{0x8e3a ,0x02 },
{0x8e3b ,0x00 },
{0x8e3c ,0x00 },
{0x8e3d ,0x36 },
{0x8e3e ,0x06 },
{0x8e3f ,0x07 },
{0x8e40 ,0x00 },
{0x8e41 ,0x3f },
{0x8e42 ,0x0b },
{0x8e43 ,0x0f },
{0x8e44 ,0xf0 },
{0x8e45 ,0x00 },
{0x8e46 ,0x00 },
{0x8e47 ,0x00 },
{0x8e48 ,0x00 },
{0x8e49 ,0x30 },
{0x8e4a ,0x01 },
{0x8e4b ,0x40 },
{0x8e4c ,0xbf },
{0x8e4d ,0x30 },
{0x8e4e ,0x01 },
{0x8e4f ,0x00 },
{0x8e50 ,0xbf },
{0x8e51 ,0x30 },
{0x8e52 ,0x29 },
{0x8e53 ,0x70 },
{0x8e54 ,0x00 },
{0x8e55 ,0x3a },
{0x8e56 ,0x00 },
{0x8e57 ,0x00 },
{0x8e58 ,0xff },
{0x8e59 ,0x3a },
{0x8e5a ,0x00 },
{0x8e5b ,0x00 },
{0x8e5c ,0xff },
{0x8e5d ,0x36 },
{0x8e5e ,0x03 },
{0x8e5f ,0x36 },
{0x8e60 ,0x02 },
{0x8e61 ,0x41 },
{0x8e62 ,0x44 },
{0x8e63 ,0x58 },
{0x8e64 ,0x20 },
{0x8e65 ,0x18 },
{0x8e66 ,0x10 },
{0x8e67 ,0x0a },
{0x8e68 ,0x04 },
{0x8e69 ,0x04 },
{0x8e6a ,0x00 },
{0x8e6b ,0x03 },
{0x8e6c ,0xff },
{0x8e6d ,0x64 },
{0x8e6e ,0x00 },
{0x8e6f ,0x00 },
{0x8e70 ,0x80 },
{0x8e71 ,0x00 },
{0x8e72 ,0x00 },
{0x8e73 ,0x00 },
{0x8e74 ,0x00 },
{0x8e75 ,0x00 },
{0x8e76 ,0x00 },
{0x8e77 ,0x02 },
{0x8e78 ,0x04 },
{0x8e79 ,0x06 },
{0x8e7a ,0x06 },
{0x8e7b ,0x00 },
{0x8e7c ,0x02 },
{0x8e7d ,0x60 },
{0x8e7e ,0x00 },
{0x8e7f ,0x70 },
{0x8e80 ,0x50 },
{0x8e81 ,0x3c },
{0x8e82 ,0x28 },
{0x8e83 ,0x1e },
{0x8e84 ,0x10 },
{0x8e85 ,0x10 },
{0x8e86 ,0x50 },
{0x8e87 ,0x2d },
{0x8e88 ,0x28 },
{0x8e89 ,0x16 },
{0x8e8a ,0x10 },
{0x8e8b ,0x10 },
{0x8e8c ,0x02 },
{0x8e8d ,0x00 },
{0x8e8e ,0x10 },
{0x8e8f ,0x30 },
{0x8e90 ,0x0a },
{0x8e91 ,0x04 },
{0x8e92 ,0x05 },
{0x8e93 ,0x08 },
{0x8e94 ,0x64 },
{0x8e95 ,0x18 },
{0x8e96 ,0x05 },
{0x8e97 ,0x01 },
{0x8e98 ,0x00 },
{0x8e99 ,0xa5 },
{0x8e9a ,0x5a },
{0x8e9b ,0x00 },
{0x8e9c ,0x78 },
{0x8e9d ,0xbe },
{0x8e9e ,0xe6 },
{0x8e9f ,0xd3 },
{0x8ea0 ,0x08 },
{0x8ea1 ,0xff },
{0x8ea2 ,0xe6 },
{0x8ea3 ,0x64 },
{0x8ea4 ,0x80 },
{0x8ea5 ,0xf8 },
{0x8ea6 ,0xef },
{0x8ea7 ,0x64 },
{0x8ea8 ,0x80 },
{0x8ea9 ,0x98 },
{0x8eaa ,0x22 },
{0x8eab ,0x78 },
{0x8eac ,0xc0 },
{0x8ead ,0xa6 },
{0x8eae ,0x07 },
{0x8eaf ,0x78 },
{0x8eb0 ,0xbd },
{0x8eb1 ,0xd3 },
{0x8eb2 ,0xe6 },
{0x8eb3 ,0x64 },
{0x8eb4 ,0x80 },
{0x8eb5 ,0x94 },
{0x8eb6 ,0x80 },
{0x8eb7 ,0x22 },
{0x8eb8 ,0x93 },
{0x8eb9 ,0xff },
{0x8eba ,0x7e },
{0x8ebb ,0x00 },
{0x8ebc ,0xe6 },
{0x8ebd ,0xfc },
{0x8ebe ,0x08 },
{0x8ebf ,0xe6 },
{0x8ec0 ,0xfd },
{0x8ec1 ,0x12 },
{0x8ec2 ,0x05 },
{0x8ec3 ,0x22 },
{0x8ec4 ,0x78 },
{0x8ec5 ,0xc1 },
{0x8ec6 ,0xe6 },
{0x8ec7 ,0xfc },
{0x8ec8 ,0x08 },
{0x8ec9 ,0xe6 },
{0x8eca ,0xfd },
{0x8ecb ,0xd3 },
{0x8ecc ,0xef },
{0x8ecd ,0x9d },
{0x8ece ,0xee },
{0x8ecf ,0x9c },
{0x8ed0 ,0x22 },
{0x8ed1 ,0x78 },
{0x8ed2 ,0xbf },
{0x8ed3 ,0xa6 },
{0x8ed4 ,0x07 },
{0x8ed5 ,0x08 },
{0x8ed6 ,0xd3 },
{0x8ed7 ,0xe6 },
{0x8ed8 ,0x64 },
{0x8ed9 ,0x80 },
{0x8eda ,0x94 },
{0x8edb ,0x80 },
{0x8edc ,0x22 },
{0x8edd ,0x78 },
{0x8ede ,0xc0 },
{0x8edf ,0xa6 },
{0x8ee0 ,0x07 },
{0x8ee1 ,0xc3 },
{0x8ee2 ,0x18 },
{0x8ee3 ,0xe6 },
{0x8ee4 ,0x64 },
{0x8ee5 ,0x80 },
{0x8ee6 ,0x94 },
{0x8ee7 ,0xb3 },
{0x8ee8 ,0x22 },
{0x8ee9 ,0x78 },
{0x8eea ,0xbf },
{0x8eeb ,0xa6 },
{0x8eec ,0x07 },
{0x8eed ,0xc3 },
{0x8eee ,0x08 },
{0x8eef ,0xe6 },
{0x8ef0 ,0x64 },
{0x8ef1 ,0x80 },
{0x8ef2 ,0x94 },
{0x8ef3 ,0xb3 },
{0x8ef4 ,0x22 },
{0x8ef5 ,0x25 },
{0x8ef6 ,0xe0 },
{0x8ef7 ,0x24 },
{0x8ef8 ,0x0a },
{0x8ef9 ,0xf8 },
{0x8efa ,0xe6 },
{0x8efb ,0xfe },
{0x8efc ,0x08 },
{0x8efd ,0xe6 },
{0x8efe ,0xff },
{0x8eff ,0x22 },
{0x8f00 ,0xe5 },
{0x8f01 ,0x40 },
{0x8f02 ,0x24 },
{0x8f03 ,0xf2 },
{0x8f04 ,0xf5 },
{0x8f05 ,0x37 },
{0x8f06 ,0xe5 },
{0x8f07 ,0x3f },
{0x8f08 ,0x34 },
{0x8f09 ,0x43 },
{0x8f0a ,0xf5 },
{0x8f0b ,0x36 },
{0x8f0c ,0xe5 },
{0x8f0d ,0x3e },
{0x8f0e ,0x34 },
{0x8f0f ,0xa2 },
{0x8f10 ,0xf5 },
{0x8f11 ,0x35 },
{0x8f12 ,0xe5 },
{0x8f13 ,0x3d },
{0x8f14 ,0x34 },
{0x8f15 ,0x28 },
{0x8f16 ,0xf5 },
{0x8f17 ,0x34 },
{0x8f18 ,0xe5 },
{0x8f19 ,0x37 },
{0x8f1a ,0xff },
{0x8f1b ,0xe4 },
{0x8f1c ,0xfe },
{0x8f1d ,0xfd },
{0x8f1e ,0xfc },
{0x8f1f ,0x78 },
{0x8f20 ,0x18 },
{0x8f21 ,0x12 },
{0x8f22 ,0x06 },
{0x8f23 ,0xca },
{0x8f24 ,0x8f },
{0x8f25 ,0x40 },
{0x8f26 ,0x8e },
{0x8f27 ,0x3f },
{0x8f28 ,0x8d },
{0x8f29 ,0x3e },
{0x8f2a ,0x8c },
{0x8f2b ,0x3d },
{0x8f2c ,0xe5 },
{0x8f2d ,0x37 },
{0x8f2e ,0x54 },
{0x8f2f ,0xa0 },
{0x8f30 ,0xff },
{0x8f31 ,0xe5 },
{0x8f32 ,0x36 },
{0x8f33 ,0xfe },
{0x8f34 ,0xe4 },
{0x8f35 ,0xfd },
{0x8f36 ,0xfc },
{0x8f37 ,0x78 },
{0x8f38 ,0x07 },
{0x8f39 ,0x12 },
{0x8f3a ,0x06 },
{0x8f3b ,0xb7 },
{0x8f3c ,0x78 },
{0x8f3d ,0x10 },
{0x8f3e ,0x12 },
{0x8f3f ,0x0f },
{0x8f40 ,0xac },
{0x8f41 ,0xe4 },
{0x8f42 ,0xff },
{0x8f43 ,0xfe },
{0x8f44 ,0xe5 },
{0x8f45 ,0x35 },
{0x8f46 ,0xfd },
{0x8f47 ,0xe4 },
{0x8f48 ,0xfc },
{0x8f49 ,0x78 },
{0x8f4a ,0x0e },
{0x8f4b ,0x12 },
{0x8f4c ,0x06 },
{0x8f4d ,0xb7 },
{0x8f4e ,0x12 },
{0x8f4f ,0x0f },
{0x8f50 ,0xaf },
{0x8f51 ,0xe4 },
{0x8f52 ,0xff },
{0x8f53 ,0xfe },
{0x8f54 ,0xfd },
{0x8f55 ,0xe5 },
{0x8f56 ,0x34 },
{0x8f57 ,0xfc },
{0x8f58 ,0x78 },
{0x8f59 ,0x18 },
{0x8f5a ,0x12 },
{0x8f5b ,0x06 },
{0x8f5c ,0xb7 },
{0x8f5d ,0x78 },
{0x8f5e ,0x08 },
{0x8f5f ,0x12 },
{0x8f60 ,0x0f },
{0x8f61 ,0xac },
{0x8f62 ,0x22 },
{0x8f63 ,0xa2 },
{0x8f64 ,0xaf },
{0x8f65 ,0x92 },
{0x8f66 ,0x32 },
{0x8f67 ,0xc2 },
{0x8f68 ,0xaf },
{0x8f69 ,0xe5 },
{0x8f6a ,0x23 },
{0x8f6b ,0x45 },
{0x8f6c ,0x22 },
{0x8f6d ,0x90 },
{0x8f6e ,0x0e },
{0x8f6f ,0x5d },
{0x8f70 ,0x60 },
{0x8f71 ,0x0e },
{0x8f72 ,0x12 },
{0x8f73 ,0x0f },
{0x8f74 ,0xc7 },
{0x8f75 ,0xe0 },
{0x8f76 ,0xf5 },
{0x8f77 ,0x2c },
{0x8f78 ,0x12 },
{0x8f79 ,0x0f },
{0x8f7a ,0xc4 },
{0x8f7b ,0xe0 },
{0x8f7c ,0xf5 },
{0x8f7d ,0x2d },
{0x8f7e ,0x80 },
{0x8f7f ,0x0c },
{0x8f80 ,0x12 },
{0x8f81 ,0x0f },
{0x8f82 ,0xc7 },
{0x8f83 ,0xe5 },
{0x8f84 ,0x30 },
{0x8f85 ,0xf0 },
{0x8f86 ,0x12 },
{0x8f87 ,0x0f },
{0x8f88 ,0xc4 },
{0x8f89 ,0xe5 },
{0x8f8a ,0x31 },
{0x8f8b ,0xf0 },
{0x8f8c ,0xa2 },
{0x8f8d ,0x32 },
{0x8f8e ,0x92 },
{0x8f8f ,0xaf },
{0x8f90 ,0x22 },
{0x8f91 ,0x8f },
{0x8f92 ,0x3b },
{0x8f93 ,0x8e },
{0x8f94 ,0x3a },
{0x8f95 ,0x8d },
{0x8f96 ,0x39 },
{0x8f97 ,0x8c },
{0x8f98 ,0x38 },
{0x8f99 ,0x22 },
{0x8f9a ,0x12 },
{0x8f9b ,0x06 },
{0x8f9c ,0xdd },
{0x8f9d ,0x8f },
{0x8f9e ,0x31 },
{0x8f9f ,0x8e },
{0x8fa0 ,0x30 },
{0x8fa1 ,0x8d },
{0x8fa2 ,0x2f },
{0x8fa3 ,0x8c },
{0x8fa4 ,0x2e },
{0x8fa5 ,0x22 },
{0x8fa6 ,0x93 },
{0x8fa7 ,0xf9 },
{0x8fa8 ,0xf8 },
{0x8fa9 ,0x02 },
{0x8faa ,0x06 },
{0x8fab ,0xca },
{0x8fac ,0x12 },
{0x8fad ,0x06 },
{0x8fae ,0xca },
{0x8faf ,0xe5 },
{0x8fb0 ,0x40 },
{0x8fb1 ,0x2f },
{0x8fb2 ,0xf5 },
{0x8fb3 ,0x40 },
{0x8fb4 ,0xe5 },
{0x8fb5 ,0x3f },
{0x8fb6 ,0x3e },
{0x8fb7 ,0xf5 },
{0x8fb8 ,0x3f },
{0x8fb9 ,0xe5 },
{0x8fba ,0x3e },
{0x8fbb ,0x3d },
{0x8fbc ,0xf5 },
{0x8fbd ,0x3e },
{0x8fbe ,0xe5 },
{0x8fbf ,0x3d },
{0x8fc0 ,0x3c },
{0x8fc1 ,0xf5 },
{0x8fc2 ,0x3d },
{0x8fc3 ,0x22 },
{0x8fc4 ,0x90 },
{0x8fc5 ,0x0e },
{0x8fc6 ,0x5f },
{0x8fc7 ,0xe4 },
{0x8fc8 ,0x93 },
{0x8fc9 ,0xfe },
{0x8fca ,0x74 },
{0x8fcb ,0x01 },
{0x8fcc ,0x93 },
{0x8fcd ,0xf5 },
{0x8fce ,0x82 },
{0x8fcf ,0x8e },
{0x8fd0 ,0x83 },
{0x8fd1 ,0x22 },
{0x8fd2 ,0xd2 },
{0x8fd3 ,0x01 },
{0x8fd4 ,0xc2 },
{0x8fd5 ,0x02 },
{0x8fd6 ,0xe4 },
{0x8fd7 ,0xf5 },
{0x8fd8 ,0x1f },
{0x8fd9 ,0xf5 },
{0x8fda ,0x1e },
{0x8fdb ,0xd2 },
{0x8fdc ,0x35 },
{0x8fdd ,0xd2 },
{0x8fde ,0x33 },
{0x8fdf ,0x22 },
{0x8fe0 ,0x78 },
{0x8fe1 ,0x7f },
{0x8fe2 ,0xe4 },
{0x8fe3 ,0xf6 },
{0x8fe4 ,0xd8 },
{0x8fe5 ,0xfd },
{0x8fe6 ,0x75 },
{0x8fe7 ,0x81 },
{0x8fe8 ,0xcd },
{0x8fe9 ,0x02 },
{0x8fea ,0x0c },
{0x8feb ,0xc4 },
{0x8fec ,0x8f },
{0x8fed ,0x82 },
{0x8fee ,0x8e },
{0x8fef ,0x83 },
{0x8ff0 ,0x75 },
{0x8ff1 ,0xf0 },
{0x8ff2 ,0x04 },
{0x8ff3 ,0xed },
{0x8ff4 ,0x02 },
{0x8ff5 ,0x07 },
{0x8ff6 ,0x06 },
{0x3022 ,0x00 },
{0x3023 ,0x00 },
{0x3024 ,0x00 },
{0x3025 ,0x00 },
{0x3026 ,0x00 },
{0x3027 ,0x00 },
{0x3028 ,0x00 },
{0x3029 ,0x7F },
{0x3000 ,0x00 },
{0x3004, 0xff },
{0x3005, 0xF7 },

{0xFF, 0xFF}
};
