/* ---------------------------------------------------------------------------- */
/*                  Atmel Microcontroller Software Support                      */
/*                       SAM Software Package License                           */
/* ---------------------------------------------------------------------------- */
/* Copyright (c) %copyright_year%, Atmel Corporation                                        */
/*                                                                              */
/* All rights reserved.                                                         */
/*                                                                              */
/* Redistribution and use in source and binary forms, with or without           */
/* modification, are permitted provided that the following condition is met:    */
/*                                                                              */
/* - Redistributions of source code must retain the above copyright notice,     */
/* this list of conditions and the disclaimer below.                            */
/*                                                                              */
/* Atmel's name may not be used to endorse or promote products derived from     */
/* this software without specific prior written permission.                     */
/*                                                                              */
/* DISCLAIMER:  THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR   */
/* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE   */
/* DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,      */
/* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,  */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    */
/* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING         */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, */
/* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                           */
/* ---------------------------------------------------------------------------- */

#ifndef _SAMA5D4_
#define _SAMA5D4_

/** \addtogroup SAMA5D4_definitions SAMA5D4 definitions
  This file defines all structures and symbols for SAMA5D4:
    - registers and bitfields
    - peripheral base address
    - peripheral ID
    - PIO definitions
*/
/*@{*/

#ifdef __cplusplus
 extern "C" {
#endif 

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
#include <stdint.h>
#ifdef __cplusplus
  #define __I  volatile       /**< Defines 'read-only'  permissions */
#else
  #define __I  volatile const /**< Defines 'read-only'  permissions */
#endif
#define   __O  volatile       /**< Defines 'write-only' permissions */
#define   __IO volatile       /**< Defines 'read/write' permissions */
#endif

#define REG_SFR_AICREDIR        (0xF8028054U)
typedef enum IRQn
{
  FIQ_IRQn             =  0, /**<  0 SAMA5D4 FIQ Interrupt ID (FIQ) */
  SYS_IRQn             =  1, /**<  1 SAMA5D4 System Controller Interrupt (SYS) */
  ARM_IRQn             =  2, /**<  2 SAMA5D4 Performance Monitor Unit (ARM) */
  PIT_IRQn             =  3, /**<  3 SAMA5D4 Periodic Interval Timer Interrupt (PIT) */
  WDT_IRQn             =  4, /**<  4 SAMA5D4 Watchdog timer Interrupt (WDT) */
  PIOD_IRQn            =  5, /**<  5 SAMA5D4 Parallel I/O Controller D (PIOD) */
  USART0_IRQn          =  6, /**<  6 SAMA5D4 USART 0 (USART0) */
  USART1_IRQn          =  7, /**<  7 SAMA5D4 USART 1 (USART1) */
  XDMAC0_IRQn          =  8, /**<  8 SAMA5D4 DMA Controller 0 (XDMAC0) */
  ICM_IRQn             =  9, /**<  9 SAMA5D4 Integritry Check Monitor (ICM) */
  AES_IRQn             = 12, /**< 12 SAMA5D4 Advanced Encryption Standard (AES) */
  AESB_IRQn            = 13, /**< 13 SAMA5D4 AES bridge (AESB) */
  TDES_IRQn            = 14, /**< 14 SAMA5D4 Triple Data Encryption Standard (TDES) */
  SHA_IRQn             = 15, /**< 15 SAMA5D4 SHA Signature (SHA) */
  MPDDRC_IRQn          = 16, /**< 16 SAMA5D4 MPDDR controller (MPDDRC) */
  MATRIX1_IRQn         = 17, /**< 17 SAMA5D4 H32MX, 32-bit AHB Matrix (MATRIX1) */
  MATRIX0_IRQn         = 18, /**< 18 SAMA5D4 H64MX, 64-bit AHB Matrix (MATRIX0) */
  VDEC_IRQn            = 19, /**< 19 SAMA5D4 Video Decoder (VDEC) */
  HSMC_IRQn            = 22, /**< 22 SAMA5D4 Multi-bit ECC Interrupt (HSMC) */
  PIOA_IRQn            = 23, /**< 23 SAMA5D4 Parallel I/O Controller A (PIOA) */
  PIOB_IRQn            = 24, /**< 24 SAMA5D4 Parallel I/O Controller B (PIOB) */
  PIOC_IRQn            = 25, /**< 25 SAMA5D4 Parallel I/O Controller C (PIOC) */
  PIOE_IRQn            = 26, /**< 26 SAMA5D4 Parallel I/O Controller E (PIOE) */
  UART0_IRQn           = 27, /**< 27 SAMA5D4 UART 0 (UART0) */
  UART1_IRQn           = 28, /**< 28 SAMA5D4 UART 1 (UART1) */
  USART2_IRQn          = 29, /**< 29 SAMA5D4 USART 2 (USART2) */
  USART3_IRQn          = 30, /**< 30 SAMA5D4 USART 3 (USART3) */
  USART4_IRQn          = 31, /**< 31 SAMA5D4 USART 4 (USART4) */
  TWI0_IRQn            = 32, /**< 32 SAMA5D4 Two-Wire Interface 0 (TWI0) */
  TWI1_IRQn            = 33, /**< 33 SAMA5D4 Two-Wire Interface 1 (TWI1) */
  TWI2_IRQn            = 34, /**< 34 SAMA5D4 Two-Wire Interface 2 (TWI2) */
  HSMCI0_IRQn          = 35, /**< 35 SAMA5D4 High Speed Multimedia Card Interface 0 (HSMCI0) */
  HSMCI1_IRQn          = 36, /**< 36 SAMA5D4 High Speed Multimedia Card Interface 1 (HSMCI1) */
  SPI0_IRQn            = 37, /**< 37 SAMA5D4 Serial Peripheral Interface 0 (SPI0) */
  SPI1_IRQn            = 38, /**< 38 SAMA5D4 Serial Peripheral Interface 1 (SPI1) */
  SPI2_IRQn            = 39, /**< 39 SAMA5D4 Serial Peripheral Interface 2 (SPI2) */
  TC0_IRQn             = 40, /**< 40 SAMA5D4 Timer Counter 0 (ch. 0, 1, 2) (TC0) */
  TC1_IRQn             = 41, /**< 41 SAMA5D4 Timer Counter 1 (ch. 3, 4, 5) (TC1) */
  TC2_IRQn             = 42, /**< 42 SAMA5D4 Timer Counter 2 (ch. 6, 7, 8) (TC2) */
  PWM_IRQn             = 43, /**< 43 SAMA5D4 Pulse Width Modulation Controller (PWM) */
  ADC_IRQn             = 44, /**< 44 SAMA5D4 Touch Screen ADC Controller (ADC) */
  DBGU_IRQn            = 45, /**< 45 SAMA5D4 Debug Unit Interrupt (DBGU) */
  UHPHS_IRQn           = 46, /**< 46 SAMA5D4 USB Host High Speed (UHPHS) */
  UDPHS_IRQn           = 47, /**< 47 SAMA5D4 USB Device High Speed (UDPHS) */
  SSC0_IRQn            = 48, /**< 48 SAMA5D4 Synchronous Serial Controller 0 (SSC0) */
  SSC1_IRQn            = 49, /**< 49 SAMA5D4 Synchronous Serial Controller 1 (SSC1) */
  XDMAC1_IRQn          = 50, /**< 50 SAMA5D4 DMA Controller 1 (XDMAC1) */
  LCDC_IRQn            = 51, /**< 51 SAMA5D4 LCD Controller (LCDC) */
  ISI_IRQn             = 52, /**< 52 SAMA5D4 Camera Interface (ISI) */
  TRNG_IRQn            = 53, /**< 53 SAMA5D4 True Random Number Generator (TRNG) */
  GMAC0_IRQn           = 54, /**< 54 SAMA5D4 Ethernet MAC 0 (GMAC0) */
  GMAC1_IRQn           = 55, /**< 55 SAMA5D4 Ethernet MAC 1 (GMAC1) */
  IRQ_IRQn             = 56, /**< 56 SAMA5D4 IRQ Interrupt ID (IRQ) */
  SFC_IRQn             = 57, /**< 57 SAMA5D4 Fuse Controller (SFC) */
  SMD_IRQn             = 61, /**< 61 SAMA5D4 SMD Soft Modem (SMD) */
  TWI3_IRQn            = 62, /**< 62 SAMA5D4 Two-Wire Interface 3 (TWI3) */
  CATB_IRQn            = 63, /**< 63 SAMA5D4 Capacitive Touch Controller (CATB) */
  SFR_IRQn             = 64, /**< 64 SAMA5D4 Special Function Register  (SFR) */
  AIC_IRQn             = 65, /**< 65 SAMA5D4 Advanced Interrupt Controller  (AIC) */
  SAIC_IRQn            = 66, /**< 66 SAMA5D4 Secured Advanced Interrupt Controller  (SAIC) */
  L2CC_IRQn            = 67, /**< 67 SAMA5D4 L2 Cache Controller  (L2CC) */

  PERIPH_COUNT_IRQn    = 68  /**< Number of peripheral IDs */
} IRQn_Type;

/* ************************************************************************** */
/**  SOFTWARE PERIPHERAL API DEFINITION FOR SAMA5D4 */
/* ************************************************************************** */
/** \addtogroup SAMA5D4_api Peripheral Software API */
/*@{*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Analog-to-Digital Converter */
/* ============================================================================= */
/** \addtogroup SAMA5D4_ADC Analog-to-Digital Converter */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Adc hardware registers */
typedef struct {
  __O  uint32_t ADC_CR;        /**< \brief (Adc Offset: 0x00) Control Register */
  __IO uint32_t ADC_MR;        /**< \brief (Adc Offset: 0x04) Mode Register */
  __IO uint32_t ADC_SEQR1;     /**< \brief (Adc Offset: 0x08) Channel Sequence Register 1 */
  __IO uint32_t ADC_SEQR2;     /**< \brief (Adc Offset: 0x0C) Channel Sequence Register 2 */
  __O  uint32_t ADC_CHER;      /**< \brief (Adc Offset: 0x10) Channel Enable Register */
  __O  uint32_t ADC_CHDR;      /**< \brief (Adc Offset: 0x14) Channel Disable Register */
  __I  uint32_t ADC_CHSR;      /**< \brief (Adc Offset: 0x18) Channel Status Register */
  __I  uint32_t Reserved1[1];
  __I  uint32_t ADC_LCDR;      /**< \brief (Adc Offset: 0x20) Last Converted Data Register */
  __O  uint32_t ADC_IER;       /**< \brief (Adc Offset: 0x24) Interrupt Enable Register */
  __O  uint32_t ADC_IDR;       /**< \brief (Adc Offset: 0x28) Interrupt Disable Register */
  __I  uint32_t ADC_IMR;       /**< \brief (Adc Offset: 0x2C) Interrupt Mask Register */
  __I  uint32_t ADC_ISR;       /**< \brief (Adc Offset: 0x30) Interrupt Status Register */
  __I  uint32_t Reserved2[2];
  __I  uint32_t ADC_OVER;      /**< \brief (Adc Offset: 0x3C) Overrun Status Register */
  __IO uint32_t ADC_EMR;       /**< \brief (Adc Offset: 0x40) Extended Mode Register */
  __IO uint32_t ADC_CWR;       /**< \brief (Adc Offset: 0x44) Compare Window Register */
  __I  uint32_t Reserved3[2];
  __I  uint32_t ADC_CDR[5];    /**< \brief (Adc Offset: 0x50) Channel Data Register */
  __I  uint32_t Reserved4[12];
  __IO uint32_t ADC_ACR;       /**< \brief (Adc Offset: 0x94) Analog Control Register */
  __I  uint32_t Reserved5[6];
  __IO uint32_t ADC_TSMR;      /**< \brief (Adc Offset: 0xB0) Touchscreen Mode Register */
  __I  uint32_t ADC_XPOSR;     /**< \brief (Adc Offset: 0xB4) Touchscreen X Position Register */
  __I  uint32_t ADC_YPOSR;     /**< \brief (Adc Offset: 0xB8) Touchscreen Y Position Register */
  __I  uint32_t ADC_PRESSR;    /**< \brief (Adc Offset: 0xBC) Touchscreen Pressure Register */
  __IO uint32_t ADC_TRGR;      /**< \brief (Adc Offset: 0xC0) Trigger Register */
  __I  uint32_t Reserved6[8];
  __IO uint32_t ADC_WPMR;      /**< \brief (Adc Offset: 0xE4) Write Protect Mode Register */
  __I  uint32_t ADC_WPSR;      /**< \brief (Adc Offset: 0xE8) Write Protect Status Register */
} Adc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- ADC_CR : (ADC Offset: 0x00) Control Register -------- */
#define ADC_CR_SWRST (0x1u << 0) /**< \brief (ADC_CR) Software Reset */
#define ADC_CR_START (0x1u << 1) /**< \brief (ADC_CR) Start Conversion */
#define ADC_CR_TSCALIB (0x1u << 2) /**< \brief (ADC_CR) Touchscreen Calibration */
/* -------- ADC_MR : (ADC Offset: 0x04) Mode Register -------- */
#define ADC_MR_TRGSEL_Pos 1
#define ADC_MR_TRGSEL_Msk (0x7u << ADC_MR_TRGSEL_Pos) /**< \brief (ADC_MR) Trigger Selection */
#define   ADC_MR_TRGSEL_ADC_TRIG0 (0x0u << 1) /**< \brief (ADC_MR) ADTRG */
#define   ADC_MR_TRGSEL_ADC_TRIG1 (0x1u << 1) /**< \brief (ADC_MR) TIOA0 */
#define   ADC_MR_TRGSEL_ADC_TRIG2 (0x2u << 1) /**< \brief (ADC_MR) TIOA1 */
#define   ADC_MR_TRGSEL_ADC_TRIG3 (0x3u << 1) /**< \brief (ADC_MR) TIOA2 */
#define   ADC_MR_TRGSEL_ADC_TRIG4 (0x4u << 1) /**< \brief (ADC_MR) PWM event line 0 */
#define   ADC_MR_TRGSEL_ADC_TRIG5 (0x5u << 1) /**< \brief (ADC_MR) PWM_even line 1 */
#define ADC_MR_LOWRES (0x1u << 4) /**< \brief (ADC_MR) Resolution */
#define   ADC_MR_LOWRES_BITS_10 (0x0u << 4) /**< \brief (ADC_MR) 10-bit resolution. For higher resolution by interpolation, please refer to "ADC Extended Mode Register" on page 79 */
#define   ADC_MR_LOWRES_BITS_8 (0x1u << 4) /**< \brief (ADC_MR) 8-bit resolution */
#define ADC_MR_SLEEP (0x1u << 5) /**< \brief (ADC_MR) Sleep Mode */
#define   ADC_MR_SLEEP_NORMAL (0x0u << 5) /**< \brief (ADC_MR) Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions */
#define   ADC_MR_SLEEP_SLEEP (0x1u << 5) /**< \brief (ADC_MR) Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions */
#define ADC_MR_PRESCAL_Pos 8
#define ADC_MR_PRESCAL_Msk (0xffu << ADC_MR_PRESCAL_Pos) /**< \brief (ADC_MR) Prescaler Rate Selection */
#define ADC_MR_PRESCAL(value) ((ADC_MR_PRESCAL_Msk & ((value) << ADC_MR_PRESCAL_Pos)))
#define ADC_MR_STARTUP_Pos 16
#define ADC_MR_STARTUP_Msk (0xfu << ADC_MR_STARTUP_Pos) /**< \brief (ADC_MR) Start Up Time */
#define   ADC_MR_STARTUP_SUT0 (0x0u << 16) /**< \brief (ADC_MR) 0 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT8 (0x1u << 16) /**< \brief (ADC_MR) 8 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT16 (0x2u << 16) /**< \brief (ADC_MR) 16 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT24 (0x3u << 16) /**< \brief (ADC_MR) 24 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT64 (0x4u << 16) /**< \brief (ADC_MR) 64 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT80 (0x5u << 16) /**< \brief (ADC_MR) 80 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT96 (0x6u << 16) /**< \brief (ADC_MR) 96 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT112 (0x7u << 16) /**< \brief (ADC_MR) 112 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT512 (0x8u << 16) /**< \brief (ADC_MR) 512 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT576 (0x9u << 16) /**< \brief (ADC_MR) 576 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT640 (0xAu << 16) /**< \brief (ADC_MR) 640 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT704 (0xBu << 16) /**< \brief (ADC_MR) 704 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT768 (0xCu << 16) /**< \brief (ADC_MR) 768 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT832 (0xDu << 16) /**< \brief (ADC_MR) 832 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT896 (0xEu << 16) /**< \brief (ADC_MR) 896 periods of ADCClock */
#define   ADC_MR_STARTUP_SUT960 (0xFu << 16) /**< \brief (ADC_MR) 960 periods of ADCClock */
#define ADC_MR_DIV1 (0x1u << 22) /**< \brief (ADC_MR)  */
#define ADC_MR_TRACKTIM_Pos 24
#define ADC_MR_TRACKTIM_Msk (0xfu << ADC_MR_TRACKTIM_Pos) /**< \brief (ADC_MR) Tracking Time */
#define ADC_MR_TRACKTIM(value) ((ADC_MR_TRACKTIM_Msk & ((value) << ADC_MR_TRACKTIM_Pos)))
#define ADC_MR_USEQ (0x1u << 31) /**< \brief (ADC_MR) Use Sequence Enable */
#define   ADC_MR_USEQ_NUM_ORDER (0x0u << 31) /**< \brief (ADC_MR) Normal Mode: The controller converts channels in a simple numeric order depending only on the channel index. */
#define   ADC_MR_USEQ_REG_ORDER (0x1u << 31) /**< \brief (ADC_MR) User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers and can be used to convert several times the same channel. */
/* -------- ADC_SEQR1 : (ADC Offset: 0x08) Channel Sequence Register 1 -------- */
#define ADC_SEQR1_USCH1_Pos 0
#define ADC_SEQR1_USCH1_Msk (0xfu << ADC_SEQR1_USCH1_Pos) /**< \brief (ADC_SEQR1) User Sequence Number 1 */
#define ADC_SEQR1_USCH1(value) ((ADC_SEQR1_USCH1_Msk & ((value) << ADC_SEQR1_USCH1_Pos)))
#define ADC_SEQR1_USCH2_Pos 4
#define ADC_SEQR1_USCH2_Msk (0xfu << ADC_SEQR1_USCH2_Pos) /**< \brief (ADC_SEQR1) User Sequence Number 2 */
#define ADC_SEQR1_USCH2(value) ((ADC_SEQR1_USCH2_Msk & ((value) << ADC_SEQR1_USCH2_Pos)))
#define ADC_SEQR1_USCH3_Pos 8
#define ADC_SEQR1_USCH3_Msk (0xfu << ADC_SEQR1_USCH3_Pos) /**< \brief (ADC_SEQR1) User Sequence Number 3 */
#define ADC_SEQR1_USCH3(value) ((ADC_SEQR1_USCH3_Msk & ((value) << ADC_SEQR1_USCH3_Pos)))
#define ADC_SEQR1_USCH4_Pos 12
#define ADC_SEQR1_USCH4_Msk (0xfu << ADC_SEQR1_USCH4_Pos) /**< \brief (ADC_SEQR1) User Sequence Number 4 */
#define ADC_SEQR1_USCH4(value) ((ADC_SEQR1_USCH4_Msk & ((value) << ADC_SEQR1_USCH4_Pos)))
/* -------- ADC_CHER : (ADC Offset: 0x10) Channel Enable Register -------- */
#define ADC_CHER_CH0 (0x1u << 0) /**< \brief (ADC_CHER) Channel 0 Enable */
#define ADC_CHER_CH1 (0x1u << 1) /**< \brief (ADC_CHER) Channel 1 Enable */
#define ADC_CHER_CH2 (0x1u << 2) /**< \brief (ADC_CHER) Channel 2 Enable */
#define ADC_CHER_CH3 (0x1u << 3) /**< \brief (ADC_CHER) Channel 3 Enable */
#define ADC_CHER_CH4 (0x1u << 4) /**< \brief (ADC_CHER) Channel 4 Enable */
/* -------- ADC_CHDR : (ADC Offset: 0x14) Channel Disable Register -------- */
#define ADC_CHDR_CH0 (0x1u << 0) /**< \brief (ADC_CHDR) Channel 0 Disable */
#define ADC_CHDR_CH1 (0x1u << 1) /**< \brief (ADC_CHDR) Channel 1 Disable */
#define ADC_CHDR_CH2 (0x1u << 2) /**< \brief (ADC_CHDR) Channel 2 Disable */
#define ADC_CHDR_CH3 (0x1u << 3) /**< \brief (ADC_CHDR) Channel 3 Disable */
#define ADC_CHDR_CH4 (0x1u << 4) /**< \brief (ADC_CHDR) Channel 4 Disable */
/* -------- ADC_CHSR : (ADC Offset: 0x18) Channel Status Register -------- */
#define ADC_CHSR_CH0 (0x1u << 0) /**< \brief (ADC_CHSR) Channel 0 Status */
#define ADC_CHSR_CH1 (0x1u << 1) /**< \brief (ADC_CHSR) Channel 1 Status */
#define ADC_CHSR_CH2 (0x1u << 2) /**< \brief (ADC_CHSR) Channel 2 Status */
#define ADC_CHSR_CH3 (0x1u << 3) /**< \brief (ADC_CHSR) Channel 3 Status */
#define ADC_CHSR_CH4 (0x1u << 4) /**< \brief (ADC_CHSR) Channel 4 Status */
/* -------- ADC_LCDR : (ADC Offset: 0x20) Last Converted Data Register -------- */
#define ADC_LCDR_LDATA_Pos 0
#define ADC_LCDR_LDATA_Msk (0x3ffu << ADC_LCDR_LDATA_Pos) /**< \brief (ADC_LCDR) Last Data Converted */
#define ADC_LCDR_CHNB_Pos 12
#define ADC_LCDR_CHNB_Msk (0xfu << ADC_LCDR_CHNB_Pos) /**< \brief (ADC_LCDR) Channel Number */
/* -------- ADC_IER : (ADC Offset: 0x24) Interrupt Enable Register -------- */
#define ADC_IER_EOC0 (0x1u << 0) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 0 */
#define ADC_IER_EOC1 (0x1u << 1) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 1 */
#define ADC_IER_EOC2 (0x1u << 2) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 2 */
#define ADC_IER_EOC3 (0x1u << 3) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 3 */
#define ADC_IER_EOC4 (0x1u << 4) /**< \brief (ADC_IER) End of Conversion Interrupt Enable 4 */
#define ADC_IER_XRDY (0x1u << 20) /**< \brief (ADC_IER) Touchscreen Measure XPOS Ready Interrupt Enable */
#define ADC_IER_YRDY (0x1u << 21) /**< \brief (ADC_IER) Touchscreen Measure YPOS Ready Interrupt Enable */
#define ADC_IER_PRDY (0x1u << 22) /**< \brief (ADC_IER) Touchscreen Measure Pressure Ready Interrupt Enable */
#define ADC_IER_DRDY (0x1u << 24) /**< \brief (ADC_IER) Data Ready Interrupt Enable */
#define ADC_IER_GOVRE (0x1u << 25) /**< \brief (ADC_IER) General Overrun Error Interrupt Enable */
#define ADC_IER_COMPE (0x1u << 26) /**< \brief (ADC_IER) Comparison Event Interrupt Enable */
#define ADC_IER_PEN (0x1u << 29) /**< \brief (ADC_IER) Pen Contact Interrupt Enable */
#define ADC_IER_NOPEN (0x1u << 30) /**< \brief (ADC_IER) No Pen Contact Interrupt Enable */
/* -------- ADC_IDR : (ADC Offset: 0x28) Interrupt Disable Register -------- */
#define ADC_IDR_EOC0 (0x1u << 0) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 0 */
#define ADC_IDR_EOC1 (0x1u << 1) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 1 */
#define ADC_IDR_EOC2 (0x1u << 2) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 2 */
#define ADC_IDR_EOC3 (0x1u << 3) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 3 */
#define ADC_IDR_EOC4 (0x1u << 4) /**< \brief (ADC_IDR) End of Conversion Interrupt Disable 4 */
#define ADC_IDR_XRDY (0x1u << 20) /**< \brief (ADC_IDR) Touchscreen Measure XPOS Ready Interrupt Disable */
#define ADC_IDR_YRDY (0x1u << 21) /**< \brief (ADC_IDR) Touchscreen Measure YPOS Ready Interrupt Disable */
#define ADC_IDR_PRDY (0x1u << 22) /**< \brief (ADC_IDR) Touchscreen Measure Pressure Ready Interrupt Disable */
#define ADC_IDR_DRDY (0x1u << 24) /**< \brief (ADC_IDR) Data Ready Interrupt Disable */
#define ADC_IDR_GOVRE (0x1u << 25) /**< \brief (ADC_IDR) General Overrun Error Interrupt Disable */
#define ADC_IDR_COMPE (0x1u << 26) /**< \brief (ADC_IDR) Comparison Event Interrupt Disable */
#define ADC_IDR_PEN (0x1u << 29) /**< \brief (ADC_IDR) Pen Contact Interrupt Disable */
#define ADC_IDR_NOPEN (0x1u << 30) /**< \brief (ADC_IDR) No Pen Contact Interrupt Disable */
/* -------- ADC_IMR : (ADC Offset: 0x2C) Interrupt Mask Register -------- */
#define ADC_IMR_EOC0 (0x1u << 0) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 0 */
#define ADC_IMR_EOC1 (0x1u << 1) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 1 */
#define ADC_IMR_EOC2 (0x1u << 2) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 2 */
#define ADC_IMR_EOC3 (0x1u << 3) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 3 */
#define ADC_IMR_EOC4 (0x1u << 4) /**< \brief (ADC_IMR) End of Conversion Interrupt Mask 4 */
#define ADC_IMR_XRDY (0x1u << 20) /**< \brief (ADC_IMR) Touchscreen Measure XPOS Ready Interrupt Mask */
#define ADC_IMR_YRDY (0x1u << 21) /**< \brief (ADC_IMR) Touchscreen Measure YPOS Ready Interrupt Mask */
#define ADC_IMR_PRDY (0x1u << 22) /**< \brief (ADC_IMR) Touchscreen Measure Pressure Ready Interrupt Mask */
#define ADC_IMR_DRDY (0x1u << 24) /**< \brief (ADC_IMR) Data Ready Interrupt Mask */
#define ADC_IMR_GOVRE (0x1u << 25) /**< \brief (ADC_IMR) General Overrun Error Interrupt Mask */
#define ADC_IMR_COMPE (0x1u << 26) /**< \brief (ADC_IMR) Comparison Event Interrupt Mask */
#define ADC_IMR_PEN (0x1u << 29) /**< \brief (ADC_IMR) Pen Contact Interrupt Mask */
#define ADC_IMR_NOPEN (0x1u << 30) /**< \brief (ADC_IMR) No Pen Contact Interrupt Mask */
/* -------- ADC_ISR : (ADC Offset: 0x30) Interrupt Status Register -------- */
#define ADC_ISR_EOC0 (0x1u << 0) /**< \brief (ADC_ISR) End of Conversion 0 */
#define ADC_ISR_EOC1 (0x1u << 1) /**< \brief (ADC_ISR) End of Conversion 1 */
#define ADC_ISR_EOC2 (0x1u << 2) /**< \brief (ADC_ISR) End of Conversion 2 */
#define ADC_ISR_EOC3 (0x1u << 3) /**< \brief (ADC_ISR) End of Conversion 3 */
#define ADC_ISR_EOC4 (0x1u << 4) /**< \brief (ADC_ISR) End of Conversion 4 */
#define ADC_ISR_XRDY (0x1u << 20) /**< \brief (ADC_ISR) Touchscreen XPOS Measure Ready */
#define ADC_ISR_YRDY (0x1u << 21) /**< \brief (ADC_ISR) Touchscreen YPOS Measure Ready */
#define ADC_ISR_PRDY (0x1u << 22) /**< \brief (ADC_ISR) Touchscreen Pressure Measure Ready */
#define ADC_ISR_DRDY (0x1u << 24) /**< \brief (ADC_ISR) Data Ready */
#define ADC_ISR_GOVRE (0x1u << 25) /**< \brief (ADC_ISR) General Overrun Error */
#define ADC_ISR_COMPE (0x1u << 26) /**< \brief (ADC_ISR) Comparison Error */
#define ADC_ISR_PEN (0x1u << 29) /**< \brief (ADC_ISR) Pen contact */
#define ADC_ISR_NOPEN (0x1u << 30) /**< \brief (ADC_ISR) No Pen contact */
#define ADC_ISR_PENS (0x1u << 31) /**< \brief (ADC_ISR) Pen detect Status */
/* -------- ADC_OVER : (ADC Offset: 0x3C) Overrun Status Register -------- */
#define ADC_OVER_OVRE0 (0x1u << 0) /**< \brief (ADC_OVER) Overrun Error 0 */
#define ADC_OVER_OVRE1 (0x1u << 1) /**< \brief (ADC_OVER) Overrun Error 1 */
#define ADC_OVER_OVRE2 (0x1u << 2) /**< \brief (ADC_OVER) Overrun Error 2 */
#define ADC_OVER_OVRE3 (0x1u << 3) /**< \brief (ADC_OVER) Overrun Error 3 */
#define ADC_OVER_OVRE4 (0x1u << 4) /**< \brief (ADC_OVER) Overrun Error 4 */
/* -------- ADC_EMR : (ADC Offset: 0x40) Extended Mode Register -------- */
#define ADC_EMR_CMPMODE_Pos 0
#define ADC_EMR_CMPMODE_Msk (0x3u << ADC_EMR_CMPMODE_Pos) /**< \brief (ADC_EMR) Comparison Mode */
#define   ADC_EMR_CMPMODE_LOW (0x0u << 0) /**< \brief (ADC_EMR) Generates an event when the converted data is lower than the low threshold of the window. */
#define   ADC_EMR_CMPMODE_HIGH (0x1u << 0) /**< \brief (ADC_EMR) Generates an event when the converted data is higher than the high threshold of the window. */
#define   ADC_EMR_CMPMODE_IN (0x2u << 0) /**< \brief (ADC_EMR) Generates an event when the converted data is in the comparison window. */
#define   ADC_EMR_CMPMODE_OUT (0x3u << 0) /**< \brief (ADC_EMR) Generates an event when the converted data is out of the comparison window. */
#define ADC_EMR_CMPSEL_Pos 4
#define ADC_EMR_CMPSEL_Msk (0xfu << ADC_EMR_CMPSEL_Pos) /**< \brief (ADC_EMR) Comparison Selected Channel */
#define ADC_EMR_CMPSEL(value) ((ADC_EMR_CMPSEL_Msk & ((value) << ADC_EMR_CMPSEL_Pos)))
#define ADC_EMR_CMPALL (0x1u << 9) /**< \brief (ADC_EMR) Compare All Channels */
#define ADC_EMR_CMPFILTER_Pos 12
#define ADC_EMR_CMPFILTER_Msk (0x3u << ADC_EMR_CMPFILTER_Pos) /**< \brief (ADC_EMR) Compare Event Filtering */
#define ADC_EMR_CMPFILTER(value) ((ADC_EMR_CMPFILTER_Msk & ((value) << ADC_EMR_CMPFILTER_Pos)))
#define ADC_EMR_OSR_Pos 16
#define ADC_EMR_OSR_Msk (0x3u << ADC_EMR_OSR_Pos) /**< \brief (ADC_EMR) Over Sampling Rate */
#define   ADC_EMR_OSR_NO_AVERAGE (0x0u << 16) /**< \brief (ADC_EMR) no averaging. ADC sample rate is maximum. */
#define   ADC_EMR_OSR_OSR4 (0x1u << 16) /**< \brief (ADC_EMR) 1-bit enhanced resolution by interpolation. ADC sample rate divided by 4. */
#define   ADC_EMR_OSR_OSR16 (0x2u << 16) /**< \brief (ADC_EMR) 2-bit enhanced resolution by interpolation. ADC sample rate divided by 16. */
#define ADC_EMR_ASTE (0x1u << 20) /**< \brief (ADC_EMR) Averaging on Single Trigger Event */
#define   ADC_EMR_ASTE_MULTI_TRIG_AVERAGE (0x0u << 20) /**< \brief (ADC_EMR) The average requests several trigger events. */
#define   ADC_EMR_ASTE_SINGLE_TRIG_AVERAGE (0x1u << 20) /**< \brief (ADC_EMR) The average requests only one trigger event. */
#define ADC_EMR_TAG (0x1u << 24) /**< \brief (ADC_EMR) TAG of the ADC_LDCR register */
/* -------- ADC_CWR : (ADC Offset: 0x44) Compare Window Register -------- */
#define ADC_CWR_LOWTHRES_Pos 0
#define ADC_CWR_LOWTHRES_Msk (0xfffu << ADC_CWR_LOWTHRES_Pos) /**< \brief (ADC_CWR) Low Threshold */
#define ADC_CWR_LOWTHRES(value) ((ADC_CWR_LOWTHRES_Msk & ((value) << ADC_CWR_LOWTHRES_Pos)))
#define ADC_CWR_HIGHTHRES_Pos 16
#define ADC_CWR_HIGHTHRES_Msk (0xfffu << ADC_CWR_HIGHTHRES_Pos) /**< \brief (ADC_CWR) High Threshold */
#define ADC_CWR_HIGHTHRES(value) ((ADC_CWR_HIGHTHRES_Msk & ((value) << ADC_CWR_HIGHTHRES_Pos)))
/* -------- ADC_CDR[5] : (ADC Offset: 0x50) Channel Data Register -------- */
#define ADC_CDR_DATA_Pos 0
#define ADC_CDR_DATA_Msk (0xfffu << ADC_CDR_DATA_Pos) /**< \brief (ADC_CDR[5]) Converted Data */
/* -------- ADC_ACR : (ADC Offset: 0x94) Analog Control Register -------- */
#define ADC_ACR_PENDETSENS_Pos 0
#define ADC_ACR_PENDETSENS_Msk (0x3u << ADC_ACR_PENDETSENS_Pos) /**< \brief (ADC_ACR) Pen Detection Sensitivity */
#define ADC_ACR_PENDETSENS(value) ((ADC_ACR_PENDETSENS_Msk & ((value) << ADC_ACR_PENDETSENS_Pos)))
/* -------- ADC_TSMR : (ADC Offset: 0xB0) Touchscreen Mode Register -------- */
#define ADC_TSMR_TSMODE_Pos 0
#define ADC_TSMR_TSMODE_Msk (0x3u << ADC_TSMR_TSMODE_Pos) /**< \brief (ADC_TSMR) Touchscreen Mode */
#define   ADC_TSMR_TSMODE_NONE (0x0u << 0) /**< \brief (ADC_TSMR) No Touchscreen */
#define   ADC_TSMR_TSMODE_4_WIRE_NO_PM (0x1u << 0) /**< \brief (ADC_TSMR) 4-wire Touchscreen without pressure measurement */
#define   ADC_TSMR_TSMODE_4_WIRE (0x2u << 0) /**< \brief (ADC_TSMR) 4-wire Touchscreen with pressure measurement */
#define   ADC_TSMR_TSMODE_5_WIRE (0x3u << 0) /**< \brief (ADC_TSMR) 5-wire Touchscreen */
#define ADC_TSMR_TSAV_Pos 4
#define ADC_TSMR_TSAV_Msk (0x3u << ADC_TSMR_TSAV_Pos) /**< \brief (ADC_TSMR) Touchscreen Average */
#define   ADC_TSMR_TSAV_NO_FILTER (0x0u << 4) /**< \brief (ADC_TSMR) No Filtering. Only one ADC conversion per measure */
#define   ADC_TSMR_TSAV_AVG2CONV (0x1u << 4) /**< \brief (ADC_TSMR) Averages 2 ADC conversions */
#define   ADC_TSMR_TSAV_AVG4CONV (0x2u << 4) /**< \brief (ADC_TSMR) Averages 4 ADC conversions */
#define   ADC_TSMR_TSAV_AVG8CONV (0x3u << 4) /**< \brief (ADC_TSMR) Averages 8 ADC conversions */
#define ADC_TSMR_TSFREQ_Pos 8
#define ADC_TSMR_TSFREQ_Msk (0xfu << ADC_TSMR_TSFREQ_Pos) /**< \brief (ADC_TSMR) Touchscreen Frequency */
#define ADC_TSMR_TSFREQ(value) ((ADC_TSMR_TSFREQ_Msk & ((value) << ADC_TSMR_TSFREQ_Pos)))
#define ADC_TSMR_TSSCTIM_Pos 16
#define ADC_TSMR_TSSCTIM_Msk (0xfu << ADC_TSMR_TSSCTIM_Pos) /**< \brief (ADC_TSMR) Touchscreen Switches Closure Time */
#define ADC_TSMR_TSSCTIM(value) ((ADC_TSMR_TSSCTIM_Msk & ((value) << ADC_TSMR_TSSCTIM_Pos)))
#define ADC_TSMR_NOTSDMA (0x1u << 22) /**< \brief (ADC_TSMR) No TouchScreen DMA */
#define ADC_TSMR_PENDET (0x1u << 24) /**< \brief (ADC_TSMR) Pen Contact Detection Enable */
#define ADC_TSMR_PENDBC_Pos 28
#define ADC_TSMR_PENDBC_Msk (0xfu << ADC_TSMR_PENDBC_Pos) /**< \brief (ADC_TSMR) Pen Detect Debouncing Period */
#define ADC_TSMR_PENDBC(value) ((ADC_TSMR_PENDBC_Msk & ((value) << ADC_TSMR_PENDBC_Pos)))
/* -------- ADC_XPOSR : (ADC Offset: 0xB4) Touchscreen X Position Register -------- */
#define ADC_XPOSR_XPOS_Pos 0
#define ADC_XPOSR_XPOS_Msk (0x3ffu << ADC_XPOSR_XPOS_Pos) /**< \brief (ADC_XPOSR) X Position */
#define ADC_XPOSR_XSCALE_Pos 16
#define ADC_XPOSR_XSCALE_Msk (0x3ffu << ADC_XPOSR_XSCALE_Pos) /**< \brief (ADC_XPOSR) Scale of XPOS */
/* -------- ADC_YPOSR : (ADC Offset: 0xB8) Touchscreen Y Position Register -------- */
#define ADC_YPOSR_YPOS_Pos 0
#define ADC_YPOSR_YPOS_Msk (0x3ffu << ADC_YPOSR_YPOS_Pos) /**< \brief (ADC_YPOSR) Y Position */
#define ADC_YPOSR_YSCALE_Pos 16
#define ADC_YPOSR_YSCALE_Msk (0x3ffu << ADC_YPOSR_YSCALE_Pos) /**< \brief (ADC_YPOSR) Scale of YPOS */
/* -------- ADC_PRESSR : (ADC Offset: 0xBC) Touchscreen Pressure Register -------- */
#define ADC_PRESSR_Z1_Pos 0
#define ADC_PRESSR_Z1_Msk (0x3ffu << ADC_PRESSR_Z1_Pos) /**< \brief (ADC_PRESSR) Data of Z1 Measurement */
#define ADC_PRESSR_Z2_Pos 16
#define ADC_PRESSR_Z2_Msk (0x3ffu << ADC_PRESSR_Z2_Pos) /**< \brief (ADC_PRESSR) Data of Z2 Measurement */
/* -------- ADC_TRGR : (ADC Offset: 0xC0) Trigger Register -------- */
#define ADC_TRGR_TRGMOD_Pos 0
#define ADC_TRGR_TRGMOD_Msk (0x7u << ADC_TRGR_TRGMOD_Pos) /**< \brief (ADC_TRGR) Trigger Mode */
#define   ADC_TRGR_TRGMOD_NO_TRIGGER (0x0u << 0) /**< \brief (ADC_TRGR) No trigger, only software trigger can start conversions */
#define   ADC_TRGR_TRGMOD_EXT_TRIG_RISE (0x1u << 0) /**< \brief (ADC_TRGR) External Trigger Rising Edge */
#define   ADC_TRGR_TRGMOD_EXT_TRIG_FALL (0x2u << 0) /**< \brief (ADC_TRGR) External Trigger Falling Edge */
#define   ADC_TRGR_TRGMOD_EXT_TRIG_ANY (0x3u << 0) /**< \brief (ADC_TRGR) External Trigger Any Edge */
#define   ADC_TRGR_TRGMOD_PEN_TRIG (0x4u << 0) /**< \brief (ADC_TRGR) Pen Detect Trigger (shall be selected only if PENDET is set and TSAMOD = Touchscreen only mode) */
#define   ADC_TRGR_TRGMOD_PERIOD_TRIG (0x5u << 0) /**< \brief (ADC_TRGR) Periodic Trigger (TRGPER shall be initiated appropriately) */
#define   ADC_TRGR_TRGMOD_CONTINUOUS (0x6u << 0) /**< \brief (ADC_TRGR) Continuous Mode */
#define ADC_TRGR_TRGPER_Pos 16
#define ADC_TRGR_TRGPER_Msk (0xffffu << ADC_TRGR_TRGPER_Pos) /**< \brief (ADC_TRGR) Trigger Period */
#define ADC_TRGR_TRGPER(value) ((ADC_TRGR_TRGPER_Msk & ((value) << ADC_TRGR_TRGPER_Pos)))
/* -------- ADC_WPMR : (ADC Offset: 0xE4) Write Protect Mode Register -------- */
#define ADC_WPMR_WPEN (0x1u << 0) /**< \brief (ADC_WPMR) Write Protect Enable */
#define ADC_WPMR_WPKEY_Pos 8
#define ADC_WPMR_WPKEY_Msk (0xffffffu << ADC_WPMR_WPKEY_Pos) /**< \brief (ADC_WPMR) Write Protect KEY */
#define ADC_WPMR_WPKEY(value) ((ADC_WPMR_WPKEY_Msk & ((value) << ADC_WPMR_WPKEY_Pos)))
/* -------- ADC_WPSR : (ADC Offset: 0xE8) Write Protect Status Register -------- */
#define ADC_WPSR_WPVS (0x1u << 0) /**< \brief (ADC_WPSR) Write Protect Violation Status */
#define ADC_WPSR_WPVSRC_Pos 8
#define ADC_WPSR_WPVSRC_Msk (0xffffu << ADC_WPSR_WPVSRC_Pos) /**< \brief (ADC_WPSR) Write Protect Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Advanced Encryption Standard */
/* ============================================================================= */
/** \addtogroup SAMA5D4_AES Advanced Encryption Standard */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Aes hardware registers */
typedef struct {
  __O  uint32_t AES_CR;        /**< \brief (Aes Offset: 0x00) Control Register */
  __IO uint32_t AES_MR;        /**< \brief (Aes Offset: 0x04) Mode Register */
  __I  uint32_t Reserved1[2];
  __O  uint32_t AES_IER;       /**< \brief (Aes Offset: 0x10) Interrupt Enable Register */
  __O  uint32_t AES_IDR;       /**< \brief (Aes Offset: 0x14) Interrupt Disable Register */
  __I  uint32_t AES_IMR;       /**< \brief (Aes Offset: 0x18) Interrupt Mask Register */
  __I  uint32_t AES_ISR;       /**< \brief (Aes Offset: 0x1C) Interrupt Status Register */
  __O  uint32_t AES_KEYWR[8];  /**< \brief (Aes Offset: 0x20) Key Word Register */
  __O  uint32_t AES_IDATAR[4]; /**< \brief (Aes Offset: 0x40) Input Data Register */
  __I  uint32_t AES_ODATAR[4]; /**< \brief (Aes Offset: 0x50) Output Data Register */
  __O  uint32_t AES_IVR[4];    /**< \brief (Aes Offset: 0x60) Initialization Vector Register */
  __IO uint32_t AES_AADLENR;   /**< \brief (Aes Offset: 0x70) Additional Authenticated Data Length Register */
  __IO uint32_t AES_CLENR;     /**< \brief (Aes Offset: 0x74) Plaintext/Ciphertext Length Register */
  __IO uint32_t AES_GHASHR[4]; /**< \brief (Aes Offset: 0x78) GCM Intermediate Hash Word Register */
  __I  uint32_t AES_TAGR[4];   /**< \brief (Aes Offset: 0x88) GCM Authentication Tag Word Register */
  __I  uint32_t AES_CTRR;      /**< \brief (Aes Offset: 0x98) GCM Encryption Counter Value Register */
  __IO uint32_t AES_GCMHR[4];  /**< \brief (Aes Offset: 0x9C) GCM H World Register */
} Aes;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- AES_CR : (AES Offset: 0x00) Control Register -------- */
#define AES_CR_START (0x1u << 0) /**< \brief (AES_CR) Start Processing */
#define AES_CR_SWRST (0x1u << 8) /**< \brief (AES_CR) Software Reset */
#define AES_CR_LOADSEED (0x1u << 16) /**< \brief (AES_CR) Random Number Generator Seed Loading */
/* -------- AES_MR : (AES Offset: 0x04) Mode Register -------- */
#define AES_MR_CIPHER (0x1u << 0) /**< \brief (AES_MR) Processing Mode */
#define AES_MR_GTAGEN (0x1u << 1) /**< \brief (AES_MR) GCM Automatic Tag Generation Enable */
#define AES_MR_DUALBUFF (0x1u << 3) /**< \brief (AES_MR) Dual Input BUFFer */
#define   AES_MR_DUALBUFF_INACTIVE (0x0u << 3) /**< \brief (AES_MR) AES_IDATARx cannot be written during processing of previous block. */
#define   AES_MR_DUALBUFF_ACTIVE (0x1u << 3) /**< \brief (AES_MR) AES_IDATARx can be written during processing of previous block when SMOD = 0x2. It speeds up the overall runtime of large files. */
#define AES_MR_PROCDLY_Pos 4
#define AES_MR_PROCDLY_Msk (0xfu << AES_MR_PROCDLY_Pos) /**< \brief (AES_MR) Processing Delay */
#define AES_MR_PROCDLY(value) ((AES_MR_PROCDLY_Msk & ((value) << AES_MR_PROCDLY_Pos)))
#define AES_MR_SMOD_Pos 8
#define AES_MR_SMOD_Msk (0x3u << AES_MR_SMOD_Pos) /**< \brief (AES_MR) Start Mode */
#define   AES_MR_SMOD_MANUAL_START (0x0u << 8) /**< \brief (AES_MR) Manual Mode */
#define   AES_MR_SMOD_AUTO_START (0x1u << 8) /**< \brief (AES_MR) Auto Mode */
#define   AES_MR_SMOD_IDATAR0_START (0x2u << 8) /**< \brief (AES_MR) AES_IDATAR0 access only Auto Mode */
#define AES_MR_KEYSIZE_Pos 10
#define AES_MR_KEYSIZE_Msk (0x3u << AES_MR_KEYSIZE_Pos) /**< \brief (AES_MR) Key Size */
#define   AES_MR_KEYSIZE_AES128 (0x0u << 10) /**< \brief (AES_MR) AES Key Size is 128 bits */
#define   AES_MR_KEYSIZE_AES192 (0x1u << 10) /**< \brief (AES_MR) AES Key Size is 192 bits */
#define   AES_MR_KEYSIZE_AES256 (0x2u << 10) /**< \brief (AES_MR) AES Key Size is 256 bits */
#define AES_MR_OPMOD_Pos 12
#define AES_MR_OPMOD_Msk (0x7u << AES_MR_OPMOD_Pos) /**< \brief (AES_MR) Operation Mode */
#define   AES_MR_OPMOD_ECB (0x0u << 12) /**< \brief (AES_MR) ECB: Electronic Code Book mode */
#define   AES_MR_OPMOD_CBC (0x1u << 12) /**< \brief (AES_MR) CBC: Cipher Block Chaining mode */
#define   AES_MR_OPMOD_OFB (0x2u << 12) /**< \brief (AES_MR) OFB: Output Feedback mode */
#define   AES_MR_OPMOD_CFB (0x3u << 12) /**< \brief (AES_MR) CFB: Cipher Feedback mode */
#define   AES_MR_OPMOD_CTR (0x4u << 12) /**< \brief (AES_MR) CTR: Counter mode (16-bit internal counter) */
#define   AES_MR_OPMOD_GCM (0x5u << 12) /**< \brief (AES_MR) GCM: Galois Counter mode */
#define AES_MR_LOD (0x1u << 15) /**< \brief (AES_MR) Last Output Data Mode */
#define AES_MR_CFBS_Pos 16
#define AES_MR_CFBS_Msk (0x7u << AES_MR_CFBS_Pos) /**< \brief (AES_MR) Cipher Feedback Data Size */
#define   AES_MR_CFBS_SIZE_128BIT (0x0u << 16) /**< \brief (AES_MR) 128-bit */
#define   AES_MR_CFBS_SIZE_64BIT (0x1u << 16) /**< \brief (AES_MR) 64-bit */
#define   AES_MR_CFBS_SIZE_32BIT (0x2u << 16) /**< \brief (AES_MR) 32-bit */
#define   AES_MR_CFBS_SIZE_16BIT (0x3u << 16) /**< \brief (AES_MR) 16-bit */
#define   AES_MR_CFBS_SIZE_8BIT (0x4u << 16) /**< \brief (AES_MR) 8-bit */
#define AES_MR_CKEY_Pos 20
#define AES_MR_CKEY_Msk (0xfu << AES_MR_CKEY_Pos) /**< \brief (AES_MR) Countermeasure Key */
#define   AES_MR_CKEY_PASSWD (0xEu << 20) /**< \brief (AES_MR) This field must be written with 0xE to allow CMTYPx fields change. Any other values will abort the write operation in CMTYPx fields.Always reads as 0. */
#define AES_MR_CMTYP1 (0x1u << 24) /**< \brief (AES_MR) Countermeasure Type 1 */
#define   AES_MR_CMTYP1_NOPROT_EXTKEY (0x0u << 24) /**< \brief (AES_MR) Countermeasure type 1 is disabled */
#define   AES_MR_CMTYP1_PROT_EXTKEY (0x1u << 24) /**< \brief (AES_MR) Countermeasure type 1 is enabled */
#define AES_MR_CMTYP2 (0x1u << 25) /**< \brief (AES_MR) Countermeasure Type 2 */
#define   AES_MR_CMTYP2_NO_PAUSE (0x0u << 25) /**< \brief (AES_MR) Countermeasure type 2 is disabled */
#define   AES_MR_CMTYP2_PAUSE (0x1u << 25) /**< \brief (AES_MR) Countermeasure type 2 is enabled */
#define AES_MR_CMTYP3 (0x1u << 26) /**< \brief (AES_MR) Countermeasure Type 3 */
#define   AES_MR_CMTYP3_NO_DUMMY (0x0u << 26) /**< \brief (AES_MR) Countermeasure type 3 is disabled */
#define   AES_MR_CMTYP3_DUMMY (0x1u << 26) /**< \brief (AES_MR) Countermeasure type 3 is enabled */
#define AES_MR_CMTYP4 (0x1u << 27) /**< \brief (AES_MR) Countermeasure Type 4 */
#define   AES_MR_CMTYP4_NO_RESTART (0x0u << 27) /**< \brief (AES_MR) Countermeasure type 4 is disabled */
#define   AES_MR_CMTYP4_RESTART (0x1u << 27) /**< \brief (AES_MR) Countermeasure type 4 is enabled */
#define AES_MR_CMTYP5 (0x1u << 28) /**< \brief (AES_MR) Countermeasure Type 5 */
#define   AES_MR_CMTYP5_NO_ADDACCESS (0x0u << 28) /**< \brief (AES_MR) Countermeasure type 5 is disabled */
#define   AES_MR_CMTYP5_ADDACCESS (0x1u << 28) /**< \brief (AES_MR) Countermeasure type 5 is enabled */
#define AES_MR_CMTYP6 (0x1u << 29) /**< \brief (AES_MR) CounterMeasure Type 6 */
#define   AES_MR_CMTYP6_NO_IDLECURRENT (0x0u << 29) /**< \brief (AES_MR) Countermeasure type 6 is disabled */
#define   AES_MR_CMTYP6_IDLECURRENT (0x1u << 29) /**< \brief (AES_MR) Countermeasure type 6 is enabled */
/* -------- AES_IER : (AES Offset: 0x10) Interrupt Enable Register -------- */
#define AES_IER_DATRDY (0x1u << 0) /**< \brief (AES_IER) Data Ready Interrupt Enable */
#define AES_IER_URAD (0x1u << 8) /**< \brief (AES_IER) Unspecified Register Access Detection Interrupt Enable */
/* -------- AES_IDR : (AES Offset: 0x14) Interrupt Disable Register -------- */
#define AES_IDR_DATRDY (0x1u << 0) /**< \brief (AES_IDR) Data Ready Interrupt Disable */
#define AES_IDR_URAD (0x1u << 8) /**< \brief (AES_IDR) Unspecified Register Access Detection Interrupt Disable */
/* -------- AES_IMR : (AES Offset: 0x18) Interrupt Mask Register -------- */
#define AES_IMR_DATRDY (0x1u << 0) /**< \brief (AES_IMR) Data Ready Interrupt Mask */
#define AES_IMR_URAD (0x1u << 8) /**< \brief (AES_IMR) Unspecified Register Access Detection Interrupt Mask */
/* -------- AES_ISR : (AES Offset: 0x1C) Interrupt Status Register -------- */
#define AES_ISR_DATRDY (0x1u << 0) /**< \brief (AES_ISR) Data Ready */
#define AES_ISR_URAD (0x1u << 8) /**< \brief (AES_ISR) Unspecified Register Access Detection Status */
#define AES_ISR_URAT_Pos 12
#define AES_ISR_URAT_Msk (0xfu << AES_ISR_URAT_Pos) /**< \brief (AES_ISR) Unspecified Register Access: */
#define   AES_ISR_URAT_IDR_WR_PROCESSING (0x0u << 12) /**< \brief (AES_ISR) Input Data Register written during the data processing when SMOD=0x2 mode. */
#define   AES_ISR_URAT_ODR_RD_PROCESSING (0x1u << 12) /**< \brief (AES_ISR) Output Data Register read during the data processing. */
#define   AES_ISR_URAT_MR_WR_PROCESSING (0x2u << 12) /**< \brief (AES_ISR) Mode Register written during the data processing. */
#define   AES_ISR_URAT_ODR_RD_SUBKGEN (0x3u << 12) /**< \brief (AES_ISR) Output Data Register read during the sub-keys generation. */
#define   AES_ISR_URAT_MR_WR_SUBKGEN (0x4u << 12) /**< \brief (AES_ISR) Mode Register written during the sub-keys generation. */
#define   AES_ISR_URAT_WOR_RD_ACCESS (0x5u << 12) /**< \brief (AES_ISR) Write-only register read access. */
#define AES_ISR_TAGRDY (0x1u << 16) /**< \brief (AES_ISR) GCM Tag Ready */
/* -------- AES_KEYWR[8] : (AES Offset: 0x20) Key Word Register -------- */
#define AES_KEYWR_KEYW_Pos 0
#define AES_KEYWR_KEYW_Msk (0xffffffffu << AES_KEYWR_KEYW_Pos) /**< \brief (AES_KEYWR[8]) Key Word */
#define AES_KEYWR_KEYW(value) ((AES_KEYWR_KEYW_Msk & ((value) << AES_KEYWR_KEYW_Pos)))
/* -------- AES_IDATAR[4] : (AES Offset: 0x40) Input Data Register -------- */
#define AES_IDATAR_IDATA_Pos 0
#define AES_IDATAR_IDATA_Msk (0xffffffffu << AES_IDATAR_IDATA_Pos) /**< \brief (AES_IDATAR[4]) Input Data Word */
#define AES_IDATAR_IDATA(value) ((AES_IDATAR_IDATA_Msk & ((value) << AES_IDATAR_IDATA_Pos)))
/* -------- AES_ODATAR[4] : (AES Offset: 0x50) Output Data Register -------- */
#define AES_ODATAR_ODATA_Pos 0
#define AES_ODATAR_ODATA_Msk (0xffffffffu << AES_ODATAR_ODATA_Pos) /**< \brief (AES_ODATAR[4]) Output Data */
/* -------- AES_IVR[4] : (AES Offset: 0x60) Initialization Vector Register -------- */
#define AES_IVR_IV_Pos 0
#define AES_IVR_IV_Msk (0xffffffffu << AES_IVR_IV_Pos) /**< \brief (AES_IVR[4]) Initialization Vector */
#define AES_IVR_IV(value) ((AES_IVR_IV_Msk & ((value) << AES_IVR_IV_Pos)))
/* -------- AES_AADLENR : (AES Offset: 0x70) Additional Authenticated Data Length Register -------- */
#define AES_AADLENR_AADLEN_Pos 0
#define AES_AADLENR_AADLEN_Msk (0xffffffffu << AES_AADLENR_AADLEN_Pos) /**< \brief (AES_AADLENR) AAD Length */
#define AES_AADLENR_AADLEN(value) ((AES_AADLENR_AADLEN_Msk & ((value) << AES_AADLENR_AADLEN_Pos)))
/* -------- AES_CLENR : (AES Offset: 0x74) Plaintext/Ciphertext Length Register -------- */
#define AES_CLENR_CLEN_Pos 0
#define AES_CLENR_CLEN_Msk (0xffffffffu << AES_CLENR_CLEN_Pos) /**< \brief (AES_CLENR) Plaintext/Ciphertext Length */
#define AES_CLENR_CLEN(value) ((AES_CLENR_CLEN_Msk & ((value) << AES_CLENR_CLEN_Pos)))
/* -------- AES_GHASHR[4] : (AES Offset: 0x78) GCM Intermediate Hash Word Register -------- */
#define AES_GHASHR_GHASH_Pos 0
#define AES_GHASHR_GHASH_Msk (0xffffffffu << AES_GHASHR_GHASH_Pos) /**< \brief (AES_GHASHR[4]) Intermediate GCM Hash Word x */
#define AES_GHASHR_GHASH(value) ((AES_GHASHR_GHASH_Msk & ((value) << AES_GHASHR_GHASH_Pos)))
/* -------- AES_TAGR[4] : (AES Offset: 0x88) GCM Authentication Tag Word Register -------- */
#define AES_TAGR_TAG_Pos 0
#define AES_TAGR_TAG_Msk (0xffffffffu << AES_TAGR_TAG_Pos) /**< \brief (AES_TAGR[4]) GCM Authentication Tag x */
/* -------- AES_CTRR : (AES Offset: 0x98) GCM Encryption Counter Value Register -------- */
#define AES_CTRR_CTR_Pos 0
#define AES_CTRR_CTR_Msk (0xffffffffu << AES_CTRR_CTR_Pos) /**< \brief (AES_CTRR) GCM Encryption Counter */
/* -------- AES_GCMHR[4] : (AES Offset: 0x9C) GCM H World Register -------- */
#define AES_GCMHR_H_Pos 0
#define AES_GCMHR_H_Msk (0xffffffffu << AES_GCMHR_H_Pos) /**< \brief (AES_GCMHR[4]) GCM H word x */
#define AES_GCMHR_H(value) ((AES_GCMHR_H_Msk & ((value) << AES_GCMHR_H_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Advanced Encryption Standard Bridge */
/* ============================================================================= */
/** \addtogroup SAMA5D4_AESB Advanced Encryption Standard Bridge */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Aesb hardware registers */
typedef struct {
  __O  uint32_t AESB_CR;        /**< \brief (Aesb Offset: 0x00) Control Register */
  __IO uint32_t AESB_MR;        /**< \brief (Aesb Offset: 0x04) Mode Register */
  __I  uint32_t Reserved1[2];
  __O  uint32_t AESB_IER;       /**< \brief (Aesb Offset: 0x10) Interrupt Enable Register */
  __O  uint32_t AESB_IDR;       /**< \brief (Aesb Offset: 0x14) Interrupt Disable Register */
  __I  uint32_t AESB_IMR;       /**< \brief (Aesb Offset: 0x18) Interrupt Mask Register */
  __I  uint32_t AESB_ISR;       /**< \brief (Aesb Offset: 0x1C) Interrupt Status Register */
  __O  uint32_t AESB_KEYWR[4];  /**< \brief (Aesb Offset: 0x20) Key Word Register */
  __I  uint32_t Reserved2[4];
  __O  uint32_t AESB_IDATAR[4]; /**< \brief (Aesb Offset: 0x40) Input Data Register */
  __I  uint32_t AESB_ODATAR[4]; /**< \brief (Aesb Offset: 0x50) Output Data Register */
  __O  uint32_t AESB_IVR[4];    /**< \brief (Aesb Offset: 0x60) Initialization Vector Register */
} Aesb;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- AESB_CR : (AESB Offset: 0x00) Control Register -------- */
#define AESB_CR_START (0x1u << 0) /**< \brief (AESB_CR) Start Processing */
#define AESB_CR_SWRST (0x1u << 8) /**< \brief (AESB_CR) Software Reset */
#define AESB_CR_LOADSEED (0x1u << 16) /**< \brief (AESB_CR) Random Number Generator Seed Loading */
/* -------- AESB_MR : (AESB Offset: 0x04) Mode Register -------- */
#define AESB_MR_CIPHER (0x1u << 0) /**< \brief (AESB_MR) Processing Mode */
#define AESB_MR_AAHB (0x1u << 2) /**< \brief (AESB_MR) Automatic Bridge Mode */
#define AESB_MR_DUALBUFF (0x1u << 3) /**< \brief (AESB_MR) Dual Input BUFFer */
#define   AESB_MR_DUALBUFF_INACTIVE (0x0u << 3) /**< \brief (AESB_MR) AESB_IDATARx cannot be written during processing of previous block. */
#define   AESB_MR_DUALBUFF_ACTIVE (0x1u << 3) /**< \brief (AESB_MR) AESB_IDATARx can be written during processing of previous block when SMOD = 0x2. It speeds up the overall runtime of large files. */
#define AESB_MR_PROCDLY_Pos 4
#define AESB_MR_PROCDLY_Msk (0xfu << AESB_MR_PROCDLY_Pos) /**< \brief (AESB_MR) Processing Delay */
#define AESB_MR_PROCDLY(value) ((AESB_MR_PROCDLY_Msk & ((value) << AESB_MR_PROCDLY_Pos)))
#define AESB_MR_SMOD_Pos 8
#define AESB_MR_SMOD_Msk (0x3u << AESB_MR_SMOD_Pos) /**< \brief (AESB_MR) Start Mode */
#define   AESB_MR_SMOD_MANUAL_START (0x0u << 8) /**< \brief (AESB_MR) Manual Mode */
#define   AESB_MR_SMOD_AUTO_START (0x1u << 8) /**< \brief (AESB_MR) Auto Mode */
#define   AESB_MR_SMOD_IDATAR0_START (0x2u << 8) /**< \brief (AESB_MR) AESB_IDATAR0 access only Auto Mode */
#define AESB_MR_OPMOD_Pos 12
#define AESB_MR_OPMOD_Msk (0x7u << AESB_MR_OPMOD_Pos) /**< \brief (AESB_MR) Operation Mode */
#define   AESB_MR_OPMOD_ECB (0x0u << 12) /**< \brief (AESB_MR) ECB: Electronic Code Book mode */
#define   AESB_MR_OPMOD_CBC (0x1u << 12) /**< \brief (AESB_MR) CBC: Cipher Block Chaining mode */
#define   AESB_MR_OPMOD_CTR (0x4u << 12) /**< \brief (AESB_MR) CTR: Counter mode (16-bit internal counter) */
#define AESB_MR_LOD (0x1u << 15) /**< \brief (AESB_MR) Last Output Data Mode */
#define AESB_MR_CKEY_Pos 20
#define AESB_MR_CKEY_Msk (0xfu << AESB_MR_CKEY_Pos) /**< \brief (AESB_MR) Countermeasure Key */
#define   AESB_MR_CKEY_PASSWD (0xEu << 20) /**< \brief (AESB_MR) This field must be written with 0xE to allow CMTYPx fields change. Any other values will abort the write operation in CMTYPx fields.Always reads as 0. */
#define AESB_MR_CMTYP1 (0x1u << 24) /**< \brief (AESB_MR) Countermeasure Type 1 */
#define   AESB_MR_CMTYP1_NOPROT_EXTKEY (0x0u << 24) /**< \brief (AESB_MR) Countermeasure type 1 is disabled. */
#define   AESB_MR_CMTYP1_PROT_EXTKEY (0x1u << 24) /**< \brief (AESB_MR) Countermeasure type 1 is enabled. */
#define AESB_MR_CMTYP2 (0x1u << 25) /**< \brief (AESB_MR) Countermeasure Type 2 */
#define   AESB_MR_CMTYP2_NO_PAUSE (0x0u << 25) /**< \brief (AESB_MR) Countermeasure type 2 is disabled. */
#define   AESB_MR_CMTYP2_PAUSE (0x1u << 25) /**< \brief (AESB_MR) Countermeasure type 2 is enabled. */
#define AESB_MR_CMTYP3 (0x1u << 26) /**< \brief (AESB_MR) Countermeasure Type 3 */
#define   AESB_MR_CMTYP3_NO_DUMMY (0x0u << 26) /**< \brief (AESB_MR) Countermeasure type 3 is disabled. */
#define   AESB_MR_CMTYP3_DUMMY (0x1u << 26) /**< \brief (AESB_MR) Countermeasure type 3 is enabled. */
#define AESB_MR_CMTYP4 (0x1u << 27) /**< \brief (AESB_MR) Countermeasure Type 4 */
#define   AESB_MR_CMTYP4_NO_RESTART (0x0u << 27) /**< \brief (AESB_MR) Countermeasure type 4 is disabled. */
#define   AESB_MR_CMTYP4_RESTART (0x1u << 27) /**< \brief (AESB_MR) Countermeasure type 4 is enabled. */
#define AESB_MR_CMTYP5 (0x1u << 28) /**< \brief (AESB_MR) Countermeasure Type 5 */
#define   AESB_MR_CMTYP5_NO_ADDACCESS (0x0u << 28) /**< \brief (AESB_MR) Countermeasure type 5 is disabled. */
#define   AESB_MR_CMTYP5_ADDACCESS (0x1u << 28) /**< \brief (AESB_MR) Countermeasure type 5 is enabled. */
#define AESB_MR_CMTYP6 (0x1u << 29) /**< \brief (AESB_MR) CounterMeasure Type 6 */
#define   AESB_MR_CMTYP6_NO_IDLECURRENT (0x0u << 29) /**< \brief (AESB_MR) Countermeasure type 6 is disabled. */
#define   AESB_MR_CMTYP6_IDLECURRENT (0x1u << 29) /**< \brief (AESB_MR) Countermeasure type 6 is enabled. */
/* -------- AESB_IER : (AESB Offset: 0x10) Interrupt Enable Register -------- */
#define AESB_IER_DATRDY (0x1u << 0) /**< \brief (AESB_IER) Data Ready Interrupt Enable */
#define AESB_IER_URAD (0x1u << 8) /**< \brief (AESB_IER) Unspecified Register Access Detection Interrupt Enable */
/* -------- AESB_IDR : (AESB Offset: 0x14) Interrupt Disable Register -------- */
#define AESB_IDR_DATRDY (0x1u << 0) /**< \brief (AESB_IDR) Data Ready Interrupt Disable */
#define AESB_IDR_URAD (0x1u << 8) /**< \brief (AESB_IDR) Unspecified Register Access Detection Interrupt Disable */
/* -------- AESB_IMR : (AESB Offset: 0x18) Interrupt Mask Register -------- */
#define AESB_IMR_DATRDY (0x1u << 0) /**< \brief (AESB_IMR) Data Ready Interrupt Mask */
#define AESB_IMR_URAD (0x1u << 8) /**< \brief (AESB_IMR) Unspecified Register Access Detection Interrupt Mask */
/* -------- AESB_ISR : (AESB Offset: 0x1C) Interrupt Status Register -------- */
#define AESB_ISR_DATRDY (0x1u << 0) /**< \brief (AESB_ISR) Data Ready */
#define AESB_ISR_URAD (0x1u << 8) /**< \brief (AESB_ISR) Unspecified Register Access Detection Status */
#define AESB_ISR_URAT_Pos 12
#define AESB_ISR_URAT_Msk (0xfu << AESB_ISR_URAT_Pos) /**< \brief (AESB_ISR) Unspecified Register Access: */
#define   AESB_ISR_URAT_IDR_WR_PROCESSING (0x0u << 12) /**< \brief (AESB_ISR) Input Data Register written during the data processing when SMOD=0x2 mode. */
#define   AESB_ISR_URAT_ODR_RD_PROCESSING (0x1u << 12) /**< \brief (AESB_ISR) Output Data Register read during the data processing. */
#define   AESB_ISR_URAT_MR_WR_PROCESSING (0x2u << 12) /**< \brief (AESB_ISR) Mode Register written during the data processing. */
#define   AESB_ISR_URAT_ODR_RD_SUBKGEN (0x3u << 12) /**< \brief (AESB_ISR) Output Data Register read during the sub-keys generation. */
#define   AESB_ISR_URAT_MR_WR_SUBKGEN (0x4u << 12) /**< \brief (AESB_ISR) Mode Register written during the sub-keys generation. */
#define   AESB_ISR_URAT_WOR_RD_ACCESS (0x5u << 12) /**< \brief (AESB_ISR) Write-only register read access. */
/* -------- AESB_KEYWR[4] : (AESB Offset: 0x20) Key Word Register -------- */
#define AESB_KEYWR_KEYW_Pos 0
#define AESB_KEYWR_KEYW_Msk (0xffffffffu << AESB_KEYWR_KEYW_Pos) /**< \brief (AESB_KEYWR[4]) Key Word */
#define AESB_KEYWR_KEYW(value) ((AESB_KEYWR_KEYW_Msk & ((value) << AESB_KEYWR_KEYW_Pos)))
/* -------- AESB_IDATAR[4] : (AESB Offset: 0x40) Input Data Register -------- */
#define AESB_IDATAR_IDATA_Pos 0
#define AESB_IDATAR_IDATA_Msk (0xffffffffu << AESB_IDATAR_IDATA_Pos) /**< \brief (AESB_IDATAR[4]) Input Data Word */
#define AESB_IDATAR_IDATA(value) ((AESB_IDATAR_IDATA_Msk & ((value) << AESB_IDATAR_IDATA_Pos)))
/* -------- AESB_ODATAR[4] : (AESB Offset: 0x50) Output Data Register -------- */
#define AESB_ODATAR_ODATA_Pos 0
#define AESB_ODATAR_ODATA_Msk (0xffffffffu << AESB_ODATAR_ODATA_Pos) /**< \brief (AESB_ODATAR[4]) Output Data */
/* -------- AESB_IVR[4] : (AESB Offset: 0x60) Initialization Vector Register -------- */
#define AESB_IVR_IV_Pos 0
#define AESB_IVR_IV_Msk (0xffffffffu << AESB_IVR_IV_Pos) /**< \brief (AESB_IVR[4]) Initialization Vector */
#define AESB_IVR_IV(value) ((AESB_IVR_IV_Msk & ((value) << AESB_IVR_IV_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Advanced Interrupt Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_AIC Advanced Interrupt Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Aic hardware registers */
typedef struct {
  __IO uint32_t AIC_SSR;       /**< \brief (Aic Offset: 0x00) Source Select Register */
  __IO uint32_t AIC_SMR;       /**< \brief (Aic Offset: 0x04) Source Mode Register */
  __IO uint32_t AIC_SVR;       /**< \brief (Aic Offset: 0x08) Source Vector Register */
  __I  uint32_t Reserved1[1];
  __I  uint32_t AIC_IVR;       /**< \brief (Aic Offset: 0x10) Interrupt Vector Register */
  __I  uint32_t AIC_FVR;       /**< \brief (Aic Offset: 0x14) FIQ Interrupt Vector Register */
  __I  uint32_t AIC_ISR;       /**< \brief (Aic Offset: 0x18) Interrupt Status Register */
  __I  uint32_t Reserved2[1];
  __I  uint32_t AIC_IPR0;      /**< \brief (Aic Offset: 0x20) Interrupt Pending Register 0 */
  __I  uint32_t AIC_IPR1;      /**< \brief (Aic Offset: 0x24) Interrupt Pending Register 1 */
  __I  uint32_t AIC_IPR2;      /**< \brief (Aic Offset: 0x28) Interrupt Pending Register 2 */
  __I  uint32_t AIC_IPR3;      /**< \brief (Aic Offset: 0x2C) Interrupt Pending Register 3 */
  __I  uint32_t AIC_IMR;       /**< \brief (Aic Offset: 0x30) Interrupt Mask Register */
  __I  uint32_t AIC_CISR;      /**< \brief (Aic Offset: 0x34) Core Interrupt Status Register */
  __O  uint32_t AIC_EOICR;     /**< \brief (Aic Offset: 0x38) End of Interrupt Command Register */
  __IO uint32_t AIC_SPU;       /**< \brief (Aic Offset: 0x3C) Spurious Interrupt Vector Register */
  __O  uint32_t AIC_IECR;      /**< \brief (Aic Offset: 0x40) Interrupt Enable Command Register */
  __O  uint32_t AIC_IDCR;      /**< \brief (Aic Offset: 0x44) Interrupt Disable Command Register */
  __O  uint32_t AIC_ICCR;      /**< \brief (Aic Offset: 0x48) Interrupt Clear Command Register */
  __O  uint32_t AIC_ISCR;      /**< \brief (Aic Offset: 0x4C) Interrupt Set Command Register */
  __O  uint32_t AIC_FFER;      /**< \brief (Aic Offset: 0x50) Fast Forcing Enable Register */
  __O  uint32_t AIC_FFDR;      /**< \brief (Aic Offset: 0x54) Fast Forcing Disable Register */
  __I  uint32_t AIC_FFSR;      /**< \brief (Aic Offset: 0x58) Fast Forcing Status Register */
  __I  uint32_t Reserved3[4];
  __IO uint32_t AIC_DCR;       /**< \brief (Aic Offset: 0x6C) Debug Control Register */
  __I  uint32_t Reserved4[29];
  __IO uint32_t AIC_WPMR;      /**< \brief (Aic Offset: 0xE4) Write Protect Mode Register */
  __I  uint32_t AIC_WPSR;      /**< \brief (Aic Offset: 0xE8) Write Protect Status Register */
} Aic;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- AIC_SSR : (AIC Offset: 0x00) Source Select Register -------- */
#define AIC_SSR_INTSEL_Pos 0
#define AIC_SSR_INTSEL_Msk (0x7fu << AIC_SSR_INTSEL_Pos) /**< \brief (AIC_SSR) Interrupt line Selection */
#define AIC_SSR_INTSEL(value) ((AIC_SSR_INTSEL_Msk & ((value) << AIC_SSR_INTSEL_Pos)))
/* -------- AIC_SMR : (AIC Offset: 0x04) Source Mode Register -------- */
#define AIC_SMR_PRIOR_Pos 0
#define AIC_SMR_PRIOR_Msk (0x7u << AIC_SMR_PRIOR_Pos) /**< \brief (AIC_SMR) Priority Level */
#define AIC_SMR_PRIOR(value) ((AIC_SMR_PRIOR_Msk & ((value) << AIC_SMR_PRIOR_Pos)))
#define AIC_SMR_SRCTYPE_Pos 5
#define AIC_SMR_SRCTYPE_Msk (0x3u << AIC_SMR_SRCTYPE_Pos) /**< \brief (AIC_SMR) Interrupt Source Type */
#define   AIC_SMR_SRCTYPE_INT_LEVEL_SENSITIVE (0x0u << 5) /**< \brief (AIC_SMR) High level Sensitive for internal sourceLow level Sensitive for external source */
#define   AIC_SMR_SRCTYPE_INT_EDGE_TRIGGERED (0x1u << 5) /**< \brief (AIC_SMR) Positive edge triggered for internal sourceNegative edge triggered for external source */
#define   AIC_SMR_SRCTYPE_EXT_HIGH_LEVEL (0x2u << 5) /**< \brief (AIC_SMR) High level Sensitive for internal sourceHigh level Sensitive for external source */
#define   AIC_SMR_SRCTYPE_EXT_POSITIVE_EDGE (0x3u << 5) /**< \brief (AIC_SMR) Positive edge triggered for internal sourcePositive edge triggered for external source */
/* -------- AIC_SVR : (AIC Offset: 0x08) Source Vector Register -------- */
#define AIC_SVR_VECTOR_Pos 0
#define AIC_SVR_VECTOR_Msk (0xffffffffu << AIC_SVR_VECTOR_Pos) /**< \brief (AIC_SVR) Source Vector */
#define AIC_SVR_VECTOR(value) ((AIC_SVR_VECTOR_Msk & ((value) << AIC_SVR_VECTOR_Pos)))
/* -------- AIC_IVR : (AIC Offset: 0x10) Interrupt Vector Register -------- */
#define AIC_IVR_IRQV_Pos 0
#define AIC_IVR_IRQV_Msk (0xffffffffu << AIC_IVR_IRQV_Pos) /**< \brief (AIC_IVR) Interrupt Vector Register */
/* -------- AIC_FVR : (AIC Offset: 0x14) FIQ Interrupt Vector Register -------- */
#define AIC_FVR_FIQV_Pos 0
#define AIC_FVR_FIQV_Msk (0xffffffffu << AIC_FVR_FIQV_Pos) /**< \brief (AIC_FVR) FIQ Vector Register */
/* -------- AIC_ISR : (AIC Offset: 0x18) Interrupt Status Register -------- */
#define AIC_ISR_IRQID_Pos 0
#define AIC_ISR_IRQID_Msk (0x7fu << AIC_ISR_IRQID_Pos) /**< \brief (AIC_ISR) Current Interrupt Identifier */
/* -------- AIC_IPR0 : (AIC Offset: 0x20) Interrupt Pending Register 0 -------- */
#define AIC_IPR0_FIQ (0x1u << 0) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_SYS (0x1u << 1) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID2 (0x1u << 2) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID3 (0x1u << 3) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID4 (0x1u << 4) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID5 (0x1u << 5) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID6 (0x1u << 6) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID7 (0x1u << 7) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID8 (0x1u << 8) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID9 (0x1u << 9) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID10 (0x1u << 10) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID11 (0x1u << 11) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID12 (0x1u << 12) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID13 (0x1u << 13) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID14 (0x1u << 14) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID15 (0x1u << 15) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID16 (0x1u << 16) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID17 (0x1u << 17) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID18 (0x1u << 18) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID19 (0x1u << 19) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID20 (0x1u << 20) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID21 (0x1u << 21) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID22 (0x1u << 22) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID23 (0x1u << 23) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID24 (0x1u << 24) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID25 (0x1u << 25) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID26 (0x1u << 26) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID27 (0x1u << 27) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID28 (0x1u << 28) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID29 (0x1u << 29) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID30 (0x1u << 30) /**< \brief (AIC_IPR0) Interrupt Pending */
#define AIC_IPR0_PID31 (0x1u << 31) /**< \brief (AIC_IPR0) Interrupt Pending */
/* -------- AIC_IPR1 : (AIC Offset: 0x24) Interrupt Pending Register 1 -------- */
#define AIC_IPR1_PID32 (0x1u << 0) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID33 (0x1u << 1) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID34 (0x1u << 2) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID35 (0x1u << 3) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID36 (0x1u << 4) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID37 (0x1u << 5) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID38 (0x1u << 6) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID39 (0x1u << 7) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID40 (0x1u << 8) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID41 (0x1u << 9) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID42 (0x1u << 10) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID43 (0x1u << 11) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID44 (0x1u << 12) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID45 (0x1u << 13) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID46 (0x1u << 14) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID47 (0x1u << 15) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID48 (0x1u << 16) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID49 (0x1u << 17) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID50 (0x1u << 18) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID51 (0x1u << 19) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID52 (0x1u << 20) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID53 (0x1u << 21) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID54 (0x1u << 22) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID55 (0x1u << 23) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID56 (0x1u << 24) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID57 (0x1u << 25) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID58 (0x1u << 26) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID59 (0x1u << 27) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID60 (0x1u << 28) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID61 (0x1u << 29) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID62 (0x1u << 30) /**< \brief (AIC_IPR1) Interrupt Pending */
#define AIC_IPR1_PID63 (0x1u << 31) /**< \brief (AIC_IPR1) Interrupt Pending */
/* -------- AIC_IPR2 : (AIC Offset: 0x28) Interrupt Pending Register 2 -------- */
#define AIC_IPR2_PID64 (0x1u << 0) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID65 (0x1u << 1) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID66 (0x1u << 2) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID67 (0x1u << 3) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID68 (0x1u << 4) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID69 (0x1u << 5) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID70 (0x1u << 6) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID71 (0x1u << 7) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID72 (0x1u << 8) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID73 (0x1u << 9) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID74 (0x1u << 10) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID75 (0x1u << 11) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID76 (0x1u << 12) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID77 (0x1u << 13) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID78 (0x1u << 14) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID79 (0x1u << 15) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID80 (0x1u << 16) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID81 (0x1u << 17) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID82 (0x1u << 18) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID83 (0x1u << 19) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID84 (0x1u << 20) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID85 (0x1u << 21) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID86 (0x1u << 22) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID87 (0x1u << 23) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID88 (0x1u << 24) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID89 (0x1u << 25) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID90 (0x1u << 26) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID91 (0x1u << 27) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID92 (0x1u << 28) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID93 (0x1u << 29) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID94 (0x1u << 30) /**< \brief (AIC_IPR2) Interrupt Pending */
#define AIC_IPR2_PID95 (0x1u << 31) /**< \brief (AIC_IPR2) Interrupt Pending */
/* -------- AIC_IPR3 : (AIC Offset: 0x2C) Interrupt Pending Register 3 -------- */
#define AIC_IPR3_PID96 (0x1u << 0) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID97 (0x1u << 1) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID98 (0x1u << 2) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID99 (0x1u << 3) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID100 (0x1u << 4) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID101 (0x1u << 5) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID102 (0x1u << 6) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID103 (0x1u << 7) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID104 (0x1u << 8) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID105 (0x1u << 9) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID106 (0x1u << 10) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID107 (0x1u << 11) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID108 (0x1u << 12) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID109 (0x1u << 13) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID110 (0x1u << 14) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID111 (0x1u << 15) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID112 (0x1u << 16) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID113 (0x1u << 17) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID114 (0x1u << 18) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID115 (0x1u << 19) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID116 (0x1u << 20) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID117 (0x1u << 21) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID118 (0x1u << 22) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID119 (0x1u << 23) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID120 (0x1u << 24) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID121 (0x1u << 25) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID122 (0x1u << 26) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID123 (0x1u << 27) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID124 (0x1u << 28) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID125 (0x1u << 29) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID126 (0x1u << 30) /**< \brief (AIC_IPR3) Interrupt Pending */
#define AIC_IPR3_PID127 (0x1u << 31) /**< \brief (AIC_IPR3) Interrupt Pending */
/* -------- AIC_IMR : (AIC Offset: 0x30) Interrupt Mask Register -------- */
#define AIC_IMR_INTM (0x1u << 0) /**< \brief (AIC_IMR) Interrupt Mask */
/* -------- AIC_CISR : (AIC Offset: 0x34) Core Interrupt Status Register -------- */
#define AIC_CISR_NFIQ (0x1u << 0) /**< \brief (AIC_CISR) NFIQ Status */
#define AIC_CISR_NIRQ (0x1u << 1) /**< \brief (AIC_CISR) NIRQ Status */
/* -------- AIC_EOICR : (AIC Offset: 0x38) End of Interrupt Command Register -------- */
#define AIC_EOICR_ENDIT (0x1u << 0) /**< \brief (AIC_EOICR) Interrupt Processing Complete Command */
/* -------- AIC_SPU : (AIC Offset: 0x3C) Spurious Interrupt Vector Register -------- */
#define AIC_SPU_SIVR_Pos 0
#define AIC_SPU_SIVR_Msk (0xffffffffu << AIC_SPU_SIVR_Pos) /**< \brief (AIC_SPU) Spurious Interrupt Vector Register */
#define AIC_SPU_SIVR(value) ((AIC_SPU_SIVR_Msk & ((value) << AIC_SPU_SIVR_Pos)))
/* -------- AIC_IECR : (AIC Offset: 0x40) Interrupt Enable Command Register -------- */
#define AIC_IECR_INTEN (0x1u << 0) /**< \brief (AIC_IECR) Interrupt Enable */
/* -------- AIC_IDCR : (AIC Offset: 0x44) Interrupt Disable Command Register -------- */
#define AIC_IDCR_INTD (0x1u << 0) /**< \brief (AIC_IDCR) Interrupt Disable */
/* -------- AIC_ICCR : (AIC Offset: 0x48) Interrupt Clear Command Register -------- */
#define AIC_ICCR_INTCLR (0x1u << 0) /**< \brief (AIC_ICCR) Interrupt Clear */
/* -------- AIC_ISCR : (AIC Offset: 0x4C) Interrupt Set Command Register -------- */
#define AIC_ISCR_INTSET (0x1u << 0) /**< \brief (AIC_ISCR) Interrupt Set */
/* -------- AIC_FFER : (AIC Offset: 0x50) Fast Forcing Enable Register -------- */
#define AIC_FFER_FFEN (0x1u << 0) /**< \brief (AIC_FFER) Fast Forcing Enable */
/* -------- AIC_FFDR : (AIC Offset: 0x54) Fast Forcing Disable Register -------- */
#define AIC_FFDR_FFDIS (0x1u << 0) /**< \brief (AIC_FFDR) Fast Forcing Disable */
/* -------- AIC_FFSR : (AIC Offset: 0x58) Fast Forcing Status Register -------- */
#define AIC_FFSR_FFS (0x1u << 0) /**< \brief (AIC_FFSR) Fast Forcing Status */
/* -------- AIC_DCR : (AIC Offset: 0x6C) Debug Control Register -------- */
#define AIC_DCR_PROT (0x1u << 0) /**< \brief (AIC_DCR) Protection Mode */
#define AIC_DCR_GMSK (0x1u << 1) /**< \brief (AIC_DCR) General Mask */
/* -------- AIC_WPMR : (AIC Offset: 0xE4) Write Protect Mode Register -------- */
#define AIC_WPMR_WPEN (0x1u << 0) /**< \brief (AIC_WPMR) Write Protect Enable */
#define AIC_WPMR_WPKEY_Pos 8
#define AIC_WPMR_WPKEY_Msk (0xffffffu << AIC_WPMR_WPKEY_Pos) /**< \brief (AIC_WPMR) Write Protect KEY */
#define   AIC_WPMR_WPKEY_PASSWD (0x414943u << 8) /**< \brief (AIC_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0. */
/* -------- AIC_WPSR : (AIC Offset: 0xE8) Write Protect Status Register -------- */
#define AIC_WPSR_WPVS (0x1u << 0) /**< \brief (AIC_WPSR) Write Protect Violation Status */
#define AIC_WPSR_WPVSRC_Pos 8
#define AIC_WPSR_WPVSRC_Msk (0xffffu << AIC_WPSR_WPVSRC_Pos) /**< \brief (AIC_WPSR) Write Protect Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR AXI Matrix */
/* ============================================================================= */
/** \addtogroup SAMA5D4_AXIMX AXI Matrix */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Aximx hardware registers */
typedef struct {
  __O uint32_t AXIMX_REMAP; /**< \brief (Aximx Offset: 0x00) Remap Register */
} Aximx;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- AXIMX_REMAP : (AXIMX Offset: 0x00) Remap Register -------- */
#define AXIMX_REMAP_REMAP0 (0x1u << 0) /**< \brief (AXIMX_REMAP) Remap State 0 */
#define AXIMX_REMAP_REMAP1 (0x1u << 1) /**< \brief (AXIMX_REMAP) Remap State 1 */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Debug Unit */
/* ============================================================================= */
/** \addtogroup SAMA5D4_DBGU Debug Unit */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Dbgu hardware registers */
typedef struct {
  __O  uint32_t DBGU_CR;      /**< \brief (Dbgu Offset: 0x0000) Control Register */
  __IO uint32_t DBGU_MR;      /**< \brief (Dbgu Offset: 0x0004) Mode Register */
  __O  uint32_t DBGU_IER;     /**< \brief (Dbgu Offset: 0x0008) Interrupt Enable Register */
  __O  uint32_t DBGU_IDR;     /**< \brief (Dbgu Offset: 0x000C) Interrupt Disable Register */
  __I  uint32_t DBGU_IMR;     /**< \brief (Dbgu Offset: 0x0010) Interrupt Mask Register */
  __I  uint32_t DBGU_SR;      /**< \brief (Dbgu Offset: 0x0014) Status Register */
  __I  uint32_t DBGU_RHR;     /**< \brief (Dbgu Offset: 0x0018) Receive Holding Register */
  __O  uint32_t DBGU_THR;     /**< \brief (Dbgu Offset: 0x001C) Transmit Holding Register */
  __IO uint32_t DBGU_BRGR;    /**< \brief (Dbgu Offset: 0x0020) Baud Rate Generator Register */
  __I  uint32_t Reserved1[7];
  __I  uint32_t DBGU_CIDR;    /**< \brief (Dbgu Offset: 0x0040) Chip ID Register */
  __I  uint32_t DBGU_EXID;    /**< \brief (Dbgu Offset: 0x0044) Chip ID Extension Register */
  __IO uint32_t DBGU_FNR;     /**< \brief (Dbgu Offset: 0x0048) Force NTRST Register */
} Dbgu;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- DBGU_CR : (DBGU Offset: 0x0000) Control Register -------- */
#define DBGU_CR_RSTRX (0x1u << 2) /**< \brief (DBGU_CR) Reset Receiver */
#define DBGU_CR_RSTTX (0x1u << 3) /**< \brief (DBGU_CR) Reset Transmitter */
#define DBGU_CR_RXEN (0x1u << 4) /**< \brief (DBGU_CR) Receiver Enable */
#define DBGU_CR_RXDIS (0x1u << 5) /**< \brief (DBGU_CR) Receiver Disable */
#define DBGU_CR_TXEN (0x1u << 6) /**< \brief (DBGU_CR) Transmitter Enable */
#define DBGU_CR_TXDIS (0x1u << 7) /**< \brief (DBGU_CR) Transmitter Disable */
#define DBGU_CR_RSTSTA (0x1u << 8) /**< \brief (DBGU_CR) Reset Status Bits */
/* -------- DBGU_MR : (DBGU Offset: 0x0004) Mode Register -------- */
#define DBGU_MR_PAR_Pos 9
#define DBGU_MR_PAR_Msk (0x7u << DBGU_MR_PAR_Pos) /**< \brief (DBGU_MR) Parity Type */
#define   DBGU_MR_PAR_EVEN (0x0u << 9) /**< \brief (DBGU_MR) Even Parity */
#define   DBGU_MR_PAR_ODD (0x1u << 9) /**< \brief (DBGU_MR) Odd Parity */
#define   DBGU_MR_PAR_SPACE (0x2u << 9) /**< \brief (DBGU_MR) Space: Parity forced to 0 */
#define   DBGU_MR_PAR_MARK (0x3u << 9) /**< \brief (DBGU_MR) Mark: Parity forced to 1 */
#define   DBGU_MR_PAR_NONE (0x4u << 9) /**< \brief (DBGU_MR) No Parity */
#define DBGU_MR_CHMODE_Pos 14
#define DBGU_MR_CHMODE_Msk (0x3u << DBGU_MR_CHMODE_Pos) /**< \brief (DBGU_MR) Channel Mode */
#define   DBGU_MR_CHMODE_NORM (0x0u << 14) /**< \brief (DBGU_MR) Normal Mode */
#define   DBGU_MR_CHMODE_AUTO (0x1u << 14) /**< \brief (DBGU_MR) Automatic Echo */
#define   DBGU_MR_CHMODE_LOCLOOP (0x2u << 14) /**< \brief (DBGU_MR) Local Loopback */
#define   DBGU_MR_CHMODE_REMLOOP (0x3u << 14) /**< \brief (DBGU_MR) Remote Loopback */
/* -------- DBGU_IER : (DBGU Offset: 0x0008) Interrupt Enable Register -------- */
#define DBGU_IER_RXRDY (0x1u << 0) /**< \brief (DBGU_IER) Enable RXRDY Interrupt */
#define DBGU_IER_TXRDY (0x1u << 1) /**< \brief (DBGU_IER) Enable TXRDY Interrupt */
#define DBGU_IER_OVRE (0x1u << 5) /**< \brief (DBGU_IER) Enable Overrun Error Interrupt */
#define DBGU_IER_FRAME (0x1u << 6) /**< \brief (DBGU_IER) Enable Framing Error Interrupt */
#define DBGU_IER_PARE (0x1u << 7) /**< \brief (DBGU_IER) Enable Parity Error Interrupt */
#define DBGU_IER_TXEMPTY (0x1u << 9) /**< \brief (DBGU_IER) Enable TXEMPTY Interrupt */
#define DBGU_IER_COMMTX (0x1u << 30) /**< \brief (DBGU_IER) Enable COMMTX (from ARM) Interrupt */
#define DBGU_IER_COMMRX (0x1u << 31) /**< \brief (DBGU_IER) Enable COMMRX (from ARM) Interrupt */
/* -------- DBGU_IDR : (DBGU Offset: 0x000C) Interrupt Disable Register -------- */
#define DBGU_IDR_RXRDY (0x1u << 0) /**< \brief (DBGU_IDR) Disable RXRDY Interrupt */
#define DBGU_IDR_TXRDY (0x1u << 1) /**< \brief (DBGU_IDR) Disable TXRDY Interrupt */
#define DBGU_IDR_OVRE (0x1u << 5) /**< \brief (DBGU_IDR) Disable Overrun Error Interrupt */
#define DBGU_IDR_FRAME (0x1u << 6) /**< \brief (DBGU_IDR) Disable Framing Error Interrupt */
#define DBGU_IDR_PARE (0x1u << 7) /**< \brief (DBGU_IDR) Disable Parity Error Interrupt */
#define DBGU_IDR_TXEMPTY (0x1u << 9) /**< \brief (DBGU_IDR) Disable TXEMPTY Interrupt */
#define DBGU_IDR_COMMTX (0x1u << 30) /**< \brief (DBGU_IDR) Disable COMMTX (from ARM) Interrupt */
#define DBGU_IDR_COMMRX (0x1u << 31) /**< \brief (DBGU_IDR) Disable COMMRX (from ARM) Interrupt */
/* -------- DBGU_IMR : (DBGU Offset: 0x0010) Interrupt Mask Register -------- */
#define DBGU_IMR_RXRDY (0x1u << 0) /**< \brief (DBGU_IMR) Mask RXRDY Interrupt */
#define DBGU_IMR_TXRDY (0x1u << 1) /**< \brief (DBGU_IMR) Disable TXRDY Interrupt */
#define DBGU_IMR_OVRE (0x1u << 5) /**< \brief (DBGU_IMR) Mask Overrun Error Interrupt */
#define DBGU_IMR_FRAME (0x1u << 6) /**< \brief (DBGU_IMR) Mask Framing Error Interrupt */
#define DBGU_IMR_PARE (0x1u << 7) /**< \brief (DBGU_IMR) Mask Parity Error Interrupt */
#define DBGU_IMR_TXEMPTY (0x1u << 9) /**< \brief (DBGU_IMR) Mask TXEMPTY Interrupt */
#define DBGU_IMR_COMMTX (0x1u << 30) /**< \brief (DBGU_IMR) Mask COMMTX Interrupt */
#define DBGU_IMR_COMMRX (0x1u << 31) /**< \brief (DBGU_IMR) Mask COMMRX Interrupt */
/* -------- DBGU_SR : (DBGU Offset: 0x0014) Status Register -------- */
#define DBGU_SR_RXRDY (0x1u << 0) /**< \brief (DBGU_SR) Receiver Ready */
#define DBGU_SR_TXRDY (0x1u << 1) /**< \brief (DBGU_SR) Transmitter Ready */
#define DBGU_SR_OVRE (0x1u << 5) /**< \brief (DBGU_SR) Overrun Error */
#define DBGU_SR_FRAME (0x1u << 6) /**< \brief (DBGU_SR) Framing Error */
#define DBGU_SR_PARE (0x1u << 7) /**< \brief (DBGU_SR) Parity Error */
#define DBGU_SR_TXEMPTY (0x1u << 9) /**< \brief (DBGU_SR) Transmitter Empty */
#define DBGU_SR_COMMTX (0x1u << 30) /**< \brief (DBGU_SR) Debug Communication Channel Write Status */
#define DBGU_SR_COMMRX (0x1u << 31) /**< \brief (DBGU_SR) Debug Communication Channel Read Status */
/* -------- DBGU_RHR : (DBGU Offset: 0x0018) Receive Holding Register -------- */
#define DBGU_RHR_RXCHR_Pos 0
#define DBGU_RHR_RXCHR_Msk (0xffu << DBGU_RHR_RXCHR_Pos) /**< \brief (DBGU_RHR) Received Character */
/* -------- DBGU_THR : (DBGU Offset: 0x001C) Transmit Holding Register -------- */
#define DBGU_THR_TXCHR_Pos 0
#define DBGU_THR_TXCHR_Msk (0xffu << DBGU_THR_TXCHR_Pos) /**< \brief (DBGU_THR) Character to be Transmitted */
#define DBGU_THR_TXCHR(value) ((DBGU_THR_TXCHR_Msk & ((value) << DBGU_THR_TXCHR_Pos)))
/* -------- DBGU_BRGR : (DBGU Offset: 0x0020) Baud Rate Generator Register -------- */
#define DBGU_BRGR_CD_Pos 0
#define DBGU_BRGR_CD_Msk (0xffffu << DBGU_BRGR_CD_Pos) /**< \brief (DBGU_BRGR) Clock Divisor */
#define   DBGU_BRGR_CD_DISABLED (0x0u << 0) /**< \brief (DBGU_BRGR) DBGU Disabled */
#define   DBGU_BRGR_CD_MCK (0x1u << 0) /**< \brief (DBGU_BRGR) MCK */
/* -------- DBGU_CIDR : (DBGU Offset: 0x0040) Chip ID Register -------- */
#define DBGU_CIDR_VERSION_Pos 0
#define DBGU_CIDR_VERSION_Msk (0x1fu << DBGU_CIDR_VERSION_Pos) /**< \brief (DBGU_CIDR) Version of the Device */
#define DBGU_CIDR_EPROC_Pos 5
#define DBGU_CIDR_EPROC_Msk (0x7u << DBGU_CIDR_EPROC_Pos) /**< \brief (DBGU_CIDR) Embedded Processor */
#define   DBGU_CIDR_EPROC_ARM946ES (0x1u << 5) /**< \brief (DBGU_CIDR) ARM946ES */
#define   DBGU_CIDR_EPROC_ARM7TDMI (0x2u << 5) /**< \brief (DBGU_CIDR) ARM7TDMI */
#define   DBGU_CIDR_EPROC_CM3 (0x3u << 5) /**< \brief (DBGU_CIDR) Cortex-M3 */
#define   DBGU_CIDR_EPROC_ARM920T (0x4u << 5) /**< \brief (DBGU_CIDR) ARM920T */
#define   DBGU_CIDR_EPROC_ARM926EJS (0x5u << 5) /**< \brief (DBGU_CIDR) ARM926EJS */
#define DBGU_CIDR_NVPSIZ_Pos 8
#define DBGU_CIDR_NVPSIZ_Msk (0xfu << DBGU_CIDR_NVPSIZ_Pos) /**< \brief (DBGU_CIDR) Nonvolatile Program Memory Size */
#define   DBGU_CIDR_NVPSIZ_NONE (0x0u << 8) /**< \brief (DBGU_CIDR) None */
#define   DBGU_CIDR_NVPSIZ_8K (0x1u << 8) /**< \brief (DBGU_CIDR) 8 Kbytes */
#define   DBGU_CIDR_NVPSIZ_16K (0x2u << 8) /**< \brief (DBGU_CIDR) 16 Kbytes */
#define   DBGU_CIDR_NVPSIZ_32K (0x3u << 8) /**< \brief (DBGU_CIDR) 32 Kbytes */
#define   DBGU_CIDR_NVPSIZ_64K (0x5u << 8) /**< \brief (DBGU_CIDR) 64 Kbytes */
#define   DBGU_CIDR_NVPSIZ_128K (0x7u << 8) /**< \brief (DBGU_CIDR) 128 Kbytes */
#define   DBGU_CIDR_NVPSIZ_256K (0x9u << 8) /**< \brief (DBGU_CIDR) 256 Kbytes */
#define   DBGU_CIDR_NVPSIZ_512K (0xAu << 8) /**< \brief (DBGU_CIDR) 512 Kbytes */
#define   DBGU_CIDR_NVPSIZ_1024K (0xCu << 8) /**< \brief (DBGU_CIDR) 1024 Kbytes */
#define   DBGU_CIDR_NVPSIZ_2048K (0xEu << 8) /**< \brief (DBGU_CIDR) 2048 Kbytes */
#define DBGU_CIDR_NVPSIZ2_Pos 12
#define DBGU_CIDR_NVPSIZ2_Msk (0xfu << DBGU_CIDR_NVPSIZ2_Pos) /**< \brief (DBGU_CIDR) Second Nonvolatile Program Memory Size */
#define   DBGU_CIDR_NVPSIZ2_NONE (0x0u << 12) /**< \brief (DBGU_CIDR) None */
#define   DBGU_CIDR_NVPSIZ2_8K (0x1u << 12) /**< \brief (DBGU_CIDR) 8 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_16K (0x2u << 12) /**< \brief (DBGU_CIDR) 16 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_32K (0x3u << 12) /**< \brief (DBGU_CIDR) 32 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_64K (0x5u << 12) /**< \brief (DBGU_CIDR) 64 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_128K (0x7u << 12) /**< \brief (DBGU_CIDR) 128 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_256K (0x9u << 12) /**< \brief (DBGU_CIDR) 256 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_512K (0xAu << 12) /**< \brief (DBGU_CIDR) 512 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_1024K (0xCu << 12) /**< \brief (DBGU_CIDR) 1024 Kbytes */
#define   DBGU_CIDR_NVPSIZ2_2048K (0xEu << 12) /**< \brief (DBGU_CIDR) 2048 Kbytes */
#define DBGU_CIDR_SRAMSIZ_Pos 16
#define DBGU_CIDR_SRAMSIZ_Msk (0xfu << DBGU_CIDR_SRAMSIZ_Pos) /**< \brief (DBGU_CIDR) Internal SRAM Size */
#define   DBGU_CIDR_SRAMSIZ_1K (0x1u << 16) /**< \brief (DBGU_CIDR) 1 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_2K (0x2u << 16) /**< \brief (DBGU_CIDR) 2 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_6K (0x3u << 16) /**< \brief (DBGU_CIDR) 6 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_112K (0x4u << 16) /**< \brief (DBGU_CIDR) 112 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_4K (0x5u << 16) /**< \brief (DBGU_CIDR) 4 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_80K (0x6u << 16) /**< \brief (DBGU_CIDR) 80 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_160K (0x7u << 16) /**< \brief (DBGU_CIDR) 160 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_8K (0x8u << 16) /**< \brief (DBGU_CIDR) 8 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_16K (0x9u << 16) /**< \brief (DBGU_CIDR) 16 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_32K (0xAu << 16) /**< \brief (DBGU_CIDR) 32 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_64K (0xBu << 16) /**< \brief (DBGU_CIDR) 64 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_128K (0xCu << 16) /**< \brief (DBGU_CIDR) 128 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_256K (0xDu << 16) /**< \brief (DBGU_CIDR) 256 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_96K (0xEu << 16) /**< \brief (DBGU_CIDR) 96 Kbytes */
#define   DBGU_CIDR_SRAMSIZ_512K (0xFu << 16) /**< \brief (DBGU_CIDR) 512 Kbytes */
#define DBGU_CIDR_ARCH_Pos 20
#define DBGU_CIDR_ARCH_Msk (0xffu << DBGU_CIDR_ARCH_Pos) /**< \brief (DBGU_CIDR) Architecture Identifier */
#define   DBGU_CIDR_ARCH_AT91SAM9xx (0x19u << 20) /**< \brief (DBGU_CIDR) AT91SAM9xx Series */
#define   DBGU_CIDR_ARCH_AT91SAM9XExx (0x29u << 20) /**< \brief (DBGU_CIDR) AT91SAM9XExx Series */
#define   DBGU_CIDR_ARCH_AT91x34 (0x34u << 20) /**< \brief (DBGU_CIDR) AT91x34 Series */
#define   DBGU_CIDR_ARCH_CAP7 (0x37u << 20) /**< \brief (DBGU_CIDR) CAP7 Series */
#define   DBGU_CIDR_ARCH_CAP9 (0x39u << 20) /**< \brief (DBGU_CIDR) CAP9 Series */
#define   DBGU_CIDR_ARCH_CAP11 (0x3Bu << 20) /**< \brief (DBGU_CIDR) CAP11 Series */
#define   DBGU_CIDR_ARCH_AT91x40 (0x40u << 20) /**< \brief (DBGU_CIDR) AT91x40 Series */
#define   DBGU_CIDR_ARCH_AT91x42 (0x42u << 20) /**< \brief (DBGU_CIDR) AT91x42 Series */
#define   DBGU_CIDR_ARCH_AT91x55 (0x55u << 20) /**< \brief (DBGU_CIDR) AT91x55 Series */
#define   DBGU_CIDR_ARCH_AT91SAM7Axx (0x60u << 20) /**< \brief (DBGU_CIDR) AT91SAM7Axx Series */
#define   DBGU_CIDR_ARCH_AT91SAM7AQxx (0x61u << 20) /**< \brief (DBGU_CIDR) AT91SAM7AQxx Series */
#define   DBGU_CIDR_ARCH_AT91x63 (0x63u << 20) /**< \brief (DBGU_CIDR) AT91x63 Series */
#define   DBGU_CIDR_ARCH_AT91SAM7Sxx (0x70u << 20) /**< \brief (DBGU_CIDR) AT91SAM7Sxx Series */
#define   DBGU_CIDR_ARCH_AT91SAM7XCxx (0x71u << 20) /**< \brief (DBGU_CIDR) AT91SAM7XCxx Series */
#define   DBGU_CIDR_ARCH_AT91SAM7SExx (0x72u << 20) /**< \brief (DBGU_CIDR) AT91SAM7SExx Series */
#define   DBGU_CIDR_ARCH_AT91SAM7Lxx (0x73u << 20) /**< \brief (DBGU_CIDR) AT91SAM7Lxx Series */
#define   DBGU_CIDR_ARCH_AT91SAM7Xxx (0x75u << 20) /**< \brief (DBGU_CIDR) AT91SAM7Xxx Series */
#define   DBGU_CIDR_ARCH_AT91SAM7SLxx (0x76u << 20) /**< \brief (DBGU_CIDR) AT91SAM7SLxx Series */
#define   DBGU_CIDR_ARCH_ATSAM3UxC (0x80u << 20) /**< \brief (DBGU_CIDR) ATSAM3UxC Series (100-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3UxE (0x81u << 20) /**< \brief (DBGU_CIDR) ATSAM3UxE Series (144-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3AxC (0x83u << 20) /**< \brief (DBGU_CIDR) ATSAM3AxC Series (100-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3XxC (0x84u << 20) /**< \brief (DBGU_CIDR) ATSAM3XxC Series (100-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3XxE (0x85u << 20) /**< \brief (DBGU_CIDR) ATSAM3XxE Series (144-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3XxG (0x86u << 20) /**< \brief (DBGU_CIDR) ATSAM3XxG Series (208/217-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3SxA (0x88u << 20) /**< \brief (DBGU_CIDR) ATSAM3SxA Series (48-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3SxB (0x89u << 20) /**< \brief (DBGU_CIDR) ATSAM3SxB Series (64-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3SxC (0x8Au << 20) /**< \brief (DBGU_CIDR) ATSAM3SxC Series (100-pin version) */
#define   DBGU_CIDR_ARCH_AT91x92 (0x92u << 20) /**< \brief (DBGU_CIDR) AT91x92 Series */
#define   DBGU_CIDR_ARCH_ATSAM3NxA (0x93u << 20) /**< \brief (DBGU_CIDR) ATSAM3NxA Series (48-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3NxB (0x94u << 20) /**< \brief (DBGU_CIDR) ATSAM3NxB Series (64-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3NxC (0x95u << 20) /**< \brief (DBGU_CIDR) ATSAM3NxC Series (100-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3SDxA (0x98u << 20) /**< \brief (DBGU_CIDR) ATSAM3SDxA Series (48-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3SDxB (0x99u << 20) /**< \brief (DBGU_CIDR) ATSAM3SDxB Series (64-pin version) */
#define   DBGU_CIDR_ARCH_ATSAM3SDxC (0x9Au << 20) /**< \brief (DBGU_CIDR) ATSAM3SDxC Series (100-pin version) */
#define   DBGU_CIDR_ARCH_AT75Cxx (0xF0u << 20) /**< \brief (DBGU_CIDR) AT75Cxx Series */
#define DBGU_CIDR_NVPTYP_Pos 28
#define DBGU_CIDR_NVPTYP_Msk (0x7u << DBGU_CIDR_NVPTYP_Pos) /**< \brief (DBGU_CIDR) Nonvolatile Program Memory Type */
#define   DBGU_CIDR_NVPTYP_ROM (0x0u << 28) /**< \brief (DBGU_CIDR) ROM */
#define   DBGU_CIDR_NVPTYP_ROMLESS (0x1u << 28) /**< \brief (DBGU_CIDR) ROMless or on-chip Flash */
#define   DBGU_CIDR_NVPTYP_FLASH (0x2u << 28) /**< \brief (DBGU_CIDR) Embedded Flash Memory */
#define   DBGU_CIDR_NVPTYP_ROM_FLASH (0x3u << 28) /**< \brief (DBGU_CIDR) ROM and Embedded Flash MemoryNVPSIZ is ROM size      NVPSIZ2 is Flash size */
#define   DBGU_CIDR_NVPTYP_SRAM (0x4u << 28) /**< \brief (DBGU_CIDR) SRAM emulating ROM */
#define DBGU_CIDR_EXT (0x1u << 31) /**< \brief (DBGU_CIDR) Extension Flag */
/* -------- DBGU_EXID : (DBGU Offset: 0x0044) Chip ID Extension Register -------- */
#define DBGU_EXID_EXID_Pos 0
#define DBGU_EXID_EXID_Msk (0xffffffffu << DBGU_EXID_EXID_Pos) /**< \brief (DBGU_EXID) Chip ID Extension */
/* -------- DBGU_FNR : (DBGU Offset: 0x0048) Force NTRST Register -------- */
#define DBGU_FNR_FNTRST (0x1u << 0) /**< \brief (DBGU_FNR) Force NTRST */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Gigabit Ethernet MAC */
/* ============================================================================= */
/** \addtogroup SAMA5D4_GMAC Gigabit Ethernet MAC */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief GmacSa hardware registers */
typedef struct {
  __IO uint32_t GMAC_SAB; /**< \brief (GmacSa Offset: 0x0) Specific Address 1 Bottom [31:0] Register */
  __IO uint32_t GMAC_SAT; /**< \brief (GmacSa Offset: 0x4) Specific Address 1 Top [47:32] Register */
} GmacSa;
/** \brief Gmac hardware registers */
#define GMACSA_NUMBER 4
typedef struct {
  __IO uint32_t GMAC_NCR;               /**< \brief (Gmac Offset: 0x000) Network Control Register */
  __IO uint32_t GMAC_NCFGR;             /**< \brief (Gmac Offset: 0x004) Network Configuration Register */
  __I  uint32_t GMAC_NSR;               /**< \brief (Gmac Offset: 0x008) Network Status Register */
  __IO uint32_t GMAC_UR;                /**< \brief (Gmac Offset: 0x00C) User Register */
  __IO uint32_t GMAC_DCFGR;             /**< \brief (Gmac Offset: 0x010) DMA Configuration Register */
  __IO uint32_t GMAC_TSR;               /**< \brief (Gmac Offset: 0x014) Transmit Status Register */
  __IO uint32_t GMAC_RBQB;              /**< \brief (Gmac Offset: 0x018) Receive Buffer Queue Base Address */
  __IO uint32_t GMAC_TBQB;              /**< \brief (Gmac Offset: 0x01C) Transmit Buffer Queue Base Address */
  __IO uint32_t GMAC_RSR;               /**< \brief (Gmac Offset: 0x020) Receive Status Register */
  __I  uint32_t GMAC_ISR;               /**< \brief (Gmac Offset: 0x024) Interrupt Status Register */
  __O  uint32_t GMAC_IER;               /**< \brief (Gmac Offset: 0x028) Interrupt Enable Register */
  __O  uint32_t GMAC_IDR;               /**< \brief (Gmac Offset: 0x02C) Interrupt Disable Register */
  __I  uint32_t GMAC_IMR;               /**< \brief (Gmac Offset: 0x030) Interrupt Mask Register */
  __IO uint32_t GMAC_MAN;               /**< \brief (Gmac Offset: 0x034) PHY Maintenance Register */
  __I  uint32_t GMAC_RPQ;               /**< \brief (Gmac Offset: 0x038) Received Pause Quantum Register */
  __IO uint32_t GMAC_TPQ;               /**< \brief (Gmac Offset: 0x03C) Transmit Pause Quantum Register */
  __I  uint32_t Reserved1[16];
  __IO uint32_t GMAC_HRB;               /**< \brief (Gmac Offset: 0x080) Hash Register Bottom [31:0] */
  __IO uint32_t GMAC_HRT;               /**< \brief (Gmac Offset: 0x084) Hash Register Top [63:32] */
       GmacSa   GMAC_SA[GMACSA_NUMBER]; /**< \brief (Gmac Offset: 0x088) 1 .. 4 */
  __IO uint32_t GMAC_TIDM[4];           /**< \brief (Gmac Offset: 0x0A8) Type ID Match 1 Register */
  __IO uint32_t GMAC_WOL;               /**< \brief (Gmac Offset: 0x0B8) Wake on LAN Register */
  __IO uint32_t GMAC_IPGS;              /**< \brief (Gmac Offset: 0x0BC) IPG Stretch Register */
  __IO uint32_t GMAC_SVLAN;             /**< \brief (Gmac Offset: 0x0C0) Stacked VLAN Register */
  __IO uint32_t GMAC_TPFCP;             /**< \brief (Gmac Offset: 0x0C4) Transmit PFC Pause Register */
  __IO uint32_t GMAC_SAMB1;             /**< \brief (Gmac Offset: 0x0C8) Specific Address 1 Mask Bottom [31:0] Register */
  __IO uint32_t GMAC_SAMT1;             /**< \brief (Gmac Offset: 0x0CC) Specific Address 1 Mask Top [47:32] Register */
  __I  uint32_t Reserved2[12];
  __I  uint32_t GMAC_OTLO;              /**< \brief (Gmac Offset: 0x100) Octets Transmitted [31:0] Register */
  __I  uint32_t GMAC_OTHI;              /**< \brief (Gmac Offset: 0x104) Octets Transmitted [47:32] Register */
  __I  uint32_t GMAC_FT;                /**< \brief (Gmac Offset: 0x108) Frames Transmitted Register */
  __I  uint32_t GMAC_BCFT;              /**< \brief (Gmac Offset: 0x10C) Broadcast Frames Transmitted Register */
  __I  uint32_t GMAC_MFT;               /**< \brief (Gmac Offset: 0x110) Multicast Frames Transmitted Register */
  __I  uint32_t GMAC_PFT;               /**< \brief (Gmac Offset: 0x114) Pause Frames Transmitted Register */
  __I  uint32_t GMAC_BFT64;             /**< \brief (Gmac Offset: 0x118) 64 Byte Frames Transmitted Register */
  __I  uint32_t GMAC_TBFT127;           /**< \brief (Gmac Offset: 0x11C) 65 to 127 Byte Frames Transmitted Register */
  __I  uint32_t GMAC_TBFT255;           /**< \brief (Gmac Offset: 0x120) 128 to 255 Byte Frames Transmitted Register */
  __I  uint32_t GMAC_TBFT511;           /**< \brief (Gmac Offset: 0x124) 256 to 511 Byte Frames Transmitted Register */
  __I  uint32_t GMAC_TBFT1023;          /**< \brief (Gmac Offset: 0x128) 512 to 1023 Byte Frames Transmitted Register */
  __I  uint32_t GMAC_TBFT1518;          /**< \brief (Gmac Offset: 0x12C) 1024 to 1518 Byte Frames Transmitted Register */
  __I  uint32_t GMAC_GTBFT1518;         /**< \brief (Gmac Offset: 0x130) Greater Than 1518 Byte Frames Transmitted Register */
  __I  uint32_t GMAC_TUR;               /**< \brief (Gmac Offset: 0x134) Transmit Under Runs Register */
  __I  uint32_t GMAC_SCF;               /**< \brief (Gmac Offset: 0x138) Single Collision Frames Register */
  __I  uint32_t GMAC_MCF;               /**< \brief (Gmac Offset: 0x13C) Multiple Collision Frames Register */
  __I  uint32_t GMAC_EC;                /**< \brief (Gmac Offset: 0x140) Excessive Collisions Register */
  __I  uint32_t GMAC_LC;                /**< \brief (Gmac Offset: 0x144) Late Collisions Register */
  __I  uint32_t GMAC_DTF;               /**< \brief (Gmac Offset: 0x148) Deferred Transmission Frames Register */
  __I  uint32_t GMAC_CSE;               /**< \brief (Gmac Offset: 0x14C) Carrier Sense Errors Register */
  __I  uint32_t GMAC_ORLO;              /**< \brief (Gmac Offset: 0x150) Octets Received [31:0] Received */
  __I  uint32_t GMAC_ORHI;              /**< \brief (Gmac Offset: 0x154) Octets Received [47:32] Received */
  __I  uint32_t GMAC_FR;                /**< \brief (Gmac Offset: 0x158) Frames Received Register */
  __I  uint32_t GMAC_BCFR;              /**< \brief (Gmac Offset: 0x15C) Broadcast Frames Received Register */
  __I  uint32_t GMAC_MFR;               /**< \brief (Gmac Offset: 0x160) Multicast Frames Received Register */
  __I  uint32_t GMAC_PFR;               /**< \brief (Gmac Offset: 0x164) Pause Frames Received Register */
  __I  uint32_t GMAC_BFR64;             /**< \brief (Gmac Offset: 0x168) 64 Byte Frames Received Register */
  __I  uint32_t GMAC_TBFR127;           /**< \brief (Gmac Offset: 0x16C) 65 to 127 Byte Frames Received Register */
  __I  uint32_t GMAC_TBFR255;           /**< \brief (Gmac Offset: 0x170) 128 to 255 Byte Frames Received Register */
  __I  uint32_t GMAC_TBFR511;           /**< \brief (Gmac Offset: 0x174) 256 to 511Byte Frames Received Register */
  __I  uint32_t GMAC_TBFR1023;          /**< \brief (Gmac Offset: 0x178) 512 to 1023 Byte Frames Received Register */
  __I  uint32_t GMAC_TBFR1518;          /**< \brief (Gmac Offset: 0x17C) 1024 to 1518 Byte Frames Received Register */
  __I  uint32_t GMAC_TMXBFR;            /**< \brief (Gmac Offset: 0x180) 1519 to Maximum Byte Frames Received Register */
  __I  uint32_t GMAC_UFR;               /**< \brief (Gmac Offset: 0x184) Undersize Frames Received Register */
  __I  uint32_t GMAC_OFR;               /**< \brief (Gmac Offset: 0x188) Oversize Frames Received Register */
  __I  uint32_t GMAC_JR;                /**< \brief (Gmac Offset: 0x18C) Jabbers Received Register */
  __I  uint32_t GMAC_FCSE;              /**< \brief (Gmac Offset: 0x190) Frame Check Sequence Errors Register */
  __I  uint32_t GMAC_LFFE;              /**< \brief (Gmac Offset: 0x194) Length Field Frame Errors Register */
  __I  uint32_t GMAC_RSE;               /**< \brief (Gmac Offset: 0x198) Receive Symbol Errors Register */
  __I  uint32_t GMAC_AE;                /**< \brief (Gmac Offset: 0x19C) Alignment Errors Register */
  __I  uint32_t GMAC_RRE;               /**< \brief (Gmac Offset: 0x1A0) Receive Resource Errors Register */
  __I  uint32_t GMAC_ROE;               /**< \brief (Gmac Offset: 0x1A4) Receive Overrun Register */
  __I  uint32_t GMAC_IHCE;              /**< \brief (Gmac Offset: 0x1A8) IP Header Checksum Errors Register */
  __I  uint32_t GMAC_TCE;               /**< \brief (Gmac Offset: 0x1AC) TCP Checksum Errors Register */
  __I  uint32_t GMAC_UCE;               /**< \brief (Gmac Offset: 0x1B0) UDP Checksum Errors Register */
  __I  uint32_t Reserved3[5];
  __IO uint32_t GMAC_TSSS;              /**< \brief (Gmac Offset: 0x1C8) 1588 Timer Sync Strobe Seconds Register */
  __IO uint32_t GMAC_TSSN;              /**< \brief (Gmac Offset: 0x1CC) 1588 Timer Sync Strobe Nanoseconds Register */
  __IO uint32_t GMAC_TS;                /**< \brief (Gmac Offset: 0x1D0) 1588 Timer Seconds Register */
  __IO uint32_t GMAC_TN;                /**< \brief (Gmac Offset: 0x1D4) 1588 Timer Nanoseconds Register */
  __O  uint32_t GMAC_TA;                /**< \brief (Gmac Offset: 0x1D8) 1588 Timer Adjust Register */
  __IO uint32_t GMAC_TI;                /**< \brief (Gmac Offset: 0x1DC) 1588 Timer Increment Register */
  __I  uint32_t GMAC_EFTS;              /**< \brief (Gmac Offset: 0x1E0) PTP Event Frame Transmitted Seconds */
  __I  uint32_t GMAC_EFTN;              /**< \brief (Gmac Offset: 0x1E4) PTP Event Frame Transmitted Nanoseconds */
  __I  uint32_t GMAC_EFRS;              /**< \brief (Gmac Offset: 0x1E8) PTP Event Frame Received Seconds */
  __I  uint32_t GMAC_EFRN;              /**< \brief (Gmac Offset: 0x1EC) PTP Event Frame Received Nanoseconds */
  __I  uint32_t GMAC_PEFTS;             /**< \brief (Gmac Offset: 0x1F0) PTP Peer Event Frame Transmitted Seconds */
  __I  uint32_t GMAC_PEFTN;             /**< \brief (Gmac Offset: 0x1F4) PTP Peer Event Frame Transmitted Nanoseconds */
  __I  uint32_t GMAC_PEFRS;             /**< \brief (Gmac Offset: 0x1F8) PTP Peer Event Frame Received Seconds */
  __I  uint32_t GMAC_PEFRN;             /**< \brief (Gmac Offset: 0x1FC) PTP Peer Event Frame Received Nanoseconds */
} Gmac;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- GMAC_NCR : (GMAC Offset: 0x000) Network Control Register -------- */
#define GMAC_NCR_LBL (0x1u << 1) /**< \brief (GMAC_NCR) Loop Back Local */
#define GMAC_NCR_RXEN (0x1u << 2) /**< \brief (GMAC_NCR) Receive Enable */
#define GMAC_NCR_TXEN (0x1u << 3) /**< \brief (GMAC_NCR) Transmit Enable */
#define GMAC_NCR_MPE (0x1u << 4) /**< \brief (GMAC_NCR) Management Port Enable */
#define GMAC_NCR_CLRSTAT (0x1u << 5) /**< \brief (GMAC_NCR) Clear Statistics Registers */
#define GMAC_NCR_INCSTAT (0x1u << 6) /**< \brief (GMAC_NCR) Increment Statistics Registers */
#define GMAC_NCR_WESTAT (0x1u << 7) /**< \brief (GMAC_NCR) Write Enable for Statistics Registers */
#define GMAC_NCR_BP (0x1u << 8) /**< \brief (GMAC_NCR) Back pressure */
#define GMAC_NCR_TSTART (0x1u << 9) /**< \brief (GMAC_NCR) Start Transmission */
#define GMAC_NCR_THALT (0x1u << 10) /**< \brief (GMAC_NCR) Transmit Halt */
#define GMAC_NCR_TXPF (0x1u << 11) /**< \brief (GMAC_NCR) Transmit Pause Frame */
#define GMAC_NCR_TXZQPF (0x1u << 12) /**< \brief (GMAC_NCR) Transmit Zero Quantum Pause Frame */
#define GMAC_NCR_RDS (0x1u << 14) /**< \brief (GMAC_NCR) Read Snapshot */
#define GMAC_NCR_SRTSM (0x1u << 15) /**< \brief (GMAC_NCR) Store Receive Time Stamp to Memory */
#define GMAC_NCR_ENPBPR (0x1u << 16) /**< \brief (GMAC_NCR) Enable PFC Priority-based Pause Reception */
#define GMAC_NCR_TXPBPF (0x1u << 17) /**< \brief (GMAC_NCR) Transmit PFC Priority-based Pause Frame */
#define GMAC_NCR_FNP (0x1u << 18) /**< \brief (GMAC_NCR) Flush Next Packet */
/* -------- GMAC_NCFGR : (GMAC Offset: 0x004) Network Configuration Register -------- */
#define GMAC_NCFGR_SPD (0x1u << 0) /**< \brief (GMAC_NCFGR) Speed */
#define GMAC_NCFGR_FD (0x1u << 1) /**< \brief (GMAC_NCFGR) Full Duplex */
#define GMAC_NCFGR_DNVLAN (0x1u << 2) /**< \brief (GMAC_NCFGR) Discard Non-VLAN FRAMES */
#define GMAC_NCFGR_JFRAME (0x1u << 3) /**< \brief (GMAC_NCFGR) Jumbo Frame Size */
#define GMAC_NCFGR_CAF (0x1u << 4) /**< \brief (GMAC_NCFGR) Copy All Frames */
#define GMAC_NCFGR_NBC (0x1u << 5) /**< \brief (GMAC_NCFGR) No Broadcast */
#define GMAC_NCFGR_MTIHEN (0x1u << 6) /**< \brief (GMAC_NCFGR) Multicast Hash Enable */
#define GMAC_NCFGR_UNIHEN (0x1u << 7) /**< \brief (GMAC_NCFGR) Unicast Hash Enable */
#define GMAC_NCFGR_MAXFS (0x1u << 8) /**< \brief (GMAC_NCFGR) 1536 Maximum Frame Size */
#define GMAC_NCFGR_RTY (0x1u << 12) /**< \brief (GMAC_NCFGR) Retry Test */
#define GMAC_NCFGR_PEN (0x1u << 13) /**< \brief (GMAC_NCFGR) Pause Enable */
#define GMAC_NCFGR_RXBUFO_Pos 14
#define GMAC_NCFGR_RXBUFO_Msk (0x3u << GMAC_NCFGR_RXBUFO_Pos) /**< \brief (GMAC_NCFGR) Receive Buffer Offset */
#define GMAC_NCFGR_RXBUFO(value) ((GMAC_NCFGR_RXBUFO_Msk & ((value) << GMAC_NCFGR_RXBUFO_Pos)))
#define GMAC_NCFGR_LFERD (0x1u << 16) /**< \brief (GMAC_NCFGR) Length Field Error Frame Discard */
#define GMAC_NCFGR_RFCS (0x1u << 17) /**< \brief (GMAC_NCFGR) Remove FCS */
#define GMAC_NCFGR_CLK_Pos 18
#define GMAC_NCFGR_CLK_Msk (0x7u << GMAC_NCFGR_CLK_Pos) /**< \brief (GMAC_NCFGR) MDC CLock Division */
#define   GMAC_NCFGR_CLK_MCK_8 (0x0u << 18) /**< \brief (GMAC_NCFGR) MCK divided by 8 (MCK up to 20 MHz) */
#define   GMAC_NCFGR_CLK_MCK_16 (0x1u << 18) /**< \brief (GMAC_NCFGR) MCK divided by 16 (MCK up to 40 MHz) */
#define   GMAC_NCFGR_CLK_MCK_32 (0x2u << 18) /**< \brief (GMAC_NCFGR) MCK divided by 32 (MCK up to 80 MHz) */
#define   GMAC_NCFGR_CLK_MCK_48 (0x3u << 18) /**< \brief (GMAC_NCFGR) MCK divided by 48 (MCK up to 120MHz) */
#define   GMAC_NCFGR_CLK_MCK_64 (0x4u << 18) /**< \brief (GMAC_NCFGR) MCK divided by 64 (MCK up to 160 MHz) */
#define   GMAC_NCFGR_CLK_MCK_96 (0x5u << 18) /**< \brief (GMAC_NCFGR) MCK divided by 96 (MCK up to 240 MHz) */
#define GMAC_NCFGR_DBW_Pos 21
#define GMAC_NCFGR_DBW_Msk (0x3u << GMAC_NCFGR_DBW_Pos) /**< \brief (GMAC_NCFGR) Data Bus Width */
#define   GMAC_NCFGR_DBW_DBW32 (0x0u << 21) /**< \brief (GMAC_NCFGR) 32-bit data bus width */
#define   GMAC_NCFGR_DBW_DBW64 (0x1u << 21) /**< \brief (GMAC_NCFGR) 64-bit data bus width */
#define GMAC_NCFGR_DCPF (0x1u << 23) /**< \brief (GMAC_NCFGR) Disable Copy of Pause Frames */
#define GMAC_NCFGR_RXCOEN (0x1u << 24) /**< \brief (GMAC_NCFGR) Receive Checksum Offload Enable */
#define GMAC_NCFGR_EFRHD (0x1u << 25) /**< \brief (GMAC_NCFGR) Enable Frames Received in Half Duplex */
#define GMAC_NCFGR_IRXFCS (0x1u << 26) /**< \brief (GMAC_NCFGR) Ignore RX FCS */
#define GMAC_NCFGR_IPGSEN (0x1u << 28) /**< \brief (GMAC_NCFGR) IP Stretch Enable */
#define GMAC_NCFGR_RXBP (0x1u << 29) /**< \brief (GMAC_NCFGR) Receive Bad Preamble */
#define GMAC_NCFGR_IRXER (0x1u << 30) /**< \brief (GMAC_NCFGR) Ignore IPG GRXER */
/* -------- GMAC_NSR : (GMAC Offset: 0x008) Network Status Register -------- */
#define GMAC_NSR_MDIO (0x1u << 1) /**< \brief (GMAC_NSR) MDIO Input Status */
#define GMAC_NSR_IDLE (0x1u << 2) /**< \brief (GMAC_NSR) PHY Management Logic Idle */
/* -------- GMAC_UR : (GMAC Offset: 0x00C) User Register -------- */
#define GMAC_UR_RMII (0x1u << 0) /**< \brief (GMAC_UR) Reduced MII Mode */
/* -------- GMAC_DCFGR : (GMAC Offset: 0x010) DMA Configuration Register -------- */
#define GMAC_DCFGR_FBLDO_Pos 0
#define GMAC_DCFGR_FBLDO_Msk (0x1fu << GMAC_DCFGR_FBLDO_Pos) /**< \brief (GMAC_DCFGR) Fixed Burst Length for DMA Data Operations: */
#define   GMAC_DCFGR_FBLDO_SINGLE (0x1u << 0) /**< \brief (GMAC_DCFGR) 00001: Always use SINGLE AHB bursts */
#define   GMAC_DCFGR_FBLDO_INCR4 (0x4u << 0) /**< \brief (GMAC_DCFGR) 001xx: Attempt to use INCR4 AHB bursts (Default) */
#define   GMAC_DCFGR_FBLDO_INCR8 (0x8u << 0) /**< \brief (GMAC_DCFGR) 01xxx: Attempt to use INCR8 AHB bursts */
#define   GMAC_DCFGR_FBLDO_INCR16 (0x10u << 0) /**< \brief (GMAC_DCFGR) 1xxxx: Attempt to use INCR16 AHB bursts */
#define GMAC_DCFGR_ESMA (0x1u << 6) /**< \brief (GMAC_DCFGR) Endian Swap Mode Enable for Management Descriptor Accesses */
#define GMAC_DCFGR_ESPA (0x1u << 7) /**< \brief (GMAC_DCFGR) Endian Swap Mode Enable for Packet Data Accesses */
#define GMAC_DCFGR_TXCOEN (0x1u << 11) /**< \brief (GMAC_DCFGR) Transmitter Checksum Generation Offload Enable */
#define GMAC_DCFGR_DRBS_Pos 16
#define GMAC_DCFGR_DRBS_Msk (0xffu << GMAC_DCFGR_DRBS_Pos) /**< \brief (GMAC_DCFGR) DMA Receive Buffer Size */
#define GMAC_DCFGR_DRBS(value) ((GMAC_DCFGR_DRBS_Msk & ((value) << GMAC_DCFGR_DRBS_Pos)))
/* -------- GMAC_TSR : (GMAC Offset: 0x014) Transmit Status Register -------- */
#define GMAC_TSR_UBR (0x1u << 0) /**< \brief (GMAC_TSR) Used Bit Read */
#define GMAC_TSR_COL (0x1u << 1) /**< \brief (GMAC_TSR) Collision Occurred */
#define GMAC_TSR_RLE (0x1u << 2) /**< \brief (GMAC_TSR) Retry Limit Exceeded */
#define GMAC_TSR_TXGO (0x1u << 3) /**< \brief (GMAC_TSR) Transmit Go */
#define GMAC_TSR_TFC (0x1u << 4) /**< \brief (GMAC_TSR) Transmit Frame Corruption due to AHB error */
#define GMAC_TSR_TXCOMP (0x1u << 5) /**< \brief (GMAC_TSR) Transmit Complete */
#define GMAC_TSR_UND (0x1u << 6) /**< \brief (GMAC_TSR) Transmit Under Run */
#define GMAC_TSR_HRESP (0x1u << 8) /**< \brief (GMAC_TSR) HRESP Not OK */
/* -------- GMAC_RBQB : (GMAC Offset: 0x018) Receive Buffer Queue Base Address -------- */
#define GMAC_RBQB_ADDR_Pos 2
#define GMAC_RBQB_ADDR_Msk (0x3fffffffu << GMAC_RBQB_ADDR_Pos) /**< \brief (GMAC_RBQB) Receive buffer queue base address */
#define GMAC_RBQB_ADDR(value) ((GMAC_RBQB_ADDR_Msk & ((value) << GMAC_RBQB_ADDR_Pos)))
/* -------- GMAC_TBQB : (GMAC Offset: 0x01C) Transmit Buffer Queue Base Address -------- */
#define GMAC_TBQB_ADDR_Pos 2
#define GMAC_TBQB_ADDR_Msk (0x3fffffffu << GMAC_TBQB_ADDR_Pos) /**< \brief (GMAC_TBQB) Transmit Buffer Queue Base Address */
#define GMAC_TBQB_ADDR(value) ((GMAC_TBQB_ADDR_Msk & ((value) << GMAC_TBQB_ADDR_Pos)))
/* -------- GMAC_RSR : (GMAC Offset: 0x020) Receive Status Register -------- */
#define GMAC_RSR_BNA (0x1u << 0) /**< \brief (GMAC_RSR) Buffer Not Available */
#define GMAC_RSR_REC (0x1u << 1) /**< \brief (GMAC_RSR) Frame Received */
#define GMAC_RSR_RXOVR (0x1u << 2) /**< \brief (GMAC_RSR) Receive Overrun */
#define GMAC_RSR_HNO (0x1u << 3) /**< \brief (GMAC_RSR) HRESP Not OK */
/* -------- GMAC_ISR : (GMAC Offset: 0x024) Interrupt Status Register -------- */
#define GMAC_ISR_MFS (0x1u << 0) /**< \brief (GMAC_ISR) Management Frame Sent */
#define GMAC_ISR_RCOMP (0x1u << 1) /**< \brief (GMAC_ISR) Receive Complete */
#define GMAC_ISR_RXUBR (0x1u << 2) /**< \brief (GMAC_ISR) RX Used Bit Read */
#define GMAC_ISR_TXUBR (0x1u << 3) /**< \brief (GMAC_ISR) TX Used Bit Read */
#define GMAC_ISR_TUR (0x1u << 4) /**< \brief (GMAC_ISR) Transmit Under Run */
#define GMAC_ISR_RLEX (0x1u << 5) /**< \brief (GMAC_ISR) Retry Limit Exceeded */
#define GMAC_ISR_TFC (0x1u << 6) /**< \brief (GMAC_ISR) Transmit Frame Corruption due to AHB error */
#define GMAC_ISR_TCOMP (0x1u << 7) /**< \brief (GMAC_ISR) Transmit Complete */
#define GMAC_ISR_ROVR (0x1u << 10) /**< \brief (GMAC_ISR) Receive Overrun */
#define GMAC_ISR_HRESP (0x1u << 11) /**< \brief (GMAC_ISR) HRESP Not OK */
#define GMAC_ISR_PFNZ (0x1u << 12) /**< \brief (GMAC_ISR) Pause Frame with Non-zero Pause Quantum Received */
#define GMAC_ISR_PTZ (0x1u << 13) /**< \brief (GMAC_ISR) Pause Time Zero */
#define GMAC_ISR_PFTR (0x1u << 14) /**< \brief (GMAC_ISR) Pause Frame Transmitted */
#define GMAC_ISR_DRQFR (0x1u << 18) /**< \brief (GMAC_ISR) PTP Delay Request Frame Received */
#define GMAC_ISR_SFR (0x1u << 19) /**< \brief (GMAC_ISR) PTP Sync Frame Received */
#define GMAC_ISR_DRQFT (0x1u << 20) /**< \brief (GMAC_ISR) PTP Delay Request Frame Transmitted */
#define GMAC_ISR_SFT (0x1u << 21) /**< \brief (GMAC_ISR) PTP Sync Frame Transmitted */
#define GMAC_ISR_PDRQFR (0x1u << 22) /**< \brief (GMAC_ISR) PDelay Request Frame Received */
#define GMAC_ISR_PDRSFR (0x1u << 23) /**< \brief (GMAC_ISR) PDelay Response Frame Received */
#define GMAC_ISR_PDRQFT (0x1u << 24) /**< \brief (GMAC_ISR) PDelay Request Frame Transmitted */
#define GMAC_ISR_PDRSFT (0x1u << 25) /**< \brief (GMAC_ISR) PDelay Response Frame Transmitted */
#define GMAC_ISR_SRI (0x1u << 26) /**< \brief (GMAC_ISR) TSU Seconds Register Increment */
#define GMAC_ISR_WOL (0x1u << 28) /**< \brief (GMAC_ISR) Wake On LAN */
/* -------- GMAC_IER : (GMAC Offset: 0x028) Interrupt Enable Register -------- */
#define GMAC_IER_MFS (0x1u << 0) /**< \brief (GMAC_IER) Management Frame Sent */
#define GMAC_IER_RCOMP (0x1u << 1) /**< \brief (GMAC_IER) Receive Complete */
#define GMAC_IER_RXUBR (0x1u << 2) /**< \brief (GMAC_IER) RX Used Bit Read */
#define GMAC_IER_TXUBR (0x1u << 3) /**< \brief (GMAC_IER) TX Used Bit Read */
#define GMAC_IER_TUR (0x1u << 4) /**< \brief (GMAC_IER) Transmit Under Run */
#define GMAC_IER_RLEX (0x1u << 5) /**< \brief (GMAC_IER) Retry Limit Exceeded or Late Collision */
#define GMAC_IER_TFC (0x1u << 6) /**< \brief (GMAC_IER) Transmit Frame Corruption due to AHB error */
#define GMAC_IER_TCOMP (0x1u << 7) /**< \brief (GMAC_IER) Transmit Complete */
#define GMAC_IER_ROVR (0x1u << 10) /**< \brief (GMAC_IER) Receive Overrun */
#define GMAC_IER_HRESP (0x1u << 11) /**< \brief (GMAC_IER) HRESP Not OK */
#define GMAC_IER_PFNZ (0x1u << 12) /**< \brief (GMAC_IER) Pause Frame with Non-zero Pause Quantum Received */
#define GMAC_IER_PTZ (0x1u << 13) /**< \brief (GMAC_IER) Pause Time Zero */
#define GMAC_IER_PFTR (0x1u << 14) /**< \brief (GMAC_IER) Pause Frame Transmitted */
#define GMAC_IER_EXINT (0x1u << 15) /**< \brief (GMAC_IER) External Interrupt */
#define GMAC_IER_DRQFR (0x1u << 18) /**< \brief (GMAC_IER) PTP Delay Request Frame Received */
#define GMAC_IER_SFR (0x1u << 19) /**< \brief (GMAC_IER) PTP Sync Frame Received */
#define GMAC_IER_DRQFT (0x1u << 20) /**< \brief (GMAC_IER) PTP Delay Request Frame Transmitted */
#define GMAC_IER_SFT (0x1u << 21) /**< \brief (GMAC_IER) PTP Sync Frame Transmitted */
#define GMAC_IER_PDRQFR (0x1u << 22) /**< \brief (GMAC_IER) PDelay Request Frame Received */
#define GMAC_IER_PDRSFR (0x1u << 23) /**< \brief (GMAC_IER) PDelay Response Frame Received */
#define GMAC_IER_PDRQFT (0x1u << 24) /**< \brief (GMAC_IER) PDelay Request Frame Transmitted */
#define GMAC_IER_PDRSFT (0x1u << 25) /**< \brief (GMAC_IER) PDelay Response Frame Transmitted */
#define GMAC_IER_SRI (0x1u << 26) /**< \brief (GMAC_IER) TSU Seconds Register Increment */
#define GMAC_IER_WOL (0x1u << 28) /**< \brief (GMAC_IER) Wake On LAN */
/* -------- GMAC_IDR : (GMAC Offset: 0x02C) Interrupt Disable Register -------- */
#define GMAC_IDR_MFS (0x1u << 0) /**< \brief (GMAC_IDR) Management Frame Sent */
#define GMAC_IDR_RCOMP (0x1u << 1) /**< \brief (GMAC_IDR) Receive Complete */
#define GMAC_IDR_RXUBR (0x1u << 2) /**< \brief (GMAC_IDR) RX Used Bit Read */
#define GMAC_IDR_TXUBR (0x1u << 3) /**< \brief (GMAC_IDR) TX Used Bit Read */
#define GMAC_IDR_TUR (0x1u << 4) /**< \brief (GMAC_IDR) Transmit Under Run */
#define GMAC_IDR_RLEX (0x1u << 5) /**< \brief (GMAC_IDR) Retry Limit Exceeded or Late Collision */
#define GMAC_IDR_TFC (0x1u << 6) /**< \brief (GMAC_IDR) Transmit Frame Corruption due to AHB error */
#define GMAC_IDR_TCOMP (0x1u << 7) /**< \brief (GMAC_IDR) Transmit Complete */
#define GMAC_IDR_ROVR (0x1u << 10) /**< \brief (GMAC_IDR) Receive Overrun */
#define GMAC_IDR_HRESP (0x1u << 11) /**< \brief (GMAC_IDR) HRESP Not OK */
#define GMAC_IDR_PFNZ (0x1u << 12) /**< \brief (GMAC_IDR) Pause Frame with Non-zero Pause Quantum Received */
#define GMAC_IDR_PTZ (0x1u << 13) /**< \brief (GMAC_IDR) Pause Time Zero */
#define GMAC_IDR_PFTR (0x1u << 14) /**< \brief (GMAC_IDR) Pause Frame Transmitted */
#define GMAC_IDR_EXINT (0x1u << 15) /**< \brief (GMAC_IDR) External Interrupt */
#define GMAC_IDR_DRQFR (0x1u << 18) /**< \brief (GMAC_IDR) PTP Delay Request Frame Received */
#define GMAC_IDR_SFR (0x1u << 19) /**< \brief (GMAC_IDR) PTP Sync Frame Received */
#define GMAC_IDR_DRQFT (0x1u << 20) /**< \brief (GMAC_IDR) PTP Delay Request Frame Transmitted */
#define GMAC_IDR_SFT (0x1u << 21) /**< \brief (GMAC_IDR) PTP Sync Frame Transmitted */
#define GMAC_IDR_PDRQFR (0x1u << 22) /**< \brief (GMAC_IDR) PDelay Request Frame Received */
#define GMAC_IDR_PDRSFR (0x1u << 23) /**< \brief (GMAC_IDR) PDelay Response Frame Received */
#define GMAC_IDR_PDRQFT (0x1u << 24) /**< \brief (GMAC_IDR) PDelay Request Frame Transmitted */
#define GMAC_IDR_PDRSFT (0x1u << 25) /**< \brief (GMAC_IDR) PDelay Response Frame Transmitted */
#define GMAC_IDR_SRI (0x1u << 26) /**< \brief (GMAC_IDR) TSU Seconds Register Increment */
#define GMAC_IDR_WOL (0x1u << 28) /**< \brief (GMAC_IDR) Wake On LAN */
/* -------- GMAC_IMR : (GMAC Offset: 0x030) Interrupt Mask Register -------- */
#define GMAC_IMR_MFS (0x1u << 0) /**< \brief (GMAC_IMR) Management Frame Sent */
#define GMAC_IMR_RCOMP (0x1u << 1) /**< \brief (GMAC_IMR) Receive Complete */
#define GMAC_IMR_RXUBR (0x1u << 2) /**< \brief (GMAC_IMR) RX Used Bit Read */
#define GMAC_IMR_TXUBR (0x1u << 3) /**< \brief (GMAC_IMR) TX Used Bit Read */
#define GMAC_IMR_TUR (0x1u << 4) /**< \brief (GMAC_IMR) Transmit Under Run */
#define GMAC_IMR_RLEX (0x1u << 5) /**< \brief (GMAC_IMR) Retry Limit Exceeded */
#define GMAC_IMR_TFC (0x1u << 6) /**< \brief (GMAC_IMR) Transmit Frame Corruption due to AHB error */
#define GMAC_IMR_TCOMP (0x1u << 7) /**< \brief (GMAC_IMR) Transmit Complete */
#define GMAC_IMR_ROVR (0x1u << 10) /**< \brief (GMAC_IMR) Receive Overrun */
#define GMAC_IMR_HRESP (0x1u << 11) /**< \brief (GMAC_IMR) HRESP Not OK */
#define GMAC_IMR_PFNZ (0x1u << 12) /**< \brief (GMAC_IMR) Pause Frame with Non-zero Pause Quantum Received */
#define GMAC_IMR_PTZ (0x1u << 13) /**< \brief (GMAC_IMR) Pause Time Zero */
#define GMAC_IMR_PFTR (0x1u << 14) /**< \brief (GMAC_IMR) Pause Frame Transmitted */
#define GMAC_IMR_EXINT (0x1u << 15) /**< \brief (GMAC_IMR) External Interrupt */
#define GMAC_IMR_DRQFR (0x1u << 18) /**< \brief (GMAC_IMR) PTP Delay Request Frame Received */
#define GMAC_IMR_SFR (0x1u << 19) /**< \brief (GMAC_IMR) PTP Sync Frame Received */
#define GMAC_IMR_DRQFT (0x1u << 20) /**< \brief (GMAC_IMR) PTP Delay Request Frame Transmitted */
#define GMAC_IMR_SFT (0x1u << 21) /**< \brief (GMAC_IMR) PTP Sync Frame Transmitted */
#define GMAC_IMR_PDRQFR (0x1u << 22) /**< \brief (GMAC_IMR) PDelay Request Frame Received */
#define GMAC_IMR_PDRSFR (0x1u << 23) /**< \brief (GMAC_IMR) PDelay Response Frame Received */
#define GMAC_IMR_PDRQFT (0x1u << 24) /**< \brief (GMAC_IMR) PDelay Request Frame Transmitted */
#define GMAC_IMR_PDRSFT (0x1u << 25) /**< \brief (GMAC_IMR) PDelay Response Frame Transmitted */
/* -------- GMAC_MAN : (GMAC Offset: 0x034) PHY Maintenance Register -------- */
#define GMAC_MAN_DATA_Pos 0
#define GMAC_MAN_DATA_Msk (0xffffu << GMAC_MAN_DATA_Pos) /**< \brief (GMAC_MAN) PHY Data */
#define GMAC_MAN_DATA(value) ((GMAC_MAN_DATA_Msk & ((value) << GMAC_MAN_DATA_Pos)))
#define GMAC_MAN_WTN_Pos 16
#define GMAC_MAN_WTN_Msk (0x3u << GMAC_MAN_WTN_Pos) /**< \brief (GMAC_MAN) Write Ten */
#define GMAC_MAN_WTN(value) ((GMAC_MAN_WTN_Msk & ((value) << GMAC_MAN_WTN_Pos)))
#define GMAC_MAN_REGA_Pos 18
#define GMAC_MAN_REGA_Msk (0x1fu << GMAC_MAN_REGA_Pos) /**< \brief (GMAC_MAN) Register Address */
#define GMAC_MAN_REGA(value) ((GMAC_MAN_REGA_Msk & ((value) << GMAC_MAN_REGA_Pos)))
#define GMAC_MAN_PHYA_Pos 23
#define GMAC_MAN_PHYA_Msk (0x1fu << GMAC_MAN_PHYA_Pos) /**< \brief (GMAC_MAN) PHY Address */
#define GMAC_MAN_PHYA(value) ((GMAC_MAN_PHYA_Msk & ((value) << GMAC_MAN_PHYA_Pos)))
#define GMAC_MAN_OP_Pos 28
#define GMAC_MAN_OP_Msk (0x3u << GMAC_MAN_OP_Pos) /**< \brief (GMAC_MAN) Operation */
#define GMAC_MAN_OP(value) ((GMAC_MAN_OP_Msk & ((value) << GMAC_MAN_OP_Pos)))
#define GMAC_MAN_CLTTO (0x1u << 30) /**< \brief (GMAC_MAN) Clause 22 Operation */
#define GMAC_MAN_WZO (0x1u << 31) /**< \brief (GMAC_MAN) Write ZERO */
/* -------- GMAC_RPQ : (GMAC Offset: 0x038) Received Pause Quantum Register -------- */
#define GMAC_RPQ_RPQ_Pos 0
#define GMAC_RPQ_RPQ_Msk (0xffffu << GMAC_RPQ_RPQ_Pos) /**< \brief (GMAC_RPQ) Received Pause Quantum */
/* -------- GMAC_TPQ : (GMAC Offset: 0x03C) Transmit Pause Quantum Register -------- */
#define GMAC_TPQ_TPQ_Pos 0
#define GMAC_TPQ_TPQ_Msk (0xffffu << GMAC_TPQ_TPQ_Pos) /**< \brief (GMAC_TPQ) Transmit Pause Quantum */
#define GMAC_TPQ_TPQ(value) ((GMAC_TPQ_TPQ_Msk & ((value) << GMAC_TPQ_TPQ_Pos)))
/* -------- GMAC_HRB : (GMAC Offset: 0x080) Hash Register Bottom [31:0] -------- */
#define GMAC_HRB_ADDR_Pos 0
#define GMAC_HRB_ADDR_Msk (0xffffffffu << GMAC_HRB_ADDR_Pos) /**< \brief (GMAC_HRB) Hash Address */
#define GMAC_HRB_ADDR(value) ((GMAC_HRB_ADDR_Msk & ((value) << GMAC_HRB_ADDR_Pos)))
/* -------- GMAC_HRT : (GMAC Offset: 0x084) Hash Register Top [63:32] -------- */
#define GMAC_HRT_ADDR_Pos 0
#define GMAC_HRT_ADDR_Msk (0xffffffffu << GMAC_HRT_ADDR_Pos) /**< \brief (GMAC_HRT) Hash Address */
#define GMAC_HRT_ADDR(value) ((GMAC_HRT_ADDR_Msk & ((value) << GMAC_HRT_ADDR_Pos)))
/* -------- GMAC_SAB1 : (GMAC Offset: 0x088) Specific Address 1 Bottom [31:0] Register -------- */
#define GMAC_SAB1_ADDR_Pos 0
#define GMAC_SAB1_ADDR_Msk (0xffffffffu << GMAC_SAB1_ADDR_Pos) /**< \brief (GMAC_SAB1) Specific Address 1 */
#define GMAC_SAB1_ADDR(value) ((GMAC_SAB1_ADDR_Msk & ((value) << GMAC_SAB1_ADDR_Pos)))
/* -------- GMAC_SAT1 : (GMAC Offset: 0x08C) Specific Address 1 Top [47:32] Register -------- */
#define GMAC_SAT1_ADDR_Pos 0
#define GMAC_SAT1_ADDR_Msk (0xffffu << GMAC_SAT1_ADDR_Pos) /**< \brief (GMAC_SAT1) Specific Address 1 */
#define GMAC_SAT1_ADDR(value) ((GMAC_SAT1_ADDR_Msk & ((value) << GMAC_SAT1_ADDR_Pos)))
/* -------- GMAC_SAB2 : (GMAC Offset: 0x090) Specific Address 2 Bottom [31:0] Register -------- */
#define GMAC_SAB2_ADDR_Pos 0
#define GMAC_SAB2_ADDR_Msk (0xffffffffu << GMAC_SAB2_ADDR_Pos) /**< \brief (GMAC_SAB2) Specific Address 2 */
#define GMAC_SAB2_ADDR(value) ((GMAC_SAB2_ADDR_Msk & ((value) << GMAC_SAB2_ADDR_Pos)))
/* -------- GMAC_SAT2 : (GMAC Offset: 0x094) Specific Address 2 Top [47:32] Register -------- */
#define GMAC_SAT2_ADDR_Pos 0
#define GMAC_SAT2_ADDR_Msk (0xffffu << GMAC_SAT2_ADDR_Pos) /**< \brief (GMAC_SAT2) Specific Address 2 */
#define GMAC_SAT2_ADDR(value) ((GMAC_SAT2_ADDR_Msk & ((value) << GMAC_SAT2_ADDR_Pos)))
/* -------- GMAC_SAB3 : (GMAC Offset: 0x098) Specific Address 3 Bottom [31:0] Register -------- */
#define GMAC_SAB3_ADDR_Pos 0
#define GMAC_SAB3_ADDR_Msk (0xffffffffu << GMAC_SAB3_ADDR_Pos) /**< \brief (GMAC_SAB3) Specific Address 3 */
#define GMAC_SAB3_ADDR(value) ((GMAC_SAB3_ADDR_Msk & ((value) << GMAC_SAB3_ADDR_Pos)))
/* -------- GMAC_SAT3 : (GMAC Offset: 0x09C) Specific Address 3 Top [47:32] Register -------- */
#define GMAC_SAT3_ADDR_Pos 0
#define GMAC_SAT3_ADDR_Msk (0xffffu << GMAC_SAT3_ADDR_Pos) /**< \brief (GMAC_SAT3) Specific Address 3 */
#define GMAC_SAT3_ADDR(value) ((GMAC_SAT3_ADDR_Msk & ((value) << GMAC_SAT3_ADDR_Pos)))
/* -------- GMAC_SAB4 : (GMAC Offset: 0x0A0) Specific Address 4 Bottom [31:0] Register -------- */
#define GMAC_SAB4_ADDR_Pos 0
#define GMAC_SAB4_ADDR_Msk (0xffffffffu << GMAC_SAB4_ADDR_Pos) /**< \brief (GMAC_SAB4) Specific Address 4 */
#define GMAC_SAB4_ADDR(value) ((GMAC_SAB4_ADDR_Msk & ((value) << GMAC_SAB4_ADDR_Pos)))
/* -------- GMAC_SAT4 : (GMAC Offset: 0x0A4) Specific Address 4 Top [47:32] Register -------- */
#define GMAC_SAT4_ADDR_Pos 0
#define GMAC_SAT4_ADDR_Msk (0xffffu << GMAC_SAT4_ADDR_Pos) /**< \brief (GMAC_SAT4) Specific Address 4 */
#define GMAC_SAT4_ADDR(value) ((GMAC_SAT4_ADDR_Msk & ((value) << GMAC_SAT4_ADDR_Pos)))
/* -------- GMAC_TIDM[4] : (GMAC Offset: 0x0A8) Type ID Match 1 Register -------- */
#define GMAC_TIDM_TID_Pos 0
#define GMAC_TIDM_TID_Msk (0xffffu << GMAC_TIDM_TID_Pos) /**< \brief (GMAC_TIDM[4]) Type ID Match 1 */
#define GMAC_TIDM_TID(value) ((GMAC_TIDM_TID_Msk & ((value) << GMAC_TIDM_TID_Pos)))
/* -------- GMAC_WOL : (GMAC Offset: 0x0B8) Wake on LAN Register -------- */
#define GMAC_WOL_IP_Pos 0
#define GMAC_WOL_IP_Msk (0xffffu << GMAC_WOL_IP_Pos) /**< \brief (GMAC_WOL) ARP Request IP Address */
#define GMAC_WOL_IP(value) ((GMAC_WOL_IP_Msk & ((value) << GMAC_WOL_IP_Pos)))
#define GMAC_WOL_MAG (0x1u << 16) /**< \brief (GMAC_WOL) Magic Packet Event Enable */
#define GMAC_WOL_ARP (0x1u << 17) /**< \brief (GMAC_WOL) ARP Request IP Address */
#define GMAC_WOL_SA1 (0x1u << 18) /**< \brief (GMAC_WOL) Specific Address Register 1 Event Enable */
#define GMAC_WOL_MTI (0x1u << 19) /**< \brief (GMAC_WOL) Multicast Hash Event Enable */
/* -------- GMAC_IPGS : (GMAC Offset: 0x0BC) IPG Stretch Register -------- */
#define GMAC_IPGS_FL_Pos 0
#define GMAC_IPGS_FL_Msk (0xffffu << GMAC_IPGS_FL_Pos) /**< \brief (GMAC_IPGS) Frame Length */
#define GMAC_IPGS_FL(value) ((GMAC_IPGS_FL_Msk & ((value) << GMAC_IPGS_FL_Pos)))
/* -------- GMAC_SVLAN : (GMAC Offset: 0x0C0) Stacked VLAN Register -------- */
#define GMAC_SVLAN_VLAN_TYPE_Pos 0
#define GMAC_SVLAN_VLAN_TYPE_Msk (0xffffu << GMAC_SVLAN_VLAN_TYPE_Pos) /**< \brief (GMAC_SVLAN) User Defined VLAN_TYPE Field */
#define GMAC_SVLAN_VLAN_TYPE(value) ((GMAC_SVLAN_VLAN_TYPE_Msk & ((value) << GMAC_SVLAN_VLAN_TYPE_Pos)))
#define GMAC_SVLAN_ESVLAN (0x1u << 31) /**< \brief (GMAC_SVLAN) Enable Stacked VLAN Processing Mode */
/* -------- GMAC_TPFCP : (GMAC Offset: 0x0C4) Transmit PFC Pause Register -------- */
#define GMAC_TPFCP_PEV_Pos 0
#define GMAC_TPFCP_PEV_Msk (0xffu << GMAC_TPFCP_PEV_Pos) /**< \brief (GMAC_TPFCP) Priority Enable Vector */
#define GMAC_TPFCP_PEV(value) ((GMAC_TPFCP_PEV_Msk & ((value) << GMAC_TPFCP_PEV_Pos)))
#define GMAC_TPFCP_PQ_Pos 8
#define GMAC_TPFCP_PQ_Msk (0xffu << GMAC_TPFCP_PQ_Pos) /**< \brief (GMAC_TPFCP) Pause Quantum */
#define GMAC_TPFCP_PQ(value) ((GMAC_TPFCP_PQ_Msk & ((value) << GMAC_TPFCP_PQ_Pos)))
/* -------- GMAC_SAMB1 : (GMAC Offset: 0x0C8) Specific Address 1 Mask Bottom [31:0] Register -------- */
#define GMAC_SAMB1_ADDR_Pos 0
#define GMAC_SAMB1_ADDR_Msk (0xffffffffu << GMAC_SAMB1_ADDR_Pos) /**< \brief (GMAC_SAMB1) Specific Address 1 Mask */
#define GMAC_SAMB1_ADDR(value) ((GMAC_SAMB1_ADDR_Msk & ((value) << GMAC_SAMB1_ADDR_Pos)))
/* -------- GMAC_SAMT1 : (GMAC Offset: 0x0CC) Specific Address 1 Mask Top [47:32] Register -------- */
#define GMAC_SAMT1_ADDR_Pos 0
#define GMAC_SAMT1_ADDR_Msk (0xffffu << GMAC_SAMT1_ADDR_Pos) /**< \brief (GMAC_SAMT1) Specific Address 1 Mask */
#define GMAC_SAMT1_ADDR(value) ((GMAC_SAMT1_ADDR_Msk & ((value) << GMAC_SAMT1_ADDR_Pos)))
/* -------- GMAC_OTLO : (GMAC Offset: 0x100) Octets Transmitted [31:0] Register -------- */
#define GMAC_OTLO_TXO_Pos 0
#define GMAC_OTLO_TXO_Msk (0xffffffffu << GMAC_OTLO_TXO_Pos) /**< \brief (GMAC_OTLO) Transmitted Octets */
/* -------- GMAC_OTHI : (GMAC Offset: 0x104) Octets Transmitted [47:32] Register -------- */
#define GMAC_OTHI_TXO_Pos 0
#define GMAC_OTHI_TXO_Msk (0xffffu << GMAC_OTHI_TXO_Pos) /**< \brief (GMAC_OTHI) Transmitted Octets */
/* -------- GMAC_FT : (GMAC Offset: 0x108) Frames Transmitted Register -------- */
#define GMAC_FT_FTX_Pos 0
#define GMAC_FT_FTX_Msk (0xffffffffu << GMAC_FT_FTX_Pos) /**< \brief (GMAC_FT) Frames Transmitted without Error */
/* -------- GMAC_BCFT : (GMAC Offset: 0x10C) Broadcast Frames Transmitted Register -------- */
#define GMAC_BCFT_BFTX_Pos 0
#define GMAC_BCFT_BFTX_Msk (0xffffffffu << GMAC_BCFT_BFTX_Pos) /**< \brief (GMAC_BCFT) Broadcast Frames Transmitted without Error */
/* -------- GMAC_MFT : (GMAC Offset: 0x110) Multicast Frames Transmitted Register -------- */
#define GMAC_MFT_MFTX_Pos 0
#define GMAC_MFT_MFTX_Msk (0xffffffffu << GMAC_MFT_MFTX_Pos) /**< \brief (GMAC_MFT) Multicast Frames Transmitted without Error */
/* -------- GMAC_PFT : (GMAC Offset: 0x114) Pause Frames Transmitted Register -------- */
#define GMAC_PFT_PFTX_Pos 0
#define GMAC_PFT_PFTX_Msk (0xffffu << GMAC_PFT_PFTX_Pos) /**< \brief (GMAC_PFT) Pause Frames Transmitted Register */
/* -------- GMAC_BFT64 : (GMAC Offset: 0x118) 64 Byte Frames Transmitted Register -------- */
#define GMAC_BFT64_NFTX_Pos 0
#define GMAC_BFT64_NFTX_Msk (0xffffffffu << GMAC_BFT64_NFTX_Pos) /**< \brief (GMAC_BFT64) 64 Byte Frames Transmitted without Error */
/* -------- GMAC_TBFT127 : (GMAC Offset: 0x11C) 65 to 127 Byte Frames Transmitted Register -------- */
#define GMAC_TBFT127_NFTX_Pos 0
#define GMAC_TBFT127_NFTX_Msk (0xffffffffu << GMAC_TBFT127_NFTX_Pos) /**< \brief (GMAC_TBFT127) 65 to 127 Byte Frames Transmitted without Error */
/* -------- GMAC_TBFT255 : (GMAC Offset: 0x120) 128 to 255 Byte Frames Transmitted Register -------- */
#define GMAC_TBFT255_NFTX_Pos 0
#define GMAC_TBFT255_NFTX_Msk (0xffffffffu << GMAC_TBFT255_NFTX_Pos) /**< \brief (GMAC_TBFT255) 128 to 255 Byte Frames Transmitted without Error */
/* -------- GMAC_TBFT511 : (GMAC Offset: 0x124) 256 to 511 Byte Frames Transmitted Register -------- */
#define GMAC_TBFT511_NFTX_Pos 0
#define GMAC_TBFT511_NFTX_Msk (0xffffffffu << GMAC_TBFT511_NFTX_Pos) /**< \brief (GMAC_TBFT511) 256 to 511 Byte Frames Transmitted without Error */
/* -------- GMAC_TBFT1023 : (GMAC Offset: 0x128) 512 to 1023 Byte Frames Transmitted Register -------- */
#define GMAC_TBFT1023_NFTX_Pos 0
#define GMAC_TBFT1023_NFTX_Msk (0xffffffffu << GMAC_TBFT1023_NFTX_Pos) /**< \brief (GMAC_TBFT1023) 512 to 1023 Byte Frames Transmitted without Error */
/* -------- GMAC_TBFT1518 : (GMAC Offset: 0x12C) 1024 to 1518 Byte Frames Transmitted Register -------- */
#define GMAC_TBFT1518_NFTX_Pos 0
#define GMAC_TBFT1518_NFTX_Msk (0xffffffffu << GMAC_TBFT1518_NFTX_Pos) /**< \brief (GMAC_TBFT1518) 1024 to 1518 Byte Frames Transmitted without Error */
/* -------- GMAC_GTBFT1518 : (GMAC Offset: 0x130) Greater Than 1518 Byte Frames Transmitted Register -------- */
#define GMAC_GTBFT1518_NFTX_Pos 0
#define GMAC_GTBFT1518_NFTX_Msk (0xffffffffu << GMAC_GTBFT1518_NFTX_Pos) /**< \brief (GMAC_GTBFT1518) Greater than 1518 Byte Frames Transmitted without Error */
/* -------- GMAC_TUR : (GMAC Offset: 0x134) Transmit Under Runs Register -------- */
#define GMAC_TUR_TXUNR_Pos 0
#define GMAC_TUR_TXUNR_Msk (0x3ffu << GMAC_TUR_TXUNR_Pos) /**< \brief (GMAC_TUR) Transmit Under Runs */
/* -------- GMAC_SCF : (GMAC Offset: 0x138) Single Collision Frames Register -------- */
#define GMAC_SCF_SCOL_Pos 0
#define GMAC_SCF_SCOL_Msk (0x3ffffu << GMAC_SCF_SCOL_Pos) /**< \brief (GMAC_SCF) Single Collision */
/* -------- GMAC_MCF : (GMAC Offset: 0x13C) Multiple Collision Frames Register -------- */
#define GMAC_MCF_MCOL_Pos 0
#define GMAC_MCF_MCOL_Msk (0x3ffffu << GMAC_MCF_MCOL_Pos) /**< \brief (GMAC_MCF) Multiple Collision */
/* -------- GMAC_EC : (GMAC Offset: 0x140) Excessive Collisions Register -------- */
#define GMAC_EC_XCOL_Pos 0
#define GMAC_EC_XCOL_Msk (0x3ffu << GMAC_EC_XCOL_Pos) /**< \brief (GMAC_EC) Excessive Collisions */
/* -------- GMAC_LC : (GMAC Offset: 0x144) Late Collisions Register -------- */
#define GMAC_LC_LCOL_Pos 0
#define GMAC_LC_LCOL_Msk (0x3ffu << GMAC_LC_LCOL_Pos) /**< \brief (GMAC_LC) Late Collisions */
/* -------- GMAC_DTF : (GMAC Offset: 0x148) Deferred Transmission Frames Register -------- */
#define GMAC_DTF_DEFT_Pos 0
#define GMAC_DTF_DEFT_Msk (0x3ffffu << GMAC_DTF_DEFT_Pos) /**< \brief (GMAC_DTF) Deferred Transmission */
/* -------- GMAC_CSE : (GMAC Offset: 0x14C) Carrier Sense Errors Register -------- */
#define GMAC_CSE_CSR_Pos 0
#define GMAC_CSE_CSR_Msk (0x3ffu << GMAC_CSE_CSR_Pos) /**< \brief (GMAC_CSE) Carrier Sense Error */
/* -------- GMAC_ORLO : (GMAC Offset: 0x150) Octets Received [31:0] Received -------- */
#define GMAC_ORLO_RXO_Pos 0
#define GMAC_ORLO_RXO_Msk (0xffffffffu << GMAC_ORLO_RXO_Pos) /**< \brief (GMAC_ORLO) Received Octets */
/* -------- GMAC_ORHI : (GMAC Offset: 0x154) Octets Received [47:32] Received -------- */
#define GMAC_ORHI_RXO_Pos 0
#define GMAC_ORHI_RXO_Msk (0xffffu << GMAC_ORHI_RXO_Pos) /**< \brief (GMAC_ORHI) Received Octets */
/* -------- GMAC_FR : (GMAC Offset: 0x158) Frames Received Register -------- */
#define GMAC_FR_FRX_Pos 0
#define GMAC_FR_FRX_Msk (0xffffffffu << GMAC_FR_FRX_Pos) /**< \brief (GMAC_FR) Frames Received without Error */
/* -------- GMAC_BCFR : (GMAC Offset: 0x15C) Broadcast Frames Received Register -------- */
#define GMAC_BCFR_BFRX_Pos 0
#define GMAC_BCFR_BFRX_Msk (0xffffffffu << GMAC_BCFR_BFRX_Pos) /**< \brief (GMAC_BCFR) Broadcast Frames Received without Error */
/* -------- GMAC_MFR : (GMAC Offset: 0x160) Multicast Frames Received Register -------- */
#define GMAC_MFR_MFRX_Pos 0
#define GMAC_MFR_MFRX_Msk (0xffffffffu << GMAC_MFR_MFRX_Pos) /**< \brief (GMAC_MFR) Multicast Frames Received without Error */
/* -------- GMAC_PFR : (GMAC Offset: 0x164) Pause Frames Received Register -------- */
#define GMAC_PFR_PFRX_Pos 0
#define GMAC_PFR_PFRX_Msk (0xffffu << GMAC_PFR_PFRX_Pos) /**< \brief (GMAC_PFR) Pause Frames Received Register */
/* -------- GMAC_BFR64 : (GMAC Offset: 0x168) 64 Byte Frames Received Register -------- */
#define GMAC_BFR64_NFRX_Pos 0
#define GMAC_BFR64_NFRX_Msk (0xffffffffu << GMAC_BFR64_NFRX_Pos) /**< \brief (GMAC_BFR64) 64 Byte Frames Received without Error */
/* -------- GMAC_TBFR127 : (GMAC Offset: 0x16C) 65 to 127 Byte Frames Received Register -------- */
#define GMAC_TBFR127_NFRX_Pos 0
#define GMAC_TBFR127_NFRX_Msk (0xffffffffu << GMAC_TBFR127_NFRX_Pos) /**< \brief (GMAC_TBFR127) 65 to 127 Byte Frames Received without Error */
/* -------- GMAC_TBFR255 : (GMAC Offset: 0x170) 128 to 255 Byte Frames Received Register -------- */
#define GMAC_TBFR255_NFRX_Pos 0
#define GMAC_TBFR255_NFRX_Msk (0xffffffffu << GMAC_TBFR255_NFRX_Pos) /**< \brief (GMAC_TBFR255) 128 to 255 Byte Frames Received without Error */
/* -------- GMAC_TBFR511 : (GMAC Offset: 0x174) 256 to 511Byte Frames Received Register -------- */
#define GMAC_TBFR511_NFRX_Pos 0
#define GMAC_TBFR511_NFRX_Msk (0xffffffffu << GMAC_TBFR511_NFRX_Pos) /**< \brief (GMAC_TBFR511) 256 to 511 Byte Frames Received without Error */
/* -------- GMAC_TBFR1023 : (GMAC Offset: 0x178) 512 to 1023 Byte Frames Received Register -------- */
#define GMAC_TBFR1023_NFRX_Pos 0
#define GMAC_TBFR1023_NFRX_Msk (0xffffffffu << GMAC_TBFR1023_NFRX_Pos) /**< \brief (GMAC_TBFR1023) 512 to 1023 Byte Frames Received without Error */
/* -------- GMAC_TBFR1518 : (GMAC Offset: 0x17C) 1024 to 1518 Byte Frames Received Register -------- */
#define GMAC_TBFR1518_NFRX_Pos 0
#define GMAC_TBFR1518_NFRX_Msk (0xffffffffu << GMAC_TBFR1518_NFRX_Pos) /**< \brief (GMAC_TBFR1518) 1024 to 1518 Byte Frames Received without Error */
/* -------- GMAC_TMXBFR : (GMAC Offset: 0x180) 1519 to Maximum Byte Frames Received Register -------- */
#define GMAC_TMXBFR_NFRX_Pos 0
#define GMAC_TMXBFR_NFRX_Msk (0xffffffffu << GMAC_TMXBFR_NFRX_Pos) /**< \brief (GMAC_TMXBFR) 1519 to Maximum Byte Frames Received without Error */
/* -------- GMAC_UFR : (GMAC Offset: 0x184) Undersize Frames Received Register -------- */
#define GMAC_UFR_UFRX_Pos 0
#define GMAC_UFR_UFRX_Msk (0x3ffu << GMAC_UFR_UFRX_Pos) /**< \brief (GMAC_UFR) Undersize Frames Received */
/* -------- GMAC_OFR : (GMAC Offset: 0x188) Oversize Frames Received Register -------- */
#define GMAC_OFR_OFRX_Pos 0
#define GMAC_OFR_OFRX_Msk (0x3ffu << GMAC_OFR_OFRX_Pos) /**< \brief (GMAC_OFR) Oversized Frames Received */
/* -------- GMAC_JR : (GMAC Offset: 0x18C) Jabbers Received Register -------- */
#define GMAC_JR_JRX_Pos 0
#define GMAC_JR_JRX_Msk (0x3ffu << GMAC_JR_JRX_Pos) /**< \brief (GMAC_JR) Jabbers Received */
/* -------- GMAC_FCSE : (GMAC Offset: 0x190) Frame Check Sequence Errors Register -------- */
#define GMAC_FCSE_FCKR_Pos 0
#define GMAC_FCSE_FCKR_Msk (0x3ffu << GMAC_FCSE_FCKR_Pos) /**< \brief (GMAC_FCSE) Frame Check Sequence Errors */
/* -------- GMAC_LFFE : (GMAC Offset: 0x194) Length Field Frame Errors Register -------- */
#define GMAC_LFFE_LFER_Pos 0
#define GMAC_LFFE_LFER_Msk (0x3ffu << GMAC_LFFE_LFER_Pos) /**< \brief (GMAC_LFFE) Length Field Frame Errors */
/* -------- GMAC_RSE : (GMAC Offset: 0x198) Receive Symbol Errors Register -------- */
#define GMAC_RSE_RXSE_Pos 0
#define GMAC_RSE_RXSE_Msk (0x3ffu << GMAC_RSE_RXSE_Pos) /**< \brief (GMAC_RSE) Receive Symbol Errors */
/* -------- GMAC_AE : (GMAC Offset: 0x19C) Alignment Errors Register -------- */
#define GMAC_AE_AER_Pos 0
#define GMAC_AE_AER_Msk (0x3ffu << GMAC_AE_AER_Pos) /**< \brief (GMAC_AE) Alignment Errors */
/* -------- GMAC_RRE : (GMAC Offset: 0x1A0) Receive Resource Errors Register -------- */
#define GMAC_RRE_RXRER_Pos 0
#define GMAC_RRE_RXRER_Msk (0x3ffffu << GMAC_RRE_RXRER_Pos) /**< \brief (GMAC_RRE) Receive Resource Errors */
/* -------- GMAC_ROE : (GMAC Offset: 0x1A4) Receive Overrun Register -------- */
#define GMAC_ROE_RXOVR_Pos 0
#define GMAC_ROE_RXOVR_Msk (0x3ffu << GMAC_ROE_RXOVR_Pos) /**< \brief (GMAC_ROE) Receive Overruns */
/* -------- GMAC_IHCE : (GMAC Offset: 0x1A8) IP Header Checksum Errors Register -------- */
#define GMAC_IHCE_HCKER_Pos 0
#define GMAC_IHCE_HCKER_Msk (0xffu << GMAC_IHCE_HCKER_Pos) /**< \brief (GMAC_IHCE) IP Header Checksum Errors */
/* -------- GMAC_TCE : (GMAC Offset: 0x1AC) TCP Checksum Errors Register -------- */
#define GMAC_TCE_TCKER_Pos 0
#define GMAC_TCE_TCKER_Msk (0xffu << GMAC_TCE_TCKER_Pos) /**< \brief (GMAC_TCE) TCP Checksum Errors */
/* -------- GMAC_UCE : (GMAC Offset: 0x1B0) UDP Checksum Errors Register -------- */
#define GMAC_UCE_UCKER_Pos 0
#define GMAC_UCE_UCKER_Msk (0xffu << GMAC_UCE_UCKER_Pos) /**< \brief (GMAC_UCE) UDP Checksum Errors */
/* -------- GMAC_TSSS : (GMAC Offset: 0x1C8) 1588 Timer Sync Strobe Seconds Register -------- */
#define GMAC_TSSS_VTS_Pos 0
#define GMAC_TSSS_VTS_Msk (0xffffffffu << GMAC_TSSS_VTS_Pos) /**< \brief (GMAC_TSSS) Value of Timer Seconds Register Capture */
#define GMAC_TSSS_VTS(value) ((GMAC_TSSS_VTS_Msk & ((value) << GMAC_TSSS_VTS_Pos)))
/* -------- GMAC_TSSN : (GMAC Offset: 0x1CC) 1588 Timer Sync Strobe Nanoseconds Register -------- */
#define GMAC_TSSN_VTN_Pos 0
#define GMAC_TSSN_VTN_Msk (0x3fffffffu << GMAC_TSSN_VTN_Pos) /**< \brief (GMAC_TSSN) Value Timer Nanoseconds Register Capture */
#define GMAC_TSSN_VTN(value) ((GMAC_TSSN_VTN_Msk & ((value) << GMAC_TSSN_VTN_Pos)))
/* -------- GMAC_TS : (GMAC Offset: 0x1D0) 1588 Timer Seconds Register -------- */
#define GMAC_TS_TCS_Pos 0
#define GMAC_TS_TCS_Msk (0xffffffffu << GMAC_TS_TCS_Pos) /**< \brief (GMAC_TS) Timer Count in Seconds */
#define GMAC_TS_TCS(value) ((GMAC_TS_TCS_Msk & ((value) << GMAC_TS_TCS_Pos)))
/* -------- GMAC_TN : (GMAC Offset: 0x1D4) 1588 Timer Nanoseconds Register -------- */
#define GMAC_TN_TNS_Pos 0
#define GMAC_TN_TNS_Msk (0x3fffffffu << GMAC_TN_TNS_Pos) /**< \brief (GMAC_TN) Timer Count in Nanoseconds */
#define GMAC_TN_TNS(value) ((GMAC_TN_TNS_Msk & ((value) << GMAC_TN_TNS_Pos)))
/* -------- GMAC_TA : (GMAC Offset: 0x1D8) 1588 Timer Adjust Register -------- */
#define GMAC_TA_ITDT_Pos 0
#define GMAC_TA_ITDT_Msk (0x3fffffffu << GMAC_TA_ITDT_Pos) /**< \brief (GMAC_TA) Increment/Decrement */
#define GMAC_TA_ITDT(value) ((GMAC_TA_ITDT_Msk & ((value) << GMAC_TA_ITDT_Pos)))
#define GMAC_TA_ADJ (0x1u << 31) /**< \brief (GMAC_TA) Adjust 1588 Timer */
/* -------- GMAC_TI : (GMAC Offset: 0x1DC) 1588 Timer Increment Register -------- */
#define GMAC_TI_CNS_Pos 0
#define GMAC_TI_CNS_Msk (0xffu << GMAC_TI_CNS_Pos) /**< \brief (GMAC_TI) Count Nanoseconds */
#define GMAC_TI_CNS(value) ((GMAC_TI_CNS_Msk & ((value) << GMAC_TI_CNS_Pos)))
#define GMAC_TI_ACNS_Pos 8
#define GMAC_TI_ACNS_Msk (0xffu << GMAC_TI_ACNS_Pos) /**< \brief (GMAC_TI) Alternative Count Nanoseconds */
#define GMAC_TI_ACNS(value) ((GMAC_TI_ACNS_Msk & ((value) << GMAC_TI_ACNS_Pos)))
#define GMAC_TI_NIT_Pos 16
#define GMAC_TI_NIT_Msk (0xffu << GMAC_TI_NIT_Pos) /**< \brief (GMAC_TI) Number of Increments */
#define GMAC_TI_NIT(value) ((GMAC_TI_NIT_Msk & ((value) << GMAC_TI_NIT_Pos)))
/* -------- GMAC_EFTS : (GMAC Offset: 0x1E0) PTP Event Frame Transmitted Seconds -------- */
#define GMAC_EFTS_RUD_Pos 0
#define GMAC_EFTS_RUD_Msk (0xffffffffu << GMAC_EFTS_RUD_Pos) /**< \brief (GMAC_EFTS) Register Update */
/* -------- GMAC_EFTN : (GMAC Offset: 0x1E4) PTP Event Frame Transmitted Nanoseconds -------- */
#define GMAC_EFTN_RUD_Pos 0
#define GMAC_EFTN_RUD_Msk (0x3fffffffu << GMAC_EFTN_RUD_Pos) /**< \brief (GMAC_EFTN) Register Update */
/* -------- GMAC_EFRS : (GMAC Offset: 0x1E8) PTP Event Frame Received Seconds -------- */
#define GMAC_EFRS_RUD_Pos 0
#define GMAC_EFRS_RUD_Msk (0xffffffffu << GMAC_EFRS_RUD_Pos) /**< \brief (GMAC_EFRS) Register Update */
/* -------- GMAC_EFRN : (GMAC Offset: 0x1EC) PTP Event Frame Received Nanoseconds -------- */
#define GMAC_EFRN_RUD_Pos 0
#define GMAC_EFRN_RUD_Msk (0x3fffffffu << GMAC_EFRN_RUD_Pos) /**< \brief (GMAC_EFRN) Register Update */
/* -------- GMAC_PEFTS : (GMAC Offset: 0x1F0) PTP Peer Event Frame Transmitted Seconds -------- */
#define GMAC_PEFTS_RUD_Pos 0
#define GMAC_PEFTS_RUD_Msk (0xffffffffu << GMAC_PEFTS_RUD_Pos) /**< \brief (GMAC_PEFTS) Register Update */
/* -------- GMAC_PEFTN : (GMAC Offset: 0x1F4) PTP Peer Event Frame Transmitted Nanoseconds -------- */
#define GMAC_PEFTN_RUD_Pos 0
#define GMAC_PEFTN_RUD_Msk (0x3fffffffu << GMAC_PEFTN_RUD_Pos) /**< \brief (GMAC_PEFTN) Register Update */
/* -------- GMAC_PEFRS : (GMAC Offset: 0x1F8) PTP Peer Event Frame Received Seconds -------- */
#define GMAC_PEFRS_RUD_Pos 0
#define GMAC_PEFRS_RUD_Msk (0xffffffffu << GMAC_PEFRS_RUD_Pos) /**< \brief (GMAC_PEFRS) Register Update */
/* -------- GMAC_PEFRN : (GMAC Offset: 0x1FC) PTP Peer Event Frame Received Nanoseconds -------- */
#define GMAC_PEFRN_RUD_Pos 0
#define GMAC_PEFRN_RUD_Msk (0x3fffffffu << GMAC_PEFRN_RUD_Pos) /**< \brief (GMAC_PEFRN) Register Update */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Static Memory Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_HSMC Static Memory Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief HsmcCs_number hardware registers */
typedef struct {
  __IO uint32_t HSMC_SETUP;   /**< \brief (HsmcCs_number Offset: 0x0) HSMC Setup Register */
  __IO uint32_t HSMC_PULSE;   /**< \brief (HsmcCs_number Offset: 0x4) HSMC Pulse Register */
  __IO uint32_t HSMC_CYCLE;   /**< \brief (HsmcCs_number Offset: 0x8) HSMC Cycle Register */
  __IO uint32_t HSMC_TIMINGS; /**< \brief (HsmcCs_number Offset: 0xC) HSMC Timings Register */
  __IO uint32_t HSMC_MODE;    /**< \brief (HsmcCs_number Offset: 0x10) HSMC Mode Register */
} HsmcCs_number;
/** \brief HsmcPmecc hardware registers */
typedef struct {
  __I uint32_t HSMC_PMECC[11]; /**< \brief (HsmcPmecc Offset: 0x0) PMECC Redundancy x Register */
  __I uint32_t Reserved1[5];
} HsmcPmecc;
/** \brief HsmcRem hardware registers */
typedef struct {
  __I uint32_t HSMC_REM[12]; /**< \brief (HsmcRem Offset: 0x0) PMECC Remainder x Register */
  __I uint32_t Reserved2[4];
} HsmcRem;
/** \brief Hsmc hardware registers */
#define HSMCPMECC_NUMBER 8
#define HSMCREM_NUMBER 8
#define HSMCCS_NUMBER_NUMBER 4
typedef struct {
  __IO uint32_t      HSMC_CFG;                             /**< \brief (Hsmc Offset: 0x000) HSMC NFC Configuration Register */
  __O  uint32_t      HSMC_CTRL;                            /**< \brief (Hsmc Offset: 0x004) HSMC NFC Control Register */
  __I  uint32_t      HSMC_SR;                              /**< \brief (Hsmc Offset: 0x008) HSMC NFC Status Register */
  __O  uint32_t      HSMC_IER;                             /**< \brief (Hsmc Offset: 0x00C) HSMC NFC Interrupt Enable Register */
  __O  uint32_t      HSMC_IDR;                             /**< \brief (Hsmc Offset: 0x010) HSMC NFC Interrupt Disable Register */
  __I  uint32_t      HSMC_IMR;                             /**< \brief (Hsmc Offset: 0x014) HSMC NFC Interrupt Mask Register */
  __IO uint32_t      HSMC_ADDR;                            /**< \brief (Hsmc Offset: 0x018) HSMC NFC Address Cycle Zero Register */
  __IO uint32_t      HSMC_BANK;                            /**< \brief (Hsmc Offset: 0x01C) HSMC Bank Address Register */
  __O  uint32_t      HSMC_ECC_CTRL;                        /**< \brief (Hsmc Offset: 0x020) HSMC ECC Control Register */
  __IO uint32_t      HSMC_ECC_MD;                          /**< \brief (Hsmc Offset: 0x024) HSMC ECC Mode Register */
  __I  uint32_t      HSMC_ECC_SR1;                         /**< \brief (Hsmc Offset: 0x028) HSMC ECC Status 1 Register */
  __I  uint32_t      HSMC_ECC_PR0;                         /**< \brief (Hsmc Offset: 0x02C) HSMC ECC Parity 0 Register */
  __I  uint32_t      HSMC_ECC_PR1;                         /**< \brief (Hsmc Offset: 0x030) HSMC ECC parity 1 Register */
  __I  uint32_t      HSMC_ECC_SR2;                         /**< \brief (Hsmc Offset: 0x034) HSMC ECC status 2 Register */
  __I  uint32_t      HSMC_ECC_PR2;                         /**< \brief (Hsmc Offset: 0x038) HSMC ECC parity 2 Register */
  __I  uint32_t      HSMC_ECC_PR3;                         /**< \brief (Hsmc Offset: 0x03C) HSMC ECC parity 3 Register */
  __I  uint32_t      HSMC_ECC_PR4;                         /**< \brief (Hsmc Offset: 0x040) HSMC ECC parity 4 Register */
  __I  uint32_t      HSMC_ECC_PR5;                         /**< \brief (Hsmc Offset: 0x044) HSMC ECC parity 5 Register */
  __I  uint32_t      HSMC_ECC_PR6;                         /**< \brief (Hsmc Offset: 0x048) HSMC ECC parity 6 Register */
  __I  uint32_t      HSMC_ECC_PR7;                         /**< \brief (Hsmc Offset: 0x04C) HSMC ECC parity 7 Register */
  __I  uint32_t      HSMC_ECC_PR8;                         /**< \brief (Hsmc Offset: 0x050) HSMC ECC parity 8 Register */
  __I  uint32_t      HSMC_ECC_PR9;                         /**< \brief (Hsmc Offset: 0x054) HSMC ECC parity 9 Register */
  __I  uint32_t      HSMC_ECC_PR10;                        /**< \brief (Hsmc Offset: 0x058) HSMC ECC parity 10 Register */
  __I  uint32_t      HSMC_ECC_PR11;                        /**< \brief (Hsmc Offset: 0x05C) HSMC ECC parity 11 Register */
  __I  uint32_t      HSMC_ECC_PR12;                        /**< \brief (Hsmc Offset: 0x060) HSMC ECC parity 12 Register */
  __I  uint32_t      HSMC_ECC_PR13;                        /**< \brief (Hsmc Offset: 0x064) HSMC ECC parity 13 Register */
  __I  uint32_t      HSMC_ECC_PR14;                        /**< \brief (Hsmc Offset: 0x068) HSMC ECC parity 14 Register */
  __I  uint32_t      HSMC_ECC_PR15;                        /**< \brief (Hsmc Offset: 0x06C) HSMC ECC parity 15 Register */
  __IO uint32_t      HSMC_PMECCFG;                         /**< \brief (Hsmc Offset: 0x70) PMECC Configuration Register */
  __IO uint32_t      HSMC_PMECCSAREA;                      /**< \brief (Hsmc Offset: 0x74) PMECC Spare Area Size Register */
  __IO uint32_t      HSMC_PMECCSADDR;                      /**< \brief (Hsmc Offset: 0x78) PMECC Start Address Register */
  __IO uint32_t      HSMC_PMECCEADDR;                      /**< \brief (Hsmc Offset: 0x7C) PMECC End Address Register */
  __I  uint32_t      Reserved1[1];
  __O  uint32_t      HSMC_PMECCTRL;                        /**< \brief (Hsmc Offset: 0x84) PMECC Control Register */
  __I  uint32_t      HSMC_PMECCSR;                         /**< \brief (Hsmc Offset: 0x88) PMECC Status Register */
  __O  uint32_t      HSMC_PMECCIER;                        /**< \brief (Hsmc Offset: 0x8C) PMECC Interrupt Enable register */
  __O  uint32_t      HSMC_PMECCIDR;                        /**< \brief (Hsmc Offset: 0x90) PMECC Interrupt Disable Register */
  __I  uint32_t      HSMC_PMECCIMR;                        /**< \brief (Hsmc Offset: 0x94) PMECC Interrupt Mask Register */
  __I  uint32_t      HSMC_PMECCISR;                        /**< \brief (Hsmc Offset: 0x98) PMECC Interrupt Status Register */
  __I  uint32_t      Reserved2[5];
       HsmcPmecc     HSMC_PMECC[HSMCPMECC_NUMBER];         /**< \brief (Hsmc Offset: 0xB0) sec_num = 0 .. 7 */
       HsmcRem       HSMC_REM[HSMCREM_NUMBER];             /**< \brief (Hsmc Offset: 0x2B0) sec_num = 0 .. 7 */
  __I  uint32_t      Reserved3[20];
  __IO uint32_t      HSMC_ELCFG;                           /**< \brief (Hsmc Offset: 0x500) PMECC Error Location Configuration Register */
  __I  uint32_t      HSMC_ELPRIM;                          /**< \brief (Hsmc Offset: 0x504) PMECC Error Location Primitive Register */
  __O  uint32_t      HSMC_ELEN;                            /**< \brief (Hsmc Offset: 0x508) PMECC Error Location Enable Register */
  __O  uint32_t      HSMC_ELDIS;                           /**< \brief (Hsmc Offset: 0x50C) PMECC Error Location Disable Register */
  __I  uint32_t      HSMC_ELSR;                            /**< \brief (Hsmc Offset: 0x510) PMECC Error Location Status Register */
  __O  uint32_t      HSMC_ELIER;                           /**< \brief (Hsmc Offset: 0x514) PMECC Error Location Interrupt Enable register */
  __O  uint32_t      HSMC_ELIDR;                           /**< \brief (Hsmc Offset: 0x518) PMECC Error Location Interrupt Disable Register */
  __I  uint32_t      HSMC_ELIMR;                           /**< \brief (Hsmc Offset: 0x51C) PMECC Error Location Interrupt Mask Register */
  __I  uint32_t      HSMC_ELISR;                           /**< \brief (Hsmc Offset: 0x520) PMECC Error Location Interrupt Status Register */
  __I  uint32_t      Reserved4[1];
  __IO uint32_t      HSMC_SIGMA0;                          /**< \brief (Hsmc Offset: 0x528) PMECC Error Location SIGMA 0 Register */
  __IO uint32_t      HSMC_SIGMA1;                          /**< \brief (Hsmc Offset: 0x52C) PMECC Error Location SIGMA 1 Register */
  __IO uint32_t      HSMC_SIGMA2;                          /**< \brief (Hsmc Offset: 0x530) PMECC Error Location SIGMA 2 Register */
  __IO uint32_t      HSMC_SIGMA3;                          /**< \brief (Hsmc Offset: 0x534) PMECC Error Location SIGMA 3 Register */
  __IO uint32_t      HSMC_SIGMA4;                          /**< \brief (Hsmc Offset: 0x538) PMECC Error Location SIGMA 4 Register */
  __IO uint32_t      HSMC_SIGMA5;                          /**< \brief (Hsmc Offset: 0x53C) PMECC Error Location SIGMA 5 Register */
  __IO uint32_t      HSMC_SIGMA6;                          /**< \brief (Hsmc Offset: 0x540) PMECC Error Location SIGMA 6 Register */
  __IO uint32_t      HSMC_SIGMA7;                          /**< \brief (Hsmc Offset: 0x544) PMECC Error Location SIGMA 7 Register */
  __IO uint32_t      HSMC_SIGMA8;                          /**< \brief (Hsmc Offset: 0x548) PMECC Error Location SIGMA 8 Register */
  __IO uint32_t      HSMC_SIGMA9;                          /**< \brief (Hsmc Offset: 0x54C) PMECC Error Location SIGMA 9 Register */
  __IO uint32_t      HSMC_SIGMA10;                         /**< \brief (Hsmc Offset: 0x550) PMECC Error Location SIGMA 10 Register */
  __IO uint32_t      HSMC_SIGMA11;                         /**< \brief (Hsmc Offset: 0x554) PMECC Error Location SIGMA 11 Register */
  __IO uint32_t      HSMC_SIGMA12;                         /**< \brief (Hsmc Offset: 0x558) PMECC Error Location SIGMA 12 Register */
  __IO uint32_t      HSMC_SIGMA13;                         /**< \brief (Hsmc Offset: 0x55C) PMECC Error Location SIGMA 13 Register */
  __IO uint32_t      HSMC_SIGMA14;                         /**< \brief (Hsmc Offset: 0x560) PMECC Error Location SIGMA 14 Register */
  __IO uint32_t      HSMC_SIGMA15;                         /**< \brief (Hsmc Offset: 0x564) PMECC Error Location SIGMA 15 Register */
  __IO uint32_t      HSMC_SIGMA16;                         /**< \brief (Hsmc Offset: 0x568) PMECC Error Location SIGMA 16 Register */
  __IO uint32_t      HSMC_SIGMA17;                         /**< \brief (Hsmc Offset: 0x56C) PMECC Error Location SIGMA 17 Register */
  __IO uint32_t      HSMC_SIGMA18;                         /**< \brief (Hsmc Offset: 0x570) PMECC Error Location SIGMA 18 Register */
  __IO uint32_t      HSMC_SIGMA19;                         /**< \brief (Hsmc Offset: 0x574) PMECC Error Location SIGMA 19 Register */
  __IO uint32_t      HSMC_SIGMA20;                         /**< \brief (Hsmc Offset: 0x578) PMECC Error Location SIGMA 20 Register */
  __IO uint32_t      HSMC_SIGMA21;                         /**< \brief (Hsmc Offset: 0x57C) PMECC Error Location SIGMA 21 Register */
  __IO uint32_t      HSMC_SIGMA22;                         /**< \brief (Hsmc Offset: 0x580) PMECC Error Location SIGMA 22 Register */
  __IO uint32_t      HSMC_SIGMA23;                         /**< \brief (Hsmc Offset: 0x584) PMECC Error Location SIGMA 23 Register */
  __IO uint32_t      HSMC_SIGMA24;                         /**< \brief (Hsmc Offset: 0x588) PMECC Error Location SIGMA 24 Register */
  __I  uint32_t      HSMC_ERRLOC[24];                      /**< \brief (Hsmc Offset: 0x58C) PMECC Error Location 0 Register */
  __I  uint32_t      Reserved5[5];
       HsmcCs_number HSMC_CS_NUMBER[HSMCCS_NUMBER_NUMBER]; /**< \brief (Hsmc Offset: 0x600) CS_number = 0 .. 3 */
  __I  uint32_t      Reserved6[20];
  __IO uint32_t      HSMC_OCMS;                            /**< \brief (Hsmc Offset: 0x6A0) HSMC OCMS Register */
  __O  uint32_t      HSMC_KEY1;                            /**< \brief (Hsmc Offset: 0x6A4) HSMC OCMS KEY1 Register */
  __O  uint32_t      HSMC_KEY2;                            /**< \brief (Hsmc Offset: 0x6A8) HSMC OCMS KEY2 Register */
  __I  uint32_t      Reserved7[14];
  __O  uint32_t      HSMC_WPCR;                            /**< \brief (Hsmc Offset: 0x6E4) HSMC Write Protection Control Register */
  __I  uint32_t      HSMC_WPSR;                            /**< \brief (Hsmc Offset: 0x6E8) HSMC Write Protection Status Register */
} Hsmc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- HSMC_CFG : (HSMC Offset: 0x000) HSMC NFC Configuration Register -------- */
#define HSMC_CFG_PAGESIZE_Pos 0
#define HSMC_CFG_PAGESIZE_Msk (0x7u << HSMC_CFG_PAGESIZE_Pos) /**< \brief (HSMC_CFG)  */
#define   HSMC_CFG_PAGESIZE_PS512 (0x0u << 0) /**< \brief (HSMC_CFG) Main area 512 Bytes */
#define   HSMC_CFG_PAGESIZE_PS1024 (0x1u << 0) /**< \brief (HSMC_CFG) Main area 1024 Bytes */
#define   HSMC_CFG_PAGESIZE_PS2048 (0x2u << 0) /**< \brief (HSMC_CFG) Main area 2048 Bytes */
#define   HSMC_CFG_PAGESIZE_PS4096 (0x3u << 0) /**< \brief (HSMC_CFG) Main area 4096 Bytes */
#define   HSMC_CFG_PAGESIZE_PS8192 (0x4u << 0) /**< \brief (HSMC_CFG) Main area 8192 Bytes */
#define HSMC_CFG_WSPARE (0x1u << 8) /**< \brief (HSMC_CFG) Write Spare Area */
#define HSMC_CFG_RSPARE (0x1u << 9) /**< \brief (HSMC_CFG) Read Spare Area */
#define HSMC_CFG_EDGECTRL (0x1u << 12) /**< \brief (HSMC_CFG) Rising/Falling Edge Detection Control */
#define HSMC_CFG_RBEDGE (0x1u << 13) /**< \brief (HSMC_CFG) Ready/Busy Signal Edge Detection */
#define HSMC_CFG_DTOCYC_Pos 16
#define HSMC_CFG_DTOCYC_Msk (0xfu << HSMC_CFG_DTOCYC_Pos) /**< \brief (HSMC_CFG) Data Timeout Cycle Number */
#define HSMC_CFG_DTOCYC(value) ((HSMC_CFG_DTOCYC_Msk & ((value) << HSMC_CFG_DTOCYC_Pos)))
#define HSMC_CFG_DTOMUL_Pos 20
#define HSMC_CFG_DTOMUL_Msk (0x7u << HSMC_CFG_DTOMUL_Pos) /**< \brief (HSMC_CFG) Data Timeout Multiplier */
#define   HSMC_CFG_DTOMUL_X1 (0x0u << 20) /**< \brief (HSMC_CFG) DTOCYC */
#define   HSMC_CFG_DTOMUL_X16 (0x1u << 20) /**< \brief (HSMC_CFG) DTOCYC x 16 */
#define   HSMC_CFG_DTOMUL_X128 (0x2u << 20) /**< \brief (HSMC_CFG) DTOCYC x 128 */
#define   HSMC_CFG_DTOMUL_X256 (0x3u << 20) /**< \brief (HSMC_CFG) DTOCYC x 256 */
#define   HSMC_CFG_DTOMUL_X1024 (0x4u << 20) /**< \brief (HSMC_CFG) DTOCYC x 1024 */
#define   HSMC_CFG_DTOMUL_X4096 (0x5u << 20) /**< \brief (HSMC_CFG) DTOCYC x 4096 */
#define   HSMC_CFG_DTOMUL_X65536 (0x6u << 20) /**< \brief (HSMC_CFG) DTOCYC x 65536 */
#define   HSMC_CFG_DTOMUL_X1048576 (0x7u << 20) /**< \brief (HSMC_CFG) DTOCYC x 1048576 */
#define HSMC_CFG_NFCSPARESIZE_Pos 24
#define HSMC_CFG_NFCSPARESIZE_Msk (0x7fu << HSMC_CFG_NFCSPARESIZE_Pos) /**< \brief (HSMC_CFG) NAND Flash Spare Area Size Retrieved by the Host Controller */
#define HSMC_CFG_NFCSPARESIZE(value) ((HSMC_CFG_NFCSPARESIZE_Msk & ((value) << HSMC_CFG_NFCSPARESIZE_Pos)))
/* -------- HSMC_CTRL : (HSMC Offset: 0x004) HSMC NFC Control Register -------- */
#define HSMC_CTRL_NFCEN (0x1u << 0) /**< \brief (HSMC_CTRL) NAND Flash Controller Enable */
#define HSMC_CTRL_NFCDIS (0x1u << 1) /**< \brief (HSMC_CTRL) NAND Flash Controller Disable */
/* -------- HSMC_SR : (HSMC Offset: 0x008) HSMC NFC Status Register -------- */
#define HSMC_SR_SMCSTS (0x1u << 0) /**< \brief (HSMC_SR) NAND Flash Controller Status (this field cannot be reset) */
#define HSMC_SR_RB_RISE (0x1u << 4) /**< \brief (HSMC_SR) Selected Ready Busy Rising Edge Detected */
#define HSMC_SR_RB_FALL (0x1u << 5) /**< \brief (HSMC_SR) Selected Ready Busy Falling Edge Detected */
#define HSMC_SR_NFCBUSY (0x1u << 8) /**< \brief (HSMC_SR) NFC Busy (this field cannot be reset) */
#define HSMC_SR_NFCWR (0x1u << 11) /**< \brief (HSMC_SR) NFC Write/Read Operation (this field cannot be reset) */
#define HSMC_SR_NFCSID_Pos 12
#define HSMC_SR_NFCSID_Msk (0x7u << HSMC_SR_NFCSID_Pos) /**< \brief (HSMC_SR) NFC Chip Select ID (this field cannot be reset) */
#define HSMC_SR_XFRDONE (0x1u << 16) /**< \brief (HSMC_SR) NFC Data Transfer Terminated */
#define HSMC_SR_CMDDONE (0x1u << 17) /**< \brief (HSMC_SR) Command Done */
#define HSMC_SR_ECCRDY (0x1u << 18) /**< \brief (HSMC_SR) Hamming ECC Ready */
#define HSMC_SR_DTOE (0x1u << 20) /**< \brief (HSMC_SR) Data Timeout Error */
#define HSMC_SR_UNDEF (0x1u << 21) /**< \brief (HSMC_SR) Undefined Area Error */
#define HSMC_SR_AWB (0x1u << 22) /**< \brief (HSMC_SR) Accessing While Busy */
#define HSMC_SR_NFCASE (0x1u << 23) /**< \brief (HSMC_SR) NFC Access Size Error */
#define HSMC_SR_RB_EDGE3 (0x1u << 27) /**< \brief (HSMC_SR) Ready/Busy Line 3 Edge Detected */
/* -------- HSMC_IER : (HSMC Offset: 0x00C) HSMC NFC Interrupt Enable Register -------- */
#define HSMC_IER_RB_RISE (0x1u << 4) /**< \brief (HSMC_IER) Ready Busy Rising Edge Detection Interrupt Enable */
#define HSMC_IER_RB_FALL (0x1u << 5) /**< \brief (HSMC_IER) Ready Busy Falling Edge Detection Interrupt Enable */
#define HSMC_IER_XFRDONE (0x1u << 16) /**< \brief (HSMC_IER) Transfer Done Interrupt Enable */
#define HSMC_IER_CMDDONE (0x1u << 17) /**< \brief (HSMC_IER) Command Done Interrupt Enable */
#define HSMC_IER_DTOE (0x1u << 20) /**< \brief (HSMC_IER) Data Timeout Error Interrupt Enable */
#define HSMC_IER_UNDEF (0x1u << 21) /**< \brief (HSMC_IER) Undefined Area Access Interrupt Enable */
#define HSMC_IER_AWB (0x1u << 22) /**< \brief (HSMC_IER) Accessing While Busy Interrupt Enable */
#define HSMC_IER_NFCASE (0x1u << 23) /**< \brief (HSMC_IER) NFC Access Size Error Interrupt Enable */
#define HSMC_IER_RB_EDGE3 (0x1u << 27) /**< \brief (HSMC_IER) Ready/Busy Line 3 Interrupt Enable */
/* -------- HSMC_IDR : (HSMC Offset: 0x010) HSMC NFC Interrupt Disable Register -------- */
#define HSMC_IDR_RB_RISE (0x1u << 4) /**< \brief (HSMC_IDR) Ready Busy Rising Edge Detection Interrupt Disable */
#define HSMC_IDR_RB_FALL (0x1u << 5) /**< \brief (HSMC_IDR) Ready Busy Falling Edge Detection Interrupt Disable */
#define HSMC_IDR_XFRDONE (0x1u << 16) /**< \brief (HSMC_IDR) Transfer Done Interrupt Disable */
#define HSMC_IDR_CMDDONE (0x1u << 17) /**< \brief (HSMC_IDR) Command Done Interrupt Disable */
#define HSMC_IDR_DTOE (0x1u << 20) /**< \brief (HSMC_IDR) Data Timeout Error Interrupt Disable */
#define HSMC_IDR_UNDEF (0x1u << 21) /**< \brief (HSMC_IDR) Undefined Area Access Interrupt Disable */
#define HSMC_IDR_AWB (0x1u << 22) /**< \brief (HSMC_IDR) Accessing While Busy Interrupt Disable */
#define HSMC_IDR_NFCASE (0x1u << 23) /**< \brief (HSMC_IDR) NFC Access Size Error Interrupt Disable */
#define HSMC_IDR_RB_EDGE3 (0x1u << 27) /**< \brief (HSMC_IDR) Ready/Busy Line 3 Interrupt Disable */
/* -------- HSMC_IMR : (HSMC Offset: 0x014) HSMC NFC Interrupt Mask Register -------- */
#define HSMC_IMR_RB_RISE (0x1u << 4) /**< \brief (HSMC_IMR) Ready Busy Rising Edge Detection Interrupt Mask */
#define HSMC_IMR_RB_FALL (0x1u << 5) /**< \brief (HSMC_IMR) Ready Busy Falling Edge Detection Interrupt Mask */
#define HSMC_IMR_XFRDONE (0x1u << 16) /**< \brief (HSMC_IMR) Transfer Done Interrupt Mask */
#define HSMC_IMR_CMDDONE (0x1u << 17) /**< \brief (HSMC_IMR) Command Done Interrupt Mask */
#define HSMC_IMR_DTOE (0x1u << 20) /**< \brief (HSMC_IMR) Data Timeout Error Interrupt Mask */
#define HSMC_IMR_UNDEF (0x1u << 21) /**< \brief (HSMC_IMR) Undefined Area Access Interrupt Mask5 */
#define HSMC_IMR_AWB (0x1u << 22) /**< \brief (HSMC_IMR) Accessing While Busy Interrupt Mask */
#define HSMC_IMR_NFCASE (0x1u << 23) /**< \brief (HSMC_IMR) NFC Access Size Error Interrupt Mask */
#define HSMC_IMR_RB_EDGE3 (0x1u << 27) /**< \brief (HSMC_IMR) Ready/Busy Line 3 Interrupt Mask */
/* -------- HSMC_ADDR : (HSMC Offset: 0x018) HSMC NFC Address Cycle Zero Register -------- */
#define HSMC_ADDR_ADDR_CYCLE0_Pos 0
#define HSMC_ADDR_ADDR_CYCLE0_Msk (0xffu << HSMC_ADDR_ADDR_CYCLE0_Pos) /**< \brief (HSMC_ADDR) NAND Flash Array Address Cycle 0 */
#define HSMC_ADDR_ADDR_CYCLE0(value) ((HSMC_ADDR_ADDR_CYCLE0_Msk & ((value) << HSMC_ADDR_ADDR_CYCLE0_Pos)))
/* -------- HSMC_BANK : (HSMC Offset: 0x01C) HSMC Bank Address Register -------- */
#define HSMC_BANK_BANK (0x1u << 0) /**< \brief (HSMC_BANK) Bank Identifier */
/* -------- HSMC_ECC_CTRL : (HSMC Offset: 0x020) HSMC ECC Control Register -------- */
#define HSMC_ECC_CTRL_RST (0x1u << 0) /**< \brief (HSMC_ECC_CTRL) Reset ECC */
#define HSMC_ECC_CTRL_SWRST (0x1u << 1) /**< \brief (HSMC_ECC_CTRL) Software Reset */
/* -------- HSMC_ECC_MD : (HSMC Offset: 0x024) HSMC ECC Mode Register -------- */
#define HSMC_ECC_MD_ECC_PAGESIZE_Pos 0
#define HSMC_ECC_MD_ECC_PAGESIZE_Msk (0x3u << HSMC_ECC_MD_ECC_PAGESIZE_Pos) /**< \brief (HSMC_ECC_MD) ECC Page Size */
#define   HSMC_ECC_MD_ECC_PAGESIZE_PS512 (0x0u << 0) /**< \brief (HSMC_ECC_MD) Main area 512 Words */
#define   HSMC_ECC_MD_ECC_PAGESIZE_PS1024 (0x1u << 0) /**< \brief (HSMC_ECC_MD) Main area 1024 Words */
#define   HSMC_ECC_MD_ECC_PAGESIZE_PS2048 (0x2u << 0) /**< \brief (HSMC_ECC_MD) Main area 2048 Words */
#define   HSMC_ECC_MD_ECC_PAGESIZE_PS4096 (0x3u << 0) /**< \brief (HSMC_ECC_MD) Main area 4096 Words */
#define HSMC_ECC_MD_TYPCORREC_Pos 4
#define HSMC_ECC_MD_TYPCORREC_Msk (0x3u << HSMC_ECC_MD_TYPCORREC_Pos) /**< \brief (HSMC_ECC_MD) Type of Correction */
#define   HSMC_ECC_MD_TYPCORREC_CPAGE (0x0u << 4) /**< \brief (HSMC_ECC_MD) 1 bit correction for a page of 512/1024/2048/4096 Bytes  (for 8 or 16-bit NAND Flash) */
#define   HSMC_ECC_MD_TYPCORREC_C256B (0x1u << 4) /**< \brief (HSMC_ECC_MD) 1 bit correction for 256 Bytes of data for a page of 512/2048/4096 bytes (for 8-bit NAND Flash only) */
#define   HSMC_ECC_MD_TYPCORREC_C512B (0x2u << 4) /**< \brief (HSMC_ECC_MD) 1 bit correction for 512 Bytes of data for a page of 512/2048/4096 bytes (for 8-bit NAND Flash only) */
#define HSMC_ECC_MD_HAMMING (0x1u << 8) /**< \brief (HSMC_ECC_MD) Hamming Error Correcting Code Selected */
/* -------- HSMC_ECC_SR1 : (HSMC Offset: 0x028) HSMC ECC Status 1 Register -------- */
#define HSMC_ECC_SR1_RECERR0 (0x1u << 0) /**< \brief (HSMC_ECC_SR1) Recoverable Error */
#define HSMC_ECC_SR1_ECCERR0 (0x1u << 1) /**< \brief (HSMC_ECC_SR1) ECC Error */
#define HSMC_ECC_SR1_MULERR0 (0x1u << 2) /**< \brief (HSMC_ECC_SR1) Multiple Error */
#define HSMC_ECC_SR1_RECERR1 (0x1u << 4) /**< \brief (HSMC_ECC_SR1) Recoverable Error in the page between the 256th and the 511th Bytes or the 512nd and the 1023rd Bytes */
#define HSMC_ECC_SR1_ECCERR1 (0x1u << 5) /**< \brief (HSMC_ECC_SR1) ECC Error in the page between the 256th and the 511th Bytes or between the 512nd and the 1023rd Bytes */
#define HSMC_ECC_SR1_MULERR1 (0x1u << 6) /**< \brief (HSMC_ECC_SR1) Multiple Error in the page between the 256th and the 511th Bytes or between the 512nd and the 1023rd Bytes */
#define HSMC_ECC_SR1_RECERR2 (0x1u << 8) /**< \brief (HSMC_ECC_SR1) Recoverable Error in the page between the 512nd and the 767th Bytes or between the 1024th and the 1535th Bytes */
#define HSMC_ECC_SR1_ECCERR2 (0x1u << 9) /**< \brief (HSMC_ECC_SR1) ECC Error in the page between the 512nd and the 767th Bytes or between the 1024th and the 1535th Bytes */
#define HSMC_ECC_SR1_MULERR2 (0x1u << 10) /**< \brief (HSMC_ECC_SR1) Multiple Error in the page between the 512nd and the 767th Bytes or between the 1024th and the 1535th Bytes */
#define HSMC_ECC_SR1_RECERR3 (0x1u << 12) /**< \brief (HSMC_ECC_SR1) Recoverable Error in the page between the 768th and the 1023rd Bytes or between the 1536th and the 2047th Bytes */
#define HSMC_ECC_SR1_ECCERR3 (0x1u << 13) /**< \brief (HSMC_ECC_SR1) ECC Error in the page between the 768th and the 1023rd Bytes or between the 1536th and the 2047th Bytes */
#define HSMC_ECC_SR1_MULERR3 (0x1u << 14) /**< \brief (HSMC_ECC_SR1) Multiple Error in the page between the 768th and the 1023rd Bytes or between the 1536th and the 2047th Bytes */
#define HSMC_ECC_SR1_RECERR4 (0x1u << 16) /**< \brief (HSMC_ECC_SR1) Recoverable Error in the page between the 1024th and the 1279th Bytes or between the 2048th and the 2559th Bytes */
#define HSMC_ECC_SR1_ECCERR4 (0x1u << 17) /**< \brief (HSMC_ECC_SR1) ECC Error in the page between the 1024th and the 1279th Bytes or between the 2048th and the 2559th Bytes */
#define HSMC_ECC_SR1_MULERR4 (0x1u << 18) /**< \brief (HSMC_ECC_SR1) Multiple Error in the page between the 1024th and the 1279th Bytes or between the 2048th and the 2559th Bytes */
#define HSMC_ECC_SR1_RECERR5 (0x1u << 20) /**< \brief (HSMC_ECC_SR1) Recoverable Error in the page between the 1280th and the 1535th Bytes or between the 2560th and the 3071st Bytes */
#define HSMC_ECC_SR1_ECCERR5 (0x1u << 21) /**< \brief (HSMC_ECC_SR1) ECC Error in the page between the 1280th and the 1535th Bytes or between the 2560th and the 3071st Bytes */
#define HSMC_ECC_SR1_MULERR5 (0x1u << 22) /**< \brief (HSMC_ECC_SR1) Multiple Error in the page between the 1280th and the 1535th Bytes or between the 2560th and the 3071st Bytes */
#define HSMC_ECC_SR1_RECERR6 (0x1u << 24) /**< \brief (HSMC_ECC_SR1) Recoverable Error in the page between the 1536th and the 1791st Bytes or between the 3072nd and the 3583rd Bytes */
#define HSMC_ECC_SR1_ECCERR6 (0x1u << 25) /**< \brief (HSMC_ECC_SR1) ECC Error in the page between the 1536th and the 1791st Bytes or between the 3072nd and the 3583rd Bytes */
#define HSMC_ECC_SR1_MULERR6 (0x1u << 26) /**< \brief (HSMC_ECC_SR1) Multiple Error in the page between the 1536th and the 1791st Bytes or between the 3072nd and the 3583rd Bytes */
#define HSMC_ECC_SR1_RECERR7 (0x1u << 28) /**< \brief (HSMC_ECC_SR1) Recoverable Error in the page between the 1792nd and the 2047th Bytes or between the 3584th and the 4095th Bytes */
#define HSMC_ECC_SR1_ECCERR7 (0x1u << 29) /**< \brief (HSMC_ECC_SR1) ECC Error in the page between the 1792nd and the 2047th Bytes or between the 3584th and the 4095th Bytes */
#define HSMC_ECC_SR1_MULERR7 (0x1u << 30) /**< \brief (HSMC_ECC_SR1) Multiple Error in the page between the 1792nd and the 2047th Bytes or between the 3584th and the 4095th Bytes */
/* -------- HSMC_ECC_PR0 : (HSMC Offset: 0x02C) HSMC ECC Parity 0 Register -------- */
#define HSMC_ECC_PR0_BITADDR_Pos 0
#define HSMC_ECC_PR0_BITADDR_Msk (0xfu << HSMC_ECC_PR0_BITADDR_Pos) /**< \brief (HSMC_ECC_PR0) Bit Address */
#define HSMC_ECC_PR0_WORDADDR_Pos 4
#define HSMC_ECC_PR0_WORDADDR_Msk (0xfffu << HSMC_ECC_PR0_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR0) Word Address */
#define HSMC_ECC_PR0_BITADDR_W9BIT_Pos 0
#define HSMC_ECC_PR0_BITADDR_W9BIT_Msk (0x7u << HSMC_ECC_PR0_BITADDR_W9BIT_Pos) /**< \brief (HSMC_ECC_PR0) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR0_WORDADDR_W9BIT_Pos 3
#define HSMC_ECC_PR0_WORDADDR_W9BIT_Msk (0x1ffu << HSMC_ECC_PR0_WORDADDR_W9BIT_Pos) /**< \brief (HSMC_ECC_PR0) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR0_NPARITY_Pos 12
#define HSMC_ECC_PR0_NPARITY_Msk (0xfffu << HSMC_ECC_PR0_NPARITY_Pos) /**< \brief (HSMC_ECC_PR0) Parity N */
#define HSMC_ECC_PR0_BITADDR_W8BIT_Pos 0
#define HSMC_ECC_PR0_BITADDR_W8BIT_Msk (0x7u << HSMC_ECC_PR0_BITADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR0) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR0_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR0_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR0_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR0) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR0_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR0_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR0_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR0) Parity N */
/* -------- HSMC_ECC_PR1 : (HSMC Offset: 0x030) HSMC ECC parity 1 Register -------- */
#define HSMC_ECC_PR1_NPARITY_Pos 0
#define HSMC_ECC_PR1_NPARITY_Msk (0xffffu << HSMC_ECC_PR1_NPARITY_Pos) /**< \brief (HSMC_ECC_PR1) Parity N */
#define HSMC_ECC_PR1_BITADDR_Pos 0
#define HSMC_ECC_PR1_BITADDR_Msk (0x7u << HSMC_ECC_PR1_BITADDR_Pos) /**< \brief (HSMC_ECC_PR1) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR1_WORDADDR_Pos 3
#define HSMC_ECC_PR1_WORDADDR_Msk (0x1ffu << HSMC_ECC_PR1_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR1) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR1_NPARITY_W9BIT_Pos 12
#define HSMC_ECC_PR1_NPARITY_W9BIT_Msk (0xfffu << HSMC_ECC_PR1_NPARITY_W9BIT_Pos) /**< \brief (HSMC_ECC_PR1) Parity N */
#define HSMC_ECC_PR1_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR1_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR1_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR1) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR1_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR1_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR1_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR1) Parity N */
/* -------- HSMC_ECC_SR2 : (HSMC Offset: 0x034) HSMC ECC status 2 Register -------- */
#define HSMC_ECC_SR2_RECERR8 (0x1u << 0) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 2048th and the 2303rd Bytes */
#define HSMC_ECC_SR2_ECCERR8 (0x1u << 1) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 2048th and the 2303rd Bytes */
#define HSMC_ECC_SR2_MULERR8 (0x1u << 2) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 2048th and the 2303rd Bytes */
#define HSMC_ECC_SR2_RECERR9 (0x1u << 4) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 2304th and the 2559th Bytes */
#define HSMC_ECC_SR2_ECCERR9 (0x1u << 5) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 2304th and the 2559th Bytes */
#define HSMC_ECC_SR2_MULERR9 (0x1u << 6) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 2304th and the 2559th Bytes */
#define HSMC_ECC_SR2_RECERR10 (0x1u << 8) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 2560th and the 2815th Bytes */
#define HSMC_ECC_SR2_ECCERR10 (0x1u << 9) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 2560th and the 2815th Bytes */
#define HSMC_ECC_SR2_MULERR10 (0x1u << 10) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 2560th and the 2815th Bytes */
#define HSMC_ECC_SR2_RECERR11 (0x1u << 12) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 2816th and the 3071st Bytes */
#define HSMC_ECC_SR2_ECCERR11 (0x1u << 13) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 2816th and the 3071st Bytes */
#define HSMC_ECC_SR2_MULERR11 (0x1u << 14) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 2816th and the 3071st Bytes */
#define HSMC_ECC_SR2_RECERR12 (0x1u << 16) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 3072nd and the 3327th Bytes */
#define HSMC_ECC_SR2_ECCERR12 (0x1u << 17) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 3072nd and the 3327th Bytes */
#define HSMC_ECC_SR2_MULERR12 (0x1u << 18) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 3072nd and the 3327th Bytes */
#define HSMC_ECC_SR2_RECERR13 (0x1u << 20) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 3328th and the 3583rd Bytes */
#define HSMC_ECC_SR2_ECCERR13 (0x1u << 21) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 3328th and the 3583rd Bytes */
#define HSMC_ECC_SR2_MULERR13 (0x1u << 22) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 3328th and the 3583rd Bytes */
#define HSMC_ECC_SR2_RECERR14 (0x1u << 24) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 3584th and the 3839th Bytes */
#define HSMC_ECC_SR2_ECCERR14 (0x1u << 25) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 3584th and the 3839th Bytes */
#define HSMC_ECC_SR2_MULERR14 (0x1u << 26) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 3584th and the 3839th Bytes */
#define HSMC_ECC_SR2_RECERR15 (0x1u << 28) /**< \brief (HSMC_ECC_SR2) Recoverable Error in the page between the 3840th and the 4095th Bytes */
#define HSMC_ECC_SR2_ECCERR15 (0x1u << 29) /**< \brief (HSMC_ECC_SR2) ECC Error in the page between the 3840th and the 4095th Bytes */
#define HSMC_ECC_SR2_MULERR15 (0x1u << 30) /**< \brief (HSMC_ECC_SR2) Multiple Error in the page between the 3840th and the 4095th Bytes */
/* -------- HSMC_ECC_PR2 : (HSMC Offset: 0x038) HSMC ECC parity 2 Register -------- */
#define HSMC_ECC_PR2_BITADDR_Pos 0
#define HSMC_ECC_PR2_BITADDR_Msk (0x7u << HSMC_ECC_PR2_BITADDR_Pos) /**< \brief (HSMC_ECC_PR2) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR2_WORDADDR_Pos 3
#define HSMC_ECC_PR2_WORDADDR_Msk (0x1ffu << HSMC_ECC_PR2_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR2) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR2_NPARITY_Pos 12
#define HSMC_ECC_PR2_NPARITY_Msk (0xfffu << HSMC_ECC_PR2_NPARITY_Pos) /**< \brief (HSMC_ECC_PR2) Parity N */
#define HSMC_ECC_PR2_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR2_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR2_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR2) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR2_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR2_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR2_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR2) Parity N */
/* -------- HSMC_ECC_PR3 : (HSMC Offset: 0x03C) HSMC ECC parity 3 Register -------- */
#define HSMC_ECC_PR3_BITADDR_Pos 0
#define HSMC_ECC_PR3_BITADDR_Msk (0x7u << HSMC_ECC_PR3_BITADDR_Pos) /**< \brief (HSMC_ECC_PR3) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR3_WORDADDR_Pos 3
#define HSMC_ECC_PR3_WORDADDR_Msk (0x1ffu << HSMC_ECC_PR3_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR3) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR3_NPARITY_Pos 12
#define HSMC_ECC_PR3_NPARITY_Msk (0xfffu << HSMC_ECC_PR3_NPARITY_Pos) /**< \brief (HSMC_ECC_PR3) Parity N */
#define HSMC_ECC_PR3_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR3_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR3_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR3) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR3_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR3_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR3_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR3) Parity N */
/* -------- HSMC_ECC_PR4 : (HSMC Offset: 0x040) HSMC ECC parity 4 Register -------- */
#define HSMC_ECC_PR4_BITADDR_Pos 0
#define HSMC_ECC_PR4_BITADDR_Msk (0x7u << HSMC_ECC_PR4_BITADDR_Pos) /**< \brief (HSMC_ECC_PR4) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR4_WORDADDR_Pos 3
#define HSMC_ECC_PR4_WORDADDR_Msk (0x1ffu << HSMC_ECC_PR4_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR4) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR4_NPARITY_Pos 12
#define HSMC_ECC_PR4_NPARITY_Msk (0xfffu << HSMC_ECC_PR4_NPARITY_Pos) /**< \brief (HSMC_ECC_PR4) Parity N */
#define HSMC_ECC_PR4_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR4_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR4_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR4) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR4_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR4_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR4_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR4) Parity N */
/* -------- HSMC_ECC_PR5 : (HSMC Offset: 0x044) HSMC ECC parity 5 Register -------- */
#define HSMC_ECC_PR5_BITADDR_Pos 0
#define HSMC_ECC_PR5_BITADDR_Msk (0x7u << HSMC_ECC_PR5_BITADDR_Pos) /**< \brief (HSMC_ECC_PR5) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR5_WORDADDR_Pos 3
#define HSMC_ECC_PR5_WORDADDR_Msk (0x1ffu << HSMC_ECC_PR5_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR5) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR5_NPARITY_Pos 12
#define HSMC_ECC_PR5_NPARITY_Msk (0xfffu << HSMC_ECC_PR5_NPARITY_Pos) /**< \brief (HSMC_ECC_PR5) Parity N */
#define HSMC_ECC_PR5_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR5_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR5_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR5) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR5_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR5_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR5_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR5) Parity N */
/* -------- HSMC_ECC_PR6 : (HSMC Offset: 0x048) HSMC ECC parity 6 Register -------- */
#define HSMC_ECC_PR6_BITADDR_Pos 0
#define HSMC_ECC_PR6_BITADDR_Msk (0x7u << HSMC_ECC_PR6_BITADDR_Pos) /**< \brief (HSMC_ECC_PR6) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR6_WORDADDR_Pos 3
#define HSMC_ECC_PR6_WORDADDR_Msk (0x1ffu << HSMC_ECC_PR6_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR6) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR6_NPARITY_Pos 12
#define HSMC_ECC_PR6_NPARITY_Msk (0xfffu << HSMC_ECC_PR6_NPARITY_Pos) /**< \brief (HSMC_ECC_PR6) Parity N */
#define HSMC_ECC_PR6_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR6_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR6_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR6) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR6_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR6_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR6_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR6) Parity N */
/* -------- HSMC_ECC_PR7 : (HSMC Offset: 0x04C) HSMC ECC parity 7 Register -------- */
#define HSMC_ECC_PR7_BITADDR_Pos 0
#define HSMC_ECC_PR7_BITADDR_Msk (0x7u << HSMC_ECC_PR7_BITADDR_Pos) /**< \brief (HSMC_ECC_PR7) Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR7_WORDADDR_Pos 3
#define HSMC_ECC_PR7_WORDADDR_Msk (0x1ffu << HSMC_ECC_PR7_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR7) Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR7_NPARITY_Pos 12
#define HSMC_ECC_PR7_NPARITY_Msk (0xfffu << HSMC_ECC_PR7_NPARITY_Pos) /**< \brief (HSMC_ECC_PR7) Parity N */
#define HSMC_ECC_PR7_WORDADDR_W8BIT_Pos 3
#define HSMC_ECC_PR7_WORDADDR_W8BIT_Msk (0xffu << HSMC_ECC_PR7_WORDADDR_W8BIT_Pos) /**< \brief (HSMC_ECC_PR7) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR7_NPARITY_W8BIT_Pos 12
#define HSMC_ECC_PR7_NPARITY_W8BIT_Msk (0x7ffu << HSMC_ECC_PR7_NPARITY_W8BIT_Pos) /**< \brief (HSMC_ECC_PR7) Parity N */
/* -------- HSMC_ECC_PR8 : (HSMC Offset: 0x050) HSMC ECC parity 8 Register -------- */
#define HSMC_ECC_PR8_BITADDR_Pos 0
#define HSMC_ECC_PR8_BITADDR_Msk (0x7u << HSMC_ECC_PR8_BITADDR_Pos) /**< \brief (HSMC_ECC_PR8) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR8_WORDADDR_Pos 3
#define HSMC_ECC_PR8_WORDADDR_Msk (0xffu << HSMC_ECC_PR8_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR8) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR8_NPARITY_Pos 12
#define HSMC_ECC_PR8_NPARITY_Msk (0x7ffu << HSMC_ECC_PR8_NPARITY_Pos) /**< \brief (HSMC_ECC_PR8) Parity N */
/* -------- HSMC_ECC_PR9 : (HSMC Offset: 0x054) HSMC ECC parity 9 Register -------- */
#define HSMC_ECC_PR9_BITADDR_Pos 0
#define HSMC_ECC_PR9_BITADDR_Msk (0x7u << HSMC_ECC_PR9_BITADDR_Pos) /**< \brief (HSMC_ECC_PR9) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR9_WORDADDR_Pos 3
#define HSMC_ECC_PR9_WORDADDR_Msk (0xffu << HSMC_ECC_PR9_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR9) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR9_NPARITY_Pos 12
#define HSMC_ECC_PR9_NPARITY_Msk (0x7ffu << HSMC_ECC_PR9_NPARITY_Pos) /**< \brief (HSMC_ECC_PR9) Parity N */
/* -------- HSMC_ECC_PR10 : (HSMC Offset: 0x058) HSMC ECC parity 10 Register -------- */
#define HSMC_ECC_PR10_BITADDR_Pos 0
#define HSMC_ECC_PR10_BITADDR_Msk (0x7u << HSMC_ECC_PR10_BITADDR_Pos) /**< \brief (HSMC_ECC_PR10) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR10_WORDADDR_Pos 3
#define HSMC_ECC_PR10_WORDADDR_Msk (0xffu << HSMC_ECC_PR10_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR10) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR10_NPARITY_Pos 12
#define HSMC_ECC_PR10_NPARITY_Msk (0x7ffu << HSMC_ECC_PR10_NPARITY_Pos) /**< \brief (HSMC_ECC_PR10) Parity N */
/* -------- HSMC_ECC_PR11 : (HSMC Offset: 0x05C) HSMC ECC parity 11 Register -------- */
#define HSMC_ECC_PR11_BITADDR_Pos 0
#define HSMC_ECC_PR11_BITADDR_Msk (0x7u << HSMC_ECC_PR11_BITADDR_Pos) /**< \brief (HSMC_ECC_PR11) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR11_WORDADDR_Pos 3
#define HSMC_ECC_PR11_WORDADDR_Msk (0xffu << HSMC_ECC_PR11_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR11) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR11_NPARITY_Pos 12
#define HSMC_ECC_PR11_NPARITY_Msk (0x7ffu << HSMC_ECC_PR11_NPARITY_Pos) /**< \brief (HSMC_ECC_PR11) Parity N */
/* -------- HSMC_ECC_PR12 : (HSMC Offset: 0x060) HSMC ECC parity 12 Register -------- */
#define HSMC_ECC_PR12_BITADDR_Pos 0
#define HSMC_ECC_PR12_BITADDR_Msk (0x7u << HSMC_ECC_PR12_BITADDR_Pos) /**< \brief (HSMC_ECC_PR12) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR12_WORDADDR_Pos 3
#define HSMC_ECC_PR12_WORDADDR_Msk (0xffu << HSMC_ECC_PR12_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR12) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR12_NPARITY_Pos 12
#define HSMC_ECC_PR12_NPARITY_Msk (0x7ffu << HSMC_ECC_PR12_NPARITY_Pos) /**< \brief (HSMC_ECC_PR12) Parity N */
/* -------- HSMC_ECC_PR13 : (HSMC Offset: 0x064) HSMC ECC parity 13 Register -------- */
#define HSMC_ECC_PR13_BITADDR_Pos 0
#define HSMC_ECC_PR13_BITADDR_Msk (0x7u << HSMC_ECC_PR13_BITADDR_Pos) /**< \brief (HSMC_ECC_PR13) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR13_WORDADDR_Pos 3
#define HSMC_ECC_PR13_WORDADDR_Msk (0xffu << HSMC_ECC_PR13_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR13) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR13_NPARITY_Pos 12
#define HSMC_ECC_PR13_NPARITY_Msk (0x7ffu << HSMC_ECC_PR13_NPARITY_Pos) /**< \brief (HSMC_ECC_PR13) Parity N */
/* -------- HSMC_ECC_PR14 : (HSMC Offset: 0x068) HSMC ECC parity 14 Register -------- */
#define HSMC_ECC_PR14_BITADDR_Pos 0
#define HSMC_ECC_PR14_BITADDR_Msk (0x7u << HSMC_ECC_PR14_BITADDR_Pos) /**< \brief (HSMC_ECC_PR14) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR14_WORDADDR_Pos 3
#define HSMC_ECC_PR14_WORDADDR_Msk (0xffu << HSMC_ECC_PR14_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR14) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR14_NPARITY_Pos 12
#define HSMC_ECC_PR14_NPARITY_Msk (0x7ffu << HSMC_ECC_PR14_NPARITY_Pos) /**< \brief (HSMC_ECC_PR14) Parity N */
/* -------- HSMC_ECC_PR15 : (HSMC Offset: 0x06C) HSMC ECC parity 15 Register -------- */
#define HSMC_ECC_PR15_BITADDR_Pos 0
#define HSMC_ECC_PR15_BITADDR_Msk (0x7u << HSMC_ECC_PR15_BITADDR_Pos) /**< \brief (HSMC_ECC_PR15) Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR15_WORDADDR_Pos 3
#define HSMC_ECC_PR15_WORDADDR_Msk (0xffu << HSMC_ECC_PR15_WORDADDR_Pos) /**< \brief (HSMC_ECC_PR15) Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes */
#define HSMC_ECC_PR15_NPARITY_Pos 12
#define HSMC_ECC_PR15_NPARITY_Msk (0x7ffu << HSMC_ECC_PR15_NPARITY_Pos) /**< \brief (HSMC_ECC_PR15) Parity N */
/* -------- HSMC_PMECCFG : (HSMC Offset: 0x70) PMECC Configuration Register -------- */
#define HSMC_PMECCFG_BCH_ERR_Pos 0
#define HSMC_PMECCFG_BCH_ERR_Msk (0x7u << HSMC_PMECCFG_BCH_ERR_Pos) /**< \brief (HSMC_PMECCFG) Error Correcting Capability */
#define   HSMC_PMECCFG_BCH_ERR_BCH_ERR2 (0x0u << 0) /**< \brief (HSMC_PMECCFG) 2 errors */
#define   HSMC_PMECCFG_BCH_ERR_BCH_ERR4 (0x1u << 0) /**< \brief (HSMC_PMECCFG) 4 errors */
#define   HSMC_PMECCFG_BCH_ERR_BCH_ERR8 (0x2u << 0) /**< \brief (HSMC_PMECCFG) 8 errors */
#define   HSMC_PMECCFG_BCH_ERR_BCH_ERR12 (0x3u << 0) /**< \brief (HSMC_PMECCFG) 12 errors */
#define   HSMC_PMECCFG_BCH_ERR_BCH_ERR24 (0x4u << 0) /**< \brief (HSMC_PMECCFG) 24 errors */
#define HSMC_PMECCFG_SECTORSZ (0x1u << 4) /**< \brief (HSMC_PMECCFG) Sector Size */
#define HSMC_PMECCFG_PAGESIZE_Pos 8
#define HSMC_PMECCFG_PAGESIZE_Msk (0x3u << HSMC_PMECCFG_PAGESIZE_Pos) /**< \brief (HSMC_PMECCFG) Number of Sectors in the Page */
#define   HSMC_PMECCFG_PAGESIZE_PAGESIZE_1SEC (0x0u << 8) /**< \brief (HSMC_PMECCFG) 1 sector for main area (512 or 1024 Bytes) */
#define   HSMC_PMECCFG_PAGESIZE_PAGESIZE_2SEC (0x1u << 8) /**< \brief (HSMC_PMECCFG) 2 sectors for main area (1024 or 2048 Bytes) */
#define   HSMC_PMECCFG_PAGESIZE_PAGESIZE_4SEC (0x2u << 8) /**< \brief (HSMC_PMECCFG) 4 sectors for main area (2048 or 4096 Bytes) */
#define   HSMC_PMECCFG_PAGESIZE_PAGESIZE_8SEC (0x3u << 8) /**< \brief (HSMC_PMECCFG) 8 sectors for main area (4096 or 8192 Bytes) */
#define HSMC_PMECCFG_NANDWR (0x1u << 12) /**< \brief (HSMC_PMECCFG) NAND Write Access */
#define HSMC_PMECCFG_SPAREEN (0x1u << 16) /**< \brief (HSMC_PMECCFG) Spare Enable */
#define HSMC_PMECCFG_AUTO (0x1u << 20) /**< \brief (HSMC_PMECCFG) Automatic Mode Enable */
/* -------- HSMC_PMECCSAREA : (HSMC Offset: 0x74) PMECC Spare Area Size Register -------- */
#define HSMC_PMECCSAREA_SPARESIZE_Pos 0
#define HSMC_PMECCSAREA_SPARESIZE_Msk (0x1ffu << HSMC_PMECCSAREA_SPARESIZE_Pos) /**< \brief (HSMC_PMECCSAREA) Spare Area Size */
#define HSMC_PMECCSAREA_SPARESIZE(value) ((HSMC_PMECCSAREA_SPARESIZE_Msk & ((value) << HSMC_PMECCSAREA_SPARESIZE_Pos)))
/* -------- HSMC_PMECCSADDR : (HSMC Offset: 0x78) PMECC Start Address Register -------- */
#define HSMC_PMECCSADDR_STARTADDR_Pos 0
#define HSMC_PMECCSADDR_STARTADDR_Msk (0x1ffu << HSMC_PMECCSADDR_STARTADDR_Pos) /**< \brief (HSMC_PMECCSADDR) ECC Area Start Address */
#define HSMC_PMECCSADDR_STARTADDR(value) ((HSMC_PMECCSADDR_STARTADDR_Msk & ((value) << HSMC_PMECCSADDR_STARTADDR_Pos)))
/* -------- HSMC_PMECCEADDR : (HSMC Offset: 0x7C) PMECC End Address Register -------- */
#define HSMC_PMECCEADDR_ENDADDR_Pos 0
#define HSMC_PMECCEADDR_ENDADDR_Msk (0x1ffu << HSMC_PMECCEADDR_ENDADDR_Pos) /**< \brief (HSMC_PMECCEADDR) ECC Area End Address */
#define HSMC_PMECCEADDR_ENDADDR(value) ((HSMC_PMECCEADDR_ENDADDR_Msk & ((value) << HSMC_PMECCEADDR_ENDADDR_Pos)))
/* -------- HSMC_PMECCTRL : (HSMC Offset: 0x84) PMECC Control Register -------- */
#define HSMC_PMECCTRL_RST (0x1u << 0) /**< \brief (HSMC_PMECCTRL) Reset the PMECC Module */
#define HSMC_PMECCTRL_DATA (0x1u << 1) /**< \brief (HSMC_PMECCTRL) Start a Data Phase */
#define HSMC_PMECCTRL_USER (0x1u << 2) /**< \brief (HSMC_PMECCTRL) Start a User Mode Phase */
#define HSMC_PMECCTRL_ENABLE (0x1u << 4) /**< \brief (HSMC_PMECCTRL) PMECC Enable */
#define HSMC_PMECCTRL_DISABLE (0x1u << 5) /**< \brief (HSMC_PMECCTRL) PMECC Enable */
/* -------- HSMC_PMECCSR : (HSMC Offset: 0x88) PMECC Status Register -------- */
#define HSMC_PMECCSR_BUSY (0x1u << 0) /**< \brief (HSMC_PMECCSR) The kernel of the PMECC is busy */
#define HSMC_PMECCSR_ENABLE (0x1u << 4) /**< \brief (HSMC_PMECCSR) PMECC Enable bit */
/* -------- HSMC_PMECCIER : (HSMC Offset: 0x8C) PMECC Interrupt Enable register -------- */
#define HSMC_PMECCIER_ERRIE (0x1u << 0) /**< \brief (HSMC_PMECCIER) Error Interrupt Enable */
/* -------- HSMC_PMECCIDR : (HSMC Offset: 0x90) PMECC Interrupt Disable Register -------- */
#define HSMC_PMECCIDR_ERRID (0x1u << 0) /**< \brief (HSMC_PMECCIDR) Error Interrupt Disable */
/* -------- HSMC_PMECCIMR : (HSMC Offset: 0x94) PMECC Interrupt Mask Register -------- */
#define HSMC_PMECCIMR_ERRIM (0x1u << 0) /**< \brief (HSMC_PMECCIMR) Error Interrupt Mask */
/* -------- HSMC_PMECCISR : (HSMC Offset: 0x98) PMECC Interrupt Status Register -------- */
#define HSMC_PMECCISR_ERRIS_Pos 0
#define HSMC_PMECCISR_ERRIS_Msk (0xffu << HSMC_PMECCISR_ERRIS_Pos) /**< \brief (HSMC_PMECCISR) Error Interrupt Status Register */
/* -------- HSMC_PMECC[11] : (HSMC Offset: N/A) PMECC Redundancy x Register -------- */
#define HSMC_PMECC_ECC_Pos 0
#define HSMC_PMECC_ECC_Msk (0xffffffffu << HSMC_PMECC_ECC_Pos) /**< \brief (HSMC_PMECC[11]) BCH Redundancy */
/* -------- HSMC_REM[12] : (HSMC Offset: N/A) PMECC Remainder x Register -------- */
#define HSMC_REM_REM2NP1_Pos 0
#define HSMC_REM_REM2NP1_Msk (0x3fffu << HSMC_REM_REM2NP1_Pos) /**< \brief (HSMC_REM[12]) BCH Remainder 2 * N + 1 */
#define HSMC_REM_REM2NP3_Pos 16
#define HSMC_REM_REM2NP3_Msk (0x3fffu << HSMC_REM_REM2NP3_Pos) /**< \brief (HSMC_REM[12]) BCH Remainder 2 * N + 3 */
/* -------- HSMC_ELCFG : (HSMC Offset: 0x500) PMECC Error Location Configuration Register -------- */
#define HSMC_ELCFG_SECTORSZ (0x1u << 0) /**< \brief (HSMC_ELCFG) Sector Size */
#define HSMC_ELCFG_ERRNUM_Pos 16
#define HSMC_ELCFG_ERRNUM_Msk (0x1fu << HSMC_ELCFG_ERRNUM_Pos) /**< \brief (HSMC_ELCFG) Number of Errors */
#define HSMC_ELCFG_ERRNUM(value) ((HSMC_ELCFG_ERRNUM_Msk & ((value) << HSMC_ELCFG_ERRNUM_Pos)))
/* -------- HSMC_ELPRIM : (HSMC Offset: 0x504) PMECC Error Location Primitive Register -------- */
#define HSMC_ELPRIM_PRIMITIV_Pos 0
#define HSMC_ELPRIM_PRIMITIV_Msk (0xffffu << HSMC_ELPRIM_PRIMITIV_Pos) /**< \brief (HSMC_ELPRIM) Primitive Polynomial */
/* -------- HSMC_ELEN : (HSMC Offset: 0x508) PMECC Error Location Enable Register -------- */
#define HSMC_ELEN_ENINIT_Pos 0
#define HSMC_ELEN_ENINIT_Msk (0x3fffu << HSMC_ELEN_ENINIT_Pos) /**< \brief (HSMC_ELEN) Error Location Enable */
#define HSMC_ELEN_ENINIT(value) ((HSMC_ELEN_ENINIT_Msk & ((value) << HSMC_ELEN_ENINIT_Pos)))
/* -------- HSMC_ELDIS : (HSMC Offset: 0x50C) PMECC Error Location Disable Register -------- */
#define HSMC_ELDIS_DIS (0x1u << 0) /**< \brief (HSMC_ELDIS) Disable Error Location Engine */
/* -------- HSMC_ELSR : (HSMC Offset: 0x510) PMECC Error Location Status Register -------- */
#define HSMC_ELSR_BUSY (0x1u << 0) /**< \brief (HSMC_ELSR) Error Location Engine Busy */
/* -------- HSMC_ELIER : (HSMC Offset: 0x514) PMECC Error Location Interrupt Enable register -------- */
#define HSMC_ELIER_DONE (0x1u << 0) /**< \brief (HSMC_ELIER) Computation Terminated Interrupt Enable */
/* -------- HSMC_ELIDR : (HSMC Offset: 0x518) PMECC Error Location Interrupt Disable Register -------- */
#define HSMC_ELIDR_DONE (0x1u << 0) /**< \brief (HSMC_ELIDR) Computation Terminated Interrupt Disable */
/* -------- HSMC_ELIMR : (HSMC Offset: 0x51C) PMECC Error Location Interrupt Mask Register -------- */
#define HSMC_ELIMR_DONE (0x1u << 0) /**< \brief (HSMC_ELIMR) Computation Terminated Interrupt Mask */
/* -------- HSMC_ELISR : (HSMC Offset: 0x520) PMECC Error Location Interrupt Status Register -------- */
#define HSMC_ELISR_DONE (0x1u << 0) /**< \brief (HSMC_ELISR) Computation Terminated Interrupt Status */
#define HSMC_ELISR_ERR_CNT_Pos 8
#define HSMC_ELISR_ERR_CNT_Msk (0x1fu << HSMC_ELISR_ERR_CNT_Pos) /**< \brief (HSMC_ELISR) Error Counter value */
/* -------- HSMC_SIGMA0 : (HSMC Offset: 0x528) PMECC Error Location SIGMA 0 Register -------- */
#define HSMC_SIGMA0_SIGMA0_Pos 0
#define HSMC_SIGMA0_SIGMA0_Msk (0x3fffu << HSMC_SIGMA0_SIGMA0_Pos) /**< \brief (HSMC_SIGMA0) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA0_SIGMA0(value) ((HSMC_SIGMA0_SIGMA0_Msk & ((value) << HSMC_SIGMA0_SIGMA0_Pos)))
/* -------- HSMC_SIGMA1 : (HSMC Offset: 0x52C) PMECC Error Location SIGMA 1 Register -------- */
#define HSMC_SIGMA1_SIGMA1_Pos 0
#define HSMC_SIGMA1_SIGMA1_Msk (0x3fffu << HSMC_SIGMA1_SIGMA1_Pos) /**< \brief (HSMC_SIGMA1) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA1_SIGMA1(value) ((HSMC_SIGMA1_SIGMA1_Msk & ((value) << HSMC_SIGMA1_SIGMA1_Pos)))
/* -------- HSMC_SIGMA2 : (HSMC Offset: 0x530) PMECC Error Location SIGMA 2 Register -------- */
#define HSMC_SIGMA2_SIGMA2_Pos 0
#define HSMC_SIGMA2_SIGMA2_Msk (0x3fffu << HSMC_SIGMA2_SIGMA2_Pos) /**< \brief (HSMC_SIGMA2) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA2_SIGMA2(value) ((HSMC_SIGMA2_SIGMA2_Msk & ((value) << HSMC_SIGMA2_SIGMA2_Pos)))
/* -------- HSMC_SIGMA3 : (HSMC Offset: 0x534) PMECC Error Location SIGMA 3 Register -------- */
#define HSMC_SIGMA3_SIGMA3_Pos 0
#define HSMC_SIGMA3_SIGMA3_Msk (0x3fffu << HSMC_SIGMA3_SIGMA3_Pos) /**< \brief (HSMC_SIGMA3) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA3_SIGMA3(value) ((HSMC_SIGMA3_SIGMA3_Msk & ((value) << HSMC_SIGMA3_SIGMA3_Pos)))
/* -------- HSMC_SIGMA4 : (HSMC Offset: 0x538) PMECC Error Location SIGMA 4 Register -------- */
#define HSMC_SIGMA4_SIGMA4_Pos 0
#define HSMC_SIGMA4_SIGMA4_Msk (0x3fffu << HSMC_SIGMA4_SIGMA4_Pos) /**< \brief (HSMC_SIGMA4) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA4_SIGMA4(value) ((HSMC_SIGMA4_SIGMA4_Msk & ((value) << HSMC_SIGMA4_SIGMA4_Pos)))
/* -------- HSMC_SIGMA5 : (HSMC Offset: 0x53C) PMECC Error Location SIGMA 5 Register -------- */
#define HSMC_SIGMA5_SIGMA5_Pos 0
#define HSMC_SIGMA5_SIGMA5_Msk (0x3fffu << HSMC_SIGMA5_SIGMA5_Pos) /**< \brief (HSMC_SIGMA5) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA5_SIGMA5(value) ((HSMC_SIGMA5_SIGMA5_Msk & ((value) << HSMC_SIGMA5_SIGMA5_Pos)))
/* -------- HSMC_SIGMA6 : (HSMC Offset: 0x540) PMECC Error Location SIGMA 6 Register -------- */
#define HSMC_SIGMA6_SIGMA6_Pos 0
#define HSMC_SIGMA6_SIGMA6_Msk (0x3fffu << HSMC_SIGMA6_SIGMA6_Pos) /**< \brief (HSMC_SIGMA6) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA6_SIGMA6(value) ((HSMC_SIGMA6_SIGMA6_Msk & ((value) << HSMC_SIGMA6_SIGMA6_Pos)))
/* -------- HSMC_SIGMA7 : (HSMC Offset: 0x544) PMECC Error Location SIGMA 7 Register -------- */
#define HSMC_SIGMA7_SIGMA7_Pos 0
#define HSMC_SIGMA7_SIGMA7_Msk (0x3fffu << HSMC_SIGMA7_SIGMA7_Pos) /**< \brief (HSMC_SIGMA7) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA7_SIGMA7(value) ((HSMC_SIGMA7_SIGMA7_Msk & ((value) << HSMC_SIGMA7_SIGMA7_Pos)))
/* -------- HSMC_SIGMA8 : (HSMC Offset: 0x548) PMECC Error Location SIGMA 8 Register -------- */
#define HSMC_SIGMA8_SIGMA8_Pos 0
#define HSMC_SIGMA8_SIGMA8_Msk (0x3fffu << HSMC_SIGMA8_SIGMA8_Pos) /**< \brief (HSMC_SIGMA8) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA8_SIGMA8(value) ((HSMC_SIGMA8_SIGMA8_Msk & ((value) << HSMC_SIGMA8_SIGMA8_Pos)))
/* -------- HSMC_SIGMA9 : (HSMC Offset: 0x54C) PMECC Error Location SIGMA 9 Register -------- */
#define HSMC_SIGMA9_SIGMA9_Pos 0
#define HSMC_SIGMA9_SIGMA9_Msk (0x3fffu << HSMC_SIGMA9_SIGMA9_Pos) /**< \brief (HSMC_SIGMA9) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA9_SIGMA9(value) ((HSMC_SIGMA9_SIGMA9_Msk & ((value) << HSMC_SIGMA9_SIGMA9_Pos)))
/* -------- HSMC_SIGMA10 : (HSMC Offset: 0x550) PMECC Error Location SIGMA 10 Register -------- */
#define HSMC_SIGMA10_SIGMA10_Pos 0
#define HSMC_SIGMA10_SIGMA10_Msk (0x3fffu << HSMC_SIGMA10_SIGMA10_Pos) /**< \brief (HSMC_SIGMA10) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA10_SIGMA10(value) ((HSMC_SIGMA10_SIGMA10_Msk & ((value) << HSMC_SIGMA10_SIGMA10_Pos)))
/* -------- HSMC_SIGMA11 : (HSMC Offset: 0x554) PMECC Error Location SIGMA 11 Register -------- */
#define HSMC_SIGMA11_SIGMA11_Pos 0
#define HSMC_SIGMA11_SIGMA11_Msk (0x3fffu << HSMC_SIGMA11_SIGMA11_Pos) /**< \brief (HSMC_SIGMA11) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA11_SIGMA11(value) ((HSMC_SIGMA11_SIGMA11_Msk & ((value) << HSMC_SIGMA11_SIGMA11_Pos)))
/* -------- HSMC_SIGMA12 : (HSMC Offset: 0x558) PMECC Error Location SIGMA 12 Register -------- */
#define HSMC_SIGMA12_SIGMA12_Pos 0
#define HSMC_SIGMA12_SIGMA12_Msk (0x3fffu << HSMC_SIGMA12_SIGMA12_Pos) /**< \brief (HSMC_SIGMA12) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA12_SIGMA12(value) ((HSMC_SIGMA12_SIGMA12_Msk & ((value) << HSMC_SIGMA12_SIGMA12_Pos)))
/* -------- HSMC_SIGMA13 : (HSMC Offset: 0x55C) PMECC Error Location SIGMA 13 Register -------- */
#define HSMC_SIGMA13_SIGMA13_Pos 0
#define HSMC_SIGMA13_SIGMA13_Msk (0x3fffu << HSMC_SIGMA13_SIGMA13_Pos) /**< \brief (HSMC_SIGMA13) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA13_SIGMA13(value) ((HSMC_SIGMA13_SIGMA13_Msk & ((value) << HSMC_SIGMA13_SIGMA13_Pos)))
/* -------- HSMC_SIGMA14 : (HSMC Offset: 0x560) PMECC Error Location SIGMA 14 Register -------- */
#define HSMC_SIGMA14_SIGMA14_Pos 0
#define HSMC_SIGMA14_SIGMA14_Msk (0x3fffu << HSMC_SIGMA14_SIGMA14_Pos) /**< \brief (HSMC_SIGMA14) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA14_SIGMA14(value) ((HSMC_SIGMA14_SIGMA14_Msk & ((value) << HSMC_SIGMA14_SIGMA14_Pos)))
/* -------- HSMC_SIGMA15 : (HSMC Offset: 0x564) PMECC Error Location SIGMA 15 Register -------- */
#define HSMC_SIGMA15_SIGMA15_Pos 0
#define HSMC_SIGMA15_SIGMA15_Msk (0x3fffu << HSMC_SIGMA15_SIGMA15_Pos) /**< \brief (HSMC_SIGMA15) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA15_SIGMA15(value) ((HSMC_SIGMA15_SIGMA15_Msk & ((value) << HSMC_SIGMA15_SIGMA15_Pos)))
/* -------- HSMC_SIGMA16 : (HSMC Offset: 0x568) PMECC Error Location SIGMA 16 Register -------- */
#define HSMC_SIGMA16_SIGMA16_Pos 0
#define HSMC_SIGMA16_SIGMA16_Msk (0x3fffu << HSMC_SIGMA16_SIGMA16_Pos) /**< \brief (HSMC_SIGMA16) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA16_SIGMA16(value) ((HSMC_SIGMA16_SIGMA16_Msk & ((value) << HSMC_SIGMA16_SIGMA16_Pos)))
/* -------- HSMC_SIGMA17 : (HSMC Offset: 0x56C) PMECC Error Location SIGMA 17 Register -------- */
#define HSMC_SIGMA17_SIGMA17_Pos 0
#define HSMC_SIGMA17_SIGMA17_Msk (0x3fffu << HSMC_SIGMA17_SIGMA17_Pos) /**< \brief (HSMC_SIGMA17) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA17_SIGMA17(value) ((HSMC_SIGMA17_SIGMA17_Msk & ((value) << HSMC_SIGMA17_SIGMA17_Pos)))
/* -------- HSMC_SIGMA18 : (HSMC Offset: 0x570) PMECC Error Location SIGMA 18 Register -------- */
#define HSMC_SIGMA18_SIGMA18_Pos 0
#define HSMC_SIGMA18_SIGMA18_Msk (0x3fffu << HSMC_SIGMA18_SIGMA18_Pos) /**< \brief (HSMC_SIGMA18) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA18_SIGMA18(value) ((HSMC_SIGMA18_SIGMA18_Msk & ((value) << HSMC_SIGMA18_SIGMA18_Pos)))
/* -------- HSMC_SIGMA19 : (HSMC Offset: 0x574) PMECC Error Location SIGMA 19 Register -------- */
#define HSMC_SIGMA19_SIGMA19_Pos 0
#define HSMC_SIGMA19_SIGMA19_Msk (0x3fffu << HSMC_SIGMA19_SIGMA19_Pos) /**< \brief (HSMC_SIGMA19) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA19_SIGMA19(value) ((HSMC_SIGMA19_SIGMA19_Msk & ((value) << HSMC_SIGMA19_SIGMA19_Pos)))
/* -------- HSMC_SIGMA20 : (HSMC Offset: 0x578) PMECC Error Location SIGMA 20 Register -------- */
#define HSMC_SIGMA20_SIGMA20_Pos 0
#define HSMC_SIGMA20_SIGMA20_Msk (0x3fffu << HSMC_SIGMA20_SIGMA20_Pos) /**< \brief (HSMC_SIGMA20) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA20_SIGMA20(value) ((HSMC_SIGMA20_SIGMA20_Msk & ((value) << HSMC_SIGMA20_SIGMA20_Pos)))
/* -------- HSMC_SIGMA21 : (HSMC Offset: 0x57C) PMECC Error Location SIGMA 21 Register -------- */
#define HSMC_SIGMA21_SIGMA21_Pos 0
#define HSMC_SIGMA21_SIGMA21_Msk (0x3fffu << HSMC_SIGMA21_SIGMA21_Pos) /**< \brief (HSMC_SIGMA21) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA21_SIGMA21(value) ((HSMC_SIGMA21_SIGMA21_Msk & ((value) << HSMC_SIGMA21_SIGMA21_Pos)))
/* -------- HSMC_SIGMA22 : (HSMC Offset: 0x580) PMECC Error Location SIGMA 22 Register -------- */
#define HSMC_SIGMA22_SIGMA22_Pos 0
#define HSMC_SIGMA22_SIGMA22_Msk (0x3fffu << HSMC_SIGMA22_SIGMA22_Pos) /**< \brief (HSMC_SIGMA22) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA22_SIGMA22(value) ((HSMC_SIGMA22_SIGMA22_Msk & ((value) << HSMC_SIGMA22_SIGMA22_Pos)))
/* -------- HSMC_SIGMA23 : (HSMC Offset: 0x584) PMECC Error Location SIGMA 23 Register -------- */
#define HSMC_SIGMA23_SIGMA23_Pos 0
#define HSMC_SIGMA23_SIGMA23_Msk (0x3fffu << HSMC_SIGMA23_SIGMA23_Pos) /**< \brief (HSMC_SIGMA23) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA23_SIGMA23(value) ((HSMC_SIGMA23_SIGMA23_Msk & ((value) << HSMC_SIGMA23_SIGMA23_Pos)))
/* -------- HSMC_SIGMA24 : (HSMC Offset: 0x588) PMECC Error Location SIGMA 24 Register -------- */
#define HSMC_SIGMA24_SIGMA24_Pos 0
#define HSMC_SIGMA24_SIGMA24_Msk (0x3fffu << HSMC_SIGMA24_SIGMA24_Pos) /**< \brief (HSMC_SIGMA24) Coefficient of degree x in the SIGMA polynomial. */
#define HSMC_SIGMA24_SIGMA24(value) ((HSMC_SIGMA24_SIGMA24_Msk & ((value) << HSMC_SIGMA24_SIGMA24_Pos)))
/* -------- HSMC_ERRLOC[24] : (HSMC Offset: 0x58C) PMECC Error Location 0 Register -------- */
#define HSMC_ERRLOC_ERRLOCN_Pos 0
#define HSMC_ERRLOC_ERRLOCN_Msk (0x3fffu << HSMC_ERRLOC_ERRLOCN_Pos) /**< \brief (HSMC_ERRLOC[24]) Error Position within the Set {sector area, spare area} */
/* -------- HSMC_SETUP : (HSMC Offset: N/A) HSMC Setup Register -------- */
#define HSMC_SETUP_NWE_SETUP_Pos 0
#define HSMC_SETUP_NWE_SETUP_Msk (0x3fu << HSMC_SETUP_NWE_SETUP_Pos) /**< \brief (HSMC_SETUP) NWE Setup Length */
#define HSMC_SETUP_NWE_SETUP(value) ((HSMC_SETUP_NWE_SETUP_Msk & ((value) << HSMC_SETUP_NWE_SETUP_Pos)))
#define HSMC_SETUP_NCS_WR_SETUP_Pos 8
#define HSMC_SETUP_NCS_WR_SETUP_Msk (0x3fu << HSMC_SETUP_NCS_WR_SETUP_Pos) /**< \brief (HSMC_SETUP) NCS Setup Length in Write Access */
#define HSMC_SETUP_NCS_WR_SETUP(value) ((HSMC_SETUP_NCS_WR_SETUP_Msk & ((value) << HSMC_SETUP_NCS_WR_SETUP_Pos)))
#define HSMC_SETUP_NRD_SETUP_Pos 16
#define HSMC_SETUP_NRD_SETUP_Msk (0x3fu << HSMC_SETUP_NRD_SETUP_Pos) /**< \brief (HSMC_SETUP) NRD Setup Length */
#define HSMC_SETUP_NRD_SETUP(value) ((HSMC_SETUP_NRD_SETUP_Msk & ((value) << HSMC_SETUP_NRD_SETUP_Pos)))
#define HSMC_SETUP_NCS_RD_SETUP_Pos 24
#define HSMC_SETUP_NCS_RD_SETUP_Msk (0x3fu << HSMC_SETUP_NCS_RD_SETUP_Pos) /**< \brief (HSMC_SETUP) NCS Setup Length in Read Access */
#define HSMC_SETUP_NCS_RD_SETUP(value) ((HSMC_SETUP_NCS_RD_SETUP_Msk & ((value) << HSMC_SETUP_NCS_RD_SETUP_Pos)))
/* -------- HSMC_PULSE : (HSMC Offset: N/A) HSMC Pulse Register -------- */
#define HSMC_PULSE_NWE_PULSE_Pos 0
#define HSMC_PULSE_NWE_PULSE_Msk (0x3fu << HSMC_PULSE_NWE_PULSE_Pos) /**< \brief (HSMC_PULSE) NWE Pulse Length */
#define HSMC_PULSE_NWE_PULSE(value) ((HSMC_PULSE_NWE_PULSE_Msk & ((value) << HSMC_PULSE_NWE_PULSE_Pos)))
#define HSMC_PULSE_NCS_WR_PULSE_Pos 8
#define HSMC_PULSE_NCS_WR_PULSE_Msk (0x3fu << HSMC_PULSE_NCS_WR_PULSE_Pos) /**< \brief (HSMC_PULSE) NCS Pulse Length in WRITE Access */
#define HSMC_PULSE_NCS_WR_PULSE(value) ((HSMC_PULSE_NCS_WR_PULSE_Msk & ((value) << HSMC_PULSE_NCS_WR_PULSE_Pos)))
#define HSMC_PULSE_NRD_PULSE_Pos 16
#define HSMC_PULSE_NRD_PULSE_Msk (0x3fu << HSMC_PULSE_NRD_PULSE_Pos) /**< \brief (HSMC_PULSE) NRD Pulse Length */
#define HSMC_PULSE_NRD_PULSE(value) ((HSMC_PULSE_NRD_PULSE_Msk & ((value) << HSMC_PULSE_NRD_PULSE_Pos)))
#define HSMC_PULSE_NCS_RD_PULSE_Pos 24
#define HSMC_PULSE_NCS_RD_PULSE_Msk (0x3fu << HSMC_PULSE_NCS_RD_PULSE_Pos) /**< \brief (HSMC_PULSE) NCS Pulse Length in READ Access */
#define HSMC_PULSE_NCS_RD_PULSE(value) ((HSMC_PULSE_NCS_RD_PULSE_Msk & ((value) << HSMC_PULSE_NCS_RD_PULSE_Pos)))
/* -------- HSMC_CYCLE : (HSMC Offset: N/A) HSMC Cycle Register -------- */
#define HSMC_CYCLE_NWE_CYCLE_Pos 0
#define HSMC_CYCLE_NWE_CYCLE_Msk (0x1ffu << HSMC_CYCLE_NWE_CYCLE_Pos) /**< \brief (HSMC_CYCLE) Total Write Cycle Length */
#define HSMC_CYCLE_NWE_CYCLE(value) ((HSMC_CYCLE_NWE_CYCLE_Msk & ((value) << HSMC_CYCLE_NWE_CYCLE_Pos)))
#define HSMC_CYCLE_NRD_CYCLE_Pos 16
#define HSMC_CYCLE_NRD_CYCLE_Msk (0x1ffu << HSMC_CYCLE_NRD_CYCLE_Pos) /**< \brief (HSMC_CYCLE) Total Read Cycle Length */
#define HSMC_CYCLE_NRD_CYCLE(value) ((HSMC_CYCLE_NRD_CYCLE_Msk & ((value) << HSMC_CYCLE_NRD_CYCLE_Pos)))
/* -------- HSMC_TIMINGS : (HSMC Offset: N/A) HSMC Timings Register -------- */
#define HSMC_TIMINGS_TCLR_Pos 0
#define HSMC_TIMINGS_TCLR_Msk (0xfu << HSMC_TIMINGS_TCLR_Pos) /**< \brief (HSMC_TIMINGS) CLE to REN Low Delay */
#define HSMC_TIMINGS_TCLR(value) ((HSMC_TIMINGS_TCLR_Msk & ((value) << HSMC_TIMINGS_TCLR_Pos)))
#define HSMC_TIMINGS_TADL_Pos 4
#define HSMC_TIMINGS_TADL_Msk (0xfu << HSMC_TIMINGS_TADL_Pos) /**< \brief (HSMC_TIMINGS) ALE to Data Start */
#define HSMC_TIMINGS_TADL(value) ((HSMC_TIMINGS_TADL_Msk & ((value) << HSMC_TIMINGS_TADL_Pos)))
#define HSMC_TIMINGS_TAR_Pos 8
#define HSMC_TIMINGS_TAR_Msk (0xfu << HSMC_TIMINGS_TAR_Pos) /**< \brief (HSMC_TIMINGS) ALE to REN Low Delay */
#define HSMC_TIMINGS_TAR(value) ((HSMC_TIMINGS_TAR_Msk & ((value) << HSMC_TIMINGS_TAR_Pos)))
#define HSMC_TIMINGS_OCMS (0x1u << 12) /**< \brief (HSMC_TIMINGS) Off Chip Memory Scrambling Enable */
#define HSMC_TIMINGS_TRR_Pos 16
#define HSMC_TIMINGS_TRR_Msk (0xfu << HSMC_TIMINGS_TRR_Pos) /**< \brief (HSMC_TIMINGS) Ready to REN Low Delay */
#define HSMC_TIMINGS_TRR(value) ((HSMC_TIMINGS_TRR_Msk & ((value) << HSMC_TIMINGS_TRR_Pos)))
#define HSMC_TIMINGS_TWB_Pos 24
#define HSMC_TIMINGS_TWB_Msk (0xfu << HSMC_TIMINGS_TWB_Pos) /**< \brief (HSMC_TIMINGS) WEN High to REN to Busy */
#define HSMC_TIMINGS_TWB(value) ((HSMC_TIMINGS_TWB_Msk & ((value) << HSMC_TIMINGS_TWB_Pos)))
#define HSMC_TIMINGS_RBNSEL_Pos 28
#define HSMC_TIMINGS_RBNSEL_Msk (0x7u << HSMC_TIMINGS_RBNSEL_Pos) /**< \brief (HSMC_TIMINGS) Ready/Busy Line Selection */
#define HSMC_TIMINGS_RBNSEL(value) ((HSMC_TIMINGS_RBNSEL_Msk & ((value) << HSMC_TIMINGS_RBNSEL_Pos)))
#define HSMC_TIMINGS_NFSEL (0x1u << 31) /**< \brief (HSMC_TIMINGS) NAND Flash Selection */
/* -------- HSMC_MODE : (HSMC Offset: N/A) HSMC Mode Register -------- */
#define HSMC_MODE_READ_MODE (0x1u << 0) /**< \brief (HSMC_MODE)  */
#define   HSMC_MODE_READ_MODE_NCS_CTRL (0x0u << 0) /**< \brief (HSMC_MODE) The Read operation is controlled by the NCS signal. */
#define   HSMC_MODE_READ_MODE_NRD_CTRL (0x1u << 0) /**< \brief (HSMC_MODE) The Read operation is controlled by the NRD signal. */
#define HSMC_MODE_WRITE_MODE (0x1u << 1) /**< \brief (HSMC_MODE)  */
#define   HSMC_MODE_WRITE_MODE_NCS_CTRL (0x0u << 1) /**< \brief (HSMC_MODE) The Write operation is controller by the NCS signal. */
#define   HSMC_MODE_WRITE_MODE_NWE_CTRL (0x1u << 1) /**< \brief (HSMC_MODE) The Write operation is controlled by the NWE signal. */
#define HSMC_MODE_EXNW_MODE_Pos 4
#define HSMC_MODE_EXNW_MODE_Msk (0x3u << HSMC_MODE_EXNW_MODE_Pos) /**< \brief (HSMC_MODE) NWAIT Mode */
#define   HSMC_MODE_EXNW_MODE_DISABLED (0x0u << 4) /**< \brief (HSMC_MODE) Disabled */
#define   HSMC_MODE_EXNW_MODE_FROZEN (0x2u << 4) /**< \brief (HSMC_MODE) Frozen Mode */
#define   HSMC_MODE_EXNW_MODE_READY (0x3u << 4) /**< \brief (HSMC_MODE) Ready Mode */
#define HSMC_MODE_BAT (0x1u << 8) /**< \brief (HSMC_MODE) Byte Access Type */
#define HSMC_MODE_DBW (0x1u << 12) /**< \brief (HSMC_MODE) Data Bus Width */
#define   HSMC_MODE_DBW_BIT_8 (0x0u << 12) /**< \brief (HSMC_MODE) 8-bit bus */
#define   HSMC_MODE_DBW_BIT_16 (0x1u << 12) /**< \brief (HSMC_MODE) 16-bit bus */
#define HSMC_MODE_TDF_CYCLES_Pos 16
#define HSMC_MODE_TDF_CYCLES_Msk (0xfu << HSMC_MODE_TDF_CYCLES_Pos) /**< \brief (HSMC_MODE) Data Float Time */
#define HSMC_MODE_TDF_CYCLES(value) ((HSMC_MODE_TDF_CYCLES_Msk & ((value) << HSMC_MODE_TDF_CYCLES_Pos)))
#define HSMC_MODE_TDF_MODE (0x1u << 20) /**< \brief (HSMC_MODE) TDF Optimization */
/* -------- HSMC_OCMS : (HSMC Offset: 0x6A0) HSMC OCMS Register -------- */
#define HSMC_OCMS_SMSE (0x1u << 0) /**< \brief (HSMC_OCMS) Static Memory Controller Scrambling Enable */
#define HSMC_OCMS_SRSE (0x1u << 1) /**< \brief (HSMC_OCMS) SRAM Scrambling Enable */
/* -------- HSMC_KEY1 : (HSMC Offset: 0x6A4) HSMC OCMS KEY1 Register -------- */
#define HSMC_KEY1_KEY1_Pos 0
#define HSMC_KEY1_KEY1_Msk (0xffffffffu << HSMC_KEY1_KEY1_Pos) /**< \brief (HSMC_KEY1) Off Chip Memory Scrambling (OCMS) Key Part 1 */
#define HSMC_KEY1_KEY1(value) ((HSMC_KEY1_KEY1_Msk & ((value) << HSMC_KEY1_KEY1_Pos)))
/* -------- HSMC_KEY2 : (HSMC Offset: 0x6A8) HSMC OCMS KEY2 Register -------- */
#define HSMC_KEY2_KEY2_Pos 0
#define HSMC_KEY2_KEY2_Msk (0xffffffffu << HSMC_KEY2_KEY2_Pos) /**< \brief (HSMC_KEY2) Off Chip Memory Scrambling (OCMS) Key Part 2 */
#define HSMC_KEY2_KEY2(value) ((HSMC_KEY2_KEY2_Msk & ((value) << HSMC_KEY2_KEY2_Pos)))
/* -------- HSMC_WPCR : (HSMC Offset: 0x6E4) HSMC Write Protection Control Register -------- */
#define HSMC_WPCR_WP_EN (0x1u << 0) /**< \brief (HSMC_WPCR) Write Protection Enable */
#define HSMC_WPCR_WP_KEY_Pos 8
#define HSMC_WPCR_WP_KEY_Msk (0xffffffu << HSMC_WPCR_WP_KEY_Pos) /**< \brief (HSMC_WPCR) Write Protection KEY password */
#define HSMC_WPCR_WP_KEY(value) ((HSMC_WPCR_WP_KEY_Msk & ((value) << HSMC_WPCR_WP_KEY_Pos)))
/* -------- HSMC_WPSR : (HSMC Offset: 0x6E8) HSMC Write Protection Status Register -------- */
#define HSMC_WPSR_WP_VS_Pos 0
#define HSMC_WPSR_WP_VS_Msk (0xfu << HSMC_WPSR_WP_VS_Pos) /**< \brief (HSMC_WPSR) Write Protection Violation Status */
#define HSMC_WPSR_WP_VSRC_Pos 8
#define HSMC_WPSR_WP_VSRC_Msk (0xffffu << HSMC_WPSR_WP_VSRC_Pos) /**< \brief (HSMC_WPSR) Write Protection Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR High Speed MultiMedia Card Interface */
/* ============================================================================= */
/** \addtogroup SAMA5D4_HSMCI High Speed MultiMedia Card Interface */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Hsmci hardware registers */
typedef struct {
  __O  uint32_t HSMCI_CR;        /**< \brief (Hsmci Offset: 0x00) Control Register */
  __IO uint32_t HSMCI_MR;        /**< \brief (Hsmci Offset: 0x04) Mode Register */
  __IO uint32_t HSMCI_DTOR;      /**< \brief (Hsmci Offset: 0x08) Data Timeout Register */
  __IO uint32_t HSMCI_SDCR;      /**< \brief (Hsmci Offset: 0x0C) SD/SDIO Card Register */
  __IO uint32_t HSMCI_ARGR;      /**< \brief (Hsmci Offset: 0x10) Argument Register */
  __O  uint32_t HSMCI_CMDR;      /**< \brief (Hsmci Offset: 0x14) Command Register */
  __IO uint32_t HSMCI_BLKR;      /**< \brief (Hsmci Offset: 0x18) Block Register */
  __IO uint32_t HSMCI_CSTOR;     /**< \brief (Hsmci Offset: 0x1C) Completion Signal Timeout Register */
  __I  uint32_t HSMCI_RSPR[4];   /**< \brief (Hsmci Offset: 0x20) Response Register */
  __I  uint32_t HSMCI_RDR;       /**< \brief (Hsmci Offset: 0x30) Receive Data Register */
  __O  uint32_t HSMCI_TDR;       /**< \brief (Hsmci Offset: 0x34) Transmit Data Register */
  __I  uint32_t Reserved1[2];
  __I  uint32_t HSMCI_SR;        /**< \brief (Hsmci Offset: 0x40) Status Register */
  __O  uint32_t HSMCI_IER;       /**< \brief (Hsmci Offset: 0x44) Interrupt Enable Register */
  __O  uint32_t HSMCI_IDR;       /**< \brief (Hsmci Offset: 0x48) Interrupt Disable Register */
  __I  uint32_t HSMCI_IMR;       /**< \brief (Hsmci Offset: 0x4C) Interrupt Mask Register */
  __IO uint32_t HSMCI_DMA;       /**< \brief (Hsmci Offset: 0x50) DMA Configuration Register */
  __IO uint32_t HSMCI_CFG;       /**< \brief (Hsmci Offset: 0x54) Configuration Register */
  __I  uint32_t Reserved2[35];
  __IO uint32_t HSMCI_WPMR;      /**< \brief (Hsmci Offset: 0xE4) Write Protection Mode Register */
  __I  uint32_t HSMCI_WPSR;      /**< \brief (Hsmci Offset: 0xE8) Write Protection Status Register */
  __I  uint32_t Reserved3[69];
  __IO uint32_t HSMCI_FIFO[256]; /**< \brief (Hsmci Offset: 0x200) FIFO Memory Aperture0 */
} Hsmci;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- HSMCI_CR : (HSMCI Offset: 0x00) Control Register -------- */
#define HSMCI_CR_MCIEN (0x1u << 0) /**< \brief (HSMCI_CR) Multi-Media Interface Enable */
#define HSMCI_CR_MCIDIS (0x1u << 1) /**< \brief (HSMCI_CR) Multi-Media Interface Disable */
#define HSMCI_CR_PWSEN (0x1u << 2) /**< \brief (HSMCI_CR) Power Save Mode Enable */
#define HSMCI_CR_PWSDIS (0x1u << 3) /**< \brief (HSMCI_CR) Power Save Mode Disable */
#define HSMCI_CR_SWRST (0x1u << 7) /**< \brief (HSMCI_CR) Software Reset */
/* -------- HSMCI_MR : (HSMCI Offset: 0x04) Mode Register -------- */
#define HSMCI_MR_CLKDIV_Pos 0
#define HSMCI_MR_CLKDIV_Msk (0xffu << HSMCI_MR_CLKDIV_Pos) /**< \brief (HSMCI_MR) Clock Divider */
#define HSMCI_MR_CLKDIV(value) ((HSMCI_MR_CLKDIV_Msk & ((value) << HSMCI_MR_CLKDIV_Pos)))
#define HSMCI_MR_PWSDIV_Pos 8
#define HSMCI_MR_PWSDIV_Msk (0x7u << HSMCI_MR_PWSDIV_Pos) /**< \brief (HSMCI_MR) Power Saving Divider */
#define HSMCI_MR_PWSDIV(value) ((HSMCI_MR_PWSDIV_Msk & ((value) << HSMCI_MR_PWSDIV_Pos)))
#define HSMCI_MR_RDPROOF (0x1u << 11) /**< \brief (HSMCI_MR) Read Proof Enable */
#define HSMCI_MR_WRPROOF (0x1u << 12) /**< \brief (HSMCI_MR) Write Proof Enable */
#define HSMCI_MR_FBYTE (0x1u << 13) /**< \brief (HSMCI_MR) Force Byte Transfer */
#define HSMCI_MR_PADV (0x1u << 14) /**< \brief (HSMCI_MR) Padding Value */
#define HSMCI_MR_CLKODD (0x1u << 16) /**< \brief (HSMCI_MR) Clock divider is odd */
/* -------- HSMCI_DTOR : (HSMCI Offset: 0x08) Data Timeout Register -------- */
#define HSMCI_DTOR_DTOCYC_Pos 0
#define HSMCI_DTOR_DTOCYC_Msk (0xfu << HSMCI_DTOR_DTOCYC_Pos) /**< \brief (HSMCI_DTOR) Data Timeout Cycle Number */
#define HSMCI_DTOR_DTOCYC(value) ((HSMCI_DTOR_DTOCYC_Msk & ((value) << HSMCI_DTOR_DTOCYC_Pos)))
#define HSMCI_DTOR_DTOMUL_Pos 4
#define HSMCI_DTOR_DTOMUL_Msk (0x7u << HSMCI_DTOR_DTOMUL_Pos) /**< \brief (HSMCI_DTOR) Data Timeout Multiplier */
#define   HSMCI_DTOR_DTOMUL_1 (0x0u << 4) /**< \brief (HSMCI_DTOR) DTOCYC */
#define   HSMCI_DTOR_DTOMUL_16 (0x1u << 4) /**< \brief (HSMCI_DTOR) DTOCYC x 16 */
#define   HSMCI_DTOR_DTOMUL_128 (0x2u << 4) /**< \brief (HSMCI_DTOR) DTOCYC x 128 */
#define   HSMCI_DTOR_DTOMUL_256 (0x3u << 4) /**< \brief (HSMCI_DTOR) DTOCYC x 256 */
#define   HSMCI_DTOR_DTOMUL_1024 (0x4u << 4) /**< \brief (HSMCI_DTOR) DTOCYC x 1024 */
#define   HSMCI_DTOR_DTOMUL_4096 (0x5u << 4) /**< \brief (HSMCI_DTOR) DTOCYC x 4096 */
#define   HSMCI_DTOR_DTOMUL_65536 (0x6u << 4) /**< \brief (HSMCI_DTOR) DTOCYC x 65536 */
#define   HSMCI_DTOR_DTOMUL_1048576 (0x7u << 4) /**< \brief (HSMCI_DTOR) DTOCYC x 1048576 */
/* -------- HSMCI_SDCR : (HSMCI Offset: 0x0C) SD/SDIO Card Register -------- */
#define HSMCI_SDCR_SDCSEL_Pos 0
#define HSMCI_SDCR_SDCSEL_Msk (0x3u << HSMCI_SDCR_SDCSEL_Pos) /**< \brief (HSMCI_SDCR) SDCard/SDIO Slot */
#define   HSMCI_SDCR_SDCSEL_SLOTA (0x0u << 0) /**< \brief (HSMCI_SDCR) Slot A is selected. */
#define   HSMCI_SDCR_SDCSEL_SLOTB (0x1u << 0) /**< \brief (HSMCI_SDCR) Slot B is selected. */
#define HSMCI_SDCR_SDCBUS_Pos 6
#define HSMCI_SDCR_SDCBUS_Msk (0x3u << HSMCI_SDCR_SDCBUS_Pos) /**< \brief (HSMCI_SDCR) SDCard/SDIO Bus Width */
#define   HSMCI_SDCR_SDCBUS_1 (0x0u << 6) /**< \brief (HSMCI_SDCR) 1 bit */
#define   HSMCI_SDCR_SDCBUS_4 (0x2u << 6) /**< \brief (HSMCI_SDCR) 4 bit */
#define   HSMCI_SDCR_SDCBUS_8 (0x3u << 6) /**< \brief (HSMCI_SDCR) 8 bit */
/* -------- HSMCI_ARGR : (HSMCI Offset: 0x10) Argument Register -------- */
#define HSMCI_ARGR_ARG_Pos 0
#define HSMCI_ARGR_ARG_Msk (0xffffffffu << HSMCI_ARGR_ARG_Pos) /**< \brief (HSMCI_ARGR) Command Argument */
#define HSMCI_ARGR_ARG(value) ((HSMCI_ARGR_ARG_Msk & ((value) << HSMCI_ARGR_ARG_Pos)))
/* -------- HSMCI_CMDR : (HSMCI Offset: 0x14) Command Register -------- */
#define HSMCI_CMDR_CMDNB_Pos 0
#define HSMCI_CMDR_CMDNB_Msk (0x3fu << HSMCI_CMDR_CMDNB_Pos) /**< \brief (HSMCI_CMDR) Command Number */
#define HSMCI_CMDR_CMDNB(value) ((HSMCI_CMDR_CMDNB_Msk & ((value) << HSMCI_CMDR_CMDNB_Pos)))
#define HSMCI_CMDR_RSPTYP_Pos 6
#define HSMCI_CMDR_RSPTYP_Msk (0x3u << HSMCI_CMDR_RSPTYP_Pos) /**< \brief (HSMCI_CMDR) Response Type */
#define   HSMCI_CMDR_RSPTYP_NORESP (0x0u << 6) /**< \brief (HSMCI_CMDR) No response. */
#define   HSMCI_CMDR_RSPTYP_48_BIT (0x1u << 6) /**< \brief (HSMCI_CMDR) 48-bit response. */
#define   HSMCI_CMDR_RSPTYP_136_BIT (0x2u << 6) /**< \brief (HSMCI_CMDR) 136-bit response. */
#define   HSMCI_CMDR_RSPTYP_R1B (0x3u << 6) /**< \brief (HSMCI_CMDR) R1b response type */
#define HSMCI_CMDR_SPCMD_Pos 8
#define HSMCI_CMDR_SPCMD_Msk (0x7u << HSMCI_CMDR_SPCMD_Pos) /**< \brief (HSMCI_CMDR) Special Command */
#define   HSMCI_CMDR_SPCMD_STD (0x0u << 8) /**< \brief (HSMCI_CMDR) Not a special CMD. */
#define   HSMCI_CMDR_SPCMD_INIT (0x1u << 8) /**< \brief (HSMCI_CMDR) Initialization CMD: 74 clock cycles for initialization sequence. */
#define   HSMCI_CMDR_SPCMD_SYNC (0x2u << 8) /**< \brief (HSMCI_CMDR) Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command. */
#define   HSMCI_CMDR_SPCMD_CE_ATA (0x3u << 8) /**< \brief (HSMCI_CMDR) CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line. */
#define   HSMCI_CMDR_SPCMD_IT_CMD (0x4u << 8) /**< \brief (HSMCI_CMDR) Interrupt command: Corresponds to the Interrupt Mode (CMD40). */
#define   HSMCI_CMDR_SPCMD_IT_RESP (0x5u << 8) /**< \brief (HSMCI_CMDR) Interrupt response: Corresponds to the Interrupt Mode (CMD40). */
#define   HSMCI_CMDR_SPCMD_BOR (0x6u << 8) /**< \brief (HSMCI_CMDR) Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly. */
#define   HSMCI_CMDR_SPCMD_EBO (0x7u << 8) /**< \brief (HSMCI_CMDR) End Boot Operation. This command allows the host processor to terminate the boot operation mode. */
#define HSMCI_CMDR_OPDCMD (0x1u << 11) /**< \brief (HSMCI_CMDR) Open Drain Command */
#define   HSMCI_CMDR_OPDCMD_PUSHPULL (0x0u << 11) /**< \brief (HSMCI_CMDR) Push pull command. */
#define   HSMCI_CMDR_OPDCMD_OPENDRAIN (0x1u << 11) /**< \brief (HSMCI_CMDR) Open drain command. */
#define HSMCI_CMDR_MAXLAT (0x1u << 12) /**< \brief (HSMCI_CMDR) Max Latency for Command to Response */
#define   HSMCI_CMDR_MAXLAT_5 (0x0u << 12) /**< \brief (HSMCI_CMDR) 5-cycle max latency. */
#define   HSMCI_CMDR_MAXLAT_64 (0x1u << 12) /**< \brief (HSMCI_CMDR) 64-cycle max latency. */
#define HSMCI_CMDR_TRCMD_Pos 16
#define HSMCI_CMDR_TRCMD_Msk (0x3u << HSMCI_CMDR_TRCMD_Pos) /**< \brief (HSMCI_CMDR) Transfer Command */
#define   HSMCI_CMDR_TRCMD_NO_DATA (0x0u << 16) /**< \brief (HSMCI_CMDR) No data transfer */
#define   HSMCI_CMDR_TRCMD_START_DATA (0x1u << 16) /**< \brief (HSMCI_CMDR) Start data transfer */
#define   HSMCI_CMDR_TRCMD_STOP_DATA (0x2u << 16) /**< \brief (HSMCI_CMDR) Stop data transfer */
#define HSMCI_CMDR_TRDIR (0x1u << 18) /**< \brief (HSMCI_CMDR) Transfer Direction */
#define   HSMCI_CMDR_TRDIR_WRITE (0x0u << 18) /**< \brief (HSMCI_CMDR) Write. */
#define   HSMCI_CMDR_TRDIR_READ (0x1u << 18) /**< \brief (HSMCI_CMDR) Read. */
#define HSMCI_CMDR_TRTYP_Pos 19
#define HSMCI_CMDR_TRTYP_Msk (0x7u << HSMCI_CMDR_TRTYP_Pos) /**< \brief (HSMCI_CMDR) Transfer Type */
#define   HSMCI_CMDR_TRTYP_SINGLE (0x0u << 19) /**< \brief (HSMCI_CMDR) MMC/SD Card Single Block */
#define   HSMCI_CMDR_TRTYP_MULTIPLE (0x1u << 19) /**< \brief (HSMCI_CMDR) MMC/SD Card Multiple Block */
#define   HSMCI_CMDR_TRTYP_STREAM (0x2u << 19) /**< \brief (HSMCI_CMDR) MMC Stream */
#define   HSMCI_CMDR_TRTYP_BYTE (0x4u << 19) /**< \brief (HSMCI_CMDR) SDIO Byte */
#define   HSMCI_CMDR_TRTYP_BLOCK (0x5u << 19) /**< \brief (HSMCI_CMDR) SDIO Block */
#define HSMCI_CMDR_IOSPCMD_Pos 24
#define HSMCI_CMDR_IOSPCMD_Msk (0x3u << HSMCI_CMDR_IOSPCMD_Pos) /**< \brief (HSMCI_CMDR) SDIO Special Command */
#define   HSMCI_CMDR_IOSPCMD_STD (0x0u << 24) /**< \brief (HSMCI_CMDR) Not an SDIO Special Command */
#define   HSMCI_CMDR_IOSPCMD_SUSPEND (0x1u << 24) /**< \brief (HSMCI_CMDR) SDIO Suspend Command */
#define   HSMCI_CMDR_IOSPCMD_RESUME (0x2u << 24) /**< \brief (HSMCI_CMDR) SDIO Resume Command */
#define HSMCI_CMDR_ATACS (0x1u << 26) /**< \brief (HSMCI_CMDR) ATA with Command Completion Signal */
#define   HSMCI_CMDR_ATACS_NORMAL (0x0u << 26) /**< \brief (HSMCI_CMDR) Normal operation mode. */
#define   HSMCI_CMDR_ATACS_COMPLETION (0x1u << 26) /**< \brief (HSMCI_CMDR) This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR). */
#define HSMCI_CMDR_BOOT_ACK (0x1u << 27) /**< \brief (HSMCI_CMDR) Boot Operation Acknowledge. */
/* -------- HSMCI_BLKR : (HSMCI Offset: 0x18) Block Register -------- */
#define HSMCI_BLKR_BCNT_Pos 0
#define HSMCI_BLKR_BCNT_Msk (0xffffu << HSMCI_BLKR_BCNT_Pos) /**< \brief (HSMCI_BLKR) MMC/SDIO Block Count - SDIO Byte Count */
#define HSMCI_BLKR_BCNT(value) ((HSMCI_BLKR_BCNT_Msk & ((value) << HSMCI_BLKR_BCNT_Pos)))
#define HSMCI_BLKR_BLKLEN_Pos 16
#define HSMCI_BLKR_BLKLEN_Msk (0xffffu << HSMCI_BLKR_BLKLEN_Pos) /**< \brief (HSMCI_BLKR) Data Block Length */
#define HSMCI_BLKR_BLKLEN(value) ((HSMCI_BLKR_BLKLEN_Msk & ((value) << HSMCI_BLKR_BLKLEN_Pos)))
/* -------- HSMCI_CSTOR : (HSMCI Offset: 0x1C) Completion Signal Timeout Register -------- */
#define HSMCI_CSTOR_CSTOCYC_Pos 0
#define HSMCI_CSTOR_CSTOCYC_Msk (0xfu << HSMCI_CSTOR_CSTOCYC_Pos) /**< \brief (HSMCI_CSTOR) Completion Signal Timeout Cycle Number */
#define HSMCI_CSTOR_CSTOCYC(value) ((HSMCI_CSTOR_CSTOCYC_Msk & ((value) << HSMCI_CSTOR_CSTOCYC_Pos)))
#define HSMCI_CSTOR_CSTOMUL_Pos 4
#define HSMCI_CSTOR_CSTOMUL_Msk (0x7u << HSMCI_CSTOR_CSTOMUL_Pos) /**< \brief (HSMCI_CSTOR) Completion Signal Timeout Multiplier */
#define   HSMCI_CSTOR_CSTOMUL_1 (0x0u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 1 */
#define   HSMCI_CSTOR_CSTOMUL_16 (0x1u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 16 */
#define   HSMCI_CSTOR_CSTOMUL_128 (0x2u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 128 */
#define   HSMCI_CSTOR_CSTOMUL_256 (0x3u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 256 */
#define   HSMCI_CSTOR_CSTOMUL_1024 (0x4u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 1024 */
#define   HSMCI_CSTOR_CSTOMUL_4096 (0x5u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 4096 */
#define   HSMCI_CSTOR_CSTOMUL_65536 (0x6u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 65536 */
#define   HSMCI_CSTOR_CSTOMUL_1048576 (0x7u << 4) /**< \brief (HSMCI_CSTOR) CSTOCYC x 1048576 */
/* -------- HSMCI_RSPR[4] : (HSMCI Offset: 0x20) Response Register -------- */
#define HSMCI_RSPR_RSP_Pos 0
#define HSMCI_RSPR_RSP_Msk (0xffffffffu << HSMCI_RSPR_RSP_Pos) /**< \brief (HSMCI_RSPR[4]) Response */
/* -------- HSMCI_RDR : (HSMCI Offset: 0x30) Receive Data Register -------- */
#define HSMCI_RDR_DATA_Pos 0
#define HSMCI_RDR_DATA_Msk (0xffffffffu << HSMCI_RDR_DATA_Pos) /**< \brief (HSMCI_RDR) Data to Read */
/* -------- HSMCI_TDR : (HSMCI Offset: 0x34) Transmit Data Register -------- */
#define HSMCI_TDR_DATA_Pos 0
#define HSMCI_TDR_DATA_Msk (0xffffffffu << HSMCI_TDR_DATA_Pos) /**< \brief (HSMCI_TDR) Data to Write */
#define HSMCI_TDR_DATA(value) ((HSMCI_TDR_DATA_Msk & ((value) << HSMCI_TDR_DATA_Pos)))
/* -------- HSMCI_SR : (HSMCI Offset: 0x40) Status Register -------- */
#define HSMCI_SR_CMDRDY (0x1u << 0) /**< \brief (HSMCI_SR) Command Ready */
#define HSMCI_SR_RXRDY (0x1u << 1) /**< \brief (HSMCI_SR) Receiver Ready */
#define HSMCI_SR_TXRDY (0x1u << 2) /**< \brief (HSMCI_SR) Transmit Ready */
#define HSMCI_SR_BLKE (0x1u << 3) /**< \brief (HSMCI_SR) Data Block Ended */
#define HSMCI_SR_DTIP (0x1u << 4) /**< \brief (HSMCI_SR) Data Transfer in Progress */
#define HSMCI_SR_NOTBUSY (0x1u << 5) /**< \brief (HSMCI_SR) HSMCI Not Busy */
#define HSMCI_SR_SDIOIRQA (0x1u << 8) /**< \brief (HSMCI_SR) SDIO Interrupt for Slot A */
#define HSMCI_SR_SDIOIRQB (0x1u << 9) /**< \brief (HSMCI_SR) SDIO Interrupt for Slot B */
#define HSMCI_SR_SDIOWAIT (0x1u << 12) /**< \brief (HSMCI_SR) SDIO Read Wait Operation Status */
#define HSMCI_SR_CSRCV (0x1u << 13) /**< \brief (HSMCI_SR) CE-ATA Completion Signal Received */
#define HSMCI_SR_RINDE (0x1u << 16) /**< \brief (HSMCI_SR) Response Index Error */
#define HSMCI_SR_RDIRE (0x1u << 17) /**< \brief (HSMCI_SR) Response Direction Error */
#define HSMCI_SR_RCRCE (0x1u << 18) /**< \brief (HSMCI_SR) Response CRC Error */
#define HSMCI_SR_RENDE (0x1u << 19) /**< \brief (HSMCI_SR) Response End Bit Error */
#define HSMCI_SR_RTOE (0x1u << 20) /**< \brief (HSMCI_SR) Response Time-out Error */
#define HSMCI_SR_DCRCE (0x1u << 21) /**< \brief (HSMCI_SR) Data CRC Error */
#define HSMCI_SR_DTOE (0x1u << 22) /**< \brief (HSMCI_SR) Data Time-out Error */
#define HSMCI_SR_CSTOE (0x1u << 23) /**< \brief (HSMCI_SR) Completion Signal Time-out Error */
#define HSMCI_SR_BLKOVRE (0x1u << 24) /**< \brief (HSMCI_SR) DMA Block Overrun Error */
#define HSMCI_SR_FIFOEMPTY (0x1u << 26) /**< \brief (HSMCI_SR) FIFO empty flag */
#define HSMCI_SR_XFRDONE (0x1u << 27) /**< \brief (HSMCI_SR) Transfer Done flag */
#define HSMCI_SR_ACKRCV (0x1u << 28) /**< \brief (HSMCI_SR) Boot Operation Acknowledge Received */
#define HSMCI_SR_ACKRCVE (0x1u << 29) /**< \brief (HSMCI_SR) Boot Operation Acknowledge Error */
#define HSMCI_SR_OVRE (0x1u << 30) /**< \brief (HSMCI_SR) Overrun */
#define HSMCI_SR_UNRE (0x1u << 31) /**< \brief (HSMCI_SR) Underrun */
/* -------- HSMCI_IER : (HSMCI Offset: 0x44) Interrupt Enable Register -------- */
#define HSMCI_IER_CMDRDY (0x1u << 0) /**< \brief (HSMCI_IER) Command Ready Interrupt Enable */
#define HSMCI_IER_RXRDY (0x1u << 1) /**< \brief (HSMCI_IER) Receiver Ready Interrupt Enable */
#define HSMCI_IER_TXRDY (0x1u << 2) /**< \brief (HSMCI_IER) Transmit Ready Interrupt Enable */
#define HSMCI_IER_BLKE (0x1u << 3) /**< \brief (HSMCI_IER) Data Block Ended Interrupt Enable */
#define HSMCI_IER_DTIP (0x1u << 4) /**< \brief (HSMCI_IER) Data Transfer in Progress Interrupt Enable */
#define HSMCI_IER_NOTBUSY (0x1u << 5) /**< \brief (HSMCI_IER) Data Not Busy Interrupt Enable */
#define HSMCI_IER_SDIOIRQA (0x1u << 8) /**< \brief (HSMCI_IER) SDIO Interrupt for Slot A Interrupt Enable */
#define HSMCI_IER_SDIOIRQB (0x1u << 9) /**< \brief (HSMCI_IER) SDIO Interrupt for Slot B Interrupt Enable */
#define HSMCI_IER_SDIOWAIT (0x1u << 12) /**< \brief (HSMCI_IER) SDIO Read Wait Operation Status Interrupt Enable */
#define HSMCI_IER_CSRCV (0x1u << 13) /**< \brief (HSMCI_IER) Completion Signal Received Interrupt Enable */
#define HSMCI_IER_RINDE (0x1u << 16) /**< \brief (HSMCI_IER) Response Index Error Interrupt Enable */
#define HSMCI_IER_RDIRE (0x1u << 17) /**< \brief (HSMCI_IER) Response Direction Error Interrupt Enable */
#define HSMCI_IER_RCRCE (0x1u << 18) /**< \brief (HSMCI_IER) Response CRC Error Interrupt Enable */
#define HSMCI_IER_RENDE (0x1u << 19) /**< \brief (HSMCI_IER) Response End Bit Error Interrupt Enable */
#define HSMCI_IER_RTOE (0x1u << 20) /**< \brief (HSMCI_IER) Response Time-out Error Interrupt Enable */
#define HSMCI_IER_DCRCE (0x1u << 21) /**< \brief (HSMCI_IER) Data CRC Error Interrupt Enable */
#define HSMCI_IER_DTOE (0x1u << 22) /**< \brief (HSMCI_IER) Data Time-out Error Interrupt Enable */
#define HSMCI_IER_CSTOE (0x1u << 23) /**< \brief (HSMCI_IER) Completion Signal Timeout Error Interrupt Enable */
#define HSMCI_IER_BLKOVRE (0x1u << 24) /**< \brief (HSMCI_IER) DMA Block Overrun Error Interrupt Enable */
#define HSMCI_IER_FIFOEMPTY (0x1u << 26) /**< \brief (HSMCI_IER) FIFO empty Interrupt enable */
#define HSMCI_IER_XFRDONE (0x1u << 27) /**< \brief (HSMCI_IER) Transfer Done Interrupt enable */
#define HSMCI_IER_ACKRCV (0x1u << 28) /**< \brief (HSMCI_IER) Boot Acknowledge Interrupt Enable */
#define HSMCI_IER_ACKRCVE (0x1u << 29) /**< \brief (HSMCI_IER) Boot Acknowledge Error Interrupt Enable */
#define HSMCI_IER_OVRE (0x1u << 30) /**< \brief (HSMCI_IER) Overrun Interrupt Enable */
#define HSMCI_IER_UNRE (0x1u << 31) /**< \brief (HSMCI_IER) Underrun Interrupt Enable */
/* -------- HSMCI_IDR : (HSMCI Offset: 0x48) Interrupt Disable Register -------- */
#define HSMCI_IDR_CMDRDY (0x1u << 0) /**< \brief (HSMCI_IDR) Command Ready Interrupt Disable */
#define HSMCI_IDR_RXRDY (0x1u << 1) /**< \brief (HSMCI_IDR) Receiver Ready Interrupt Disable */
#define HSMCI_IDR_TXRDY (0x1u << 2) /**< \brief (HSMCI_IDR) Transmit Ready Interrupt Disable */
#define HSMCI_IDR_BLKE (0x1u << 3) /**< \brief (HSMCI_IDR) Data Block Ended Interrupt Disable */
#define HSMCI_IDR_DTIP (0x1u << 4) /**< \brief (HSMCI_IDR) Data Transfer in Progress Interrupt Disable */
#define HSMCI_IDR_NOTBUSY (0x1u << 5) /**< \brief (HSMCI_IDR) Data Not Busy Interrupt Disable */
#define HSMCI_IDR_SDIOIRQA (0x1u << 8) /**< \brief (HSMCI_IDR) SDIO Interrupt for Slot A Interrupt Disable */
#define HSMCI_IDR_SDIOIRQB (0x1u << 9) /**< \brief (HSMCI_IDR) SDIO Interrupt for Slot B Interrupt Disable */
#define HSMCI_IDR_SDIOWAIT (0x1u << 12) /**< \brief (HSMCI_IDR) SDIO Read Wait Operation Status Interrupt Disable */
#define HSMCI_IDR_CSRCV (0x1u << 13) /**< \brief (HSMCI_IDR) Completion Signal received interrupt Disable */
#define HSMCI_IDR_RINDE (0x1u << 16) /**< \brief (HSMCI_IDR) Response Index Error Interrupt Disable */
#define HSMCI_IDR_RDIRE (0x1u << 17) /**< \brief (HSMCI_IDR) Response Direction Error Interrupt Disable */
#define HSMCI_IDR_RCRCE (0x1u << 18) /**< \brief (HSMCI_IDR) Response CRC Error Interrupt Disable */
#define HSMCI_IDR_RENDE (0x1u << 19) /**< \brief (HSMCI_IDR) Response End Bit Error Interrupt Disable */
#define HSMCI_IDR_RTOE (0x1u << 20) /**< \brief (HSMCI_IDR) Response Time-out Error Interrupt Disable */
#define HSMCI_IDR_DCRCE (0x1u << 21) /**< \brief (HSMCI_IDR) Data CRC Error Interrupt Disable */
#define HSMCI_IDR_DTOE (0x1u << 22) /**< \brief (HSMCI_IDR) Data Time-out Error Interrupt Disable */
#define HSMCI_IDR_CSTOE (0x1u << 23) /**< \brief (HSMCI_IDR) Completion Signal Time out Error Interrupt Disable */
#define HSMCI_IDR_BLKOVRE (0x1u << 24) /**< \brief (HSMCI_IDR) DMA Block Overrun Error Interrupt Disable */
#define HSMCI_IDR_FIFOEMPTY (0x1u << 26) /**< \brief (HSMCI_IDR) FIFO empty Interrupt Disable */
#define HSMCI_IDR_XFRDONE (0x1u << 27) /**< \brief (HSMCI_IDR) Transfer Done Interrupt Disable */
#define HSMCI_IDR_ACKRCV (0x1u << 28) /**< \brief (HSMCI_IDR) Boot Acknowledge Interrupt Disable */
#define HSMCI_IDR_ACKRCVE (0x1u << 29) /**< \brief (HSMCI_IDR) Boot Acknowledge Error Interrupt Disable */
#define HSMCI_IDR_OVRE (0x1u << 30) /**< \brief (HSMCI_IDR) Overrun Interrupt Disable */
#define HSMCI_IDR_UNRE (0x1u << 31) /**< \brief (HSMCI_IDR) Underrun Interrupt Disable */
/* -------- HSMCI_IMR : (HSMCI Offset: 0x4C) Interrupt Mask Register -------- */
#define HSMCI_IMR_CMDRDY (0x1u << 0) /**< \brief (HSMCI_IMR) Command Ready Interrupt Mask */
#define HSMCI_IMR_RXRDY (0x1u << 1) /**< \brief (HSMCI_IMR) Receiver Ready Interrupt Mask */
#define HSMCI_IMR_TXRDY (0x1u << 2) /**< \brief (HSMCI_IMR) Transmit Ready Interrupt Mask */
#define HSMCI_IMR_BLKE (0x1u << 3) /**< \brief (HSMCI_IMR) Data Block Ended Interrupt Mask */
#define HSMCI_IMR_DTIP (0x1u << 4) /**< \brief (HSMCI_IMR) Data Transfer in Progress Interrupt Mask */
#define HSMCI_IMR_NOTBUSY (0x1u << 5) /**< \brief (HSMCI_IMR) Data Not Busy Interrupt Mask */
#define HSMCI_IMR_SDIOIRQA (0x1u << 8) /**< \brief (HSMCI_IMR) SDIO Interrupt for Slot A Interrupt Mask */
#define HSMCI_IMR_SDIOIRQB (0x1u << 9) /**< \brief (HSMCI_IMR) SDIO Interrupt for Slot B Interrupt Mask */
#define HSMCI_IMR_SDIOWAIT (0x1u << 12) /**< \brief (HSMCI_IMR) SDIO Read Wait Operation Status Interrupt Mask */
#define HSMCI_IMR_CSRCV (0x1u << 13) /**< \brief (HSMCI_IMR) Completion Signal Received Interrupt Mask */
#define HSMCI_IMR_RINDE (0x1u << 16) /**< \brief (HSMCI_IMR) Response Index Error Interrupt Mask */
#define HSMCI_IMR_RDIRE (0x1u << 17) /**< \brief (HSMCI_IMR) Response Direction Error Interrupt Mask */
#define HSMCI_IMR_RCRCE (0x1u << 18) /**< \brief (HSMCI_IMR) Response CRC Error Interrupt Mask */
#define HSMCI_IMR_RENDE (0x1u << 19) /**< \brief (HSMCI_IMR) Response End Bit Error Interrupt Mask */
#define HSMCI_IMR_RTOE (0x1u << 20) /**< \brief (HSMCI_IMR) Response Time-out Error Interrupt Mask */
#define HSMCI_IMR_DCRCE (0x1u << 21) /**< \brief (HSMCI_IMR) Data CRC Error Interrupt Mask */
#define HSMCI_IMR_DTOE (0x1u << 22) /**< \brief (HSMCI_IMR) Data Time-out Error Interrupt Mask */
#define HSMCI_IMR_CSTOE (0x1u << 23) /**< \brief (HSMCI_IMR) Completion Signal Time-out Error Interrupt Mask */
#define HSMCI_IMR_BLKOVRE (0x1u << 24) /**< \brief (HSMCI_IMR) DMA Block Overrun Error Interrupt Mask */
#define HSMCI_IMR_FIFOEMPTY (0x1u << 26) /**< \brief (HSMCI_IMR) FIFO Empty Interrupt Mask */
#define HSMCI_IMR_XFRDONE (0x1u << 27) /**< \brief (HSMCI_IMR) Transfer Done Interrupt Mask */
#define HSMCI_IMR_ACKRCV (0x1u << 28) /**< \brief (HSMCI_IMR) Boot Operation Acknowledge Received Interrupt Mask */
#define HSMCI_IMR_ACKRCVE (0x1u << 29) /**< \brief (HSMCI_IMR) Boot Operation Acknowledge Error Interrupt Mask */
#define HSMCI_IMR_OVRE (0x1u << 30) /**< \brief (HSMCI_IMR) Overrun Interrupt Mask */
#define HSMCI_IMR_UNRE (0x1u << 31) /**< \brief (HSMCI_IMR) Underrun Interrupt Mask */
/* -------- HSMCI_DMA : (HSMCI Offset: 0x50) DMA Configuration Register -------- */
#define HSMCI_DMA_CHKSIZE_Pos 4
#define HSMCI_DMA_CHKSIZE_Msk (0x7u << HSMCI_DMA_CHKSIZE_Pos) /**< \brief (HSMCI_DMA) DMA Channel Read and Write Chunk Size */
#define HSMCI_DMA_CHKSIZE(value) ((HSMCI_DMA_CHKSIZE_Msk & ((value) << HSMCI_DMA_CHKSIZE_Pos)))
#define HSMCI_DMA_DMAEN (0x1u << 8) /**< \brief (HSMCI_DMA) DMA Hardware Handshaking Enable */
/* -------- HSMCI_CFG : (HSMCI Offset: 0x54) Configuration Register -------- */
#define HSMCI_CFG_FIFOMODE (0x1u << 0) /**< \brief (HSMCI_CFG) HSMCI Internal FIFO control mode */
#define HSMCI_CFG_FERRCTRL (0x1u << 4) /**< \brief (HSMCI_CFG) Flow Error flag reset control mode */
#define HSMCI_CFG_HSMODE (0x1u << 8) /**< \brief (HSMCI_CFG) High Speed Mode */
#define HSMCI_CFG_LSYNC (0x1u << 12) /**< \brief (HSMCI_CFG) Synchronize on the last block */
/* -------- HSMCI_WPMR : (HSMCI Offset: 0xE4) Write Protection Mode Register -------- */
#define HSMCI_WPMR_WP_EN (0x1u << 0) /**< \brief (HSMCI_WPMR) Write Protection Enable */
#define HSMCI_WPMR_WP_KEY_Pos 8
#define HSMCI_WPMR_WP_KEY_Msk (0xffffffu << HSMCI_WPMR_WP_KEY_Pos) /**< \brief (HSMCI_WPMR) Write Protection Key password */
#define HSMCI_WPMR_WP_KEY(value) ((HSMCI_WPMR_WP_KEY_Msk & ((value) << HSMCI_WPMR_WP_KEY_Pos)))
/* -------- HSMCI_WPSR : (HSMCI Offset: 0xE8) Write Protection Status Register -------- */
#define HSMCI_WPSR_WP_VS_Pos 0
#define HSMCI_WPSR_WP_VS_Msk (0xfu << HSMCI_WPSR_WP_VS_Pos) /**< \brief (HSMCI_WPSR) Write Protection Violation Status */
#define   HSMCI_WPSR_WP_VS_NONE (0x0u << 0) /**< \brief (HSMCI_WPSR) No Write Protection Violation occurred since the last read of this register (WP_SR) */
#define   HSMCI_WPSR_WP_VS_WRITE (0x1u << 0) /**< \brief (HSMCI_WPSR) Write Protection detected unauthorized attempt to write a control register had occurred (since the last read.) */
#define   HSMCI_WPSR_WP_VS_RESET (0x2u << 0) /**< \brief (HSMCI_WPSR) Software reset had been performed while Write Protection was enabled (since the last read). */
#define   HSMCI_WPSR_WP_VS_BOTH (0x3u << 0) /**< \brief (HSMCI_WPSR) Both Write Protection violation and software reset with Write Protection enabled have occurred since the last read. */
#define HSMCI_WPSR_WP_VSRC_Pos 8
#define HSMCI_WPSR_WP_VSRC_Msk (0xffffu << HSMCI_WPSR_WP_VSRC_Pos) /**< \brief (HSMCI_WPSR) Write Protection Violation SouRCe */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Integrity Check Monitor */
/* ============================================================================= */
/** \addtogroup SAMA5D4_ICM Integrity Check Monitor */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Icm hardware registers */
typedef struct {
  __IO uint32_t ICM_CFG;       /**< \brief (Icm Offset: 0x00) Configuration Register */
  __O  uint32_t ICM_CTRL;      /**< \brief (Icm Offset: 0x04) Control Register */
  __O  uint32_t ICM_SR;        /**< \brief (Icm Offset: 0x08) Status Register */
  __I  uint32_t Reserved1[1];
  __O  uint32_t ICM_IER;       /**< \brief (Icm Offset: 0x10) Interrupt Enable Register */
  __O  uint32_t ICM_IDR;       /**< \brief (Icm Offset: 0x14) Interrupt Disable Register */
  __I  uint32_t ICM_IMR;       /**< \brief (Icm Offset: 0x18) Interrupt Mask Register */
  __I  uint32_t ICM_ISR;       /**< \brief (Icm Offset: 0x1C) Interrupt Status Register */
  __I  uint32_t ICM_UASR;      /**< \brief (Icm Offset: 0x20) Undefined Access Status Register */
  __I  uint32_t Reserved2[3];
  __IO uint32_t ICM_DSCR;      /**< \brief (Icm Offset: 0x30) Region Descriptor Area Start Address Register */
  __IO uint32_t ICM_HASH;      /**< \brief (Icm Offset: 0x34) Region Hash Area Start Address Register */
  __O  uint32_t ICM_UIHVAL[8]; /**< \brief (Icm Offset: 0x38) User Initial Hash Value 0 Register */
} Icm;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- ICM_CFG : (ICM Offset: 0x00) Configuration Register -------- */
#define ICM_CFG_WBDIS (0x1u << 0) /**< \brief (ICM_CFG) Write Back Disable */
#define ICM_CFG_EOMDIS (0x1u << 1) /**< \brief (ICM_CFG) End of Monitoring Disable */
#define ICM_CFG_SLBDIS (0x1u << 2) /**< \brief (ICM_CFG) Secondary List Branching Disable */
#define ICM_CFG_BBC_Pos 4
#define ICM_CFG_BBC_Msk (0xfu << ICM_CFG_BBC_Pos) /**< \brief (ICM_CFG) Bus Burden Control */
#define ICM_CFG_BBC(value) ((ICM_CFG_BBC_Msk & ((value) << ICM_CFG_BBC_Pos)))
#define ICM_CFG_ASCD (0x1u << 8) /**< \brief (ICM_CFG) Automatic Switch To Compare Digest */
#define ICM_CFG_DUALBUFF (0x1u << 9) /**< \brief (ICM_CFG) Dual Input Buffer */
#define ICM_CFG_UIHASH (0x1u << 12) /**< \brief (ICM_CFG) User Initial Hash Value */
#define ICM_CFG_UALGO_Pos 13
#define ICM_CFG_UALGO_Msk (0x7u << ICM_CFG_UALGO_Pos) /**< \brief (ICM_CFG) User SHA Algorithm */
#define   ICM_CFG_UALGO_SHA1 (0x0u << 13) /**< \brief (ICM_CFG) SHA1 algorithm processed */
#define   ICM_CFG_UALGO_SHA256 (0x1u << 13) /**< \brief (ICM_CFG) SHA256 algorithm processed */
#define   ICM_CFG_UALGO_SHA224 (0x4u << 13) /**< \brief (ICM_CFG) SHA224 algorithm processed */
#define ICM_CFG_HAPROT_Pos 16
#define ICM_CFG_HAPROT_Msk (0x3fu << ICM_CFG_HAPROT_Pos) /**< \brief (ICM_CFG) Region Hash Area Protection */
#define ICM_CFG_HAPROT(value) ((ICM_CFG_HAPROT_Msk & ((value) << ICM_CFG_HAPROT_Pos)))
#define ICM_CFG_DAPROT_Pos 24
#define ICM_CFG_DAPROT_Msk (0x3fu << ICM_CFG_DAPROT_Pos) /**< \brief (ICM_CFG) Region Descriptor Area Protection */
#define ICM_CFG_DAPROT(value) ((ICM_CFG_DAPROT_Msk & ((value) << ICM_CFG_DAPROT_Pos)))
/* -------- ICM_CTRL : (ICM Offset: 0x04) Control Register -------- */
#define ICM_CTRL_ENABLE (0x1u << 0) /**< \brief (ICM_CTRL) ICM Enable */
#define ICM_CTRL_DISABLE (0x1u << 1) /**< \brief (ICM_CTRL) ICM Disable Register */
#define ICM_CTRL_SWRST (0x1u << 2) /**< \brief (ICM_CTRL) Software Reset */
#define ICM_CTRL_REHASH_Pos 4
#define ICM_CTRL_REHASH_Msk (0xfu << ICM_CTRL_REHASH_Pos) /**< \brief (ICM_CTRL) Recompute Internal Hash */
#define ICM_CTRL_REHASH(value) ((ICM_CTRL_REHASH_Msk & ((value) << ICM_CTRL_REHASH_Pos)))
#define ICM_CTRL_RMDIS_Pos 8
#define ICM_CTRL_RMDIS_Msk (0xfu << ICM_CTRL_RMDIS_Pos) /**< \brief (ICM_CTRL) Region Monitoring Disable */
#define ICM_CTRL_RMDIS(value) ((ICM_CTRL_RMDIS_Msk & ((value) << ICM_CTRL_RMDIS_Pos)))
#define ICM_CTRL_RMEN_Pos 12
#define ICM_CTRL_RMEN_Msk (0xfu << ICM_CTRL_RMEN_Pos) /**< \brief (ICM_CTRL) Region Monitoring Enable */
#define ICM_CTRL_RMEN(value) ((ICM_CTRL_RMEN_Msk & ((value) << ICM_CTRL_RMEN_Pos)))
/* -------- ICM_SR : (ICM Offset: 0x08) Status Register -------- */
#define ICM_SR_ENABLE (0x1u << 0) /**< \brief (ICM_SR) ICM Controller Enable Register */
#define ICM_SR_RAWRMDIS_Pos 8
#define ICM_SR_RAWRMDIS_Msk (0xfu << ICM_SR_RAWRMDIS_Pos) /**< \brief (ICM_SR) RAW Region Monitoring Disabled Status */
#define ICM_SR_RAWRMDIS(value) ((ICM_SR_RAWRMDIS_Msk & ((value) << ICM_SR_RAWRMDIS_Pos)))
#define ICM_SR_RMDIS_Pos 12
#define ICM_SR_RMDIS_Msk (0xfu << ICM_SR_RMDIS_Pos) /**< \brief (ICM_SR) Region Monitoring Disabled Status */
#define ICM_SR_RMDIS(value) ((ICM_SR_RMDIS_Msk & ((value) << ICM_SR_RMDIS_Pos)))
/* -------- ICM_IER : (ICM Offset: 0x10) Interrupt Enable Register -------- */
#define ICM_IER_RHC_Pos 0
#define ICM_IER_RHC_Msk (0xfu << ICM_IER_RHC_Pos) /**< \brief (ICM_IER) Region Hash Completed Interrupt Enable */
#define ICM_IER_RHC(value) ((ICM_IER_RHC_Msk & ((value) << ICM_IER_RHC_Pos)))
#define ICM_IER_RDM_Pos 4
#define ICM_IER_RDM_Msk (0xfu << ICM_IER_RDM_Pos) /**< \brief (ICM_IER) Region Digest Mismatch Interrupt Enable */
#define ICM_IER_RDM(value) ((ICM_IER_RDM_Msk & ((value) << ICM_IER_RDM_Pos)))
#define ICM_IER_RBE_Pos 8
#define ICM_IER_RBE_Msk (0xfu << ICM_IER_RBE_Pos) /**< \brief (ICM_IER) Region Bus Error Interrupt Enable */
#define ICM_IER_RBE(value) ((ICM_IER_RBE_Msk & ((value) << ICM_IER_RBE_Pos)))
#define ICM_IER_RWC_Pos 12
#define ICM_IER_RWC_Msk (0xfu << ICM_IER_RWC_Pos) /**< \brief (ICM_IER) Region Wrap Condition detected Interrupt Enable */
#define ICM_IER_RWC(value) ((ICM_IER_RWC_Msk & ((value) << ICM_IER_RWC_Pos)))
#define ICM_IER_REC_Pos 16
#define ICM_IER_REC_Msk (0xfu << ICM_IER_REC_Pos) /**< \brief (ICM_IER) Region End bit Condition Detected Interrupt Enable */
#define ICM_IER_REC(value) ((ICM_IER_REC_Msk & ((value) << ICM_IER_REC_Pos)))
#define ICM_IER_RSU_Pos 20
#define ICM_IER_RSU_Msk (0xfu << ICM_IER_RSU_Pos) /**< \brief (ICM_IER) Region Status Updated Interrupt Disable */
#define ICM_IER_RSU(value) ((ICM_IER_RSU_Msk & ((value) << ICM_IER_RSU_Pos)))
#define ICM_IER_URAD (0x1u << 24) /**< \brief (ICM_IER) Undefined Register Access Detection Interrupt Enable */
/* -------- ICM_IDR : (ICM Offset: 0x14) Interrupt Disable Register -------- */
#define ICM_IDR_RHC_Pos 0
#define ICM_IDR_RHC_Msk (0xfu << ICM_IDR_RHC_Pos) /**< \brief (ICM_IDR) Region Hash Completed Interrupt Disable */
#define ICM_IDR_RHC(value) ((ICM_IDR_RHC_Msk & ((value) << ICM_IDR_RHC_Pos)))
#define ICM_IDR_RDM_Pos 4
#define ICM_IDR_RDM_Msk (0xfu << ICM_IDR_RDM_Pos) /**< \brief (ICM_IDR) Region Digest Mismatch Interrupt Disable */
#define ICM_IDR_RDM(value) ((ICM_IDR_RDM_Msk & ((value) << ICM_IDR_RDM_Pos)))
#define ICM_IDR_RBE_Pos 8
#define ICM_IDR_RBE_Msk (0xfu << ICM_IDR_RBE_Pos) /**< \brief (ICM_IDR) Region Bus Error Interrupt Disable */
#define ICM_IDR_RBE(value) ((ICM_IDR_RBE_Msk & ((value) << ICM_IDR_RBE_Pos)))
#define ICM_IDR_RWC_Pos 12
#define ICM_IDR_RWC_Msk (0xfu << ICM_IDR_RWC_Pos) /**< \brief (ICM_IDR) Region Wrap Condition Detected Interrupt Disable */
#define ICM_IDR_RWC(value) ((ICM_IDR_RWC_Msk & ((value) << ICM_IDR_RWC_Pos)))
#define ICM_IDR_REC_Pos 16
#define ICM_IDR_REC_Msk (0xfu << ICM_IDR_REC_Pos) /**< \brief (ICM_IDR) Region End bit Condition detected Interrupt Disable */
#define ICM_IDR_REC(value) ((ICM_IDR_REC_Msk & ((value) << ICM_IDR_REC_Pos)))
#define ICM_IDR_RSU_Pos 20
#define ICM_IDR_RSU_Msk (0xfu << ICM_IDR_RSU_Pos) /**< \brief (ICM_IDR) Region Status Updated Interrupt Disable */
#define ICM_IDR_RSU(value) ((ICM_IDR_RSU_Msk & ((value) << ICM_IDR_RSU_Pos)))
#define ICM_IDR_URAD (0x1u << 24) /**< \brief (ICM_IDR) Undefined Register Access Detection Interrupt Disable */
/* -------- ICM_IMR : (ICM Offset: 0x18) Interrupt Mask Register -------- */
#define ICM_IMR_RHC_Pos 0
#define ICM_IMR_RHC_Msk (0xfu << ICM_IMR_RHC_Pos) /**< \brief (ICM_IMR) Region Hash Completed Interrupt Mask */
#define ICM_IMR_RDM_Pos 4
#define ICM_IMR_RDM_Msk (0xfu << ICM_IMR_RDM_Pos) /**< \brief (ICM_IMR) Region Digest Mismatch Interrupt Mask */
#define ICM_IMR_RBE_Pos 8
#define ICM_IMR_RBE_Msk (0xfu << ICM_IMR_RBE_Pos) /**< \brief (ICM_IMR) Region Bus Error Interrupt Mask */
#define ICM_IMR_RWC_Pos 12
#define ICM_IMR_RWC_Msk (0xfu << ICM_IMR_RWC_Pos) /**< \brief (ICM_IMR) Region Wrap Condition Detected Interrupt Mask */
#define ICM_IMR_REC_Pos 16
#define ICM_IMR_REC_Msk (0xfu << ICM_IMR_REC_Pos) /**< \brief (ICM_IMR) Region End bit Condition Detected Interrupt Mask */
#define ICM_IMR_RSU_Pos 20
#define ICM_IMR_RSU_Msk (0xfu << ICM_IMR_RSU_Pos) /**< \brief (ICM_IMR) Region Status Updated Interrupt Mask */
#define ICM_IMR_URAD (0x1u << 24) /**< \brief (ICM_IMR) Undefined Register Access Detection Interrupt Mask */
/* -------- ICM_ISR : (ICM Offset: 0x1C) Interrupt Status Register -------- */
#define ICM_ISR_RHC_Pos 0
#define ICM_ISR_RHC_Msk (0xfu << ICM_ISR_RHC_Pos) /**< \brief (ICM_ISR) Region Hash Completed */
#define ICM_ISR_RDM_Pos 4
#define ICM_ISR_RDM_Msk (0xfu << ICM_ISR_RDM_Pos) /**< \brief (ICM_ISR) Region Digest Mismatch */
#define ICM_ISR_RBE_Pos 8
#define ICM_ISR_RBE_Msk (0xfu << ICM_ISR_RBE_Pos) /**< \brief (ICM_ISR) Region Bus Error */
#define ICM_ISR_RWC_Pos 12
#define ICM_ISR_RWC_Msk (0xfu << ICM_ISR_RWC_Pos) /**< \brief (ICM_ISR) Region Wrap Condition Detected */
#define ICM_ISR_REC_Pos 16
#define ICM_ISR_REC_Msk (0xfu << ICM_ISR_REC_Pos) /**< \brief (ICM_ISR) Region End bit Condition Detected */
#define ICM_ISR_RSU_Pos 20
#define ICM_ISR_RSU_Msk (0xfu << ICM_ISR_RSU_Pos) /**< \brief (ICM_ISR) Region Status Updated Detected */
#define ICM_ISR_URAD (0x1u << 24) /**< \brief (ICM_ISR) Undefined Register Access Detection Status */
/* -------- ICM_UASR : (ICM Offset: 0x20) Undefined Access Status Register -------- */
#define ICM_UASR_URAT_Pos 0
#define ICM_UASR_URAT_Msk (0x7u << ICM_UASR_URAT_Pos) /**< \brief (ICM_UASR) Undefined Register Access Trace */
#define   ICM_UASR_URAT_UNSPEC_STRUCT_MEMBER (0x0u << 0) /**< \brief (ICM_UASR) Unspecified structure member set to one detected when the descriptor is loaded. */
#define   ICM_UASR_URAT_ICM_CFG_MODIFIED (0x1u << 0) /**< \brief (ICM_UASR) ICM_CFG modified during active monitoring. */
#define   ICM_UASR_URAT_ICM_DSCR_MODIFIED (0x2u << 0) /**< \brief (ICM_UASR) ICM_DSCR modified during active monitoring. */
#define   ICM_UASR_URAT_ICM_HASH_MODIFIED (0x3u << 0) /**< \brief (ICM_UASR) ICM_HASH modified during active monitoring */
#define   ICM_UASR_URAT_READ_ACCESS (0x4u << 0) /**< \brief (ICM_UASR) Write-only register read access */
/* -------- ICM_DSCR : (ICM Offset: 0x30) Region Descriptor Area Start Address Register -------- */
#define ICM_DSCR_DASA_Pos 6
#define ICM_DSCR_DASA_Msk (0x3ffffffu << ICM_DSCR_DASA_Pos) /**< \brief (ICM_DSCR) Descriptor Area Start Address */
#define ICM_DSCR_DASA(value) ((ICM_DSCR_DASA_Msk & ((value) << ICM_DSCR_DASA_Pos)))
/* -------- ICM_HASH : (ICM Offset: 0x34) Region Hash Area Start Address Register -------- */
#define ICM_HASH_HASA_Pos 7
#define ICM_HASH_HASA_Msk (0x1ffffffu << ICM_HASH_HASA_Pos) /**< \brief (ICM_HASH) Hash Area Start Address */
#define ICM_HASH_HASA(value) ((ICM_HASH_HASA_Msk & ((value) << ICM_HASH_HASA_Pos)))
/* -------- ICM_UIHVAL[8] : (ICM Offset: 0x38) User Initial Hash Value 0 Register -------- */
#define ICM_UIHVAL_VAL_Pos 0
#define ICM_UIHVAL_VAL_Msk (0xffffffffu << ICM_UIHVAL_VAL_Pos) /**< \brief (ICM_UIHVAL[8]) Initial Hash Value */
#define ICM_UIHVAL_VAL(value) ((ICM_UIHVAL_VAL_Msk & ((value) << ICM_UIHVAL_VAL_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Image Sensor Interface */
/* ============================================================================= */
/** \addtogroup SAMA5D4_ISI Image Sensor Interface */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Isi hardware registers */
typedef struct {
  __IO uint32_t ISI_CFG1;       /**< \brief (Isi Offset: 0x00) ISI Configuration 1 Register */
  __IO uint32_t ISI_CFG2;       /**< \brief (Isi Offset: 0x04) ISI Configuration 2 Register */
  __IO uint32_t ISI_PSIZE;      /**< \brief (Isi Offset: 0x08) ISI Preview Size Register */
  __IO uint32_t ISI_PDECF;      /**< \brief (Isi Offset: 0x0C) ISI Preview Decimation Factor Register */
  __IO uint32_t ISI_Y2R_SET0;   /**< \brief (Isi Offset: 0x10) ISI CSC YCrCb To RGB Set 0 Register */
  __IO uint32_t ISI_Y2R_SET1;   /**< \brief (Isi Offset: 0x14) ISI CSC YCrCb To RGB Set 1 Register */
  __IO uint32_t ISI_R2Y_SET0;   /**< \brief (Isi Offset: 0x18) ISI CSC RGB To YCrCb Set 0 Register */
  __IO uint32_t ISI_R2Y_SET1;   /**< \brief (Isi Offset: 0x1C) ISI CSC RGB To YCrCb Set 1 Register */
  __IO uint32_t ISI_R2Y_SET2;   /**< \brief (Isi Offset: 0x20) ISI CSC RGB To YCrCb Set 2 Register */
  __O  uint32_t ISI_CR;         /**< \brief (Isi Offset: 0x24) ISI Control Register */
  __I  uint32_t ISI_SR;         /**< \brief (Isi Offset: 0x28) ISI Status Register */
  __O  uint32_t ISI_IER;        /**< \brief (Isi Offset: 0x2C) ISI Interrupt Enable Register */
  __O  uint32_t ISI_IDR;        /**< \brief (Isi Offset: 0x30) ISI Interrupt Disable Register */
  __I  uint32_t ISI_IMR;        /**< \brief (Isi Offset: 0x34) ISI Interrupt Mask Register */
  __O  uint32_t ISI_DMA_CHER;   /**< \brief (Isi Offset: 0x38) DMA Channel Enable Register */
  __O  uint32_t ISI_DMA_CHDR;   /**< \brief (Isi Offset: 0x3C) DMA Channel Disable Register */
  __I  uint32_t ISI_DMA_CHSR;   /**< \brief (Isi Offset: 0x40) DMA Channel Status Register */
  __IO uint32_t ISI_DMA_P_ADDR; /**< \brief (Isi Offset: 0x44) DMA Preview Base Address Register */
  __IO uint32_t ISI_DMA_P_CTRL; /**< \brief (Isi Offset: 0x48) DMA Preview Control Register */
  __IO uint32_t ISI_DMA_P_DSCR; /**< \brief (Isi Offset: 0x4C) DMA Preview Descriptor Address Register */
  __IO uint32_t ISI_DMA_C_ADDR; /**< \brief (Isi Offset: 0x50) DMA Codec Base Address Register */
  __IO uint32_t ISI_DMA_C_CTRL; /**< \brief (Isi Offset: 0x54) DMA Codec Control Register */
  __IO uint32_t ISI_DMA_C_DSCR; /**< \brief (Isi Offset: 0x58) DMA Codec Descriptor Address Register */
  __I  uint32_t Reserved1[34];
  __IO uint32_t ISI_WPCR;       /**< \brief (Isi Offset: 0xE4) Write Protection Control Register */
  __I  uint32_t ISI_WPSR;       /**< \brief (Isi Offset: 0xE8) Write Protection Status Register */
} Isi;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- ISI_CFG1 : (ISI Offset: 0x00) ISI Configuration 1 Register -------- */
#define ISI_CFG1_HSYNC_POL (0x1u << 2) /**< \brief (ISI_CFG1) Horizontal Synchronization Polarity */
#define ISI_CFG1_VSYNC_POL (0x1u << 3) /**< \brief (ISI_CFG1) Vertical Synchronization Polarity */
#define ISI_CFG1_PIXCLK_POL (0x1u << 4) /**< \brief (ISI_CFG1) Pixel Clock Polarity */
#define ISI_CFG1_EMB_SYNC (0x1u << 6) /**< \brief (ISI_CFG1) Embedded Synchronization */
#define ISI_CFG1_CRC_SYNC (0x1u << 7) /**< \brief (ISI_CFG1) Embedded Synchronization Correction */
#define ISI_CFG1_FRATE_Pos 8
#define ISI_CFG1_FRATE_Msk (0x7u << ISI_CFG1_FRATE_Pos) /**< \brief (ISI_CFG1) Frame Rate [0..7] */
#define ISI_CFG1_FRATE(value) ((ISI_CFG1_FRATE_Msk & ((value) << ISI_CFG1_FRATE_Pos)))
#define ISI_CFG1_DISCR (0x1u << 11) /**< \brief (ISI_CFG1) Disable Codec Request */
#define ISI_CFG1_FULL (0x1u << 12) /**< \brief (ISI_CFG1) Full Mode is Allowed */
#define ISI_CFG1_THMASK_Pos 13
#define ISI_CFG1_THMASK_Msk (0x3u << ISI_CFG1_THMASK_Pos) /**< \brief (ISI_CFG1) Threshold Mask */
#define   ISI_CFG1_THMASK_BEATS_4 (0x0u << 13) /**< \brief (ISI_CFG1) Only 4 beats AHB burst allowed */
#define   ISI_CFG1_THMASK_BEATS_8 (0x1u << 13) /**< \brief (ISI_CFG1) Only 4 and 8 beats AHB burst allowed */
#define   ISI_CFG1_THMASK_BEATS_16 (0x2u << 13) /**< \brief (ISI_CFG1) 4, 8 and 16 beats AHB burst allowed */
#define ISI_CFG1_SLD_Pos 16
#define ISI_CFG1_SLD_Msk (0xffu << ISI_CFG1_SLD_Pos) /**< \brief (ISI_CFG1) Start of Line Delay */
#define ISI_CFG1_SLD(value) ((ISI_CFG1_SLD_Msk & ((value) << ISI_CFG1_SLD_Pos)))
#define ISI_CFG1_SFD_Pos 24
#define ISI_CFG1_SFD_Msk (0xffu << ISI_CFG1_SFD_Pos) /**< \brief (ISI_CFG1) Start of Frame Delay */
#define ISI_CFG1_SFD(value) ((ISI_CFG1_SFD_Msk & ((value) << ISI_CFG1_SFD_Pos)))
/* -------- ISI_CFG2 : (ISI Offset: 0x04) ISI Configuration 2 Register -------- */
#define ISI_CFG2_IM_VSIZE_Pos 0
#define ISI_CFG2_IM_VSIZE_Msk (0x7ffu << ISI_CFG2_IM_VSIZE_Pos) /**< \brief (ISI_CFG2) Vertical Size of the Image Sensor [0..2047]: */
#define ISI_CFG2_IM_VSIZE(value) ((ISI_CFG2_IM_VSIZE_Msk & ((value) << ISI_CFG2_IM_VSIZE_Pos)))
#define ISI_CFG2_GS_MODE (0x1u << 11) /**< \brief (ISI_CFG2)  */
#define ISI_CFG2_RGB_MODE (0x1u << 12) /**< \brief (ISI_CFG2) RGB Input Mode: */
#define ISI_CFG2_GRAYSCALE (0x1u << 13) /**< \brief (ISI_CFG2)  */
#define ISI_CFG2_RGB_SWAP (0x1u << 14) /**< \brief (ISI_CFG2)  */
#define ISI_CFG2_COL_SPACE (0x1u << 15) /**< \brief (ISI_CFG2) Color Space for the Image Data */
#define ISI_CFG2_IM_HSIZE_Pos 16
#define ISI_CFG2_IM_HSIZE_Msk (0x7ffu << ISI_CFG2_IM_HSIZE_Pos) /**< \brief (ISI_CFG2) Horizontal Size of the Image Sensor [0..2047] */
#define ISI_CFG2_IM_HSIZE(value) ((ISI_CFG2_IM_HSIZE_Msk & ((value) << ISI_CFG2_IM_HSIZE_Pos)))
#define ISI_CFG2_YCC_SWAP_Pos 28
#define ISI_CFG2_YCC_SWAP_Msk (0x3u << ISI_CFG2_YCC_SWAP_Pos) /**< \brief (ISI_CFG2) Defines the YCC Image Data */
#define ISI_CFG2_YCC_SWAP(value) ((ISI_CFG2_YCC_SWAP_Msk & ((value) << ISI_CFG2_YCC_SWAP_Pos)))
#define ISI_CFG2_RGB_CFG_Pos 30
#define ISI_CFG2_RGB_CFG_Msk (0x3u << ISI_CFG2_RGB_CFG_Pos) /**< \brief (ISI_CFG2) Defines RGB Pattern when RGB_MODE is set to 1 */
#define ISI_CFG2_RGB_CFG(value) ((ISI_CFG2_RGB_CFG_Msk & ((value) << ISI_CFG2_RGB_CFG_Pos)))
/* -------- ISI_PSIZE : (ISI Offset: 0x08) ISI Preview Size Register -------- */
#define ISI_PSIZE_PREV_VSIZE_Pos 0
#define ISI_PSIZE_PREV_VSIZE_Msk (0x3ffu << ISI_PSIZE_PREV_VSIZE_Pos) /**< \brief (ISI_PSIZE) Vertical Size for the Preview Path */
#define ISI_PSIZE_PREV_VSIZE(value) ((ISI_PSIZE_PREV_VSIZE_Msk & ((value) << ISI_PSIZE_PREV_VSIZE_Pos)))
#define ISI_PSIZE_PREV_HSIZE_Pos 16
#define ISI_PSIZE_PREV_HSIZE_Msk (0x3ffu << ISI_PSIZE_PREV_HSIZE_Pos) /**< \brief (ISI_PSIZE) Horizontal Size for the Preview Path */
#define ISI_PSIZE_PREV_HSIZE(value) ((ISI_PSIZE_PREV_HSIZE_Msk & ((value) << ISI_PSIZE_PREV_HSIZE_Pos)))
/* -------- ISI_PDECF : (ISI Offset: 0x0C) ISI Preview Decimation Factor Register -------- */
#define ISI_PDECF_DEC_FACTOR_Pos 0
#define ISI_PDECF_DEC_FACTOR_Msk (0xffu << ISI_PDECF_DEC_FACTOR_Pos) /**< \brief (ISI_PDECF) Decimation Factor */
#define ISI_PDECF_DEC_FACTOR(value) ((ISI_PDECF_DEC_FACTOR_Msk & ((value) << ISI_PDECF_DEC_FACTOR_Pos)))
/* -------- ISI_Y2R_SET0 : (ISI Offset: 0x10) ISI CSC YCrCb To RGB Set 0 Register -------- */
#define ISI_Y2R_SET0_C0_Pos 0
#define ISI_Y2R_SET0_C0_Msk (0xffu << ISI_Y2R_SET0_C0_Pos) /**< \brief (ISI_Y2R_SET0) Color Space Conversion Matrix Coefficient C0 */
#define ISI_Y2R_SET0_C0(value) ((ISI_Y2R_SET0_C0_Msk & ((value) << ISI_Y2R_SET0_C0_Pos)))
#define ISI_Y2R_SET0_C1_Pos 8
#define ISI_Y2R_SET0_C1_Msk (0xffu << ISI_Y2R_SET0_C1_Pos) /**< \brief (ISI_Y2R_SET0) Color Space Conversion Matrix Coefficient C1 */
#define ISI_Y2R_SET0_C1(value) ((ISI_Y2R_SET0_C1_Msk & ((value) << ISI_Y2R_SET0_C1_Pos)))
#define ISI_Y2R_SET0_C2_Pos 16
#define ISI_Y2R_SET0_C2_Msk (0xffu << ISI_Y2R_SET0_C2_Pos) /**< \brief (ISI_Y2R_SET0) Color Space Conversion Matrix Coefficient C2 */
#define ISI_Y2R_SET0_C2(value) ((ISI_Y2R_SET0_C2_Msk & ((value) << ISI_Y2R_SET0_C2_Pos)))
#define ISI_Y2R_SET0_C3_Pos 24
#define ISI_Y2R_SET0_C3_Msk (0xffu << ISI_Y2R_SET0_C3_Pos) /**< \brief (ISI_Y2R_SET0) Color Space Conversion Matrix Coefficient C3 */
#define ISI_Y2R_SET0_C3(value) ((ISI_Y2R_SET0_C3_Msk & ((value) << ISI_Y2R_SET0_C3_Pos)))
/* -------- ISI_Y2R_SET1 : (ISI Offset: 0x14) ISI CSC YCrCb To RGB Set 1 Register -------- */
#define ISI_Y2R_SET1_C4_Pos 0
#define ISI_Y2R_SET1_C4_Msk (0x1ffu << ISI_Y2R_SET1_C4_Pos) /**< \brief (ISI_Y2R_SET1) Color Space Conversion Matrix Coefficient C4 */
#define ISI_Y2R_SET1_C4(value) ((ISI_Y2R_SET1_C4_Msk & ((value) << ISI_Y2R_SET1_C4_Pos)))
#define ISI_Y2R_SET1_Yoff (0x1u << 12) /**< \brief (ISI_Y2R_SET1) Color Space Conversion Luminance Default Offset */
#define ISI_Y2R_SET1_Croff (0x1u << 13) /**< \brief (ISI_Y2R_SET1) Color Space Conversion Red Chrominance Default Offset */
#define ISI_Y2R_SET1_Cboff (0x1u << 14) /**< \brief (ISI_Y2R_SET1) Color Space Conversion Blue Chrominance Default Offset */
/* -------- ISI_R2Y_SET0 : (ISI Offset: 0x18) ISI CSC RGB To YCrCb Set 0 Register -------- */
#define ISI_R2Y_SET0_C0_Pos 0
#define ISI_R2Y_SET0_C0_Msk (0x7fu << ISI_R2Y_SET0_C0_Pos) /**< \brief (ISI_R2Y_SET0) Color Space Conversion Matrix Coefficient C0 */
#define ISI_R2Y_SET0_C0(value) ((ISI_R2Y_SET0_C0_Msk & ((value) << ISI_R2Y_SET0_C0_Pos)))
#define ISI_R2Y_SET0_C1_Pos 8
#define ISI_R2Y_SET0_C1_Msk (0x7fu << ISI_R2Y_SET0_C1_Pos) /**< \brief (ISI_R2Y_SET0) Color Space Conversion Matrix Coefficient C1 */
#define ISI_R2Y_SET0_C1(value) ((ISI_R2Y_SET0_C1_Msk & ((value) << ISI_R2Y_SET0_C1_Pos)))
#define ISI_R2Y_SET0_C2_Pos 16
#define ISI_R2Y_SET0_C2_Msk (0x7fu << ISI_R2Y_SET0_C2_Pos) /**< \brief (ISI_R2Y_SET0) Color Space Conversion Matrix Coefficient C2 */
#define ISI_R2Y_SET0_C2(value) ((ISI_R2Y_SET0_C2_Msk & ((value) << ISI_R2Y_SET0_C2_Pos)))
#define ISI_R2Y_SET0_Roff (0x1u << 24) /**< \brief (ISI_R2Y_SET0) Color Space Conversion Red Component Offset */
/* -------- ISI_R2Y_SET1 : (ISI Offset: 0x1C) ISI CSC RGB To YCrCb Set 1 Register -------- */
#define ISI_R2Y_SET1_C3_Pos 0
#define ISI_R2Y_SET1_C3_Msk (0x7fu << ISI_R2Y_SET1_C3_Pos) /**< \brief (ISI_R2Y_SET1) Color Space Conversion Matrix Coefficient C3 */
#define ISI_R2Y_SET1_C3(value) ((ISI_R2Y_SET1_C3_Msk & ((value) << ISI_R2Y_SET1_C3_Pos)))
#define ISI_R2Y_SET1_C4_Pos 8
#define ISI_R2Y_SET1_C4_Msk (0x7fu << ISI_R2Y_SET1_C4_Pos) /**< \brief (ISI_R2Y_SET1) Color Space Conversion Matrix Coefficient C4 */
#define ISI_R2Y_SET1_C4(value) ((ISI_R2Y_SET1_C4_Msk & ((value) << ISI_R2Y_SET1_C4_Pos)))
#define ISI_R2Y_SET1_C5_Pos 16
#define ISI_R2Y_SET1_C5_Msk (0x7fu << ISI_R2Y_SET1_C5_Pos) /**< \brief (ISI_R2Y_SET1) Color Space Conversion Matrix Coefficient C5 */
#define ISI_R2Y_SET1_C5(value) ((ISI_R2Y_SET1_C5_Msk & ((value) << ISI_R2Y_SET1_C5_Pos)))
#define ISI_R2Y_SET1_Goff (0x1u << 24) /**< \brief (ISI_R2Y_SET1) Color Space Conversion Green Component Offset */
/* -------- ISI_R2Y_SET2 : (ISI Offset: 0x20) ISI CSC RGB To YCrCb Set 2 Register -------- */
#define ISI_R2Y_SET2_C6_Pos 0
#define ISI_R2Y_SET2_C6_Msk (0x7fu << ISI_R2Y_SET2_C6_Pos) /**< \brief (ISI_R2Y_SET2) Color Space Conversion Matrix Coefficient C6 */
#define ISI_R2Y_SET2_C6(value) ((ISI_R2Y_SET2_C6_Msk & ((value) << ISI_R2Y_SET2_C6_Pos)))
#define ISI_R2Y_SET2_C7_Pos 8
#define ISI_R2Y_SET2_C7_Msk (0x7fu << ISI_R2Y_SET2_C7_Pos) /**< \brief (ISI_R2Y_SET2) Color Space Conversion Matrix Coefficient C7 */
#define ISI_R2Y_SET2_C7(value) ((ISI_R2Y_SET2_C7_Msk & ((value) << ISI_R2Y_SET2_C7_Pos)))
#define ISI_R2Y_SET2_C8_Pos 16
#define ISI_R2Y_SET2_C8_Msk (0x7fu << ISI_R2Y_SET2_C8_Pos) /**< \brief (ISI_R2Y_SET2) Color Space Conversion Matrix Coefficient C8 */
#define ISI_R2Y_SET2_C8(value) ((ISI_R2Y_SET2_C8_Msk & ((value) << ISI_R2Y_SET2_C8_Pos)))
#define ISI_R2Y_SET2_Boff (0x1u << 24) /**< \brief (ISI_R2Y_SET2) Color Space Conversion Blue Component Offset */
/* -------- ISI_CR : (ISI Offset: 0x24) ISI Control Register -------- */
#define ISI_CR_ISI_EN (0x1u << 0) /**< \brief (ISI_CR) ISI Module Enable Request */
#define ISI_CR_ISI_DIS (0x1u << 1) /**< \brief (ISI_CR) ISI Module Disable Request */
#define ISI_CR_ISI_SRST (0x1u << 2) /**< \brief (ISI_CR) ISI Software Reset Request */
#define ISI_CR_ISI_CDC (0x1u << 8) /**< \brief (ISI_CR) ISI Codec Request */
/* -------- ISI_SR : (ISI Offset: 0x28) ISI Status Register -------- */
#define ISI_SR_ENABLE (0x1u << 0) /**< \brief (ISI_SR)  */
#define ISI_SR_DIS_DONE (0x1u << 1) /**< \brief (ISI_SR) Module Disable Request has Terminated */
#define ISI_SR_SRST (0x1u << 2) /**< \brief (ISI_SR) Module Software Reset Request has Terminated */
#define ISI_SR_CDC_PND (0x1u << 8) /**< \brief (ISI_SR) Pending Codec Request (this bit is a status bit) */
#define ISI_SR_VSYNC (0x1u << 10) /**< \brief (ISI_SR) Vertical Synchronization */
#define ISI_SR_PXFR_DONE (0x1u << 16) /**< \brief (ISI_SR) Preview DMA Transfer has Terminated. */
#define ISI_SR_CXFR_DONE (0x1u << 17) /**< \brief (ISI_SR) Codec DMA Transfer has Terminated. */
#define ISI_SR_SIP (0x1u << 19) /**< \brief (ISI_SR) Synchronization in Progress (this is a status bit) */
#define ISI_SR_P_OVR (0x1u << 24) /**< \brief (ISI_SR) Preview Datapath Overflow */
#define ISI_SR_C_OVR (0x1u << 25) /**< \brief (ISI_SR) Codec Datapath Overflow */
#define ISI_SR_CRC_ERR (0x1u << 26) /**< \brief (ISI_SR) CRC Synchronization Error */
#define ISI_SR_FR_OVR (0x1u << 27) /**< \brief (ISI_SR) Frame Rate Overrun */
/* -------- ISI_IER : (ISI Offset: 0x2C) ISI Interrupt Enable Register -------- */
#define ISI_IER_DIS_DONE (0x1u << 1) /**< \brief (ISI_IER) Disable Done Interrupt Enable */
#define ISI_IER_SRST (0x1u << 2) /**< \brief (ISI_IER) Software Reset Interrupt Enable */
#define ISI_IER_VSYNC (0x1u << 10) /**< \brief (ISI_IER) Vertical Synchronization Interrupt Enable */
#define ISI_IER_PXFR_DONE (0x1u << 16) /**< \brief (ISI_IER) Preview DMA Transfer Done Interrupt Enable */
#define ISI_IER_CXFR_DONE (0x1u << 17) /**< \brief (ISI_IER) Codec DMA Transfer Done Interrupt Enable */
#define ISI_IER_P_OVR (0x1u << 24) /**< \brief (ISI_IER) Preview Datapath Overflow Interrupt Enable */
#define ISI_IER_C_OVR (0x1u << 25) /**< \brief (ISI_IER) Codec Datapath Overflow Interrupt Enable */
#define ISI_IER_CRC_ERR (0x1u << 26) /**< \brief (ISI_IER) Embedded Synchronization CRC Error Interrupt Enable */
#define ISI_IER_FR_OVR (0x1u << 27) /**< \brief (ISI_IER) Frame Rate Overflow Interrupt Enable */
/* -------- ISI_IDR : (ISI Offset: 0x30) ISI Interrupt Disable Register -------- */
#define ISI_IDR_DIS_DONE (0x1u << 1) /**< \brief (ISI_IDR) Disable Done Interrupt Disable */
#define ISI_IDR_SRST (0x1u << 2) /**< \brief (ISI_IDR) Software Reset Interrupt Disable */
#define ISI_IDR_VSYNC (0x1u << 10) /**< \brief (ISI_IDR) Vertical Synchronization Interrupt Disable */
#define ISI_IDR_PXFR_DONE (0x1u << 16) /**< \brief (ISI_IDR) Preview DMA Transfer Done Interrupt Disable */
#define ISI_IDR_CXFR_DONE (0x1u << 17) /**< \brief (ISI_IDR) Codec DMA Transfer Done Interrupt Disable */
#define ISI_IDR_P_OVR (0x1u << 24) /**< \brief (ISI_IDR) Preview Datapath Overflow Interrupt Disable */
#define ISI_IDR_C_OVR (0x1u << 25) /**< \brief (ISI_IDR) Codec Datapath Overflow Interrupt Disable */
#define ISI_IDR_CRC_ERR (0x1u << 26) /**< \brief (ISI_IDR) Embedded Synchronization CRC Error Interrupt Disable */
#define ISI_IDR_FR_OVR (0x1u << 27) /**< \brief (ISI_IDR) Frame Rate Overflow Interrupt Disable */
/* -------- ISI_IMR : (ISI Offset: 0x34) ISI Interrupt Mask Register -------- */
#define ISI_IMR_DIS_DONE (0x1u << 1) /**< \brief (ISI_IMR) Module Disable Operation Completed */
#define ISI_IMR_SRST (0x1u << 2) /**< \brief (ISI_IMR) Software Reset Completed */
#define ISI_IMR_VSYNC (0x1u << 10) /**< \brief (ISI_IMR) Vertical Synchronization */
#define ISI_IMR_PXFR_DONE (0x1u << 16) /**< \brief (ISI_IMR) Preview DMA Transfer Interrupt */
#define ISI_IMR_CXFR_DONE (0x1u << 17) /**< \brief (ISI_IMR) Codec DMA Transfer Interrupt */
#define ISI_IMR_P_OVR (0x1u << 24) /**< \brief (ISI_IMR) FIFO Preview Overflow */
#define ISI_IMR_C_OVR (0x1u << 25) /**< \brief (ISI_IMR) FIFO Codec Overflow */
#define ISI_IMR_CRC_ERR (0x1u << 26) /**< \brief (ISI_IMR) CRC Synchronization Error */
#define ISI_IMR_FR_OVR (0x1u << 27) /**< \brief (ISI_IMR) Frame Rate Overrun */
/* -------- ISI_DMA_CHER : (ISI Offset: 0x38) DMA Channel Enable Register -------- */
#define ISI_DMA_CHER_P_CH_EN (0x1u << 0) /**< \brief (ISI_DMA_CHER) Preview Channel Enable */
#define ISI_DMA_CHER_C_CH_EN (0x1u << 1) /**< \brief (ISI_DMA_CHER) Codec Channel Enable */
/* -------- ISI_DMA_CHDR : (ISI Offset: 0x3C) DMA Channel Disable Register -------- */
#define ISI_DMA_CHDR_P_CH_DIS (0x1u << 0) /**< \brief (ISI_DMA_CHDR)  */
#define ISI_DMA_CHDR_C_CH_DIS (0x1u << 1) /**< \brief (ISI_DMA_CHDR)  */
/* -------- ISI_DMA_CHSR : (ISI Offset: 0x40) DMA Channel Status Register -------- */
#define ISI_DMA_CHSR_P_CH_S (0x1u << 0) /**< \brief (ISI_DMA_CHSR)  */
#define ISI_DMA_CHSR_C_CH_S (0x1u << 1) /**< \brief (ISI_DMA_CHSR)  */
/* -------- ISI_DMA_P_ADDR : (ISI Offset: 0x44) DMA Preview Base Address Register -------- */
#define ISI_DMA_P_ADDR_P_ADDR_Pos 2
#define ISI_DMA_P_ADDR_P_ADDR_Msk (0x3fffffffu << ISI_DMA_P_ADDR_P_ADDR_Pos) /**< \brief (ISI_DMA_P_ADDR) Preview Image Base Address. (This address is word aligned.) */
#define ISI_DMA_P_ADDR_P_ADDR(value) ((ISI_DMA_P_ADDR_P_ADDR_Msk & ((value) << ISI_DMA_P_ADDR_P_ADDR_Pos)))
/* -------- ISI_DMA_P_CTRL : (ISI Offset: 0x48) DMA Preview Control Register -------- */
#define ISI_DMA_P_CTRL_P_FETCH (0x1u << 0) /**< \brief (ISI_DMA_P_CTRL) Descriptor Fetch Control Field */
#define ISI_DMA_P_CTRL_P_WB (0x1u << 1) /**< \brief (ISI_DMA_P_CTRL) Descriptor Writeback Control Field */
#define ISI_DMA_P_CTRL_P_IEN (0x1u << 2) /**< \brief (ISI_DMA_P_CTRL) Transfer Done Flag Control */
#define ISI_DMA_P_CTRL_P_DONE (0x1u << 3) /**< \brief (ISI_DMA_P_CTRL) (This field is only updated in the memory.) */
/* -------- ISI_DMA_P_DSCR : (ISI Offset: 0x4C) DMA Preview Descriptor Address Register -------- */
#define ISI_DMA_P_DSCR_P_DSCR_Pos 2
#define ISI_DMA_P_DSCR_P_DSCR_Msk (0x3fffffffu << ISI_DMA_P_DSCR_P_DSCR_Pos) /**< \brief (ISI_DMA_P_DSCR) Preview Descriptor Base Address (This address is word aligned.) */
#define ISI_DMA_P_DSCR_P_DSCR(value) ((ISI_DMA_P_DSCR_P_DSCR_Msk & ((value) << ISI_DMA_P_DSCR_P_DSCR_Pos)))
/* -------- ISI_DMA_C_ADDR : (ISI Offset: 0x50) DMA Codec Base Address Register -------- */
#define ISI_DMA_C_ADDR_C_ADDR_Pos 2
#define ISI_DMA_C_ADDR_C_ADDR_Msk (0x3fffffffu << ISI_DMA_C_ADDR_C_ADDR_Pos) /**< \brief (ISI_DMA_C_ADDR) Codec Image Base Address (This address is word aligned.) */
#define ISI_DMA_C_ADDR_C_ADDR(value) ((ISI_DMA_C_ADDR_C_ADDR_Msk & ((value) << ISI_DMA_C_ADDR_C_ADDR_Pos)))
/* -------- ISI_DMA_C_CTRL : (ISI Offset: 0x54) DMA Codec Control Register -------- */
#define ISI_DMA_C_CTRL_C_FETCH (0x1u << 0) /**< \brief (ISI_DMA_C_CTRL) Descriptor Fetch Control Field */
#define ISI_DMA_C_CTRL_C_WB (0x1u << 1) /**< \brief (ISI_DMA_C_CTRL) Descriptor Writeback Control Field */
#define ISI_DMA_C_CTRL_C_IEN (0x1u << 2) /**< \brief (ISI_DMA_C_CTRL) Transfer Done flag control */
#define ISI_DMA_C_CTRL_C_DONE (0x1u << 3) /**< \brief (ISI_DMA_C_CTRL) (This field is only updated in the memory.) */
/* -------- ISI_DMA_C_DSCR : (ISI Offset: 0x58) DMA Codec Descriptor Address Register -------- */
#define ISI_DMA_C_DSCR_C_DSCR_Pos 2
#define ISI_DMA_C_DSCR_C_DSCR_Msk (0x3fffffffu << ISI_DMA_C_DSCR_C_DSCR_Pos) /**< \brief (ISI_DMA_C_DSCR) Codec Descriptor Base Address (This address is word aligned.) */
#define ISI_DMA_C_DSCR_C_DSCR(value) ((ISI_DMA_C_DSCR_C_DSCR_Msk & ((value) << ISI_DMA_C_DSCR_C_DSCR_Pos)))
/* -------- ISI_WPCR : (ISI Offset: 0xE4) Write Protection Control Register -------- */
#define ISI_WPCR_WP_EN (0x1u << 0) /**< \brief (ISI_WPCR) Write Protection Enable */
#define ISI_WPCR_WP_KEY_Pos 8
#define ISI_WPCR_WP_KEY_Msk (0xffffffu << ISI_WPCR_WP_KEY_Pos) /**< \brief (ISI_WPCR) Write Protection KEY Password */
#define ISI_WPCR_WP_KEY(value) ((ISI_WPCR_WP_KEY_Msk & ((value) << ISI_WPCR_WP_KEY_Pos)))
/* -------- ISI_WPSR : (ISI Offset: 0xE8) Write Protection Status Register -------- */
#define ISI_WPSR_WP_VS_Pos 0
#define ISI_WPSR_WP_VS_Msk (0xfu << ISI_WPSR_WP_VS_Pos) /**< \brief (ISI_WPSR) Write Protection Violation Status */
#define ISI_WPSR_WP_VSRC_Pos 8
#define ISI_WPSR_WP_VSRC_Msk (0xffffu << ISI_WPSR_WP_VSRC_Pos) /**< \brief (ISI_WPSR) Write Protection Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR L2 Cache Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_L2CC L2 Cache Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief L2cc hardware registers */
typedef struct {
  __I  uint32_t L2CC_IDR;        /**< \brief (L2cc Offset: 0x000) Cache ID Register */
  __I  uint32_t L2CC_TYPR;       /**< \brief (L2cc Offset: 0x004) Cache Type Register */
  __I  uint32_t Reserved1[62];
  __IO uint32_t L2CC_CR;         /**< \brief (L2cc Offset: 0x100) Control Register */
  __IO uint32_t L2CC_ACR;        /**< \brief (L2cc Offset: 0x104) Auxiliary Control Register */
  __IO uint32_t L2CC_TRCR;       /**< \brief (L2cc Offset: 0x108) Tag RAM Control Register */
  __IO uint32_t L2CC_DRCR;       /**< \brief (L2cc Offset: 0x10C) Data RAM Control Register */
  __I  uint32_t Reserved2[60];
  __IO uint32_t L2CC_ECR;        /**< \brief (L2cc Offset: 0x200) Event Counter Control Register */
  __IO uint32_t L2CC_ECFGR1;     /**< \brief (L2cc Offset: 0x204) Event Counter 1 Configuration Register */
  __IO uint32_t L2CC_ECFGR0;     /**< \brief (L2cc Offset: 0x208) Event Counter 0 Configuration Register */
  __IO uint32_t L2CC_EVR1;       /**< \brief (L2cc Offset: 0x20C) Event Counter 1 Value Register */
  __IO uint32_t L2CC_EVR0;       /**< \brief (L2cc Offset: 0x210) Event Counter 0 Value Register */
  __IO uint32_t L2CC_IMR;        /**< \brief (L2cc Offset: 0x214) Interrupt Mask Register */
  __I  uint32_t L2CC_MISR;       /**< \brief (L2cc Offset: 0x218) Masked Interrupt Status Register */
  __I  uint32_t L2CC_RISR;       /**< \brief (L2cc Offset: 0x21C) Raw Interrupt Status Register */
  __IO uint32_t L2CC_ICR;        /**< \brief (L2cc Offset: 0x220) Interrupt Clear Register */
  __I  uint32_t Reserved3[323];
  __IO uint32_t L2CC_CSR;        /**< \brief (L2cc Offset: 0x730) Cache Synchronization Register */
  __I  uint32_t Reserved4[15];
  __IO uint32_t L2CC_IPALR;      /**< \brief (L2cc Offset: 0x770) Invalidate Physical Address Line Register */
  __I  uint32_t Reserved5[2];
  __IO uint32_t L2CC_IWR;        /**< \brief (L2cc Offset: 0x77C) Invalidate Way Register */
  __I  uint32_t Reserved6[12];
  __IO uint32_t L2CC_CPALR;      /**< \brief (L2cc Offset: 0x7B0) Clean Physical Address Line Register */
  __I  uint32_t Reserved7[1];
  __IO uint32_t L2CC_CIR;        /**< \brief (L2cc Offset: 0x7B8) Clean Index Register */
  __IO uint32_t L2CC_CWR;        /**< \brief (L2cc Offset: 0x7BC) Clean Way Register */
  __I  uint32_t Reserved8[12];
  __IO uint32_t L2CC_CIPALR;     /**< \brief (L2cc Offset: 0x7F0) Clean Invalidate Physical Address Line Register */
  __I  uint32_t Reserved9[1];
  __IO uint32_t L2CC_CIIR;       /**< \brief (L2cc Offset: 0x7F8) Clean Invalidate Index Register */
  __IO uint32_t L2CC_CIWR;       /**< \brief (L2cc Offset: 0x7FC) Clean Invalidate Way Register */
  __I  uint32_t Reserved10[64];
  __IO uint32_t L2CC_DLKR;       /**< \brief (L2cc Offset: 0x900) Data Lockdown Register */
  __IO uint32_t L2CC_ILKR;       /**< \brief (L2cc Offset: 0x904) Instruction Lockdown Register */
  __I  uint32_t Reserved11[398];
  __IO uint32_t L2CC_DCR;        /**< \brief (L2cc Offset: 0xF40) Debug Control Register */
  __I  uint32_t Reserved12[7];
  __IO uint32_t L2CC_PCR;        /**< \brief (L2cc Offset: 0xF60) Prefetch Control Register */
  __I  uint32_t Reserved13[7];
  __IO uint32_t L2CC_POWCR;      /**< \brief (L2cc Offset: 0xF80) Power Control Register */
} L2cc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- L2CC_IDR : (L2CC Offset: 0x000) Cache ID Register -------- */
#define L2CC_IDR_ID_Pos 0
#define L2CC_IDR_ID_Msk (0xffffffffu << L2CC_IDR_ID_Pos) /**< \brief (L2CC_IDR) Cache Controller ID */
/* -------- L2CC_TYPR : (L2CC Offset: 0x004) Cache Type Register -------- */
#define L2CC_TYPR_IL2ASS (0x1u << 6) /**< \brief (L2CC_TYPR) Instruction L2 Cache associativity */
#define L2CC_TYPR_IL2WSIZE_Pos 8
#define L2CC_TYPR_IL2WSIZE_Msk (0x7u << L2CC_TYPR_IL2WSIZE_Pos) /**< \brief (L2CC_TYPR) Instruction L2 Cache way size */
#define L2CC_TYPR_DL2ASS (0x1u << 18) /**< \brief (L2CC_TYPR) Data L2 Cache associativity */
#define L2CC_TYPR_DL2WSIZE_Pos 20
#define L2CC_TYPR_DL2WSIZE_Msk (0x7u << L2CC_TYPR_DL2WSIZE_Pos) /**< \brief (L2CC_TYPR) Data L2 Cache way size */
/* -------- L2CC_CR : (L2CC Offset: 0x100) Control Register -------- */
#define L2CC_CR_L2CEN (0x1u << 0) /**< \brief (L2CC_CR) L2 Cache Enable */
/* -------- L2CC_ACR : (L2CC Offset: 0x104) Auxiliary Control Register -------- */
#define L2CC_ACR_HPSO (0x1u << 10) /**< \brief (L2CC_ACR) High Priority for SO and Dev Reads Enable */
#define L2CC_ACR_SBDLE (0x1u << 11) /**< \brief (L2CC_ACR) Store Buffer Device Limitation Enable */
#define L2CC_ACR_EXCC (0x1u << 12) /**< \brief (L2CC_ACR) Exclusive Cache Configuration */
#define L2CC_ACR_SAIE (0x1u << 13) /**< \brief (L2CC_ACR) Shared Attribute Invalidate Enable */
#define L2CC_ACR_ASS (0x1u << 16) /**< \brief (L2CC_ACR) Associativity */
#define L2CC_ACR_WAYSIZE_Pos 17
#define L2CC_ACR_WAYSIZE_Msk (0x7u << L2CC_ACR_WAYSIZE_Pos) /**< \brief (L2CC_ACR) Way Size */
#define   L2CC_ACR_WAYSIZE_16KB_WAY (0x1u << 17) /**< \brief (L2CC_ACR) 16 Kbyte way set associative */
#define L2CC_ACR_EMBEN (0x1u << 20) /**< \brief (L2CC_ACR) Event Monitor Bus Enable */
#define L2CC_ACR_PEN (0x1u << 21) /**< \brief (L2CC_ACR) Parity Enable */
#define L2CC_ACR_SAOEN (0x1u << 22) /**< \brief (L2CC_ACR) Shared Attribute Override Enable */
#define L2CC_ACR_FWA_Pos 23
#define L2CC_ACR_FWA_Msk (0x3u << L2CC_ACR_FWA_Pos) /**< \brief (L2CC_ACR) Force Write Allocate */
#define L2CC_ACR_FWA(value) ((L2CC_ACR_FWA_Msk & ((value) << L2CC_ACR_FWA_Pos)))
#define L2CC_ACR_CRPOL (0x1u << 25) /**< \brief (L2CC_ACR) Cache Replacement Policy */
#define L2CC_ACR_NSLEN (0x1u << 26) /**< \brief (L2CC_ACR) Non-Secure Lockdown Enable */
#define L2CC_ACR_NSIAC (0x1u << 27) /**< \brief (L2CC_ACR) Non-Secure Interrupt Access Control */
#define L2CC_ACR_DPEN (0x1u << 28) /**< \brief (L2CC_ACR) Data Prefetch Enable */
#define L2CC_ACR_IPEN (0x1u << 29) /**< \brief (L2CC_ACR) Instruction Prefetch Enable */
/* -------- L2CC_TRCR : (L2CC Offset: 0x108) Tag RAM Control Register -------- */
#define L2CC_TRCR_TSETLAT_Pos 0
#define L2CC_TRCR_TSETLAT_Msk (0x7u << L2CC_TRCR_TSETLAT_Pos) /**< \brief (L2CC_TRCR) Setup Latency */
#define L2CC_TRCR_TSETLAT(value) ((L2CC_TRCR_TSETLAT_Msk & ((value) << L2CC_TRCR_TSETLAT_Pos)))
#define L2CC_TRCR_TRDLAT_Pos 4
#define L2CC_TRCR_TRDLAT_Msk (0x7u << L2CC_TRCR_TRDLAT_Pos) /**< \brief (L2CC_TRCR) Read Access Latency */
#define L2CC_TRCR_TRDLAT(value) ((L2CC_TRCR_TRDLAT_Msk & ((value) << L2CC_TRCR_TRDLAT_Pos)))
#define L2CC_TRCR_TWRLAT_Pos 8
#define L2CC_TRCR_TWRLAT_Msk (0x7u << L2CC_TRCR_TWRLAT_Pos) /**< \brief (L2CC_TRCR) Write Access Latency */
#define L2CC_TRCR_TWRLAT(value) ((L2CC_TRCR_TWRLAT_Msk & ((value) << L2CC_TRCR_TWRLAT_Pos)))
/* -------- L2CC_DRCR : (L2CC Offset: 0x10C) Data RAM Control Register -------- */
#define L2CC_DRCR_DSETLAT_Pos 0
#define L2CC_DRCR_DSETLAT_Msk (0x7u << L2CC_DRCR_DSETLAT_Pos) /**< \brief (L2CC_DRCR) Setup Latency */
#define L2CC_DRCR_DSETLAT(value) ((L2CC_DRCR_DSETLAT_Msk & ((value) << L2CC_DRCR_DSETLAT_Pos)))
#define L2CC_DRCR_DRDLAT_Pos 4
#define L2CC_DRCR_DRDLAT_Msk (0x7u << L2CC_DRCR_DRDLAT_Pos) /**< \brief (L2CC_DRCR) Read Access Latency */
#define L2CC_DRCR_DRDLAT(value) ((L2CC_DRCR_DRDLAT_Msk & ((value) << L2CC_DRCR_DRDLAT_Pos)))
#define L2CC_DRCR_DWRLAT_Pos 8
#define L2CC_DRCR_DWRLAT_Msk (0x7u << L2CC_DRCR_DWRLAT_Pos) /**< \brief (L2CC_DRCR) Write Access Latency */
#define L2CC_DRCR_DWRLAT(value) ((L2CC_DRCR_DWRLAT_Msk & ((value) << L2CC_DRCR_DWRLAT_Pos)))
/* -------- L2CC_ECR : (L2CC Offset: 0x200) Event Counter Control Register -------- */
#define L2CC_ECR_EVCEN (0x1u << 0) /**< \brief (L2CC_ECR) Event Counter Enable */
#define L2CC_ECR_EVC0RST (0x1u << 1) /**< \brief (L2CC_ECR) Event Counter 0 Reset */
#define L2CC_ECR_EVC1RST (0x1u << 2) /**< \brief (L2CC_ECR) Event Counter 1 Reset */
/* -------- L2CC_ECFGR1 : (L2CC Offset: 0x204) Event Counter 1 Configuration Register -------- */
#define L2CC_ECFGR1_EIGEN_Pos 0
#define L2CC_ECFGR1_EIGEN_Msk (0x3u << L2CC_ECFGR1_EIGEN_Pos) /**< \brief (L2CC_ECFGR1) Event Counter Interrupt Generation */
#define   L2CC_ECFGR1_EIGEN_INT_DIS (0x0u << 0) /**< \brief (L2CC_ECFGR1) Disables (default) */
#define   L2CC_ECFGR1_EIGEN_INT_EN_INCR (0x1u << 0) /**< \brief (L2CC_ECFGR1) Enables with Increment condition */
#define   L2CC_ECFGR1_EIGEN_INT_EN_OVER (0x2u << 0) /**< \brief (L2CC_ECFGR1) Enables with Overflow condition */
#define   L2CC_ECFGR1_EIGEN_INT_GEN_DIS (0x3u << 0) /**< \brief (L2CC_ECFGR1) Disables Interrupt generation */
#define L2CC_ECFGR1_ESRC_Pos 2
#define L2CC_ECFGR1_ESRC_Msk (0xfu << L2CC_ECFGR1_ESRC_Pos) /**< \brief (L2CC_ECFGR1) Event Counter Source */
#define   L2CC_ECFGR1_ESRC_CNT_DIS (0x0u << 2) /**< \brief (L2CC_ECFGR1) Counter Disabled */
#define   L2CC_ECFGR1_ESRC_SRC_CO (0x1u << 2) /**< \brief (L2CC_ECFGR1) Source is CO */
#define   L2CC_ECFGR1_ESRC_SRC_DRHIT (0x2u << 2) /**< \brief (L2CC_ECFGR1) Source is DRHIT */
#define   L2CC_ECFGR1_ESRC_SRC_DRREQ (0x3u << 2) /**< \brief (L2CC_ECFGR1) Source is DRREQ */
#define   L2CC_ECFGR1_ESRC_SRC_DWHIT (0x4u << 2) /**< \brief (L2CC_ECFGR1) Source is DWHIT */
#define   L2CC_ECFGR1_ESRC_SRC_DWREQ (0x5u << 2) /**< \brief (L2CC_ECFGR1) Source is DWREQ */
#define   L2CC_ECFGR1_ESRC_SRC_DWTREQ (0x6u << 2) /**< \brief (L2CC_ECFGR1) Source is DWTREQ */
#define   L2CC_ECFGR1_ESRC_SRC_IRHIT (0x7u << 2) /**< \brief (L2CC_ECFGR1) Source is IRHIT */
#define   L2CC_ECFGR1_ESRC_SRC_IRREQ (0x8u << 2) /**< \brief (L2CC_ECFGR1) Source is IRREQ */
#define   L2CC_ECFGR1_ESRC_SRC_WA (0x9u << 2) /**< \brief (L2CC_ECFGR1) Source is WA */
#define   L2CC_ECFGR1_ESRC_SRC_IPFALLOC (0xAu << 2) /**< \brief (L2CC_ECFGR1) Source is IPFALLOC */
#define   L2CC_ECFGR1_ESRC_SRC_EPFHIT (0xBu << 2) /**< \brief (L2CC_ECFGR1) Source is EPFHIT */
#define   L2CC_ECFGR1_ESRC_SRC_EPFALLOC (0xCu << 2) /**< \brief (L2CC_ECFGR1) Source is EPFALLOC */
#define   L2CC_ECFGR1_ESRC_SRC_SRRCVD (0xDu << 2) /**< \brief (L2CC_ECFGR1) Source is SRRCVD */
#define   L2CC_ECFGR1_ESRC_SRC_SRCONF (0xEu << 2) /**< \brief (L2CC_ECFGR1) Source is SRCONF */
#define   L2CC_ECFGR1_ESRC_SRC_EPFRCVD (0xFu << 2) /**< \brief (L2CC_ECFGR1) Source is EPFRCVD */
/* -------- L2CC_ECFGR0 : (L2CC Offset: 0x208) Event Counter 0 Configuration Register -------- */
#define L2CC_ECFGR0_EIGEN_Pos 0
#define L2CC_ECFGR0_EIGEN_Msk (0x3u << L2CC_ECFGR0_EIGEN_Pos) /**< \brief (L2CC_ECFGR0) Event Counter Interrupt Generation */
#define   L2CC_ECFGR0_EIGEN_INT_DIS (0x0u << 0) /**< \brief (L2CC_ECFGR0) Disables (default) */
#define   L2CC_ECFGR0_EIGEN_INT_EN_INCR (0x1u << 0) /**< \brief (L2CC_ECFGR0) Enables with Increment condition */
#define   L2CC_ECFGR0_EIGEN_INT_EN_OVER (0x2u << 0) /**< \brief (L2CC_ECFGR0) Enables with Overflow condition */
#define   L2CC_ECFGR0_EIGEN_INT_GEN_DIS (0x3u << 0) /**< \brief (L2CC_ECFGR0) Disables Interrupt generation */
#define L2CC_ECFGR0_ESRC_Pos 2
#define L2CC_ECFGR0_ESRC_Msk (0xfu << L2CC_ECFGR0_ESRC_Pos) /**< \brief (L2CC_ECFGR0) Event Counter Source */
#define   L2CC_ECFGR0_ESRC_CNT_DIS (0x0u << 2) /**< \brief (L2CC_ECFGR0) Counter Disabled */
#define   L2CC_ECFGR0_ESRC_SRC_CO (0x1u << 2) /**< \brief (L2CC_ECFGR0) Source is CO */
#define   L2CC_ECFGR0_ESRC_SRC_DRHIT (0x2u << 2) /**< \brief (L2CC_ECFGR0) Source is DRHIT */
#define   L2CC_ECFGR0_ESRC_SRC_DRREQ (0x3u << 2) /**< \brief (L2CC_ECFGR0) Source is DRREQ */
#define   L2CC_ECFGR0_ESRC_SRC_DWHIT (0x4u << 2) /**< \brief (L2CC_ECFGR0) Source is DWHIT */
#define   L2CC_ECFGR0_ESRC_SRC_DWREQ (0x5u << 2) /**< \brief (L2CC_ECFGR0) Source is DWREQ */
#define   L2CC_ECFGR0_ESRC_SRC_DWTREQ (0x6u << 2) /**< \brief (L2CC_ECFGR0) Source is DWTREQ */
#define   L2CC_ECFGR0_ESRC_SRC_IRHIT (0x7u << 2) /**< \brief (L2CC_ECFGR0) Source is IRHIT */
#define   L2CC_ECFGR0_ESRC_SRC_IRREQ (0x8u << 2) /**< \brief (L2CC_ECFGR0) Source is IRREQ */
#define   L2CC_ECFGR0_ESRC_SRC_WA (0x9u << 2) /**< \brief (L2CC_ECFGR0) Source is WA */
#define   L2CC_ECFGR0_ESRC_SRC_IPFALLOC (0xAu << 2) /**< \brief (L2CC_ECFGR0) Source is IPFALLOC */
#define   L2CC_ECFGR0_ESRC_SRC_EPFHIT (0xBu << 2) /**< \brief (L2CC_ECFGR0) Source is EPFHIT */
#define   L2CC_ECFGR0_ESRC_SRC_EPFALLOC (0xCu << 2) /**< \brief (L2CC_ECFGR0) Source is EPFALLOC */
#define   L2CC_ECFGR0_ESRC_SRC_SRRCVD (0xDu << 2) /**< \brief (L2CC_ECFGR0) Source is SRRCVD */
#define   L2CC_ECFGR0_ESRC_SRC_SRCONF (0xEu << 2) /**< \brief (L2CC_ECFGR0) Source is SRCONF */
#define   L2CC_ECFGR0_ESRC_SRC_EPFRCVD (0xFu << 2) /**< \brief (L2CC_ECFGR0) Source is EPFRCVD */
/* -------- L2CC_EVR1 : (L2CC Offset: 0x20C) Event Counter 1 Value Register -------- */
#define L2CC_EVR1_VALUE_Pos 0
#define L2CC_EVR1_VALUE_Msk (0xffffffffu << L2CC_EVR1_VALUE_Pos) /**< \brief (L2CC_EVR1) Event Counter Value */
#define L2CC_EVR1_VALUE(value) ((L2CC_EVR1_VALUE_Msk & ((value) << L2CC_EVR1_VALUE_Pos)))
/* -------- L2CC_EVR0 : (L2CC Offset: 0x210) Event Counter 0 Value Register -------- */
#define L2CC_EVR0_VALUE_Pos 0
#define L2CC_EVR0_VALUE_Msk (0xffffffffu << L2CC_EVR0_VALUE_Pos) /**< \brief (L2CC_EVR0) Event Counter Value */
#define L2CC_EVR0_VALUE(value) ((L2CC_EVR0_VALUE_Msk & ((value) << L2CC_EVR0_VALUE_Pos)))
/* -------- L2CC_IMR : (L2CC Offset: 0x214) Interrupt Mask Register -------- */
#define L2CC_IMR_ECNTR (0x1u << 0) /**< \brief (L2CC_IMR) Event Counter 1/0 Overflow Increment */
#define L2CC_IMR_PARRT (0x1u << 1) /**< \brief (L2CC_IMR) Parity Error on L2 Tag RAM, Read */
#define L2CC_IMR_PARRD (0x1u << 2) /**< \brief (L2CC_IMR) Parity Error on L2 Data RAM, Read */
#define L2CC_IMR_ERRWT (0x1u << 3) /**< \brief (L2CC_IMR) Error on L2 Tag RAM, Write */
#define L2CC_IMR_ERRWD (0x1u << 4) /**< \brief (L2CC_IMR) Error on L2 Data RAM, Write */
#define L2CC_IMR_ERRRT (0x1u << 5) /**< \brief (L2CC_IMR) Error on L2 Tag RAM, Read */
#define L2CC_IMR_ERRRD (0x1u << 6) /**< \brief (L2CC_IMR) Error on L2 Data RAM, Read */
#define L2CC_IMR_SLVERR (0x1u << 7) /**< \brief (L2CC_IMR) SLVERR from L3 memory */
#define L2CC_IMR_DECERR (0x1u << 8) /**< \brief (L2CC_IMR) DECERR from L3 memory */
/* -------- L2CC_MISR : (L2CC Offset: 0x218) Masked Interrupt Status Register -------- */
#define L2CC_MISR_ECNTR (0x1u << 0) /**< \brief (L2CC_MISR) Event Counter 1/0 Overflow Increment */
#define L2CC_MISR_PARRT (0x1u << 1) /**< \brief (L2CC_MISR) Parity Error on L2 Tag RAM, Read */
#define L2CC_MISR_PARRD (0x1u << 2) /**< \brief (L2CC_MISR) Parity Error on L2 Data RAM, Read */
#define L2CC_MISR_ERRWT (0x1u << 3) /**< \brief (L2CC_MISR) Error on L2 Tag RAM, Write */
#define L2CC_MISR_ERRWD (0x1u << 4) /**< \brief (L2CC_MISR) Error on L2 Data RAM, Write */
#define L2CC_MISR_ERRRT (0x1u << 5) /**< \brief (L2CC_MISR) Error on L2 Tag RAM, Read */
#define L2CC_MISR_ERRRD (0x1u << 6) /**< \brief (L2CC_MISR) Error on L2 Data RAM, Read */
#define L2CC_MISR_SLVERR (0x1u << 7) /**< \brief (L2CC_MISR) SLVERR from L3 memory */
#define L2CC_MISR_DECERR (0x1u << 8) /**< \brief (L2CC_MISR) DECERR from L3 memory */
/* -------- L2CC_RISR : (L2CC Offset: 0x21C) Raw Interrupt Status Register -------- */
#define L2CC_RISR_ECNTR (0x1u << 0) /**< \brief (L2CC_RISR) Event Counter 1/0 Overflow Increment */
#define L2CC_RISR_PARRT (0x1u << 1) /**< \brief (L2CC_RISR) Parity Error on L2 Tag RAM, Read */
#define L2CC_RISR_PARRD (0x1u << 2) /**< \brief (L2CC_RISR) Parity Error on L2 Data RAM, Read */
#define L2CC_RISR_ERRWT (0x1u << 3) /**< \brief (L2CC_RISR) Error on L2 Tag RAM, Write */
#define L2CC_RISR_ERRWD (0x1u << 4) /**< \brief (L2CC_RISR) Error on L2 Data RAM, Write */
#define L2CC_RISR_ERRRT (0x1u << 5) /**< \brief (L2CC_RISR) Error on L2 Tag RAM, Read */
#define L2CC_RISR_ERRRD (0x1u << 6) /**< \brief (L2CC_RISR) Error on L2 Data RAM, Read */
#define L2CC_RISR_SLVERR (0x1u << 7) /**< \brief (L2CC_RISR) SLVERR from L3 memory */
#define L2CC_RISR_DECERR (0x1u << 8) /**< \brief (L2CC_RISR) DECERR from L3 memory */
/* -------- L2CC_ICR : (L2CC Offset: 0x220) Interrupt Clear Register -------- */
#define L2CC_ICR_ECNTR (0x1u << 0) /**< \brief (L2CC_ICR) Event Counter 1/0 Overflow Increment */
#define L2CC_ICR_PARRT (0x1u << 1) /**< \brief (L2CC_ICR) Parity Error on L2 Tag RAM, Read */
#define L2CC_ICR_PARRD (0x1u << 2) /**< \brief (L2CC_ICR) Parity Error on L2 Data RAM, Read */
#define L2CC_ICR_ERRWT (0x1u << 3) /**< \brief (L2CC_ICR) Error on L2 Tag RAM, Write */
#define L2CC_ICR_ERRWD (0x1u << 4) /**< \brief (L2CC_ICR) Error on L2 Data RAM, Write */
#define L2CC_ICR_ERRRT (0x1u << 5) /**< \brief (L2CC_ICR) Error on L2 Tag RAM, Read */
#define L2CC_ICR_ERRRD (0x1u << 6) /**< \brief (L2CC_ICR) Error on L2 Data RAM, Read */
#define L2CC_ICR_SLVERR (0x1u << 7) /**< \brief (L2CC_ICR) SLVERR from L3 memory */
#define L2CC_ICR_DECERR (0x1u << 8) /**< \brief (L2CC_ICR) DECERR from L3 memory */
/* -------- L2CC_CSR : (L2CC Offset: 0x730) Cache Synchronization Register -------- */
#define L2CC_CSR_C (0x1u << 0) /**< \brief (L2CC_CSR) Cache Synchronization Status */
/* -------- L2CC_IPALR : (L2CC Offset: 0x770) Invalidate Physical Address Line Register -------- */
#define L2CC_IPALR_C (0x1u << 0) /**< \brief (L2CC_IPALR) Cache Synchronization Status */
#define L2CC_IPALR_IDX_Pos 5
#define L2CC_IPALR_IDX_Msk (0x1ffu << L2CC_IPALR_IDX_Pos) /**< \brief (L2CC_IPALR) Index Number */
#define L2CC_IPALR_IDX(value) ((L2CC_IPALR_IDX_Msk & ((value) << L2CC_IPALR_IDX_Pos)))
#define L2CC_IPALR_TAG_Pos 14
#define L2CC_IPALR_TAG_Msk (0x3ffffu << L2CC_IPALR_TAG_Pos) /**< \brief (L2CC_IPALR) Tag Number */
#define L2CC_IPALR_TAG(value) ((L2CC_IPALR_TAG_Msk & ((value) << L2CC_IPALR_TAG_Pos)))
/* -------- L2CC_IWR : (L2CC Offset: 0x77C) Invalidate Way Register -------- */
#define L2CC_IWR_WAY0 (0x1u << 0) /**< \brief (L2CC_IWR) Invalidate Way Number 0 */
#define L2CC_IWR_WAY1 (0x1u << 1) /**< \brief (L2CC_IWR) Invalidate Way Number 1 */
#define L2CC_IWR_WAY2 (0x1u << 2) /**< \brief (L2CC_IWR) Invalidate Way Number 2 */
#define L2CC_IWR_WAY3 (0x1u << 3) /**< \brief (L2CC_IWR) Invalidate Way Number 3 */
#define L2CC_IWR_WAY4 (0x1u << 4) /**< \brief (L2CC_IWR) Invalidate Way Number 4 */
#define L2CC_IWR_WAY5 (0x1u << 5) /**< \brief (L2CC_IWR) Invalidate Way Number 5 */
#define L2CC_IWR_WAY6 (0x1u << 6) /**< \brief (L2CC_IWR) Invalidate Way Number 6 */
#define L2CC_IWR_WAY7 (0x1u << 7) /**< \brief (L2CC_IWR) Invalidate Way Number 7 */
/* -------- L2CC_CPALR : (L2CC Offset: 0x7B0) Clean Physical Address Line Register -------- */
#define L2CC_CPALR_C (0x1u << 0) /**< \brief (L2CC_CPALR) Cache Synchronization Status */
#define L2CC_CPALR_IDX_Pos 5
#define L2CC_CPALR_IDX_Msk (0x1ffu << L2CC_CPALR_IDX_Pos) /**< \brief (L2CC_CPALR) Index number */
#define L2CC_CPALR_IDX(value) ((L2CC_CPALR_IDX_Msk & ((value) << L2CC_CPALR_IDX_Pos)))
#define L2CC_CPALR_TAG_Pos 14
#define L2CC_CPALR_TAG_Msk (0x3ffffu << L2CC_CPALR_TAG_Pos) /**< \brief (L2CC_CPALR) Tag number */
#define L2CC_CPALR_TAG(value) ((L2CC_CPALR_TAG_Msk & ((value) << L2CC_CPALR_TAG_Pos)))
/* -------- L2CC_CIR : (L2CC Offset: 0x7B8) Clean Index Register -------- */
#define L2CC_CIR_C (0x1u << 0) /**< \brief (L2CC_CIR) Cache Synchronization Status */
#define L2CC_CIR_IDX_Pos 5
#define L2CC_CIR_IDX_Msk (0x1ffu << L2CC_CIR_IDX_Pos) /**< \brief (L2CC_CIR) Index number */
#define L2CC_CIR_IDX(value) ((L2CC_CIR_IDX_Msk & ((value) << L2CC_CIR_IDX_Pos)))
#define L2CC_CIR_WAY_Pos 28
#define L2CC_CIR_WAY_Msk (0x7u << L2CC_CIR_WAY_Pos) /**< \brief (L2CC_CIR) Way number */
#define L2CC_CIR_WAY(value) ((L2CC_CIR_WAY_Msk & ((value) << L2CC_CIR_WAY_Pos)))
/* -------- L2CC_CWR : (L2CC Offset: 0x7BC) Clean Way Register -------- */
#define L2CC_CWR_WAY0 (0x1u << 0) /**< \brief (L2CC_CWR) Clean Way Number 0 */
#define L2CC_CWR_WAY1 (0x1u << 1) /**< \brief (L2CC_CWR) Clean Way Number 1 */
#define L2CC_CWR_WAY2 (0x1u << 2) /**< \brief (L2CC_CWR) Clean Way Number 2 */
#define L2CC_CWR_WAY3 (0x1u << 3) /**< \brief (L2CC_CWR) Clean Way Number 3 */
#define L2CC_CWR_WAY4 (0x1u << 4) /**< \brief (L2CC_CWR) Clean Way Number 4 */
#define L2CC_CWR_WAY5 (0x1u << 5) /**< \brief (L2CC_CWR) Clean Way Number 5 */
#define L2CC_CWR_WAY6 (0x1u << 6) /**< \brief (L2CC_CWR) Clean Way Number 6 */
#define L2CC_CWR_WAY7 (0x1u << 7) /**< \brief (L2CC_CWR) Clean Way Number 7 */
/* -------- L2CC_CIPALR : (L2CC Offset: 0x7F0) Clean Invalidate Physical Address Line Register -------- */
#define L2CC_CIPALR_C (0x1u << 0) /**< \brief (L2CC_CIPALR) Cache Synchronization Status */
#define L2CC_CIPALR_IDX_Pos 5
#define L2CC_CIPALR_IDX_Msk (0x1ffu << L2CC_CIPALR_IDX_Pos) /**< \brief (L2CC_CIPALR) Index Number */
#define L2CC_CIPALR_IDX(value) ((L2CC_CIPALR_IDX_Msk & ((value) << L2CC_CIPALR_IDX_Pos)))
#define L2CC_CIPALR_TAG_Pos 14
#define L2CC_CIPALR_TAG_Msk (0x3ffffu << L2CC_CIPALR_TAG_Pos) /**< \brief (L2CC_CIPALR) Tag Number */
#define L2CC_CIPALR_TAG(value) ((L2CC_CIPALR_TAG_Msk & ((value) << L2CC_CIPALR_TAG_Pos)))
/* -------- L2CC_CIIR : (L2CC Offset: 0x7F8) Clean Invalidate Index Register -------- */
#define L2CC_CIIR_C (0x1u << 0) /**< \brief (L2CC_CIIR) Cache Synchronization Status */
#define L2CC_CIIR_IDX_Pos 5
#define L2CC_CIIR_IDX_Msk (0x1ffu << L2CC_CIIR_IDX_Pos) /**< \brief (L2CC_CIIR) Index Number */
#define L2CC_CIIR_IDX(value) ((L2CC_CIIR_IDX_Msk & ((value) << L2CC_CIIR_IDX_Pos)))
#define L2CC_CIIR_WAY_Pos 28
#define L2CC_CIIR_WAY_Msk (0x7u << L2CC_CIIR_WAY_Pos) /**< \brief (L2CC_CIIR) Way Number */
#define L2CC_CIIR_WAY(value) ((L2CC_CIIR_WAY_Msk & ((value) << L2CC_CIIR_WAY_Pos)))
/* -------- L2CC_CIWR : (L2CC Offset: 0x7FC) Clean Invalidate Way Register -------- */
#define L2CC_CIWR_WAY0 (0x1u << 0) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 0 */
#define L2CC_CIWR_WAY1 (0x1u << 1) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 1 */
#define L2CC_CIWR_WAY2 (0x1u << 2) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 2 */
#define L2CC_CIWR_WAY3 (0x1u << 3) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 3 */
#define L2CC_CIWR_WAY4 (0x1u << 4) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 4 */
#define L2CC_CIWR_WAY5 (0x1u << 5) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 5 */
#define L2CC_CIWR_WAY6 (0x1u << 6) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 6 */
#define L2CC_CIWR_WAY7 (0x1u << 7) /**< \brief (L2CC_CIWR) Clean Invalidate Way Number 7 */
/* -------- L2CC_DLKR : (L2CC Offset: 0x900) Data Lockdown Register -------- */
#define L2CC_DLKR_DLK0 (0x1u << 0) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 0 */
#define L2CC_DLKR_DLK1 (0x1u << 1) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 1 */
#define L2CC_DLKR_DLK2 (0x1u << 2) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 2 */
#define L2CC_DLKR_DLK3 (0x1u << 3) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 3 */
#define L2CC_DLKR_DLK4 (0x1u << 4) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 4 */
#define L2CC_DLKR_DLK5 (0x1u << 5) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 5 */
#define L2CC_DLKR_DLK6 (0x1u << 6) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 6 */
#define L2CC_DLKR_DLK7 (0x1u << 7) /**< \brief (L2CC_DLKR) Data Lockdown in Way Number 7 */
/* -------- L2CC_ILKR : (L2CC Offset: 0x904) Instruction Lockdown Register -------- */
#define L2CC_ILKR_ILK0 (0x1u << 0) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 0 */
#define L2CC_ILKR_ILK1 (0x1u << 1) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 1 */
#define L2CC_ILKR_ILK2 (0x1u << 2) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 2 */
#define L2CC_ILKR_ILK3 (0x1u << 3) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 3 */
#define L2CC_ILKR_ILK4 (0x1u << 4) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 4 */
#define L2CC_ILKR_ILK5 (0x1u << 5) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 5 */
#define L2CC_ILKR_ILK6 (0x1u << 6) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 6 */
#define L2CC_ILKR_ILK7 (0x1u << 7) /**< \brief (L2CC_ILKR) Instruction Lockdown in Way Number 7 */
/* -------- L2CC_DCR : (L2CC Offset: 0xF40) Debug Control Register -------- */
#define L2CC_DCR_DCL (0x1u << 0) /**< \brief (L2CC_DCR) Disable Cache Linefill */
#define L2CC_DCR_DWB (0x1u << 1) /**< \brief (L2CC_DCR) Disable Write-back, Force Write-through */
#define L2CC_DCR_SPNIDEN (0x1u << 2) /**< \brief (L2CC_DCR) SPNIDEN Value */
/* -------- L2CC_PCR : (L2CC Offset: 0xF60) Prefetch Control Register -------- */
#define L2CC_PCR_OFFSET_Pos 0
#define L2CC_PCR_OFFSET_Msk (0x1fu << L2CC_PCR_OFFSET_Pos) /**< \brief (L2CC_PCR) Prefetch Offset */
#define L2CC_PCR_OFFSET(value) ((L2CC_PCR_OFFSET_Msk & ((value) << L2CC_PCR_OFFSET_Pos)))
#define L2CC_PCR_NSIDEN (0x1u << 21) /**< \brief (L2CC_PCR) Incr Double Linefill Enable */
#define L2CC_PCR_IDLEN (0x1u << 23) /**< \brief (L2CC_PCR) Incr Double Linefill Enable */
#define L2CC_PCR_PDEN (0x1u << 24) /**< \brief (L2CC_PCR) Prefetch Drop Enable */
#define L2CC_PCR_DLFWRDIS (0x1u << 27) /**< \brief (L2CC_PCR) Double Linefill on WRAP Read Disable */
#define L2CC_PCR_DATPEN (0x1u << 28) /**< \brief (L2CC_PCR) Data Prefetch Enable */
#define L2CC_PCR_INSPEN (0x1u << 29) /**< \brief (L2CC_PCR) Instruction Prefetch Enable */
#define L2CC_PCR_DLEN (0x1u << 30) /**< \brief (L2CC_PCR) Double Linefill Enable */
/* -------- L2CC_POWCR : (L2CC Offset: 0xF80) Power Control Register -------- */
#define L2CC_POWCR_STBYEN (0x1u << 0) /**< \brief (L2CC_POWCR) Standby Mode Enable */
#define L2CC_POWCR_DCKGATEN (0x1u << 1) /**< \brief (L2CC_POWCR) Dynamic Clock Gating Enable */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR LCD Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_LCDC LCD Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Lcdc hardware registers */
typedef struct {
  __IO uint32_t LCDC_LCDCFG0;       /**< \brief (Lcdc Offset: 0x00000000) LCD Controller Configuration Register 0 */
  __IO uint32_t LCDC_LCDCFG1;       /**< \brief (Lcdc Offset: 0x00000004) LCD Controller Configuration Register 1 */
  __IO uint32_t LCDC_LCDCFG2;       /**< \brief (Lcdc Offset: 0x00000008) LCD Controller Configuration Register 2 */
  __IO uint32_t LCDC_LCDCFG3;       /**< \brief (Lcdc Offset: 0x0000000C) LCD Controller Configuration Register 3 */
  __IO uint32_t LCDC_LCDCFG4;       /**< \brief (Lcdc Offset: 0x00000010) LCD Controller Configuration Register 4 */
  __IO uint32_t LCDC_LCDCFG5;       /**< \brief (Lcdc Offset: 0x00000014) LCD Controller Configuration Register 5 */
  __IO uint32_t LCDC_LCDCFG6;       /**< \brief (Lcdc Offset: 0x00000018) LCD Controller Configuration Register 6 */
  __I  uint32_t Reserved1[1];
  __O  uint32_t LCDC_LCDEN;         /**< \brief (Lcdc Offset: 0x00000020) LCD Controller Enable Register */
  __O  uint32_t LCDC_LCDDIS;        /**< \brief (Lcdc Offset: 0x00000024) LCD Controller Disable Register */
  __I  uint32_t LCDC_LCDSR;         /**< \brief (Lcdc Offset: 0x00000028) LCD Controller Status Register */
  __O  uint32_t LCDC_LCDIER;        /**< \brief (Lcdc Offset: 0x0000002C) LCD Controller Interrupt Enable Register */
  __O  uint32_t LCDC_LCDIDR;        /**< \brief (Lcdc Offset: 0x00000030) LCD Controller Interrupt Disable Register */
  __I  uint32_t LCDC_LCDIMR;        /**< \brief (Lcdc Offset: 0x00000034) LCD Controller Interrupt Mask Register */
  __I  uint32_t LCDC_LCDISR;        /**< \brief (Lcdc Offset: 0x00000038) LCD Controller Interrupt Status Register */
  __I  uint32_t Reserved2[1];
  __O  uint32_t LCDC_BASECHER;      /**< \brief (Lcdc Offset: 0x00000040) Base Layer Channel Enable Register */
  __O  uint32_t LCDC_BASECHDR;      /**< \brief (Lcdc Offset: 0x00000044) Base Layer Channel Disable Register */
  __I  uint32_t LCDC_BASECHSR;      /**< \brief (Lcdc Offset: 0x00000048) Base Layer Channel Status Register */
  __O  uint32_t LCDC_BASEIER;       /**< \brief (Lcdc Offset: 0x0000004C) Base Layer Interrupt Enable Register */
  __O  uint32_t LCDC_BASEIDR;       /**< \brief (Lcdc Offset: 0x00000050) Base Layer Interrupt Disabled Register */
  __I  uint32_t LCDC_BASEIMR;       /**< \brief (Lcdc Offset: 0x00000054) Base Layer Interrupt Mask Register */
  __I  uint32_t LCDC_BASEISR;       /**< \brief (Lcdc Offset: 0x00000058) Base Layer Interrupt status Register */
  __IO uint32_t LCDC_BASEHEAD;      /**< \brief (Lcdc Offset: 0x0000005C) Base DMA Head Register */
  __IO uint32_t LCDC_BASEADDR;      /**< \brief (Lcdc Offset: 0x00000060) Base DMA Address Register */
  __IO uint32_t LCDC_BASECTRL;      /**< \brief (Lcdc Offset: 0x00000064) Base DMA Control Register */
  __IO uint32_t LCDC_BASENEXT;      /**< \brief (Lcdc Offset: 0x00000068) Base DMA Next Register */
  __IO uint32_t LCDC_BASECFG0;      /**< \brief (Lcdc Offset: 0x0000006C) Base Configuration register 0 */
  __IO uint32_t LCDC_BASECFG1;      /**< \brief (Lcdc Offset: 0x00000070) Base Configuration register 1 */
  __IO uint32_t LCDC_BASECFG2;      /**< \brief (Lcdc Offset: 0x00000074) Base Configuration register 2 */
  __IO uint32_t LCDC_BASECFG3;      /**< \brief (Lcdc Offset: 0x00000078) Base Configuration register 3 */
  __IO uint32_t LCDC_BASECFG4;      /**< \brief (Lcdc Offset: 0x0000007C) Base Configuration register 4 */
  __IO uint32_t LCDC_BASECFG5;      /**< \brief (Lcdc Offset: 0x00000080) Base Configuration register 5 */
  __IO uint32_t LCDC_BASECFG6;      /**< \brief (Lcdc Offset: 0x00000084) Base Configuration register 6 */
  __I  uint32_t Reserved3[46];
  __O  uint32_t LCDC_OVRCHER1;      /**< \brief (Lcdc Offset: 0x00000140) Overlay 1 Channel Enable Register */
  __O  uint32_t LCDC_OVRCHDR1;      /**< \brief (Lcdc Offset: 0x00000144) Overlay 1 Channel Disable Register */
  __I  uint32_t LCDC_OVRCHSR1;      /**< \brief (Lcdc Offset: 0x00000148) Overlay 1 Channel Status Register */
  __O  uint32_t LCDC_OVRIER1;       /**< \brief (Lcdc Offset: 0x0000014C) Overlay 1 Interrupt Enable Register */
  __O  uint32_t LCDC_OVRIDR1;       /**< \brief (Lcdc Offset: 0x00000150) Overlay 1 Interrupt Disable Register */
  __I  uint32_t LCDC_OVRIMR1;       /**< \brief (Lcdc Offset: 0x00000154) Overlay 1 Interrupt Mask Register */
  __I  uint32_t LCDC_OVRISR1;       /**< \brief (Lcdc Offset: 0x00000158) Overlay 1 Interrupt Status Register */
  __IO uint32_t LCDC_OVRHEAD1;      /**< \brief (Lcdc Offset: 0x0000015C) Overlay 1 DMA Head Register */
  __IO uint32_t LCDC_OVRADDR1;      /**< \brief (Lcdc Offset: 0x00000160) Overlay 1 DMA Address Register */
  __IO uint32_t LCDC_OVRCTRL1;      /**< \brief (Lcdc Offset: 0x00000164) Overlay 1 DMA Control Register */
  __IO uint32_t LCDC_OVRNEXT1;      /**< \brief (Lcdc Offset: 0x00000168) Overlay 1 DMA Next Register */
  __IO uint32_t LCDC_OVR1CFG0;      /**< \brief (Lcdc Offset: 0x0000016C) Overlay 1 Configuration 0 Register */
  __IO uint32_t LCDC_OVR1CFG1;      /**< \brief (Lcdc Offset: 0x00000170) Overlay 1 Configuration 1 Register */
  __IO uint32_t LCDC_OVR1CFG2;      /**< \brief (Lcdc Offset: 0x00000174) Overlay 1 Configuration 2 Register */
  __IO uint32_t LCDC_OVR1CFG3;      /**< \brief (Lcdc Offset: 0x00000178) Overlay 1 Configuration 3 Register */
  __IO uint32_t LCDC_OVR1CFG4;      /**< \brief (Lcdc Offset: 0x0000017C) Overlay 1 Configuration 4 Register */
  __IO uint32_t LCDC_OVR1CFG5;      /**< \brief (Lcdc Offset: 0x00000180) Overlay 1 Configuration 5 Register */
  __IO uint32_t LCDC_OVR1CFG6;      /**< \brief (Lcdc Offset: 0x00000184) Overlay 1 Configuration 6 Register */
  __IO uint32_t LCDC_OVR1CFG7;      /**< \brief (Lcdc Offset: 0x00000188) Overlay 1 Configuration 7 Register */
  __IO uint32_t LCDC_OVR1CFG8;      /**< \brief (Lcdc Offset: 0x0000018C) Overlay 1 Configuration 8Register */
  __IO uint32_t LCDC_OVR1CFG9;      /**< \brief (Lcdc Offset: 0x00000190) Overlay 1 Configuration 9 Register */
  __I  uint32_t Reserved4[43];
  __O  uint32_t LCDC_OVRCHER2;      /**< \brief (Lcdc Offset: 0x00000240) Overlay 2 Channel Enable Register */
  __O  uint32_t LCDC_OVRCHDR2;      /**< \brief (Lcdc Offset: 0x00000244) Overlay 2 Channel Disable Register */
  __I  uint32_t LCDC_OVRCHSR2;      /**< \brief (Lcdc Offset: 0x00000248) Overlay 2 Channel Status Register */
  __O  uint32_t LCDC_OVRIER2;       /**< \brief (Lcdc Offset: 0x0000024C) Overlay 2 Interrupt Enable Register */
  __O  uint32_t LCDC_OVRIDR2;       /**< \brief (Lcdc Offset: 0x00000250) Overlay 2 Interrupt Disable Register */
  __I  uint32_t LCDC_OVRIMR2;       /**< \brief (Lcdc Offset: 0x00000254) Overlay 2 Interrupt Mask Register */
  __I  uint32_t LCDC_OVRISR2;       /**< \brief (Lcdc Offset: 0x00000258) Overlay 2 Interrupt status Register */
  __IO uint32_t LCDC_OVRHEAD2;      /**< \brief (Lcdc Offset: 0x0000025C) Overlay 2 DMA Head Register */
  __IO uint32_t LCDC_OVRADDR2;      /**< \brief (Lcdc Offset: 0x00000260) Overlay 2 DMA Address Register */
  __IO uint32_t LCDC_OVRCTRL2;      /**< \brief (Lcdc Offset: 0x00000264) Overlay 2 DMA Control Register */
  __IO uint32_t LCDC_OVRNEXT2;      /**< \brief (Lcdc Offset: 0x00000268) Overlay 2 DMA Next Register */
  __IO uint32_t LCDC_OVR2CFG0;      /**< \brief (Lcdc Offset: 0x0000026C) Overlay 2 Configuration 0 Register */
  __IO uint32_t LCDC_OVR2CFG1;      /**< \brief (Lcdc Offset: 0x00000270) Overlay 2 Configuration 1 Register */
  __IO uint32_t LCDC_OVR2CFG2;      /**< \brief (Lcdc Offset: 0x00000274) Overlay 2 Configuration 2 Register */
  __IO uint32_t LCDC_OVR2CFG3;      /**< \brief (Lcdc Offset: 0x00000278) Overlay 2 Configuration 3 Register */
  __IO uint32_t LCDC_OVR2CFG4;      /**< \brief (Lcdc Offset: 0x0000027C) Overlay 2 Configuration 4 Register */
  __IO uint32_t LCDC_OVR2CFG5;      /**< \brief (Lcdc Offset: 0x00000280) Overlay 2 Configuration 5 Register */
  __IO uint32_t LCDC_OVR2CFG6;      /**< \brief (Lcdc Offset: 0x00000284) Overlay 2 Configuration 6 Register */
  __IO uint32_t LCDC_OVR2CFG7;      /**< \brief (Lcdc Offset: 0x00000288) Overlay 2 Configuration 7 Register */
  __IO uint32_t LCDC_OVR2CFG8;      /**< \brief (Lcdc Offset: 0x0000028C) Overlay 2 Configuration 8 Register */
  __IO uint32_t LCDC_OVR2CFG9;      /**< \brief (Lcdc Offset: 0x00000290) Overlay 2 Configuration 9 Register */
  __I  uint32_t Reserved5[43];
  __O  uint32_t LCDC_HEOCHER;       /**< \brief (Lcdc Offset: 0x00000340) High-End Overlay Channel Enable Register */
  __O  uint32_t LCDC_HEOCHDR;       /**< \brief (Lcdc Offset: 0x00000344) High-End Overlay Channel Disable Register */
  __I  uint32_t LCDC_HEOCHSR;       /**< \brief (Lcdc Offset: 0x00000348) High-End Overlay Channel Status Register */
  __O  uint32_t LCDC_HEOIER;        /**< \brief (Lcdc Offset: 0x0000034C) High-End Overlay Interrupt Enable Register */
  __O  uint32_t LCDC_HEOIDR;        /**< \brief (Lcdc Offset: 0x00000350) High-End Overlay Interrupt Disable Register */
  __I  uint32_t LCDC_HEOIMR;        /**< \brief (Lcdc Offset: 0x00000354) High-End Overlay Interrupt Mask Register */
  __I  uint32_t LCDC_HEOISR;        /**< \brief (Lcdc Offset: 0x00000358) High-End Overlay Interrupt Status Register */
  __IO uint32_t LCDC_HEOHEAD;       /**< \brief (Lcdc Offset: 0x0000035C) High-End Overlay DMA Head Register */
  __IO uint32_t LCDC_HEOADDR;       /**< \brief (Lcdc Offset: 0x00000360) High-End Overlay DMA Address Register */
  __IO uint32_t LCDC_HEOCTRL;       /**< \brief (Lcdc Offset: 0x00000364) High-End Overlay DMA Control Register */
  __IO uint32_t LCDC_HEONEXT;       /**< \brief (Lcdc Offset: 0x00000368) High-End Overlay DMA Next Register */
  __IO uint32_t LCDC_HEOUHEAD;      /**< \brief (Lcdc Offset: 0x0000036C) High-End Overlay U DMA Head Register */
  __IO uint32_t LCDC_HEOUADDR;      /**< \brief (Lcdc Offset: 0x00000370) High-End Overlay U DMA Address Register */
  __IO uint32_t LCDC_HEOUCTRL;      /**< \brief (Lcdc Offset: 0x00000374) High-End Overlay U DMA control Register */
  __IO uint32_t LCDC_HEOUNEXT;      /**< \brief (Lcdc Offset: 0x00000378) High-End Overlay U DMA Next Register */
  __IO uint32_t LCDC_HEOVHEAD;      /**< \brief (Lcdc Offset: 0x0000037C) High-End Overlay V DMA Head Register */
  __IO uint32_t LCDC_HEOVADDR;      /**< \brief (Lcdc Offset: 0x00000380) High-End Overlay V DMA Address Register */
  __IO uint32_t LCDC_HEOVCTRL;      /**< \brief (Lcdc Offset: 0x00000384) High-End Overlay V DMA control Register */
  __IO uint32_t LCDC_HEOVNEXT;      /**< \brief (Lcdc Offset: 0x00000388) High-End Overlay VDMA Next Register */
  __IO uint32_t LCDC_HEOCFG0;       /**< \brief (Lcdc Offset: 0x0000038C) High-End Overlay Configuration Register 0 */
  __IO uint32_t LCDC_HEOCFG1;       /**< \brief (Lcdc Offset: 0x00000390) High-End Overlay Configuration Register 1 */
  __IO uint32_t LCDC_HEOCFG2;       /**< \brief (Lcdc Offset: 0x00000394) High-End Overlay Configuration Register 2 */
  __IO uint32_t LCDC_HEOCFG3;       /**< \brief (Lcdc Offset: 0x00000398) High-End Overlay Configuration Register 3 */
  __IO uint32_t LCDC_HEOCFG4;       /**< \brief (Lcdc Offset: 0x0000039C) High-End Overlay Configuration Register 4 */
  __IO uint32_t LCDC_HEOCFG5;       /**< \brief (Lcdc Offset: 0x000003A0) High-End Overlay Configuration Register 5 */
  __IO uint32_t LCDC_HEOCFG6;       /**< \brief (Lcdc Offset: 0x000003A4) High-End Overlay Configuration Register 6 */
  __IO uint32_t LCDC_HEOCFG7;       /**< \brief (Lcdc Offset: 0x000003A8) High-End Overlay Configuration Register 7 */
  __IO uint32_t LCDC_HEOCFG8;       /**< \brief (Lcdc Offset: 0x000003AC) High-End Overlay Configuration Register 8 */
  __IO uint32_t LCDC_HEOCFG9;       /**< \brief (Lcdc Offset: 0x000003B0) High-End Overlay Configuration Register 9 */
  __IO uint32_t LCDC_HEOCFG10;      /**< \brief (Lcdc Offset: 0x000003B4) High-End Overlay Configuration Register 10 */
  __IO uint32_t LCDC_HEOCFG11;      /**< \brief (Lcdc Offset: 0x000003B8) High-End Overlay Configuration Register 11 */
  __IO uint32_t LCDC_HEOCFG12;      /**< \brief (Lcdc Offset: 0x000003BC) High-End Overlay Configuration Register 12 */
  __IO uint32_t LCDC_HEOCFG13;      /**< \brief (Lcdc Offset: 0x000003C0) High-End Overlay Configuration Register 13 */
  __IO uint32_t LCDC_HEOCFG14;      /**< \brief (Lcdc Offset: 0x000003C4) High-End Overlay Configuration Register 14 */
  __IO uint32_t LCDC_HEOCFG15;      /**< \brief (Lcdc Offset: 0x000003C8) High-End Overlay Configuration Register 15 */
  __IO uint32_t LCDC_HEOCFG16;      /**< \brief (Lcdc Offset: 0x000003CC) High-End Overlay Configuration Register 16 */
  __IO uint32_t LCDC_HEOCFG17;      /**< \brief (Lcdc Offset: 0x000003D0) High-End Overlay Configuration Register 17 */
  __IO uint32_t LCDC_HEOCFG18;      /**< \brief (Lcdc Offset: 0x000003D4) High-End Overlay Configuration Register 18 */
  __IO uint32_t LCDC_HEOCFG19;      /**< \brief (Lcdc Offset: 0x000003D8) High-End Overlay Configuration Register 19 */
  __IO uint32_t LCDC_HEOCFG20;      /**< \brief (Lcdc Offset: 0x000003DC) High-End Overlay Configuration Register 20 */
  __IO uint32_t LCDC_HEOCFG21;      /**< \brief (Lcdc Offset: 0x000003E0) High-End Overlay Configuration Register 21 */
  __IO uint32_t LCDC_HEOCFG22;      /**< \brief (Lcdc Offset: 0x000003E4) High-End Overlay Configuration Register 22 */
  __IO uint32_t LCDC_HEOCFG23;      /**< \brief (Lcdc Offset: 0x000003E8) High-End Overlay Configuration Register 23 */
  __IO uint32_t LCDC_HEOCFG24;      /**< \brief (Lcdc Offset: 0x000003EC) High-End Overlay Configuration Register 24 */
  __IO uint32_t LCDC_HEOCFG25;      /**< \brief (Lcdc Offset: 0x000003F0) High-End Overlay Configuration Register 25 */
  __IO uint32_t LCDC_HEOCFG26;      /**< \brief (Lcdc Offset: 0x000003F4) High-End Overlay Configuration Register 26 */
  __IO uint32_t LCDC_HEOCFG27;      /**< \brief (Lcdc Offset: 0x000003F8) High-End Overlay Configuration Register 27 */
  __IO uint32_t LCDC_HEOCFG28;      /**< \brief (Lcdc Offset: 0x000003FC) High-End Overlay Configuration Register 28 */
  __IO uint32_t LCDC_HEOCFG29;      /**< \brief (Lcdc Offset: 0x00000400) High-End Overlay Configuration Register 29 */
  __IO uint32_t LCDC_HEOCFG30;      /**< \brief (Lcdc Offset: 0x00000404) High-End Overlay Configuration Register 30 */
  __IO uint32_t LCDC_HEOCFG31;      /**< \brief (Lcdc Offset: 0x00000408) High-End Overlay Configuration Register 31 */
  __IO uint32_t LCDC_HEOCFG32;      /**< \brief (Lcdc Offset: 0x0000040C) High-End Overlay Configuration Register 32 */
  __IO uint32_t LCDC_HEOCFG33;      /**< \brief (Lcdc Offset: 0x00000410) High-End Overlay Configuration Register 33 */
  __IO uint32_t LCDC_HEOCFG34;      /**< \brief (Lcdc Offset: 0x00000414) High-End Overlay Configuration Register 34 */
  __IO uint32_t LCDC_HEOCFG35;      /**< \brief (Lcdc Offset: 0x00000418) High-End Overlay Configuration Register 35 */
  __IO uint32_t LCDC_HEOCFG36;      /**< \brief (Lcdc Offset: 0x0000041C) High-End Overlay Configuration Register 36 */
  __IO uint32_t LCDC_HEOCFG37;      /**< \brief (Lcdc Offset: 0x00000420) High-End Overlay Configuration Register 37 */
  __IO uint32_t LCDC_HEOCFG38;      /**< \brief (Lcdc Offset: 0x00000424) High-End Overlay Configuration Register 38 */
  __IO uint32_t LCDC_HEOCFG39;      /**< \brief (Lcdc Offset: 0x00000428) High-End Overlay Configuration Register 39 */
  __IO uint32_t LCDC_HEOCFG40;      /**< \brief (Lcdc Offset: 0x0000042C) High-End Overlay Configuration Register 40 */
  __IO uint32_t LCDC_HEOCFG41;      /**< \brief (Lcdc Offset: 0x00000430) High-End Overlay Configuration Register 41 */
  __I  uint32_t Reserved6[115];
  __IO uint32_t LCDC_BASECLUT[256]; /**< \brief (Lcdc Offset: 0x600) Base CLUT Register */
  __IO uint32_t LCDC_OVR1CLUT[256]; /**< \brief (Lcdc Offset: 0xA00) Overlay 1 CLUT Register */
  __IO uint32_t LCDC_OVR2CLUT[256]; /**< \brief (Lcdc Offset: 0xE00) Overlay 2 CLUT Register */
  __IO uint32_t LCDC_HEOCLUT[256];  /**< \brief (Lcdc Offset: 0x1200) High End Overlay CLUT Register */
} Lcdc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- LCDC_LCDCFG0 : (LCDC Offset: 0x00000000) LCD Controller Configuration Register 0 -------- */
#define LCDC_LCDCFG0_CLKPOL (0x1u << 0) /**< \brief (LCDC_LCDCFG0) LCD Controller Clock Polarity */
#define LCDC_LCDCFG0_CLKSEL (0x1u << 2) /**< \brief (LCDC_LCDCFG0) LCD Controller Clock Source Selection */
#define LCDC_LCDCFG0_CLKPWMSEL (0x1u << 3) /**< \brief (LCDC_LCDCFG0) LCD Controller PWM Clock Source Selection */
#define LCDC_LCDCFG0_CGDISBASE (0x1u << 8) /**< \brief (LCDC_LCDCFG0) Clock Gating Disable Control for the Base Layer */
#define LCDC_LCDCFG0_CGDISOVR1 (0x1u << 9) /**< \brief (LCDC_LCDCFG0) Clock Gating Disable Control for the Overlay 1 Layer */
#define LCDC_LCDCFG0_CGDISOVR2 (0x1u << 10) /**< \brief (LCDC_LCDCFG0) Clock Gating Disable Control for the Overlay 2 Layer */
#define LCDC_LCDCFG0_CGDISHEO (0x1u << 11) /**< \brief (LCDC_LCDCFG0) Clock Gating Disable Control for the High End Overlay */
#define LCDC_LCDCFG0_CLKDIV_Pos 16
#define LCDC_LCDCFG0_CLKDIV_Msk (0xffu << LCDC_LCDCFG0_CLKDIV_Pos) /**< \brief (LCDC_LCDCFG0) LCD Controller Clock Divider */
#define LCDC_LCDCFG0_CLKDIV(value) ((LCDC_LCDCFG0_CLKDIV_Msk & ((value) << LCDC_LCDCFG0_CLKDIV_Pos)))
/* -------- LCDC_LCDCFG1 : (LCDC Offset: 0x00000004) LCD Controller Configuration Register 1 -------- */
#define LCDC_LCDCFG1_HSPW_Pos 0
#define LCDC_LCDCFG1_HSPW_Msk (0x3fu << LCDC_LCDCFG1_HSPW_Pos) /**< \brief (LCDC_LCDCFG1) Horizontal Synchronization Pulse Width */
#define LCDC_LCDCFG1_HSPW(value) ((LCDC_LCDCFG1_HSPW_Msk & ((value) << LCDC_LCDCFG1_HSPW_Pos)))
#define LCDC_LCDCFG1_VSPW_Pos 16
#define LCDC_LCDCFG1_VSPW_Msk (0x3fu << LCDC_LCDCFG1_VSPW_Pos) /**< \brief (LCDC_LCDCFG1) Vertical Synchronization Pulse Width */
#define LCDC_LCDCFG1_VSPW(value) ((LCDC_LCDCFG1_VSPW_Msk & ((value) << LCDC_LCDCFG1_VSPW_Pos)))
/* -------- LCDC_LCDCFG2 : (LCDC Offset: 0x00000008) LCD Controller Configuration Register 2 -------- */
#define LCDC_LCDCFG2_VFPW_Pos 0
#define LCDC_LCDCFG2_VFPW_Msk (0x3fu << LCDC_LCDCFG2_VFPW_Pos) /**< \brief (LCDC_LCDCFG2) Vertical Front Porch Width */
#define LCDC_LCDCFG2_VFPW(value) ((LCDC_LCDCFG2_VFPW_Msk & ((value) << LCDC_LCDCFG2_VFPW_Pos)))
#define LCDC_LCDCFG2_VBPW_Pos 16
#define LCDC_LCDCFG2_VBPW_Msk (0x3fu << LCDC_LCDCFG2_VBPW_Pos) /**< \brief (LCDC_LCDCFG2) Vertical Back Porch Width */
#define LCDC_LCDCFG2_VBPW(value) ((LCDC_LCDCFG2_VBPW_Msk & ((value) << LCDC_LCDCFG2_VBPW_Pos)))
/* -------- LCDC_LCDCFG3 : (LCDC Offset: 0x0000000C) LCD Controller Configuration Register 3 -------- */
#define LCDC_LCDCFG3_HFPW_Pos 0
#define LCDC_LCDCFG3_HFPW_Msk (0x1ffu << LCDC_LCDCFG3_HFPW_Pos) /**< \brief (LCDC_LCDCFG3) Horizontal Front Porch Width */
#define LCDC_LCDCFG3_HFPW(value) ((LCDC_LCDCFG3_HFPW_Msk & ((value) << LCDC_LCDCFG3_HFPW_Pos)))
#define LCDC_LCDCFG3_HBPW_Pos 16
#define LCDC_LCDCFG3_HBPW_Msk (0x1ffu << LCDC_LCDCFG3_HBPW_Pos) /**< \brief (LCDC_LCDCFG3) Horizontal Back Porch Width */
#define LCDC_LCDCFG3_HBPW(value) ((LCDC_LCDCFG3_HBPW_Msk & ((value) << LCDC_LCDCFG3_HBPW_Pos)))
/* -------- LCDC_LCDCFG4 : (LCDC Offset: 0x00000010) LCD Controller Configuration Register 4 -------- */
#define LCDC_LCDCFG4_PPL_Pos 0
#define LCDC_LCDCFG4_PPL_Msk (0x7ffu << LCDC_LCDCFG4_PPL_Pos) /**< \brief (LCDC_LCDCFG4) Number of Pixels Per Line */
#define LCDC_LCDCFG4_PPL(value) ((LCDC_LCDCFG4_PPL_Msk & ((value) << LCDC_LCDCFG4_PPL_Pos)))
#define LCDC_LCDCFG4_RPF_Pos 16
#define LCDC_LCDCFG4_RPF_Msk (0x7ffu << LCDC_LCDCFG4_RPF_Pos) /**< \brief (LCDC_LCDCFG4) Number of Active Row Per Frame */
#define LCDC_LCDCFG4_RPF(value) ((LCDC_LCDCFG4_RPF_Msk & ((value) << LCDC_LCDCFG4_RPF_Pos)))
/* -------- LCDC_LCDCFG5 : (LCDC Offset: 0x00000014) LCD Controller Configuration Register 5 -------- */
#define LCDC_LCDCFG5_HSPOL (0x1u << 0) /**< \brief (LCDC_LCDCFG5) Horizontal Synchronization Pulse Polarity */
#define LCDC_LCDCFG5_VSPOL (0x1u << 1) /**< \brief (LCDC_LCDCFG5) Vertical Synchronization Pulse Polarity */
#define LCDC_LCDCFG5_VSPDLYS (0x1u << 2) /**< \brief (LCDC_LCDCFG5) Vertical Synchronization Pulse Start */
#define LCDC_LCDCFG5_VSPDLYE (0x1u << 3) /**< \brief (LCDC_LCDCFG5) Vertical Synchronization Pulse End */
#define LCDC_LCDCFG5_DISPPOL (0x1u << 4) /**< \brief (LCDC_LCDCFG5) Display Signal Polarity */
#define LCDC_LCDCFG5_DITHER (0x1u << 6) /**< \brief (LCDC_LCDCFG5) LCD Controller Dithering */
#define LCDC_LCDCFG5_DISPDLY (0x1u << 7) /**< \brief (LCDC_LCDCFG5) LCD Controller Display Power Signal Synchronization */
#define LCDC_LCDCFG5_MODE_Pos 8
#define LCDC_LCDCFG5_MODE_Msk (0x3u << LCDC_LCDCFG5_MODE_Pos) /**< \brief (LCDC_LCDCFG5) LCD Controller Output Mode */
#define   LCDC_LCDCFG5_MODE_OUTPUT_12BPP (0x0u << 8) /**< \brief (LCDC_LCDCFG5) LCD output mode is set to 12 bits per pixel */
#define   LCDC_LCDCFG5_MODE_OUTPUT_16BPP (0x1u << 8) /**< \brief (LCDC_LCDCFG5) LCD output mode is set to 16 bits per pixel */
#define   LCDC_LCDCFG5_MODE_OUTPUT_18BPP (0x2u << 8) /**< \brief (LCDC_LCDCFG5) LCD output mode is set to 18 bits per pixel */
#define   LCDC_LCDCFG5_MODE_OUTPUT_24BPP (0x3u << 8) /**< \brief (LCDC_LCDCFG5) LCD output mode is set to 24 bits per pixel */
#define LCDC_LCDCFG5_VSPSU (0x1u << 12) /**< \brief (LCDC_LCDCFG5) LCD Controller Vertical synchronization Pulse Setup Configuration */
#define LCDC_LCDCFG5_VSPHO (0x1u << 13) /**< \brief (LCDC_LCDCFG5) LCD Controller Vertical synchronization Pulse Hold Configuration */
#define LCDC_LCDCFG5_GUARDTIME_Pos 16
#define LCDC_LCDCFG5_GUARDTIME_Msk (0x1fu << LCDC_LCDCFG5_GUARDTIME_Pos) /**< \brief (LCDC_LCDCFG5) LCD DISPLAY Guard Time */
#define LCDC_LCDCFG5_GUARDTIME(value) ((LCDC_LCDCFG5_GUARDTIME_Msk & ((value) << LCDC_LCDCFG5_GUARDTIME_Pos)))
/* -------- LCDC_LCDCFG6 : (LCDC Offset: 0x00000018) LCD Controller Configuration Register 6 -------- */
#define LCDC_LCDCFG6_PWMPS_Pos 0
#define LCDC_LCDCFG6_PWMPS_Msk (0x7u << LCDC_LCDCFG6_PWMPS_Pos) /**< \brief (LCDC_LCDCFG6) PWM Clock Prescaler */
#define LCDC_LCDCFG6_PWMPS(value) ((LCDC_LCDCFG6_PWMPS_Msk & ((value) << LCDC_LCDCFG6_PWMPS_Pos)))
#define LCDC_LCDCFG6_PWMPOL (0x1u << 4) /**< \brief (LCDC_LCDCFG6) LCD Controller PWM Signal Polarity */
#define LCDC_LCDCFG6_PWMCVAL_Pos 8
#define LCDC_LCDCFG6_PWMCVAL_Msk (0xffu << LCDC_LCDCFG6_PWMCVAL_Pos) /**< \brief (LCDC_LCDCFG6) LCD Controller PWM Compare Value */
#define LCDC_LCDCFG6_PWMCVAL(value) ((LCDC_LCDCFG6_PWMCVAL_Msk & ((value) << LCDC_LCDCFG6_PWMCVAL_Pos)))
/* -------- LCDC_LCDEN : (LCDC Offset: 0x00000020) LCD Controller Enable Register -------- */
#define LCDC_LCDEN_CLKEN (0x1u << 0) /**< \brief (LCDC_LCDEN) LCD Controller Pixel Clock Enable */
#define LCDC_LCDEN_SYNCEN (0x1u << 1) /**< \brief (LCDC_LCDEN) LCD Controller Horizontal and Vertical Synchronization Enable */
#define LCDC_LCDEN_DISPEN (0x1u << 2) /**< \brief (LCDC_LCDEN) LCD Controller DISP Signal Enable */
#define LCDC_LCDEN_PWMEN (0x1u << 3) /**< \brief (LCDC_LCDEN) LCD Controller Pulse Width Modulation Enable */
/* -------- LCDC_LCDDIS : (LCDC Offset: 0x00000024) LCD Controller Disable Register -------- */
#define LCDC_LCDDIS_CLKDIS (0x1u << 0) /**< \brief (LCDC_LCDDIS) LCD Controller Pixel Clock Disable */
#define LCDC_LCDDIS_SYNCDIS (0x1u << 1) /**< \brief (LCDC_LCDDIS) LCD Controller Horizontal and Vertical Synchronization Disable */
#define LCDC_LCDDIS_DISPDIS (0x1u << 2) /**< \brief (LCDC_LCDDIS) LCD Controller DISP Signal Disable */
#define LCDC_LCDDIS_PWMDIS (0x1u << 3) /**< \brief (LCDC_LCDDIS) LCD Controller Pulse Width Modulation Disable */
#define LCDC_LCDDIS_CLKRST (0x1u << 8) /**< \brief (LCDC_LCDDIS) LCD Controller Clock Reset */
#define LCDC_LCDDIS_SYNCRST (0x1u << 9) /**< \brief (LCDC_LCDDIS) LCD Controller Horizontal and Vertical Synchronization Reset */
#define LCDC_LCDDIS_DISPRST (0x1u << 10) /**< \brief (LCDC_LCDDIS) LCD Controller DISP Signal Reset */
#define LCDC_LCDDIS_PWMRST (0x1u << 11) /**< \brief (LCDC_LCDDIS) LCD Controller PWM Reset */
/* -------- LCDC_LCDSR : (LCDC Offset: 0x00000028) LCD Controller Status Register -------- */
#define LCDC_LCDSR_CLKSTS (0x1u << 0) /**< \brief (LCDC_LCDSR) Clock Status */
#define LCDC_LCDSR_LCDSTS (0x1u << 1) /**< \brief (LCDC_LCDSR) LCD Controller Synchronization status */
#define LCDC_LCDSR_DISPSTS (0x1u << 2) /**< \brief (LCDC_LCDSR) LCD Controller DISP Signal Status */
#define LCDC_LCDSR_PWMSTS (0x1u << 3) /**< \brief (LCDC_LCDSR) LCD Controller PWM Signal Status */
#define LCDC_LCDSR_SIPSTS (0x1u << 4) /**< \brief (LCDC_LCDSR) Synchronization In Progress */
/* -------- LCDC_LCDIER : (LCDC Offset: 0x0000002C) LCD Controller Interrupt Enable Register -------- */
#define LCDC_LCDIER_SOFIE (0x1u << 0) /**< \brief (LCDC_LCDIER) Start of Frame Interrupt Enable Register */
#define LCDC_LCDIER_DISIE (0x1u << 1) /**< \brief (LCDC_LCDIER) LCD Disable Interrupt Enable Register */
#define LCDC_LCDIER_DISPIE (0x1u << 2) /**< \brief (LCDC_LCDIER) Power UP/Down Sequence Terminated Interrupt Enable Register */
#define LCDC_LCDIER_FIFOERRIE (0x1u << 4) /**< \brief (LCDC_LCDIER) Output FIFO Error Interrupt Enable Register */
#define LCDC_LCDIER_BASEIE (0x1u << 8) /**< \brief (LCDC_LCDIER) Base Layer Interrupt Enable Register */
#define LCDC_LCDIER_OVR1IE (0x1u << 9) /**< \brief (LCDC_LCDIER) Overlay 1 Interrupt Enable Register */
#define LCDC_LCDIER_OVR2IE (0x1u << 10) /**< \brief (LCDC_LCDIER) Overlay 2 Interrupt Enable Register */
#define LCDC_LCDIER_HEOIE (0x1u << 11) /**< \brief (LCDC_LCDIER) High End Overlay Interrupt Enable Register */
/* -------- LCDC_LCDIDR : (LCDC Offset: 0x00000030) LCD Controller Interrupt Disable Register -------- */
#define LCDC_LCDIDR_SOFID (0x1u << 0) /**< \brief (LCDC_LCDIDR) Start of Frame Interrupt Disable Register */
#define LCDC_LCDIDR_DISID (0x1u << 1) /**< \brief (LCDC_LCDIDR) LCD Disable Interrupt Disable Register */
#define LCDC_LCDIDR_DISPID (0x1u << 2) /**< \brief (LCDC_LCDIDR) Power UP/Down Sequence Terminated Interrupt Disable Register */
#define LCDC_LCDIDR_FIFOERRID (0x1u << 4) /**< \brief (LCDC_LCDIDR) Output FIFO Error Interrupt Disable Register */
#define LCDC_LCDIDR_BASEID (0x1u << 8) /**< \brief (LCDC_LCDIDR) Base Layer Interrupt Disable Register */
#define LCDC_LCDIDR_OVR1ID (0x1u << 9) /**< \brief (LCDC_LCDIDR) Overlay 1 Interrupt Disable Register */
#define LCDC_LCDIDR_OVR2ID (0x1u << 10) /**< \brief (LCDC_LCDIDR) Overlay 2 Interrupt Disable Register */
#define LCDC_LCDIDR_HEOID (0x1u << 11) /**< \brief (LCDC_LCDIDR) High End Overlay Interrupt Disable Register */
/* -------- LCDC_LCDIMR : (LCDC Offset: 0x00000034) LCD Controller Interrupt Mask Register -------- */
#define LCDC_LCDIMR_SOFIM (0x1u << 0) /**< \brief (LCDC_LCDIMR) Start of Frame Interrupt Mask Register */
#define LCDC_LCDIMR_DISIM (0x1u << 1) /**< \brief (LCDC_LCDIMR) LCD Disable Interrupt Mask Register */
#define LCDC_LCDIMR_DISPIM (0x1u << 2) /**< \brief (LCDC_LCDIMR) Power UP/Down Sequence Terminated Interrupt Mask Register */
#define LCDC_LCDIMR_FIFOERRIM (0x1u << 4) /**< \brief (LCDC_LCDIMR) Output FIFO Error Interrupt Mask Register */
#define LCDC_LCDIMR_BASEIM (0x1u << 8) /**< \brief (LCDC_LCDIMR) Base Layer Interrupt Mask Register */
#define LCDC_LCDIMR_OVR1IM (0x1u << 9) /**< \brief (LCDC_LCDIMR) Overlay 1 Interrupt Mask Register */
#define LCDC_LCDIMR_OVR2IM (0x1u << 10) /**< \brief (LCDC_LCDIMR) Overlay 2 Interrupt Mask Register */
#define LCDC_LCDIMR_HEOIM (0x1u << 11) /**< \brief (LCDC_LCDIMR) High End Overlay Interrupt Mask Register */
/* -------- LCDC_LCDISR : (LCDC Offset: 0x00000038) LCD Controller Interrupt Status Register -------- */
#define LCDC_LCDISR_SOF (0x1u << 0) /**< \brief (LCDC_LCDISR) Start of Frame Interrupt Status Register */
#define LCDC_LCDISR_DIS (0x1u << 1) /**< \brief (LCDC_LCDISR) LCD Disable Interrupt Status Register */
#define LCDC_LCDISR_DISP (0x1u << 2) /**< \brief (LCDC_LCDISR) Power-up/Power-down Sequence Terminated Interrupt Status Register */
#define LCDC_LCDISR_FIFOERR (0x1u << 4) /**< \brief (LCDC_LCDISR) Output FIFO Error */
#define LCDC_LCDISR_BASE (0x1u << 8) /**< \brief (LCDC_LCDISR) Base Layer Raw Interrupt Status Register */
#define LCDC_LCDISR_OVR1 (0x1u << 9) /**< \brief (LCDC_LCDISR) Overlay 1 Raw Interrupt Status Register */
#define LCDC_LCDISR_OVR2 (0x1u << 10) /**< \brief (LCDC_LCDISR) Overlay 2 Raw Interrupt Status Register */
#define LCDC_LCDISR_HEO (0x1u << 11) /**< \brief (LCDC_LCDISR) High End Overlay Raw Interrupt Status Register */
/* -------- LCDC_BASECHER : (LCDC Offset: 0x00000040) Base Layer Channel Enable Register -------- */
#define LCDC_BASECHER_CHEN (0x1u << 0) /**< \brief (LCDC_BASECHER) Channel Enable Register */
#define LCDC_BASECHER_UPDATEEN (0x1u << 1) /**< \brief (LCDC_BASECHER) Update Overlay Attributes Enable Register */
#define LCDC_BASECHER_A2QEN (0x1u << 2) /**< \brief (LCDC_BASECHER) Add Head Pointer Enable Register */
/* -------- LCDC_BASECHDR : (LCDC Offset: 0x00000044) Base Layer Channel Disable Register -------- */
#define LCDC_BASECHDR_CHDIS (0x1u << 0) /**< \brief (LCDC_BASECHDR) Channel Disable Register */
#define LCDC_BASECHDR_CHRST (0x1u << 8) /**< \brief (LCDC_BASECHDR) Channel Reset Register */
/* -------- LCDC_BASECHSR : (LCDC Offset: 0x00000048) Base Layer Channel Status Register -------- */
#define LCDC_BASECHSR_CHSR (0x1u << 0) /**< \brief (LCDC_BASECHSR) Channel Status Register */
#define LCDC_BASECHSR_UPDATESR (0x1u << 1) /**< \brief (LCDC_BASECHSR) Update Overlay Attributes In Progress */
#define LCDC_BASECHSR_A2QSR (0x1u << 2) /**< \brief (LCDC_BASECHSR) Add To Queue Pending Register */
/* -------- LCDC_BASEIER : (LCDC Offset: 0x0000004C) Base Layer Interrupt Enable Register -------- */
#define LCDC_BASEIER_DMA (0x1u << 2) /**< \brief (LCDC_BASEIER) End of DMA Transfer Interrupt Enable Register */
#define LCDC_BASEIER_DSCR (0x1u << 3) /**< \brief (LCDC_BASEIER) Descriptor Loaded Interrupt Enable Register */
#define LCDC_BASEIER_ADD (0x1u << 4) /**< \brief (LCDC_BASEIER) Head Descriptor Loaded Interrupt Enable Register */
#define LCDC_BASEIER_DONE (0x1u << 5) /**< \brief (LCDC_BASEIER) End of List Interrupt Enable Register */
#define LCDC_BASEIER_OVR (0x1u << 6) /**< \brief (LCDC_BASEIER) Overflow Interrupt Enable Register */
/* -------- LCDC_BASEIDR : (LCDC Offset: 0x00000050) Base Layer Interrupt Disabled Register -------- */
#define LCDC_BASEIDR_DMA (0x1u << 2) /**< \brief (LCDC_BASEIDR) End of DMA Transfer Interrupt Disable Register */
#define LCDC_BASEIDR_DSCR (0x1u << 3) /**< \brief (LCDC_BASEIDR) Descriptor Loaded Interrupt Disable Register */
#define LCDC_BASEIDR_ADD (0x1u << 4) /**< \brief (LCDC_BASEIDR) Head Descriptor Loaded Interrupt Disable Register */
#define LCDC_BASEIDR_DONE (0x1u << 5) /**< \brief (LCDC_BASEIDR) End of List Interrupt Disable Register */
#define LCDC_BASEIDR_OVR (0x1u << 6) /**< \brief (LCDC_BASEIDR) Overflow Interrupt Disable Register */
/* -------- LCDC_BASEIMR : (LCDC Offset: 0x00000054) Base Layer Interrupt Mask Register -------- */
#define LCDC_BASEIMR_DMA (0x1u << 2) /**< \brief (LCDC_BASEIMR) End of DMA Transfer Interrupt Mask Register */
#define LCDC_BASEIMR_DSCR (0x1u << 3) /**< \brief (LCDC_BASEIMR) Descriptor Loaded Interrupt Mask Register */
#define LCDC_BASEIMR_ADD (0x1u << 4) /**< \brief (LCDC_BASEIMR) Head Descriptor Loaded Interrupt Mask Register */
#define LCDC_BASEIMR_DONE (0x1u << 5) /**< \brief (LCDC_BASEIMR) End of List Interrupt Mask Register */
#define LCDC_BASEIMR_OVR (0x1u << 6) /**< \brief (LCDC_BASEIMR) Overflow Interrupt Mask Register */
/* -------- LCDC_BASEISR : (LCDC Offset: 0x00000058) Base Layer Interrupt status Register -------- */
#define LCDC_BASEISR_DMA (0x1u << 2) /**< \brief (LCDC_BASEISR) End of DMA Transfer */
#define LCDC_BASEISR_DSCR (0x1u << 3) /**< \brief (LCDC_BASEISR) DMA Descriptor Loaded */
#define LCDC_BASEISR_ADD (0x1u << 4) /**< \brief (LCDC_BASEISR) Head Descriptor Loaded */
#define LCDC_BASEISR_DONE (0x1u << 5) /**< \brief (LCDC_BASEISR) End of List Detected */
#define LCDC_BASEISR_OVR (0x1u << 6) /**< \brief (LCDC_BASEISR) Overflow Detected */
/* -------- LCDC_BASEHEAD : (LCDC Offset: 0x0000005C) Base DMA Head Register -------- */
#define LCDC_BASEHEAD_HEAD_Pos 2
#define LCDC_BASEHEAD_HEAD_Msk (0x3fffffffu << LCDC_BASEHEAD_HEAD_Pos) /**< \brief (LCDC_BASEHEAD) DMA Head Pointer */
#define LCDC_BASEHEAD_HEAD(value) ((LCDC_BASEHEAD_HEAD_Msk & ((value) << LCDC_BASEHEAD_HEAD_Pos)))
/* -------- LCDC_BASEADDR : (LCDC Offset: 0x00000060) Base DMA Address Register -------- */
#define LCDC_BASEADDR_ADDR_Pos 0
#define LCDC_BASEADDR_ADDR_Msk (0xffffffffu << LCDC_BASEADDR_ADDR_Pos) /**< \brief (LCDC_BASEADDR) DMA Transfer Start Address */
#define LCDC_BASEADDR_ADDR(value) ((LCDC_BASEADDR_ADDR_Msk & ((value) << LCDC_BASEADDR_ADDR_Pos)))
/* -------- LCDC_BASECTRL : (LCDC Offset: 0x00000064) Base DMA Control Register -------- */
#define LCDC_BASECTRL_DFETCH (0x1u << 0) /**< \brief (LCDC_BASECTRL) Transfer Descriptor Fetch Enable */
#define LCDC_BASECTRL_LFETCH (0x1u << 1) /**< \brief (LCDC_BASECTRL) Lookup Table Fetch Enable */
#define LCDC_BASECTRL_DMAIEN (0x1u << 2) /**< \brief (LCDC_BASECTRL) End of DMA Transfer Interrupt Enable */
#define LCDC_BASECTRL_DSCRIEN (0x1u << 3) /**< \brief (LCDC_BASECTRL) Descriptor Loaded Interrupt Enable */
#define LCDC_BASECTRL_ADDIEN (0x1u << 4) /**< \brief (LCDC_BASECTRL) Add Head Descriptor to Queue Interrupt Enable */
#define LCDC_BASECTRL_DONEIEN (0x1u << 5) /**< \brief (LCDC_BASECTRL) End of List Interrupt Enable */
/* -------- LCDC_BASENEXT : (LCDC Offset: 0x00000068) Base DMA Next Register -------- */
#define LCDC_BASENEXT_NEXT_Pos 0
#define LCDC_BASENEXT_NEXT_Msk (0xffffffffu << LCDC_BASENEXT_NEXT_Pos) /**< \brief (LCDC_BASENEXT) DMA Descriptor Next Address */
#define LCDC_BASENEXT_NEXT(value) ((LCDC_BASENEXT_NEXT_Msk & ((value) << LCDC_BASENEXT_NEXT_Pos)))
/* -------- LCDC_BASECFG0 : (LCDC Offset: 0x0000006C) Base Configuration register 0 -------- */
#define LCDC_BASECFG0_SIF (0x1u << 0) /**< \brief (LCDC_BASECFG0) Source Interface */
#define LCDC_BASECFG0_BLEN_Pos 4
#define LCDC_BASECFG0_BLEN_Msk (0x3u << LCDC_BASECFG0_BLEN_Pos) /**< \brief (LCDC_BASECFG0) AHB Burst Length */
#define   LCDC_BASECFG0_BLEN_AHB_SINGLE (0x0u << 4) /**< \brief (LCDC_BASECFG0) AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_BASECFG0_BLEN_AHB_INCR4 (0x1u << 4) /**< \brief (LCDC_BASECFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_BASECFG0_BLEN_AHB_INCR8 (0x2u << 4) /**< \brief (LCDC_BASECFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_BASECFG0_BLEN_AHB_INCR16 (0x3u << 4) /**< \brief (LCDC_BASECFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define LCDC_BASECFG0_DLBO (0x1u << 8) /**< \brief (LCDC_BASECFG0) Defined Length Burst Only For Channel Bus Transaction. */
/* -------- LCDC_BASECFG1 : (LCDC Offset: 0x00000070) Base Configuration register 1 -------- */
#define LCDC_BASECFG1_CLUTEN (0x1u << 0) /**< \brief (LCDC_BASECFG1) Color Lookup Table Enable */
#define LCDC_BASECFG1_RGBMODE_Pos 4
#define LCDC_BASECFG1_RGBMODE_Msk (0xfu << LCDC_BASECFG1_RGBMODE_Pos) /**< \brief (LCDC_BASECFG1) RGB Input Mode Selection */
#define   LCDC_BASECFG1_RGBMODE_12BPP_RGB_444 (0x0u << 4) /**< \brief (LCDC_BASECFG1) 12 bpp RGB 444 */
#define   LCDC_BASECFG1_RGBMODE_16BPP_ARGB_4444 (0x1u << 4) /**< \brief (LCDC_BASECFG1) 16 bpp ARGB 4444 */
#define   LCDC_BASECFG1_RGBMODE_16BPP_RGBA_4444 (0x2u << 4) /**< \brief (LCDC_BASECFG1) 16 bpp RGBA 4444 */
#define   LCDC_BASECFG1_RGBMODE_16BPP_RGB_565 (0x3u << 4) /**< \brief (LCDC_BASECFG1) 16 bpp RGB 565 */
#define   LCDC_BASECFG1_RGBMODE_16BPP_TRGB_1555 (0x4u << 4) /**< \brief (LCDC_BASECFG1) 16 bpp TRGB 1555 */
#define   LCDC_BASECFG1_RGBMODE_18BPP_RGB_666 (0x5u << 4) /**< \brief (LCDC_BASECFG1) 18 bpp RGB 666 */
#define   LCDC_BASECFG1_RGBMODE_18BPP_RGB_666PACKED (0x6u << 4) /**< \brief (LCDC_BASECFG1) 18 bpp RGB 666 PACKED */
#define   LCDC_BASECFG1_RGBMODE_19BPP_TRGB_1666 (0x7u << 4) /**< \brief (LCDC_BASECFG1) 19 bpp TRGB 1666 */
#define   LCDC_BASECFG1_RGBMODE_19BPP_TRGB_PACKED (0x8u << 4) /**< \brief (LCDC_BASECFG1) 19 bpp TRGB 1666 PACKED */
#define   LCDC_BASECFG1_RGBMODE_24BPP_RGB_888 (0x9u << 4) /**< \brief (LCDC_BASECFG1) 24 bpp RGB 888 */
#define   LCDC_BASECFG1_RGBMODE_24BPP_RGB_888_PACKED (0xAu << 4) /**< \brief (LCDC_BASECFG1) 24 bpp RGB 888 PACKED */
#define   LCDC_BASECFG1_RGBMODE_25BPP_TRGB_1888 (0xBu << 4) /**< \brief (LCDC_BASECFG1) 25 bpp TRGB 1888 */
#define   LCDC_BASECFG1_RGBMODE_32BPP_ARGB_8888 (0xCu << 4) /**< \brief (LCDC_BASECFG1) 32 bpp ARGB 8888 */
#define   LCDC_BASECFG1_RGBMODE_32BPP_RGBA_8888 (0xDu << 4) /**< \brief (LCDC_BASECFG1) 32 bpp RGBA 8888 */
#define LCDC_BASECFG1_CLUTMODE_Pos 8
#define LCDC_BASECFG1_CLUTMODE_Msk (0x3u << LCDC_BASECFG1_CLUTMODE_Pos) /**< \brief (LCDC_BASECFG1) Color Lookup Table Input Mode Selection */
#define   LCDC_BASECFG1_CLUTMODE_CLUT_1BPP (0x0u << 8) /**< \brief (LCDC_BASECFG1) color lookup table mode set to 1 bit per pixel */
#define   LCDC_BASECFG1_CLUTMODE_CLUT_2BPP (0x1u << 8) /**< \brief (LCDC_BASECFG1) color lookup table mode set to 2 bits per pixel */
#define   LCDC_BASECFG1_CLUTMODE_CLUT_4BPP (0x2u << 8) /**< \brief (LCDC_BASECFG1) color lookup table mode set to 4 bits per pixel */
#define   LCDC_BASECFG1_CLUTMODE_CLUT_8BPP (0x3u << 8) /**< \brief (LCDC_BASECFG1) color lookup table mode set to 8 bits per pixel */
/* -------- LCDC_BASECFG2 : (LCDC Offset: 0x00000074) Base Configuration register 2 -------- */
#define LCDC_BASECFG2_XSTRIDE_Pos 0
#define LCDC_BASECFG2_XSTRIDE_Msk (0xffffffffu << LCDC_BASECFG2_XSTRIDE_Pos) /**< \brief (LCDC_BASECFG2) Horizontal Stride */
#define LCDC_BASECFG2_XSTRIDE(value) ((LCDC_BASECFG2_XSTRIDE_Msk & ((value) << LCDC_BASECFG2_XSTRIDE_Pos)))
/* -------- LCDC_BASECFG3 : (LCDC Offset: 0x00000078) Base Configuration register 3 -------- */
#define LCDC_BASECFG3_BDEF_Pos 0
#define LCDC_BASECFG3_BDEF_Msk (0xffu << LCDC_BASECFG3_BDEF_Pos) /**< \brief (LCDC_BASECFG3) Blue Default */
#define LCDC_BASECFG3_BDEF(value) ((LCDC_BASECFG3_BDEF_Msk & ((value) << LCDC_BASECFG3_BDEF_Pos)))
#define LCDC_BASECFG3_GDEF_Pos 8
#define LCDC_BASECFG3_GDEF_Msk (0xffu << LCDC_BASECFG3_GDEF_Pos) /**< \brief (LCDC_BASECFG3) Green Default */
#define LCDC_BASECFG3_GDEF(value) ((LCDC_BASECFG3_GDEF_Msk & ((value) << LCDC_BASECFG3_GDEF_Pos)))
#define LCDC_BASECFG3_RDEF_Pos 16
#define LCDC_BASECFG3_RDEF_Msk (0xffu << LCDC_BASECFG3_RDEF_Pos) /**< \brief (LCDC_BASECFG3) Red Default */
#define LCDC_BASECFG3_RDEF(value) ((LCDC_BASECFG3_RDEF_Msk & ((value) << LCDC_BASECFG3_RDEF_Pos)))
/* -------- LCDC_BASECFG4 : (LCDC Offset: 0x0000007C) Base Configuration register 4 -------- */
#define LCDC_BASECFG4_DMA (0x1u << 8) /**< \brief (LCDC_BASECFG4) Use DMA Data Path */
#define LCDC_BASECFG4_REP (0x1u << 9) /**< \brief (LCDC_BASECFG4) Use Replication logic to expand RGB color to 24 bits */
#define LCDC_BASECFG4_DISCEN (0x1u << 11) /**< \brief (LCDC_BASECFG4) Discard Area Enable */
/* -------- LCDC_BASECFG5 : (LCDC Offset: 0x00000080) Base Configuration register 5 -------- */
#define LCDC_BASECFG5_DISCXPOS_Pos 0
#define LCDC_BASECFG5_DISCXPOS_Msk (0x7ffu << LCDC_BASECFG5_DISCXPOS_Pos) /**< \brief (LCDC_BASECFG5) Discard Area horizontal coordinate */
#define LCDC_BASECFG5_DISCXPOS(value) ((LCDC_BASECFG5_DISCXPOS_Msk & ((value) << LCDC_BASECFG5_DISCXPOS_Pos)))
#define LCDC_BASECFG5_DISCYPOS_Pos 16
#define LCDC_BASECFG5_DISCYPOS_Msk (0x7ffu << LCDC_BASECFG5_DISCYPOS_Pos) /**< \brief (LCDC_BASECFG5) Discard Area Vertical coordinate */
#define LCDC_BASECFG5_DISCYPOS(value) ((LCDC_BASECFG5_DISCYPOS_Msk & ((value) << LCDC_BASECFG5_DISCYPOS_Pos)))
/* -------- LCDC_BASECFG6 : (LCDC Offset: 0x00000084) Base Configuration register 6 -------- */
#define LCDC_BASECFG6_DISCXSIZE_Pos 0
#define LCDC_BASECFG6_DISCXSIZE_Msk (0x7ffu << LCDC_BASECFG6_DISCXSIZE_Pos) /**< \brief (LCDC_BASECFG6) Discard Area Horizontal Size */
#define LCDC_BASECFG6_DISCXSIZE(value) ((LCDC_BASECFG6_DISCXSIZE_Msk & ((value) << LCDC_BASECFG6_DISCXSIZE_Pos)))
#define LCDC_BASECFG6_DISCYSIZE_Pos 16
#define LCDC_BASECFG6_DISCYSIZE_Msk (0x7ffu << LCDC_BASECFG6_DISCYSIZE_Pos) /**< \brief (LCDC_BASECFG6) Discard Area Vertical Size */
#define LCDC_BASECFG6_DISCYSIZE(value) ((LCDC_BASECFG6_DISCYSIZE_Msk & ((value) << LCDC_BASECFG6_DISCYSIZE_Pos)))
/* -------- LCDC_OVRCHER1 : (LCDC Offset: 0x00000140) Overlay 1 Channel Enable Register -------- */
#define LCDC_OVRCHER1_CHEN (0x1u << 0) /**< \brief (LCDC_OVRCHER1) Channel Enable Register */
#define LCDC_OVRCHER1_UPDATEEN (0x1u << 1) /**< \brief (LCDC_OVRCHER1) Update Overlay Attributes Enable Register */
#define LCDC_OVRCHER1_A2QEN (0x1u << 2) /**< \brief (LCDC_OVRCHER1) Add Head Pointer Enable Register */
/* -------- LCDC_OVRCHDR1 : (LCDC Offset: 0x00000144) Overlay 1 Channel Disable Register -------- */
#define LCDC_OVRCHDR1_CHDIS (0x1u << 0) /**< \brief (LCDC_OVRCHDR1) Channel Disable Register */
#define LCDC_OVRCHDR1_CHRST (0x1u << 8) /**< \brief (LCDC_OVRCHDR1) Channel Reset Register */
/* -------- LCDC_OVRCHSR1 : (LCDC Offset: 0x00000148) Overlay 1 Channel Status Register -------- */
#define LCDC_OVRCHSR1_CHSR (0x1u << 0) /**< \brief (LCDC_OVRCHSR1) Channel Status Register */
#define LCDC_OVRCHSR1_UPDATESR (0x1u << 1) /**< \brief (LCDC_OVRCHSR1) Update Overlay Attributes In Progress */
#define LCDC_OVRCHSR1_A2QSR (0x1u << 2) /**< \brief (LCDC_OVRCHSR1) Add to Queue Pending Register */
/* -------- LCDC_OVRIER1 : (LCDC Offset: 0x0000014C) Overlay 1 Interrupt Enable Register -------- */
#define LCDC_OVRIER1_DMA (0x1u << 2) /**< \brief (LCDC_OVRIER1) End of DMA Transfer Interrupt Enable Register */
#define LCDC_OVRIER1_DSCR (0x1u << 3) /**< \brief (LCDC_OVRIER1) Descriptor Loaded Interrupt Enable Register */
#define LCDC_OVRIER1_ADD (0x1u << 4) /**< \brief (LCDC_OVRIER1) Head Descriptor Loaded Interrupt Enable Register */
#define LCDC_OVRIER1_DONE (0x1u << 5) /**< \brief (LCDC_OVRIER1) End of List Interrupt Enable Register */
#define LCDC_OVRIER1_OVR (0x1u << 6) /**< \brief (LCDC_OVRIER1) Overflow Interrupt Enable Register */
/* -------- LCDC_OVRIDR1 : (LCDC Offset: 0x00000150) Overlay 1 Interrupt Disable Register -------- */
#define LCDC_OVRIDR1_DMA (0x1u << 2) /**< \brief (LCDC_OVRIDR1) End of DMA Transfer Interrupt Disable Register */
#define LCDC_OVRIDR1_DSCR (0x1u << 3) /**< \brief (LCDC_OVRIDR1) Descriptor Loaded Interrupt Disable Register */
#define LCDC_OVRIDR1_ADD (0x1u << 4) /**< \brief (LCDC_OVRIDR1) Head Descriptor Loaded Interrupt Disable Register */
#define LCDC_OVRIDR1_DONE (0x1u << 5) /**< \brief (LCDC_OVRIDR1) End of List Interrupt Disable Register */
#define LCDC_OVRIDR1_OVR (0x1u << 6) /**< \brief (LCDC_OVRIDR1) Overflow Interrupt Disable Register */
/* -------- LCDC_OVRIMR1 : (LCDC Offset: 0x00000154) Overlay 1 Interrupt Mask Register -------- */
#define LCDC_OVRIMR1_DMA (0x1u << 2) /**< \brief (LCDC_OVRIMR1) End of DMA Transfer Interrupt Mask Register */
#define LCDC_OVRIMR1_DSCR (0x1u << 3) /**< \brief (LCDC_OVRIMR1) Descriptor Loaded Interrupt Mask Register */
#define LCDC_OVRIMR1_ADD (0x1u << 4) /**< \brief (LCDC_OVRIMR1) Head Descriptor Loaded Interrupt Mask Register */
#define LCDC_OVRIMR1_DONE (0x1u << 5) /**< \brief (LCDC_OVRIMR1) End of List Interrupt Mask Register */
#define LCDC_OVRIMR1_OVR (0x1u << 6) /**< \brief (LCDC_OVRIMR1) Overflow Interrupt Mask Register */
/* -------- LCDC_OVRISR1 : (LCDC Offset: 0x00000158) Overlay 1 Interrupt Status Register -------- */
#define LCDC_OVRISR1_DMA (0x1u << 2) /**< \brief (LCDC_OVRISR1) End of DMA Transfer */
#define LCDC_OVRISR1_DSCR (0x1u << 3) /**< \brief (LCDC_OVRISR1) DMA Descriptor Loaded */
#define LCDC_OVRISR1_ADD (0x1u << 4) /**< \brief (LCDC_OVRISR1) Head Descriptor Loaded */
#define LCDC_OVRISR1_DONE (0x1u << 5) /**< \brief (LCDC_OVRISR1) End of List Detected Register */
#define LCDC_OVRISR1_OVR (0x1u << 6) /**< \brief (LCDC_OVRISR1) Overflow Detected */
/* -------- LCDC_OVRHEAD1 : (LCDC Offset: 0x0000015C) Overlay 1 DMA Head Register -------- */
#define LCDC_OVRHEAD1_HEAD_Pos 2
#define LCDC_OVRHEAD1_HEAD_Msk (0x3fffffffu << LCDC_OVRHEAD1_HEAD_Pos) /**< \brief (LCDC_OVRHEAD1) DMA Head Pointer */
#define LCDC_OVRHEAD1_HEAD(value) ((LCDC_OVRHEAD1_HEAD_Msk & ((value) << LCDC_OVRHEAD1_HEAD_Pos)))
/* -------- LCDC_OVRADDR1 : (LCDC Offset: 0x00000160) Overlay 1 DMA Address Register -------- */
#define LCDC_OVRADDR1_ADDR_Pos 0
#define LCDC_OVRADDR1_ADDR_Msk (0xffffffffu << LCDC_OVRADDR1_ADDR_Pos) /**< \brief (LCDC_OVRADDR1) DMA Transfer Overlay 1 Address */
#define LCDC_OVRADDR1_ADDR(value) ((LCDC_OVRADDR1_ADDR_Msk & ((value) << LCDC_OVRADDR1_ADDR_Pos)))
/* -------- LCDC_OVRCTRL1 : (LCDC Offset: 0x00000164) Overlay 1 DMA Control Register -------- */
#define LCDC_OVRCTRL1_DFETCH (0x1u << 0) /**< \brief (LCDC_OVRCTRL1) Transfer Descriptor Fetch Enable */
#define LCDC_OVRCTRL1_LFETCH (0x1u << 1) /**< \brief (LCDC_OVRCTRL1) Lookup Table Fetch Enable */
#define LCDC_OVRCTRL1_DMAIEN (0x1u << 2) /**< \brief (LCDC_OVRCTRL1) End of DMA Transfer Interrupt Enable */
#define LCDC_OVRCTRL1_DSCRIEN (0x1u << 3) /**< \brief (LCDC_OVRCTRL1) Descriptor Loaded Interrupt Enable */
#define LCDC_OVRCTRL1_ADDIEN (0x1u << 4) /**< \brief (LCDC_OVRCTRL1) Add Head Descriptor to Queue Interrupt Enable */
#define LCDC_OVRCTRL1_DONEIEN (0x1u << 5) /**< \brief (LCDC_OVRCTRL1) End of List Interrupt Enable */
/* -------- LCDC_OVRNEXT1 : (LCDC Offset: 0x00000168) Overlay 1 DMA Next Register -------- */
#define LCDC_OVRNEXT1_NEXT_Pos 0
#define LCDC_OVRNEXT1_NEXT_Msk (0xffffffffu << LCDC_OVRNEXT1_NEXT_Pos) /**< \brief (LCDC_OVRNEXT1) DMA Descriptor Next Address */
#define LCDC_OVRNEXT1_NEXT(value) ((LCDC_OVRNEXT1_NEXT_Msk & ((value) << LCDC_OVRNEXT1_NEXT_Pos)))
/* -------- LCDC_OVR1CFG0 : (LCDC Offset: 0x0000016C) Overlay 1 Configuration 0 Register -------- */
#define LCDC_OVR1CFG0_SIF (0x1u << 0) /**< \brief (LCDC_OVR1CFG0) Source Interface */
#define LCDC_OVR1CFG0_BLEN_Pos 4
#define LCDC_OVR1CFG0_BLEN_Msk (0x3u << LCDC_OVR1CFG0_BLEN_Pos) /**< \brief (LCDC_OVR1CFG0) AHB Burst Length */
#define   LCDC_OVR1CFG0_BLEN_AHB_BLEN_SINGLE (0x0u << 4) /**< \brief (LCDC_OVR1CFG0) AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_OVR1CFG0_BLEN_AHB_BLEN_INCR4 (0x1u << 4) /**< \brief (LCDC_OVR1CFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_OVR1CFG0_BLEN_AHB_BLEN_INCR8 (0x2u << 4) /**< \brief (LCDC_OVR1CFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_OVR1CFG0_BLEN_AHB_BLEN_INCR16 (0x3u << 4) /**< \brief (LCDC_OVR1CFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define LCDC_OVR1CFG0_DLBO (0x1u << 8) /**< \brief (LCDC_OVR1CFG0) Defined Length Burst Only for Channel Bus Transaction. */
#define LCDC_OVR1CFG0_ROTDIS (0x1u << 12) /**< \brief (LCDC_OVR1CFG0) Hardware Rotation Optimization Disable */
#define LCDC_OVR1CFG0_LOCKDIS (0x1u << 13) /**< \brief (LCDC_OVR1CFG0) Hardware Rotation Lock Disable */
/* -------- LCDC_OVR1CFG1 : (LCDC Offset: 0x00000170) Overlay 1 Configuration 1 Register -------- */
#define LCDC_OVR1CFG1_CLUTEN (0x1u << 0) /**< \brief (LCDC_OVR1CFG1) Color Lookup Table Enable */
#define LCDC_OVR1CFG1_RGBMODE_Pos 4
#define LCDC_OVR1CFG1_RGBMODE_Msk (0xfu << LCDC_OVR1CFG1_RGBMODE_Pos) /**< \brief (LCDC_OVR1CFG1) RGB Input Mode Selection */
#define   LCDC_OVR1CFG1_RGBMODE_12BPP_RGB_444 (0x0u << 4) /**< \brief (LCDC_OVR1CFG1) 12 bpp RGB 444 */
#define   LCDC_OVR1CFG1_RGBMODE_16BPP_ARGB_4444 (0x1u << 4) /**< \brief (LCDC_OVR1CFG1) 16 bpp ARGB 4444 */
#define   LCDC_OVR1CFG1_RGBMODE_16BPP_RGBA_4444 (0x2u << 4) /**< \brief (LCDC_OVR1CFG1) 16 bpp RGBA 4444 */
#define   LCDC_OVR1CFG1_RGBMODE_16BPP_RGB_565 (0x3u << 4) /**< \brief (LCDC_OVR1CFG1) 16 bpp RGB 565 */
#define   LCDC_OVR1CFG1_RGBMODE_16BPP_TRGB_1555 (0x4u << 4) /**< \brief (LCDC_OVR1CFG1) 16 bpp TRGB 1555 */
#define   LCDC_OVR1CFG1_RGBMODE_18BPP_RGB_666 (0x5u << 4) /**< \brief (LCDC_OVR1CFG1) 18 bpp RGB 666 */
#define   LCDC_OVR1CFG1_RGBMODE_18BPP_RGB_666PACKED (0x6u << 4) /**< \brief (LCDC_OVR1CFG1) 18 bpp RGB 666 PACKED */
#define   LCDC_OVR1CFG1_RGBMODE_19BPP_TRGB_1666 (0x7u << 4) /**< \brief (LCDC_OVR1CFG1) 19 bpp TRGB 1666 */
#define   LCDC_OVR1CFG1_RGBMODE_19BPP_TRGB_PACKED (0x8u << 4) /**< \brief (LCDC_OVR1CFG1) 19 bpp TRGB 1666 PACKED */
#define   LCDC_OVR1CFG1_RGBMODE_24BPP_RGB_888 (0x9u << 4) /**< \brief (LCDC_OVR1CFG1) 24 bpp RGB 888 */
#define   LCDC_OVR1CFG1_RGBMODE_24BPP_RGB_888_PACKED (0xAu << 4) /**< \brief (LCDC_OVR1CFG1) 24 bpp RGB 888 PACKED */
#define   LCDC_OVR1CFG1_RGBMODE_25BPP_TRGB_1888 (0xBu << 4) /**< \brief (LCDC_OVR1CFG1) 25 bpp TRGB 1888 */
#define   LCDC_OVR1CFG1_RGBMODE_32BPP_ARGB_8888 (0xCu << 4) /**< \brief (LCDC_OVR1CFG1) 32 bpp ARGB 8888 */
#define   LCDC_OVR1CFG1_RGBMODE_32BPP_RGBA_8888 (0xDu << 4) /**< \brief (LCDC_OVR1CFG1) 32 bpp RGBA 8888 */
#define LCDC_OVR1CFG1_CLUTMODE_Pos 8
#define LCDC_OVR1CFG1_CLUTMODE_Msk (0x3u << LCDC_OVR1CFG1_CLUTMODE_Pos) /**< \brief (LCDC_OVR1CFG1) Color Lookup table input mode selection */
#define   LCDC_OVR1CFG1_CLUTMODE_CLUT_1BPP (0x0u << 8) /**< \brief (LCDC_OVR1CFG1) color lookup table mode set to 1 bit per pixel */
#define   LCDC_OVR1CFG1_CLUTMODE_CLUT_2BPP (0x1u << 8) /**< \brief (LCDC_OVR1CFG1) color lookup table mode set to 2 bits per pixel */
#define   LCDC_OVR1CFG1_CLUTMODE_CLUT_4BPP (0x2u << 8) /**< \brief (LCDC_OVR1CFG1) color lookup table mode set to 4 bits per pixel */
#define   LCDC_OVR1CFG1_CLUTMODE_CLUT_8BPP (0x3u << 8) /**< \brief (LCDC_OVR1CFG1) color lookup table mode set to 8 bits per pixel */
/* -------- LCDC_OVR1CFG2 : (LCDC Offset: 0x00000174) Overlay 1 Configuration 2 Register -------- */
#define LCDC_OVR1CFG2_XPOS_Pos 0
#define LCDC_OVR1CFG2_XPOS_Msk (0x7ffu << LCDC_OVR1CFG2_XPOS_Pos) /**< \brief (LCDC_OVR1CFG2) Horizontal Window Position */
#define LCDC_OVR1CFG2_XPOS(value) ((LCDC_OVR1CFG2_XPOS_Msk & ((value) << LCDC_OVR1CFG2_XPOS_Pos)))
#define LCDC_OVR1CFG2_YPOS_Pos 16
#define LCDC_OVR1CFG2_YPOS_Msk (0x7ffu << LCDC_OVR1CFG2_YPOS_Pos) /**< \brief (LCDC_OVR1CFG2) Vertical Window Position */
#define LCDC_OVR1CFG2_YPOS(value) ((LCDC_OVR1CFG2_YPOS_Msk & ((value) << LCDC_OVR1CFG2_YPOS_Pos)))
/* -------- LCDC_OVR1CFG3 : (LCDC Offset: 0x00000178) Overlay 1 Configuration 3 Register -------- */
#define LCDC_OVR1CFG3_XSIZE_Pos 0
#define LCDC_OVR1CFG3_XSIZE_Msk (0x7ffu << LCDC_OVR1CFG3_XSIZE_Pos) /**< \brief (LCDC_OVR1CFG3) Horizontal Window Size */
#define LCDC_OVR1CFG3_XSIZE(value) ((LCDC_OVR1CFG3_XSIZE_Msk & ((value) << LCDC_OVR1CFG3_XSIZE_Pos)))
#define LCDC_OVR1CFG3_YSIZE_Pos 16
#define LCDC_OVR1CFG3_YSIZE_Msk (0x7ffu << LCDC_OVR1CFG3_YSIZE_Pos) /**< \brief (LCDC_OVR1CFG3) Vertical Window Size */
#define LCDC_OVR1CFG3_YSIZE(value) ((LCDC_OVR1CFG3_YSIZE_Msk & ((value) << LCDC_OVR1CFG3_YSIZE_Pos)))
/* -------- LCDC_OVR1CFG4 : (LCDC Offset: 0x0000017C) Overlay 1 Configuration 4 Register -------- */
#define LCDC_OVR1CFG4_XSTRIDE_Pos 0
#define LCDC_OVR1CFG4_XSTRIDE_Msk (0xffffffffu << LCDC_OVR1CFG4_XSTRIDE_Pos) /**< \brief (LCDC_OVR1CFG4) Horizontal Stride */
#define LCDC_OVR1CFG4_XSTRIDE(value) ((LCDC_OVR1CFG4_XSTRIDE_Msk & ((value) << LCDC_OVR1CFG4_XSTRIDE_Pos)))
/* -------- LCDC_OVR1CFG5 : (LCDC Offset: 0x00000180) Overlay 1 Configuration 5 Register -------- */
#define LCDC_OVR1CFG5_PSTRIDE_Pos 0
#define LCDC_OVR1CFG5_PSTRIDE_Msk (0xffffffffu << LCDC_OVR1CFG5_PSTRIDE_Pos) /**< \brief (LCDC_OVR1CFG5) Pixel Stride */
#define LCDC_OVR1CFG5_PSTRIDE(value) ((LCDC_OVR1CFG5_PSTRIDE_Msk & ((value) << LCDC_OVR1CFG5_PSTRIDE_Pos)))
/* -------- LCDC_OVR1CFG6 : (LCDC Offset: 0x00000184) Overlay 1 Configuration 6 Register -------- */
#define LCDC_OVR1CFG6_BDEF_Pos 0
#define LCDC_OVR1CFG6_BDEF_Msk (0xffu << LCDC_OVR1CFG6_BDEF_Pos) /**< \brief (LCDC_OVR1CFG6) Blue Default */
#define LCDC_OVR1CFG6_BDEF(value) ((LCDC_OVR1CFG6_BDEF_Msk & ((value) << LCDC_OVR1CFG6_BDEF_Pos)))
#define LCDC_OVR1CFG6_GDEF_Pos 8
#define LCDC_OVR1CFG6_GDEF_Msk (0xffu << LCDC_OVR1CFG6_GDEF_Pos) /**< \brief (LCDC_OVR1CFG6) Green Default */
#define LCDC_OVR1CFG6_GDEF(value) ((LCDC_OVR1CFG6_GDEF_Msk & ((value) << LCDC_OVR1CFG6_GDEF_Pos)))
#define LCDC_OVR1CFG6_RDEF_Pos 16
#define LCDC_OVR1CFG6_RDEF_Msk (0xffu << LCDC_OVR1CFG6_RDEF_Pos) /**< \brief (LCDC_OVR1CFG6) Red Default */
#define LCDC_OVR1CFG6_RDEF(value) ((LCDC_OVR1CFG6_RDEF_Msk & ((value) << LCDC_OVR1CFG6_RDEF_Pos)))
/* -------- LCDC_OVR1CFG7 : (LCDC Offset: 0x00000188) Overlay 1 Configuration 7 Register -------- */
#define LCDC_OVR1CFG7_BKEY_Pos 0
#define LCDC_OVR1CFG7_BKEY_Msk (0xffu << LCDC_OVR1CFG7_BKEY_Pos) /**< \brief (LCDC_OVR1CFG7) Blue Color Component Chroma Key */
#define LCDC_OVR1CFG7_BKEY(value) ((LCDC_OVR1CFG7_BKEY_Msk & ((value) << LCDC_OVR1CFG7_BKEY_Pos)))
#define LCDC_OVR1CFG7_GKEY_Pos 8
#define LCDC_OVR1CFG7_GKEY_Msk (0xffu << LCDC_OVR1CFG7_GKEY_Pos) /**< \brief (LCDC_OVR1CFG7) Green Color Component Chroma Key */
#define LCDC_OVR1CFG7_GKEY(value) ((LCDC_OVR1CFG7_GKEY_Msk & ((value) << LCDC_OVR1CFG7_GKEY_Pos)))
#define LCDC_OVR1CFG7_RKEY_Pos 16
#define LCDC_OVR1CFG7_RKEY_Msk (0xffu << LCDC_OVR1CFG7_RKEY_Pos) /**< \brief (LCDC_OVR1CFG7) Red Color Component Chroma Key */
#define LCDC_OVR1CFG7_RKEY(value) ((LCDC_OVR1CFG7_RKEY_Msk & ((value) << LCDC_OVR1CFG7_RKEY_Pos)))
/* -------- LCDC_OVR1CFG8 : (LCDC Offset: 0x0000018C) Overlay 1 Configuration 8Register -------- */
#define LCDC_OVR1CFG8_BMASK_Pos 0
#define LCDC_OVR1CFG8_BMASK_Msk (0xffu << LCDC_OVR1CFG8_BMASK_Pos) /**< \brief (LCDC_OVR1CFG8) Blue Color Component Chroma Key Mask */
#define LCDC_OVR1CFG8_BMASK(value) ((LCDC_OVR1CFG8_BMASK_Msk & ((value) << LCDC_OVR1CFG8_BMASK_Pos)))
#define LCDC_OVR1CFG8_GMASK_Pos 8
#define LCDC_OVR1CFG8_GMASK_Msk (0xffu << LCDC_OVR1CFG8_GMASK_Pos) /**< \brief (LCDC_OVR1CFG8) Green Color Component Chroma Key Mask */
#define LCDC_OVR1CFG8_GMASK(value) ((LCDC_OVR1CFG8_GMASK_Msk & ((value) << LCDC_OVR1CFG8_GMASK_Pos)))
#define LCDC_OVR1CFG8_RMASK_Pos 16
#define LCDC_OVR1CFG8_RMASK_Msk (0xffu << LCDC_OVR1CFG8_RMASK_Pos) /**< \brief (LCDC_OVR1CFG8) Red Color Component Chroma Key Mask */
#define LCDC_OVR1CFG8_RMASK(value) ((LCDC_OVR1CFG8_RMASK_Msk & ((value) << LCDC_OVR1CFG8_RMASK_Pos)))
/* -------- LCDC_OVR1CFG9 : (LCDC Offset: 0x00000190) Overlay 1 Configuration 9 Register -------- */
#define LCDC_OVR1CFG9_CRKEY (0x1u << 0) /**< \brief (LCDC_OVR1CFG9) Blender Chroma Key Enable */
#define LCDC_OVR1CFG9_INV (0x1u << 1) /**< \brief (LCDC_OVR1CFG9) Blender Inverted Blender Output Enable */
#define LCDC_OVR1CFG9_ITER2BL (0x1u << 2) /**< \brief (LCDC_OVR1CFG9) Blender Iterated Color Enable */
#define LCDC_OVR1CFG9_ITER (0x1u << 3) /**< \brief (LCDC_OVR1CFG9) Blender Use Iterated Color */
#define LCDC_OVR1CFG9_REVALPHA (0x1u << 4) /**< \brief (LCDC_OVR1CFG9) Blender Reverse Alpha */
#define LCDC_OVR1CFG9_GAEN (0x1u << 5) /**< \brief (LCDC_OVR1CFG9) Blender Global Alpha Enable */
#define LCDC_OVR1CFG9_LAEN (0x1u << 6) /**< \brief (LCDC_OVR1CFG9) Blender Local Alpha Enable */
#define LCDC_OVR1CFG9_OVR (0x1u << 7) /**< \brief (LCDC_OVR1CFG9) Blender Overlay Layer Enable */
#define LCDC_OVR1CFG9_DMA (0x1u << 8) /**< \brief (LCDC_OVR1CFG9) Blender DMA Layer Enable */
#define LCDC_OVR1CFG9_REP (0x1u << 9) /**< \brief (LCDC_OVR1CFG9) Use Replication logic to expand RGB color to 24 bits */
#define LCDC_OVR1CFG9_DSTKEY (0x1u << 10) /**< \brief (LCDC_OVR1CFG9) Destination Chroma Keying */
#define LCDC_OVR1CFG9_GA_Pos 16
#define LCDC_OVR1CFG9_GA_Msk (0xffu << LCDC_OVR1CFG9_GA_Pos) /**< \brief (LCDC_OVR1CFG9) Blender Global Alpha */
#define LCDC_OVR1CFG9_GA(value) ((LCDC_OVR1CFG9_GA_Msk & ((value) << LCDC_OVR1CFG9_GA_Pos)))
/* -------- LCDC_OVRCHER2 : (LCDC Offset: 0x00000240) Overlay 2 Channel Enable Register -------- */
#define LCDC_OVRCHER2_CHEN (0x1u << 0) /**< \brief (LCDC_OVRCHER2) Channel Enable Register */
#define LCDC_OVRCHER2_UPDATEEN (0x1u << 1) /**< \brief (LCDC_OVRCHER2) Update Overlay Attributes Enable Register */
#define LCDC_OVRCHER2_A2QEN (0x1u << 2) /**< \brief (LCDC_OVRCHER2) Add Head Pointer Enable Register */
/* -------- LCDC_OVRCHDR2 : (LCDC Offset: 0x00000244) Overlay 2 Channel Disable Register -------- */
#define LCDC_OVRCHDR2_CHDIS (0x1u << 0) /**< \brief (LCDC_OVRCHDR2) Channel Disable Register */
#define LCDC_OVRCHDR2_CHRST (0x1u << 8) /**< \brief (LCDC_OVRCHDR2) Channel Reset Register */
/* -------- LCDC_OVRCHSR2 : (LCDC Offset: 0x00000248) Overlay 2 Channel Status Register -------- */
#define LCDC_OVRCHSR2_CHSR (0x1u << 0) /**< \brief (LCDC_OVRCHSR2) Channel Status Register */
#define LCDC_OVRCHSR2_UPDATESR (0x1u << 1) /**< \brief (LCDC_OVRCHSR2) Update Overlay Attributes In Progress */
#define LCDC_OVRCHSR2_A2QSR (0x1u << 2) /**< \brief (LCDC_OVRCHSR2) Add To Queue Pending Register */
/* -------- LCDC_OVRIER2 : (LCDC Offset: 0x0000024C) Overlay 2 Interrupt Enable Register -------- */
#define LCDC_OVRIER2_DMA (0x1u << 2) /**< \brief (LCDC_OVRIER2) End of DMA Transfer Interrupt Enable Register */
#define LCDC_OVRIER2_DSCR (0x1u << 3) /**< \brief (LCDC_OVRIER2) Descriptor Loaded Interrupt Enable Register */
#define LCDC_OVRIER2_ADD (0x1u << 4) /**< \brief (LCDC_OVRIER2) Head Descriptor Loaded Interrupt Enable Register */
#define LCDC_OVRIER2_DONE (0x1u << 5) /**< \brief (LCDC_OVRIER2) End of List Interrupt Enable Register */
#define LCDC_OVRIER2_OVR (0x1u << 6) /**< \brief (LCDC_OVRIER2) Overflow Interrupt Enable Register */
/* -------- LCDC_OVRIDR2 : (LCDC Offset: 0x00000250) Overlay 2 Interrupt Disable Register -------- */
#define LCDC_OVRIDR2_DMA (0x1u << 2) /**< \brief (LCDC_OVRIDR2) End of DMA Transfer Interrupt Disable Register */
#define LCDC_OVRIDR2_DSCR (0x1u << 3) /**< \brief (LCDC_OVRIDR2) Descriptor Loaded Interrupt Disable Register */
#define LCDC_OVRIDR2_ADD (0x1u << 4) /**< \brief (LCDC_OVRIDR2) Head Descriptor Loaded Interrupt Disable Register */
#define LCDC_OVRIDR2_DONE (0x1u << 5) /**< \brief (LCDC_OVRIDR2) End of List Interrupt Disable Register */
#define LCDC_OVRIDR2_OVR (0x1u << 6) /**< \brief (LCDC_OVRIDR2) Overflow Interrupt Disable Register */
/* -------- LCDC_OVRIMR2 : (LCDC Offset: 0x00000254) Overlay 2 Interrupt Mask Register -------- */
#define LCDC_OVRIMR2_DMA (0x1u << 2) /**< \brief (LCDC_OVRIMR2) End of DMA Transfer Interrupt Mask Register */
#define LCDC_OVRIMR2_DSCR (0x1u << 3) /**< \brief (LCDC_OVRIMR2) Descriptor Loaded Interrupt Mask Register */
#define LCDC_OVRIMR2_ADD (0x1u << 4) /**< \brief (LCDC_OVRIMR2) Head Descriptor Loaded Interrupt Mask Register */
#define LCDC_OVRIMR2_DONE (0x1u << 5) /**< \brief (LCDC_OVRIMR2) End of List Interrupt Mask Register */
#define LCDC_OVRIMR2_OVR (0x1u << 6) /**< \brief (LCDC_OVRIMR2) Overflow Interrupt Mask Register */
/* -------- LCDC_OVRISR2 : (LCDC Offset: 0x00000258) Overlay 2 Interrupt status Register -------- */
#define LCDC_OVRISR2_DMA (0x1u << 2) /**< \brief (LCDC_OVRISR2) End of DMA Transfer */
#define LCDC_OVRISR2_DSCR (0x1u << 3) /**< \brief (LCDC_OVRISR2) DMA Descriptor Loaded */
#define LCDC_OVRISR2_ADD (0x1u << 4) /**< \brief (LCDC_OVRISR2) Head Descriptor Loaded Interrupt Disable Register */
#define LCDC_OVRISR2_DONE (0x1u << 5) /**< \brief (LCDC_OVRISR2) End Of List Interrupt Disable Register */
#define LCDC_OVRISR2_OVR (0x1u << 6) /**< \brief (LCDC_OVRISR2) Overflow Detected */
/* -------- LCDC_OVRHEAD2 : (LCDC Offset: 0x0000025C) Overlay 2 DMA Head Register -------- */
#define LCDC_OVRHEAD2_HEAD_Pos 2
#define LCDC_OVRHEAD2_HEAD_Msk (0x3fffffffu << LCDC_OVRHEAD2_HEAD_Pos) /**< \brief (LCDC_OVRHEAD2) DMA Head Pointer */
#define LCDC_OVRHEAD2_HEAD(value) ((LCDC_OVRHEAD2_HEAD_Msk & ((value) << LCDC_OVRHEAD2_HEAD_Pos)))
/* -------- LCDC_OVRADDR2 : (LCDC Offset: 0x00000260) Overlay 2 DMA Address Register -------- */
#define LCDC_OVRADDR2_ADDR_Pos 0
#define LCDC_OVRADDR2_ADDR_Msk (0xffffffffu << LCDC_OVRADDR2_ADDR_Pos) /**< \brief (LCDC_OVRADDR2) DMA Transfer Overlay 2 Address */
#define LCDC_OVRADDR2_ADDR(value) ((LCDC_OVRADDR2_ADDR_Msk & ((value) << LCDC_OVRADDR2_ADDR_Pos)))
/* -------- LCDC_OVRCTRL2 : (LCDC Offset: 0x00000264) Overlay 2 DMA Control Register -------- */
#define LCDC_OVRCTRL2_DFETCH (0x1u << 0) /**< \brief (LCDC_OVRCTRL2) Transfer Descriptor Fetch Enable */
#define LCDC_OVRCTRL2_LFETCH (0x1u << 1) /**< \brief (LCDC_OVRCTRL2) Lookup Table Fetch Enable */
#define LCDC_OVRCTRL2_DMAIEN (0x1u << 2) /**< \brief (LCDC_OVRCTRL2) End of DMA Transfer Interrupt Enable */
#define LCDC_OVRCTRL2_DSCRIEN (0x1u << 3) /**< \brief (LCDC_OVRCTRL2) Descriptor Loaded Interrupt Enable */
#define LCDC_OVRCTRL2_ADDIEN (0x1u << 4) /**< \brief (LCDC_OVRCTRL2) Add Head Descriptor to Queue Interrupt Enable */
#define LCDC_OVRCTRL2_DONEIEN (0x1u << 5) /**< \brief (LCDC_OVRCTRL2) End of List Interrupt Enable */
/* -------- LCDC_OVRNEXT2 : (LCDC Offset: 0x00000268) Overlay 2 DMA Next Register -------- */
#define LCDC_OVRNEXT2_NEXT_Pos 0
#define LCDC_OVRNEXT2_NEXT_Msk (0xffffffffu << LCDC_OVRNEXT2_NEXT_Pos) /**< \brief (LCDC_OVRNEXT2) DMA Descriptor Next Address */
#define LCDC_OVRNEXT2_NEXT(value) ((LCDC_OVRNEXT2_NEXT_Msk & ((value) << LCDC_OVRNEXT2_NEXT_Pos)))
/* -------- LCDC_OVR2CFG0 : (LCDC Offset: 0x0000026C) Overlay 2 Configuration 0 Register -------- */
#define LCDC_OVR2CFG0_BLEN_Pos 4
#define LCDC_OVR2CFG0_BLEN_Msk (0x3u << LCDC_OVR2CFG0_BLEN_Pos) /**< \brief (LCDC_OVR2CFG0) AHB Burst Length */
#define   LCDC_OVR2CFG0_BLEN_AHB_SINGLE (0x0u << 4) /**< \brief (LCDC_OVR2CFG0) AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_OVR2CFG0_BLEN_AHB_INCR4 (0x1u << 4) /**< \brief (LCDC_OVR2CFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_OVR2CFG0_BLEN_AHB_INCR8 (0x2u << 4) /**< \brief (LCDC_OVR2CFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_OVR2CFG0_BLEN_AHB_INCR16 (0x3u << 4) /**< \brief (LCDC_OVR2CFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define LCDC_OVR2CFG0_DLBO (0x1u << 8) /**< \brief (LCDC_OVR2CFG0) Defined Length Burst Only For Channel Bus Transaction. */
#define LCDC_OVR2CFG0_ROTDIS (0x1u << 12) /**< \brief (LCDC_OVR2CFG0) Hardware Rotation Optimization Disable */
#define LCDC_OVR2CFG0_LOCKDIS (0x1u << 13) /**< \brief (LCDC_OVR2CFG0) Hardware Rotation Lock Disable */
/* -------- LCDC_OVR2CFG1 : (LCDC Offset: 0x00000270) Overlay 2 Configuration 1 Register -------- */
#define LCDC_OVR2CFG1_CLUTEN (0x1u << 0) /**< \brief (LCDC_OVR2CFG1) Color Lookup Table Enable */
#define LCDC_OVR2CFG1_RGBMODE_Pos 4
#define LCDC_OVR2CFG1_RGBMODE_Msk (0xfu << LCDC_OVR2CFG1_RGBMODE_Pos) /**< \brief (LCDC_OVR2CFG1) RGB Input Mode Selection */
#define   LCDC_OVR2CFG1_RGBMODE_12BPP_RGB_444 (0x0u << 4) /**< \brief (LCDC_OVR2CFG1) 12 bpp RGB 444 */
#define   LCDC_OVR2CFG1_RGBMODE_16BPP_ARGB_4444 (0x1u << 4) /**< \brief (LCDC_OVR2CFG1) 16 bpp ARGB 4444 */
#define   LCDC_OVR2CFG1_RGBMODE_16BPP_RGBA_4444 (0x2u << 4) /**< \brief (LCDC_OVR2CFG1) 16 bpp RGBA 4444 */
#define   LCDC_OVR2CFG1_RGBMODE_16BPP_RGB_565 (0x3u << 4) /**< \brief (LCDC_OVR2CFG1) 16 bpp RGB 565 */
#define   LCDC_OVR2CFG1_RGBMODE_16BPP_TRGB_1555 (0x4u << 4) /**< \brief (LCDC_OVR2CFG1) 16 bpp TRGB 1555 */
#define   LCDC_OVR2CFG1_RGBMODE_18BPP_RGB_666 (0x5u << 4) /**< \brief (LCDC_OVR2CFG1) 18 bpp RGB 666 */
#define   LCDC_OVR2CFG1_RGBMODE_18BPP_RGB_666PACKED (0x6u << 4) /**< \brief (LCDC_OVR2CFG1) 18 bpp RGB 666 PACKED */
#define   LCDC_OVR2CFG1_RGBMODE_19BPP_TRGB_1666 (0x7u << 4) /**< \brief (LCDC_OVR2CFG1) 19 bpp TRGB 1666 */
#define   LCDC_OVR2CFG1_RGBMODE_19BPP_TRGB_PACKED (0x8u << 4) /**< \brief (LCDC_OVR2CFG1) 19 bpp TRGB 1666 PACKED */
#define   LCDC_OVR2CFG1_RGBMODE_24BPP_RGB_888 (0x9u << 4) /**< \brief (LCDC_OVR2CFG1) 24 bpp RGB 888 */
#define   LCDC_OVR2CFG1_RGBMODE_24BPP_RGB_888_PACKED (0xAu << 4) /**< \brief (LCDC_OVR2CFG1) 24 bpp RGB 888 PACKED */
#define   LCDC_OVR2CFG1_RGBMODE_25BPP_TRGB_1888 (0xBu << 4) /**< \brief (LCDC_OVR2CFG1) 25 bpp TRGB 1888 */
#define   LCDC_OVR2CFG1_RGBMODE_32BPP_ARGB_8888 (0xCu << 4) /**< \brief (LCDC_OVR2CFG1) 32 bpp ARGB 8888 */
#define   LCDC_OVR2CFG1_RGBMODE_32BPP_RGBA_8888 (0xDu << 4) /**< \brief (LCDC_OVR2CFG1) 32 bpp RGBA 8888 */
#define LCDC_OVR2CFG1_CLUTMODE_Pos 8
#define LCDC_OVR2CFG1_CLUTMODE_Msk (0x3u << LCDC_OVR2CFG1_CLUTMODE_Pos) /**< \brief (LCDC_OVR2CFG1) Color Lookup table input mode selection */
#define   LCDC_OVR2CFG1_CLUTMODE_CLUT_1BPP (0x0u << 8) /**< \brief (LCDC_OVR2CFG1) color lookup table mode set to 1 bit per pixel */
#define   LCDC_OVR2CFG1_CLUTMODE_CLUT_2BPP (0x1u << 8) /**< \brief (LCDC_OVR2CFG1) color lookup table mode set to 2 bits per pixel */
#define   LCDC_OVR2CFG1_CLUTMODE_CLUT_4BPP (0x2u << 8) /**< \brief (LCDC_OVR2CFG1) color lookup table mode set to 4 bits per pixel */
#define   LCDC_OVR2CFG1_CLUTMODE_CLUT_8BPP (0x3u << 8) /**< \brief (LCDC_OVR2CFG1) color lookup table mode set to 8 bits per pixel */
/* -------- LCDC_OVR2CFG2 : (LCDC Offset: 0x00000274) Overlay 2 Configuration 2 Register -------- */
#define LCDC_OVR2CFG2_XPOS_Pos 0
#define LCDC_OVR2CFG2_XPOS_Msk (0x7ffu << LCDC_OVR2CFG2_XPOS_Pos) /**< \brief (LCDC_OVR2CFG2) Horizontal Window Position */
#define LCDC_OVR2CFG2_XPOS(value) ((LCDC_OVR2CFG2_XPOS_Msk & ((value) << LCDC_OVR2CFG2_XPOS_Pos)))
#define LCDC_OVR2CFG2_YPOS_Pos 16
#define LCDC_OVR2CFG2_YPOS_Msk (0x7ffu << LCDC_OVR2CFG2_YPOS_Pos) /**< \brief (LCDC_OVR2CFG2) Vertical Window Position */
#define LCDC_OVR2CFG2_YPOS(value) ((LCDC_OVR2CFG2_YPOS_Msk & ((value) << LCDC_OVR2CFG2_YPOS_Pos)))
/* -------- LCDC_OVR2CFG3 : (LCDC Offset: 0x00000278) Overlay 2 Configuration 3 Register -------- */
#define LCDC_OVR2CFG3_XSIZE_Pos 0
#define LCDC_OVR2CFG3_XSIZE_Msk (0x7ffu << LCDC_OVR2CFG3_XSIZE_Pos) /**< \brief (LCDC_OVR2CFG3) Horizontal Window Size */
#define LCDC_OVR2CFG3_XSIZE(value) ((LCDC_OVR2CFG3_XSIZE_Msk & ((value) << LCDC_OVR2CFG3_XSIZE_Pos)))
#define LCDC_OVR2CFG3_YSIZE_Pos 16
#define LCDC_OVR2CFG3_YSIZE_Msk (0x7ffu << LCDC_OVR2CFG3_YSIZE_Pos) /**< \brief (LCDC_OVR2CFG3) Vertical Window Size */
#define LCDC_OVR2CFG3_YSIZE(value) ((LCDC_OVR2CFG3_YSIZE_Msk & ((value) << LCDC_OVR2CFG3_YSIZE_Pos)))
/* -------- LCDC_OVR2CFG4 : (LCDC Offset: 0x0000027C) Overlay 2 Configuration 4 Register -------- */
#define LCDC_OVR2CFG4_XSTRIDE_Pos 0
#define LCDC_OVR2CFG4_XSTRIDE_Msk (0xffffffffu << LCDC_OVR2CFG4_XSTRIDE_Pos) /**< \brief (LCDC_OVR2CFG4) Horizontal Stride */
#define LCDC_OVR2CFG4_XSTRIDE(value) ((LCDC_OVR2CFG4_XSTRIDE_Msk & ((value) << LCDC_OVR2CFG4_XSTRIDE_Pos)))
/* -------- LCDC_OVR2CFG5 : (LCDC Offset: 0x00000280) Overlay 2 Configuration 5 Register -------- */
#define LCDC_OVR2CFG5_PSTRIDE_Pos 0
#define LCDC_OVR2CFG5_PSTRIDE_Msk (0xffffffffu << LCDC_OVR2CFG5_PSTRIDE_Pos) /**< \brief (LCDC_OVR2CFG5) Pixel Stride */
#define LCDC_OVR2CFG5_PSTRIDE(value) ((LCDC_OVR2CFG5_PSTRIDE_Msk & ((value) << LCDC_OVR2CFG5_PSTRIDE_Pos)))
/* -------- LCDC_OVR2CFG6 : (LCDC Offset: 0x00000284) Overlay 2 Configuration 6 Register -------- */
#define LCDC_OVR2CFG6_BDEF_Pos 0
#define LCDC_OVR2CFG6_BDEF_Msk (0xffu << LCDC_OVR2CFG6_BDEF_Pos) /**< \brief (LCDC_OVR2CFG6) Blue Default */
#define LCDC_OVR2CFG6_BDEF(value) ((LCDC_OVR2CFG6_BDEF_Msk & ((value) << LCDC_OVR2CFG6_BDEF_Pos)))
#define LCDC_OVR2CFG6_GDEF_Pos 8
#define LCDC_OVR2CFG6_GDEF_Msk (0xffu << LCDC_OVR2CFG6_GDEF_Pos) /**< \brief (LCDC_OVR2CFG6) Green Default */
#define LCDC_OVR2CFG6_GDEF(value) ((LCDC_OVR2CFG6_GDEF_Msk & ((value) << LCDC_OVR2CFG6_GDEF_Pos)))
#define LCDC_OVR2CFG6_RDEF_Pos 16
#define LCDC_OVR2CFG6_RDEF_Msk (0xffu << LCDC_OVR2CFG6_RDEF_Pos) /**< \brief (LCDC_OVR2CFG6) Red Default */
#define LCDC_OVR2CFG6_RDEF(value) ((LCDC_OVR2CFG6_RDEF_Msk & ((value) << LCDC_OVR2CFG6_RDEF_Pos)))
/* -------- LCDC_OVR2CFG7 : (LCDC Offset: 0x00000288) Overlay 2 Configuration 7 Register -------- */
#define LCDC_OVR2CFG7_BKEY_Pos 0
#define LCDC_OVR2CFG7_BKEY_Msk (0xffu << LCDC_OVR2CFG7_BKEY_Pos) /**< \brief (LCDC_OVR2CFG7) Blue Color Component Chroma Key */
#define LCDC_OVR2CFG7_BKEY(value) ((LCDC_OVR2CFG7_BKEY_Msk & ((value) << LCDC_OVR2CFG7_BKEY_Pos)))
#define LCDC_OVR2CFG7_GKEY_Pos 8
#define LCDC_OVR2CFG7_GKEY_Msk (0xffu << LCDC_OVR2CFG7_GKEY_Pos) /**< \brief (LCDC_OVR2CFG7) Green Color Component Chroma Key */
#define LCDC_OVR2CFG7_GKEY(value) ((LCDC_OVR2CFG7_GKEY_Msk & ((value) << LCDC_OVR2CFG7_GKEY_Pos)))
#define LCDC_OVR2CFG7_RKEY_Pos 16
#define LCDC_OVR2CFG7_RKEY_Msk (0xffu << LCDC_OVR2CFG7_RKEY_Pos) /**< \brief (LCDC_OVR2CFG7) Red Color Component Chroma Key */
#define LCDC_OVR2CFG7_RKEY(value) ((LCDC_OVR2CFG7_RKEY_Msk & ((value) << LCDC_OVR2CFG7_RKEY_Pos)))
/* -------- LCDC_OVR2CFG8 : (LCDC Offset: 0x0000028C) Overlay 2 Configuration 8 Register -------- */
#define LCDC_OVR2CFG8_BMASK_Pos 0
#define LCDC_OVR2CFG8_BMASK_Msk (0xffu << LCDC_OVR2CFG8_BMASK_Pos) /**< \brief (LCDC_OVR2CFG8) Blue Color Component Chroma Key Mask */
#define LCDC_OVR2CFG8_BMASK(value) ((LCDC_OVR2CFG8_BMASK_Msk & ((value) << LCDC_OVR2CFG8_BMASK_Pos)))
#define LCDC_OVR2CFG8_GMASK_Pos 8
#define LCDC_OVR2CFG8_GMASK_Msk (0xffu << LCDC_OVR2CFG8_GMASK_Pos) /**< \brief (LCDC_OVR2CFG8) Green Color Component Chroma Key Mask */
#define LCDC_OVR2CFG8_GMASK(value) ((LCDC_OVR2CFG8_GMASK_Msk & ((value) << LCDC_OVR2CFG8_GMASK_Pos)))
#define LCDC_OVR2CFG8_RMASK_Pos 16
#define LCDC_OVR2CFG8_RMASK_Msk (0xffu << LCDC_OVR2CFG8_RMASK_Pos) /**< \brief (LCDC_OVR2CFG8) Red Color Component Chroma Key Mask */
#define LCDC_OVR2CFG8_RMASK(value) ((LCDC_OVR2CFG8_RMASK_Msk & ((value) << LCDC_OVR2CFG8_RMASK_Pos)))
/* -------- LCDC_OVR2CFG9 : (LCDC Offset: 0x00000290) Overlay 2 Configuration 9 Register -------- */
#define LCDC_OVR2CFG9_CRKEY (0x1u << 0) /**< \brief (LCDC_OVR2CFG9) Blender Chroma Key Enable */
#define LCDC_OVR2CFG9_INV (0x1u << 1) /**< \brief (LCDC_OVR2CFG9) Blender Inverted Blender Output Enable */
#define LCDC_OVR2CFG9_ITER2BL (0x1u << 2) /**< \brief (LCDC_OVR2CFG9) Blender Iterated Color Enable */
#define LCDC_OVR2CFG9_ITER (0x1u << 3) /**< \brief (LCDC_OVR2CFG9) Blender Use Iterated Color */
#define LCDC_OVR2CFG9_REVALPHA (0x1u << 4) /**< \brief (LCDC_OVR2CFG9) Blender Reverse Alpha */
#define LCDC_OVR2CFG9_GAEN (0x1u << 5) /**< \brief (LCDC_OVR2CFG9) Blender Global Alpha Enable */
#define LCDC_OVR2CFG9_LAEN (0x1u << 6) /**< \brief (LCDC_OVR2CFG9) Blender Local Alpha Enable */
#define LCDC_OVR2CFG9_OVR (0x1u << 7) /**< \brief (LCDC_OVR2CFG9) Blender Overlay Layer Enable */
#define LCDC_OVR2CFG9_DMA (0x1u << 8) /**< \brief (LCDC_OVR2CFG9) Blender DMA Layer Enable */
#define LCDC_OVR2CFG9_REP (0x1u << 9) /**< \brief (LCDC_OVR2CFG9) Use Replication logic to expand RGB color to 24 bits */
#define LCDC_OVR2CFG9_DSTKEY (0x1u << 10) /**< \brief (LCDC_OVR2CFG9) Destination Chroma Keying */
#define LCDC_OVR2CFG9_GA_Pos 16
#define LCDC_OVR2CFG9_GA_Msk (0xffu << LCDC_OVR2CFG9_GA_Pos) /**< \brief (LCDC_OVR2CFG9) Blender Global Alpha */
#define LCDC_OVR2CFG9_GA(value) ((LCDC_OVR2CFG9_GA_Msk & ((value) << LCDC_OVR2CFG9_GA_Pos)))
/* -------- LCDC_HEOCHER : (LCDC Offset: 0x00000340) High-End Overlay Channel Enable Register -------- */
#define LCDC_HEOCHER_CHEN (0x1u << 0) /**< \brief (LCDC_HEOCHER) Channel Enable Register */
#define LCDC_HEOCHER_UPDATEEN (0x1u << 1) /**< \brief (LCDC_HEOCHER) Update Overlay Attributes Enable Register */
#define LCDC_HEOCHER_A2QEN (0x1u << 2) /**< \brief (LCDC_HEOCHER) Add Head Pointer Enable Register */
/* -------- LCDC_HEOCHDR : (LCDC Offset: 0x00000344) High-End Overlay Channel Disable Register -------- */
#define LCDC_HEOCHDR_CHDIS (0x1u << 0) /**< \brief (LCDC_HEOCHDR) Channel Disable Register */
#define LCDC_HEOCHDR_CHRST (0x1u << 8) /**< \brief (LCDC_HEOCHDR) Channel Reset Register */
/* -------- LCDC_HEOCHSR : (LCDC Offset: 0x00000348) High-End Overlay Channel Status Register -------- */
#define LCDC_HEOCHSR_CHSR (0x1u << 0) /**< \brief (LCDC_HEOCHSR) Channel Status Register */
#define LCDC_HEOCHSR_UPDATESR (0x1u << 1) /**< \brief (LCDC_HEOCHSR) Update Overlay Attributes In Progress */
#define LCDC_HEOCHSR_A2QSR (0x1u << 2) /**< \brief (LCDC_HEOCHSR) Add To Queue Pending Register */
/* -------- LCDC_HEOIER : (LCDC Offset: 0x0000034C) High-End Overlay Interrupt Enable Register -------- */
#define LCDC_HEOIER_DMA (0x1u << 2) /**< \brief (LCDC_HEOIER) End of DMA Transfer Interrupt Enable Register */
#define LCDC_HEOIER_DSCR (0x1u << 3) /**< \brief (LCDC_HEOIER) Descriptor Loaded Interrupt Enable Register */
#define LCDC_HEOIER_ADD (0x1u << 4) /**< \brief (LCDC_HEOIER) Head Descriptor Loaded Interrupt Enable Register */
#define LCDC_HEOIER_DONE (0x1u << 5) /**< \brief (LCDC_HEOIER) End of List Interrupt Enable Register */
#define LCDC_HEOIER_OVR (0x1u << 6) /**< \brief (LCDC_HEOIER) Overflow Interrupt Enable Register */
#define LCDC_HEOIER_UDMA (0x1u << 10) /**< \brief (LCDC_HEOIER) End of DMA Transfer for U or UV Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_UDSCR (0x1u << 11) /**< \brief (LCDC_HEOIER) Descriptor Loaded for U or UV Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_UADD (0x1u << 12) /**< \brief (LCDC_HEOIER) Head Descriptor Loaded for U or UV Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_UDONE (0x1u << 13) /**< \brief (LCDC_HEOIER) End of List for U or UV Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_UOVR (0x1u << 14) /**< \brief (LCDC_HEOIER) Overflow for U or UV Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_VDMA (0x1u << 18) /**< \brief (LCDC_HEOIER) End of DMA for V Chrominance Transfer Interrupt Enable Register */
#define LCDC_HEOIER_VDSCR (0x1u << 19) /**< \brief (LCDC_HEOIER) Descriptor Loaded for V Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_VADD (0x1u << 20) /**< \brief (LCDC_HEOIER) Head Descriptor Loaded for V Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_VDONE (0x1u << 21) /**< \brief (LCDC_HEOIER) End of List for V Chrominance Interrupt Enable Register */
#define LCDC_HEOIER_VOVR (0x1u << 22) /**< \brief (LCDC_HEOIER) Overflow for V Chrominance Interrupt Enable Register */
/* -------- LCDC_HEOIDR : (LCDC Offset: 0x00000350) High-End Overlay Interrupt Disable Register -------- */
#define LCDC_HEOIDR_DMA (0x1u << 2) /**< \brief (LCDC_HEOIDR) End of DMA Transfer Interrupt Disable Register */
#define LCDC_HEOIDR_DSCR (0x1u << 3) /**< \brief (LCDC_HEOIDR) Descriptor Loaded Interrupt Disable Register */
#define LCDC_HEOIDR_ADD (0x1u << 4) /**< \brief (LCDC_HEOIDR) Head Descriptor Loaded Interrupt Disable Register */
#define LCDC_HEOIDR_DONE (0x1u << 5) /**< \brief (LCDC_HEOIDR) End of List Interrupt Disable Register */
#define LCDC_HEOIDR_OVR (0x1u << 6) /**< \brief (LCDC_HEOIDR) Overflow Interrupt Disable Register */
#define LCDC_HEOIDR_UDMA (0x1u << 10) /**< \brief (LCDC_HEOIDR) End of DMA Transfer for U or UV Chrominance Component Interrupt Disable Register */
#define LCDC_HEOIDR_UDSCR (0x1u << 11) /**< \brief (LCDC_HEOIDR) Descriptor Loaded for U or UV Chrominance Component Interrupt Disable Register */
#define LCDC_HEOIDR_UADD (0x1u << 12) /**< \brief (LCDC_HEOIDR) Head Descriptor Loaded for U or UV Chrominance Component Interrupt Disable Register */
#define LCDC_HEOIDR_UDONE (0x1u << 13) /**< \brief (LCDC_HEOIDR) End of List Interrupt for U or UV Chrominance Component Disable Register */
#define LCDC_HEOIDR_UOVR (0x1u << 14) /**< \brief (LCDC_HEOIDR) Overflow Interrupt for U or UV Chrominance Component Disable Register */
#define LCDC_HEOIDR_VDMA (0x1u << 18) /**< \brief (LCDC_HEOIDR) End of DMA Transfer for V Chrominance Component Interrupt Disable Register */
#define LCDC_HEOIDR_VDSCR (0x1u << 19) /**< \brief (LCDC_HEOIDR) Descriptor Loaded for V Chrominance Component Interrupt Disable Register */
#define LCDC_HEOIDR_VADD (0x1u << 20) /**< \brief (LCDC_HEOIDR) Head Descriptor Loaded for V Chrominance Component Interrupt Disable Register */
#define LCDC_HEOIDR_VDONE (0x1u << 21) /**< \brief (LCDC_HEOIDR) End of List for V Chrominance Component Interrupt Disable Register */
#define LCDC_HEOIDR_VOVR (0x1u << 22) /**< \brief (LCDC_HEOIDR) Overflow for V Chrominance Component Interrupt Disable Register */
/* -------- LCDC_HEOIMR : (LCDC Offset: 0x00000354) High-End Overlay Interrupt Mask Register -------- */
#define LCDC_HEOIMR_DMA (0x1u << 2) /**< \brief (LCDC_HEOIMR) End of DMA Transfer Interrupt Mask Register */
#define LCDC_HEOIMR_DSCR (0x1u << 3) /**< \brief (LCDC_HEOIMR) Descriptor Loaded Interrupt Mask Register */
#define LCDC_HEOIMR_ADD (0x1u << 4) /**< \brief (LCDC_HEOIMR) Head Descriptor Loaded Interrupt Mask Register */
#define LCDC_HEOIMR_DONE (0x1u << 5) /**< \brief (LCDC_HEOIMR) End of List Interrupt Mask Register */
#define LCDC_HEOIMR_OVR (0x1u << 6) /**< \brief (LCDC_HEOIMR) Overflow Interrupt Mask Register */
#define LCDC_HEOIMR_UDMA (0x1u << 10) /**< \brief (LCDC_HEOIMR) End of DMA Transfer for U or UV Chrominance Component Interrupt Mask Register */
#define LCDC_HEOIMR_UDSCR (0x1u << 11) /**< \brief (LCDC_HEOIMR) Descriptor Loaded for U or UV Chrominance Component Interrupt Mask Register */
#define LCDC_HEOIMR_UADD (0x1u << 12) /**< \brief (LCDC_HEOIMR) Head Descriptor Loaded for U or UV Chrominance Component Mask Register */
#define LCDC_HEOIMR_UDONE (0x1u << 13) /**< \brief (LCDC_HEOIMR) End of List for U or UV Chrominance Component Mask Register */
#define LCDC_HEOIMR_UOVR (0x1u << 14) /**< \brief (LCDC_HEOIMR) Overflow for U Chrominance Interrupt Mask Register */
#define LCDC_HEOIMR_VDMA (0x1u << 18) /**< \brief (LCDC_HEOIMR) End of DMA Transfer for V Chrominance Component Interrupt Mask Register */
#define LCDC_HEOIMR_VDSCR (0x1u << 19) /**< \brief (LCDC_HEOIMR) Descriptor Loaded for V Chrominance Component Interrupt Mask Register */
#define LCDC_HEOIMR_VADD (0x1u << 20) /**< \brief (LCDC_HEOIMR) Head Descriptor Loaded for V Chrominance Component Mask Register */
#define LCDC_HEOIMR_VDONE (0x1u << 21) /**< \brief (LCDC_HEOIMR) End of List for V Chrominance Component Mask Register */
#define LCDC_HEOIMR_VOVR (0x1u << 22) /**< \brief (LCDC_HEOIMR) Overflow for V Chrominance Interrupt Mask Register */
/* -------- LCDC_HEOISR : (LCDC Offset: 0x00000358) High-End Overlay Interrupt Status Register -------- */
#define LCDC_HEOISR_DMA (0x1u << 2) /**< \brief (LCDC_HEOISR) End of DMA Transfer */
#define LCDC_HEOISR_DSCR (0x1u << 3) /**< \brief (LCDC_HEOISR) DMA Descriptor Loaded */
#define LCDC_HEOISR_ADD (0x1u << 4) /**< \brief (LCDC_HEOISR) Head Descriptor Loaded */
#define LCDC_HEOISR_DONE (0x1u << 5) /**< \brief (LCDC_HEOISR) End of List Detected */
#define LCDC_HEOISR_OVR (0x1u << 6) /**< \brief (LCDC_HEOISR) Overflow Detected */
#define LCDC_HEOISR_UDMA (0x1u << 10) /**< \brief (LCDC_HEOISR) End of DMA Transfer for U component */
#define LCDC_HEOISR_UDSCR (0x1u << 11) /**< \brief (LCDC_HEOISR) DMA Descriptor Loaded for U component */
#define LCDC_HEOISR_UADD (0x1u << 12) /**< \brief (LCDC_HEOISR) Head Descriptor Loaded for U component */
#define LCDC_HEOISR_UDONE (0x1u << 13) /**< \brief (LCDC_HEOISR) End of List Detected for U component */
#define LCDC_HEOISR_UOVR (0x1u << 14) /**< \brief (LCDC_HEOISR) Overflow Detected for U component */
#define LCDC_HEOISR_VDMA (0x1u << 18) /**< \brief (LCDC_HEOISR) End of DMA Transfer for V component */
#define LCDC_HEOISR_VDSCR (0x1u << 19) /**< \brief (LCDC_HEOISR) DMA Descriptor Loaded for V component */
#define LCDC_HEOISR_VADD (0x1u << 20) /**< \brief (LCDC_HEOISR) Head Descriptor Loaded for V component */
#define LCDC_HEOISR_VDONE (0x1u << 21) /**< \brief (LCDC_HEOISR) End of List Detected for V component */
#define LCDC_HEOISR_VOVR (0x1u << 22) /**< \brief (LCDC_HEOISR) Overflow Detected for V component */
/* -------- LCDC_HEOHEAD : (LCDC Offset: 0x0000035C) High-End Overlay DMA Head Register -------- */
#define LCDC_HEOHEAD_HEAD_Pos 2
#define LCDC_HEOHEAD_HEAD_Msk (0x3fffffffu << LCDC_HEOHEAD_HEAD_Pos) /**< \brief (LCDC_HEOHEAD) DMA Head Pointer */
#define LCDC_HEOHEAD_HEAD(value) ((LCDC_HEOHEAD_HEAD_Msk & ((value) << LCDC_HEOHEAD_HEAD_Pos)))
/* -------- LCDC_HEOADDR : (LCDC Offset: 0x00000360) High-End Overlay DMA Address Register -------- */
#define LCDC_HEOADDR_ADDR_Pos 0
#define LCDC_HEOADDR_ADDR_Msk (0xffffffffu << LCDC_HEOADDR_ADDR_Pos) /**< \brief (LCDC_HEOADDR) DMA Transfer start Address */
#define LCDC_HEOADDR_ADDR(value) ((LCDC_HEOADDR_ADDR_Msk & ((value) << LCDC_HEOADDR_ADDR_Pos)))
/* -------- LCDC_HEOCTRL : (LCDC Offset: 0x00000364) High-End Overlay DMA Control Register -------- */
#define LCDC_HEOCTRL_DFETCH (0x1u << 0) /**< \brief (LCDC_HEOCTRL) Transfer Descriptor Fetch Enable */
#define LCDC_HEOCTRL_LFETCH (0x1u << 1) /**< \brief (LCDC_HEOCTRL) Lookup Table Fetch Enable */
#define LCDC_HEOCTRL_DMAIEN (0x1u << 2) /**< \brief (LCDC_HEOCTRL) End of DMA Transfer Interrupt Enable */
#define LCDC_HEOCTRL_DSCRIEN (0x1u << 3) /**< \brief (LCDC_HEOCTRL) Descriptor Loaded Interrupt Enable */
#define LCDC_HEOCTRL_ADDIEN (0x1u << 4) /**< \brief (LCDC_HEOCTRL) Add Head Descriptor to Queue Interrupt Enable */
#define LCDC_HEOCTRL_DONEIEN (0x1u << 5) /**< \brief (LCDC_HEOCTRL) End of List Interrupt Enable */
/* -------- LCDC_HEONEXT : (LCDC Offset: 0x00000368) High-End Overlay DMA Next Register -------- */
#define LCDC_HEONEXT_NEXT_Pos 0
#define LCDC_HEONEXT_NEXT_Msk (0xffffffffu << LCDC_HEONEXT_NEXT_Pos) /**< \brief (LCDC_HEONEXT) DMA Descriptor Next Address */
#define LCDC_HEONEXT_NEXT(value) ((LCDC_HEONEXT_NEXT_Msk & ((value) << LCDC_HEONEXT_NEXT_Pos)))
/* -------- LCDC_HEOUHEAD : (LCDC Offset: 0x0000036C) High-End Overlay U DMA Head Register -------- */
#define LCDC_HEOUHEAD_UHEAD_Pos 0
#define LCDC_HEOUHEAD_UHEAD_Msk (0xffffffffu << LCDC_HEOUHEAD_UHEAD_Pos) /**< \brief (LCDC_HEOUHEAD) DMA Head Pointer */
#define LCDC_HEOUHEAD_UHEAD(value) ((LCDC_HEOUHEAD_UHEAD_Msk & ((value) << LCDC_HEOUHEAD_UHEAD_Pos)))
/* -------- LCDC_HEOUADDR : (LCDC Offset: 0x00000370) High-End Overlay U DMA Address Register -------- */
#define LCDC_HEOUADDR_UADDR_Pos 0
#define LCDC_HEOUADDR_UADDR_Msk (0xffffffffu << LCDC_HEOUADDR_UADDR_Pos) /**< \brief (LCDC_HEOUADDR) DMA Transfer Start Address for U or UV Chrominance */
#define LCDC_HEOUADDR_UADDR(value) ((LCDC_HEOUADDR_UADDR_Msk & ((value) << LCDC_HEOUADDR_UADDR_Pos)))
/* -------- LCDC_HEOUCTRL : (LCDC Offset: 0x00000374) High-End Overlay U DMA control Register -------- */
#define LCDC_HEOUCTRL_UDFETCH (0x1u << 0) /**< \brief (LCDC_HEOUCTRL) Transfer Descriptor Fetch Enable */
#define LCDC_HEOUCTRL_UDMAIEN (0x1u << 2) /**< \brief (LCDC_HEOUCTRL) End of DMA Transfer Interrupt Enable */
#define LCDC_HEOUCTRL_UDSCRIEN (0x1u << 3) /**< \brief (LCDC_HEOUCTRL) Descriptor Loaded Interrupt Enable */
#define LCDC_HEOUCTRL_UADDIEN (0x1u << 4) /**< \brief (LCDC_HEOUCTRL) Add Head Descriptor to Queue Interrupt Enable */
#define LCDC_HEOUCTRL_UDONEIEN (0x1u << 5) /**< \brief (LCDC_HEOUCTRL) End of List Interrupt Enable */
/* -------- LCDC_HEOUNEXT : (LCDC Offset: 0x00000378) High-End Overlay U DMA Next Register -------- */
#define LCDC_HEOUNEXT_UNEXT_Pos 0
#define LCDC_HEOUNEXT_UNEXT_Msk (0xffffffffu << LCDC_HEOUNEXT_UNEXT_Pos) /**< \brief (LCDC_HEOUNEXT) DMA Descriptor Next Address */
#define LCDC_HEOUNEXT_UNEXT(value) ((LCDC_HEOUNEXT_UNEXT_Msk & ((value) << LCDC_HEOUNEXT_UNEXT_Pos)))
/* -------- LCDC_HEOVHEAD : (LCDC Offset: 0x0000037C) High-End Overlay V DMA Head Register -------- */
#define LCDC_HEOVHEAD_VHEAD_Pos 0
#define LCDC_HEOVHEAD_VHEAD_Msk (0xffffffffu << LCDC_HEOVHEAD_VHEAD_Pos) /**< \brief (LCDC_HEOVHEAD) DMA Head Pointer */
#define LCDC_HEOVHEAD_VHEAD(value) ((LCDC_HEOVHEAD_VHEAD_Msk & ((value) << LCDC_HEOVHEAD_VHEAD_Pos)))
/* -------- LCDC_HEOVADDR : (LCDC Offset: 0x00000380) High-End Overlay V DMA Address Register -------- */
#define LCDC_HEOVADDR_VADDR_Pos 0
#define LCDC_HEOVADDR_VADDR_Msk (0xffffffffu << LCDC_HEOVADDR_VADDR_Pos) /**< \brief (LCDC_HEOVADDR) DMA Transfer Start Address for V Chrominance */
#define LCDC_HEOVADDR_VADDR(value) ((LCDC_HEOVADDR_VADDR_Msk & ((value) << LCDC_HEOVADDR_VADDR_Pos)))
/* -------- LCDC_HEOVCTRL : (LCDC Offset: 0x00000384) High-End Overlay V DMA control Register -------- */
#define LCDC_HEOVCTRL_VDFETCH (0x1u << 0) /**< \brief (LCDC_HEOVCTRL) Transfer Descriptor Fetch Enable */
#define LCDC_HEOVCTRL_VDMAIEN (0x1u << 2) /**< \brief (LCDC_HEOVCTRL) End of DMA Transfer Interrupt Enable */
#define LCDC_HEOVCTRL_VDSCRIEN (0x1u << 3) /**< \brief (LCDC_HEOVCTRL) Descriptor Loaded Interrupt Enable */
#define LCDC_HEOVCTRL_VADDIEN (0x1u << 4) /**< \brief (LCDC_HEOVCTRL) Add Head Descriptor to Queue Interrupt Enable */
#define LCDC_HEOVCTRL_VDONEIEN (0x1u << 5) /**< \brief (LCDC_HEOVCTRL) End of List Interrupt Enable */
/* -------- LCDC_HEOVNEXT : (LCDC Offset: 0x00000388) High-End Overlay VDMA Next Register -------- */
#define LCDC_HEOVNEXT_VNEXT_Pos 0
#define LCDC_HEOVNEXT_VNEXT_Msk (0xffffffffu << LCDC_HEOVNEXT_VNEXT_Pos) /**< \brief (LCDC_HEOVNEXT) DMA Descriptor Next Address */
#define LCDC_HEOVNEXT_VNEXT(value) ((LCDC_HEOVNEXT_VNEXT_Msk & ((value) << LCDC_HEOVNEXT_VNEXT_Pos)))
/* -------- LCDC_HEOCFG0 : (LCDC Offset: 0x0000038C) High-End Overlay Configuration Register 0 -------- */
#define LCDC_HEOCFG0_SIF (0x1u << 0) /**< \brief (LCDC_HEOCFG0) Source Interface */
#define LCDC_HEOCFG0_BLEN_Pos 4
#define LCDC_HEOCFG0_BLEN_Msk (0x3u << LCDC_HEOCFG0_BLEN_Pos) /**< \brief (LCDC_HEOCFG0) AHB Burst Length */
#define   LCDC_HEOCFG0_BLEN_AHB_BLEN_SINGLE (0x0u << 4) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_HEOCFG0_BLEN_AHB_BLEN_INCR4 (0x1u << 4) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_HEOCFG0_BLEN_AHB_BLEN_INCR8 (0x2u << 4) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_HEOCFG0_BLEN_AHB_BLEN_INCR16 (0x3u << 4) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define LCDC_HEOCFG0_BLENUV_Pos 6
#define LCDC_HEOCFG0_BLENUV_Msk (0x3u << LCDC_HEOCFG0_BLENUV_Pos) /**< \brief (LCDC_HEOCFG0) AHB Burst Length for U-V channel */
#define   LCDC_HEOCFG0_BLENUV_AHB_SINGLE (0x0u << 6) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_HEOCFG0_BLENUV_AHB_INCR4 (0x1u << 6) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_HEOCFG0_BLENUV_AHB_INCR8 (0x2u << 6) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define   LCDC_HEOCFG0_BLENUV_AHB_INCR16 (0x3u << 6) /**< \brief (LCDC_HEOCFG0) AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats. */
#define LCDC_HEOCFG0_DLBO (0x1u << 8) /**< \brief (LCDC_HEOCFG0) Defined Length Burst Only For Channel Bus Transaction. */
#define LCDC_HEOCFG0_ROTDIS (0x1u << 12) /**< \brief (LCDC_HEOCFG0) Hardware Rotation Optimization Disable */
#define LCDC_HEOCFG0_LOCKDIS (0x1u << 13) /**< \brief (LCDC_HEOCFG0) Hardware Rotation Lock Disable */
/* -------- LCDC_HEOCFG1 : (LCDC Offset: 0x00000390) High-End Overlay Configuration Register 1 -------- */
#define LCDC_HEOCFG1_CLUTEN (0x1u << 0) /**< \brief (LCDC_HEOCFG1) Color Lookup Table Enable */
#define LCDC_HEOCFG1_YUVEN (0x1u << 1) /**< \brief (LCDC_HEOCFG1) YUV Color Space Enable */
#define LCDC_HEOCFG1_RGBMODE_Pos 4
#define LCDC_HEOCFG1_RGBMODE_Msk (0xfu << LCDC_HEOCFG1_RGBMODE_Pos) /**< \brief (LCDC_HEOCFG1) RGB input mode selection */
#define   LCDC_HEOCFG1_RGBMODE_12BPP_RGB_444 (0x0u << 4) /**< \brief (LCDC_HEOCFG1) 12 bpp RGB 444 */
#define   LCDC_HEOCFG1_RGBMODE_16BPP_ARGB_4444 (0x1u << 4) /**< \brief (LCDC_HEOCFG1) 16 bpp ARGB 4444 */
#define   LCDC_HEOCFG1_RGBMODE_16BPP_RGBA_4444 (0x2u << 4) /**< \brief (LCDC_HEOCFG1) 16 bpp RGBA 4444 */
#define   LCDC_HEOCFG1_RGBMODE_16BPP_RGB_565 (0x3u << 4) /**< \brief (LCDC_HEOCFG1) 16 bpp RGB 565 */
#define   LCDC_HEOCFG1_RGBMODE_16BPP_TRGB_1555 (0x4u << 4) /**< \brief (LCDC_HEOCFG1) 16 bpp TRGB 1555 */
#define   LCDC_HEOCFG1_RGBMODE_18BPP_RGB_666 (0x5u << 4) /**< \brief (LCDC_HEOCFG1) 18 bpp RGB 666 */
#define   LCDC_HEOCFG1_RGBMODE_18BPP_RGB_666PACKED (0x6u << 4) /**< \brief (LCDC_HEOCFG1) 18 bpp RGB 666 PACKED */
#define   LCDC_HEOCFG1_RGBMODE_19BPP_TRGB_1666 (0x7u << 4) /**< \brief (LCDC_HEOCFG1) 19 bpp TRGB 1666 */
#define   LCDC_HEOCFG1_RGBMODE_19BPP_TRGB_PACKED (0x8u << 4) /**< \brief (LCDC_HEOCFG1) 19 bpp TRGB 1666 PACKED */
#define   LCDC_HEOCFG1_RGBMODE_24BPP_RGB_888 (0x9u << 4) /**< \brief (LCDC_HEOCFG1) 24 bpp RGB 888 */
#define   LCDC_HEOCFG1_RGBMODE_24BPP_RGB_888_PACKED (0xAu << 4) /**< \brief (LCDC_HEOCFG1) 24 bpp RGB 888 PACKED */
#define   LCDC_HEOCFG1_RGBMODE_25BPP_TRGB_1888 (0xBu << 4) /**< \brief (LCDC_HEOCFG1) 25 bpp TRGB 1888 */
#define   LCDC_HEOCFG1_RGBMODE_32BPP_ARGB_8888 (0xCu << 4) /**< \brief (LCDC_HEOCFG1) 32 bpp ARGB 8888 */
#define   LCDC_HEOCFG1_RGBMODE_32BPP_RGBA_8888 (0xDu << 4) /**< \brief (LCDC_HEOCFG1) 32 bpp RGBA 8888 */
#define LCDC_HEOCFG1_CLUTMODE_Pos 8
#define LCDC_HEOCFG1_CLUTMODE_Msk (0x3u << LCDC_HEOCFG1_CLUTMODE_Pos) /**< \brief (LCDC_HEOCFG1) Color Lookup table input mode selection */
#define   LCDC_HEOCFG1_CLUTMODE_CLUT_1BPP (0x0u << 8) /**< \brief (LCDC_HEOCFG1) color lookup table mode set to 1 bit per pixel */
#define   LCDC_HEOCFG1_CLUTMODE_CLUT_2BPP (0x1u << 8) /**< \brief (LCDC_HEOCFG1) color lookup table mode set to 2 bits per pixel */
#define   LCDC_HEOCFG1_CLUTMODE_CLUT_4BPP (0x2u << 8) /**< \brief (LCDC_HEOCFG1) color lookup table mode set to 4 bits per pixel */
#define   LCDC_HEOCFG1_CLUTMODE_CLUT_8BPP (0x3u << 8) /**< \brief (LCDC_HEOCFG1) color lookup table mode set to 8 bits per pixel */
#define LCDC_HEOCFG1_YUVMODE_Pos 12
#define LCDC_HEOCFG1_YUVMODE_Msk (0xfu << LCDC_HEOCFG1_YUVMODE_Pos) /**< \brief (LCDC_HEOCFG1) YUV input mode selection */
#define   LCDC_HEOCFG1_YUVMODE_32BPP_AYCBCR (0x0u << 12) /**< \brief (LCDC_HEOCFG1) 32 bpp AYCbCr 444 */
#define   LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE0 (0x1u << 12) /**< \brief (LCDC_HEOCFG1) 16 bpp Cr(n)Y(n+1)Cb(n)Y(n) 422 */
#define   LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE1 (0x2u << 12) /**< \brief (LCDC_HEOCFG1) 16 bpp Y(n+1)Cr(n)Y(n)Cb(n) 422 */
#define   LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE2 (0x3u << 12) /**< \brief (LCDC_HEOCFG1) 16 bpp Cb(n)Y(+1)Cr(n)Y(n) 422 */
#define   LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE3 (0x4u << 12) /**< \brief (LCDC_HEOCFG1) 16 bpp Y(n+1)Cb(n)Y(n)Cr(n) 422 */
#define   LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_SEMIPLANAR (0x5u << 12) /**< \brief (LCDC_HEOCFG1) 16 bpp Semiplanar 422 YCbCr */
#define   LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_PLANAR (0x6u << 12) /**< \brief (LCDC_HEOCFG1) 16 bpp Planar 422 YCbCr */
#define   LCDC_HEOCFG1_YUVMODE_12BPP_YCBCR_SEMIPLANAR (0x7u << 12) /**< \brief (LCDC_HEOCFG1) 12 bpp Semiplanar 420 YCbCr */
#define   LCDC_HEOCFG1_YUVMODE_12BPP_YCBCR_PLANAR (0x8u << 12) /**< \brief (LCDC_HEOCFG1) 12 bpp Planar 420 YCbCr */
#define LCDC_HEOCFG1_YUV422ROT (0x1u << 16) /**< \brief (LCDC_HEOCFG1) YUV 4:2:2 Rotation */
#define LCDC_HEOCFG1_YUV422SWP (0x1u << 17) /**< \brief (LCDC_HEOCFG1) YUV 4:2:2 SWAP */
#define LCDC_HEOCFG1_DSCALEOPT (0x1u << 20) /**< \brief (LCDC_HEOCFG1) Down Scaling Bandwidth Optimization */
/* -------- LCDC_HEOCFG2 : (LCDC Offset: 0x00000394) High-End Overlay Configuration Register 2 -------- */
#define LCDC_HEOCFG2_XPOS_Pos 0
#define LCDC_HEOCFG2_XPOS_Msk (0x7ffu << LCDC_HEOCFG2_XPOS_Pos) /**< \brief (LCDC_HEOCFG2) Horizontal Window Position */
#define LCDC_HEOCFG2_XPOS(value) ((LCDC_HEOCFG2_XPOS_Msk & ((value) << LCDC_HEOCFG2_XPOS_Pos)))
#define LCDC_HEOCFG2_YPOS_Pos 16
#define LCDC_HEOCFG2_YPOS_Msk (0x7ffu << LCDC_HEOCFG2_YPOS_Pos) /**< \brief (LCDC_HEOCFG2) Vertical Window Position */
#define LCDC_HEOCFG2_YPOS(value) ((LCDC_HEOCFG2_YPOS_Msk & ((value) << LCDC_HEOCFG2_YPOS_Pos)))
/* -------- LCDC_HEOCFG3 : (LCDC Offset: 0x00000398) High-End Overlay Configuration Register 3 -------- */
#define LCDC_HEOCFG3_XSIZE_Pos 0
#define LCDC_HEOCFG3_XSIZE_Msk (0x7ffu << LCDC_HEOCFG3_XSIZE_Pos) /**< \brief (LCDC_HEOCFG3) Horizontal Window Size */
#define LCDC_HEOCFG3_XSIZE(value) ((LCDC_HEOCFG3_XSIZE_Msk & ((value) << LCDC_HEOCFG3_XSIZE_Pos)))
#define LCDC_HEOCFG3_YSIZE_Pos 16
#define LCDC_HEOCFG3_YSIZE_Msk (0x7ffu << LCDC_HEOCFG3_YSIZE_Pos) /**< \brief (LCDC_HEOCFG3) Vertical Window Size */
#define LCDC_HEOCFG3_YSIZE(value) ((LCDC_HEOCFG3_YSIZE_Msk & ((value) << LCDC_HEOCFG3_YSIZE_Pos)))
/* -------- LCDC_HEOCFG4 : (LCDC Offset: 0x0000039C) High-End Overlay Configuration Register 4 -------- */
#define LCDC_HEOCFG4_XMEMSIZE_Pos 0
#define LCDC_HEOCFG4_XMEMSIZE_Msk (0x7ffu << LCDC_HEOCFG4_XMEMSIZE_Pos) /**< \brief (LCDC_HEOCFG4) Horizontal image Size in Memory */
#define LCDC_HEOCFG4_XMEMSIZE(value) ((LCDC_HEOCFG4_XMEMSIZE_Msk & ((value) << LCDC_HEOCFG4_XMEMSIZE_Pos)))
#define LCDC_HEOCFG4_YMEMSIZE_Pos 16
#define LCDC_HEOCFG4_YMEMSIZE_Msk (0x7ffu << LCDC_HEOCFG4_YMEMSIZE_Pos) /**< \brief (LCDC_HEOCFG4) Vertical image Size in Memory */
#define LCDC_HEOCFG4_YMEMSIZE(value) ((LCDC_HEOCFG4_YMEMSIZE_Msk & ((value) << LCDC_HEOCFG4_YMEMSIZE_Pos)))
/* -------- LCDC_HEOCFG5 : (LCDC Offset: 0x000003A0) High-End Overlay Configuration Register 5 -------- */
#define LCDC_HEOCFG5_XSTRIDE_Pos 0
#define LCDC_HEOCFG5_XSTRIDE_Msk (0xffffffffu << LCDC_HEOCFG5_XSTRIDE_Pos) /**< \brief (LCDC_HEOCFG5) Horizontal Stride */
#define LCDC_HEOCFG5_XSTRIDE(value) ((LCDC_HEOCFG5_XSTRIDE_Msk & ((value) << LCDC_HEOCFG5_XSTRIDE_Pos)))
/* -------- LCDC_HEOCFG6 : (LCDC Offset: 0x000003A4) High-End Overlay Configuration Register 6 -------- */
#define LCDC_HEOCFG6_PSTRIDE_Pos 0
#define LCDC_HEOCFG6_PSTRIDE_Msk (0xffffffffu << LCDC_HEOCFG6_PSTRIDE_Pos) /**< \brief (LCDC_HEOCFG6) Pixel Stride */
#define LCDC_HEOCFG6_PSTRIDE(value) ((LCDC_HEOCFG6_PSTRIDE_Msk & ((value) << LCDC_HEOCFG6_PSTRIDE_Pos)))
/* -------- LCDC_HEOCFG7 : (LCDC Offset: 0x000003A8) High-End Overlay Configuration Register 7 -------- */
#define LCDC_HEOCFG7_UVXSTRIDE_Pos 0
#define LCDC_HEOCFG7_UVXSTRIDE_Msk (0xffffffffu << LCDC_HEOCFG7_UVXSTRIDE_Pos) /**< \brief (LCDC_HEOCFG7) UV Horizontal Stride */
#define LCDC_HEOCFG7_UVXSTRIDE(value) ((LCDC_HEOCFG7_UVXSTRIDE_Msk & ((value) << LCDC_HEOCFG7_UVXSTRIDE_Pos)))
/* -------- LCDC_HEOCFG8 : (LCDC Offset: 0x000003AC) High-End Overlay Configuration Register 8 -------- */
#define LCDC_HEOCFG8_UVPSTRIDE_Pos 0
#define LCDC_HEOCFG8_UVPSTRIDE_Msk (0xffffffffu << LCDC_HEOCFG8_UVPSTRIDE_Pos) /**< \brief (LCDC_HEOCFG8) UV Pixel Stride */
#define LCDC_HEOCFG8_UVPSTRIDE(value) ((LCDC_HEOCFG8_UVPSTRIDE_Msk & ((value) << LCDC_HEOCFG8_UVPSTRIDE_Pos)))
/* -------- LCDC_HEOCFG9 : (LCDC Offset: 0x000003B0) High-End Overlay Configuration Register 9 -------- */
#define LCDC_HEOCFG9_BDEF_Pos 0
#define LCDC_HEOCFG9_BDEF_Msk (0xffu << LCDC_HEOCFG9_BDEF_Pos) /**< \brief (LCDC_HEOCFG9) Blue Default */
#define LCDC_HEOCFG9_BDEF(value) ((LCDC_HEOCFG9_BDEF_Msk & ((value) << LCDC_HEOCFG9_BDEF_Pos)))
#define LCDC_HEOCFG9_GDEF_Pos 8
#define LCDC_HEOCFG9_GDEF_Msk (0xffu << LCDC_HEOCFG9_GDEF_Pos) /**< \brief (LCDC_HEOCFG9) Green Default */
#define LCDC_HEOCFG9_GDEF(value) ((LCDC_HEOCFG9_GDEF_Msk & ((value) << LCDC_HEOCFG9_GDEF_Pos)))
#define LCDC_HEOCFG9_RDEF_Pos 16
#define LCDC_HEOCFG9_RDEF_Msk (0xffu << LCDC_HEOCFG9_RDEF_Pos) /**< \brief (LCDC_HEOCFG9) Red Default */
#define LCDC_HEOCFG9_RDEF(value) ((LCDC_HEOCFG9_RDEF_Msk & ((value) << LCDC_HEOCFG9_RDEF_Pos)))
/* -------- LCDC_HEOCFG10 : (LCDC Offset: 0x000003B4) High-End Overlay Configuration Register 10 -------- */
#define LCDC_HEOCFG10_BKEY_Pos 0
#define LCDC_HEOCFG10_BKEY_Msk (0xffu << LCDC_HEOCFG10_BKEY_Pos) /**< \brief (LCDC_HEOCFG10) Blue Color Component Chroma Key */
#define LCDC_HEOCFG10_BKEY(value) ((LCDC_HEOCFG10_BKEY_Msk & ((value) << LCDC_HEOCFG10_BKEY_Pos)))
#define LCDC_HEOCFG10_GKEY_Pos 8
#define LCDC_HEOCFG10_GKEY_Msk (0xffu << LCDC_HEOCFG10_GKEY_Pos) /**< \brief (LCDC_HEOCFG10) Green Color Component Chroma Key */
#define LCDC_HEOCFG10_GKEY(value) ((LCDC_HEOCFG10_GKEY_Msk & ((value) << LCDC_HEOCFG10_GKEY_Pos)))
#define LCDC_HEOCFG10_RKEY_Pos 16
#define LCDC_HEOCFG10_RKEY_Msk (0xffu << LCDC_HEOCFG10_RKEY_Pos) /**< \brief (LCDC_HEOCFG10) Red Color Component Chroma Key */
#define LCDC_HEOCFG10_RKEY(value) ((LCDC_HEOCFG10_RKEY_Msk & ((value) << LCDC_HEOCFG10_RKEY_Pos)))
/* -------- LCDC_HEOCFG11 : (LCDC Offset: 0x000003B8) High-End Overlay Configuration Register 11 -------- */
#define LCDC_HEOCFG11_BMASK_Pos 0
#define LCDC_HEOCFG11_BMASK_Msk (0xffu << LCDC_HEOCFG11_BMASK_Pos) /**< \brief (LCDC_HEOCFG11) Blue Color Component Chroma Key Mask */
#define LCDC_HEOCFG11_BMASK(value) ((LCDC_HEOCFG11_BMASK_Msk & ((value) << LCDC_HEOCFG11_BMASK_Pos)))
#define LCDC_HEOCFG11_GMASK_Pos 8
#define LCDC_HEOCFG11_GMASK_Msk (0xffu << LCDC_HEOCFG11_GMASK_Pos) /**< \brief (LCDC_HEOCFG11) Green Color Component Chroma Key Mask */
#define LCDC_HEOCFG11_GMASK(value) ((LCDC_HEOCFG11_GMASK_Msk & ((value) << LCDC_HEOCFG11_GMASK_Pos)))
#define LCDC_HEOCFG11_RMASK_Pos 16
#define LCDC_HEOCFG11_RMASK_Msk (0xffu << LCDC_HEOCFG11_RMASK_Pos) /**< \brief (LCDC_HEOCFG11) Red Color Component Chroma Key Mask */
#define LCDC_HEOCFG11_RMASK(value) ((LCDC_HEOCFG11_RMASK_Msk & ((value) << LCDC_HEOCFG11_RMASK_Pos)))
/* -------- LCDC_HEOCFG12 : (LCDC Offset: 0x000003BC) High-End Overlay Configuration Register 12 -------- */
#define LCDC_HEOCFG12_CRKEY (0x1u << 0) /**< \brief (LCDC_HEOCFG12) Blender Chroma Key Enable */
#define LCDC_HEOCFG12_INV (0x1u << 1) /**< \brief (LCDC_HEOCFG12) Blender Inverted Blender Output Enable */
#define LCDC_HEOCFG12_ITER2BL (0x1u << 2) /**< \brief (LCDC_HEOCFG12) Blender Iterated Color Enable */
#define LCDC_HEOCFG12_ITER (0x1u << 3) /**< \brief (LCDC_HEOCFG12) Blender Use Iterated Color */
#define LCDC_HEOCFG12_REVALPHA (0x1u << 4) /**< \brief (LCDC_HEOCFG12) Blender Reverse Alpha */
#define LCDC_HEOCFG12_GAEN (0x1u << 5) /**< \brief (LCDC_HEOCFG12) Blender Global Alpha Enable */
#define LCDC_HEOCFG12_LAEN (0x1u << 6) /**< \brief (LCDC_HEOCFG12) Blender Local Alpha Enable */
#define LCDC_HEOCFG12_OVR (0x1u << 7) /**< \brief (LCDC_HEOCFG12) Blender Overlay Layer Enable */
#define LCDC_HEOCFG12_DMA (0x1u << 8) /**< \brief (LCDC_HEOCFG12) Blender DMA Layer Enable */
#define LCDC_HEOCFG12_REP (0x1u << 9) /**< \brief (LCDC_HEOCFG12) Use Replication logic to expand RGB color to 24 bits */
#define LCDC_HEOCFG12_DSTKEY (0x1u << 10) /**< \brief (LCDC_HEOCFG12) Destination Chroma Keying */
#define LCDC_HEOCFG12_VIDPRI (0x1u << 12) /**< \brief (LCDC_HEOCFG12) Video Priority */
#define LCDC_HEOCFG12_GA_Pos 16
#define LCDC_HEOCFG12_GA_Msk (0xffu << LCDC_HEOCFG12_GA_Pos) /**< \brief (LCDC_HEOCFG12) Blender Global Alpha */
#define LCDC_HEOCFG12_GA(value) ((LCDC_HEOCFG12_GA_Msk & ((value) << LCDC_HEOCFG12_GA_Pos)))
/* -------- LCDC_HEOCFG13 : (LCDC Offset: 0x000003C0) High-End Overlay Configuration Register 13 -------- */
#define LCDC_HEOCFG13_XFACTOR_Pos 0
#define LCDC_HEOCFG13_XFACTOR_Msk (0x3fffu << LCDC_HEOCFG13_XFACTOR_Pos) /**< \brief (LCDC_HEOCFG13) Horizontal Scaling Factor */
#define LCDC_HEOCFG13_XFACTOR(value) ((LCDC_HEOCFG13_XFACTOR_Msk & ((value) << LCDC_HEOCFG13_XFACTOR_Pos)))
#define LCDC_HEOCFG13_YFACTOR_Pos 16
#define LCDC_HEOCFG13_YFACTOR_Msk (0x3fffu << LCDC_HEOCFG13_YFACTOR_Pos) /**< \brief (LCDC_HEOCFG13) Vertical Scaling Factor */
#define LCDC_HEOCFG13_YFACTOR(value) ((LCDC_HEOCFG13_YFACTOR_Msk & ((value) << LCDC_HEOCFG13_YFACTOR_Pos)))
#define LCDC_HEOCFG13_SCALEN (0x1u << 31) /**< \brief (LCDC_HEOCFG13) Hardware Scaler Enable */
/* -------- LCDC_HEOCFG14 : (LCDC Offset: 0x000003C4) High-End Overlay Configuration Register 14 -------- */
#define LCDC_HEOCFG14_CSCRY_Pos 0
#define LCDC_HEOCFG14_CSCRY_Msk (0x3ffu << LCDC_HEOCFG14_CSCRY_Pos) /**< \brief (LCDC_HEOCFG14) Color Space Conversion Y coefficient for Red Component 1:2:7 format */
#define LCDC_HEOCFG14_CSCRY(value) ((LCDC_HEOCFG14_CSCRY_Msk & ((value) << LCDC_HEOCFG14_CSCRY_Pos)))
#define LCDC_HEOCFG14_CSCRU_Pos 10
#define LCDC_HEOCFG14_CSCRU_Msk (0x3ffu << LCDC_HEOCFG14_CSCRU_Pos) /**< \brief (LCDC_HEOCFG14) Color Space Conversion U coefficient for Red Component 1:2:7 format */
#define LCDC_HEOCFG14_CSCRU(value) ((LCDC_HEOCFG14_CSCRU_Msk & ((value) << LCDC_HEOCFG14_CSCRU_Pos)))
#define LCDC_HEOCFG14_CSCRV_Pos 20
#define LCDC_HEOCFG14_CSCRV_Msk (0x3ffu << LCDC_HEOCFG14_CSCRV_Pos) /**< \brief (LCDC_HEOCFG14) Color Space Conversion V coefficient for Red Component 1:2:7 format */
#define LCDC_HEOCFG14_CSCRV(value) ((LCDC_HEOCFG14_CSCRV_Msk & ((value) << LCDC_HEOCFG14_CSCRV_Pos)))
#define LCDC_HEOCFG14_CSCYOFF (0x1u << 30) /**< \brief (LCDC_HEOCFG14) Color Space Conversion Offset */
/* -------- LCDC_HEOCFG15 : (LCDC Offset: 0x000003C8) High-End Overlay Configuration Register 15 -------- */
#define LCDC_HEOCFG15_CSCGY_Pos 0
#define LCDC_HEOCFG15_CSCGY_Msk (0x3ffu << LCDC_HEOCFG15_CSCGY_Pos) /**< \brief (LCDC_HEOCFG15) Color Space Conversion Y coefficient for Green Component 1:2:7 format */
#define LCDC_HEOCFG15_CSCGY(value) ((LCDC_HEOCFG15_CSCGY_Msk & ((value) << LCDC_HEOCFG15_CSCGY_Pos)))
#define LCDC_HEOCFG15_CSCGU_Pos 10
#define LCDC_HEOCFG15_CSCGU_Msk (0x3ffu << LCDC_HEOCFG15_CSCGU_Pos) /**< \brief (LCDC_HEOCFG15) Color Space Conversion U coefficient for Green Component 1:2:7 format */
#define LCDC_HEOCFG15_CSCGU(value) ((LCDC_HEOCFG15_CSCGU_Msk & ((value) << LCDC_HEOCFG15_CSCGU_Pos)))
#define LCDC_HEOCFG15_CSCGV_Pos 20
#define LCDC_HEOCFG15_CSCGV_Msk (0x3ffu << LCDC_HEOCFG15_CSCGV_Pos) /**< \brief (LCDC_HEOCFG15) Color Space Conversion V coefficient for Green Component 1:2:7 format */
#define LCDC_HEOCFG15_CSCGV(value) ((LCDC_HEOCFG15_CSCGV_Msk & ((value) << LCDC_HEOCFG15_CSCGV_Pos)))
#define LCDC_HEOCFG15_CSCUOFF (0x1u << 30) /**< \brief (LCDC_HEOCFG15) Color Space Conversion Offset */
/* -------- LCDC_HEOCFG16 : (LCDC Offset: 0x000003CC) High-End Overlay Configuration Register 16 -------- */
#define LCDC_HEOCFG16_CSCBY_Pos 0
#define LCDC_HEOCFG16_CSCBY_Msk (0x3ffu << LCDC_HEOCFG16_CSCBY_Pos) /**< \brief (LCDC_HEOCFG16) Color Space Conversion Y coefficient for Blue Component 1:2:7 format */
#define LCDC_HEOCFG16_CSCBY(value) ((LCDC_HEOCFG16_CSCBY_Msk & ((value) << LCDC_HEOCFG16_CSCBY_Pos)))
#define LCDC_HEOCFG16_CSCBU_Pos 10
#define LCDC_HEOCFG16_CSCBU_Msk (0x3ffu << LCDC_HEOCFG16_CSCBU_Pos) /**< \brief (LCDC_HEOCFG16) Color Space Conversion U coefficient for Blue Component 1:2:7 format */
#define LCDC_HEOCFG16_CSCBU(value) ((LCDC_HEOCFG16_CSCBU_Msk & ((value) << LCDC_HEOCFG16_CSCBU_Pos)))
#define LCDC_HEOCFG16_CSCBV_Pos 20
#define LCDC_HEOCFG16_CSCBV_Msk (0x3ffu << LCDC_HEOCFG16_CSCBV_Pos) /**< \brief (LCDC_HEOCFG16) Color Space Conversion V coefficient for Blue Component 1:2:7 format */
#define LCDC_HEOCFG16_CSCBV(value) ((LCDC_HEOCFG16_CSCBV_Msk & ((value) << LCDC_HEOCFG16_CSCBV_Pos)))
#define LCDC_HEOCFG16_CSCVOFF (0x1u << 30) /**< \brief (LCDC_HEOCFG16) Color Space Conversion Offset */
/* -------- LCDC_HEOCFG17 : (LCDC Offset: 0x000003D0) High-End Overlay Configuration Register 17 -------- */
#define LCDC_HEOCFG17_XPHI0COEFF0_Pos 0
#define LCDC_HEOCFG17_XPHI0COEFF0_Msk (0xffu << LCDC_HEOCFG17_XPHI0COEFF0_Pos) /**< \brief (LCDC_HEOCFG17) Horizontal Coefficient for phase 0 tap 0 */
#define LCDC_HEOCFG17_XPHI0COEFF0(value) ((LCDC_HEOCFG17_XPHI0COEFF0_Msk & ((value) << LCDC_HEOCFG17_XPHI0COEFF0_Pos)))
#define LCDC_HEOCFG17_XPHI0COEFF1_Pos 8
#define LCDC_HEOCFG17_XPHI0COEFF1_Msk (0xffu << LCDC_HEOCFG17_XPHI0COEFF1_Pos) /**< \brief (LCDC_HEOCFG17) Horizontal Coefficient for phase 0 tap 1 */
#define LCDC_HEOCFG17_XPHI0COEFF1(value) ((LCDC_HEOCFG17_XPHI0COEFF1_Msk & ((value) << LCDC_HEOCFG17_XPHI0COEFF1_Pos)))
#define LCDC_HEOCFG17_XPHI0COEFF2_Pos 16
#define LCDC_HEOCFG17_XPHI0COEFF2_Msk (0xffu << LCDC_HEOCFG17_XPHI0COEFF2_Pos) /**< \brief (LCDC_HEOCFG17) Horizontal Coefficient for phase 0 tap 2 */
#define LCDC_HEOCFG17_XPHI0COEFF2(value) ((LCDC_HEOCFG17_XPHI0COEFF2_Msk & ((value) << LCDC_HEOCFG17_XPHI0COEFF2_Pos)))
#define LCDC_HEOCFG17_XPHI0COEFF3_Pos 24
#define LCDC_HEOCFG17_XPHI0COEFF3_Msk (0xffu << LCDC_HEOCFG17_XPHI0COEFF3_Pos) /**< \brief (LCDC_HEOCFG17) Horizontal Coefficient for phase 0 tap 3 */
#define LCDC_HEOCFG17_XPHI0COEFF3(value) ((LCDC_HEOCFG17_XPHI0COEFF3_Msk & ((value) << LCDC_HEOCFG17_XPHI0COEFF3_Pos)))
/* -------- LCDC_HEOCFG18 : (LCDC Offset: 0x000003D4) High-End Overlay Configuration Register 18 -------- */
#define LCDC_HEOCFG18_XPHI0COEFF4_Pos 0
#define LCDC_HEOCFG18_XPHI0COEFF4_Msk (0xffu << LCDC_HEOCFG18_XPHI0COEFF4_Pos) /**< \brief (LCDC_HEOCFG18) Horizontal Coefficient for phase 0 tap 4 */
#define LCDC_HEOCFG18_XPHI0COEFF4(value) ((LCDC_HEOCFG18_XPHI0COEFF4_Msk & ((value) << LCDC_HEOCFG18_XPHI0COEFF4_Pos)))
/* -------- LCDC_HEOCFG19 : (LCDC Offset: 0x000003D8) High-End Overlay Configuration Register 19 -------- */
#define LCDC_HEOCFG19_XPHI1COEFF0_Pos 0
#define LCDC_HEOCFG19_XPHI1COEFF0_Msk (0xffu << LCDC_HEOCFG19_XPHI1COEFF0_Pos) /**< \brief (LCDC_HEOCFG19) Horizontal Coefficient for phase 1 tap 0 */
#define LCDC_HEOCFG19_XPHI1COEFF0(value) ((LCDC_HEOCFG19_XPHI1COEFF0_Msk & ((value) << LCDC_HEOCFG19_XPHI1COEFF0_Pos)))
#define LCDC_HEOCFG19_XPHI1COEFF1_Pos 8
#define LCDC_HEOCFG19_XPHI1COEFF1_Msk (0xffu << LCDC_HEOCFG19_XPHI1COEFF1_Pos) /**< \brief (LCDC_HEOCFG19) Horizontal Coefficient for phase 1 tap 1 */
#define LCDC_HEOCFG19_XPHI1COEFF1(value) ((LCDC_HEOCFG19_XPHI1COEFF1_Msk & ((value) << LCDC_HEOCFG19_XPHI1COEFF1_Pos)))
#define LCDC_HEOCFG19_XPHI1COEFF2_Pos 16
#define LCDC_HEOCFG19_XPHI1COEFF2_Msk (0xffu << LCDC_HEOCFG19_XPHI1COEFF2_Pos) /**< \brief (LCDC_HEOCFG19) Horizontal Coefficient for phase 1 tap 2 */
#define LCDC_HEOCFG19_XPHI1COEFF2(value) ((LCDC_HEOCFG19_XPHI1COEFF2_Msk & ((value) << LCDC_HEOCFG19_XPHI1COEFF2_Pos)))
#define LCDC_HEOCFG19_XPHI1COEFF3_Pos 24
#define LCDC_HEOCFG19_XPHI1COEFF3_Msk (0xffu << LCDC_HEOCFG19_XPHI1COEFF3_Pos) /**< \brief (LCDC_HEOCFG19) Horizontal Coefficient for phase 1 tap 3 */
#define LCDC_HEOCFG19_XPHI1COEFF3(value) ((LCDC_HEOCFG19_XPHI1COEFF3_Msk & ((value) << LCDC_HEOCFG19_XPHI1COEFF3_Pos)))
/* -------- LCDC_HEOCFG20 : (LCDC Offset: 0x000003DC) High-End Overlay Configuration Register 20 -------- */
#define LCDC_HEOCFG20_XPHI1COEFF4_Pos 0
#define LCDC_HEOCFG20_XPHI1COEFF4_Msk (0xffu << LCDC_HEOCFG20_XPHI1COEFF4_Pos) /**< \brief (LCDC_HEOCFG20) Horizontal Coefficient for phase 1 tap 4 */
#define LCDC_HEOCFG20_XPHI1COEFF4(value) ((LCDC_HEOCFG20_XPHI1COEFF4_Msk & ((value) << LCDC_HEOCFG20_XPHI1COEFF4_Pos)))
/* -------- LCDC_HEOCFG21 : (LCDC Offset: 0x000003E0) High-End Overlay Configuration Register 21 -------- */
#define LCDC_HEOCFG21_XPHI2COEFF0_Pos 0
#define LCDC_HEOCFG21_XPHI2COEFF0_Msk (0xffu << LCDC_HEOCFG21_XPHI2COEFF0_Pos) /**< \brief (LCDC_HEOCFG21) Horizontal Coefficient for phase 2 tap 0 */
#define LCDC_HEOCFG21_XPHI2COEFF0(value) ((LCDC_HEOCFG21_XPHI2COEFF0_Msk & ((value) << LCDC_HEOCFG21_XPHI2COEFF0_Pos)))
#define LCDC_HEOCFG21_XPHI2COEFF1_Pos 8
#define LCDC_HEOCFG21_XPHI2COEFF1_Msk (0xffu << LCDC_HEOCFG21_XPHI2COEFF1_Pos) /**< \brief (LCDC_HEOCFG21) Horizontal Coefficient for phase 2 tap 1 */
#define LCDC_HEOCFG21_XPHI2COEFF1(value) ((LCDC_HEOCFG21_XPHI2COEFF1_Msk & ((value) << LCDC_HEOCFG21_XPHI2COEFF1_Pos)))
#define LCDC_HEOCFG21_XPHI2COEFF2_Pos 16
#define LCDC_HEOCFG21_XPHI2COEFF2_Msk (0xffu << LCDC_HEOCFG21_XPHI2COEFF2_Pos) /**< \brief (LCDC_HEOCFG21) Horizontal Coefficient for phase 2 tap 2 */
#define LCDC_HEOCFG21_XPHI2COEFF2(value) ((LCDC_HEOCFG21_XPHI2COEFF2_Msk & ((value) << LCDC_HEOCFG21_XPHI2COEFF2_Pos)))
#define LCDC_HEOCFG21_XPHI2COEFF3_Pos 24
#define LCDC_HEOCFG21_XPHI2COEFF3_Msk (0xffu << LCDC_HEOCFG21_XPHI2COEFF3_Pos) /**< \brief (LCDC_HEOCFG21) Horizontal Coefficient for phase 2 tap 3 */
#define LCDC_HEOCFG21_XPHI2COEFF3(value) ((LCDC_HEOCFG21_XPHI2COEFF3_Msk & ((value) << LCDC_HEOCFG21_XPHI2COEFF3_Pos)))
/* -------- LCDC_HEOCFG22 : (LCDC Offset: 0x000003E4) High-End Overlay Configuration Register 22 -------- */
#define LCDC_HEOCFG22_XPHI2COEFF4_Pos 0
#define LCDC_HEOCFG22_XPHI2COEFF4_Msk (0xffu << LCDC_HEOCFG22_XPHI2COEFF4_Pos) /**< \brief (LCDC_HEOCFG22) Horizontal Coefficient for phase 2 tap 4 */
#define LCDC_HEOCFG22_XPHI2COEFF4(value) ((LCDC_HEOCFG22_XPHI2COEFF4_Msk & ((value) << LCDC_HEOCFG22_XPHI2COEFF4_Pos)))
/* -------- LCDC_HEOCFG23 : (LCDC Offset: 0x000003E8) High-End Overlay Configuration Register 23 -------- */
#define LCDC_HEOCFG23_XPHI3COEFF0_Pos 0
#define LCDC_HEOCFG23_XPHI3COEFF0_Msk (0xffu << LCDC_HEOCFG23_XPHI3COEFF0_Pos) /**< \brief (LCDC_HEOCFG23) Horizontal Coefficient for phase 3 tap 0 */
#define LCDC_HEOCFG23_XPHI3COEFF0(value) ((LCDC_HEOCFG23_XPHI3COEFF0_Msk & ((value) << LCDC_HEOCFG23_XPHI3COEFF0_Pos)))
#define LCDC_HEOCFG23_XPHI3COEFF1_Pos 8
#define LCDC_HEOCFG23_XPHI3COEFF1_Msk (0xffu << LCDC_HEOCFG23_XPHI3COEFF1_Pos) /**< \brief (LCDC_HEOCFG23) Horizontal Coefficient for phase 3 tap 1 */
#define LCDC_HEOCFG23_XPHI3COEFF1(value) ((LCDC_HEOCFG23_XPHI3COEFF1_Msk & ((value) << LCDC_HEOCFG23_XPHI3COEFF1_Pos)))
#define LCDC_HEOCFG23_XPHI3COEFF2_Pos 16
#define LCDC_HEOCFG23_XPHI3COEFF2_Msk (0xffu << LCDC_HEOCFG23_XPHI3COEFF2_Pos) /**< \brief (LCDC_HEOCFG23) Horizontal Coefficient for phase 3 tap 2 */
#define LCDC_HEOCFG23_XPHI3COEFF2(value) ((LCDC_HEOCFG23_XPHI3COEFF2_Msk & ((value) << LCDC_HEOCFG23_XPHI3COEFF2_Pos)))
#define LCDC_HEOCFG23_XPHI3COEFF3_Pos 24
#define LCDC_HEOCFG23_XPHI3COEFF3_Msk (0xffu << LCDC_HEOCFG23_XPHI3COEFF3_Pos) /**< \brief (LCDC_HEOCFG23) Horizontal Coefficient for phase 3 tap 3 */
#define LCDC_HEOCFG23_XPHI3COEFF3(value) ((LCDC_HEOCFG23_XPHI3COEFF3_Msk & ((value) << LCDC_HEOCFG23_XPHI3COEFF3_Pos)))
/* -------- LCDC_HEOCFG24 : (LCDC Offset: 0x000003EC) High-End Overlay Configuration Register 24 -------- */
#define LCDC_HEOCFG24_XPHI3COEFF4_Pos 0
#define LCDC_HEOCFG24_XPHI3COEFF4_Msk (0xffu << LCDC_HEOCFG24_XPHI3COEFF4_Pos) /**< \brief (LCDC_HEOCFG24) Horizontal Coefficient for phase 3 tap 4 */
#define LCDC_HEOCFG24_XPHI3COEFF4(value) ((LCDC_HEOCFG24_XPHI3COEFF4_Msk & ((value) << LCDC_HEOCFG24_XPHI3COEFF4_Pos)))
/* -------- LCDC_HEOCFG25 : (LCDC Offset: 0x000003F0) High-End Overlay Configuration Register 25 -------- */
#define LCDC_HEOCFG25_XPHI4COEFF0_Pos 0
#define LCDC_HEOCFG25_XPHI4COEFF0_Msk (0xffu << LCDC_HEOCFG25_XPHI4COEFF0_Pos) /**< \brief (LCDC_HEOCFG25) Horizontal Coefficient for phase 4 tap 0 */
#define LCDC_HEOCFG25_XPHI4COEFF0(value) ((LCDC_HEOCFG25_XPHI4COEFF0_Msk & ((value) << LCDC_HEOCFG25_XPHI4COEFF0_Pos)))
#define LCDC_HEOCFG25_XPHI4COEFF1_Pos 8
#define LCDC_HEOCFG25_XPHI4COEFF1_Msk (0xffu << LCDC_HEOCFG25_XPHI4COEFF1_Pos) /**< \brief (LCDC_HEOCFG25) Horizontal Coefficient for phase 4 tap 1 */
#define LCDC_HEOCFG25_XPHI4COEFF1(value) ((LCDC_HEOCFG25_XPHI4COEFF1_Msk & ((value) << LCDC_HEOCFG25_XPHI4COEFF1_Pos)))
#define LCDC_HEOCFG25_XPHI4COEFF2_Pos 16
#define LCDC_HEOCFG25_XPHI4COEFF2_Msk (0xffu << LCDC_HEOCFG25_XPHI4COEFF2_Pos) /**< \brief (LCDC_HEOCFG25) Horizontal Coefficient for phase 4 tap 2 */
#define LCDC_HEOCFG25_XPHI4COEFF2(value) ((LCDC_HEOCFG25_XPHI4COEFF2_Msk & ((value) << LCDC_HEOCFG25_XPHI4COEFF2_Pos)))
#define LCDC_HEOCFG25_XPHI4COEFF3_Pos 24
#define LCDC_HEOCFG25_XPHI4COEFF3_Msk (0xffu << LCDC_HEOCFG25_XPHI4COEFF3_Pos) /**< \brief (LCDC_HEOCFG25) Horizontal Coefficient for phase 4 tap 3 */
#define LCDC_HEOCFG25_XPHI4COEFF3(value) ((LCDC_HEOCFG25_XPHI4COEFF3_Msk & ((value) << LCDC_HEOCFG25_XPHI4COEFF3_Pos)))
/* -------- LCDC_HEOCFG26 : (LCDC Offset: 0x000003F4) High-End Overlay Configuration Register 26 -------- */
#define LCDC_HEOCFG26_XPHI4COEFF4_Pos 0
#define LCDC_HEOCFG26_XPHI4COEFF4_Msk (0xffu << LCDC_HEOCFG26_XPHI4COEFF4_Pos) /**< \brief (LCDC_HEOCFG26) Horizontal Coefficient for phase 4 tap 4 */
#define LCDC_HEOCFG26_XPHI4COEFF4(value) ((LCDC_HEOCFG26_XPHI4COEFF4_Msk & ((value) << LCDC_HEOCFG26_XPHI4COEFF4_Pos)))
/* -------- LCDC_HEOCFG27 : (LCDC Offset: 0x000003F8) High-End Overlay Configuration Register 27 -------- */
#define LCDC_HEOCFG27_XPHI5COEFF0_Pos 0
#define LCDC_HEOCFG27_XPHI5COEFF0_Msk (0xffu << LCDC_HEOCFG27_XPHI5COEFF0_Pos) /**< \brief (LCDC_HEOCFG27) Horizontal Coefficient for phase 5 tap 0 */
#define LCDC_HEOCFG27_XPHI5COEFF0(value) ((LCDC_HEOCFG27_XPHI5COEFF0_Msk & ((value) << LCDC_HEOCFG27_XPHI5COEFF0_Pos)))
#define LCDC_HEOCFG27_XPHI5COEFF1_Pos 8
#define LCDC_HEOCFG27_XPHI5COEFF1_Msk (0xffu << LCDC_HEOCFG27_XPHI5COEFF1_Pos) /**< \brief (LCDC_HEOCFG27) Horizontal Coefficient for phase 5 tap 1 */
#define LCDC_HEOCFG27_XPHI5COEFF1(value) ((LCDC_HEOCFG27_XPHI5COEFF1_Msk & ((value) << LCDC_HEOCFG27_XPHI5COEFF1_Pos)))
#define LCDC_HEOCFG27_XPHI5COEFF2_Pos 16
#define LCDC_HEOCFG27_XPHI5COEFF2_Msk (0xffu << LCDC_HEOCFG27_XPHI5COEFF2_Pos) /**< \brief (LCDC_HEOCFG27) Horizontal Coefficient for phase 5 tap 2 */
#define LCDC_HEOCFG27_XPHI5COEFF2(value) ((LCDC_HEOCFG27_XPHI5COEFF2_Msk & ((value) << LCDC_HEOCFG27_XPHI5COEFF2_Pos)))
#define LCDC_HEOCFG27_XPHI5COEFF3_Pos 24
#define LCDC_HEOCFG27_XPHI5COEFF3_Msk (0xffu << LCDC_HEOCFG27_XPHI5COEFF3_Pos) /**< \brief (LCDC_HEOCFG27) Horizontal Coefficient for phase 5 tap 3 */
#define LCDC_HEOCFG27_XPHI5COEFF3(value) ((LCDC_HEOCFG27_XPHI5COEFF3_Msk & ((value) << LCDC_HEOCFG27_XPHI5COEFF3_Pos)))
/* -------- LCDC_HEOCFG28 : (LCDC Offset: 0x000003FC) High-End Overlay Configuration Register 28 -------- */
#define LCDC_HEOCFG28_XPHI5COEFF4_Pos 0
#define LCDC_HEOCFG28_XPHI5COEFF4_Msk (0xffu << LCDC_HEOCFG28_XPHI5COEFF4_Pos) /**< \brief (LCDC_HEOCFG28) Horizontal Coefficient for phase 5 tap 4 */
#define LCDC_HEOCFG28_XPHI5COEFF4(value) ((LCDC_HEOCFG28_XPHI5COEFF4_Msk & ((value) << LCDC_HEOCFG28_XPHI5COEFF4_Pos)))
/* -------- LCDC_HEOCFG29 : (LCDC Offset: 0x00000400) High-End Overlay Configuration Register 29 -------- */
#define LCDC_HEOCFG29_XPHI6COEFF0_Pos 0
#define LCDC_HEOCFG29_XPHI6COEFF0_Msk (0xffu << LCDC_HEOCFG29_XPHI6COEFF0_Pos) /**< \brief (LCDC_HEOCFG29) Horizontal Coefficient for phase 6 tap 0 */
#define LCDC_HEOCFG29_XPHI6COEFF0(value) ((LCDC_HEOCFG29_XPHI6COEFF0_Msk & ((value) << LCDC_HEOCFG29_XPHI6COEFF0_Pos)))
#define LCDC_HEOCFG29_XPHI6COEFF1_Pos 8
#define LCDC_HEOCFG29_XPHI6COEFF1_Msk (0xffu << LCDC_HEOCFG29_XPHI6COEFF1_Pos) /**< \brief (LCDC_HEOCFG29) Horizontal Coefficient for phase 6 tap 1 */
#define LCDC_HEOCFG29_XPHI6COEFF1(value) ((LCDC_HEOCFG29_XPHI6COEFF1_Msk & ((value) << LCDC_HEOCFG29_XPHI6COEFF1_Pos)))
#define LCDC_HEOCFG29_XPHI6COEFF2_Pos 16
#define LCDC_HEOCFG29_XPHI6COEFF2_Msk (0xffu << LCDC_HEOCFG29_XPHI6COEFF2_Pos) /**< \brief (LCDC_HEOCFG29) Horizontal Coefficient for phase 6 tap 2 */
#define LCDC_HEOCFG29_XPHI6COEFF2(value) ((LCDC_HEOCFG29_XPHI6COEFF2_Msk & ((value) << LCDC_HEOCFG29_XPHI6COEFF2_Pos)))
#define LCDC_HEOCFG29_XPHI6COEFF3_Pos 24
#define LCDC_HEOCFG29_XPHI6COEFF3_Msk (0xffu << LCDC_HEOCFG29_XPHI6COEFF3_Pos) /**< \brief (LCDC_HEOCFG29) Horizontal Coefficient for phase 6 tap 3 */
#define LCDC_HEOCFG29_XPHI6COEFF3(value) ((LCDC_HEOCFG29_XPHI6COEFF3_Msk & ((value) << LCDC_HEOCFG29_XPHI6COEFF3_Pos)))
/* -------- LCDC_HEOCFG30 : (LCDC Offset: 0x00000404) High-End Overlay Configuration Register 30 -------- */
#define LCDC_HEOCFG30_XPHI6COEFF4_Pos 0
#define LCDC_HEOCFG30_XPHI6COEFF4_Msk (0xffu << LCDC_HEOCFG30_XPHI6COEFF4_Pos) /**< \brief (LCDC_HEOCFG30) Horizontal Coefficient for phase 6 tap 4 */
#define LCDC_HEOCFG30_XPHI6COEFF4(value) ((LCDC_HEOCFG30_XPHI6COEFF4_Msk & ((value) << LCDC_HEOCFG30_XPHI6COEFF4_Pos)))
/* -------- LCDC_HEOCFG31 : (LCDC Offset: 0x00000408) High-End Overlay Configuration Register 31 -------- */
#define LCDC_HEOCFG31_XPHI7COEFF0_Pos 0
#define LCDC_HEOCFG31_XPHI7COEFF0_Msk (0xffu << LCDC_HEOCFG31_XPHI7COEFF0_Pos) /**< \brief (LCDC_HEOCFG31) Horizontal Coefficient for phase 7 tap 0 */
#define LCDC_HEOCFG31_XPHI7COEFF0(value) ((LCDC_HEOCFG31_XPHI7COEFF0_Msk & ((value) << LCDC_HEOCFG31_XPHI7COEFF0_Pos)))
#define LCDC_HEOCFG31_XPHI7COEFF1_Pos 8
#define LCDC_HEOCFG31_XPHI7COEFF1_Msk (0xffu << LCDC_HEOCFG31_XPHI7COEFF1_Pos) /**< \brief (LCDC_HEOCFG31) Horizontal Coefficient for phase 7 tap 1 */
#define LCDC_HEOCFG31_XPHI7COEFF1(value) ((LCDC_HEOCFG31_XPHI7COEFF1_Msk & ((value) << LCDC_HEOCFG31_XPHI7COEFF1_Pos)))
#define LCDC_HEOCFG31_XPHI7COEFF2_Pos 16
#define LCDC_HEOCFG31_XPHI7COEFF2_Msk (0xffu << LCDC_HEOCFG31_XPHI7COEFF2_Pos) /**< \brief (LCDC_HEOCFG31) Horizontal Coefficient for phase 7 tap 2 */
#define LCDC_HEOCFG31_XPHI7COEFF2(value) ((LCDC_HEOCFG31_XPHI7COEFF2_Msk & ((value) << LCDC_HEOCFG31_XPHI7COEFF2_Pos)))
#define LCDC_HEOCFG31_XPHI7COEFF3_Pos 24
#define LCDC_HEOCFG31_XPHI7COEFF3_Msk (0xffu << LCDC_HEOCFG31_XPHI7COEFF3_Pos) /**< \brief (LCDC_HEOCFG31) Horizontal Coefficient for phase 7 tap 3 */
#define LCDC_HEOCFG31_XPHI7COEFF3(value) ((LCDC_HEOCFG31_XPHI7COEFF3_Msk & ((value) << LCDC_HEOCFG31_XPHI7COEFF3_Pos)))
/* -------- LCDC_HEOCFG32 : (LCDC Offset: 0x0000040C) High-End Overlay Configuration Register 32 -------- */
#define LCDC_HEOCFG32_XPHI7COEFF4_Pos 0
#define LCDC_HEOCFG32_XPHI7COEFF4_Msk (0xffu << LCDC_HEOCFG32_XPHI7COEFF4_Pos) /**< \brief (LCDC_HEOCFG32) Horizontal Coefficient for phase 7 tap 4 */
#define LCDC_HEOCFG32_XPHI7COEFF4(value) ((LCDC_HEOCFG32_XPHI7COEFF4_Msk & ((value) << LCDC_HEOCFG32_XPHI7COEFF4_Pos)))
/* -------- LCDC_HEOCFG33 : (LCDC Offset: 0x00000410) High-End Overlay Configuration Register 33 -------- */
#define LCDC_HEOCFG33_YPHI0COEFF0_Pos 0
#define LCDC_HEOCFG33_YPHI0COEFF0_Msk (0xffu << LCDC_HEOCFG33_YPHI0COEFF0_Pos) /**< \brief (LCDC_HEOCFG33) Vertical Coefficient for phase 0 tap 0 */
#define LCDC_HEOCFG33_YPHI0COEFF0(value) ((LCDC_HEOCFG33_YPHI0COEFF0_Msk & ((value) << LCDC_HEOCFG33_YPHI0COEFF0_Pos)))
#define LCDC_HEOCFG33_YPHI0COEFF1_Pos 8
#define LCDC_HEOCFG33_YPHI0COEFF1_Msk (0xffu << LCDC_HEOCFG33_YPHI0COEFF1_Pos) /**< \brief (LCDC_HEOCFG33) Vertical Coefficient for phase 0 tap 1 */
#define LCDC_HEOCFG33_YPHI0COEFF1(value) ((LCDC_HEOCFG33_YPHI0COEFF1_Msk & ((value) << LCDC_HEOCFG33_YPHI0COEFF1_Pos)))
#define LCDC_HEOCFG33_YPHI0COEFF2_Pos 16
#define LCDC_HEOCFG33_YPHI0COEFF2_Msk (0xffu << LCDC_HEOCFG33_YPHI0COEFF2_Pos) /**< \brief (LCDC_HEOCFG33) Vertical Coefficient for phase 0 tap 2 */
#define LCDC_HEOCFG33_YPHI0COEFF2(value) ((LCDC_HEOCFG33_YPHI0COEFF2_Msk & ((value) << LCDC_HEOCFG33_YPHI0COEFF2_Pos)))
/* -------- LCDC_HEOCFG34 : (LCDC Offset: 0x00000414) High-End Overlay Configuration Register 34 -------- */
#define LCDC_HEOCFG34_YPHI1COEFF0_Pos 0
#define LCDC_HEOCFG34_YPHI1COEFF0_Msk (0xffu << LCDC_HEOCFG34_YPHI1COEFF0_Pos) /**< \brief (LCDC_HEOCFG34) Vertical Coefficient for phase 1 tap 0 */
#define LCDC_HEOCFG34_YPHI1COEFF0(value) ((LCDC_HEOCFG34_YPHI1COEFF0_Msk & ((value) << LCDC_HEOCFG34_YPHI1COEFF0_Pos)))
#define LCDC_HEOCFG34_YPHI1COEFF1_Pos 8
#define LCDC_HEOCFG34_YPHI1COEFF1_Msk (0xffu << LCDC_HEOCFG34_YPHI1COEFF1_Pos) /**< \brief (LCDC_HEOCFG34) Vertical Coefficient for phase 1 tap 1 */
#define LCDC_HEOCFG34_YPHI1COEFF1(value) ((LCDC_HEOCFG34_YPHI1COEFF1_Msk & ((value) << LCDC_HEOCFG34_YPHI1COEFF1_Pos)))
#define LCDC_HEOCFG34_YPHI1COEFF2_Pos 16
#define LCDC_HEOCFG34_YPHI1COEFF2_Msk (0xffu << LCDC_HEOCFG34_YPHI1COEFF2_Pos) /**< \brief (LCDC_HEOCFG34) Vertical Coefficient for phase 1 tap 2 */
#define LCDC_HEOCFG34_YPHI1COEFF2(value) ((LCDC_HEOCFG34_YPHI1COEFF2_Msk & ((value) << LCDC_HEOCFG34_YPHI1COEFF2_Pos)))
/* -------- LCDC_HEOCFG35 : (LCDC Offset: 0x00000418) High-End Overlay Configuration Register 35 -------- */
#define LCDC_HEOCFG35_YPHI2COEFF0_Pos 0
#define LCDC_HEOCFG35_YPHI2COEFF0_Msk (0xffu << LCDC_HEOCFG35_YPHI2COEFF0_Pos) /**< \brief (LCDC_HEOCFG35) Vertical Coefficient for phase 2 tap 0 */
#define LCDC_HEOCFG35_YPHI2COEFF0(value) ((LCDC_HEOCFG35_YPHI2COEFF0_Msk & ((value) << LCDC_HEOCFG35_YPHI2COEFF0_Pos)))
#define LCDC_HEOCFG35_YPHI2COEFF1_Pos 8
#define LCDC_HEOCFG35_YPHI2COEFF1_Msk (0xffu << LCDC_HEOCFG35_YPHI2COEFF1_Pos) /**< \brief (LCDC_HEOCFG35) Vertical Coefficient for phase 2 tap 1 */
#define LCDC_HEOCFG35_YPHI2COEFF1(value) ((LCDC_HEOCFG35_YPHI2COEFF1_Msk & ((value) << LCDC_HEOCFG35_YPHI2COEFF1_Pos)))
#define LCDC_HEOCFG35_YPHI2COEFF2_Pos 16
#define LCDC_HEOCFG35_YPHI2COEFF2_Msk (0xffu << LCDC_HEOCFG35_YPHI2COEFF2_Pos) /**< \brief (LCDC_HEOCFG35) Vertical Coefficient for phase 2 tap 2 */
#define LCDC_HEOCFG35_YPHI2COEFF2(value) ((LCDC_HEOCFG35_YPHI2COEFF2_Msk & ((value) << LCDC_HEOCFG35_YPHI2COEFF2_Pos)))
/* -------- LCDC_HEOCFG36 : (LCDC Offset: 0x0000041C) High-End Overlay Configuration Register 36 -------- */
#define LCDC_HEOCFG36_YPHI3COEFF0_Pos 0
#define LCDC_HEOCFG36_YPHI3COEFF0_Msk (0xffu << LCDC_HEOCFG36_YPHI3COEFF0_Pos) /**< \brief (LCDC_HEOCFG36) Vertical Coefficient for phase 3 tap 0 */
#define LCDC_HEOCFG36_YPHI3COEFF0(value) ((LCDC_HEOCFG36_YPHI3COEFF0_Msk & ((value) << LCDC_HEOCFG36_YPHI3COEFF0_Pos)))
#define LCDC_HEOCFG36_YPHI3COEFF1_Pos 8
#define LCDC_HEOCFG36_YPHI3COEFF1_Msk (0xffu << LCDC_HEOCFG36_YPHI3COEFF1_Pos) /**< \brief (LCDC_HEOCFG36) Vertical Coefficient for phase 3 tap 1 */
#define LCDC_HEOCFG36_YPHI3COEFF1(value) ((LCDC_HEOCFG36_YPHI3COEFF1_Msk & ((value) << LCDC_HEOCFG36_YPHI3COEFF1_Pos)))
#define LCDC_HEOCFG36_YPHI3COEFF2_Pos 16
#define LCDC_HEOCFG36_YPHI3COEFF2_Msk (0xffu << LCDC_HEOCFG36_YPHI3COEFF2_Pos) /**< \brief (LCDC_HEOCFG36) Vertical Coefficient for phase 3 tap 2 */
#define LCDC_HEOCFG36_YPHI3COEFF2(value) ((LCDC_HEOCFG36_YPHI3COEFF2_Msk & ((value) << LCDC_HEOCFG36_YPHI3COEFF2_Pos)))
/* -------- LCDC_HEOCFG37 : (LCDC Offset: 0x00000420) High-End Overlay Configuration Register 37 -------- */
#define LCDC_HEOCFG37_YPHI4COEFF0_Pos 0
#define LCDC_HEOCFG37_YPHI4COEFF0_Msk (0xffu << LCDC_HEOCFG37_YPHI4COEFF0_Pos) /**< \brief (LCDC_HEOCFG37) Vertical Coefficient for phase 4 tap 0 */
#define LCDC_HEOCFG37_YPHI4COEFF0(value) ((LCDC_HEOCFG37_YPHI4COEFF0_Msk & ((value) << LCDC_HEOCFG37_YPHI4COEFF0_Pos)))
#define LCDC_HEOCFG37_YPHI4COEFF1_Pos 8
#define LCDC_HEOCFG37_YPHI4COEFF1_Msk (0xffu << LCDC_HEOCFG37_YPHI4COEFF1_Pos) /**< \brief (LCDC_HEOCFG37) Vertical Coefficient for phase 4 tap 1 */
#define LCDC_HEOCFG37_YPHI4COEFF1(value) ((LCDC_HEOCFG37_YPHI4COEFF1_Msk & ((value) << LCDC_HEOCFG37_YPHI4COEFF1_Pos)))
#define LCDC_HEOCFG37_YPHI4COEFF2_Pos 16
#define LCDC_HEOCFG37_YPHI4COEFF2_Msk (0xffu << LCDC_HEOCFG37_YPHI4COEFF2_Pos) /**< \brief (LCDC_HEOCFG37) Vertical Coefficient for phase 4 tap 2 */
#define LCDC_HEOCFG37_YPHI4COEFF2(value) ((LCDC_HEOCFG37_YPHI4COEFF2_Msk & ((value) << LCDC_HEOCFG37_YPHI4COEFF2_Pos)))
/* -------- LCDC_HEOCFG38 : (LCDC Offset: 0x00000424) High-End Overlay Configuration Register 38 -------- */
#define LCDC_HEOCFG38_YPHI5COEFF0_Pos 0
#define LCDC_HEOCFG38_YPHI5COEFF0_Msk (0xffu << LCDC_HEOCFG38_YPHI5COEFF0_Pos) /**< \brief (LCDC_HEOCFG38) Vertical Coefficient for phase 5 tap 0 */
#define LCDC_HEOCFG38_YPHI5COEFF0(value) ((LCDC_HEOCFG38_YPHI5COEFF0_Msk & ((value) << LCDC_HEOCFG38_YPHI5COEFF0_Pos)))
#define LCDC_HEOCFG38_YPHI5COEFF1_Pos 8
#define LCDC_HEOCFG38_YPHI5COEFF1_Msk (0xffu << LCDC_HEOCFG38_YPHI5COEFF1_Pos) /**< \brief (LCDC_HEOCFG38) Vertical Coefficient for phase 5 tap 1 */
#define LCDC_HEOCFG38_YPHI5COEFF1(value) ((LCDC_HEOCFG38_YPHI5COEFF1_Msk & ((value) << LCDC_HEOCFG38_YPHI5COEFF1_Pos)))
#define LCDC_HEOCFG38_YPHI5COEFF2_Pos 16
#define LCDC_HEOCFG38_YPHI5COEFF2_Msk (0xffu << LCDC_HEOCFG38_YPHI5COEFF2_Pos) /**< \brief (LCDC_HEOCFG38) Vertical Coefficient for phase 5 tap 2 */
#define LCDC_HEOCFG38_YPHI5COEFF2(value) ((LCDC_HEOCFG38_YPHI5COEFF2_Msk & ((value) << LCDC_HEOCFG38_YPHI5COEFF2_Pos)))
/* -------- LCDC_HEOCFG39 : (LCDC Offset: 0x00000428) High-End Overlay Configuration Register 39 -------- */
#define LCDC_HEOCFG39_YPHI6COEFF0_Pos 0
#define LCDC_HEOCFG39_YPHI6COEFF0_Msk (0xffu << LCDC_HEOCFG39_YPHI6COEFF0_Pos) /**< \brief (LCDC_HEOCFG39) Vertical Coefficient for phase 6 tap 0 */
#define LCDC_HEOCFG39_YPHI6COEFF0(value) ((LCDC_HEOCFG39_YPHI6COEFF0_Msk & ((value) << LCDC_HEOCFG39_YPHI6COEFF0_Pos)))
#define LCDC_HEOCFG39_YPHI6COEFF1_Pos 8
#define LCDC_HEOCFG39_YPHI6COEFF1_Msk (0xffu << LCDC_HEOCFG39_YPHI6COEFF1_Pos) /**< \brief (LCDC_HEOCFG39) Vertical Coefficient for phase 6 tap 1 */
#define LCDC_HEOCFG39_YPHI6COEFF1(value) ((LCDC_HEOCFG39_YPHI6COEFF1_Msk & ((value) << LCDC_HEOCFG39_YPHI6COEFF1_Pos)))
#define LCDC_HEOCFG39_YPHI6COEFF2_Pos 16
#define LCDC_HEOCFG39_YPHI6COEFF2_Msk (0xffu << LCDC_HEOCFG39_YPHI6COEFF2_Pos) /**< \brief (LCDC_HEOCFG39) Vertical Coefficient for phase 6 tap 2 */
#define LCDC_HEOCFG39_YPHI6COEFF2(value) ((LCDC_HEOCFG39_YPHI6COEFF2_Msk & ((value) << LCDC_HEOCFG39_YPHI6COEFF2_Pos)))
/* -------- LCDC_HEOCFG40 : (LCDC Offset: 0x0000042C) High-End Overlay Configuration Register 40 -------- */
#define LCDC_HEOCFG40_YPHI7COEFF0_Pos 0
#define LCDC_HEOCFG40_YPHI7COEFF0_Msk (0xffu << LCDC_HEOCFG40_YPHI7COEFF0_Pos) /**< \brief (LCDC_HEOCFG40) Vertical Coefficient for phase 7 tap 0 */
#define LCDC_HEOCFG40_YPHI7COEFF0(value) ((LCDC_HEOCFG40_YPHI7COEFF0_Msk & ((value) << LCDC_HEOCFG40_YPHI7COEFF0_Pos)))
#define LCDC_HEOCFG40_YPHI7COEFF1_Pos 8
#define LCDC_HEOCFG40_YPHI7COEFF1_Msk (0xffu << LCDC_HEOCFG40_YPHI7COEFF1_Pos) /**< \brief (LCDC_HEOCFG40) Vertical Coefficient for phase 7 tap 1 */
#define LCDC_HEOCFG40_YPHI7COEFF1(value) ((LCDC_HEOCFG40_YPHI7COEFF1_Msk & ((value) << LCDC_HEOCFG40_YPHI7COEFF1_Pos)))
#define LCDC_HEOCFG40_YPHI7COEFF2_Pos 16
#define LCDC_HEOCFG40_YPHI7COEFF2_Msk (0xffu << LCDC_HEOCFG40_YPHI7COEFF2_Pos) /**< \brief (LCDC_HEOCFG40) Vertical Coefficient for phase 7 tap 2 */
#define LCDC_HEOCFG40_YPHI7COEFF2(value) ((LCDC_HEOCFG40_YPHI7COEFF2_Msk & ((value) << LCDC_HEOCFG40_YPHI7COEFF2_Pos)))
/* -------- LCDC_HEOCFG41 : (LCDC Offset: 0x00000430) High-End Overlay Configuration Register 41 -------- */
#define LCDC_HEOCFG41_XPHIDEF_Pos 0
#define LCDC_HEOCFG41_XPHIDEF_Msk (0x7u << LCDC_HEOCFG41_XPHIDEF_Pos) /**< \brief (LCDC_HEOCFG41) Horizontal Filter Phase Offset */
#define LCDC_HEOCFG41_XPHIDEF(value) ((LCDC_HEOCFG41_XPHIDEF_Msk & ((value) << LCDC_HEOCFG41_XPHIDEF_Pos)))
#define LCDC_HEOCFG41_YPHIDEF_Pos 16
#define LCDC_HEOCFG41_YPHIDEF_Msk (0x7u << LCDC_HEOCFG41_YPHIDEF_Pos) /**< \brief (LCDC_HEOCFG41) Vertical Filter Phase Offset */
#define LCDC_HEOCFG41_YPHIDEF(value) ((LCDC_HEOCFG41_YPHIDEF_Msk & ((value) << LCDC_HEOCFG41_YPHIDEF_Pos)))
/* -------- LCDC_BASECLUT[256] : (LCDC Offset: 0x600) Base CLUT Register -------- */
#define LCDC_BASECLUT_BCLUT_Pos 0
#define LCDC_BASECLUT_BCLUT_Msk (0xffu << LCDC_BASECLUT_BCLUT_Pos) /**< \brief (LCDC_BASECLUT[256]) Blue Color entry */
#define LCDC_BASECLUT_BCLUT(value) ((LCDC_BASECLUT_BCLUT_Msk & ((value) << LCDC_BASECLUT_BCLUT_Pos)))
#define LCDC_BASECLUT_GCLUT_Pos 8
#define LCDC_BASECLUT_GCLUT_Msk (0xffu << LCDC_BASECLUT_GCLUT_Pos) /**< \brief (LCDC_BASECLUT[256]) Green Color entry */
#define LCDC_BASECLUT_GCLUT(value) ((LCDC_BASECLUT_GCLUT_Msk & ((value) << LCDC_BASECLUT_GCLUT_Pos)))
#define LCDC_BASECLUT_RCLUT_Pos 16
#define LCDC_BASECLUT_RCLUT_Msk (0xffu << LCDC_BASECLUT_RCLUT_Pos) /**< \brief (LCDC_BASECLUT[256]) Red Color entry */
#define LCDC_BASECLUT_RCLUT(value) ((LCDC_BASECLUT_RCLUT_Msk & ((value) << LCDC_BASECLUT_RCLUT_Pos)))
/* -------- LCDC_OVR1CLUT[256] : (LCDC Offset: 0xA00) Overlay 1 CLUT Register -------- */
#define LCDC_OVR1CLUT_BCLUT_Pos 0
#define LCDC_OVR1CLUT_BCLUT_Msk (0xffu << LCDC_OVR1CLUT_BCLUT_Pos) /**< \brief (LCDC_OVR1CLUT[256]) Blue Color entry */
#define LCDC_OVR1CLUT_BCLUT(value) ((LCDC_OVR1CLUT_BCLUT_Msk & ((value) << LCDC_OVR1CLUT_BCLUT_Pos)))
#define LCDC_OVR1CLUT_GCLUT_Pos 8
#define LCDC_OVR1CLUT_GCLUT_Msk (0xffu << LCDC_OVR1CLUT_GCLUT_Pos) /**< \brief (LCDC_OVR1CLUT[256]) Green Color entry */
#define LCDC_OVR1CLUT_GCLUT(value) ((LCDC_OVR1CLUT_GCLUT_Msk & ((value) << LCDC_OVR1CLUT_GCLUT_Pos)))
#define LCDC_OVR1CLUT_RCLUT_Pos 16
#define LCDC_OVR1CLUT_RCLUT_Msk (0xffu << LCDC_OVR1CLUT_RCLUT_Pos) /**< \brief (LCDC_OVR1CLUT[256]) Red Color entry */
#define LCDC_OVR1CLUT_RCLUT(value) ((LCDC_OVR1CLUT_RCLUT_Msk & ((value) << LCDC_OVR1CLUT_RCLUT_Pos)))
#define LCDC_OVR1CLUT_ACLUT_Pos 24
#define LCDC_OVR1CLUT_ACLUT_Msk (0xffu << LCDC_OVR1CLUT_ACLUT_Pos) /**< \brief (LCDC_OVR1CLUT[256]) Alpha Color entry */
#define LCDC_OVR1CLUT_ACLUT(value) ((LCDC_OVR1CLUT_ACLUT_Msk & ((value) << LCDC_OVR1CLUT_ACLUT_Pos)))
/* -------- LCDC_OVR2CLUT[256] : (LCDC Offset: 0xE00) Overlay 2 CLUT Register -------- */
#define LCDC_OVR2CLUT_BCLUT_Pos 0
#define LCDC_OVR2CLUT_BCLUT_Msk (0xffu << LCDC_OVR2CLUT_BCLUT_Pos) /**< \brief (LCDC_OVR2CLUT[256]) Blue Color entry */
#define LCDC_OVR2CLUT_BCLUT(value) ((LCDC_OVR2CLUT_BCLUT_Msk & ((value) << LCDC_OVR2CLUT_BCLUT_Pos)))
#define LCDC_OVR2CLUT_GCLUT_Pos 8
#define LCDC_OVR2CLUT_GCLUT_Msk (0xffu << LCDC_OVR2CLUT_GCLUT_Pos) /**< \brief (LCDC_OVR2CLUT[256]) Green Color entry */
#define LCDC_OVR2CLUT_GCLUT(value) ((LCDC_OVR2CLUT_GCLUT_Msk & ((value) << LCDC_OVR2CLUT_GCLUT_Pos)))
#define LCDC_OVR2CLUT_RCLUT_Pos 16
#define LCDC_OVR2CLUT_RCLUT_Msk (0xffu << LCDC_OVR2CLUT_RCLUT_Pos) /**< \brief (LCDC_OVR2CLUT[256]) Red Color entry */
#define LCDC_OVR2CLUT_RCLUT(value) ((LCDC_OVR2CLUT_RCLUT_Msk & ((value) << LCDC_OVR2CLUT_RCLUT_Pos)))
#define LCDC_OVR2CLUT_ACLUT_Pos 24
#define LCDC_OVR2CLUT_ACLUT_Msk (0xffu << LCDC_OVR2CLUT_ACLUT_Pos) /**< \brief (LCDC_OVR2CLUT[256]) Alpha Color entry */
#define LCDC_OVR2CLUT_ACLUT(value) ((LCDC_OVR2CLUT_ACLUT_Msk & ((value) << LCDC_OVR2CLUT_ACLUT_Pos)))
/* -------- LCDC_HEOCLUT[256] : (LCDC Offset: 0x1200) High End Overlay CLUT Register -------- */
#define LCDC_HEOCLUT_BCLUT_Pos 0
#define LCDC_HEOCLUT_BCLUT_Msk (0xffu << LCDC_HEOCLUT_BCLUT_Pos) /**< \brief (LCDC_HEOCLUT[256]) Blue Color entry */
#define LCDC_HEOCLUT_BCLUT(value) ((LCDC_HEOCLUT_BCLUT_Msk & ((value) << LCDC_HEOCLUT_BCLUT_Pos)))
#define LCDC_HEOCLUT_GCLUT_Pos 8
#define LCDC_HEOCLUT_GCLUT_Msk (0xffu << LCDC_HEOCLUT_GCLUT_Pos) /**< \brief (LCDC_HEOCLUT[256]) Green Color entry */
#define LCDC_HEOCLUT_GCLUT(value) ((LCDC_HEOCLUT_GCLUT_Msk & ((value) << LCDC_HEOCLUT_GCLUT_Pos)))
#define LCDC_HEOCLUT_RCLUT_Pos 16
#define LCDC_HEOCLUT_RCLUT_Msk (0xffu << LCDC_HEOCLUT_RCLUT_Pos) /**< \brief (LCDC_HEOCLUT[256]) Red Color entry */
#define LCDC_HEOCLUT_RCLUT(value) ((LCDC_HEOCLUT_RCLUT_Msk & ((value) << LCDC_HEOCLUT_RCLUT_Pos)))
#define LCDC_HEOCLUT_ACLUT_Pos 24
#define LCDC_HEOCLUT_ACLUT_Msk (0xffu << LCDC_HEOCLUT_ACLUT_Pos) /**< \brief (LCDC_HEOCLUT[256]) Alpha Color entry */
#define LCDC_HEOCLUT_ACLUT(value) ((LCDC_HEOCLUT_ACLUT_Msk & ((value) << LCDC_HEOCLUT_ACLUT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR AHB Bus Matrix */
/* ============================================================================= */
/** \addtogroup SAMA5D4_MATRIX AHB Bus Matrix */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief MatrixPr hardware registers */
typedef struct {
  __IO uint32_t MATRIX_PRAS; /**< \brief (MatrixPr Offset: 0x0) Priority Register A for Slave 0 */
  __IO uint32_t MATRIX_PRBS; /**< \brief (MatrixPr Offset: 0x4) Priority Register B for Slave 0 */
} MatrixPr;
/** \brief Matrix hardware registers */
#define MATRIXPR_NUMBER 13
typedef struct {
  __IO uint32_t MATRIX_MCFG[10];            /**< \brief (Matrix Offset: 0x0000) Master Configuration Register */
  __I  uint32_t Reserved1[6];
  __IO uint32_t MATRIX_SCFG[13];            /**< \brief (Matrix Offset: 0x0040) Slave Configuration Register */
  __I  uint32_t Reserved2[3];
       MatrixPr MATRIX_PR[MATRIXPR_NUMBER]; /**< \brief (Matrix Offset: 0x0080) 0 .. 12 */
  __I  uint32_t Reserved3[26];
  __O  uint32_t MATRIX_MEIER;               /**< \brief (Matrix Offset: 0x0150) Master Error Interrupt Enable Register */
  __O  uint32_t MATRIX_MEIDR;               /**< \brief (Matrix Offset: 0x0154) Master Error Interrupt Disable Register */
  __I  uint32_t MATRIX_MEIMR;               /**< \brief (Matrix Offset: 0x0158) Master Error Interrupt Mask Register */
  __I  uint32_t MATRIX_MESR;                /**< \brief (Matrix Offset: 0x015C) Master Error Status Register */
  __I  uint32_t MATRIX_MEAR[10];            /**< \brief (Matrix Offset: 0x0160) Master 0 Error Address Register */
  __I  uint32_t Reserved4[23];
  __IO uint32_t MATRIX_WPMR;                /**< \brief (Matrix Offset: 0x01E4) Write Protect Mode Register */
  __I  uint32_t MATRIX_WPSR;                /**< \brief (Matrix Offset: 0x01E8) Write Protect Status Register */
  __I  uint32_t Reserved5[5];
  __IO uint32_t MATRIX_SSR[13];             /**< \brief (Matrix Offset: 0x0200) Security Slave 0 Register */
  __I  uint32_t Reserved6[3];
  __IO uint32_t MATRIX_SASSR[13];           /**< \brief (Matrix Offset: 0x0240) Security Areas Split Slave 0 Register */
  __I  uint32_t Reserved7[3];
  __IO uint32_t MATRIX_SRTSR[13];           /**< \brief (Matrix Offset: 0x0280) Security Region Top Slave 0 Register */
  __I  uint32_t Reserved8[3];
  __IO uint32_t MATRIX_SPSELR[3];           /**< \brief (Matrix Offset: 0x02C0) Security Peripheral Select 1 Register */
} Matrix;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- MATRIX_MCFG[10] : (MATRIX Offset: 0x0000) Master Configuration Register -------- */
#define MATRIX_MCFG_ULBT_Pos 0
#define MATRIX_MCFG_ULBT_Msk (0x7u << MATRIX_MCFG_ULBT_Pos) /**< \brief (MATRIX_MCFG[10]) Undefined Length Burst Type */
#define MATRIX_MCFG_ULBT(value) ((MATRIX_MCFG_ULBT_Msk & ((value) << MATRIX_MCFG_ULBT_Pos)))
/* -------- MATRIX_SCFG[13] : (MATRIX Offset: 0x0040) Slave Configuration Register -------- */
#define MATRIX_SCFG_SLOT_CYCLE_Pos 0
#define MATRIX_SCFG_SLOT_CYCLE_Msk (0x1ffu << MATRIX_SCFG_SLOT_CYCLE_Pos) /**< \brief (MATRIX_SCFG[13]) Maximum Bus Grant Duration for Masters */
#define MATRIX_SCFG_SLOT_CYCLE(value) ((MATRIX_SCFG_SLOT_CYCLE_Msk & ((value) << MATRIX_SCFG_SLOT_CYCLE_Pos)))
#define MATRIX_SCFG_DEFMSTR_TYPE_Pos 16
#define MATRIX_SCFG_DEFMSTR_TYPE_Msk (0x3u << MATRIX_SCFG_DEFMSTR_TYPE_Pos) /**< \brief (MATRIX_SCFG[13]) Default Master Type */
#define MATRIX_SCFG_DEFMSTR_TYPE(value) ((MATRIX_SCFG_DEFMSTR_TYPE_Msk & ((value) << MATRIX_SCFG_DEFMSTR_TYPE_Pos)))
#define MATRIX_SCFG_FIXED_DEFMSTR_Pos 18
#define MATRIX_SCFG_FIXED_DEFMSTR_Msk (0xfu << MATRIX_SCFG_FIXED_DEFMSTR_Pos) /**< \brief (MATRIX_SCFG[13]) Fixed Default Master */
#define MATRIX_SCFG_FIXED_DEFMSTR(value) ((MATRIX_SCFG_FIXED_DEFMSTR_Msk & ((value) << MATRIX_SCFG_FIXED_DEFMSTR_Pos)))
/* -------- MATRIX_PRAS : (MATRIX Offset: N/A) Priority Register A for Slave 0 -------- */
#define MATRIX_PRAS_M0PR_Pos 0
#define MATRIX_PRAS_M0PR_Msk (0x3u << MATRIX_PRAS_M0PR_Pos) /**< \brief (MATRIX_PRAS) Master 0 Priority */
#define MATRIX_PRAS_M0PR(value) ((MATRIX_PRAS_M0PR_Msk & ((value) << MATRIX_PRAS_M0PR_Pos)))
#define MATRIX_PRAS_LQOSEN0 (0x1u << 2) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 0 */
#define MATRIX_PRAS_M1PR_Pos 4
#define MATRIX_PRAS_M1PR_Msk (0x3u << MATRIX_PRAS_M1PR_Pos) /**< \brief (MATRIX_PRAS) Master 1 Priority */
#define MATRIX_PRAS_M1PR(value) ((MATRIX_PRAS_M1PR_Msk & ((value) << MATRIX_PRAS_M1PR_Pos)))
#define MATRIX_PRAS_LQOSEN1 (0x1u << 6) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 1 */
#define MATRIX_PRAS_M2PR_Pos 8
#define MATRIX_PRAS_M2PR_Msk (0x3u << MATRIX_PRAS_M2PR_Pos) /**< \brief (MATRIX_PRAS) Master 2 Priority */
#define MATRIX_PRAS_M2PR(value) ((MATRIX_PRAS_M2PR_Msk & ((value) << MATRIX_PRAS_M2PR_Pos)))
#define MATRIX_PRAS_LQOSEN2 (0x1u << 10) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 2 */
#define MATRIX_PRAS_M3PR_Pos 12
#define MATRIX_PRAS_M3PR_Msk (0x3u << MATRIX_PRAS_M3PR_Pos) /**< \brief (MATRIX_PRAS) Master 3 Priority */
#define MATRIX_PRAS_M3PR(value) ((MATRIX_PRAS_M3PR_Msk & ((value) << MATRIX_PRAS_M3PR_Pos)))
#define MATRIX_PRAS_LQOSEN3 (0x1u << 14) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 3 */
#define MATRIX_PRAS_M4PR_Pos 16
#define MATRIX_PRAS_M4PR_Msk (0x3u << MATRIX_PRAS_M4PR_Pos) /**< \brief (MATRIX_PRAS) Master 4 Priority */
#define MATRIX_PRAS_M4PR(value) ((MATRIX_PRAS_M4PR_Msk & ((value) << MATRIX_PRAS_M4PR_Pos)))
#define MATRIX_PRAS_LQOSEN4 (0x1u << 18) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 4 */
#define MATRIX_PRAS_M5PR_Pos 20
#define MATRIX_PRAS_M5PR_Msk (0x3u << MATRIX_PRAS_M5PR_Pos) /**< \brief (MATRIX_PRAS) Master 5 Priority */
#define MATRIX_PRAS_M5PR(value) ((MATRIX_PRAS_M5PR_Msk & ((value) << MATRIX_PRAS_M5PR_Pos)))
#define MATRIX_PRAS_LQOSEN5 (0x1u << 22) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 5 */
#define MATRIX_PRAS_M6PR_Pos 24
#define MATRIX_PRAS_M6PR_Msk (0x3u << MATRIX_PRAS_M6PR_Pos) /**< \brief (MATRIX_PRAS) Master 6 Priority */
#define MATRIX_PRAS_M6PR(value) ((MATRIX_PRAS_M6PR_Msk & ((value) << MATRIX_PRAS_M6PR_Pos)))
#define MATRIX_PRAS_LQOSEN6 (0x1u << 26) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 6 */
#define MATRIX_PRAS_M7PR_Pos 28
#define MATRIX_PRAS_M7PR_Msk (0x3u << MATRIX_PRAS_M7PR_Pos) /**< \brief (MATRIX_PRAS) Master 7 Priority */
#define MATRIX_PRAS_M7PR(value) ((MATRIX_PRAS_M7PR_Msk & ((value) << MATRIX_PRAS_M7PR_Pos)))
#define MATRIX_PRAS_LQOSEN7 (0x1u << 30) /**< \brief (MATRIX_PRAS) Latency Quality of Service Enable for Master 7 */
/* -------- MATRIX_PRBS : (MATRIX Offset: N/A) Priority Register B for Slave 0 -------- */
#define MATRIX_PRBS_M8PR_Pos 0
#define MATRIX_PRBS_M8PR_Msk (0x3u << MATRIX_PRBS_M8PR_Pos) /**< \brief (MATRIX_PRBS) Master 8 Priority */
#define MATRIX_PRBS_M8PR(value) ((MATRIX_PRBS_M8PR_Msk & ((value) << MATRIX_PRBS_M8PR_Pos)))
#define MATRIX_PRBS_LQOSEN8 (0x1u << 2) /**< \brief (MATRIX_PRBS) Latency Quality of Service Enable for Master 8 */
#define MATRIX_PRBS_M9PR_Pos 4
#define MATRIX_PRBS_M9PR_Msk (0x3u << MATRIX_PRBS_M9PR_Pos) /**< \brief (MATRIX_PRBS) Master 9 Priority */
#define MATRIX_PRBS_M9PR(value) ((MATRIX_PRBS_M9PR_Msk & ((value) << MATRIX_PRBS_M9PR_Pos)))
#define MATRIX_PRBS_LQOSEN9 (0x1u << 6) /**< \brief (MATRIX_PRBS) Latency Quality of Service Enable for Master 9 */
/* -------- MATRIX_MEIER : (MATRIX Offset: 0x0150) Master Error Interrupt Enable Register -------- */
#define MATRIX_MEIER_MERR0 (0x1u << 0) /**< \brief (MATRIX_MEIER) Master 0 Access Error */
#define MATRIX_MEIER_MERR1 (0x1u << 1) /**< \brief (MATRIX_MEIER) Master 1 Access Error */
#define MATRIX_MEIER_MERR2 (0x1u << 2) /**< \brief (MATRIX_MEIER) Master 2 Access Error */
#define MATRIX_MEIER_MERR3 (0x1u << 3) /**< \brief (MATRIX_MEIER) Master 3 Access Error */
#define MATRIX_MEIER_MERR4 (0x1u << 4) /**< \brief (MATRIX_MEIER) Master 4 Access Error */
#define MATRIX_MEIER_MERR5 (0x1u << 5) /**< \brief (MATRIX_MEIER) Master 5 Access Error */
#define MATRIX_MEIER_MERR6 (0x1u << 6) /**< \brief (MATRIX_MEIER) Master 6 Access Error */
#define MATRIX_MEIER_MERR7 (0x1u << 7) /**< \brief (MATRIX_MEIER) Master 7 Access Error */
#define MATRIX_MEIER_MERR8 (0x1u << 8) /**< \brief (MATRIX_MEIER) Master 8 Access Error */
#define MATRIX_MEIER_MERR9 (0x1u << 9) /**< \brief (MATRIX_MEIER) Master 9 Access Error */
/* -------- MATRIX_MEIDR : (MATRIX Offset: 0x0154) Master Error Interrupt Disable Register -------- */
#define MATRIX_MEIDR_MERR0 (0x1u << 0) /**< \brief (MATRIX_MEIDR) Master 0 Access Error */
#define MATRIX_MEIDR_MERR1 (0x1u << 1) /**< \brief (MATRIX_MEIDR) Master 1 Access Error */
#define MATRIX_MEIDR_MERR2 (0x1u << 2) /**< \brief (MATRIX_MEIDR) Master 2 Access Error */
#define MATRIX_MEIDR_MERR3 (0x1u << 3) /**< \brief (MATRIX_MEIDR) Master 3 Access Error */
#define MATRIX_MEIDR_MERR4 (0x1u << 4) /**< \brief (MATRIX_MEIDR) Master 4 Access Error */
#define MATRIX_MEIDR_MERR5 (0x1u << 5) /**< \brief (MATRIX_MEIDR) Master 5 Access Error */
#define MATRIX_MEIDR_MERR6 (0x1u << 6) /**< \brief (MATRIX_MEIDR) Master 6 Access Error */
#define MATRIX_MEIDR_MERR7 (0x1u << 7) /**< \brief (MATRIX_MEIDR) Master 7 Access Error */
#define MATRIX_MEIDR_MERR8 (0x1u << 8) /**< \brief (MATRIX_MEIDR) Master 8 Access Error */
#define MATRIX_MEIDR_MERR9 (0x1u << 9) /**< \brief (MATRIX_MEIDR) Master 9 Access Error */
/* -------- MATRIX_MEIMR : (MATRIX Offset: 0x0158) Master Error Interrupt Mask Register -------- */
#define MATRIX_MEIMR_MERR0 (0x1u << 0) /**< \brief (MATRIX_MEIMR) Master 0 Access Error */
#define MATRIX_MEIMR_MERR1 (0x1u << 1) /**< \brief (MATRIX_MEIMR) Master 1 Access Error */
#define MATRIX_MEIMR_MERR2 (0x1u << 2) /**< \brief (MATRIX_MEIMR) Master 2 Access Error */
#define MATRIX_MEIMR_MERR3 (0x1u << 3) /**< \brief (MATRIX_MEIMR) Master 3 Access Error */
#define MATRIX_MEIMR_MERR4 (0x1u << 4) /**< \brief (MATRIX_MEIMR) Master 4 Access Error */
#define MATRIX_MEIMR_MERR5 (0x1u << 5) /**< \brief (MATRIX_MEIMR) Master 5 Access Error */
#define MATRIX_MEIMR_MERR6 (0x1u << 6) /**< \brief (MATRIX_MEIMR) Master 6 Access Error */
#define MATRIX_MEIMR_MERR7 (0x1u << 7) /**< \brief (MATRIX_MEIMR) Master 7 Access Error */
#define MATRIX_MEIMR_MERR8 (0x1u << 8) /**< \brief (MATRIX_MEIMR) Master 8 Access Error */
#define MATRIX_MEIMR_MERR9 (0x1u << 9) /**< \brief (MATRIX_MEIMR) Master 9 Access Error */
/* -------- MATRIX_MESR : (MATRIX Offset: 0x015C) Master Error Status Register -------- */
#define MATRIX_MESR_MERR0 (0x1u << 0) /**< \brief (MATRIX_MESR) Master 0 Access Error */
#define MATRIX_MESR_MERR1 (0x1u << 1) /**< \brief (MATRIX_MESR) Master 1 Access Error */
#define MATRIX_MESR_MERR2 (0x1u << 2) /**< \brief (MATRIX_MESR) Master 2 Access Error */
#define MATRIX_MESR_MERR3 (0x1u << 3) /**< \brief (MATRIX_MESR) Master 3 Access Error */
#define MATRIX_MESR_MERR4 (0x1u << 4) /**< \brief (MATRIX_MESR) Master 4 Access Error */
#define MATRIX_MESR_MERR5 (0x1u << 5) /**< \brief (MATRIX_MESR) Master 5 Access Error */
#define MATRIX_MESR_MERR6 (0x1u << 6) /**< \brief (MATRIX_MESR) Master 6 Access Error */
#define MATRIX_MESR_MERR7 (0x1u << 7) /**< \brief (MATRIX_MESR) Master 7 Access Error */
#define MATRIX_MESR_MERR8 (0x1u << 8) /**< \brief (MATRIX_MESR) Master 8 Access Error */
#define MATRIX_MESR_MERR9 (0x1u << 9) /**< \brief (MATRIX_MESR) Master 9 Access Error */
/* -------- MATRIX_MEAR[10] : (MATRIX Offset: 0x0160) Master 0 Error Address Register -------- */
#define MATRIX_MEAR_ERRADD_Pos 0
#define MATRIX_MEAR_ERRADD_Msk (0xffffffffu << MATRIX_MEAR_ERRADD_Pos) /**< \brief (MATRIX_MEAR[10]) Master Error Address */
/* -------- MATRIX_WPMR : (MATRIX Offset: 0x01E4) Write Protect Mode Register -------- */
#define MATRIX_WPMR_WPEN (0x1u << 0) /**< \brief (MATRIX_WPMR) Write Protect Enable */
#define MATRIX_WPMR_WPKEY_Pos 8
#define MATRIX_WPMR_WPKEY_Msk (0xffffffu << MATRIX_WPMR_WPKEY_Pos) /**< \brief (MATRIX_WPMR) Write Protect KEY (Write-only) */
#define MATRIX_WPMR_WPKEY(value) ((MATRIX_WPMR_WPKEY_Msk & ((value) << MATRIX_WPMR_WPKEY_Pos)))
/* -------- MATRIX_WPSR : (MATRIX Offset: 0x01E8) Write Protect Status Register -------- */
#define MATRIX_WPSR_WPVS (0x1u << 0) /**< \brief (MATRIX_WPSR) Write Protect Violation Status */
#define MATRIX_WPSR_WPVSRC_Pos 8
#define MATRIX_WPSR_WPVSRC_Msk (0xffffu << MATRIX_WPSR_WPVSRC_Pos) /**< \brief (MATRIX_WPSR) Write Protect Violation Source */
/* -------- MATRIX_SSR[13] : (MATRIX Offset: 0x0200) Security Slave 0 Register -------- */
#define MATRIX_SSR_LANSECH0 (0x1u << 0) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_LANSECH1 (0x1u << 1) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_LANSECH2 (0x1u << 2) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_LANSECH3 (0x1u << 3) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_LANSECH4 (0x1u << 4) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_LANSECH5 (0x1u << 5) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_LANSECH6 (0x1u << 6) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_LANSECH7 (0x1u << 7) /**< \brief (MATRIX_SSR[13]) Low Area Not Secured in HSELx Security Region */
#define MATRIX_SSR_RDNSECH0 (0x1u << 8) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_RDNSECH1 (0x1u << 9) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_RDNSECH2 (0x1u << 10) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_RDNSECH3 (0x1u << 11) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_RDNSECH4 (0x1u << 12) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_RDNSECH5 (0x1u << 13) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_RDNSECH6 (0x1u << 14) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_RDNSECH7 (0x1u << 15) /**< \brief (MATRIX_SSR[13]) Read Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH0 (0x1u << 16) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH1 (0x1u << 17) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH2 (0x1u << 18) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH3 (0x1u << 19) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH4 (0x1u << 20) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH5 (0x1u << 21) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH6 (0x1u << 22) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
#define MATRIX_SSR_WRNSECH7 (0x1u << 23) /**< \brief (MATRIX_SSR[13]) Write Not Secured for HSELx Security Region */
/* -------- MATRIX_SASSR[13] : (MATRIX Offset: 0x0240) Security Areas Split Slave 0 Register -------- */
#define MATRIX_SASSR_SASPLIT0_Pos 0
#define MATRIX_SASSR_SASPLIT0_Msk (0xfu << MATRIX_SASSR_SASPLIT0_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT0(value) ((MATRIX_SASSR_SASPLIT0_Msk & ((value) << MATRIX_SASSR_SASPLIT0_Pos)))
#define MATRIX_SASSR_SASPLIT1_Pos 4
#define MATRIX_SASSR_SASPLIT1_Msk (0xfu << MATRIX_SASSR_SASPLIT1_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT1(value) ((MATRIX_SASSR_SASPLIT1_Msk & ((value) << MATRIX_SASSR_SASPLIT1_Pos)))
#define MATRIX_SASSR_SASPLIT2_Pos 8
#define MATRIX_SASSR_SASPLIT2_Msk (0xfu << MATRIX_SASSR_SASPLIT2_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT2(value) ((MATRIX_SASSR_SASPLIT2_Msk & ((value) << MATRIX_SASSR_SASPLIT2_Pos)))
#define MATRIX_SASSR_SASPLIT3_Pos 12
#define MATRIX_SASSR_SASPLIT3_Msk (0xfu << MATRIX_SASSR_SASPLIT3_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT3(value) ((MATRIX_SASSR_SASPLIT3_Msk & ((value) << MATRIX_SASSR_SASPLIT3_Pos)))
#define MATRIX_SASSR_SASPLIT4_Pos 16
#define MATRIX_SASSR_SASPLIT4_Msk (0xfu << MATRIX_SASSR_SASPLIT4_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT4(value) ((MATRIX_SASSR_SASPLIT4_Msk & ((value) << MATRIX_SASSR_SASPLIT4_Pos)))
#define MATRIX_SASSR_SASPLIT5_Pos 20
#define MATRIX_SASSR_SASPLIT5_Msk (0xfu << MATRIX_SASSR_SASPLIT5_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT5(value) ((MATRIX_SASSR_SASPLIT5_Msk & ((value) << MATRIX_SASSR_SASPLIT5_Pos)))
#define MATRIX_SASSR_SASPLIT6_Pos 24
#define MATRIX_SASSR_SASPLIT6_Msk (0xfu << MATRIX_SASSR_SASPLIT6_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT6(value) ((MATRIX_SASSR_SASPLIT6_Msk & ((value) << MATRIX_SASSR_SASPLIT6_Pos)))
#define MATRIX_SASSR_SASPLIT7_Pos 28
#define MATRIX_SASSR_SASPLIT7_Msk (0xfu << MATRIX_SASSR_SASPLIT7_Pos) /**< \brief (MATRIX_SASSR[13]) Security Areas Split for HSELx Security Region */
#define MATRIX_SASSR_SASPLIT7(value) ((MATRIX_SASSR_SASPLIT7_Msk & ((value) << MATRIX_SASSR_SASPLIT7_Pos)))
/* -------- MATRIX_SRTSR[13] : (MATRIX Offset: 0x0280) Security Region Top Slave 0 Register -------- */
#define MATRIX_SRTSR_SRTOP0_Pos 0
#define MATRIX_SRTSR_SRTOP0_Msk (0xfu << MATRIX_SRTSR_SRTOP0_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP0(value) ((MATRIX_SRTSR_SRTOP0_Msk & ((value) << MATRIX_SRTSR_SRTOP0_Pos)))
#define MATRIX_SRTSR_SRTOP1_Pos 4
#define MATRIX_SRTSR_SRTOP1_Msk (0xfu << MATRIX_SRTSR_SRTOP1_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP1(value) ((MATRIX_SRTSR_SRTOP1_Msk & ((value) << MATRIX_SRTSR_SRTOP1_Pos)))
#define MATRIX_SRTSR_SRTOP2_Pos 8
#define MATRIX_SRTSR_SRTOP2_Msk (0xfu << MATRIX_SRTSR_SRTOP2_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP2(value) ((MATRIX_SRTSR_SRTOP2_Msk & ((value) << MATRIX_SRTSR_SRTOP2_Pos)))
#define MATRIX_SRTSR_SRTOP3_Pos 12
#define MATRIX_SRTSR_SRTOP3_Msk (0xfu << MATRIX_SRTSR_SRTOP3_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP3(value) ((MATRIX_SRTSR_SRTOP3_Msk & ((value) << MATRIX_SRTSR_SRTOP3_Pos)))
#define MATRIX_SRTSR_SRTOP4_Pos 16
#define MATRIX_SRTSR_SRTOP4_Msk (0xfu << MATRIX_SRTSR_SRTOP4_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP4(value) ((MATRIX_SRTSR_SRTOP4_Msk & ((value) << MATRIX_SRTSR_SRTOP4_Pos)))
#define MATRIX_SRTSR_SRTOP5_Pos 20
#define MATRIX_SRTSR_SRTOP5_Msk (0xfu << MATRIX_SRTSR_SRTOP5_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP5(value) ((MATRIX_SRTSR_SRTOP5_Msk & ((value) << MATRIX_SRTSR_SRTOP5_Pos)))
#define MATRIX_SRTSR_SRTOP6_Pos 24
#define MATRIX_SRTSR_SRTOP6_Msk (0xfu << MATRIX_SRTSR_SRTOP6_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP6(value) ((MATRIX_SRTSR_SRTOP6_Msk & ((value) << MATRIX_SRTSR_SRTOP6_Pos)))
#define MATRIX_SRTSR_SRTOP7_Pos 28
#define MATRIX_SRTSR_SRTOP7_Msk (0xfu << MATRIX_SRTSR_SRTOP7_Pos) /**< \brief (MATRIX_SRTSR[13]) HSELx Security Region Top */
#define MATRIX_SRTSR_SRTOP7(value) ((MATRIX_SRTSR_SRTOP7_Msk & ((value) << MATRIX_SRTSR_SRTOP7_Pos)))
/* -------- MATRIX_SPSELR[3] : (MATRIX Offset: 0x02C0) Security Peripheral Select 1 Register -------- */
#define MATRIX_SPSELR_NSECP0 (0x1u << 0) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP1 (0x1u << 1) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP2 (0x1u << 2) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP3 (0x1u << 3) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP4 (0x1u << 4) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP5 (0x1u << 5) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP6 (0x1u << 6) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP7 (0x1u << 7) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP8 (0x1u << 8) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP9 (0x1u << 9) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP10 (0x1u << 10) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP11 (0x1u << 11) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP12 (0x1u << 12) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP13 (0x1u << 13) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP14 (0x1u << 14) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP15 (0x1u << 15) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP16 (0x1u << 16) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP17 (0x1u << 17) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP18 (0x1u << 18) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP19 (0x1u << 19) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP20 (0x1u << 20) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP21 (0x1u << 21) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP22 (0x1u << 22) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP23 (0x1u << 23) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP24 (0x1u << 24) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP25 (0x1u << 25) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP26 (0x1u << 26) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP27 (0x1u << 27) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP28 (0x1u << 28) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP29 (0x1u << 29) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP30 (0x1u << 30) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */
#define MATRIX_SPSELR_NSECP31 (0x1u << 31) /**< \brief (MATRIX_SPSELR[3]) Not Secured PSELy Peripheral */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR AHB Multi-port DDR-SDRAM Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_MPDDRC AHB Multi-port DDR-SDRAM Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Mpddrc hardware registers */
typedef struct {
  __IO uint32_t MPDDRC_MR;             /**< \brief (Mpddrc Offset: 0x00) MPDDRC Mode Register */
  __IO uint32_t MPDDRC_RTR;            /**< \brief (Mpddrc Offset: 0x04) MPDDRC Refresh Timer Register */
  __IO uint32_t MPDDRC_CR;             /**< \brief (Mpddrc Offset: 0x08) MPDDRC Configuration Register */
  __IO uint32_t MPDDRC_TPR0;           /**< \brief (Mpddrc Offset: 0x0C) MPDDRC Timing Parameter 0 Register */
  __IO uint32_t MPDDRC_TPR1;           /**< \brief (Mpddrc Offset: 0x10) MPDDRC Timing Parameter 1 Register */
  __IO uint32_t MPDDRC_TPR2;           /**< \brief (Mpddrc Offset: 0x14) MPDDRC Timing Parameter 2 Register */
  __I  uint32_t Reserved1[1];
  __IO uint32_t MPDDRC_LPR;            /**< \brief (Mpddrc Offset: 0x1C) MPDDRC Low-power Register */
  __IO uint32_t MPDDRC_MD;             /**< \brief (Mpddrc Offset: 0x20) MPDDRC Memory Device Register */
  __I  uint32_t Reserved2[1];
  __IO uint32_t MPDDRC_LPDDR2_LPR;     /**< \brief (Mpddrc Offset: 0x28) MPDDRC LPDDR2 Low-power Register */
  __IO uint32_t MPDDRC_LPDDR2_CAL_MR4; /**< \brief (Mpddrc Offset: 0x2C) MPDDRC LPDDR2 Calibration and MR4 Register */
  __IO uint32_t MPDDRC_LPDDR2_TIM_CAL; /**< \brief (Mpddrc Offset: 0x30) MPDDRC LPDDR2 Timing Calibration Register */
  __IO uint32_t MPDDRC_IO_CALIBR;      /**< \brief (Mpddrc Offset: 0x34) MPDDRC IO Calibration */
  __IO uint32_t MPDDRC_OCMS;           /**< \brief (Mpddrc Offset: 0x38) MPDDRC OCMS Register */
  __O  uint32_t MPDDRC_OCMS_KEY1;      /**< \brief (Mpddrc Offset: 0x3C) MPDDRC OCMS KEY1 Register */
  __O  uint32_t MPDDRC_OCMS_KEY2;      /**< \brief (Mpddrc Offset: 0x40) MPDDRC OCMS KEY2 Register */
  __IO uint32_t MPDDRC_CONF_ARBITER;   /**< \brief (Mpddrc Offset: 0x44) MPDDRC Configuration Arbiter */
  __IO uint32_t MPDDRC_TIMEOUT;        /**< \brief (Mpddrc Offset: 0x48) MPDDRC Time-out Port 0/1/2/3 */
  __IO uint32_t MPDDRC_REQ_PORT_0123;  /**< \brief (Mpddrc Offset: 0x4C) MPDDRC Time-out Request Port 0/1/2/3 */
  __IO uint32_t MPDDRC_REQ_PORT_4567;  /**< \brief (Mpddrc Offset: 0x50) MPDDRC Time-out Request Port 4/5/6/7 */
  __I  uint32_t MPDDRC_BDW_PORT_0123;  /**< \brief (Mpddrc Offset: 0x54) MPDDRC Bandwidth Port 0/1/2/3 */
  __I  uint32_t MPDDRC_BDW_PORT_4567;  /**< \brief (Mpddrc Offset: 0x58) MPDDRC Bandwidth Port 4/5/6/7 */
  __IO uint32_t MPDDRC_RD_DATA_PATH;   /**< \brief (Mpddrc Offset: 0x5C) MPDDRC_READ_DATA_PATH */
  __IO uint32_t MPDDRC_SAW[4];         /**< \brief (Mpddrc Offset: 0x60) MPDDRC Smart Adaptation Wrapper 0 Register */
  __I  uint32_t Reserved3[29];
  __IO uint32_t MPDDRC_WPMR;           /**< \brief (Mpddrc Offset: 0xE4) MPDDRC Write Protect Control Register */
  __I  uint32_t MPDDRC_WPSR;           /**< \brief (Mpddrc Offset: 0xE8) MPDDRC Write Protect Status Register */
  __I  uint32_t Reserved4[5];
  __IO uint32_t MPDDRC_DLL_OS;         /**< \brief (Mpddrc Offset: 0x100) MPDDRC DLL Offset Selection Register */
  __IO uint32_t MPDDRC_DLL_MO;         /**< \brief (Mpddrc Offset: 0x104) MPDDRC DLL MASTER Offset Register */
  __IO uint32_t MPDDRC_DLL_SO0;        /**< \brief (Mpddrc Offset: 0x108) MPDDRC DLL SLAVE Offset 0 Register */
  __IO uint32_t MPDDRC_DLL_SO1;        /**< \brief (Mpddrc Offset: 0x10C) MPDDRC DLL SLAVE Offset 1 Register */
  __IO uint32_t MPDDRC_DLL_WRO;        /**< \brief (Mpddrc Offset: 0x110) MPDDRC DLL CLKWR Offset Register */
  __IO uint32_t MPDDRC_DLL_ADO;        /**< \brief (Mpddrc Offset: 0x114) MPDDRC DLL CLKAD Offset Register */
  __I  uint32_t MPDDRC_DLL_SM[4];      /**< \brief (Mpddrc Offset: 0x118) MPDDRC DLL Status MASTER0 Register */
  __I  uint32_t MPDDRC_DLL_SSL[8];     /**< \brief (Mpddrc Offset: 0x128) MPDDRC DLL Status SLAVE0 Register */
  __I  uint32_t MPDDRC_DLL_SWR[4];     /**< \brief (Mpddrc Offset: 0x148) MPDDRC DLL Status CLKWR0 Register */
  __I  uint32_t MPDDRC_DLL_SAD;        /**< \brief (Mpddrc Offset: 0x158) MPDDRC DLL Status CLKAD Register */
} Mpddrc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- MPDDRC_MR : (MPDDRC Offset: 0x00) MPDDRC Mode Register -------- */
#define MPDDRC_MR_MODE_Pos 0
#define MPDDRC_MR_MODE_Msk (0x7u << MPDDRC_MR_MODE_Pos) /**< \brief (MPDDRC_MR) MPDDRC Command Mode */
#define   MPDDRC_MR_MODE_NORMAL_CMD (0x0u << 0) /**< \brief (MPDDRC_MR) Normal Mode. Any access to the MPDDRC is decoded normally. To activate this mode, the command must be followed by a write to the DDR-SDRAM. */
#define   MPDDRC_MR_MODE_NOP_CMD (0x1u << 0) /**< \brief (MPDDRC_MR) The MPDDRC issues a NOP command when the DDR-SDRAM device is accessed regardless of the cycle. To activate this mode, the command must be followed by a write to the DDR-SDRAM. */
#define   MPDDRC_MR_MODE_PRCGALL_CMD (0x2u << 0) /**< \brief (MPDDRC_MR) The MPDDRC issues the All Banks Precharge command when the DDR-SDRAM device is accessed regardless of the cycle. To activate this mode, the command must be followed by a write to the SDRAM. */
#define   MPDDRC_MR_MODE_LMR_CMD (0x3u << 0) /**< \brief (MPDDRC_MR) The MPDDRC issues a Load Mode Register command when the DDR-SDRAM device is accessed regardless of the cycle. To activate this mode, the command must be followed by a write to the DDR-SDRAM. */
#define   MPDDRC_MR_MODE_RFSH_CMD (0x4u << 0) /**< \brief (MPDDRC_MR) The MPDDRC issues an Auto-Refresh command when the DDR-SDRAM device is accessed regardless of the cycle. Previously, an "All Banks Precharge" command must be issued. To activate this mode, the command must be followed by a write to the DDR-SDRAM. */
#define   MPDDRC_MR_MODE_EXT_LMR_CMD (0x5u << 0) /**< \brief (MPDDRC_MR) The MPDDRC issues an Extended Load Mode Register command when the SDRAM device is accessed regardless of the cycle. To activate this mode, the command must be followed by a write to the DDR-SDRAM. The write in the DDR-SDRAM must be done in the appropriate bank. */
#define   MPDDRC_MR_MODE_DEEP_CMD (0x6u << 0) /**< \brief (MPDDRC_MR) Deep power mode: Access to deep power-down mode */
#define   MPDDRC_MR_MODE_LPDDR2_CMD (0x7u << 0) /**< \brief (MPDDRC_MR) The MPDDRC issues an LPDDR2 Mode Register command when the Low-power DDR2-SDRAM device is accessed regardless of the cycle. To activate this mode, the Mode Register command must be followed by a write to the Low-power DDR2-SDRAM. */
#define MPDDRC_MR_MRS_Pos 8
#define MPDDRC_MR_MRS_Msk (0xffu << MPDDRC_MR_MRS_Pos) /**< \brief (MPDDRC_MR) Mode Register Select LPDDR2 */
#define MPDDRC_MR_MRS(value) ((MPDDRC_MR_MRS_Msk & ((value) << MPDDRC_MR_MRS_Pos)))
/* -------- MPDDRC_RTR : (MPDDRC Offset: 0x04) MPDDRC Refresh Timer Register -------- */
#define MPDDRC_RTR_COUNT_Pos 0
#define MPDDRC_RTR_COUNT_Msk (0xfffu << MPDDRC_RTR_COUNT_Pos) /**< \brief (MPDDRC_RTR) MPDDRC Refresh Timer Count */
#define MPDDRC_RTR_COUNT(value) ((MPDDRC_RTR_COUNT_Msk & ((value) << MPDDRC_RTR_COUNT_Pos)))
#define MPDDRC_RTR_ADJ_REF (0x1u << 16) /**< \brief (MPDDRC_RTR) Adjust Refresh Rate */
#define MPDDRC_RTR_REF_PB (0x1u << 17) /**< \brief (MPDDRC_RTR) Refresh Per Bank */
#define MPDDRC_RTR_MR4_VALUE_Pos 20
#define MPDDRC_RTR_MR4_VALUE_Msk (0x7u << MPDDRC_RTR_MR4_VALUE_Pos) /**< \brief (MPDDRC_RTR) Content of MR4 Register */
#define MPDDRC_RTR_MR4_VALUE(value) ((MPDDRC_RTR_MR4_VALUE_Msk & ((value) << MPDDRC_RTR_MR4_VALUE_Pos)))
/* -------- MPDDRC_CR : (MPDDRC Offset: 0x08) MPDDRC Configuration Register -------- */
#define MPDDRC_CR_NC_Pos 0
#define MPDDRC_CR_NC_Msk (0x3u << MPDDRC_CR_NC_Pos) /**< \brief (MPDDRC_CR) Number of Column Bits */
#define   MPDDRC_CR_NC_9_COL_BITS (0x0u << 0) /**< \brief (MPDDRC_CR) 9 bit to define the column number, up to 512 column */
#define   MPDDRC_CR_NC_10_COL_BITS (0x1u << 0) /**< \brief (MPDDRC_CR) 10 bit to define the column number, up to 1024 columns */
#define   MPDDRC_CR_NC_11_COL_BITS (0x2u << 0) /**< \brief (MPDDRC_CR) 11 bit to define the column number, up to 2048 columns */
#define   MPDDRC_CR_NC_12_COL_BITS (0x3u << 0) /**< \brief (MPDDRC_CR) 12 bit to define the column number, up to 4096 columns */
#define MPDDRC_CR_NR_Pos 2
#define MPDDRC_CR_NR_Msk (0x3u << MPDDRC_CR_NR_Pos) /**< \brief (MPDDRC_CR) Number of Row Bits */
#define   MPDDRC_CR_NR_11_ROW_BITS (0x0u << 2) /**< \brief (MPDDRC_CR) 11 bit to define the row number, up to 2048 rows */
#define   MPDDRC_CR_NR_12_ROW_BITS (0x1u << 2) /**< \brief (MPDDRC_CR) 12 bit to define the row number, up to 4096 rows */
#define   MPDDRC_CR_NR_13_ROW_BITS (0x2u << 2) /**< \brief (MPDDRC_CR) 13 bit to define the row number, up to 8192 rows */
#define   MPDDRC_CR_NR_14_ROW_BITS (0x3u << 2) /**< \brief (MPDDRC_CR) 14 bit to define the row number, up to 16384 rows */
#define MPDDRC_CR_CAS_Pos 4
#define MPDDRC_CR_CAS_Msk (0x7u << MPDDRC_CR_CAS_Pos) /**< \brief (MPDDRC_CR) CAS Latency */
#define   MPDDRC_CR_CAS_DDR_CAS2 (0x2u << 4) /**< \brief (MPDDRC_CR) LPDDR1 CAS Latency 2 */
#define   MPDDRC_CR_CAS_DDR_CAS3 (0x3u << 4) /**< \brief (MPDDRC_CR) DDR2/LPDDR2/LPDDR1 CAS Latency 3 */
#define   MPDDRC_CR_CAS_DDR_CAS4 (0x4u << 4) /**< \brief (MPDDRC_CR) DDR2/LPDDR2 CAS Latency 4 */
#define   MPDDRC_CR_CAS_DDR_CAS5 (0x5u << 4) /**< \brief (MPDDRC_CR) DDR2/LPDDR2 CAS Latency 5 */
#define   MPDDRC_CR_CAS_DDR_CAS6 (0x6u << 4) /**< \brief (MPDDRC_CR) DDR2 CAS Latency 6 */
#define MPDDRC_CR_DLL (0x1u << 7) /**< \brief (MPDDRC_CR) Reset DLL */
#define   MPDDRC_CR_DLL_RESET_DISABLED (0x0u << 7) /**< \brief (MPDDRC_CR) Disable DLL reset. */
#define   MPDDRC_CR_DLL_RESET_ENABLED (0x1u << 7) /**< \brief (MPDDRC_CR) Enable DLL reset. */
#define MPDDRC_CR_DIC_DS (0x1u << 8) /**< \brief (MPDDRC_CR) Output Driver Impedance Control (Drive Strength) */
#define   MPDDRC_CR_DIC_DS_DDR2_NORMALSTRENGTH (0x0u << 8) /**< \brief (MPDDRC_CR) Normal driver strength */
#define   MPDDRC_CR_DIC_DS_DDR2_WEAKSTRENGTH (0x1u << 8) /**< \brief (MPDDRC_CR) Weak driver strength */
#define MPDDRC_CR_DIS_DLL (0x1u << 9) /**< \brief (MPDDRC_CR) DISABLE DLL */
#define MPDDRC_CR_ZQ_Pos 10
#define MPDDRC_CR_ZQ_Msk (0x3u << MPDDRC_CR_ZQ_Pos) /**< \brief (MPDDRC_CR) ZQ Calibration */
#define   MPDDRC_CR_ZQ_INIT (0x0u << 10) /**< \brief (MPDDRC_CR) Calibration command after initialization */
#define   MPDDRC_CR_ZQ_LONG (0x1u << 10) /**< \brief (MPDDRC_CR) Long calibration */
#define   MPDDRC_CR_ZQ_SHORT (0x2u << 10) /**< \brief (MPDDRC_CR) Short calibration */
#define   MPDDRC_CR_ZQ_RESET (0x3u << 10) /**< \brief (MPDDRC_CR) ZQ Reset */
#define MPDDRC_CR_OCD_Pos 12
#define MPDDRC_CR_OCD_Msk (0x7u << MPDDRC_CR_OCD_Pos) /**< \brief (MPDDRC_CR) Off-chip Driver */
#define   MPDDRC_CR_OCD_DDR2_EXITCALIB (0x0u << 12) /**< \brief (MPDDRC_CR) Exit from OCD calibration mode and maintain settings */
#define   MPDDRC_CR_OCD_DDR2_DEFAULT_CALIB (0x7u << 12) /**< \brief (MPDDRC_CR) OCD calibration default */
#define MPDDRC_CR_DQMS (0x1u << 16) /**< \brief (MPDDRC_CR) Mask Data is Shared */
#define   MPDDRC_CR_DQMS_NOT_SHARED (0x0u << 16) /**< \brief (MPDDRC_CR) DQM is not shared with another controller. */
#define   MPDDRC_CR_DQMS_SHARED (0x1u << 16) /**< \brief (MPDDRC_CR) DQM is shared with another controller. */
#define MPDDRC_CR_ENRDM (0x1u << 17) /**< \brief (MPDDRC_CR) Enable Read Measure */
#define   MPDDRC_CR_ENRDM_OFF (0x0u << 17) /**< \brief (MPDDRC_CR) DQS/DDR_DATA phase error correction is disabled. */
#define   MPDDRC_CR_ENRDM_ON (0x1u << 17) /**< \brief (MPDDRC_CR) DQS/DDR_DATA phase error correction is enabled. */
#define MPDDRC_CR_LC_LPDDR1 (0x1u << 19) /**< \brief (MPDDRC_CR) Low-cost Low-power DDR1. */
#define   MPDDRC_CR_LC_LPDDR1_NOT_2_BANKS (0x0u << 19) /**< \brief (MPDDRC_CR) Any type of memory devices except of low cost, low density Low Power DDR1. */
#define   MPDDRC_CR_LC_LPDDR1_2_BANKS_LPDDR1 (0x1u << 19) /**< \brief (MPDDRC_CR) Low-cost and low-density Low-power DDR1. These devices have a density of 32 Mbits and are organized as 2 internal banks. To use this feature, the user has to define the type of memory and the data bus width (see "MPDDRC Memory Device Register" on page 69).The 16-bit memory device is organized as 2 banks, 9 columns and 11 rows. The 32-bit memory device is organized as 2 banks, 8 columns and 11 rows.It is impossible to use two 16-bit memory devices (2x32 Mbits) for creating one 32-bit memory device (64 Mbits). In this case, it is recommended to use one 32-bit memory device which embeds 4 internal banks. */
#define MPDDRC_CR_NB (0x1u << 20) /**< \brief (MPDDRC_CR) Number of Banks */
#define   MPDDRC_CR_NB_4_BANKS (0x0u << 20) /**< \brief (MPDDRC_CR) 4 banks memory devices. */
#define   MPDDRC_CR_NB_8_BANKS (0x1u << 20) /**< \brief (MPDDRC_CR) 8 banks. Only possible when using the DDR2-SDRAM and Low-power DDR2-SDRAM devices. */
#define MPDDRC_CR_NDQS (0x1u << 21) /**< \brief (MPDDRC_CR) Not DQS */
#define   MPDDRC_CR_NDQS_ENABLED (0x0u << 21) /**< \brief (MPDDRC_CR) Not DQS is enabled. */
#define   MPDDRC_CR_NDQS_DISABLED (0x1u << 21) /**< \brief (MPDDRC_CR) Not DQS is disabled. */
#define MPDDRC_CR_DECOD (0x1u << 22) /**< \brief (MPDDRC_CR) Type of Decoding */
#define   MPDDRC_CR_DECOD_SEQUENTIAL (0x0u << 22) /**< \brief (MPDDRC_CR) Method for address mapping where banks alternate at each last DDR-SDRAM page of the current bank. */
#define   MPDDRC_CR_DECOD_INTERLEAVED (0x1u << 22) /**< \brief (MPDDRC_CR) Method for address mapping where banks alternate at each SDRAM end page of the current bank. */
#define MPDDRC_CR_UNAL (0x1u << 23) /**< \brief (MPDDRC_CR) Support Unaligned Access */
#define   MPDDRC_CR_UNAL_UNSUPPORTED (0x0u << 23) /**< \brief (MPDDRC_CR) Unaligned access is not supported. */
#define   MPDDRC_CR_UNAL_SUPPORTED (0x1u << 23) /**< \brief (MPDDRC_CR) Unaligned access is supported. */
/* -------- MPDDRC_TPR0 : (MPDDRC Offset: 0x0C) MPDDRC Timing Parameter 0 Register -------- */
#define MPDDRC_TPR0_TRAS_Pos 0
#define MPDDRC_TPR0_TRAS_Msk (0xfu << MPDDRC_TPR0_TRAS_Pos) /**< \brief (MPDDRC_TPR0) Active to Precharge Delay */
#define MPDDRC_TPR0_TRAS(value) ((MPDDRC_TPR0_TRAS_Msk & ((value) << MPDDRC_TPR0_TRAS_Pos)))
#define MPDDRC_TPR0_TRCD_Pos 4
#define MPDDRC_TPR0_TRCD_Msk (0xfu << MPDDRC_TPR0_TRCD_Pos) /**< \brief (MPDDRC_TPR0) Row to Column Delay */
#define MPDDRC_TPR0_TRCD(value) ((MPDDRC_TPR0_TRCD_Msk & ((value) << MPDDRC_TPR0_TRCD_Pos)))
#define MPDDRC_TPR0_TWR_Pos 8
#define MPDDRC_TPR0_TWR_Msk (0xfu << MPDDRC_TPR0_TWR_Pos) /**< \brief (MPDDRC_TPR0) Write Recovery Delay */
#define MPDDRC_TPR0_TWR(value) ((MPDDRC_TPR0_TWR_Msk & ((value) << MPDDRC_TPR0_TWR_Pos)))
#define MPDDRC_TPR0_TRC_Pos 12
#define MPDDRC_TPR0_TRC_Msk (0xfu << MPDDRC_TPR0_TRC_Pos) /**< \brief (MPDDRC_TPR0) Row Cycle Delay */
#define MPDDRC_TPR0_TRC(value) ((MPDDRC_TPR0_TRC_Msk & ((value) << MPDDRC_TPR0_TRC_Pos)))
#define MPDDRC_TPR0_TRP_Pos 16
#define MPDDRC_TPR0_TRP_Msk (0xfu << MPDDRC_TPR0_TRP_Pos) /**< \brief (MPDDRC_TPR0) Row Precharge Delay */
#define MPDDRC_TPR0_TRP(value) ((MPDDRC_TPR0_TRP_Msk & ((value) << MPDDRC_TPR0_TRP_Pos)))
#define MPDDRC_TPR0_TRRD_Pos 20
#define MPDDRC_TPR0_TRRD_Msk (0xfu << MPDDRC_TPR0_TRRD_Pos) /**< \brief (MPDDRC_TPR0) Active BankA to Active BankB */
#define MPDDRC_TPR0_TRRD(value) ((MPDDRC_TPR0_TRRD_Msk & ((value) << MPDDRC_TPR0_TRRD_Pos)))
#define MPDDRC_TPR0_TWTR_Pos 24
#define MPDDRC_TPR0_TWTR_Msk (0xfu << MPDDRC_TPR0_TWTR_Pos) /**< \brief (MPDDRC_TPR0) Internal Write to Read Delay */
#define MPDDRC_TPR0_TWTR(value) ((MPDDRC_TPR0_TWTR_Msk & ((value) << MPDDRC_TPR0_TWTR_Pos)))
#define MPDDRC_TPR0_TMRD_Pos 28
#define MPDDRC_TPR0_TMRD_Msk (0xfu << MPDDRC_TPR0_TMRD_Pos) /**< \brief (MPDDRC_TPR0) Load Mode Register Command to Activate or Refresh Command */
#define MPDDRC_TPR0_TMRD(value) ((MPDDRC_TPR0_TMRD_Msk & ((value) << MPDDRC_TPR0_TMRD_Pos)))
/* -------- MPDDRC_TPR1 : (MPDDRC Offset: 0x10) MPDDRC Timing Parameter 1 Register -------- */
#define MPDDRC_TPR1_TRFC_Pos 0
#define MPDDRC_TPR1_TRFC_Msk (0x7fu << MPDDRC_TPR1_TRFC_Pos) /**< \brief (MPDDRC_TPR1) Row Cycle Delay */
#define MPDDRC_TPR1_TRFC(value) ((MPDDRC_TPR1_TRFC_Msk & ((value) << MPDDRC_TPR1_TRFC_Pos)))
#define MPDDRC_TPR1_TXSNR_Pos 8
#define MPDDRC_TPR1_TXSNR_Msk (0xffu << MPDDRC_TPR1_TXSNR_Pos) /**< \brief (MPDDRC_TPR1) Exit Self-refresh Delay to Non Read Command */
#define MPDDRC_TPR1_TXSNR(value) ((MPDDRC_TPR1_TXSNR_Msk & ((value) << MPDDRC_TPR1_TXSNR_Pos)))
#define MPDDRC_TPR1_TXSRD_Pos 16
#define MPDDRC_TPR1_TXSRD_Msk (0xffu << MPDDRC_TPR1_TXSRD_Pos) /**< \brief (MPDDRC_TPR1) Exit Self-refresh Delay to Read Command */
#define MPDDRC_TPR1_TXSRD(value) ((MPDDRC_TPR1_TXSRD_Msk & ((value) << MPDDRC_TPR1_TXSRD_Pos)))
#define MPDDRC_TPR1_TXP_Pos 24
#define MPDDRC_TPR1_TXP_Msk (0xfu << MPDDRC_TPR1_TXP_Pos) /**< \brief (MPDDRC_TPR1) Exit Power-down Delay to First Command */
#define MPDDRC_TPR1_TXP(value) ((MPDDRC_TPR1_TXP_Msk & ((value) << MPDDRC_TPR1_TXP_Pos)))
/* -------- MPDDRC_TPR2 : (MPDDRC Offset: 0x14) MPDDRC Timing Parameter 2 Register -------- */
#define MPDDRC_TPR2_TXARD_Pos 0
#define MPDDRC_TPR2_TXARD_Msk (0xfu << MPDDRC_TPR2_TXARD_Pos) /**< \brief (MPDDRC_TPR2) Exit Active Power Down Delay to Read Command in Mode "Fast Exit" */
#define MPDDRC_TPR2_TXARD(value) ((MPDDRC_TPR2_TXARD_Msk & ((value) << MPDDRC_TPR2_TXARD_Pos)))
#define MPDDRC_TPR2_TXARDS_Pos 4
#define MPDDRC_TPR2_TXARDS_Msk (0xfu << MPDDRC_TPR2_TXARDS_Pos) /**< \brief (MPDDRC_TPR2) Exit Active Power Down Delay to Read Command in Mode "Slow Exit" */
#define MPDDRC_TPR2_TXARDS(value) ((MPDDRC_TPR2_TXARDS_Msk & ((value) << MPDDRC_TPR2_TXARDS_Pos)))
#define MPDDRC_TPR2_TRPA_Pos 8
#define MPDDRC_TPR2_TRPA_Msk (0xfu << MPDDRC_TPR2_TRPA_Pos) /**< \brief (MPDDRC_TPR2) Row Precharge All Delay */
#define MPDDRC_TPR2_TRPA(value) ((MPDDRC_TPR2_TRPA_Msk & ((value) << MPDDRC_TPR2_TRPA_Pos)))
#define MPDDRC_TPR2_TRTP_Pos 12
#define MPDDRC_TPR2_TRTP_Msk (0x7u << MPDDRC_TPR2_TRTP_Pos) /**< \brief (MPDDRC_TPR2) Read to Precharge */
#define MPDDRC_TPR2_TRTP(value) ((MPDDRC_TPR2_TRTP_Msk & ((value) << MPDDRC_TPR2_TRTP_Pos)))
#define MPDDRC_TPR2_TFAW_Pos 16
#define MPDDRC_TPR2_TFAW_Msk (0xfu << MPDDRC_TPR2_TFAW_Pos) /**< \brief (MPDDRC_TPR2) Four Active Windows */
#define MPDDRC_TPR2_TFAW(value) ((MPDDRC_TPR2_TFAW_Msk & ((value) << MPDDRC_TPR2_TFAW_Pos)))
/* -------- MPDDRC_LPR : (MPDDRC Offset: 0x1C) MPDDRC Low-power Register -------- */
#define MPDDRC_LPR_LPCB_Pos 0
#define MPDDRC_LPR_LPCB_Msk (0x3u << MPDDRC_LPR_LPCB_Pos) /**< \brief (MPDDRC_LPR) Low-power Command Bit */
#define   MPDDRC_LPR_LPCB_NOLOWPOWER (0x0u << 0) /**< \brief (MPDDRC_LPR) Low-power feature is inhibited. No power-down, self-refresh and deep-power modes are issued to the DDR-SDRAM device. */
#define   MPDDRC_LPR_LPCB_SELFREFRESH (0x1u << 0) /**< \brief (MPDDRC_LPR) The MPDDRC issues a self-refresh command to the DDR-SDRAM device, the clock(s) is/are deactivated and the CKE signal is set low. The DDR-SDRAM device leaves the self-refresh mode when accessed and reenters it after the access. */
#define   MPDDRC_LPR_LPCB_POWERDOWN (0x2u << 0) /**< \brief (MPDDRC_LPR) The MPDDRC issues a Power-down command to the DDR-SDRAM device after each access, the CKE signal is set low. The DDR-SDRAM device leaves the power-down mode when accessed and reenters it after the access. */
#define   MPDDRC_LPR_LPCB_DEEPPOWERDOWN (0x3u << 0) /**< \brief (MPDDRC_LPR) The MPDDRC issues a Deep Power-down command to the Low-power DDR-SDRAM device. */
#define MPDDRC_LPR_CLK_FR (0x1u << 2) /**< \brief (MPDDRC_LPR) Clock Frozen Command Bit */
#define   MPDDRC_LPR_CLK_FR_DISABLED (0x0u << 2) /**< \brief (MPDDRC_LPR) Clock(s) is/are not frozen. */
#define   MPDDRC_LPR_CLK_FR_ENABLED (0x1u << 2) /**< \brief (MPDDRC_LPR) Clock(s) is/are frozen. */
#define MPDDRC_LPR_LPDDR2_PWOFF (0x1u << 3) /**< \brief (MPDDRC_LPR) LPDDR2 Power Off Bit */
#define   MPDDRC_LPR_LPDDR2_PWOFF_DISABLED (0x0u << 3) /**< \brief (MPDDRC_LPR) No power off sequence applied to LPDDR2. */
#define   MPDDRC_LPR_LPDDR2_PWOFF_ENABLED (0x1u << 3) /**< \brief (MPDDRC_LPR) A power off sequence is applied to the LPDDR2 device. CKE is forced low. */
#define MPDDRC_LPR_PASR_Pos 4
#define MPDDRC_LPR_PASR_Msk (0x7u << MPDDRC_LPR_PASR_Pos) /**< \brief (MPDDRC_LPR) Partial Array Self-refresh */
#define MPDDRC_LPR_PASR(value) ((MPDDRC_LPR_PASR_Msk & ((value) << MPDDRC_LPR_PASR_Pos)))
#define MPDDRC_LPR_DS_Pos 8
#define MPDDRC_LPR_DS_Msk (0x7u << MPDDRC_LPR_DS_Pos) /**< \brief (MPDDRC_LPR) Drive Strength */
#define MPDDRC_LPR_DS(value) ((MPDDRC_LPR_DS_Msk & ((value) << MPDDRC_LPR_DS_Pos)))
#define MPDDRC_LPR_TIMEOUT_Pos 12
#define MPDDRC_LPR_TIMEOUT_Msk (0x3u << MPDDRC_LPR_TIMEOUT_Pos) /**< \brief (MPDDRC_LPR) Time Between Last Transfer and Low Power Mode */
#define   MPDDRC_LPR_TIMEOUT_NONE (0x0u << 12) /**< \brief (MPDDRC_LPR) SDRAM low-power mode is activated immediately after the end of the last transfer. */
#define   MPDDRC_LPR_TIMEOUT_DELAY_64_CLK (0x1u << 12) /**< \brief (MPDDRC_LPR) SDRAM low-power mode is activated 64 clock cycles after the end of the last transfer. */
#define   MPDDRC_LPR_TIMEOUT_DELAY_128_CLK (0x2u << 12) /**< \brief (MPDDRC_LPR) SDRAM low-power mode is activated 128 clock cycles after the end of the last transfer. */
#define MPDDRC_LPR_APDE (0x1u << 16) /**< \brief (MPDDRC_LPR) Active Power Down Exit Time */
#define   MPDDRC_LPR_APDE_DDR2_FAST_EXIT (0x0u << 16) /**< \brief (MPDDRC_LPR) Fast Exit from Power Down. The DDR2-SDRAM devices only. */
#define   MPDDRC_LPR_APDE_DDR2_SLOW_EXIT (0x1u << 16) /**< \brief (MPDDRC_LPR) Slow Exit from Power Down. The DDR2-SDRAM devices only. */
#define MPDDRC_LPR_UPD_MR_Pos 20
#define MPDDRC_LPR_UPD_MR_Msk (0x3u << MPDDRC_LPR_UPD_MR_Pos) /**< \brief (MPDDRC_LPR) Update Load Mode Register and Extended Mode Register */
#define   MPDDRC_LPR_UPD_MR_NO_UPDATE (0x0u << 20) /**< \brief (MPDDRC_LPR) Update of Load Mode and Extended Mode registers is disabled. */
#define   MPDDRC_LPR_UPD_MR_UPDATE_SHAREDBUS (0x1u << 20) /**< \brief (MPDDRC_LPR) DDRSDRC shares an external bus. Automatic update is done during a refresh command and a pending read or write access in the SDRAM device. */
#define   MPDDRC_LPR_UPD_MR_UPDATE_NOSHAREDBUS (0x2u << 20) /**< \brief (MPDDRC_LPR) DDRSDRC does not share an external bus. Automatic update is done before entering in self-refresh mode. */
/* -------- MPDDRC_MD : (MPDDRC Offset: 0x20) MPDDRC Memory Device Register -------- */
#define MPDDRC_MD_MD_Pos 0
#define MPDDRC_MD_MD_Msk (0x7u << MPDDRC_MD_MD_Pos) /**< \brief (MPDDRC_MD) Memory Device */
#define   MPDDRC_MD_MD_DDR_SDRAM (0x2u << 0) /**< \brief (MPDDRC_MD) DDR1-SDRAM */
#define   MPDDRC_MD_MD_LPDDR_SDRAM (0x3u << 0) /**< \brief (MPDDRC_MD) Low-power DDR1-SDRAM */
#define   MPDDRC_MD_MD_DDR2_SDRAM (0x6u << 0) /**< \brief (MPDDRC_MD) DDR2-SDRAM */
#define   MPDDRC_MD_MD_LPDDR2_SDRAM (0x7u << 0) /**< \brief (MPDDRC_MD) Low-Power DDR2-SDRAM */
#define MPDDRC_MD_DBW (0x1u << 4) /**< \brief (MPDDRC_MD) Data Bus Width */
#define   MPDDRC_MD_DBW_DBW_32_BITS (0x0u << 4) /**< \brief (MPDDRC_MD) Data bus width is 32 bits. */
#define   MPDDRC_MD_DBW_DBW_16_BITS (0x1u << 4) /**< \brief (MPDDRC_MD) Data bus width is 16 bits. */
/* -------- MPDDRC_LPDDR2_LPR : (MPDDRC Offset: 0x28) MPDDRC LPDDR2 Low-power Register -------- */
#define MPDDRC_LPDDR2_LPR_BK_MASK_PASR_Pos 0
#define MPDDRC_LPDDR2_LPR_BK_MASK_PASR_Msk (0xffu << MPDDRC_LPDDR2_LPR_BK_MASK_PASR_Pos) /**< \brief (MPDDRC_LPDDR2_LPR) Bank Mask Bit/PASR */
#define MPDDRC_LPDDR2_LPR_BK_MASK_PASR(value) ((MPDDRC_LPDDR2_LPR_BK_MASK_PASR_Msk & ((value) << MPDDRC_LPDDR2_LPR_BK_MASK_PASR_Pos)))
#define MPDDRC_LPDDR2_LPR_SEG_MASK_Pos 8
#define MPDDRC_LPDDR2_LPR_SEG_MASK_Msk (0xffffu << MPDDRC_LPDDR2_LPR_SEG_MASK_Pos) /**< \brief (MPDDRC_LPDDR2_LPR) Segment Mask Bit */
#define MPDDRC_LPDDR2_LPR_SEG_MASK(value) ((MPDDRC_LPDDR2_LPR_SEG_MASK_Msk & ((value) << MPDDRC_LPDDR2_LPR_SEG_MASK_Pos)))
#define MPDDRC_LPDDR2_LPR_DS_Pos 24
#define MPDDRC_LPDDR2_LPR_DS_Msk (0xfu << MPDDRC_LPDDR2_LPR_DS_Pos) /**< \brief (MPDDRC_LPDDR2_LPR) Drive strength */
#define MPDDRC_LPDDR2_LPR_DS(value) ((MPDDRC_LPDDR2_LPR_DS_Msk & ((value) << MPDDRC_LPDDR2_LPR_DS_Pos)))
/* -------- MPDDRC_LPDDR2_CAL_MR4 : (MPDDRC Offset: 0x2C) MPDDRC LPDDR2 Calibration and MR4 Register -------- */
#define MPDDRC_LPDDR2_CAL_MR4_COUNT_CAL_Pos 0
#define MPDDRC_LPDDR2_CAL_MR4_COUNT_CAL_Msk (0xffffu << MPDDRC_LPDDR2_CAL_MR4_COUNT_CAL_Pos) /**< \brief (MPDDRC_LPDDR2_CAL_MR4) LPDDR2 Calibration Timer Count */
#define MPDDRC_LPDDR2_CAL_MR4_COUNT_CAL(value) ((MPDDRC_LPDDR2_CAL_MR4_COUNT_CAL_Msk & ((value) << MPDDRC_LPDDR2_CAL_MR4_COUNT_CAL_Pos)))
#define MPDDRC_LPDDR2_CAL_MR4_MR4_READ_Pos 16
#define MPDDRC_LPDDR2_CAL_MR4_MR4_READ_Msk (0xffffu << MPDDRC_LPDDR2_CAL_MR4_MR4_READ_Pos) /**< \brief (MPDDRC_LPDDR2_CAL_MR4) Mode Register 4 Read Interval */
#define MPDDRC_LPDDR2_CAL_MR4_MR4_READ(value) ((MPDDRC_LPDDR2_CAL_MR4_MR4_READ_Msk & ((value) << MPDDRC_LPDDR2_CAL_MR4_MR4_READ_Pos)))
/* -------- MPDDRC_LPDDR2_TIM_CAL : (MPDDRC Offset: 0x30) MPDDRC LPDDR2 Timing Calibration Register -------- */
#define MPDDRC_LPDDR2_TIM_CAL_ZQCS_Pos 0
#define MPDDRC_LPDDR2_TIM_CAL_ZQCS_Msk (0xffu << MPDDRC_LPDDR2_TIM_CAL_ZQCS_Pos) /**< \brief (MPDDRC_LPDDR2_TIM_CAL) ZQ Calibration Short */
#define MPDDRC_LPDDR2_TIM_CAL_ZQCS(value) ((MPDDRC_LPDDR2_TIM_CAL_ZQCS_Msk & ((value) << MPDDRC_LPDDR2_TIM_CAL_ZQCS_Pos)))
/* -------- MPDDRC_IO_CALIBR : (MPDDRC Offset: 0x34) MPDDRC IO Calibration -------- */
#define MPDDRC_IO_CALIBR_RDIV_Pos 0
#define MPDDRC_IO_CALIBR_RDIV_Msk (0x7u << MPDDRC_IO_CALIBR_RDIV_Pos) /**< \brief (MPDDRC_IO_CALIBR) Resistor Divider, Output Driver Impedance */
#define   MPDDRC_IO_CALIBR_RDIV_RZQ_34 (0x1u << 0) /**< \brief (MPDDRC_IO_CALIBR) LPDDR2 RZQ = 34,3 Ohms, DDR2/LPDDR1: Not applicable */
#define   MPDDRC_IO_CALIBR_RDIV_RZQ_40_RZQ_33_3 (0x2u << 0) /**< \brief (MPDDRC_IO_CALIBR) LPDDR2:RZQ = 40 Ohms, DDR2/LPDDR1: RZQ = 33,3 Ohms */
#define   MPDDRC_IO_CALIBR_RDIV_RZQ_48_RZQ_40 (0x3u << 0) /**< \brief (MPDDRC_IO_CALIBR) LPDDR2:RZQ =48 Ohms, DDR2/LPDDR1: RZQ =40 Ohms */
#define   MPDDRC_IO_CALIBR_RDIV_RZQ_60_RZQ_50 (0x4u << 0) /**< \brief (MPDDRC_IO_CALIBR) LPDDR2:RZQ =60 Ohms, DDR2/LPDDR1: RZQ =50 Ohms */
#define   MPDDRC_IO_CALIBR_RDIV_RZQ_80_RZQ_66_7 (0x6u << 0) /**< \brief (MPDDRC_IO_CALIBR) LPDDR2: RZQ = 80 Ohms, DDR2/LPDDR1: RZQ = 66,7 Ohms */
#define   MPDDRC_IO_CALIBR_RDIV_RZQ_120_RZQ_100 (0x7u << 0) /**< \brief (MPDDRC_IO_CALIBR) LPDDR2:RZQ = 120 Ohms, DDR2/LPDDR1: RZQ = 100 Ohms */
#define MPDDRC_IO_CALIBR_EN_CALIB (0x1u << 4) /**< \brief (MPDDRC_IO_CALIBR) Enable of the Calibration */
#define   MPDDRC_IO_CALIBR_EN_CALIB_DISABLE_CALIBRATION (0x0u << 4) /**< \brief (MPDDRC_IO_CALIBR) Calibration is disabled. */
#define   MPDDRC_IO_CALIBR_EN_CALIB_ENABLE_CALIBRATION (0x1u << 4) /**< \brief (MPDDRC_IO_CALIBR) Calibration is enabled. */
#define MPDDRC_IO_CALIBR_TZQIO_Pos 8
#define MPDDRC_IO_CALIBR_TZQIO_Msk (0x7u << MPDDRC_IO_CALIBR_TZQIO_Pos) /**< \brief (MPDDRC_IO_CALIBR) IO Calibration */
#define MPDDRC_IO_CALIBR_TZQIO(value) ((MPDDRC_IO_CALIBR_TZQIO_Msk & ((value) << MPDDRC_IO_CALIBR_TZQIO_Pos)))
#define MPDDRC_IO_CALIBR_CALCODEP_Pos 16
#define MPDDRC_IO_CALIBR_CALCODEP_Msk (0xfu << MPDDRC_IO_CALIBR_CALCODEP_Pos) /**< \brief (MPDDRC_IO_CALIBR) Number of Transistor P */
#define MPDDRC_IO_CALIBR_CALCODEP(value) ((MPDDRC_IO_CALIBR_CALCODEP_Msk & ((value) << MPDDRC_IO_CALIBR_CALCODEP_Pos)))
#define MPDDRC_IO_CALIBR_CALCODEN_Pos 20
#define MPDDRC_IO_CALIBR_CALCODEN_Msk (0xfu << MPDDRC_IO_CALIBR_CALCODEN_Pos) /**< \brief (MPDDRC_IO_CALIBR) Number of Transistor N */
#define MPDDRC_IO_CALIBR_CALCODEN(value) ((MPDDRC_IO_CALIBR_CALCODEN_Msk & ((value) << MPDDRC_IO_CALIBR_CALCODEN_Pos)))
/* -------- MPDDRC_OCMS : (MPDDRC Offset: 0x38) MPDDRC OCMS Register -------- */
#define MPDDRC_OCMS_SCR_EN (0x1u << 0) /**< \brief (MPDDRC_OCMS) Scrambling Enable */
/* -------- MPDDRC_OCMS_KEY1 : (MPDDRC Offset: 0x3C) MPDDRC OCMS KEY1 Register -------- */
#define MPDDRC_OCMS_KEY1_KEY1_Pos 0
#define MPDDRC_OCMS_KEY1_KEY1_Msk (0xffffffffu << MPDDRC_OCMS_KEY1_KEY1_Pos) /**< \brief (MPDDRC_OCMS_KEY1) Off-chip Memory Scrambling (OCMS) Key Part 1 */
#define MPDDRC_OCMS_KEY1_KEY1(value) ((MPDDRC_OCMS_KEY1_KEY1_Msk & ((value) << MPDDRC_OCMS_KEY1_KEY1_Pos)))
/* -------- MPDDRC_OCMS_KEY2 : (MPDDRC Offset: 0x40) MPDDRC OCMS KEY2 Register -------- */
#define MPDDRC_OCMS_KEY2_KEY2_Pos 0
#define MPDDRC_OCMS_KEY2_KEY2_Msk (0xffffffffu << MPDDRC_OCMS_KEY2_KEY2_Pos) /**< \brief (MPDDRC_OCMS_KEY2) Off-chip Memory Scrambling (OCMS) Key Part 2 */
#define MPDDRC_OCMS_KEY2_KEY2(value) ((MPDDRC_OCMS_KEY2_KEY2_Msk & ((value) << MPDDRC_OCMS_KEY2_KEY2_Pos)))
/* -------- MPDDRC_CONF_ARBITER : (MPDDRC Offset: 0x44) MPDDRC Configuration Arbiter -------- */
#define MPDDRC_CONF_ARBITER_ARB_Pos 0
#define MPDDRC_CONF_ARBITER_ARB_Msk (0x3u << MPDDRC_CONF_ARBITER_ARB_Pos) /**< \brief (MPDDRC_CONF_ARBITER) Type of Arbitration */
#define   MPDDRC_CONF_ARBITER_ARB_ROUND (0x0u << 0) /**< \brief (MPDDRC_CONF_ARBITER) Round Robin */
#define   MPDDRC_CONF_ARBITER_ARB_NB_REQUEST (0x1u << 0) /**< \brief (MPDDRC_CONF_ARBITER) Request Policy */
#define   MPDDRC_CONF_ARBITER_ARB_BANDWIDTH (0x2u << 0) /**< \brief (MPDDRC_CONF_ARBITER) Bandwidth Policy */
#define MPDDRC_CONF_ARBITER_BDW_BURST (0x1u << 2) /**< \brief (MPDDRC_CONF_ARBITER) Bandwidth is Reached or Bandwidth and Current Burst Access is Ended */
#define MPDDRC_CONF_ARBITER_BDW_MAX_CUR (0x1u << 3) /**< \brief (MPDDRC_CONF_ARBITER) Bandwidth Max or Current */
#define MPDDRC_CONF_ARBITER_RQ_WD_P0 (0x1u << 8) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_RQ_WD_P1 (0x1u << 9) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_RQ_WD_P2 (0x1u << 10) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_RQ_WD_P3 (0x1u << 11) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_RQ_WD_P4 (0x1u << 12) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_RQ_WD_P5 (0x1u << 13) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_RQ_WD_P6 (0x1u << 14) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_RQ_WD_P7 (0x1u << 15) /**< \brief (MPDDRC_CONF_ARBITER) Request or Word from port X */
#define MPDDRC_CONF_ARBITER_MA_PR_P0 (0x1u << 16) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
#define MPDDRC_CONF_ARBITER_MA_PR_P1 (0x1u << 17) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
#define MPDDRC_CONF_ARBITER_MA_PR_P2 (0x1u << 18) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
#define MPDDRC_CONF_ARBITER_MA_PR_P3 (0x1u << 19) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
#define MPDDRC_CONF_ARBITER_MA_PR_P4 (0x1u << 20) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
#define MPDDRC_CONF_ARBITER_MA_PR_P5 (0x1u << 21) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
#define MPDDRC_CONF_ARBITER_MA_PR_P6 (0x1u << 22) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
#define MPDDRC_CONF_ARBITER_MA_PR_P7 (0x1u << 23) /**< \brief (MPDDRC_CONF_ARBITER) Master or Software Provide Information */
/* -------- MPDDRC_TIMEOUT : (MPDDRC Offset: 0x48) MPDDRC Time-out Port 0/1/2/3 -------- */
#define MPDDRC_TIMEOUT_TIMEOUT_P0_Pos 0
#define MPDDRC_TIMEOUT_TIMEOUT_P0_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P0_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P0(value) ((MPDDRC_TIMEOUT_TIMEOUT_P0_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P0_Pos)))
#define MPDDRC_TIMEOUT_TIMEOUT_P1_Pos 4
#define MPDDRC_TIMEOUT_TIMEOUT_P1_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P1_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P1(value) ((MPDDRC_TIMEOUT_TIMEOUT_P1_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P1_Pos)))
#define MPDDRC_TIMEOUT_TIMEOUT_P2_Pos 8
#define MPDDRC_TIMEOUT_TIMEOUT_P2_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P2_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P2(value) ((MPDDRC_TIMEOUT_TIMEOUT_P2_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P2_Pos)))
#define MPDDRC_TIMEOUT_TIMEOUT_P3_Pos 12
#define MPDDRC_TIMEOUT_TIMEOUT_P3_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P3_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P3(value) ((MPDDRC_TIMEOUT_TIMEOUT_P3_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P3_Pos)))
#define MPDDRC_TIMEOUT_TIMEOUT_P4_Pos 16
#define MPDDRC_TIMEOUT_TIMEOUT_P4_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P4_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P4(value) ((MPDDRC_TIMEOUT_TIMEOUT_P4_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P4_Pos)))
#define MPDDRC_TIMEOUT_TIMEOUT_P5_Pos 20
#define MPDDRC_TIMEOUT_TIMEOUT_P5_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P5_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P5(value) ((MPDDRC_TIMEOUT_TIMEOUT_P5_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P5_Pos)))
#define MPDDRC_TIMEOUT_TIMEOUT_P6_Pos 24
#define MPDDRC_TIMEOUT_TIMEOUT_P6_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P6_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P6(value) ((MPDDRC_TIMEOUT_TIMEOUT_P6_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P6_Pos)))
#define MPDDRC_TIMEOUT_TIMEOUT_P7_Pos 28
#define MPDDRC_TIMEOUT_TIMEOUT_P7_Msk (0xfu << MPDDRC_TIMEOUT_TIMEOUT_P7_Pos) /**< \brief (MPDDRC_TIMEOUT) Time-out for Ports 0, 1, 2, 3, 4, 5, 6 and 7 */
#define MPDDRC_TIMEOUT_TIMEOUT_P7(value) ((MPDDRC_TIMEOUT_TIMEOUT_P7_Msk & ((value) << MPDDRC_TIMEOUT_TIMEOUT_P7_Pos)))
/* -------- MPDDRC_REQ_PORT_0123 : (MPDDRC Offset: 0x4C) MPDDRC Time-out Request Port 0/1/2/3 -------- */
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P0_Pos 0
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P0_Msk (0xffu << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P0_Pos) /**< \brief (MPDDRC_REQ_PORT_0123) Number of Requests, Number of Words or Bandwidth Allocation from Port 0-1-2-3 */
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P0(value) ((MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P0_Msk & ((value) << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P0_Pos)))
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P1_Pos 8
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P1_Msk (0xffu << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P1_Pos) /**< \brief (MPDDRC_REQ_PORT_0123) Number of Requests, Number of Words or Bandwidth Allocation from Port 0-1-2-3 */
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P1(value) ((MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P1_Msk & ((value) << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P1_Pos)))
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P2_Pos 16
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P2_Msk (0xffu << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P2_Pos) /**< \brief (MPDDRC_REQ_PORT_0123) Number of Requests, Number of Words or Bandwidth Allocation from Port 0-1-2-3 */
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P2(value) ((MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P2_Msk & ((value) << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P2_Pos)))
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P3_Pos 24
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P3_Msk (0xffu << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P3_Pos) /**< \brief (MPDDRC_REQ_PORT_0123) Number of Requests, Number of Words or Bandwidth Allocation from Port 0-1-2-3 */
#define MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P3(value) ((MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P3_Msk & ((value) << MPDDRC_REQ_PORT_0123_NRQ_NWD_BDW_P3_Pos)))
/* -------- MPDDRC_REQ_PORT_4567 : (MPDDRC Offset: 0x50) MPDDRC Time-out Request Port 4/5/6/7 -------- */
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P4_Pos 0
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P4_Msk (0xffu << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P4_Pos) /**< \brief (MPDDRC_REQ_PORT_4567) Number of Requests, Number of Words or Bandwidth allocation from port 4-5-6-7 */
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P4(value) ((MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P4_Msk & ((value) << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P4_Pos)))
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P5_Pos 8
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P5_Msk (0xffu << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P5_Pos) /**< \brief (MPDDRC_REQ_PORT_4567) Number of Requests, Number of Words or Bandwidth allocation from port 4-5-6-7 */
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P5(value) ((MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P5_Msk & ((value) << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P5_Pos)))
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P6_Pos 16
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P6_Msk (0xffu << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P6_Pos) /**< \brief (MPDDRC_REQ_PORT_4567) Number of Requests, Number of Words or Bandwidth allocation from port 4-5-6-7 */
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P6(value) ((MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P6_Msk & ((value) << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P6_Pos)))
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P7_Pos 24
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P7_Msk (0xffu << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P7_Pos) /**< \brief (MPDDRC_REQ_PORT_4567) Number of Requests, Number of Words or Bandwidth allocation from port 4-5-6-7 */
#define MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P7(value) ((MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P7_Msk & ((value) << MPDDRC_REQ_PORT_4567_NRQ_NWD_BDW_P7_Pos)))
/* -------- MPDDRC_BDW_PORT_0123 : (MPDDRC Offset: 0x54) MPDDRC Bandwidth Port 0/1/2/3 -------- */
#define MPDDRC_BDW_PORT_0123_BDW_P0_Pos 0
#define MPDDRC_BDW_PORT_0123_BDW_P0_Msk (0x7fu << MPDDRC_BDW_PORT_0123_BDW_P0_Pos) /**< \brief (MPDDRC_BDW_PORT_0123) Current/Maximum Bandwidth from Port 0-1-2-3 */
#define MPDDRC_BDW_PORT_0123_BDW_P1_Pos 8
#define MPDDRC_BDW_PORT_0123_BDW_P1_Msk (0x7fu << MPDDRC_BDW_PORT_0123_BDW_P1_Pos) /**< \brief (MPDDRC_BDW_PORT_0123) Current/Maximum Bandwidth from Port 0-1-2-3 */
#define MPDDRC_BDW_PORT_0123_BDW_P2_Pos 16
#define MPDDRC_BDW_PORT_0123_BDW_P2_Msk (0x7fu << MPDDRC_BDW_PORT_0123_BDW_P2_Pos) /**< \brief (MPDDRC_BDW_PORT_0123) Current/Maximum Bandwidth from Port 0-1-2-3 */
#define MPDDRC_BDW_PORT_0123_BDW_P3_Pos 24
#define MPDDRC_BDW_PORT_0123_BDW_P3_Msk (0x7fu << MPDDRC_BDW_PORT_0123_BDW_P3_Pos) /**< \brief (MPDDRC_BDW_PORT_0123) Current/Maximum Bandwidth from Port 0-1-2-3 */
/* -------- MPDDRC_BDW_PORT_4567 : (MPDDRC Offset: 0x58) MPDDRC Bandwidth Port 4/5/6/7 -------- */
#define MPDDRC_BDW_PORT_4567_BDW_P4_Pos 0
#define MPDDRC_BDW_PORT_4567_BDW_P4_Msk (0x7fu << MPDDRC_BDW_PORT_4567_BDW_P4_Pos) /**< \brief (MPDDRC_BDW_PORT_4567) Current/Maximum Bandwidth from Port 4-5-6-7 */
#define MPDDRC_BDW_PORT_4567_BDW_P5_Pos 8
#define MPDDRC_BDW_PORT_4567_BDW_P5_Msk (0x7fu << MPDDRC_BDW_PORT_4567_BDW_P5_Pos) /**< \brief (MPDDRC_BDW_PORT_4567) Current/Maximum Bandwidth from Port 4-5-6-7 */
#define MPDDRC_BDW_PORT_4567_BDW_P6_Pos 16
#define MPDDRC_BDW_PORT_4567_BDW_P6_Msk (0x7fu << MPDDRC_BDW_PORT_4567_BDW_P6_Pos) /**< \brief (MPDDRC_BDW_PORT_4567) Current/Maximum Bandwidth from Port 4-5-6-7 */
#define MPDDRC_BDW_PORT_4567_BDW_P7_Pos 24
#define MPDDRC_BDW_PORT_4567_BDW_P7_Msk (0x7fu << MPDDRC_BDW_PORT_4567_BDW_P7_Pos) /**< \brief (MPDDRC_BDW_PORT_4567) Current/Maximum Bandwidth from Port 4-5-6-7 */
/* -------- MPDDRC_RD_DATA_PATH : (MPDDRC Offset: 0x5C) MPDDRC_READ_DATA_PATH -------- */
#define MPDDRC_RD_DATA_PATH_SHIFT_SAMPLING_Pos 0
#define MPDDRC_RD_DATA_PATH_SHIFT_SAMPLING_Msk (0x3u << MPDDRC_RD_DATA_PATH_SHIFT_SAMPLING_Pos) /**< \brief (MPDDRC_RD_DATA_PATH) Shift Sampling Point of Data */
#define   MPDDRC_RD_DATA_PATH_SHIFT_SAMPLING_NO_SHIFT (0x0u << 0) /**< \brief (MPDDRC_RD_DATA_PATH) Initial sampling point. */
#define   MPDDRC_RD_DATA_PATH_SHIFT_SAMPLING_SHIFT_ONE_CYCLE (0x1u << 0) /**< \brief (MPDDRC_RD_DATA_PATH) Sampling point is shifted of one cycle. */
#define   MPDDRC_RD_DATA_PATH_SHIFT_SAMPLING_SHIFT_TWO_CYCLES (0x2u << 0) /**< \brief (MPDDRC_RD_DATA_PATH) Sampling point is shifted of two cycles. */
#define   MPDDRC_RD_DATA_PATH_SHIFT_SAMPLING_SHIFT_THREE_CYCLES (0x3u << 0) /**< \brief (MPDDRC_RD_DATA_PATH) Sampling point is shifted of three cycles, unique for LPDDR2.Not applicable for the DDR2 and LPDDR1devices. */
/* -------- MPDDRC_SAW[4] : (MPDDRC Offset: 0x60) MPDDRC Smart Adaptation Wrapper 0 Register -------- */
#define MPDDRC_SAW_FLUSH_MAX_Pos 0
#define MPDDRC_SAW_FLUSH_MAX_Msk (0xffu << MPDDRC_SAW_FLUSH_MAX_Pos) /**< \brief (MPDDRC_SAW[4]) Clears FIFO Content */
#define MPDDRC_SAW_FLUSH_MAX(value) ((MPDDRC_SAW_FLUSH_MAX_Msk & ((value) << MPDDRC_SAW_FLUSH_MAX_Pos)))
#define MPDDRC_SAW_INCR_THRESH_Pos 8
#define MPDDRC_SAW_INCR_THRESH_Msk (0x3fu << MPDDRC_SAW_INCR_THRESH_Pos) /**< \brief (MPDDRC_SAW[4]) Incremental Threshold */
#define   MPDDRC_SAW_INCR_THRESH_1_WORD (0x1u << 8) /**< \brief (MPDDRC_SAW[4]) 1 word/dword max */
#define   MPDDRC_SAW_INCR_THRESH_2_WORDS (0x2u << 8) /**< \brief (MPDDRC_SAW[4]) 2 word/dword max */
#define   MPDDRC_SAW_INCR_THRESH_4_WORDS (0x4u << 8) /**< \brief (MPDDRC_SAW[4]) 4 word/dword max */
#define   MPDDRC_SAW_INCR_THRESH_8_WORDS (0x8u << 8) /**< \brief (MPDDRC_SAW[4]) 8 word/dword max */
#define   MPDDRC_SAW_INCR_THRESH_16_WORDS (0x10u << 8) /**< \brief (MPDDRC_SAW[4]) 16 word/dword max */
#define   MPDDRC_SAW_INCR_THRESH_32_WORDS (0x20u << 8) /**< \brief (MPDDRC_SAW[4]) 32 word/dword max */
#define MPDDRC_SAW_PFCH_THRESH_Pos 16
#define MPDDRC_SAW_PFCH_THRESH_Msk (0x3fu << MPDDRC_SAW_PFCH_THRESH_Pos) /**< \brief (MPDDRC_SAW[4]) Prefetch Threshold */
#define   MPDDRC_SAW_PFCH_THRESH_2_WORDS (0x2u << 16) /**< \brief (MPDDRC_SAW[4]) 2 word/dword max */
#define   MPDDRC_SAW_PFCH_THRESH_4_WORDS (0x4u << 16) /**< \brief (MPDDRC_SAW[4]) 4 word/dword max */
#define   MPDDRC_SAW_PFCH_THRESH_8_WORDS (0x8u << 16) /**< \brief (MPDDRC_SAW[4]) 8 word/dword max */
/* -------- MPDDRC_WPMR : (MPDDRC Offset: 0xE4) MPDDRC Write Protect Control Register -------- */
#define MPDDRC_WPMR_WPEN (0x1u << 0) /**< \brief (MPDDRC_WPMR) Write Protection Enable */
#define MPDDRC_WPMR_WPKEY_Pos 8
#define MPDDRC_WPMR_WPKEY_Msk (0xffffffu << MPDDRC_WPMR_WPKEY_Pos) /**< \brief (MPDDRC_WPMR) Write Protection KEY */
#define   MPDDRC_WPMR_WPKEY_PASSWD (0x444452u << 8) /**< \brief (MPDDRC_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0. */
/* -------- MPDDRC_WPSR : (MPDDRC Offset: 0xE8) MPDDRC Write Protect Status Register -------- */
#define MPDDRC_WPSR_WPVS (0x1u << 0) /**< \brief (MPDDRC_WPSR) Write Protection Enable */
#define MPDDRC_WPSR_WPVSRC_Pos 8
#define MPDDRC_WPSR_WPVSRC_Msk (0xffffu << MPDDRC_WPSR_WPVSRC_Pos) /**< \brief (MPDDRC_WPSR) Write Protection Violation Source */
/* -------- MPDDRC_DLL_OS : (MPDDRC Offset: 0x100) MPDDRC DLL Offset Selection Register -------- */
#define MPDDRC_DLL_OS_SELOFF (0x1u << 0) /**< \brief (MPDDRC_DLL_OS) Offset Selection */
/* -------- MPDDRC_DLL_MO : (MPDDRC Offset: 0x104) MPDDRC DLL MASTER Offset Register -------- */
#define MPDDRC_DLL_MO_M0OFF_Pos 0
#define MPDDRC_DLL_MO_M0OFF_Msk (0xffu << MPDDRC_DLL_MO_M0OFF_Pos) /**< \brief (MPDDRC_DLL_MO) Master 0 Delay Line Offset */
#define MPDDRC_DLL_MO_M0OFF(value) ((MPDDRC_DLL_MO_M0OFF_Msk & ((value) << MPDDRC_DLL_MO_M0OFF_Pos)))
/* -------- MPDDRC_DLL_SO0 : (MPDDRC Offset: 0x108) MPDDRC DLL SLAVE Offset 0 Register -------- */
#define MPDDRC_DLL_SO0_S0OFF_Pos 0
#define MPDDRC_DLL_SO0_S0OFF_Msk (0xffu << MPDDRC_DLL_SO0_S0OFF_Pos) /**< \brief (MPDDRC_DLL_SO0) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO0_S0OFF(value) ((MPDDRC_DLL_SO0_S0OFF_Msk & ((value) << MPDDRC_DLL_SO0_S0OFF_Pos)))
#define MPDDRC_DLL_SO0_S1OFF_Pos 8
#define MPDDRC_DLL_SO0_S1OFF_Msk (0xffu << MPDDRC_DLL_SO0_S1OFF_Pos) /**< \brief (MPDDRC_DLL_SO0) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO0_S1OFF(value) ((MPDDRC_DLL_SO0_S1OFF_Msk & ((value) << MPDDRC_DLL_SO0_S1OFF_Pos)))
#define MPDDRC_DLL_SO0_S2OFF_Pos 16
#define MPDDRC_DLL_SO0_S2OFF_Msk (0xffu << MPDDRC_DLL_SO0_S2OFF_Pos) /**< \brief (MPDDRC_DLL_SO0) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO0_S2OFF(value) ((MPDDRC_DLL_SO0_S2OFF_Msk & ((value) << MPDDRC_DLL_SO0_S2OFF_Pos)))
#define MPDDRC_DLL_SO0_S3OFF_Pos 24
#define MPDDRC_DLL_SO0_S3OFF_Msk (0xffu << MPDDRC_DLL_SO0_S3OFF_Pos) /**< \brief (MPDDRC_DLL_SO0) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO0_S3OFF(value) ((MPDDRC_DLL_SO0_S3OFF_Msk & ((value) << MPDDRC_DLL_SO0_S3OFF_Pos)))
/* -------- MPDDRC_DLL_SO1 : (MPDDRC Offset: 0x10C) MPDDRC DLL SLAVE Offset 1 Register -------- */
#define MPDDRC_DLL_SO1_S4OFF_Pos 0
#define MPDDRC_DLL_SO1_S4OFF_Msk (0xffu << MPDDRC_DLL_SO1_S4OFF_Pos) /**< \brief (MPDDRC_DLL_SO1) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO1_S4OFF(value) ((MPDDRC_DLL_SO1_S4OFF_Msk & ((value) << MPDDRC_DLL_SO1_S4OFF_Pos)))
#define MPDDRC_DLL_SO1_S5OFF_Pos 8
#define MPDDRC_DLL_SO1_S5OFF_Msk (0xffu << MPDDRC_DLL_SO1_S5OFF_Pos) /**< \brief (MPDDRC_DLL_SO1) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO1_S5OFF(value) ((MPDDRC_DLL_SO1_S5OFF_Msk & ((value) << MPDDRC_DLL_SO1_S5OFF_Pos)))
#define MPDDRC_DLL_SO1_S6OFF_Pos 16
#define MPDDRC_DLL_SO1_S6OFF_Msk (0xffu << MPDDRC_DLL_SO1_S6OFF_Pos) /**< \brief (MPDDRC_DLL_SO1) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO1_S6OFF(value) ((MPDDRC_DLL_SO1_S6OFF_Msk & ((value) << MPDDRC_DLL_SO1_S6OFF_Pos)))
#define MPDDRC_DLL_SO1_S7OFF_Pos 24
#define MPDDRC_DLL_SO1_S7OFF_Msk (0xffu << MPDDRC_DLL_SO1_S7OFF_Pos) /**< \brief (MPDDRC_DLL_SO1) SLAVEx Delay Line Offset */
#define MPDDRC_DLL_SO1_S7OFF(value) ((MPDDRC_DLL_SO1_S7OFF_Msk & ((value) << MPDDRC_DLL_SO1_S7OFF_Pos)))
/* -------- MPDDRC_DLL_WRO : (MPDDRC Offset: 0x110) MPDDRC DLL CLKWR Offset Register -------- */
#define MPDDRC_DLL_WRO_WR0OFF_Pos 0
#define MPDDRC_DLL_WRO_WR0OFF_Msk (0xffu << MPDDRC_DLL_WRO_WR0OFF_Pos) /**< \brief (MPDDRC_DLL_WRO) CLKWRx Delay Line Offset */
#define MPDDRC_DLL_WRO_WR0OFF(value) ((MPDDRC_DLL_WRO_WR0OFF_Msk & ((value) << MPDDRC_DLL_WRO_WR0OFF_Pos)))
#define MPDDRC_DLL_WRO_WR1OFF_Pos 8
#define MPDDRC_DLL_WRO_WR1OFF_Msk (0xffu << MPDDRC_DLL_WRO_WR1OFF_Pos) /**< \brief (MPDDRC_DLL_WRO) CLKWRx Delay Line Offset */
#define MPDDRC_DLL_WRO_WR1OFF(value) ((MPDDRC_DLL_WRO_WR1OFF_Msk & ((value) << MPDDRC_DLL_WRO_WR1OFF_Pos)))
#define MPDDRC_DLL_WRO_WR2OFF_Pos 16
#define MPDDRC_DLL_WRO_WR2OFF_Msk (0xffu << MPDDRC_DLL_WRO_WR2OFF_Pos) /**< \brief (MPDDRC_DLL_WRO) CLKWRx Delay Line Offset */
#define MPDDRC_DLL_WRO_WR2OFF(value) ((MPDDRC_DLL_WRO_WR2OFF_Msk & ((value) << MPDDRC_DLL_WRO_WR2OFF_Pos)))
#define MPDDRC_DLL_WRO_WR3OFF_Pos 24
#define MPDDRC_DLL_WRO_WR3OFF_Msk (0xffu << MPDDRC_DLL_WRO_WR3OFF_Pos) /**< \brief (MPDDRC_DLL_WRO) CLKWRx Delay Line Offset */
#define MPDDRC_DLL_WRO_WR3OFF(value) ((MPDDRC_DLL_WRO_WR3OFF_Msk & ((value) << MPDDRC_DLL_WRO_WR3OFF_Pos)))
/* -------- MPDDRC_DLL_ADO : (MPDDRC Offset: 0x114) MPDDRC DLL CLKAD Offset Register -------- */
#define MPDDRC_DLL_ADO_ADOFF_Pos 0
#define MPDDRC_DLL_ADO_ADOFF_Msk (0xffu << MPDDRC_DLL_ADO_ADOFF_Pos) /**< \brief (MPDDRC_DLL_ADO) CLKAD Delay Line Offset */
#define MPDDRC_DLL_ADO_ADOFF(value) ((MPDDRC_DLL_ADO_ADOFF_Msk & ((value) << MPDDRC_DLL_ADO_ADOFF_Pos)))
/* -------- MPDDRC_DLL_SM[4] : (MPDDRC Offset: 0x118) MPDDRC DLL Status MASTER0 Register -------- */
#define MPDDRC_DLL_SM_MDINC (0x1u << 0) /**< \brief (MPDDRC_DLL_SM[4]) MASTERx Delay Increment */
#define MPDDRC_DLL_SM_MDDEC (0x1u << 1) /**< \brief (MPDDRC_DLL_SM[4]) MASTERx Delay Decrement */
#define MPDDRC_DLL_SM_MDOVF (0x1u << 2) /**< \brief (MPDDRC_DLL_SM[4]) MASTERx Delay Overflow Flag */
#define MPDDRC_DLL_SM_MDLVAL_Pos 8
#define MPDDRC_DLL_SM_MDLVAL_Msk (0xffu << MPDDRC_DLL_SM_MDLVAL_Pos) /**< \brief (MPDDRC_DLL_SM[4]) MASTERx Delay Lock Value */
#define MPDDRC_DLL_SM_MDCNT_Pos 20
#define MPDDRC_DLL_SM_MDCNT_Msk (0xffu << MPDDRC_DLL_SM_MDCNT_Pos) /**< \brief (MPDDRC_DLL_SM[4]) MASTERx Delay Counter Value */
/* -------- MPDDRC_DLL_SSL[8] : (MPDDRC Offset: 0x128) MPDDRC DLL Status SLAVE0 Register -------- */
#define MPDDRC_DLL_SSL_SDCOVF (0x1u << 0) /**< \brief (MPDDRC_DLL_SSL[8]) SLAVEx Delay Correction Overflow Flag */
#define MPDDRC_DLL_SSL_SDCUDF (0x1u << 1) /**< \brief (MPDDRC_DLL_SSL[8]) SLAVEx Delay Correction Underflow Flag */
#define MPDDRC_DLL_SSL_SDERF (0x1u << 2) /**< \brief (MPDDRC_DLL_SSL[8]) SLAVEx Delay Correction Error Flag */
#define MPDDRC_DLL_SSL_SDCNT_Pos 8
#define MPDDRC_DLL_SSL_SDCNT_Msk (0xffu << MPDDRC_DLL_SSL_SDCNT_Pos) /**< \brief (MPDDRC_DLL_SSL[8]) SLAVEx Delay Counter Value */
#define MPDDRC_DLL_SSL_SDCVAL_Pos 20
#define MPDDRC_DLL_SSL_SDCVAL_Msk (0xffu << MPDDRC_DLL_SSL_SDCVAL_Pos) /**< \brief (MPDDRC_DLL_SSL[8]) SLAVEx Delay Correction Value */
/* -------- MPDDRC_DLL_SWR[4] : (MPDDRC Offset: 0x148) MPDDRC DLL Status CLKWR0 Register -------- */
#define MPDDRC_DLL_SWR_WRDCNT_Pos 0
#define MPDDRC_DLL_SWR_WRDCNT_Msk (0xffu << MPDDRC_DLL_SWR_WRDCNT_Pos) /**< \brief (MPDDRC_DLL_SWR[4]) CLKWRx Delay Counter Value */
/* -------- MPDDRC_DLL_SAD : (MPDDRC Offset: 0x158) MPDDRC DLL Status CLKAD Register -------- */
#define MPDDRC_DLL_SAD_ADDCNT_Pos 0
#define MPDDRC_DLL_SAD_ADDCNT_Msk (0xffu << MPDDRC_DLL_SAD_ADDCNT_Pos) /**< \brief (MPDDRC_DLL_SAD) CLKAD Delay Counter Value */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Parallel Input/Output Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_PIO Parallel Input/Output Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Pio hardware registers */
typedef struct {
  __O  uint32_t PIO_PER;       /**< \brief (Pio Offset: 0x0000) PIO Enable Register */
  __O  uint32_t PIO_PDR;       /**< \brief (Pio Offset: 0x0004) PIO Disable Register */
  __I  uint32_t PIO_PSR;       /**< \brief (Pio Offset: 0x0008) PIO Status Register */
  __IO uint32_t PIO_ISLR;      /**< \brief (Pio Offset: 0x000C) PIO Interrupt Security Level Register */
  __O  uint32_t PIO_OER;       /**< \brief (Pio Offset: 0x0010) Output Enable Register */
  __O  uint32_t PIO_ODR;       /**< \brief (Pio Offset: 0x0014) Output Disable Register */
  __I  uint32_t PIO_OSR;       /**< \brief (Pio Offset: 0x0018) Output Status Register */
  __I  uint32_t Reserved1[1];
  __O  uint32_t PIO_IFER;      /**< \brief (Pio Offset: 0x0020) Glitch Input Filter Enable Register */
  __O  uint32_t PIO_IFDR;      /**< \brief (Pio Offset: 0x0024) Glitch Input Filter Disable Register */
  __I  uint32_t PIO_IFSR;      /**< \brief (Pio Offset: 0x0028) Glitch Input Filter Status Register */
  __I  uint32_t Reserved2[1];
  __O  uint32_t PIO_SODR;      /**< \brief (Pio Offset: 0x0030) Set Output Data Register */
  __O  uint32_t PIO_CODR;      /**< \brief (Pio Offset: 0x0034) Clear Output Data Register */
  __IO uint32_t PIO_ODSR;      /**< \brief (Pio Offset: 0x0038) Output Data Status Register */
  __I  uint32_t PIO_PDSR;      /**< \brief (Pio Offset: 0x003C) Pin Data Status Register */
  __O  uint32_t PIO_IER;       /**< \brief (Pio Offset: 0x0040) Interrupt Enable Register */
  __O  uint32_t PIO_IDR;       /**< \brief (Pio Offset: 0x0044) Interrupt Disable Register */
  __I  uint32_t PIO_IMR;       /**< \brief (Pio Offset: 0x0048) Interrupt Mask Register */
  __I  uint32_t PIO_ISR;       /**< \brief (Pio Offset: 0x004C) Interrupt Status Register */
  __O  uint32_t PIO_MDER;      /**< \brief (Pio Offset: 0x0050) Multi-driver Enable Register */
  __O  uint32_t PIO_MDDR;      /**< \brief (Pio Offset: 0x0054) Multi-driver Disable Register */
  __I  uint32_t PIO_MDSR;      /**< \brief (Pio Offset: 0x0058) Multi-driver Status Register */
  __I  uint32_t Reserved3[1];
  __O  uint32_t PIO_PUDR;      /**< \brief (Pio Offset: 0x0060) Pull-up Disable Register */
  __O  uint32_t PIO_PUER;      /**< \brief (Pio Offset: 0x0064) Pull-up Enable Register */
  __I  uint32_t PIO_PUSR;      /**< \brief (Pio Offset: 0x0068) Pad Pull-up Status Register */
  __I  uint32_t Reserved4[1];
  __IO uint32_t PIO_ABCDSR[2]; /**< \brief (Pio Offset: 0x0070) Peripheral Select Register */
  __I  uint32_t Reserved5[2];
  __O  uint32_t PIO_IFSCDR;    /**< \brief (Pio Offset: 0x0080) Input Filter Slow Clock Disable Register */
  __O  uint32_t PIO_IFSCER;    /**< \brief (Pio Offset: 0x0084) Input Filter Slow Clock Enable Register */
  __I  uint32_t PIO_IFSCSR;    /**< \brief (Pio Offset: 0x0088) Input Filter Slow Clock Status Register */
  __IO uint32_t PIO_SCDR;      /**< \brief (Pio Offset: 0x008C) Slow Clock Divider Debouncing Register */
  __O  uint32_t PIO_PPDDR;     /**< \brief (Pio Offset: 0x0090) Pad Pull-down Disable Register */
  __O  uint32_t PIO_PPDER;     /**< \brief (Pio Offset: 0x0094) Pad Pull-down Enable Register */
  __I  uint32_t PIO_PPDSR;     /**< \brief (Pio Offset: 0x0098) Pad Pull-down Status Register */
  __I  uint32_t Reserved6[1];
  __O  uint32_t PIO_OWER;      /**< \brief (Pio Offset: 0x00A0) Output Write Enable */
  __O  uint32_t PIO_OWDR;      /**< \brief (Pio Offset: 0x00A4) Output Write Disable */
  __I  uint32_t PIO_OWSR;      /**< \brief (Pio Offset: 0x00A8) Output Write Status Register */
  __I  uint32_t Reserved7[1];
  __O  uint32_t PIO_AIMER;     /**< \brief (Pio Offset: 0x00B0) Additional Interrupt Modes Enable Register */
  __O  uint32_t PIO_AIMDR;     /**< \brief (Pio Offset: 0x00B4) Additional Interrupt Modes Disables Register */
  __I  uint32_t PIO_AIMMR;     /**< \brief (Pio Offset: 0x00B8) Additional Interrupt Modes Mask Register */
  __I  uint32_t Reserved8[1];
  __O  uint32_t PIO_ESR;       /**< \brief (Pio Offset: 0x00C0) Edge Select Register */
  __O  uint32_t PIO_LSR;       /**< \brief (Pio Offset: 0x00C4) Level Select Register */
  __I  uint32_t PIO_ELSR;      /**< \brief (Pio Offset: 0x00C8) Edge/Level Status Register */
  __I  uint32_t Reserved9[1];
  __O  uint32_t PIO_FELLSR;    /**< \brief (Pio Offset: 0x00D0) Falling Edge/Low Level Select Register */
  __O  uint32_t PIO_REHLSR;    /**< \brief (Pio Offset: 0x00D4) Rising Edge/ High Level Select Register */
  __I  uint32_t PIO_FRLHSR;    /**< \brief (Pio Offset: 0x00D8) Fall/Rise - Low/High Status Register */
  __I  uint32_t Reserved10[2];
  __IO uint32_t PIO_WPMR;      /**< \brief (Pio Offset: 0x00E4) Write Protect Mode Register */
  __I  uint32_t PIO_WPSR;      /**< \brief (Pio Offset: 0x00E8) Write Protect Status Register */
  __I  uint32_t Reserved11[5];
  __IO uint32_t PIO_SCHMITT;   /**< \brief (Pio Offset: 0x0100) Schmitt Trigger Register */
  __I  uint32_t Reserved12[5];
  __IO uint32_t PIO_DRIVER1;   /**< \brief (Pio Offset: 0x0118) I/O Drive Register 1 */
  __IO uint32_t PIO_DRIVER2;   /**< \brief (Pio Offset: 0x011C) I/O Drive Register 2 */
} Pio;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- PIO_PER : (PIO Offset: 0x0000) PIO Enable Register -------- */
#define PIO_PER_P0 (0x1u << 0) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P1 (0x1u << 1) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P2 (0x1u << 2) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P3 (0x1u << 3) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P4 (0x1u << 4) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P5 (0x1u << 5) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P6 (0x1u << 6) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P7 (0x1u << 7) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P8 (0x1u << 8) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P9 (0x1u << 9) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P10 (0x1u << 10) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P11 (0x1u << 11) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P12 (0x1u << 12) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P13 (0x1u << 13) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P14 (0x1u << 14) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P15 (0x1u << 15) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P16 (0x1u << 16) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P17 (0x1u << 17) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P18 (0x1u << 18) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P19 (0x1u << 19) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P20 (0x1u << 20) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P21 (0x1u << 21) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P22 (0x1u << 22) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P23 (0x1u << 23) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P24 (0x1u << 24) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P25 (0x1u << 25) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P26 (0x1u << 26) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P27 (0x1u << 27) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P28 (0x1u << 28) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P29 (0x1u << 29) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P30 (0x1u << 30) /**< \brief (PIO_PER) PIO Enable */
#define PIO_PER_P31 (0x1u << 31) /**< \brief (PIO_PER) PIO Enable */
/* -------- PIO_PDR : (PIO Offset: 0x0004) PIO Disable Register -------- */
#define PIO_PDR_P0 (0x1u << 0) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P1 (0x1u << 1) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P2 (0x1u << 2) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P3 (0x1u << 3) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P4 (0x1u << 4) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P5 (0x1u << 5) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P6 (0x1u << 6) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P7 (0x1u << 7) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P8 (0x1u << 8) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P9 (0x1u << 9) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P10 (0x1u << 10) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P11 (0x1u << 11) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P12 (0x1u << 12) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P13 (0x1u << 13) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P14 (0x1u << 14) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P15 (0x1u << 15) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P16 (0x1u << 16) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P17 (0x1u << 17) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P18 (0x1u << 18) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P19 (0x1u << 19) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P20 (0x1u << 20) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P21 (0x1u << 21) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P22 (0x1u << 22) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P23 (0x1u << 23) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P24 (0x1u << 24) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P25 (0x1u << 25) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P26 (0x1u << 26) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P27 (0x1u << 27) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P28 (0x1u << 28) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P29 (0x1u << 29) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P30 (0x1u << 30) /**< \brief (PIO_PDR) PIO Disable */
#define PIO_PDR_P31 (0x1u << 31) /**< \brief (PIO_PDR) PIO Disable */
/* -------- PIO_PSR : (PIO Offset: 0x0008) PIO Status Register -------- */
#define PIO_PSR_P0 (0x1u << 0) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P1 (0x1u << 1) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P2 (0x1u << 2) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P3 (0x1u << 3) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P4 (0x1u << 4) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P5 (0x1u << 5) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P6 (0x1u << 6) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P7 (0x1u << 7) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P8 (0x1u << 8) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P9 (0x1u << 9) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P10 (0x1u << 10) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P11 (0x1u << 11) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P12 (0x1u << 12) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P13 (0x1u << 13) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P14 (0x1u << 14) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P15 (0x1u << 15) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P16 (0x1u << 16) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P17 (0x1u << 17) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P18 (0x1u << 18) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P19 (0x1u << 19) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P20 (0x1u << 20) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P21 (0x1u << 21) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P22 (0x1u << 22) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P23 (0x1u << 23) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P24 (0x1u << 24) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P25 (0x1u << 25) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P26 (0x1u << 26) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P27 (0x1u << 27) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P28 (0x1u << 28) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P29 (0x1u << 29) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P30 (0x1u << 30) /**< \brief (PIO_PSR) PIO Status */
#define PIO_PSR_P31 (0x1u << 31) /**< \brief (PIO_PSR) PIO Status */
/* -------- PIO_ISLR : (PIO Offset: 0x000C) PIO Interrupt Security Level Register -------- */
#define PIO_ISLR_P0 (0x1u << 0) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P1 (0x1u << 1) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P2 (0x1u << 2) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P3 (0x1u << 3) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P4 (0x1u << 4) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P5 (0x1u << 5) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P6 (0x1u << 6) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P7 (0x1u << 7) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P8 (0x1u << 8) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P9 (0x1u << 9) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P10 (0x1u << 10) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P11 (0x1u << 11) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P12 (0x1u << 12) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P13 (0x1u << 13) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P14 (0x1u << 14) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P15 (0x1u << 15) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P16 (0x1u << 16) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P17 (0x1u << 17) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P18 (0x1u << 18) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P19 (0x1u << 19) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P20 (0x1u << 20) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P21 (0x1u << 21) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P22 (0x1u << 22) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P23 (0x1u << 23) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P24 (0x1u << 24) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P25 (0x1u << 25) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P26 (0x1u << 26) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P27 (0x1u << 27) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P28 (0x1u << 28) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P29 (0x1u << 29) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P30 (0x1u << 30) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
#define PIO_ISLR_P31 (0x1u << 31) /**< \brief (PIO_ISLR) PIO Interrupt Security Level */
/* -------- PIO_OER : (PIO Offset: 0x0010) Output Enable Register -------- */
#define PIO_OER_P0 (0x1u << 0) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P1 (0x1u << 1) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P2 (0x1u << 2) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P3 (0x1u << 3) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P4 (0x1u << 4) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P5 (0x1u << 5) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P6 (0x1u << 6) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P7 (0x1u << 7) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P8 (0x1u << 8) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P9 (0x1u << 9) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P10 (0x1u << 10) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P11 (0x1u << 11) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P12 (0x1u << 12) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P13 (0x1u << 13) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P14 (0x1u << 14) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P15 (0x1u << 15) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P16 (0x1u << 16) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P17 (0x1u << 17) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P18 (0x1u << 18) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P19 (0x1u << 19) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P20 (0x1u << 20) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P21 (0x1u << 21) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P22 (0x1u << 22) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P23 (0x1u << 23) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P24 (0x1u << 24) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P25 (0x1u << 25) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P26 (0x1u << 26) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P27 (0x1u << 27) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P28 (0x1u << 28) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P29 (0x1u << 29) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P30 (0x1u << 30) /**< \brief (PIO_OER) Output Enable */
#define PIO_OER_P31 (0x1u << 31) /**< \brief (PIO_OER) Output Enable */
/* -------- PIO_ODR : (PIO Offset: 0x0014) Output Disable Register -------- */
#define PIO_ODR_P0 (0x1u << 0) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P1 (0x1u << 1) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P2 (0x1u << 2) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P3 (0x1u << 3) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P4 (0x1u << 4) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P5 (0x1u << 5) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P6 (0x1u << 6) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P7 (0x1u << 7) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P8 (0x1u << 8) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P9 (0x1u << 9) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P10 (0x1u << 10) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P11 (0x1u << 11) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P12 (0x1u << 12) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P13 (0x1u << 13) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P14 (0x1u << 14) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P15 (0x1u << 15) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P16 (0x1u << 16) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P17 (0x1u << 17) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P18 (0x1u << 18) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P19 (0x1u << 19) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P20 (0x1u << 20) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P21 (0x1u << 21) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P22 (0x1u << 22) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P23 (0x1u << 23) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P24 (0x1u << 24) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P25 (0x1u << 25) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P26 (0x1u << 26) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P27 (0x1u << 27) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P28 (0x1u << 28) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P29 (0x1u << 29) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P30 (0x1u << 30) /**< \brief (PIO_ODR) Output Disable */
#define PIO_ODR_P31 (0x1u << 31) /**< \brief (PIO_ODR) Output Disable */
/* -------- PIO_OSR : (PIO Offset: 0x0018) Output Status Register -------- */
#define PIO_OSR_P0 (0x1u << 0) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P1 (0x1u << 1) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P2 (0x1u << 2) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P3 (0x1u << 3) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P4 (0x1u << 4) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P5 (0x1u << 5) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P6 (0x1u << 6) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P7 (0x1u << 7) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P8 (0x1u << 8) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P9 (0x1u << 9) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P10 (0x1u << 10) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P11 (0x1u << 11) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P12 (0x1u << 12) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P13 (0x1u << 13) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P14 (0x1u << 14) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P15 (0x1u << 15) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P16 (0x1u << 16) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P17 (0x1u << 17) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P18 (0x1u << 18) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P19 (0x1u << 19) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P20 (0x1u << 20) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P21 (0x1u << 21) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P22 (0x1u << 22) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P23 (0x1u << 23) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P24 (0x1u << 24) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P25 (0x1u << 25) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P26 (0x1u << 26) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P27 (0x1u << 27) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P28 (0x1u << 28) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P29 (0x1u << 29) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P30 (0x1u << 30) /**< \brief (PIO_OSR) Output Status */
#define PIO_OSR_P31 (0x1u << 31) /**< \brief (PIO_OSR) Output Status */
/* -------- PIO_IFER : (PIO Offset: 0x0020) Glitch Input Filter Enable Register -------- */
#define PIO_IFER_P0 (0x1u << 0) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P1 (0x1u << 1) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P2 (0x1u << 2) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P3 (0x1u << 3) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P4 (0x1u << 4) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P5 (0x1u << 5) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P6 (0x1u << 6) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P7 (0x1u << 7) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P8 (0x1u << 8) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P9 (0x1u << 9) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P10 (0x1u << 10) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P11 (0x1u << 11) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P12 (0x1u << 12) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P13 (0x1u << 13) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P14 (0x1u << 14) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P15 (0x1u << 15) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P16 (0x1u << 16) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P17 (0x1u << 17) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P18 (0x1u << 18) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P19 (0x1u << 19) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P20 (0x1u << 20) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P21 (0x1u << 21) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P22 (0x1u << 22) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P23 (0x1u << 23) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P24 (0x1u << 24) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P25 (0x1u << 25) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P26 (0x1u << 26) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P27 (0x1u << 27) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P28 (0x1u << 28) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P29 (0x1u << 29) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P30 (0x1u << 30) /**< \brief (PIO_IFER) Input Filter Enable */
#define PIO_IFER_P31 (0x1u << 31) /**< \brief (PIO_IFER) Input Filter Enable */
/* -------- PIO_IFDR : (PIO Offset: 0x0024) Glitch Input Filter Disable Register -------- */
#define PIO_IFDR_P0 (0x1u << 0) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P1 (0x1u << 1) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P2 (0x1u << 2) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P3 (0x1u << 3) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P4 (0x1u << 4) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P5 (0x1u << 5) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P6 (0x1u << 6) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P7 (0x1u << 7) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P8 (0x1u << 8) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P9 (0x1u << 9) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P10 (0x1u << 10) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P11 (0x1u << 11) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P12 (0x1u << 12) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P13 (0x1u << 13) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P14 (0x1u << 14) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P15 (0x1u << 15) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P16 (0x1u << 16) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P17 (0x1u << 17) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P18 (0x1u << 18) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P19 (0x1u << 19) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P20 (0x1u << 20) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P21 (0x1u << 21) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P22 (0x1u << 22) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P23 (0x1u << 23) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P24 (0x1u << 24) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P25 (0x1u << 25) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P26 (0x1u << 26) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P27 (0x1u << 27) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P28 (0x1u << 28) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P29 (0x1u << 29) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P30 (0x1u << 30) /**< \brief (PIO_IFDR) Input Filter Disable */
#define PIO_IFDR_P31 (0x1u << 31) /**< \brief (PIO_IFDR) Input Filter Disable */
/* -------- PIO_IFSR : (PIO Offset: 0x0028) Glitch Input Filter Status Register -------- */
#define PIO_IFSR_P0 (0x1u << 0) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P1 (0x1u << 1) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P2 (0x1u << 2) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P3 (0x1u << 3) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P4 (0x1u << 4) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P5 (0x1u << 5) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P6 (0x1u << 6) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P7 (0x1u << 7) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P8 (0x1u << 8) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P9 (0x1u << 9) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P10 (0x1u << 10) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P11 (0x1u << 11) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P12 (0x1u << 12) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P13 (0x1u << 13) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P14 (0x1u << 14) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P15 (0x1u << 15) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P16 (0x1u << 16) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P17 (0x1u << 17) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P18 (0x1u << 18) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P19 (0x1u << 19) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P20 (0x1u << 20) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P21 (0x1u << 21) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P22 (0x1u << 22) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P23 (0x1u << 23) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P24 (0x1u << 24) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P25 (0x1u << 25) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P26 (0x1u << 26) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P27 (0x1u << 27) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P28 (0x1u << 28) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P29 (0x1u << 29) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P30 (0x1u << 30) /**< \brief (PIO_IFSR) Input Filer Status */
#define PIO_IFSR_P31 (0x1u << 31) /**< \brief (PIO_IFSR) Input Filer Status */
/* -------- PIO_SODR : (PIO Offset: 0x0030) Set Output Data Register -------- */
#define PIO_SODR_P0 (0x1u << 0) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P1 (0x1u << 1) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P2 (0x1u << 2) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P3 (0x1u << 3) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P4 (0x1u << 4) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P5 (0x1u << 5) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P6 (0x1u << 6) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P7 (0x1u << 7) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P8 (0x1u << 8) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P9 (0x1u << 9) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P10 (0x1u << 10) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P11 (0x1u << 11) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P12 (0x1u << 12) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P13 (0x1u << 13) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P14 (0x1u << 14) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P15 (0x1u << 15) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P16 (0x1u << 16) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P17 (0x1u << 17) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P18 (0x1u << 18) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P19 (0x1u << 19) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P20 (0x1u << 20) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P21 (0x1u << 21) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P22 (0x1u << 22) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P23 (0x1u << 23) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P24 (0x1u << 24) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P25 (0x1u << 25) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P26 (0x1u << 26) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P27 (0x1u << 27) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P28 (0x1u << 28) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P29 (0x1u << 29) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P30 (0x1u << 30) /**< \brief (PIO_SODR) Set Output Data */
#define PIO_SODR_P31 (0x1u << 31) /**< \brief (PIO_SODR) Set Output Data */
/* -------- PIO_CODR : (PIO Offset: 0x0034) Clear Output Data Register -------- */
#define PIO_CODR_P0 (0x1u << 0) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P1 (0x1u << 1) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P2 (0x1u << 2) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P3 (0x1u << 3) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P4 (0x1u << 4) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P5 (0x1u << 5) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P6 (0x1u << 6) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P7 (0x1u << 7) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P8 (0x1u << 8) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P9 (0x1u << 9) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P10 (0x1u << 10) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P11 (0x1u << 11) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P12 (0x1u << 12) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P13 (0x1u << 13) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P14 (0x1u << 14) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P15 (0x1u << 15) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P16 (0x1u << 16) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P17 (0x1u << 17) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P18 (0x1u << 18) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P19 (0x1u << 19) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P20 (0x1u << 20) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P21 (0x1u << 21) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P22 (0x1u << 22) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P23 (0x1u << 23) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P24 (0x1u << 24) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P25 (0x1u << 25) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P26 (0x1u << 26) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P27 (0x1u << 27) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P28 (0x1u << 28) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P29 (0x1u << 29) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P30 (0x1u << 30) /**< \brief (PIO_CODR) Clear Output Data */
#define PIO_CODR_P31 (0x1u << 31) /**< \brief (PIO_CODR) Clear Output Data */
/* -------- PIO_ODSR : (PIO Offset: 0x0038) Output Data Status Register -------- */
#define PIO_ODSR_P0 (0x1u << 0) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P1 (0x1u << 1) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P2 (0x1u << 2) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P3 (0x1u << 3) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P4 (0x1u << 4) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P5 (0x1u << 5) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P6 (0x1u << 6) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P7 (0x1u << 7) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P8 (0x1u << 8) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P9 (0x1u << 9) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P10 (0x1u << 10) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P11 (0x1u << 11) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P12 (0x1u << 12) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P13 (0x1u << 13) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P14 (0x1u << 14) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P15 (0x1u << 15) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P16 (0x1u << 16) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P17 (0x1u << 17) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P18 (0x1u << 18) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P19 (0x1u << 19) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P20 (0x1u << 20) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P21 (0x1u << 21) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P22 (0x1u << 22) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P23 (0x1u << 23) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P24 (0x1u << 24) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P25 (0x1u << 25) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P26 (0x1u << 26) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P27 (0x1u << 27) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P28 (0x1u << 28) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P29 (0x1u << 29) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P30 (0x1u << 30) /**< \brief (PIO_ODSR) Output Data Status */
#define PIO_ODSR_P31 (0x1u << 31) /**< \brief (PIO_ODSR) Output Data Status */
/* -------- PIO_PDSR : (PIO Offset: 0x003C) Pin Data Status Register -------- */
#define PIO_PDSR_P0 (0x1u << 0) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P1 (0x1u << 1) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P2 (0x1u << 2) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P3 (0x1u << 3) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P4 (0x1u << 4) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P5 (0x1u << 5) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P6 (0x1u << 6) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P7 (0x1u << 7) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P8 (0x1u << 8) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P9 (0x1u << 9) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P10 (0x1u << 10) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P11 (0x1u << 11) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P12 (0x1u << 12) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P13 (0x1u << 13) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P14 (0x1u << 14) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P15 (0x1u << 15) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P16 (0x1u << 16) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P17 (0x1u << 17) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P18 (0x1u << 18) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P19 (0x1u << 19) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P20 (0x1u << 20) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P21 (0x1u << 21) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P22 (0x1u << 22) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P23 (0x1u << 23) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P24 (0x1u << 24) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P25 (0x1u << 25) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P26 (0x1u << 26) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P27 (0x1u << 27) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P28 (0x1u << 28) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P29 (0x1u << 29) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P30 (0x1u << 30) /**< \brief (PIO_PDSR) Output Data Status */
#define PIO_PDSR_P31 (0x1u << 31) /**< \brief (PIO_PDSR) Output Data Status */
/* -------- PIO_IER : (PIO Offset: 0x0040) Interrupt Enable Register -------- */
#define PIO_IER_P0 (0x1u << 0) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P1 (0x1u << 1) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P2 (0x1u << 2) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P3 (0x1u << 3) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P4 (0x1u << 4) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P5 (0x1u << 5) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P6 (0x1u << 6) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P7 (0x1u << 7) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P8 (0x1u << 8) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P9 (0x1u << 9) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P10 (0x1u << 10) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P11 (0x1u << 11) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P12 (0x1u << 12) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P13 (0x1u << 13) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P14 (0x1u << 14) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P15 (0x1u << 15) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P16 (0x1u << 16) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P17 (0x1u << 17) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P18 (0x1u << 18) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P19 (0x1u << 19) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P20 (0x1u << 20) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P21 (0x1u << 21) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P22 (0x1u << 22) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P23 (0x1u << 23) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P24 (0x1u << 24) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P25 (0x1u << 25) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P26 (0x1u << 26) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P27 (0x1u << 27) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P28 (0x1u << 28) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P29 (0x1u << 29) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P30 (0x1u << 30) /**< \brief (PIO_IER) Input Change Interrupt Enable */
#define PIO_IER_P31 (0x1u << 31) /**< \brief (PIO_IER) Input Change Interrupt Enable */
/* -------- PIO_IDR : (PIO Offset: 0x0044) Interrupt Disable Register -------- */
#define PIO_IDR_P0 (0x1u << 0) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P1 (0x1u << 1) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P2 (0x1u << 2) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P3 (0x1u << 3) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P4 (0x1u << 4) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P5 (0x1u << 5) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P6 (0x1u << 6) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P7 (0x1u << 7) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P8 (0x1u << 8) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P9 (0x1u << 9) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P10 (0x1u << 10) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P11 (0x1u << 11) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P12 (0x1u << 12) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P13 (0x1u << 13) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P14 (0x1u << 14) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P15 (0x1u << 15) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P16 (0x1u << 16) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P17 (0x1u << 17) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P18 (0x1u << 18) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P19 (0x1u << 19) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P20 (0x1u << 20) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P21 (0x1u << 21) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P22 (0x1u << 22) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P23 (0x1u << 23) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P24 (0x1u << 24) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P25 (0x1u << 25) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P26 (0x1u << 26) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P27 (0x1u << 27) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P28 (0x1u << 28) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P29 (0x1u << 29) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P30 (0x1u << 30) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
#define PIO_IDR_P31 (0x1u << 31) /**< \brief (PIO_IDR) Input Change Interrupt Disable */
/* -------- PIO_IMR : (PIO Offset: 0x0048) Interrupt Mask Register -------- */
#define PIO_IMR_P0 (0x1u << 0) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P1 (0x1u << 1) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P2 (0x1u << 2) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P3 (0x1u << 3) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P4 (0x1u << 4) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P5 (0x1u << 5) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P6 (0x1u << 6) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P7 (0x1u << 7) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P8 (0x1u << 8) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P9 (0x1u << 9) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P10 (0x1u << 10) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P11 (0x1u << 11) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P12 (0x1u << 12) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P13 (0x1u << 13) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P14 (0x1u << 14) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P15 (0x1u << 15) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P16 (0x1u << 16) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P17 (0x1u << 17) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P18 (0x1u << 18) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P19 (0x1u << 19) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P20 (0x1u << 20) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P21 (0x1u << 21) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P22 (0x1u << 22) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P23 (0x1u << 23) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P24 (0x1u << 24) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P25 (0x1u << 25) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P26 (0x1u << 26) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P27 (0x1u << 27) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P28 (0x1u << 28) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P29 (0x1u << 29) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P30 (0x1u << 30) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
#define PIO_IMR_P31 (0x1u << 31) /**< \brief (PIO_IMR) Input Change Interrupt Mask */
/* -------- PIO_ISR : (PIO Offset: 0x004C) Interrupt Status Register -------- */
#define PIO_ISR_P0 (0x1u << 0) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P1 (0x1u << 1) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P2 (0x1u << 2) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P3 (0x1u << 3) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P4 (0x1u << 4) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P5 (0x1u << 5) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P6 (0x1u << 6) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P7 (0x1u << 7) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P8 (0x1u << 8) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P9 (0x1u << 9) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P10 (0x1u << 10) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P11 (0x1u << 11) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P12 (0x1u << 12) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P13 (0x1u << 13) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P14 (0x1u << 14) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P15 (0x1u << 15) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P16 (0x1u << 16) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P17 (0x1u << 17) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P18 (0x1u << 18) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P19 (0x1u << 19) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P20 (0x1u << 20) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P21 (0x1u << 21) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P22 (0x1u << 22) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P23 (0x1u << 23) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P24 (0x1u << 24) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P25 (0x1u << 25) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P26 (0x1u << 26) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P27 (0x1u << 27) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P28 (0x1u << 28) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P29 (0x1u << 29) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P30 (0x1u << 30) /**< \brief (PIO_ISR) Input Change Interrupt Status */
#define PIO_ISR_P31 (0x1u << 31) /**< \brief (PIO_ISR) Input Change Interrupt Status */
/* -------- PIO_MDER : (PIO Offset: 0x0050) Multi-driver Enable Register -------- */
#define PIO_MDER_P0 (0x1u << 0) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P1 (0x1u << 1) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P2 (0x1u << 2) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P3 (0x1u << 3) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P4 (0x1u << 4) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P5 (0x1u << 5) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P6 (0x1u << 6) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P7 (0x1u << 7) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P8 (0x1u << 8) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P9 (0x1u << 9) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P10 (0x1u << 10) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P11 (0x1u << 11) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P12 (0x1u << 12) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P13 (0x1u << 13) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P14 (0x1u << 14) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P15 (0x1u << 15) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P16 (0x1u << 16) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P17 (0x1u << 17) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P18 (0x1u << 18) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P19 (0x1u << 19) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P20 (0x1u << 20) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P21 (0x1u << 21) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P22 (0x1u << 22) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P23 (0x1u << 23) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P24 (0x1u << 24) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P25 (0x1u << 25) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P26 (0x1u << 26) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P27 (0x1u << 27) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P28 (0x1u << 28) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P29 (0x1u << 29) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P30 (0x1u << 30) /**< \brief (PIO_MDER) Multi Drive Enable */
#define PIO_MDER_P31 (0x1u << 31) /**< \brief (PIO_MDER) Multi Drive Enable */
/* -------- PIO_MDDR : (PIO Offset: 0x0054) Multi-driver Disable Register -------- */
#define PIO_MDDR_P0 (0x1u << 0) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P1 (0x1u << 1) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P2 (0x1u << 2) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P3 (0x1u << 3) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P4 (0x1u << 4) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P5 (0x1u << 5) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P6 (0x1u << 6) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P7 (0x1u << 7) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P8 (0x1u << 8) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P9 (0x1u << 9) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P10 (0x1u << 10) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P11 (0x1u << 11) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P12 (0x1u << 12) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P13 (0x1u << 13) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P14 (0x1u << 14) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P15 (0x1u << 15) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P16 (0x1u << 16) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P17 (0x1u << 17) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P18 (0x1u << 18) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P19 (0x1u << 19) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P20 (0x1u << 20) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P21 (0x1u << 21) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P22 (0x1u << 22) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P23 (0x1u << 23) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P24 (0x1u << 24) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P25 (0x1u << 25) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P26 (0x1u << 26) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P27 (0x1u << 27) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P28 (0x1u << 28) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P29 (0x1u << 29) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P30 (0x1u << 30) /**< \brief (PIO_MDDR) Multi Drive Disable. */
#define PIO_MDDR_P31 (0x1u << 31) /**< \brief (PIO_MDDR) Multi Drive Disable. */
/* -------- PIO_MDSR : (PIO Offset: 0x0058) Multi-driver Status Register -------- */
#define PIO_MDSR_P0 (0x1u << 0) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P1 (0x1u << 1) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P2 (0x1u << 2) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P3 (0x1u << 3) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P4 (0x1u << 4) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P5 (0x1u << 5) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P6 (0x1u << 6) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P7 (0x1u << 7) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P8 (0x1u << 8) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P9 (0x1u << 9) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P10 (0x1u << 10) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P11 (0x1u << 11) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P12 (0x1u << 12) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P13 (0x1u << 13) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P14 (0x1u << 14) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P15 (0x1u << 15) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P16 (0x1u << 16) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P17 (0x1u << 17) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P18 (0x1u << 18) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P19 (0x1u << 19) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P20 (0x1u << 20) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P21 (0x1u << 21) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P22 (0x1u << 22) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P23 (0x1u << 23) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P24 (0x1u << 24) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P25 (0x1u << 25) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P26 (0x1u << 26) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P27 (0x1u << 27) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P28 (0x1u << 28) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P29 (0x1u << 29) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P30 (0x1u << 30) /**< \brief (PIO_MDSR) Multi Drive Status. */
#define PIO_MDSR_P31 (0x1u << 31) /**< \brief (PIO_MDSR) Multi Drive Status. */
/* -------- PIO_PUDR : (PIO Offset: 0x0060) Pull-up Disable Register -------- */
#define PIO_PUDR_P0 (0x1u << 0) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P1 (0x1u << 1) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P2 (0x1u << 2) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P3 (0x1u << 3) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P4 (0x1u << 4) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P5 (0x1u << 5) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P6 (0x1u << 6) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P7 (0x1u << 7) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P8 (0x1u << 8) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P9 (0x1u << 9) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P10 (0x1u << 10) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P11 (0x1u << 11) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P12 (0x1u << 12) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P13 (0x1u << 13) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P14 (0x1u << 14) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P15 (0x1u << 15) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P16 (0x1u << 16) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P17 (0x1u << 17) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P18 (0x1u << 18) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P19 (0x1u << 19) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P20 (0x1u << 20) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P21 (0x1u << 21) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P22 (0x1u << 22) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P23 (0x1u << 23) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P24 (0x1u << 24) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P25 (0x1u << 25) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P26 (0x1u << 26) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P27 (0x1u << 27) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P28 (0x1u << 28) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P29 (0x1u << 29) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P30 (0x1u << 30) /**< \brief (PIO_PUDR) Pull Up Disable. */
#define PIO_PUDR_P31 (0x1u << 31) /**< \brief (PIO_PUDR) Pull Up Disable. */
/* -------- PIO_PUER : (PIO Offset: 0x0064) Pull-up Enable Register -------- */
#define PIO_PUER_P0 (0x1u << 0) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P1 (0x1u << 1) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P2 (0x1u << 2) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P3 (0x1u << 3) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P4 (0x1u << 4) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P5 (0x1u << 5) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P6 (0x1u << 6) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P7 (0x1u << 7) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P8 (0x1u << 8) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P9 (0x1u << 9) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P10 (0x1u << 10) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P11 (0x1u << 11) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P12 (0x1u << 12) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P13 (0x1u << 13) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P14 (0x1u << 14) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P15 (0x1u << 15) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P16 (0x1u << 16) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P17 (0x1u << 17) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P18 (0x1u << 18) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P19 (0x1u << 19) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P20 (0x1u << 20) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P21 (0x1u << 21) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P22 (0x1u << 22) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P23 (0x1u << 23) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P24 (0x1u << 24) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P25 (0x1u << 25) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P26 (0x1u << 26) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P27 (0x1u << 27) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P28 (0x1u << 28) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P29 (0x1u << 29) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P30 (0x1u << 30) /**< \brief (PIO_PUER) Pull Up Enable. */
#define PIO_PUER_P31 (0x1u << 31) /**< \brief (PIO_PUER) Pull Up Enable. */
/* -------- PIO_PUSR : (PIO Offset: 0x0068) Pad Pull-up Status Register -------- */
#define PIO_PUSR_P0 (0x1u << 0) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P1 (0x1u << 1) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P2 (0x1u << 2) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P3 (0x1u << 3) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P4 (0x1u << 4) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P5 (0x1u << 5) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P6 (0x1u << 6) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P7 (0x1u << 7) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P8 (0x1u << 8) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P9 (0x1u << 9) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P10 (0x1u << 10) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P11 (0x1u << 11) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P12 (0x1u << 12) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P13 (0x1u << 13) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P14 (0x1u << 14) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P15 (0x1u << 15) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P16 (0x1u << 16) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P17 (0x1u << 17) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P18 (0x1u << 18) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P19 (0x1u << 19) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P20 (0x1u << 20) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P21 (0x1u << 21) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P22 (0x1u << 22) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P23 (0x1u << 23) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P24 (0x1u << 24) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P25 (0x1u << 25) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P26 (0x1u << 26) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P27 (0x1u << 27) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P28 (0x1u << 28) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P29 (0x1u << 29) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P30 (0x1u << 30) /**< \brief (PIO_PUSR) Pull Up Status. */
#define PIO_PUSR_P31 (0x1u << 31) /**< \brief (PIO_PUSR) Pull Up Status. */
/* -------- PIO_ABCDSR[2] : (PIO Offset: 0x0070) Peripheral Select Register -------- */
#define PIO_ABCDSR_P0 (0x1u << 0) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P1 (0x1u << 1) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P2 (0x1u << 2) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P3 (0x1u << 3) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P4 (0x1u << 4) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P5 (0x1u << 5) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P6 (0x1u << 6) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P7 (0x1u << 7) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P8 (0x1u << 8) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P9 (0x1u << 9) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P10 (0x1u << 10) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P11 (0x1u << 11) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P12 (0x1u << 12) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P13 (0x1u << 13) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P14 (0x1u << 14) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P15 (0x1u << 15) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P16 (0x1u << 16) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P17 (0x1u << 17) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P18 (0x1u << 18) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P19 (0x1u << 19) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P20 (0x1u << 20) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P21 (0x1u << 21) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P22 (0x1u << 22) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P23 (0x1u << 23) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P24 (0x1u << 24) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P25 (0x1u << 25) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P26 (0x1u << 26) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P27 (0x1u << 27) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P28 (0x1u << 28) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P29 (0x1u << 29) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P30 (0x1u << 30) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
#define PIO_ABCDSR_P31 (0x1u << 31) /**< \brief (PIO_ABCDSR[2]) Peripheral Select. */
/* -------- PIO_IFSCDR : (PIO Offset: 0x0080) Input Filter Slow Clock Disable Register -------- */
#define PIO_IFSCDR_P0 (0x1u << 0) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P1 (0x1u << 1) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P2 (0x1u << 2) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P3 (0x1u << 3) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P4 (0x1u << 4) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P5 (0x1u << 5) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P6 (0x1u << 6) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P7 (0x1u << 7) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P8 (0x1u << 8) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P9 (0x1u << 9) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P10 (0x1u << 10) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P11 (0x1u << 11) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P12 (0x1u << 12) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P13 (0x1u << 13) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P14 (0x1u << 14) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P15 (0x1u << 15) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P16 (0x1u << 16) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P17 (0x1u << 17) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P18 (0x1u << 18) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P19 (0x1u << 19) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P20 (0x1u << 20) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P21 (0x1u << 21) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P22 (0x1u << 22) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P23 (0x1u << 23) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P24 (0x1u << 24) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P25 (0x1u << 25) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P26 (0x1u << 26) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P27 (0x1u << 27) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P28 (0x1u << 28) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P29 (0x1u << 29) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P30 (0x1u << 30) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
#define PIO_IFSCDR_P31 (0x1u << 31) /**< \brief (PIO_IFSCDR) PIO Clock Glitch Filtering Select. */
/* -------- PIO_IFSCER : (PIO Offset: 0x0084) Input Filter Slow Clock Enable Register -------- */
#define PIO_IFSCER_P0 (0x1u << 0) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P1 (0x1u << 1) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P2 (0x1u << 2) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P3 (0x1u << 3) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P4 (0x1u << 4) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P5 (0x1u << 5) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P6 (0x1u << 6) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P7 (0x1u << 7) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P8 (0x1u << 8) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P9 (0x1u << 9) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P10 (0x1u << 10) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P11 (0x1u << 11) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P12 (0x1u << 12) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P13 (0x1u << 13) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P14 (0x1u << 14) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P15 (0x1u << 15) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P16 (0x1u << 16) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P17 (0x1u << 17) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P18 (0x1u << 18) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P19 (0x1u << 19) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P20 (0x1u << 20) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P21 (0x1u << 21) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P22 (0x1u << 22) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P23 (0x1u << 23) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P24 (0x1u << 24) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P25 (0x1u << 25) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P26 (0x1u << 26) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P27 (0x1u << 27) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P28 (0x1u << 28) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P29 (0x1u << 29) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P30 (0x1u << 30) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
#define PIO_IFSCER_P31 (0x1u << 31) /**< \brief (PIO_IFSCER) Debouncing Filtering Select. */
/* -------- PIO_IFSCSR : (PIO Offset: 0x0088) Input Filter Slow Clock Status Register -------- */
#define PIO_IFSCSR_P0 (0x1u << 0) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P1 (0x1u << 1) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P2 (0x1u << 2) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P3 (0x1u << 3) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P4 (0x1u << 4) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P5 (0x1u << 5) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P6 (0x1u << 6) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P7 (0x1u << 7) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P8 (0x1u << 8) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P9 (0x1u << 9) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P10 (0x1u << 10) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P11 (0x1u << 11) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P12 (0x1u << 12) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P13 (0x1u << 13) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P14 (0x1u << 14) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P15 (0x1u << 15) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P16 (0x1u << 16) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P17 (0x1u << 17) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P18 (0x1u << 18) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P19 (0x1u << 19) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P20 (0x1u << 20) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P21 (0x1u << 21) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P22 (0x1u << 22) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P23 (0x1u << 23) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P24 (0x1u << 24) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P25 (0x1u << 25) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P26 (0x1u << 26) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P27 (0x1u << 27) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P28 (0x1u << 28) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P29 (0x1u << 29) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P30 (0x1u << 30) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
#define PIO_IFSCSR_P31 (0x1u << 31) /**< \brief (PIO_IFSCSR) Glitch or Debouncing Filter Selection Status */
/* -------- PIO_SCDR : (PIO Offset: 0x008C) Slow Clock Divider Debouncing Register -------- */
#define PIO_SCDR_DIV_Pos 0
#define PIO_SCDR_DIV_Msk (0x3fffu << PIO_SCDR_DIV_Pos) /**< \brief (PIO_SCDR) Slow Clock Divider Selection for Debouncing */
#define PIO_SCDR_DIV(value) ((PIO_SCDR_DIV_Msk & ((value) << PIO_SCDR_DIV_Pos)))
/* -------- PIO_PPDDR : (PIO Offset: 0x0090) Pad Pull-down Disable Register -------- */
#define PIO_PPDDR_P0 (0x1u << 0) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P1 (0x1u << 1) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P2 (0x1u << 2) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P3 (0x1u << 3) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P4 (0x1u << 4) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P5 (0x1u << 5) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P6 (0x1u << 6) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P7 (0x1u << 7) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P8 (0x1u << 8) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P9 (0x1u << 9) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P10 (0x1u << 10) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P11 (0x1u << 11) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P12 (0x1u << 12) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P13 (0x1u << 13) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P14 (0x1u << 14) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P15 (0x1u << 15) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P16 (0x1u << 16) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P17 (0x1u << 17) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P18 (0x1u << 18) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P19 (0x1u << 19) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P20 (0x1u << 20) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P21 (0x1u << 21) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P22 (0x1u << 22) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P23 (0x1u << 23) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P24 (0x1u << 24) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P25 (0x1u << 25) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P26 (0x1u << 26) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P27 (0x1u << 27) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P28 (0x1u << 28) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P29 (0x1u << 29) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P30 (0x1u << 30) /**< \brief (PIO_PPDDR) Pull Down Disable */
#define PIO_PPDDR_P31 (0x1u << 31) /**< \brief (PIO_PPDDR) Pull Down Disable */
/* -------- PIO_PPDER : (PIO Offset: 0x0094) Pad Pull-down Enable Register -------- */
#define PIO_PPDER_P0 (0x1u << 0) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P1 (0x1u << 1) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P2 (0x1u << 2) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P3 (0x1u << 3) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P4 (0x1u << 4) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P5 (0x1u << 5) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P6 (0x1u << 6) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P7 (0x1u << 7) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P8 (0x1u << 8) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P9 (0x1u << 9) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P10 (0x1u << 10) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P11 (0x1u << 11) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P12 (0x1u << 12) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P13 (0x1u << 13) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P14 (0x1u << 14) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P15 (0x1u << 15) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P16 (0x1u << 16) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P17 (0x1u << 17) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P18 (0x1u << 18) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P19 (0x1u << 19) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P20 (0x1u << 20) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P21 (0x1u << 21) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P22 (0x1u << 22) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P23 (0x1u << 23) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P24 (0x1u << 24) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P25 (0x1u << 25) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P26 (0x1u << 26) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P27 (0x1u << 27) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P28 (0x1u << 28) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P29 (0x1u << 29) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P30 (0x1u << 30) /**< \brief (PIO_PPDER) Pull Down Enable */
#define PIO_PPDER_P31 (0x1u << 31) /**< \brief (PIO_PPDER) Pull Down Enable */
/* -------- PIO_PPDSR : (PIO Offset: 0x0098) Pad Pull-down Status Register -------- */
#define PIO_PPDSR_P0 (0x1u << 0) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P1 (0x1u << 1) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P2 (0x1u << 2) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P3 (0x1u << 3) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P4 (0x1u << 4) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P5 (0x1u << 5) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P6 (0x1u << 6) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P7 (0x1u << 7) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P8 (0x1u << 8) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P9 (0x1u << 9) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P10 (0x1u << 10) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P11 (0x1u << 11) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P12 (0x1u << 12) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P13 (0x1u << 13) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P14 (0x1u << 14) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P15 (0x1u << 15) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P16 (0x1u << 16) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P17 (0x1u << 17) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P18 (0x1u << 18) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P19 (0x1u << 19) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P20 (0x1u << 20) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P21 (0x1u << 21) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P22 (0x1u << 22) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P23 (0x1u << 23) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P24 (0x1u << 24) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P25 (0x1u << 25) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P26 (0x1u << 26) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P27 (0x1u << 27) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P28 (0x1u << 28) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P29 (0x1u << 29) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P30 (0x1u << 30) /**< \brief (PIO_PPDSR) Pull Down Status */
#define PIO_PPDSR_P31 (0x1u << 31) /**< \brief (PIO_PPDSR) Pull Down Status */
/* -------- PIO_OWER : (PIO Offset: 0x00A0) Output Write Enable -------- */
#define PIO_OWER_P0 (0x1u << 0) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P1 (0x1u << 1) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P2 (0x1u << 2) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P3 (0x1u << 3) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P4 (0x1u << 4) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P5 (0x1u << 5) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P6 (0x1u << 6) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P7 (0x1u << 7) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P8 (0x1u << 8) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P9 (0x1u << 9) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P10 (0x1u << 10) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P11 (0x1u << 11) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P12 (0x1u << 12) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P13 (0x1u << 13) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P14 (0x1u << 14) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P15 (0x1u << 15) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P16 (0x1u << 16) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P17 (0x1u << 17) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P18 (0x1u << 18) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P19 (0x1u << 19) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P20 (0x1u << 20) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P21 (0x1u << 21) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P22 (0x1u << 22) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P23 (0x1u << 23) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P24 (0x1u << 24) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P25 (0x1u << 25) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P26 (0x1u << 26) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P27 (0x1u << 27) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P28 (0x1u << 28) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P29 (0x1u << 29) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P30 (0x1u << 30) /**< \brief (PIO_OWER) Output Write Enable */
#define PIO_OWER_P31 (0x1u << 31) /**< \brief (PIO_OWER) Output Write Enable */
/* -------- PIO_OWDR : (PIO Offset: 0x00A4) Output Write Disable -------- */
#define PIO_OWDR_P0 (0x1u << 0) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P1 (0x1u << 1) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P2 (0x1u << 2) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P3 (0x1u << 3) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P4 (0x1u << 4) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P5 (0x1u << 5) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P6 (0x1u << 6) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P7 (0x1u << 7) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P8 (0x1u << 8) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P9 (0x1u << 9) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P10 (0x1u << 10) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P11 (0x1u << 11) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P12 (0x1u << 12) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P13 (0x1u << 13) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P14 (0x1u << 14) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P15 (0x1u << 15) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P16 (0x1u << 16) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P17 (0x1u << 17) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P18 (0x1u << 18) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P19 (0x1u << 19) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P20 (0x1u << 20) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P21 (0x1u << 21) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P22 (0x1u << 22) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P23 (0x1u << 23) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P24 (0x1u << 24) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P25 (0x1u << 25) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P26 (0x1u << 26) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P27 (0x1u << 27) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P28 (0x1u << 28) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P29 (0x1u << 29) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P30 (0x1u << 30) /**< \brief (PIO_OWDR) Output Write Disable */
#define PIO_OWDR_P31 (0x1u << 31) /**< \brief (PIO_OWDR) Output Write Disable */
/* -------- PIO_OWSR : (PIO Offset: 0x00A8) Output Write Status Register -------- */
#define PIO_OWSR_P0 (0x1u << 0) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P1 (0x1u << 1) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P2 (0x1u << 2) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P3 (0x1u << 3) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P4 (0x1u << 4) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P5 (0x1u << 5) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P6 (0x1u << 6) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P7 (0x1u << 7) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P8 (0x1u << 8) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P9 (0x1u << 9) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P10 (0x1u << 10) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P11 (0x1u << 11) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P12 (0x1u << 12) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P13 (0x1u << 13) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P14 (0x1u << 14) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P15 (0x1u << 15) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P16 (0x1u << 16) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P17 (0x1u << 17) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P18 (0x1u << 18) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P19 (0x1u << 19) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P20 (0x1u << 20) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P21 (0x1u << 21) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P22 (0x1u << 22) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P23 (0x1u << 23) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P24 (0x1u << 24) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P25 (0x1u << 25) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P26 (0x1u << 26) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P27 (0x1u << 27) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P28 (0x1u << 28) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P29 (0x1u << 29) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P30 (0x1u << 30) /**< \brief (PIO_OWSR) Output Write Status */
#define PIO_OWSR_P31 (0x1u << 31) /**< \brief (PIO_OWSR) Output Write Status */
/* -------- PIO_AIMER : (PIO Offset: 0x00B0) Additional Interrupt Modes Enable Register -------- */
#define PIO_AIMER_P0 (0x1u << 0) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P1 (0x1u << 1) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P2 (0x1u << 2) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P3 (0x1u << 3) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P4 (0x1u << 4) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P5 (0x1u << 5) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P6 (0x1u << 6) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P7 (0x1u << 7) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P8 (0x1u << 8) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P9 (0x1u << 9) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P10 (0x1u << 10) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P11 (0x1u << 11) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P12 (0x1u << 12) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P13 (0x1u << 13) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P14 (0x1u << 14) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P15 (0x1u << 15) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P16 (0x1u << 16) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P17 (0x1u << 17) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P18 (0x1u << 18) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P19 (0x1u << 19) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P20 (0x1u << 20) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P21 (0x1u << 21) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P22 (0x1u << 22) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P23 (0x1u << 23) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P24 (0x1u << 24) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P25 (0x1u << 25) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P26 (0x1u << 26) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P27 (0x1u << 27) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P28 (0x1u << 28) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P29 (0x1u << 29) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P30 (0x1u << 30) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
#define PIO_AIMER_P31 (0x1u << 31) /**< \brief (PIO_AIMER) Additional Interrupt Modes Enable */
/* -------- PIO_AIMDR : (PIO Offset: 0x00B4) Additional Interrupt Modes Disables Register -------- */
#define PIO_AIMDR_P0 (0x1u << 0) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P1 (0x1u << 1) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P2 (0x1u << 2) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P3 (0x1u << 3) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P4 (0x1u << 4) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P5 (0x1u << 5) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P6 (0x1u << 6) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P7 (0x1u << 7) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P8 (0x1u << 8) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P9 (0x1u << 9) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P10 (0x1u << 10) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P11 (0x1u << 11) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P12 (0x1u << 12) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P13 (0x1u << 13) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P14 (0x1u << 14) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P15 (0x1u << 15) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P16 (0x1u << 16) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P17 (0x1u << 17) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P18 (0x1u << 18) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P19 (0x1u << 19) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P20 (0x1u << 20) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P21 (0x1u << 21) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P22 (0x1u << 22) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P23 (0x1u << 23) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P24 (0x1u << 24) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P25 (0x1u << 25) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P26 (0x1u << 26) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P27 (0x1u << 27) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P28 (0x1u << 28) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P29 (0x1u << 29) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P30 (0x1u << 30) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
#define PIO_AIMDR_P31 (0x1u << 31) /**< \brief (PIO_AIMDR) Additional Interrupt Modes Disable */
/* -------- PIO_AIMMR : (PIO Offset: 0x00B8) Additional Interrupt Modes Mask Register -------- */
#define PIO_AIMMR_P0 (0x1u << 0) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P1 (0x1u << 1) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P2 (0x1u << 2) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P3 (0x1u << 3) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P4 (0x1u << 4) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P5 (0x1u << 5) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P6 (0x1u << 6) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P7 (0x1u << 7) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P8 (0x1u << 8) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P9 (0x1u << 9) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P10 (0x1u << 10) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P11 (0x1u << 11) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P12 (0x1u << 12) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P13 (0x1u << 13) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P14 (0x1u << 14) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P15 (0x1u << 15) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P16 (0x1u << 16) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P17 (0x1u << 17) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P18 (0x1u << 18) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P19 (0x1u << 19) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P20 (0x1u << 20) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P21 (0x1u << 21) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P22 (0x1u << 22) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P23 (0x1u << 23) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P24 (0x1u << 24) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P25 (0x1u << 25) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P26 (0x1u << 26) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P27 (0x1u << 27) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P28 (0x1u << 28) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P29 (0x1u << 29) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P30 (0x1u << 30) /**< \brief (PIO_AIMMR) Peripheral CD Status */
#define PIO_AIMMR_P31 (0x1u << 31) /**< \brief (PIO_AIMMR) Peripheral CD Status */
/* -------- PIO_ESR : (PIO Offset: 0x00C0) Edge Select Register -------- */
#define PIO_ESR_P0 (0x1u << 0) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P1 (0x1u << 1) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P2 (0x1u << 2) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P3 (0x1u << 3) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P4 (0x1u << 4) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P5 (0x1u << 5) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P6 (0x1u << 6) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P7 (0x1u << 7) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P8 (0x1u << 8) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P9 (0x1u << 9) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P10 (0x1u << 10) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P11 (0x1u << 11) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P12 (0x1u << 12) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P13 (0x1u << 13) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P14 (0x1u << 14) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P15 (0x1u << 15) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P16 (0x1u << 16) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P17 (0x1u << 17) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P18 (0x1u << 18) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P19 (0x1u << 19) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P20 (0x1u << 20) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P21 (0x1u << 21) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P22 (0x1u << 22) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P23 (0x1u << 23) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P24 (0x1u << 24) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P25 (0x1u << 25) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P26 (0x1u << 26) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P27 (0x1u << 27) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P28 (0x1u << 28) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P29 (0x1u << 29) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P30 (0x1u << 30) /**< \brief (PIO_ESR) Edge Interrupt Selection */
#define PIO_ESR_P31 (0x1u << 31) /**< \brief (PIO_ESR) Edge Interrupt Selection */
/* -------- PIO_LSR : (PIO Offset: 0x00C4) Level Select Register -------- */
#define PIO_LSR_P0 (0x1u << 0) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P1 (0x1u << 1) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P2 (0x1u << 2) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P3 (0x1u << 3) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P4 (0x1u << 4) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P5 (0x1u << 5) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P6 (0x1u << 6) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P7 (0x1u << 7) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P8 (0x1u << 8) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P9 (0x1u << 9) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P10 (0x1u << 10) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P11 (0x1u << 11) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P12 (0x1u << 12) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P13 (0x1u << 13) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P14 (0x1u << 14) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P15 (0x1u << 15) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P16 (0x1u << 16) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P17 (0x1u << 17) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P18 (0x1u << 18) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P19 (0x1u << 19) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P20 (0x1u << 20) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P21 (0x1u << 21) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P22 (0x1u << 22) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P23 (0x1u << 23) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P24 (0x1u << 24) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P25 (0x1u << 25) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P26 (0x1u << 26) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P27 (0x1u << 27) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P28 (0x1u << 28) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P29 (0x1u << 29) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P30 (0x1u << 30) /**< \brief (PIO_LSR) Level Interrupt Selection */
#define PIO_LSR_P31 (0x1u << 31) /**< \brief (PIO_LSR) Level Interrupt Selection */
/* -------- PIO_ELSR : (PIO Offset: 0x00C8) Edge/Level Status Register -------- */
#define PIO_ELSR_P0 (0x1u << 0) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P1 (0x1u << 1) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P2 (0x1u << 2) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P3 (0x1u << 3) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P4 (0x1u << 4) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P5 (0x1u << 5) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P6 (0x1u << 6) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P7 (0x1u << 7) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P8 (0x1u << 8) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P9 (0x1u << 9) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P10 (0x1u << 10) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P11 (0x1u << 11) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P12 (0x1u << 12) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P13 (0x1u << 13) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P14 (0x1u << 14) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P15 (0x1u << 15) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P16 (0x1u << 16) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P17 (0x1u << 17) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P18 (0x1u << 18) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P19 (0x1u << 19) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P20 (0x1u << 20) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P21 (0x1u << 21) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P22 (0x1u << 22) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P23 (0x1u << 23) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P24 (0x1u << 24) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P25 (0x1u << 25) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P26 (0x1u << 26) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P27 (0x1u << 27) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P28 (0x1u << 28) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P29 (0x1u << 29) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P30 (0x1u << 30) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
#define PIO_ELSR_P31 (0x1u << 31) /**< \brief (PIO_ELSR) Edge/Level Interrupt Source Selection */
/* -------- PIO_FELLSR : (PIO Offset: 0x00D0) Falling Edge/Low Level Select Register -------- */
#define PIO_FELLSR_P0 (0x1u << 0) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P1 (0x1u << 1) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P2 (0x1u << 2) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P3 (0x1u << 3) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P4 (0x1u << 4) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P5 (0x1u << 5) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P6 (0x1u << 6) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P7 (0x1u << 7) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P8 (0x1u << 8) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P9 (0x1u << 9) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P10 (0x1u << 10) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P11 (0x1u << 11) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P12 (0x1u << 12) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P13 (0x1u << 13) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P14 (0x1u << 14) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P15 (0x1u << 15) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P16 (0x1u << 16) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P17 (0x1u << 17) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P18 (0x1u << 18) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P19 (0x1u << 19) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P20 (0x1u << 20) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P21 (0x1u << 21) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P22 (0x1u << 22) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P23 (0x1u << 23) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P24 (0x1u << 24) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P25 (0x1u << 25) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P26 (0x1u << 26) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P27 (0x1u << 27) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P28 (0x1u << 28) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P29 (0x1u << 29) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P30 (0x1u << 30) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
#define PIO_FELLSR_P31 (0x1u << 31) /**< \brief (PIO_FELLSR) Falling Edge/Low Level Interrupt Selection */
/* -------- PIO_REHLSR : (PIO Offset: 0x00D4) Rising Edge/ High Level Select Register -------- */
#define PIO_REHLSR_P0 (0x1u << 0) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P1 (0x1u << 1) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P2 (0x1u << 2) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P3 (0x1u << 3) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P4 (0x1u << 4) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P5 (0x1u << 5) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P6 (0x1u << 6) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P7 (0x1u << 7) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P8 (0x1u << 8) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P9 (0x1u << 9) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P10 (0x1u << 10) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P11 (0x1u << 11) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P12 (0x1u << 12) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P13 (0x1u << 13) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P14 (0x1u << 14) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P15 (0x1u << 15) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P16 (0x1u << 16) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P17 (0x1u << 17) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P18 (0x1u << 18) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P19 (0x1u << 19) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P20 (0x1u << 20) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P21 (0x1u << 21) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P22 (0x1u << 22) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P23 (0x1u << 23) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P24 (0x1u << 24) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P25 (0x1u << 25) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P26 (0x1u << 26) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P27 (0x1u << 27) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P28 (0x1u << 28) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P29 (0x1u << 29) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P30 (0x1u << 30) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
#define PIO_REHLSR_P31 (0x1u << 31) /**< \brief (PIO_REHLSR) Rising Edge /High Level Interrupt Selection */
/* -------- PIO_FRLHSR : (PIO Offset: 0x00D8) Fall/Rise - Low/High Status Register -------- */
#define PIO_FRLHSR_P0 (0x1u << 0) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P1 (0x1u << 1) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P2 (0x1u << 2) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P3 (0x1u << 3) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P4 (0x1u << 4) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P5 (0x1u << 5) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P6 (0x1u << 6) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P7 (0x1u << 7) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P8 (0x1u << 8) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P9 (0x1u << 9) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P10 (0x1u << 10) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P11 (0x1u << 11) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P12 (0x1u << 12) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P13 (0x1u << 13) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P14 (0x1u << 14) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P15 (0x1u << 15) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P16 (0x1u << 16) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P17 (0x1u << 17) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P18 (0x1u << 18) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P19 (0x1u << 19) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P20 (0x1u << 20) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P21 (0x1u << 21) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P22 (0x1u << 22) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P23 (0x1u << 23) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P24 (0x1u << 24) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P25 (0x1u << 25) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P26 (0x1u << 26) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P27 (0x1u << 27) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P28 (0x1u << 28) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P29 (0x1u << 29) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P30 (0x1u << 30) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
#define PIO_FRLHSR_P31 (0x1u << 31) /**< \brief (PIO_FRLHSR) Edge /Level Interrupt Source Selection */
/* -------- PIO_WPMR : (PIO Offset: 0x00E4) Write Protect Mode Register -------- */
#define PIO_WPMR_WPEN (0x1u << 0) /**< \brief (PIO_WPMR) Write Protect Enable */
#define PIO_WPMR_WPKEY_Pos 8
#define PIO_WPMR_WPKEY_Msk (0xffffffu << PIO_WPMR_WPKEY_Pos) /**< \brief (PIO_WPMR) Write Protect KEY. */
#define   PIO_WPMR_WPKEY_PASSWD (0x50494Fu << 8) /**< \brief (PIO_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0. */
/* -------- PIO_WPSR : (PIO Offset: 0x00E8) Write Protect Status Register -------- */
#define PIO_WPSR_WPVS (0x1u << 0) /**< \brief (PIO_WPSR) Write Protect Violation Status */
#define PIO_WPSR_WPVSRC_Pos 8
#define PIO_WPSR_WPVSRC_Msk (0xffffu << PIO_WPSR_WPVSRC_Pos) /**< \brief (PIO_WPSR) Write Protect Violation Source */
/* -------- PIO_SCHMITT : (PIO Offset: 0x0100) Schmitt Trigger Register -------- */
#define PIO_SCHMITT_SCHMITT0 (0x1u << 0) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT1 (0x1u << 1) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT2 (0x1u << 2) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT3 (0x1u << 3) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT4 (0x1u << 4) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT5 (0x1u << 5) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT6 (0x1u << 6) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT7 (0x1u << 7) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT8 (0x1u << 8) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT9 (0x1u << 9) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT10 (0x1u << 10) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT11 (0x1u << 11) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT12 (0x1u << 12) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT13 (0x1u << 13) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT14 (0x1u << 14) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT15 (0x1u << 15) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT16 (0x1u << 16) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT17 (0x1u << 17) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT18 (0x1u << 18) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT19 (0x1u << 19) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT20 (0x1u << 20) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT21 (0x1u << 21) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT22 (0x1u << 22) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT23 (0x1u << 23) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT24 (0x1u << 24) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT25 (0x1u << 25) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT26 (0x1u << 26) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT27 (0x1u << 27) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT28 (0x1u << 28) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT29 (0x1u << 29) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT30 (0x1u << 30) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
#define PIO_SCHMITT_SCHMITT31 (0x1u << 31) /**< \brief (PIO_SCHMITT) Schmitt Trigger Control */
/* -------- PIO_DRIVER1 : (PIO Offset: 0x0118) I/O Drive Register 1 -------- */
#define PIO_DRIVER1_LINE0_Pos 0
#define PIO_DRIVER1_LINE0_Msk (0x3u << PIO_DRIVER1_LINE0_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 0 */
#define   PIO_DRIVER1_LINE0_LO_DRIVE (0x0u << 0) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE0_ME_DRIVE (0x2u << 0) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE0_HI_DRIVE (0x3u << 0) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE1_Pos 2
#define PIO_DRIVER1_LINE1_Msk (0x3u << PIO_DRIVER1_LINE1_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 1 */
#define   PIO_DRIVER1_LINE1_LO_DRIVE (0x0u << 2) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE1_ME_DRIVE (0x2u << 2) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE1_HI_DRIVE (0x3u << 2) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE2_Pos 4
#define PIO_DRIVER1_LINE2_Msk (0x3u << PIO_DRIVER1_LINE2_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 2 */
#define   PIO_DRIVER1_LINE2_LO_DRIVE (0x0u << 4) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE2_ME_DRIVE (0x2u << 4) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE2_HI_DRIVE (0x3u << 4) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE3_Pos 6
#define PIO_DRIVER1_LINE3_Msk (0x3u << PIO_DRIVER1_LINE3_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 3 */
#define   PIO_DRIVER1_LINE3_LO_DRIVE (0x0u << 6) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE3_ME_DRIVE (0x2u << 6) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE3_HI_DRIVE (0x3u << 6) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE4_Pos 8
#define PIO_DRIVER1_LINE4_Msk (0x3u << PIO_DRIVER1_LINE4_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 4 */
#define   PIO_DRIVER1_LINE4_LO_DRIVE (0x0u << 8) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE4_ME_DRIVE (0x2u << 8) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE4_HI_DRIVE (0x3u << 8) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE5_Pos 10
#define PIO_DRIVER1_LINE5_Msk (0x3u << PIO_DRIVER1_LINE5_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 5 */
#define   PIO_DRIVER1_LINE5_LO_DRIVE (0x0u << 10) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE5_ME_DRIVE (0x2u << 10) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE5_HI_DRIVE (0x3u << 10) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE6_Pos 12
#define PIO_DRIVER1_LINE6_Msk (0x3u << PIO_DRIVER1_LINE6_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 6 */
#define   PIO_DRIVER1_LINE6_LO_DRIVE (0x0u << 12) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE6_ME_DRIVE (0x2u << 12) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE6_HI_DRIVE (0x3u << 12) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE7_Pos 14
#define PIO_DRIVER1_LINE7_Msk (0x3u << PIO_DRIVER1_LINE7_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 7 */
#define   PIO_DRIVER1_LINE7_LO_DRIVE (0x0u << 14) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE7_ME_DRIVE (0x2u << 14) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE7_HI_DRIVE (0x3u << 14) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE8_Pos 16
#define PIO_DRIVER1_LINE8_Msk (0x3u << PIO_DRIVER1_LINE8_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 8 */
#define   PIO_DRIVER1_LINE8_LO_DRIVE (0x0u << 16) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE8_ME_DRIVE (0x2u << 16) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE8_HI_DRIVE (0x3u << 16) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE9_Pos 18
#define PIO_DRIVER1_LINE9_Msk (0x3u << PIO_DRIVER1_LINE9_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 9 */
#define   PIO_DRIVER1_LINE9_LO_DRIVE (0x0u << 18) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE9_ME_DRIVE (0x2u << 18) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE9_HI_DRIVE (0x3u << 18) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE10_Pos 20
#define PIO_DRIVER1_LINE10_Msk (0x3u << PIO_DRIVER1_LINE10_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 10 */
#define   PIO_DRIVER1_LINE10_LO_DRIVE (0x0u << 20) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE10_ME_DRIVE (0x2u << 20) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE10_HI_DRIVE (0x3u << 20) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE11_Pos 22
#define PIO_DRIVER1_LINE11_Msk (0x3u << PIO_DRIVER1_LINE11_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 11 */
#define   PIO_DRIVER1_LINE11_LO_DRIVE (0x0u << 22) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE11_ME_DRIVE (0x2u << 22) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE11_HI_DRIVE (0x3u << 22) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE12_Pos 24
#define PIO_DRIVER1_LINE12_Msk (0x3u << PIO_DRIVER1_LINE12_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 12 */
#define   PIO_DRIVER1_LINE12_LO_DRIVE (0x0u << 24) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE12_ME_DRIVE (0x2u << 24) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE12_HI_DRIVE (0x3u << 24) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE13_Pos 26
#define PIO_DRIVER1_LINE13_Msk (0x3u << PIO_DRIVER1_LINE13_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 13 */
#define   PIO_DRIVER1_LINE13_LO_DRIVE (0x0u << 26) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE13_ME_DRIVE (0x2u << 26) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE13_HI_DRIVE (0x3u << 26) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE14_Pos 28
#define PIO_DRIVER1_LINE14_Msk (0x3u << PIO_DRIVER1_LINE14_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 14 */
#define   PIO_DRIVER1_LINE14_LO_DRIVE (0x0u << 28) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE14_ME_DRIVE (0x2u << 28) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE14_HI_DRIVE (0x3u << 28) /**< \brief (PIO_DRIVER1) High drive */
#define PIO_DRIVER1_LINE15_Pos 30
#define PIO_DRIVER1_LINE15_Msk (0x3u << PIO_DRIVER1_LINE15_Pos) /**< \brief (PIO_DRIVER1) Drive of PIO Line 15 */
#define   PIO_DRIVER1_LINE15_LO_DRIVE (0x0u << 30) /**< \brief (PIO_DRIVER1) Low drive */
#define   PIO_DRIVER1_LINE15_ME_DRIVE (0x2u << 30) /**< \brief (PIO_DRIVER1) Medium drive */
#define   PIO_DRIVER1_LINE15_HI_DRIVE (0x3u << 30) /**< \brief (PIO_DRIVER1) High drive */
/* -------- PIO_DRIVER2 : (PIO Offset: 0x011C) I/O Drive Register 2 -------- */
#define PIO_DRIVER2_LINE16_Pos 0
#define PIO_DRIVER2_LINE16_Msk (0x3u << PIO_DRIVER2_LINE16_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 16 */
#define   PIO_DRIVER2_LINE16_LO_DRIVE (0x0u << 0) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE16_ME_DRIVE (0x2u << 0) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE16_HI_DRIVE (0x3u << 0) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE17_Pos 2
#define PIO_DRIVER2_LINE17_Msk (0x3u << PIO_DRIVER2_LINE17_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 17 */
#define   PIO_DRIVER2_LINE17_LO_DRIVE (0x0u << 2) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE17_ME_DRIVE (0x2u << 2) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE17_HI_DRIVE (0x3u << 2) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE18_Pos 4
#define PIO_DRIVER2_LINE18_Msk (0x3u << PIO_DRIVER2_LINE18_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 18 */
#define   PIO_DRIVER2_LINE18_LO_DRIVE (0x0u << 4) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE18_ME_DRIVE (0x2u << 4) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE18_HI_DRIVE (0x3u << 4) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE19_Pos 6
#define PIO_DRIVER2_LINE19_Msk (0x3u << PIO_DRIVER2_LINE19_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 19 */
#define   PIO_DRIVER2_LINE19_LO_DRIVE (0x0u << 6) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE19_ME_DRIVE (0x2u << 6) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE19_HI_DRIVE (0x3u << 6) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE20_Pos 8
#define PIO_DRIVER2_LINE20_Msk (0x3u << PIO_DRIVER2_LINE20_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 20 */
#define   PIO_DRIVER2_LINE20_LO_DRIVE (0x0u << 8) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE20_ME_DRIVE (0x2u << 8) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE20_HI_DRIVE (0x3u << 8) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE21_Pos 10
#define PIO_DRIVER2_LINE21_Msk (0x3u << PIO_DRIVER2_LINE21_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 21 */
#define   PIO_DRIVER2_LINE21_LO_DRIVE (0x0u << 10) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE21_ME_DRIVE (0x2u << 10) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE21_HI_DRIVE (0x3u << 10) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE22_Pos 12
#define PIO_DRIVER2_LINE22_Msk (0x3u << PIO_DRIVER2_LINE22_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 22 */
#define   PIO_DRIVER2_LINE22_LO_DRIVE (0x0u << 12) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE22_ME_DRIVE (0x2u << 12) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE22_HI_DRIVE (0x3u << 12) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE23_Pos 14
#define PIO_DRIVER2_LINE23_Msk (0x3u << PIO_DRIVER2_LINE23_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 23 */
#define   PIO_DRIVER2_LINE23_LO_DRIVE (0x0u << 14) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE23_ME_DRIVE (0x2u << 14) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE23_HI_DRIVE (0x3u << 14) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE24_Pos 16
#define PIO_DRIVER2_LINE24_Msk (0x3u << PIO_DRIVER2_LINE24_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 24 */
#define   PIO_DRIVER2_LINE24_LO_DRIVE (0x0u << 16) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE24_ME_DRIVE (0x2u << 16) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE24_HI_DRIVE (0x3u << 16) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE25_Pos 18
#define PIO_DRIVER2_LINE25_Msk (0x3u << PIO_DRIVER2_LINE25_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 25 */
#define   PIO_DRIVER2_LINE25_LO_DRIVE (0x0u << 18) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE25_ME_DRIVE (0x2u << 18) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE25_HI_DRIVE (0x3u << 18) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE26_Pos 20
#define PIO_DRIVER2_LINE26_Msk (0x3u << PIO_DRIVER2_LINE26_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 26 */
#define   PIO_DRIVER2_LINE26_LO_DRIVE (0x0u << 20) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE26_ME_DRIVE (0x2u << 20) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE26_HI_DRIVE (0x3u << 20) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE27_Pos 22
#define PIO_DRIVER2_LINE27_Msk (0x3u << PIO_DRIVER2_LINE27_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 27 */
#define   PIO_DRIVER2_LINE27_LO_DRIVE (0x0u << 22) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE27_ME_DRIVE (0x2u << 22) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE27_HI_DRIVE (0x3u << 22) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE28_Pos 24
#define PIO_DRIVER2_LINE28_Msk (0x3u << PIO_DRIVER2_LINE28_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 28 */
#define   PIO_DRIVER2_LINE28_LO_DRIVE (0x0u << 24) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE28_ME_DRIVE (0x2u << 24) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE28_HI_DRIVE (0x3u << 24) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE29_Pos 26
#define PIO_DRIVER2_LINE29_Msk (0x3u << PIO_DRIVER2_LINE29_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 29 */
#define   PIO_DRIVER2_LINE29_LO_DRIVE (0x0u << 26) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE29_ME_DRIVE (0x2u << 26) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE29_HI_DRIVE (0x3u << 26) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE30_Pos 28
#define PIO_DRIVER2_LINE30_Msk (0x3u << PIO_DRIVER2_LINE30_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 30 */
#define   PIO_DRIVER2_LINE30_LO_DRIVE (0x0u << 28) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE30_ME_DRIVE (0x2u << 28) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE30_HI_DRIVE (0x3u << 28) /**< \brief (PIO_DRIVER2) High drive */
#define PIO_DRIVER2_LINE31_Pos 30
#define PIO_DRIVER2_LINE31_Msk (0x3u << PIO_DRIVER2_LINE31_Pos) /**< \brief (PIO_DRIVER2) Drive of PIO line 31 */
#define   PIO_DRIVER2_LINE31_LO_DRIVE (0x0u << 30) /**< \brief (PIO_DRIVER2) Low drive */
#define   PIO_DRIVER2_LINE31_ME_DRIVE (0x2u << 30) /**< \brief (PIO_DRIVER2) Medium drive */
#define   PIO_DRIVER2_LINE31_HI_DRIVE (0x3u << 30) /**< \brief (PIO_DRIVER2) High drive */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Periodic Interval Timer */
/* ============================================================================= */
/** \addtogroup SAMA5D4_PIT Periodic Interval Timer */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Pit hardware registers */
typedef struct {
  __IO uint32_t PIT_MR;   /**< \brief (Pit Offset: 0x00) Mode Register */
  __I  uint32_t PIT_SR;   /**< \brief (Pit Offset: 0x04) Status Register */
  __I  uint32_t PIT_PIVR; /**< \brief (Pit Offset: 0x08) Periodic Interval Value Register */
  __I  uint32_t PIT_PIIR; /**< \brief (Pit Offset: 0x0C) Periodic Interval Image Register */
} Pit;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- PIT_MR : (PIT Offset: 0x00) Mode Register -------- */
#define PIT_MR_PIV_Pos 0
#define PIT_MR_PIV_Msk (0xfffffu << PIT_MR_PIV_Pos) /**< \brief (PIT_MR) Periodic Interval Value */
#define PIT_MR_PIV(value) ((PIT_MR_PIV_Msk & ((value) << PIT_MR_PIV_Pos)))
#define PIT_MR_PITEN (0x1u << 24) /**< \brief (PIT_MR) Period Interval Timer Enabled */
#define PIT_MR_PITIEN (0x1u << 25) /**< \brief (PIT_MR) Periodic Interval Timer Interrupt Enable */
/* -------- PIT_SR : (PIT Offset: 0x04) Status Register -------- */
#define PIT_SR_PITS (0x1u << 0) /**< \brief (PIT_SR) Periodic Interval Timer Status */
/* -------- PIT_PIVR : (PIT Offset: 0x08) Periodic Interval Value Register -------- */
#define PIT_PIVR_CPIV_Pos 0
#define PIT_PIVR_CPIV_Msk (0xfffffu << PIT_PIVR_CPIV_Pos) /**< \brief (PIT_PIVR) Current Periodic Interval Value */
#define PIT_PIVR_PICNT_Pos 20
#define PIT_PIVR_PICNT_Msk (0xfffu << PIT_PIVR_PICNT_Pos) /**< \brief (PIT_PIVR) Periodic Interval Counter */
/* -------- PIT_PIIR : (PIT Offset: 0x0C) Periodic Interval Image Register -------- */
#define PIT_PIIR_CPIV_Pos 0
#define PIT_PIIR_CPIV_Msk (0xfffffu << PIT_PIIR_CPIV_Pos) /**< \brief (PIT_PIIR) Current Periodic Interval Value */
#define PIT_PIIR_PICNT_Pos 20
#define PIT_PIIR_PICNT_Msk (0xfffu << PIT_PIIR_PICNT_Pos) /**< \brief (PIT_PIIR) Periodic Interval Counter */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Power Management Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_PMC Power Management Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Pmc hardware registers */
typedef struct {
  __O  uint32_t PMC_SCER;      /**< \brief (Pmc Offset: 0x0000) System Clock Enable Register */
  __O  uint32_t PMC_SCDR;      /**< \brief (Pmc Offset: 0x0004) System Clock Disable Register */
  __I  uint32_t PMC_SCSR;      /**< \brief (Pmc Offset: 0x0008) System Clock Status Register */
  __I  uint32_t Reserved1[1];
  __O  uint32_t PMC_PCER0;     /**< \brief (Pmc Offset: 0x0010) Peripheral Clock Enable Register 0 */
  __O  uint32_t PMC_PCDR0;     /**< \brief (Pmc Offset: 0x0014) Peripheral Clock Disable Register 0 */
  __I  uint32_t PMC_PCSR0;     /**< \brief (Pmc Offset: 0x0018) Peripheral Clock Status Register 0 */
  __IO uint32_t CKGR_UCKR;     /**< \brief (Pmc Offset: 0x001C) UTMI Clock Register */
  __IO uint32_t CKGR_MOR;      /**< \brief (Pmc Offset: 0x0020) Main Oscillator Register */
  __I  uint32_t CKGR_MCFR;     /**< \brief (Pmc Offset: 0x0024) Main Clock Frequency Register */
  __IO uint32_t CKGR_PLLAR;    /**< \brief (Pmc Offset: 0x0028) PLLA Register */
  __I  uint32_t Reserved2[1];
  __IO uint32_t PMC_MCKR;      /**< \brief (Pmc Offset: 0x0030) Master Clock Register */
  __I  uint32_t Reserved3[1];
  __IO uint32_t PMC_USB;       /**< \brief (Pmc Offset: 0x0038) USB Clock Register */
  __IO uint32_t PMC_SMD;       /**< \brief (Pmc Offset: 0x003C) Soft Modem Clock Register */
  __IO uint32_t PMC_PCK[3];    /**< \brief (Pmc Offset: 0x0040) Programmable Clock 0 Register */
  __I  uint32_t Reserved4[5];
  __O  uint32_t PMC_IER;       /**< \brief (Pmc Offset: 0x0060) Interrupt Enable Register */
  __O  uint32_t PMC_IDR;       /**< \brief (Pmc Offset: 0x0064) Interrupt Disable Register */
  __I  uint32_t PMC_SR;        /**< \brief (Pmc Offset: 0x0068) Status Register */
  __I  uint32_t PMC_IMR;       /**< \brief (Pmc Offset: 0x006C) Interrupt Mask Register */
  __I  uint32_t Reserved5[2];
  __O  uint32_t PMC_FOCR;      /**< \brief (Pmc Offset: 0x0078) Fault Output Clear Register */
  __I  uint32_t Reserved6[1];
  __O  uint32_t PMC_PLLICPR;   /**< \brief (Pmc Offset: 0x0080) PLL Charge Pump Current Register */
  __I  uint32_t Reserved7[24];
  __IO uint32_t PMC_WPMR;      /**< \brief (Pmc Offset: 0x00E4) Write Protect Mode Register */
  __I  uint32_t PMC_WPSR;      /**< \brief (Pmc Offset: 0x00E8) Write Protect Status Register */
  __I  uint32_t Reserved8[5];
  __O  uint32_t PMC_PCER1;     /**< \brief (Pmc Offset: 0x0100) Peripheral Clock Enable Register 1 */
  __O  uint32_t PMC_PCDR1;     /**< \brief (Pmc Offset: 0x0104) Peripheral Clock Disable Register 1 */
  __I  uint32_t PMC_PCSR1;     /**< \brief (Pmc Offset: 0x0108) Peripheral Clock Status Register 1 */
  __IO uint32_t PMC_PCR;       /**< \brief (Pmc Offset: 0x010C) Peripheral Control Register */
} Pmc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- PMC_SCER : (PMC Offset: 0x0000) System Clock Enable Register -------- */
#define PMC_SCER_DDRCK (0x1u << 2) /**< \brief (PMC_SCER) DDR Clock Enable */
#define PMC_SCER_LCDCK (0x1u << 3) /**< \brief (PMC_SCER) LCD2x Clock Enable */
#define PMC_SCER_SMDCK (0x1u << 4) /**< \brief (PMC_SCER) SMD Clock Enable */
#define PMC_SCER_UHP (0x1u << 6) /**< \brief (PMC_SCER) USB Host OHCI Clocks Enable */
#define PMC_SCER_UDP (0x1u << 7) /**< \brief (PMC_SCER) USB Device Clock Enable */
#define PMC_SCER_PCK0 (0x1u << 8) /**< \brief (PMC_SCER) Programmable Clock 0 Output Enable */
#define PMC_SCER_PCK1 (0x1u << 9) /**< \brief (PMC_SCER) Programmable Clock 1 Output Enable */
#define PMC_SCER_PCK2 (0x1u << 10) /**< \brief (PMC_SCER) Programmable Clock 2 Output Enable */
/* -------- PMC_SCDR : (PMC Offset: 0x0004) System Clock Disable Register -------- */
#define PMC_SCDR_PCK (0x1u << 0) /**< \brief (PMC_SCDR) Processor Clock Disable */
#define PMC_SCDR_DDRCK (0x1u << 2) /**< \brief (PMC_SCDR) DDR Clock Disable */
#define PMC_SCDR_LCDCK (0x1u << 3) /**< \brief (PMC_SCDR) LCD2x Clock Disable */
#define PMC_SCDR_SMDCK (0x1u << 4) /**< \brief (PMC_SCDR) SMD Clock Disable */
#define PMC_SCDR_UHP (0x1u << 6) /**< \brief (PMC_SCDR) USB Host OHCI Clock Disable */
#define PMC_SCDR_UDP (0x1u << 7) /**< \brief (PMC_SCDR) USB Device Clock Enable */
#define PMC_SCDR_PCK0 (0x1u << 8) /**< \brief (PMC_SCDR) Programmable Clock 0 Output Disable */
#define PMC_SCDR_PCK1 (0x1u << 9) /**< \brief (PMC_SCDR) Programmable Clock 1 Output Disable */
#define PMC_SCDR_PCK2 (0x1u << 10) /**< \brief (PMC_SCDR) Programmable Clock 2 Output Disable */
/* -------- PMC_SCSR : (PMC Offset: 0x0008) System Clock Status Register -------- */
#define PMC_SCSR_PCK (0x1u << 0) /**< \brief (PMC_SCSR) Processor Clock Status */
#define PMC_SCSR_DDRCK (0x1u << 2) /**< \brief (PMC_SCSR) DDR Clock Status */
#define PMC_SCSR_LCDCK (0x1u << 3) /**< \brief (PMC_SCSR) LCD2x Clock Status */
#define PMC_SCSR_SMDCK (0x1u << 4) /**< \brief (PMC_SCSR) SMD Clock Status */
#define PMC_SCSR_UHP (0x1u << 6) /**< \brief (PMC_SCSR) USB Host Port Clock Status */
#define PMC_SCSR_UDP (0x1u << 7) /**< \brief (PMC_SCSR) USB Device Port Clock Status */
#define PMC_SCSR_PCK0 (0x1u << 8) /**< \brief (PMC_SCSR) Programmable Clock 0 Output Status */
#define PMC_SCSR_PCK1 (0x1u << 9) /**< \brief (PMC_SCSR) Programmable Clock 1 Output Status */
#define PMC_SCSR_PCK2 (0x1u << 10) /**< \brief (PMC_SCSR) Programmable Clock 2 Output Status */
/* -------- PMC_PCER0 : (PMC Offset: 0x0010) Peripheral Clock Enable Register 0 -------- */
#define PMC_PCER0_PID2 (0x1u << 2) /**< \brief (PMC_PCER0) Peripheral Clock 2 Enable */
#define PMC_PCER0_PID3 (0x1u << 3) /**< \brief (PMC_PCER0) Peripheral Clock 3 Enable */
#define PMC_PCER0_PID4 (0x1u << 4) /**< \brief (PMC_PCER0) Peripheral Clock 4 Enable */
#define PMC_PCER0_PID5 (0x1u << 5) /**< \brief (PMC_PCER0) Peripheral Clock 5 Enable */
#define PMC_PCER0_PID6 (0x1u << 6) /**< \brief (PMC_PCER0) Peripheral Clock 6 Enable */
#define PMC_PCER0_PID7 (0x1u << 7) /**< \brief (PMC_PCER0) Peripheral Clock 7 Enable */
#define PMC_PCER0_PID8 (0x1u << 8) /**< \brief (PMC_PCER0) Peripheral Clock 8 Enable */
#define PMC_PCER0_PID9 (0x1u << 9) /**< \brief (PMC_PCER0) Peripheral Clock 9 Enable */
#define PMC_PCER0_PID10 (0x1u << 10) /**< \brief (PMC_PCER0) Peripheral Clock 10 Enable */
#define PMC_PCER0_PID11 (0x1u << 11) /**< \brief (PMC_PCER0) Peripheral Clock 11 Enable */
#define PMC_PCER0_PID12 (0x1u << 12) /**< \brief (PMC_PCER0) Peripheral Clock 12 Enable */
#define PMC_PCER0_PID13 (0x1u << 13) /**< \brief (PMC_PCER0) Peripheral Clock 13 Enable */
#define PMC_PCER0_PID14 (0x1u << 14) /**< \brief (PMC_PCER0) Peripheral Clock 14 Enable */
#define PMC_PCER0_PID15 (0x1u << 15) /**< \brief (PMC_PCER0) Peripheral Clock 15 Enable */
#define PMC_PCER0_PID16 (0x1u << 16) /**< \brief (PMC_PCER0) Peripheral Clock 16 Enable */
#define PMC_PCER0_PID17 (0x1u << 17) /**< \brief (PMC_PCER0) Peripheral Clock 17 Enable */
#define PMC_PCER0_PID18 (0x1u << 18) /**< \brief (PMC_PCER0) Peripheral Clock 18 Enable */
#define PMC_PCER0_PID19 (0x1u << 19) /**< \brief (PMC_PCER0) Peripheral Clock 19 Enable */
#define PMC_PCER0_PID20 (0x1u << 20) /**< \brief (PMC_PCER0) Peripheral Clock 20 Enable */
#define PMC_PCER0_PID21 (0x1u << 21) /**< \brief (PMC_PCER0) Peripheral Clock 21 Enable */
#define PMC_PCER0_PID22 (0x1u << 22) /**< \brief (PMC_PCER0) Peripheral Clock 22 Enable */
#define PMC_PCER0_PID23 (0x1u << 23) /**< \brief (PMC_PCER0) Peripheral Clock 23 Enable */
#define PMC_PCER0_PID24 (0x1u << 24) /**< \brief (PMC_PCER0) Peripheral Clock 24 Enable */
#define PMC_PCER0_PID25 (0x1u << 25) /**< \brief (PMC_PCER0) Peripheral Clock 25 Enable */
#define PMC_PCER0_PID26 (0x1u << 26) /**< \brief (PMC_PCER0) Peripheral Clock 26 Enable */
#define PMC_PCER0_PID27 (0x1u << 27) /**< \brief (PMC_PCER0) Peripheral Clock 27 Enable */
#define PMC_PCER0_PID28 (0x1u << 28) /**< \brief (PMC_PCER0) Peripheral Clock 28 Enable */
#define PMC_PCER0_PID29 (0x1u << 29) /**< \brief (PMC_PCER0) Peripheral Clock 29 Enable */
#define PMC_PCER0_PID30 (0x1u << 30) /**< \brief (PMC_PCER0) Peripheral Clock 30 Enable */
#define PMC_PCER0_PID31 (0x1u << 31) /**< \brief (PMC_PCER0) Peripheral Clock 31 Enable */
/* -------- PMC_PCDR0 : (PMC Offset: 0x0014) Peripheral Clock Disable Register 0 -------- */
#define PMC_PCDR0_PID2 (0x1u << 2) /**< \brief (PMC_PCDR0) Peripheral Clock 2 Disable */
#define PMC_PCDR0_PID3 (0x1u << 3) /**< \brief (PMC_PCDR0) Peripheral Clock 3 Disable */
#define PMC_PCDR0_PID4 (0x1u << 4) /**< \brief (PMC_PCDR0) Peripheral Clock 4 Disable */
#define PMC_PCDR0_PID5 (0x1u << 5) /**< \brief (PMC_PCDR0) Peripheral Clock 5 Disable */
#define PMC_PCDR0_PID6 (0x1u << 6) /**< \brief (PMC_PCDR0) Peripheral Clock 6 Disable */
#define PMC_PCDR0_PID7 (0x1u << 7) /**< \brief (PMC_PCDR0) Peripheral Clock 7 Disable */
#define PMC_PCDR0_PID8 (0x1u << 8) /**< \brief (PMC_PCDR0) Peripheral Clock 8 Disable */
#define PMC_PCDR0_PID9 (0x1u << 9) /**< \brief (PMC_PCDR0) Peripheral Clock 9 Disable */
#define PMC_PCDR0_PID10 (0x1u << 10) /**< \brief (PMC_PCDR0) Peripheral Clock 10 Disable */
#define PMC_PCDR0_PID11 (0x1u << 11) /**< \brief (PMC_PCDR0) Peripheral Clock 11 Disable */
#define PMC_PCDR0_PID12 (0x1u << 12) /**< \brief (PMC_PCDR0) Peripheral Clock 12 Disable */
#define PMC_PCDR0_PID13 (0x1u << 13) /**< \brief (PMC_PCDR0) Peripheral Clock 13 Disable */
#define PMC_PCDR0_PID14 (0x1u << 14) /**< \brief (PMC_PCDR0) Peripheral Clock 14 Disable */
#define PMC_PCDR0_PID15 (0x1u << 15) /**< \brief (PMC_PCDR0) Peripheral Clock 15 Disable */
#define PMC_PCDR0_PID16 (0x1u << 16) /**< \brief (PMC_PCDR0) Peripheral Clock 16 Disable */
#define PMC_PCDR0_PID17 (0x1u << 17) /**< \brief (PMC_PCDR0) Peripheral Clock 17 Disable */
#define PMC_PCDR0_PID18 (0x1u << 18) /**< \brief (PMC_PCDR0) Peripheral Clock 18 Disable */
#define PMC_PCDR0_PID19 (0x1u << 19) /**< \brief (PMC_PCDR0) Peripheral Clock 19 Disable */
#define PMC_PCDR0_PID20 (0x1u << 20) /**< \brief (PMC_PCDR0) Peripheral Clock 20 Disable */
#define PMC_PCDR0_PID21 (0x1u << 21) /**< \brief (PMC_PCDR0) Peripheral Clock 21 Disable */
#define PMC_PCDR0_PID22 (0x1u << 22) /**< \brief (PMC_PCDR0) Peripheral Clock 22 Disable */
#define PMC_PCDR0_PID23 (0x1u << 23) /**< \brief (PMC_PCDR0) Peripheral Clock 23 Disable */
#define PMC_PCDR0_PID24 (0x1u << 24) /**< \brief (PMC_PCDR0) Peripheral Clock 24 Disable */
#define PMC_PCDR0_PID25 (0x1u << 25) /**< \brief (PMC_PCDR0) Peripheral Clock 25 Disable */
#define PMC_PCDR0_PID26 (0x1u << 26) /**< \brief (PMC_PCDR0) Peripheral Clock 26 Disable */
#define PMC_PCDR0_PID27 (0x1u << 27) /**< \brief (PMC_PCDR0) Peripheral Clock 27 Disable */
#define PMC_PCDR0_PID28 (0x1u << 28) /**< \brief (PMC_PCDR0) Peripheral Clock 28 Disable */
#define PMC_PCDR0_PID29 (0x1u << 29) /**< \brief (PMC_PCDR0) Peripheral Clock 29 Disable */
#define PMC_PCDR0_PID30 (0x1u << 30) /**< \brief (PMC_PCDR0) Peripheral Clock 30 Disable */
#define PMC_PCDR0_PID31 (0x1u << 31) /**< \brief (PMC_PCDR0) Peripheral Clock 31 Disable */
/* -------- PMC_PCSR0 : (PMC Offset: 0x0018) Peripheral Clock Status Register 0 -------- */
#define PMC_PCSR0_PID2 (0x1u << 2) /**< \brief (PMC_PCSR0) Peripheral Clock 2 Status */
#define PMC_PCSR0_PID3 (0x1u << 3) /**< \brief (PMC_PCSR0) Peripheral Clock 3 Status */
#define PMC_PCSR0_PID4 (0x1u << 4) /**< \brief (PMC_PCSR0) Peripheral Clock 4 Status */
#define PMC_PCSR0_PID5 (0x1u << 5) /**< \brief (PMC_PCSR0) Peripheral Clock 5 Status */
#define PMC_PCSR0_PID6 (0x1u << 6) /**< \brief (PMC_PCSR0) Peripheral Clock 6 Status */
#define PMC_PCSR0_PID7 (0x1u << 7) /**< \brief (PMC_PCSR0) Peripheral Clock 7 Status */
#define PMC_PCSR0_PID8 (0x1u << 8) /**< \brief (PMC_PCSR0) Peripheral Clock 8 Status */
#define PMC_PCSR0_PID9 (0x1u << 9) /**< \brief (PMC_PCSR0) Peripheral Clock 9 Status */
#define PMC_PCSR0_PID10 (0x1u << 10) /**< \brief (PMC_PCSR0) Peripheral Clock 10 Status */
#define PMC_PCSR0_PID11 (0x1u << 11) /**< \brief (PMC_PCSR0) Peripheral Clock 11 Status */
#define PMC_PCSR0_PID12 (0x1u << 12) /**< \brief (PMC_PCSR0) Peripheral Clock 12 Status */
#define PMC_PCSR0_PID13 (0x1u << 13) /**< \brief (PMC_PCSR0) Peripheral Clock 13 Status */
#define PMC_PCSR0_PID14 (0x1u << 14) /**< \brief (PMC_PCSR0) Peripheral Clock 14 Status */
#define PMC_PCSR0_PID15 (0x1u << 15) /**< \brief (PMC_PCSR0) Peripheral Clock 15 Status */
#define PMC_PCSR0_PID16 (0x1u << 16) /**< \brief (PMC_PCSR0) Peripheral Clock 16 Status */
#define PMC_PCSR0_PID17 (0x1u << 17) /**< \brief (PMC_PCSR0) Peripheral Clock 17 Status */
#define PMC_PCSR0_PID18 (0x1u << 18) /**< \brief (PMC_PCSR0) Peripheral Clock 18 Status */
#define PMC_PCSR0_PID19 (0x1u << 19) /**< \brief (PMC_PCSR0) Peripheral Clock 19 Status */
#define PMC_PCSR0_PID20 (0x1u << 20) /**< \brief (PMC_PCSR0) Peripheral Clock 20 Status */
#define PMC_PCSR0_PID21 (0x1u << 21) /**< \brief (PMC_PCSR0) Peripheral Clock 21 Status */
#define PMC_PCSR0_PID22 (0x1u << 22) /**< \brief (PMC_PCSR0) Peripheral Clock 22 Status */
#define PMC_PCSR0_PID23 (0x1u << 23) /**< \brief (PMC_PCSR0) Peripheral Clock 23 Status */
#define PMC_PCSR0_PID24 (0x1u << 24) /**< \brief (PMC_PCSR0) Peripheral Clock 24 Status */
#define PMC_PCSR0_PID25 (0x1u << 25) /**< \brief (PMC_PCSR0) Peripheral Clock 25 Status */
#define PMC_PCSR0_PID26 (0x1u << 26) /**< \brief (PMC_PCSR0) Peripheral Clock 26 Status */
#define PMC_PCSR0_PID27 (0x1u << 27) /**< \brief (PMC_PCSR0) Peripheral Clock 27 Status */
#define PMC_PCSR0_PID28 (0x1u << 28) /**< \brief (PMC_PCSR0) Peripheral Clock 28 Status */
#define PMC_PCSR0_PID29 (0x1u << 29) /**< \brief (PMC_PCSR0) Peripheral Clock 29 Status */
#define PMC_PCSR0_PID30 (0x1u << 30) /**< \brief (PMC_PCSR0) Peripheral Clock 30 Status */
#define PMC_PCSR0_PID31 (0x1u << 31) /**< \brief (PMC_PCSR0) Peripheral Clock 31 Status */
/* -------- CKGR_UCKR : (PMC Offset: 0x001C) UTMI Clock Register -------- */
#define CKGR_UCKR_UPLLEN (0x1u << 16) /**< \brief (CKGR_UCKR) UTMI PLL Enable */
#define CKGR_UCKR_UPLLCOUNT_Pos 20
#define CKGR_UCKR_UPLLCOUNT_Msk (0xfu << CKGR_UCKR_UPLLCOUNT_Pos) /**< \brief (CKGR_UCKR) UTMI PLL Start-up Time */
#define CKGR_UCKR_UPLLCOUNT(value) ((CKGR_UCKR_UPLLCOUNT_Msk & ((value) << CKGR_UCKR_UPLLCOUNT_Pos)))
#define CKGR_UCKR_BIASEN (0x1u << 24) /**< \brief (CKGR_UCKR) UTMI BIAS Enable */
#define CKGR_UCKR_BIASCOUNT_Pos 28
#define CKGR_UCKR_BIASCOUNT_Msk (0xfu << CKGR_UCKR_BIASCOUNT_Pos) /**< \brief (CKGR_UCKR) UTMI BIAS Start-up Time */
#define CKGR_UCKR_BIASCOUNT(value) ((CKGR_UCKR_BIASCOUNT_Msk & ((value) << CKGR_UCKR_BIASCOUNT_Pos)))
/* -------- CKGR_MOR : (PMC Offset: 0x0020) Main Oscillator Register -------- */
#define CKGR_MOR_MOSCXTEN (0x1u << 0) /**< \brief (CKGR_MOR) Main Crystal Oscillator Enable */
#define CKGR_MOR_MOSCXTBY (0x1u << 1) /**< \brief (CKGR_MOR) Main Crystal Oscillator Bypass */
#define CKGR_MOR_MOSCXTST_Pos 8
#define CKGR_MOR_MOSCXTST_Msk (0xffu << CKGR_MOR_MOSCXTST_Pos) /**< \brief (CKGR_MOR) Main Crystal Oscillator Startup Time */
#define CKGR_MOR_MOSCXTST(value) ((CKGR_MOR_MOSCXTST_Msk & ((value) << CKGR_MOR_MOSCXTST_Pos)))
#define CKGR_MOR_KEY_Pos 16
#define CKGR_MOR_KEY_Msk (0xffu << CKGR_MOR_KEY_Pos) /**< \brief (CKGR_MOR) Password */
#define   CKGR_MOR_KEY_PASSWD (0x37u << 16) /**< \brief (CKGR_MOR) Writing any other value in this field aborts the write operation. */
#define CKGR_MOR_MOSCSEL (0x1u << 24) /**< \brief (CKGR_MOR) Main Oscillator Selection */
#define CKGR_MOR_CFDEN (0x1u << 25) /**< \brief (CKGR_MOR) Clock Failure Detector Enable */
/* -------- CKGR_MCFR : (PMC Offset: 0x0024) Main Clock Frequency Register -------- */
#define CKGR_MCFR_MAINF_Pos 0
#define CKGR_MCFR_MAINF_Msk (0xffffu << CKGR_MCFR_MAINF_Pos) /**< \brief (CKGR_MCFR) Main Clock Frequency */
#define CKGR_MCFR_MAINFRDY (0x1u << 16) /**< \brief (CKGR_MCFR) Main Clock Ready */
/* -------- CKGR_PLLAR : (PMC Offset: 0x0028) PLLA Register -------- */
#define CKGR_PLLAR_PLLACOUNT_Pos 8
#define CKGR_PLLAR_PLLACOUNT_Msk (0x3fu << CKGR_PLLAR_PLLACOUNT_Pos) /**< \brief (CKGR_PLLAR) PLLA Counter */
#define CKGR_PLLAR_PLLACOUNT(value) ((CKGR_PLLAR_PLLACOUNT_Msk & ((value) << CKGR_PLLAR_PLLACOUNT_Pos)))
#define CKGR_PLLAR_OUTA_Pos 14
#define CKGR_PLLAR_OUTA_Msk (0xfu << CKGR_PLLAR_OUTA_Pos) /**< \brief (CKGR_PLLAR) PLLA Clock Frequency Range */
#define CKGR_PLLAR_OUTA(value) ((CKGR_PLLAR_OUTA_Msk & ((value) << CKGR_PLLAR_OUTA_Pos)))
#define CKGR_PLLAR_MULA_Pos 18
#define CKGR_PLLAR_MULA_Msk (0x7fu << CKGR_PLLAR_MULA_Pos) /**< \brief (CKGR_PLLAR) PLLA Multiplier */
#define CKGR_PLLAR_MULA(value) ((CKGR_PLLAR_MULA_Msk & ((value) << CKGR_PLLAR_MULA_Pos)))
#define CKGR_PLLAR_ONE (0x1u << 29) /**< \brief (CKGR_PLLAR) Must Be Set to 1 */
/* -------- PMC_MCKR : (PMC Offset: 0x0030) Master Clock Register -------- */
#define PMC_MCKR_CSS_Pos 0
#define PMC_MCKR_CSS_Msk (0x3u << PMC_MCKR_CSS_Pos) /**< \brief (PMC_MCKR) Master/Processor Clock Source Selection */
#define   PMC_MCKR_CSS_SLOW_CLK (0x0u << 0) /**< \brief (PMC_MCKR) Slow Clock is selected */
#define   PMC_MCKR_CSS_MAIN_CLK (0x1u << 0) /**< \brief (PMC_MCKR) Main Clock is selected */
#define   PMC_MCKR_CSS_PLLA_CLK (0x2u << 0) /**< \brief (PMC_MCKR) PLLACK is selected */
#define   PMC_MCKR_CSS_UPLL_CLK (0x3u << 0) /**< \brief (PMC_MCKR) UPLL Clock is selected */
#define PMC_MCKR_PRES_Pos 4
#define PMC_MCKR_PRES_Msk (0x7u << PMC_MCKR_PRES_Pos) /**< \brief (PMC_MCKR) Master/Processor Clock Prescaler */
#define   PMC_MCKR_PRES_CLOCK (0x0u << 4) /**< \brief (PMC_MCKR) Selected clock */
#define   PMC_MCKR_PRES_CLOCK_DIV2 (0x1u << 4) /**< \brief (PMC_MCKR) Selected clock divided by 2 */
#define   PMC_MCKR_PRES_CLOCK_DIV4 (0x2u << 4) /**< \brief (PMC_MCKR) Selected clock divided by 4 */
#define   PMC_MCKR_PRES_CLOCK_DIV8 (0x3u << 4) /**< \brief (PMC_MCKR) Selected clock divided by 8 */
#define   PMC_MCKR_PRES_CLOCK_DIV16 (0x4u << 4) /**< \brief (PMC_MCKR) Selected clock divided by 16 */
#define   PMC_MCKR_PRES_CLOCK_DIV32 (0x5u << 4) /**< \brief (PMC_MCKR) Selected clock divided by 32 */
#define   PMC_MCKR_PRES_CLOCK_DIV64 (0x6u << 4) /**< \brief (PMC_MCKR) Selected clock divided by 64 */
#define PMC_MCKR_MDIV_Pos 8
#define PMC_MCKR_MDIV_Msk (0x3u << PMC_MCKR_MDIV_Pos) /**< \brief (PMC_MCKR) Master Clock Division */
#define   PMC_MCKR_MDIV_EQ_PCK (0x0u << 8) /**< \brief (PMC_MCKR) Master Clock is Prescaler Output Clock divided by 1.Warning: SysClk DDR and DDRCK are not available. */
#define   PMC_MCKR_MDIV_PCK_DIV2 (0x1u << 8) /**< \brief (PMC_MCKR) Master Clock is Prescaler Output Clock divided by 2.SysClk DDR is equal to 2 x MCK. DDRCK is equal to MCK. */
#define   PMC_MCKR_MDIV_PCK_DIV4 (0x2u << 8) /**< \brief (PMC_MCKR) Master Clock is Prescaler Output Clock divided by 4.SysClk DDR is equal to 2 x MCK. DDRCK is equal to MCK. */
#define   PMC_MCKR_MDIV_PCK_DIV3 (0x3u << 8) /**< \brief (PMC_MCKR) Master Clock is Prescaler Output Clock divided by 3.SysClk DDR is equal to 2 x MCK. DDRCK is equal to MCK. */
#define PMC_MCKR_PLLADIV2 (0x1u << 12) /**< \brief (PMC_MCKR) PLLA Divisor by 2 */
#define PMC_MCKR_H32MXDIV (0x1u << 24) /**< \brief (PMC_MCKR) AHB 32-bit Matrix Divisor */
#define   PMC_MCKR_H32MXDIV_H32MXDIV1 (0x0u << 24) /**< \brief (PMC_MCKR) The AHB 32-bit Matrix frequency is equal to the AHB 64-bit Matrix frequency. It is possible only if the AHB 64-bit Matrix frequency is not exceeding 90 MHz. */
#define   PMC_MCKR_H32MXDIV_H32MXDIV2 (0x1u << 24) /**< \brief (PMC_MCKR) The AHB 32-bit Matrix frequency is equal to the AHB 64-bit Matrix frequency divided by 2. */
/* -------- PMC_USB : (PMC Offset: 0x0038) USB Clock Register -------- */
#define PMC_USB_USBS (0x1u << 0) /**< \brief (PMC_USB) USB OHCI Input clock selection */
#define PMC_USB_USBDIV_Pos 8
#define PMC_USB_USBDIV_Msk (0xfu << PMC_USB_USBDIV_Pos) /**< \brief (PMC_USB) Divider for USB OHCI Clock. */
#define PMC_USB_USBDIV(value) ((PMC_USB_USBDIV_Msk & ((value) << PMC_USB_USBDIV_Pos)))
/* -------- PMC_SMD : (PMC Offset: 0x003C) Soft Modem Clock Register -------- */
#define PMC_SMD_SMDS (0x1u << 0) /**< \brief (PMC_SMD) SMD input clock selection */
#define PMC_SMD_SMDDIV_Pos 8
#define PMC_SMD_SMDDIV_Msk (0x1fu << PMC_SMD_SMDDIV_Pos) /**< \brief (PMC_SMD) Divider for SMD Clock. */
#define PMC_SMD_SMDDIV(value) ((PMC_SMD_SMDDIV_Msk & ((value) << PMC_SMD_SMDDIV_Pos)))
/* -------- PMC_PCK[3] : (PMC Offset: 0x0040) Programmable Clock 0 Register -------- */
#define PMC_PCK_CSS_Pos 0
#define PMC_PCK_CSS_Msk (0x7u << PMC_PCK_CSS_Pos) /**< \brief (PMC_PCK[3]) Master Clock Source Selection */
#define   PMC_PCK_CSS_SLOW_CLK (0x0u << 0) /**< \brief (PMC_PCK[3]) Slow Clock is selected */
#define   PMC_PCK_CSS_MAIN_CLK (0x1u << 0) /**< \brief (PMC_PCK[3]) Main Clock is selected */
#define   PMC_PCK_CSS_PLLA_CLK (0x2u << 0) /**< \brief (PMC_PCK[3]) PLLACK is selected */
#define   PMC_PCK_CSS_UPLL_CLK (0x3u << 0) /**< \brief (PMC_PCK[3]) UPLL Clock is selected */
#define   PMC_PCK_CSS_MCK_CLK (0x4u << 0) /**< \brief (PMC_PCK[3]) Master Clock is selected */
#define PMC_PCK_PRES_Pos 4
#define PMC_PCK_PRES_Msk (0x7u << PMC_PCK_PRES_Pos) /**< \brief (PMC_PCK[3]) Programmable Clock Prescaler */
#define   PMC_PCK_PRES_CLOCK (0x0u << 4) /**< \brief (PMC_PCK[3]) Selected clock */
#define   PMC_PCK_PRES_CLOCK_DIV2 (0x1u << 4) /**< \brief (PMC_PCK[3]) Selected clock divided by 2 */
#define   PMC_PCK_PRES_CLOCK_DIV4 (0x2u << 4) /**< \brief (PMC_PCK[3]) Selected clock divided by 4 */
#define   PMC_PCK_PRES_CLOCK_DIV8 (0x3u << 4) /**< \brief (PMC_PCK[3]) Selected clock divided by 8 */
#define   PMC_PCK_PRES_CLOCK_DIV16 (0x4u << 4) /**< \brief (PMC_PCK[3]) Selected clock divided by 16 */
#define   PMC_PCK_PRES_CLOCK_DIV32 (0x5u << 4) /**< \brief (PMC_PCK[3]) Selected clock divided by 32 */
#define   PMC_PCK_PRES_CLOCK_DIV64 (0x6u << 4) /**< \brief (PMC_PCK[3]) Selected clock divided by 64 */
/* -------- PMC_IER : (PMC Offset: 0x0060) Interrupt Enable Register -------- */
#define PMC_IER_MOSCXTS (0x1u << 0) /**< \brief (PMC_IER) Main Crystal Oscillator Status Interrupt Enable */
#define PMC_IER_LOCKA (0x1u << 1) /**< \brief (PMC_IER) PLLA Lock Interrupt Enable */
#define PMC_IER_MCKRDY (0x1u << 3) /**< \brief (PMC_IER) Master Clock Ready Interrupt Enable */
#define PMC_IER_LOCKU (0x1u << 6) /**< \brief (PMC_IER) UTMI PLL Lock Interrupt Enable */
#define PMC_IER_PCKRDY0 (0x1u << 8) /**< \brief (PMC_IER) Programmable Clock Ready 0 Interrupt Enable */
#define PMC_IER_PCKRDY1 (0x1u << 9) /**< \brief (PMC_IER) Programmable Clock Ready 1 Interrupt Enable */
#define PMC_IER_PCKRDY2 (0x1u << 10) /**< \brief (PMC_IER) Programmable Clock Ready 2 Interrupt Enable */
#define PMC_IER_MOSCSELS (0x1u << 16) /**< \brief (PMC_IER) Main Oscillator Selection Status Interrupt Enable */
#define PMC_IER_MOSCRCS (0x1u << 17) /**< \brief (PMC_IER) Main On-Chip RC Status Interrupt Enable */
#define PMC_IER_CFDEV (0x1u << 18) /**< \brief (PMC_IER) Clock Failure Detector Event Interrupt Enable */
/* -------- PMC_IDR : (PMC Offset: 0x0064) Interrupt Disable Register -------- */
#define PMC_IDR_MOSCXTS (0x1u << 0) /**< \brief (PMC_IDR) Main Crystal Oscillator Status Interrupt Disable */
#define PMC_IDR_LOCKA (0x1u << 1) /**< \brief (PMC_IDR) PLLA Lock Interrupt Disable */
#define PMC_IDR_MCKRDY (0x1u << 3) /**< \brief (PMC_IDR) Master Clock Ready Interrupt Disable */
#define PMC_IDR_LOCKU (0x1u << 6) /**< \brief (PMC_IDR) UTMI PLL Lock Interrupt Enable */
#define PMC_IDR_PCKRDY0 (0x1u << 8) /**< \brief (PMC_IDR) Programmable Clock Ready 0 Interrupt Disable */
#define PMC_IDR_PCKRDY1 (0x1u << 9) /**< \brief (PMC_IDR) Programmable Clock Ready 1 Interrupt Disable */
#define PMC_IDR_PCKRDY2 (0x1u << 10) /**< \brief (PMC_IDR) Programmable Clock Ready 2 Interrupt Disable */
#define PMC_IDR_MOSCSELS (0x1u << 16) /**< \brief (PMC_IDR) Main Oscillator Selection Status Interrupt Disable */
#define PMC_IDR_MOSCRCS (0x1u << 17) /**< \brief (PMC_IDR) Main On-Chip RC Status Interrupt Disable */
#define PMC_IDR_CFDEV (0x1u << 18) /**< \brief (PMC_IDR) Clock Failure Detector Event Interrupt Disable */
/* -------- PMC_SR : (PMC Offset: 0x0068) Status Register -------- */
#define PMC_SR_MOSCXTS (0x1u << 0) /**< \brief (PMC_SR) Main XTAL Oscillator Status */
#define PMC_SR_LOCKA (0x1u << 1) /**< \brief (PMC_SR) PLLA Lock Status */
#define PMC_SR_MCKRDY (0x1u << 3) /**< \brief (PMC_SR) Master Clock Status */
#define PMC_SR_LOCKU (0x1u << 6) /**< \brief (PMC_SR) UPLL Clock Status */
#define PMC_SR_OSCSELS (0x1u << 7) /**< \brief (PMC_SR) Slow Clock Oscillator Selection */
#define PMC_SR_PCKRDY0 (0x1u << 8) /**< \brief (PMC_SR) Programmable Clock Ready Status */
#define PMC_SR_PCKRDY1 (0x1u << 9) /**< \brief (PMC_SR) Programmable Clock Ready Status */
#define PMC_SR_PCKRDY2 (0x1u << 10) /**< \brief (PMC_SR) Programmable Clock Ready Status */
#define PMC_SR_MOSCSELS (0x1u << 16) /**< \brief (PMC_SR) Main Oscillator Selection Status */
#define PMC_SR_MOSCRCS (0x1u << 17) /**< \brief (PMC_SR) Main On-Chip RC Oscillator Status */
#define PMC_SR_CFDEV (0x1u << 18) /**< \brief (PMC_SR) Clock Failure Detector Event */
#define PMC_SR_CFDS (0x1u << 19) /**< \brief (PMC_SR) Clock Failure Detector Status */
#define PMC_SR_FOS (0x1u << 20) /**< \brief (PMC_SR) Clock Failure Detector Fault Output Status */
/* -------- PMC_IMR : (PMC Offset: 0x006C) Interrupt Mask Register -------- */
#define PMC_IMR_MOSCXTS (0x1u << 0) /**< \brief (PMC_IMR) Main Crystal Oscillator Status Interrupt Mask */
#define PMC_IMR_LOCKA (0x1u << 1) /**< \brief (PMC_IMR) PLLA Lock Interrupt Mask */
#define PMC_IMR_MCKRDY (0x1u << 3) /**< \brief (PMC_IMR) Master Clock Ready Interrupt Mask */
#define PMC_IMR_PCKRDY0 (0x1u << 8) /**< \brief (PMC_IMR) Programmable Clock Ready 0 Interrupt Mask */
#define PMC_IMR_PCKRDY1 (0x1u << 9) /**< \brief (PMC_IMR) Programmable Clock Ready 1 Interrupt Mask */
#define PMC_IMR_PCKRDY2 (0x1u << 10) /**< \brief (PMC_IMR) Programmable Clock Ready 2 Interrupt Mask */
#define PMC_IMR_MOSCSELS (0x1u << 16) /**< \brief (PMC_IMR) Main Oscillator Selection Status Interrupt Mask */
#define PMC_IMR_MOSCRCS (0x1u << 17) /**< \brief (PMC_IMR) Main On-Chip RC Status Interrupt Mask */
#define PMC_IMR_CFDEV (0x1u << 18) /**< \brief (PMC_IMR) Clock Failure Detector Event Interrupt Mask */
/* -------- PMC_FOCR : (PMC Offset: 0x0078) Fault Output Clear Register -------- */
#define PMC_FOCR_FOCLR (0x1u << 0) /**< \brief (PMC_FOCR) Fault Output Clear */
/* -------- PMC_PLLICPR : (PMC Offset: 0x0080) PLL Charge Pump Current Register -------- */
#define PMC_PLLICPR_ICP_PLLA_Pos 0
#define PMC_PLLICPR_ICP_PLLA_Msk (0x3u << PMC_PLLICPR_ICP_PLLA_Pos) /**< \brief (PMC_PLLICPR) Charge Pump Current PLLA */
#define PMC_PLLICPR_ICP_PLLA(value) ((PMC_PLLICPR_ICP_PLLA_Msk & ((value) << PMC_PLLICPR_ICP_PLLA_Pos)))
#define PMC_PLLICPR_IPLL_PLLA_Pos 8
#define PMC_PLLICPR_IPLL_PLLA_Msk (0x7u << PMC_PLLICPR_IPLL_PLLA_Pos) /**< \brief (PMC_PLLICPR) Engineering Configuration PLLA */
#define PMC_PLLICPR_IPLL_PLLA(value) ((PMC_PLLICPR_IPLL_PLLA_Msk & ((value) << PMC_PLLICPR_IPLL_PLLA_Pos)))
#define PMC_PLLICPR_ICP_PLLU_Pos 16
#define PMC_PLLICPR_ICP_PLLU_Msk (0x3u << PMC_PLLICPR_ICP_PLLU_Pos) /**< \brief (PMC_PLLICPR) Charge Pump Current PLL UTMI */
#define PMC_PLLICPR_ICP_PLLU(value) ((PMC_PLLICPR_ICP_PLLU_Msk & ((value) << PMC_PLLICPR_ICP_PLLU_Pos)))
#define PMC_PLLICPR_IVCO_PLLU_Pos 24
#define PMC_PLLICPR_IVCO_PLLU_Msk (0x3u << PMC_PLLICPR_IVCO_PLLU_Pos) /**< \brief (PMC_PLLICPR) Voltage Control Output Current PLL UTMI */
#define PMC_PLLICPR_IVCO_PLLU(value) ((PMC_PLLICPR_IVCO_PLLU_Msk & ((value) << PMC_PLLICPR_IVCO_PLLU_Pos)))
/* -------- PMC_WPMR : (PMC Offset: 0x00E4) Write Protect Mode Register -------- */
#define PMC_WPMR_WPEN (0x1u << 0) /**< \brief (PMC_WPMR) Write Protect Enable */
#define PMC_WPMR_WPKEY_Pos 8
#define PMC_WPMR_WPKEY_Msk (0xffffffu << PMC_WPMR_WPKEY_Pos) /**< \brief (PMC_WPMR) Write Protect KEY */
#define   PMC_WPMR_WPKEY_PASSWD (0x504D43u << 8) /**< \brief (PMC_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0. */
/* -------- PMC_WPSR : (PMC Offset: 0x00E8) Write Protect Status Register -------- */
#define PMC_WPSR_WPVS (0x1u << 0) /**< \brief (PMC_WPSR) Write Protect Violation Status */
#define PMC_WPSR_WPVSRC_Pos 8
#define PMC_WPSR_WPVSRC_Msk (0xffffu << PMC_WPSR_WPVSRC_Pos) /**< \brief (PMC_WPSR) Write Protect Violation Source */
/* -------- PMC_PCER1 : (PMC Offset: 0x0100) Peripheral Clock Enable Register 1 -------- */
#define PMC_PCER1_PID32 (0x1u << 0) /**< \brief (PMC_PCER1) Peripheral Clock 32 Enable */
#define PMC_PCER1_PID33 (0x1u << 1) /**< \brief (PMC_PCER1) Peripheral Clock 33 Enable */
#define PMC_PCER1_PID34 (0x1u << 2) /**< \brief (PMC_PCER1) Peripheral Clock 34 Enable */
#define PMC_PCER1_PID35 (0x1u << 3) /**< \brief (PMC_PCER1) Peripheral Clock 35 Enable */
#define PMC_PCER1_PID36 (0x1u << 4) /**< \brief (PMC_PCER1) Peripheral Clock 36 Enable */
#define PMC_PCER1_PID37 (0x1u << 5) /**< \brief (PMC_PCER1) Peripheral Clock 37 Enable */
#define PMC_PCER1_PID38 (0x1u << 6) /**< \brief (PMC_PCER1) Peripheral Clock 38 Enable */
#define PMC_PCER1_PID39 (0x1u << 7) /**< \brief (PMC_PCER1) Peripheral Clock 39 Enable */
#define PMC_PCER1_PID40 (0x1u << 8) /**< \brief (PMC_PCER1) Peripheral Clock 40 Enable */
#define PMC_PCER1_PID41 (0x1u << 9) /**< \brief (PMC_PCER1) Peripheral Clock 41 Enable */
#define PMC_PCER1_PID42 (0x1u << 10) /**< \brief (PMC_PCER1) Peripheral Clock 42 Enable */
#define PMC_PCER1_PID43 (0x1u << 11) /**< \brief (PMC_PCER1) Peripheral Clock 43 Enable */
#define PMC_PCER1_PID44 (0x1u << 12) /**< \brief (PMC_PCER1) Peripheral Clock 44 Enable */
#define PMC_PCER1_PID45 (0x1u << 13) /**< \brief (PMC_PCER1) Peripheral Clock 45 Enable */
#define PMC_PCER1_PID46 (0x1u << 14) /**< \brief (PMC_PCER1) Peripheral Clock 46 Enable */
#define PMC_PCER1_PID47 (0x1u << 15) /**< \brief (PMC_PCER1) Peripheral Clock 47 Enable */
#define PMC_PCER1_PID48 (0x1u << 16) /**< \brief (PMC_PCER1) Peripheral Clock 48 Enable */
#define PMC_PCER1_PID49 (0x1u << 17) /**< \brief (PMC_PCER1) Peripheral Clock 49 Enable */
#define PMC_PCER1_PID50 (0x1u << 18) /**< \brief (PMC_PCER1) Peripheral Clock 50 Enable */
#define PMC_PCER1_PID51 (0x1u << 19) /**< \brief (PMC_PCER1) Peripheral Clock 51 Enable */
#define PMC_PCER1_PID52 (0x1u << 20) /**< \brief (PMC_PCER1) Peripheral Clock 52 Enable */
#define PMC_PCER1_PID53 (0x1u << 21) /**< \brief (PMC_PCER1) Peripheral Clock 53 Enable */
#define PMC_PCER1_PID54 (0x1u << 22) /**< \brief (PMC_PCER1) Peripheral Clock 54 Enable */
#define PMC_PCER1_PID55 (0x1u << 23) /**< \brief (PMC_PCER1) Peripheral Clock 55 Enable */
#define PMC_PCER1_PID56 (0x1u << 24) /**< \brief (PMC_PCER1) Peripheral Clock 56 Enable */
#define PMC_PCER1_PID57 (0x1u << 25) /**< \brief (PMC_PCER1) Peripheral Clock 57 Enable */
#define PMC_PCER1_PID58 (0x1u << 26) /**< \brief (PMC_PCER1) Peripheral Clock 58 Enable */
#define PMC_PCER1_PID59 (0x1u << 27) /**< \brief (PMC_PCER1) Peripheral Clock 59 Enable */
#define PMC_PCER1_PID60 (0x1u << 28) /**< \brief (PMC_PCER1) Peripheral Clock 60 Enable */
#define PMC_PCER1_PID61 (0x1u << 29) /**< \brief (PMC_PCER1) Peripheral Clock 61 Enable */
#define PMC_PCER1_PID62 (0x1u << 30) /**< \brief (PMC_PCER1) Peripheral Clock 62 Enable */
#define PMC_PCER1_PID63 (0x1u << 31) /**< \brief (PMC_PCER1) Peripheral Clock 63 Enable */
/* -------- PMC_PCDR1 : (PMC Offset: 0x0104) Peripheral Clock Disable Register 1 -------- */
#define PMC_PCDR1_PID32 (0x1u << 0) /**< \brief (PMC_PCDR1) Peripheral Clock 32 Disable */
#define PMC_PCDR1_PID33 (0x1u << 1) /**< \brief (PMC_PCDR1) Peripheral Clock 33 Disable */
#define PMC_PCDR1_PID34 (0x1u << 2) /**< \brief (PMC_PCDR1) Peripheral Clock 34 Disable */
#define PMC_PCDR1_PID35 (0x1u << 3) /**< \brief (PMC_PCDR1) Peripheral Clock 35 Disable */
#define PMC_PCDR1_PID36 (0x1u << 4) /**< \brief (PMC_PCDR1) Peripheral Clock 36 Disable */
#define PMC_PCDR1_PID37 (0x1u << 5) /**< \brief (PMC_PCDR1) Peripheral Clock 37 Disable */
#define PMC_PCDR1_PID38 (0x1u << 6) /**< \brief (PMC_PCDR1) Peripheral Clock 38 Disable */
#define PMC_PCDR1_PID39 (0x1u << 7) /**< \brief (PMC_PCDR1) Peripheral Clock 39 Disable */
#define PMC_PCDR1_PID40 (0x1u << 8) /**< \brief (PMC_PCDR1) Peripheral Clock 40 Disable */
#define PMC_PCDR1_PID41 (0x1u << 9) /**< \brief (PMC_PCDR1) Peripheral Clock 41 Disable */
#define PMC_PCDR1_PID42 (0x1u << 10) /**< \brief (PMC_PCDR1) Peripheral Clock 42 Disable */
#define PMC_PCDR1_PID43 (0x1u << 11) /**< \brief (PMC_PCDR1) Peripheral Clock 43 Disable */
#define PMC_PCDR1_PID44 (0x1u << 12) /**< \brief (PMC_PCDR1) Peripheral Clock 44 Disable */
#define PMC_PCDR1_PID45 (0x1u << 13) /**< \brief (PMC_PCDR1) Peripheral Clock 45 Disable */
#define PMC_PCDR1_PID46 (0x1u << 14) /**< \brief (PMC_PCDR1) Peripheral Clock 46 Disable */
#define PMC_PCDR1_PID47 (0x1u << 15) /**< \brief (PMC_PCDR1) Peripheral Clock 47 Disable */
#define PMC_PCDR1_PID48 (0x1u << 16) /**< \brief (PMC_PCDR1) Peripheral Clock 48 Disable */
#define PMC_PCDR1_PID49 (0x1u << 17) /**< \brief (PMC_PCDR1) Peripheral Clock 49 Disable */
#define PMC_PCDR1_PID50 (0x1u << 18) /**< \brief (PMC_PCDR1) Peripheral Clock 50 Disable */
#define PMC_PCDR1_PID51 (0x1u << 19) /**< \brief (PMC_PCDR1) Peripheral Clock 51 Disable */
#define PMC_PCDR1_PID52 (0x1u << 20) /**< \brief (PMC_PCDR1) Peripheral Clock 52 Disable */
#define PMC_PCDR1_PID53 (0x1u << 21) /**< \brief (PMC_PCDR1) Peripheral Clock 53 Disable */
#define PMC_PCDR1_PID54 (0x1u << 22) /**< \brief (PMC_PCDR1) Peripheral Clock 54 Disable */
#define PMC_PCDR1_PID55 (0x1u << 23) /**< \brief (PMC_PCDR1) Peripheral Clock 55 Disable */
#define PMC_PCDR1_PID56 (0x1u << 24) /**< \brief (PMC_PCDR1) Peripheral Clock 56 Disable */
#define PMC_PCDR1_PID57 (0x1u << 25) /**< \brief (PMC_PCDR1) Peripheral Clock 57 Disable */
#define PMC_PCDR1_PID58 (0x1u << 26) /**< \brief (PMC_PCDR1) Peripheral Clock 58 Disable */
#define PMC_PCDR1_PID59 (0x1u << 27) /**< \brief (PMC_PCDR1) Peripheral Clock 59 Disable */
#define PMC_PCDR1_PID60 (0x1u << 28) /**< \brief (PMC_PCDR1) Peripheral Clock 60 Disable */
#define PMC_PCDR1_PID61 (0x1u << 29) /**< \brief (PMC_PCDR1) Peripheral Clock 61 Disable */
#define PMC_PCDR1_PID62 (0x1u << 30) /**< \brief (PMC_PCDR1) Peripheral Clock 62 Disable */
#define PMC_PCDR1_PID63 (0x1u << 31) /**< \brief (PMC_PCDR1) Peripheral Clock 63 Disable */
/* -------- PMC_PCSR1 : (PMC Offset: 0x0108) Peripheral Clock Status Register 1 -------- */
#define PMC_PCSR1_PID32 (0x1u << 0) /**< \brief (PMC_PCSR1) Peripheral Clock 32 Status */
#define PMC_PCSR1_PID33 (0x1u << 1) /**< \brief (PMC_PCSR1) Peripheral Clock 33 Status */
#define PMC_PCSR1_PID34 (0x1u << 2) /**< \brief (PMC_PCSR1) Peripheral Clock 34 Status */
#define PMC_PCSR1_PID35 (0x1u << 3) /**< \brief (PMC_PCSR1) Peripheral Clock 35 Status */
#define PMC_PCSR1_PID36 (0x1u << 4) /**< \brief (PMC_PCSR1) Peripheral Clock 36 Status */
#define PMC_PCSR1_PID37 (0x1u << 5) /**< \brief (PMC_PCSR1) Peripheral Clock 37 Status */
#define PMC_PCSR1_PID38 (0x1u << 6) /**< \brief (PMC_PCSR1) Peripheral Clock 38 Status */
#define PMC_PCSR1_PID39 (0x1u << 7) /**< \brief (PMC_PCSR1) Peripheral Clock 39 Status */
#define PMC_PCSR1_PID40 (0x1u << 8) /**< \brief (PMC_PCSR1) Peripheral Clock 40 Status */
#define PMC_PCSR1_PID41 (0x1u << 9) /**< \brief (PMC_PCSR1) Peripheral Clock 41 Status */
#define PMC_PCSR1_PID42 (0x1u << 10) /**< \brief (PMC_PCSR1) Peripheral Clock 42 Status */
#define PMC_PCSR1_PID43 (0x1u << 11) /**< \brief (PMC_PCSR1) Peripheral Clock 43 Status */
#define PMC_PCSR1_PID44 (0x1u << 12) /**< \brief (PMC_PCSR1) Peripheral Clock 44 Status */
#define PMC_PCSR1_PID45 (0x1u << 13) /**< \brief (PMC_PCSR1) Peripheral Clock 45 Status */
#define PMC_PCSR1_PID46 (0x1u << 14) /**< \brief (PMC_PCSR1) Peripheral Clock 46 Status */
#define PMC_PCSR1_PID47 (0x1u << 15) /**< \brief (PMC_PCSR1) Peripheral Clock 47 Status */
#define PMC_PCSR1_PID48 (0x1u << 16) /**< \brief (PMC_PCSR1) Peripheral Clock 48 Status */
#define PMC_PCSR1_PID49 (0x1u << 17) /**< \brief (PMC_PCSR1) Peripheral Clock 49 Status */
#define PMC_PCSR1_PID50 (0x1u << 18) /**< \brief (PMC_PCSR1) Peripheral Clock 50 Status */
#define PMC_PCSR1_PID51 (0x1u << 19) /**< \brief (PMC_PCSR1) Peripheral Clock 51 Status */
#define PMC_PCSR1_PID52 (0x1u << 20) /**< \brief (PMC_PCSR1) Peripheral Clock 52 Status */
#define PMC_PCSR1_PID53 (0x1u << 21) /**< \brief (PMC_PCSR1) Peripheral Clock 53 Status */
#define PMC_PCSR1_PID54 (0x1u << 22) /**< \brief (PMC_PCSR1) Peripheral Clock 54 Status */
#define PMC_PCSR1_PID55 (0x1u << 23) /**< \brief (PMC_PCSR1) Peripheral Clock 55 Status */
#define PMC_PCSR1_PID56 (0x1u << 24) /**< \brief (PMC_PCSR1) Peripheral Clock 56 Status */
#define PMC_PCSR1_PID57 (0x1u << 25) /**< \brief (PMC_PCSR1) Peripheral Clock 57 Status */
#define PMC_PCSR1_PID58 (0x1u << 26) /**< \brief (PMC_PCSR1) Peripheral Clock 58 Status */
#define PMC_PCSR1_PID59 (0x1u << 27) /**< \brief (PMC_PCSR1) Peripheral Clock 59 Status */
#define PMC_PCSR1_PID60 (0x1u << 28) /**< \brief (PMC_PCSR1) Peripheral Clock 60 Status */
#define PMC_PCSR1_PID61 (0x1u << 29) /**< \brief (PMC_PCSR1) Peripheral Clock 61 Status */
#define PMC_PCSR1_PID62 (0x1u << 30) /**< \brief (PMC_PCSR1) Peripheral Clock 62 Status */
#define PMC_PCSR1_PID63 (0x1u << 31) /**< \brief (PMC_PCSR1) Peripheral Clock 63 Status */
/* -------- PMC_PCR : (PMC Offset: 0x010C) Peripheral Control Register -------- */
#define PMC_PCR_PID_Pos 0
#define PMC_PCR_PID_Msk (0x3fu << PMC_PCR_PID_Pos) /**< \brief (PMC_PCR) Peripheral ID */
#define PMC_PCR_PID(value) ((PMC_PCR_PID_Msk & ((value) << PMC_PCR_PID_Pos)))
#define PMC_PCR_CMD (0x1u << 12) /**< \brief (PMC_PCR) Command */
#define PMC_PCR_DIV_Pos 16
#define PMC_PCR_DIV_Msk (0x3u << PMC_PCR_DIV_Pos) /**< \brief (PMC_PCR) Divisor value */
#define   PMC_PCR_DIV_PERIPH_DIV_MCK (0x0u << 16) /**< \brief (PMC_PCR) Peripheral clock is MCK */
#define   PMC_PCR_DIV_PERIPH_DIV2_MCK (0x1u << 16) /**< \brief (PMC_PCR) Peripheral clock is MCK/2 */
#define   PMC_PCR_DIV_PERIPH_DIV4_MCK (0x2u << 16) /**< \brief (PMC_PCR) Peripheral clock is MCK/4 */
#define   PMC_PCR_DIV_PERIPH_DIV8_MCK (0x3u << 16) /**< \brief (PMC_PCR) Peripheral clock is MCK/8 */
#define PMC_PCR_EN (0x1u << 28) /**< \brief (PMC_PCR) Enable */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Pulse Width Modulation Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_PWM Pulse Width Modulation Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief PwmCh_num hardware registers */
typedef struct {
  __IO uint32_t PWM_CMR;     /**< \brief (PwmCh_num Offset: 0x0) PWM Channel Mode Register */
  __IO uint32_t PWM_CDTY;    /**< \brief (PwmCh_num Offset: 0x4) PWM Channel Duty Cycle Register */
  __O  uint32_t PWM_CDTYUPD; /**< \brief (PwmCh_num Offset: 0x8) PWM Channel Duty Cycle Update Register */
  __IO uint32_t PWM_CPRD;    /**< \brief (PwmCh_num Offset: 0xC) PWM Channel Period Register */
  __O  uint32_t PWM_CPRDUPD; /**< \brief (PwmCh_num Offset: 0x10) PWM Channel Period Update Register */
  __I  uint32_t PWM_CCNT;    /**< \brief (PwmCh_num Offset: 0x14) PWM Channel Counter Register */
  __IO uint32_t PWM_DT;      /**< \brief (PwmCh_num Offset: 0x18) PWM Channel Dead Time Register */
  __O  uint32_t PWM_DTUPD;   /**< \brief (PwmCh_num Offset: 0x1C) PWM Channel Dead Time Update Register */
} PwmCh_num;
/** \brief PwmCmp hardware registers */
typedef struct {
  __IO uint32_t PWM_CMPV;    /**< \brief (PwmCmp Offset: 0x0) PWM Comparison 0 Value Register */
  __O  uint32_t PWM_CMPVUPD; /**< \brief (PwmCmp Offset: 0x4) PWM Comparison 0 Value Update Register */
  __IO uint32_t PWM_CMPM;    /**< \brief (PwmCmp Offset: 0x8) PWM Comparison 0 Mode Register */
  __O  uint32_t PWM_CMPMUPD; /**< \brief (PwmCmp Offset: 0xC) PWM Comparison 0 Mode Update Register */
} PwmCmp;
/** \brief Pwm hardware registers */
#define PWMCMP_NUMBER 8
#define PWMCH_NUM_NUMBER 4
typedef struct {
  __IO uint32_t  PWM_CLK;                      /**< \brief (Pwm Offset: 0x00) PWM Clock Register */
  __O  uint32_t  PWM_ENA;                      /**< \brief (Pwm Offset: 0x04) PWM Enable Register */
  __O  uint32_t  PWM_DIS;                      /**< \brief (Pwm Offset: 0x08) PWM Disable Register */
  __I  uint32_t  PWM_SR;                       /**< \brief (Pwm Offset: 0x0C) PWM Status Register */
  __O  uint32_t  PWM_IER1;                     /**< \brief (Pwm Offset: 0x10) PWM Interrupt Enable Register 1 */
  __O  uint32_t  PWM_IDR1;                     /**< \brief (Pwm Offset: 0x14) PWM Interrupt Disable Register 1 */
  __I  uint32_t  PWM_IMR1;                     /**< \brief (Pwm Offset: 0x18) PWM Interrupt Mask Register 1 */
  __I  uint32_t  PWM_ISR1;                     /**< \brief (Pwm Offset: 0x1C) PWM Interrupt Status Register 1 */
  __IO uint32_t  PWM_SCM;                      /**< \brief (Pwm Offset: 0x20) PWM Sync Channels Mode Register */
  __I  uint32_t  Reserved1[1];
  __IO uint32_t  PWM_SCUC;                     /**< \brief (Pwm Offset: 0x28) PWM Sync Channels Update Control Register */
  __IO uint32_t  PWM_SCUP;                     /**< \brief (Pwm Offset: 0x2C) PWM Sync Channels Update Period Register */
  __O  uint32_t  PWM_SCUPUPD;                  /**< \brief (Pwm Offset: 0x30) PWM Sync Channels Update Period Update Register */
  __O  uint32_t  PWM_IER2;                     /**< \brief (Pwm Offset: 0x34) PWM Interrupt Enable Register 2 */
  __O  uint32_t  PWM_IDR2;                     /**< \brief (Pwm Offset: 0x38) PWM Interrupt Disable Register 2 */
  __I  uint32_t  PWM_IMR2;                     /**< \brief (Pwm Offset: 0x3C) PWM Interrupt Mask Register 2 */
  __I  uint32_t  PWM_ISR2;                     /**< \brief (Pwm Offset: 0x40) PWM Interrupt Status Register 2 */
  __IO uint32_t  PWM_OOV;                      /**< \brief (Pwm Offset: 0x44) PWM Output Override Value Register */
  __IO uint32_t  PWM_OS;                       /**< \brief (Pwm Offset: 0x48) PWM Output Selection Register */
  __O  uint32_t  PWM_OSS;                      /**< \brief (Pwm Offset: 0x4C) PWM Output Selection Set Register */
  __O  uint32_t  PWM_OSC;                      /**< \brief (Pwm Offset: 0x50) PWM Output Selection Clear Register */
  __O  uint32_t  PWM_OSSUPD;                   /**< \brief (Pwm Offset: 0x54) PWM Output Selection Set Update Register */
  __O  uint32_t  PWM_OSCUPD;                   /**< \brief (Pwm Offset: 0x58) PWM Output Selection Clear Update Register */
  __IO uint32_t  PWM_FMR;                      /**< \brief (Pwm Offset: 0x5C) PWM Fault Mode Register */
  __I  uint32_t  PWM_FSR;                      /**< \brief (Pwm Offset: 0x60) PWM Fault Status Register */
  __O  uint32_t  PWM_FCR;                      /**< \brief (Pwm Offset: 0x64) PWM Fault Clear Register */
  __IO uint32_t  PWM_FPV1;                     /**< \brief (Pwm Offset: 0x68) PWM Fault Protection Value Register 1 */
  __IO uint32_t  PWM_FPE;                      /**< \brief (Pwm Offset: 0x6C) PWM Fault Protection Enable Register */
  __I  uint32_t  Reserved2[3];
  __IO uint32_t  PWM_ELMR[2];                  /**< \brief (Pwm Offset: 0x7C) PWM Event Line 0 Mode Register */
  __I  uint32_t  Reserved3[7];
  __IO uint32_t  PWM_SSPR;                     /**< \brief (Pwm Offset: 0xA0) PWM Spread Spectrum Register */
  __O  uint32_t  PWM_SSPUP;                    /**< \brief (Pwm Offset: 0xA4) PWM Spread Spectrum Update Register */
  __I  uint32_t  Reserved4[2];
  __IO uint32_t  PWM_SMMR;                     /**< \brief (Pwm Offset: 0xB0) PWM Stepper Motor Mode Register */
  __I  uint32_t  Reserved5[3];
  __IO uint32_t  PWM_FPV2;                     /**< \brief (Pwm Offset: 0xC0) PWM Fault Protection Value 2 Register */
  __I  uint32_t  Reserved6[8];
  __O  uint32_t  PWM_WPCR;                     /**< \brief (Pwm Offset: 0xE4) PWM Write Protect Control Register */
  __I  uint32_t  PWM_WPSR;                     /**< \brief (Pwm Offset: 0xE8) PWM Write Protect Status Register */
  __I  uint32_t  Reserved7[17];
       PwmCmp    PWM_CMP[PWMCMP_NUMBER];       /**< \brief (Pwm Offset: 0x130) 0 .. 7 */
  __I  uint32_t  Reserved8[20];
       PwmCh_num PWM_CH_NUM[PWMCH_NUM_NUMBER]; /**< \brief (Pwm Offset: 0x200) ch_num = 0 .. 3 */
  __I  uint32_t  Reserved9[96];
  __O  uint32_t  PWM_CMUPD0;                   /**< \brief (Pwm Offset: 0x400) PWM Channel Mode Update Register (ch_num = 0) */
  __I  uint32_t  Reserved10[7];
  __O  uint32_t  PWM_CMUPD1;                   /**< \brief (Pwm Offset: 0x420) PWM Channel Mode Update Register (ch_num = 1) */
  __I  uint32_t  Reserved11[7];
  __O  uint32_t  PWM_CMUPD2;                   /**< \brief (Pwm Offset: 0x440) PWM Channel Mode Update Register (ch_num = 2) */
  __I  uint32_t  Reserved12[7];
  __O  uint32_t  PWM_CMUPD3;                   /**< \brief (Pwm Offset: 0x460) PWM Channel Mode Update Register (ch_num = 3) */
} Pwm;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- PWM_CLK : (PWM Offset: 0x00) PWM Clock Register -------- */
#define PWM_CLK_DIVA_Pos 0
#define PWM_CLK_DIVA_Msk (0xffu << PWM_CLK_DIVA_Pos) /**< \brief (PWM_CLK) CLKA, CLKB Divide Factor */
#define PWM_CLK_DIVA(value) ((PWM_CLK_DIVA_Msk & ((value) << PWM_CLK_DIVA_Pos)))
#define PWM_CLK_PREA_Pos 8
#define PWM_CLK_PREA_Msk (0xfu << PWM_CLK_PREA_Pos) /**< \brief (PWM_CLK) CLKA, CLKB Source Clock Selection */
#define PWM_CLK_PREA(value) ((PWM_CLK_PREA_Msk & ((value) << PWM_CLK_PREA_Pos)))
#define PWM_CLK_DIVB_Pos 16
#define PWM_CLK_DIVB_Msk (0xffu << PWM_CLK_DIVB_Pos) /**< \brief (PWM_CLK) CLKA, CLKB Divide Factor */
#define PWM_CLK_DIVB(value) ((PWM_CLK_DIVB_Msk & ((value) << PWM_CLK_DIVB_Pos)))
#define PWM_CLK_PREB_Pos 24
#define PWM_CLK_PREB_Msk (0xfu << PWM_CLK_PREB_Pos) /**< \brief (PWM_CLK) CLKA, CLKB Source Clock Selection */
#define PWM_CLK_PREB(value) ((PWM_CLK_PREB_Msk & ((value) << PWM_CLK_PREB_Pos)))
/* -------- PWM_ENA : (PWM Offset: 0x04) PWM Enable Register -------- */
#define PWM_ENA_CHID0 (0x1u << 0) /**< \brief (PWM_ENA) Channel ID */
#define PWM_ENA_CHID1 (0x1u << 1) /**< \brief (PWM_ENA) Channel ID */
#define PWM_ENA_CHID2 (0x1u << 2) /**< \brief (PWM_ENA) Channel ID */
#define PWM_ENA_CHID3 (0x1u << 3) /**< \brief (PWM_ENA) Channel ID */
/* -------- PWM_DIS : (PWM Offset: 0x08) PWM Disable Register -------- */
#define PWM_DIS_CHID0 (0x1u << 0) /**< \brief (PWM_DIS) Channel ID */
#define PWM_DIS_CHID1 (0x1u << 1) /**< \brief (PWM_DIS) Channel ID */
#define PWM_DIS_CHID2 (0x1u << 2) /**< \brief (PWM_DIS) Channel ID */
#define PWM_DIS_CHID3 (0x1u << 3) /**< \brief (PWM_DIS) Channel ID */
/* -------- PWM_SR : (PWM Offset: 0x0C) PWM Status Register -------- */
#define PWM_SR_CHID0 (0x1u << 0) /**< \brief (PWM_SR) Channel ID */
#define PWM_SR_CHID1 (0x1u << 1) /**< \brief (PWM_SR) Channel ID */
#define PWM_SR_CHID2 (0x1u << 2) /**< \brief (PWM_SR) Channel ID */
#define PWM_SR_CHID3 (0x1u << 3) /**< \brief (PWM_SR) Channel ID */
/* -------- PWM_IER1 : (PWM Offset: 0x10) PWM Interrupt Enable Register 1 -------- */
#define PWM_IER1_CHID0 (0x1u << 0) /**< \brief (PWM_IER1) Counter Event on Channel 0 Interrupt Enable */
#define PWM_IER1_CHID1 (0x1u << 1) /**< \brief (PWM_IER1) Counter Event on Channel 1 Interrupt Enable */
#define PWM_IER1_CHID2 (0x1u << 2) /**< \brief (PWM_IER1) Counter Event on Channel 2 Interrupt Enable */
#define PWM_IER1_CHID3 (0x1u << 3) /**< \brief (PWM_IER1) Counter Event on Channel 3 Interrupt Enable */
#define PWM_IER1_FCHID0 (0x1u << 16) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 0 Interrupt Enable */
#define PWM_IER1_FCHID1 (0x1u << 17) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 1 Interrupt Enable */
#define PWM_IER1_FCHID2 (0x1u << 18) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 2 Interrupt Enable */
#define PWM_IER1_FCHID3 (0x1u << 19) /**< \brief (PWM_IER1) Fault Protection Trigger on Channel 3 Interrupt Enable */
/* -------- PWM_IDR1 : (PWM Offset: 0x14) PWM Interrupt Disable Register 1 -------- */
#define PWM_IDR1_CHID0 (0x1u << 0) /**< \brief (PWM_IDR1) Counter Event on Channel 0 Interrupt Disable */
#define PWM_IDR1_CHID1 (0x1u << 1) /**< \brief (PWM_IDR1) Counter Event on Channel 1 Interrupt Disable */
#define PWM_IDR1_CHID2 (0x1u << 2) /**< \brief (PWM_IDR1) Counter Event on Channel 2 Interrupt Disable */
#define PWM_IDR1_CHID3 (0x1u << 3) /**< \brief (PWM_IDR1) Counter Event on Channel 3 Interrupt Disable */
#define PWM_IDR1_FCHID0 (0x1u << 16) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 0 Interrupt Disable */
#define PWM_IDR1_FCHID1 (0x1u << 17) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 1 Interrupt Disable */
#define PWM_IDR1_FCHID2 (0x1u << 18) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 2 Interrupt Disable */
#define PWM_IDR1_FCHID3 (0x1u << 19) /**< \brief (PWM_IDR1) Fault Protection Trigger on Channel 3 Interrupt Disable */
/* -------- PWM_IMR1 : (PWM Offset: 0x18) PWM Interrupt Mask Register 1 -------- */
#define PWM_IMR1_CHID0 (0x1u << 0) /**< \brief (PWM_IMR1) Counter Event on Channel 0 Interrupt Mask */
#define PWM_IMR1_CHID1 (0x1u << 1) /**< \brief (PWM_IMR1) Counter Event on Channel 1 Interrupt Mask */
#define PWM_IMR1_CHID2 (0x1u << 2) /**< \brief (PWM_IMR1) Counter Event on Channel 2 Interrupt Mask */
#define PWM_IMR1_CHID3 (0x1u << 3) /**< \brief (PWM_IMR1) Counter Event on Channel 3 Interrupt Mask */
#define PWM_IMR1_FCHID0 (0x1u << 16) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 0 Interrupt Mask */
#define PWM_IMR1_FCHID1 (0x1u << 17) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 1 Interrupt Mask */
#define PWM_IMR1_FCHID2 (0x1u << 18) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 2 Interrupt Mask */
#define PWM_IMR1_FCHID3 (0x1u << 19) /**< \brief (PWM_IMR1) Fault Protection Trigger on Channel 3 Interrupt Mask */
/* -------- PWM_ISR1 : (PWM Offset: 0x1C) PWM Interrupt Status Register 1 -------- */
#define PWM_ISR1_CHID0 (0x1u << 0) /**< \brief (PWM_ISR1) Counter Event on Channel 0 */
#define PWM_ISR1_CHID1 (0x1u << 1) /**< \brief (PWM_ISR1) Counter Event on Channel 1 */
#define PWM_ISR1_CHID2 (0x1u << 2) /**< \brief (PWM_ISR1) Counter Event on Channel 2 */
#define PWM_ISR1_CHID3 (0x1u << 3) /**< \brief (PWM_ISR1) Counter Event on Channel 3 */
#define PWM_ISR1_FCHID0 (0x1u << 16) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 0 */
#define PWM_ISR1_FCHID1 (0x1u << 17) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 1 */
#define PWM_ISR1_FCHID2 (0x1u << 18) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 2 */
#define PWM_ISR1_FCHID3 (0x1u << 19) /**< \brief (PWM_ISR1) Fault Protection Trigger on Channel 3 */
/* -------- PWM_SCM : (PWM Offset: 0x20) PWM Sync Channels Mode Register -------- */
#define PWM_SCM_SYNC0 (0x1u << 0) /**< \brief (PWM_SCM) Synchronous Channel 0 */
#define PWM_SCM_SYNC1 (0x1u << 1) /**< \brief (PWM_SCM) Synchronous Channel 1 */
#define PWM_SCM_SYNC2 (0x1u << 2) /**< \brief (PWM_SCM) Synchronous Channel 2 */
#define PWM_SCM_SYNC3 (0x1u << 3) /**< \brief (PWM_SCM) Synchronous Channel 3 */
#define PWM_SCM_UPDM_Pos 16
#define PWM_SCM_UPDM_Msk (0x3u << PWM_SCM_UPDM_Pos) /**< \brief (PWM_SCM) Synchronous Channels Update Mode */
#define   PWM_SCM_UPDM_MODE0 (0x0u << 16) /**< \brief (PWM_SCM) Manual write of double buffer registers and manual update of synchronous channels */
#define   PWM_SCM_UPDM_MODE1 (0x1u << 16) /**< \brief (PWM_SCM) Manual write of double buffer registers and automatic update of synchronous channels */
/* -------- PWM_SCUC : (PWM Offset: 0x28) PWM Sync Channels Update Control Register -------- */
#define PWM_SCUC_UPDULOCK (0x1u << 0) /**< \brief (PWM_SCUC) Synchronous Channels Update Unlock */
/* -------- PWM_SCUP : (PWM Offset: 0x2C) PWM Sync Channels Update Period Register -------- */
#define PWM_SCUP_UPR_Pos 0
#define PWM_SCUP_UPR_Msk (0xfu << PWM_SCUP_UPR_Pos) /**< \brief (PWM_SCUP) Update Period */
#define PWM_SCUP_UPR(value) ((PWM_SCUP_UPR_Msk & ((value) << PWM_SCUP_UPR_Pos)))
#define PWM_SCUP_UPRCNT_Pos 4
#define PWM_SCUP_UPRCNT_Msk (0xfu << PWM_SCUP_UPRCNT_Pos) /**< \brief (PWM_SCUP) Update Period Counter */
#define PWM_SCUP_UPRCNT(value) ((PWM_SCUP_UPRCNT_Msk & ((value) << PWM_SCUP_UPRCNT_Pos)))
/* -------- PWM_SCUPUPD : (PWM Offset: 0x30) PWM Sync Channels Update Period Update Register -------- */
#define PWM_SCUPUPD_UPRUPD_Pos 0
#define PWM_SCUPUPD_UPRUPD_Msk (0xfu << PWM_SCUPUPD_UPRUPD_Pos) /**< \brief (PWM_SCUPUPD) Update Period Update */
#define PWM_SCUPUPD_UPRUPD(value) ((PWM_SCUPUPD_UPRUPD_Msk & ((value) << PWM_SCUPUPD_UPRUPD_Pos)))
/* -------- PWM_IER2 : (PWM Offset: 0x34) PWM Interrupt Enable Register 2 -------- */
#define PWM_IER2_WRDY (0x1u << 0) /**< \brief (PWM_IER2) Write Ready for Synchronous Channels Update Interrupt Enable */
#define PWM_IER2_UNRE (0x1u << 3) /**< \brief (PWM_IER2) Synchronous Channels Update Underrun Error Interrupt Enable */
#define PWM_IER2_CMPM0 (0x1u << 8) /**< \brief (PWM_IER2) Comparison 0 Match Interrupt Enable */
#define PWM_IER2_CMPM1 (0x1u << 9) /**< \brief (PWM_IER2) Comparison 1 Match Interrupt Enable */
#define PWM_IER2_CMPM2 (0x1u << 10) /**< \brief (PWM_IER2) Comparison 2 Match Interrupt Enable */
#define PWM_IER2_CMPM3 (0x1u << 11) /**< \brief (PWM_IER2) Comparison 3 Match Interrupt Enable */
#define PWM_IER2_CMPM4 (0x1u << 12) /**< \brief (PWM_IER2) Comparison 4 Match Interrupt Enable */
#define PWM_IER2_CMPM5 (0x1u << 13) /**< \brief (PWM_IER2) Comparison 5 Match Interrupt Enable */
#define PWM_IER2_CMPM6 (0x1u << 14) /**< \brief (PWM_IER2) Comparison 6 Match Interrupt Enable */
#define PWM_IER2_CMPM7 (0x1u << 15) /**< \brief (PWM_IER2) Comparison 7 Match Interrupt Enable */
#define PWM_IER2_CMPU0 (0x1u << 16) /**< \brief (PWM_IER2) Comparison 0 Update Interrupt Enable */
#define PWM_IER2_CMPU1 (0x1u << 17) /**< \brief (PWM_IER2) Comparison 1 Update Interrupt Enable */
#define PWM_IER2_CMPU2 (0x1u << 18) /**< \brief (PWM_IER2) Comparison 2 Update Interrupt Enable */
#define PWM_IER2_CMPU3 (0x1u << 19) /**< \brief (PWM_IER2) Comparison 3 Update Interrupt Enable */
#define PWM_IER2_CMPU4 (0x1u << 20) /**< \brief (PWM_IER2) Comparison 4 Update Interrupt Enable */
#define PWM_IER2_CMPU5 (0x1u << 21) /**< \brief (PWM_IER2) Comparison 5 Update Interrupt Enable */
#define PWM_IER2_CMPU6 (0x1u << 22) /**< \brief (PWM_IER2) Comparison 6 Update Interrupt Enable */
#define PWM_IER2_CMPU7 (0x1u << 23) /**< \brief (PWM_IER2) Comparison 7 Update Interrupt Enable */
/* -------- PWM_IDR2 : (PWM Offset: 0x38) PWM Interrupt Disable Register 2 -------- */
#define PWM_IDR2_WRDY (0x1u << 0) /**< \brief (PWM_IDR2) Write Ready for Synchronous Channels Update Interrupt Disable */
#define PWM_IDR2_UNRE (0x1u << 3) /**< \brief (PWM_IDR2) Synchronous Channels Update Underrun Error Interrupt Disable */
#define PWM_IDR2_CMPM0 (0x1u << 8) /**< \brief (PWM_IDR2) Comparison 0 Match Interrupt Disable */
#define PWM_IDR2_CMPM1 (0x1u << 9) /**< \brief (PWM_IDR2) Comparison 1 Match Interrupt Disable */
#define PWM_IDR2_CMPM2 (0x1u << 10) /**< \brief (PWM_IDR2) Comparison 2 Match Interrupt Disable */
#define PWM_IDR2_CMPM3 (0x1u << 11) /**< \brief (PWM_IDR2) Comparison 3 Match Interrupt Disable */
#define PWM_IDR2_CMPM4 (0x1u << 12) /**< \brief (PWM_IDR2) Comparison 4 Match Interrupt Disable */
#define PWM_IDR2_CMPM5 (0x1u << 13) /**< \brief (PWM_IDR2) Comparison 5 Match Interrupt Disable */
#define PWM_IDR2_CMPM6 (0x1u << 14) /**< \brief (PWM_IDR2) Comparison 6 Match Interrupt Disable */
#define PWM_IDR2_CMPM7 (0x1u << 15) /**< \brief (PWM_IDR2) Comparison 7 Match Interrupt Disable */
#define PWM_IDR2_CMPU0 (0x1u << 16) /**< \brief (PWM_IDR2) Comparison 0 Update Interrupt Disable */
#define PWM_IDR2_CMPU1 (0x1u << 17) /**< \brief (PWM_IDR2) Comparison 1 Update Interrupt Disable */
#define PWM_IDR2_CMPU2 (0x1u << 18) /**< \brief (PWM_IDR2) Comparison 2 Update Interrupt Disable */
#define PWM_IDR2_CMPU3 (0x1u << 19) /**< \brief (PWM_IDR2) Comparison 3 Update Interrupt Disable */
#define PWM_IDR2_CMPU4 (0x1u << 20) /**< \brief (PWM_IDR2) Comparison 4 Update Interrupt Disable */
#define PWM_IDR2_CMPU5 (0x1u << 21) /**< \brief (PWM_IDR2) Comparison 5 Update Interrupt Disable */
#define PWM_IDR2_CMPU6 (0x1u << 22) /**< \brief (PWM_IDR2) Comparison 6 Update Interrupt Disable */
#define PWM_IDR2_CMPU7 (0x1u << 23) /**< \brief (PWM_IDR2) Comparison 7 Update Interrupt Disable */
/* -------- PWM_IMR2 : (PWM Offset: 0x3C) PWM Interrupt Mask Register 2 -------- */
#define PWM_IMR2_WRDY (0x1u << 0) /**< \brief (PWM_IMR2) Write Ready for Synchronous Channels Update Interrupt Mask */
#define PWM_IMR2_UNRE (0x1u << 3) /**< \brief (PWM_IMR2) Synchronous Channels Update Underrun Error Interrupt Mask */
#define PWM_IMR2_CMPM0 (0x1u << 8) /**< \brief (PWM_IMR2) Comparison 0 Match Interrupt Mask */
#define PWM_IMR2_CMPM1 (0x1u << 9) /**< \brief (PWM_IMR2) Comparison 1 Match Interrupt Mask */
#define PWM_IMR2_CMPM2 (0x1u << 10) /**< \brief (PWM_IMR2) Comparison 2 Match Interrupt Mask */
#define PWM_IMR2_CMPM3 (0x1u << 11) /**< \brief (PWM_IMR2) Comparison 3 Match Interrupt Mask */
#define PWM_IMR2_CMPM4 (0x1u << 12) /**< \brief (PWM_IMR2) Comparison 4 Match Interrupt Mask */
#define PWM_IMR2_CMPM5 (0x1u << 13) /**< \brief (PWM_IMR2) Comparison 5 Match Interrupt Mask */
#define PWM_IMR2_CMPM6 (0x1u << 14) /**< \brief (PWM_IMR2) Comparison 6 Match Interrupt Mask */
#define PWM_IMR2_CMPM7 (0x1u << 15) /**< \brief (PWM_IMR2) Comparison 7 Match Interrupt Mask */
#define PWM_IMR2_CMPU0 (0x1u << 16) /**< \brief (PWM_IMR2) Comparison 0 Update Interrupt Mask */
#define PWM_IMR2_CMPU1 (0x1u << 17) /**< \brief (PWM_IMR2) Comparison 1 Update Interrupt Mask */
#define PWM_IMR2_CMPU2 (0x1u << 18) /**< \brief (PWM_IMR2) Comparison 2 Update Interrupt Mask */
#define PWM_IMR2_CMPU3 (0x1u << 19) /**< \brief (PWM_IMR2) Comparison 3 Update Interrupt Mask */
#define PWM_IMR2_CMPU4 (0x1u << 20) /**< \brief (PWM_IMR2) Comparison 4 Update Interrupt Mask */
#define PWM_IMR2_CMPU5 (0x1u << 21) /**< \brief (PWM_IMR2) Comparison 5 Update Interrupt Mask */
#define PWM_IMR2_CMPU6 (0x1u << 22) /**< \brief (PWM_IMR2) Comparison 6 Update Interrupt Mask */
#define PWM_IMR2_CMPU7 (0x1u << 23) /**< \brief (PWM_IMR2) Comparison 7 Update Interrupt Mask */
/* -------- PWM_ISR2 : (PWM Offset: 0x40) PWM Interrupt Status Register 2 -------- */
#define PWM_ISR2_WRDY (0x1u << 0) /**< \brief (PWM_ISR2) Write Ready for Synchronous Channels Update */
#define PWM_ISR2_UNRE (0x1u << 3) /**< \brief (PWM_ISR2) Synchronous Channels Update Underrun Error */
#define PWM_ISR2_CMPM0 (0x1u << 8) /**< \brief (PWM_ISR2) Comparison 0 Match */
#define PWM_ISR2_CMPM1 (0x1u << 9) /**< \brief (PWM_ISR2) Comparison 1 Match */
#define PWM_ISR2_CMPM2 (0x1u << 10) /**< \brief (PWM_ISR2) Comparison 2 Match */
#define PWM_ISR2_CMPM3 (0x1u << 11) /**< \brief (PWM_ISR2) Comparison 3 Match */
#define PWM_ISR2_CMPM4 (0x1u << 12) /**< \brief (PWM_ISR2) Comparison 4 Match */
#define PWM_ISR2_CMPM5 (0x1u << 13) /**< \brief (PWM_ISR2) Comparison 5 Match */
#define PWM_ISR2_CMPM6 (0x1u << 14) /**< \brief (PWM_ISR2) Comparison 6 Match */
#define PWM_ISR2_CMPM7 (0x1u << 15) /**< \brief (PWM_ISR2) Comparison 7 Match */
#define PWM_ISR2_CMPU0 (0x1u << 16) /**< \brief (PWM_ISR2) Comparison 0 Update */
#define PWM_ISR2_CMPU1 (0x1u << 17) /**< \brief (PWM_ISR2) Comparison 1 Update */
#define PWM_ISR2_CMPU2 (0x1u << 18) /**< \brief (PWM_ISR2) Comparison 2 Update */
#define PWM_ISR2_CMPU3 (0x1u << 19) /**< \brief (PWM_ISR2) Comparison 3 Update */
#define PWM_ISR2_CMPU4 (0x1u << 20) /**< \brief (PWM_ISR2) Comparison 4 Update */
#define PWM_ISR2_CMPU5 (0x1u << 21) /**< \brief (PWM_ISR2) Comparison 5 Update */
#define PWM_ISR2_CMPU6 (0x1u << 22) /**< \brief (PWM_ISR2) Comparison 6 Update */
#define PWM_ISR2_CMPU7 (0x1u << 23) /**< \brief (PWM_ISR2) Comparison 7 Update */
/* -------- PWM_OOV : (PWM Offset: 0x44) PWM Output Override Value Register -------- */
#define PWM_OOV_OOVH0 (0x1u << 0) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 0 */
#define PWM_OOV_OOVH1 (0x1u << 1) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 1 */
#define PWM_OOV_OOVH2 (0x1u << 2) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 2 */
#define PWM_OOV_OOVH3 (0x1u << 3) /**< \brief (PWM_OOV) Output Override Value for PWMH output of the channel 3 */
#define PWM_OOV_OOVL0 (0x1u << 16) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 0 */
#define PWM_OOV_OOVL1 (0x1u << 17) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 1 */
#define PWM_OOV_OOVL2 (0x1u << 18) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 2 */
#define PWM_OOV_OOVL3 (0x1u << 19) /**< \brief (PWM_OOV) Output Override Value for PWML output of the channel 3 */
/* -------- PWM_OS : (PWM Offset: 0x48) PWM Output Selection Register -------- */
#define PWM_OS_OSH0 (0x1u << 0) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 0 */
#define PWM_OS_OSH1 (0x1u << 1) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 1 */
#define PWM_OS_OSH2 (0x1u << 2) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 2 */
#define PWM_OS_OSH3 (0x1u << 3) /**< \brief (PWM_OS) Output Selection for PWMH output of the channel 3 */
#define PWM_OS_OSL0 (0x1u << 16) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 0 */
#define PWM_OS_OSL1 (0x1u << 17) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 1 */
#define PWM_OS_OSL2 (0x1u << 18) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 2 */
#define PWM_OS_OSL3 (0x1u << 19) /**< \brief (PWM_OS) Output Selection for PWML output of the channel 3 */
/* -------- PWM_OSS : (PWM Offset: 0x4C) PWM Output Selection Set Register -------- */
#define PWM_OSS_OSSH0 (0x1u << 0) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 0 */
#define PWM_OSS_OSSH1 (0x1u << 1) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 1 */
#define PWM_OSS_OSSH2 (0x1u << 2) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 2 */
#define PWM_OSS_OSSH3 (0x1u << 3) /**< \brief (PWM_OSS) Output Selection Set for PWMH output of the channel 3 */
#define PWM_OSS_OSSL0 (0x1u << 16) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 0 */
#define PWM_OSS_OSSL1 (0x1u << 17) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 1 */
#define PWM_OSS_OSSL2 (0x1u << 18) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 2 */
#define PWM_OSS_OSSL3 (0x1u << 19) /**< \brief (PWM_OSS) Output Selection Set for PWML output of the channel 3 */
/* -------- PWM_OSC : (PWM Offset: 0x50) PWM Output Selection Clear Register -------- */
#define PWM_OSC_OSCH0 (0x1u << 0) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 0 */
#define PWM_OSC_OSCH1 (0x1u << 1) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 1 */
#define PWM_OSC_OSCH2 (0x1u << 2) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 2 */
#define PWM_OSC_OSCH3 (0x1u << 3) /**< \brief (PWM_OSC) Output Selection Clear for PWMH output of the channel 3 */
#define PWM_OSC_OSCL0 (0x1u << 16) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 0 */
#define PWM_OSC_OSCL1 (0x1u << 17) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 1 */
#define PWM_OSC_OSCL2 (0x1u << 18) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 2 */
#define PWM_OSC_OSCL3 (0x1u << 19) /**< \brief (PWM_OSC) Output Selection Clear for PWML output of the channel 3 */
/* -------- PWM_OSSUPD : (PWM Offset: 0x54) PWM Output Selection Set Update Register -------- */
#define PWM_OSSUPD_OSSUPH0 (0x1u << 0) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 0 */
#define PWM_OSSUPD_OSSUPH1 (0x1u << 1) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 1 */
#define PWM_OSSUPD_OSSUPH2 (0x1u << 2) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 2 */
#define PWM_OSSUPD_OSSUPH3 (0x1u << 3) /**< \brief (PWM_OSSUPD) Output Selection Set for PWMH output of the channel 3 */
#define PWM_OSSUPD_OSSUPL0 (0x1u << 16) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 0 */
#define PWM_OSSUPD_OSSUPL1 (0x1u << 17) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 1 */
#define PWM_OSSUPD_OSSUPL2 (0x1u << 18) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 2 */
#define PWM_OSSUPD_OSSUPL3 (0x1u << 19) /**< \brief (PWM_OSSUPD) Output Selection Set for PWML output of the channel 3 */
/* -------- PWM_OSCUPD : (PWM Offset: 0x58) PWM Output Selection Clear Update Register -------- */
#define PWM_OSCUPD_OSCUPH0 (0x1u << 0) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 0 */
#define PWM_OSCUPD_OSCUPH1 (0x1u << 1) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 1 */
#define PWM_OSCUPD_OSCUPH2 (0x1u << 2) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 2 */
#define PWM_OSCUPD_OSCUPH3 (0x1u << 3) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWMH output of the channel 3 */
#define PWM_OSCUPD_OSCUPL0 (0x1u << 16) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 0 */
#define PWM_OSCUPD_OSCUPL1 (0x1u << 17) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 1 */
#define PWM_OSCUPD_OSCUPL2 (0x1u << 18) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 2 */
#define PWM_OSCUPD_OSCUPL3 (0x1u << 19) /**< \brief (PWM_OSCUPD) Output Selection Clear for PWML output of the channel 3 */
/* -------- PWM_FMR : (PWM Offset: 0x5C) PWM Fault Mode Register -------- */
#define PWM_FMR_FPOL_Pos 0
#define PWM_FMR_FPOL_Msk (0xffu << PWM_FMR_FPOL_Pos) /**< \brief (PWM_FMR) Fault Polarity (fault input bit varies from 0 to 7) */
#define PWM_FMR_FPOL(value) ((PWM_FMR_FPOL_Msk & ((value) << PWM_FMR_FPOL_Pos)))
#define PWM_FMR_FMOD_Pos 8
#define PWM_FMR_FMOD_Msk (0xffu << PWM_FMR_FMOD_Pos) /**< \brief (PWM_FMR) Fault Activation Mode (fault input bit varies from 0 to 7) */
#define PWM_FMR_FMOD(value) ((PWM_FMR_FMOD_Msk & ((value) << PWM_FMR_FMOD_Pos)))
#define PWM_FMR_FFIL_Pos 16
#define PWM_FMR_FFIL_Msk (0xffu << PWM_FMR_FFIL_Pos) /**< \brief (PWM_FMR) Fault Filtering (fault input bit varies from 0 to 7) */
#define PWM_FMR_FFIL(value) ((PWM_FMR_FFIL_Msk & ((value) << PWM_FMR_FFIL_Pos)))
/* -------- PWM_FSR : (PWM Offset: 0x60) PWM Fault Status Register -------- */
#define PWM_FSR_FIV_Pos 0
#define PWM_FSR_FIV_Msk (0xffu << PWM_FSR_FIV_Pos) /**< \brief (PWM_FSR) Fault Input Value (fault input bit varies from 0 to 7) */
#define PWM_FSR_FS_Pos 8
#define PWM_FSR_FS_Msk (0xffu << PWM_FSR_FS_Pos) /**< \brief (PWM_FSR) Fault Status (fault input bit varies from 0 to 7) */
/* -------- PWM_FCR : (PWM Offset: 0x64) PWM Fault Clear Register -------- */
#define PWM_FCR_FCLR_Pos 0
#define PWM_FCR_FCLR_Msk (0xffu << PWM_FCR_FCLR_Pos) /**< \brief (PWM_FCR) Fault Clear (fault input bit varies from 0 to 7) */
#define PWM_FCR_FCLR(value) ((PWM_FCR_FCLR_Msk & ((value) << PWM_FCR_FCLR_Pos)))
/* -------- PWM_FPV1 : (PWM Offset: 0x68) PWM Fault Protection Value Register 1 -------- */
#define PWM_FPV1_FPVH0 (0x1u << 0) /**< \brief (PWM_FPV1) Fault Protection Value for PWMH output on channel 0 */
#define PWM_FPV1_FPVH1 (0x1u << 1) /**< \brief (PWM_FPV1) Fault Protection Value for PWMH output on channel 1 */
#define PWM_FPV1_FPVH2 (0x1u << 2) /**< \brief (PWM_FPV1) Fault Protection Value for PWMH output on channel 2 */
#define PWM_FPV1_FPVH3 (0x1u << 3) /**< \brief (PWM_FPV1) Fault Protection Value for PWMH output on channel 3 */
#define PWM_FPV1_FPVL0 (0x1u << 16) /**< \brief (PWM_FPV1) Fault Protection Value for PWML output on channel 0 */
#define PWM_FPV1_FPVL1 (0x1u << 17) /**< \brief (PWM_FPV1) Fault Protection Value for PWML output on channel 1 */
#define PWM_FPV1_FPVL2 (0x1u << 18) /**< \brief (PWM_FPV1) Fault Protection Value for PWML output on channel 2 */
#define PWM_FPV1_FPVL3 (0x1u << 19) /**< \brief (PWM_FPV1) Fault Protection Value for PWML output on channel 3 */
/* -------- PWM_FPE : (PWM Offset: 0x6C) PWM Fault Protection Enable Register -------- */
#define PWM_FPE_FPE0_Pos 0
#define PWM_FPE_FPE0_Msk (0xffu << PWM_FPE_FPE0_Pos) /**< \brief (PWM_FPE) Fault Protection Enable for channel 0 (fault input bit varies from 0 to 7) */
#define PWM_FPE_FPE0(value) ((PWM_FPE_FPE0_Msk & ((value) << PWM_FPE_FPE0_Pos)))
#define PWM_FPE_FPE1_Pos 8
#define PWM_FPE_FPE1_Msk (0xffu << PWM_FPE_FPE1_Pos) /**< \brief (PWM_FPE) Fault Protection Enable for channel 1 (fault input bit varies from 0 to 7) */
#define PWM_FPE_FPE1(value) ((PWM_FPE_FPE1_Msk & ((value) << PWM_FPE_FPE1_Pos)))
#define PWM_FPE_FPE2_Pos 16
#define PWM_FPE_FPE2_Msk (0xffu << PWM_FPE_FPE2_Pos) /**< \brief (PWM_FPE) Fault Protection Enable for channel 2 (fault input bit varies from 0 to 7) */
#define PWM_FPE_FPE2(value) ((PWM_FPE_FPE2_Msk & ((value) << PWM_FPE_FPE2_Pos)))
#define PWM_FPE_FPE3_Pos 24
#define PWM_FPE_FPE3_Msk (0xffu << PWM_FPE_FPE3_Pos) /**< \brief (PWM_FPE) Fault Protection Enable for channel 3 (fault input bit varies from 0 to 7) */
#define PWM_FPE_FPE3(value) ((PWM_FPE_FPE3_Msk & ((value) << PWM_FPE_FPE3_Pos)))
/* -------- PWM_ELMR[2] : (PWM Offset: 0x7C) PWM Event Line 0 Mode Register -------- */
#define PWM_ELMR_CSEL0 (0x1u << 0) /**< \brief (PWM_ELMR[2]) Comparison 0 Selection */
#define PWM_ELMR_CSEL1 (0x1u << 1) /**< \brief (PWM_ELMR[2]) Comparison 1 Selection */
#define PWM_ELMR_CSEL2 (0x1u << 2) /**< \brief (PWM_ELMR[2]) Comparison 2 Selection */
#define PWM_ELMR_CSEL3 (0x1u << 3) /**< \brief (PWM_ELMR[2]) Comparison 3 Selection */
#define PWM_ELMR_CSEL4 (0x1u << 4) /**< \brief (PWM_ELMR[2]) Comparison 4 Selection */
#define PWM_ELMR_CSEL5 (0x1u << 5) /**< \brief (PWM_ELMR[2]) Comparison 5 Selection */
#define PWM_ELMR_CSEL6 (0x1u << 6) /**< \brief (PWM_ELMR[2]) Comparison 6 Selection */
#define PWM_ELMR_CSEL7 (0x1u << 7) /**< \brief (PWM_ELMR[2]) Comparison 7 Selection */
/* -------- PWM_SSPR : (PWM Offset: 0xA0) PWM Spread Spectrum Register -------- */
#define PWM_SSPR_SPRD_Pos 0
#define PWM_SSPR_SPRD_Msk (0xffffffu << PWM_SSPR_SPRD_Pos) /**< \brief (PWM_SSPR) Spread Spectrum Limit Value */
#define PWM_SSPR_SPRD(value) ((PWM_SSPR_SPRD_Msk & ((value) << PWM_SSPR_SPRD_Pos)))
#define PWM_SSPR_SPRDM (0x1u << 24) /**< \brief (PWM_SSPR) Spread Spectrum Counter Mode */
/* -------- PWM_SSPUP : (PWM Offset: 0xA4) PWM Spread Spectrum Update Register -------- */
#define PWM_SSPUP_SPRDUP_Pos 0
#define PWM_SSPUP_SPRDUP_Msk (0xffffffu << PWM_SSPUP_SPRDUP_Pos) /**< \brief (PWM_SSPUP) Spread Spectrum Limit Value Update */
#define PWM_SSPUP_SPRDUP(value) ((PWM_SSPUP_SPRDUP_Msk & ((value) << PWM_SSPUP_SPRDUP_Pos)))
/* -------- PWM_SMMR : (PWM Offset: 0xB0) PWM Stepper Motor Mode Register -------- */
#define PWM_SMMR_GCEN0 (0x1u << 0) /**< \brief (PWM_SMMR) Gray Count ENable */
#define PWM_SMMR_GCEN1 (0x1u << 1) /**< \brief (PWM_SMMR) Gray Count ENable */
#define PWM_SMMR_DOWN0 (0x1u << 16) /**< \brief (PWM_SMMR) DOWN Count */
#define PWM_SMMR_DOWN1 (0x1u << 17) /**< \brief (PWM_SMMR) DOWN Count */
/* -------- PWM_FPV2 : (PWM Offset: 0xC0) PWM Fault Protection Value 2 Register -------- */
#define PWM_FPV2_FPZH0 (0x1u << 0) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWMH output on channel 0 */
#define PWM_FPV2_FPZH1 (0x1u << 1) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWMH output on channel 1 */
#define PWM_FPV2_FPZH2 (0x1u << 2) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWMH output on channel 2 */
#define PWM_FPV2_FPZH3 (0x1u << 3) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWMH output on channel 3 */
#define PWM_FPV2_FPZL0 (0x1u << 16) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWML output on channel 0 */
#define PWM_FPV2_FPZL1 (0x1u << 17) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWML output on channel 1 */
#define PWM_FPV2_FPZL2 (0x1u << 18) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWML output on channel 2 */
#define PWM_FPV2_FPZL3 (0x1u << 19) /**< \brief (PWM_FPV2) Fault Protection to Hi-Z for PWML output on channel 3 */
/* -------- PWM_WPCR : (PWM Offset: 0xE4) PWM Write Protect Control Register -------- */
#define PWM_WPCR_WPCMD_Pos 0
#define PWM_WPCR_WPCMD_Msk (0x3u << PWM_WPCR_WPCMD_Pos) /**< \brief (PWM_WPCR) Write Protect Command */
#define PWM_WPCR_WPCMD(value) ((PWM_WPCR_WPCMD_Msk & ((value) << PWM_WPCR_WPCMD_Pos)))
#define PWM_WPCR_WPRG0 (0x1u << 2) /**< \brief (PWM_WPCR) Write Protect Register Group 0 */
#define PWM_WPCR_WPRG1 (0x1u << 3) /**< \brief (PWM_WPCR) Write Protect Register Group 1 */
#define PWM_WPCR_WPRG2 (0x1u << 4) /**< \brief (PWM_WPCR) Write Protect Register Group 2 */
#define PWM_WPCR_WPRG3 (0x1u << 5) /**< \brief (PWM_WPCR) Write Protect Register Group 3 */
#define PWM_WPCR_WPRG4 (0x1u << 6) /**< \brief (PWM_WPCR) Write Protect Register Group 4 */
#define PWM_WPCR_WPRG5 (0x1u << 7) /**< \brief (PWM_WPCR) Write Protect Register Group 5 */
#define PWM_WPCR_WPKEY_Pos 8
#define PWM_WPCR_WPKEY_Msk (0xffffffu << PWM_WPCR_WPKEY_Pos) /**< \brief (PWM_WPCR) Write Protect Key */
#define PWM_WPCR_WPKEY(value) ((PWM_WPCR_WPKEY_Msk & ((value) << PWM_WPCR_WPKEY_Pos)))
/* -------- PWM_WPSR : (PWM Offset: 0xE8) PWM Write Protect Status Register -------- */
#define PWM_WPSR_WPSWS0 (0x1u << 0) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS1 (0x1u << 1) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS2 (0x1u << 2) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS3 (0x1u << 3) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS4 (0x1u << 4) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPSWS5 (0x1u << 5) /**< \brief (PWM_WPSR) Write Protect SW Status */
#define PWM_WPSR_WPVS (0x1u << 7) /**< \brief (PWM_WPSR) Write Protect Violation Status */
#define PWM_WPSR_WPHWS0 (0x1u << 8) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS1 (0x1u << 9) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS2 (0x1u << 10) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS3 (0x1u << 11) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS4 (0x1u << 12) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPHWS5 (0x1u << 13) /**< \brief (PWM_WPSR) Write Protect HW Status */
#define PWM_WPSR_WPVSRC_Pos 16
#define PWM_WPSR_WPVSRC_Msk (0xffffu << PWM_WPSR_WPVSRC_Pos) /**< \brief (PWM_WPSR) Write Protect Violation Source */
/* -------- PWM_CMPV : (PWM Offset: N/A) PWM Comparison 0 Value Register -------- */
#define PWM_CMPV_CV_Pos 0
#define PWM_CMPV_CV_Msk (0xffffffu << PWM_CMPV_CV_Pos) /**< \brief (PWM_CMPV) Comparison x Value */
#define PWM_CMPV_CV(value) ((PWM_CMPV_CV_Msk & ((value) << PWM_CMPV_CV_Pos)))
#define PWM_CMPV_CVM (0x1u << 24) /**< \brief (PWM_CMPV) Comparison x Value Mode */
/* -------- PWM_CMPVUPD : (PWM Offset: N/A) PWM Comparison 0 Value Update Register -------- */
#define PWM_CMPVUPD_CVUPD_Pos 0
#define PWM_CMPVUPD_CVUPD_Msk (0xffffffu << PWM_CMPVUPD_CVUPD_Pos) /**< \brief (PWM_CMPVUPD) Comparison x Value Update */
#define PWM_CMPVUPD_CVUPD(value) ((PWM_CMPVUPD_CVUPD_Msk & ((value) << PWM_CMPVUPD_CVUPD_Pos)))
#define PWM_CMPVUPD_CVMUPD (0x1u << 24) /**< \brief (PWM_CMPVUPD) Comparison x Value Mode Update */
/* -------- PWM_CMPM : (PWM Offset: N/A) PWM Comparison 0 Mode Register -------- */
#define PWM_CMPM_CEN (0x1u << 0) /**< \brief (PWM_CMPM) Comparison x Enable */
#define PWM_CMPM_CTR_Pos 4
#define PWM_CMPM_CTR_Msk (0xfu << PWM_CMPM_CTR_Pos) /**< \brief (PWM_CMPM) Comparison x Trigger */
#define PWM_CMPM_CTR(value) ((PWM_CMPM_CTR_Msk & ((value) << PWM_CMPM_CTR_Pos)))
#define PWM_CMPM_CPR_Pos 8
#define PWM_CMPM_CPR_Msk (0xfu << PWM_CMPM_CPR_Pos) /**< \brief (PWM_CMPM) Comparison x Period */
#define PWM_CMPM_CPR(value) ((PWM_CMPM_CPR_Msk & ((value) << PWM_CMPM_CPR_Pos)))
#define PWM_CMPM_CPRCNT_Pos 12
#define PWM_CMPM_CPRCNT_Msk (0xfu << PWM_CMPM_CPRCNT_Pos) /**< \brief (PWM_CMPM) Comparison x Period Counter */
#define PWM_CMPM_CPRCNT(value) ((PWM_CMPM_CPRCNT_Msk & ((value) << PWM_CMPM_CPRCNT_Pos)))
#define PWM_CMPM_CUPR_Pos 16
#define PWM_CMPM_CUPR_Msk (0xfu << PWM_CMPM_CUPR_Pos) /**< \brief (PWM_CMPM) Comparison x Update Period */
#define PWM_CMPM_CUPR(value) ((PWM_CMPM_CUPR_Msk & ((value) << PWM_CMPM_CUPR_Pos)))
#define PWM_CMPM_CUPRCNT_Pos 20
#define PWM_CMPM_CUPRCNT_Msk (0xfu << PWM_CMPM_CUPRCNT_Pos) /**< \brief (PWM_CMPM) Comparison x Update Period Counter */
#define PWM_CMPM_CUPRCNT(value) ((PWM_CMPM_CUPRCNT_Msk & ((value) << PWM_CMPM_CUPRCNT_Pos)))
/* -------- PWM_CMPMUPD : (PWM Offset: N/A) PWM Comparison 0 Mode Update Register -------- */
#define PWM_CMPMUPD_CENUPD (0x1u << 0) /**< \brief (PWM_CMPMUPD) Comparison x Enable Update */
#define PWM_CMPMUPD_CTRUPD_Pos 4
#define PWM_CMPMUPD_CTRUPD_Msk (0xfu << PWM_CMPMUPD_CTRUPD_Pos) /**< \brief (PWM_CMPMUPD) Comparison x Trigger Update */
#define PWM_CMPMUPD_CTRUPD(value) ((PWM_CMPMUPD_CTRUPD_Msk & ((value) << PWM_CMPMUPD_CTRUPD_Pos)))
#define PWM_CMPMUPD_CPRUPD_Pos 8
#define PWM_CMPMUPD_CPRUPD_Msk (0xfu << PWM_CMPMUPD_CPRUPD_Pos) /**< \brief (PWM_CMPMUPD) Comparison x Period Update */
#define PWM_CMPMUPD_CPRUPD(value) ((PWM_CMPMUPD_CPRUPD_Msk & ((value) << PWM_CMPMUPD_CPRUPD_Pos)))
#define PWM_CMPMUPD_CUPRUPD_Pos 16
#define PWM_CMPMUPD_CUPRUPD_Msk (0xfu << PWM_CMPMUPD_CUPRUPD_Pos) /**< \brief (PWM_CMPMUPD) Comparison x Update Period Update */
#define PWM_CMPMUPD_CUPRUPD(value) ((PWM_CMPMUPD_CUPRUPD_Msk & ((value) << PWM_CMPMUPD_CUPRUPD_Pos)))
/* -------- PWM_CMR : (PWM Offset: N/A) PWM Channel Mode Register -------- */
#define PWM_CMR_CPRE_Pos 0
#define PWM_CMR_CPRE_Msk (0xfu << PWM_CMR_CPRE_Pos) /**< \brief (PWM_CMR) Channel Pre-scaler */
#define   PWM_CMR_CPRE_MCK (0x0u << 0) /**< \brief (PWM_CMR) Master clock */
#define   PWM_CMR_CPRE_MCK_DIV_2 (0x1u << 0) /**< \brief (PWM_CMR) Master clock/2 */
#define   PWM_CMR_CPRE_MCK_DIV_4 (0x2u << 0) /**< \brief (PWM_CMR) Master clock/4 */
#define   PWM_CMR_CPRE_MCK_DIV_8 (0x3u << 0) /**< \brief (PWM_CMR) Master clock/8 */
#define   PWM_CMR_CPRE_MCK_DIV_16 (0x4u << 0) /**< \brief (PWM_CMR) Master clock/16 */
#define   PWM_CMR_CPRE_MCK_DIV_32 (0x5u << 0) /**< \brief (PWM_CMR) Master clock/32 */
#define   PWM_CMR_CPRE_MCK_DIV_64 (0x6u << 0) /**< \brief (PWM_CMR) Master clock/64 */
#define   PWM_CMR_CPRE_MCK_DIV_128 (0x7u << 0) /**< \brief (PWM_CMR) Master clock/128 */
#define   PWM_CMR_CPRE_MCK_DIV_256 (0x8u << 0) /**< \brief (PWM_CMR) Master clock/256 */
#define   PWM_CMR_CPRE_MCK_DIV_512 (0x9u << 0) /**< \brief (PWM_CMR) Master clock/512 */
#define   PWM_CMR_CPRE_MCK_DIV_1024 (0xAu << 0) /**< \brief (PWM_CMR) Master clock/1024 */
#define   PWM_CMR_CPRE_CLKA (0xBu << 0) /**< \brief (PWM_CMR) Clock A */
#define   PWM_CMR_CPRE_CLKB (0xCu << 0) /**< \brief (PWM_CMR) Clock B */
#define PWM_CMR_CALG (0x1u << 8) /**< \brief (PWM_CMR) Channel Alignment */
#define PWM_CMR_CPOL (0x1u << 9) /**< \brief (PWM_CMR) Channel Polarity */
#define PWM_CMR_CES (0x1u << 10) /**< \brief (PWM_CMR) Counter Event Selection */
#define PWM_CMR_UPDS (0x1u << 11) /**< \brief (PWM_CMR) Update Selection */
#define PWM_CMR_DTE (0x1u << 16) /**< \brief (PWM_CMR) Dead-Time Generator Enable */
#define PWM_CMR_DTHI (0x1u << 17) /**< \brief (PWM_CMR) Dead-Time PWMHx Output Inverted */
#define PWM_CMR_DTLI (0x1u << 18) /**< \brief (PWM_CMR) Dead-Time PWMLx Output Inverted */
/* -------- PWM_CDTY : (PWM Offset: N/A) PWM Channel Duty Cycle Register -------- */
#define PWM_CDTY_CDTY_Pos 0
#define PWM_CDTY_CDTY_Msk (0xffffffu << PWM_CDTY_CDTY_Pos) /**< \brief (PWM_CDTY) Channel Duty-Cycle */
#define PWM_CDTY_CDTY(value) ((PWM_CDTY_CDTY_Msk & ((value) << PWM_CDTY_CDTY_Pos)))
/* -------- PWM_CDTYUPD : (PWM Offset: N/A) PWM Channel Duty Cycle Update Register -------- */
#define PWM_CDTYUPD_CDTYUPD_Pos 0
#define PWM_CDTYUPD_CDTYUPD_Msk (0xffffffu << PWM_CDTYUPD_CDTYUPD_Pos) /**< \brief (PWM_CDTYUPD) Channel Duty-Cycle Update */
#define PWM_CDTYUPD_CDTYUPD(value) ((PWM_CDTYUPD_CDTYUPD_Msk & ((value) << PWM_CDTYUPD_CDTYUPD_Pos)))
/* -------- PWM_CPRD : (PWM Offset: N/A) PWM Channel Period Register -------- */
#define PWM_CPRD_CPRD_Pos 0
#define PWM_CPRD_CPRD_Msk (0xffffffu << PWM_CPRD_CPRD_Pos) /**< \brief (PWM_CPRD) Channel Period */
#define PWM_CPRD_CPRD(value) ((PWM_CPRD_CPRD_Msk & ((value) << PWM_CPRD_CPRD_Pos)))
/* -------- PWM_CPRDUPD : (PWM Offset: N/A) PWM Channel Period Update Register -------- */
#define PWM_CPRDUPD_CPRDUPD_Pos 0
#define PWM_CPRDUPD_CPRDUPD_Msk (0xffffffu << PWM_CPRDUPD_CPRDUPD_Pos) /**< \brief (PWM_CPRDUPD) Channel Period Update */
#define PWM_CPRDUPD_CPRDUPD(value) ((PWM_CPRDUPD_CPRDUPD_Msk & ((value) << PWM_CPRDUPD_CPRDUPD_Pos)))
/* -------- PWM_CCNT : (PWM Offset: N/A) PWM Channel Counter Register -------- */
#define PWM_CCNT_CNT_Pos 0
#define PWM_CCNT_CNT_Msk (0xffffffu << PWM_CCNT_CNT_Pos) /**< \brief (PWM_CCNT) Channel Counter Register */
/* -------- PWM_DT : (PWM Offset: N/A) PWM Channel Dead Time Register -------- */
#define PWM_DT_DTH_Pos 0
#define PWM_DT_DTH_Msk (0xffffu << PWM_DT_DTH_Pos) /**< \brief (PWM_DT) Dead-Time Value for PWMHx Output */
#define PWM_DT_DTH(value) ((PWM_DT_DTH_Msk & ((value) << PWM_DT_DTH_Pos)))
#define PWM_DT_DTL_Pos 16
#define PWM_DT_DTL_Msk (0xffffu << PWM_DT_DTL_Pos) /**< \brief (PWM_DT) Dead-Time Value for PWMLx Output */
#define PWM_DT_DTL(value) ((PWM_DT_DTL_Msk & ((value) << PWM_DT_DTL_Pos)))
/* -------- PWM_DTUPD : (PWM Offset: N/A) PWM Channel Dead Time Update Register -------- */
#define PWM_DTUPD_DTHUPD_Pos 0
#define PWM_DTUPD_DTHUPD_Msk (0xffffu << PWM_DTUPD_DTHUPD_Pos) /**< \brief (PWM_DTUPD) Dead-Time Value Update for PWMHx Output */
#define PWM_DTUPD_DTHUPD(value) ((PWM_DTUPD_DTHUPD_Msk & ((value) << PWM_DTUPD_DTHUPD_Pos)))
#define PWM_DTUPD_DTLUPD_Pos 16
#define PWM_DTUPD_DTLUPD_Msk (0xffffu << PWM_DTUPD_DTLUPD_Pos) /**< \brief (PWM_DTUPD) Dead-Time Value Update for PWMLx Output */
#define PWM_DTUPD_DTLUPD(value) ((PWM_DTUPD_DTLUPD_Msk & ((value) << PWM_DTUPD_DTLUPD_Pos)))
/* -------- PWM_CMUPD0 : (PWM Offset: 0x400) PWM Channel Mode Update Register (ch_num = 0) -------- */
#define PWM_CMUPD0_CPOLUP (0x1u << 9) /**< \brief (PWM_CMUPD0) Channel Polarity Update */
#define PWM_CMUPD0_CPOLINVUP (0x1u << 13) /**< \brief (PWM_CMUPD0) Channel Polarity Inversion Update */
/* -------- PWM_CMUPD1 : (PWM Offset: 0x420) PWM Channel Mode Update Register (ch_num = 1) -------- */
#define PWM_CMUPD1_CPOLUP (0x1u << 9) /**< \brief (PWM_CMUPD1) Channel Polarity Update */
#define PWM_CMUPD1_CPOLINVUP (0x1u << 13) /**< \brief (PWM_CMUPD1) Channel Polarity Inversion Update */
/* -------- PWM_CMUPD2 : (PWM Offset: 0x440) PWM Channel Mode Update Register (ch_num = 2) -------- */
#define PWM_CMUPD2_CPOLUP (0x1u << 9) /**< \brief (PWM_CMUPD2) Channel Polarity Update */
#define PWM_CMUPD2_CPOLINVUP (0x1u << 13) /**< \brief (PWM_CMUPD2) Channel Polarity Inversion Update */
/* -------- PWM_CMUPD3 : (PWM Offset: 0x460) PWM Channel Mode Update Register (ch_num = 3) -------- */
#define PWM_CMUPD3_CPOLUP (0x1u << 9) /**< \brief (PWM_CMUPD3) Channel Polarity Update */
#define PWM_CMUPD3_CPOLINVUP (0x1u << 13) /**< \brief (PWM_CMUPD3) Channel Polarity Inversion Update */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Reset Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_RSTC Reset Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Rstc hardware registers */
typedef struct {
  __O  uint32_t RSTC_CR; /**< \brief (Rstc Offset: 0x00) Control Register */
  __I  uint32_t RSTC_SR; /**< \brief (Rstc Offset: 0x04) Status Register */
  __IO uint32_t RSTC_MR; /**< \brief (Rstc Offset: 0x08) Mode Register */
} Rstc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- RSTC_CR : (RSTC Offset: 0x00) Control Register -------- */
#define RSTC_CR_PROCRST (0x1u << 0) /**< \brief (RSTC_CR) Processor Reset */
#define RSTC_CR_PERRST (0x1u << 2) /**< \brief (RSTC_CR) Peripheral Reset */
#define RSTC_CR_EXTRST (0x1u << 3) /**< \brief (RSTC_CR) External Reset */
#define RSTC_CR_KEY_Pos 24
#define RSTC_CR_KEY_Msk (0xffu << RSTC_CR_KEY_Pos) /**< \brief (RSTC_CR) Password */
#define RSTC_CR_KEY(value) ((RSTC_CR_KEY_Msk & ((value) << RSTC_CR_KEY_Pos)))
/* -------- RSTC_SR : (RSTC Offset: 0x04) Status Register -------- */
#define RSTC_SR_URSTS (0x1u << 0) /**< \brief (RSTC_SR) User Reset Status */
#define RSTC_SR_RSTTYP_Pos 8
#define RSTC_SR_RSTTYP_Msk (0x7u << RSTC_SR_RSTTYP_Pos) /**< \brief (RSTC_SR) Reset Type */
#define RSTC_SR_NRSTL (0x1u << 16) /**< \brief (RSTC_SR) NRST Pin Level */
#define RSTC_SR_SRCMP (0x1u << 17) /**< \brief (RSTC_SR) Software Reset Command in Progress */
/* -------- RSTC_MR : (RSTC Offset: 0x08) Mode Register -------- */
#define RSTC_MR_URSTEN (0x1u << 0) /**< \brief (RSTC_MR) User Reset Enable */
#define RSTC_MR_URSTIEN (0x1u << 4) /**< \brief (RSTC_MR) User Reset Interrupt Enable */
#define RSTC_MR_ERSTL_Pos 8
#define RSTC_MR_ERSTL_Msk (0xfu << RSTC_MR_ERSTL_Pos) /**< \brief (RSTC_MR) External Reset Length */
#define RSTC_MR_ERSTL(value) ((RSTC_MR_ERSTL_Msk & ((value) << RSTC_MR_ERSTL_Pos)))
#define RSTC_MR_KEY_Pos 24
#define RSTC_MR_KEY_Msk (0xffu << RSTC_MR_KEY_Pos) /**< \brief (RSTC_MR) Password */
#define RSTC_MR_KEY(value) ((RSTC_MR_KEY_Msk & ((value) << RSTC_MR_KEY_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Real-time Clock */
/* ============================================================================= */
/** \addtogroup SAMA5D4_RTC Real-time Clock */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief RtcTs hardware registers */
typedef struct {
  __I uint32_t RTC_TSTR; /**< \brief (RtcTs Offset: 0x0) TimeStamp Time Register 0 */
  __I uint32_t RTC_TSDR; /**< \brief (RtcTs Offset: 0x4) TimeStamp Date Register 0 */
  __I uint32_t RTC_TSSR; /**< \brief (RtcTs Offset: 0x8) TimeStamp Source Register 0 */
} RtcTs;
/** \brief Rtc hardware registers */
#define RTCTS_NUMBER 2
typedef struct {
  __IO uint32_t RTC_CR;               /**< \brief (Rtc Offset: 0x00) Control Register */
  __IO uint32_t RTC_MR;               /**< \brief (Rtc Offset: 0x04) Mode Register */
  __IO uint32_t RTC_TIMR;             /**< \brief (Rtc Offset: 0x08) Time Register */
  __IO uint32_t RTC_CALR;             /**< \brief (Rtc Offset: 0x0C) Calendar Register */
  __IO uint32_t RTC_TIMALR;           /**< \brief (Rtc Offset: 0x10) Time Alarm Register */
  __IO uint32_t RTC_CALALR;           /**< \brief (Rtc Offset: 0x14) Calendar Alarm Register */
  __I  uint32_t RTC_SR;               /**< \brief (Rtc Offset: 0x18) Status Register */
  __O  uint32_t RTC_SCCR;             /**< \brief (Rtc Offset: 0x1C) Status Clear Command Register */
  __O  uint32_t RTC_IER;              /**< \brief (Rtc Offset: 0x20) Interrupt Enable Register */
  __O  uint32_t RTC_IDR;              /**< \brief (Rtc Offset: 0x24) Interrupt Disable Register */
  __I  uint32_t RTC_IMR;              /**< \brief (Rtc Offset: 0x28) Interrupt Mask Register */
  __I  uint32_t RTC_VER;              /**< \brief (Rtc Offset: 0x2C) Valid Entry Register */
  __I  uint32_t Reserved1[32];
       RtcTs    RTC_TS[RTCTS_NUMBER]; /**< \brief (Rtc Offset: 0xB0) 0 .. 1 */
} Rtc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- RTC_CR : (RTC Offset: 0x00) Control Register -------- */
#define RTC_CR_UPDTIM (0x1u << 0) /**< \brief (RTC_CR) Update Request Time Register */
#define RTC_CR_UPDCAL (0x1u << 1) /**< \brief (RTC_CR) Update Request Calendar Register */
#define RTC_CR_TIMEVSEL_Pos 8
#define RTC_CR_TIMEVSEL_Msk (0x3u << RTC_CR_TIMEVSEL_Pos) /**< \brief (RTC_CR) Time Event Selection */
#define   RTC_CR_TIMEVSEL_MINUTE (0x0u << 8) /**< \brief (RTC_CR) Minute change */
#define   RTC_CR_TIMEVSEL_HOUR (0x1u << 8) /**< \brief (RTC_CR) Hour change */
#define   RTC_CR_TIMEVSEL_MIDNIGHT (0x2u << 8) /**< \brief (RTC_CR) Every day at midnight */
#define   RTC_CR_TIMEVSEL_NOON (0x3u << 8) /**< \brief (RTC_CR) Every day at noon */
#define RTC_CR_CALEVSEL_Pos 16
#define RTC_CR_CALEVSEL_Msk (0x3u << RTC_CR_CALEVSEL_Pos) /**< \brief (RTC_CR) Calendar Event Selection */
#define   RTC_CR_CALEVSEL_WEEK (0x0u << 16) /**< \brief (RTC_CR) Week change (every Monday at time 00:00:00) */
#define   RTC_CR_CALEVSEL_MONTH (0x1u << 16) /**< \brief (RTC_CR) Month change (every 01 of each month at time 00:00:00) */
#define   RTC_CR_CALEVSEL_YEAR (0x2u << 16) /**< \brief (RTC_CR) Year change (every January 1 at time 00:00:00) */
/* -------- RTC_MR : (RTC Offset: 0x04) Mode Register -------- */
#define RTC_MR_HRMOD (0x1u << 0) /**< \brief (RTC_MR) 12-/24-hour Mode */
#define RTC_MR_PERSIAN (0x1u << 1) /**< \brief (RTC_MR) PERSIAN Calendar */
#define RTC_MR_NEGPPM (0x1u << 4) /**< \brief (RTC_MR) NEGative PPM Correction */
#define RTC_MR_CORRECTION_Pos 8
#define RTC_MR_CORRECTION_Msk (0x7fu << RTC_MR_CORRECTION_Pos) /**< \brief (RTC_MR) Slow Clock Correction */
#define RTC_MR_CORRECTION(value) ((RTC_MR_CORRECTION_Msk & ((value) << RTC_MR_CORRECTION_Pos)))
#define RTC_MR_HIGHPPM (0x1u << 15) /**< \brief (RTC_MR) HIGH PPM Correction */
/* -------- RTC_TIMR : (RTC Offset: 0x08) Time Register -------- */
#define RTC_TIMR_SEC_Pos 0
#define RTC_TIMR_SEC_Msk (0x7fu << RTC_TIMR_SEC_Pos) /**< \brief (RTC_TIMR) Current Second */
#define RTC_TIMR_SEC(value) ((RTC_TIMR_SEC_Msk & ((value) << RTC_TIMR_SEC_Pos)))
#define RTC_TIMR_MIN_Pos 8
#define RTC_TIMR_MIN_Msk (0x7fu << RTC_TIMR_MIN_Pos) /**< \brief (RTC_TIMR) Current Minute */
#define RTC_TIMR_MIN(value) ((RTC_TIMR_MIN_Msk & ((value) << RTC_TIMR_MIN_Pos)))
#define RTC_TIMR_HOUR_Pos 16
#define RTC_TIMR_HOUR_Msk (0x3fu << RTC_TIMR_HOUR_Pos) /**< \brief (RTC_TIMR) Current Hour */
#define RTC_TIMR_HOUR(value) ((RTC_TIMR_HOUR_Msk & ((value) << RTC_TIMR_HOUR_Pos)))
#define RTC_TIMR_AMPM (0x1u << 22) /**< \brief (RTC_TIMR) Ante Meridiem Post Meridiem Indicator */
/* -------- RTC_CALR : (RTC Offset: 0x0C) Calendar Register -------- */
#define RTC_CALR_CENT_Pos 0
#define RTC_CALR_CENT_Msk (0x7fu << RTC_CALR_CENT_Pos) /**< \brief (RTC_CALR) Current Century */
#define RTC_CALR_CENT(value) ((RTC_CALR_CENT_Msk & ((value) << RTC_CALR_CENT_Pos)))
#define RTC_CALR_YEAR_Pos 8
#define RTC_CALR_YEAR_Msk (0xffu << RTC_CALR_YEAR_Pos) /**< \brief (RTC_CALR) Current Year */
#define RTC_CALR_YEAR(value) ((RTC_CALR_YEAR_Msk & ((value) << RTC_CALR_YEAR_Pos)))
#define RTC_CALR_MONTH_Pos 16
#define RTC_CALR_MONTH_Msk (0x1fu << RTC_CALR_MONTH_Pos) /**< \brief (RTC_CALR) Current Month */
#define RTC_CALR_MONTH(value) ((RTC_CALR_MONTH_Msk & ((value) << RTC_CALR_MONTH_Pos)))
#define RTC_CALR_DAY_Pos 21
#define RTC_CALR_DAY_Msk (0x7u << RTC_CALR_DAY_Pos) /**< \brief (RTC_CALR) Current Day in Current Week */
#define RTC_CALR_DAY(value) ((RTC_CALR_DAY_Msk & ((value) << RTC_CALR_DAY_Pos)))
#define RTC_CALR_DATE_Pos 24
#define RTC_CALR_DATE_Msk (0x3fu << RTC_CALR_DATE_Pos) /**< \brief (RTC_CALR) Current Day in Current Month */
#define RTC_CALR_DATE(value) ((RTC_CALR_DATE_Msk & ((value) << RTC_CALR_DATE_Pos)))
/* -------- RTC_TIMALR : (RTC Offset: 0x10) Time Alarm Register -------- */
#define RTC_TIMALR_SEC_Pos 0
#define RTC_TIMALR_SEC_Msk (0x7fu << RTC_TIMALR_SEC_Pos) /**< \brief (RTC_TIMALR) Second Alarm */
#define RTC_TIMALR_SEC(value) ((RTC_TIMALR_SEC_Msk & ((value) << RTC_TIMALR_SEC_Pos)))
#define RTC_TIMALR_SECEN (0x1u << 7) /**< \brief (RTC_TIMALR) Second Alarm Enable */
#define RTC_TIMALR_MIN_Pos 8
#define RTC_TIMALR_MIN_Msk (0x7fu << RTC_TIMALR_MIN_Pos) /**< \brief (RTC_TIMALR) Minute Alarm */
#define RTC_TIMALR_MIN(value) ((RTC_TIMALR_MIN_Msk & ((value) << RTC_TIMALR_MIN_Pos)))
#define RTC_TIMALR_MINEN (0x1u << 15) /**< \brief (RTC_TIMALR) Minute Alarm Enable */
#define RTC_TIMALR_HOUR_Pos 16
#define RTC_TIMALR_HOUR_Msk (0x3fu << RTC_TIMALR_HOUR_Pos) /**< \brief (RTC_TIMALR) Hour Alarm */
#define RTC_TIMALR_HOUR(value) ((RTC_TIMALR_HOUR_Msk & ((value) << RTC_TIMALR_HOUR_Pos)))
#define RTC_TIMALR_AMPM (0x1u << 22) /**< \brief (RTC_TIMALR) AM/PM Indicator */
#define RTC_TIMALR_HOUREN (0x1u << 23) /**< \brief (RTC_TIMALR) Hour Alarm Enable */
/* -------- RTC_CALALR : (RTC Offset: 0x14) Calendar Alarm Register -------- */
#define RTC_CALALR_MONTH_Pos 16
#define RTC_CALALR_MONTH_Msk (0x1fu << RTC_CALALR_MONTH_Pos) /**< \brief (RTC_CALALR) Month Alarm */
#define RTC_CALALR_MONTH(value) ((RTC_CALALR_MONTH_Msk & ((value) << RTC_CALALR_MONTH_Pos)))
#define RTC_CALALR_MTHEN (0x1u << 23) /**< \brief (RTC_CALALR) Month Alarm Enable */
#define RTC_CALALR_DATE_Pos 24
#define RTC_CALALR_DATE_Msk (0x3fu << RTC_CALALR_DATE_Pos) /**< \brief (RTC_CALALR) Date Alarm */
#define RTC_CALALR_DATE(value) ((RTC_CALALR_DATE_Msk & ((value) << RTC_CALALR_DATE_Pos)))
#define RTC_CALALR_DATEEN (0x1u << 31) /**< \brief (RTC_CALALR) Date Alarm Enable */
/* -------- RTC_SR : (RTC Offset: 0x18) Status Register -------- */
#define RTC_SR_ACKUPD (0x1u << 0) /**< \brief (RTC_SR) Acknowledge for Update */
#define   RTC_SR_ACKUPD_FREERUN (0x0u << 0) /**< \brief (RTC_SR) Time and calendar registers cannot be updated. */
#define   RTC_SR_ACKUPD_UPDATE (0x1u << 0) /**< \brief (RTC_SR) Time and calendar registers can be updated. */
#define RTC_SR_ALARM (0x1u << 1) /**< \brief (RTC_SR) Alarm Flag */
#define   RTC_SR_ALARM_NO_ALARMEVENT (0x0u << 1) /**< \brief (RTC_SR) No alarm matching condition occurred. */
#define   RTC_SR_ALARM_ALARMEVENT (0x1u << 1) /**< \brief (RTC_SR) An alarm matching condition has occurred. */
#define RTC_SR_SEC (0x1u << 2) /**< \brief (RTC_SR) Second Event */
#define   RTC_SR_SEC_NO_SECEVENT (0x0u << 2) /**< \brief (RTC_SR) No second event has occurred since the last clear. */
#define   RTC_SR_SEC_SECEVENT (0x1u << 2) /**< \brief (RTC_SR) At least one second event has occurred since the last clear. */
#define RTC_SR_TIMEV (0x1u << 3) /**< \brief (RTC_SR) Time Event */
#define   RTC_SR_TIMEV_NO_TIMEVENT (0x0u << 3) /**< \brief (RTC_SR) No time event has occurred since the last clear. */
#define   RTC_SR_TIMEV_TIMEVENT (0x1u << 3) /**< \brief (RTC_SR) At least one time event has occurred since the last clear. */
#define RTC_SR_CALEV (0x1u << 4) /**< \brief (RTC_SR) Calendar Event */
#define   RTC_SR_CALEV_NO_CALEVENT (0x0u << 4) /**< \brief (RTC_SR) No calendar event has occurred since the last clear. */
#define   RTC_SR_CALEV_CALEVENT (0x1u << 4) /**< \brief (RTC_SR) At least one calendar event has occurred since the last clear. */
#define RTC_SR_TDERR (0x1u << 5) /**< \brief (RTC_SR) Time and/or Date Free Running Error */
#define   RTC_SR_TDERR_CORRECT (0x0u << 5) /**< \brief (RTC_SR) The internal free running counters are carrying valid values since the last read of RTC_SR. */
#define   RTC_SR_TDERR_ERR_TIMEDATE (0x1u << 5) /**< \brief (RTC_SR) The internal free running counters have been corrupted (invalid date or time, non-BCD values) since the last read and/or they are still invalid. */
/* -------- RTC_SCCR : (RTC Offset: 0x1C) Status Clear Command Register -------- */
#define RTC_SCCR_ACKCLR (0x1u << 0) /**< \brief (RTC_SCCR) Acknowledge Clear */
#define RTC_SCCR_ALRCLR (0x1u << 1) /**< \brief (RTC_SCCR) Alarm Clear */
#define RTC_SCCR_SECCLR (0x1u << 2) /**< \brief (RTC_SCCR) Second Clear */
#define RTC_SCCR_TIMCLR (0x1u << 3) /**< \brief (RTC_SCCR) Time Clear */
#define RTC_SCCR_CALCLR (0x1u << 4) /**< \brief (RTC_SCCR) Calendar Clear */
#define RTC_SCCR_TDERRCLR (0x1u << 5) /**< \brief (RTC_SCCR) Time and/or Date Free Running Error Clear */
/* -------- RTC_IER : (RTC Offset: 0x20) Interrupt Enable Register -------- */
#define RTC_IER_ACKEN (0x1u << 0) /**< \brief (RTC_IER) Acknowledge Update Interrupt Enable */
#define RTC_IER_ALREN (0x1u << 1) /**< \brief (RTC_IER) Alarm Interrupt Enable */
#define RTC_IER_SECEN (0x1u << 2) /**< \brief (RTC_IER) Second Event Interrupt Enable */
#define RTC_IER_TIMEN (0x1u << 3) /**< \brief (RTC_IER) Time Event Interrupt Enable */
#define RTC_IER_CALEN (0x1u << 4) /**< \brief (RTC_IER) Calendar Event Interrupt Enable */
#define RTC_IER_TDERREN (0x1u << 5) /**< \brief (RTC_IER) Time and/or Date Error Interrupt Enable */
/* -------- RTC_IDR : (RTC Offset: 0x24) Interrupt Disable Register -------- */
#define RTC_IDR_ACKDIS (0x1u << 0) /**< \brief (RTC_IDR) Acknowledge Update Interrupt Disable */
#define RTC_IDR_ALRDIS (0x1u << 1) /**< \brief (RTC_IDR) Alarm Interrupt Disable */
#define RTC_IDR_SECDIS (0x1u << 2) /**< \brief (RTC_IDR) Second Event Interrupt Disable */
#define RTC_IDR_TIMDIS (0x1u << 3) /**< \brief (RTC_IDR) Time Event Interrupt Disable */
#define RTC_IDR_CALDIS (0x1u << 4) /**< \brief (RTC_IDR) Calendar Event Interrupt Disable */
#define RTC_IDR_TDERRDIS (0x1u << 5) /**< \brief (RTC_IDR) Time and/or Date Error Interrupt Disable */
/* -------- RTC_IMR : (RTC Offset: 0x28) Interrupt Mask Register -------- */
#define RTC_IMR_ACK (0x1u << 0) /**< \brief (RTC_IMR) Acknowledge Update Interrupt Mask */
#define RTC_IMR_ALR (0x1u << 1) /**< \brief (RTC_IMR) Alarm Interrupt Mask */
#define RTC_IMR_SEC (0x1u << 2) /**< \brief (RTC_IMR) Second Event Interrupt Mask */
#define RTC_IMR_TIM (0x1u << 3) /**< \brief (RTC_IMR) Time Event Interrupt Mask */
#define RTC_IMR_CAL (0x1u << 4) /**< \brief (RTC_IMR) Calendar Event Interrupt Mask */
/* -------- RTC_VER : (RTC Offset: 0x2C) Valid Entry Register -------- */
#define RTC_VER_NVTIM (0x1u << 0) /**< \brief (RTC_VER) Non-valid Time */
#define RTC_VER_NVCAL (0x1u << 1) /**< \brief (RTC_VER) Non-valid Calendar */
#define RTC_VER_NVTIMALR (0x1u << 2) /**< \brief (RTC_VER) Non-valid Time Alarm */
#define RTC_VER_NVCALALR (0x1u << 3) /**< \brief (RTC_VER) Non-valid Calendar Alarm */
/* -------- RTC_TSTR : (RTC Offset: N/A) TimeStamp Time Register 0 -------- */
#define RTC_TSTR_SEC_Pos 0
#define RTC_TSTR_SEC_Msk (0x7fu << RTC_TSTR_SEC_Pos) /**< \brief (RTC_TSTR) SEConds of the tamper */
#define RTC_TSTR_MIN_Pos 8
#define RTC_TSTR_MIN_Msk (0x7fu << RTC_TSTR_MIN_Pos) /**< \brief (RTC_TSTR) MINutes of the tamper */
#define RTC_TSTR_HOUR_Pos 16
#define RTC_TSTR_HOUR_Msk (0x3fu << RTC_TSTR_HOUR_Pos) /**< \brief (RTC_TSTR) HOURs of the tamper */
#define RTC_TSTR_AMPM (0x1u << 22) /**< \brief (RTC_TSTR) AMPM indicator of the tamper */
#define RTC_TSTR_TEVCNT_Pos 24
#define RTC_TSTR_TEVCNT_Msk (0xfu << RTC_TSTR_TEVCNT_Pos) /**< \brief (RTC_TSTR) Tamper events counter */
#define RTC_TSTR_BACKUP (0x1u << 31) /**< \brief (RTC_TSTR) system mode of the tamper */
/* -------- RTC_TSDR : (RTC Offset: N/A) TimeStamp Date Register 0 -------- */
#define RTC_TSDR_CENT_Pos 0
#define RTC_TSDR_CENT_Msk (0x7fu << RTC_TSDR_CENT_Pos) /**< \brief (RTC_TSDR) Century of the tamper */
#define RTC_TSDR_YEAR_Pos 8
#define RTC_TSDR_YEAR_Msk (0xffu << RTC_TSDR_YEAR_Pos) /**< \brief (RTC_TSDR) Year of the tamper */
#define RTC_TSDR_MONTH_Pos 16
#define RTC_TSDR_MONTH_Msk (0x1fu << RTC_TSDR_MONTH_Pos) /**< \brief (RTC_TSDR) Month of the tamper */
#define RTC_TSDR_DAY_Pos 21
#define RTC_TSDR_DAY_Msk (0x7u << RTC_TSDR_DAY_Pos) /**< \brief (RTC_TSDR) Day of the tamper */
#define RTC_TSDR_DATE_Pos 24
#define RTC_TSDR_DATE_Msk (0x3fu << RTC_TSDR_DATE_Pos) /**< \brief (RTC_TSDR) Date of the tamper */
/* -------- RTC_TSSR : (RTC Offset: N/A) TimeStamp Source Register 0 -------- */
#define RTC_TSSR_SHLDM (0x1u << 0) /**< \brief (RTC_TSSR) Shield Monitor */
#define RTC_TSSR_DBLFM (0x1u << 1) /**< \brief (RTC_TSSR) Double Frequency Monitor */
#define RTC_TSSR_TST (0x1u << 2) /**< \brief (RTC_TSSR) Test pin Monitor */
#define RTC_TSSR_JTAG (0x1u << 3) /**< \brief (RTC_TSSR) JTAG pins Monitor */
#define RTC_TSSR_REGUL (0x1u << 4) /**< \brief (RTC_TSSR) Core regulator disconnection Monitor */
#define RTC_TSSR_MCKM (0x1u << 5) /**< \brief (RTC_TSSR) Master Clock Monitor */
#define RTC_TSSR_TPML (0x1u << 6) /**< \brief (RTC_TSSR) Low Temperature Monitor */
#define RTC_TSSR_TPMH (0x1u << 7) /**< \brief (RTC_TSSR) High Temperature Monitor */
#define RTC_TSSR_VDDRL (0x1u << 8) /**< \brief (RTC_TSSR) Low VDDDDR Voltage Monitor */
#define RTC_TSSR_VDDRH (0x1u << 9) /**< \brief (RTC_TSSR) High VDDDDR Voltage Monitor */
#define RTC_TSSR_VDDBUL (0x1u << 10) /**< \brief (RTC_TSSR) Low VDDBU Voltage Monitor */
#define RTC_TSSR_VDDBUH (0x1u << 11) /**< \brief (RTC_TSSR) High VDDBU Voltage Monitor */
#define RTC_TSSR_VDDCOREL (0x1u << 12) /**< \brief (RTC_TSSR) Low VDDCORE Voltage Monitor */
#define RTC_TSSR_VDDCOREH (0x1u << 13) /**< \brief (RTC_TSSR) High VDDCORE Voltage Monitor */
#define RTC_TSSR_VDDIOL (0x1u << 14) /**< \brief (RTC_TSSR) Low VDDIO Voltage Monitor */
#define RTC_TSSR_VDDIOH (0x1u << 15) /**< \brief (RTC_TSSR) High VDDIO Voltage Monitor */
#define RTC_TSSR_DET0 (0x1u << 16) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET1 (0x1u << 17) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET2 (0x1u << 18) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET3 (0x1u << 19) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET4 (0x1u << 20) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET5 (0x1u << 21) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET6 (0x1u << 22) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET7 (0x1u << 23) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET8 (0x1u << 24) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET9 (0x1u << 25) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET10 (0x1u << 26) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET11 (0x1u << 27) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET12 (0x1u << 28) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET13 (0x1u << 29) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET14 (0x1u << 30) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */
#define RTC_TSSR_DET15 (0x1u << 31) /**< \brief (RTC_TSSR) PIOBU Intrusion Detector */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Slow Clock Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SCKC Slow Clock Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Sckc hardware registers */
typedef struct {
  __IO uint32_t SCKC_CR; /**< \brief (Sckc Offset: 0x0) Slow Clock Configuration Register */
} Sckc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SCKC_CR : (SCKC Offset: 0x0) Slow Clock Configuration Register -------- */
#define SCKC_CR_OSCSEL (0x1u << 3) /**< \brief (SCKC_CR) Slow Clock Selector */
#define   SCKC_CR_OSCSEL_RC (0x0u << 3) /**< \brief (SCKC_CR) Slow clock is internal 32 kHz RC oscillator. */
#define   SCKC_CR_OSCSEL_XTAL (0x1u << 3) /**< \brief (SCKC_CR) Slow clock is 32768 Hz oscillator. */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Secure Fuse Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SFC Secure Fuse Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Sfc hardware registers */
typedef struct {
  __O  uint32_t SFC_KR;       /**< \brief (Sfc Offset: 0x00) SFC Key Register */
  __IO uint32_t SFC_MR;       /**< \brief (Sfc Offset: 0X04) SFC Mode Register */
  __I  uint32_t Reserved1[2];
  __IO uint32_t SFC_IER;      /**< \brief (Sfc Offset: 0x10) SFC Interrupt Enable Register */
  __IO uint32_t SFC_IDR;      /**< \brief (Sfc Offset: 0x14) SFC Interrupt Disable Register */
  __I  uint32_t SFC_IMR;      /**< \brief (Sfc Offset: 0x18) SFC Interrupt Mask Register */
  __I  uint32_t SFC_SR;       /**< \brief (Sfc Offset: 0x1C) SFC Status Register */
  __IO uint32_t SFC_DR[24];   /**< \brief (Sfc Offset: 0x20) SFC Data Register */
} Sfc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SFC_KR : (SFC Offset: 0x00) SFC Key Register -------- */
#define SFC_KR_KEY_Pos 0
#define SFC_KR_KEY_Msk (0xffu << SFC_KR_KEY_Pos) /**< \brief (SFC_KR) Key Code */
#define SFC_KR_KEY(value) ((SFC_KR_KEY_Msk & ((value) << SFC_KR_KEY_Pos)))
/* -------- SFC_MR : (SFC Offset: 0X04) SFC Mode Register -------- */
#define SFC_MR_MSK (0x1u << 0) /**< \brief (SFC_MR) Mask Data Registers */
/* -------- SFC_IER : (SFC Offset: 0x10) SFC Interrupt Enable Register -------- */
#define SFC_IER_PGMC (0x1u << 0) /**< \brief (SFC_IER) Programming Sequence Completed Interrupt Enable */
#define SFC_IER_APLE (0x1u << 16) /**< \brief (SFC_IER) ATMEL Programming Lock Error Interrupt Enable */
#define SFC_IER_ACE (0x1u << 17) /**< \brief (SFC_IER) ATMEL Check Error Interrupt Enable */
/* -------- SFC_IDR : (SFC Offset: 0x14) SFC Interrupt Disable Register -------- */
#define SFC_IDR_PGMC (0x1u << 0) /**< \brief (SFC_IDR) Programming Sequence Completed Interrupt Disable */
#define SFC_IDR_APLE (0x1u << 16) /**< \brief (SFC_IDR) ATMEL Programming Lock Error Interrupt Disable */
#define SFC_IDR_ACE (0x1u << 17) /**< \brief (SFC_IDR) ATMEL Check Error Interrupt Disable */
/* -------- SFC_IMR : (SFC Offset: 0x18) SFC Interrupt Mask Register -------- */
#define SFC_IMR_PGMC (0x1u << 0) /**< \brief (SFC_IMR) Programming Sequence Completed Interrupt Mask */
#define SFC_IMR_APLE (0x1u << 16) /**< \brief (SFC_IMR) ATMEL Programming Lock Error Interrupt Mask */
#define SFC_IMR_ACE (0x1u << 17) /**< \brief (SFC_IMR) ATMEL Check Error Interrupt Mask */
/* -------- SFC_SR : (SFC Offset: 0x1C) SFC Status Register -------- */
#define SFC_SR_PGMC (0x1u << 0) /**< \brief (SFC_SR) Programming Sequence Completed */
#define SFC_SR_APLE (0x1u << 16) /**< \brief (SFC_SR) ATMEL Programming Lock Error */
#define SFC_SR_ACE (0x1u << 17) /**< \brief (SFC_SR) ATMEL Check Error */
/* -------- SFC_DR[24] : (SFC Offset: 0x20) SFC Data Register -------- */
#define SFC_DR_DATA_Pos 0
#define SFC_DR_DATA_Msk (0xffffffffu << SFC_DR_DATA_Pos) /**< \brief (SFC_DR[24]) Fuse Data */
#define SFC_DR_DATA(value) ((SFC_DR_DATA_Msk & ((value) << SFC_DR_DATA_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Special Function Registers */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SFR Special Function Registers */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Sfr hardware registers */
typedef struct {
  __I  uint32_t Reserved1[4];
  __IO uint32_t SFR_OHCIICR;  /**< \brief (Sfr Offset: 0x10) OHCI Interrupt Configuration Register */
  __I  uint32_t SFR_OHCIISR;  /**< \brief (Sfr Offset: 0x14) OHCI Interrupt Status Register */
  __I  uint32_t Reserved2[4];
  __IO uint32_t SFR_SECURE;   /**< \brief (Sfr Offset: 0x28) Security Configuration Register */
  __I  uint32_t Reserved3[5];
  __IO uint32_t SFR_EBICFG;   /**< \brief (Sfr Offset: 0x40) EBI Configuration Register */
  __I  uint32_t Reserved4[2];
  __I  uint32_t SFR_SN0;      /**< \brief (Sfr Offset: 0x4C) Serial Number 0 Register */
  __I  uint32_t SFR_SN1;      /**< \brief (Sfr Offset: 0x50) Seriel Number 1 Register */
} Sfr;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SFR_OHCIICR : (SFR Offset: 0x10) OHCI Interrupt Configuration Register -------- */
#define SFR_OHCIICR_RES0 (0x1u << 0) /**< \brief (SFR_OHCIICR) USB PORTx RESET */
#define SFR_OHCIICR_RES1 (0x1u << 1) /**< \brief (SFR_OHCIICR) USB PORTx RESET */
#define SFR_OHCIICR_RES2 (0x1u << 2) /**< \brief (SFR_OHCIICR) USB PORTx RESET */
#define SFR_OHCIICR_ARIE (0x1u << 4) /**< \brief (SFR_OHCIICR) OHCI Asynchronous Resume Interrupt Enable */
#define SFR_OHCIICR_APPSTART (0x1u << 5) /**< \brief (SFR_OHCIICR) Reserved */
#define SFR_OHCIICR_UDPPUDIS (0x1u << 23) /**< \brief (SFR_OHCIICR) USB DEVICE PULL-UP DISABLE */
/* -------- SFR_OHCIISR : (SFR Offset: 0x14) OHCI Interrupt Status Register -------- */
#define SFR_OHCIISR_RIS0 (0x1u << 0) /**< \brief (SFR_OHCIISR) OHCI Resume Interrupt Status Port 0 */
#define SFR_OHCIISR_RIS1 (0x1u << 1) /**< \brief (SFR_OHCIISR) OHCI Resume Interrupt Status Port 1 */
#define SFR_OHCIISR_RIS2 (0x1u << 2) /**< \brief (SFR_OHCIISR) OHCI Resume Interrupt Status Port 2 */
/* -------- SFR_SECURE : (SFR Offset: 0x28) Security Configuration Register -------- */
#define SFR_SECURE_ROM (0x1u << 0) /**< \brief (SFR_SECURE) Disable Access to ROM Code */
#define SFR_SECURE_FUSE (0x1u << 8) /**< \brief (SFR_SECURE) Disable Access to Fuse Controller */
/* -------- SFR_EBICFG : (SFR Offset: 0x40) EBI Configuration Register -------- */
#define SFR_EBICFG_DRIVE0_Pos 0
#define SFR_EBICFG_DRIVE0_Msk (0x3u << SFR_EBICFG_DRIVE0_Pos) /**< \brief (SFR_EBICFG) EBI Pins Drive Level */
#define   SFR_EBICFG_DRIVE0_LOW (0x0u << 0) /**< \brief (SFR_EBICFG) Low drive level */
#define   SFR_EBICFG_DRIVE0_MEDIUM (0x2u << 0) /**< \brief (SFR_EBICFG) Medium drive level */
#define   SFR_EBICFG_DRIVE0_HIGH (0x3u << 0) /**< \brief (SFR_EBICFG) High drive level */
#define SFR_EBICFG_PULL0_Pos 2
#define SFR_EBICFG_PULL0_Msk (0x3u << SFR_EBICFG_PULL0_Pos) /**< \brief (SFR_EBICFG) EBI Pins Pull Value */
#define   SFR_EBICFG_PULL0_UP (0x0u << 2) /**< \brief (SFR_EBICFG) Pull-up */
#define   SFR_EBICFG_PULL0_NONE (0x1u << 2) /**< \brief (SFR_EBICFG) No Pull */
#define   SFR_EBICFG_PULL0_DOWN (0x3u << 2) /**< \brief (SFR_EBICFG) Pull-down */
#define SFR_EBICFG_SCH0 (0x1u << 4) /**< \brief (SFR_EBICFG) EBI Pins Schmitt Trigger */
#define SFR_EBICFG_DRIVE1_Pos 8
#define SFR_EBICFG_DRIVE1_Msk (0x3u << SFR_EBICFG_DRIVE1_Pos) /**< \brief (SFR_EBICFG) EBI Pins Drive Level */
#define   SFR_EBICFG_DRIVE1_LOW (0x0u << 8) /**< \brief (SFR_EBICFG) Low drive level */
#define   SFR_EBICFG_DRIVE1_MEDIUM (0x2u << 8) /**< \brief (SFR_EBICFG) Medium drive level */
#define   SFR_EBICFG_DRIVE1_HIGH (0x3u << 8) /**< \brief (SFR_EBICFG) High drive level */
#define SFR_EBICFG_PULL1_Pos 10
#define SFR_EBICFG_PULL1_Msk (0x3u << SFR_EBICFG_PULL1_Pos) /**< \brief (SFR_EBICFG) EBI Pins Pull Value */
#define   SFR_EBICFG_PULL1_UP (0x0u << 10) /**< \brief (SFR_EBICFG) Pull-up */
#define   SFR_EBICFG_PULL1_NONE (0x1u << 10) /**< \brief (SFR_EBICFG) No Pull */
#define   SFR_EBICFG_PULL1_DOWN (0x3u << 10) /**< \brief (SFR_EBICFG) Pull-down */
#define SFR_EBICFG_SCH1 (0x1u << 12) /**< \brief (SFR_EBICFG) EBI Pins Schmitt Trigger */
#define SFR_EBICFG_BMS (0x1u << 16) /**< \brief (SFR_EBICFG) BMS Sampled Value (Read Only) */
#define   SFR_EBICFG_BMS_ROM (0x0u << 16) /**< \brief (SFR_EBICFG) Boot on ROM. */
#define   SFR_EBICFG_BMS_EBI (0x1u << 16) /**< \brief (SFR_EBICFG) Boot on EBI. */
/* -------- SFR_SN0 : (SFR Offset: 0x4C) Serial Number 0 Register -------- */
#define SFR_SN0_SN0_Pos 0
#define SFR_SN0_SN0_Msk (0xffffffffu << SFR_SN0_SN0_Pos) /**< \brief (SFR_SN0) Serial Number 0 */
/* -------- SFR_SN1 : (SFR Offset: 0x50) Seriel Number 1 Register -------- */
#define SFR_SN1_SN1_Pos 0
#define SFR_SN1_SN1_Msk (0xffffffu << SFR_SN1_SN1_Pos) /**< \brief (SFR_SN1) Serial Number 1 */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Secure Hash Algorithm */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SHA Secure Hash Algorithm */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Sha hardware registers */
typedef struct {
  __O  uint32_t SHA_CR;          /**< \brief (Sha Offset: 0x00) Control Register */
  __IO uint32_t SHA_MR;          /**< \brief (Sha Offset: 0x04) Mode Register */
  __I  uint32_t Reserved1[2];
  __O  uint32_t SHA_IER;         /**< \brief (Sha Offset: 0x10) Interrupt Enable Register */
  __O  uint32_t SHA_IDR;         /**< \brief (Sha Offset: 0x14) Interrupt Disable Register */
  __I  uint32_t SHA_IMR;         /**< \brief (Sha Offset: 0x18) Interrupt Mask Register */
  __I  uint32_t SHA_ISR;         /**< \brief (Sha Offset: 0x1C) Interrupt Status Register */
  __I  uint32_t Reserved2[8];
  __O  uint32_t SHA_IDATAR[16];  /**< \brief (Sha Offset: 0x40) Input Data 0 Register */
  __IO uint32_t SHA_IODATAR[16]; /**< \brief (Sha Offset: 0x80) Input/Output Data 0 Register */
} Sha;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SHA_CR : (SHA Offset: 0x00) Control Register -------- */
#define SHA_CR_START (0x1u << 0) /**< \brief (SHA_CR) Start Processing */
#define SHA_CR_FIRST (0x1u << 4) /**< \brief (SHA_CR) First Block of a Message */
#define SHA_CR_SWRST (0x1u << 8) /**< \brief (SHA_CR) Software Reset */
/* -------- SHA_MR : (SHA Offset: 0x04) Mode Register -------- */
#define SHA_MR_SMOD_Pos 0
#define SHA_MR_SMOD_Msk (0x3u << SHA_MR_SMOD_Pos) /**< \brief (SHA_MR) Start Mode */
#define   SHA_MR_SMOD_MANUAL_START (0x0u << 0) /**< \brief (SHA_MR) Manual Mode */
#define   SHA_MR_SMOD_AUTO_START (0x1u << 0) /**< \brief (SHA_MR) Auto Mode */
#define   SHA_MR_SMOD_IDATAR0_START (0x2u << 0) /**< \brief (SHA_MR) SHA_IDATAR0 access only Auto Mode */
#define SHA_MR_PROCDLY (0x1u << 4) /**< \brief (SHA_MR) Processing Delay */
#define   SHA_MR_PROCDLY_SHORTEST (0x0u << 4) /**< \brief (SHA_MR) SHA processing runtime is the shortest one */
#define   SHA_MR_PROCDLY_LONGEST (0x1u << 4) /**< \brief (SHA_MR) SHA processing runtime is the longest one */
#define SHA_MR_ALGO_Pos 8
#define SHA_MR_ALGO_Msk (0x7u << SHA_MR_ALGO_Pos) /**< \brief (SHA_MR) SHA Algorithm. */
#define   SHA_MR_ALGO_SHA1 (0x0u << 8) /**< \brief (SHA_MR) SHA1 algorithm processed */
#define   SHA_MR_ALGO_SHA256 (0x1u << 8) /**< \brief (SHA_MR) SHA256 algorithm processed */
#define   SHA_MR_ALGO_SHA384 (0x2u << 8) /**< \brief (SHA_MR) SHA384 algorithm processed */
#define   SHA_MR_ALGO_SHA512 (0x3u << 8) /**< \brief (SHA_MR) SHA512 algorithm processed */
#define   SHA_MR_ALGO_SHA224 (0x4u << 8) /**< \brief (SHA_MR) SHA224 algorithm processed */
#define SHA_MR_DUALBUFF (0x1u << 16) /**< \brief (SHA_MR) Dual Input BUFFer */
#define   SHA_MR_DUALBUFF_INACTIVE (0x0u << 16) /**< \brief (SHA_MR) SHA_IDATARx and SHA_IODATARx cannot be written during processing of previous block. */
#define   SHA_MR_DUALBUFF_ACTIVE (0x1u << 16) /**< \brief (SHA_MR) SHA_IDATARx and SHA_IODATARx can be written during processing of previous block when SMOD=0x2. It speeds up the overall runtime of large files. */
/* -------- SHA_IER : (SHA Offset: 0x10) Interrupt Enable Register -------- */
#define SHA_IER_DATRDY (0x1u << 0) /**< \brief (SHA_IER) Data Ready Interrupt Enable */
#define SHA_IER_URAD (0x1u << 8) /**< \brief (SHA_IER) Unspecified Register Access Detection Interrupt Enable */
/* -------- SHA_IDR : (SHA Offset: 0x14) Interrupt Disable Register -------- */
#define SHA_IDR_DATRDY (0x1u << 0) /**< \brief (SHA_IDR) Data Ready Interrupt Disable */
#define SHA_IDR_URAD (0x1u << 8) /**< \brief (SHA_IDR) Unspecified Register Access Detection Interrupt Disable */
/* -------- SHA_IMR : (SHA Offset: 0x18) Interrupt Mask Register -------- */
#define SHA_IMR_DATRDY (0x1u << 0) /**< \brief (SHA_IMR) Data Ready Interrupt Mask */
#define SHA_IMR_URAD (0x1u << 8) /**< \brief (SHA_IMR) Unspecified Register Access Detection Interrupt Mask */
/* -------- SHA_ISR : (SHA Offset: 0x1C) Interrupt Status Register -------- */
#define SHA_ISR_DATRDY (0x1u << 0) /**< \brief (SHA_ISR) Data Ready */
#define SHA_ISR_URAD (0x1u << 8) /**< \brief (SHA_ISR) Unspecified Register Access Detection Status */
#define SHA_ISR_URAT_Pos 12
#define SHA_ISR_URAT_Msk (0x7u << SHA_ISR_URAT_Pos) /**< \brief (SHA_ISR) Unspecified Register Access Type */
/* -------- SHA_IDATAR[16] : (SHA Offset: 0x40) Input Data 0 Register -------- */
#define SHA_IDATAR_IDATA_Pos 0
#define SHA_IDATAR_IDATA_Msk (0xffffffffu << SHA_IDATAR_IDATA_Pos) /**< \brief (SHA_IDATAR[16]) Input Data */
#define SHA_IDATAR_IDATA(value) ((SHA_IDATAR_IDATA_Msk & ((value) << SHA_IDATAR_IDATA_Pos)))
/* -------- SHA_IODATAR[16] : (SHA Offset: 0x80) Input/Output Data 0 Register -------- */
#define SHA_IODATAR_IODATA_Pos 0
#define SHA_IODATAR_IODATA_Msk (0xffffffffu << SHA_IODATAR_IODATA_Pos) /**< \brief (SHA_IODATAR[16]) Input/Output Data */
#define SHA_IODATAR_IODATA(value) ((SHA_IODATAR_IODATA_Msk & ((value) << SHA_IODATAR_IODATA_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Shutdown Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SHDWC Shutdown Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Shdwc hardware registers */
typedef struct {
  __O  uint32_t SHDW_CR; /**< \brief (Shdwc Offset: 0x00) Shutdown Control Register */
  __IO uint32_t SHDW_MR; /**< \brief (Shdwc Offset: 0x04) Shutdown Mode Register */
  __I  uint32_t SHDW_SR; /**< \brief (Shdwc Offset: 0x08) Shutdown Status Register */
} Shdwc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SHDW_CR : (SHDWC Offset: 0x00) Shutdown Control Register -------- */
#define SHDW_CR_SHDW (0x1u << 0) /**< \brief (SHDW_CR) Shutdown Command */
#define SHDW_CR_KEY_Pos 24
#define SHDW_CR_KEY_Msk (0xffu << SHDW_CR_KEY_Pos) /**< \brief (SHDW_CR) Password */
#define SHDW_CR_KEY(value) ((SHDW_CR_KEY_Msk & ((value) << SHDW_CR_KEY_Pos)))
/* -------- SHDW_MR : (SHDWC Offset: 0x04) Shutdown Mode Register -------- */
#define SHDW_MR_WKMODE0_Pos 0
#define SHDW_MR_WKMODE0_Msk (0x3u << SHDW_MR_WKMODE0_Pos) /**< \brief (SHDW_MR) Wake-up Mode 0 */
#define   SHDW_MR_WKMODE0_NO_DETECTION (0x0u << 0) /**< \brief (SHDW_MR) No detection is performed on the wake-up input */
#define   SHDW_MR_WKMODE0_RISING_EDGE (0x1u << 0) /**< \brief (SHDW_MR) Low to high transition triggers the detection process */
#define   SHDW_MR_WKMODE0_FALLING_EDGE (0x2u << 0) /**< \brief (SHDW_MR) High to low level transition triggers the detection process */
#define   SHDW_MR_WKMODE0_ANY_EDGE (0x3u << 0) /**< \brief (SHDW_MR) Any edge on the wake-up input triggers the detection process */
#define SHDW_MR_CPTWK0_Pos 4
#define SHDW_MR_CPTWK0_Msk (0xfu << SHDW_MR_CPTWK0_Pos) /**< \brief (SHDW_MR) Debounce Counter on Wake-up 0 */
#define SHDW_MR_CPTWK0(value) ((SHDW_MR_CPTWK0_Msk & ((value) << SHDW_MR_CPTWK0_Pos)))
#define SHDW_MR_WKMODE1_Pos 8
#define SHDW_MR_WKMODE1_Msk (0x3u << SHDW_MR_WKMODE1_Pos) /**< \brief (SHDW_MR) Wake-up Mode 1 */
#define   SHDW_MR_WKMODE1_NO_DETECTION (0x0u << 8) /**< \brief (SHDW_MR) No detection is performed on the wake-up input */
#define   SHDW_MR_WKMODE1_RISING_EDGE (0x1u << 8) /**< \brief (SHDW_MR) Low to high transition triggers the detection process */
#define   SHDW_MR_WKMODE1_FALLING_EDGE (0x2u << 8) /**< \brief (SHDW_MR) High to low level transition triggers the detection process */
#define   SHDW_MR_WKMODE1_ANY_EDGE (0x3u << 8) /**< \brief (SHDW_MR) Any edge on the wake-up input triggers the detection process */
#define SHDW_MR_CPTWK1_Pos 12
#define SHDW_MR_CPTWK1_Msk (0xfu << SHDW_MR_CPTWK1_Pos) /**< \brief (SHDW_MR) Debounce Counter on Wake-up 1 */
#define SHDW_MR_CPTWK1(value) ((SHDW_MR_CPTWK1_Msk & ((value) << SHDW_MR_CPTWK1_Pos)))
#define SHDW_MR_RTCWKEN (0x1u << 17) /**< \brief (SHDW_MR) Real-time Clock Wake-up Enable */
/* -------- SHDW_SR : (SHDWC Offset: 0x08) Shutdown Status Register -------- */
#define SHDW_SR_WAKEUP0 (0x1u << 0) /**< \brief (SHDW_SR) Wake-up 0 Status */
#define SHDW_SR_WAKEUP1 (0x1u << 1) /**< \brief (SHDW_SR) Wake-up 1 Status */
#define SHDW_SR_RTCWK (0x1u << 17) /**< \brief (SHDW_SR) Real-time Clock Wake-up */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Software Modem Device */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SMD Software Modem Device */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Smd hardware registers */
typedef struct {
  __IO uint32_t SMD_CONTROL_POPR; /**< \brief (Smd Offset: 0x00) SMD Control or Pop Removal register */
  __IO uint32_t SMD_STATUS_REV;   /**< \brief (Smd Offset: 0x04) SMD Status or Revision register */
  __IO uint32_t SMD_WRAP;         /**< \brief (Smd Offset: 0x08) SMD Wrapper/Power register */
  __IO uint32_t SMD_DRIVE;        /**< \brief (Smd Offset: 0x0C) SMD Drive register */
  __IO uint32_t SMD_ADJ;          /**< \brief (Smd Offset: 0x10) SMD Adjustment register */
  __IO uint32_t SMD_VOLC;         /**< \brief (Smd Offset: 0x14) SMD Volume Control register */
  __IO uint32_t SMD_AUX;          /**< \brief (Smd Offset: 0x18) SMD Auxiliary Control register */
  __IO uint32_t SMD_PULSE;        /**< \brief (Smd Offset: 0x1C) SMD Pulse Dialing Control register */
  __IO uint32_t SMD_DATA1_LOW;    /**< \brief (Smd Offset: 0x20) SMD Data1 Lower Byte register */
  __IO uint32_t SMD_DATA1_UP;     /**< \brief (Smd Offset: 0x24) SMD Data1 Upper Byte register */
  __IO uint32_t SMD_CTRL1_LOW;    /**< \brief (Smd Offset: 0x28) SMD Control1 Lower Byte register */
  __IO uint32_t SMD_CTRL1_UP;     /**< \brief (Smd Offset: 0x2C) SMD Control1 Upper Byte register */
  __I  uint32_t SMD_DATA2_LOW;    /**< \brief (Smd Offset: 0x30) SMD Data2 Lower Byte register */
  __I  uint32_t SMD_DATA2_UP;     /**< \brief (Smd Offset: 0x34) SMD Data2 Upper Byte register */
  __I  uint32_t SMD_CTRL2;        /**< \brief (Smd Offset: 0x38) SMD Control2 register */
  __IO uint32_t SMD_PARAM_TRIM;   /**< \brief (Smd Offset: 0x3C) SMD Parameter register (for pulse dialing / ring detection) */
  __IO uint32_t SMD_FIFOCTRL;     /**< \brief (Smd Offset: 0x40) SMD FIFO Control register */
  __IO uint32_t SMD_IRQ_LVL;      /**< \brief (Smd Offset: 0x44) SMD FIFO IRQ Level register */
  __IO uint32_t SMD_LPWR_CLK_ENB; /**< \brief (Smd Offset: 0x48) SMD Low Power Clock Enable register */
  __I  uint32_t Reserved1[1];
  __O  uint32_t SMD_TXDATA_FIFO;  /**< \brief (Smd Offset: 0x50) SMD Transmit Data FIFO */
  __I  uint32_t SMD_RXDATA_FIFO;  /**< \brief (Smd Offset: 0x54) SMD Receive Data FIFO */
} Smd;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SMD_CONTROL_POPR : (SMD Offset: 0x00) SMD Control or Pop Removal register -------- */
#define SMD_CONTROL_POPR_SD_DMAEOE (0x1u << 0) /**< \brief (SMD_CONTROL_POPR) SMD Serializer/Deserializer and DMA Engine Operation Enable. */
#define SMD_CONTROL_POPR_PCGE (0x1u << 1) /**< \brief (SMD_CONTROL_POPR) SMD Power Clock Generation Enable. */
#define SMD_CONTROL_POPR_PE_CTRL2_IE (0x1u << 2) /**< \brief (SMD_CONTROL_POPR) PE_CTRL2 Interrupt Enable. */
#define SMD_CONTROL_POPR_CDSTDIB_IE (0x1u << 3) /**< \brief (SMD_CONTROL_POPR) CDSTDIB Interrupt Enable. */
#define SMD_CONTROL_POPR_RXFIFO_OV_IE (0x1u << 4) /**< \brief (SMD_CONTROL_POPR) RXFIFO_OVER Interrupt Enable. */
#define SMD_CONTROL_POPR_TXFIFO_UN_IE (0x1u << 5) /**< \brief (SMD_CONTROL_POPR) TXFIFO_UNDER Interrupt Enable. */
#define SMD_CONTROL_POPR_RXFIFO_NE_IE (0x1u << 6) /**< \brief (SMD_CONTROL_POPR) RXFIFO_NE Interrupt Enable. */
#define SMD_CONTROL_POPR_TXFIFO_NF_IE (0x1u << 7) /**< \brief (SMD_CONTROL_POPR) TXFIFO_NF Interrupt Enable. */
#define SMD_CONTROL_POPR_POP_REM_Pos 0
#define SMD_CONTROL_POPR_POP_REM_Msk (0xffu << SMD_CONTROL_POPR_POP_REM_Pos) /**< \brief (SMD_CONTROL_POPR) SMD Pop Removal Register */
#define SMD_CONTROL_POPR_POP_REM(value) ((SMD_CONTROL_POPR_POP_REM_Msk & ((value) << SMD_CONTROL_POPR_POP_REM_Pos)))
/* -------- SMD_STATUS_REV : (SMD Offset: 0x04) SMD Status or Revision register -------- */
#define SMD_STATUS_REV_MADCVS (0x1u << 0) /**< \brief (SMD_STATUS_REV) SMD Monitoring ADC Value Stored in SMD_CTRL2. */
#define SMD_STATUS_REV_DTCADIBI (0x1u << 1) /**< \brief (SMD_STATUS_REV) SMD Data Transfer Completed Across DIB Interface. */
#define SMD_STATUS_REV_PE_CTRL2 (0x1u << 2) /**< \brief (SMD_STATUS_REV) SMD Parity Error in CTRL2. */
#define SMD_STATUS_REV_CDSTDIB (0x1u << 3) /**< \brief (SMD_STATUS_REV) SMD Control Data Sent Through DIB. */
#define SMD_STATUS_REV_RXFIFO_OV (0x1u << 4) /**< \brief (SMD_STATUS_REV) SMD RX FIFO Overflow. */
#define SMD_STATUS_REV_TXFIFO_UN (0x1u << 5) /**< \brief (SMD_STATUS_REV) SMD TX FIFO Underflow. */
#define SMD_STATUS_REV_RXFIFO_NE (0x1u << 6) /**< \brief (SMD_STATUS_REV) SMD RX FIFO Not Empty. */
#define SMD_STATUS_REV_TXFIFO_NF (0x1u << 7) /**< \brief (SMD_STATUS_REV) SMD TX FIFO Not Full. */
#define SMD_STATUS_REV_REVISION_Pos 0
#define SMD_STATUS_REV_REVISION_Msk (0xffu << SMD_STATUS_REV_REVISION_Pos) /**< \brief (SMD_STATUS_REV) SMD Revision Register */
#define SMD_STATUS_REV_REVISION(value) ((SMD_STATUS_REV_REVISION_Msk & ((value) << SMD_STATUS_REV_REVISION_Pos)))
/* -------- SMD_WRAP : (SMD Offset: 0x08) SMD Wrapper/Power register -------- */
#define SMD_WRAP_NFB_Pos 0
#define SMD_WRAP_NFB_Msk (0x3u << SMD_WRAP_NFB_Pos) /**< \brief (SMD_WRAP) SMD Number of Frame Bits. */
#define SMD_WRAP_NFB(value) ((SMD_WRAP_NFB_Msk & ((value) << SMD_WRAP_NFB_Pos)))
#define SMD_WRAP_PS_Pos 2
#define SMD_WRAP_PS_Msk (0x3fu << SMD_WRAP_PS_Pos) /**< \brief (SMD_WRAP) SMD Power Settings. */
#define SMD_WRAP_PS(value) ((SMD_WRAP_PS_Msk & ((value) << SMD_WRAP_PS_Pos)))
/* -------- SMD_DRIVE : (SMD Offset: 0x0C) SMD Drive register -------- */
#define SMD_DRIVE_MIE (0x1u << 0) /**< \brief (SMD_DRIVE) MADCVS Interrupt Enable. */
#define SMD_DRIVE_DC_PWRCLKPN (0x1u << 1) /**< \brief (SMD_DRIVE) Direct Control of PWRCLKP, PWRCLKN Pins Enable. */
#define SMD_DRIVE_PWRCLKP_PV2 (0x1u << 2) /**< \brief (SMD_DRIVE) PWRCLKP Pin Value. */
#define SMD_DRIVE_PWRCLKP_PV (0x1u << 3) /**< \brief (SMD_DRIVE) PWRCLKP Pin Value. */
#define SMD_DRIVE_PWRCLKN_PCS2_Pos 4
#define SMD_DRIVE_PWRCLKN_PCS2_Msk (0x3u << SMD_DRIVE_PWRCLKN_PCS2_Pos) /**< \brief (SMD_DRIVE) PWRCLKN Pin Control Select. */
#define SMD_DRIVE_PWRCLKN_PCS2(value) ((SMD_DRIVE_PWRCLKN_PCS2_Msk & ((value) << SMD_DRIVE_PWRCLKN_PCS2_Pos)))
#define SMD_DRIVE_PWRCLKP_PCS_Pos 6
#define SMD_DRIVE_PWRCLKP_PCS_Msk (0x3u << SMD_DRIVE_PWRCLKP_PCS_Pos) /**< \brief (SMD_DRIVE) PWRCLKP Pin Control Select. */
#define SMD_DRIVE_PWRCLKP_PCS(value) ((SMD_DRIVE_PWRCLKP_PCS_Msk & ((value) << SMD_DRIVE_PWRCLKP_PCS_Pos)))
/* -------- SMD_ADJ : (SMD Offset: 0x10) SMD Adjustment register -------- */
#define SMD_ADJ_RSAS_Pos 0
#define SMD_ADJ_RSAS_Msk (0x3u << SMD_ADJ_RSAS_Pos) /**< \brief (SMD_ADJ) Register Synchronization Adjust Select. */
#define SMD_ADJ_RSAS(value) ((SMD_ADJ_RSAS_Msk & ((value) << SMD_ADJ_RSAS_Pos)))
#define SMD_ADJ_DCOE (0x1u << 2) /**< \brief (SMD_ADJ) Data Channel Operation Enable. */
#define SMD_ADJ_PCFDS (0x1u << 3) /**< \brief (SMD_ADJ) Power Clock Frequency Derivation Select. */
#define SMD_ADJ_PWM_ADJ_PWRCLK_Pos 4
#define SMD_ADJ_PWM_ADJ_PWRCLK_Msk (0x3u << SMD_ADJ_PWM_ADJ_PWRCLK_Pos) /**< \brief (SMD_ADJ) PWM Adjust for PWRCLK. */
#define SMD_ADJ_PWM_ADJ_PWRCLK(value) ((SMD_ADJ_PWM_ADJ_PWRCLK_Msk & ((value) << SMD_ADJ_PWM_ADJ_PWRCLK_Pos)))
#define SMD_ADJ_ALOS (0x1u << 6) /**< \brief (SMD_ADJ) Address Location Offset Select. */
#define SMD_ADJ_PWRCLKPN_FS (0x1u << 7) /**< \brief (SMD_ADJ) PWRCLKP and PWRCLKN Function Swap. */
/* -------- SMD_VOLC : (SMD Offset: 0x14) SMD Volume Control register -------- */
#define SMD_VOLC_DSVC_Pos 0
#define SMD_VOLC_DSVC_Msk (0x7u << SMD_VOLC_DSVC_Pos) /**< \brief (SMD_VOLC) Digital Speaker Volume Control. */
#define SMD_VOLC_DSVC(value) ((SMD_VOLC_DSVC_Msk & ((value) << SMD_VOLC_DSVC_Pos)))
#define SMD_VOLC_DSSC_Pos 3
#define SMD_VOLC_DSSC_Msk (0x3u << SMD_VOLC_DSSC_Pos) /**< \brief (SMD_VOLC) Digital Speaker Source Control. */
#define SMD_VOLC_DSSC(value) ((SMD_VOLC_DSSC_Msk & ((value) << SMD_VOLC_DSSC_Pos)))
#define SMD_VOLC_DSPDC (0x1u << 5) /**< \brief (SMD_VOLC) Digital Speaker Pin Drive Control. */
#define SMD_VOLC_DSOC_Pos 6
#define SMD_VOLC_DSOC_Msk (0x3u << SMD_VOLC_DSOC_Pos) /**< \brief (SMD_VOLC) Digital Speaker Output Control. */
#define SMD_VOLC_DSOC(value) ((SMD_VOLC_DSOC_Msk & ((value) << SMD_VOLC_DSOC_Pos)))
/* -------- SMD_AUX : (SMD Offset: 0x18) SMD Auxiliary Control register -------- */
#define SMD_AUX_DMA_AE (0x1u << 0) /**< \brief (SMD_AUX) DMA Access Enable. */
#define SMD_AUX_RDSME (0x1u << 1) /**< \brief (SMD_AUX) Ring Detection State Machine Enable. */
#define SMD_AUX_RDWUE (0x1u << 2) /**< \brief (SMD_AUX) Ring Detect Wake Up Enable. */
#define SMD_AUX_RDIE (0x1u << 3) /**< \brief (SMD_AUX) RD Interrupt Enable. */
#define SMD_AUX_EPWUE (0x1u << 4) /**< \brief (SMD_AUX) Extension Pickup Wake Up Enable. */
#define SMD_AUX_EHPDIE (0x1u << 5) /**< \brief (SMD_AUX) EHPD Interrupt Enable. */
#define SMD_AUX_RD (0x1u << 6) /**< \brief (SMD_AUX) Ring Detected. */
#define SMD_AUX_EHPD (0x1u << 7) /**< \brief (SMD_AUX) Extension Handset Pickup Detected. */
/* -------- SMD_PULSE : (SMD Offset: 0x1C) SMD Pulse Dialing Control register -------- */
#define SMD_PULSE_NDP_Pos 0
#define SMD_PULSE_NDP_Msk (0xfu << SMD_PULSE_NDP_Pos) /**< \brief (SMD_PULSE) Number of Dialing Pulses. */
#define SMD_PULSE_NDP(value) ((SMD_PULSE_NDP_Msk & ((value) << SMD_PULSE_NDP_Pos)))
#define SMD_PULSE_PDF_IE (0x1u << 4) /**< \brief (SMD_PULSE) PDF Interrupt Enable. */
#define SMD_PULSE_PDCS_IE (0x1u << 5) /**< \brief (SMD_PULSE) PDCS Interrupt Enable. */
#define SMD_PULSE_PDF (0x1u << 6) /**< \brief (SMD_PULSE) Pulse Dialing Failed. */
#define SMD_PULSE_PDCS (0x1u << 7) /**< \brief (SMD_PULSE) Pulse Dialing Completed Successfully. */
/* -------- SMD_DATA1_LOW : (SMD Offset: 0x20) SMD Data1 Lower Byte register -------- */
#define SMD_DATA1_LOW_TXFIFO_LB_Pos 0
#define SMD_DATA1_LOW_TXFIFO_LB_Msk (0xffu << SMD_DATA1_LOW_TXFIFO_LB_Pos) /**< \brief (SMD_DATA1_LOW) TX FIFO Lower Byte */
#define SMD_DATA1_LOW_TXFIFO_LB(value) ((SMD_DATA1_LOW_TXFIFO_LB_Msk & ((value) << SMD_DATA1_LOW_TXFIFO_LB_Pos)))
/* -------- SMD_DATA1_UP : (SMD Offset: 0x24) SMD Data1 Upper Byte register -------- */
#define SMD_DATA1_UP_TXFIFO_UB_Pos 0
#define SMD_DATA1_UP_TXFIFO_UB_Msk (0xffu << SMD_DATA1_UP_TXFIFO_UB_Pos) /**< \brief (SMD_DATA1_UP) TX FIFO Upper Byte. */
#define SMD_DATA1_UP_TXFIFO_UB(value) ((SMD_DATA1_UP_TXFIFO_UB_Msk & ((value) << SMD_DATA1_UP_TXFIFO_UB_Pos)))
/* -------- SMD_CTRL1_LOW : (SMD Offset: 0x28) SMD Control1 Lower Byte register -------- */
#define SMD_CTRL1_LOW_CCC_LB_Pos 0
#define SMD_CTRL1_LOW_CCC_LB_Msk (0xffu << SMD_CTRL1_LOW_CCC_LB_Pos) /**< \brief (SMD_CTRL1_LOW) Control Channel Command Lower Byte. */
#define SMD_CTRL1_LOW_CCC_LB(value) ((SMD_CTRL1_LOW_CCC_LB_Msk & ((value) << SMD_CTRL1_LOW_CCC_LB_Pos)))
/* -------- SMD_CTRL1_UP : (SMD Offset: 0x2C) SMD Control1 Upper Byte register -------- */
#define SMD_CTRL1_UP_CCC_UB_Pos 0
#define SMD_CTRL1_UP_CCC_UB_Msk (0x7fu << SMD_CTRL1_UP_CCC_UB_Pos) /**< \brief (SMD_CTRL1_UP) Control Channel Command Upper Byte. */
#define SMD_CTRL1_UP_CCC_UB(value) ((SMD_CTRL1_UP_CCC_UB_Msk & ((value) << SMD_CTRL1_UP_CCC_UB_Pos)))
#define SMD_CTRL1_UP_CCC_RW (0x1u << 7) /**< \brief (SMD_CTRL1_UP) Control Channel Command Read-Write. */
/* -------- SMD_DATA2_LOW : (SMD Offset: 0x30) SMD Data2 Lower Byte register -------- */
#define SMD_DATA2_LOW_DATA2_LB_Pos 0
#define SMD_DATA2_LOW_DATA2_LB_Msk (0xffu << SMD_DATA2_LOW_DATA2_LB_Pos) /**< \brief (SMD_DATA2_LOW) Data 2 Lower Byte. */
/* -------- SMD_DATA2_UP : (SMD Offset: 0x34) SMD Data2 Upper Byte register -------- */
#define SMD_DATA2_UP_DATA2_UB_Pos 0
#define SMD_DATA2_UP_DATA2_UB_Msk (0xffu << SMD_DATA2_UP_DATA2_UB_Pos) /**< \brief (SMD_DATA2_UP) Data 2 Upper Byte. */
/* -------- SMD_CTRL2 : (SMD Offset: 0x38) SMD Control2 register -------- */
#define SMD_CTRL2_CTRL2_CR_Pos 0
#define SMD_CTRL2_CTRL2_CR_Msk (0xffu << SMD_CTRL2_CTRL2_CR_Pos) /**< \brief (SMD_CTRL2) Control 2 Channel Response. */
/* -------- SMD_PARAM_TRIM : (SMD Offset: 0x3C) SMD Parameter register (for pulse dialing / ring detection) -------- */
#define SMD_PARAM_TRIM_DC_PD (0x1u << 0) /**< \brief (SMD_PARAM_TRIM) Duty Cycle during Pulse Dialing. */
#define SMD_PARAM_TRIM_PPSR_PD (0x1u << 1) /**< \brief (SMD_PARAM_TRIM) Pulse per Second Rate during Pulse Dialing. */
#define SMD_PARAM_TRIM_DBD_PDSM_Pos 2
#define SMD_PARAM_TRIM_DBD_PDSM_Msk (0x3fu << SMD_PARAM_TRIM_DBD_PDSM_Pos) /**< \brief (SMD_PARAM_TRIM) Delay Between Digits of the Pulse Dialing State Machine. */
#define SMD_PARAM_TRIM_DBD_PDSM(value) ((SMD_PARAM_TRIM_DBD_PDSM_Msk & ((value) << SMD_PARAM_TRIM_DBD_PDSM_Pos)))
#define SMD_PARAM_TRIM_RDMETC_Pos 0
#define SMD_PARAM_TRIM_RDMETC_Msk (0xfu << SMD_PARAM_TRIM_RDMETC_Pos) /**< \brief (SMD_PARAM_TRIM) Ring Detection Mode Extra Toggling Control. */
#define SMD_PARAM_TRIM_RDMETC(value) ((SMD_PARAM_TRIM_RDMETC_Msk & ((value) << SMD_PARAM_TRIM_RDMETC_Pos)))
#define SMD_PARAM_TRIM_TL_RD_Pos 4
#define SMD_PARAM_TRIM_TL_RD_Msk (0x3u << SMD_PARAM_TRIM_TL_RD_Pos) /**< \brief (SMD_PARAM_TRIM) Threshold Level for Ring Detection. */
#define SMD_PARAM_TRIM_TL_RD(value) ((SMD_PARAM_TRIM_TL_RD_Msk & ((value) << SMD_PARAM_TRIM_TL_RD_Pos)))
#define SMD_PARAM_TRIM_BREAK_DBD_Pos 0
#define SMD_PARAM_TRIM_BREAK_DBD_Msk (0xfu << SMD_PARAM_TRIM_BREAK_DBD_Pos) /**< \brief (SMD_PARAM_TRIM) "Break" Duration Between Digits. */
#define SMD_PARAM_TRIM_BREAK_DBD(value) ((SMD_PARAM_TRIM_BREAK_DBD_Msk & ((value) << SMD_PARAM_TRIM_BREAK_DBD_Pos)))
#define SMD_PARAM_TRIM_MAKE_DBD_Pos 4
#define SMD_PARAM_TRIM_MAKE_DBD_Msk (0xfu << SMD_PARAM_TRIM_MAKE_DBD_Pos) /**< \brief (SMD_PARAM_TRIM) "Make" Duration Between Digits. */
#define SMD_PARAM_TRIM_MAKE_DBD(value) ((SMD_PARAM_TRIM_MAKE_DBD_Msk & ((value) << SMD_PARAM_TRIM_MAKE_DBD_Pos)))
#define SMD_PARAM_TRIM_MIN_DIB_Pos 0
#define SMD_PARAM_TRIM_MIN_DIB_Msk (0xffu << SMD_PARAM_TRIM_MIN_DIB_Pos) /**< \brief (SMD_PARAM_TRIM) Minimum amount of DIB frames inside the burst. */
#define SMD_PARAM_TRIM_MIN_DIB(value) ((SMD_PARAM_TRIM_MIN_DIB_Msk & ((value) << SMD_PARAM_TRIM_MIN_DIB_Pos)))
/* -------- SMD_FIFOCTRL : (SMD Offset: 0x40) SMD FIFO Control register -------- */
#define SMD_FIFOCTRL_ENB_DMACONT_RX (0x1u << 2) /**< \brief (SMD_FIFOCTRL) Enable DMA Continue for the SMD RXFIFO. */
#define SMD_FIFOCTRL_ENB_DMACONT_TX (0x1u << 3) /**< \brief (SMD_FIFOCTRL) Enable DMA Continue for the SMD TXFIFO. */
#define SMD_FIFOCTRL_RX_FLUSH (0x1u << 6) /**< \brief (SMD_FIFOCTRL) Flush the SMD RXFIFO. */
#define SMD_FIFOCTRL_TX_FLUSH (0x1u << 7) /**< \brief (SMD_FIFOCTRL) Flush the SMD TXFIFO. */
#define SMD_FIFOCTRL_ENB_FIFOIRQ (0x1u << 8) /**< \brief (SMD_FIFOCTRL) FIFO Interrupt Enable. */
#define SMD_FIFOCTRL_FIFOIRQ_STATUS (0x1u << 9) /**< \brief (SMD_FIFOCTRL) FIFO Interrupt. */
/* -------- SMD_IRQ_LVL : (SMD Offset: 0x44) SMD FIFO IRQ Level register -------- */
#define SMD_IRQ_LVL_IRQ_LVL_Pos 0
#define SMD_IRQ_LVL_IRQ_LVL_Msk (0xffu << SMD_IRQ_LVL_IRQ_LVL_Pos) /**< \brief (SMD_IRQ_LVL) IRQ Count Level. */
#define SMD_IRQ_LVL_IRQ_LVL(value) ((SMD_IRQ_LVL_IRQ_LVL_Msk & ((value) << SMD_IRQ_LVL_IRQ_LVL_Pos)))
/* -------- SMD_LPWR_CLK_ENB : (SMD Offset: 0x48) SMD Low Power Clock Enable register -------- */
#define SMD_LPWR_CLK_ENB_LPWR_DIFF (0x1u << 2) /**< \brief (SMD_LPWR_CLK_ENB) SMD Low Power Differential Receive Disable. */
/* -------- SMD_TXDATA_FIFO : (SMD Offset: 0x50) SMD Transmit Data FIFO -------- */
#define SMD_TXDATA_FIFO_FIFO_DATA_Pos 0
#define SMD_TXDATA_FIFO_FIFO_DATA_Msk (0xffffffffu << SMD_TXDATA_FIFO_FIFO_DATA_Pos) /**< \brief (SMD_TXDATA_FIFO) SMD FIFO Data. */
#define SMD_TXDATA_FIFO_FIFO_DATA(value) ((SMD_TXDATA_FIFO_FIFO_DATA_Msk & ((value) << SMD_TXDATA_FIFO_FIFO_DATA_Pos)))
/* -------- SMD_RXDATA_FIFO : (SMD Offset: 0x54) SMD Receive Data FIFO -------- */
#define SMD_RXDATA_FIFO_FIFO_DATA_Pos 0
#define SMD_RXDATA_FIFO_FIFO_DATA_Msk (0xffffffffu << SMD_RXDATA_FIFO_FIFO_DATA_Pos) /**< \brief (SMD_RXDATA_FIFO) SMD FIFO Data. */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Serial Peripheral Interface */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SPI Serial Peripheral Interface */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Spi hardware registers */
typedef struct {
  __O  uint32_t SPI_CR;        /**< \brief (Spi Offset: 0x00) Control Register */
  __IO uint32_t SPI_MR;        /**< \brief (Spi Offset: 0x04) Mode Register */
  __I  uint32_t SPI_RDR;       /**< \brief (Spi Offset: 0x08) Receive Data Register */
  __O  uint32_t SPI_TDR;       /**< \brief (Spi Offset: 0x0C) Transmit Data Register */
  __I  uint32_t SPI_SR;        /**< \brief (Spi Offset: 0x10) Status Register */
  __O  uint32_t SPI_IER;       /**< \brief (Spi Offset: 0x14) Interrupt Enable Register */
  __O  uint32_t SPI_IDR;       /**< \brief (Spi Offset: 0x18) Interrupt Disable Register */
  __I  uint32_t SPI_IMR;       /**< \brief (Spi Offset: 0x1C) Interrupt Mask Register */
  __I  uint32_t Reserved1[4];
  __IO uint32_t SPI_CSR[4];    /**< \brief (Spi Offset: 0x30) Chip Select Register */
  __I  uint32_t Reserved2[41];
  __IO uint32_t SPI_WPMR;      /**< \brief (Spi Offset: 0xE4) Write Protection Control Register */
  __I  uint32_t SPI_WPSR;      /**< \brief (Spi Offset: 0xE8) Write Protection Status Register */
} Spi;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SPI_CR : (SPI Offset: 0x00) Control Register -------- */
#define SPI_CR_SPIEN (0x1u << 0) /**< \brief (SPI_CR) SPI Enable */
#define SPI_CR_SPIDIS (0x1u << 1) /**< \brief (SPI_CR) SPI Disable */
#define SPI_CR_SWRST (0x1u << 7) /**< \brief (SPI_CR) SPI Software Reset */
#define SPI_CR_LASTXFER (0x1u << 24) /**< \brief (SPI_CR) Last Transfer */
/* -------- SPI_MR : (SPI Offset: 0x04) Mode Register -------- */
#define SPI_MR_MSTR (0x1u << 0) /**< \brief (SPI_MR) Master/Slave Mode */
#define SPI_MR_PS (0x1u << 1) /**< \brief (SPI_MR) Peripheral Select */
#define SPI_MR_PCSDEC (0x1u << 2) /**< \brief (SPI_MR) Chip Select Decode */
#define SPI_MR_MODFDIS (0x1u << 4) /**< \brief (SPI_MR) Mode Fault Detection */
#define SPI_MR_WDRBT (0x1u << 5) /**< \brief (SPI_MR) Wait Data Read Before Transfer */
#define SPI_MR_LLB (0x1u << 7) /**< \brief (SPI_MR) Local Loopback Enable */
#define SPI_MR_PCS_Pos 16
#define SPI_MR_PCS_Msk (0xfu << SPI_MR_PCS_Pos) /**< \brief (SPI_MR) Peripheral Chip Select */
#define SPI_MR_PCS(value) ((SPI_MR_PCS_Msk & ((value) << SPI_MR_PCS_Pos)))
#define SPI_MR_DLYBCS_Pos 24
#define SPI_MR_DLYBCS_Msk (0xffu << SPI_MR_DLYBCS_Pos) /**< \brief (SPI_MR) Delay Between Chip Selects */
#define SPI_MR_DLYBCS(value) ((SPI_MR_DLYBCS_Msk & ((value) << SPI_MR_DLYBCS_Pos)))
/* -------- SPI_RDR : (SPI Offset: 0x08) Receive Data Register -------- */
#define SPI_RDR_RD_Pos 0
#define SPI_RDR_RD_Msk (0xffffu << SPI_RDR_RD_Pos) /**< \brief (SPI_RDR) Receive Data */
#define SPI_RDR_PCS_Pos 16
#define SPI_RDR_PCS_Msk (0xfu << SPI_RDR_PCS_Pos) /**< \brief (SPI_RDR) Peripheral Chip Select */
/* -------- SPI_TDR : (SPI Offset: 0x0C) Transmit Data Register -------- */
#define SPI_TDR_TD_Pos 0
#define SPI_TDR_TD_Msk (0xffffu << SPI_TDR_TD_Pos) /**< \brief (SPI_TDR) Transmit Data */
#define SPI_TDR_TD(value) ((SPI_TDR_TD_Msk & ((value) << SPI_TDR_TD_Pos)))
#define SPI_TDR_PCS_Pos 16
#define SPI_TDR_PCS_Msk (0xfu << SPI_TDR_PCS_Pos) /**< \brief (SPI_TDR) Peripheral Chip Select */
#define SPI_TDR_PCS(value) ((SPI_TDR_PCS_Msk & ((value) << SPI_TDR_PCS_Pos)))
#define SPI_TDR_LASTXFER (0x1u << 24) /**< \brief (SPI_TDR) Last Transfer */
/* -------- SPI_SR : (SPI Offset: 0x10) Status Register -------- */
#define SPI_SR_RDRF (0x1u << 0) /**< \brief (SPI_SR) Receive Data Register Full */
#define SPI_SR_TDRE (0x1u << 1) /**< \brief (SPI_SR) Transmit Data Register Empty */
#define SPI_SR_MODF (0x1u << 2) /**< \brief (SPI_SR) Mode Fault Error */
#define SPI_SR_OVRES (0x1u << 3) /**< \brief (SPI_SR) Overrun Error Status */
#define SPI_SR_NSSR (0x1u << 8) /**< \brief (SPI_SR) NSS Rising */
#define SPI_SR_TXEMPTY (0x1u << 9) /**< \brief (SPI_SR) Transmission Registers Empty */
#define SPI_SR_UNDES (0x1u << 10) /**< \brief (SPI_SR) Underrun Error Status (Slave Mode Only) */
#define SPI_SR_SPIENS (0x1u << 16) /**< \brief (SPI_SR) SPI Enable Status */
/* -------- SPI_IER : (SPI Offset: 0x14) Interrupt Enable Register -------- */
#define SPI_IER_RDRF (0x1u << 0) /**< \brief (SPI_IER) Receive Data Register Full Interrupt Enable */
#define SPI_IER_TDRE (0x1u << 1) /**< \brief (SPI_IER) SPI Transmit Data Register Empty Interrupt Enable */
#define SPI_IER_MODF (0x1u << 2) /**< \brief (SPI_IER) Mode Fault Error Interrupt Enable */
#define SPI_IER_OVRES (0x1u << 3) /**< \brief (SPI_IER) Overrun Error Interrupt Enable */
#define SPI_IER_NSSR (0x1u << 8) /**< \brief (SPI_IER) NSS Rising Interrupt Enable */
#define SPI_IER_TXEMPTY (0x1u << 9) /**< \brief (SPI_IER) Transmission Registers Empty Enable */
#define SPI_IER_UNDES (0x1u << 10) /**< \brief (SPI_IER) Underrun Error Interrupt Enable */
/* -------- SPI_IDR : (SPI Offset: 0x18) Interrupt Disable Register -------- */
#define SPI_IDR_RDRF (0x1u << 0) /**< \brief (SPI_IDR) Receive Data Register Full Interrupt Disable */
#define SPI_IDR_TDRE (0x1u << 1) /**< \brief (SPI_IDR) SPI Transmit Data Register Empty Interrupt Disable */
#define SPI_IDR_MODF (0x1u << 2) /**< \brief (SPI_IDR) Mode Fault Error Interrupt Disable */
#define SPI_IDR_OVRES (0x1u << 3) /**< \brief (SPI_IDR) Overrun Error Interrupt Disable */
#define SPI_IDR_NSSR (0x1u << 8) /**< \brief (SPI_IDR) NSS Rising Interrupt Disable */
#define SPI_IDR_TXEMPTY (0x1u << 9) /**< \brief (SPI_IDR) Transmission Registers Empty Disable */
#define SPI_IDR_UNDES (0x1u << 10) /**< \brief (SPI_IDR) Underrun Error Interrupt Disable */
/* -------- SPI_IMR : (SPI Offset: 0x1C) Interrupt Mask Register -------- */
#define SPI_IMR_RDRF (0x1u << 0) /**< \brief (SPI_IMR) Receive Data Register Full Interrupt Mask */
#define SPI_IMR_TDRE (0x1u << 1) /**< \brief (SPI_IMR) SPI Transmit Data Register Empty Interrupt Mask */
#define SPI_IMR_MODF (0x1u << 2) /**< \brief (SPI_IMR) Mode Fault Error Interrupt Mask */
#define SPI_IMR_OVRES (0x1u << 3) /**< \brief (SPI_IMR) Overrun Error Interrupt Mask */
#define SPI_IMR_NSSR (0x1u << 8) /**< \brief (SPI_IMR) NSS Rising Interrupt Mask */
#define SPI_IMR_TXEMPTY (0x1u << 9) /**< \brief (SPI_IMR) Transmission Registers Empty Mask */
#define SPI_IMR_UNDES (0x1u << 10) /**< \brief (SPI_IMR) Underrun Error Interrupt Mask */
/* -------- SPI_CSR[4] : (SPI Offset: 0x30) Chip Select Register -------- */
#define SPI_CSR_CPOL (0x1u << 0) /**< \brief (SPI_CSR[4]) Clock Polarity */
#define SPI_CSR_NCPHA (0x1u << 1) /**< \brief (SPI_CSR[4]) Clock Phase */
#define SPI_CSR_CSNAAT (0x1u << 2) /**< \brief (SPI_CSR[4]) Chip Select Not Active After Transfer (Ignored if CSAAT = 1) */
#define SPI_CSR_CSAAT (0x1u << 3) /**< \brief (SPI_CSR[4]) Chip Select Active After Transfer */
#define SPI_CSR_BITS_Pos 4
#define SPI_CSR_BITS_Msk (0xfu << SPI_CSR_BITS_Pos) /**< \brief (SPI_CSR[4]) Bits Per Transfer */
#define   SPI_CSR_BITS_8_BIT (0x0u << 4) /**< \brief (SPI_CSR[4]) 8 bits for transfer */
#define   SPI_CSR_BITS_9_BIT (0x1u << 4) /**< \brief (SPI_CSR[4]) 9 bits for transfer */
#define   SPI_CSR_BITS_10_BIT (0x2u << 4) /**< \brief (SPI_CSR[4]) 10 bits for transfer */
#define   SPI_CSR_BITS_11_BIT (0x3u << 4) /**< \brief (SPI_CSR[4]) 11 bits for transfer */
#define   SPI_CSR_BITS_12_BIT (0x4u << 4) /**< \brief (SPI_CSR[4]) 12 bits for transfer */
#define   SPI_CSR_BITS_13_BIT (0x5u << 4) /**< \brief (SPI_CSR[4]) 13 bits for transfer */
#define   SPI_CSR_BITS_14_BIT (0x6u << 4) /**< \brief (SPI_CSR[4]) 14 bits for transfer */
#define   SPI_CSR_BITS_15_BIT (0x7u << 4) /**< \brief (SPI_CSR[4]) 15 bits for transfer */
#define   SPI_CSR_BITS_16_BIT (0x8u << 4) /**< \brief (SPI_CSR[4]) 16 bits for transfer */
#define SPI_CSR_SCBR_Pos 8
#define SPI_CSR_SCBR_Msk (0xffu << SPI_CSR_SCBR_Pos) /**< \brief (SPI_CSR[4]) Serial Clock Baud Rate */
#define SPI_CSR_SCBR(value) ((SPI_CSR_SCBR_Msk & ((value) << SPI_CSR_SCBR_Pos)))
#define SPI_CSR_DLYBS_Pos 16
#define SPI_CSR_DLYBS_Msk (0xffu << SPI_CSR_DLYBS_Pos) /**< \brief (SPI_CSR[4]) Delay Before SPCK */
#define SPI_CSR_DLYBS(value) ((SPI_CSR_DLYBS_Msk & ((value) << SPI_CSR_DLYBS_Pos)))
#define SPI_CSR_DLYBCT_Pos 24
#define SPI_CSR_DLYBCT_Msk (0xffu << SPI_CSR_DLYBCT_Pos) /**< \brief (SPI_CSR[4]) Delay Between Consecutive Transfers */
#define SPI_CSR_DLYBCT(value) ((SPI_CSR_DLYBCT_Msk & ((value) << SPI_CSR_DLYBCT_Pos)))
/* -------- SPI_WPMR : (SPI Offset: 0xE4) Write Protection Control Register -------- */
#define SPI_WPMR_WPEN (0x1u << 0) /**< \brief (SPI_WPMR) Write Protect Enable */
#define SPI_WPMR_WPKEY_Pos 8
#define SPI_WPMR_WPKEY_Msk (0xffffffu << SPI_WPMR_WPKEY_Pos) /**< \brief (SPI_WPMR) Write Protect Key */
#define   SPI_WPMR_WPKEY_PASSWD (0x535049u << 8) /**< \brief (SPI_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0. */
/* -------- SPI_WPSR : (SPI Offset: 0xE8) Write Protection Status Register -------- */
#define SPI_WPSR_WPVS (0x1u << 0) /**< \brief (SPI_WPSR) Write Protection Violation Status */
#define SPI_WPSR_WPVSRC_Pos 8
#define SPI_WPSR_WPVSRC_Msk (0xffu << SPI_WPSR_WPVSRC_Pos) /**< \brief (SPI_WPSR) Write Protection Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Synchronous Serial Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_SSC Synchronous Serial Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Ssc hardware registers */
typedef struct {
  __O  uint32_t SSC_CR;        /**< \brief (Ssc Offset: 0x0) Control Register */
  __IO uint32_t SSC_CMR;       /**< \brief (Ssc Offset: 0x4) Clock Mode Register */
  __I  uint32_t Reserved1[2];
  __IO uint32_t SSC_RCMR;      /**< \brief (Ssc Offset: 0x10) Receive Clock Mode Register */
  __IO uint32_t SSC_RFMR;      /**< \brief (Ssc Offset: 0x14) Receive Frame Mode Register */
  __IO uint32_t SSC_TCMR;      /**< \brief (Ssc Offset: 0x18) Transmit Clock Mode Register */
  __IO uint32_t SSC_TFMR;      /**< \brief (Ssc Offset: 0x1C) Transmit Frame Mode Register */
  __I  uint32_t SSC_RHR;       /**< \brief (Ssc Offset: 0x20) Receive Holding Register */
  __O  uint32_t SSC_THR;       /**< \brief (Ssc Offset: 0x24) Transmit Holding Register */
  __I  uint32_t Reserved2[2];
  __I  uint32_t SSC_RSHR;      /**< \brief (Ssc Offset: 0x30) Receive Sync. Holding Register */
  __IO uint32_t SSC_TSHR;      /**< \brief (Ssc Offset: 0x34) Transmit Sync. Holding Register */
  __IO uint32_t SSC_RC0R;      /**< \brief (Ssc Offset: 0x38) Receive Compare 0 Register */
  __IO uint32_t SSC_RC1R;      /**< \brief (Ssc Offset: 0x3C) Receive Compare 1 Register */
  __I  uint32_t SSC_SR;        /**< \brief (Ssc Offset: 0x40) Status Register */
  __O  uint32_t SSC_IER;       /**< \brief (Ssc Offset: 0x44) Interrupt Enable Register */
  __O  uint32_t SSC_IDR;       /**< \brief (Ssc Offset: 0x48) Interrupt Disable Register */
  __I  uint32_t SSC_IMR;       /**< \brief (Ssc Offset: 0x4C) Interrupt Mask Register */
  __I  uint32_t Reserved3[37];
  __IO uint32_t SSC_WPMR;      /**< \brief (Ssc Offset: 0xE4) Write Protect Mode Register */
  __I  uint32_t SSC_WPSR;      /**< \brief (Ssc Offset: 0xE8) Write Protect Status Register */
} Ssc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- SSC_CR : (SSC Offset: 0x0) Control Register -------- */
#define SSC_CR_RXEN (0x1u << 0) /**< \brief (SSC_CR) Receive Enable */
#define SSC_CR_RXDIS (0x1u << 1) /**< \brief (SSC_CR) Receive Disable */
#define SSC_CR_TXEN (0x1u << 8) /**< \brief (SSC_CR) Transmit Enable */
#define SSC_CR_TXDIS (0x1u << 9) /**< \brief (SSC_CR) Transmit Disable */
#define SSC_CR_SWRST (0x1u << 15) /**< \brief (SSC_CR) Software Reset */
/* -------- SSC_CMR : (SSC Offset: 0x4) Clock Mode Register -------- */
#define SSC_CMR_DIV_Pos 0
#define SSC_CMR_DIV_Msk (0xfffu << SSC_CMR_DIV_Pos) /**< \brief (SSC_CMR) Clock Divider */
#define SSC_CMR_DIV(value) ((SSC_CMR_DIV_Msk & ((value) << SSC_CMR_DIV_Pos)))
/* -------- SSC_RCMR : (SSC Offset: 0x10) Receive Clock Mode Register -------- */
#define SSC_RCMR_CKS_Pos 0
#define SSC_RCMR_CKS_Msk (0x3u << SSC_RCMR_CKS_Pos) /**< \brief (SSC_RCMR) Receive Clock Selection */
#define   SSC_RCMR_CKS_MCK (0x0u << 0) /**< \brief (SSC_RCMR) Divided Clock */
#define   SSC_RCMR_CKS_TK (0x1u << 0) /**< \brief (SSC_RCMR) TK Clock signal */
#define   SSC_RCMR_CKS_RK (0x2u << 0) /**< \brief (SSC_RCMR) RK pin */
#define SSC_RCMR_CKO_Pos 2
#define SSC_RCMR_CKO_Msk (0x7u << SSC_RCMR_CKO_Pos) /**< \brief (SSC_RCMR) Receive Clock Output Mode Selection */
#define   SSC_RCMR_CKO_NONE (0x0u << 2) /**< \brief (SSC_RCMR) None, RK pin is an input */
#define   SSC_RCMR_CKO_CONTINUOUS (0x1u << 2) /**< \brief (SSC_RCMR) Continuous Receive Clock, RK pin is an output */
#define   SSC_RCMR_CKO_TRANSFER (0x2u << 2) /**< \brief (SSC_RCMR) Receive Clock only during data transfers, RK pin is an output */
#define SSC_RCMR_CKI (0x1u << 5) /**< \brief (SSC_RCMR) Receive Clock Inversion */
#define SSC_RCMR_CKG_Pos 6
#define SSC_RCMR_CKG_Msk (0x3u << SSC_RCMR_CKG_Pos) /**< \brief (SSC_RCMR) Receive Clock Gating Selection */
#define   SSC_RCMR_CKG_CONTINUOUS (0x0u << 6) /**< \brief (SSC_RCMR) None */
#define   SSC_RCMR_CKG_EN_RF_LOW (0x1u << 6) /**< \brief (SSC_RCMR) Receive Clock enabled only if RF Pin is Low */
#define   SSC_RCMR_CKG_EN_RF_HIGH (0x2u << 6) /**< \brief (SSC_RCMR) Receive Clock enabled only if RF Pin is High */
#define SSC_RCMR_START_Pos 8
#define SSC_RCMR_START_Msk (0xfu << SSC_RCMR_START_Pos) /**< \brief (SSC_RCMR) Receive Start Selection */
#define   SSC_RCMR_START_CONTINUOUS (0x0u << 8) /**< \brief (SSC_RCMR) Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data. */
#define   SSC_RCMR_START_TRANSMIT (0x1u << 8) /**< \brief (SSC_RCMR) Transmit start */
#define   SSC_RCMR_START_RF_LOW (0x2u << 8) /**< \brief (SSC_RCMR) Detection of a low level on RF signal */
#define   SSC_RCMR_START_RF_HIGH (0x3u << 8) /**< \brief (SSC_RCMR) Detection of a high level on RF signal */
#define   SSC_RCMR_START_RF_FALLING (0x4u << 8) /**< \brief (SSC_RCMR) Detection of a falling edge on RF signal */
#define   SSC_RCMR_START_RF_RISING (0x5u << 8) /**< \brief (SSC_RCMR) Detection of a rising edge on RF signal */
#define   SSC_RCMR_START_RF_LEVEL (0x6u << 8) /**< \brief (SSC_RCMR) Detection of any level change on RF signal */
#define   SSC_RCMR_START_RF_EDGE (0x7u << 8) /**< \brief (SSC_RCMR) Detection of any edge on RF signal */
#define   SSC_RCMR_START_CMP_0 (0x8u << 8) /**< \brief (SSC_RCMR) Compare 0 */
#define SSC_RCMR_STOP (0x1u << 12) /**< \brief (SSC_RCMR) Receive Stop Selection */
#define SSC_RCMR_STTDLY_Pos 16
#define SSC_RCMR_STTDLY_Msk (0xffu << SSC_RCMR_STTDLY_Pos) /**< \brief (SSC_RCMR) Receive Start Delay */
#define SSC_RCMR_STTDLY(value) ((SSC_RCMR_STTDLY_Msk & ((value) << SSC_RCMR_STTDLY_Pos)))
#define SSC_RCMR_PERIOD_Pos 24
#define SSC_RCMR_PERIOD_Msk (0xffu << SSC_RCMR_PERIOD_Pos) /**< \brief (SSC_RCMR) Receive Period Divider Selection */
#define SSC_RCMR_PERIOD(value) ((SSC_RCMR_PERIOD_Msk & ((value) << SSC_RCMR_PERIOD_Pos)))
/* -------- SSC_RFMR : (SSC Offset: 0x14) Receive Frame Mode Register -------- */
#define SSC_RFMR_DATLEN_Pos 0
#define SSC_RFMR_DATLEN_Msk (0x1fu << SSC_RFMR_DATLEN_Pos) /**< \brief (SSC_RFMR) Data Length */
#define SSC_RFMR_DATLEN(value) ((SSC_RFMR_DATLEN_Msk & ((value) << SSC_RFMR_DATLEN_Pos)))
#define SSC_RFMR_LOOP (0x1u << 5) /**< \brief (SSC_RFMR) Loop Mode */
#define SSC_RFMR_MSBF (0x1u << 7) /**< \brief (SSC_RFMR) Most Significant Bit First */
#define SSC_RFMR_DATNB_Pos 8
#define SSC_RFMR_DATNB_Msk (0xfu << SSC_RFMR_DATNB_Pos) /**< \brief (SSC_RFMR) Data Number per Frame */
#define SSC_RFMR_DATNB(value) ((SSC_RFMR_DATNB_Msk & ((value) << SSC_RFMR_DATNB_Pos)))
#define SSC_RFMR_FSLEN_Pos 16
#define SSC_RFMR_FSLEN_Msk (0xfu << SSC_RFMR_FSLEN_Pos) /**< \brief (SSC_RFMR) Receive Frame Sync Length */
#define SSC_RFMR_FSLEN(value) ((SSC_RFMR_FSLEN_Msk & ((value) << SSC_RFMR_FSLEN_Pos)))
#define SSC_RFMR_FSOS_Pos 20
#define SSC_RFMR_FSOS_Msk (0x7u << SSC_RFMR_FSOS_Pos) /**< \brief (SSC_RFMR) Receive Frame Sync Output Selection */
#define   SSC_RFMR_FSOS_NONE (0x0u << 20) /**< \brief (SSC_RFMR) None, RF pin is an input */
#define   SSC_RFMR_FSOS_NEGATIVE (0x1u << 20) /**< \brief (SSC_RFMR) Negative Pulse, RF pin is an output */
#define   SSC_RFMR_FSOS_POSITIVE (0x2u << 20) /**< \brief (SSC_RFMR) Positive Pulse, RF pin is an output */
#define   SSC_RFMR_FSOS_LOW (0x3u << 20) /**< \brief (SSC_RFMR) Driven Low during data transfer, RF pin is an output */
#define   SSC_RFMR_FSOS_HIGH (0x4u << 20) /**< \brief (SSC_RFMR) Driven High during data transfer, RF pin is an output */
#define   SSC_RFMR_FSOS_TOGGLING (0x5u << 20) /**< \brief (SSC_RFMR) Toggling at each start of data transfer, RF pin is an output */
#define SSC_RFMR_FSEDGE (0x1u << 24) /**< \brief (SSC_RFMR) Frame Sync Edge Detection */
#define   SSC_RFMR_FSEDGE_POSITIVE (0x0u << 24) /**< \brief (SSC_RFMR) Positive Edge Detection */
#define   SSC_RFMR_FSEDGE_NEGATIVE (0x1u << 24) /**< \brief (SSC_RFMR) Negative Edge Detection */
#define SSC_RFMR_FSLEN_EXT_Pos 28
#define SSC_RFMR_FSLEN_EXT_Msk (0xfu << SSC_RFMR_FSLEN_EXT_Pos) /**< \brief (SSC_RFMR) FSLEN Field Extension */
#define SSC_RFMR_FSLEN_EXT(value) ((SSC_RFMR_FSLEN_EXT_Msk & ((value) << SSC_RFMR_FSLEN_EXT_Pos)))
/* -------- SSC_TCMR : (SSC Offset: 0x18) Transmit Clock Mode Register -------- */
#define SSC_TCMR_CKS_Pos 0
#define SSC_TCMR_CKS_Msk (0x3u << SSC_TCMR_CKS_Pos) /**< \brief (SSC_TCMR) Transmit Clock Selection */
#define   SSC_TCMR_CKS_MCK (0x0u << 0) /**< \brief (SSC_TCMR) Divided Clock */
#define   SSC_TCMR_CKS_RK (0x1u << 0) /**< \brief (SSC_TCMR) RK Clock signal */
#define   SSC_TCMR_CKS_TK (0x2u << 0) /**< \brief (SSC_TCMR) TK pin */
#define SSC_TCMR_CKO_Pos 2
#define SSC_TCMR_CKO_Msk (0x7u << SSC_TCMR_CKO_Pos) /**< \brief (SSC_TCMR) Transmit Clock Output Mode Selection */
#define   SSC_TCMR_CKO_NONE (0x0u << 2) /**< \brief (SSC_TCMR) None, TK pin is an input */
#define   SSC_TCMR_CKO_CONTINUOUS (0x1u << 2) /**< \brief (SSC_TCMR) Continuous Transmit Clock, TK pin is an output */
#define   SSC_TCMR_CKO_TRANSFER (0x2u << 2) /**< \brief (SSC_TCMR) Transmit Clock only during data transfers, TK pin is an output */
#define SSC_TCMR_CKI (0x1u << 5) /**< \brief (SSC_TCMR) Transmit Clock Inversion */
#define SSC_TCMR_CKG_Pos 6
#define SSC_TCMR_CKG_Msk (0x3u << SSC_TCMR_CKG_Pos) /**< \brief (SSC_TCMR) Transmit Clock Gating Selection */
#define   SSC_TCMR_CKG_CONTINUOUS (0x0u << 6) /**< \brief (SSC_TCMR) None */
#define   SSC_TCMR_CKG_EN_TF_LOW (0x1u << 6) /**< \brief (SSC_TCMR) Transmit Clock enabled only if TF pin is Low */
#define   SSC_TCMR_CKG_EN_TF_HIGH (0x2u << 6) /**< \brief (SSC_TCMR) Transmit Clock enabled only if TF pin is High */
#define SSC_TCMR_START_Pos 8
#define SSC_TCMR_START_Msk (0xfu << SSC_TCMR_START_Pos) /**< \brief (SSC_TCMR) Transmit Start Selection */
#define   SSC_TCMR_START_CONTINUOUS (0x0u << 8) /**< \brief (SSC_TCMR) Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data. */
#define   SSC_TCMR_START_RECEIVE (0x1u << 8) /**< \brief (SSC_TCMR) Receive start */
#define   SSC_TCMR_START_TF_LOW (0x2u << 8) /**< \brief (SSC_TCMR) Detection of a low level on TF signal */
#define   SSC_TCMR_START_TF_HIGH (0x3u << 8) /**< \brief (SSC_TCMR) Detection of a high level on TF signal */
#define   SSC_TCMR_START_TF_FALLING (0x4u << 8) /**< \brief (SSC_TCMR) Detection of a falling edge on TF signal */
#define   SSC_TCMR_START_TF_RISING (0x5u << 8) /**< \brief (SSC_TCMR) Detection of a rising edge on TF signal */
#define   SSC_TCMR_START_TF_LEVEL (0x6u << 8) /**< \brief (SSC_TCMR) Detection of any level change on TF signal */
#define   SSC_TCMR_START_TF_EDGE (0x7u << 8) /**< \brief (SSC_TCMR) Detection of any edge on TF signal */
#define SSC_TCMR_STTDLY_Pos 16
#define SSC_TCMR_STTDLY_Msk (0xffu << SSC_TCMR_STTDLY_Pos) /**< \brief (SSC_TCMR) Transmit Start Delay */
#define SSC_TCMR_STTDLY(value) ((SSC_TCMR_STTDLY_Msk & ((value) << SSC_TCMR_STTDLY_Pos)))
#define SSC_TCMR_PERIOD_Pos 24
#define SSC_TCMR_PERIOD_Msk (0xffu << SSC_TCMR_PERIOD_Pos) /**< \brief (SSC_TCMR) Transmit Period Divider Selection */
#define SSC_TCMR_PERIOD(value) ((SSC_TCMR_PERIOD_Msk & ((value) << SSC_TCMR_PERIOD_Pos)))
/* -------- SSC_TFMR : (SSC Offset: 0x1C) Transmit Frame Mode Register -------- */
#define SSC_TFMR_DATLEN_Pos 0
#define SSC_TFMR_DATLEN_Msk (0x1fu << SSC_TFMR_DATLEN_Pos) /**< \brief (SSC_TFMR) Data Length */
#define SSC_TFMR_DATLEN(value) ((SSC_TFMR_DATLEN_Msk & ((value) << SSC_TFMR_DATLEN_Pos)))
#define SSC_TFMR_DATDEF (0x1u << 5) /**< \brief (SSC_TFMR) Data Default Value */
#define SSC_TFMR_MSBF (0x1u << 7) /**< \brief (SSC_TFMR) Most Significant Bit First */
#define SSC_TFMR_DATNB_Pos 8
#define SSC_TFMR_DATNB_Msk (0xfu << SSC_TFMR_DATNB_Pos) /**< \brief (SSC_TFMR) Data Number per frame */
#define SSC_TFMR_DATNB(value) ((SSC_TFMR_DATNB_Msk & ((value) << SSC_TFMR_DATNB_Pos)))
#define SSC_TFMR_FSLEN_Pos 16
#define SSC_TFMR_FSLEN_Msk (0xfu << SSC_TFMR_FSLEN_Pos) /**< \brief (SSC_TFMR) Transmit Frame Sync Length */
#define SSC_TFMR_FSLEN(value) ((SSC_TFMR_FSLEN_Msk & ((value) << SSC_TFMR_FSLEN_Pos)))
#define SSC_TFMR_FSOS_Pos 20
#define SSC_TFMR_FSOS_Msk (0x7u << SSC_TFMR_FSOS_Pos) /**< \brief (SSC_TFMR) Transmit Frame Sync Output Selection */
#define   SSC_TFMR_FSOS_NONE (0x0u << 20) /**< \brief (SSC_TFMR) None, TF pin is an input */
#define   SSC_TFMR_FSOS_NEGATIVE (0x1u << 20) /**< \brief (SSC_TFMR) Negative Pulse, TF pin is an output */
#define   SSC_TFMR_FSOS_POSITIVE (0x2u << 20) /**< \brief (SSC_TFMR) Positive Pulse,TF pin is an output */
#define   SSC_TFMR_FSOS_LOW (0x3u << 20) /**< \brief (SSC_TFMR) TF pin Driven Low during data transfer */
#define   SSC_TFMR_FSOS_HIGH (0x4u << 20) /**< \brief (SSC_TFMR) TF pin Driven High during data transfer */
#define   SSC_TFMR_FSOS_TOGGLING (0x5u << 20) /**< \brief (SSC_TFMR) TF pin Toggles at each start of data transfer */
#define SSC_TFMR_FSDEN (0x1u << 23) /**< \brief (SSC_TFMR) Frame Sync Data Enable */
#define SSC_TFMR_FSEDGE (0x1u << 24) /**< \brief (SSC_TFMR) Frame Sync Edge Detection */
#define   SSC_TFMR_FSEDGE_POSITIVE (0x0u << 24) /**< \brief (SSC_TFMR) Positive Edge Detection */
#define   SSC_TFMR_FSEDGE_NEGATIVE (0x1u << 24) /**< \brief (SSC_TFMR) Negative Edge Detection */
#define SSC_TFMR_FSLEN_EXT_Pos 28
#define SSC_TFMR_FSLEN_EXT_Msk (0xfu << SSC_TFMR_FSLEN_EXT_Pos) /**< \brief (SSC_TFMR) FSLEN Field Extension */
#define SSC_TFMR_FSLEN_EXT(value) ((SSC_TFMR_FSLEN_EXT_Msk & ((value) << SSC_TFMR_FSLEN_EXT_Pos)))
/* -------- SSC_RHR : (SSC Offset: 0x20) Receive Holding Register -------- */
#define SSC_RHR_RDAT_Pos 0
#define SSC_RHR_RDAT_Msk (0xffffffffu << SSC_RHR_RDAT_Pos) /**< \brief (SSC_RHR) Receive Data */
/* -------- SSC_THR : (SSC Offset: 0x24) Transmit Holding Register -------- */
#define SSC_THR_TDAT_Pos 0
#define SSC_THR_TDAT_Msk (0xffffffffu << SSC_THR_TDAT_Pos) /**< \brief (SSC_THR) Transmit Data */
#define SSC_THR_TDAT(value) ((SSC_THR_TDAT_Msk & ((value) << SSC_THR_TDAT_Pos)))
/* -------- SSC_RSHR : (SSC Offset: 0x30) Receive Sync. Holding Register -------- */
#define SSC_RSHR_RSDAT_Pos 0
#define SSC_RSHR_RSDAT_Msk (0xffffu << SSC_RSHR_RSDAT_Pos) /**< \brief (SSC_RSHR) Receive Synchronization Data */
/* -------- SSC_TSHR : (SSC Offset: 0x34) Transmit Sync. Holding Register -------- */
#define SSC_TSHR_TSDAT_Pos 0
#define SSC_TSHR_TSDAT_Msk (0xffffu << SSC_TSHR_TSDAT_Pos) /**< \brief (SSC_TSHR) Transmit Synchronization Data */
#define SSC_TSHR_TSDAT(value) ((SSC_TSHR_TSDAT_Msk & ((value) << SSC_TSHR_TSDAT_Pos)))
/* -------- SSC_RC0R : (SSC Offset: 0x38) Receive Compare 0 Register -------- */
#define SSC_RC0R_CP0_Pos 0
#define SSC_RC0R_CP0_Msk (0xffffu << SSC_RC0R_CP0_Pos) /**< \brief (SSC_RC0R) Receive Compare Data 0 */
#define SSC_RC0R_CP0(value) ((SSC_RC0R_CP0_Msk & ((value) << SSC_RC0R_CP0_Pos)))
/* -------- SSC_RC1R : (SSC Offset: 0x3C) Receive Compare 1 Register -------- */
#define SSC_RC1R_CP1_Pos 0
#define SSC_RC1R_CP1_Msk (0xffffu << SSC_RC1R_CP1_Pos) /**< \brief (SSC_RC1R) Receive Compare Data 1 */
#define SSC_RC1R_CP1(value) ((SSC_RC1R_CP1_Msk & ((value) << SSC_RC1R_CP1_Pos)))
/* -------- SSC_SR : (SSC Offset: 0x40) Status Register -------- */
#define SSC_SR_TXRDY (0x1u << 0) /**< \brief (SSC_SR) Transmit Ready */
#define SSC_SR_TXEMPTY (0x1u << 1) /**< \brief (SSC_SR) Transmit Empty */
#define SSC_SR_RXRDY (0x1u << 4) /**< \brief (SSC_SR) Receive Ready */
#define SSC_SR_OVRUN (0x1u << 5) /**< \brief (SSC_SR) Receive Overrun */
#define SSC_SR_CP0 (0x1u << 8) /**< \brief (SSC_SR) Compare 0 */
#define SSC_SR_CP1 (0x1u << 9) /**< \brief (SSC_SR) Compare 1 */
#define SSC_SR_TXSYN (0x1u << 10) /**< \brief (SSC_SR) Transmit Sync */
#define SSC_SR_RXSYN (0x1u << 11) /**< \brief (SSC_SR) Receive Sync */
#define SSC_SR_TXEN (0x1u << 16) /**< \brief (SSC_SR) Transmit Enable */
#define SSC_SR_RXEN (0x1u << 17) /**< \brief (SSC_SR) Receive Enable */
/* -------- SSC_IER : (SSC Offset: 0x44) Interrupt Enable Register -------- */
#define SSC_IER_TXRDY (0x1u << 0) /**< \brief (SSC_IER) Transmit Ready Interrupt Enable */
#define SSC_IER_TXEMPTY (0x1u << 1) /**< \brief (SSC_IER) Transmit Empty Interrupt Enable */
#define SSC_IER_RXRDY (0x1u << 4) /**< \brief (SSC_IER) Receive Ready Interrupt Enable */
#define SSC_IER_OVRUN (0x1u << 5) /**< \brief (SSC_IER) Receive Overrun Interrupt Enable */
#define SSC_IER_CP0 (0x1u << 8) /**< \brief (SSC_IER) Compare 0 Interrupt Enable */
#define SSC_IER_CP1 (0x1u << 9) /**< \brief (SSC_IER) Compare 1 Interrupt Enable */
#define SSC_IER_TXSYN (0x1u << 10) /**< \brief (SSC_IER) Tx Sync Interrupt Enable */
#define SSC_IER_RXSYN (0x1u << 11) /**< \brief (SSC_IER) Rx Sync Interrupt Enable */
/* -------- SSC_IDR : (SSC Offset: 0x48) Interrupt Disable Register -------- */
#define SSC_IDR_TXRDY (0x1u << 0) /**< \brief (SSC_IDR) Transmit Ready Interrupt Disable */
#define SSC_IDR_TXEMPTY (0x1u << 1) /**< \brief (SSC_IDR) Transmit Empty Interrupt Disable */
#define SSC_IDR_RXRDY (0x1u << 4) /**< \brief (SSC_IDR) Receive Ready Interrupt Disable */
#define SSC_IDR_OVRUN (0x1u << 5) /**< \brief (SSC_IDR) Receive Overrun Interrupt Disable */
#define SSC_IDR_CP0 (0x1u << 8) /**< \brief (SSC_IDR) Compare 0 Interrupt Disable */
#define SSC_IDR_CP1 (0x1u << 9) /**< \brief (SSC_IDR) Compare 1 Interrupt Disable */
#define SSC_IDR_TXSYN (0x1u << 10) /**< \brief (SSC_IDR) Tx Sync Interrupt Enable */
#define SSC_IDR_RXSYN (0x1u << 11) /**< \brief (SSC_IDR) Rx Sync Interrupt Enable */
/* -------- SSC_IMR : (SSC Offset: 0x4C) Interrupt Mask Register -------- */
#define SSC_IMR_TXRDY (0x1u << 0) /**< \brief (SSC_IMR) Transmit Ready Interrupt Mask */
#define SSC_IMR_TXEMPTY (0x1u << 1) /**< \brief (SSC_IMR) Transmit Empty Interrupt Mask */
#define SSC_IMR_RXRDY (0x1u << 4) /**< \brief (SSC_IMR) Receive Ready Interrupt Mask */
#define SSC_IMR_OVRUN (0x1u << 5) /**< \brief (SSC_IMR) Receive Overrun Interrupt Mask */
#define SSC_IMR_CP0 (0x1u << 8) /**< \brief (SSC_IMR) Compare 0 Interrupt Mask */
#define SSC_IMR_CP1 (0x1u << 9) /**< \brief (SSC_IMR) Compare 1 Interrupt Mask */
#define SSC_IMR_TXSYN (0x1u << 10) /**< \brief (SSC_IMR) Tx Sync Interrupt Mask */
#define SSC_IMR_RXSYN (0x1u << 11) /**< \brief (SSC_IMR) Rx Sync Interrupt Mask */
/* -------- SSC_WPMR : (SSC Offset: 0xE4) Write Protect Mode Register -------- */
#define SSC_WPMR_WPEN (0x1u << 0) /**< \brief (SSC_WPMR) Write Protect Enable */
#define SSC_WPMR_WPKEY_Pos 8
#define SSC_WPMR_WPKEY_Msk (0xffffffu << SSC_WPMR_WPKEY_Pos) /**< \brief (SSC_WPMR) Write Protect KEY */
#define SSC_WPMR_WPKEY(value) ((SSC_WPMR_WPKEY_Msk & ((value) << SSC_WPMR_WPKEY_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Timer Counter */
/* ============================================================================= */
/** \addtogroup SAMA5D4_TC Timer Counter */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief TcChannel hardware registers */
typedef struct {
  __O  uint32_t TC_CCR;       /**< \brief (TcChannel Offset: 0x0) Channel Control Register */
  __IO uint32_t TC_CMR;       /**< \brief (TcChannel Offset: 0x4) Channel Mode Register */
  __IO uint32_t TC_SMMR;      /**< \brief (TcChannel Offset: 0x8) Stepper Motor Mode Register */
  __I  uint32_t TC_RAB;       /**< \brief (TcChannel Offset: 0xC) Register AB */
  __I  uint32_t TC_CV;        /**< \brief (TcChannel Offset: 0x10) Counter Value */
  __IO uint32_t TC_RA;        /**< \brief (TcChannel Offset: 0x14) Register A */
  __IO uint32_t TC_RB;        /**< \brief (TcChannel Offset: 0x18) Register B */
  __IO uint32_t TC_RC;        /**< \brief (TcChannel Offset: 0x1C) Register C */
  __I  uint32_t TC_SR;        /**< \brief (TcChannel Offset: 0x20) Status Register */
  __O  uint32_t TC_IER;       /**< \brief (TcChannel Offset: 0x24) Interrupt Enable Register */
  __O  uint32_t TC_IDR;       /**< \brief (TcChannel Offset: 0x28) Interrupt Disable Register */
  __I  uint32_t TC_IMR;       /**< \brief (TcChannel Offset: 0x2C) Interrupt Mask Register */
  __IO uint32_t TC_EMR;       /**< \brief (TcChannel Offset: 0x30) Extended Mode Register */
  __I  uint32_t Reserved1[3];
} TcChannel;
/** \brief Tc hardware registers */
#define TCCHANNEL_NUMBER 3
typedef struct {
       TcChannel TC_CHANNEL[TCCHANNEL_NUMBER]; /**< \brief (Tc Offset: 0x0) channel = 0 .. 2 */
  __O  uint32_t  TC_BCR;                       /**< \brief (Tc Offset: 0xC0) Block Control Register */
  __IO uint32_t  TC_BMR;                       /**< \brief (Tc Offset: 0xC4) Block Mode Register */
  __O  uint32_t  TC_QIER;                      /**< \brief (Tc Offset: 0xC8) QDEC Interrupt Enable Register */
  __O  uint32_t  TC_QIDR;                      /**< \brief (Tc Offset: 0xCC) QDEC Interrupt Disable Register */
  __I  uint32_t  TC_QIMR;                      /**< \brief (Tc Offset: 0xD0) QDEC Interrupt Mask Register */
  __I  uint32_t  TC_QISR;                      /**< \brief (Tc Offset: 0xD4) QDEC Interrupt Status Register */
  __IO uint32_t  TC_FMR;                       /**< \brief (Tc Offset: 0xD8) Fault Mode Register */
  __I  uint32_t  Reserved1[2];
  __IO uint32_t  TC_WPMR;                      /**< \brief (Tc Offset: 0xE4) Write Protect Mode Register */
} Tc;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- TC_CCR : (TC Offset: N/A) Channel Control Register -------- */
#define TC_CCR_CLKEN (0x1u << 0) /**< \brief (TC_CCR) Counter Clock Enable Command */
#define TC_CCR_CLKDIS (0x1u << 1) /**< \brief (TC_CCR) Counter Clock Disable Command */
#define TC_CCR_SWTRG (0x1u << 2) /**< \brief (TC_CCR) Software Trigger Command */
/* -------- TC_CMR : (TC Offset: N/A) Channel Mode Register -------- */
#define TC_CMR_TCCLKS_Pos 0
#define TC_CMR_TCCLKS_Msk (0x7u << TC_CMR_TCCLKS_Pos) /**< \brief (TC_CMR) Clock Selection */
#define   TC_CMR_TCCLKS_TIMER_CLOCK1 (0x0u << 0) /**< \brief (TC_CMR) Clock selected: TCLK1 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK2 (0x1u << 0) /**< \brief (TC_CMR) Clock selected: TCLK2 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK3 (0x2u << 0) /**< \brief (TC_CMR) Clock selected: TCLK3 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK4 (0x3u << 0) /**< \brief (TC_CMR) Clock selected: TCLK4 */
#define   TC_CMR_TCCLKS_TIMER_CLOCK5 (0x4u << 0) /**< \brief (TC_CMR) Clock selected: TCLK5 */
#define   TC_CMR_TCCLKS_XC0 (0x5u << 0) /**< \brief (TC_CMR) Clock selected: XC0 */
#define   TC_CMR_TCCLKS_XC1 (0x6u << 0) /**< \brief (TC_CMR) Clock selected: XC1 */
#define   TC_CMR_TCCLKS_XC2 (0x7u << 0) /**< \brief (TC_CMR) Clock selected: XC2 */
#define TC_CMR_CLKI (0x1u << 3) /**< \brief (TC_CMR) Clock Invert */
#define TC_CMR_BURST_Pos 4
#define TC_CMR_BURST_Msk (0x3u << TC_CMR_BURST_Pos) /**< \brief (TC_CMR) Burst Signal Selection */
#define   TC_CMR_BURST_NONE (0x0u << 4) /**< \brief (TC_CMR) The clock is not gated by an external signal. */
#define   TC_CMR_BURST_XC0 (0x1u << 4) /**< \brief (TC_CMR) XC0 is ANDed with the selected clock. */
#define   TC_CMR_BURST_XC1 (0x2u << 4) /**< \brief (TC_CMR) XC1 is ANDed with the selected clock. */
#define   TC_CMR_BURST_XC2 (0x3u << 4) /**< \brief (TC_CMR) XC2 is ANDed with the selected clock. */
#define TC_CMR_LDBSTOP (0x1u << 6) /**< \brief (TC_CMR) Counter Clock Stopped with RB Loading */
#define TC_CMR_LDBDIS (0x1u << 7) /**< \brief (TC_CMR) Counter Clock Disable with RB Loading */
#define TC_CMR_ETRGEDG_Pos 8
#define TC_CMR_ETRGEDG_Msk (0x3u << TC_CMR_ETRGEDG_Pos) /**< \brief (TC_CMR) External Trigger Edge Selection */
#define   TC_CMR_ETRGEDG_NONE (0x0u << 8) /**< \brief (TC_CMR) The clock is not gated by an external signal. */
#define   TC_CMR_ETRGEDG_RISING (0x1u << 8) /**< \brief (TC_CMR) Rising edge */
#define   TC_CMR_ETRGEDG_FALLING (0x2u << 8) /**< \brief (TC_CMR) Falling edge */
#define   TC_CMR_ETRGEDG_EDGE (0x3u << 8) /**< \brief (TC_CMR) Each edge */
#define TC_CMR_ABETRG (0x1u << 10) /**< \brief (TC_CMR) TIOA or TIOB External Trigger Selection */
#define TC_CMR_CPCTRG (0x1u << 14) /**< \brief (TC_CMR) RC Compare Trigger Enable */
#define TC_CMR_WAVE (0x1u << 15) /**< \brief (TC_CMR) Waveform Mode */
#define TC_CMR_LDRA_Pos 16
#define TC_CMR_LDRA_Msk (0x3u << TC_CMR_LDRA_Pos) /**< \brief (TC_CMR) RA Loading Edge Selection */
#define   TC_CMR_LDRA_NONE (0x0u << 16) /**< \brief (TC_CMR) None */
#define   TC_CMR_LDRA_RISING (0x1u << 16) /**< \brief (TC_CMR) Rising edge of TIOA */
#define   TC_CMR_LDRA_FALLING (0x2u << 16) /**< \brief (TC_CMR) Falling edge of TIOA */
#define   TC_CMR_LDRA_EDGE (0x3u << 16) /**< \brief (TC_CMR) Each edge of TIOA */
#define TC_CMR_LDRB_Pos 18
#define TC_CMR_LDRB_Msk (0x3u << TC_CMR_LDRB_Pos) /**< \brief (TC_CMR) RB Loading Edge Selection */
#define   TC_CMR_LDRB_NONE (0x0u << 18) /**< \brief (TC_CMR) None */
#define   TC_CMR_LDRB_RISING (0x1u << 18) /**< \brief (TC_CMR) Rising edge of TIOA */
#define   TC_CMR_LDRB_FALLING (0x2u << 18) /**< \brief (TC_CMR) Falling edge of TIOA */
#define   TC_CMR_LDRB_EDGE (0x3u << 18) /**< \brief (TC_CMR) Each edge of TIOA */
#define TC_CMR_SBSMPLR_Pos 20
#define TC_CMR_SBSMPLR_Msk (0x7u << TC_CMR_SBSMPLR_Pos) /**< \brief (TC_CMR) Loading Edge Subsampling Ratio */
#define   TC_CMR_SBSMPLR_ONE (0x0u << 20) /**< \brief (TC_CMR) Load a Capture Register each selected edge */
#define   TC_CMR_SBSMPLR_HALF (0x1u << 20) /**< \brief (TC_CMR) Load a Capture Register every 2 selected edges */
#define   TC_CMR_SBSMPLR_FOURTH (0x2u << 20) /**< \brief (TC_CMR) Load a Capture Register every 4 selected edges */
#define   TC_CMR_SBSMPLR_EIGHTH (0x3u << 20) /**< \brief (TC_CMR) Load a Capture Register every 8 selected edges */
#define   TC_CMR_SBSMPLR_SIXTEENTH (0x4u << 20) /**< \brief (TC_CMR) Load a Capture Register every 16 selected edges */
#define TC_CMR_CPCSTOP (0x1u << 6) /**< \brief (TC_CMR) Counter Clock Stopped with RC Compare */
#define TC_CMR_CPCDIS (0x1u << 7) /**< \brief (TC_CMR) Counter Clock Disable with RC Compare */
#define TC_CMR_EEVTEDG_Pos 8
#define TC_CMR_EEVTEDG_Msk (0x3u << TC_CMR_EEVTEDG_Pos) /**< \brief (TC_CMR) External Event Edge Selection */
#define   TC_CMR_EEVTEDG_NONE (0x0u << 8) /**< \brief (TC_CMR) None */
#define   TC_CMR_EEVTEDG_RISING (0x1u << 8) /**< \brief (TC_CMR) Rising edge */
#define   TC_CMR_EEVTEDG_FALLING (0x2u << 8) /**< \brief (TC_CMR) Falling edge */
#define   TC_CMR_EEVTEDG_EDGE (0x3u << 8) /**< \brief (TC_CMR) Each edge */
#define TC_CMR_EEVT_Pos 10
#define TC_CMR_EEVT_Msk (0x3u << TC_CMR_EEVT_Pos) /**< \brief (TC_CMR) External Event Selection */
#define   TC_CMR_EEVT_TIOB (0x0u << 10) /**< \brief (TC_CMR) TIOB */
#define   TC_CMR_EEVT_XC0 (0x1u << 10) /**< \brief (TC_CMR) XC0 */
#define   TC_CMR_EEVT_XC1 (0x2u << 10) /**< \brief (TC_CMR) XC1 */
#define   TC_CMR_EEVT_XC2 (0x3u << 10) /**< \brief (TC_CMR) XC2 */
#define TC_CMR_ENETRG (0x1u << 12) /**< \brief (TC_CMR) External Event Trigger Enable */
#define TC_CMR_WAVSEL_Pos 13
#define TC_CMR_WAVSEL_Msk (0x3u << TC_CMR_WAVSEL_Pos) /**< \brief (TC_CMR) Waveform Selection */
#define   TC_CMR_WAVSEL_UP (0x0u << 13) /**< \brief (TC_CMR) UP mode without automatic trigger on RC Compare */
#define   TC_CMR_WAVSEL_UPDOWN (0x1u << 13) /**< \brief (TC_CMR) UPDOWN mode without automatic trigger on RC Compare */
#define   TC_CMR_WAVSEL_UP_RC (0x2u << 13) /**< \brief (TC_CMR) UP mode with automatic trigger on RC Compare */
#define   TC_CMR_WAVSEL_UPDOWN_RC (0x3u << 13) /**< \brief (TC_CMR) UPDOWN mode with automatic trigger on RC Compare */
#define TC_CMR_ACPA_Pos 16
#define TC_CMR_ACPA_Msk (0x3u << TC_CMR_ACPA_Pos) /**< \brief (TC_CMR) RA Compare Effect on TIOA */
#define   TC_CMR_ACPA_NONE (0x0u << 16) /**< \brief (TC_CMR) None */
#define   TC_CMR_ACPA_SET (0x1u << 16) /**< \brief (TC_CMR) Set */
#define   TC_CMR_ACPA_CLEAR (0x2u << 16) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_ACPA_TOGGLE (0x3u << 16) /**< \brief (TC_CMR) Toggle */
#define TC_CMR_ACPC_Pos 18
#define TC_CMR_ACPC_Msk (0x3u << TC_CMR_ACPC_Pos) /**< \brief (TC_CMR) RC Compare Effect on TIOA */
#define   TC_CMR_ACPC_NONE (0x0u << 18) /**< \brief (TC_CMR) None */
#define   TC_CMR_ACPC_SET (0x1u << 18) /**< \brief (TC_CMR) Set */
#define   TC_CMR_ACPC_CLEAR (0x2u << 18) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_ACPC_TOGGLE (0x3u << 18) /**< \brief (TC_CMR) Toggle */
#define TC_CMR_AEEVT_Pos 20
#define TC_CMR_AEEVT_Msk (0x3u << TC_CMR_AEEVT_Pos) /**< \brief (TC_CMR) External Event Effect on TIOA */
#define   TC_CMR_AEEVT_NONE (0x0u << 20) /**< \brief (TC_CMR) None */
#define   TC_CMR_AEEVT_SET (0x1u << 20) /**< \brief (TC_CMR) Set */
#define   TC_CMR_AEEVT_CLEAR (0x2u << 20) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_AEEVT_TOGGLE (0x3u << 20) /**< \brief (TC_CMR) Toggle */
#define TC_CMR_ASWTRG_Pos 22
#define TC_CMR_ASWTRG_Msk (0x3u << TC_CMR_ASWTRG_Pos) /**< \brief (TC_CMR) Software Trigger Effect on TIOA */
#define   TC_CMR_ASWTRG_NONE (0x0u << 22) /**< \brief (TC_CMR) None */
#define   TC_CMR_ASWTRG_SET (0x1u << 22) /**< \brief (TC_CMR) Set */
#define   TC_CMR_ASWTRG_CLEAR (0x2u << 22) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_ASWTRG_TOGGLE (0x3u << 22) /**< \brief (TC_CMR) Toggle */
#define TC_CMR_BCPB_Pos 24
#define TC_CMR_BCPB_Msk (0x3u << TC_CMR_BCPB_Pos) /**< \brief (TC_CMR) RB Compare Effect on TIOB */
#define   TC_CMR_BCPB_NONE (0x0u << 24) /**< \brief (TC_CMR) None */
#define   TC_CMR_BCPB_SET (0x1u << 24) /**< \brief (TC_CMR) Set */
#define   TC_CMR_BCPB_CLEAR (0x2u << 24) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_BCPB_TOGGLE (0x3u << 24) /**< \brief (TC_CMR) Toggle */
#define TC_CMR_BCPC_Pos 26
#define TC_CMR_BCPC_Msk (0x3u << TC_CMR_BCPC_Pos) /**< \brief (TC_CMR) RC Compare Effect on TIOB */
#define   TC_CMR_BCPC_NONE (0x0u << 26) /**< \brief (TC_CMR) None */
#define   TC_CMR_BCPC_SET (0x1u << 26) /**< \brief (TC_CMR) Set */
#define   TC_CMR_BCPC_CLEAR (0x2u << 26) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_BCPC_TOGGLE (0x3u << 26) /**< \brief (TC_CMR) Toggle */
#define TC_CMR_BEEVT_Pos 28
#define TC_CMR_BEEVT_Msk (0x3u << TC_CMR_BEEVT_Pos) /**< \brief (TC_CMR) External Event Effect on TIOB */
#define   TC_CMR_BEEVT_NONE (0x0u << 28) /**< \brief (TC_CMR) None */
#define   TC_CMR_BEEVT_SET (0x1u << 28) /**< \brief (TC_CMR) Set */
#define   TC_CMR_BEEVT_CLEAR (0x2u << 28) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_BEEVT_TOGGLE (0x3u << 28) /**< \brief (TC_CMR) Toggle */
#define TC_CMR_BSWTRG_Pos 30
#define TC_CMR_BSWTRG_Msk (0x3u << TC_CMR_BSWTRG_Pos) /**< \brief (TC_CMR) Software Trigger Effect on TIOB */
#define   TC_CMR_BSWTRG_NONE (0x0u << 30) /**< \brief (TC_CMR) None */
#define   TC_CMR_BSWTRG_SET (0x1u << 30) /**< \brief (TC_CMR) Set */
#define   TC_CMR_BSWTRG_CLEAR (0x2u << 30) /**< \brief (TC_CMR) Clear */
#define   TC_CMR_BSWTRG_TOGGLE (0x3u << 30) /**< \brief (TC_CMR) Toggle */
/* -------- TC_SMMR : (TC Offset: N/A) Stepper Motor Mode Register -------- */
#define TC_SMMR_GCEN (0x1u << 0) /**< \brief (TC_SMMR) Gray Count Enable */
#define TC_SMMR_DOWN (0x1u << 1) /**< \brief (TC_SMMR) DOWN Count */
/* -------- TC_RAB : (TC Offset: N/A) Register AB -------- */
#define TC_RAB_RAB_Pos 0
#define TC_RAB_RAB_Msk (0xffffffffu << TC_RAB_RAB_Pos) /**< \brief (TC_RAB) Register A or Register B */
/* -------- TC_CV : (TC Offset: N/A) Counter Value -------- */
#define TC_CV_CV_Pos 0
#define TC_CV_CV_Msk (0xffffffffu << TC_CV_CV_Pos) /**< \brief (TC_CV) Counter Value */
/* -------- TC_RA : (TC Offset: N/A) Register A -------- */
#define TC_RA_RA_Pos 0
#define TC_RA_RA_Msk (0xffffffffu << TC_RA_RA_Pos) /**< \brief (TC_RA) Register A */
#define TC_RA_RA(value) ((TC_RA_RA_Msk & ((value) << TC_RA_RA_Pos)))
/* -------- TC_RB : (TC Offset: N/A) Register B -------- */
#define TC_RB_RB_Pos 0
#define TC_RB_RB_Msk (0xffffffffu << TC_RB_RB_Pos) /**< \brief (TC_RB) Register B */
#define TC_RB_RB(value) ((TC_RB_RB_Msk & ((value) << TC_RB_RB_Pos)))
/* -------- TC_RC : (TC Offset: N/A) Register C -------- */
#define TC_RC_RC_Pos 0
#define TC_RC_RC_Msk (0xffffffffu << TC_RC_RC_Pos) /**< \brief (TC_RC) Register C */
#define TC_RC_RC(value) ((TC_RC_RC_Msk & ((value) << TC_RC_RC_Pos)))
/* -------- TC_SR : (TC Offset: N/A) Status Register -------- */
#define TC_SR_COVFS (0x1u << 0) /**< \brief (TC_SR) Counter Overflow Status */
#define TC_SR_LOVRS (0x1u << 1) /**< \brief (TC_SR) Load Overrun Status */
#define TC_SR_CPAS (0x1u << 2) /**< \brief (TC_SR) RA Compare Status */
#define TC_SR_CPBS (0x1u << 3) /**< \brief (TC_SR) RB Compare Status */
#define TC_SR_CPCS (0x1u << 4) /**< \brief (TC_SR) RC Compare Status */
#define TC_SR_LDRAS (0x1u << 5) /**< \brief (TC_SR) RA Loading Status */
#define TC_SR_LDRBS (0x1u << 6) /**< \brief (TC_SR) RB Loading Status */
#define TC_SR_ETRGS (0x1u << 7) /**< \brief (TC_SR) External Trigger Status */
#define TC_SR_CLKSTA (0x1u << 16) /**< \brief (TC_SR) Clock Enabling Status */
#define TC_SR_MTIOA (0x1u << 17) /**< \brief (TC_SR) TIOA Mirror */
#define TC_SR_MTIOB (0x1u << 18) /**< \brief (TC_SR) TIOB Mirror */
/* -------- TC_IER : (TC Offset: N/A) Interrupt Enable Register -------- */
#define TC_IER_COVFS (0x1u << 0) /**< \brief (TC_IER) Counter Overflow */
#define TC_IER_LOVRS (0x1u << 1) /**< \brief (TC_IER) Load Overrun */
#define TC_IER_CPAS (0x1u << 2) /**< \brief (TC_IER) RA Compare */
#define TC_IER_CPBS (0x1u << 3) /**< \brief (TC_IER) RB Compare */
#define TC_IER_CPCS (0x1u << 4) /**< \brief (TC_IER) RC Compare */
#define TC_IER_LDRAS (0x1u << 5) /**< \brief (TC_IER) RA Loading */
#define TC_IER_LDRBS (0x1u << 6) /**< \brief (TC_IER) RB Loading */
#define TC_IER_ETRGS (0x1u << 7) /**< \brief (TC_IER) External Trigger */
/* -------- TC_IDR : (TC Offset: N/A) Interrupt Disable Register -------- */
#define TC_IDR_COVFS (0x1u << 0) /**< \brief (TC_IDR) Counter Overflow */
#define TC_IDR_LOVRS (0x1u << 1) /**< \brief (TC_IDR) Load Overrun */
#define TC_IDR_CPAS (0x1u << 2) /**< \brief (TC_IDR) RA Compare */
#define TC_IDR_CPBS (0x1u << 3) /**< \brief (TC_IDR) RB Compare */
#define TC_IDR_CPCS (0x1u << 4) /**< \brief (TC_IDR) RC Compare */
#define TC_IDR_LDRAS (0x1u << 5) /**< \brief (TC_IDR) RA Loading */
#define TC_IDR_LDRBS (0x1u << 6) /**< \brief (TC_IDR) RB Loading */
#define TC_IDR_ETRGS (0x1u << 7) /**< \brief (TC_IDR) External Trigger */
/* -------- TC_IMR : (TC Offset: N/A) Interrupt Mask Register -------- */
#define TC_IMR_COVFS (0x1u << 0) /**< \brief (TC_IMR) Counter Overflow */
#define TC_IMR_LOVRS (0x1u << 1) /**< \brief (TC_IMR) Load Overrun */
#define TC_IMR_CPAS (0x1u << 2) /**< \brief (TC_IMR) RA Compare */
#define TC_IMR_CPBS (0x1u << 3) /**< \brief (TC_IMR) RB Compare */
#define TC_IMR_CPCS (0x1u << 4) /**< \brief (TC_IMR) RC Compare */
#define TC_IMR_LDRAS (0x1u << 5) /**< \brief (TC_IMR) RA Loading */
#define TC_IMR_LDRBS (0x1u << 6) /**< \brief (TC_IMR) RB Loading */
#define TC_IMR_ETRGS (0x1u << 7) /**< \brief (TC_IMR) External Trigger */
/* -------- TC_EMR : (TC Offset: N/A) Extended Mode Register -------- */
#define TC_EMR_TRIGSRCA_Pos 0
#define TC_EMR_TRIGSRCA_Msk (0x3u << TC_EMR_TRIGSRCA_Pos) /**< \brief (TC_EMR) TRIGger SouRCe for input A */
#define   TC_EMR_TRIGSRCA_EXTERNAL_TIOAx (0x0u << 0) /**< \brief (TC_EMR) the trigger/capture input A is driven by external pin TIOAx */
#define   TC_EMR_TRIGSRCA_PWMx (0x1u << 0) /**< \brief (TC_EMR) the trigger/capture input A is driven internally by PWMx */
#define TC_EMR_TRIGSRCB_Pos 4
#define TC_EMR_TRIGSRCB_Msk (0x3u << TC_EMR_TRIGSRCB_Pos) /**< \brief (TC_EMR) TRIGger SouRCe for input B */
#define   TC_EMR_TRIGSRCB_EXTERNAL_TIOBx (0x0u << 4) /**< \brief (TC_EMR) the trigger/capture input B is driven by external pin TIOBx */
#define   TC_EMR_TRIGSRCB_PWMx (0x1u << 4) /**< \brief (TC_EMR) the trigger/capture input B is driven internally by PWMx */
#define TC_EMR_NODIVCLK (0x1u << 8) /**< \brief (TC_EMR) NO DIVided CLocK */
/* -------- TC_BCR : (TC Offset: 0xC0) Block Control Register -------- */
#define TC_BCR_SYNC (0x1u << 0) /**< \brief (TC_BCR) Synchro Command */
/* -------- TC_BMR : (TC Offset: 0xC4) Block Mode Register -------- */
#define TC_BMR_TC0XC0S_Pos 0
#define TC_BMR_TC0XC0S_Msk (0x3u << TC_BMR_TC0XC0S_Pos) /**< \brief (TC_BMR) External Clock Signal 0 Selection */
#define   TC_BMR_TC0XC0S_TCLK0 (0x0u << 0) /**< \brief (TC_BMR) Signal connected to XC0: TCLK0 */
#define   TC_BMR_TC0XC0S_TIOA1 (0x2u << 0) /**< \brief (TC_BMR) Signal connected to XC0: TIOA1 */
#define   TC_BMR_TC0XC0S_TIOA2 (0x3u << 0) /**< \brief (TC_BMR) Signal connected to XC0: TIOA2 */
#define TC_BMR_TC1XC1S_Pos 2
#define TC_BMR_TC1XC1S_Msk (0x3u << TC_BMR_TC1XC1S_Pos) /**< \brief (TC_BMR) External Clock Signal 1 Selection */
#define   TC_BMR_TC1XC1S_TCLK1 (0x0u << 2) /**< \brief (TC_BMR) Signal connected to XC1: TCLK1 */
#define   TC_BMR_TC1XC1S_TIOA0 (0x2u << 2) /**< \brief (TC_BMR) Signal connected to XC1: TIOA0 */
#define   TC_BMR_TC1XC1S_TIOA2 (0x3u << 2) /**< \brief (TC_BMR) Signal connected to XC1: TIOA2 */
#define TC_BMR_TC2XC2S_Pos 4
#define TC_BMR_TC2XC2S_Msk (0x3u << TC_BMR_TC2XC2S_Pos) /**< \brief (TC_BMR) External Clock Signal 2 Selection */
#define   TC_BMR_TC2XC2S_TCLK2 (0x0u << 4) /**< \brief (TC_BMR) Signal connected to XC2: TCLK2 */
#define   TC_BMR_TC2XC2S_TIOA1 (0x2u << 4) /**< \brief (TC_BMR) Signal connected to XC2: TIOA1 */
#define   TC_BMR_TC2XC2S_TIOA2 (0x3u << 4) /**< \brief (TC_BMR) Signal connected to XC2: TIOA2 */
#define TC_BMR_QDEN (0x1u << 8) /**< \brief (TC_BMR) Quadrature Decoder ENabled */
#define TC_BMR_POSEN (0x1u << 9) /**< \brief (TC_BMR) POSition ENabled */
#define TC_BMR_SPEEDEN (0x1u << 10) /**< \brief (TC_BMR) SPEED ENabled */
#define TC_BMR_QDTRANS (0x1u << 11) /**< \brief (TC_BMR) Quadrature Decoding TRANSparent */
#define TC_BMR_EDGPHA (0x1u << 12) /**< \brief (TC_BMR) EDGe on PHA count mode */
#define TC_BMR_INVA (0x1u << 13) /**< \brief (TC_BMR) INVerted phA */
#define TC_BMR_INVB (0x1u << 14) /**< \brief (TC_BMR) INVerted phB */
#define TC_BMR_INVIDX (0x1u << 15) /**< \brief (TC_BMR) INVerted InDeX */
#define TC_BMR_SWAP (0x1u << 16) /**< \brief (TC_BMR) SWAP PHA and PHB */
#define TC_BMR_IDXPHB (0x1u << 17) /**< \brief (TC_BMR) InDeX pin is PHB pin */
#define TC_BMR_FILTER (0x1u << 19) /**< \brief (TC_BMR)  */
#define TC_BMR_MAXFILT_Pos 20
#define TC_BMR_MAXFILT_Msk (0x3fu << TC_BMR_MAXFILT_Pos) /**< \brief (TC_BMR) MAXimum FILTer */
#define TC_BMR_MAXFILT(value) ((TC_BMR_MAXFILT_Msk & ((value) << TC_BMR_MAXFILT_Pos)))
/* -------- TC_QIER : (TC Offset: 0xC8) QDEC Interrupt Enable Register -------- */
#define TC_QIER_IDX (0x1u << 0) /**< \brief (TC_QIER) InDeX */
#define TC_QIER_DIRCHG (0x1u << 1) /**< \brief (TC_QIER) DIRection CHanGe */
#define TC_QIER_QERR (0x1u << 2) /**< \brief (TC_QIER) Quadrature ERRor */
/* -------- TC_QIDR : (TC Offset: 0xCC) QDEC Interrupt Disable Register -------- */
#define TC_QIDR_IDX (0x1u << 0) /**< \brief (TC_QIDR) InDeX */
#define TC_QIDR_DIRCHG (0x1u << 1) /**< \brief (TC_QIDR) DIRection CHanGe */
#define TC_QIDR_QERR (0x1u << 2) /**< \brief (TC_QIDR) Quadrature ERRor */
/* -------- TC_QIMR : (TC Offset: 0xD0) QDEC Interrupt Mask Register -------- */
#define TC_QIMR_IDX (0x1u << 0) /**< \brief (TC_QIMR) InDeX */
#define TC_QIMR_DIRCHG (0x1u << 1) /**< \brief (TC_QIMR) DIRection CHanGe */
#define TC_QIMR_QERR (0x1u << 2) /**< \brief (TC_QIMR) Quadrature ERRor */
/* -------- TC_QISR : (TC Offset: 0xD4) QDEC Interrupt Status Register -------- */
#define TC_QISR_IDX (0x1u << 0) /**< \brief (TC_QISR) InDeX */
#define TC_QISR_DIRCHG (0x1u << 1) /**< \brief (TC_QISR) DIRection CHanGe */
#define TC_QISR_QERR (0x1u << 2) /**< \brief (TC_QISR) Quadrature ERRor */
#define TC_QISR_DIR (0x1u << 8) /**< \brief (TC_QISR) DIRection */
/* -------- TC_FMR : (TC Offset: 0xD8) Fault Mode Register -------- */
#define TC_FMR_ENCF0 (0x1u << 0) /**< \brief (TC_FMR) ENable Compare Fault Channel 0 */
#define TC_FMR_ENCF1 (0x1u << 1) /**< \brief (TC_FMR) ENable Compare Fault Channel 1 */
/* -------- TC_WPMR : (TC Offset: 0xE4) Write Protect Mode Register -------- */
#define TC_WPMR_WPEN (0x1u << 0) /**< \brief (TC_WPMR) Write Protect Enable */
#define TC_WPMR_WPKEY_Pos 8
#define TC_WPMR_WPKEY_Msk (0xffffffu << TC_WPMR_WPKEY_Pos) /**< \brief (TC_WPMR) Write Protect KEY */
#define   TC_WPMR_WPKEY_PASSWD (0x54494Du << 8) /**< \brief (TC_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0. */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Triple Data Encryption Standard */
/* ============================================================================= */
/** \addtogroup SAMA5D4_TDES Triple Data Encryption Standard */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Tdes hardware registers */
typedef struct {
  __O  uint32_t TDES_CR;        /**< \brief (Tdes Offset: 0x00) Control Register */
  __IO uint32_t TDES_MR;        /**< \brief (Tdes Offset: 0x04) Mode Register */
  __I  uint32_t Reserved1[2];
  __O  uint32_t TDES_IER;       /**< \brief (Tdes Offset: 0x10) Interrupt Enable Register */
  __O  uint32_t TDES_IDR;       /**< \brief (Tdes Offset: 0x14) Interrupt Disable Register */
  __I  uint32_t TDES_IMR;       /**< \brief (Tdes Offset: 0x18) Interrupt Mask Register */
  __I  uint32_t TDES_ISR;       /**< \brief (Tdes Offset: 0x1C) Interrupt Status Register */
  __O  uint32_t TDES_KEY1WR[2]; /**< \brief (Tdes Offset: 0x20) Key 1 Word Register */
  __O  uint32_t TDES_KEY2WR[2]; /**< \brief (Tdes Offset: 0x28) Key 2 Word Register */
  __O  uint32_t TDES_KEY3WR[2]; /**< \brief (Tdes Offset: 0x30) Key 3 Word Register */
  __I  uint32_t Reserved2[2];
  __O  uint32_t TDES_IDATAR[2]; /**< \brief (Tdes Offset: 0x40) Input Data Register */
  __I  uint32_t Reserved3[2];
  __I  uint32_t TDES_ODATAR[2]; /**< \brief (Tdes Offset: 0x50) Output Data Register */
  __I  uint32_t Reserved4[2];
  __O  uint32_t TDES_IVR[2];    /**< \brief (Tdes Offset: 0x60) Initialization Vector Register */
  __I  uint32_t Reserved5[2];
  __IO uint32_t TDES_XTEA_RNDR; /**< \brief (Tdes Offset: 0x70) XTEA Rounds Register */
} Tdes;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- TDES_CR : (TDES Offset: 0x00) Control Register -------- */
#define TDES_CR_START (0x1u << 0) /**< \brief (TDES_CR) Start Processing */
#define TDES_CR_SWRST (0x1u << 8) /**< \brief (TDES_CR) Software Reset */
#define TDES_CR_LOADSEED (0x1u << 16) /**< \brief (TDES_CR) Load Seed */
/* -------- TDES_MR : (TDES Offset: 0x04) Mode Register -------- */
#define TDES_MR_CIPHER (0x1u << 0) /**< \brief (TDES_MR) Processing Mode */
#define   TDES_MR_CIPHER_DECRYPT (0x0u << 0) /**< \brief (TDES_MR) Decrypts data. */
#define   TDES_MR_CIPHER_ENCRYPT (0x1u << 0) /**< \brief (TDES_MR) Encrypts data. */
#define TDES_MR_TDESMOD_Pos 1
#define TDES_MR_TDESMOD_Msk (0x3u << TDES_MR_TDESMOD_Pos) /**< \brief (TDES_MR) ALGORITHM mode */
#define TDES_MR_TDESMOD(value) ((TDES_MR_TDESMOD_Msk & ((value) << TDES_MR_TDESMOD_Pos)))
#define TDES_MR_KEYMOD (0x1u << 4) /**< \brief (TDES_MR) Key Mode */
#define TDES_MR_SMOD_Pos 8
#define TDES_MR_SMOD_Msk (0x3u << TDES_MR_SMOD_Pos) /**< \brief (TDES_MR) Start Mode */
#define   TDES_MR_SMOD_MANUAL_START (0x0u << 8) /**< \brief (TDES_MR) Manual Mode */
#define   TDES_MR_SMOD_AUTO_START (0x1u << 8) /**< \brief (TDES_MR) Auto Mode */
#define   TDES_MR_SMOD_IDATAR0_START (0x2u << 8) /**< \brief (TDES_MR) TDES_IDATAR0 access only Auto Mode */
#define TDES_MR_OPMOD_Pos 12
#define TDES_MR_OPMOD_Msk (0x3u << TDES_MR_OPMOD_Pos) /**< \brief (TDES_MR) Operation Mode */
#define   TDES_MR_OPMOD_ECB (0x0u << 12) /**< \brief (TDES_MR) ECB: Electronic Code Book mode */
#define   TDES_MR_OPMOD_CBC (0x1u << 12) /**< \brief (TDES_MR) CBC: Cipher Block Chaining mode */
#define   TDES_MR_OPMOD_OFB (0x2u << 12) /**< \brief (TDES_MR) OFB: Output Feedback mode */
#define   TDES_MR_OPMOD_CFB (0x3u << 12) /**< \brief (TDES_MR) CFB: Cipher Feedback mode */
#define TDES_MR_LOD (0x1u << 15) /**< \brief (TDES_MR) Last Output Data Mode */
#define TDES_MR_CFBS_Pos 16
#define TDES_MR_CFBS_Msk (0x3u << TDES_MR_CFBS_Pos) /**< \brief (TDES_MR) Cipher Feedback Data Size */
#define   TDES_MR_CFBS_SIZE_64BIT (0x0u << 16) /**< \brief (TDES_MR) 64-bit */
#define   TDES_MR_CFBS_SIZE_32BIT (0x1u << 16) /**< \brief (TDES_MR) 32-bit */
#define   TDES_MR_CFBS_SIZE_16BIT (0x2u << 16) /**< \brief (TDES_MR) 16-bit */
#define   TDES_MR_CFBS_SIZE_8BIT (0x3u << 16) /**< \brief (TDES_MR) 8-bit */
#define TDES_MR_CKEY_Pos 20
#define TDES_MR_CKEY_Msk (0xfu << TDES_MR_CKEY_Pos) /**< \brief (TDES_MR) Countermeasure Key */
#define TDES_MR_CKEY(value) ((TDES_MR_CKEY_Msk & ((value) << TDES_MR_CKEY_Pos)))
#define TDES_MR_CMTYP1 (0x1u << 24) /**< \brief (TDES_MR) Countermeasure Type 1 */
#define   TDES_MR_CMTYP1_NO_PAUSE (0x0u << 24) /**< \brief (TDES_MR) Countermeasure type 1 is disabled */
#define   TDES_MR_CMTYP1_PAUSE (0x1u << 24) /**< \brief (TDES_MR) Counter-Measure type 1 is enabled */
#define TDES_MR_CMTYP2 (0x1u << 25) /**< \brief (TDES_MR) Countermeasure Type 2 */
#define   TDES_MR_CMTYP2_NO_DUMMY (0x0u << 25) /**< \brief (TDES_MR) Countermeasure type 2 is disabled */
#define   TDES_MR_CMTYP2_DUMMY (0x1u << 25) /**< \brief (TDES_MR) Countermeasure type 2 is enabled */
#define TDES_MR_CMTYP3 (0x1u << 26) /**< \brief (TDES_MR) Countermeasure Type 3 */
#define   TDES_MR_CMTYP3_NO_RESTART (0x0u << 26) /**< \brief (TDES_MR) Countermeasure type 3 is disabled */
#define   TDES_MR_CMTYP3_RESTART (0x1u << 26) /**< \brief (TDES_MR) Countermeasure type 3 is enabled */
#define TDES_MR_CMTYP4 (0x1u << 27) /**< \brief (TDES_MR) Countermeasure Type 4 */
#define   TDES_MR_CMTYP4_NO_IDLECURRENT (0x0u << 27) /**< \brief (TDES_MR) Countermeasure type 4 is disabled */
#define   TDES_MR_CMTYP4_IDLECURRENT (0x1u << 27) /**< \brief (TDES_MR) Countermeasure type 4 is enabled */
#define TDES_MR_CMTYP5 (0x1u << 28) /**< \brief (TDES_MR) Countermeasure Type 5 */
#define   TDES_MR_CMTYP5_NO_ADDACCESS (0x0u << 28) /**< \brief (TDES_MR) Countermeasure type 5 is disabled */
#define   TDES_MR_CMTYP5_ADDACCESS (0x1u << 28) /**< \brief (TDES_MR) Countermeasure type 5 is enabled */
#define TDES_MR_CMTYP6 (0x1u << 29) /**< \brief (TDES_MR) Countermeasure Type 6 */
#define   TDES_MR_CMTYP6_NO_UNIFORM (0x0u << 29) /**< \brief (TDES_MR) Countermeasure type 6 is disabled */
#define   TDES_MR_CMTYP6_UNIFORM (0x1u << 29) /**< \brief (TDES_MR) Countermeasure type 6 is enabled */
/* -------- TDES_IER : (TDES Offset: 0x10) Interrupt Enable Register -------- */
#define TDES_IER_DATRDY (0x1u << 0) /**< \brief (TDES_IER) Data Ready Interrupt Enable */
#define TDES_IER_URAD (0x1u << 8) /**< \brief (TDES_IER) Unspecified Register Access Detection Interrupt Enable */
/* -------- TDES_IDR : (TDES Offset: 0x14) Interrupt Disable Register -------- */
#define TDES_IDR_DATRDY (0x1u << 0) /**< \brief (TDES_IDR) Data Ready Interrupt Disable */
#define TDES_IDR_URAD (0x1u << 8) /**< \brief (TDES_IDR) Unspecified Register Access Detection Interrupt Disable */
/* -------- TDES_IMR : (TDES Offset: 0x18) Interrupt Mask Register -------- */
#define TDES_IMR_DATRDY (0x1u << 0) /**< \brief (TDES_IMR) Data Ready Interrupt Mask */
#define TDES_IMR_URAD (0x1u << 8) /**< \brief (TDES_IMR) Unspecified Register Access Detection Interrupt Mask */
/* -------- TDES_ISR : (TDES Offset: 0x1C) Interrupt Status Register -------- */
#define TDES_ISR_DATRDY (0x1u << 0) /**< \brief (TDES_ISR) Data Ready */
#define TDES_ISR_URAD (0x1u << 8) /**< \brief (TDES_ISR) Unspecified Register Access Detection Status */
#define TDES_ISR_URAT_Pos 12
#define TDES_ISR_URAT_Msk (0x3u << TDES_ISR_URAT_Pos) /**< \brief (TDES_ISR) Unspecified Register Access */
#define   TDES_ISR_URAT_IDR_WR_PROCESSING (0x0u << 12) /**< \brief (TDES_ISR) Input Data Register written during the data processing when SMOD=0x2 mode. */
#define   TDES_ISR_URAT_ODR_RD_PROCESSING (0x1u << 12) /**< \brief (TDES_ISR) Output Data Register read during the data processing. */
#define   TDES_ISR_URAT_MR_WR_PROCESSING (0x2u << 12) /**< \brief (TDES_ISR) Mode Register written during the data processing. */
#define   TDES_ISR_URAT_WOR_RD_ACCESS (0x3u << 12) /**< \brief (TDES_ISR) Write-only register read access. */
/* -------- TDES_KEY1WR[2] : (TDES Offset: 0x20) Key 1 Word Register -------- */
#define TDES_KEY1WR_KEY1W_Pos 0
#define TDES_KEY1WR_KEY1W_Msk (0xffffffffu << TDES_KEY1WR_KEY1W_Pos) /**< \brief (TDES_KEY1WR[2]) Key 1 Word */
#define TDES_KEY1WR_KEY1W(value) ((TDES_KEY1WR_KEY1W_Msk & ((value) << TDES_KEY1WR_KEY1W_Pos)))
/* -------- TDES_KEY2WR[2] : (TDES Offset: 0x28) Key 2 Word Register -------- */
#define TDES_KEY2WR_KEY2W_Pos 0
#define TDES_KEY2WR_KEY2W_Msk (0xffffffffu << TDES_KEY2WR_KEY2W_Pos) /**< \brief (TDES_KEY2WR[2]) Key 2 Word */
#define TDES_KEY2WR_KEY2W(value) ((TDES_KEY2WR_KEY2W_Msk & ((value) << TDES_KEY2WR_KEY2W_Pos)))
/* -------- TDES_KEY3WR[2] : (TDES Offset: 0x30) Key 3 Word Register -------- */
#define TDES_KEY3WR_KEY3W_Pos 0
#define TDES_KEY3WR_KEY3W_Msk (0xffffffffu << TDES_KEY3WR_KEY3W_Pos) /**< \brief (TDES_KEY3WR[2]) Key 3 Word */
#define TDES_KEY3WR_KEY3W(value) ((TDES_KEY3WR_KEY3W_Msk & ((value) << TDES_KEY3WR_KEY3W_Pos)))
/* -------- TDES_IDATAR[2] : (TDES Offset: 0x40) Input Data Register -------- */
#define TDES_IDATAR_IDATA_Pos 0
#define TDES_IDATAR_IDATA_Msk (0xffffffffu << TDES_IDATAR_IDATA_Pos) /**< \brief (TDES_IDATAR[2]) Input Data */
#define TDES_IDATAR_IDATA(value) ((TDES_IDATAR_IDATA_Msk & ((value) << TDES_IDATAR_IDATA_Pos)))
/* -------- TDES_ODATAR[2] : (TDES Offset: 0x50) Output Data Register -------- */
#define TDES_ODATAR_ODATA_Pos 0
#define TDES_ODATAR_ODATA_Msk (0xffffffffu << TDES_ODATAR_ODATA_Pos) /**< \brief (TDES_ODATAR[2]) Output Data */
/* -------- TDES_IVR[2] : (TDES Offset: 0x60) Initialization Vector Register -------- */
#define TDES_IVR_IV_Pos 0
#define TDES_IVR_IV_Msk (0xffffffffu << TDES_IVR_IV_Pos) /**< \brief (TDES_IVR[2]) Initialization Vector */
#define TDES_IVR_IV(value) ((TDES_IVR_IV_Msk & ((value) << TDES_IVR_IV_Pos)))
/* -------- TDES_XTEA_RNDR : (TDES Offset: 0x70) XTEA Rounds Register -------- */
#define TDES_XTEA_RNDR_XTEA_RNDS_Pos 0
#define TDES_XTEA_RNDR_XTEA_RNDS_Msk (0x3fu << TDES_XTEA_RNDR_XTEA_RNDS_Pos) /**< \brief (TDES_XTEA_RNDR) Number of Rounds */
#define TDES_XTEA_RNDR_XTEA_RNDS(value) ((TDES_XTEA_RNDR_XTEA_RNDS_Msk & ((value) << TDES_XTEA_RNDR_XTEA_RNDS_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR True Random Number Generator */
/* ============================================================================= */
/** \addtogroup SAMA5D4_TRNG True Random Number Generator */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Trng hardware registers */
typedef struct {
  __O uint32_t TRNG_CR;       /**< \brief (Trng Offset: 0x00) Control Register */
  __I uint32_t Reserved1[3];
  __O uint32_t TRNG_IER;      /**< \brief (Trng Offset: 0x10) Interrupt Enable Register */
  __O uint32_t TRNG_IDR;      /**< \brief (Trng Offset: 0x14) Interrupt Disable Register */
  __I uint32_t TRNG_IMR;      /**< \brief (Trng Offset: 0x18) Interrupt Mask Register */
  __I uint32_t TRNG_ISR;      /**< \brief (Trng Offset: 0x1C) Interrupt Status Register */
  __I uint32_t Reserved2[12];
  __I uint32_t TRNG_ODATA;    /**< \brief (Trng Offset: 0x50) Output Data Register */
} Trng;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- TRNG_CR : (TRNG Offset: 0x00) Control Register -------- */
#define TRNG_CR_ENABLE (0x1u << 0) /**< \brief (TRNG_CR) Enables the TRNG to provide random values */
#define TRNG_CR_KEY_Pos 8
#define TRNG_CR_KEY_Msk (0xffffffu << TRNG_CR_KEY_Pos) /**< \brief (TRNG_CR) Security Key */
#define TRNG_CR_KEY(value) ((TRNG_CR_KEY_Msk & ((value) << TRNG_CR_KEY_Pos)))
/* -------- TRNG_IER : (TRNG Offset: 0x10) Interrupt Enable Register -------- */
#define TRNG_IER_DATRDY (0x1u << 0) /**< \brief (TRNG_IER) Data Ready Interrupt Enable */
/* -------- TRNG_IDR : (TRNG Offset: 0x14) Interrupt Disable Register -------- */
#define TRNG_IDR_DATRDY (0x1u << 0) /**< \brief (TRNG_IDR) Data Ready Interrupt Disable */
/* -------- TRNG_IMR : (TRNG Offset: 0x18) Interrupt Mask Register -------- */
#define TRNG_IMR_DATRDY (0x1u << 0) /**< \brief (TRNG_IMR) Data Ready Interrupt Mask */
/* -------- TRNG_ISR : (TRNG Offset: 0x1C) Interrupt Status Register -------- */
#define TRNG_ISR_DATRDY (0x1u << 0) /**< \brief (TRNG_ISR) Data Ready */
/* -------- TRNG_ODATA : (TRNG Offset: 0x50) Output Data Register -------- */
#define TRNG_ODATA_ODATA_Pos 0
#define TRNG_ODATA_ODATA_Msk (0xffffffffu << TRNG_ODATA_ODATA_Pos) /**< \brief (TRNG_ODATA) Output Data */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Two-wire Interface */
/* ============================================================================= */
/** \addtogroup SAMA5D4_TWI Two-wire Interface */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Twi hardware registers */
typedef struct {
  __O  uint32_t TWI_CR;        /**< \brief (Twi Offset: 0x00) Control Register */
  __IO uint32_t TWI_MMR;       /**< \brief (Twi Offset: 0x04) Master Mode Register */
  __IO uint32_t TWI_SMR;       /**< \brief (Twi Offset: 0x08) Slave Mode Register */
  __IO uint32_t TWI_IADR;      /**< \brief (Twi Offset: 0x0C) Internal Address Register */
  __IO uint32_t TWI_CWGR;      /**< \brief (Twi Offset: 0x10) Clock Waveform Generator Register */
  __I  uint32_t Reserved1[3];
  __I  uint32_t TWI_SR;        /**< \brief (Twi Offset: 0x20) Status Register */
  __O  uint32_t TWI_IER;       /**< \brief (Twi Offset: 0x24) Interrupt Enable Register */
  __O  uint32_t TWI_IDR;       /**< \brief (Twi Offset: 0x28) Interrupt Disable Register */
  __I  uint32_t TWI_IMR;       /**< \brief (Twi Offset: 0x2C) Interrupt Mask Register */
  __I  uint32_t TWI_RHR;       /**< \brief (Twi Offset: 0x30) Receive Holding Register */
  __O  uint32_t TWI_THR;       /**< \brief (Twi Offset: 0x34) Transmit Holding Register */
  __I  uint32_t Reserved2[43];
  __IO uint32_t TWI_WPMR;      /**< \brief (Twi Offset: 0xE4) Protection Mode Register */
  __I  uint32_t TWI_WPSR;      /**< \brief (Twi Offset: 0xE8) Protection Status Register */
} Twi;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- TWI_CR : (TWI Offset: 0x00) Control Register -------- */
#define TWI_CR_START (0x1u << 0) /**< \brief (TWI_CR) Send a START Condition */
#define TWI_CR_STOP (0x1u << 1) /**< \brief (TWI_CR) Send a STOP Condition */
#define TWI_CR_MSEN (0x1u << 2) /**< \brief (TWI_CR) TWI Master Mode Enabled */
#define TWI_CR_MSDIS (0x1u << 3) /**< \brief (TWI_CR) TWI Master Mode Disabled */
#define TWI_CR_SVEN (0x1u << 4) /**< \brief (TWI_CR) TWI Slave Mode Enabled */
#define TWI_CR_SVDIS (0x1u << 5) /**< \brief (TWI_CR) TWI Slave Mode Disabled */
#define TWI_CR_SWRST (0x1u << 7) /**< \brief (TWI_CR) Software Reset */
/* -------- TWI_MMR : (TWI Offset: 0x04) Master Mode Register -------- */
#define TWI_MMR_IADRSZ_Pos 8
#define TWI_MMR_IADRSZ_Msk (0x3u << TWI_MMR_IADRSZ_Pos) /**< \brief (TWI_MMR) Internal Device Address Size */
#define   TWI_MMR_IADRSZ_NONE (0x0u << 8) /**< \brief (TWI_MMR) No internal device address */
#define   TWI_MMR_IADRSZ_1_BYTE (0x1u << 8) /**< \brief (TWI_MMR) One-byte internal device address */
#define   TWI_MMR_IADRSZ_2_BYTE (0x2u << 8) /**< \brief (TWI_MMR) Two-byte internal device address */
#define   TWI_MMR_IADRSZ_3_BYTE (0x3u << 8) /**< \brief (TWI_MMR) Three-byte internal device address */
#define TWI_MMR_MREAD (0x1u << 12) /**< \brief (TWI_MMR) Master Read Direction */
#define TWI_MMR_DADR_Pos 16
#define TWI_MMR_DADR_Msk (0x7fu << TWI_MMR_DADR_Pos) /**< \brief (TWI_MMR) Device Address */
#define TWI_MMR_DADR(value) ((TWI_MMR_DADR_Msk & ((value) << TWI_MMR_DADR_Pos)))
/* -------- TWI_SMR : (TWI Offset: 0x08) Slave Mode Register -------- */
#define TWI_SMR_SADR_Pos 16
#define TWI_SMR_SADR_Msk (0x7fu << TWI_SMR_SADR_Pos) /**< \brief (TWI_SMR) Slave Address */
#define TWI_SMR_SADR(value) ((TWI_SMR_SADR_Msk & ((value) << TWI_SMR_SADR_Pos)))
/* -------- TWI_IADR : (TWI Offset: 0x0C) Internal Address Register -------- */
#define TWI_IADR_IADR_Pos 0
#define TWI_IADR_IADR_Msk (0xffffffu << TWI_IADR_IADR_Pos) /**< \brief (TWI_IADR) Internal Address */
#define TWI_IADR_IADR(value) ((TWI_IADR_IADR_Msk & ((value) << TWI_IADR_IADR_Pos)))
/* -------- TWI_CWGR : (TWI Offset: 0x10) Clock Waveform Generator Register -------- */
#define TWI_CWGR_CLDIV_Pos 0
#define TWI_CWGR_CLDIV_Msk (0xffu << TWI_CWGR_CLDIV_Pos) /**< \brief (TWI_CWGR) Clock Low Divider */
#define TWI_CWGR_CLDIV(value) ((TWI_CWGR_CLDIV_Msk & ((value) << TWI_CWGR_CLDIV_Pos)))
#define TWI_CWGR_CHDIV_Pos 8
#define TWI_CWGR_CHDIV_Msk (0xffu << TWI_CWGR_CHDIV_Pos) /**< \brief (TWI_CWGR) Clock High Divider */
#define TWI_CWGR_CHDIV(value) ((TWI_CWGR_CHDIV_Msk & ((value) << TWI_CWGR_CHDIV_Pos)))
#define TWI_CWGR_CKDIV_Pos 16
#define TWI_CWGR_CKDIV_Msk (0x7u << TWI_CWGR_CKDIV_Pos) /**< \brief (TWI_CWGR) Clock Divider */
#define TWI_CWGR_CKDIV(value) ((TWI_CWGR_CKDIV_Msk & ((value) << TWI_CWGR_CKDIV_Pos)))
#define TWI_CWGR_HOLD_Pos 24
#define TWI_CWGR_HOLD_Msk (0x1fu << TWI_CWGR_HOLD_Pos) /**< \brief (TWI_CWGR) TWD Hold Time versus TWCK falling */
#define TWI_CWGR_HOLD(value) ((TWI_CWGR_HOLD_Msk & ((value) << TWI_CWGR_HOLD_Pos)))
/* -------- TWI_SR : (TWI Offset: 0x20) Status Register -------- */
#define TWI_SR_TXCOMP (0x1u << 0) /**< \brief (TWI_SR) Transmission Completed (automatically set / reset) */
#define TWI_SR_RXRDY (0x1u << 1) /**< \brief (TWI_SR) Receive Holding Register Ready (automatically set / reset) */
#define TWI_SR_TXRDY (0x1u << 2) /**< \brief (TWI_SR) Transmit Holding Register Ready (automatically set / reset) */
#define TWI_SR_SVREAD (0x1u << 3) /**< \brief (TWI_SR) Slave Read (automatically set / reset) */
#define TWI_SR_SVACC (0x1u << 4) /**< \brief (TWI_SR) Slave Access (automatically set / reset) */
#define TWI_SR_GACC (0x1u << 5) /**< \brief (TWI_SR) General Call Access (clear on read) */
#define TWI_SR_OVRE (0x1u << 6) /**< \brief (TWI_SR) Overrun Error (clear on read) */
#define TWI_SR_NACK (0x1u << 8) /**< \brief (TWI_SR) Not Acknowledged (clear on read) */
#define TWI_SR_ARBLST (0x1u << 9) /**< \brief (TWI_SR) Arbitration Lost (clear on read) */
#define TWI_SR_SCLWS (0x1u << 10) /**< \brief (TWI_SR) Clock Wait State (automatically set / reset) */
#define TWI_SR_EOSACC (0x1u << 11) /**< \brief (TWI_SR) End Of Slave Access (clear on read) */
/* -------- TWI_IER : (TWI Offset: 0x24) Interrupt Enable Register -------- */
#define TWI_IER_TXCOMP (0x1u << 0) /**< \brief (TWI_IER) Transmission Completed Interrupt Enable */
#define TWI_IER_RXRDY (0x1u << 1) /**< \brief (TWI_IER) Receive Holding Register Ready Interrupt Enable */
#define TWI_IER_TXRDY (0x1u << 2) /**< \brief (TWI_IER) Transmit Holding Register Ready Interrupt Enable */
#define TWI_IER_SVACC (0x1u << 4) /**< \brief (TWI_IER) Slave Access Interrupt Enable */
#define TWI_IER_GACC (0x1u << 5) /**< \brief (TWI_IER) General Call Access Interrupt Enable */
#define TWI_IER_OVRE (0x1u << 6) /**< \brief (TWI_IER) Overrun Error Interrupt Enable */
#define TWI_IER_NACK (0x1u << 8) /**< \brief (TWI_IER) Not Acknowledge Interrupt Enable */
#define TWI_IER_ARBLST (0x1u << 9) /**< \brief (TWI_IER) Arbitration Lost Interrupt Enable */
#define TWI_IER_SCL_WS (0x1u << 10) /**< \brief (TWI_IER) Clock Wait State Interrupt Enable */
#define TWI_IER_EOSACC (0x1u << 11) /**< \brief (TWI_IER) End Of Slave Access Interrupt Enable */
/* -------- TWI_IDR : (TWI Offset: 0x28) Interrupt Disable Register -------- */
#define TWI_IDR_TXCOMP (0x1u << 0) /**< \brief (TWI_IDR) Transmission Completed Interrupt Disable */
#define TWI_IDR_RXRDY (0x1u << 1) /**< \brief (TWI_IDR) Receive Holding Register Ready Interrupt Disable */
#define TWI_IDR_TXRDY (0x1u << 2) /**< \brief (TWI_IDR) Transmit Holding Register Ready Interrupt Disable */
#define TWI_IDR_SVACC (0x1u << 4) /**< \brief (TWI_IDR) Slave Access Interrupt Disable */
#define TWI_IDR_GACC (0x1u << 5) /**< \brief (TWI_IDR) General Call Access Interrupt Disable */
#define TWI_IDR_OVRE (0x1u << 6) /**< \brief (TWI_IDR) Overrun Error Interrupt Disable */
#define TWI_IDR_NACK (0x1u << 8) /**< \brief (TWI_IDR) Not Acknowledge Interrupt Disable */
#define TWI_IDR_ARBLST (0x1u << 9) /**< \brief (TWI_IDR) Arbitration Lost Interrupt Disable */
#define TWI_IDR_SCL_WS (0x1u << 10) /**< \brief (TWI_IDR) Clock Wait State Interrupt Disable */
#define TWI_IDR_EOSACC (0x1u << 11) /**< \brief (TWI_IDR) End Of Slave Access Interrupt Disable */
/* -------- TWI_IMR : (TWI Offset: 0x2C) Interrupt Mask Register -------- */
#define TWI_IMR_TXCOMP (0x1u << 0) /**< \brief (TWI_IMR) Transmission Completed Interrupt Mask */
#define TWI_IMR_RXRDY (0x1u << 1) /**< \brief (TWI_IMR) Receive Holding Register Ready Interrupt Mask */
#define TWI_IMR_TXRDY (0x1u << 2) /**< \brief (TWI_IMR) Transmit Holding Register Ready Interrupt Mask */
#define TWI_IMR_SVACC (0x1u << 4) /**< \brief (TWI_IMR) Slave Access Interrupt Mask */
#define TWI_IMR_GACC (0x1u << 5) /**< \brief (TWI_IMR) General Call Access Interrupt Mask */
#define TWI_IMR_OVRE (0x1u << 6) /**< \brief (TWI_IMR) Overrun Error Interrupt Mask */
#define TWI_IMR_NACK (0x1u << 8) /**< \brief (TWI_IMR) Not Acknowledge Interrupt Mask */
#define TWI_IMR_ARBLST (0x1u << 9) /**< \brief (TWI_IMR) Arbitration Lost Interrupt Mask */
#define TWI_IMR_SCL_WS (0x1u << 10) /**< \brief (TWI_IMR) Clock Wait State Interrupt Mask */
#define TWI_IMR_EOSACC (0x1u << 11) /**< \brief (TWI_IMR) End Of Slave Access Interrupt Mask */
/* -------- TWI_RHR : (TWI Offset: 0x30) Receive Holding Register -------- */
#define TWI_RHR_RXDATA_Pos 0
#define TWI_RHR_RXDATA_Msk (0xffu << TWI_RHR_RXDATA_Pos) /**< \brief (TWI_RHR) Master or Slave Receive Holding Data */
/* -------- TWI_THR : (TWI Offset: 0x34) Transmit Holding Register -------- */
#define TWI_THR_TXDATA_Pos 0
#define TWI_THR_TXDATA_Msk (0xffu << TWI_THR_TXDATA_Pos) /**< \brief (TWI_THR) Master or Slave Transmit Holding Data */
#define TWI_THR_TXDATA(value) ((TWI_THR_TXDATA_Msk & ((value) << TWI_THR_TXDATA_Pos)))
/* -------- TWI_WPMR : (TWI Offset: 0xE4) Protection Mode Register -------- */
#define TWI_WPMR_WPEN (0x1u << 0) /**< \brief (TWI_WPMR) Write Protect Enable */
#define TWI_WPMR_WPKEY_Pos 8
#define TWI_WPMR_WPKEY_Msk (0xffffffu << TWI_WPMR_WPKEY_Pos) /**< \brief (TWI_WPMR) Write Protect Key */
#define   TWI_WPMR_WPKEY_PASSWD (0x545749u << 8) /**< \brief (TWI_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0 */
/* -------- TWI_WPSR : (TWI Offset: 0xE8) Protection Status Register -------- */
#define TWI_WPSR_WPVS (0x1u << 0) /**< \brief (TWI_WPSR) Write Protect Violation Status */
#define TWI_WPSR_WPVSRC_Pos 8
#define TWI_WPSR_WPVSRC_Msk (0xffffffu << TWI_WPSR_WPVSRC_Pos) /**< \brief (TWI_WPSR) Write Protect Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Universal Asynchronous Receiver Transmitter */
/* ============================================================================= */
/** \addtogroup SAMA5D4_UART Universal Asynchronous Receiver Transmitter */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Uart hardware registers */
typedef struct {
  __O  uint32_t UART_CR;   /**< \brief (Uart Offset: 0x0000) Control Register */
  __IO uint32_t UART_MR;   /**< \brief (Uart Offset: 0x0004) Mode Register */
  __O  uint32_t UART_IER;  /**< \brief (Uart Offset: 0x0008) Interrupt Enable Register */
  __O  uint32_t UART_IDR;  /**< \brief (Uart Offset: 0x000C) Interrupt Disable Register */
  __I  uint32_t UART_IMR;  /**< \brief (Uart Offset: 0x0010) Interrupt Mask Register */
  __I  uint32_t UART_SR;   /**< \brief (Uart Offset: 0x0014) Status Register */
  __I  uint32_t UART_RHR;  /**< \brief (Uart Offset: 0x0018) Receive Holding Register */
  __O  uint32_t UART_THR;  /**< \brief (Uart Offset: 0x001C) Transmit Holding Register */
  __IO uint32_t UART_BRGR; /**< \brief (Uart Offset: 0x0020) Baud Rate Generator Register */
} Uart;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- UART_CR : (UART Offset: 0x0000) Control Register -------- */
#define UART_CR_RSTRX (0x1u << 2) /**< \brief (UART_CR) Reset Receiver */
#define UART_CR_RSTTX (0x1u << 3) /**< \brief (UART_CR) Reset Transmitter */
#define UART_CR_RXEN (0x1u << 4) /**< \brief (UART_CR) Receiver Enable */
#define UART_CR_RXDIS (0x1u << 5) /**< \brief (UART_CR) Receiver Disable */
#define UART_CR_TXEN (0x1u << 6) /**< \brief (UART_CR) Transmitter Enable */
#define UART_CR_TXDIS (0x1u << 7) /**< \brief (UART_CR) Transmitter Disable */
#define UART_CR_RSTSTA (0x1u << 8) /**< \brief (UART_CR) Reset Status Bits */
/* -------- UART_MR : (UART Offset: 0x0004) Mode Register -------- */
#define UART_MR_PAR_Pos 9
#define UART_MR_PAR_Msk (0x7u << UART_MR_PAR_Pos) /**< \brief (UART_MR) Parity Type */
#define   UART_MR_PAR_EVEN (0x0u << 9) /**< \brief (UART_MR) Even Parity */
#define   UART_MR_PAR_ODD (0x1u << 9) /**< \brief (UART_MR) Odd Parity */
#define   UART_MR_PAR_SPACE (0x2u << 9) /**< \brief (UART_MR) Space: parity forced to 0 */
#define   UART_MR_PAR_MARK (0x3u << 9) /**< \brief (UART_MR) Mark: parity forced to 1 */
#define   UART_MR_PAR_NO (0x4u << 9) /**< \brief (UART_MR) No Parity */
#define UART_MR_CHMODE_Pos 14
#define UART_MR_CHMODE_Msk (0x3u << UART_MR_CHMODE_Pos) /**< \brief (UART_MR) Channel Mode */
#define   UART_MR_CHMODE_NORMAL (0x0u << 14) /**< \brief (UART_MR) Normal Mode */
#define   UART_MR_CHMODE_AUTOMATIC (0x1u << 14) /**< \brief (UART_MR) Automatic Echo */
#define   UART_MR_CHMODE_LOCAL_LOOPBACK (0x2u << 14) /**< \brief (UART_MR) Local Loopback */
#define   UART_MR_CHMODE_REMOTE_LOOPBACK (0x3u << 14) /**< \brief (UART_MR) Remote Loopback */
/* -------- UART_IER : (UART Offset: 0x0008) Interrupt Enable Register -------- */
#define UART_IER_RXRDY (0x1u << 0) /**< \brief (UART_IER) Enable RXRDY Interrupt */
#define UART_IER_TXRDY (0x1u << 1) /**< \brief (UART_IER) Enable TXRDY Interrupt */
#define UART_IER_OVRE (0x1u << 5) /**< \brief (UART_IER) Enable Overrun Error Interrupt */
#define UART_IER_FRAME (0x1u << 6) /**< \brief (UART_IER) Enable Framing Error Interrupt */
#define UART_IER_PARE (0x1u << 7) /**< \brief (UART_IER) Enable Parity Error Interrupt */
#define UART_IER_TXEMPTY (0x1u << 9) /**< \brief (UART_IER) Enable TXEMPTY Interrupt */
/* -------- UART_IDR : (UART Offset: 0x000C) Interrupt Disable Register -------- */
#define UART_IDR_RXRDY (0x1u << 0) /**< \brief (UART_IDR) Disable RXRDY Interrupt */
#define UART_IDR_TXRDY (0x1u << 1) /**< \brief (UART_IDR) Disable TXRDY Interrupt */
#define UART_IDR_OVRE (0x1u << 5) /**< \brief (UART_IDR) Disable Overrun Error Interrupt */
#define UART_IDR_FRAME (0x1u << 6) /**< \brief (UART_IDR) Disable Framing Error Interrupt */
#define UART_IDR_PARE (0x1u << 7) /**< \brief (UART_IDR) Disable Parity Error Interrupt */
#define UART_IDR_TXEMPTY (0x1u << 9) /**< \brief (UART_IDR) Disable TXEMPTY Interrupt */
/* -------- UART_IMR : (UART Offset: 0x0010) Interrupt Mask Register -------- */
#define UART_IMR_RXRDY (0x1u << 0) /**< \brief (UART_IMR) Mask RXRDY Interrupt */
#define UART_IMR_TXRDY (0x1u << 1) /**< \brief (UART_IMR) Disable TXRDY Interrupt */
#define UART_IMR_OVRE (0x1u << 5) /**< \brief (UART_IMR) Mask Overrun Error Interrupt */
#define UART_IMR_FRAME (0x1u << 6) /**< \brief (UART_IMR) Mask Framing Error Interrupt */
#define UART_IMR_PARE (0x1u << 7) /**< \brief (UART_IMR) Mask Parity Error Interrupt */
#define UART_IMR_TXEMPTY (0x1u << 9) /**< \brief (UART_IMR) Mask TXEMPTY Interrupt */
/* -------- UART_SR : (UART Offset: 0x0014) Status Register -------- */
#define UART_SR_RXRDY (0x1u << 0) /**< \brief (UART_SR) Receiver Ready */
#define UART_SR_TXRDY (0x1u << 1) /**< \brief (UART_SR) Transmitter Ready */
#define UART_SR_OVRE (0x1u << 5) /**< \brief (UART_SR) Overrun Error */
#define UART_SR_FRAME (0x1u << 6) /**< \brief (UART_SR) Framing Error */
#define UART_SR_PARE (0x1u << 7) /**< \brief (UART_SR) Parity Error */
#define UART_SR_TXEMPTY (0x1u << 9) /**< \brief (UART_SR) Transmitter Empty */
/* -------- UART_RHR : (UART Offset: 0x0018) Receive Holding Register -------- */
#define UART_RHR_RXCHR_Pos 0
#define UART_RHR_RXCHR_Msk (0xffu << UART_RHR_RXCHR_Pos) /**< \brief (UART_RHR) Received Character */
/* -------- UART_THR : (UART Offset: 0x001C) Transmit Holding Register -------- */
#define UART_THR_TXCHR_Pos 0
#define UART_THR_TXCHR_Msk (0xffu << UART_THR_TXCHR_Pos) /**< \brief (UART_THR) Character to be Transmitted */
#define UART_THR_TXCHR(value) ((UART_THR_TXCHR_Msk & ((value) << UART_THR_TXCHR_Pos)))
/* -------- UART_BRGR : (UART Offset: 0x0020) Baud Rate Generator Register -------- */
#define UART_BRGR_CD_Pos 0
#define UART_BRGR_CD_Msk (0xffffu << UART_BRGR_CD_Pos) /**< \brief (UART_BRGR) Clock Divisor */
#define UART_BRGR_CD(value) ((UART_BRGR_CD_Msk & ((value) << UART_BRGR_CD_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR USB High Speed Device Port */
/* ============================================================================= */
/** \addtogroup SAMA5D4_UDPHS USB High Speed Device Port */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief UdphsDma hardware registers */
typedef struct {
  __IO uint32_t UDPHS_DMANXTDSC;  /**< \brief (UdphsDma Offset: 0x0) UDPHS DMA Next Descriptor Address Register */
  __IO uint32_t UDPHS_DMAADDRESS; /**< \brief (UdphsDma Offset: 0x4) UDPHS DMA Channel Address Register */
  __IO uint32_t UDPHS_DMACONTROL; /**< \brief (UdphsDma Offset: 0x8) UDPHS DMA Channel Control Register */
  __IO uint32_t UDPHS_DMASTATUS;  /**< \brief (UdphsDma Offset: 0xC) UDPHS DMA Channel Status Register */
} UdphsDma;
/** \brief UdphsEpt hardware registers */
typedef struct {
  __IO uint32_t UDPHS_EPTCFG;    /**< \brief (UdphsEpt Offset: 0x0) UDPHS Endpoint Configuration Register */
  __O  uint32_t UDPHS_EPTCTLENB; /**< \brief (UdphsEpt Offset: 0x4) UDPHS Endpoint Control Enable Register */
  __O  uint32_t UDPHS_EPTCTLDIS; /**< \brief (UdphsEpt Offset: 0x8) UDPHS Endpoint Control Disable Register */
  __I  uint32_t UDPHS_EPTCTL;    /**< \brief (UdphsEpt Offset: 0xC) UDPHS Endpoint Control Register */
  __I  uint32_t Reserved1[1];
  __O  uint32_t UDPHS_EPTSETSTA; /**< \brief (UdphsEpt Offset: 0x14) UDPHS Endpoint Set Status Register */
  __O  uint32_t UDPHS_EPTCLRSTA; /**< \brief (UdphsEpt Offset: 0x18) UDPHS Endpoint Clear Status Register */
  __I  uint32_t UDPHS_EPTSTA;    /**< \brief (UdphsEpt Offset: 0x1C) UDPHS Endpoint Status Register */
} UdphsEpt;
/** \brief Udphs hardware registers */
#define UDPHSEPT_NUMBER 16
#define UDPHSDMA_NUMBER 7
typedef struct {
  __IO uint32_t UDPHS_CTRL;                 /**< \brief (Udphs Offset: 0x00) UDPHS Control Register */
  __I  uint32_t UDPHS_FNUM;                 /**< \brief (Udphs Offset: 0x04) UDPHS Frame Number Register */
  __I  uint32_t Reserved1[2];
  __IO uint32_t UDPHS_IEN;                  /**< \brief (Udphs Offset: 0x10) UDPHS Interrupt Enable Register */
  __I  uint32_t UDPHS_INTSTA;               /**< \brief (Udphs Offset: 0x14) UDPHS Interrupt Status Register */
  __O  uint32_t UDPHS_CLRINT;               /**< \brief (Udphs Offset: 0x18) UDPHS Clear Interrupt Register */
  __O  uint32_t UDPHS_EPTRST;               /**< \brief (Udphs Offset: 0x1C) UDPHS Endpoints Reset Register */
  __I  uint32_t Reserved2[48];
  __IO uint32_t UDPHS_TST;                  /**< \brief (Udphs Offset: 0xE0) UDPHS Test Register */
  __I  uint32_t Reserved3[7];
       UdphsEpt UDPHS_EPT[UDPHSEPT_NUMBER]; /**< \brief (Udphs Offset: 0x100) endpoint = 0 .. 15 */
       UdphsDma UDPHS_DMA[UDPHSDMA_NUMBER]; /**< \brief (Udphs Offset: 0x300) channel = 0 .. 6 */
} Udphs;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- UDPHS_CTRL : (UDPHS Offset: 0x00) UDPHS Control Register -------- */
#define UDPHS_CTRL_DEV_ADDR_Pos 0
#define UDPHS_CTRL_DEV_ADDR_Msk (0x7fu << UDPHS_CTRL_DEV_ADDR_Pos) /**< \brief (UDPHS_CTRL) UDPHS Address */
#define UDPHS_CTRL_DEV_ADDR(value) ((UDPHS_CTRL_DEV_ADDR_Msk & ((value) << UDPHS_CTRL_DEV_ADDR_Pos)))
#define UDPHS_CTRL_FADDR_EN (0x1u << 7) /**< \brief (UDPHS_CTRL) Function Address Enable */
#define UDPHS_CTRL_EN_UDPHS (0x1u << 8) /**< \brief (UDPHS_CTRL) UDPHS Enable */
#define UDPHS_CTRL_DETACH (0x1u << 9) /**< \brief (UDPHS_CTRL) Detach Command */
#define UDPHS_CTRL_REWAKEUP (0x1u << 10) /**< \brief (UDPHS_CTRL) Send Remote Wake Up */
#define UDPHS_CTRL_PULLD_DIS (0x1u << 11) /**< \brief (UDPHS_CTRL) Pull-Down Disable */
/* -------- UDPHS_FNUM : (UDPHS Offset: 0x04) UDPHS Frame Number Register -------- */
#define UDPHS_FNUM_MICRO_FRAME_NUM_Pos 0
#define UDPHS_FNUM_MICRO_FRAME_NUM_Msk (0x7u << UDPHS_FNUM_MICRO_FRAME_NUM_Pos) /**< \brief (UDPHS_FNUM) Microframe Number */
#define UDPHS_FNUM_FRAME_NUMBER_Pos 3
#define UDPHS_FNUM_FRAME_NUMBER_Msk (0x7ffu << UDPHS_FNUM_FRAME_NUMBER_Pos) /**< \brief (UDPHS_FNUM) Frame Number as defined in the Packet Field Formats */
#define UDPHS_FNUM_FNUM_ERR (0x1u << 31) /**< \brief (UDPHS_FNUM) Frame Number CRC Error */
/* -------- UDPHS_IEN : (UDPHS Offset: 0x10) UDPHS Interrupt Enable Register -------- */
#define UDPHS_IEN_DET_SUSPD (0x1u << 1) /**< \brief (UDPHS_IEN) Suspend Interrupt Enable */
#define UDPHS_IEN_MICRO_SOF (0x1u << 2) /**< \brief (UDPHS_IEN) Micro-SOF Interrupt Enable */
#define UDPHS_IEN_INT_SOF (0x1u << 3) /**< \brief (UDPHS_IEN) SOF Interrupt Enable */
#define UDPHS_IEN_ENDRESET (0x1u << 4) /**< \brief (UDPHS_IEN) End Of Reset Interrupt Enable */
#define UDPHS_IEN_WAKE_UP (0x1u << 5) /**< \brief (UDPHS_IEN) Wake Up CPU Interrupt Enable */
#define UDPHS_IEN_ENDOFRSM (0x1u << 6) /**< \brief (UDPHS_IEN) End Of Resume Interrupt Enable */
#define UDPHS_IEN_UPSTR_RES (0x1u << 7) /**< \brief (UDPHS_IEN) Upstream Resume Interrupt Enable */
#define UDPHS_IEN_EPT_0 (0x1u << 8) /**< \brief (UDPHS_IEN) Endpoint 0 Interrupt Enable */
#define UDPHS_IEN_EPT_1 (0x1u << 9) /**< \brief (UDPHS_IEN) Endpoint 1 Interrupt Enable */
#define UDPHS_IEN_EPT_2 (0x1u << 10) /**< \brief (UDPHS_IEN) Endpoint 2 Interrupt Enable */
#define UDPHS_IEN_EPT_3 (0x1u << 11) /**< \brief (UDPHS_IEN) Endpoint 3 Interrupt Enable */
#define UDPHS_IEN_EPT_4 (0x1u << 12) /**< \brief (UDPHS_IEN) Endpoint 4 Interrupt Enable */
#define UDPHS_IEN_EPT_5 (0x1u << 13) /**< \brief (UDPHS_IEN) Endpoint 5 Interrupt Enable */
#define UDPHS_IEN_EPT_6 (0x1u << 14) /**< \brief (UDPHS_IEN) Endpoint 6 Interrupt Enable */
#define UDPHS_IEN_EPT_7 (0x1u << 15) /**< \brief (UDPHS_IEN) Endpoint 7 Interrupt Enable */
#define UDPHS_IEN_EPT_8 (0x1u << 16) /**< \brief (UDPHS_IEN) Endpoint 8 Interrupt Enable */
#define UDPHS_IEN_EPT_9 (0x1u << 17) /**< \brief (UDPHS_IEN) Endpoint 9 Interrupt Enable */
#define UDPHS_IEN_EPT_10 (0x1u << 18) /**< \brief (UDPHS_IEN) Endpoint 10 Interrupt Enable */
#define UDPHS_IEN_EPT_11 (0x1u << 19) /**< \brief (UDPHS_IEN) Endpoint 11 Interrupt Enable */
#define UDPHS_IEN_EPT_12 (0x1u << 20) /**< \brief (UDPHS_IEN) Endpoint 12 Interrupt Enable */
#define UDPHS_IEN_EPT_13 (0x1u << 21) /**< \brief (UDPHS_IEN) Endpoint 13 Interrupt Enable */
#define UDPHS_IEN_EPT_14 (0x1u << 22) /**< \brief (UDPHS_IEN) Endpoint 14 Interrupt Enable */
#define UDPHS_IEN_EPT_15 (0x1u << 23) /**< \brief (UDPHS_IEN) Endpoint 15 Interrupt Enable */
#define UDPHS_IEN_DMA_1 (0x1u << 25) /**< \brief (UDPHS_IEN) DMA Channel 1 Interrupt Enable */
#define UDPHS_IEN_DMA_2 (0x1u << 26) /**< \brief (UDPHS_IEN) DMA Channel 2 Interrupt Enable */
#define UDPHS_IEN_DMA_3 (0x1u << 27) /**< \brief (UDPHS_IEN) DMA Channel 3 Interrupt Enable */
#define UDPHS_IEN_DMA_4 (0x1u << 28) /**< \brief (UDPHS_IEN) DMA Channel 4 Interrupt Enable */
#define UDPHS_IEN_DMA_5 (0x1u << 29) /**< \brief (UDPHS_IEN) DMA Channel 5 Interrupt Enable */
#define UDPHS_IEN_DMA_6 (0x1u << 30) /**< \brief (UDPHS_IEN) DMA Channel 6 Interrupt Enable */
#define UDPHS_IEN_DMA_7 (0x1u << 31) /**< \brief (UDPHS_IEN) DMA Channel 7 Interrupt Enable */
/* -------- UDPHS_INTSTA : (UDPHS Offset: 0x14) UDPHS Interrupt Status Register -------- */
#define UDPHS_INTSTA_SPEED (0x1u << 0) /**< \brief (UDPHS_INTSTA) Speed Status */
#define UDPHS_INTSTA_DET_SUSPD (0x1u << 1) /**< \brief (UDPHS_INTSTA) Suspend Interrupt */
#define UDPHS_INTSTA_MICRO_SOF (0x1u << 2) /**< \brief (UDPHS_INTSTA) Micro Start Of Frame Interrupt */
#define UDPHS_INTSTA_INT_SOF (0x1u << 3) /**< \brief (UDPHS_INTSTA) Start Of Frame Interrupt */
#define UDPHS_INTSTA_ENDRESET (0x1u << 4) /**< \brief (UDPHS_INTSTA) End Of Reset Interrupt */
#define UDPHS_INTSTA_WAKE_UP (0x1u << 5) /**< \brief (UDPHS_INTSTA) Wake Up CPU Interrupt */
#define UDPHS_INTSTA_ENDOFRSM (0x1u << 6) /**< \brief (UDPHS_INTSTA) End Of Resume Interrupt */
#define UDPHS_INTSTA_UPSTR_RES (0x1u << 7) /**< \brief (UDPHS_INTSTA) Upstream Resume Interrupt */
#define UDPHS_INTSTA_EPT_0 (0x1u << 8) /**< \brief (UDPHS_INTSTA) Endpoint 0 Interrupt */
#define UDPHS_INTSTA_EPT_1 (0x1u << 9) /**< \brief (UDPHS_INTSTA) Endpoint 1 Interrupt */
#define UDPHS_INTSTA_EPT_2 (0x1u << 10) /**< \brief (UDPHS_INTSTA) Endpoint 2 Interrupt */
#define UDPHS_INTSTA_EPT_3 (0x1u << 11) /**< \brief (UDPHS_INTSTA) Endpoint 3 Interrupt */
#define UDPHS_INTSTA_EPT_4 (0x1u << 12) /**< \brief (UDPHS_INTSTA) Endpoint 4 Interrupt */
#define UDPHS_INTSTA_EPT_5 (0x1u << 13) /**< \brief (UDPHS_INTSTA) Endpoint 5 Interrupt */
#define UDPHS_INTSTA_EPT_6 (0x1u << 14) /**< \brief (UDPHS_INTSTA) Endpoint 6 Interrupt */
#define UDPHS_INTSTA_EPT_7 (0x1u << 15) /**< \brief (UDPHS_INTSTA) Endpoint 7 Interrupt */
#define UDPHS_INTSTA_EPT_8 (0x1u << 16) /**< \brief (UDPHS_INTSTA) Endpoint 8 Interrupt */
#define UDPHS_INTSTA_EPT_9 (0x1u << 17) /**< \brief (UDPHS_INTSTA) Endpoint 9 Interrupt */
#define UDPHS_INTSTA_EPT_10 (0x1u << 18) /**< \brief (UDPHS_INTSTA) Endpoint 10 Interrupt */
#define UDPHS_INTSTA_EPT_11 (0x1u << 19) /**< \brief (UDPHS_INTSTA) Endpoint 11 Interrupt */
#define UDPHS_INTSTA_EPT_12 (0x1u << 20) /**< \brief (UDPHS_INTSTA) Endpoint 12 Interrupt */
#define UDPHS_INTSTA_EPT_13 (0x1u << 21) /**< \brief (UDPHS_INTSTA) Endpoint 13 Interrupt */
#define UDPHS_INTSTA_EPT_14 (0x1u << 22) /**< \brief (UDPHS_INTSTA) Endpoint 14 Interrupt */
#define UDPHS_INTSTA_EPT_15 (0x1u << 23) /**< \brief (UDPHS_INTSTA) Endpoint 15 Interrupt */
#define UDPHS_INTSTA_DMA_1 (0x1u << 25) /**< \brief (UDPHS_INTSTA) DMA Channel 1 Interrupt */
#define UDPHS_INTSTA_DMA_2 (0x1u << 26) /**< \brief (UDPHS_INTSTA) DMA Channel 2 Interrupt */
#define UDPHS_INTSTA_DMA_3 (0x1u << 27) /**< \brief (UDPHS_INTSTA) DMA Channel 3 Interrupt */
#define UDPHS_INTSTA_DMA_4 (0x1u << 28) /**< \brief (UDPHS_INTSTA) DMA Channel 4 Interrupt */
#define UDPHS_INTSTA_DMA_5 (0x1u << 29) /**< \brief (UDPHS_INTSTA) DMA Channel 5 Interrupt */
#define UDPHS_INTSTA_DMA_6 (0x1u << 30) /**< \brief (UDPHS_INTSTA) DMA Channel 6 Interrupt */
#define UDPHS_INTSTA_DMA_7 (0x1u << 31) /**< \brief (UDPHS_INTSTA) DMA Channel 7 Interrupt */
/* -------- UDPHS_CLRINT : (UDPHS Offset: 0x18) UDPHS Clear Interrupt Register -------- */
#define UDPHS_CLRINT_DET_SUSPD (0x1u << 1) /**< \brief (UDPHS_CLRINT) Suspend Interrupt Clear */
#define UDPHS_CLRINT_MICRO_SOF (0x1u << 2) /**< \brief (UDPHS_CLRINT) Micro Start Of Frame Interrupt Clear */
#define UDPHS_CLRINT_INT_SOF (0x1u << 3) /**< \brief (UDPHS_CLRINT) Start Of Frame Interrupt Clear */
#define UDPHS_CLRINT_ENDRESET (0x1u << 4) /**< \brief (UDPHS_CLRINT) End Of Reset Interrupt Clear */
#define UDPHS_CLRINT_WAKE_UP (0x1u << 5) /**< \brief (UDPHS_CLRINT) Wake Up CPU Interrupt Clear */
#define UDPHS_CLRINT_ENDOFRSM (0x1u << 6) /**< \brief (UDPHS_CLRINT) End Of Resume Interrupt Clear */
#define UDPHS_CLRINT_UPSTR_RES (0x1u << 7) /**< \brief (UDPHS_CLRINT) Upstream Resume Interrupt Clear */
/* -------- UDPHS_EPTRST : (UDPHS Offset: 0x1C) UDPHS Endpoints Reset Register -------- */
#define UDPHS_EPTRST_EPT_0 (0x1u << 0) /**< \brief (UDPHS_EPTRST) Endpoint 0 Reset */
#define UDPHS_EPTRST_EPT_1 (0x1u << 1) /**< \brief (UDPHS_EPTRST) Endpoint 1 Reset */
#define UDPHS_EPTRST_EPT_2 (0x1u << 2) /**< \brief (UDPHS_EPTRST) Endpoint 2 Reset */
#define UDPHS_EPTRST_EPT_3 (0x1u << 3) /**< \brief (UDPHS_EPTRST) Endpoint 3 Reset */
#define UDPHS_EPTRST_EPT_4 (0x1u << 4) /**< \brief (UDPHS_EPTRST) Endpoint 4 Reset */
#define UDPHS_EPTRST_EPT_5 (0x1u << 5) /**< \brief (UDPHS_EPTRST) Endpoint 5 Reset */
#define UDPHS_EPTRST_EPT_6 (0x1u << 6) /**< \brief (UDPHS_EPTRST) Endpoint 6 Reset */
#define UDPHS_EPTRST_EPT_7 (0x1u << 7) /**< \brief (UDPHS_EPTRST) Endpoint 7 Reset */
#define UDPHS_EPTRST_EPT_8 (0x1u << 8) /**< \brief (UDPHS_EPTRST) Endpoint 8 Reset */
#define UDPHS_EPTRST_EPT_9 (0x1u << 9) /**< \brief (UDPHS_EPTRST) Endpoint 9 Reset */
#define UDPHS_EPTRST_EPT_10 (0x1u << 10) /**< \brief (UDPHS_EPTRST) Endpoint 10 Reset */
#define UDPHS_EPTRST_EPT_11 (0x1u << 11) /**< \brief (UDPHS_EPTRST) Endpoint 11 Reset */
#define UDPHS_EPTRST_EPT_12 (0x1u << 12) /**< \brief (UDPHS_EPTRST) Endpoint 12 Reset */
#define UDPHS_EPTRST_EPT_13 (0x1u << 13) /**< \brief (UDPHS_EPTRST) Endpoint 13 Reset */
#define UDPHS_EPTRST_EPT_14 (0x1u << 14) /**< \brief (UDPHS_EPTRST) Endpoint 14 Reset */
#define UDPHS_EPTRST_EPT_15 (0x1u << 15) /**< \brief (UDPHS_EPTRST) Endpoint 15 Reset */
/* -------- UDPHS_TST : (UDPHS Offset: 0xE0) UDPHS Test Register -------- */
#define UDPHS_TST_SPEED_CFG_Pos 0
#define UDPHS_TST_SPEED_CFG_Msk (0x3u << UDPHS_TST_SPEED_CFG_Pos) /**< \brief (UDPHS_TST) Speed Configuration */
#define   UDPHS_TST_SPEED_CFG_NORMAL (0x0u << 0) /**< \brief (UDPHS_TST) Normal Mode: The macro is in Full Speed mode, ready to make a High Speed identification, if the host supports it and then to automatically switch to High Speed mode */
#define   UDPHS_TST_SPEED_CFG_HIGH_SPEED (0x2u << 0) /**< \brief (UDPHS_TST) Force High Speed: Set this value to force the hardware to work in High Speed mode. Only for debug or test purpose. */
#define   UDPHS_TST_SPEED_CFG_FULL_SPEED (0x3u << 0) /**< \brief (UDPHS_TST) Force Full Speed: Set this value to force the hardware to work only in Full Speed mode. In this configuration, the macro will not respond to a High Speed reset handshake. */
#define UDPHS_TST_TST_J (0x1u << 2) /**< \brief (UDPHS_TST) Test J Mode */
#define UDPHS_TST_TST_K (0x1u << 3) /**< \brief (UDPHS_TST) Test K Mode */
#define UDPHS_TST_TST_PKT (0x1u << 4) /**< \brief (UDPHS_TST) Test Packet Mode */
#define UDPHS_TST_OPMODE2 (0x1u << 5) /**< \brief (UDPHS_TST) OpMode2 */
/* -------- UDPHS_EPTCFG : (UDPHS Offset: N/A) UDPHS Endpoint Configuration Register -------- */
#define UDPHS_EPTCFG_EPT_SIZE_Pos 0
#define UDPHS_EPTCFG_EPT_SIZE_Msk (0x7u << UDPHS_EPTCFG_EPT_SIZE_Pos) /**< \brief (UDPHS_EPTCFG) Endpoint Size */
#define   UDPHS_EPTCFG_EPT_SIZE_8 (0x0u << 0) /**< \brief (UDPHS_EPTCFG) 8 bytes */
#define   UDPHS_EPTCFG_EPT_SIZE_16 (0x1u << 0) /**< \brief (UDPHS_EPTCFG) 16 bytes */
#define   UDPHS_EPTCFG_EPT_SIZE_32 (0x2u << 0) /**< \brief (UDPHS_EPTCFG) 32 bytes */
#define   UDPHS_EPTCFG_EPT_SIZE_64 (0x3u << 0) /**< \brief (UDPHS_EPTCFG) 64 bytes */
#define   UDPHS_EPTCFG_EPT_SIZE_128 (0x4u << 0) /**< \brief (UDPHS_EPTCFG) 128 bytes */
#define   UDPHS_EPTCFG_EPT_SIZE_256 (0x5u << 0) /**< \brief (UDPHS_EPTCFG) 256 bytes */
#define   UDPHS_EPTCFG_EPT_SIZE_512 (0x6u << 0) /**< \brief (UDPHS_EPTCFG) 512 bytes */
#define   UDPHS_EPTCFG_EPT_SIZE_1024 (0x7u << 0) /**< \brief (UDPHS_EPTCFG) 1024 bytes */
#define UDPHS_EPTCFG_EPT_DIR (0x1u << 3) /**< \brief (UDPHS_EPTCFG) Endpoint Direction */
#define UDPHS_EPTCFG_EPT_TYPE_Pos 4
#define UDPHS_EPTCFG_EPT_TYPE_Msk (0x3u << UDPHS_EPTCFG_EPT_TYPE_Pos) /**< \brief (UDPHS_EPTCFG) Endpoint Type */
#define   UDPHS_EPTCFG_EPT_TYPE_CTRL8 (0x0u << 4) /**< \brief (UDPHS_EPTCFG) Control endpoint */
#define   UDPHS_EPTCFG_EPT_TYPE_ISO (0x1u << 4) /**< \brief (UDPHS_EPTCFG) Isochronous endpoint */
#define   UDPHS_EPTCFG_EPT_TYPE_BULK (0x2u << 4) /**< \brief (UDPHS_EPTCFG) Bulk endpoint */
#define   UDPHS_EPTCFG_EPT_TYPE_INT (0x3u << 4) /**< \brief (UDPHS_EPTCFG) Interrupt endpoint */
#define UDPHS_EPTCFG_BK_NUMBER_Pos 6
#define UDPHS_EPTCFG_BK_NUMBER_Msk (0x3u << UDPHS_EPTCFG_BK_NUMBER_Pos) /**< \brief (UDPHS_EPTCFG) Number of Banks */
#define   UDPHS_EPTCFG_BK_NUMBER_0 (0x0u << 6) /**< \brief (UDPHS_EPTCFG) Zero bank, the endpoint is not mapped in memory */
#define   UDPHS_EPTCFG_BK_NUMBER_1 (0x1u << 6) /**< \brief (UDPHS_EPTCFG) One bank (bank 0) */
#define   UDPHS_EPTCFG_BK_NUMBER_2 (0x2u << 6) /**< \brief (UDPHS_EPTCFG) Double bank (Ping-Pong: bank0/bank1) */
#define   UDPHS_EPTCFG_BK_NUMBER_3 (0x3u << 6) /**< \brief (UDPHS_EPTCFG) Triple bank (bank0/bank1/bank2) */
#define UDPHS_EPTCFG_NB_TRANS_Pos 8
#define UDPHS_EPTCFG_NB_TRANS_Msk (0x3u << UDPHS_EPTCFG_NB_TRANS_Pos) /**< \brief (UDPHS_EPTCFG) Number Of Transaction per Microframe */
#define UDPHS_EPTCFG_NB_TRANS(value) ((UDPHS_EPTCFG_NB_TRANS_Msk & ((value) << UDPHS_EPTCFG_NB_TRANS_Pos)))
#define UDPHS_EPTCFG_EPT_MAPD (0x1u << 31) /**< \brief (UDPHS_EPTCFG) Endpoint Mapped */
/* -------- UDPHS_EPTCTLENB : (UDPHS Offset: N/A) UDPHS Endpoint Control Enable Register -------- */
#define UDPHS_EPTCTLENB_EPT_ENABL (0x1u << 0) /**< \brief (UDPHS_EPTCTLENB) Endpoint Enable */
#define UDPHS_EPTCTLENB_AUTO_VALID (0x1u << 1) /**< \brief (UDPHS_EPTCTLENB) Packet Auto-Valid Enable */
#define UDPHS_EPTCTLENB_INTDIS_DMA (0x1u << 3) /**< \brief (UDPHS_EPTCTLENB) Interrupts Disable DMA */
#define UDPHS_EPTCTLENB_NYET_DIS (0x1u << 4) /**< \brief (UDPHS_EPTCTLENB) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLENB_ERR_OVFLW (0x1u << 8) /**< \brief (UDPHS_EPTCTLENB) Overflow Error Interrupt Enable */
#define UDPHS_EPTCTLENB_RXRDY_TXKL (0x1u << 9) /**< \brief (UDPHS_EPTCTLENB) Received OUT Data Interrupt Enable */
#define UDPHS_EPTCTLENB_TX_COMPLT (0x1u << 10) /**< \brief (UDPHS_EPTCTLENB) Transmitted IN Data Complete Interrupt Enable */
#define UDPHS_EPTCTLENB_TXRDY (0x1u << 11) /**< \brief (UDPHS_EPTCTLENB) TX Packet Ready Interrupt Enable */
#define UDPHS_EPTCTLENB_RX_SETUP (0x1u << 12) /**< \brief (UDPHS_EPTCTLENB) Received SETUP */
#define UDPHS_EPTCTLENB_STALL_SNT (0x1u << 13) /**< \brief (UDPHS_EPTCTLENB) Stall Sent Interrupt Enable */
#define UDPHS_EPTCTLENB_NAK_IN (0x1u << 14) /**< \brief (UDPHS_EPTCTLENB) NAKIN Interrupt Enable */
#define UDPHS_EPTCTLENB_NAK_OUT (0x1u << 15) /**< \brief (UDPHS_EPTCTLENB) NAKOUT Interrupt Enable */
#define UDPHS_EPTCTLENB_BUSY_BANK (0x1u << 18) /**< \brief (UDPHS_EPTCTLENB) Busy Bank Interrupt Enable */
#define UDPHS_EPTCTLENB_SHRT_PCKT (0x1u << 31) /**< \brief (UDPHS_EPTCTLENB) Short Packet Send/Short Packet Interrupt Enable */
#define UDPHS_EPTCTLENB_DATAX_RX (0x1u << 6) /**< \brief (UDPHS_EPTCTLENB) DATAx Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB_MDATA_RX (0x1u << 7) /**< \brief (UDPHS_EPTCTLENB) MDATA Interrupt Enable (Only for high bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLENB_TXRDY_TRER (0x1u << 11) /**< \brief (UDPHS_EPTCTLENB) TX Packet Ready/Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB_ERR_FL_ISO (0x1u << 12) /**< \brief (UDPHS_EPTCTLENB) Error Flow Interrupt Enable */
#define UDPHS_EPTCTLENB_ERR_CRC_NTR (0x1u << 13) /**< \brief (UDPHS_EPTCTLENB) ISO CRC Error/Number of Transaction Error Interrupt Enable */
#define UDPHS_EPTCTLENB_ERR_FLUSH (0x1u << 14) /**< \brief (UDPHS_EPTCTLENB) Bank Flush Error Interrupt Enable */
/* -------- UDPHS_EPTCTLDIS : (UDPHS Offset: N/A) UDPHS Endpoint Control Disable Register -------- */
#define UDPHS_EPTCTLDIS_EPT_DISABL (0x1u << 0) /**< \brief (UDPHS_EPTCTLDIS) Endpoint Disable */
#define UDPHS_EPTCTLDIS_AUTO_VALID (0x1u << 1) /**< \brief (UDPHS_EPTCTLDIS) Packet Auto-Valid Disable */
#define UDPHS_EPTCTLDIS_INTDIS_DMA (0x1u << 3) /**< \brief (UDPHS_EPTCTLDIS) Interrupts Disable DMA */
#define UDPHS_EPTCTLDIS_NYET_DIS (0x1u << 4) /**< \brief (UDPHS_EPTCTLDIS) NYET Enable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTLDIS_ERR_OVFLW (0x1u << 8) /**< \brief (UDPHS_EPTCTLDIS) Overflow Error Interrupt Disable */
#define UDPHS_EPTCTLDIS_RXRDY_TXKL (0x1u << 9) /**< \brief (UDPHS_EPTCTLDIS) Received OUT Data Interrupt Disable */
#define UDPHS_EPTCTLDIS_TX_COMPLT (0x1u << 10) /**< \brief (UDPHS_EPTCTLDIS) Transmitted IN Data Complete Interrupt Disable */
#define UDPHS_EPTCTLDIS_TXRDY (0x1u << 11) /**< \brief (UDPHS_EPTCTLDIS) TX Packet Ready Interrupt Disable */
#define UDPHS_EPTCTLDIS_RX_SETUP (0x1u << 12) /**< \brief (UDPHS_EPTCTLDIS) Received SETUP Interrupt Disable */
#define UDPHS_EPTCTLDIS_STALL_SNT (0x1u << 13) /**< \brief (UDPHS_EPTCTLDIS) Stall Sent Interrupt Disable */
#define UDPHS_EPTCTLDIS_NAK_IN (0x1u << 14) /**< \brief (UDPHS_EPTCTLDIS) NAKIN Interrupt Disable */
#define UDPHS_EPTCTLDIS_NAK_OUT (0x1u << 15) /**< \brief (UDPHS_EPTCTLDIS) NAKOUT Interrupt Disable */
#define UDPHS_EPTCTLDIS_BUSY_BANK (0x1u << 18) /**< \brief (UDPHS_EPTCTLDIS) Busy Bank Interrupt Disable */
#define UDPHS_EPTCTLDIS_SHRT_PCKT (0x1u << 31) /**< \brief (UDPHS_EPTCTLDIS) Short Packet Interrupt Disable */
#define UDPHS_EPTCTLDIS_DATAX_RX (0x1u << 6) /**< \brief (UDPHS_EPTCTLDIS) DATAx Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS_MDATA_RX (0x1u << 7) /**< \brief (UDPHS_EPTCTLDIS) MDATA Interrupt Disable (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTLDIS_TXRDY_TRER (0x1u << 11) /**< \brief (UDPHS_EPTCTLDIS) TX Packet Ready/Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS_ERR_FL_ISO (0x1u << 12) /**< \brief (UDPHS_EPTCTLDIS) Error Flow Interrupt Disable */
#define UDPHS_EPTCTLDIS_ERR_CRC_NTR (0x1u << 13) /**< \brief (UDPHS_EPTCTLDIS) ISO CRC Error/Number of Transaction Error Interrupt Disable */
#define UDPHS_EPTCTLDIS_ERR_FLUSH (0x1u << 14) /**< \brief (UDPHS_EPTCTLDIS) bank flush error Interrupt Disable */
/* -------- UDPHS_EPTCTL : (UDPHS Offset: N/A) UDPHS Endpoint Control Register -------- */
#define UDPHS_EPTCTL_EPT_ENABL (0x1u << 0) /**< \brief (UDPHS_EPTCTL) Endpoint Enable */
#define UDPHS_EPTCTL_AUTO_VALID (0x1u << 1) /**< \brief (UDPHS_EPTCTL) Packet Auto-Valid Enabled (Not for CONTROL Endpoints) */
#define UDPHS_EPTCTL_INTDIS_DMA (0x1u << 3) /**< \brief (UDPHS_EPTCTL) Interrupt Disables DMA */
#define UDPHS_EPTCTL_NYET_DIS (0x1u << 4) /**< \brief (UDPHS_EPTCTL) NYET Disable (Only for High Speed Bulk OUT endpoints) */
#define UDPHS_EPTCTL_ERR_OVFLW (0x1u << 8) /**< \brief (UDPHS_EPTCTL) Overflow Error Interrupt Enabled */
#define UDPHS_EPTCTL_RXRDY_TXKL (0x1u << 9) /**< \brief (UDPHS_EPTCTL) Received OUT Data Interrupt Enabled */
#define UDPHS_EPTCTL_TX_COMPLT (0x1u << 10) /**< \brief (UDPHS_EPTCTL) Transmitted IN Data Complete Interrupt Enabled */
#define UDPHS_EPTCTL_TXRDY (0x1u << 11) /**< \brief (UDPHS_EPTCTL) TX Packet Ready Interrupt Enabled */
#define UDPHS_EPTCTL_RX_SETUP (0x1u << 12) /**< \brief (UDPHS_EPTCTL) Received SETUP Interrupt Enabled */
#define UDPHS_EPTCTL_STALL_SNT (0x1u << 13) /**< \brief (UDPHS_EPTCTL) Stall Sent Interrupt Enabled */
#define UDPHS_EPTCTL_NAK_IN (0x1u << 14) /**< \brief (UDPHS_EPTCTL) NAKIN Interrupt Enabled */
#define UDPHS_EPTCTL_NAK_OUT (0x1u << 15) /**< \brief (UDPHS_EPTCTL) NAKOUT Interrupt Enabled */
#define UDPHS_EPTCTL_BUSY_BANK (0x1u << 18) /**< \brief (UDPHS_EPTCTL) Busy Bank Interrupt Enabled */
#define UDPHS_EPTCTL_SHRT_PCKT (0x1u << 31) /**< \brief (UDPHS_EPTCTL) Short Packet Interrupt Enabled */
#define UDPHS_EPTCTL_DATAX_RX (0x1u << 6) /**< \brief (UDPHS_EPTCTL) DATAx Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL_MDATA_RX (0x1u << 7) /**< \brief (UDPHS_EPTCTL) MDATA Interrupt Enabled (Only for High Bandwidth Isochronous OUT endpoints) */
#define UDPHS_EPTCTL_TXRDY_TRER (0x1u << 11) /**< \brief (UDPHS_EPTCTL) TX Packet Ready/Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL_ERR_FL_ISO (0x1u << 12) /**< \brief (UDPHS_EPTCTL) Error Flow Interrupt Enabled */
#define UDPHS_EPTCTL_ERR_CRC_NTR (0x1u << 13) /**< \brief (UDPHS_EPTCTL) ISO CRC Error/Number of Transaction Error Interrupt Enabled */
#define UDPHS_EPTCTL_ERR_FLUSH (0x1u << 14) /**< \brief (UDPHS_EPTCTL) Bank Flush Error Interrupt Enabled */
/* -------- UDPHS_EPTSETSTA : (UDPHS Offset: N/A) UDPHS Endpoint Set Status Register -------- */
#define UDPHS_EPTSETSTA_FRCESTALL (0x1u << 5) /**< \brief (UDPHS_EPTSETSTA) Stall Handshake Request Set */
#define UDPHS_EPTSETSTA_RXRDY_TXKL (0x1u << 9) /**< \brief (UDPHS_EPTSETSTA) KILL Bank Set (for IN Endpoint) */
#define UDPHS_EPTSETSTA_TXRDY (0x1u << 11) /**< \brief (UDPHS_EPTSETSTA) TX Packet Ready Set */
#define UDPHS_EPTSETSTA_TXRDY_TRER (0x1u << 11) /**< \brief (UDPHS_EPTSETSTA) TX Packet Ready Set */
/* -------- UDPHS_EPTCLRSTA : (UDPHS Offset: N/A) UDPHS Endpoint Clear Status Register -------- */
#define UDPHS_EPTCLRSTA_FRCESTALL (0x1u << 5) /**< \brief (UDPHS_EPTCLRSTA) Stall Handshake Request Clear */
#define UDPHS_EPTCLRSTA_TOGGLESQ (0x1u << 6) /**< \brief (UDPHS_EPTCLRSTA) Data Toggle Clear */
#define UDPHS_EPTCLRSTA_RXRDY_TXKL (0x1u << 9) /**< \brief (UDPHS_EPTCLRSTA) Received OUT Data Clear */
#define UDPHS_EPTCLRSTA_TX_COMPLT (0x1u << 10) /**< \brief (UDPHS_EPTCLRSTA) Transmitted IN Data Complete Clear */
#define UDPHS_EPTCLRSTA_RX_SETUP (0x1u << 12) /**< \brief (UDPHS_EPTCLRSTA) Received SETUP Clear */
#define UDPHS_EPTCLRSTA_STALL_SNT (0x1u << 13) /**< \brief (UDPHS_EPTCLRSTA) Stall Sent Clear */
#define UDPHS_EPTCLRSTA_NAK_IN (0x1u << 14) /**< \brief (UDPHS_EPTCLRSTA) NAKIN Clear */
#define UDPHS_EPTCLRSTA_NAK_OUT (0x1u << 15) /**< \brief (UDPHS_EPTCLRSTA) NAKOUT Clear */
#define UDPHS_EPTCLRSTA_ERR_FL_ISO (0x1u << 12) /**< \brief (UDPHS_EPTCLRSTA) Error Flow Clear */
#define UDPHS_EPTCLRSTA_ERR_CRC_NTR (0x1u << 13) /**< \brief (UDPHS_EPTCLRSTA) Number of Transaction Error Clear */
#define UDPHS_EPTCLRSTA_ERR_FLUSH (0x1u << 14) /**< \brief (UDPHS_EPTCLRSTA) Bank Flush Error Clear */
/* -------- UDPHS_EPTSTA : (UDPHS Offset: N/A) UDPHS Endpoint Status Register -------- */
#define UDPHS_EPTSTA_FRCESTALL (0x1u << 5) /**< \brief (UDPHS_EPTSTA) Stall Handshake Request */
#define UDPHS_EPTSTA_TOGGLESQ_STA_Pos 6
#define UDPHS_EPTSTA_TOGGLESQ_STA_Msk (0x3u << UDPHS_EPTSTA_TOGGLESQ_STA_Pos) /**< \brief (UDPHS_EPTSTA) Toggle Sequencing */
#define   UDPHS_EPTSTA_TOGGLESQ_STA_DATA0 (0x0u << 6) /**< \brief (UDPHS_EPTSTA) DATA0 */
#define   UDPHS_EPTSTA_TOGGLESQ_STA_DATA1 (0x1u << 6) /**< \brief (UDPHS_EPTSTA) DATA1 */
#define   UDPHS_EPTSTA_TOGGLESQ_STA_DATA2 (0x2u << 6) /**< \brief (UDPHS_EPTSTA) Reserved for High Bandwidth Isochronous Endpoint */
#define   UDPHS_EPTSTA_TOGGLESQ_STA_MDATA (0x3u << 6) /**< \brief (UDPHS_EPTSTA) Reserved for High Bandwidth Isochronous Endpoint */
#define UDPHS_EPTSTA_ERR_OVFLW (0x1u << 8) /**< \brief (UDPHS_EPTSTA) Overflow Error */
#define UDPHS_EPTSTA_RXRDY_TXKL (0x1u << 9) /**< \brief (UDPHS_EPTSTA) Received OUT Data/KILL Bank */
#define UDPHS_EPTSTA_TX_COMPLT (0x1u << 10) /**< \brief (UDPHS_EPTSTA) Transmitted IN Data Complete */
#define UDPHS_EPTSTA_TXRDY (0x1u << 11) /**< \brief (UDPHS_EPTSTA) TX Packet Ready */
#define UDPHS_EPTSTA_RX_SETUP (0x1u << 12) /**< \brief (UDPHS_EPTSTA) Received SETUP */
#define UDPHS_EPTSTA_STALL_SNT (0x1u << 13) /**< \brief (UDPHS_EPTSTA) Stall Sent */
#define UDPHS_EPTSTA_NAK_IN (0x1u << 14) /**< \brief (UDPHS_EPTSTA) NAK IN */
#define UDPHS_EPTSTA_NAK_OUT (0x1u << 15) /**< \brief (UDPHS_EPTSTA) NAK OUT */
#define UDPHS_EPTSTA_CURBK_CTLDIR_Pos 16
#define UDPHS_EPTSTA_CURBK_CTLDIR_Msk (0x3u << UDPHS_EPTSTA_CURBK_CTLDIR_Pos) /**< \brief (UDPHS_EPTSTA) Current Bank/Control Direction */
#define UDPHS_EPTSTA_BUSY_BANK_STA_Pos 18
#define UDPHS_EPTSTA_BUSY_BANK_STA_Msk (0x3u << UDPHS_EPTSTA_BUSY_BANK_STA_Pos) /**< \brief (UDPHS_EPTSTA) Busy Bank Number */
#define   UDPHS_EPTSTA_BUSY_BANK_STA_1BUSYBANK (0x0u << 18) /**< \brief (UDPHS_EPTSTA) 1 busy bank */
#define   UDPHS_EPTSTA_BUSY_BANK_STA_2BUSYBANKS (0x1u << 18) /**< \brief (UDPHS_EPTSTA) 2 busy banks */
#define   UDPHS_EPTSTA_BUSY_BANK_STA_3BUSYBANKS (0x2u << 18) /**< \brief (UDPHS_EPTSTA) 3 busy banks */
#define UDPHS_EPTSTA_BYTE_COUNT_Pos 20
#define UDPHS_EPTSTA_BYTE_COUNT_Msk (0x7ffu << UDPHS_EPTSTA_BYTE_COUNT_Pos) /**< \brief (UDPHS_EPTSTA) UDPHS Byte Count */
#define UDPHS_EPTSTA_SHRT_PCKT (0x1u << 31) /**< \brief (UDPHS_EPTSTA) Short Packet */
#define UDPHS_EPTSTA_TXRDY_TRER (0x1u << 11) /**< \brief (UDPHS_EPTSTA) TX Packet Ready/Transaction Error */
#define UDPHS_EPTSTA_ERR_FL_ISO (0x1u << 12) /**< \brief (UDPHS_EPTSTA) Error Flow */
#define UDPHS_EPTSTA_ERR_CRC_NTR (0x1u << 13) /**< \brief (UDPHS_EPTSTA) CRC ISO Error/Number of Transaction Error */
#define UDPHS_EPTSTA_ERR_FLUSH (0x1u << 14) /**< \brief (UDPHS_EPTSTA) Bank Flush Error */
#define UDPHS_EPTSTA_CURBK_Pos 16
#define UDPHS_EPTSTA_CURBK_Msk (0x3u << UDPHS_EPTSTA_CURBK_Pos) /**< \brief (UDPHS_EPTSTA) Current Bank */
#define   UDPHS_EPTSTA_CURBK_BANK0 (0x0u << 16) /**< \brief (UDPHS_EPTSTA) Bank 0 (or single bank) */
#define   UDPHS_EPTSTA_CURBK_BANK1 (0x1u << 16) /**< \brief (UDPHS_EPTSTA) Bank 1 */
#define   UDPHS_EPTSTA_CURBK_BANK2 (0x2u << 16) /**< \brief (UDPHS_EPTSTA) Bank 2 */
/* -------- UDPHS_DMANXTDSC : (UDPHS Offset: N/A) UDPHS DMA Next Descriptor Address Register -------- */
#define UDPHS_DMANXTDSC_NXT_DSC_ADD_Pos 0
#define UDPHS_DMANXTDSC_NXT_DSC_ADD_Msk (0xffffffffu << UDPHS_DMANXTDSC_NXT_DSC_ADD_Pos) /**< \brief (UDPHS_DMANXTDSC) Next Descriptor Address */
#define UDPHS_DMANXTDSC_NXT_DSC_ADD(value) ((UDPHS_DMANXTDSC_NXT_DSC_ADD_Msk & ((value) << UDPHS_DMANXTDSC_NXT_DSC_ADD_Pos)))
/* -------- UDPHS_DMAADDRESS : (UDPHS Offset: N/A) UDPHS DMA Channel Address Register -------- */
#define UDPHS_DMAADDRESS_BUFF_ADD_Pos 0
#define UDPHS_DMAADDRESS_BUFF_ADD_Msk (0xffffffffu << UDPHS_DMAADDRESS_BUFF_ADD_Pos) /**< \brief (UDPHS_DMAADDRESS) Buffer Address */
#define UDPHS_DMAADDRESS_BUFF_ADD(value) ((UDPHS_DMAADDRESS_BUFF_ADD_Msk & ((value) << UDPHS_DMAADDRESS_BUFF_ADD_Pos)))
/* -------- UDPHS_DMACONTROL : (UDPHS Offset: N/A) UDPHS DMA Channel Control Register -------- */
#define UDPHS_DMACONTROL_CHANN_ENB (0x1u << 0) /**< \brief (UDPHS_DMACONTROL) (Channel Enable Command) */
#define UDPHS_DMACONTROL_LDNXT_DSC (0x1u << 1) /**< \brief (UDPHS_DMACONTROL) Load Next Channel Transfer Descriptor Enable (Command) */
#define UDPHS_DMACONTROL_END_TR_EN (0x1u << 2) /**< \brief (UDPHS_DMACONTROL) End of Transfer Enable (Control) */
#define UDPHS_DMACONTROL_END_B_EN (0x1u << 3) /**< \brief (UDPHS_DMACONTROL) End of Buffer Enable (Control) */
#define UDPHS_DMACONTROL_END_TR_IT (0x1u << 4) /**< \brief (UDPHS_DMACONTROL) End of Transfer Interrupt Enable */
#define UDPHS_DMACONTROL_END_BUFFIT (0x1u << 5) /**< \brief (UDPHS_DMACONTROL) End of Buffer Interrupt Enable */
#define UDPHS_DMACONTROL_DESC_LD_IT (0x1u << 6) /**< \brief (UDPHS_DMACONTROL) Descriptor Loaded Interrupt Enable */
#define UDPHS_DMACONTROL_BURST_LCK (0x1u << 7) /**< \brief (UDPHS_DMACONTROL) Burst Lock Enable */
#define UDPHS_DMACONTROL_BUFF_LENGTH_Pos 16
#define UDPHS_DMACONTROL_BUFF_LENGTH_Msk (0xffffu << UDPHS_DMACONTROL_BUFF_LENGTH_Pos) /**< \brief (UDPHS_DMACONTROL) Buffer Byte Length (Write-only) */
#define UDPHS_DMACONTROL_BUFF_LENGTH(value) ((UDPHS_DMACONTROL_BUFF_LENGTH_Msk & ((value) << UDPHS_DMACONTROL_BUFF_LENGTH_Pos)))
/* -------- UDPHS_DMASTATUS : (UDPHS Offset: N/A) UDPHS DMA Channel Status Register -------- */
#define UDPHS_DMASTATUS_CHANN_ENB (0x1u << 0) /**< \brief (UDPHS_DMASTATUS) Channel Enable Status */
#define UDPHS_DMASTATUS_CHANN_ACT (0x1u << 1) /**< \brief (UDPHS_DMASTATUS) Channel Active Status */
#define UDPHS_DMASTATUS_END_TR_ST (0x1u << 4) /**< \brief (UDPHS_DMASTATUS) End of Channel Transfer Status */
#define UDPHS_DMASTATUS_END_BF_ST (0x1u << 5) /**< \brief (UDPHS_DMASTATUS) End of Channel Buffer Status */
#define UDPHS_DMASTATUS_DESC_LDST (0x1u << 6) /**< \brief (UDPHS_DMASTATUS) Descriptor Loaded Status */
#define UDPHS_DMASTATUS_BUFF_COUNT_Pos 16
#define UDPHS_DMASTATUS_BUFF_COUNT_Msk (0xffffu << UDPHS_DMASTATUS_BUFF_COUNT_Pos) /**< \brief (UDPHS_DMASTATUS) Buffer Byte Count */
#define UDPHS_DMASTATUS_BUFF_COUNT(value) ((UDPHS_DMASTATUS_BUFF_COUNT_Msk & ((value) << UDPHS_DMASTATUS_BUFF_COUNT_Pos)))

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Universal Synchronous Asynchronous Receiver Transmitter */
/* ============================================================================= */
/** \addtogroup SAMA5D4_USART Universal Synchronous Asynchronous Receiver Transmitter */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Usart hardware registers */
typedef struct {
  __O  uint32_t US_CR;         /**< \brief (Usart Offset: 0x0000) Control Register */
  __IO uint32_t US_MR;         /**< \brief (Usart Offset: 0x0004) Mode Register */
  __O  uint32_t US_IER;        /**< \brief (Usart Offset: 0x0008) Interrupt Enable Register */
  __O  uint32_t US_IDR;        /**< \brief (Usart Offset: 0x000C) Interrupt Disable Register */
  __I  uint32_t US_IMR;        /**< \brief (Usart Offset: 0x0010) Interrupt Mask Register */
  __I  uint32_t US_CSR;        /**< \brief (Usart Offset: 0x0014) Channel Status Register */
  __I  uint32_t US_RHR;        /**< \brief (Usart Offset: 0x0018) Receiver Holding Register */
  __O  uint32_t US_THR;        /**< \brief (Usart Offset: 0x001C) Transmitter Holding Register */
  __IO uint32_t US_BRGR;       /**< \brief (Usart Offset: 0x0020) Baud Rate Generator Register */
  __IO uint32_t US_RTOR;       /**< \brief (Usart Offset: 0x0024) Receiver Time-out Register */
  __IO uint32_t US_TTGR;       /**< \brief (Usart Offset: 0x0028) Transmitter Timeguard Register */
  __I  uint32_t Reserved1[5];
  __IO uint32_t US_FIDI;       /**< \brief (Usart Offset: 0x0040) FI DI Ratio Register */
  __I  uint32_t US_NER;        /**< \brief (Usart Offset: 0x0044) Number of Errors Register */
  __I  uint32_t Reserved2[1];
  __IO uint32_t US_IF;         /**< \brief (Usart Offset: 0x004C) IrDA Filter Register */
  __IO uint32_t US_MAN;        /**< \brief (Usart Offset: 0x0050) Manchester Encoder Decoder Register */
  __I  uint32_t Reserved3[36];
  __IO uint32_t US_WPMR;       /**< \brief (Usart Offset: 0x00E4) Write Protect Mode Register */
  __I  uint32_t US_WPSR;       /**< \brief (Usart Offset: 0x00E8) Write Protect Status Register */
} Usart;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- US_CR : (USART Offset: 0x0000) Control Register -------- */
#define US_CR_RSTRX (0x1u << 2) /**< \brief (US_CR) Reset Receiver */
#define US_CR_RSTTX (0x1u << 3) /**< \brief (US_CR) Reset Transmitter */
#define US_CR_RXEN (0x1u << 4) /**< \brief (US_CR) Receiver Enable */
#define US_CR_RXDIS (0x1u << 5) /**< \brief (US_CR) Receiver Disable */
#define US_CR_TXEN (0x1u << 6) /**< \brief (US_CR) Transmitter Enable */
#define US_CR_TXDIS (0x1u << 7) /**< \brief (US_CR) Transmitter Disable */
#define US_CR_RSTSTA (0x1u << 8) /**< \brief (US_CR) Reset Status Bits */
#define US_CR_STTBRK (0x1u << 9) /**< \brief (US_CR) Start Break */
#define US_CR_STPBRK (0x1u << 10) /**< \brief (US_CR) Stop Break */
#define US_CR_STTTO (0x1u << 11) /**< \brief (US_CR) Start Time-out */
#define US_CR_SENDA (0x1u << 12) /**< \brief (US_CR) Send Address */
#define US_CR_RSTIT (0x1u << 13) /**< \brief (US_CR) Reset Iterations */
#define US_CR_RSTNACK (0x1u << 14) /**< \brief (US_CR) Reset Non Acknowledge */
#define US_CR_RETTO (0x1u << 15) /**< \brief (US_CR) Rearm Time-out */
#define US_CR_RTSEN (0x1u << 18) /**< \brief (US_CR) Request to Send Enable */
#define US_CR_RTSDIS (0x1u << 19) /**< \brief (US_CR) Request to Send Disable */
#define US_CR_FCS (0x1u << 18) /**< \brief (US_CR) Force SPI Chip Select */
#define US_CR_RCS (0x1u << 19) /**< \brief (US_CR) Release SPI Chip Select */
/* -------- US_MR : (USART Offset: 0x0004) Mode Register -------- */
#define US_MR_USART_MODE_Pos 0
#define US_MR_USART_MODE_Msk (0xfu << US_MR_USART_MODE_Pos) /**< \brief (US_MR) USART Mode of Operation */
#define   US_MR_USART_MODE_NORMAL (0x0u << 0) /**< \brief (US_MR) Normal mode */
#define   US_MR_USART_MODE_RS485 (0x1u << 0) /**< \brief (US_MR) RS485 */
#define   US_MR_USART_MODE_HW_HANDSHAKING (0x2u << 0) /**< \brief (US_MR) Hardware Handshaking */
#define   US_MR_USART_MODE_IS07816_T_0 (0x4u << 0) /**< \brief (US_MR) IS07816 Protocol: T = 0 */
#define   US_MR_USART_MODE_IS07816_T_1 (0x6u << 0) /**< \brief (US_MR) IS07816 Protocol: T = 1 */
#define   US_MR_USART_MODE_IRDA (0x8u << 0) /**< \brief (US_MR) IrDA */
#define   US_MR_USART_MODE_SPI_MASTER (0xEu << 0) /**< \brief (US_MR) SPI Master */
#define   US_MR_USART_MODE_SPI_SLAVE (0xFu << 0) /**< \brief (US_MR) SPI Slave */
#define US_MR_USCLKS_Pos 4
#define US_MR_USCLKS_Msk (0x3u << US_MR_USCLKS_Pos) /**< \brief (US_MR) Clock Selection */
#define   US_MR_USCLKS_MCK (0x0u << 4) /**< \brief (US_MR) Master Clock MCK is selected */
#define   US_MR_USCLKS_DIV (0x1u << 4) /**< \brief (US_MR) Internal Clock Divided MCK/DIV (DIV=(DIV=8)) is selected */
#define   US_MR_USCLKS_SCK (0x3u << 4) /**< \brief (US_MR) Serial Clock SLK is selected */
#define US_MR_CHRL_Pos 6
#define US_MR_CHRL_Msk (0x3u << US_MR_CHRL_Pos) /**< \brief (US_MR) Character Length. */
#define   US_MR_CHRL_5_BIT (0x0u << 6) /**< \brief (US_MR) Character length is 5 bits */
#define   US_MR_CHRL_6_BIT (0x1u << 6) /**< \brief (US_MR) Character length is 6 bits */
#define   US_MR_CHRL_7_BIT (0x2u << 6) /**< \brief (US_MR) Character length is 7 bits */
#define   US_MR_CHRL_8_BIT (0x3u << 6) /**< \brief (US_MR) Character length is 8 bits */
#define US_MR_SYNC (0x1u << 8) /**< \brief (US_MR) Synchronous Mode Select */
#define US_MR_PAR_Pos 9
#define US_MR_PAR_Msk (0x7u << US_MR_PAR_Pos) /**< \brief (US_MR) Parity Type */
#define   US_MR_PAR_EVEN (0x0u << 9) /**< \brief (US_MR) Even parity */
#define   US_MR_PAR_ODD (0x1u << 9) /**< \brief (US_MR) Odd parity */
#define   US_MR_PAR_SPACE (0x2u << 9) /**< \brief (US_MR) Parity forced to 0 (Space) */
#define   US_MR_PAR_MARK (0x3u << 9) /**< \brief (US_MR) Parity forced to 1 (Mark) */
#define   US_MR_PAR_NO (0x4u << 9) /**< \brief (US_MR) No parity */
#define   US_MR_PAR_MULTIDROP (0x6u << 9) /**< \brief (US_MR) Multidrop mode */
#define US_MR_NBSTOP_Pos 12
#define US_MR_NBSTOP_Msk (0x3u << US_MR_NBSTOP_Pos) /**< \brief (US_MR) Number of Stop Bits */
#define   US_MR_NBSTOP_1_BIT (0x0u << 12) /**< \brief (US_MR) 1 stop bit */
#define   US_MR_NBSTOP_1_5_BIT (0x1u << 12) /**< \brief (US_MR) 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1) */
#define   US_MR_NBSTOP_2_BIT (0x2u << 12) /**< \brief (US_MR) 2 stop bits */
#define US_MR_CHMODE_Pos 14
#define US_MR_CHMODE_Msk (0x3u << US_MR_CHMODE_Pos) /**< \brief (US_MR) Channel Mode */
#define   US_MR_CHMODE_NORMAL (0x0u << 14) /**< \brief (US_MR) Normal Mode */
#define   US_MR_CHMODE_AUTOMATIC (0x1u << 14) /**< \brief (US_MR) Automatic Echo. Receiver input is connected to the TXD pin. */
#define   US_MR_CHMODE_LOCAL_LOOPBACK (0x2u << 14) /**< \brief (US_MR) Local Loopback. Transmitter output is connected to the Receiver Input. */
#define   US_MR_CHMODE_REMOTE_LOOPBACK (0x3u << 14) /**< \brief (US_MR) Remote Loopback. RXD pin is internally connected to the TXD pin. */
#define US_MR_MSBF (0x1u << 16) /**< \brief (US_MR) Bit Order */
#define US_MR_MODE9 (0x1u << 17) /**< \brief (US_MR) 9-bit Character Length */
#define US_MR_CLKO (0x1u << 18) /**< \brief (US_MR) Clock Output Select */
#define US_MR_OVER (0x1u << 19) /**< \brief (US_MR) Oversampling Mode */
#define US_MR_INACK (0x1u << 20) /**< \brief (US_MR) Inhibit Non Acknowledge */
#define US_MR_DSNACK (0x1u << 21) /**< \brief (US_MR) Disable Successive NACK */
#define US_MR_VAR_SYNC (0x1u << 22) /**< \brief (US_MR) Variable Synchronization of Command/Data Sync Start Frame Delimiter */
#define US_MR_INVDATA (0x1u << 23) /**< \brief (US_MR) Inverted Data */
#define US_MR_MAX_ITERATION_Pos 24
#define US_MR_MAX_ITERATION_Msk (0x7u << US_MR_MAX_ITERATION_Pos) /**< \brief (US_MR) Maximum Number of Automatic Iteration */
#define US_MR_MAX_ITERATION(value) ((US_MR_MAX_ITERATION_Msk & ((value) << US_MR_MAX_ITERATION_Pos)))
#define US_MR_FILTER (0x1u << 28) /**< \brief (US_MR) Infrared Receive Line Filter */
#define US_MR_MAN (0x1u << 29) /**< \brief (US_MR) Manchester Encoder/Decoder Enable */
#define US_MR_MODSYNC (0x1u << 30) /**< \brief (US_MR) Manchester Synchronization Mode */
#define US_MR_ONEBIT (0x1u << 31) /**< \brief (US_MR) Start Frame Delimiter Selector */
#define US_MR_CPHA (0x1u << 8) /**< \brief (US_MR) SPI Clock Phase */
#define US_MR_CPOL (0x1u << 16) /**< \brief (US_MR) SPI Clock Polarity */
#define US_MR_WRDBT (0x1u << 20) /**< \brief (US_MR) Wait Read Data Before Transfer */
/* -------- US_IER : (USART Offset: 0x0008) Interrupt Enable Register -------- */
#define US_IER_RXRDY (0x1u << 0) /**< \brief (US_IER) RXRDY Interrupt Enable */
#define US_IER_TXRDY (0x1u << 1) /**< \brief (US_IER) TXRDY Interrupt Enable */
#define US_IER_RXBRK (0x1u << 2) /**< \brief (US_IER) Receiver Break Interrupt Enable */
#define US_IER_OVRE (0x1u << 5) /**< \brief (US_IER) Overrun Error Interrupt Enable */
#define US_IER_FRAME (0x1u << 6) /**< \brief (US_IER) Framing Error Interrupt Enable */
#define US_IER_PARE (0x1u << 7) /**< \brief (US_IER) Parity Error Interrupt Enable */
#define US_IER_TIMEOUT (0x1u << 8) /**< \brief (US_IER) Time-out Interrupt Enable */
#define US_IER_TXEMPTY (0x1u << 9) /**< \brief (US_IER) TXEMPTY Interrupt Enable */
#define US_IER_ITER (0x1u << 10) /**< \brief (US_IER) Max number of Repetitions Reached Interrupt Enable */
#define US_IER_NACK (0x1u << 13) /**< \brief (US_IER) Non AcknowledgeInterrupt Enable */
#define US_IER_CTSIC (0x1u << 19) /**< \brief (US_IER) Clear to Send Input Change Interrupt Enable */
#define US_IER_MANE (0x1u << 24) /**< \brief (US_IER) Manchester Error Interrupt Enable */
#define US_IER_UNRE (0x1u << 10) /**< \brief (US_IER) SPI Underrun Error Interrupt Enable */
/* -------- US_IDR : (USART Offset: 0x000C) Interrupt Disable Register -------- */
#define US_IDR_RXRDY (0x1u << 0) /**< \brief (US_IDR) RXRDY Interrupt Disable */
#define US_IDR_TXRDY (0x1u << 1) /**< \brief (US_IDR) TXRDY Interrupt Disable */
#define US_IDR_RXBRK (0x1u << 2) /**< \brief (US_IDR) Receiver Break Interrupt Disable */
#define US_IDR_OVRE (0x1u << 5) /**< \brief (US_IDR) Overrun Error Interrupt Enable */
#define US_IDR_FRAME (0x1u << 6) /**< \brief (US_IDR) Framing Error Interrupt Disable */
#define US_IDR_PARE (0x1u << 7) /**< \brief (US_IDR) Parity Error Interrupt Disable */
#define US_IDR_TIMEOUT (0x1u << 8) /**< \brief (US_IDR) Time-out Interrupt Disable */
#define US_IDR_TXEMPTY (0x1u << 9) /**< \brief (US_IDR) TXEMPTY Interrupt Disable */
#define US_IDR_ITER (0x1u << 10) /**< \brief (US_IDR) Max Number of Repetitions Reached Interrupt Disable */
#define US_IDR_NACK (0x1u << 13) /**< \brief (US_IDR) Non AcknowledgeInterrupt Disable */
#define US_IDR_CTSIC (0x1u << 19) /**< \brief (US_IDR) Clear to Send Input Change Interrupt Disable */
#define US_IDR_MANE (0x1u << 24) /**< \brief (US_IDR) Manchester Error Interrupt Disable */
#define US_IDR_UNRE (0x1u << 10) /**< \brief (US_IDR) SPI Underrun Error Interrupt Disable */
/* -------- US_IMR : (USART Offset: 0x0010) Interrupt Mask Register -------- */
#define US_IMR_RXRDY (0x1u << 0) /**< \brief (US_IMR) RXRDY Interrupt Mask */
#define US_IMR_TXRDY (0x1u << 1) /**< \brief (US_IMR) TXRDY Interrupt Mask */
#define US_IMR_RXBRK (0x1u << 2) /**< \brief (US_IMR) Receiver Break Interrupt Mask */
#define US_IMR_OVRE (0x1u << 5) /**< \brief (US_IMR) Overrun Error Interrupt Mask */
#define US_IMR_FRAME (0x1u << 6) /**< \brief (US_IMR) Framing Error Interrupt Mask */
#define US_IMR_PARE (0x1u << 7) /**< \brief (US_IMR) Parity Error Interrupt Mask */
#define US_IMR_TIMEOUT (0x1u << 8) /**< \brief (US_IMR) Time-out Interrupt Mask */
#define US_IMR_TXEMPTY (0x1u << 9) /**< \brief (US_IMR) TXEMPTY Interrupt Mask */
#define US_IMR_ITER (0x1u << 10) /**< \brief (US_IMR) Max Number of Repetitions Reached Interrupt Mask */
#define US_IMR_NACK (0x1u << 13) /**< \brief (US_IMR) Non AcknowledgeInterrupt Mask */
#define US_IMR_CTSIC (0x1u << 19) /**< \brief (US_IMR) Clear to Send Input Change Interrupt Mask */
#define US_IMR_MANE (0x1u << 24) /**< \brief (US_IMR) Manchester Error Interrupt Mask */
#define US_IMR_UNRE (0x1u << 10) /**< \brief (US_IMR) SPI Underrun Error Interrupt Mask */
/* -------- US_CSR : (USART Offset: 0x0014) Channel Status Register -------- */
#define US_CSR_RXRDY (0x1u << 0) /**< \brief (US_CSR) Receiver Ready */
#define US_CSR_TXRDY (0x1u << 1) /**< \brief (US_CSR) Transmitter Ready */
#define US_CSR_RXBRK (0x1u << 2) /**< \brief (US_CSR) Break Received/End of Break */
#define US_CSR_OVRE (0x1u << 5) /**< \brief (US_CSR) Overrun Error */
#define US_CSR_FRAME (0x1u << 6) /**< \brief (US_CSR) Framing Error */
#define US_CSR_PARE (0x1u << 7) /**< \brief (US_CSR) Parity Error */
#define US_CSR_TIMEOUT (0x1u << 8) /**< \brief (US_CSR) Receiver Time-out */
#define US_CSR_TXEMPTY (0x1u << 9) /**< \brief (US_CSR) Transmitter Empty */
#define US_CSR_ITER (0x1u << 10) /**< \brief (US_CSR) Max Number of Repetitions Reached */
#define US_CSR_NACK (0x1u << 13) /**< \brief (US_CSR) Non AcknowledgeInterrupt */
#define US_CSR_CTSIC (0x1u << 19) /**< \brief (US_CSR) Clear to Send Input Change Flag */
#define US_CSR_CTS (0x1u << 23) /**< \brief (US_CSR) Image of CTS Input */
#define US_CSR_MANERR (0x1u << 24) /**< \brief (US_CSR) Manchester Error */
#define US_CSR_UNRE (0x1u << 10) /**< \brief (US_CSR) Underrun Error */
/* -------- US_RHR : (USART Offset: 0x0018) Receiver Holding Register -------- */
#define US_RHR_RXCHR_Pos 0
#define US_RHR_RXCHR_Msk (0x1ffu << US_RHR_RXCHR_Pos) /**< \brief (US_RHR) Received Character */
#define US_RHR_RXSYNH (0x1u << 15) /**< \brief (US_RHR) Received Sync */
/* -------- US_THR : (USART Offset: 0x001C) Transmitter Holding Register -------- */
#define US_THR_TXCHR_Pos 0
#define US_THR_TXCHR_Msk (0x1ffu << US_THR_TXCHR_Pos) /**< \brief (US_THR) Character to be Transmitted */
#define US_THR_TXCHR(value) ((US_THR_TXCHR_Msk & ((value) << US_THR_TXCHR_Pos)))
#define US_THR_TXSYNH (0x1u << 15) /**< \brief (US_THR) Sync Field to be Transmitted */
/* -------- US_BRGR : (USART Offset: 0x0020) Baud Rate Generator Register -------- */
#define US_BRGR_CD_Pos 0
#define US_BRGR_CD_Msk (0xffffu << US_BRGR_CD_Pos) /**< \brief (US_BRGR) Clock Divider */
#define US_BRGR_CD(value) ((US_BRGR_CD_Msk & ((value) << US_BRGR_CD_Pos)))
#define US_BRGR_FP_Pos 16
#define US_BRGR_FP_Msk (0x7u << US_BRGR_FP_Pos) /**< \brief (US_BRGR) Fractional Part */
#define US_BRGR_FP(value) ((US_BRGR_FP_Msk & ((value) << US_BRGR_FP_Pos)))
/* -------- US_RTOR : (USART Offset: 0x0024) Receiver Time-out Register -------- */
#define US_RTOR_TO_Pos 0
#define US_RTOR_TO_Msk (0xffffu << US_RTOR_TO_Pos) /**< \brief (US_RTOR) Time-out Value */
#define US_RTOR_TO(value) ((US_RTOR_TO_Msk & ((value) << US_RTOR_TO_Pos)))
/* -------- US_TTGR : (USART Offset: 0x0028) Transmitter Timeguard Register -------- */
#define US_TTGR_TG_Pos 0
#define US_TTGR_TG_Msk (0xffu << US_TTGR_TG_Pos) /**< \brief (US_TTGR) Timeguard Value */
#define US_TTGR_TG(value) ((US_TTGR_TG_Msk & ((value) << US_TTGR_TG_Pos)))
/* -------- US_FIDI : (USART Offset: 0x0040) FI DI Ratio Register -------- */
#define US_FIDI_FI_DI_RATIO_Pos 0
#define US_FIDI_FI_DI_RATIO_Msk (0xffffu << US_FIDI_FI_DI_RATIO_Pos) /**< \brief (US_FIDI) FI Over DI Ratio Value */
#define US_FIDI_FI_DI_RATIO(value) ((US_FIDI_FI_DI_RATIO_Msk & ((value) << US_FIDI_FI_DI_RATIO_Pos)))
/* -------- US_NER : (USART Offset: 0x0044) Number of Errors Register -------- */
#define US_NER_NB_ERRORS_Pos 0
#define US_NER_NB_ERRORS_Msk (0xffu << US_NER_NB_ERRORS_Pos) /**< \brief (US_NER) Number of Errors */
/* -------- US_IF : (USART Offset: 0x004C) IrDA Filter Register -------- */
#define US_IF_IRDA_FILTER_Pos 0
#define US_IF_IRDA_FILTER_Msk (0xffu << US_IF_IRDA_FILTER_Pos) /**< \brief (US_IF) IrDA Filter */
#define US_IF_IRDA_FILTER(value) ((US_IF_IRDA_FILTER_Msk & ((value) << US_IF_IRDA_FILTER_Pos)))
/* -------- US_MAN : (USART Offset: 0x0050) Manchester Encoder Decoder Register -------- */
#define US_MAN_TX_PL_Pos 0
#define US_MAN_TX_PL_Msk (0xfu << US_MAN_TX_PL_Pos) /**< \brief (US_MAN) Transmitter Preamble Length */
#define US_MAN_TX_PL(value) ((US_MAN_TX_PL_Msk & ((value) << US_MAN_TX_PL_Pos)))
#define US_MAN_TX_PP_Pos 8
#define US_MAN_TX_PP_Msk (0x3u << US_MAN_TX_PP_Pos) /**< \brief (US_MAN) Transmitter Preamble Pattern */
#define   US_MAN_TX_PP_ALL_ONE (0x0u << 8) /**< \brief (US_MAN) The preamble is composed of '1's */
#define   US_MAN_TX_PP_ALL_ZERO (0x1u << 8) /**< \brief (US_MAN) The preamble is composed of '0's */
#define   US_MAN_TX_PP_ZERO_ONE (0x2u << 8) /**< \brief (US_MAN) The preamble is composed of '01's */
#define   US_MAN_TX_PP_ONE_ZERO (0x3u << 8) /**< \brief (US_MAN) The preamble is composed of '10's */
#define US_MAN_TX_MPOL (0x1u << 12) /**< \brief (US_MAN) Transmitter Manchester Polarity */
#define US_MAN_RX_PL_Pos 16
#define US_MAN_RX_PL_Msk (0xfu << US_MAN_RX_PL_Pos) /**< \brief (US_MAN) Receiver Preamble Length */
#define US_MAN_RX_PL(value) ((US_MAN_RX_PL_Msk & ((value) << US_MAN_RX_PL_Pos)))
#define US_MAN_RX_PP_Pos 24
#define US_MAN_RX_PP_Msk (0x3u << US_MAN_RX_PP_Pos) /**< \brief (US_MAN) Receiver Preamble Pattern detected */
#define   US_MAN_RX_PP_ALL_ONE (0x0u << 24) /**< \brief (US_MAN) The preamble is composed of '1's */
#define   US_MAN_RX_PP_ALL_ZERO (0x1u << 24) /**< \brief (US_MAN) The preamble is composed of '0's */
#define   US_MAN_RX_PP_ZERO_ONE (0x2u << 24) /**< \brief (US_MAN) The preamble is composed of '01's */
#define   US_MAN_RX_PP_ONE_ZERO (0x3u << 24) /**< \brief (US_MAN) The preamble is composed of '10's */
#define US_MAN_RX_MPOL (0x1u << 28) /**< \brief (US_MAN) Receiver Manchester Polarity */
#define US_MAN_ONE (0x1u << 29) /**< \brief (US_MAN) Must Be Set to 1 */
#define US_MAN_DRIFT (0x1u << 30) /**< \brief (US_MAN) Drift Compensation */
/* -------- US_WPMR : (USART Offset: 0x00E4) Write Protect Mode Register -------- */
#define US_WPMR_WPEN (0x1u << 0) /**< \brief (US_WPMR) Write Protect Enable */
#define US_WPMR_WPKEY_Pos 8
#define US_WPMR_WPKEY_Msk (0xffffffu << US_WPMR_WPKEY_Pos) /**< \brief (US_WPMR) Write Protect KEY. */
#define   US_WPMR_WPKEY_PASSWD (0x555341u << 8) /**< \brief (US_WPMR) Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0. */
/* -------- US_WPSR : (USART Offset: 0x00E8) Write Protect Status Register -------- */
#define US_WPSR_WPVS (0x1u << 0) /**< \brief (US_WPSR) Write Protect Violation Status */
#define US_WPSR_WPVSRC_Pos 8
#define US_WPSR_WPVSRC_Msk (0xffffu << US_WPSR_WPVSRC_Pos) /**< \brief (US_WPSR) Write Protect Violation Source */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Watchdog Timer */
/* ============================================================================= */
/** \addtogroup SAMA5D4_WDT Watchdog Timer */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief Wdt hardware registers */
typedef struct {
  __O  uint32_t WDT_CR; /**< \brief (Wdt Offset: 0x00) Control Register */
  __IO uint32_t WDT_MR; /**< \brief (Wdt Offset: 0x04) Mode Register */
  __I  uint32_t WDT_SR; /**< \brief (Wdt Offset: 0x08) Status Register */
} Wdt;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- WDT_CR : (WDT Offset: 0x00) Control Register -------- */
#define WDT_CR_WDRSTT (0x1u << 0) /**< \brief (WDT_CR) Watchdog Restart */
#define WDT_CR_LOCKMR (0x1u << 4) /**< \brief (WDT_CR) Locks Mode Register Write Access */
#define WDT_CR_KEY_Pos 24
#define WDT_CR_KEY_Msk (0xffu << WDT_CR_KEY_Pos) /**< \brief (WDT_CR) Password. */
#define   WDT_CR_KEY_PASSWD (0xA5u << 24) /**< \brief (WDT_CR) Writing any other value in this field aborts the write operation. */
/* -------- WDT_MR : (WDT Offset: 0x04) Mode Register -------- */
#define WDT_MR_WDV_Pos 0
#define WDT_MR_WDV_Msk (0xfffu << WDT_MR_WDV_Pos) /**< \brief (WDT_MR) Watchdog Counter Value */
#define WDT_MR_WDV(value) ((WDT_MR_WDV_Msk & ((value) << WDT_MR_WDV_Pos)))
#define WDT_MR_WDFIEN (0x1u << 12) /**< \brief (WDT_MR) Watchdog Fault Interrupt Enable */
#define WDT_MR_WDRSTEN (0x1u << 13) /**< \brief (WDT_MR) Watchdog Reset Enable */
#define WDT_MR_WDRPROC (0x1u << 14) /**< \brief (WDT_MR) Watchdog Reset Processor */
#define WDT_MR_WDDIS (0x1u << 15) /**< \brief (WDT_MR) Watchdog Disable */
#define WDT_MR_WDD_Pos 16
#define WDT_MR_WDD_Msk (0xfffu << WDT_MR_WDD_Pos) /**< \brief (WDT_MR) Watchdog Delta Value */
#define WDT_MR_WDD(value) ((WDT_MR_WDD_Msk & ((value) << WDT_MR_WDD_Pos)))
#define WDT_MR_WDDBGHLT (0x1u << 28) /**< \brief (WDT_MR) Watchdog Debug Halt */
#define WDT_MR_WDIDLEHLT (0x1u << 29) /**< \brief (WDT_MR) Watchdog Idle Halt */
/* -------- WDT_SR : (WDT Offset: 0x08) Status Register -------- */
#define WDT_SR_WDUNF (0x1u << 0) /**< \brief (WDT_SR) Watchdog Underflow */
#define WDT_SR_WDERR (0x1u << 1) /**< \brief (WDT_SR) Watchdog Error */

/*@}*/

/* ============================================================================= */
/**  SOFTWARE API DEFINITION FOR Extensible DMA Controller */
/* ============================================================================= */
/** \addtogroup SAMA5D4_XDMAC Extensible DMA Controller */
/*@{*/

#if !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
/** \brief XdmacChid hardware registers */
typedef struct {
  __O  uint32_t XDMAC_CIE;     /**< \brief (XdmacChid Offset: 0x0) Channel Interrupt Enable Register */
  __O  uint32_t XDMAC_CID;     /**< \brief (XdmacChid Offset: 0x4) Channel Interrupt Disable Register */
  __O  uint32_t XDMAC_CIM;     /**< \brief (XdmacChid Offset: 0x8) Channel Interrupt Mask Register */
  __I  uint32_t XDMAC_CIS;     /**< \brief (XdmacChid Offset: 0xC) Channel Interrupt Status Register */
  __IO uint32_t XDMAC_CSA;     /**< \brief (XdmacChid Offset: 0x10) Channel Source Address Register */
  __IO uint32_t XDMAC_CDA;     /**< \brief (XdmacChid Offset: 0x14) Channel Destination Address Register */
  __IO uint32_t XDMAC_CNDA;    /**< \brief (XdmacChid Offset: 0x18) Channel Next Descriptor Address Register */
  __IO uint32_t XDMAC_CNDC;    /**< \brief (XdmacChid Offset: 0x1C) Channel Next Descriptor Control Register */
  __IO uint32_t XDMAC_CUBC;    /**< \brief (XdmacChid Offset: 0x20) Channel Microblock Control Register */
  __IO uint32_t XDMAC_CBC;     /**< \brief (XdmacChid Offset: 0x24) Channel Block Control Register */
  __IO uint32_t XDMAC_CC;      /**< \brief (XdmacChid Offset: 0x28) Channel Configuration Register */
  __IO uint32_t XDMAC_CDS_MSP; /**< \brief (XdmacChid Offset: 0x2C) Channel Data Stride Memory Set Pattern */
  __IO uint32_t XDMAC_CSUS;    /**< \brief (XdmacChid Offset: 0x30) Channel Source Microblock Stride */
  __IO uint32_t XDMAC_CDUS;    /**< \brief (XdmacChid Offset: 0x34) Channel Destination Microblock Stride */
  __I  uint32_t Reserved1[2];
} XdmacChid;
/** \brief Xdmac hardware registers */
#define XDMACCHID_NUMBER 16
typedef struct {
  __IO uint32_t  XDMAC_GTYPE;                  /**< \brief (Xdmac Offset: 0x00) Global Type register */
  __I  uint32_t  XDMAC_GCFG;                   /**< \brief (Xdmac Offset: 0x04) Global Configuration Register */
  __IO uint32_t  XDMAC_GWAC;                   /**< \brief (Xdmac Offset: 0x08) Global Weighted Arbiter Configuration Register */
  __O  uint32_t  XDMAC_GIE;                    /**< \brief (Xdmac Offset: 0x0C) Global Interrupt Enable Register */
  __O  uint32_t  XDMAC_GID;                    /**< \brief (Xdmac Offset: 0x10) Global Interrupt Disable Register */
  __I  uint32_t  XDMAC_GIM;                    /**< \brief (Xdmac Offset: 0x14) Global Interrupt Mask Register */
  __I  uint32_t  XDMAC_GIS;                    /**< \brief (Xdmac Offset: 0x18) Global Interrupt Status Register */
  __O  uint32_t  XDMAC_GE;                     /**< \brief (Xdmac Offset: 0x1C) Global Channel Enable Register */
  __O  uint32_t  XDMAC_GD;                     /**< \brief (Xdmac Offset: 0x20) Global Channel Disable Register */
  __I  uint32_t  XDMAC_GS;                     /**< \brief (Xdmac Offset: 0x24) Global Channel Status Register */
  __IO uint32_t  XDMAC_GRS;                    /**< \brief (Xdmac Offset: 0x28) Global Channel Read Suspend Register */
  __IO uint32_t  XDMAC_GWS;                    /**< \brief (Xdmac Offset: 0x2C) Global Channel Write Suspend Register */
  __O  uint32_t  XDMAC_GRWS;                   /**< \brief (Xdmac Offset: 0x30) Global Channel Read Write Suspend Register */
  __O  uint32_t  XDMAC_GRWR;                   /**< \brief (Xdmac Offset: 0x34) Global Channel Read Write Resume Register */
  __O  uint32_t  XDMAC_GSWR;                   /**< \brief (Xdmac Offset: 0x38) Global Channel Software Request Register */
  __I  uint32_t  XDMAC_GSWS;                   /**< \brief (Xdmac Offset: 0x3C) Global Channel Software Request Status Register */
  __O  uint32_t  XDMAC_GSWF;                   /**< \brief (Xdmac Offset: 0x40) Global Channel Software Flush Request Register */
  __I  uint32_t  Reserved1[3];
       XdmacChid XDMAC_CHID[XDMACCHID_NUMBER]; /**< \brief (Xdmac Offset: 0x50) chid = 0 .. 15 */
} Xdmac;
#endif /* !(defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* -------- XDMAC_GTYPE : (XDMAC Offset: 0x00) Global Type register -------- */
#define XDMAC_GTYPE_NB_CH_Pos 0
#define XDMAC_GTYPE_NB_CH_Msk (0x1fu << XDMAC_GTYPE_NB_CH_Pos) /**< \brief (XDMAC_GTYPE) Number of Channels Minus One */
#define XDMAC_GTYPE_NB_CH(value) ((XDMAC_GTYPE_NB_CH_Msk & ((value) << XDMAC_GTYPE_NB_CH_Pos)))
#define XDMAC_GTYPE_FIFO_SZ_Pos 5
#define XDMAC_GTYPE_FIFO_SZ_Msk (0x7ffu << XDMAC_GTYPE_FIFO_SZ_Pos) /**< \brief (XDMAC_GTYPE) Number of Bytes */
#define XDMAC_GTYPE_FIFO_SZ(value) ((XDMAC_GTYPE_FIFO_SZ_Msk & ((value) << XDMAC_GTYPE_FIFO_SZ_Pos)))
#define XDMAC_GTYPE_NB_REQ_Pos 16
#define XDMAC_GTYPE_NB_REQ_Msk (0x7fu << XDMAC_GTYPE_NB_REQ_Pos) /**< \brief (XDMAC_GTYPE) Number of Peripheral Requests Minus One */
#define XDMAC_GTYPE_NB_REQ(value) ((XDMAC_GTYPE_NB_REQ_Msk & ((value) << XDMAC_GTYPE_NB_REQ_Pos)))
/* -------- XDMAC_GCFG : (XDMAC Offset: 0x04) Global Configuration Register -------- */
#define XDMAC_GCFG_CGDISREG (0x1u << 0) /**< \brief (XDMAC_GCFG) Configuration Registers Clock Gating Disable */
#define XDMAC_GCFG_CGDISPIPE (0x1u << 1) /**< \brief (XDMAC_GCFG) Pipeline Clock Gating Disable */
#define XDMAC_GCFG_CGDISFIFO (0x1u << 2) /**< \brief (XDMAC_GCFG) FIFO Clock Gating Disable */
#define XDMAC_GCFG_CGDISIF (0x1u << 3) /**< \brief (XDMAC_GCFG) Bus Interface Clock Gating Disable */
#define XDMAC_GCFG_BXKBEN (0x1u << 8) /**< \brief (XDMAC_GCFG) Boundary X Kilo byte Enable */
/* -------- XDMAC_GWAC : (XDMAC Offset: 0x08) Global Weighted Arbiter Configuration Register -------- */
#define XDMAC_GWAC_PW0_Pos 0
#define XDMAC_GWAC_PW0_Msk (0xfu << XDMAC_GWAC_PW0_Pos) /**< \brief (XDMAC_GWAC) Pool Weight 0 */
#define XDMAC_GWAC_PW0(value) ((XDMAC_GWAC_PW0_Msk & ((value) << XDMAC_GWAC_PW0_Pos)))
#define XDMAC_GWAC_PW1_Pos 4
#define XDMAC_GWAC_PW1_Msk (0xfu << XDMAC_GWAC_PW1_Pos) /**< \brief (XDMAC_GWAC) Pool Weight 1 */
#define XDMAC_GWAC_PW1(value) ((XDMAC_GWAC_PW1_Msk & ((value) << XDMAC_GWAC_PW1_Pos)))
#define XDMAC_GWAC_PW2_Pos 8
#define XDMAC_GWAC_PW2_Msk (0xfu << XDMAC_GWAC_PW2_Pos) /**< \brief (XDMAC_GWAC) Pool Weight 2 */
#define XDMAC_GWAC_PW2(value) ((XDMAC_GWAC_PW2_Msk & ((value) << XDMAC_GWAC_PW2_Pos)))
#define XDMAC_GWAC_PW3_Pos 12
#define XDMAC_GWAC_PW3_Msk (0xfu << XDMAC_GWAC_PW3_Pos) /**< \brief (XDMAC_GWAC) Pool Weight 3 */
#define XDMAC_GWAC_PW3(value) ((XDMAC_GWAC_PW3_Msk & ((value) << XDMAC_GWAC_PW3_Pos)))
/* -------- XDMAC_GIE : (XDMAC Offset: 0x0C) Global Interrupt Enable Register -------- */
#define XDMAC_GIE_IE0 (0x1u << 0) /**< \brief (XDMAC_GIE) XDMAC Channel 0 Interrupt Enable Bit */
#define XDMAC_GIE_IE1 (0x1u << 1) /**< \brief (XDMAC_GIE) XDMAC Channel 1 Interrupt Enable Bit */
#define XDMAC_GIE_IE2 (0x1u << 2) /**< \brief (XDMAC_GIE) XDMAC Channel 2 Interrupt Enable Bit */
#define XDMAC_GIE_IE3 (0x1u << 3) /**< \brief (XDMAC_GIE) XDMAC Channel 3 Interrupt Enable Bit */
#define XDMAC_GIE_IE4 (0x1u << 4) /**< \brief (XDMAC_GIE) XDMAC Channel 4 Interrupt Enable Bit */
#define XDMAC_GIE_IE5 (0x1u << 5) /**< \brief (XDMAC_GIE) XDMAC Channel 5 Interrupt Enable Bit */
#define XDMAC_GIE_IE6 (0x1u << 6) /**< \brief (XDMAC_GIE) XDMAC Channel 6 Interrupt Enable Bit */
#define XDMAC_GIE_IE7 (0x1u << 7) /**< \brief (XDMAC_GIE) XDMAC Channel 7 Interrupt Enable Bit */
#define XDMAC_GIE_IE8 (0x1u << 8) /**< \brief (XDMAC_GIE) XDMAC Channel 8 Interrupt Enable Bit */
#define XDMAC_GIE_IE9 (0x1u << 9) /**< \brief (XDMAC_GIE) XDMAC Channel 9 Interrupt Enable Bit */
#define XDMAC_GIE_IE10 (0x1u << 10) /**< \brief (XDMAC_GIE) XDMAC Channel 10 Interrupt Enable Bit */
#define XDMAC_GIE_IE11 (0x1u << 11) /**< \brief (XDMAC_GIE) XDMAC Channel 11 Interrupt Enable Bit */
#define XDMAC_GIE_IE12 (0x1u << 12) /**< \brief (XDMAC_GIE) XDMAC Channel 12 Interrupt Enable Bit */
#define XDMAC_GIE_IE13 (0x1u << 13) /**< \brief (XDMAC_GIE) XDMAC Channel 13 Interrupt Enable Bit */
#define XDMAC_GIE_IE14 (0x1u << 14) /**< \brief (XDMAC_GIE) XDMAC Channel 14 Interrupt Enable Bit */
#define XDMAC_GIE_IE15 (0x1u << 15) /**< \brief (XDMAC_GIE) XDMAC Channel 15 Interrupt Enable Bit */
/* -------- XDMAC_GID : (XDMAC Offset: 0x10) Global Interrupt Disable Register -------- */
#define XDMAC_GID_ID0 (0x1u << 0) /**< \brief (XDMAC_GID) XDMAC Channel 0 Interrupt Disable Bit */
#define XDMAC_GID_ID1 (0x1u << 1) /**< \brief (XDMAC_GID) XDMAC Channel 1 Interrupt Disable Bit */
#define XDMAC_GID_ID2 (0x1u << 2) /**< \brief (XDMAC_GID) XDMAC Channel 2 Interrupt Disable Bit */
#define XDMAC_GID_ID3 (0x1u << 3) /**< \brief (XDMAC_GID) XDMAC Channel 3 Interrupt Disable Bit */
#define XDMAC_GID_ID4 (0x1u << 4) /**< \brief (XDMAC_GID) XDMAC Channel 4 Interrupt Disable Bit */
#define XDMAC_GID_ID5 (0x1u << 5) /**< \brief (XDMAC_GID) XDMAC Channel 5 Interrupt Disable Bit */
#define XDMAC_GID_ID6 (0x1u << 6) /**< \brief (XDMAC_GID) XDMAC Channel 6 Interrupt Disable Bit */
#define XDMAC_GID_ID7 (0x1u << 7) /**< \brief (XDMAC_GID) XDMAC Channel 7 Interrupt Disable Bit */
#define XDMAC_GID_ID8 (0x1u << 8) /**< \brief (XDMAC_GID) XDMAC Channel 8 Interrupt Disable Bit */
#define XDMAC_GID_ID9 (0x1u << 9) /**< \brief (XDMAC_GID) XDMAC Channel 9 Interrupt Disable Bit */
#define XDMAC_GID_ID10 (0x1u << 10) /**< \brief (XDMAC_GID) XDMAC Channel 10 Interrupt Disable Bit */
#define XDMAC_GID_ID11 (0x1u << 11) /**< \brief (XDMAC_GID) XDMAC Channel 11 Interrupt Disable Bit */
#define XDMAC_GID_ID12 (0x1u << 12) /**< \brief (XDMAC_GID) XDMAC Channel 12 Interrupt Disable Bit */
#define XDMAC_GID_ID13 (0x1u << 13) /**< \brief (XDMAC_GID) XDMAC Channel 13 Interrupt Disable Bit */
#define XDMAC_GID_ID14 (0x1u << 14) /**< \brief (XDMAC_GID) XDMAC Channel 14 Interrupt Disable Bit */
#define XDMAC_GID_ID15 (0x1u << 15) /**< \brief (XDMAC_GID) XDMAC Channel 15 Interrupt Disable Bit */
/* -------- XDMAC_GIM : (XDMAC Offset: 0x14) Global Interrupt Mask Register -------- */
#define XDMAC_GIM_IM0 (0x1u << 0) /**< \brief (XDMAC_GIM) XDMAC Channel 0 Interrupt Mask Bit */
#define XDMAC_GIM_IM1 (0x1u << 1) /**< \brief (XDMAC_GIM) XDMAC Channel 1 Interrupt Mask Bit */
#define XDMAC_GIM_IM2 (0x1u << 2) /**< \brief (XDMAC_GIM) XDMAC Channel 2 Interrupt Mask Bit */
#define XDMAC_GIM_IM3 (0x1u << 3) /**< \brief (XDMAC_GIM) XDMAC Channel 3 Interrupt Mask Bit */
#define XDMAC_GIM_IM4 (0x1u << 4) /**< \brief (XDMAC_GIM) XDMAC Channel 4 Interrupt Mask Bit */
#define XDMAC_GIM_IM5 (0x1u << 5) /**< \brief (XDMAC_GIM) XDMAC Channel 5 Interrupt Mask Bit */
#define XDMAC_GIM_IM6 (0x1u << 6) /**< \brief (XDMAC_GIM) XDMAC Channel 6 Interrupt Mask Bit */
#define XDMAC_GIM_IM7 (0x1u << 7) /**< \brief (XDMAC_GIM) XDMAC Channel 7 Interrupt Mask Bit */
#define XDMAC_GIM_IM8 (0x1u << 8) /**< \brief (XDMAC_GIM) XDMAC Channel 8 Interrupt Mask Bit */
#define XDMAC_GIM_IM9 (0x1u << 9) /**< \brief (XDMAC_GIM) XDMAC Channel 9 Interrupt Mask Bit */
#define XDMAC_GIM_IM10 (0x1u << 10) /**< \brief (XDMAC_GIM) XDMAC Channel 10 Interrupt Mask Bit */
#define XDMAC_GIM_IM11 (0x1u << 11) /**< \brief (XDMAC_GIM) XDMAC Channel 11 Interrupt Mask Bit */
#define XDMAC_GIM_IM12 (0x1u << 12) /**< \brief (XDMAC_GIM) XDMAC Channel 12 Interrupt Mask Bit */
#define XDMAC_GIM_IM13 (0x1u << 13) /**< \brief (XDMAC_GIM) XDMAC Channel 13 Interrupt Mask Bit */
#define XDMAC_GIM_IM14 (0x1u << 14) /**< \brief (XDMAC_GIM) XDMAC Channel 14 Interrupt Mask Bit */
#define XDMAC_GIM_IM15 (0x1u << 15) /**< \brief (XDMAC_GIM) XDMAC Channel 15 Interrupt Mask Bit */
/* -------- XDMAC_GIS : (XDMAC Offset: 0x18) Global Interrupt Status Register -------- */
#define XDMAC_GIS_IS0 (0x1u << 0) /**< \brief (XDMAC_GIS) XDMAC Channel 0 Interrupt Status Bit */
#define XDMAC_GIS_IS1 (0x1u << 1) /**< \brief (XDMAC_GIS) XDMAC Channel 1 Interrupt Status Bit */
#define XDMAC_GIS_IS2 (0x1u << 2) /**< \brief (XDMAC_GIS) XDMAC Channel 2 Interrupt Status Bit */
#define XDMAC_GIS_IS3 (0x1u << 3) /**< \brief (XDMAC_GIS) XDMAC Channel 3 Interrupt Status Bit */
#define XDMAC_GIS_IS4 (0x1u << 4) /**< \brief (XDMAC_GIS) XDMAC Channel 4 Interrupt Status Bit */
#define XDMAC_GIS_IS5 (0x1u << 5) /**< \brief (XDMAC_GIS) XDMAC Channel 5 Interrupt Status Bit */
#define XDMAC_GIS_IS6 (0x1u << 6) /**< \brief (XDMAC_GIS) XDMAC Channel 6 Interrupt Status Bit */
#define XDMAC_GIS_IS7 (0x1u << 7) /**< \brief (XDMAC_GIS) XDMAC Channel 7 Interrupt Status Bit */
#define XDMAC_GIS_IS8 (0x1u << 8) /**< \brief (XDMAC_GIS) XDMAC Channel 8 Interrupt Status Bit */
#define XDMAC_GIS_IS9 (0x1u << 9) /**< \brief (XDMAC_GIS) XDMAC Channel 9 Interrupt Status Bit */
#define XDMAC_GIS_IS10 (0x1u << 10) /**< \brief (XDMAC_GIS) XDMAC Channel 10 Interrupt Status Bit */
#define XDMAC_GIS_IS11 (0x1u << 11) /**< \brief (XDMAC_GIS) XDMAC Channel 11 Interrupt Status Bit */
#define XDMAC_GIS_IS12 (0x1u << 12) /**< \brief (XDMAC_GIS) XDMAC Channel 12 Interrupt Status Bit */
#define XDMAC_GIS_IS13 (0x1u << 13) /**< \brief (XDMAC_GIS) XDMAC Channel 13 Interrupt Status Bit */
#define XDMAC_GIS_IS14 (0x1u << 14) /**< \brief (XDMAC_GIS) XDMAC Channel 14 Interrupt Status Bit */
#define XDMAC_GIS_IS15 (0x1u << 15) /**< \brief (XDMAC_GIS) XDMAC Channel 15 Interrupt Status Bit */
/* -------- XDMAC_GE : (XDMAC Offset: 0x1C) Global Channel Enable Register -------- */
#define XDMAC_GE_EN0 (0x1u << 0) /**< \brief (XDMAC_GE) XDMAC Channel 0 Enable Bit */
#define XDMAC_GE_EN1 (0x1u << 1) /**< \brief (XDMAC_GE) XDMAC Channel 1 Enable Bit */
#define XDMAC_GE_EN2 (0x1u << 2) /**< \brief (XDMAC_GE) XDMAC Channel 2 Enable Bit */
#define XDMAC_GE_EN3 (0x1u << 3) /**< \brief (XDMAC_GE) XDMAC Channel 3 Enable Bit */
#define XDMAC_GE_EN4 (0x1u << 4) /**< \brief (XDMAC_GE) XDMAC Channel 4 Enable Bit */
#define XDMAC_GE_EN5 (0x1u << 5) /**< \brief (XDMAC_GE) XDMAC Channel 5 Enable Bit */
#define XDMAC_GE_EN6 (0x1u << 6) /**< \brief (XDMAC_GE) XDMAC Channel 6 Enable Bit */
#define XDMAC_GE_EN7 (0x1u << 7) /**< \brief (XDMAC_GE) XDMAC Channel 7 Enable Bit */
#define XDMAC_GE_EN8 (0x1u << 8) /**< \brief (XDMAC_GE) XDMAC Channel 8 Enable Bit */
#define XDMAC_GE_EN9 (0x1u << 9) /**< \brief (XDMAC_GE) XDMAC Channel 9 Enable Bit */
#define XDMAC_GE_EN10 (0x1u << 10) /**< \brief (XDMAC_GE) XDMAC Channel 10 Enable Bit */
#define XDMAC_GE_EN11 (0x1u << 11) /**< \brief (XDMAC_GE) XDMAC Channel 11 Enable Bit */
#define XDMAC_GE_EN12 (0x1u << 12) /**< \brief (XDMAC_GE) XDMAC Channel 12 Enable Bit */
#define XDMAC_GE_EN13 (0x1u << 13) /**< \brief (XDMAC_GE) XDMAC Channel 13 Enable Bit */
#define XDMAC_GE_EN14 (0x1u << 14) /**< \brief (XDMAC_GE) XDMAC Channel 14 Enable Bit */
#define XDMAC_GE_EN15 (0x1u << 15) /**< \brief (XDMAC_GE) XDMAC Channel 15 Enable Bit */
/* -------- XDMAC_GD : (XDMAC Offset: 0x20) Global Channel Disable Register -------- */
#define XDMAC_GD_DI0 (0x1u << 0) /**< \brief (XDMAC_GD) XDMAC Channel 0 Disable Bit */
#define XDMAC_GD_DI1 (0x1u << 1) /**< \brief (XDMAC_GD) XDMAC Channel 1 Disable Bit */
#define XDMAC_GD_DI2 (0x1u << 2) /**< \brief (XDMAC_GD) XDMAC Channel 2 Disable Bit */
#define XDMAC_GD_DI3 (0x1u << 3) /**< \brief (XDMAC_GD) XDMAC Channel 3 Disable Bit */
#define XDMAC_GD_DI4 (0x1u << 4) /**< \brief (XDMAC_GD) XDMAC Channel 4 Disable Bit */
#define XDMAC_GD_DI5 (0x1u << 5) /**< \brief (XDMAC_GD) XDMAC Channel 5 Disable Bit */
#define XDMAC_GD_DI6 (0x1u << 6) /**< \brief (XDMAC_GD) XDMAC Channel 6 Disable Bit */
#define XDMAC_GD_DI7 (0x1u << 7) /**< \brief (XDMAC_GD) XDMAC Channel 7 Disable Bit */
#define XDMAC_GD_DI8 (0x1u << 8) /**< \brief (XDMAC_GD) XDMAC Channel 8 Disable Bit */
#define XDMAC_GD_DI9 (0x1u << 9) /**< \brief (XDMAC_GD) XDMAC Channel 9 Disable Bit */
#define XDMAC_GD_DI10 (0x1u << 10) /**< \brief (XDMAC_GD) XDMAC Channel 10 Disable Bit */
#define XDMAC_GD_DI11 (0x1u << 11) /**< \brief (XDMAC_GD) XDMAC Channel 11 Disable Bit */
#define XDMAC_GD_DI12 (0x1u << 12) /**< \brief (XDMAC_GD) XDMAC Channel 12 Disable Bit */
#define XDMAC_GD_DI13 (0x1u << 13) /**< \brief (XDMAC_GD) XDMAC Channel 13 Disable Bit */
#define XDMAC_GD_DI14 (0x1u << 14) /**< \brief (XDMAC_GD) XDMAC Channel 14 Disable Bit */
#define XDMAC_GD_DI15 (0x1u << 15) /**< \brief (XDMAC_GD) XDMAC Channel 15 Disable Bit */
/* -------- XDMAC_GS : (XDMAC Offset: 0x24) Global Channel Status Register -------- */
#define XDMAC_GS_ST0 (0x1u << 0) /**< \brief (XDMAC_GS) XDMAC Channel 0 Status Bit */
#define XDMAC_GS_ST1 (0x1u << 1) /**< \brief (XDMAC_GS) XDMAC Channel 1 Status Bit */
#define XDMAC_GS_ST2 (0x1u << 2) /**< \brief (XDMAC_GS) XDMAC Channel 2 Status Bit */
#define XDMAC_GS_ST3 (0x1u << 3) /**< \brief (XDMAC_GS) XDMAC Channel 3 Status Bit */
#define XDMAC_GS_ST4 (0x1u << 4) /**< \brief (XDMAC_GS) XDMAC Channel 4 Status Bit */
#define XDMAC_GS_ST5 (0x1u << 5) /**< \brief (XDMAC_GS) XDMAC Channel 5 Status Bit */
#define XDMAC_GS_ST6 (0x1u << 6) /**< \brief (XDMAC_GS) XDMAC Channel 6 Status Bit */
#define XDMAC_GS_ST7 (0x1u << 7) /**< \brief (XDMAC_GS) XDMAC Channel 7 Status Bit */
#define XDMAC_GS_ST8 (0x1u << 8) /**< \brief (XDMAC_GS) XDMAC Channel 8 Status Bit */
#define XDMAC_GS_ST9 (0x1u << 9) /**< \brief (XDMAC_GS) XDMAC Channel 9 Status Bit */
#define XDMAC_GS_ST10 (0x1u << 10) /**< \brief (XDMAC_GS) XDMAC Channel 10 Status Bit */
#define XDMAC_GS_ST11 (0x1u << 11) /**< \brief (XDMAC_GS) XDMAC Channel 11 Status Bit */
#define XDMAC_GS_ST12 (0x1u << 12) /**< \brief (XDMAC_GS) XDMAC Channel 12 Status Bit */
#define XDMAC_GS_ST13 (0x1u << 13) /**< \brief (XDMAC_GS) XDMAC Channel 13 Status Bit */
#define XDMAC_GS_ST14 (0x1u << 14) /**< \brief (XDMAC_GS) XDMAC Channel 14 Status Bit */
#define XDMAC_GS_ST15 (0x1u << 15) /**< \brief (XDMAC_GS) XDMAC Channel 15 Status Bit */
/* -------- XDMAC_GRS : (XDMAC Offset: 0x28) Global Channel Read Suspend Register -------- */
#define XDMAC_GRS_RS0 (0x1u << 0) /**< \brief (XDMAC_GRS) XDMAC Channel 0 Read Suspend Bit */
#define XDMAC_GRS_RS1 (0x1u << 1) /**< \brief (XDMAC_GRS) XDMAC Channel 1 Read Suspend Bit */
#define XDMAC_GRS_RS2 (0x1u << 2) /**< \brief (XDMAC_GRS) XDMAC Channel 2 Read Suspend Bit */
#define XDMAC_GRS_RS3 (0x1u << 3) /**< \brief (XDMAC_GRS) XDMAC Channel 3 Read Suspend Bit */
#define XDMAC_GRS_RS4 (0x1u << 4) /**< \brief (XDMAC_GRS) XDMAC Channel 4 Read Suspend Bit */
#define XDMAC_GRS_RS5 (0x1u << 5) /**< \brief (XDMAC_GRS) XDMAC Channel 5 Read Suspend Bit */
#define XDMAC_GRS_RS6 (0x1u << 6) /**< \brief (XDMAC_GRS) XDMAC Channel 6 Read Suspend Bit */
#define XDMAC_GRS_RS7 (0x1u << 7) /**< \brief (XDMAC_GRS) XDMAC Channel 7 Read Suspend Bit */
#define XDMAC_GRS_RS8 (0x1u << 8) /**< \brief (XDMAC_GRS) XDMAC Channel 8 Read Suspend Bit */
#define XDMAC_GRS_RS9 (0x1u << 9) /**< \brief (XDMAC_GRS) XDMAC Channel 9 Read Suspend Bit */
#define XDMAC_GRS_RS10 (0x1u << 10) /**< \brief (XDMAC_GRS) XDMAC Channel 10 Read Suspend Bit */
#define XDMAC_GRS_RS11 (0x1u << 11) /**< \brief (XDMAC_GRS) XDMAC Channel 11 Read Suspend Bit */
#define XDMAC_GRS_RS12 (0x1u << 12) /**< \brief (XDMAC_GRS) XDMAC Channel 12 Read Suspend Bit */
#define XDMAC_GRS_RS13 (0x1u << 13) /**< \brief (XDMAC_GRS) XDMAC Channel 13 Read Suspend Bit */
#define XDMAC_GRS_RS14 (0x1u << 14) /**< \brief (XDMAC_GRS) XDMAC Channel 14 Read Suspend Bit */
#define XDMAC_GRS_RS15 (0x1u << 15) /**< \brief (XDMAC_GRS) XDMAC Channel 15 Read Suspend Bit */
/* -------- XDMAC_GWS : (XDMAC Offset: 0x2C) Global Channel Write Suspend Register -------- */
#define XDMAC_GWS_WS0 (0x1u << 0) /**< \brief (XDMAC_GWS) XDMAC Channel 0 Write Suspend Bit */
#define XDMAC_GWS_WS1 (0x1u << 1) /**< \brief (XDMAC_GWS) XDMAC Channel 1 Write Suspend Bit */
#define XDMAC_GWS_WS2 (0x1u << 2) /**< \brief (XDMAC_GWS) XDMAC Channel 2 Write Suspend Bit */
#define XDMAC_GWS_WS3 (0x1u << 3) /**< \brief (XDMAC_GWS) XDMAC Channel 3 Write Suspend Bit */
#define XDMAC_GWS_WS4 (0x1u << 4) /**< \brief (XDMAC_GWS) XDMAC Channel 4 Write Suspend Bit */
#define XDMAC_GWS_WS5 (0x1u << 5) /**< \brief (XDMAC_GWS) XDMAC Channel 5 Write Suspend Bit */
#define XDMAC_GWS_WS6 (0x1u << 6) /**< \brief (XDMAC_GWS) XDMAC Channel 6 Write Suspend Bit */
#define XDMAC_GWS_WS7 (0x1u << 7) /**< \brief (XDMAC_GWS) XDMAC Channel 7 Write Suspend Bit */
#define XDMAC_GWS_WS8 (0x1u << 8) /**< \brief (XDMAC_GWS) XDMAC Channel 8 Write Suspend Bit */
#define XDMAC_GWS_WS9 (0x1u << 9) /**< \brief (XDMAC_GWS) XDMAC Channel 9 Write Suspend Bit */
#define XDMAC_GWS_WS10 (0x1u << 10) /**< \brief (XDMAC_GWS) XDMAC Channel 10 Write Suspend Bit */
#define XDMAC_GWS_WS11 (0x1u << 11) /**< \brief (XDMAC_GWS) XDMAC Channel 11 Write Suspend Bit */
#define XDMAC_GWS_WS12 (0x1u << 12) /**< \brief (XDMAC_GWS) XDMAC Channel 12 Write Suspend Bit */
#define XDMAC_GWS_WS13 (0x1u << 13) /**< \brief (XDMAC_GWS) XDMAC Channel 13 Write Suspend Bit */
#define XDMAC_GWS_WS14 (0x1u << 14) /**< \brief (XDMAC_GWS) XDMAC Channel 14 Write Suspend Bit */
#define XDMAC_GWS_WS15 (0x1u << 15) /**< \brief (XDMAC_GWS) XDMAC Channel 15 Write Suspend Bit */
/* -------- XDMAC_GRWS : (XDMAC Offset: 0x30) Global Channel Read Write Suspend Register -------- */
#define XDMAC_GRWS_RWS0 (0x1u << 0) /**< \brief (XDMAC_GRWS) XDMAC Channel 0 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS1 (0x1u << 1) /**< \brief (XDMAC_GRWS) XDMAC Channel 1 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS2 (0x1u << 2) /**< \brief (XDMAC_GRWS) XDMAC Channel 2 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS3 (0x1u << 3) /**< \brief (XDMAC_GRWS) XDMAC Channel 3 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS4 (0x1u << 4) /**< \brief (XDMAC_GRWS) XDMAC Channel 4 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS5 (0x1u << 5) /**< \brief (XDMAC_GRWS) XDMAC Channel 5 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS6 (0x1u << 6) /**< \brief (XDMAC_GRWS) XDMAC Channel 6 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS7 (0x1u << 7) /**< \brief (XDMAC_GRWS) XDMAC Channel 7 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS8 (0x1u << 8) /**< \brief (XDMAC_GRWS) XDMAC Channel 8 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS9 (0x1u << 9) /**< \brief (XDMAC_GRWS) XDMAC Channel 9 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS10 (0x1u << 10) /**< \brief (XDMAC_GRWS) XDMAC Channel 10 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS11 (0x1u << 11) /**< \brief (XDMAC_GRWS) XDMAC Channel 11 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS12 (0x1u << 12) /**< \brief (XDMAC_GRWS) XDMAC Channel 12 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS13 (0x1u << 13) /**< \brief (XDMAC_GRWS) XDMAC Channel 13 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS14 (0x1u << 14) /**< \brief (XDMAC_GRWS) XDMAC Channel 14 Read Write Suspend Bit */
#define XDMAC_GRWS_RWS15 (0x1u << 15) /**< \brief (XDMAC_GRWS) XDMAC Channel 15 Read Write Suspend Bit */
/* -------- XDMAC_GRWR : (XDMAC Offset: 0x34) Global Channel Read Write Resume Register -------- */
#define XDMAC_GRWR_RWR0 (0x1u << 0) /**< \brief (XDMAC_GRWR) XDMAC Channel 0 Read Write Resume Bit */
#define XDMAC_GRWR_RWR1 (0x1u << 1) /**< \brief (XDMAC_GRWR) XDMAC Channel 1 Read Write Resume Bit */
#define XDMAC_GRWR_RWR2 (0x1u << 2) /**< \brief (XDMAC_GRWR) XDMAC Channel 2 Read Write Resume Bit */
#define XDMAC_GRWR_RWR3 (0x1u << 3) /**< \brief (XDMAC_GRWR) XDMAC Channel 3 Read Write Resume Bit */
#define XDMAC_GRWR_RWR4 (0x1u << 4) /**< \brief (XDMAC_GRWR) XDMAC Channel 4 Read Write Resume Bit */
#define XDMAC_GRWR_RWR5 (0x1u << 5) /**< \brief (XDMAC_GRWR) XDMAC Channel 5 Read Write Resume Bit */
#define XDMAC_GRWR_RWR6 (0x1u << 6) /**< \brief (XDMAC_GRWR) XDMAC Channel 6 Read Write Resume Bit */
#define XDMAC_GRWR_RWR7 (0x1u << 7) /**< \brief (XDMAC_GRWR) XDMAC Channel 7 Read Write Resume Bit */
#define XDMAC_GRWR_RWR8 (0x1u << 8) /**< \brief (XDMAC_GRWR) XDMAC Channel 8 Read Write Resume Bit */
#define XDMAC_GRWR_RWR9 (0x1u << 9) /**< \brief (XDMAC_GRWR) XDMAC Channel 9 Read Write Resume Bit */
#define XDMAC_GRWR_RWR10 (0x1u << 10) /**< \brief (XDMAC_GRWR) XDMAC Channel 10 Read Write Resume Bit */
#define XDMAC_GRWR_RWR11 (0x1u << 11) /**< \brief (XDMAC_GRWR) XDMAC Channel 11 Read Write Resume Bit */
#define XDMAC_GRWR_RWR12 (0x1u << 12) /**< \brief (XDMAC_GRWR) XDMAC Channel 12 Read Write Resume Bit */
#define XDMAC_GRWR_RWR13 (0x1u << 13) /**< \brief (XDMAC_GRWR) XDMAC Channel 13 Read Write Resume Bit */
#define XDMAC_GRWR_RWR14 (0x1u << 14) /**< \brief (XDMAC_GRWR) XDMAC Channel 14 Read Write Resume Bit */
#define XDMAC_GRWR_RWR15 (0x1u << 15) /**< \brief (XDMAC_GRWR) XDMAC Channel 15 Read Write Resume Bit */
/* -------- XDMAC_GSWR : (XDMAC Offset: 0x38) Global Channel Software Request Register -------- */
#define XDMAC_GSWR_SWREQ0 (0x1u << 0) /**< \brief (XDMAC_GSWR) XDMAC Channel 0 Software Request Bit */
#define XDMAC_GSWR_SWREQ1 (0x1u << 1) /**< \brief (XDMAC_GSWR) XDMAC Channel 1 Software Request Bit */
#define XDMAC_GSWR_SWREQ2 (0x1u << 2) /**< \brief (XDMAC_GSWR) XDMAC Channel 2 Software Request Bit */
#define XDMAC_GSWR_SWREQ3 (0x1u << 3) /**< \brief (XDMAC_GSWR) XDMAC Channel 3 Software Request Bit */
#define XDMAC_GSWR_SWREQ4 (0x1u << 4) /**< \brief (XDMAC_GSWR) XDMAC Channel 4 Software Request Bit */
#define XDMAC_GSWR_SWREQ5 (0x1u << 5) /**< \brief (XDMAC_GSWR) XDMAC Channel 5 Software Request Bit */
#define XDMAC_GSWR_SWREQ6 (0x1u << 6) /**< \brief (XDMAC_GSWR) XDMAC Channel 6 Software Request Bit */
#define XDMAC_GSWR_SWREQ7 (0x1u << 7) /**< \brief (XDMAC_GSWR) XDMAC Channel 7 Software Request Bit */
#define XDMAC_GSWR_SWREQ8 (0x1u << 8) /**< \brief (XDMAC_GSWR) XDMAC Channel 8 Software Request Bit */
#define XDMAC_GSWR_SWREQ9 (0x1u << 9) /**< \brief (XDMAC_GSWR) XDMAC Channel 9 Software Request Bit */
#define XDMAC_GSWR_SWREQ10 (0x1u << 10) /**< \brief (XDMAC_GSWR) XDMAC Channel 10 Software Request Bit */
#define XDMAC_GSWR_SWREQ11 (0x1u << 11) /**< \brief (XDMAC_GSWR) XDMAC Channel 11 Software Request Bit */
#define XDMAC_GSWR_SWREQ12 (0x1u << 12) /**< \brief (XDMAC_GSWR) XDMAC Channel 12 Software Request Bit */
#define XDMAC_GSWR_SWREQ13 (0x1u << 13) /**< \brief (XDMAC_GSWR) XDMAC Channel 13 Software Request Bit */
#define XDMAC_GSWR_SWREQ14 (0x1u << 14) /**< \brief (XDMAC_GSWR) XDMAC Channel 14 Software Request Bit */
#define XDMAC_GSWR_SWREQ15 (0x1u << 15) /**< \brief (XDMAC_GSWR) XDMAC Channel 15 Software Request Bit */
/* -------- XDMAC_GSWS : (XDMAC Offset: 0x3C) Global Channel Software Request Status Register -------- */
#define XDMAC_GSWS_SWRS0 (0x1u << 0) /**< \brief (XDMAC_GSWS) XDMAC Channel 0 Software Request Status Bit */
#define XDMAC_GSWS_SWRS1 (0x1u << 1) /**< \brief (XDMAC_GSWS) XDMAC Channel 1 Software Request Status Bit */
#define XDMAC_GSWS_SWRS2 (0x1u << 2) /**< \brief (XDMAC_GSWS) XDMAC Channel 2 Software Request Status Bit */
#define XDMAC_GSWS_SWRS3 (0x1u << 3) /**< \brief (XDMAC_GSWS) XDMAC Channel 3 Software Request Status Bit */
#define XDMAC_GSWS_SWRS4 (0x1u << 4) /**< \brief (XDMAC_GSWS) XDMAC Channel 4 Software Request Status Bit */
#define XDMAC_GSWS_SWRS5 (0x1u << 5) /**< \brief (XDMAC_GSWS) XDMAC Channel 5 Software Request Status Bit */
#define XDMAC_GSWS_SWRS6 (0x1u << 6) /**< \brief (XDMAC_GSWS) XDMAC Channel 6 Software Request Status Bit */
#define XDMAC_GSWS_SWRS7 (0x1u << 7) /**< \brief (XDMAC_GSWS) XDMAC Channel 7 Software Request Status Bit */
#define XDMAC_GSWS_SWRS8 (0x1u << 8) /**< \brief (XDMAC_GSWS) XDMAC Channel 8 Software Request Status Bit */
#define XDMAC_GSWS_SWRS9 (0x1u << 9) /**< \brief (XDMAC_GSWS) XDMAC Channel 9 Software Request Status Bit */
#define XDMAC_GSWS_SWRS10 (0x1u << 10) /**< \brief (XDMAC_GSWS) XDMAC Channel 10 Software Request Status Bit */
#define XDMAC_GSWS_SWRS11 (0x1u << 11) /**< \brief (XDMAC_GSWS) XDMAC Channel 11 Software Request Status Bit */
#define XDMAC_GSWS_SWRS12 (0x1u << 12) /**< \brief (XDMAC_GSWS) XDMAC Channel 12 Software Request Status Bit */
#define XDMAC_GSWS_SWRS13 (0x1u << 13) /**< \brief (XDMAC_GSWS) XDMAC Channel 13 Software Request Status Bit */
#define XDMAC_GSWS_SWRS14 (0x1u << 14) /**< \brief (XDMAC_GSWS) XDMAC Channel 14 Software Request Status Bit */
#define XDMAC_GSWS_SWRS15 (0x1u << 15) /**< \brief (XDMAC_GSWS) XDMAC Channel 15 Software Request Status Bit */
/* -------- XDMAC_GSWF : (XDMAC Offset: 0x40) Global Channel Software Flush Request Register -------- */
#define XDMAC_GSWF_SWF0 (0x1u << 0) /**< \brief (XDMAC_GSWF) XDMAC Channel 0 Software Flush Request Bit */
#define XDMAC_GSWF_SWF1 (0x1u << 1) /**< \brief (XDMAC_GSWF) XDMAC Channel 1 Software Flush Request Bit */
#define XDMAC_GSWF_SWF2 (0x1u << 2) /**< \brief (XDMAC_GSWF) XDMAC Channel 2 Software Flush Request Bit */
#define XDMAC_GSWF_SWF3 (0x1u << 3) /**< \brief (XDMAC_GSWF) XDMAC Channel 3 Software Flush Request Bit */
#define XDMAC_GSWF_SWF4 (0x1u << 4) /**< \brief (XDMAC_GSWF) XDMAC Channel 4 Software Flush Request Bit */
#define XDMAC_GSWF_SWF5 (0x1u << 5) /**< \brief (XDMAC_GSWF) XDMAC Channel 5 Software Flush Request Bit */
#define XDMAC_GSWF_SWF6 (0x1u << 6) /**< \brief (XDMAC_GSWF) XDMAC Channel 6 Software Flush Request Bit */
#define XDMAC_GSWF_SWF7 (0x1u << 7) /**< \brief (XDMAC_GSWF) XDMAC Channel 7 Software Flush Request Bit */
#define XDMAC_GSWF_SWF8 (0x1u << 8) /**< \brief (XDMAC_GSWF) XDMAC Channel 8 Software Flush Request Bit */
#define XDMAC_GSWF_SWF9 (0x1u << 9) /**< \brief (XDMAC_GSWF) XDMAC Channel 9 Software Flush Request Bit */
#define XDMAC_GSWF_SWF10 (0x1u << 10) /**< \brief (XDMAC_GSWF) XDMAC Channel 10 Software Flush Request Bit */
#define XDMAC_GSWF_SWF11 (0x1u << 11) /**< \brief (XDMAC_GSWF) XDMAC Channel 11 Software Flush Request Bit */
#define XDMAC_GSWF_SWF12 (0x1u << 12) /**< \brief (XDMAC_GSWF) XDMAC Channel 12 Software Flush Request Bit */
#define XDMAC_GSWF_SWF13 (0x1u << 13) /**< \brief (XDMAC_GSWF) XDMAC Channel 13 Software Flush Request Bit */
#define XDMAC_GSWF_SWF14 (0x1u << 14) /**< \brief (XDMAC_GSWF) XDMAC Channel 14 Software Flush Request Bit */
#define XDMAC_GSWF_SWF15 (0x1u << 15) /**< \brief (XDMAC_GSWF) XDMAC Channel 15 Software Flush Request Bit */
/* -------- XDMAC_CIE : (XDMAC Offset: N/A) Channel Interrupt Enable Register -------- */
#define XDMAC_CIE_BIE (0x1u << 0) /**< \brief (XDMAC_CIE) End of Block Interrupt Enable Bit */
#define XDMAC_CIE_LIE (0x1u << 1) /**< \brief (XDMAC_CIE) End of Linked List Interrupt Enable Bit */
#define XDMAC_CIE_DIE (0x1u << 2) /**< \brief (XDMAC_CIE) End of Disable Interrupt Enable Bit */
#define XDMAC_CIE_FIE (0x1u << 3) /**< \brief (XDMAC_CIE) End of Flush Interrupt Enable Bit */
#define XDMAC_CIE_RBIE (0x1u << 4) /**< \brief (XDMAC_CIE) Read Bus Error Interrupt Enable Bit */
#define XDMAC_CIE_WBIE (0x1u << 5) /**< \brief (XDMAC_CIE) Write Bus Error Interrupt Enable Bit */
#define XDMAC_CIE_ROIE (0x1u << 6) /**< \brief (XDMAC_CIE) Request Overflow Error Interrupt Enable Bit */
/* -------- XDMAC_CID : (XDMAC Offset: N/A) Channel Interrupt Disable Register -------- */
#define XDMAC_CID_BID (0x1u << 0) /**< \brief (XDMAC_CID) End of Block Interrupt Disable Bit */
#define XDMAC_CID_LID (0x1u << 1) /**< \brief (XDMAC_CID) End of Linked List Interrupt Disable Bit */
#define XDMAC_CID_DID (0x1u << 2) /**< \brief (XDMAC_CID) End of Disable Interrupt Disable Bit */
#define XDMAC_CID_FID (0x1u << 3) /**< \brief (XDMAC_CID) End of Flush Interrupt Disable Bit */
#define XDMAC_CID_RBEID (0x1u << 4) /**< \brief (XDMAC_CID) Read Bus Error Interrupt Disable Bit */
#define XDMAC_CID_WBEID (0x1u << 5) /**< \brief (XDMAC_CID) Write Bus Error Interrupt Disable Bit */
#define XDMAC_CID_ROID (0x1u << 6) /**< \brief (XDMAC_CID) Request Overflow Error Interrupt Disable Bit */
/* -------- XDMAC_CIM : (XDMAC Offset: N/A) Channel Interrupt Mask Register -------- */
#define XDMAC_CIM_BIM (0x1u << 0) /**< \brief (XDMAC_CIM) End of Block Interrupt Mask Bit */
#define XDMAC_CIM_LIM (0x1u << 1) /**< \brief (XDMAC_CIM) End of Linked List Interrupt Mask Bit */
#define XDMAC_CIM_DIM (0x1u << 2) /**< \brief (XDMAC_CIM) End of Disable Interrupt Mask bit */
#define XDMAC_CIM_FIM (0x1u << 3) /**< \brief (XDMAC_CIM) End of Flush Interrupt Mask Bit */
#define XDMAC_CIM_RBEIM (0x1u << 4) /**< \brief (XDMAC_CIM) Read Bus Error Interrupt Mask Bit */
#define XDMAC_CIM_WBEIM (0x1u << 5) /**< \brief (XDMAC_CIM) Write Bus Error Interrupt Mask Bit */
#define XDMAC_CIM_ROIM (0x1u << 6) /**< \brief (XDMAC_CIM) Request Overflow Error Interrupt Mask Bit */
/* -------- XDMAC_CIS : (XDMAC Offset: N/A) Channel Interrupt Status Register -------- */
#define XDMAC_CIS_BIS (0x1u << 0) /**< \brief (XDMAC_CIS) End of Block Interrupt Status Bit */
#define XDMAC_CIS_LIS (0x1u << 1) /**< \brief (XDMAC_CIS) End of Linked List Interrupt Status Bit */
#define XDMAC_CIS_DIS (0x1u << 2) /**< \brief (XDMAC_CIS) End of Disable Interrupt Status Bit */
#define XDMAC_CIS_FIS (0x1u << 3) /**< \brief (XDMAC_CIS) End of Flush Interrupt Status Bit */
#define XDMAC_CIS_RBEIS (0x1u << 4) /**< \brief (XDMAC_CIS) Read Bus Error Interrupt Status Bit */
#define XDMAC_CIS_WBEIS (0x1u << 5) /**< \brief (XDMAC_CIS) Write Bus Error Interrupt Status Bit */
#define XDMAC_CIS_ROIS (0x1u << 6) /**< \brief (XDMAC_CIS) Request Overflow Error Interrupt Status Bit */
/* -------- XDMAC_CSA : (XDMAC Offset: N/A) Channel Source Address Register -------- */
#define XDMAC_CSA_SA_Pos 0
#define XDMAC_CSA_SA_Msk (0xffffffffu << XDMAC_CSA_SA_Pos) /**< \brief (XDMAC_CSA) Channel x Source Address */
#define XDMAC_CSA_SA(value) ((XDMAC_CSA_SA_Msk & ((value) << XDMAC_CSA_SA_Pos)))
/* -------- XDMAC_CDA : (XDMAC Offset: N/A) Channel Destination Address Register -------- */
#define XDMAC_CDA_DA_Pos 0
#define XDMAC_CDA_DA_Msk (0xffffffffu << XDMAC_CDA_DA_Pos) /**< \brief (XDMAC_CDA) Channel x Destination Address */
#define XDMAC_CDA_DA(value) ((XDMAC_CDA_DA_Msk & ((value) << XDMAC_CDA_DA_Pos)))
/* -------- XDMAC_CNDA : (XDMAC Offset: N/A) Channel Next Descriptor Address Register -------- */
#define XDMAC_CNDA_NDAIF (0x1u << 0) /**< \brief (XDMAC_CNDA) Channel x Next Descriptor Interface */
#define XDMAC_CNDA_NDA_Pos 2
#define XDMAC_CNDA_NDA_Msk (0x3fffffffu << XDMAC_CNDA_NDA_Pos) /**< \brief (XDMAC_CNDA) Channel x Next Descriptor Address */
#define XDMAC_CNDA_NDA(value) ((XDMAC_CNDA_NDA_Msk & ((value) << XDMAC_CNDA_NDA_Pos)))
/* -------- XDMAC_CNDC : (XDMAC Offset: N/A) Channel Next Descriptor Control Register -------- */
#define XDMAC_CNDC_NDE (0x1u << 0) /**< \brief (XDMAC_CNDC) Channel x Next Descriptor Enable */
#define   XDMAC_CNDC_NDE_DSCR_FETCH_DIS (0x0u << 0) /**< \brief (XDMAC_CNDC) Descriptor fetch is disabled */
#define   XDMAC_CNDC_NDE_DSCR_FETCH_EN (0x1u << 0) /**< \brief (XDMAC_CNDC) Descriptor fetch is enabled */
#define XDMAC_CNDC_NDSUP (0x1u << 1) /**< \brief (XDMAC_CNDC) Channel x Next Descriptor Source Update */
#define   XDMAC_CNDC_NDSUP_SRC_PARAMS_UNCHANGED (0x0u << 1) /**< \brief (XDMAC_CNDC) Source parameters remain unchanged. */
#define   XDMAC_CNDC_NDSUP_SRC_PARAMS_UPDATED (0x1u << 1) /**< \brief (XDMAC_CNDC) Source parameters are updated when the descriptor is retrieved. */
#define XDMAC_CNDC_NDDUP (0x1u << 2) /**< \brief (XDMAC_CNDC) Channel x Next Descriptor Destination Update */
#define   XDMAC_CNDC_NDDUP_DST_PARAMS_UNCHANGED (0x0u << 2) /**< \brief (XDMAC_CNDC) Destination parameters remain unchanged. */
#define   XDMAC_CNDC_NDDUP_DST_PARAMS_UPDATED (0x1u << 2) /**< \brief (XDMAC_CNDC) Destination parameters are updated when the descriptor is retrieved. */
#define XDMAC_CNDC_NDVIEW_Pos 3
#define XDMAC_CNDC_NDVIEW_Msk (0x3u << XDMAC_CNDC_NDVIEW_Pos) /**< \brief (XDMAC_CNDC) Channel x Next Descriptor View */
#define   XDMAC_CNDC_NDVIEW_NDV0 (0x0u << 3) /**< \brief (XDMAC_CNDC) Next Descriptor View 0 */
#define   XDMAC_CNDC_NDVIEW_NDV1 (0x1u << 3) /**< \brief (XDMAC_CNDC) Next Descriptor View 1 */
#define   XDMAC_CNDC_NDVIEW_NDV2 (0x2u << 3) /**< \brief (XDMAC_CNDC) Next Descriptor View 2 */
#define   XDMAC_CNDC_NDVIEW_NDV3 (0x3u << 3) /**< \brief (XDMAC_CNDC) Next Descriptor View 3 */
/* -------- XDMAC_CUBC : (XDMAC Offset: N/A) Channel Microblock Control Register -------- */
#define XDMAC_CUBC_UBLEN_Pos 0
#define XDMAC_CUBC_UBLEN_Msk (0xffffffu << XDMAC_CUBC_UBLEN_Pos) /**< \brief (XDMAC_CUBC) Channel x Microblock Length */
#define XDMAC_CUBC_UBLEN(value) ((XDMAC_CUBC_UBLEN_Msk & ((value) << XDMAC_CUBC_UBLEN_Pos)))
/* -------- XDMAC_CBC : (XDMAC Offset: N/A) Channel Block Control Register -------- */
#define XDMAC_CBC_BLEN_Pos 0
#define XDMAC_CBC_BLEN_Msk (0xfffu << XDMAC_CBC_BLEN_Pos) /**< \brief (XDMAC_CBC) Channel x Block Length */
#define XDMAC_CBC_BLEN(value) ((XDMAC_CBC_BLEN_Msk & ((value) << XDMAC_CBC_BLEN_Pos)))
/* -------- XDMAC_CC : (XDMAC Offset: N/A) Channel Configuration Register -------- */
#define XDMAC_CC_TYPE (0x1u << 0) /**< \brief (XDMAC_CC) Channel x Transfer Type */
#define   XDMAC_CC_TYPE_MEM_TRAN (0x0u << 0) /**< \brief (XDMAC_CC) Self triggered mode (Memory to Memory Transfer). */
#define   XDMAC_CC_TYPE_PER_TRAN (0x1u << 0) /**< \brief (XDMAC_CC) Synchronized mode (Peripheral to Memory or Memory to Peripheral Transfer). */
#define XDMAC_CC_MBSIZE_Pos 1
#define XDMAC_CC_MBSIZE_Msk (0x3u << XDMAC_CC_MBSIZE_Pos) /**< \brief (XDMAC_CC) Channel x Memory Burst Size */
#define   XDMAC_CC_MBSIZE_SINGLE (0x0u << 1) /**< \brief (XDMAC_CC) The memory burst size is set to one. */
#define   XDMAC_CC_MBSIZE_FOUR (0x1u << 1) /**< \brief (XDMAC_CC) The memory burst size is set to four. */
#define   XDMAC_CC_MBSIZE_EIGHT (0x2u << 1) /**< \brief (XDMAC_CC) The memory burst size is set to eight. */
#define   XDMAC_CC_MBSIZE_SIXTEEN (0x3u << 1) /**< \brief (XDMAC_CC) The memory burst size is set to sixteen. */
#define XDMAC_CC_DSYNC (0x1u << 4) /**< \brief (XDMAC_CC) Channel x Synchronization */
#define   XDMAC_CC_DSYNC_PER2MEM (0x0u << 4) /**< \brief (XDMAC_CC) Peripheral to Memory transfer */
#define   XDMAC_CC_DSYNC_MEM2PER (0x1u << 4) /**< \brief (XDMAC_CC) Memory to Peripheral transfer */
#define XDMAC_CC_PROT (0x1u << 5) /**< \brief (XDMAC_CC) Channel x Protection */
#define   XDMAC_CC_PROT_SEC (0x0u << 5) /**< \brief (XDMAC_CC) Channel is secured */
#define   XDMAC_CC_PROT_UNSEC (0x1u << 5) /**< \brief (XDMAC_CC) Channel is unsecured */
#define XDMAC_CC_SWREQ (0x1u << 6) /**< \brief (XDMAC_CC) Channel x Software Request Trigger */
#define   XDMAC_CC_SWREQ_HWR_CONNECTED (0x0u << 6) /**< \brief (XDMAC_CC) Hardware request line is connected to the peripheral request line. */
#define   XDMAC_CC_SWREQ_SWR_CONNECTED (0x1u << 6) /**< \brief (XDMAC_CC) Software request is connected to the peripheral request line. */
#define XDMAC_CC_MEMSET (0x1u << 7) /**< \brief (XDMAC_CC) Channel x Fill Block of memory */
#define   XDMAC_CC_MEMSET_NORMAL_MODE (0x0u << 7) /**< \brief (XDMAC_CC) Memset is not activated */
#define   XDMAC_CC_MEMSET_HW_MODE (0x1u << 7) /**< \brief (XDMAC_CC) Sets the block of memory pointed by DA field to the specified value. This operation is performed on 8, 16 or 32 bits basis. */
#define XDMAC_CC_CSIZE_Pos 8
#define XDMAC_CC_CSIZE_Msk (0x7u << XDMAC_CC_CSIZE_Pos) /**< \brief (XDMAC_CC) Channel x Chunk Size */
#define   XDMAC_CC_CSIZE_CHK_1 (0x0u << 8) /**< \brief (XDMAC_CC) 1 data transferred */
#define   XDMAC_CC_CSIZE_CHK_2 (0x1u << 8) /**< \brief (XDMAC_CC) 2 data transferred */
#define   XDMAC_CC_CSIZE_CHK_4 (0x2u << 8) /**< \brief (XDMAC_CC) 4 data transferred */
#define   XDMAC_CC_CSIZE_CHK_8 (0x3u << 8) /**< \brief (XDMAC_CC) 8 data transferred */
#define   XDMAC_CC_CSIZE_CHK_16 (0x4u << 8) /**< \brief (XDMAC_CC) 16 data transferred */
#define XDMAC_CC_DWIDTH_Pos 11
#define XDMAC_CC_DWIDTH_Msk (0x3u << XDMAC_CC_DWIDTH_Pos) /**< \brief (XDMAC_CC) Channel x Data Width */
#define   XDMAC_CC_DWIDTH_BYTE (0x0u << 11) /**< \brief (XDMAC_CC) The data size is set to 8 bits */
#define   XDMAC_CC_DWIDTH_HALFWORD (0x1u << 11) /**< \brief (XDMAC_CC) The data size is set to 16 bits */
#define   XDMAC_CC_DWIDTH_WORD (0x2u << 11) /**< \brief (XDMAC_CC) The data size is set to 32 bits */
#define   XDMAC_CC_DWIDTH_DWORD (0x3u << 11) /**< \brief (XDMAC_CC) The data size is set to 64bits */
#define XDMAC_CC_SIF (0x1u << 13) /**< \brief (XDMAC_CC) Channel x Source Interface Identifier */
#define   XDMAC_CC_SIF_AHB_IF0 (0x0u << 13) /**< \brief (XDMAC_CC) The data is read through the system bus interface 0 */
#define   XDMAC_CC_SIF_AHB_IF1 (0x1u << 13) /**< \brief (XDMAC_CC) The data is read through the system bus interface 1 */
#define XDMAC_CC_DIF (0x1u << 14) /**< \brief (XDMAC_CC) Channel x Destination Interface Identifier */
#define   XDMAC_CC_DIF_AHB_IF0 (0x0u << 14) /**< \brief (XDMAC_CC) The data is written through the system bus interface 0 */
#define   XDMAC_CC_DIF_AHB_IF1 (0x1u << 14) /**< \brief (XDMAC_CC) The data is written though the system bus interface 1 */
#define XDMAC_CC_SAM_Pos 16
#define XDMAC_CC_SAM_Msk (0x3u << XDMAC_CC_SAM_Pos) /**< \brief (XDMAC_CC) Channel x Source Addressing Mode */
#define   XDMAC_CC_SAM_FIXED_AM (0x0u << 16) /**< \brief (XDMAC_CC) The address remains unchanged. */
#define   XDMAC_CC_SAM_INCREMENTED_AM (0x1u << 16) /**< \brief (XDMAC_CC) The addressing mode is incremented (the increment size is set to the data size). */
#define   XDMAC_CC_SAM_UBS_AM (0x2u << 16) /**< \brief (XDMAC_CC) The microblock stride is added at the microblock boundary. */
#define   XDMAC_CC_SAM_UBS_DS_AM (0x3u << 16) /**< \brief (XDMAC_CC) The microblock stride is added at the microblock boundary, the data stride is added at the data boundary. */
#define XDMAC_CC_DAM_Pos 18
#define XDMAC_CC_DAM_Msk (0x3u << XDMAC_CC_DAM_Pos) /**< \brief (XDMAC_CC) Channel x Destination Addressing Mode */
#define   XDMAC_CC_DAM_FIXED_AM (0x0u << 18) /**< \brief (XDMAC_CC) The address remains unchanged. */
#define   XDMAC_CC_DAM_INCREMENTED_AM (0x1u << 18) /**< \brief (XDMAC_CC) The addressing mode is incremented (the increment size is set to the data size). */
#define   XDMAC_CC_DAM_UBS_AM (0x2u << 18) /**< \brief (XDMAC_CC) The microblock stride is added at the microblock boundary. */
#define   XDMAC_CC_DAM_UBS_DS_AM (0x3u << 18) /**< \brief (XDMAC_CC) The microblock stride is added at the microblock boundary, the data stride is added at the data boundary. */
#define XDMAC_CC_INITD (0x1u << 21) /**< \brief (XDMAC_CC) Channel Initialization Terminated (this bit is read only) */
#define   XDMAC_CC_INITD_TERMINATED (0x0u << 21) /**< \brief (XDMAC_CC) Channel initialization is in progress. */
#define   XDMAC_CC_INITD_IN_PROGRESS (0x1u << 21) /**< \brief (XDMAC_CC) Channel initialization is completed. */
#define XDMAC_CC_RDIP (0x1u << 22) /**< \brief (XDMAC_CC) Read in Progress (this bit is read only) */
#define   XDMAC_CC_RDIP_DONE (0x0u << 22) /**< \brief (XDMAC_CC) No Active read transaction on the bus. */
#define   XDMAC_CC_RDIP_IN_PROGRESS (0x1u << 22) /**< \brief (XDMAC_CC) A read transaction is in progress. */
#define XDMAC_CC_WRIP (0x1u << 23) /**< \brief (XDMAC_CC) Write in Progress (this bit is read only) */
#define   XDMAC_CC_WRIP_DONE (0x0u << 23) /**< \brief (XDMAC_CC) No Active write transaction on the bus. */
#define   XDMAC_CC_WRIP_IN_PROGRESS (0x1u << 23) /**< \brief (XDMAC_CC) A Write transaction is in progress. */
#define XDMAC_CC_PERID_Pos 24
#define XDMAC_CC_PERID_Msk (0x7fu << XDMAC_CC_PERID_Pos) /**< \brief (XDMAC_CC) Channel x Peripheral Identifier */
#define XDMAC_CC_PERID(value) ((XDMAC_CC_PERID_Msk & ((value) << XDMAC_CC_PERID_Pos)))
/* -------- XDMAC_CDS_MSP : (XDMAC Offset: N/A) Channel Data Stride Memory Set Pattern -------- */
#define XDMAC_CDS_MSP_SDS_MSP_Pos 0
#define XDMAC_CDS_MSP_SDS_MSP_Msk (0xffffu << XDMAC_CDS_MSP_SDS_MSP_Pos) /**< \brief (XDMAC_CDS_MSP) Channel x Source Data stride or Memory Set Pattern */
#define XDMAC_CDS_MSP_SDS_MSP(value) ((XDMAC_CDS_MSP_SDS_MSP_Msk & ((value) << XDMAC_CDS_MSP_SDS_MSP_Pos)))
#define XDMAC_CDS_MSP_DDS_MSP_Pos 16
#define XDMAC_CDS_MSP_DDS_MSP_Msk (0xffffu << XDMAC_CDS_MSP_DDS_MSP_Pos) /**< \brief (XDMAC_CDS_MSP) Channel x Destination Data Stride or Memory Set Pattern */
#define XDMAC_CDS_MSP_DDS_MSP(value) ((XDMAC_CDS_MSP_DDS_MSP_Msk & ((value) << XDMAC_CDS_MSP_DDS_MSP_Pos)))
/* -------- XDMAC_CSUS : (XDMAC Offset: N/A) Channel Source Microblock Stride -------- */
#define XDMAC_CSUS_SUBS_Pos 0
#define XDMAC_CSUS_SUBS_Msk (0xffffffu << XDMAC_CSUS_SUBS_Pos) /**< \brief (XDMAC_CSUS) Channel x Source Microblock Stride */
#define XDMAC_CSUS_SUBS(value) ((XDMAC_CSUS_SUBS_Msk & ((value) << XDMAC_CSUS_SUBS_Pos)))
/* -------- XDMAC_CDUS : (XDMAC Offset: N/A) Channel Destination Microblock Stride -------- */
#define XDMAC_CDUS_DUBS_Pos 0
#define XDMAC_CDUS_DUBS_Msk (0xffffffu << XDMAC_CDUS_DUBS_Pos) /**< \brief (XDMAC_CDUS) Channel x Destination Microblock Stride */
#define XDMAC_CDUS_DUBS(value) ((XDMAC_CDUS_DUBS_Msk & ((value) << XDMAC_CDUS_DUBS_Pos)))

/*@}*/

/*@}*/

/* ************************************************************************** */
/*   REGISTER ACCESS DEFINITIONS FOR SAMA5D4 */
/* ************************************************************************** */
/** \addtogroup SAMA5D4_reg Registers Access Definitions */
/*@{*/

/* ========== Register definition for AXIMX peripheral ========== */
#if (defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
  #define REG_AXIMX_REMAP                 (0x00700000U) /**< \brief (AXIMX) Remap Register */
#else
  #define REG_AXIMX_REMAP (*(__O uint32_t*)0x00700000U) /**< \brief (AXIMX) Remap Register */
#endif /* (defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* ========== Register definition for SMD peripheral ========== */
#if (defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
  #define REG_SMD_CONTROL_POPR                  (0x00900000U) /**< \brief (SMD) SMD Control or Pop Removal register */
  #define REG_SMD_STATUS_REV                    (0x00900004U) /**< \brief (SMD) SMD Status or Revision register */
  #define REG_SMD_WRAP                          (0x00900008U) /**< \brief (SMD) SMD Wrapper/Power register */
  #define REG_SMD_DRIVE                         (0x0090000CU) /**< \brief (SMD) SMD Drive register */
  #define REG_SMD_ADJ                           (0x00900010U) /**< \brief (SMD) SMD Adjustment register */
  #define REG_SMD_VOLC                          (0x00900014U) /**< \brief (SMD) SMD Volume Control register */
  #define REG_SMD_AUX                           (0x00900018U) /**< \brief (SMD) SMD Auxiliary Control register */
  #define REG_SMD_PULSE                         (0x0090001CU) /**< \brief (SMD) SMD Pulse Dialing Control register */
  #define REG_SMD_DATA1_LOW                     (0x00900020U) /**< \brief (SMD) SMD Data1 Lower Byte register */
  #define REG_SMD_DATA1_UP                      (0x00900024U) /**< \brief (SMD) SMD Data1 Upper Byte register */
  #define REG_SMD_CTRL1_LOW                     (0x00900028U) /**< \brief (SMD) SMD Control1 Lower Byte register */
  #define REG_SMD_CTRL1_UP                      (0x0090002CU) /**< \brief (SMD) SMD Control1 Upper Byte register */
  #define REG_SMD_DATA2_LOW                     (0x00900030U) /**< \brief (SMD) SMD Data2 Lower Byte register */
  #define REG_SMD_DATA2_UP                      (0x00900034U) /**< \brief (SMD) SMD Data2 Upper Byte register */
  #define REG_SMD_CTRL2                         (0x00900038U) /**< \brief (SMD) SMD Control2 register */
  #define REG_SMD_PARAM_TRIM                    (0x0090003CU) /**< \brief (SMD) SMD Parameter register (for pulse dialing / ring detection) */
  #define REG_SMD_FIFOCTRL                      (0x00900040U) /**< \brief (SMD) SMD FIFO Control register */
  #define REG_SMD_IRQ_LVL                       (0x00900044U) /**< \brief (SMD) SMD FIFO IRQ Level register */
  #define REG_SMD_LPWR_CLK_ENB                  (0x00900048U) /**< \brief (SMD) SMD Low Power Clock Enable register */
  #define REG_SMD_TXDATA_FIFO                   (0x00900050U) /**< \brief (SMD) SMD Transmit Data FIFO */
  #define REG_SMD_RXDATA_FIFO                   (0x00900054U) /**< \brief (SMD) SMD Receive Data FIFO */
#else
  #define REG_SMD_CONTROL_POPR (*(__IO uint32_t*)0x00900000U) /**< \brief (SMD) SMD Control or Pop Removal register */
  #define REG_SMD_STATUS_REV   (*(__IO uint32_t*)0x00900004U) /**< \brief (SMD) SMD Status or Revision register */
  #define REG_SMD_WRAP         (*(__IO uint32_t*)0x00900008U) /**< \brief (SMD) SMD Wrapper/Power register */
  #define REG_SMD_DRIVE        (*(__IO uint32_t*)0x0090000CU) /**< \brief (SMD) SMD Drive register */
  #define REG_SMD_ADJ          (*(__IO uint32_t*)0x00900010U) /**< \brief (SMD) SMD Adjustment register */
  #define REG_SMD_VOLC         (*(__IO uint32_t*)0x00900014U) /**< \brief (SMD) SMD Volume Control register */
  #define REG_SMD_AUX          (*(__IO uint32_t*)0x00900018U) /**< \brief (SMD) SMD Auxiliary Control register */
  #define REG_SMD_PULSE        (*(__IO uint32_t*)0x0090001CU) /**< \brief (SMD) SMD Pulse Dialing Control register */
  #define REG_SMD_DATA1_LOW    (*(__IO uint32_t*)0x00900020U) /**< \brief (SMD) SMD Data1 Lower Byte register */
  #define REG_SMD_DATA1_UP     (*(__IO uint32_t*)0x00900024U) /**< \brief (SMD) SMD Data1 Upper Byte register */
  #define REG_SMD_CTRL1_LOW    (*(__IO uint32_t*)0x00900028U) /**< \brief (SMD) SMD Control1 Lower Byte register */
  #define REG_SMD_CTRL1_UP     (*(__IO uint32_t*)0x0090002CU) /**< \brief (SMD) SMD Control1 Upper Byte register */
  #define REG_SMD_DATA2_LOW    (*(__I  uint32_t*)0x00900030U) /**< \brief (SMD) SMD Data2 Lower Byte register */
  #define REG_SMD_DATA2_UP     (*(__I  uint32_t*)0x00900034U) /**< \brief (SMD) SMD Data2 Upper Byte register */
  #define REG_SMD_CTRL2        (*(__I  uint32_t*)0x00900038U) /**< \brief (SMD) SMD Control2 register */
  #define REG_SMD_PARAM_TRIM   (*(__IO uint32_t*)0x0090003CU) /**< \brief (SMD) SMD Parameter register (for pulse dialing / ring detection) */
  #define REG_SMD_FIFOCTRL     (*(__IO uint32_t*)0x00900040U) /**< \brief (SMD) SMD FIFO Control register */
  #define REG_SMD_IRQ_LVL      (*(__IO uint32_t*)0x00900044U) /**< \brief (SMD) SMD FIFO IRQ Level register */
  #define REG_SMD_LPWR_CLK_ENB (*(__IO uint32_t*)0x00900048U) /**< \brief (SMD) SMD Low Power Clock Enable register */
  #define REG_SMD_TXDATA_FIFO  (*(__O  uint32_t*)0x00900050U) /**< \brief (SMD) SMD Transmit Data FIFO */
  #define REG_SMD_RXDATA_FIFO  (*(__I  uint32_t*)0x00900054U) /**< \brief (SMD) SMD Receive Data FIFO */
#endif /* (defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* ========== Register definition for L2CC peripheral ========== */
#if (defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
  #define REG_L2CC_IDR                     (0x00A00000U) /**< \brief (L2CC) Cache ID Register */
  #define REG_L2CC_TYPR                    (0x00A00004U) /**< \brief (L2CC) Cache Type Register */
  #define REG_L2CC_CR                      (0x00A00100U) /**< \brief (L2CC) Control Register */
  #define REG_L2CC_ACR                     (0x00A00104U) /**< \brief (L2CC) Auxiliary Control Register */
  #define REG_L2CC_TRCR                    (0x00A00108U) /**< \brief (L2CC) Tag RAM Control Register */
  #define REG_L2CC_DRCR                    (0x00A0010CU) /**< \brief (L2CC) Data RAM Control Register */
  #define REG_L2CC_ECR                     (0x00A00200U) /**< \brief (L2CC) Event Counter Control Register */
  #define REG_L2CC_ECFGR1                  (0x00A00204U) /**< \brief (L2CC) Event Counter 1 Configuration Register */
  #define REG_L2CC_ECFGR0                  (0x00A00208U) /**< \brief (L2CC) Event Counter 0 Configuration Register */
  #define REG_L2CC_EVR1                    (0x00A0020CU) /**< \brief (L2CC) Event Counter 1 Value Register */
  #define REG_L2CC_EVR0                    (0x00A00210U) /**< \brief (L2CC) Event Counter 0 Value Register */
  #define REG_L2CC_IMR                     (0x00A00214U) /**< \brief (L2CC) Interrupt Mask Register */
  #define REG_L2CC_MISR                    (0x00A00218U) /**< \brief (L2CC) Masked Interrupt Status Register */
  #define REG_L2CC_RISR                    (0x00A0021CU) /**< \brief (L2CC) Raw Interrupt Status Register */
  #define REG_L2CC_ICR                     (0x00A00220U) /**< \brief (L2CC) Interrupt Clear Register */
  #define REG_L2CC_CSR                     (0x00A00730U) /**< \brief (L2CC) Cache Synchronization Register */
  #define REG_L2CC_IPALR                   (0x00A00770U) /**< \brief (L2CC) Invalidate Physical Address Line Register */
  #define REG_L2CC_IWR                     (0x00A0077CU) /**< \brief (L2CC) Invalidate Way Register */
  #define REG_L2CC_CPALR                   (0x00A007B0U) /**< \brief (L2CC) Clean Physical Address Line Register */
  #define REG_L2CC_CIR                     (0x00A007B8U) /**< \brief (L2CC) Clean Index Register */
  #define REG_L2CC_CWR                     (0x00A007BCU) /**< \brief (L2CC) Clean Way Register */
  #define REG_L2CC_CIPALR                  (0x00A007F0U) /**< \brief (L2CC) Clean Invalidate Physical Address Line Register */
  #define REG_L2CC_CIIR                    (0x00A007F8U) /**< \brief (L2CC) Clean Invalidate Index Register */
  #define REG_L2CC_CIWR                    (0x00A007FCU) /**< \brief (L2CC) Clean Invalidate Way Register */
  #define REG_L2CC_DLKR                    (0x00A00900U) /**< \brief (L2CC) Data Lockdown Register */
  #define REG_L2CC_ILKR                    (0x00A00904U) /**< \brief (L2CC) Instruction Lockdown Register */
  #define REG_L2CC_DCR                     (0x00A00F40U) /**< \brief (L2CC) Debug Control Register */
  #define REG_L2CC_PCR                     (0x00A00F60U) /**< \brief (L2CC) Prefetch Control Register */
  #define REG_L2CC_POWCR                   (0x00A00F80U) /**< \brief (L2CC) Power Control Register */
#else
  #define REG_L2CC_IDR    (*(__I  uint32_t*)0x00A00000U) /**< \brief (L2CC) Cache ID Register */
  #define REG_L2CC_TYPR   (*(__I  uint32_t*)0x00A00004U) /**< \brief (L2CC) Cache Type Register */
  #define REG_L2CC_CR     (*(__IO uint32_t*)0x00A00100U) /**< \brief (L2CC) Control Register */
  #define REG_L2CC_ACR    (*(__IO uint32_t*)0x00A00104U) /**< \brief (L2CC) Auxiliary Control Register */
  #define REG_L2CC_TRCR   (*(__IO uint32_t*)0x00A00108U) /**< \brief (L2CC) Tag RAM Control Register */
  #define REG_L2CC_DRCR   (*(__IO uint32_t*)0x00A0010CU) /**< \brief (L2CC) Data RAM Control Register */
  #define REG_L2CC_ECR    (*(__IO uint32_t*)0x00A00200U) /**< \brief (L2CC) Event Counter Control Register */
  #define REG_L2CC_ECFGR1 (*(__IO uint32_t*)0x00A00204U) /**< \brief (L2CC) Event Counter 1 Configuration Register */
  #define REG_L2CC_ECFGR0 (*(__IO uint32_t*)0x00A00208U) /**< \brief (L2CC) Event Counter 0 Configuration Register */
  #define REG_L2CC_EVR1   (*(__IO uint32_t*)0x00A0020CU) /**< \brief (L2CC) Event Counter 1 Value Register */
  #define REG_L2CC_EVR0   (*(__IO uint32_t*)0x00A00210U) /**< \brief (L2CC) Event Counter 0 Value Register */
  #define REG_L2CC_IMR    (*(__IO uint32_t*)0x00A00214U) /**< \brief (L2CC) Interrupt Mask Register */
  #define REG_L2CC_MISR   (*(__I  uint32_t*)0x00A00218U) /**< \brief (L2CC) Masked Interrupt Status Register */
  #define REG_L2CC_RISR   (*(__I  uint32_t*)0x00A0021CU) /**< \brief (L2CC) Raw Interrupt Status Register */
  #define REG_L2CC_ICR    (*(__IO uint32_t*)0x00A00220U) /**< \brief (L2CC) Interrupt Clear Register */
  #define REG_L2CC_CSR    (*(__IO uint32_t*)0x00A00730U) /**< \brief (L2CC) Cache Synchronization Register */
  #define REG_L2CC_IPALR  (*(__IO uint32_t*)0x00A00770U) /**< \brief (L2CC) Invalidate Physical Address Line Register */
  #define REG_L2CC_IWR    (*(__IO uint32_t*)0x00A0077CU) /**< \brief (L2CC) Invalidate Way Register */
  #define REG_L2CC_CPALR  (*(__IO uint32_t*)0x00A007B0U) /**< \brief (L2CC) Clean Physical Address Line Register */
  #define REG_L2CC_CIR    (*(__IO uint32_t*)0x00A007B8U) /**< \brief (L2CC) Clean Index Register */
  #define REG_L2CC_CWR    (*(__IO uint32_t*)0x00A007BCU) /**< \brief (L2CC) Clean Way Register */
  #define REG_L2CC_CIPALR (*(__IO uint32_t*)0x00A007F0U) /**< \brief (L2CC) Clean Invalidate Physical Address Line Register */
  #define REG_L2CC_CIIR   (*(__IO uint32_t*)0x00A007F8U) /**< \brief (L2CC) Clean Invalidate Index Register */
  #define REG_L2CC_CIWR   (*(__IO uint32_t*)0x00A007FCU) /**< \brief (L2CC) Clean Invalidate Way Register */
  #define REG_L2CC_DLKR   (*(__IO uint32_t*)0x00A00900U) /**< \brief (L2CC) Data Lockdown Register */
  #define REG_L2CC_ILKR   (*(__IO uint32_t*)0x00A00904U) /**< \brief (L2CC) Instruction Lockdown Register */
  #define REG_L2CC_DCR    (*(__IO uint32_t*)0x00A00F40U) /**< \brief (L2CC) Debug Control Register */
  #define REG_L2CC_PCR    (*(__IO uint32_t*)0x00A00F60U) /**< \brief (L2CC) Prefetch Control Register */
  #define REG_L2CC_POWCR  (*(__IO uint32_t*)0x00A00F80U) /**< \brief (L2CC) Power Control Register */
#endif /* (defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__)) */
/* ========== Register definition for LCDC peripheral ========== */
#if (defined(__ASSEMBLY__) || defined(__IAR_SYSTEMS_ASM__))
  #define REG_LCDC_LCDCFG0                   (0xF0000000U) /**< \brief (LCDC) LCD Controller Configuration Register 0 */
  #define REG_LCDC_LCDCFG1                   (0xF0000004U) /**< \brief (LCDC) LCD Controller Configuration Register 1 */
  #define REG_LCDC_LCDCFG2                   (0xF0000008U) /**< \brief (LCDC) LCD Controller Configuration Register 2 */
  #define REG_LCDC_LCDCFG3                   (0xF000000CU) /**< \brief (LCDC) LCD Controller Configuration Register 3 */
  #define REG_LCDC_LCDCFG4                   (0xF0000010U) /**< \brief (LCDC) LCD Controller Configuration Register 4 */
  #define REG_LCDC_LCDCFG5                   (0xF0000014U) /**< \brief (LCDC) LCD Controller Configuration Register 5 */
  #define REG_LCDC_LCDCFG6                   (0xF0000018U) /**< \brief (LCDC) LCD Controller Configuration Register 6 */
  #define REG_LCDC_LCDEN                     (0xF0000020U) /**< \brief (LCDC) LCD Controller Enable Register */
  #define REG_LCDC_LCDDIS                    (0xF0000024U) /**< \brief (LCDC) LCD Controller Disable Register */
  #define REG_LCDC_LCDSR                     (0xF0000028U) /**< \brief (LCDC) LCD Controller Status Register */
  #define REG_LCDC_LCDIER                    (0xF000002CU) /**< \brief (LCDC) LCD Controller Interrupt Enable Register */
  #define REG_LCDC_LCDIDR                    (0xF0000030U) /**< \brief (LCDC) LCD Controller Interrupt Disable Register */
  #define REG_LCDC_LCDIMR                    (0xF0000034U) /**< \brief (LCDC) LCD Controller Interrupt Mask Register */
  #define REG_LCDC_LCDISR                    (0xF0000038U) /**< \brief (LCDC) LCD Controller Interrupt Status Register */
  #define REG_LCDC_BASECHER                  (0xF0000040U) /**< \brief (LCDC) Base Layer Channel Enable Register */
  #define REG_LCDC_BASECHDR                  (0xF0000044U) /**< \brief (LCDC) Base Layer Channel Disable Register */
  #define REG_LCDC_BASECHSR                  (0xF0000048U) /**< \brief (LCDC) Base Layer Channel Status Register */
  #define REG_LCDC_BASEIER                   (0xF000004CU) /**< \brief (LCDC) Base Layer Interrupt Enable Register */
  #define REG_LCDC_BASEIDR                   (0xF0000050U) /**< \brief (LCDC) Base Layer Interrupt Disabled Register */
  #define REG_LCDC_BASEIMR                   (0xF0000054U) /**< \brief (LCDC) Base Layer Interrupt Mask Register */
  #define REG_LCDC_BASEISR                   (0xF0000058U) /**< \brief (LCDC) Base Layer Interrupt status Register */
  #define REG_LCDC_BASEHEAD                  (0xF000005CU) /**< \brief (LCDC) Base DMA Head Register */
  #define REG_LCDC_BASEADDR                  (0xF0000060U) /**< \brief (LCDC) Base DMA Address Register */
  #define REG_LCDC_BASECTRL                  (0xF0000064U) /**< \brief (LCDC) Base DMA Control Register */
  #define REG_LCDC_BASENEXT                  (0xF0000068U) /**< \brief (LCDC) Base DMA Next Register */
  #define REG_LCDC_BASECFG0                  (0xF000006CU) /**< \brief (LCDC) Base Configuration register 0 */
  #define REG_LCDC_BASECFG1                  (0xF0000070U) /**< \brief (LCDC) Base Configuration register 1 */
  #define REG_LCDC_BASECFG2                  (0xF0000074U) /**< \brief (LCDC) Base Configuration register 2 */
  #define REG_LCDC_BASECFG3                  (0xF0000078U) /**< \brief (LCDC) Base Configuration register 3 */
  #define REG_LCDC_BASECFG4                  (0xF000007CU) /**< \brief (LCDC) Base Configuration register 4 */
  #define REG_LCDC_BASECFG5                  (0xF0000080U) /**< \brief (LCDC) Base Configuration register 5 */
  #define REG_LCDC_BASECFG6                  (0xF0000084U) /**< \brief (LCDC) Base Configuration register 6 */
  #define REG_LCDC_OVRCHER1                  (0xF0000140U) /**< \brief (LCDC) Overlay 1 Channel Enable Register */
  #define REG_LCDC_OVRCHDR1                  (0xF0000144U) /**< \brief (LCDC) Overlay 1 Channel Disable Register */
  #define REG_LCDC_OVRCHSR1                  (0xF0000148U) /**< \brief (LCDC) Overlay 1 Channel Status Register */
  #define REG_LCDC_OVRIER1                   (0xF000014CU) /**< \brief (LCDC) Overlay 1 Interrupt Enable Register */
  #define REG_LCDC_OVRIDR1                   (0xF0000150U) /**< \brief (LCDC) Overlay 1 Interrupt Disable Register */
  #define REG_LCDC_OVRIMR1                   (0xF0000154U) /**< \brief (LCDC) Overlay 1 Interrupt Mask Register */
  #define REG_LCDC_OVRISR1                   (0xF0000158U) /**< \brief (LCDC) Overlay 1 Interrupt Status Register */
  #define REG_LCDC_OVRHEAD1                  (0xF000015CU) /**< \brief (LCDC) Overlay 1 DMA Head Register */
  #define REG_LCDC_OVRADDR1                  (0xF0000160U) /**< \brief (LCDC) Overlay 1 DMA Address Register */
  #define REG_LCDC_OVRCTRL1                  (0xF0000164U) /**< \brief (LCDC) Overlay 1 DMA Control Register */
  #define REG_LCDC_OVRNEXT1                  (0xF0000168U) /**< \brief (LCDC) Overlay 1 DMA Next Register */
  #define REG_LCDC_OVR1CFG0                  (0xF000016CU) /**< \brief (LCDC) Overlay 1 Configuration 0 Register */
  #define REG_LCDC_OVR1CFG1                  (0xF0000170U) /**< \brief (LCDC) Overlay 1 Configuration 1 Register */
  #define REG_LCDC_OVR1CFG2                  (0xF0000174U) /**< \brief (LCDC) Overlay 1 Configuration 2 Register */
  #define REG_LCDC_OVR1CFG3                  (0xF0000178U) /**< \brief (LCDC) Overlay 1 Configuration 3 Register */
  #define REG_LCDC_OVR1CFG4                  (0xF000017CU) /**< \brief (LCDC) Overlay 1 Configuration 4 Register */
  #define REG_LCDC_OVR1CFG5                  (0xF0000180U) /**< \brief (LCDC) Overlay 1 Configuration 5 Register */
  #define REG_LCDC_OVR1CFG6                  (0xF0000184U) /**< \brief (LCDC) Overlay 1 Configuration 6 Register */
  #define REG_LCDC_OVR1CFG7                  (0xF0000188U) /**< \brief (LCDC) Overlay 1 Configuration 7 Register */
  #define REG_LCDC_OVR1CFG8                  (0xF000018CU) /**< \brief (LCDC) Overlay 1 Configuration 8Register */
  #define REG_LCDC_OVR1CFG9                  (0xF0000190U) /**< \brief (LCDC) Overlay 1 Configuration 9 Register */
  #define REG_LCDC_OVRCHER2                  (0xF0000240U) /**< \brief (LCDC) Overlay 2 Channel Enable Register */
  #define REG_LCDC_OVRCHDR2                  (0xF0000244U) /**< \brief (LCDC) Overlay 2 Channel Disable Register */
  #define REG_LCDC_OVRCHSR2                  (0xF0000248U) /**< \brief (LCDC) Overlay 2 Channel Status Register */
  #define REG_LCDC_OVRIER2                   (0xF000024CU) /**< \brief (LCDC) Overlay 2 Interrupt Enable Register */
  #define REG_LCDC_OVRIDR2                   (0xF0000250U) /**< \brief (LCDC) Overlay 2 Interrupt Disable Register */
  #define REG_LCDC_OVRIMR2                   (0xF0000254U) /**< \brief (LCDC) Overlay 2 Interrupt Mask Register */
  #define REG_LCDC_OVRISR2                   (0xF0000258U) /**< \brief (LCDC) Overlay 2 Interrupt status Register */
  #define REG_LCDC_OVRHEAD2                  (0xF000025CU) /**< \brief (LCDC) Overlay 2 DMA Head Register */
  #define REG_LCDC_OVRADDR2                  (0xF0000260U) /**< \brief (LCDC) Overlay 2 DMA Address Register */
  #define REG_LCDC_OVRCTRL2                  (0xF0000264U) /**< \brief (LCDC) Overlay 2 DMA Control Register */
  #define REG_LCDC_OVRNEXT2                  (0xF0000268U) /**< \brief (LCDC) Overlay 2 DMA Next Register */
  #define REG_LCDC_OVR2CFG0                  (0xF000026CU) /**< \brief (LCDC) Overlay 2 Configuration 0 Register */
  #define REG_LCDC_OVR2CFG1                  (0xF0000270U) /**< \brief (LCDC) Overlay 2 Configuration 1 Register */
  #define REG_LCDC_OVR2CFG2                  (0xF0000274U) /**< \brief (LCDC) Overlay 2 Configuration 2 Register */
  #define REG_LCDC_OVR2CFG3                  (0xF0000278U) /**< \brief (LCDC) Overlay 2 Configuration 3 Register */
  #define REG_LCDC_OVR2CFG4                  (0xF000027CU) /**< \brief (LCDC) Overlay 2 Configuration 4 Register */
  #define REG_LCDC_OVR2CFG5                  (0xF0000280U) /**< \brief (LCDC) Overlay 2 Configuration 5 Register */
  #define REG_LCDC_OVR2CFG6                  (0xF0000284U) /**< \brief (LCDC) Overlay 2 Configuration 6 Register */
  #define REG_LCDC_OVR2CFG7                  (0xF0000288U) /**< \brief (LCDC) Overlay 2 Configuration 7 Register */
  #define REG_LCDC_OVR2CFG8                  (0xF000028CU) /**< \brief (LCDC) Overlay 2 Configuration 8 Register */
  #define REG_LCDC_OVR2CFG9                  (0xF0000290U) /**< \brief (LCDC) Overlay 2 Configuration 9 Register */
  #define REG_LCDC_HEOCHER                   (0xF0000340U) /**< \brief (LCDC) High-End Overlay Channel Enable Register */
  #define REG_LCDC_HEOCHDR                   (0xF0000344U) /**< \brief (LCDC) High-End Overlay Channel Disable Register */
  #define REG_LCDC_HEOCHSR                   (0xF0000348U) /**< \brief (LCDC) High-End Overlay Channel Status Register */
  #define REG_LCDC_HEOIER                    (0xF000034CU) /**< \brief (LCDC) High-End Overlay Interrupt Enable Register */
  #define REG_LCDC_HEOIDR                    (0xF0000350U) /**< \brief (LCDC) High-End Overlay Interrupt Disable Register */
  #define REG_LCDC_HEOIMR                    (0xF0000354U) /**< \brief (LCDC) High-End Overlay Interrupt Mask Register */
  #define REG_LCDC_HEOISR                    (0xF0000358U) /**< \brief (LCDC) High-End Overlay Interrupt Status Register */
  #define REG_LCDC_HEOHEAD                   (0xF000035CU) /**< \brief (LCDC) High-End Overlay DMA Head Register */
  #define REG_LCDC_HEOADDR                   (0xF0000360U) /**< \brief (LCDC) High-End Overlay DMA Address Register */
  #define REG_LCDC_HEOCTRL                   (0xF0000364U) /**< \brief (LCDC) High-End Overlay DMA Control Register */
  #define REG_LCDC_HEONEXT                   (0xF0000368U) /**< \brief (LCDC) High-End Overlay DMA Next Register */
  #define REG_LCDC_HEOUHEAD                  (0xF000036CU) /**< \brief (LCDC) High-End Overlay U DMA Head Register */
  #define REG_LCDC_HEOUADDR                  (0xF0000370U) /**< \brief (LCDC) High-End Overlay U DMA Address Register */
  #define REG_LCDC_HEOUCTRL                  (0xF0000374U) /**< \brief (LCDC) High-End Overlay U DMA control Register */
  #define REG_LCDC_HEOUNEXT                  (0xF0000378U) /**< \brief (LCDC) High-End Overlay U DMA Next Register */
  #define REG_LCDC_HEOVHEAD                  (0xF000037CU) /**< \brief (LCDC) High-End Overlay V DMA Head Register */
  #define REG_LCDC_HEOVADDR                  (0xF0000380U) /**< \brief (LCDC) High-End Overlay V DMA Address Register */
  #define REG_LCDC_HEOVCTRL                  (0xF0000384U) /**< \brief (LCDC) High-End Overlay V DMA control Register */
  #define REG_LCDC_HEOVNEXT                  (0xF0000388U) /**< \brief (LCDC) High-End Overlay VDMA Next Register */
  #define REG_LCDC_HEOCFG0                   (0xF000038CU) /**< \brief (LCDC) High-End Overlay Configuration Register 0 */
  #define REG_LCDC_HEOCFG1                   (0xF0000390U) /**< \brief (LCDC) High-End Overlay Configuration Register 1 */
  #define REG_LCDC_HEOCFG2                   (0xF0000394U) /**< \brief (LCDC) High-End Overlay Configuration Register 2 */
  #define REG_LCDC_HEOCFG3                   (0xF0000398U) /**< \brief (LCDC) High-End Overlay Configuration Register 3 */
  #define REG_LCDC_HEOCFG4                   (0xF000039CU) /**< \brief (LCDC) High-End Overlay Configuration Register 4 */
  #define REG_LCDC_HEOCFG5                   (0xF00003A0U) /**< \brief (LCDC) High-End Overlay Configuration Register 5 */
  #define REG_LCDC_HEOCFG6                   (0xF00003A4U) /**< \brief (LCDC) High-End Overlay Configuration Register 6 */
  #define REG_LCDC_HEOCFG7                   (0xF00003A8U) /**< \brief (LCDC) High-End Overlay Configuration Register 7 */
  #define REG_LCDC_HEOCFG8                   (0xF00003ACU) /**< \brief (LCDC) High-End Overlay Configuration Register 8 */
  #define REG_LCDC_HEOCFG9                   (0xF00003B0U) /**< \brief (LCDC) High-End Overlay Configuration Register 9 */
  #define REG_LCDC_HEOCFG10                  (0xF00003B4U) /**< \brief (LCDC) High-End Overlay Configuration Register 10 */
  #define REG_LCDC_HEOCFG11                  (0xF00003B8U) /**< \brief (LCDC) High-End Overlay Configuration Register 11 */
  #define REG_LCDC_HEOCFG12                  (0xF00003BCU) /**< \brief (LCDC) High-End Overlay Configuration Register 12 */
  #define REG_LCDC_HEOCFG13                  (0xF00003C0U) /**< \brief (LCDC) High-End Overlay Configuration Register 13 */
  #define REG_LCDC_HEOCFG14                  (0xF00003C4U) /**< \brief (LCDC) High-End Overlay Configuration Register 14 */
  #define REG_LCDC_HEOCFG15                  (0xF00003C8U) /**< \brief (LCDC) High-End Overlay Configuration Register 15 */
  #define REG_LCDC_HEOCFG16                  (0xF00003CCU) /**< \brief (LCDC) High-End Overlay Configuration Register 16 */
  #define REG_LCDC_HEOCFG17                  (0xF00003D0U) /**< \brief (LCDC) High-End Overlay Configuration Register 17 */
  #define REG_LCDC_HEOCFG18                  (0xF00003D4U) /**< \brief (LCDC) High-End Overlay Configuration Register 18 */
  #define REG_LCDC_HEOCFG19                  (0xF00003D8U) /**< \brief (LCDC) High-End Overlay Configuration Register 19 */
  #define REG_LCDC_HEOCFG20                  (0xF00003DCU) /**< \brief (LCDC) High-End Overlay Configuration Register 20 */
  #define REG_LCDC_HEOCFG21                  (0xF00003E0U) /**< \brief (LCDC) High-End Overlay Configuration Register 21 */
  #define REG_LCDC_HEOCFG22                  (0xF00003E4U) /**< \brief (LCDC) High-End Overlay Configuration Register 22 */
  #define REG_LCDC_HEOCFG23                  (0xF00003E8U) /**< \brief (LCDC) High-End Overlay Configuration Register 23 */
  #define REG_LCDC_HEOCFG24                  (0xF00003ECU) /**< \brief (LCDC) High-End Overlay Configuration Register 24 */
  #define REG_LCDC_HEOCFG25                  (0xF00003F0U) /**< \brief (LCDC) High-End Overlay Configuration Register 25 */
  #define REG_LCDC_HEOCFG26                  (0xF00003F4U) /**< \brief (LCDC) High-End Overlay Configuration Register 26 */
  #define REG_LCDC_HEOCFG27                  (0xF00003F8U) /**< \brief (LCDC) High-End Overlay Configuration Register 27 */
  #define REG_LCDC_HEOCFG28                  (0xF00003FCU) /**< \brief (LCDC) High-End Overlay Configuration Register 28 */
  #define REG_LCDC_HEOCFG29                  (0xF0000400U) /**< \brief (LCDC) High-End Overlay Configuration Register 29 */
  #define REG_LCDC_HEOCFG30                  (0xF0000404U) /**< \brief (LCDC) High-End Overlay Configuration Register 30 */
  #define REG_LCDC_HEOCFG31                  (0xF0000408U) /**< \brief (LCDC) High-End Overlay Configuration Register 31 */
  #define REG_LCDC_HEOCFG32                  (0xF000040CU) /**< \brief (LCDC) High-End Overlay Configuration Register 32 */
  #define REG_LCDC_HEOCFG33                  (0xF0000410U) /**< \brief (LCDC) High-End Overlay Configuration Register 33 */
  #define REG_LCDC_HEOCFG34                  (0xF0000414U) /**< \brief (LCDC) High-End Overlay Configuration Register 34 */
  #define REG_LCDC_HEOCFG35                  (0xF0000418U) /**< \brief (LCDC) High-End Overlay Configuration Register 35 */
  #define REG_LCDC_HEOCFG36                  (0xF000041CU) /**< \brief (LCDC) High-End Overlay Configuration Register 36 */
  #define REG_LCDC_HEOCFG37                  (0xF0000420U) /**< \brief (LCDC) High-End Overlay Configuration Register 37 */
  #define REG_LCDC_HEOCFG38                  (0xF0000424U) /**< \brief (LCDC) High-End Overlay Configuration Register 38 */
  #define REG_LCDC_HEOCFG39                  (0xF0000428U) /**< \brief (LCDC) High-End Overlay Configuration Register 39 */
  #define REG_LCDC_HEOCFG40                  (0xF000042CU) /**< \brief (LCDC) High-End Overlay Configuration Register 40 */
  #define REG_LCDC_HEOCFG41                  (0xF0000430U) /**< \brief (LCDC) High-End Overlay Configuration Register 41 */
  #define REG_LCDC_BASECLUT                  (0xF0000600U) /**< \brief (LCDC) Base CLUT Register */
  #define REG_LCDC_OVR1CLUT                  (0xF0000A00U) /**< \brief (LCDC) Overlay 1 CLUT Register */
  #define REG_LCDC_OVR2CLUT                  (0xF0000E00U) /**< \brief (LCDC) Overlay 2 CLUT Register */
  #define REG_LCDC_HEOCLUT                   (0xF0001200U) /**< \brief (LCDC) High End Overlay CLUT Register */
#else
  #define REG_LCDC_LCDCFG0  (*(__IO uint32_t*)0xF0000000U) /**< \brief (LCDC) LCD Controller Configuration Register 0 */
  #define REG_LCDC_LCDCFG1  (*(__IO uint32_t*)0xF0000004U) /**< \brief (LCDC) LCD Controller Configuration Register 1 */
  #define REG_LCDC_LCDCFG2  (*(__IO uint32_t*)0xF0000008U) /**< \brief (LCDC) LCD Controller Configuration Register 2 */
  #define REG_LCDC_LCDCFG3  (*(__IO uint32_t*)0xF000000CU) /**< \brief (LCDC) LCD Controller Configuration Register 3 */
  #define REG_LCDC_LCDCFG4  (*(__IO uint32_t*)0xF0000010U) /**< \brief (LCDC) LCD Controller Configuration Register 4 */
  #define REG_LCDC_LCDCFG5  (*(__IO uint32_t*)0xF0000014U) /**< \brief (LCDC) LCD Controller Configuration Register 5 */
  #define REG_LCDC_LCDCFG6  (*(__IO uint32_t*)0xF0000018U) /**< \brief (LCDC) LCD Controller Configuration Register 6 */
  #define REG_LCDC_LCDEN    (*(__O  uint32_t*)0xF0000020U) /**< \brief (LCDC) LCD Controller Enable Register */
  #define REG_LCDC_LCDDIS   (*(__O  uint32_t*)0xF0000024U) /**< \brief (LCDC) LCD Controller Disable Register */
  #define REG_LCDC_LCDSR    (*(__I  uint32_t*)0xF0000028U) /**< \brief (LCDC) LCD Controller Status Register */
  #define REG_LCDC_LCDIER   (*(__O  uint32_t*)0xF000002CU) /**< \brief (LCDC) LCD Controller Interrupt Enable Register */
  #define REG_LCDC_LCDIDR   (*(__O  uint32_t*)0xF0000030U) /**< \brief (LCDC) LCD Controller Interrupt Disable Register */
  #define REG_LCDC_LCDIMR   (*(__I  uint32_t*)0xF0000034U) /**< \brief (LCDC) LCD Controller Interrupt Mask Register */
  #define REG_LCDC_LCDISR   (*(__I  uint32_t*)0xF0000038U) /**< \brief (LCDC) LCD Controller Interrupt Status Register */
  #define REG_LCDC_BASECHER (*(__O  uint32_t*)0xF0000040U) /**< \brief (LCDC) Base Layer Channel Enable Register */
  #define REG_LCDC_BASECHDR (*(__O  uint32_t*)0xF0000044U) /**< \brief (LCDC) Base Layer Channel Disable Register */
  #define REG_LCDC_BASECHSR (*(__I  uint32_t*)0xF0000048U) /**< \brief (LCDC) Base Layer Channel Status Register */
  #define REG_LCDC_BASEIER  (*(__O  uint32_t*)0xF000004CU) /**< \brief (LCDC) Base Layer Interrupt Enable Register */
  #define REG_LCDC_BASEIDR  (*(__O  uint32_t*)0xF0000050U) /**< \brief (LCDC) Base Layer Interrupt Disabled Register */
  #define REG_LCDC_BASEIMR  (*(__I  uint32_t*)0xF0000054U) /**< \brief (LCDC) Base Layer Interrupt Mask Register */
  #define REG_LCDC_BASEISR  (*(__I  uint32_t*)0xF0000058U) /**< \brief (LCDC) Base Layer Interrupt status Register */
  #define REG_LCDC_BASEHEAD (*(__IO uint32_t*)0xF000005CU) /**< \brief (LCDC) Base DMA Head Register */
  #define REG_LCDC_BASEADDR (*(__IO uint32_t*)0xF0000060U) /**< \brief (LCDC) Base DMA Address Register */
  #define REG_LCDC_BASECTRL (*(__IO uint32_t*)0xF0000064U) /**< \brief (LCDC) Base DMA Control Register */
  #define REG_LCDC_BASENEXT (*(__IO uint32_t*)0xF0000068U) /**< \brief (LCDC) Base DMA Next Register */
  #define REG_LCDC_BASECFG0 (*(__IO uint32_t*)0xF000006CU) /**< \brief (LCDC) Base Configuration register 0 */
  #define REG_LCDC_BASECFG1 (*(__IO uint32_t*)0xF0000070U) /**< \brief (LCDC) Base Configuration register 1 */
  #define REG_LCDC_BASECFG2 (*(__IO uint32_t*)0xF0000074U) /**< \brief (LCDC) Base Configuration register 2 */
  #define REG_LCDC_BASECFG3 (*(__IO uint32_t*)0xF0000078U) /**< \brief (LCDC) Base Configuration register 3 */
  #define REG_LCDC_BASECFG4 (*(__IO uint32_t*)0xF000007CU) /**< \brief (LCDC) Base Configuration register 4 */
  #define REG_LCDC_BASECFG5 (*(__IO uint32_t*)0xF0000080U) /**< \brief (LCDC) Base Configuration register 5 */
  #define REG_LCDC_BASECFG6 (*(__IO uint32_t*)0xF0000084U) /**< \brief (LCDC) Base Configuration register 6 */
  #define REG_LCDC_OVRCHER1 (*(__O  uint32_t*)0xF0000140U) /**< \brief (LCDC) Overlay 1 Channel Enable Register */
  #define REG_LCDC_OVRCHDR1 (*(__O  uint32_t*)0xF0000144U) /**< \brief (LCDC) Overlay 1 Channel Disable Register */
  #define REG_LCDC_OVRCHSR1 (*(__I  uint32_t*)0xF0000148U) /**< \brief (LCDC) Overlay 1 Channel Status Register */
  #define REG_LCDC_OVRIER1  (*(__O  uint32_t*)0xF000014CU) /**< \brief (LCDC) Overlay 1 Interrupt Enable Register */
  #define REG_LCDC_OVRIDR1  (*(__O  uint32_t*)0xF0000150U) /**< \brief (LCDC) Overlay 1 Interrupt Disable Register */
  #define REG_LCDC_OVRIMR1  (*(__I  uint32_t*)0xF0000154U) /**< \brief (LCDC) Overlay 1 Interrupt Mask Register */
  #define REG_LCDC_OVRISR1  (*(__I  uint32_t*)0xF0000158U) /**< \brief (LCDC) Overlay 1 Interrupt Status Register */
  #define REG_LCDC_OVRHEAD1 (*(__IO uint32_t*)0xF000015CU) /**< \brief (LCDC) Overlay 1 DMA Head Register */
  #define REG_LCDC_OVRADDR1 (*(__IO uint32_t*)0xF0000160U) /**< \brief (LCDC) Overlay 1 DMA Address Register */
  #define REG_LCDC_OVRCTRL1 (*(__IO uint32_t*)0xF0000164U) /**< \brief (LCDC) Overlay 1 DMA Control Register */
  #define REG_LCDC_OVRNEXT1 (*(__IO uint32_t*)0xF0000168U) /**< \brief (LCDC) Overlay 1 DMA Next Register */
  #define REG_LCDC_OVR1CFG0 (*(__IO uint32_t*)0xF000016CU) /**< \brief (LCDC) Overlay 1 Configuration 0 Register */
  #define REG_LCDC_OVR1CFG1 (*(__IO uint32_t*)0xF0000170U) /**< \brief (LCDC) Overlay 1 Configuration 1 Register */
  #define REG_LCDC_OVR1CFG2 (*(__IO uint32_t*)0xF0000174U) /**< \brief (LCDC) Overlay 1 Configuration 2 Register */
  #define REG_LCDC_OVR1CFG3 (*(__IO uint32_t*)0xF0000178U) /**< \brief (LCDC) Overlay 1 Configuration 3 Register */
  #define REG_LCDC_OVR1CFG4 (*(__IO uint32_t*)0xF000017CU) /**< \brief (LCDC) Overlay 1 Configuration 4 Register */
  #define REG_LCDC_OVR1CFG5 (*(__IO uint32_t*)0xF0000180U) /**< \brief (LCDC) Overlay 1 Configuration 5 Register */
  #define REG_LCDC_OVR1CFG6 (*(__IO uint32_t*)0xF0000184U) /**< \brief (LCDC) Overlay 1 Configuration 6 Register */
  #define REG_LCDC_OVR1CFG7 (*(__IO uint32_t*)0xF0000188U) /**< \brief (LCDC) Overlay 1 Configuration 7 Register */
  #define REG_LCDC_OVR1CFG8 (*(__IO uint32_t*)0xF000018CU) /**< \brief (LCDC) Overlay 1 Configuration 8Register */
  #define REG_LCDC_OVR1CFG9 (*(__IO uint32_t*)0xF0000190U) /**< \brief (LCDC) Overlay 1 Configuration 9 Register */
  #define REG_LCDC_OVRCHER2 (*(__O  uint32_t*)0xF0000240U) /**< \brief (LCDC) Overlay 2 Channel Enable Register */
  #define REG_LCDC_OVRCHDR2 (*(__O  uint32_t*)0xF0000244U) /**< \brief (LCDC) Overlay 2 Channel Disable Register */
  #define REG_LCDC_OVRCHSR2 (*(__I  uint32_t*)0xF0000248U) /**< \brief (LCDC) Overlay 2 Channel Status Register */
  #define REG_LCDC_OVRIER2  (*(__O  uint32_t*)0xF000024CU) /**< \brief (LCDC) Overlay 2 Interrupt Enable Register */
  #define REG_LCDC_OVRIDR2  (*(__O  uint32_t*)0xF0000250U) /**< \brief (LCDC) Overlay 2 Interrupt Disable Register */
  #define REG_LCDC_OVRIMR2  (*(__I  uint32_t*)0xF0000254U) /**< \brief (LCDC) Overlay 2 Interrupt Mask Register */
  #define REG_LCDC_OVRISR2  (*(__I  uint32_t*)0xF0000258U) /**< \brief (LCDC) Overlay 2 Interrupt status Register */
  #define REG_LCDC_OVRHEAD2 (*(__IO uint32_t*)0xF000025CU) /**< \brief (LCDC) Overlay 2 DMA Head Register */
  #define REG_LCDC_OVRADDR2 (*(__IO uint32_t*)0xF0000260U) /**< \brief (LCDC) Overlay 2 DMA Address Register */
  #define REG_LCDC_OVRCTRL2 (*(__IO uint32_t*)0xF0000264U) /**< \brief (LCDC) Overlay 2 DMA Control Register */
  #define REG_LCDC_OVRNEXT2 (*(__IO uint32_t*)0xF0000268U) /**< \brief (LCDC) Overlay 2 DMA Next Register */
  #define REG_LCDC_OVR2CFG0 (*(__IO uint32_t*)0xF000026CU) /**< \brief (LCDC) Overlay 2 Configuration 0 Register */
  #define REG_LCDC_OVR2CFG1 (*(__IO uint32_t*)0xF0000270U) /**< \brief (LCDC) Overlay 2 Configuration 1 Register */
  #define REG_LCDC_OVR2CFG2 (*(__IO uint32_t*)0xF0000274U) /**< \brief (LCDC) Overlay 2 Configuration 2 Register */
  #define REG_LCDC_OVR2CFG3 (*(__IO uint32_t*)0xF0000278U) /**< \brief (LCDC) Overlay 2 Configuration 3 Register */
  #define REG_LCDC_OVR2CFG4 (*(__IO uint32_t*)0xF000027CU) /**< \brief (LCDC) Overlay 2 Configuration 4 Register */
  #define REG_LCDC_OVR2CFG5 (*(__IO uint32_t*)0xF0000280U) /**< \brief (LCDC) Overlay 2 Configuration 5 Register */
  #define REG_LCDC_OVR2CFG6 (*(__IO uint32_t*)0xF0000284U) /**< \brief (LCDC) Overlay 2 Configuration 6 Register */
  #define REG_LCDC_OVR2CFG7 (*(__IO uint32_t*)0xF0000288U) /**< \brief (LCDC) Overlay 2 Configuration 7 Register */
  #define REG_LCDC_OVR2CFG8 (*(__IO uint32_t*)0xF000028CU) /**< \brief (LCDC) Overlay 2 Configuration 8 Register */
  #define REG_LCDC_OVR2CFG9 (*(__IO uint32_t*)0xF0000290U) /**< \brief (LCDC) Overlay 2 Configuration 9 Register */
  #define REG_LCDC_HEOCHER  (*(__O  uint32_t*)0xF0000340U) /**< \brief (LCDC) High-End Overlay Channel Enable Register */
  #define REG_LCDC_HEOCHDR  (*(__O  uint32_t*)0xF0000344U) /**< \brief (LCDC) High-End Overlay Channel Disable Register */
  #define REG_LCDC_HEOCHSR  (*(__I  uint32_t*)0xF0000348U) /**< \brief (LCDC) High-End Overlay Channel Status Register */
  #define REG_LCDC_HEOIER   (*(__O  uint32_t*)0xF000034CU) /**< \brief (LCDC) High-End Overlay Interrupt Enable Register */
  #define REG_LCDC_HEOIDR   (*(__O  uint32_t*)0xF0000350U) /**< \brief (LCDC) High-End Overlay Interrupt Disable Register */
  #define REG_LCDC_HEOIMR   (*(__I  uint32_t*)0xF0000354U) /**< \brief (LCDC) High-End Overlay Interrupt Mask Register */
  #define REG_LCDC_HEOISR   (*(__I  uint32_t*)0xF0000358U) /**< \brief (LCDC) High-End Overlay Interrupt Status Register */
  #define REG_LCDC_HEOHEAD  (*(__IO uint32_t*)0xF000035CU) /**< \brief (LCDC) High-End Overlay DMA Head Register */
  #define REG_LCDC_HEOADDR  (*(__IO uint32_t*)0xF0000360U) /**< \brief (LCDC) High-End Overlay DMA Address Register */
  #define REG_LCDC_HEOCTRL  (*(__IO uint32_t*)0xF0000364U) /**< \brief (LCDC) High-End Overlay DMA Control Register */
  #define REG_LCDC_HEONEXT  (*(__IO uint32_t*)0xF0000368U) /**< \brief (LCDC) High-End Overlay DMA Next Register */
  #define REG_LCDC_HEOUHEAD (*(__IO uint32_t*)0xF000036CU) /**< \brief (LCDC) High-End Overlay U DMA Head Register */
  #define REG_LCDC_HEOUADDR (*(__IO uint32_t*)0xF0000370U) /**< \brief (LCDC) High-End Overlay U DMA Address Register */
  #define REG_LCDC_HEOUCTRL (*(__IO uint32_t*)0xF0000374U) /**< \brief (LCDC) High-End Overlay U DMA control Register */
  #define REG_LCDC_HEOUNEXT (*(__IO uint32_t*)0xF0000378U) /**< \brief (LCDC) High-End Overlay U DMA Next Register */
  #define REG_LCDC_HEOVHEAD (*(__IO uint32_t*)0xF000037CU) /**< \brief (LCDC) High-End Overlay V DMA Head Register */
  #define REG_LCDC_HEOVADDR (*(__IO uint32_t*)0xF0000380U) /**< \brief (LCDC) High-End Overlay V DMA Address Register */
  #define REG_LCDC_HEOVCTRL (*(__IO uint32_t*)0xF0000384U) /**< \brief (LCDC) High-End Overlay V DMA control Register */
  #define REG_LCDC_HEOVNEXT (*(__IO uint32_t*)0xF0000388U) /**< \brief (LCDC) High-End Overlay VDMA Next Register */
  #define REG_LCDC_HEOCFG0  (*(__IO uint32_t*)0xF000038CU) /**< \brief (LCDC) High-End Overlay Configuration Register 0 */
  #define REG_LCDC_HEOCFG1  (*(__IO uint32_t*)0xF0000390U) /**< \brief (LCDC) High-End Overlay Configuration Register 1 */
  #define REG_LCDC_HEOCFG2  (*(__IO uint32_t*)0xF0000394U) /**< \brief (LCDC) High-End Overlay Configuration Register 2 */
  #define REG_LCDC_HEOCFG3  (*(__IO uint32_t*)0xF0000398U) /**< \brief (LCDC) High-End Overlay Configuration Register 3 */
  #define REG_LCDC_HEOCFG4  (*(__IO uint32_t*)0xF000039CU) /**< \brief (LCDC) High-End Overlay Configuration Register 4 */
  #define REG_LCDC_HEOCFG5  (*(__IO uint32_t*)0xF00003A0U) /**< \brief (LCDC) High-End Overlay Configuration Register 5 */
  #define REG_LCDC_HEOCFG6  (*(__IO uint32_t*)0xF00003A4U) /**< \brief (LCDC) High-End Overlay Configuration Register 6 */
  #define REG_LCDC_HEOCFG7  (*(__IO uint32_t*)0xF00003A8U) /**< \brief (LCDC) High-End Overlay Configuration Register 7 */
  #define REG_LCDC_HEOCFG8  (*(__IO uint32_t*)0xF00003ACU) /**< \brief (LCDC) High-End Overlay Configuration Register 8 */
  #define REG_LCDC_HEOCFG9  (*(__IO uint32_t*)0xF00003B0U) /**< \brief (LCDC) High-End Overlay Configuration Register 9 */
  #define REG_LCDC_HEOCFG10 (*(__IO uint32_t*)0xF00003B4U) /**< \brief (LCDC) High-End Overlay Configuration Register 10 */
  #define REG_LCDC_HEOCFG11 (*(__IO uint32_t*)0xF00003B8U) /**< \brief (LCDC) High-End Overlay Configuration Register 11 */
  #define REG_LCDC_HEOCFG12 (*(__IO uint32_t*)0xF00003BCU) /**< \brief (LCDC) High-End Overlay Configuration Register 12 */
  #define REG_LCDC_HEOCFG13 (*(__IO uint32_t*)0xF00003C0U) /**< \brief (LCDC) High-End Overlay Configuration Register 13 */
  #define REG_LCDC_HEOCFG14 (*(__IO uint32_t*)0xF00003C4U) /**< \brief (LCDC) High-End Overlay Configuration Register 14 */
  #define REG_LCDC_HEOCFG15 (*(__IO uint32_t*)0xF00003C8U) /**< \brief (LCDC) High-End Overlay Configuration Register 15 */
  #define REG_LCDC_HEOCFG16 (*(__IO uint32_t*)0xF00003CCU) /**< \brief (LCDC) High-End Overlay Configuration Register 16 */
  #define REG_LCDC_HEOCFG17 (*(__IO uint32_t*)0xF00003D0U) /**< \brief (LCDC) High-End Overlay Configuration Register 17 */
  #define REG_LCDC_HEOCFG18 (*(__IO uint32_t*)0xF00003D4U) /**< \brief (LCDC) High-End Overlay Configuration Register 18 */
  #define REG_LCDC_HEOCFG19 (*(__IO uint32_t*)0xF00003D8U) /**< \brief (LCDC) High-End Overlay Configuration Register 19 */
  #define REG_LCDC_HEOCFG20 (*(__IO uint32_t*)0xF00003DCU) /**< \brief (LCDC) High-End Overlay Configuration Register 20 */
  #define REG_LCDC_HEOCFG21 (*(__IO uint32_t*)0xF00003E0U) /**< \brief (LCDC) High-End Overlay Configuration Register 21 */
  #define REG_LCDC_HEOCFG22 (*(__IO uint32_t*)0xF00003E4U) /**< \brief (LCDC) High-End Overlay Configuration Register 22 */
  #define REG_LCDC_HEOCFG23 (*(__IO uint32_t*)0xF00003E8U) /**< \brief (LCDC) High-End Overlay Configuration Register 23 */
  #define REG_LCDC_HEOCFG24 (*(__IO uint32_t*)0xF00003ECU) /**< \brief (LCDC) High-End Overlay Configuration Register 24 */
  #define REG_LCDC_HEOCFG25 (*(__IO uint32_t*)0xF00003F0U) /**< \brief (LCDC) High-End Overlay Configuration Register 25 */
  #define REG_LCDC_HEOCFG26 (*(__IO uint32_t*)0xF00003F4U) /**< \brief (LCDC) High-End Overlay Configuration Register 26 */
  #define REG_LCDC_HEOCFG27 (*(__IO uint32_t*)0xF00003F8U) /**< \brief (LCDC) High-End Overlay Configuration Register 27 */
  #define REG_LCDC_HEOCFG28 (*(__IO uint32_t*)0xF00003FCU) /**< \brief (LCDC) High-End Overlay Configuration Register 28 */
  #define REG_LCDC_HEOCFG29 (*(__IO uint32_t*)0xF0000400U) /**< \brief (LCDC) High-End Overlay Configuration Register 29 */
  #define REG_LCDC_HEOCFG30 (*(__IO uint32_t*)0xF0000404U) /**< \brief (LCDC) High-End Overlay Configuration Register 30 */
  #define REG_LCDC_HEOCFG31 (*(__IO uint32_t*)0xF0000408U) /**< \brief (LCDC) High-End Overlay Configuration Register 31 */
  #define REG_LCDC_HEOCFG32 (*(__IO uint32_t*)0xF000040CU) /**< \brief (LCDC) High-End Overlay Configuration Register 32 */
  #define REG_LCDC_HEOCFG33 (*(__IO uint32_t*)0xF0000410U) /**< \brief (LCDC) High-End Overlay Configuration Register 33 */
  #define REG_LCDC_HEOCFG34 (*(__IO uint32_t*)0xF0000414U) /**< \brief (LCDC) High-End Overl