/*******************************************************************************
*                                                                              *
* Copyright 2013 Altera Corporation. All Rights Reserved.                      *
*                                                                              *
* Redistribution and use in source and binary forms, with or without           *
* modification, are permitted provided that the following conditions are met:  *
*                                                                              *
* 1. Redistributions of source code must retain the above copyright notice,    *
*    this list of conditions and the following disclaimer.                     *
*                                                                              *
* 2. Redistributions in binary form must reproduce the above copyright notice, *
*    this list of conditions and the following disclaimer in the documentation *
*    and/or other materials provided with the distribution.                    *
*                                                                              *
* 3. The name of the author may not be used to endorse or promote products     *
*    derived from this software without specific prior written permission.     *
*                                                                              *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY EXPRESS OR *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE DISCLAIMED. IN NO  *
* EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       *
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;  *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,     *
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR      *
* OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF       *
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                   *
*                                                                              *
*******************************************************************************/

/* Altera - ALT_CAN */

#ifndef __ALTERA_ALT_CAN_H__
#define __ALTERA_ALT_CAN_H__

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

/*
 * Component : CAN Controller Module - ALT_CAN
 * CAN Controller Module
 * 
 * Registers in the CAN Controller module
 * 
 */
/*
 * Register Group : Protocol Group - ALT_CAN_PROTO
 * Protocol Group
 * 
 * These registers are related to the CAN protocol controller in the CAN Core. They
 * control the operating modes and the configuration of the CAN bit timing and
 * provide status information.
 * 
 */
/*
 * Register : Control Register - CCTRL
 * 
 * Control Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                         
 * :--------|:-------|:------|:-------------------------------------
 *  [0]     | RW     | 0x1   | Initialization                      
 *  [1]     | RW     | 0x0   | Module Interrupt Line Enable        
 *  [2]     | RW     | 0x0   | Status Interrupt Enable             
 *  [3]     | RW     | 0x0   | Error Interrupt Enable              
 *  [4]     | ???    | 0x0   | *UNDEFINED*                         
 *  [5]     | RW     | 0x0   | Disable Automatic Retransmission    
 *  [6]     | RW     | 0x0   | Configuration Change Enable         
 *  [7]     | RW     | 0x0   | Test Mode Enable                    
 *  [16:8]  | ???    | 0x0   | *UNDEFINED*                         
 *  [17]    | RW     | 0x0   | Message Object Interrupt Line Enable
 *  [18]    | RW     | 0x0   | DMA Enable for IF1                  
 *  [19]    | RW     | 0x0   | DMA Enable for IF2                  
 *  [31:20] | ???    | 0x0   | *UNDEFINED*                         
 * 
 */
/*
 * Field : Initialization - Init
 * 
 * Initialization
 * 
 * Note: Due to the synchronization mechanism between the two clock domains, there
 * may be a delay until the value written to CCTRL.Init can be read back. Therefore
 * the programmer has to assure that the previous value written to CCTRL.Init has
 * been accepted by reading CCTRL.Init before setting CCTRL.Init to a new value.\n
 * 
 * Note: The Bus_Off recovery sequence (see CAN Specification Rev. 2.0) cannot be
 * shortened by setting or resetting CCTRL.Init. If the device goes Bus_Off, it
 * will set CCTRL.Init of its own accord, stopping all bus activities. Once
 * CCTRL.Init has been cleared by the CPU, the device will then wait for 129
 * occurrences of Bus Idle (129 * 11 consecutive recessive bits) before resuming
 * normal operations. At the end of the Bus_Off recovery sequence, the Error
 * Management Counters will be reset. During the waiting time after the resetting
 * of CCTRL.Init, each time a sequence of 11 recessive bits has been monitored, a
 * Bit0Error code is written to the Status Register, enabling the CPU to readily
 * check up whether the CAN bus is stuck at dominant or continuously disturbed and
 * to monitor the proceeding of the us_Off recovery sequence.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description               
 * :---------------------------------|:------|:---------------------------
 *  ALT_CAN_PROTO_CCTL_INIT_E_NORMAL | 0x0   | Normal Operation.         
 *  ALT_CAN_PROTO_CCTL_INIT_E_START  | 0x1   | Initialization is started.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_INIT
 * 
 * Normal Operation.
 */
#define ALT_CAN_PROTO_CCTL_INIT_E_NORMAL    0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_INIT
 * 
 * Initialization is started.
 */
#define ALT_CAN_PROTO_CCTL_INIT_E_START     0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_INIT register field. */
#define ALT_CAN_PROTO_CCTL_INIT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_INIT register field. */
#define ALT_CAN_PROTO_CCTL_INIT_MSB        0
/* The width in bits of the ALT_CAN_PROTO_CCTL_INIT register field. */
#define ALT_CAN_PROTO_CCTL_INIT_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_INIT register field value. */
#define ALT_CAN_PROTO_CCTL_INIT_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_PROTO_CCTL_INIT register field value. */
#define ALT_CAN_PROTO_CCTL_INIT_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_PROTO_CCTL_INIT register field. */
#define ALT_CAN_PROTO_CCTL_INIT_RESET      0x1
/* Extracts the ALT_CAN_PROTO_CCTL_INIT field value from a register. */
#define ALT_CAN_PROTO_CCTL_INIT_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_PROTO_CCTL_INIT register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_INIT_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Module Interrupt Line Enable - ILE
 * 
 * Module Interrupt Line Enable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                                    
 * :------------------------------|:------|:------------------------------------------------
 *  ALT_CAN_PROTO_CCTL_ILE_E_DISD | 0x0   | Module Interrupt Line CAN_INT_STATUS is always 
 * :                              |       | LOW.                                           
 *  ALT_CAN_PROTO_CCTL_ILE_E_END  | 0x1   | Error and status interrupts (if CCTRL.EIE=1 and
 * :                              |       | CCTRL.SIE=1) will set line CAN_INT_STATUS to   
 * :                              |       | one, signal remains one until all pending      
 * :                              |       | interrupts are processed. If MIL is disabled,  
 * :                              |       | the message object interrupts will also affect 
 * :                              |       | this interrupt line.                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_ILE
 * 
 * Module Interrupt Line CAN_INT_STATUS is always LOW.
 */
#define ALT_CAN_PROTO_CCTL_ILE_E_DISD   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_ILE
 * 
 * Error and status interrupts (if CCTRL.EIE=1 and CCTRL.SIE=1) will set line
 * CAN_INT_STATUS to one, signal remains one until all pending interrupts are
 * processed. If MIL is disabled, the message object interrupts will also affect
 * this interrupt line.
 */
#define ALT_CAN_PROTO_CCTL_ILE_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_ILE register field. */
#define ALT_CAN_PROTO_CCTL_ILE_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_ILE register field. */
#define ALT_CAN_PROTO_CCTL_ILE_MSB        1
/* The width in bits of the ALT_CAN_PROTO_CCTL_ILE register field. */
#define ALT_CAN_PROTO_CCTL_ILE_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_ILE register field value. */
#define ALT_CAN_PROTO_CCTL_ILE_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_PROTO_CCTL_ILE register field value. */
#define ALT_CAN_PROTO_CCTL_ILE_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_PROTO_CCTL_ILE register field. */
#define ALT_CAN_PROTO_CCTL_ILE_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_ILE field value from a register. */
#define ALT_CAN_PROTO_CCTL_ILE_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_PROTO_CCTL_ILE register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_ILE_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Status Interrupt Enable - SIE
 * 
 * Status Interrupt Enable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                                     
 * :------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CCTL_SIE_E_DISD | 0x0   | CSTS.RxOk, CSTS.TxOk and CSTS.LEC will still be 
 * :                              |       | updated, but without affecting interrupt line   
 * :                              |       | CAN_INT_STATUS and Interrupt register CIR.      
 *  ALT_CAN_PROTO_CCTL_SIE_E_END  | 0x1   | When a message transfer is successfully         
 * :                              |       | completed or a CAN bus error is detected,       
 * :                              |       | indicated by flags CSTS.RxOk, CSTS.TxOk and     
 * :                              |       | CSTS.LEC, the interrupt line CAN_INT_STATUS gets
 * :                              |       | active (if ILE=1) and CIR.StatusInt is set.     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_SIE
 * 
 * CSTS.RxOk, CSTS.TxOk and CSTS.LEC will still be updated, but without affecting
 * interrupt line CAN_INT_STATUS and Interrupt register CIR.
 */
#define ALT_CAN_PROTO_CCTL_SIE_E_DISD   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_SIE
 * 
 * When a message transfer is successfully completed or a CAN bus error is
 * detected, indicated by flags CSTS.RxOk, CSTS.TxOk and CSTS.LEC, the interrupt
 * line CAN_INT_STATUS gets active (if ILE=1) and CIR.StatusInt is set.
 */
#define ALT_CAN_PROTO_CCTL_SIE_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_SIE register field. */
#define ALT_CAN_PROTO_CCTL_SIE_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_SIE register field. */
#define ALT_CAN_PROTO_CCTL_SIE_MSB        2
/* The width in bits of the ALT_CAN_PROTO_CCTL_SIE register field. */
#define ALT_CAN_PROTO_CCTL_SIE_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_SIE register field value. */
#define ALT_CAN_PROTO_CCTL_SIE_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_PROTO_CCTL_SIE register field value. */
#define ALT_CAN_PROTO_CCTL_SIE_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_PROTO_CCTL_SIE register field. */
#define ALT_CAN_PROTO_CCTL_SIE_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_SIE field value from a register. */
#define ALT_CAN_PROTO_CCTL_SIE_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_PROTO_CCTL_SIE register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_SIE_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Error Interrupt Enable - EIE
 * 
 * Error Interrupt Enable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                                  
 * :------------------------------|:------|:----------------------------------------------
 *  ALT_CAN_PROTO_CCTL_EIE_E_DISD | 0x0   | CSTS.PER, CSTS.BOff and CSTS.EWarn flags will
 * :                              |       | still be updated, but without affecting      
 * :                              |       | interrupt line CAN_INT_STATUS and Interrupt  
 * :                              |       | register CIR                                 
 *  ALT_CAN_PROTO_CCTL_EIE_E_END  | 0x1   | If CSTS.PER flag is one, or CSTS.BOff or     
 * :                              |       | CSTS.EWarn are changed, the interrupt line   
 * :                              |       | CAN_INT_STATUS gets active (if ILE=1) and    
 * :                              |       | CIR.StatusInt is set.                        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_EIE
 * 
 * CSTS.PER, CSTS.BOff and CSTS.EWarn flags will still be updated, but without
 * affecting interrupt line CAN_INT_STATUS and Interrupt register CIR
 */
#define ALT_CAN_PROTO_CCTL_EIE_E_DISD   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_EIE
 * 
 * If CSTS.PER flag is one, or CSTS.BOff or CSTS.EWarn are changed, the interrupt
 * line CAN_INT_STATUS gets active (if ILE=1) and CIR.StatusInt is set.
 */
#define ALT_CAN_PROTO_CCTL_EIE_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_EIE register field. */
#define ALT_CAN_PROTO_CCTL_EIE_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_EIE register field. */
#define ALT_CAN_PROTO_CCTL_EIE_MSB        3
/* The width in bits of the ALT_CAN_PROTO_CCTL_EIE register field. */
#define ALT_CAN_PROTO_CCTL_EIE_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_EIE register field value. */
#define ALT_CAN_PROTO_CCTL_EIE_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_PROTO_CCTL_EIE register field value. */
#define ALT_CAN_PROTO_CCTL_EIE_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_PROTO_CCTL_EIE register field. */
#define ALT_CAN_PROTO_CCTL_EIE_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_EIE field value from a register. */
#define ALT_CAN_PROTO_CCTL_EIE_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_PROTO_CCTL_EIE register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_EIE_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Disable Automatic Retransmission - DAR
 * 
 * Disable Automatic Retransmission
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                               
 * :------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_PROTO_CCTL_DAR_E_END  | 0x0   | Automatic Retransmission of not successful
 * :                              |       | messages enabled.                         
 *  ALT_CAN_PROTO_CCTL_DAR_E_DISD | 0x1   | Automatic Retransmission disabled.        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_DAR
 * 
 * Automatic Retransmission of not successful messages enabled.
 */
#define ALT_CAN_PROTO_CCTL_DAR_E_END    0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_DAR
 * 
 * Automatic Retransmission disabled.
 */
#define ALT_CAN_PROTO_CCTL_DAR_E_DISD   0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_DAR register field. */
#define ALT_CAN_PROTO_CCTL_DAR_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_DAR register field. */
#define ALT_CAN_PROTO_CCTL_DAR_MSB        5
/* The width in bits of the ALT_CAN_PROTO_CCTL_DAR register field. */
#define ALT_CAN_PROTO_CCTL_DAR_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_DAR register field value. */
#define ALT_CAN_PROTO_CCTL_DAR_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_PROTO_CCTL_DAR register field value. */
#define ALT_CAN_PROTO_CCTL_DAR_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_PROTO_CCTL_DAR register field. */
#define ALT_CAN_PROTO_CCTL_DAR_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_DAR field value from a register. */
#define ALT_CAN_PROTO_CCTL_DAR_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_PROTO_CCTL_DAR register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_DAR_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Configuration Change Enable - CCE
 * 
 * Configuration Change Enable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                                     
 * :---------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CCTL_CCE_E_NOWRACC | 0x0   | The CPU has no write access to the configuration
 * :                                 |       | registers.                                      
 *  ALT_CAN_PROTO_CCTL_CCE_E_WRACC   | 0x1   | The CPU has write access to the Bit Timing      
 * :                                 |       | Register CBT (while CCTRL.Init = 1).            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_CCE
 * 
 * The CPU has no write access to the configuration registers.
 */
#define ALT_CAN_PROTO_CCTL_CCE_E_NOWRACC    0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_CCE
 * 
 * The CPU has write access to the Bit Timing Register CBT (while CCTRL.Init = 1).
 */
#define ALT_CAN_PROTO_CCTL_CCE_E_WRACC      0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_CCE register field. */
#define ALT_CAN_PROTO_CCTL_CCE_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_CCE register field. */
#define ALT_CAN_PROTO_CCTL_CCE_MSB        6
/* The width in bits of the ALT_CAN_PROTO_CCTL_CCE register field. */
#define ALT_CAN_PROTO_CCTL_CCE_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_CCE register field value. */
#define ALT_CAN_PROTO_CCTL_CCE_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_PROTO_CCTL_CCE register field value. */
#define ALT_CAN_PROTO_CCTL_CCE_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_PROTO_CCTL_CCE register field. */
#define ALT_CAN_PROTO_CCTL_CCE_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_CCE field value from a register. */
#define ALT_CAN_PROTO_CCTL_CCE_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_PROTO_CCTL_CCE register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_CCE_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Test Mode Enable - Test
 * 
 * Test Mode Enable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                                
 * :----------------------------------|:------|:--------------------------------------------
 *  ALT_CAN_PROTO_CCTL_TEST_E_DISD    | 0x0   | Normal Operation.                          
 *  ALT_CAN_PROTO_CCTL_TEST_E_TESTMOD | 0x1   | Test Mode. Enables the write access to Test
 * :                                  |       | Register CTR.                              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_TEST
 * 
 * Normal Operation.
 */
#define ALT_CAN_PROTO_CCTL_TEST_E_DISD      0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_TEST
 * 
 * Test Mode. Enables the write access to Test Register CTR.
 */
#define ALT_CAN_PROTO_CCTL_TEST_E_TESTMOD   0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_TEST register field. */
#define ALT_CAN_PROTO_CCTL_TEST_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_TEST register field. */
#define ALT_CAN_PROTO_CCTL_TEST_MSB        7
/* The width in bits of the ALT_CAN_PROTO_CCTL_TEST register field. */
#define ALT_CAN_PROTO_CCTL_TEST_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_TEST register field value. */
#define ALT_CAN_PROTO_CCTL_TEST_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_PROTO_CCTL_TEST register field value. */
#define ALT_CAN_PROTO_CCTL_TEST_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_PROTO_CCTL_TEST register field. */
#define ALT_CAN_PROTO_CCTL_TEST_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_TEST field value from a register. */
#define ALT_CAN_PROTO_CCTL_TEST_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_PROTO_CCTL_TEST register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_TEST_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Message Object Interrupt Line Enable - MIL
 * 
 * Message Object Interrupt Line Enable
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                                     
 * :------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CCTL_MIL_E_DISD | 0x0   | Message Object Interrupt CAN_INT_MO is always   
 * :                              |       | LOW. If CCTRL.ILE is enabled all message object 
 * :                              |       | interrupts are routed to line CAN_INT_STATUS    
 * :                              |       | otherwise no message object interrupt will be   
 * :                              |       | visible.                                        
 *  ALT_CAN_PROTO_CCTL_MIL_E_END  | 0x1   | Message object interrupts will set CAN_INT_MO to
 * :                              |       | one, signal remains one until all pending       
 * :                              |       | interrupts are processed.                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_MIL
 * 
 * Message Object Interrupt CAN_INT_MO is always LOW. If CCTRL.ILE is enabled all
 * message object interrupts are routed to line CAN_INT_STATUS otherwise no message
 * object interrupt will be visible.
 */
#define ALT_CAN_PROTO_CCTL_MIL_E_DISD   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_MIL
 * 
 * Message object interrupts will set CAN_INT_MO to one, signal remains one until
 * all pending interrupts are processed.
 */
#define ALT_CAN_PROTO_CCTL_MIL_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_MIL register field. */
#define ALT_CAN_PROTO_CCTL_MIL_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_MIL register field. */
#define ALT_CAN_PROTO_CCTL_MIL_MSB        17
/* The width in bits of the ALT_CAN_PROTO_CCTL_MIL register field. */
#define ALT_CAN_PROTO_CCTL_MIL_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_MIL register field value. */
#define ALT_CAN_PROTO_CCTL_MIL_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_PROTO_CCTL_MIL register field value. */
#define ALT_CAN_PROTO_CCTL_MIL_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_PROTO_CCTL_MIL register field. */
#define ALT_CAN_PROTO_CCTL_MIL_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_MIL field value from a register. */
#define ALT_CAN_PROTO_CCTL_MIL_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_PROTO_CCTL_MIL register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_MIL_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : DMA Enable for IF1 - DE1
 * 
 * DMA Enable for IF1
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                                     
 * :------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CCTL_DE1_E_DISD | 0x0   | Module DMA output port CAN_IF1DMA is always LOW.
 *  ALT_CAN_PROTO_CCTL_DE1_E_END  | 0x1   | Requesting a message object transfer from IF1 to
 * :                              |       | Message RAM or vice versa with IF1CMR.DMAactive 
 * :                              |       | enabled the end of the transfer will be marked  
 * :                              |       | with setting port CAN_IF1DMA to one. The port   
 * :                              |       | remains one until first access to one of the IF1
 * :                              |       | registers.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_DE1
 * 
 * Module DMA output port CAN_IF1DMA is always LOW.
 */
#define ALT_CAN_PROTO_CCTL_DE1_E_DISD   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_DE1
 * 
 * Requesting a message object transfer from IF1 to Message RAM or vice versa with
 * IF1CMR.DMAactive enabled the end of the transfer will be marked with setting
 * port CAN_IF1DMA to one. The port remains one until first access to one of the
 * IF1 registers.
 */
#define ALT_CAN_PROTO_CCTL_DE1_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_DE1 register field. */
#define ALT_CAN_PROTO_CCTL_DE1_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_DE1 register field. */
#define ALT_CAN_PROTO_CCTL_DE1_MSB        18
/* The width in bits of the ALT_CAN_PROTO_CCTL_DE1 register field. */
#define ALT_CAN_PROTO_CCTL_DE1_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_DE1 register field value. */
#define ALT_CAN_PROTO_CCTL_DE1_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_PROTO_CCTL_DE1 register field value. */
#define ALT_CAN_PROTO_CCTL_DE1_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_PROTO_CCTL_DE1 register field. */
#define ALT_CAN_PROTO_CCTL_DE1_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_DE1 field value from a register. */
#define ALT_CAN_PROTO_CCTL_DE1_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_PROTO_CCTL_DE1 register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_DE1_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : DMA Enable for IF2 - DE2
 * 
 * DMA Enable for IF2
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                                     
 * :------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CCTL_DE2_E_DISD | 0x0   | Module DMA output port CAN_IF2DMA is always LOW.
 *  ALT_CAN_PROTO_CCTL_DE2_E_END  | 0x1   | Requesting a message object transfer from IF2 to
 * :                              |       | Message RAM or vice versa with IF2CMR.DMAactive 
 * :                              |       | enabled the end of the transfer will be marked  
 * :                              |       | with setting port CAN_IF2DMA to one. The port   
 * :                              |       | remains one until first access to one of the IF2
 * :                              |       | registers.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_DE2
 * 
 * Module DMA output port CAN_IF2DMA is always LOW.
 */
#define ALT_CAN_PROTO_CCTL_DE2_E_DISD   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CCTL_DE2
 * 
 * Requesting a message object transfer from IF2 to Message RAM or vice versa with
 * IF2CMR.DMAactive enabled the end of the transfer will be marked with setting
 * port CAN_IF2DMA to one. The port remains one until first access to one of the
 * IF2 registers.
 */
#define ALT_CAN_PROTO_CCTL_DE2_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CCTL_DE2 register field. */
#define ALT_CAN_PROTO_CCTL_DE2_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CCTL_DE2 register field. */
#define ALT_CAN_PROTO_CCTL_DE2_MSB        19
/* The width in bits of the ALT_CAN_PROTO_CCTL_DE2 register field. */
#define ALT_CAN_PROTO_CCTL_DE2_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CCTL_DE2 register field value. */
#define ALT_CAN_PROTO_CCTL_DE2_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_PROTO_CCTL_DE2 register field value. */
#define ALT_CAN_PROTO_CCTL_DE2_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_PROTO_CCTL_DE2 register field. */
#define ALT_CAN_PROTO_CCTL_DE2_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CCTL_DE2 field value from a register. */
#define ALT_CAN_PROTO_CCTL_DE2_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_PROTO_CCTL_DE2 register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CCTL_DE2_SET(value) (((value) << 19) & 0x00080000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CCTL.
 */
struct ALT_CAN_PROTO_CCTL_s
{
    uint32_t  Init :  1;  /* Initialization */
    uint32_t  ILE  :  1;  /* Module Interrupt Line Enable */
    uint32_t  SIE  :  1;  /* Status Interrupt Enable */
    uint32_t  EIE  :  1;  /* Error Interrupt Enable */
    uint32_t       :  1;  /* *UNDEFINED* */
    uint32_t  DAR  :  1;  /* Disable Automatic Retransmission */
    uint32_t  CCE  :  1;  /* Configuration Change Enable */
    uint32_t  Test :  1;  /* Test Mode Enable */
    uint32_t       :  9;  /* *UNDEFINED* */
    uint32_t  MIL  :  1;  /* Message Object Interrupt Line Enable */
    uint32_t  DE1  :  1;  /* DMA Enable for IF1 */
    uint32_t  DE2  :  1;  /* DMA Enable for IF2 */
    uint32_t       : 12;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_CCTL. */
typedef volatile struct ALT_CAN_PROTO_CCTL_s  ALT_CAN_PROTO_CCTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CCTL register from the beginning of the component. */
#define ALT_CAN_PROTO_CCTL_OFST        0x0
/* The address of the ALT_CAN_PROTO_CCTL register. */
#define ALT_CAN_PROTO_CCTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CCTL_OFST))

/*
 * Register : Status Register - CSTS
 * 
 * Status Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                       
 * :-------|:-------|:------|:-----------------------------------
 *  [2:0]  | R      | 0x7   | Last Error Code                   
 *  [3]    | R      | 0x0   | Transmitted a Message Successfully
 *  [4]    | R      | 0x0   | Received a Message Successfully   
 *  [5]    | R      | 0x0   | Error Passive                     
 *  [6]    | R      | 0x0   | Warning Status                    
 *  [7]    | R      | 0x0   | Bus_Off Status                    
 *  [8]    | R      | 0x0   | Parity Error Detected             
 *  [31:9] | ???    | 0x0   | *UNDEFINED*                       
 * 
 */
/*
 * Field : Last Error Code - LEC
 * 
 * The LEC field holds a code which indicates the type of the last error to occur
 * on the CAN bus. This field will be cleared to 0 when a message has been
 * transferred (reception or transmission) without error.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                     
 * :------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CSTS_LEC_E_NOERROR    | 0x0   | Set together with CSTS.RxOK or CSTS.TxOK.       
 *  ALT_CAN_PROTO_CSTS_LEC_E_STUFFERROR | 0x1   | More than 5 equal bits in a sequence have       
 * :                                    |       | occurred in a part of a received message where  
 * :                                    |       | this is not allowed.                            
 *  ALT_CAN_PROTO_CSTS_LEC_E_FORMERROR  | 0x2   | A fixed format part of a received frame has the 
 * :                                    |       | wrong format.                                   
 *  ALT_CAN_PROTO_CSTS_LEC_E_ACKERROR   | 0x3   | The message this CAN Core transmitted was not   
 * :                                    |       | acknowledged by another node.                   
 *  ALT_CAN_PROTO_CSTS_LEC_E_BIT1ERROR  | 0x4   | During the transmission of a message (with the  
 * :                                    |       | exception of the arbitration field), the device 
 * :                                    |       | wanted to send a recessive level (bit of logical
 * :                                    |       | value 1), but the monitored bus value was       
 * :                                    |       | dominant.                                       
 *  ALT_CAN_PROTO_CSTS_LEC_E_BIT0ERROR  | 0x5   | During the transmission of a message (or        
 * :                                    |       | acknowledge bit, or active error flag, or       
 * :                                    |       | overload flag), the device wanted to send a     
 * :                                    |       | dominant level (data or identifier bit logical  
 * :                                    |       | value 0), but the monitored bus value was       
 * :                                    |       | recessive. During Bus_Off recovery this status  
 * :                                    |       | is set each time a sequence of 11 recessive bits
 * :                                    |       | has been monitored. This enables the CPU to     
 * :                                    |       | monitor the proceeding of the Bus_Off recovery  
 * :                                    |       | sequence (indicating the bus is not stuck at    
 * :                                    |       | dominant or continuously disturbed).            
 *  ALT_CAN_PROTO_CSTS_LEC_E_CRCERROR   | 0x6   | The CRC checksum was incorrect in the message   
 * :                                    |       | received, the CRC received for an incoming      
 * :                                    |       | message does not match with the calculated CRC  
 * :                                    |       | for the received data.                          
 *  ALT_CAN_PROTO_CSTS_LEC_E_NOCHANGE   | 0x7   | Any read access to the Status Register re       
 * :                                    |       | initializes the LEC to 7. When the LEC shows the
 * :                                    |       | value 7, no CAN bus event was detected since the
 * :                                    |       | last CPU read access to the Status Register.    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * Set together with CSTS.RxOK or CSTS.TxOK.
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_NOERROR    0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * More than 5 equal bits in a sequence have occurred in a part of a received
 * message where this is not allowed.
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_STUFFERROR 0x1
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * A fixed format part of a received frame has the wrong format.
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_FORMERROR  0x2
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * The message this CAN Core transmitted was not acknowledged by another node.
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_ACKERROR   0x3
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * During the transmission of a message (with the exception of the arbitration
 * field), the device wanted to send a recessive level (bit of logical value 1),
 * but the monitored bus value was dominant.
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_BIT1ERROR  0x4
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * During the transmission of a message (or acknowledge bit, or active error flag,
 * or overload flag), the device wanted to send a dominant level (data or
 * identifier bit logical value 0), but the monitored bus value was recessive.
 * During Bus_Off recovery this status is set each time a sequence of 11 recessive
 * bits has been monitored. This enables the CPU to monitor the proceeding of the
 * Bus_Off recovery sequence (indicating the bus is not stuck at dominant or
 * continuously disturbed).
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_BIT0ERROR  0x5
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * The CRC checksum was incorrect in the message received, the CRC received for an
 * incoming message does not match with the calculated CRC for the received data.
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_CRCERROR   0x6
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_LEC
 * 
 * Any read access to the Status Register re initializes the LEC to 7. When the LEC
 * shows the value 7, no CAN bus event was detected since the last CPU read access
 * to the Status Register.
 */
#define ALT_CAN_PROTO_CSTS_LEC_E_NOCHANGE   0x7

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CSTS_LEC register field. */
#define ALT_CAN_PROTO_CSTS_LEC_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CSTS_LEC register field. */
#define ALT_CAN_PROTO_CSTS_LEC_MSB        2
/* The width in bits of the ALT_CAN_PROTO_CSTS_LEC register field. */
#define ALT_CAN_PROTO_CSTS_LEC_WIDTH      3
/* The mask used to set the ALT_CAN_PROTO_CSTS_LEC register field value. */
#define ALT_CAN_PROTO_CSTS_LEC_SET_MSK    0x00000007
/* The mask used to clear the ALT_CAN_PROTO_CSTS_LEC register field value. */
#define ALT_CAN_PROTO_CSTS_LEC_CLR_MSK    0xfffffff8
/* The reset value of the ALT_CAN_PROTO_CSTS_LEC register field. */
#define ALT_CAN_PROTO_CSTS_LEC_RESET      0x7
/* Extracts the ALT_CAN_PROTO_CSTS_LEC field value from a register. */
#define ALT_CAN_PROTO_CSTS_LEC_GET(value) (((value) & 0x00000007) >> 0)
/* Produces a ALT_CAN_PROTO_CSTS_LEC register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CSTS_LEC_SET(value) (((value) << 0) & 0x00000007)

/*
 * Field : Transmitted a Message Successfully - TxOK
 * 
 * Transmitted a Message Successfully
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                                    
 * :---------------------------------|:------|:------------------------------------------------
 *  ALT_CAN_PROTO_CSTS_TXOK_E_NOTXOK | 0x0   | Since this bit was last read by the CPU, no    
 * :                                 |       | message has been successfully transmitted. This
 * :                                 |       | bit is never reset by CAN internal events.     
 *  ALT_CAN_PROTO_CSTS_TXOK_E_TXOK   | 0x1   | Since this bit was last reset by a read access 
 * :                                 |       | of the CPU, a message has been successfully    
 * :                                 |       | (error free and acknowledged by at least one   
 * :                                 |       | other node) transmitted. This bit will be reset
 * :                                 |       | by reading the Status Register.                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_TXOK
 * 
 * Since this bit was last read by the CPU, no message has been successfully
 * transmitted. This bit is never reset by CAN internal events.
 */
#define ALT_CAN_PROTO_CSTS_TXOK_E_NOTXOK    0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_TXOK
 * 
 * Since this bit was last reset by a read access of the CPU, a message has been
 * successfully (error free and acknowledged by at least one other node)
 * transmitted. This bit will be reset by reading the Status Register.
 */
#define ALT_CAN_PROTO_CSTS_TXOK_E_TXOK      0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CSTS_TXOK register field. */
#define ALT_CAN_PROTO_CSTS_TXOK_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CSTS_TXOK register field. */
#define ALT_CAN_PROTO_CSTS_TXOK_MSB        3
/* The width in bits of the ALT_CAN_PROTO_CSTS_TXOK register field. */
#define ALT_CAN_PROTO_CSTS_TXOK_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CSTS_TXOK register field value. */
#define ALT_CAN_PROTO_CSTS_TXOK_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_PROTO_CSTS_TXOK register field value. */
#define ALT_CAN_PROTO_CSTS_TXOK_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_PROTO_CSTS_TXOK register field. */
#define ALT_CAN_PROTO_CSTS_TXOK_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CSTS_TXOK field value from a register. */
#define ALT_CAN_PROTO_CSTS_TXOK_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_PROTO_CSTS_TXOK register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CSTS_TXOK_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Received a Message Successfully - RxOK
 * 
 * Received a Message Successfully
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                                     
 * :---------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CSTS_RXOK_E_NORXOK | 0x0   | Since this bit was read by the CPU, no message  
 * :                                 |       | has been successfully received. This bit is     
 * :                                 |       | never reset by CAN internal events.             
 *  ALT_CAN_PROTO_CSTS_RXOK_E_RXOK   | 0x1   | Since this bit was last reset by a read access  
 * :                                 |       | of the CPU, a message has been successfully     
 * :                                 |       | received (independently of the result of        
 * :                                 |       | acceptance filtering). This bit will be reset by
 * :                                 |       | reading the Status Register.                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_RXOK
 * 
 * Since this bit was read by the CPU, no message has been successfully received.
 * This bit is never reset by CAN internal events.
 */
#define ALT_CAN_PROTO_CSTS_RXOK_E_NORXOK    0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_RXOK
 * 
 * Since this bit was last reset by a read access of the CPU, a message has been
 * successfully received (independently of the result of acceptance filtering).
 * This bit will be reset by reading the Status Register.
 */
#define ALT_CAN_PROTO_CSTS_RXOK_E_RXOK      0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CSTS_RXOK register field. */
#define ALT_CAN_PROTO_CSTS_RXOK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CSTS_RXOK register field. */
#define ALT_CAN_PROTO_CSTS_RXOK_MSB        4
/* The width in bits of the ALT_CAN_PROTO_CSTS_RXOK register field. */
#define ALT_CAN_PROTO_CSTS_RXOK_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CSTS_RXOK register field value. */
#define ALT_CAN_PROTO_CSTS_RXOK_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_PROTO_CSTS_RXOK register field value. */
#define ALT_CAN_PROTO_CSTS_RXOK_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_PROTO_CSTS_RXOK register field. */
#define ALT_CAN_PROTO_CSTS_RXOK_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CSTS_RXOK field value from a register. */
#define ALT_CAN_PROTO_CSTS_RXOK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_PROTO_CSTS_RXOK register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CSTS_RXOK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Error Passive - EPASS
 * 
 * Error Passive
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                  
 * :-----------------------------------|:------|:----------------------------------------------
 *  ALT_CAN_PROTO_CSTS_EPASS_E_ACT     | 0x0   | The CAN Core is in the error active state. It
 * :                                   |       | normally takes part in bus communication and 
 * :                                   |       | sends an active error flag when an error has 
 * :                                   |       | been detected.                               
 *  ALT_CAN_PROTO_CSTS_EPASS_E_PASSIVE | 0x1   | The CAN Core is in the error passive state as
 * :                                   |       | defined in the CAN Specification.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_EPASS
 * 
 * The CAN Core is in the error active state. It normally takes part in bus
 * communication and sends an active error flag when an error has been detected.
 */
#define ALT_CAN_PROTO_CSTS_EPASS_E_ACT      0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_EPASS
 * 
 * The CAN Core is in the error passive state as defined in the CAN Specification.
 */
#define ALT_CAN_PROTO_CSTS_EPASS_E_PASSIVE  0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CSTS_EPASS register field. */
#define ALT_CAN_PROTO_CSTS_EPASS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CSTS_EPASS register field. */
#define ALT_CAN_PROTO_CSTS_EPASS_MSB        5
/* The width in bits of the ALT_CAN_PROTO_CSTS_EPASS register field. */
#define ALT_CAN_PROTO_CSTS_EPASS_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CSTS_EPASS register field value. */
#define ALT_CAN_PROTO_CSTS_EPASS_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_PROTO_CSTS_EPASS register field value. */
#define ALT_CAN_PROTO_CSTS_EPASS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_PROTO_CSTS_EPASS register field. */
#define ALT_CAN_PROTO_CSTS_EPASS_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CSTS_EPASS field value from a register. */
#define ALT_CAN_PROTO_CSTS_EPASS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_PROTO_CSTS_EPASS register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CSTS_EPASS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Warning Status - EWarn
 * 
 * Warning Status
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_CAN_PROTO_CSTS_EWARN_E_BELOWLIMIT | 0x0   | Both error counters are below the error warning
 * :                                      |       | limit of 96.                                   
 *  ALT_CAN_PROTO_CSTS_EWARN_E_ABOVELIMIT | 0x1   | At least one of the error counters in the EML  
 * :                                      |       | has reached the error warning limit of 96.     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_EWARN
 * 
 * Both error counters are below the error warning limit of 96.
 */
#define ALT_CAN_PROTO_CSTS_EWARN_E_BELOWLIMIT   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_EWARN
 * 
 * At least one of the error counters in the EML has reached the error warning
 * limit of 96.
 */
#define ALT_CAN_PROTO_CSTS_EWARN_E_ABOVELIMIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CSTS_EWARN register field. */
#define ALT_CAN_PROTO_CSTS_EWARN_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CSTS_EWARN register field. */
#define ALT_CAN_PROTO_CSTS_EWARN_MSB        6
/* The width in bits of the ALT_CAN_PROTO_CSTS_EWARN register field. */
#define ALT_CAN_PROTO_CSTS_EWARN_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CSTS_EWARN register field value. */
#define ALT_CAN_PROTO_CSTS_EWARN_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_PROTO_CSTS_EWARN register field value. */
#define ALT_CAN_PROTO_CSTS_EWARN_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_PROTO_CSTS_EWARN register field. */
#define ALT_CAN_PROTO_CSTS_EWARN_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CSTS_EWARN field value from a register. */
#define ALT_CAN_PROTO_CSTS_EWARN_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_PROTO_CSTS_EWARN register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CSTS_EWARN_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Bus_Off Status - BOff
 * 
 * Bus_Off Status
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                        
 * :------------------------------------|:------|:------------------------------------
 *  ALT_CAN_PROTO_CSTS_BOFF_E_NOTBUSOFF | 0x0   | The CAN module is not Bus_Off.     
 *  ALT_CAN_PROTO_CSTS_BOFF_E_BUSOFF    | 0x1   | The CAN module is in Bus_Off state.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_BOFF
 * 
 * The CAN module is not Bus_Off.
 */
#define ALT_CAN_PROTO_CSTS_BOFF_E_NOTBUSOFF 0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_BOFF
 * 
 * The CAN module is in Bus_Off state.
 */
#define ALT_CAN_PROTO_CSTS_BOFF_E_BUSOFF    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CSTS_BOFF register field. */
#define ALT_CAN_PROTO_CSTS_BOFF_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CSTS_BOFF register field. */
#define ALT_CAN_PROTO_CSTS_BOFF_MSB        7
/* The width in bits of the ALT_CAN_PROTO_CSTS_BOFF register field. */
#define ALT_CAN_PROTO_CSTS_BOFF_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CSTS_BOFF register field value. */
#define ALT_CAN_PROTO_CSTS_BOFF_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_PROTO_CSTS_BOFF register field value. */
#define ALT_CAN_PROTO_CSTS_BOFF_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_PROTO_CSTS_BOFF register field. */
#define ALT_CAN_PROTO_CSTS_BOFF_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CSTS_BOFF field value from a register. */
#define ALT_CAN_PROTO_CSTS_BOFF_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_PROTO_CSTS_BOFF register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CSTS_BOFF_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Parity Error Detected - PER
 * 
 * Parity Error Detected
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                     
 * :---------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CSTS_PER_E_NONE          | 0x0   | No parity error detected since last read access.
 *  ALT_CAN_PROTO_CSTS_PER_E_ERRORDETECTED | 0x1   | The Parity CheckMechanism has detected a parity 
 * :                                       |       | error in the Message RAM, this bit will be reset
 * :                                       |       | if Status Register is read                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_PER
 * 
 * No parity error detected since last read access.
 */
#define ALT_CAN_PROTO_CSTS_PER_E_NONE           0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CSTS_PER
 * 
 * The Parity CheckMechanism has detected a parity error in the Message RAM, this
 * bit will be reset if Status Register is read
 */
#define ALT_CAN_PROTO_CSTS_PER_E_ERRORDETECTED  0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CSTS_PER register field. */
#define ALT_CAN_PROTO_CSTS_PER_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CSTS_PER register field. */
#define ALT_CAN_PROTO_CSTS_PER_MSB        8
/* The width in bits of the ALT_CAN_PROTO_CSTS_PER register field. */
#define ALT_CAN_PROTO_CSTS_PER_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CSTS_PER register field value. */
#define ALT_CAN_PROTO_CSTS_PER_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_PROTO_CSTS_PER register field value. */
#define ALT_CAN_PROTO_CSTS_PER_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_PROTO_CSTS_PER register field. */
#define ALT_CAN_PROTO_CSTS_PER_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CSTS_PER field value from a register. */
#define ALT_CAN_PROTO_CSTS_PER_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_PROTO_CSTS_PER register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CSTS_PER_SET(value) (((value) << 8) & 0x00000100)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CSTS.
 */
struct ALT_CAN_PROTO_CSTS_s
{
    const uint32_t  LEC   :  3;  /* Last Error Code */
    const uint32_t  TxOK  :  1;  /* Transmitted a Message Successfully */
    const uint32_t  RxOK  :  1;  /* Received a Message Successfully */
    const uint32_t  EPASS :  1;  /* Error Passive */
    const uint32_t  EWarn :  1;  /* Warning Status */
    const uint32_t  BOff  :  1;  /* Bus_Off Status */
    const uint32_t  PER   :  1;  /* Parity Error Detected */
    uint32_t              : 23;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_CSTS. */
typedef volatile struct ALT_CAN_PROTO_CSTS_s  ALT_CAN_PROTO_CSTS_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CSTS register from the beginning of the component. */
#define ALT_CAN_PROTO_CSTS_OFST        0x4
/* The address of the ALT_CAN_PROTO_CSTS register. */
#define ALT_CAN_PROTO_CSTS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CSTS_OFST))

/*
 * Register : Error Counter Register - CERC
 * 
 * Error Counter Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description           
 * :--------|:-------|:------|:-----------------------
 *  [7:0]   | R      | 0x0   | Transmit Error Counter
 *  [14:8]  | R      | 0x0   | Receive Error Counter 
 *  [15]    | R      | 0x0   | Receive Error Passive 
 *  [31:16] | ???    | 0x0   | *UNDEFINED*           
 * 
 */
/*
 * Field : Transmit Error Counter - TEC
 * 
 * Actual state of the Transmit Error Counter. Values between 0 and 255.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CERC_TEC register field. */
#define ALT_CAN_PROTO_CERC_TEC_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CERC_TEC register field. */
#define ALT_CAN_PROTO_CERC_TEC_MSB        7
/* The width in bits of the ALT_CAN_PROTO_CERC_TEC register field. */
#define ALT_CAN_PROTO_CERC_TEC_WIDTH      8
/* The mask used to set the ALT_CAN_PROTO_CERC_TEC register field value. */
#define ALT_CAN_PROTO_CERC_TEC_SET_MSK    0x000000ff
/* The mask used to clear the ALT_CAN_PROTO_CERC_TEC register field value. */
#define ALT_CAN_PROTO_CERC_TEC_CLR_MSK    0xffffff00
/* The reset value of the ALT_CAN_PROTO_CERC_TEC register field. */
#define ALT_CAN_PROTO_CERC_TEC_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CERC_TEC field value from a register. */
#define ALT_CAN_PROTO_CERC_TEC_GET(value) (((value) & 0x000000ff) >> 0)
/* Produces a ALT_CAN_PROTO_CERC_TEC register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CERC_TEC_SET(value) (((value) << 0) & 0x000000ff)

/*
 * Field : Receive Error Counter - REC
 * 
 * Actual state of the Receive Error Counter. Values between 0 and 127.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CERC_REC register field. */
#define ALT_CAN_PROTO_CERC_REC_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CERC_REC register field. */
#define ALT_CAN_PROTO_CERC_REC_MSB        14
/* The width in bits of the ALT_CAN_PROTO_CERC_REC register field. */
#define ALT_CAN_PROTO_CERC_REC_WIDTH      7
/* The mask used to set the ALT_CAN_PROTO_CERC_REC register field value. */
#define ALT_CAN_PROTO_CERC_REC_SET_MSK    0x00007f00
/* The mask used to clear the ALT_CAN_PROTO_CERC_REC register field value. */
#define ALT_CAN_PROTO_CERC_REC_CLR_MSK    0xffff80ff
/* The reset value of the ALT_CAN_PROTO_CERC_REC register field. */
#define ALT_CAN_PROTO_CERC_REC_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CERC_REC field value from a register. */
#define ALT_CAN_PROTO_CERC_REC_GET(value) (((value) & 0x00007f00) >> 8)
/* Produces a ALT_CAN_PROTO_CERC_REC register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CERC_REC_SET(value) (((value) << 8) & 0x00007f00)

/*
 * Field : Receive Error Passive - RP
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                    
 * :--------------------------------|:------|:------------------------------------------------
 *  ALT_CAN_PROTO_CERC_RP_E_BELOW   | 0x0   | The Receive Error Counter is below the error   
 * :                                |       | passive level.                                 
 *  ALT_CAN_PROTO_CERC_RP_E_REACHED | 0x1   | The Receive Error Counter has reached the error
 * :                                |       | passive level as defined in the CAN            
 * :                                |       | Specification.                                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CERC_RP
 * 
 * The Receive Error Counter is below the error passive level.
 */
#define ALT_CAN_PROTO_CERC_RP_E_BELOW   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CERC_RP
 * 
 * The Receive Error Counter has reached the error passive level as defined in the
 * CAN Specification.
 */
#define ALT_CAN_PROTO_CERC_RP_E_REACHED 0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CERC_RP register field. */
#define ALT_CAN_PROTO_CERC_RP_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CERC_RP register field. */
#define ALT_CAN_PROTO_CERC_RP_MSB        15
/* The width in bits of the ALT_CAN_PROTO_CERC_RP register field. */
#define ALT_CAN_PROTO_CERC_RP_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CERC_RP register field value. */
#define ALT_CAN_PROTO_CERC_RP_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_PROTO_CERC_RP register field value. */
#define ALT_CAN_PROTO_CERC_RP_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_PROTO_CERC_RP register field. */
#define ALT_CAN_PROTO_CERC_RP_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CERC_RP field value from a register. */
#define ALT_CAN_PROTO_CERC_RP_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_PROTO_CERC_RP register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CERC_RP_SET(value) (((value) << 15) & 0x00008000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CERC.
 */
struct ALT_CAN_PROTO_CERC_s
{
    const uint32_t  TEC :  8;  /* Transmit Error Counter */
    const uint32_t  REC :  7;  /* Receive Error Counter */
    const uint32_t  RP  :  1;  /* Receive Error Passive */
    uint32_t            : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_CERC. */
typedef volatile struct ALT_CAN_PROTO_CERC_s  ALT_CAN_PROTO_CERC_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CERC register from the beginning of the component. */
#define ALT_CAN_PROTO_CERC_OFST        0x8
/* The address of the ALT_CAN_PROTO_CERC register. */
#define ALT_CAN_PROTO_CERC_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CERC_OFST))

/*
 * Register : Bit Timing / BRP Extension Register - CBT
 * 
 * This register is only writable if bits CCTRL.CCE and CCTRL.Init are set. The CAN
 * bit time may be programed in the range of [4 .. 25] time quanta. The CAN time
 * quantum may be programmed in the range of [1 .. 1024] CAN_CLK periods. For
 * details see Application Note 001 "Configuration of Bit Timing". The actual
 * interpretation by the hardware of this value is such that one more than the
 * value programmed here is used. TSeg1 is the sum of Prop_Seg and Phase_Seg1.
 * TSeg2 is Phase_Seg2. Therefore the length of the bit time is (programmed values)
 * [TSeg1 + TSeg2 + 3] tq or (functional values) [Sync_Seg + Prop_Seg + Phase_Seg1
 * + Phase_Seg2] tq.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                             
 * :--------|:-------|:------|:-----------------------------------------
 *  [5:0]   | RW     | 0x1   | Baud Rate Prescaler                     
 *  [7:6]   | RW     | 0x0   | (Re) Synchronization Jump Width         
 *  [11:8]  | RW     | 0x3   | The time segment before the sample point
 *  [14:12] | RW     | 0x2   | The time segment after the sample point 
 *  [15]    | ???    | 0x0   | *UNDEFINED*                             
 *  [19:16] | RW     | 0x0   | Baud Rate Prescaler Extension           
 *  [31:20] | ???    | 0x0   | *UNDEFINED*                             
 * 
 */
/*
 * Field : Baud Rate Prescaler - BRP
 * 
 * The value by which the oscillator frequency is divided for generating the bit
 * time quanta. The bit time is built up from a multiple of this quanta. Valid
 * values for the Baud Rate Prescaler are [0 .. 63]. The actual interpretation by
 * the hardware of this value is such that one more than the value programmed here
 * is used.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CBT_BRP register field. */
#define ALT_CAN_PROTO_CBT_BRP_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CBT_BRP register field. */
#define ALT_CAN_PROTO_CBT_BRP_MSB        5
/* The width in bits of the ALT_CAN_PROTO_CBT_BRP register field. */
#define ALT_CAN_PROTO_CBT_BRP_WIDTH      6
/* The mask used to set the ALT_CAN_PROTO_CBT_BRP register field value. */
#define ALT_CAN_PROTO_CBT_BRP_SET_MSK    0x0000003f
/* The mask used to clear the ALT_CAN_PROTO_CBT_BRP register field value. */
#define ALT_CAN_PROTO_CBT_BRP_CLR_MSK    0xffffffc0
/* The reset value of the ALT_CAN_PROTO_CBT_BRP register field. */
#define ALT_CAN_PROTO_CBT_BRP_RESET      0x1
/* Extracts the ALT_CAN_PROTO_CBT_BRP field value from a register. */
#define ALT_CAN_PROTO_CBT_BRP_GET(value) (((value) & 0x0000003f) >> 0)
/* Produces a ALT_CAN_PROTO_CBT_BRP register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CBT_BRP_SET(value) (((value) << 0) & 0x0000003f)

/*
 * Field : (Re) Synchronization Jump Width - SJW
 * 
 * Valid programmed values are [0 .. 3]. The actual interpretation by the hardware
 * of this value is such that one more than the value programmed here is used.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CBT_SJW register field. */
#define ALT_CAN_PROTO_CBT_SJW_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CBT_SJW register field. */
#define ALT_CAN_PROTO_CBT_SJW_MSB        7
/* The width in bits of the ALT_CAN_PROTO_CBT_SJW register field. */
#define ALT_CAN_PROTO_CBT_SJW_WIDTH      2
/* The mask used to set the ALT_CAN_PROTO_CBT_SJW register field value. */
#define ALT_CAN_PROTO_CBT_SJW_SET_MSK    0x000000c0
/* The mask used to clear the ALT_CAN_PROTO_CBT_SJW register field value. */
#define ALT_CAN_PROTO_CBT_SJW_CLR_MSK    0xffffff3f
/* The reset value of the ALT_CAN_PROTO_CBT_SJW register field. */
#define ALT_CAN_PROTO_CBT_SJW_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CBT_SJW field value from a register. */
#define ALT_CAN_PROTO_CBT_SJW_GET(value) (((value) & 0x000000c0) >> 6)
/* Produces a ALT_CAN_PROTO_CBT_SJW register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CBT_SJW_SET(value) (((value) << 6) & 0x000000c0)

/*
 * Field : The time segment before the sample point - TSeg1
 * 
 * Valid values for TSeg1 are [1 .. 15].
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CBT_TSEG1 register field. */
#define ALT_CAN_PROTO_CBT_TSEG1_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CBT_TSEG1 register field. */
#define ALT_CAN_PROTO_CBT_TSEG1_MSB        11
/* The width in bits of the ALT_CAN_PROTO_CBT_TSEG1 register field. */
#define ALT_CAN_PROTO_CBT_TSEG1_WIDTH      4
/* The mask used to set the ALT_CAN_PROTO_CBT_TSEG1 register field value. */
#define ALT_CAN_PROTO_CBT_TSEG1_SET_MSK    0x00000f00
/* The mask used to clear the ALT_CAN_PROTO_CBT_TSEG1 register field value. */
#define ALT_CAN_PROTO_CBT_TSEG1_CLR_MSK    0xfffff0ff
/* The reset value of the ALT_CAN_PROTO_CBT_TSEG1 register field. */
#define ALT_CAN_PROTO_CBT_TSEG1_RESET      0x3
/* Extracts the ALT_CAN_PROTO_CBT_TSEG1 field value from a register. */
#define ALT_CAN_PROTO_CBT_TSEG1_GET(value) (((value) & 0x00000f00) >> 8)
/* Produces a ALT_CAN_PROTO_CBT_TSEG1 register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CBT_TSEG1_SET(value) (((value) << 8) & 0x00000f00)

/*
 * Field : The time segment after the sample point - TSeg2
 * 
 * Valid values for TSeg2 are [0 .. 7].
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CBT_TSEG2 register field. */
#define ALT_CAN_PROTO_CBT_TSEG2_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CBT_TSEG2 register field. */
#define ALT_CAN_PROTO_CBT_TSEG2_MSB        14
/* The width in bits of the ALT_CAN_PROTO_CBT_TSEG2 register field. */
#define ALT_CAN_PROTO_CBT_TSEG2_WIDTH      3
/* The mask used to set the ALT_CAN_PROTO_CBT_TSEG2 register field value. */
#define ALT_CAN_PROTO_CBT_TSEG2_SET_MSK    0x00007000
/* The mask used to clear the ALT_CAN_PROTO_CBT_TSEG2 register field value. */
#define ALT_CAN_PROTO_CBT_TSEG2_CLR_MSK    0xffff8fff
/* The reset value of the ALT_CAN_PROTO_CBT_TSEG2 register field. */
#define ALT_CAN_PROTO_CBT_TSEG2_RESET      0x2
/* Extracts the ALT_CAN_PROTO_CBT_TSEG2 field value from a register. */
#define ALT_CAN_PROTO_CBT_TSEG2_GET(value) (((value) & 0x00007000) >> 12)
/* Produces a ALT_CAN_PROTO_CBT_TSEG2 register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CBT_TSEG2_SET(value) (((value) << 12) & 0x00007000)

/*
 * Field : Baud Rate Prescaler Extension - BRPE
 * 
 * By programming BRPE the Baud Rate Prescaler can be extended to values up to
 * 1023. The actual interpretation by the hardware is that one more than the value
 * programmed by BRPE (MSBs) and BRP (LSBs) is used.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CBT_BRPE register field. */
#define ALT_CAN_PROTO_CBT_BRPE_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CBT_BRPE register field. */
#define ALT_CAN_PROTO_CBT_BRPE_MSB        19
/* The width in bits of the ALT_CAN_PROTO_CBT_BRPE register field. */
#define ALT_CAN_PROTO_CBT_BRPE_WIDTH      4
/* The mask used to set the ALT_CAN_PROTO_CBT_BRPE register field value. */
#define ALT_CAN_PROTO_CBT_BRPE_SET_MSK    0x000f0000
/* The mask used to clear the ALT_CAN_PROTO_CBT_BRPE register field value. */
#define ALT_CAN_PROTO_CBT_BRPE_CLR_MSK    0xfff0ffff
/* The reset value of the ALT_CAN_PROTO_CBT_BRPE register field. */
#define ALT_CAN_PROTO_CBT_BRPE_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CBT_BRPE field value from a register. */
#define ALT_CAN_PROTO_CBT_BRPE_GET(value) (((value) & 0x000f0000) >> 16)
/* Produces a ALT_CAN_PROTO_CBT_BRPE register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CBT_BRPE_SET(value) (((value) << 16) & 0x000f0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CBT.
 */
struct ALT_CAN_PROTO_CBT_s
{
    uint32_t  BRP   :  6;  /* Baud Rate Prescaler */
    uint32_t  SJW   :  2;  /* (Re) Synchronization Jump Width */
    uint32_t  TSeg1 :  4;  /* The time segment before the sample point */
    uint32_t  TSeg2 :  3;  /* The time segment after the sample point */
    uint32_t        :  1;  /* *UNDEFINED* */
    uint32_t  BRPE  :  4;  /* Baud Rate Prescaler Extension */
    uint32_t        : 12;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_CBT. */
typedef volatile struct ALT_CAN_PROTO_CBT_s  ALT_CAN_PROTO_CBT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CBT register from the beginning of the component. */
#define ALT_CAN_PROTO_CBT_OFST        0xc
/* The address of the ALT_CAN_PROTO_CBT register. */
#define ALT_CAN_PROTO_CBT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CBT_OFST))

/*
 * Register : Interrupt Register - CIR
 * 
 * If several interrupts are pending, the CAN Interrupt Register will point to the
 * pending interrupt with the highest priority, disregarding their chronological
 * order. An interrupt remains pending until the CPU has cleared it. If IntID is
 * different from 0x00 and CCTRL.MIL is set, the interrupt port CAN_INT_MO is
 * active. The interrupt port remains active until IntID is back to value 0x00 (the
 * cause of the interrupt is reset) or until CCTRL.MIL is reset. If CCTRL.ILE is
 * set and CCTRL.MIL is reseted the Message Object interrupts will be routed to
 * interrupt port CAN_INT_STATUS. The interrupt port remains active until IntID is
 * back to value 0x00 (the cause of the interrupt is reset) or until CCTRL.MIL is
 * set or CCTRL.ILE is reset.
 * 
 * The Message Object's interrupt priority decreases with increasing message
 * number.
 * 
 * A message interrupt is cleared by clearing the Message Object's IntPnd bit.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                    
 * :--------|:-------|:------|:--------------------------------
 *  [7:0]   | R      | 0x0   | Interrupt Identifier           
 *  [14:8]  | ???    | 0x0   | *UNDEFINED*                    
 *  [15]    | R      | 0x0   | A Status Interrupt has occurred
 *  [31:16] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : Interrupt Identifier - IntId
 * 
 * 0x00 No Message Object interrupt is pending.
 * 
 * 0x01-0x80 Number of Message Object which caused the interrupt.
 * 
 * 0x81-0xFF unused.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CIR_INTID register field. */
#define ALT_CAN_PROTO_CIR_INTID_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CIR_INTID register field. */
#define ALT_CAN_PROTO_CIR_INTID_MSB        7
/* The width in bits of the ALT_CAN_PROTO_CIR_INTID register field. */
#define ALT_CAN_PROTO_CIR_INTID_WIDTH      8
/* The mask used to set the ALT_CAN_PROTO_CIR_INTID register field value. */
#define ALT_CAN_PROTO_CIR_INTID_SET_MSK    0x000000ff
/* The mask used to clear the ALT_CAN_PROTO_CIR_INTID register field value. */
#define ALT_CAN_PROTO_CIR_INTID_CLR_MSK    0xffffff00
/* The reset value of the ALT_CAN_PROTO_CIR_INTID register field. */
#define ALT_CAN_PROTO_CIR_INTID_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CIR_INTID field value from a register. */
#define ALT_CAN_PROTO_CIR_INTID_GET(value) (((value) & 0x000000ff) >> 0)
/* Produces a ALT_CAN_PROTO_CIR_INTID register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CIR_INTID_SET(value) (((value) << 0) & 0x000000ff)

/*
 * Field : A Status Interrupt has occurred - StatusInt
 * 
 * The Status Interrupt is cleared by reading the Status Register.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CIR_STATINT register field. */
#define ALT_CAN_PROTO_CIR_STATINT_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CIR_STATINT register field. */
#define ALT_CAN_PROTO_CIR_STATINT_MSB        15
/* The width in bits of the ALT_CAN_PROTO_CIR_STATINT register field. */
#define ALT_CAN_PROTO_CIR_STATINT_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CIR_STATINT register field value. */
#define ALT_CAN_PROTO_CIR_STATINT_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_PROTO_CIR_STATINT register field value. */
#define ALT_CAN_PROTO_CIR_STATINT_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_PROTO_CIR_STATINT register field. */
#define ALT_CAN_PROTO_CIR_STATINT_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CIR_STATINT field value from a register. */
#define ALT_CAN_PROTO_CIR_STATINT_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_PROTO_CIR_STATINT register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CIR_STATINT_SET(value) (((value) << 15) & 0x00008000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CIR.
 */
struct ALT_CAN_PROTO_CIR_s
{
    const uint32_t  IntId     :  8;  /* Interrupt Identifier */
    uint32_t                  :  7;  /* *UNDEFINED* */
    const uint32_t  StatusInt :  1;  /* A Status Interrupt has occurred */
    uint32_t                  : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_CIR. */
typedef volatile struct ALT_CAN_PROTO_CIR_s  ALT_CAN_PROTO_CIR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CIR register from the beginning of the component. */
#define ALT_CAN_PROTO_CIR_OFST        0x10
/* The address of the ALT_CAN_PROTO_CIR register. */
#define ALT_CAN_PROTO_CIR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CIR_OFST))

/*
 * Register : Test Register - CTR
 * 
 * The Test Mode is entered by setting bit CCTRL.Test to one. In Test Mode the bits
 * EXL, Tx1, Tx0, LBack and Silent in the Test Register are writable. Bit Rx
 * monitors the state of pin CAN_RXD and therefore is only readable. All Test
 * Register functions are disabled when bit Test is reset to zero.
 * 
 * Loop Back Mode and CAN_TXD Control Mode are hardware test modes, not to be used
 * by application programs.
 * 
 * Note: This register is only writable if bit CCTRL.Test is set.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset   | Description   
 * :-------|:-------|:--------|:---------------
 *  [2:0]  | ???    | 0x0     | *UNDEFINED*   
 *  [3]    | RW     | 0x0     | Silent Mode   
 *  [4]    | RW     | 0x0     | Loop Back Mode
 *  [6:5]  | RW     | 0x0     | Transmit Pin  
 *  [7]    | R      | Unknown | Receive Pin   
 *  [31:8] | ???    | 0x0     | *UNDEFINED*   
 * 
 */
/*
 * Field : Silent Mode - Silent
 * 
 * Silent Mode
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description               
 * :----------------------------------|:------|:---------------------------
 *  ALT_CAN_PROTO_CTR_SILENT_E_NORMAL | 0x0   | Normal operation.         
 *  ALT_CAN_PROTO_CTR_SILENT_E_SILENT | 0x1   | The CAN is in Silent Mode.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_SILENT
 * 
 * Normal operation.
 */
#define ALT_CAN_PROTO_CTR_SILENT_E_NORMAL   0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_SILENT
 * 
 * The CAN is in Silent Mode.
 */
#define ALT_CAN_PROTO_CTR_SILENT_E_SILENT   0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CTR_SILENT register field. */
#define ALT_CAN_PROTO_CTR_SILENT_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CTR_SILENT register field. */
#define ALT_CAN_PROTO_CTR_SILENT_MSB        3
/* The width in bits of the ALT_CAN_PROTO_CTR_SILENT register field. */
#define ALT_CAN_PROTO_CTR_SILENT_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CTR_SILENT register field value. */
#define ALT_CAN_PROTO_CTR_SILENT_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_PROTO_CTR_SILENT register field value. */
#define ALT_CAN_PROTO_CTR_SILENT_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_PROTO_CTR_SILENT register field. */
#define ALT_CAN_PROTO_CTR_SILENT_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CTR_SILENT field value from a register. */
#define ALT_CAN_PROTO_CTR_SILENT_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_PROTO_CTR_SILENT register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CTR_SILENT_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Loop Back Mode - LBack
 * 
 * Loop Back Mode
 * 
 * Field Enumeration Values:
 * 
 *  Enum                           | Value | Description                
 * :-------------------------------|:------|:----------------------------
 *  ALT_CAN_PROTO_CTR_LBACK_E_DISD | 0x0   | Loop Back Mode is disabled.
 *  ALT_CAN_PROTO_CTR_LBACK_E_END  | 0x1   | Loop Back Mode is enabled. 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_LBACK
 * 
 * Loop Back Mode is disabled.
 */
#define ALT_CAN_PROTO_CTR_LBACK_E_DISD  0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_LBACK
 * 
 * Loop Back Mode is enabled.
 */
#define ALT_CAN_PROTO_CTR_LBACK_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CTR_LBACK register field. */
#define ALT_CAN_PROTO_CTR_LBACK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CTR_LBACK register field. */
#define ALT_CAN_PROTO_CTR_LBACK_MSB        4
/* The width in bits of the ALT_CAN_PROTO_CTR_LBACK register field. */
#define ALT_CAN_PROTO_CTR_LBACK_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CTR_LBACK register field value. */
#define ALT_CAN_PROTO_CTR_LBACK_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_PROTO_CTR_LBACK register field value. */
#define ALT_CAN_PROTO_CTR_LBACK_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_PROTO_CTR_LBACK register field. */
#define ALT_CAN_PROTO_CTR_LBACK_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CTR_LBACK field value from a register. */
#define ALT_CAN_PROTO_CTR_LBACK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_PROTO_CTR_LBACK register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CTR_LBACK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Transmit Pin - Tx
 * 
 * Controls CAN_TXD pin.  Setting to non-zero disturbs message transfer.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                                  
 * :---------------------------------|:------|:----------------------------------------------
 *  ALT_CAN_PROTO_CTR_TX_E_RST       | 0x0   | Reset value, CAN_TXD is controlled by the    
 * :                                 |       | CAN_Core.                                    
 *  ALT_CAN_PROTO_CTR_TX_E_SMPL      | 0x1   | Sample Point can be monitored at CAN_TXD pin.
 *  ALT_CAN_PROTO_CTR_TX_E_DOMINANT  | 0x2   | CAN_TXD pin drives a dominant (0) value.     
 *  ALT_CAN_PROTO_CTR_TX_E_RECESSIVE | 0x3   | CAN_TXD pin drives a recessive (1) value.    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_TX
 * 
 * Reset value, CAN_TXD is controlled by the CAN_Core.
 */
#define ALT_CAN_PROTO_CTR_TX_E_RST          0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_TX
 * 
 * Sample Point can be monitored at CAN_TXD pin.
 */
#define ALT_CAN_PROTO_CTR_TX_E_SMPL         0x1
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_TX
 * 
 * CAN_TXD pin drives a dominant (0) value.
 */
#define ALT_CAN_PROTO_CTR_TX_E_DOMINANT     0x2
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_TX
 * 
 * CAN_TXD pin drives a recessive (1) value.
 */
#define ALT_CAN_PROTO_CTR_TX_E_RECESSIVE    0x3

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CTR_TX register field. */
#define ALT_CAN_PROTO_CTR_TX_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CTR_TX register field. */
#define ALT_CAN_PROTO_CTR_TX_MSB        6
/* The width in bits of the ALT_CAN_PROTO_CTR_TX register field. */
#define ALT_CAN_PROTO_CTR_TX_WIDTH      2
/* The mask used to set the ALT_CAN_PROTO_CTR_TX register field value. */
#define ALT_CAN_PROTO_CTR_TX_SET_MSK    0x00000060
/* The mask used to clear the ALT_CAN_PROTO_CTR_TX register field value. */
#define ALT_CAN_PROTO_CTR_TX_CLR_MSK    0xffffff9f
/* The reset value of the ALT_CAN_PROTO_CTR_TX register field. */
#define ALT_CAN_PROTO_CTR_TX_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CTR_TX field value from a register. */
#define ALT_CAN_PROTO_CTR_TX_GET(value) (((value) & 0x00000060) >> 5)
/* Produces a ALT_CAN_PROTO_CTR_TX register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CTR_TX_SET(value) (((value) << 5) & 0x00000060)

/*
 * Field : Receive Pin - Rx
 * 
 * Monitors the actual value of the CAN_RXD pin.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                            
 * :---------------------------------|:------|:----------------------------------------
 *  ALT_CAN_PROTO_CTR_RX_E_DOMINANT  | 0x0   | The CAN bus is dominant (CAN_RXD = 0). 
 *  ALT_CAN_PROTO_CTR_RX_E_RECESSIVE | 0x1   | The CAN bus is recessive (CAN_RXD = 1).
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_RX
 * 
 * The CAN bus is dominant (CAN_RXD = 0).
 */
#define ALT_CAN_PROTO_CTR_RX_E_DOMINANT     0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CTR_RX
 * 
 * The CAN bus is recessive (CAN_RXD = 1).
 */
#define ALT_CAN_PROTO_CTR_RX_E_RECESSIVE    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CTR_RX register field. */
#define ALT_CAN_PROTO_CTR_RX_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CTR_RX register field. */
#define ALT_CAN_PROTO_CTR_RX_MSB        7
/* The width in bits of the ALT_CAN_PROTO_CTR_RX register field. */
#define ALT_CAN_PROTO_CTR_RX_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CTR_RX register field value. */
#define ALT_CAN_PROTO_CTR_RX_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_PROTO_CTR_RX register field value. */
#define ALT_CAN_PROTO_CTR_RX_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_PROTO_CTR_RX register field is UNKNOWN. */
#define ALT_CAN_PROTO_CTR_RX_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CTR_RX field value from a register. */
#define ALT_CAN_PROTO_CTR_RX_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_PROTO_CTR_RX register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CTR_RX_SET(value) (((value) << 7) & 0x00000080)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CTR.
 */
struct ALT_CAN_PROTO_CTR_s
{
    uint32_t               :  3;  /* *UNDEFINED* */
    uint32_t        Silent :  1;  /* Silent Mode */
    uint32_t        LBack  :  1;  /* Loop Back Mode */
    uint32_t        Tx     :  2;  /* Transmit Pin */
    const uint32_t  Rx     :  1;  /* Receive Pin */
    uint32_t               : 24;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_CTR. */
typedef volatile struct ALT_CAN_PROTO_CTR_s  ALT_CAN_PROTO_CTR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CTR register from the beginning of the component. */
#define ALT_CAN_PROTO_CTR_OFST        0x14
/* The address of the ALT_CAN_PROTO_CTR register. */
#define ALT_CAN_PROTO_CTR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CTR_OFST))

/*
 * Register : Function Register - CFR
 * 
 * The Function Register controls the features RAM_Initialisation and Power_Down
 * also by application register.
 * 
 * The CAN module can be prepared for Power_Down by setting the port
 * CAN_CLKSTOP_REQ to one or writing to CFR.ClkStReq a one. The power down state is
 * left by setting port CAN_CLKSTOP_REQ to zero or writing to CFR.ClkStReq a zero,
 * acknowledged by CAN_CLKSTOP_ACK is going to zero as well as CFR.ClkStAck. The
 * CCTRL.Init bit is left one and has to be written by the application to re-enable
 * CAN transfers.
 * 
 * Note: It's recommended to use either the ports CAN_CLKSTOP_REQ and
 * CAN_CLKSTOP_ACK or the CCTRL.ClkStReq and CFR.ClkStAck. The application
 * CFR.ClkStReq showsalso the actual status of the portCAN_CLKSTOP_REQ.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                             
 * :-------|:-------|:------|:-----------------------------------------
 *  [0]    | R      | 0x0   | Clock Stop Acknowledgement              
 *  [1]    | RW     | 0x0   | Clock Stop Request                      
 *  [2]    | ???    | 0x0   | *UNDEFINED*                             
 *  [3]    | RW     | 0x0   | Request for automatic RAM Initialization
 *  [31:4] | ???    | 0x0   | *UNDEFINED*                             
 * 
 */
/*
 * Field : Clock Stop Acknowledgement - ClkStAck
 * 
 * Clock Stop Acknowledgement
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CFR_CLKSTACK register field. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CFR_CLKSTACK register field. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_MSB        0
/* The width in bits of the ALT_CAN_PROTO_CFR_CLKSTACK register field. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CFR_CLKSTACK register field value. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_PROTO_CFR_CLKSTACK register field value. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_PROTO_CFR_CLKSTACK register field. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CFR_CLKSTACK field value from a register. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_PROTO_CFR_CLKSTACK register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CFR_CLKSTACK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Clock Stop Request - ClkStReq
 * 
 * Clock Stop Request
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CFR_CLKSTREQ register field. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CFR_CLKSTREQ register field. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_MSB        1
/* The width in bits of the ALT_CAN_PROTO_CFR_CLKSTREQ register field. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CFR_CLKSTREQ register field value. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_PROTO_CFR_CLKSTREQ register field value. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_PROTO_CFR_CLKSTREQ register field. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CFR_CLKSTREQ field value from a register. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_PROTO_CFR_CLKSTREQ register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CFR_CLKSTREQ_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Request for automatic RAM Initialization - RAMinit
 * 
 * Request for automatic RAM Initialization
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                     
 * :--------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_PROTO_CFR_RAMINIT_E_NOAUTO    | 0x0   | No automatic RAM Initialization is requested, if
 * :                                      |       | once a ram initialization is started a write of 
 * :                                      |       | a zero will be ignored. The Bit is cleared by   
 * :                                      |       | hardware, after RAM Initialization is completed.
 *  ALT_CAN_PROTO_CFR_RAMINIT_E_STARTAUTO | 0x1   | Start automatic RAM Initialization. All message 
 * :                                      |       | objects will be written with zeros and the      
 * :                                      |       | parity bits will be set. The RAMInit Bit will   
 * :                                      |       | return to zero after the RAM-Initialization     
 * :                                      |       | process is completed. A RAM Initialization      
 * :                                      |       | Request is only possible if CCTRL.Init is set.  
 * :                                      |       | The duration of the automatic RAM Initialization
 * :                                      |       | is messagebuffer-size + 4 host_clock cycles.    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_CFR_RAMINIT
 * 
 * No automatic RAM Initialization is requested, if once a ram initialization is
 * started a write of a zero will be ignored. The Bit is cleared by hardware, after
 * RAM Initialization is completed.
 */
#define ALT_CAN_PROTO_CFR_RAMINIT_E_NOAUTO      0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_CFR_RAMINIT
 * 
 * Start automatic RAM Initialization. All message objects will be written with
 * zeros and the parity bits will be set. The RAMInit Bit will return to zero after
 * the RAM-Initialization process is completed. A RAM Initialization Request is
 * only possible if CCTRL.Init is set. The duration of the automatic RAM
 * Initialization is messagebuffer-size + 4 host_clock cycles.
 */
#define ALT_CAN_PROTO_CFR_RAMINIT_E_STARTAUTO   0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CFR_RAMINIT register field. */
#define ALT_CAN_PROTO_CFR_RAMINIT_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CFR_RAMINIT register field. */
#define ALT_CAN_PROTO_CFR_RAMINIT_MSB        3
/* The width in bits of the ALT_CAN_PROTO_CFR_RAMINIT register field. */
#define ALT_CAN_PROTO_CFR_RAMINIT_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_CFR_RAMINIT register field value. */
#define ALT_CAN_PROTO_CFR_RAMINIT_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_PROTO_CFR_RAMINIT register field value. */
#define ALT_CAN_PROTO_CFR_RAMINIT_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_PROTO_CFR_RAMINIT register field. */
#define ALT_CAN_PROTO_CFR_RAMINIT_RESET      0x0
/* Extracts the ALT_CAN_PROTO_CFR_RAMINIT field value from a register. */
#define ALT_CAN_PROTO_CFR_RAMINIT_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_PROTO_CFR_RAMINIT register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CFR_RAMINIT_SET(value) (((value) << 3) & 0x00000008)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CFR.
 */
struct ALT_CAN_PROTO_CFR_s
{
    const uint32_t  ClkStAck :  1;  /* Clock Stop Acknowledgement */
    uint32_t        ClkStReq :  1;  /* Clock Stop Request */
    uint32_t                 :  1;  /* *UNDEFINED* */
    uint32_t        RAMinit  :  1;  /* Request for automatic RAM Initialization */
    uint32_t                 : 28;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_CFR. */
typedef volatile struct ALT_CAN_PROTO_CFR_s  ALT_CAN_PROTO_CFR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CFR register from the beginning of the component. */
#define ALT_CAN_PROTO_CFR_OFST        0x18
/* The address of the ALT_CAN_PROTO_CFR register. */
#define ALT_CAN_PROTO_CFR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CFR_OFST))

/*
 * Register : Core Release Register - CRR
 * 
 * Core Release Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description             
 * :--------|:-------|:------|:-------------------------
 *  [7:0]   | R      | 0x28  | Design Time Stamp, Day  
 *  [15:8]  | R      | 0x11  | Design Time Stamp, Month
 *  [19:16] | R      | 0x6   | Design Time Stamp, Year 
 *  [27:20] | R      | 0x11  | Step of Core Release    
 *  [31:28] | R      | 0x1   | Core Release            
 * 
 */
/*
 * Field : Design Time Stamp, Day - DAY
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CRR_DAY register field. */
#define ALT_CAN_PROTO_CRR_DAY_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CRR_DAY register field. */
#define ALT_CAN_PROTO_CRR_DAY_MSB        7
/* The width in bits of the ALT_CAN_PROTO_CRR_DAY register field. */
#define ALT_CAN_PROTO_CRR_DAY_WIDTH      8
/* The mask used to set the ALT_CAN_PROTO_CRR_DAY register field value. */
#define ALT_CAN_PROTO_CRR_DAY_SET_MSK    0x000000ff
/* The mask used to clear the ALT_CAN_PROTO_CRR_DAY register field value. */
#define ALT_CAN_PROTO_CRR_DAY_CLR_MSK    0xffffff00
/* The reset value of the ALT_CAN_PROTO_CRR_DAY register field. */
#define ALT_CAN_PROTO_CRR_DAY_RESET      0x28
/* Extracts the ALT_CAN_PROTO_CRR_DAY field value from a register. */
#define ALT_CAN_PROTO_CRR_DAY_GET(value) (((value) & 0x000000ff) >> 0)
/* Produces a ALT_CAN_PROTO_CRR_DAY register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CRR_DAY_SET(value) (((value) << 0) & 0x000000ff)

/*
 * Field : Design Time Stamp, Month - MON
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CRR_MON register field. */
#define ALT_CAN_PROTO_CRR_MON_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CRR_MON register field. */
#define ALT_CAN_PROTO_CRR_MON_MSB        15
/* The width in bits of the ALT_CAN_PROTO_CRR_MON register field. */
#define ALT_CAN_PROTO_CRR_MON_WIDTH      8
/* The mask used to set the ALT_CAN_PROTO_CRR_MON register field value. */
#define ALT_CAN_PROTO_CRR_MON_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_CAN_PROTO_CRR_MON register field value. */
#define ALT_CAN_PROTO_CRR_MON_CLR_MSK    0xffff00ff
/* The reset value of the ALT_CAN_PROTO_CRR_MON register field. */
#define ALT_CAN_PROTO_CRR_MON_RESET      0x11
/* Extracts the ALT_CAN_PROTO_CRR_MON field value from a register. */
#define ALT_CAN_PROTO_CRR_MON_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_CAN_PROTO_CRR_MON register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CRR_MON_SET(value) (((value) << 8) & 0x0000ff00)

/*
 * Field : Design Time Stamp, Year - YEAR
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CRR_YEAR register field. */
#define ALT_CAN_PROTO_CRR_YEAR_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CRR_YEAR register field. */
#define ALT_CAN_PROTO_CRR_YEAR_MSB        19
/* The width in bits of the ALT_CAN_PROTO_CRR_YEAR register field. */
#define ALT_CAN_PROTO_CRR_YEAR_WIDTH      4
/* The mask used to set the ALT_CAN_PROTO_CRR_YEAR register field value. */
#define ALT_CAN_PROTO_CRR_YEAR_SET_MSK    0x000f0000
/* The mask used to clear the ALT_CAN_PROTO_CRR_YEAR register field value. */
#define ALT_CAN_PROTO_CRR_YEAR_CLR_MSK    0xfff0ffff
/* The reset value of the ALT_CAN_PROTO_CRR_YEAR register field. */
#define ALT_CAN_PROTO_CRR_YEAR_RESET      0x6
/* Extracts the ALT_CAN_PROTO_CRR_YEAR field value from a register. */
#define ALT_CAN_PROTO_CRR_YEAR_GET(value) (((value) & 0x000f0000) >> 16)
/* Produces a ALT_CAN_PROTO_CRR_YEAR register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CRR_YEAR_SET(value) (((value) << 16) & 0x000f0000)

/*
 * Field : Step of Core Release - STEP
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CRR_STEP register field. */
#define ALT_CAN_PROTO_CRR_STEP_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CRR_STEP register field. */
#define ALT_CAN_PROTO_CRR_STEP_MSB        27
/* The width in bits of the ALT_CAN_PROTO_CRR_STEP register field. */
#define ALT_CAN_PROTO_CRR_STEP_WIDTH      8
/* The mask used to set the ALT_CAN_PROTO_CRR_STEP register field value. */
#define ALT_CAN_PROTO_CRR_STEP_SET_MSK    0x0ff00000
/* The mask used to clear the ALT_CAN_PROTO_CRR_STEP register field value. */
#define ALT_CAN_PROTO_CRR_STEP_CLR_MSK    0xf00fffff
/* The reset value of the ALT_CAN_PROTO_CRR_STEP register field. */
#define ALT_CAN_PROTO_CRR_STEP_RESET      0x11
/* Extracts the ALT_CAN_PROTO_CRR_STEP field value from a register. */
#define ALT_CAN_PROTO_CRR_STEP_GET(value) (((value) & 0x0ff00000) >> 20)
/* Produces a ALT_CAN_PROTO_CRR_STEP register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CRR_STEP_SET(value) (((value) << 20) & 0x0ff00000)

/*
 * Field : Core Release - REL
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_CRR_REL register field. */
#define ALT_CAN_PROTO_CRR_REL_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_CRR_REL register field. */
#define ALT_CAN_PROTO_CRR_REL_MSB        31
/* The width in bits of the ALT_CAN_PROTO_CRR_REL register field. */
#define ALT_CAN_PROTO_CRR_REL_WIDTH      4
/* The mask used to set the ALT_CAN_PROTO_CRR_REL register field value. */
#define ALT_CAN_PROTO_CRR_REL_SET_MSK    0xf0000000
/* The mask used to clear the ALT_CAN_PROTO_CRR_REL register field value. */
#define ALT_CAN_PROTO_CRR_REL_CLR_MSK    0x0fffffff
/* The reset value of the ALT_CAN_PROTO_CRR_REL register field. */
#define ALT_CAN_PROTO_CRR_REL_RESET      0x1
/* Extracts the ALT_CAN_PROTO_CRR_REL field value from a register. */
#define ALT_CAN_PROTO_CRR_REL_GET(value) (((value) & 0xf0000000) >> 28)
/* Produces a ALT_CAN_PROTO_CRR_REL register field value suitable for setting the register. */
#define ALT_CAN_PROTO_CRR_REL_SET(value) (((value) << 28) & 0xf0000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_CRR.
 */
struct ALT_CAN_PROTO_CRR_s
{
    const uint32_t  DAY  :  8;  /* Design Time Stamp, Day */
    const uint32_t  MON  :  8;  /* Design Time Stamp, Month */
    const uint32_t  YEAR :  4;  /* Design Time Stamp, Year */
    const uint32_t  STEP :  8;  /* Step of Core Release */
    const uint32_t  REL  :  4;  /* Core Release */
};

/* The typedef declaration for register ALT_CAN_PROTO_CRR. */
typedef volatile struct ALT_CAN_PROTO_CRR_s  ALT_CAN_PROTO_CRR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_CRR register from the beginning of the component. */
#define ALT_CAN_PROTO_CRR_OFST        0x20
/* The address of the ALT_CAN_PROTO_CRR register. */
#define ALT_CAN_PROTO_CRR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_CRR_OFST))

/*
 * Register : Hardware Configuration Status Register - HWS
 * 
 * Hardware Configuration Status Register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description         
 * :-------|:-------|:------|:---------------------
 *  [1:0]  | R      | 0x3   | Message Buffer Count
 *  [2]    | R      | 0x0   | Parity Generation   
 *  [31:3] | ???    | 0x0   | *UNDEFINED*         
 * 
 */
/*
 * Field : Message Buffer Count - mb_w
 * 
 * Message Buffer Count
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description        
 * :------------------------------------|:------|:--------------------
 *  ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS16  | 0x0   | 16 Message Objects 
 *  ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS32  | 0x1   | 32 Message Objects 
 *  ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS64  | 0x2   | 64 Message Objects 
 *  ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS128 | 0x3   | 128 Message Objects
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_HWS_MB_W
 * 
 * 16 Message Objects
 */
#define ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS16  0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_HWS_MB_W
 * 
 * 32 Message Objects
 */
#define ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS32  0x1
/*
 * Enumerated value for register field ALT_CAN_PROTO_HWS_MB_W
 * 
 * 64 Message Objects
 */
#define ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS64  0x2
/*
 * Enumerated value for register field ALT_CAN_PROTO_HWS_MB_W
 * 
 * 128 Message Objects
 */
#define ALT_CAN_PROTO_HWS_MB_W_E_MSGOBJS128 0x3

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_HWS_MB_W register field. */
#define ALT_CAN_PROTO_HWS_MB_W_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_HWS_MB_W register field. */
#define ALT_CAN_PROTO_HWS_MB_W_MSB        1
/* The width in bits of the ALT_CAN_PROTO_HWS_MB_W register field. */
#define ALT_CAN_PROTO_HWS_MB_W_WIDTH      2
/* The mask used to set the ALT_CAN_PROTO_HWS_MB_W register field value. */
#define ALT_CAN_PROTO_HWS_MB_W_SET_MSK    0x00000003
/* The mask used to clear the ALT_CAN_PROTO_HWS_MB_W register field value. */
#define ALT_CAN_PROTO_HWS_MB_W_CLR_MSK    0xfffffffc
/* The reset value of the ALT_CAN_PROTO_HWS_MB_W register field. */
#define ALT_CAN_PROTO_HWS_MB_W_RESET      0x3
/* Extracts the ALT_CAN_PROTO_HWS_MB_W field value from a register. */
#define ALT_CAN_PROTO_HWS_MB_W_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_CAN_PROTO_HWS_MB_W register field value suitable for setting the register. */
#define ALT_CAN_PROTO_HWS_MB_W_SET(value) (((value) << 0) & 0x00000003)

/*
 * Field : Parity Generation - paren
 * 
 * Parity Generation
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                              
 * :-------------------------------------|:------|:------------------------------------------
 *  ALT_CAN_PROTO_HWS_PAREN_E_NOTPRESENT | 0x0   | Parity generation harware is not present.
 *  ALT_CAN_PROTO_HWS_PAREN_E_PRESENT    | 0x1   | Parity generation harware is present.    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_PROTO_HWS_PAREN
 * 
 * Parity generation harware is not present.
 */
#define ALT_CAN_PROTO_HWS_PAREN_E_NOTPRESENT    0x0
/*
 * Enumerated value for register field ALT_CAN_PROTO_HWS_PAREN
 * 
 * Parity generation harware is present.
 */
#define ALT_CAN_PROTO_HWS_PAREN_E_PRESENT       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_PROTO_HWS_PAREN register field. */
#define ALT_CAN_PROTO_HWS_PAREN_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_PROTO_HWS_PAREN register field. */
#define ALT_CAN_PROTO_HWS_PAREN_MSB        2
/* The width in bits of the ALT_CAN_PROTO_HWS_PAREN register field. */
#define ALT_CAN_PROTO_HWS_PAREN_WIDTH      1
/* The mask used to set the ALT_CAN_PROTO_HWS_PAREN register field value. */
#define ALT_CAN_PROTO_HWS_PAREN_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_PROTO_HWS_PAREN register field value. */
#define ALT_CAN_PROTO_HWS_PAREN_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_PROTO_HWS_PAREN register field. */
#define ALT_CAN_PROTO_HWS_PAREN_RESET      0x0
/* Extracts the ALT_CAN_PROTO_HWS_PAREN field value from a register. */
#define ALT_CAN_PROTO_HWS_PAREN_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_PROTO_HWS_PAREN register field value suitable for setting the register. */
#define ALT_CAN_PROTO_HWS_PAREN_SET(value) (((value) << 2) & 0x00000004)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_PROTO_HWS.
 */
struct ALT_CAN_PROTO_HWS_s
{
    const uint32_t  mb_w  :  2;  /* Message Buffer Count */
    const uint32_t  paren :  1;  /* Parity Generation */
    uint32_t              : 29;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_PROTO_HWS. */
typedef volatile struct ALT_CAN_PROTO_HWS_s  ALT_CAN_PROTO_HWS_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_PROTO_HWS register from the beginning of the component. */
#define ALT_CAN_PROTO_HWS_OFST        0x24
/* The address of the ALT_CAN_PROTO_HWS register. */
#define ALT_CAN_PROTO_HWS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_PROTO_HWS_OFST))

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_CAN_PROTO.
 */
struct ALT_CAN_PROTO_s
{
    volatile ALT_CAN_PROTO_CCTL_t  CCTRL;           /* ALT_CAN_PROTO_CCTL */
    volatile ALT_CAN_PROTO_CSTS_t  CSTS;            /* ALT_CAN_PROTO_CSTS */
    volatile ALT_CAN_PROTO_CERC_t  CERC;            /* ALT_CAN_PROTO_CERC */
    volatile ALT_CAN_PROTO_CBT_t   CBT;             /* ALT_CAN_PROTO_CBT */
    volatile ALT_CAN_PROTO_CIR_t   CIR;             /* ALT_CAN_PROTO_CIR */
    volatile ALT_CAN_PROTO_CTR_t   CTR;             /* ALT_CAN_PROTO_CTR */
    volatile ALT_CAN_PROTO_CFR_t   CFR;             /* ALT_CAN_PROTO_CFR */
    volatile uint32_t              _pad_0x1c_0x1f;  /* *UNDEFINED* */
    volatile ALT_CAN_PROTO_CRR_t   CRR;             /* ALT_CAN_PROTO_CRR */
    volatile ALT_CAN_PROTO_HWS_t   HWS;             /* ALT_CAN_PROTO_HWS */
};

/* The typedef declaration for register group ALT_CAN_PROTO. */
typedef volatile struct ALT_CAN_PROTO_s  ALT_CAN_PROTO_t;
/* The struct declaration for the raw register contents of register group ALT_CAN_PROTO. */
struct ALT_CAN_PROTO_raw_s
{
    volatile uint32_t  CCTRL;           /* ALT_CAN_PROTO_CCTL */
    volatile uint32_t  CSTS;            /* ALT_CAN_PROTO_CSTS */
    volatile uint32_t  CERC;            /* ALT_CAN_PROTO_CERC */
    volatile uint32_t  CBT;             /* ALT_CAN_PROTO_CBT */
    volatile uint32_t  CIR;             /* ALT_CAN_PROTO_CIR */
    volatile uint32_t  CTR;             /* ALT_CAN_PROTO_CTR */
    volatile uint32_t  CFR;             /* ALT_CAN_PROTO_CFR */
    volatile uint32_t  _pad_0x1c_0x1f;  /* *UNDEFINED* */
    volatile uint32_t  CRR;             /* ALT_CAN_PROTO_CRR */
    volatile uint32_t  HWS;             /* ALT_CAN_PROTO_HWS */
};

/* The typedef declaration for the raw register contents of register group ALT_CAN_PROTO. */
typedef volatile struct ALT_CAN_PROTO_raw_s  ALT_CAN_PROTO_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Message Handler Group - ALT_CAN_MSGHAND
 * Message Handler Group
 * 
 * These registers are related to the operation of the Message Handler. The Message
 * Handler is a state machine that controls the data transfer between the single
 * ported Message RAM and the CAN Core's Rx/Tx Shift Register. It also handles
 * acceptance filtering and the interrupt setting as programmed in the Control and
 * Configuration Registers.
 * 
 */
/*
 * Register : Transmission Request X Register - MOTRX
 * 
 * Reading this register allows the CPU to quickly detect if any of the
 * transmission request bits in each of the MOTRA, MOTRB, MOTRC, and MOTRD
 * Transmission Request Registers are set.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description
 * :--------|:-------|:------|:------------
 *  [0]     | R      | 0x0   | TxRqstA    
 *  [1]     | R      | 0x0   | TxRqstA    
 *  [2]     | R      | 0x0   | TxRqstA    
 *  [3]     | R      | 0x0   | TxRqstA    
 *  [4]     | R      | 0x0   | TxRqstB    
 *  [5]     | R      | 0x0   | TxRqstB    
 *  [6]     | R      | 0x0   | TxRqstB    
 *  [7]     | R      | 0x0   | TxRqstB    
 *  [8]     | R      | 0x0   | TxRqstC    
 *  [9]     | R      | 0x0   | TxRqstC    
 *  [10]    | R      | 0x0   | TxRqstC    
 *  [11]    | R      | 0x0   | TxRqstC    
 *  [12]    | R      | 0x0   | TxRqstD    
 *  [13]    | R      | 0x0   | TxRqstD    
 *  [14]    | R      | 0x0   | TxRqstD    
 *  [15]    | R      | 0x0   | TxRqstD    
 *  [31:16] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : TxRqstA - TxRqstA_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRA register. Array
 * index i corresponds to byte i of the MOTRA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRA are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRA are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0
 * 
 * The Message Objects in the corresponding byte of MOTRA are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRA are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : TxRqstA - TxRqstA_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRA register. Array
 * index i corresponds to byte i of the MOTRA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRA are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRA are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1
 * 
 * The Message Objects in the corresponding byte of MOTRA are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRA are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : TxRqstA - TxRqstA_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRA register. Array
 * index i corresponds to byte i of the MOTRA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRA are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRA are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2
 * 
 * The Message Objects in the corresponding byte of MOTRA are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRA are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : TxRqstA - TxRqstA_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRA register. Array
 * index i corresponds to byte i of the MOTRA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRA are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRA are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3
 * 
 * The Message Objects in the corresponding byte of MOTRA are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRA are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTA_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : TxRqstB - TxRqstB_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRB register. Array
 * index i corresponds to byte i of the MOTRB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRB are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRB are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0
 * 
 * The Message Objects in the corresponding byte of MOTRB are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRB are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_0_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : TxRqstB - TxRqstB_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRB register. Array
 * index i corresponds to byte i of the MOTRB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRB are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRB are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1
 * 
 * The Message Objects in the corresponding byte of MOTRB are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRB are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_1_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : TxRqstB - TxRqstB_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRB register. Array
 * index i corresponds to byte i of the MOTRB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRB are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRB are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2
 * 
 * The Message Objects in the corresponding byte of MOTRB are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRB are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_2_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : TxRqstB - TxRqstB_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRB register. Array
 * index i corresponds to byte i of the MOTRB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRB are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRB are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3
 * 
 * The Message Objects in the corresponding byte of MOTRB are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRB are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTB_3_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : TxRqstC - TxRqstC_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRC register. Array
 * index i corresponds to byte i of the MOTRC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRC are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRC are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0
 * 
 * The Message Objects in the corresponding byte of MOTRC are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRC are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_0_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : TxRqstC - TxRqstC_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRC register. Array
 * index i corresponds to byte i of the MOTRC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRC are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRC are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1
 * 
 * The Message Objects in the corresponding byte of MOTRC are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRC are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_1_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : TxRqstC - TxRqstC_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRC register. Array
 * index i corresponds to byte i of the MOTRC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRC are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRC are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2
 * 
 * The Message Objects in the corresponding byte of MOTRC are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRC are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_2_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : TxRqstC - TxRqstC_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRC register. Array
 * index i corresponds to byte i of the MOTRC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRC are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRC are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3
 * 
 * The Message Objects in the corresponding byte of MOTRC are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRC are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTC_3_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : TxRqstD - TxRqstD_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRD register. Array
 * index i corresponds to byte i of the MOTRD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRD are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRD are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0
 * 
 * The Message Objects in the corresponding byte of MOTRD are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRD are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_0_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : TxRqstD - TxRqstD_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRD register. Array
 * index i corresponds to byte i of the MOTRD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRD are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRD are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1
 * 
 * The Message Objects in the corresponding byte of MOTRD are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRD are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_1_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : TxRqstD - TxRqstD_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRD register. Array
 * index i corresponds to byte i of the MOTRD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRD are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRD are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2
 * 
 * The Message Objects in the corresponding byte of MOTRD are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRD are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_2_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : TxRqstD - TxRqstD_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOTRD register. Array
 * index i corresponds to byte i of the MOTRD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_E_NOTWAITING | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MOTRD are not waiting for transmission.         
 *  ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_E_PENDING    | 0x1   | One or more of the transmission of the Message  
 * :                                             |       | Objects in the corresponding byte of MOTRD are  
 * :                                             |       | requested and are not yet done.                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3
 * 
 * The Message Objects in the corresponding byte of MOTRD are not waiting for
 * transmission.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3
 * 
 * One or more of the transmission of the Message Objects in the corresponding byte
 * of MOTRD are requested and are not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 register field. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRX_TXRQSTD_3_SET(value) (((value) << 15) & 0x00008000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MOTRX.
 */
struct ALT_CAN_MSGHAND_MOTRX_s
{
    const uint32_t  TxRqstA_0 :  1;  /* TxRqstA */
    const uint32_t  TxRqstA_1 :  1;  /* TxRqstA */
    const uint32_t  TxRqstA_2 :  1;  /* TxRqstA */
    const uint32_t  TxRqstA_3 :  1;  /* TxRqstA */
    const uint32_t  TxRqstB_0 :  1;  /* TxRqstB */
    const uint32_t  TxRqstB_1 :  1;  /* TxRqstB */
    const uint32_t  TxRqstB_2 :  1;  /* TxRqstB */
    const uint32_t  TxRqstB_3 :  1;  /* TxRqstB */
    const uint32_t  TxRqstC_0 :  1;  /* TxRqstC */
    const uint32_t  TxRqstC_1 :  1;  /* TxRqstC */
    const uint32_t  TxRqstC_2 :  1;  /* TxRqstC */
    const uint32_t  TxRqstC_3 :  1;  /* TxRqstC */
    const uint32_t  TxRqstD_0 :  1;  /* TxRqstD */
    const uint32_t  TxRqstD_1 :  1;  /* TxRqstD */
    const uint32_t  TxRqstD_2 :  1;  /* TxRqstD */
    const uint32_t  TxRqstD_3 :  1;  /* TxRqstD */
    uint32_t                  : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MOTRX. */
typedef volatile struct ALT_CAN_MSGHAND_MOTRX_s  ALT_CAN_MSGHAND_MOTRX_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MOTRX register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MOTRX_OFST        0x0
/* The address of the ALT_CAN_MSGHAND_MOTRX register. */
#define ALT_CAN_MSGHAND_MOTRX_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MOTRX_OFST))

/*
 * Register : Transmission Request A Register - MOTRA
 * 
 * Transmission request bits for Message Objects 1 to 32.  By reading the TxRqst
 * bits, the CPU can check for which Message Object a Transmission Request is
 * pending. The TxRqst bit of a specific Message Object can be set/reset by the CPU
 * via the IFx Message Interface Registers or set by the Message Handler after
 * reception of a Remote Frame or reset by the Message Handler after a successful
 * transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description
 * :-----|:-------|:------|:------------
 *  [0]  | R      | 0x0   | TxRqst32-1 
 *  [1]  | R      | 0x0   | TxRqst32-1 
 *  [2]  | R      | 0x0   | TxRqst32-1 
 *  [3]  | R      | 0x0   | TxRqst32-1 
 *  [4]  | R      | 0x0   | TxRqst32-1 
 *  [5]  | R      | 0x0   | TxRqst32-1 
 *  [6]  | R      | 0x0   | TxRqst32-1 
 *  [7]  | R      | 0x0   | TxRqst32-1 
 *  [8]  | R      | 0x0   | TxRqst32-1 
 *  [9]  | R      | 0x0   | TxRqst32-1 
 *  [10] | R      | 0x0   | TxRqst32-1 
 *  [11] | R      | 0x0   | TxRqst32-1 
 *  [12] | R      | 0x0   | TxRqst32-1 
 *  [13] | R      | 0x0   | TxRqst32-1 
 *  [14] | R      | 0x0   | TxRqst32-1 
 *  [15] | R      | 0x0   | TxRqst32-1 
 *  [16] | R      | 0x0   | TxRqst32-1 
 *  [17] | R      | 0x0   | TxRqst32-1 
 *  [18] | R      | 0x0   | TxRqst32-1 
 *  [19] | R      | 0x0   | TxRqst32-1 
 *  [20] | R      | 0x0   | TxRqst32-1 
 *  [21] | R      | 0x0   | TxRqst32-1 
 *  [22] | R      | 0x0   | TxRqst32-1 
 *  [23] | R      | 0x0   | TxRqst32-1 
 *  [24] | R      | 0x0   | TxRqst32-1 
 *  [25] | R      | 0x0   | TxRqst32-1 
 *  [26] | R      | 0x0   | TxRqst32-1 
 *  [27] | R      | 0x0   | TxRqst32-1 
 *  [28] | R      | 0x0   | TxRqst32-1 
 *  [29] | R      | 0x0   | TxRqst32-1 
 *  [30] | R      | 0x0   | TxRqst32-1 
 *  [31] | R      | 0x0   | TxRqst32-1 
 * 
 */
/*
 * Field : TxRqst32-1 - TxRqst_0
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_0_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_0_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_0
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_0
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : TxRqst32-1 - TxRqst_1
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_1_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_1_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_1
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_1
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : TxRqst32-1 - TxRqst_2
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_2_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_2_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_2
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_2
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : TxRqst32-1 - TxRqst_3
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_3_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_3_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_3
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_3
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : TxRqst32-1 - TxRqst_4
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_4_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_4_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_4
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_4
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_4 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : TxRqst32-1 - TxRqst_5
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_5_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_5_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_5
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_5
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_5 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : TxRqst32-1 - TxRqst_6
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_6_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_6_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_6
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_6
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_6 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : TxRqst32-1 - TxRqst_7
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_7_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_7_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_7
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_7
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_7 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : TxRqst32-1 - TxRqst_8
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_8_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_8_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_8
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_8
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_8 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : TxRqst32-1 - TxRqst_9
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_9_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_9_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_9
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_9
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_9 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : TxRqst32-1 - TxRqst_10
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_10_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_10_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_10
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_10
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_10 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : TxRqst32-1 - TxRqst_11
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_11_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_11_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_11
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_11
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_11 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : TxRqst32-1 - TxRqst_12
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_12_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_12_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_12
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_12
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_12 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : TxRqst32-1 - TxRqst_13
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_13_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_13_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_13
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_13
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_13 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : TxRqst32-1 - TxRqst_14
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_14_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_14_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_14
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_14
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_14 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : TxRqst32-1 - TxRqst_15
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_15_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_15_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_15
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_15
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_15 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : TxRqst32-1 - TxRqst_16
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_16_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_16_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_16
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_16
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_16 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : TxRqst32-1 - TxRqst_17
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_17_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_17_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_17
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_17
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_17 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : TxRqst32-1 - TxRqst_18
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_18_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_18_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_18
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_18
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_18 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : TxRqst32-1 - TxRqst_19
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_19_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_19_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_19
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_19
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_19 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : TxRqst32-1 - TxRqst_20
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_20_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_20_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_20
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_20
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_20 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : TxRqst32-1 - TxRqst_21
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_21_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_21_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_21
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_21
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_21 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : TxRqst32-1 - TxRqst_22
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_22_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_22_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_22
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_22
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_22 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : TxRqst32-1 - TxRqst_23
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_23_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_23_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_23
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_23
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_23 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : TxRqst32-1 - TxRqst_24
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_24_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_24_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_24
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_24
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_24 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : TxRqst32-1 - TxRqst_25
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_25_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_25_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_25
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_25
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_25 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : TxRqst32-1 - TxRqst_26
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_26_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_26_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_26
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_26
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_26 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : TxRqst32-1 - TxRqst_27
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_27_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_27_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_27
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_27
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_27 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : TxRqst32-1 - TxRqst_28
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_28_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_28_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_28
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_28
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_28 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : TxRqst32-1 - TxRqst_29
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_29_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_29_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_29
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_29
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_29 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : TxRqst32-1 - TxRqst_30
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_30_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_30_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_30
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_30
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_30 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : TxRqst32-1 - TxRqst_31
 * 
 * Transmission request bits for Message Objects 1 to 32. Array index i corresponds
 * to Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_31_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRA_TXRQST_31_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_31
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRA_TXRQST_31
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRA_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MOTRA_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRA_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRA_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRA_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRA_TXRQST_31 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MOTRA_TXRQST_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRA_TXRQST_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MOTRA.
 */
struct ALT_CAN_MSGHAND_MOTRA_s
{
    const uint32_t  TxRqst_0  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_1  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_2  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_3  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_4  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_5  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_6  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_7  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_8  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_9  :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_10 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_11 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_12 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_13 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_14 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_15 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_16 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_17 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_18 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_19 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_20 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_21 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_22 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_23 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_24 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_25 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_26 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_27 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_28 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_29 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_30 :  1;  /* TxRqst32-1 */
    const uint32_t  TxRqst_31 :  1;  /* TxRqst32-1 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MOTRA. */
typedef volatile struct ALT_CAN_MSGHAND_MOTRA_s  ALT_CAN_MSGHAND_MOTRA_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MOTRA register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MOTRA_OFST        0x4
/* The address of the ALT_CAN_MSGHAND_MOTRA register. */
#define ALT_CAN_MSGHAND_MOTRA_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MOTRA_OFST))

/*
 * Register : Transmission Request B Register - MOTRB
 * 
 * Transmission request bits for Message Objects 33 to 64.  By reading the TxRqst
 * bits, the CPU can check for which Message Object a Transmission Request is
 * pending. The TxRqst bit of a specific Message Object can be set/reset by the CPU
 * via the IFx Message Interface Registers or set by the Message Handler after
 * reception of a Remote Frame or reset by the Message Handler after a successful
 * transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description
 * :-----|:-------|:------|:------------
 *  [0]  | R      | 0x0   | TxRqst64-33
 *  [1]  | R      | 0x0   | TxRqst64-33
 *  [2]  | R      | 0x0   | TxRqst64-33
 *  [3]  | R      | 0x0   | TxRqst64-33
 *  [4]  | R      | 0x0   | TxRqst64-33
 *  [5]  | R      | 0x0   | TxRqst64-33
 *  [6]  | R      | 0x0   | TxRqst64-33
 *  [7]  | R      | 0x0   | TxRqst64-33
 *  [8]  | R      | 0x0   | TxRqst64-33
 *  [9]  | R      | 0x0   | TxRqst64-33
 *  [10] | R      | 0x0   | TxRqst64-33
 *  [11] | R      | 0x0   | TxRqst64-33
 *  [12] | R      | 0x0   | TxRqst64-33
 *  [13] | R      | 0x0   | TxRqst64-33
 *  [14] | R      | 0x0   | TxRqst64-33
 *  [15] | R      | 0x0   | TxRqst64-33
 *  [16] | R      | 0x0   | TxRqst64-33
 *  [17] | R      | 0x0   | TxRqst64-33
 *  [18] | R      | 0x0   | TxRqst64-33
 *  [19] | R      | 0x0   | TxRqst64-33
 *  [20] | R      | 0x0   | TxRqst64-33
 *  [21] | R      | 0x0   | TxRqst64-33
 *  [22] | R      | 0x0   | TxRqst64-33
 *  [23] | R      | 0x0   | TxRqst64-33
 *  [24] | R      | 0x0   | TxRqst64-33
 *  [25] | R      | 0x0   | TxRqst64-33
 *  [26] | R      | 0x0   | TxRqst64-33
 *  [27] | R      | 0x0   | TxRqst64-33
 *  [28] | R      | 0x0   | TxRqst64-33
 *  [29] | R      | 0x0   | TxRqst64-33
 *  [30] | R      | 0x0   | TxRqst64-33
 *  [31] | R      | 0x0   | TxRqst64-33
 * 
 */
/*
 * Field : TxRqst64-33 - TxRqst_0
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_0_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_0_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_0
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_0
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : TxRqst64-33 - TxRqst_1
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_1_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_1_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_1
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_1
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : TxRqst64-33 - TxRqst_2
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_2_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_2_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_2
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_2
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : TxRqst64-33 - TxRqst_3
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_3_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_3_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_3
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_3
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : TxRqst64-33 - TxRqst_4
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_4_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_4_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_4
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_4
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_4 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : TxRqst64-33 - TxRqst_5
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_5_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_5_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_5
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_5
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_5 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : TxRqst64-33 - TxRqst_6
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_6_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_6_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_6
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_6
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_6 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : TxRqst64-33 - TxRqst_7
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_7_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_7_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_7
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_7
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_7 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : TxRqst64-33 - TxRqst_8
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_8_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_8_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_8
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_8
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_8 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : TxRqst64-33 - TxRqst_9
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_9_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_9_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_9
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_9
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_9 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : TxRqst64-33 - TxRqst_10
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_10_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_10_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_10
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_10
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_10 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : TxRqst64-33 - TxRqst_11
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_11_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_11_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_11
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_11
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_11 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : TxRqst64-33 - TxRqst_12
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_12_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_12_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_12
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_12
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_12 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : TxRqst64-33 - TxRqst_13
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_13_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_13_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_13
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_13
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_13 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : TxRqst64-33 - TxRqst_14
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_14_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_14_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_14
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_14
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_14 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : TxRqst64-33 - TxRqst_15
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_15_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_15_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_15
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_15
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_15 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : TxRqst64-33 - TxRqst_16
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_16_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_16_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_16
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_16
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_16 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : TxRqst64-33 - TxRqst_17
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_17_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_17_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_17
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_17
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_17 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : TxRqst64-33 - TxRqst_18
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_18_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_18_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_18
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_18
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_18 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : TxRqst64-33 - TxRqst_19
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_19_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_19_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_19
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_19
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_19 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : TxRqst64-33 - TxRqst_20
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_20_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_20_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_20
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_20
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_20 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : TxRqst64-33 - TxRqst_21
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_21_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_21_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_21
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_21
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_21 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : TxRqst64-33 - TxRqst_22
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_22_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_22_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_22
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_22
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_22 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : TxRqst64-33 - TxRqst_23
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_23_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_23_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_23
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_23
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_23 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : TxRqst64-33 - TxRqst_24
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_24_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_24_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_24
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_24
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_24 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : TxRqst64-33 - TxRqst_25
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_25_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_25_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_25
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_25
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_25 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : TxRqst64-33 - TxRqst_26
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_26_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_26_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_26
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_26
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_26 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : TxRqst64-33 - TxRqst_27
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_27_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_27_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_27
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_27
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_27 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : TxRqst64-33 - TxRqst_28
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_28_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_28_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_28
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_28
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_28 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : TxRqst64-33 - TxRqst_29
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_29_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_29_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_29
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_29
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_29 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : TxRqst64-33 - TxRqst_30
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_30_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_30_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_30
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_30
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_30 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : TxRqst64-33 - TxRqst_31
 * 
 * Transmission request bits for Message Objects 33 to 64. Array index i
 * corresponds to Message Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_31_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRB_TXRQST_31_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_31
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRB_TXRQST_31
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRB_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MOTRB_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRB_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRB_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRB_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRB_TXRQST_31 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MOTRB_TXRQST_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRB_TXRQST_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MOTRB.
 */
struct ALT_CAN_MSGHAND_MOTRB_s
{
    const uint32_t  TxRqst_0  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_1  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_2  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_3  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_4  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_5  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_6  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_7  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_8  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_9  :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_10 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_11 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_12 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_13 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_14 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_15 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_16 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_17 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_18 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_19 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_20 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_21 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_22 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_23 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_24 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_25 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_26 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_27 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_28 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_29 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_30 :  1;  /* TxRqst64-33 */
    const uint32_t  TxRqst_31 :  1;  /* TxRqst64-33 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MOTRB. */
typedef volatile struct ALT_CAN_MSGHAND_MOTRB_s  ALT_CAN_MSGHAND_MOTRB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MOTRB register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MOTRB_OFST        0x8
/* The address of the ALT_CAN_MSGHAND_MOTRB register. */
#define ALT_CAN_MSGHAND_MOTRB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MOTRB_OFST))

/*
 * Register : Transmission Request C Register - MOTRC
 * 
 * Transmission request bits for Message Objects 65 to 96.  By reading the TxRqst
 * bits, the CPU can check for which Message Object a Transmission Request is
 * pending. The TxRqst bit of a specific Message Object can be set/reset by the CPU
 * via the IFx Message Interface Registers or set by the Message Handler after
 * reception of a Remote Frame or reset by the Message Handler after a successful
 * transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description
 * :-----|:-------|:------|:------------
 *  [0]  | R      | 0x0   | TxRqst96-65
 *  [1]  | R      | 0x0   | TxRqst96-65
 *  [2]  | R      | 0x0   | TxRqst96-65
 *  [3]  | R      | 0x0   | TxRqst96-65
 *  [4]  | R      | 0x0   | TxRqst96-65
 *  [5]  | R      | 0x0   | TxRqst96-65
 *  [6]  | R      | 0x0   | TxRqst96-65
 *  [7]  | R      | 0x0   | TxRqst96-65
 *  [8]  | R      | 0x0   | TxRqst96-65
 *  [9]  | R      | 0x0   | TxRqst96-65
 *  [10] | R      | 0x0   | TxRqst96-65
 *  [11] | R      | 0x0   | TxRqst96-65
 *  [12] | R      | 0x0   | TxRqst96-65
 *  [13] | R      | 0x0   | TxRqst96-65
 *  [14] | R      | 0x0   | TxRqst96-65
 *  [15] | R      | 0x0   | TxRqst96-65
 *  [16] | R      | 0x0   | TxRqst96-65
 *  [17] | R      | 0x0   | TxRqst96-65
 *  [18] | R      | 0x0   | TxRqst96-65
 *  [19] | R      | 0x0   | TxRqst96-65
 *  [20] | R      | 0x0   | TxRqst96-65
 *  [21] | R      | 0x0   | TxRqst96-65
 *  [22] | R      | 0x0   | TxRqst96-65
 *  [23] | R      | 0x0   | TxRqst96-65
 *  [24] | R      | 0x0   | TxRqst96-65
 *  [25] | R      | 0x0   | TxRqst96-65
 *  [26] | R      | 0x0   | TxRqst96-65
 *  [27] | R      | 0x0   | TxRqst96-65
 *  [28] | R      | 0x0   | TxRqst96-65
 *  [29] | R      | 0x0   | TxRqst96-65
 *  [30] | R      | 0x0   | TxRqst96-65
 *  [31] | R      | 0x0   | TxRqst96-65
 * 
 */
/*
 * Field : TxRqst96-65 - TxRqst_0
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_0_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_0_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_0
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_0
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : TxRqst96-65 - TxRqst_1
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_1_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_1_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_1
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_1
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : TxRqst96-65 - TxRqst_2
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_2_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_2_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_2
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_2
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : TxRqst96-65 - TxRqst_3
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_3_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_3_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_3
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_3
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : TxRqst96-65 - TxRqst_4
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_4_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_4_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_4
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_4
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_4 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : TxRqst96-65 - TxRqst_5
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_5_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_5_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_5
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_5
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_5 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : TxRqst96-65 - TxRqst_6
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_6_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_6_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_6
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_6
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_6 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : TxRqst96-65 - TxRqst_7
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_7_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_7_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_7
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_7
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_7 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : TxRqst96-65 - TxRqst_8
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_8_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_8_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_8
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_8
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_8 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : TxRqst96-65 - TxRqst_9
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_9_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_9_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_9
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_9
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_9 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : TxRqst96-65 - TxRqst_10
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_10_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_10_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_10
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_10
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_10 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : TxRqst96-65 - TxRqst_11
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_11_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_11_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_11
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_11
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_11 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : TxRqst96-65 - TxRqst_12
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_12_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_12_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_12
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_12
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_12 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : TxRqst96-65 - TxRqst_13
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_13_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_13_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_13
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_13
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_13 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : TxRqst96-65 - TxRqst_14
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_14_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_14_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_14
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_14
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_14 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : TxRqst96-65 - TxRqst_15
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_15_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_15_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_15
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_15
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_15 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : TxRqst96-65 - TxRqst_16
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_16_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_16_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_16
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_16
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_16 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : TxRqst96-65 - TxRqst_17
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_17_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_17_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_17
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_17
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_17 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : TxRqst96-65 - TxRqst_18
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_18_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_18_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_18
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_18
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_18 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : TxRqst96-65 - TxRqst_19
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_19_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_19_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_19
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_19
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_19 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : TxRqst96-65 - TxRqst_20
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_20_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_20_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_20
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_20
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_20 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : TxRqst96-65 - TxRqst_21
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_21_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_21_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_21
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_21
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_21 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : TxRqst96-65 - TxRqst_22
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_22_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_22_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_22
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_22
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_22 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : TxRqst96-65 - TxRqst_23
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_23_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_23_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_23
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_23
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_23 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : TxRqst96-65 - TxRqst_24
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_24_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_24_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_24
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_24
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_24 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : TxRqst96-65 - TxRqst_25
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_25_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_25_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_25
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_25
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_25 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : TxRqst96-65 - TxRqst_26
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_26_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_26_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_26
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_26
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_26 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : TxRqst96-65 - TxRqst_27
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_27_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_27_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_27
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_27
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_27 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : TxRqst96-65 - TxRqst_28
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_28_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_28_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_28
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_28
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_28 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : TxRqst96-65 - TxRqst_29
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_29_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_29_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_29
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_29
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_29 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : TxRqst96-65 - TxRqst_30
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_30_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_30_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_30
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_30
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_30 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : TxRqst96-65 - TxRqst_31
 * 
 * Transmission request bits for Message Objects 65 to 96. Array index i
 * corresponds to Message Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_31_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRC_TXRQST_31_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_31
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRC_TXRQST_31
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRC_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MOTRC_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRC_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRC_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRC_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRC_TXRQST_31 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MOTRC_TXRQST_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRC_TXRQST_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MOTRC.
 */
struct ALT_CAN_MSGHAND_MOTRC_s
{
    const uint32_t  TxRqst_0  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_1  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_2  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_3  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_4  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_5  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_6  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_7  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_8  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_9  :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_10 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_11 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_12 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_13 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_14 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_15 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_16 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_17 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_18 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_19 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_20 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_21 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_22 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_23 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_24 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_25 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_26 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_27 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_28 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_29 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_30 :  1;  /* TxRqst96-65 */
    const uint32_t  TxRqst_31 :  1;  /* TxRqst96-65 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MOTRC. */
typedef volatile struct ALT_CAN_MSGHAND_MOTRC_s  ALT_CAN_MSGHAND_MOTRC_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MOTRC register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MOTRC_OFST        0xc
/* The address of the ALT_CAN_MSGHAND_MOTRC register. */
#define ALT_CAN_MSGHAND_MOTRC_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MOTRC_OFST))

/*
 * Register : Transmission Request D Register - MOTRD
 * 
 * Transmission request bits for Message Objects 97 to 128.  By reading the TxRqst
 * bits, the CPU can check for which Message Object a Transmission Request is
 * pending. The TxRqst bit of a specific Message Object can be set/reset by the CPU
 * via the IFx Message Interface Registers or set by the Message Handler after
 * reception of a Remote Frame or reset by the Message Handler after a successful
 * transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description 
 * :-----|:-------|:------|:-------------
 *  [0]  | R      | 0x0   | TxRqst128-97
 *  [1]  | R      | 0x0   | TxRqst128-97
 *  [2]  | R      | 0x0   | TxRqst128-97
 *  [3]  | R      | 0x0   | TxRqst128-97
 *  [4]  | R      | 0x0   | TxRqst128-97
 *  [5]  | R      | 0x0   | TxRqst128-97
 *  [6]  | R      | 0x0   | TxRqst128-97
 *  [7]  | R      | 0x0   | TxRqst128-97
 *  [8]  | R      | 0x0   | TxRqst128-97
 *  [9]  | R      | 0x0   | TxRqst128-97
 *  [10] | R      | 0x0   | TxRqst128-97
 *  [11] | R      | 0x0   | TxRqst128-97
 *  [12] | R      | 0x0   | TxRqst128-97
 *  [13] | R      | 0x0   | TxRqst128-97
 *  [14] | R      | 0x0   | TxRqst128-97
 *  [15] | R      | 0x0   | TxRqst128-97
 *  [16] | R      | 0x0   | TxRqst128-97
 *  [17] | R      | 0x0   | TxRqst128-97
 *  [18] | R      | 0x0   | TxRqst128-97
 *  [19] | R      | 0x0   | TxRqst128-97
 *  [20] | R      | 0x0   | TxRqst128-97
 *  [21] | R      | 0x0   | TxRqst128-97
 *  [22] | R      | 0x0   | TxRqst128-97
 *  [23] | R      | 0x0   | TxRqst128-97
 *  [24] | R      | 0x0   | TxRqst128-97
 *  [25] | R      | 0x0   | TxRqst128-97
 *  [26] | R      | 0x0   | TxRqst128-97
 *  [27] | R      | 0x0   | TxRqst128-97
 *  [28] | R      | 0x0   | TxRqst128-97
 *  [29] | R      | 0x0   | TxRqst128-97
 *  [30] | R      | 0x0   | TxRqst128-97
 *  [31] | R      | 0x0   | TxRqst128-97
 * 
 */
/*
 * Field : TxRqst128-97 - TxRqst_0
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_0_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_0_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_0
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_0
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_0 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_0 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : TxRqst128-97 - TxRqst_1
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_1_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_1_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_1
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_1
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_1 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_1 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : TxRqst128-97 - TxRqst_2
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_2_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_2_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_2
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_2
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_2 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_2 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : TxRqst128-97 - TxRqst_3
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_3_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_3_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_3
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_3
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_3 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_3 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : TxRqst128-97 - TxRqst_4
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_4_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_4_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_4
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_4
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_4 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_4 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_4 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : TxRqst128-97 - TxRqst_5
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_5_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_5_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_5
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_5
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_5 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_5 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_5 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : TxRqst128-97 - TxRqst_6
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_6_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_6_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_6
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_6
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_6 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_6 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_6 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : TxRqst128-97 - TxRqst_7
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_7_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_7_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_7
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_7
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_7 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_7 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_7 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : TxRqst128-97 - TxRqst_8
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_8_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_8_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_8
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_8
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_8 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_8 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_8 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : TxRqst128-97 - TxRqst_9
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_9_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                            |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_9_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                            |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_9
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_E_NOTWAITING 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_9
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_E_PENDING    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_9 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_9 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_9 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : TxRqst128-97 - TxRqst_10
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_10_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_10_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_10
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_10
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_10 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_10 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_10 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : TxRqst128-97 - TxRqst_11
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_11_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_11_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_11
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_11
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_11 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_11 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_11 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : TxRqst128-97 - TxRqst_12
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_12_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_12_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_12
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_12
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_12 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_12 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_12 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : TxRqst128-97 - TxRqst_13
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_13_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_13_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_13
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_13
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_13 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_13 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_13 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : TxRqst128-97 - TxRqst_14
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_14_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_14_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_14
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_14
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_14 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_14 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_14 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : TxRqst128-97 - TxRqst_15
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_15_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_15_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_15
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_15
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_15 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_15 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_15 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : TxRqst128-97 - TxRqst_16
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_16_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_16_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_16
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_16
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_16 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_16 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_16 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : TxRqst128-97 - TxRqst_17
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_17_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_17_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_17
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_17
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_17 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_17 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_17 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : TxRqst128-97 - TxRqst_18
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_18_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_18_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_18
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_18
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_18 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_18 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_18 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : TxRqst128-97 - TxRqst_19
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_19_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_19_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_19
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_19
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_19 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_19 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_19 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : TxRqst128-97 - TxRqst_20
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_20_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_20_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_20
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_20
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_20 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_20 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_20 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : TxRqst128-97 - TxRqst_21
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_21_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_21_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_21
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_21
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_21 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_21 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_21 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : TxRqst128-97 - TxRqst_22
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_22_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_22_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_22
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_22
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_22 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_22 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_22 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : TxRqst128-97 - TxRqst_23
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_23_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_23_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_23
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_23
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_23 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_23 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_23 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : TxRqst128-97 - TxRqst_24
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_24_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_24_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_24
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_24
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_24 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_24 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_24 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : TxRqst128-97 - TxRqst_25
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_25_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_25_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_25
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_25
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_25 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_25 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_25 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : TxRqst128-97 - TxRqst_26
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_26_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_26_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_26
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_26
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_26 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_26 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_26 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : TxRqst128-97 - TxRqst_27
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_27_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_27_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_27
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_27
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_27 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_27 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_27 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : TxRqst128-97 - TxRqst_28
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_28_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_28_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_28
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_28
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_28 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_28 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_28 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : TxRqst128-97 - TxRqst_29
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_29_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_29_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_29
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_29
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_29 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_29 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_29 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : TxRqst128-97 - TxRqst_30
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_30_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_30_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_30
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_30
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_30 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_30 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_30 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : TxRqst128-97 - TxRqst_31
 * 
 * Transmission request bits for Message Objects 97 to 128. Array index i
 * corresponds to Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_31_E_NOTWAITING | 0x0   | This Message Object is not waiting for    
 * :                                             |       | transmission.                             
 *  ALT_CAN_MSGHAND_MOTRD_TXRQST_31_E_PENDING    | 0x1   | The transmission of this Message Object is
 * :                                             |       | requested and is not yet done.            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_31
 * 
 * This Message Object is not waiting for transmission.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_E_NOTWAITING    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOTRD_TXRQST_31
 * 
 * The transmission of this Message Object is requested and is not yet done.
 */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_E_PENDING       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOTRD_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MOTRD_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOTRD_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MOTRD_TXRQST_31 register field value. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MOTRD_TXRQST_31 register field. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOTRD_TXRQST_31 field value from a register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MOTRD_TXRQST_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOTRD_TXRQST_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MOTRD.
 */
struct ALT_CAN_MSGHAND_MOTRD_s
{
    const uint32_t  TxRqst_0  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_1  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_2  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_3  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_4  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_5  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_6  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_7  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_8  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_9  :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_10 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_11 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_12 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_13 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_14 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_15 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_16 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_17 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_18 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_19 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_20 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_21 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_22 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_23 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_24 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_25 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_26 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_27 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_28 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_29 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_30 :  1;  /* TxRqst128-97 */
    const uint32_t  TxRqst_31 :  1;  /* TxRqst128-97 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MOTRD. */
typedef volatile struct ALT_CAN_MSGHAND_MOTRD_s  ALT_CAN_MSGHAND_MOTRD_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MOTRD register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MOTRD_OFST        0x10
/* The address of the ALT_CAN_MSGHAND_MOTRD register. */
#define ALT_CAN_MSGHAND_MOTRD_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MOTRD_OFST))

/*
 * Register : New Data X Register - MONDX
 * 
 * Reading this register allows the CPU to quickly detect if any of the new data
 * bits in each of the MONDA, MONDB, MONDC, and MONDD New Data Registers are set.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description
 * :--------|:-------|:------|:------------
 *  [0]     | R      | 0x0   | NewDatA    
 *  [1]     | R      | 0x0   | NewDatA    
 *  [2]     | R      | 0x0   | NewDatA    
 *  [3]     | R      | 0x0   | NewDatA    
 *  [4]     | R      | 0x0   | NewDatB    
 *  [5]     | R      | 0x0   | NewDatB    
 *  [6]     | R      | 0x0   | NewDatB    
 *  [7]     | R      | 0x0   | NewDatB    
 *  [8]     | R      | 0x0   | NewDatC    
 *  [9]     | R      | 0x0   | NewDatC    
 *  [10]    | R      | 0x0   | NewDatC    
 *  [11]    | R      | 0x0   | NewDatC    
 *  [12]    | R      | 0x0   | NewDatD    
 *  [13]    | R      | 0x0   | NewDatD    
 *  [14]    | R      | 0x0   | NewDatD    
 *  [15]    | R      | 0x0   | NewDatD    
 *  [31:16] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : NewDatA - NewDatA_0
 * 
 * Each bit in this field is a logical OR of a byte of the MONDA register. Array
 * index i corresponds to byte i of the MONDA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_0_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDA don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_0_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDA have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_0
 * 
 * The Message Objects in the corresponding byte of MONDA don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_0
 * 
 * One or more of the Message Objects in the corresponding byte of MONDA have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATA_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATA_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATA_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATA_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATA_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATA_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : NewDatA - NewDatA_1
 * 
 * Each bit in this field is a logical OR of a byte of the MONDA register. Array
 * index i corresponds to byte i of the MONDA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_1_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDA don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_1_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDA have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_1
 * 
 * The Message Objects in the corresponding byte of MONDA don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_1
 * 
 * One or more of the Message Objects in the corresponding byte of MONDA have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATA_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATA_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATA_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATA_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATA_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATA_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : NewDatA - NewDatA_2
 * 
 * Each bit in this field is a logical OR of a byte of the MONDA register. Array
 * index i corresponds to byte i of the MONDA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_2_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDA don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_2_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDA have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_2
 * 
 * The Message Objects in the corresponding byte of MONDA don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_2
 * 
 * One or more of the Message Objects in the corresponding byte of MONDA have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATA_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATA_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATA_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATA_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATA_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATA_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : NewDatA - NewDatA_3
 * 
 * Each bit in this field is a logical OR of a byte of the MONDA register. Array
 * index i corresponds to byte i of the MONDA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_3_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDA don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATA_3_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDA have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_3
 * 
 * The Message Objects in the corresponding byte of MONDA don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATA_3
 * 
 * One or more of the Message Objects in the corresponding byte of MONDA have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATA_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATA_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATA_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATA_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATA_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATA_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATA_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATA_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NewDatB - NewDatB_0
 * 
 * Each bit in this field is a logical OR of a byte of the MONDB register. Array
 * index i corresponds to byte i of the MONDB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_0_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDB don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_0_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDB have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_0
 * 
 * The Message Objects in the corresponding byte of MONDB don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_0
 * 
 * One or more of the Message Objects in the corresponding byte of MONDB have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATB_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATB_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATB_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATB_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATB_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATB_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_0_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : NewDatB - NewDatB_1
 * 
 * Each bit in this field is a logical OR of a byte of the MONDB register. Array
 * index i corresponds to byte i of the MONDB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_1_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDB don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_1_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDB have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_1
 * 
 * The Message Objects in the corresponding byte of MONDB don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_1
 * 
 * One or more of the Message Objects in the corresponding byte of MONDB have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATB_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATB_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATB_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATB_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATB_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATB_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_1_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NewDatB - NewDatB_2
 * 
 * Each bit in this field is a logical OR of a byte of the MONDB register. Array
 * index i corresponds to byte i of the MONDB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_2_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDB don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_2_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDB have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_2
 * 
 * The Message Objects in the corresponding byte of MONDB don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_2
 * 
 * One or more of the Message Objects in the corresponding byte of MONDB have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATB_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATB_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATB_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATB_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATB_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATB_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_2_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : NewDatB - NewDatB_3
 * 
 * Each bit in this field is a logical OR of a byte of the MONDB register. Array
 * index i corresponds to byte i of the MONDB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_3_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDB don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATB_3_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDB have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_3
 * 
 * The Message Objects in the corresponding byte of MONDB don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATB_3
 * 
 * One or more of the Message Objects in the corresponding byte of MONDB have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATB_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATB_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATB_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATB_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATB_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATB_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATB_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATB_3_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : NewDatC - NewDatC_0
 * 
 * Each bit in this field is a logical OR of a byte of the MONDC register. Array
 * index i corresponds to byte i of the MONDC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_0_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDC don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_0_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDC have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_0
 * 
 * The Message Objects in the corresponding byte of MONDC don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_0
 * 
 * One or more of the Message Objects in the corresponding byte of MONDC have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATC_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATC_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATC_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATC_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATC_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATC_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_0_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : NewDatC - NewDatC_1
 * 
 * Each bit in this field is a logical OR of a byte of the MONDC register. Array
 * index i corresponds to byte i of the MONDC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_1_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDC don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_1_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDC have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_1
 * 
 * The Message Objects in the corresponding byte of MONDC don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_1
 * 
 * One or more of the Message Objects in the corresponding byte of MONDC have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATC_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATC_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATC_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATC_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATC_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATC_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_1_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : NewDatC - NewDatC_2
 * 
 * Each bit in this field is a logical OR of a byte of the MONDC register. Array
 * index i corresponds to byte i of the MONDC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_2_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDC don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_2_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDC have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_2
 * 
 * The Message Objects in the corresponding byte of MONDC don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_2
 * 
 * One or more of the Message Objects in the corresponding byte of MONDC have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATC_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATC_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATC_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATC_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATC_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATC_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_2_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : NewDatC - NewDatC_3
 * 
 * Each bit in this field is a logical OR of a byte of the MONDC register. Array
 * index i corresponds to byte i of the MONDC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_3_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDC don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATC_3_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDC have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_3
 * 
 * The Message Objects in the corresponding byte of MONDC don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATC_3
 * 
 * One or more of the Message Objects in the corresponding byte of MONDC have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATC_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATC_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATC_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATC_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATC_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATC_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATC_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATC_3_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : NewDatD - NewDatD_0
 * 
 * Each bit in this field is a logical OR of a byte of the MONDD register. Array
 * index i corresponds to byte i of the MONDD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_0_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDD don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_0_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDD have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_0
 * 
 * The Message Objects in the corresponding byte of MONDD don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_0
 * 
 * One or more of the Message Objects in the corresponding byte of MONDD have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATD_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATD_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATD_0 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATD_0 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATD_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATD_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_0_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : NewDatD - NewDatD_1
 * 
 * Each bit in this field is a logical OR of a byte of the MONDD register. Array
 * index i corresponds to byte i of the MONDD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_1_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDD don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_1_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDD have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_1
 * 
 * The Message Objects in the corresponding byte of MONDD don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_1
 * 
 * One or more of the Message Objects in the corresponding byte of MONDD have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATD_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATD_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATD_1 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATD_1 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATD_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATD_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_1_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : NewDatD - NewDatD_2
 * 
 * Each bit in this field is a logical OR of a byte of the MONDD register. Array
 * index i corresponds to byte i of the MONDD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_2_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDD don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_2_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDD have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_2
 * 
 * The Message Objects in the corresponding byte of MONDD don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_2
 * 
 * One or more of the Message Objects in the corresponding byte of MONDD have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATD_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATD_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATD_2 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATD_2 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATD_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATD_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_2_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : NewDatD - NewDatD_3
 * 
 * Each bit in this field is a logical OR of a byte of the MONDD register. Array
 * index i corresponds to byte i of the MONDD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_3_E_NOTWRITTEN | 0x0   | The Message Objects in the corresponding byte of
 * :                                             |       | MONDD don't have new data.                      
 *  ALT_CAN_MSGHAND_MONDX_NEWDATD_3_E_WRITTEN    | 0x1   | One or more of the Message Objects in the       
 * :                                             |       | corresponding byte of MONDD have new data       
 * :                                             |       | available.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_3
 * 
 * The Message Objects in the corresponding byte of MONDD don't have new data.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDX_NEWDATD_3
 * 
 * One or more of the Message Objects in the corresponding byte of MONDD have new
 * data available.
 */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDX_NEWDATD_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MONDX_NEWDATD_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDX_NEWDATD_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDX_NEWDATD_3 register field value. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MONDX_NEWDATD_3 register field. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDX_NEWDATD_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MONDX_NEWDATD_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDX_NEWDATD_3_SET(value) (((value) << 15) & 0x00008000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MONDX.
 */
struct ALT_CAN_MSGHAND_MONDX_s
{
    const uint32_t  NewDatA_0 :  1;  /* NewDatA */
    const uint32_t  NewDatA_1 :  1;  /* NewDatA */
    const uint32_t  NewDatA_2 :  1;  /* NewDatA */
    const uint32_t  NewDatA_3 :  1;  /* NewDatA */
    const uint32_t  NewDatB_0 :  1;  /* NewDatB */
    const uint32_t  NewDatB_1 :  1;  /* NewDatB */
    const uint32_t  NewDatB_2 :  1;  /* NewDatB */
    const uint32_t  NewDatB_3 :  1;  /* NewDatB */
    const uint32_t  NewDatC_0 :  1;  /* NewDatC */
    const uint32_t  NewDatC_1 :  1;  /* NewDatC */
    const uint32_t  NewDatC_2 :  1;  /* NewDatC */
    const uint32_t  NewDatC_3 :  1;  /* NewDatC */
    const uint32_t  NewDatD_0 :  1;  /* NewDatD */
    const uint32_t  NewDatD_1 :  1;  /* NewDatD */
    const uint32_t  NewDatD_2 :  1;  /* NewDatD */
    const uint32_t  NewDatD_3 :  1;  /* NewDatD */
    uint32_t                  : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MONDX. */
typedef volatile struct ALT_CAN_MSGHAND_MONDX_s  ALT_CAN_MSGHAND_MONDX_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MONDX register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MONDX_OFST        0x14
/* The address of the ALT_CAN_MSGHAND_MONDX register. */
#define ALT_CAN_MSGHAND_MONDX_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MONDX_OFST))

/*
 * Register : New Data A Register - MONDA
 * 
 * New data bits for Message Objects 1 to 32.  By reading the NewDat bits, the CPU
 * can check for which Message Object the data portion was updated. The NewDat bit
 * of a specific Message Object can be set/reset by the CPU via the IFx Message
 * Interface Registers or set by the Message Handler after reception of a Data
 * Frame or reset by the Message Handler at start of a transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description
 * :-----|:-------|:------|:------------
 *  [0]  | R      | 0x0   | NewDat32-1 
 *  [1]  | R      | 0x0   | NewDat32-1 
 *  [2]  | R      | 0x0   | NewDat32-1 
 *  [3]  | R      | 0x0   | NewDat32-1 
 *  [4]  | R      | 0x0   | NewDat32-1 
 *  [5]  | R      | 0x0   | NewDat32-1 
 *  [6]  | R      | 0x0   | NewDat32-1 
 *  [7]  | R      | 0x0   | NewDat32-1 
 *  [8]  | R      | 0x0   | NewDat32-1 
 *  [9]  | R      | 0x0   | NewDat32-1 
 *  [10] | R      | 0x0   | NewDat32-1 
 *  [11] | R      | 0x0   | NewDat32-1 
 *  [12] | R      | 0x0   | NewDat32-1 
 *  [13] | R      | 0x0   | NewDat32-1 
 *  [14] | R      | 0x0   | NewDat32-1 
 *  [15] | R      | 0x0   | NewDat32-1 
 *  [16] | R      | 0x0   | NewDat32-1 
 *  [17] | R      | 0x0   | NewDat32-1 
 *  [18] | R      | 0x0   | NewDat32-1 
 *  [19] | R      | 0x0   | NewDat32-1 
 *  [20] | R      | 0x0   | NewDat32-1 
 *  [21] | R      | 0x0   | NewDat32-1 
 *  [22] | R      | 0x0   | NewDat32-1 
 *  [23] | R      | 0x0   | NewDat32-1 
 *  [24] | R      | 0x0   | NewDat32-1 
 *  [25] | R      | 0x0   | NewDat32-1 
 *  [26] | R      | 0x0   | NewDat32-1 
 *  [27] | R      | 0x0   | NewDat32-1 
 *  [28] | R      | 0x0   | NewDat32-1 
 *  [29] | R      | 0x0   | NewDat32-1 
 *  [30] | R      | 0x0   | NewDat32-1 
 *  [31] | R      | 0x0   | NewDat32-1 
 * 
 */
/*
 * Field : NewDat32-1 - NewDat_0
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_0_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_0_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_0
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_0
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : NewDat32-1 - NewDat_1
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_1_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_1_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_1
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_1
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : NewDat32-1 - NewDat_2
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_2_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_2_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_2
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_2
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : NewDat32-1 - NewDat_3
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_3_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_3_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_3
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_3
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NewDat32-1 - NewDat_4
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_4_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_4_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_4
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_4
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_4 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : NewDat32-1 - NewDat_5
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_5_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_5_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_5
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_5
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_5 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NewDat32-1 - NewDat_6
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_6_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_6_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_6
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_6
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_6 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : NewDat32-1 - NewDat_7
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_7_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_7_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_7
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_7
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_7 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : NewDat32-1 - NewDat_8
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_8_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_8_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_8
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_8
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_8 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : NewDat32-1 - NewDat_9
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_9_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_9_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_9
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_9
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_9 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : NewDat32-1 - NewDat_10
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_10_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_10_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_10
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_10
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_10 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : NewDat32-1 - NewDat_11
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_11_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_11_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_11
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_11
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_11 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : NewDat32-1 - NewDat_12
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_12_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_12_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_12
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_12
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_12 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : NewDat32-1 - NewDat_13
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_13_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_13_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_13
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_13
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_13 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : NewDat32-1 - NewDat_14
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_14_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_14_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_14
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_14
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_14 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : NewDat32-1 - NewDat_15
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_15_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_15_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_15
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_15
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_15 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : NewDat32-1 - NewDat_16
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_16_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_16_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_16
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_16
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_16 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : NewDat32-1 - NewDat_17
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_17_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_17_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_17
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_17
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_17 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : NewDat32-1 - NewDat_18
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_18_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_18_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_18
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_18
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_18 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : NewDat32-1 - NewDat_19
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_19_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_19_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_19
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_19
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_19 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : NewDat32-1 - NewDat_20
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_20_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_20_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_20
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_20
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_20 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : NewDat32-1 - NewDat_21
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_21_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_21_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_21
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_21
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_21 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : NewDat32-1 - NewDat_22
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_22_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_22_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_22
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_22
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_22 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : NewDat32-1 - NewDat_23
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_23_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_23_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_23
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_23
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_23 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : NewDat32-1 - NewDat_24
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_24_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_24_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_24
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_24
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_24 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : NewDat32-1 - NewDat_25
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_25_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_25_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_25
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_25
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_25 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : NewDat32-1 - NewDat_26
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_26_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_26_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_26
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_26
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_26 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : NewDat32-1 - NewDat_27
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_27_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_27_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_27
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_27
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_27 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : NewDat32-1 - NewDat_28
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_28_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_28_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_28
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_28
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_28 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : NewDat32-1 - NewDat_29
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_29_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_29_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_29
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_29
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_29 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : NewDat32-1 - NewDat_30
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_30_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_30_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_30
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_30
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_30 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : NewDat32-1 - NewDat_31
 * 
 * New data bits for Message Objects 1 to 32. Array index i corresponds to Message
 * Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_31_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDA_NEWDAT_31_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_31
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDA_NEWDAT_31
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDA_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MONDA_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDA_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDA_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDA_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDA_NEWDAT_31 field value from a register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MONDA_NEWDAT_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDA_NEWDAT_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MONDA.
 */
struct ALT_CAN_MSGHAND_MONDA_s
{
    const uint32_t  NewDat_0  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_1  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_2  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_3  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_4  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_5  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_6  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_7  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_8  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_9  :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_10 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_11 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_12 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_13 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_14 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_15 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_16 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_17 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_18 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_19 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_20 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_21 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_22 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_23 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_24 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_25 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_26 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_27 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_28 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_29 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_30 :  1;  /* NewDat32-1 */
    const uint32_t  NewDat_31 :  1;  /* NewDat32-1 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MONDA. */
typedef volatile struct ALT_CAN_MSGHAND_MONDA_s  ALT_CAN_MSGHAND_MONDA_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MONDA register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MONDA_OFST        0x18
/* The address of the ALT_CAN_MSGHAND_MONDA register. */
#define ALT_CAN_MSGHAND_MONDA_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MONDA_OFST))

/*
 * Register : New Data B Register - MONDB
 * 
 * New data bits for Message Objects 33 to 64.  By reading the NewDat bits, the CPU
 * can check for which Message Object the data portion was updated. The NewDat bit
 * of a specific Message Object can be set/reset by the CPU via the IFx Message
 * Interface Registers or set by the Message Handler after reception of a Data
 * Frame or reset by the Message Handler at start of a transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description
 * :-----|:-------|:------|:------------
 *  [0]  | R      | 0x0   | NewDat64-33
 *  [1]  | R      | 0x0   | NewDat64-33
 *  [2]  | R      | 0x0   | NewDat64-33
 *  [3]  | R      | 0x0   | NewDat64-33
 *  [4]  | R      | 0x0   | NewDat64-33
 *  [5]  | R      | 0x0   | NewDat64-33
 *  [6]  | R      | 0x0   | NewDat64-33
 *  [7]  | R      | 0x0   | NewDat64-33
 *  [8]  | R      | 0x0   | NewDat64-33
 *  [9]  | R      | 0x0   | NewDat64-33
 *  [10] | R      | 0x0   | NewDat64-33
 *  [11] | R      | 0x0   | NewDat64-33
 *  [12] | R      | 0x0   | NewDat64-33
 *  [13] | R      | 0x0   | NewDat64-33
 *  [14] | R      | 0x0   | NewDat64-33
 *  [15] | R      | 0x0   | NewDat64-33
 *  [16] | R      | 0x0   | NewDat64-33
 *  [17] | R      | 0x0   | NewDat64-33
 *  [18] | R      | 0x0   | NewDat64-33
 *  [19] | R      | 0x0   | NewDat64-33
 *  [20] | R      | 0x0   | NewDat64-33
 *  [21] | R      | 0x0   | NewDat64-33
 *  [22] | R      | 0x0   | NewDat64-33
 *  [23] | R      | 0x0   | NewDat64-33
 *  [24] | R      | 0x0   | NewDat64-33
 *  [25] | R      | 0x0   | NewDat64-33
 *  [26] | R      | 0x0   | NewDat64-33
 *  [27] | R      | 0x0   | NewDat64-33
 *  [28] | R      | 0x0   | NewDat64-33
 *  [29] | R      | 0x0   | NewDat64-33
 *  [30] | R      | 0x0   | NewDat64-33
 *  [31] | R      | 0x0   | NewDat64-33
 * 
 */
/*
 * Field : NewDat64-33 - NewDat_0
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_0_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_0_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_0
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_0
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : NewDat64-33 - NewDat_1
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_1_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_1_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_1
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_1
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : NewDat64-33 - NewDat_2
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_2_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_2_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_2
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_2
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : NewDat64-33 - NewDat_3
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_3_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_3_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_3
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_3
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NewDat64-33 - NewDat_4
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_4_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_4_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_4
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_4
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_4 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : NewDat64-33 - NewDat_5
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_5_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_5_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_5
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_5
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_5 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NewDat64-33 - NewDat_6
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_6_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_6_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_6
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_6
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_6 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : NewDat64-33 - NewDat_7
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_7_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_7_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_7
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_7
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_7 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : NewDat64-33 - NewDat_8
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_8_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_8_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_8
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_8
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_8 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : NewDat64-33 - NewDat_9
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_9_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_9_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_9
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_9
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_9 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : NewDat64-33 - NewDat_10
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_10_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_10_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_10
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_10
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_10 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : NewDat64-33 - NewDat_11
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_11_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_11_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_11
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_11
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_11 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : NewDat64-33 - NewDat_12
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_12_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_12_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_12
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_12
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_12 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : NewDat64-33 - NewDat_13
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_13_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_13_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_13
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_13
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_13 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : NewDat64-33 - NewDat_14
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_14_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_14_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_14
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_14
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_14 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : NewDat64-33 - NewDat_15
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_15_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_15_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_15
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_15
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_15 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : NewDat64-33 - NewDat_16
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_16_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_16_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_16
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_16
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_16 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : NewDat64-33 - NewDat_17
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_17_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_17_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_17
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_17
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_17 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : NewDat64-33 - NewDat_18
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_18_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_18_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_18
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_18
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_18 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : NewDat64-33 - NewDat_19
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_19_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_19_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_19
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_19
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_19 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : NewDat64-33 - NewDat_20
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_20_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_20_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_20
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_20
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_20 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : NewDat64-33 - NewDat_21
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_21_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_21_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_21
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_21
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_21 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : NewDat64-33 - NewDat_22
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_22_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_22_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_22
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_22
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_22 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : NewDat64-33 - NewDat_23
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_23_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_23_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_23
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_23
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_23 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : NewDat64-33 - NewDat_24
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_24_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_24_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_24
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_24
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_24 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : NewDat64-33 - NewDat_25
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_25_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_25_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_25
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_25
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_25 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : NewDat64-33 - NewDat_26
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_26_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_26_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_26
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_26
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_26 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : NewDat64-33 - NewDat_27
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_27_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_27_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_27
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_27
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_27 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : NewDat64-33 - NewDat_28
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_28_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_28_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_28
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_28
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_28 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : NewDat64-33 - NewDat_29
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_29_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_29_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_29
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_29
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_29 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : NewDat64-33 - NewDat_30
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_30_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_30_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_30
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_30
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_30 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : NewDat64-33 - NewDat_31
 * 
 * New data bits for Message Objects 33 to 64. Array index i corresponds to Message
 * Object i+33.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_31_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDB_NEWDAT_31_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_31
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDB_NEWDAT_31
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDB_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MONDB_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDB_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDB_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDB_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDB_NEWDAT_31 field value from a register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MONDB_NEWDAT_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDB_NEWDAT_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MONDB.
 */
struct ALT_CAN_MSGHAND_MONDB_s
{
    const uint32_t  NewDat_0  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_1  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_2  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_3  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_4  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_5  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_6  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_7  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_8  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_9  :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_10 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_11 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_12 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_13 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_14 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_15 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_16 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_17 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_18 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_19 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_20 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_21 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_22 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_23 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_24 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_25 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_26 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_27 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_28 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_29 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_30 :  1;  /* NewDat64-33 */
    const uint32_t  NewDat_31 :  1;  /* NewDat64-33 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MONDB. */
typedef volatile struct ALT_CAN_MSGHAND_MONDB_s  ALT_CAN_MSGHAND_MONDB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MONDB register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MONDB_OFST        0x1c
/* The address of the ALT_CAN_MSGHAND_MONDB register. */
#define ALT_CAN_MSGHAND_MONDB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MONDB_OFST))

/*
 * Register : New Data C Register - MONDC
 * 
 * New data bits for Message Objects 65 to 96.  By reading the NewDat bits, the CPU
 * can check for which Message Object the data portion was updated. The NewDat bit
 * of a specific Message Object can be set/reset by the CPU via the IFx Message
 * Interface Registers or set by the Message Handler after reception of a Data
 * Frame or reset by the Message Handler at start of a transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description
 * :-----|:-------|:------|:------------
 *  [0]  | R      | 0x0   | NewDat96-65
 *  [1]  | R      | 0x0   | NewDat96-65
 *  [2]  | R      | 0x0   | NewDat96-65
 *  [3]  | R      | 0x0   | NewDat96-65
 *  [4]  | R      | 0x0   | NewDat96-65
 *  [5]  | R      | 0x0   | NewDat96-65
 *  [6]  | R      | 0x0   | NewDat96-65
 *  [7]  | R      | 0x0   | NewDat96-65
 *  [8]  | R      | 0x0   | NewDat96-65
 *  [9]  | R      | 0x0   | NewDat96-65
 *  [10] | R      | 0x0   | NewDat96-65
 *  [11] | R      | 0x0   | NewDat96-65
 *  [12] | R      | 0x0   | NewDat96-65
 *  [13] | R      | 0x0   | NewDat96-65
 *  [14] | R      | 0x0   | NewDat96-65
 *  [15] | R      | 0x0   | NewDat96-65
 *  [16] | R      | 0x0   | NewDat96-65
 *  [17] | R      | 0x0   | NewDat96-65
 *  [18] | R      | 0x0   | NewDat96-65
 *  [19] | R      | 0x0   | NewDat96-65
 *  [20] | R      | 0x0   | NewDat96-65
 *  [21] | R      | 0x0   | NewDat96-65
 *  [22] | R      | 0x0   | NewDat96-65
 *  [23] | R      | 0x0   | NewDat96-65
 *  [24] | R      | 0x0   | NewDat96-65
 *  [25] | R      | 0x0   | NewDat96-65
 *  [26] | R      | 0x0   | NewDat96-65
 *  [27] | R      | 0x0   | NewDat96-65
 *  [28] | R      | 0x0   | NewDat96-65
 *  [29] | R      | 0x0   | NewDat96-65
 *  [30] | R      | 0x0   | NewDat96-65
 *  [31] | R      | 0x0   | NewDat96-65
 * 
 */
/*
 * Field : NewDat96-65 - NewDat_0
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_0_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_0_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_0
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_0
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : NewDat96-65 - NewDat_1
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_1_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_1_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_1
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_1
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : NewDat96-65 - NewDat_2
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_2_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_2_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_2
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_2
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : NewDat96-65 - NewDat_3
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_3_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_3_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_3
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_3
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NewDat96-65 - NewDat_4
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_4_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_4_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_4
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_4
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_4 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : NewDat96-65 - NewDat_5
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_5_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_5_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_5
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_5
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_5 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NewDat96-65 - NewDat_6
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_6_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_6_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_6
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_6
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_6 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : NewDat96-65 - NewDat_7
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_7_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_7_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_7
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_7
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_7 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : NewDat96-65 - NewDat_8
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_8_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_8_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_8
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_8
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_8 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : NewDat96-65 - NewDat_9
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_9_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_9_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_9
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_9
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_9 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : NewDat96-65 - NewDat_10
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_10_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_10_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_10
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_10
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_10 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : NewDat96-65 - NewDat_11
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_11_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_11_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_11
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_11
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_11 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : NewDat96-65 - NewDat_12
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_12_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_12_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_12
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_12
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_12 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : NewDat96-65 - NewDat_13
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_13_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_13_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_13
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_13
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_13 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : NewDat96-65 - NewDat_14
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_14_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_14_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_14
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_14
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_14 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : NewDat96-65 - NewDat_15
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_15_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_15_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_15
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_15
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_15 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : NewDat96-65 - NewDat_16
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_16_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_16_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_16
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_16
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_16 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : NewDat96-65 - NewDat_17
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_17_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_17_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_17
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_17
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_17 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : NewDat96-65 - NewDat_18
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_18_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_18_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_18
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_18
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_18 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : NewDat96-65 - NewDat_19
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_19_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_19_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_19
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_19
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_19 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : NewDat96-65 - NewDat_20
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_20_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_20_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_20
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_20
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_20 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : NewDat96-65 - NewDat_21
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_21_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_21_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_21
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_21
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_21 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : NewDat96-65 - NewDat_22
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_22_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_22_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_22
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_22
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_22 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : NewDat96-65 - NewDat_23
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_23_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_23_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_23
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_23
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_23 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : NewDat96-65 - NewDat_24
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_24_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_24_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_24
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_24
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_24 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : NewDat96-65 - NewDat_25
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_25_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_25_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_25
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_25
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_25 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : NewDat96-65 - NewDat_26
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_26_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_26_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_26
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_26
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_26 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : NewDat96-65 - NewDat_27
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_27_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_27_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_27
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_27
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_27 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : NewDat96-65 - NewDat_28
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_28_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_28_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_28
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_28
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_28 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : NewDat96-65 - NewDat_29
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_29_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_29_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_29
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_29
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_29 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : NewDat96-65 - NewDat_30
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_30_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_30_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_30
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_30
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_30 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : NewDat96-65 - NewDat_31
 * 
 * New data bits for Message Objects 65 to 96. Array index i corresponds to Message
 * Object i+65.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_31_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDC_NEWDAT_31_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_31
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDC_NEWDAT_31
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDC_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MONDC_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDC_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDC_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDC_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDC_NEWDAT_31 field value from a register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MONDC_NEWDAT_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDC_NEWDAT_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MONDC.
 */
struct ALT_CAN_MSGHAND_MONDC_s
{
    const uint32_t  NewDat_0  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_1  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_2  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_3  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_4  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_5  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_6  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_7  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_8  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_9  :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_10 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_11 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_12 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_13 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_14 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_15 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_16 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_17 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_18 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_19 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_20 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_21 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_22 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_23 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_24 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_25 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_26 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_27 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_28 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_29 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_30 :  1;  /* NewDat96-65 */
    const uint32_t  NewDat_31 :  1;  /* NewDat96-65 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MONDC. */
typedef volatile struct ALT_CAN_MSGHAND_MONDC_s  ALT_CAN_MSGHAND_MONDC_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MONDC register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MONDC_OFST        0x20
/* The address of the ALT_CAN_MSGHAND_MONDC register. */
#define ALT_CAN_MSGHAND_MONDC_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MONDC_OFST))

/*
 * Register : New Data D Register - MONDD
 * 
 * New data bits for Message Objects 97 to 128.  By reading the NewDat bits, the
 * CPU can check for which Message Object the data portion was updated. The NewDat
 * bit of a specific Message Object can be set/reset by the CPU via the IFx Message
 * Interface Registers or set by the Message Handler after reception of a Data
 * Frame or reset by the Message Handler at start of a transmission.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description 
 * :-----|:-------|:------|:-------------
 *  [0]  | R      | 0x0   | NewDat128-97
 *  [1]  | R      | 0x0   | NewDat128-97
 *  [2]  | R      | 0x0   | NewDat128-97
 *  [3]  | R      | 0x0   | NewDat128-97
 *  [4]  | R      | 0x0   | NewDat128-97
 *  [5]  | R      | 0x0   | NewDat128-97
 *  [6]  | R      | 0x0   | NewDat128-97
 *  [7]  | R      | 0x0   | NewDat128-97
 *  [8]  | R      | 0x0   | NewDat128-97
 *  [9]  | R      | 0x0   | NewDat128-97
 *  [10] | R      | 0x0   | NewDat128-97
 *  [11] | R      | 0x0   | NewDat128-97
 *  [12] | R      | 0x0   | NewDat128-97
 *  [13] | R      | 0x0   | NewDat128-97
 *  [14] | R      | 0x0   | NewDat128-97
 *  [15] | R      | 0x0   | NewDat128-97
 *  [16] | R      | 0x0   | NewDat128-97
 *  [17] | R      | 0x0   | NewDat128-97
 *  [18] | R      | 0x0   | NewDat128-97
 *  [19] | R      | 0x0   | NewDat128-97
 *  [20] | R      | 0x0   | NewDat128-97
 *  [21] | R      | 0x0   | NewDat128-97
 *  [22] | R      | 0x0   | NewDat128-97
 *  [23] | R      | 0x0   | NewDat128-97
 *  [24] | R      | 0x0   | NewDat128-97
 *  [25] | R      | 0x0   | NewDat128-97
 *  [26] | R      | 0x0   | NewDat128-97
 *  [27] | R      | 0x0   | NewDat128-97
 *  [28] | R      | 0x0   | NewDat128-97
 *  [29] | R      | 0x0   | NewDat128-97
 *  [30] | R      | 0x0   | NewDat128-97
 *  [31] | R      | 0x0   | NewDat128-97
 * 
 */
/*
 * Field : NewDat128-97 - NewDat_0
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_0_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_0_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_0
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_0
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_0 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_0 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_0 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : NewDat128-97 - NewDat_1
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_1_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_1_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_1
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_1
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_1 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_1 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_1 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : NewDat128-97 - NewDat_2
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_2_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_2_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_2
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_2
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_2 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_2 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_2 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : NewDat128-97 - NewDat_3
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_3_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_3_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_3
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_3
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_3 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_3 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_3 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NewDat128-97 - NewDat_4
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_4_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_4_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_4
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_4
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_4 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_4 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_4 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : NewDat128-97 - NewDat_5
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_5_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_5_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_5
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_5
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_5 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_5 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_5 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NewDat128-97 - NewDat_6
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_6_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_6_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_6
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_6
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_6 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_6 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_6 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : NewDat128-97 - NewDat_7
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_7_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_7_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_7
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_7
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_7 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_7 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_7 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : NewDat128-97 - NewDat_8
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_8_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_8_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_8
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_8
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_8 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_8 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_8 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_8 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_8_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : NewDat128-97 - NewDat_9
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_9_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                            |       | portion of this Message Object by the Message   
 * :                                            |       | Handler since last time this flag was cleared by
 * :                                            |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_9_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                            |       | data into the data portion of this Message      
 * :                                            |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_9
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_E_NOTWRITTEN 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_9
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_E_WRITTEN    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_9 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_9 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_9 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_9 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_9_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : NewDat128-97 - NewDat_10
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_10_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_10_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_10
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_10
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_10 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_10 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_10 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_10 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_10_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : NewDat128-97 - NewDat_11
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_11_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_11_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_11
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_11
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_11 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_11 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_11 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_11 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_11_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : NewDat128-97 - NewDat_12
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_12_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_12_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_12
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_12
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_12 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_12 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_12 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_12 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_12_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : NewDat128-97 - NewDat_13
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_13_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_13_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_13
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_13
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_13 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_13 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_13 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_13 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_13_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : NewDat128-97 - NewDat_14
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_14_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_14_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_14
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_14
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_14 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_14 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_14 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_14 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_14_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : NewDat128-97 - NewDat_15
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_15_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_15_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_15
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_15
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_15 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_15 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_15 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_15 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_15_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : NewDat128-97 - NewDat_16
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_16_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_16_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_16
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_16
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_MSB        16
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_SET_MSK    0x00010000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_16 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_CLR_MSK    0xfffeffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_16 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_16 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_16 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_16_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : NewDat128-97 - NewDat_17
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_17_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_17_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_17
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_17
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_MSB        17
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_SET_MSK    0x00020000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_17 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_CLR_MSK    0xfffdffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_17 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_17 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_17 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_17_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : NewDat128-97 - NewDat_18
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_18_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_18_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_18
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_18
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_MSB        18
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_SET_MSK    0x00040000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_18 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_CLR_MSK    0xfffbffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_18 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_18 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_18 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_18_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : NewDat128-97 - NewDat_19
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_19_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_19_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_19
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_19
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_MSB        19
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_SET_MSK    0x00080000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_19 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_19 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_19 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_19 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_19_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : NewDat128-97 - NewDat_20
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_20_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_20_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_20
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_20
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_MSB        20
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_SET_MSK    0x00100000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_20 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_CLR_MSK    0xffefffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_20 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_20 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_20 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_20_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : NewDat128-97 - NewDat_21
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_21_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_21_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_21
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_21
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_MSB        21
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_SET_MSK    0x00200000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_21 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_CLR_MSK    0xffdfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_21 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_21 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_21 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_21_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : NewDat128-97 - NewDat_22
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_22_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_22_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_22
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_22
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_MSB        22
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_SET_MSK    0x00400000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_22 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_CLR_MSK    0xffbfffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_22 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_22 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_22 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_22_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : NewDat128-97 - NewDat_23
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_23_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_23_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_23
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_23
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_MSB        23
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_SET_MSK    0x00800000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_23 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_CLR_MSK    0xff7fffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_23 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_23 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_23 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_23_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : NewDat128-97 - NewDat_24
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_24_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_24_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_24
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_24
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_MSB        24
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_SET_MSK    0x01000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_24 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_CLR_MSK    0xfeffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_24 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_24 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_24 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_24_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : NewDat128-97 - NewDat_25
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_25_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_25_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_25
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_25
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_MSB        25
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_SET_MSK    0x02000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_25 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_CLR_MSK    0xfdffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_25 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_25 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_25 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_25_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : NewDat128-97 - NewDat_26
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_26_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_26_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_26
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_26
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_MSB        26
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_SET_MSK    0x04000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_26 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_CLR_MSK    0xfbffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_26 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_26 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_26 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_26_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : NewDat128-97 - NewDat_27
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_27_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_27_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_27
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_27
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_MSB        27
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_SET_MSK    0x08000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_27 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_27 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_27 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_27 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_27_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : NewDat128-97 - NewDat_28
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_28_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_28_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_28
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_28
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_MSB        28
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_SET_MSK    0x10000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_28 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_CLR_MSK    0xefffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_28 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_28 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_28 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_28_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : NewDat128-97 - NewDat_29
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_29_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_29_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_29
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_29
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_MSB        29
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_SET_MSK    0x20000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_29 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_CLR_MSK    0xdfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_29 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_29 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_29 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_29_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : NewDat128-97 - NewDat_30
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_30_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_30_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_30
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_30
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_MSB        30
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_SET_MSK    0x40000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_30 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_CLR_MSK    0xbfffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_30 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_30 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_30 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_30_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : NewDat128-97 - NewDat_31
 * 
 * New data bits for Message Objects 97 to 128. Array index i corresponds to
 * Message Object i+97.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_31_E_NOTWRITTEN | 0x0   | No new data has been written into the data      
 * :                                             |       | portion of this Message Object by the Message   
 * :                                             |       | Handler since last time this flag was cleared by
 * :                                             |       | the CPU.                                        
 *  ALT_CAN_MSGHAND_MONDD_NEWDAT_31_E_WRITTEN    | 0x1   | The Message Handler or the CPU has written new  
 * :                                             |       | data into the data portion of this Message      
 * :                                             |       | Object.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_31
 * 
 * No new data has been written into the data portion of this Message Object by the
 * Message Handler since last time this flag was cleared by the CPU.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_E_NOTWRITTEN    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MONDD_NEWDAT_31
 * 
 * The Message Handler or the CPU has written new data into the data portion of
 * this Message Object.
 */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_E_WRITTEN       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MONDD_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_MSB        31
/* The width in bits of the ALT_CAN_MSGHAND_MONDD_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MONDD_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_SET_MSK    0x80000000
/* The mask used to clear the ALT_CAN_MSGHAND_MONDD_NEWDAT_31 register field value. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_CLR_MSK    0x7fffffff
/* The reset value of the ALT_CAN_MSGHAND_MONDD_NEWDAT_31 register field. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MONDD_NEWDAT_31 field value from a register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_CAN_MSGHAND_MONDD_NEWDAT_31 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MONDD_NEWDAT_31_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MONDD.
 */
struct ALT_CAN_MSGHAND_MONDD_s
{
    const uint32_t  NewDat_0  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_1  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_2  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_3  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_4  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_5  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_6  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_7  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_8  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_9  :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_10 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_11 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_12 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_13 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_14 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_15 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_16 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_17 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_18 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_19 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_20 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_21 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_22 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_23 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_24 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_25 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_26 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_27 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_28 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_29 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_30 :  1;  /* NewDat128-97 */
    const uint32_t  NewDat_31 :  1;  /* NewDat128-97 */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MONDD. */
typedef volatile struct ALT_CAN_MSGHAND_MONDD_s  ALT_CAN_MSGHAND_MONDD_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MONDD register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MONDD_OFST        0x24
/* The address of the ALT_CAN_MSGHAND_MONDD register. */
#define ALT_CAN_MSGHAND_MONDD_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MONDD_OFST))

/*
 * Register : Interrupt Pending X Register - MOIPX
 * 
 * Reading this register allows the CPU to quickly detect if any of the interrupt
 * pending bits in each of the MOIPA, MOIPB, MOIPC, and MOIPD Interrupt Pending
 * Registers are set.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description
 * :--------|:-------|:------|:------------
 *  [0]     | R      | 0x0   | IntPndA    
 *  [1]     | R      | 0x0   | IntPndA    
 *  [2]     | R      | 0x0   | IntPndA    
 *  [3]     | R      | 0x0   | IntPndA    
 *  [4]     | R      | 0x0   | IntPndB    
 *  [5]     | R      | 0x0   | IntPndB    
 *  [6]     | R      | 0x0   | IntPndB    
 *  [7]     | R      | 0x0   | IntPndB    
 *  [8]     | R      | 0x0   | IntPndC    
 *  [9]     | R      | 0x0   | IntPndC    
 *  [10]    | R      | 0x0   | IntPndC    
 *  [11]    | R      | 0x0   | IntPndC    
 *  [12]    | R      | 0x0   | IntPndD    
 *  [13]    | R      | 0x0   | IntPndD    
 *  [14]    | R      | 0x0   | IntPndD    
 *  [15]    | R      | 0x0   | IntPndD    
 *  [31:16] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : IntPndA - IntPndA_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPA register. Array
 * index i corresponds to byte i of the MOIPA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPA are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPA are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_0
 * 
 * The Message Objects in the corresponding byte of MOIPA are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_0
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPA are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDA_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : IntPndA - IntPndA_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPA register. Array
 * index i corresponds to byte i of the MOIPA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPA are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPA are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_1
 * 
 * The Message Objects in the corresponding byte of MOIPA are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_1
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPA are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDA_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : IntPndA - IntPndA_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPA register. Array
 * index i corresponds to byte i of the MOIPA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPA are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPA are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_2
 * 
 * The Message Objects in the corresponding byte of MOIPA are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_2
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPA are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDA_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : IntPndA - IntPndA_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPA register. Array
 * index i corresponds to byte i of the MOIPA register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPA are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPA are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_3
 * 
 * The Message Objects in the corresponding byte of MOIPA are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDA_3
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPA are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDA_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDA_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : IntPndB - IntPndB_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPB register. Array
 * index i corresponds to byte i of the MOIPB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPB are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPB are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_0
 * 
 * The Message Objects in the corresponding byte of MOIPB are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_0
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPB are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDB_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_0_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : IntPndB - IntPndB_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPB register. Array
 * index i corresponds to byte i of the MOIPB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPB are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPB are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_1
 * 
 * The Message Objects in the corresponding byte of MOIPB are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_1
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPB are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDB_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_1_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : IntPndB - IntPndB_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPB register. Array
 * index i corresponds to byte i of the MOIPB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPB are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPB are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_2
 * 
 * The Message Objects in the corresponding byte of MOIPB are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_2
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPB are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDB_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_2_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : IntPndB - IntPndB_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPB register. Array
 * index i corresponds to byte i of the MOIPB register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPB are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPB are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_3
 * 
 * The Message Objects in the corresponding byte of MOIPB are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDB_3
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPB are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDB_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDB_3_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : IntPndC - IntPndC_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPC register. Array
 * index i corresponds to byte i of the MOIPC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPC are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPC are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_0
 * 
 * The Message Objects in the corresponding byte of MOIPC are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_0
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPC are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_MSB        8
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_SET_MSK    0x00000100
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_CLR_MSK    0xfffffeff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDC_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_0_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : IntPndC - IntPndC_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPC register. Array
 * index i corresponds to byte i of the MOIPC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPC are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPC are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_1
 * 
 * The Message Objects in the corresponding byte of MOIPC are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_1
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPC are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_MSB        9
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_SET_MSK    0x00000200
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_CLR_MSK    0xfffffdff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDC_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_1_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : IntPndC - IntPndC_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPC register. Array
 * index i corresponds to byte i of the MOIPC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPC are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPC are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_2
 * 
 * The Message Objects in the corresponding byte of MOIPC are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_2
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPC are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_MSB        10
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_SET_MSK    0x00000400
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_CLR_MSK    0xfffffbff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDC_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_2_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : IntPndC - IntPndC_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPC register. Array
 * index i corresponds to byte i of the MOIPC register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPC are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPC are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_3
 * 
 * The Message Objects in the corresponding byte of MOIPC are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDC_3
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPC are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_MSB        11
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_SET_MSK    0x00000800
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDC_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDC_3_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : IntPndD - IntPndD_0
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPD register. Array
 * index i corresponds to byte i of the MOIPD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPD are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPD are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_0
 * 
 * The Message Objects in the corresponding byte of MOIPD are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_0
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPD are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_MSB        12
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_SET_MSK    0x00001000
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_CLR_MSK    0xffffefff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDD_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_0_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : IntPndD - IntPndD_1
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPD register. Array
 * index i corresponds to byte i of the MOIPD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPD are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPD are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_1
 * 
 * The Message Objects in the corresponding byte of MOIPD are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_1
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPD are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_MSB        13
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_SET_MSK    0x00002000
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_CLR_MSK    0xffffdfff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDD_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_1_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : IntPndD - IntPndD_2
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPD register. Array
 * index i corresponds to byte i of the MOIPD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPD are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPD are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_2
 * 
 * The Message Objects in the corresponding byte of MOIPD are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_2
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPD are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_MSB        14
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_SET_MSK    0x00004000
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_CLR_MSK    0xffffbfff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDD_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_2_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : IntPndD - IntPndD_3
 * 
 * Each bit in this field is a logical OR of a byte of the MOIPD register. Array
 * index i corresponds to byte i of the MOIPD register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                     
 * :-----------------------------------------|:------|:-------------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_E_NOTSRC | 0x0   | The Message Objects in the corresponding byte of
 * :                                         |       | MOIPD are not the source of an interrupt.       
 *  ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_E_SRC    | 0x1   | One or more of the Message Objects in the       
 * :                                         |       | corresponding byte of MOIPD are the source an   
 * :                                         |       | interrupt.                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_3
 * 
 * The Message Objects in the corresponding byte of MOIPD are not the source of an
 * interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_E_NOTSRC    0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPX_INTPNDD_3
 * 
 * One or more of the Message Objects in the corresponding byte of MOIPD are the
 * source an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_E_SRC       0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_MSB        15
/* The width in bits of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_SET_MSK    0x00008000
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_CLR_MSK    0xffff7fff
/* The reset value of the ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 register field. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_CAN_MSGHAND_MOIPX_INTPNDD_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPX_INTPNDD_3_SET(value) (((value) << 15) & 0x00008000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_CAN_MSGHAND_MOIPX.
 */
struct ALT_CAN_MSGHAND_MOIPX_s
{
    const uint32_t  IntPndA_0 :  1;  /* IntPndA */
    const uint32_t  IntPndA_1 :  1;  /* IntPndA */
    const uint32_t  IntPndA_2 :  1;  /* IntPndA */
    const uint32_t  IntPndA_3 :  1;  /* IntPndA */
    const uint32_t  IntPndB_0 :  1;  /* IntPndB */
    const uint32_t  IntPndB_1 :  1;  /* IntPndB */
    const uint32_t  IntPndB_2 :  1;  /* IntPndB */
    const uint32_t  IntPndB_3 :  1;  /* IntPndB */
    const uint32_t  IntPndC_0 :  1;  /* IntPndC */
    const uint32_t  IntPndC_1 :  1;  /* IntPndC */
    const uint32_t  IntPndC_2 :  1;  /* IntPndC */
    const uint32_t  IntPndC_3 :  1;  /* IntPndC */
    const uint32_t  IntPndD_0 :  1;  /* IntPndD */
    const uint32_t  IntPndD_1 :  1;  /* IntPndD */
    const uint32_t  IntPndD_2 :  1;  /* IntPndD */
    const uint32_t  IntPndD_3 :  1;  /* IntPndD */
    uint32_t                  : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_CAN_MSGHAND_MOIPX. */
typedef volatile struct ALT_CAN_MSGHAND_MOIPX_s  ALT_CAN_MSGHAND_MOIPX_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_CAN_MSGHAND_MOIPX register from the beginning of the component. */
#define ALT_CAN_MSGHAND_MOIPX_OFST        0x28
/* The address of the ALT_CAN_MSGHAND_MOIPX register. */
#define ALT_CAN_MSGHAND_MOIPX_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_CAN_MSGHAND_MOIPX_OFST))

/*
 * Register : Interrupt Pending A Register - MOIPA
 * 
 * Interrupt pending bits for Message Objects 1 to 32.  By reading the IntPnd bits,
 * the CPU can check for which Message Object an interrupt is pending. The IntPnd
 * bit of a specific Message Object can be set/reset by the CPU via the IFx Message
 * Interface Registers or set by the Message Handler after reception or after a
 * successful transmission of a frame. This will also affect the valid of IntID in
 * the Interrupt Register.
 * 
 * Register Layout
 * 
 *  Bits | Access | Reset | Description
 * :-----|:-------|:------|:------------
 *  [0]  | R      | 0x0   | IntPnd32-1 
 *  [1]  | R      | 0x0   | IntPnd32-1 
 *  [2]  | R      | 0x0   | IntPnd32-1 
 *  [3]  | R      | 0x0   | IntPnd32-1 
 *  [4]  | R      | 0x0   | IntPnd32-1 
 *  [5]  | R      | 0x0   | IntPnd32-1 
 *  [6]  | R      | 0x0   | IntPnd32-1 
 *  [7]  | R      | 0x0   | IntPnd32-1 
 *  [8]  | R      | 0x0   | IntPnd32-1 
 *  [9]  | R      | 0x0   | IntPnd32-1 
 *  [10] | R      | 0x0   | IntPnd32-1 
 *  [11] | R      | 0x0   | IntPnd32-1 
 *  [12] | R      | 0x0   | IntPnd32-1 
 *  [13] | R      | 0x0   | IntPnd32-1 
 *  [14] | R      | 0x0   | IntPnd32-1 
 *  [15] | R      | 0x0   | IntPnd32-1 
 *  [16] | R      | 0x0   | IntPnd32-1 
 *  [17] | R      | 0x0   | IntPnd32-1 
 *  [18] | R      | 0x0   | IntPnd32-1 
 *  [19] | R      | 0x0   | IntPnd32-1 
 *  [20] | R      | 0x0   | IntPnd32-1 
 *  [21] | R      | 0x0   | IntPnd32-1 
 *  [22] | R      | 0x0   | IntPnd32-1 
 *  [23] | R      | 0x0   | IntPnd32-1 
 *  [24] | R      | 0x0   | IntPnd32-1 
 *  [25] | R      | 0x0   | IntPnd32-1 
 *  [26] | R      | 0x0   | IntPnd32-1 
 *  [27] | R      | 0x0   | IntPnd32-1 
 *  [28] | R      | 0x0   | IntPnd32-1 
 *  [29] | R      | 0x0   | IntPnd32-1 
 *  [30] | R      | 0x0   | IntPnd32-1 
 *  [31] | R      | 0x0   | IntPnd32-1 
 * 
 */
/*
 * Field : IntPnd32-1 - IntPnd_0
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_0_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_0_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_0
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_0
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_0 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_0 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_MSB        0
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_0 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_0 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_0 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_0 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_0 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : IntPnd32-1 - IntPnd_1
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_1_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_1_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_1
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_1
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_1 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_1 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_MSB        1
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_1 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_1 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_1 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_1 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_1 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : IntPnd32-1 - IntPnd_2
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_2_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_2_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_2
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_2
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_2 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_2 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_MSB        2
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_2 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_2 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_2 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_2 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_2 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : IntPnd32-1 - IntPnd_3
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_3_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_3_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_3
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_3
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_3 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_3 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_MSB        3
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_3 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_3 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_3 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_3 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_3 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : IntPnd32-1 - IntPnd_4
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_4_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_4_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_4
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_4
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_4 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_4 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_MSB        4
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_4 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_4 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_SET_MSK    0x00000010
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_4 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_CLR_MSK    0xffffffef
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_4 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_4 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_4 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_4_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : IntPnd32-1 - IntPnd_5
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_5_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_5_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_5
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_5
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_5 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_5 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_MSB        5
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_5 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_5 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_SET_MSK    0x00000020
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_5 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_CLR_MSK    0xffffffdf
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_5 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_5 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_5 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_5_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : IntPnd32-1 - IntPnd_6
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_6_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_6_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_6
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_6
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_6 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_6 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_MSB        6
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_6 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_6 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_SET_MSK    0x00000040
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_6 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_CLR_MSK    0xffffffbf
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_6 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_6 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_6 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_6_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : IntPnd32-1 - IntPnd_7
 * 
 * Interrupt pending bits for Message Objects 1 to 32. Array index i corresponds to
 * Message Object i+1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                               
 * :----------------------------------------|:------|:-------------------------------------------
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_7_E_NOTSRC | 0x0   | The Message Object is not the source of an
 * :                                        |       | interrupt.                                
 *  ALT_CAN_MSGHAND_MOIPA_INTPND_7_E_SRC    | 0x1   | The Message Object is the source of an    
 * :                                        |       | interrupt.                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_7
 * 
 * The Message Object is not the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_E_NOTSRC 0x0
/*
 * Enumerated value for register field ALT_CAN_MSGHAND_MOIPA_INTPND_7
 * 
 * The Message Object is the source of an interrupt.
 */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_E_SRC    0x1

/* The Least Significant Bit (LSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_7 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_CAN_MSGHAND_MOIPA_INTPND_7 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_MSB        7
/* The width in bits of the ALT_CAN_MSGHAND_MOIPA_INTPND_7 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_WIDTH      1
/* The mask used to set the ALT_CAN_MSGHAND_MOIPA_INTPND_7 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_SET_MSK    0x00000080
/* The mask used to clear the ALT_CAN_MSGHAND_MOIPA_INTPND_7 register field value. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_CLR_MSK    0xffffff7f
/* The reset value of the ALT_CAN_MSGHAND_MOIPA_INTPND_7 register field. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_RESET      0x0
/* Extracts the ALT_CAN_MSGHAND_MOIPA_INTPND_7 field value from a register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_CAN_MSGHAND_MOIPA_INTPND_7 register field value suitable for setting the register. */
#define ALT_CAN_MSGHAND_MOIPA_INTPND_7_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : IntPn