/*******************************************************************************
*                                                                              *
* Copyright 2013 Altera Corporation. All Rights Reserved.                      *
*                                                                              *
* Redistribution and use in source and binary forms, with or without           *
* modification, are permitted provided that the following conditions are met:  *
*                                                                              *
* 1. Redistributions of source code must retain the above copyright notice,    *
*    this list of conditions and the following disclaimer.                     *
*                                                                              *
* 2. Redistributions in binary form must reproduce the above copyright notice, *
*    this list of conditions and the following disclaimer in the documentation *
*    and/or other materials provided with the distribution.                    *
*                                                                              *
* 3. The name of the author may not be used to endorse or promote products     *
*    derived from this software without specific prior written permission.     *
*                                                                              *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY EXPRESS OR *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE DISCLAIMED. IN NO  *
* EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       *
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;  *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,     *
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR      *
* OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF       *
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                   *
*                                                                              *
*******************************************************************************/

/* Altera - ALT_EMAC */

#ifndef __ALTERA_ALT_EMAC_H__
#define __ALTERA_ALT_EMAC_H__

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

/*
 * Component : EMAC Module - ALT_EMAC
 * EMAC Module
 * 
 * Registers in the EMAC module.
 * 
 */
/*
 * Register Group : GMAC Register Group - ALT_EMAC_GMAC
 * GMAC Register Group
 * 
 * GMAC Register Group
 * 
 */
/*
 * Register : Register 0 (MAC Configuration Register) - MAC_Configuration
 * 
 * The MAC Configuration register establishes receive and transmit operating modes.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                    
 * :--------|:-------|:------|:------------------------------------------------
 *  [1:0]   | RW     | 0x0   | Preamble Length for Transmit Frames            
 *  [2]     | RW     | 0x0   | Receiver Enable                                
 *  [3]     | RW     | 0x0   | Transmitter Enable                             
 *  [4]     | RW     | 0x0   | Deferral Check                                 
 *  [6:5]   | RW     | 0x0   | Back-Off Limit                                 
 *  [7]     | RW     | 0x0   | Automatic Pad or CRC Stripping                 
 *  [8]     | RW     | 0x0   | Link Up or Down                                
 *  [9]     | RW     | 0x0   | Disable Retry                                  
 *  [10]    | RW     | 0x0   | Checksum Offload                               
 *  [11]    | RW     | 0x0   | Duplex Mode                                    
 *  [12]    | RW     | 0x0   | Loopback Mode                                  
 *  [13]    | RW     | 0x0   | Disable Receive Own                            
 *  [14]    | RW     | 0x0   | Speed                                          
 *  [15]    | RW     | 0x0   | Port Select                                    
 *  [16]    | RW     | 0x0   | Disable Carrier Sense During Transmission      
 *  [19:17] | RW     | 0x0   | Inter-Frame Gap                                
 *  [20]    | RW     | 0x0   | Jumbo Frame Enable                             
 *  [21]    | RW     | 0x0   | Frame Burst Enable                             
 *  [22]    | RW     | 0x0   | Jabber Disable                                 
 *  [23]    | RW     | 0x0   | Watchdog Disable                               
 *  [24]    | RW     | 0x0   | Transmit Configuration in RGMII, SGMII, or SMII
 *  [25]    | RW     | 0x0   | CRC Stripping of Type Frames                   
 *  [26]    | ???    | 0x0   | *UNDEFINED*                                    
 *  [27]    | RW     | 0x0   | IEEE 802.3as support for 2K packets Enable     
 *  [31:28] | ???    | 0x0   | *UNDEFINED*                                    
 * 
 */
/*
 * Field : Preamble Length for Transmit Frames - prelen
 * 
 * These bits control the number of preamble bytes that are added to the beginning
 * of every Transmit frame. The preamble reduction occurs only when the MAC is
 * operating
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description     
 * :-------------------------------------------|:------|:-----------------
 *  ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM7BYTES | 0x0   | Preamble 7 Bytes
 *  ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM5BYTES | 0x1   | Preamble 5 Bytes
 *  ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM3BYTES | 0x2   | Preamble 3 Bytes
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PRELEN
 * 
 * Preamble 7 Bytes
 */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM7BYTES  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PRELEN
 * 
 * Preamble 5 Bytes
 */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM5BYTES  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PRELEN
 * 
 * Preamble 3 Bytes
 */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_E_PREAM3BYTES  0x2

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_SET_MSK    0x00000003
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_CLR_MSK    0xfffffffc
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_PRELEN register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_PRELEN field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_PRELEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_PRELEN_SET(value) (((value) << 0) & 0x00000003)

/*
 * Field : Receiver Enable - re
 * 
 * When this bit is set, the receiver state machine of the MAC is enabled for
 * receiving frames from the GMII or MII. When this bit is reset, the MAC receive
 * state machine is disabled after the completion of the reception of the current
 * frame, and does not receive any further frames from the GMII or MII.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_RE_E_DISD | 0x0   | MAC receive state machine disabled
 *  ALT_EMAC_GMAC_MAC_CFG_RE_E_END  | 0x1   | MAC receive state machine enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_RE
 * 
 * MAC receive state machine disabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_RE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_RE
 * 
 * MAC receive state machine enabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_RE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_RE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_RE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_RE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_RE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_RE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_RE_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Transmitter Enable - te
 * 
 * When this bit is set, the transmit state machine of the MAC is enabled for
 * transmission on the GMII or MII. When this bit is reset, the MAC transmit state
 * machine is disabled after the completion of the transmission of the current
 * frame, and does not transmit any further frames.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                        
 * :--------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_TE_E_DISD | 0x0   | MAC transmit state machine disabled
 *  ALT_EMAC_GMAC_MAC_CFG_TE_E_END  | 0x1   | MAC transmit state machine disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TE
 * 
 * MAC transmit state machine disabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_TE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TE
 * 
 * MAC transmit state machine disabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_TE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_TE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_TE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_TE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_TE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_TE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_TE_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Deferral Check - dc
 * 
 * When this bit is set, the deferral check function is enabled in the MAC. The MAC
 * issues a Frame Abort status, along with the excessive deferral error bit set in
 * the transmit frame status, when the transmit state machine is deferred for more
 * than 24,288 bit times in the 10 or 100 Mbps mode. If the MAC is configured for
 * 1000 Mbps operation, or if the Jumbo frame mode is enabled in the 10 or 100 Mbps
 * mode, the threshold for deferral is 155,680 bits times. Deferral begins when the
 * transmitter is ready to transmit, but is prevented because of an active carrier
 * sense signal (CRS) on GMII or MII. Defer time is not cumulative. When the
 * transmitter defers for 10,000 bit times, it transmits, collides, backs off, and
 * then defers again after completion of back-off. The deferral timer resets to 0
 * and restarts.
 * 
 * When this bit is reset, the deferral check function is disabled and the MAC
 * defers until the CRS signal goes inactive. This bit is applicable only in the
 * half-duplex mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description            
 * :--------------------------------|:------|:------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_DC_E_END  | 0x1   | Deferral Check Enabled 
 *  ALT_EMAC_GMAC_MAC_CFG_DC_E_DISD | 0x0   | Deferral Check Disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DC
 * 
 * Deferral Check Enabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_DC_E_END  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DC
 * 
 * Deferral Check Disabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_DC_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DC field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DC_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Back-Off Limit - bl
 * 
 * The Back-Off limit determines the random integer number (r) of slot time delays
 * (4,096 bit times for 1000 Mbps and 512 bit times for 10/100 Mbps) for which the
 * MAC waits before rescheduling a transmission attempt during retries after a
 * collision. This bit is applicable only in the half-duplex mode.
 * 
 * * 00: k = min (n, 10)
 * 
 * * 01: k = min (n, 8)
 * 
 * * 10: k = min (n, 4)
 * 
 * * 11: k = min (n, 1)
 * 
 * where <i> n </i>= retransmission attempt. The random integer <i> r </i> takes
 * the value in the
 * 
 * range 0 <= r < kth power of 2
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description    
 * :---------------------------------------|:------|:----------------
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMTR10 | 0x0   | k = min (n, 10)
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMIRT8 | 0x1   | k = min (n, 8) 
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR4 | 0x2   | k = min (n, 4) 
 *  ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR1 | 0x3   | k = min (n, 1) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 * k = min (n, 10)
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMTR10  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 * k = min (n, 8)
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMIRT8  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 * k = min (n, 4)
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR4  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BL
 * 
 * k = min (n, 1)
 */
#define ALT_EMAC_GMAC_MAC_CFG_BL_E_BACKLIMITR1  0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_BL register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_SET_MSK    0x00000060
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_BL register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_CLR_MSK    0xffffff9f
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_BL register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_BL field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_GET(value) (((value) & 0x00000060) >> 5)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_BL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_BL_SET(value) (((value) << 5) & 0x00000060)

/*
 * Field : Automatic Pad or CRC Stripping - acs
 * 
 * When this bit is set, the MAC strips the Pad or FCS field on the incoming frames
 * only if the value of the length field is less than 1,536 bytes. All received
 * frames with length field greater than or equal to 1,536 bytes are passed to the
 * application without stripping the Pad or FCS field.
 * 
 * When this bit is reset, the MAC passes all incoming frames, without modifying
 * them, to the Host.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_ACS_E_DISD | 0x0   | Disable Automatic Pad CRC Stripping
 *  ALT_EMAC_GMAC_MAC_CFG_ACS_E_END  | 0x1   | Enable Automatic Pad CRC Stripping 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_ACS
 * 
 * Disable Automatic Pad CRC Stripping
 */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_ACS
 * 
 * Enable Automatic Pad CRC Stripping
 */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_ACS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_ACS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_ACS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_ACS field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_ACS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_ACS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Link Up or Down - lud
 * 
 * This bit indicates whether the link is up or down during the transmission of
 * configuration in the RGMII, SGMII, or SMII interface
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MAC_CFG_LUD_E_DISD | 0x0   | Link Down  
 *  ALT_EMAC_GMAC_MAC_CFG_LUD_E_END  | 0x1   | Link Up    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LUD
 * 
 * Link Down
 */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LUD
 * 
 * Link Up
 */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_LUD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_LUD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_LUD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_LUD field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_LUD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_LUD_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Disable Retry - dr
 * 
 * When this bit is set, the MAC attempts only one transmission. When a collision
 * occurs on the GMII or MII interface, the MAC ignores the current frame
 * transmission and reports a Frame Abort with excessive collision error in the
 * transmit frame status.
 * 
 * When this bit is reset, the MAC attempts retries based on the settings of the BL
 * field (Bits [6:5]). This bit is applicable only in the half-duplex mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                      
 * :--------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_DR_E_DISD | 0x1   | MAC attempts one transmission    
 *  ALT_EMAC_GMAC_MAC_CFG_DR_E_END  | 0x0   | MAC attempts retries per bl Field
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DR
 * 
 * MAC attempts one transmission
 */
#define ALT_EMAC_GMAC_MAC_CFG_DR_E_DISD 0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DR
 * 
 * MAC attempts retries per bl Field
 */
#define ALT_EMAC_GMAC_MAC_CFG_DR_E_END  0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DR register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DR register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DR register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DR field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DR_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Checksum Offload - ipc
 * 
 * When this bit is set, the MAC calculates the 16-bit ones complement of the ones
 * complement sum of all received Ethernet frame payloads. It also checks whether
 * the IPv4 Header checksum (assumed to be bytes 2526 or 2930 (VLAN-tagged) of the
 * received Ethernet frame) is correct for the received frame and gives the status
 * in the receive status word. The MAC also appends the 16-bit checksum calculated
 * for the IP header datagram payload (bytes after the IPv4 header) and appends it
 * to the Ethernet frame transferred to the application (when Type 2 COE is
 * deselected).
 * 
 * When this bit is reset, this function is disabled.
 * 
 * When Type 2 COE is selected, this bit, when set, enables the IPv4 header
 * checksum checking and IPv4 or IPv6 TCP, UDP, or ICMP payload checksum checking.
 * When this bit is reset, the COE function in the receiver is disabled and the
 * corresponding PCE and IP HCE status bits are always cleared.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description      
 * :---------------------------------|:------|:------------------
 *  ALT_EMAC_GMAC_MAC_CFG_IPC_E_END  | 0x1   | Checksum Enabled 
 *  ALT_EMAC_GMAC_MAC_CFG_IPC_E_DISD | 0x0   | Checksum Disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IPC
 * 
 * Checksum Enabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_E_END     0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IPC
 * 
 * Checksum Disabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_E_DISD    0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_IPC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_IPC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_IPC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_IPC field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_IPC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_IPC_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : Duplex Mode - dm
 * 
 * When this bit is set, the MAC operates in the full-duplex mode where it can
 * transmit and receive simultaneously.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description             
 * :--------------------------------|:------|:-------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_DM_E_END  | 0x1   | MAC Full Duplex Enabled 
 *  ALT_EMAC_GMAC_MAC_CFG_DM_E_DISD | 0x0   | MAC Full Duplex Disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DM
 * 
 * MAC Full Duplex Enabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_DM_E_END  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DM
 * 
 * MAC Full Duplex Disabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_DM_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DM field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DM_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Loopback Mode - lm
 * 
 * When this bit is set, the MAC operates in the loopback mode at GMII or MII. The
 * (G)MII Receive clock input is required for the loopback to work properly,
 * because the Transmit clock is not looped-back internally.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description      
 * :--------------------------------|:------|:------------------
 *  ALT_EMAC_GMAC_MAC_CFG_LM_E_DISD | 0x0   | Disable Loop Back
 *  ALT_EMAC_GMAC_MAC_CFG_LM_E_END  | 0x1   | Enable Loop Back 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LM
 * 
 * Disable Loop Back
 */
#define ALT_EMAC_GMAC_MAC_CFG_LM_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_LM
 * 
 * Enable Loop Back
 */
#define ALT_EMAC_GMAC_MAC_CFG_LM_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_LM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_LM register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_LM register field. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_LM field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_LM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_LM_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Disable Receive Own - do
 * 
 * When this bit is set, the MAC disables the reception of frames when the
 * gmii_txen_o is asserted in the half-duplex mode.
 * 
 * When this bit is reset, the MAC receives all packets that are given by the PHY
 * while transmitting.
 * 
 * This bit is not applicable if the MAC is operating in the full-duplex mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                     
 * :--------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_DO_E_END  | 0x0   | MAC Enables Reception of Frames 
 *  ALT_EMAC_GMAC_MAC_CFG_DO_E_DISD | 0x1   | MAC Disables Reception of Frames
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DO
 * 
 * MAC Enables Reception of Frames
 */
#define ALT_EMAC_GMAC_MAC_CFG_DO_E_END  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DO
 * 
 * MAC Disables Reception of Frames
 */
#define ALT_EMAC_GMAC_MAC_CFG_DO_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DO register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DO register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DO register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DO field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DO_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : Speed - fes
 * 
 * This bit selects the speed in the RMII/RGMII interface:
 * 
 * * 0: 10 Mbps
 * 
 * * 1: 100 Mbps
 * 
 * This bit generates link speed encoding when TC (Bit 24) is set in the RGMII,
 * SMII, or SGMII mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description     
 * :-------------------------------------|:------|:-----------------
 *  ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED10  | 0x0   | Speed = 10 Mbps 
 *  ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED100 | 0x1   | Speed = 100 Mbps
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_FES
 * 
 * Speed = 10 Mbps
 */
#define ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED10     0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_FES
 * 
 * Speed = 100 Mbps
 */
#define ALT_EMAC_GMAC_MAC_CFG_FES_E_SPEED100    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_FES register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_FES register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_FES register field. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_FES field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_FES register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_FES_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : Port Select - ps
 * 
 * This bit selects between GMII and MII
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description    
 * :---------------------------------------|:------|:----------------
 *  ALT_EMAC_GMAC_MAC_CFG_PS_E_GMII1000SEL | 0x0   | GMII 1000 Mbps 
 *  ALT_EMAC_GMAC_MAC_CFG_PS_E_MII10100SEL | 0x1   | MII 10/100 Mbps
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PS
 * 
 * GMII 1000 Mbps
 */
#define ALT_EMAC_GMAC_MAC_CFG_PS_E_GMII1000SEL  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_PS
 * 
 * MII 10/100 Mbps
 */
#define ALT_EMAC_GMAC_MAC_CFG_PS_E_MII10100SEL  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_PS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_PS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_PS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_PS field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_PS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_PS_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : Disable Carrier Sense During Transmission - dcrs
 * 
 * When set high, this bit makes the MAC transmitter ignore the (G)MII CRS signal
 * during frame transmission in the half-duplex mode. This request results in no
 * errors generated because of Loss of Carrier or No Carrier during such
 * transmission. When this bit is low, the MAC transmitter generates such errors
 * because of Carrier Sense and can even abort the transmissions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                     
 * :----------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_DCRS_E_DISD | 0x0   | MAC Tx Gen. Err. No Carrier     
 *  ALT_EMAC_GMAC_MAC_CFG_DCRS_E_END  | 0x1   | MAC Tx Ignores (G)MII Crs Signal
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DCRS
 * 
 * MAC Tx Gen. Err. No Carrier
 */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_DCRS
 * 
 * MAC Tx Ignores (G)MII Crs Signal
 */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_DCRS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_DCRS register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_DCRS register field. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_DCRS field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_DCRS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_DCRS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : Inter-Frame Gap - ifg
 * 
 * These bits control the minimum IFG between frames during transmission.
 * 
 * In the half-duplex mode, the minimum IFG can be configured only for 64 bit times
 * (IFG = 100). Lower values are not considered. In the 1000-Mbps mode, the minimum
 * IFG supported is 80 bit times (and above).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                 
 * :------------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG96BITTIMES | 0x0   | Inter Frame Gap 96 bit times
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG88BITTIMES | 0x1   | Inter Frame Gap 88 bit times
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG80BITTIMES | 0x2   | Inter Frame Gap 80 bit times
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG72BITTIMES | 0x3   | Inter Frame Gap 72 bit times
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG64BITTIMES | 0x4   | Inter Frame Gap 64 bit times
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG56BITTIMES | 0x5   | Inter Frame Gap 56 bit times
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG48BITTIMES | 0x6   | Inter Frame Gap 48 bit times
 *  ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG40BITTIMES | 0x7   | Inter Frame Gap 40 bit times
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 96 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG96BITTIMES   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 88 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG88BITTIMES   0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 80 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG80BITTIMES   0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 72 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG72BITTIMES   0x3
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 64 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG64BITTIMES   0x4
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 56 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG56BITTIMES   0x5
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 48 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG48BITTIMES   0x6
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_IFG
 * 
 * Inter Frame Gap 40 bit times
 */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_E_IFG40BITTIMES   0x7

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_WIDTH      3
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_IFG register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_SET_MSK    0x000e0000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_IFG register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_CLR_MSK    0xfff1ffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_IFG register field. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_IFG field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_GET(value) (((value) & 0x000e0000) >> 17)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_IFG register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_IFG_SET(value) (((value) << 17) & 0x000e0000)

/*
 * Field : Jumbo Frame Enable - je
 * 
 * When this bit is set, the MAC allows Jumbo frames of 9,018 bytes (9,022 bytes
 * for VLAN tagged frames) without reporting a giant frame error in the receive
 * frame status.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description             
 * :--------------------------------|:------|:-------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_JE_E_DISD | 0x0   | Report Jumbo Frame Error
 *  ALT_EMAC_GMAC_MAC_CFG_JE_E_END  | 0x1   | Ignore Jumbo Frame Error
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JE
 * 
 * Report Jumbo Frame Error
 */
#define ALT_EMAC_GMAC_MAC_CFG_JE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JE
 * 
 * Ignore Jumbo Frame Error
 */
#define ALT_EMAC_GMAC_MAC_CFG_JE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_JE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_JE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_JE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_JE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_JE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_JE_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : Frame Burst Enable - be
 * 
 * When this bit is set, the MAC allows frame bursting during transmission in the
 * GMII half-duplex mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description           
 * :--------------------------------|:------|:-----------------------
 *  ALT_EMAC_GMAC_MAC_CFG_BE_E_DISD | 0x0   | Frame Burst Enable OFF
 *  ALT_EMAC_GMAC_MAC_CFG_BE_E_END  | 0x1   | Frame Burst Enable ON 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BE
 * 
 * Frame Burst Enable OFF
 */
#define ALT_EMAC_GMAC_MAC_CFG_BE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_BE
 * 
 * Frame Burst Enable ON
 */
#define ALT_EMAC_GMAC_MAC_CFG_BE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_BE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_BE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_BE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_BE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_BE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_BE_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : Jabber Disable - jd
 * 
 * When this bit is set, the MAC disables the jabber timer on the transmitter. The
 * MAC can transfer frames of up to 16,384 bytes.
 * 
 * When this bit is reset, the MAC cuts off the transmitter if the application
 * sends out more than 2,048 bytes of data (10,240 if JE is set high) during
 * transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description           
 * :--------------------------------|:------|:-----------------------
 *  ALT_EMAC_GMAC_MAC_CFG_JD_E_END  | 0x0   | MAC cuts off TX > 2048
 *  ALT_EMAC_GMAC_MAC_CFG_JD_E_DISD | 0x1   | Jabber Timer Disabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JD
 * 
 * MAC cuts off TX > 2048
 */
#define ALT_EMAC_GMAC_MAC_CFG_JD_E_END  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_JD
 * 
 * Jabber Timer Disabled
 */
#define ALT_EMAC_GMAC_MAC_CFG_JD_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_JD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_JD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_JD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_JD field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_JD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_JD_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : Watchdog Disable - wd
 * 
 * When this bit is set, the MAC disables the watchdog timer on the receiver. The
 * MAC can receive frames of up to 16,384 bytes.
 * 
 * When this bit is reset, the MAC does not allow more than 2,048 bytes (10,240 if
 * JE is set high) of the frame being received. The MAC cuts off any bytes received
 * after 2,048 bytes.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                  
 * :--------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_WD_E_END  | 0x0   | Enable MAC cutoff > 2048Bytes
 *  ALT_EMAC_GMAC_MAC_CFG_WD_E_DISD | 0x1   | Disable Watchdog             
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_WD
 * 
 * Enable MAC cutoff > 2048Bytes
 */
#define ALT_EMAC_GMAC_MAC_CFG_WD_E_END  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_WD
 * 
 * Disable Watchdog
 */
#define ALT_EMAC_GMAC_MAC_CFG_WD_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_WD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_WD register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_WD register field. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_WD field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_WD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_WD_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : Transmit Configuration in RGMII, SGMII, or SMII - tc
 * 
 * When set, this bit enables the transmission of duplex mode, link speed, and link
 * up or down information to the PHY in the RGMII. When this bit is reset, no such
 * information is driven to the PHY.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                   
 * :--------------------------------|:------|:-------------------------------
 *  ALT_EMAC_GMAC_MAC_CFG_TC_E_END  | 0x1   | Enables Transmission of duplex
 *  ALT_EMAC_GMAC_MAC_CFG_TC_E_DISD | 0x0   | Disables Transmission to Phy  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TC
 * 
 * Enables Transmission of duplex
 */
#define ALT_EMAC_GMAC_MAC_CFG_TC_E_END  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_TC
 * 
 * Disables Transmission to Phy
 */
#define ALT_EMAC_GMAC_MAC_CFG_TC_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_TC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_TC register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_TC register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_TC field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_TC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_TC_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : CRC Stripping of Type Frames - cst
 * 
 * When set, the last 4 bytes (FCS) of all frames of Ether type (type field greater
 * than 0x0600) are stripped and dropped before forwarding the frame to the
 * application. This function is not valid when the IP Checksum Engine (Type 1) is
 * enabled in the MAC receiver.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description           
 * :---------------------------------|:------|:-----------------------
 *  ALT_EMAC_GMAC_MAC_CFG_CST_E_DISD | 0x0   | Strip Ether Frames Off
 *  ALT_EMAC_GMAC_MAC_CFG_CST_E_END  | 0x1   | Strip Ether Frames On 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_CST
 * 
 * Strip Ether Frames Off
 */
#define ALT_EMAC_GMAC_MAC_CFG_CST_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_CFG_CST
 * 
 * Strip Ether Frames On
 */
#define ALT_EMAC_GMAC_MAC_CFG_CST_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_CST register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_CST register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_CST register field. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_CST field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_CST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_CST_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : IEEE 802.3as support for 2K packets Enable - twokpe
 * 
 * When set, the MAC considers all frames, with up to 2,000 bytes length, as normal
 * packets. When Bit 20 (Jumbo Enable) is not set, the MAC considers all received
 * frames of size more than 2K bytes as Giant frames.
 * 
 * When this bit is reset and Bit 20 (Jumbo Enable) is not set, the MAC considers
 * all received frames of size more than 1,518 bytes (1,522 bytes for tagged) as
 * Giant frames.
 * 
 * When Bit 20 (Jumbo Enable) is set, setting this bit has no effect on Giant Frame
 * status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field value. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_CFG_TWOKPE field value from a register. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_CFG_TWOKPE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_CFG_TWOKPE_SET(value) (((value) << 27) & 0x08000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_CFG.
 */
struct ALT_EMAC_GMAC_MAC_CFG_s
{
    uint32_t  prelen :  2;  /* Preamble Length for Transmit Frames */
    uint32_t  re     :  1;  /* Receiver Enable */
    uint32_t  te     :  1;  /* Transmitter Enable */
    uint32_t  dc     :  1;  /* Deferral Check */
    uint32_t  bl     :  2;  /* Back-Off Limit */
    uint32_t  acs    :  1;  /* Automatic Pad or CRC Stripping */
    uint32_t  lud    :  1;  /* Link Up or Down */
    uint32_t  dr     :  1;  /* Disable Retry */
    uint32_t  ipc    :  1;  /* Checksum Offload */
    uint32_t  dm     :  1;  /* Duplex Mode */
    uint32_t  lm     :  1;  /* Loopback Mode */
    uint32_t  do_    :  1;  /* Disable Receive Own */
    uint32_t  fes    :  1;  /* Speed */
    uint32_t  ps     :  1;  /* Port Select */
    uint32_t  dcrs   :  1;  /* Disable Carrier Sense During Transmission */
    uint32_t  ifg    :  3;  /* Inter-Frame Gap */
    uint32_t  je     :  1;  /* Jumbo Frame Enable */
    uint32_t  be     :  1;  /* Frame Burst Enable */
    uint32_t  jd     :  1;  /* Jabber Disable */
    uint32_t  wd     :  1;  /* Watchdog Disable */
    uint32_t  tc     :  1;  /* Transmit Configuration in RGMII, SGMII, or SMII */
    uint32_t  cst    :  1;  /* CRC Stripping of Type Frames */
    uint32_t         :  1;  /* *UNDEFINED* */
    uint32_t  twokpe :  1;  /* IEEE 802.3as support for 2K packets Enable */
    uint32_t         :  4;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_CFG. */
typedef volatile struct ALT_EMAC_GMAC_MAC_CFG_s  ALT_EMAC_GMAC_MAC_CFG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_CFG register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_CFG_OFST        0x0
/* The address of the ALT_EMAC_GMAC_MAC_CFG register. */
#define ALT_EMAC_GMAC_MAC_CFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_CFG_OFST))

/*
 * Register : Register 1 (MAC Frame Filter) - MAC_Frame_Filter
 * 
 * The MAC Frame Filter register contains the filter controls for receiving frames.
 * Some of the controls from this register go to the address check block of the
 * MAC, which performs the first level of address filtering. The second level of
 * filtering is performed on the incoming frame, based on other controls such as
 * Pass Bad Frames and Pass Control Frames.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [0]     | RW     | 0x0   | Promiscuous Mode                 
 *  [1]     | RW     | 0x0   | Hash Unicast                     
 *  [2]     | RW     | 0x0   | Hash Multicast                   
 *  [3]     | RW     | 0x0   | DA Inverse Filtering             
 *  [4]     | RW     | 0x0   | Pass All Multicast               
 *  [5]     | RW     | 0x0   | Disable Broadcast Frames         
 *  [7:6]   | RW     | 0x0   | Pass Control Frames              
 *  [8]     | RW     | 0x0   | SA Inverse Filtering             
 *  [9]     | RW     | 0x0   | Source Address Filter Enable     
 *  [10]    | RW     | 0x0   | Hash or Perfect Filter           
 *  [15:11] | ???    | 0x0   | *UNDEFINED*                      
 *  [16]    | RW     | 0x0   | VLAN Tag Filter Enable           
 *  [19:17] | ???    | 0x0   | *UNDEFINED*                      
 *  [20]    | RW     | 0x0   | Layer 3 and Layer 4 Filter Enable
 *  [21]    | RW     | 0x0   | Drop non-TCP/UDP over IP Frames  
 *  [30:22] | ???    | 0x0   | *UNDEFINED*                      
 *  [31]    | RW     | 0x0   | Receive All                      
 * 
 */
/*
 * Field : Promiscuous Mode - pr
 * 
 * When this bit is set, the Address Filter block passes all incoming frames
 * regardless of its destination or source address. The SA or DA Filter Fails
 * status bits of the Receive Status Word are always cleared when PR is set.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description               
 * :------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_END  | 0x1   | All Incoming Frames Passed
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_DISD | 0x0   | Clear SA DA Status Bits   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PR
 * 
 * All Incoming Frames Passed
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_END  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PR
 * 
 * Clear SA DA Status Bits
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_PR field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_PR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PR_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Hash Unicast - huc
 * 
 * When set, MAC performs destination address filtering of unicast frames according
 * to the hash table.
 * 
 * When reset, the MAC performs a perfect destination address filtering for unicast
 * frames, that is, it compares the DA field with the values programmed in DA
 * registers.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                
 * :-------------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_END  | 0x1   | MAC Filters with Hash Table
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_DISD | 0x0   | MAC Filters with Compare   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HUC
 * 
 * MAC Filters with Hash Table
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_END     0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HUC
 * 
 * MAC Filters with Compare
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_E_DISD    0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_HUC field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_HUC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HUC_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Hash Multicast - hmc
 * 
 * When set, MAC performs destination address filtering of received multicast
 * frames according to the hash table.
 * 
 * When reset, the MAC performs a perfect destination address filtering for
 * multicast frames, that is, it compares the DA field with the values programmed
 * in DA registers.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                
 * :-------------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_DISD | 0x0   | MAC Filters with Hash Table
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_END  | 0x1   | MAC Filters with Compare   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HMC
 * 
 * MAC Filters with Hash Table
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HMC
 * 
 * MAC Filters with Compare
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_HMC field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_HMC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HMC_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : DA Inverse Filtering - daif
 * 
 * When this bit is set, the Address Check block operates in inverse filtering mode
 * for the DA address comparison for both unicast and multicast frames.
 * 
 * When reset, normal filtering of frames is performed.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                       
 * :--------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_DISD | 0x0   | Normal Inverse Filter             
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_END  | 0x1   | Address Check Block Inverse Filter
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF
 * 
 * Normal Inverse Filter
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF
 * 
 * Address Check Block Inverse Filter
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DAIF_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Pass All Multicast - pm
 * 
 * When set, this bit indicates that all received frames with a multicast
 * destination address (first bit in the destination address field is '1') are
 * passed.
 * 
 * When reset, filtering of multicast frame depends on HMC bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description               
 * :------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_DISD | 0x0   | Allows Filter of MC Frames
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_END  | 0x1   | All Rcvd MC Frames Pass   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PM
 * 
 * Allows Filter of MC Frames
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PM
 * 
 * All Rcvd MC Frames Pass
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_PM field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_PM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PM_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Disable Broadcast Frames - dbf
 * 
 * When this bit is set, the AFM block filters all incoming broadcast frames. In
 * addition, it overrides all other filter settings.
 * 
 * When this bit is reset, the AFM block passes all received broadcast frames.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                
 * :-------------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_DISD | 0x0   | Pass All Broadcast Frames  
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_END  | 0x1   | Filter All Broadcast Frames
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DBF
 * 
 * Pass All Broadcast Frames
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DBF
 * 
 * Filter All Broadcast Frames
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_DBF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_DBF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DBF_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Pass Control Frames - pcf
 * 
 * These bits control the forwarding of all control frames (including unicast and
 * multicast PAUSE frames).
 * 
 * * 00: MAC filters all control frames from reaching the application.
 * 
 * * 01: MAC forwards all control frames except PAUSE control frames to application
 *   even if they fail the Address filter.
 * 
 * * 10: MAC forwards all control frames to application even if they fail the
 *   Address Filter.
 * 
 * * 11: MAC forwards control frames that pass the Address Filter.
 * 
 * The following conditions should be true for the PAUSE control frames processing:
 * 
 * * Condition 1: The MAC is in the full-duplex mode and flow control is enabled by
 *   setting Bit 2 (RFE) of Register 6 (Flow Control Register) to 1.
 * 
 * * Condition 2: The destination address (DA) of the received frame matches the
 *   special multicast address or the MAC Address 0 when Bit 3 (UP) of the Register
 *   6 (Flow Control Register) is set.
 * 
 * * Condition 3: The Type field of the received frame is 0x8808 and the OPCODE
 *   field is 0x0001.
 * 
 * This field should be set to 01 only when the Condition 1 is true, that is, the
 * MAC is programmed to operate in the full-duplex mode and the RFE bit is enabled.
 * Otherwise, the PAUSE frame filtering may be inconsistent. When Condition 1 is
 * false, the PAUSE frames are considered as generic control frames. Therefore, to
 * pass all control frames (including PAUSE control frames) when the full-duplex
 * mode and flow control is not enabled, you should set the PCF field to 10 or 11
 * (as required by the application).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                  
 * :---------------------------------------------|:------|:----------------------------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFLTALLCFR | 0x0   | MAC filters all control frames               
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDXPAUSE | 0x1   | MAC forwards all control frames except PAUSE 
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDFAIL   | 0x2   | MAC forwards all control frames fail addrflt 
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDPASS   | 0x3   | MAC forwards control frames that pass addrflt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 * MAC filters all control frames
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFLTALLCFR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 * MAC forwards all control frames except PAUSE
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDXPAUSE    0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 * MAC forwards all control frames fail addrflt
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDFAIL      0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_PCF
 * 
 * MAC forwards control frames that pass addrflt
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_E_MACFWDPASS      0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_SET_MSK    0x000000c0
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_CLR_MSK    0xffffff3f
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_PCF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_GET(value) (((value) & 0x000000c0) >> 6)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_PCF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_PCF_SET(value) (((value) << 6) & 0x000000c0)

/*
 * Field : SA Inverse Filtering - saif
 * 
 * When this bit is set, the Address Check block operates in inverse filtering mode
 * for the SA address comparison. The frames whose SA matches the SA registers are
 * marked as failing the SA Address filter.
 * 
 * When this bit is reset, frames whose SA does not match the SA registers are
 * marked as failing the SA Address filter.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description    
 * :--------------------------------------|:------|:----------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_DISD | 0x0   | SA Nomatch Fail
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_END  | 0x1   | SA Match Fail  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF
 * 
 * SA Nomatch Fail
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF
 * 
 * SA Match Fail
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAIF_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Source Address Filter Enable - saf
 * 
 * When this bit is set, the MAC compares the SA field of the received frames with
 * the values programmed in the enabled SA registers. If the comparison matches,
 * then the SA Match bit of RxStatus Word is set high. When this bit is set high
 * and the SA filter fails, the MAC drops the frame.
 * 
 * When this bit is reset, the MAC forwards the received frame to the application
 * and with the updated SA Match bit of the RxStatus depending on the SA address
 * comparison.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_DISD | 0x0   | SA Filter Off
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_END  | 0x1   | SA Filter On 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAF
 * 
 * SA Filter Off
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_SAF
 * 
 * SA Filter On
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_SAF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_SAF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_SAF_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Hash or Perfect Filter - hpf
 * 
 * When this bit is set, it configures the address filter to pass a frame if it
 * matches either the perfect filtering or the hash filtering as set by the HMC or
 * HUC bits.
 * 
 * When this bit is low and the HUC or HMC bit is set, the frame is passed only if
 * it matches the Hash filter.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description               
 * :-------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_DISD | 0x0   | Hash or Perfect Filter off
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_END  | 0x1   | Hash or Perfect Filter on 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HPF
 * 
 * Hash or Perfect Filter off
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_HPF
 * 
 * Hash or Perfect Filter on
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_HPF field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_HPF register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_HPF_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : VLAN Tag Filter Enable - vtfe
 * 
 * When set, this bit enables the MAC to drop VLAN tagged frames that do not match
 * the VLAN Tag comparison.
 * 
 * When reset, the MAC forwards all frames irrespective of the match status of the
 * VLAN Tag.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                  
 * :----------------------------------------|:------|:----------------------------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_NODROP | 0x0   | Forward all frames irrespective of the match 
 * :                                        |       | status of the VLAN tag                       
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_DROP   | 0x1   | Drop VLAN tagged frames that do not match the
 * :                                        |       | VLAN Tag comparison                          
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE
 * 
 * Forward all frames irrespective of the match status of the VLAN tag
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_NODROP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE
 * 
 * Drop VLAN tagged frames that do not match the VLAN Tag comparison
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_E_DROP   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_VTFE_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : Layer 3 and Layer 4 Filter Enable - ipfe
 * 
 * When set, this bit enables the MAC to drop frames that do not match the enabled
 * Layer 3 and Layer 4 filters. If Layer 3 or Layer 4 filters are not enabled for
 * matching, this bit does not have any effect.
 * 
 * When reset, the MAC forwards all frames irrespective of the match status of the
 * Layer 3 and Layer 4 filters.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                    
 * :----------------------------------------|:------|:------------------------------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_NODROP | 0x0   | Forward all frames irrespective of the match   
 * :                                        |       | status of Layer 3 and Layer 4 filters          
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_DROP   | 0x1   | Drop frames that do not match the enabled Layer
 * :                                        |       | 3 and Layer 4 filters                          
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE
 * 
 * Forward all frames irrespective of the match status of Layer 3 and Layer 4
 * filters
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_NODROP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE
 * 
 * Drop frames that do not match the enabled Layer 3 and Layer 4 filters
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_E_DROP   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_IPFE_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : Drop non-TCP/UDP over IP Frames - dntu
 * 
 * When set, this bit enables the MAC to drop the non-TCP or UDP over IP frames.
 * The MAC forward only those frames that are processed by the Layer 4 filter.
 * 
 * When reset, this bit enables the MAC to forward all non-TCP or UDP over IP
 * frames.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                              
 * :----------------------------------------|:------|:------------------------------------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_NODROP | 0x0   | Forward all non-TCP or UDP over IP frames
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_DROP   | 0x1   | Drop non-TCP or UDP over IP frames       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU
 * 
 * Forward all non-TCP or UDP over IP frames
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_NODROP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU
 * 
 * Drop non-TCP or UDP over IP frames
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_E_DROP   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_DNTU_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : Receive All - ra
 * 
 * When this bit is set, the MAC Receiver block passes all received frames,
 * irrespective of whether they pass the address filter or not, to the Application.
 * The result of the SA or DA filtering is updated (pass or fail) in the
 * corresponding bits in the Receive Status Word.
 * 
 * When this bit is reset, the Receiver block passes only those frames to the
 * Application that pass the SA or DA address filter.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description    
 * :------------------------------------|:------|:----------------
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_DISD | 0x0   | Receive All off
 *  ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_END  | 0x1   | Receive All On 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_RA
 * 
 * Receive All off
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_FRM_FLT_RA
 * 
 * Receive All On
 */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field value. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_FRM_FLT_RA field value from a register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_FRM_FLT_RA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_RA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_FRM_FLT.
 */
struct ALT_EMAC_GMAC_MAC_FRM_FLT_s
{
    uint32_t  pr   :  1;  /* Promiscuous Mode */
    uint32_t  huc  :  1;  /* Hash Unicast */
    uint32_t  hmc  :  1;  /* Hash Multicast */
    uint32_t  daif :  1;  /* DA Inverse Filtering */
    uint32_t  pm   :  1;  /* Pass All Multicast */
    uint32_t  dbf  :  1;  /* Disable Broadcast Frames */
    uint32_t  pcf  :  2;  /* Pass Control Frames */
    uint32_t  saif :  1;  /* SA Inverse Filtering */
    uint32_t  saf  :  1;  /* Source Address Filter Enable */
    uint32_t  hpf  :  1;  /* Hash or Perfect Filter */
    uint32_t       :  5;  /* *UNDEFINED* */
    uint32_t  vtfe :  1;  /* VLAN Tag Filter Enable */
    uint32_t       :  3;  /* *UNDEFINED* */
    uint32_t  ipfe :  1;  /* Layer 3 and Layer 4 Filter Enable */
    uint32_t  dntu :  1;  /* Drop non-TCP/UDP over IP Frames */
    uint32_t       :  9;  /* *UNDEFINED* */
    uint32_t  ra   :  1;  /* Receive All */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_FRM_FLT. */
typedef volatile struct ALT_EMAC_GMAC_MAC_FRM_FLT_s  ALT_EMAC_GMAC_MAC_FRM_FLT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_FRM_FLT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_OFST        0x4
/* The address of the ALT_EMAC_GMAC_MAC_FRM_FLT register. */
#define ALT_EMAC_GMAC_MAC_FRM_FLT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_FRM_FLT_OFST))

/*
 * Register : Register 4 (GMII Address Register) - GMII_Address
 * 
 * The GMII Address register controls the management cycles to the external PHY
 * through the management interface.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description           
 * :--------|:-------|:------|:-----------------------
 *  [0]     | RW     | 0x0   | GMII Busy             
 *  [1]     | RW     | 0x0   | GMII Write            
 *  [5:2]   | RW     | 0x0   | CSR Clock Range       
 *  [10:6]  | RW     | 0x0   | GMII Register         
 *  [15:11] | RW     | 0x0   | Physical Layer Address
 *  [31:16] | ???    | 0x0   | *UNDEFINED*           
 * 
 */
/*
 * Field : GMII Busy - gb
 * 
 * This bit should read logic 0 before writing to Register 4 and Register 5. During
 * a PHY or RevMII register access, the software sets this bit to 1'b1 to indicate
 * that a Read or Write access is in progress.
 * 
 * The Register 5 is invalid until this bit is cleared by the MAC. Therefore,
 * Register 5 (GMII Data) should be kept valid until the MAC clears this bit during
 * a PHY Write operation. Similarly for a read operation, the contents of Register
 * 5 are not valid until this bit is cleared.
 * 
 * The subsequent read or write operation should happen only after the previous
 * operation is complete. Because there is no acknowledgment from the PHY to MAC
 * after a read or write operation is completed, there is no change in the
 * functionality of this bit even when the PHY is not present.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_GMII_ADDR_GB_E_DISD | 0x0   | Not Busy   
 *  ALT_EMAC_GMAC_GMII_ADDR_GB_E_END  | 0x1   | Busy       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GB
 * 
 * Not Busy
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GB
 * 
 * Busy
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_GB register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_GB register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_GB register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_GB field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_GB register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GB_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : GMII Write - gw
 * 
 * When set, this bit indicates to the PHY or RevMII that this is a Write operation
 * using the GMII Data register. If this bit is not set, it indicates that this is
 * a Read operation, that is, placing the data in the GMII Data register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description         
 * :----------------------------------|:------|:---------------------
 *  ALT_EMAC_GMAC_GMII_ADDR_GW_E_DISD | 0x0   | Gmii Write Operation
 *  ALT_EMAC_GMAC_GMII_ADDR_GW_E_END  | 0x1   | Gmii Read Operation 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GW
 * 
 * Gmii Write Operation
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_GW
 * 
 * Gmii Read Operation
 */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_GW register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_GW register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_GW register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_GW field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_GW register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GW_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : CSR Clock Range - cr
 * 
 * The CSR Clock Range selection determines the frequency of the MDC clock
 * according to the l3_sp_clk frequency used in your design. The suggested range of
 * l3_sp_clk frequency applicable for each value (when Bit[5] = 0) ensures that the
 * MDC clock is approximately between the frequency range 1.0 MHz - 2.5 MHz.
 * 
 * When Bit 5 is set, you can achieve MDC clock of frequency higher than the IEEE
 * 802.3 specified frequency limit of 2.5 MHz and program a clock divider of lower
 * value. For example, when l3_sp_clk is of 100 MHz frequency and you program these
 * bits as 1010, then the resultant MDC clock is of 12.5 MHz which is outside the
 * limit of IEEE 802.3 specified range. Only use the values larger than 7 if the
 * interfacing chips support faster MDC clocks.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                     
 * :----------------------------------------|:------|:-------------------------------------------------
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV42      | 0x0   | l3_sp_clk 60-100Mhz  and MDC clock =            
 * :                                        |       | l3_sp_clk/42                                    
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV62      | 0x1   | l3_sp_clk 100-150Mhz and MDC clock =            
 * :                                        |       | l3_sp_clk/62                                    
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16      | 0x2   | l3_sp_clk 25-35Mhz and MDC clock  = l3_sp_clk/16
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV26      | 0x3   | l3_sp_clk 35-60Mhz and MDC clock  = l3_sp_clk/26
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV102     | 0x4   | l3_sp_clk 150-250Mhz and MDC clock =            
 * :                                        |       | l3_sp_clk/102                                   
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV124     | 0x5   | l3_sp_clk 250-300Mhz and MDC clock =            
 * :                                        |       | l3_sp_clk/124                                   
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV4       | 0x8   | l3_sp_clk/4                                     
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV6       | 0x9   | l3_sp_clk/6                                     
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV8       | 0xa   | l3_sp_clk/8                                     
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV10      | 0xb   | l3_sp_clk/10                                    
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV12      | 0xc   | l3_sp_clk/12                                    
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV14      | 0xd   | l3_sp_clk/14                                    
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16AGAIN | 0xe   | l3_sp_clk/16                                    
 *  ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV18      | 0xf   | l3_sp_clk/18                                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk 60-100Mhz  and MDC clock =  l3_sp_clk/42
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV42      0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk 100-150Mhz and MDC clock =  l3_sp_clk/62
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV62      0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk 25-35Mhz and MDC clock  = l3_sp_clk/16
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16      0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk 35-60Mhz and MDC clock  = l3_sp_clk/26
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV26      0x3
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk 150-250Mhz and MDC clock = l3_sp_clk/102
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV102     0x4
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk 250-300Mhz and MDC clock = l3_sp_clk/124
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV124     0x5
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/4
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV4       0x8
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/6
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV6       0x9
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/8
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV8       0xa
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/10
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV10      0xb
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/12
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV12      0xc
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/14
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV14      0xd
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/16
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV16AGAIN 0xe
/*
 * Enumerated value for register field ALT_EMAC_GMAC_GMII_ADDR_CR
 * 
 * l3_sp_clk/18
 */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_E_DIV18      0xf

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_WIDTH      4
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_CR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_SET_MSK    0x0000003c
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_CR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_CLR_MSK    0xffffffc3
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_CR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_CR field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_GET(value) (((value) & 0x0000003c) >> 2)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_CR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_CR_SET(value) (((value) << 2) & 0x0000003c)

/*
 * Field : GMII Register - gr
 * 
 * These bits select the desired GMII register in the selected PHY device.
 * 
 * For RevMII, these bits select the desired CSR register in the RevMII Registers
 * set.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_WIDTH      5
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_GR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_SET_MSK    0x000007c0
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_GR register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_CLR_MSK    0xfffff83f
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_GR register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_GR field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_GET(value) (((value) & 0x000007c0) >> 6)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_GR register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_GR_SET(value) (((value) << 6) & 0x000007c0)

/*
 * Field : Physical Layer Address - pa
 * 
 * This field indicates which of the 32 possible PHY devices are being accessed.
 * 
 * For RevMII, this field gives the PHY Address of the RevMII block.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_WIDTH      5
/* The mask used to set the ALT_EMAC_GMAC_GMII_ADDR_PA register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_SET_MSK    0x0000f800
/* The mask used to clear the ALT_EMAC_GMAC_GMII_ADDR_PA register field value. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_CLR_MSK    0xffff07ff
/* The reset value of the ALT_EMAC_GMAC_GMII_ADDR_PA register field. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_ADDR_PA field value from a register. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_GET(value) (((value) & 0x0000f800) >> 11)
/* Produces a ALT_EMAC_GMAC_GMII_ADDR_PA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_ADDR_PA_SET(value) (((value) << 11) & 0x0000f800)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_GMII_ADDR.
 */
struct ALT_EMAC_GMAC_GMII_ADDR_s
{
    uint32_t  gb :  1;  /* GMII Busy */
    uint32_t  gw :  1;  /* GMII Write */
    uint32_t  cr :  4;  /* CSR Clock Range */
    uint32_t  gr :  5;  /* GMII Register */
    uint32_t  pa :  5;  /* Physical Layer Address */
    uint32_t     : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_GMII_ADDR. */
typedef volatile struct ALT_EMAC_GMAC_GMII_ADDR_s  ALT_EMAC_GMAC_GMII_ADDR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_GMII_ADDR register from the beginning of the component. */
#define ALT_EMAC_GMAC_GMII_ADDR_OFST        0x10
/* The address of the ALT_EMAC_GMAC_GMII_ADDR register. */
#define ALT_EMAC_GMAC_GMII_ADDR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_GMII_ADDR_OFST))

/*
 * Register : Register 5 (GMII Data Register) - GMII_Data
 * 
 * The GMII Data register stores Write data to be written to the PHY register
 * located at the address specified in Register 4 (GMII Address Register). This
 * register also stores the Read data from the PHY register located at the address
 * specified by Register 4.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description
 * :--------|:-------|:------|:------------
 *  [15:0]  | RW     | 0x0   | GMII Data  
 *  [31:16] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : GMII Data - gd
 * 
 * This field contains the 16-bit data value read from the PHY or RevMII after a
 * Management Read operation or the 16-bit data value to be written to the PHY or
 * RevMII before a Management Write operation.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_GMII_DATA_GD register field value. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_GMII_DATA_GD register field value. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_GMII_DATA_GD register field. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_GMII_DATA_GD field value from a register. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_GMII_DATA_GD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_GMII_DATA_GD_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_GMII_DATA.
 */
struct ALT_EMAC_GMAC_GMII_DATA_s
{
    uint32_t  gd : 16;  /* GMII Data */
    uint32_t     : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_GMII_DATA. */
typedef volatile struct ALT_EMAC_GMAC_GMII_DATA_s  ALT_EMAC_GMAC_GMII_DATA_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_GMII_DATA register from the beginning of the component. */
#define ALT_EMAC_GMAC_GMII_DATA_OFST        0x14
/* The address of the ALT_EMAC_GMAC_GMII_DATA register. */
#define ALT_EMAC_GMAC_GMII_DATA_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_GMII_DATA_OFST))

/*
 * Register : Register 6 (Flow Control Register) - Flow_Control
 * 
 * The Flow Control register controls the generation and reception of the Control
 * (Pause Command) frames by the MAC's Flow control block. A Write to a register
 * with the Busy bit set to '1' triggers the Flow Control block to generate a Pause
 * Control frame. The fields of the control frame are selected as specified in the
 * 802.3x specification, and the Pause Time value from this register is used in the
 * Pause Time field of the control frame. The Busy bit remains set until the
 * control frame is transferred onto the cable. The Host must make sure that the
 * Busy bit is cleared before writing to the register.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                               
 * :--------|:-------|:------|:-------------------------------------------
 *  [0]     | RW     | 0x0   | Flow Control Busy or Backpressure Activate
 *  [1]     | RW     | 0x0   | Transmit Flow Control Enable              
 *  [2]     | RW     | 0x0   | Receive Flow Control Enable               
 *  [3]     | RW     | 0x0   | Unicast Pause Frame Detect                
 *  [5:4]   | RW     | 0x0   | Pause Low Threshold                       
 *  [6]     | ???    | 0x0   | *UNDEFINED*                               
 *  [7]     | RW     | 0x0   | Disable Zero-Quanta Pause                 
 *  [15:8]  | ???    | 0x0   | *UNDEFINED*                               
 *  [31:16] | RW     | 0x0   | Pause Time                                
 * 
 */
/*
 * Field : Flow Control Busy or Backpressure Activate - fca_bpa
 * 
 * This bit initiates a Pause Control frame in the full-duplex mode and activates
 * the backpressure function in the half-duplex mode if the TFE bit is set.
 * 
 * In the full-duplex mode, this bit should be read as 1'b0 before writing to the
 * Flow Control register. To initiate a Pause control frame, the Application must
 * set this bit to 1'b1. During a transfer of the Control Frame, this bit continues
 * to be set to signify that a frame transmission is in progress. After the
 * completion of Pause control frame transmission, the MAC resets this bit to 1'b0.
 * The Flow Control register should not be written to until this bit is cleared.
 * 
 * In the half-duplex mode, when this bit is set (and TFE is set), then
 * backpressure is asserted by the MAC. During backpressure, when the MAC receives
 * a new frame, the transmitter starts sending a JAM pattern resulting in a
 * collision. This control register bit is logically ORed with the mti_flowctrl_i
 * input signal for the backpressure function. When the MAC is configured for the
 * full-duplex mode, the BPA is automatically disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                  
 * :--------------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_DISD | 0x0   | Pause Ctrl Frame and BPA off 
 *  ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_END  | 0x1   | Init Pause Ctrl Frame and BPA
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA
 * 
 * Pause Ctrl Frame and BPA off
 */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA
 * 
 * Init Pause Ctrl Frame and BPA
 */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_FCA_BPA_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Transmit Flow Control Enable - tfe
 * 
 * In the full-duplex mode, when this bit is set, the MAC enables the flow control
 * operation to transmit Pause frames. When this bit is reset, the flow control
 * operation in the MAC is disabled, and the MAC does not transmit any Pause
 * frames.
 * 
 * In half-duplex mode, when this bit is set, the MAC enables the back-pressure
 * operation. When this bit is reset, the back-pressure feature is disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                  
 * :----------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_FLOW_CTL_TFE_E_DISD | 0x0   | Transmit Flow Control Disable
 *  ALT_EMAC_GMAC_FLOW_CTL_TFE_E_END  | 0x1   | Transmit Flow Control Enable 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_TFE
 * 
 * Transmit Flow Control Disable
 */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_TFE
 * 
 * Transmit Flow Control Enable
 */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_TFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_TFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_TFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_TFE field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_TFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_TFE_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Receive Flow Control Enable - rfe
 * 
 * When this bit is set, the MAC decodes the received Pause frame and disables its
 * transmitter for a specified (Pause) time. When this bit is reset, the decode
 * function of the Pause frame is disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                         
 * :----------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_FLOW_CTL_RFE_E_DISD | 0x0   | Decode Func. of Pause Frame Disabled
 *  ALT_EMAC_GMAC_FLOW_CTL_RFE_E_END  | 0x1   | MAC decodes the received Pause      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_RFE
 * 
 * Decode Func. of Pause Frame Disabled
 */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_RFE
 * 
 * MAC decodes the received Pause
 */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_RFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_RFE register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_RFE register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_RFE field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_RFE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_RFE_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Unicast Pause Frame Detect - up
 * 
 * When this bit is set, then in addition to the detecting Pause frames with the
 * unique multicast address, the MAC detects the Pause frames with the station's
 * unicast address specified in the MAC Address0 High Register and MAC Address0 Low
 * Register. When this bit is reset, the MAC detects only a Pause frame with the
 * unique multicast address specified in the 802.3x standard.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                  
 * :---------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_FLOW_CTL_UP_E_DISD | 0x0   | MAC Detects Pause MCA        
 *  ALT_EMAC_GMAC_FLOW_CTL_UP_E_END  | 0x1   | MAC Detects Pause MCA and UCA
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_UP
 * 
 * MAC Detects Pause MCA
 */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_UP
 * 
 * MAC Detects Pause MCA and UCA
 */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_UP register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_UP register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_UP register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_UP field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_UP register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_UP_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Pause Low Threshold - plt
 * 
 * This field configures the threshold of the PAUSE timer at which the input flow
 * control signal mti_flowctrl_i (or sbd_flowctrl_i) is checked for automatic
 * retransmission of PAUSE Frame.
 * 
 * The threshold values should be always less than the Pause Time configured in
 * Bits[31:16]. For example, if PT = 100H (256 slot-times), and PLT = 01, then a
 * second PAUSE frame is automatically transmitted if the mti_flowctrl_i signal is
 * asserted at 228 (256 - 28) slot times after the first PAUSE frame is
 * transmitted.
 * 
 * The slot time is defined as the time taken to transmit 512 bits (64 bytes) on
 * the GMII or MII interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                
 * :-------------------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_4   | 0x0   | Pause time - 4 slot times  
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_28  | 0x1   | Pause time - 28 slot times 
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_144 | 0x2   | Pause time - 144 slot times
 *  ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_256 | 0x3   | Pause time - 256 slot times
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 * Pause time - 4 slot times
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_4    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 * Pause time - 28 slot times
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_28   0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 * Pause time - 144 slot times
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_144  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_PLT
 * 
 * Pause time - 256 slot times
 */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_E_PAUSETIME_256  0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_PLT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_SET_MSK    0x00000030
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_PLT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_CLR_MSK    0xffffffcf
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_PLT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_PLT field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_GET(value) (((value) & 0x00000030) >> 4)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_PLT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PLT_SET(value) (((value) << 4) & 0x00000030)

/*
 * Field : Disable Zero-Quanta Pause - dzpq
 * 
 * When this bit is set, it disables the automatic generation of the Zero-Quanta
 * Pause Control frames on the de-assertion of the flow-control signal from the
 * FIFO layer (MTL or external sideband flow control signal
 * sbd_flowctrl_i/mti_flowctrl_i).
 * 
 * When this bit is reset, normal operation with automatic Zero-Quanta Pause
 * Control frame generation is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                           
 * :-----------------------------------|:------|:---------------------------------------
 *  ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_END  | 0x1   | Disable Auto Gen. of Zero-Quanta Pause
 *  ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_DISD | 0x0   | Enable Auto Gen. of Zero-Quanta Pause 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_DZPQ
 * 
 * Disable Auto Gen. of Zero-Quanta Pause
 */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_END   0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_FLOW_CTL_DZPQ
 * 
 * Enable Auto Gen. of Zero-Quanta Pause
 */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_DZPQ field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_DZPQ register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_DZPQ_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Pause Time - pt
 * 
 * This field holds the value to be used in the Pause Time field in the transmit
 * control frame. Because the Pause Time bits are double-synchronized to the (G)MII
 * clock domain, then consecutive writes to this register should be performed only
 * after at least four clock cycles in the destination clock domain.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_FLOW_CTL_PT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_SET_MSK    0xffff0000
/* The mask used to clear the ALT_EMAC_GMAC_FLOW_CTL_PT register field value. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_CLR_MSK    0x0000ffff
/* The reset value of the ALT_EMAC_GMAC_FLOW_CTL_PT register field. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_FLOW_CTL_PT field value from a register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_FLOW_CTL_PT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_FLOW_CTL_PT_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_FLOW_CTL.
 */
struct ALT_EMAC_GMAC_FLOW_CTL_s
{
    uint32_t  fca_bpa :  1;  /* Flow Control Busy or Backpressure Activate */
    uint32_t  tfe     :  1;  /* Transmit Flow Control Enable */
    uint32_t  rfe     :  1;  /* Receive Flow Control Enable */
    uint32_t  up      :  1;  /* Unicast Pause Frame Detect */
    uint32_t  plt     :  2;  /* Pause Low Threshold */
    uint32_t          :  1;  /* *UNDEFINED* */
    uint32_t  dzpq    :  1;  /* Disable Zero-Quanta Pause */
    uint32_t          :  8;  /* *UNDEFINED* */
    uint32_t  pt      : 16;  /* Pause Time */
};

/* The typedef declaration for register ALT_EMAC_GMAC_FLOW_CTL. */
typedef volatile struct ALT_EMAC_GMAC_FLOW_CTL_s  ALT_EMAC_GMAC_FLOW_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_FLOW_CTL register from the beginning of the component. */
#define ALT_EMAC_GMAC_FLOW_CTL_OFST        0x18
/* The address of the ALT_EMAC_GMAC_FLOW_CTL register. */
#define ALT_EMAC_GMAC_FLOW_CTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_FLOW_CTL_OFST))

/*
 * Register : Register 7 (VLAN Tag Register) - VLAN_Tag
 * 
 * The VLAN Tag register contains the IEEE 802.1Q VLAN Tag to identify the VLAN
 * frames. The MAC compares the 13th and 14th bytes of the receiving frame
 * (Length/Type) with 16'h8100, and the following two bytes are compared with the
 * VLAN tag. If a match occurs, the MAC sets the received VLAN bit in the receive
 * frame status. The legal length of the frame is increased from 1,518 bytes to
 * 1,522 bytes.
 * 
 * Because the VLAN Tag register is double-synchronized to the (G)MII clock domain,
 * then consecutive writes to these register should be performed only after at
 * least four clock cycles in the destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                           
 * :--------|:-------|:------|:---------------------------------------
 *  [15:0]  | RW     | 0x0   | VLAN Tag Identifier for Receive Frames
 *  [16]    | RW     | 0x0   | Enable 12-Bit VLAN Tag Comparison     
 *  [17]    | RW     | 0x0   | VLAN Tag Inverse Match Enable         
 *  [18]    | RW     | 0x0   | Enable S-VLAN                         
 *  [19]    | RW     | 0x0   | VLAN Tag Hash Table Match Enable      
 *  [31:20] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : VLAN Tag Identifier for Receive Frames - vl
 * 
 * This field contains the 802.1Q VLAN tag to identify the VLAN frames and is
 * compared to the 15th and 16th bytes of the frames being received for VLAN
 * frames. The following list describes the bits of this field:
 * 
 * * Bits [15:13]: User Priority
 * 
 * * Bit 12: Canonical Format Indicator (CFI) or Drop Eligible Indicator (DEI)
 * 
 * * Bits[11:0]: VLAN tag's VLAN Identifier (VID) field
 * 
 * When the ETV bit is set, only the VID (Bits[11:0]) is used for comparison.
 * 
 * If VL (VL[11:0] if ETV is set) is all zeros, the MAC does not check the
 * fifteenth and 16th bytes for VLAN tag comparison, and declares all frames with a
 * Type field value of 0x8100 or 0x88a8 as VLAN frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_VL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_VL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_VL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_VL field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_VL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VL_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Enable 12-Bit VLAN Tag Comparison - etv
 * 
 * When this bit is set, a 12-bit VLAN identifier is used for comparing and
 * filtering instead of the complete 16-bit VLAN tag. Bits [11:0] of VLAN tag are
 * compared with the corresponding field in the received VLAN-tagged frame.
 * Similarly, when enabled, only 12 bits of the VLAN tag in the received frame are
 * used for hash-based VLAN filtering.
 * 
 * When this bit is reset, all 16 bits of the 15th and 16th bytes of the received
 * VLAN frame are used for comparison and VLAN hash filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                    
 * :----------------------------------|:------|:--------------------------------
 *  ALT_EMAC_GMAC_VLAN_TAG_ETV_E_DISD | 0x0   | Disable 12-Bit VLAN Tag Compare
 *  ALT_EMAC_GMAC_VLAN_TAG_ETV_E_END  | 0x1   | Enable 12-Bit VLAN Tag Compare 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_VLAN_TAG_ETV
 * 
 * Disable 12-Bit VLAN Tag Compare
 */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_VLAN_TAG_ETV
 * 
 * Enable 12-Bit VLAN Tag Compare
 */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_ETV register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_ETV register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_ETV register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_ETV field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_ETV register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ETV_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : VLAN Tag Inverse Match Enable - vtim
 * 
 * When set, this bit enables the VLAN Tag inverse matching. The frames that do not
 * have matching VLAN Tag are marked as matched.
 * 
 * When reset, this bit enables the VLAN Tag perfect matching. The frames with
 * matched VLAN Tag are marked as matched.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_VTIM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_VTIM field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_VTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTIM_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : Enable S-VLAN - esvl
 * 
 * When this bit is set, the MAC transmitter and receiver also consider the S-VLAN
 * (Type = 0x88A8) frames as valid VLAN tagged frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_ESVL register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_ESVL field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_ESVL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ESVL_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : VLAN Tag Hash Table Match Enable - vthm
 * 
 * When set, the most significant four bits of the VLAN tag's CRC are used to index
 * the content of Register 354 (VLAN Hash Table Register). A value of 1 in the VLAN
 * Hash Table register, corresponding to the index, indicates that the frame
 * matched the VLAN hash table.
 * 
 * When Bit 16 (ETV) is set, the CRC of the 12-bit VLAN Identifier (VID) is used
 * for comparison whereas when ETV is reset, the CRC of the 16-bit VLAN tag is used
 * for comparison.
 * 
 * When reset, the VLAN Hash Match operation is not performed.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field value. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_VLAN_TAG_VTHM register field. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_VLAN_TAG_VTHM field value from a register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_VLAN_TAG_VTHM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VLAN_TAG_VTHM_SET(value) (((value) << 19) & 0x00080000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_VLAN_TAG.
 */
struct ALT_EMAC_GMAC_VLAN_TAG_s
{
    uint32_t  vl   : 16;  /* VLAN Tag Identifier for Receive Frames */
    uint32_t  etv  :  1;  /* Enable 12-Bit VLAN Tag Comparison */
    uint32_t  vtim :  1;  /* VLAN Tag Inverse Match Enable */
    uint32_t  esvl :  1;  /* Enable S-VLAN */
    uint32_t  vthm :  1;  /* VLAN Tag Hash Table Match Enable */
    uint32_t       : 12;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_VLAN_TAG. */
typedef volatile struct ALT_EMAC_GMAC_VLAN_TAG_s  ALT_EMAC_GMAC_VLAN_TAG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_VLAN_TAG register from the beginning of the component. */
#define ALT_EMAC_GMAC_VLAN_TAG_OFST        0x1c
/* The address of the ALT_EMAC_GMAC_VLAN_TAG register. */
#define ALT_EMAC_GMAC_VLAN_TAG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_VLAN_TAG_OFST))

/*
 * Register : Register 8 (Version Register) - Version
 * 
 * The Version registers identifies the version of the EMAC. This register contains
 * two bytes: one specified by Synopsys to identify the core release number, and
 * the other specified by Altera.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description              
 * :--------|:-------|:------|:--------------------------
 *  [7:0]   | R      | 0x37  | ALT_EMAC_GMAC_VER_SNPSVER
 *  [15:8]  | R      | 0x10  | ALT_EMAC_GMAC_VER_USERVER
 *  [31:16] | ???    | 0x0   | *UNDEFINED*              
 * 
 */
/*
 * Field : snpsver
 * 
 * Synopsys-defined Version (3.7)
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_VER_SNPSVER register field value. */
#define ALT_EMAC_GMAC_VER_SNPSVER_SET_MSK    0x000000ff
/* The mask used to clear the ALT_EMAC_GMAC_VER_SNPSVER register field value. */
#define ALT_EMAC_GMAC_VER_SNPSVER_CLR_MSK    0xffffff00
/* The reset value of the ALT_EMAC_GMAC_VER_SNPSVER register field. */
#define ALT_EMAC_GMAC_VER_SNPSVER_RESET      0x37
/* Extracts the ALT_EMAC_GMAC_VER_SNPSVER field value from a register. */
#define ALT_EMAC_GMAC_VER_SNPSVER_GET(value) (((value) & 0x000000ff) >> 0)
/* Produces a ALT_EMAC_GMAC_VER_SNPSVER register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VER_SNPSVER_SET(value) (((value) << 0) & 0x000000ff)

/*
 * Field : userver
 * 
 * Altera-defined Version
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_WIDTH      8
/* The mask used to set the ALT_EMAC_GMAC_VER_USERVER register field value. */
#define ALT_EMAC_GMAC_VER_USERVER_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_EMAC_GMAC_VER_USERVER register field value. */
#define ALT_EMAC_GMAC_VER_USERVER_CLR_MSK    0xffff00ff
/* The reset value of the ALT_EMAC_GMAC_VER_USERVER register field. */
#define ALT_EMAC_GMAC_VER_USERVER_RESET      0x10
/* Extracts the ALT_EMAC_GMAC_VER_USERVER field value from a register. */
#define ALT_EMAC_GMAC_VER_USERVER_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_EMAC_GMAC_VER_USERVER register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_VER_USERVER_SET(value) (((value) << 8) & 0x0000ff00)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_VER.
 */
struct ALT_EMAC_GMAC_VER_s
{
    const uint32_t  snpsver :  8;  /* ALT_EMAC_GMAC_VER_SNPSVER */
    const uint32_t  userver :  8;  /* ALT_EMAC_GMAC_VER_USERVER */
    uint32_t                : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_VER. */
typedef volatile struct ALT_EMAC_GMAC_VER_s  ALT_EMAC_GMAC_VER_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_VER register from the beginning of the component. */
#define ALT_EMAC_GMAC_VER_OFST        0x20
/* The address of the ALT_EMAC_GMAC_VER register. */
#define ALT_EMAC_GMAC_VER_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_VER_OFST))

/*
 * Register : Register 9 (Debug Register) - Debug
 * 
 * The Debug register gives the status of all main blocks of the transmit and
 * receive data-paths and the FIFOs. An all-zero status indicates that the MAC is
 * in idle state (and FIFOs are empty) and no activity is going on in the data-
 * paths.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                    
 * :--------|:-------|:------|:------------------------------------------------
 *  [0]     | R      | 0x0   | MAC GMII or MII Receive Protocol Engine Status 
 *  [2:1]   | R      | 0x0   | MAC Receive Frame Controller FIFO Status       
 *  [3]     | ???    | 0x0   | *UNDEFINED*                                    
 *  [4]     | R      | 0x0   | MTL Rx FIFO Write Controller Active Status     
 *  [6:5]   | R      | 0x0   | MTL Rx FIFO Read Controller State              
 *  [7]     | ???    | 0x0   | *UNDEFINED*                                    
 *  [9:8]   | R      | 0x0   | MTL Rx FIFO Fill-level Status                  
 *  [15:10] | ???    | 0x0   | *UNDEFINED*                                    
 *  [16]    | R      | 0x0   | MAC GMII or MII Transmit Protocol Engine Status
 *  [18:17] | R      | 0x0   | MAC Transmit Frame Controller Status           
 *  [19]    | R      | 0x0   | MAC transmitter in PAUSE                       
 *  [21:20] | R      | 0x0   | MTL Tx FIFO Read Controller Status             
 *  [22]    | R      | 0x0   | MTL Tx FIFO Write Controller Active Status     
 *  [23]    | ???    | 0x0   | *UNDEFINED*                                    
 *  [24]    | R      | 0x0   | MTL Tx FIFO Not Empty Status                   
 *  [25]    | R      | 0x0   | MTL TxStatus FIFO Full Status                  
 *  [31:26] | ???    | 0x0   | *UNDEFINED*                                    
 * 
 */
/*
 * Field : MAC GMII or MII Receive Protocol Engine Status - rpests
 * 
 * When high, this bit indicates that the MAC GMII or MII receive protocol engine
 * is actively receiving data and not in IDLE state.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description           
 * :---------------------------------|:------|:-----------------------
 *  ALT_EMAC_GMAC_DBG_RPESTS_E_INACT | 0x0   | Idle State            
 *  ALT_EMAC_GMAC_DBG_RPESTS_E_ACT   | 0x1   | Protocol Engine Active
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RPESTS
 * 
 * Idle State
 */
#define ALT_EMAC_GMAC_DBG_RPESTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RPESTS
 * 
 * Protocol Engine Active
 */
#define ALT_EMAC_GMAC_DBG_RPESTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_RPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_RPESTS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_RPESTS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_DBG_RPESTS register field. */
#define ALT_EMAC_GMAC_DBG_RPESTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RPESTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RPESTS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_DBG_RPESTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RPESTS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : MAC Receive Frame Controller FIFO Status - rfcfcsts
 * 
 * When high, this field indicates the active state of the small FIFO Read and
 * Write controllers of the MAC Receive Frame Controller Module.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                         
 * :-----------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_DBG_RFCFCSTS_E_INACT | 0x0   | Disable Active State FIFO Read Write
 *  ALT_EMAC_GMAC_DBG_RFCFCSTS_E_ACT   | 0x1   | Enable Active State FIFO Read Write 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RFCFCSTS
 * 
 * Disable Active State FIFO Read Write
 */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RFCFCSTS
 * 
 * Enable Active State FIFO Read Write
 */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_RFCFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_SET_MSK    0x00000006
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RFCFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_CLR_MSK    0xfffffff9
/* The reset value of the ALT_EMAC_GMAC_DBG_RFCFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RFCFCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_GET(value) (((value) & 0x00000006) >> 1)
/* Produces a ALT_EMAC_GMAC_DBG_RFCFCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RFCFCSTS_SET(value) (((value) << 1) & 0x00000006)

/*
 * Field : MTL Rx FIFO Write Controller Active Status - rwcsts
 * 
 * When high, this bit indicates that the MTL Rx FIFO Write Controller is active
 * and is transferring a received frame to the FIFO.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                             
 * :---------------------------------|:------|:-----------------------------------------
 *  ALT_EMAC_GMAC_DBG_RWCSTS_E_INACT | 0x0   | MTL Rx Fifo Controller Non-Active Status
 *  ALT_EMAC_GMAC_DBG_RWCSTS_E_ACT   | 0x1   | MTL Rx Fifo Controller Active Status    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RWCSTS
 * 
 * MTL Rx Fifo Controller Non-Active Status
 */
#define ALT_EMAC_GMAC_DBG_RWCSTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RWCSTS
 * 
 * MTL Rx Fifo Controller Active Status
 */
#define ALT_EMAC_GMAC_DBG_RWCSTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_RWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_DBG_RWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RWCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_DBG_RWCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RWCSTS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : MTL Rx FIFO Read Controller State - rrcsts
 * 
 * This field gives the state of the Rx FIFO read Controller
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                        
 * :-------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_IDLE      | 0x0   | IDLE State                         
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMDATA | 0x1   | Reading Frame Data                 
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMSTAT | 0x2   | Reading Frame Status (or timestamp)
 *  ALT_EMAC_GMAC_DBG_RRCSTS_E_FLUSHFRDS | 0x3   | Flushing Frame Data and Status     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 * IDLE State
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_IDLE         0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 * Reading Frame Data
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMDATA    0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 * Reading Frame Status (or timestamp)
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_RDFRMSTAT    0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RRCSTS
 * 
 * Flushing Frame Data and Status
 */
#define ALT_EMAC_GMAC_DBG_RRCSTS_E_FLUSHFRDS    0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_RRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_SET_MSK    0x00000060
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_CLR_MSK    0xffffff9f
/* The reset value of the ALT_EMAC_GMAC_DBG_RRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RRCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_GET(value) (((value) & 0x00000060) >> 5)
/* Produces a ALT_EMAC_GMAC_DBG_RRCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RRCSTS_SET(value) (((value) << 5) & 0x00000060)

/*
 * Field : MTL Rx FIFO Fill-level Status - rxfsts
 * 
 * This field gives the status of the fill-level of the Rx FIFO.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                     
 * :----------------------------------------|:------|:-------------------------------------------------
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOEMPTY  | 0x0   | Rx FIFO Empty                                   
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOBELLVL | 0x1   | Rx FIFO fill-level below flow-control deactivate
 * :                                        |       | thres.                                          
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOABLVL  | 0x2   | Rx FIFO fill-level above flow-control activate  
 * :                                        |       | thres.                                          
 *  ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOFULL   | 0x3   | Rx FIFO Full                                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 * Rx FIFO Empty
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOEMPTY  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 * Rx FIFO fill-level below flow-control deactivate thres.
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOBELLVL 0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 * Rx FIFO fill-level above flow-control activate thres.
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOABLVL  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_RXFSTS
 * 
 * Rx FIFO Full
 */
#define ALT_EMAC_GMAC_DBG_RXFSTS_E_RXFIFOFULL   0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_RXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_SET_MSK    0x00000300
/* The mask used to clear the ALT_EMAC_GMAC_DBG_RXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_CLR_MSK    0xfffffcff
/* The reset value of the ALT_EMAC_GMAC_DBG_RXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_RXFSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_GET(value) (((value) & 0x00000300) >> 8)
/* Produces a ALT_EMAC_GMAC_DBG_RXFSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_RXFSTS_SET(value) (((value) << 8) & 0x00000300)

/*
 * Field : MAC GMII or MII Transmit Protocol Engine Status - tpests
 * 
 * When high, this bit indicates that the MAC GMII or MII transmit protocol engine
 * is actively transmitting data and is not in the IDLE state.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description               
 * :--------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_DBG_TPESTS_E_DISD | 0x0   | Idle State                
 *  ALT_EMAC_GMAC_DBG_TPESTS_E_END  | 0x1   | Actively Transmitting Data
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TPESTS
 * 
 * Idle State
 */
#define ALT_EMAC_GMAC_DBG_TPESTS_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TPESTS
 * 
 * Actively Transmitting Data
 */
#define ALT_EMAC_GMAC_DBG_TPESTS_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_TPESTS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TPESTS register field value. */
#define ALT_EMAC_GMAC_DBG_TPESTS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TPESTS register field. */
#define ALT_EMAC_GMAC_DBG_TPESTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TPESTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TPESTS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_DBG_TPESTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TPESTS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : MAC Transmit Frame Controller Status - tfcsts
 * 
 * This field indicates the state of the MAC Transmit Frame Controller block
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description               
 * :-----------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_IDLE    | 0x0   | Idle State                
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_WAITIFG | 0x1   | Waiting Prev. State or IFG
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_XTPAUSE | 0x2   | Generating Tx Pause       
 *  ALT_EMAC_GMAC_DBG_TFCSTS_E_XTINFRM | 0x3   | Tx Input Frame            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 * Idle State
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_IDLE     0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 * Waiting Prev. State or IFG
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_WAITIFG  0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 * Generating Tx Pause
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_XTPAUSE  0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TFCSTS
 * 
 * Tx Input Frame
 */
#define ALT_EMAC_GMAC_DBG_TFCSTS_E_XTINFRM  0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_TFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_SET_MSK    0x00060000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TFCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_CLR_MSK    0xfff9ffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TFCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TFCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_GET(value) (((value) & 0x00060000) >> 17)
/* Produces a ALT_EMAC_GMAC_DBG_TFCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TFCSTS_SET(value) (((value) << 17) & 0x00060000)

/*
 * Field : MAC transmitter in PAUSE - txpaused
 * 
 * When high, this bit indicates that the MAC transmitter is in the PAUSE condition
 * (in the full-duplex only mode) and hence does not schedule any frame for
 * transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                    
 * :---------------------------------|:------|:--------------------------------
 *  ALT_EMAC_GMAC_DBG_TXPAUSED_E_DIS | 0x0   | MAC Transmitter Pause Disabled 
 *  ALT_EMAC_GMAC_DBG_TXPAUSED_E_END | 0x1   | MAC Transmitter Pause Condition
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXPAUSED
 * 
 * MAC Transmitter Pause Disabled
 */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_E_DIS    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXPAUSED
 * 
 * MAC Transmitter Pause Condition
 */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TXPAUSED register field value. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TXPAUSED register field value. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TXPAUSED register field. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TXPAUSED field value from a register. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_DBG_TXPAUSED register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TXPAUSED_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : MTL Tx FIFO Read Controller Status - trcsts
 * 
 * This field indicates the state of the Tx FIFO Read Controller
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                     
 * :--------------------------------------|:------|:-------------------------------------------------
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_IDLE       | 0x0   | Idle State                                      
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_RDSTATE    | 0x1   | Read State (transferring data to the MAC        
 * :                                      |       | transmitter)                                    
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_WAITTXSTAT | 0x2   | Waiting for TxStatus from the MAC transmitter   
 *  ALT_EMAC_GMAC_DBG_TRCSTS_E_WRTXSTAT   | 0x3   | Writing the received TxStatus or flushing the Tx
 * :                                      |       | FIFO                                            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 * Idle State
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_IDLE         0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 * Read State (transferring data to the MAC transmitter)
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_RDSTATE      0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 * Waiting for TxStatus from the MAC transmitter
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_WAITTXSTAT   0x2
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TRCSTS
 * 
 * Writing the received TxStatus or flushing the Tx FIFO
 */
#define ALT_EMAC_GMAC_DBG_TRCSTS_E_WRTXSTAT     0x3

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_DBG_TRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_SET_MSK    0x00300000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TRCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_CLR_MSK    0xffcfffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TRCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TRCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_EMAC_GMAC_DBG_TRCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TRCSTS_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : MTL Tx FIFO Write Controller Active Status - twcsts
 * 
 * When high, this bit indicates that the MTL Tx FIFO Write Controller is active
 * and transferring data to the Tx FIFO.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                
 * :---------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_DBG_TWCSTS_E_INACT | 0x0   | Tx FIFO Write Ctrl Inactive
 *  ALT_EMAC_GMAC_DBG_TWCSTS_E_ACT   | 0x1   | Tx FIFO Write Ctrl Active  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TWCSTS
 * 
 * Tx FIFO Write Ctrl Inactive
 */
#define ALT_EMAC_GMAC_DBG_TWCSTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TWCSTS
 * 
 * Tx FIFO Write Ctrl Active
 */
#define ALT_EMAC_GMAC_DBG_TWCSTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TWCSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TWCSTS register field. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TWCSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_DBG_TWCSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TWCSTS_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : MTL Tx FIFO Not Empty Status - txfsts
 * 
 * When high, this bit indicates that the MTL Tx FIFO is not empty and some data is
 * left for transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description          
 * :---------------------------------|:------|:----------------------
 *  ALT_EMAC_GMAC_DBG_TXFSTS_E_INACT | 0x0   | MTL Tx FIFO Empty    
 *  ALT_EMAC_GMAC_DBG_TXFSTS_E_ACT   | 0x1   | MTL Tx FIFO Not Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXFSTS
 * 
 * MTL Tx FIFO Empty
 */
#define ALT_EMAC_GMAC_DBG_TXFSTS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXFSTS
 * 
 * MTL Tx FIFO Not Empty
 */
#define ALT_EMAC_GMAC_DBG_TXFSTS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TXFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TXFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TXFSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_DBG_TXFSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TXFSTS_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : MTL TxStatus FIFO Full Status - txstsfsts
 * 
 * When high, this bit indicates that the MTL TxStatus FIFO is full. Therefore, the
 * MTL cannot accept any more frames for transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                      
 * :------------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_INACT | 0x0   | MTL TxStatus FIFO Not Full Status
 *  ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_ACT   | 0x1   | MTL TxStatus FIFO Full Status    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXSTSFSTS
 * 
 * MTL TxStatus FIFO Not Full Status
 */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_DBG_TXSTSFSTS
 * 
 * MTL TxStatus FIFO Full Status
 */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field value. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_DBG_TXSTSFSTS register field. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_DBG_TXSTSFSTS field value from a register. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_DBG_TXSTSFSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_DBG_TXSTSFSTS_SET(value) (((value) << 25) & 0x02000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_DBG.
 */
struct ALT_EMAC_GMAC_DBG_s
{
    const uint32_t  rpests    :  1;  /* MAC GMII or MII Receive Protocol Engine Status */
    const uint32_t  rfcfcsts  :  2;  /* MAC Receive Frame Controller FIFO Status */
    uint32_t                  :  1;  /* *UNDEFINED* */
    const uint32_t  rwcsts    :  1;  /* MTL Rx FIFO Write Controller Active Status */
    const uint32_t  rrcsts    :  2;  /* MTL Rx FIFO Read Controller State */
    uint32_t                  :  1;  /* *UNDEFINED* */
    const uint32_t  rxfsts    :  2;  /* MTL Rx FIFO Fill-level Status */
    uint32_t                  :  6;  /* *UNDEFINED* */
    const uint32_t  tpests    :  1;  /* MAC GMII or MII Transmit Protocol Engine Status */
    const uint32_t  tfcsts    :  2;  /* MAC Transmit Frame Controller Status */
    const uint32_t  txpaused  :  1;  /* MAC transmitter in PAUSE */
    const uint32_t  trcsts    :  2;  /* MTL Tx FIFO Read Controller Status */
    const uint32_t  twcsts    :  1;  /* MTL Tx FIFO Write Controller Active Status */
    uint32_t                  :  1;  /* *UNDEFINED* */
    const uint32_t  txfsts    :  1;  /* MTL Tx FIFO Not Empty Status */
    const uint32_t  txstsfsts :  1;  /* MTL TxStatus FIFO Full Status */
    uint32_t                  :  6;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_DBG. */
typedef volatile struct ALT_EMAC_GMAC_DBG_s  ALT_EMAC_GMAC_DBG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_DBG register from the beginning of the component. */
#define ALT_EMAC_GMAC_DBG_OFST        0x24
/* The address of the ALT_EMAC_GMAC_DBG register. */
#define ALT_EMAC_GMAC_DBG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_DBG_OFST))

/*
 * Register : Register 12 (LPI Control and Status Register) - LPI_Control_Status
 * 
 * The LPI Control and Status Register controls the LPI functions and provides the
 * LPI interrupt status. The status bits are cleared when this register is read.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description           
 * :--------|:-------|:------|:-----------------------
 *  [0]     | R      | 0x0   | Transmit LPI Entry    
 *  [1]     | R      | 0x0   | Transmit LPI Exit     
 *  [2]     | R      | 0x0   | Receive LPI Entry     
 *  [3]     | R      | 0x0   | Receive LPI Exit      
 *  [7:4]   | ???    | 0x0   | *UNDEFINED*           
 *  [8]     | R      | 0x0   | Transmit LPI State    
 *  [9]     | R      | 0x0   | Receive LPI State     
 *  [15:10] | ???    | 0x0   | *UNDEFINED*           
 *  [16]    | RW     | 0x0   | LPI Enable            
 *  [17]    | RW     | 0x0   | PHY Link Status       
 *  [18]    | RW     | 0x0   | PHY Link Status Enable
 *  [19]    | RW     | 0x0   | LPI TX Automate       
 *  [31:20] | ???    | 0x0   | *UNDEFINED*           
 * 
 */
/*
 * Field : Transmit LPI Entry - tlpien
 * 
 * When set, this bit indicates that the MAC Transmitter has entered the LPI state
 * because of the setting of the LPIEN bit. This bit is cleared by a read into this
 * register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                      
 * :------------------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_INACT | 0x0   | MAC Transmitter Not in LPI State 
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_ACT   | 0x1   | MAC Transmitter Entered LPI State
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN
 * 
 * MAC Transmitter Not in LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN
 * 
 * MAC Transmitter Entered LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Transmit LPI Exit - tlpiex
 * 
 * When set, this bit indicates that the MAC transmitter has exited the LPI state
 * after the user has cleared the LPIEN bit and the LPI TW Timer has expired. This
 * bit is cleared by a read into this register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                     
 * :------------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_INACT | 0x0   | MAC Transmitter Non LPI State   
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_ACT   | 0x1   | MAC Transmitter Exited LPI State
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX
 * 
 * MAC Transmitter Non LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX
 * 
 * MAC Transmitter Exited LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIEX_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Receive LPI Entry - rlpien
 * 
 * When set, this bit indicates that the MAC Receiver has received an LPI pattern
 * and entered the LPI state. This bit is cleared by a read into this register.
 * 
 * Note:
 * 
 * This bit may not get set if the MAC stops receiving the LPI pattern for a very
 * short duration, such as, less than 3 clock cycles of l3_sp_clk.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                  
 * :------------------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_INACT | 0x0   | MAC Receiver Not In LPI State
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_ACT   | 0x1   | MAC Receiver In LPI State    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN
 * 
 * MAC Receiver Not In LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN
 * 
 * MAC Receiver In LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEN_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Receive LPI Exit - rlpiex
 * 
 * When set, this bit indicates that the MAC Receiver has stopped receiving the LPI
 * pattern on the GMII or MII interface, exited the LPI state, and resumed the
 * normal reception. This bit is cleared by a read into this register.
 * 
 * Note:
 * 
 * This bit may not get set if the MAC stops receiving the LPI pattern for a very
 * short duration, such as, less than 3 clock cycles of l3_sp_clk.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                          
 * :------------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_INACT | 0x0   | MAC RX receiving LPI Patterns        
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_ACT   | 0x1   | MAC RX Stopped receiving LPI Patterns
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX
 * 
 * MAC RX receiving LPI Patterns
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX
 * 
 * MAC RX Stopped receiving LPI Patterns
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIEX_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Transmit LPI State - tlpist
 * 
 * When set, this bit indicates that the MAC is transmitting the LPI pattern on the
 * GMII or MII interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                 
 * :------------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_INACT | 0x0   | MAC Transmitting LPI Pattern
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_ACT   | 0x1   | MAC Transmitting LPI Pattern
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST
 * 
 * MAC Transmitting LPI Pattern
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST
 * 
 * MAC Transmitting LPI Pattern
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_TLPIST_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Receive LPI State - rlpist
 * 
 * When set, this bit indicates that the MAC is receiving the LPI pattern on the
 * GMII or MII interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                     
 * :------------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_INACT | 0x0   | MAC is not receiving LPI Pattern
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_ACT   | 0x1   | MAC receiving LPI Pattern       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST
 * 
 * MAC is not receiving LPI Pattern
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST
 * 
 * MAC receiving LPI Pattern
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_RLPIST_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : LPI Enable - lpien
 * 
 * When set, this bit instructs the MAC Transmitter to enter the LPI state. When
 * reset, this bit instructs the MAC to exit the LPI state and resume normal
 * transmission.
 * 
 * This bit is cleared when the LPITXA bit is set and the MAC exits the LPI state
 * because of the arrival of a new packet for transmission.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                     
 * :----------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_DISD | 0x0   | MAC Transmitter exit LPI State  
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_END  | 0x1   | MAC Transmitter enters LPI State
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN
 * 
 * MAC Transmitter exit LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN
 * 
 * MAC Transmitter enters LPI State
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPIEN_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : PHY Link Status - pls
 * 
 * This bit indicates the link status of the PHY. The MAC Transmitter asserts the
 * LPI pattern only when the link status is up (okay) at least for the time
 * indicated by the LPI LS TIMER.
 * 
 * When set, the link is considered to be okay (up) and when reset, the link is
 * considered to be down.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description   
 * :--------------------------------------|:------|:---------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_DISD | 0x0   | Link Down     
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_END  | 0x1   | Link Up (okay)
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLS
 * 
 * Link Down
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLS
 * 
 * Link Up (okay)
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_PLS field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_PLS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : PHY Link Status Enable - plsen
 * 
 * This bit enables the link status received on the RGMII receive paths to be used
 * for activating the LPI LS TIMER.
 * 
 * When set, the MAC uses the link-status bits of Register 54 (SGMII/RGMII/SMII
 * Status Register) and Bit 17 (PLS) for the LPI LS Timer trigger. When cleared,
 * the MAC ignores the link-status bits of Register 54 and takes only the PLS bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_DISD | 0x0   | MAC Ignores Link Status Bits
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_END  | 0x1   | MAC Uses Link Status Bits   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN
 * 
 * MAC Ignores Link Status Bits
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN
 * 
 * MAC Uses Link Status Bits
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_PLSEN_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : LPI TX Automate - lpitxa
 * 
 * This bit controls the behavior of the MAC when it is entering or coming out of
 * the LPI mode on the transmit side. This bit is not functional in the GMAC-CORE
 * configuration in which the Tx clock gating is done during the LPI mode.
 * 
 * If the LPITXA and LPIEN bits are set to 1, the MAC enters the LPI mode only
 * after all outstanding frames (in the core) and pending frames (in the
 * application interface) have been transmitted. The MAC comes out of the LPI mode
 * when the application sends any frame for transmission or the application issues
 * a TX FIFO Flush command. In addition, the MAC automatically clears the LPIEN bit
 * when it exits the LPI state. If TX FIFO Flush is set, in Bit 20 of Register 6
 * (Operation Mode Register), when the MAC is in the LPI mode, the MAC exits the
 * LPI mode.
 * 
 * When this bit is 0, the LPIEN bit directly controls behavior of the MAC when it
 * is entering or coming out of the LPI mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description             
 * :-----------------------------------------|:------|:-------------------------
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_DISD | 0x0   | LPI TX Automate Disabled
 *  ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_END  | 0x1   | LPI TX Automate Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA
 * 
 * LPI TX Automate Disabled
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA
 * 
 * LPI TX Automate Enabled
 */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field value. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA field value from a register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_LPITXA_SET(value) (((value) << 19) & 0x00080000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_LPI_CTL_STAT.
 */
struct ALT_EMAC_GMAC_LPI_CTL_STAT_s
{
    const uint32_t  tlpien :  1;  /* Transmit LPI Entry */
    const uint32_t  tlpiex :  1;  /* Transmit LPI Exit */
    const uint32_t  rlpien :  1;  /* Receive LPI Entry */
    const uint32_t  rlpiex :  1;  /* Receive LPI Exit */
    uint32_t               :  4;  /* *UNDEFINED* */
    const uint32_t  tlpist :  1;  /* Transmit LPI State */
    const uint32_t  rlpist :  1;  /* Receive LPI State */
    uint32_t               :  6;  /* *UNDEFINED* */
    uint32_t        lpien  :  1;  /* LPI Enable */
    uint32_t        pls    :  1;  /* PHY Link Status */
    uint32_t        plsen  :  1;  /* PHY Link Status Enable */
    uint32_t        lpitxa :  1;  /* LPI TX Automate */
    uint32_t               : 12;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_LPI_CTL_STAT. */
typedef volatile struct ALT_EMAC_GMAC_LPI_CTL_STAT_s  ALT_EMAC_GMAC_LPI_CTL_STAT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_LPI_CTL_STAT register from the beginning of the component. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_OFST        0x30
/* The address of the ALT_EMAC_GMAC_LPI_CTL_STAT register. */
#define ALT_EMAC_GMAC_LPI_CTL_STAT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_LPI_CTL_STAT_OFST))

/*
 * Register : Register 13 (LPI Timers Control Register) - LPI_Timers_Control
 * 
 * The LPI Timers Control register controls the timeout values in the LPI states.
 * It specifies the time for which the MAC transmits the LPI pattern and also the
 * time for which the MAC waits before resuming the normal transmission.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description 
 * :--------|:-------|:------|:-------------
 *  [15:0]  | RW     | 0x0   | LPI TW Timer
 *  [25:16] | RW     | 0x3e8 | LPI LS Timer
 *  [31:26] | ???    | 0x0   | *UNDEFINED* 
 * 
 */
/*
 * Field : LPI TW Timer - twt
 * 
 * This field specifies the minimum time (in microseconds) for which the MAC waits
 * after it stops transmitting the LPI pattern to the PHY and before it resumes the
 * normal transmission. The TLPIEX status bit is set after the expiry of this
 * timer.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT field value from a register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_TWT_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : LPI LS Timer - lst
 * 
 * This field specifies the minimum time (in milliseconds) for which the link
 * status from the PHY should be up (OKAY) before the LPI pattern can be
 * transmitted to the PHY. The MAC does not transmit the LPI pattern even when the
 * LPIEN bit is set unless the LPI LS Timer reaches the programmed terminal count.
 * The default value of the LPI LS Timer is 1000 (1 sec) as defined in the IEEE
 * standard.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_WIDTH      10
/* The mask used to set the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_SET_MSK    0x03ff0000
/* The mask used to clear the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field value. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_CLR_MSK    0xfc00ffff
/* The reset value of the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_RESET      0x3e8
/* Extracts the ALT_EMAC_GMAC_LPI_TMRS_CTL_LST field value from a register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_GET(value) (((value) & 0x03ff0000) >> 16)
/* Produces a ALT_EMAC_GMAC_LPI_TMRS_CTL_LST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_LST_SET(value) (((value) << 16) & 0x03ff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_LPI_TMRS_CTL.
 */
struct ALT_EMAC_GMAC_LPI_TMRS_CTL_s
{
    uint32_t  twt : 16;  /* LPI TW Timer */
    uint32_t  lst : 10;  /* LPI LS Timer */
    uint32_t      :  6;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_LPI_TMRS_CTL. */
typedef volatile struct ALT_EMAC_GMAC_LPI_TMRS_CTL_s  ALT_EMAC_GMAC_LPI_TMRS_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_LPI_TMRS_CTL register from the beginning of the component. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_OFST        0x34
/* The address of the ALT_EMAC_GMAC_LPI_TMRS_CTL register. */
#define ALT_EMAC_GMAC_LPI_TMRS_CTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_LPI_TMRS_CTL_OFST))

/*
 * Register : Register 14 (Interrupt Register) - Interrupt_Status
 * 
 * The Interrupt Status register identifies the events in the MAC that can generate
 * interrupt. All interrupt events are generated only when the corresponding
 * optional feature is enabled.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                  
 * :--------|:-------|:------|:----------------------------------------------
 *  [0]     | R      | 0x0   | RGMII or SMII Interrupt Status               
 *  [1]     | R      | 0x0   | PCS Link Status Changed                      
 *  [2]     | R      | 0x0   | PCS Auto-Negotiation Complete                
 *  [3]     | ???    | 0x0   | *UNDEFINED*                                  
 *  [4]     | R      | 0x0   | MMC Interrupt Status                         
 *  [5]     | R      | 0x0   | MMC Receive Interrupt Status                 
 *  [6]     | R      | 0x0   | MMC Transmit Interrupt Status                
 *  [7]     | R      | 0x0   | MMC Receive Checksum Offload Interrupt Status
 *  [8]     | ???    | 0x0   | *UNDEFINED*                                  
 *  [9]     | R      | 0x0   | Timestamp Interrupt Status                   
 *  [10]    | R      | 0x0   | LPI Interrupt Status                         
 *  [31:11] | ???    | 0x0   | *UNDEFINED*                                  
 * 
 */
/*
 * Field : RGMII or SMII Interrupt Status - rgsmiiis
 * 
 * This bit is set because of any change in value of the Link Status of RGMII or
 * SMII interface (Bit 3 in Register 54 (SGMII/RGMII/SMII Status Register)). This
 * bit is cleared when you perform a read operation on the SGMII/RGMII/SMII Status
 * Register.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description   
 * :----------------------------------------|:------|:---------------
 *  ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_INACT | 0x0   | Link No Change
 *  ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_ACT   | 0x1   | Link Change   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_RGSMIIIS
 * 
 * Link No Change
 */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_RGSMIIIS
 * 
 * Link Change
 */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_RGSMIIIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_INT_STAT_RGSMIIIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_RGSMIIIS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : PCS Link Status Changed - pcslchgis
 * 
 * This bit is set because of any change in Link Status in the TBI, RTBI, or SGMII
 * PHY interface (Bit 2 in Register 49 (AN Status Register)). This bit is cleared
 * when you perform a read operation on the AN Status register.
 * 
 * This bit is valid only when you select the SGMII PHY interface during operation.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSLCHGIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : PCS Auto-Negotiation Complete - pcsancis
 * 
 * This bit is set when the Auto-negotiation is completed in the TBI, RTBI, or
 * SGMII PHY interface (Bit 5 in Register 49 (AN Status Register)). This bit is
 * cleared when you perform a read operation to the AN Status register.
 * 
 * This bit is valid only when you select the SGMII PHY interface during operation.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_PCSANCIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_INT_STAT_PCSANCIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_PCSANCIS_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : MMC Interrupt Status - mmcis
 * 
 * This bit is set high when any of the Bits [7:5] is set high and cleared only
 * when all of these bits are low.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                  
 * :-------------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCIS_E_INACT | 0x0   | MMC Interrupt Status Disabled
 *  ALT_EMAC_GMAC_INT_STAT_MMCIS_E_ACT   | 0x1   | MMC Interrupt Status Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCIS
 * 
 * MMC Interrupt Status Disabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCIS
 * 
 * MMC Interrupt Status Enabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCIS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : MMC Receive Interrupt Status - mmcrxis
 * 
 * This bit is set high when an interrupt is generated in the MMC Receive Interrupt
 * Register. This bit is cleared when all the bits in this interrupt register are
 * cleared.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                          
 * :--------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_DISD | 0x0   | MMC Receive Interrupt Status Disabled
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_END  | 0x1   | MMC Receive Interrupt Status Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIS
 * 
 * MMC Receive Interrupt Status Disabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIS
 * 
 * MMC Receive Interrupt Status Enabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCRXIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCRXIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : MMC Transmit Interrupt Status - mmctxis
 * 
 * This bit is set high when an interrupt is generated in the MMC Transmit
 * Interrupt Register. This bit is cleared when all the bits in this interrupt
 * register are cleared.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                           
 * :---------------------------------------|:------|:---------------------------------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_INACT | 0x0   | MMC Transmit Interrupt Status Disabled
 *  ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_ACT   | 0x1   | MMC Transmit Interrupt Status Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCTXIS
 * 
 * MMC Transmit Interrupt Status Disabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCTXIS
 * 
 * MMC Transmit Interrupt Status Enabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCTXIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCTXIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCTXIS_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : MMC Receive Checksum Offload Interrupt Status - mmcrxipis
 * 
 * This bit is set high when an interrupt is generated in the MMC Receive Checksum
 * Offload Interrupt Register. This bit is cleared when all the bits in this
 * interrupt register are cleared.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                  
 * :-----------------------------------------|:------|:----------------------------------------------
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_INACT | 0x0   | MMC Receive Checksum Offload Interrupt Status
 * :                                         |       | Disabled                                     
 *  ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_ACT   | 0x1   | MMC Receive Checksum Offload Interrupt Status
 * :                                         |       | Enabled                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS
 * 
 * MMC Receive Checksum Offload Interrupt Status Disabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS
 * 
 * MMC Receive Checksum Offload Interrupt Status Enabled
 */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_MMCRXIPIS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Timestamp Interrupt Status - tsis
 * 
 * This bit is set when any of the following conditions is true:
 * 
 * * The system time value equals or exceeds the value specified in the Target Time
 *   High and Low registers.
 * 
 * * There is an overflow in the seconds register.
 * 
 * * The Auxiliary snapshot trigger is asserted.
 * 
 * This bit is cleared on reading Bit 0 of the Register 458 (Timestamp Status
 * Register).
 * 
 * When set, this bit indicates that the system time value is equal to or exceeds
 * the value specified in the Target Time registers. In this mode, this bit is
 * cleared after the completion of the read of this bit. In all other modes, this
 * bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                        
 * :------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_INT_STAT_TSIS_E_INACT | 0x0   | Timestamp Interrupt Status Disabled
 *  ALT_EMAC_GMAC_INT_STAT_TSIS_E_ACT   | 0x1   | Timestamp Interrupt Status Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_TSIS
 * 
 * Timestamp Interrupt Status Disabled
 */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_TSIS
 * 
 * Timestamp Interrupt Status Enabled
 */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_TSIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_TSIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_TSIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_TSIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_INT_STAT_TSIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_TSIS_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : LPI Interrupt Status - lpiis
 * 
 * This bit is set for any LPI state entry or exit in the MAC Transmitter or
 * Receiver. This bit is cleared on reading Bit 0 of Register 12 (LPI Control and
 * Status Register). In all other modes, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                  
 * :-------------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_INT_STAT_LPIIS_E_INACT | 0x0   | LPI Interrupt Status Disabled
 *  ALT_EMAC_GMAC_INT_STAT_LPIIS_E_ACT   | 0x1   | LPI Interrupt Status Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_LPIIS
 * 
 * LPI Interrupt Status Disabled
 */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_STAT_LPIIS
 * 
 * LPI Interrupt Status Enabled
 */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_STAT_LPIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_INT_STAT_LPIIS register field value. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_INT_STAT_LPIIS register field. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_STAT_LPIIS field value from a register. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_INT_STAT_LPIIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_STAT_LPIIS_SET(value) (((value) << 10) & 0x00000400)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_INT_STAT.
 */
struct ALT_EMAC_GMAC_INT_STAT_s
{
    const uint32_t  rgsmiiis  :  1;  /* RGMII or SMII Interrupt Status */
    const uint32_t  pcslchgis :  1;  /* PCS Link Status Changed */
    const uint32_t  pcsancis  :  1;  /* PCS Auto-Negotiation Complete */
    uint32_t                  :  1;  /* *UNDEFINED* */
    const uint32_t  mmcis     :  1;  /* MMC Interrupt Status */
    const uint32_t  mmcrxis   :  1;  /* MMC Receive Interrupt Status */
    const uint32_t  mmctxis   :  1;  /* MMC Transmit Interrupt Status */
    const uint32_t  mmcrxipis :  1;  /* MMC Receive Checksum Offload Interrupt Status */
    uint32_t                  :  1;  /* *UNDEFINED* */
    const uint32_t  tsis      :  1;  /* Timestamp Interrupt Status */
    const uint32_t  lpiis     :  1;  /* LPI Interrupt Status */
    uint32_t                  : 21;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_INT_STAT. */
typedef volatile struct ALT_EMAC_GMAC_INT_STAT_s  ALT_EMAC_GMAC_INT_STAT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_INT_STAT register from the beginning of the component. */
#define ALT_EMAC_GMAC_INT_STAT_OFST        0x38
/* The address of the ALT_EMAC_GMAC_INT_STAT register. */
#define ALT_EMAC_GMAC_INT_STAT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_INT_STAT_OFST))

/*
 * Register : Register 15 (Interrupt Mask Register) - Interrupt_Mask
 * 
 * The Interrupt Mask Register bits enable you to mask the interrupt signal because
 * of the corresponding event in the Interrupt Status Register. The interrupt
 * signal is sbd_intr_o.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                     
 * :--------|:-------|:------|:---------------------------------
 *  [0]     | RW     | 0x0   | RGMII or SMII Interrupt Mask    
 *  [1]     | R      | 0x0   | PCS Link Status Interrupt Mask  
 *  [2]     | R      | 0x0   | PCS AN Completion Interrupt Mask
 *  [8:3]   | ???    | 0x0   | *UNDEFINED*                     
 *  [9]     | RW     | 0x0   | Timestamp Interrupt Mask        
 *  [10]    | RW     | 0x0   | LPI Interrupt Mask              
 *  [31:11] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : RGMII or SMII Interrupt Mask - rgsmiiim
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of the RGMII or SMII Interrupt Status bit in Register 14 (Interrupt
 * Status Register).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                         
 * :--------------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_DISD | 0x0   | RGMII or SMII Interrupt Mask Disable
 *  ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_END  | 0x1   | RGMII or SMII Interrupt Mask Enable 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_RGSMIIIM
 * 
 * RGMII or SMII Interrupt Mask Disable
 */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_RGSMIIIM
 * 
 * RGMII or SMII Interrupt Mask Enable
 */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_RGSMIIIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_INT_MSK_RGSMIIIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_RGSMIIIM_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : PCS Link Status Interrupt Mask - pcslchgim
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of the PCS Link-status changed bit in Register 14 (Interrupt Status
 * Register).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSLCHGIM_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : PCS AN Completion Interrupt Mask - pcsancim
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of PCS Auto-negotiation complete bit in Register 14 (Interrupt Status
 * Register).
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_PCSANCIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_INT_MSK_PCSANCIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_PCSANCIM_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Timestamp Interrupt Mask - tsim
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of Timestamp Interrupt Status bit in Register 14 (Interrupt Status
 * Register).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                      
 * :----------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_INT_MSK_TSIM_E_DISD | 0x0   | Timestamp Interrupt Mask Disabled
 *  ALT_EMAC_GMAC_INT_MSK_TSIM_E_END  | 0x1   | Timestamp Interrupt Mask Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_TSIM
 * 
 * Timestamp Interrupt Mask Disabled
 */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_TSIM
 * 
 * Timestamp Interrupt Mask Enabled
 */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_TSIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_TSIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_TSIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_TSIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_INT_MSK_TSIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_TSIM_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : LPI Interrupt Mask - lpiim
 * 
 * When set, this bit disables the assertion of the interrupt signal because of the
 * setting of the LPI Interrupt Status bit in Register 14 (Interrupt Status
 * Register).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                
 * :-----------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_INT_MSK_LPIIM_E_DISD | 0x0   | LPI Interrupt Mask Disabled
 *  ALT_EMAC_GMAC_INT_MSK_LPIIM_E_END  | 0x1   | LPI Interrupt Mask Enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_LPIIM
 * 
 * LPI Interrupt Mask Disabled
 */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_INT_MSK_LPIIM
 * 
 * LPI Interrupt Mask Enabled
 */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_INT_MSK_LPIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_INT_MSK_LPIIM register field value. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_INT_MSK_LPIIM register field. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_INT_MSK_LPIIM field value from a register. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_INT_MSK_LPIIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_INT_MSK_LPIIM_SET(value) (((value) << 10) & 0x00000400)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_INT_MSK.
 */
struct ALT_EMAC_GMAC_INT_MSK_s
{
    uint32_t        rgsmiiim  :  1;  /* RGMII or SMII Interrupt Mask */
    const uint32_t  pcslchgim :  1;  /* PCS Link Status Interrupt Mask */
    const uint32_t  pcsancim  :  1;  /* PCS AN Completion Interrupt Mask */
    uint32_t                  :  6;  /* *UNDEFINED* */
    uint32_t        tsim      :  1;  /* Timestamp Interrupt Mask */
    uint32_t        lpiim     :  1;  /* LPI Interrupt Mask */
    uint32_t                  : 21;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_INT_MSK. */
typedef volatile struct ALT_EMAC_GMAC_INT_MSK_s  ALT_EMAC_GMAC_INT_MSK_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_INT_MSK register from the beginning of the component. */
#define ALT_EMAC_GMAC_INT_MSK_OFST        0x3c
/* The address of the ALT_EMAC_GMAC_INT_MSK register. */
#define ALT_EMAC_GMAC_INT_MSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_INT_MSK_OFST))

/*
 * Register : Register 16 (MAC Address0 High Register) - MAC_Address0_High
 * 
 * The MAC Address0 High register holds the upper 16 bits of the first 6-byte MAC
 * address of the station. The first DA byte that is received on the (G)MII
 * interface corresponds to the LS byte (Bits [7:0]) of the MAC Address Low
 * register. For example, if 0x112233445566 is received (0x11 in lane 0 of the
 * first column) on the (G)MII as the destination address, then the MacAddress0
 * Register [47:0] is compared with 0x665544332211.
 * 
 * Because the MAC address registers are double-synchronized to the (G)MII clock
 * domains, then the synchronization is triggered only when Bits[31:24] (in little-
 * endian mode) or Bits[7:0] (in big-endian mode) of the MAC Address0 Low Register
 * are written. For proper synchronization updates, the consecutive writes to this
 * Address Low Register should be performed after at least four clock cycles in the
 * destination clock domain.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address0 [47:32]
 *  [30:16] | ???    | 0x0    | *UNDEFINED*         
 *  [31]    | R      | 0x1    | Address Enable      
 * 
 */
/*
 * Field : MAC Address0 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the first 6-byte MAC address.
 * The MAC uses this field for filtering the received frames and inserting the MAC
 * address in the Transmit Flow Control (PAUSE) Frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Address Enable - ae
 * 
 * This bit is always set to 1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_RESET      0x1
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR0_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR0_HIGH_s
{
    uint32_t        addrhi : 16;  /* MAC Address0 [47:32] */
    uint32_t               : 15;  /* *UNDEFINED* */
    const uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR0_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR0_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR0_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_OFST        0x40
/* The address of the ALT_EMAC_GMAC_MAC_ADDR0_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR0_HIGH_OFST))

/*
 * Register : Register 17 (MAC Address0 Low Register) - MAC_Address0_Low
 * 
 * The MAC Address0 Low register holds the lower 32 bits of the first 6-byte MAC
 * address of the station.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address0 [31:0]
 * 
 */
/*
 * Field : MAC Address0 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the first 6-byte MAC address. This is
 * used by the MAC for filtering the received frames and inserting the MAC address
 * in the Transmit Flow Control (PAUSE) Frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR0_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR0_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address0 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR0_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR0_LOW_s  ALT_EMAC_GMAC_MAC_ADDR0_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR0_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_OFST        0x44
/* The address of the ALT_EMAC_GMAC_MAC_ADDR0_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR0_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR0_LOW_OFST))

/*
 * Register : Register 18 (MAC Address1 High Register) - MAC_Address1_High
 * 
 * The MAC Address1 High register holds the upper 16 bits of the 2nd 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address1 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address1 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address1 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 2nd 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address1 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address1[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address1[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 2nd MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR1_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR1_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address1 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR1_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR1_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR1_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_OFST        0x48
/* The address of the ALT_EMAC_GMAC_MAC_ADDR1_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR1_HIGH_OFST))

/*
 * Register : Register 19 (MAC Address1 Low Register) - MAC_Address1_Low
 * 
 * The MAC Address1 Low register holds the lower 32 bits of the 2nd 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address1 [31:0]
 * 
 */
/*
 * Field : MAC Address1 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 2nd 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR1_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR1_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address1 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR1_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR1_LOW_s  ALT_EMAC_GMAC_MAC_ADDR1_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR1_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_OFST        0x4c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR1_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR1_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR1_LOW_OFST))

/*
 * Register : Register 20 (MAC Address2 High Register) - MAC_Address2_High
 * 
 * The MAC Address2 High register holds the upper 16 bits of the 3rd 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address2 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address2 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address2 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 3rd 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address2 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address2[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address2[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 3rd MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR2_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR2_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address2 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR2_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR2_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR2_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_OFST        0x50
/* The address of the ALT_EMAC_GMAC_MAC_ADDR2_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR2_HIGH_OFST))

/*
 * Register : Register 21 (MAC Address2 Low Register) - MAC_Address2_Low
 * 
 * The MAC Address2 Low register holds the lower 32 bits of the 3rd 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address2 [31:0]
 * 
 */
/*
 * Field : MAC Address2 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 3rd 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR2_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR2_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address2 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR2_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR2_LOW_s  ALT_EMAC_GMAC_MAC_ADDR2_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR2_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_OFST        0x54
/* The address of the ALT_EMAC_GMAC_MAC_ADDR2_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR2_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR2_LOW_OFST))

/*
 * Register : Register 22 (MAC Address3 High Register) - MAC_Address3_High
 * 
 * The MAC Address3 High register holds the upper 16 bits of the 4th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address3 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address3 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address3 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 4th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address3 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address3[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address3[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 4th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR3_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR3_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address3 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR3_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR3_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR3_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_OFST        0x58
/* The address of the ALT_EMAC_GMAC_MAC_ADDR3_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR3_HIGH_OFST))

/*
 * Register : Register 23 (MAC Address3 Low Register) - MAC_Address3_Low
 * 
 * The MAC Address3 Low register holds the lower 32 bits of the 4th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address3 [31:0]
 * 
 */
/*
 * Field : MAC Address3 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 4th 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR3_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR3_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address3 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR3_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR3_LOW_s  ALT_EMAC_GMAC_MAC_ADDR3_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR3_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_OFST        0x5c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR3_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR3_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR3_LOW_OFST))

/*
 * Register : Register 24 (MAC Address4 High Register) - MAC_Address4_High
 * 
 * The MAC Address4 High register holds the upper 16 bits of the 5th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address4 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address4 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address4 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 5th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address4 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address4[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address4[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 5th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR4_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR4_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address4 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR4_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR4_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR4_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_OFST        0x60
/* The address of the ALT_EMAC_GMAC_MAC_ADDR4_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR4_HIGH_OFST))

/*
 * Register : Register 25 (MAC Address4 Low Register) - MAC_Address4_Low
 * 
 * The MAC Address4 Low register holds the lower 32 bits of the 5th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address4 [31:0]
 * 
 */
/*
 * Field : MAC Address4 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 5th 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR4_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR4_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address4 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR4_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR4_LOW_s  ALT_EMAC_GMAC_MAC_ADDR4_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR4_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_OFST        0x64
/* The address of the ALT_EMAC_GMAC_MAC_ADDR4_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR4_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR4_LOW_OFST))

/*
 * Register : Register 26 (MAC Address5 High Register) - MAC_Address5_High
 * 
 * The MAC Address5 High register holds the upper 16 bits of the 6th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address5 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address5 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address5 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 6th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address5 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address5[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address5[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 6th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR5_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR5_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address5 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR5_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR5_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR5_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_OFST        0x68
/* The address of the ALT_EMAC_GMAC_MAC_ADDR5_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR5_HIGH_OFST))

/*
 * Register : Register 27 (MAC Address5 Low Register) - MAC_Address5_Low
 * 
 * The MAC Address5 Low register holds the lower 32 bits of the 6th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address5 [31:0]
 * 
 */
/*
 * Field : MAC Address5 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 6th 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR5_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR5_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address5 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR5_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR5_LOW_s  ALT_EMAC_GMAC_MAC_ADDR5_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR5_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_OFST        0x6c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR5_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR5_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR5_LOW_OFST))

/*
 * Register : Register 28 (MAC Address6 High Register) - MAC_Address6_High
 * 
 * The MAC Address6 High register holds the upper 16 bits of the 7th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address6 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address6 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address6 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 7th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address6 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address6[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address6[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 7th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR6_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR6_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address6 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR6_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR6_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR6_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_OFST        0x70
/* The address of the ALT_EMAC_GMAC_MAC_ADDR6_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR6_HIGH_OFST))

/*
 * Register : Register 29 (MAC Address6 Low Register) - MAC_Address6_Low
 * 
 * The MAC Address6 Low register holds the lower 32 bits of the 7th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address6 [31:0]
 * 
 */
/*
 * Field : MAC Address6 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 7th 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR6_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR6_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address6 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR6_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR6_LOW_s  ALT_EMAC_GMAC_MAC_ADDR6_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR6_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_OFST        0x74
/* The address of the ALT_EMAC_GMAC_MAC_ADDR6_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR6_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR6_LOW_OFST))

/*
 * Register : Register 30 (MAC Address7 High Register) - MAC_Address7_High
 * 
 * The MAC Address7 High register holds the upper 16 bits of the 8th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address7 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address7 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address7 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 8th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address7 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address7[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address7[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 8th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR7_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR7_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address7 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR7_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR7_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR7_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_OFST        0x78
/* The address of the ALT_EMAC_GMAC_MAC_ADDR7_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR7_HIGH_OFST))

/*
 * Register : Register 31 (MAC Address7 Low Register) - MAC_Address7_Low
 * 
 * The MAC Address7 Low register holds the lower 32 bits of the 8th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address7 [31:0]
 * 
 */
/*
 * Field : MAC Address7 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 8th 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR7_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR7_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address7 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR7_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR7_LOW_s  ALT_EMAC_GMAC_MAC_ADDR7_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR7_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_OFST        0x7c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR7_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR7_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR7_LOW_OFST))

/*
 * Register : Register 32 (MAC Address8 High Register) - MAC_Address8_High
 * 
 * The MAC Address8 High register holds the upper 16 bits of the 9th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address8 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address8 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address8 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 9th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address8 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address8[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address8[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 9th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR8_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR8_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address8 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR8_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR8_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR8_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_OFST        0x80
/* The address of the ALT_EMAC_GMAC_MAC_ADDR8_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR8_HIGH_OFST))

/*
 * Register : Register 33 (MAC Address8 Low Register) - MAC_Address8_Low
 * 
 * The MAC Address8 Low register holds the lower 32 bits of the 9th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address8 [31:0]
 * 
 */
/*
 * Field : MAC Address8 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 9th 6-byte MAC address. The content
 * of this field is undefined until loaded by software after the initialization
 * process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR8_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR8_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address8 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR8_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR8_LOW_s  ALT_EMAC_GMAC_MAC_ADDR8_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR8_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_OFST        0x84
/* The address of the ALT_EMAC_GMAC_MAC_ADDR8_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR8_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR8_LOW_OFST))

/*
 * Register : Register 34 (MAC Address9 High Register) - MAC_Address9_High
 * 
 * The MAC Address9 High register holds the upper 16 bits of the 10th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address9 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | RW     | 0xffff | MAC Address9 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*         
 *  [24]    | RW     | 0x0    | Mask Byte Control   
 *  [25]    | RW     | 0x0    | Mask Byte Control   
 *  [26]    | RW     | 0x0    | Mask Byte Control   
 *  [27]    | RW     | 0x0    | Mask Byte Control   
 *  [28]    | RW     | 0x0    | Mask Byte Control   
 *  [29]    | RW     | 0x0    | Mask Byte Control   
 *  [30]    | RW     | 0x0    | Source Address      
 *  [31]    | RW     | 0x0    | Address Enable      
 * 
 */
/*
 * Field : MAC Address9 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 10th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address9 high and low registers. Each
 * bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                        
 * :---------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_UNMSKED    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_E_MSKED      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address9[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address9[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                 
 * :---------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 10th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                          
 * :---------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR9_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR9_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address9 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR9_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR9_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR9_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_OFST        0x88
/* The address of the ALT_EMAC_GMAC_MAC_ADDR9_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR9_HIGH_OFST))

/*
 * Register : Register 35 (MAC Address9 Low Register) - MAC_Address9_Low
 * 
 * The MAC Address9 Low register holds the lower 32 bits of the 10th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description        
 * :-------|:-------|:-----------|:--------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address9 [31:0]
 * 
 */
/*
 * Field : MAC Address9 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 10th 6-byte MAC address. The
 * content of this field is undefined until loaded by software after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR9_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR9_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address9 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR9_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR9_LOW_s  ALT_EMAC_GMAC_MAC_ADDR9_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR9_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_OFST        0x8c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR9_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR9_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR9_LOW_OFST))

/*
 * Register : Register 36 (MAC Address10 High Register) - MAC_Address10_High
 * 
 * The MAC Address10 High register holds the upper 16 bits of the 11th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address10 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description          
 * :--------|:-------|:-------|:----------------------
 *  [15:0]  | RW     | 0xffff | MAC Address10 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*          
 *  [24]    | RW     | 0x0    | Mask Byte Control    
 *  [25]    | RW     | 0x0    | Mask Byte Control    
 *  [26]    | RW     | 0x0    | Mask Byte Control    
 *  [27]    | RW     | 0x0    | Mask Byte Control    
 *  [28]    | RW     | 0x0    | Mask Byte Control    
 *  [29]    | RW     | 0x0    | Mask Byte Control    
 *  [30]    | RW     | 0x0    | Source Address       
 *  [31]    | RW     | 0x0    | Address Enable       
 * 
 */
/*
 * Field : MAC Address10 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 11th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address10 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address10[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address10[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 11th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                          
 * :----------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR10_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR10_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address10 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR10_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR10_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR10_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_OFST        0x90
/* The address of the ALT_EMAC_GMAC_MAC_ADDR10_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR10_HIGH_OFST))

/*
 * Register : Register 37 (MAC Address10 Low Register) - MAC_Address10_Low
 * 
 * The MAC Address10 Low register holds the lower 32 bits of the 11th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description         
 * :-------|:-------|:-----------|:---------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address10 [31:0]
 * 
 */
/*
 * Field : MAC Address10 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 11th 6-byte MAC address. The
 * content of this field is undefined until loaded by software after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR10_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR10_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address10 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR10_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR10_LOW_s  ALT_EMAC_GMAC_MAC_ADDR10_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR10_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_OFST        0x94
/* The address of the ALT_EMAC_GMAC_MAC_ADDR10_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR10_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR10_LOW_OFST))

/*
 * Register : Register 38 (MAC Address11 High Register) - MAC_Address11_High
 * 
 * The MAC Address11 High register holds the upper 16 bits of the 12th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address11 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description          
 * :--------|:-------|:-------|:----------------------
 *  [15:0]  | RW     | 0xffff | MAC Address11 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*          
 *  [24]    | RW     | 0x0    | Mask Byte Control    
 *  [25]    | RW     | 0x0    | Mask Byte Control    
 *  [26]    | RW     | 0x0    | Mask Byte Control    
 *  [27]    | RW     | 0x0    | Mask Byte Control    
 *  [28]    | RW     | 0x0    | Mask Byte Control    
 *  [29]    | RW     | 0x0    | Mask Byte Control    
 *  [30]    | RW     | 0x0    | Source Address       
 *  [31]    | RW     | 0x0    | Address Enable       
 * 
 */
/*
 * Field : MAC Address11 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 12th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address11 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address11[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address11[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 12th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                          
 * :----------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR11_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR11_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address11 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR11_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR11_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR11_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_OFST        0x98
/* The address of the ALT_EMAC_GMAC_MAC_ADDR11_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR11_HIGH_OFST))

/*
 * Register : Register 39 (MAC Address11 Low Register) - MAC_Address11_Low
 * 
 * The MAC Address11 Low register holds the lower 32 bits of the 12th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description         
 * :-------|:-------|:-----------|:---------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address11 [31:0]
 * 
 */
/*
 * Field : MAC Address11 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 12th 6-byte MAC address. The
 * content of this field is undefined until loaded by software after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR11_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR11_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address11 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR11_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR11_LOW_s  ALT_EMAC_GMAC_MAC_ADDR11_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR11_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_OFST        0x9c
/* The address of the ALT_EMAC_GMAC_MAC_ADDR11_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR11_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR11_LOW_OFST))

/*
 * Register : Register 40 (MAC Address12 High Register) - MAC_Address12_High
 * 
 * The MAC Address12 High register holds the upper 16 bits of the 13th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address12 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description          
 * :--------|:-------|:-------|:----------------------
 *  [15:0]  | RW     | 0xffff | MAC Address12 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*          
 *  [24]    | RW     | 0x0    | Mask Byte Control    
 *  [25]    | RW     | 0x0    | Mask Byte Control    
 *  [26]    | RW     | 0x0    | Mask Byte Control    
 *  [27]    | RW     | 0x0    | Mask Byte Control    
 *  [28]    | RW     | 0x0    | Mask Byte Control    
 *  [29]    | RW     | 0x0    | Mask Byte Control    
 *  [30]    | RW     | 0x0    | Source Address       
 *  [31]    | RW     | 0x0    | Address Enable       
 * 
 */
/*
 * Field : MAC Address12 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 13th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address12 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address12[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address12[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 13th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                          
 * :----------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR12_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR12_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address12 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR12_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR12_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR12_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_OFST        0xa0
/* The address of the ALT_EMAC_GMAC_MAC_ADDR12_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR12_HIGH_OFST))

/*
 * Register : Register 41 (MAC Address12 Low Register) - MAC_Address12_Low
 * 
 * The MAC Address12 Low register holds the lower 32 bits of the 13th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description         
 * :-------|:-------|:-----------|:---------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address12 [31:0]
 * 
 */
/*
 * Field : MAC Address12 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 13th 6-byte MAC address. The
 * content of this field is undefined until loaded by software after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR12_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR12_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address12 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR12_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR12_LOW_s  ALT_EMAC_GMAC_MAC_ADDR12_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR12_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_OFST        0xa4
/* The address of the ALT_EMAC_GMAC_MAC_ADDR12_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR12_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR12_LOW_OFST))

/*
 * Register : Register 42 (MAC Address13 High Register) - MAC_Address13_High
 * 
 * The MAC Address13 High register holds the upper 16 bits of the 14th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address13 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description          
 * :--------|:-------|:-------|:----------------------
 *  [15:0]  | RW     | 0xffff | MAC Address13 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*          
 *  [24]    | RW     | 0x0    | Mask Byte Control    
 *  [25]    | RW     | 0x0    | Mask Byte Control    
 *  [26]    | RW     | 0x0    | Mask Byte Control    
 *  [27]    | RW     | 0x0    | Mask Byte Control    
 *  [28]    | RW     | 0x0    | Mask Byte Control    
 *  [29]    | RW     | 0x0    | Mask Byte Control    
 *  [30]    | RW     | 0x0    | Source Address       
 *  [31]    | RW     | 0x0    | Address Enable       
 * 
 */
/*
 * Field : MAC Address13 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 14th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address13 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address13[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address13[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 14th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                          
 * :----------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR13_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR13_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address13 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR13_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR13_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR13_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_OFST        0xa8
/* The address of the ALT_EMAC_GMAC_MAC_ADDR13_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR13_HIGH_OFST))

/*
 * Register : Register 43 (MAC Address13 Low Register) - MAC_Address13_Low
 * 
 * The MAC Address13 Low register holds the lower 32 bits of the 14th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description         
 * :-------|:-------|:-----------|:---------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address13 [31:0]
 * 
 */
/*
 * Field : MAC Address13 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 14th 6-byte MAC address. The
 * content of this field is undefined until loaded by software after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR13_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR13_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address13 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR13_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR13_LOW_s  ALT_EMAC_GMAC_MAC_ADDR13_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR13_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_OFST        0xac
/* The address of the ALT_EMAC_GMAC_MAC_ADDR13_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR13_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR13_LOW_OFST))

/*
 * Register : Register 44 (MAC Address14 High Register) - MAC_Address14_High
 * 
 * The MAC Address14 High register holds the upper 16 bits of the 15th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address14 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description          
 * :--------|:-------|:-------|:----------------------
 *  [15:0]  | RW     | 0xffff | MAC Address14 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*          
 *  [24]    | RW     | 0x0    | Mask Byte Control    
 *  [25]    | RW     | 0x0    | Mask Byte Control    
 *  [26]    | RW     | 0x0    | Mask Byte Control    
 *  [27]    | RW     | 0x0    | Mask Byte Control    
 *  [28]    | RW     | 0x0    | Mask Byte Control    
 *  [29]    | RW     | 0x0    | Mask Byte Control    
 *  [30]    | RW     | 0x0    | Source Address       
 *  [31]    | RW     | 0x0    | Address Enable       
 * 
 */
/*
 * Field : MAC Address14 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 15th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address14 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address14[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address14[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 15th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                          
 * :----------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR14_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR14_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address14 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR14_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR14_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR14_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_OFST        0xb0
/* The address of the ALT_EMAC_GMAC_MAC_ADDR14_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR14_HIGH_OFST))

/*
 * Register : Register 45 (MAC Address14 Low Register) - MAC_Address14_Low
 * 
 * The MAC Address14 Low register holds the lower 32 bits of the 15th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description         
 * :-------|:-------|:-----------|:---------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address14 [31:0]
 * 
 */
/*
 * Field : MAC Address14 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 15th 6-byte MAC address. The
 * content of this field is undefined until loaded by software after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR14_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR14_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address14 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR14_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR14_LOW_s  ALT_EMAC_GMAC_MAC_ADDR14_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR14_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_OFST        0xb4
/* The address of the ALT_EMAC_GMAC_MAC_ADDR14_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR14_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR14_LOW_OFST))

/*
 * Register : Register 46 (MAC Address15 High Register) - MAC_Address15_High
 * 
 * The MAC Address15 High register holds the upper 16 bits of the 16th 6-byte MAC
 * address of the station. Because the MAC address registers are configured to be
 * double-synchronized to the (G)MII clock domains, the synchronization is
 * triggered only when bits[31:24] (in little-endian mode) or Bits[7:0] (in big-
 * endian mode) of the MAC Address15 Low Register are written. For proper
 * synchronization updates, the consecutive writes to this Address Low Register
 * should be performed after at least four clock cycles in the destination clock
 * domain.
 * 
 * Note that all MAC Address High registers (except MAC Address0 High) have the
 * same format.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description          
 * :--------|:-------|:-------|:----------------------
 *  [15:0]  | RW     | 0xffff | MAC Address15 [47:32]
 *  [23:16] | ???    | 0x0    | *UNDEFINED*          
 *  [24]    | RW     | 0x0    | Mask Byte Control    
 *  [25]    | RW     | 0x0    | Mask Byte Control    
 *  [26]    | RW     | 0x0    | Mask Byte Control    
 *  [27]    | RW     | 0x0    | Mask Byte Control    
 *  [28]    | RW     | 0x0    | Mask Byte Control    
 *  [29]    | RW     | 0x0    | Mask Byte Control    
 *  [30]    | RW     | 0x0    | Source Address       
 *  [31]    | RW     | 0x0    | Address Enable       
 * 
 */
/*
 * Field : MAC Address15 [47:32] - addrhi
 * 
 * This field contains the upper 16 bits (47:32) of the 16th 6-byte MAC address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_WIDTH      16
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_CLR_MSK    0xffff0000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_RESET      0xffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDRHI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Mask Byte Control - mbc_0
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_0_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Mask Byte Control - mbc_1
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_1_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Mask Byte Control - mbc_2
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_MSB        26
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_SET_MSK    0x04000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_CLR_MSK    0xfbffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_2_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mask Byte Control - mbc_3
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_MSB        27
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_SET_MSK    0x08000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_3_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Mask Byte Control - mbc_4
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_MSB        28
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_SET_MSK    0x10000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_CLR_MSK    0xefffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_4_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Mask Byte Control - mbc_5
 * 
 * This array of bits are mask control bits for comparison of each of the MAC
 * Address bytes. When masked, the MAC does not compare the corresponding byte of
 * received DA or SA with the contents of MAC Address15 high and low registers.
 * Each bit controls the masking of the bytes. You can filter a group of addresses
 * (known as group address filtering) by masking one or more bytes of the address.
 * 
 * The array index corresponds to the byte (e.g. index 0 is for bits 7:0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                        
 * :----------------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_UNMSKED | 0x0   | Byte is unmasked (i.e. is compared)
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_MSKED   | 0x1   | Byte is masked (i.e. not compared) 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5
 * 
 * Byte is unmasked (i.e. is compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_UNMSKED   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5
 * 
 * Byte is masked (i.e. not compared)
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_E_MSKED     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_MSB        29
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_SET_MSK    0x20000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_CLR_MSK    0xdfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5 register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_MBC_5_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Source Address - sa
 * 
 * When this bit is enabled, the MAC Address15[47:0] is used to compare with the SA
 * fields of the received frame. When this bit is disabled, the MAC Address15[47:0]
 * is used to compare with the DA fields of the received frame.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_DISD | 0x0   | MAC address compare disabled
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_END  | 0x1   | MAC address compare enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA
 * 
 * MAC address compare disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA
 * 
 * MAC address compare enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_MSB        30
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_SET_MSK    0x40000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_CLR_MSK    0xbfffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_SA_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Address Enable - ae
 * 
 * When this bit is enabled, the address filter block uses the 16th MAC address for
 * perfect filtering. When this bit is disabled, the address filter block ignores
 * the address for filtering.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                          
 * :----------------------------------------|:------|:--------------------------------------
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_DISD | 0x0   | Second MAC address filtering disabled
 *  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_END  | 0x1   | Second MAC address filtering enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE
 * 
 * Second MAC address filtering disabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE
 * 
 * Second MAC address filtering enabled
 */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_SET_MSK    0x80000000
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_AE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR15_HIGH.
 */
struct ALT_EMAC_GMAC_MAC_ADDR15_HIGH_s
{
    uint32_t  addrhi : 16;  /* MAC Address15 [47:32] */
    uint32_t         :  8;  /* *UNDEFINED* */
    uint32_t  mbc_0  :  1;  /* Mask Byte Control */
    uint32_t  mbc_1  :  1;  /* Mask Byte Control */
    uint32_t  mbc_2  :  1;  /* Mask Byte Control */
    uint32_t  mbc_3  :  1;  /* Mask Byte Control */
    uint32_t  mbc_4  :  1;  /* Mask Byte Control */
    uint32_t  mbc_5  :  1;  /* Mask Byte Control */
    uint32_t  sa     :  1;  /* Source Address */
    uint32_t  ae     :  1;  /* Address Enable */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR15_HIGH. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR15_HIGH_s  ALT_EMAC_GMAC_MAC_ADDR15_HIGH_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_OFST        0xb8
/* The address of the ALT_EMAC_GMAC_MAC_ADDR15_HIGH register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_HIGH_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR15_HIGH_OFST))

/*
 * Register : Register 47 (MAC Address15 Low Register) - MAC_Address15_Low
 * 
 * The MAC Address15 Low register holds the lower 32 bits of the 16th 6-byte MAC
 * address of the station.
 * 
 * Note that all MAC Address Low registers (except MAC Address0 Low) have the same
 * format.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description         
 * :-------|:-------|:-----------|:---------------------
 *  [31:0] | RW     | 0xffffffff | MAC Address15 [31:0]
 * 
 */
/*
 * Field : MAC Address15 [31:0] - addrlo
 * 
 * This field contains the lower 32 bits of the 16th 6-byte MAC address. The
 * content of this field is undefined until loaded by software after the
 * initialization process.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field value. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_RESET      0xffffffff
/* Extracts the ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO field value from a register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDRLO_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MAC_ADDR15_LOW.
 */
struct ALT_EMAC_GMAC_MAC_ADDR15_LOW_s
{
    uint32_t  addrlo : 32;  /* MAC Address15 [31:0] */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MAC_ADDR15_LOW. */
typedef volatile struct ALT_EMAC_GMAC_MAC_ADDR15_LOW_s  ALT_EMAC_GMAC_MAC_ADDR15_LOW_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MAC_ADDR15_LOW register from the beginning of the component. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_OFST        0xbc
/* The address of the ALT_EMAC_GMAC_MAC_ADDR15_LOW register. */
#define ALT_EMAC_GMAC_MAC_ADDR15_LOW_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MAC_ADDR15_LOW_OFST))

/*
 * Register : Register 54 (SGMII/RGMII/SMII Status Register) - SGMII_RGMII_SMII_Control_Status
 * 
 * The SGMII/RGMII/SMII Status register indicates the status signals received by
 * the RGMII interface (selected at reset) from the PHY.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [0]    | R      | 0x0   | Link Mode  
 *  [2:1]  | R      | 0x0   | Link Speed 
 *  [3]    | R      | 0x0   | Link Status
 *  [31:4] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : Link Mode - lnkmod
 * 
 * This bit indicates the current mode of operation of the link
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_HALFDUP | 0x0   | Half Duplex
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_FULLDUP | 0x1   | Full Duplex
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD
 * 
 * Half Duplex
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_HALFDUP 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD
 * 
 * Full Duplex
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_E_FULLDUP 0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD field value from a register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKMOD_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Link Speed - lnkspeed
 * 
 * This bit indicates the current speed of the link. Bit 2 is reserved when the MAC
 * is configured for the SMII PHY interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                  | Value | Description      
 * :------------------------------------------------------|:------|:------------------
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED2POINT5MHZ | 0x0   | Link Speed 2.5MHz
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED25MHZ      | 0x1   | Link Speed 25MHz 
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED125MHZ     | 0x2   | Link Speed 125MHz
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED
 * 
 * Link Speed 2.5MHz
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED2POINT5MHZ   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED
 * 
 * Link Speed 25MHz
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED25MHZ        0x1
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED
 * 
 * Link Speed 125MHz
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_E_SPEED125MHZ       0x2

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_WIDTH      2
/* The mask used to set the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_SET_MSK    0x00000006
/* The mask used to clear the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_CLR_MSK    0xfffffff9
/* The reset value of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED field value from a register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_GET(value) (((value) & 0x00000006) >> 1)
/* Produces a ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSPEED_SET(value) (((value) << 1) & 0x00000006)

/*
 * Field : Link Status - lnksts
 * 
 * This bit indicates whether the link is up (1'b1) or down (1'b0).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description
 * :---------------------------------------------|:------|:------------
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKDOWN | 0x0   | Linkdown   
 *  ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKUP   | 0x1   | Linkup     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS
 * 
 * Linkdown
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKDOWN    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS
 * 
 * Linkup
 */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_E_LINKUP      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field value. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS field value from a register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_LNKSTS_SET(value) (((value) << 3) & 0x00000008)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MII_CTL_STAT.
 */
struct ALT_EMAC_GMAC_MII_CTL_STAT_s
{
    const uint32_t  lnkmod   :  1;  /* Link Mode */
    const uint32_t  lnkspeed :  2;  /* Link Speed */
    const uint32_t  lnksts   :  1;  /* Link Status */
    uint32_t                 : 28;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MII_CTL_STAT. */
typedef volatile struct ALT_EMAC_GMAC_MII_CTL_STAT_s  ALT_EMAC_GMAC_MII_CTL_STAT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MII_CTL_STAT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_OFST        0xd8
/* The address of the ALT_EMAC_GMAC_MII_CTL_STAT register. */
#define ALT_EMAC_GMAC_MII_CTL_STAT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MII_CTL_STAT_OFST))

/*
 * Register : Register 64 (MMC Control Register) - MMC_Control
 * 
 * The MMC Control register establishes the operating mode of the management
 * counters.
 * 
 * Note:
 * 
 * The bit 0 (Counters Reset) has higher priority than bit 4 (Counter Preset).
 * Therefore, when the Software tries to set both bits in the same write cycle, all
 * counters are cleared and the bit 4 is not set.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                     
 * :-------|:-------|:------|:-------------------------------------------------
 *  [0]    | RW     | 0x0   | Counters Reset                                  
 *  [1]    | RW     | 0x0   | Counters Stop Rollover                          
 *  [2]    | RW     | 0x0   | Reset on Read                                   
 *  [3]    | RW     | 0x0   | MMC Counter Freeze                              
 *  [4]    | RW     | 0x0   | Counters Preset                                 
 *  [5]    | RW     | 0x0   | Full-Half Preset                                
 *  [7:6]  | ???    | 0x0   | *UNDEFINED*                                     
 *  [8]    | RW     | 0x0   | Update MMC Counters for Dropped Broadcast Frames
 *  [31:9] | ???    | 0x0   | *UNDEFINED*                                     
 * 
 */
/*
 * Field : Counters Reset - cntrst
 * 
 * When this bit is set, all counters are reset. This bit is cleared automatically
 * after one clock cycle.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                     
 * :------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_DISD | 0x0   | Auto cleared after 1 clock cycle
 *  ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_END  | 0x1   | All Counters Reset              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTRST
 * 
 * Auto cleared after 1 clock cycle
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTRST
 * 
 * All Counters Reset
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTRST field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTRST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTRST_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Counters Stop Rollover - cntstopro
 * 
 * When this bit is set, after reaching maximum value, the counter does not roll
 * over to zero.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description               
 * :---------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_DISD | 0x0   | Counter Roll Over         
 *  ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_END  | 0x1   | Counter does not Roll Over
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO
 * 
 * Counter Roll Over
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO
 * 
 * Counter does not Roll Over
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTSTOPRO_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Reset on Read - rstonrd
 * 
 * When this bit is set, the MMC counters are reset to zero after Read (self-
 * clearing after reset). The counters are cleared when the least significant byte
 * lane (bits[7:0]) is read.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description        
 * :-------------------------------------|:------|:--------------------
 *  ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_DISD | 0x0   | No reset after read
 *  ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_END  | 0x1   | Reset after read   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_RSTONRD
 * 
 * No reset after read
 */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_RSTONRD
 * 
 * Reset after read
 */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_RSTONRD field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_RSTONRD register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_RSTONRD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : MMC Counter Freeze - cntfreez
 * 
 * When this bit is set, it freezes all MMC counters to their current value. Until
 * this bit is reset to 0, no MMC counter is updated because of any transmitted or
 * received frame. If any MMC counter is read with the Reset on Read bit set, then
 * that counter is also cleared in this mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                         
 * :--------------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_DISD | 0x0   | Update MMC Counters                 
 *  ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_END  | 0x1   | Freeze MMC counters to current value
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ
 * 
 * Update MMC Counters
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ
 * 
 * Freeze MMC counters to current value
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTFREEZ_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Counters Preset - cntprst
 * 
 * When this bit is set, all counters are initialized or preset to almost full or
 * almost half according to bit 5. This bit is cleared automatically after 1 clock
 * cycle. This bit, along with bit 5, is useful for debugging and testing the
 * assertion of interrupts because of MMC counter becoming half-full or full.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                           
 * :-------------------------------------|:------|:---------------------------------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_DISD | 0x0   | Counters not preset                   
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_END  | 0x1   | Counters preset to full or almost full
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRST
 * 
 * Counters not preset
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRST
 * 
 * Counters preset to full or almost full
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTPRST field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTPRST register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRST_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Full-Half Preset - cntprstlvl
 * 
 * When low and bit 4 is set, all MMC counters get preset to almost-half value. All
 * octet counters get preset to 0x7FFF_F800 (half - 2KBytes) and all frame-counters
 * gets preset to 0x7FFF_FFF0 (half - 16).
 * 
 * When this bit is high and bit 4 is set, all MMC counters get preset to almost-
 * full value. All octet counters get preset to 0xFFFF_F800 (full - 2KBytes) and
 * all frame-counters gets preset to 0xFFFF_FFF0 (full - 16).
 * 
 * For 16-bit counters, the almost-half preset values are 0x7800 and 0x7FF0 for the
 * respective octet and frame counters. Similarly, the almost-full preset values
 * for the 16-bit counters are 0xF800 and 0xFFF0.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                       
 * :----------------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTHALF | 0x0   | Preset All Counters to almost-half
 *  ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTFULL | 0x1   | Present All Counters almost-full  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL
 * 
 * Preset All Counters to almost-half
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTHALF   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL
 * 
 * Present All Counters almost-full
 */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_E_ALMOSTFULL   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_CNTPRSTLVL_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Update MMC Counters for Dropped Broadcast Frames - ucdbc
 * 
 * When set, this bit enables MAC to update all the related MMC Counters for
 * Broadcast frames dropped due to setting of DBF bit (Disable Broadcast Frames) of
 * MAC Filter Register at offset 0x0004.
 * 
 * When reset, MMC Counters are not updated for dropped Broadcast frames.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field value. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_CTL_UCDBC register field. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_CTL_UCDBC field value from a register. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_CTL_UCDBC register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_CTL_UCDBC_SET(value) (((value) << 8) & 0x00000100)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_CTL.
 */
struct ALT_EMAC_GMAC_MMC_CTL_s
{
    uint32_t  cntrst     :  1;  /* Counters Reset */
    uint32_t  cntstopro  :  1;  /* Counters Stop Rollover */
    uint32_t  rstonrd    :  1;  /* Reset on Read */
    uint32_t  cntfreez   :  1;  /* MMC Counter Freeze */
    uint32_t  cntprst    :  1;  /* Counters Preset */
    uint32_t  cntprstlvl :  1;  /* Full-Half Preset */
    uint32_t             :  2;  /* *UNDEFINED* */
    uint32_t  ucdbc      :  1;  /* Update MMC Counters for Dropped Broadcast Frames */
    uint32_t             : 23;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_CTL. */
typedef volatile struct ALT_EMAC_GMAC_MMC_CTL_s  ALT_EMAC_GMAC_MMC_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MMC_CTL register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_CTL_OFST        0x100
/* The address of the ALT_EMAC_GMAC_MMC_CTL register. */
#define ALT_EMAC_GMAC_MMC_CTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_CTL_OFST))

/*
 * Register : Register 65 (MMC Receive Interrupt Register) - MMC_Receive_Interrupt
 * 
 * The MMC Receive Interrupt register maintains the interrupts that are generated
 * when the following happens:
 * 
 * * Receive statistic counters reach half of their maximum values (0x8000_0000 for
 *   32-bit counter and 0x8000 for 16-bit counter).
 * 
 * * Receive statistic counters cross their maximum values (0xFFFF_FFFF for 32-bit
 *   counter and 0xFFFF for 16-bit counter).
 * 
 * When the Counter Stop Rollover is set, then interrupts are set but the counter
 * remains at all-ones. The MMC Receive Interrupt register is a 32-bit wide
 * register. An interrupt bit is cleared when the respective MMC counter that
 * caused the interrupt is read. The least significant byte lane (Bits[7:0]) of the
 * respective counter must be read in order to clear the interrupt bit.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                                              
 * :--------|:-------|:------|:--------------------------------------------------------------------------
 *  [0]     | R      | 0x0   | MMC Receive Good Bad Frame Counter Interrupt Status                      
 *  [1]     | R      | 0x0   | MMC Receive Good Bad Octet Counter Interrupt Status                      
 *  [2]     | R      | 0x0   | MMC Receive Good Octet Counter Interrupt Status.                         
 *  [3]     | R      | 0x0   | MMC Receive Broadcast Good Frame Counter Interrupt Status.               
 *  [4]     | R      | 0x0   | MMC Receive Multicast Good Frame Counter Interrupt Status                
 *  [5]     | R      | 0x0   | MMC Receive CRC Error Frame Counter Interrupt Status                     
 *  [6]     | R      | 0x0   | MMC Receive Alignment Error Frame Counter Interrupt Status               
 *  [7]     | R      | 0x0   | MMC Receive Runt Frame Counter Interrupt Status                          
 *  [8]     | R      | 0x0   | MMC Receive Jabber Error Frame Counter Interrupt Status                  
 *  [9]     | R      | 0x0   | MMC Receive Undersize Good Frame Counter Interrupt Status                
 *  [10]    | R      | 0x0   | MMC Receive Oversize Good Frame Counter Interrupt Status                 
 *  [11]    | R      | 0x0   | MMC Receive 64 Octet Good Bad Frame Counter Interrupt Status             
 *  [12]    | R      | 0x0   | MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Status      
 *  [13]    | R      | 0x0   | MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Status     
 *  [14]    | R      | 0x0   | MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Status     
 *  [15]    | R      | 0x0   | MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Status    
 *  [16]    | R      | 0x0   | MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status
 *  [17]    | R      | 0x0   | MMC Receive Unicast Good Frame Counter Interrupt Status                  
 *  [18]    | R      | 0x0   | MMC Receive Length Error Frame Counter Interrupt Status                  
 *  [19]    | R      | 0x0   | MMC Receive Out Of Range Error Frame Counter Interrupt Status            
 *  [20]    | R      | 0x0   | MMC Receive Pause Frame Counter Interrupt Status                         
 *  [21]    | R      | 0x0   | MMC Receive FIFO Overflow Frame Counter Interrupt Status                 
 *  [22]    | R      | 0x0   | MMC Receive VLAN Good Bad Frame Counter Interrupt Status                 
 *  [23]    | R      | 0x0   | MMC Receive Watchdog Error Frame Counter Interrupt Status                
 *  [24]    | R      | 0x0   | MMC Receive Error Frame Counter Interrupt Status                         
 *  [25]    | R      | 0x0   | MMC Receive Control Frame Counter Interrupt Status                       
 *  [31:26] | ???    | 0x0   | *UNDEFINED*                                                              
 * 
 */
/*
 * Field : MMC Receive Good Bad Frame Counter Interrupt Status - rxgbfrmis
 * 
 * This bit is set when the rxframecount_bg counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                       
 * :----------------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTHALF | 0x0   | Preset All Counters to almost-half
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTFULL | 0x1   | Present All Counters almost-full  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS
 * 
 * Preset All Counters to almost-half
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTHALF   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS
 * 
 * Present All Counters almost-full
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_E_ALMOSTFULL   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBFRMIS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : MMC Receive Good Bad Octet Counter Interrupt Status - rxgboctis
 * 
 * This bit is set when the rxoctetcount_bg counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                
 * :-----------------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_INACT | 0x0   | Rxoctetcount_bg < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_ACT   | 0x1   | Rxoctetcount_bg >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS
 * 
 * Rxoctetcount_bg < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS
 * 
 * Rxoctetcount_bg >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GBOCTIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : MMC Receive Good Octet Counter Interrupt Status. - rxgoctis
 * 
 * This bit is set when the rxoctetcount_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description               
 * :----------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_INACT | 0x0   | Rxoctetcount_g < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_ACT   | 0x1   | Rxoctetcount_g >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS
 * 
 * Rxoctetcount_g < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS
 * 
 * Rxoctetcount_g >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_GOCTIS_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : MMC Receive Broadcast Good Frame Counter Interrupt Status. - rxbcgfis
 * 
 * This bit is set when the rxbroadcastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_BCGFIS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : MMC Receive Multicast Good Frame Counter Interrupt Status - rxmcgfis
 * 
 * This bit is set when the rxmulticastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                    
 * :----------------------------------------|:------|:--------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_INACT | 0x0   | rxbroadcastframes_g < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_ACT   | 0x1   | rxbroadcastframes_g >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS
 * 
 * rxbroadcastframes_g < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS
 * 
 * rxbroadcastframes_g >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MCGFIS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : MMC Receive CRC Error Frame Counter Interrupt Status - rxcrcerfis
 * 
 * This bit is set when the rxcrcerror counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description           
 * :------------------------------------------|:------|:-----------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_INACT | 0x0   | rxcrcerror < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_ACT   | 0x1   | rxcrcerror >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS
 * 
 * rxcrcerror < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS
 * 
 * rxcrcerror >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CRCERFIS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : MMC Receive Alignment Error Frame Counter Interrupt Status - rxalgnerfis
 * 
 * This bit is set when the rxalignmenterror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                 
 * :-------------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_INACT | 0x0   | rxalignmenterror < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_ACT   | 0x1   | rxalignmenterror >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS
 * 
 * rxalignmenterror < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS
 * 
 * rxalignmenterror >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ALGNERFIS_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : MMC Receive Runt Frame Counter Interrupt Status - rxruntfis
 * 
 * This bit is set when the rxrunterror counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description            
 * :-----------------------------------------|:------|:------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_INACT | 0x0   | rxrunterror < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_ACT   | 0x1   | rxrunterror >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS
 * 
 * rxrunterror < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS
 * 
 * rxrunterror >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RUNTFIS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : MMC Receive Jabber Error Frame Counter Interrupt Status - rxjaberfis
 * 
 * This bit is set when the rxjabbererror counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description              
 * :------------------------------------------|:------|:--------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_INACT | 0x0   | rxjabbererror < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_ACT   | 0x1   | rxjabbererror >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS
 * 
 * rxjabbererror < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS
 * 
 * rxjabbererror >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_JABERFIS_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : MMC Receive Undersize Good Frame Counter Interrupt Status - rxusizegfis
 * 
 * This bit is set when the rxundersize_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description              
 * :-------------------------------------------|:------|:--------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_INACT | 0x0   | rxundersize_g < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_ACT   | 0x1   | rxundersize_g >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS
 * 
 * rxundersize_g < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS
 * 
 * rxundersize_g >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_USIZEGFIS_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : MMC Receive Oversize Good Frame Counter Interrupt Status - rxosizegfis
 * 
 * This bit is set when the rxoversize_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description              
 * :-------------------------------------------|:------|:--------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_INACT | 0x0   | rxoversize_g  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_ACT   | 0x1   | rxoversize_g  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS
 * 
 * rxoversize_g  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS
 * 
 * rxoversize_g  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OSIZEGFIS_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : MMC Receive 64 Octet Good Bad Frame Counter Interrupt Status - rx64octgbfis
 * 
 * This bit is set when the rx64octets_gb counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description               
 * :--------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_INACT | 0x0   | rx64octets_gb   < half max
 *  ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_ACT   | 0x1   | rx64octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS
 * 
 * rx64octets_gb   < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS
 * 
 * rx64octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_64OCTGBFIS_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Status - rx65t127octgbfis
 * 
 * This is set when the rx65to127octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description                    
 * :------------------------------------------------|:------|:--------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_INACT | 0x0   | rx65to127octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_ACT   | 0x1   | rx65to127octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS
 * 
 * rx65to127octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS
 * 
 * rx65to127octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_65T127OCTGBFIS_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Status - rx128t255octgbfis
 * 
 * This bit is set when the rx128to255octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description                     
 * :-------------------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_INACT | 0x0   | rx128to255octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_ACT   | 0x1   | rx128to255octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS
 * 
 * rx128to255octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS
 * 
 * rx128to255octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_128T255OCTGBFIS_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Status - rx256t511octgbfis
 * 
 * This bit is set when the rx256to511octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description                     
 * :-------------------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_INACT | 0x0   | rx256to511octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_ACT   | 0x1   | rx256to511octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS
 * 
 * rx256to511octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS
 * 
 * rx256to511octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_256T511OCTGBFIS_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Status - rx512t1023octgbfis
 * 
 * This bit is set when the rx512to1023octets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description                      
 * :--------------------------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_INACT | 0x0   | rx512to1023octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_ACT   | 0x1   | rx512to1023octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS
 * 
 * rx512to1023octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS
 * 
 * rx512to1023octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_512T1023OCTGBFIS_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status - rx1024tmaxoctgbfis
 * 
 * This bit is set when the rx1024tomaxoctets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description                      
 * :--------------------------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_INACT | 0x0   | rx1024tomaxoctets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_ACT   | 0x1   | rx1024tomaxoctets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS
 * 
 * rx1024tomaxoctets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS
 * 
 * rx1024tomaxoctets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_1024TMAXOCTGBFIS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : MMC Receive Unicast Good Frame Counter Interrupt Status - rxucgfis
 * 
 * This bit is set when the rxunicastframes_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                      
 * :----------------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_INACT | 0x0   | rx1024tomaxoctets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_ACT   | 0x1   | rx1024tomaxoctets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS
 * 
 * rx1024tomaxoctets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS
 * 
 * rx1024tomaxoctets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_UCGFIS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : MMC Receive Length Error Frame Counter Interrupt Status - rxlenerfis
 * 
 * This bit is set when the rxlengtherror counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description               
 * :------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_INACT | 0x0   | rxlengtherror  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_ACT   | 0x1   | rxlengtherror  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS
 * 
 * rxlengtherror  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS
 * 
 * rxlengtherror  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_LENERFIS_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : MMC Receive Out Of Range Error Frame Counter Interrupt Status - rxorangefis
 * 
 * This bit is set when the rxoutofrangetype counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                  
 * :-------------------------------------------|:------|:------------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_INACT | 0x0   | rxoutofrangetype  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_ACT   | 0x1   | rxoutofrangetype  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS
 * 
 * rxoutofrangetype  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS
 * 
 * rxoutofrangetype  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ORANGEFIS_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : MMC Receive Pause Frame Counter Interrupt Status - rxpausfis
 * 
 * This bit is set when the rxpauseframe counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description              
 * :-----------------------------------------|:------|:--------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_INACT | 0x0   | rxpauseframe  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_ACT   | 0x1   | rxpauseframe  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS
 * 
 * rxpauseframe  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS
 * 
 * rxpauseframe  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_PAUSFIS_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : MMC Receive FIFO Overflow Frame Counter Interrupt Status - rxfovfis
 * 
 * This bit is set when the rxfifooverflow counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                
 * :----------------------------------------|:------|:----------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_INACT | 0x0   | rxfifooverflow  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_ACT   | 0x1   | rxfifooverflow  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS
 * 
 * rxfifooverflow  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS
 * 
 * rxfifooverflow  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_FOVFIS_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : MMC Receive VLAN Good Bad Frame Counter Interrupt Status - rxvlangbfis
 * 
 * This bit is set when the rxvlanframes_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                 
 * :-------------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_INACT | 0x0   | rxvlanframes_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_ACT   | 0x1   | rxvlanframes_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS
 * 
 * rxvlanframes_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS
 * 
 * rxvlanframes_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_VLANGBFIS_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : MMC Receive Watchdog Error Frame Counter Interrupt Status - rxwdogfis
 * 
 * This bit is set when the rxwatchdogerror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                 
 * :-----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_INACT | 0x0   | rxwatchdogerror  < half max 
 *  ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_ACT   | 0x1   | rxwatchdogerror  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS
 * 
 * rxwatchdogerror  < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS
 * 
 * rxwatchdogerror  >= half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_WDOGFIS_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : MMC Receive Error Frame Counter Interrupt Status - rxrcverrfis
 * 
 * This bit is set when the rxrcverror counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_RCVERRFIS_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : MMC Receive Control Frame Counter Interrupt Status - rxctrlfis
 * 
 * This bit is set when the rxctrlframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_CTLFIS_SET(value) (((value) << 25) & 0x02000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_RX_INT.
 */
struct ALT_EMAC_GMAC_MMC_RX_INT_s
{
    const uint32_t  rxgbfrmis          :  1;  /* MMC Receive Good Bad Frame Counter Interrupt Status */
    const uint32_t  rxgboctis          :  1;  /* MMC Receive Good Bad Octet Counter Interrupt Status */
    const uint32_t  rxgoctis           :  1;  /* MMC Receive Good Octet Counter Interrupt Status. */
    const uint32_t  rxbcgfis           :  1;  /* MMC Receive Broadcast Good Frame Counter Interrupt Status. */
    const uint32_t  rxmcgfis           :  1;  /* MMC Receive Multicast Good Frame Counter Interrupt Status */
    const uint32_t  rxcrcerfis         :  1;  /* MMC Receive CRC Error Frame Counter Interrupt Status */
    const uint32_t  rxalgnerfis        :  1;  /* MMC Receive Alignment Error Frame Counter Interrupt Status */
    const uint32_t  rxruntfis          :  1;  /* MMC Receive Runt Frame Counter Interrupt Status */
    const uint32_t  rxjaberfis         :  1;  /* MMC Receive Jabber Error Frame Counter Interrupt Status */
    const uint32_t  rxusizegfis        :  1;  /* MMC Receive Undersize Good Frame Counter Interrupt Status */
    const uint32_t  rxosizegfis        :  1;  /* MMC Receive Oversize Good Frame Counter Interrupt Status */
    const uint32_t  rx64octgbfis       :  1;  /* MMC Receive 64 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  rx65t127octgbfis   :  1;  /* MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  rx128t255octgbfis  :  1;  /* MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  rx256t511octgbfis  :  1;  /* MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  rx512t1023octgbfis :  1;  /* MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  rx1024tmaxoctgbfis :  1;  /* MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  rxucgfis           :  1;  /* MMC Receive Unicast Good Frame Counter Interrupt Status */
    const uint32_t  rxlenerfis         :  1;  /* MMC Receive Length Error Frame Counter Interrupt Status */
    const uint32_t  rxorangefis        :  1;  /* MMC Receive Out Of Range Error Frame Counter Interrupt Status */
    const uint32_t  rxpausfis          :  1;  /* MMC Receive Pause Frame Counter Interrupt Status */
    const uint32_t  rxfovfis           :  1;  /* MMC Receive FIFO Overflow Frame Counter Interrupt Status */
    const uint32_t  rxvlangbfis        :  1;  /* MMC Receive VLAN Good Bad Frame Counter Interrupt Status */
    const uint32_t  rxwdogfis          :  1;  /* MMC Receive Watchdog Error Frame Counter Interrupt Status */
    const uint32_t  rxrcverrfis        :  1;  /* MMC Receive Error Frame Counter Interrupt Status */
    const uint32_t  rxctrlfis          :  1;  /* MMC Receive Control Frame Counter Interrupt Status */
    uint32_t                           :  6;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_RX_INT. */
typedef volatile struct ALT_EMAC_GMAC_MMC_RX_INT_s  ALT_EMAC_GMAC_MMC_RX_INT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MMC_RX_INT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_RX_INT_OFST        0x104
/* The address of the ALT_EMAC_GMAC_MMC_RX_INT register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_RX_INT_OFST))

/*
 * Register : Register 66 (MMC Transmit Interrupt Register) - MMC_Transmit_Interrupt
 * 
 * The MMC Transmit Interrupt register maintains the interrupts generated when
 * transmit statistic counters reach half of their maximum values (0x8000_0000 for
 * 32-bit counter and 0x8000 for 16-bit counter), and the maximum values
 * (0xFFFF_FFFF for 32-bit counter and 0xFFFF for 16-bit counter). When Counter
 * Stop Rollover is set, then interrupts are set but the counter remains at all-
 * ones. The MMC Transmit Interrupt register is a 32-bit wide register. An
 * interrupt bit is cleared when the respective MMC counter that caused the
 * interrupt is read. The least significant byte lane (Bits[7:0]) of the respective
 * counter must be read in order to clear the interrupt bit.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                                               
 * :--------|:-------|:------|:---------------------------------------------------------------------------
 *  [0]     | R      | 0x0   | MMC Transmit Good Bad Octet Counter Interrupt Status                      
 *  [1]     | R      | 0x0   | MMC Transmit Good Bad Frame Counter Interrupt Status                      
 *  [2]     | R      | 0x0   | MMC Transmit Broadcast Good Frame Counter Interrupt Status                
 *  [3]     | R      | 0x0   | MMC Transmit Multicast Good Frame Counter Interrupt Status                
 *  [4]     | R      | 0x0   | MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Status.            
 *  [5]     | R      | 0x0   | MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Status      
 *  [6]     | R      | 0x0   | MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Status     
 *  [7]     | R      | 0x0   | MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Status     
 *  [8]     | R      | 0x0   | MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Status    
 *  [9]     | R      | 0x0   | MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status
 *  [10]    | R      | 0x0   | MMC Transmit Unicast Good Bad Frame Counter Interrupt Status              
 *  [11]    | R      | 0x0   | MMC Transmit Multicast Good Bad Frame Counter Interrupt Status            
 *  [12]    | R      | 0x0   | MMC Transmit Broadcast Good Bad Frame Counter Interrupt Status            
 *  [13]    | R      | 0x0   | MMC Transmit Underflow Error Frame Counter Interrupt Status               
 *  [14]    | R      | 0x0   | MMC Transmit Single Collision Good Frame Counter Interrupt Status         
 *  [15]    | R      | 0x0   | MMC Transmit Multiple Collision Good Frame Counter Interrupt Status       
 *  [16]    | R      | 0x0   | MMC Transmit Deferred Frame Counter Interrupt Status                      
 *  [17]    | R      | 0x0   | MMC Transmit Late Collision Frame Counter Interrupt Status                
 *  [18]    | R      | 0x0   | MMC Transmit Excessive Collision Frame Counter Interrupt Status           
 *  [19]    | R      | 0x0   | MMC Transmit Carrier Error Frame Counter Interrupt Status                 
 *  [20]    | R      | 0x0   | MMC Transmit Good Octet Counter Interrupt Status                          
 *  [21]    | R      | 0x0   | MMC Transmit Good Frame Counter Interrupt Status                          
 *  [22]    | R      | 0x0   | MMC Transmit Excessive Deferral Frame Counter Interrupt Status            
 *  [23]    | R      | 0x0   | MMC Transmit Pause Frame Counter Interrupt Status                         
 *  [24]    | R      | 0x0   | MMC Transmit VLAN Good Frame Counter Interrupt Status                     
 *  [25]    | R      | 0x0   | MMC Transmit Oversize Good Frame Counter Interrupt Status                 
 *  [31:26] | ???    | 0x0   | *UNDEFINED*                                                               
 * 
 */
/*
 * Field : MMC Transmit Good Bad Octet Counter Interrupt Status - txgboctis
 * 
 * This bit is set when the txoctetcount_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                 
 * :-----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_INACT | 0x0   | txoctetcount_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_ACT   | 0x1   | txoctetcount_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS
 * 
 * txoctetcount_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS
 * 
 * txoctetcount_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBOCTIS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : MMC Transmit Good Bad Frame Counter Interrupt Status - txgbfrmis
 * 
 * This bit is set when the txframecount_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                 
 * :-----------------------------------------|:------|:-----------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_INACT | 0x0   | txframecount_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_ACT   | 0x1   | txframecount_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS
 * 
 * txframecount_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS
 * 
 * txframecount_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GBFRMIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : MMC Transmit Broadcast Good Frame Counter Interrupt Status - txbcgfis
 * 
 * This bit is set when the txbroadcastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                     
 * :----------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_INACT | 0x0   | txbroadcastframes_g  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_ACT   | 0x1   | txbroadcastframes_g  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS
 * 
 * txbroadcastframes_g  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS
 * 
 * txbroadcastframes_g  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGFIS_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : MMC Transmit Multicast Good Frame Counter Interrupt Status - txmcgfis
 * 
 * This bit is set when the txmulticastframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                     
 * :----------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_INACT | 0x0   | txmulticastframes_g  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_ACT   | 0x1   | txmulticastframes_g  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS
 * 
 * txmulticastframes_g  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS
 * 
 * txmulticastframes_g  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGFIS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Status. - tx64octgbfis
 * 
 * This bit is set when the tx64octets_gb counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description               
 * :-------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_DISD | 0x0   | tx64octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_END  | 0x1   | tx64octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS
 * 
 * tx64octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS
 * 
 * tx64octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_64OCTGBFIS_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Status - tx65t127octgbfis
 * 
 * This bit is set when the tx65to127octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description                    
 * :------------------------------------------------|:------|:--------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_INACT | 0x0   | tx65to127octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_ACT   | 0x1   | tx65to127octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS
 * 
 * tx65to127octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS
 * 
 * tx65to127octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_65T127OCTGBFIS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Status - tx128t255octgbfis
 * 
 * This bit is set when the tx128to255octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description                     
 * :-------------------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_INACT | 0x0   | tx128to255octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_ACT   | 0x1   | tx128to255octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS
 * 
 * tx128to255octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS
 * 
 * tx128to255octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_128T255OCTGBFIS_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Status - tx256t511octgbfis
 * 
 * This bit is set when the tx256to511octets_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description                     
 * :-------------------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_INACT | 0x0   | tx256to511octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_ACT   | 0x1   | tx256to511octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS
 * 
 * tx256to511octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS
 * 
 * tx256to511octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_256T511OCTGBFIS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Status - tx512t1023octgbfis
 * 
 * This bit is set when the tx512to1023octets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description                      
 * :--------------------------------------------------|:------|:----------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_INACT | 0x0   | tx512to1023octets_gb  < half max 
 *  ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_ACT   | 0x1   | tx512to1023octets_gb  >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS
 * 
 * tx512to1023octets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS
 * 
 * tx512to1023octets_gb  >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_512T1023OCTGBFIS_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status - tx1024tmaxoctgbfis
 * 
 * This bit is set when the tx1024tomaxoctets_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description                       
 * :--------------------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_INACT | 0x0   | tx1024tomaxoctets_gb  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_ACT   | 0x1   | tx1024tomaxoctets_gb   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS
 * 
 * tx1024tomaxoctets_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_INACT   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS
 * 
 * tx1024tomaxoctets_gb   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_1024TMAXOCTGBFIS_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : MMC Transmit Unicast Good Bad Frame Counter Interrupt Status - txucgbfis
 * 
 * This bit is set when the txunicastframes_gb counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                     
 * :-----------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_INACT | 0x0   | txunicastframes_bb  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_ACT   | 0x1   | txunicastframes_bb   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS
 * 
 * txunicastframes_bb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS
 * 
 * txunicastframes_bb   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UCGBFIS_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : MMC Transmit Multicast Good Bad Frame Counter Interrupt Status - txmcgbfis
 * 
 * This bit is set when the txmulticastframes_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                       
 * :-----------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_INACT | 0x0   | txmulticastframes_gb  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_ACT   | 0x1   | txmulticastframes_gb   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS
 * 
 * txmulticastframes_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_INACT    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS
 * 
 * txmulticastframes_gb   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCGBFIS_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : MMC Transmit Broadcast Good Bad Frame Counter Interrupt Status - txbcgbfis
 * 
 * This bit is set when the txbroadcastframes_gb counter reaches half of the
 * maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                       
 * :----------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_DISD | 0x0   | txbroadcastframes_gb  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_END  | 0x1   | txbroadcastframes_gb   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS
 * 
 * txbroadcastframes_gb  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS
 * 
 * txbroadcastframes_gb   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_BCGBFIS_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : MMC Transmit Underflow Error Frame Counter Interrupt Status - txuflowerfis
 * 
 * This bit is set when the txunderflowerror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                           
 * :-------------------------------------------|:------|:---------------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_DISD | 0x0   | txunderflowerror counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_END  | 0x1   | txunderflowerror counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS
 * 
 * txunderflowerror counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS
 * 
 * txunderflowerror counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_UFLOWERFIS_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : MMC Transmit Single Collision Good Frame Counter Interrupt Status - txscolgfis
 * 
 * This bit is set when the txsinglecol_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                        
 * :-----------------------------------------|:------|:------------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_DISD | 0x0   | txsinglecol_g counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_END  | 0x1   | txsinglecol_g counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS
 * 
 * txsinglecol_g counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS
 * 
 * txsinglecol_g counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_SCOLGFIS_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : MMC Transmit Multiple Collision Good Frame Counter Interrupt Status - txmcolgfis
 * 
 * This bit is set when the txmulticol_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                       
 * :-----------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_DISD | 0x0   | txmulticol_g counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_END  | 0x1   | txmulticol_g counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS
 * 
 * txmulticol_g counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS
 * 
 * txmulticol_g counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MCOLGFIS_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : MMC Transmit Deferred Frame Counter Interrupt Status - txdeffis
 * 
 * This bit is set when the txdeferred counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                     
 * :---------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_DISD | 0x0   | txdeferred counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_END  | 0x1   | txdeferred counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS
 * 
 * txdeferred counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS
 * 
 * txdeferred counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_DEFFIS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : MMC Transmit Late Collision Frame Counter Interrupt Status - txlatcolfis
 * 
 * This bit is set when the txlatecol counter reaches half of the maximum value or
 * the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                    
 * :------------------------------------------|:------|:--------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_DISD | 0x0   | txlatecol counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_END  | 0x1   | txlatecol counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS
 * 
 * txlatecol counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_DISD   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS
 * 
 * txlatecol counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_LATCOLFIS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : MMC Transmit Excessive Collision Frame Counter Interrupt Status - txexcolfis
 * 
 * This bit is set when the txexcesscol counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                     
 * :-----------------------------------------|:------|:---------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_DISD | 0x0   | txexesscol counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_END  | 0x1   | txexesscol counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS
 * 
 * txexesscol counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS
 * 
 * txexesscol counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXCOLFIS_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : MMC Transmit Carrier Error Frame Counter Interrupt Status - txcarerfis
 * 
 * This bit is set when the txcarriererror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                         
 * :-----------------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_DISD | 0x0   | txcarriererror counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_END  | 0x1   | txcarriererror counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS
 * 
 * txcarriererror counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS
 * 
 * txcarriererror counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_CARERFIS_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : MMC Transmit Good Octet Counter Interrupt Status - txgoctis
 * 
 * This bit is set when the txoctetcount_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                         
 * :---------------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_DISD | 0x0   | txoctetcount_g counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_END  | 0x1   | txoctetcount_g counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS
 * 
 * txoctetcount_g counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS
 * 
 * txoctetcount_g counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GOCTIS_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : MMC Transmit Good Frame Counter Interrupt Status - txgfrmis
 * 
 * This bit is set when the txframecount_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                         
 * :---------------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_DISD | 0x0   | txframecount_g counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_END  | 0x1   | txframecount_g counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS
 * 
 * txframecount_g counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS
 * 
 * txframecount_g counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_GFRMIS_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : MMC Transmit Excessive Deferral Frame Counter Interrupt Status - txexdeffis
 * 
 * This bit is set when the txexcessdef counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                       
 * :-----------------------------------------|:------|:-----------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_DISD | 0x0   | txoexcessdef counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_END  | 0x1   | txoexcessdef counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS
 * 
 * txoexcessdef counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS
 * 
 * txoexcessdef counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_EXDEFFIS_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : MMC Transmit Pause Frame Counter Interrupt Status - txpausfis
 * 
 * This bit is set when the txpauseframeserror counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                             
 * :----------------------------------------|:------|:-----------------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_DISD | 0x0   | txpauseframeserror counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_END  | 0x1   | txpauseframeserror counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS
 * 
 * txpauseframeserror counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_DISD 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS
 * 
 * txpauseframeserror counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_PAUSFIS_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : MMC Transmit VLAN Good Frame Counter Interrupt Status - txvlangfis
 * 
 * This bit is set when the txvlanframes_g counter reaches half of the maximum
 * value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                         
 * :-----------------------------------------|:------|:-------------------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_DISD | 0x0   | txvlanframes_g counter  < half max  
 *  ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_END  | 0x1   | txvlanframes_g counter   >= half max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS
 * 
 * txvlanframes_g counter  < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_DISD    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS
 * 
 * txvlanframes_g counter   >= half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_VLANGFIS_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : MMC Transmit Oversize Good Frame Counter Interrupt Status - txosizegfis
 * 
 * This bit is set when the txoversize_g counter reaches half of the maximum value
 * or the maximum value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OSIZEGFIS_SET(value) (((value) << 25) & 0x02000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_TX_INT.
 */
struct ALT_EMAC_GMAC_MMC_TX_INT_s
{
    const uint32_t  txgboctis          :  1;  /* MMC Transmit Good Bad Octet Counter Interrupt Status */
    const uint32_t  txgbfrmis          :  1;  /* MMC Transmit Good Bad Frame Counter Interrupt Status */
    const uint32_t  txbcgfis           :  1;  /* MMC Transmit Broadcast Good Frame Counter Interrupt Status */
    const uint32_t  txmcgfis           :  1;  /* MMC Transmit Multicast Good Frame Counter Interrupt Status */
    const uint32_t  tx64octgbfis       :  1;  /* MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Status. */
    const uint32_t  tx65t127octgbfis   :  1;  /* MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  tx128t255octgbfis  :  1;  /* MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  tx256t511octgbfis  :  1;  /* MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  tx512t1023octgbfis :  1;  /* MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  tx1024tmaxoctgbfis :  1;  /* MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Status */
    const uint32_t  txucgbfis          :  1;  /* MMC Transmit Unicast Good Bad Frame Counter Interrupt Status */
    const uint32_t  txmcgbfis          :  1;  /* MMC Transmit Multicast Good Bad Frame Counter Interrupt Status */
    const uint32_t  txbcgbfis          :  1;  /* MMC Transmit Broadcast Good Bad Frame Counter Interrupt Status */
    const uint32_t  txuflowerfis       :  1;  /* MMC Transmit Underflow Error Frame Counter Interrupt Status */
    const uint32_t  txscolgfis         :  1;  /* MMC Transmit Single Collision Good Frame Counter Interrupt Status */
    const uint32_t  txmcolgfis         :  1;  /* MMC Transmit Multiple Collision Good Frame Counter Interrupt Status */
    const uint32_t  txdeffis           :  1;  /* MMC Transmit Deferred Frame Counter Interrupt Status */
    const uint32_t  txlatcolfis        :  1;  /* MMC Transmit Late Collision Frame Counter Interrupt Status */
    const uint32_t  txexcolfis         :  1;  /* MMC Transmit Excessive Collision Frame Counter Interrupt Status */
    const uint32_t  txcarerfis         :  1;  /* MMC Transmit Carrier Error Frame Counter Interrupt Status */
    const uint32_t  txgoctis           :  1;  /* MMC Transmit Good Octet Counter Interrupt Status */
    const uint32_t  txgfrmis           :  1;  /* MMC Transmit Good Frame Counter Interrupt Status */
    const uint32_t  txexdeffis         :  1;  /* MMC Transmit Excessive Deferral Frame Counter Interrupt Status */
    const uint32_t  txpausfis          :  1;  /* MMC Transmit Pause Frame Counter Interrupt Status */
    const uint32_t  txvlangfis         :  1;  /* MMC Transmit VLAN Good Frame Counter Interrupt Status */
    const uint32_t  txosizegfis        :  1;  /* MMC Transmit Oversize Good Frame Counter Interrupt Status */
    uint32_t                           :  6;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_TX_INT. */
typedef volatile struct ALT_EMAC_GMAC_MMC_TX_INT_s  ALT_EMAC_GMAC_MMC_TX_INT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MMC_TX_INT register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_TX_INT_OFST        0x108
/* The address of the ALT_EMAC_GMAC_MMC_TX_INT register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_TX_INT_OFST))

/*
 * Register : Register 67 (MMC Receive Interrupt Mask Register) - MMC_Receive_Interrupt_Mask
 * 
 * The MMC Receive Interrupt Mask register maintains the masks for the interrupts
 * generated when the receive statistic counters reach half of their maximum value,
 * or maximum value. This register is 32-bits wide.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                                            
 * :--------|:-------|:------|:------------------------------------------------------------------------
 *  [0]     | RW     | 0x0   | MMC Receive Good Bad Frame Counter Interrupt Mask                      
 *  [1]     | RW     | 0x0   | MMC Receive Good Bad Octet Counter Interrupt Mask                      
 *  [2]     | RW     | 0x0   | MMC Receive Good Octet Counter Interrupt Mask                          
 *  [3]     | RW     | 0x0   | MMC Receive Broadcast Good Frame Counter Interrupt Mask                
 *  [4]     | RW     | 0x0   | MMC Receive Multicast Good Frame Counter Interrupt Mask                
 *  [5]     | RW     | 0x0   | MMC Receive CRC Error Frame Counter Interrupt Mask                     
 *  [6]     | RW     | 0x0   | MMC Receive Alignment Error Frame Counter Interrupt Mask               
 *  [7]     | RW     | 0x0   | MMC Receive Runt Frame Counter Interrupt Mask                          
 *  [8]     | RW     | 0x0   | MMC Receive Jabber Error Frame Counter Interrupt Mask                  
 *  [9]     | RW     | 0x0   | MMC Receive Undersize Good Frame Counter Interrupt Mask                
 *  [10]    | RW     | 0x0   | MMC Receive Oversize Good Frame Counter Interrupt Mask                 
 *  [11]    | RW     | 0x0   | MMC Receive 64 Octet Good Bad Frame Counter Interrupt Mask             
 *  [12]    | RW     | 0x0   | MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Mask      
 *  [13]    | RW     | 0x0   | MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Mask     
 *  [14]    | RW     | 0x0   | MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Mask     
 *  [15]    | RW     | 0x0   | MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask    
 *  [16]    | RW     | 0x0   | MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask
 *  [17]    | RW     | 0x0   | MMC Receive Unicast Good Frame Counter Interrupt Mask                  
 *  [18]    | RW     | 0x0   | MMC Receive Length Error Frame Counter Interrupt Mask                  
 *  [19]    | RW     | 0x0   | MMC Receive Out Of Range Error Frame Counter Interrupt  Mask           
 *  [20]    | RW     | 0x0   | MMC Receive Pause Frame Counter Interrupt Mask                         
 *  [21]    | RW     | 0x0   | MMC Receive FIFO Overflow Frame Counter Interrupt Mask                 
 *  [22]    | RW     | 0x0   | MMC Receive VLAN Good Bad Frame Counter Interrupt Mask                 
 *  [23]    | RW     | 0x0   | MMC Receive Watchdog Error Frame Counter Interrupt Mask                
 *  [24]    | RW     | 0x0   | MMC Receive Error Frame Counter Interrupt Mask                         
 *  [25]    | RW     | 0x0   | MMC Receive Control Frame Counter Interrupt Mask                       
 *  [31:26] | ???    | 0x0   | *UNDEFINED*                                                            
 * 
 */
/*
 * Field : MMC Receive Good Bad Frame Counter Interrupt Mask - rxgbfrmim
 * 
 * Setting this bit masks the interrupt when the rxframecount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBFRMIM_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : MMC Receive Good Bad Octet Counter Interrupt Mask - rxgboctim
 * 
 * Setting this bit masks the interrupt when the rxoctetcount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GBOCTIM_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : MMC Receive Good Octet Counter Interrupt Mask - rxgoctim
 * 
 * Setting this bit masks the interrupt when the rxoctetcount_g counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_GOCTIM_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : MMC Receive Broadcast Good Frame Counter Interrupt Mask - rxbcgfim
 * 
 * Setting this bit masks the interrupt when the rxbroadcastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_BCGFIM_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : MMC Receive Multicast Good Frame Counter Interrupt Mask - rxmcgfim
 * 
 * Setting this bit masks the interrupt when the rxmulticastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_MCGFIM_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : MMC Receive CRC Error Frame Counter Interrupt Mask - rxcrcerfim
 * 
 * Setting this bit masks the interrupt when the rxcrcerror counter reaches half of
 * the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CRCERFIM_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : MMC Receive Alignment Error Frame Counter Interrupt Mask - rxalgnerfim
 * 
 * Setting this bit masks the interrupt when the rxalignmenterror counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ALGNERFIM_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : MMC Receive Runt Frame Counter Interrupt Mask - rxruntfim
 * 
 * Setting this bit masks the interrupt when the rxrunterror counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RUNTFIM_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : MMC Receive Jabber Error Frame Counter Interrupt Mask - rxjaberfim
 * 
 * Setting this bit masks the interrupt when the rxjabbererror counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_JABERFIM_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : MMC Receive Undersize Good Frame Counter Interrupt Mask - rxusizegfim
 * 
 * Setting this bit masks the interrupt when the rxundersize_g counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_USIZEGFIM_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : MMC Receive Oversize Good Frame Counter Interrupt Mask - rxosizegfim
 * 
 * Setting this bit masks the interrupt when the rxoversize_g counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OSIZEGFIM_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : MMC Receive 64 Octet Good Bad Frame Counter Interrupt Mask - rx64octgbfim
 * 
 * Setting this bit masks the interrupt when the rx64octets_gb counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                | Value | Description               
 * :----------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_64OCTGBFIM_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Mask - rx65t127octgbfim
 * 
 * Setting this bit masks the interrupt when the rx65to127octets_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                    | Value | Description               
 * :--------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_65T127OCTGBFIM_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Mask - rx128t255octgbfim
 * 
 * Setting this bit masks the interrupt when the rx128to255octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description               
 * :---------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_128T255OCTGBFIM_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Mask - rx256t511octgbfim
 * 
 * Setting this bit masks the interrupt when the rx256to511octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description               
 * :---------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_256T511OCTGBFIM_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask - rx512t1023octgbfim
 * 
 * Setting this bit masks the interrupt when the rx512to1023octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description               
 * :----------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_512T1023OCTGBFIM_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask - rx1024tmaxoctgbfim
 * 
 * Setting this bit masks the interrupt when the rx1024tomaxoctets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description               
 * :----------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_1024TMAXOCTGBFIM_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : MMC Receive Unicast Good Frame Counter Interrupt Mask - rxucgfim
 * 
 * Setting this bit masks the interrupt when the rxunicastframes_g counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_UCGFIM_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : MMC Receive Length Error Frame Counter Interrupt Mask - rxlenerfim
 * 
 * Setting this bit masks the interrupt when the rxlengtherror counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_LENERFIM_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : MMC Receive Out Of Range Error Frame Counter Interrupt  Mask - rxorangefim
 * 
 * Setting this bit masks the interrupt when the rxoutofrangetype counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ORANGEFIM_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : MMC Receive Pause Frame Counter Interrupt Mask - rxpausfim
 * 
 * Setting this bit masks the interrupt when the rxpauseframes counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_PAUSFIM_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : MMC Receive FIFO Overflow Frame Counter Interrupt Mask - rxfovfim
 * 
 * Setting this bit masks the interrupt when the rxfifooverflow counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_FOVFIM_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : MMC Receive VLAN Good Bad Frame Counter Interrupt Mask - rxvlangbfim
 * 
 * Setting this bit masks the interrupt when the rxvlanframes_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_VLANGBFIM_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : MMC Receive Watchdog Error Frame Counter Interrupt Mask - rxwdogfim
 * 
 * Setting this bit masks the interrupt when the rxwatchdog counter reaches half of
 * the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_WDOGFIM_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : MMC Receive Error Frame Counter Interrupt Mask - rxrcverrfim
 * 
 * Setting this bit masks the interrupt when the rxrcverror error counter reaches
 * half the maximum value, and also when it reaches the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_RCVERRFIM_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : MMC Receive Control Frame Counter Interrupt Mask - rxctrlfim
 * 
 * Setting this bit masks the interrupt when the rxctrlframes counter reaches half
 * the maximum value, and also when it reaches the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_CTLFIM_SET(value) (((value) << 25) & 0x02000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_RX_INT_MSK.
 */
struct ALT_EMAC_GMAC_MMC_RX_INT_MSK_s
{
    uint32_t  rxgbfrmim          :  1;  /* MMC Receive Good Bad Frame Counter Interrupt Mask */
    uint32_t  rxgboctim          :  1;  /* MMC Receive Good Bad Octet Counter Interrupt Mask */
    uint32_t  rxgoctim           :  1;  /* MMC Receive Good Octet Counter Interrupt Mask */
    uint32_t  rxbcgfim           :  1;  /* MMC Receive Broadcast Good Frame Counter Interrupt Mask */
    uint32_t  rxmcgfim           :  1;  /* MMC Receive Multicast Good Frame Counter Interrupt Mask */
    uint32_t  rxcrcerfim         :  1;  /* MMC Receive CRC Error Frame Counter Interrupt Mask */
    uint32_t  rxalgnerfim        :  1;  /* MMC Receive Alignment Error Frame Counter Interrupt Mask */
    uint32_t  rxruntfim          :  1;  /* MMC Receive Runt Frame Counter Interrupt Mask */
    uint32_t  rxjaberfim         :  1;  /* MMC Receive Jabber Error Frame Counter Interrupt Mask */
    uint32_t  rxusizegfim        :  1;  /* MMC Receive Undersize Good Frame Counter Interrupt Mask */
    uint32_t  rxosizegfim        :  1;  /* MMC Receive Oversize Good Frame Counter Interrupt Mask */
    uint32_t  rx64octgbfim       :  1;  /* MMC Receive 64 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  rx65t127octgbfim   :  1;  /* MMC Receive 65 to 127 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  rx128t255octgbfim  :  1;  /* MMC Receive 128 to 255 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  rx256t511octgbfim  :  1;  /* MMC Receive 256 to 511 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  rx512t1023octgbfim :  1;  /* MMC Receive 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  rx1024tmaxoctgbfim :  1;  /* MMC Receive 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  rxucgfim           :  1;  /* MMC Receive Unicast Good Frame Counter Interrupt Mask */
    uint32_t  rxlenerfim         :  1;  /* MMC Receive Length Error Frame Counter Interrupt Mask */
    uint32_t  rxorangefim        :  1;  /* MMC Receive Out Of Range Error Frame Counter Interrupt  Mask */
    uint32_t  rxpausfim          :  1;  /* MMC Receive Pause Frame Counter Interrupt Mask */
    uint32_t  rxfovfim           :  1;  /* MMC Receive FIFO Overflow Frame Counter Interrupt Mask */
    uint32_t  rxvlangbfim        :  1;  /* MMC Receive VLAN Good Bad Frame Counter Interrupt Mask */
    uint32_t  rxwdogfim          :  1;  /* MMC Receive Watchdog Error Frame Counter Interrupt Mask */
    uint32_t  rxrcverrfim        :  1;  /* MMC Receive Error Frame Counter Interrupt Mask */
    uint32_t  rxctrlfim          :  1;  /* MMC Receive Control Frame Counter Interrupt Mask */
    uint32_t                     :  6;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_RX_INT_MSK. */
typedef volatile struct ALT_EMAC_GMAC_MMC_RX_INT_MSK_s  ALT_EMAC_GMAC_MMC_RX_INT_MSK_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MMC_RX_INT_MSK register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_OFST        0x10c
/* The address of the ALT_EMAC_GMAC_MMC_RX_INT_MSK register. */
#define ALT_EMAC_GMAC_MMC_RX_INT_MSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_RX_INT_MSK_OFST))

/*
 * Register : Register 68 (MMC Transmit Interrupt Mask Register) - MMC_Transmit_Interrupt_Mask
 * 
 * The MMC Transmit Interrupt Mask register maintains the masks for the interrupts
 * generated when the transmit statistic counters reach half of their maximum value
 * or maximum value. This register is 32-bits wide.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                                             
 * :--------|:-------|:------|:-------------------------------------------------------------------------
 *  [0]     | RW     | 0x0   | MMC Transmit Good Bad Octet Counter Interrupt Mask                      
 *  [1]     | RW     | 0x0   | MMC Transmit Good Bad Frame Counter Interrupt Mask                      
 *  [2]     | RW     | 0x0   | MMC Transmit Broadcast Good Frame Counter Interrupt Mask                
 *  [3]     | RW     | 0x0   | MMC Transmit Multicast Good Frame Counter Interrupt Mask                
 *  [4]     | RW     | 0x0   | MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Mask             
 *  [5]     | RW     | 0x0   | MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Mask      
 *  [6]     | RW     | 0x0   | MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Mask     
 *  [7]     | RW     | 0x0   | MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Mask     
 *  [8]     | RW     | 0x0   | MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask    
 *  [9]     | RW     | 0x0   | MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask
 *  [10]    | RW     | 0x0   | MMC Transmit Unicast Good Bad Frame Counter Interrupt Mask              
 *  [11]    | RW     | 0x0   | MMC Transmit Multicast Good Bad Frame Counter Interrupt Mask            
 *  [12]    | RW     | 0x0   | MMC Transmit Broadcast Good Bad Frame Counter Interrupt Mask            
 *  [13]    | RW     | 0x0   | MMC Transmit Underflow Error Frame Counter Interrupt Mask               
 *  [14]    | RW     | 0x0   | MMC Transmit Single Collision Good Frame Counter Interrupt Mask         
 *  [15]    | RW     | 0x0   | MMC Transmit Multiple Collision Good Frame Counter Interrupt Mask       
 *  [16]    | RW     | 0x0   | MMC Transmit Deferred Frame Counter Interrupt Mask                      
 *  [17]    | RW     | 0x0   | MMC Transmit Late Collision Frame Counter Interrupt Mask                
 *  [18]    | RW     | 0x0   | MMC Transmit Excessive Collision Frame Counter Interrupt Mask           
 *  [19]    | RW     | 0x0   | MMC Transmit Carrier Error Frame Counter Interrupt Mask                 
 *  [20]    | RW     | 0x0   | MMC Transmit Good Octet Counter Interrupt Mask                          
 *  [21]    | RW     | 0x0   | MMC Transmit Good Frame Counter Interrupt Mask                          
 *  [22]    | RW     | 0x0   | MMC Transmit Excessive Deferral Frame Counter Interrupt Mask            
 *  [23]    | RW     | 0x0   | MMC Transmit Pause Frame Counter Interrupt Mask                         
 *  [24]    | RW     | 0x0   | MMC Transmit VLAN Good Frame Counter Interrupt Mask                     
 *  [25]    | RW     | 0x0   | MMC Transmit Oversize Good Frame Counter Interrupt Mask                 
 *  [31:26] | ???    | 0x0   | *UNDEFINED*                                                             
 * 
 */
/*
 * Field : MMC Transmit Good Bad Octet Counter Interrupt Mask - txgboctim
 * 
 * Setting this bit masks the interrupt when the txoctetcount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_MSB        0
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_SET_MSK    0x00000001
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_CLR_MSK    0xfffffffe
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBOCTIM_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : MMC Transmit Good Bad Frame Counter Interrupt Mask - txgbfrmim
 * 
 * Setting this bit masks the interrupt when the txframecount_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_MSB        1
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_SET_MSK    0x00000002
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_CLR_MSK    0xfffffffd
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GBFRMIM_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : MMC Transmit Broadcast Good Frame Counter Interrupt Mask - txbcgfim
 * 
 * Setting this bit masks the interrupt when the txbroadcastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_MSB        2
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_SET_MSK    0x00000004
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_CLR_MSK    0xfffffffb
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGFIM_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : MMC Transmit Multicast Good Frame Counter Interrupt Mask - txmcgfim
 * 
 * Setting this bit masks the interrupt when the txmulticastframes_g counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_MSB        3
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_SET_MSK    0x00000008
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_CLR_MSK    0xfffffff7
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGFIM_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Mask - tx64octgbfim
 * 
 * Setting this bit masks the interrupt when the tx64octets_gb counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                | Value | Description               
 * :----------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_MSB        4
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_SET_MSK    0x00000010
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_CLR_MSK    0xffffffef
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_64OCTGBFIM_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Mask - tx65t127octgbfim
 * 
 * Setting this bit masks the interrupt when the tx65to127octets_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                    | Value | Description               
 * :--------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_MSB        5
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_SET_MSK    0x00000020
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_CLR_MSK    0xffffffdf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_65T127OCTGBFIM_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Mask - tx128t255octgbfim
 * 
 * Setting this bit masks the interrupt when the tx128to255octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description               
 * :---------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_MSB        6
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_SET_MSK    0x00000040
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_CLR_MSK    0xffffffbf
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_128T255OCTGBFIM_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Mask - tx256t511octgbfim
 * 
 * Setting this bit masks the interrupt when the tx256to511octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                     | Value | Description               
 * :---------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_MSB        7
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_SET_MSK    0x00000080
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_CLR_MSK    0xffffff7f
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_256T511OCTGBFIM_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask - tx512t1023octgbfim
 * 
 * Setting this bit masks the interrupt when the tx512to1023octets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description               
 * :----------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_MSB        8
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_SET_MSK    0x00000100
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_CLR_MSK    0xfffffeff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_512T1023OCTGBFIM_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask - tx1024tmaxoctgbfim
 * 
 * Setting this bit masks the interrupt when the tx1024tomaxoctets_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                      | Value | Description               
 * :----------------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_MSB        9
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_SET_MSK    0x00000200
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_CLR_MSK    0xfffffdff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_1024TMAXOCTGBFIM_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : MMC Transmit Unicast Good Bad Frame Counter Interrupt Mask - txucgbfim
 * 
 * Setting this bit masks the interrupt when the txunicastframes_gb counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_MSB        10
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_SET_MSK    0x00000400
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_CLR_MSK    0xfffffbff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UCGBFIM_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : MMC Transmit Multicast Good Bad Frame Counter Interrupt Mask - txmcgbfim
 * 
 * Setting this bit masks the interrupt when the txmulticastframes_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_MSB        11
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_SET_MSK    0x00000800
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCGBFIM_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : MMC Transmit Broadcast Good Bad Frame Counter Interrupt Mask - txbcgbfim
 * 
 * Setting this bit masks the interrupt when the txbroadcastframes_gb counter
 * reaches half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_MSB        12
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_SET_MSK    0x00001000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_CLR_MSK    0xffffefff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_BCGBFIM_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : MMC Transmit Underflow Error Frame Counter Interrupt Mask - txuflowerfim
 * 
 * Setting this bit masks the interrupt when the txunderflowerror counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                | Value | Description               
 * :----------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_MSB        13
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_SET_MSK    0x00002000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_CLR_MSK    0xffffdfff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_UFLOWERFIM_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : MMC Transmit Single Collision Good Frame Counter Interrupt Mask - txscolgfim
 * 
 * Setting this bit masks the interrupt when the txsinglecol_g counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_MSB        14
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_SET_MSK    0x00004000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_CLR_MSK    0xffffbfff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_SCOLGFIM_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : MMC Transmit Multiple Collision Good Frame Counter Interrupt Mask - txmcolgfim
 * 
 * Setting this bit masks the interrupt when the txmulticol_g counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_MSB        15
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_SET_MSK    0x00008000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_CLR_MSK    0xffff7fff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_MCOLGFIM_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : MMC Transmit Deferred Frame Counter Interrupt Mask - txdeffim
 * 
 * Setting this bit masks the interrupt when the txdeferred counter reaches half of
 * the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_MSB        16
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_SET_MSK    0x00010000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_CLR_MSK    0xfffeffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_DEFFIM_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : MMC Transmit Late Collision Frame Counter Interrupt Mask - txlatcolfim
 * 
 * Setting this bit masks the interrupt when the txlatecol counter reaches half of
 * the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_MSB        17
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_SET_MSK    0x00020000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_CLR_MSK    0xfffdffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_LATCOLFIM_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : MMC Transmit Excessive Collision Frame Counter Interrupt Mask - txexcolfim
 * 
 * Setting this bit masks the interrupt when the txexcesscol counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_MSB        18
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_SET_MSK    0x00040000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_CLR_MSK    0xfffbffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXCOLFIM_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : MMC Transmit Carrier Error Frame Counter Interrupt Mask - txcarerfim
 * 
 * Setting this bit masks the interrupt when the txcarriererror counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_MSB        19
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_SET_MSK    0x00080000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_CARERFIM_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : MMC Transmit Good Octet Counter Interrupt Mask - txgoctim
 * 
 * Setting this bit masks the interrupt when the txoctetcount_g counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_MSB        20
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_SET_MSK    0x00100000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_CLR_MSK    0xffefffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GOCTIM_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : MMC Transmit Good Frame Counter Interrupt Mask - txgfrmim
 * 
 * Setting this bit masks the interrupt when the txframecount_g counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description               
 * :------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_E_NOMSKINTR 0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_E_MSKINTR   0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_MSB        21
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_SET_MSK    0x00200000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_CLR_MSK    0xffdfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_GFRMIM_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : MMC Transmit Excessive Deferral Frame Counter Interrupt Mask - txexdeffim
 * 
 * Setting this bit masks the interrupt when the txexcessdef counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_MSB        22
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_SET_MSK    0x00400000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_CLR_MSK    0xffbfffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_EXDEFFIM_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : MMC Transmit Pause Frame Counter Interrupt Mask - txpausfim
 * 
 * Setting this bit masks the interrupt when the txpauseframes counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                             | Value | Description               
 * :-------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_E_NOMSKINTR    0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_E_MSKINTR      0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_MSB        23
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_SET_MSK    0x00800000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_CLR_MSK    0xff7fffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_PAUSFIM_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : MMC Transmit VLAN Good Frame Counter Interrupt Mask - txvlangfim
 * 
 * Setting this bit masks the interrupt when the txvlanframes_g counter reaches
 * half of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description               
 * :--------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_E_NOMSKINTR   0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_E_MSKINTR     0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_MSB        24
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_SET_MSK    0x01000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_CLR_MSK    0xfeffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_VLANGFIM_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : MMC Transmit Oversize Good Frame Counter Interrupt Mask - txosizegfim
 * 
 * Setting this bit masks the interrupt when the txoversize_g counter reaches half
 * of the maximum value or the maximum value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description               
 * :---------------------------------------------------|:------|:---------------------------
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_E_NOMSKINTR | 0x0   | counter < half max        
 *  ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_E_MSKINTR   | 0x1   | counter >= half max or max
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM
 * 
 * counter < half max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_E_NOMSKINTR  0x0
/*
 * Enumerated value for register field ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM
 * 
 * counter >= half max or max
 */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_E_MSKINTR    0x1

/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_MSB        25
/* The width in bits of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_WIDTH      1
/* The mask used to set the ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_SET_MSK    0x02000000
/* The mask used to clear the ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM register field value. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_CLR_MSK    0xfdffffff
/* The reset value of the ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM register field. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM field value from a register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OSIZEGFIM_SET(value) (((value) << 25) & 0x02000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_MMC_TX_INT_MSK.
 */
struct ALT_EMAC_GMAC_MMC_TX_INT_MSK_s
{
    uint32_t  txgboctim          :  1;  /* MMC Transmit Good Bad Octet Counter Interrupt Mask */
    uint32_t  txgbfrmim          :  1;  /* MMC Transmit Good Bad Frame Counter Interrupt Mask */
    uint32_t  txbcgfim           :  1;  /* MMC Transmit Broadcast Good Frame Counter Interrupt Mask */
    uint32_t  txmcgfim           :  1;  /* MMC Transmit Multicast Good Frame Counter Interrupt Mask */
    uint32_t  tx64octgbfim       :  1;  /* MMC Transmit 64 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  tx65t127octgbfim   :  1;  /* MMC Transmit 65 to 127 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  tx128t255octgbfim  :  1;  /* MMC Transmit 128 to 255 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  tx256t511octgbfim  :  1;  /* MMC Transmit 256 to 511 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  tx512t1023octgbfim :  1;  /* MMC Transmit 512 to 1023 Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  tx1024tmaxoctgbfim :  1;  /* MMC Transmit 1024 to Maximum Octet Good Bad Frame Counter Interrupt Mask */
    uint32_t  txucgbfim          :  1;  /* MMC Transmit Unicast Good Bad Frame Counter Interrupt Mask */
    uint32_t  txmcgbfim          :  1;  /* MMC Transmit Multicast Good Bad Frame Counter Interrupt Mask */
    uint32_t  txbcgbfim          :  1;  /* MMC Transmit Broadcast Good Bad Frame Counter Interrupt Mask */
    uint32_t  txuflowerfim       :  1;  /* MMC Transmit Underflow Error Frame Counter Interrupt Mask */
    uint32_t  txscolgfim         :  1;  /* MMC Transmit Single Collision Good Frame Counter Interrupt Mask */
    uint32_t  txmcolgfim         :  1;  /* MMC Transmit Multiple Collision Good Frame Counter Interrupt Mask */
    uint32_t  txdeffim           :  1;  /* MMC Transmit Deferred Frame Counter Interrupt Mask */
    uint32_t  txlatcolfim        :  1;  /* MMC Transmit Late Collision Frame Counter Interrupt Mask */
    uint32_t  txexcolfim         :  1;  /* MMC Transmit Excessive Collision Frame Counter Interrupt Mask */
    uint32_t  txcarerfim         :  1;  /* MMC Transmit Carrier Error Frame Counter Interrupt Mask */
    uint32_t  txgoctim           :  1;  /* MMC Transmit Good Octet Counter Interrupt Mask */
    uint32_t  txgfrmim           :  1;  /* MMC Transmit Good Frame Counter Interrupt Mask */
    uint32_t  txexdeffim         :  1;  /* MMC Transmit Excessive Deferral Frame Counter Interrupt Mask */
    uint32_t  txpausfim          :  1;  /* MMC Transmit Pause Frame Counter Interrupt Mask */
    uint32_t  txvlangfim         :  1;  /* MMC Transmit VLAN Good Frame Counter Interrupt Mask */
    uint32_t  txosizegfim        :  1;  /* MMC Transmit Oversize Good Frame Counter Interrupt Mask */
    uint32_t                     :  6;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_EMAC_GMAC_MMC_TX_INT_MSK. */
typedef volatile struct ALT_EMAC_GMAC_MMC_TX_INT_MSK_s  ALT_EMAC_GMAC_MMC_TX_INT_MSK_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_MMC_TX_INT_MSK register from the beginning of the component. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_OFST        0x110
/* The address of the ALT_EMAC_GMAC_MMC_TX_INT_MSK register. */
#define ALT_EMAC_GMAC_MMC_TX_INT_MSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_MMC_TX_INT_MSK_OFST))

/*
 * Register : Register 69 (txoctetcount_gb Register) - txoctetcount_gb
 * 
 * Number of bytes transmitted, exclusive of preamble and retried bytes, in good
 * and bad frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description    
 * :-------|:-------|:------|:----------------
 *  [31:0] | R      | 0x0   | txoctetcount_gb
 * 
 */
/*
 * Field : txoctetcount_gb - cnt
 * 
 * Number of bytes transmitted, exclusive of preamble and retried bytes, in good
 * and bad frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TXOCTETCOUNT_GB.
 */
struct ALT_EMAC_GMAC_TXOCTETCOUNT_GB_s
{
    const uint32_t  cnt : 32;  /* txoctetcount_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TXOCTETCOUNT_GB. */
typedef volatile struct ALT_EMAC_GMAC_TXOCTETCOUNT_GB_s  ALT_EMAC_GMAC_TXOCTETCOUNT_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TXOCTETCOUNT_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_OFST        0x114
/* The address of the ALT_EMAC_GMAC_TXOCTETCOUNT_GB register. */
#define ALT_EMAC_GMAC_TXOCTETCOUNT_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TXOCTETCOUNT_GB_OFST))

/*
 * Register : Register 70 (txframecount_gb Register) - txframecount_gb
 * 
 * Number of good and bad frames transmitted, exclusive of retried frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description    
 * :-------|:-------|:------|:----------------
 *  [31:0] | R      | 0x0   | txframecount_gb
 * 
 */
/*
 * Field : txframecount_gb - cnt
 * 
 * Number of good and bad frames transmitted, exclusive of retried frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT register field. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TXFRMCOUNT_GB.
 */
struct ALT_EMAC_GMAC_TXFRMCOUNT_GB_s
{
    const uint32_t  cnt : 32;  /* txframecount_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TXFRMCOUNT_GB. */
typedef volatile struct ALT_EMAC_GMAC_TXFRMCOUNT_GB_s  ALT_EMAC_GMAC_TXFRMCOUNT_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TXFRMCOUNT_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_OFST        0x118
/* The address of the ALT_EMAC_GMAC_TXFRMCOUNT_GB register. */
#define ALT_EMAC_GMAC_TXFRMCOUNT_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TXFRMCOUNT_GB_OFST))

/*
 * Register : Register 71 (txbroadcastframes_g Register) - txbroadcastframes_g
 * 
 * Number of good broadcast frames transmitted
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description        
 * :-------|:-------|:------|:--------------------
 *  [31:0] | R      | 0x0   | txbroadcastframes_g
 * 
 */
/*
 * Field : txbroadcastframes_g - cnt
 * 
 * Number of good broadcast frames transmitted
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT register field value. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT register field value. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT field value from a register. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TXBCASTFRMS_G.
 */
struct ALT_EMAC_GMAC_TXBCASTFRMS_G_s
{
    const uint32_t  cnt : 32;  /* txbroadcastframes_g */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TXBCASTFRMS_G. */
typedef volatile struct ALT_EMAC_GMAC_TXBCASTFRMS_G_s  ALT_EMAC_GMAC_TXBCASTFRMS_G_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TXBCASTFRMS_G register from the beginning of the component. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_OFST        0x11c
/* The address of the ALT_EMAC_GMAC_TXBCASTFRMS_G register. */
#define ALT_EMAC_GMAC_TXBCASTFRMS_G_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TXBCASTFRMS_G_OFST))

/*
 * Register : Register 72 (txmulticastframes_g Register) - txmulticastframes_g
 * 
 * Number of good multicast frames transmitted
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description        
 * :-------|:-------|:------|:--------------------
 *  [31:0] | R      | 0x0   | txmulticastframes_g
 * 
 */
/*
 * Field : txmulticastframes_g - cnt
 * 
 * Number of good multicast frames transmitted
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT register field value. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT register field value. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT register field. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT field value from a register. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TXMCASTFRMS_G.
 */
struct ALT_EMAC_GMAC_TXMCASTFRMS_G_s
{
    const uint32_t  cnt : 32;  /* txmulticastframes_g */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TXMCASTFRMS_G. */
typedef volatile struct ALT_EMAC_GMAC_TXMCASTFRMS_G_s  ALT_EMAC_GMAC_TXMCASTFRMS_G_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TXMCASTFRMS_G register from the beginning of the component. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_OFST        0x120
/* The address of the ALT_EMAC_GMAC_TXMCASTFRMS_G register. */
#define ALT_EMAC_GMAC_TXMCASTFRMS_G_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TXMCASTFRMS_G_OFST))

/*
 * Register : Register 73 (tx64octets_gb Register) - tx64octets_gb
 * 
 * Number of good and bad frames transmitted with length 64 bytes, exclusive of
 * preamble and retried frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description  
 * :-------|:-------|:------|:--------------
 *  [31:0] | R      | 0x0   | tx64octets_gb
 * 
 */
/*
 * Field : tx64octets_gb - cnt
 * 
 * Number of good and bad frames transmitted with length 64 bytes, exclusive of
 * preamble and retried frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TX64OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TX64OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TX64OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TX64OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TX64OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TX64OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TX64OCTETS_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TX64OCTETS_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TX64OCTETS_GB.
 */
struct ALT_EMAC_GMAC_TX64OCTETS_GB_s
{
    const uint32_t  cnt : 32;  /* tx64octets_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TX64OCTETS_GB. */
typedef volatile struct ALT_EMAC_GMAC_TX64OCTETS_GB_s  ALT_EMAC_GMAC_TX64OCTETS_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TX64OCTETS_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_OFST        0x124
/* The address of the ALT_EMAC_GMAC_TX64OCTETS_GB register. */
#define ALT_EMAC_GMAC_TX64OCTETS_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TX64OCTETS_GB_OFST))

/*
 * Register : Register 74 (tx65to127octets_gb Register) - tx65to127octets_gb
 * 
 * Number of good and bad frames transmitted with length between 65 and 127
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description       
 * :-------|:-------|:------|:-------------------
 *  [31:0] | R      | 0x0   | tx65to127octets_gb
 * 
 */
/*
 * Field : tx65to127octets_gb - cnt
 * 
 * Number of good and bad frames transmitted with length between 65 and 127
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TX65TO127OCTETS_GB.
 */
struct ALT_EMAC_GMAC_TX65TO127OCTETS_GB_s
{
    const uint32_t  cnt : 32;  /* tx65to127octets_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TX65TO127OCTETS_GB. */
typedef volatile struct ALT_EMAC_GMAC_TX65TO127OCTETS_GB_s  ALT_EMAC_GMAC_TX65TO127OCTETS_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TX65TO127OCTETS_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_OFST        0x128
/* The address of the ALT_EMAC_GMAC_TX65TO127OCTETS_GB register. */
#define ALT_EMAC_GMAC_TX65TO127OCTETS_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TX65TO127OCTETS_GB_OFST))

/*
 * Register : Register 75 (tx128to255octets_gb Register) - tx128to255octets_gb
 * 
 * Number of good and bad frames transmitted with length between 128 and 255
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description        
 * :-------|:-------|:------|:--------------------
 *  [31:0] | R      | 0x0   | tx128to255octets_gb
 * 
 */
/*
 * Field : tx128to255octets_gb - cnt
 * 
 * Number of good and bad frames transmitted with length between 128 and 255
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TX128TO255OCTETS_GB.
 */
struct ALT_EMAC_GMAC_TX128TO255OCTETS_GB_s
{
    const uint32_t  cnt : 32;  /* tx128to255octets_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TX128TO255OCTETS_GB. */
typedef volatile struct ALT_EMAC_GMAC_TX128TO255OCTETS_GB_s  ALT_EMAC_GMAC_TX128TO255OCTETS_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TX128TO255OCTETS_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_OFST        0x12c
/* The address of the ALT_EMAC_GMAC_TX128TO255OCTETS_GB register. */
#define ALT_EMAC_GMAC_TX128TO255OCTETS_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TX128TO255OCTETS_GB_OFST))

/*
 * Register : Register 76 (tx256to511octets_gb Register) - tx256to511octets_gb
 * 
 * Number of good and bad frames transmitted with length between 256 and 511
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description        
 * :-------|:-------|:------|:--------------------
 *  [31:0] | R      | 0x0   | tx256to511octets_gb
 * 
 */
/*
 * Field : tx256to511octets_gb - cnt
 * 
 * Number of good and bad frames transmitted with length between 256 and 511
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TX256TO511OCTETS_GB.
 */
struct ALT_EMAC_GMAC_TX256TO511OCTETS_GB_s
{
    const uint32_t  cnt : 32;  /* tx256to511octets_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TX256TO511OCTETS_GB. */
typedef volatile struct ALT_EMAC_GMAC_TX256TO511OCTETS_GB_s  ALT_EMAC_GMAC_TX256TO511OCTETS_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TX256TO511OCTETS_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_OFST        0x130
/* The address of the ALT_EMAC_GMAC_TX256TO511OCTETS_GB register. */
#define ALT_EMAC_GMAC_TX256TO511OCTETS_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TX256TO511OCTETS_GB_OFST))

/*
 * Register : Register 77 (tx512to1023octets_gb Register) - tx512to1023octets_gb
 * 
 * Number of good and bad frames transmitted with length between 512 and 1,023
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description         
 * :-------|:-------|:------|:---------------------
 *  [31:0] | R      | 0x0   | tx512to1023octets_gb
 * 
 */
/*
 * Field : tx512to1023octets_gb - cnt
 * 
 * Number of good and bad frames transmitted with length between 512 and 1,023
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TX512TO1023OCTETS_GB.
 */
struct ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_s
{
    const uint32_t  cnt : 32;  /* tx512to1023octets_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TX512TO1023OCTETS_GB. */
typedef volatile struct ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_s  ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_OFST        0x134
/* The address of the ALT_EMAC_GMAC_TX512TO1023OCTETS_GB register. */
#define ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TX512TO1023OCTETS_GB_OFST))

/*
 * Register : Register 78 (tx1024tomaxoctets_gb Register) - tx1024tomaxoctets_gb
 * 
 * Number of good and bad frames transmitted with length between 1,024 and maxsize
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description         
 * :-------|:-------|:------|:---------------------
 *  [31:0] | R      | 0x0   | tx1024tomaxoctets_gb
 * 
 */
/*
 * Field : tx1024tomaxoctets_gb - cnt
 * 
 * Number of good and bad frames transmitted with length between 1,024 and maxsize
 * (inclusive) bytes, exclusive of preamble and retried frames
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_MSB        31
/* The width in bits of the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_WIDTH      32
/* The mask used to set the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_SET_MSK    0xffffffff
/* The mask used to clear the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT register field value. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_CLR_MSK    0x00000000
/* The reset value of the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_RESET      0x0
/* Extracts the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT field value from a register. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT register field value suitable for setting the register. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_CNT_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB.
 */
struct ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_s
{
    const uint32_t  cnt : 32;  /* tx1024tomaxoctets_gb */
};

/* The typedef declaration for register ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB. */
typedef volatile struct ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_s  ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB register from the beginning of the component. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_OFST        0x138
/* The address of the ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB register. */
#define ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_EMAC_GMAC_TX1024TOMAXOCTETS_GB_OFST))

/*
 * Register : Register 79 (txunicastframes_gb Register) - txunicastframes_gb
 * 
 * Number of good and bad unicast frames transmitted
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description       
 * :-------|:-------|:------|:-------------------
 *  [31:0] | R      | 0x0   | txunicastframes_gb
 * 
 */
/*
 * Field : txunicastframes_gb - cnt
 * 
 * Number of good and bad unicast frames transmitted
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_EMAC_GMAC_TXUNICASTFRMS_GB_CNT register field. */
#define ALT_EMAC_GMAC_TX