/*******************************************************************************
*                                                                              *
* Copyright 2013 Altera Corporation. All Rights Reserved.                      *
*                                                                              *
* Redistribution and use in source and binary forms, with or without           *
* modification, are permitted provided that the following conditions are met:  *
*                                                                              *
* 1. Redistributions of source code must retain the above copyright notice,    *
*    this list of conditions and the following disclaimer.                     *
*                                                                              *
* 2. Redistributions in binary form must reproduce the above copyright notice, *
*    this list of conditions and the following disclaimer in the documentation *
*    and/or other materials provided with the distribution.                    *
*                                                                              *
* 3. The name of the author may not be used to endorse or promote products     *
*    derived from this software without specific prior written permission.     *
*                                                                              *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY EXPRESS OR *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE DISCLAIMED. IN NO  *
* EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       *
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;  *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,     *
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR      *
* OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF       *
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                   *
*                                                                              *
*******************************************************************************/

/* Altera - ALT_USB */

#ifndef __ALTERA_ALT_USB_H__
#define __ALTERA_ALT_USB_H__

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

/*
 * Component : USB OTG Controller Module Registers - ALT_USB
 * USB OTG Controller Module Registers
 * 
 * Registers in the USB OTG Controller Module.
 * 
 * Only the Core Global, Power and Clock Gating, Data FIFO Access, and Host Port
 * registers can be accessedin both Host and Device modes. When the USB OTG
 * Controller is operating in one mode, either Device or Host, the application must
 * not access registers from the other mode. If an illegal access occurs, a Mode
 * Mismatch interrupt is generated and reflected in the Core Interrupt register
 * (GINTSTS.ModeMis).
 * 
 * When the core switches from one mode to another, the registers in the new mode
 * must be reprogrammed as they would be after a power-on reset.
 * 
 * The register address map is fixed and does not depend on the module
 * configuration (for example, how many endpoints are implemented). Host and Device
 * mode registers occupy different addresses.
 * 
 */
/*
 * Register Group : Global Registers - ALT_USB_GLOB
 * Global Registers
 * 
 * These registers are available in both Host and Device modes, and do not need to
 * be reprogrammed when switching between these modes.
 * 
 */
/*
 * Register : OTG Control and Status Register - gotgctl
 * 
 * The OTG Control and Status register controls the behavior and reflects the
 * status of the OTG function.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                               
 * :--------|:-------|:------|:-------------------------------------------
 *  [0]     | R      | 0x0   | Session Request Success                   
 *  [1]     | RW     | 0x0   | Session Request                           
 *  [2]     | RW     | 0x0   | VBUS Valid Override Enable                
 *  [3]     | RW     | 0x0   | VBUS Valid Override Value                 
 *  [4]     | RW     | 0x0   | A-Peripheral Session Valid Override Enable
 *  [5]     | RW     | 0x0   | A-Peripheral Session Valid OverrideValue  
 *  [6]     | RW     | 0x0   | B-Peripheral Session Valid Override Enable
 *  [7]     | RW     | 0x0   | B-Peripheral Session Valid OverrideValue  
 *  [8]     | R      | 0x0   | Host Negotiation Success                  
 *  [9]     | RW     | 0x0   | HNP Request                               
 *  [10]    | RW     | 0x0   | Host Set HNP Enable                       
 *  [11]    | RW     | 0x0   | Device HNP Enabled                        
 *  [15:12] | ???    | 0x0   | *UNDEFINED*                               
 *  [16]    | R      | 0x1   | Connector ID Status                       
 *  [17]    | R      | 0x0   | Long Short Debounce Time                  
 *  [18]    | R      | 0x0   | A-Session Valid                           
 *  [19]    | R      | 0x0   | B-Session Valid                           
 *  [20]    | RW     | 0x0   | OTG Version                               
 *  [31:21] | ???    | 0x0   | *UNDEFINED*                               
 * 
 */
/*
 * Field : Session Request Success - sesreqscs
 * 
 * This bit is set when a session request initiation is successful. This bit is
 * valid only For Device Only configuration when OTG_MODE == 3 or OTG_MODE == 4.
 * Applies for device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description            
 * :-----------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_FAIL    | 0x0   | Session request failure
 *  ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_SUCCESS | 0x1   | Session request success
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQSCS
 * 
 * Session request failure
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_FAIL       0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQSCS
 * 
 * Session request success
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_E_SUCCESS    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_MSB        0
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GOTGCTL_SESREQSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_SESREQSCS field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GOTGCTL_SESREQSCS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQSCS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Session Request - sesreq
 * 
 * The application sets this bit to initiate a session request on the USB. The
 * application can clear this bit by writing a 0 when the Host Negotiation Success
 * Status Change bit in the OTG Interrupt register (GOTGINT.HstNegSucStsChng) is
 * SET. The core clears this bit when the HstNegSucStsChng bit is cleared. If you
 * use the USB 1.1 Full-Speed Serial Transceiver interface to initiate the session
 * request, the application must wait until the VBUS discharges to 0.2 V, after the
 * B-Session Valid bit in  this register (GOTGCTL.BSesVld) is cleared. This
 * discharge time varies between different PHYs and can be obtained from the PHY
 * vendor.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description       
 * :----------------------------------------|:------|:-------------------
 *  ALT_USB_GLOB_GOTGCTL_SESREQ_E_NOREQUEST | 0x0   | No session request
 *  ALT_USB_GLOB_GOTGCTL_SESREQ_E_REQUEST   | 0x1   | Session request   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQ
 * 
 * No session request
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_E_NOREQUEST 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_SESREQ
 * 
 * Session request
 */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_E_REQUEST   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_MSB        1
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_SESREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_SESREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_GLOB_GOTGCTL_SESREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_SESREQ field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_GLOB_GOTGCTL_SESREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_SESREQ_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : VBUS Valid Override Enable - vbvalidoven
 * 
 * This bit is used to enable/disable the software to override the vbus-valid
 * signal using the GOTGCTL.vbvalidOvVal..
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                    
 * :----------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_DISD | 0x0   | Override is disabled and bvalid signal from the
 * :                                        |       | respective PHY selected is used internally by  
 * :                                        |       | the force                                      
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_END  | 0x1   | The vbus-valid signal received from the PHY is 
 * :                                        |       | overridden with GOTGCTL.vbvalidOvVal           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN
 * 
 * Override is disabled and bvalid signal from the respective PHY selected is used
 * internally by the force
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN
 * 
 * The vbus-valid signal received from the PHY is overridden with
 * GOTGCTL.vbvalidOvVal
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_MSB        2
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVEN_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : VBUS Valid Override Value - vbvalidovval
 * 
 * This bit is used to set Override value for vbus valid signal when
 * GOTGCTL.VbvalidOvEn is set.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                  
 * :-----------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET0 | 0x0   | vbusvalid value when GOTGCTL.VbvalidOvEn = 1 
 *  ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET1 | 0x1   | vbusvalid value when GOTGCTL.VbvalidOvEn is 1
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL
 * 
 * vbusvalid value when GOTGCTL.VbvalidOvEn = 1
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET0    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL
 * 
 * vbusvalid value when GOTGCTL.VbvalidOvEn is 1
 */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_E_SET1    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_MSB        3
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_VBVALIDOVVAL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : A-Peripheral Session Valid Override Enable - avalidoven
 * 
 * This bit is used to enable/disable the software to override the Avalid signal
 * using the GOTGCTL.AvalidOvVal.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                    
 * :---------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_DISD | 0x0   | Override is disabled and Avalid signal from the
 * :                                       |       | respective PHY is used internally by the core. 
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_END  | 0x1   | Internally Avalid received from the PHY is     
 * :                                       |       | overridden with GOTGCTL.AvalidOvVa             
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVEN
 * 
 * Override is disabled and Avalid signal from the respective PHY is used
 * internally by the core.
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVEN
 * 
 * Internally Avalid received from the PHY is overridden with GOTGCTL.AvalidOvVa
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_MSB        4
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_AVALIDOVEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GOTGCTL_AVALIDOVEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVEN_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : A-Peripheral Session Valid OverrideValue - avalidovval
 * 
 * This bit is used to set Override value for Avalid signal when GOTGCTL.BvalidOvEn
 * is set.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                    
 * :------------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE0 | 0x0   | Avalid value is 1'b0 when GOTGCTL.BvalidOvEn =1
 *  ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE1 | 0x1   | Avalid value is 1'b1 when GOTGCTL.BvalidOvEn =1
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL
 * 
 * Avalid value is 1'b0 when GOTGCTL.BvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL
 * 
 * Avalid value is 1'b1 when GOTGCTL.BvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_E_VALUE1   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_MSB        5
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_AVALIDOVVAL_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : B-Peripheral Session Valid Override Enable - bvalidoven
 * 
 * This bit is used to enable/disable the software to  override the Bvalid signal
 * using the GOTGCTL.BvalidOvVal.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                    
 * :---------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_DISD | 0x0   | Override is disabled and bvalid signal from the
 * :                                       |       | respective PHY selected is used internally by  
 * :                                       |       | the core                                       
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_END  | 0x1   | Internally Bvalid received from the PHY is     
 * :                                       |       | overridden with GOTGCTL.BvalidOvVal            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVEN
 * 
 * Override is disabled and bvalid signal from the respective PHY selected is used
 * internally by the core
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVEN
 * 
 * Internally Bvalid received from the PHY is overridden with GOTGCTL.BvalidOvVal
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_MSB        6
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_BVALIDOVEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GOTGCTL_BVALIDOVEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVEN_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : B-Peripheral Session Valid OverrideValue - bvalidovval
 * 
 * This bit is used to set Override value for Bvalid signalwhen GOTGCTL.BvalidOvEn
 * is set.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                            
 * :------------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE0 | 0x0   | Bvalid value when GOTGCTL.AvalidOvEn =1
 *  ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE1 | 0x1   | Bvalid value when GOTGCTL.AvalidOvEn =1
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL
 * 
 * Bvalid value when GOTGCTL.AvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL
 * 
 * Bvalid value when GOTGCTL.AvalidOvEn =1
 */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_E_VALUE1   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_MSB        7
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field value. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_BVALIDOVVAL_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Host Negotiation Success - hstnegscs
 * 
 * Mode: Device only. Host Negotiation Success (HstNegScs) The core sets this bit
 * when host negotiation is successful. The core clears this bit when the HNP
 * Request (HNPReq) bit in this register is SET.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description             
 * :-----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_FAIL    | 0x0   | Host negotiation failure
 *  ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_SUCCESS | 0x1   | Host negotiation success
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTNEGSCS
 * 
 * Host negotiation failure
 */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_FAIL       0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTNEGSCS
 * 
 * Host negotiation success
 */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_E_SUCCESS    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_MSB        8
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_HSTNEGSCS field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GOTGCTL_HSTNEGSCS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_HSTNEGSCS_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : HNP Request - hnpreq
 * 
 * Mode: Device only. The application sets this bit to initiate an HNP request to
 * the connected USB host. The application can clear this bit by writing a 0 when
 * the Host Negotiation Success Status Change bit in the OTG Interrupt register
 * (GOTGINT.HstNegSucStsChng) is SET.The core clears this bit when the
 * HstNegSucStsChng bit iscleared.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description   
 * :-----------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GOTGCTL_HNPREQ_E_DISD | 0x0   | No HNP request
 *  ALT_USB_GLOB_GOTGCTL_HNPREQ_E_END  | 0x1   | HNP request   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HNPREQ
 * 
 * No HNP request
 */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HNPREQ
 * 
 * HNP request
 */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_MSB        9
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_HNPREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_HNPREQ register field value. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_HNPREQ register field. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_HNPREQ field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GOTGCTL_HNPREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_HNPREQ_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Host Set HNP Enable - hstsethnpen
 * 
 * Mode: Host only. The application sets this bit when it has successfully enabled
 * HNP (using the SetFeature.SetHNPEnable command) on the connected device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                
 * :----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_DISD | 0x0   | Host Set HNP is not enabled
 *  ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_END  | 0x1   | Host Set HNP is enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN
 * 
 * Host Set HNP is not enabled
 */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN
 * 
 * Host Set HNP is enabled
 */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_MSB        10
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_HSTSETHNPEN_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : Device HNP Enabled - devhnpen
 * 
 * Mode: Device only. The application sets this bit when it successfully receives a
 * SetFeature.SetHNPEnable command from the connected USB host.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                          
 * :-------------------------------------|:------|:--------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_DISD | 0x0   | HNP is not enabled in the application
 *  ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_END  | 0x1   | HNP Enabled                          
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DEVHNPEN
 * 
 * HNP is not enabled in the application
 */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_DISD    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DEVHNPEN
 * 
 * HNP Enabled
 */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_MSB        11
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field value. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_DEVHNPEN field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GOTGCTL_DEVHNPEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_DEVHNPEN_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Connector ID Status - conidsts
 * 
 * Mode: Host and Device. Indicates the connector ID status on a connect event.This
 * bit is valid only for Host and Device mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                         
 * :-------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODA | 0x0   | The DWC_otg core is in A-Device mode
 *  ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODB | 0x1   | The otg core is in B-Device mode    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_CONIDSTS
 * 
 * The DWC_otg core is in A-Device mode
 */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODA    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_CONIDSTS
 * 
 * The otg core is in B-Device mode
 */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_E_MODB    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_MSB        16
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field value. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field value. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_CONIDSTS register field. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_RESET      0x1
/* Extracts the ALT_USB_GLOB_GOTGCTL_CONIDSTS field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_GLOB_GOTGCTL_CONIDSTS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_CONIDSTS_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : Long Short Debounce Time - dbnctime
 * 
 * Mode: Host only. Indicates the debounce time of a detected connection.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_LONG  | 0x0   | Long debounce time, used FOR physical         
 * :                                      |       | connections (100 ms + 2.5 s)                  
 *  ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_SHORT | 0x1   | Short debounce time, used FOR soft connections
 * :                                      |       | (2.5 s                                        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DBNCTIME
 * 
 * Long debounce time, used FOR physical connections (100 ms + 2.5 s)
 */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_LONG    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_DBNCTIME
 * 
 * Short debounce time, used FOR soft connections (2.5 s
 */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_E_SHORT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_MSB        17
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field value. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field value. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_DBNCTIME register field. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_DBNCTIME field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GOTGCTL_DBNCTIME register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_DBNCTIME_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : A-Session Valid - asesvld
 * 
 * Mode: Host only. Indicates the Host mode transceiver status. If you do not
 * enabled OTG features (such as SRP and HNP), the read reset value will be 1.The
 * vbus assigns the values internally for non-SRP or non-HNP configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description           
 * :----------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GOTGCTL_ASESVLD_E_VALID    | 0x0   | A-session is not valid
 *  ALT_USB_GLOB_GOTGCTL_ASESVLD_E_NOTVALID | 0x1   | A-session is valid    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_ASESVLD
 * 
 * A-session is not valid
 */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_E_VALID    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_ASESVLD
 * 
 * A-session is valid
 */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_E_NOTVALID 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_MSB        18
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_ASESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_ASESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_ASESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_ASESVLD field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GOTGCTL_ASESVLD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_ASESVLD_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : B-Session Valid - bsesvld
 * 
 * Mode: Device only. Indicates the Device mode transceiver status. In OTG mode,
 * you can use this bit to determine IF the device is connected or disconnected. If
 * you do not enable OTG features (such as SRP and HNP), the read reset value will
 * be 1. The vbus assigns the values internally for non-SRP or non-HNP
 * configurations.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description           
 * :----------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GOTGCTL_BSESVLD_E_NOTVALID | 0x0   | B-session is not valid
 *  ALT_USB_GLOB_GOTGCTL_BSESVLD_E_VALID    | 0x1   | B-session is valid    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BSESVLD
 * 
 * B-session is not valid
 */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_E_NOTVALID 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_BSESVLD
 * 
 * B-session is valid
 */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_E_VALID    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_MSB        19
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_BSESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_BSESVLD register field value. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_BSESVLD register field. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_BSESVLD field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GOTGCTL_BSESVLD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_BSESVLD_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : OTG Version - otgver
 * 
 * Indicates the OTG revision. In OTG Version 1.3. the core supports Data line
 * pulsing and VBus pulsing for SRP. In OTG Version 2.0 the core supports only Data
 * line pulsing for SRP.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                              
 * :------------------------------------|:------|:------------------------------------------
 *  ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER13 | 0x0   | OTG Version 1.3. In this version the core
 * :                                    |       | supports Data line                       
 *  ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER20 | 0x1   | OTG Version 2.0. In this version the core
 * :                                    |       | supports only Data line pulsing for SRP  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_OTGVER
 * 
 * OTG Version 1.3. In this version the core supports Data line
 */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER13 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGCTL_OTGVER
 * 
 * OTG Version 2.0. In this version the core supports only Data line pulsing for
 * SRP
 */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_E_VER20 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_MSB        20
/* The width in bits of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGCTL_OTGVER register field value. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GOTGCTL_OTGVER register field value. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GOTGCTL_OTGVER register field. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGCTL_OTGVER field value from a register. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GOTGCTL_OTGVER register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGCTL_OTGVER_SET(value) (((value) << 20) & 0x00100000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GOTGCTL.
 */
struct ALT_USB_GLOB_GOTGCTL_s
{
    const uint32_t  sesreqscs    :  1;  /* Session Request Success */
    uint32_t        sesreq       :  1;  /* Session Request */
    uint32_t        vbvalidoven  :  1;  /* VBUS Valid Override Enable */
    uint32_t        vbvalidovval :  1;  /* VBUS Valid Override Value */
    uint32_t        avalidoven   :  1;  /* A-Peripheral Session Valid Override Enable */
    uint32_t        avalidovval  :  1;  /* A-Peripheral Session Valid OverrideValue */
    uint32_t        bvalidoven   :  1;  /* B-Peripheral Session Valid Override Enable */
    uint32_t        bvalidovval  :  1;  /* B-Peripheral Session Valid OverrideValue */
    const uint32_t  hstnegscs    :  1;  /* Host Negotiation Success */
    uint32_t        hnpreq       :  1;  /* HNP Request */
    uint32_t        hstsethnpen  :  1;  /* Host Set HNP Enable */
    uint32_t        devhnpen     :  1;  /* Device HNP Enabled */
    uint32_t                     :  4;  /* *UNDEFINED* */
    const uint32_t  conidsts     :  1;  /* Connector ID Status */
    const uint32_t  dbnctime     :  1;  /* Long Short Debounce Time */
    const uint32_t  asesvld      :  1;  /* A-Session Valid */
    const uint32_t  bsesvld      :  1;  /* B-Session Valid */
    uint32_t        otgver       :  1;  /* OTG Version */
    uint32_t                     : 11;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GOTGCTL. */
typedef volatile struct ALT_USB_GLOB_GOTGCTL_s  ALT_USB_GLOB_GOTGCTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GOTGCTL register from the beginning of the component. */
#define ALT_USB_GLOB_GOTGCTL_OFST        0x0
/* The address of the ALT_USB_GLOB_GOTGCTL register. */
#define ALT_USB_GLOB_GOTGCTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GOTGCTL_OFST))

/*
 * Register : OTG Interrupt Register - gotgint
 * 
 * The application reads this register whenever there is an OTG interrupt and
 * clears the bits in this register to clear the OTG interrupt.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                           
 * :--------|:-------|:------|:---------------------------------------
 *  [1:0]   | ???    | 0x0   | *UNDEFINED*                           
 *  [2]     | R      | 0x0   | Session End Detected                  
 *  [7:3]   | ???    | 0x0   | *UNDEFINED*                           
 *  [8]     | R      | 0x0   | Session Request Success Status Change 
 *  [9]     | R      | 0x0   | Host Negotiation Success Status Change
 *  [16:10] | ???    | 0x0   | *UNDEFINED*                           
 *  [17]    | R      | 0x0   | Host Negotiation Detected             
 *  [18]    | R      | 0x0   | A-Device Timeout Change               
 *  [19]    | R      | 0x0   | Debounce Done                         
 *  [31:20] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : Session End Detected - sesenddet
 * 
 * Mode:Host and Device.This bit can be set only by the core and the application
 * should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                 
 * :---------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GOTGINT_SESENDDET_E_INACT | 0x0   | Non Active State                            
 *  ALT_USB_GLOB_GOTGINT_SESENDDET_E_ACT   | 0x1   | Set when utmisrp_bvalid signal is deasserted
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESENDDET
 * 
 * Non Active State
 */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESENDDET
 * 
 * Set when utmisrp_bvalid signal is deasserted
 */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_MSB        2
/* The width in bits of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_SESENDDET register field value. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_SESENDDET register field value. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GOTGINT_SESENDDET register field. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_SESENDDET field value from a register. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GOTGINT_SESENDDET register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_SESENDDET_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Session Request Success Status Change - sesreqsucstschng
 * 
 * Mode: Host and Device. The core sets this bit on the success or failure of a
 * session request. The application must read the Session Request Success bit in
 * the OTG Control and Status register (GOTGCTL.SesReqScs) to check for success or
 * failure. This bit can be set only by the core and the application should write 1
 * to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description           
 * :----------------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_INACT | 0x0   | No change             
 *  ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_ACT   | 0x1   | Session Request Status
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG
 * 
 * No change
 */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG
 * 
 * Session Request Status
 */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_MSB        8
/* The width in bits of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG field value from a register. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_SESREQSUCSTSCHNG_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Host Negotiation Success Status Change - hstnegsucstschng
 * 
 * Mode: Host and Device. The core sets this bit on the success or failure of a USB
 * host negotiation request. The application must read the Host Negotiation Success
 * bit of the OTG Control and Status register (GOTGCTL.HstNegScs) to check for
 * success or failure. This bit can be set only by the core and the application
 * should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                   
 * :----------------------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_INACT | 0x0   | No Change                     
 *  ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_ACT   | 0x1   | Host Negotiation Status Change
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG
 * 
 * Host Negotiation Status Change
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_MSB        9
/* The width in bits of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG field value from a register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGSUCSTSCHNG_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Host Negotiation Detected - hstnegdet
 * 
 * Mode:Host and Device. The core sets this bit when it detects a host negotiation
 * request on the USB. This bit can be set only by the core and the application
 * should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description              
 * :---------------------------------------|:------|:--------------------------
 *  ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_INACT | 0x0   | No Change                
 *  ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_ACT   | 0x1   | Host Negotiation Detected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGDET
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_HSTNEGDET
 * 
 * Host Negotiation Detected
 */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_MSB        17
/* The width in bits of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field value. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GOTGINT_HSTNEGDET register field. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_HSTNEGDET field value from a register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GOTGINT_HSTNEGDET register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_HSTNEGDET_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : A-Device Timeout Change - adevtoutchg
 * 
 * Mode:Host and Device. The core sets this bit to indicate that the A-device has
 * timed out WHILE waiting FOR the B-device to connect. This bit can be set only by
 * the core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description     
 * :-----------------------------------------|:------|:-----------------
 *  ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_INACT | 0x0   | No Change       
 *  ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_ACT   | 0x1   | A-Device Timeout
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG
 * 
 * A-Device Timeout
 */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_MSB        18
/* The width in bits of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field value. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field value. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG field value from a register. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_ADEVTOUTCHG_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : Debounce Done - dbncedone
 * 
 * Mode: Host only. The core sets this bit when the debounce is completed after the
 * device connect. The application can start driving USB reset after seeing this
 * interrupt. This bit is only valid when the HNP Capable or SRP Capable bit is SET
 * in the Core USB Configuration register (GUSBCFG.HNPCap or GUSBCFG.SRPCap,
 * respectively). This bit can be set only by the core and the application should
 * write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description       
 * :---------------------------------------|:------|:-------------------
 *  ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_INACT | 0x0   | No Change         
 *  ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_ACT   | 0x1   | Debounce completed
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_DBNCEDONE
 * 
 * No Change
 */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GOTGINT_DBNCEDONE
 * 
 * Debounce completed
 */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_MSB        19
/* The width in bits of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field value. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field value. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GOTGINT_DBNCEDONE register field. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GOTGINT_DBNCEDONE field value from a register. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GOTGINT_DBNCEDONE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GOTGINT_DBNCEDONE_SET(value) (((value) << 19) & 0x00080000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GOTGINT.
 */
struct ALT_USB_GLOB_GOTGINT_s
{
    uint32_t                         :  2;  /* *UNDEFINED* */
    const uint32_t  sesenddet        :  1;  /* Session End Detected */
    uint32_t                         :  5;  /* *UNDEFINED* */
    const uint32_t  sesreqsucstschng :  1;  /* Session Request Success Status Change */
    const uint32_t  hstnegsucstschng :  1;  /* Host Negotiation Success Status Change */
    uint32_t                         :  7;  /* *UNDEFINED* */
    const uint32_t  hstnegdet        :  1;  /* Host Negotiation Detected */
    const uint32_t  adevtoutchg      :  1;  /* A-Device Timeout Change */
    const uint32_t  dbncedone        :  1;  /* Debounce Done */
    uint32_t                         : 12;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GOTGINT. */
typedef volatile struct ALT_USB_GLOB_GOTGINT_s  ALT_USB_GLOB_GOTGINT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GOTGINT register from the beginning of the component. */
#define ALT_USB_GLOB_GOTGINT_OFST        0x4
/* The address of the ALT_USB_GLOB_GOTGINT register. */
#define ALT_USB_GLOB_GOTGINT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GOTGINT_OFST))

/*
 * Register : AHB Configuration Register - gahbcfg
 * 
 * This register can be used to configure the core after power-on or a change in
 * mode. This register mainly contains AHB system-related configuration parameters.
 * Do not change this register after the initial programming. The application must
 * program this register before starting any transactions on either the AHB or the
 * USB.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [0]     | RW     | 0x0   | Global Interrupt Mask            
 *  [4:1]   | RW     | 0x0   | Burst Length Type                
 *  [5]     | RW     | 0x0   | DMA Enable                       
 *  [6]     | ???    | 0x0   | *UNDEFINED*                      
 *  [7]     | RW     | 0x0   | Non-Periodic TxFIFO Empty Level  
 *  [8]     | RW     | 0x0   | Periodic TxFIFO Empty Leve       
 *  [20:9]  | ???    | 0x0   | *UNDEFINED*                      
 *  [21]    | RW     | 0x0   | Remote Memory Support            
 *  [22]    | RW     | 0x0   | Notify All Dma Write Transactions
 *  [31:23] | ???    | 0x0   | *UNDEFINED*                      
 * 
 */
/*
 * Field : Global Interrupt Mask - glblintrmsk
 * 
 * Mode: Host and device. The application uses this bit to mask or unmask the
 * interrupt line assertion to itself. Irrespective of this bits setting, the
 * interrupt status registers are updated by the core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                    
 * :-----------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_MSK   | 0x0   | Mask the interrupt assertion to the application
 *  ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_NOMSK | 0x1   | Unmask the interrupt assertion to the          
 * :                                         |       | application.                                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK
 * 
 * Mask the interrupt assertion to the application
 */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK
 * 
 * Unmask the interrupt assertion to the application.
 */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_MSB        0
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field value. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field value. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_GLBLINTRMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Burst Length Type - hbstlen
 * 
 * Mode:Host and device. This field is used in Internal DMA modes.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                           | Value | Description       
 * :-----------------------------------------------|:------|:-------------------
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD1ORSINGLE   | 0x0   | 1 word or single  
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD4ORINCR     | 0x1   | 4 word or incr    
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD8           | 0x2   | 8 word            
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD16ORINCR4   | 0x3   | 16 word or incr4  
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD32          | 0x4   | 32 word           
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD64ORINCR8   | 0x5   | 64 word or incr8  
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD128         | 0x6   | 128 word          
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD256ORINCR16 | 0x7   | 256 word or incr16
 *  ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORDX           | 0x8   | Others reserved   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 1 word or single
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD1ORSINGLE    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 4 word or incr
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD4ORINCR      0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 8 word
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD8            0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 16 word or incr4
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD16ORINCR4    0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 32 word
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD32           0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 64 word or incr8
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD64ORINCR8    0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 128 word
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD128          0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * 256 word or incr16
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORD256ORINCR16  0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_HBSTLEN
 * 
 * Others reserved
 */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_E_WORDX            0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_MSB        4
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_SET_MSK    0x0000001e
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_CLR_MSK    0xffffffe1
/* The reset value of the ALT_USB_GLOB_GAHBCFG_HBSTLEN register field. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_HBSTLEN field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_GET(value) (((value) & 0x0000001e) >> 1)
/* Produces a ALT_USB_GLOB_GAHBCFG_HBSTLEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_HBSTLEN_SET(value) (((value) << 1) & 0x0000001e)

/*
 * Field : DMA Enable - dmaen
 * 
 * Mode:Host and device. Enables switching from DMA mode to slave mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                
 * :------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GAHBCFG_DMAEN_E_SLVMOD | 0x0   | Core operates in Slave mode
 *  ALT_USB_GLOB_GAHBCFG_DMAEN_E_DMAMOD | 0x1   | Core operates in a DMA mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_DMAEN
 * 
 * Core operates in Slave mode
 */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_E_SLVMOD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_DMAEN
 * 
 * Core operates in a DMA mode
 */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_E_DMAMOD 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_MSB        5
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_DMAEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_DMAEN register field value. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GAHBCFG_DMAEN register field. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_DMAEN field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GAHBCFG_DMAEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_DMAEN_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Non-Periodic TxFIFO Empty Level - nptxfemplvl
 * 
 * Mode:Host and device. This bit is used only in Slave mode. In host mode and with
 * Shared FIFO with device mode, this bit indicates when the Non-Periodic TxFIFO
 * Empty Interrupt bit in the Core Interrupt register (GINTSTS.NPTxFEmp) is
 * triggered. With dedicated FIFO in device mode, this bit indicates when IN
 * endpoint Transmit FIFO empty interrupt (DIEPINTn.TxFEmp) is triggered. Host mode
 * and with Shared FIFO with device mode:
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                     
 * :---------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_HALFEMPTY | 0x0   | DIEPINTn.TxFEmp interrupt indicates that the IN 
 * :                                             |       | Endpoint TxFIFO is half empty or DIEPINTn.TxFEmp
 * :                                             |       | interrupt indicates that the IN Endpoint TxFIFO 
 * :                                             |       | is half empty                                   
 *  ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_EMPTY     | 0x1   | GINTSTS.NPTxFEmp interrupt indicates that the   
 * :                                             |       | Non-Periodic TxFIFO is completely empty or      
 * :                                             |       | DIEPINTn.TxFEmp interrupt indicates that the IN 
 * :                                             |       | Endpoint TxFIFO is completely empty             
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL
 * 
 * DIEPINTn.TxFEmp interrupt indicates that the IN Endpoint TxFIFO is half empty or
 * DIEPINTn.TxFEmp interrupt indicates that the IN Endpoint TxFIFO is half empty
 */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_HALFEMPTY    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL
 * 
 * GINTSTS.NPTxFEmp interrupt indicates that the Non-Periodic TxFIFO is completely
 * empty or DIEPINTn.TxFEmp interrupt indicates that the IN Endpoint TxFIFO is
 * completely empty
 */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_E_EMPTY        0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_MSB        7
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_NPTXFEMPLVL_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Periodic TxFIFO Empty Leve - ptxfemplvl
 * 
 * Mode:Host only. Indicates when the Periodic TxFIFO Empty Interrupt bit in the
 * Core Interrupt register (GINTSTS.PTxFEmp) is triggered. This bit is used only in
 * Slave mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                 
 * :--------------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_HALFEMPTY | 0x0   | GINTSTS.PTxFEmp interrupt indicates that the
 * :                                            |       | Periodic TxFIFO is half empty               
 *  ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_EMPTY     | 0x1   | GINTSTS.PTxFEmp interrupt indicates that the
 * :                                            |       | Periodic TxFIFO is completely empty         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL
 * 
 * GINTSTS.PTxFEmp interrupt indicates that the Periodic TxFIFO is half empty
 */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_HALFEMPTY 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL
 * 
 * GINTSTS.PTxFEmp interrupt indicates that the Periodic TxFIFO is completely empty
 */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_E_EMPTY     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_MSB        8
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field value. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_PTXFEMPLVL_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Remote Memory Support - remmemsupp
 * 
 * This bit is programmed to enable/disable the functionality to wait for the
 * system DMA Done Signal for the DMA Write Transfers.
 * 
 * * The int_dma_req output signal is asserted when HSOTG DMA starts write transfer
 *   to the external memory. When the core is done with the Transfers it asserts
 *   int_dma_done signal to flag the completion of DMA writes from HSOTG. The core
 *   then waits for sys_dma_done signal from the system to proceed further and
 *   complete the Data Transfer corresponding to a particular Channel/Endpoint.
 * 
 * * The int_dma_req and int_dma_done signals are not asserted and the core
 *   proceeds with the assertion of the XferComp interrupt as soon as wait for the
 *   system DMA Done Signal for the DMA Write Transfers the DMA write transfer is
 *   done at the HSOTG Core Boundary and it doesn't wait for the sys_dma_done
 *   signal to complete the DATA
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                   
 * :---------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_DISD | 0x0   | Disable wait for system DMA Done Signal       
 *  ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_END  | 0x1   | Enable wait for the system DMA Done Signal for
 * :                                       |       | the DMA Write Transfers                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_REMMEMSUPP
 * 
 * Disable wait for system DMA Done Signal
 */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_REMMEMSUPP
 * 
 * Enable wait for the system DMA Done Signal for the DMA Write Transfers
 */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_MSB        21
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field value. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field value. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_REMMEMSUPP field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GAHBCFG_REMMEMSUPP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_REMMEMSUPP_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : Notify All Dma Write Transactions - notialldmawrit
 * 
 * This bit is programmed to enable the System DMA Done functionality for all the
 * DMA write Transactions corresponding to the Channel/Endpoint. This bit is valid
 * only when GAHBCFG.RemMemSupp is set to 1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                            | Value | Description                                     
 * :------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_ALLTRANS  | 0x1   | HSOTG core asserts int_dma_req for all the DMA  
 * :                                                |       | write transactions on the AHB interface along   
 * :                                                |       | with int_dma_done, chep_last_transact and       
 * :                                                |       | chep_number signal informations. The core waits 
 * :                                                |       | for sys_dma_done signal for all the DMA write   
 * :                                                |       | transactions in order to complete the transfer  
 * :                                                |       | of a particular Channel/Endpoint                
 *  ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_LASTTRANS | 0x0   | HSOTG core asserts int_dma_req signal only for  
 * :                                                |       | the last transaction of DMA write transfer      
 * :                                                |       | corresponding to a particular Channel/Endpoint. 
 * :                                                |       | Similarly, the core waits for sys_dma_done      
 * :                                                |       | signal only for that transaction of DMA write to
 * :                                                |       | complete the transfer of a particular           
 * :                                                |       | Channel/Endpoint                                
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT
 * 
 * HSOTG core asserts int_dma_req for all the DMA write transactions on the AHB
 * interface along with int_dma_done, chep_last_transact and chep_number signal
 * informations. The core waits for sys_dma_done signal for all the DMA write
 * transactions in order to complete the transfer of a particular Channel/Endpoint
 */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_ALLTRANS  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT
 * 
 * HSOTG core asserts int_dma_req signal only for the last transaction of DMA write
 * transfer corresponding to a particular Channel/Endpoint. Similarly, the core
 * waits for sys_dma_done signal only for that transaction of DMA write to complete
 * the transfer of a particular Channel/Endpoint
 */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_E_LASTTRANS 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_MSB        22
/* The width in bits of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field value. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field value. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT field value from a register. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GAHBCFG_NOTIALLDMAWRIT_SET(value) (((value) << 22) & 0x00400000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GAHBCFG.
 */
struct ALT_USB_GLOB_GAHBCFG_s
{
    uint32_t  glblintrmsk    :  1;  /* Global Interrupt Mask */
    uint32_t  hbstlen        :  4;  /* Burst Length Type */
    uint32_t  dmaen          :  1;  /* DMA Enable */
    uint32_t                 :  1;  /* *UNDEFINED* */
    uint32_t  nptxfemplvl    :  1;  /* Non-Periodic TxFIFO Empty Level */
    uint32_t  ptxfemplvl     :  1;  /* Periodic TxFIFO Empty Leve */
    uint32_t                 : 12;  /* *UNDEFINED* */
    uint32_t  remmemsupp     :  1;  /* Remote Memory Support */
    uint32_t  notialldmawrit :  1;  /* Notify All Dma Write Transactions */
    uint32_t                 :  9;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GAHBCFG. */
typedef volatile struct ALT_USB_GLOB_GAHBCFG_s  ALT_USB_GLOB_GAHBCFG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GAHBCFG register from the beginning of the component. */
#define ALT_USB_GLOB_GAHBCFG_OFST        0x8
/* The address of the ALT_USB_GLOB_GAHBCFG register. */
#define ALT_USB_GLOB_GAHBCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GAHBCFG_OFST))

/*
 * Register : USB Configuration Registe - gusbcfg
 * 
 * This register can be used to configure the core after power-on or a changing to
 * Host mode or Device mode. It contains USB and USB-PHY related configuration
 * parameters. The application must program this register before starting any
 * transactions on either the AHB or the USB. Do not make changes to this register
 * after the initial programming.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                       
 * :--------|:-------|:------|:-----------------------------------
 *  [2:0]   | RW     | 0x0   | HS FS Timeout Calibration         
 *  [3]     | R      | 0x0   | PHY Interfac                      
 *  [4]     | R      | 0x1   | ULPI Select                       
 *  [5]     | R      | 0x0   | Full-Speed Serial Interface Select
 *  [6]     | R      | 0x0   | USB 2.0 High-Speed PHY            
 *  [7]     | RW     | 0x0   | ULPI DDR Select                   
 *  [8]     | RW     | 0x0   | SRP-Capable                       
 *  [9]     | RW     | 0x0   | HNP-Capable                       
 *  [13:10] | RW     | 0x5   | USB Turnaround Time               
 *  [17:14] | ???    | 0x0   | *UNDEFINED*                       
 *  [18]    | RW     | 0x0   | ULPI Auto Resume                  
 *  [19]    | RW     | 0x0   | ULPI Clock SuspendM               
 *  [20]    | RW     | 0x0   | ULPI External VBUS Drive          
 *  [21]    | RW     | 0x0   | ULPI External VBUS Indicato       
 *  [22]    | RW     | 0x0   | TermSel DLine Pulsing Selection   
 *  [23]    | RW     | 0x0   | Indicator Complement              
 *  [24]    | RW     | 0x0   | Indicator Pass Throug             
 *  [25]    | RW     | 0x0   | ULPI Interface Protect Disable    
 *  [27:26] | ???    | 0x0   | *UNDEFINED*                       
 *  [28]    | RW     | 0x0   | Tx End Delay                      
 *  [29]    | RW     | 0x0   | Force Host Mode.                  
 *  [30]    | RW     | 0x0   | Force Device Mode                 
 *  [31]    | W      | 0x0   | Corrupt Tx packet                 
 * 
 */
/*
 * Field : HS FS Timeout Calibration - toutcal
 * 
 * Mode:Host and Device. The number of PHY clocks that the application programs in
 * this field is added to the high-speed/full-speed interpacket timeout duration in
 * the core to account for any additional delays introduced by the PHY. This can be
 * required, because the delay introduced by the PHY in generating the linestate
 * condition can vary from one PHY to another. The USB standard timeout value for
 * high-speed operation is 736 to 816 (inclusive) bit times. The USB standard
 * timeout value for full-speed operation is 16 to 18 (inclusive) bit times. The
 * application must program this field based on the speed of enumeration. The
 * number of bit times added per PHY clock are: High-speed operation:
 * 
 * * One 30-MHz PHY clock = 16 bit times
 * 
 * * One 60-MHz PHY clock = 8 bit times
 * 
 * Full-speed operation:
 * 
 * * One 30-MHz PHY clock = 0.4 bit times
 * 
 * * One 60-MHz PHY clock = 0.2 bit times
 * 
 * * One 48-MHz PHY clock = 0.25 bit times
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_MSB        2
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_WIDTH      3
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field value. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_SET_MSK    0x00000007
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field value. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_CLR_MSK    0xfffffff8
/* The reset value of the ALT_USB_GLOB_GUSBCFG_TOUTCAL register field. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_TOUTCAL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_GET(value) (((value) & 0x00000007) >> 0)
/* Produces a ALT_USB_GLOB_GUSBCFG_TOUTCAL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_TOUTCAL_SET(value) (((value) << 0) & 0x00000007)

/*
 * Field : PHY Interfac - phyif
 * 
 * Mode:Host and Device. This application uses a ULPI interface only. Hence only
 * 8-bit setting is relevant. This setting should not matter since UTMI is not
 * enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description  
 * :-----------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GUSBCFG_PHYIF_E_BITS8 | 0x0   | PHY 8bit Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_PHYIF
 * 
 * PHY 8bit Mode
 */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_E_BITS8  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_MSB        3
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_PHYIF register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_PHYIF register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GUSBCFG_PHYIF register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_PHYIF field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GUSBCFG_PHYIF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_PHYIF_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : ULPI Select - ulpi_utmi_sel
 * 
 * Mode:Host and Device. The application uses ULPI Only in 8bit mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_E_ULPI | 0x0   | ULPI PHY   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL
 * 
 * ULPI PHY
 */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_E_ULPI   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_MSB        4
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_RESET      0x1
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_UTMI_SEL_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Full-Speed Serial Interface Select - fsintf
 * 
 * Mode:Host and Device. The application can Set this bit to select between the 3-
 * and 6-pin interfaces, and access is Read and Write.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                     
 * :-------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS6PIN | 0x0   | 6-pin unidirectional full-speed serial interface
 *  ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS3PIN | 0x1   | 3-pin bidirectional full-speed serial interface 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FSINTF
 * 
 * 6-pin unidirectional full-speed serial interface
 */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS6PIN    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FSINTF
 * 
 * 3-pin bidirectional full-speed serial interface
 */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_E_FS3PIN    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_MSB        5
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_FSINTF register field value. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_FSINTF register field value. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GUSBCFG_FSINTF register field. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_FSINTF field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GUSBCFG_FSINTF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_FSINTF_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : USB 2.0 High-Speed PHY - physel
 * 
 * Mode:Host and Device. The application uses USB 2.0.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GUSBCFG_PHYSEL_E_USB20 | 0x0   | USB 2.0 high-speed ULPI
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_PHYSEL
 * 
 * USB 2.0 high-speed ULPI
 */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_E_USB20 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_MSB        6
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_PHYSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_PHYSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GUSBCFG_PHYSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_PHYSEL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GUSBCFG_PHYSEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_PHYSEL_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : ULPI DDR Select - ddrsel
 * 
 * Mode:Host and Device. The application uses this bit to select a Single Data Rate
 * (SDR) or Double Data Rate (DDR) or ULPI interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                                     
 * :----------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_DDRSEL_E_SDR | 0x0   | Single Data Rate ULPI Interfacewith 8-bit-wide  
 * :                                  |       | data bus                                        
 *  ALT_USB_GLOB_GUSBCFG_DDRSEL_E_DDR | 0x1   | Double Data Rate ULPI Interface, with 4-bit-wide
 * :                                  |       | data bus                                        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_DDRSEL
 * 
 * Single Data Rate ULPI Interfacewith 8-bit-wide data bus
 */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_E_SDR   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_DDRSEL
 * 
 * Double Data Rate ULPI Interface, with 4-bit-wide data bus
 */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_E_DDR   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_MSB        7
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_DDRSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_DDRSEL register field value. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GUSBCFG_DDRSEL register field. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_DDRSEL field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GUSBCFG_DDRSEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_DDRSEL_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : SRP-Capable - srpcap
 * 
 * Mode:Host and Device. The application uses this bit to control the otg core SRP
 * capabilities. If the core operates as a non-SRP-capable B-device, it cannot
 * request the connected A-device (host) to activate VBUS and start a session. This
 * bit is writable only If an SRP mode was specified for Mode of Operation in
 * coreConsultant (parameter OTG_MODE). Otherwise, reads Return 0.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                  
 * :-----------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GUSBCFG_SRPCAP_E_DISD | 0x0   | SRP capability is not enabled
 *  ALT_USB_GLOB_GUSBCFG_SRPCAP_E_END  | 0x1   | SRP capability is enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_SRPCAP
 * 
 * SRP capability is not enabled
 */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_SRPCAP
 * 
 * SRP capability is enabled
 */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_MSB        8
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_SRPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_SRPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_SRPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_SRPCAP field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GUSBCFG_SRPCAP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_SRPCAP_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : HNP-Capable - hnpcap
 * 
 * Mode:Host and Device. The application uses this bit to control the otg core's
 * HNP capabilities.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                   
 * :-----------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GUSBCFG_HNPCAP_E_DISD | 0x0   | HNP capability is not enabled.
 *  ALT_USB_GLOB_GUSBCFG_HNPCAP_E_END  | 0x1   | HNP capability is enabled     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_HNPCAP
 * 
 * HNP capability is not enabled.
 */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_HNPCAP
 * 
 * HNP capability is enabled
 */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_MSB        9
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_HNPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_HNPCAP register field value. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_HNPCAP register field. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_HNPCAP field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GUSBCFG_HNPCAP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_HNPCAP_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : USB Turnaround Time - usbtrdtim
 * 
 * Mode: Device only. Sets the turnaround time in PHY clocks. Specifies the
 * response time for a MAC request to the Packet FIFO Controller (PFC) to fetch
 * data from the DFIFO (SPRAM).
 * 
 * The value is calculated for the minimum AHB frequency of 30 MHz. USB turnaround
 * time is critical for certification where long cables and 5-Hubs are used, so If
 * you need the AHB to run at less than 30 MHz, and If USB turnaround time is not
 * critical, these bits can be programmed to a larger value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                  
 * :------------------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GUSBCFG_USBTRDTIM_E_TURNTIME | 0x9   | MAC interface is 8-bit UTMI+.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_USBTRDTIM
 * 
 * MAC interface is 8-bit UTMI+.
 */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_E_TURNTIME   0x9

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_MSB        13
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field value. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_SET_MSK    0x00003c00
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field value. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_CLR_MSK    0xffffc3ff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_RESET      0x5
/* Extracts the ALT_USB_GLOB_GUSBCFG_USBTRDTIM field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_GET(value) (((value) & 0x00003c00) >> 10)
/* Produces a ALT_USB_GLOB_GUSBCFG_USBTRDTIM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_USBTRDTIM_SET(value) (((value) << 10) & 0x00003c00)

/*
 * Field : ULPI Auto Resume - ulpiautores
 * 
 * Mode:Host and Device. This bit sets the AutoResume bit in the Interface Control
 * register on the ULPI PHY.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                        
 * :----------------------------------------|:------|:------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_DISD | 0x0   | PHY does not use AutoResume feature
 *  ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_END  | 0x1   | PHY uses AutoResume feature        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIAUTORES
 * 
 * PHY does not use AutoResume feature
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIAUTORES
 * 
 * PHY uses AutoResume feature
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_MSB        18
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPIAUTORES field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPIAUTORES register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIAUTORES_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : ULPI Clock SuspendM - ulpiclksusm
 * 
 * Mode:Host and Device. This bit sets the ClockSuspendM bit in the Interface
 * Control register on the ULPI PHY. This bit applies only in serial or carkit
 * modes.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                  
 * :---------------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_PWDCLK    | 0x0   | PHY powers down internal clock during suspend
 *  ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_NONPWDCLK | 0x1   | PHY does not power down internal clock       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM
 * 
 * PHY powers down internal clock during suspend
 */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_PWDCLK       0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM
 * 
 * PHY does not power down internal clock
 */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_E_NONPWDCLK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_MSB        19
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPICLKSUSM_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : ULPI External VBUS Drive - ulpiextvbusdrv
 * 
 * Mode:Host only. This bit selects between internal or external supply to drive 5V
 * on VBUS, in ULPI PHY.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                               
 * :---------------------------------------------|:------|:-------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_INTERN | 0x0   | PHY drives VBUS using internal charge pump
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_EXTERN | 0x1   | PHY drives VBUS using external supply     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV
 * 
 * PHY drives VBUS using internal charge pump
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_INTERN    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV
 * 
 * PHY drives VBUS using external supply
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_E_EXTERN    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_MSB        20
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSDRV_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : ULPI External VBUS Indicato - ulpiextvbusindicator
 * 
 * Mode:Host only. This bit indicates to the ULPI PHY to use an external VBUS
 * overcurrent indicator.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description                            
 * :---------------------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_INTERN | 0x0   | PHY uses internal VBUS valid comparator
 *  ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_EXTERN | 0x1   | PHY uses external VBUS valid comparator
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR
 * 
 * PHY uses internal VBUS valid comparator
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_INTERN  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR
 * 
 * PHY uses external VBUS valid comparator
 */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_E_EXTERN  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_MSB        21
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPIEXTVBUSINDICATOR_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : TermSel DLine Pulsing Selection - termseldlpulse
 * 
 * Mode:Device only. This bit selects utmi_termselect to drive data line pulse
 * during SRP.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                         
 * :----------------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TXVALID | 0x0   | Data line pulsing using utmi_txvalid
 *  ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TERMSEL | 0x1   | Data line pulsing using utmi_termsel
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE
 * 
 * Data line pulsing using utmi_txvalid
 */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TXVALID   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE
 * 
 * Data line pulsing using utmi_termsel
 */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_E_TERMSEL   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_MSB        22
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field value. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field value. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_TERMSELDLPULSE_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : Indicator Complement - complement
 * 
 * Mode:Host only. Controls the PHY to invert the ExternalVbusIndicator
 * inputsignal, generating the ComplementOutput. Please refer to the ULPI Spec for
 * more detail.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_NONINVERT | 0x0   | PHY does not invert ExternalVbusIndicator signal
 *  ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_INVERT    | 0x1   | PHY does invert ExternalVbusIndicator signal    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_COMPLEMENT
 * 
 * PHY does not invert ExternalVbusIndicator signal
 */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_NONINVERT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_COMPLEMENT
 * 
 * PHY does invert ExternalVbusIndicator signal
 */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_E_INVERT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_MSB        23
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field value. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field value. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_COMPLEMENT field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GUSBCFG_COMPLEMENT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_COMPLEMENT_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : Indicator Pass Throug - indicator
 * 
 * Mode:Host only. Controls wether the Complement Output is qualified with the
 * Internal Vbus Valid comparator before being used in the Vbus State in the RX
 * CMD.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                                    
 * :----------------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_INDICATOR_E_QUALIFIED    | 0x0   | Complement Output signal is qualified with the 
 * :                                              |       | Internal VbusValid comparator                  
 *  ALT_USB_GLOB_GUSBCFG_INDICATOR_E_NONQUALIFIED | 0x1   | Complement Output signal is not qualified  with
 * :                                              |       | the Internal VbusValid comparator              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_INDICATOR
 * 
 * Complement Output signal is qualified with the Internal VbusValid comparator
 */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_E_QUALIFIED      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_INDICATOR
 * 
 * Complement Output signal is not qualified  with the Internal VbusValid
 * comparator
 */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_E_NONQUALIFIED   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_MSB        24
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_INDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_INDICATOR register field value. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_INDICATOR register field. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_INDICATOR field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GUSBCFG_INDICATOR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_INDICATOR_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : ULPI Interface Protect Disable - ulpi
 * 
 * Mode:Host only. Controls circuitry built into the PHY for protecting the ULPI
 * interface when the link tri-states STP and data. Any pull-ups or pull-downs
 * employed by this feature can be disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                           
 * :---------------------------------|:------|:---------------------------------------
 *  ALT_USB_GLOB_GUSBCFG_ULPI_E_END  | 0x0   | Enables the interface protect circuit 
 *  ALT_USB_GLOB_GUSBCFG_ULPI_E_DISD | 0x1   | Disables the interface protect circuit
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPI
 * 
 * Enables the interface protect circuit
 */
#define ALT_USB_GLOB_GUSBCFG_ULPI_E_END     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_ULPI
 * 
 * Disables the interface protect circuit
 */
#define ALT_USB_GLOB_GUSBCFG_ULPI_E_DISD    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_MSB        25
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_ULPI register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_ULPI register field value. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_ULPI register field. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_ULPI field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GUSBCFG_ULPI register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_ULPI_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Tx End Delay - txenddelay
 * 
 * Mode: Device only. Set to non UTMI+.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GUSBCFG_TXENDDELAY_E_DISD | 0x0   | Normal Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_TXENDDELAY
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_MSB        28
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field value. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_SET_MSK    0x10000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field value. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_CLR_MSK    0xefffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_TXENDDELAY field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_USB_GLOB_GUSBCFG_TXENDDELAY register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_TXENDDELAY_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Force Host Mode. - forcehstmode
 * 
 * Mode:Host and device. Writing a 1 to this bit forces the core to host mode After
 * setting the force bit, the application must wait at least 25 ms before the
 * change to take effect. When the simulation is in scale down mode, waiting for
 * 500 micro-sec is sufficient.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description    
 * :----------------------------------------|:------|:----------------
 *  ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_DISD | 0x0   | Normal Mode    
 *  ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_END  | 0x1   | Force Host Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD
 * 
 * Force Host Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_MSB        29
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEHSTMOD_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Force Device Mode - forcedevmode
 * 
 * Mode:Host and device. Writing a 1 to this bit forces the core to device mode.
 * After setting the force bit, the application must wait at least 25 ms before the
 * change to take effect. When the simulation is in scale down mode, waiting for
 * 500 micro-sec is sufficient.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description      
 * :----------------------------------------|:------|:------------------
 *  ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_DISD | 0x0   | Normal Mode      
 *  ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_END  | 0x1   | Force Device Mode
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD
 * 
 * Force Device Mode
 */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_MSB        30
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field value. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_FORCEDEVMOD_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Corrupt Tx packet - corrupttxpkt
 * 
 * Mode: Host and device. This bit is for debug purposes only. Never Set this bit
 * to 1. The application should always write 0 to this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_NODBG | 0x0   | Normal Mode
 *  ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_DBG   | 0x1   | Debug Mode 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT
 * 
 * Normal Mode
 */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_NODBG   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT
 * 
 * Debug Mode
 */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_E_DBG     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_MSB        31
/* The width in bits of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field value. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field value. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT field value from a register. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUSBCFG_CORRUPTTXPKT_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GUSBCFG.
 */
struct ALT_USB_GLOB_GUSBCFG_s
{
    uint32_t        toutcal              :  3;  /* HS FS Timeout Calibration */
    const uint32_t  phyif                :  1;  /* PHY Interfac */
    const uint32_t  ulpi_utmi_sel        :  1;  /* ULPI Select */
    const uint32_t  fsintf               :  1;  /* Full-Speed Serial Interface Select */
    const uint32_t  physel               :  1;  /* USB 2.0 High-Speed PHY */
    uint32_t        ddrsel               :  1;  /* ULPI DDR Select */
    uint32_t        srpcap               :  1;  /* SRP-Capable */
    uint32_t        hnpcap               :  1;  /* HNP-Capable */
    uint32_t        usbtrdtim            :  4;  /* USB Turnaround Time */
    uint32_t                             :  4;  /* *UNDEFINED* */
    uint32_t        ulpiautores          :  1;  /* ULPI Auto Resume */
    uint32_t        ulpiclksusm          :  1;  /* ULPI Clock SuspendM */
    uint32_t        ulpiextvbusdrv       :  1;  /* ULPI External VBUS Drive */
    uint32_t        ulpiextvbusindicator :  1;  /* ULPI External VBUS Indicato */
    uint32_t        termseldlpulse       :  1;  /* TermSel DLine Pulsing Selection */
    uint32_t        complement           :  1;  /* Indicator Complement */
    uint32_t        indicator            :  1;  /* Indicator Pass Throug */
    uint32_t        ulpi                 :  1;  /* ULPI Interface Protect Disable */
    uint32_t                             :  2;  /* *UNDEFINED* */
    uint32_t        txenddelay           :  1;  /* Tx End Delay */
    uint32_t        forcehstmode         :  1;  /* Force Host Mode. */
    uint32_t        forcedevmode         :  1;  /* Force Device Mode */
    uint32_t        corrupttxpkt         :  1;  /* Corrupt Tx packet */
};

/* The typedef declaration for register ALT_USB_GLOB_GUSBCFG. */
typedef volatile struct ALT_USB_GLOB_GUSBCFG_s  ALT_USB_GLOB_GUSBCFG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GUSBCFG register from the beginning of the component. */
#define ALT_USB_GLOB_GUSBCFG_OFST        0xc
/* The address of the ALT_USB_GLOB_GUSBCFG register. */
#define ALT_USB_GLOB_GUSBCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GUSBCFG_OFST))

/*
 * Register : Reset Register - grstctl
 * 
 * The application uses this register to reset various hardware features inside the
 * core
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description             
 * :--------|:-------|:------|:-------------------------
 *  [0]     | R      | 0x0   | Core Soft Reset         
 *  [1]     | ???    | 0x0   | *UNDEFINED*             
 *  [2]     | R      | 0x0   | Host Frame Counter Reset
 *  [3]     | ???    | 0x0   | *UNDEFINED*             
 *  [4]     | R      | 0x0   | RxFIFO Flush            
 *  [5]     | R      | 0x0   | TxFIFO Flush            
 *  [10:6]  | RW     | 0x0   | TxFIFO Number           
 *  [29:11] | ???    | 0x0   | *UNDEFINED*             
 *  [30]    | R      | 0x0   | DMA Request Signal      
 *  [31]    | R      | 0x1   | AHB Master Idle         
 * 
 */
/*
 * Field : Core Soft Reset - csftrst
 * 
 * Mode:Host and Device. Resets the hclk and phy_clock domains as follows:Clears
 * the interrupts and all the CSR registers except the following register bits:
 * 
 * * PCGCCTL.RstPdwnModule
 * 
 * * PCGCCTL.GateHclk
 * 
 * * PCGCCTL.PwrClmp
 * 
 * * PCGCCTL.StopPPhyLPwrClkSelclk
 * 
 * * GUSBCFG.PhyLPwrClkSel
 * 
 * * GUSBCFG.DDRSel
 * 
 * * GUSBCFG.PHYSel
 * 
 * * GUSBCFG.FSIntf
 * 
 * * GUSBCFG.ULPI_UTMI_Sel
 * 
 * * GUSBCFG.PHYIf
 * 
 * * HCFG.FSLSPclkSel
 * 
 * * DCFG.DevSpd
 * 
 * * GGPIO
 * 
 * * GPWRDN
 * 
 * * GADPCTL
 * 
 * All module state machines (except the AHB Slave Unit) are reset to the IDLE
 * state, and all the transmit FIFOs and the receive FIFO are flushed. Any
 * transactions on the AHB Master are terminated as soonas possible, after
 * gracefully completing the last data phase of an AHB transfer. Any transactions
 * on the USB are terminated immediately. When Hibernation or ADP feature is
 * enabled, the PMU module is not reset by the Core Soft Reset.The application can
 * write to this bit any time it wants to reset the core. This is a self-clearing
 * bit and the core clears this bit after all the necessary logic is reset in the
 * core, which can take several clocks, depending on the current state of the core.
 * Once this bit is cleared software must wait at least 3 PHY clocks before doing
 * any access to the PHY domain (synchronization delay). Software must also must
 * check that bit 31 of this register is 1 (AHB Master is IDLE) before starting any
 * operation.Typically software reset is used during software development and also
 * when you dynamically change the PHY selection bits in the USB configuration
 * registers listed above. When you change the PHY, the corresponding clock for the
 * PHY is selected and used in the PHY domain. Once a new clock is selected, the
 * PHY domain has to be reset for proper operation.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                      
 * :--------------------------------------|:------|:----------------------------------
 *  ALT_USB_GLOB_GRSTCTL_CSFTRST_E_NOTACT | 0x0   | No reset                         
 *  ALT_USB_GLOB_GRSTCTL_CSFTRST_E_ACT    | 0x1   | Resets hclk and phy_clock domains
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_CSFTRST
 * 
 * No reset
 */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_E_NOTACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_CSFTRST
 * 
 * Resets hclk and phy_clock domains
 */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_MSB        0
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_CSFTRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_CSFTRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GRSTCTL_CSFTRST register field. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_CSFTRST field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GRSTCTL_CSFTRST register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_CSFTRST_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Host Frame Counter Reset - frmcntrrst
 * 
 * Mode:Host only. The application writes this bit to reset the (micro)frame number
 * counter inside the core. When the (micro)frame counter is reset, the subsequent
 * SOF sent out by the core has a (micro)frame number of 0. When application writes
 * 1 to the bit, it might not be able to read back the value as it will get cleared
 * by the core in a few clock cycles.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description             
 * :-----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_NOTACT | 0x0   | No reset                
 *  ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_ACT    | 0x1   | Host Frame Counter Reset
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_FRMCNTRRST
 * 
 * No reset
 */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_NOTACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_FRMCNTRRST
 * 
 * Host Frame Counter Reset
 */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_E_ACT       0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_MSB        2
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field value. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_FRMCNTRRST field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GRSTCTL_FRMCNTRRST register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_FRMCNTRRST_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : RxFIFO Flush - rxfflsh
 * 
 * Mode:Host and Device. The application can flush the entire RxFIFO using this
 * bit, but must first ensure that the core is not in the middle of a transaction.
 * The application must only write to this bit after checking that the core is
 * neither reading from the RxFIFO nor writing to the RxFIFO. The application must
 * wait until the bit is cleared before performing any other operations. This bit
 * requires 8 clocks (slowest of PHY or AHB clock) to clear.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description               
 * :-------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_INACT | 0x0   | no flush the entire RxFIFO
 *  ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_ACT   | 0x1   | flush the entire RxFIFO   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_RXFFLSH
 * 
 * no flush the entire RxFIFO
 */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_RXFFLSH
 * 
 * flush the entire RxFIFO
 */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_MSB        4
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GRSTCTL_RXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_RXFFLSH field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GRSTCTL_RXFFLSH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_RXFFLSH_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : TxFIFO Flush - txfflsh
 * 
 * Mode:Host and Device. This bit selectively flushes a single or all transmit
 * FIFOs, but cannot do so If the core is in the midst of a transaction. The
 * application must write this bit only after checking that the core is neither
 * writing to the TxFIFO nor reading from the TxFIFO. Verify using these registers:
 * ReadNAK Effective Interrupt ensures the core is notreading from the FIFO
 * WriteGRSTCTL.AHBIdle ensures the core is not writinganything to the FIFO.
 * Flushing is normally recommended when FIFOs are reconfigured or when switching
 * between Shared FIFO and Dedicated Transmit FIFO operation. FIFO flushing is also
 * recommended during device endpoint disable. The application must wait until the
 * core clears this bit before performing any operations. This bit takes eight
 * clocks to clear, using the slower clock of phy_clk or hclk.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                 
 * :-------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_INACT | 0x0   | No Flush                                    
 *  ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_ACT   | 0x1   | selectively flushes a single or all transmit
 * :                                     |       | FIFOs                                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFFLSH
 * 
 * No Flush
 */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFFLSH
 * 
 * selectively flushes a single or all transmit FIFOs
 */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_MSB        5
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GRSTCTL_TXFFLSH register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_TXFFLSH field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GRSTCTL_TXFFLSH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_TXFFLSH_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : TxFIFO Number - txfnum
 * 
 * Mode:Host and Device. This is the FIFO number that must be flushed using the
 * TxFIFO Flush bit. This field must not be changed until the core clears the
 * TxFIFO Flush bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                     
 * :------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF0  | 0x0   | - Non-periodic TxFIFO flush in Host mode - Non- 
 * :                                    |       | periodic TxFIFO flush in device mode when in    
 * :                                    |       | shared FIFO operation                           
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF1  | 0x1   | - Periodic TxFIFO flush in Host mode - Periodic 
 * :                                    |       | TxFIFO 1 flush in Device mode when in sharedFIFO
 * :                                    |       | operation                                       
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF2  | 0x2   | - Periodic TxFIFO 2 flush in Device mode when in
 * :                                    |       | sharedFIFO operation- TXFIFO 2 flush in device  
 * :                                    |       | mode when in dedicated FIFO mode                
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF15 | 0xf   | - Periodic TxFIFO 15 flush in Device mode when  
 * :                                    |       | in shared FIFO operation - TXFIFO 15 flush in   
 * :                                    |       | device mode when in dedicated FIFO mode         
 *  ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF16 | 0x10  | Flush all the transmit FIFOs in device or host  
 * :                                    |       | mode.                                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Non-periodic TxFIFO flush in Host mode
 * 
 * * Non-periodic TxFIFO flush in device mode when in shared FIFO operation
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF0  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Periodic TxFIFO flush in Host mode
 * 
 * * Periodic TxFIFO 1 flush in Device mode when in sharedFIFO operation
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF1  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Periodic TxFIFO 2 flush in Device mode when in sharedFIFO operation- TXFIFO 2
 *   flush in device mode when in dedicated FIFO mode
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF2  0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * * Periodic TxFIFO 15 flush in Device mode when in shared FIFO operation
 * 
 * * TXFIFO 15 flush in device mode when in dedicated FIFO mode
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF15 0xf
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_TXFNUM
 * 
 * Flush all the transmit FIFOs in device or host mode.
 */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_E_TXF16 0x10

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_MSB        10
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_WIDTH      5
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_TXFNUM register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_SET_MSK    0x000007c0
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_TXFNUM register field value. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_CLR_MSK    0xfffff83f
/* The reset value of the ALT_USB_GLOB_GRSTCTL_TXFNUM register field. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_TXFNUM field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_GET(value) (((value) & 0x000007c0) >> 6)
/* Produces a ALT_USB_GLOB_GRSTCTL_TXFNUM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_TXFNUM_SET(value) (((value) << 6) & 0x000007c0)

/*
 * Field : DMA Request Signal - dmareq
 * 
 * Mode:Host and Device. Indicates that the DMA request is in progress. Used for
 * debug.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description               
 * :------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GRSTCTL_DMAREQ_E_INACT | 0x0   | No DMA request            
 *  ALT_USB_GLOB_GRSTCTL_DMAREQ_E_ACT   | 0x1   | DMA request is in progress
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_DMAREQ
 * 
 * No DMA request
 */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_DMAREQ
 * 
 * DMA request is in progress
 */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_MSB        30
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_DMAREQ register field value. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_DMAREQ register field value. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GRSTCTL_DMAREQ register field. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRSTCTL_DMAREQ field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GRSTCTL_DMAREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_DMAREQ_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : AHB Master Idle - ahbidle
 * 
 * Mode:Host and Device. Indicates that the AHB Master State Machine is in the IDLE
 * condition.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description    
 * :-------------------------------------|:------|:----------------
 *  ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_INACT | 0x0   | Not Idle       
 *  ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_ACT   | 0x1   | AHB Master Idle
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_AHBIDLE
 * 
 * Not Idle
 */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRSTCTL_AHBIDLE
 * 
 * AHB Master Idle
 */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_MSB        31
/* The width in bits of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field value. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field value. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GRSTCTL_AHBIDLE register field. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_RESET      0x1
/* Extracts the ALT_USB_GLOB_GRSTCTL_AHBIDLE field value from a register. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GRSTCTL_AHBIDLE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRSTCTL_AHBIDLE_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRSTCTL.
 */
struct ALT_USB_GLOB_GRSTCTL_s
{
    const uint32_t  csftrst    :  1;  /* Core Soft Reset */
    uint32_t                   :  1;  /* *UNDEFINED* */
    const uint32_t  frmcntrrst :  1;  /* Host Frame Counter Reset */
    uint32_t                   :  1;  /* *UNDEFINED* */
    const uint32_t  rxfflsh    :  1;  /* RxFIFO Flush */
    const uint32_t  txfflsh    :  1;  /* TxFIFO Flush */
    uint32_t        txfnum     :  5;  /* TxFIFO Number */
    uint32_t                   : 19;  /* *UNDEFINED* */
    const uint32_t  dmareq     :  1;  /* DMA Request Signal */
    const uint32_t  ahbidle    :  1;  /* AHB Master Idle */
};

/* The typedef declaration for register ALT_USB_GLOB_GRSTCTL. */
typedef volatile struct ALT_USB_GLOB_GRSTCTL_s  ALT_USB_GLOB_GRSTCTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GRSTCTL register from the beginning of the component. */
#define ALT_USB_GLOB_GRSTCTL_OFST        0x10
/* The address of the ALT_USB_GLOB_GRSTCTL register. */
#define ALT_USB_GLOB_GRSTCTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRSTCTL_OFST))

/*
 * Register : Interrupt Register - gintsts
 * 
 * This register interrupts the application for system-level events in the current
 * mode (Device mode or Host mode). Some of the bits in this register are valid
 * only in Host mode, while others are valid in Device mode only. This register
 * also indicates the current mode. To clear the interrupt status bits of type
 * R_SS_WC, the application must write 1 into the bit. The FIFO status interrupts
 * are read only; once software reads from or writes to the FIFO while servicing
 * these interrupts, FIFO interrupt conditions are cleared automatically. The
 * application must clear the GINTSTS register at initialization before unmasking
 * the interrupt bit to avoid any interrupts generated prior to initialization.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                   
 * :--------|:-------|:------|:-----------------------------------------------
 *  [0]     | R      | 0x0   | Current Mode of Operation                     
 *  [1]     | R      | 0x0   | Mode Mismatch Interrupt                       
 *  [2]     | R      | 0x0   | OTG Interrupt                                 
 *  [3]     | R      | 0x0   | Start of Frame                                
 *  [4]     | R      | 0x0   | RxFIFO Non-Empty                              
 *  [5]     | ???    | 0x0   | *UNDEFINED*                                   
 *  [6]     | R      | 0x0   | Global IN Non-periodic NAK Effective          
 *  [7]     | R      | 0x0   | Global OUT NAK Effective                      
 *  [9:8]   | ???    | 0x0   | *UNDEFINED*                                   
 *  [10]    | R      | 0x0   | Early Suspend                                 
 *  [11]    | R      | 0x0   | USB Suspend                                   
 *  [12]    | R      | 0x0   | USB Reset                                     
 *  [13]    | R      | 0x0   | Enumeration Done                              
 *  [14]    | R      | 0x0   | Isochronous OUT Packet Dropped Interrupt      
 *  [16:15] | ???    | 0x0   | *UNDEFINED*                                   
 *  [17]    | R      | 0x0   | Endpoint Mismatch Interrupt                   
 *  [18]    | R      | 0x0   | IN Endpoints Interrupt                        
 *  [19]    | R      | 0x0   | OUT Endpoints Interrupt                       
 *  [20]    | R      | 0x0   | Incomplete Isochronous IN Transfer            
 *  [21]    | R      | 0x0   | Incomplete Periodic Transfer                  
 *  [22]    | R      | 0x0   | Data Fetch Suspended                          
 *  [23]    | R      | 0x0   | Reset detected Interrupt                      
 *  [24]    | R      | 0x0   | Host Port Interrupt                           
 *  [25]    | R      | 0x0   | Host Channels Interrupt                       
 *  [26]    | R      | 0x1   | Periodic TxFIFO Empty                         
 *  [27]    | ???    | 0x0   | *UNDEFINED*                                   
 *  [28]    | R      | 0x1   | Connector ID Status Change                    
 *  [29]    | R      | 0x0   | Disconnect Detected Interrupt                 
 *  [30]    | R      | 0x0   | Session Request New Session Detected Interrupt
 *  [31]    | R      | 0x0   | Resume Remote Wakeup Detected Interrupt       
 * 
 */
/*
 * Field : Current Mode of Operation - curmod
 * 
 * Mode: Host and Device. Indicates the current mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GINTSTS_CURMOD_E_DEVICE | 0x0   | Device mode
 *  ALT_USB_GLOB_GINTSTS_CURMOD_E_HOST   | 0x1   | Host mode  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CURMOD
 * 
 * Device mode
 */
#define ALT_USB_GLOB_GINTSTS_CURMOD_E_DEVICE    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CURMOD
 * 
 * Host mode
 */
#define ALT_USB_GLOB_GINTSTS_CURMOD_E_HOST      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_MSB        0
/* The width in bits of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_CURMOD register field value. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_CURMOD register field value. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_GLOB_GINTSTS_CURMOD register field. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_CURMOD field value from a register. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_GLOB_GINTSTS_CURMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_CURMOD_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Mode Mismatch Interrupt - modemis
 * 
 * Mode: Host and Device. The core sets this bit when the application is trying to
 * access:
 * 
 * * A Host mode register, when the core is operating in Device mode. -A Device
 *   mode register, when the core is operating in Host mode.
 * 
 * The register access is completed on the AHB with an OKAYresponse, but is ignored
 * by the core internally and does not affect the operation of the core. This bit
 * can be set only by the core and the application should write 1 to clearit
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description               
 * :------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTSTS_MODMIS_E_INACT | 0x0   | No Mode Mismatch Interrupt
 *  ALT_USB_GLOB_GINTSTS_MODMIS_E_ACT   | 0x1   | Mode Mismatch Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_MODMIS
 * 
 * No Mode Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_MODMIS_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_MODMIS
 * 
 * Mode Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_MODMIS_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_MSB        1
/* The width in bits of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_MODMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_MODMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_GLOB_GINTSTS_MODMIS register field. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_MODMIS field value from a register. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_GLOB_GINTSTS_MODMIS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_MODMIS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : OTG Interrupt - otgint
 * 
 * Mode: Host and Device. The core sets this bit to indicate an OTG protocol event.
 * The application must read the OTG Interrupt Status (GOTGINT) register to
 * determine the exact event that caused this interrupt. The application must clear
 * the appropriate status bit in the GOTGINT register to clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description  
 * :------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GINTSTS_OTGINT_E_INACT | 0x0   | No Interrupt 
 *  ALT_USB_GLOB_GINTSTS_OTGINT_E_ACT   | 0x1   | OTG Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OTGINT
 * 
 * No Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_OTGINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OTGINT
 * 
 * OTG Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_OTGINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_MSB        2
/* The width in bits of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_OTGINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_OTGINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GINTSTS_OTGINT register field. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_OTGINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GINTSTS_OTGINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_OTGINT_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Start of Frame - sof
 * 
 * Mode: Host and Device. In Host mode, the core sets this bit to indicate that an
 * SOF (FS), micro-SOF (HS), or Keep-Alive (LS) is transmitted on the USB. The
 * application must write a 1 to this bit to clear the interrupt. In Device mode,
 * the core sets this bit to indicate that an SOF token has been received on the
 * USB. The application can read the Device Status register to get the current
 * (micro)Frame number. This interrupt is seen only when the core is operating at
 * either HS or FS. This bit can be set only by the core and the application should
 * write 1 to clear it. This register may return 1 if read immediately after power
 * on reset. If the register bit reads 1 immediately after power on reset it does
 * not indicate that an SOF has been sent (in case of host mode) or SOF has been
 * received (in case of device mode). The read value of this interrupt is valid
 * only after a valid connection between host and device is established. If the bit
 * is set after power on reset the application can clear the bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description   
 * :----------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GINTSTS_SOF_E_INTACT | 0x0   | No sof        
 *  ALT_USB_GLOB_GINTSTS_SOF_E_ACT    | 0x1   | Start of Frame
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SOF
 * 
 * No sof
 */
#define ALT_USB_GLOB_GINTSTS_SOF_E_INTACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SOF
 * 
 * Start of Frame
 */
#define ALT_USB_GLOB_GINTSTS_SOF_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_MSB        3
/* The width in bits of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_SOF register field value. */
#define ALT_USB_GLOB_GINTSTS_SOF_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_SOF register field value. */
#define ALT_USB_GLOB_GINTSTS_SOF_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GINTSTS_SOF register field. */
#define ALT_USB_GLOB_GINTSTS_SOF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_SOF field value from a register. */
#define ALT_USB_GLOB_GINTSTS_SOF_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GINTSTS_SOF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_SOF_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : RxFIFO Non-Empty - rxflvl
 * 
 * Mode: Host and Device. Indicates that there is at least one packet pending to be
 * read from the RxFIFO.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_GLOB_GINTSTS_RXFLVL_E_INACT | 0x0   | Not Active       
 *  ALT_USB_GLOB_GINTSTS_RXFLVL_E_ACT   | 0x1   | Rx Fifo Non Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RXFLVL
 * 
 * Not Active
 */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RXFLVL
 * 
 * Rx Fifo Non Empty
 */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_MSB        4
/* The width in bits of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_RXFLVL register field value. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_RXFLVL register field value. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GINTSTS_RXFLVL register field. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_RXFLVL field value from a register. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GINTSTS_RXFLVL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_RXFLVL_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Global IN Non-periodic NAK Effective - ginnakeff
 * 
 * Mode: Device only. Indicates that the Set Global Non-periodic IN NAK bit in the
 * Device Control register (DCTL.SGNPInNak), Set by the application, has taken
 * effect in the core. That is, the core has sampled the Global IN NAK bit Set by
 * the application. This bit can be cleared by clearing the Clear Global Non-
 * periodic IN NAK bit in the Device Control register (DCTL.CGNPInNak). This
 * interrupt does not necessarily mean that a NAK handshake is sent out on the USB.
 * The STALL bit takes precedence over the NAK bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                      
 * :---------------------------------------|:------|:----------------------------------
 *  ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_INACT | 0x0   | Not active                       
 *  ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_ACT   | 0x1   | Set Global Non-periodic IN NAK bi
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GINNAKEFF
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GINNAKEFF
 * 
 * Set Global Non-periodic IN NAK bi
 */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_MSB        6
/* The width in bits of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GINTSTS_GINNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_GINNAKEFF field value from a register. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GINTSTS_GINNAKEFF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_GINNAKEFF_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Global OUT NAK Effective - goutnakeff
 * 
 * Mode: Device only. Indicates that the Set Global OUT NAK bit in the Device
 * Control register (DCTL.SGOUTNak), Set by the application, has taken effect in
 * the core. This bit can be cleared by writing the Clear Global OUT NAK bit in the
 * Device Control register (DCTL.CGOUTNak).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description             
 * :----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_INACT | 0x0   | No Active               
 *  ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_ACT   | 0x1   | Global OUT NAK Effective
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GOUTNAKEFF
 * 
 * No Active
 */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_GOUTNAKEFF
 * 
 * Global OUT NAK Effective
 */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_MSB        7
/* The width in bits of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field value. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_GOUTNAKEFF field value from a register. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GINTSTS_GOUTNAKEFF register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_GOUTNAKEFF_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Early Suspend - erlysusp
 * 
 * Mode: Device only. The core sets this bit to indicate that an Idle state has
 * been detected on the USB for 3 ms.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description        
 * :--------------------------------------|:------|:--------------------
 *  ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_INACT | 0x0   | No Idle            
 *  ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_ACT   | 0x1   | Idle state detecetd
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ERLYSUSP
 * 
 * No Idle
 */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ERLYSUSP
 * 
 * Idle state detecetd
 */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_MSB        10
/* The width in bits of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GINTSTS_ERLYSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_ERLYSUSP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GINTSTS_ERLYSUSP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_ERLYSUSP_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : USB Suspend - usbsusp
 * 
 * Mode: Device only. The core sets this bit to indicate that a suspend was
 * detected on the USB. The core enters the Suspended state when there is no
 * activity on the phy_line_state_i signal for an extended period of time.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GINTSTS_USBSUSP_E_INACT | 0x0   | Not Active 
 *  ALT_USB_GLOB_GINTSTS_USBSUSP_E_ACT   | 0x1   | USB Suspend
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBSUSP
 * 
 * Not Active
 */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBSUSP
 * 
 * USB Suspend
 */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_MSB        11
/* The width in bits of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_USBSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_USBSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GINTSTS_USBSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_USBSUSP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GINTSTS_USBSUSP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_USBSUSP_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : USB Reset - usbrst
 * 
 * Mode: Device only. The core sets this bit to indicate that a reset is detected
 * on the USB.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GINTSTS_USBRST_E_INACT | 0x0   | Not active 
 *  ALT_USB_GLOB_GINTSTS_USBRST_E_ACT   | 0x1   | USB Reset  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBRST
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_USBRST_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_USBRST
 * 
 * USB Reset
 */
#define ALT_USB_GLOB_GINTSTS_USBRST_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_MSB        12
/* The width in bits of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_USBRST register field value. */
#define ALT_USB_GLOB_GINTSTS_USBRST_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_USBRST register field value. */
#define ALT_USB_GLOB_GINTSTS_USBRST_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_GLOB_GINTSTS_USBRST register field. */
#define ALT_USB_GLOB_GINTSTS_USBRST_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_USBRST field value from a register. */
#define ALT_USB_GLOB_GINTSTS_USBRST_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_GLOB_GINTSTS_USBRST register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_USBRST_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Enumeration Done - enumdone
 * 
 * Mode: Device only. The core sets this bit to indicate that speed enumeration is
 * complete. The application must read the Device Status register to obtain the
 * enumerated speed.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description     
 * :--------------------------------------|:------|:-----------------
 *  ALT_USB_GLOB_GINTSTS_ENUMDONE_E_INACT | 0x0   | Not active      
 *  ALT_USB_GLOB_GINTSTS_ENUMDONE_E_ACT   | 0x1   | Enumeration Done
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ENUMDONE
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ENUMDONE
 * 
 * Enumeration Done
 */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_MSB        13
/* The width in bits of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_ENUMDONE register field value. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_ENUMDONE register field value. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_GLOB_GINTSTS_ENUMDONE register field. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_ENUMDONE field value from a register. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_GLOB_GINTSTS_ENUMDONE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_ENUMDONE_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : Isochronous OUT Packet Dropped Interrupt - isooutdrop
 * 
 * Mode: Device only. The core sets this bit when it fails to write an isochronous
 * OUT packet into the RxFIFO because the RxFIFO does not have enough space to
 * accommodate a maximum packet size packet for the isochronous OUT endpoint.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                            
 * :----------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_INACT | 0x0   | Not active                             
 *  ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_ACT   | 0x1   | Isochronous OUT Packet Dropped Interrup
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ISOOUTDROP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_ISOOUTDROP
 * 
 * Isochronous OUT Packet Dropped Interrup
 */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_MSB        14
/* The width in bits of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field value. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_SET_MSK    0x00004000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field value. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_CLR_MSK    0xffffbfff
/* The reset value of the ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_ISOOUTDROP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_USB_GLOB_GINTSTS_ISOOUTDROP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_ISOOUTDROP_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : Endpoint Mismatch Interrupt - epmis
 * 
 * Mode: Device only. This interrupt is valid only in shared FIFO operation.
 * Indicates that an IN token has been received for a non-periodic endpoint, but
 * the data for another endpoint is present in the top of the Non-periodic Transmit
 * FIFO and the IN endpoint mismatch count programmed by the application has
 * expired.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description               
 * :-----------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTSTS_EPMIS_E_INACT | 0x0   | Not active                
 *  ALT_USB_GLOB_GINTSTS_EPMIS_E_ACT   | 0x1   | Endpoint Mismatch Interrup
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_EPMIS
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_EPMIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_EPMIS
 * 
 * Endpoint Mismatch Interrup
 */
#define ALT_USB_GLOB_GINTSTS_EPMIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_MSB        17
/* The width in bits of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_EPMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_EPMIS register field value. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_EPMIS register field. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_EPMIS field value from a register. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GINTSTS_EPMIS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_EPMIS_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : IN Endpoints Interrupt - iepint
 * 
 * Mode: Device only. The core sets this bit to indicate that an interrupt is
 * pending on one of the IN endpoints of the core (in Device mode). The application
 * must read the Device All Endpoints Interrupt (DAINT) register to determine the
 * exact number of the IN endpoint on Device IN Endpoint-n Interrupt (DIEPINTn)
 * register to determine the exact cause of the interrupt. The application must
 * clear the appropriate status bit in the corresponding DIEPINTn register to clear
 * this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description           
 * :------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GINTSTS_IEPINT_E_INACT | 0x0   | Not active            
 *  ALT_USB_GLOB_GINTSTS_IEPINT_E_ACT   | 0x1   | IN Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_IEPINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_IEPINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_IEPINT
 * 
 * IN Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_IEPINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_MSB        18
/* The width in bits of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_IEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_IEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_IEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_IEPINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GINTSTS_IEPINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_IEPINT_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : OUT Endpoints Interrupt - oepint
 * 
 * Mode: Device only. The core sets this bit to indicate that an interrupt is
 * pending on one of the OUT endpoints of the core (in Device mode). The
 * application must read the Device All Endpoints Interrupt (DAINT) register to
 * determine the exact number of the OUT endpoint on which the interrupt occurred,
 * and Then read the corresponding Device OUT Endpoint-n Interrupt (DOEPINTn)
 * register to determine the exact cause of the interrupt. The application must
 * clear the appropriate status bit in the corresponding DOEPINTn register to clear
 * this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GINTSTS_OEPINT_E_INACT | 0x0   | Not active             
 *  ALT_USB_GLOB_GINTSTS_OEPINT_E_ACT   | 0x1   | OUT Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OEPINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_OEPINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_OEPINT
 * 
 * OUT Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_OEPINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_MSB        19
/* The width in bits of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_OEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_OEPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_OEPINT register field. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_OEPINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GINTSTS_OEPINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_OEPINT_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : Incomplete Isochronous IN Transfer - incompisoin
 * 
 * Mode: Device only. The core sets this interrupt to indicate that there is at
 * least isochronous IN endpoint on which the transfer is not completed in the
 * current microframe. This interrupt is asserted along with the End of Periodic
 * Frame Interrupt (EOPF) bit in this register. This interrupt is not asserted in
 * Scatter/Gather DMA mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                       
 * :-----------------------------------------|:------|:-----------------------------------
 *  ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_INACT | 0x0   | Not active                        
 *  ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_ACT   | 0x1   | Incomplete Isochronous IN Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPISOIN
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPISOIN
 * 
 * Incomplete Isochronous IN Transfer
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_MSB        20
/* The width in bits of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_INCOMPISOIN field value from a register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GINTSTS_INCOMPISOIN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPISOIN_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : Incomplete Periodic Transfer - incomplp
 * 
 * Mode: Device only. In Host mode, the core sets this interrupt bit when there are
 * incomplete periodic transactions still pending which arescheduled for the
 * current microframe. Incomplete Isochronous OUT Transfer (incompISOOUT) The
 * Device mode, the core sets this interrupt to indicate that there is at least one
 * isochronous OUT endpoint on which the transfer is not completed in the current
 * microframe. This interrupt is asserted along with the End of Periodic Frame
 * Interrupt (EOPF) bit in this register. This bit can be set only by the core and
 * the application should write 1 to clear it
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                 
 * :--------------------------------------|:------|:-----------------------------
 *  ALT_USB_GLOB_GINTSTS_INCOMPLP_E_INACT | 0x0   | Not active                  
 *  ALT_USB_GLOB_GINTSTS_INCOMPLP_E_ACT   | 0x1   | Incomplete Periodic Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPLP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_INCOMPLP
 * 
 * Incomplete Periodic Transfer
 */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_MSB        21
/* The width in bits of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_INCOMPLP register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_INCOMPLP register field value. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_INCOMPLP register field. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_INCOMPLP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GINTSTS_INCOMPLP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_INCOMPLP_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : Data Fetch Suspended - fetsusp
 * 
 * Mode: Device only. This interrupt is valid only in DMA mode. This interrupt
 * indicates that the core has stopped fetching data for IN endpoints due to the
 * unavailability of TxFIFO space or Request Queue space. This interrupt is used by
 * the application for an endpoint mismatch algorithm. for example, after detecting
 * an endpoint mismatch, the application:
 * 
 * * Sets a Global non-periodic IN NAK handshake
 * 
 * * Disables In endpoints
 * 
 * * Flushes the FIFO
 * 
 * * Determines the token sequence from the IN Token Sequence
 * 
 * Learning Queue
 * 
 * * Re-enables the endpoints
 * 
 * * Clears the Global non-periodic IN NAK handshake
 * 
 * If the Global non-periodic IN NAK is cleared, the core has not yet fetched data
 * for the IN endpoint, and the IN token is received: the core generates an IN
 * token received when FIFO empty interrupt. The OTG Then sends the host a NAK
 * response. To avoid this scenario, the application can check the GINTSTS.FetSusp
 * interrupt, which ensures that the FIFO is full before clearing a Global NAK
 * handshake. Alternatively, the application can mask the "IN token received when
 * FIFO empty" interrupt when clearing a Global IN NAKhandshake.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description         
 * :-------------------------------------|:------|:---------------------
 *  ALT_USB_GLOB_GINTSTS_FETSUSP_E_INACT | 0x0   | Not active          
 *  ALT_USB_GLOB_GINTSTS_FETSUSP_E_ACT   | 0x1   | Data Fetch Suspended
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_FETSUSP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_FETSUSP
 * 
 * Data Fetch Suspended
 */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_MSB        22
/* The width in bits of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_FETSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_FETSUSP register field value. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_FETSUSP register field. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_FETSUSP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GINTSTS_FETSUSP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_FETSUSP_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : Reset detected Interrupt - resetdet
 * 
 * Mode: Device only. In Device mode, this interrupt is asserted when a reset is
 * detected on the USB in partial power-down mode when the device is in Suspend. In
 * Host mode, this interrupt is not asserted.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GINTSTS_RSTDET_E_INACT | 0x0   | Not active             
 *  ALT_USB_GLOB_GINTSTS_RSTDET_E_ACT   | 0x1   | Reset detected Interrup
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RSTDET
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_RSTDET_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_RSTDET
 * 
 * Reset detected Interrup
 */
#define ALT_USB_GLOB_GINTSTS_RSTDET_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_MSB        23
/* The width in bits of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_RSTDET register field value. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_RSTDET register field value. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_RSTDET register field. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_RSTDET field value from a register. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GINTSTS_RSTDET register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_RSTDET_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : Host Port Interrupt - prtint
 * 
 * Mode:Host only. The core sets this bit to indicate a change in port status of
 * one of the otg core ports in Host mode. The application must read the Host Port
 * Control and Status (HPRT) register to determine the exact event that caused this
 * interrupt. The application must clear the appropriate status bit in the Host PC
 * Control and Status register to clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description        
 * :------------------------------------|:------|:--------------------
 *  ALT_USB_GLOB_GINTSTS_PRTINT_E_INACT | 0x0   |                    
 *  ALT_USB_GLOB_GINTSTS_PRTINT_E_ACT   | 0x1   | Host Port Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PRTINT
 * 
 */
#define ALT_USB_GLOB_GINTSTS_PRTINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PRTINT
 * 
 * Host Port Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_PRTINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_MSB        24
/* The width in bits of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_PRTINT register field value. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_PRTINT register field value. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_PRTINT register field. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_PRTINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GINTSTS_PRTINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_PRTINT_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Host Channels Interrupt - hchint
 * 
 * Mode:Host only. The core sets this bit to indicate that an interrupt is pending
 * on one of the channels of the core (in Host mode). The application must read the
 * Host All Channels Interrupt (HAINT) register to determine the exact number of
 * the channel on which the interrupt occurred, and Then read the corresponding
 * Host Channel-n Interrupt (HCINTn) register to determine the exact cause of the
 * interrupt. The application must clear the appropriate status bit in the HCINTn
 * register to clear this bit.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description            
 * :------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GINTSTS_HCHINT_E_INACT | 0x0   | Not active             
 *  ALT_USB_GLOB_GINTSTS_HCHINT_E_ACT   | 0x1   | Host Channels Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_HCHINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_HCHINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_HCHINT
 * 
 * Host Channels Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_HCHINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_MSB        25
/* The width in bits of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_HCHINT register field value. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_HCHINT register field value. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_HCHINT register field. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_HCHINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GINTSTS_HCHINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_HCHINT_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Periodic TxFIFO Empty - ptxfemp
 * 
 * Mode:Host only. This interrupt is asserted when the Periodic Transmit FIFO is
 * either half or completely empty and there is space for at least one entry to be
 * written in the Periodic Request Queue. The half or completely empty status is
 * determined by the Periodic TxFIFO Empty Level bit in the Core AHB Configuration
 * register (GAHBCFG.PTxFEmpLvl).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description          
 * :-------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GINTSTS_PTXFEMP_E_INACT | 0x0   | Not active           
 *  ALT_USB_GLOB_GINTSTS_PTXFEMP_E_ACT   | 0x1   | Periodic TxFIFO Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PTXFEMP
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_PTXFEMP
 * 
 * Periodic TxFIFO Empty
 */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_MSB        26
/* The width in bits of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_PTXFEMP register field value. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_PTXFEMP register field value. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_PTXFEMP register field. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_RESET      0x1
/* Extracts the ALT_USB_GLOB_GINTSTS_PTXFEMP field value from a register. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_GLOB_GINTSTS_PTXFEMP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_PTXFEMP_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Connector ID Status Change - ConIDStsChng
 * 
 * Mode:Host and Device. The core sets this bit when there is a change in connector
 * ID status. This bit can be set only by the core and the application should write
 * 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description               
 * :------------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_INACT | 0x0   | Not Active                
 *  ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_ACT   | 0x1   | Connector ID Status Change
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG
 * 
 * Not Active
 */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG
 * 
 * Connector ID Status Change
 */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_MSB        28
/* The width in bits of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field value. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_SET_MSK    0x10000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field value. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_CLR_MSK    0xefffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_RESET      0x1
/* Extracts the ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG field value from a register. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_CONIDSTSCHNG_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : Disconnect Detected Interrupt - disconnint
 * 
 * Mode:Host only. Asserted when a device disconnect is detected. This bit can be
 * set only by the core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                  
 * :----------------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GINTSTS_DISCONNINT_E_INACT | 0x0   | Not active                   
 *  ALT_USB_GLOB_GINTSTS_DISCONNINT_E_ACT   | 0x1   | Disconnect Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_DISCONNINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_DISCONNINT
 * 
 * Disconnect Detected Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_MSB        29
/* The width in bits of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_DISCONNINT register field value. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_DISCONNINT register field value. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_DISCONNINT register field. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_DISCONNINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_GLOB_GINTSTS_DISCONNINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_DISCONNINT_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Session Request New Session Detected Interrupt - sessreqint
 * 
 * Mode:Host and Device. In Host mode, this interrupt is asserted when a session
 * request is detected from the device. In Host mode, this interrupt is asserted
 * when a session request is detected from the device. In Device mode, this
 * interrupt is asserted when the utmisrp_bvalid signal goes high. This bit can be
 * set only by the core and the application should write 1 to clear.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                   
 * :----------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GINTSTS_SESSREQINT_E_INACT | 0x0   | Not active                                    
 *  ALT_USB_GLOB_GINTSTS_SESSREQINT_E_ACT   | 0x1   | Session Request New Session Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SESSREQINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_SESSREQINT
 * 
 * Session Request New Session Detected Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_MSB        30
/* The width in bits of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_SESSREQINT register field value. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_SESSREQINT register field value. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_SESSREQINT register field. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_SESSREQINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GINTSTS_SESSREQINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_SESSREQINT_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Resume Remote Wakeup Detected Interrupt - wkupint
 * 
 * Mode:Host and Device. Wakeup Interrupt during Suspend(L2) or LPM(L1) state.
 * -During Suspend(L2):
 * 
 * * Device Mode - This interrupt is asserted only when Host Initiated Resume is
 *   detected on USB.
 * 
 * * Host Mode - This interrupt is asserted only when Device Initiated Remote
 *   Wakeup is detected on USB
 * 
 * * During LPM(L1):- - Device Mode - This interrupt is asserted for either Host
 *   Initiated Resume or Device Initiated Remote Wakeup on USB.
 * 
 * * Host Mode - This interrupt is asserted for either Host Initiated Resume or
 *   Device Initiated Remote Wakeup on USB.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                            
 * :-------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GINTSTS_WKUPINT_E_INACT | 0x0   | Not active                             
 *  ALT_USB_GLOB_GINTSTS_WKUPINT_E_ACT   | 0x1   | Resume Remote Wakeup Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_WKUPINT
 * 
 * Not active
 */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTSTS_WKUPINT
 * 
 * Resume Remote Wakeup Detected Interrupt
 */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_MSB        31
/* The width in bits of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTSTS_WKUPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GINTSTS_WKUPINT register field value. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GINTSTS_WKUPINT register field. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTSTS_WKUPINT field value from a register. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GINTSTS_WKUPINT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTSTS_WKUPINT_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GINTSTS.
 */
struct ALT_USB_GLOB_GINTSTS_s
{
    const uint32_t  curmod       :  1;  /* Current Mode of Operation */
    const uint32_t  modemis      :  1;  /* Mode Mismatch Interrupt */
    const uint32_t  otgint       :  1;  /* OTG Interrupt */
    const uint32_t  sof          :  1;  /* Start of Frame */
    const uint32_t  rxflvl       :  1;  /* RxFIFO Non-Empty */
    uint32_t                     :  1;  /* *UNDEFINED* */
    const uint32_t  ginnakeff    :  1;  /* Global IN Non-periodic NAK Effective */
    const uint32_t  goutnakeff   :  1;  /* Global OUT NAK Effective */
    uint32_t                     :  2;  /* *UNDEFINED* */
    const uint32_t  erlysusp     :  1;  /* Early Suspend */
    const uint32_t  usbsusp      :  1;  /* USB Suspend */
    const uint32_t  usbrst       :  1;  /* USB Reset */
    const uint32_t  enumdone     :  1;  /* Enumeration Done */
    const uint32_t  isooutdrop   :  1;  /* Isochronous OUT Packet Dropped Interrupt */
    uint32_t                     :  2;  /* *UNDEFINED* */
    const uint32_t  epmis        :  1;  /* Endpoint Mismatch Interrupt */
    const uint32_t  iepint       :  1;  /* IN Endpoints Interrupt */
    const uint32_t  oepint       :  1;  /* OUT Endpoints Interrupt */
    const uint32_t  incompisoin  :  1;  /* Incomplete Isochronous IN Transfer */
    const uint32_t  incomplp     :  1;  /* Incomplete Periodic Transfer */
    const uint32_t  fetsusp      :  1;  /* Data Fetch Suspended */
    const uint32_t  resetdet     :  1;  /* Reset detected Interrupt */
    const uint32_t  prtint       :  1;  /* Host Port Interrupt */
    const uint32_t  hchint       :  1;  /* Host Channels Interrupt */
    const uint32_t  ptxfemp      :  1;  /* Periodic TxFIFO Empty */
    uint32_t                     :  1;  /* *UNDEFINED* */
    const uint32_t  ConIDStsChng :  1;  /* Connector ID Status Change */
    const uint32_t  disconnint   :  1;  /* Disconnect Detected Interrupt */
    const uint32_t  sessreqint   :  1;  /* Session Request New Session Detected Interrupt */
    const uint32_t  wkupint      :  1;  /* Resume Remote Wakeup Detected Interrupt */
};

/* The typedef declaration for register ALT_USB_GLOB_GINTSTS. */
typedef volatile struct ALT_USB_GLOB_GINTSTS_s  ALT_USB_GLOB_GINTSTS_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GINTSTS register from the beginning of the component. */
#define ALT_USB_GLOB_GINTSTS_OFST        0x14
/* The address of the ALT_USB_GLOB_GINTSTS register. */
#define ALT_USB_GLOB_GINTSTS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GINTSTS_OFST))

/*
 * Register : Interrupt Mask Register - gintmsk
 * 
 * This register works with the Interrupt Register (GINTSTS) to interrupt the
 * application. When an interrupt bit is masked, the interrupt associated with that
 * bit is not generated. However, the GINTSTS register bit corresponding to that
 * interrupt is still set.
 * 
 * Register Layout
 * 
 *  Bits  | Access | Reset | Description                                       
 * :------|:-------|:------|:---------------------------------------------------
 *  [0]   | ???    | 0x0   | *UNDEFINED*                                       
 *  [1]   | RW     | 0x0   | Mode Mismatch Interrupt Mask                      
 *  [2]   | RW     | 0x0   | OTG Interrupt Mask                                
 *  [3]   | RW     | 0x0   | Start of (micro)Frame Mask                        
 *  [4]   | RW     | 0x0   | Receive FIFO Non-Empty Mask                       
 *  [5]   | ???    | 0x0   | *UNDEFINED*                                       
 *  [6]   | RW     | 0x0   | Global Non-periodic IN NAK Effective Mask         
 *  [7]   | RW     | 0x0   | Global OUT NAK Effective Mask                     
 *  [9:8] | ???    | 0x0   | *UNDEFINED*                                       
 *  [10]  | RW     | 0x0   | Early Suspend Mask                                
 *  [11]  | RW     | 0x0   | USB Suspend Mask                                  
 *  [12]  | RW     | 0x0   | USB Reset Mask                                    
 *  [13]  | RW     | 0x0   | Enumeration Done Mask                             
 *  [14]  | RW     | 0x0   | Isochronous OUT Packet Dropped Interrupt Mask     
 *  [15]  | RW     | 0x0   | End of Periodic Frame Interrupt Mask              
 *  [16]  | ???    | 0x0   | *UNDEFINED*                                       
 *  [17]  | RW     | 0x0   | Endpoint Mismatch Interrupt Mask                  
 *  [18]  | RW     | 0x0   | IN Endpoints Interrupt Mask                       
 *  [19]  | RW     | 0x0   | OUT Endpoints Interrupt Mask                      
 *  [20]  | RW     | 0x0   | Incomplete Isochronous IN Transfer Mask           
 *  [21]  | RW     | 0x0   | Incomplete Periodic Transfer Mask                 
 *  [22]  | RW     | 0x0   | Data Fetch Suspended Mask                         
 *  [23]  | RW     | 0x0   | Reset detected Interrupt Mask                     
 *  [24]  | RW     | 0x0   | Host Port Interrupt Mask                          
 *  [25]  | RW     | 0x0   | Host Channels Interrupt Mask                      
 *  [26]  | RW     | 0x0   | Periodic TxFIFO Empty Mask                        
 *  [27]  | ???    | 0x0   | *UNDEFINED*                                       
 *  [28]  | RW     | 0x0   | Connector ID Status Change Mask                   
 *  [29]  | RW     | 0x0   | ALT_USB_GLOB_GINTMSK_DISCONNINTMSK                
 *  [30]  | RW     | 0x0   | Session Request New Session Detected Interrupt Mas
 *  [31]  | RW     | 0x0   | Resume Remote Wakeup Detected Interrupt Mask      
 * 
 */
/*
 * Field : Mode Mismatch Interrupt Mask - modemismsk
 * 
 * Mode: Host and Device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                    
 * :---------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GINTMSK_MODMISMSK_E_MSK   | 0x0   | Mode Mismatch Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_MODMISMSK_E_NOMSK | 0x1   | No Mask Mode Mismatch Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_MODMISMSK
 * 
 * Mode Mismatch Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_MODMISMSK
 * 
 * No Mask Mode Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_MSB        1
/* The width in bits of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_MODMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_MODMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_GLOB_GINTMSK_MODMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_MODMISMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_GLOB_GINTMSK_MODMISMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_MODMISMSK_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : OTG Interrupt Mask - otgintmsk
 * 
 * Mode: Host and Device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description          
 * :---------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_MSK   | 0x0   | OTG Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_NOMSK | 0x1   | No mask OTG Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OTGINTMSK
 * 
 * OTG Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OTGINTMSK
 * 
 * No mask OTG Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_MSB        2
/* The width in bits of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_GLOB_GINTMSK_OTGINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_OTGINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_GLOB_GINTMSK_OTGINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_OTGINTMSK_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Start of (micro)Frame Mask - sofmsk
 * 
 * Mode: Host and Device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description           
 * :------------------------------------|:------|:-----------------------
 *  ALT_USB_GLOB_GINTMSK_SOFMSK_E_MSK   | 0x0   | Start of Frame Mask   
 *  ALT_USB_GLOB_GINTMSK_SOFMSK_E_NOMSK | 0x1   | No Mask Start of Frame
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SOFMSK
 * 
 * Start of Frame Mask
 */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SOFMSK
 * 
 * No Mask Start of Frame
 */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_MSB        3
/* The width in bits of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_SOFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_SOFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_GLOB_GINTMSK_SOFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_SOFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_GLOB_GINTMSK_SOFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_SOFMSK_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Receive FIFO Non-Empty Mask - rxflvlmsk
 * 
 * Mode: Host and Device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                   
 * :---------------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_MSK   | 0x0   | Receive FIFO Non-Empty Mask   
 *  ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_NOMSK | 0x1   | No maks Receive FIFO Non-Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RXFLVLMSK
 * 
 * Receive FIFO Non-Empty Mask
 */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RXFLVLMSK
 * 
 * No maks Receive FIFO Non-Empty
 */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_MSB        4
/* The width in bits of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_RXFLVLMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GINTMSK_RXFLVLMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_RXFLVLMSK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Global Non-periodic IN NAK Effective Mask - ginnakeffmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                 
 * :------------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_MSK   | 0x0   | Global Non-periodic IN NAK Effective Mask   
 *  ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_NOMSK | 0x1   | No mask Global Non-periodic IN NAK Effective
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK
 * 
 * Global Non-periodic IN NAK Effective Mask
 */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK
 * 
 * No mask Global Non-periodic IN NAK Effective
 */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_MSB        6
/* The width in bits of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_GINNAKEFFMSK_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Global OUT NAK Effective Mask - goutnakeffmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                     
 * :--------------------------------------------|:------|:---------------------------------
 *  ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_MSK    | 0x0   | Global OUT NAK Effective Mask   
 *  ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_NOMAKS | 0x1   | No mask Global OUT NAK Effective
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK
 * 
 * Global OUT NAK Effective Mask
 */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK
 * 
 * No mask Global OUT NAK Effective
 */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_E_NOMAKS 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_MSB        7
/* The width in bits of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_GOUTNAKEFFMSK_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Early Suspend Mask - erlysuspmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description               
 * :-----------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_MSK   | 0x0   | Early Suspend Mask        
 *  ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_NOMSK | 0x1   | No mask Early Suspend Mask
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK
 * 
 * Early Suspend Mask
 */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK
 * 
 * No mask Early Suspend Mask
 */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_MSB        10
/* The width in bits of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_ERLYSUSPMSK_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : USB Suspend Mask - usbsuspmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_MSK   | 0x0   | USB Suspend Mask    
 *  ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_NOMSK | 0x1   | No mask  USB Suspend
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBSUSPMSK
 * 
 * USB Suspend Mask
 */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBSUSPMSK
 * 
 * No mask  USB Suspend
 */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_MSB        11
/* The width in bits of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_USBSUSPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GINTMSK_USBSUSPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_USBSUSPMSK_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : USB Reset Mask - usbrstmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description      
 * :---------------------------------------|:------|:------------------
 *  ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_MSK   | 0x0   | USB Reset Mask   
 *  ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_NOMSK | 0x1   | No mask USB Reset
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBRSTMSK
 * 
 * USB Reset Mask
 */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_USBRSTMSK
 * 
 * No mask USB Reset
 */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_MSB        12
/* The width in bits of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_GLOB_GINTMSK_USBRSTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_USBRSTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_GLOB_GINTMSK_USBRSTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_USBRSTMSK_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Enumeration Done Mask - enumdonemsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description             
 * :-----------------------------------------|:------|:-------------------------
 *  ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_MSK   | 0x0   | Enumeration Done Mask   
 *  ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_NOMSK | 0x1   | No mask Enumeration Done
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ENUMDONEMSK
 * 
 * Enumeration Done Mask
 */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ENUMDONEMSK
 * 
 * No mask Enumeration Done
 */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_MSB        13
/* The width in bits of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_ENUMDONEMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_GLOB_GINTMSK_ENUMDONEMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_ENUMDONEMSK_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : Isochronous OUT Packet Dropped Interrupt Mask - isooutdropmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                     
 * :-------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_MSK   | 0x0   | Isochronous OUT Packet Dropped Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_NOMSK | 0x1   | No mask Isochronous OUT Packet Dropped Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK
 * 
 * Isochronous OUT Packet Dropped Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK
 * 
 * No mask Isochronous OUT Packet Dropped Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_MSB        14
/* The width in bits of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_SET_MSK    0x00004000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_CLR_MSK    0xffffbfff
/* The reset value of the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_ISOOUTDROPMSK_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : End of Periodic Frame Interrupt Mask - eopfmsk
 * 
 * Mode: Device only. End of Periodic Frame Interrupt Mask (EOPFMsk)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                            
 * :-------------------------------------|:------|:----------------------------------------
 *  ALT_USB_GLOB_GINTMSK_EOPFMSK_E_MSK   | 0x0   | End of Periodic Frame Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_EOPFMSK_E_NOMSK | 0x1   | No mask End of Periodic Frame Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EOPFMSK
 * 
 * End of Periodic Frame Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EOPFMSK
 * 
 * No mask End of Periodic Frame Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_MSB        15
/* The width in bits of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_EOPFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_EOPFMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_GLOB_GINTMSK_EOPFMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_EOPFMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_GLOB_GINTMSK_EOPFMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_EOPFMSK_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : Endpoint Mismatch Interrupt Mask - epmismsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                        
 * :--------------------------------------|:------|:------------------------------------
 *  ALT_USB_GLOB_GINTMSK_EPMISMSK_E_MSK   | 0x0   | Endpoint Mismatch Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_EPMISMSK_E_NOMSK | 0x1   | No mask Endpoint Mismatch Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EPMISMSK
 * 
 * Endpoint Mismatch Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_EPMISMSK
 * 
 * No mask Endpoint Mismatch Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_MSB        17
/* The width in bits of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_EPMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_EPMISMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_EPMISMSK register field. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_EPMISMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_GLOB_GINTMSK_EPMISMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_EPMISMSK_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : IN Endpoints Interrupt Mask - iepintmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                   
 * :----------------------------------------|:------|:-------------------------------
 *  ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_MSK    | 0x0   | IN Endpoints Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_NOMAKS | 0x1   | No mask IN Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_IEPINTMSK
 * 
 * IN Endpoints Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_IEPINTMSK
 * 
 * No mask IN Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_E_NOMAKS 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_MSB        18
/* The width in bits of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_IEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_IEPINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GINTMSK_IEPINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_IEPINTMSK_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : OUT Endpoints Interrupt Mask - oepintmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                    
 * :---------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_MSK   | 0x0   | OUT Endpoints Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_NOMSK | 0x1   | No mask OUT Endpoints Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OEPINTMSK
 * 
 * OUT Endpoints Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_OEPINTMSK
 * 
 * No mask OUT Endpoints Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_MSB        19
/* The width in bits of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_OEPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_OEPINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GINTMSK_OEPINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_OEPINTMSK_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : Incomplete Isochronous IN Transfer Mask - incompisoinmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                               
 * :--------------------------------------------|:------|:-------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_MSK   | 0x0   | Incomplete Isochronous IN Transfer Mask   
 *  ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_NOMSK | 0x1   | No mask Incomplete Isochronous IN Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK
 * 
 * Incomplete Isochronous IN Transfer Mask
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK
 * 
 * No mask Incomplete Isochronous IN Transfer
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_MSB        20
/* The width in bits of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPISOINMSK_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : Incomplete Periodic Transfer Mask - incomplpmsk
 * 
 * Mode: Host only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                         
 * :-----------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_MSK   | 0x0   | Incomplete Periodic Transfer Mask   
 *  ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_NOMSK | 0x1   | No mask Incomplete Periodic Transfer
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPLPMSK
 * 
 * Incomplete Periodic Transfer Mask
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_INCOMPLPMSK
 * 
 * No mask Incomplete Periodic Transfer
 */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_MSB        21
/* The width in bits of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_INCOMPLPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GINTMSK_INCOMPLPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_INCOMPLPMSK_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : Data Fetch Suspended Mask - fetsuspmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_MSK   | 0x0   | Data Fetch Suspended Mask   
 *  ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_NOMSK | 0x1   | No mask Data Fetch Suspended
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_FETSUSPMSK
 * 
 * Data Fetch Suspended Mask
 */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_FETSUSPMSK
 * 
 * No mask Data Fetch Suspended
 */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_MSB        22
/* The width in bits of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_FETSUSPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GINTMSK_FETSUSPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_FETSUSPMSK_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : Reset detected Interrupt Mask - resetdetmsk
 * 
 * Mode: Device only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                     
 * :---------------------------------------|:------|:---------------------------------
 *  ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_MSK   | 0x0   | Reset detected Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_NOMSK | 0x1   | No mask Reset detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RSTDETMSK
 * 
 * Reset detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_RSTDETMSK
 * 
 * No mask Reset detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_MSB        23
/* The width in bits of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_RSTDETMSK register field. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_RSTDETMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GINTMSK_RSTDETMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_RSTDETMSK_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : Host Port Interrupt Mask - prtintmsk
 * 
 * Mode: Host only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                
 * :---------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_MSK   | 0x0   | Host Port Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_NOMSK | 0x1   | No mask Host Port Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PRTINTMSK
 * 
 * Host Port Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PRTINTMSK
 * 
 * No mask Host Port Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_MSB        24
/* The width in bits of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_PRTINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_PRTINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GINTMSK_PRTINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_PRTINTMSK_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Host Channels Interrupt Mask - hchintmsk
 * 
 * Mode: Host only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                    
 * :---------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_MSK   | 0x0   | Host Channels Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_NOMSK | 0x1   | No mask Host Channels Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_HCHINTMSK
 * 
 * Host Channels Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_HCHINTMSK
 * 
 * No mask Host Channels Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_MSB        25
/* The width in bits of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_HCHINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_HCHINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GINTMSK_HCHINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_HCHINTMSK_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Periodic TxFIFO Empty Mask - ptxfempmsk
 * 
 * Mode: Host only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                  
 * :----------------------------------------|:------|:------------------------------
 *  ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_MSK   | 0x0   | Periodic TxFIFO Empty Mask   
 *  ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_NOMSK | 0x1   | No mask Periodic TxFIFO Empty
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PTXFEMPMSK
 * 
 * Periodic TxFIFO Empty Mask
 */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_PTXFEMPMSK
 * 
 * No mask Periodic TxFIFO Empty
 */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_MSB        26
/* The width in bits of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_PTXFEMPMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_GLOB_GINTMSK_PTXFEMPMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_PTXFEMPMSK_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Connector ID Status Change Mask - conidstschngmsk
 * 
 * Mode: Host and Device. This bit can be set only by the core and the application
 * should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                       
 * :---------------------------------------------|:------|:-----------------------------------
 *  ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_MSK   | 0x0   | Connector ID Status Change Mask   
 *  ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_NOMSK | 0x1   | No mask Connector ID Status Change
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK
 * 
 * Connector ID Status Change Mask
 */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK
 * 
 * No mask Connector ID Status Change
 */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_LSB        28
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_MSB        28
/* The width in bits of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_SET_MSK    0x10000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_CLR_MSK    0xefffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_GET(value) (((value) & 0x10000000) >> 28)
/* Produces a ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_CONIDSTSCHNGMSK_SET(value) (((value) << 28) & 0x10000000)

/*
 * Field : disconnintmsk
 * 
 * Mode: Host and Device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                          
 * :-------------------------------------------|:------|:--------------------------------------
 *  ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_MSK   | 0x0   | Disconnect Detected Interrupt Mask   
 *  ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_NOMSK | 0x1   | No mask Disconnect Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_DISCONNINTMSK
 * 
 * Disconnect Detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_DISCONNINTMSK
 * 
 * No mask Disconnect Detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_MSB        29
/* The width in bits of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_SET_MSK    0x20000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_CLR_MSK    0xdfffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_DISCONNINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_GET(value) (((value) & 0x20000000) >> 29)
/* Produces a ALT_USB_GLOB_GINTMSK_DISCONNINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_DISCONNINTMSK_SET(value) (((value) << 29) & 0x20000000)

/*
 * Field : Session Request New Session Detected Interrupt Mas - sessreqintmsk
 * 
 * Mode: Host and Device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                   
 * :-------------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_MSK   | 0x0   | Session Request New Session Detected Interrupt
 * :                                           |       | Mask                                          
 *  ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_NOMSK | 0x1   | No mask Session RequestNew Session Detected   
 * :                                           |       | Interrupt                                     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SESSREQINTMSK
 * 
 * Session Request New Session Detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_SESSREQINTMSK
 * 
 * No mask Session RequestNew Session Detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_MSB        30
/* The width in bits of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_SESSREQINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GINTMSK_SESSREQINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_SESSREQINTMSK_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Resume Remote Wakeup Detected Interrupt Mask - wkupintmsk
 * 
 * Mode: Host and Device.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                   
 * :----------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_MSK   | 0x0   | Resume Remote Wakeup Detected Interrupt Mask  
 *  ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_NOMSK | 0x1   | No maskResume Remote Wakeup Detected Interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_WKUPINTMSK
 * 
 * Resume Remote Wakeup Detected Interrupt Mask
 */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GINTMSK_WKUPINTMSK
 * 
 * No maskResume Remote Wakeup Detected Interrupt
 */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_MSB        31
/* The width in bits of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field value. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_RESET      0x0
/* Extracts the ALT_USB_GLOB_GINTMSK_WKUPINTMSK field value from a register. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GINTMSK_WKUPINTMSK register field value suitable for setting the register. */
#define ALT_USB_GLOB_GINTMSK_WKUPINTMSK_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GINTMSK.
 */
struct ALT_USB_GLOB_GINTMSK_s
{
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  modemismsk      :  1;  /* Mode Mismatch Interrupt Mask */
    uint32_t  otgintmsk       :  1;  /* OTG Interrupt Mask */
    uint32_t  sofmsk          :  1;  /* Start of (micro)Frame Mask */
    uint32_t  rxflvlmsk       :  1;  /* Receive FIFO Non-Empty Mask */
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  ginnakeffmsk    :  1;  /* Global Non-periodic IN NAK Effective Mask */
    uint32_t  goutnakeffmsk   :  1;  /* Global OUT NAK Effective Mask */
    uint32_t                  :  2;  /* *UNDEFINED* */
    uint32_t  erlysuspmsk     :  1;  /* Early Suspend Mask */
    uint32_t  usbsuspmsk      :  1;  /* USB Suspend Mask */
    uint32_t  usbrstmsk       :  1;  /* USB Reset Mask */
    uint32_t  enumdonemsk     :  1;  /* Enumeration Done Mask */
    uint32_t  isooutdropmsk   :  1;  /* Isochronous OUT Packet Dropped Interrupt Mask */
    uint32_t  eopfmsk         :  1;  /* End of Periodic Frame Interrupt Mask */
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  epmismsk        :  1;  /* Endpoint Mismatch Interrupt Mask */
    uint32_t  iepintmsk       :  1;  /* IN Endpoints Interrupt Mask */
    uint32_t  oepintmsk       :  1;  /* OUT Endpoints Interrupt Mask */
    uint32_t  incompisoinmsk  :  1;  /* Incomplete Isochronous IN Transfer Mask */
    uint32_t  incomplpmsk     :  1;  /* Incomplete Periodic Transfer Mask */
    uint32_t  fetsuspmsk      :  1;  /* Data Fetch Suspended Mask */
    uint32_t  resetdetmsk     :  1;  /* Reset detected Interrupt Mask */
    uint32_t  prtintmsk       :  1;  /* Host Port Interrupt Mask */
    uint32_t  hchintmsk       :  1;  /* Host Channels Interrupt Mask */
    uint32_t  ptxfempmsk      :  1;  /* Periodic TxFIFO Empty Mask */
    uint32_t                  :  1;  /* *UNDEFINED* */
    uint32_t  conidstschngmsk :  1;  /* Connector ID Status Change Mask */
    uint32_t  disconnintmsk   :  1;  /* ALT_USB_GLOB_GINTMSK_DISCONNINTMSK */
    uint32_t  sessreqintmsk   :  1;  /* Session Request New Session Detected Interrupt Mas */
    uint32_t  wkupintmsk      :  1;  /* Resume Remote Wakeup Detected Interrupt Mask */
};

/* The typedef declaration for register ALT_USB_GLOB_GINTMSK. */
typedef volatile struct ALT_USB_GLOB_GINTMSK_s  ALT_USB_GLOB_GINTMSK_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GINTMSK register from the beginning of the component. */
#define ALT_USB_GLOB_GINTMSK_OFST        0x18
/* The address of the ALT_USB_GLOB_GINTMSK register. */
#define ALT_USB_GLOB_GINTMSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GINTMSK_OFST))

/*
 * Register : Receive Status Debug Read Register - grxstsr
 * 
 * A read to the Receive Status Read and Pop register additionally pops the: top
 * data entry out of the RxFIFO. The receive status contents must be interpreted
 * differently in Host and Device modes. The core ignores the receive status
 * pop/read when the receive FIFO is empty and returns a value of 0. The
 * application must only pop the Receive Status FIFO when the Receive FIFO Non-
 * Empty bit of the Core Interrupt register (GINTSTS.RxFLvl) is asserted.  Use of
 * these fields vary based on whether the HS OTG core is functioning as a host or a
 * device. Do not read this register's reset value before configuring the core
 * because the read value is "X" in the simulation.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description   
 * :--------|:-------|:------|:---------------
 *  [3:0]   | R      | 0x0   | Channel Number
 *  [14:4]  | R      | 0x0   | Byte Count    
 *  [16:15] | R      | 0x0   | Data PID      
 *  [20:17] | R      | 0x0   | Packet Status 
 *  [31:21] | ???    | 0x0   | *UNDEFINED*   
 * 
 */
/*
 * Field : Channel Number - chnum
 * 
 * Indicates the endpoint number to which the current received packet belongs.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_MSB        3
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GRXSTSR_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_CHNUM field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GRXSTSR_CHNUM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_CHNUM_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : Byte Count - bcnt
 * 
 * Indicates the byte count of the received data packet.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_MSB        14
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_WIDTH      11
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_SET_MSK    0x00007ff0
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_CLR_MSK    0xffff800f
/* The reset value of the ALT_USB_GLOB_GRXSTSR_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_BCNT field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_GET(value) (((value) & 0x00007ff0) >> 4)
/* Produces a ALT_USB_GLOB_GRXSTSR_BCNT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_BCNT_SET(value) (((value) << 4) & 0x00007ff0)

/*
 * Field : Data PID - dpid
 * 
 * Indicates the Data PID of the received packet.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_DATA0 | 0x0   | DATA0      
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_DATA1 | 0x2   | DATA1      
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_DATA2 | 0x1   | DATA2      
 *  ALT_USB_GLOB_GRXSTSR_DPID_E_MDATA | 0x3   | MDATA      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * DATA0
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_DATA0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * DATA1
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_DATA1   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * DATA2
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_DATA2   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_DPID
 * 
 * MDATA
 */
#define ALT_USB_GLOB_GRXSTSR_DPID_E_MDATA   0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_MSB        16
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSR_DPID_SET_MSK    0x00018000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSR_DPID_CLR_MSK    0xfffe7fff
/* The reset value of the ALT_USB_GLOB_GRXSTSR_DPID register field. */
#define ALT_USB_GLOB_GRXSTSR_DPID_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_DPID field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_DPID_GET(value) (((value) & 0x00018000) >> 15)
/* Produces a ALT_USB_GLOB_GRXSTSR_DPID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_DPID_SET(value) (((value) << 15) & 0x00018000)

/*
 * Field : Packet Status - pktsts
 * 
 * Mode: Host only. Others: Reserved. Indicates the status of the received packet
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                 
 * :--------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INDPRX  | 0x2   | IN data packet received                     
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INTRCOM | 0x3   | IN transfer completed (triggers an interrupt
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_DTTOG   | 0x5   | Data toggle error (triggers an interrupt)   
 *  ALT_USB_GLOB_GRXSTSR_PKTSTS_E_CHHALT  | 0x7   | Channel halted (triggers an interrupt)      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * IN data packet received
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INDPRX    0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * IN transfer completed (triggers an interrupt
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_INTRCOM   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * Data toggle error (triggers an interrupt)
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_DTTOG     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSR_PKTSTS
 * 
 * Channel halted (triggers an interrupt)
 */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_E_CHHALT    0x7

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_MSB        20
/* The width in bits of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSR_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_SET_MSK    0x001e0000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSR_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_CLR_MSK    0xffe1ffff
/* The reset value of the ALT_USB_GLOB_GRXSTSR_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSR_PKTSTS field value from a register. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_GET(value) (((value) & 0x001e0000) >> 17)
/* Produces a ALT_USB_GLOB_GRXSTSR_PKTSTS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSR_PKTSTS_SET(value) (((value) << 17) & 0x001e0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRXSTSR.
 */
struct ALT_USB_GLOB_GRXSTSR_s
{
    const uint32_t  chnum  :  4;  /* Channel Number */
    const uint32_t  bcnt   : 11;  /* Byte Count */
    const uint32_t  dpid   :  2;  /* Data PID */
    const uint32_t  pktsts :  4;  /* Packet Status */
    uint32_t               : 11;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GRXSTSR. */
typedef volatile struct ALT_USB_GLOB_GRXSTSR_s  ALT_USB_GLOB_GRXSTSR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GRXSTSR register from the beginning of the component. */
#define ALT_USB_GLOB_GRXSTSR_OFST        0x1c
/* The address of the ALT_USB_GLOB_GRXSTSR register. */
#define ALT_USB_GLOB_GRXSTSR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRXSTSR_OFST))

/*
 * Register : Receive Status Read Pop Register - grxstsp
 * 
 * A read to the Receive Status Read and Pop register additionally pops the: top
 * data entry out of the RxFIFO. The receive status contents must be interpreted
 * differently in Host and Device modes. The core ignores the receive status
 * pop/read when the receive FIFO is empty and returns a value of 0. The
 * application must only pop the Receive Status FIFO when the Receive FIFO Non-
 * Empty bit of the Core Interrupt register (GINTSTS.RxFLvl) is asserted.  Use of
 * these fields vary based on whether the HS OTG core is functioning as a host or a
 * device. Do not read this register'ss reset value before configuring the core
 * because the read value is "X" in the simulation.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description   
 * :--------|:-------|:------|:---------------
 *  [3:0]   | R      | 0x0   | Channel Number
 *  [14:4]  | R      | 0x0   | Byte Count    
 *  [16:15] | R      | 0x0   | Data PID      
 *  [20:17] | R      | 0x0   | Packet Status 
 *  [24:21] | R      | 0x0   | Frame Number  
 *  [31:25] | ???    | 0x0   | *UNDEFINED*   
 * 
 */
/*
 * Field : Channel Number - chnum
 * 
 * Mode: Host only. Indicates the channel number to which the current received
 * packet belongs.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_MSB        3
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_CHNUM register field value. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GRXSTSP_CHNUM register field. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_CHNUM field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GRXSTSP_CHNUM register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_CHNUM_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : Byte Count - bcnt
 * 
 * Mode: Host only. Indicates the byte count of the received IN data packet.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_MSB        14
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_WIDTH      11
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_SET_MSK    0x00007ff0
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_BCNT register field value. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_CLR_MSK    0xffff800f
/* The reset value of the ALT_USB_GLOB_GRXSTSP_BCNT register field. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_BCNT field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_GET(value) (((value) & 0x00007ff0) >> 4)
/* Produces a ALT_USB_GLOB_GRXSTSP_BCNT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_BCNT_SET(value) (((value) << 4) & 0x00007ff0)

/*
 * Field : Data PID - dpid
 * 
 * Indicates the Data PID of the received OUT data packet.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description
 * :----------------------------------|:------|:------------
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_DATA0 | 0x0   | DATA0      
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_DATA1 | 0x2   | DATA1      
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_DATA2 | 0x1   | DATA2      
 *  ALT_USB_GLOB_GRXSTSP_DPID_E_MDATA | 0x3   | MDATA      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * DATA0
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_DATA0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * DATA1
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_DATA1   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * DATA2
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_DATA2   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_DPID
 * 
 * MDATA
 */
#define ALT_USB_GLOB_GRXSTSP_DPID_E_MDATA   0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_MSB        16
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSP_DPID_SET_MSK    0x00018000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_DPID register field value. */
#define ALT_USB_GLOB_GRXSTSP_DPID_CLR_MSK    0xfffe7fff
/* The reset value of the ALT_USB_GLOB_GRXSTSP_DPID register field. */
#define ALT_USB_GLOB_GRXSTSP_DPID_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_DPID field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_DPID_GET(value) (((value) & 0x00018000) >> 15)
/* Produces a ALT_USB_GLOB_GRXSTSP_DPID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_DPID_SET(value) (((value) << 15) & 0x00018000)

/*
 * Field : Packet Status - pktsts
 * 
 * Mode: Host only. Others: Reserved. Indicates the status of the received packet
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA0 | 0x0   | DATA0      
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA1 | 0x2   | DATA1      
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA2 | 0x1   | DATA2      
 *  ALT_USB_GLOB_GRXSTSP_PKTSTS_E_MDATA | 0x3   | MDATA      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * DATA0
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA0 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * DATA1
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA1 0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * DATA2
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_DATA2 0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GRXSTSP_PKTSTS
 * 
 * MDATA
 */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_E_MDATA 0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_MSB        20
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_SET_MSK    0x001e0000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_PKTSTS register field value. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_CLR_MSK    0xffe1ffff
/* The reset value of the ALT_USB_GLOB_GRXSTSP_PKTSTS register field. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_PKTSTS field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_GET(value) (((value) & 0x001e0000) >> 17)
/* Produces a ALT_USB_GLOB_GRXSTSP_PKTSTS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_PKTSTS_SET(value) (((value) << 17) & 0x001e0000)

/*
 * Field : Frame Number - fn
 * 
 * Mode: Device only. This is the least significant 4 bits of the (micro)Frame
 * number in which the packet is received on the USB. This field is supported only
 * when isochronous OUT endpoints are supported.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_MSB        24
/* The width in bits of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GRXSTSP_FN register field value. */
#define ALT_USB_GLOB_GRXSTSP_FN_SET_MSK    0x01e00000
/* The mask used to clear the ALT_USB_GLOB_GRXSTSP_FN register field value. */
#define ALT_USB_GLOB_GRXSTSP_FN_CLR_MSK    0xfe1fffff
/* The reset value of the ALT_USB_GLOB_GRXSTSP_FN register field. */
#define ALT_USB_GLOB_GRXSTSP_FN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GRXSTSP_FN field value from a register. */
#define ALT_USB_GLOB_GRXSTSP_FN_GET(value) (((value) & 0x01e00000) >> 21)
/* Produces a ALT_USB_GLOB_GRXSTSP_FN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXSTSP_FN_SET(value) (((value) << 21) & 0x01e00000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRXSTSP.
 */
struct ALT_USB_GLOB_GRXSTSP_s
{
    const uint32_t  chnum  :  4;  /* Channel Number */
    const uint32_t  bcnt   : 11;  /* Byte Count */
    const uint32_t  dpid   :  2;  /* Data PID */
    const uint32_t  pktsts :  4;  /* Packet Status */
    const uint32_t  fn     :  4;  /* Frame Number */
    uint32_t               :  7;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GRXSTSP. */
typedef volatile struct ALT_USB_GLOB_GRXSTSP_s  ALT_USB_GLOB_GRXSTSP_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GRXSTSP register from the beginning of the component. */
#define ALT_USB_GLOB_GRXSTSP_OFST        0x20
/* The address of the ALT_USB_GLOB_GRXSTSP register. */
#define ALT_USB_GLOB_GRXSTSP_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRXSTSP_OFST))

/*
 * Register : Receive FIFO Size Register - grxfsiz
 * 
 * The application can program the RAM size that must be allocated to the RxFIFO.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description 
 * :--------|:-------|:-------|:-------------
 *  [13:0]  | RW     | 0x2000 | RxFIFO Depth
 *  [31:14] | ???    | 0x0    | *UNDEFINED* 
 * 
 */
/*
 * Field : RxFIFO Depth - rxfdep
 * 
 * This value is in terms of 32-bit words.  Minimum value is 16  Maximum value is
 * 32,768 The power-on reset value of this register is specified as the Largest Rx
 * Data FIFO Dept 8192. Using the Dynamic FIFO Sizing, you can write a new value in
 * this field. Programmed values must not exceed 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_MSB        13
/* The width in bits of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field value. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_SET_MSK    0x00003fff
/* The mask used to clear the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field value. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_CLR_MSK    0xffffc000
/* The reset value of the ALT_USB_GLOB_GRXFSIZ_RXFDEP register field. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GRXFSIZ_RXFDEP field value from a register. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_GET(value) (((value) & 0x00003fff) >> 0)
/* Produces a ALT_USB_GLOB_GRXFSIZ_RXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GRXFSIZ_RXFDEP_SET(value) (((value) << 0) & 0x00003fff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GRXFSIZ.
 */
struct ALT_USB_GLOB_GRXFSIZ_s
{
    uint32_t  rxfdep : 14;  /* RxFIFO Depth */
    uint32_t         : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GRXFSIZ. */
typedef volatile struct ALT_USB_GLOB_GRXFSIZ_s  ALT_USB_GLOB_GRXFSIZ_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GRXFSIZ register from the beginning of the component. */
#define ALT_USB_GLOB_GRXFSIZ_OFST        0x24
/* The address of the ALT_USB_GLOB_GRXFSIZ register. */
#define ALT_USB_GLOB_GRXFSIZ_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GRXFSIZ_OFST))

/*
 * Register : Non-periodic Transmit FIFO Size Register - gnptxfsiz
 * 
 * The application can program the RAM size and the memory start address for the
 * Non-periodic TxFIFO. The fields of this register change, depending on host or
 * device mode.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                            
 * :--------|:-------|:-------|:----------------------------------------
 *  [13:0]  | RW     | 0x2000 | Non-periodic Transmit RAM Start Address
 *  [15:14] | ???    | 0x0    | *UNDEFINED*                            
 *  [29:16] | RW     | 0x2000 | Non-periodic TxFIFO Depth              
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                            
 * 
 */
/*
 * Field : Non-periodic Transmit RAM Start Address - nptxfstaddr
 * 
 * Mode: Host only. for host mode, this field is always valid.This field contains
 * the memory start address for Non-periodic Transmit FIFO RAM. This field is set
 * from 16-8192 32 bit words. The application can write a new value in this field.
 * Programmed values must not exceed 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_MSB        13
/* The width in bits of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_SET_MSK    0x00003fff
/* The mask used to clear the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_CLR_MSK    0xffffc000
/* The reset value of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_GET(value) (((value) & 0x00003fff) >> 0)
/* Produces a ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFSTADDR_SET(value) (((value) << 0) & 0x00003fff)

/*
 * Field : Non-periodic TxFIFO Depth - nptxfdep
 * 
 * Mode: Host only. for host mode, this field is always valid. The application can
 * write a new value in this field. Programmed values must not exceed 8192
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field value. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP field value from a register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXFSIZ_NPTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GNPTXFSIZ.
 */
struct ALT_USB_GLOB_GNPTXFSIZ_s
{
    uint32_t  nptxfstaddr : 14;  /* Non-periodic Transmit RAM Start Address */
    uint32_t              :  2;  /* *UNDEFINED* */
    uint32_t  nptxfdep    : 14;  /* Non-periodic TxFIFO Depth */
    uint32_t              :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GNPTXFSIZ. */
typedef volatile struct ALT_USB_GLOB_GNPTXFSIZ_s  ALT_USB_GLOB_GNPTXFSIZ_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GNPTXFSIZ register from the beginning of the component. */
#define ALT_USB_GLOB_GNPTXFSIZ_OFST        0x28
/* The address of the ALT_USB_GLOB_GNPTXFSIZ register. */
#define ALT_USB_GLOB_GNPTXFSIZ_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GNPTXFSIZ_OFST))

/*
 * Register : Non-periodic Transmit FIFO Queue Status Register - gnptxsts
 * 
 * In Device mode, this register is valid only in Shared FIFO operation. It
 * contains the free space information for the Non-periodic TxFIFO and the
 * Nonperiodic Transmit RequestQueue
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                        
 * :--------|:-------|:------|:----------------------------------------------------
 *  [15:0]  | R      | 0x400 | Non-periodic TxFIFO Space Avail                    
 *  [23:16] | R      | 0x8   | Non-periodic Transmit Request Queue Space Available
 *  [30:24] | R      | 0x0   | Top of the Non-periodic Transmit Request Queue     
 *  [31]    | ???    | 0x0   | *UNDEFINED*                                        
 * 
 */
/*
 * Field : Non-periodic TxFIFO Space Avail - nptxfspcavail
 * 
 * Indicates the amount of free space available in the Non-periodic TxFIFO.Values
 * are in terms of 32-bit words. 16h0: Non-periodic TxFIFO is full 16h1: 1 word
 * available 16h2: 2 words available 16hn: n words available (where 0  n  32,768)
 * 16h8000: 32,768 words available Others: Reserved
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_MSB        15
/* The width in bits of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_RESET      0x400
/* Extracts the ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL field value from a register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXFSPCAVAIL_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Non-periodic Transmit Request Queue Space Available - nptxqspcavail
 * 
 * Indicates the amount of free space available in the Non-periodic Transmit
 * Request Queue. This queue holds both IN and OUT requests in Host mode. Device
 * mode has only IN requests. -Others: Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                
 * :-------------------------------------------|:------|:--------------------------------------------
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_FULL | 0x0   | Non-periodic Transmit Request Queue is full
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE1 | 0x1   | 1 location available                       
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE2 | 0x2   | 2 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE3 | 0x3   | 3 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE4 | 0x4   | 4 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE5 | 0x5   | 5 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE6 | 0x6   | 6 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE7 | 0x7   | 7 locations available                      
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE8 | 0x8   | 8 locations available                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * Non-periodic Transmit Request Queue is full
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_FULL  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 1 location available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE1  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 2 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE2  0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 3 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE3  0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 4 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE4  0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 5 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE5  0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 6 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE6  0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 7 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE7  0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL
 * 
 * 8 locations available
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_E_QUE8  0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_MSB        23
/* The width in bits of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_WIDTH      8
/* The mask used to set the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_CLR_MSK    0xff00ffff
/* The reset value of the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_RESET      0x8
/* Extracts the ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL field value from a register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQSPCAVAIL_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Top of the Non-periodic Transmit Request Queue - nptxqtop
 * 
 * Entry in the Non-periodic Tx Request Queue that is currently being processed by
 * the MAC.
 * 
 * * Bits [30:27]: Channel/endpoint number
 * 
 * * Bits [26:25]:
 * 
 * * Bit [24]: Terminate (last Entry for selected channel endpoint)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                                     
 * :--------------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_INOUTTK    | 0x0   | IN/OUT token                                    
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_ZEROTX     | 0x1   | Zero-length transmit packet (device IN/host OUT)
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_PINGCSPLIT | 0x2   | PING/CSPLIT token                               
 *  ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_CHNHALT    | 0x3   | Channel halt command                            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * IN/OUT token
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_INOUTTK    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * Zero-length transmit packet (device IN/host OUT)
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_ZEROTX     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * PING/CSPLIT token
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_PINGCSPLIT 0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GNPTXSTS_NPTXQTOP
 * 
 * Channel halt command
 */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_E_CHNHALT    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_MSB        30
/* The width in bits of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_WIDTH      7
/* The mask used to set the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_SET_MSK    0x7f000000
/* The mask used to clear the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field value. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_CLR_MSK    0x80ffffff
/* The reset value of the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_RESET      0x0
/* Extracts the ALT_USB_GLOB_GNPTXSTS_NPTXQTOP field value from a register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_GET(value) (((value) & 0x7f000000) >> 24)
/* Produces a ALT_USB_GLOB_GNPTXSTS_NPTXQTOP register field value suitable for setting the register. */
#define ALT_USB_GLOB_GNPTXSTS_NPTXQTOP_SET(value) (((value) << 24) & 0x7f000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GNPTXSTS.
 */
struct ALT_USB_GLOB_GNPTXSTS_s
{
    const uint32_t  nptxfspcavail : 16;  /* Non-periodic TxFIFO Space Avail */
    const uint32_t  nptxqspcavail :  8;  /* Non-periodic Transmit Request Queue Space Available */
    const uint32_t  nptxqtop      :  7;  /* Top of the Non-periodic Transmit Request Queue */
    uint32_t                      :  1;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GNPTXSTS. */
typedef volatile struct ALT_USB_GLOB_GNPTXSTS_s  ALT_USB_GLOB_GNPTXSTS_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GNPTXSTS register from the beginning of the component. */
#define ALT_USB_GLOB_GNPTXSTS_OFST        0x2c
/* The address of the ALT_USB_GLOB_GNPTXSTS register. */
#define ALT_USB_GLOB_GNPTXSTS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GNPTXSTS_OFST))

/*
 * Register : PHY Vendor Control Register - gpvndctl
 * 
 * The application can use this register to access PHY registers. for a ULPI PHY,
 * the core uses the ULPI interface for PHY register access. The application sets
 * Vendor Control register for PHY register access and times the PHY register
 * access. The application polls the VStatus Done bit in this register for the
 * completion of the PHY register access
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                          
 * :--------|:-------|:------|:--------------------------------------
 *  [7:0]   | RW     | 0x0   | Register Data                        
 *  [15:8]  | RW     | 0x0   | UTMI+ Vendor Control Register Address
 *  [21:16] | RW     | 0x0   | Register Address                     
 *  [22]    | RW     | 0x0   | Register Write                       
 *  [24:23] | ???    | 0x0   | *UNDEFINED*                          
 *  [25]    | R      | 0x0   | New Register Request                 
 *  [26]    | R      | 0x0   | VStatus Busy                         
 *  [27]    | R      | 0x0   | VStatus Done                         
 *  [30:28] | ???    | 0x0   | *UNDEFINED*                          
 *  [31]    | R      | 0x0   | Disable ULPI Drivers                 
 * 
 */
/*
 * Field : Register Data - regdata
 * 
 * Contains the write data for register write. Read data for register read, valid
 * when VStatus Done is Set.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_MSB        7
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_WIDTH      8
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_REGDATA register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_SET_MSK    0x000000ff
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_REGDATA register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_CLR_MSK    0xffffff00
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_REGDATA register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_REGDATA field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_GET(value) (((value) & 0x000000ff) >> 0)
/* Produces a ALT_USB_GLOB_GPVNDCTL_REGDATA register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_REGDATA_SET(value) (((value) << 0) & 0x000000ff)

/*
 * Field : UTMI+ Vendor Control Register Address - vctrl
 * 
 * The 4-bit register address a vendor defined 4-bit parallel output bus. ULPI
 * Extended Register Address and the 6-bit PHY extended register address.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_MSB        15
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_WIDTH      8
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_VCTL register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_VCTL register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_CLR_MSK    0xffff00ff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_VCTL register field. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_VCTL field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_USB_GLOB_GPVNDCTL_VCTL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_VCTL_SET(value) (((value) << 8) & 0x0000ff00)

/*
 * Field : Register Address - regaddr
 * 
 * The 6-bit PHY register address for immediate PHY Register Set access. Set to
 * 0x2F for Extended PHY Register Set access.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_MSB        21
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_WIDTH      6
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_REGADDR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_SET_MSK    0x003f0000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_REGADDR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_CLR_MSK    0xffc0ffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_REGADDR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_REGADDR field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_GET(value) (((value) & 0x003f0000) >> 16)
/* Produces a ALT_USB_GLOB_GPVNDCTL_REGADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_REGADDR_SET(value) (((value) << 16) & 0x003f0000)

/*
 * Field : Register Write - regwr
 * 
 * Set this bit for register writes, and clear it for register reads.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description   
 * :---------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GPVNDCTL_REGWR_E_RD | 0x0   | Register Write
 *  ALT_USB_GLOB_GPVNDCTL_REGWR_E_WR | 0x1   | Register Write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_REGWR
 * 
 * Register Write
 */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_E_RD    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_REGWR
 * 
 * Register Write
 */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_E_WR    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_MSB        22
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_REGWR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_REGWR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_REGWR register field. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_REGWR field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GPVNDCTL_REGWR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_REGWR_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : New Register Request - newregreq
 * 
 * The application sets this bit for a new vendor controlaccess.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                    
 * :----------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_INACT | 0x0   | New Register Request not active
 *  ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_ACT   | 0x1   | New Register Request active    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_NEWREGREQ
 * 
 * New Register Request not active
 */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_NEWREGREQ
 * 
 * New Register Request active
 */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_MSB        25
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field value. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field value. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_NEWREGREQ field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GPVNDCTL_NEWREGREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_NEWREGREQ_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : VStatus Busy - vstsbsy
 * 
 * The core sets this bit when the vendor control access is in progress and clears
 * this bit when done.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description          
 * :--------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_INACT | 0x0   | VStatus Busy inactive
 *  ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_ACT   | 0x1   | VStatus Busy active  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSBSY
 * 
 * VStatus Busy inactive
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSBSY
 * 
 * VStatus Busy active
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_MSB        26
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_VSTSBSY field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_GLOB_GPVNDCTL_VSTSBSY register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSBSY_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : VStatus Done - vstsdone
 * 
 * The core sets this bit when the vendor control access isdone. This bit is
 * cleared by the core when the application sets the New Register Request bit (bit
 * 25).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description          
 * :---------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_INACT | 0x0   | VStatus Done inactive
 *  ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_ACT   | 0x1   | VStatus Done active  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSDONE
 * 
 * VStatus Done inactive
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_VSTSDONE
 * 
 * VStatus Done active
 */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_MSB        27
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_SET_MSK    0x08000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field value. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_CLR_MSK    0xf7ffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_VSTSDONE field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_GET(value) (((value) & 0x08000000) >> 27)
/* Produces a ALT_USB_GLOB_GPVNDCTL_VSTSDONE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_VSTSDONE_SET(value) (((value) << 27) & 0x08000000)

/*
 * Field : Disable ULPI Drivers - disulpidrvr
 * 
 * The application sets this bit when it has finished processing the ULPI Carkit
 * Interrupt (GINTSTS.ULPICKINT). When Set, the otg core disables drivers for
 * output signals and masks input signal for the ULPI interface. otg clears this
 * bit before enabling the ULPI interface.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description               
 * :-----------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_END  | 0x0   | ULPI ouput signals        
 *  ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_DISD | 0x1   | Disable ULPI ouput signals
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR
 * 
 * ULPI ouput signals
 */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_END     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR
 * 
 * Disable ULPI ouput signals
 */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_E_DISD    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_MSB        31
/* The width in bits of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field value. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR field value from a register. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GPVNDCTL_DISULPIDRVR_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GPVNDCTL.
 */
struct ALT_USB_GLOB_GPVNDCTL_s
{
    uint32_t        regdata     :  8;  /* Register Data */
    uint32_t        vctrl       :  8;  /* UTMI+ Vendor Control Register Address */
    uint32_t        regaddr     :  6;  /* Register Address */
    uint32_t        regwr       :  1;  /* Register Write */
    uint32_t                    :  2;  /* *UNDEFINED* */
    const uint32_t  newregreq   :  1;  /* New Register Request */
    const uint32_t  vstsbsy     :  1;  /* VStatus Busy */
    const uint32_t  vstsdone    :  1;  /* VStatus Done */
    uint32_t                    :  3;  /* *UNDEFINED* */
    const uint32_t  disulpidrvr :  1;  /* Disable ULPI Drivers */
};

/* The typedef declaration for register ALT_USB_GLOB_GPVNDCTL. */
typedef volatile struct ALT_USB_GLOB_GPVNDCTL_s  ALT_USB_GLOB_GPVNDCTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GPVNDCTL register from the beginning of the component. */
#define ALT_USB_GLOB_GPVNDCTL_OFST        0x34
/* The address of the ALT_USB_GLOB_GPVNDCTL register. */
#define ALT_USB_GLOB_GPVNDCTL_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GPVNDCTL_OFST))

/*
 * Register : General Purpose Input Output Register - ggpio
 * 
 * The application can use this register for general purpose input/output ports or
 * for debugging.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description           
 * :--------|:-------|:------|:-----------------------
 *  [15:0]  | R      | 0x0   | General Purpose Input 
 *  [31:16] | RW     | 0x0   | General Purpose Output
 * 
 */
/*
 * Field : General Purpose Input - gpi
 * 
 * This field's read value reflects the gp_i[15:0] core input value.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_MSB        15
/* The width in bits of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GGPIO_GPI register field value. */
#define ALT_USB_GLOB_GGPIO_GPI_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_GGPIO_GPI register field value. */
#define ALT_USB_GLOB_GGPIO_GPI_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_GGPIO_GPI register field. */
#define ALT_USB_GLOB_GGPIO_GPI_RESET      0x0
/* Extracts the ALT_USB_GLOB_GGPIO_GPI field value from a register. */
#define ALT_USB_GLOB_GGPIO_GPI_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_GGPIO_GPI register field value suitable for setting the register. */
#define ALT_USB_GLOB_GGPIO_GPI_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : General Purpose Output - gpo
 * 
 * This field is driven as an output from the core, gp_o[15:0]. The application can
 * program this field to determine the corresponding value on the gp_o[15:0]
 * output.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_MSB        31
/* The width in bits of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GGPIO_GPO register field value. */
#define ALT_USB_GLOB_GGPIO_GPO_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_GLOB_GGPIO_GPO register field value. */
#define ALT_USB_GLOB_GGPIO_GPO_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_GLOB_GGPIO_GPO register field. */
#define ALT_USB_GLOB_GGPIO_GPO_RESET      0x0
/* Extracts the ALT_USB_GLOB_GGPIO_GPO field value from a register. */
#define ALT_USB_GLOB_GGPIO_GPO_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_GLOB_GGPIO_GPO register field value suitable for setting the register. */
#define ALT_USB_GLOB_GGPIO_GPO_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GGPIO.
 */
struct ALT_USB_GLOB_GGPIO_s
{
    const uint32_t  gpi : 16;  /* General Purpose Input */
    uint32_t        gpo : 16;  /* General Purpose Output */
};

/* The typedef declaration for register ALT_USB_GLOB_GGPIO. */
typedef volatile struct ALT_USB_GLOB_GGPIO_s  ALT_USB_GLOB_GGPIO_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GGPIO register from the beginning of the component. */
#define ALT_USB_GLOB_GGPIO_OFST        0x38
/* The address of the ALT_USB_GLOB_GGPIO register. */
#define ALT_USB_GLOB_GGPIO_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GGPIO_OFST))

/*
 * Register : User ID Register - guid
 * 
 * This is a read/write register containing the User ID. This register can be used
 * in the following ways:
 * 
 * * To store the version or revision of your system
 * 
 * * To store hardware configurations that are outside the otg core
 * 
 * As a scratch register
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description
 * :-------|:-------|:-----------|:------------
 *  [31:0] | RW     | 0x12345678 | User ID    
 * 
 */
/*
 * Field : User ID - guid
 * 
 * Application-programmable ID field.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_MSB        31
/* The width in bits of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_WIDTH      32
/* The mask used to set the ALT_USB_GLOB_GUID_GUID register field value. */
#define ALT_USB_GLOB_GUID_GUID_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_GLOB_GUID_GUID register field value. */
#define ALT_USB_GLOB_GUID_GUID_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_GLOB_GUID_GUID register field. */
#define ALT_USB_GLOB_GUID_GUID_RESET      0x12345678
/* Extracts the ALT_USB_GLOB_GUID_GUID field value from a register. */
#define ALT_USB_GLOB_GUID_GUID_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_GLOB_GUID_GUID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GUID_GUID_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GUID.
 */
struct ALT_USB_GLOB_GUID_s
{
    uint32_t  guid : 32;  /* User ID */
};

/* The typedef declaration for register ALT_USB_GLOB_GUID. */
typedef volatile struct ALT_USB_GLOB_GUID_s  ALT_USB_GLOB_GUID_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GUID register from the beginning of the component. */
#define ALT_USB_GLOB_GUID_OFST        0x3c
/* The address of the ALT_USB_GLOB_GUID register. */
#define ALT_USB_GLOB_GUID_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GUID_OFST))

/*
 * Register : Synopsys ID Register - gsnpsid
 * 
 * This read-only register contains the release number of the core being used.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description
 * :-------|:-------|:-----------|:------------
 *  [31:0] | R      | 0x4f54293a | Synopsys ID
 * 
 */
/*
 * Field : Synopsys ID - gsnpsid
 * 
 * Release number of the otg core being used is currently OTG 2.93a
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_MSB        31
/* The width in bits of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_WIDTH      32
/* The mask used to set the ALT_USB_GLOB_GSNPSID_GSNPSID register field value. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_GLOB_GSNPSID_GSNPSID register field value. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_GLOB_GSNPSID_GSNPSID register field. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_RESET      0x4f54293a
/* Extracts the ALT_USB_GLOB_GSNPSID_GSNPSID field value from a register. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_GLOB_GSNPSID_GSNPSID register field value suitable for setting the register. */
#define ALT_USB_GLOB_GSNPSID_GSNPSID_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GSNPSID.
 */
struct ALT_USB_GLOB_GSNPSID_s
{
    const uint32_t  gsnpsid : 32;  /* Synopsys ID */
};

/* The typedef declaration for register ALT_USB_GLOB_GSNPSID. */
typedef volatile struct ALT_USB_GLOB_GSNPSID_s  ALT_USB_GLOB_GSNPSID_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GSNPSID register from the beginning of the component. */
#define ALT_USB_GLOB_GSNPSID_OFST        0x40
/* The address of the ALT_USB_GLOB_GSNPSID register. */
#define ALT_USB_GLOB_GSNPSID_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GSNPSID_OFST))

/*
 * Register : User HW Config1 Register - ghwcfg1
 * 
 * This register contains the logical endpoint direction(s).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description       
 * :-------|:-------|:------|:-------------------
 *  [31:0] | R      | 0x0   | Endpoint Direction
 * 
 */
/*
 * Field : Endpoint Direction - ghwcfg1
 * 
 * This 32-bit field uses two bits per endpoint to determine the endpoint
 * direction.
 * 
 * Endpoint
 * 
 * * Bits [31:30]: Endpoint 15 direction
 * 
 * * Bits [29:28]: Endpoint 14 direction
 * 
 * ...
 * 
 * * Bits [3:2]: Endpoint 1 direction
 * 
 * * Bits[1:0]: Endpoint 0 direction (always BIDIR)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                
 * :----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_BDIR     | 0x0   | BIDIR (IN and OUT) endpoint
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_INENDPT  | 0x1   | IN endpoint                
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_OUTENDPT | 0x2   | OUT endpoint               
 *  ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_RSVD     | 0x3   | Reserved                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * BIDIR (IN and OUT) endpoint
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_BDIR     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * IN endpoint
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_INENDPT  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * OUT endpoint
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_OUTENDPT 0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG1_GHWCFG1
 * 
 * Reserved
 */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_E_RSVD     0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_MSB        31
/* The width in bits of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_WIDTH      32
/* The mask used to set the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field value. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field value. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG1_GHWCFG1 field value from a register. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG1_GHWCFG1 register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG1_GHWCFG1_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG1.
 */
struct ALT_USB_GLOB_GHWCFG1_s
{
    const uint32_t  ghwcfg1 : 32;  /* Endpoint Direction */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG1. */
typedef volatile struct ALT_USB_GLOB_GHWCFG1_s  ALT_USB_GLOB_GHWCFG1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GHWCFG1 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG1_OFST        0x44
/* The address of the ALT_USB_GLOB_GHWCFG1 register. */
#define ALT_USB_GLOB_GHWCFG1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG1_OFST))

/*
 * Register : User HW Config2 Register - ghwcfg2
 * 
 * This register contains configuration options.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                       
 * :--------|:-------|:------|:---------------------------------------------------
 *  [2:0]   | R      | 0x0   | Mode of Operation                                 
 *  [4:3]   | R      | 0x2   | Architecture                                      
 *  [5]     | R      | 0x0   | Point-to-Point                                    
 *  [7:6]   | R      | 0x2   | High Speed PHY Interface Type                     
 *  [9:8]   | R      | 0x0   | Full Speed PHY Interface Type                     
 *  [13:10] | R      | 0xf   | Number of Device Endpoints                        
 *  [17:14] | R      | 0xf   | Number of Host Channels                           
 *  [18]    | R      | 0x1   | Periodic OUT Channels Supported in Host Mode      
 *  [19]    | R      | 0x1   | Dynamic FIFO Sizing Enabled                       
 *  [20]    | R      | 0x0   | Multi Processor Interrupt Enabled                 
 *  [21]    | ???    | 0x0   | *UNDEFINED*                                       
 *  [23:22] | R      | 0x2   | Non Periodic Request Queue Depth                  
 *  [25:24] | R      | 0x0   | Host Mode Periodic Request Queue Depth            
 *  [30:26] | R      | 0x8   | Device Mode IN Token Sequence Learning Queue Depth
 *  [31]    | ???    | 0x0   | *UNDEFINED*                                       
 * 
 */
/*
 * Field : Mode of Operation - otgmode
 * 
 * HNP- and SRP-Capable OTG (Device and Host).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                    
 * :---------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_HNPSRP   | 0x0   | HNP- and SRP-Capable OTG (Host & Device        
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPOTG   | 0x1   | SRP-Capable OTG (Host & Device)                
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NHNPNSRP | 0x2   | Non-HNP and Non-SRP Capable OTG (Host & Device)
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPD  | 0x3   | SRP-Capable Device                             
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGD  | 0x4   | Non-OTG Device                                 
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPH  | 0x5   | SRP-Capable Host                               
 *  ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGH  | 0x6   | Non-OTG Host                                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * HNP- and SRP-Capable OTG (Host & Device
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_HNPSRP    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * SRP-Capable OTG (Host & Device)
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPOTG    0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * Non-HNP and Non-SRP Capable OTG (Host & Device)
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NHNPNSRP  0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * SRP-Capable Device
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPD   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * Non-OTG Device
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGD   0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * SRP-Capable Host
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_SRPCAPH   0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGMOD
 * 
 * Non-OTG Host
 */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_E_NONOTGH   0x6

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_MSB        2
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_WIDTH      3
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_OTGMOD register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_SET_MSK    0x00000007
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_OTGMOD register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_CLR_MSK    0xfffffff8
/* The reset value of the ALT_USB_GLOB_GHWCFG2_OTGMOD register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_OTGMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_GET(value) (((value) & 0x00000007) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG2_OTGMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_OTGMOD_SET(value) (((value) << 0) & 0x00000007)

/*
 * Field : Architecture - otgarch
 * 
 * DMA Architecture.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description 
 * :--------------------------------------|:------|:-------------
 *  ALT_USB_GLOB_GHWCFG2_OTGARCH_E_DMAMOD | 0x2   | Internal DMA
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_OTGARCH
 * 
 * Internal DMA
 */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_E_DMAMOD   0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_MSB        4
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_OTGARCH register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_SET_MSK    0x00000018
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_OTGARCH register field value. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_CLR_MSK    0xffffffe7
/* The reset value of the ALT_USB_GLOB_GHWCFG2_OTGARCH register field. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_RESET      0x2
/* Extracts the ALT_USB_GLOB_GHWCFG2_OTGARCH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_GET(value) (((value) & 0x00000018) >> 3)
/* Produces a ALT_USB_GLOB_GHWCFG2_OTGARCH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_OTGARCH_SET(value) (((value) << 3) & 0x00000018)

/*
 * Field : Point-to-Point - singpnt
 * 
 * Single Point Only.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description            
 * :-------------------------------------------|:------|:------------------------
 *  ALT_USB_GLOB_GHWCFG2_SINGPNT_E_SINGLEPOINT | 0x1   | Single-point applicatio
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_SINGPNT
 * 
 * Single-point applicatio
 */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_E_SINGLEPOINT  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_MSB        5
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_SINGPNT register field value. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_SINGPNT register field value. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GHWCFG2_SINGPNT register field. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_SINGPNT field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GHWCFG2_SINGPNT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_SINGPNT_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : High Speed PHY Interface Type - hsphytype
 * 
 * Specifies the High Speed PHY in use.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                       
 * :--------------------------------------|:------|:-----------------------------------
 *  ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_NOHS | 0x0   | High-Speed interface not supported
 *  ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_ULPI | 0x2   | ULPI                              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_HSPHYTYPE
 * 
 * High-Speed interface not supported
 */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_NOHS   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_HSPHYTYPE
 * 
 * ULPI
 */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_E_ULPI   0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_MSB        7
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_SET_MSK    0x000000c0
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_CLR_MSK    0xffffff3f
/* The reset value of the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_RESET      0x2
/* Extracts the ALT_USB_GLOB_GHWCFG2_HSPHYTYPE field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_GET(value) (((value) & 0x000000c0) >> 6)
/* Produces a ALT_USB_GLOB_GHWCFG2_HSPHYTYPE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_HSPHYTYPE_SET(value) (((value) << 6) & 0x000000c0)

/*
 * Field : Full Speed PHY Interface Type - fsphytype
 * 
 * Specifies the Full Speed PHY in use.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description
 * :-------------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_E_FULLSPEED | 0x2   | ULPI Type  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_FSPHYTYPE
 * 
 * ULPI Type
 */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_E_FULLSPEED  0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_MSB        9
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_SET_MSK    0x00000300
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_CLR_MSK    0xfffffcff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_FSPHYTYPE field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_GET(value) (((value) & 0x00000300) >> 8)
/* Produces a ALT_USB_GLOB_GHWCFG2_FSPHYTYPE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_FSPHYTYPE_SET(value) (((value) << 8) & 0x00000300)

/*
 * Field : Number of Device Endpoints - numdeveps
 * 
 * The number of endpoints is 1 to 15 in Device mode in addition to control
 * endpoint 0.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description  
 * :-----------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  0
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  1
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  2
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  3
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  4
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  5
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  6
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  7
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  8
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  9
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  10
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  11
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  12
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  13
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  14
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMDEVEPS
 * 
 * End point  15
 */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_MSB        13
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_SET_MSK    0x00003c00
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_CLR_MSK    0xffffc3ff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG2_NUMDEVEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_GET(value) (((value) & 0x00003c00) >> 10)
/* Produces a ALT_USB_GLOB_GHWCFG2_NUMDEVEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_NUMDEVEPS_SET(value) (((value) << 10) & 0x00003c00)

/*
 * Field : Number of Host Channels - numhstchnl
 * 
 * Indicates the number of host channels supported by the core in Host mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description    
 * :-------------------------------------------|:------|:----------------
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH0  | 0x0   | Host Channel 1 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH1  | 0x1   | Host Channel 2 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH2  | 0x2   | Host Channel 3 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH3  | 0x3   | Host Channel 4 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH4  | 0x4   | Host Channel 5 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH5  | 0x5   | Host Channel 6 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH6  | 0x6   | Host Channel 7 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH7  | 0x7   | Host Channel 8 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH8  | 0x8   | Host Channel 9 
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH9  | 0x9   | Host Channel 10
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH10 | 0xa   | Host Channel 11
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH11 | 0xb   | Host Channel 12
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH12 | 0xc   | Host Channel 13
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH13 | 0xd   | Host Channel 14
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH14 | 0xe   | Host Channel 15
 *  ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH15 | 0xf   | Host Channel 16
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 1
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH0   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 2
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH1   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 3
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH2   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 4
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH3   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 5
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH4   0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 6
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH5   0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 7
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH6   0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 8
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH7   0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 9
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH8   0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 10
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH9   0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 11
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH10  0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 12
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH11  0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 13
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH12  0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 14
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH13  0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 15
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH14  0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL
 * 
 * Host Channel 16
 */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_E_HOSTCH15  0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_MSB        17
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_SET_MSK    0x0003c000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field value. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_CLR_MSK    0xfffc3fff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_GET(value) (((value) & 0x0003c000) >> 14)
/* Produces a ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_NUMHSTCHNL_SET(value) (((value) << 14) & 0x0003c000)

/*
 * Field : Periodic OUT Channels Supported in Host Mode - periosupport
 * 
 * Feature supported.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                 
 * :----------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_E_END | 0x1   | Periodic OUT Channels Supported in Host Mode
 * :                                        |       | Supported                                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT
 * 
 * Periodic OUT Channels Supported in Host Mode Supported
 */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_E_END 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_MSB        18
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_SET_MSK    0x00040000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_CLR_MSK    0xfffbffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_GET(value) (((value) & 0x00040000) >> 18)
/* Produces a ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_PERIOSUPPORT_SET(value) (((value) << 18) & 0x00040000)

/*
 * Field : Dynamic FIFO Sizing Enabled - dynfifosizing
 * 
 * Feature supported.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                
 * :-----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_E_END | 0x1   | Dynamic FIFO Sizing Enabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING
 * 
 * Dynamic FIFO Sizing Enabled
 */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_MSB        19
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field value. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_SET_MSK    0x00080000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field value. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_CLR_MSK    0xfff7ffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_GET(value) (((value) & 0x00080000) >> 19)
/* Produces a ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_DYNFIFOSIZING_SET(value) (((value) << 19) & 0x00080000)

/*
 * Field : Multi Processor Interrupt Enabled - multiprocintrpt
 * 
 * Not implemented.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description                         
 * :--------------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_E_DISD | 0x0   | No Multi Processor Interrupt Enabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT
 * 
 * No Multi Processor Interrupt Enabled
 */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_MSB        20
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field value. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field value. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_MULTIPROCINTRPT_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : Non Periodic Request Queue Depth - nptxqdepth
 * 
 * Specifies the Non-periodic Request Queue depth, the maximum number of packets
 * that can reside in the Non-periodic TxFIFO.
 * 
 * In Device mode, the queue is used only in Shared FIFO Mode (Enable Dedicated
 * Transmit FIFO for device IN Endpoints? =No). In this mode, there is one entry in
 * the Non-periodic Request Queue for each packet in the Non-periodic TxFIFO.
 * 
 * In Host mode, this queue holds one entry corresponding to each IN or OUT
 * nonperiodic request. This queue is seven bits wide.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_TWO   | 0x0   | Que size 2 
 *  ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_FOUR  | 0x1   | Que size 4 
 *  ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_EIGHT | 0x2   | Que size 8 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH
 * 
 * Que size 2
 */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_TWO   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH
 * 
 * Que size 4
 */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_FOUR  0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH
 * 
 * Que size 8
 */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_E_EIGHT 0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_MSB        23
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_SET_MSK    0x00c00000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_CLR_MSK    0xff3fffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_RESET      0x2
/* Extracts the ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_GET(value) (((value) & 0x00c00000) >> 22)
/* Produces a ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_NPTXQDEPTH_SET(value) (((value) << 22) & 0x00c00000)

/*
 * Field : Host Mode Periodic Request Queue Depth - ptxqdepth
 * 
 * Specifies the Host mode Periodic Request Queue depth.That is, the maximum number
 * of packets that can reside in the Host Periodic TxFIFO. This queue holds one
 * entry corresponding to each IN or OUT periodic request. This queue is 9 bits
 * wide.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description 
 * :---------------------------------------|:------|:-------------
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE2  | 0x0   | Que Depth 2 
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE4  | 0x1   | Que Depth 4 
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE8  | 0x2   | Que Depth 8 
 *  ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE16 | 0x3   | Que Depth 16
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 2
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE2   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 4
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE4   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 8
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE8   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG2_PTXQDEPTH
 * 
 * Que Depth 16
 */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_E_QUE16  0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_MSB        25
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_SET_MSK    0x03000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_CLR_MSK    0xfcffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG2_PTXQDEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_GET(value) (((value) & 0x03000000) >> 24)
/* Produces a ALT_USB_GLOB_GHWCFG2_PTXQDEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_PTXQDEPTH_SET(value) (((value) << 24) & 0x03000000)

/*
 * Field : Device Mode IN Token Sequence Learning Queue Depth - tknqdepth
 * 
 * Range: 0 to 30.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_MSB        30
/* The width in bits of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_WIDTH      5
/* The mask used to set the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_SET_MSK    0x7c000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_CLR_MSK    0x83ffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_RESET      0x8
/* Extracts the ALT_USB_GLOB_GHWCFG2_TKNQDEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_GET(value) (((value) & 0x7c000000) >> 26)
/* Produces a ALT_USB_GLOB_GHWCFG2_TKNQDEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG2_TKNQDEPTH_SET(value) (((value) << 26) & 0x7c000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG2.
 */
struct ALT_USB_GLOB_GHWCFG2_s
{
    const uint32_t  otgmode         :  3;  /* Mode of Operation */
    const uint32_t  otgarch         :  2;  /* Architecture */
    const uint32_t  singpnt         :  1;  /* Point-to-Point */
    const uint32_t  hsphytype       :  2;  /* High Speed PHY Interface Type */
    const uint32_t  fsphytype       :  2;  /* Full Speed PHY Interface Type */
    const uint32_t  numdeveps       :  4;  /* Number of Device Endpoints */
    const uint32_t  numhstchnl      :  4;  /* Number of Host Channels */
    const uint32_t  periosupport    :  1;  /* Periodic OUT Channels Supported in Host Mode */
    const uint32_t  dynfifosizing   :  1;  /* Dynamic FIFO Sizing Enabled */
    const uint32_t  multiprocintrpt :  1;  /* Multi Processor Interrupt Enabled */
    uint32_t                        :  1;  /* *UNDEFINED* */
    const uint32_t  nptxqdepth      :  2;  /* Non Periodic Request Queue Depth */
    const uint32_t  ptxqdepth       :  2;  /* Host Mode Periodic Request Queue Depth */
    const uint32_t  tknqdepth       :  5;  /* Device Mode IN Token Sequence Learning Queue Depth */
    uint32_t                        :  1;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG2. */
typedef volatile struct ALT_USB_GLOB_GHWCFG2_s  ALT_USB_GLOB_GHWCFG2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GHWCFG2 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG2_OFST        0x48
/* The address of the ALT_USB_GLOB_GHWCFG2 register. */
#define ALT_USB_GLOB_GHWCFG2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG2_OFST))

/*
 * Register : User HW Config3 Register - ghwcfg3
 * 
 * This register contains the configuration options.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [3:0]   | R      | 0x8    | Width of Transfer Size Counters             
 *  [6:4]   | R      | 0x6    | Width of Packet Size Counters               
 *  [7]     | R      | 0x1    | OTG Function Enabled                        
 *  [8]     | R      | 0x0    | I2C Selection                               
 *  [9]     | R      | 0x1    | Vendor Control Interface Suppor             
 *  [10]    | R      | 0x0    | Optional Features Removed                   
 *  [11]    | R      | 0x0    | Reset Style for Clocked always Blocks in RTL
 *  [12]    | R      | 0x0    | OTG ADP Support                             
 *  [13]    | R      | 0x0    | OTG ENABLE HSIC                             
 *  [14]    | R      | 0x0    | OTG BC SUPPORT                              
 *  [15]    | R      | 0x0    | OTG ENABLE LPM                              
 *  [31:16] | R      | 0x1f80 | DFIFO Depth                                 
 * 
 */
/*
 * Field : Width of Transfer Size Counters - xfersizewidth
 * 
 * Width variable from 11 to 19 bits.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                           
 * :---------------------------------------------|:------|:---------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH11 | 0x0   | Width of Transfer Size Counter 11 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH12 | 0x1   | Width of Transfer Size Counter 12 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH13 | 0x2   | Width of Transfer Size Counter 13 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH14 | 0x3   | Width of Transfer Size Counter 14 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH15 | 0x4   | Width of Transfer Size Counter 15 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH16 | 0x5   | Width of Transfer Size Counter 16 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH17 | 0x6   | Width of Transfer Size Counter 17 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH18 | 0x7   | Width of Transfer Size Counter 18 bits
 *  ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH19 | 0x8   | Width of Transfer Size Counter 19 bits
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 11 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH11    0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 12 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH12    0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 13 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH13    0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 14 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH14    0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 15 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH15    0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 16 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH16    0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 17 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH17    0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 18 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH18    0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH
 * 
 * Width of Transfer Size Counter 19 bits
 */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_E_WIDTH19    0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_MSB        3
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_RESET      0x8
/* Extracts the ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_XFERSIZEWIDTH_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : Width of Packet Size Counters - pktsizewidth
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                    
 * :-------------------------------------------|:------|:--------------------------------
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS4  | 0x0   | Width of Packet Size Counter 4 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS5  | 0x1   | Width of Packet Size Counter 5 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS6  | 0x2   | Width of Packet Size Counter 6 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS7  | 0x3   | Width of Packet Size Counter 7 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS8  | 0x4   | Width of Packet Size Counter 8 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS9  | 0x5   | Width of Packet Size Counter 9 
 *  ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS10 | 0x6   | Width of Packet Size Counter 10
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 4
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS4   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 5
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS5   0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 6
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS6   0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 7
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS7   0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 8
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS8   0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 9
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS9   0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH
 * 
 * Width of Packet Size Counter 10
 */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_E_BITS10  0x6

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_MSB        6
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_WIDTH      3
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_SET_MSK    0x00000070
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_CLR_MSK    0xffffff8f
/* The reset value of the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_RESET      0x6
/* Extracts the ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_GET(value) (((value) & 0x00000070) >> 4)
/* Produces a ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_PKTSIZEWIDTH_SET(value) (((value) << 4) & 0x00000070)

/*
 * Field : OTG Function Enabled - otgen
 * 
 * HNP and SRP Capable OTG (Device and Host)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG3_OTGEN_E_END | 0x1   | OTG Capable
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_OTGEN
 * 
 * OTG Capable
 */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_E_END    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_MSB        7
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_OTGEN register field value. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_OTGEN register field value. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_GLOB_GHWCFG3_OTGEN register field. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG3_OTGEN field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_GLOB_GHWCFG3_OTGEN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_OTGEN_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : I2C Selection - i2cintsel
 * 
 * I2C Interface not used.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description  
 * :--------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GHWCFG3_I2CINTSEL_E_DISD | 0x0   | I2C Interface
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_I2CINTSEL
 * 
 * I2C Interface
 */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_E_DISD   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_MSB        8
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field value. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field value. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_I2CINTSEL field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_GLOB_GHWCFG3_I2CINTSEL register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_I2CINTSEL_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Vendor Control Interface Suppor - vndctlsupt
 * 
 * ULPI  PHY internal registers can be accessed by software using register
 * reads/writes to otg
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                     
 * :--------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_E_END | 0x1   | Vendor Control Interface is not available on the
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT
 * 
 * Vendor Control Interface is not available on the
 */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_MSB        9
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field value. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field value. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_VNDCTLSUPT_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Optional Features Removed - optfeature
 * 
 * User ID register, GPIO interface ports, and SOF toggle and counter ports were
 * removed.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_GLOB_GHWCFG3_OPTFEATURE_E_DISD | 0x0   | No Optional features
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_OPTFEATURE
 * 
 * No Optional features
 */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_MSB        10
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field value. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field value. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_OPTFEATURE field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_GLOB_GHWCFG3_OPTFEATURE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_OPTFEATURE_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : Reset Style for Clocked always Blocks in RTL - rsttype
 * 
 * Defines what reset type is used in the core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                           
 * :-----------------------------------|:------|:---------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_RSTTYPE_E_END | 0x0   | Asynchronous reset is used in the core
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_RSTTYPE
 * 
 * Asynchronous reset is used in the core
 */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_E_END  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_MSB        11
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field value. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_RSTTYPE register field. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_RSTTYPE field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_GLOB_GHWCFG3_RSTTYPE register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_RSTTYPE_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : OTG ADP Support - adpsupport
 * 
 * ADP logic support.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                     
 * :--------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_E_END | 0x1   | ADP logic is present along with HSOTG controller
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_ADPSUPPORT
 * 
 * ADP logic is present along with HSOTG controller
 */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_MSB        12
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_ADPSUPPORT field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_GLOB_GHWCFG3_ADPSUPPORT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_ADPSUPPORT_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : OTG ENABLE HSIC - hsicmode
 * 
 * Supports HSIC and Non-HSIC Modes.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_GLOB_GHWCFG3_HSICMOD_E_DISD | 0x0   | Non-HSIC-capable
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_HSICMOD
 * 
 * Non-HSIC-capable
 */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_MSB        13
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_HSICMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_HSICMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_HSICMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_HSICMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_GLOB_GHWCFG3_HSICMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_HSICMOD_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : OTG BC SUPPORT - bcsupport
 * 
 * Battery Charger Support.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description               
 * :--------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GHWCFG3_BCSUPPORT_E_DISD | 0x0   | No Battery Charger Support
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_BCSUPPORT
 * 
 * No Battery Charger Support
 */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_E_DISD   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_MSB        14
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_SET_MSK    0x00004000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field value. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_CLR_MSK    0xffffbfff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_BCSUPPORT field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_USB_GLOB_GHWCFG3_BCSUPPORT register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_BCSUPPORT_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : OTG ENABLE LPM - lpmmode
 * 
 * LPM Mode Enabled/Disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description 
 * :-----------------------------------|:------|:-------------
 *  ALT_USB_GLOB_GHWCFG3_LPMMOD_E_DISD | 0x0   | LPM disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG3_LPMMOD
 * 
 * LPM disabled
 */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_MSB        15
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_LPMMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_LPMMOD register field value. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_LPMMOD register field. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG3_LPMMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_GLOB_GHWCFG3_LPMMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_LPMMOD_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : DFIFO Depth - dfifodepth
 * 
 * DFIFO Depth. This value is in terms of 35-bit words.
 * 
 * Minimum value is 32
 * 
 * Maximum value is 8192
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_MSB        31
/* The width in bits of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field value. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_RESET      0x1f80
/* Extracts the ALT_USB_GLOB_GHWCFG3_DFIFODEPTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_GLOB_GHWCFG3_DFIFODEPTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG3_DFIFODEPTH_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG3.
 */
struct ALT_USB_GLOB_GHWCFG3_s
{
    const uint32_t  xfersizewidth :  4;  /* Width of Transfer Size Counters */
    const uint32_t  pktsizewidth  :  3;  /* Width of Packet Size Counters */
    const uint32_t  otgen         :  1;  /* OTG Function Enabled */
    const uint32_t  i2cintsel     :  1;  /* I2C Selection */
    const uint32_t  vndctlsupt    :  1;  /* Vendor Control Interface Suppor */
    const uint32_t  optfeature    :  1;  /* Optional Features Removed */
    const uint32_t  rsttype       :  1;  /* Reset Style for Clocked always Blocks in RTL */
    const uint32_t  adpsupport    :  1;  /* OTG ADP Support */
    const uint32_t  hsicmode      :  1;  /* OTG ENABLE HSIC */
    const uint32_t  bcsupport     :  1;  /* OTG BC SUPPORT */
    const uint32_t  lpmmode       :  1;  /* OTG ENABLE LPM */
    const uint32_t  dfifodepth    : 16;  /* DFIFO Depth */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG3. */
typedef volatile struct ALT_USB_GLOB_GHWCFG3_s  ALT_USB_GLOB_GHWCFG3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GHWCFG3 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG3_OFST        0x4c
/* The address of the ALT_USB_GLOB_GHWCFG3 register. */
#define ALT_USB_GLOB_GHWCFG3_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG3_OFST))

/*
 * Register : User HW Config4 Register - ghwcfg4
 * 
 * This register contains the configuration options.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                                      
 * :--------|:-------|:------|:------------------------------------------------------------------
 *  [3:0]   | R      | 0x0   | Number of Device Mode Periodic IN Endpoints                      
 *  [4]     | R      | 0x0   | Enable Partial Power Down                                        
 *  [5]     | R      | 0x1   | Minimum AHB Frequency Less Than 60 MHz                           
 *  [6]     | R      | 0x0   | Enable Hibernation                                               
 *  [13:7]  | ???    | 0x0   | *UNDEFINED*                                                      
 *  [15:14] | R      | 0x0   | UTMI+ PHY/ULPI-to-Internal UTMI+ Wrapper Data Width              
 *  [19:16] | R      | 0xf   | Number of Device Mode Control Endpoints in Addition to Endpoint 0
 *  [20]    | R      | 0x0   | Iddig Filter Enable                                              
 *  [21]    | R      | 0x0   | Vbus Valid Filter Enabled                                        
 *  [22]    | R      | 0x0   | a_valid Filter                                                   
 *  [23]    | R      | 0x0   | b_valid Filter                                                   
 *  [24]    | R      | 0x0   | Session End Filter                                               
 *  [25]    | R      | 0x1   | Enable Dedicated Transmit FIFO for device IN Endpoints           
 *  [29:26] | R      | 0xf   | Number of Device Mode IN Endpoints Including Control             
 *  [30]    | R      | 0x1   | Scatter Gather DMA configuration                                 
 *  [31]    | R      | 0x1   | Scatter Gather DMA                                               
 * 
 */
/*
 * Field : Number of Device Mode Periodic IN Endpoints - numdevperioeps
 * 
 * The maximum number of device IN operations is 16 active at any time including
 * endpoint 0, which is always present. This parameter determines the number of
 * device mode Tx FIFOs to be instantiated.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_MSB        3
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_SET_MSK    0x0000000f
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_CLR_MSK    0xfffffff0
/* The reset value of the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_NUMDEVPERIOEPS_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : Enable Partial Power Down - partialpwrdn
 * 
 * Specifies whether to enable power optimization.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                
 * :-----------------------------------------|:------|:----------------------------
 *  ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_E_DISD | 0x0   | Partial Power Down disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN
 * 
 * Partial Power Down disabled
 */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_E_DISD    0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_MSB        4
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field value. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field value. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_PARTIALPWRDN_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Minimum AHB Frequency Less Than 60 MHz - ahbfreq
 * 
 * When the AHB frequency is less than 60 MHz, 4-deep clock-domain crossing sink
 * and source buffers are instantiated between the MAC and the Packet FIFO
 * Controller (PFC); otherwise, two-deep buffers are sufficient.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                          
 * :-----------------------------------|:------|:--------------------------------------
 *  ALT_USB_GLOB_GHWCFG4_AHBFREQ_E_END | 0x1   | Minimum AHB Frequency Less Than 60 MH
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_AHBFREQ
 * 
 * Minimum AHB Frequency Less Than 60 MH
 */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_MSB        5
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field value. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field value. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_GLOB_GHWCFG4_AHBFREQ register field. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_AHBFREQ field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_GLOB_GHWCFG4_AHBFREQ register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_AHBFREQ_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Enable Hibernation - hibernation
 * 
 * Enables power saving mode hibernation.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                 
 * :----------------------------------------|:------|:-----------------------------
 *  ALT_USB_GLOB_GHWCFG4_HIBERNATION_E_DISD | 0x0   | Hibernation feature disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_HIBERNATION
 * 
 * Hibernation feature disabled
 */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_MSB        6
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field value. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field value. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_GLOB_GHWCFG4_HIBERNATION register field. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_HIBERNATION field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_GLOB_GHWCFG4_HIBERNATION register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_HIBERNATION_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : UTMI+ PHY/ULPI-to-Internal UTMI+ Wrapper Data Width - phydatawidth
 * 
 * Uses a ULPI interface only. Hence only 8-bit setting is relevant. This setting
 * should not matter since UTMI is not enabled.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_MSB        15
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_WIDTH      2
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field value. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_PHYDATAWIDTH_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : Number of Device Mode Control Endpoints in Addition to Endpoint 0 - numctleps
 * 
 * Specifies the number of Device mode control endpoints in addition to control
 * endpoint 0, which is always present. Range: 0-15.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description  
 * :-----------------------------------------|:------|:--------------
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  0
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  1
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  2
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  3
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  4
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  5
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  6
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  7
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  8
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  9
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  10
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  11
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  12
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  13
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  14
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_NUMCTLEPS
 * 
 * End point  15
 */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_MSB        19
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_SET_MSK    0x000f0000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_CLR_MSK    0xfff0ffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG4_NUMCTLEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_GET(value) (((value) & 0x000f0000) >> 16)
/* Produces a ALT_USB_GLOB_GHWCFG4_NUMCTLEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_NUMCTLEPS_SET(value) (((value) << 16) & 0x000f0000)

/*
 * Field : Iddig Filter Enable - iddgfltr
 * 
 * Specifies whether to add a filter on the iddig input from the PHY. This is not
 * relevant since we only support ULPI and there is no iddig pin exposed to I/O
 * pads.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description          
 * :-------------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GHWCFG4_IDDGFLTR_E_DISD | 0x0   | Iddig Filter Disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_IDDGFLTR
 * 
 * Iddig Filter Disabled
 */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_E_DISD    0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_MSB        20
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_SET_MSK    0x00100000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_CLR_MSK    0xffefffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_IDDGFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_GET(value) (((value) & 0x00100000) >> 20)
/* Produces a ALT_USB_GLOB_GHWCFG4_IDDGFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_IDDGFLTR_SET(value) (((value) << 20) & 0x00100000)

/*
 * Field : Vbus Valid Filter Enabled - vbusvalidfltr
 * 
 * Vbus Valid Filter Enabled (VBusValidFltr) 0: No filter 1: Filter(coreConsultant
 * parameter: OTG_EN_VBUSVALID_FILTER)
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description               
 * :------------------------------------------|:------|:---------------------------
 *  ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_E_DISD | 0x0   | Vbus Valid Filter Disabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR
 * 
 * Vbus Valid Filter Disabled
 */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_E_DISD   0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_LSB        21
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_MSB        21
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_SET_MSK    0x00200000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_CLR_MSK    0xffdfffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_GET(value) (((value) & 0x00200000) >> 21)
/* Produces a ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_VBUSVALIDFLTR_SET(value) (((value) << 21) & 0x00200000)

/*
 * Field : a_valid Filter - avalidfltr
 * 
 * Specifies whether to add a filter on the b_valid input from the PHY.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_E_DISD | 0x0   | No filter  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_AVALIDFLTR
 * 
 * No filter
 */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_MSB        22
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_SET_MSK    0x00400000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_CLR_MSK    0xffbfffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_AVALIDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_GET(value) (((value) & 0x00400000) >> 22)
/* Produces a ALT_USB_GLOB_GHWCFG4_AVALIDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_AVALIDFLTR_SET(value) (((value) << 22) & 0x00400000)

/*
 * Field : b_valid Filter - bvalidfltr
 * 
 * Specifies whether to add a filter on the b_valid input from the PHY.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description
 * :---------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_E_DISD | 0x0   | No Filter  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_BVALIDFLTR
 * 
 * No Filter
 */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_E_DISD  0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_MSB        23
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_BVALIDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_GLOB_GHWCFG4_BVALIDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_BVALIDFLTR_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : Session End Filter - sessendfltr
 * 
 * Specifies whether to add a filter on the session_end input from the PHY.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description
 * :----------------------------------------|:------|:------------
 *  ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_E_DISD | 0x0   | No filter  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_SESSENDFLTR
 * 
 * No filter
 */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_E_DISD 0x0

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_MSB        24
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field value. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_RESET      0x0
/* Extracts the ALT_USB_GLOB_GHWCFG4_SESSENDFLTR field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_GLOB_GHWCFG4_SESSENDFLTR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_SESSENDFLTR_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Enable Dedicated Transmit FIFO for device IN Endpoints - dedfifomode
 * 
 * Specifies whether Dedicated Transmit FIFOs should be enabled in device mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                              
 * :--------------------------------------|:------|:------------------------------------------
 *  ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_E_END | 0x1   | Dedicated Transmit FIFO Operation enabled
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD
 * 
 * Dedicated Transmit FIFO Operation enabled
 */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_MSB        25
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field value. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_SET_MSK    0x02000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field value. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_CLR_MSK    0xfdffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_GET(value) (((value) & 0x02000000) >> 25)
/* Produces a ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_DEDFIFOMOD_SET(value) (((value) << 25) & 0x02000000)

/*
 * Field : Number of Device Mode IN Endpoints Including Control - ineps
 * 
 * Number of Device Mode IN Endpoints Including Control.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description   
 * :-------------------------------------|:------|:---------------
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT1  | 0x0   | In Endpoint 1 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT2  | 0x1   | In Endpoint 2 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT3  | 0x2   | In Endpoint 3 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT4  | 0x3   | In Endpoint 4 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT5  | 0x4   | In Endpoint 5 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT6  | 0x5   | In Endpoint 6 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT7  | 0x6   | In Endpoint 7 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT8  | 0x7   | In Endpoint 8 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT9  | 0x8   | In Endpoint 9 
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT10 | 0x9   | In Endpoint 10
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT11 | 0xa   | In Endpoint 11
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT12 | 0xb   | In Endpoint 12
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT13 | 0xc   | In Endpoint 13
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT14 | 0xd   | In Endpoint 14
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT15 | 0xe   | In Endpoint 15
 *  ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT16 | 0xf   | In Endpoint 16
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 1
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT1     0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 2
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT2     0x1
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 3
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT3     0x2
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 4
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT4     0x3
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 5
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT5     0x4
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 6
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT6     0x5
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 7
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT7     0x6
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 8
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT8     0x7
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 9
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT9     0x8
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 10
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT10    0x9
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 11
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT11    0xa
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 12
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT12    0xb
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 13
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT13    0xc
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 14
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT14    0xd
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 15
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT15    0xe
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_INEPS
 * 
 * In Endpoint 16
 */
#define ALT_USB_GLOB_GHWCFG4_INEPS_E_ENDPT16    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_MSB        29
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_WIDTH      4
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_INEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_SET_MSK    0x3c000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_INEPS register field value. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_CLR_MSK    0xc3ffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_INEPS register field. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_RESET      0xf
/* Extracts the ALT_USB_GLOB_GHWCFG4_INEPS field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_GET(value) (((value) & 0x3c000000) >> 26)
/* Produces a ALT_USB_GLOB_GHWCFG4_INEPS register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_INEPS_SET(value) (((value) << 26) & 0x3c000000)

/*
 * Field : Scatter Gather DMA configuration - dma_configuration
 * 
 * Selects bewteen scatter and nonscatter configuration
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                         
 * :------------------------------------------|:------|:-------------------------------------
 *  ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_NONSCATTER | 0x0   | Non-Scatter/Gather DMA configuration
 *  ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_SCATTER    | 0x1   | Scatter/Gather DMA configuration    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DMA_CFG
 * 
 * Non-Scatter/Gather DMA configuration
 */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_NONSCATTER   0x0
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DMA_CFG
 * 
 * Scatter/Gather DMA configuration
 */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_E_SCATTER      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_MSB        30
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_DMA_CFG register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_DMA_CFG field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_GLOB_GHWCFG4_DMA_CFG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CFG_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Scatter Gather DMA - dma
 * 
 * Enable descriptor based scatter/gather DMA.  When enabled, DMA operations will
 * be serviced with descriptor based scatter/gather DMA
 * 
 * Field Enumeration Values:
 * 
 *  Enum                           | Value | Description          
 * :-------------------------------|:------|:----------------------
 *  ALT_USB_GLOB_GHWCFG4_DMA_E_END | 0x1   | Dynamic configuration
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_GLOB_GHWCFG4_DMA
 * 
 * Dynamic configuration
 */
#define ALT_USB_GLOB_GHWCFG4_DMA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_MSB        31
/* The width in bits of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_WIDTH      1
/* The mask used to set the ALT_USB_GLOB_GHWCFG4_DMA register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_GLOB_GHWCFG4_DMA register field value. */
#define ALT_USB_GLOB_GHWCFG4_DMA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_GLOB_GHWCFG4_DMA register field. */
#define ALT_USB_GLOB_GHWCFG4_DMA_RESET      0x1
/* Extracts the ALT_USB_GLOB_GHWCFG4_DMA field value from a register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_GLOB_GHWCFG4_DMA register field value suitable for setting the register. */
#define ALT_USB_GLOB_GHWCFG4_DMA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GHWCFG4.
 */
struct ALT_USB_GLOB_GHWCFG4_s
{
    const uint32_t  numdevperioeps    :  4;  /* Number of Device Mode Periodic IN Endpoints */
    const uint32_t  partialpwrdn      :  1;  /* Enable Partial Power Down */
    const uint32_t  ahbfreq           :  1;  /* Minimum AHB Frequency Less Than 60 MHz */
    const uint32_t  hibernation       :  1;  /* Enable Hibernation */
    uint32_t                          :  7;  /* *UNDEFINED* */
    const uint32_t  phydatawidth      :  2;  /* UTMI+ PHY/ULPI-to-Internal UTMI+ Wrapper Data Width */
    const uint32_t  numctleps         :  4;  /* Number of Device Mode Control Endpoints in Addition to Endpoint 0 */
    const uint32_t  iddgfltr          :  1;  /* Iddig Filter Enable */
    const uint32_t  vbusvalidfltr     :  1;  /* Vbus Valid Filter Enabled */
    const uint32_t  avalidfltr        :  1;  /* a_valid Filter */
    const uint32_t  bvalidfltr        :  1;  /* b_valid Filter */
    const uint32_t  sessendfltr       :  1;  /* Session End Filter */
    const uint32_t  dedfifomode       :  1;  /* Enable Dedicated Transmit FIFO for device IN Endpoints */
    const uint32_t  ineps             :  4;  /* Number of Device Mode IN Endpoints Including Control */
    const uint32_t  dma_configuration :  1;  /* Scatter Gather DMA configuration */
    const uint32_t  dma               :  1;  /* Scatter Gather DMA */
};

/* The typedef declaration for register ALT_USB_GLOB_GHWCFG4. */
typedef volatile struct ALT_USB_GLOB_GHWCFG4_s  ALT_USB_GLOB_GHWCFG4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GHWCFG4 register from the beginning of the component. */
#define ALT_USB_GLOB_GHWCFG4_OFST        0x50
/* The address of the ALT_USB_GLOB_GHWCFG4 register. */
#define ALT_USB_GLOB_GHWCFG4_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GHWCFG4_OFST))

/*
 * Register : DFIFO Software Config Register - gdfifocfg
 * 
 * Specifies whether Dedicated Transmit FIFOs should be enabled in device mode.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description             
 * :--------|:-------|:-------|:-------------------------
 *  [15:0]  | RW     | 0x2000 | DFIFO Software Config   
 *  [31:16] | RW     | 0x1f80 | End Point Info Basr Addr
 * 
 */
/*
 * Field : DFIFO Software Config - gdfifocfg
 * 
 * This field is for dynamic programming of the DFIFO Size. This value takes effect
 * only when the application programs a non zero value to this register. The otg
 * core does not have any corrective logic if the FIFO sizes are programmed
 * incorrectly.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_MSB        15
/* The width in bits of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_RESET      0x2000
/* Extracts the ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG field value from a register. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG register field value suitable for setting the register. */
#define ALT_USB_GLOB_GDFIFOCFG_GDFIFOCFG_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : End Point Info Basr Addr - epinfobaseaddr
 * 
 * This field provides the start address of the EP info controller.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_MSB        31
/* The width in bits of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field value. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_RESET      0x1f80
/* Extracts the ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR field value from a register. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_GDFIFOCFG_EPINFOBASEADDR_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_GDFIFOCFG.
 */
struct ALT_USB_GLOB_GDFIFOCFG_s
{
    uint32_t  gdfifocfg      : 16;  /* DFIFO Software Config */
    uint32_t  epinfobaseaddr : 16;  /* End Point Info Basr Addr */
};

/* The typedef declaration for register ALT_USB_GLOB_GDFIFOCFG. */
typedef volatile struct ALT_USB_GLOB_GDFIFOCFG_s  ALT_USB_GLOB_GDFIFOCFG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_GDFIFOCFG register from the beginning of the component. */
#define ALT_USB_GLOB_GDFIFOCFG_OFST        0x5c
/* The address of the ALT_USB_GLOB_GDFIFOCFG register. */
#define ALT_USB_GLOB_GDFIFOCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_GDFIFOCFG_OFST))

/*
 * Register : Host Periodic Transmit FIFO Size Register - hptxfsiz
 * 
 * This register holds the size and the memory start address of the Periodic TxFIFO
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                       
 * :--------|:-------|:-------|:-----------------------------------
 *  [14:0]  | RW     | 0x4000 | Host Periodic TxFIFO Start Address
 *  [15]    | ???    | 0x0    | *UNDEFINED*                       
 *  [29:16] | RW     | 0x2000 | Host Periodic TxFIFO Depth        
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                       
 * 
 */
/*
 * Field : Host Periodic TxFIFO Start Address - ptxfstaddr
 * 
 * The power-on reset value of this register is the sum of the Largest Rx Data FIFO
 * Depth and Largest Non-periodic Tx Data FIFO. Programmed values must not exceed
 * the power-on value
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_MSB        14
/* The width in bits of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_WIDTH      15
/* The mask used to set the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_SET_MSK    0x00007fff
/* The mask used to clear the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_CLR_MSK    0xffff8000
/* The reset value of the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_RESET      0x4000
/* Extracts the ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_GET(value) (((value) & 0x00007fff) >> 0)
/* Produces a ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSTADDR_SET(value) (((value) << 0) & 0x00007fff)

/*
 * Field : Host Periodic TxFIFO Depth - ptxfsize
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 1024
 * 
 * The power-on reset value of this register is specified as the 1024.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_MSB        29
/* The width in bits of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field value. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_RESET      0x2000
/* Extracts the ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE field value from a register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE register field value suitable for setting the register. */
#define ALT_USB_GLOB_HPTXFSIZ_PTXFSIZE_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_HPTXFSIZ.
 */
struct ALT_USB_GLOB_HPTXFSIZ_s
{
    uint32_t  ptxfstaddr : 15;  /* Host Periodic TxFIFO Start Address */
    uint32_t             :  1;  /* *UNDEFINED* */
    uint32_t  ptxfsize   : 14;  /* Host Periodic TxFIFO Depth */
    uint32_t             :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_HPTXFSIZ. */
typedef volatile struct ALT_USB_GLOB_HPTXFSIZ_s  ALT_USB_GLOB_HPTXFSIZ_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_HPTXFSIZ register from the beginning of the component. */
#define ALT_USB_GLOB_HPTXFSIZ_OFST        0x100
/* The address of the ALT_USB_GLOB_HPTXFSIZ register. */
#define ALT_USB_GLOB_HPTXFSIZ_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_HPTXFSIZ_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 1 - dieptxf1
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [14:0]  | RW     | 0x4000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [15]    | ???    | 0x0    | *UNDEFINED*                                 
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_MSB        14
/* The width in bits of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_WIDTH      15
/* The mask used to set the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_SET_MSK    0x00007fff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_CLR_MSK    0xffff8000
/* The reset value of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_RESET      0x4000
/* Extracts the ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_GET(value) (((value) & 0x00007fff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x00007fff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF1_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF1.
 */
struct ALT_USB_GLOB_DIEPTXF1_s
{
    uint32_t  inepntxfstaddr : 15;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t                 :  1;  /* *UNDEFINED* */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF1. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF1_s  ALT_USB_GLOB_DIEPTXF1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF1 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF1_OFST        0x104
/* The address of the ALT_USB_GLOB_DIEPTXF1 register. */
#define ALT_USB_GLOB_DIEPTXF1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF1_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 2 - dieptxf2
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for instantiated IN endpoint FIFO. For IN endpoint FIFO 0
 * use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [14:0]  | RW     | 0x6000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [15]    | ???    | 0x0    | *UNDEFINED*                                 
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_MSB        14
/* The width in bits of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_WIDTH      15
/* The mask used to set the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_SET_MSK    0x00007fff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_CLR_MSK    0xffff8000
/* The reset value of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_RESET      0x6000
/* Extracts the ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_GET(value) (((value) & 0x00007fff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x00007fff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF2_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF2.
 */
struct ALT_USB_GLOB_DIEPTXF2_s
{
    uint32_t  inepntxfstaddr : 15;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t                 :  1;  /* *UNDEFINED* */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF2. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF2_s  ALT_USB_GLOB_DIEPTXF2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF2 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF2_OFST        0x108
/* The address of the ALT_USB_GLOB_DIEPTXF2 register. */
#define ALT_USB_GLOB_DIEPTXF2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF2_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 3 - dieptxf3
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for instantiated IN endpoint FIFO. For IN endpoint FIFO 0
 * use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0x8000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_RESET      0x8000
/* Extracts the ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.Minimum value is 16Maximum value is 8192
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF3_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF3.
 */
struct ALT_USB_GLOB_DIEPTXF3_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF3. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF3_s  ALT_USB_GLOB_DIEPTXF3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF3 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF3_OFST        0x10c
/* The address of the ALT_USB_GLOB_DIEPTXF3 register. */
#define ALT_USB_GLOB_DIEPTXF3_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF3_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 4 - dieptxf4
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0xa000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 4.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_RESET      0xa000
/* Extracts the ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF4_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF4.
 */
struct ALT_USB_GLOB_DIEPTXF4_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF4. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF4_s  ALT_USB_GLOB_DIEPTXF4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF4 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF4_OFST        0x110
/* The address of the ALT_USB_GLOB_DIEPTXF4 register. */
#define ALT_USB_GLOB_DIEPTXF4_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF4_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 5 - dieptxf5
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0xc000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 5.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_RESET      0xc000
/* Extracts the ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF5_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF5.
 */
struct ALT_USB_GLOB_DIEPTXF5_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF5. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF5_s  ALT_USB_GLOB_DIEPTXF5_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF5 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF5_OFST        0x114
/* The address of the ALT_USB_GLOB_DIEPTXF5 register. */
#define ALT_USB_GLOB_DIEPTXF5_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF5_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 6 - dieptxf6
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0xe000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 6.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_RESET      0xe000
/* Extracts the ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF6_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF6.
 */
struct ALT_USB_GLOB_DIEPTXF6_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF6. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF6_s  ALT_USB_GLOB_DIEPTXF6_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF6 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF6_OFST        0x118
/* The address of the ALT_USB_GLOB_DIEPTXF6 register. */
#define ALT_USB_GLOB_DIEPTXF6_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF6_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 7 - dieptxf7
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0x0    | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 7.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_RESET      0x0
/* Extracts the ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF7_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF7.
 */
struct ALT_USB_GLOB_DIEPTXF7_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF7. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF7_s  ALT_USB_GLOB_DIEPTXF7_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF7 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF7_OFST        0x11c
/* The address of the ALT_USB_GLOB_DIEPTXF7 register. */
#define ALT_USB_GLOB_DIEPTXF7_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF7_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 8 - dieptxf8
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0x2000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 8.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF8_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF8.
 */
struct ALT_USB_GLOB_DIEPTXF8_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF8. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF8_s  ALT_USB_GLOB_DIEPTXF8_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF8 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF8_OFST        0x120
/* The address of the ALT_USB_GLOB_DIEPTXF8 register. */
#define ALT_USB_GLOB_DIEPTXF8_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF8_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 9 - dieptxf9
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                
 * :--------|:-------|:-------|:--------------------------------------------
 *  [15:0]  | RW     | 0x4000 | IN Endpoint FIFOn Transmit RAM Start Addres
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                   
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Addres - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 9.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_RESET      0x4000
/* Extracts the ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF9_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF9.
 */
struct ALT_USB_GLOB_DIEPTXF9_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Addres */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF9. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF9_s  ALT_USB_GLOB_DIEPTXF9_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF9 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF9_OFST        0x124
/* The address of the ALT_USB_GLOB_DIEPTXF9 register. */
#define ALT_USB_GLOB_DIEPTXF9_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF9_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 10 - dieptxf10
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0x6000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 10.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_RESET      0x6000
/* Extracts the ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF10_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF10.
 */
struct ALT_USB_GLOB_DIEPTXF10_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF10. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF10_s  ALT_USB_GLOB_DIEPTXF10_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF10 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF10_OFST        0x128
/* The address of the ALT_USB_GLOB_DIEPTXF10 register. */
#define ALT_USB_GLOB_DIEPTXF10_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF10_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 11 - dieptxf11
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0x8000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 11.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_RESET      0x8000
/* Extracts the ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF11_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF11.
 */
struct ALT_USB_GLOB_DIEPTXF11_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF11. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF11_s  ALT_USB_GLOB_DIEPTXF11_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF11 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF11_OFST        0x12c
/* The address of the ALT_USB_GLOB_DIEPTXF11 register. */
#define ALT_USB_GLOB_DIEPTXF11_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF11_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 12 - dieptxf12
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0xa000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 12.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_RESET      0xa000
/* Extracts the ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF12_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF12.
 */
struct ALT_USB_GLOB_DIEPTXF12_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF12. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF12_s  ALT_USB_GLOB_DIEPTXF12_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF12 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF12_OFST        0x130
/* The address of the ALT_USB_GLOB_DIEPTXF12 register. */
#define ALT_USB_GLOB_DIEPTXF12_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF12_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 13 - dieptxf13
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0xc000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 13.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_RESET      0xc000
/* Extracts the ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF13_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF13.
 */
struct ALT_USB_GLOB_DIEPTXF13_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF13. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF13_s  ALT_USB_GLOB_DIEPTXF13_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF13 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF13_OFST        0x134
/* The address of the ALT_USB_GLOB_DIEPTXF13 register. */
#define ALT_USB_GLOB_DIEPTXF13_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF13_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 14 - dieptxf14
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0xe000 | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 14.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_RESET      0xe000
/* Extracts the ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF14_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF14.
 */
struct ALT_USB_GLOB_DIEPTXF14_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF14. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF14_s  ALT_USB_GLOB_DIEPTXF14_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF14 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF14_OFST        0x138
/* The address of the ALT_USB_GLOB_DIEPTXF14 register. */
#define ALT_USB_GLOB_DIEPTXF14_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF14_OFST))

/*
 * Register : Device IN Endpoint Transmit FIFO Size Register 15 - dieptxf15
 * 
 * This register holds the size and memory start address of IN endpoint TxFIFOs
 * implemented in Device mode. Each FIFO holds the data for one IN endpoint. This
 * register is repeated for each instantiated IN endpoint FIFO. For IN endpoint
 * FIFO 0 use GNPTXFSIZ register for programming the size and memory start address.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                 
 * :--------|:-------|:-------|:---------------------------------------------
 *  [15:0]  | RW     | 0x0    | IN Endpoint FIFOn Transmit RAM Start Address
 *  [29:16] | RW     | 0x2000 | IN Endpoint TxFIFO Depth                    
 *  [31:30] | ???    | 0x0    | *UNDEFINED*                                 
 * 
 */
/*
 * Field : IN Endpoint FIFOn Transmit RAM Start Address - inepntxfstaddr
 * 
 * This field contains the memory start address for IN endpoint Transmit FIFO 15.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_MSB        15
/* The width in bits of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_WIDTH      16
/* The mask used to set the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_RESET      0x0
/* Extracts the ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR field value from a register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFSTADDR_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : IN Endpoint TxFIFO Depth - inepntxfdep
 * 
 * This value is in terms of 32-bit words.
 * 
 * Minimum value is 16
 * 
 * Maximum value is 8192.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_MSB        29
/* The width in bits of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_WIDTH      14
/* The mask used to set the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_SET_MSK    0x3fff0000
/* The mask used to clear the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field value. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_CLR_MSK    0xc000ffff
/* The reset value of the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_RESET      0x2000
/* Extracts the ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP field value from a register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_GET(value) (((value) & 0x3fff0000) >> 16)
/* Produces a ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP register field value suitable for setting the register. */
#define ALT_USB_GLOB_DIEPTXF15_INEPNTXFDEP_SET(value) (((value) << 16) & 0x3fff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_GLOB_DIEPTXF15.
 */
struct ALT_USB_GLOB_DIEPTXF15_s
{
    uint32_t  inepntxfstaddr : 16;  /* IN Endpoint FIFOn Transmit RAM Start Address */
    uint32_t  inepntxfdep    : 14;  /* IN Endpoint TxFIFO Depth */
    uint32_t                 :  2;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_GLOB_DIEPTXF15. */
typedef volatile struct ALT_USB_GLOB_DIEPTXF15_s  ALT_USB_GLOB_DIEPTXF15_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_GLOB_DIEPTXF15 register from the beginning of the component. */
#define ALT_USB_GLOB_DIEPTXF15_OFST        0x13c
/* The address of the ALT_USB_GLOB_DIEPTXF15 register. */
#define ALT_USB_GLOB_DIEPTXF15_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_GLOB_DIEPTXF15_OFST))

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_USB_GLOB.
 */
struct ALT_USB_GLOB_s
{
    volatile ALT_USB_GLOB_GOTGCTL_t    gotgctl;             /* ALT_USB_GLOB_GOTGCTL */
    volatile ALT_USB_GLOB_GOTGINT_t    gotgint;             /* ALT_USB_GLOB_GOTGINT */
    volatile ALT_USB_GLOB_GAHBCFG_t    gahbcfg;             /* ALT_USB_GLOB_GAHBCFG */
    volatile ALT_USB_GLOB_GUSBCFG_t    gusbcfg;             /* ALT_USB_GLOB_GUSBCFG */
    volatile ALT_USB_GLOB_GRSTCTL_t    grstctl;             /* ALT_USB_GLOB_GRSTCTL */
    volatile ALT_USB_GLOB_GINTSTS_t    gintsts;             /* ALT_USB_GLOB_GINTSTS */
    volatile ALT_USB_GLOB_GINTMSK_t    gintmsk;             /* ALT_USB_GLOB_GINTMSK */
    volatile ALT_USB_GLOB_GRXSTSR_t    grxstsr;             /* ALT_USB_GLOB_GRXSTSR */
    volatile ALT_USB_GLOB_GRXSTSP_t    grxstsp;             /* ALT_USB_GLOB_GRXSTSP */
    volatile ALT_USB_GLOB_GRXFSIZ_t    grxfsiz;             /* ALT_USB_GLOB_GRXFSIZ */
    volatile ALT_USB_GLOB_GNPTXFSIZ_t  gnptxfsiz;           /* ALT_USB_GLOB_GNPTXFSIZ */
    volatile ALT_USB_GLOB_GNPTXSTS_t   gnptxsts;            /* ALT_USB_GLOB_GNPTXSTS */
    volatile uint32_t                  _pad_0x30_0x33;      /* *UNDEFINED* */
    volatile ALT_USB_GLOB_GPVNDCTL_t   gpvndctl;            /* ALT_USB_GLOB_GPVNDCTL */
    volatile ALT_USB_GLOB_GGPIO_t      ggpio;               /* ALT_USB_GLOB_GGPIO */
    volatile ALT_USB_GLOB_GUID_t       guid;                /* ALT_USB_GLOB_GUID */
    volatile ALT_USB_GLOB_GSNPSID_t    gsnpsid;             /* ALT_USB_GLOB_GSNPSID */
    volatile ALT_USB_GLOB_GHWCFG1_t    ghwcfg1;             /* ALT_USB_GLOB_GHWCFG1 */
    volatile ALT_USB_GLOB_GHWCFG2_t    ghwcfg2;             /* ALT_USB_GLOB_GHWCFG2 */
    volatile ALT_USB_GLOB_GHWCFG3_t    ghwcfg3;             /* ALT_USB_GLOB_GHWCFG3 */
    volatile ALT_USB_GLOB_GHWCFG4_t    ghwcfg4;             /* ALT_USB_GLOB_GHWCFG4 */
    volatile uint32_t                  _pad_0x54_0x5b[2];   /* *UNDEFINED* */
    volatile ALT_USB_GLOB_GDFIFOCFG_t  gdfifocfg;           /* ALT_USB_GLOB_GDFIFOCFG */
    volatile uint32_t                  _pad_0x60_0xff[40];  /* *UNDEFINED* */
    volatile ALT_USB_GLOB_HPTXFSIZ_t   hptxfsiz;            /* ALT_USB_GLOB_HPTXFSIZ */
    volatile ALT_USB_GLOB_DIEPTXF1_t   dieptxf1;            /* ALT_USB_GLOB_DIEPTXF1 */
    volatile ALT_USB_GLOB_DIEPTXF2_t   dieptxf2;            /* ALT_USB_GLOB_DIEPTXF2 */
    volatile ALT_USB_GLOB_DIEPTXF3_t   dieptxf3;            /* ALT_USB_GLOB_DIEPTXF3 */
    volatile ALT_USB_GLOB_DIEPTXF4_t   dieptxf4;            /* ALT_USB_GLOB_DIEPTXF4 */
    volatile ALT_USB_GLOB_DIEPTXF5_t   dieptxf5;            /* ALT_USB_GLOB_DIEPTXF5 */
    volatile ALT_USB_GLOB_DIEPTXF6_t   dieptxf6;            /* ALT_USB_GLOB_DIEPTXF6 */
    volatile ALT_USB_GLOB_DIEPTXF7_t   dieptxf7;            /* ALT_USB_GLOB_DIEPTXF7 */
    volatile ALT_USB_GLOB_DIEPTXF8_t   dieptxf8;            /* ALT_USB_GLOB_DIEPTXF8 */
    volatile ALT_USB_GLOB_DIEPTXF9_t   dieptxf9;            /* ALT_USB_GLOB_DIEPTXF9 */
    volatile ALT_USB_GLOB_DIEPTXF10_t  dieptxf10;           /* ALT_USB_GLOB_DIEPTXF10 */
    volatile ALT_USB_GLOB_DIEPTXF11_t  dieptxf11;           /* ALT_USB_GLOB_DIEPTXF11 */
    volatile ALT_USB_GLOB_DIEPTXF12_t  dieptxf12;           /* ALT_USB_GLOB_DIEPTXF12 */
    volatile ALT_USB_GLOB_DIEPTXF13_t  dieptxf13;           /* ALT_USB_GLOB_DIEPTXF13 */
    volatile ALT_USB_GLOB_DIEPTXF14_t  dieptxf14;           /* ALT_USB_GLOB_DIEPTXF14 */
    volatile ALT_USB_GLOB_DIEPTXF15_t  dieptxf15;           /* ALT_USB_GLOB_DIEPTXF15 */
};

/* The typedef declaration for register group ALT_USB_GLOB. */
typedef volatile struct ALT_USB_GLOB_s  ALT_USB_GLOB_t;
/* The struct declaration for the raw register contents of register group ALT_USB_GLOB. */
struct ALT_USB_GLOB_raw_s
{
    volatile uint32_t  gotgctl;             /* ALT_USB_GLOB_GOTGCTL */
    volatile uint32_t  gotgint;             /* ALT_USB_GLOB_GOTGINT */
    volatile uint32_t  gahbcfg;             /* ALT_USB_GLOB_GAHBCFG */
    volatile uint32_t  gusbcfg;             /* ALT_USB_GLOB_GUSBCFG */
    volatile uint32_t  grstctl;             /* ALT_USB_GLOB_GRSTCTL */
    volatile uint32_t  gintsts;             /* ALT_USB_GLOB_GINTSTS */
    volatile uint32_t  gintmsk;             /* ALT_USB_GLOB_GINTMSK */
    volatile uint32_t  grxstsr;             /* ALT_USB_GLOB_GRXSTSR */
    volatile uint32_t  grxstsp;             /* ALT_USB_GLOB_GRXSTSP */
    volatile uint32_t  grxfsiz;             /* ALT_USB_GLOB_GRXFSIZ */
    volatile uint32_t  gnptxfsiz;           /* ALT_USB_GLOB_GNPTXFSIZ */
    volatile uint32_t  gnptxsts;            /* ALT_USB_GLOB_GNPTXSTS */
    volatile uint32_t  _pad_0x30_0x33;      /* *UNDEFINED* */
    volatile uint32_t  gpvndctl;            /* ALT_USB_GLOB_GPVNDCTL */
    volatile uint32_t  ggpio;               /* ALT_USB_GLOB_GGPIO */
    volatile uint32_t  guid;                /* ALT_USB_GLOB_GUID */
    volatile uint32_t  gsnpsid;             /* ALT_USB_GLOB_GSNPSID */
    volatile uint32_t  ghwcfg1;             /* ALT_USB_GLOB_GHWCFG1 */
    volatile uint32_t  ghwcfg2;             /* ALT_USB_GLOB_GHWCFG2 */
    volatile uint32_t  ghwcfg3;             /* ALT_USB_GLOB_GHWCFG3 */
    volatile uint32_t  ghwcfg4;             /* ALT_USB_GLOB_GHWCFG4 */
    volatile uint32_t  _pad_0x54_0x5b[2];   /* *UNDEFINED* */
    volatile uint32_t  gdfifocfg;           /* ALT_USB_GLOB_GDFIFOCFG */
    volatile uint32_t  _pad_0x60_0xff[40];  /* *UNDEFINED* */
    volatile uint32_t  hptxfsiz;            /* ALT_USB_GLOB_HPTXFSIZ */
    volatile uint32_t  dieptxf1;            /* ALT_USB_GLOB_DIEPTXF1 */
    volatile uint32_t  dieptxf2;            /* ALT_USB_GLOB_DIEPTXF2 */
    volatile uint32_t  dieptxf3;            /* ALT_USB_GLOB_DIEPTXF3 */
    volatile uint32_t  dieptxf4;            /* ALT_USB_GLOB_DIEPTXF4 */
    volatile uint32_t  dieptxf5;            /* ALT_USB_GLOB_DIEPTXF5 */
    volatile uint32_t  dieptxf6;            /* ALT_USB_GLOB_DIEPTXF6 */
    volatile uint32_t  dieptxf7;            /* ALT_USB_GLOB_DIEPTXF7 */
    volatile uint32_t  dieptxf8;            /* ALT_USB_GLOB_DIEPTXF8 */
    volatile uint32_t  dieptxf9;            /* ALT_USB_GLOB_DIEPTXF9 */
    volatile uint32_t  dieptxf10;           /* ALT_USB_GLOB_DIEPTXF10 */
    volatile uint32_t  dieptxf11;           /* ALT_USB_GLOB_DIEPTXF11 */
    volatile uint32_t  dieptxf12;           /* ALT_USB_GLOB_DIEPTXF12 */
    volatile uint32_t  dieptxf13;           /* ALT_USB_GLOB_DIEPTXF13 */
    volatile uint32_t  dieptxf14;           /* ALT_USB_GLOB_DIEPTXF14 */
    volatile uint32_t  dieptxf15;           /* ALT_USB_GLOB_DIEPTXF15 */
};

/* The typedef declaration for the raw register contents of register group ALT_USB_GLOB. */
typedef volatile struct ALT_USB_GLOB_raw_s  ALT_USB_GLOB_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Host Mode Registers - ALT_USB_HOST
 * Host Mode Registers
 * 
 * These registers must be programmed every time the USB OTG Controller changes to
 * Host mode.
 * 
 */
/*
 * Register : Host Configuration Register - hcfg
 * 
 * Host Mode control. This register must be programmed every time the core changes
 * to Host mode
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                           
 * :--------|:-------|:------|:---------------------------------------
 *  [1:0]   | RW     | 0x0   | FS LS PHY Clock Select                
 *  [2]     | RW     | 0x0   | FS- and LS-Only Suppor                
 *  [6:3]   | ???    | 0x0   | *UNDEFINED*                           
 *  [7]     | RW     | 0x0   | Enable 32 KHz Suspend mode            
 *  [15:8]  | RW     | 0x2   | Resume Validation Period              
 *  [22:16] | ???    | 0x0   | *UNDEFINED*                           
 *  [23]    | RW     | 0x0   | Enable Scatter Gather DMA in Host mode
 *  [25:24] | RW     | 0x0   | Frame List Entries                    
 *  [26]    | RW     | 0x0   | Enable Periodic Scheduling            
 *  [30:27] | ???    | 0x0   | *UNDEFINED*                           
 *  [31]    | RW     | 0x0   | Mode Change Ready Timer Enable        
 * 
 */
/*
 * Field : FS LS PHY Clock Select - fslspclksel
 * 
 * When the core is in FS Host mode. The internal PHY clock is running at 30/60 MHZ
 * for ULPI PHY Interfaces. The internal PHY clock is running at 48MHZ for 1.1 FS
 * transceiver Interface When the core is in LS Host mode, the internal PHY clock
 * is running at 30/60 MHZ for ULPI PHY Interfaces. The internal PHY clock is
 * running at 6 MHZ and the external clock is running at 48MHZ. When you select a 6
 * MHz clock during LS Mode, you must do a soft reset for 1.1 FS transceiver
 * Interface. * When Core in FS mode, the internal and external clocks have the
 * same frequency.
 * 
 * * When Core in LS mode,
 * 
 *     - If fslspclksel is 30/60 Mhz internal and external clocks have the same
 *       frequency.
 * 
 *     - If fslspclksel is 6Mhz the internal clock is divided by eight of external
 *       48 MHz clock (utmifs_clk).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                      
 * :----------------------------------------|:------|:----------------------------------
 *  ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK3060 | 0x0   | PHY clock is running at 30/60 MHz
 *  ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK48   | 0x1   | PHY clock is running at 48 MHz   
 *  ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK6    | 0x2   | PHY clock is running at 6 MHz    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSPCLKSEL
 * 
 * PHY clock is running at 30/60 MHz
 */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK3060 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSPCLKSEL
 * 
 * PHY clock is running at 48 MHz
 */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK48   0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSPCLKSEL
 * 
 * PHY clock is running at 6 MHz
 */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_E_CLK6    0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_MSB        1
/* The width in bits of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field value. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field value. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_USB_HOST_HCFG_FSLSPCLKSEL register field. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_FSLSPCLKSEL field value from a register. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_USB_HOST_HCFG_FSLSPCLKSEL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_FSLSPCLKSEL_SET(value) (((value) << 0) & 0x00000003)

/*
 * Field : FS- and LS-Only Suppor - fslssupp
 * 
 * The application uses this bit to control the core's enumeration speed. Using
 * this bit, the application can make the core enumerate as a FS host, even If the
 * connected device supports HS traffic. Do not make changes to this field after
 * initial programming.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                   
 * :------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCFG_FSLSSUPP_E_HSFSLS | 0x0   | HS/FS/LS, based on the maximum speed supported
 * :                                    |       | by the connected device                       
 *  ALT_USB_HOST_HCFG_FSLSSUPP_E_FSLS   | 0x1   | FS/LS-only, even if the connected device can  
 * :                                    |       | support HS                                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSSUPP
 * 
 * HS/FS/LS, based on the maximum speed supported by the connected device
 */
#define ALT_USB_HOST_HCFG_FSLSSUPP_E_HSFSLS 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FSLSSUPP
 * 
 * FS/LS-only, even if the connected device can support HS
 */
#define ALT_USB_HOST_HCFG_FSLSSUPP_E_FSLS   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_MSB        2
/* The width in bits of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_FSLSSUPP register field value. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCFG_FSLSSUPP register field value. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCFG_FSLSSUPP register field. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_FSLSSUPP field value from a register. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCFG_FSLSSUPP register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_FSLSSUPP_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Enable 32 KHz Suspend mode - ena32khzs
 * 
 * This bit can only be set if the USB 1.1 Full-Speed Serial Transceiver Interface
 * has been selected. If USB 1.1 Full-Speed Serial Transceiver Interface has not
 * been selected, this bit must be zero. When the USB 1.1 Full-Speed Serial
 * Transceiver Interface is chosen and this bit is set, the core expects the 48-MHz
 * PHY clock to be switched to 32 KHz during a suspend.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                    
 * :-----------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCFG_ENA32KHZS_E_DISD | 0x0   | USB 1.1 Full-Speed Not Selected                
 *  ALT_USB_HOST_HCFG_ENA32KHZS_E_END  | 0x1   | USB 1.1 Full-Speed Serial Transceiver Interface
 * :                                   |       | selected                                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_ENA32KHZS
 * 
 * USB 1.1 Full-Speed Not Selected
 */
#define ALT_USB_HOST_HCFG_ENA32KHZS_E_DISD  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_ENA32KHZS
 * 
 * USB 1.1 Full-Speed Serial Transceiver Interface selected
 */
#define ALT_USB_HOST_HCFG_ENA32KHZS_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_MSB        7
/* The width in bits of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_ENA32KHZS register field value. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCFG_ENA32KHZS register field value. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCFG_ENA32KHZS register field. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_ENA32KHZS field value from a register. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCFG_ENA32KHZS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_ENA32KHZS_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Resume Validation Period - resvalid
 * 
 * This field is effective only when HCFG.Ena32KHzS is set. It will control the
 * resume period when the core resumes from suspend. The core counts for ResValid
 * number of clock cycles to detect a valid resume when this is set.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_MSB        15
/* The width in bits of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_WIDTH      8
/* The mask used to set the ALT_USB_HOST_HCFG_RESVALID register field value. */
#define ALT_USB_HOST_HCFG_RESVALID_SET_MSK    0x0000ff00
/* The mask used to clear the ALT_USB_HOST_HCFG_RESVALID register field value. */
#define ALT_USB_HOST_HCFG_RESVALID_CLR_MSK    0xffff00ff
/* The reset value of the ALT_USB_HOST_HCFG_RESVALID register field. */
#define ALT_USB_HOST_HCFG_RESVALID_RESET      0x2
/* Extracts the ALT_USB_HOST_HCFG_RESVALID field value from a register. */
#define ALT_USB_HOST_HCFG_RESVALID_GET(value) (((value) & 0x0000ff00) >> 8)
/* Produces a ALT_USB_HOST_HCFG_RESVALID register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_RESVALID_SET(value) (((value) << 8) & 0x0000ff00)

/*
 * Field : Enable Scatter Gather DMA in Host mode - descdma
 * 
 * The application can set this bit during initialization to enable the
 * Scatter/Gather DMA operation. This bit must be modified only once after a reset.
 * The following combinations are available for programming:
 * 
 * GAHBCFG.DMAEn=0,HCFG.DescDMA=0 => Slave mode GAHBCFG.DMAEn=0,HCFG.DescDMA=1 =>
 * InvalidGAHBCFG.DMAEn=1,HCFG.DescDMA=0 => Buffered DMA mode
 * GAHBCFG.DMAEn=1,HCFG.DescDMA=1 => Scatter/Gather DMA mode
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                
 * :---------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HCFG_DESCDMA_E_DISD | 0x0   | No Scatter/Gather DMA      
 *  ALT_USB_HOST_HCFG_DESCDMA_E_END  | 0x1   | Scatter/Gather DMA selected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_DESCDMA
 * 
 * No Scatter/Gather DMA
 */
#define ALT_USB_HOST_HCFG_DESCDMA_E_DISD    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_DESCDMA
 * 
 * Scatter/Gather DMA selected
 */
#define ALT_USB_HOST_HCFG_DESCDMA_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_LSB        23
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_MSB        23
/* The width in bits of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_DESCDMA register field value. */
#define ALT_USB_HOST_HCFG_DESCDMA_SET_MSK    0x00800000
/* The mask used to clear the ALT_USB_HOST_HCFG_DESCDMA register field value. */
#define ALT_USB_HOST_HCFG_DESCDMA_CLR_MSK    0xff7fffff
/* The reset value of the ALT_USB_HOST_HCFG_DESCDMA register field. */
#define ALT_USB_HOST_HCFG_DESCDMA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_DESCDMA field value from a register. */
#define ALT_USB_HOST_HCFG_DESCDMA_GET(value) (((value) & 0x00800000) >> 23)
/* Produces a ALT_USB_HOST_HCFG_DESCDMA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_DESCDMA_SET(value) (((value) << 23) & 0x00800000)

/*
 * Field : Frame List Entries - frlisten
 * 
 * The value in the register specifies the number of entries in the Frame list.
 * This field is valid only in Scatter/Gather DMA mode.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_RSVD    | 0x0   | Reserved   
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY8  | 0x1   | 8  Entries 
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY16 | 0x2   | 16 Entries 
 *  ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY32 | 0x3   | 32 Entries 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * Reserved
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_RSVD       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * 8  Entries
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY8     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * 16 Entries
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY16    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_FRLISTEN
 * 
 * 32 Entries
 */
#define ALT_USB_HOST_HCFG_FRLISTEN_E_ENTRY32    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_MSB        25
/* The width in bits of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCFG_FRLISTEN register field value. */
#define ALT_USB_HOST_HCFG_FRLISTEN_SET_MSK    0x03000000
/* The mask used to clear the ALT_USB_HOST_HCFG_FRLISTEN register field value. */
#define ALT_USB_HOST_HCFG_FRLISTEN_CLR_MSK    0xfcffffff
/* The reset value of the ALT_USB_HOST_HCFG_FRLISTEN register field. */
#define ALT_USB_HOST_HCFG_FRLISTEN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_FRLISTEN field value from a register. */
#define ALT_USB_HOST_HCFG_FRLISTEN_GET(value) (((value) & 0x03000000) >> 24)
/* Produces a ALT_USB_HOST_HCFG_FRLISTEN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_FRLISTEN_SET(value) (((value) << 24) & 0x03000000)

/*
 * Field : Enable Periodic Scheduling - perschedena
 * 
 * Applicable in Scatter/Gather DMA mode only. Enables periodic scheduling within
 * the core. Initially, the bit is reset. The core will not process any periodic
 * channels. As soon as this bit is set, the core will get ready to start
 * scheduling periodic channels. In non Scatter/Gather DMA mode, this bit is
 * reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                 
 * :-------------------------------------|:------|:---------------------------------------------
 *  ALT_USB_HOST_HCFG_PERSCHEDENA_E_DISD | 0x0   | Disables periodic scheduling within the core
 *  ALT_USB_HOST_HCFG_PERSCHEDENA_E_END  | 0x1   | Enables periodic scheduling within the core 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_PERSCHEDENA
 * 
 * Disables periodic scheduling within the core
 */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_E_DISD    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_PERSCHEDENA
 * 
 * Enables periodic scheduling within the core
 */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_E_END     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_LSB        26
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_MSB        26
/* The width in bits of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_PERSCHEDENA register field value. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_SET_MSK    0x04000000
/* The mask used to clear the ALT_USB_HOST_HCFG_PERSCHEDENA register field value. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_CLR_MSK    0xfbffffff
/* The reset value of the ALT_USB_HOST_HCFG_PERSCHEDENA register field. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_PERSCHEDENA field value from a register. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_GET(value) (((value) & 0x04000000) >> 26)
/* Produces a ALT_USB_HOST_HCFG_PERSCHEDENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_PERSCHEDENA_SET(value) (((value) << 26) & 0x04000000)

/*
 * Field : Mode Change Ready Timer Enable - modechtimen
 * 
 * This bit is used to enable or disable the host core to wait for 200 PHY clock
 * cycles at the end of Resume to change the opmode signal to the PHY to 00 after
 * Suspend or LPM.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                    
 * :------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCFG_MODCHTIMEN_E_END  | 0x0   | The Host core waits for either 200 PHY clock   
 * :                                    |       | cycles or a linestate of SE0 at the end of     
 * :                                    |       | resume to change the opmode from 0x2 to 0x0    
 *  ALT_USB_HOST_HCFG_MODCHTIMEN_E_DISD | 0x1   | The Host core waits only for a linestate of SE0
 * :                                    |       | at the end of resume to change the opmode from 
 * :                                    |       | 0x2 to 0x0                                     
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_MODCHTIMEN
 * 
 * The Host core waits for either 200 PHY clock cycles or a linestate of SE0 at the
 * end of resume to change the opmode from 0x2 to 0x0
 */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_E_END  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCFG_MODCHTIMEN
 * 
 * The Host core waits only for a linestate of SE0 at the end of resume to change
 * the opmode from 0x2 to 0x0
 */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_E_DISD 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_MSB        31
/* The width in bits of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCFG_MODCHTIMEN register field value. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCFG_MODCHTIMEN register field value. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCFG_MODCHTIMEN register field. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCFG_MODCHTIMEN field value from a register. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCFG_MODCHTIMEN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCFG_MODCHTIMEN_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCFG.
 */
struct ALT_USB_HOST_HCFG_s
{
    uint32_t  fslspclksel :  2;  /* FS LS PHY Clock Select */
    uint32_t  fslssupp    :  1;  /* FS- and LS-Only Suppor */
    uint32_t              :  4;  /* *UNDEFINED* */
    uint32_t  ena32khzs   :  1;  /* Enable 32 KHz Suspend mode */
    uint32_t  resvalid    :  8;  /* Resume Validation Period */
    uint32_t              :  7;  /* *UNDEFINED* */
    uint32_t  descdma     :  1;  /* Enable Scatter Gather DMA in Host mode */
    uint32_t  frlisten    :  2;  /* Frame List Entries */
    uint32_t  perschedena :  1;  /* Enable Periodic Scheduling */
    uint32_t              :  4;  /* *UNDEFINED* */
    uint32_t  modechtimen :  1;  /* Mode Change Ready Timer Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCFG. */
typedef volatile struct ALT_USB_HOST_HCFG_s  ALT_USB_HOST_HCFG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCFG register from the beginning of the component. */
#define ALT_USB_HOST_HCFG_OFST        0x0
/* The address of the ALT_USB_HOST_HCFG register. */
#define ALT_USB_HOST_HCFG_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCFG_OFST))

/*
 * Register : Host Frame Interval Register - hfir
 * 
 * This register stores the frame interval information for the current speed to
 * which the otg core has enumerated
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description   
 * :--------|:-------|:-------|:---------------
 *  [15:0]  | RW     | 0xea60 | Frame IntervaL
 *  [16]    | RW     | 0x0    | Reload Control
 *  [31:17] | ???    | 0x0    | *UNDEFINED*   
 * 
 */
/*
 * Field : Frame IntervaL - frint
 * 
 * The value that the application programs to this field specifies the interval
 * between two consecutive SOFs (FS) or micro- SOFs (HS) or Keep-Alive tokens (HS).
 * This field contains the number of PHY clocks that constitute the required frame
 * interval. The Default value Set in this field for a FS operation when the PHY
 * clock frequency is 60 MHz. The application can write a value to this register
 * only after the Port Enable bit of the Host Port Control and Status register
 * (HPRT.PrtEnaPort) has been Set. If no value is programmed, the core calculates
 * the value based on the PHY clock specified in the FS/LS PHY Clock Select field
 * of the Host Configuration register (HCFG.FSLSPclkSel). Do not change the value
 * of this field after the initial configuration.
 * 
 * 125 s * (PHY clock frequency for HS)
 * 
 * 1 ms * (PHY clock frequency for FS/LS)
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_MSB        15
/* The width in bits of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HFIR_FRINT register field value. */
#define ALT_USB_HOST_HFIR_FRINT_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HFIR_FRINT register field value. */
#define ALT_USB_HOST_HFIR_FRINT_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HFIR_FRINT register field. */
#define ALT_USB_HOST_HFIR_FRINT_RESET      0xea60
/* Extracts the ALT_USB_HOST_HFIR_FRINT field value from a register. */
#define ALT_USB_HOST_HFIR_FRINT_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HFIR_FRINT register field value suitable for setting the register. */
#define ALT_USB_HOST_HFIR_FRINT_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Reload Control - hfirrldctrl
 * 
 * This bit allows dynamic reloading of the HFIR register during run time. 0x0 :
 * The HFIR cannot be reloaded dynamically0x1: the HFIR can be dynamically reloaded
 * during runtime. This bit needs to be programmed during initial configuration and
 * its value should not be changed during runtime.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                
 * :------------------------------------|:------|:--------------------------------------------
 *  ALT_USB_HOST_HFIR_HFIRRLDCTL_E_DISD | 0x0   | The HFIR cannot be reloaded dynamically    
 *  ALT_USB_HOST_HFIR_HFIRRLDCTL_E_END  | 0x1   | The HFIR can be dynamically reloaded during
 * :                                    |       | runtime                                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HFIR_HFIRRLDCTL
 * 
 * The HFIR cannot be reloaded dynamically
 */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HFIR_HFIRRLDCTL
 * 
 * The HFIR can be dynamically reloaded during runtime
 */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_MSB        16
/* The width in bits of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HFIR_HFIRRLDCTL register field value. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HFIR_HFIRRLDCTL register field value. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HFIR_HFIRRLDCTL register field. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_RESET      0x0
/* Extracts the ALT_USB_HOST_HFIR_HFIRRLDCTL field value from a register. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HFIR_HFIRRLDCTL register field value suitable for setting the register. */
#define ALT_USB_HOST_HFIR_HFIRRLDCTL_SET(value) (((value) << 16) & 0x00010000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HFIR.
 */
struct ALT_USB_HOST_HFIR_s
{
    uint32_t  frint       : 16;  /* Frame IntervaL */
    uint32_t  hfirrldctrl :  1;  /* Reload Control */
    uint32_t              : 15;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HFIR. */
typedef volatile struct ALT_USB_HOST_HFIR_s  ALT_USB_HOST_HFIR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HFIR register from the beginning of the component. */
#define ALT_USB_HOST_HFIR_OFST        0x4
/* The address of the ALT_USB_HOST_HFIR register. */
#define ALT_USB_HOST_HFIR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HFIR_OFST))

/*
 * Register : Host Frame Number Frame Time Remaining Register - hfnum
 * 
 * This register contains the free space information for the Periodic TxFIFO and
 * the Periodic Transmit Request Queue
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description         
 * :--------|:-------|:-------|:---------------------
 *  [15:0]  | R      | 0x3fff | Frame Number        
 *  [31:16] | R      | 0x0    | Frame Time Remaining
 * 
 */
/*
 * Field : Frame Number - frnum
 * 
 * This field increments when a new SOF is transmitted on the USB, and is reset to
 * 0 when it reaches 0x3FFF. Reads Return the Frame number value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description          
 * :---------------------------------|:------|:----------------------
 *  ALT_USB_HOST_HFNUM_FRNUM_E_INACT | 0x0   | No SOF is transmitted
 *  ALT_USB_HOST_HFNUM_FRNUM_E_ACT   | 0x1   | SOF is transmitted   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HFNUM_FRNUM
 * 
 * No SOF is transmitted
 */
#define ALT_USB_HOST_HFNUM_FRNUM_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HFNUM_FRNUM
 * 
 * SOF is transmitted
 */
#define ALT_USB_HOST_HFNUM_FRNUM_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_MSB        15
/* The width in bits of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HFNUM_FRNUM register field value. */
#define ALT_USB_HOST_HFNUM_FRNUM_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HFNUM_FRNUM register field value. */
#define ALT_USB_HOST_HFNUM_FRNUM_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HFNUM_FRNUM register field. */
#define ALT_USB_HOST_HFNUM_FRNUM_RESET      0x3fff
/* Extracts the ALT_USB_HOST_HFNUM_FRNUM field value from a register. */
#define ALT_USB_HOST_HFNUM_FRNUM_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HFNUM_FRNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HFNUM_FRNUM_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Frame Time Remaining - frrem
 * 
 * Indicates the amount of time remaining in the current microframe (HS) or Frame
 * (FS/LS), in terms of PHY clocks. This field decrements on each PHY clock. When
 * it reaches zero, this field is reloaded with the value in the Frame Interval
 * register and a new SOF is transmitted on the USB.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_MSB        31
/* The width in bits of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HFNUM_FRREM register field value. */
#define ALT_USB_HOST_HFNUM_FRREM_SET_MSK    0xffff0000
/* The mask used to clear the ALT_USB_HOST_HFNUM_FRREM register field value. */
#define ALT_USB_HOST_HFNUM_FRREM_CLR_MSK    0x0000ffff
/* The reset value of the ALT_USB_HOST_HFNUM_FRREM register field. */
#define ALT_USB_HOST_HFNUM_FRREM_RESET      0x0
/* Extracts the ALT_USB_HOST_HFNUM_FRREM field value from a register. */
#define ALT_USB_HOST_HFNUM_FRREM_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_USB_HOST_HFNUM_FRREM register field value suitable for setting the register. */
#define ALT_USB_HOST_HFNUM_FRREM_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HFNUM.
 */
struct ALT_USB_HOST_HFNUM_s
{
    const uint32_t  frnum : 16;  /* Frame Number */
    const uint32_t  frrem : 16;  /* Frame Time Remaining */
};

/* The typedef declaration for register ALT_USB_HOST_HFNUM. */
typedef volatile struct ALT_USB_HOST_HFNUM_s  ALT_USB_HOST_HFNUM_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HFNUM register from the beginning of the component. */
#define ALT_USB_HOST_HFNUM_OFST        0x8
/* The address of the ALT_USB_HOST_HFNUM register. */
#define ALT_USB_HOST_HFNUM_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HFNUM_OFST))

/*
 * Register : Host Periodic Transmit FIFO Queue Status Register - hptxsts
 * 
 * This register contains the free space information for the Periodic TxFIFO and
 * the Periodic Transmit Request Queue.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset  | Description                                    
 * :--------|:-------|:-------|:------------------------------------------------
 *  [15:0]  | R      | 0x2000 | Periodic Transmit Data FIFO Space Available    
 *  [23:16] | R      | 0x10   | Periodic Transmit Request Queue Space Available
 *  [24]    | R      | 0x0    | Terminate                                      
 *  [26:25] | R      | 0x0    | Type                                           
 *  [30:27] | R      | 0x0    | Channel Endpoint Number                        
 *  [31]    | R      | 0x0    | Odd Even Micro Frame                           
 * 
 */
/*
 * Field : Periodic Transmit Data FIFO Space Available - ptxfspcavail
 * 
 * Indicates the number of free locations available to be written to in the
 * Periodic TxFIFO. Values are in terms of 32-bit words
 * 
 * 16h0: Periodic TxFIFO is full
 * 
 * 16h1: 1 word available
 * 
 * 16h2: 2 words available
 * 
 * 16hn: n words available where n is 0 to 8192
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_MSB        15
/* The width in bits of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_RESET      0x2000
/* Extracts the ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL field value from a register. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_PTXFSPCAVAIL_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Periodic Transmit Request Queue Space Available - ptxqspcavail
 * 
 * Indicates the number of free locations available to be written in the Periodic
 * Transmit Request Queue. This queue holds both IN and OUT requests. Others:
 * Reserved
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                            
 * :------------------------------------------|:------|:----------------------------------------
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FULL  | 0x0   | Periodic Transmit Request Queue is full
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE1 | 0x1   | 1 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE2 | 0x2   | 2 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE3 | 0x3   | 3 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE4 | 0x4   | 4 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE5 | 0x5   | 5 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE6 | 0x6   | 6 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE7 | 0x7   | 7 location available                   
 *  ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE8 | 0x8   | 8 location available                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * Periodic Transmit Request Queue is full
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FULL    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 1 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE1   0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 2 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE2   0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 3 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE3   0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 4 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE4   0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 5 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE5   0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 6 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE6   0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 7 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE7   0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL
 * 
 * 8 location available
 */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_E_FREE8   0x8

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_MSB        23
/* The width in bits of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_WIDTH      8
/* The mask used to set the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_SET_MSK    0x00ff0000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field value. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_CLR_MSK    0xff00ffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_RESET      0x10
/* Extracts the ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL field value from a register. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_GET(value) (((value) & 0x00ff0000) >> 16)
/* Produces a ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_PTXQSPCAVAIL_SET(value) (((value) << 16) & 0x00ff0000)

/*
 * Field : Terminate - term
 * 
 * Terminate last entry for selected channel/endpoint.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description                      
 * :----------------------------------|:------|:----------------------------------
 *  ALT_USB_HOST_HPTXSTS_TERM_E_INACT | 0x0   | No termination                   
 *  ALT_USB_HOST_HPTXSTS_TERM_E_ACT   | 0x1   | Terminate last entry for selected
 * :                                  |       | channel/endpoint                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TERM
 * 
 * No termination
 */
#define ALT_USB_HOST_HPTXSTS_TERM_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TERM
 * 
 * Terminate last entry for selected channel/endpoint
 */
#define ALT_USB_HOST_HPTXSTS_TERM_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_LSB        24
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_MSB        24
/* The width in bits of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPTXSTS_TERM register field value. */
#define ALT_USB_HOST_HPTXSTS_TERM_SET_MSK    0x01000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_TERM register field value. */
#define ALT_USB_HOST_HPTXSTS_TERM_CLR_MSK    0xfeffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_TERM register field. */
#define ALT_USB_HOST_HPTXSTS_TERM_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_TERM field value from a register. */
#define ALT_USB_HOST_HPTXSTS_TERM_GET(value) (((value) & 0x01000000) >> 24)
/* Produces a ALT_USB_HOST_HPTXSTS_TERM register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_TERM_SET(value) (((value) << 24) & 0x01000000)

/*
 * Field : Type - type
 * 
 * This indicates the Entry in the Periodic Tx Request Queue that is currently
 * being processes by the MAC.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description            
 * :--------------------------------------|:------|:------------------------
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_INOUT     | 0x0   | IN/OUT type            
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_ZEROLNGTH | 0x1   | Zero-length packet type
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_CSPLIT    | 0x2   | CSPLIT type            
 *  ALT_USB_HOST_HPTXSTS_TYPE_E_DIS       | 0x3   | Disable channel command
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * IN/OUT type
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_INOUT       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * Zero-length packet type
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_ZEROLNGTH   0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * CSPLIT type
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_CSPLIT      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_TYPE
 * 
 * Disable channel command
 */
#define ALT_USB_HOST_HPTXSTS_TYPE_E_DIS         0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_LSB        25
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_MSB        26
/* The width in bits of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HPTXSTS_TYPE register field value. */
#define ALT_USB_HOST_HPTXSTS_TYPE_SET_MSK    0x06000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_TYPE register field value. */
#define ALT_USB_HOST_HPTXSTS_TYPE_CLR_MSK    0xf9ffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_TYPE register field. */
#define ALT_USB_HOST_HPTXSTS_TYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_TYPE field value from a register. */
#define ALT_USB_HOST_HPTXSTS_TYPE_GET(value) (((value) & 0x06000000) >> 25)
/* Produces a ALT_USB_HOST_HPTXSTS_TYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_TYPE_SET(value) (((value) << 25) & 0x06000000)

/*
 * Field : Channel Endpoint Number - chanendpt
 * 
 * This indicates the channel endpoint number that is currently being processes by
 * the MAC.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description  
 * :-----------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT0  | 0x0   | End point  1 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT1  | 0x1   | End point  2 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT2  | 0x2   | End point  3 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT3  | 0x3   | End point  4 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT4  | 0x4   | End point  5 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT5  | 0x5   | End point  6 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT6  | 0x6   | End point  7 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT7  | 0x7   | End point  8 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT8  | 0x8   | End point  9 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT9  | 0x9   | End point  10
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT10 | 0xa   | End point 11 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT11 | 0xb   | End point 12 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT12 | 0xc   | End point 13 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT13 | 0xd   | End point 14 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT14 | 0xe   | End point 15 
 *  ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT15 | 0xf   | End point 16 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  1
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  2
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  3
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  4
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  5
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  6
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  7
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  8
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  9
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point  10
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 11
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 12
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 13
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 14
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 15
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_CHANENDPT
 * 
 * End point 16
 */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_LSB        27
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_MSB        30
/* The width in bits of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HPTXSTS_CHANENDPT register field value. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_SET_MSK    0x78000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_CHANENDPT register field value. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_CLR_MSK    0x87ffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_CHANENDPT register field. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_CHANENDPT field value from a register. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_GET(value) (((value) & 0x78000000) >> 27)
/* Produces a ALT_USB_HOST_HPTXSTS_CHANENDPT register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_CHANENDPT_SET(value) (((value) << 27) & 0x78000000)

/*
 * Field : Odd Even Micro Frame - oddevnmframe
 * 
 * This indicates the odd/even micro frame that is currently being processes by the
 * MAC.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description              
 * :---------------------------------------|:------|:--------------------------
 *  ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_EVEN | 0x0   | Send in even (micro)Frame
 *  ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_ODD  | 0x1   | Send in odd (micro)Frame 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_ODDEVNMFRM
 * 
 * Send in even (micro)Frame
 */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_EVEN  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPTXSTS_ODDEVNMFRM
 * 
 * Send in odd (micro)Frame
 */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_E_ODD   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_MSB        31
/* The width in bits of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field value. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field value. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_RESET      0x0
/* Extracts the ALT_USB_HOST_HPTXSTS_ODDEVNMFRM field value from a register. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HPTXSTS_ODDEVNMFRM register field value suitable for setting the register. */
#define ALT_USB_HOST_HPTXSTS_ODDEVNMFRM_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HPTXSTS.
 */
struct ALT_USB_HOST_HPTXSTS_s
{
    const uint32_t  ptxfspcavail : 16;  /* Periodic Transmit Data FIFO Space Available */
    const uint32_t  ptxqspcavail :  8;  /* Periodic Transmit Request Queue Space Available */
    const uint32_t  term         :  1;  /* Terminate */
    const uint32_t  type         :  2;  /* Type */
    const uint32_t  chanendpt    :  4;  /* Channel Endpoint Number */
    const uint32_t  oddevnmframe :  1;  /* Odd Even Micro Frame */
};

/* The typedef declaration for register ALT_USB_HOST_HPTXSTS. */
typedef volatile struct ALT_USB_HOST_HPTXSTS_s  ALT_USB_HOST_HPTXSTS_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HPTXSTS register from the beginning of the component. */
#define ALT_USB_HOST_HPTXSTS_OFST        0x10
/* The address of the ALT_USB_HOST_HPTXSTS register. */
#define ALT_USB_HOST_HPTXSTS_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HPTXSTS_OFST))

/*
 * Register : Host All Channels Interrupt Register - haint
 * 
 * When a significant event occurs on a channel, the Host All Channels Interrupt
 * register interrupts the application using the Host Channels Interrupt bit of the
 * Core Interrupt register (GINTSTS.HChInt). There is one interrupt bit per
 * channel, up to a maximum of 16 bits. Bits in this register are set and cleared
 * when the application sets and clears bits in the corresponding Host Channel-n
 * Interrupt register.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description       
 * :--------|:-------|:------|:-------------------
 *  [15:0]  | R      | 0x0   | Channel Interrupts
 *  [31:16] | ???    | 0x0   | *UNDEFINED*       
 * 
 */
/*
 * Field : Channel Interrupts - haint
 * 
 * One bit per channel: Bit 0 for Channel 0, bit 15 for Channel 15
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_MSB        15
/* The width in bits of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HAINT_HAINT register field value. */
#define ALT_USB_HOST_HAINT_HAINT_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HAINT_HAINT register field value. */
#define ALT_USB_HOST_HAINT_HAINT_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HAINT_HAINT register field. */
#define ALT_USB_HOST_HAINT_HAINT_RESET      0x0
/* Extracts the ALT_USB_HOST_HAINT_HAINT field value from a register. */
#define ALT_USB_HOST_HAINT_HAINT_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HAINT_HAINT register field value suitable for setting the register. */
#define ALT_USB_HOST_HAINT_HAINT_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HAINT.
 */
struct ALT_USB_HOST_HAINT_s
{
    const uint32_t  haint : 16;  /* Channel Interrupts */
    uint32_t              : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HAINT. */
typedef volatile struct ALT_USB_HOST_HAINT_s  ALT_USB_HOST_HAINT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HAINT register from the beginning of the component. */
#define ALT_USB_HOST_HAINT_OFST        0x14
/* The address of the ALT_USB_HOST_HAINT register. */
#define ALT_USB_HOST_HAINT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HAINT_OFST))

/*
 * Register : Host All Channels Interrupt Mask Register - haintmsk
 * 
 * The Host All Channel Interrupt Mask register works with the Host All Channel
 * Interrupt register to interrupt the application when an event occurs on a
 * channel. There is one interrupt mask bit per channel, up to a maximum of 16
 * bits.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description           
 * :--------|:-------|:------|:-----------------------
 *  [15:0]  | RW     | 0x0   | Channel Interrupt Mask
 *  [31:16] | ???    | 0x0   | *UNDEFINED*           
 * 
 */
/*
 * Field : Channel Interrupt Mask - haintmsk
 * 
 * One bit per channel: Bit 0 for channel 0, bit 15 for channel 15
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description     
 * :---------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HAINTMSK_HAINTMSK_E_MSK   | 0x0   | Mask interrupt  
 *  ALT_USB_HOST_HAINTMSK_HAINTMSK_E_NOMSK | 0x1   | Unmask interrupt
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HAINTMSK_HAINTMSK
 * 
 * Mask interrupt
 */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HAINTMSK_HAINTMSK
 * 
 * Unmask interrupt
 */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_MSB        15
/* The width in bits of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_WIDTH      16
/* The mask used to set the ALT_USB_HOST_HAINTMSK_HAINTMSK register field value. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_USB_HOST_HAINTMSK_HAINTMSK register field value. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_CLR_MSK    0xffff0000
/* The reset value of the ALT_USB_HOST_HAINTMSK_HAINTMSK register field. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HAINTMSK_HAINTMSK field value from a register. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_USB_HOST_HAINTMSK_HAINTMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HAINTMSK_HAINTMSK_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HAINTMSK.
 */
struct ALT_USB_HOST_HAINTMSK_s
{
    uint32_t  haintmsk : 16;  /* Channel Interrupt Mask */
    uint32_t           : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HAINTMSK. */
typedef volatile struct ALT_USB_HOST_HAINTMSK_s  ALT_USB_HOST_HAINTMSK_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HAINTMSK register from the beginning of the component. */
#define ALT_USB_HOST_HAINTMSK_OFST        0x18
/* The address of the ALT_USB_HOST_HAINTMSK register. */
#define ALT_USB_HOST_HAINTMSK_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HAINTMSK_OFST))

/*
 * Register : Host Frame List Base Address Register - hflbaddr
 * 
 * This Register is valid only for Host mode Scatter-Gather DMA. Starting address
 * of the Frame list. This register is used only for Isochronous and Interrupt
 * Channels.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [31:0] | RW     | 0x0   | ALT_USB_HOST_HFLBADDR_HFLBADDR
 * 
 */
/*
 * Field : hflbaddr
 * 
 * This Register is valid only for Host mode Scatter-Gather DMA  mode. Starting
 * address of the Frame list. This register is used only for Isochronous and
 * Interrupt Channels.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_MSB        31
/* The width in bits of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HFLBADDR_HFLBADDR register field value. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HFLBADDR_HFLBADDR register field value. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HFLBADDR_HFLBADDR register field. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HFLBADDR_HFLBADDR field value from a register. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HFLBADDR_HFLBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HFLBADDR_HFLBADDR_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HFLBADDR.
 */
struct ALT_USB_HOST_HFLBADDR_s
{
    uint32_t  hflbaddr : 32;  /* ALT_USB_HOST_HFLBADDR_HFLBADDR */
};

/* The typedef declaration for register ALT_USB_HOST_HFLBADDR. */
typedef volatile struct ALT_USB_HOST_HFLBADDR_s  ALT_USB_HOST_HFLBADDR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HFLBADDR register from the beginning of the component. */
#define ALT_USB_HOST_HFLBADDR_OFST        0x1c
/* The address of the ALT_USB_HOST_HFLBADDR register. */
#define ALT_USB_HOST_HFLBADDR_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HFLBADDR_OFST))

/*
 * Register : Host Port Control and Status Register - hprt
 * 
 * This register is available only in Host mode. Currently, the OTG Host supports
 * only one port. A single register holds USB port-related information such as USB
 * reset, enable, suspend, resume, connect status, and test mode for each port.The
 * R_SS_WC bits in this register can trigger an interrupt to the application
 * through the Host Port Interrupt bit of the Core Interrupt register
 * (GINTSTS.PrtInt). On a Port Interrupt, the application must read this register
 * and clear the bit that caused the interrupt. for the R_SS_WC bits, the
 * application must write a 1 to the bit to clear the interrupt
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description               
 * :--------|:-------|:------|:---------------------------
 *  [0]     | R      | 0x0   | Port Connect Status       
 *  [1]     | R      | 0x0   | Port Connect Detected     
 *  [2]     | R      | 0x0   | Port Enabl                
 *  [3]     | R      | 0x0   | Port Enable Disable Change
 *  [4]     | R      | 0x0   | Port Overcurrent Active   
 *  [5]     | R      | 0x0   | Port Overcurrent Change   
 *  [6]     | RW     | 0x0   | Port Resume               
 *  [7]     | R      | 0x0   | Port Suspend              
 *  [8]     | RW     | 0x0   | Port Reset                
 *  [9]     | ???    | 0x0   | *UNDEFINED*               
 *  [11:10] | R      | 0x0   | Port Line Status          
 *  [12]    | RW     | 0x0   | Port Power                
 *  [16:13] | RW     | 0x0   | Port Test Control         
 *  [18:17] | R      | 0x0   | Port Speed                
 *  [31:19] | ???    | 0x0   | *UNDEFINED*               
 * 
 */
/*
 * Field : Port Connect Status - prtconnsts
 * 
 * Defines whether port is attached.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                      
 * :-------------------------------------------|:------|:----------------------------------
 *  ALT_USB_HOST_HPRT_PRTCONNSTS_E_NOTATTACHED | 0x0   | No device is attached to the port
 *  ALT_USB_HOST_HPRT_PRTCONNSTS_E_ATTACHED    | 0x1   | A device is attached to the port 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNSTS
 * 
 * No device is attached to the port
 */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_E_NOTATTACHED  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNSTS
 * 
 * A device is attached to the port
 */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_E_ATTACHED     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_MSB        0
/* The width in bits of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTCONNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTCONNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HPRT_PRTCONNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTCONNSTS field value from a register. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HPRT_PRTCONNSTS register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTCONNSTS_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Port Connect Detected - PrtConnDet
 * 
 * The core sets this bit when a device connection is detected to trigger an
 * interrupt to the application using the Host Port Interrupt bit of the Core
 * Interrupt register (GINTSTS.PrtInt). This bit can be set only by the core and
 * the application should write 1 to clear it.The application must write a 1 to
 * this bit to clear the interrupt.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                  
 * :-------------------------------------|:------|:------------------------------
 *  ALT_USB_HOST_HPRT_PRTCONNDET_E_ACT   | 0x0   | Device connection detected   
 *  ALT_USB_HOST_HPRT_PRTCONNDET_E_INACT | 0x1   | No device connection detected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNDET
 * 
 * Device connection detected
 */
#define ALT_USB_HOST_HPRT_PRTCONNDET_E_ACT      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTCONNDET
 * 
 * No device connection detected
 */
#define ALT_USB_HOST_HPRT_PRTCONNDET_E_INACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_MSB        1
/* The width in bits of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTCONNDET register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTCONNDET register field value. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HPRT_PRTCONNDET register field. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTCONNDET field value from a register. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HPRT_PRTCONNDET register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTCONNDET_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Port Enabl - prtena
 * 
 * A port is enabled only by the core after a reset sequence, and is disabled by an
 * overcurrent condition, a disconnect condition, or by the application clearing
 * this bit. The application cannot Set this bit by a register write. It can only
 * clear it to disable the port by writing 1. This bit does not trigger any
 * interrupt to the application.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description  
 * :--------------------------------|:------|:--------------
 *  ALT_USB_HOST_HPRT_PRTENA_E_DISD | 0x0   | Port disabled
 *  ALT_USB_HOST_HPRT_PRTENA_E_END  | 0x1   | Port enabled 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENA
 * 
 * Port disabled
 */
#define ALT_USB_HOST_HPRT_PRTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENA
 * 
 * Port enabled
 */
#define ALT_USB_HOST_HPRT_PRTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_MSB        2
/* The width in bits of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTENA register field value. */
#define ALT_USB_HOST_HPRT_PRTENA_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTENA register field value. */
#define ALT_USB_HOST_HPRT_PRTENA_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HPRT_PRTENA register field. */
#define ALT_USB_HOST_HPRT_PRTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTENA field value from a register. */
#define ALT_USB_HOST_HPRT_PRTENA_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HPRT_PRTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTENA_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Port Enable Disable Change - prtenchng
 * 
 * The core sets this bit when the status of the Port Enable bit [2] of this
 * register changes. This bit can be set only by the core and the application
 * should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                
 * :------------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HPRT_PRTENCHNG_E_INACT | 0x0   | Port Enable bit 2 no change
 *  ALT_USB_HOST_HPRT_PRTENCHNG_E_ACT   | 0x1   | Port Enable bit 2 changed  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENCHNG
 * 
 * Port Enable bit 2 no change
 */
#define ALT_USB_HOST_HPRT_PRTENCHNG_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTENCHNG
 * 
 * Port Enable bit 2 changed
 */
#define ALT_USB_HOST_HPRT_PRTENCHNG_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_MSB        3
/* The width in bits of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTENCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTENCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HPRT_PRTENCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTENCHNG field value from a register. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HPRT_PRTENCHNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTENCHNG_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Port Overcurrent Active - prtovrcurract
 * 
 * Indicates the overcurrent condition of the port. 0x0: No overcurrent condition
 * 0x1: Overcurrent condition
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description             
 * :----------------------------------------|:------|:-------------------------
 *  ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_INACT | 0x0   | No overcurrent condition
 *  ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_ACT   | 0x1   | Overcurrent condition   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRACT
 * 
 * No overcurrent condition
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRACT
 * 
 * Overcurrent condition
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_MSB        4
/* The width in bits of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HPRT_PRTOVRCURRACT register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTOVRCURRACT field value from a register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HPRT_PRTOVRCURRACT register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRACT_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Port Overcurrent Change - prtovrcurrchng
 * 
 * The core sets this bit when the status of the PortOvercurrent Active bit (bit 4)
 * in this register changes.This bit can be set only by the core and the
 * application should write 1 to clear it
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                         
 * :-----------------------------------------|:------|:-------------------------------------
 *  ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_INACT | 0x0   | Status of port overcurrent no change
 *  ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_ACT   | 0x1   | Status of port overcurrent changed  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRCHNG
 * 
 * Status of port overcurrent no change
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTOVRCURRCHNG
 * 
 * Status of port overcurrent changed
 */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_MSB        5
/* The width in bits of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field value. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTOVRCURRCHNG field value from a register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HPRT_PRTOVRCURRCHNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTOVRCURRCHNG_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Port Resume - prtres
 * 
 * The application sets this bit to drive resume signaling on the port. The core
 * continues to drive the resume signal until the application clears this bit. If
 * the core detects a USB remote wakeup sequence, as indicated by the Port
 * Resume/Remote Wakeup Detected Interrupt bit of the Core Interrupt register
 * (GINTSTS.WkUpInt), the core starts driving resume signaling without application
 * intervention and clears this bit when it detects a disconnect condition. The
 * read value of this bit indicates whether the core is currently drivingresume
 * signaling. When LPM is enabled and the core is in the L1 (Sleep) state, setting
 * this bit results in the following behavior:
 * 
 * The core continues to drive the resume signal until a pre-determined time
 * specified in the GLPMCFG.HIRD_Thres[3:0] field. If the core detects a USB remote
 * wakeup sequence, as indicated by the Port L1 Resume/Remote L1 Wakeup Detected
 * Interrupt bit of the Core Interrupt register (GINTSTS.L1WkUpInt), the core
 * starts driving resume signaling without application intervention and clears this
 * bit at the end of the resume. The read value of this bit indicates whether the
 * core is currently driving resume signaling.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HPRT_PRTRES_E_NORESUME | 0x0   | No resume driven
 *  ALT_USB_HOST_HPRT_PRTRES_E_RESUME   | 0x1   | Resume driven   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRES
 * 
 * No resume driven
 */
#define ALT_USB_HOST_HPRT_PRTRES_E_NORESUME 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRES
 * 
 * Resume driven
 */
#define ALT_USB_HOST_HPRT_PRTRES_E_RESUME   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_MSB        6
/* The width in bits of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTRES register field value. */
#define ALT_USB_HOST_HPRT_PRTRES_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTRES register field value. */
#define ALT_USB_HOST_HPRT_PRTRES_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HPRT_PRTRES register field. */
#define ALT_USB_HOST_HPRT_PRTRES_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTRES field value from a register. */
#define ALT_USB_HOST_HPRT_PRTRES_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HPRT_PRTRES register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTRES_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Port Suspend - prtsusp
 * 
 * The application sets this bit to put this port in Suspend mode. The core only
 * stops sending SOFs when this is Set. To stop the PHY clock, the application must
 * Set the Port Clock Stop bit, which asserts the suspend input pin of the PHY. The
 * read value of this bit reflects the current suspend status of the port. This bit
 * is cleared by the core after a remote wakeup signal is detected or the
 * application sets the Port Reset bit or Port Resume bit in this register or the
 * Resume/Remote Wakeup Detected Interrupt bit or Disconnect Detected Interrupt bit
 * in the Core Interrupt register (GINTSTS.WkUpInt or GINTSTS.DisconnInt,
 * respectively). This bit is cleared by the core even if there is no device
 * connected to the Host.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description             
 * :----------------------------------|:------|:-------------------------
 *  ALT_USB_HOST_HPRT_PRTSUSP_E_INACT | 0x0   | Port not in Suspend mode
 *  ALT_USB_HOST_HPRT_PRTSUSP_E_ACT   | 0x1   | Port in Suspend mode    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSUSP
 * 
 * Port not in Suspend mode
 */
#define ALT_USB_HOST_HPRT_PRTSUSP_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSUSP
 * 
 * Port in Suspend mode
 */
#define ALT_USB_HOST_HPRT_PRTSUSP_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_MSB        7
/* The width in bits of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTSUSP register field value. */
#define ALT_USB_HOST_HPRT_PRTSUSP_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTSUSP register field value. */
#define ALT_USB_HOST_HPRT_PRTSUSP_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HPRT_PRTSUSP register field. */
#define ALT_USB_HOST_HPRT_PRTSUSP_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTSUSP field value from a register. */
#define ALT_USB_HOST_HPRT_PRTSUSP_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HPRT_PRTSUSP register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTSUSP_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Port Reset - prtrst
 * 
 * When the application sets this bit, a reset sequence is started on this port.
 * The application must time the reset period and clear this bit after the reset
 * sequence is complete. The application must leave this bit Set for at least a
 * minimum duration mentioned below to start a reset on the port. The application
 * can leave it Set for another 10 ms in addition to the required minimum duration,
 * before clearing the bit, even though there is no maximum limit set by theUSB
 * standard. This bit is cleared by the core even if there is no device connected
 * to the Host.
 * 
 * High speed: 50 ms
 * 
 * Full speed/Low speed: 10 ms
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description      
 * :--------------------------------|:------|:------------------
 *  ALT_USB_HOST_HPRT_PRTRST_E_DISD | 0x0   | Port not in reset
 *  ALT_USB_HOST_HPRT_PRTRST_E_END  | 0x1   | Port in reset    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRST
 * 
 * Port not in reset
 */
#define ALT_USB_HOST_HPRT_PRTRST_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTRST
 * 
 * Port in reset
 */
#define ALT_USB_HOST_HPRT_PRTRST_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_MSB        8
/* The width in bits of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTRST register field value. */
#define ALT_USB_HOST_HPRT_PRTRST_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTRST register field value. */
#define ALT_USB_HOST_HPRT_PRTRST_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HPRT_PRTRST register field. */
#define ALT_USB_HOST_HPRT_PRTRST_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTRST field value from a register. */
#define ALT_USB_HOST_HPRT_PRTRST_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HPRT_PRTRST register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTRST_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Port Line Status - prtlnsts
 * 
 * Indicates the current logic level USB data lines. Bit [10]: Logic level of D+
 * Bit [11]: Logic level of D-
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HPRT_PRTLNSTS_E_PLUSD  | 0x1   | Logic level of D+
 *  ALT_USB_HOST_HPRT_PRTLNSTS_E_MINUSD | 0x2   | Logic level of D-
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTLNSTS
 * 
 * Logic level of D+
 */
#define ALT_USB_HOST_HPRT_PRTLNSTS_E_PLUSD  0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTLNSTS
 * 
 * Logic level of D-
 */
#define ALT_USB_HOST_HPRT_PRTLNSTS_E_MINUSD 0x2

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_MSB        11
/* The width in bits of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HPRT_PRTLNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_SET_MSK    0x00000c00
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTLNSTS register field value. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_CLR_MSK    0xfffff3ff
/* The reset value of the ALT_USB_HOST_HPRT_PRTLNSTS register field. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTLNSTS field value from a register. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_GET(value) (((value) & 0x00000c00) >> 10)
/* Produces a ALT_USB_HOST_HPRT_PRTLNSTS register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTLNSTS_SET(value) (((value) << 10) & 0x00000c00)

/*
 * Field : Port Power - prtpwr
 * 
 * The application uses this field to control power to this port, and the core can
 * clear this bit on an over current condition.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                           | Value | Description
 * :-------------------------------|:------|:------------
 *  ALT_USB_HOST_HPRT_PRTPWR_E_OFF | 0x0   | Power off  
 *  ALT_USB_HOST_HPRT_PRTPWR_E_ON  | 0x1   | Power on   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTPWR
 * 
 * Power off
 */
#define ALT_USB_HOST_HPRT_PRTPWR_E_OFF  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTPWR
 * 
 * Power on
 */
#define ALT_USB_HOST_HPRT_PRTPWR_E_ON   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_MSB        12
/* The width in bits of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HPRT_PRTPWR register field value. */
#define ALT_USB_HOST_HPRT_PRTPWR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTPWR register field value. */
#define ALT_USB_HOST_HPRT_PRTPWR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HPRT_PRTPWR register field. */
#define ALT_USB_HOST_HPRT_PRTPWR_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTPWR field value from a register. */
#define ALT_USB_HOST_HPRT_PRTPWR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HPRT_PRTPWR register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTPWR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Port Test Control - prttstctl
 * 
 * The application writes a nonzero value to this field to put the port into a Test
 * mode, and the corresponding pattern is signaled on the port.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description       
 * :---------------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_DISD     | 0x0   | Test mode disabled
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTJ    | 0x1   | Test_J mode       
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTK    | 0x2   | Test_K mode       
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTSN   | 0x3   | Test_SE0_NAK mode 
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTPM   | 0x4   | Test_Packet mode  
 *  ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTFENB | 0x5   | Test_force_Enable 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test mode disabled
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_DISD      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_J mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTJ     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_K mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTK     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_SE0_NAK mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTSN    0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_Packet mode
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTPM    0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTTSTCTL
 * 
 * Test_force_Enable
 */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_E_TESTFENB  0x5

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_MSB        16
/* The width in bits of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HPRT_PRTTSTCTL register field value. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_SET_MSK    0x0001e000
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTTSTCTL register field value. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_CLR_MSK    0xfffe1fff
/* The reset value of the ALT_USB_HOST_HPRT_PRTTSTCTL register field. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTTSTCTL field value from a register. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_GET(value) (((value) & 0x0001e000) >> 13)
/* Produces a ALT_USB_HOST_HPRT_PRTTSTCTL register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTTSTCTL_SET(value) (((value) << 13) & 0x0001e000)

/*
 * Field : Port Speed - prtspd
 * 
 * Indicates the speed of the device attached to this port.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description
 * :-----------------------------------|:------|:------------
 *  ALT_USB_HOST_HPRT_PRTSPD_E_HIGHSPD | 0x0   | High speed 
 *  ALT_USB_HOST_HPRT_PRTSPD_E_FULLSPD | 0x1   | Full speed 
 *  ALT_USB_HOST_HPRT_PRTSPD_E_LOWSPD  | 0x2   | Low speed  
 *  ALT_USB_HOST_HPRT_PRTSPD_E_RSVD    | 0x3   | Reserved   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * High speed
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_HIGHSPD  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * Full speed
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_FULLSPD  0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * Low speed
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_LOWSPD   0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HPRT_PRTSPD
 * 
 * Reserved
 */
#define ALT_USB_HOST_HPRT_PRTSPD_E_RSVD     0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_MSB        18
/* The width in bits of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HPRT_PRTSPD register field value. */
#define ALT_USB_HOST_HPRT_PRTSPD_SET_MSK    0x00060000
/* The mask used to clear the ALT_USB_HOST_HPRT_PRTSPD register field value. */
#define ALT_USB_HOST_HPRT_PRTSPD_CLR_MSK    0xfff9ffff
/* The reset value of the ALT_USB_HOST_HPRT_PRTSPD register field. */
#define ALT_USB_HOST_HPRT_PRTSPD_RESET      0x0
/* Extracts the ALT_USB_HOST_HPRT_PRTSPD field value from a register. */
#define ALT_USB_HOST_HPRT_PRTSPD_GET(value) (((value) & 0x00060000) >> 17)
/* Produces a ALT_USB_HOST_HPRT_PRTSPD register field value suitable for setting the register. */
#define ALT_USB_HOST_HPRT_PRTSPD_SET(value) (((value) << 17) & 0x00060000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HPRT.
 */
struct ALT_USB_HOST_HPRT_s
{
    const uint32_t  prtconnsts     :  1;  /* Port Connect Status */
    const uint32_t  PrtConnDet     :  1;  /* Port Connect Detected */
    const uint32_t  prtena         :  1;  /* Port Enabl */
    const uint32_t  prtenchng      :  1;  /* Port Enable Disable Change */
    const uint32_t  prtovrcurract  :  1;  /* Port Overcurrent Active */
    const uint32_t  prtovrcurrchng :  1;  /* Port Overcurrent Change */
    uint32_t        prtres         :  1;  /* Port Resume */
    const uint32_t  prtsusp        :  1;  /* Port Suspend */
    uint32_t        prtrst         :  1;  /* Port Reset */
    uint32_t                       :  1;  /* *UNDEFINED* */
    const uint32_t  prtlnsts       :  2;  /* Port Line Status */
    uint32_t        prtpwr         :  1;  /* Port Power */
    uint32_t        prttstctl      :  4;  /* Port Test Control */
    const uint32_t  prtspd         :  2;  /* Port Speed */
    uint32_t                       : 13;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HPRT. */
typedef volatile struct ALT_USB_HOST_HPRT_s  ALT_USB_HOST_HPRT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HPRT register from the beginning of the component. */
#define ALT_USB_HOST_HPRT_OFST        0x40
/* The address of the ALT_USB_HOST_HPRT register. */
#define ALT_USB_HOST_HPRT_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HPRT_OFST))

/*
 * Register : Host Channel 0 Characteristics Register - hcchar0
 * 
 * Channel_number: 0.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description            
 * :--------|:-------|:------|:------------------------
 *  [10:0]  | RW     | 0x0   | Maximum Packet Size    
 *  [14:11] | RW     | 0x0   | Endpoint Number        
 *  [15]    | RW     | 0x0   | Endpoint Direction     
 *  [16]    | ???    | 0x0   | *UNDEFINED*            
 *  [17]    | RW     | 0x0   | Low-Speed Device       
 *  [19:18] | RW     | 0x0   | Endpoint Type          
 *  [21:20] | RW     | 0x0   | Multi Count Error Count
 *  [28:22] | RW     | 0x0   | Device Address         
 *  [29]    | ???    | 0x0   | *UNDEFINED*            
 *  [30]    | R      | 0x0   | Channel Disable        
 *  [31]    | R      | 0x0   | Channel Enable         
 * 
 */
/*
 * Field : Maximum Packet Size - mps
 * 
 * Indicates the maximum packet size of the associated endpoint.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_MSB        10
/* The width in bits of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_WIDTH      11
/* The mask used to set the ALT_USB_HOST_HCCHAR0_MPS register field value. */
#define ALT_USB_HOST_HCCHAR0_MPS_SET_MSK    0x000007ff
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_MPS register field value. */
#define ALT_USB_HOST_HCCHAR0_MPS_CLR_MSK    0xfffff800
/* The reset value of the ALT_USB_HOST_HCCHAR0_MPS register field. */
#define ALT_USB_HOST_HCCHAR0_MPS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_MPS field value from a register. */
#define ALT_USB_HOST_HCCHAR0_MPS_GET(value) (((value) & 0x000007ff) >> 0)
/* Produces a ALT_USB_HOST_HCCHAR0_MPS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_MPS_SET(value) (((value) << 0) & 0x000007ff)

/*
 * Field : Endpoint Number - epnum
 * 
 * Indicates the endpoint number on the device serving as the data source or sink.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  0
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  1
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  2
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  3
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  4
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  5
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  6
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  7
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  8
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  9
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  10
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  11
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  12
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  13
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  14
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPNUM
 * 
 * End point  15
 */
#define ALT_USB_HOST_HCCHAR0_EPNUM_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_MSB        14
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_SET_MSK    0x00007800
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_CLR_MSK    0xffff87ff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EPNUM field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_GET(value) (((value) & 0x00007800) >> 11)
/* Produces a ALT_USB_HOST_HCCHAR0_EPNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EPNUM_SET(value) (((value) << 11) & 0x00007800)

/*
 * Field : Endpoint Direction - epdir
 * 
 * Indicates whether the transaction is IN or OUT.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR0_EPDIR_E_OUTDIR | 0x0   | OUT        
 *  ALT_USB_HOST_HCCHAR0_EPDIR_E_INDIR  | 0x1   | IN         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPDIR
 * 
 * OUT
 */
#define ALT_USB_HOST_HCCHAR0_EPDIR_E_OUTDIR 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPDIR
 * 
 * IN
 */
#define ALT_USB_HOST_HCCHAR0_EPDIR_E_INDIR  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_MSB        15
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EPDIR field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_HOST_HCCHAR0_EPDIR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EPDIR_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : Low-Speed Device - lspddev
 * 
 * This field is Set by the application to indicate that this channel is
 * communicating to a low-speed device. The application must program this bit when
 * a low speed device is connected to the host through an FS HUB. The HS OTG Host
 * core uses this field to drive the XCVR_SELECT signal to 0x3 while communicating
 * to the LS Device through the FS hub. In a peer to peer setup, the HS OTG Host
 * core ignores this bit even if it is set by the application software.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                    
 * :-------------------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCCHAR0_LSPDDEV_E_NONLOWSPEED | 0x0   | Communicating with non lowspeed
 *  ALT_USB_HOST_HCCHAR0_LSPDDEV_E_LOWSPEED    | 0x1   | Communicating with lowspeed    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_LSPDDEV
 * 
 * Communicating with non lowspeed
 */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_E_NONLOWSPEED  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_LSPDDEV
 * 
 * Communicating with lowspeed
 */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_E_LOWSPEED     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_MSB        17
/* The width in bits of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_LSPDDEV field value from a register. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_HOST_HCCHAR0_LSPDDEV register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_LSPDDEV_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : Endpoint Type - eptype
 * 
 * Indicates the transfer type selected.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_CTL    | 0x0   | Control    
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_ISOC   | 0x1   | Isochronous
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_BULK   | 0x2   | Bulk       
 *  ALT_USB_HOST_HCCHAR0_EPTYPE_E_INTERR | 0x3   | Interrupt  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Control
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_CTL       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Isochronous
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_ISOC      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Bulk
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_BULK      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EPTYPE
 * 
 * Interrupt
 */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_E_INTERR    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_MSB        19
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_SET_MSK    0x000c0000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_CLR_MSK    0xfff3ffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EPTYPE field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_GET(value) (((value) & 0x000c0000) >> 18)
/* Produces a ALT_USB_HOST_HCCHAR0_EPTYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EPTYPE_SET(value) (((value) << 18) & 0x000c0000)

/*
 * Field : Multi Count Error Count - ec
 * 
 * When the Split Enable bit of the Host Channel-n Split Control register
 * (HCSPLTn.SpltEna) is reset (0), this field indicates to the host the number of
 * transactions that must be executed per microframe for this periodic endpoint.
 * for non periodic transfers, this field is used only in DMA mode, and specifies
 * the number packets to be fetched for this channel before the internal DMA engine
 * changes arbitration. When HCSPLTn.SpltEna is Set (1'b1), this field indicates
 * the number of immediate retries to be performed for a periodic split
 * transactions on transaction errors. This field must be Set to at least 2'b01.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                  
 * :-------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_HOST_HCCHAR0_EC_E_RSVD       | 0x0   | Reserved This field yields undefined results 
 *  ALT_USB_HOST_HCCHAR0_EC_E_TRANSONE   | 0x1   | 1 transaction                                
 *  ALT_USB_HOST_HCCHAR0_EC_E_TRANSTWO   | 0x2   | 2 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 *  ALT_USB_HOST_HCCHAR0_EC_E_TRANSTHREE | 0x3   | 3 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * Reserved This field yields undefined results
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_RSVD          0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * 1 transaction
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_TRANSONE      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * 2 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_TRANSTWO      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_EC
 * 
 * 3 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR0_EC_E_TRANSTHREE    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_MSB        21
/* The width in bits of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR0_EC register field value. */
#define ALT_USB_HOST_HCCHAR0_EC_SET_MSK    0x00300000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_EC register field value. */
#define ALT_USB_HOST_HCCHAR0_EC_CLR_MSK    0xffcfffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_EC register field. */
#define ALT_USB_HOST_HCCHAR0_EC_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_EC field value from a register. */
#define ALT_USB_HOST_HCCHAR0_EC_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_USB_HOST_HCCHAR0_EC register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_EC_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : Device Address - devaddr
 * 
 * This field selects the specific device serving as the data source or sink.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_MSB        28
/* The width in bits of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCCHAR0_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_SET_MSK    0x1fc00000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_CLR_MSK    0xe03fffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_DEVADDR field value from a register. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_GET(value) (((value) & 0x1fc00000) >> 22)
/* Produces a ALT_USB_HOST_HCCHAR0_DEVADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_DEVADDR_SET(value) (((value) << 22) & 0x1fc00000)

/*
 * Field : Channel Disable - chdis
 * 
 * The application sets this bit to stop transmitting/receiving data on a channel,
 * even before the transfer for that channel is complete. The application must wait
 * for the Channel Disabled interrupt before treating the channel as disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                     
 * :-----------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCCHAR0_CHDIS_E_INACT | 0x0   | No activity                     
 *  ALT_USB_HOST_HCCHAR0_CHDIS_E_ACT   | 0x1   | Stop transmitting/receiving data
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHDIS
 * 
 * No activity
 */
#define ALT_USB_HOST_HCCHAR0_CHDIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHDIS
 * 
 * Stop transmitting/receiving data
 */
#define ALT_USB_HOST_HCCHAR0_CHDIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_MSB        30
/* The width in bits of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_CHDIS field value from a register. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_HOST_HCCHAR0_CHDIS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_CHDIS_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Channel Enable - chena
 * 
 * When Scatter/Gather mode is disabled. This field is set by the application and
 * cleared by the OTG host.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                     
 * :------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_HOST_HCCHAR0_CHENA_E_NOTRDY | 0x0   | Indicates that the descriptor structure is not  
 * :                                    |       | yet ready                                       
 *  ALT_USB_HOST_HCCHAR0_CHENA_E_RDY    | 0x1   | Indicates that the descriptor structure and data
 * :                                    |       | buffer with data is setup and this channel can  
 * :                                    |       | access the descriptor                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHENA
 * 
 * Indicates that the descriptor structure is not yet ready
 */
#define ALT_USB_HOST_HCCHAR0_CHENA_E_NOTRDY 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR0_CHENA
 * 
 * Indicates that the descriptor structure and data  buffer with data is setup and
 * this channel can access the descriptor
 */
#define ALT_USB_HOST_HCCHAR0_CHENA_E_RDY    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR0_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR0_CHENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR0_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR0_CHENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCCHAR0_CHENA register field. */
#define ALT_USB_HOST_HCCHAR0_CHENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR0_CHENA field value from a register. */
#define ALT_USB_HOST_HCCHAR0_CHENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCCHAR0_CHENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR0_CHENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCCHAR0.
 */
struct ALT_USB_HOST_HCCHAR0_s
{
    uint32_t        mps     : 11;  /* Maximum Packet Size */
    uint32_t        epnum   :  4;  /* Endpoint Number */
    uint32_t        epdir   :  1;  /* Endpoint Direction */
    uint32_t                :  1;  /* *UNDEFINED* */
    uint32_t        lspddev :  1;  /* Low-Speed Device */
    uint32_t        eptype  :  2;  /* Endpoint Type */
    uint32_t        ec      :  2;  /* Multi Count Error Count */
    uint32_t        devaddr :  7;  /* Device Address */
    uint32_t                :  1;  /* *UNDEFINED* */
    const uint32_t  chdis   :  1;  /* Channel Disable */
    const uint32_t  chena   :  1;  /* Channel Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCCHAR0. */
typedef volatile struct ALT_USB_HOST_HCCHAR0_s  ALT_USB_HOST_HCCHAR0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCCHAR0 register from the beginning of the component. */
#define ALT_USB_HOST_HCCHAR0_OFST        0x100
/* The address of the ALT_USB_HOST_HCCHAR0 register. */
#define ALT_USB_HOST_HCCHAR0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCCHAR0_OFST))

/*
 * Register : Host Channel 0 Split Control Register - hcsplt0
 * 
 * Channel_number 0
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description         
 * :--------|:-------|:------|:---------------------
 *  [6:0]   | RW     | 0x0   | Port Address        
 *  [13:7]  | RW     | 0x0   | Hub Address         
 *  [15:14] | RW     | 0x0   | Transaction Position
 *  [16]    | RW     | 0x0   | Do Complete Split   
 *  [30:17] | ???    | 0x0   | *UNDEFINED*         
 *  [31]    | RW     | 0x0   | Split Enable        
 * 
 */
/*
 * Field : Port Address - prtaddr
 * 
 * This field is the port number of the recipient transactiontranslator.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_MSB        6
/* The width in bits of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT0_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_SET_MSK    0x0000007f
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_CLR_MSK    0xffffff80
/* The reset value of the ALT_USB_HOST_HCSPLT0_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_PRTADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_GET(value) (((value) & 0x0000007f) >> 0)
/* Produces a ALT_USB_HOST_HCSPLT0_PRTADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_PRTADDR_SET(value) (((value) << 0) & 0x0000007f)

/*
 * Field : Hub Address - hubaddr
 * 
 * This field holds the device address of the transaction translator's hub.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT0_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_SET_MSK    0x00003f80
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_CLR_MSK    0xffffc07f
/* The reset value of the ALT_USB_HOST_HCSPLT0_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_HUBADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_GET(value) (((value) & 0x00003f80) >> 7)
/* Produces a ALT_USB_HOST_HCSPLT0_HUBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_HUBADDR_SET(value) (((value) << 7) & 0x00003f80)

/*
 * Field : Transaction Position - xactpos
 * 
 * This field is used to determine whether to send all, first, middle, or last
 * payloads with each OUT transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_MIDDLE | 0x0   | Mid. This is the middle payload of this        
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_END    | 0x1   | End. This is the last payload of this          
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_BEGIN  | 0x2   | Begin. This is the first data payload of this  
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT0_XACTPOS_E_ALL    | 0x3   | All. This is the entire data payload is of this
 * :                                      |       | transaction (which is less than or equal to 188
 * :                                      |       | bytes)                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * Mid. This is the middle payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_MIDDLE   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * End. This is the last payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_END      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * Begin. This is the first data payload of this transaction (which is larger than
 * 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_BEGIN    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_XACTPOS
 * 
 * All. This is the entire data payload is of this transaction (which is less than
 * or equal to 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_E_ALL      0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_MSB        15
/* The width in bits of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCSPLT0_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_HOST_HCSPLT0_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_XACTPOS field value from a register. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_HOST_HCSPLT0_XACTPOS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_XACTPOS_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : Do Complete Split - compsplt
 * 
 * The application sets this field to request the OTG host to perform a complete
 * split transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCSPLT0_COMPSPLT_E_NOSPLIT | 0x0   | No split transaction
 *  ALT_USB_HOST_HCSPLT0_COMPSPLT_E_SPLIT   | 0x1   | Split transaction   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_COMPSPLT
 * 
 * No split transaction
 */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_E_NOSPLIT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_COMPSPLT
 * 
 * Split transaction
 */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_E_SPLIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_MSB        16
/* The width in bits of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT0_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HCSPLT0_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_COMPSPLT field value from a register. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HCSPLT0_COMPSPLT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_COMPSPLT_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : Split Enable - spltena
 * 
 * The application sets this field to indicate that this channel is enabled to
 * perform split transactions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HCSPLT0_SPLTENA_E_DISD | 0x0   | Split not enabled
 *  ALT_USB_HOST_HCSPLT0_SPLTENA_E_END  | 0x1   | Split enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_SPLTENA
 * 
 * Split not enabled
 */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT0_SPLTENA
 * 
 * Split enabled
 */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT0_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCSPLT0_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCSPLT0_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT0_SPLTENA field value from a register. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCSPLT0_SPLTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT0_SPLTENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCSPLT0.
 */
struct ALT_USB_HOST_HCSPLT0_s
{
    uint32_t  prtaddr  :  7;  /* Port Address */
    uint32_t  hubaddr  :  7;  /* Hub Address */
    uint32_t  xactpos  :  2;  /* Transaction Position */
    uint32_t  compsplt :  1;  /* Do Complete Split */
    uint32_t           : 14;  /* *UNDEFINED* */
    uint32_t  spltena  :  1;  /* Split Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCSPLT0. */
typedef volatile struct ALT_USB_HOST_HCSPLT0_s  ALT_USB_HOST_HCSPLT0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCSPLT0 register from the beginning of the component. */
#define ALT_USB_HOST_HCSPLT0_OFST        0x104
/* The address of the ALT_USB_HOST_HCSPLT0 register. */
#define ALT_USB_HOST_HCSPLT0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCSPLT0_OFST))

/*
 * Register : Host Channel 0 Interrupt Register - hcint0
 * 
 * This register indicates the status of a channel with respect to USB- and AHB-
 * related events. The application must read this register when the Host Channels
 * Interrupt bit of the Core Interrupt register (GINTSTS.HChInt) is set. Before the
 * application can read this register, it must first read the Host All Channels
 * Interrupt (HAINT) register to get the exact channel number for the Host
 * Channel-n Interrupt register. The application must clear the appropriate bit in
 * this register to clear the corresponding bits in the HAINT and GINTSTS
 * registers.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                
 * :--------|:-------|:------|:--------------------------------------------
 *  [0]     | R      | 0x0   | Transfer Completed                         
 *  [1]     | R      | 0x0   | Channel Halted                             
 *  [2]     | R      | 0x0   | AHB Error                                  
 *  [3]     | R      | 0x0   | STALL Response Received Interrupt          
 *  [4]     | R      | 0x0   | NAK Response Received Interrupt            
 *  [5]     | R      | 0x0   | ACK Response Received Transmitted Interrupt
 *  [6]     | R      | 0x0   | NYET Response Received Interrupt           
 *  [7]     | R      | 0x0   | Transaction Error                          
 *  [8]     | R      | 0x0   | Babble Error                               
 *  [9]     | R      | 0x0   | Frame Overrun                              
 *  [10]    | R      | 0x0   | Data Toggle Error                          
 *  [11]    | R      | 0x0   | BNA Interrupt                              
 *  [12]    | R      | 0x0   | Excessive Transaction Error                
 *  [13]    | R      | 0x0   | Descriptor rollover interrupt              
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                                
 * 
 */
/*
 * Field : Transfer Completed - xfercompl
 * 
 * Transfer completed normally without any errors. This bit can be set only by the
 * core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT0_XFERCOMPL_E_INACT | 0x0   | No transfer                                   
 *  ALT_USB_HOST_HCINT0_XFERCOMPL_E_ACT   | 0x1   | Transfer completed normally without any errors
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XFERCOMPL
 * 
 * No transfer
 */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XFERCOMPL
 * 
 * Transfer completed normally without any errors
 */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINT0_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINT0_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_XFERCOMPL field value from a register. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINT0_XFERCOMPL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_XFERCOMPL_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Halted - chhltd
 * 
 * In non Scatter/Gather DMA mode, it indicates the transfer completed abnormally
 * either because of any USB transaction error or in response to disable request by
 * the application or because of a completed transfer. In Scatter/gather DMA mode,
 * this indicates that transfer completed due to any of the following
 * 
 * . EOL being set in descriptor
 * 
 * . AHB error
 * 
 * . Excessive transaction errors
 * 
 * . Babble
 * 
 * . Stall
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description       
 * :-----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT0_CHHLTD_E_INACT | 0x0   | Channel not halted
 *  ALT_USB_HOST_HCINT0_CHHLTD_E_ACT   | 0x1   | Channel Halted    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_CHHLTD
 * 
 * Channel not halted
 */
#define ALT_USB_HOST_HCINT0_CHHLTD_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_CHHLTD
 * 
 * Channel Halted
 */
#define ALT_USB_HOST_HCINT0_CHHLTD_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT0_CHHLTD_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINT0_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT0_CHHLTD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINT0_CHHLTD register field. */
#define ALT_USB_HOST_HCINT0_CHHLTD_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_CHHLTD field value from a register. */
#define ALT_USB_HOST_HCINT0_CHHLTD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINT0_CHHLTD register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_CHHLTD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : AHB Error - ahberr
 * 
 * This is generated only in Internal DMA mode when there is an AHB error during
 * AHB read/write. The application can read the corresponding channel's DMA address
 * register to get the error address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                    
 * :-----------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCINT0_AHBERR_E_INACT | 0x0   | No AHB error                   
 *  ALT_USB_HOST_HCINT0_AHBERR_E_ACT   | 0x1   | AHB error during AHB read/write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_AHBERR
 * 
 * No AHB error
 */
#define ALT_USB_HOST_HCINT0_AHBERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_AHBERR
 * 
 * AHB error during AHB read/write
 */
#define ALT_USB_HOST_HCINT0_AHBERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_AHBERR register field value. */
#define ALT_USB_HOST_HCINT0_AHBERR_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINT0_AHBERR register field value. */
#define ALT_USB_HOST_HCINT0_AHBERR_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINT0_AHBERR register field. */
#define ALT_USB_HOST_HCINT0_AHBERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_AHBERR field value from a register. */
#define ALT_USB_HOST_HCINT0_AHBERR_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINT0_AHBERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_AHBERR_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : STALL Response Received Interrupt - stall
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description       
 * :----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT0_STALL_E_INACT | 0x0   | No Stall Interrupt
 *  ALT_USB_HOST_HCINT0_STALL_E_ACT   | 0x1   | Stall Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_STALL
 * 
 * No Stall Interrupt
 */
#define ALT_USB_HOST_HCINT0_STALL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_STALL
 * 
 * Stall Interrupt
 */
#define ALT_USB_HOST_HCINT0_STALL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_STALL register field value. */
#define ALT_USB_HOST_HCINT0_STALL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINT0_STALL register field value. */
#define ALT_USB_HOST_HCINT0_STALL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINT0_STALL register field. */
#define ALT_USB_HOST_HCINT0_STALL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_STALL field value from a register. */
#define ALT_USB_HOST_HCINT0_STALL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINT0_STALL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_STALL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NAK Response Received Interrupt - nak
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_USB_HOST_HCINT0_NAK_E_INACT | 0x0   | No NAK Response Received Interrupt
 *  ALT_USB_HOST_HCINT0_NAK_E_ACT   | 0x1   | NAK Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NAK
 * 
 * No NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NAK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NAK
 * 
 * NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NAK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_NAK register field value. */
#define ALT_USB_HOST_HCINT0_NAK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINT0_NAK register field value. */
#define ALT_USB_HOST_HCINT0_NAK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINT0_NAK register field. */
#define ALT_USB_HOST_HCINT0_NAK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_NAK field value from a register. */
#define ALT_USB_HOST_HCINT0_NAK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINT0_NAK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_NAK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ACK Response Received Transmitted Interrupt - ack
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                   
 * :--------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT0_ACK_E_INACT | 0x0   | No ACK Response Received Transmitted Interrupt
 *  ALT_USB_HOST_HCINT0_ACK_E_ACT   | 0x1   | ACK Response Received Transmitted Interrup    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_ACK
 * 
 * No ACK Response Received Transmitted Interrupt
 */
#define ALT_USB_HOST_HCINT0_ACK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_ACK
 * 
 * ACK Response Received Transmitted Interrup
 */
#define ALT_USB_HOST_HCINT0_ACK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_ACK register field value. */
#define ALT_USB_HOST_HCINT0_ACK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINT0_ACK register field value. */
#define ALT_USB_HOST_HCINT0_ACK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINT0_ACK register field. */
#define ALT_USB_HOST_HCINT0_ACK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_ACK field value from a register. */
#define ALT_USB_HOST_HCINT0_ACK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINT0_ACK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_ACK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NYET Response Received Interrupt - nyet
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCINT0_NYET_E_INACT | 0x0   | No NYET Response Received Interrupt
 *  ALT_USB_HOST_HCINT0_NYET_E_ACT   | 0x1   | NYET Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NYET
 * 
 * No NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NYET_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_NYET
 * 
 * NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT0_NYET_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_NYET register field value. */
#define ALT_USB_HOST_HCINT0_NYET_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINT0_NYET register field value. */
#define ALT_USB_HOST_HCINT0_NYET_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINT0_NYET register field. */
#define ALT_USB_HOST_HCINT0_NYET_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_NYET field value from a register. */
#define ALT_USB_HOST_HCINT0_NYET_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINT0_NYET register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_NYET_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Transaction Error - xacterr
 * 
 * Indicates one of the following errors occurred on the USB.-CRC check failure
 * 
 * * Timeout
 * 
 * * Bit stuff error
 * 
 * * False EOP
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description         
 * :------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT0_XACTERR_E_INACT | 0x0   | No Transaction Error
 *  ALT_USB_HOST_HCINT0_XACTERR_E_ACT   | 0x1   | Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XACTERR
 * 
 * No Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XACTERR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XACTERR
 * 
 * Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XACTERR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_XACTERR register field value. */
#define ALT_USB_HOST_HCINT0_XACTERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINT0_XACTERR register field value. */
#define ALT_USB_HOST_HCINT0_XACTERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINT0_XACTERR register field. */
#define ALT_USB_HOST_HCINT0_XACTERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_XACTERR field value from a register. */
#define ALT_USB_HOST_HCINT0_XACTERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINT0_XACTERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_XACTERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Babble Error - bblerr
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core..This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description    
 * :-----------------------------------|:------|:----------------
 *  ALT_USB_HOST_HCINT0_BBLERR_E_INACT | 0x0   | No Babble Error
 *  ALT_USB_HOST_HCINT0_BBLERR_E_ACT   | 0x1   | Babble Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BBLERR
 * 
 * No Babble Error
 */
#define ALT_USB_HOST_HCINT0_BBLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BBLERR
 * 
 * Babble Error
 */
#define ALT_USB_HOST_HCINT0_BBLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_BBLERR register field value. */
#define ALT_USB_HOST_HCINT0_BBLERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINT0_BBLERR register field value. */
#define ALT_USB_HOST_HCINT0_BBLERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINT0_BBLERR register field. */
#define ALT_USB_HOST_HCINT0_BBLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_BBLERR field value from a register. */
#define ALT_USB_HOST_HCINT0_BBLERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINT0_BBLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_BBLERR_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Frame Overrun - frmovrun
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description     
 * :-------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT0_FRMOVRUN_E_INACT | 0x0   | No Frame Overrun
 *  ALT_USB_HOST_HCINT0_FRMOVRUN_E_ACT   | 0x1   | Frame Overrun   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_FRMOVRUN
 * 
 * No Frame Overrun
 */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_FRMOVRUN
 * 
 * Frame Overrun
 */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINT0_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINT0_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_FRMOVRUN field value from a register. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINT0_FRMOVRUN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_FRMOVRUN_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Data Toggle Error - datatglerr
 * 
 * This bit can be set only by the core and the application should write 1 to clear
 * it. In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT0_DATATGLERR_E_INACT | 0x0   | No Data Toggle Error
 *  ALT_USB_HOST_HCINT0_DATATGLERR_E_ACT   | 0x1   | Data Toggle Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DATATGLERR
 * 
 * No Data Toggle Error
 */
#define ALT_USB_HOST_HCINT0_DATATGLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DATATGLERR
 * 
 * Data Toggle Error
 */
#define ALT_USB_HOST_HCINT0_DATATGLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINT0_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINT0_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_DATATGLERR field value from a register. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINT0_DATATGLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_DATATGLERR_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : BNA Interrupt - bnaintr
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core
 * generates this interrupt when the descriptor accessed is not ready for the Core
 * to process. BNA will not be generated for Isochronous channels. for non
 * Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT0_BNAINTR_E_INACT | 0x0   | No BNA Interrupt
 *  ALT_USB_HOST_HCINT0_BNAINTR_E_ACT   | 0x1   | BNA Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BNAINTR
 * 
 * No BNA Interrupt
 */
#define ALT_USB_HOST_HCINT0_BNAINTR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_BNAINTR
 * 
 * BNA Interrupt
 */
#define ALT_USB_HOST_HCINT0_BNAINTR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT0_BNAINTR_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINT0_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT0_BNAINTR_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINT0_BNAINTR register field. */
#define ALT_USB_HOST_HCINT0_BNAINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_BNAINTR field value from a register. */
#define ALT_USB_HOST_HCINT0_BNAINTR_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINT0_BNAINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_BNAINTR_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Excessive Transaction Error - xcs_xact_err
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit when 3 consecutive transaction errors occurred on the USB bus.
 * XCS_XACT_ERR will not be generated for Isochronous channels.for non
 * Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                   
 * :-------------------------------------------|:------|:-------------------------------
 *  ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_INACT   | 0x0   | No Excessive Transaction Error
 *  ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_ACVTIVE | 0x1   | Excessive Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XCS_XACT_ERR
 * 
 * No Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_XCS_XACT_ERR
 * 
 * Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_E_ACVTIVE  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_MSB        12
/* The width in bits of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_XCS_XACT_ERR field value from a register. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HCINT0_XCS_XACT_ERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_XCS_XACT_ERR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Descriptor rollover interrupt - desc_lst_rollintr
 * 
 * Descriptor rollover interrupt (DESC_LST_ROLLIntr)This bit is valid only when
 * Scatter/Gather DMA mode is enabled. The core sets this bit when the
 * corresponding channel's descriptor list rolls over. for non Scatter/Gather DMA
 * mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                     
 * :----------------------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_INACT | 0x0   | No Descriptor rollover interrupt
 *  ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_ACT   | 0x1   | Descriptor rollover interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR
 * 
 * No Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR
 * 
 * Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR field value from a register. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT0_DESC_LST_ROLLINTR_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINT0.
 */
struct ALT_USB_HOST_HCINT0_s
{
    const uint32_t  xfercompl         :  1;  /* Transfer Completed */
    const uint32_t  chhltd            :  1;  /* Channel Halted */
    const uint32_t  ahberr            :  1;  /* AHB Error */
    const uint32_t  stall             :  1;  /* STALL Response Received Interrupt */
    const uint32_t  nak               :  1;  /* NAK Response Received Interrupt */
    const uint32_t  ack               :  1;  /* ACK Response Received Transmitted Interrupt */
    const uint32_t  nyet              :  1;  /* NYET Response Received Interrupt */
    const uint32_t  xacterr           :  1;  /* Transaction Error */
    const uint32_t  bblerr            :  1;  /* Babble Error */
    const uint32_t  frmovrun          :  1;  /* Frame Overrun */
    const uint32_t  datatglerr        :  1;  /* Data Toggle Error */
    const uint32_t  bnaintr           :  1;  /* BNA Interrupt */
    const uint32_t  xcs_xact_err      :  1;  /* Excessive Transaction Error */
    const uint32_t  desc_lst_rollintr :  1;  /* Descriptor rollover interrupt */
    uint32_t                          : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINT0. */
typedef volatile struct ALT_USB_HOST_HCINT0_s  ALT_USB_HOST_HCINT0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCINT0 register from the beginning of the component. */
#define ALT_USB_HOST_HCINT0_OFST        0x108
/* The address of the ALT_USB_HOST_HCINT0 register. */
#define ALT_USB_HOST_HCINT0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINT0_OFST))

/*
 * Register : Host Channel 0 Interrupt Mask Register - hcintmsk0
 * 
 * This register reflects the mask for each channel status described in the
 * previous section.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [0]     | RW     | 0x0   | Transfer Completed Mask          
 *  [1]     | RW     | 0x0   | Channel Halted Mask              
 *  [2]     | RW     | 0x0   | AHB Error Mask                   
 *  [10:3]  | ???    | 0x0   | *UNDEFINED*                      
 *  [11]    | RW     | 0x0   | BNA Interrupt  mask              
 *  [12]    | ???    | 0x0   | *UNDEFINED*                      
 *  [13]    | RW     | 0x0   | Framelist Rollover Interrupt Mask
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                      
 * 
 */
/*
 * Field : Transfer Completed Mask - xfercomplmsk
 * 
 * Transfer complete.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_XFERCOMPLMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Halted Mask - chhltdmsk
 * 
 * Channel Halted.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_CHHLTDMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_CHHLTDMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_CHHLTDMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINTMSK0_CHHLTDMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_CHHLTDMSK_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : AHB Error Mask - ahberrmsk
 * 
 * In  scatter/gather DMA  mode  for  host, interrupts will not be generated due to
 * the corresponding bits set in HCINTn.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_AHBERRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_AHBERRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_AHBERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINTMSK0_AHBERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_AHBERRMSK_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : BNA Interrupt  mask - bnaintrmsk
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_BNAINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_BNAINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_BNAINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINTMSK0_BNAINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_BNAINTRMSK_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Framelist Rollover Interrupt Mask - frm_lst_rollintrmsk
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK0_FRM_LST_ROLLINTRMSK_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINTMSK0.
 */
struct ALT_USB_HOST_HCINTMSK0_s
{
    uint32_t  xfercomplmsk        :  1;  /* Transfer Completed Mask */
    uint32_t  chhltdmsk           :  1;  /* Channel Halted Mask */
    uint32_t  ahberrmsk           :  1;  /* AHB Error Mask */
    uint32_t                      :  8;  /* *UNDEFINED* */
    uint32_t  bnaintrmsk          :  1;  /* BNA Interrupt  mask */
    uint32_t                      :  1;  /* *UNDEFINED* */
    uint32_t  frm_lst_rollintrmsk :  1;  /* Framelist Rollover Interrupt Mask */
    uint32_t                      : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINTMSK0. */
typedef volatile struct ALT_USB_HOST_HCINTMSK0_s  ALT_USB_HOST_HCINTMSK0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCINTMSK0 register from the beginning of the component. */
#define ALT_USB_HOST_HCINTMSK0_OFST        0x10c
/* The address of the ALT_USB_HOST_HCINTMSK0 register. */
#define ALT_USB_HOST_HCINTMSK0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINTMSK0_OFST))

/*
 * Register : Host Channel 0 Transfer Size Register - hctsiz0
 * 
 * Buffer DMA Mode
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description  
 * :--------|:-------|:------|:--------------
 *  [18:0]  | RW     | 0x0   | Transfer Size
 *  [28:19] | RW     | 0x0   | Packet Count 
 *  [30:29] | RW     | 0x0   | PID          
 *  [31]    | RW     | 0x0   | Do Ping      
 * 
 */
/*
 * Field : Transfer Size - xfersize
 * 
 * For an OUT, this field is the number of data bytes the host sends during the
 * transfer. for an IN, this field is the buffer size that the application has
 * Reserved for the transfer. The application is expected to program this field as
 * an integer multiple of the maximum packet size for IN transactions (periodic and
 * non-periodic).The width of this counter is specified as 19 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_MSB        18
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_WIDTH      19
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_SET_MSK    0x0007ffff
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_CLR_MSK    0xfff80000
/* The reset value of the ALT_USB_HOST_HCTSIZ0_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_XFERSIZE field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_GET(value) (((value) & 0x0007ffff) >> 0)
/* Produces a ALT_USB_HOST_HCTSIZ0_XFERSIZE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_XFERSIZE_SET(value) (((value) << 0) & 0x0007ffff)

/*
 * Field : Packet Count - pktcnt
 * 
 * This field is programmed by the application with the expected number of packets
 * to be transmitted (OUT) or received (IN). The host decrements this count on
 * every successful transmission or reception of an OUT/IN packet. Once this count
 * reaches zero, the application is interrupted to indicate normal completion. The
 * width of this counter is specified as 10 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_MSB        28
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_WIDTH      10
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_SET_MSK    0x1ff80000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_CLR_MSK    0xe007ffff
/* The reset value of the ALT_USB_HOST_HCTSIZ0_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_PKTCNT field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_GET(value) (((value) & 0x1ff80000) >> 19)
/* Produces a ALT_USB_HOST_HCTSIZ0_PKTCNT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_PKTCNT_SET(value) (((value) << 19) & 0x1ff80000)

/*
 * Field : PID - pid
 * 
 * The application programs this field with the type of PID to use forthe initial
 * transaction. The host maintains this field for the rest of the transfer.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCTSIZ0_PID_E_DATA0 | 0x0   | DATA0                              
 *  ALT_USB_HOST_HCTSIZ0_PID_E_DATA2 | 0x1   | DATA2                              
 *  ALT_USB_HOST_HCTSIZ0_PID_E_DATA1 | 0x2   | DATA1                              
 *  ALT_USB_HOST_HCTSIZ0_PID_E_MDATA | 0x3   | MDATA (non-control)/SETUP (control)
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * DATA0
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_DATA0    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * DATA2
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_DATA2    0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * DATA1
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_DATA1    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_PID
 * 
 * MDATA (non-control)/SETUP (control)
 */
#define ALT_USB_HOST_HCTSIZ0_PID_E_MDATA    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_MSB        30
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_PID register field value. */
#define ALT_USB_HOST_HCTSIZ0_PID_SET_MSK    0x60000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_PID register field value. */
#define ALT_USB_HOST_HCTSIZ0_PID_CLR_MSK    0x9fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ0_PID register field. */
#define ALT_USB_HOST_HCTSIZ0_PID_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_PID field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_PID_GET(value) (((value) & 0x60000000) >> 29)
/* Produces a ALT_USB_HOST_HCTSIZ0_PID register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_PID_SET(value) (((value) << 29) & 0x60000000)

/*
 * Field : Do Ping - dopng
 * 
 * This bit is used only for OUT transfers.Setting this field to 1 directs the host
 * to do PING protocol. Do not Set this bit for IN transfers. If this bit is set
 * for IN transfers it disables the channel.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCTSIZ0_DOPNG_E_NOPING | 0x0   | No ping protocol
 *  ALT_USB_HOST_HCTSIZ0_DOPNG_E_PING   | 0x1   | Ping protocol   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_DOPNG
 * 
 * No ping protocol
 */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_E_NOPING 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ0_DOPNG
 * 
 * Ping protocol
 */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_E_PING   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_MSB        31
/* The width in bits of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCTSIZ0_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ0_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ0_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ0_DOPNG field value from a register. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCTSIZ0_DOPNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ0_DOPNG_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCTSIZ0.
 */
struct ALT_USB_HOST_HCTSIZ0_s
{
    uint32_t  xfersize : 19;  /* Transfer Size */
    uint32_t  pktcnt   : 10;  /* Packet Count */
    uint32_t  pid      :  2;  /* PID */
    uint32_t  dopng    :  1;  /* Do Ping */
};

/* The typedef declaration for register ALT_USB_HOST_HCTSIZ0. */
typedef volatile struct ALT_USB_HOST_HCTSIZ0_s  ALT_USB_HOST_HCTSIZ0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCTSIZ0 register from the beginning of the component. */
#define ALT_USB_HOST_HCTSIZ0_OFST        0x110
/* The address of the ALT_USB_HOST_HCTSIZ0 register. */
#define ALT_USB_HOST_HCTSIZ0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCTSIZ0_OFST))

/*
 * Register : Host Channel 0 DMA Address Register - hcdma0
 * 
 * This register is used by the OTG host in the internal DMA mode to maintain the
 * current buffer pointer for IN/OUT transactions. The starting DMA address must be
 * DWORD-aligned.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [31:0] | RW     | 0x0   | DMA Address
 * 
 */
/*
 * Field : DMA Address - hcdma0
 * 
 * Non-Isochronous: This field holds the start address of the 512 bytes  page.  The
 * first descriptor in the list should be located in this address. The first
 * descriptor may be or may not be ready. The core starts processing the list from
 * the CTD value. This field holds the address of the 2*(nTD+1) bytes of locations
 * in which the isochronous descriptors are present where N is based on nTD as per
 * Table below
 * 
 * [31:N]  Base Address [N-1:3]  Offset  [2:0]  000
 * 
 * HS ISOC                           FS ISOC nTD   N                          nTD
 * N
 * 
 * 7     6                           1       4
 * 
 * 15    7                           3      5
 * 
 * 31    8                           7      6
 * 
 * 63    9                           15     7
 * 
 * 127  10                           31     8
 * 
 * 255  11                           63     9
 * 
 * [N-1:3] (Isoc):[8:3] (Non Isoc): Current Transfer Desc(CTD):  Non Isochronous:
 * This value is in terms of number of descriptors. The values can be from 0 to 63.
 * 
 * 0 -  1 descriptor.
 * 
 * 63 - 64 descriptors.
 * 
 * This field indicates the current descriptor processed in the list. This field is
 * updated both by application and the core. for example, if the application
 * enables the channel after programming CTD=5, then the core will start processing
 * the 6th descriptor. The address is obtained by adding a value of (8bytes*5=)
 * 40(decimal)  to DMAAddr.  Isochronous: CTD for isochronous is based on the
 * current frame/microframe value. Need to be set to zero by application.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMA0_HCDMA0 register field value. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMA0_HCDMA0 register field value. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMA0_HCDMA0 register field. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMA0_HCDMA0 field value from a register. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMA0_HCDMA0 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMA0_HCDMA0_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMA0.
 */
struct ALT_USB_HOST_HCDMA0_s
{
    uint32_t  hcdma0 : 32;  /* DMA Address */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMA0. */
typedef volatile struct ALT_USB_HOST_HCDMA0_s  ALT_USB_HOST_HCDMA0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCDMA0 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMA0_OFST        0x114
/* The address of the ALT_USB_HOST_HCDMA0 register. */
#define ALT_USB_HOST_HCDMA0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMA0_OFST))

/*
 * Register : Host Channel 0 DMA Buffer Address Register - hcdmab0
 * 
 * These  registers  are  present  only  in  case  of  Scatter/Gather  DMA. These
 * registers  are  implemented  in RAM instead of flop-based implementation. Holds
 * the  current  buffer  address.  This  register  is  updated  as  and when  the
 * data  transfer  for  the corresponding  end  point  is  in progress.  This
 * register  is  present  only  in  Scatter/Gather  DMA mode. Otherwise this field
 * is reserved.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                      
 * :-------|:-------|:------|:----------------------------------
 *  [31:0] | RW     | 0x0   | Host Channel 0 DMA Buffer Address
 * 
 */
/*
 * Field : Host Channel 0 DMA Buffer Address - hcdmab0
 * 
 * These  registers  are  present  only  in  case  of  Scatter/Gather DMA. These
 * registers  are  implemented  in RAM instead of flop-based implementation. Holds
 * the  current  buffer  address. This register is updated as and when  the  data
 * transfer for the corresponding  end  point  is  in progress. This register  is
 * present  only  in Scatter/Gather DMA mode. Otherwise this field is reserved.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field value. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field value. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMAB0_HCDMAB0 register field. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMAB0_HCDMAB0 field value from a register. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMAB0_HCDMAB0 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMAB0_HCDMAB0_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMAB0.
 */
struct ALT_USB_HOST_HCDMAB0_s
{
    uint32_t  hcdmab0 : 32;  /* Host Channel 0 DMA Buffer Address */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMAB0. */
typedef volatile struct ALT_USB_HOST_HCDMAB0_s  ALT_USB_HOST_HCDMAB0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCDMAB0 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMAB0_OFST        0x118
/* The address of the ALT_USB_HOST_HCDMAB0 register. */
#define ALT_USB_HOST_HCDMAB0_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMAB0_OFST))

/*
 * Register : Host Channel 1 Characteristics Register - hcchar1
 * 
 * Host Channel 1 Characteristics Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description        
 * :--------|:-------|:------|:--------------------
 *  [10:0]  | RW     | 0x0   | Maximum Packet Size
 *  [14:11] | RW     | 0x0   | Endpoint Number    
 *  [15]    | RW     | 0x0   | Endpoint Direction 
 *  [16]    | ???    | 0x0   | *UNDEFINED*        
 *  [17]    | RW     | 0x0   | Low-Speed Device   
 *  [19:18] | RW     | 0x0   | Endpoint Type      
 *  [21:20] | RW     | 0x0   | Multi Count        
 *  [28:22] | RW     | 0x0   | Device Address     
 *  [29]    | ???    | 0x0   | *UNDEFINED*        
 *  [30]    | R      | 0x0   | Channel Disable    
 *  [31]    | R      | 0x0   | Channel Enable     
 * 
 */
/*
 * Field : Maximum Packet Size - mps
 * 
 * Indicates the maximum packet size of the associated endpoint.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_MSB        10
/* The width in bits of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_WIDTH      11
/* The mask used to set the ALT_USB_HOST_HCCHAR1_MPS register field value. */
#define ALT_USB_HOST_HCCHAR1_MPS_SET_MSK    0x000007ff
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_MPS register field value. */
#define ALT_USB_HOST_HCCHAR1_MPS_CLR_MSK    0xfffff800
/* The reset value of the ALT_USB_HOST_HCCHAR1_MPS register field. */
#define ALT_USB_HOST_HCCHAR1_MPS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_MPS field value from a register. */
#define ALT_USB_HOST_HCCHAR1_MPS_GET(value) (((value) & 0x000007ff) >> 0)
/* Produces a ALT_USB_HOST_HCCHAR1_MPS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_MPS_SET(value) (((value) << 0) & 0x000007ff)

/*
 * Field : Endpoint Number - epnum
 * 
 * Indicates the endpoint number on the device serving as the data source or sink.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  0
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  1
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  2
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  3
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  4
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  5
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  6
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  7
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  8
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  9
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  10
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  11
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  12
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  13
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  14
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPNUM
 * 
 * End point  15
 */
#define ALT_USB_HOST_HCCHAR1_EPNUM_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_MSB        14
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_SET_MSK    0x00007800
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_CLR_MSK    0xffff87ff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EPNUM field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_GET(value) (((value) & 0x00007800) >> 11)
/* Produces a ALT_USB_HOST_HCCHAR1_EPNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EPNUM_SET(value) (((value) << 11) & 0x00007800)

/*
 * Field : Endpoint Direction - epdir
 * 
 * Indicates whether the transaction is IN or OUT.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description  
 * :---------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR1_EPDIR_E_OUT | 0x0   | OUT Direction
 *  ALT_USB_HOST_HCCHAR1_EPDIR_E_IN  | 0x1   | IN Direction 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPDIR
 * 
 * OUT Direction
 */
#define ALT_USB_HOST_HCCHAR1_EPDIR_E_OUT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPDIR
 * 
 * IN Direction
 */
#define ALT_USB_HOST_HCCHAR1_EPDIR_E_IN     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_MSB        15
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EPDIR field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_HOST_HCCHAR1_EPDIR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EPDIR_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : Low-Speed Device - lspddev
 * 
 * This field is set by the application to indicate that this channel is
 * communicating to a low-speed device. The application must program this bit when
 * a low speed device is connected to the host through an FS HUB. The HS OTG Host
 * core uses this field to drive the XCVR_SELECT signal to 0x3 while communicating
 * to the LS Device through the FS hub. In a peer to peer setup, the HS OTG Host
 * core ignores this bit even if it is set by the application software
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                            
 * :------------------------------------|:------|:----------------------------------------
 *  ALT_USB_HOST_HCCHAR1_LSPDDEV_E_DISD | 0x0   | Not Communicating with low speed device
 *  ALT_USB_HOST_HCCHAR1_LSPDDEV_E_END  | 0x1   | Communicating with low speed device    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_LSPDDEV
 * 
 * Not Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_LSPDDEV
 * 
 * Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_MSB        17
/* The width in bits of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_LSPDDEV field value from a register. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_HOST_HCCHAR1_LSPDDEV register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_LSPDDEV_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : Endpoint Type - eptype
 * 
 * Indicates the transfer type selected.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_CTL    | 0x0   | Control    
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_ISOC   | 0x1   | Isochronous
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_BULK   | 0x2   | Bulk       
 *  ALT_USB_HOST_HCCHAR1_EPTYPE_E_INTERR | 0x3   | Interrupt  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Control
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_CTL       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Isochronous
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_ISOC      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Bulk
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_BULK      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EPTYPE
 * 
 * Interrupt
 */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_E_INTERR    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_MSB        19
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_SET_MSK    0x000c0000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_CLR_MSK    0xfff3ffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EPTYPE field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_GET(value) (((value) & 0x000c0000) >> 18)
/* Produces a ALT_USB_HOST_HCCHAR1_EPTYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EPTYPE_SET(value) (((value) << 18) & 0x000c0000)

/*
 * Field : Multi Count - ec
 * 
 * When the Split Enable bit of the Host Channel-n Split Control register
 * (HCSPLTn.SpltEna) is reset (0), this field indicates to the host the number of
 * transactions that must be executed per microframe for this periodic endpoint.
 * for non periodic transfers, this field is used only in DMA mode, and specifies
 * the number packets to be fetched for this channel before the internal DMA engine
 * changes arbitration. When HCSPLTn.SpltEna is Set (1), this field indicates the
 * number of immediate retries to be performed for a periodic split transactions on
 * transaction errors. This field must be set to at least 1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                  
 * :-------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_HOST_HCCHAR1_EC_E_RSVD       | 0x0   | Reserved This field yields undefined result  
 *  ALT_USB_HOST_HCCHAR1_EC_E_TRANSONE   | 0x1   | 1 transaction                                
 *  ALT_USB_HOST_HCCHAR1_EC_E_TRANSTWO   | 0x2   | 2 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 *  ALT_USB_HOST_HCCHAR1_EC_E_TRANSTHREE | 0x3   | 3 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * Reserved This field yields undefined result
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_RSVD          0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * 1 transaction
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_TRANSONE      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * 2 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_TRANSTWO      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_EC
 * 
 * 3 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR1_EC_E_TRANSTHREE    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_MSB        21
/* The width in bits of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR1_EC register field value. */
#define ALT_USB_HOST_HCCHAR1_EC_SET_MSK    0x00300000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_EC register field value. */
#define ALT_USB_HOST_HCCHAR1_EC_CLR_MSK    0xffcfffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_EC register field. */
#define ALT_USB_HOST_HCCHAR1_EC_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_EC field value from a register. */
#define ALT_USB_HOST_HCCHAR1_EC_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_USB_HOST_HCCHAR1_EC register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_EC_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : Device Address - devaddr
 * 
 * This field selects the specific device serving as the data source or sink.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_MSB        28
/* The width in bits of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCCHAR1_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_SET_MSK    0x1fc00000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_CLR_MSK    0xe03fffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_DEVADDR field value from a register. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_GET(value) (((value) & 0x1fc00000) >> 22)
/* Produces a ALT_USB_HOST_HCCHAR1_DEVADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_DEVADDR_SET(value) (((value) << 22) & 0x1fc00000)

/*
 * Field : Channel Disable - chdis
 * 
 * The application sets this bit to stop transmitting/receiving data on a channel,
 * even before the transfer for that channel is complete. The application must wait
 * for the Channel Disabled interrupt before treating the channel as disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                
 * :-----------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HCCHAR1_CHDIS_E_INACT | 0x0   | Transmit/Recieve normal    
 *  ALT_USB_HOST_HCCHAR1_CHDIS_E_ACT   | 0x1   | Stop transmitting/receiving
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHDIS
 * 
 * Transmit/Recieve normal
 */
#define ALT_USB_HOST_HCCHAR1_CHDIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHDIS
 * 
 * Stop transmitting/receiving
 */
#define ALT_USB_HOST_HCCHAR1_CHDIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_MSB        30
/* The width in bits of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_CHDIS field value from a register. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_HOST_HCCHAR1_CHDIS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_CHDIS_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Channel Enable - chena
 * 
 * When Scatter/Gather mode is disabled This field is set by the application and
 * cleared by the OTG host.
 * 
 * 0: Channel disabled
 * 
 * 1: Channel enabled
 * 
 * When Scatter/Gather mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                     
 * :-----------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_HOST_HCCHAR1_CHENA_E_INACT | 0x0   | Indicates that the descriptor structure is not  
 * :                                   |       | yet ready                                       
 *  ALT_USB_HOST_HCCHAR1_CHENA_E_ACT   | 0x1   | Indicates  that  the  descriptor  structure  and
 * :                                   |       | data  buffer  with data is setup and this       
 * :                                   |       | channel can access the descriptor               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHENA
 * 
 * Indicates that the descriptor structure is not yet ready
 */
#define ALT_USB_HOST_HCCHAR1_CHENA_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR1_CHENA
 * 
 * Indicates  that  the  descriptor  structure  and  data  buffer  with data is
 * setup and this channel can access the descriptor
 */
#define ALT_USB_HOST_HCCHAR1_CHENA_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR1_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR1_CHENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR1_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR1_CHENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCCHAR1_CHENA register field. */
#define ALT_USB_HOST_HCCHAR1_CHENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR1_CHENA field value from a register. */
#define ALT_USB_HOST_HCCHAR1_CHENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCCHAR1_CHENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR1_CHENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCCHAR1.
 */
struct ALT_USB_HOST_HCCHAR1_s
{
    uint32_t        mps     : 11;  /* Maximum Packet Size */
    uint32_t        epnum   :  4;  /* Endpoint Number */
    uint32_t        epdir   :  1;  /* Endpoint Direction */
    uint32_t                :  1;  /* *UNDEFINED* */
    uint32_t        lspddev :  1;  /* Low-Speed Device */
    uint32_t        eptype  :  2;  /* Endpoint Type */
    uint32_t        ec      :  2;  /* Multi Count */
    uint32_t        devaddr :  7;  /* Device Address */
    uint32_t                :  1;  /* *UNDEFINED* */
    const uint32_t  chdis   :  1;  /* Channel Disable */
    const uint32_t  chena   :  1;  /* Channel Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCCHAR1. */
typedef volatile struct ALT_USB_HOST_HCCHAR1_s  ALT_USB_HOST_HCCHAR1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCCHAR1 register from the beginning of the component. */
#define ALT_USB_HOST_HCCHAR1_OFST        0x120
/* The address of the ALT_USB_HOST_HCCHAR1 register. */
#define ALT_USB_HOST_HCCHAR1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCCHAR1_OFST))

/*
 * Register : Host Channel 1 Split Control Register - hcsplt1
 * 
 * Channel_number 1
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description         
 * :--------|:-------|:------|:---------------------
 *  [6:0]   | RW     | 0x0   | Port Address        
 *  [13:7]  | RW     | 0x0   | Hub Address         
 *  [15:14] | RW     | 0x0   | Transaction Position
 *  [16]    | RW     | 0x0   | Do Complete Split   
 *  [30:17] | ???    | 0x0   | *UNDEFINED*         
 *  [31]    | RW     | 0x0   | Split Enable        
 * 
 */
/*
 * Field : Port Address - prtaddr
 * 
 * This field is the port number of the recipient transactiontranslator.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_MSB        6
/* The width in bits of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT1_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_SET_MSK    0x0000007f
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_CLR_MSK    0xffffff80
/* The reset value of the ALT_USB_HOST_HCSPLT1_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_PRTADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_GET(value) (((value) & 0x0000007f) >> 0)
/* Produces a ALT_USB_HOST_HCSPLT1_PRTADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_PRTADDR_SET(value) (((value) << 0) & 0x0000007f)

/*
 * Field : Hub Address - hubaddr
 * 
 * This field holds the device address of the transaction translator's hub.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT1_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_SET_MSK    0x00003f80
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_CLR_MSK    0xffffc07f
/* The reset value of the ALT_USB_HOST_HCSPLT1_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_HUBADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_GET(value) (((value) & 0x00003f80) >> 7)
/* Produces a ALT_USB_HOST_HCSPLT1_HUBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_HUBADDR_SET(value) (((value) << 7) & 0x00003f80)

/*
 * Field : Transaction Position - xactpos
 * 
 * This field is used to determine whether to send all, first, middle, or last
 * payloads with each OUT transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_MIDDLE | 0x0   | Mid. This is the middle payload of this        
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_END    | 0x1   | End. This is the last payload of this          
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_BEGIN  | 0x2   | Begin. This is the first data payload of this  
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT1_XACTPOS_E_ALL    | 0x3   | All. This is the entire data payload is of this
 * :                                      |       | transaction (which is less than or equal to 188
 * :                                      |       | bytes)                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * Mid. This is the middle payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_MIDDLE   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * End. This is the last payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_END      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * Begin. This is the first data payload of this transaction (which is larger than
 * 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_BEGIN    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_XACTPOS
 * 
 * All. This is the entire data payload is of this transaction (which is less than
 * or equal to 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_E_ALL      0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_MSB        15
/* The width in bits of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCSPLT1_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_HOST_HCSPLT1_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_XACTPOS field value from a register. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_HOST_HCSPLT1_XACTPOS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_XACTPOS_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : Do Complete Split - compsplt
 * 
 * The application sets this field to request the OTG host to perform a complete
 * split transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCSPLT1_COMPSPLT_E_NOSPLIT | 0x0   | No split transaction
 *  ALT_USB_HOST_HCSPLT1_COMPSPLT_E_SPLIT   | 0x1   | Split transaction   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_COMPSPLT
 * 
 * No split transaction
 */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_E_NOSPLIT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_COMPSPLT
 * 
 * Split transaction
 */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_E_SPLIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_MSB        16
/* The width in bits of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT1_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HCSPLT1_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_COMPSPLT field value from a register. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HCSPLT1_COMPSPLT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_COMPSPLT_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : Split Enable - spltena
 * 
 * The application sets this field to indicate that this channel is enabled to
 * perform split transactions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HCSPLT1_SPLTENA_E_DISD | 0x0   | Split not enabled
 *  ALT_USB_HOST_HCSPLT1_SPLTENA_E_END  | 0x1   | Split enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_SPLTENA
 * 
 * Split not enabled
 */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT1_SPLTENA
 * 
 * Split enabled
 */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT1_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCSPLT1_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCSPLT1_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT1_SPLTENA field value from a register. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCSPLT1_SPLTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT1_SPLTENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCSPLT1.
 */
struct ALT_USB_HOST_HCSPLT1_s
{
    uint32_t  prtaddr  :  7;  /* Port Address */
    uint32_t  hubaddr  :  7;  /* Hub Address */
    uint32_t  xactpos  :  2;  /* Transaction Position */
    uint32_t  compsplt :  1;  /* Do Complete Split */
    uint32_t           : 14;  /* *UNDEFINED* */
    uint32_t  spltena  :  1;  /* Split Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCSPLT1. */
typedef volatile struct ALT_USB_HOST_HCSPLT1_s  ALT_USB_HOST_HCSPLT1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCSPLT1 register from the beginning of the component. */
#define ALT_USB_HOST_HCSPLT1_OFST        0x124
/* The address of the ALT_USB_HOST_HCSPLT1 register. */
#define ALT_USB_HOST_HCSPLT1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCSPLT1_OFST))

/*
 * Register : Host Channel 1 Interrupt Register - hcint1
 * 
 * This register indicates the status of a channel with respect to USB- and AHB-
 * related events. The application must read this register when the Host Channels
 * Interrupt bit of the Core Interrupt register (GINTSTS.HChInt) is set. Before the
 * application can read this register, it must first read the Host All Channels
 * Interrupt (HAINT) register to get the exact channel number for the Host
 * Channel-n Interrupt register. The application must clear the appropriate bit in
 * this register to clear the corresponding bits in the HAINT and GINTSTS
 * registers.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                
 * :--------|:-------|:------|:--------------------------------------------
 *  [0]     | R      | 0x0   | Transfer Completed                         
 *  [1]     | R      | 0x0   | Channel Halted                             
 *  [2]     | R      | 0x0   | AHB Error                                  
 *  [3]     | R      | 0x0   | STALL Response Received Interrupt          
 *  [4]     | R      | 0x0   | NAK Response Received Interrupt            
 *  [5]     | R      | 0x0   | ACK Response Received Transmitted Interrupt
 *  [6]     | R      | 0x0   | NYET Response Received Interrupt           
 *  [7]     | R      | 0x0   | Transaction Error                          
 *  [8]     | R      | 0x0   | Babble Error                               
 *  [9]     | R      | 0x0   | Frame Overrun                              
 *  [10]    | R      | 0x0   | Data Toggle Error                          
 *  [11]    | R      | 0x0   | BNA Interrupt                              
 *  [12]    | R      | 0x0   | Excessive Transaction Error                
 *  [13]    | R      | 0x0   | Descriptor rollover interrupt              
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                                
 * 
 */
/*
 * Field : Transfer Completed - xfercompl
 * 
 * Transfer completed normally without any errors. This bit can be set only by the
 * core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT1_XFERCOMPL_E_INACT | 0x0   | No transfer                                   
 *  ALT_USB_HOST_HCINT1_XFERCOMPL_E_ACT   | 0x1   | Transfer completed normally without any errors
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XFERCOMPL
 * 
 * No transfer
 */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XFERCOMPL
 * 
 * Transfer completed normally without any errors
 */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINT1_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINT1_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_XFERCOMPL field value from a register. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINT1_XFERCOMPL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_XFERCOMPL_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Halted - chhltd
 * 
 * In non Scatter/Gather DMA mode, it indicates the transfer completed abnormally
 * either because of any USB transaction error or in response to disable request by
 * the application or because of a completed transfer. In Scatter/gather DMA mode,
 * this indicates that transfer completed due to any of the following
 * 
 * . EOL being set in descriptor
 * 
 * . AHB error
 * 
 * . Excessive transaction errors
 * 
 * . Babble
 * 
 * . Stall
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description       
 * :-----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT1_CHHLTD_E_INACT | 0x0   | Channel not halted
 *  ALT_USB_HOST_HCINT1_CHHLTD_E_ACT   | 0x1   | Channel Halted    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_CHHLTD
 * 
 * Channel not halted
 */
#define ALT_USB_HOST_HCINT1_CHHLTD_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_CHHLTD
 * 
 * Channel Halted
 */
#define ALT_USB_HOST_HCINT1_CHHLTD_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT1_CHHLTD_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINT1_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT1_CHHLTD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINT1_CHHLTD register field. */
#define ALT_USB_HOST_HCINT1_CHHLTD_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_CHHLTD field value from a register. */
#define ALT_USB_HOST_HCINT1_CHHLTD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINT1_CHHLTD register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_CHHLTD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : AHB Error - ahberr
 * 
 * This is generated only in Internal DMA mode when there is an AHB error during
 * AHB read/write. The application can read the corresponding channel's DMA address
 * register to get the error address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                    
 * :-----------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCINT1_AHBERR_E_INACT | 0x0   | No AHB error                   
 *  ALT_USB_HOST_HCINT1_AHBERR_E_ACT   | 0x1   | AHB error during AHB read/write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_AHBERR
 * 
 * No AHB error
 */
#define ALT_USB_HOST_HCINT1_AHBERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_AHBERR
 * 
 * AHB error during AHB read/write
 */
#define ALT_USB_HOST_HCINT1_AHBERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_AHBERR register field value. */
#define ALT_USB_HOST_HCINT1_AHBERR_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINT1_AHBERR register field value. */
#define ALT_USB_HOST_HCINT1_AHBERR_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINT1_AHBERR register field. */
#define ALT_USB_HOST_HCINT1_AHBERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_AHBERR field value from a register. */
#define ALT_USB_HOST_HCINT1_AHBERR_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINT1_AHBERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_AHBERR_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : STALL Response Received Interrupt - stall
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description       
 * :----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT1_STALL_E_INACT | 0x0   | No Stall Interrupt
 *  ALT_USB_HOST_HCINT1_STALL_E_ACT   | 0x1   | Stall Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_STALL
 * 
 * No Stall Interrupt
 */
#define ALT_USB_HOST_HCINT1_STALL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_STALL
 * 
 * Stall Interrupt
 */
#define ALT_USB_HOST_HCINT1_STALL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_STALL register field value. */
#define ALT_USB_HOST_HCINT1_STALL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINT1_STALL register field value. */
#define ALT_USB_HOST_HCINT1_STALL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINT1_STALL register field. */
#define ALT_USB_HOST_HCINT1_STALL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_STALL field value from a register. */
#define ALT_USB_HOST_HCINT1_STALL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINT1_STALL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_STALL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NAK Response Received Interrupt - nak
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_USB_HOST_HCINT1_NAK_E_INACT | 0x0   | No NAK Response Received Interrupt
 *  ALT_USB_HOST_HCINT1_NAK_E_ACT   | 0x1   | NAK Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NAK
 * 
 * No NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NAK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NAK
 * 
 * NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NAK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_NAK register field value. */
#define ALT_USB_HOST_HCINT1_NAK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINT1_NAK register field value. */
#define ALT_USB_HOST_HCINT1_NAK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINT1_NAK register field. */
#define ALT_USB_HOST_HCINT1_NAK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_NAK field value from a register. */
#define ALT_USB_HOST_HCINT1_NAK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINT1_NAK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_NAK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ACK Response Received Transmitted Interrupt - ack
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                   
 * :--------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT1_ACK_E_INACT | 0x0   | No ACK Response Received Transmitted Interrupt
 *  ALT_USB_HOST_HCINT1_ACK_E_ACT   | 0x1   | ACK Response Received Transmitted Interrup    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_ACK
 * 
 * No ACK Response Received Transmitted Interrupt
 */
#define ALT_USB_HOST_HCINT1_ACK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_ACK
 * 
 * ACK Response Received Transmitted Interrup
 */
#define ALT_USB_HOST_HCINT1_ACK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_ACK register field value. */
#define ALT_USB_HOST_HCINT1_ACK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINT1_ACK register field value. */
#define ALT_USB_HOST_HCINT1_ACK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINT1_ACK register field. */
#define ALT_USB_HOST_HCINT1_ACK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_ACK field value from a register. */
#define ALT_USB_HOST_HCINT1_ACK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINT1_ACK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_ACK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NYET Response Received Interrupt - nyet
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCINT1_NYET_E_INACT | 0x0   | No NYET Response Received Interrupt
 *  ALT_USB_HOST_HCINT1_NYET_E_ACT   | 0x1   | NYET Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NYET
 * 
 * No NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NYET_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_NYET
 * 
 * NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT1_NYET_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_NYET register field value. */
#define ALT_USB_HOST_HCINT1_NYET_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINT1_NYET register field value. */
#define ALT_USB_HOST_HCINT1_NYET_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINT1_NYET register field. */
#define ALT_USB_HOST_HCINT1_NYET_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_NYET field value from a register. */
#define ALT_USB_HOST_HCINT1_NYET_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINT1_NYET register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_NYET_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Transaction Error - xacterr
 * 
 * Indicates one of the following errors occurred on the USB.-CRC check failure
 * 
 * * Timeout
 * 
 * * Bit stuff error
 * 
 * * False EOP
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description         
 * :------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT1_XACTERR_E_INACT | 0x0   | No Transaction Error
 *  ALT_USB_HOST_HCINT1_XACTERR_E_ACT   | 0x1   | Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XACTERR
 * 
 * No Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XACTERR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XACTERR
 * 
 * Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XACTERR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_XACTERR register field value. */
#define ALT_USB_HOST_HCINT1_XACTERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINT1_XACTERR register field value. */
#define ALT_USB_HOST_HCINT1_XACTERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINT1_XACTERR register field. */
#define ALT_USB_HOST_HCINT1_XACTERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_XACTERR field value from a register. */
#define ALT_USB_HOST_HCINT1_XACTERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINT1_XACTERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_XACTERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Babble Error - bblerr
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core..This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description    
 * :-----------------------------------|:------|:----------------
 *  ALT_USB_HOST_HCINT1_BBLERR_E_INACT | 0x0   | No Babble Error
 *  ALT_USB_HOST_HCINT1_BBLERR_E_ACT   | 0x1   | Babble Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BBLERR
 * 
 * No Babble Error
 */
#define ALT_USB_HOST_HCINT1_BBLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BBLERR
 * 
 * Babble Error
 */
#define ALT_USB_HOST_HCINT1_BBLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_BBLERR register field value. */
#define ALT_USB_HOST_HCINT1_BBLERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINT1_BBLERR register field value. */
#define ALT_USB_HOST_HCINT1_BBLERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINT1_BBLERR register field. */
#define ALT_USB_HOST_HCINT1_BBLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_BBLERR field value from a register. */
#define ALT_USB_HOST_HCINT1_BBLERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINT1_BBLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_BBLERR_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Frame Overrun - frmovrun
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description     
 * :-------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT1_FRMOVRUN_E_INACT | 0x0   | No Frame Overrun
 *  ALT_USB_HOST_HCINT1_FRMOVRUN_E_ACT   | 0x1   | Frame Overrun   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_FRMOVRUN
 * 
 * No Frame Overrun
 */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_FRMOVRUN
 * 
 * Frame Overrun
 */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINT1_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINT1_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_FRMOVRUN field value from a register. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINT1_FRMOVRUN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_FRMOVRUN_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Data Toggle Error - datatglerr
 * 
 * This bit can be set only by the core and the application should write 1 to clear
 * it. In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT1_DATATGLERR_E_INACT | 0x0   | No Data Toggle Error
 *  ALT_USB_HOST_HCINT1_DATATGLERR_E_ACT   | 0x1   | Data Toggle Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DATATGLERR
 * 
 * No Data Toggle Error
 */
#define ALT_USB_HOST_HCINT1_DATATGLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DATATGLERR
 * 
 * Data Toggle Error
 */
#define ALT_USB_HOST_HCINT1_DATATGLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINT1_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINT1_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_DATATGLERR field value from a register. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINT1_DATATGLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_DATATGLERR_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : BNA Interrupt - bnaintr
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core
 * generates this interrupt when the descriptor accessed is not ready for the Core
 * to process. BNA will not be generated for Isochronous channels. for non
 * Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT1_BNAINTR_E_INACT | 0x0   | No BNA Interrupt
 *  ALT_USB_HOST_HCINT1_BNAINTR_E_ACT   | 0x1   | BNA Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BNAINTR
 * 
 * No BNA Interrupt
 */
#define ALT_USB_HOST_HCINT1_BNAINTR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_BNAINTR
 * 
 * BNA Interrupt
 */
#define ALT_USB_HOST_HCINT1_BNAINTR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT1_BNAINTR_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINT1_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT1_BNAINTR_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINT1_BNAINTR register field. */
#define ALT_USB_HOST_HCINT1_BNAINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_BNAINTR field value from a register. */
#define ALT_USB_HOST_HCINT1_BNAINTR_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINT1_BNAINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_BNAINTR_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Excessive Transaction Error - xcs_xact_err
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit when 3 consecutive transaction errors occurred on the USB bus.
 * XCS_XACT_ERR will not be generated for Isochronous channels.for non
 * Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                   
 * :-------------------------------------------|:------|:-------------------------------
 *  ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_INACT   | 0x0   | No Excessive Transaction Error
 *  ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_ACVTIVE | 0x1   | Excessive Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XCS_XACT_ERR
 * 
 * No Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_XCS_XACT_ERR
 * 
 * Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_E_ACVTIVE  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_MSB        12
/* The width in bits of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_XCS_XACT_ERR field value from a register. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HCINT1_XCS_XACT_ERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_XCS_XACT_ERR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Descriptor rollover interrupt - desc_lst_rollintr
 * 
 * Descriptor rollover interrupt (DESC_LST_ROLLIntr)This bit is valid only when
 * Scatter/Gather DMA mode is enabled. The core sets this bit when the
 * corresponding channel's descriptor list rolls over. for non Scatter/Gather DMA
 * mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                     
 * :----------------------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_INACT | 0x0   | No Descriptor rollover interrupt
 *  ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_ACT   | 0x1   | Descriptor rollover interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR
 * 
 * No Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR
 * 
 * Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR field value from a register. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT1_DESC_LST_ROLLINTR_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINT1.
 */
struct ALT_USB_HOST_HCINT1_s
{
    const uint32_t  xfercompl         :  1;  /* Transfer Completed */
    const uint32_t  chhltd            :  1;  /* Channel Halted */
    const uint32_t  ahberr            :  1;  /* AHB Error */
    const uint32_t  stall             :  1;  /* STALL Response Received Interrupt */
    const uint32_t  nak               :  1;  /* NAK Response Received Interrupt */
    const uint32_t  ack               :  1;  /* ACK Response Received Transmitted Interrupt */
    const uint32_t  nyet              :  1;  /* NYET Response Received Interrupt */
    const uint32_t  xacterr           :  1;  /* Transaction Error */
    const uint32_t  bblerr            :  1;  /* Babble Error */
    const uint32_t  frmovrun          :  1;  /* Frame Overrun */
    const uint32_t  datatglerr        :  1;  /* Data Toggle Error */
    const uint32_t  bnaintr           :  1;  /* BNA Interrupt */
    const uint32_t  xcs_xact_err      :  1;  /* Excessive Transaction Error */
    const uint32_t  desc_lst_rollintr :  1;  /* Descriptor rollover interrupt */
    uint32_t                          : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINT1. */
typedef volatile struct ALT_USB_HOST_HCINT1_s  ALT_USB_HOST_HCINT1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCINT1 register from the beginning of the component. */
#define ALT_USB_HOST_HCINT1_OFST        0x128
/* The address of the ALT_USB_HOST_HCINT1 register. */
#define ALT_USB_HOST_HCINT1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINT1_OFST))

/*
 * Register : Host Channel 1 Interrupt Mask Register - hcintmsk1
 * 
 * This register reflects the mask for each channel status described in the
 * previous section.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [0]     | RW     | 0x0   | Transfer Completed Mask          
 *  [1]     | RW     | 0x0   | Channel Halted Mask              
 *  [2]     | RW     | 0x0   | AHB Error Mask                   
 *  [10:3]  | ???    | 0x0   | *UNDEFINED*                      
 *  [11]    | RW     | 0x0   | BNA Interrupt  mask              
 *  [12]    | ???    | 0x0   | *UNDEFINED*                      
 *  [13]    | RW     | 0x0   | Framelist Rollover Interrupt Mask
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                      
 * 
 */
/*
 * Field : Transfer Completed Mask - xfercomplmsk
 * 
 * Transfer complete.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_XFERCOMPLMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Halted Mask - chhltdmsk
 * 
 * Channel Halted.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_CHHLTDMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_CHHLTDMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_CHHLTDMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINTMSK1_CHHLTDMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_CHHLTDMSK_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : AHB Error Mask - ahberrmsk
 * 
 * In  scatter/gather DMA  mode  for  host, interrupts will not be generated due to
 * the corresponding bits set in HCINTn.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_AHBERRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_AHBERRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_AHBERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINTMSK1_AHBERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_AHBERRMSK_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : BNA Interrupt  mask - bnaintrmsk
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_BNAINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_BNAINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_BNAINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINTMSK1_BNAINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_BNAINTRMSK_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Framelist Rollover Interrupt Mask - frm_lst_rollintrmsk
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK1_FRM_LST_ROLLINTRMSK_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINTMSK1.
 */
struct ALT_USB_HOST_HCINTMSK1_s
{
    uint32_t  xfercomplmsk        :  1;  /* Transfer Completed Mask */
    uint32_t  chhltdmsk           :  1;  /* Channel Halted Mask */
    uint32_t  ahberrmsk           :  1;  /* AHB Error Mask */
    uint32_t                      :  8;  /* *UNDEFINED* */
    uint32_t  bnaintrmsk          :  1;  /* BNA Interrupt  mask */
    uint32_t                      :  1;  /* *UNDEFINED* */
    uint32_t  frm_lst_rollintrmsk :  1;  /* Framelist Rollover Interrupt Mask */
    uint32_t                      : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINTMSK1. */
typedef volatile struct ALT_USB_HOST_HCINTMSK1_s  ALT_USB_HOST_HCINTMSK1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCINTMSK1 register from the beginning of the component. */
#define ALT_USB_HOST_HCINTMSK1_OFST        0x12c
/* The address of the ALT_USB_HOST_HCINTMSK1 register. */
#define ALT_USB_HOST_HCINTMSK1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINTMSK1_OFST))

/*
 * Register : Host Channel 1 Transfer Size Register - hctsiz1
 * 
 * Buffer DMA Mode
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description  
 * :--------|:-------|:------|:--------------
 *  [18:0]  | RW     | 0x0   | Transfer Size
 *  [28:19] | RW     | 0x0   | Packet Count 
 *  [30:29] | RW     | 0x0   | PID          
 *  [31]    | RW     | 0x0   | Do Ping      
 * 
 */
/*
 * Field : Transfer Size - xfersize
 * 
 * for an OUT, this field is the number of data bytes the host sends during the
 * transfer. for an IN, this field is the buffer size that the application has
 * Reserved for the transfer. The application is expected to program this field as
 * an integer multiple of the maximum packet size for IN transactions (periodic and
 * non-periodic).The width of this counter is specified as 19 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_MSB        18
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_WIDTH      19
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_SET_MSK    0x0007ffff
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_CLR_MSK    0xfff80000
/* The reset value of the ALT_USB_HOST_HCTSIZ1_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_XFERSIZE field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_GET(value) (((value) & 0x0007ffff) >> 0)
/* Produces a ALT_USB_HOST_HCTSIZ1_XFERSIZE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_XFERSIZE_SET(value) (((value) << 0) & 0x0007ffff)

/*
 * Field : Packet Count - pktcnt
 * 
 * This field is programmed by the application with the expected number of packets
 * to be transmitted (OUT) or received (IN). The host decrements this count on
 * every successful transmission or reception of an OUT/IN packet. Once this count
 * reaches zero, the application is interrupted to indicate normal completion. The
 * width of this counter is specified as 10 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_MSB        28
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_WIDTH      10
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_SET_MSK    0x1ff80000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_CLR_MSK    0xe007ffff
/* The reset value of the ALT_USB_HOST_HCTSIZ1_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_PKTCNT field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_GET(value) (((value) & 0x1ff80000) >> 19)
/* Produces a ALT_USB_HOST_HCTSIZ1_PKTCNT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_PKTCNT_SET(value) (((value) << 19) & 0x1ff80000)

/*
 * Field : PID - pid
 * 
 * The application programs this field with the type of PID to use forthe initial
 * transaction. The host maintains this field for the rest of the transfer.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCTSIZ1_PID_E_DATA0 | 0x0   | DATA0                              
 *  ALT_USB_HOST_HCTSIZ1_PID_E_DATA2 | 0x1   | DATA2                              
 *  ALT_USB_HOST_HCTSIZ1_PID_E_DATA1 | 0x2   | DATA1                              
 *  ALT_USB_HOST_HCTSIZ1_PID_E_MDATA | 0x3   | MDATA (non-control)/SETUP (control)
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * DATA0
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_DATA0    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * DATA2
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_DATA2    0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * DATA1
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_DATA1    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_PID
 * 
 * MDATA (non-control)/SETUP (control)
 */
#define ALT_USB_HOST_HCTSIZ1_PID_E_MDATA    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_MSB        30
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_PID register field value. */
#define ALT_USB_HOST_HCTSIZ1_PID_SET_MSK    0x60000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_PID register field value. */
#define ALT_USB_HOST_HCTSIZ1_PID_CLR_MSK    0x9fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ1_PID register field. */
#define ALT_USB_HOST_HCTSIZ1_PID_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_PID field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_PID_GET(value) (((value) & 0x60000000) >> 29)
/* Produces a ALT_USB_HOST_HCTSIZ1_PID register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_PID_SET(value) (((value) << 29) & 0x60000000)

/*
 * Field : Do Ping - dopng
 * 
 * This bit is used only for OUT transfers.Setting this field to 1 directs the host
 * to do PING protocol. Do not Set this bit for IN transfers. If this bit is set
 * for IN transfers it disables the channel.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCTSIZ1_DOPNG_E_NOPING | 0x0   | No ping protocol
 *  ALT_USB_HOST_HCTSIZ1_DOPNG_E_PING   | 0x1   | Ping protocol   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_DOPNG
 * 
 * No ping protocol
 */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_E_NOPING 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ1_DOPNG
 * 
 * Ping protocol
 */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_E_PING   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_MSB        31
/* The width in bits of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCTSIZ1_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ1_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ1_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ1_DOPNG field value from a register. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCTSIZ1_DOPNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ1_DOPNG_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCTSIZ1.
 */
struct ALT_USB_HOST_HCTSIZ1_s
{
    uint32_t  xfersize : 19;  /* Transfer Size */
    uint32_t  pktcnt   : 10;  /* Packet Count */
    uint32_t  pid      :  2;  /* PID */
    uint32_t  dopng    :  1;  /* Do Ping */
};

/* The typedef declaration for register ALT_USB_HOST_HCTSIZ1. */
typedef volatile struct ALT_USB_HOST_HCTSIZ1_s  ALT_USB_HOST_HCTSIZ1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCTSIZ1 register from the beginning of the component. */
#define ALT_USB_HOST_HCTSIZ1_OFST        0x130
/* The address of the ALT_USB_HOST_HCTSIZ1 register. */
#define ALT_USB_HOST_HCTSIZ1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCTSIZ1_OFST))

/*
 * Register : Host Channel 1 DMA Address Register - hcdma1
 * 
 * This register is used by the OTG host in the internal DMA mode to maintain the
 * current buffer pointer for IN/OUT transactions. The starting DMA address must be
 * DWORD-aligned.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [31:0] | RW     | 0x0   | DMA Address
 * 
 */
/*
 * Field : DMA Address - hcdma1
 * 
 * Non-Isochronous: This field holds the start address of the 512 bytes  page.  The
 * first descriptor in the list should be located in this address. The first
 * descriptor may be or may not be ready. The core starts processing the list from
 * the CTD value. This field holds the address of the 2*(nTD+1) bytes of locations
 * in which the isochronous descriptors are present where N is based on nTD as per
 * Table below
 * 
 * [31:N]  Base Address [N-1:3]  Offset  [2:0]  000
 * 
 * HS ISOC                           FS ISOC
 * 
 * nTD   N                          nTD     N
 * 
 * 7     6                           1       4
 * 
 * 15    7                           3      5
 * 
 * 31    8                           7      6
 * 
 * 63    9                           15     7
 * 
 * 127  10                           31     8
 * 
 * 255  11                           63     9
 * 
 * [N-1:3] (Isoc):[8:3] (Non Isoc): Current Transfer Desc(CTD):  Non Isochronous:
 * This value is in terms of number of descriptors. The values can be from 0 to 63.
 * 0 -  1 descriptor. 63 - 64 descriptors. This field indicates the current
 * descriptor processed in the list. This field is updated both by application and
 * the core. for example, if the application enables the channel after programming
 * CTD=5, then the core will start processing the 6th descriptor. The address is
 * obtained by adding a value of (8bytes*5=) 40(decimal)  to DMAAddr.  Isochronous:
 * CTD for isochronous is based on the current frame/microframe value. Need to be
 * set to zero by application.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMA1_HCDMA1 register field value. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMA1_HCDMA1 register field value. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMA1_HCDMA1 register field. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMA1_HCDMA1 field value from a register. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMA1_HCDMA1 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMA1_HCDMA1_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMA1.
 */
struct ALT_USB_HOST_HCDMA1_s
{
    uint32_t  hcdma1 : 32;  /* DMA Address */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMA1. */
typedef volatile struct ALT_USB_HOST_HCDMA1_s  ALT_USB_HOST_HCDMA1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCDMA1 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMA1_OFST        0x134
/* The address of the ALT_USB_HOST_HCDMA1 register. */
#define ALT_USB_HOST_HCDMA1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMA1_OFST))

/*
 * Register : Host Channel 1 DMA Buffer Address Register - hcdmab1
 * 
 * These  registers  are  present  only  in  case  of  Scatter/Gather  DMA. These
 * registers  are  implemented  in RAM instead of flop-based implementation. Holds
 * the  current  buffer  address.  This  register  is  updated  as  and when  the
 * data  transfer  for  the corresponding  end  point  is  in progress.  This
 * register  is  present  only  in  Scatter/Gather  DMA mode. Otherwise this field
 * is reserved.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                      
 * :-------|:-------|:------|:----------------------------------
 *  [31:0] | RW     | 0x0   | Host Channel 1 DMA Buffer Address
 * 
 */
/*
 * Field : Host Channel 1 DMA Buffer Address - hcdmab1
 * 
 * These  registers  are  present  only  in  case  of  Scatter/Gather DMA. These
 * registers  are  implemented  in RAM instead of flop-based implementation. Holds
 * the  current  buffer  address. This register is updated as and when  the  data
 * transfer for the corresponding  end  point  is  in progress. This register  is
 * present  only  in Scatter/Gather DMA mode. Otherwise this field is reserved.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field value. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field value. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMAB1_HCDMAB1 register field. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMAB1_HCDMAB1 field value from a register. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMAB1_HCDMAB1 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMAB1_HCDMAB1_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMAB1.
 */
struct ALT_USB_HOST_HCDMAB1_s
{
    uint32_t  hcdmab1 : 32;  /* Host Channel 1 DMA Buffer Address */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMAB1. */
typedef volatile struct ALT_USB_HOST_HCDMAB1_s  ALT_USB_HOST_HCDMAB1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCDMAB1 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMAB1_OFST        0x138
/* The address of the ALT_USB_HOST_HCDMAB1 register. */
#define ALT_USB_HOST_HCDMAB1_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMAB1_OFST))

/*
 * Register : Host Channel 2 Characteristics Register - hcchar2
 * 
 * Host Channel 2 Characteristics Register
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description        
 * :--------|:-------|:------|:--------------------
 *  [10:0]  | RW     | 0x0   | Maximum Packet Size
 *  [14:11] | RW     | 0x0   | Endpoint Number    
 *  [15]    | RW     | 0x0   | Endpoint Direction 
 *  [16]    | ???    | 0x0   | *UNDEFINED*        
 *  [17]    | RW     | 0x0   | Low-Speed Device   
 *  [19:18] | RW     | 0x0   | Endpoint Type      
 *  [21:20] | RW     | 0x0   | Multi Count        
 *  [28:22] | RW     | 0x0   | Device Address     
 *  [29]    | ???    | 0x0   | *UNDEFINED*        
 *  [30]    | R      | 0x0   | Channel Disable    
 *  [31]    | R      | 0x0   | Channel Enable     
 * 
 */
/*
 * Field : Maximum Packet Size - mps
 * 
 * Indicates the maximum packet size of the associated endpoint.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_MSB        10
/* The width in bits of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_WIDTH      11
/* The mask used to set the ALT_USB_HOST_HCCHAR2_MPS register field value. */
#define ALT_USB_HOST_HCCHAR2_MPS_SET_MSK    0x000007ff
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_MPS register field value. */
#define ALT_USB_HOST_HCCHAR2_MPS_CLR_MSK    0xfffff800
/* The reset value of the ALT_USB_HOST_HCCHAR2_MPS register field. */
#define ALT_USB_HOST_HCCHAR2_MPS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_MPS field value from a register. */
#define ALT_USB_HOST_HCCHAR2_MPS_GET(value) (((value) & 0x000007ff) >> 0)
/* Produces a ALT_USB_HOST_HCCHAR2_MPS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_MPS_SET(value) (((value) << 0) & 0x000007ff)

/*
 * Field : Endpoint Number - epnum
 * 
 * Indicates the endpoint number on the device serving as the data source or sink.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  0
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  1
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  2
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  3
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  4
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  5
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  6
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  7
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  8
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  9
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  10
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  11
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  12
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  13
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  14
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPNUM
 * 
 * End point  15
 */
#define ALT_USB_HOST_HCCHAR2_EPNUM_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_MSB        14
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_SET_MSK    0x00007800
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_CLR_MSK    0xffff87ff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EPNUM field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_GET(value) (((value) & 0x00007800) >> 11)
/* Produces a ALT_USB_HOST_HCCHAR2_EPNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EPNUM_SET(value) (((value) << 11) & 0x00007800)

/*
 * Field : Endpoint Direction - epdir
 * 
 * Indicates whether the transaction is IN or OUT.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description  
 * :---------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR2_EPDIR_E_OUT | 0x0   | OUT Direction
 *  ALT_USB_HOST_HCCHAR2_EPDIR_E_IN  | 0x1   | IN Direction 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPDIR
 * 
 * OUT Direction
 */
#define ALT_USB_HOST_HCCHAR2_EPDIR_E_OUT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPDIR
 * 
 * IN Direction
 */
#define ALT_USB_HOST_HCCHAR2_EPDIR_E_IN     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_MSB        15
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EPDIR field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_HOST_HCCHAR2_EPDIR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EPDIR_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : Low-Speed Device - lspddev
 * 
 * This field is set by the application to indicate that this channel is
 * communicating to a low-speed device. The application must program this bit when
 * a low speed device is connected to the host through an FS HUB. The HS OTG Host
 * core uses this field to drive the XCVR_SELECT signal to 0x3 while communicating
 * to the LS Device through the FS hub. In a peer to peer setup, the HS OTG Host
 * core ignores this bit even if it is set by the application software
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                            
 * :------------------------------------|:------|:----------------------------------------
 *  ALT_USB_HOST_HCCHAR2_LSPDDEV_E_DISD | 0x0   | Not Communicating with low speed device
 *  ALT_USB_HOST_HCCHAR2_LSPDDEV_E_END  | 0x1   | Communicating with low speed device    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_LSPDDEV
 * 
 * Not Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_LSPDDEV
 * 
 * Communicating with low speed device
 */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_MSB        17
/* The width in bits of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_LSPDDEV field value from a register. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_HOST_HCCHAR2_LSPDDEV register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_LSPDDEV_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : Endpoint Type - eptype
 * 
 * Indicates the transfer type selected.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_CTL    | 0x0   | Control    
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_ISOC   | 0x1   | Isochronous
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_BULK   | 0x2   | Bulk       
 *  ALT_USB_HOST_HCCHAR2_EPTYPE_E_INTERR | 0x3   | Interrupt  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Control
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_CTL       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Isochronous
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_ISOC      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Bulk
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_BULK      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EPTYPE
 * 
 * Interrupt
 */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_E_INTERR    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_MSB        19
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_SET_MSK    0x000c0000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_CLR_MSK    0xfff3ffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EPTYPE field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_GET(value) (((value) & 0x000c0000) >> 18)
/* Produces a ALT_USB_HOST_HCCHAR2_EPTYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EPTYPE_SET(value) (((value) << 18) & 0x000c0000)

/*
 * Field : Multi Count - ec
 * 
 * When the Split Enable bit of the Host Channel-n Split Control register
 * (HCSPLTn.SpltEna) is reset (0), this field indicates to the host the number of
 * transactions that must be executed per microframe for this periodic endpoint.
 * for non periodic transfers, this field is used only in DMA mode, and specifies
 * the number packets to be fetched for this channel before the internal DMA engine
 * changes arbitration. When HCSPLTn.SpltEna is Set (1), this field indicates the
 * number of immediate retries to be performed for a periodic split transactions on
 * transaction errors. This field must be set to at least 1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                  
 * :-------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_HOST_HCCHAR2_EC_E_RSVD       | 0x0   | Reserved This field yields undefined result  
 *  ALT_USB_HOST_HCCHAR2_EC_E_TRANSONE   | 0x1   | 1 transaction                                
 *  ALT_USB_HOST_HCCHAR2_EC_E_TRANSTWO   | 0x2   | 2 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 *  ALT_USB_HOST_HCCHAR2_EC_E_TRANSTHREE | 0x3   | 3 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * Reserved This field yields undefined result
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_RSVD          0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * 1 transaction
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_TRANSONE      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * 2 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_TRANSTWO      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_EC
 * 
 * 3 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR2_EC_E_TRANSTHREE    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_MSB        21
/* The width in bits of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR2_EC register field value. */
#define ALT_USB_HOST_HCCHAR2_EC_SET_MSK    0x00300000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_EC register field value. */
#define ALT_USB_HOST_HCCHAR2_EC_CLR_MSK    0xffcfffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_EC register field. */
#define ALT_USB_HOST_HCCHAR2_EC_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_EC field value from a register. */
#define ALT_USB_HOST_HCCHAR2_EC_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_USB_HOST_HCCHAR2_EC register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_EC_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : Device Address - devaddr
 * 
 * This field selects the specific device serving as the data source or sink.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_MSB        28
/* The width in bits of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCCHAR2_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_SET_MSK    0x1fc00000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_CLR_MSK    0xe03fffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_DEVADDR field value from a register. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_GET(value) (((value) & 0x1fc00000) >> 22)
/* Produces a ALT_USB_HOST_HCCHAR2_DEVADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_DEVADDR_SET(value) (((value) << 22) & 0x1fc00000)

/*
 * Field : Channel Disable - chdis
 * 
 * The application sets this bit to stop transmitting/receiving data on a channel,
 * even before the transfer for that channel is complete. The application must wait
 * for the Channel Disabled interrupt before treating the channel as disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                
 * :-----------------------------------|:------|:----------------------------
 *  ALT_USB_HOST_HCCHAR2_CHDIS_E_INACT | 0x0   | Transmit/Recieve normal    
 *  ALT_USB_HOST_HCCHAR2_CHDIS_E_ACT   | 0x1   | Stop transmitting/receiving
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHDIS
 * 
 * Transmit/Recieve normal
 */
#define ALT_USB_HOST_HCCHAR2_CHDIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHDIS
 * 
 * Stop transmitting/receiving
 */
#define ALT_USB_HOST_HCCHAR2_CHDIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_MSB        30
/* The width in bits of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_CHDIS field value from a register. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_HOST_HCCHAR2_CHDIS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_CHDIS_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Channel Enable - chena
 * 
 * When Scatter/Gather mode is disabled This field is set by the application and
 * cleared by the OTG host.
 * 
 * 0: Channel disabled
 * 
 * 1: Channel enabled
 * 
 * When Scatter/Gather mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                     
 * :-----------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_HOST_HCCHAR2_CHENA_E_INACT | 0x0   | Indicates that the descriptor structure is not  
 * :                                   |       | yet ready                                       
 *  ALT_USB_HOST_HCCHAR2_CHENA_E_ACT   | 0x1   | Indicates  that  the  descriptor  structure  and
 * :                                   |       | data  buffer  with data is setup and this       
 * :                                   |       | channel can access the descriptor               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHENA
 * 
 * Indicates that the descriptor structure is not yet ready
 */
#define ALT_USB_HOST_HCCHAR2_CHENA_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR2_CHENA
 * 
 * Indicates  that  the  descriptor  structure  and  data  buffer  with data is
 * setup and this channel can access the descriptor
 */
#define ALT_USB_HOST_HCCHAR2_CHENA_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR2_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR2_CHENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR2_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR2_CHENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCCHAR2_CHENA register field. */
#define ALT_USB_HOST_HCCHAR2_CHENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR2_CHENA field value from a register. */
#define ALT_USB_HOST_HCCHAR2_CHENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCCHAR2_CHENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR2_CHENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCCHAR2.
 */
struct ALT_USB_HOST_HCCHAR2_s
{
    uint32_t        mps     : 11;  /* Maximum Packet Size */
    uint32_t        epnum   :  4;  /* Endpoint Number */
    uint32_t        epdir   :  1;  /* Endpoint Direction */
    uint32_t                :  1;  /* *UNDEFINED* */
    uint32_t        lspddev :  1;  /* Low-Speed Device */
    uint32_t        eptype  :  2;  /* Endpoint Type */
    uint32_t        ec      :  2;  /* Multi Count */
    uint32_t        devaddr :  7;  /* Device Address */
    uint32_t                :  1;  /* *UNDEFINED* */
    const uint32_t  chdis   :  1;  /* Channel Disable */
    const uint32_t  chena   :  1;  /* Channel Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCCHAR2. */
typedef volatile struct ALT_USB_HOST_HCCHAR2_s  ALT_USB_HOST_HCCHAR2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCCHAR2 register from the beginning of the component. */
#define ALT_USB_HOST_HCCHAR2_OFST        0x140
/* The address of the ALT_USB_HOST_HCCHAR2 register. */
#define ALT_USB_HOST_HCCHAR2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCCHAR2_OFST))

/*
 * Register : Host Channel 2 Split Control Register - hcsplt2
 * 
 * Channel_number 2
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description         
 * :--------|:-------|:------|:---------------------
 *  [6:0]   | RW     | 0x0   | Port Address        
 *  [13:7]  | RW     | 0x0   | Hub Address         
 *  [15:14] | RW     | 0x0   | Transaction Position
 *  [16]    | RW     | 0x0   | Do Complete Split   
 *  [30:17] | ???    | 0x0   | *UNDEFINED*         
 *  [31]    | RW     | 0x0   | Split Enable        
 * 
 */
/*
 * Field : Port Address - prtaddr
 * 
 * This field is the port number of the recipient transactiontranslator.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_MSB        6
/* The width in bits of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT2_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_SET_MSK    0x0000007f
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_CLR_MSK    0xffffff80
/* The reset value of the ALT_USB_HOST_HCSPLT2_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_PRTADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_GET(value) (((value) & 0x0000007f) >> 0)
/* Produces a ALT_USB_HOST_HCSPLT2_PRTADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_PRTADDR_SET(value) (((value) << 0) & 0x0000007f)

/*
 * Field : Hub Address - hubaddr
 * 
 * This field holds the device address of the transaction translator's hub.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT2_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_SET_MSK    0x00003f80
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_CLR_MSK    0xffffc07f
/* The reset value of the ALT_USB_HOST_HCSPLT2_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_HUBADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_GET(value) (((value) & 0x00003f80) >> 7)
/* Produces a ALT_USB_HOST_HCSPLT2_HUBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_HUBADDR_SET(value) (((value) << 7) & 0x00003f80)

/*
 * Field : Transaction Position - xactpos
 * 
 * This field is used to determine whether to send all, first, middle, or last
 * payloads with each OUT transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_MIDDLE | 0x0   | Mid. This is the middle payload of this        
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_END    | 0x1   | End. This is the last payload of this          
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_BEGIN  | 0x2   | Begin. This is the first data payload of this  
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT2_XACTPOS_E_ALL    | 0x3   | All. This is the entire data payload is of this
 * :                                      |       | transaction (which is less than or equal to 188
 * :                                      |       | bytes)                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * Mid. This is the middle payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_MIDDLE   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * End. This is the last payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_END      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * Begin. This is the first data payload of this transaction (which is larger than
 * 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_BEGIN    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_XACTPOS
 * 
 * All. This is the entire data payload is of this transaction (which is less than
 * or equal to 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_E_ALL      0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_MSB        15
/* The width in bits of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCSPLT2_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_HOST_HCSPLT2_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_XACTPOS field value from a register. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_HOST_HCSPLT2_XACTPOS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_XACTPOS_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : Do Complete Split - compsplt
 * 
 * The application sets this field to request the OTG host to perform a complete
 * split transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCSPLT2_COMPSPLT_E_NOSPLIT | 0x0   | No split transaction
 *  ALT_USB_HOST_HCSPLT2_COMPSPLT_E_SPLIT   | 0x1   | Split transaction   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_COMPSPLT
 * 
 * No split transaction
 */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_E_NOSPLIT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_COMPSPLT
 * 
 * Split transaction
 */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_E_SPLIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_MSB        16
/* The width in bits of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT2_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HCSPLT2_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_COMPSPLT field value from a register. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HCSPLT2_COMPSPLT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_COMPSPLT_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : Split Enable - spltena
 * 
 * The application sets this field to indicate that this channel is enabled to
 * perform split transactions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HCSPLT2_SPLTENA_E_DISD | 0x0   | Split not enabled
 *  ALT_USB_HOST_HCSPLT2_SPLTENA_E_END  | 0x1   | Split enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_SPLTENA
 * 
 * Split not enabled
 */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT2_SPLTENA
 * 
 * Split enabled
 */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT2_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCSPLT2_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCSPLT2_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT2_SPLTENA field value from a register. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCSPLT2_SPLTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT2_SPLTENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCSPLT2.
 */
struct ALT_USB_HOST_HCSPLT2_s
{
    uint32_t  prtaddr  :  7;  /* Port Address */
    uint32_t  hubaddr  :  7;  /* Hub Address */
    uint32_t  xactpos  :  2;  /* Transaction Position */
    uint32_t  compsplt :  1;  /* Do Complete Split */
    uint32_t           : 14;  /* *UNDEFINED* */
    uint32_t  spltena  :  1;  /* Split Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCSPLT2. */
typedef volatile struct ALT_USB_HOST_HCSPLT2_s  ALT_USB_HOST_HCSPLT2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCSPLT2 register from the beginning of the component. */
#define ALT_USB_HOST_HCSPLT2_OFST        0x144
/* The address of the ALT_USB_HOST_HCSPLT2 register. */
#define ALT_USB_HOST_HCSPLT2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCSPLT2_OFST))

/*
 * Register : Host Channel 2 Interrupt Register - hcint2
 * 
 * This register indicates the status of a channel with respect to USB- and AHB-
 * related events. The application must read this register when the Host Channels
 * Interrupt bit of the Core Interrupt register (GINTSTS.HChInt) is set. Before the
 * application can read this register, it must first read the Host All Channels
 * Interrupt (HAINT) register to get the exact channel number for the Host
 * Channel-n Interrupt register. The application must clear the appropriate bit in
 * this register to clear the corresponding bits in the HAINT and GINTSTS
 * registers.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                
 * :--------|:-------|:------|:--------------------------------------------
 *  [0]     | R      | 0x0   | Transfer Completed                         
 *  [1]     | R      | 0x0   | Channel Halted                             
 *  [2]     | R      | 0x0   | AHB Error                                  
 *  [3]     | R      | 0x0   | STALL Response Received Interrupt          
 *  [4]     | R      | 0x0   | NAK Response Received Interrupt            
 *  [5]     | R      | 0x0   | ACK Response Received Transmitted Interrupt
 *  [6]     | R      | 0x0   | NYET Response Received Interrupt           
 *  [7]     | R      | 0x0   | Transaction Error                          
 *  [8]     | R      | 0x0   | Babble Error                               
 *  [9]     | R      | 0x0   | Frame Overrun                              
 *  [10]    | R      | 0x0   | Data Toggle Error                          
 *  [11]    | R      | 0x0   | BNA Interrupt                              
 *  [12]    | R      | 0x0   | Excessive Transaction Error                
 *  [13]    | R      | 0x0   | Descriptor rollover interrupt              
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                                
 * 
 */
/*
 * Field : Transfer Completed - xfercompl
 * 
 * Transfer completed normally without any errors. This bit can be set only by the
 * core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT2_XFERCOMPL_E_INACT | 0x0   | No transfer                                   
 *  ALT_USB_HOST_HCINT2_XFERCOMPL_E_ACT   | 0x1   | Transfer completed normally without any errors
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XFERCOMPL
 * 
 * No transfer
 */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XFERCOMPL
 * 
 * Transfer completed normally without any errors
 */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINT2_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINT2_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_XFERCOMPL field value from a register. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINT2_XFERCOMPL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_XFERCOMPL_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Halted - chhltd
 * 
 * In non Scatter/Gather DMA mode, it indicates the transfer completed abnormally
 * either because of any USB transaction error or in response to disable request by
 * the application or because of a completed transfer. In Scatter/gather DMA mode,
 * this indicates that transfer completed due to any of the following
 * 
 * . EOL being set in descriptor
 * 
 * . AHB error
 * 
 * . Excessive transaction errors
 * 
 * . Babble
 * 
 * . Stall
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description       
 * :-----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT2_CHHLTD_E_INACT | 0x0   | Channel not halted
 *  ALT_USB_HOST_HCINT2_CHHLTD_E_ACT   | 0x1   | Channel Halted    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_CHHLTD
 * 
 * Channel not halted
 */
#define ALT_USB_HOST_HCINT2_CHHLTD_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_CHHLTD
 * 
 * Channel Halted
 */
#define ALT_USB_HOST_HCINT2_CHHLTD_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT2_CHHLTD_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINT2_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT2_CHHLTD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINT2_CHHLTD register field. */
#define ALT_USB_HOST_HCINT2_CHHLTD_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_CHHLTD field value from a register. */
#define ALT_USB_HOST_HCINT2_CHHLTD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINT2_CHHLTD register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_CHHLTD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : AHB Error - ahberr
 * 
 * This is generated only in Internal DMA mode when there is an AHB error during
 * AHB read/write. The application can read the corresponding channel's address
 * register to get the error address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                    
 * :-----------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCINT2_AHBERR_E_INACT | 0x0   | No AHB error                   
 *  ALT_USB_HOST_HCINT2_AHBERR_E_ACT   | 0x1   | AHB error during AHB read/write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_AHBERR
 * 
 * No AHB error
 */
#define ALT_USB_HOST_HCINT2_AHBERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_AHBERR
 * 
 * AHB error during AHB read/write
 */
#define ALT_USB_HOST_HCINT2_AHBERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_AHBERR register field value. */
#define ALT_USB_HOST_HCINT2_AHBERR_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINT2_AHBERR register field value. */
#define ALT_USB_HOST_HCINT2_AHBERR_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINT2_AHBERR register field. */
#define ALT_USB_HOST_HCINT2_AHBERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_AHBERR field value from a register. */
#define ALT_USB_HOST_HCINT2_AHBERR_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINT2_AHBERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_AHBERR_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : STALL Response Received Interrupt - stall
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description       
 * :----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT2_STALL_E_INACT | 0x0   | No Stall Interrupt
 *  ALT_USB_HOST_HCINT2_STALL_E_ACT   | 0x1   | Stall Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_STALL
 * 
 * No Stall Interrupt
 */
#define ALT_USB_HOST_HCINT2_STALL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_STALL
 * 
 * Stall Interrupt
 */
#define ALT_USB_HOST_HCINT2_STALL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_STALL register field value. */
#define ALT_USB_HOST_HCINT2_STALL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINT2_STALL register field value. */
#define ALT_USB_HOST_HCINT2_STALL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINT2_STALL register field. */
#define ALT_USB_HOST_HCINT2_STALL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_STALL field value from a register. */
#define ALT_USB_HOST_HCINT2_STALL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINT2_STALL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_STALL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NAK Response Received Interrupt - nak
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_USB_HOST_HCINT2_NAK_E_INACT | 0x0   | No NAK Response Received Interrupt
 *  ALT_USB_HOST_HCINT2_NAK_E_ACT   | 0x1   | NAK Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NAK
 * 
 * No NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NAK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NAK
 * 
 * NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NAK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_NAK register field value. */
#define ALT_USB_HOST_HCINT2_NAK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINT2_NAK register field value. */
#define ALT_USB_HOST_HCINT2_NAK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINT2_NAK register field. */
#define ALT_USB_HOST_HCINT2_NAK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_NAK field value from a register. */
#define ALT_USB_HOST_HCINT2_NAK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINT2_NAK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_NAK_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : ACK Response Received Transmitted Interrupt - ack
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                   
 * :--------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT2_ACK_E_INACT | 0x0   | No ACK Response Received Transmitted Interrupt
 *  ALT_USB_HOST_HCINT2_ACK_E_ACT   | 0x1   | ACK Response Received Transmitted Interrup    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_ACK
 * 
 * No ACK Response Received Transmitted Interrupt
 */
#define ALT_USB_HOST_HCINT2_ACK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_ACK
 * 
 * ACK Response Received Transmitted Interrup
 */
#define ALT_USB_HOST_HCINT2_ACK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_MSB        5
/* The width in bits of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_ACK register field value. */
#define ALT_USB_HOST_HCINT2_ACK_SET_MSK    0x00000020
/* The mask used to clear the ALT_USB_HOST_HCINT2_ACK register field value. */
#define ALT_USB_HOST_HCINT2_ACK_CLR_MSK    0xffffffdf
/* The reset value of the ALT_USB_HOST_HCINT2_ACK register field. */
#define ALT_USB_HOST_HCINT2_ACK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_ACK field value from a register. */
#define ALT_USB_HOST_HCINT2_ACK_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_USB_HOST_HCINT2_ACK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_ACK_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NYET Response Received Interrupt - nyet
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCINT2_NYET_E_INACT | 0x0   | No NYET Response Received Interrupt
 *  ALT_USB_HOST_HCINT2_NYET_E_ACT   | 0x1   | NYET Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NYET
 * 
 * No NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NYET_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_NYET
 * 
 * NYET Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT2_NYET_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_MSB        6
/* The width in bits of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_NYET register field value. */
#define ALT_USB_HOST_HCINT2_NYET_SET_MSK    0x00000040
/* The mask used to clear the ALT_USB_HOST_HCINT2_NYET register field value. */
#define ALT_USB_HOST_HCINT2_NYET_CLR_MSK    0xffffffbf
/* The reset value of the ALT_USB_HOST_HCINT2_NYET register field. */
#define ALT_USB_HOST_HCINT2_NYET_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_NYET field value from a register. */
#define ALT_USB_HOST_HCINT2_NYET_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_USB_HOST_HCINT2_NYET register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_NYET_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Transaction Error - xacterr
 * 
 * Indicates one of the following errors occurred on the USB.-CRC check failure
 * 
 * * Timeout
 * 
 * * Bit stuff error
 * 
 * * False EOP
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description         
 * :------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT2_XACTERR_E_INACT | 0x0   | No Transaction Error
 *  ALT_USB_HOST_HCINT2_XACTERR_E_ACT   | 0x1   | Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XACTERR
 * 
 * No Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XACTERR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XACTERR
 * 
 * Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XACTERR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_MSB        7
/* The width in bits of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_XACTERR register field value. */
#define ALT_USB_HOST_HCINT2_XACTERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_USB_HOST_HCINT2_XACTERR register field value. */
#define ALT_USB_HOST_HCINT2_XACTERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_USB_HOST_HCINT2_XACTERR register field. */
#define ALT_USB_HOST_HCINT2_XACTERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_XACTERR field value from a register. */
#define ALT_USB_HOST_HCINT2_XACTERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_USB_HOST_HCINT2_XACTERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_XACTERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Babble Error - bblerr
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core..This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description    
 * :-----------------------------------|:------|:----------------
 *  ALT_USB_HOST_HCINT2_BBLERR_E_INACT | 0x0   | No Babble Error
 *  ALT_USB_HOST_HCINT2_BBLERR_E_ACT   | 0x1   | Babble Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BBLERR
 * 
 * No Babble Error
 */
#define ALT_USB_HOST_HCINT2_BBLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BBLERR
 * 
 * Babble Error
 */
#define ALT_USB_HOST_HCINT2_BBLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_MSB        8
/* The width in bits of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_BBLERR register field value. */
#define ALT_USB_HOST_HCINT2_BBLERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_USB_HOST_HCINT2_BBLERR register field value. */
#define ALT_USB_HOST_HCINT2_BBLERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_USB_HOST_HCINT2_BBLERR register field. */
#define ALT_USB_HOST_HCINT2_BBLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_BBLERR field value from a register. */
#define ALT_USB_HOST_HCINT2_BBLERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_USB_HOST_HCINT2_BBLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_BBLERR_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Frame Overrun - frmovrun
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description     
 * :-------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT2_FRMOVRUN_E_INACT | 0x0   | No Frame Overrun
 *  ALT_USB_HOST_HCINT2_FRMOVRUN_E_ACT   | 0x1   | Frame Overrun   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_FRMOVRUN
 * 
 * No Frame Overrun
 */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_FRMOVRUN
 * 
 * Frame Overrun
 */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_E_ACT      0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_MSB        9
/* The width in bits of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_SET_MSK    0x00000200
/* The mask used to clear the ALT_USB_HOST_HCINT2_FRMOVRUN register field value. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_CLR_MSK    0xfffffdff
/* The reset value of the ALT_USB_HOST_HCINT2_FRMOVRUN register field. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_FRMOVRUN field value from a register. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_USB_HOST_HCINT2_FRMOVRUN register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_FRMOVRUN_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Data Toggle Error - datatglerr
 * 
 * This bit can be set only by the core and the application should write 1 to clear
 * it. In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description         
 * :---------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCINT2_DATATGLERR_E_INACT | 0x0   | No Data Toggle Error
 *  ALT_USB_HOST_HCINT2_DATATGLERR_E_ACT   | 0x1   | Data Toggle Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DATATGLERR
 * 
 * No Data Toggle Error
 */
#define ALT_USB_HOST_HCINT2_DATATGLERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DATATGLERR
 * 
 * Data Toggle Error
 */
#define ALT_USB_HOST_HCINT2_DATATGLERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_MSB        10
/* The width in bits of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_SET_MSK    0x00000400
/* The mask used to clear the ALT_USB_HOST_HCINT2_DATATGLERR register field value. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_CLR_MSK    0xfffffbff
/* The reset value of the ALT_USB_HOST_HCINT2_DATATGLERR register field. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_DATATGLERR field value from a register. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_USB_HOST_HCINT2_DATATGLERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_DATATGLERR_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : BNA Interrupt - bnaintr
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core
 * generates this interrupt when the descriptor accessed is not ready for the Core
 * to process. BNA will not be generated for Isochronous channels. for non
 * Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCINT2_BNAINTR_E_INACT | 0x0   | No BNA Interrupt
 *  ALT_USB_HOST_HCINT2_BNAINTR_E_ACT   | 0x1   | BNA Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BNAINTR
 * 
 * No BNA Interrupt
 */
#define ALT_USB_HOST_HCINT2_BNAINTR_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_BNAINTR
 * 
 * BNA Interrupt
 */
#define ALT_USB_HOST_HCINT2_BNAINTR_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT2_BNAINTR_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINT2_BNAINTR register field value. */
#define ALT_USB_HOST_HCINT2_BNAINTR_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINT2_BNAINTR register field. */
#define ALT_USB_HOST_HCINT2_BNAINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_BNAINTR field value from a register. */
#define ALT_USB_HOST_HCINT2_BNAINTR_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINT2_BNAINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_BNAINTR_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Excessive Transaction Error - xcs_xact_err
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled. The core sets
 * this bit when 3 consecutive transaction errors occurred on the USB bus.
 * XCS_XACT_ERR will not be generated for Isochronous channels.for non
 * Scatter/Gather DMA mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                   
 * :-------------------------------------------|:------|:-------------------------------
 *  ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_INACT   | 0x0   | No Excessive Transaction Error
 *  ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_ACVTIVE | 0x1   | Excessive Transaction Error   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XCS_XACT_ERR
 * 
 * No Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_INACT    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_XCS_XACT_ERR
 * 
 * Excessive Transaction Error
 */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_E_ACVTIVE  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_MSB        12
/* The width in bits of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_SET_MSK    0x00001000
/* The mask used to clear the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field value. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_CLR_MSK    0xffffefff
/* The reset value of the ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_XCS_XACT_ERR field value from a register. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_USB_HOST_HCINT2_XCS_XACT_ERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_XCS_XACT_ERR_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Descriptor rollover interrupt - desc_lst_rollintr
 * 
 * Descriptor rollover interrupt (DESC_LST_ROLLIntr)This bit is valid only when
 * Scatter/Gather DMA mode is enabled. The core sets this bit when the
 * corresponding channel's descriptor list rolls over. for non Scatter/Gather DMA
 * mode, this bit is reserved.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                     
 * :----------------------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_INACT | 0x0   | No Descriptor rollover interrupt
 *  ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_ACT   | 0x1   | Descriptor rollover interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR
 * 
 * No Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR
 * 
 * Descriptor rollover interrupt
 */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field value. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR field value from a register. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT2_DESC_LST_ROLLINTR_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINT2.
 */
struct ALT_USB_HOST_HCINT2_s
{
    const uint32_t  xfercompl         :  1;  /* Transfer Completed */
    const uint32_t  chhltd            :  1;  /* Channel Halted */
    const uint32_t  ahberr            :  1;  /* AHB Error */
    const uint32_t  stall             :  1;  /* STALL Response Received Interrupt */
    const uint32_t  nak               :  1;  /* NAK Response Received Interrupt */
    const uint32_t  ack               :  1;  /* ACK Response Received Transmitted Interrupt */
    const uint32_t  nyet              :  1;  /* NYET Response Received Interrupt */
    const uint32_t  xacterr           :  1;  /* Transaction Error */
    const uint32_t  bblerr            :  1;  /* Babble Error */
    const uint32_t  frmovrun          :  1;  /* Frame Overrun */
    const uint32_t  datatglerr        :  1;  /* Data Toggle Error */
    const uint32_t  bnaintr           :  1;  /* BNA Interrupt */
    const uint32_t  xcs_xact_err      :  1;  /* Excessive Transaction Error */
    const uint32_t  desc_lst_rollintr :  1;  /* Descriptor rollover interrupt */
    uint32_t                          : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINT2. */
typedef volatile struct ALT_USB_HOST_HCINT2_s  ALT_USB_HOST_HCINT2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCINT2 register from the beginning of the component. */
#define ALT_USB_HOST_HCINT2_OFST        0x148
/* The address of the ALT_USB_HOST_HCINT2 register. */
#define ALT_USB_HOST_HCINT2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINT2_OFST))

/*
 * Register : Host Channel 2 Interrupt Mask Register - hcintmsk2
 * 
 * This register reflects the mask for each channel status described in the
 * previous section.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                      
 * :--------|:-------|:------|:----------------------------------
 *  [0]     | RW     | 0x0   | Transfer Completed Mask          
 *  [1]     | RW     | 0x0   | Channel Halted Mask              
 *  [2]     | RW     | 0x0   | AHB Error Mask                   
 *  [10:3]  | ???    | 0x0   | *UNDEFINED*                      
 *  [11]    | RW     | 0x0   | BNA Interrupt  mask              
 *  [12]    | ???    | 0x0   | *UNDEFINED*                      
 *  [13]    | RW     | 0x0   | Framelist Rollover Interrupt Mask
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                      
 * 
 */
/*
 * Field : Transfer Completed Mask - xfercomplmsk
 * 
 * Transfer complete.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description
 * :--------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_MSK   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_E_NOMSK 0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK2_XFERCOMPLMSK_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Halted Mask - chhltdmsk
 * 
 * Channel Halted.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_CHHLTDMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_CHHLTDMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK2_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK2_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINTMSK2_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK2_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINTMSK2_CHHLTDMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINTMSK2_CHHLTDMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK2_CHHLTDMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINTMSK2_CHHLTDMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK2_CHHLTDMSK_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : AHB Error Mask - ahberrmsk
 * 
 * In  scatter/gather DMA  mode  for  host, interrupts will not be generated due to
 * the corresponding bits set in HCINTn.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description
 * :-----------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK2_AHBERRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK2_AHBERRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_AHBERRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_E_MSK      0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_AHBERRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_E_NOMSK    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK2_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK2_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINTMSK2_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK2_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINTMSK2_AHBERRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINTMSK2_AHBERRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK2_AHBERRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINTMSK2_AHBERRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK2_AHBERRMSK_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : BNA Interrupt  mask - bnaintrmsk
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description
 * :------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_BNAINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_E_MSK     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_BNAINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_E_NOMSK   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK2_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK2_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_MSB        11
/* The width in bits of the ALT_USB_HOST_HCINTMSK2_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK2_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_SET_MSK    0x00000800
/* The mask used to clear the ALT_USB_HOST_HCINTMSK2_BNAINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_USB_HOST_HCINTMSK2_BNAINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK2_BNAINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_USB_HOST_HCINTMSK2_BNAINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK2_BNAINTRMSK_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Framelist Rollover Interrupt Mask - frm_lst_rollintrmsk
 * 
 * This bit is valid only when Scatter/Gather DMA mode is enabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description
 * :---------------------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_E_MSK   | 0x0   | Mask       
 *  ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_E_NOMSK | 0x1   | No mask    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK
 * 
 * Mask
 */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_E_MSK    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK
 * 
 * No mask
 */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_E_NOMSK  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_MSB        13
/* The width in bits of the ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_SET_MSK    0x00002000
/* The mask used to clear the ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK register field value. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_CLR_MSK    0xffffdfff
/* The reset value of the ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK register field. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK field value from a register. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINTMSK2_FRM_LST_ROLLINTRMSK_SET(value) (((value) << 13) & 0x00002000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCINTMSK2.
 */
struct ALT_USB_HOST_HCINTMSK2_s
{
    uint32_t  xfercomplmsk        :  1;  /* Transfer Completed Mask */
    uint32_t  chhltdmsk           :  1;  /* Channel Halted Mask */
    uint32_t  ahberrmsk           :  1;  /* AHB Error Mask */
    uint32_t                      :  8;  /* *UNDEFINED* */
    uint32_t  bnaintrmsk          :  1;  /* BNA Interrupt  mask */
    uint32_t                      :  1;  /* *UNDEFINED* */
    uint32_t  frm_lst_rollintrmsk :  1;  /* Framelist Rollover Interrupt Mask */
    uint32_t                      : 18;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_USB_HOST_HCINTMSK2. */
typedef volatile struct ALT_USB_HOST_HCINTMSK2_s  ALT_USB_HOST_HCINTMSK2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCINTMSK2 register from the beginning of the component. */
#define ALT_USB_HOST_HCINTMSK2_OFST        0x14c
/* The address of the ALT_USB_HOST_HCINTMSK2 register. */
#define ALT_USB_HOST_HCINTMSK2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCINTMSK2_OFST))

/*
 * Register : Host Channel 2 Transfer Size Register - hctsiz2
 * 
 * Buffer DMA Mode.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description  
 * :--------|:-------|:------|:--------------
 *  [18:0]  | RW     | 0x0   | Transfer Size
 *  [28:19] | RW     | 0x0   | Packet Count 
 *  [30:29] | RW     | 0x0   | PID          
 *  [31]    | RW     | 0x0   | Do Ping      
 * 
 */
/*
 * Field : Transfer Size - xfersize
 * 
 * for an OUT, this field is the number of data bytes the host sends during the
 * transfer. for an IN, this field is the buffer size that the application has
 * Reserved for the transfer. The application is expected to program this field as
 * an integer multiple of the maximum packet size for IN transactions (periodic and
 * non-periodic).The width of this counter is specified as 19 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ2_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ2_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_MSB        18
/* The width in bits of the ALT_USB_HOST_HCTSIZ2_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_WIDTH      19
/* The mask used to set the ALT_USB_HOST_HCTSIZ2_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_SET_MSK    0x0007ffff
/* The mask used to clear the ALT_USB_HOST_HCTSIZ2_XFERSIZE register field value. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_CLR_MSK    0xfff80000
/* The reset value of the ALT_USB_HOST_HCTSIZ2_XFERSIZE register field. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ2_XFERSIZE field value from a register. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_GET(value) (((value) & 0x0007ffff) >> 0)
/* Produces a ALT_USB_HOST_HCTSIZ2_XFERSIZE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ2_XFERSIZE_SET(value) (((value) << 0) & 0x0007ffff)

/*
 * Field : Packet Count - pktcnt
 * 
 * This field is programmed by the application with the expected number of packets
 * to be transmitted (OUT) or received (IN). The host decrements this count on
 * every successful transmission or reception of an OUT/IN packet. Once this count
 * reaches zero, the application is interrupted to indicate normal completion. The
 * width of this counter is specified as 10 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ2_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_LSB        19
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ2_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_MSB        28
/* The width in bits of the ALT_USB_HOST_HCTSIZ2_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_WIDTH      10
/* The mask used to set the ALT_USB_HOST_HCTSIZ2_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_SET_MSK    0x1ff80000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ2_PKTCNT register field value. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_CLR_MSK    0xe007ffff
/* The reset value of the ALT_USB_HOST_HCTSIZ2_PKTCNT register field. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ2_PKTCNT field value from a register. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_GET(value) (((value) & 0x1ff80000) >> 19)
/* Produces a ALT_USB_HOST_HCTSIZ2_PKTCNT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ2_PKTCNT_SET(value) (((value) << 19) & 0x1ff80000)

/*
 * Field : PID - pid
 * 
 * The application programs this field with the type of PID to use forthe initial
 * transaction. The host maintains this field for the rest of the transfer.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description                        
 * :---------------------------------|:------|:------------------------------------
 *  ALT_USB_HOST_HCTSIZ2_PID_E_DATA0 | 0x0   | DATA0                              
 *  ALT_USB_HOST_HCTSIZ2_PID_E_DATA2 | 0x1   | DATA2                              
 *  ALT_USB_HOST_HCTSIZ2_PID_E_DATA1 | 0x2   | DATA1                              
 *  ALT_USB_HOST_HCTSIZ2_PID_E_MDATA | 0x3   | MDATA (non-control)/SETUP (control)
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ2_PID
 * 
 * DATA0
 */
#define ALT_USB_HOST_HCTSIZ2_PID_E_DATA0    0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ2_PID
 * 
 * DATA2
 */
#define ALT_USB_HOST_HCTSIZ2_PID_E_DATA2    0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ2_PID
 * 
 * DATA1
 */
#define ALT_USB_HOST_HCTSIZ2_PID_E_DATA1    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ2_PID
 * 
 * MDATA (non-control)/SETUP (control)
 */
#define ALT_USB_HOST_HCTSIZ2_PID_E_MDATA    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ2_PID register field. */
#define ALT_USB_HOST_HCTSIZ2_PID_LSB        29
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ2_PID register field. */
#define ALT_USB_HOST_HCTSIZ2_PID_MSB        30
/* The width in bits of the ALT_USB_HOST_HCTSIZ2_PID register field. */
#define ALT_USB_HOST_HCTSIZ2_PID_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCTSIZ2_PID register field value. */
#define ALT_USB_HOST_HCTSIZ2_PID_SET_MSK    0x60000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ2_PID register field value. */
#define ALT_USB_HOST_HCTSIZ2_PID_CLR_MSK    0x9fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ2_PID register field. */
#define ALT_USB_HOST_HCTSIZ2_PID_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ2_PID field value from a register. */
#define ALT_USB_HOST_HCTSIZ2_PID_GET(value) (((value) & 0x60000000) >> 29)
/* Produces a ALT_USB_HOST_HCTSIZ2_PID register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ2_PID_SET(value) (((value) << 29) & 0x60000000)

/*
 * Field : Do Ping - dopng
 * 
 * This bit is used only for OUT transfers.Setting this field to 1 directs the host
 * to do PING protocol. Do not Set this bit for IN transfers. If this bit is set
 * for IN transfers it disables the channel.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description     
 * :------------------------------------|:------|:-----------------
 *  ALT_USB_HOST_HCTSIZ2_DOPNG_E_NOPING | 0x0   | No ping protocol
 *  ALT_USB_HOST_HCTSIZ2_DOPNG_E_PING   | 0x1   | Ping protocol   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ2_DOPNG
 * 
 * No ping protocol
 */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_E_NOPING 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCTSIZ2_DOPNG
 * 
 * Ping protocol
 */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_E_PING   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCTSIZ2_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCTSIZ2_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_MSB        31
/* The width in bits of the ALT_USB_HOST_HCTSIZ2_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCTSIZ2_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCTSIZ2_DOPNG register field value. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCTSIZ2_DOPNG register field. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_RESET      0x0
/* Extracts the ALT_USB_HOST_HCTSIZ2_DOPNG field value from a register. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCTSIZ2_DOPNG register field value suitable for setting the register. */
#define ALT_USB_HOST_HCTSIZ2_DOPNG_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCTSIZ2.
 */
struct ALT_USB_HOST_HCTSIZ2_s
{
    uint32_t  xfersize : 19;  /* Transfer Size */
    uint32_t  pktcnt   : 10;  /* Packet Count */
    uint32_t  pid      :  2;  /* PID */
    uint32_t  dopng    :  1;  /* Do Ping */
};

/* The typedef declaration for register ALT_USB_HOST_HCTSIZ2. */
typedef volatile struct ALT_USB_HOST_HCTSIZ2_s  ALT_USB_HOST_HCTSIZ2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCTSIZ2 register from the beginning of the component. */
#define ALT_USB_HOST_HCTSIZ2_OFST        0x150
/* The address of the ALT_USB_HOST_HCTSIZ2 register. */
#define ALT_USB_HOST_HCTSIZ2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCTSIZ2_OFST))

/*
 * Register : Host Channel 2 DMA Address Register - hcdma2
 * 
 * This register is used by the OTG host in the internal DMA mode to maintain the
 * current buffer pointer for IN/OUT transactions. The starting DMA address must be
 * DWORD-aligned.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [31:0] | RW     | 0x0   | DMA Address
 * 
 */
/*
 * Field : DMA Address - hcdma2
 * 
 * Non-Isochronous: This field holds the start address of the 512 bytes  page.  The
 * first descriptor in the list should be located in this address. The first
 * descriptor may be or may not be ready. The core starts processing the list from
 * the CTD value. This field holds the address of the 2*(nTD+1) bytes of locations
 * in which the isochronous descriptors are present where N is based on nTD as per
 * Table below
 * 
 * [31:N]  Base Address [N-1:3]  Offset  [2:0]  000
 * 
 * HS ISOC                           FS ISOC
 * 
 * nTD   N                          nTD     N
 * 
 * 7     6                           1       4
 * 
 * 15    7                           3      5
 * 
 * 31    8                           7      6
 * 
 * 63    9                           15     7
 * 
 * 127  10                           31     8
 * 
 * 255  11                           63     9
 * 
 * [N-1:3] (Isoc):[8:3] (Non Isoc): Current Transfer Desc(CTD):  Non Isochronous:
 * This value is in terms of number of descriptors. The values can be from 0 to 63.
 * 0 -  1 descriptor. 63 - 64 descriptors. This field indicates the current
 * descriptor processed in the list. This field is updated both by application and
 * the core. for example, if the application enables the channel after programming
 * CTD=5, then the core will start processing the 6th descriptor. The address is
 * obtained by adding a value of (8bytes*5=) 40(decimal)  to DMAAddr.  Isochronous:
 * CTD for isochronous is based on the current frame/microframe value. Need to be
 * set to zero by application.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMA2_HCDMA2 register field. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMA2_HCDMA2 register field. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMA2_HCDMA2 register field. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMA2_HCDMA2 register field value. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMA2_HCDMA2 register field value. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMA2_HCDMA2 register field. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMA2_HCDMA2 field value from a register. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMA2_HCDMA2 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMA2_HCDMA2_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMA2.
 */
struct ALT_USB_HOST_HCDMA2_s
{
    uint32_t  hcdma2 : 32;  /* DMA Address */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMA2. */
typedef volatile struct ALT_USB_HOST_HCDMA2_s  ALT_USB_HOST_HCDMA2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCDMA2 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMA2_OFST        0x154
/* The address of the ALT_USB_HOST_HCDMA2 register. */
#define ALT_USB_HOST_HCDMA2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMA2_OFST))

/*
 * Register : Host Channel 2 DMA Buffer Address Register - hcdmab2
 * 
 * These  registers  are  present  only  in  case  of  Scatter/Gather  DMA. These
 * registers  are  implemented  in RAM instead of flop-based implementation. Holds
 * the  current  buffer  address.  This  register  is  updated  as  and when  the
 * data  transfer  for  the corresponding  end  point  is  in progress.  This
 * register  is  present  only  in  Scatter/Gather  DMA mode. Otherwise this field
 * is reserved.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                      
 * :-------|:-------|:------|:----------------------------------
 *  [31:0] | RW     | 0x0   | Host Channel 2 DMA Buffer Address
 * 
 */
/*
 * Field : Host Channel 2 DMA Buffer Address - hcdmab2
 * 
 * These  registers  are  present  only  in  case  of  Scatter/Gather DMA. These
 * registers  are  implemented  in RAM instead of flop-based implementation. Holds
 * the  current  buffer  address. This register is updated as and when  the  data
 * transfer for the corresponding  end  point  is  in progress. This register  is
 * present  only  in Scatter/Gather DMA mode. Otherwise this field is reserved.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCDMAB2_HCDMAB2 register field. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCDMAB2_HCDMAB2 register field. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_MSB        31
/* The width in bits of the ALT_USB_HOST_HCDMAB2_HCDMAB2 register field. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_WIDTH      32
/* The mask used to set the ALT_USB_HOST_HCDMAB2_HCDMAB2 register field value. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_SET_MSK    0xffffffff
/* The mask used to clear the ALT_USB_HOST_HCDMAB2_HCDMAB2 register field value. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_CLR_MSK    0x00000000
/* The reset value of the ALT_USB_HOST_HCDMAB2_HCDMAB2 register field. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_RESET      0x0
/* Extracts the ALT_USB_HOST_HCDMAB2_HCDMAB2 field value from a register. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_USB_HOST_HCDMAB2_HCDMAB2 register field value suitable for setting the register. */
#define ALT_USB_HOST_HCDMAB2_HCDMAB2_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCDMAB2.
 */
struct ALT_USB_HOST_HCDMAB2_s
{
    uint32_t  hcdmab2 : 32;  /* Host Channel 2 DMA Buffer Address */
};

/* The typedef declaration for register ALT_USB_HOST_HCDMAB2. */
typedef volatile struct ALT_USB_HOST_HCDMAB2_s  ALT_USB_HOST_HCDMAB2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCDMAB2 register from the beginning of the component. */
#define ALT_USB_HOST_HCDMAB2_OFST        0x158
/* The address of the ALT_USB_HOST_HCDMAB2 register. */
#define ALT_USB_HOST_HCDMAB2_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCDMAB2_OFST))

/*
 * Register : Host Channel 3 Characteristics Register - hcchar3
 * 
 * Channel_number: 3.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description            
 * :--------|:-------|:------|:------------------------
 *  [10:0]  | RW     | 0x0   | Maximum Packet Size    
 *  [14:11] | RW     | 0x0   | Endpoint Number        
 *  [15]    | RW     | 0x0   | Endpoint Direction     
 *  [16]    | ???    | 0x0   | *UNDEFINED*            
 *  [17]    | RW     | 0x0   | Low-Speed Device       
 *  [19:18] | RW     | 0x0   | Endpoint Type          
 *  [21:20] | RW     | 0x0   | Multi Count Error Count
 *  [28:22] | RW     | 0x0   | Device Address         
 *  [29]    | ???    | 0x0   | *UNDEFINED*            
 *  [30]    | R      | 0x0   | Channel Disable        
 *  [31]    | R      | 0x0   | Channel Enable         
 * 
 */
/*
 * Field : Maximum Packet Size - mps
 * 
 * Indicates the maximum packet size of the associated endpoint.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_MPS register field. */
#define ALT_USB_HOST_HCCHAR3_MPS_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_MPS register field. */
#define ALT_USB_HOST_HCCHAR3_MPS_MSB        10
/* The width in bits of the ALT_USB_HOST_HCCHAR3_MPS register field. */
#define ALT_USB_HOST_HCCHAR3_MPS_WIDTH      11
/* The mask used to set the ALT_USB_HOST_HCCHAR3_MPS register field value. */
#define ALT_USB_HOST_HCCHAR3_MPS_SET_MSK    0x000007ff
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_MPS register field value. */
#define ALT_USB_HOST_HCCHAR3_MPS_CLR_MSK    0xfffff800
/* The reset value of the ALT_USB_HOST_HCCHAR3_MPS register field. */
#define ALT_USB_HOST_HCCHAR3_MPS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_MPS field value from a register. */
#define ALT_USB_HOST_HCCHAR3_MPS_GET(value) (((value) & 0x000007ff) >> 0)
/* Produces a ALT_USB_HOST_HCCHAR3_MPS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_MPS_SET(value) (((value) << 0) & 0x000007ff)

/*
 * Field : Endpoint Number - epnum
 * 
 * Indicates the endpoint number on the device serving as the data source or sink.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description  
 * :-------------------------------------|:------|:--------------
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT0  | 0x0   | End point  0 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT1  | 0x1   | End point  1 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT2  | 0x2   | End point  2 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT3  | 0x3   | End point  3 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT4  | 0x4   | End point  4 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT5  | 0x5   | End point  5 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT6  | 0x6   | End point  6 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT7  | 0x7   | End point  7 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT8  | 0x8   | End point  8 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT9  | 0x9   | End point  9 
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT10 | 0xa   | End point  10
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT11 | 0xb   | End point  11
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT12 | 0xc   | End point  12
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT13 | 0xd   | End point  13
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT14 | 0xe   | End point  14
 *  ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT15 | 0xf   | End point  15
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  0
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT0     0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  1
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT1     0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  2
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT2     0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  3
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT3     0x3
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  4
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT4     0x4
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  5
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT5     0x5
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  6
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT6     0x6
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  7
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT7     0x7
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  8
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT8     0x8
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  9
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT9     0x9
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  10
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT10    0xa
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  11
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT11    0xb
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  12
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT12    0xc
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  13
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT13    0xd
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  14
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT14    0xe
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPNUM
 * 
 * End point  15
 */
#define ALT_USB_HOST_HCCHAR3_EPNUM_E_ENDPT15    0xf

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_MSB        14
/* The width in bits of the ALT_USB_HOST_HCCHAR3_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_WIDTH      4
/* The mask used to set the ALT_USB_HOST_HCCHAR3_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_SET_MSK    0x00007800
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_EPNUM register field value. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_CLR_MSK    0xffff87ff
/* The reset value of the ALT_USB_HOST_HCCHAR3_EPNUM register field. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_EPNUM field value from a register. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_GET(value) (((value) & 0x00007800) >> 11)
/* Produces a ALT_USB_HOST_HCCHAR3_EPNUM register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_EPNUM_SET(value) (((value) << 11) & 0x00007800)

/*
 * Field : Endpoint Direction - epdir
 * 
 * Indicates whether the transaction is IN or OUT.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description
 * :------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR3_EPDIR_E_OUTDIR | 0x0   | OUT        
 *  ALT_USB_HOST_HCCHAR3_EPDIR_E_INDIR  | 0x1   | IN         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPDIR
 * 
 * OUT
 */
#define ALT_USB_HOST_HCCHAR3_EPDIR_E_OUTDIR 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPDIR
 * 
 * IN
 */
#define ALT_USB_HOST_HCCHAR3_EPDIR_E_INDIR  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_MSB        15
/* The width in bits of the ALT_USB_HOST_HCCHAR3_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR3_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_SET_MSK    0x00008000
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_EPDIR register field value. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_CLR_MSK    0xffff7fff
/* The reset value of the ALT_USB_HOST_HCCHAR3_EPDIR register field. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_EPDIR field value from a register. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_USB_HOST_HCCHAR3_EPDIR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_EPDIR_SET(value) (((value) << 15) & 0x00008000)

/*
 * Field : Low-Speed Device - lspddev
 * 
 * This field is Set by the application to indicate that this channel is
 * communicating to a low-speed device. The application must program this bit when
 * a low speed device is connected to the host through an FS HUB. The HS OTG Host
 * core uses this field to drive the XCVR_SELECT signal to 0x3 while communicating
 * to the LS Device through the FS hub. In a peer to peer setup, the HS OTG Host
 * core ignores this bit even if it is set by the application software.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                    
 * :-------------------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCCHAR3_LSPDDEV_E_NONLOWSPEED | 0x0   | Communicating with non lowspeed
 *  ALT_USB_HOST_HCCHAR3_LSPDDEV_E_LOWSPEED    | 0x1   | Communicating with lowspeed    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_LSPDDEV
 * 
 * Communicating with non lowspeed
 */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_E_NONLOWSPEED  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_LSPDDEV
 * 
 * Communicating with lowspeed
 */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_E_LOWSPEED     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_LSB        17
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_MSB        17
/* The width in bits of the ALT_USB_HOST_HCCHAR3_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR3_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_SET_MSK    0x00020000
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_LSPDDEV register field value. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_CLR_MSK    0xfffdffff
/* The reset value of the ALT_USB_HOST_HCCHAR3_LSPDDEV register field. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_LSPDDEV field value from a register. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_GET(value) (((value) & 0x00020000) >> 17)
/* Produces a ALT_USB_HOST_HCCHAR3_LSPDDEV register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_LSPDDEV_SET(value) (((value) << 17) & 0x00020000)

/*
 * Field : Endpoint Type - eptype
 * 
 * Indicates the transfer type selected.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description
 * :-------------------------------------|:------|:------------
 *  ALT_USB_HOST_HCCHAR3_EPTYPE_E_CTL    | 0x0   | Control    
 *  ALT_USB_HOST_HCCHAR3_EPTYPE_E_ISOC   | 0x1   | Isochronous
 *  ALT_USB_HOST_HCCHAR3_EPTYPE_E_BULK   | 0x2   | Bulk       
 *  ALT_USB_HOST_HCCHAR3_EPTYPE_E_INTERR | 0x3   | Interrupt  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPTYPE
 * 
 * Control
 */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_E_CTL       0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPTYPE
 * 
 * Isochronous
 */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_E_ISOC      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPTYPE
 * 
 * Bulk
 */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_E_BULK      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EPTYPE
 * 
 * Interrupt
 */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_E_INTERR    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_LSB        18
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_MSB        19
/* The width in bits of the ALT_USB_HOST_HCCHAR3_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR3_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_SET_MSK    0x000c0000
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_EPTYPE register field value. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_CLR_MSK    0xfff3ffff
/* The reset value of the ALT_USB_HOST_HCCHAR3_EPTYPE register field. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_EPTYPE field value from a register. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_GET(value) (((value) & 0x000c0000) >> 18)
/* Produces a ALT_USB_HOST_HCCHAR3_EPTYPE register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_EPTYPE_SET(value) (((value) << 18) & 0x000c0000)

/*
 * Field : Multi Count Error Count - ec
 * 
 * When the Split Enable bit of the Host Channel-n Split Control register
 * (HCSPLTn.SpltEna) is reset (0), this field indicates to the host the number of
 * transactions that must be executed per microframe for this periodic endpoint.
 * for non periodic transfers, this field is used only in DMA mode, and specifies
 * the number packets to be fetched for this channel before the internal DMA engine
 * changes arbitration. When HCSPLTn.SpltEna is Set (1), this field indicates the
 * number of immediate retries to be performed for a periodic split transactions on
 * transaction errors. This field must be Set to at least 1.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                  
 * :-------------------------------------|:------|:----------------------------------------------
 *  ALT_USB_HOST_HCCHAR3_EC_E_RSVD       | 0x0   | Reserved This field yields undefined results 
 *  ALT_USB_HOST_HCCHAR3_EC_E_TRANSONE   | 0x1   | 1 transaction                                
 *  ALT_USB_HOST_HCCHAR3_EC_E_TRANSTWO   | 0x2   | 2 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 *  ALT_USB_HOST_HCCHAR3_EC_E_TRANSTHREE | 0x3   | 3 transactions to be issued for this endpoint
 * :                                     |       | per microframe                               
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EC
 * 
 * Reserved This field yields undefined results
 */
#define ALT_USB_HOST_HCCHAR3_EC_E_RSVD          0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EC
 * 
 * 1 transaction
 */
#define ALT_USB_HOST_HCCHAR3_EC_E_TRANSONE      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EC
 * 
 * 2 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR3_EC_E_TRANSTWO      0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_EC
 * 
 * 3 transactions to be issued for this endpoint per microframe
 */
#define ALT_USB_HOST_HCCHAR3_EC_E_TRANSTHREE    0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_EC register field. */
#define ALT_USB_HOST_HCCHAR3_EC_LSB        20
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_EC register field. */
#define ALT_USB_HOST_HCCHAR3_EC_MSB        21
/* The width in bits of the ALT_USB_HOST_HCCHAR3_EC register field. */
#define ALT_USB_HOST_HCCHAR3_EC_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCCHAR3_EC register field value. */
#define ALT_USB_HOST_HCCHAR3_EC_SET_MSK    0x00300000
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_EC register field value. */
#define ALT_USB_HOST_HCCHAR3_EC_CLR_MSK    0xffcfffff
/* The reset value of the ALT_USB_HOST_HCCHAR3_EC register field. */
#define ALT_USB_HOST_HCCHAR3_EC_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_EC field value from a register. */
#define ALT_USB_HOST_HCCHAR3_EC_GET(value) (((value) & 0x00300000) >> 20)
/* Produces a ALT_USB_HOST_HCCHAR3_EC register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_EC_SET(value) (((value) << 20) & 0x00300000)

/*
 * Field : Device Address - devaddr
 * 
 * This field selects the specific device serving as the data source or sink.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_LSB        22
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_MSB        28
/* The width in bits of the ALT_USB_HOST_HCCHAR3_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCCHAR3_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_SET_MSK    0x1fc00000
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_DEVADDR register field value. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_CLR_MSK    0xe03fffff
/* The reset value of the ALT_USB_HOST_HCCHAR3_DEVADDR register field. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_DEVADDR field value from a register. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_GET(value) (((value) & 0x1fc00000) >> 22)
/* Produces a ALT_USB_HOST_HCCHAR3_DEVADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_DEVADDR_SET(value) (((value) << 22) & 0x1fc00000)

/*
 * Field : Channel Disable - chdis
 * 
 * The application sets this bit to stop transmitting/receiving data on a channel,
 * even before the transfer for that channel is complete. The application must wait
 * for the Channel Disabled interrupt before treating the channel as disabled.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                     
 * :-----------------------------------|:------|:---------------------------------
 *  ALT_USB_HOST_HCCHAR3_CHDIS_E_INACT | 0x0   | No activity                     
 *  ALT_USB_HOST_HCCHAR3_CHDIS_E_ACT   | 0x1   | Stop transmitting/receiving data
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_CHDIS
 * 
 * No activity
 */
#define ALT_USB_HOST_HCCHAR3_CHDIS_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_CHDIS
 * 
 * Stop transmitting/receiving data
 */
#define ALT_USB_HOST_HCCHAR3_CHDIS_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_LSB        30
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_MSB        30
/* The width in bits of the ALT_USB_HOST_HCCHAR3_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR3_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_SET_MSK    0x40000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_CHDIS register field value. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_CLR_MSK    0xbfffffff
/* The reset value of the ALT_USB_HOST_HCCHAR3_CHDIS register field. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_CHDIS field value from a register. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_GET(value) (((value) & 0x40000000) >> 30)
/* Produces a ALT_USB_HOST_HCCHAR3_CHDIS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_CHDIS_SET(value) (((value) << 30) & 0x40000000)

/*
 * Field : Channel Enable - chena
 * 
 * When Scatter/Gather mode is disabled. This field is set by the application and
 * cleared by the OTG host.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                                     
 * :------------------------------------|:------|:-------------------------------------------------
 *  ALT_USB_HOST_HCCHAR3_CHENA_E_NOTRDY | 0x0   | Indicates that the descriptor structure is not  
 * :                                    |       | yet ready                                       
 *  ALT_USB_HOST_HCCHAR3_CHENA_E_RDY    | 0x1   | Indicates that the descriptor structure and data
 * :                                    |       | buffer with data is setup and this channel can  
 * :                                    |       | access the descriptor                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_CHENA
 * 
 * Indicates that the descriptor structure is not yet ready
 */
#define ALT_USB_HOST_HCCHAR3_CHENA_E_NOTRDY 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCCHAR3_CHENA
 * 
 * Indicates that the descriptor structure and data  buffer with data is setup and
 * this channel can access the descriptor
 */
#define ALT_USB_HOST_HCCHAR3_CHENA_E_RDY    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCCHAR3_CHENA register field. */
#define ALT_USB_HOST_HCCHAR3_CHENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCCHAR3_CHENA register field. */
#define ALT_USB_HOST_HCCHAR3_CHENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCCHAR3_CHENA register field. */
#define ALT_USB_HOST_HCCHAR3_CHENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCCHAR3_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR3_CHENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCCHAR3_CHENA register field value. */
#define ALT_USB_HOST_HCCHAR3_CHENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCCHAR3_CHENA register field. */
#define ALT_USB_HOST_HCCHAR3_CHENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCCHAR3_CHENA field value from a register. */
#define ALT_USB_HOST_HCCHAR3_CHENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCCHAR3_CHENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCCHAR3_CHENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCCHAR3.
 */
struct ALT_USB_HOST_HCCHAR3_s
{
    uint32_t        mps     : 11;  /* Maximum Packet Size */
    uint32_t        epnum   :  4;  /* Endpoint Number */
    uint32_t        epdir   :  1;  /* Endpoint Direction */
    uint32_t                :  1;  /* *UNDEFINED* */
    uint32_t        lspddev :  1;  /* Low-Speed Device */
    uint32_t        eptype  :  2;  /* Endpoint Type */
    uint32_t        ec      :  2;  /* Multi Count Error Count */
    uint32_t        devaddr :  7;  /* Device Address */
    uint32_t                :  1;  /* *UNDEFINED* */
    const uint32_t  chdis   :  1;  /* Channel Disable */
    const uint32_t  chena   :  1;  /* Channel Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCCHAR3. */
typedef volatile struct ALT_USB_HOST_HCCHAR3_s  ALT_USB_HOST_HCCHAR3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCCHAR3 register from the beginning of the component. */
#define ALT_USB_HOST_HCCHAR3_OFST        0x160
/* The address of the ALT_USB_HOST_HCCHAR3 register. */
#define ALT_USB_HOST_HCCHAR3_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCCHAR3_OFST))

/*
 * Register : Host Channel 3 Split Control Register - hcsplt3
 * 
 * Channel_number 3
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description         
 * :--------|:-------|:------|:---------------------
 *  [6:0]   | RW     | 0x0   | Port Address        
 *  [13:7]  | RW     | 0x0   | Hub Address         
 *  [15:14] | RW     | 0x0   | Transaction Position
 *  [16]    | RW     | 0x0   | Do Complete Split   
 *  [30:17] | ???    | 0x0   | *UNDEFINED*         
 *  [31]    | RW     | 0x0   | Split Enable        
 * 
 */
/*
 * Field : Port Address - prtaddr
 * 
 * This field is the port number of the recipient transactiontranslator.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT3_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT3_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_MSB        6
/* The width in bits of the ALT_USB_HOST_HCSPLT3_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT3_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_SET_MSK    0x0000007f
/* The mask used to clear the ALT_USB_HOST_HCSPLT3_PRTADDR register field value. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_CLR_MSK    0xffffff80
/* The reset value of the ALT_USB_HOST_HCSPLT3_PRTADDR register field. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT3_PRTADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_GET(value) (((value) & 0x0000007f) >> 0)
/* Produces a ALT_USB_HOST_HCSPLT3_PRTADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT3_PRTADDR_SET(value) (((value) << 0) & 0x0000007f)

/*
 * Field : Hub Address - hubaddr
 * 
 * This field holds the device address of the transaction translator's hub.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT3_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT3_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_MSB        13
/* The width in bits of the ALT_USB_HOST_HCSPLT3_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_WIDTH      7
/* The mask used to set the ALT_USB_HOST_HCSPLT3_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_SET_MSK    0x00003f80
/* The mask used to clear the ALT_USB_HOST_HCSPLT3_HUBADDR register field value. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_CLR_MSK    0xffffc07f
/* The reset value of the ALT_USB_HOST_HCSPLT3_HUBADDR register field. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT3_HUBADDR field value from a register. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_GET(value) (((value) & 0x00003f80) >> 7)
/* Produces a ALT_USB_HOST_HCSPLT3_HUBADDR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT3_HUBADDR_SET(value) (((value) << 7) & 0x00003f80)

/*
 * Field : Transaction Position - xactpos
 * 
 * This field is used to determine whether to send all, first, middle, or last
 * payloads with each OUT transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                    
 * :--------------------------------------|:------|:------------------------------------------------
 *  ALT_USB_HOST_HCSPLT3_XACTPOS_E_MIDDLE | 0x0   | Mid. This is the middle payload of this        
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT3_XACTPOS_E_END    | 0x1   | End. This is the last payload of this          
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT3_XACTPOS_E_BEGIN  | 0x2   | Begin. This is the first data payload of this  
 * :                                      |       | transaction (which is larger than 188 bytes)   
 *  ALT_USB_HOST_HCSPLT3_XACTPOS_E_ALL    | 0x3   | All. This is the entire data payload is of this
 * :                                      |       | transaction (which is less than or equal to 188
 * :                                      |       | bytes)                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_XACTPOS
 * 
 * Mid. This is the middle payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_E_MIDDLE   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_XACTPOS
 * 
 * End. This is the last payload of this transaction (which is larger than 188
 * bytes)
 */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_E_END      0x1
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_XACTPOS
 * 
 * Begin. This is the first data payload of this transaction (which is larger than
 * 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_E_BEGIN    0x2
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_XACTPOS
 * 
 * All. This is the entire data payload is of this transaction (which is less than
 * or equal to 188 bytes)
 */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_E_ALL      0x3

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT3_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT3_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_MSB        15
/* The width in bits of the ALT_USB_HOST_HCSPLT3_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_WIDTH      2
/* The mask used to set the ALT_USB_HOST_HCSPLT3_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_SET_MSK    0x0000c000
/* The mask used to clear the ALT_USB_HOST_HCSPLT3_XACTPOS register field value. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_CLR_MSK    0xffff3fff
/* The reset value of the ALT_USB_HOST_HCSPLT3_XACTPOS register field. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT3_XACTPOS field value from a register. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_GET(value) (((value) & 0x0000c000) >> 14)
/* Produces a ALT_USB_HOST_HCSPLT3_XACTPOS register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT3_XACTPOS_SET(value) (((value) << 14) & 0x0000c000)

/*
 * Field : Do Complete Split - compsplt
 * 
 * The application sets this field to request the OTG host to perform a complete
 * split transaction.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description         
 * :----------------------------------------|:------|:---------------------
 *  ALT_USB_HOST_HCSPLT3_COMPSPLT_E_NOSPLIT | 0x0   | No split transaction
 *  ALT_USB_HOST_HCSPLT3_COMPSPLT_E_SPLIT   | 0x1   | Split transaction   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_COMPSPLT
 * 
 * No split transaction
 */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_E_NOSPLIT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_COMPSPLT
 * 
 * Split transaction
 */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_E_SPLIT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT3_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT3_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_MSB        16
/* The width in bits of the ALT_USB_HOST_HCSPLT3_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT3_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_SET_MSK    0x00010000
/* The mask used to clear the ALT_USB_HOST_HCSPLT3_COMPSPLT register field value. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_CLR_MSK    0xfffeffff
/* The reset value of the ALT_USB_HOST_HCSPLT3_COMPSPLT register field. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT3_COMPSPLT field value from a register. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_GET(value) (((value) & 0x00010000) >> 16)
/* Produces a ALT_USB_HOST_HCSPLT3_COMPSPLT register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT3_COMPSPLT_SET(value) (((value) << 16) & 0x00010000)

/*
 * Field : Split Enable - spltena
 * 
 * The application sets this field to indicate that this channel is enabled to
 * perform split transactions.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description      
 * :------------------------------------|:------|:------------------
 *  ALT_USB_HOST_HCSPLT3_SPLTENA_E_DISD | 0x0   | Split not enabled
 *  ALT_USB_HOST_HCSPLT3_SPLTENA_E_END  | 0x1   | Split enabled    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_SPLTENA
 * 
 * Split not enabled
 */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_E_DISD 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCSPLT3_SPLTENA
 * 
 * Split enabled
 */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_E_END  0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCSPLT3_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_LSB        31
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCSPLT3_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_MSB        31
/* The width in bits of the ALT_USB_HOST_HCSPLT3_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCSPLT3_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_SET_MSK    0x80000000
/* The mask used to clear the ALT_USB_HOST_HCSPLT3_SPLTENA register field value. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_CLR_MSK    0x7fffffff
/* The reset value of the ALT_USB_HOST_HCSPLT3_SPLTENA register field. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_RESET      0x0
/* Extracts the ALT_USB_HOST_HCSPLT3_SPLTENA field value from a register. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_GET(value) (((value) & 0x80000000) >> 31)
/* Produces a ALT_USB_HOST_HCSPLT3_SPLTENA register field value suitable for setting the register. */
#define ALT_USB_HOST_HCSPLT3_SPLTENA_SET(value) (((value) << 31) & 0x80000000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_USB_HOST_HCSPLT3.
 */
struct ALT_USB_HOST_HCSPLT3_s
{
    uint32_t  prtaddr  :  7;  /* Port Address */
    uint32_t  hubaddr  :  7;  /* Hub Address */
    uint32_t  xactpos  :  2;  /* Transaction Position */
    uint32_t  compsplt :  1;  /* Do Complete Split */
    uint32_t           : 14;  /* *UNDEFINED* */
    uint32_t  spltena  :  1;  /* Split Enable */
};

/* The typedef declaration for register ALT_USB_HOST_HCSPLT3. */
typedef volatile struct ALT_USB_HOST_HCSPLT3_s  ALT_USB_HOST_HCSPLT3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_USB_HOST_HCSPLT3 register from the beginning of the component. */
#define ALT_USB_HOST_HCSPLT3_OFST        0x164
/* The address of the ALT_USB_HOST_HCSPLT3 register. */
#define ALT_USB_HOST_HCSPLT3_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_USB_HOST_HCSPLT3_OFST))

/*
 * Register : Host Channel 3 Interrupt Register - hcint3
 * 
 * This register indicates the status of a channel with respect to USB- and AHB-
 * related events. The application must read this register when the Host Channels
 * Interrupt bit of the Core Interrupt register (GINTSTS.HChInt) is set. Before the
 * application can read this register, it must first read the Host All Channels
 * Interrupt (HAINT) register to get the exact channel number for the Host
 * Channel-n Interrupt register. The application must clear the appropriate bit in
 * this register to clear the corresponding bits in the HAINT and GINTSTS
 * registers.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                
 * :--------|:-------|:------|:--------------------------------------------
 *  [0]     | R      | 0x0   | Transfer Completed                         
 *  [1]     | R      | 0x0   | Channel Halted                             
 *  [2]     | R      | 0x0   | AHB Error                                  
 *  [3]     | R      | 0x0   | STALL Response Received Interrupt          
 *  [4]     | R      | 0x0   | NAK Response Received Interrupt            
 *  [5]     | R      | 0x0   | ACK Response Received Transmitted Interrupt
 *  [6]     | R      | 0x0   | NYET Response Received Interrupt           
 *  [7]     | R      | 0x0   | Transaction Error                          
 *  [8]     | R      | 0x0   | Babble Error                               
 *  [9]     | R      | 0x0   | Frame Overrun                              
 *  [10]    | R      | 0x0   | Data Toggle Error                          
 *  [11]    | R      | 0x0   | BNA Interrupt                              
 *  [12]    | R      | 0x0   | Excessive Transaction Error                
 *  [13]    | R      | 0x0   | Descriptor rollover interrupt              
 *  [31:14] | ???    | 0x0   | *UNDEFINED*                                
 * 
 */
/*
 * Field : Transfer Completed - xfercompl
 * 
 * Transfer completed normally without any errors. This bit can be set only by the
 * core and the application should write 1 to clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                   
 * :--------------------------------------|:------|:-----------------------------------------------
 *  ALT_USB_HOST_HCINT3_XFERCOMPL_E_INACT | 0x0   | No transfer                                   
 *  ALT_USB_HOST_HCINT3_XFERCOMPL_E_ACT   | 0x1   | Transfer completed normally without any errors
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_XFERCOMPL
 * 
 * No transfer
 */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_XFERCOMPL
 * 
 * Transfer completed normally without any errors
 */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT3_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT3_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_MSB        0
/* The width in bits of the ALT_USB_HOST_HCINT3_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT3_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_SET_MSK    0x00000001
/* The mask used to clear the ALT_USB_HOST_HCINT3_XFERCOMPL register field value. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_USB_HOST_HCINT3_XFERCOMPL register field. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT3_XFERCOMPL field value from a register. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_USB_HOST_HCINT3_XFERCOMPL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT3_XFERCOMPL_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Halted - chhltd
 * 
 * In non Scatter/Gather DMA mode, it indicates the transfer completed abnormally
 * either because of any USB transaction error or in response to disable request by
 * the application or because of a completed transfer. In Scatter/gather DMA mode,
 * this indicates that transfer completed due to any of the following
 * 
 * . EOL being set in descriptor
 * 
 * . AHB error
 * 
 * . Excessive transaction errors
 * 
 * . Babble
 * 
 * . Stall
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description       
 * :-----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT3_CHHLTD_E_INACT | 0x0   | Channel not halted
 *  ALT_USB_HOST_HCINT3_CHHLTD_E_ACT   | 0x1   | Channel Halted    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_CHHLTD
 * 
 * Channel not halted
 */
#define ALT_USB_HOST_HCINT3_CHHLTD_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_CHHLTD
 * 
 * Channel Halted
 */
#define ALT_USB_HOST_HCINT3_CHHLTD_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT3_CHHLTD register field. */
#define ALT_USB_HOST_HCINT3_CHHLTD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT3_CHHLTD register field. */
#define ALT_USB_HOST_HCINT3_CHHLTD_MSB        1
/* The width in bits of the ALT_USB_HOST_HCINT3_CHHLTD register field. */
#define ALT_USB_HOST_HCINT3_CHHLTD_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT3_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT3_CHHLTD_SET_MSK    0x00000002
/* The mask used to clear the ALT_USB_HOST_HCINT3_CHHLTD register field value. */
#define ALT_USB_HOST_HCINT3_CHHLTD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_USB_HOST_HCINT3_CHHLTD register field. */
#define ALT_USB_HOST_HCINT3_CHHLTD_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT3_CHHLTD field value from a register. */
#define ALT_USB_HOST_HCINT3_CHHLTD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_USB_HOST_HCINT3_CHHLTD register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT3_CHHLTD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : AHB Error - ahberr
 * 
 * This is generated only in Internal DMA mode when there is an AHB error during
 * AHB read/write. The application can read the corresponding channel's DMA address
 * register to get the error address.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                    
 * :-----------------------------------|:------|:--------------------------------
 *  ALT_USB_HOST_HCINT3_AHBERR_E_INACT | 0x0   | No AHB error                   
 *  ALT_USB_HOST_HCINT3_AHBERR_E_ACT   | 0x1   | AHB error during AHB read/write
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_AHBERR
 * 
 * No AHB error
 */
#define ALT_USB_HOST_HCINT3_AHBERR_E_INACT  0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_AHBERR
 * 
 * AHB error during AHB read/write
 */
#define ALT_USB_HOST_HCINT3_AHBERR_E_ACT    0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT3_AHBERR register field. */
#define ALT_USB_HOST_HCINT3_AHBERR_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT3_AHBERR register field. */
#define ALT_USB_HOST_HCINT3_AHBERR_MSB        2
/* The width in bits of the ALT_USB_HOST_HCINT3_AHBERR register field. */
#define ALT_USB_HOST_HCINT3_AHBERR_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT3_AHBERR register field value. */
#define ALT_USB_HOST_HCINT3_AHBERR_SET_MSK    0x00000004
/* The mask used to clear the ALT_USB_HOST_HCINT3_AHBERR register field value. */
#define ALT_USB_HOST_HCINT3_AHBERR_CLR_MSK    0xfffffffb
/* The reset value of the ALT_USB_HOST_HCINT3_AHBERR register field. */
#define ALT_USB_HOST_HCINT3_AHBERR_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT3_AHBERR field value from a register. */
#define ALT_USB_HOST_HCINT3_AHBERR_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_USB_HOST_HCINT3_AHBERR register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT3_AHBERR_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : STALL Response Received Interrupt - stall
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the core.
 * This bit can be set only by the core and the application should write 1 to clear
 * it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                              | Value | Description       
 * :----------------------------------|:------|:-------------------
 *  ALT_USB_HOST_HCINT3_STALL_E_INACT | 0x0   | No Stall Interrupt
 *  ALT_USB_HOST_HCINT3_STALL_E_ACT   | 0x1   | Stall Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_STALL
 * 
 * No Stall Interrupt
 */
#define ALT_USB_HOST_HCINT3_STALL_E_INACT   0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_STALL
 * 
 * Stall Interrupt
 */
#define ALT_USB_HOST_HCINT3_STALL_E_ACT     0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT3_STALL register field. */
#define ALT_USB_HOST_HCINT3_STALL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT3_STALL register field. */
#define ALT_USB_HOST_HCINT3_STALL_MSB        3
/* The width in bits of the ALT_USB_HOST_HCINT3_STALL register field. */
#define ALT_USB_HOST_HCINT3_STALL_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT3_STALL register field value. */
#define ALT_USB_HOST_HCINT3_STALL_SET_MSK    0x00000008
/* The mask used to clear the ALT_USB_HOST_HCINT3_STALL register field value. */
#define ALT_USB_HOST_HCINT3_STALL_CLR_MSK    0xfffffff7
/* The reset value of the ALT_USB_HOST_HCINT3_STALL register field. */
#define ALT_USB_HOST_HCINT3_STALL_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT3_STALL field value from a register. */
#define ALT_USB_HOST_HCINT3_STALL_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_USB_HOST_HCINT3_STALL register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT3_STALL_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NAK Response Received Interrupt - nak
 * 
 * In Scatter/Gather DMA mode, the interrupt due to this bit is masked in the
 * core.This bit can be set only by the core and the application should write 1 to
 * clear it.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                       
 * :--------------------------------|:------|:-----------------------------------
 *  ALT_USB_HOST_HCINT3_NAK_E_INACT | 0x0   | No NAK Response Received Interrupt
 *  ALT_USB_HOST_HCINT3_NAK_E_ACT   | 0x1   | NAK Response Received Interrupt   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_NAK
 * 
 * No NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT3_NAK_E_INACT 0x0
/*
 * Enumerated value for register field ALT_USB_HOST_HCINT3_NAK
 * 
 * NAK Response Received Interrupt
 */
#define ALT_USB_HOST_HCINT3_NAK_E_ACT   0x1

/* The Least Significant Bit (LSB) position of the ALT_USB_HOST_HCINT3_NAK register field. */
#define ALT_USB_HOST_HCINT3_NAK_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_USB_HOST_HCINT3_NAK register field. */
#define ALT_USB_HOST_HCINT3_NAK_MSB        4
/* The width in bits of the ALT_USB_HOST_HCINT3_NAK register field. */
#define ALT_USB_HOST_HCINT3_NAK_WIDTH      1
/* The mask used to set the ALT_USB_HOST_HCINT3_NAK register field value. */
#define ALT_USB_HOST_HCINT3_NAK_SET_MSK    0x00000010
/* The mask used to clear the ALT_USB_HOST_HCINT3_NAK register field value. */
#define ALT_USB_HOST_HCINT3_NAK_CLR_MSK    0xffffffef
/* The reset value of the ALT_USB_HOST_HCINT3_NAK register field. */
#define ALT_USB_HOST_HCINT3_NAK_RESET      0x0
/* Extracts the ALT_USB_HOST_HCINT3_NAK field value from a register. */
#define ALT_USB_HOST_HCINT3_NAK_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_USB_HOST_HCINT3_NAK register field value suitable for setting the register. */
#define ALT_USB_HOST_HCINT3_NAK_SET(val