
/****************************************************************************************************//**
 * @file     XMC4200.h
 *
 * @brief    CMSIS Cortex-M4 Peripheral Access Layer Header File for
 *           XMC4200 from Infineon.
 *
 * @version  V1.1.0 (Reference Manual v1.1)
 * @date     10. January 2013
 *
 * @note     Generated with SVDConv V2.78b 
 *           from CMSIS SVD File 'XMC4200_Processed_SVD.xml' Version 1.1.0 (Reference Manual v1.1),
 *******************************************************************************************************/



/** @addtogroup Infineon
  * @{
  */

/** @addtogroup XMC4200
  * @{
  */

#ifndef XMC4200_H
#define XMC4200_H

#ifdef __cplusplus
extern "C" {
#endif


/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum {
/* -------------------  Cortex-M4 Processor Exceptions Numbers  ------------------- */
  Reset_IRQn                    = -15,              /*!<   1  Reset Vector, invoked on Power up and warm reset                 */
  NonMaskableInt_IRQn           = -14,              /*!<   2  Non maskable Interrupt, cannot be stopped or preempted           */
  HardFault_IRQn                = -13,              /*!<   3  Hard Fault, all classes of Fault                                 */
  MemoryManagement_IRQn         = -12,              /*!<   4  Memory Management, MPU mismatch, including Access Violation
                                                         and No Match                                                          */
  BusFault_IRQn                 = -11,              /*!<   5  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                         related Fault                                                         */
  UsageFault_IRQn               = -10,              /*!<   6  Usage Fault, i.e. Undef Instruction, Illegal State Transition    */
  SVCall_IRQn                   =  -5,              /*!<  11  System Service Call via SVC instruction                          */
  DebugMonitor_IRQn             =  -4,              /*!<  12  Debug Monitor                                                    */
  PendSV_IRQn                   =  -2,              /*!<  14  Pendable request for system service                              */
  SysTick_IRQn                  =  -1,              /*!<  15  System Tick Timer                                                */
/* ---------------------  XMC4200 Specific Interrupt Numbers  --------------------- */
  SCU_0_IRQn                    =   0,              /*!<   0  SCU_0                                                            */
  ERU0_0_IRQn                   =   1,              /*!<   1  ERU0_0                                                           */
  ERU0_1_IRQn                   =   2,              /*!<   2  ERU0_1                                                           */
  ERU0_2_IRQn                   =   3,              /*!<   3  ERU0_2                                                           */
  ERU0_3_IRQn                   =   4,              /*!<   4  ERU0_3                                                           */
  ERU1_0_IRQn                   =   5,              /*!<   5  ERU1_0                                                           */
  ERU1_1_IRQn                   =   6,              /*!<   6  ERU1_1                                                           */
  ERU1_2_IRQn                   =   7,              /*!<   7  ERU1_2                                                           */
  ERU1_3_IRQn                   =   8,              /*!<   8  ERU1_3                                                           */
  PMU0_0_IRQn                   =  12,              /*!<  12  PMU0_0                                                           */
  VADC0_C0_0_IRQn               =  14,              /*!<  14  VADC0_C0_0                                                       */
  VADC0_C0_1_IRQn               =  15,              /*!<  15  VADC0_C0_1                                                       */
  VADC0_C0_2_IRQn               =  16,              /*!<  16  VADC0_C0_2                                                       */
  VADC0_C0_3_IRQn               =  17,              /*!<  17  VADC0_C0_3                                                       */
  VADC0_G0_0_IRQn               =  18,              /*!<  18  VADC0_G0_0                                                       */
  VADC0_G0_1_IRQn               =  19,              /*!<  19  VADC0_G0_1                                                       */
  VADC0_G0_2_IRQn               =  20,              /*!<  20  VADC0_G0_2                                                       */
  VADC0_G0_3_IRQn               =  21,              /*!<  21  VADC0_G0_3                                                       */
  VADC0_G1_0_IRQn               =  22,              /*!<  22  VADC0_G1_0                                                       */
  VADC0_G1_1_IRQn               =  23,              /*!<  23  VADC0_G1_1                                                       */
  VADC0_G1_2_IRQn               =  24,              /*!<  24  VADC0_G1_2                                                       */
  VADC0_G1_3_IRQn               =  25,              /*!<  25  VADC0_G1_3                                                       */
  DAC0_0_IRQn                   =  42,              /*!<  42  DAC0_0                                                           */
  DAC0_1_IRQn                   =  43,              /*!<  43  DAC0_1                                                           */
  CCU40_0_IRQn                  =  44,              /*!<  44  CCU40_0                                                          */
  CCU40_1_IRQn                  =  45,              /*!<  45  CCU40_1                                                          */
  CCU40_2_IRQn                  =  46,              /*!<  46  CCU40_2                                                          */
  CCU40_3_IRQn                  =  47,              /*!<  47  CCU40_3                                                          */
  CCU41_0_IRQn                  =  48,              /*!<  48  CCU41_0                                                          */
  CCU41_1_IRQn                  =  49,              /*!<  49  CCU41_1                                                          */
  CCU41_2_IRQn                  =  50,              /*!<  50  CCU41_2                                                          */
  CCU41_3_IRQn                  =  51,              /*!<  51  CCU41_3                                                          */
  CCU80_0_IRQn                  =  60,              /*!<  60  CCU80_0                                                          */
  CCU80_1_IRQn                  =  61,              /*!<  61  CCU80_1                                                          */
  CCU80_2_IRQn                  =  62,              /*!<  62  CCU80_2                                                          */
  CCU80_3_IRQn                  =  63,              /*!<  63  CCU80_3                                                          */
  POSIF0_0_IRQn                 =  68,              /*!<  68  POSIF0_0                                                         */
  POSIF0_1_IRQn                 =  69,              /*!<  69  POSIF0_1                                                         */
  HRPWM_0_IRQn                  =  72,              /*!<  72  HRPWM_0                                                          */
  HRPWM_1_IRQn                  =  73,              /*!<  73  HRPWM_1                                                         */
  HRPWM_2_IRQn                  =  74,              /*!<  74  HRPWM_0                                                          */
  HRPWM_3_IRQn                  =  75,              /*!<  75  HRPWM_1                                                         */
  CAN0_0_IRQn                   =  76,              /*!<  76  CAN0_0                                                           */
  CAN0_1_IRQn                   =  77,              /*!<  77  CAN0_1                                                           */
  CAN0_2_IRQn                   =  78,              /*!<  78  CAN0_2                                                           */
  CAN0_3_IRQn                   =  79,              /*!<  79  CAN0_3                                                           */
  CAN0_4_IRQn                   =  80,              /*!<  80  CAN0_4                                                           */
  CAN0_5_IRQn                   =  81,              /*!<  81  CAN0_5                                                           */
  CAN0_6_IRQn                   =  82,              /*!<  82  CAN0_6                                                           */
  CAN0_7_IRQn                   =  83,              /*!<  83  CAN0_7                                                           */
  USIC0_0_IRQn                  =  84,              /*!<  84  USIC0_0                                                          */
  USIC0_1_IRQn                  =  85,              /*!<  85  USIC0_1                                                          */
  USIC0_2_IRQn                  =  86,              /*!<  86  USIC0_2                                                          */
  USIC0_3_IRQn                  =  87,              /*!<  87  USIC0_3                                                          */
  USIC0_4_IRQn                  =  88,              /*!<  88  USIC0_4                                                          */
  USIC0_5_IRQn                  =  89,              /*!<  89  USIC0_5                                                          */
  USIC1_0_IRQn                  =  90,              /*!<  90  USIC1_0                                                          */
  USIC1_1_IRQn                  =  91,              /*!<  91  USIC1_1                                                          */
  USIC1_2_IRQn                  =  92,              /*!<  92  USIC1_2                                                          */
  USIC1_3_IRQn                  =  93,              /*!<  93  USIC1_3                                                          */
  USIC1_4_IRQn                  =  94,              /*!<  94  USIC1_4                                                          */
  USIC1_5_IRQn                  =  95,              /*!<  95  USIC1_5                                                          */
  LEDTS0_0_IRQn                 = 102,              /*!< 102  LEDTS0_0                                                         */
  FCE0_0_IRQn                   = 104,              /*!< 104  FCE0_0                                                           */
  GPDMA0_0_IRQn                 = 105,              /*!< 105  GPDMA0_0                                                         */
  USB0_0_IRQn                   = 107,              /*!< 107  USB0_0                                                           */
} IRQn_Type;


/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

/* ----------------Configuration of the Cortex-M4 Processor and Core Peripherals---------------- */
#define __CM4_REV                 0x0200            /*!< Cortex-M4 Core Revision                                               */
#define __MPU_PRESENT                  1            /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS               6            /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig         0            /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT                  1            /*!< FPU present or not                                                    */
/** @} */ /* End of group Configuration_of_CMSIS */

#include <core_cm4.h>                               /*!< Cortex-M4 processor and core peripherals                              */
#include "system_XMC4200.h"                         /*!< XMC4200 System                                                        */


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */
/* Macro to modify desired bitfields of a register */
#define WR_REG(reg, mask, pos, val) reg = (((uint32_t)val << pos) & \
		                                         ((uint32_t)mask)) | \
                                          (reg & ((uint32_t)~((uint32_t)mask)))

/* Macro to modify desired bitfields of a register */
#define WR_REG_SIZE(reg, mask, pos, val, size) {  \
uint##size##_t VAL1 = (uint##size##_t)((uint##size##_t)val << pos); \
uint##size##_t VAL2 = (uint##size##_t) (VAL1 & (uint##size##_t)mask); \
uint##size##_t VAL3 = (uint##size##_t)~((uint##size##_t)mask); \
uint##size##_t VAL4 = (uint##size##_t) ((uint##size##_t)reg & VAL3); \
reg = (uint##size##_t) (VAL2 | VAL4);\
}

/** Macro to read bitfields from a register */
#define RD_REG(reg, mask, pos) (((uint32_t)reg & (uint32_t)mask) >> pos)

/** Macro to read bitfields from a register */
#define RD_REG_SIZE(reg, mask, pos,size) ((uint##size##_t)(((uint32_t)reg & \
                                                      (uint32_t)mask) >> pos) )

/** Macro to set a bit in register */
#define SET_BIT(reg, pos)     (reg |= ((uint32_t)1<<pos))

/** Macro to clear a bit in register */
#define CLR_BIT(reg, pos)     (reg = reg & (uint32_t)(~((uint32_t)1<<pos)) )
/*
* ==========================================================================
* ---------- Interrupt Handler Definition ----------------------------------
* ==========================================================================
*/
#define IRQ_Hdlr_0   SCU_0_IRQHandler
#define IRQ_Hdlr_1   ERU0_0_IRQHandler
#define IRQ_Hdlr_2   ERU0_1_IRQHandler
#define IRQ_Hdlr_3   ERU0_2_IRQHandler
#define IRQ_Hdlr_4   ERU0_3_IRQHandler
#define IRQ_Hdlr_5   ERU1_0_IRQHandler
#define IRQ_Hdlr_6   ERU1_1_IRQHandler
#define IRQ_Hdlr_7   ERU1_2_IRQHandler
#define IRQ_Hdlr_8   ERU1_3_IRQHandler
#define IRQ_Hdlr_12  PMU0_0_IRQHandler
#define IRQ_Hdlr_14  VADC0_C0_0_IRQHandler
#define IRQ_Hdlr_15  VADC0_C0_1_IRQHandler
#define IRQ_Hdlr_16  VADC0_C0_2_IRQHandler
#define IRQ_Hdlr_17  VADC0_C0_3_IRQHandler
#define IRQ_Hdlr_18  VADC0_G0_0_IRQHandler
#define IRQ_Hdlr_19  VADC0_G0_1_IRQHandler
#define IRQ_Hdlr_20  VADC0_G0_2_IRQHandler
#define IRQ_Hdlr_21  VADC0_G0_3_IRQHandler
#define IRQ_Hdlr_22  VADC0_G1_0_IRQHandler
#define IRQ_Hdlr_23  VADC0_G1_1_IRQHandler
#define IRQ_Hdlr_24  VADC0_G1_2_IRQHandler
#define IRQ_Hdlr_25  VADC0_G1_3_IRQHandler
#define IRQ_Hdlr_42  DAC0_0_IRQHandler
#define IRQ_Hdlr_43  DAC0_1_IRQHandler
#define IRQ_Hdlr_44  CCU40_0_IRQHandler
#define IRQ_Hdlr_45  CCU40_1_IRQHandler
#define IRQ_Hdlr_46  CCU40_2_IRQHandler
#define IRQ_Hdlr_47  CCU40_3_IRQHandler
#define IRQ_Hdlr_48  CCU41_0_IRQHandler
#define IRQ_Hdlr_49  CCU41_1_IRQHandler
#define IRQ_Hdlr_50  CCU41_2_IRQHandler
#define IRQ_Hdlr_51  CCU41_3_IRQHandler
#define IRQ_Hdlr_60  CCU80_0_IRQHandler
#define IRQ_Hdlr_61  CCU80_1_IRQHandler
#define IRQ_Hdlr_62  CCU80_2_IRQHandler
#define IRQ_Hdlr_63  CCU80_3_IRQHandler
#define IRQ_Hdlr_68  POSIF0_0_IRQHandler
#define IRQ_Hdlr_69  POSIF0_1_IRQHandler
#define IRQ_Hdlr_72  HRPWM_0_IRQHandler
#define IRQ_Hdlr_73  HRPWM_1_IRQHandler
#define IRQ_Hdlr_74  HRPWM_2_IRQHandler
#define IRQ_Hdlr_75  HRPWM_3_IRQHandler
#define IRQ_Hdlr_76  CAN0_0_IRQHandler
#define IRQ_Hdlr_77  CAN0_1_IRQHandler
#define IRQ_Hdlr_78  CAN0_2_IRQHandler
#define IRQ_Hdlr_79  CAN0_3_IRQHandler
#define IRQ_Hdlr_80  CAN0_4_IRQHandler
#define IRQ_Hdlr_81  CAN0_5_IRQHandler
#define IRQ_Hdlr_82  CAN0_6_IRQHandler
#define IRQ_Hdlr_83  CAN0_7_IRQHandler
#define IRQ_Hdlr_84  USIC0_0_IRQHandler
#define IRQ_Hdlr_85  USIC0_1_IRQHandler
#define IRQ_Hdlr_86  USIC0_2_IRQHandler
#define IRQ_Hdlr_87  USIC0_3_IRQHandler
#define IRQ_Hdlr_88  USIC0_4_IRQHandler
#define IRQ_Hdlr_89  USIC0_5_IRQHandler
#define IRQ_Hdlr_90  USIC1_0_IRQHandler
#define IRQ_Hdlr_91  USIC1_1_IRQHandler
#define IRQ_Hdlr_92  USIC1_2_IRQHandler
#define IRQ_Hdlr_93  USIC1_3_IRQHandler
#define IRQ_Hdlr_94  USIC1_4_IRQHandler
#define IRQ_Hdlr_95  USIC1_5_IRQHandler
#define IRQ_Hdlr_102 LEDTS0_0_IRQHandler
#define IRQ_Hdlr_104 FCE0_0_IRQHandler
#define IRQ_Hdlr_105 GPDMA0_0_IRQHandler
#define IRQ_Hdlr_107 USB0_0_IRQHandler

/*
* ==========================================================================
* ---------- Interrupt Handler retrieval macro -----------------------------
* ==========================================================================
*/
#define GET_IRQ_HANDLER(N) IRQ_Hdlr_##N


/** @addtogroup Device_Peripheral_Registers
  * @{
  */


/* -------------------  Start of section using anonymous unions  ------------------ */
#if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined(__ICCARM__)
  #pragma language=extended
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning 586
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================                       PPB                      ================ */
/* ================================================================================ */


/**
  * @brief Cortex-M4 Private Peripheral Block (PPB)
  */

typedef struct {                                    /*!< (@ 0xE000E000) PPB Structure                                          */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  ACTLR;                             /*!< (@ 0xE000E008) Auxiliary Control Register                             */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  SYST_CSR;                          /*!< (@ 0xE000E010) SysTick Control and Status Register                    */
  __IO uint32_t  SYST_RVR;                          /*!< (@ 0xE000E014) SysTick Reload Value Register                          */
  __IO uint32_t  SYST_CVR;                          /*!< (@ 0xE000E018) SysTick Current Value Register                         */
  __IO uint32_t  SYST_CALIB;                        /*!< (@ 0xE000E01C) SysTick Calibration Value Register r                   */
  __I  uint32_t  RESERVED2[56];
  __IO uint32_t  NVIC_ISER0;                        /*!< (@ 0xE000E100) Interrupt Set-enable Register 0                        */
  __IO uint32_t  NVIC_ISER1;                        /*!< (@ 0xE000E104) Interrupt Set-enable Register 1                        */
  __IO uint32_t  NVIC_ISER2;                        /*!< (@ 0xE000E108) Interrupt Set-enable Register 2                        */
  __IO uint32_t  NVIC_ISER3;                        /*!< (@ 0xE000E10C) Interrupt Set-enable Register 3                        */
  __I  uint32_t  RESERVED3[28];
  __IO uint32_t  NVIC_ICER0;                        /*!< (@ 0xE000E180) Interrupt Clear-enable Register 0                      */
  __IO uint32_t  NVIC_ICER1;                        /*!< (@ 0xE000E184) Interrupt Clear-enable Register 1                      */
  __IO uint32_t  NVIC_ICER2;                        /*!< (@ 0xE000E188) Interrupt Clear-enable Register 2                      */
  __IO uint32_t  NVIC_ICER3;                        /*!< (@ 0xE000E18C) Interrupt Clear-enable Register 3                      */
  __I  uint32_t  RESERVED4[28];
  __IO uint32_t  NVIC_ISPR0;                        /*!< (@ 0xE000E200) Interrupt Set-pending Register 0                       */
  __IO uint32_t  NVIC_ISPR1;                        /*!< (@ 0xE000E204) Interrupt Set-pending Register 1                       */
  __IO uint32_t  NVIC_ISPR2;                        /*!< (@ 0xE000E208) Interrupt Set-pending Register 2                       */
  __IO uint32_t  NVIC_ISPR3;                        /*!< (@ 0xE000E20C) Interrupt Set-pending Register 3                       */
  __I  uint32_t  RESERVED5[28];
  __IO uint32_t  NVIC_ICPR0;                        /*!< (@ 0xE000E280) Interrupt Clear-pending Register 0                     */
  __IO uint32_t  NVIC_ICPR1;                        /*!< (@ 0xE000E284) Interrupt Clear-pending Register 1                     */
  __IO uint32_t  NVIC_ICPR2;                        /*!< (@ 0xE000E288) Interrupt Clear-pending Register 2                     */
  __IO uint32_t  NVIC_ICPR3;                        /*!< (@ 0xE000E28C) Interrupt Clear-pending Register 3                     */
  __I  uint32_t  RESERVED6[28];
  __IO uint32_t  NVIC_IABR0;                        /*!< (@ 0xE000E300) Interrupt Active Bit Register 0                        */
  __IO uint32_t  NVIC_IABR1;                        /*!< (@ 0xE000E304) Interrupt Active Bit Register 1                        */
  __IO uint32_t  NVIC_IABR2;                        /*!< (@ 0xE000E308) Interrupt Active Bit Register 2                        */
  __IO uint32_t  NVIC_IABR3;                        /*!< (@ 0xE000E30C) Interrupt Active Bit Register 3                        */
  __I  uint32_t  RESERVED7[60];
  __IO uint32_t  NVIC_IPR0;                         /*!< (@ 0xE000E400) Interrupt Priority Register 0                          */
  __IO uint32_t  NVIC_IPR1;                         /*!< (@ 0xE000E404) Interrupt Priority Register 1                          */
  __IO uint32_t  NVIC_IPR2;                         /*!< (@ 0xE000E408) Interrupt Priority Register 2                          */
  __IO uint32_t  NVIC_IPR3;                         /*!< (@ 0xE000E40C) Interrupt Priority Register 3                          */
  __IO uint32_t  NVIC_IPR4;                         /*!< (@ 0xE000E410) Interrupt Priority Register 4                          */
  __IO uint32_t  NVIC_IPR5;                         /*!< (@ 0xE000E414) Interrupt Priority Register 5                          */
  __IO uint32_t  NVIC_IPR6;                         /*!< (@ 0xE000E418) Interrupt Priority Register 6                          */
  __IO uint32_t  NVIC_IPR7;                         /*!< (@ 0xE000E41C) Interrupt Priority Register 7                          */
  __IO uint32_t  NVIC_IPR8;                         /*!< (@ 0xE000E420) Interrupt Priority Register 8                          */
  __IO uint32_t  NVIC_IPR9;                         /*!< (@ 0xE000E424) Interrupt Priority Register 9                          */
  __IO uint32_t  NVIC_IPR10;                        /*!< (@ 0xE000E428) Interrupt Priority Register 10                         */
  __IO uint32_t  NVIC_IPR11;                        /*!< (@ 0xE000E42C) Interrupt Priority Register 11                         */
  __IO uint32_t  NVIC_IPR12;                        /*!< (@ 0xE000E430) Interrupt Priority Register 12                         */
  __IO uint32_t  NVIC_IPR13;                        /*!< (@ 0xE000E434) Interrupt Priority Register 13                         */
  __IO uint32_t  NVIC_IPR14;                        /*!< (@ 0xE000E438) Interrupt Priority Register 14                         */
  __IO uint32_t  NVIC_IPR15;                        /*!< (@ 0xE000E43C) Interrupt Priority Register 15                         */
  __IO uint32_t  NVIC_IPR16;                        /*!< (@ 0xE000E440) Interrupt Priority Register 16                         */
  __IO uint32_t  NVIC_IPR17;                        /*!< (@ 0xE000E444) Interrupt Priority Register 17                         */
  __IO uint32_t  NVIC_IPR18;                        /*!< (@ 0xE000E448) Interrupt Priority Register 18                         */
  __IO uint32_t  NVIC_IPR19;                        /*!< (@ 0xE000E44C) Interrupt Priority Register 19                         */
  __IO uint32_t  NVIC_IPR20;                        /*!< (@ 0xE000E450) Interrupt Priority Register 20                         */
  __IO uint32_t  NVIC_IPR21;                        /*!< (@ 0xE000E454) Interrupt Priority Register 21                         */
  __IO uint32_t  NVIC_IPR22;                        /*!< (@ 0xE000E458) Interrupt Priority Register 22                         */
  __IO uint32_t  NVIC_IPR23;                        /*!< (@ 0xE000E45C) Interrupt Priority Register 23                         */
  __IO uint32_t  NVIC_IPR24;                        /*!< (@ 0xE000E460) Interrupt Priority Register 24                         */
  __IO uint32_t  NVIC_IPR25;                        /*!< (@ 0xE000E464) Interrupt Priority Register 25                         */
  __IO uint32_t  NVIC_IPR26;                        /*!< (@ 0xE000E468) Interrupt Priority Register 26                         */
  __IO uint32_t  NVIC_IPR27;                        /*!< (@ 0xE000E46C) Interrupt Priority Register 27                         */
  __I  uint32_t  RESERVED8[548];
  __I  uint32_t  CPUID;                             /*!< (@ 0xE000ED00) CPUID Base Register                                    */
  __IO uint32_t  ICSR;                              /*!< (@ 0xE000ED04) Interrupt Control and State Register                   */
  __IO uint32_t  VTOR;                              /*!< (@ 0xE000ED08) Vector Table Offset Register                           */
  __IO uint32_t  AIRCR;                             /*!< (@ 0xE000ED0C) Application Interrupt and Reset Control Register       */
  __IO uint32_t  SCR;                               /*!< (@ 0xE000ED10) System Control Register                                */
  __IO uint32_t  CCR;                               /*!< (@ 0xE000ED14) Configuration and Control Register                     */
  __IO uint32_t  SHPR1;                             /*!< (@ 0xE000ED18) System Handler Priority Register 1                     */
  __IO uint32_t  SHPR2;                             /*!< (@ 0xE000ED1C) System Handler Priority Register 2                     */
  __IO uint32_t  SHPR3;                             /*!< (@ 0xE000ED20) System Handler Priority Register 3                     */
  __IO uint32_t  SHCSR;                             /*!< (@ 0xE000ED24) System Handler Control and State Register              */
  __IO uint32_t  CFSR;                              /*!< (@ 0xE000ED28) Configurable Fault Status Register                     */
  __IO uint32_t  HFSR;                              /*!< (@ 0xE000ED2C) HardFault Status Register                              */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MMFAR;                             /*!< (@ 0xE000ED34) MemManage Fault Address Register                       */
  __IO uint32_t  BFAR;                              /*!< (@ 0xE000ED38) BusFault Address Register                              */
  __IO uint32_t  AFSR;                              /*!< (@ 0xE000ED3C) Auxiliary Fault Status Register                        */
  __I  uint32_t  RESERVED10[18];
  __IO uint32_t  CPACR;                             /*!< (@ 0xE000ED88) Coprocessor Access Control Register                    */
  __I  uint32_t  RESERVED11;
  __I  uint32_t  MPU_TYPE;                          /*!< (@ 0xE000ED90) MPU Type Register                                      */
  __IO uint32_t  MPU_CTRL;                          /*!< (@ 0xE000ED94) MPU Control Register                                   */
  __IO uint32_t  MPU_RNR;                           /*!< (@ 0xE000ED98) MPU Region Number Register                             */
  __IO uint32_t  MPU_RBAR;                          /*!< (@ 0xE000ED9C) MPU Region Base Address Register                       */
  __IO uint32_t  MPU_RASR;                          /*!< (@ 0xE000EDA0) MPU Region Attribute and Size Register                 */
  __IO uint32_t  MPU_RBAR_A1;                       /*!< (@ 0xE000EDA4) MPU Region Base Address Register A1                    */
  __IO uint32_t  MPU_RASR_A1;                       /*!< (@ 0xE000EDA8) MPU Region Attribute and Size Register A1              */
  __IO uint32_t  MPU_RBAR_A2;                       /*!< (@ 0xE000EDAC) MPU Region Base Address Register A2                    */
  __IO uint32_t  MPU_RASR_A2;                       /*!< (@ 0xE000EDB0) MPU Region Attribute and Size Register A2              */
  __IO uint32_t  MPU_RBAR_A3;                       /*!< (@ 0xE000EDB4) MPU Region Base Address Register A3                    */
  __IO uint32_t  MPU_RASR_A3;                       /*!< (@ 0xE000EDB8) MPU Region Attribute and Size Register A3              */
  __I  uint32_t  RESERVED12[81];
  __O  uint32_t  STIR;                              /*!< (@ 0xE000EF00) Software Trigger Interrupt Register                    */
  __I  uint32_t  RESERVED13[12];
  __IO uint32_t  FPCCR;                             /*!< (@ 0xE000EF34) Floating-point Context Control Register                */
  __IO uint32_t  FPCAR;                             /*!< (@ 0xE000EF38) Floating-point Context Address Register                */
  __IO uint32_t  FPDSCR;                            /*!< (@ 0xE000EF3C) Floating-point Default Status Control Register         */
} PPB_Type;


/* ================================================================================ */
/* ================                       DLR                      ================ */
/* ================================================================================ */


/**
  * @brief DMA Line Router (DLR)
  */

typedef struct {                                    /*!< (@ 0x50004900) DLR Structure                                          */
  __I  uint32_t  OVRSTAT;                           /*!< (@ 0x50004900) Overrun Status                                         */
  __O  uint32_t  OVRCLR;                            /*!< (@ 0x50004904) Overrun Clear                                          */
  __IO uint32_t  SRSEL0;                            /*!< (@ 0x50004908) Service Request Selection 0                            */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  LNEN;                              /*!< (@ 0x50004910) Line Enable                                            */
} DLR_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   ERU [ERU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Event Request Unit 0 (ERU)
  */

typedef struct {                                    /*!< (@ 0x50004800) ERU Structure                                          */
  __IO uint32_t  EXISEL;                            /*!< (@ 0x50004800) Event Input Select                                     */
  __I  uint32_t  RESERVED0[3];
  __IO uint32_t  EXICON[4];                         /*!< (@ 0x50004810) Event Input Control                                    */
  __IO uint32_t  EXOCON[4];                         /*!< (@ 0x50004820) Event Output Trigger Control                           */
} ERU_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     GPDMA0                     ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0)
  */

typedef struct {                                    /*!< (@ 0x500142C0) GPDMA0 Structure                                       */
  __IO uint32_t  RAWTFR;                            /*!< (@ 0x500142C0) Raw IntTfr Status                                      */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  RAWBLOCK;                          /*!< (@ 0x500142C8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  RAWSRCTRAN;                        /*!< (@ 0x500142D0) Raw IntSrcTran Status                                  */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  RAWDSTTRAN;                        /*!< (@ 0x500142D8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  RAWERR;                            /*!< (@ 0x500142E0) Raw IntErr Status                                      */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  STATUSTFR;                         /*!< (@ 0x500142E8) IntTfr Status                                          */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  STATUSBLOCK;                       /*!< (@ 0x500142F0) IntBlock Status                                        */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  STATUSSRCTRAN;                     /*!< (@ 0x500142F8) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED7;
  __I  uint32_t  STATUSDSTTRAN;                     /*!< (@ 0x50014300) IntBlock Status                                        */
  __I  uint32_t  RESERVED8;
  __I  uint32_t  STATUSERR;                         /*!< (@ 0x50014308) IntErr Status                                          */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MASKTFR;                           /*!< (@ 0x50014310) Mask for Raw IntTfr Status                             */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  MASKBLOCK;                         /*!< (@ 0x50014318) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED11;
  __IO uint32_t  MASKSRCTRAN;                       /*!< (@ 0x50014320) Mask for Raw IntSrcTran Status                         */
  __I  uint32_t  RESERVED12;
  __IO uint32_t  MASKDSTTRAN;                       /*!< (@ 0x50014328) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED13;
  __IO uint32_t  MASKERR;                           /*!< (@ 0x50014330) Mask for Raw IntErr Status                             */
  __I  uint32_t  RESERVED14;
  __O  uint32_t  CLEARTFR;                          /*!< (@ 0x50014338) IntTfr Status                                          */
  __I  uint32_t  RESERVED15;
  __O  uint32_t  CLEARBLOCK;                        /*!< (@ 0x50014340) IntBlock Status                                        */
  __I  uint32_t  RESERVED16;
  __O  uint32_t  CLEARSRCTRAN;                      /*!< (@ 0x50014348) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED17;
  __O  uint32_t  CLEARDSTTRAN;                      /*!< (@ 0x50014350) IntBlock Status                                        */
  __I  uint32_t  RESERVED18;
  __O  uint32_t  CLEARERR;                          /*!< (@ 0x50014358) IntErr Status                                          */
  __I  uint32_t  RESERVED19;
  __I  uint32_t  STATUSINT;                         /*!< (@ 0x50014360) Combined Interrupt Status Register                     */
  __I  uint32_t  RESERVED20;
  __IO uint32_t  REQSRCREG;                         /*!< (@ 0x50014368) Source Software Transaction Request Register           */
  __I  uint32_t  RESERVED21;
  __IO uint32_t  REQDSTREG;                         /*!< (@ 0x50014370) Destination Software Transaction Request Register      */
  __I  uint32_t  RESERVED22;
  __IO uint32_t  SGLREQSRCREG;                      /*!< (@ 0x50014378) Single Source Transaction Request Register             */
  __I  uint32_t  RESERVED23;
  __IO uint32_t  SGLREQDSTREG;                      /*!< (@ 0x50014380) Single Destination Transaction Request Register        */
  __I  uint32_t  RESERVED24;
  __IO uint32_t  LSTSRCREG;                         /*!< (@ 0x50014388) Last Source Transaction Request Register               */
  __I  uint32_t  RESERVED25;
  __IO uint32_t  LSTDSTREG;                         /*!< (@ 0x50014390) Last Destination Transaction Request Register          */
  __I  uint32_t  RESERVED26;
  __IO uint32_t  DMACFGREG;                         /*!< (@ 0x50014398) GPDMA Configuration Register                           */
  __I  uint32_t  RESERVED27;
  __IO uint32_t  CHENREG;                           /*!< (@ 0x500143A0) GPDMA Channel Enable Register                          */
  __I  uint32_t  RESERVED28;
  __I  uint32_t  ID;                                /*!< (@ 0x500143A8) GPDMA0 ID Register                                     */
  __I  uint32_t  RESERVED29[19];
  __I  uint32_t  TYPE;                              /*!< (@ 0x500143F8) GPDMA Component Type                                   */
  __I  uint32_t  VERSION;                           /*!< (@ 0x500143FC) DMA Component Version                                  */
} GPDMA0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH0_1 [GPDMA0_CH0]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH0_1)
  */

typedef struct {                                    /*!< (@ 0x50014000) GPDMA0_CH0_1 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x50014000) Source Address Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DAR;                               /*!< (@ 0x50014008) Destination Address Register                           */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  LLP;                               /*!< (@ 0x50014010) Linked List Pointer Register                           */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  CTLL;                              /*!< (@ 0x50014018) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x5001401C) Control Register High                                  */
  __IO uint32_t  SSTAT;                             /*!< (@ 0x50014020) Source Status Register                                 */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DSTAT;                             /*!< (@ 0x50014028) Destination Status Register                            */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SSTATAR;                           /*!< (@ 0x50014030) Source Status Address Register                         */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  DSTATAR;                           /*!< (@ 0x50014038) Destination Status Address Register                    */
  __I  uint32_t  RESERVED6;
  __IO uint32_t  CFGL;                              /*!< (@ 0x50014040) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x50014044) Configuration Register High                            */
  __IO uint32_t  SGR;                               /*!< (@ 0x50014048) Source Gather Register                                 */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DSR;                               /*!< (@ 0x50014050) Destination Scatter Register                           */
} GPDMA0_CH_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH2_7 [GPDMA0_CH2]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH2_7)
  */

typedef struct {                                    /*!< (@ 0x500140B0) GPDMA0_CH2_7 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x500140B0) Source Address Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DAR;                               /*!< (@ 0x500140B8) Destination Address Register                           */
  __I  uint32_t  RESERVED1[3];
  __IO uint32_t  CTLL;                              /*!< (@ 0x500140C8) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x500140CC) Control Register High                                  */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  CFGL;                              /*!< (@ 0x500140F0) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x500140F4) Configuration Register High                            */
} GPDMA0_CH2_7_Type;


/* ================================================================================ */
/* ================                       FCE                      ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE)
  */

typedef struct {                                    /*!< (@ 0x50020000) FCE Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x50020000) Clock Control Register                                 */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  ID;                                /*!< (@ 0x50020008) Module Identification Register                         */
} FCE_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                FCE_KE [FCE_KE0]                ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE_KE)
  */

typedef struct {                                    /*!< (@ 0x50020020) FCE_KE Structure                                       */
  __IO uint32_t  IR;                                /*!< (@ 0x50020020) Input Register                                         */
  __I  uint32_t  RES;                               /*!< (@ 0x50020024) CRC Result Register                                    */
  __IO uint32_t  CFG;                               /*!< (@ 0x50020028) CRC Configuration Register                             */
  __IO uint32_t  STS;                               /*!< (@ 0x5002002C) CRC Status Register                                    */
  __IO uint32_t  LENGTH;                            /*!< (@ 0x50020030) CRC Length Register                                    */
  __IO uint32_t  CHECK;                             /*!< (@ 0x50020034) CRC Check Register                                     */
  __IO uint32_t  CRC;                               /*!< (@ 0x50020038) CRC Register                                           */
  __IO uint32_t  CTR;                               /*!< (@ 0x5002003C) CRC Test Register                                      */
} FCE_KE_TypeDef;


/* ================================================================================ */
/* ================                   PBA [PBA0]                   ================ */
/* ================================================================================ */


/**
  * @brief Peripheral Bridge AHB 0 (PBA)
  */

typedef struct {                                    /*!< (@ 0x40000000) PBA Structure                                          */
  __IO uint32_t  STS;                               /*!< (@ 0x40000000) Peripheral Bridge Status Register                      */
  __I  uint32_t  WADDR;                             /*!< (@ 0x40000004) PBA Write Error Address Register                       */
} PBA_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                 FLASH [FLASH0]                 ================ */
/* ================================================================================ */


/**
  * @brief Flash Memory Controller (FLASH)
  */

typedef struct {                                    /*!< (@ 0x58001000) FLASH Structure                                        */
  __I  uint32_t  RESERVED0[1026];
  __I  uint32_t  ID;                                /*!< (@ 0x58002008) Flash Module Identification Register                   */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  FSR;                               /*!< (@ 0x58002010) Flash Status Register                                  */
  __IO uint32_t  FCON;                              /*!< (@ 0x58002014) Flash Configuration Register                           */
  __IO uint32_t  MARP;                              /*!< (@ 0x58002018) Margin Control Register PFLASH                         */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  PROCON0;                           /*!< (@ 0x58002020) Flash Protection Configuration Register User
                                                         0                                                                     */
  __I  uint32_t  PROCON1;                           /*!< (@ 0x58002024) Flash Protection Configuration Register User
                                                         1                                                                     */
  __I  uint32_t  PROCON2;                           /*!< (@ 0x58002028) Flash Protection Configuration Register User
                                                         2                                                                     */
} FLASH0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PREF                      ================ */
/* ================================================================================ */


/**
  * @brief Prefetch Unit (PREF)
  */

typedef struct {                                    /*!< (@ 0x58004000) PREF Structure                                         */
  __IO uint32_t  PCON;                              /*!< (@ 0x58004000) Prefetch Configuration Register                        */
} PREF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   PMU [PMU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Program Management Unit (PMU)
  */

typedef struct {                                    /*!< (@ 0x58000508) PMU Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x58000508) PMU0 Identification Register                           */
} PMU0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       WDT                      ================ */
/* ================================================================================ */


/**
  * @brief Watch Dog Timer (WDT)
  */

typedef struct {                                    /*!< (@ 0x50008000) WDT Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50008000) WDT ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50008004) WDT Control Register                                   */
  __O  uint32_t  SRV;                               /*!< (@ 0x50008008) WDT Service Register                                   */
  __I  uint32_t  TIM;                               /*!< (@ 0x5000800C) WDT Timer Register                                     */
  __IO uint32_t  WLB;                               /*!< (@ 0x50008010) WDT Window Lower Bound Register                        */
  __IO uint32_t  WUB;                               /*!< (@ 0x50008014) WDT Window Upper Bound Register                        */
  __I  uint32_t  WDTSTS;                            /*!< (@ 0x50008018) WDT Status Register                                    */
  __O  uint32_t  WDTCLR;                            /*!< (@ 0x5000801C) WDT Clear Register                                     */
} WDT_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       RTC                      ================ */
/* ================================================================================ */


/**
  * @brief Real Time Clock (RTC)
  */

typedef struct {                                    /*!< (@ 0x50004A00) RTC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50004A00) RTC ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50004A04) RTC Control Register                                   */
  __I  uint32_t  RAWSTAT;                           /*!< (@ 0x50004A08) RTC Raw Service Request Register                       */
  __I  uint32_t  STSSR;                             /*!< (@ 0x50004A0C) RTC Service Request Status Register                    */
  __IO uint32_t  MSKSR;                             /*!< (@ 0x50004A10) RTC Service Request Mask Register                      */
  __O  uint32_t  CLRSR;                             /*!< (@ 0x50004A14) RTC Clear Service Request Register                     */
  __IO uint32_t  ATIM0;                             /*!< (@ 0x50004A18) RTC Alarm Time Register 0                              */
  __IO uint32_t  ATIM1;                             /*!< (@ 0x50004A1C) RTC Alarm Time Register 1                              */
  __IO uint32_t  TIM0;                              /*!< (@ 0x50004A20) RTC Time Register 0                                    */
  __IO uint32_t  TIM1;                              /*!< (@ 0x50004A24) RTC Time Register 1                                    */
} RTC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     SCU_CLK                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_CLK)
  */

typedef struct {                                    /*!< (@ 0x50004600) SCU_CLK Structure                                      */
  __I  uint32_t  CLKSTAT;                           /*!< (@ 0x50004600) Clock Status Register                                  */
  __O  uint32_t  CLKSET;                            /*!< (@ 0x50004604) CLK Set Register                                       */
  __O  uint32_t  CLKCLR;                            /*!< (@ 0x50004608) CLK Clear Register                                     */
  __IO uint32_t  SYSCLKCR;                          /*!< (@ 0x5000460C) System Clock Control Register                          */
  __IO uint32_t  CPUCLKCR;                          /*!< (@ 0x50004610) CPU Clock Control Register                             */
  __IO uint32_t  PBCLKCR;                           /*!< (@ 0x50004614) Peripheral Bus Clock Control Register                  */
  __IO uint32_t  USBCLKCR;                          /*!< (@ 0x50004618) USB Clock Control Register                             */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  CCUCLKCR;                          /*!< (@ 0x50004620) CCU Clock Control Register                             */
  __IO uint32_t  WDTCLKCR;                          /*!< (@ 0x50004624) WDT Clock Control Register                             */
  __IO uint32_t  EXTCLKCR;                          /*!< (@ 0x50004628) External Clock Control                                 */
  __IO uint32_t  MLINKCLKCR;                        /*!< (@ 0x5000462C) Multi-Link Clock Control                               */
  __IO uint32_t  SLEEPCR;                           /*!< (@ 0x50004630) Sleep Control Register                                 */
  __IO uint32_t  DSLEEPCR;                          /*!< (@ 0x50004634) Deep Sleep Control Register                            */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  CGATSTAT0;                         /*!< (@ 0x50004640) Peripheral 0 Clock Gating Status                       */
  __O  uint32_t  CGATSET0;                          /*!< (@ 0x50004644) Peripheral 0 Clock Gating Set                          */
  __O  uint32_t  CGATCLR0;                          /*!< (@ 0x50004648) Peripheral 0 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT1;                         /*!< (@ 0x5000464C) Peripheral 1 Clock Gating Status                       */
  __O  uint32_t  CGATSET1;                          /*!< (@ 0x50004650) Peripheral 1 Clock Gating Set                          */
  __O  uint32_t  CGATCLR1;                          /*!< (@ 0x50004654) Peripheral 1 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT2;                         /*!< (@ 0x50004658) Peripheral 2 Clock Gating Status                       */
  __O  uint32_t  CGATSET2;                          /*!< (@ 0x5000465C) Peripheral 2 Clock Gating Set                          */
  __O  uint32_t  CGATCLR2;                          /*!< (@ 0x50004660) Peripheral 2 Clock Gating Clear                        */
} SCU_CLK_TypeDef;


/* ================================================================================ */
/* ================                     SCU_OSC                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_OSC)
  */

typedef struct {                                    /*!< (@ 0x50004700) SCU_OSC Structure                                      */
  __I  uint32_t  OSCHPSTAT;                         /*!< (@ 0x50004700) OSC_HP Status Register                                 */
  __IO uint32_t  OSCHPCTRL;                         /*!< (@ 0x50004704) OSC_HP Control Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  CLKCALCONST;                       /*!< (@ 0x5000470C) Clock Calibration Constant Register                    */
} SCU_OSC_TypeDef;


/* ================================================================================ */
/* ================                     SCU_PLL                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PLL)
  */

typedef struct {                                    /*!< (@ 0x50004710) SCU_PLL Structure                                      */
  __I  uint32_t  PLLSTAT;                           /*!< (@ 0x50004710) PLL Status Register                                    */
  __IO uint32_t  PLLCON0;                           /*!< (@ 0x50004714) PLL Configuration 0 Register                           */
  __IO uint32_t  PLLCON1;                           /*!< (@ 0x50004718) PLL Configuration 1 Register                           */
  __IO uint32_t  PLLCON2;                           /*!< (@ 0x5000471C) PLL Configuration 2 Register                           */
  __I  uint32_t  USBPLLSTAT;                        /*!< (@ 0x50004720) USB PLL Status Register                                */
  __IO uint32_t  USBPLLCON;                         /*!< (@ 0x50004724) USB PLL Configuration Register                         */
  __I  uint32_t  RESERVED0[4];
  __I  uint32_t  CLKMXSTAT;                         /*!< (@ 0x50004738) Clock Multiplexing Status Register                     */
} SCU_PLL_TypeDef;


/* ================================================================================ */
/* ================                   SCU_GENERAL                  ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_GENERAL)
  */

typedef struct {                                    /*!< (@ 0x50004000) SCU_GENERAL Structure                                  */
  __I  uint32_t  ID;                                /*!< (@ 0x50004000) SCU Module ID Register                                 */
  __I  uint32_t  IDCHIP;                            /*!< (@ 0x50004004) Chip ID Register                                       */
  __I  uint32_t  IDMANUF;                           /*!< (@ 0x50004008) Manufactory ID Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  STCON;                             /*!< (@ 0x50004010) Startup Configuration Register                         */
  __I  uint32_t  RESERVED1[6];
  __IO uint32_t  GPR[2];                            /*!< (@ 0x5000402C) General Purpose Register 0                             */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  CCUCON;                            /*!< (@ 0x5000404C) CCU Control Register                                   */
  __I  uint32_t  RESERVED3[15];
  __IO uint32_t  DTSCON;                            /*!< (@ 0x5000408C) Die Temperature Sensor Control Register                */
  __I  uint32_t  DTSSTAT;                           /*!< (@ 0x50004090) Die Temperature Sensor Status Register                 */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  GORCEN[2];                         /*!< (@ 0x500040A0) Out of Range Comparator Enable Register 0              */
  __IO uint32_t  DTEMPLIM;                          /*!< (@ 0x500040A8) Die Temperature Sensor Limit Register                  */
  __I  uint32_t  DTEMPALARM;                        /*!< (@ 0x500040AC) Die Temperature Sensor Alarm Register                  */
  __I  uint32_t  RESERVED5[5];
  __I  uint32_t  MIRRSTS;                           /*!< (@ 0x500040C4) Mirror Write Status Register                           */
  __IO uint32_t  RMACR;                             /*!< (@ 0x500040C8) Retention Memory Access Control Register               */
  __IO uint32_t  RMDATA;                            /*!< (@ 0x500040CC) Retention Memory Access Data Register                  */
  __I  uint32_t  MIRRALLSTAT;                       /*!< (@ 0x500040D0) Mirror All Status                                      */
  __O  uint32_t  MIRRALLREQ;                        /*!< (@ 0x500040D4) Mirror All Request                                     */
} SCU_GENERAL_TypeDef;


/* ================================================================================ */
/* ================                  SCU_INTERRUPT                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_INTERRUPT)
  */

typedef struct {                                    /*!< (@ 0x50004074) SCU_INTERRUPT Structure                                */
  __I  uint32_t  SRSTAT;                            /*!< (@ 0x50004074) SCU Service Request Status                             */
  __I  uint32_t  SRRAW;                             /*!< (@ 0x50004078) SCU Raw Service Request Status                         */
  __IO uint32_t  SRMSK;                             /*!< (@ 0x5000407C) SCU Service Request Mask                               */
  __O  uint32_t  SRCLR;                             /*!< (@ 0x50004080) SCU Service Request Clear                              */
  __O  uint32_t  SRSET;                             /*!< (@ 0x50004084) SCU Service Request Set                                */
  __IO uint32_t  NMIREQEN;                          /*!< (@ 0x50004088) SCU Service Request Mask                               */
} SCU_INTERRUPT_TypeDef;


/* ================================================================================ */
/* ================                   SCU_PARITY                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PARITY)
  */

typedef struct {                                    /*!< (@ 0x5000413C) SCU_PARITY Structure                                   */
  __IO uint32_t  PEEN;                              /*!< (@ 0x5000413C) Parity Error Enable Register                           */
  __IO uint32_t  MCHKCON;                           /*!< (@ 0x50004140) Memory Checking Control Register                       */
  __IO uint32_t  PETE;                              /*!< (@ 0x50004144) Parity Error Trap Enable Register                      */
  __IO uint32_t  PERSTEN;                           /*!< (@ 0x50004148) Parity Error Reset Enable Register                     */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  PEFLAG;                            /*!< (@ 0x50004150) Parity Error Flag Register                             */
  __IO uint32_t  PMTPR;                             /*!< (@ 0x50004154) Parity Memory Test Pattern Register                    */
  __IO uint32_t  PMTSR;                             /*!< (@ 0x50004158) Parity Memory Test Select Register                     */
} SCU_PARITY_TypeDef;


/* ================================================================================ */
/* ================                    SCU_TRAP                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_TRAP)
  */

typedef struct {                                    /*!< (@ 0x50004160) SCU_TRAP Structure                                     */
  __I  uint32_t  TRAPSTAT;                          /*!< (@ 0x50004160) Trap Status Register                                   */
  __I  uint32_t  TRAPRAW;                           /*!< (@ 0x50004164) Trap Raw Status Register                               */
  __IO uint32_t  TRAPDIS;                           /*!< (@ 0x50004168) Trap Disable Register                                  */
  __O  uint32_t  TRAPCLR;                           /*!< (@ 0x5000416C) Trap Clear Register                                    */
  __O  uint32_t  TRAPSET;                           /*!< (@ 0x50004170) Trap Set Register                                      */
} SCU_TRAP_TypeDef;


/* ================================================================================ */
/* ================                  SCU_HIBERNATE                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_HIBERNATE)
  */

typedef struct {                                    /*!< (@ 0x50004300) SCU_HIBERNATE Structure                                */
  __I  uint32_t  HDSTAT;                            /*!< (@ 0x50004300) Hibernate Domain Status Register                       */
  __O  uint32_t  HDCLR;                             /*!< (@ 0x50004304) Hibernate Domain Status Clear Register                 */
  __O  uint32_t  HDSET;                             /*!< (@ 0x50004308) Hibernate Domain Status Set Register                   */
  __IO uint32_t  HDCR;                              /*!< (@ 0x5000430C) Hibernate Domain Control Register                      */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  OSCSICTRL;                         /*!< (@ 0x50004314) fOSI Control Register                                  */
  __I  uint32_t  OSCULSTAT;                         /*!< (@ 0x50004318) OSC_ULP Status Register                                */
  __IO uint32_t  OSCULCTRL;                         /*!< (@ 0x5000431C) OSC_ULP Control Register                               */
  __IO uint32_t  LPACCONF;                          /*!< (@ 0x50004320) Analog Wake-up Configuration Register                  */
  __IO uint32_t  LPACTH0;                           /*!< (@ 0x50004324) LPAC Threshold Register 0                              */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  LPACST;                            /*!< (@ 0x5000432C) Hibernate Analog Control State Register                */
  __O  uint32_t  LPACCLR;                           /*!< (@ 0x50004330) LPAC Control Clear Register                            */
  __O  uint32_t  LPACSET;                           /*!< (@ 0x50004334) LPAC Control Set Register                              */
  __I  uint32_t  HINTST;                            /*!< (@ 0x50004338) Hibernate Internal Control State Register              */
  __O  uint32_t  HINTCLR;                           /*!< (@ 0x5000433C) Hibernate Internal Control Clear Register              */
  __O  uint32_t  HINTSET;                           /*!< (@ 0x50004340) Hibernate Internal Control Set Register                */
} SCU_HIBERNATE_TypeDef;


/* ================================================================================ */
/* ================                    SCU_POWER                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_POWER)
  */

typedef struct {                                    /*!< (@ 0x50004200) SCU_POWER Structure                                    */
  __I  uint32_t  PWRSTAT;                           /*!< (@ 0x50004200) PCU Status Register                                    */
  __O  uint32_t  PWRSET;                            /*!< (@ 0x50004204) PCU Set Control Register                               */
  __O  uint32_t  PWRCLR;                            /*!< (@ 0x50004208) PCU Clear Control Register                             */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  EVRSTAT;                           /*!< (@ 0x50004210) EVR Status Register                                    */
  __I  uint32_t  EVRVADCSTAT;                       /*!< (@ 0x50004214) EVR VADC Status Register                               */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  PWRMON;                            /*!< (@ 0x5000422C) Power Monitor Control                                  */
} SCU_POWER_TypeDef;


/* ================================================================================ */
/* ================                    SCU_RESET                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_RESET)
  */

typedef struct {                                    /*!< (@ 0x50004400) SCU_RESET Structure                                    */
  __I  uint32_t  RSTSTAT;                           /*!< (@ 0x50004400) RCU Reset Status                                       */
  __O  uint32_t  RSTSET;                            /*!< (@ 0x50004404) RCU Reset Set Register                                 */
  __O  uint32_t  RSTCLR;                            /*!< (@ 0x50004408) RCU Reset Clear Register                               */
  __I  uint32_t  PRSTAT0;                           /*!< (@ 0x5000440C) RCU Peripheral 0 Reset Status                          */
  __O  uint32_t  PRSET0;                            /*!< (@ 0x50004410) RCU Peripheral 0 Reset Set                             */
  __O  uint32_t  PRCLR0;                            /*!< (@ 0x50004414) RCU Peripheral 0 Reset Clear                           */
  __I  uint32_t  PRSTAT1;                           /*!< (@ 0x50004418) RCU Peripheral 1 Reset Status                          */
  __O  uint32_t  PRSET1;                            /*!< (@ 0x5000441C) RCU Peripheral 1 Reset Set                             */
  __O  uint32_t  PRCLR1;                            /*!< (@ 0x50004420) RCU Peripheral 1 Reset Clear                           */
  __I  uint32_t  PRSTAT2;                           /*!< (@ 0x50004424) RCU Peripheral 2 Reset Status                          */
  __O  uint32_t  PRSET2;                            /*!< (@ 0x50004428) RCU Peripheral 2 Reset Set                             */
  __O  uint32_t  PRCLR2;                            /*!< (@ 0x5000442C) RCU Peripheral 2 Reset Clear                           */
} SCU_RESET_TypeDef;


/* ================================================================================ */
/* ================                 LEDTS [LEDTS0]                 ================ */
/* ================================================================================ */


/**
  * @brief LED and Touch Sense Unit 0 (LEDTS)
  */

typedef struct {                                    /*!< (@ 0x48010000) LEDTS Structure                                        */
  __I  uint32_t  ID;                                /*!< (@ 0x48010000) Module Identification Register                         */
  __IO uint32_t  GLOBCTL;                           /*!< (@ 0x48010004) Global Control Register                                */
  __IO uint32_t  FNCTL;                             /*!< (@ 0x48010008) Function Control Register                              */
  __O  uint32_t  EVFR;                              /*!< (@ 0x4801000C) Event Flag Register                                    */
  __IO uint32_t  TSVAL;                             /*!< (@ 0x48010010) Touch-sense TS-Counter Value                           */
  __IO uint32_t  LINE0;                             /*!< (@ 0x48010014) Line Pattern Register 0                                */
  __IO uint32_t  LINE1;                             /*!< (@ 0x48010018) Line Pattern Register 1                                */
  __IO uint32_t  LDCMP0;                            /*!< (@ 0x4801001C) LED Compare Register 0                                 */
  __IO uint32_t  LDCMP1;                            /*!< (@ 0x48010020) LED Compare Register 1                                 */
  __IO uint32_t  TSCMP0;                            /*!< (@ 0x48010024) Touch-sense Compare Register 0                         */
  __IO uint32_t  TSCMP1;                            /*!< (@ 0x48010028) Touch-sense Compare Register 1                         */
} LEDTS0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   USB [USB0]                   ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB)
  */

typedef struct {                                    /*!< (@ 0x50040000) USB Structure                                          */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  GAHBCFG;                           /*!< (@ 0x50040008) AHB Configuration Register                             */
  __IO uint32_t  GUSBCFG;                           /*!< (@ 0x5004000C) USB Configuration Register                             */
  __IO uint32_t  GRSTCTL;                           /*!< (@ 0x50040010) Reset Register                                         */
  __IO uint32_t  GINTSTS;                           /*!< (@ 0x50040014) Interrupt Register                                     */
  __IO uint32_t  GINTMSK;                           /*!< (@ 0x50040018) Interrupt Mask Register                                */
  __I  uint32_t  GRXSTSR;                           /*!< (@ 0x5004001C) Receive Status Debug Read Register                     */
  __I  uint32_t  GRXSTSP;                           /*!< (@ 0x50040020) Receive Status Read and Pop Register                   */
  __IO uint32_t  GRXFSIZ;                           /*!< (@ 0x50040024) Receive FIFO Size Register                             */
  __IO uint32_t  GNPTXFSIZ;                         /*!< (@ 0x50040028) Non-Periodic Transmit FIFO Size Register               */
  __I  uint32_t  RESERVED1[4];
  __IO uint32_t  GUID;                              /*!< (@ 0x5004003C) USB Module Identification Register                     */
  __I  uint32_t  RESERVED2[7];
  __IO uint32_t  GDFIFOCFG;                         /*!< (@ 0x5004005C) Global DFIFO Software Config Register                  */
  __I  uint32_t  RESERVED3[41];
  __IO uint32_t  DIEPTXF1;                          /*!< (@ 0x50040104) Device IN Endpoint 1 Transmit FIFO Size Register       */
  __IO uint32_t  DIEPTXF2;                          /*!< (@ 0x50040108) Device IN Endpoint 2 Transmit FIFO Size Register       */
  __IO uint32_t  DIEPTXF3;                          /*!< (@ 0x5004010C) Device IN Endpoint 3 Transmit FIFO Size Register       */
  __IO uint32_t  DIEPTXF4;                          /*!< (@ 0x50040110) Device IN Endpoint 4 Transmit FIFO Size Register       */
  __IO uint32_t  DIEPTXF5;                          /*!< (@ 0x50040114) Device IN Endpoint 5 Transmit FIFO Size Register       */
  __IO uint32_t  DIEPTXF6;                          /*!< (@ 0x50040118) Device IN Endpoint 6 Transmit FIFO Size Register       */
  __I  uint32_t  RESERVED4[441];
  __IO uint32_t  DCFG;                              /*!< (@ 0x50040800) Device Configuration Register                          */
  __IO uint32_t  DCTL;                              /*!< (@ 0x50040804) Device Control Register                                */
  __I  uint32_t  DSTS;                              /*!< (@ 0x50040808) Device Status Register                                 */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  DIEPMSK;                           /*!< (@ 0x50040810) Device IN Endpoint Common Interrupt Mask Register      */
  __IO uint32_t  DOEPMSK;                           /*!< (@ 0x50040814) Device OUT Endpoint Common Interrupt Mask Register     */
  __I  uint32_t  DAINT;                             /*!< (@ 0x50040818) Device All Endpoints Interrupt Register                */
  __IO uint32_t  DAINTMSK;                          /*!< (@ 0x5004081C) Device All Endpoints Interrupt Mask Register           */
  __I  uint32_t  RESERVED6[2];
  __IO uint32_t  DVBUSDIS;                          /*!< (@ 0x50040828) Device VBUS Discharge Time Register                    */
  __IO uint32_t  DVBUSPULSE;                        /*!< (@ 0x5004082C) Device VBUS Pulsing Time Register                      */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DIEPEMPMSK;                        /*!< (@ 0x50040834) Device IN Endpoint FIFO Empty Interrupt Mask
                                                         Register                                                              */
  __I  uint32_t  RESERVED8[370];
  __IO uint32_t  PCGCCTL;                           /*!< (@ 0x50040E00) Power and Clock Gating Control Register                */
} USB0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    USB0_EP0                    ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB0_EP0)
  */

typedef struct {                                    /*!< (@ 0x50040900) USB0_EP0 Structure                                     */
  __IO uint32_t  DIEPCTL0;                          /*!< (@ 0x50040900) Device Control IN Endpoint Control Register            */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DIEPINT0;                          /*!< (@ 0x50040908) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ0;                         /*!< (@ 0x50040910) Device IN Endpoint Transfer Size Register              */
  __IO uint32_t  DIEPDMA0;                          /*!< (@ 0x50040914) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS0;                          /*!< (@ 0x50040918) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB0;                         /*!< (@ 0x5004091C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  __IO uint32_t  DOEPCTL0;                          /*!< (@ 0x50040B00) Device Control OUT Endpoint Control Register           */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT0;                          /*!< (@ 0x50040B08) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  DOEPTSIZ0;                         /*!< (@ 0x50040B10) Device OUT Endpoint Transfer Size Register             */
  __IO uint32_t  DOEPDMA0;                          /*!< (@ 0x50040B14) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB0;                         /*!< (@ 0x50040B1C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP0_TypeDef;


/* ================================================================================ */
/* ================                USB_EP [USB0_EP1]               ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB_EP)
  */

typedef struct {                                    /*!< (@ 0x50040920) USB_EP Structure                                       */
  
  union {
    __IO uint32_t  DIEPCTL_INTBULK;                 /*!< (@ 0x50040920) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DIEPCTL_ISOCONT;                 /*!< (@ 0x50040920) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DIEPINT;                           /*!< (@ 0x50040928) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ;                          /*!< (@ 0x50040930) Device Endpoint Transfer Size Register                 */
  __IO uint32_t  DIEPDMA;                           /*!< (@ 0x50040934) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS;                           /*!< (@ 0x50040938) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB;                          /*!< (@ 0x5004093C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  
  union {
    __IO uint32_t  DOEPCTL_INTBULK;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DOEPCTL_ISOCONT;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT;                           /*!< (@ 0x50040B28) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  
  union {
    __IO uint32_t  DOEPTSIZ_CONTROL;                /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [CONT]          */
    __IO uint32_t  DOEPTSIZ_ISO;                    /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [ISO]           */
  };
  __IO uint32_t  DOEPDMA;                           /*!< (@ 0x50040B34) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB;                          /*!< (@ 0x50040B3C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP_TypeDef;


/* ================================================================================ */
/* ================                  USIC [USIC0]                  ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC)
  */

typedef struct {                                    /*!< (@ 0x40030008) USIC Structure                                         */
  __I  uint32_t  ID;                                /*!< (@ 0x40030008) Module Identification Register                         */
} USIC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================               USIC_CH [USIC0_CH0]              ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC_CH)
  */

typedef struct {                                    /*!< (@ 0x40030000) USIC_CH Structure                                      */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  CCFG;                              /*!< (@ 0x40030004) Channel Configuration Register                         */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  KSCFG;                             /*!< (@ 0x4003000C) Kernel State Configuration Register                    */
  __IO uint32_t  FDR;                               /*!< (@ 0x40030010) Fractional Divider Register                            */
  __IO uint32_t  BRG;                               /*!< (@ 0x40030014) Baud Rate Generator Register                           */
  __IO uint32_t  INPR;                              /*!< (@ 0x40030018) Interrupt Node Pointer Register                        */
  __IO uint32_t  DX0CR;                             /*!< (@ 0x4003001C) Input Control Register 0                               */
  __IO uint32_t  DX1CR;                             /*!< (@ 0x40030020) Input Control Register 1                               */
  __IO uint32_t  DX2CR;                             /*!< (@ 0x40030024) Input Control Register 2                               */
  __IO uint32_t  DX3CR;                             /*!< (@ 0x40030028) Input Control Register 3                               */
  __IO uint32_t  DX4CR;                             /*!< (@ 0x4003002C) Input Control Register 4                               */
  __IO uint32_t  DX5CR;                             /*!< (@ 0x40030030) Input Control Register 5                               */
  __IO uint32_t  SCTR;                              /*!< (@ 0x40030034) Shift Control Register                                 */
  __IO uint32_t  TCSR;                              /*!< (@ 0x40030038) Transmit Control/Status Register                       */
  
  union {
    __IO uint32_t  PCR_IICMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIC Mode]                   */
    __IO uint32_t  PCR_IISMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIS Mode]                   */
    __IO uint32_t  PCR_SSCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [SSC Mode]                   */
    __IO uint32_t  PCR;                             /*!< (@ 0x4003003C) Protocol Control Register                              */
    __IO uint32_t  PCR_ASCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [ASC Mode]                   */
  };
  __IO uint32_t  CCR;                               /*!< (@ 0x40030040) Channel Control Register                               */
  __IO uint32_t  CMTR;                              /*!< (@ 0x40030044) Capture Mode Timer Register                            */
  
  union {
    __IO uint32_t  PSR_IICMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIC Mode]                    */
    __IO uint32_t  PSR_IISMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIS Mode]                    */
    __IO uint32_t  PSR_SSCMode;                     /*!< (@ 0x40030048) Protocol Status Register [SSC Mode]                    */
    __IO uint32_t  PSR;                             /*!< (@ 0x40030048) Protocol Status Register                               */
    __IO uint32_t  PSR_ASCMode;                     /*!< (@ 0x40030048) Protocol Status Register [ASC Mode]                    */
  };
  __O  uint32_t  PSCR;                              /*!< (@ 0x4003004C) Protocol Status Clear Register                         */
  __I  uint32_t  RBUFSR;                            /*!< (@ 0x40030050) Receiver Buffer Status Register                        */
  __I  uint32_t  RBUF;                              /*!< (@ 0x40030054) Receiver Buffer Register                               */
  __I  uint32_t  RBUFD;                             /*!< (@ 0x40030058) Receiver Buffer Register for Debugger                  */
  __I  uint32_t  RBUF0;                             /*!< (@ 0x4003005C) Receiver Buffer Register 0                             */
  __I  uint32_t  RBUF1;                             /*!< (@ 0x40030060) Receiver Buffer Register 1                             */
  __I  uint32_t  RBUF01SR;                          /*!< (@ 0x40030064) Receiver Buffer 01 Status Register                     */
  __O  uint32_t  FMR;                               /*!< (@ 0x40030068) Flag Modification Register                             */
  __I  uint32_t  RESERVED2[5];
  __IO uint32_t  TBUF[32];                          /*!< (@ 0x40030080) Transmit Buffer                                        */
  __IO uint32_t  BYP;                               /*!< (@ 0x40030100) Bypass Data Register                                   */
  __IO uint32_t  BYPCR;                             /*!< (@ 0x40030104) Bypass Control Register                                */
  __IO uint32_t  TBCTR;                             /*!< (@ 0x40030108) Transmitter Buffer Control Register                    */
  __IO uint32_t  RBCTR;                             /*!< (@ 0x4003010C) Receiver Buffer Control Register                       */
  __I  uint32_t  TRBPTR;                            /*!< (@ 0x40030110) Transmit/Receive Buffer Pointer Register               */
  __IO uint32_t  TRBSR;                             /*!< (@ 0x40030114) Transmit/Receive Buffer Status Register                */
  __O  uint32_t  TRBSCR;                            /*!< (@ 0x40030118) Transmit/Receive Buffer Status Clear Register          */
  __I  uint32_t  OUTR;                              /*!< (@ 0x4003011C) Receiver Buffer Output Register                        */
  __I  uint32_t  OUTDR;                             /*!< (@ 0x40030120) Receiver Buffer Output Register L for Debugger         */
  __I  uint32_t  RESERVED3[23];
  __O  uint32_t  IN[32];                            /*!< (@ 0x40030180) Transmit FIFO Buffer                                   */
} USIC_CH_TypeDef;


/* ================================================================================ */
/* ================                       CAN                      ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN)
  */

typedef struct {                                    /*!< (@ 0x48014000) CAN Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x48014000) CAN Clock Control Register                             */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  ID;                                /*!< (@ 0x48014008) Module Identification Register                         */
  __IO uint32_t  FDR;                               /*!< (@ 0x4801400C) CAN Fractional Divider Register                        */
  __I  uint32_t  RESERVED1[60];
  __I  uint32_t  LIST[8];                           /*!< (@ 0x48014100) List Register                                          */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  MSPND[8];                          /*!< (@ 0x48014140) Message Pending Register                               */
  __I  uint32_t  RESERVED3[8];
  __I  uint32_t  MSID[8];                           /*!< (@ 0x48014180) Message Index Register                                 */
  __I  uint32_t  RESERVED4[8];
  __IO uint32_t  MSIMASK;                           /*!< (@ 0x480141C0) Message Index Mask Register                            */
  __IO uint32_t  PANCTR;                            /*!< (@ 0x480141C4) Panel Control Register                                 */
  __IO uint32_t  MCR;                               /*!< (@ 0x480141C8) Module Control Register                                */
  __O  uint32_t  MITR;                              /*!< (@ 0x480141CC) Module Interrupt Trigger Register                      */
} CAN_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CAN_NODE [CAN_NODE0]              ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_NODE)
  */

typedef struct {                                    /*!< (@ 0x48014200) CAN_NODE Structure                                     */
  __IO uint32_t  NCR;                               /*!< (@ 0x48014200) Node Control Register                                  */
  __IO uint32_t  NSR;                               /*!< (@ 0x48014204) Node Status Register                                   */
  __IO uint32_t  NIPR;                              /*!< (@ 0x48014208) Node Interrupt Pointer Register                        */
  __IO uint32_t  NPCR;                              /*!< (@ 0x4801420C) Node Port Control Register                             */
  __IO uint32_t  NBTR;                              /*!< (@ 0x48014210) Node Bit Timing Register                               */
  __IO uint32_t  NECNT;                             /*!< (@ 0x48014214) Node Error Counter Register                            */
  __IO uint32_t  NFCR;                              /*!< (@ 0x48014218) Node Frame Counter Register                            */
} CAN_NODE_TypeDef;


/* ================================================================================ */
/* ================                CAN_MO [CAN_MO0]                ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_MO)
  */

typedef struct {                                    /*!< (@ 0x48015000) CAN_MO Structure                                       */
  __IO uint32_t  MOFCR;                             /*!< (@ 0x48015000) Message Object Function Control Register               */
  __IO uint32_t  MOFGPR;                            /*!< (@ 0x48015004) Message Object FIFO/Gateway Pointer Register           */
  __IO uint32_t  MOIPR;                             /*!< (@ 0x48015008) Message Object Interrupt Pointer Register              */
  __IO uint32_t  MOAMR;                             /*!< (@ 0x4801500C) Message Object Acceptance Mask Register                */
  __IO uint32_t  MODATAL;                           /*!< (@ 0x48015010) Message Object Data Register Low                       */
  __IO uint32_t  MODATAH;                           /*!< (@ 0x48015014) Message Object Data Register High                      */
  __IO uint32_t  MOAR;                              /*!< (@ 0x48015018) Message Object Arbitration Register                    */
  
  union {
    __I  uint32_t  MOSTAT;                          /*!< (@ 0x4801501C) Message Object Status Register                         */
    __O  uint32_t  MOCTR;                           /*!< (@ 0x4801501C) Message Object Control Register                        */
  };
} CAN_MO_TypeDef;


/* ================================================================================ */
/* ================                      VADC                      ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC)
  */

typedef struct {                                    /*!< (@ 0x40004000) VADC Structure                                         */
  __IO uint32_t  CLC;                               /*!< (@ 0x40004000) Clock Control Register                                 */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  ID;                                /*!< (@ 0x40004008) Module Identification Register                         */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  OCS;                               /*!< (@ 0x40004028) OCDS Control and Status Register                       */
  __I  uint32_t  RESERVED2[21];
  __IO uint32_t  GLOBCFG;                           /*!< (@ 0x40004080) Global Configuration Register                          */
  __I  uint32_t  RESERVED3[7];
  __IO uint32_t  GLOBICLASS[2];                     /*!< (@ 0x400040A0) Input Class Register, Global                           */
  __I  uint32_t  RESERVED4[4];
  __IO uint32_t  GLOBBOUND;                         /*!< (@ 0x400040B8) Global Boundary Select Register                        */
  __I  uint32_t  RESERVED5[9];
  __IO uint32_t  GLOBEFLAG;                         /*!< (@ 0x400040E0) Global Event Flag Register                             */
  __I  uint32_t  RESERVED6[23];
  __IO uint32_t  GLOBEVNP;                          /*!< (@ 0x40004140) Global Event Node Pointer Register                     */
  __I  uint32_t  RESERVED7[7];
  __IO uint32_t  GLOBTF;                            /*!< (@ 0x40004160) Global Test Functions Register                         */
  __I  uint32_t  RESERVED8[7];
  __IO uint32_t  BRSSEL[4];                         /*!< (@ 0x40004180) Background Request Source Channel Select Register      */
  __I  uint32_t  RESERVED9[12];
  __IO uint32_t  BRSPND[4];                         /*!< (@ 0x400041C0) Background Request Source Pending Register             */
  __I  uint32_t  RESERVED10[12];
  __IO uint32_t  BRSCTRL;                           /*!< (@ 0x40004200) Background Request Source Control Register             */
  __IO uint32_t  BRSMR;                             /*!< (@ 0x40004204) Background Request Source Mode Register                */
  __I  uint32_t  RESERVED11[30];
  __IO uint32_t  GLOBRCR;                           /*!< (@ 0x40004280) Global Result Control Register                         */
  __I  uint32_t  RESERVED12[31];
  __IO uint32_t  GLOBRES;                           /*!< (@ 0x40004300) Global Result Register                                 */
  __I  uint32_t  RESERVED13[31];
  __IO uint32_t  GLOBRESD;                          /*!< (@ 0x40004380) Global Result Register, Debug                          */
  __I  uint32_t  RESERVED14[27];
  __IO uint32_t  EMUXSEL;                           /*!< (@ 0x400043F0) External Multiplexer Select Register                   */
} VADC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                VADC_G [VADC_G0]                ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC_G)
  */

typedef struct {                                    /*!< (@ 0x40004400) VADC_G Structure                                       */
  __I  uint32_t  RESERVED0[32];
  __IO uint32_t  ARBCFG;                            /*!< (@ 0x40004480) Arbitration Configuration Register                     */
  __IO uint32_t  ARBPR;                             /*!< (@ 0x40004484) Arbitration Priority Register                          */
  __IO uint32_t  CHASS;                             /*!< (@ 0x40004488) Channel Assignment Register                            */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  ICLASS[2];                         /*!< (@ 0x400044A0) Input Class Register                                   */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  ALIAS;                             /*!< (@ 0x400044B0) Alias Register                                         */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  BOUND;                             /*!< (@ 0x400044B8) Boundary Select Register                               */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SYNCTR;                            /*!< (@ 0x400044C0) Synchronization Control Register                       */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  BFL;                               /*!< (@ 0x400044C8) Boundary Flag Register                                 */
  __I  uint32_t  RESERVED6[13];
  __IO uint32_t  QCTRL0;                            /*!< (@ 0x40004500) Queue 0 Source Control Register                        */
  __IO uint32_t  QMR0;                              /*!< (@ 0x40004504) Queue 0 Mode Register                                  */
  __I  uint32_t  QSR0;                              /*!< (@ 0x40004508) Queue 0 Status Register                                */
  __I  uint32_t  Q0R0;                              /*!< (@ 0x4000450C) Queue 0 Register 0                                     */
  
  union {
    __I  uint32_t  QBUR0;                           /*!< (@ 0x40004510) Queue 0 Backup Register                                */
    __O  uint32_t  QINR0;                           /*!< (@ 0x40004510) Queue 0 Input Register                                 */
  };
  __I  uint32_t  RESERVED7[3];
  __IO uint32_t  ASCTRL;                            /*!< (@ 0x40004520) Autoscan Source Control Register                       */
  __IO uint32_t  ASMR;                              /*!< (@ 0x40004524) Autoscan Source Mode Register                          */
  __IO uint32_t  ASSEL;                             /*!< (@ 0x40004528) Autoscan Source Channel Select Register                */
  __IO uint32_t  ASPND;                             /*!< (@ 0x4000452C) Autoscan Source Pending Register                       */
  __I  uint32_t  RESERVED8[20];
  __IO uint32_t  CEFLAG;                            /*!< (@ 0x40004580) Channel Event Flag Register                            */
  __IO uint32_t  REFLAG;                            /*!< (@ 0x40004584) Result Event Flag Register                             */
  __IO uint32_t  SEFLAG;                            /*!< (@ 0x40004588) Source Event Flag Register                             */
  __I  uint32_t  RESERVED9;
  __O  uint32_t  CEFCLR;                            /*!< (@ 0x40004590) Channel Event Flag Clear Register                      */
  __O  uint32_t  REFCLR;                            /*!< (@ 0x40004594) Result Event Flag Clear Register                       */
  __O  uint32_t  SEFCLR;                            /*!< (@ 0x40004598) Source Event Flag Clear Register                       */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  CEVNP0;                            /*!< (@ 0x400045A0) Channel Event Node Pointer Register 0                  */
  __I  uint32_t  RESERVED11[3];
  __IO uint32_t  REVNP0;                            /*!< (@ 0x400045B0) Result Event Node Pointer Register 0                   */
  __IO uint32_t  REVNP1;                            /*!< (@ 0x400045B4) Result Event Node Pointer Register 1                   */
  __I  uint32_t  RESERVED12[2];
  __IO uint32_t  SEVNP;                             /*!< (@ 0x400045C0) Source Event Node Pointer Register                     */
  __I  uint32_t  RESERVED13;
  __O  uint32_t  SRACT;                             /*!< (@ 0x400045C8) Service Request Software Activation Trigger            */
  __I  uint32_t  RESERVED14[9];
  __IO uint32_t  EMUXCTR;                           /*!< (@ 0x400045F0) External Multiplexer Control Register                  */
  __I  uint32_t  RESERVED15;
  __IO uint32_t  VFR;                               /*!< (@ 0x400045F8) Valid Flag Register                                    */
  __I  uint32_t  RESERVED16;
  __IO uint32_t  CHCTR[8];                          /*!< (@ 0x40004600) Channel Ctrl. Reg.                                     */
  __I  uint32_t  RESERVED17[24];
  __IO uint32_t  RCR[16];                           /*!< (@ 0x40004680) Result Control Register                                */
  __I  uint32_t  RESERVED18[16];
  __IO uint32_t  RES[16];                           /*!< (@ 0x40004700) Result Register                                        */
  __I  uint32_t  RESERVED19[16];
  __I  uint32_t  RESD[16];                          /*!< (@ 0x40004780) Result Register, Debug                                 */
} VADC_G_TypeDef;


/* ================================================================================ */
/* ================                       DAC                      ================ */
/* ================================================================================ */


/**
  * @brief Digital to Analog Converter (DAC)
  */

typedef struct {                                    /*!< (@ 0x48018000) DAC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x48018000) Module Identification Register                         */
  __IO uint32_t  DAC0CFG0;                          /*!< (@ 0x48018004) DAC0 Configuration Register 0                          */
  __IO uint32_t  DAC0CFG1;                          /*!< (@ 0x48018008) DAC0 Configuration Register 1                          */
  __IO uint32_t  DAC1CFG0;                          /*!< (@ 0x4801800C) DAC1 Configuration Register 0                          */
  __IO uint32_t  DAC1CFG1;                          /*!< (@ 0x48018010) DAC1 Configuration Register 1                          */
  __IO uint32_t  DAC0DATA;                          /*!< (@ 0x48018014) DAC0 Data Register                                     */
  __IO uint32_t  DAC1DATA;                          /*!< (@ 0x48018018) DAC1 Data Register                                     */
  __IO uint32_t  DAC01DATA;                         /*!< (@ 0x4801801C) DAC01 Data Register                                    */
  __IO uint32_t  DAC0PATL;                          /*!< (@ 0x48018020) DAC0 Lower Pattern Register                            */
  __IO uint32_t  DAC0PATH;                          /*!< (@ 0x48018024) DAC0 Higher Pattern Register                           */
  __IO uint32_t  DAC1PATL;                          /*!< (@ 0x48018028) DAC1 Lower Pattern Register                            */
  __IO uint32_t  DAC1PATH;                          /*!< (@ 0x4801802C) DAC1 Higher Pattern Register                           */
} DAC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                  CCU4 [CCU40]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4)
  */

typedef struct {                                    /*!< (@ 0x4000C000) CCU4 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x4000C000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x4000C004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x4000C008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4000C00C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x4000C010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x4000C014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x4000C018) Global Channel Status                                  */
  __I  uint32_t  RESERVED0[13];
  __I  uint32_t  ECRD;                              /*!< (@ 0x4000C050) Extended Capture Mode Read                             */
  __I  uint32_t  RESERVED1[11];
  __I  uint32_t  MIDR;                              /*!< (@ 0x4000C080) Module Identification                                  */
} CCU4_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU4_CC4 [CCU40_CC40]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4_CC4)
  */

typedef struct {                                    /*!< (@ 0x4000C100) CCU4_CC4 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x4000C100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x4000C104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x4000C108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4000C10C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x4000C110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x4000C114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x4000C118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4000C11C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x4000C120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x4000C124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x4000C128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4000C12C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x4000C130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x4000C134) Timer Shadow Period Value                              */
  __I  uint32_t  CR;                                /*!< (@ 0x4000C138) Timer Compare Value                                    */
  __IO uint32_t  CRS;                               /*!< (@ 0x4000C13C) Timer Shadow Compare Value                             */
  __I  uint32_t  RESERVED0[12];
  __IO uint32_t  TIMER;                             /*!< (@ 0x4000C170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x4000C174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x4000C1A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x4000C1A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x4000C1A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x4000C1AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x4000C1B0) Interrupt Status Clear                                 */
} CCU4_CC4_TypeDef;


/* ================================================================================ */
/* ================                  CCU8 [CCU80]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8)
  */

typedef struct {                                    /*!< (@ 0x40020000) CCU8 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x40020000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x40020004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x40020008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4002000C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x40020010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x40020014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x40020018) Global Channel status                                  */
  __IO uint32_t  GPCHK;                             /*!< (@ 0x4002001C) Parity Checker Configuration                           */
  __I  uint32_t  RESERVED0[12];
  __I  uint32_t  ECRD;                              /*!< (@ 0x40020050) Extended Capture Mode Read                             */
  __I  uint32_t  RESERVED1[11];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40020080) Module Identification                                  */
} CCU8_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU8_CC8 [CCU80_CC80]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8_CC8)
  */

typedef struct {                                    /*!< (@ 0x40020100) CCU8_CC8 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x40020100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x40020104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x40020108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4002010C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x40020110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x40020114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x40020118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4002011C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x40020120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x40020124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x40020128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4002012C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x40020130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x40020134) Timer Shadow Period Value                              */
  __I  uint32_t  CR1;                               /*!< (@ 0x40020138) Channel 1 Compare Value                                */
  __IO uint32_t  CR1S;                              /*!< (@ 0x4002013C) Channel 1 Compare Shadow Value                         */
  __I  uint32_t  CR2;                               /*!< (@ 0x40020140) Channel 2 Compare Value                                */
  __IO uint32_t  CR2S;                              /*!< (@ 0x40020144) Channel 2 Compare Shadow Value                         */
  __IO uint32_t  CHC;                               /*!< (@ 0x40020148) Channel Control                                        */
  __IO uint32_t  DTC;                               /*!< (@ 0x4002014C) Dead Time Control                                      */
  __IO uint32_t  DC1R;                              /*!< (@ 0x40020150) Channel 1 Dead Time Values                             */
  __IO uint32_t  DC2R;                              /*!< (@ 0x40020154) Channel 2 Dead Time Values                             */
  __I  uint32_t  RESERVED0[6];
  __IO uint32_t  TIMER;                             /*!< (@ 0x40020170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x40020174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x400201A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x400201A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x400201A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x400201AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x400201B0) Interrupt Status Clear                                 */
  __IO uint32_t  STC;                               /*!< (@ 0x400201B4) Shadow transfer control                                */
} CCU8_CC8_TypeDef;


/* ================================================================================ */
/* ================                     HRPWM0                     ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0)
  */

typedef struct {                                    /*!< (@ 0x40020900) HRPWM0 Structure                                       */
  __IO uint32_t  HRBSC;                             /*!< (@ 0x40020900) Bias and suspend configuration                         */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  MIDR;                              /*!< (@ 0x40020908) Module identification register                         */
  __I  uint32_t  RESERVED1[2];
  __IO uint32_t  GLBANA;                            /*!< (@ 0x40020914) Global Analog Configuration                            */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  CSGCFG;                            /*!< (@ 0x40020920) Global CSG configuration                               */
  __O  uint32_t  CSGSETG;                           /*!< (@ 0x40020924) Global CSG run bit set                                 */
  __O  uint32_t  CSGCLRG;                           /*!< (@ 0x40020928) Global CSG run bit clear                               */
  __I  uint32_t  CSGSTATG;                          /*!< (@ 0x4002092C) Global CSG run bit status                              */
  __O  uint32_t  CSGFCG;                            /*!< (@ 0x40020930) Global CSG slope/prescaler control                     */
  __I  uint32_t  CSGFSG;                            /*!< (@ 0x40020934) Global CSG slope/prescaler status                      */
  __O  uint32_t  CSGTRG;                            /*!< (@ 0x40020938) Global CSG shadow/switch trigger                       */
  __O  uint32_t  CSGTRC;                            /*!< (@ 0x4002093C) Global CSG shadow trigger clear                        */
  __I  uint32_t  CSGTRSG;                           /*!< (@ 0x40020940) Global CSG shadow/switch status                        */
  __I  uint32_t  RESERVED3[7];
  __IO uint32_t  HRCCFG;                            /*!< (@ 0x40020960) Global HRC configuration                               */
  __O  uint32_t  HRCSTRG;                           /*!< (@ 0x40020964) Global HRC shadow trigger set                          */
  __O  uint32_t  HRCCTRG;                           /*!< (@ 0x40020968) Global HRC shadow trigger clear                        */
  __I  uint32_t  HRCSTSG;                           /*!< (@ 0x4002096C) Global HRC shadow transfer status                      */
  __I  uint32_t  HRGHRS;                            /*!< (@ 0x40020970) High Resolution Generation Status                      */
} HRPWM0_Type;


/* ================================================================================ */
/* ================            HRPWM0_CSG [HRPWM0_CSG0]            ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0_CSG)
  */

typedef struct {                                    /*!< (@ 0x40020A00) HRPWM0_CSG Structure                                   */
  __IO uint32_t  DCI;                               /*!< (@ 0x40020A00) External input selection                               */
  __IO uint32_t  IES;                               /*!< (@ 0x40020A04) External input selection                               */
  __IO uint32_t  SC;                                /*!< (@ 0x40020A08) Slope generation control                               */
  __I  uint32_t  PC;                                /*!< (@ 0x40020A0C) Pulse swallow configuration                            */
  __I  uint32_t  DSV1;                              /*!< (@ 0x40020A10) DAC reference value 1                                  */
  __IO uint32_t  DSV2;                              /*!< (@ 0x40020A14) DAC reference value 1                                  */
  __IO uint32_t  SDSV1;                             /*!< (@ 0x40020A18) Shadow reference value 1                               */
  __IO uint32_t  SPC;                               /*!< (@ 0x40020A1C) Shadow Pulse swallow value                             */
  __IO uint32_t  CC;                                /*!< (@ 0x40020A20) Comparator configuration                               */
  __IO uint32_t  PLC;                               /*!< (@ 0x40020A24) Passive level configuration                            */
  __IO uint32_t  BLV;                               /*!< (@ 0x40020A28) Comparator blanking value                              */
  __IO uint32_t  SRE;                               /*!< (@ 0x40020A2C) Service request enable                                 */
  __IO uint32_t  SRS;                               /*!< (@ 0x40020A30) Service request line selector                          */
  __O  uint32_t  SWS;                               /*!< (@ 0x40020A34) Service request SW set                                 */
  __O  uint32_t  SWC;                               /*!< (@ 0x40020A38) Service request SW clear                               */
  __I  uint32_t  ISTAT;                             /*!< (@ 0x40020A3C) Service request status                                 */
} HRPWM0_CSG_Type;


/* ================================================================================ */
/* ================            HRPWM0_HRC [HRPWM0_HRC0]            ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0_HRC)
  */

typedef struct {                                    /*!< (@ 0x40021300) HRPWM0_HRC Structure                                   */
  __IO uint32_t  GC;                                /*!< (@ 0x40021300) HRC mode configuration                                 */
  __IO uint32_t  PL;                                /*!< (@ 0x40021304) HRC output passive level                               */
  __IO uint32_t  GSEL;                              /*!< (@ 0x40021308) HRC global control selection                           */
  __IO uint32_t  TSEL;                              /*!< (@ 0x4002130C) HRC timer selection                                    */
  __I  uint32_t  SC;                                /*!< (@ 0x40021310) HRC current source for shadow                          */
  __I  uint32_t  DCR;                               /*!< (@ 0x40021314) HRC dead time rising value                             */
  __I  uint32_t  DCF;                               /*!< (@ 0x40021318) HRC dead time falling value                            */
  __I  uint32_t  CR1;                               /*!< (@ 0x4002131C) HRC rising edge value                                  */
  __I  uint32_t  CR2;                               /*!< (@ 0x40021320) HRC falling edge value                                 */
  __IO uint32_t  SSC;                               /*!< (@ 0x40021324) HRC next source for shadow                             */
  __IO uint32_t  SDCR;                              /*!< (@ 0x40021328) HRC shadow dead time rising                            */
  __IO uint32_t  SDCF;                              /*!< (@ 0x4002132C) HRC shadow dead time falling                           */
  __IO uint32_t  SCR1;                              /*!< (@ 0x40021330) HRC shadow rising edge value                           */
  __IO uint32_t  SCR2;                              /*!< (@ 0x40021334) HRC shadow falling edge value                          */
} HRPWM0_HRC_Type;


/* ================================================================================ */
/* ================                 POSIF [POSIF0]                 ================ */
/* ================================================================================ */


/**
  * @brief Position Interface 0 (POSIF)
  */

typedef struct {                                    /*!< (@ 0x40028000) POSIF Structure                                        */
  __IO uint32_t  PCONF;                             /*!< (@ 0x40028000) Service Request Processing configuration               */
  __IO uint32_t  PSUS;                              /*!< (@ 0x40028004) Service Request Processing Suspend Config              */
  __O  uint32_t  PRUNS;                             /*!< (@ 0x40028008) Service Request Processing Run Bit Set                 */
  __O  uint32_t  PRUNC;                             /*!< (@ 0x4002800C) Service Request Processing Run Bit Clear               */
  __I  uint32_t  PRUN;                              /*!< (@ 0x40028010) Service Request Processing Run Bit Status              */
  __I  uint32_t  RESERVED0[3];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40028020) Module Identification register                         */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  HALP;                              /*!< (@ 0x40028030) Hall Sensor Patterns                                   */
  __IO uint32_t  HALPS;                             /*!< (@ 0x40028034) Hall Sensor Shadow Patterns                            */
  __I  uint32_t  RESERVED2[2];
  __I  uint32_t  MCM;                               /*!< (@ 0x40028040) Multi-Channel Pattern                                  */
  __IO uint32_t  MCSM;                              /*!< (@ 0x40028044) Multi-Channel Shadow Pattern                           */
  __O  uint32_t  MCMS;                              /*!< (@ 0x40028048) Multi-Channel Pattern Control set                      */
  __O  uint32_t  MCMC;                              /*!< (@ 0x4002804C) Multi-Channel Pattern Control clear                    */
  __I  uint32_t  MCMF;                              /*!< (@ 0x40028050) Multi-Channel Pattern Control flag                     */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  QDC;                               /*!< (@ 0x40028060) Quadrature Decoder Control                             */
  __I  uint32_t  RESERVED4[3];
  __I  uint32_t  PFLG;                              /*!< (@ 0x40028070) Service Request Processing Interrupt Flags             */
  __IO uint32_t  PFLGE;                             /*!< (@ 0x40028074) Service Request Processing Interrupt Enable            */
  __O  uint32_t  SPFLG;                             /*!< (@ 0x40028078) Service Request Processing Interrupt Set               */
  __O  uint32_t  RPFLG;                             /*!< (@ 0x4002807C) Service Request Processing Interrupt Clear             */
  __I  uint32_t  RESERVED5[32];
  __I  uint32_t  PDBG;                              /*!< (@ 0x40028100) POSIF Debug register                                   */
} POSIF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PORT0                     ================ */
/* ================================================================================ */


/**
  * @brief Port 0 (PORT0)
  */

typedef struct {                                    /*!< (@ 0x48028000) PORT0 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028000) Port 0 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028004) Port 0 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028010) Port 0 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028014) Port 0 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028018) Port 0 Input/Output Control Register 8                 */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028024) Port 0 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028040) Port 0 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028044) Port 0 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028060) Port 0 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028070) Port 0 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028074) Port 0 Pin Hardware Select Register                    */
} PORT0_Type;


/* ================================================================================ */
/* ================                      PORT1                     ================ */
/* ================================================================================ */


/**
  * @brief Port 1 (PORT1)
  */

typedef struct {                                    /*!< (@ 0x48028100) PORT1 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028100) Port 1 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028104) Port 1 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028110) Port 1 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028114) Port 1 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028118) Port 1 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802811C) Port 1 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028124) Port 1 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028140) Port 1 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028144) Port 1 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028160) Port 1 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028170) Port 1 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028174) Port 1 Pin Hardware Select Register                    */
} PORT1_Type;


/* ================================================================================ */
/* ================                      PORT2                     ================ */
/* ================================================================================ */


/**
  * @brief Port 2 (PORT2)
  */

typedef struct {                                    /*!< (@ 0x48028200) PORT2 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028200) Port 2 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028204) Port 2 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028210) Port 2 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028214) Port 2 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028218) Port 2 Input/Output Control Register 8                 */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028224) Port 2 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028240) Port 2 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028244) Port 2 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028260) Port 2 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028270) Port 2 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028274) Port 2 Pin Hardware Select Register                    */
} PORT2_Type;


/* ================================================================================ */
/* ================                      PORT3                     ================ */
/* ================================================================================ */


/**
  * @brief Port 3 (PORT3)
  */

typedef struct {                                    /*!< (@ 0x48028300) PORT3 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028300) Port 3 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028304) Port 3 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028310) Port 3 Input/Output Control Register 0                 */
  __I  uint32_t  RESERVED1[4];
  __I  uint32_t  IN;                                /*!< (@ 0x48028324) Port 3 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028340) Port 3 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028360) Port 3 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028370) Port 3 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028374) Port 3 Pin Hardware Select Register                    */
} PORT3_Type;


/* ================================================================================ */
/* ================                     PORT14                     ================ */
/* ================================================================================ */


/**
  * @brief Port 14 (PORT14)
  */

typedef struct {                                    /*!< (@ 0x48028E00) PORT14 Structure                                       */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028E00) Port 14 Output Register                                */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028E04) Port 14 Output Modification Register                   */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028E10) Port 14 Input/Output Control Register 0                */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028E14) Port 14 Input/Output Control Register 4                */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028E18) Port 14 Input/Output Control Register 8                */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x48028E1C) Port 14 Input/Output Control Register 12               */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028E24) Port 14 Input Register                                 */
  __I  uint32_t  RESERVED2[14];
  __IO uint32_t  PDISC;                             /*!< (@ 0x48028E60) Port 14 Pin Function Decision Control Register         */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028E70) Port 14 Pin Power Save Register                        */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028E74) Port 14 Pin Hardware Select Register                   */
} PORT14_Type;


/* --------------------  End of section using anonymous unions  ------------------- */
#if defined(__CC_ARM)
  #pragma pop
#elif defined(__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning restore
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================          struct 'PPB' Position & Mask          ================ */
/* ================================================================================ */


/* ----------------------------------  PPB_ACTLR  --------------------------------- */
#define PPB_ACTLR_DISMCYCINT_Pos              0                                                       /*!< PPB ACTLR: DISMCYCINT Position          */
#define PPB_ACTLR_DISMCYCINT_Msk              (0x01UL << PPB_ACTLR_DISMCYCINT_Pos)                    /*!< PPB ACTLR: DISMCYCINT Mask              */
#define PPB_ACTLR_DISDEFWBUF_Pos              1                                                       /*!< PPB ACTLR: DISDEFWBUF Position          */
#define PPB_ACTLR_DISDEFWBUF_Msk              (0x01UL << PPB_ACTLR_DISDEFWBUF_Pos)                    /*!< PPB ACTLR: DISDEFWBUF Mask              */
#define PPB_ACTLR_DISFOLD_Pos                 2                                                       /*!< PPB ACTLR: DISFOLD Position             */
#define PPB_ACTLR_DISFOLD_Msk                 (0x01UL << PPB_ACTLR_DISFOLD_Pos)                       /*!< PPB ACTLR: DISFOLD Mask                 */
#define PPB_ACTLR_DISFPCA_Pos                 8                                                       /*!< PPB ACTLR: DISFPCA Position             */
#define PPB_ACTLR_DISFPCA_Msk                 (0x01UL << PPB_ACTLR_DISFPCA_Pos)                       /*!< PPB ACTLR: DISFPCA Mask                 */
#define PPB_ACTLR_DISOOFP_Pos                 9                                                       /*!< PPB ACTLR: DISOOFP Position             */
#define PPB_ACTLR_DISOOFP_Msk                 (0x01UL << PPB_ACTLR_DISOOFP_Pos)                       /*!< PPB ACTLR: DISOOFP Mask                 */

/* --------------------------------  PPB_SYST_CSR  -------------------------------- */
#define PPB_SYST_CSR_ENABLE_Pos               0                                                       /*!< PPB SYST_CSR: ENABLE Position           */
#define PPB_SYST_CSR_ENABLE_Msk               (0x01UL << PPB_SYST_CSR_ENABLE_Pos)                     /*!< PPB SYST_CSR: ENABLE Mask               */
#define PPB_SYST_CSR_TICKINT_Pos              1                                                       /*!< PPB SYST_CSR: TICKINT Position          */
#define PPB_SYST_CSR_TICKINT_Msk              (0x01UL << PPB_SYST_CSR_TICKINT_Pos)                    /*!< PPB SYST_CSR: TICKINT Mask              */
#define PPB_SYST_CSR_CLKSOURCE_Pos            2                                                       /*!< PPB SYST_CSR: CLKSOURCE Position        */
#define PPB_SYST_CSR_CLKSOURCE_Msk            (0x01UL << PPB_SYST_CSR_CLKSOURCE_Pos)                  /*!< PPB SYST_CSR: CLKSOURCE Mask            */
#define PPB_SYST_CSR_COUNTFLAG_Pos            16                                                      /*!< PPB SYST_CSR: COUNTFLAG Position        */
#define PPB_SYST_CSR_COUNTFLAG_Msk            (0x01UL << PPB_SYST_CSR_COUNTFLAG_Pos)                  /*!< PPB SYST_CSR: COUNTFLAG Mask            */

/* --------------------------------  PPB_SYST_RVR  -------------------------------- */
#define PPB_SYST_RVR_RELOAD_Pos               0                                                       /*!< PPB SYST_RVR: RELOAD Position           */
#define PPB_SYST_RVR_RELOAD_Msk               (0x00ffffffUL << PPB_SYST_RVR_RELOAD_Pos)               /*!< PPB SYST_RVR: RELOAD Mask               */

/* --------------------------------  PPB_SYST_CVR  -------------------------------- */
#define PPB_SYST_CVR_CURRENT_Pos              0                                                       /*!< PPB SYST_CVR: CURRENT Position          */
#define PPB_SYST_CVR_CURRENT_Msk              (0x00ffffffUL << PPB_SYST_CVR_CURRENT_Pos)              /*!< PPB SYST_CVR: CURRENT Mask              */

/* -------------------------------  PPB_SYST_CALIB  ------------------------------- */
#define PPB_SYST_CALIB_TENMS_Pos              0                                                       /*!< PPB SYST_CALIB: TENMS Position          */
#define PPB_SYST_CALIB_TENMS_Msk              (0x00ffffffUL << PPB_SYST_CALIB_TENMS_Pos)              /*!< PPB SYST_CALIB: TENMS Mask              */
#define PPB_SYST_CALIB_SKEW_Pos               30                                                      /*!< PPB SYST_CALIB: SKEW Position           */
#define PPB_SYST_CALIB_SKEW_Msk               (0x01UL << PPB_SYST_CALIB_SKEW_Pos)                     /*!< PPB SYST_CALIB: SKEW Mask               */
#define PPB_SYST_CALIB_NOREF_Pos              31                                                      /*!< PPB SYST_CALIB: NOREF Position          */
#define PPB_SYST_CALIB_NOREF_Msk              (0x01UL << PPB_SYST_CALIB_NOREF_Pos)                    /*!< PPB SYST_CALIB: NOREF Mask              */

/* -------------------------------  PPB_NVIC_ISER0  ------------------------------- */
#define PPB_NVIC_ISER0_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER0: SETENA Position         */
#define PPB_NVIC_ISER0_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER0_SETENA_Pos)             /*!< PPB NVIC_ISER0: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ISER1  ------------------------------- */
#define PPB_NVIC_ISER1_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER1: SETENA Position         */
#define PPB_NVIC_ISER1_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER1_SETENA_Pos)             /*!< PPB NVIC_ISER1: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ISER2  ------------------------------- */
#define PPB_NVIC_ISER2_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER2: SETENA Position         */
#define PPB_NVIC_ISER2_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER2_SETENA_Pos)             /*!< PPB NVIC_ISER2: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ISER3  ------------------------------- */
#define PPB_NVIC_ISER3_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER3: SETENA Position         */
#define PPB_NVIC_ISER3_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER3_SETENA_Pos)             /*!< PPB NVIC_ISER3: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ICER0  ------------------------------- */
#define PPB_NVIC_ICER0_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER0: CLRENA Position         */
#define PPB_NVIC_ICER0_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER0_CLRENA_Pos)             /*!< PPB NVIC_ICER0: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ICER1  ------------------------------- */
#define PPB_NVIC_ICER1_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER1: CLRENA Position         */
#define PPB_NVIC_ICER1_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER1_CLRENA_Pos)             /*!< PPB NVIC_ICER1: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ICER2  ------------------------------- */
#define PPB_NVIC_ICER2_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER2: CLRENA Position         */
#define PPB_NVIC_ICER2_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER2_CLRENA_Pos)             /*!< PPB NVIC_ICER2: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ICER3  ------------------------------- */
#define PPB_NVIC_ICER3_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER3: CLRENA Position         */
#define PPB_NVIC_ICER3_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER3_CLRENA_Pos)             /*!< PPB NVIC_ICER3: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ISPR0  ------------------------------- */
#define PPB_NVIC_ISPR0_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR0: SETPEND Position        */
#define PPB_NVIC_ISPR0_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR0_SETPEND_Pos)            /*!< PPB NVIC_ISPR0: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ISPR1  ------------------------------- */
#define PPB_NVIC_ISPR1_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR1: SETPEND Position        */
#define PPB_NVIC_ISPR1_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR1_SETPEND_Pos)            /*!< PPB NVIC_ISPR1: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ISPR2  ------------------------------- */
#define PPB_NVIC_ISPR2_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR2: SETPEND Position        */
#define PPB_NVIC_ISPR2_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR2_SETPEND_Pos)            /*!< PPB NVIC_ISPR2: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ISPR3  ------------------------------- */
#define PPB_NVIC_ISPR3_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR3: SETPEND Position        */
#define PPB_NVIC_ISPR3_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR3_SETPEND_Pos)            /*!< PPB NVIC_ISPR3: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR0  ------------------------------- */
#define PPB_NVIC_ICPR0_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR0: CLRPEND Position        */
#define PPB_NVIC_ICPR0_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR0_CLRPEND_Pos)            /*!< PPB NVIC_ICPR0: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR1  ------------------------------- */
#define PPB_NVIC_ICPR1_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR1: CLRPEND Position        */
#define PPB_NVIC_ICPR1_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR1_CLRPEND_Pos)            /*!< PPB NVIC_ICPR1: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR2  ------------------------------- */
#define PPB_NVIC_ICPR2_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR2: CLRPEND Position        */
#define PPB_NVIC_ICPR2_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR2_CLRPEND_Pos)            /*!< PPB NVIC_ICPR2: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR3  ------------------------------- */
#define PPB_NVIC_ICPR3_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR3: CLRPEND Position        */
#define PPB_NVIC_ICPR3_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR3_CLRPEND_Pos)            /*!< PPB NVIC_ICPR3: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_IABR0  ------------------------------- */
#define PPB_NVIC_IABR0_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR0: ACTIVE Position         */
#define PPB_NVIC_IABR0_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR0_ACTIVE_Pos)             /*!< PPB NVIC_IABR0: ACTIVE Mask             */

/* -------------------------------  PPB_NVIC_IABR1  ------------------------------- */
#define PPB_NVIC_IABR1_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR1: ACTIVE Position         */
#define PPB_NVIC_IABR1_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR1_ACTIVE_Pos)             /*!< PPB NVIC_IABR1: ACTIVE Mask             */

/* -------------------------------  PPB_NVIC_IABR2  ------------------------------- */
#define PPB_NVIC_IABR2_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR2: ACTIVE Position         */
#define PPB_NVIC_IABR2_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR2_ACTIVE_Pos)             /*!< PPB NVIC_IABR2: ACTIVE Mask             */

/* -------------------------------  PPB_NVIC_IABR3  ------------------------------- */
#define PPB_NVIC_IABR3_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR3: ACTIVE Position         */
#define PPB_NVIC_IABR3_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR3_ACTIVE_Pos)             /*!< PPB NVIC_IABR3: ACTIVE Mask             */

/* --------------------------------  PPB_NVIC_IPR0  ------------------------------- */
#define PPB_NVIC_IPR0_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR0: PRI_0 Position           */
#define PPB_NVIC_IPR0_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_0_Pos)               /*!< PPB NVIC_IPR0: PRI_0 Mask               */
#define PPB_NVIC_IPR0_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR0: PRI_1 Position           */
#define PPB_NVIC_IPR0_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_1_Pos)               /*!< PPB NVIC_IPR0: PRI_1 Mask               */
#define PPB_NVIC_IPR0_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR0: PRI_2 Position           */
#define PPB_NVIC_IPR0_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_2_Pos)               /*!< PPB NVIC_IPR0: PRI_2 Mask               */
#define PPB_NVIC_IPR0_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR0: PRI_3 Position           */
#define PPB_NVIC_IPR0_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_3_Pos)               /*!< PPB NVIC_IPR0: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR1  ------------------------------- */
#define PPB_NVIC_IPR1_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR1: PRI_0 Position           */
#define PPB_NVIC_IPR1_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_0_Pos)               /*!< PPB NVIC_IPR1: PRI_0 Mask               */
#define PPB_NVIC_IPR1_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR1: PRI_1 Position           */
#define PPB_NVIC_IPR1_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_1_Pos)               /*!< PPB NVIC_IPR1: PRI_1 Mask               */
#define PPB_NVIC_IPR1_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR1: PRI_2 Position           */
#define PPB_NVIC_IPR1_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_2_Pos)               /*!< PPB NVIC_IPR1: PRI_2 Mask               */
#define PPB_NVIC_IPR1_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR1: PRI_3 Position           */
#define PPB_NVIC_IPR1_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_3_Pos)               /*!< PPB NVIC_IPR1: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR2  ------------------------------- */
#define PPB_NVIC_IPR2_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR2: PRI_0 Position           */
#define PPB_NVIC_IPR2_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_0_Pos)               /*!< PPB NVIC_IPR2: PRI_0 Mask               */
#define PPB_NVIC_IPR2_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR2: PRI_1 Position           */
#define PPB_NVIC_IPR2_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_1_Pos)               /*!< PPB NVIC_IPR2: PRI_1 Mask               */
#define PPB_NVIC_IPR2_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR2: PRI_2 Position           */
#define PPB_NVIC_IPR2_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_2_Pos)               /*!< PPB NVIC_IPR2: PRI_2 Mask               */
#define PPB_NVIC_IPR2_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR2: PRI_3 Position           */
#define PPB_NVIC_IPR2_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_3_Pos)               /*!< PPB NVIC_IPR2: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR3  ------------------------------- */
#define PPB_NVIC_IPR3_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR3: PRI_0 Position           */
#define PPB_NVIC_IPR3_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_0_Pos)               /*!< PPB NVIC_IPR3: PRI_0 Mask               */
#define PPB_NVIC_IPR3_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR3: PRI_1 Position           */
#define PPB_NVIC_IPR3_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_1_Pos)               /*!< PPB NVIC_IPR3: PRI_1 Mask               */
#define PPB_NVIC_IPR3_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR3: PRI_2 Position           */
#define PPB_NVIC_IPR3_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_2_Pos)               /*!< PPB NVIC_IPR3: PRI_2 Mask               */
#define PPB_NVIC_IPR3_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR3: PRI_3 Position           */
#define PPB_NVIC_IPR3_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_3_Pos)               /*!< PPB NVIC_IPR3: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR4  ------------------------------- */
#define PPB_NVIC_IPR4_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR4: PRI_0 Position           */
#define PPB_NVIC_IPR4_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_0_Pos)               /*!< PPB NVIC_IPR4: PRI_0 Mask               */
#define PPB_NVIC_IPR4_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR4: PRI_1 Position           */
#define PPB_NVIC_IPR4_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_1_Pos)               /*!< PPB NVIC_IPR4: PRI_1 Mask               */
#define PPB_NVIC_IPR4_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR4: PRI_2 Position           */
#define PPB_NVIC_IPR4_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_2_Pos)               /*!< PPB NVIC_IPR4: PRI_2 Mask               */
#define PPB_NVIC_IPR4_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR4: PRI_3 Position           */
#define PPB_NVIC_IPR4_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_3_Pos)               /*!< PPB NVIC_IPR4: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR5  ------------------------------- */
#define PPB_NVIC_IPR5_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR5: PRI_0 Position           */
#define PPB_NVIC_IPR5_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_0_Pos)               /*!< PPB NVIC_IPR5: PRI_0 Mask               */
#define PPB_NVIC_IPR5_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR5: PRI_1 Position           */
#define PPB_NVIC_IPR5_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_1_Pos)               /*!< PPB NVIC_IPR5: PRI_1 Mask               */
#define PPB_NVIC_IPR5_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR5: PRI_2 Position           */
#define PPB_NVIC_IPR5_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_2_Pos)               /*!< PPB NVIC_IPR5: PRI_2 Mask               */
#define PPB_NVIC_IPR5_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR5: PRI_3 Position           */
#define PPB_NVIC_IPR5_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_3_Pos)               /*!< PPB NVIC_IPR5: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR6  ------------------------------- */
#define PPB_NVIC_IPR6_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR6: PRI_0 Position           */
#define PPB_NVIC_IPR6_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_0_Pos)               /*!< PPB NVIC_IPR6: PRI_0 Mask               */
#define PPB_NVIC_IPR6_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR6: PRI_1 Position           */
#define PPB_NVIC_IPR6_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_1_Pos)               /*!< PPB NVIC_IPR6: PRI_1 Mask               */
#define PPB_NVIC_IPR6_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR6: PRI_2 Position           */
#define PPB_NVIC_IPR6_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_2_Pos)               /*!< PPB NVIC_IPR6: PRI_2 Mask               */
#define PPB_NVIC_IPR6_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR6: PRI_3 Position           */
#define PPB_NVIC_IPR6_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_3_Pos)               /*!< PPB NVIC_IPR6: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR7  ------------------------------- */
#define PPB_NVIC_IPR7_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR7: PRI_0 Position           */
#define PPB_NVIC_IPR7_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_0_Pos)               /*!< PPB NVIC_IPR7: PRI_0 Mask               */
#define PPB_NVIC_IPR7_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR7: PRI_1 Position           */
#define PPB_NVIC_IPR7_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_1_Pos)               /*!< PPB NVIC_IPR7: PRI_1 Mask               */
#define PPB_NVIC_IPR7_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR7: PRI_2 Position           */
#define PPB_NVIC_IPR7_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_2_Pos)               /*!< PPB NVIC_IPR7: PRI_2 Mask               */
#define PPB_NVIC_IPR7_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR7: PRI_3 Position           */
#define PPB_NVIC_IPR7_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_3_Pos)               /*!< PPB NVIC_IPR7: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR8  ------------------------------- */
#define PPB_NVIC_IPR8_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR8: PRI_0 Position           */
#define PPB_NVIC_IPR8_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_0_Pos)               /*!< PPB NVIC_IPR8: PRI_0 Mask               */
#define PPB_NVIC_IPR8_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR8: PRI_1 Position           */
#define PPB_NVIC_IPR8_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_1_Pos)               /*!< PPB NVIC_IPR8: PRI_1 Mask               */
#define PPB_NVIC_IPR8_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR8: PRI_2 Position           */
#define PPB_NVIC_IPR8_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_2_Pos)               /*!< PPB NVIC_IPR8: PRI_2 Mask               */
#define PPB_NVIC_IPR8_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR8: PRI_3 Position           */
#define PPB_NVIC_IPR8_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_3_Pos)               /*!< PPB NVIC_IPR8: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR9  ------------------------------- */
#define PPB_NVIC_IPR9_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR9: PRI_0 Position           */
#define PPB_NVIC_IPR9_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_0_Pos)               /*!< PPB NVIC_IPR9: PRI_0 Mask               */
#define PPB_NVIC_IPR9_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR9: PRI_1 Position           */
#define PPB_NVIC_IPR9_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_1_Pos)               /*!< PPB NVIC_IPR9: PRI_1 Mask               */
#define PPB_NVIC_IPR9_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR9: PRI_2 Position           */
#define PPB_NVIC_IPR9_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_2_Pos)               /*!< PPB NVIC_IPR9: PRI_2 Mask               */
#define PPB_NVIC_IPR9_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR9: PRI_3 Position           */
#define PPB_NVIC_IPR9_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_3_Pos)               /*!< PPB NVIC_IPR9: PRI_3 Mask               */

/* -------------------------------  PPB_NVIC_IPR10  ------------------------------- */
#define PPB_NVIC_IPR10_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR10: PRI_0 Position          */
#define PPB_NVIC_IPR10_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_0_Pos)              /*!< PPB NVIC_IPR10: PRI_0 Mask              */
#define PPB_NVIC_IPR10_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR10: PRI_1 Position          */
#define PPB_NVIC_IPR10_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_1_Pos)              /*!< PPB NVIC_IPR10: PRI_1 Mask              */
#define PPB_NVIC_IPR10_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR10: PRI_2 Position          */
#define PPB_NVIC_IPR10_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_2_Pos)              /*!< PPB NVIC_IPR10: PRI_2 Mask              */
#define PPB_NVIC_IPR10_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR10: PRI_3 Position          */
#define PPB_NVIC_IPR10_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_3_Pos)              /*!< PPB NVIC_IPR10: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR11  ------------------------------- */
#define PPB_NVIC_IPR11_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR11: PRI_0 Position          */
#define PPB_NVIC_IPR11_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_0_Pos)              /*!< PPB NVIC_IPR11: PRI_0 Mask              */
#define PPB_NVIC_IPR11_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR11: PRI_1 Position          */
#define PPB_NVIC_IPR11_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_1_Pos)              /*!< PPB NVIC_IPR11: PRI_1 Mask              */
#define PPB_NVIC_IPR11_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR11: PRI_2 Position          */
#define PPB_NVIC_IPR11_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_2_Pos)              /*!< PPB NVIC_IPR11: PRI_2 Mask              */
#define PPB_NVIC_IPR11_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR11: PRI_3 Position          */
#define PPB_NVIC_IPR11_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_3_Pos)              /*!< PPB NVIC_IPR11: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR12  ------------------------------- */
#define PPB_NVIC_IPR12_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR12: PRI_0 Position          */
#define PPB_NVIC_IPR12_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_0_Pos)              /*!< PPB NVIC_IPR12: PRI_0 Mask              */
#define PPB_NVIC_IPR12_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR12: PRI_1 Position          */
#define PPB_NVIC_IPR12_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_1_Pos)              /*!< PPB NVIC_IPR12: PRI_1 Mask              */
#define PPB_NVIC_IPR12_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR12: PRI_2 Position          */
#define PPB_NVIC_IPR12_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_2_Pos)              /*!< PPB NVIC_IPR12: PRI_2 Mask              */
#define PPB_NVIC_IPR12_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR12: PRI_3 Position          */
#define PPB_NVIC_IPR12_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_3_Pos)              /*!< PPB NVIC_IPR12: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR13  ------------------------------- */
#define PPB_NVIC_IPR13_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR13: PRI_0 Position          */
#define PPB_NVIC_IPR13_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_0_Pos)              /*!< PPB NVIC_IPR13: PRI_0 Mask              */
#define PPB_NVIC_IPR13_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR13: PRI_1 Position          */
#define PPB_NVIC_IPR13_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_1_Pos)              /*!< PPB NVIC_IPR13: PRI_1 Mask              */
#define PPB_NVIC_IPR13_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR13: PRI_2 Position          */
#define PPB_NVIC_IPR13_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_2_Pos)              /*!< PPB NVIC_IPR13: PRI_2 Mask              */
#define PPB_NVIC_IPR13_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR13: PRI_3 Position          */
#define PPB_NVIC_IPR13_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_3_Pos)              /*!< PPB NVIC_IPR13: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR14  ------------------------------- */
#define PPB_NVIC_IPR14_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR14: PRI_0 Position          */
#define PPB_NVIC_IPR14_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_0_Pos)              /*!< PPB NVIC_IPR14: PRI_0 Mask              */
#define PPB_NVIC_IPR14_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR14: PRI_1 Position          */
#define PPB_NVIC_IPR14_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_1_Pos)              /*!< PPB NVIC_IPR14: PRI_1 Mask              */
#define PPB_NVIC_IPR14_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR14: PRI_2 Position          */
#define PPB_NVIC_IPR14_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_2_Pos)              /*!< PPB NVIC_IPR14: PRI_2 Mask              */
#define PPB_NVIC_IPR14_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR14: PRI_3 Position          */
#define PPB_NVIC_IPR14_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_3_Pos)              /*!< PPB NVIC_IPR14: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR15  ------------------------------- */
#define PPB_NVIC_IPR15_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR15: PRI_0 Position          */
#define PPB_NVIC_IPR15_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_0_Pos)              /*!< PPB NVIC_IPR15: PRI_0 Mask              */
#define PPB_NVIC_IPR15_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR15: PRI_1 Position          */
#define PPB_NVIC_IPR15_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_1_Pos)              /*!< PPB NVIC_IPR15: PRI_1 Mask              */
#define PPB_NVIC_IPR15_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR15: PRI_2 Position          */
#define PPB_NVIC_IPR15_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_2_Pos)              /*!< PPB NVIC_IPR15: PRI_2 Mask              */
#define PPB_NVIC_IPR15_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR15: PRI_3 Position          */
#define PPB_NVIC_IPR15_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_3_Pos)              /*!< PPB NVIC_IPR15: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR16  ------------------------------- */
#define PPB_NVIC_IPR16_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR16: PRI_0 Position          */
#define PPB_NVIC_IPR16_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_0_Pos)              /*!< PPB NVIC_IPR16: PRI_0 Mask              */
#define PPB_NVIC_IPR16_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR16: PRI_1 Position          */
#define PPB_NVIC_IPR16_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_1_Pos)              /*!< PPB NVIC_IPR16: PRI_1 Mask              */
#define PPB_NVIC_IPR16_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR16: PRI_2 Position          */
#define PPB_NVIC_IPR16_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_2_Pos)              /*!< PPB NVIC_IPR16: PRI_2 Mask              */
#define PPB_NVIC_IPR16_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR16: PRI_3 Position          */
#define PPB_NVIC_IPR16_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_3_Pos)              /*!< PPB NVIC_IPR16: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR17  ------------------------------- */
#define PPB_NVIC_IPR17_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR17: PRI_0 Position          */
#define PPB_NVIC_IPR17_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_0_Pos)              /*!< PPB NVIC_IPR17: PRI_0 Mask              */
#define PPB_NVIC_IPR17_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR17: PRI_1 Position          */
#define PPB_NVIC_IPR17_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_1_Pos)              /*!< PPB NVIC_IPR17: PRI_1 Mask              */
#define PPB_NVIC_IPR17_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR17: PRI_2 Position          */
#define PPB_NVIC_IPR17_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_2_Pos)              /*!< PPB NVIC_IPR17: PRI_2 Mask              */
#define PPB_NVIC_IPR17_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR17: PRI_3 Position          */
#define PPB_NVIC_IPR17_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_3_Pos)              /*!< PPB NVIC_IPR17: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR18  ------------------------------- */
#define PPB_NVIC_IPR18_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR18: PRI_0 Position          */
#define PPB_NVIC_IPR18_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_0_Pos)              /*!< PPB NVIC_IPR18: PRI_0 Mask              */
#define PPB_NVIC_IPR18_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR18: PRI_1 Position          */
#define PPB_NVIC_IPR18_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_1_Pos)              /*!< PPB NVIC_IPR18: PRI_1 Mask              */
#define PPB_NVIC_IPR18_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR18: PRI_2 Position          */
#define PPB_NVIC_IPR18_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_2_Pos)              /*!< PPB NVIC_IPR18: PRI_2 Mask              */
#define PPB_NVIC_IPR18_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR18: PRI_3 Position          */
#define PPB_NVIC_IPR18_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_3_Pos)              /*!< PPB NVIC_IPR18: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR19  ------------------------------- */
#define PPB_NVIC_IPR19_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR19: PRI_0 Position          */
#define PPB_NVIC_IPR19_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_0_Pos)              /*!< PPB NVIC_IPR19: PRI_0 Mask              */
#define PPB_NVIC_IPR19_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR19: PRI_1 Position          */
#define PPB_NVIC_IPR19_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_1_Pos)              /*!< PPB NVIC_IPR19: PRI_1 Mask              */
#define PPB_NVIC_IPR19_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR19: PRI_2 Position          */
#define PPB_NVIC_IPR19_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_2_Pos)              /*!< PPB NVIC_IPR19: PRI_2 Mask              */
#define PPB_NVIC_IPR19_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR19: PRI_3 Position          */
#define PPB_NVIC_IPR19_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_3_Pos)              /*!< PPB NVIC_IPR19: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR20  ------------------------------- */
#define PPB_NVIC_IPR20_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR20: PRI_0 Position          */
#define PPB_NVIC_IPR20_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_0_Pos)              /*!< PPB NVIC_IPR20: PRI_0 Mask              */
#define PPB_NVIC_IPR20_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR20: PRI_1 Position          */
#define PPB_NVIC_IPR20_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_1_Pos)              /*!< PPB NVIC_IPR20: PRI_1 Mask              */
#define PPB_NVIC_IPR20_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR20: PRI_2 Position          */
#define PPB_NVIC_IPR20_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_2_Pos)              /*!< PPB NVIC_IPR20: PRI_2 Mask              */
#define PPB_NVIC_IPR20_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR20: PRI_3 Position          */
#define PPB_NVIC_IPR20_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_3_Pos)              /*!< PPB NVIC_IPR20: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR21  ------------------------------- */
#define PPB_NVIC_IPR21_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR21: PRI_0 Position          */
#define PPB_NVIC_IPR21_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_0_Pos)              /*!< PPB NVIC_IPR21: PRI_0 Mask              */
#define PPB_NVIC_IPR21_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR21: PRI_1 Position          */
#define PPB_NVIC_IPR21_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_1_Pos)              /*!< PPB NVIC_IPR21: PRI_1 Mask              */
#define PPB_NVIC_IPR21_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR21: PRI_2 Position          */
#define PPB_NVIC_IPR21_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_2_Pos)              /*!< PPB NVIC_IPR21: PRI_2 Mask              */
#define PPB_NVIC_IPR21_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR21: PRI_3 Position          */
#define PPB_NVIC_IPR21_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_3_Pos)              /*!< PPB NVIC_IPR21: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR22  ------------------------------- */
#define PPB_NVIC_IPR22_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR22: PRI_0 Position          */
#define PPB_NVIC_IPR22_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_0_Pos)              /*!< PPB NVIC_IPR22: PRI_0 Mask              */
#define PPB_NVIC_IPR22_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR22: PRI_1 Position          */
#define PPB_NVIC_IPR22_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_1_Pos)              /*!< PPB NVIC_IPR22: PRI_1 Mask              */
#define PPB_NVIC_IPR22_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR22: PRI_2 Position          */
#define PPB_NVIC_IPR22_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_2_Pos)              /*!< PPB NVIC_IPR22: PRI_2 Mask              */
#define PPB_NVIC_IPR22_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR22: PRI_3 Position          */
#define PPB_NVIC_IPR22_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_3_Pos)              /*!< PPB NVIC_IPR22: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR23  ------------------------------- */
#define PPB_NVIC_IPR23_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR23: PRI_0 Position          */
#define PPB_NVIC_IPR23_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_0_Pos)              /*!< PPB NVIC_IPR23: PRI_0 Mask              */
#define PPB_NVIC_IPR23_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR23: PRI_1 Position          */
#define PPB_NVIC_IPR23_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_1_Pos)              /*!< PPB NVIC_IPR23: PRI_1 Mask              */
#define PPB_NVIC_IPR23_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR23: PRI_2 Position          */
#define PPB_NVIC_IPR23_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_2_Pos)              /*!< PPB NVIC_IPR23: PRI_2 Mask              */
#define PPB_NVIC_IPR23_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR23: PRI_3 Position          */
#define PPB_NVIC_IPR23_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_3_Pos)              /*!< PPB NVIC_IPR23: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR24  ------------------------------- */
#define PPB_NVIC_IPR24_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR24: PRI_0 Position          */
#define PPB_NVIC_IPR24_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_0_Pos)              /*!< PPB NVIC_IPR24: PRI_0 Mask              */
#define PPB_NVIC_IPR24_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR24: PRI_1 Position          */
#define PPB_NVIC_IPR24_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_1_Pos)              /*!< PPB NVIC_IPR24: PRI_1 Mask              */
#define PPB_NVIC_IPR24_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR24: PRI_2 Position          */
#define PPB_NVIC_IPR24_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_2_Pos)              /*!< PPB NVIC_IPR24: PRI_2 Mask              */
#define PPB_NVIC_IPR24_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR24: PRI_3 Position          */
#define PPB_NVIC_IPR24_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_3_Pos)              /*!< PPB NVIC_IPR24: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR25  ------------------------------- */
#define PPB_NVIC_IPR25_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR25: PRI_0 Position          */
#define PPB_NVIC_IPR25_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_0_Pos)              /*!< PPB NVIC_IPR25: PRI_0 Mask              */
#define PPB_NVIC_IPR25_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR25: PRI_1 Position          */
#define PPB_NVIC_IPR25_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_1_Pos)              /*!< PPB NVIC_IPR25: PRI_1 Mask              */
#define PPB_NVIC_IPR25_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR25: PRI_2 Position          */
#define PPB_NVIC_IPR25_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_2_Pos)              /*!< PPB NVIC_IPR25: PRI_2 Mask              */
#define PPB_NVIC_IPR25_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR25: PRI_3 Position          */
#define PPB_NVIC_IPR25_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_3_Pos)              /*!< PPB NVIC_IPR25: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR26  ------------------------------- */
#define PPB_NVIC_IPR26_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR26: PRI_0 Position          */
#define PPB_NVIC_IPR26_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_0_Pos)              /*!< PPB NVIC_IPR26: PRI_0 Mask              */
#define PPB_NVIC_IPR26_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR26: PRI_1 Position          */
#define PPB_NVIC_IPR26_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_1_Pos)              /*!< PPB NVIC_IPR26: PRI_1 Mask              */
#define PPB_NVIC_IPR26_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR26: PRI_2 Position          */
#define PPB_NVIC_IPR26_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_2_Pos)              /*!< PPB NVIC_IPR26: PRI_2 Mask              */
#define PPB_NVIC_IPR26_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR26: PRI_3 Position          */
#define PPB_NVIC_IPR26_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_3_Pos)              /*!< PPB NVIC_IPR26: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR27  ------------------------------- */
#define PPB_NVIC_IPR27_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR27: PRI_0 Position          */
#define PPB_NVIC_IPR27_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_0_Pos)              /*!< PPB NVIC_IPR27: PRI_0 Mask              */
#define PPB_NVIC_IPR27_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR27: PRI_1 Position          */
#define PPB_NVIC_IPR27_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_1_Pos)              /*!< PPB NVIC_IPR27: PRI_1 Mask              */
#define PPB_NVIC_IPR27_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR27: PRI_2 Position          */
#define PPB_NVIC_IPR27_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_2_Pos)              /*!< PPB NVIC_IPR27: PRI_2 Mask              */
#define PPB_NVIC_IPR27_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR27: PRI_3 Position          */
#define PPB_NVIC_IPR27_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_3_Pos)              /*!< PPB NVIC_IPR27: PRI_3 Mask              */

/* ----------------------------------  PPB_CPUID  --------------------------------- */
#define PPB_CPUID_Revision_Pos                0                                                       /*!< PPB CPUID: Revision Position            */
#define PPB_CPUID_Revision_Msk                (0x0fUL << PPB_CPUID_Revision_Pos)                      /*!< PPB CPUID: Revision Mask                */
#define PPB_CPUID_PartNo_Pos                  4                                                       /*!< PPB CPUID: PartNo Position              */
#define PPB_CPUID_PartNo_Msk                  (0x00000fffUL << PPB_CPUID_PartNo_Pos)                  /*!< PPB CPUID: PartNo Mask                  */
#define PPB_CPUID_Constant_Pos                16                                                      /*!< PPB CPUID: Constant Position            */
#define PPB_CPUID_Constant_Msk                (0x0fUL << PPB_CPUID_Constant_Pos)                      /*!< PPB CPUID: Constant Mask                */
#define PPB_CPUID_Variant_Pos                 20                                                      /*!< PPB CPUID: Variant Position             */
#define PPB_CPUID_Variant_Msk                 (0x0fUL << PPB_CPUID_Variant_Pos)                       /*!< PPB CPUID: Variant Mask                 */
#define PPB_CPUID_Implementer_Pos             24                                                      /*!< PPB CPUID: Implementer Position         */
#define PPB_CPUID_Implementer_Msk             (0x000000ffUL << PPB_CPUID_Implementer_Pos)             /*!< PPB CPUID: Implementer Mask             */

/* ----------------------------------  PPB_ICSR  ---------------------------------- */
#define PPB_ICSR_VECTACTIVE_Pos               0                                                       /*!< PPB ICSR: VECTACTIVE Position           */
#define PPB_ICSR_VECTACTIVE_Msk               (0x000001ffUL << PPB_ICSR_VECTACTIVE_Pos)               /*!< PPB ICSR: VECTACTIVE Mask               */
#define PPB_ICSR_RETTOBASE_Pos                11                                                      /*!< PPB ICSR: RETTOBASE Position            */
#define PPB_ICSR_RETTOBASE_Msk                (0x01UL << PPB_ICSR_RETTOBASE_Pos)                      /*!< PPB ICSR: RETTOBASE Mask                */
#define PPB_ICSR_VECTPENDING_Pos              12                                                      /*!< PPB ICSR: VECTPENDING Position          */
#define PPB_ICSR_VECTPENDING_Msk              (0x3fUL << PPB_ICSR_VECTPENDING_Pos)                    /*!< PPB ICSR: VECTPENDING Mask              */
#define PPB_ICSR_ISRPENDING_Pos               22                                                      /*!< PPB ICSR: ISRPENDING Position           */
#define PPB_ICSR_ISRPENDING_Msk               (0x01UL << PPB_ICSR_ISRPENDING_Pos)                     /*!< PPB ICSR: ISRPENDING Mask               */
#define PPB_ICSR_Res_Pos                      23                                                      /*!< PPB ICSR: Res Position                  */
#define PPB_ICSR_Res_Msk                      (0x01UL << PPB_ICSR_Res_Pos)                            /*!< PPB ICSR: Res Mask                      */
#define PPB_ICSR_PENDSTCLR_Pos                25                                                      /*!< PPB ICSR: PENDSTCLR Position            */
#define PPB_ICSR_PENDSTCLR_Msk                (0x01UL << PPB_ICSR_PENDSTCLR_Pos)                      /*!< PPB ICSR: PENDSTCLR Mask                */
#define PPB_ICSR_PENDSTSET_Pos                26                                                      /*!< PPB ICSR: PENDSTSET Position            */
#define PPB_ICSR_PENDSTSET_Msk                (0x01UL << PPB_ICSR_PENDSTSET_Pos)                      /*!< PPB ICSR: PENDSTSET Mask                */
#define PPB_ICSR_PENDSVCLR_Pos                27                                                      /*!< PPB ICSR: PENDSVCLR Position            */
#define PPB_ICSR_PENDSVCLR_Msk                (0x01UL << PPB_ICSR_PENDSVCLR_Pos)                      /*!< PPB ICSR: PENDSVCLR Mask                */
#define PPB_ICSR_PENDSVSET_Pos                28                                                      /*!< PPB ICSR: PENDSVSET Position            */
#define PPB_ICSR_PENDSVSET_Msk                (0x01UL << PPB_ICSR_PENDSVSET_Pos)                      /*!< PPB ICSR: PENDSVSET Mask                */
#define PPB_ICSR_NMIPENDSET_Pos               31                                                      /*!< PPB ICSR: NMIPENDSET Position           */
#define PPB_ICSR_NMIPENDSET_Msk               (0x01UL << PPB_ICSR_NMIPENDSET_Pos)                     /*!< PPB ICSR: NMIPENDSET Mask               */

/* ----------------------------------  PPB_VTOR  ---------------------------------- */
#define PPB_VTOR_TBLOFF_Pos                   10                                                      /*!< PPB VTOR: TBLOFF Position               */
#define PPB_VTOR_TBLOFF_Msk                   (0x003fffffUL << PPB_VTOR_TBLOFF_Pos)                   /*!< PPB VTOR: TBLOFF Mask                   */

/* ----------------------------------  PPB_AIRCR  --------------------------------- */
#define PPB_AIRCR_VECTRESET_Pos               0                                                       /*!< PPB AIRCR: VECTRESET Position           */
#define PPB_AIRCR_VECTRESET_Msk               (0x01UL << PPB_AIRCR_VECTRESET_Pos)                     /*!< PPB AIRCR: VECTRESET Mask               */
#define PPB_AIRCR_VECTCLRACTIVE_Pos           1                                                       /*!< PPB AIRCR: VECTCLRACTIVE Position       */
#define PPB_AIRCR_VECTCLRACTIVE_Msk           (0x01UL << PPB_AIRCR_VECTCLRACTIVE_Pos)                 /*!< PPB AIRCR: VECTCLRACTIVE Mask           */
#define PPB_AIRCR_SYSRESETREQ_Pos             2                                                       /*!< PPB AIRCR: SYSRESETREQ Position         */
#define PPB_AIRCR_SYSRESETREQ_Msk             (0x01UL << PPB_AIRCR_SYSRESETREQ_Pos)                   /*!< PPB AIRCR: SYSRESETREQ Mask             */
#define PPB_AIRCR_PRIGROUP_Pos                8                                                       /*!< PPB AIRCR: PRIGROUP Position            */
#define PPB_AIRCR_PRIGROUP_Msk                (0x07UL << PPB_AIRCR_PRIGROUP_Pos)                      /*!< PPB AIRCR: PRIGROUP Mask                */
#define PPB_AIRCR_ENDIANNESS_Pos              15                                                      /*!< PPB AIRCR: ENDIANNESS Position          */
#define PPB_AIRCR_ENDIANNESS_Msk              (0x01UL << PPB_AIRCR_ENDIANNESS_Pos)                    /*!< PPB AIRCR: ENDIANNESS Mask              */
#define PPB_AIRCR_VECTKEY_Pos                 16                                                      /*!< PPB AIRCR: VECTKEY Position             */
#define PPB_AIRCR_VECTKEY_Msk                 (0x0000ffffUL << PPB_AIRCR_VECTKEY_Pos)                 /*!< PPB AIRCR: VECTKEY Mask                 */

/* -----------------------------------  PPB_SCR  ---------------------------------- */
#define PPB_SCR_SLEEPONEXIT_Pos               1                                                       /*!< PPB SCR: SLEEPONEXIT Position           */
#define PPB_SCR_SLEEPONEXIT_Msk               (0x01UL << PPB_SCR_SLEEPONEXIT_Pos)                     /*!< PPB SCR: SLEEPONEXIT Mask               */
#define PPB_SCR_SLEEPDEEP_Pos                 2                                                       /*!< PPB SCR: SLEEPDEEP Position             */
#define PPB_SCR_SLEEPDEEP_Msk                 (0x01UL << PPB_SCR_SLEEPDEEP_Pos)                       /*!< PPB SCR: SLEEPDEEP Mask                 */
#define PPB_SCR_SEVONPEND_Pos                 4                                                       /*!< PPB SCR: SEVONPEND Position             */
#define PPB_SCR_SEVONPEND_Msk                 (0x01UL << PPB_SCR_SEVONPEND_Pos)                       /*!< PPB SCR: SEVONPEND Mask                 */

/* -----------------------------------  PPB_CCR  ---------------------------------- */
#define PPB_CCR_NONBASETHRDENA_Pos            0                                                       /*!< PPB CCR: NONBASETHRDENA Position        */
#define PPB_CCR_NONBASETHRDENA_Msk            (0x01UL << PPB_CCR_NONBASETHRDENA_Pos)                  /*!< PPB CCR: NONBASETHRDENA Mask            */
#define PPB_CCR_USERSETMPEND_Pos              1                                                       /*!< PPB CCR: USERSETMPEND Position          */
#define PPB_CCR_USERSETMPEND_Msk              (0x01UL << PPB_CCR_USERSETMPEND_Pos)                    /*!< PPB CCR: USERSETMPEND Mask              */
#define PPB_CCR_UNALIGN_TRP_Pos               3                                                       /*!< PPB CCR: UNALIGN_TRP Position           */
#define PPB_CCR_UNALIGN_TRP_Msk               (0x01UL << PPB_CCR_UNALIGN_TRP_Pos)                     /*!< PPB CCR: UNALIGN_TRP Mask               */
#define PPB_CCR_DIV_0_TRP_Pos                 4                                                       /*!< PPB CCR: DIV_0_TRP Position             */
#define PPB_CCR_DIV_0_TRP_Msk                 (0x01UL << PPB_CCR_DIV_0_TRP_Pos)                       /*!< PPB CCR: DIV_0_TRP Mask                 */
#define PPB_CCR_BFHFNMIGN_Pos                 8                                                       /*!< PPB CCR: BFHFNMIGN Position             */
#define PPB_CCR_BFHFNMIGN_Msk                 (0x01UL << PPB_CCR_BFHFNMIGN_Pos)                       /*!< PPB CCR: BFHFNMIGN Mask                 */
#define PPB_CCR_STKALIGN_Pos                  9                                                       /*!< PPB CCR: STKALIGN Position              */
#define PPB_CCR_STKALIGN_Msk                  (0x01UL << PPB_CCR_STKALIGN_Pos)                        /*!< PPB CCR: STKALIGN Mask                  */

/* ----------------------------------  PPB_SHPR1  --------------------------------- */
#define PPB_SHPR1_PRI_4_Pos                   0                                                       /*!< PPB SHPR1: PRI_4 Position               */
#define PPB_SHPR1_PRI_4_Msk                   (0x000000ffUL << PPB_SHPR1_PRI_4_Pos)                   /*!< PPB SHPR1: PRI_4 Mask                   */
#define PPB_SHPR1_PRI_5_Pos                   8                                                       /*!< PPB SHPR1: PRI_5 Position               */
#define PPB_SHPR1_PRI_5_Msk                   (0x000000ffUL << PPB_SHPR1_PRI_5_Pos)                   /*!< PPB SHPR1: PRI_5 Mask                   */
#define PPB_SHPR1_PRI_6_Pos                   16                                                      /*!< PPB SHPR1: PRI_6 Position               */
#define PPB_SHPR1_PRI_6_Msk                   (0x000000ffUL << PPB_SHPR1_PRI_6_Pos)                   /*!< PPB SHPR1: PRI_6 Mask                   */

/* ----------------------------------  PPB_SHPR2  --------------------------------- */
#define PPB_SHPR2_PRI_11_Pos                  24                                                      /*!< PPB SHPR2: PRI_11 Position              */
#define PPB_SHPR2_PRI_11_Msk                  (0x000000ffUL << PPB_SHPR2_PRI_11_Pos)                  /*!< PPB SHPR2: PRI_11 Mask                  */

/* ----------------------------------  PPB_SHPR3  --------------------------------- */
#define PPB_SHPR3_PRI_14_Pos                  16                                                      /*!< PPB SHPR3: PRI_14 Position              */
#define PPB_SHPR3_PRI_14_Msk                  (0x000000ffUL << PPB_SHPR3_PRI_14_Pos)                  /*!< PPB SHPR3: PRI_14 Mask                  */
#define PPB_SHPR3_PRI_15_Pos                  24                                                      /*!< PPB SHPR3: PRI_15 Position              */
#define PPB_SHPR3_PRI_15_Msk                  (0x000000ffUL << PPB_SHPR3_PRI_15_Pos)                  /*!< PPB SHPR3: PRI_15 Mask                  */

/* ----------------------------------  PPB_SHCSR  --------------------------------- */
#define PPB_SHCSR_MEMFAULTACT_Pos             0                                                       /*!< PPB SHCSR: MEMFAULTACT Position         */
#define PPB_SHCSR_MEMFAULTACT_Msk             (0x01UL << PPB_SHCSR_MEMFAULTACT_Pos)                   /*!< PPB SHCSR: MEMFAULTACT Mask             */
#define PPB_SHCSR_BUSFAULTACT_Pos             1                                                       /*!< PPB SHCSR: BUSFAULTACT Position         */
#define PPB_SHCSR_BUSFAULTACT_Msk             (0x01UL << PPB_SHCSR_BUSFAULTACT_Pos)                   /*!< PPB SHCSR: BUSFAULTACT Mask             */
#define PPB_SHCSR_USGFAULTACT_Pos             3                                                       /*!< PPB SHCSR: USGFAULTACT Position         */
#define PPB_SHCSR_USGFAULTACT_Msk             (0x01UL << PPB_SHCSR_USGFAULTACT_Pos)                   /*!< PPB SHCSR: USGFAULTACT Mask             */
#define PPB_SHCSR_SVCALLACT_Pos               7                                                       /*!< PPB SHCSR: SVCALLACT Position           */
#define PPB_SHCSR_SVCALLACT_Msk               (0x01UL << PPB_SHCSR_SVCALLACT_Pos)                     /*!< PPB SHCSR: SVCALLACT Mask               */
#define PPB_SHCSR_MONITORACT_Pos              8                                                       /*!< PPB SHCSR: MONITORACT Position          */
#define PPB_SHCSR_MONITORACT_Msk              (0x01UL << PPB_SHCSR_MONITORACT_Pos)                    /*!< PPB SHCSR: MONITORACT Mask              */
#define PPB_SHCSR_PENDSVACT_Pos               10                                                      /*!< PPB SHCSR: PENDSVACT Position           */
#define PPB_SHCSR_PENDSVACT_Msk               (0x01UL << PPB_SHCSR_PENDSVACT_Pos)                     /*!< PPB SHCSR: PENDSVACT Mask               */
#define PPB_SHCSR_SYSTICKACT_Pos              11                                                      /*!< PPB SHCSR: SYSTICKACT Position          */
#define PPB_SHCSR_SYSTICKACT_Msk              (0x01UL << PPB_SHCSR_SYSTICKACT_Pos)                    /*!< PPB SHCSR: SYSTICKACT Mask              */
#define PPB_SHCSR_USGFAULTPENDED_Pos          12                                                      /*!< PPB SHCSR: USGFAULTPENDED Position      */
#define PPB_SHCSR_USGFAULTPENDED_Msk          (0x01UL << PPB_SHCSR_USGFAULTPENDED_Pos)                /*!< PPB SHCSR: USGFAULTPENDED Mask          */
#define PPB_SHCSR_MEMFAULTPENDED_Pos          13                                                      /*!< PPB SHCSR: MEMFAULTPENDED Position      */
#define PPB_SHCSR_MEMFAULTPENDED_Msk          (0x01UL << PPB_SHCSR_MEMFAULTPENDED_Pos)                /*!< PPB SHCSR: MEMFAULTPENDED Mask          */
#define PPB_SHCSR_BUSFAULTPENDED_Pos          14                                                      /*!< PPB SHCSR: BUSFAULTPENDED Position      */
#define PPB_SHCSR_BUSFAULTPENDED_Msk          (0x01UL << PPB_SHCSR_BUSFAULTPENDED_Pos)                /*!< PPB SHCSR: BUSFAULTPENDED Mask          */
#define PPB_SHCSR_SVCALLPENDED_Pos            15                                                      /*!< PPB SHCSR: SVCALLPENDED Position        */
#define PPB_SHCSR_SVCALLPENDED_Msk            (0x01UL << PPB_SHCSR_SVCALLPENDED_Pos)                  /*!< PPB SHCSR: SVCALLPENDED Mask            */
#define PPB_SHCSR_MEMFAULTENA_Pos             16                                                      /*!< PPB SHCSR: MEMFAULTENA Position         */
#define PPB_SHCSR_MEMFAULTENA_Msk             (0x01UL << PPB_SHCSR_MEMFAULTENA_Pos)                   /*!< PPB SHCSR: MEMFAULTENA Mask             */
#define PPB_SHCSR_BUSFAULTENA_Pos             17                                                      /*!< PPB SHCSR: BUSFAULTENA Position         */
#define PPB_SHCSR_BUSFAULTENA_Msk             (0x01UL << PPB_SHCSR_BUSFAULTENA_Pos)                   /*!< PPB SHCSR: BUSFAULTENA Mask             */
#define PPB_SHCSR_USGFAULTENA_Pos             18                                                      /*!< PPB SHCSR: USGFAULTENA Position         */
#define PPB_SHCSR_USGFAULTENA_Msk             (0x01UL << PPB_SHCSR_USGFAULTENA_Pos)                   /*!< PPB SHCSR: USGFAULTENA Mask             */

/* ----------------------------------  PPB_CFSR  ---------------------------------- */
#define PPB_CFSR_IACCVIOL_Pos                 0                                                       /*!< PPB CFSR: IACCVIOL Position             */
#define PPB_CFSR_IACCVIOL_Msk                 (0x01UL << PPB_CFSR_IACCVIOL_Pos)                       /*!< PPB CFSR: IACCVIOL Mask                 */
#define PPB_CFSR_DACCVIOL_Pos                 1                                                       /*!< PPB CFSR: DACCVIOL Position             */
#define PPB_CFSR_DACCVIOL_Msk                 (0x01UL << PPB_CFSR_DACCVIOL_Pos)                       /*!< PPB CFSR: DACCVIOL Mask                 */
#define PPB_CFSR_MUNSTKERR_Pos                3                                                       /*!< PPB CFSR: MUNSTKERR Position            */
#define PPB_CFSR_MUNSTKERR_Msk                (0x01UL << PPB_CFSR_MUNSTKERR_Pos)                      /*!< PPB CFSR: MUNSTKERR Mask                */
#define PPB_CFSR_MSTKERR_Pos                  4                                                       /*!< PPB CFSR: MSTKERR Position              */
#define PPB_CFSR_MSTKERR_Msk                  (0x01UL << PPB_CFSR_MSTKERR_Pos)                        /*!< PPB CFSR: MSTKERR Mask                  */
#define PPB_CFSR_MLSPERR_Pos                  5                                                       /*!< PPB CFSR: MLSPERR Position              */
#define PPB_CFSR_MLSPERR_Msk                  (0x01UL << PPB_CFSR_MLSPERR_Pos)                        /*!< PPB CFSR: MLSPERR Mask                  */
#define PPB_CFSR_MMARVALID_Pos                7                                                       /*!< PPB CFSR: MMARVALID Position            */
#define PPB_CFSR_MMARVALID_Msk                (0x01UL << PPB_CFSR_MMARVALID_Pos)                      /*!< PPB CFSR: MMARVALID Mask                */
#define PPB_CFSR_IBUSERR_Pos                  8                                                       /*!< PPB CFSR: IBUSERR Position              */
#define PPB_CFSR_IBUSERR_Msk                  (0x01UL << PPB_CFSR_IBUSERR_Pos)                        /*!< PPB CFSR: IBUSERR Mask                  */
#define PPB_CFSR_PRECISERR_Pos                9                                                       /*!< PPB CFSR: PRECISERR Position            */
#define PPB_CFSR_PRECISERR_Msk                (0x01UL << PPB_CFSR_PRECISERR_Pos)                      /*!< PPB CFSR: PRECISERR Mask                */
#define PPB_CFSR_IMPRECISERR_Pos              10                                                      /*!< PPB CFSR: IMPRECISERR Position          */
#define PPB_CFSR_IMPRECISERR_Msk              (0x01UL << PPB_CFSR_IMPRECISERR_Pos)                    /*!< PPB CFSR: IMPRECISERR Mask              */
#define PPB_CFSR_UNSTKERR_Pos                 11                                                      /*!< PPB CFSR: UNSTKERR Position             */
#define PPB_CFSR_UNSTKERR_Msk                 (0x01UL << PPB_CFSR_UNSTKERR_Pos)                       /*!< PPB CFSR: UNSTKERR Mask                 */
#define PPB_CFSR_STKERR_Pos                   12                                                      /*!< PPB CFSR: STKERR Position               */
#define PPB_CFSR_STKERR_Msk                   (0x01UL << PPB_CFSR_STKERR_Pos)                         /*!< PPB CFSR: STKERR Mask                   */
#define PPB_CFSR_LSPERR_Pos                   13                                                      /*!< PPB CFSR: LSPERR Position               */
#define PPB_CFSR_LSPERR_Msk                   (0x01UL << PPB_CFSR_LSPERR_Pos)                         /*!< PPB CFSR: LSPERR Mask                   */
#define PPB_CFSR_BFARVALID_Pos                15                                                      /*!< PPB CFSR: BFARVALID Position            */
#define PPB_CFSR_BFARVALID_Msk                (0x01UL << PPB_CFSR_BFARVALID_Pos)                      /*!< PPB CFSR: BFARVALID Mask                */
#define PPB_CFSR_UNDEFINSTR_Pos               16                                                      /*!< PPB CFSR: UNDEFINSTR Position           */
#define PPB_CFSR_UNDEFINSTR_Msk               (0x01UL << PPB_CFSR_UNDEFINSTR_Pos)                     /*!< PPB CFSR: UNDEFINSTR Mask               */
#define PPB_CFSR_INVSTATE_Pos                 17                                                      /*!< PPB CFSR: INVSTATE Position             */
#define PPB_CFSR_INVSTATE_Msk                 (0x01UL << PPB_CFSR_INVSTATE_Pos)                       /*!< PPB CFSR: INVSTATE Mask                 */
#define PPB_CFSR_INVPC_Pos                    18                                                      /*!< PPB CFSR: INVPC Position                */
#define PPB_CFSR_INVPC_Msk                    (0x01UL << PPB_CFSR_INVPC_Pos)                          /*!< PPB CFSR: INVPC Mask                    */
#define PPB_CFSR_NOCP_Pos                     19                                                      /*!< PPB CFSR: NOCP Position                 */
#define PPB_CFSR_NOCP_Msk                     (0x01UL << PPB_CFSR_NOCP_Pos)                           /*!< PPB CFSR: NOCP Mask                     */
#define PPB_CFSR_UNALIGNED_Pos                24                                                      /*!< PPB CFSR: UNALIGNED Position            */
#define PPB_CFSR_UNALIGNED_Msk                (0x01UL << PPB_CFSR_UNALIGNED_Pos)                      /*!< PPB CFSR: UNALIGNED Mask                */
#define PPB_CFSR_DIVBYZERO_Pos                25                                                      /*!< PPB CFSR: DIVBYZERO Position            */
#define PPB_CFSR_DIVBYZERO_Msk                (0x01UL << PPB_CFSR_DIVBYZERO_Pos)                      /*!< PPB CFSR: DIVBYZERO Mask                */

/* ----------------------------------  PPB_HFSR  ---------------------------------- */
#define PPB_HFSR_VECTTBL_Pos                  1                                                       /*!< PPB HFSR: VECTTBL Position              */
#define PPB_HFSR_VECTTBL_Msk                  (0x01UL << PPB_HFSR_VECTTBL_Pos)                        /*!< PPB HFSR: VECTTBL Mask                  */
#define PPB_HFSR_FORCED_Pos                   30                                                      /*!< PPB HFSR: FORCED Position               */
#define PPB_HFSR_FORCED_Msk                   (0x01UL << PPB_HFSR_FORCED_Pos)                         /*!< PPB HFSR: FORCED Mask                   */
#define PPB_HFSR_DEBUGEVT_Pos                 31                                                      /*!< PPB HFSR: DEBUGEVT Position             */
#define PPB_HFSR_DEBUGEVT_Msk                 (0x01UL << PPB_HFSR_DEBUGEVT_Pos)                       /*!< PPB HFSR: DEBUGEVT Mask                 */

/* ----------------------------------  PPB_MMFAR  --------------------------------- */
#define PPB_MMFAR_ADDRESS_Pos                 0                                                       /*!< PPB MMFAR: ADDRESS Position             */
#define PPB_MMFAR_ADDRESS_Msk                 (0xffffffffUL << PPB_MMFAR_ADDRESS_Pos)                 /*!< PPB MMFAR: ADDRESS Mask                 */

/* ----------------------------------  PPB_BFAR  ---------------------------------- */
#define PPB_BFAR_ADDRESS_Pos                  0                                                       /*!< PPB BFAR: ADDRESS Position              */
#define PPB_BFAR_ADDRESS_Msk                  (0xffffffffUL << PPB_BFAR_ADDRESS_Pos)                  /*!< PPB BFAR: ADDRESS Mask                  */

/* ----------------------------------  PPB_AFSR  ---------------------------------- */
#define PPB_AFSR_VALUE_Pos                    0                                                       /*!< PPB AFSR: VALUE Position                */
#define PPB_AFSR_VALUE_Msk                    (0xffffffffUL << PPB_AFSR_VALUE_Pos)                    /*!< PPB AFSR: VALUE Mask                    */

/* ----------------------------------  PPB_CPACR  --------------------------------- */
#define PPB_CPACR_CP10_Pos                    20                                                      /*!< PPB CPACR: CP10 Position                */
#define PPB_CPACR_CP10_Msk                    (0x03UL << PPB_CPACR_CP10_Pos)                          /*!< PPB CPACR: CP10 Mask                    */
#define PPB_CPACR_CP11_Pos                    22                                                      /*!< PPB CPACR: CP11 Position                */
#define PPB_CPACR_CP11_Msk                    (0x03UL << PPB_CPACR_CP11_Pos)                          /*!< PPB CPACR: CP11 Mask                    */

/* --------------------------------  PPB_MPU_TYPE  -------------------------------- */
#define PPB_MPU_TYPE_SEPARATE_Pos             0                                                       /*!< PPB MPU_TYPE: SEPARATE Position         */
#define PPB_MPU_TYPE_SEPARATE_Msk             (0x01UL << PPB_MPU_TYPE_SEPARATE_Pos)                   /*!< PPB MPU_TYPE: SEPARATE Mask             */
#define PPB_MPU_TYPE_DREGION_Pos              8                                                       /*!< PPB MPU_TYPE: DREGION Position          */
#define PPB_MPU_TYPE_DREGION_Msk              (0x000000ffUL << PPB_MPU_TYPE_DREGION_Pos)              /*!< PPB MPU_TYPE: DREGION Mask              */
#define PPB_MPU_TYPE_IREGION_Pos              16                                                      /*!< PPB MPU_TYPE: IREGION Position          */
#define PPB_MPU_TYPE_IREGION_Msk              (0x000000ffUL << PPB_MPU_TYPE_IREGION_Pos)              /*!< PPB MPU_TYPE: IREGION Mask              */

/* --------------------------------  PPB_MPU_CTRL  -------------------------------- */
#define PPB_MPU_CTRL_ENABLE_Pos               0                                                       /*!< PPB MPU_CTRL: ENABLE Position           */
#define PPB_MPU_CTRL_ENABLE_Msk               (0x01UL << PPB_MPU_CTRL_ENABLE_Pos)                     /*!< PPB MPU_CTRL: ENABLE Mask               */
#define PPB_MPU_CTRL_HFNMIENA_Pos             1                                                       /*!< PPB MPU_CTRL: HFNMIENA Position         */
#define PPB_MPU_CTRL_HFNMIENA_Msk             (0x01UL << PPB_MPU_CTRL_HFNMIENA_Pos)                   /*!< PPB MPU_CTRL: HFNMIENA Mask             */
#define PPB_MPU_CTRL_PRIVDEFENA_Pos           2                                                       /*!< PPB MPU_CTRL: PRIVDEFENA Position       */
#define PPB_MPU_CTRL_PRIVDEFENA_Msk           (0x01UL << PPB_MPU_CTRL_PRIVDEFENA_Pos)                 /*!< PPB MPU_CTRL: PRIVDEFENA Mask           */

/* ---------------------------------  PPB_MPU_RNR  -------------------------------- */
#define PPB_MPU_RNR_REGION_Pos                0                                                       /*!< PPB MPU_RNR: REGION Position            */
#define PPB_MPU_RNR_REGION_Msk                (0x000000ffUL << PPB_MPU_RNR_REGION_Pos)                /*!< PPB MPU_RNR: REGION Mask                */

/* --------------------------------  PPB_MPU_RBAR  -------------------------------- */
#define PPB_MPU_RBAR_REGION_Pos               0                                                       /*!< PPB MPU_RBAR: REGION Position           */
#define PPB_MPU_RBAR_REGION_Msk               (0x0fUL << PPB_MPU_RBAR_REGION_Pos)                     /*!< PPB MPU_RBAR: REGION Mask               */
#define PPB_MPU_RBAR_VALID_Pos                4                                                       /*!< PPB MPU_RBAR: VALID Position            */
#define PPB_MPU_RBAR_VALID_Msk                (0x01UL << PPB_MPU_RBAR_VALID_Pos)                      /*!< PPB MPU_RBAR: VALID Mask                */
#define PPB_MPU_RBAR_ADDR_Pos                 9                                                       /*!< PPB MPU_RBAR: ADDR Position             */
#define PPB_MPU_RBAR_ADDR_Msk                 (0x007fffffUL << PPB_MPU_RBAR_ADDR_Pos)                 /*!< PPB MPU_RBAR: ADDR Mask                 */

/* --------------------------------  PPB_MPU_RASR  -------------------------------- */
#define PPB_MPU_RASR_ENABLE_Pos               0                                                       /*!< PPB MPU_RASR: ENABLE Position           */
#define PPB_MPU_RASR_ENABLE_Msk               (0x01UL << PPB_MPU_RASR_ENABLE_Pos)                     /*!< PPB MPU_RASR: ENABLE Mask               */
#define PPB_MPU_RASR_SIZE_Pos                 1                                                       /*!< PPB MPU_RASR: SIZE Position             */
#define PPB_MPU_RASR_SIZE_Msk                 (0x1fUL << PPB_MPU_RASR_SIZE_Pos)                       /*!< PPB MPU_RASR: SIZE Mask                 */
#define PPB_MPU_RASR_SRD_Pos                  8                                                       /*!< PPB MPU_RASR: SRD Position              */
#define PPB_MPU_RASR_SRD_Msk                  (0x000000ffUL << PPB_MPU_RASR_SRD_Pos)                  /*!< PPB MPU_RASR: SRD Mask                  */
#define PPB_MPU_RASR_B_Pos                    16                                                      /*!< PPB MPU_RASR: B Position                */
#define PPB_MPU_RASR_B_Msk                    (0x01UL << PPB_MPU_RASR_B_Pos)                          /*!< PPB MPU_RASR: B Mask                    */
#define PPB_MPU_RASR_C_Pos                    17                                                      /*!< PPB MPU_RASR: C Position                */
#define PPB_MPU_RASR_C_Msk                    (0x01UL << PPB_MPU_RASR_C_Pos)                          /*!< PPB MPU_RASR: C Mask                    */
#define PPB_MPU_RASR_S_Pos                    18                                                      /*!< PPB MPU_RASR: S Position                */
#define PPB_MPU_RASR_S_Msk                    (0x01UL << PPB_MPU_RASR_S_Pos)                          /*!< PPB MPU_RASR: S Mask                    */
#define PPB_MPU_RASR_TEX_Pos                  19                                                      /*!< PPB MPU_RASR: TEX Position              */
#define PPB_MPU_RASR_TEX_Msk                  (0x07UL << PPB_MPU_RASR_TEX_Pos)                        /*!< PPB MPU_RASR: TEX Mask                  */
#define PPB_MPU_RASR_AP_Pos                   24                                                      /*!< PPB MPU_RASR: AP Position               */
#define PPB_MPU_RASR_AP_Msk                   (0x07UL << PPB_MPU_RASR_AP_Pos)                         /*!< PPB MPU_RASR: AP Mask                   */
#define PPB_MPU_RASR_XN_Pos                   28                                                      /*!< PPB MPU_RASR: XN Position               */
#define PPB_MPU_RASR_XN_Msk                   (0x01UL << PPB_MPU_RASR_XN_Pos)                         /*!< PPB MPU_RASR: XN Mask                   */

/* -------------------------------  PPB_MPU_RBAR_A1  ------------------------------ */
#define PPB_MPU_RBAR_A1_REGION_Pos            0                                                       /*!< PPB MPU_RBAR_A1: REGION Position        */
#define PPB_MPU_RBAR_A1_REGION_Msk            (0x0fUL << PPB_MPU_RBAR_A1_REGION_Pos)                  /*!< PPB MPU_RBAR_A1: REGION Mask            */
#define PPB_MPU_RBAR_A1_VALID_Pos             4                                                       /*!< PPB MPU_RBAR_A1: VALID Position         */
#define PPB_MPU_RBAR_A1_VALID_Msk             (0x01UL << PPB_MPU_RBAR_A1_VALID_Pos)                   /*!< PPB MPU_RBAR_A1: VALID Mask             */
#define PPB_MPU_RBAR_A1_ADDR_Pos              9                                                       /*!< PPB MPU_RBAR_A1: ADDR Position          */
#define PPB_MPU_RBAR_A1_ADDR_Msk              (0x007fffffUL << PPB_MPU_RBAR_A1_ADDR_Pos)              /*!< PPB MPU_RBAR_A1: ADDR Mask              */

/* -------------------------------  PPB_MPU_RASR_A1  ------------------------------ */
#define PPB_MPU_RASR_A1_ENABLE_Pos            0                                                       /*!< PPB MPU_RASR_A1: ENABLE Position        */
#define PPB_MPU_RASR_A1_ENABLE_Msk            (0x01UL << PPB_MPU_RASR_A1_ENABLE_Pos)                  /*!< PPB MPU_RASR_A1: ENABLE Mask            */
#define PPB_MPU_RASR_A1_SIZE_Pos              1                                                       /*!< PPB MPU_RASR_A1: SIZE Position          */
#define PPB_MPU_RASR_A1_SIZE_Msk              (0x1fUL << PPB_MPU_RASR_A1_SIZE_Pos)                    /*!< PPB MPU_RASR_A1: SIZE Mask              */
#define PPB_MPU_RASR_A1_SRD_Pos               8                                                       /*!< PPB MPU_RASR_A1: SRD Position           */
#define PPB_MPU_RASR_A1_SRD_Msk               (0x000000ffUL << PPB_MPU_RASR_A1_SRD_Pos)               /*!< PPB MPU_RASR_A1: SRD Mask               */
#define PPB_MPU_RASR_A1_B_Pos                 16                                                      /*!< PPB MPU_RASR_A1: B Position             */
#define PPB_MPU_RASR_A1_B_Msk                 (0x01UL << PPB_MPU_RASR_A1_B_Pos)                       /*!< PPB MPU_RASR_A1: B Mask                 */
#define PPB_MPU_RASR_A1_C_Pos                 17                                                      /*!< PPB MPU_RASR_A1: C Position             */
#define PPB_MPU_RASR_A1_C_Msk                 (0x01UL << PPB_MPU_RASR_A1_C_Pos)                       /*!< PPB MPU_RASR_A1: C Mask                 */
#define PPB_MPU_RASR_A1_S_Pos                 18                                                      /*!< PPB MPU_RASR_A1: S Position             */
#define PPB_MPU_RASR_A1_S_Msk                 (0x01UL << PPB_MPU_RASR_A1_S_Pos)                       /*!< PPB MPU_RASR_A1: S Mask                 */
#define PPB_MPU_RASR_A1_TEX_Pos               19                                                      /*!< PPB MPU_RASR_A1: TEX Position           */
#define PPB_MPU_RASR_A1_TEX_Msk               (0x07UL << PPB_MPU_RASR_A1_TEX_Pos)                     /*!< PPB MPU_RASR_A1: TEX Mask               */
#define PPB_MPU_RASR_A1_AP_Pos                24                                                      /*!< PPB MPU_RASR_A1: AP Position            */
#define PPB_MPU_RASR_A1_AP_Msk                (0x07UL << PPB_MPU_RASR_A1_AP_Pos)                      /*!< PPB MPU_RASR_A1: AP Mask                */
#define PPB_MPU_RASR_A1_XN_Pos                28                                                      /*!< PPB MPU_RASR_A1: XN Position            */
#define PPB_MPU_RASR_A1_XN_Msk                (0x01UL << PPB_MPU_RASR_A1_XN_Pos)                      /*!< PPB MPU_RASR_A1: XN Mask                */

/* -------------------------------  PPB_MPU_RBAR_A2  ------------------------------ */
#define PPB_MPU_RBAR_A2_REGION_Pos            0                                                       /*!< PPB MPU_RBAR_A2: REGION Position        */
#define PPB_MPU_RBAR_A2_REGION_Msk            (0x0fUL << PPB_MPU_RBAR_A2_REGION_Pos)                  /*!< PPB MPU_RBAR_A2: REGION Mask            */
#define PPB_MPU_RBAR_A2_VALID_Pos             4                                                       /*!< PPB MPU_RBAR_A2: VALID Position         */
#define PPB_MPU_RBAR_A2_VALID_Msk             (0x01UL << PPB_MPU_RBAR_A2_VALID_Pos)                   /*!< PPB MPU_RBAR_A2: VALID Mask             */
#define PPB_MPU_RBAR_A2_ADDR_Pos              9                                                       /*!< PPB MPU_RBAR_A2: ADDR Position          */
#define PPB_MPU_RBAR_A2_ADDR_Msk              (0x007fffffUL << PPB_MPU_RBAR_A2_ADDR_Pos)              /*!< PPB MPU_RBAR_A2: ADDR Mask              */

/* -------------------------------  PPB_MPU_RASR_A2  ------------------------------ */
#define PPB_MPU_RASR_A2_ENABLE_Pos            0                                                       /*!< PPB MPU_RASR_A2: ENABLE Position        */
#define PPB_MPU_RASR_A2_ENABLE_Msk            (0x01UL << PPB_MPU_RASR_A2_ENABLE_Pos)                  /*!< PPB MPU_RASR_A2: ENABLE Mask            */
#define PPB_MPU_RASR_A2_SIZE_Pos              1                                                       /*!< PPB MPU_RASR_A2: SIZE Position          */
#define PPB_MPU_RASR_A2_SIZE_Msk              (0x1fUL << PPB_MPU_RASR_A2_SIZE_Pos)                    /*!< PPB MPU_RASR_A2: SIZE Mask              */
#define PPB_MPU_RASR_A2_SRD_Pos               8                                                       /*!< PPB MPU_RASR_A2: SRD Position           */
#define PPB_MPU_RASR_A2_SRD_Msk               (0x000000ffUL << PPB_MPU_RASR_A2_SRD_Pos)               /*!< PPB MPU_RASR_A2: SRD Mask               */
#define PPB_MPU_RASR_A2_B_Pos                 16                                                      /*!< PPB MPU_RASR_A2: B Position             */
#define PPB_MPU_RASR_A2_B_Msk                 (0x01UL << PPB_MPU_RASR_A2_B_Pos)                       /*!< PPB MPU_RASR_A2: B Mask                 */
#define PPB_MPU_RASR_A2_C_Pos                 17                                                      /*!< PPB MPU_RASR_A2: C Position             */
#define PPB_MPU_RASR_A2_C_Msk                 (0x01UL << PPB_MPU_RASR_A2_C_Pos)                       /*!< PPB MPU_RASR_A2: C Mask                 */
#define PPB_MPU_RASR_A2_S_Pos                 18                                                      /*!< PPB MPU_RASR_A2: S Position             */
#define PPB_MPU_RASR_A2_S_Msk                 (0x01UL << PPB_MPU_RASR_A2_S_Pos)                       /*!< PPB MPU_RASR_A2: S Mask                 */
#define PPB_MPU_RASR_A2_TEX_Pos               19                                                      /*!< PPB MPU_RASR_A2: TEX Position           */
#define PPB_MPU_RASR_A2_TEX_Msk               (0x07UL << PPB_MPU_RASR_A2_TEX_Pos)                     /*!< PPB MPU_RASR_A2: TEX Mask               */
#define PPB_MPU_RASR_A2_AP_Pos                24                                                      /*!< PPB MPU_RASR_A2: AP Position            */
#define PPB_MPU_RASR_A2_AP_Msk                (0x07UL << PPB_MPU_RASR_A2_AP_Pos)                      /*!< PPB MPU_RASR_A2: AP Mask                */
#define PPB_MPU_RASR_A2_XN_Pos                28                                                      /*!< PPB MPU_RASR_A2: XN Position            */
#define PPB_MPU_RASR_A2_XN_Msk                (0x01UL << PPB_MPU_RASR_A2_XN_Pos)                      /*!< PPB MPU_RASR_A2: XN Mask                */

/* -------------------------------  PPB_MPU_RBAR_A3  ------------------------------ */
#define PPB_MPU_RBAR_A3_REGION_Pos            0                                                       /*!< PPB MPU_RBAR_A3: REGION Position        */
#define PPB_MPU_RBAR_A3_REGION_Msk            (0x0fUL << PPB_MPU_RBAR_A3_REGION_Pos)                  /*!< PPB MPU_RBAR_A3: REGION Mask            */
#define PPB_MPU_RBAR_A3_VALID_Pos             4                                                       /*!< PPB MPU_RBAR_A3: VALID Position         */
#define PPB_MPU_RBAR_A3_VALID_Msk             (0x01UL << PPB_MPU_RBAR_A3_VALID_Pos)                   /*!< PPB MPU_RBAR_A3: VALID Mask             */
#define PPB_MPU_RBAR_A3_ADDR_Pos              9                                                       /*!< PPB MPU_RBAR_A3: ADDR Position          */
#define PPB_MPU_RBAR_A3_ADDR_Msk              (0x007fffffUL << PPB_MPU_RBAR_A3_ADDR_Pos)              /*!< PPB MPU_RBAR_A3: ADDR Mask              */

/* -------------------------------  PPB_MPU_RASR_A3  ------------------------------ */
#define PPB_MPU_RASR_A3_ENABLE_Pos            0                                                       /*!< PPB MPU_RASR_A3: ENABLE Position        */
#define PPB_MPU_RASR_A3_ENABLE_Msk            (0x01UL << PPB_MPU_RASR_A3_ENABLE_Pos)                  /*!< PPB MPU_RASR_A3: ENABLE Mask            */
#define PPB_MPU_RASR_A3_SIZE_Pos              1                                                       /*!< PPB MPU_RASR_A3: SIZE Position          */
#define PPB_MPU_RASR_A3_SIZE_Msk              (0x1fUL << PPB_MPU_RASR_A3_SIZE_Pos)                    /*!< PPB MPU_RASR_A3: SIZE Mask              */
#define PPB_MPU_RASR_A3_SRD_Pos               8                                                       /*!< PPB MPU_RASR_A3: SRD Position           */
#define PPB_MPU_RASR_A3_SRD_Msk               (0x000000ffUL << PPB_MPU_RASR_A3_SRD_Pos)               /*!< PPB MPU_RASR_A3: SRD Mask               */
#define PPB_MPU_RASR_A3_B_Pos                 16                                                      /*!< PPB MPU_RASR_A3: B Position             */
#define PPB_MPU_RASR_A3_B_Msk                 (0x01UL << PPB_MPU_RASR_A3_B_Pos)                       /*!< PPB MPU_RASR_A3: B Mask                 */
#define PPB_MPU_RASR_A3_C_Pos                 17                                                      /*!< PPB MPU_RASR_A3: C Position             */
#define PPB_MPU_RASR_A3_C_Msk                 (0x01UL << PPB_MPU_RASR_A3_C_Pos)                       /*!< PPB MPU_RASR_A3: C Mask                 */
#define PPB_MPU_RASR_A3_S_Pos                 18                                                      /*!< PPB MPU_RASR_A3: S Position             */
#define PPB_MPU_RASR_A3_S_Msk                 (0x01UL << PPB_MPU_RASR_A3_S_Pos)                       /*!< PPB MPU_RASR_A3: S Mask                 */
#define PPB_MPU_RASR_A3_TEX_Pos               19                                                      /*!< PPB MPU_RASR_A3: TEX Position           */
#define PPB_MPU_RASR_A3_TEX_Msk               (0x07UL << PPB_MPU_RASR_A3_TEX_Pos)                     /*!< PPB MPU_RASR_A3: TEX Mask               */
#define PPB_MPU_RASR_A3_AP_Pos                24                                                      /*!< PPB MPU_RASR_A3: AP Position            */
#define PPB_MPU_RASR_A3_AP_Msk                (0x07UL << PPB_MPU_RASR_A3_AP_Pos)                      /*!< PPB MPU_RASR_A3: AP Mask                */
#define PPB_MPU_RASR_A3_XN_Pos                28                                                      /*!< PPB MPU_RASR_A3: XN Position            */
#define PPB_MPU_RASR_A3_XN_Msk                (0x01UL << PPB_MPU_RASR_A3_XN_Pos)                      /*!< PPB MPU_RASR_A3: XN Mask                */

/* ----------------------------------  PPB_STIR  ---------------------------------- */
#define PPB_STIR_INTID_Pos                    0                                                       /*!< PPB STIR: INTID Position                */
#define PPB_STIR_INTID_Msk                    (0x000001ffUL << PPB_STIR_INTID_Pos)                    /*!< PPB STIR: INTID Mask                    */

/* ----------------------------------  PPB_FPCCR  --------------------------------- */
#define PPB_FPCCR_LSPACT_Pos                  0                                                       /*!< PPB FPCCR: LSPACT Position              */
#define PPB_FPCCR_LSPACT_Msk                  (0x01UL << PPB_FPCCR_LSPACT_Pos)                        /*!< PPB FPCCR: LSPACT Mask                  */
#define PPB_FPCCR_USER_Pos                    1                                                       /*!< PPB FPCCR: USER Position                */
#define PPB_FPCCR_USER_Msk                    (0x01UL << PPB_FPCCR_USER_Pos)                          /*!< PPB FPCCR: USER Mask                    */
#define PPB_FPCCR_THREAD_Pos                  3                                                       /*!< PPB FPCCR: THREAD Position              */
#define PPB_FPCCR_THREAD_Msk                  (0x01UL << PPB_FPCCR_THREAD_Pos)                        /*!< PPB FPCCR: THREAD Mask                  */
#define PPB_FPCCR_HFRDY_Pos                   4                                                       /*!< PPB FPCCR: HFRDY Position               */
#define PPB_FPCCR_HFRDY_Msk                   (0x01UL << PPB_FPCCR_HFRDY_Pos)                         /*!< PPB FPCCR: HFRDY Mask                   */
#define PPB_FPCCR_MMRDY_Pos                   5                                                       /*!< PPB FPCCR: MMRDY Position               */
#define PPB_FPCCR_MMRDY_Msk                   (0x01UL << PPB_FPCCR_MMRDY_Pos)                         /*!< PPB FPCCR: MMRDY Mask                   */
#define PPB_FPCCR_BFRDY_Pos                   6                                                       /*!< PPB FPCCR: BFRDY Position               */
#define PPB_FPCCR_BFRDY_Msk                   (0x01UL << PPB_FPCCR_BFRDY_Pos)                         /*!< PPB FPCCR: BFRDY Mask                   */
#define PPB_FPCCR_MONRDY_Pos                  8                                                       /*!< PPB FPCCR: MONRDY Position              */
#define PPB_FPCCR_MONRDY_Msk                  (0x01UL << PPB_FPCCR_MONRDY_Pos)                        /*!< PPB FPCCR: MONRDY Mask                  */
#define PPB_FPCCR_LSPEN_Pos                   30                                                      /*!< PPB FPCCR: LSPEN Position               */
#define PPB_FPCCR_LSPEN_Msk                   (0x01UL << PPB_FPCCR_LSPEN_Pos)                         /*!< PPB FPCCR: LSPEN Mask                   */
#define PPB_FPCCR_ASPEN_Pos                   31                                                      /*!< PPB FPCCR: ASPEN Position               */
#define PPB_FPCCR_ASPEN_Msk                   (0x01UL << PPB_FPCCR_ASPEN_Pos)                         /*!< PPB FPCCR: ASPEN Mask                   */

/* ----------------------------------  PPB_FPCAR  --------------------------------- */
#define PPB_FPCAR_ADDRESS_Pos                 3                                                       /*!< PPB FPCAR: ADDRESS Position             */
#define PPB_FPCAR_ADDRESS_Msk                 (0x1fffffffUL << PPB_FPCAR_ADDRESS_Pos)                 /*!< PPB FPCAR: ADDRESS Mask                 */

/* ---------------------------------  PPB_FPDSCR  --------------------------------- */
#define PPB_FPDSCR_RMode_Pos                  22                                                      /*!< PPB FPDSCR: RMode Position              */
#define PPB_FPDSCR_RMode_Msk                  (0x03UL << PPB_FPDSCR_RMode_Pos)                        /*!< PPB FPDSCR: RMode Mask                  */
#define PPB_FPDSCR_FZ_Pos                     24                                                      /*!< PPB FPDSCR: FZ Position                 */
#define PPB_FPDSCR_FZ_Msk                     (0x01UL << PPB_FPDSCR_FZ_Pos)                           /*!< PPB FPDSCR: FZ Mask                     */
#define PPB_FPDSCR_DN_Pos                     25                                                      /*!< PPB FPDSCR: DN Position                 */
#define PPB_FPDSCR_DN_Msk                     (0x01UL << PPB_FPDSCR_DN_Pos)                           /*!< PPB FPDSCR: DN Mask                     */
#define PPB_FPDSCR_AHP_Pos                    26                                                      /*!< PPB FPDSCR: AHP Position                */
#define PPB_FPDSCR_AHP_Msk                    (0x01UL << PPB_FPDSCR_AHP_Pos)                          /*!< PPB FPDSCR: AHP Mask                    */


/* ================================================================================ */
/* ================          struct 'DLR' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  DLR_OVRSTAT  -------------------------------- */
#define DLR_OVRSTAT_LN0_Pos                   0                                                       /*!< DLR OVRSTAT: LN0 Position               */
#define DLR_OVRSTAT_LN0_Msk                   (0x01UL << DLR_OVRSTAT_LN0_Pos)                         /*!< DLR OVRSTAT: LN0 Mask                   */
#define DLR_OVRSTAT_LN1_Pos                   1                                                       /*!< DLR OVRSTAT: LN1 Position               */
#define DLR_OVRSTAT_LN1_Msk                   (0x01UL << DLR_OVRSTAT_LN1_Pos)                         /*!< DLR OVRSTAT: LN1 Mask                   */
#define DLR_OVRSTAT_LN2_Pos                   2                                                       /*!< DLR OVRSTAT: LN2 Position               */
#define DLR_OVRSTAT_LN2_Msk                   (0x01UL << DLR_OVRSTAT_LN2_Pos)                         /*!< DLR OVRSTAT: LN2 Mask                   */
#define DLR_OVRSTAT_LN3_Pos                   3                                                       /*!< DLR OVRSTAT: LN3 Position               */
#define DLR_OVRSTAT_LN3_Msk                   (0x01UL << DLR_OVRSTAT_LN3_Pos)                         /*!< DLR OVRSTAT: LN3 Mask                   */
#define DLR_OVRSTAT_LN4_Pos                   4                                                       /*!< DLR OVRSTAT: LN4 Position               */
#define DLR_OVRSTAT_LN4_Msk                   (0x01UL << DLR_OVRSTAT_LN4_Pos)                         /*!< DLR OVRSTAT: LN4 Mask                   */
#define DLR_OVRSTAT_LN5_Pos                   5                                                       /*!< DLR OVRSTAT: LN5 Position               */
#define DLR_OVRSTAT_LN5_Msk                   (0x01UL << DLR_OVRSTAT_LN5_Pos)                         /*!< DLR OVRSTAT: LN5 Mask                   */
#define DLR_OVRSTAT_LN6_Pos                   6                                                       /*!< DLR OVRSTAT: LN6 Position               */
#define DLR_OVRSTAT_LN6_Msk                   (0x01UL << DLR_OVRSTAT_LN6_Pos)                         /*!< DLR OVRSTAT: LN6 Mask                   */
#define DLR_OVRSTAT_LN7_Pos                   7                                                       /*!< DLR OVRSTAT: LN7 Position               */
#define DLR_OVRSTAT_LN7_Msk                   (0x01UL << DLR_OVRSTAT_LN7_Pos)                         /*!< DLR OVRSTAT: LN7 Mask                   */

/* ---------------------------------  DLR_OVRCLR  --------------------------------- */
#define DLR_OVRCLR_LN0_Pos                    0                                                       /*!< DLR OVRCLR: LN0 Position                */
#define DLR_OVRCLR_LN0_Msk                    (0x01UL << DLR_OVRCLR_LN0_Pos)                          /*!< DLR OVRCLR: LN0 Mask                    */
#define DLR_OVRCLR_LN1_Pos                    1                                                       /*!< DLR OVRCLR: LN1 Position                */
#define DLR_OVRCLR_LN1_Msk                    (0x01UL << DLR_OVRCLR_LN1_Pos)                          /*!< DLR OVRCLR: LN1 Mask                    */
#define DLR_OVRCLR_LN2_Pos                    2                                                       /*!< DLR OVRCLR: LN2 Position                */
#define DLR_OVRCLR_LN2_Msk                    (0x01UL << DLR_OVRCLR_LN2_Pos)                          /*!< DLR OVRCLR: LN2 Mask                    */
#define DLR_OVRCLR_LN3_Pos                    3                                                       /*!< DLR OVRCLR: LN3 Position                */
#define DLR_OVRCLR_LN3_Msk                    (0x01UL << DLR_OVRCLR_LN3_Pos)                          /*!< DLR OVRCLR: LN3 Mask                    */
#define DLR_OVRCLR_LN4_Pos                    4                                                       /*!< DLR OVRCLR: LN4 Position                */
#define DLR_OVRCLR_LN4_Msk                    (0x01UL << DLR_OVRCLR_LN4_Pos)                          /*!< DLR OVRCLR: LN4 Mask                    */
#define DLR_OVRCLR_LN5_Pos                    5                                                       /*!< DLR OVRCLR: LN5 Position                */
#define DLR_OVRCLR_LN5_Msk                    (0x01UL << DLR_OVRCLR_LN5_Pos)                          /*!< DLR OVRCLR: LN5 Mask                    */
#define DLR_OVRCLR_LN6_Pos                    6                                                       /*!< DLR OVRCLR: LN6 Position                */
#define DLR_OVRCLR_LN6_Msk                    (0x01UL << DLR_OVRCLR_LN6_Pos)                          /*!< DLR OVRCLR: LN6 Mask                    */
#define DLR_OVRCLR_LN7_Pos                    7                                                       /*!< DLR OVRCLR: LN7 Position                */
#define DLR_OVRCLR_LN7_Msk                    (0x01UL << DLR_OVRCLR_LN7_Pos)                          /*!< DLR OVRCLR: LN7 Mask                    */

/* ---------------------------------  DLR_SRSEL0  --------------------------------- */
#define DLR_SRSEL0_RS0_Pos                    0                                                       /*!< DLR SRSEL0: RS0 Position                */
#define DLR_SRSEL0_RS0_Msk                    (0x0fUL << DLR_SRSEL0_RS0_Pos)                          /*!< DLR SRSEL0: RS0 Mask                    */
#define DLR_SRSEL0_RS1_Pos                    4                                                       /*!< DLR SRSEL0: RS1 Position                */
#define DLR_SRSEL0_RS1_Msk                    (0x0fUL << DLR_SRSEL0_RS1_Pos)                          /*!< DLR SRSEL0: RS1 Mask                    */
#define DLR_SRSEL0_RS2_Pos                    8                                                       /*!< DLR SRSEL0: RS2 Position                */
#define DLR_SRSEL0_RS2_Msk                    (0x0fUL << DLR_SRSEL0_RS2_Pos)                          /*!< DLR SRSEL0: RS2 Mask                    */
#define DLR_SRSEL0_RS3_Pos                    12                                                      /*!< DLR SRSEL0: RS3 Position                */
#define DLR_SRSEL0_RS3_Msk                    (0x0fUL << DLR_SRSEL0_RS3_Pos)                          /*!< DLR SRSEL0: RS3 Mask                    */
#define DLR_SRSEL0_RS4_Pos                    16                                                      /*!< DLR SRSEL0: RS4 Position                */
#define DLR_SRSEL0_RS4_Msk                    (0x0fUL << DLR_SRSEL0_RS4_Pos)                          /*!< DLR SRSEL0: RS4 Mask                    */
#define DLR_SRSEL0_RS5_Pos                    20                                                      /*!< DLR SRSEL0: RS5 Position                */
#define DLR_SRSEL0_RS5_Msk                    (0x0fUL << DLR_SRSEL0_RS5_Pos)                          /*!< DLR SRSEL0: RS5 Mask                    */
#define DLR_SRSEL0_RS6_Pos                    24                                                      /*!< DLR SRSEL0: RS6 Position                */
#define DLR_SRSEL0_RS6_Msk                    (0x0fUL << DLR_SRSEL0_RS6_Pos)                          /*!< DLR SRSEL0: RS6 Mask                    */
#define DLR_SRSEL0_RS7_Pos                    28                                                      /*!< DLR SRSEL0: RS7 Position                */
#define DLR_SRSEL0_RS7_Msk                    (0x0fUL << DLR_SRSEL0_RS7_Pos)                          /*!< DLR SRSEL0: RS7 Mask                    */

/* ----------------------------------  DLR_LNEN  ---------------------------------- */
#define DLR_LNEN_LN0_Pos                      0                                                       /*!< DLR LNEN: LN0 Position                  */
#define DLR_LNEN_LN0_Msk                      (0x01UL << DLR_LNEN_LN0_Pos)                            /*!< DLR LNEN: LN0 Mask                      */
#define DLR_LNEN_LN1_Pos                      1                                                       /*!< DLR LNEN: LN1 Position                  */
#define DLR_LNEN_LN1_Msk                      (0x01UL << DLR_LNEN_LN1_Pos)                            /*!< DLR LNEN: LN1 Mask                      */
#define DLR_LNEN_LN2_Pos                      2                                                       /*!< DLR LNEN: LN2 Position                  */
#define DLR_LNEN_LN2_Msk                      (0x01UL << DLR_LNEN_LN2_Pos)                            /*!< DLR LNEN: LN2 Mask                      */
#define DLR_LNEN_LN3_Pos                      3                                                       /*!< DLR LNEN: LN3 Position                  */
#define DLR_LNEN_LN3_Msk                      (0x01UL << DLR_LNEN_LN3_Pos)                            /*!< DLR LNEN: LN3 Mask                      */
#define DLR_LNEN_LN4_Pos                      4                                                       /*!< DLR LNEN: LN4 Position                  */
#define DLR_LNEN_LN4_Msk                      (0x01UL << DLR_LNEN_LN4_Pos)                            /*!< DLR LNEN: LN4 Mask                      */
#define DLR_LNEN_LN5_Pos                      5                                                       /*!< DLR LNEN: LN5 Position                  */
#define DLR_LNEN_LN5_Msk                      (0x01UL << DLR_LNEN_LN5_Pos)                            /*!< DLR LNEN: LN5 Mask                      */
#define DLR_LNEN_LN6_Pos                      6                                                       /*!< DLR LNEN: LN6 Position                  */
#define DLR_LNEN_LN6_Msk                      (0x01UL << DLR_LNEN_LN6_Pos)                            /*!< DLR LNEN: LN6 Mask                      */
#define DLR_LNEN_LN7_Pos                      7                                                       /*!< DLR LNEN: LN7 Position                  */
#define DLR_LNEN_LN7_Msk                      (0x01UL << DLR_LNEN_LN7_Pos)                            /*!< DLR LNEN: LN7 Mask                      */


/* ================================================================================ */
/* ================           Group 'ERU' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  ERU_EXISEL  --------------------------------- */
#define ERU_EXISEL_EXS0A_Pos                  0                                                       /*!< ERU EXISEL: EXS0A Position              */
#define ERU_EXISEL_EXS0A_Msk                  (0x03UL << ERU_EXISEL_EXS0A_Pos)                        /*!< ERU EXISEL: EXS0A Mask                  */
#define ERU_EXISEL_EXS0B_Pos                  2                                                       /*!< ERU EXISEL: EXS0B Position              */
#define ERU_EXISEL_EXS0B_Msk                  (0x03UL << ERU_EXISEL_EXS0B_Pos)                        /*!< ERU EXISEL: EXS0B Mask                  */
#define ERU_EXISEL_EXS1A_Pos                  4                                                       /*!< ERU EXISEL: EXS1A Position              */
#define ERU_EXISEL_EXS1A_Msk                  (0x03UL << ERU_EXISEL_EXS1A_Pos)                        /*!< ERU EXISEL: EXS1A Mask                  */
#define ERU_EXISEL_EXS1B_Pos                  6                                                       /*!< ERU EXISEL: EXS1B Position              */
#define ERU_EXISEL_EXS1B_Msk                  (0x03UL << ERU_EXISEL_EXS1B_Pos)                        /*!< ERU EXISEL: EXS1B Mask                  */
#define ERU_EXISEL_EXS2A_Pos                  8                                                       /*!< ERU EXISEL: EXS2A Position              */
#define ERU_EXISEL_EXS2A_Msk                  (0x03UL << ERU_EXISEL_EXS2A_Pos)                        /*!< ERU EXISEL: EXS2A Mask                  */
#define ERU_EXISEL_EXS2B_Pos                  10                                                      /*!< ERU EXISEL: EXS2B Position              */
#define ERU_EXISEL_EXS2B_Msk                  (0x03UL << ERU_EXISEL_EXS2B_Pos)                        /*!< ERU EXISEL: EXS2B Mask                  */
#define ERU_EXISEL_EXS3A_Pos                  12                                                      /*!< ERU EXISEL: EXS3A Position              */
#define ERU_EXISEL_EXS3A_Msk                  (0x03UL << ERU_EXISEL_EXS3A_Pos)                        /*!< ERU EXISEL: EXS3A Mask                  */
#define ERU_EXISEL_EXS3B_Pos                  14                                                      /*!< ERU EXISEL: EXS3B Position              */
#define ERU_EXISEL_EXS3B_Msk                  (0x03UL << ERU_EXISEL_EXS3B_Pos)                        /*!< ERU EXISEL: EXS3B Mask                  */

/* ---------------------------------  ERU_EXICON  --------------------------------- */
#define ERU_EXICON_PE_Pos                     0                                                       /*!< ERU EXICON: PE Position                 */
#define ERU_EXICON_PE_Msk                     (0x01UL << ERU_EXICON_PE_Pos)                           /*!< ERU EXICON: PE Mask                     */
#define ERU_EXICON_LD_Pos                     1                                                       /*!< ERU EXICON: LD Position                 */
#define ERU_EXICON_LD_Msk                     (0x01UL << ERU_EXICON_LD_Pos)                           /*!< ERU EXICON: LD Mask                     */
#define ERU_EXICON_RE_Pos                     2                                                       /*!< ERU EXICON: RE Position                 */
#define ERU_EXICON_RE_Msk                     (0x01UL << ERU_EXICON_RE_Pos)                           /*!< ERU EXICON: RE Mask                     */
#define ERU_EXICON_FE_Pos                     3                                                       /*!< ERU EXICON: FE Position                 */
#define ERU_EXICON_FE_Msk                     (0x01UL << ERU_EXICON_FE_Pos)                           /*!< ERU EXICON: FE Mask                     */
#define ERU_EXICON_OCS_Pos                    4                                                       /*!< ERU EXICON: OCS Position                */
#define ERU_EXICON_OCS_Msk                    (0x07UL << ERU_EXICON_OCS_Pos)                          /*!< ERU EXICON: OCS Mask                    */
#define ERU_EXICON_FL_Pos                     7                                                       /*!< ERU EXICON: FL Position                 */
#define ERU_EXICON_FL_Msk                     (0x01UL << ERU_EXICON_FL_Pos)                           /*!< ERU EXICON: FL Mask                     */
#define ERU_EXICON_SS_Pos                     8                                                       /*!< ERU EXICON: SS Position                 */
#define ERU_EXICON_SS_Msk                     (0x03UL << ERU_EXICON_SS_Pos)                           /*!< ERU EXICON: SS Mask                     */
#define ERU_EXICON_NA_Pos                     10                                                      /*!< ERU EXICON: NA Position                 */
#define ERU_EXICON_NA_Msk                     (0x01UL << ERU_EXICON_NA_Pos)                           /*!< ERU EXICON: NA Mask                     */
#define ERU_EXICON_NB_Pos                     11                                                      /*!< ERU EXICON: NB Position                 */
#define ERU_EXICON_NB_Msk                     (0x01UL << ERU_EXICON_NB_Pos)                           /*!< ERU EXICON: NB Mask                     */

/* ---------------------------------  ERU_EXOCON  --------------------------------- */
#define ERU_EXOCON_ISS_Pos                    0                                                       /*!< ERU EXOCON: ISS Position                */
#define ERU_EXOCON_ISS_Msk                    (0x03UL << ERU_EXOCON_ISS_Pos)                          /*!< ERU EXOCON: ISS Mask                    */
#define ERU_EXOCON_GEEN_Pos                   2                                                       /*!< ERU EXOCON: GEEN Position               */
#define ERU_EXOCON_GEEN_Msk                   (0x01UL << ERU_EXOCON_GEEN_Pos)                         /*!< ERU EXOCON: GEEN Mask                   */
#define ERU_EXOCON_PDR_Pos                    3                                                       /*!< ERU EXOCON: PDR Position                */
#define ERU_EXOCON_PDR_Msk                    (0x01UL << ERU_EXOCON_PDR_Pos)                          /*!< ERU EXOCON: PDR Mask                    */
#define ERU_EXOCON_GP_Pos                     4                                                       /*!< ERU EXOCON: GP Position                 */
#define ERU_EXOCON_GP_Msk                     (0x03UL << ERU_EXOCON_GP_Pos)                           /*!< ERU EXOCON: GP Mask                     */
#define ERU_EXOCON_IPEN0_Pos                  12                                                      /*!< ERU EXOCON: IPEN0 Position              */
#define ERU_EXOCON_IPEN0_Msk                  (0x01UL << ERU_EXOCON_IPEN0_Pos)                        /*!< ERU EXOCON: IPEN0 Mask                  */
#define ERU_EXOCON_IPEN1_Pos                  13                                                      /*!< ERU EXOCON: IPEN1 Position              */
#define ERU_EXOCON_IPEN1_Msk                  (0x01UL << ERU_EXOCON_IPEN1_Pos)                        /*!< ERU EXOCON: IPEN1 Mask                  */
#define ERU_EXOCON_IPEN2_Pos                  14                                                      /*!< ERU EXOCON: IPEN2 Position              */
#define ERU_EXOCON_IPEN2_Msk                  (0x01UL << ERU_EXOCON_IPEN2_Pos)                        /*!< ERU EXOCON: IPEN2 Mask                  */
#define ERU_EXOCON_IPEN3_Pos                  15                                                      /*!< ERU EXOCON: IPEN3 Position              */
#define ERU_EXOCON_IPEN3_Msk                  (0x01UL << ERU_EXOCON_IPEN3_Pos)                        /*!< ERU EXOCON: IPEN3 Mask                  */


/* ================================================================================ */
/* ================         struct 'GPDMA0' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  GPDMA0_RAWTFR  ------------------------------- */
#define GPDMA0_RAWTFR_CH0_Pos                 0                                                       /*!< GPDMA0 RAWTFR: CH0 Position             */
#define GPDMA0_RAWTFR_CH0_Msk                 (0x01UL << GPDMA0_RAWTFR_CH0_Pos)                       /*!< GPDMA0 RAWTFR: CH0 Mask                 */
#define GPDMA0_RAWTFR_CH1_Pos                 1                                                       /*!< GPDMA0 RAWTFR: CH1 Position             */
#define GPDMA0_RAWTFR_CH1_Msk                 (0x01UL << GPDMA0_RAWTFR_CH1_Pos)                       /*!< GPDMA0 RAWTFR: CH1 Mask                 */
#define GPDMA0_RAWTFR_CH2_Pos                 2                                                       /*!< GPDMA0 RAWTFR: CH2 Position             */
#define GPDMA0_RAWTFR_CH2_Msk                 (0x01UL << GPDMA0_RAWTFR_CH2_Pos)                       /*!< GPDMA0 RAWTFR: CH2 Mask                 */
#define GPDMA0_RAWTFR_CH3_Pos                 3                                                       /*!< GPDMA0 RAWTFR: CH3 Position             */
#define GPDMA0_RAWTFR_CH3_Msk                 (0x01UL << GPDMA0_RAWTFR_CH3_Pos)                       /*!< GPDMA0 RAWTFR: CH3 Mask                 */
#define GPDMA0_RAWTFR_CH4_Pos                 4                                                       /*!< GPDMA0 RAWTFR: CH4 Position             */
#define GPDMA0_RAWTFR_CH4_Msk                 (0x01UL << GPDMA0_RAWTFR_CH4_Pos)                       /*!< GPDMA0 RAWTFR: CH4 Mask                 */
#define GPDMA0_RAWTFR_CH5_Pos                 5                                                       /*!< GPDMA0 RAWTFR: CH5 Position             */
#define GPDMA0_RAWTFR_CH5_Msk                 (0x01UL << GPDMA0_RAWTFR_CH5_Pos)                       /*!< GPDMA0 RAWTFR: CH5 Mask                 */
#define GPDMA0_RAWTFR_CH6_Pos                 6                                                       /*!< GPDMA0 RAWTFR: CH6 Position             */
#define GPDMA0_RAWTFR_CH6_Msk                 (0x01UL << GPDMA0_RAWTFR_CH6_Pos)                       /*!< GPDMA0 RAWTFR: CH6 Mask                 */
#define GPDMA0_RAWTFR_CH7_Pos                 7                                                       /*!< GPDMA0 RAWTFR: CH7 Position             */
#define GPDMA0_RAWTFR_CH7_Msk                 (0x01UL << GPDMA0_RAWTFR_CH7_Pos)                       /*!< GPDMA0 RAWTFR: CH7 Mask                 */

/* -------------------------------  GPDMA0_RAWBLOCK  ------------------------------ */
#define GPDMA0_RAWBLOCK_CH0_Pos               0                                                       /*!< GPDMA0 RAWBLOCK: CH0 Position           */
#define GPDMA0_RAWBLOCK_CH0_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH0_Pos)                     /*!< GPDMA0 RAWBLOCK: CH0 Mask               */
#define GPDMA0_RAWBLOCK_CH1_Pos               1                                                       /*!< GPDMA0 RAWBLOCK: CH1 Position           */
#define GPDMA0_RAWBLOCK_CH1_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH1_Pos)                     /*!< GPDMA0 RAWBLOCK: CH1 Mask               */
#define GPDMA0_RAWBLOCK_CH2_Pos               2                                                       /*!< GPDMA0 RAWBLOCK: CH2 Position           */
#define GPDMA0_RAWBLOCK_CH2_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH2_Pos)                     /*!< GPDMA0 RAWBLOCK: CH2 Mask               */
#define GPDMA0_RAWBLOCK_CH3_Pos               3                                                       /*!< GPDMA0 RAWBLOCK: CH3 Position           */
#define GPDMA0_RAWBLOCK_CH3_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH3_Pos)                     /*!< GPDMA0 RAWBLOCK: CH3 Mask               */
#define GPDMA0_RAWBLOCK_CH4_Pos               4                                                       /*!< GPDMA0 RAWBLOCK: CH4 Position           */
#define GPDMA0_RAWBLOCK_CH4_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH4_Pos)                     /*!< GPDMA0 RAWBLOCK: CH4 Mask               */
#define GPDMA0_RAWBLOCK_CH5_Pos               5                                                       /*!< GPDMA0 RAWBLOCK: CH5 Position           */
#define GPDMA0_RAWBLOCK_CH5_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH5_Pos)                     /*!< GPDMA0 RAWBLOCK: CH5 Mask               */
#define GPDMA0_RAWBLOCK_CH6_Pos               6                                                       /*!< GPDMA0 RAWBLOCK: CH6 Position           */
#define GPDMA0_RAWBLOCK_CH6_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH6_Pos)                     /*!< GPDMA0 RAWBLOCK: CH6 Mask               */
#define GPDMA0_RAWBLOCK_CH7_Pos               7                                                       /*!< GPDMA0 RAWBLOCK: CH7 Position           */
#define GPDMA0_RAWBLOCK_CH7_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH7_Pos)                     /*!< GPDMA0 RAWBLOCK: CH7 Mask               */

/* ------------------------------  GPDMA0_RAWSRCTRAN  ----------------------------- */
#define GPDMA0_RAWSRCTRAN_CH0_Pos             0                                                       /*!< GPDMA0 RAWSRCTRAN: CH0 Position         */
#define GPDMA0_RAWSRCTRAN_CH0_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH0_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH0 Mask             */
#define GPDMA0_RAWSRCTRAN_CH1_Pos             1                                                       /*!< GPDMA0 RAWSRCTRAN: CH1 Position         */
#define GPDMA0_RAWSRCTRAN_CH1_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH1_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH1 Mask             */
#define GPDMA0_RAWSRCTRAN_CH2_Pos             2                                                       /*!< GPDMA0 RAWSRCTRAN: CH2 Position         */
#define GPDMA0_RAWSRCTRAN_CH2_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH2_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH2 Mask             */
#define GPDMA0_RAWSRCTRAN_CH3_Pos             3                                                       /*!< GPDMA0 RAWSRCTRAN: CH3 Position         */
#define GPDMA0_RAWSRCTRAN_CH3_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH3_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH3 Mask             */
#define GPDMA0_RAWSRCTRAN_CH4_Pos             4                                                       /*!< GPDMA0 RAWSRCTRAN: CH4 Position         */
#define GPDMA0_RAWSRCTRAN_CH4_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH4_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH4 Mask             */
#define GPDMA0_RAWSRCTRAN_CH5_Pos             5                                                       /*!< GPDMA0 RAWSRCTRAN: CH5 Position         */
#define GPDMA0_RAWSRCTRAN_CH5_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH5_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH5 Mask             */
#define GPDMA0_RAWSRCTRAN_CH6_Pos             6                                                       /*!< GPDMA0 RAWSRCTRAN: CH6 Position         */
#define GPDMA0_RAWSRCTRAN_CH6_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH6_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH6 Mask             */
#define GPDMA0_RAWSRCTRAN_CH7_Pos             7                                                       /*!< GPDMA0 RAWSRCTRAN: CH7 Position         */
#define GPDMA0_RAWSRCTRAN_CH7_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH7_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH7 Mask             */

/* ------------------------------  GPDMA0_RAWDSTTRAN  ----------------------------- */
#define GPDMA0_RAWDSTTRAN_CH0_Pos             0                                                       /*!< GPDMA0 RAWDSTTRAN: CH0 Position         */
#define GPDMA0_RAWDSTTRAN_CH0_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH0_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH0 Mask             */
#define GPDMA0_RAWDSTTRAN_CH1_Pos             1                                                       /*!< GPDMA0 RAWDSTTRAN: CH1 Position         */
#define GPDMA0_RAWDSTTRAN_CH1_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH1_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH1 Mask             */
#define GPDMA0_RAWDSTTRAN_CH2_Pos             2                                                       /*!< GPDMA0 RAWDSTTRAN: CH2 Position         */
#define GPDMA0_RAWDSTTRAN_CH2_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH2_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH2 Mask             */
#define GPDMA0_RAWDSTTRAN_CH3_Pos             3                                                       /*!< GPDMA0 RAWDSTTRAN: CH3 Position         */
#define GPDMA0_RAWDSTTRAN_CH3_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH3_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH3 Mask             */
#define GPDMA0_RAWDSTTRAN_CH4_Pos             4                                                       /*!< GPDMA0 RAWDSTTRAN: CH4 Position         */
#define GPDMA0_RAWDSTTRAN_CH4_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH4_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH4 Mask             */
#define GPDMA0_RAWDSTTRAN_CH5_Pos             5                                                       /*!< GPDMA0 RAWDSTTRAN: CH5 Position         */
#define GPDMA0_RAWDSTTRAN_CH5_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH5_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH5 Mask             */
#define GPDMA0_RAWDSTTRAN_CH6_Pos             6                                                       /*!< GPDMA0 RAWDSTTRAN: CH6 Position         */
#define GPDMA0_RAWDSTTRAN_CH6_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH6_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH6 Mask             */
#define GPDMA0_RAWDSTTRAN_CH7_Pos             7                                                       /*!< GPDMA0 RAWDSTTRAN: CH7 Position         */
#define GPDMA0_RAWDSTTRAN_CH7_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH7_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH7 Mask             */

/* --------------------------------  GPDMA0_RAWERR  ------------------------------- */
#define GPDMA0_RAWERR_CH0_Pos                 0                                                       /*!< GPDMA0 RAWERR: CH0 Position             */
#define GPDMA0_RAWERR_CH0_Msk                 (0x01UL << GPDMA0_RAWERR_CH0_Pos)                       /*!< GPDMA0 RAWERR: CH0 Mask                 */
#define GPDMA0_RAWERR_CH1_Pos                 1                                                       /*!< GPDMA0 RAWERR: CH1 Position             */
#define GPDMA0_RAWERR_CH1_Msk                 (0x01UL << GPDMA0_RAWERR_CH1_Pos)                       /*!< GPDMA0 RAWERR: CH1 Mask                 */
#define GPDMA0_RAWERR_CH2_Pos                 2                                                       /*!< GPDMA0 RAWERR: CH2 Position             */
#define GPDMA0_RAWERR_CH2_Msk                 (0x01UL << GPDMA0_RAWERR_CH2_Pos)                       /*!< GPDMA0 RAWERR: CH2 Mask                 */
#define GPDMA0_RAWERR_CH3_Pos                 3                                                       /*!< GPDMA0 RAWERR: CH3 Position             */
#define GPDMA0_RAWERR_CH3_Msk                 (0x01UL << GPDMA0_RAWERR_CH3_Pos)                       /*!< GPDMA0 RAWERR: CH3 Mask                 */
#define GPDMA0_RAWERR_CH4_Pos                 4                                                       /*!< GPDMA0 RAWERR: CH4 Position             */
#define GPDMA0_RAWERR_CH4_Msk                 (0x01UL << GPDMA0_RAWERR_CH4_Pos)                       /*!< GPDMA0 RAWERR: CH4 Mask                 */
#define GPDMA0_RAWERR_CH5_Pos                 5                                                       /*!< GPDMA0 RAWERR: CH5 Position             */
#define GPDMA0_RAWERR_CH5_Msk                 (0x01UL << GPDMA0_RAWERR_CH5_Pos)                       /*!< GPDMA0 RAWERR: CH5 Mask                 */
#define GPDMA0_RAWERR_CH6_Pos                 6                                                       /*!< GPDMA0 RAWERR: CH6 Position             */
#define GPDMA0_RAWERR_CH6_Msk                 (0x01UL << GPDMA0_RAWERR_CH6_Pos)                       /*!< GPDMA0 RAWERR: CH6 Mask                 */
#define GPDMA0_RAWERR_CH7_Pos                 7                                                       /*!< GPDMA0 RAWERR: CH7 Position             */
#define GPDMA0_RAWERR_CH7_Msk                 (0x01UL << GPDMA0_RAWERR_CH7_Pos)                       /*!< GPDMA0 RAWERR: CH7 Mask                 */

/* ------------------------------  GPDMA0_STATUSTFR  ------------------------------ */
#define GPDMA0_STATUSTFR_CH0_Pos              0                                                       /*!< GPDMA0 STATUSTFR: CH0 Position          */
#define GPDMA0_STATUSTFR_CH0_Msk              (0x01UL << GPDMA0_STATUSTFR_CH0_Pos)                    /*!< GPDMA0 STATUSTFR: CH0 Mask              */
#define GPDMA0_STATUSTFR_CH1_Pos              1                                                       /*!< GPDMA0 STATUSTFR: CH1 Position          */
#define GPDMA0_STATUSTFR_CH1_Msk              (0x01UL << GPDMA0_STATUSTFR_CH1_Pos)                    /*!< GPDMA0 STATUSTFR: CH1 Mask              */
#define GPDMA0_STATUSTFR_CH2_Pos              2                                                       /*!< GPDMA0 STATUSTFR: CH2 Position          */
#define GPDMA0_STATUSTFR_CH2_Msk              (0x01UL << GPDMA0_STATUSTFR_CH2_Pos)                    /*!< GPDMA0 STATUSTFR: CH2 Mask              */
#define GPDMA0_STATUSTFR_CH3_Pos              3                                                       /*!< GPDMA0 STATUSTFR: CH3 Position          */
#define GPDMA0_STATUSTFR_CH3_Msk              (0x01UL << GPDMA0_STATUSTFR_CH3_Pos)                    /*!< GPDMA0 STATUSTFR: CH3 Mask              */
#define GPDMA0_STATUSTFR_CH4_Pos              4                                                       /*!< GPDMA0 STATUSTFR: CH4 Position          */
#define GPDMA0_STATUSTFR_CH4_Msk              (0x01UL << GPDMA0_STATUSTFR_CH4_Pos)                    /*!< GPDMA0 STATUSTFR: CH4 Mask              */
#define GPDMA0_STATUSTFR_CH5_Pos              5                                                       /*!< GPDMA0 STATUSTFR: CH5 Position          */
#define GPDMA0_STATUSTFR_CH5_Msk              (0x01UL << GPDMA0_STATUSTFR_CH5_Pos)                    /*!< GPDMA0 STATUSTFR: CH5 Mask              */
#define GPDMA0_STATUSTFR_CH6_Pos              6                                                       /*!< GPDMA0 STATUSTFR: CH6 Position          */
#define GPDMA0_STATUSTFR_CH6_Msk              (0x01UL << GPDMA0_STATUSTFR_CH6_Pos)                    /*!< GPDMA0 STATUSTFR: CH6 Mask              */
#define GPDMA0_STATUSTFR_CH7_Pos              7                                                       /*!< GPDMA0 STATUSTFR: CH7 Position          */
#define GPDMA0_STATUSTFR_CH7_Msk              (0x01UL << GPDMA0_STATUSTFR_CH7_Pos)                    /*!< GPDMA0 STATUSTFR: CH7 Mask              */

/* -----------------------------  GPDMA0_STATUSBLOCK  ----------------------------- */
#define GPDMA0_STATUSBLOCK_CH0_Pos            0                                                       /*!< GPDMA0 STATUSBLOCK: CH0 Position        */
#define GPDMA0_STATUSBLOCK_CH0_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH0_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH0 Mask            */
#define GPDMA0_STATUSBLOCK_CH1_Pos            1                                                       /*!< GPDMA0 STATUSBLOCK: CH1 Position        */
#define GPDMA0_STATUSBLOCK_CH1_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH1_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH1 Mask            */
#define GPDMA0_STATUSBLOCK_CH2_Pos            2                                                       /*!< GPDMA0 STATUSBLOCK: CH2 Position        */
#define GPDMA0_STATUSBLOCK_CH2_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH2_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH2 Mask            */
#define GPDMA0_STATUSBLOCK_CH3_Pos            3                                                       /*!< GPDMA0 STATUSBLOCK: CH3 Position        */
#define GPDMA0_STATUSBLOCK_CH3_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH3_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH3 Mask            */
#define GPDMA0_STATUSBLOCK_CH4_Pos            4                                                       /*!< GPDMA0 STATUSBLOCK: CH4 Position        */
#define GPDMA0_STATUSBLOCK_CH4_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH4_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH4 Mask            */
#define GPDMA0_STATUSBLOCK_CH5_Pos            5                                                       /*!< GPDMA0 STATUSBLOCK: CH5 Position        */
#define GPDMA0_STATUSBLOCK_CH5_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH5_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH5 Mask            */
#define GPDMA0_STATUSBLOCK_CH6_Pos            6                                                       /*!< GPDMA0 STATUSBLOCK: CH6 Position        */
#define GPDMA0_STATUSBLOCK_CH6_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH6_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH6 Mask            */
#define GPDMA0_STATUSBLOCK_CH7_Pos            7                                                       /*!< GPDMA0 STATUSBLOCK: CH7 Position        */
#define GPDMA0_STATUSBLOCK_CH7_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH7_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH7 Mask            */

/* ----------------------------  GPDMA0_STATUSSRCTRAN  ---------------------------- */
#define GPDMA0_STATUSSRCTRAN_CH0_Pos          0                                                       /*!< GPDMA0 STATUSSRCTRAN: CH0 Position      */
#define GPDMA0_STATUSSRCTRAN_CH0_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH0_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH0 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH1_Pos          1                                                       /*!< GPDMA0 STATUSSRCTRAN: CH1 Position      */
#define GPDMA0_STATUSSRCTRAN_CH1_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH1_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH1 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH2_Pos          2                                                       /*!< GPDMA0 STATUSSRCTRAN: CH2 Position      */
#define GPDMA0_STATUSSRCTRAN_CH2_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH2_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH2 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH3_Pos          3                                                       /*!< GPDMA0 STATUSSRCTRAN: CH3 Position      */
#define GPDMA0_STATUSSRCTRAN_CH3_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH3_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH3 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH4_Pos          4                                                       /*!< GPDMA0 STATUSSRCTRAN: CH4 Position      */
#define GPDMA0_STATUSSRCTRAN_CH4_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH4_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH4 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH5_Pos          5                                                       /*!< GPDMA0 STATUSSRCTRAN: CH5 Position      */
#define GPDMA0_STATUSSRCTRAN_CH5_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH5_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH5 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH6_Pos          6                                                       /*!< GPDMA0 STATUSSRCTRAN: CH6 Position      */
#define GPDMA0_STATUSSRCTRAN_CH6_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH6_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH6 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH7_Pos          7                                                       /*!< GPDMA0 STATUSSRCTRAN: CH7 Position      */
#define GPDMA0_STATUSSRCTRAN_CH7_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH7_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH7 Mask          */

/* ----------------------------  GPDMA0_STATUSDSTTRAN  ---------------------------- */
#define GPDMA0_STATUSDSTTRAN_CH0_Pos          0                                                       /*!< GPDMA0 STATUSDSTTRAN: CH0 Position      */
#define GPDMA0_STATUSDSTTRAN_CH0_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH0_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH0 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH1_Pos          1                                                       /*!< GPDMA0 STATUSDSTTRAN: CH1 Position      */
#define GPDMA0_STATUSDSTTRAN_CH1_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH1_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH1 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH2_Pos          2                                                       /*!< GPDMA0 STATUSDSTTRAN: CH2 Position      */
#define GPDMA0_STATUSDSTTRAN_CH2_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH2_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH2 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH3_Pos          3                                                       /*!< GPDMA0 STATUSDSTTRAN: CH3 Position      */
#define GPDMA0_STATUSDSTTRAN_CH3_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH3_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH3 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH4_Pos          4                                                       /*!< GPDMA0 STATUSDSTTRAN: CH4 Position      */
#define GPDMA0_STATUSDSTTRAN_CH4_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH4_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH4 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH5_Pos          5                                                       /*!< GPDMA0 STATUSDSTTRAN: CH5 Position      */
#define GPDMA0_STATUSDSTTRAN_CH5_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH5_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH5 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH6_Pos          6                                                       /*!< GPDMA0 STATUSDSTTRAN: CH6 Position      */
#define GPDMA0_STATUSDSTTRAN_CH6_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH6_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH6 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH7_Pos          7                                                       /*!< GPDMA0 STATUSDSTTRAN: CH7 Position      */
#define GPDMA0_STATUSDSTTRAN_CH7_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH7_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH7 Mask          */

/* ------------------------------  GPDMA0_STATUSERR  ------------------------------ */
#define GPDMA0_STATUSERR_CH0_Pos              0                                                       /*!< GPDMA0 STATUSERR: CH0 Position          */
#define GPDMA0_STATUSERR_CH0_Msk              (0x01UL << GPDMA0_STATUSERR_CH0_Pos)                    /*!< GPDMA0 STATUSERR: CH0 Mask              */
#define GPDMA0_STATUSERR_CH1_Pos              1                                                       /*!< GPDMA0 STATUSERR: CH1 Position          */
#define GPDMA0_STATUSERR_CH1_Msk              (0x01UL << GPDMA0_STATUSERR_CH1_Pos)                    /*!< GPDMA0 STATUSERR: CH1 Mask              */
#define GPDMA0_STATUSERR_CH2_Pos              2                                                       /*!< GPDMA0 STATUSERR: CH2 Position          */
#define GPDMA0_STATUSERR_CH2_Msk              (0x01UL << GPDMA0_STATUSERR_CH2_Pos)                    /*!< GPDMA0 STATUSERR: CH2 Mask              */
#define GPDMA0_STATUSERR_CH3_Pos              3                                                       /*!< GPDMA0 STATUSERR: CH3 Position          */
#define GPDMA0_STATUSERR_CH3_Msk              (0x01UL << GPDMA0_STATUSERR_CH3_Pos)                    /*!< GPDMA0 STATUSERR: CH3 Mask              */
#define GPDMA0_STATUSERR_CH4_Pos              4                                                       /*!< GPDMA0 STATUSERR: CH4 Position          */
#define GPDMA0_STATUSERR_CH4_Msk              (0x01UL << GPDMA0_STATUSERR_CH4_Pos)                    /*!< GPDMA0 STATUSERR: CH4 Mask              */
#define GPDMA0_STATUSERR_CH5_Pos              5                                                       /*!< GPDMA0 STATUSERR: CH5 Position          */
#define GPDMA0_STATUSERR_CH5_Msk              (0x01UL << GPDMA0_STATUSERR_CH5_Pos)                    /*!< GPDMA0 STATUSERR: CH5 Mask              */
#define GPDMA0_STATUSERR_CH6_Pos              6                                                       /*!< GPDMA0 STATUSERR: CH6 Position          */
#define GPDMA0_STATUSERR_CH6_Msk              (0x01UL << GPDMA0_STATUSERR_CH6_Pos)                    /*!< GPDMA0 STATUSERR: CH6 Mask              */
#define GPDMA0_STATUSERR_CH7_Pos              7                                                       /*!< GPDMA0 STATUSERR: CH7 Position          */
#define GPDMA0_STATUSERR_CH7_Msk              (0x01UL << GPDMA0_STATUSERR_CH7_Pos)                    /*!< GPDMA0 STATUSERR: CH7 Mask              */

/* -------------------------------  GPDMA0_MASKTFR  ------------------------------- */
#define GPDMA0_MASKTFR_CH0_Pos                0                                                       /*!< GPDMA0 MASKTFR: CH0 Position            */
#define GPDMA0_MASKTFR_CH0_Msk                (0x01UL << GPDMA0_MASKTFR_CH0_Pos)                      /*!< GPDMA0 MASKTFR: CH0 Mask                */
#define GPDMA0_MASKTFR_CH1_Pos                1                                                       /*!< GPDMA0 MASKTFR: CH1 Position            */
#define GPDMA0_MASKTFR_CH1_Msk                (0x01UL << GPDMA0_MASKTFR_CH1_Pos)                      /*!< GPDMA0 MASKTFR: CH1 Mask                */
#define GPDMA0_MASKTFR_CH2_Pos                2                                                       /*!< GPDMA0 MASKTFR: CH2 Position            */
#define GPDMA0_MASKTFR_CH2_Msk                (0x01UL << GPDMA0_MASKTFR_CH2_Pos)                      /*!< GPDMA0 MASKTFR: CH2 Mask                */
#define GPDMA0_MASKTFR_CH3_Pos                3                                                       /*!< GPDMA0 MASKTFR: CH3 Position            */
#define GPDMA0_MASKTFR_CH3_Msk                (0x01UL << GPDMA0_MASKTFR_CH3_Pos)                      /*!< GPDMA0 MASKTFR: CH3 Mask                */
#define GPDMA0_MASKTFR_CH4_Pos                4                                                       /*!< GPDMA0 MASKTFR: CH4 Position            */
#define GPDMA0_MASKTFR_CH4_Msk                (0x01UL << GPDMA0_MASKTFR_CH4_Pos)                      /*!< GPDMA0 MASKTFR: CH4 Mask                */
#define GPDMA0_MASKTFR_CH5_Pos                5                                                       /*!< GPDMA0 MASKTFR: CH5 Position            */
#define GPDMA0_MASKTFR_CH5_Msk                (0x01UL << GPDMA0_MASKTFR_CH5_Pos)                      /*!< GPDMA0 MASKTFR: CH5 Mask                */
#define GPDMA0_MASKTFR_CH6_Pos                6                                                       /*!< GPDMA0 MASKTFR: CH6 Position            */
#define GPDMA0_MASKTFR_CH6_Msk                (0x01UL << GPDMA0_MASKTFR_CH6_Pos)                      /*!< GPDMA0 MASKTFR: CH6 Mask                */
#define GPDMA0_MASKTFR_CH7_Pos                7                                                       /*!< GPDMA0 MASKTFR: CH7 Position            */
#define GPDMA0_MASKTFR_CH7_Msk                (0x01UL << GPDMA0_MASKTFR_CH7_Pos)                      /*!< GPDMA0 MASKTFR: CH7 Mask                */
#define GPDMA0_MASKTFR_WE_CH0_Pos             8                                                       /*!< GPDMA0 MASKTFR: WE_CH0 Position         */
#define GPDMA0_MASKTFR_WE_CH0_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH0_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH0 Mask             */
#define GPDMA0_MASKTFR_WE_CH1_Pos             9                                                       /*!< GPDMA0 MASKTFR: WE_CH1 Position         */
#define GPDMA0_MASKTFR_WE_CH1_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH1_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH1 Mask             */
#define GPDMA0_MASKTFR_WE_CH2_Pos             10                                                      /*!< GPDMA0 MASKTFR: WE_CH2 Position         */
#define GPDMA0_MASKTFR_WE_CH2_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH2_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH2 Mask             */
#define GPDMA0_MASKTFR_WE_CH3_Pos             11                                                      /*!< GPDMA0 MASKTFR: WE_CH3 Position         */
#define GPDMA0_MASKTFR_WE_CH3_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH3_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH3 Mask             */
#define GPDMA0_MASKTFR_WE_CH4_Pos             12                                                      /*!< GPDMA0 MASKTFR: WE_CH4 Position         */
#define GPDMA0_MASKTFR_WE_CH4_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH4_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH4 Mask             */
#define GPDMA0_MASKTFR_WE_CH5_Pos             13                                                      /*!< GPDMA0 MASKTFR: WE_CH5 Position         */
#define GPDMA0_MASKTFR_WE_CH5_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH5_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH5 Mask             */
#define GPDMA0_MASKTFR_WE_CH6_Pos             14                                                      /*!< GPDMA0 MASKTFR: WE_CH6 Position         */
#define GPDMA0_MASKTFR_WE_CH6_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH6_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH6 Mask             */
#define GPDMA0_MASKTFR_WE_CH7_Pos             15                                                      /*!< GPDMA0 MASKTFR: WE_CH7 Position         */
#define GPDMA0_MASKTFR_WE_CH7_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH7_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH7 Mask             */

/* ------------------------------  GPDMA0_MASKBLOCK  ------------------------------ */
#define GPDMA0_MASKBLOCK_CH0_Pos              0                                                       /*!< GPDMA0 MASKBLOCK: CH0 Position          */
#define GPDMA0_MASKBLOCK_CH0_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH0_Pos)                    /*!< GPDMA0 MASKBLOCK: CH0 Mask              */
#define GPDMA0_MASKBLOCK_CH1_Pos              1                                                       /*!< GPDMA0 MASKBLOCK: CH1 Position          */
#define GPDMA0_MASKBLOCK_CH1_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH1_Pos)                    /*!< GPDMA0 MASKBLOCK: CH1 Mask              */
#define GPDMA0_MASKBLOCK_CH2_Pos              2                                                       /*!< GPDMA0 MASKBLOCK: CH2 Position          */
#define GPDMA0_MASKBLOCK_CH2_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH2_Pos)                    /*!< GPDMA0 MASKBLOCK: CH2 Mask              */
#define GPDMA0_MASKBLOCK_CH3_Pos              3                                                       /*!< GPDMA0 MASKBLOCK: CH3 Position          */
#define GPDMA0_MASKBLOCK_CH3_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH3_Pos)                    /*!< GPDMA0 MASKBLOCK: CH3 Mask              */
#define GPDMA0_MASKBLOCK_CH4_Pos              4                                                       /*!< GPDMA0 MASKBLOCK: CH4 Position          */
#define GPDMA0_MASKBLOCK_CH4_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH4_Pos)                    /*!< GPDMA0 MASKBLOCK: CH4 Mask              */
#define GPDMA0_MASKBLOCK_CH5_Pos              5                                                       /*!< GPDMA0 MASKBLOCK: CH5 Position          */
#define GPDMA0_MASKBLOCK_CH5_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH5_Pos)                    /*!< GPDMA0 MASKBLOCK: CH5 Mask              */
#define GPDMA0_MASKBLOCK_CH6_Pos              6                                                       /*!< GPDMA0 MASKBLOCK: CH6 Position          */
#define GPDMA0_MASKBLOCK_CH6_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH6_Pos)                    /*!< GPDMA0 MASKBLOCK: CH6 Mask              */
#define GPDMA0_MASKBLOCK_CH7_Pos              7                                                       /*!< GPDMA0 MASKBLOCK: CH7 Position          */
#define GPDMA0_MASKBLOCK_CH7_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH7_Pos)                    /*!< GPDMA0 MASKBLOCK: CH7 Mask              */
#define GPDMA0_MASKBLOCK_WE_CH0_Pos           8                                                       /*!< GPDMA0 MASKBLOCK: WE_CH0 Position       */
#define GPDMA0_MASKBLOCK_WE_CH0_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH0_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH0 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH1_Pos           9                                                       /*!< GPDMA0 MASKBLOCK: WE_CH1 Position       */
#define GPDMA0_MASKBLOCK_WE_CH1_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH1_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH1 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH2_Pos           10                                                      /*!< GPDMA0 MASKBLOCK: WE_CH2 Position       */
#define GPDMA0_MASKBLOCK_WE_CH2_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH2_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH2 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH3_Pos           11                                                      /*!< GPDMA0 MASKBLOCK: WE_CH3 Position       */
#define GPDMA0_MASKBLOCK_WE_CH3_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH3_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH3 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH4_Pos           12                                                      /*!< GPDMA0 MASKBLOCK: WE_CH4 Position       */
#define GPDMA0_MASKBLOCK_WE_CH4_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH4_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH4 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH5_Pos           13                                                      /*!< GPDMA0 MASKBLOCK: WE_CH5 Position       */
#define GPDMA0_MASKBLOCK_WE_CH5_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH5_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH5 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH6_Pos           14                                                      /*!< GPDMA0 MASKBLOCK: WE_CH6 Position       */
#define GPDMA0_MASKBLOCK_WE_CH6_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH6_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH6 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH7_Pos           15                                                      /*!< GPDMA0 MASKBLOCK: WE_CH7 Position       */
#define GPDMA0_MASKBLOCK_WE_CH7_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH7_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH7 Mask           */

/* -----------------------------  GPDMA0_MASKSRCTRAN  ----------------------------- */
#define GPDMA0_MASKSRCTRAN_CH0_Pos            0                                                       /*!< GPDMA0 MASKSRCTRAN: CH0 Position        */
#define GPDMA0_MASKSRCTRAN_CH0_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH0_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH0 Mask            */
#define GPDMA0_MASKSRCTRAN_CH1_Pos            1                                                       /*!< GPDMA0 MASKSRCTRAN: CH1 Position        */
#define GPDMA0_MASKSRCTRAN_CH1_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH1_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH1 Mask            */
#define GPDMA0_MASKSRCTRAN_CH2_Pos            2                                                       /*!< GPDMA0 MASKSRCTRAN: CH2 Position        */
#define GPDMA0_MASKSRCTRAN_CH2_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH2_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH2 Mask            */
#define GPDMA0_MASKSRCTRAN_CH3_Pos            3                                                       /*!< GPDMA0 MASKSRCTRAN: CH3 Position        */
#define GPDMA0_MASKSRCTRAN_CH3_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH3_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH3 Mask            */
#define GPDMA0_MASKSRCTRAN_CH4_Pos            4                                                       /*!< GPDMA0 MASKSRCTRAN: CH4 Position        */
#define GPDMA0_MASKSRCTRAN_CH4_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH4_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH4 Mask            */
#define GPDMA0_MASKSRCTRAN_CH5_Pos            5                                                       /*!< GPDMA0 MASKSRCTRAN: CH5 Position        */
#define GPDMA0_MASKSRCTRAN_CH5_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH5_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH5 Mask            */
#define GPDMA0_MASKSRCTRAN_CH6_Pos            6                                                       /*!< GPDMA0 MASKSRCTRAN: CH6 Position        */
#define GPDMA0_MASKSRCTRAN_CH6_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH6_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH6 Mask            */
#define GPDMA0_MASKSRCTRAN_CH7_Pos            7                                                       /*!< GPDMA0 MASKSRCTRAN: CH7 Position        */
#define GPDMA0_MASKSRCTRAN_CH7_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH7_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH7 Mask            */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Pos         8                                                       /*!< GPDMA0 MASKSRCTRAN: WE_CH0 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH0_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH0 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Pos         9                                                       /*!< GPDMA0 MASKSRCTRAN: WE_CH1 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH1_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH1 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Pos         10                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH2 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH2_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH2 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Pos         11                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH3 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH3_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH3 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Pos         12                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH4 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH4_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH4 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Pos         13                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH5 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH5_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH5 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Pos         14                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH6 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH6_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH6 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Pos         15                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH7 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH7_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH7 Mask         */

/* -----------------------------  GPDMA0_MASKDSTTRAN  ----------------------------- */
#define GPDMA0_MASKDSTTRAN_CH0_Pos            0                                                       /*!< GPDMA0 MASKDSTTRAN: CH0 Position        */
#define GPDMA0_MASKDSTTRAN_CH0_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH0_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH0 Mask            */
#define GPDMA0_MASKDSTTRAN_CH1_Pos            1                                                       /*!< GPDMA0 MASKDSTTRAN: CH1 Position        */
#define GPDMA0_MASKDSTTRAN_CH1_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH1_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH1 Mask            */
#define GPDMA0_MASKDSTTRAN_CH2_Pos            2                                                       /*!< GPDMA0 MASKDSTTRAN: CH2 Position        */
#define GPDMA0_MASKDSTTRAN_CH2_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH2_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH2 Mask            */
#define GPDMA0_MASKDSTTRAN_CH3_Pos            3                                                       /*!< GPDMA0 MASKDSTTRAN: CH3 Position        */
#define GPDMA0_MASKDSTTRAN_CH3_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH3_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH3 Mask            */
#define GPDMA0_MASKDSTTRAN_CH4_Pos            4                                                       /*!< GPDMA0 MASKDSTTRAN: CH4 Position        */
#define GPDMA0_MASKDSTTRAN_CH4_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH4_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH4 Mask            */
#define GPDMA0_MASKDSTTRAN_CH5_Pos            5                                                       /*!< GPDMA0 MASKDSTTRAN: CH5 Position        */
#define GPDMA0_MASKDSTTRAN_CH5_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH5_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH5 Mask            */
#define GPDMA0_MASKDSTTRAN_CH6_Pos            6                                                       /*!< GPDMA0 MASKDSTTRAN: CH6 Position        */
#define GPDMA0_MASKDSTTRAN_CH6_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH6_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH6 Mask            */
#define GPDMA0_MASKDSTTRAN_CH7_Pos            7                                                       /*!< GPDMA0 MASKDSTTRAN: CH7 Position        */
#define GPDMA0_MASKDSTTRAN_CH7_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH7_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH7 Mask            */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Pos         8                                                       /*!< GPDMA0 MASKDSTTRAN: WE_CH0 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH0_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH0 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Pos         9                                                       /*!< GPDMA0 MASKDSTTRAN: WE_CH1 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH1_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH1 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Pos         10                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH2 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH2_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH2 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Pos         11                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH3 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH3_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH3 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Pos         12                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH4 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH4_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH4 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Pos         13                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH5 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH5_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH5 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Pos         14                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH6 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH6_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH6 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Pos         15                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH7 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH7_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH7 Mask         */

/* -------------------------------  GPDMA0_MASKERR  ------------------------------- */
#define GPDMA0_MASKERR_CH0_Pos                0                                                       /*!< GPDMA0 MASKERR: CH0 Position            */
#define GPDMA0_MASKERR_CH0_Msk                (0x01UL << GPDMA0_MASKERR_CH0_Pos)                      /*!< GPDMA0 MASKERR: CH0 Mask                */
#define GPDMA0_MASKERR_CH1_Pos                1                                                       /*!< GPDMA0 MASKERR: CH1 Position            */
#define GPDMA0_MASKERR_CH1_Msk                (0x01UL << GPDMA0_MASKERR_CH1_Pos)                      /*!< GPDMA0 MASKERR: CH1 Mask                */
#define GPDMA0_MASKERR_CH2_Pos                2                                                       /*!< GPDMA0 MASKERR: CH2 Position            */
#define GPDMA0_MASKERR_CH2_Msk                (0x01UL << GPDMA0_MASKERR_CH2_Pos)                      /*!< GPDMA0 MASKERR: CH2 Mask                */
#define GPDMA0_MASKERR_CH3_Pos                3                                                       /*!< GPDMA0 MASKERR: CH3 Position            */
#define GPDMA0_MASKERR_CH3_Msk                (0x01UL << GPDMA0_MASKERR_CH3_Pos)                      /*!< GPDMA0 MASKERR: CH3 Mask                */
#define GPDMA0_MASKERR_CH4_Pos                4                                                       /*!< GPDMA0 MASKERR: CH4 Position            */
#define GPDMA0_MASKERR_CH4_Msk                (0x01UL << GPDMA0_MASKERR_CH4_Pos)                      /*!< GPDMA0 MASKERR: CH4 Mask                */
#define GPDMA0_MASKERR_CH5_Pos                5                                                       /*!< GPDMA0 MASKERR: CH5 Position            */
#define GPDMA0_MASKERR_CH5_Msk                (0x01UL << GPDMA0_MASKERR_CH5_Pos)                      /*!< GPDMA0 MASKERR: CH5 Mask                */
#define GPDMA0_MASKERR_CH6_Pos                6                                                       /*!< GPDMA0 MASKERR: CH6 Position            */
#define GPDMA0_MASKERR_CH6_Msk                (0x01UL << GPDMA0_MASKERR_CH6_Pos)                      /*!< GPDMA0 MASKERR: CH6 Mask                */
#define GPDMA0_MASKERR_CH7_Pos                7                                                       /*!< GPDMA0 MASKERR: CH7 Position            */
#define GPDMA0_MASKERR_CH7_Msk                (0x01UL << GPDMA0_MASKERR_CH7_Pos)                      /*!< GPDMA0 MASKERR: CH7 Mask                */
#define GPDMA0_MASKERR_WE_CH0_Pos             8                                                       /*!< GPDMA0 MASKERR: WE_CH0 Position         */
#define GPDMA0_MASKERR_WE_CH0_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH0_Pos)                   /*!< GPDMA0 MASKERR: WE_CH0 Mask             */
#define GPDMA0_MASKERR_WE_CH1_Pos             9                                                       /*!< GPDMA0 MASKERR: WE_CH1 Position         */
#define GPDMA0_MASKERR_WE_CH1_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH1_Pos)                   /*!< GPDMA0 MASKERR: WE_CH1 Mask             */
#define GPDMA0_MASKERR_WE_CH2_Pos             10                                                      /*!< GPDMA0 MASKERR: WE_CH2 Position         */
#define GPDMA0_MASKERR_WE_CH2_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH2_Pos)                   /*!< GPDMA0 MASKERR: WE_CH2 Mask             */
#define GPDMA0_MASKERR_WE_CH3_Pos             11                                                      /*!< GPDMA0 MASKERR: WE_CH3 Position         */
#define GPDMA0_MASKERR_WE_CH3_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH3_Pos)                   /*!< GPDMA0 MASKERR: WE_CH3 Mask             */
#define GPDMA0_MASKERR_WE_CH4_Pos             12                                                      /*!< GPDMA0 MASKERR: WE_CH4 Position         */
#define GPDMA0_MASKERR_WE_CH4_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH4_Pos)                   /*!< GPDMA0 MASKERR: WE_CH4 Mask             */
#define GPDMA0_MASKERR_WE_CH5_Pos             13                                                      /*!< GPDMA0 MASKERR: WE_CH5 Position         */
#define GPDMA0_MASKERR_WE_CH5_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH5_Pos)                   /*!< GPDMA0 MASKERR: WE_CH5 Mask             */
#define GPDMA0_MASKERR_WE_CH6_Pos             14                                                      /*!< GPDMA0 MASKERR: WE_CH6 Position         */
#define GPDMA0_MASKERR_WE_CH6_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH6_Pos)                   /*!< GPDMA0 MASKERR: WE_CH6 Mask             */
#define GPDMA0_MASKERR_WE_CH7_Pos             15                                                      /*!< GPDMA0 MASKERR: WE_CH7 Position         */
#define GPDMA0_MASKERR_WE_CH7_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH7_Pos)                   /*!< GPDMA0 MASKERR: WE_CH7 Mask             */

/* -------------------------------  GPDMA0_CLEARTFR  ------------------------------ */
#define GPDMA0_CLEARTFR_CH0_Pos               0                                                       /*!< GPDMA0 CLEARTFR: CH0 Position           */
#define GPDMA0_CLEARTFR_CH0_Msk               (0x01UL << GPDMA0_CLEARTFR_CH0_Pos)                     /*!< GPDMA0 CLEARTFR: CH0 Mask               */
#define GPDMA0_CLEARTFR_CH1_Pos               1                                                       /*!< GPDMA0 CLEARTFR: CH1 Position           */
#define GPDMA0_CLEARTFR_CH1_Msk               (0x01UL << GPDMA0_CLEARTFR_CH1_Pos)                     /*!< GPDMA0 CLEARTFR: CH1 Mask               */
#define GPDMA0_CLEARTFR_CH2_Pos               2                                                       /*!< GPDMA0 CLEARTFR: CH2 Position           */
#define GPDMA0_CLEARTFR_CH2_Msk               (0x01UL << GPDMA0_CLEARTFR_CH2_Pos)                     /*!< GPDMA0 CLEARTFR: CH2 Mask               */
#define GPDMA0_CLEARTFR_CH3_Pos               3                                                       /*!< GPDMA0 CLEARTFR: CH3 Position           */
#define GPDMA0_CLEARTFR_CH3_Msk               (0x01UL << GPDMA0_CLEARTFR_CH3_Pos)                     /*!< GPDMA0 CLEARTFR: CH3 Mask               */
#define GPDMA0_CLEARTFR_CH4_Pos               4                                                       /*!< GPDMA0 CLEARTFR: CH4 Position           */
#define GPDMA0_CLEARTFR_CH4_Msk               (0x01UL << GPDMA0_CLEARTFR_CH4_Pos)                     /*!< GPDMA0 CLEARTFR: CH4 Mask               */
#define GPDMA0_CLEARTFR_CH5_Pos               5                                                       /*!< GPDMA0 CLEARTFR: CH5 Position           */
#define GPDMA0_CLEARTFR_CH5_Msk               (0x01UL << GPDMA0_CLEARTFR_CH5_Pos)                     /*!< GPDMA0 CLEARTFR: CH5 Mask               */
#define GPDMA0_CLEARTFR_CH6_Pos               6                                                       /*!< GPDMA0 CLEARTFR: CH6 Position           */
#define GPDMA0_CLEARTFR_CH6_Msk               (0x01UL << GPDMA0_CLEARTFR_CH6_Pos)                     /*!< GPDMA0 CLEARTFR: CH6 Mask               */
#define GPDMA0_CLEARTFR_CH7_Pos               7                                                       /*!< GPDMA0 CLEARTFR: CH7 Position           */
#define GPDMA0_CLEARTFR_CH7_Msk               (0x01UL << GPDMA0_CLEARTFR_CH7_Pos)                     /*!< GPDMA0 CLEARTFR: CH7 Mask               */

/* ------------------------------  GPDMA0_CLEARBLOCK  ----------------------------- */
#define GPDMA0_CLEARBLOCK_CH0_Pos             0                                                       /*!< GPDMA0 CLEARBLOCK: CH0 Position         */
#define GPDMA0_CLEARBLOCK_CH0_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH0_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH0 Mask             */
#define GPDMA0_CLEARBLOCK_CH1_Pos             1                                                       /*!< GPDMA0 CLEARBLOCK: CH1 Position         */
#define GPDMA0_CLEARBLOCK_CH1_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH1_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH1 Mask             */
#define GPDMA0_CLEARBLOCK_CH2_Pos             2                                                       /*!< GPDMA0 CLEARBLOCK: CH2 Position         */
#define GPDMA0_CLEARBLOCK_CH2_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH2_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH2 Mask             */
#define GPDMA0_CLEARBLOCK_CH3_Pos             3                                                       /*!< GPDMA0 CLEARBLOCK: CH3 Position         */
#define GPDMA0_CLEARBLOCK_CH3_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH3_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH3 Mask             */
#define GPDMA0_CLEARBLOCK_CH4_Pos             4                                                       /*!< GPDMA0 CLEARBLOCK: CH4 Position         */
#define GPDMA0_CLEARBLOCK_CH4_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH4_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH4 Mask             */
#define GPDMA0_CLEARBLOCK_CH5_Pos             5                                                       /*!< GPDMA0 CLEARBLOCK: CH5 Position         */
#define GPDMA0_CLEARBLOCK_CH5_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH5_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH5 Mask             */
#define GPDMA0_CLEARBLOCK_CH6_Pos             6                                                       /*!< GPDMA0 CLEARBLOCK: CH6 Position         */
#define GPDMA0_CLEARBLOCK_CH6_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH6_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH6 Mask             */
#define GPDMA0_CLEARBLOCK_CH7_Pos             7                                                       /*!< GPDMA0 CLEARBLOCK: CH7 Position         */
#define GPDMA0_CLEARBLOCK_CH7_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH7_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH7 Mask             */

/* -----------------------------  GPDMA0_CLEARSRCTRAN  ---------------------------- */
#define GPDMA0_CLEARSRCTRAN_CH0_Pos           0                                                       /*!< GPDMA0 CLEARSRCTRAN: CH0 Position       */
#define GPDMA0_CLEARSRCTRAN_CH0_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH0_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH0 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH1_Pos           1                                                       /*!< GPDMA0 CLEARSRCTRAN: CH1 Position       */
#define GPDMA0_CLEARSRCTRAN_CH1_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH1_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH1 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH2_Pos           2                                                       /*!< GPDMA0 CLEARSRCTRAN: CH2 Position       */
#define GPDMA0_CLEARSRCTRAN_CH2_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH2_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH2 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH3_Pos           3                                                       /*!< GPDMA0 CLEARSRCTRAN: CH3 Position       */
#define GPDMA0_CLEARSRCTRAN_CH3_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH3_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH3 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH4_Pos           4                                                       /*!< GPDMA0 CLEARSRCTRAN: CH4 Position       */
#define GPDMA0_CLEARSRCTRAN_CH4_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH4_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH4 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH5_Pos           5                                                       /*!< GPDMA0 CLEARSRCTRAN: CH5 Position       */
#define GPDMA0_CLEARSRCTRAN_CH5_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH5_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH5 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH6_Pos           6                                                       /*!< GPDMA0 CLEARSRCTRAN: CH6 Position       */
#define GPDMA0_CLEARSRCTRAN_CH6_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH6_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH6 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH7_Pos           7                                                       /*!< GPDMA0 CLEARSRCTRAN: CH7 Position       */
#define GPDMA0_CLEARSRCTRAN_CH7_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH7_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH7 Mask           */

/* -----------------------------  GPDMA0_CLEARDSTTRAN  ---------------------------- */
#define GPDMA0_CLEARDSTTRAN_CH0_Pos           0                                                       /*!< GPDMA0 CLEARDSTTRAN: CH0 Position       */
#define GPDMA0_CLEARDSTTRAN_CH0_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH0_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH0 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH1_Pos           1                                                       /*!< GPDMA0 CLEARDSTTRAN: CH1 Position       */
#define GPDMA0_CLEARDSTTRAN_CH1_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH1_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH1 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH2_Pos           2                                                       /*!< GPDMA0 CLEARDSTTRAN: CH2 Position       */
#define GPDMA0_CLEARDSTTRAN_CH2_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH2_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH2 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH3_Pos           3                                                       /*!< GPDMA0 CLEARDSTTRAN: CH3 Position       */
#define GPDMA0_CLEARDSTTRAN_CH3_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH3_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH3 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH4_Pos           4                                                       /*!< GPDMA0 CLEARDSTTRAN: CH4 Position       */
#define GPDMA0_CLEARDSTTRAN_CH4_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH4_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH4 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH5_Pos           5                                                       /*!< GPDMA0 CLEARDSTTRAN: CH5 Position       */
#define GPDMA0_CLEARDSTTRAN_CH5_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH5_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH5 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH6_Pos           6                                                       /*!< GPDMA0 CLEARDSTTRAN: CH6 Position       */
#define GPDMA0_CLEARDSTTRAN_CH6_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH6_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH6 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH7_Pos           7                                                       /*!< GPDMA0 CLEARDSTTRAN: CH7 Position       */
#define GPDMA0_CLEARDSTTRAN_CH7_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH7_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH7 Mask           */

/* -------------------------------  GPDMA0_CLEARERR  ------------------------------ */
#define GPDMA0_CLEARERR_CH0_Pos               0                                                       /*!< GPDMA0 CLEARERR: CH0 Position           */
#define GPDMA0_CLEARERR_CH0_Msk               (0x01UL << GPDMA0_CLEARERR_CH0_Pos)                     /*!< GPDMA0 CLEARERR: CH0 Mask               */
#define GPDMA0_CLEARERR_CH1_Pos               1                                                       /*!< GPDMA0 CLEARERR: CH1 Position           */
#define GPDMA0_CLEARERR_CH1_Msk               (0x01UL << GPDMA0_CLEARERR_CH1_Pos)                     /*!< GPDMA0 CLEARERR: CH1 Mask               */
#define GPDMA0_CLEARERR_CH2_Pos               2                                                       /*!< GPDMA0 CLEARERR: CH2 Position           */
#define GPDMA0_CLEARERR_CH2_Msk               (0x01UL << GPDMA0_CLEARERR_CH2_Pos)                     /*!< GPDMA0 CLEARERR: CH2 Mask               */
#define GPDMA0_CLEARERR_CH3_Pos               3                                                       /*!< GPDMA0 CLEARERR: CH3 Position           */
#define GPDMA0_CLEARERR_CH3_Msk               (0x01UL << GPDMA0_CLEARERR_CH3_Pos)                     /*!< GPDMA0 CLEARERR: CH3 Mask               */
#define GPDMA0_CLEARERR_CH4_Pos               4                                                       /*!< GPDMA0 CLEARERR: CH4 Position           */
#define GPDMA0_CLEARERR_CH4_Msk               (0x01UL << GPDMA0_CLEARERR_CH4_Pos)                     /*!< GPDMA0 CLEARERR: CH4 Mask               */
#define GPDMA0_CLEARERR_CH5_Pos               5                                                       /*!< GPDMA0 CLEARERR: CH5 Position           */
#define GPDMA0_CLEARERR_CH5_Msk               (0x01UL << GPDMA0_CLEARERR_CH5_Pos)                     /*!< GPDMA0 CLEARERR: CH5 Mask               */
#define GPDMA0_CLEARERR_CH6_Pos               6                                                       /*!< GPDMA0 CLEARERR: CH6 Position           */
#define GPDMA0_CLEARERR_CH6_Msk               (0x01UL << GPDMA0_CLEARERR_CH6_Pos)                     /*!< GPDMA0 CLEARERR: CH6 Mask               */
#define GPDMA0_CLEARERR_CH7_Pos               7                                                       /*!< GPDMA0 CLEARERR: CH7 Position           */
#define GPDMA0_CLEARERR_CH7_Msk               (0x01UL << GPDMA0_CLEARERR_CH7_Pos)                     /*!< GPDMA0 CLEARERR: CH7 Mask               */

/* ------------------------------  GPDMA0_STATUSINT  ------------------------------ */
#define GPDMA0_STATUSINT_TFR_Pos              0                                                       /*!< GPDMA0 STATUSINT: TFR Position          */
#define GPDMA0_STATUSINT_TFR_Msk              (0x01UL << GPDMA0_STATUSINT_TFR_Pos)                    /*!< GPDMA0 STATUSINT: TFR Mask              */
#define GPDMA0_STATUSINT_BLOCK_Pos            1                                                       /*!< GPDMA0 STATUSINT: BLOCK Position        */
#define GPDMA0_STATUSINT_BLOCK_Msk            (0x01UL << GPDMA0_STATUSINT_BLOCK_Pos)                  /*!< GPDMA0 STATUSINT: BLOCK Mask            */
#define GPDMA0_STATUSINT_SRCT_Pos             2                                                       /*!< GPDMA0 STATUSINT: SRCT Position         */
#define GPDMA0_STATUSINT_SRCT_Msk             (0x01UL << GPDMA0_STATUSINT_SRCT_Pos)                   /*!< GPDMA0 STATUSINT: SRCT Mask             */
#define GPDMA0_STATUSINT_DSTT_Pos             3                                                       /*!< GPDMA0 STATUSINT: DSTT Position         */
#define GPDMA0_STATUSINT_DSTT_Msk             (0x01UL << GPDMA0_STATUSINT_DSTT_Pos)                   /*!< GPDMA0 STATUSINT: DSTT Mask             */
#define GPDMA0_STATUSINT_ERR_Pos              4                                                       /*!< GPDMA0 STATUSINT: ERR Position          */
#define GPDMA0_STATUSINT_ERR_Msk              (0x01UL << GPDMA0_STATUSINT_ERR_Pos)                    /*!< GPDMA0 STATUSINT: ERR Mask              */

/* ------------------------------  GPDMA0_REQSRCREG  ------------------------------ */
#define GPDMA0_REQSRCREG_CH0_Pos              0                                                       /*!< GPDMA0 REQSRCREG: CH0 Position          */
#define GPDMA0_REQSRCREG_CH0_Msk              (0x01UL << GPDMA0_REQSRCREG_CH0_Pos)                    /*!< GPDMA0 REQSRCREG: CH0 Mask              */
#define GPDMA0_REQSRCREG_CH1_Pos              1                                                       /*!< GPDMA0 REQSRCREG: CH1 Position          */
#define GPDMA0_REQSRCREG_CH1_Msk              (0x01UL << GPDMA0_REQSRCREG_CH1_Pos)                    /*!< GPDMA0 REQSRCREG: CH1 Mask              */
#define GPDMA0_REQSRCREG_CH2_Pos              2                                                       /*!< GPDMA0 REQSRCREG: CH2 Position          */
#define GPDMA0_REQSRCREG_CH2_Msk              (0x01UL << GPDMA0_REQSRCREG_CH2_Pos)                    /*!< GPDMA0 REQSRCREG: CH2 Mask              */
#define GPDMA0_REQSRCREG_CH3_Pos              3                                                       /*!< GPDMA0 REQSRCREG: CH3 Position          */
#define GPDMA0_REQSRCREG_CH3_Msk              (0x01UL << GPDMA0_REQSRCREG_CH3_Pos)                    /*!< GPDMA0 REQSRCREG: CH3 Mask              */
#define GPDMA0_REQSRCREG_CH4_Pos              4                                                       /*!< GPDMA0 REQSRCREG: CH4 Position          */
#define GPDMA0_REQSRCREG_CH4_Msk              (0x01UL << GPDMA0_REQSRCREG_CH4_Pos)                    /*!< GPDMA0 REQSRCREG: CH4 Mask              */
#define GPDMA0_REQSRCREG_CH5_Pos              5                                                       /*!< GPDMA0 REQSRCREG: CH5 Position          */
#define GPDMA0_REQSRCREG_CH5_Msk              (0x01UL << GPDMA0_REQSRCREG_CH5_Pos)                    /*!< GPDMA0 REQSRCREG: CH5 Mask              */
#define GPDMA0_REQSRCREG_CH6_Pos              6                                                       /*!< GPDMA0 REQSRCREG: CH6 Position          */
#define GPDMA0_REQSRCREG_CH6_Msk              (0x01UL << GPDMA0_REQSRCREG_CH6_Pos)                    /*!< GPDMA0 REQSRCREG: CH6 Mask              */
#define GPDMA0_REQSRCREG_CH7_Pos              7                                                       /*!< GPDMA0 REQSRCREG: CH7 Position          */
#define GPDMA0_REQSRCREG_CH7_Msk              (0x01UL << GPDMA0_REQSRCREG_CH7_Pos)                    /*!< GPDMA0 REQSRCREG: CH7 Mask              */
#define GPDMA0_REQSRCREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 REQSRCREG: WE_CH0 Position       */
#define GPDMA0_REQSRCREG_WE_CH0_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH0_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH0 Mask           */
#define GPDMA0_REQSRCREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 REQSRCREG: WE_CH1 Position       */
#define GPDMA0_REQSRCREG_WE_CH1_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH1_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH1 Mask           */
#define GPDMA0_REQSRCREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 REQSRCREG: WE_CH2 Position       */
#define GPDMA0_REQSRCREG_WE_CH2_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH2_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH2 Mask           */
#define GPDMA0_REQSRCREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 REQSRCREG: WE_CH3 Position       */
#define GPDMA0_REQSRCREG_WE_CH3_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH3_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH3 Mask           */
#define GPDMA0_REQSRCREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 REQSRCREG: WE_CH4 Position       */
#define GPDMA0_REQSRCREG_WE_CH4_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH4_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH4 Mask           */
#define GPDMA0_REQSRCREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 REQSRCREG: WE_CH5 Position       */
#define GPDMA0_REQSRCREG_WE_CH5_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH5_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH5 Mask           */
#define GPDMA0_REQSRCREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 REQSRCREG: WE_CH6 Position       */
#define GPDMA0_REQSRCREG_WE_CH6_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH6_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH6 Mask           */
#define GPDMA0_REQSRCREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 REQSRCREG: WE_CH7 Position       */
#define GPDMA0_REQSRCREG_WE_CH7_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH7_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH7 Mask           */

/* ------------------------------  GPDMA0_REQDSTREG  ------------------------------ */
#define GPDMA0_REQDSTREG_CH0_Pos              0                                                       /*!< GPDMA0 REQDSTREG: CH0 Position          */
#define GPDMA0_REQDSTREG_CH0_Msk              (0x01UL << GPDMA0_REQDSTREG_CH0_Pos)                    /*!< GPDMA0 REQDSTREG: CH0 Mask              */
#define GPDMA0_REQDSTREG_CH1_Pos              1                                                       /*!< GPDMA0 REQDSTREG: CH1 Position          */
#define GPDMA0_REQDSTREG_CH1_Msk              (0x01UL << GPDMA0_REQDSTREG_CH1_Pos)                    /*!< GPDMA0 REQDSTREG: CH1 Mask              */
#define GPDMA0_REQDSTREG_CH2_Pos              2                                                       /*!< GPDMA0 REQDSTREG: CH2 Position          */
#define GPDMA0_REQDSTREG_CH2_Msk              (0x01UL << GPDMA0_REQDSTREG_CH2_Pos)                    /*!< GPDMA0 REQDSTREG: CH2 Mask              */
#define GPDMA0_REQDSTREG_CH3_Pos              3                                                       /*!< GPDMA0 REQDSTREG: CH3 Position          */
#define GPDMA0_REQDSTREG_CH3_Msk              (0x01UL << GPDMA0_REQDSTREG_CH3_Pos)                    /*!< GPDMA0 REQDSTREG: CH3 Mask              */
#define GPDMA0_REQDSTREG_CH4_Pos              4                                                       /*!< GPDMA0 REQDSTREG: CH4 Position          */
#define GPDMA0_REQDSTREG_CH4_Msk              (0x01UL << GPDMA0_REQDSTREG_CH4_Pos)                    /*!< GPDMA0 REQDSTREG: CH4 Mask              */
#define GPDMA0_REQDSTREG_CH5_Pos              5                                                       /*!< GPDMA0 REQDSTREG: CH5 Position          */
#define GPDMA0_REQDSTREG_CH5_Msk              (0x01UL << GPDMA0_REQDSTREG_CH5_Pos)                    /*!< GPDMA0 REQDSTREG: CH5 Mask              */
#define GPDMA0_REQDSTREG_CH6_Pos              6                                                       /*!< GPDMA0 REQDSTREG: CH6 Position          */
#define GPDMA0_REQDSTREG_CH6_Msk              (0x01UL << GPDMA0_REQDSTREG_CH6_Pos)                    /*!< GPDMA0 REQDSTREG: CH6 Mask              */
#define GPDMA0_REQDSTREG_CH7_Pos              7                                                       /*!< GPDMA0 REQDSTREG: CH7 Position          */
#define GPDMA0_REQDSTREG_CH7_Msk              (0x01UL << GPDMA0_REQDSTREG_CH7_Pos)                    /*!< GPDMA0 REQDSTREG: CH7 Mask              */
#define GPDMA0_REQDSTREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 REQDSTREG: WE_CH0 Position       */
#define GPDMA0_REQDSTREG_WE_CH0_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH0_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH0 Mask           */
#define GPDMA0_REQDSTREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 REQDSTREG: WE_CH1 Position       */
#define GPDMA0_REQDSTREG_WE_CH1_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH1_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH1 Mask           */
#define GPDMA0_REQDSTREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 REQDSTREG: WE_CH2 Position       */
#define GPDMA0_REQDSTREG_WE_CH2_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH2_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH2 Mask           */
#define GPDMA0_REQDSTREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 REQDSTREG: WE_CH3 Position       */
#define GPDMA0_REQDSTREG_WE_CH3_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH3_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH3 Mask           */
#define GPDMA0_REQDSTREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 REQDSTREG: WE_CH4 Position       */
#define GPDMA0_REQDSTREG_WE_CH4_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH4_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH4 Mask           */
#define GPDMA0_REQDSTREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 REQDSTREG: WE_CH5 Position       */
#define GPDMA0_REQDSTREG_WE_CH5_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH5_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH5 Mask           */
#define GPDMA0_REQDSTREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 REQDSTREG: WE_CH6 Position       */
#define GPDMA0_REQDSTREG_WE_CH6_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH6_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH6 Mask           */
#define GPDMA0_REQDSTREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 REQDSTREG: WE_CH7 Position       */
#define GPDMA0_REQDSTREG_WE_CH7_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH7_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH7 Mask           */

/* -----------------------------  GPDMA0_SGLREQSRCREG  ---------------------------- */
#define GPDMA0_SGLREQSRCREG_CH0_Pos           0                                                       /*!< GPDMA0 SGLREQSRCREG: CH0 Position       */
#define GPDMA0_SGLREQSRCREG_CH0_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH0_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH0 Mask           */
#define GPDMA0_SGLREQSRCREG_CH1_Pos           1                                                       /*!< GPDMA0 SGLREQSRCREG: CH1 Position       */
#define GPDMA0_SGLREQSRCREG_CH1_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH1_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH1 Mask           */
#define GPDMA0_SGLREQSRCREG_CH2_Pos           2                                                       /*!< GPDMA0 SGLREQSRCREG: CH2 Position       */
#define GPDMA0_SGLREQSRCREG_CH2_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH2_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH2 Mask           */
#define GPDMA0_SGLREQSRCREG_CH3_Pos           3                                                       /*!< GPDMA0 SGLREQSRCREG: CH3 Position       */
#define GPDMA0_SGLREQSRCREG_CH3_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH3_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH3 Mask           */
#define GPDMA0_SGLREQSRCREG_CH4_Pos           4                                                       /*!< GPDMA0 SGLREQSRCREG: CH4 Position       */
#define GPDMA0_SGLREQSRCREG_CH4_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH4_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH4 Mask           */
#define GPDMA0_SGLREQSRCREG_CH5_Pos           5                                                       /*!< GPDMA0 SGLREQSRCREG: CH5 Position       */
#define GPDMA0_SGLREQSRCREG_CH5_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH5_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH5 Mask           */
#define GPDMA0_SGLREQSRCREG_CH6_Pos           6                                                       /*!< GPDMA0 SGLREQSRCREG: CH6 Position       */
#define GPDMA0_SGLREQSRCREG_CH6_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH6_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH6 Mask           */
#define GPDMA0_SGLREQSRCREG_CH7_Pos           7                                                       /*!< GPDMA0 SGLREQSRCREG: CH7 Position       */
#define GPDMA0_SGLREQSRCREG_CH7_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH7_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH7 Mask           */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Pos        8                                                       /*!< GPDMA0 SGLREQSRCREG: WE_CH0 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH0_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH0 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Pos        9                                                       /*!< GPDMA0 SGLREQSRCREG: WE_CH1 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH1_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH1 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Pos        10                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH2 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH2_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH2 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Pos        11                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH3 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH3_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH3 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Pos        12                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH4 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH4_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH4 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Pos        13                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH5 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH5_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH5 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Pos        14                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH6 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH6_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH6 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Pos        15                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH7 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH7_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH7 Mask        */

/* -----------------------------  GPDMA0_SGLREQDSTREG  ---------------------------- */
#define GPDMA0_SGLREQDSTREG_CH0_Pos           0                                                       /*!< GPDMA0 SGLREQDSTREG: CH0 Position       */
#define GPDMA0_SGLREQDSTREG_CH0_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH0_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH0 Mask           */
#define GPDMA0_SGLREQDSTREG_CH1_Pos           1                                                       /*!< GPDMA0 SGLREQDSTREG: CH1 Position       */
#define GPDMA0_SGLREQDSTREG_CH1_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH1_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH1 Mask           */
#define GPDMA0_SGLREQDSTREG_CH2_Pos           2                                                       /*!< GPDMA0 SGLREQDSTREG: CH2 Position       */
#define GPDMA0_SGLREQDSTREG_CH2_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH2_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH2 Mask           */
#define GPDMA0_SGLREQDSTREG_CH3_Pos           3                                                       /*!< GPDMA0 SGLREQDSTREG: CH3 Position       */
#define GPDMA0_SGLREQDSTREG_CH3_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH3_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH3 Mask           */
#define GPDMA0_SGLREQDSTREG_CH4_Pos           4                                                       /*!< GPDMA0 SGLREQDSTREG: CH4 Position       */
#define GPDMA0_SGLREQDSTREG_CH4_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH4_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH4 Mask           */
#define GPDMA0_SGLREQDSTREG_CH5_Pos           5                                                       /*!< GPDMA0 SGLREQDSTREG: CH5 Position       */
#define GPDMA0_SGLREQDSTREG_CH5_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH5_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH5 Mask           */
#define GPDMA0_SGLREQDSTREG_CH6_Pos           6                                                       /*!< GPDMA0 SGLREQDSTREG: CH6 Position       */
#define GPDMA0_SGLREQDSTREG_CH6_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH6_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH6 Mask           */
#define GPDMA0_SGLREQDSTREG_CH7_Pos           7                                                       /*!< GPDMA0 SGLREQDSTREG: CH7 Position       */
#define GPDMA0_SGLREQDSTREG_CH7_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH7_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH7 Mask           */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Pos        8                                                       /*!< GPDMA0 SGLREQDSTREG: WE_CH0 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH0_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH0 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Pos        9                                                       /*!< GPDMA0 SGLREQDSTREG: WE_CH1 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH1_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH1 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Pos        10                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH2 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH2_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH2 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Pos        11                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH3 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH3_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH3 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Pos        12                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH4 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH4_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH4 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Pos        13                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH5 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH5_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH5 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Pos        14                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH6 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH6_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH6 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Pos        15                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH7 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH7_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH7 Mask        */

/* ------------------------------  GPDMA0_LSTSRCREG  ------------------------------ */
#define GPDMA0_LSTSRCREG_CH0_Pos              0                                                       /*!< GPDMA0 LSTSRCREG: CH0 Position          */
#define GPDMA0_LSTSRCREG_CH0_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH0_Pos)                    /*!< GPDMA0 LSTSRCREG: CH0 Mask              */
#define GPDMA0_LSTSRCREG_CH1_Pos              1                                                       /*!< GPDMA0 LSTSRCREG: CH1 Position          */
#define GPDMA0_LSTSRCREG_CH1_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH1_Pos)                    /*!< GPDMA0 LSTSRCREG: CH1 Mask              */
#define GPDMA0_LSTSRCREG_CH2_Pos              2                                                       /*!< GPDMA0 LSTSRCREG: CH2 Position          */
#define GPDMA0_LSTSRCREG_CH2_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH2_Pos)                    /*!< GPDMA0 LSTSRCREG: CH2 Mask              */
#define GPDMA0_LSTSRCREG_CH3_Pos              3                                                       /*!< GPDMA0 LSTSRCREG: CH3 Position          */
#define GPDMA0_LSTSRCREG_CH3_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH3_Pos)                    /*!< GPDMA0 LSTSRCREG: CH3 Mask              */
#define GPDMA0_LSTSRCREG_CH4_Pos              4                                                       /*!< GPDMA0 LSTSRCREG: CH4 Position          */
#define GPDMA0_LSTSRCREG_CH4_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH4_Pos)                    /*!< GPDMA0 LSTSRCREG: CH4 Mask              */
#define GPDMA0_LSTSRCREG_CH5_Pos              5                                                       /*!< GPDMA0 LSTSRCREG: CH5 Position          */
#define GPDMA0_LSTSRCREG_CH5_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH5_Pos)                    /*!< GPDMA0 LSTSRCREG: CH5 Mask              */
#define GPDMA0_LSTSRCREG_CH6_Pos              6                                                       /*!< GPDMA0 LSTSRCREG: CH6 Position          */
#define GPDMA0_LSTSRCREG_CH6_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH6_Pos)                    /*!< GPDMA0 LSTSRCREG: CH6 Mask              */
#define GPDMA0_LSTSRCREG_CH7_Pos              7                                                       /*!< GPDMA0 LSTSRCREG: CH7 Position          */
#define GPDMA0_LSTSRCREG_CH7_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH7_Pos)                    /*!< GPDMA0 LSTSRCREG: CH7 Mask              */
#define GPDMA0_LSTSRCREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 LSTSRCREG: WE_CH0 Position       */
#define GPDMA0_LSTSRCREG_WE_CH0_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH0_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH0 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 LSTSRCREG: WE_CH1 Position       */
#define GPDMA0_LSTSRCREG_WE_CH1_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH1_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH1 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 LSTSRCREG: WE_CH2 Position       */
#define GPDMA0_LSTSRCREG_WE_CH2_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH2_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH2 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 LSTSRCREG: WE_CH3 Position       */
#define GPDMA0_LSTSRCREG_WE_CH3_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH3_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH3 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 LSTSRCREG: WE_CH4 Position       */
#define GPDMA0_LSTSRCREG_WE_CH4_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH4_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH4 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 LSTSRCREG: WE_CH5 Position       */
#define GPDMA0_LSTSRCREG_WE_CH5_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH5_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH5 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 LSTSRCREG: WE_CH6 Position       */
#define GPDMA0_LSTSRCREG_WE_CH6_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH6_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH6 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 LSTSRCREG: WE_CH7 Position       */
#define GPDMA0_LSTSRCREG_WE_CH7_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH7_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH7 Mask           */

/* ------------------------------  GPDMA0_LSTDSTREG  ------------------------------ */
#define GPDMA0_LSTDSTREG_CH0_Pos              0                                                       /*!< GPDMA0 LSTDSTREG: CH0 Position          */
#define GPDMA0_LSTDSTREG_CH0_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH0_Pos)                    /*!< GPDMA0 LSTDSTREG: CH0 Mask              */
#define GPDMA0_LSTDSTREG_CH1_Pos              1                                                       /*!< GPDMA0 LSTDSTREG: CH1 Position          */
#define GPDMA0_LSTDSTREG_CH1_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH1_Pos)                    /*!< GPDMA0 LSTDSTREG: CH1 Mask              */
#define GPDMA0_LSTDSTREG_CH2_Pos              2                                                       /*!< GPDMA0 LSTDSTREG: CH2 Position          */
#define GPDMA0_LSTDSTREG_CH2_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH2_Pos)                    /*!< GPDMA0 LSTDSTREG: CH2 Mask              */
#define GPDMA0_LSTDSTREG_CH3_Pos              3                                                       /*!< GPDMA0 LSTDSTREG: CH3 Position          */
#define GPDMA0_LSTDSTREG_CH3_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH3_Pos)                    /*!< GPDMA0 LSTDSTREG: CH3 Mask              */
#define GPDMA0_LSTDSTREG_CH4_Pos              4                                                       /*!< GPDMA0 LSTDSTREG: CH4 Position          */
#define GPDMA0_LSTDSTREG_CH4_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH4_Pos)                    /*!< GPDMA0 LSTDSTREG: CH4 Mask              */
#define GPDMA0_LSTDSTREG_CH5_Pos              5                                                       /*!< GPDMA0 LSTDSTREG: CH5 Position          */
#define GPDMA0_LSTDSTREG_CH5_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH5_Pos)                    /*!< GPDMA0 LSTDSTREG: CH5 Mask              */
#define GPDMA0_LSTDSTREG_CH6_Pos              6                                                       /*!< GPDMA0 LSTDSTREG: CH6 Position          */
#define GPDMA0_LSTDSTREG_CH6_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH6_Pos)                    /*!< GPDMA0 LSTDSTREG: CH6 Mask              */
#define GPDMA0_LSTDSTREG_CH7_Pos              7                                                       /*!< GPDMA0 LSTDSTREG: CH7 Position          */
#define GPDMA0_LSTDSTREG_CH7_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH7_Pos)                    /*!< GPDMA0 LSTDSTREG: CH7 Mask              */
#define GPDMA0_LSTDSTREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 LSTDSTREG: WE_CH0 Position       */
#define GPDMA0_LSTDSTREG_WE_CH0_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH0_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH0 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 LSTDSTREG: WE_CH1 Position       */
#define GPDMA0_LSTDSTREG_WE_CH1_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH1_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH1 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 LSTDSTREG: WE_CH2 Position       */
#define GPDMA0_LSTDSTREG_WE_CH2_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH2_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH2 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 LSTDSTREG: WE_CH3 Position       */
#define GPDMA0_LSTDSTREG_WE_CH3_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH3_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH3 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 LSTDSTREG: WE_CH4 Position       */
#define GPDMA0_LSTDSTREG_WE_CH4_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH4_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH4 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 LSTDSTREG: WE_CH5 Position       */
#define GPDMA0_LSTDSTREG_WE_CH5_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH5_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH5 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 LSTDSTREG: WE_CH6 Position       */
#define GPDMA0_LSTDSTREG_WE_CH6_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH6_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH6 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 LSTDSTREG: WE_CH7 Position       */
#define GPDMA0_LSTDSTREG_WE_CH7_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH7_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH7 Mask           */

/* ------------------------------  GPDMA0_DMACFGREG  ------------------------------ */
#define GPDMA0_DMACFGREG_DMA_EN_Pos           0                                                       /*!< GPDMA0 DMACFGREG: DMA_EN Position       */
#define GPDMA0_DMACFGREG_DMA_EN_Msk           (0x01UL << GPDMA0_DMACFGREG_DMA_EN_Pos)                 /*!< GPDMA0 DMACFGREG: DMA_EN Mask           */

/* -------------------------------  GPDMA0_CHENREG  ------------------------------- */
#define GPDMA0_CHENREG_CH_Pos                 0                                                       /*!< GPDMA0 CHENREG: CH Position             */
#define GPDMA0_CHENREG_CH_Msk                 (0x000000ffUL << GPDMA0_CHENREG_CH_Pos)                 /*!< GPDMA0 CHENREG: CH Mask                 */
#define GPDMA0_CHENREG_WE_CH_Pos              8                                                       /*!< GPDMA0 CHENREG: WE_CH Position          */
#define GPDMA0_CHENREG_WE_CH_Msk              (0x000000ffUL << GPDMA0_CHENREG_WE_CH_Pos)              /*!< GPDMA0 CHENREG: WE_CH Mask              */

/* ----------------------------------  GPDMA0_ID  --------------------------------- */
#define GPDMA0_ID_VALUE_Pos                   0                                                       /*!< GPDMA0 ID: VALUE Position               */
#define GPDMA0_ID_VALUE_Msk                   (0xffffffffUL << GPDMA0_ID_VALUE_Pos)                   /*!< GPDMA0 ID: VALUE Mask                   */

/* ---------------------------------  GPDMA0_TYPE  -------------------------------- */
#define GPDMA0_TYPE_VALUE_Pos                 0                                                       /*!< GPDMA0 TYPE: VALUE Position             */
#define GPDMA0_TYPE_VALUE_Msk                 (0xffffffffUL << GPDMA0_TYPE_VALUE_Pos)                 /*!< GPDMA0 TYPE: VALUE Mask                 */

/* -------------------------------  GPDMA0_VERSION  ------------------------------- */
#define GPDMA0_VERSION_VALUE_Pos              0                                                       /*!< GPDMA0 VERSION: VALUE Position          */
#define GPDMA0_VERSION_VALUE_Msk              (0xffffffffUL << GPDMA0_VERSION_VALUE_Pos)              /*!< GPDMA0 VERSION: VALUE Mask              */


/* ================================================================================ */
/* ================      Group 'GPDMA0_CH0_1' Position & Mask      ================ */
/* ================================================================================ */


/* ------------------------------  GPDMA0_CH_SAR  ------------------------------ */
#define GPDMA0_CH_SAR_SAR_Pos              0                                                       /*!< GPDMA0_CH0_1 SAR: SAR Position          */
#define GPDMA0_CH_SAR_SAR_Msk              (0xffffffffUL << GPDMA0_CH_SAR_SAR_Pos)              /*!< GPDMA0_CH0_1 SAR: SAR Mask              */

/* ------------------------------  GPDMA0_CH_DAR  ------------------------------ */
#define GPDMA0_CH_DAR_DAR_Pos              0                                                       /*!< GPDMA0_CH0_1 DAR: DAR Position          */
#define GPDMA0_CH_DAR_DAR_Msk              (0xffffffffUL << GPDMA0_CH_DAR_DAR_Pos)              /*!< GPDMA0_CH0_1 DAR: DAR Mask              */

/* ------------------------------  GPDMA0_CH_LLP  ------------------------------ */
#define GPDMA0_CH_LLP_LOC_Pos              2                                                       /*!< GPDMA0_CH0_1 LLP: LOC Position          */
#define GPDMA0_CH_LLP_LOC_Msk              (0x3fffffffUL << GPDMA0_CH_LLP_LOC_Pos)              /*!< GPDMA0_CH0_1 LLP: LOC Mask              */

/* ------------------------------  GPDMA0_CH_CTLL  ----------------------------- */
#define GPDMA0_CH_CTLL_INT_EN_Pos          0                                                       /*!< GPDMA0_CH0_1 CTLL: INT_EN Position      */
#define GPDMA0_CH_CTLL_INT_EN_Msk          (0x01UL << GPDMA0_CH_CTLL_INT_EN_Pos)                /*!< GPDMA0_CH0_1 CTLL: INT_EN Mask          */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Pos    1                                                       /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH Position */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Msk    (0x07UL << GPDMA0_CH_CTLL_DST_TR_WIDTH_Pos)          /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH Mask    */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Pos    4                                                       /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH Position */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Msk    (0x07UL << GPDMA0_CH_CTLL_SRC_TR_WIDTH_Pos)          /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH Mask    */
#define GPDMA0_CH_CTLL_DINC_Pos            7                                                       /*!< GPDMA0_CH0_1 CTLL: DINC Position        */
#define GPDMA0_CH_CTLL_DINC_Msk            (0x03UL << GPDMA0_CH_CTLL_DINC_Pos)                  /*!< GPDMA0_CH0_1 CTLL: DINC Mask            */
#define GPDMA0_CH_CTLL_SINC_Pos            9                                                       /*!< GPDMA0_CH0_1 CTLL: SINC Position        */
#define GPDMA0_CH_CTLL_SINC_Msk            (0x03UL << GPDMA0_CH_CTLL_SINC_Pos)                  /*!< GPDMA0_CH0_1 CTLL: SINC Mask            */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Pos      11                                                      /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE Position  */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Msk      (0x07UL << GPDMA0_CH_CTLL_DEST_MSIZE_Pos)            /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE Mask      */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Pos       14                                                      /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE Position   */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Msk       (0x07UL << GPDMA0_CH_CTLL_SRC_MSIZE_Pos)             /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE Mask       */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Pos   17                                                      /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN Position */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Msk   (0x01UL << GPDMA0_CH_CTLL_SRC_GATHER_EN_Pos)         /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN Mask   */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Pos  18                                                      /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN Position */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Msk  (0x01UL << GPDMA0_CH_CTLL_DST_SCATTER_EN_Pos)        /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN Mask  */
#define GPDMA0_CH_CTLL_TT_FC_Pos           20                                                      /*!< GPDMA0_CH0_1 CTLL: TT_FC Position       */
#define GPDMA0_CH_CTLL_TT_FC_Msk           (0x07UL << GPDMA0_CH_CTLL_TT_FC_Pos)                 /*!< GPDMA0_CH0_1 CTLL: TT_FC Mask           */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Pos      27                                                      /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN Position  */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Msk      (0x01UL << GPDMA0_CH_CTLL_LLP_DST_EN_Pos)            /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN Mask      */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Pos      28                                                      /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN Position  */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Msk      (0x01UL << GPDMA0_CH_CTLL_LLP_SRC_EN_Pos)            /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN Mask      */

/* ------------------------------  GPDMA0_CH_CTLH  ----------------------------- */
#define GPDMA0_CH_CTLH_BLOCK_TS_Pos        0                                                       /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS Position    */
#define GPDMA0_CH_CTLH_BLOCK_TS_Msk        (0x00000fffUL << GPDMA0_CH_CTLH_BLOCK_TS_Pos)        /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS Mask        */
#define GPDMA0_CH_CTLH_DONE_Pos            12                                                      /*!< GPDMA0_CH0_1 CTLH: DONE Position        */
#define GPDMA0_CH_CTLH_DONE_Msk            (0x01UL << GPDMA0_CH_CTLH_DONE_Pos)                  /*!< GPDMA0_CH0_1 CTLH: DONE Mask            */

/* -----------------------------  GPDMA0_CH_SSTAT  ----------------------------- */
#define GPDMA0_CH_SSTAT_SSTAT_Pos          0                                                       /*!< GPDMA0_CH0_1 SSTAT: SSTAT Position      */
#define GPDMA0_CH_SSTAT_SSTAT_Msk          (0xffffffffUL << GPDMA0_CH_SSTAT_SSTAT_Pos)          /*!< GPDMA0_CH0_1 SSTAT: SSTAT Mask          */

/* -----------------------------  GPDMA0_CH_DSTAT  ----------------------------- */
#define GPDMA0_CH_DSTAT_DSTAT_Pos          0                                                       /*!< GPDMA0_CH0_1 DSTAT: DSTAT Position      */
#define GPDMA0_CH_DSTAT_DSTAT_Msk          (0xffffffffUL << GPDMA0_CH_DSTAT_DSTAT_Pos)          /*!< GPDMA0_CH0_1 DSTAT: DSTAT Mask          */

/* ----------------------------  GPDMA0_CH_SSTATAR  ---------------------------- */
#define GPDMA0_CH_SSTATAR_SSTATAR_Pos      0                                                       /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR Position  */
#define GPDMA0_CH_SSTATAR_SSTATAR_Msk      (0xffffffffUL << GPDMA0_CH_SSTATAR_SSTATAR_Pos)      /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR Mask      */

/* ----------------------------  GPDMA0_CH_DSTATAR  ---------------------------- */
#define GPDMA0_CH_DSTATAR_DSTATAR_Pos      0                                                       /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR Position  */
#define GPDMA0_CH_DSTATAR_DSTATAR_Msk      (0xffffffffUL << GPDMA0_CH_DSTATAR_DSTATAR_Pos)      /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR Mask      */

/* ------------------------------  GPDMA0_CH_CFGL  ----------------------------- */
#define GPDMA0_CH_CFGL_CH_PRIOR_Pos        5                                                       /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR Position    */
#define GPDMA0_CH_CFGL_CH_PRIOR_Msk        (0x07UL << GPDMA0_CH_CFGL_CH_PRIOR_Pos)              /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR Mask        */
#define GPDMA0_CH_CFGL_CH_SUSP_Pos         8                                                       /*!< GPDMA0_CH0_1 CFGL: CH_SUSP Position     */
#define GPDMA0_CH_CFGL_CH_SUSP_Msk         (0x01UL << GPDMA0_CH_CFGL_CH_SUSP_Pos)               /*!< GPDMA0_CH0_1 CFGL: CH_SUSP Mask         */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Pos      9                                                       /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY Position  */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Msk      (0x01UL << GPDMA0_CH_CFGL_FIFO_EMPTY_Pos)            /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY Mask      */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Pos      10                                                      /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST Position  */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Msk      (0x01UL << GPDMA0_CH_CFGL_HS_SEL_DST_Pos)            /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST Mask      */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Pos      11                                                      /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC Position  */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Msk      (0x01UL << GPDMA0_CH_CFGL_HS_SEL_SRC_Pos)            /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC Mask      */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Pos       12                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L Position   */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Msk       (0x03UL << GPDMA0_CH_CFGL_LOCK_CH_L_Pos)             /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L Mask       */
#define GPDMA0_CH_CFGL_LOCK_B_L_Pos        14                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L Position    */
#define GPDMA0_CH_CFGL_LOCK_B_L_Msk        (0x03UL << GPDMA0_CH_CFGL_LOCK_B_L_Pos)              /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L Mask        */
#define GPDMA0_CH_CFGL_LOCK_CH_Pos         16                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_CH Position     */
#define GPDMA0_CH_CFGL_LOCK_CH_Msk         (0x01UL << GPDMA0_CH_CFGL_LOCK_CH_Pos)               /*!< GPDMA0_CH0_1 CFGL: LOCK_CH Mask         */
#define GPDMA0_CH_CFGL_LOCK_B_Pos          17                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_B Position      */
#define GPDMA0_CH_CFGL_LOCK_B_Msk          (0x01UL << GPDMA0_CH_CFGL_LOCK_B_Pos)                /*!< GPDMA0_CH0_1 CFGL: LOCK_B Mask          */
#define GPDMA0_CH_CFGL_DST_HS_POL_Pos      18                                                      /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL Position  */
#define GPDMA0_CH_CFGL_DST_HS_POL_Msk      (0x01UL << GPDMA0_CH_CFGL_DST_HS_POL_Pos)            /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL Mask      */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Pos      19                                                      /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL Position  */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Msk      (0x01UL << GPDMA0_CH_CFGL_SRC_HS_POL_Pos)            /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL Mask      */
#define GPDMA0_CH_CFGL_MAX_ABRST_Pos       20                                                      /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST Position   */
#define GPDMA0_CH_CFGL_MAX_ABRST_Msk       (0x000003ffUL << GPDMA0_CH_CFGL_MAX_ABRST_Pos)       /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST Mask       */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Pos      30                                                      /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC Position  */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Msk      (0x01UL << GPDMA0_CH_CFGL_RELOAD_SRC_Pos)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC Mask      */
#define GPDMA0_CH_CFGL_RELOAD_DST_Pos      31                                                      /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST Position  */
#define GPDMA0_CH_CFGL_RELOAD_DST_Msk      (0x01UL << GPDMA0_CH_CFGL_RELOAD_DST_Pos)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST Mask      */

/* ------------------------------  GPDMA0_CH_CFGH  ----------------------------- */
#define GPDMA0_CH_CFGH_FCMODE_Pos          0                                                       /*!< GPDMA0_CH0_1 CFGH: FCMODE Position      */
#define GPDMA0_CH_CFGH_FCMODE_Msk          (0x01UL << GPDMA0_CH_CFGH_FCMODE_Pos)                /*!< GPDMA0_CH0_1 CFGH: FCMODE Mask          */
#define GPDMA0_CH_CFGH_FIFO_MODE_Pos       1                                                       /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE Position   */
#define GPDMA0_CH_CFGH_FIFO_MODE_Msk       (0x01UL << GPDMA0_CH_CFGH_FIFO_MODE_Pos)             /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE Mask       */
#define GPDMA0_CH_CFGH_PROTCTL_Pos         2                                                       /*!< GPDMA0_CH0_1 CFGH: PROTCTL Position     */
#define GPDMA0_CH_CFGH_PROTCTL_Msk         (0x07UL << GPDMA0_CH_CFGH_PROTCTL_Pos)               /*!< GPDMA0_CH0_1 CFGH: PROTCTL Mask         */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Pos       5                                                       /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN Position   */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Msk       (0x01UL << GPDMA0_CH_CFGH_DS_UPD_EN_Pos)             /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN Mask       */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Pos       6                                                       /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN Position   */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Msk       (0x01UL << GPDMA0_CH_CFGH_SS_UPD_EN_Pos)             /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN Mask       */
#define GPDMA0_CH_CFGH_SRC_PER_Pos         7                                                       /*!< GPDMA0_CH0_1 CFGH: SRC_PER Position     */
#define GPDMA0_CH_CFGH_SRC_PER_Msk         (0x0fUL << GPDMA0_CH_CFGH_SRC_PER_Pos)               /*!< GPDMA0_CH0_1 CFGH: SRC_PER Mask         */
#define GPDMA0_CH_CFGH_DEST_PER_Pos        11                                                      /*!< GPDMA0_CH0_1 CFGH: DEST_PER Position    */
#define GPDMA0_CH_CFGH_DEST_PER_Msk        (0x0fUL << GPDMA0_CH_CFGH_DEST_PER_Pos)              /*!< GPDMA0_CH0_1 CFGH: DEST_PER Mask        */

/* ------------------------------  GPDMA0_CH_SGR  ------------------------------ */
#define GPDMA0_CH_SGR_SGI_Pos              0                                                       /*!< GPDMA0_CH0_1 SGR: SGI Position          */
#define GPDMA0_CH_SGR_SGI_Msk              (0x000fffffUL << GPDMA0_CH_SGR_SGI_Pos)              /*!< GPDMA0_CH0_1 SGR: SGI Mask              */
#define GPDMA0_CH_SGR_SGC_Pos              20                                                      /*!< GPDMA0_CH0_1 SGR: SGC Position          */
#define GPDMA0_CH_SGR_SGC_Msk              (0x00000fffUL << GPDMA0_CH_SGR_SGC_Pos)              /*!< GPDMA0_CH0_1 SGR: SGC Mask              */

/* ------------------------------  GPDMA0_CH_DSR  ------------------------------ */
#define GPDMA0_CH_DSR_DSI_Pos              0                                                       /*!< GPDMA0_CH0_1 DSR: DSI Position          */
#define GPDMA0_CH_DSR_DSI_Msk              (0x000fffffUL << GPDMA0_CH_DSR_DSI_Pos)              /*!< GPDMA0_CH0_1 DSR: DSI Mask              */
#define GPDMA0_CH_DSR_DSC_Pos              20                                                      /*!< GPDMA0_CH0_1 DSR: DSC Position          */
#define GPDMA0_CH_DSR_DSC_Msk              (0x00000fffUL << GPDMA0_CH_DSR_DSC_Pos)              /*!< GPDMA0_CH0_1 DSR: DSC Mask              */


/* ================================================================================ */
/* ================          struct 'FCE' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  FCE_CLC  ---------------------------------- */
#define FCE_CLC_DISR_Pos                      0                                                       /*!< FCE CLC: DISR Position                  */
#define FCE_CLC_DISR_Msk                      (0x01UL << FCE_CLC_DISR_Pos)                            /*!< FCE CLC: DISR Mask                      */
#define FCE_CLC_DISS_Pos                      1                                                       /*!< FCE CLC: DISS Position                  */
#define FCE_CLC_DISS_Msk                      (0x01UL << FCE_CLC_DISS_Pos)                            /*!< FCE CLC: DISS Mask                      */

/* -----------------------------------  FCE_ID  ----------------------------------- */
#define FCE_ID_MOD_REV_Pos                    0                                                       /*!< FCE ID: MOD_REV Position                */
#define FCE_ID_MOD_REV_Msk                    (0x000000ffUL << FCE_ID_MOD_REV_Pos)                    /*!< FCE ID: MOD_REV Mask                    */
#define FCE_ID_MOD_TYPE_Pos                   8                                                       /*!< FCE ID: MOD_TYPE Position               */
#define FCE_ID_MOD_TYPE_Msk                   (0x000000ffUL << FCE_ID_MOD_TYPE_Pos)                   /*!< FCE ID: MOD_TYPE Mask                   */
#define FCE_ID_MOD_NUMBER_Pos                 16                                                      /*!< FCE ID: MOD_NUMBER Position             */
#define FCE_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << FCE_ID_MOD_NUMBER_Pos)                 /*!< FCE ID: MOD_NUMBER Mask                 */


/* ================================================================================ */
/* ================         Group 'FCE_KE' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FCE_KE_IR  --------------------------------- */
#define FCE_KE_IR_IR_Pos                      0                                                       /*!< FCE_KE IR: IR Position                  */
#define FCE_KE_IR_IR_Msk                      (0xffffffffUL << FCE_KE_IR_IR_Pos)                      /*!< FCE_KE IR: IR Mask                      */

/* ---------------------------------  FCE_KE_RES  --------------------------------- */
#define FCE_KE_RES_RES_Pos                    0                                                       /*!< FCE_KE RES: RES Position                */
#define FCE_KE_RES_RES_Msk                    (0xffffffffUL << FCE_KE_RES_RES_Pos)                    /*!< FCE_KE RES: RES Mask                    */

/* ---------------------------------  FCE_KE_CFG  --------------------------------- */
#define FCE_KE_CFG_CMI_Pos                    0                                                       /*!< FCE_KE CFG: CMI Position                */
#define FCE_KE_CFG_CMI_Msk                    (0x01UL << FCE_KE_CFG_CMI_Pos)                          /*!< FCE_KE CFG: CMI Mask                    */
#define FCE_KE_CFG_CEI_Pos                    1                                                       /*!< FCE_KE CFG: CEI Position                */
#define FCE_KE_CFG_CEI_Msk                    (0x01UL << FCE_KE_CFG_CEI_Pos)                          /*!< FCE_KE CFG: CEI Mask                    */
#define FCE_KE_CFG_LEI_Pos                    2                                                       /*!< FCE_KE CFG: LEI Position                */
#define FCE_KE_CFG_LEI_Msk                    (0x01UL << FCE_KE_CFG_LEI_Pos)                          /*!< FCE_KE CFG: LEI Mask                    */
#define FCE_KE_CFG_BEI_Pos                    3                                                       /*!< FCE_KE CFG: BEI Position                */
#define FCE_KE_CFG_BEI_Msk                    (0x01UL << FCE_KE_CFG_BEI_Pos)                          /*!< FCE_KE CFG: BEI Mask                    */
#define FCE_KE_CFG_CCE_Pos                    4                                                       /*!< FCE_KE CFG: CCE Position                */
#define FCE_KE_CFG_CCE_Msk                    (0x01UL << FCE_KE_CFG_CCE_Pos)                          /*!< FCE_KE CFG: CCE Mask                    */
#define FCE_KE_CFG_ALR_Pos                    5                                                       /*!< FCE_KE CFG: ALR Position                */
#define FCE_KE_CFG_ALR_Msk                    (0x01UL << FCE_KE_CFG_ALR_Pos)                          /*!< FCE_KE CFG: ALR Mask                    */
#define FCE_KE_CFG_REFIN_Pos                  8                                                       /*!< FCE_KE CFG: REFIN Position              */
#define FCE_KE_CFG_REFIN_Msk                  (0x01UL << FCE_KE_CFG_REFIN_Pos)                        /*!< FCE_KE CFG: REFIN Mask                  */
#define FCE_KE_CFG_REFOUT_Pos                 9                                                       /*!< FCE_KE CFG: REFOUT Position             */
#define FCE_KE_CFG_REFOUT_Msk                 (0x01UL << FCE_KE_CFG_REFOUT_Pos)                       /*!< FCE_KE CFG: REFOUT Mask                 */
#define FCE_KE_CFG_XSEL_Pos                   10                                                      /*!< FCE_KE CFG: XSEL Position               */
#define FCE_KE_CFG_XSEL_Msk                   (0x01UL << FCE_KE_CFG_XSEL_Pos)                         /*!< FCE_KE CFG: XSEL Mask                   */

/* ---------------------------------  FCE_KE_STS  --------------------------------- */
#define FCE_KE_STS_CMF_Pos                    0                                                       /*!< FCE_KE STS: CMF Position                */
#define FCE_KE_STS_CMF_Msk                    (0x01UL << FCE_KE_STS_CMF_Pos)                          /*!< FCE_KE STS: CMF Mask                    */
#define FCE_KE_STS_CEF_Pos                    1                                                       /*!< FCE_KE STS: CEF Position                */
#define FCE_KE_STS_CEF_Msk                    (0x01UL << FCE_KE_STS_CEF_Pos)                          /*!< FCE_KE STS: CEF Mask                    */
#define FCE_KE_STS_LEF_Pos                    2                                                       /*!< FCE_KE STS: LEF Position                */
#define FCE_KE_STS_LEF_Msk                    (0x01UL << FCE_KE_STS_LEF_Pos)                          /*!< FCE_KE STS: LEF Mask                    */
#define FCE_KE_STS_BEF_Pos                    3                                                       /*!< FCE_KE STS: BEF Position                */
#define FCE_KE_STS_BEF_Msk                    (0x01UL << FCE_KE_STS_BEF_Pos)                          /*!< FCE_KE STS: BEF Mask                    */

/* --------------------------------  FCE_KE_LENGTH  ------------------------------- */
#define FCE_KE_LENGTH_LENGTH_Pos              0                                                       /*!< FCE_KE LENGTH: LENGTH Position          */
#define FCE_KE_LENGTH_LENGTH_Msk              (0x0000ffffUL << FCE_KE_LENGTH_LENGTH_Pos)              /*!< FCE_KE LENGTH: LENGTH Mask              */

/* --------------------------------  FCE_KE_CHECK  -------------------------------- */
#define FCE_KE_CHECK_CHECK_Pos                0                                                       /*!< FCE_KE CHECK: CHECK Position            */
#define FCE_KE_CHECK_CHECK_Msk                (0xffffffffUL << FCE_KE_CHECK_CHECK_Pos)                /*!< FCE_KE CHECK: CHECK Mask                */

/* ---------------------------------  FCE_KE_CRC  --------------------------------- */
#define FCE_KE_CRC_CRC_Pos                    0                                                       /*!< FCE_KE CRC: CRC Position                */
#define FCE_KE_CRC_CRC_Msk                    (0xffffffffUL << FCE_KE_CRC_CRC_Pos)                    /*!< FCE_KE CRC: CRC Mask                    */

/* ---------------------------------  FCE_KE_CTR  --------------------------------- */
#define FCE_KE_CTR_FCM_Pos                    0                                                       /*!< FCE_KE CTR: FCM Position                */
#define FCE_KE_CTR_FCM_Msk                    (0x01UL << FCE_KE_CTR_FCM_Pos)                          /*!< FCE_KE CTR: FCM Mask                    */
#define FCE_KE_CTR_FRM_CFG_Pos                1                                                       /*!< FCE_KE CTR: FRM_CFG Position            */
#define FCE_KE_CTR_FRM_CFG_Msk                (0x01UL << FCE_KE_CTR_FRM_CFG_Pos)                      /*!< FCE_KE CTR: FRM_CFG Mask                */
#define FCE_KE_CTR_FRM_CHECK_Pos              2                                                       /*!< FCE_KE CTR: FRM_CHECK Position          */
#define FCE_KE_CTR_FRM_CHECK_Msk              (0x01UL << FCE_KE_CTR_FRM_CHECK_Pos)                    /*!< FCE_KE CTR: FRM_CHECK Mask              */


/* ================================================================================ */
/* ================           Group 'PBA' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PBA_STS  ---------------------------------- */
#define PBA_STS_WERR_Pos                      0                                                       /*!< PBA STS: WERR Position                  */
#define PBA_STS_WERR_Msk                      (0x01UL << PBA_STS_WERR_Pos)                            /*!< PBA STS: WERR Mask                      */

/* ----------------------------------  PBA_WADDR  --------------------------------- */
#define PBA_WADDR_WADDR_Pos                   0                                                       /*!< PBA WADDR: WADDR Position               */
#define PBA_WADDR_WADDR_Msk                   (0xffffffffUL << PBA_WADDR_WADDR_Pos)                   /*!< PBA WADDR: WADDR Mask                   */


/* ================================================================================ */
/* ================          Group 'FLASH' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FLASH_ID  ---------------------------------- */
#define FLASH_ID_MOD_REV_Pos                  0                                                       /*!< FLASH ID: MOD_REV Position              */
#define FLASH_ID_MOD_REV_Msk                  (0x000000ffUL << FLASH_ID_MOD_REV_Pos)                  /*!< FLASH ID: MOD_REV Mask                  */
#define FLASH_ID_MOD_TYPE_Pos                 8                                                       /*!< FLASH ID: MOD_TYPE Position             */
#define FLASH_ID_MOD_TYPE_Msk                 (0x000000ffUL << FLASH_ID_MOD_TYPE_Pos)                 /*!< FLASH ID: MOD_TYPE Mask                 */
#define FLASH_ID_MOD_NUMBER_Pos               16                                                      /*!< FLASH ID: MOD_NUMBER Position           */
#define FLASH_ID_MOD_NUMBER_Msk               (0x0000ffffUL << FLASH_ID_MOD_NUMBER_Pos)               /*!< FLASH ID: MOD_NUMBER Mask               */

/* ----------------------------------  FLASH_FSR  --------------------------------- */
#define FLASH_FSR_PBUSY_Pos                   0                                                       /*!< FLASH FSR: PBUSY Position               */
#define FLASH_FSR_PBUSY_Msk                   (0x01UL << FLASH_FSR_PBUSY_Pos)                         /*!< FLASH FSR: PBUSY Mask                   */
#define FLASH_FSR_FABUSY_Pos                  1                                                       /*!< FLASH FSR: FABUSY Position              */
#define FLASH_FSR_FABUSY_Msk                  (0x01UL << FLASH_FSR_FABUSY_Pos)                        /*!< FLASH FSR: FABUSY Mask                  */
#define FLASH_FSR_PROG_Pos                    4                                                       /*!< FLASH FSR: PROG Position                */
#define FLASH_FSR_PROG_Msk                    (0x01UL << FLASH_FSR_PROG_Pos)                          /*!< FLASH FSR: PROG Mask                    */
#define FLASH_FSR_ERASE_Pos                   5                                                       /*!< FLASH FSR: ERASE Position               */
#define FLASH_FSR_ERASE_Msk                   (0x01UL << FLASH_FSR_ERASE_Pos)                         /*!< FLASH FSR: ERASE Mask                   */
#define FLASH_FSR_PFPAGE_Pos                  6                                                       /*!< FLASH FSR: PFPAGE Position              */
#define FLASH_FSR_PFPAGE_Msk                  (0x01UL << FLASH_FSR_PFPAGE_Pos)                        /*!< FLASH FSR: PFPAGE Mask                  */
#define FLASH_FSR_PFOPER_Pos                  8                                                       /*!< FLASH FSR: PFOPER Position              */
#define FLASH_FSR_PFOPER_Msk                  (0x01UL << FLASH_FSR_PFOPER_Pos)                        /*!< FLASH FSR: PFOPER Mask                  */
#define FLASH_FSR_SQER_Pos                    10                                                      /*!< FLASH FSR: SQER Position                */
#define FLASH_FSR_SQER_Msk                    (0x01UL << FLASH_FSR_SQER_Pos)                          /*!< FLASH FSR: SQER Mask                    */
#define FLASH_FSR_PROER_Pos                   11                                                      /*!< FLASH FSR: PROER Position               */
#define FLASH_FSR_PROER_Msk                   (0x01UL << FLASH_FSR_PROER_Pos)                         /*!< FLASH FSR: PROER Mask                   */
#define FLASH_FSR_PFSBER_Pos                  12                                                      /*!< FLASH FSR: PFSBER Position              */
#define FLASH_FSR_PFSBER_Msk                  (0x01UL << FLASH_FSR_PFSBER_Pos)                        /*!< FLASH FSR: PFSBER Mask                  */
#define FLASH_FSR_PFDBER_Pos                  14                                                      /*!< FLASH FSR: PFDBER Position              */
#define FLASH_FSR_PFDBER_Msk                  (0x01UL << FLASH_FSR_PFDBER_Pos)                        /*!< FLASH FSR: PFDBER Mask                  */
#define FLASH_FSR_PROIN_Pos                   16                                                      /*!< FLASH FSR: PROIN Position               */
#define FLASH_FSR_PROIN_Msk                   (0x01UL << FLASH_FSR_PROIN_Pos)                         /*!< FLASH FSR: PROIN Mask                   */
#define FLASH_FSR_RPROIN_Pos                  18                                                      /*!< FLASH FSR: RPROIN Position              */
#define FLASH_FSR_RPROIN_Msk                  (0x01UL << FLASH_FSR_RPROIN_Pos)                        /*!< FLASH FSR: RPROIN Mask                  */
#define FLASH_FSR_RPRODIS_Pos                 19                                                      /*!< FLASH FSR: RPRODIS Position             */
#define FLASH_FSR_RPRODIS_Msk                 (0x01UL << FLASH_FSR_RPRODIS_Pos)                       /*!< FLASH FSR: RPRODIS Mask                 */
#define FLASH_FSR_WPROIN0_Pos                 21                                                      /*!< FLASH FSR: WPROIN0 Position             */
#define FLASH_FSR_WPROIN0_Msk                 (0x01UL << FLASH_FSR_WPROIN0_Pos)                       /*!< FLASH FSR: WPROIN0 Mask                 */
#define FLASH_FSR_WPROIN1_Pos                 22                                                      /*!< FLASH FSR: WPROIN1 Position             */
#define FLASH_FSR_WPROIN1_Msk                 (0x01UL << FLASH_FSR_WPROIN1_Pos)                       /*!< FLASH FSR: WPROIN1 Mask                 */
#define FLASH_FSR_WPROIN2_Pos                 23                                                      /*!< FLASH FSR: WPROIN2 Position             */
#define FLASH_FSR_WPROIN2_Msk                 (0x01UL << FLASH_FSR_WPROIN2_Pos)                       /*!< FLASH FSR: WPROIN2 Mask                 */
#define FLASH_FSR_WPRODIS0_Pos                25                                                      /*!< FLASH FSR: WPRODIS0 Position            */
#define FLASH_FSR_WPRODIS0_Msk                (0x01UL << FLASH_FSR_WPRODIS0_Pos)                      /*!< FLASH FSR: WPRODIS0 Mask                */
#define FLASH_FSR_WPRODIS1_Pos                26                                                      /*!< FLASH FSR: WPRODIS1 Position            */
#define FLASH_FSR_WPRODIS1_Msk                (0x01UL << FLASH_FSR_WPRODIS1_Pos)                      /*!< FLASH FSR: WPRODIS1 Mask                */
#define FLASH_FSR_SLM_Pos                     28                                                      /*!< FLASH FSR: SLM Position                 */
#define FLASH_FSR_SLM_Msk                     (0x01UL << FLASH_FSR_SLM_Pos)                           /*!< FLASH FSR: SLM Mask                     */
#define FLASH_FSR_X_Pos                       30                                                      /*!< FLASH FSR: X Position                   */
#define FLASH_FSR_X_Msk                       (0x01UL << FLASH_FSR_X_Pos)                             /*!< FLASH FSR: X Mask                       */
#define FLASH_FSR_VER_Pos                     31                                                      /*!< FLASH FSR: VER Position                 */
#define FLASH_FSR_VER_Msk                     (0x01UL << FLASH_FSR_VER_Pos)                           /*!< FLASH FSR: VER Mask                     */

/* ---------------------------------  FLASH_FCON  --------------------------------- */
#define FLASH_FCON_WSPFLASH_Pos               0                                                       /*!< FLASH FCON: WSPFLASH Position           */
#define FLASH_FCON_WSPFLASH_Msk               (0x0fUL << FLASH_FCON_WSPFLASH_Pos)                     /*!< FLASH FCON: WSPFLASH Mask               */
#define FLASH_FCON_WSECPF_Pos                 4                                                       /*!< FLASH FCON: WSECPF Position             */
#define FLASH_FCON_WSECPF_Msk                 (0x01UL << FLASH_FCON_WSECPF_Pos)                       /*!< FLASH FCON: WSECPF Mask                 */
#define FLASH_FCON_IDLE_Pos                   13                                                      /*!< FLASH FCON: IDLE Position               */
#define FLASH_FCON_IDLE_Msk                   (0x01UL << FLASH_FCON_IDLE_Pos)                         /*!< FLASH FCON: IDLE Mask                   */
#define FLASH_FCON_ESLDIS_Pos                 14                                                      /*!< FLASH FCON: ESLDIS Position             */
#define FLASH_FCON_ESLDIS_Msk                 (0x01UL << FLASH_FCON_ESLDIS_Pos)                       /*!< FLASH FCON: ESLDIS Mask                 */
#define FLASH_FCON_SLEEP_Pos                  15                                                      /*!< FLASH FCON: SLEEP Position              */
#define FLASH_FCON_SLEEP_Msk                  (0x01UL << FLASH_FCON_SLEEP_Pos)                        /*!< FLASH FCON: SLEEP Mask                  */
#define FLASH_FCON_RPA_Pos                    16                                                      /*!< FLASH FCON: RPA Position                */
#define FLASH_FCON_RPA_Msk                    (0x01UL << FLASH_FCON_RPA_Pos)                          /*!< FLASH FCON: RPA Mask                    */
#define FLASH_FCON_DCF_Pos                    17                                                      /*!< FLASH FCON: DCF Position                */
#define FLASH_FCON_DCF_Msk                    (0x01UL << FLASH_FCON_DCF_Pos)                          /*!< FLASH FCON: DCF Mask                    */
#define FLASH_FCON_DDF_Pos                    18                                                      /*!< FLASH FCON: DDF Position                */
#define FLASH_FCON_DDF_Msk                    (0x01UL << FLASH_FCON_DDF_Pos)                          /*!< FLASH FCON: DDF Mask                    */
#define FLASH_FCON_VOPERM_Pos                 24                                                      /*!< FLASH FCON: VOPERM Position             */
#define FLASH_FCON_VOPERM_Msk                 (0x01UL << FLASH_FCON_VOPERM_Pos)                       /*!< FLASH FCON: VOPERM Mask                 */
#define FLASH_FCON_SQERM_Pos                  25                                                      /*!< FLASH FCON: SQERM Position              */
#define FLASH_FCON_SQERM_Msk                  (0x01UL << FLASH_FCON_SQERM_Pos)                        /*!< FLASH FCON: SQERM Mask                  */
#define FLASH_FCON_PROERM_Pos                 26                                                      /*!< FLASH FCON: PROERM Position             */
#define FLASH_FCON_PROERM_Msk                 (0x01UL << FLASH_FCON_PROERM_Pos)                       /*!< FLASH FCON: PROERM Mask                 */
#define FLASH_FCON_PFSBERM_Pos                27                                                      /*!< FLASH FCON: PFSBERM Position            */
#define FLASH_FCON_PFSBERM_Msk                (0x01UL << FLASH_FCON_PFSBERM_Pos)                      /*!< FLASH FCON: PFSBERM Mask                */
#define FLASH_FCON_PFDBERM_Pos                29                                                      /*!< FLASH FCON: PFDBERM Position            */
#define FLASH_FCON_PFDBERM_Msk                (0x01UL << FLASH_FCON_PFDBERM_Pos)                      /*!< FLASH FCON: PFDBERM Mask                */
#define FLASH_FCON_EOBM_Pos                   31                                                      /*!< FLASH FCON: EOBM Position               */
#define FLASH_FCON_EOBM_Msk                   (0x01UL << FLASH_FCON_EOBM_Pos)                         /*!< FLASH FCON: EOBM Mask                   */

/* ---------------------------------  FLASH_MARP  --------------------------------- */
#define FLASH_MARP_MARGIN_Pos                 0                                                       /*!< FLASH MARP: MARGIN Position             */
#define FLASH_MARP_MARGIN_Msk                 (0x0fUL << FLASH_MARP_MARGIN_Pos)                       /*!< FLASH MARP: MARGIN Mask                 */
#define FLASH_MARP_TRAPDIS_Pos                15                                                      /*!< FLASH MARP: TRAPDIS Position            */
#define FLASH_MARP_TRAPDIS_Msk                (0x01UL << FLASH_MARP_TRAPDIS_Pos)                      /*!< FLASH MARP: TRAPDIS Mask                */

/* --------------------------------  FLASH_PROCON0  ------------------------------- */
#define FLASH_PROCON0_S0L_Pos                 0                                                       /*!< FLASH PROCON0: S0L Position             */
#define FLASH_PROCON0_S0L_Msk                 (0x01UL << FLASH_PROCON0_S0L_Pos)                       /*!< FLASH PROCON0: S0L Mask                 */
#define FLASH_PROCON0_S1L_Pos                 1                                                       /*!< FLASH PROCON0: S1L Position             */
#define FLASH_PROCON0_S1L_Msk                 (0x01UL << FLASH_PROCON0_S1L_Pos)                       /*!< FLASH PROCON0: S1L Mask                 */
#define FLASH_PROCON0_S2L_Pos                 2                                                       /*!< FLASH PROCON0: S2L Position             */
#define FLASH_PROCON0_S2L_Msk                 (0x01UL << FLASH_PROCON0_S2L_Pos)                       /*!< FLASH PROCON0: S2L Mask                 */
#define FLASH_PROCON0_S3L_Pos                 3                                                       /*!< FLASH PROCON0: S3L Position             */
#define FLASH_PROCON0_S3L_Msk                 (0x01UL << FLASH_PROCON0_S3L_Pos)                       /*!< FLASH PROCON0: S3L Mask                 */
#define FLASH_PROCON0_S4L_Pos                 4                                                       /*!< FLASH PROCON0: S4L Position             */
#define FLASH_PROCON0_S4L_Msk                 (0x01UL << FLASH_PROCON0_S4L_Pos)                       /*!< FLASH PROCON0: S4L Mask                 */
#define FLASH_PROCON0_S5L_Pos                 5                                                       /*!< FLASH PROCON0: S5L Position             */
#define FLASH_PROCON0_S5L_Msk                 (0x01UL << FLASH_PROCON0_S5L_Pos)                       /*!< FLASH PROCON0: S5L Mask                 */
#define FLASH_PROCON0_S6L_Pos                 6                                                       /*!< FLASH PROCON0: S6L Position             */
#define FLASH_PROCON0_S6L_Msk                 (0x01UL << FLASH_PROCON0_S6L_Pos)                       /*!< FLASH PROCON0: S6L Mask                 */
#define FLASH_PROCON0_S7L_Pos                 7                                                       /*!< FLASH PROCON0: S7L Position             */
#define FLASH_PROCON0_S7L_Msk                 (0x01UL << FLASH_PROCON0_S7L_Pos)                       /*!< FLASH PROCON0: S7L Mask                 */
#define FLASH_PROCON0_S8L_Pos                 8                                                       /*!< FLASH PROCON0: S8L Position             */
#define FLASH_PROCON0_S8L_Msk                 (0x01UL << FLASH_PROCON0_S8L_Pos)                       /*!< FLASH PROCON0: S8L Mask                 */
#define FLASH_PROCON0_RPRO_Pos                15                                                      /*!< FLASH PROCON0: RPRO Position            */
#define FLASH_PROCON0_RPRO_Msk                (0x01UL << FLASH_PROCON0_RPRO_Pos)                      /*!< FLASH PROCON0: RPRO Mask                */

/* --------------------------------  FLASH_PROCON1  ------------------------------- */
#define FLASH_PROCON1_S0L_Pos                 0                                                       /*!< FLASH PROCON1: S0L Position             */
#define FLASH_PROCON1_S0L_Msk                 (0x01UL << FLASH_PROCON1_S0L_Pos)                       /*!< FLASH PROCON1: S0L Mask                 */
#define FLASH_PROCON1_S1L_Pos                 1                                                       /*!< FLASH PROCON1: S1L Position             */
#define FLASH_PROCON1_S1L_Msk                 (0x01UL << FLASH_PROCON1_S1L_Pos)                       /*!< FLASH PROCON1: S1L Mask                 */
#define FLASH_PROCON1_S2L_Pos                 2                                                       /*!< FLASH PROCON1: S2L Position             */
#define FLASH_PROCON1_S2L_Msk                 (0x01UL << FLASH_PROCON1_S2L_Pos)                       /*!< FLASH PROCON1: S2L Mask                 */
#define FLASH_PROCON1_S3L_Pos                 3                                                       /*!< FLASH PROCON1: S3L Position             */
#define FLASH_PROCON1_S3L_Msk                 (0x01UL << FLASH_PROCON1_S3L_Pos)                       /*!< FLASH PROCON1: S3L Mask                 */
#define FLASH_PROCON1_S4L_Pos                 4                                                       /*!< FLASH PROCON1: S4L Position             */
#define FLASH_PROCON1_S4L_Msk                 (0x01UL << FLASH_PROCON1_S4L_Pos)                       /*!< FLASH PROCON1: S4L Mask                 */
#define FLASH_PROCON1_S5L_Pos                 5                                                       /*!< FLASH PROCON1: S5L Position             */
#define FLASH_PROCON1_S5L_Msk                 (0x01UL << FLASH_PROCON1_S5L_Pos)                       /*!< FLASH PROCON1: S5L Mask                 */
#define FLASH_PROCON1_S6L_Pos                 6                                                       /*!< FLASH PROCON1: S6L Position             */
#define FLASH_PROCON1_S6L_Msk                 (0x01UL << FLASH_PROCON1_S6L_Pos)                       /*!< FLASH PROCON1: S6L Mask                 */
#define FLASH_PROCON1_S7L_Pos                 7                                                       /*!< FLASH PROCON1: S7L Position             */
#define FLASH_PROCON1_S7L_Msk                 (0x01UL << FLASH_PROCON1_S7L_Pos)                       /*!< FLASH PROCON1: S7L Mask                 */
#define FLASH_PROCON1_S8L_Pos                 8                                                       /*!< FLASH PROCON1: S8L Position             */
#define FLASH_PROCON1_S8L_Msk                 (0x01UL << FLASH_PROCON1_S8L_Pos)                       /*!< FLASH PROCON1: S8L Mask                 */

/* --------------------------------  FLASH_PROCON2  ------------------------------- */
#define FLASH_PROCON2_S0ROM_Pos               0                                                       /*!< FLASH PROCON2: S0ROM Position           */
#define FLASH_PROCON2_S0ROM_Msk               (0x01UL << FLASH_PROCON2_S0ROM_Pos)                     /*!< FLASH PROCON2: S0ROM Mask               */
#define FLASH_PROCON2_S1ROM_Pos               1                                                       /*!< FLASH PROCON2: S1ROM Position           */
#define FLASH_PROCON2_S1ROM_Msk               (0x01UL << FLASH_PROCON2_S1ROM_Pos)                     /*!< FLASH PROCON2: S1ROM Mask               */
#define FLASH_PROCON2_S2ROM_Pos               2                                                       /*!< FLASH PROCON2: S2ROM Position           */
#define FLASH_PROCON2_S2ROM_Msk               (0x01UL << FLASH_PROCON2_S2ROM_Pos)                     /*!< FLASH PROCON2: S2ROM Mask               */
#define FLASH_PROCON2_S3ROM_Pos               3                                                       /*!< FLASH PROCON2: S3ROM Position           */
#define FLASH_PROCON2_S3ROM_Msk               (0x01UL << FLASH_PROCON2_S3ROM_Pos)                     /*!< FLASH PROCON2: S3ROM Mask               */
#define FLASH_PROCON2_S4ROM_Pos               4                                                       /*!< FLASH PROCON2: S4ROM Position           */
#define FLASH_PROCON2_S4ROM_Msk               (0x01UL << FLASH_PROCON2_S4ROM_Pos)                     /*!< FLASH PROCON2: S4ROM Mask               */
#define FLASH_PROCON2_S5ROM_Pos               5                                                       /*!< FLASH PROCON2: S5ROM Position           */
#define FLASH_PROCON2_S5ROM_Msk               (0x01UL << FLASH_PROCON2_S5ROM_Pos)                     /*!< FLASH PROCON2: S5ROM Mask               */
#define FLASH_PROCON2_S6ROM_Pos               6                                                       /*!< FLASH PROCON2: S6ROM Position           */
#define FLASH_PROCON2_S6ROM_Msk               (0x01UL << FLASH_PROCON2_S6ROM_Pos)                     /*!< FLASH PROCON2: S6ROM Mask               */
#define FLASH_PROCON2_S7ROM_Pos               7                                                       /*!< FLASH PROCON2: S7ROM Position           */
#define FLASH_PROCON2_S7ROM_Msk               (0x01UL << FLASH_PROCON2_S7ROM_Pos)                     /*!< FLASH PROCON2: S7ROM Mask               */
#define FLASH_PROCON2_S8ROM_Pos               8                                                       /*!< FLASH PROCON2: S8ROM Position           */
#define FLASH_PROCON2_S8ROM_Msk               (0x01UL << FLASH_PROCON2_S8ROM_Pos)                     /*!< FLASH PROCON2: S8ROM Mask               */


/* ================================================================================ */
/* ================          struct 'PREF' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  PREF_PCON  --------------------------------- */
#define PREF_PCON_IBYP_Pos                    0                                                       /*!< PREF PCON: IBYP Position                */
#define PREF_PCON_IBYP_Msk                    (0x01UL << PREF_PCON_IBYP_Pos)                          /*!< PREF PCON: IBYP Mask                    */
#define PREF_PCON_IINV_Pos                    1                                                       /*!< PREF PCON: IINV Position                */
#define PREF_PCON_IINV_Msk                    (0x01UL << PREF_PCON_IINV_Pos)                          /*!< PREF PCON: IINV Mask                    */
#define PREF_PCON_DBYP_Pos                    4                                                       /*!< PREF PCON: DBYP Position                */
#define PREF_PCON_DBYP_Msk                    (0x01UL << PREF_PCON_DBYP_Pos)                          /*!< PREF PCON: DBYP Mask                    */


/* ================================================================================ */
/* ================           Group 'PMU' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PMU_ID  ----------------------------------- */
#define PMU_ID_MOD_REV_Pos                    0                                                       /*!< PMU ID: MOD_REV Position                */
#define PMU_ID_MOD_REV_Msk                    (0x000000ffUL << PMU_ID_MOD_REV_Pos)                    /*!< PMU ID: MOD_REV Mask                    */
#define PMU_ID_MOD_TYPE_Pos                   8                                                       /*!< PMU ID: MOD_TYPE Position               */
#define PMU_ID_MOD_TYPE_Msk                   (0x000000ffUL << PMU_ID_MOD_TYPE_Pos)                   /*!< PMU ID: MOD_TYPE Mask                   */
#define PMU_ID_MOD_NUMBER_Pos                 16                                                      /*!< PMU ID: MOD_NUMBER Position             */
#define PMU_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << PMU_ID_MOD_NUMBER_Pos)                 /*!< PMU ID: MOD_NUMBER Mask                 */


/* ================================================================================ */
/* ================          struct 'WDT' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  WDT_ID  ----------------------------------- */
#define WDT_ID_MOD_REV_Pos                    0                                                       /*!< WDT ID: MOD_REV Position                */
#define WDT_ID_MOD_REV_Msk                    (0x000000ffUL << WDT_ID_MOD_REV_Pos)                    /*!< WDT ID: MOD_REV Mask                    */
#define WDT_ID_MOD_TYPE_Pos                   8                                                       /*!< WDT ID: MOD_TYPE Position               */
#define WDT_ID_MOD_TYPE_Msk                   (0x000000ffUL << WDT_ID_MOD_TYPE_Pos)                   /*!< WDT ID: MOD_TYPE Mask                   */
#define WDT_ID_MOD_NUMBER_Pos                 16                                                      /*!< WDT ID: MOD_NUMBER Position             */
#define WDT_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << WDT_ID_MOD_NUMBER_Pos)                 /*!< WDT ID: MOD_NUMBER Mask                 */

/* -----------------------------------  WDT_CTR  ---------------------------------- */
#define WDT_CTR_ENB_Pos                       0                                                       /*!< WDT CTR: ENB Position                   */
#define WDT_CTR_ENB_Msk                       (0x01UL << WDT_CTR_ENB_Pos)                             /*!< WDT CTR: ENB Mask                       */
#define WDT_CTR_PRE_Pos                       1                                                       /*!< WDT CTR: PRE Position                   */
#define WDT_CTR_PRE_Msk                       (0x01UL << WDT_CTR_PRE_Pos)                             /*!< WDT CTR: PRE Mask                       */
#define WDT_CTR_DSP_Pos                       4                                                       /*!< WDT CTR: DSP Position                   */
#define WDT_CTR_DSP_Msk                       (0x01UL << WDT_CTR_DSP_Pos)                             /*!< WDT CTR: DSP Mask                       */
#define WDT_CTR_SPW_Pos                       8                                                       /*!< WDT CTR: SPW Position                   */
#define WDT_CTR_SPW_Msk                       (0x000000ffUL << WDT_CTR_SPW_Pos)                       /*!< WDT CTR: SPW Mask                       */

/* -----------------------------------  WDT_SRV  ---------------------------------- */
#define WDT_SRV_SRV_Pos                       0                                                       /*!< WDT SRV: SRV Position                   */
#define WDT_SRV_SRV_Msk                       (0xffffffffUL << WDT_SRV_SRV_Pos)                       /*!< WDT SRV: SRV Mask                       */

/* -----------------------------------  WDT_TIM  ---------------------------------- */
#define WDT_TIM_TIM_Pos                       0                                                       /*!< WDT TIM: TIM Position                   */
#define WDT_TIM_TIM_Msk                       (0xffffffffUL << WDT_TIM_TIM_Pos)                       /*!< WDT TIM: TIM Mask                       */

/* -----------------------------------  WDT_WLB  ---------------------------------- */
#define WDT_WLB_WLB_Pos                       0                                                       /*!< WDT WLB: WLB Position                   */
#define WDT_WLB_WLB_Msk                       (0xffffffffUL << WDT_WLB_WLB_Pos)                       /*!< WDT WLB: WLB Mask                       */

/* -----------------------------------  WDT_WUB  ---------------------------------- */
#define WDT_WUB_WUB_Pos                       0                                                       /*!< WDT WUB: WUB Position                   */
#define WDT_WUB_WUB_Msk                       (0xffffffffUL << WDT_WUB_WUB_Pos)                       /*!< WDT WUB: WUB Mask                       */

/* ---------------------------------  WDT_WDTSTS  --------------------------------- */
#define WDT_WDTSTS_ALMS_Pos                   0                                                       /*!< WDT WDTSTS: ALMS Position               */
#define WDT_WDTSTS_ALMS_Msk                   (0x01UL << WDT_WDTSTS_ALMS_Pos)                         /*!< WDT WDTSTS: ALMS Mask                   */

/* ---------------------------------  WDT_WDTCLR  --------------------------------- */
#define WDT_WDTCLR_ALMC_Pos                   0                                                       /*!< WDT WDTCLR: ALMC Position               */
#define WDT_WDTCLR_ALMC_Msk                   (0x01UL << WDT_WDTCLR_ALMC_Pos)                         /*!< WDT WDTCLR: ALMC Mask                   */


/* ================================================================================ */
/* ================          struct 'RTC' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  RTC_ID  ----------------------------------- */
#define RTC_ID_MOD_REV_Pos                    0                                                       /*!< RTC ID: MOD_REV Position                */
#define RTC_ID_MOD_REV_Msk                    (0x000000ffUL << RTC_ID_MOD_REV_Pos)                    /*!< RTC ID: MOD_REV Mask                    */
#define RTC_ID_MOD_TYPE_Pos                   8                                                       /*!< RTC ID: MOD_TYPE Position               */
#define RTC_ID_MOD_TYPE_Msk                   (0x000000ffUL << RTC_ID_MOD_TYPE_Pos)                   /*!< RTC ID: MOD_TYPE Mask                   */
#define RTC_ID_MOD_NUMBER_Pos                 16                                                      /*!< RTC ID: MOD_NUMBER Position             */
#define RTC_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << RTC_ID_MOD_NUMBER_Pos)                 /*!< RTC ID: MOD_NUMBER Mask                 */

/* -----------------------------------  RTC_CTR  ---------------------------------- */
#define RTC_CTR_ENB_Pos                       0                                                       /*!< RTC CTR: ENB Position                   */
#define RTC_CTR_ENB_Msk                       (0x01UL << RTC_CTR_ENB_Pos)                             /*!< RTC CTR: ENB Mask                       */
#define RTC_CTR_TAE_Pos                       2                                                       /*!< RTC CTR: TAE Position                   */
#define RTC_CTR_TAE_Msk                       (0x01UL << RTC_CTR_TAE_Pos)                             /*!< RTC CTR: TAE Mask                       */
#define RTC_CTR_ESEC_Pos                      8                                                       /*!< RTC CTR: ESEC Position                  */
#define RTC_CTR_ESEC_Msk                      (0x01UL << RTC_CTR_ESEC_Pos)                            /*!< RTC CTR: ESEC Mask                      */
#define RTC_CTR_EMIC_Pos                      9                                                       /*!< RTC CTR: EMIC Position                  */
#define RTC_CTR_EMIC_Msk                      (0x01UL << RTC_CTR_EMIC_Pos)                            /*!< RTC CTR: EMIC Mask                      */
#define RTC_CTR_EHOC_Pos                      10                                                      /*!< RTC CTR: EHOC Position                  */
#define RTC_CTR_EHOC_Msk                      (0x01UL << RTC_CTR_EHOC_Pos)                            /*!< RTC CTR: EHOC Mask                      */
#define RTC_CTR_EDAC_Pos                      11                                                      /*!< RTC CTR: EDAC Position                  */
#define RTC_CTR_EDAC_Msk                      (0x01UL << RTC_CTR_EDAC_Pos)                            /*!< RTC CTR: EDAC Mask                      */
#define RTC_CTR_EMOC_Pos                      13                                                      /*!< RTC CTR: EMOC Position                  */
#define RTC_CTR_EMOC_Msk                      (0x01UL << RTC_CTR_EMOC_Pos)                            /*!< RTC CTR: EMOC Mask                      */
#define RTC_CTR_EYEC_Pos                      14                                                      /*!< RTC CTR: EYEC Position                  */
#define RTC_CTR_EYEC_Msk                      (0x01UL << RTC_CTR_EYEC_Pos)                            /*!< RTC CTR: EYEC Mask                      */
#define RTC_CTR_DIV_Pos                       16                                                      /*!< RTC CTR: DIV Position                   */
#define RTC_CTR_DIV_Msk                       (0x0000ffffUL << RTC_CTR_DIV_Pos)                       /*!< RTC CTR: DIV Mask                       */

/* ---------------------------------  RTC_RAWSTAT  -------------------------------- */
#define RTC_RAWSTAT_RPSE_Pos                  0                                                       /*!< RTC RAWSTAT: RPSE Position              */
#define RTC_RAWSTAT_RPSE_Msk                  (0x01UL << RTC_RAWSTAT_RPSE_Pos)                        /*!< RTC RAWSTAT: RPSE Mask                  */
#define RTC_RAWSTAT_RPMI_Pos                  1                                                       /*!< RTC RAWSTAT: RPMI Position              */
#define RTC_RAWSTAT_RPMI_Msk                  (0x01UL << RTC_RAWSTAT_RPMI_Pos)                        /*!< RTC RAWSTAT: RPMI Mask                  */
#define RTC_RAWSTAT_RPHO_Pos                  2                                                       /*!< RTC RAWSTAT: RPHO Position              */
#define RTC_RAWSTAT_RPHO_Msk                  (0x01UL << RTC_RAWSTAT_RPHO_Pos)                        /*!< RTC RAWSTAT: RPHO Mask                  */
#define RTC_RAWSTAT_RPDA_Pos                  3                                                       /*!< RTC RAWSTAT: RPDA Position              */
#define RTC_RAWSTAT_RPDA_Msk                  (0x01UL << RTC_RAWSTAT_RPDA_Pos)                        /*!< RTC RAWSTAT: RPDA Mask                  */
#define RTC_RAWSTAT_RPMO_Pos                  5                                                       /*!< RTC RAWSTAT: RPMO Position              */
#define RTC_RAWSTAT_RPMO_Msk                  (0x01UL << RTC_RAWSTAT_RPMO_Pos)                        /*!< RTC RAWSTAT: RPMO Mask                  */
#define RTC_RAWSTAT_RPYE_Pos                  6                                                       /*!< RTC RAWSTAT: RPYE Position              */
#define RTC_RAWSTAT_RPYE_Msk                  (0x01UL << RTC_RAWSTAT_RPYE_Pos)                        /*!< RTC RAWSTAT: RPYE Mask                  */
#define RTC_RAWSTAT_RAI_Pos                   8                                                       /*!< RTC RAWSTAT: RAI Position               */
#define RTC_RAWSTAT_RAI_Msk                   (0x01UL << RTC_RAWSTAT_RAI_Pos)                         /*!< RTC RAWSTAT: RAI Mask                   */

/* ----------------------------------  RTC_STSSR  --------------------------------- */
#define RTC_STSSR_SPSE_Pos                    0                                                       /*!< RTC STSSR: SPSE Position                */
#define RTC_STSSR_SPSE_Msk                    (0x01UL << RTC_STSSR_SPSE_Pos)                          /*!< RTC STSSR: SPSE Mask                    */
#define RTC_STSSR_SPMI_Pos                    1                                                       /*!< RTC STSSR: SPMI Position                */
#define RTC_STSSR_SPMI_Msk                    (0x01UL << RTC_STSSR_SPMI_Pos)                          /*!< RTC STSSR: SPMI Mask                    */
#define RTC_STSSR_SPHO_Pos                    2                                                       /*!< RTC STSSR: SPHO Position                */
#define RTC_STSSR_SPHO_Msk                    (0x01UL << RTC_STSSR_SPHO_Pos)                          /*!< RTC STSSR: SPHO Mask                    */
#define RTC_STSSR_SPDA_Pos                    3                                                       /*!< RTC STSSR: SPDA Position                */
#define RTC_STSSR_SPDA_Msk                    (0x01UL << RTC_STSSR_SPDA_Pos)                          /*!< RTC STSSR: SPDA Mask                    */
#define RTC_STSSR_SPMO_Pos                    5                                                       /*!< RTC STSSR: SPMO Position                */
#define RTC_STSSR_SPMO_Msk                    (0x01UL << RTC_STSSR_SPMO_Pos)                          /*!< RTC STSSR: SPMO Mask                    */
#define RTC_STSSR_SPYE_Pos                    6                                                       /*!< RTC STSSR: SPYE Position                */
#define RTC_STSSR_SPYE_Msk                    (0x01UL << RTC_STSSR_SPYE_Pos)                          /*!< RTC STSSR: SPYE Mask                    */
#define RTC_STSSR_SAI_Pos                     8                                                       /*!< RTC STSSR: SAI Position                 */
#define RTC_STSSR_SAI_Msk                     (0x01UL << RTC_STSSR_SAI_Pos)                           /*!< RTC STSSR: SAI Mask                     */

/* ----------------------------------  RTC_MSKSR  --------------------------------- */
#define RTC_MSKSR_MPSE_Pos                    0                                                       /*!< RTC MSKSR: MPSE Position                */
#define RTC_MSKSR_MPSE_Msk                    (0x01UL << RTC_MSKSR_MPSE_Pos)                          /*!< RTC MSKSR: MPSE Mask                    */
#define RTC_MSKSR_MPMI_Pos                    1                                                       /*!< RTC MSKSR: MPMI Position                */
#define RTC_MSKSR_MPMI_Msk                    (0x01UL << RTC_MSKSR_MPMI_Pos)                          /*!< RTC MSKSR: MPMI Mask                    */
#define RTC_MSKSR_MPHO_Pos                    2                                                       /*!< RTC MSKSR: MPHO Position                */
#define RTC_MSKSR_MPHO_Msk                    (0x01UL << RTC_MSKSR_MPHO_Pos)                          /*!< RTC MSKSR: MPHO Mask                    */
#define RTC_MSKSR_MPDA_Pos                    3                                                       /*!< RTC MSKSR: MPDA Position                */
#define RTC_MSKSR_MPDA_Msk                    (0x01UL << RTC_MSKSR_MPDA_Pos)                          /*!< RTC MSKSR: MPDA Mask                    */
#define RTC_MSKSR_MPMO_Pos                    5                                                       /*!< RTC MSKSR: MPMO Position                */
#define RTC_MSKSR_MPMO_Msk                    (0x01UL << RTC_MSKSR_MPMO_Pos)                          /*!< RTC MSKSR: MPMO Mask                    */
#define RTC_MSKSR_MPYE_Pos                    6                                                       /*!< RTC MSKSR: MPYE Position                */
#define RTC_MSKSR_MPYE_Msk                    (0x01UL << RTC_MSKSR_MPYE_Pos)                          /*!< RTC MSKSR: MPYE Mask                    */
#define RTC_MSKSR_MAI_Pos                     8                                                       /*!< RTC MSKSR: MAI Position                 */
#define RTC_MSKSR_MAI_Msk                     (0x01UL << RTC_MSKSR_MAI_Pos)                           /*!< RTC MSKSR: MAI Mask                     */

/* ----------------------------------  RTC_CLRSR  --------------------------------- */
#define RTC_CLRSR_RPSE_Pos                    0                                                       /*!< RTC CLRSR: RPSE Position                */
#define RTC_CLRSR_RPSE_Msk                    (0x01UL << RTC_CLRSR_RPSE_Pos)                          /*!< RTC CLRSR: RPSE Mask                    */
#define RTC_CLRSR_RPMI_Pos                    1                                                       /*!< RTC CLRSR: RPMI Position                */
#define RTC_CLRSR_RPMI_Msk                    (0x01UL << RTC_CLRSR_RPMI_Pos)                          /*!< RTC CLRSR: RPMI Mask                    */
#define RTC_CLRSR_RPHO_Pos                    2                                                       /*!< RTC CLRSR: RPHO Position                */
#define RTC_CLRSR_RPHO_Msk                    (0x01UL << RTC_CLRSR_RPHO_Pos)                          /*!< RTC CLRSR: RPHO Mask                    */
#define RTC_CLRSR_RPDA_Pos                    3                                                       /*!< RTC CLRSR: RPDA Position                */
#define RTC_CLRSR_RPDA_Msk                    (0x01UL << RTC_CLRSR_RPDA_Pos)                          /*!< RTC CLRSR: RPDA Mask                    */
#define RTC_CLRSR_RPMO_Pos                    5                                                       /*!< RTC CLRSR: RPMO Position                */
#define RTC_CLRSR_RPMO_Msk                    (0x01UL << RTC_CLRSR_RPMO_Pos)                          /*!< RTC CLRSR: RPMO Mask                    */
#define RTC_CLRSR_RPYE_Pos                    6                                                       /*!< RTC CLRSR: RPYE Position                */
#define RTC_CLRSR_RPYE_Msk                    (0x01UL << RTC_CLRSR_RPYE_Pos)                          /*!< RTC CLRSR: RPYE Mask                    */
#define RTC_CLRSR_RAI_Pos                     8                                                       /*!< RTC CLRSR: RAI Position                 */
#define RTC_CLRSR_RAI_Msk                     (0x01UL << RTC_CLRSR_RAI_Pos)                           /*!< RTC CLRSR: RAI Mask                     */

/* ----------------------------------  RTC_ATIM0  --------------------------------- */
#define RTC_ATIM0_ASE_Pos                     0                                                       /*!< RTC ATIM0: ASE Position                 */
#define RTC_ATIM0_ASE_Msk                     (0x3fUL << RTC_ATIM0_ASE_Pos)                           /*!< RTC ATIM0: ASE Mask                     */
#define RTC_ATIM0_AMI_Pos                     8                                                       /*!< RTC ATIM0: AMI Position                 */
#define RTC_ATIM0_AMI_Msk                     (0x3fUL << RTC_ATIM0_AMI_Pos)                           /*!< RTC ATIM0: AMI Mask                     */
#define RTC_ATIM0_AHO_Pos                     16                                                      /*!< RTC ATIM0: AHO Position                 */
#define RTC_ATIM0_AHO_Msk                     (0x1fUL << RTC_ATIM0_AHO_Pos)                           /*!< RTC ATIM0: AHO Mask                     */
#define RTC_ATIM0_ADA_Pos                     24                                                      /*!< RTC ATIM0: ADA Position                 */
#define RTC_ATIM0_ADA_Msk                     (0x1fUL << RTC_ATIM0_ADA_Pos)                           /*!< RTC ATIM0: ADA Mask                     */

/* ----------------------------------  RTC_ATIM1  --------------------------------- */
#define RTC_ATIM1_AMO_Pos                     8                                                       /*!< RTC ATIM1: AMO Position                 */
#define RTC_ATIM1_AMO_Msk                     (0x0fUL << RTC_ATIM1_AMO_Pos)                           /*!< RTC ATIM1: AMO Mask                     */
#define RTC_ATIM1_AYE_Pos                     16                                                      /*!< RTC ATIM1: AYE Position                 */
#define RTC_ATIM1_AYE_Msk                     (0x0000ffffUL << RTC_ATIM1_AYE_Pos)                     /*!< RTC ATIM1: AYE Mask                     */

/* ----------------------------------  RTC_TIM0  ---------------------------------- */
#define RTC_TIM0_SE_Pos                       0                                                       /*!< RTC TIM0: SE Position                   */
#define RTC_TIM0_SE_Msk                       (0x3fUL << RTC_TIM0_SE_Pos)                             /*!< RTC TIM0: SE Mask                       */
#define RTC_TIM0_MI_Pos                       8                                                       /*!< RTC TIM0: MI Position                   */
#define RTC_TIM0_MI_Msk                       (0x3fUL << RTC_TIM0_MI_Pos)                             /*!< RTC TIM0: MI Mask                       */
#define RTC_TIM0_HO_Pos                       16                                                      /*!< RTC TIM0: HO Position                   */
#define RTC_TIM0_HO_Msk                       (0x1fUL << RTC_TIM0_HO_Pos)                             /*!< RTC TIM0: HO Mask                       */
#define RTC_TIM0_DA_Pos                       24                                                      /*!< RTC TIM0: DA Position                   */
#define RTC_TIM0_DA_Msk                       (0x1fUL << RTC_TIM0_DA_Pos)                             /*!< RTC TIM0: DA Mask                       */

/* ----------------------------------  RTC_TIM1  ---------------------------------- */
#define RTC_TIM1_DAWE_Pos                     0                                                       /*!< RTC TIM1: DAWE Position                 */
#define RTC_TIM1_DAWE_Msk                     (0x07UL << RTC_TIM1_DAWE_Pos)                           /*!< RTC TIM1: DAWE Mask                     */
#define RTC_TIM1_MO_Pos                       8                                                       /*!< RTC TIM1: MO Position                   */
#define RTC_TIM1_MO_Msk                       (0x0fUL << RTC_TIM1_MO_Pos)                             /*!< RTC TIM1: MO Mask                       */
#define RTC_TIM1_YE_Pos                       16                                                      /*!< RTC TIM1: YE Position                   */
#define RTC_TIM1_YE_Msk                       (0x0000ffffUL << RTC_TIM1_YE_Pos)                       /*!< RTC TIM1: YE Mask                       */


/* ================================================================================ */
/* ================        struct 'SCU_CLK' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_CLK_CLKSTAT  ------------------------------ */
#define SCU_CLK_CLKSTAT_USBCST_Pos            0                                                       /*!< SCU_CLK CLKSTAT: USBCST Position        */
#define SCU_CLK_CLKSTAT_USBCST_Msk            (0x01UL << SCU_CLK_CLKSTAT_USBCST_Pos)                  /*!< SCU_CLK CLKSTAT: USBCST Mask            */
#define SCU_CLK_CLKSTAT_CCUCST_Pos            4                                                       /*!< SCU_CLK CLKSTAT: CCUCST Position        */
#define SCU_CLK_CLKSTAT_CCUCST_Msk            (0x01UL << SCU_CLK_CLKSTAT_CCUCST_Pos)                  /*!< SCU_CLK CLKSTAT: CCUCST Mask            */
#define SCU_CLK_CLKSTAT_WDTCST_Pos            5                                                       /*!< SCU_CLK CLKSTAT: WDTCST Position        */
#define SCU_CLK_CLKSTAT_WDTCST_Msk            (0x01UL << SCU_CLK_CLKSTAT_WDTCST_Pos)                  /*!< SCU_CLK CLKSTAT: WDTCST Mask            */

/* -------------------------------  SCU_CLK_CLKSET  ------------------------------- */
#define SCU_CLK_CLKSET_USBCEN_Pos             0                                                       /*!< SCU_CLK CLKSET: USBCEN Position         */
#define SCU_CLK_CLKSET_USBCEN_Msk             (0x01UL << SCU_CLK_CLKSET_USBCEN_Pos)                   /*!< SCU_CLK CLKSET: USBCEN Mask             */
#define SCU_CLK_CLKSET_CCUCEN_Pos             4                                                       /*!< SCU_CLK CLKSET: CCUCEN Position         */
#define SCU_CLK_CLKSET_CCUCEN_Msk             (0x01UL << SCU_CLK_CLKSET_CCUCEN_Pos)                   /*!< SCU_CLK CLKSET: CCUCEN Mask             */
#define SCU_CLK_CLKSET_WDTCEN_Pos             5                                                       /*!< SCU_CLK CLKSET: WDTCEN Position         */
#define SCU_CLK_CLKSET_WDTCEN_Msk             (0x01UL << SCU_CLK_CLKSET_WDTCEN_Pos)                   /*!< SCU_CLK CLKSET: WDTCEN Mask             */

/* -------------------------------  SCU_CLK_CLKCLR  ------------------------------- */
#define SCU_CLK_CLKCLR_USBCDI_Pos             0                                                       /*!< SCU_CLK CLKCLR: USBCDI Position         */
#define SCU_CLK_CLKCLR_USBCDI_Msk             (0x01UL << SCU_CLK_CLKCLR_USBCDI_Pos)                   /*!< SCU_CLK CLKCLR: USBCDI Mask             */
#define SCU_CLK_CLKCLR_CCUCDI_Pos             4                                                       /*!< SCU_CLK CLKCLR: CCUCDI Position         */
#define SCU_CLK_CLKCLR_CCUCDI_Msk             (0x01UL << SCU_CLK_CLKCLR_CCUCDI_Pos)                   /*!< SCU_CLK CLKCLR: CCUCDI Mask             */
#define SCU_CLK_CLKCLR_WDTCDI_Pos             5                                                       /*!< SCU_CLK CLKCLR: WDTCDI Position         */
#define SCU_CLK_CLKCLR_WDTCDI_Msk             (0x01UL << SCU_CLK_CLKCLR_WDTCDI_Pos)                   /*!< SCU_CLK CLKCLR: WDTCDI Mask             */

/* ------------------------------  SCU_CLK_SYSCLKCR  ------------------------------ */
#define SCU_CLK_SYSCLKCR_SYSDIV_Pos           0                                                       /*!< SCU_CLK SYSCLKCR: SYSDIV Position       */
#define SCU_CLK_SYSCLKCR_SYSDIV_Msk           (0x000000ffUL << SCU_CLK_SYSCLKCR_SYSDIV_Pos)           /*!< SCU_CLK SYSCLKCR: SYSDIV Mask           */
#define SCU_CLK_SYSCLKCR_SYSSEL_Pos           16                                                      /*!< SCU_CLK SYSCLKCR: SYSSEL Position       */
#define SCU_CLK_SYSCLKCR_SYSSEL_Msk           (0x01UL << SCU_CLK_SYSCLKCR_SYSSEL_Pos)                 /*!< SCU_CLK SYSCLKCR: SYSSEL Mask           */

/* ------------------------------  SCU_CLK_CPUCLKCR  ------------------------------ */
#define SCU_CLK_CPUCLKCR_CPUDIV_Pos           0                                                       /*!< SCU_CLK CPUCLKCR: CPUDIV Position       */
#define SCU_CLK_CPUCLKCR_CPUDIV_Msk           (0x01UL << SCU_CLK_CPUCLKCR_CPUDIV_Pos)                 /*!< SCU_CLK CPUCLKCR: CPUDIV Mask           */

/* -------------------------------  SCU_CLK_PBCLKCR  ------------------------------ */
#define SCU_CLK_PBCLKCR_PBDIV_Pos             0                                                       /*!< SCU_CLK PBCLKCR: PBDIV Position         */
#define SCU_CLK_PBCLKCR_PBDIV_Msk             (0x01UL << SCU_CLK_PBCLKCR_PBDIV_Pos)                   /*!< SCU_CLK PBCLKCR: PBDIV Mask             */

/* ------------------------------  SCU_CLK_USBCLKCR  ------------------------------ */
#define SCU_CLK_USBCLKCR_USBDIV_Pos           0                                                       /*!< SCU_CLK USBCLKCR: USBDIV Position       */
#define SCU_CLK_USBCLKCR_USBDIV_Msk           (0x07UL << SCU_CLK_USBCLKCR_USBDIV_Pos)                 /*!< SCU_CLK USBCLKCR: USBDIV Mask           */
#define SCU_CLK_USBCLKCR_USBSEL_Pos           16                                                      /*!< SCU_CLK USBCLKCR: USBSEL Position       */
#define SCU_CLK_USBCLKCR_USBSEL_Msk           (0x01UL << SCU_CLK_USBCLKCR_USBSEL_Pos)                 /*!< SCU_CLK USBCLKCR: USBSEL Mask           */

/* ------------------------------  SCU_CLK_CCUCLKCR  ------------------------------ */
#define SCU_CLK_CCUCLKCR_CCUDIV_Pos           0                                                       /*!< SCU_CLK CCUCLKCR: CCUDIV Position       */
#define SCU_CLK_CCUCLKCR_CCUDIV_Msk           (0x01UL << SCU_CLK_CCUCLKCR_CCUDIV_Pos)                 /*!< SCU_CLK CCUCLKCR: CCUDIV Mask           */

/* ------------------------------  SCU_CLK_WDTCLKCR  ------------------------------ */
#define SCU_CLK_WDTCLKCR_WDTDIV_Pos           0                                                       /*!< SCU_CLK WDTCLKCR: WDTDIV Position       */
#define SCU_CLK_WDTCLKCR_WDTDIV_Msk           (0x000000ffUL << SCU_CLK_WDTCLKCR_WDTDIV_Pos)           /*!< SCU_CLK WDTCLKCR: WDTDIV Mask           */
#define SCU_CLK_WDTCLKCR_WDTSEL_Pos           16                                                      /*!< SCU_CLK WDTCLKCR: WDTSEL Position       */
#define SCU_CLK_WDTCLKCR_WDTSEL_Msk           (0x03UL << SCU_CLK_WDTCLKCR_WDTSEL_Pos)                 /*!< SCU_CLK WDTCLKCR: WDTSEL Mask           */

/* ------------------------------  SCU_CLK_EXTCLKCR  ------------------------------ */
#define SCU_CLK_EXTCLKCR_ECKSEL_Pos           0                                                       /*!< SCU_CLK EXTCLKCR: ECKSEL Position       */
#define SCU_CLK_EXTCLKCR_ECKSEL_Msk           (0x07UL << SCU_CLK_EXTCLKCR_ECKSEL_Pos)                 /*!< SCU_CLK EXTCLKCR: ECKSEL Mask           */
#define SCU_CLK_EXTCLKCR_ECKDIV_Pos           16                                                      /*!< SCU_CLK EXTCLKCR: ECKDIV Position       */
#define SCU_CLK_EXTCLKCR_ECKDIV_Msk           (0x000001ffUL << SCU_CLK_EXTCLKCR_ECKDIV_Pos)           /*!< SCU_CLK EXTCLKCR: ECKDIV Mask           */

/* -----------------------------  SCU_CLK_MLINKCLKCR  ----------------------------- */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Pos         0                                                       /*!< SCU_CLK MLINKCLKCR: SYSDIV Position     */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Msk         (0x000000ffUL << SCU_CLK_MLINKCLKCR_SYSDIV_Pos)         /*!< SCU_CLK MLINKCLKCR: SYSDIV Mask         */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Pos         8                                                       /*!< SCU_CLK MLINKCLKCR: SYSSEL Position     */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Msk         (0x01UL << SCU_CLK_MLINKCLKCR_SYSSEL_Pos)               /*!< SCU_CLK MLINKCLKCR: SYSSEL Mask         */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Pos         10                                                      /*!< SCU_CLK MLINKCLKCR: CPUDIV Position     */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Msk         (0x01UL << SCU_CLK_MLINKCLKCR_CPUDIV_Pos)               /*!< SCU_CLK MLINKCLKCR: CPUDIV Mask         */
#define SCU_CLK_MLINKCLKCR_PBDIV_Pos          12                                                      /*!< SCU_CLK MLINKCLKCR: PBDIV Position      */
#define SCU_CLK_MLINKCLKCR_PBDIV_Msk          (0x01UL << SCU_CLK_MLINKCLKCR_PBDIV_Pos)                /*!< SCU_CLK MLINKCLKCR: PBDIV Mask          */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Pos         14                                                      /*!< SCU_CLK MLINKCLKCR: CCUDIV Position     */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Msk         (0x01UL << SCU_CLK_MLINKCLKCR_CCUDIV_Pos)               /*!< SCU_CLK MLINKCLKCR: CCUDIV Mask         */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Pos         16                                                      /*!< SCU_CLK MLINKCLKCR: WDTDIV Position     */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Msk         (0x000000ffUL << SCU_CLK_MLINKCLKCR_WDTDIV_Pos)         /*!< SCU_CLK MLINKCLKCR: WDTDIV Mask         */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Pos         24                                                      /*!< SCU_CLK MLINKCLKCR: WDTSEL Position     */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Msk         (0x03UL << SCU_CLK_MLINKCLKCR_WDTSEL_Pos)               /*!< SCU_CLK MLINKCLKCR: WDTSEL Mask         */

/* -------------------------------  SCU_CLK_SLEEPCR  ------------------------------ */
#define SCU_CLK_SLEEPCR_SYSSEL_Pos            0                                                       /*!< SCU_CLK SLEEPCR: SYSSEL Position        */
#define SCU_CLK_SLEEPCR_SYSSEL_Msk            (0x01UL << SCU_CLK_SLEEPCR_SYSSEL_Pos)                  /*!< SCU_CLK SLEEPCR: SYSSEL Mask            */
#define SCU_CLK_SLEEPCR_USBCR_Pos             16                                                      /*!< SCU_CLK SLEEPCR: USBCR Position         */
#define SCU_CLK_SLEEPCR_USBCR_Msk             (0x01UL << SCU_CLK_SLEEPCR_USBCR_Pos)                   /*!< SCU_CLK SLEEPCR: USBCR Mask             */
#define SCU_CLK_SLEEPCR_CCUCR_Pos             20                                                      /*!< SCU_CLK SLEEPCR: CCUCR Position         */
#define SCU_CLK_SLEEPCR_CCUCR_Msk             (0x01UL << SCU_CLK_SLEEPCR_CCUCR_Pos)                   /*!< SCU_CLK SLEEPCR: CCUCR Mask             */
#define SCU_CLK_SLEEPCR_WDTCR_Pos             21                                                      /*!< SCU_CLK SLEEPCR: WDTCR Position         */
#define SCU_CLK_SLEEPCR_WDTCR_Msk             (0x01UL << SCU_CLK_SLEEPCR_WDTCR_Pos)                   /*!< SCU_CLK SLEEPCR: WDTCR Mask             */

/* ------------------------------  SCU_CLK_DSLEEPCR  ------------------------------ */
#define SCU_CLK_DSLEEPCR_SYSSEL_Pos           0                                                       /*!< SCU_CLK DSLEEPCR: SYSSEL Position       */
#define SCU_CLK_DSLEEPCR_SYSSEL_Msk           (0x01UL << SCU_CLK_DSLEEPCR_SYSSEL_Pos)                 /*!< SCU_CLK DSLEEPCR: SYSSEL Mask           */
#define SCU_CLK_DSLEEPCR_FPDN_Pos             11                                                      /*!< SCU_CLK DSLEEPCR: FPDN Position         */
#define SCU_CLK_DSLEEPCR_FPDN_Msk             (0x01UL << SCU_CLK_DSLEEPCR_FPDN_Pos)                   /*!< SCU_CLK DSLEEPCR: FPDN Mask             */
#define SCU_CLK_DSLEEPCR_PLLPDN_Pos           12                                                      /*!< SCU_CLK DSLEEPCR: PLLPDN Position       */
#define SCU_CLK_DSLEEPCR_PLLPDN_Msk           (0x01UL << SCU_CLK_DSLEEPCR_PLLPDN_Pos)                 /*!< SCU_CLK DSLEEPCR: PLLPDN Mask           */
#define SCU_CLK_DSLEEPCR_VCOPDN_Pos           13                                                      /*!< SCU_CLK DSLEEPCR: VCOPDN Position       */
#define SCU_CLK_DSLEEPCR_VCOPDN_Msk           (0x01UL << SCU_CLK_DSLEEPCR_VCOPDN_Pos)                 /*!< SCU_CLK DSLEEPCR: VCOPDN Mask           */
#define SCU_CLK_DSLEEPCR_USBCR_Pos            16                                                      /*!< SCU_CLK DSLEEPCR: USBCR Position        */
#define SCU_CLK_DSLEEPCR_USBCR_Msk            (0x01UL << SCU_CLK_DSLEEPCR_USBCR_Pos)                  /*!< SCU_CLK DSLEEPCR: USBCR Mask            */
#define SCU_CLK_DSLEEPCR_CCUCR_Pos            20                                                      /*!< SCU_CLK DSLEEPCR: CCUCR Position        */
#define SCU_CLK_DSLEEPCR_CCUCR_Msk            (0x01UL << SCU_CLK_DSLEEPCR_CCUCR_Pos)                  /*!< SCU_CLK DSLEEPCR: CCUCR Mask            */
#define SCU_CLK_DSLEEPCR_WDTCR_Pos            21                                                      /*!< SCU_CLK DSLEEPCR: WDTCR Position        */
#define SCU_CLK_DSLEEPCR_WDTCR_Msk            (0x01UL << SCU_CLK_DSLEEPCR_WDTCR_Pos)                  /*!< SCU_CLK DSLEEPCR: WDTCR Mask            */

/* ------------------------------  SCU_CLK_CGATSTAT0  ----------------------------- */
#define SCU_CLK_CGATSTAT0_VADC_Pos            0                                                       /*!< SCU_CLK CGATSTAT0: VADC Position        */
#define SCU_CLK_CGATSTAT0_VADC_Msk            (0x01UL << SCU_CLK_CGATSTAT0_VADC_Pos)                  /*!< SCU_CLK CGATSTAT0: VADC Mask            */
#define SCU_CLK_CGATSTAT0_CCU40_Pos           2                                                       /*!< SCU_CLK CGATSTAT0: CCU40 Position       */
#define SCU_CLK_CGATSTAT0_CCU40_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU40_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU40 Mask           */
#define SCU_CLK_CGATSTAT0_CCU41_Pos           3                                                       /*!< SCU_CLK CGATSTAT0: CCU41 Position       */
#define SCU_CLK_CGATSTAT0_CCU41_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU41_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU41 Mask           */
#define SCU_CLK_CGATSTAT0_CCU80_Pos           7                                                       /*!< SCU_CLK CGATSTAT0: CCU80 Position       */
#define SCU_CLK_CGATSTAT0_CCU80_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU80_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU80 Mask           */
#define SCU_CLK_CGATSTAT0_POSIF0_Pos          9                                                       /*!< SCU_CLK CGATSTAT0: POSIF0 Position      */
#define SCU_CLK_CGATSTAT0_POSIF0_Msk          (0x01UL << SCU_CLK_CGATSTAT0_POSIF0_Pos)                /*!< SCU_CLK CGATSTAT0: POSIF0 Mask          */
#define SCU_CLK_CGATSTAT0_USIC0_Pos           11                                                      /*!< SCU_CLK CGATSTAT0: USIC0 Position       */
#define SCU_CLK_CGATSTAT0_USIC0_Msk           (0x01UL << SCU_CLK_CGATSTAT0_USIC0_Pos)                 /*!< SCU_CLK CGATSTAT0: USIC0 Mask           */
#define SCU_CLK_CGATSTAT0_ERU1_Pos            16                                                      /*!< SCU_CLK CGATSTAT0: ERU1 Position        */
#define SCU_CLK_CGATSTAT0_ERU1_Msk            (0x01UL << SCU_CLK_CGATSTAT0_ERU1_Pos)                  /*!< SCU_CLK CGATSTAT0: ERU1 Mask            */
#define SCU_CLK_CGATSTAT0_HRPWM0_Pos          23                                                      /*!< SCU_CLK CGATSTAT0: HRPWM0 Position      */
#define SCU_CLK_CGATSTAT0_HRPWM0_Msk          (0x01UL << SCU_CLK_CGATSTAT0_HRPWM0_Pos)                /*!< SCU_CLK CGATSTAT0: HRPWM0 Mask          */

/* ------------------------------  SCU_CLK_CGATSET0  ------------------------------ */
#define SCU_CLK_CGATSET0_VADC_Pos             0                                                       /*!< SCU_CLK CGATSET0: VADC Position         */
#define SCU_CLK_CGATSET0_VADC_Msk             (0x01UL << SCU_CLK_CGATSET0_VADC_Pos)                   /*!< SCU_CLK CGATSET0: VADC Mask             */
#define SCU_CLK_CGATSET0_CCU40_Pos            2                                                       /*!< SCU_CLK CGATSET0: CCU40 Position        */
#define SCU_CLK_CGATSET0_CCU40_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU40_Pos)                  /*!< SCU_CLK CGATSET0: CCU40 Mask            */
#define SCU_CLK_CGATSET0_CCU41_Pos            3                                                       /*!< SCU_CLK CGATSET0: CCU41 Position        */
#define SCU_CLK_CGATSET0_CCU41_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU41_Pos)                  /*!< SCU_CLK CGATSET0: CCU41 Mask            */
#define SCU_CLK_CGATSET0_CCU80_Pos            7                                                       /*!< SCU_CLK CGATSET0: CCU80 Position        */
#define SCU_CLK_CGATSET0_CCU80_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU80_Pos)                  /*!< SCU_CLK CGATSET0: CCU80 Mask            */
#define SCU_CLK_CGATSET0_POSIF0_Pos           9                                                       /*!< SCU_CLK CGATSET0: POSIF0 Position       */
#define SCU_CLK_CGATSET0_POSIF0_Msk           (0x01UL << SCU_CLK_CGATSET0_POSIF0_Pos)                 /*!< SCU_CLK CGATSET0: POSIF0 Mask           */
#define SCU_CLK_CGATSET0_USIC0_Pos            11                                                      /*!< SCU_CLK CGATSET0: USIC0 Position        */
#define SCU_CLK_CGATSET0_USIC0_Msk            (0x01UL << SCU_CLK_CGATSET0_USIC0_Pos)                  /*!< SCU_CLK CGATSET0: USIC0 Mask            */
#define SCU_CLK_CGATSET0_ERU1_Pos             16                                                      /*!< SCU_CLK CGATSET0: ERU1 Position         */
#define SCU_CLK_CGATSET0_ERU1_Msk             (0x01UL << SCU_CLK_CGATSET0_ERU1_Pos)                   /*!< SCU_CLK CGATSET0: ERU1 Mask             */
#define SCU_CLK_CGATSET0_HRPWM0_Pos           23                                                      /*!< SCU_CLK CGATSET0: HRPWM0 Position       */
#define SCU_CLK_CGATSET0_HRPWM0_Msk           (0x01UL << SCU_CLK_CGATSET0_HRPWM0_Pos)                 /*!< SCU_CLK CGATSET0: HRPWM0 Mask           */

/* ------------------------------  SCU_CLK_CGATCLR0  ------------------------------ */
#define SCU_CLK_CGATCLR0_VADC_Pos             0                                                       /*!< SCU_CLK CGATCLR0: VADC Position         */
#define SCU_CLK_CGATCLR0_VADC_Msk             (0x01UL << SCU_CLK_CGATCLR0_VADC_Pos)                   /*!< SCU_CLK CGATCLR0: VADC Mask             */
#define SCU_CLK_CGATCLR0_CCU40_Pos            2                                                       /*!< SCU_CLK CGATCLR0: CCU40 Position        */
#define SCU_CLK_CGATCLR0_CCU40_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU40_Pos)                  /*!< SCU_CLK CGATCLR0: CCU40 Mask            */
#define SCU_CLK_CGATCLR0_CCU41_Pos            3                                                       /*!< SCU_CLK CGATCLR0: CCU41 Position        */
#define SCU_CLK_CGATCLR0_CCU41_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU41_Pos)                  /*!< SCU_CLK CGATCLR0: CCU41 Mask            */
#define SCU_CLK_CGATCLR0_CCU80_Pos            7                                                       /*!< SCU_CLK CGATCLR0: CCU80 Position        */
#define SCU_CLK_CGATCLR0_CCU80_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU80_Pos)                  /*!< SCU_CLK CGATCLR0: CCU80 Mask            */
#define SCU_CLK_CGATCLR0_POSIF0_Pos           9                                                       /*!< SCU_CLK CGATCLR0: POSIF0 Position       */
#define SCU_CLK_CGATCLR0_POSIF0_Msk           (0x01UL << SCU_CLK_CGATCLR0_POSIF0_Pos)                 /*!< SCU_CLK CGATCLR0: POSIF0 Mask           */
#define SCU_CLK_CGATCLR0_USIC0_Pos            11                                                      /*!< SCU_CLK CGATCLR0: USIC0 Position        */
#define SCU_CLK_CGATCLR0_USIC0_Msk            (0x01UL << SCU_CLK_CGATCLR0_USIC0_Pos)                  /*!< SCU_CLK CGATCLR0: USIC0 Mask            */
#define SCU_CLK_CGATCLR0_ERU1_Pos             16                                                      /*!< SCU_CLK CGATCLR0: ERU1 Position         */
#define SCU_CLK_CGATCLR0_ERU1_Msk             (0x01UL << SCU_CLK_CGATCLR0_ERU1_Pos)                   /*!< SCU_CLK CGATCLR0: ERU1 Mask             */
#define SCU_CLK_CGATCLR0_HRPWM0_Pos           23                                                      /*!< SCU_CLK CGATCLR0: HRPWM0 Position       */
#define SCU_CLK_CGATCLR0_HRPWM0_Msk           (0x01UL << SCU_CLK_CGATCLR0_HRPWM0_Pos)                 /*!< SCU_CLK CGATCLR0: HRPWM0 Mask           */

/* ------------------------------  SCU_CLK_CGATSTAT1  ----------------------------- */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Pos        3                                                       /*!< SCU_CLK CGATSTAT1: LEDTSCU0 Position    */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Msk        (0x01UL << SCU_CLK_CGATSTAT1_LEDTSCU0_Pos)              /*!< SCU_CLK CGATSTAT1: LEDTSCU0 Mask        */
#define SCU_CLK_CGATSTAT1_MCAN0_Pos           4                                                       /*!< SCU_CLK CGATSTAT1: MCAN0 Position       */
#define SCU_CLK_CGATSTAT1_MCAN0_Msk           (0x01UL << SCU_CLK_CGATSTAT1_MCAN0_Pos)                 /*!< SCU_CLK CGATSTAT1: MCAN0 Mask           */
#define SCU_CLK_CGATSTAT1_DAC_Pos             5                                                       /*!< SCU_CLK CGATSTAT1: DAC Position         */
#define SCU_CLK_CGATSTAT1_DAC_Msk             (0x01UL << SCU_CLK_CGATSTAT1_DAC_Pos)                   /*!< SCU_CLK CGATSTAT1: DAC Mask             */
#define SCU_CLK_CGATSTAT1_USIC1_Pos           7                                                       /*!< SCU_CLK CGATSTAT1: USIC1 Position       */
#define SCU_CLK_CGATSTAT1_USIC1_Msk           (0x01UL << SCU_CLK_CGATSTAT1_USIC1_Pos)                 /*!< SCU_CLK CGATSTAT1: USIC1 Mask           */
#define SCU_CLK_CGATSTAT1_PPORTS_Pos          9                                                       /*!< SCU_CLK CGATSTAT1: PPORTS Position      */
#define SCU_CLK_CGATSTAT1_PPORTS_Msk          (0x01UL << SCU_CLK_CGATSTAT1_PPORTS_Pos)                /*!< SCU_CLK CGATSTAT1: PPORTS Mask          */

/* ------------------------------  SCU_CLK_CGATSET1  ------------------------------ */
#define SCU_CLK_CGATSET1_LEDTSCU0_Pos         3                                                       /*!< SCU_CLK CGATSET1: LEDTSCU0 Position     */
#define SCU_CLK_CGATSET1_LEDTSCU0_Msk         (0x01UL << SCU_CLK_CGATSET1_LEDTSCU0_Pos)               /*!< SCU_CLK CGATSET1: LEDTSCU0 Mask         */
#define SCU_CLK_CGATSET1_MCAN0_Pos            4                                                       /*!< SCU_CLK CGATSET1: MCAN0 Position        */
#define SCU_CLK_CGATSET1_MCAN0_Msk            (0x01UL << SCU_CLK_CGATSET1_MCAN0_Pos)                  /*!< SCU_CLK CGATSET1: MCAN0 Mask            */
#define SCU_CLK_CGATSET1_DAC_Pos              5                                                       /*!< SCU_CLK CGATSET1: DAC Position          */
#define SCU_CLK_CGATSET1_DAC_Msk              (0x01UL << SCU_CLK_CGATSET1_DAC_Pos)                    /*!< SCU_CLK CGATSET1: DAC Mask              */
#define SCU_CLK_CGATSET1_USIC1_Pos            7                                                       /*!< SCU_CLK CGATSET1: USIC1 Position        */
#define SCU_CLK_CGATSET1_USIC1_Msk            (0x01UL << SCU_CLK_CGATSET1_USIC1_Pos)                  /*!< SCU_CLK CGATSET1: USIC1 Mask            */
#define SCU_CLK_CGATSET1_PPORTS_Pos           9                                                       /*!< SCU_CLK CGATSET1: PPORTS Position       */
#define SCU_CLK_CGATSET1_PPORTS_Msk           (0x01UL << SCU_CLK_CGATSET1_PPORTS_Pos)                 /*!< SCU_CLK CGATSET1: PPORTS Mask           */

/* ------------------------------  SCU_CLK_CGATCLR1  ------------------------------ */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Pos         3                                                       /*!< SCU_CLK CGATCLR1: LEDTSCU0 Position     */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Msk         (0x01UL << SCU_CLK_CGATCLR1_LEDTSCU0_Pos)               /*!< SCU_CLK CGATCLR1: LEDTSCU0 Mask         */
#define SCU_CLK_CGATCLR1_MCAN0_Pos            4                                                       /*!< SCU_CLK CGATCLR1: MCAN0 Position        */
#define SCU_CLK_CGATCLR1_MCAN0_Msk            (0x01UL << SCU_CLK_CGATCLR1_MCAN0_Pos)                  /*!< SCU_CLK CGATCLR1: MCAN0 Mask            */
#define SCU_CLK_CGATCLR1_DAC_Pos              5                                                       /*!< SCU_CLK CGATCLR1: DAC Position          */
#define SCU_CLK_CGATCLR1_DAC_Msk              (0x01UL << SCU_CLK_CGATCLR1_DAC_Pos)                    /*!< SCU_CLK CGATCLR1: DAC Mask              */
#define SCU_CLK_CGATCLR1_USIC1_Pos            7                                                       /*!< SCU_CLK CGATCLR1: USIC1 Position        */
#define SCU_CLK_CGATCLR1_USIC1_Msk            (0x01UL << SCU_CLK_CGATCLR1_USIC1_Pos)                  /*!< SCU_CLK CGATCLR1: USIC1 Mask            */
#define SCU_CLK_CGATCLR1_PPORTS_Pos           9                                                       /*!< SCU_CLK CGATCLR1: PPORTS Position       */
#define SCU_CLK_CGATCLR1_PPORTS_Msk           (0x01UL << SCU_CLK_CGATCLR1_PPORTS_Pos)                 /*!< SCU_CLK CGATCLR1: PPORTS Mask           */

/* ------------------------------  SCU_CLK_CGATSTAT2  ----------------------------- */
#define SCU_CLK_CGATSTAT2_WDT_Pos             1                                                       /*!< SCU_CLK CGATSTAT2: WDT Position         */
#define SCU_CLK_CGATSTAT2_WDT_Msk             (0x01UL << SCU_CLK_CGATSTAT2_WDT_Pos)                   /*!< SCU_CLK CGATSTAT2: WDT Mask             */
#define SCU_CLK_CGATSTAT2_DMA0_Pos            4                                                       /*!< SCU_CLK CGATSTAT2: DMA0 Position        */
#define SCU_CLK_CGATSTAT2_DMA0_Msk            (0x01UL << SCU_CLK_CGATSTAT2_DMA0_Pos)                  /*!< SCU_CLK CGATSTAT2: DMA0 Mask            */
#define SCU_CLK_CGATSTAT2_FCE_Pos             6                                                       /*!< SCU_CLK CGATSTAT2: FCE Position         */
#define SCU_CLK_CGATSTAT2_FCE_Msk             (0x01UL << SCU_CLK_CGATSTAT2_FCE_Pos)                   /*!< SCU_CLK CGATSTAT2: FCE Mask             */
#define SCU_CLK_CGATSTAT2_USB_Pos             7                                                       /*!< SCU_CLK CGATSTAT2: USB Position         */
#define SCU_CLK_CGATSTAT2_USB_Msk             (0x01UL << SCU_CLK_CGATSTAT2_USB_Pos)                   /*!< SCU_CLK CGATSTAT2: USB Mask             */

/* ------------------------------  SCU_CLK_CGATSET2  ------------------------------ */
#define SCU_CLK_CGATSET2_WDT_Pos              1                                                       /*!< SCU_CLK CGATSET2: WDT Position          */
#define SCU_CLK_CGATSET2_WDT_Msk              (0x01UL << SCU_CLK_CGATSET2_WDT_Pos)                    /*!< SCU_CLK CGATSET2: WDT Mask              */
#define SCU_CLK_CGATSET2_DMA0_Pos             4                                                       /*!< SCU_CLK CGATSET2: DMA0 Position         */
#define SCU_CLK_CGATSET2_DMA0_Msk             (0x01UL << SCU_CLK_CGATSET2_DMA0_Pos)                   /*!< SCU_CLK CGATSET2: DMA0 Mask             */
#define SCU_CLK_CGATSET2_FCE_Pos              6                                                       /*!< SCU_CLK CGATSET2: FCE Position          */
#define SCU_CLK_CGATSET2_FCE_Msk              (0x01UL << SCU_CLK_CGATSET2_FCE_Pos)                    /*!< SCU_CLK CGATSET2: FCE Mask              */
#define SCU_CLK_CGATSET2_USB_Pos              7                                                       /*!< SCU_CLK CGATSET2: USB Position          */
#define SCU_CLK_CGATSET2_USB_Msk              (0x01UL << SCU_CLK_CGATSET2_USB_Pos)                    /*!< SCU_CLK CGATSET2: USB Mask              */

/* ------------------------------  SCU_CLK_CGATCLR2  ------------------------------ */
#define SCU_CLK_CGATCLR2_WDT_Pos              1                                                       /*!< SCU_CLK CGATCLR2: WDT Position          */
#define SCU_CLK_CGATCLR2_WDT_Msk              (0x01UL << SCU_CLK_CGATCLR2_WDT_Pos)                    /*!< SCU_CLK CGATCLR2: WDT Mask              */
#define SCU_CLK_CGATCLR2_DMA0_Pos             4                                                       /*!< SCU_CLK CGATCLR2: DMA0 Position         */
#define SCU_CLK_CGATCLR2_DMA0_Msk             (0x01UL << SCU_CLK_CGATCLR2_DMA0_Pos)                   /*!< SCU_CLK CGATCLR2: DMA0 Mask             */
#define SCU_CLK_CGATCLR2_FCE_Pos              6                                                       /*!< SCU_CLK CGATCLR2: FCE Position          */
#define SCU_CLK_CGATCLR2_FCE_Msk              (0x01UL << SCU_CLK_CGATCLR2_FCE_Pos)                    /*!< SCU_CLK CGATCLR2: FCE Mask              */
#define SCU_CLK_CGATCLR2_USB_Pos              7                                                       /*!< SCU_CLK CGATCLR2: USB Position          */
#define SCU_CLK_CGATCLR2_USB_Msk              (0x01UL << SCU_CLK_CGATCLR2_USB_Pos)                    /*!< SCU_CLK CGATCLR2: USB Mask              */


/* ================================================================================ */
/* ================        struct 'SCU_OSC' Position & Mask        ================ */
/* ================================================================================ */


/* ------------------------------  SCU_OSC_OSCHPSTAT  ----------------------------- */
#define SCU_OSC_OSCHPSTAT_X1D_Pos             0                                                       /*!< SCU_OSC OSCHPSTAT: X1D Position         */
#define SCU_OSC_OSCHPSTAT_X1D_Msk             (0x01UL << SCU_OSC_OSCHPSTAT_X1D_Pos)                   /*!< SCU_OSC OSCHPSTAT: X1D Mask             */

/* ------------------------------  SCU_OSC_OSCHPCTRL  ----------------------------- */
#define SCU_OSC_OSCHPCTRL_X1DEN_Pos           0                                                       /*!< SCU_OSC OSCHPCTRL: X1DEN Position       */
#define SCU_OSC_OSCHPCTRL_X1DEN_Msk           (0x01UL << SCU_OSC_OSCHPCTRL_X1DEN_Pos)                 /*!< SCU_OSC OSCHPCTRL: X1DEN Mask           */
#define SCU_OSC_OSCHPCTRL_SHBY_Pos            1                                                       /*!< SCU_OSC OSCHPCTRL: SHBY Position        */
#define SCU_OSC_OSCHPCTRL_SHBY_Msk            (0x01UL << SCU_OSC_OSCHPCTRL_SHBY_Pos)                  /*!< SCU_OSC OSCHPCTRL: SHBY Mask            */
#define SCU_OSC_OSCHPCTRL_MODE_Pos            4                                                       /*!< SCU_OSC OSCHPCTRL: MODE Position        */
#define SCU_OSC_OSCHPCTRL_MODE_Msk            (0x03UL << SCU_OSC_OSCHPCTRL_MODE_Pos)                  /*!< SCU_OSC OSCHPCTRL: MODE Mask            */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Pos          16                                                      /*!< SCU_OSC OSCHPCTRL: OSCVAL Position      */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Msk          (0x1fUL << SCU_OSC_OSCHPCTRL_OSCVAL_Pos)                /*!< SCU_OSC OSCHPCTRL: OSCVAL Mask          */

/* -----------------------------  SCU_OSC_CLKCALCONST  ---------------------------- */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Pos    0                                                       /*!< SCU_OSC CLKCALCONST: CALIBCONST Position */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Msk    (0x0fUL << SCU_OSC_CLKCALCONST_CALIBCONST_Pos)          /*!< SCU_OSC CLKCALCONST: CALIBCONST Mask    */


/* ================================================================================ */
/* ================        struct 'SCU_PLL' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PLL_PLLSTAT  ------------------------------ */
#define SCU_PLL_PLLSTAT_VCOBYST_Pos           0                                                       /*!< SCU_PLL PLLSTAT: VCOBYST Position       */
#define SCU_PLL_PLLSTAT_VCOBYST_Msk           (0x01UL << SCU_PLL_PLLSTAT_VCOBYST_Pos)                 /*!< SCU_PLL PLLSTAT: VCOBYST Mask           */
#define SCU_PLL_PLLSTAT_PWDSTAT_Pos           1                                                       /*!< SCU_PLL PLLSTAT: PWDSTAT Position       */
#define SCU_PLL_PLLSTAT_PWDSTAT_Msk           (0x01UL << SCU_PLL_PLLSTAT_PWDSTAT_Pos)                 /*!< SCU_PLL PLLSTAT: PWDSTAT Mask           */
#define SCU_PLL_PLLSTAT_VCOLOCK_Pos           2                                                       /*!< SCU_PLL PLLSTAT: VCOLOCK Position       */
#define SCU_PLL_PLLSTAT_VCOLOCK_Msk           (0x01UL << SCU_PLL_PLLSTAT_VCOLOCK_Pos)                 /*!< SCU_PLL PLLSTAT: VCOLOCK Mask           */
#define SCU_PLL_PLLSTAT_K1RDY_Pos             4                                                       /*!< SCU_PLL PLLSTAT: K1RDY Position         */
#define SCU_PLL_PLLSTAT_K1RDY_Msk             (0x01UL << SCU_PLL_PLLSTAT_K1RDY_Pos)                   /*!< SCU_PLL PLLSTAT: K1RDY Mask             */
#define SCU_PLL_PLLSTAT_K2RDY_Pos             5                                                       /*!< SCU_PLL PLLSTAT: K2RDY Position         */
#define SCU_PLL_PLLSTAT_K2RDY_Msk             (0x01UL << SCU_PLL_PLLSTAT_K2RDY_Pos)                   /*!< SCU_PLL PLLSTAT: K2RDY Mask             */
#define SCU_PLL_PLLSTAT_BY_Pos                6                                                       /*!< SCU_PLL PLLSTAT: BY Position            */
#define SCU_PLL_PLLSTAT_BY_Msk                (0x01UL << SCU_PLL_PLLSTAT_BY_Pos)                      /*!< SCU_PLL PLLSTAT: BY Mask                */
#define SCU_PLL_PLLSTAT_PLLLV_Pos             7                                                       /*!< SCU_PLL PLLSTAT: PLLLV Position         */
#define SCU_PLL_PLLSTAT_PLLLV_Msk             (0x01UL << SCU_PLL_PLLSTAT_PLLLV_Pos)                   /*!< SCU_PLL PLLSTAT: PLLLV Mask             */
#define SCU_PLL_PLLSTAT_PLLHV_Pos             8                                                       /*!< SCU_PLL PLLSTAT: PLLHV Position         */
#define SCU_PLL_PLLSTAT_PLLHV_Msk             (0x01UL << SCU_PLL_PLLSTAT_PLLHV_Pos)                   /*!< SCU_PLL PLLSTAT: PLLHV Mask             */
#define SCU_PLL_PLLSTAT_PLLSP_Pos             9                                                       /*!< SCU_PLL PLLSTAT: PLLSP Position         */
#define SCU_PLL_PLLSTAT_PLLSP_Msk             (0x01UL << SCU_PLL_PLLSTAT_PLLSP_Pos)                   /*!< SCU_PLL PLLSTAT: PLLSP Mask             */

/* -------------------------------  SCU_PLL_PLLCON0  ------------------------------ */
#define SCU_PLL_PLLCON0_VCOBYP_Pos            0                                                       /*!< SCU_PLL PLLCON0: VCOBYP Position        */
#define SCU_PLL_PLLCON0_VCOBYP_Msk            (0x01UL << SCU_PLL_PLLCON0_VCOBYP_Pos)                  /*!< SCU_PLL PLLCON0: VCOBYP Mask            */
#define SCU_PLL_PLLCON0_VCOPWD_Pos            1                                                       /*!< SCU_PLL PLLCON0: VCOPWD Position        */
#define SCU_PLL_PLLCON0_VCOPWD_Msk            (0x01UL << SCU_PLL_PLLCON0_VCOPWD_Pos)                  /*!< SCU_PLL PLLCON0: VCOPWD Mask            */
#define SCU_PLL_PLLCON0_VCOTR_Pos             2                                                       /*!< SCU_PLL PLLCON0: VCOTR Position         */
#define SCU_PLL_PLLCON0_VCOTR_Msk             (0x01UL << SCU_PLL_PLLCON0_VCOTR_Pos)                   /*!< SCU_PLL PLLCON0: VCOTR Mask             */
#define SCU_PLL_PLLCON0_FINDIS_Pos            4                                                       /*!< SCU_PLL PLLCON0: FINDIS Position        */
#define SCU_PLL_PLLCON0_FINDIS_Msk            (0x01UL << SCU_PLL_PLLCON0_FINDIS_Pos)                  /*!< SCU_PLL PLLCON0: FINDIS Mask            */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Pos        6                                                       /*!< SCU_PLL PLLCON0: OSCDISCDIS Position    */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Msk        (0x01UL << SCU_PLL_PLLCON0_OSCDISCDIS_Pos)              /*!< SCU_PLL PLLCON0: OSCDISCDIS Mask        */
#define SCU_PLL_PLLCON0_PLLPWD_Pos            16                                                      /*!< SCU_PLL PLLCON0: PLLPWD Position        */
#define SCU_PLL_PLLCON0_PLLPWD_Msk            (0x01UL << SCU_PLL_PLLCON0_PLLPWD_Pos)                  /*!< SCU_PLL PLLCON0: PLLPWD Mask            */
#define SCU_PLL_PLLCON0_OSCRES_Pos            17                                                      /*!< SCU_PLL PLLCON0: OSCRES Position        */
#define SCU_PLL_PLLCON0_OSCRES_Msk            (0x01UL << SCU_PLL_PLLCON0_OSCRES_Pos)                  /*!< SCU_PLL PLLCON0: OSCRES Mask            */
#define SCU_PLL_PLLCON0_RESLD_Pos             18                                                      /*!< SCU_PLL PLLCON0: RESLD Position         */
#define SCU_PLL_PLLCON0_RESLD_Msk             (0x01UL << SCU_PLL_PLLCON0_RESLD_Pos)                   /*!< SCU_PLL PLLCON0: RESLD Mask             */
#define SCU_PLL_PLLCON0_AOTREN_Pos            19                                                      /*!< SCU_PLL PLLCON0: AOTREN Position        */
#define SCU_PLL_PLLCON0_AOTREN_Msk            (0x01UL << SCU_PLL_PLLCON0_AOTREN_Pos)                  /*!< SCU_PLL PLLCON0: AOTREN Mask            */
#define SCU_PLL_PLLCON0_FOTR_Pos              20                                                      /*!< SCU_PLL PLLCON0: FOTR Position          */
#define SCU_PLL_PLLCON0_FOTR_Msk              (0x01UL << SCU_PLL_PLLCON0_FOTR_Pos)                    /*!< SCU_PLL PLLCON0: FOTR Mask              */

/* -------------------------------  SCU_PLL_PLLCON1  ------------------------------ */
#define SCU_PLL_PLLCON1_K1DIV_Pos             0                                                       /*!< SCU_PLL PLLCON1: K1DIV Position         */
#define SCU_PLL_PLLCON1_K1DIV_Msk             (0x7fUL << SCU_PLL_PLLCON1_K1DIV_Pos)                   /*!< SCU_PLL PLLCON1: K1DIV Mask             */
#define SCU_PLL_PLLCON1_NDIV_Pos              8                                                       /*!< SCU_PLL PLLCON1: NDIV Position          */
#define SCU_PLL_PLLCON1_NDIV_Msk              (0x7fUL << SCU_PLL_PLLCON1_NDIV_Pos)                    /*!< SCU_PLL PLLCON1: NDIV Mask              */
#define SCU_PLL_PLLCON1_K2DIV_Pos             16                                                      /*!< SCU_PLL PLLCON1: K2DIV Position         */
#define SCU_PLL_PLLCON1_K2DIV_Msk             (0x7fUL << SCU_PLL_PLLCON1_K2DIV_Pos)                   /*!< SCU_PLL PLLCON1: K2DIV Mask             */
#define SCU_PLL_PLLCON1_PDIV_Pos              24                                                      /*!< SCU_PLL PLLCON1: PDIV Position          */
#define SCU_PLL_PLLCON1_PDIV_Msk              (0x0fUL << SCU_PLL_PLLCON1_PDIV_Pos)                    /*!< SCU_PLL PLLCON1: PDIV Mask              */

/* -------------------------------  SCU_PLL_PLLCON2  ------------------------------ */
#define SCU_PLL_PLLCON2_PINSEL_Pos            0                                                       /*!< SCU_PLL PLLCON2: PINSEL Position        */
#define SCU_PLL_PLLCON2_PINSEL_Msk            (0x01UL << SCU_PLL_PLLCON2_PINSEL_Pos)                  /*!< SCU_PLL PLLCON2: PINSEL Mask            */
#define SCU_PLL_PLLCON2_K1INSEL_Pos           8                                                       /*!< SCU_PLL PLLCON2: K1INSEL Position       */
#define SCU_PLL_PLLCON2_K1INSEL_Msk           (0x01UL << SCU_PLL_PLLCON2_K1INSEL_Pos)                 /*!< SCU_PLL PLLCON2: K1INSEL Mask           */

/* -----------------------------  SCU_PLL_USBPLLSTAT  ----------------------------- */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Pos        0                                                       /*!< SCU_PLL USBPLLSTAT: VCOBYST Position    */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Msk        (0x01UL << SCU_PLL_USBPLLSTAT_VCOBYST_Pos)              /*!< SCU_PLL USBPLLSTAT: VCOBYST Mask        */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Pos        1                                                       /*!< SCU_PLL USBPLLSTAT: PWDSTAT Position    */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Msk        (0x01UL << SCU_PLL_USBPLLSTAT_PWDSTAT_Pos)              /*!< SCU_PLL USBPLLSTAT: PWDSTAT Mask        */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Pos        2                                                       /*!< SCU_PLL USBPLLSTAT: VCOLOCK Position    */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Msk        (0x01UL << SCU_PLL_USBPLLSTAT_VCOLOCK_Pos)              /*!< SCU_PLL USBPLLSTAT: VCOLOCK Mask        */
#define SCU_PLL_USBPLLSTAT_BY_Pos             6                                                       /*!< SCU_PLL USBPLLSTAT: BY Position         */
#define SCU_PLL_USBPLLSTAT_BY_Msk             (0x01UL << SCU_PLL_USBPLLSTAT_BY_Pos)                   /*!< SCU_PLL USBPLLSTAT: BY Mask             */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Pos      7                                                       /*!< SCU_PLL USBPLLSTAT: VCOLOCKED Position  */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Msk      (0x01UL << SCU_PLL_USBPLLSTAT_VCOLOCKED_Pos)            /*!< SCU_PLL USBPLLSTAT: VCOLOCKED Mask      */

/* ------------------------------  SCU_PLL_USBPLLCON  ----------------------------- */
#define SCU_PLL_USBPLLCON_VCOBYP_Pos          0                                                       /*!< SCU_PLL USBPLLCON: VCOBYP Position      */
#define SCU_PLL_USBPLLCON_VCOBYP_Msk          (0x01UL << SCU_PLL_USBPLLCON_VCOBYP_Pos)                /*!< SCU_PLL USBPLLCON: VCOBYP Mask          */
#define SCU_PLL_USBPLLCON_VCOPWD_Pos          1                                                       /*!< SCU_PLL USBPLLCON: VCOPWD Position      */
#define SCU_PLL_USBPLLCON_VCOPWD_Msk          (0x01UL << SCU_PLL_USBPLLCON_VCOPWD_Pos)                /*!< SCU_PLL USBPLLCON: VCOPWD Mask          */
#define SCU_PLL_USBPLLCON_VCOTR_Pos           2                                                       /*!< SCU_PLL USBPLLCON: VCOTR Position       */
#define SCU_PLL_USBPLLCON_VCOTR_Msk           (0x01UL << SCU_PLL_USBPLLCON_VCOTR_Pos)                 /*!< SCU_PLL USBPLLCON: VCOTR Mask           */
#define SCU_PLL_USBPLLCON_FINDIS_Pos          4                                                       /*!< SCU_PLL USBPLLCON: FINDIS Position      */
#define SCU_PLL_USBPLLCON_FINDIS_Msk          (0x01UL << SCU_PLL_USBPLLCON_FINDIS_Pos)                /*!< SCU_PLL USBPLLCON: FINDIS Mask          */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Pos      6                                                       /*!< SCU_PLL USBPLLCON: OSCDISCDIS Position  */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Msk      (0x01UL << SCU_PLL_USBPLLCON_OSCDISCDIS_Pos)            /*!< SCU_PLL USBPLLCON: OSCDISCDIS Mask      */
#define SCU_PLL_USBPLLCON_NDIV_Pos            8                                                       /*!< SCU_PLL USBPLLCON: NDIV Position        */
#define SCU_PLL_USBPLLCON_NDIV_Msk            (0x7fUL << SCU_PLL_USBPLLCON_NDIV_Pos)                  /*!< SCU_PLL USBPLLCON: NDIV Mask            */
#define SCU_PLL_USBPLLCON_PLLPWD_Pos          16                                                      /*!< SCU_PLL USBPLLCON: PLLPWD Position      */
#define SCU_PLL_USBPLLCON_PLLPWD_Msk          (0x01UL << SCU_PLL_USBPLLCON_PLLPWD_Pos)                /*!< SCU_PLL USBPLLCON: PLLPWD Mask          */
#define SCU_PLL_USBPLLCON_RESLD_Pos           18                                                      /*!< SCU_PLL USBPLLCON: RESLD Position       */
#define SCU_PLL_USBPLLCON_RESLD_Msk           (0x01UL << SCU_PLL_USBPLLCON_RESLD_Pos)                 /*!< SCU_PLL USBPLLCON: RESLD Mask           */
#define SCU_PLL_USBPLLCON_PDIV_Pos            24                                                      /*!< SCU_PLL USBPLLCON: PDIV Position        */
#define SCU_PLL_USBPLLCON_PDIV_Msk            (0x0fUL << SCU_PLL_USBPLLCON_PDIV_Pos)                  /*!< SCU_PLL USBPLLCON: PDIV Mask            */

/* ------------------------------  SCU_PLL_CLKMXSTAT  ----------------------------- */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Pos       0                                                       /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX Position   */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Msk       (0x03UL << SCU_PLL_CLKMXSTAT_SYSCLKMUX_Pos)             /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX Mask       */


/* ================================================================================ */
/* ================      struct 'SCU_GENERAL' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_GENERAL_ID  ------------------------------- */
#define SCU_GENERAL_ID_MOD_REV_Pos            0                                                       /*!< SCU_GENERAL ID: MOD_REV Position        */
#define SCU_GENERAL_ID_MOD_REV_Msk            (0x000000ffUL << SCU_GENERAL_ID_MOD_REV_Pos)            /*!< SCU_GENERAL ID: MOD_REV Mask            */
#define SCU_GENERAL_ID_MOD_TYPE_Pos           8                                                       /*!< SCU_GENERAL ID: MOD_TYPE Position       */
#define SCU_GENERAL_ID_MOD_TYPE_Msk           (0x000000ffUL << SCU_GENERAL_ID_MOD_TYPE_Pos)           /*!< SCU_GENERAL ID: MOD_TYPE Mask           */
#define SCU_GENERAL_ID_MOD_NUMBER_Pos         16                                                      /*!< SCU_GENERAL ID: MOD_NUMBER Position     */
#define SCU_GENERAL_ID_MOD_NUMBER_Msk         (0x0000ffffUL << SCU_GENERAL_ID_MOD_NUMBER_Pos)         /*!< SCU_GENERAL ID: MOD_NUMBER Mask         */

/* -----------------------------  SCU_GENERAL_IDCHIP  ----------------------------- */
#define SCU_GENERAL_IDCHIP_IDCHIP_Pos         0                                                       /*!< SCU_GENERAL IDCHIP: IDCHIP Position     */
#define SCU_GENERAL_IDCHIP_IDCHIP_Msk         (0xffffffffUL << SCU_GENERAL_IDCHIP_IDCHIP_Pos)         /*!< SCU_GENERAL IDCHIP: IDCHIP Mask         */

/* -----------------------------  SCU_GENERAL_IDMANUF  ---------------------------- */
#define SCU_GENERAL_IDMANUF_DEPT_Pos          0                                                       /*!< SCU_GENERAL IDMANUF: DEPT Position      */
#define SCU_GENERAL_IDMANUF_DEPT_Msk          (0x1fUL << SCU_GENERAL_IDMANUF_DEPT_Pos)                /*!< SCU_GENERAL IDMANUF: DEPT Mask          */
#define SCU_GENERAL_IDMANUF_MANUF_Pos         5                                                       /*!< SCU_GENERAL IDMANUF: MANUF Position     */
#define SCU_GENERAL_IDMANUF_MANUF_Msk         (0x000007ffUL << SCU_GENERAL_IDMANUF_MANUF_Pos)         /*!< SCU_GENERAL IDMANUF: MANUF Mask         */

/* ------------------------------  SCU_GENERAL_STCON  ----------------------------- */
#define SCU_GENERAL_STCON_HWCON_Pos           0                                                       /*!< SCU_GENERAL STCON: HWCON Position       */
#define SCU_GENERAL_STCON_HWCON_Msk           (0x03UL << SCU_GENERAL_STCON_HWCON_Pos)                 /*!< SCU_GENERAL STCON: HWCON Mask           */
#define SCU_GENERAL_STCON_SWCON_Pos           8                                                       /*!< SCU_GENERAL STCON: SWCON Position       */
#define SCU_GENERAL_STCON_SWCON_Msk           (0x0fUL << SCU_GENERAL_STCON_SWCON_Pos)                 /*!< SCU_GENERAL STCON: SWCON Mask           */

/* -------------------------------  SCU_GENERAL_GPR  ------------------------------ */
#define SCU_GENERAL_GPR_DAT_Pos               0                                                       /*!< SCU_GENERAL GPR: DAT Position           */
#define SCU_GENERAL_GPR_DAT_Msk               (0xffffffffUL << SCU_GENERAL_GPR_DAT_Pos)               /*!< SCU_GENERAL GPR: DAT Mask               */

/* -----------------------------  SCU_GENERAL_CCUCON  ----------------------------- */
#define SCU_GENERAL_CCUCON_GSC40_Pos          0                                                       /*!< SCU_GENERAL CCUCON: GSC40 Position      */
#define SCU_GENERAL_CCUCON_GSC40_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC40_Pos)                /*!< SCU_GENERAL CCUCON: GSC40 Mask          */
#define SCU_GENERAL_CCUCON_GSC41_Pos          1                                                       /*!< SCU_GENERAL CCUCON: GSC41 Position      */
#define SCU_GENERAL_CCUCON_GSC41_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC41_Pos)                /*!< SCU_GENERAL CCUCON: GSC41 Mask          */
#define SCU_GENERAL_CCUCON_GSC80_Pos          8                                                       /*!< SCU_GENERAL CCUCON: GSC80 Position      */
#define SCU_GENERAL_CCUCON_GSC80_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC80_Pos)                /*!< SCU_GENERAL CCUCON: GSC80 Mask          */
#define SCU_GENERAL_CCUCON_GSHR0_Pos          24                                                      /*!< SCU_GENERAL CCUCON: GSHR0 Position      */
#define SCU_GENERAL_CCUCON_GSHR0_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSHR0_Pos)                /*!< SCU_GENERAL CCUCON: GSHR0 Mask          */

/* -----------------------------  SCU_GENERAL_DTSCON  ----------------------------- */
#define SCU_GENERAL_DTSCON_PWD_Pos            0                                                       /*!< SCU_GENERAL DTSCON: PWD Position        */
#define SCU_GENERAL_DTSCON_PWD_Msk            (0x01UL << SCU_GENERAL_DTSCON_PWD_Pos)                  /*!< SCU_GENERAL DTSCON: PWD Mask            */
#define SCU_GENERAL_DTSCON_START_Pos          1                                                       /*!< SCU_GENERAL DTSCON: START Position      */
#define SCU_GENERAL_DTSCON_START_Msk          (0x01UL << SCU_GENERAL_DTSCON_START_Pos)                /*!< SCU_GENERAL DTSCON: START Mask          */
#define SCU_GENERAL_DTSCON_OFFSET_Pos         4                                                       /*!< SCU_GENERAL DTSCON: OFFSET Position     */
#define SCU_GENERAL_DTSCON_OFFSET_Msk         (0x7fUL << SCU_GENERAL_DTSCON_OFFSET_Pos)               /*!< SCU_GENERAL DTSCON: OFFSET Mask         */
#define SCU_GENERAL_DTSCON_GAIN_Pos           11                                                      /*!< SCU_GENERAL DTSCON: GAIN Position       */
#define SCU_GENERAL_DTSCON_GAIN_Msk           (0x3fUL << SCU_GENERAL_DTSCON_GAIN_Pos)                 /*!< SCU_GENERAL DTSCON: GAIN Mask           */
#define SCU_GENERAL_DTSCON_REFTRIM_Pos        17                                                      /*!< SCU_GENERAL DTSCON: REFTRIM Position    */
#define SCU_GENERAL_DTSCON_REFTRIM_Msk        (0x07UL << SCU_GENERAL_DTSCON_REFTRIM_Pos)              /*!< SCU_GENERAL DTSCON: REFTRIM Mask        */
#define SCU_GENERAL_DTSCON_BGTRIM_Pos         20                                                      /*!< SCU_GENERAL DTSCON: BGTRIM Position     */
#define SCU_GENERAL_DTSCON_BGTRIM_Msk         (0x0fUL << SCU_GENERAL_DTSCON_BGTRIM_Pos)               /*!< SCU_GENERAL DTSCON: BGTRIM Mask         */

/* -----------------------------  SCU_GENERAL_DTSSTAT  ---------------------------- */
#define SCU_GENERAL_DTSSTAT_RESULT_Pos        0                                                       /*!< SCU_GENERAL DTSSTAT: RESULT Position    */
#define SCU_GENERAL_DTSSTAT_RESULT_Msk        (0x000003ffUL << SCU_GENERAL_DTSSTAT_RESULT_Pos)        /*!< SCU_GENERAL DTSSTAT: RESULT Mask        */
#define SCU_GENERAL_DTSSTAT_RDY_Pos           14                                                      /*!< SCU_GENERAL DTSSTAT: RDY Position       */
#define SCU_GENERAL_DTSSTAT_RDY_Msk           (0x01UL << SCU_GENERAL_DTSSTAT_RDY_Pos)                 /*!< SCU_GENERAL DTSSTAT: RDY Mask           */
#define SCU_GENERAL_DTSSTAT_BUSY_Pos          15                                                      /*!< SCU_GENERAL DTSSTAT: BUSY Position      */
#define SCU_GENERAL_DTSSTAT_BUSY_Msk          (0x01UL << SCU_GENERAL_DTSSTAT_BUSY_Pos)                /*!< SCU_GENERAL DTSSTAT: BUSY Mask          */

/* -----------------------------  SCU_GENERAL_GORCEN  ----------------------------- */
#define SCU_GENERAL_GORCEN_ENORC6_Pos         6                                                       /*!< SCU_GENERAL GORCEN: ENORC6 Position     */
#define SCU_GENERAL_GORCEN_ENORC6_Msk         (0x01UL << SCU_GENERAL_GORCEN_ENORC6_Pos)               /*!< SCU_GENERAL GORCEN: ENORC6 Mask         */
#define SCU_GENERAL_GORCEN_ENORC7_Pos         7                                                       /*!< SCU_GENERAL GORCEN: ENORC7 Position     */
#define SCU_GENERAL_GORCEN_ENORC7_Msk         (0x01UL << SCU_GENERAL_GORCEN_ENORC7_Pos)               /*!< SCU_GENERAL GORCEN: ENORC7 Mask         */

/* ----------------------------  SCU_GENERAL_DTEMPLIM  ---------------------------- */
#define SCU_GENERAL_DTEMPLIM_LOWER_Pos        0                                                       /*!< SCU_GENERAL DTEMPLIM: LOWER Position    */
#define SCU_GENERAL_DTEMPLIM_LOWER_Msk        (0x000003ffUL << SCU_GENERAL_DTEMPLIM_LOWER_Pos)        /*!< SCU_GENERAL DTEMPLIM: LOWER Mask        */
#define SCU_GENERAL_DTEMPLIM_UPPER_Pos        16                                                      /*!< SCU_GENERAL DTEMPLIM: UPPER Position    */
#define SCU_GENERAL_DTEMPLIM_UPPER_Msk        (0x000003ffUL << SCU_GENERAL_DTEMPLIM_UPPER_Pos)        /*!< SCU_GENERAL DTEMPLIM: UPPER Mask        */

/* ---------------------------  SCU_GENERAL_DTEMPALARM  --------------------------- */
#define SCU_GENERAL_DTEMPALARM_UNDERFL_Pos    0                                                       /*!< SCU_GENERAL DTEMPALARM: UNDERFL Position */
#define SCU_GENERAL_DTEMPALARM_UNDERFL_Msk    (0x01UL << SCU_GENERAL_DTEMPALARM_UNDERFL_Pos)          /*!< SCU_GENERAL DTEMPALARM: UNDERFL Mask    */
#define SCU_GENERAL_DTEMPALARM_OVERFL_Pos     16                                                      /*!< SCU_GENERAL DTEMPALARM: OVERFL Position */
#define SCU_GENERAL_DTEMPALARM_OVERFL_Msk     (0x01UL << SCU_GENERAL_DTEMPALARM_OVERFL_Pos)           /*!< SCU_GENERAL DTEMPALARM: OVERFL Mask     */

/* -----------------------------  SCU_GENERAL_MIRRSTS  ---------------------------- */
#define SCU_GENERAL_MIRRSTS_HDCLR_Pos         1                                                       /*!< SCU_GENERAL MIRRSTS: HDCLR Position     */
#define SCU_GENERAL_MIRRSTS_HDCLR_Msk         (0x01UL << SCU_GENERAL_MIRRSTS_HDCLR_Pos)               /*!< SCU_GENERAL MIRRSTS: HDCLR Mask         */
#define SCU_GENERAL_MIRRSTS_HDSET_Pos         2                                                       /*!< SCU_GENERAL MIRRSTS: HDSET Position     */
#define SCU_GENERAL_MIRRSTS_HDSET_Msk         (0x01UL << SCU_GENERAL_MIRRSTS_HDSET_Pos)               /*!< SCU_GENERAL MIRRSTS: HDSET Mask         */
#define SCU_GENERAL_MIRRSTS_HDCR_Pos          3                                                       /*!< SCU_GENERAL MIRRSTS: HDCR Position      */
#define SCU_GENERAL_MIRRSTS_HDCR_Msk          (0x01UL << SCU_GENERAL_MIRRSTS_HDCR_Pos)                /*!< SCU_GENERAL MIRRSTS: HDCR Mask          */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Pos     5                                                       /*!< SCU_GENERAL MIRRSTS: OSCSICTRL Position */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_OSCSICTRL_Pos)           /*!< SCU_GENERAL MIRRSTS: OSCSICTRL Mask     */
#define SCU_GENERAL_MIRRSTS_OSCULSTAT_Pos     6                                                       /*!< SCU_GENERAL MIRRSTS: OSCULSTAT Position */
#define SCU_GENERAL_MIRRSTS_OSCULSTAT_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_OSCULSTAT_Pos)           /*!< SCU_GENERAL MIRRSTS: OSCULSTAT Mask     */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Pos     7                                                       /*!< SCU_GENERAL MIRRSTS: OSCULCTRL Position */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_OSCULCTRL_Pos)           /*!< SCU_GENERAL MIRRSTS: OSCULCTRL Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Pos       8                                                       /*!< SCU_GENERAL MIRRSTS: RTC_CTR Position   */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_RTC_CTR_Pos)             /*!< SCU_GENERAL MIRRSTS: RTC_CTR Mask       */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Pos     9                                                       /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 Position */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_ATIM0_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Pos     10                                                      /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 Position */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_ATIM1_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Pos      11                                                      /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 Position  */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Msk      (0x01UL << SCU_GENERAL_MIRRSTS_RTC_TIM0_Pos)            /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 Mask      */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Pos      12                                                      /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 Position  */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Msk      (0x01UL << SCU_GENERAL_MIRRSTS_RTC_TIM1_Pos)            /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 Mask      */
#define SCU_GENERAL_MIRRSTS_RMX_Pos           13                                                      /*!< SCU_GENERAL MIRRSTS: RMX Position       */
#define SCU_GENERAL_MIRRSTS_RMX_Msk           (0x01UL << SCU_GENERAL_MIRRSTS_RMX_Pos)                 /*!< SCU_GENERAL MIRRSTS: RMX Mask           */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Pos     14                                                      /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR Position */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_MSKSR_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Pos     15                                                      /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR Position */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_CLRSR_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR Mask     */
#define SCU_GENERAL_MIRRSTS_LPACCONF_Pos      16                                                      /*!< SCU_GENERAL MIRRSTS: LPACCONF Position  */
#define SCU_GENERAL_MIRRSTS_LPACCONF_Msk      (0x01UL << SCU_GENERAL_MIRRSTS_LPACCONF_Pos)            /*!< SCU_GENERAL MIRRSTS: LPACCONF Mask      */
#define SCU_GENERAL_MIRRSTS_LPACTH0_Pos       17                                                      /*!< SCU_GENERAL MIRRSTS: LPACTH0 Position   */
#define SCU_GENERAL_MIRRSTS_LPACTH0_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_LPACTH0_Pos)             /*!< SCU_GENERAL MIRRSTS: LPACTH0 Mask       */
#define SCU_GENERAL_MIRRSTS_LPACCLR_Pos       20                                                      /*!< SCU_GENERAL MIRRSTS: LPACCLR Position   */
#define SCU_GENERAL_MIRRSTS_LPACCLR_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_LPACCLR_Pos)             /*!< SCU_GENERAL MIRRSTS: LPACCLR Mask       */
#define SCU_GENERAL_MIRRSTS_LPACSET_Pos       21                                                      /*!< SCU_GENERAL MIRRSTS: LPACSET Position   */
#define SCU_GENERAL_MIRRSTS_LPACSET_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_LPACSET_Pos)             /*!< SCU_GENERAL MIRRSTS: LPACSET Mask       */
#define SCU_GENERAL_MIRRSTS_HINTCLR_Pos       23                                                      /*!< SCU_GENERAL MIRRSTS: HINTCLR Position   */
#define SCU_GENERAL_MIRRSTS_HINTCLR_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_HINTCLR_Pos)             /*!< SCU_GENERAL MIRRSTS: HINTCLR Mask       */
#define SCU_GENERAL_MIRRSTS_HINTSET_Pos       24                                                      /*!< SCU_GENERAL MIRRSTS: HINTSET Position   */
#define SCU_GENERAL_MIRRSTS_HINTSET_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_HINTSET_Pos)             /*!< SCU_GENERAL MIRRSTS: HINTSET Mask       */

/* ------------------------------  SCU_GENERAL_RMACR  ----------------------------- */
#define SCU_GENERAL_RMACR_RDWR_Pos            0                                                       /*!< SCU_GENERAL RMACR: RDWR Position        */
#define SCU_GENERAL_RMACR_RDWR_Msk            (0x01UL << SCU_GENERAL_RMACR_RDWR_Pos)                  /*!< SCU_GENERAL RMACR: RDWR Mask            */
#define SCU_GENERAL_RMACR_ADDR_Pos            16                                                      /*!< SCU_GENERAL RMACR: ADDR Position        */
#define SCU_GENERAL_RMACR_ADDR_Msk            (0x0fUL << SCU_GENERAL_RMACR_ADDR_Pos)                  /*!< SCU_GENERAL RMACR: ADDR Mask            */

/* -----------------------------  SCU_GENERAL_RMDATA  ----------------------------- */
#define SCU_GENERAL_RMDATA_DATA_Pos           0                                                       /*!< SCU_GENERAL RMDATA: DATA Position       */
#define SCU_GENERAL_RMDATA_DATA_Msk           (0xffffffffUL << SCU_GENERAL_RMDATA_DATA_Pos)           /*!< SCU_GENERAL RMDATA: DATA Mask           */

/* ---------------------------  SCU_GENERAL_MIRRALLSTAT  -------------------------- */
#define SCU_GENERAL_MIRRALLSTAT_BUSY_Pos      0                                                       /*!< SCU_GENERAL MIRRALLSTAT: BUSY Position  */
#define SCU_GENERAL_MIRRALLSTAT_BUSY_Msk      (0x01UL << SCU_GENERAL_MIRRALLSTAT_BUSY_Pos)            /*!< SCU_GENERAL MIRRALLSTAT: BUSY Mask      */

/* ---------------------------  SCU_GENERAL_MIRRALLREQ  --------------------------- */
#define SCU_GENERAL_MIRRALLREQ_REQ_Pos        0                                                       /*!< SCU_GENERAL MIRRALLREQ: REQ Position    */
#define SCU_GENERAL_MIRRALLREQ_REQ_Msk        (0x01UL << SCU_GENERAL_MIRRALLREQ_REQ_Pos)              /*!< SCU_GENERAL MIRRALLREQ: REQ Mask        */


/* ================================================================================ */
/* ================     struct 'SCU_INTERRUPT' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_INTERRUPT_SRSTAT  ---------------------------- */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Pos       0                                                       /*!< SCU_INTERRUPT SRSTAT: PRWARN Position   */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_PRWARN_Pos)             /*!< SCU_INTERRUPT SRSTAT: PRWARN Mask       */
#define SCU_INTERRUPT_SRSTAT_PI_Pos           1                                                       /*!< SCU_INTERRUPT SRSTAT: PI Position       */
#define SCU_INTERRUPT_SRSTAT_PI_Msk           (0x01UL << SCU_INTERRUPT_SRSTAT_PI_Pos)                 /*!< SCU_INTERRUPT SRSTAT: PI Mask           */
#define SCU_INTERRUPT_SRSTAT_AI_Pos           2                                                       /*!< SCU_INTERRUPT SRSTAT: AI Position       */
#define SCU_INTERRUPT_SRSTAT_AI_Msk           (0x01UL << SCU_INTERRUPT_SRSTAT_AI_Pos)                 /*!< SCU_INTERRUPT SRSTAT: AI Mask           */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Pos       3                                                       /*!< SCU_INTERRUPT SRSTAT: DLROVR Position   */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_DLROVR_Pos)             /*!< SCU_INTERRUPT SRSTAT: DLROVR Mask       */
#define SCU_INTERRUPT_SRSTAT_LPACCR_Pos       6                                                       /*!< SCU_INTERRUPT SRSTAT: LPACCR Position   */
#define SCU_INTERRUPT_SRSTAT_LPACCR_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_LPACCR_Pos)             /*!< SCU_INTERRUPT SRSTAT: LPACCR Mask       */
#define SCU_INTERRUPT_SRSTAT_LPACTH0_Pos      7                                                       /*!< SCU_INTERRUPT SRSTAT: LPACTH0 Position  */
#define SCU_INTERRUPT_SRSTAT_LPACTH0_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_LPACTH0_Pos)            /*!< SCU_INTERRUPT SRSTAT: LPACTH0 Mask      */
#define SCU_INTERRUPT_SRSTAT_LPACST_Pos       9                                                       /*!< SCU_INTERRUPT SRSTAT: LPACST Position   */
#define SCU_INTERRUPT_SRSTAT_LPACST_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_LPACST_Pos)             /*!< SCU_INTERRUPT SRSTAT: LPACST Mask       */
#define SCU_INTERRUPT_SRSTAT_LPACCLR_Pos      10                                                      /*!< SCU_INTERRUPT SRSTAT: LPACCLR Position  */
#define SCU_INTERRUPT_SRSTAT_LPACCLR_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_LPACCLR_Pos)            /*!< SCU_INTERRUPT SRSTAT: LPACCLR Mask      */
#define SCU_INTERRUPT_SRSTAT_LPACSET_Pos      11                                                      /*!< SCU_INTERRUPT SRSTAT: LPACSET Position  */
#define SCU_INTERRUPT_SRSTAT_LPACSET_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_LPACSET_Pos)            /*!< SCU_INTERRUPT SRSTAT: LPACSET Mask      */
#define SCU_INTERRUPT_SRSTAT_HINTST_Pos       12                                                      /*!< SCU_INTERRUPT SRSTAT: HINTST Position   */
#define SCU_INTERRUPT_SRSTAT_HINTST_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_HINTST_Pos)             /*!< SCU_INTERRUPT SRSTAT: HINTST Mask       */
#define SCU_INTERRUPT_SRSTAT_HINTCLR_Pos      13                                                      /*!< SCU_INTERRUPT SRSTAT: HINTCLR Position  */
#define SCU_INTERRUPT_SRSTAT_HINTCLR_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_HINTCLR_Pos)            /*!< SCU_INTERRUPT SRSTAT: HINTCLR Mask      */
#define SCU_INTERRUPT_SRSTAT_HINTSET_Pos      14                                                      /*!< SCU_INTERRUPT SRSTAT: HINTSET Position  */
#define SCU_INTERRUPT_SRSTAT_HINTSET_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_HINTSET_Pos)            /*!< SCU_INTERRUPT SRSTAT: HINTSET Mask      */
#define SCU_INTERRUPT_SRSTAT_HDSTAT_Pos       16                                                      /*!< SCU_INTERRUPT SRSTAT: HDSTAT Position   */
#define SCU_INTERRUPT_SRSTAT_HDSTAT_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_HDSTAT_Pos)             /*!< SCU_INTERRUPT SRSTAT: HDSTAT Mask       */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Pos        17                                                      /*!< SCU_INTERRUPT SRSTAT: HDCLR Position    */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Msk        (0x01UL << SCU_INTERRUPT_SRSTAT_HDCLR_Pos)              /*!< SCU_INTERRUPT SRSTAT: HDCLR Mask        */
#define SCU_INTERRUPT_SRSTAT_HDSET_Pos        18                                                      /*!< SCU_INTERRUPT SRSTAT: HDSET Position    */
#define SCU_INTERRUPT_SRSTAT_HDSET_Msk        (0x01UL << SCU_INTERRUPT_SRSTAT_HDSET_Pos)              /*!< SCU_INTERRUPT SRSTAT: HDSET Mask        */
#define SCU_INTERRUPT_SRSTAT_HDCR_Pos         19                                                      /*!< SCU_INTERRUPT SRSTAT: HDCR Position     */
#define SCU_INTERRUPT_SRSTAT_HDCR_Msk         (0x01UL << SCU_INTERRUPT_SRSTAT_HDCR_Pos)               /*!< SCU_INTERRUPT SRSTAT: HDCR Mask         */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Pos    21                                                      /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL Position */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_OSCSICTRL_Pos)          /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL Mask    */
#define SCU_INTERRUPT_SRSTAT_OSCULSTAT_Pos    22                                                      /*!< SCU_INTERRUPT SRSTAT: OSCULSTAT Position */
#define SCU_INTERRUPT_SRSTAT_OSCULSTAT_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_OSCULSTAT_Pos)          /*!< SCU_INTERRUPT SRSTAT: OSCULSTAT Mask    */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Pos    23                                                      /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL Position */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_OSCULCTRL_Pos)          /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL Mask    */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Pos      24                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_CTR Position  */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_CTR_Pos)            /*!< SCU_INTERRUPT SRSTAT: RTC_CTR Mask      */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Pos    25                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Pos)          /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 Mask    */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Pos    26                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Pos)          /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 Mask    */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Pos     27                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Msk     (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_TIM0_Pos)           /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 Mask     */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Pos     28                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Msk     (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_TIM1_Pos)           /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 Mask     */
#define SCU_INTERRUPT_SRSTAT_RMX_Pos          29                                                      /*!< SCU_INTERRUPT SRSTAT: RMX Position      */
#define SCU_INTERRUPT_SRSTAT_RMX_Msk          (0x01UL << SCU_INTERRUPT_SRSTAT_RMX_Pos)                /*!< SCU_INTERRUPT SRSTAT: RMX Mask          */

/* -----------------------------  SCU_INTERRUPT_SRRAW  ---------------------------- */
#define SCU_INTERRUPT_SRRAW_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRRAW: PRWARN Position    */
#define SCU_INTERRUPT_SRRAW_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_PRWARN_Pos)              /*!< SCU_INTERRUPT SRRAW: PRWARN Mask        */
#define SCU_INTERRUPT_SRRAW_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRRAW: PI Position        */
#define SCU_INTERRUPT_SRRAW_PI_Msk            (0x01UL << SCU_INTERRUPT_SRRAW_PI_Pos)                  /*!< SCU_INTERRUPT SRRAW: PI Mask            */
#define SCU_INTERRUPT_SRRAW_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRRAW: AI Position        */
#define SCU_INTERRUPT_SRRAW_AI_Msk            (0x01UL << SCU_INTERRUPT_SRRAW_AI_Pos)                  /*!< SCU_INTERRUPT SRRAW: AI Mask            */
#define SCU_INTERRUPT_SRRAW_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRRAW: DLROVR Position    */
#define SCU_INTERRUPT_SRRAW_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_DLROVR_Pos)              /*!< SCU_INTERRUPT SRRAW: DLROVR Mask        */
#define SCU_INTERRUPT_SRRAW_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRRAW: LPACCR Position    */
#define SCU_INTERRUPT_SRRAW_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_LPACCR_Pos)              /*!< SCU_INTERRUPT SRRAW: LPACCR Mask        */
#define SCU_INTERRUPT_SRRAW_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRRAW: LPACTH0 Position   */
#define SCU_INTERRUPT_SRRAW_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRRAW: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRRAW_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRRAW: LPACST Position    */
#define SCU_INTERRUPT_SRRAW_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_LPACST_Pos)              /*!< SCU_INTERRUPT SRRAW: LPACST Mask        */
#define SCU_INTERRUPT_SRRAW_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRRAW: LPACCLR Position   */
#define SCU_INTERRUPT_SRRAW_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRRAW: LPACCLR Mask       */
#define SCU_INTERRUPT_SRRAW_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRRAW: LPACSET Position   */
#define SCU_INTERRUPT_SRRAW_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_LPACSET_Pos)             /*!< SCU_INTERRUPT SRRAW: LPACSET Mask       */
#define SCU_INTERRUPT_SRRAW_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRRAW: HINTST Position    */
#define SCU_INTERRUPT_SRRAW_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_HINTST_Pos)              /*!< SCU_INTERRUPT SRRAW: HINTST Mask        */
#define SCU_INTERRUPT_SRRAW_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRRAW: HINTCLR Position   */
#define SCU_INTERRUPT_SRRAW_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRRAW: HINTCLR Mask       */
#define SCU_INTERRUPT_SRRAW_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRRAW: HINTSET Position   */
#define SCU_INTERRUPT_SRRAW_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_HINTSET_Pos)             /*!< SCU_INTERRUPT SRRAW: HINTSET Mask       */
#define SCU_INTERRUPT_SRRAW_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRRAW: HDSTAT Position    */
#define SCU_INTERRUPT_SRRAW_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRRAW: HDSTAT Mask        */
#define SCU_INTERRUPT_SRRAW_HDCLR_Pos         17                                                      /*!< SCU_INTERRUPT SRRAW: HDCLR Position     */
#define SCU_INTERRUPT_SRRAW_HDCLR_Msk         (0x01UL << SCU_INTERRUPT_SRRAW_HDCLR_Pos)               /*!< SCU_INTERRUPT SRRAW: HDCLR Mask         */
#define SCU_INTERRUPT_SRRAW_HDSET_Pos         18                                                      /*!< SCU_INTERRUPT SRRAW: HDSET Position     */
#define SCU_INTERRUPT_SRRAW_HDSET_Msk         (0x01UL << SCU_INTERRUPT_SRRAW_HDSET_Pos)               /*!< SCU_INTERRUPT SRRAW: HDSET Mask         */
#define SCU_INTERRUPT_SRRAW_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRRAW: HDCR Position      */
#define SCU_INTERRUPT_SRRAW_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRRAW_HDCR_Pos)                /*!< SCU_INTERRUPT SRRAW: HDCR Mask          */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRRAW: OSCSICTRL Position */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRRAW: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRRAW_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRRAW: OSCULSTAT Position */
#define SCU_INTERRUPT_SRRAW_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRRAW: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRRAW: OSCULCTRL Position */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRRAW: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRRAW: RTC_CTR Position   */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRRAW: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRRAW_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRRAW_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRRAW_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRRAW: RMX Position       */
#define SCU_INTERRUPT_SRRAW_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRRAW_RMX_Pos)                 /*!< SCU_INTERRUPT SRRAW: RMX Mask           */

/* -----------------------------  SCU_INTERRUPT_SRMSK  ---------------------------- */
#define SCU_INTERRUPT_SRMSK_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRMSK: PRWARN Position    */
#define SCU_INTERRUPT_SRMSK_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_PRWARN_Pos)              /*!< SCU_INTERRUPT SRMSK: PRWARN Mask        */
#define SCU_INTERRUPT_SRMSK_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRMSK: PI Position        */
#define SCU_INTERRUPT_SRMSK_PI_Msk            (0x01UL << SCU_INTERRUPT_SRMSK_PI_Pos)                  /*!< SCU_INTERRUPT SRMSK: PI Mask            */
#define SCU_INTERRUPT_SRMSK_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRMSK: AI Position        */
#define SCU_INTERRUPT_SRMSK_AI_Msk            (0x01UL << SCU_INTERRUPT_SRMSK_AI_Pos)                  /*!< SCU_INTERRUPT SRMSK: AI Mask            */
#define SCU_INTERRUPT_SRMSK_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRMSK: DLROVR Position    */
#define SCU_INTERRUPT_SRMSK_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_DLROVR_Pos)              /*!< SCU_INTERRUPT SRMSK: DLROVR Mask        */
#define SCU_INTERRUPT_SRMSK_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRMSK: LPACCR Position    */
#define SCU_INTERRUPT_SRMSK_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_LPACCR_Pos)              /*!< SCU_INTERRUPT SRMSK: LPACCR Mask        */
#define SCU_INTERRUPT_SRMSK_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRMSK: LPACTH0 Position   */
#define SCU_INTERRUPT_SRMSK_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRMSK: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRMSK_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRMSK: LPACST Position    */
#define SCU_INTERRUPT_SRMSK_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_LPACST_Pos)              /*!< SCU_INTERRUPT SRMSK: LPACST Mask        */
#define SCU_INTERRUPT_SRMSK_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRMSK: LPACCLR Position   */
#define SCU_INTERRUPT_SRMSK_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRMSK: LPACCLR Mask       */
#define SCU_INTERRUPT_SRMSK_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRMSK: LPACSET Position   */
#define SCU_INTERRUPT_SRMSK_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_LPACSET_Pos)             /*!< SCU_INTERRUPT SRMSK: LPACSET Mask       */
#define SCU_INTERRUPT_SRMSK_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRMSK: HINTST Position    */
#define SCU_INTERRUPT_SRMSK_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_HINTST_Pos)              /*!< SCU_INTERRUPT SRMSK: HINTST Mask        */
#define SCU_INTERRUPT_SRMSK_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRMSK: HINTCLR Position   */
#define SCU_INTERRUPT_SRMSK_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRMSK: HINTCLR Mask       */
#define SCU_INTERRUPT_SRMSK_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRMSK: HINTSET Position   */
#define SCU_INTERRUPT_SRMSK_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_HINTSET_Pos)             /*!< SCU_INTERRUPT SRMSK: HINTSET Mask       */
#define SCU_INTERRUPT_SRMSK_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRMSK: HDSTAT Position    */
#define SCU_INTERRUPT_SRMSK_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRMSK: HDSTAT Mask        */
#define SCU_INTERRUPT_SRMSK_HDCLR_Pos         17                                                      /*!< SCU_INTERRUPT SRMSK: HDCLR Position     */
#define SCU_INTERRUPT_SRMSK_HDCLR_Msk         (0x01UL << SCU_INTERRUPT_SRMSK_HDCLR_Pos)               /*!< SCU_INTERRUPT SRMSK: HDCLR Mask         */
#define SCU_INTERRUPT_SRMSK_HDSET_Pos         18                                                      /*!< SCU_INTERRUPT SRMSK: HDSET Position     */
#define SCU_INTERRUPT_SRMSK_HDSET_Msk         (0x01UL << SCU_INTERRUPT_SRMSK_HDSET_Pos)               /*!< SCU_INTERRUPT SRMSK: HDSET Mask         */
#define SCU_INTERRUPT_SRMSK_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRMSK: HDCR Position      */
#define SCU_INTERRUPT_SRMSK_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRMSK_HDCR_Pos)                /*!< SCU_INTERRUPT SRMSK: HDCR Mask          */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRMSK: OSCSICTRL Position */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRMSK: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRMSK_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRMSK: OSCULSTAT Position */
#define SCU_INTERRUPT_SRMSK_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRMSK: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRMSK: OSCULCTRL Position */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRMSK: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRMSK: RTC_CTR Position   */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRMSK: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRMSK_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRMSK_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRMSK_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRMSK: RMX Position       */
#define SCU_INTERRUPT_SRMSK_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRMSK_RMX_Pos)                 /*!< SCU_INTERRUPT SRMSK: RMX Mask           */

/* -----------------------------  SCU_INTERRUPT_SRCLR  ---------------------------- */
#define SCU_INTERRUPT_SRCLR_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRCLR: PRWARN Position    */
#define SCU_INTERRUPT_SRCLR_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_PRWARN_Pos)              /*!< SCU_INTERRUPT SRCLR: PRWARN Mask        */
#define SCU_INTERRUPT_SRCLR_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRCLR: PI Position        */
#define SCU_INTERRUPT_SRCLR_PI_Msk            (0x01UL << SCU_INTERRUPT_SRCLR_PI_Pos)                  /*!< SCU_INTERRUPT SRCLR: PI Mask            */
#define SCU_INTERRUPT_SRCLR_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRCLR: AI Position        */
#define SCU_INTERRUPT_SRCLR_AI_Msk            (0x01UL << SCU_INTERRUPT_SRCLR_AI_Pos)                  /*!< SCU_INTERRUPT SRCLR: AI Mask            */
#define SCU_INTERRUPT_SRCLR_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRCLR: DLROVR Position    */
#define SCU_INTERRUPT_SRCLR_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_DLROVR_Pos)              /*!< SCU_INTERRUPT SRCLR: DLROVR Mask        */
#define SCU_INTERRUPT_SRCLR_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRCLR: LPACCR Position    */
#define SCU_INTERRUPT_SRCLR_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_LPACCR_Pos)              /*!< SCU_INTERRUPT SRCLR: LPACCR Mask        */
#define SCU_INTERRUPT_SRCLR_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRCLR: LPACTH0 Position   */
#define SCU_INTERRUPT_SRCLR_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRCLR: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRCLR_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRCLR: LPACST Position    */
#define SCU_INTERRUPT_SRCLR_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_LPACST_Pos)              /*!< SCU_INTERRUPT SRCLR: LPACST Mask        */
#define SCU_INTERRUPT_SRCLR_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRCLR: LPACCLR Position   */
#define SCU_INTERRUPT_SRCLR_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRCLR: LPACCLR Mask       */
#define SCU_INTERRUPT_SRCLR_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRCLR: LPACSET Position   */
#define SCU_INTERRUPT_SRCLR_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_LPACSET_Pos)             /*!< SCU_INTERRUPT SRCLR: LPACSET Mask       */
#define SCU_INTERRUPT_SRCLR_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRCLR: HINTST Position    */
#define SCU_INTERRUPT_SRCLR_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_HINTST_Pos)              /*!< SCU_INTERRUPT SRCLR: HINTST Mask        */
#define SCU_INTERRUPT_SRCLR_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRCLR: HINTCLR Position   */
#define SCU_INTERRUPT_SRCLR_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRCLR: HINTCLR Mask       */
#define SCU_INTERRUPT_SRCLR_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRCLR: HINTSET Position   */
#define SCU_INTERRUPT_SRCLR_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_HINTSET_Pos)             /*!< SCU_INTERRUPT SRCLR: HINTSET Mask       */
#define SCU_INTERRUPT_SRCLR_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRCLR: HDSTAT Position    */
#define SCU_INTERRUPT_SRCLR_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRCLR: HDSTAT Mask        */
#define SCU_INTERRUPT_SRCLR_HDCLR_Pos         17                                                      /*!< SCU_INTERRUPT SRCLR: HDCLR Position     */
#define SCU_INTERRUPT_SRCLR_HDCLR_Msk         (0x01UL << SCU_INTERRUPT_SRCLR_HDCLR_Pos)               /*!< SCU_INTERRUPT SRCLR: HDCLR Mask         */
#define SCU_INTERRUPT_SRCLR_HDSET_Pos         18                                                      /*!< SCU_INTERRUPT SRCLR: HDSET Position     */
#define SCU_INTERRUPT_SRCLR_HDSET_Msk         (0x01UL << SCU_INTERRUPT_SRCLR_HDSET_Pos)               /*!< SCU_INTERRUPT SRCLR: HDSET Mask         */
#define SCU_INTERRUPT_SRCLR_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRCLR: HDCR Position      */
#define SCU_INTERRUPT_SRCLR_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRCLR_HDCR_Pos)                /*!< SCU_INTERRUPT SRCLR: HDCR Mask          */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRCLR: OSCSICTRL Position */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRCLR: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRCLR_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRCLR: OSCULSTAT Position */
#define SCU_INTERRUPT_SRCLR_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRCLR: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRCLR: OSCULCTRL Position */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRCLR: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRCLR: RTC_CTR Position   */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRCLR: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRCLR_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRCLR_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRCLR_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRCLR: RMX Position       */
#define SCU_INTERRUPT_SRCLR_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRCLR_RMX_Pos)                 /*!< SCU_INTERRUPT SRCLR: RMX Mask           */

/* -----------------------------  SCU_INTERRUPT_SRSET  ---------------------------- */
#define SCU_INTERRUPT_SRSET_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRSET: PRWARN Position    */
#define SCU_INTERRUPT_SRSET_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRSET_PRWARN_Pos)              /*!< SCU_INTERRUPT SRSET: PRWARN Mask        */
#define SCU_INTERRUPT_SRSET_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRSET: PI Position        */
#define SCU_INTERRUPT_SRSET_PI_Msk            (0x01UL << SCU_INTERRUPT_SRSET_PI_Pos)                  /*!< SCU_INTERRUPT SRSET: PI Mask            */
#define SCU_INTERRUPT_SRSET_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRSET: AI Position        */
#define SCU_INTERRUPT_SRSET_AI_Msk            (0x01UL << SCU_INTERRUPT_SRSET_AI_Pos)                  /*!< SCU_INTERRUPT SRSET: AI Mask            */
#define SCU_INTERRUPT_SRSET_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRSET: DLROVR Position    */
#define SCU_INTERRUPT_SRSET_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRSET_DLROVR_Pos)              /*!< SCU_INTERRUPT SRSET: DLROVR Mask        */
#define SCU_INTERRUPT_SRSET_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRSET: LPACCR Position    */
#define SCU_INTERRUPT_SRSET_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRSET_LPACCR_Pos)              /*!< SCU_INTERRUPT SRSET: LPACCR Mask        */
#define SCU_INTERRUPT_SRSET_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRSET: LPACTH0 Position   */
#define SCU_INTERRUPT_SRSET_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRSET_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRSET: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRSET_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRSET: LPACST Position    */
#define SCU_INTERRUPT_SRSET_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRSET_LPACST_Pos)              /*!< SCU_INTERRUPT SRSET: LPACST Mask        */
#define SCU_INTERRUPT_SRSET_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRSET: LPACCLR Position   */
#define SCU_INTERRUPT_SRSET_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRSET: LPACCLR Mask       */
#define SCU_INTERRUPT_SRSET_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRSET: LPACSET Position   */
#define SCU_INTERRUPT_SRSET_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRSET_LPACSET_Pos)             /*!< SCU_INTERRUPT SRSET: LPACSET Mask       */
#define SCU_INTERRUPT_SRSET_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRSET: HINTST Position    */
#define SCU_INTERRUPT_SRSET_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRSET_HINTST_Pos)              /*!< SCU_INTERRUPT SRSET: HINTST Mask        */
#define SCU_INTERRUPT_SRSET_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRSET: HINTCLR Position   */
#define SCU_INTERRUPT_SRSET_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRSET: HINTCLR Mask       */
#define SCU_INTERRUPT_SRSET_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRSET: HINTSET Position   */
#define SCU_INTERRUPT_SRSET_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HINTSET_Pos)             /*!< SCU_INTERRUPT SRSET: HINTSET Mask       */
#define SCU_INTERRUPT_SRSET_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRSET: HDSTAT Position    */
#define SCU_INTERRUPT_SRSET_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRSET_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRSET: HDSTAT Mask        */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Pos       17                                                      /*!< SCU_INTERRUPT SRSET: HDCRCLR Position   */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HDCRCLR_Pos)             /*!< SCU_INTERRUPT SRSET: HDCRCLR Mask       */
#define SCU_INTERRUPT_SRSET_HDCRSET_Pos       18                                                      /*!< SCU_INTERRUPT SRSET: HDCRSET Position   */
#define SCU_INTERRUPT_SRSET_HDCRSET_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HDCRSET_Pos)             /*!< SCU_INTERRUPT SRSET: HDCRSET Mask       */
#define SCU_INTERRUPT_SRSET_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRSET: HDCR Position      */
#define SCU_INTERRUPT_SRSET_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRSET_HDCR_Pos)                /*!< SCU_INTERRUPT SRSET: HDCR Mask          */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRSET: OSCSICTRL Position */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRSET_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRSET: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRSET_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRSET: OSCULSTAT Position */
#define SCU_INTERRUPT_SRSET_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRSET_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRSET: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRSET: OSCULCTRL Position */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRSET_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRSET: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRSET: RTC_CTR Position   */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRSET: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRSET_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRSET_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRSET: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRSET_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRSET: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRSET: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRSET_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRSET: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRSET_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRSET: RMX Position       */
#define SCU_INTERRUPT_SRSET_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRSET_RMX_Pos)                 /*!< SCU_INTERRUPT SRSET: RMX Mask           */

/* ---------------------------  SCU_INTERRUPT_NMIREQEN  --------------------------- */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Pos     0                                                       /*!< SCU_INTERRUPT NMIREQEN: PRWARN Position */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Msk     (0x01UL << SCU_INTERRUPT_NMIREQEN_PRWARN_Pos)           /*!< SCU_INTERRUPT NMIREQEN: PRWARN Mask     */
#define SCU_INTERRUPT_NMIREQEN_PI_Pos         1                                                       /*!< SCU_INTERRUPT NMIREQEN: PI Position     */
#define SCU_INTERRUPT_NMIREQEN_PI_Msk         (0x01UL << SCU_INTERRUPT_NMIREQEN_PI_Pos)               /*!< SCU_INTERRUPT NMIREQEN: PI Mask         */
#define SCU_INTERRUPT_NMIREQEN_AI_Pos         2                                                       /*!< SCU_INTERRUPT NMIREQEN: AI Position     */
#define SCU_INTERRUPT_NMIREQEN_AI_Msk         (0x01UL << SCU_INTERRUPT_NMIREQEN_AI_Pos)               /*!< SCU_INTERRUPT NMIREQEN: AI Mask         */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Pos      16                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU00 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU00_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU00 Mask      */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Pos      17                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU01 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU01_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU01 Mask      */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Pos      18                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU02 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU02_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU02 Mask      */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Pos      19                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU03 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU03_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU03 Mask      */


/* ================================================================================ */
/* ================       struct 'SCU_PARITY' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PARITY_PEEN  ------------------------------ */
#define SCU_PARITY_PEEN_PEENPS_Pos            0                                                       /*!< SCU_PARITY PEEN: PEENPS Position        */
#define SCU_PARITY_PEEN_PEENPS_Msk            (0x01UL << SCU_PARITY_PEEN_PEENPS_Pos)                  /*!< SCU_PARITY PEEN: PEENPS Mask            */
#define SCU_PARITY_PEEN_PEENDS1_Pos           1                                                       /*!< SCU_PARITY PEEN: PEENDS1 Position       */
#define SCU_PARITY_PEEN_PEENDS1_Msk           (0x01UL << SCU_PARITY_PEEN_PEENDS1_Pos)                 /*!< SCU_PARITY PEEN: PEENDS1 Mask           */
#define SCU_PARITY_PEEN_PEENU0_Pos            8                                                       /*!< SCU_PARITY PEEN: PEENU0 Position        */
#define SCU_PARITY_PEEN_PEENU0_Msk            (0x01UL << SCU_PARITY_PEEN_PEENU0_Pos)                  /*!< SCU_PARITY PEEN: PEENU0 Mask            */
#define SCU_PARITY_PEEN_PEENU1_Pos            9                                                       /*!< SCU_PARITY PEEN: PEENU1 Position        */
#define SCU_PARITY_PEEN_PEENU1_Msk            (0x01UL << SCU_PARITY_PEEN_PEENU1_Pos)                  /*!< SCU_PARITY PEEN: PEENU1 Mask            */
#define SCU_PARITY_PEEN_PEENMC_Pos            12                                                      /*!< SCU_PARITY PEEN: PEENMC Position        */
#define SCU_PARITY_PEEN_PEENMC_Msk            (0x01UL << SCU_PARITY_PEEN_PEENMC_Pos)                  /*!< SCU_PARITY PEEN: PEENMC Mask            */
#define SCU_PARITY_PEEN_PEENPPRF_Pos          13                                                      /*!< SCU_PARITY PEEN: PEENPPRF Position      */
#define SCU_PARITY_PEEN_PEENPPRF_Msk          (0x01UL << SCU_PARITY_PEEN_PEENPPRF_Pos)                /*!< SCU_PARITY PEEN: PEENPPRF Mask          */
#define SCU_PARITY_PEEN_PEENUSB_Pos           16                                                      /*!< SCU_PARITY PEEN: PEENUSB Position       */
#define SCU_PARITY_PEEN_PEENUSB_Msk           (0x01UL << SCU_PARITY_PEEN_PEENUSB_Pos)                 /*!< SCU_PARITY PEEN: PEENUSB Mask           */

/* -----------------------------  SCU_PARITY_MCHKCON  ----------------------------- */
#define SCU_PARITY_MCHKCON_SELPS_Pos          0                                                       /*!< SCU_PARITY MCHKCON: SELPS Position      */
#define SCU_PARITY_MCHKCON_SELPS_Msk          (0x01UL << SCU_PARITY_MCHKCON_SELPS_Pos)                /*!< SCU_PARITY MCHKCON: SELPS Mask          */
#define SCU_PARITY_MCHKCON_SELDS1_Pos         1                                                       /*!< SCU_PARITY MCHKCON: SELDS1 Position     */
#define SCU_PARITY_MCHKCON_SELDS1_Msk         (0x01UL << SCU_PARITY_MCHKCON_SELDS1_Pos)               /*!< SCU_PARITY MCHKCON: SELDS1 Mask         */
#define SCU_PARITY_MCHKCON_USIC0DRA_Pos       8                                                       /*!< SCU_PARITY MCHKCON: USIC0DRA Position   */
#define SCU_PARITY_MCHKCON_USIC0DRA_Msk       (0x01UL << SCU_PARITY_MCHKCON_USIC0DRA_Pos)             /*!< SCU_PARITY MCHKCON: USIC0DRA Mask       */
#define SCU_PARITY_MCHKCON_USIC1DRA_Pos       9                                                       /*!< SCU_PARITY MCHKCON: USIC1DRA Position   */
#define SCU_PARITY_MCHKCON_USIC1DRA_Msk       (0x01UL << SCU_PARITY_MCHKCON_USIC1DRA_Pos)             /*!< SCU_PARITY MCHKCON: USIC1DRA Mask       */
#define SCU_PARITY_MCHKCON_MCANDRA_Pos        12                                                      /*!< SCU_PARITY MCHKCON: MCANDRA Position    */
#define SCU_PARITY_MCHKCON_MCANDRA_Msk        (0x01UL << SCU_PARITY_MCHKCON_MCANDRA_Pos)              /*!< SCU_PARITY MCHKCON: MCANDRA Mask        */
#define SCU_PARITY_MCHKCON_PPRFDRA_Pos        13                                                      /*!< SCU_PARITY MCHKCON: PPRFDRA Position    */
#define SCU_PARITY_MCHKCON_PPRFDRA_Msk        (0x01UL << SCU_PARITY_MCHKCON_PPRFDRA_Pos)              /*!< SCU_PARITY MCHKCON: PPRFDRA Mask        */
#define SCU_PARITY_MCHKCON_SELUSB_Pos         16                                                      /*!< SCU_PARITY MCHKCON: SELUSB Position     */
#define SCU_PARITY_MCHKCON_SELUSB_Msk         (0x01UL << SCU_PARITY_MCHKCON_SELUSB_Pos)               /*!< SCU_PARITY MCHKCON: SELUSB Mask         */

/* -------------------------------  SCU_PARITY_PETE  ------------------------------ */
#define SCU_PARITY_PETE_PETEPS_Pos            0                                                       /*!< SCU_PARITY PETE: PETEPS Position        */
#define SCU_PARITY_PETE_PETEPS_Msk            (0x01UL << SCU_PARITY_PETE_PETEPS_Pos)                  /*!< SCU_PARITY PETE: PETEPS Mask            */
#define SCU_PARITY_PETE_PETEDS1_Pos           1                                                       /*!< SCU_PARITY PETE: PETEDS1 Position       */
#define SCU_PARITY_PETE_PETEDS1_Msk           (0x01UL << SCU_PARITY_PETE_PETEDS1_Pos)                 /*!< SCU_PARITY PETE: PETEDS1 Mask           */
#define SCU_PARITY_PETE_PETEU0_Pos            8                                                       /*!< SCU_PARITY PETE: PETEU0 Position        */
#define SCU_PARITY_PETE_PETEU0_Msk            (0x01UL << SCU_PARITY_PETE_PETEU0_Pos)                  /*!< SCU_PARITY PETE: PETEU0 Mask            */
#define SCU_PARITY_PETE_PETEU1_Pos            9                                                       /*!< SCU_PARITY PETE: PETEU1 Position        */
#define SCU_PARITY_PETE_PETEU1_Msk            (0x01UL << SCU_PARITY_PETE_PETEU1_Pos)                  /*!< SCU_PARITY PETE: PETEU1 Mask            */
#define SCU_PARITY_PETE_PETEMC_Pos            12                                                      /*!< SCU_PARITY PETE: PETEMC Position        */
#define SCU_PARITY_PETE_PETEMC_Msk            (0x01UL << SCU_PARITY_PETE_PETEMC_Pos)                  /*!< SCU_PARITY PETE: PETEMC Mask            */
#define SCU_PARITY_PETE_PETEPPRF_Pos          13                                                      /*!< SCU_PARITY PETE: PETEPPRF Position      */
#define SCU_PARITY_PETE_PETEPPRF_Msk          (0x01UL << SCU_PARITY_PETE_PETEPPRF_Pos)                /*!< SCU_PARITY PETE: PETEPPRF Mask          */
#define SCU_PARITY_PETE_PETEUSB_Pos           16                                                      /*!< SCU_PARITY PETE: PETEUSB Position       */
#define SCU_PARITY_PETE_PETEUSB_Msk           (0x01UL << SCU_PARITY_PETE_PETEUSB_Pos)                 /*!< SCU_PARITY PETE: PETEUSB Mask           */

/* -----------------------------  SCU_PARITY_PERSTEN  ----------------------------- */
#define SCU_PARITY_PERSTEN_RSEN_Pos           0                                                       /*!< SCU_PARITY PERSTEN: RSEN Position       */
#define SCU_PARITY_PERSTEN_RSEN_Msk           (0x01UL << SCU_PARITY_PERSTEN_RSEN_Pos)                 /*!< SCU_PARITY PERSTEN: RSEN Mask           */

/* ------------------------------  SCU_PARITY_PEFLAG  ----------------------------- */
#define SCU_PARITY_PEFLAG_PEFPS_Pos           0                                                       /*!< SCU_PARITY PEFLAG: PEFPS Position       */
#define SCU_PARITY_PEFLAG_PEFPS_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFPS_Pos)                 /*!< SCU_PARITY PEFLAG: PEFPS Mask           */
#define SCU_PARITY_PEFLAG_PEFDS1_Pos          1                                                       /*!< SCU_PARITY PEFLAG: PEFDS1 Position      */
#define SCU_PARITY_PEFLAG_PEFDS1_Msk          (0x01UL << SCU_PARITY_PEFLAG_PEFDS1_Pos)                /*!< SCU_PARITY PEFLAG: PEFDS1 Mask          */
#define SCU_PARITY_PEFLAG_PEFU0_Pos           8                                                       /*!< SCU_PARITY PEFLAG: PEFU0 Position       */
#define SCU_PARITY_PEFLAG_PEFU0_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFU0_Pos)                 /*!< SCU_PARITY PEFLAG: PEFU0 Mask           */
#define SCU_PARITY_PEFLAG_PEFU1_Pos           9                                                       /*!< SCU_PARITY PEFLAG: PEFU1 Position       */
#define SCU_PARITY_PEFLAG_PEFU1_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFU1_Pos)                 /*!< SCU_PARITY PEFLAG: PEFU1 Mask           */
#define SCU_PARITY_PEFLAG_PEFMC_Pos           12                                                      /*!< SCU_PARITY PEFLAG: PEFMC Position       */
#define SCU_PARITY_PEFLAG_PEFMC_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFMC_Pos)                 /*!< SCU_PARITY PEFLAG: PEFMC Mask           */
#define SCU_PARITY_PEFLAG_PEFPPRF_Pos         13                                                      /*!< SCU_PARITY PEFLAG: PEFPPRF Position     */
#define SCU_PARITY_PEFLAG_PEFPPRF_Msk         (0x01UL << SCU_PARITY_PEFLAG_PEFPPRF_Pos)               /*!< SCU_PARITY PEFLAG: PEFPPRF Mask         */
#define SCU_PARITY_PEFLAG_PEUSB_Pos           16                                                      /*!< SCU_PARITY PEFLAG: PEUSB Position       */
#define SCU_PARITY_PEFLAG_PEUSB_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEUSB_Pos)                 /*!< SCU_PARITY PEFLAG: PEUSB Mask           */

/* ------------------------------  SCU_PARITY_PMTPR  ------------------------------ */
#define SCU_PARITY_PMTPR_PWR_Pos              0                                                       /*!< SCU_PARITY PMTPR: PWR Position          */
#define SCU_PARITY_PMTPR_PWR_Msk              (0x000000ffUL << SCU_PARITY_PMTPR_PWR_Pos)              /*!< SCU_PARITY PMTPR: PWR Mask              */
#define SCU_PARITY_PMTPR_PRD_Pos              8                                                       /*!< SCU_PARITY PMTPR: PRD Position          */
#define SCU_PARITY_PMTPR_PRD_Msk              (0x000000ffUL << SCU_PARITY_PMTPR_PRD_Pos)              /*!< SCU_PARITY PMTPR: PRD Mask              */

/* ------------------------------  SCU_PARITY_PMTSR  ------------------------------ */
#define SCU_PARITY_PMTSR_MTENPS_Pos           0                                                       /*!< SCU_PARITY PMTSR: MTENPS Position       */
#define SCU_PARITY_PMTSR_MTENPS_Msk           (0x01UL << SCU_PARITY_PMTSR_MTENPS_Pos)                 /*!< SCU_PARITY PMTSR: MTENPS Mask           */
#define SCU_PARITY_PMTSR_MTENDS1_Pos          1                                                       /*!< SCU_PARITY PMTSR: MTENDS1 Position      */
#define SCU_PARITY_PMTSR_MTENDS1_Msk          (0x01UL << SCU_PARITY_PMTSR_MTENDS1_Pos)                /*!< SCU_PARITY PMTSR: MTENDS1 Mask          */
#define SCU_PARITY_PMTSR_MTEU0_Pos            8                                                       /*!< SCU_PARITY PMTSR: MTEU0 Position        */
#define SCU_PARITY_PMTSR_MTEU0_Msk            (0x01UL << SCU_PARITY_PMTSR_MTEU0_Pos)                  /*!< SCU_PARITY PMTSR: MTEU0 Mask            */
#define SCU_PARITY_PMTSR_MTEU1_Pos            9                                                       /*!< SCU_PARITY PMTSR: MTEU1 Position        */
#define SCU_PARITY_PMTSR_MTEU1_Msk            (0x01UL << SCU_PARITY_PMTSR_MTEU1_Pos)                  /*!< SCU_PARITY PMTSR: MTEU1 Mask            */
#define SCU_PARITY_PMTSR_MTEMC_Pos            12                                                      /*!< SCU_PARITY PMTSR: MTEMC Position        */
#define SCU_PARITY_PMTSR_MTEMC_Msk            (0x01UL << SCU_PARITY_PMTSR_MTEMC_Pos)                  /*!< SCU_PARITY PMTSR: MTEMC Mask            */
#define SCU_PARITY_PMTSR_MTEPPRF_Pos          13                                                      /*!< SCU_PARITY PMTSR: MTEPPRF Position      */
#define SCU_PARITY_PMTSR_MTEPPRF_Msk          (0x01UL << SCU_PARITY_PMTSR_MTEPPRF_Pos)                /*!< SCU_PARITY PMTSR: MTEPPRF Mask          */
#define SCU_PARITY_PMTSR_MTUSB_Pos            16                                                      /*!< SCU_PARITY PMTSR: MTUSB Position        */
#define SCU_PARITY_PMTSR_MTUSB_Msk            (0x01UL << SCU_PARITY_PMTSR_MTUSB_Pos)                  /*!< SCU_PARITY PMTSR: MTUSB Mask            */


/* ================================================================================ */
/* ================        struct 'SCU_TRAP' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_TRAP_TRAPSTAT  ----------------------------- */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Pos        0                                                       /*!< SCU_TRAP TRAPSTAT: SOSCWDGT Position    */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Msk        (0x01UL << SCU_TRAP_TRAPSTAT_SOSCWDGT_Pos)              /*!< SCU_TRAP TRAPSTAT: SOSCWDGT Mask        */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Pos        2                                                       /*!< SCU_TRAP TRAPSTAT: SVCOLCKT Position    */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Msk        (0x01UL << SCU_TRAP_TRAPSTAT_SVCOLCKT_Pos)              /*!< SCU_TRAP TRAPSTAT: SVCOLCKT Mask        */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Pos        3                                                       /*!< SCU_TRAP TRAPSTAT: UVCOLCKT Position    */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Msk        (0x01UL << SCU_TRAP_TRAPSTAT_UVCOLCKT_Pos)              /*!< SCU_TRAP TRAPSTAT: UVCOLCKT Mask        */
#define SCU_TRAP_TRAPSTAT_PET_Pos             4                                                       /*!< SCU_TRAP TRAPSTAT: PET Position         */
#define SCU_TRAP_TRAPSTAT_PET_Msk             (0x01UL << SCU_TRAP_TRAPSTAT_PET_Pos)                   /*!< SCU_TRAP TRAPSTAT: PET Mask             */
#define SCU_TRAP_TRAPSTAT_BRWNT_Pos           5                                                       /*!< SCU_TRAP TRAPSTAT: BRWNT Position       */
#define SCU_TRAP_TRAPSTAT_BRWNT_Msk           (0x01UL << SCU_TRAP_TRAPSTAT_BRWNT_Pos)                 /*!< SCU_TRAP TRAPSTAT: BRWNT Mask           */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Pos         6                                                       /*!< SCU_TRAP TRAPSTAT: ULPWDGT Position     */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_ULPWDGT_Pos)               /*!< SCU_TRAP TRAPSTAT: ULPWDGT Mask         */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Pos         7                                                       /*!< SCU_TRAP TRAPSTAT: BWERR0T Position     */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_BWERR0T_Pos)               /*!< SCU_TRAP TRAPSTAT: BWERR0T Mask         */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Pos         8                                                       /*!< SCU_TRAP TRAPSTAT: BWERR1T Position     */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_BWERR1T_Pos)               /*!< SCU_TRAP TRAPSTAT: BWERR1T Mask         */
#define SCU_TRAP_TRAPSTAT_TEMPHIT_Pos         12                                                      /*!< SCU_TRAP TRAPSTAT: TEMPHIT Position     */
#define SCU_TRAP_TRAPSTAT_TEMPHIT_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_TEMPHIT_Pos)               /*!< SCU_TRAP TRAPSTAT: TEMPHIT Mask         */
#define SCU_TRAP_TRAPSTAT_TEMPLOT_Pos         13                                                      /*!< SCU_TRAP TRAPSTAT: TEMPLOT Position     */
#define SCU_TRAP_TRAPSTAT_TEMPLOT_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_TEMPLOT_Pos)               /*!< SCU_TRAP TRAPSTAT: TEMPLOT Mask         */

/* ------------------------------  SCU_TRAP_TRAPRAW  ------------------------------ */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPRAW: SOSCWDGT Position     */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPRAW_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPRAW: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPRAW: SVCOLCKT Position     */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPRAW_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPRAW: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPRAW: UVCOLCKT Position     */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPRAW_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPRAW: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPRAW_PET_Pos              4                                                       /*!< SCU_TRAP TRAPRAW: PET Position          */
#define SCU_TRAP_TRAPRAW_PET_Msk              (0x01UL << SCU_TRAP_TRAPRAW_PET_Pos)                    /*!< SCU_TRAP TRAPRAW: PET Mask              */
#define SCU_TRAP_TRAPRAW_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPRAW: BRWNT Position        */
#define SCU_TRAP_TRAPRAW_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPRAW_BRWNT_Pos)                  /*!< SCU_TRAP TRAPRAW: BRWNT Mask            */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Pos          6                                                       /*!< SCU_TRAP TRAPRAW: ULPWDGT Position      */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Msk          (0x01UL << SCU_TRAP_TRAPRAW_ULPWDGT_Pos)                /*!< SCU_TRAP TRAPRAW: ULPWDGT Mask          */
#define SCU_TRAP_TRAPRAW_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPRAW: BWERR0T Position      */
#define SCU_TRAP_TRAPRAW_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPRAW_BWERR0T_Pos)                /*!< SCU_TRAP TRAPRAW: BWERR0T Mask          */
#define SCU_TRAP_TRAPRAW_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPRAW: BWERR1T Position      */
#define SCU_TRAP_TRAPRAW_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPRAW_BWERR1T_Pos)                /*!< SCU_TRAP TRAPRAW: BWERR1T Mask          */
#define SCU_TRAP_TRAPRAW_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPRAW: TEMPHIT Position      */
#define SCU_TRAP_TRAPRAW_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPRAW_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPRAW: TEMPHIT Mask          */
#define SCU_TRAP_TRAPRAW_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPRAW: TEMPLOT Position      */
#define SCU_TRAP_TRAPRAW_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPRAW_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPRAW: TEMPLOT Mask          */

/* ------------------------------  SCU_TRAP_TRAPDIS  ------------------------------ */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPDIS: SOSCWDGT Position     */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPDIS_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPDIS: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPDIS: SVCOLCKT Position     */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPDIS_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPDIS: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPDIS: UVCOLCKT Position     */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPDIS_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPDIS: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPDIS_PET_Pos              4                                                       /*!< SCU_TRAP TRAPDIS: PET Position          */
#define SCU_TRAP_TRAPDIS_PET_Msk              (0x01UL << SCU_TRAP_TRAPDIS_PET_Pos)                    /*!< SCU_TRAP TRAPDIS: PET Mask              */
#define SCU_TRAP_TRAPDIS_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPDIS: BRWNT Position        */
#define SCU_TRAP_TRAPDIS_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPDIS_BRWNT_Pos)                  /*!< SCU_TRAP TRAPDIS: BRWNT Mask            */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Pos          6                                                       /*!< SCU_TRAP TRAPDIS: ULPWDGT Position      */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Msk          (0x01UL << SCU_TRAP_TRAPDIS_ULPWDGT_Pos)                /*!< SCU_TRAP TRAPDIS: ULPWDGT Mask          */
#define SCU_TRAP_TRAPDIS_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPDIS: BWERR0T Position      */
#define SCU_TRAP_TRAPDIS_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPDIS_BWERR0T_Pos)                /*!< SCU_TRAP TRAPDIS: BWERR0T Mask          */
#define SCU_TRAP_TRAPDIS_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPDIS: BWERR1T Position      */
#define SCU_TRAP_TRAPDIS_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPDIS_BWERR1T_Pos)                /*!< SCU_TRAP TRAPDIS: BWERR1T Mask          */
#define SCU_TRAP_TRAPDIS_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPDIS: TEMPHIT Position      */
#define SCU_TRAP_TRAPDIS_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPDIS_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPDIS: TEMPHIT Mask          */
#define SCU_TRAP_TRAPDIS_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPDIS: TEMPLOT Position      */
#define SCU_TRAP_TRAPDIS_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPDIS_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPDIS: TEMPLOT Mask          */

/* ------------------------------  SCU_TRAP_TRAPCLR  ------------------------------ */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPCLR: SOSCWDGT Position     */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPCLR_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPCLR: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPCLR: SVCOLCKT Position     */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPCLR_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPCLR: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPCLR: UVCOLCKT Position     */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPCLR_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPCLR: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPCLR_PET_Pos              4                                                       /*!< SCU_TRAP TRAPCLR: PET Position          */
#define SCU_TRAP_TRAPCLR_PET_Msk              (0x01UL << SCU_TRAP_TRAPCLR_PET_Pos)                    /*!< SCU_TRAP TRAPCLR: PET Mask              */
#define SCU_TRAP_TRAPCLR_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPCLR: BRWNT Position        */
#define SCU_TRAP_TRAPCLR_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPCLR_BRWNT_Pos)                  /*!< SCU_TRAP TRAPCLR: BRWNT Mask            */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Pos          6                                                       /*!< SCU_TRAP TRAPCLR: ULPWDGT Position      */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Msk          (0x01UL << SCU_TRAP_TRAPCLR_ULPWDGT_Pos)                /*!< SCU_TRAP TRAPCLR: ULPWDGT Mask          */
#define SCU_TRAP_TRAPCLR_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPCLR: BWERR0T Position      */
#define SCU_TRAP_TRAPCLR_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPCLR_BWERR0T_Pos)                /*!< SCU_TRAP TRAPCLR: BWERR0T Mask          */
#define SCU_TRAP_TRAPCLR_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPCLR: BWERR1T Position      */
#define SCU_TRAP_TRAPCLR_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPCLR_BWERR1T_Pos)                /*!< SCU_TRAP TRAPCLR: BWERR1T Mask          */
#define SCU_TRAP_TRAPCLR_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPCLR: TEMPHIT Position      */
#define SCU_TRAP_TRAPCLR_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPCLR_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPCLR: TEMPHIT Mask          */
#define SCU_TRAP_TRAPCLR_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPCLR: TEMPLOT Position      */
#define SCU_TRAP_TRAPCLR_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPCLR_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPCLR: TEMPLOT Mask          */

/* ------------------------------  SCU_TRAP_TRAPSET  ------------------------------ */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPSET: SOSCWDGT Position     */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPSET_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPSET: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPSET: SVCOLCKT Position     */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPSET_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPSET: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPSET: UVCOLCKT Position     */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPSET_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPSET: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPSET_PET_Pos              4                                                       /*!< SCU_TRAP TRAPSET: PET Position          */
#define SCU_TRAP_TRAPSET_PET_Msk              (0x01UL << SCU_TRAP_TRAPSET_PET_Pos)                    /*!< SCU_TRAP TRAPSET: PET Mask              */
#define SCU_TRAP_TRAPSET_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPSET: BRWNT Position        */
#define SCU_TRAP_TRAPSET_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPSET_BRWNT_Pos)                  /*!< SCU_TRAP TRAPSET: BRWNT Mask            */
#define SCU_TRAP_TRAPSET_ULPWDT_Pos           6                                                       /*!< SCU_TRAP TRAPSET: ULPWDT Position       */
#define SCU_TRAP_TRAPSET_ULPWDT_Msk           (0x01UL << SCU_TRAP_TRAPSET_ULPWDT_Pos)                 /*!< SCU_TRAP TRAPSET: ULPWDT Mask           */
#define SCU_TRAP_TRAPSET_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPSET: BWERR0T Position      */
#define SCU_TRAP_TRAPSET_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPSET_BWERR0T_Pos)                /*!< SCU_TRAP TRAPSET: BWERR0T Mask          */
#define SCU_TRAP_TRAPSET_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPSET: BWERR1T Position      */
#define SCU_TRAP_TRAPSET_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPSET_BWERR1T_Pos)                /*!< SCU_TRAP TRAPSET: BWERR1T Mask          */
#define SCU_TRAP_TRAPSET_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPSET: TEMPHIT Position      */
#define SCU_TRAP_TRAPSET_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPSET_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPSET: TEMPHIT Mask          */
#define SCU_TRAP_TRAPSET_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPSET: TEMPLOT Position      */
#define SCU_TRAP_TRAPSET_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPSET_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPSET: TEMPLOT Mask          */


/* ================================================================================ */
/* ================     struct 'SCU_HIBERNATE' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_HIBERNATE_HDSTAT  ---------------------------- */
#define SCU_HIBERNATE_HDSTAT_EPEV_Pos         0                                                       /*!< SCU_HIBERNATE HDSTAT: EPEV Position     */
#define SCU_HIBERNATE_HDSTAT_EPEV_Msk         (0x01UL << SCU_HIBERNATE_HDSTAT_EPEV_Pos)               /*!< SCU_HIBERNATE HDSTAT: EPEV Mask         */
#define SCU_HIBERNATE_HDSTAT_ENEV_Pos         1                                                       /*!< SCU_HIBERNATE HDSTAT: ENEV Position     */
#define SCU_HIBERNATE_HDSTAT_ENEV_Msk         (0x01UL << SCU_HIBERNATE_HDSTAT_ENEV_Pos)               /*!< SCU_HIBERNATE HDSTAT: ENEV Mask         */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Pos        2                                                       /*!< SCU_HIBERNATE HDSTAT: RTCEV Position    */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Msk        (0x01UL << SCU_HIBERNATE_HDSTAT_RTCEV_Pos)              /*!< SCU_HIBERNATE HDSTAT: RTCEV Mask        */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Pos       3                                                       /*!< SCU_HIBERNATE HDSTAT: ULPWDG Position   */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Msk       (0x01UL << SCU_HIBERNATE_HDSTAT_ULPWDG_Pos)             /*!< SCU_HIBERNATE HDSTAT: ULPWDG Mask       */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Pos      4                                                       /*!< SCU_HIBERNATE HDSTAT: HIBNOUT Position  */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Msk      (0x01UL << SCU_HIBERNATE_HDSTAT_HIBNOUT_Pos)            /*!< SCU_HIBERNATE HDSTAT: HIBNOUT Mask      */
#define SCU_HIBERNATE_HDSTAT_VBATPEV_Pos      8                                                       /*!< SCU_HIBERNATE HDSTAT: VBATPEV Position  */
#define SCU_HIBERNATE_HDSTAT_VBATPEV_Msk      (0x01UL << SCU_HIBERNATE_HDSTAT_VBATPEV_Pos)            /*!< SCU_HIBERNATE HDSTAT: VBATPEV Mask      */
#define SCU_HIBERNATE_HDSTAT_VBATNEV_Pos      9                                                       /*!< SCU_HIBERNATE HDSTAT: VBATNEV Position  */
#define SCU_HIBERNATE_HDSTAT_VBATNEV_Msk      (0x01UL << SCU_HIBERNATE_HDSTAT_VBATNEV_Pos)            /*!< SCU_HIBERNATE HDSTAT: VBATNEV Mask      */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Pos   10                                                      /*!< SCU_HIBERNATE HDSTAT: AHIBIO0PEV Position */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Msk   (0x01UL << SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Pos)         /*!< SCU_HIBERNATE HDSTAT: AHIBIO0PEV Mask   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Pos   11                                                      /*!< SCU_HIBERNATE HDSTAT: AHIBIO0NEV Position */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Msk   (0x01UL << SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Pos)         /*!< SCU_HIBERNATE HDSTAT: AHIBIO0NEV Mask   */

/* -----------------------------  SCU_HIBERNATE_HDCLR  ---------------------------- */
#define SCU_HIBERNATE_HDCLR_EPEV_Pos          0                                                       /*!< SCU_HIBERNATE HDCLR: EPEV Position      */
#define SCU_HIBERNATE_HDCLR_EPEV_Msk          (0x01UL << SCU_HIBERNATE_HDCLR_EPEV_Pos)                /*!< SCU_HIBERNATE HDCLR: EPEV Mask          */
#define SCU_HIBERNATE_HDCLR_ENEV_Pos          1                                                       /*!< SCU_HIBERNATE HDCLR: ENEV Position      */
#define SCU_HIBERNATE_HDCLR_ENEV_Msk          (0x01UL << SCU_HIBERNATE_HDCLR_ENEV_Pos)                /*!< SCU_HIBERNATE HDCLR: ENEV Mask          */
#define SCU_HIBERNATE_HDCLR_RTCEV_Pos         2                                                       /*!< SCU_HIBERNATE HDCLR: RTCEV Position     */
#define SCU_HIBERNATE_HDCLR_RTCEV_Msk         (0x01UL << SCU_HIBERNATE_HDCLR_RTCEV_Pos)               /*!< SCU_HIBERNATE HDCLR: RTCEV Mask         */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Pos        3                                                       /*!< SCU_HIBERNATE HDCLR: ULPWDG Position    */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Msk        (0x01UL << SCU_HIBERNATE_HDCLR_ULPWDG_Pos)              /*!< SCU_HIBERNATE HDCLR: ULPWDG Mask        */
#define SCU_HIBERNATE_HDCLR_VBATPEV_Pos       8                                                       /*!< SCU_HIBERNATE HDCLR: VBATPEV Position   */
#define SCU_HIBERNATE_HDCLR_VBATPEV_Msk       (0x01UL << SCU_HIBERNATE_HDCLR_VBATPEV_Pos)             /*!< SCU_HIBERNATE HDCLR: VBATPEV Mask       */
#define SCU_HIBERNATE_HDCLR_VBATNEV_Pos       9                                                       /*!< SCU_HIBERNATE HDCLR: VBATNEV Position   */
#define SCU_HIBERNATE_HDCLR_VBATNEV_Msk       (0x01UL << SCU_HIBERNATE_HDCLR_VBATNEV_Pos)             /*!< SCU_HIBERNATE HDCLR: VBATNEV Mask       */
#define SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Pos    10                                                      /*!< SCU_HIBERNATE HDCLR: AHIBIO0PEV Position */
#define SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Msk    (0x01UL << SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Pos)          /*!< SCU_HIBERNATE HDCLR: AHIBIO0PEV Mask    */
#define SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Pos    11                                                      /*!< SCU_HIBERNATE HDCLR: AHIBIO0NEV Position */
#define SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Msk    (0x01UL << SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Pos)          /*!< SCU_HIBERNATE HDCLR: AHIBIO0NEV Mask    */

/* -----------------------------  SCU_HIBERNATE_HDSET  ---------------------------- */
#define SCU_HIBERNATE_HDSET_EPEV_Pos          0                                                       /*!< SCU_HIBERNATE HDSET: EPEV Position      */
#define SCU_HIBERNATE_HDSET_EPEV_Msk          (0x01UL << SCU_HIBERNATE_HDSET_EPEV_Pos)                /*!< SCU_HIBERNATE HDSET: EPEV Mask          */
#define SCU_HIBERNATE_HDSET_ENEV_Pos          1                                                       /*!< SCU_HIBERNATE HDSET: ENEV Position      */
#define SCU_HIBERNATE_HDSET_ENEV_Msk          (0x01UL << SCU_HIBERNATE_HDSET_ENEV_Pos)                /*!< SCU_HIBERNATE HDSET: ENEV Mask          */
#define SCU_HIBERNATE_HDSET_RTCEV_Pos         2                                                       /*!< SCU_HIBERNATE HDSET: RTCEV Position     */
#define SCU_HIBERNATE_HDSET_RTCEV_Msk         (0x01UL << SCU_HIBERNATE_HDSET_RTCEV_Pos)               /*!< SCU_HIBERNATE HDSET: RTCEV Mask         */
#define SCU_HIBERNATE_HDSET_ULPWDG_Pos        3                                                       /*!< SCU_HIBERNATE HDSET: ULPWDG Position    */
#define SCU_HIBERNATE_HDSET_ULPWDG_Msk        (0x01UL << SCU_HIBERNATE_HDSET_ULPWDG_Pos)              /*!< SCU_HIBERNATE HDSET: ULPWDG Mask        */
#define SCU_HIBERNATE_HDSET_VBATPEV_Pos       8                                                       /*!< SCU_HIBERNATE HDSET: VBATPEV Position   */
#define SCU_HIBERNATE_HDSET_VBATPEV_Msk       (0x01UL << SCU_HIBERNATE_HDSET_VBATPEV_Pos)             /*!< SCU_HIBERNATE HDSET: VBATPEV Mask       */
#define SCU_HIBERNATE_HDSET_VBATNEV_Pos       9                                                       /*!< SCU_HIBERNATE HDSET: VBATNEV Position   */
#define SCU_HIBERNATE_HDSET_VBATNEV_Msk       (0x01UL << SCU_HIBERNATE_HDSET_VBATNEV_Pos)             /*!< SCU_HIBERNATE HDSET: VBATNEV Mask       */
#define SCU_HIBERNATE_HDSET_AHIBIO0PEV_Pos    10                                                      /*!< SCU_HIBERNATE HDSET: AHIBIO0PEV Position */
#define SCU_HIBERNATE_HDSET_AHIBIO0PEV_Msk    (0x01UL << SCU_HIBERNATE_HDSET_AHIBIO0PEV_Pos)          /*!< SCU_HIBERNATE HDSET: AHIBIO0PEV Mask    */
#define SCU_HIBERNATE_HDSET_AHIBIO0NEV_Pos    11                                                      /*!< SCU_HIBERNATE HDSET: AHIBIO0NEV Position */
#define SCU_HIBERNATE_HDSET_AHIBIO0NEV_Msk    (0x01UL << SCU_HIBERNATE_HDSET_AHIBIO0NEV_Pos)          /*!< SCU_HIBERNATE HDSET: AHIBIO0NEV Mask    */

/* -----------------------------  SCU_HIBERNATE_HDCR  ----------------------------- */
#define SCU_HIBERNATE_HDCR_WKPEP_Pos          0                                                       /*!< SCU_HIBERNATE HDCR: WKPEP Position      */
#define SCU_HIBERNATE_HDCR_WKPEP_Msk          (0x01UL << SCU_HIBERNATE_HDCR_WKPEP_Pos)                /*!< SCU_HIBERNATE HDCR: WKPEP Mask          */
#define SCU_HIBERNATE_HDCR_WKPEN_Pos          1                                                       /*!< SCU_HIBERNATE HDCR: WKPEN Position      */
#define SCU_HIBERNATE_HDCR_WKPEN_Msk          (0x01UL << SCU_HIBERNATE_HDCR_WKPEN_Pos)                /*!< SCU_HIBERNATE HDCR: WKPEN Mask          */
#define SCU_HIBERNATE_HDCR_RTCE_Pos           2                                                       /*!< SCU_HIBERNATE HDCR: RTCE Position       */
#define SCU_HIBERNATE_HDCR_RTCE_Msk           (0x01UL << SCU_HIBERNATE_HDCR_RTCE_Pos)                 /*!< SCU_HIBERNATE HDCR: RTCE Mask           */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Pos       3                                                       /*!< SCU_HIBERNATE HDCR: ULPWDGEN Position   */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Msk       (0x01UL << SCU_HIBERNATE_HDCR_ULPWDGEN_Pos)             /*!< SCU_HIBERNATE HDCR: ULPWDGEN Mask       */
#define SCU_HIBERNATE_HDCR_HIB_Pos            4                                                       /*!< SCU_HIBERNATE HDCR: HIB Position        */
#define SCU_HIBERNATE_HDCR_HIB_Msk            (0x01UL << SCU_HIBERNATE_HDCR_HIB_Pos)                  /*!< SCU_HIBERNATE HDCR: HIB Mask            */
#define SCU_HIBERNATE_HDCR_XTALGPI1SEL_Pos    5                                                       /*!< SCU_HIBERNATE HDCR: XTALGPI1SEL Position */
#define SCU_HIBERNATE_HDCR_XTALGPI1SEL_Msk    (0x01UL << SCU_HIBERNATE_HDCR_XTALGPI1SEL_Pos)          /*!< SCU_HIBERNATE HDCR: XTALGPI1SEL Mask    */
#define SCU_HIBERNATE_HDCR_RCS_Pos            6                                                       /*!< SCU_HIBERNATE HDCR: RCS Position        */
#define SCU_HIBERNATE_HDCR_RCS_Msk            (0x01UL << SCU_HIBERNATE_HDCR_RCS_Pos)                  /*!< SCU_HIBERNATE HDCR: RCS Mask            */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Pos       7                                                       /*!< SCU_HIBERNATE HDCR: STDBYSEL Position   */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Msk       (0x01UL << SCU_HIBERNATE_HDCR_STDBYSEL_Pos)             /*!< SCU_HIBERNATE HDCR: STDBYSEL Mask       */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Pos        8                                                       /*!< SCU_HIBERNATE HDCR: WKUPSEL Position    */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Msk        (0x01UL << SCU_HIBERNATE_HDCR_WKUPSEL_Pos)              /*!< SCU_HIBERNATE HDCR: WKUPSEL Mask        */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Pos        10                                                      /*!< SCU_HIBERNATE HDCR: GPI0SEL Position    */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Msk        (0x01UL << SCU_HIBERNATE_HDCR_GPI0SEL_Pos)              /*!< SCU_HIBERNATE HDCR: GPI0SEL Mask        */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Pos      12                                                      /*!< SCU_HIBERNATE HDCR: HIBIO0POL Position  */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Msk      (0x01UL << SCU_HIBERNATE_HDCR_HIBIO0POL_Pos)            /*!< SCU_HIBERNATE HDCR: HIBIO0POL Mask      */
#define SCU_HIBERNATE_HDCR_ADIG0SEL_Pos       14                                                      /*!< SCU_HIBERNATE HDCR: ADIG0SEL Position   */
#define SCU_HIBERNATE_HDCR_ADIG0SEL_Msk       (0x01UL << SCU_HIBERNATE_HDCR_ADIG0SEL_Pos)             /*!< SCU_HIBERNATE HDCR: ADIG0SEL Mask       */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Pos      16                                                      /*!< SCU_HIBERNATE HDCR: HIBIO0SEL Position  */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Msk      (0x0fUL << SCU_HIBERNATE_HDCR_HIBIO0SEL_Pos)            /*!< SCU_HIBERNATE HDCR: HIBIO0SEL Mask      */
#define SCU_HIBERNATE_HDCR_VBATLO_Pos         24                                                      /*!< SCU_HIBERNATE HDCR: VBATLO Position     */
#define SCU_HIBERNATE_HDCR_VBATLO_Msk         (0x01UL << SCU_HIBERNATE_HDCR_VBATLO_Pos)               /*!< SCU_HIBERNATE HDCR: VBATLO Mask         */
#define SCU_HIBERNATE_HDCR_VBATHI_Pos         25                                                      /*!< SCU_HIBERNATE HDCR: VBATHI Position     */
#define SCU_HIBERNATE_HDCR_VBATHI_Msk         (0x01UL << SCU_HIBERNATE_HDCR_VBATHI_Pos)               /*!< SCU_HIBERNATE HDCR: VBATHI Mask         */
#define SCU_HIBERNATE_HDCR_AHIBIO0LO_Pos      26                                                      /*!< SCU_HIBERNATE HDCR: AHIBIO0LO Position  */
#define SCU_HIBERNATE_HDCR_AHIBIO0LO_Msk      (0x01UL << SCU_HIBERNATE_HDCR_AHIBIO0LO_Pos)            /*!< SCU_HIBERNATE HDCR: AHIBIO0LO Mask      */
#define SCU_HIBERNATE_HDCR_AHIBIO0HI_Pos      27                                                      /*!< SCU_HIBERNATE HDCR: AHIBIO0HI Position  */
#define SCU_HIBERNATE_HDCR_AHIBIO0HI_Msk      (0x01UL << SCU_HIBERNATE_HDCR_AHIBIO0HI_Pos)            /*!< SCU_HIBERNATE HDCR: AHIBIO0HI Mask      */

/* ---------------------------  SCU_HIBERNATE_OSCSICTRL  -------------------------- */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Pos       0                                                       /*!< SCU_HIBERNATE OSCSICTRL: PWD Position   */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Msk       (0x01UL << SCU_HIBERNATE_OSCSICTRL_PWD_Pos)             /*!< SCU_HIBERNATE OSCSICTRL: PWD Mask       */

/* ---------------------------  SCU_HIBERNATE_OSCULSTAT  -------------------------- */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Pos       0                                                       /*!< SCU_HIBERNATE OSCULSTAT: X1D Position   */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Msk       (0x01UL << SCU_HIBERNATE_OSCULSTAT_X1D_Pos)             /*!< SCU_HIBERNATE OSCULSTAT: X1D Mask       */

/* ---------------------------  SCU_HIBERNATE_OSCULCTRL  -------------------------- */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Pos     0                                                       /*!< SCU_HIBERNATE OSCULCTRL: X1DEN Position */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Msk     (0x01UL << SCU_HIBERNATE_OSCULCTRL_X1DEN_Pos)           /*!< SCU_HIBERNATE OSCULCTRL: X1DEN Mask     */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Pos      4                                                       /*!< SCU_HIBERNATE OSCULCTRL: MODE Position  */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Msk      (0x03UL << SCU_HIBERNATE_OSCULCTRL_MODE_Pos)            /*!< SCU_HIBERNATE OSCULCTRL: MODE Mask      */

/* ---------------------------  SCU_HIBERNATE_LPACCONF  --------------------------- */
#define SCU_HIBERNATE_LPACCONF_CMPEN_Pos      0                                                       /*!< SCU_HIBERNATE LPACCONF: CMPEN Position  */
#define SCU_HIBERNATE_LPACCONF_CMPEN_Msk      (0x07UL << SCU_HIBERNATE_LPACCONF_CMPEN_Pos)            /*!< SCU_HIBERNATE LPACCONF: CMPEN Mask      */
#define SCU_HIBERNATE_LPACCONF_TRIGSEL_Pos    4                                                       /*!< SCU_HIBERNATE LPACCONF: TRIGSEL Position */
#define SCU_HIBERNATE_LPACCONF_TRIGSEL_Msk    (0x07UL << SCU_HIBERNATE_LPACCONF_TRIGSEL_Pos)          /*!< SCU_HIBERNATE LPACCONF: TRIGSEL Mask    */
#define SCU_HIBERNATE_LPACCONF_CONVDEL_Pos    12                                                      /*!< SCU_HIBERNATE LPACCONF: CONVDEL Position */
#define SCU_HIBERNATE_LPACCONF_CONVDEL_Msk    (0x01UL << SCU_HIBERNATE_LPACCONF_CONVDEL_Pos)          /*!< SCU_HIBERNATE LPACCONF: CONVDEL Mask    */
#define SCU_HIBERNATE_LPACCONF_INTERVCNT_Pos  16                                                      /*!< SCU_HIBERNATE LPACCONF: INTERVCNT Position */
#define SCU_HIBERNATE_LPACCONF_INTERVCNT_Msk  (0x00000fffUL << SCU_HIBERNATE_LPACCONF_INTERVCNT_Pos)  /*!< SCU_HIBERNATE LPACCONF: INTERVCNT Mask  */
#define SCU_HIBERNATE_LPACCONF_SETTLECNT_Pos  28                                                      /*!< SCU_HIBERNATE LPACCONF: SETTLECNT Position */
#define SCU_HIBERNATE_LPACCONF_SETTLECNT_Msk  (0x0fUL << SCU_HIBERNATE_LPACCONF_SETTLECNT_Pos)        /*!< SCU_HIBERNATE LPACCONF: SETTLECNT Mask  */

/* ----------------------------  SCU_HIBERNATE_LPACTH0  --------------------------- */
#define SCU_HIBERNATE_LPACTH0_VBATLO_Pos      0                                                       /*!< SCU_HIBERNATE LPACTH0: VBATLO Position  */
#define SCU_HIBERNATE_LPACTH0_VBATLO_Msk      (0x3fUL << SCU_HIBERNATE_LPACTH0_VBATLO_Pos)            /*!< SCU_HIBERNATE LPACTH0: VBATLO Mask      */
#define SCU_HIBERNATE_LPACTH0_VBATHI_Pos      8                                                       /*!< SCU_HIBERNATE LPACTH0: VBATHI Position  */
#define SCU_HIBERNATE_LPACTH0_VBATHI_Msk      (0x3fUL << SCU_HIBERNATE_LPACTH0_VBATHI_Pos)            /*!< SCU_HIBERNATE LPACTH0: VBATHI Mask      */

/* ----------------------------  SCU_HIBERNATE_LPACST  ---------------------------- */
#define SCU_HIBERNATE_LPACST_VBATSCMP_Pos     0                                                       /*!< SCU_HIBERNATE LPACST: VBATSCMP Position */
#define SCU_HIBERNATE_LPACST_VBATSCMP_Msk     (0x01UL << SCU_HIBERNATE_LPACST_VBATSCMP_Pos)           /*!< SCU_HIBERNATE LPACST: VBATSCMP Mask     */
#define SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Pos  1                                                       /*!< SCU_HIBERNATE LPACST: AHIBIO0SCMP Position */
#define SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Msk  (0x01UL << SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Pos)        /*!< SCU_HIBERNATE LPACST: AHIBIO0SCMP Mask  */
#define SCU_HIBERNATE_LPACST_VBATVAL_Pos      16                                                      /*!< SCU_HIBERNATE LPACST: VBATVAL Position  */
#define SCU_HIBERNATE_LPACST_VBATVAL_Msk      (0x01UL << SCU_HIBERNATE_LPACST_VBATVAL_Pos)            /*!< SCU_HIBERNATE LPACST: VBATVAL Mask      */
#define SCU_HIBERNATE_LPACST_AHIBIO0VAL_Pos   17                                                      /*!< SCU_HIBERNATE LPACST: AHIBIO0VAL Position */
#define SCU_HIBERNATE_LPACST_AHIBIO0VAL_Msk   (0x01UL << SCU_HIBERNATE_LPACST_AHIBIO0VAL_Pos)         /*!< SCU_HIBERNATE LPACST: AHIBIO0VAL Mask   */

/* ----------------------------  SCU_HIBERNATE_LPACCLR  --------------------------- */
#define SCU_HIBERNATE_LPACCLR_VBATSCMP_Pos    0                                                       /*!< SCU_HIBERNATE LPACCLR: VBATSCMP Position */
#define SCU_HIBERNATE_LPACCLR_VBATSCMP_Msk    (0x01UL << SCU_HIBERNATE_LPACCLR_VBATSCMP_Pos)          /*!< SCU_HIBERNATE LPACCLR: VBATSCMP Mask    */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Pos 1                                                       /*!< SCU_HIBERNATE LPACCLR: AHIBIO0SCMP Position */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Msk (0x01UL << SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Pos)       /*!< SCU_HIBERNATE LPACCLR: AHIBIO0SCMP Mask */
#define SCU_HIBERNATE_LPACCLR_VBATVAL_Pos     16                                                      /*!< SCU_HIBERNATE LPACCLR: VBATVAL Position */
#define SCU_HIBERNATE_LPACCLR_VBATVAL_Msk     (0x01UL << SCU_HIBERNATE_LPACCLR_VBATVAL_Pos)           /*!< SCU_HIBERNATE LPACCLR: VBATVAL Mask     */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Pos  17                                                      /*!< SCU_HIBERNATE LPACCLR: AHIBIO0VAL Position */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Msk  (0x01UL << SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Pos)        /*!< SCU_HIBERNATE LPACCLR: AHIBIO0VAL Mask  */

/* ----------------------------  SCU_HIBERNATE_LPACSET  --------------------------- */
#define SCU_HIBERNATE_LPACSET_VBATSCMP_Pos    0                                                       /*!< SCU_HIBERNATE LPACSET: VBATSCMP Position */
#define SCU_HIBERNATE_LPACSET_VBATSCMP_Msk    (0x01UL << SCU_HIBERNATE_LPACSET_VBATSCMP_Pos)          /*!< SCU_HIBERNATE LPACSET: VBATSCMP Mask    */
#define SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Pos 1                                                       /*!< SCU_HIBERNATE LPACSET: AHIBIO0SCMP Position */
#define SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Msk (0x01UL << SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Pos)       /*!< SCU_HIBERNATE LPACSET: AHIBIO0SCMP Mask */
#define SCU_HIBERNATE_LPACSET_VBATVAL_Pos     16                                                      /*!< SCU_HIBERNATE LPACSET: VBATVAL Position */
#define SCU_HIBERNATE_LPACSET_VBATVAL_Msk     (0x01UL << SCU_HIBERNATE_LPACSET_VBATVAL_Pos)           /*!< SCU_HIBERNATE LPACSET: VBATVAL Mask     */
#define SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Pos  17                                                      /*!< SCU_HIBERNATE LPACSET: AHIBIO0VAL Position */
#define SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Msk  (0x01UL << SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Pos)        /*!< SCU_HIBERNATE LPACSET: AHIBIO0VAL Mask  */

/* ----------------------------  SCU_HIBERNATE_HINTST  ---------------------------- */
#define SCU_HIBERNATE_HINTST_HIBNINT_Pos      0                                                       /*!< SCU_HIBERNATE HINTST: HIBNINT Position  */
#define SCU_HIBERNATE_HINTST_HIBNINT_Msk      (0x01UL << SCU_HIBERNATE_HINTST_HIBNINT_Pos)            /*!< SCU_HIBERNATE HINTST: HIBNINT Mask      */
#define SCU_HIBERNATE_HINTST_FLASHOFF_Pos     2                                                       /*!< SCU_HIBERNATE HINTST: FLASHOFF Position */
#define SCU_HIBERNATE_HINTST_FLASHOFF_Msk     (0x01UL << SCU_HIBERNATE_HINTST_FLASHOFF_Pos)           /*!< SCU_HIBERNATE HINTST: FLASHOFF Mask     */
#define SCU_HIBERNATE_HINTST_FLASHPD_Pos      3                                                       /*!< SCU_HIBERNATE HINTST: FLASHPD Position  */
#define SCU_HIBERNATE_HINTST_FLASHPD_Msk      (0x01UL << SCU_HIBERNATE_HINTST_FLASHPD_Pos)            /*!< SCU_HIBERNATE HINTST: FLASHPD Mask      */
#define SCU_HIBERNATE_HINTST_POFFD_Pos        4                                                       /*!< SCU_HIBERNATE HINTST: POFFD Position    */
#define SCU_HIBERNATE_HINTST_POFFD_Msk        (0x01UL << SCU_HIBERNATE_HINTST_POFFD_Pos)              /*!< SCU_HIBERNATE HINTST: POFFD Mask        */
#define SCU_HIBERNATE_HINTST_PPODEL_Pos       16                                                      /*!< SCU_HIBERNATE HINTST: PPODEL Position   */
#define SCU_HIBERNATE_HINTST_PPODEL_Msk       (0x03UL << SCU_HIBERNATE_HINTST_PPODEL_Pos)             /*!< SCU_HIBERNATE HINTST: PPODEL Mask       */
#define SCU_HIBERNATE_HINTST_POFFH_Pos        20                                                      /*!< SCU_HIBERNATE HINTST: POFFH Position    */
#define SCU_HIBERNATE_HINTST_POFFH_Msk        (0x01UL << SCU_HIBERNATE_HINTST_POFFH_Pos)              /*!< SCU_HIBERNATE HINTST: POFFH Mask        */

/* ----------------------------  SCU_HIBERNATE_HINTCLR  --------------------------- */
#define SCU_HIBERNATE_HINTCLR_HIBNINT_Pos     0                                                       /*!< SCU_HIBERNATE HINTCLR: HIBNINT Position */
#define SCU_HIBERNATE_HINTCLR_HIBNINT_Msk     (0x01UL << SCU_HIBERNATE_HINTCLR_HIBNINT_Pos)           /*!< SCU_HIBERNATE HINTCLR: HIBNINT Mask     */
#define SCU_HIBERNATE_HINTCLR_FLASHOFF_Pos    2                                                       /*!< SCU_HIBERNATE HINTCLR: FLASHOFF Position */
#define SCU_HIBERNATE_HINTCLR_FLASHOFF_Msk    (0x01UL << SCU_HIBERNATE_HINTCLR_FLASHOFF_Pos)          /*!< SCU_HIBERNATE HINTCLR: FLASHOFF Mask    */
#define SCU_HIBERNATE_HINTCLR_FLASHPD_Pos     3                                                       /*!< SCU_HIBERNATE HINTCLR: FLASHPD Position */
#define SCU_HIBERNATE_HINTCLR_FLASHPD_Msk     (0x01UL << SCU_HIBERNATE_HINTCLR_FLASHPD_Pos)           /*!< SCU_HIBERNATE HINTCLR: FLASHPD Mask     */
#define SCU_HIBERNATE_HINTCLR_POFFD_Pos       4                                                       /*!< SCU_HIBERNATE HINTCLR: POFFD Position   */
#define SCU_HIBERNATE_HINTCLR_POFFD_Msk       (0x01UL << SCU_HIBERNATE_HINTCLR_POFFD_Pos)             /*!< SCU_HIBERNATE HINTCLR: POFFD Mask       */
#define SCU_HIBERNATE_HINTCLR_PPODEL_Pos      16                                                      /*!< SCU_HIBERNATE HINTCLR: PPODEL Position  */
#define SCU_HIBERNATE_HINTCLR_PPODEL_Msk      (0x03UL << SCU_HIBERNATE_HINTCLR_PPODEL_Pos)            /*!< SCU_HIBERNATE HINTCLR: PPODEL Mask      */
#define SCU_HIBERNATE_HINTCLR_POFFH_Pos       20                                                      /*!< SCU_HIBERNATE HINTCLR: POFFH Position   */
#define SCU_HIBERNATE_HINTCLR_POFFH_Msk       (0x01UL << SCU_HIBERNATE_HINTCLR_POFFH_Pos)             /*!< SCU_HIBERNATE HINTCLR: POFFH Mask       */

/* ----------------------------  SCU_HIBERNATE_HINTSET  --------------------------- */
#define SCU_HIBERNATE_HINTSET_HIBNINT_Pos     0                                                       /*!< SCU_HIBERNATE HINTSET: HIBNINT Position */
#define SCU_HIBERNATE_HINTSET_HIBNINT_Msk     (0x01UL << SCU_HIBERNATE_HINTSET_HIBNINT_Pos)           /*!< SCU_HIBERNATE HINTSET: HIBNINT Mask     */
#define SCU_HIBERNATE_HINTSET_VCOREOFF_Pos    1                                                       /*!< SCU_HIBERNATE HINTSET: VCOREOFF Position */
#define SCU_HIBERNATE_HINTSET_VCOREOFF_Msk    (0x01UL << SCU_HIBERNATE_HINTSET_VCOREOFF_Pos)          /*!< SCU_HIBERNATE HINTSET: VCOREOFF Mask    */
#define SCU_HIBERNATE_HINTSET_FLASHOFF_Pos    2                                                       /*!< SCU_HIBERNATE HINTSET: FLASHOFF Position */
#define SCU_HIBERNATE_HINTSET_FLASHOFF_Msk    (0x01UL << SCU_HIBERNATE_HINTSET_FLASHOFF_Pos)          /*!< SCU_HIBERNATE HINTSET: FLASHOFF Mask    */
#define SCU_HIBERNATE_HINTSET_FLASHPD_Pos     3                                                       /*!< SCU_HIBERNATE HINTSET: FLASHPD Position */
#define SCU_HIBERNATE_HINTSET_FLASHPD_Msk     (0x01UL << SCU_HIBERNATE_HINTSET_FLASHPD_Pos)           /*!< SCU_HIBERNATE HINTSET: FLASHPD Mask     */
#define SCU_HIBERNATE_HINTSET_POFFD_Pos       4                                                       /*!< SCU_HIBERNATE HINTSET: POFFD Position   */
#define SCU_HIBERNATE_HINTSET_POFFD_Msk       (0x01UL << SCU_HIBERNATE_HINTSET_POFFD_Pos)             /*!< SCU_HIBERNATE HINTSET: POFFD Mask       */
#define SCU_HIBERNATE_HINTSET_PPODEL_Pos      16                                                      /*!< SCU_HIBERNATE HINTSET: PPODEL Position  */
#define SCU_HIBERNATE_HINTSET_PPODEL_Msk      (0x03UL << SCU_HIBERNATE_HINTSET_PPODEL_Pos)            /*!< SCU_HIBERNATE HINTSET: PPODEL Mask      */
#define SCU_HIBERNATE_HINTSET_POFFH_Pos       20                                                      /*!< SCU_HIBERNATE HINTSET: POFFH Position   */
#define SCU_HIBERNATE_HINTSET_POFFH_Msk       (0x01UL << SCU_HIBERNATE_HINTSET_POFFH_Pos)             /*!< SCU_HIBERNATE HINTSET: POFFH Mask       */


/* ================================================================================ */
/* ================       struct 'SCU_POWER' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_POWER_PWRSTAT  ----------------------------- */
#define SCU_POWER_PWRSTAT_HIBEN_Pos           0                                                       /*!< SCU_POWER PWRSTAT: HIBEN Position       */
#define SCU_POWER_PWRSTAT_HIBEN_Msk           (0x01UL << SCU_POWER_PWRSTAT_HIBEN_Pos)                 /*!< SCU_POWER PWRSTAT: HIBEN Mask           */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Pos       16                                                      /*!< SCU_POWER PWRSTAT: USBPHYPDQ Position   */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Msk       (0x01UL << SCU_POWER_PWRSTAT_USBPHYPDQ_Pos)             /*!< SCU_POWER PWRSTAT: USBPHYPDQ Mask       */
#define SCU_POWER_PWRSTAT_USBPUWQ_Pos         18                                                      /*!< SCU_POWER PWRSTAT: USBPUWQ Position     */
#define SCU_POWER_PWRSTAT_USBPUWQ_Msk         (0x01UL << SCU_POWER_PWRSTAT_USBPUWQ_Pos)               /*!< SCU_POWER PWRSTAT: USBPUWQ Mask         */

/* ------------------------------  SCU_POWER_PWRSET  ------------------------------ */
#define SCU_POWER_PWRSET_HIB_Pos              0                                                       /*!< SCU_POWER PWRSET: HIB Position          */
#define SCU_POWER_PWRSET_HIB_Msk              (0x01UL << SCU_POWER_PWRSET_HIB_Pos)                    /*!< SCU_POWER PWRSET: HIB Mask              */
#define SCU_POWER_PWRSET_USBPHYPDQ_Pos        16                                                      /*!< SCU_POWER PWRSET: USBPHYPDQ Position    */
#define SCU_POWER_PWRSET_USBPHYPDQ_Msk        (0x01UL << SCU_POWER_PWRSET_USBPHYPDQ_Pos)              /*!< SCU_POWER PWRSET: USBPHYPDQ Mask        */
#define SCU_POWER_PWRSET_USBPUWQ_Pos          18                                                      /*!< SCU_POWER PWRSET: USBPUWQ Position      */
#define SCU_POWER_PWRSET_USBPUWQ_Msk          (0x01UL << SCU_POWER_PWRSET_USBPUWQ_Pos)                /*!< SCU_POWER PWRSET: USBPUWQ Mask          */

/* ------------------------------  SCU_POWER_PWRCLR  ------------------------------ */
#define SCU_POWER_PWRCLR_HIB_Pos              0                                                       /*!< SCU_POWER PWRCLR: HIB Position          */
#define SCU_POWER_PWRCLR_HIB_Msk              (0x01UL << SCU_POWER_PWRCLR_HIB_Pos)                    /*!< SCU_POWER PWRCLR: HIB Mask              */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Pos        16                                                      /*!< SCU_POWER PWRCLR: USBPHYPDQ Position    */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Msk        (0x01UL << SCU_POWER_PWRCLR_USBPHYPDQ_Pos)              /*!< SCU_POWER PWRCLR: USBPHYPDQ Mask        */
#define SCU_POWER_PWRCLR_USBPUWQ_Pos          18                                                      /*!< SCU_POWER PWRCLR: USBPUWQ Position      */
#define SCU_POWER_PWRCLR_USBPUWQ_Msk          (0x01UL << SCU_POWER_PWRCLR_USBPUWQ_Pos)                /*!< SCU_POWER PWRCLR: USBPUWQ Mask          */

/* ------------------------------  SCU_POWER_EVRSTAT  ----------------------------- */
#define SCU_POWER_EVRSTAT_OV13_Pos            1                                                       /*!< SCU_POWER EVRSTAT: OV13 Position        */
#define SCU_POWER_EVRSTAT_OV13_Msk            (0x01UL << SCU_POWER_EVRSTAT_OV13_Pos)                  /*!< SCU_POWER EVRSTAT: OV13 Mask            */

/* ----------------------------  SCU_POWER_EVRVADCSTAT  --------------------------- */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Pos     0                                                       /*!< SCU_POWER EVRVADCSTAT: VADC13V Position */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Msk     (0x000000ffUL << SCU_POWER_EVRVADCSTAT_VADC13V_Pos)     /*!< SCU_POWER EVRVADCSTAT: VADC13V Mask     */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Pos     8                                                       /*!< SCU_POWER EVRVADCSTAT: VADC33V Position */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Msk     (0x000000ffUL << SCU_POWER_EVRVADCSTAT_VADC33V_Pos)     /*!< SCU_POWER EVRVADCSTAT: VADC33V Mask     */

/* ------------------------------  SCU_POWER_PWRMON  ------------------------------ */
#define SCU_POWER_PWRMON_THRS_Pos             0                                                       /*!< SCU_POWER PWRMON: THRS Position         */
#define SCU_POWER_PWRMON_THRS_Msk             (0x000000ffUL << SCU_POWER_PWRMON_THRS_Pos)             /*!< SCU_POWER PWRMON: THRS Mask             */
#define SCU_POWER_PWRMON_INTV_Pos             8                                                       /*!< SCU_POWER PWRMON: INTV Position         */
#define SCU_POWER_PWRMON_INTV_Msk             (0x000000ffUL << SCU_POWER_PWRMON_INTV_Pos)             /*!< SCU_POWER PWRMON: INTV Mask             */
#define SCU_POWER_PWRMON_ENB_Pos              16                                                      /*!< SCU_POWER PWRMON: ENB Position          */
#define SCU_POWER_PWRMON_ENB_Msk              (0x01UL << SCU_POWER_PWRMON_ENB_Pos)                    /*!< SCU_POWER PWRMON: ENB Mask              */


/* ================================================================================ */
/* ================       struct 'SCU_RESET' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_RESET_RSTSTAT  ----------------------------- */
#define SCU_RESET_RSTSTAT_RSTSTAT_Pos         0                                                       /*!< SCU_RESET RSTSTAT: RSTSTAT Position     */
#define SCU_RESET_RSTSTAT_RSTSTAT_Msk         (0x000000ffUL << SCU_RESET_RSTSTAT_RSTSTAT_Pos)         /*!< SCU_RESET RSTSTAT: RSTSTAT Mask         */
#define SCU_RESET_RSTSTAT_HIBWK_Pos           8                                                       /*!< SCU_RESET RSTSTAT: HIBWK Position       */
#define SCU_RESET_RSTSTAT_HIBWK_Msk           (0x01UL << SCU_RESET_RSTSTAT_HIBWK_Pos)                 /*!< SCU_RESET RSTSTAT: HIBWK Mask           */
#define SCU_RESET_RSTSTAT_HIBRS_Pos           9                                                       /*!< SCU_RESET RSTSTAT: HIBRS Position       */
#define SCU_RESET_RSTSTAT_HIBRS_Msk           (0x01UL << SCU_RESET_RSTSTAT_HIBRS_Pos)                 /*!< SCU_RESET RSTSTAT: HIBRS Mask           */
#define SCU_RESET_RSTSTAT_LCKEN_Pos           10                                                      /*!< SCU_RESET RSTSTAT: LCKEN Position       */
#define SCU_RESET_RSTSTAT_LCKEN_Msk           (0x01UL << SCU_RESET_RSTSTAT_LCKEN_Pos)                 /*!< SCU_RESET RSTSTAT: LCKEN Mask           */

/* ------------------------------  SCU_RESET_RSTSET  ------------------------------ */
#define SCU_RESET_RSTSET_HIBWK_Pos            8                                                       /*!< SCU_RESET RSTSET: HIBWK Position        */
#define SCU_RESET_RSTSET_HIBWK_Msk            (0x01UL << SCU_RESET_RSTSET_HIBWK_Pos)                  /*!< SCU_RESET RSTSET: HIBWK Mask            */
#define SCU_RESET_RSTSET_HIBRS_Pos            9                                                       /*!< SCU_RESET RSTSET: HIBRS Position        */
#define SCU_RESET_RSTSET_HIBRS_Msk            (0x01UL << SCU_RESET_RSTSET_HIBRS_Pos)                  /*!< SCU_RESET RSTSET: HIBRS Mask            */
#define SCU_RESET_RSTSET_LCKEN_Pos            10                                                      /*!< SCU_RESET RSTSET: LCKEN Position        */
#define SCU_RESET_RSTSET_LCKEN_Msk            (0x01UL << SCU_RESET_RSTSET_LCKEN_Pos)                  /*!< SCU_RESET RSTSET: LCKEN Mask            */

/* ------------------------------  SCU_RESET_RSTCLR  ------------------------------ */
#define SCU_RESET_RSTCLR_RSCLR_Pos            0                                                       /*!< SCU_RESET RSTCLR: RSCLR Position        */
#define SCU_RESET_RSTCLR_RSCLR_Msk            (0x01UL << SCU_RESET_RSTCLR_RSCLR_Pos)                  /*!< SCU_RESET RSTCLR: RSCLR Mask            */
#define SCU_RESET_RSTCLR_HIBWK_Pos            8                                                       /*!< SCU_RESET RSTCLR: HIBWK Position        */
#define SCU_RESET_RSTCLR_HIBWK_Msk            (0x01UL << SCU_RESET_RSTCLR_HIBWK_Pos)                  /*!< SCU_RESET RSTCLR: HIBWK Mask            */
#define SCU_RESET_RSTCLR_HIBRS_Pos            9                                                       /*!< SCU_RESET RSTCLR: HIBRS Position        */
#define SCU_RESET_RSTCLR_HIBRS_Msk            (0x01UL << SCU_RESET_RSTCLR_HIBRS_Pos)                  /*!< SCU_RESET RSTCLR: HIBRS Mask            */
#define SCU_RESET_RSTCLR_LCKEN_Pos            10                                                      /*!< SCU_RESET RSTCLR: LCKEN Position        */
#define SCU_RESET_RSTCLR_LCKEN_Msk            (0x01UL << SCU_RESET_RSTCLR_LCKEN_Pos)                  /*!< SCU_RESET RSTCLR: LCKEN Mask            */

/* ------------------------------  SCU_RESET_PRSTAT0  ----------------------------- */
#define SCU_RESET_PRSTAT0_VADCRS_Pos          0                                                       /*!< SCU_RESET PRSTAT0: VADCRS Position      */
#define SCU_RESET_PRSTAT0_VADCRS_Msk          (0x01UL << SCU_RESET_PRSTAT0_VADCRS_Pos)                /*!< SCU_RESET PRSTAT0: VADCRS Mask          */
#define SCU_RESET_PRSTAT0_CCU40RS_Pos         2                                                       /*!< SCU_RESET PRSTAT0: CCU40RS Position     */
#define SCU_RESET_PRSTAT0_CCU40RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU40RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU40RS Mask         */
#define SCU_RESET_PRSTAT0_CCU41RS_Pos         3                                                       /*!< SCU_RESET PRSTAT0: CCU41RS Position     */
#define SCU_RESET_PRSTAT0_CCU41RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU41RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU41RS Mask         */
#define SCU_RESET_PRSTAT0_CCU80RS_Pos         7                                                       /*!< SCU_RESET PRSTAT0: CCU80RS Position     */
#define SCU_RESET_PRSTAT0_CCU80RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU80RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU80RS Mask         */
#define SCU_RESET_PRSTAT0_POSIF0RS_Pos        9                                                       /*!< SCU_RESET PRSTAT0: POSIF0RS Position    */
#define SCU_RESET_PRSTAT0_POSIF0RS_Msk        (0x01UL << SCU_RESET_PRSTAT0_POSIF0RS_Pos)              /*!< SCU_RESET PRSTAT0: POSIF0RS Mask        */
#define SCU_RESET_PRSTAT0_USIC0RS_Pos         11                                                      /*!< SCU_RESET PRSTAT0: USIC0RS Position     */
#define SCU_RESET_PRSTAT0_USIC0RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_USIC0RS_Pos)               /*!< SCU_RESET PRSTAT0: USIC0RS Mask         */
#define SCU_RESET_PRSTAT0_ERU1RS_Pos          16                                                      /*!< SCU_RESET PRSTAT0: ERU1RS Position      */
#define SCU_RESET_PRSTAT0_ERU1RS_Msk          (0x01UL << SCU_RESET_PRSTAT0_ERU1RS_Pos)                /*!< SCU_RESET PRSTAT0: ERU1RS Mask          */
#define SCU_RESET_PRSTAT0_HRPWM0RS_Pos        23                                                      /*!< SCU_RESET PRSTAT0: HRPWM0RS Position    */
#define SCU_RESET_PRSTAT0_HRPWM0RS_Msk        (0x01UL << SCU_RESET_PRSTAT0_HRPWM0RS_Pos)              /*!< SCU_RESET PRSTAT0: HRPWM0RS Mask        */

/* ------------------------------  SCU_RESET_PRSET0  ------------------------------ */
#define SCU_RESET_PRSET0_VADCRS_Pos           0                                                       /*!< SCU_RESET PRSET0: VADCRS Position       */
#define SCU_RESET_PRSET0_VADCRS_Msk           (0x01UL << SCU_RESET_PRSET0_VADCRS_Pos)                 /*!< SCU_RESET PRSET0: VADCRS Mask           */
#define SCU_RESET_PRSET0_CCU40RS_Pos          2                                                       /*!< SCU_RESET PRSET0: CCU40RS Position      */
#define SCU_RESET_PRSET0_CCU40RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU40RS_Pos)                /*!< SCU_RESET PRSET0: CCU40RS Mask          */
#define SCU_RESET_PRSET0_CCU41RS_Pos          3                                                       /*!< SCU_RESET PRSET0: CCU41RS Position      */
#define SCU_RESET_PRSET0_CCU41RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU41RS_Pos)                /*!< SCU_RESET PRSET0: CCU41RS Mask          */
#define SCU_RESET_PRSET0_CCU80RS_Pos          7                                                       /*!< SCU_RESET PRSET0: CCU80RS Position      */
#define SCU_RESET_PRSET0_CCU80RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU80RS_Pos)                /*!< SCU_RESET PRSET0: CCU80RS Mask          */
#define SCU_RESET_PRSET0_POSIF0RS_Pos         9                                                       /*!< SCU_RESET PRSET0: POSIF0RS Position     */
#define SCU_RESET_PRSET0_POSIF0RS_Msk         (0x01UL << SCU_RESET_PRSET0_POSIF0RS_Pos)               /*!< SCU_RESET PRSET0: POSIF0RS Mask         */
#define SCU_RESET_PRSET0_USIC0RS_Pos          11                                                      /*!< SCU_RESET PRSET0: USIC0RS Position      */
#define SCU_RESET_PRSET0_USIC0RS_Msk          (0x01UL << SCU_RESET_PRSET0_USIC0RS_Pos)                /*!< SCU_RESET PRSET0: USIC0RS Mask          */
#define SCU_RESET_PRSET0_ERU1RS_Pos           16                                                      /*!< SCU_RESET PRSET0: ERU1RS Position       */
#define SCU_RESET_PRSET0_ERU1RS_Msk           (0x01UL << SCU_RESET_PRSET0_ERU1RS_Pos)                 /*!< SCU_RESET PRSET0: ERU1RS Mask           */
#define SCU_RESET_PRSET0_HRPWM0RS_Pos         23                                                      /*!< SCU_RESET PRSET0: HRPWM0RS Position     */
#define SCU_RESET_PRSET0_HRPWM0RS_Msk         (0x01UL << SCU_RESET_PRSET0_HRPWM0RS_Pos)               /*!< SCU_RESET PRSET0: HRPWM0RS Mask         */

/* ------------------------------  SCU_RESET_PRCLR0  ------------------------------ */
#define SCU_RESET_PRCLR0_VADCRS_Pos           0                                                       /*!< SCU_RESET PRCLR0: VADCRS Position       */
#define SCU_RESET_PRCLR0_VADCRS_Msk           (0x01UL << SCU_RESET_PRCLR0_VADCRS_Pos)                 /*!< SCU_RESET PRCLR0: VADCRS Mask           */
#define SCU_RESET_PRCLR0_CCU40RS_Pos          2                                                       /*!< SCU_RESET PRCLR0: CCU40RS Position      */
#define SCU_RESET_PRCLR0_CCU40RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU40RS_Pos)                /*!< SCU_RESET PRCLR0: CCU40RS Mask          */
#define SCU_RESET_PRCLR0_CCU41RS_Pos          3                                                       /*!< SCU_RESET PRCLR0: CCU41RS Position      */
#define SCU_RESET_PRCLR0_CCU41RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU41RS_Pos)                /*!< SCU_RESET PRCLR0: CCU41RS Mask          */
#define SCU_RESET_PRCLR0_CCU80RS_Pos          7                                                       /*!< SCU_RESET PRCLR0: CCU80RS Position      */
#define SCU_RESET_PRCLR0_CCU80RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU80RS_Pos)                /*!< SCU_RESET PRCLR0: CCU80RS Mask          */
#define SCU_RESET_PRCLR0_POSIF0RS_Pos         9                                                       /*!< SCU_RESET PRCLR0: POSIF0RS Position     */
#define SCU_RESET_PRCLR0_POSIF0RS_Msk         (0x01UL << SCU_RESET_PRCLR0_POSIF0RS_Pos)               /*!< SCU_RESET PRCLR0: POSIF0RS Mask         */
#define SCU_RESET_PRCLR0_USIC0RS_Pos          11                                                      /*!< SCU_RESET PRCLR0: USIC0RS Position      */
#define SCU_RESET_PRCLR0_USIC0RS_Msk          (0x01UL << SCU_RESET_PRCLR0_USIC0RS_Pos)                /*!< SCU_RESET PRCLR0: USIC0RS Mask          */
#define SCU_RESET_PRCLR0_ERU1RS_Pos           16                                                      /*!< SCU_RESET PRCLR0: ERU1RS Position       */
#define SCU_RESET_PRCLR0_ERU1RS_Msk           (0x01UL << SCU_RESET_PRCLR0_ERU1RS_Pos)                 /*!< SCU_RESET PRCLR0: ERU1RS Mask           */
#define SCU_RESET_PRCLR0_HRPWM0RS_Pos         23                                                      /*!< SCU_RESET PRCLR0: HRPWM0RS Position     */
#define SCU_RESET_PRCLR0_HRPWM0RS_Msk         (0x01UL << SCU_RESET_PRCLR0_HRPWM0RS_Pos)               /*!< SCU_RESET PRCLR0: HRPWM0RS Mask         */

/* ------------------------------  SCU_RESET_PRSTAT1  ----------------------------- */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Pos      3                                                       /*!< SCU_RESET PRSTAT1: LEDTSCU0RS Position  */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Msk      (0x01UL << SCU_RESET_PRSTAT1_LEDTSCU0RS_Pos)            /*!< SCU_RESET PRSTAT1: LEDTSCU0RS Mask      */
#define SCU_RESET_PRSTAT1_MCAN0RS_Pos         4                                                       /*!< SCU_RESET PRSTAT1: MCAN0RS Position     */
#define SCU_RESET_PRSTAT1_MCAN0RS_Msk         (0x01UL << SCU_RESET_PRSTAT1_MCAN0RS_Pos)               /*!< SCU_RESET PRSTAT1: MCAN0RS Mask         */
#define SCU_RESET_PRSTAT1_DACRS_Pos           5                                                       /*!< SCU_RESET PRSTAT1: DACRS Position       */
#define SCU_RESET_PRSTAT1_DACRS_Msk           (0x01UL << SCU_RESET_PRSTAT1_DACRS_Pos)                 /*!< SCU_RESET PRSTAT1: DACRS Mask           */
#define SCU_RESET_PRSTAT1_USIC1RS_Pos         7                                                       /*!< SCU_RESET PRSTAT1: USIC1RS Position     */
#define SCU_RESET_PRSTAT1_USIC1RS_Msk         (0x01UL << SCU_RESET_PRSTAT1_USIC1RS_Pos)               /*!< SCU_RESET PRSTAT1: USIC1RS Mask         */
#define SCU_RESET_PRSTAT1_PPORTSRS_Pos        9                                                       /*!< SCU_RESET PRSTAT1: PPORTSRS Position    */
#define SCU_RESET_PRSTAT1_PPORTSRS_Msk        (0x01UL << SCU_RESET_PRSTAT1_PPORTSRS_Pos)              /*!< SCU_RESET PRSTAT1: PPORTSRS Mask        */

/* ------------------------------  SCU_RESET_PRSET1  ------------------------------ */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Pos       3                                                       /*!< SCU_RESET PRSET1: LEDTSCU0RS Position   */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Msk       (0x01UL << SCU_RESET_PRSET1_LEDTSCU0RS_Pos)             /*!< SCU_RESET PRSET1: LEDTSCU0RS Mask       */
#define SCU_RESET_PRSET1_MCAN0RS_Pos          4                                                       /*!< SCU_RESET PRSET1: MCAN0RS Position      */
#define SCU_RESET_PRSET1_MCAN0RS_Msk          (0x01UL << SCU_RESET_PRSET1_MCAN0RS_Pos)                /*!< SCU_RESET PRSET1: MCAN0RS Mask          */
#define SCU_RESET_PRSET1_DACRS_Pos            5                                                       /*!< SCU_RESET PRSET1: DACRS Position        */
#define SCU_RESET_PRSET1_DACRS_Msk            (0x01UL << SCU_RESET_PRSET1_DACRS_Pos)                  /*!< SCU_RESET PRSET1: DACRS Mask            */
#define SCU_RESET_PRSET1_USIC1RS_Pos          7                                                       /*!< SCU_RESET PRSET1: USIC1RS Position      */
#define SCU_RESET_PRSET1_USIC1RS_Msk          (0x01UL << SCU_RESET_PRSET1_USIC1RS_Pos)                /*!< SCU_RESET PRSET1: USIC1RS Mask          */
#define SCU_RESET_PRSET1_PPORTSRS_Pos         9                                                       /*!< SCU_RESET PRSET1: PPORTSRS Position     */
#define SCU_RESET_PRSET1_PPORTSRS_Msk         (0x01UL << SCU_RESET_PRSET1_PPORTSRS_Pos)               /*!< SCU_RESET PRSET1: PPORTSRS Mask         */

/* ------------------------------  SCU_RESET_PRCLR1  ------------------------------ */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Pos       3                                                       /*!< SCU_RESET PRCLR1: LEDTSCU0RS Position   */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Msk       (0x01UL << SCU_RESET_PRCLR1_LEDTSCU0RS_Pos)             /*!< SCU_RESET PRCLR1: LEDTSCU0RS Mask       */
#define SCU_RESET_PRCLR1_MCAN0RS_Pos          4                                                       /*!< SCU_RESET PRCLR1: MCAN0RS Position      */
#define SCU_RESET_PRCLR1_MCAN0RS_Msk          (0x01UL << SCU_RESET_PRCLR1_MCAN0RS_Pos)                /*!< SCU_RESET PRCLR1: MCAN0RS Mask          */
#define SCU_RESET_PRCLR1_DACRS_Pos            5                                                       /*!< SCU_RESET PRCLR1: DACRS Position        */
#define SCU_RESET_PRCLR1_DACRS_Msk            (0x01UL << SCU_RESET_PRCLR1_DACRS_Pos)                  /*!< SCU_RESET PRCLR1: DACRS Mask            */
#define SCU_RESET_PRCLR1_USIC1RS_Pos          7                                                       /*!< SCU_RESET PRCLR1: USIC1RS Position      */
#define SCU_RESET_PRCLR1_USIC1RS_Msk          (0x01UL << SCU_RESET_PRCLR1_USIC1RS_Pos)                /*!< SCU_RESET PRCLR1: USIC1RS Mask          */
#define SCU_RESET_PRCLR1_PPORTSRS_Pos         9                                                       /*!< SCU_RESET PRCLR1: PPORTSRS Position     */
#define SCU_RESET_PRCLR1_PPORTSRS_Msk         (0x01UL << SCU_RESET_PRCLR1_PPORTSRS_Pos)               /*!< SCU_RESET PRCLR1: PPORTSRS Mask         */

/* ------------------------------  SCU_RESET_PRSTAT2  ----------------------------- */
#define SCU_RESET_PRSTAT2_WDTRS_Pos           1                                                       /*!< SCU_RESET PRSTAT2: WDTRS Position       */
#define SCU_RESET_PRSTAT2_WDTRS_Msk           (0x01UL << SCU_RESET_PRSTAT2_WDTRS_Pos)                 /*!< SCU_RESET PRSTAT2: WDTRS Mask           */
#define SCU_RESET_PRSTAT2_DMA0RS_Pos          4                                                       /*!< SCU_RESET PRSTAT2: DMA0RS Position      */
#define SCU_RESET_PRSTAT2_DMA0RS_Msk          (0x01UL << SCU_RESET_PRSTAT2_DMA0RS_Pos)                /*!< SCU_RESET PRSTAT2: DMA0RS Mask          */
#define SCU_RESET_PRSTAT2_FCERS_Pos           6                                                       /*!< SCU_RESET PRSTAT2: FCERS Position       */
#define SCU_RESET_PRSTAT2_FCERS_Msk           (0x01UL << SCU_RESET_PRSTAT2_FCERS_Pos)                 /*!< SCU_RESET PRSTAT2: FCERS Mask           */
#define SCU_RESET_PRSTAT2_USBRS_Pos           7                                                       /*!< SCU_RESET PRSTAT2: USBRS Position       */
#define SCU_RESET_PRSTAT2_USBRS_Msk           (0x01UL << SCU_RESET_PRSTAT2_USBRS_Pos)                 /*!< SCU_RESET PRSTAT2: USBRS Mask           */

/* ------------------------------  SCU_RESET_PRSET2  ------------------------------ */
#define SCU_RESET_PRSET2_WDTRS_Pos            1                                                       /*!< SCU_RESET PRSET2: WDTRS Position        */
#define SCU_RESET_PRSET2_WDTRS_Msk            (0x01UL << SCU_RESET_PRSET2_WDTRS_Pos)                  /*!< SCU_RESET PRSET2: WDTRS Mask            */
#define SCU_RESET_PRSET2_DMA0RS_Pos           4                                                       /*!< SCU_RESET PRSET2: DMA0RS Position       */
#define SCU_RESET_PRSET2_DMA0RS_Msk           (0x01UL << SCU_RESET_PRSET2_DMA0RS_Pos)                 /*!< SCU_RESET PRSET2: DMA0RS Mask           */
#define SCU_RESET_PRSET2_FCERS_Pos            6                                                       /*!< SCU_RESET PRSET2: FCERS Position        */
#define SCU_RESET_PRSET2_FCERS_Msk            (0x01UL << SCU_RESET_PRSET2_FCERS_Pos)                  /*!< SCU_RESET PRSET2: FCERS Mask            */
#define SCU_RESET_PRSET2_USBRS_Pos            7                                                       /*!< SCU_RESET PRSET2: USBRS Position        */
#define SCU_RESET_PRSET2_USBRS_Msk            (0x01UL << SCU_RESET_PRSET2_USBRS_Pos)                  /*!< SCU_RESET PRSET2: USBRS Mask            */

/* ------------------------------  SCU_RESET_PRCLR2  ------------------------------ */
#define SCU_RESET_PRCLR2_WDTRS_Pos            1                                                       /*!< SCU_RESET PRCLR2: WDTRS Position        */
#define SCU_RESET_PRCLR2_WDTRS_Msk            (0x01UL << SCU_RESET_PRCLR2_WDTRS_Pos)                  /*!< SCU_RESET PRCLR2: WDTRS Mask            */
#define SCU_RESET_PRCLR2_DMA0RS_Pos           4                                                       /*!< SCU_RESET PRCLR2: DMA0RS Position       */
#define SCU_RESET_PRCLR2_DMA0RS_Msk           (0x01UL << SCU_RESET_PRCLR2_DMA0RS_Pos)                 /*!< SCU_RESET PRCLR2: DMA0RS Mask           */
#define SCU_RESET_PRCLR2_FCERS_Pos            6                                                       /*!< SCU_RESET PRCLR2: FCERS Position        */
#define SCU_RESET_PRCLR2_FCERS_Msk            (0x01UL << SCU_RESET_PRCLR2_FCERS_Pos)                  /*!< SCU_RESET PRCLR2: FCERS Mask            */
#define SCU_RESET_PRCLR2_USBRS_Pos            7                                                       /*!< SCU_RESET PRCLR2: USBRS Position        */
#define SCU_RESET_PRCLR2_USBRS_Msk            (0x01UL << SCU_RESET_PRCLR2_USBRS_Pos)                  /*!< SCU_RESET PRCLR2: USBRS Mask            */


/* ================================================================================ */
/* ================          Group 'LEDTS' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  LEDTS_ID  ---------------------------------- */
#define LEDTS_ID_MOD_REV_Pos                  0                                                       /*!< LEDTS ID: MOD_REV Position              */
#define LEDTS_ID_MOD_REV_Msk                  (0x000000ffUL << LEDTS_ID_MOD_REV_Pos)                  /*!< LEDTS ID: MOD_REV Mask                  */
#define LEDTS_ID_MOD_TYPE_Pos                 8                                                       /*!< LEDTS ID: MOD_TYPE Position             */
#define LEDTS_ID_MOD_TYPE_Msk                 (0x000000ffUL << LEDTS_ID_MOD_TYPE_Pos)                 /*!< LEDTS ID: MOD_TYPE Mask                 */
#define LEDTS_ID_MOD_NUMBER_Pos               16                                                      /*!< LEDTS ID: MOD_NUMBER Position           */
#define LEDTS_ID_MOD_NUMBER_Msk               (0x0000ffffUL << LEDTS_ID_MOD_NUMBER_Pos)               /*!< LEDTS ID: MOD_NUMBER Mask               */

/* --------------------------------  LEDTS_GLOBCTL  ------------------------------- */
#define LEDTS_GLOBCTL_TS_EN_Pos               0                                                       /*!< LEDTS GLOBCTL: TS_EN Position           */
#define LEDTS_GLOBCTL_TS_EN_Msk               (0x01UL << LEDTS_GLOBCTL_TS_EN_Pos)                     /*!< LEDTS GLOBCTL: TS_EN Mask               */
#define LEDTS_GLOBCTL_LD_EN_Pos               1                                                       /*!< LEDTS GLOBCTL: LD_EN Position           */
#define LEDTS_GLOBCTL_LD_EN_Msk               (0x01UL << LEDTS_GLOBCTL_LD_EN_Pos)                     /*!< LEDTS GLOBCTL: LD_EN Mask               */
#define LEDTS_GLOBCTL_CMTR_Pos                2                                                       /*!< LEDTS GLOBCTL: CMTR Position            */
#define LEDTS_GLOBCTL_CMTR_Msk                (0x01UL << LEDTS_GLOBCTL_CMTR_Pos)                      /*!< LEDTS GLOBCTL: CMTR Mask                */
#define LEDTS_GLOBCTL_ENSYNC_Pos              3                                                       /*!< LEDTS GLOBCTL: ENSYNC Position          */
#define LEDTS_GLOBCTL_ENSYNC_Msk              (0x01UL << LEDTS_GLOBCTL_ENSYNC_Pos)                    /*!< LEDTS GLOBCTL: ENSYNC Mask              */
#define LEDTS_GLOBCTL_SUSCFG_Pos              8                                                       /*!< LEDTS GLOBCTL: SUSCFG Position          */
#define LEDTS_GLOBCTL_SUSCFG_Msk              (0x01UL << LEDTS_GLOBCTL_SUSCFG_Pos)                    /*!< LEDTS GLOBCTL: SUSCFG Mask              */
#define LEDTS_GLOBCTL_MASKVAL_Pos             9                                                       /*!< LEDTS GLOBCTL: MASKVAL Position         */
#define LEDTS_GLOBCTL_MASKVAL_Msk             (0x07UL << LEDTS_GLOBCTL_MASKVAL_Pos)                   /*!< LEDTS GLOBCTL: MASKVAL Mask             */
#define LEDTS_GLOBCTL_FENVAL_Pos              12                                                      /*!< LEDTS GLOBCTL: FENVAL Position          */
#define LEDTS_GLOBCTL_FENVAL_Msk              (0x01UL << LEDTS_GLOBCTL_FENVAL_Pos)                    /*!< LEDTS GLOBCTL: FENVAL Mask              */
#define LEDTS_GLOBCTL_ITS_EN_Pos              13                                                      /*!< LEDTS GLOBCTL: ITS_EN Position          */
#define LEDTS_GLOBCTL_ITS_EN_Msk              (0x01UL << LEDTS_GLOBCTL_ITS_EN_Pos)                    /*!< LEDTS GLOBCTL: ITS_EN Mask              */
#define LEDTS_GLOBCTL_ITF_EN_Pos              14                                                      /*!< LEDTS GLOBCTL: ITF_EN Position          */
#define LEDTS_GLOBCTL_ITF_EN_Msk              (0x01UL << LEDTS_GLOBCTL_ITF_EN_Pos)                    /*!< LEDTS GLOBCTL: ITF_EN Mask              */
#define LEDTS_GLOBCTL_ITP_EN_Pos              15                                                      /*!< LEDTS GLOBCTL: ITP_EN Position          */
#define LEDTS_GLOBCTL_ITP_EN_Msk              (0x01UL << LEDTS_GLOBCTL_ITP_EN_Pos)                    /*!< LEDTS GLOBCTL: ITP_EN Mask              */
#define LEDTS_GLOBCTL_CLK_PS_Pos              16                                                      /*!< LEDTS GLOBCTL: CLK_PS Position          */
#define LEDTS_GLOBCTL_CLK_PS_Msk              (0x0000ffffUL << LEDTS_GLOBCTL_CLK_PS_Pos)              /*!< LEDTS GLOBCTL: CLK_PS Mask              */

/* ---------------------------------  LEDTS_FNCTL  -------------------------------- */
#define LEDTS_FNCTL_PADT_Pos                  0                                                       /*!< LEDTS FNCTL: PADT Position              */
#define LEDTS_FNCTL_PADT_Msk                  (0x07UL << LEDTS_FNCTL_PADT_Pos)                        /*!< LEDTS FNCTL: PADT Mask                  */
#define LEDTS_FNCTL_PADTSW_Pos                3                                                       /*!< LEDTS FNCTL: PADTSW Position            */
#define LEDTS_FNCTL_PADTSW_Msk                (0x01UL << LEDTS_FNCTL_PADTSW_Pos)                      /*!< LEDTS FNCTL: PADTSW Mask                */
#define LEDTS_FNCTL_EPULL_Pos                 4                                                       /*!< LEDTS FNCTL: EPULL Position             */
#define LEDTS_FNCTL_EPULL_Msk                 (0x01UL << LEDTS_FNCTL_EPULL_Pos)                       /*!< LEDTS FNCTL: EPULL Mask                 */
#define LEDTS_FNCTL_FNCOL_Pos                 5                                                       /*!< LEDTS FNCTL: FNCOL Position             */
#define LEDTS_FNCTL_FNCOL_Msk                 (0x07UL << LEDTS_FNCTL_FNCOL_Pos)                       /*!< LEDTS FNCTL: FNCOL Mask                 */
#define LEDTS_FNCTL_ACCCNT_Pos                16                                                      /*!< LEDTS FNCTL: ACCCNT Position            */
#define LEDTS_FNCTL_ACCCNT_Msk                (0x0fUL << LEDTS_FNCTL_ACCCNT_Pos)                      /*!< LEDTS FNCTL: ACCCNT Mask                */
#define LEDTS_FNCTL_TSCCMP_Pos                20                                                      /*!< LEDTS FNCTL: TSCCMP Position            */
#define LEDTS_FNCTL_TSCCMP_Msk                (0x01UL << LEDTS_FNCTL_TSCCMP_Pos)                      /*!< LEDTS FNCTL: TSCCMP Mask                */
#define LEDTS_FNCTL_TSOEXT_Pos                21                                                      /*!< LEDTS FNCTL: TSOEXT Position            */
#define LEDTS_FNCTL_TSOEXT_Msk                (0x03UL << LEDTS_FNCTL_TSOEXT_Pos)                      /*!< LEDTS FNCTL: TSOEXT Mask                */
#define LEDTS_FNCTL_TSCTRR_Pos                23                                                      /*!< LEDTS FNCTL: TSCTRR Position            */
#define LEDTS_FNCTL_TSCTRR_Msk                (0x01UL << LEDTS_FNCTL_TSCTRR_Pos)                      /*!< LEDTS FNCTL: TSCTRR Mask                */
#define LEDTS_FNCTL_TSCTRSAT_Pos              24                                                      /*!< LEDTS FNCTL: TSCTRSAT Position          */
#define LEDTS_FNCTL_TSCTRSAT_Msk              (0x01UL << LEDTS_FNCTL_TSCTRSAT_Pos)                    /*!< LEDTS FNCTL: TSCTRSAT Mask              */
#define LEDTS_FNCTL_NR_TSIN_Pos               25                                                      /*!< LEDTS FNCTL: NR_TSIN Position           */
#define LEDTS_FNCTL_NR_TSIN_Msk               (0x07UL << LEDTS_FNCTL_NR_TSIN_Pos)                     /*!< LEDTS FNCTL: NR_TSIN Mask               */
#define LEDTS_FNCTL_COLLEV_Pos                28                                                      /*!< LEDTS FNCTL: COLLEV Position            */
#define LEDTS_FNCTL_COLLEV_Msk                (0x01UL << LEDTS_FNCTL_COLLEV_Pos)                      /*!< LEDTS FNCTL: COLLEV Mask                */
#define LEDTS_FNCTL_NR_LEDCOL_Pos             29                                                      /*!< LEDTS FNCTL: NR_LEDCOL Position         */
#define LEDTS_FNCTL_NR_LEDCOL_Msk             (0x07UL << LEDTS_FNCTL_NR_LEDCOL_Pos)                   /*!< LEDTS FNCTL: NR_LEDCOL Mask             */

/* ---------------------------------  LEDTS_EVFR  --------------------------------- */
#define LEDTS_EVFR_TSF_Pos                    0                                                       /*!< LEDTS EVFR: TSF Position                */
#define LEDTS_EVFR_TSF_Msk                    (0x01UL << LEDTS_EVFR_TSF_Pos)                          /*!< LEDTS EVFR: TSF Mask                    */
#define LEDTS_EVFR_TFF_Pos                    1                                                       /*!< LEDTS EVFR: TFF Position                */
#define LEDTS_EVFR_TFF_Msk                    (0x01UL << LEDTS_EVFR_TFF_Pos)                          /*!< LEDTS EVFR: TFF Mask                    */
#define LEDTS_EVFR_TPF_Pos                    2                                                       /*!< LEDTS EVFR: TPF Position                */
#define LEDTS_EVFR_TPF_Msk                    (0x01UL << LEDTS_EVFR_TPF_Pos)                          /*!< LEDTS EVFR: TPF Mask                    */
#define LEDTS_EVFR_TSCTROVF_Pos               3                                                       /*!< LEDTS EVFR: TSCTROVF Position           */
#define LEDTS_EVFR_TSCTROVF_Msk               (0x01UL << LEDTS_EVFR_TSCTROVF_Pos)                     /*!< LEDTS EVFR: TSCTROVF Mask               */
#define LEDTS_EVFR_CTSF_Pos                   16                                                      /*!< LEDTS EVFR: CTSF Position               */
#define LEDTS_EVFR_CTSF_Msk                   (0x01UL << LEDTS_EVFR_CTSF_Pos)                         /*!< LEDTS EVFR: CTSF Mask                   */
#define LEDTS_EVFR_CTFF_Pos                   17                                                      /*!< LEDTS EVFR: CTFF Position               */
#define LEDTS_EVFR_CTFF_Msk                   (0x01UL << LEDTS_EVFR_CTFF_Pos)                         /*!< LEDTS EVFR: CTFF Mask                   */
#define LEDTS_EVFR_CTPF_Pos                   18                                                      /*!< LEDTS EVFR: CTPF Position               */
#define LEDTS_EVFR_CTPF_Msk                   (0x01UL << LEDTS_EVFR_CTPF_Pos)                         /*!< LEDTS EVFR: CTPF Mask                   */

/* ---------------------------------  LEDTS_TSVAL  -------------------------------- */
#define LEDTS_TSVAL_TSCTRVALR_Pos             0                                                       /*!< LEDTS TSVAL: TSCTRVALR Position         */
#define LEDTS_TSVAL_TSCTRVALR_Msk             (0x0000ffffUL << LEDTS_TSVAL_TSCTRVALR_Pos)             /*!< LEDTS TSVAL: TSCTRVALR Mask             */
#define LEDTS_TSVAL_TSCTRVAL_Pos              16                                                      /*!< LEDTS TSVAL: TSCTRVAL Position          */
#define LEDTS_TSVAL_TSCTRVAL_Msk              (0x0000ffffUL << LEDTS_TSVAL_TSCTRVAL_Pos)              /*!< LEDTS TSVAL: TSCTRVAL Mask              */

/* ---------------------------------  LEDTS_LINE0  -------------------------------- */
#define LEDTS_LINE0_LINE_0_Pos                0                                                       /*!< LEDTS LINE0: LINE_0 Position            */
#define LEDTS_LINE0_LINE_0_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_0_Pos)                /*!< LEDTS LINE0: LINE_0 Mask                */
#define LEDTS_LINE0_LINE_1_Pos                8                                                       /*!< LEDTS LINE0: LINE_1 Position            */
#define LEDTS_LINE0_LINE_1_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_1_Pos)                /*!< LEDTS LINE0: LINE_1 Mask                */
#define LEDTS_LINE0_LINE_2_Pos                16                                                      /*!< LEDTS LINE0: LINE_2 Position            */
#define LEDTS_LINE0_LINE_2_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_2_Pos)                /*!< LEDTS LINE0: LINE_2 Mask                */
#define LEDTS_LINE0_LINE_3_Pos                24                                                      /*!< LEDTS LINE0: LINE_3 Position            */
#define LEDTS_LINE0_LINE_3_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_3_Pos)                /*!< LEDTS LINE0: LINE_3 Mask                */

/* ---------------------------------  LEDTS_LINE1  -------------------------------- */
#define LEDTS_LINE1_LINE_4_Pos                0                                                       /*!< LEDTS LINE1: LINE_4 Position            */
#define LEDTS_LINE1_LINE_4_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_4_Pos)                /*!< LEDTS LINE1: LINE_4 Mask                */
#define LEDTS_LINE1_LINE_5_Pos                8                                                       /*!< LEDTS LINE1: LINE_5 Position            */
#define LEDTS_LINE1_LINE_5_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_5_Pos)                /*!< LEDTS LINE1: LINE_5 Mask                */
#define LEDTS_LINE1_LINE_6_Pos                16                                                      /*!< LEDTS LINE1: LINE_6 Position            */
#define LEDTS_LINE1_LINE_6_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_6_Pos)                /*!< LEDTS LINE1: LINE_6 Mask                */
#define LEDTS_LINE1_LINE_A_Pos                24                                                      /*!< LEDTS LINE1: LINE_A Position            */
#define LEDTS_LINE1_LINE_A_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_A_Pos)                /*!< LEDTS LINE1: LINE_A Mask                */

/* --------------------------------  LEDTS_LDCMP0  -------------------------------- */
#define LEDTS_LDCMP0_CMP_LD0_Pos              0                                                       /*!< LEDTS LDCMP0: CMP_LD0 Position          */
#define LEDTS_LDCMP0_CMP_LD0_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD0_Pos)              /*!< LEDTS LDCMP0: CMP_LD0 Mask              */
#define LEDTS_LDCMP0_CMP_LD1_Pos              8                                                       /*!< LEDTS LDCMP0: CMP_LD1 Position          */
#define LEDTS_LDCMP0_CMP_LD1_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD1_Pos)              /*!< LEDTS LDCMP0: CMP_LD1 Mask              */
#define LEDTS_LDCMP0_CMP_LD2_Pos              16                                                      /*!< LEDTS LDCMP0: CMP_LD2 Position          */
#define LEDTS_LDCMP0_CMP_LD2_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD2_Pos)              /*!< LEDTS LDCMP0: CMP_LD2 Mask              */
#define LEDTS_LDCMP0_CMP_LD3_Pos              24                                                      /*!< LEDTS LDCMP0: CMP_LD3 Position          */
#define LEDTS_LDCMP0_CMP_LD3_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD3_Pos)              /*!< LEDTS LDCMP0: CMP_LD3 Mask              */

/* --------------------------------  LEDTS_LDCMP1  -------------------------------- */
#define LEDTS_LDCMP1_CMP_LD4_Pos              0                                                       /*!< LEDTS LDCMP1: CMP_LD4 Position          */
#define LEDTS_LDCMP1_CMP_LD4_Msk              (0x000000ffUL << LEDTS_LDCMP1_CMP_LD4_Pos)              /*!< LEDTS LDCMP1: CMP_LD4 Mask              */
#define LEDTS_LDCMP1_CMP_LD5_Pos              8                                                       /*!< LEDTS LDCMP1: CMP_LD5 Position          */
#define LEDTS_LDCMP1_CMP_LD5_Msk              (0x000000ffUL << LEDTS_LDCMP1_CMP_LD5_Pos)              /*!< LEDTS LDCMP1: CMP_LD5 Mask              */
#define LEDTS_LDCMP1_CMP_LD6_Pos              16                                                      /*!< LEDTS LDCMP1: CMP_LD6 Position          */
#define LEDTS_LDCMP1_CMP_LD6_Msk              (0x000000ffUL << LEDTS_LDCMP1_CMP_LD6_Pos)              /*!< LEDTS LDCMP1: CMP_LD6 Mask              */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Pos        24                                                      /*!< LEDTS LDCMP1: CMP_LDA_TSCOM Position    */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Msk        (0x000000ffUL << LEDTS_LDCMP1_CMP_LDA_TSCOM_Pos)        /*!< LEDTS LDCMP1: CMP_LDA_TSCOM Mask        */

/* --------------------------------  LEDTS_TSCMP0  -------------------------------- */
#define LEDTS_TSCMP0_CMP_TS0_Pos              0                                                       /*!< LEDTS TSCMP0: CMP_TS0 Position          */
#define LEDTS_TSCMP0_CMP_TS0_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS0_Pos)              /*!< LEDTS TSCMP0: CMP_TS0 Mask              */
#define LEDTS_TSCMP0_CMP_TS1_Pos              8                                                       /*!< LEDTS TSCMP0: CMP_TS1 Position          */
#define LEDTS_TSCMP0_CMP_TS1_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS1_Pos)              /*!< LEDTS TSCMP0: CMP_TS1 Mask              */
#define LEDTS_TSCMP0_CMP_TS2_Pos              16                                                      /*!< LEDTS TSCMP0: CMP_TS2 Position          */
#define LEDTS_TSCMP0_CMP_TS2_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS2_Pos)              /*!< LEDTS TSCMP0: CMP_TS2 Mask              */
#define LEDTS_TSCMP0_CMP_TS3_Pos              24                                                      /*!< LEDTS TSCMP0: CMP_TS3 Position          */
#define LEDTS_TSCMP0_CMP_TS3_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS3_Pos)              /*!< LEDTS TSCMP0: CMP_TS3 Mask              */

/* --------------------------------  LEDTS_TSCMP1  -------------------------------- */
#define LEDTS_TSCMP1_CMP_TS4_Pos              0                                                       /*!< LEDTS TSCMP1: CMP_TS4 Position          */
#define LEDTS_TSCMP1_CMP_TS4_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS4_Pos)              /*!< LEDTS TSCMP1: CMP_TS4 Mask              */
#define LEDTS_TSCMP1_CMP_TS5_Pos              8                                                       /*!< LEDTS TSCMP1: CMP_TS5 Position          */
#define LEDTS_TSCMP1_CMP_TS5_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS5_Pos)              /*!< LEDTS TSCMP1: CMP_TS5 Mask              */
#define LEDTS_TSCMP1_CMP_TS6_Pos              16                                                      /*!< LEDTS TSCMP1: CMP_TS6 Position          */
#define LEDTS_TSCMP1_CMP_TS6_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS6_Pos)              /*!< LEDTS TSCMP1: CMP_TS6 Mask              */
#define LEDTS_TSCMP1_CMP_TS7_Pos              24                                                      /*!< LEDTS TSCMP1: CMP_TS7 Position          */
#define LEDTS_TSCMP1_CMP_TS7_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS7_Pos)              /*!< LEDTS TSCMP1: CMP_TS7 Mask              */


/* ================================================================================ */
/* ================           Group 'USB' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  USB_GAHBCFG  -------------------------------- */
#define USB_GAHBCFG_GlblIntrMsk_Pos           0                                                       /*!< USB GAHBCFG: GlblIntrMsk Position       */
#define USB_GAHBCFG_GlblIntrMsk_Msk           (0x01UL << USB_GAHBCFG_GlblIntrMsk_Pos)                 /*!< USB GAHBCFG: GlblIntrMsk Mask           */
#define USB_GAHBCFG_HBstLen_Pos               1                                                       /*!< USB GAHBCFG: HBstLen Position           */
#define USB_GAHBCFG_HBstLen_Msk               (0x0fUL << USB_GAHBCFG_HBstLen_Pos)                     /*!< USB GAHBCFG: HBstLen Mask               */
#define USB_GAHBCFG_DMAEn_Pos                 5                                                       /*!< USB GAHBCFG: DMAEn Position             */
#define USB_GAHBCFG_DMAEn_Msk                 (0x01UL << USB_GAHBCFG_DMAEn_Pos)                       /*!< USB GAHBCFG: DMAEn Mask                 */
#define USB_GAHBCFG_NPTxFEmpLvl_Pos           7                                                       /*!< USB GAHBCFG: NPTxFEmpLvl Position       */
#define USB_GAHBCFG_NPTxFEmpLvl_Msk           (0x01UL << USB_GAHBCFG_NPTxFEmpLvl_Pos)                 /*!< USB GAHBCFG: NPTxFEmpLvl Mask           */
#define USB_GAHBCFG_AHBSingle_Pos             23                                                      /*!< USB GAHBCFG: AHBSingle Position         */
#define USB_GAHBCFG_AHBSingle_Msk             (0x01UL << USB_GAHBCFG_AHBSingle_Pos)                   /*!< USB GAHBCFG: AHBSingle Mask             */

/* ---------------------------------  USB_GUSBCFG  -------------------------------- */
#define USB_GUSBCFG_TOutCal_Pos               0                                                       /*!< USB GUSBCFG: TOutCal Position           */
#define USB_GUSBCFG_TOutCal_Msk               (0x07UL << USB_GUSBCFG_TOutCal_Pos)                     /*!< USB GUSBCFG: TOutCal Mask               */
#define USB_GUSBCFG_PHYSel_Pos                6                                                       /*!< USB GUSBCFG: PHYSel Position            */
#define USB_GUSBCFG_PHYSel_Msk                (0x01UL << USB_GUSBCFG_PHYSel_Pos)                      /*!< USB GUSBCFG: PHYSel Mask                */
#define USB_GUSBCFG_USBTrdTim_Pos             10                                                      /*!< USB GUSBCFG: USBTrdTim Position         */
#define USB_GUSBCFG_USBTrdTim_Msk             (0x0fUL << USB_GUSBCFG_USBTrdTim_Pos)                   /*!< USB GUSBCFG: USBTrdTim Mask             */
#define USB_GUSBCFG_TxEndDelay_Pos            28                                                      /*!< USB GUSBCFG: TxEndDelay Position        */
#define USB_GUSBCFG_TxEndDelay_Msk            (0x01UL << USB_GUSBCFG_TxEndDelay_Pos)                  /*!< USB GUSBCFG: TxEndDelay Mask            */
#define USB_GUSBCFG_ForceDevMode_Pos          30                                                      /*!< USB GUSBCFG: ForceDevMode Position      */
#define USB_GUSBCFG_ForceDevMode_Msk          (0x01UL << USB_GUSBCFG_ForceDevMode_Pos)                /*!< USB GUSBCFG: ForceDevMode Mask          */
#define USB_GUSBCFG_CTP_Pos                   31                                                      /*!< USB GUSBCFG: CTP Position               */
#define USB_GUSBCFG_CTP_Msk                   (0x01UL << USB_GUSBCFG_CTP_Pos)                         /*!< USB GUSBCFG: CTP Mask                   */

/* ---------------------------------  USB_GRSTCTL  -------------------------------- */
#define USB_GRSTCTL_CSftRst_Pos               0                                                       /*!< USB GRSTCTL: CSftRst Position           */
#define USB_GRSTCTL_CSftRst_Msk               (0x01UL << USB_GRSTCTL_CSftRst_Pos)                     /*!< USB GRSTCTL: CSftRst Mask               */
#define USB_GRSTCTL_RxFFlsh_Pos               4                                                       /*!< USB GRSTCTL: RxFFlsh Position           */
#define USB_GRSTCTL_RxFFlsh_Msk               (0x01UL << USB_GRSTCTL_RxFFlsh_Pos)                     /*!< USB GRSTCTL: RxFFlsh Mask               */
#define USB_GRSTCTL_TxFFlsh_Pos               5                                                       /*!< USB GRSTCTL: TxFFlsh Position           */
#define USB_GRSTCTL_TxFFlsh_Msk               (0x01UL << USB_GRSTCTL_TxFFlsh_Pos)                     /*!< USB GRSTCTL: TxFFlsh Mask               */
#define USB_GRSTCTL_TxFNum_Pos                6                                                       /*!< USB GRSTCTL: TxFNum Position            */
#define USB_GRSTCTL_TxFNum_Msk                (0x1fUL << USB_GRSTCTL_TxFNum_Pos)                      /*!< USB GRSTCTL: TxFNum Mask                */
#define USB_GRSTCTL_DMAReq_Pos                30                                                      /*!< USB GRSTCTL: DMAReq Position            */
#define USB_GRSTCTL_DMAReq_Msk                (0x01UL << USB_GRSTCTL_DMAReq_Pos)                      /*!< USB GRSTCTL: DMAReq Mask                */
#define USB_GRSTCTL_AHBIdle_Pos               31                                                      /*!< USB GRSTCTL: AHBIdle Position           */
#define USB_GRSTCTL_AHBIdle_Msk               (0x01UL << USB_GRSTCTL_AHBIdle_Pos)                     /*!< USB GRSTCTL: AHBIdle Mask               */

/* ---------------------------------  USB_GINTSTS  -------------------------------- */
#define USB_GINTSTS_CurMod_Pos                0                                                       /*!< USB GINTSTS: CurMod Position            */
#define USB_GINTSTS_CurMod_Msk                (0x01UL << USB_GINTSTS_CurMod_Pos)                      /*!< USB GINTSTS: CurMod Mask                */
#define USB_GINTSTS_Sof_Pos                   3                                                       /*!< USB GINTSTS: Sof Position               */
#define USB_GINTSTS_Sof_Msk                   (0x01UL << USB_GINTSTS_Sof_Pos)                         /*!< USB GINTSTS: Sof Mask                   */
#define USB_GINTSTS_RxFLvl_Pos                4                                                       /*!< USB GINTSTS: RxFLvl Position            */
#define USB_GINTSTS_RxFLvl_Msk                (0x01UL << USB_GINTSTS_RxFLvl_Pos)                      /*!< USB GINTSTS: RxFLvl Mask                */
#define USB_GINTSTS_GINNakEff_Pos             6                                                       /*!< USB GINTSTS: GINNakEff Position         */
#define USB_GINTSTS_GINNakEff_Msk             (0x01UL << USB_GINTSTS_GINNakEff_Pos)                   /*!< USB GINTSTS: GINNakEff Mask             */
#define USB_GINTSTS_GOUTNakEff_Pos            7                                                       /*!< USB GINTSTS: GOUTNakEff Position        */
#define USB_GINTSTS_GOUTNakEff_Msk            (0x01UL << USB_GINTSTS_GOUTNakEff_Pos)                  /*!< USB GINTSTS: GOUTNakEff Mask            */
#define USB_GINTSTS_ErlySusp_Pos              10                                                      /*!< USB GINTSTS: ErlySusp Position          */
#define USB_GINTSTS_ErlySusp_Msk              (0x01UL << USB_GINTSTS_ErlySusp_Pos)                    /*!< USB GINTSTS: ErlySusp Mask              */
#define USB_GINTSTS_USBSusp_Pos               11                                                      /*!< USB GINTSTS: USBSusp Position           */
#define USB_GINTSTS_USBSusp_Msk               (0x01UL << USB_GINTSTS_USBSusp_Pos)                     /*!< USB GINTSTS: USBSusp Mask               */
#define USB_GINTSTS_USBRst_Pos                12                                                      /*!< USB GINTSTS: USBRst Position            */
#define USB_GINTSTS_USBRst_Msk                (0x01UL << USB_GINTSTS_USBRst_Pos)                      /*!< USB GINTSTS: USBRst Mask                */
#define USB_GINTSTS_EnumDone_Pos              13                                                      /*!< USB GINTSTS: EnumDone Position          */
#define USB_GINTSTS_EnumDone_Msk              (0x01UL << USB_GINTSTS_EnumDone_Pos)                    /*!< USB GINTSTS: EnumDone Mask              */
#define USB_GINTSTS_ISOOutDrop_Pos            14                                                      /*!< USB GINTSTS: ISOOutDrop Position        */
#define USB_GINTSTS_ISOOutDrop_Msk            (0x01UL << USB_GINTSTS_ISOOutDrop_Pos)                  /*!< USB GINTSTS: ISOOutDrop Mask            */
#define USB_GINTSTS_EOPF_Pos                  15                                                      /*!< USB GINTSTS: EOPF Position              */
#define USB_GINTSTS_EOPF_Msk                  (0x01UL << USB_GINTSTS_EOPF_Pos)                        /*!< USB GINTSTS: EOPF Mask                  */
#define USB_GINTSTS_IEPInt_Pos                18                                                      /*!< USB GINTSTS: IEPInt Position            */
#define USB_GINTSTS_IEPInt_Msk                (0x01UL << USB_GINTSTS_IEPInt_Pos)                      /*!< USB GINTSTS: IEPInt Mask                */
#define USB_GINTSTS_OEPInt_Pos                19                                                      /*!< USB GINTSTS: OEPInt Position            */
#define USB_GINTSTS_OEPInt_Msk                (0x01UL << USB_GINTSTS_OEPInt_Pos)                      /*!< USB GINTSTS: OEPInt Mask                */
#define USB_GINTSTS_incompISOIN_Pos           20                                                      /*!< USB GINTSTS: incompISOIN Position       */
#define USB_GINTSTS_incompISOIN_Msk           (0x01UL << USB_GINTSTS_incompISOIN_Pos)                 /*!< USB GINTSTS: incompISOIN Mask           */
#define USB_GINTSTS_incomplSOOUT_Pos          21                                                      /*!< USB GINTSTS: incomplSOOUT Position      */
#define USB_GINTSTS_incomplSOOUT_Msk          (0x01UL << USB_GINTSTS_incomplSOOUT_Pos)                /*!< USB GINTSTS: incomplSOOUT Mask          */
#define USB_GINTSTS_WkUpInt_Pos               31                                                      /*!< USB GINTSTS: WkUpInt Position           */
#define USB_GINTSTS_WkUpInt_Msk               (0x01UL << USB_GINTSTS_WkUpInt_Pos)                     /*!< USB GINTSTS: WkUpInt Mask               */

/* ---------------------------------  USB_GINTMSK  -------------------------------- */
#define USB_GINTMSK_SofMsk_Pos                3                                                       /*!< USB GINTMSK: SofMsk Position            */
#define USB_GINTMSK_SofMsk_Msk                (0x01UL << USB_GINTMSK_SofMsk_Pos)                      /*!< USB GINTMSK: SofMsk Mask                */
#define USB_GINTMSK_RxFLvlMsk_Pos             4                                                       /*!< USB GINTMSK: RxFLvlMsk Position         */
#define USB_GINTMSK_RxFLvlMsk_Msk             (0x01UL << USB_GINTMSK_RxFLvlMsk_Pos)                   /*!< USB GINTMSK: RxFLvlMsk Mask             */
#define USB_GINTMSK_GINNakEffMsk_Pos          6                                                       /*!< USB GINTMSK: GINNakEffMsk Position      */
#define USB_GINTMSK_GINNakEffMsk_Msk          (0x01UL << USB_GINTMSK_GINNakEffMsk_Pos)                /*!< USB GINTMSK: GINNakEffMsk Mask          */
#define USB_GINTMSK_GOUTNakEffMsk_Pos         7                                                       /*!< USB GINTMSK: GOUTNakEffMsk Position     */
#define USB_GINTMSK_GOUTNakEffMsk_Msk         (0x01UL << USB_GINTMSK_GOUTNakEffMsk_Pos)               /*!< USB GINTMSK: GOUTNakEffMsk Mask         */
#define USB_GINTMSK_ErlySuspMsk_Pos           10                                                      /*!< USB GINTMSK: ErlySuspMsk Position       */
#define USB_GINTMSK_ErlySuspMsk_Msk           (0x01UL << USB_GINTMSK_ErlySuspMsk_Pos)                 /*!< USB GINTMSK: ErlySuspMsk Mask           */
#define USB_GINTMSK_USBSuspMsk_Pos            11                                                      /*!< USB GINTMSK: USBSuspMsk Position        */
#define USB_GINTMSK_USBSuspMsk_Msk            (0x01UL << USB_GINTMSK_USBSuspMsk_Pos)                  /*!< USB GINTMSK: USBSuspMsk Mask            */
#define USB_GINTMSK_USBRstMsk_Pos             12                                                      /*!< USB GINTMSK: USBRstMsk Position         */
#define USB_GINTMSK_USBRstMsk_Msk             (0x01UL << USB_GINTMSK_USBRstMsk_Pos)                   /*!< USB GINTMSK: USBRstMsk Mask             */
#define USB_GINTMSK_EnumDoneMsk_Pos           13                                                      /*!< USB GINTMSK: EnumDoneMsk Position       */
#define USB_GINTMSK_EnumDoneMsk_Msk           (0x01UL << USB_GINTMSK_EnumDoneMsk_Pos)                 /*!< USB GINTMSK: EnumDoneMsk Mask           */
#define USB_GINTMSK_ISOOutDropMsk_Pos         14                                                      /*!< USB GINTMSK: ISOOutDropMsk Position     */
#define USB_GINTMSK_ISOOutDropMsk_Msk         (0x01UL << USB_GINTMSK_ISOOutDropMsk_Pos)               /*!< USB GINTMSK: ISOOutDropMsk Mask         */
#define USB_GINTMSK_EOPFMsk_Pos               15                                                      /*!< USB GINTMSK: EOPFMsk Position           */
#define USB_GINTMSK_EOPFMsk_Msk               (0x01UL << USB_GINTMSK_EOPFMsk_Pos)                     /*!< USB GINTMSK: EOPFMsk Mask               */
#define USB_GINTMSK_IEPIntMsk_Pos             18                                                      /*!< USB GINTMSK: IEPIntMsk Position         */
#define USB_GINTMSK_IEPIntMsk_Msk             (0x01UL << USB_GINTMSK_IEPIntMsk_Pos)                   /*!< USB GINTMSK: IEPIntMsk Mask             */
#define USB_GINTMSK_OEPIntMsk_Pos             19                                                      /*!< USB GINTMSK: OEPIntMsk Position         */
#define USB_GINTMSK_OEPIntMsk_Msk             (0x01UL << USB_GINTMSK_OEPIntMsk_Pos)                   /*!< USB GINTMSK: OEPIntMsk Mask             */
#define USB_GINTMSK_incompISOINMsk_Pos        20                                                      /*!< USB GINTMSK: incompISOINMsk Position    */
#define USB_GINTMSK_incompISOINMsk_Msk        (0x01UL << USB_GINTMSK_incompISOINMsk_Pos)              /*!< USB GINTMSK: incompISOINMsk Mask        */
#define USB_GINTMSK_incomplSOOUTMsk_Pos       21                                                      /*!< USB GINTMSK: incomplSOOUTMsk Position   */
#define USB_GINTMSK_incomplSOOUTMsk_Msk       (0x01UL << USB_GINTMSK_incomplSOOUTMsk_Pos)             /*!< USB GINTMSK: incomplSOOUTMsk Mask       */
#define USB_GINTMSK_WkUpIntMsk_Pos            31                                                      /*!< USB GINTMSK: WkUpIntMsk Position        */
#define USB_GINTMSK_WkUpIntMsk_Msk            (0x01UL << USB_GINTMSK_WkUpIntMsk_Pos)                  /*!< USB GINTMSK: WkUpIntMsk Mask            */

/* ---------------------------------  USB_GRXSTSR  -------------------------------- */
#define USB_GRXSTSR_EPNum_Pos                 0                                                       /*!< USB GRXSTSR: EPNum Position             */
#define USB_GRXSTSR_EPNum_Msk                 (0x0fUL << USB_GRXSTSR_EPNum_Pos)                       /*!< USB GRXSTSR: EPNum Mask                 */
#define USB_GRXSTSR_BCnt_Pos                  4                                                       /*!< USB GRXSTSR: BCnt Position              */
#define USB_GRXSTSR_BCnt_Msk                  (0x000007ffUL << USB_GRXSTSR_BCnt_Pos)                  /*!< USB GRXSTSR: BCnt Mask                  */
#define USB_GRXSTSR_DPID_Pos                  15                                                      /*!< USB GRXSTSR: DPID Position              */
#define USB_GRXSTSR_DPID_Msk                  (0x03UL << USB_GRXSTSR_DPID_Pos)                        /*!< USB GRXSTSR: DPID Mask                  */
#define USB_GRXSTSR_PktSts_Pos                17                                                      /*!< USB GRXSTSR: PktSts Position            */
#define USB_GRXSTSR_PktSts_Msk                (0x0fUL << USB_GRXSTSR_PktSts_Pos)                      /*!< USB GRXSTSR: PktSts Mask                */
#define USB_GRXSTSR_FN_Pos                    21                                                      /*!< USB GRXSTSR: FN Position                */
#define USB_GRXSTSR_FN_Msk                    (0x0fUL << USB_GRXSTSR_FN_Pos)                          /*!< USB GRXSTSR: FN Mask                    */

/* ---------------------------------  USB_GRXSTSP  -------------------------------- */
#define USB_GRXSTSP_EPNum_Pos                 0                                                       /*!< USB GRXSTSP: EPNum Position             */
#define USB_GRXSTSP_EPNum_Msk                 (0x0fUL << USB_GRXSTSP_EPNum_Pos)                       /*!< USB GRXSTSP: EPNum Mask                 */
#define USB_GRXSTSP_BCnt_Pos                  4                                                       /*!< USB GRXSTSP: BCnt Position              */
#define USB_GRXSTSP_BCnt_Msk                  (0x000007ffUL << USB_GRXSTSP_BCnt_Pos)                  /*!< USB GRXSTSP: BCnt Mask                  */
#define USB_GRXSTSP_DPID_Pos                  15                                                      /*!< USB GRXSTSP: DPID Position              */
#define USB_GRXSTSP_DPID_Msk                  (0x03UL << USB_GRXSTSP_DPID_Pos)                        /*!< USB GRXSTSP: DPID Mask                  */
#define USB_GRXSTSP_PktSts_Pos                17                                                      /*!< USB GRXSTSP: PktSts Position            */
#define USB_GRXSTSP_PktSts_Msk                (0x0fUL << USB_GRXSTSP_PktSts_Pos)                      /*!< USB GRXSTSP: PktSts Mask                */
#define USB_GRXSTSP_FN_Pos                    21                                                      /*!< USB GRXSTSP: FN Position                */
#define USB_GRXSTSP_FN_Msk                    (0x0fUL << USB_GRXSTSP_FN_Pos)                          /*!< USB GRXSTSP: FN Mask                    */

/* ---------------------------------  USB_GRXFSIZ  -------------------------------- */
#define USB_GRXFSIZ_RxFDep_Pos                0                                                       /*!< USB GRXFSIZ: RxFDep Position            */
#define USB_GRXFSIZ_RxFDep_Msk                (0x0000ffffUL << USB_GRXFSIZ_RxFDep_Pos)                /*!< USB GRXFSIZ: RxFDep Mask                */

/* --------------------------------  USB_GNPTXFSIZ  ------------------------------- */
#define USB_GNPTXFSIZ_INEPTxF0StAddr_Pos      0                                                       /*!< USB GNPTXFSIZ: INEPTxF0StAddr Position  */
#define USB_GNPTXFSIZ_INEPTxF0StAddr_Msk      (0x0000ffffUL << USB_GNPTXFSIZ_INEPTxF0StAddr_Pos)      /*!< USB GNPTXFSIZ: INEPTxF0StAddr Mask      */
#define USB_GNPTXFSIZ_INEPTxF0Dep_Pos         16                                                      /*!< USB GNPTXFSIZ: INEPTxF0Dep Position     */
#define USB_GNPTXFSIZ_INEPTxF0Dep_Msk         (0x0000ffffUL << USB_GNPTXFSIZ_INEPTxF0Dep_Pos)         /*!< USB GNPTXFSIZ: INEPTxF0Dep Mask         */

/* ----------------------------------  USB_GUID  ---------------------------------- */
#define USB_GUID_MOD_REV_Pos                  0                                                       /*!< USB GUID: MOD_REV Position              */
#define USB_GUID_MOD_REV_Msk                  (0x000000ffUL << USB_GUID_MOD_REV_Pos)                  /*!< USB GUID: MOD_REV Mask                  */
#define USB_GUID_MOD_TYPE_Pos                 8                                                       /*!< USB GUID: MOD_TYPE Position             */
#define USB_GUID_MOD_TYPE_Msk                 (0x000000ffUL << USB_GUID_MOD_TYPE_Pos)                 /*!< USB GUID: MOD_TYPE Mask                 */
#define USB_GUID_MOD_NUMBER_Pos               16                                                      /*!< USB GUID: MOD_NUMBER Position           */
#define USB_GUID_MOD_NUMBER_Msk               (0x0000ffffUL << USB_GUID_MOD_NUMBER_Pos)               /*!< USB GUID: MOD_NUMBER Mask               */

/* --------------------------------  USB_GDFIFOCFG  ------------------------------- */
#define USB_GDFIFOCFG_GDFIFOCfg_Pos           0                                                       /*!< USB GDFIFOCFG: GDFIFOCfg Position       */
#define USB_GDFIFOCFG_GDFIFOCfg_Msk           (0x0000ffffUL << USB_GDFIFOCFG_GDFIFOCfg_Pos)           /*!< USB GDFIFOCFG: GDFIFOCfg Mask           */
#define USB_GDFIFOCFG_EPInfoBaseAddr_Pos      16                                                      /*!< USB GDFIFOCFG: EPInfoBaseAddr Position  */
#define USB_GDFIFOCFG_EPInfoBaseAddr_Msk      (0x0000ffffUL << USB_GDFIFOCFG_EPInfoBaseAddr_Pos)      /*!< USB GDFIFOCFG: EPInfoBaseAddr Mask      */

/* --------------------------------  USB_DIEPTXF1  -------------------------------- */
#define USB_DIEPTXF1_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF1: INEPnTxFStAddr Position   */
#define USB_DIEPTXF1_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF1_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF1: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF1_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF1: INEPnTxFDep Position      */
#define USB_DIEPTXF1_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF1_INEPnTxFDep_Pos)          /*!< USB DIEPTXF1: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF2  -------------------------------- */
#define USB_DIEPTXF2_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF2: INEPnTxFStAddr Position   */
#define USB_DIEPTXF2_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF2_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF2: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF2_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF2: INEPnTxFDep Position      */
#define USB_DIEPTXF2_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF2_INEPnTxFDep_Pos)          /*!< USB DIEPTXF2: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF3  -------------------------------- */
#define USB_DIEPTXF3_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF3: INEPnTxFStAddr Position   */
#define USB_DIEPTXF3_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF3_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF3: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF3_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF3: INEPnTxFDep Position      */
#define USB_DIEPTXF3_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF3_INEPnTxFDep_Pos)          /*!< USB DIEPTXF3: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF4  -------------------------------- */
#define USB_DIEPTXF4_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF4: INEPnTxFStAddr Position   */
#define USB_DIEPTXF4_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF4_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF4: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF4_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF4: INEPnTxFDep Position      */
#define USB_DIEPTXF4_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF4_INEPnTxFDep_Pos)          /*!< USB DIEPTXF4: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF5  -------------------------------- */
#define USB_DIEPTXF5_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF5: INEPnTxFStAddr Position   */
#define USB_DIEPTXF5_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF5_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF5: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF5_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF5: INEPnTxFDep Position      */
#define USB_DIEPTXF5_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF5_INEPnTxFDep_Pos)          /*!< USB DIEPTXF5: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF6  -------------------------------- */
#define USB_DIEPTXF6_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF6: INEPnTxFStAddr Position   */
#define USB_DIEPTXF6_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF6_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF6: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF6_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF6: INEPnTxFDep Position      */
#define USB_DIEPTXF6_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF6_INEPnTxFDep_Pos)          /*!< USB DIEPTXF6: INEPnTxFDep Mask          */

/* ----------------------------------  USB_DCFG  ---------------------------------- */
#define USB_DCFG_DevSpd_Pos                   0                                                       /*!< USB DCFG: DevSpd Position               */
#define USB_DCFG_DevSpd_Msk                   (0x03UL << USB_DCFG_DevSpd_Pos)                         /*!< USB DCFG: DevSpd Mask                   */
#define USB_DCFG_NZStsOUTHShk_Pos             2                                                       /*!< USB DCFG: NZStsOUTHShk Position         */
#define USB_DCFG_NZStsOUTHShk_Msk             (0x01UL << USB_DCFG_NZStsOUTHShk_Pos)                   /*!< USB DCFG: NZStsOUTHShk Mask             */
#define USB_DCFG_DevAddr_Pos                  4                                                       /*!< USB DCFG: DevAddr Position              */
#define USB_DCFG_DevAddr_Msk                  (0x7fUL << USB_DCFG_DevAddr_Pos)                        /*!< USB DCFG: DevAddr Mask                  */
#define USB_DCFG_PerFrInt_Pos                 11                                                      /*!< USB DCFG: PerFrInt Position             */
#define USB_DCFG_PerFrInt_Msk                 (0x03UL << USB_DCFG_PerFrInt_Pos)                       /*!< USB DCFG: PerFrInt Mask                 */
#define USB_DCFG_DescDMA_Pos                  23                                                      /*!< USB DCFG: DescDMA Position              */
#define USB_DCFG_DescDMA_Msk                  (0x01UL << USB_DCFG_DescDMA_Pos)                        /*!< USB DCFG: DescDMA Mask                  */
#define USB_DCFG_PerSchIntvl_Pos              24                                                      /*!< USB DCFG: PerSchIntvl Position          */
#define USB_DCFG_PerSchIntvl_Msk              (0x03UL << USB_DCFG_PerSchIntvl_Pos)                    /*!< USB DCFG: PerSchIntvl Mask              */

/* ----------------------------------  USB_DCTL  ---------------------------------- */
#define USB_DCTL_RmtWkUpSig_Pos               0                                                       /*!< USB DCTL: RmtWkUpSig Position           */
#define USB_DCTL_RmtWkUpSig_Msk               (0x01UL << USB_DCTL_RmtWkUpSig_Pos)                     /*!< USB DCTL: RmtWkUpSig Mask               */
#define USB_DCTL_SftDiscon_Pos                1                                                       /*!< USB DCTL: SftDiscon Position            */
#define USB_DCTL_SftDiscon_Msk                (0x01UL << USB_DCTL_SftDiscon_Pos)                      /*!< USB DCTL: SftDiscon Mask                */
#define USB_DCTL_GNPINNakSts_Pos              2                                                       /*!< USB DCTL: GNPINNakSts Position          */
#define USB_DCTL_GNPINNakSts_Msk              (0x01UL << USB_DCTL_GNPINNakSts_Pos)                    /*!< USB DCTL: GNPINNakSts Mask              */
#define USB_DCTL_GOUTNakSts_Pos               3                                                       /*!< USB DCTL: GOUTNakSts Position           */
#define USB_DCTL_GOUTNakSts_Msk               (0x01UL << USB_DCTL_GOUTNakSts_Pos)                     /*!< USB DCTL: GOUTNakSts Mask               */
#define USB_DCTL_SGNPInNak_Pos                7                                                       /*!< USB DCTL: SGNPInNak Position            */
#define USB_DCTL_SGNPInNak_Msk                (0x01UL << USB_DCTL_SGNPInNak_Pos)                      /*!< USB DCTL: SGNPInNak Mask                */
#define USB_DCTL_CGNPInNak_Pos                8                                                       /*!< USB DCTL: CGNPInNak Position            */
#define USB_DCTL_CGNPInNak_Msk                (0x01UL << USB_DCTL_CGNPInNak_Pos)                      /*!< USB DCTL: CGNPInNak Mask                */
#define USB_DCTL_SGOUTNak_Pos                 9                                                       /*!< USB DCTL: SGOUTNak Position             */
#define USB_DCTL_SGOUTNak_Msk                 (0x01UL << USB_DCTL_SGOUTNak_Pos)                       /*!< USB DCTL: SGOUTNak Mask                 */
#define USB_DCTL_CGOUTNak_Pos                 10                                                      /*!< USB DCTL: CGOUTNak Position             */
#define USB_DCTL_CGOUTNak_Msk                 (0x01UL << USB_DCTL_CGOUTNak_Pos)                       /*!< USB DCTL: CGOUTNak Mask                 */
#define USB_DCTL_GMC_Pos                      13                                                      /*!< USB DCTL: GMC Position                  */
#define USB_DCTL_GMC_Msk                      (0x03UL << USB_DCTL_GMC_Pos)                            /*!< USB DCTL: GMC Mask                      */
#define USB_DCTL_IgnrFrmNum_Pos               15                                                      /*!< USB DCTL: IgnrFrmNum Position           */
#define USB_DCTL_IgnrFrmNum_Msk               (0x01UL << USB_DCTL_IgnrFrmNum_Pos)                     /*!< USB DCTL: IgnrFrmNum Mask               */
#define USB_DCTL_NakOnBble_Pos                16                                                      /*!< USB DCTL: NakOnBble Position            */
#define USB_DCTL_NakOnBble_Msk                (0x01UL << USB_DCTL_NakOnBble_Pos)                      /*!< USB DCTL: NakOnBble Mask                */
#define USB_DCTL_EnContOnBNA_Pos              17                                                      /*!< USB DCTL: EnContOnBNA Position          */
#define USB_DCTL_EnContOnBNA_Msk              (0x01UL << USB_DCTL_EnContOnBNA_Pos)                    /*!< USB DCTL: EnContOnBNA Mask              */

/* ----------------------------------  USB_DSTS  ---------------------------------- */
#define USB_DSTS_SuspSts_Pos                  0                                                       /*!< USB DSTS: SuspSts Position              */
#define USB_DSTS_SuspSts_Msk                  (0x01UL << USB_DSTS_SuspSts_Pos)                        /*!< USB DSTS: SuspSts Mask                  */
#define USB_DSTS_EnumSpd_Pos                  1                                                       /*!< USB DSTS: EnumSpd Position              */
#define USB_DSTS_EnumSpd_Msk                  (0x03UL << USB_DSTS_EnumSpd_Pos)                        /*!< USB DSTS: EnumSpd Mask                  */
#define USB_DSTS_ErrticErr_Pos                3                                                       /*!< USB DSTS: ErrticErr Position            */
#define USB_DSTS_ErrticErr_Msk                (0x01UL << USB_DSTS_ErrticErr_Pos)                      /*!< USB DSTS: ErrticErr Mask                */
#define USB_DSTS_SOFFN_Pos                    8                                                       /*!< USB DSTS: SOFFN Position                */
#define USB_DSTS_SOFFN_Msk                    (0x00003fffUL << USB_DSTS_SOFFN_Pos)                    /*!< USB DSTS: SOFFN Mask                    */

/* ---------------------------------  USB_DIEPMSK  -------------------------------- */
#define USB_DIEPMSK_XferComplMsk_Pos          0                                                       /*!< USB DIEPMSK: XferComplMsk Position      */
#define USB_DIEPMSK_XferComplMsk_Msk          (0x01UL << USB_DIEPMSK_XferComplMsk_Pos)                /*!< USB DIEPMSK: XferComplMsk Mask          */
#define USB_DIEPMSK_EPDisbldMsk_Pos           1                                                       /*!< USB DIEPMSK: EPDisbldMsk Position       */
#define USB_DIEPMSK_EPDisbldMsk_Msk           (0x01UL << USB_DIEPMSK_EPDisbldMsk_Pos)                 /*!< USB DIEPMSK: EPDisbldMsk Mask           */
#define USB_DIEPMSK_AHBErrMsk_Pos             2                                                       /*!< USB DIEPMSK: AHBErrMsk Position         */
#define USB_DIEPMSK_AHBErrMsk_Msk             (0x01UL << USB_DIEPMSK_AHBErrMsk_Pos)                   /*!< USB DIEPMSK: AHBErrMsk Mask             */
#define USB_DIEPMSK_TimeOUTMsk_Pos            3                                                       /*!< USB DIEPMSK: TimeOUTMsk Position        */
#define USB_DIEPMSK_TimeOUTMsk_Msk            (0x01UL << USB_DIEPMSK_TimeOUTMsk_Pos)                  /*!< USB DIEPMSK: TimeOUTMsk Mask            */
#define USB_DIEPMSK_INTknTXFEmpMsk_Pos        4                                                       /*!< USB DIEPMSK: INTknTXFEmpMsk Position    */
#define USB_DIEPMSK_INTknTXFEmpMsk_Msk        (0x01UL << USB_DIEPMSK_INTknTXFEmpMsk_Pos)              /*!< USB DIEPMSK: INTknTXFEmpMsk Mask        */
#define USB_DIEPMSK_INEPNakEffMsk_Pos         6                                                       /*!< USB DIEPMSK: INEPNakEffMsk Position     */
#define USB_DIEPMSK_INEPNakEffMsk_Msk         (0x01UL << USB_DIEPMSK_INEPNakEffMsk_Pos)               /*!< USB DIEPMSK: INEPNakEffMsk Mask         */
#define USB_DIEPMSK_TxfifoUndrnMsk_Pos        8                                                       /*!< USB DIEPMSK: TxfifoUndrnMsk Position    */
#define USB_DIEPMSK_TxfifoUndrnMsk_Msk        (0x01UL << USB_DIEPMSK_TxfifoUndrnMsk_Pos)              /*!< USB DIEPMSK: TxfifoUndrnMsk Mask        */
#define USB_DIEPMSK_BNAInIntrMsk_Pos          9                                                       /*!< USB DIEPMSK: BNAInIntrMsk Position      */
#define USB_DIEPMSK_BNAInIntrMsk_Msk          (0x01UL << USB_DIEPMSK_BNAInIntrMsk_Pos)                /*!< USB DIEPMSK: BNAInIntrMsk Mask          */
#define USB_DIEPMSK_NAKMsk_Pos                13                                                      /*!< USB DIEPMSK: NAKMsk Position            */
#define USB_DIEPMSK_NAKMsk_Msk                (0x01UL << USB_DIEPMSK_NAKMsk_Pos)                      /*!< USB DIEPMSK: NAKMsk Mask                */

/* ---------------------------------  USB_DOEPMSK  -------------------------------- */
#define USB_DOEPMSK_XferComplMsk_Pos          0                                                       /*!< USB DOEPMSK: XferComplMsk Position      */
#define USB_DOEPMSK_XferComplMsk_Msk          (0x01UL << USB_DOEPMSK_XferComplMsk_Pos)                /*!< USB DOEPMSK: XferComplMsk Mask          */
#define USB_DOEPMSK_EPDisbldMsk_Pos           1                                                       /*!< USB DOEPMSK: EPDisbldMsk Position       */
#define USB_DOEPMSK_EPDisbldMsk_Msk           (0x01UL << USB_DOEPMSK_EPDisbldMsk_Pos)                 /*!< USB DOEPMSK: EPDisbldMsk Mask           */
#define USB_DOEPMSK_AHBErrMsk_Pos             2                                                       /*!< USB DOEPMSK: AHBErrMsk Position         */
#define USB_DOEPMSK_AHBErrMsk_Msk             (0x01UL << USB_DOEPMSK_AHBErrMsk_Pos)                   /*!< USB DOEPMSK: AHBErrMsk Mask             */
#define USB_DOEPMSK_SetUPMsk_Pos              3                                                       /*!< USB DOEPMSK: SetUPMsk Position          */
#define USB_DOEPMSK_SetUPMsk_Msk              (0x01UL << USB_DOEPMSK_SetUPMsk_Pos)                    /*!< USB DOEPMSK: SetUPMsk Mask              */
#define USB_DOEPMSK_OUTTknEPdisMsk_Pos        4                                                       /*!< USB DOEPMSK: OUTTknEPdisMsk Position    */
#define USB_DOEPMSK_OUTTknEPdisMsk_Msk        (0x01UL << USB_DOEPMSK_OUTTknEPdisMsk_Pos)              /*!< USB DOEPMSK: OUTTknEPdisMsk Mask        */
#define USB_DOEPMSK_Back2BackSETup_Pos        6                                                       /*!< USB DOEPMSK: Back2BackSETup Position    */
#define USB_DOEPMSK_Back2BackSETup_Msk        (0x01UL << USB_DOEPMSK_Back2BackSETup_Pos)              /*!< USB DOEPMSK: Back2BackSETup Mask        */
#define USB_DOEPMSK_OutPktErrMsk_Pos          8                                                       /*!< USB DOEPMSK: OutPktErrMsk Position      */
#define USB_DOEPMSK_OutPktErrMsk_Msk          (0x01UL << USB_DOEPMSK_OutPktErrMsk_Pos)                /*!< USB DOEPMSK: OutPktErrMsk Mask          */
#define USB_DOEPMSK_BnaOutIntrMsk_Pos         9                                                       /*!< USB DOEPMSK: BnaOutIntrMsk Position     */
#define USB_DOEPMSK_BnaOutIntrMsk_Msk         (0x01UL << USB_DOEPMSK_BnaOutIntrMsk_Pos)               /*!< USB DOEPMSK: BnaOutIntrMsk Mask         */
#define USB_DOEPMSK_BbleErrMsk_Pos            12                                                      /*!< USB DOEPMSK: BbleErrMsk Position        */
#define USB_DOEPMSK_BbleErrMsk_Msk            (0x01UL << USB_DOEPMSK_BbleErrMsk_Pos)                  /*!< USB DOEPMSK: BbleErrMsk Mask            */
#define USB_DOEPMSK_NAKMsk_Pos                13                                                      /*!< USB DOEPMSK: NAKMsk Position            */
#define USB_DOEPMSK_NAKMsk_Msk                (0x01UL << USB_DOEPMSK_NAKMsk_Pos)                      /*!< USB DOEPMSK: NAKMsk Mask                */
#define USB_DOEPMSK_NYETMsk_Pos               14                                                      /*!< USB DOEPMSK: NYETMsk Position           */
#define USB_DOEPMSK_NYETMsk_Msk               (0x01UL << USB_DOEPMSK_NYETMsk_Pos)                     /*!< USB DOEPMSK: NYETMsk Mask               */

/* ----------------------------------  USB_DAINT  --------------------------------- */
#define USB_DAINT_InEpInt_Pos                 0                                                       /*!< USB DAINT: InEpInt Position             */
#define USB_DAINT_InEpInt_Msk                 (0x0000ffffUL << USB_DAINT_InEpInt_Pos)                 /*!< USB DAINT: InEpInt Mask                 */
#define USB_DAINT_OutEPInt_Pos                16                                                      /*!< USB DAINT: OutEPInt Position            */
#define USB_DAINT_OutEPInt_Msk                (0x0000ffffUL << USB_DAINT_OutEPInt_Pos)                /*!< USB DAINT: OutEPInt Mask                */

/* --------------------------------  USB_DAINTMSK  -------------------------------- */
#define USB_DAINTMSK_InEpMsk_Pos              0                                                       /*!< USB DAINTMSK: InEpMsk Position          */
#define USB_DAINTMSK_InEpMsk_Msk              (0x0000ffffUL << USB_DAINTMSK_InEpMsk_Pos)              /*!< USB DAINTMSK: InEpMsk Mask              */
#define USB_DAINTMSK_OutEpMsk_Pos             16                                                      /*!< USB DAINTMSK: OutEpMsk Position         */
#define USB_DAINTMSK_OutEpMsk_Msk             (0x0000ffffUL << USB_DAINTMSK_OutEpMsk_Pos)             /*!< USB DAINTMSK: OutEpMsk Mask             */

/* --------------------------------  USB_DVBUSDIS  -------------------------------- */
#define USB_DVBUSDIS_DVBUSDis_Pos             0                                                       /*!< USB DVBUSDIS: DVBUSDis Position         */
#define USB_DVBUSDIS_DVBUSDis_Msk             (0x0000ffffUL << USB_DVBUSDIS_DVBUSDis_Pos)             /*!< USB DVBUSDIS: DVBUSDis Mask             */

/* -------------------------------  USB_DVBUSPULSE  ------------------------------- */
#define USB_DVBUSPULSE_DVBUSPulse_Pos         0                                                       /*!< USB DVBUSPULSE: DVBUSPulse Position     */
#define USB_DVBUSPULSE_DVBUSPulse_Msk         (0x00000fffUL << USB_DVBUSPULSE_DVBUSPulse_Pos)         /*!< USB DVBUSPULSE: DVBUSPulse Mask         */

/* -------------------------------  USB_DIEPEMPMSK  ------------------------------- */
#define USB_DIEPEMPMSK_InEpTxfEmpMsk_Pos      0                                                       /*!< USB DIEPEMPMSK: InEpTxfEmpMsk Position  */
#define USB_DIEPEMPMSK_InEpTxfEmpMsk_Msk      (0x0000ffffUL << USB_DIEPEMPMSK_InEpTxfEmpMsk_Pos)      /*!< USB DIEPEMPMSK: InEpTxfEmpMsk Mask      */

/* ---------------------------------  USB_PCGCCTL  -------------------------------- */
#define USB_PCGCCTL_StopPclk_Pos              0                                                       /*!< USB PCGCCTL: StopPclk Position          */
#define USB_PCGCCTL_StopPclk_Msk              (0x01UL << USB_PCGCCTL_StopPclk_Pos)                    /*!< USB PCGCCTL: StopPclk Mask              */
#define USB_PCGCCTL_GateHclk_Pos              1                                                       /*!< USB PCGCCTL: GateHclk Position          */
#define USB_PCGCCTL_GateHclk_Msk              (0x01UL << USB_PCGCCTL_GateHclk_Pos)                    /*!< USB PCGCCTL: GateHclk Mask              */


/* ================================================================================ */
/* ================        struct 'USB0_EP0' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  USB_EP_DIEPCTL0  ----------------------------- */
#define USB_EP_DIEPCTL0_MPS_Pos             0                                                       /*!< USB0_EP0 DIEPCTL0: MPS Position         */
#define USB_EP_DIEPCTL0_MPS_Msk             (0x03UL << USB_EP_DIEPCTL0_MPS_Pos)                   /*!< USB0_EP0 DIEPCTL0: MPS Mask             */
#define USB_EP_DIEPCTL0_USBActEP_Pos        15                                                      /*!< USB0_EP0 DIEPCTL0: USBActEP Position    */
#define USB_EP_DIEPCTL0_USBActEP_Msk        (0x01UL << USB_EP_DIEPCTL0_USBActEP_Pos)              /*!< USB0_EP0 DIEPCTL0: USBActEP Mask        */
#define USB_EP_DIEPCTL0_NAKSts_Pos          17                                                      /*!< USB0_EP0 DIEPCTL0: NAKSts Position      */
#define USB_EP_DIEPCTL0_NAKSts_Msk          (0x01UL << USB_EP_DIEPCTL0_NAKSts_Pos)                /*!< USB0_EP0 DIEPCTL0: NAKSts Mask          */
#define USB_EP_DIEPCTL0_EPType_Pos          18                                                      /*!< USB0_EP0 DIEPCTL0: EPType Position      */
#define USB_EP_DIEPCTL0_EPType_Msk          (0x03UL << USB_EP_DIEPCTL0_EPType_Pos)                /*!< USB0_EP0 DIEPCTL0: EPType Mask          */
#define USB_EP_DIEPCTL0_Stall_Pos           21                                                      /*!< USB0_EP0 DIEPCTL0: Stall Position       */
#define USB_EP_DIEPCTL0_Stall_Msk           (0x01UL << USB_EP_DIEPCTL0_Stall_Pos)                 /*!< USB0_EP0 DIEPCTL0: Stall Mask           */
#define USB_EP_DIEPCTL0_TxFNum_Pos          22                                                      /*!< USB0_EP0 DIEPCTL0: TxFNum Position      */
#define USB_EP_DIEPCTL0_TxFNum_Msk          (0x0fUL << USB_EP_DIEPCTL0_TxFNum_Pos)                /*!< USB0_EP0 DIEPCTL0: TxFNum Mask          */
#define USB_EP_DIEPCTL0_CNAK_Pos            26                                                      /*!< USB0_EP0 DIEPCTL0: CNAK Position        */
#define USB_EP_DIEPCTL0_CNAK_Msk            (0x01UL << USB_EP_DIEPCTL0_CNAK_Pos)                  /*!< USB0_EP0 DIEPCTL0: CNAK Mask            */
#define USB_EP_DIEPCTL0_SNAK_Pos            27                                                      /*!< USB0_EP0 DIEPCTL0: SNAK Position        */
#define USB_EP_DIEPCTL0_SNAK_Msk            (0x01UL << USB_EP_DIEPCTL0_SNAK_Pos)                  /*!< USB0_EP0 DIEPCTL0: SNAK Mask            */
#define USB_EP_DIEPCTL0_EPDis_Pos           30                                                      /*!< USB0_EP0 DIEPCTL0: EPDis Position       */
#define USB_EP_DIEPCTL0_EPDis_Msk           (0x01UL << USB_EP_DIEPCTL0_EPDis_Pos)                 /*!< USB0_EP0 DIEPCTL0: EPDis Mask           */
#define USB_EP_DIEPCTL0_EPEna_Pos           31                                                      /*!< USB0_EP0 DIEPCTL0: EPEna Position       */
#define USB_EP_DIEPCTL0_EPEna_Msk           (0x01UL << USB_EP_DIEPCTL0_EPEna_Pos)                 /*!< USB0_EP0 DIEPCTL0: EPEna Mask           */

/* ------------------------------  USB_EP_DIEPINT0  ----------------------------- */
#define USB_EP_DIEPINT0_XferCompl_Pos       0                                                       /*!< USB0_EP0 DIEPINT0: XferCompl Position   */
#define USB_EP_DIEPINT0_XferCompl_Msk       (0x01UL << USB_EP_DIEPINT0_XferCompl_Pos)             /*!< USB0_EP0 DIEPINT0: XferCompl Mask       */
#define USB_EP_DIEPINT0_EPDisbld_Pos        1                                                       /*!< USB0_EP0 DIEPINT0: EPDisbld Position    */
#define USB_EP_DIEPINT0_EPDisbld_Msk        (0x01UL << USB_EP_DIEPINT0_EPDisbld_Pos)              /*!< USB0_EP0 DIEPINT0: EPDisbld Mask        */
#define USB_EP_DIEPINT0_AHBErr_Pos          2                                                       /*!< USB0_EP0 DIEPINT0: AHBErr Position      */
#define USB_EP_DIEPINT0_AHBErr_Msk          (0x01UL << USB_EP_DIEPINT0_AHBErr_Pos)                /*!< USB0_EP0 DIEPINT0: AHBErr Mask          */
#define USB_EP_DIEPINT0_TimeOUT_Pos         3                                                       /*!< USB0_EP0 DIEPINT0: TimeOUT Position     */
#define USB_EP_DIEPINT0_TimeOUT_Msk         (0x01UL << USB_EP_DIEPINT0_TimeOUT_Pos)               /*!< USB0_EP0 DIEPINT0: TimeOUT Mask         */
#define USB_EP_DIEPINT0_INTknTXFEmp_Pos     4                                                       /*!< USB0_EP0 DIEPINT0: INTknTXFEmp Position */
#define USB_EP_DIEPINT0_INTknTXFEmp_Msk     (0x01UL << USB_EP_DIEPINT0_INTknTXFEmp_Pos)           /*!< USB0_EP0 DIEPINT0: INTknTXFEmp Mask     */
#define USB_EP_DIEPINT0_INEPNakEff_Pos      6                                                       /*!< USB0_EP0 DIEPINT0: INEPNakEff Position  */
#define USB_EP_DIEPINT0_INEPNakEff_Msk      (0x01UL << USB_EP_DIEPINT0_INEPNakEff_Pos)            /*!< USB0_EP0 DIEPINT0: INEPNakEff Mask      */
#define USB_EP_DIEPINT0_TxFEmp_Pos          7                                                       /*!< USB0_EP0 DIEPINT0: TxFEmp Position      */
#define USB_EP_DIEPINT0_TxFEmp_Msk          (0x01UL << USB_EP_DIEPINT0_TxFEmp_Pos)                /*!< USB0_EP0 DIEPINT0: TxFEmp Mask          */
#define USB_EP_DIEPINT0_BNAIntr_Pos         9                                                       /*!< USB0_EP0 DIEPINT0: BNAIntr Position     */
#define USB_EP_DIEPINT0_BNAIntr_Msk         (0x01UL << USB_EP_DIEPINT0_BNAIntr_Pos)               /*!< USB0_EP0 DIEPINT0: BNAIntr Mask         */

/* -----------------------------  USB_EP_DIEPTSIZ0  ----------------------------- */
#define USB_EP_DIEPTSIZ0_XferSize_Pos       0                                                       /*!< USB0_EP0 DIEPTSIZ0: XferSize Position   */
#define USB_EP_DIEPTSIZ0_XferSize_Msk       (0x7fUL << USB_EP_DIEPTSIZ0_XferSize_Pos)             /*!< USB0_EP0 DIEPTSIZ0: XferSize Mask       */
#define USB_EP_DIEPTSIZ0_PktCnt_Pos         19                                                      /*!< USB0_EP0 DIEPTSIZ0: PktCnt Position     */
#define USB_EP_DIEPTSIZ0_PktCnt_Msk         (0x03UL << USB_EP_DIEPTSIZ0_PktCnt_Pos)               /*!< USB0_EP0 DIEPTSIZ0: PktCnt Mask         */

/* ------------------------------  USB_EP_DIEPDMA0  ----------------------------- */
#define USB_EP_DIEPDMA0_DMAAddr_Pos         0                                                       /*!< USB0_EP0 DIEPDMA0: DMAAddr Position     */
#define USB_EP_DIEPDMA0_DMAAddr_Msk         (0xffffffffUL << USB_EP_DIEPDMA0_DMAAddr_Pos)         /*!< USB0_EP0 DIEPDMA0: DMAAddr Mask         */

/* ------------------------------  USB_EP_DTXFSTS0  ----------------------------- */
#define USB_EP_DTXFSTS0_INEPTxFSpcAvail_Pos 0                                                       /*!< USB0_EP0 DTXFSTS0: INEPTxFSpcAvail Position */
#define USB_EP_DTXFSTS0_INEPTxFSpcAvail_Msk (0x0000ffffUL << USB_EP_DTXFSTS0_INEPTxFSpcAvail_Pos) /*!< USB0_EP0 DTXFSTS0: INEPTxFSpcAvail Mask */

/* -----------------------------  USB_EP_DIEPDMAB0  ----------------------------- */
#define USB_EP_DIEPDMAB0_DMABufferAddr_Pos  0                                                       /*!< USB0_EP0 DIEPDMAB0: DMABufferAddr Position */
#define USB_EP_DIEPDMAB0_DMABufferAddr_Msk  (0xffffffffUL << USB_EP_DIEPDMAB0_DMABufferAddr_Pos)  /*!< USB0_EP0 DIEPDMAB0: DMABufferAddr Mask  */

/* ------------------------------  USB_EP_DOEPCTL0  ----------------------------- */
#define USB_EP_DOEPCTL0_MPS_Pos             0                                                       /*!< USB0_EP0 DOEPCTL0: MPS Position         */
#define USB_EP_DOEPCTL0_MPS_Msk             (0x03UL << USB_EP_DOEPCTL0_MPS_Pos)                   /*!< USB0_EP0 DOEPCTL0: MPS Mask             */
#define USB_EP_DOEPCTL0_USBActEP_Pos        15                                                      /*!< USB0_EP0 DOEPCTL0: USBActEP Position    */
#define USB_EP_DOEPCTL0_USBActEP_Msk        (0x01UL << USB_EP_DOEPCTL0_USBActEP_Pos)              /*!< USB0_EP0 DOEPCTL0: USBActEP Mask        */
#define USB_EP_DOEPCTL0_NAKSts_Pos          17                                                      /*!< USB0_EP0 DOEPCTL0: NAKSts Position      */
#define USB_EP_DOEPCTL0_NAKSts_Msk          (0x01UL << USB_EP_DOEPCTL0_NAKSts_Pos)                /*!< USB0_EP0 DOEPCTL0: NAKSts Mask          */
#define USB_EP_DOEPCTL0_EPType_Pos          18                                                      /*!< USB0_EP0 DOEPCTL0: EPType Position      */
#define USB_EP_DOEPCTL0_EPType_Msk          (0x03UL << USB_EP_DOEPCTL0_EPType_Pos)                /*!< USB0_EP0 DOEPCTL0: EPType Mask          */
#define USB_EP_DOEPCTL0_Snp_Pos             20                                                      /*!< USB0_EP0 DOEPCTL0: Snp Position         */
#define USB_EP_DOEPCTL0_Snp_Msk             (0x01UL << USB_EP_DOEPCTL0_Snp_Pos)                   /*!< USB0_EP0 DOEPCTL0: Snp Mask             */
#define USB_EP_DOEPCTL0_Stall_Pos           21                                                      /*!< USB0_EP0 DOEPCTL0: Stall Position       */
#define USB_EP_DOEPCTL0_Stall_Msk           (0x01UL << USB_EP_DOEPCTL0_Stall_Pos)                 /*!< USB0_EP0 DOEPCTL0: Stall Mask           */
#define USB_EP_DOEPCTL0_CNAK_Pos            26                                                      /*!< USB0_EP0 DOEPCTL0: CNAK Position        */
#define USB_EP_DOEPCTL0_CNAK_Msk            (0x01UL << USB_EP_DOEPCTL0_CNAK_Pos)                  /*!< USB0_EP0 DOEPCTL0: CNAK Mask            */
#define USB_EP_DOEPCTL0_SNAK_Pos            27                                                      /*!< USB0_EP0 DOEPCTL0: SNAK Position        */
#define USB_EP_DOEPCTL0_SNAK_Msk            (0x01UL << USB_EP_DOEPCTL0_SNAK_Pos)                  /*!< USB0_EP0 DOEPCTL0: SNAK Mask            */
#define USB_EP_DOEPCTL0_EPDis_Pos           30                                                      /*!< USB0_EP0 DOEPCTL0: EPDis Position       */
#define USB_EP_DOEPCTL0_EPDis_Msk           (0x01UL << USB_EP_DOEPCTL0_EPDis_Pos)                 /*!< USB0_EP0 DOEPCTL0: EPDis Mask           */
#define USB_EP_DOEPCTL0_EPEna_Pos           31                                                      /*!< USB0_EP0 DOEPCTL0: EPEna Position       */
#define USB_EP_DOEPCTL0_EPEna_Msk           (0x01UL << USB_EP_DOEPCTL0_EPEna_Pos)                 /*!< USB0_EP0 DOEPCTL0: EPEna Mask           */

/* ------------------------------  USB_EP_DOEPINT0  ----------------------------- */
#define USB_EP_DOEPINT0_XferCompl_Pos       0                                                       /*!< USB0_EP0 DOEPINT0: XferCompl Position   */
#define USB_EP_DOEPINT0_XferCompl_Msk       (0x01UL << USB_EP_DOEPINT0_XferCompl_Pos)             /*!< USB0_EP0 DOEPINT0: XferCompl Mask       */
#define USB_EP_DOEPINT0_EPDisbld_Pos        1                                                       /*!< USB0_EP0 DOEPINT0: EPDisbld Position    */
#define USB_EP_DOEPINT0_EPDisbld_Msk        (0x01UL << USB_EP_DOEPINT0_EPDisbld_Pos)              /*!< USB0_EP0 DOEPINT0: EPDisbld Mask        */
#define USB_EP_DOEPINT0_AHBErr_Pos          2                                                       /*!< USB0_EP0 DOEPINT0: AHBErr Position      */
#define USB_EP_DOEPINT0_AHBErr_Msk          (0x01UL << USB_EP_DOEPINT0_AHBErr_Pos)                /*!< USB0_EP0 DOEPINT0: AHBErr Mask          */
#define USB_EP_DOEPINT0_SetUp_Pos           3                                                       /*!< USB0_EP0 DOEPINT0: SetUp Position       */
#define USB_EP_DOEPINT0_SetUp_Msk           (0x01UL << USB_EP_DOEPINT0_SetUp_Pos)                 /*!< USB0_EP0 DOEPINT0: SetUp Mask           */
#define USB_EP_DOEPINT0_OUTTknEPdis_Pos     4                                                       /*!< USB0_EP0 DOEPINT0: OUTTknEPdis Position */
#define USB_EP_DOEPINT0_OUTTknEPdis_Msk     (0x01UL << USB_EP_DOEPINT0_OUTTknEPdis_Pos)           /*!< USB0_EP0 DOEPINT0: OUTTknEPdis Mask     */
#define USB_EP_DOEPINT0_StsPhseRcvd_Pos     5                                                       /*!< USB0_EP0 DOEPINT0: StsPhseRcvd Position */
#define USB_EP_DOEPINT0_StsPhseRcvd_Msk     (0x01UL << USB_EP_DOEPINT0_StsPhseRcvd_Pos)           /*!< USB0_EP0 DOEPINT0: StsPhseRcvd Mask     */
#define USB_EP_DOEPINT0_Back2BackSETup_Pos  6                                                       /*!< USB0_EP0 DOEPINT0: Back2BackSETup Position */
#define USB_EP_DOEPINT0_Back2BackSETup_Msk  (0x01UL << USB_EP_DOEPINT0_Back2BackSETup_Pos)        /*!< USB0_EP0 DOEPINT0: Back2BackSETup Mask  */
#define USB_EP_DOEPINT0_BNAIntr_Pos         9                                                       /*!< USB0_EP0 DOEPINT0: BNAIntr Position     */
#define USB_EP_DOEPINT0_BNAIntr_Msk         (0x01UL << USB_EP_DOEPINT0_BNAIntr_Pos)               /*!< USB0_EP0 DOEPINT0: BNAIntr Mask         */
#define USB_EP_DOEPINT0_PktDrpSts_Pos       11                                                      /*!< USB0_EP0 DOEPINT0: PktDrpSts Position   */
#define USB_EP_DOEPINT0_PktDrpSts_Msk       (0x01UL << USB_EP_DOEPINT0_PktDrpSts_Pos)             /*!< USB0_EP0 DOEPINT0: PktDrpSts Mask       */
#define USB_EP_DOEPINT0_BbleErrIntrpt_Pos   12                                                      /*!< USB0_EP0 DOEPINT0: BbleErrIntrpt Position */
#define USB_EP_DOEPINT0_BbleErrIntrpt_Msk   (0x01UL << USB_EP_DOEPINT0_BbleErrIntrpt_Pos)         /*!< USB0_EP0 DOEPINT0: BbleErrIntrpt Mask   */
#define USB_EP_DOEPINT0_NAKIntrpt_Pos       13                                                      /*!< USB0_EP0 DOEPINT0: NAKIntrpt Position   */
#define USB_EP_DOEPINT0_NAKIntrpt_Msk       (0x01UL << USB_EP_DOEPINT0_NAKIntrpt_Pos)             /*!< USB0_EP0 DOEPINT0: NAKIntrpt Mask       */
#define USB_EP_DOEPINT0_NYETIntrpt_Pos      14                                                      /*!< USB0_EP0 DOEPINT0: NYETIntrpt Position  */
#define USB_EP_DOEPINT0_NYETIntrpt_Msk      (0x01UL << USB_EP_DOEPINT0_NYETIntrpt_Pos)            /*!< USB0_EP0 DOEPINT0: NYETIntrpt Mask      */

/* -----------------------------  USB_EP_DOEPTSIZ0  ----------------------------- */
#define USB_EP_DOEPTSIZ0_XferSize_Pos       0                                                       /*!< USB0_EP0 DOEPTSIZ0: XferSize Position   */
#define USB_EP_DOEPTSIZ0_XferSize_Msk       (0x7fUL << USB_EP_DOEPTSIZ0_XferSize_Pos)             /*!< USB0_EP0 DOEPTSIZ0: XferSize Mask       */
#define USB_EP_DOEPTSIZ0_PktCnt_Pos         19                                                      /*!< USB0_EP0 DOEPTSIZ0: PktCnt Position     */
#define USB_EP_DOEPTSIZ0_PktCnt_Msk         (0x03UL << USB_EP_DOEPTSIZ0_PktCnt_Pos)               /*!< USB0_EP0 DOEPTSIZ0: PktCnt Mask         */
#define USB_EP_DOEPTSIZ0_SUPCnt_Pos         29                                                      /*!< USB0_EP0 DOEPTSIZ0: SUPCnt Position     */
#define USB_EP_DOEPTSIZ0_SUPCnt_Msk         (0x03UL << USB_EP_DOEPTSIZ0_SUPCnt_Pos)               /*!< USB0_EP0 DOEPTSIZ0: SUPCnt Mask         */

/* ------------------------------  USB_EP_DOEPDMA0  ----------------------------- */
#define USB_EP_DOEPDMA0_DMAAddr_Pos         0                                                       /*!< USB0_EP0 DOEPDMA0: DMAAddr Position     */
#define USB_EP_DOEPDMA0_DMAAddr_Msk         (0xffffffffUL << USB_EP_DOEPDMA0_DMAAddr_Pos)         /*!< USB0_EP0 DOEPDMA0: DMAAddr Mask         */

/* -----------------------------  USB_EP_DOEPDMAB0  ----------------------------- */
#define USB_EP_DOEPDMAB0_DMABufferAddr_Pos  0                                                       /*!< USB0_EP0 DOEPDMAB0: DMABufferAddr Position */
#define USB_EP_DOEPDMAB0_DMABufferAddr_Msk  (0xffffffffUL << USB_EP_DOEPDMAB0_DMABufferAddr_Pos)  /*!< USB0_EP0 DOEPDMAB0: DMABufferAddr Mask  */


/* ================================================================================ */
/* ================         Group 'USB_EP' Position & Mask         ================ */
/* ================================================================================ */


/* ---------------------------  USB_EP_DIEPCTL_ISOCONT  --------------------------- */
#define USB_EP_DIEPCTL_ISOCONT_MPS_Pos        0                                                       /*!< USB_EP DIEPCTL_ISOCONT: MPS Position    */
#define USB_EP_DIEPCTL_ISOCONT_MPS_Msk        (0x000007ffUL << USB_EP_DIEPCTL_ISOCONT_MPS_Pos)        /*!< USB_EP DIEPCTL_ISOCONT: MPS Mask        */
#define USB_EP_DIEPCTL_ISOCONT_USBActEP_Pos   15                                                      /*!< USB_EP DIEPCTL_ISOCONT: USBActEP Position */
#define USB_EP_DIEPCTL_ISOCONT_USBActEP_Msk   (0x01UL << USB_EP_DIEPCTL_ISOCONT_USBActEP_Pos)         /*!< USB_EP DIEPCTL_ISOCONT: USBActEP Mask   */
#define USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Pos   16                                                      /*!< USB_EP DIEPCTL_ISOCONT: EO_FrNum Position */
#define USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Msk   (0x01UL << USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Pos)         /*!< USB_EP DIEPCTL_ISOCONT: EO_FrNum Mask   */
#define USB_EP_DIEPCTL_ISOCONT_NAKSts_Pos     17                                                      /*!< USB_EP DIEPCTL_ISOCONT: NAKSts Position */
#define USB_EP_DIEPCTL_ISOCONT_NAKSts_Msk     (0x01UL << USB_EP_DIEPCTL_ISOCONT_NAKSts_Pos)           /*!< USB_EP DIEPCTL_ISOCONT: NAKSts Mask     */
#define USB_EP_DIEPCTL_ISOCONT_EPType_Pos     18                                                      /*!< USB_EP DIEPCTL_ISOCONT: EPType Position */
#define USB_EP_DIEPCTL_ISOCONT_EPType_Msk     (0x03UL << USB_EP_DIEPCTL_ISOCONT_EPType_Pos)           /*!< USB_EP DIEPCTL_ISOCONT: EPType Mask     */
#define USB_EP_DIEPCTL_ISOCONT_Snp_Pos        20                                                      /*!< USB_EP DIEPCTL_ISOCONT: Snp Position    */
#define USB_EP_DIEPCTL_ISOCONT_Snp_Msk        (0x01UL << USB_EP_DIEPCTL_ISOCONT_Snp_Pos)              /*!< USB_EP DIEPCTL_ISOCONT: Snp Mask        */
#define USB_EP_DIEPCTL_ISOCONT_Stall_Pos      21                                                      /*!< USB_EP DIEPCTL_ISOCONT: Stall Position  */
#define USB_EP_DIEPCTL_ISOCONT_Stall_Msk      (0x01UL << USB_EP_DIEPCTL_ISOCONT_Stall_Pos)            /*!< USB_EP DIEPCTL_ISOCONT: Stall Mask      */
#define USB_EP_DIEPCTL_ISOCONT_TxFNum_Pos     22                                                      /*!< USB_EP DIEPCTL_ISOCONT: TxFNum Position */
#define USB_EP_DIEPCTL_ISOCONT_TxFNum_Msk     (0x0fUL << USB_EP_DIEPCTL_ISOCONT_TxFNum_Pos)           /*!< USB_EP DIEPCTL_ISOCONT: TxFNum Mask     */
#define USB_EP_DIEPCTL_ISOCONT_CNAK_Pos       26                                                      /*!< USB_EP DIEPCTL_ISOCONT: CNAK Position   */
#define USB_EP_DIEPCTL_ISOCONT_CNAK_Msk       (0x01UL << USB_EP_DIEPCTL_ISOCONT_CNAK_Pos)             /*!< USB_EP DIEPCTL_ISOCONT: CNAK Mask       */
#define USB_EP_DIEPCTL_ISOCONT_SNAK_Pos       27                                                      /*!< USB_EP DIEPCTL_ISOCONT: SNAK Position   */
#define USB_EP_DIEPCTL_ISOCONT_SNAK_Msk       (0x01UL << USB_EP_DIEPCTL_ISOCONT_SNAK_Pos)             /*!< USB_EP DIEPCTL_ISOCONT: SNAK Mask       */
#define USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Pos  28                                                      /*!< USB_EP DIEPCTL_ISOCONT: SetEvenFr Position */
#define USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Msk  (0x01UL << USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Pos)        /*!< USB_EP DIEPCTL_ISOCONT: SetEvenFr Mask  */
#define USB_EP_DIEPCTL_ISOCONT_SetOddFr_Pos   29                                                      /*!< USB_EP DIEPCTL_ISOCONT: SetOddFr Position */
#define USB_EP_DIEPCTL_ISOCONT_SetOddFr_Msk   (0x01UL << USB_EP_DIEPCTL_ISOCONT_SetOddFr_Pos)         /*!< USB_EP DIEPCTL_ISOCONT: SetOddFr Mask   */
#define USB_EP_DIEPCTL_ISOCONT_EPDis_Pos      30                                                      /*!< USB_EP DIEPCTL_ISOCONT: EPDis Position  */
#define USB_EP_DIEPCTL_ISOCONT_EPDis_Msk      (0x01UL << USB_EP_DIEPCTL_ISOCONT_EPDis_Pos)            /*!< USB_EP DIEPCTL_ISOCONT: EPDis Mask      */
#define USB_EP_DIEPCTL_ISOCONT_EPEna_Pos      31                                                      /*!< USB_EP DIEPCTL_ISOCONT: EPEna Position  */
#define USB_EP_DIEPCTL_ISOCONT_EPEna_Msk      (0x01UL << USB_EP_DIEPCTL_ISOCONT_EPEna_Pos)            /*!< USB_EP DIEPCTL_ISOCONT: EPEna Mask      */

/* ---------------------------  USB_EP_DIEPCTL_INTBULK  --------------------------- */
#define USB_EP_DIEPCTL_INTBULK_MPS_Pos        0                                                       /*!< USB_EP DIEPCTL_INTBULK: MPS Position    */
#define USB_EP_DIEPCTL_INTBULK_MPS_Msk        (0x000007ffUL << USB_EP_DIEPCTL_INTBULK_MPS_Pos)        /*!< USB_EP DIEPCTL_INTBULK: MPS Mask        */
#define USB_EP_DIEPCTL_INTBULK_USBActEP_Pos   15                                                      /*!< USB_EP DIEPCTL_INTBULK: USBActEP Position */
#define USB_EP_DIEPCTL_INTBULK_USBActEP_Msk   (0x01UL << USB_EP_DIEPCTL_INTBULK_USBActEP_Pos)         /*!< USB_EP DIEPCTL_INTBULK: USBActEP Mask   */
#define USB_EP_DIEPCTL_INTBULK_DPID_Pos       16                                                      /*!< USB_EP DIEPCTL_INTBULK: DPID Position   */
#define USB_EP_DIEPCTL_INTBULK_DPID_Msk       (0x01UL << USB_EP_DIEPCTL_INTBULK_DPID_Pos)             /*!< USB_EP DIEPCTL_INTBULK: DPID Mask       */
#define USB_EP_DIEPCTL_INTBULK_NAKSts_Pos     17                                                      /*!< USB_EP DIEPCTL_INTBULK: NAKSts Position */
#define USB_EP_DIEPCTL_INTBULK_NAKSts_Msk     (0x01UL << USB_EP_DIEPCTL_INTBULK_NAKSts_Pos)           /*!< USB_EP DIEPCTL_INTBULK: NAKSts Mask     */
#define USB_EP_DIEPCTL_INTBULK_EPType_Pos     18                                                      /*!< USB_EP DIEPCTL_INTBULK: EPType Position */
#define USB_EP_DIEPCTL_INTBULK_EPType_Msk     (0x03UL << USB_EP_DIEPCTL_INTBULK_EPType_Pos)           /*!< USB_EP DIEPCTL_INTBULK: EPType Mask     */
#define USB_EP_DIEPCTL_INTBULK_Snp_Pos        20                                                      /*!< USB_EP DIEPCTL_INTBULK: Snp Position    */
#define USB_EP_DIEPCTL_INTBULK_Snp_Msk        (0x01UL << USB_EP_DIEPCTL_INTBULK_Snp_Pos)              /*!< USB_EP DIEPCTL_INTBULK: Snp Mask        */
#define USB_EP_DIEPCTL_INTBULK_Stall_Pos      21                                                      /*!< USB_EP DIEPCTL_INTBULK: Stall Position  */
#define USB_EP_DIEPCTL_INTBULK_Stall_Msk      (0x01UL << USB_EP_DIEPCTL_INTBULK_Stall_Pos)            /*!< USB_EP DIEPCTL_INTBULK: Stall Mask      */
#define USB_EP_DIEPCTL_INTBULK_TxFNum_Pos     22                                                      /*!< USB_EP DIEPCTL_INTBULK: TxFNum Position */
#define USB_EP_DIEPCTL_INTBULK_TxFNum_Msk     (0x0fUL << USB_EP_DIEPCTL_INTBULK_TxFNum_Pos)           /*!< USB_EP DIEPCTL_INTBULK: TxFNum Mask     */
#define USB_EP_DIEPCTL_INTBULK_CNAK_Pos       26                                                      /*!< USB_EP DIEPCTL_INTBULK: CNAK Position   */
#define USB_EP_DIEPCTL_INTBULK_CNAK_Msk       (0x01UL << USB_EP_DIEPCTL_INTBULK_CNAK_Pos)             /*!< USB_EP DIEPCTL_INTBULK: CNAK Mask       */
#define USB_EP_DIEPCTL_INTBULK_SNAK_Pos       27                                                      /*!< USB_EP DIEPCTL_INTBULK: SNAK Position   */
#define USB_EP_DIEPCTL_INTBULK_SNAK_Msk       (0x01UL << USB_EP_DIEPCTL_INTBULK_SNAK_Pos)             /*!< USB_EP DIEPCTL_INTBULK: SNAK Mask       */
#define USB_EP_DIEPCTL_INTBULK_SetD0PID_Pos   28                                                      /*!< USB_EP DIEPCTL_INTBULK: SetD0PID Position */
#define USB_EP_DIEPCTL_INTBULK_SetD0PID_Msk   (0x01UL << USB_EP_DIEPCTL_INTBULK_SetD0PID_Pos)         /*!< USB_EP DIEPCTL_INTBULK: SetD0PID Mask   */
#define USB_EP_DIEPCTL_INTBULK_SetD1PID_Pos   29                                                      /*!< USB_EP DIEPCTL_INTBULK: SetD1PID Position */
#define USB_EP_DIEPCTL_INTBULK_SetD1PID_Msk   (0x01UL << USB_EP_DIEPCTL_INTBULK_SetD1PID_Pos)         /*!< USB_EP DIEPCTL_INTBULK: SetD1PID Mask   */
#define USB_EP_DIEPCTL_INTBULK_EPDis_Pos      30                                                      /*!< USB_EP DIEPCTL_INTBULK: EPDis Position  */
#define USB_EP_DIEPCTL_INTBULK_EPDis_Msk      (0x01UL << USB_EP_DIEPCTL_INTBULK_EPDis_Pos)            /*!< USB_EP DIEPCTL_INTBULK: EPDis Mask      */
#define USB_EP_DIEPCTL_INTBULK_EPEna_Pos      31                                                      /*!< USB_EP DIEPCTL_INTBULK: EPEna Position  */
#define USB_EP_DIEPCTL_INTBULK_EPEna_Msk      (0x01UL << USB_EP_DIEPCTL_INTBULK_EPEna_Pos)            /*!< USB_EP DIEPCTL_INTBULK: EPEna Mask      */

/* -------------------------------  USB_EP_DIEPINT  ------------------------------- */
#define USB_EP_DIEPINT_XferCompl_Pos          0                                                       /*!< USB_EP DIEPINT: XferCompl Position      */
#define USB_EP_DIEPINT_XferCompl_Msk          (0x01UL << USB_EP_DIEPINT_XferCompl_Pos)                /*!< USB_EP DIEPINT: XferCompl Mask          */
#define USB_EP_DIEPINT_EPDisbld_Pos           1                                                       /*!< USB_EP DIEPINT: EPDisbld Position       */
#define USB_EP_DIEPINT_EPDisbld_Msk           (0x01UL << USB_EP_DIEPINT_EPDisbld_Pos)                 /*!< USB_EP DIEPINT: EPDisbld Mask           */
#define USB_EP_DIEPINT_AHBErr_Pos             2                                                       /*!< USB_EP DIEPINT: AHBErr Position         */
#define USB_EP_DIEPINT_AHBErr_Msk             (0x01UL << USB_EP_DIEPINT_AHBErr_Pos)                   /*!< USB_EP DIEPINT: AHBErr Mask             */
#define USB_EP_DIEPINT_TimeOUT_Pos            3                                                       /*!< USB_EP DIEPINT: TimeOUT Position        */
#define USB_EP_DIEPINT_TimeOUT_Msk            (0x01UL << USB_EP_DIEPINT_TimeOUT_Pos)                  /*!< USB_EP DIEPINT: TimeOUT Mask            */
#define USB_EP_DIEPINT_INTknTXFEmp_Pos        4                                                       /*!< USB_EP DIEPINT: INTknTXFEmp Position    */
#define USB_EP_DIEPINT_INTknTXFEmp_Msk        (0x01UL << USB_EP_DIEPINT_INTknTXFEmp_Pos)              /*!< USB_EP DIEPINT: INTknTXFEmp Mask        */
#define USB_EP_DIEPINT_INEPNakEff_Pos         6                                                       /*!< USB_EP DIEPINT: INEPNakEff Position     */
#define USB_EP_DIEPINT_INEPNakEff_Msk         (0x01UL << USB_EP_DIEPINT_INEPNakEff_Pos)               /*!< USB_EP DIEPINT: INEPNakEff Mask         */
#define USB_EP_DIEPINT_TxFEmp_Pos             7                                                       /*!< USB_EP DIEPINT: TxFEmp Position         */
#define USB_EP_DIEPINT_TxFEmp_Msk             (0x01UL << USB_EP_DIEPINT_TxFEmp_Pos)                   /*!< USB_EP DIEPINT: TxFEmp Mask             */
#define USB_EP_DIEPINT_BNAIntr_Pos            9                                                       /*!< USB_EP DIEPINT: BNAIntr Position        */
#define USB_EP_DIEPINT_BNAIntr_Msk            (0x01UL << USB_EP_DIEPINT_BNAIntr_Pos)                  /*!< USB_EP DIEPINT: BNAIntr Mask            */

/* -------------------------------  USB_EP_DIEPTSIZ  ------------------------------ */
#define USB_EP_DIEPTSIZ_XferSize_Pos          0                                                       /*!< USB_EP DIEPTSIZ: XferSize Position      */
#define USB_EP_DIEPTSIZ_XferSize_Msk          (0x0007ffffUL << USB_EP_DIEPTSIZ_XferSize_Pos)          /*!< USB_EP DIEPTSIZ: XferSize Mask          */
#define USB_EP_DIEPTSIZ_PktCnt_Pos            19                                                      /*!< USB_EP DIEPTSIZ: PktCnt Position        */
#define USB_EP_DIEPTSIZ_PktCnt_Msk            (0x000003ffUL << USB_EP_DIEPTSIZ_PktCnt_Pos)            /*!< USB_EP DIEPTSIZ: PktCnt Mask            */

/* -------------------------------  USB_EP_DIEPDMA  ------------------------------- */
#define USB_EP_DIEPDMA_DMAAddr_Pos            0                                                       /*!< USB_EP DIEPDMA: DMAAddr Position        */
#define USB_EP_DIEPDMA_DMAAddr_Msk            (0xffffffffUL << USB_EP_DIEPDMA_DMAAddr_Pos)            /*!< USB_EP DIEPDMA: DMAAddr Mask            */

/* -------------------------------  USB_EP_DTXFSTS  ------------------------------- */
#define USB_EP_DTXFSTS_INEPTxFSpcAvail_Pos    0                                                       /*!< USB_EP DTXFSTS: INEPTxFSpcAvail Position */
#define USB_EP_DTXFSTS_INEPTxFSpcAvail_Msk    (0x0000ffffUL << USB_EP_DTXFSTS_INEPTxFSpcAvail_Pos)    /*!< USB_EP DTXFSTS: INEPTxFSpcAvail Mask    */

/* -------------------------------  USB_EP_DIEPDMAB  ------------------------------ */
#define USB_EP_DIEPDMAB_DMABufferAddr_Pos     0                                                       /*!< USB_EP DIEPDMAB: DMABufferAddr Position */
#define USB_EP_DIEPDMAB_DMABufferAddr_Msk     (0xffffffffUL << USB_EP_DIEPDMAB_DMABufferAddr_Pos)     /*!< USB_EP DIEPDMAB: DMABufferAddr Mask     */

/* ---------------------------  USB_EP_DOEPCTL_ISOCONT  --------------------------- */
#define USB_EP_DOEPCTL_ISOCONT_MPS_Pos        0                                                       /*!< USB_EP DOEPCTL_ISOCONT: MPS Position    */
#define USB_EP_DOEPCTL_ISOCONT_MPS_Msk        (0x000007ffUL << USB_EP_DOEPCTL_ISOCONT_MPS_Pos)        /*!< USB_EP DOEPCTL_ISOCONT: MPS Mask        */
#define USB_EP_DOEPCTL_ISOCONT_USBActEP_Pos   15                                                      /*!< USB_EP DOEPCTL_ISOCONT: USBActEP Position */
#define USB_EP_DOEPCTL_ISOCONT_USBActEP_Msk   (0x01UL << USB_EP_DOEPCTL_ISOCONT_USBActEP_Pos)         /*!< USB_EP DOEPCTL_ISOCONT: USBActEP Mask   */
#define USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Pos   16                                                      /*!< USB_EP DOEPCTL_ISOCONT: EO_FrNum Position */
#define USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Msk   (0x01UL << USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Pos)         /*!< USB_EP DOEPCTL_ISOCONT: EO_FrNum Mask   */
#define USB_EP_DOEPCTL_ISOCONT_NAKSts_Pos     17                                                      /*!< USB_EP DOEPCTL_ISOCONT: NAKSts Position */
#define USB_EP_DOEPCTL_ISOCONT_NAKSts_Msk     (0x01UL << USB_EP_DOEPCTL_ISOCONT_NAKSts_Pos)           /*!< USB_EP DOEPCTL_ISOCONT: NAKSts Mask     */
#define USB_EP_DOEPCTL_ISOCONT_EPType_Pos     18                                                      /*!< USB_EP DOEPCTL_ISOCONT: EPType Position */
#define USB_EP_DOEPCTL_ISOCONT_EPType_Msk     (0x03UL << USB_EP_DOEPCTL_ISOCONT_EPType_Pos)           /*!< USB_EP DOEPCTL_ISOCONT: EPType Mask     */
#define USB_EP_DOEPCTL_ISOCONT_Snp_Pos        20                                                      /*!< USB_EP DOEPCTL_ISOCONT: Snp Position    */
#define USB_EP_DOEPCTL_ISOCONT_Snp_Msk        (0x01UL << USB_EP_DOEPCTL_ISOCONT_Snp_Pos)              /*!< USB_EP DOEPCTL_ISOCONT: Snp Mask        */
#define USB_EP_DOEPCTL_ISOCONT_Stall_Pos      21                                                      /*!< USB_EP DOEPCTL_ISOCONT: Stall Position  */
#define USB_EP_DOEPCTL_ISOCONT_Stall_Msk      (0x01UL << USB_EP_DOEPCTL_ISOCONT_Stall_Pos)            /*!< USB_EP DOEPCTL_ISOCONT: Stall Mask      */
#define USB_EP_DOEPCTL_ISOCONT_TxFNum_Pos     22                                                      /*!< USB_EP DOEPCTL_ISOCONT: TxFNum Position */
#define USB_EP_DOEPCTL_ISOCONT_TxFNum_Msk     (0x0fUL << USB_EP_DOEPCTL_ISOCONT_TxFNum_Pos)           /*!< USB_EP DOEPCTL_ISOCONT: TxFNum Mask     */
#define USB_EP_DOEPCTL_ISOCONT_CNAK_Pos       26                                                      /*!< USB_EP DOEPCTL_ISOCONT: CNAK Position   */
#define USB_EP_DOEPCTL_ISOCONT_CNAK_Msk       (0x01UL << USB_EP_DOEPCTL_ISOCONT_CNAK_Pos)             /*!< USB_EP DOEPCTL_ISOCONT: CNAK Mask       */
#define USB_EP_DOEPCTL_ISOCONT_SNAK_Pos       27                                                      /*!< USB_EP DOEPCTL_ISOCONT: SNAK Position   */
#define USB_EP_DOEPCTL_ISOCONT_SNAK_Msk       (0x01UL << USB_EP_DOEPCTL_ISOCONT_SNAK_Pos)             /*!< USB_EP DOEPCTL_ISOCONT: SNAK Mask       */
#define USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Pos  28                                                      /*!< USB_EP DOEPCTL_ISOCONT: SetEvenFr Position */
#define USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Msk  (0x01UL << USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Pos)        /*!< USB_EP DOEPCTL_ISOCONT: SetEvenFr Mask  */
#define USB_EP_DOEPCTL_ISOCONT_SetOddFr_Pos   29                                                      /*!< USB_EP DOEPCTL_ISOCONT: SetOddFr Position */
#define USB_EP_DOEPCTL_ISOCONT_SetOddFr_Msk   (0x01UL << USB_EP_DOEPCTL_ISOCONT_SetOddFr_Pos)         /*!< USB_EP DOEPCTL_ISOCONT: SetOddFr Mask   */
#define USB_EP_DOEPCTL_ISOCONT_EPDis_Pos      30                                                      /*!< USB_EP DOEPCTL_ISOCONT: EPDis Position  */
#define USB_EP_DOEPCTL_ISOCONT_EPDis_Msk      (0x01UL << USB_EP_DOEPCTL_ISOCONT_EPDis_Pos)            /*!< USB_EP DOEPCTL_ISOCONT: EPDis Mask      */
#define USB_EP_DOEPCTL_ISOCONT_EPEna_Pos      31                                                      /*!< USB_EP DOEPCTL_ISOCONT: EPEna Position  */
#define USB_EP_DOEPCTL_ISOCONT_EPEna_Msk      (0x01UL << USB_EP_DOEPCTL_ISOCONT_EPEna_Pos)            /*!< USB_EP DOEPCTL_ISOCONT: EPEna Mask      */

/* ---------------------------  USB_EP_DOEPCTL_INTBULK  --------------------------- */
#define USB_EP_DOEPCTL_INTBULK_MPS_Pos        0                                                       /*!< USB_EP DOEPCTL_INTBULK: MPS Position    */
#define USB_EP_DOEPCTL_INTBULK_MPS_Msk        (0x000007ffUL << USB_EP_DOEPCTL_INTBULK_MPS_Pos)        /*!< USB_EP DOEPCTL_INTBULK: MPS Mask        */
#define USB_EP_DOEPCTL_INTBULK_USBActEP_Pos   15                                                      /*!< USB_EP DOEPCTL_INTBULK: USBActEP Position */
#define USB_EP_DOEPCTL_INTBULK_USBActEP_Msk   (0x01UL << USB_EP_DOEPCTL_INTBULK_USBActEP_Pos)         /*!< USB_EP DOEPCTL_INTBULK: USBActEP Mask   */
#define USB_EP_DOEPCTL_INTBULK_DPID_Pos       16                                                      /*!< USB_EP DOEPCTL_INTBULK: DPID Position   */
#define USB_EP_DOEPCTL_INTBULK_DPID_Msk       (0x01UL << USB_EP_DOEPCTL_INTBULK_DPID_Pos)             /*!< USB_EP DOEPCTL_INTBULK: DPID Mask       */
#define USB_EP_DOEPCTL_INTBULK_NAKSts_Pos     17                                                      /*!< USB_EP DOEPCTL_INTBULK: NAKSts Position */
#define USB_EP_DOEPCTL_INTBULK_NAKSts_Msk     (0x01UL << USB_EP_DOEPCTL_INTBULK_NAKSts_Pos)           /*!< USB_EP DOEPCTL_INTBULK: NAKSts Mask     */
#define USB_EP_DOEPCTL_INTBULK_EPType_Pos     18                                                      /*!< USB_EP DOEPCTL_INTBULK: EPType Position */
#define USB_EP_DOEPCTL_INTBULK_EPType_Msk     (0x03UL << USB_EP_DOEPCTL_INTBULK_EPType_Pos)           /*!< USB_EP DOEPCTL_INTBULK: EPType Mask     */
#define USB_EP_DOEPCTL_INTBULK_Snp_Pos        20                                                      /*!< USB_EP DOEPCTL_INTBULK: Snp Position    */
#define USB_EP_DOEPCTL_INTBULK_Snp_Msk        (0x01UL << USB_EP_DOEPCTL_INTBULK_Snp_Pos)              /*!< USB_EP DOEPCTL_INTBULK: Snp Mask        */
#define USB_EP_DOEPCTL_INTBULK_Stall_Pos      21                                                      /*!< USB_EP DOEPCTL_INTBULK: Stall Position  */
#define USB_EP_DOEPCTL_INTBULK_Stall_Msk      (0x01UL << USB_EP_DOEPCTL_INTBULK_Stall_Pos)            /*!< USB_EP DOEPCTL_INTBULK: Stall Mask      */
#define USB_EP_DOEPCTL_INTBULK_TxFNum_Pos     22                                                      /*!< USB_EP DOEPCTL_INTBULK: TxFNum Position */
#define USB_EP_DOEPCTL_INTBULK_TxFNum_Msk     (0x0fUL << USB_EP_DOEPCTL_INTBULK_TxFNum_Pos)           /*!< USB_EP DOEPCTL_INTBULK: TxFNum Mask     */
#define USB_EP_DOEPCTL_INTBULK_CNAK_Pos       26                                                      /*!< USB_EP DOEPCTL_INTBULK: CNAK Position   */
#define USB_EP_DOEPCTL_INTBULK_CNAK_Msk       (0x01UL << USB_EP_DOEPCTL_INTBULK_CNAK_Pos)             /*!< USB_EP DOEPCTL_INTBULK: CNAK Mask       */
#define USB_EP_DOEPCTL_INTBULK_SNAK_Pos       27                                                      /*!< USB_EP DOEPCTL_INTBULK: SNAK Position   */
#define USB_EP_DOEPCTL_INTBULK_SNAK_Msk       (0x01UL << USB_EP_DOEPCTL_INTBULK_SNAK_Pos)             /*!< USB_EP DOEPCTL_INTBULK: SNAK Mask       */
#define USB_EP_DOEPCTL_INTBULK_SetD0PID_Pos   28                                                      /*!< USB_EP DOEPCTL_INTBULK: SetD0PID Position */
#define USB_EP_DOEPCTL_INTBULK_SetD0PID_Msk   (0x01UL << USB_EP_DOEPCTL_INTBULK_SetD0PID_Pos)         /*!< USB_EP DOEPCTL_INTBULK: SetD0PID Mask   */
#define USB_EP_DOEPCTL_INTBULK_SetD1PID_Pos   29                                                      /*!< USB_EP DOEPCTL_INTBULK: SetD1PID Position */
#define USB_EP_DOEPCTL_INTBULK_SetD1PID_Msk   (0x01UL << USB_EP_DOEPCTL_INTBULK_SetD1PID_Pos)         /*!< USB_EP DOEPCTL_INTBULK: SetD1PID Mask   */
#define USB_EP_DOEPCTL_INTBULK_EPDis_Pos      30                                                      /*!< USB_EP DOEPCTL_INTBULK: EPDis Position  */
#define USB_EP_DOEPCTL_INTBULK_EPDis_Msk      (0x01UL << USB_EP_DOEPCTL_INTBULK_EPDis_Pos)            /*!< USB_EP DOEPCTL_INTBULK: EPDis Mask      */
#define USB_EP_DOEPCTL_INTBULK_EPEna_Pos      31                                                      /*!< USB_EP DOEPCTL_INTBULK: EPEna Position  */
#define USB_EP_DOEPCTL_INTBULK_EPEna_Msk      (0x01UL << USB_EP_DOEPCTL_INTBULK_EPEna_Pos)            /*!< USB_EP DOEPCTL_INTBULK: EPEna Mask      */

/* -------------------------------  USB_EP_DOEPINT  ------------------------------- */
#define USB_EP_DOEPINT_XferCompl_Pos          0                                                       /*!< USB_EP DOEPINT: XferCompl Position      */
#define USB_EP_DOEPINT_XferCompl_Msk          (0x01UL << USB_EP_DOEPINT_XferCompl_Pos)                /*!< USB_EP DOEPINT: XferCompl Mask          */
#define USB_EP_DOEPINT_EPDisbld_Pos           1                                                       /*!< USB_EP DOEPINT: EPDisbld Position       */
#define USB_EP_DOEPINT_EPDisbld_Msk           (0x01UL << USB_EP_DOEPINT_EPDisbld_Pos)                 /*!< USB_EP DOEPINT: EPDisbld Mask           */
#define USB_EP_DOEPINT_AHBErr_Pos             2                                                       /*!< USB_EP DOEPINT: AHBErr Position         */
#define USB_EP_DOEPINT_AHBErr_Msk             (0x01UL << USB_EP_DOEPINT_AHBErr_Pos)                   /*!< USB_EP DOEPINT: AHBErr Mask             */
#define USB_EP_DOEPINT_SetUp_Pos              3                                                       /*!< USB_EP DOEPINT: SetUp Position          */
#define USB_EP_DOEPINT_SetUp_Msk              (0x01UL << USB_EP_DOEPINT_SetUp_Pos)                    /*!< USB_EP DOEPINT: SetUp Mask              */
#define USB_EP_DOEPINT_OUTTknEPdis_Pos        4                                                       /*!< USB_EP DOEPINT: OUTTknEPdis Position    */
#define USB_EP_DOEPINT_OUTTknEPdis_Msk        (0x01UL << USB_EP_DOEPINT_OUTTknEPdis_Pos)              /*!< USB_EP DOEPINT: OUTTknEPdis Mask        */
#define USB_EP_DOEPINT_StsPhseRcvd_Pos        5                                                       /*!< USB_EP DOEPINT: StsPhseRcvd Position    */
#define USB_EP_DOEPINT_StsPhseRcvd_Msk        (0x01UL << USB_EP_DOEPINT_StsPhseRcvd_Pos)              /*!< USB_EP DOEPINT: StsPhseRcvd Mask        */
#define USB_EP_DOEPINT_Back2BackSETup_Pos     6                                                       /*!< USB_EP DOEPINT: Back2BackSETup Position */
#define USB_EP_DOEPINT_Back2BackSETup_Msk     (0x01UL << USB_EP_DOEPINT_Back2BackSETup_Pos)           /*!< USB_EP DOEPINT: Back2BackSETup Mask     */
#define USB_EP_DOEPINT_BNAIntr_Pos            9                                                       /*!< USB_EP DOEPINT: BNAIntr Position        */
#define USB_EP_DOEPINT_BNAIntr_Msk            (0x01UL << USB_EP_DOEPINT_BNAIntr_Pos)                  /*!< USB_EP DOEPINT: BNAIntr Mask            */
#define USB_EP_DOEPINT_PktDrpSts_Pos          11                                                      /*!< USB_EP DOEPINT: PktDrpSts Position      */
#define USB_EP_DOEPINT_PktDrpSts_Msk          (0x01UL << USB_EP_DOEPINT_PktDrpSts_Pos)                /*!< USB_EP DOEPINT: PktDrpSts Mask          */
#define USB_EP_DOEPINT_BbleErrIntrpt_Pos      12                                                      /*!< USB_EP DOEPINT: BbleErrIntrpt Position  */
#define USB_EP_DOEPINT_BbleErrIntrpt_Msk      (0x01UL << USB_EP_DOEPINT_BbleErrIntrpt_Pos)            /*!< USB_EP DOEPINT: BbleErrIntrpt Mask      */
#define USB_EP_DOEPINT_NAKIntrpt_Pos          13                                                      /*!< USB_EP DOEPINT: NAKIntrpt Position      */
#define USB_EP_DOEPINT_NAKIntrpt_Msk          (0x01UL << USB_EP_DOEPINT_NAKIntrpt_Pos)                /*!< USB_EP DOEPINT: NAKIntrpt Mask          */
#define USB_EP_DOEPINT_NYETIntrpt_Pos         14                                                      /*!< USB_EP DOEPINT: NYETIntrpt Position     */
#define USB_EP_DOEPINT_NYETIntrpt_Msk         (0x01UL << USB_EP_DOEPINT_NYETIntrpt_Pos)               /*!< USB_EP DOEPINT: NYETIntrpt Mask         */

/* -----------------------------  USB_EP_DOEPTSIZ_ISO  ---------------------------- */
#define USB_EP_DOEPTSIZ_ISO_XferSize_Pos      0                                                       /*!< USB_EP DOEPTSIZ_ISO: XferSize Position  */
#define USB_EP_DOEPTSIZ_ISO_XferSize_Msk      (0x0007ffffUL << USB_EP_DOEPTSIZ_ISO_XferSize_Pos)      /*!< USB_EP DOEPTSIZ_ISO: XferSize Mask      */
#define USB_EP_DOEPTSIZ_ISO_PktCnt_Pos        19                                                      /*!< USB_EP DOEPTSIZ_ISO: PktCnt Position    */
#define USB_EP_DOEPTSIZ_ISO_PktCnt_Msk        (0x000003ffUL << USB_EP_DOEPTSIZ_ISO_PktCnt_Pos)        /*!< USB_EP DOEPTSIZ_ISO: PktCnt Mask        */
#define USB_EP_DOEPTSIZ_ISO_RxDPID_Pos        29                                                      /*!< USB_EP DOEPTSIZ_ISO: RxDPID Position    */
#define USB_EP_DOEPTSIZ_ISO_RxDPID_Msk        (0x03UL << USB_EP_DOEPTSIZ_ISO_RxDPID_Pos)              /*!< USB_EP DOEPTSIZ_ISO: RxDPID Mask        */

/* ---------------------------  USB_EP_DOEPTSIZ_CONTROL  -------------------------- */
#define USB_EP_DOEPTSIZ_CONTROL_XferSize_Pos  0                                                       /*!< USB_EP DOEPTSIZ_CONTROL: XferSize Position */
#define USB_EP_DOEPTSIZ_CONTROL_XferSize_Msk  (0x0007ffffUL << USB_EP_DOEPTSIZ_CONTROL_XferSize_Pos)  /*!< USB_EP DOEPTSIZ_CONTROL: XferSize Mask  */
#define USB_EP_DOEPTSIZ_CONTROL_PktCnt_Pos    19                                                      /*!< USB_EP DOEPTSIZ_CONTROL: PktCnt Position */
#define USB_EP_DOEPTSIZ_CONTROL_PktCnt_Msk    (0x000003ffUL << USB_EP_DOEPTSIZ_CONTROL_PktCnt_Pos)    /*!< USB_EP DOEPTSIZ_CONTROL: PktCnt Mask    */
#define USB_EP_DOEPTSIZ_CONTROL_SUPCnt_Pos    29                                                      /*!< USB_EP DOEPTSIZ_CONTROL: SUPCnt Position */
#define USB_EP_DOEPTSIZ_CONTROL_SUPCnt_Msk    (0x03UL << USB_EP_DOEPTSIZ_CONTROL_SUPCnt_Pos)          /*!< USB_EP DOEPTSIZ_CONTROL: SUPCnt Mask    */

/* -------------------------------  USB_EP_DOEPDMA  ------------------------------- */
#define USB_EP_DOEPDMA_DMAAddr_Pos            0                                                       /*!< USB_EP DOEPDMA: DMAAddr Position        */
#define USB_EP_DOEPDMA_DMAAddr_Msk            (0xffffffffUL << USB_EP_DOEPDMA_DMAAddr_Pos)            /*!< USB_EP DOEPDMA: DMAAddr Mask            */

/* -------------------------------  USB_EP_DOEPDMAB  ------------------------------ */
#define USB_EP_DOEPDMAB_DMABufferAddr_Pos     0                                                       /*!< USB_EP DOEPDMAB: DMABufferAddr Position */
#define USB_EP_DOEPDMAB_DMABufferAddr_Msk     (0xffffffffUL << USB_EP_DOEPDMAB_DMABufferAddr_Pos)     /*!< USB_EP DOEPDMAB: DMABufferAddr Mask     */


/* ================================================================================ */
/* ================          Group 'USIC' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  USIC_ID  ---------------------------------- */
#define USIC_ID_MOD_REV_Pos                   0                                                       /*!< USIC ID: MOD_REV Position               */
#define USIC_ID_MOD_REV_Msk                   (0x000000ffUL << USIC_ID_MOD_REV_Pos)                   /*!< USIC ID: MOD_REV Mask                   */
#define USIC_ID_MOD_TYPE_Pos                  8                                                       /*!< USIC ID: MOD_TYPE Position              */
#define USIC_ID_MOD_TYPE_Msk                  (0x000000ffUL << USIC_ID_MOD_TYPE_Pos)                  /*!< USIC ID: MOD_TYPE Mask                  */
#define USIC_ID_MOD_NUMBER_Pos                16                                                      /*!< USIC ID: MOD_NUMBER Position            */
#define USIC_ID_MOD_NUMBER_Msk                (0x0000ffffUL << USIC_ID_MOD_NUMBER_Pos)                /*!< USIC ID: MOD_NUMBER Mask                */


/* ================================================================================ */
/* ================         Group 'USIC_CH' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  USIC_CH_CCFG  -------------------------------- */
#define USIC_CH_CCFG_SSC_Pos                  0                                                       /*!< USIC_CH CCFG: SSC Position              */
#define USIC_CH_CCFG_SSC_Msk                  (0x01UL << USIC_CH_CCFG_SSC_Pos)                        /*!< USIC_CH CCFG: SSC Mask                  */
#define USIC_CH_CCFG_ASC_Pos                  1                                                       /*!< USIC_CH CCFG: ASC Position              */
#define USIC_CH_CCFG_ASC_Msk                  (0x01UL << USIC_CH_CCFG_ASC_Pos)                        /*!< USIC_CH CCFG: ASC Mask                  */
#define USIC_CH_CCFG_IIC_Pos                  2                                                       /*!< USIC_CH CCFG: IIC Position              */
#define USIC_CH_CCFG_IIC_Msk                  (0x01UL << USIC_CH_CCFG_IIC_Pos)                        /*!< USIC_CH CCFG: IIC Mask                  */
#define USIC_CH_CCFG_IIS_Pos                  3                                                       /*!< USIC_CH CCFG: IIS Position              */
#define USIC_CH_CCFG_IIS_Msk                  (0x01UL << USIC_CH_CCFG_IIS_Pos)                        /*!< USIC_CH CCFG: IIS Mask                  */
#define USIC_CH_CCFG_RB_Pos                   6                                                       /*!< USIC_CH CCFG: RB Position               */
#define USIC_CH_CCFG_RB_Msk                   (0x01UL << USIC_CH_CCFG_RB_Pos)                         /*!< USIC_CH CCFG: RB Mask                   */
#define USIC_CH_CCFG_TB_Pos                   7                                                       /*!< USIC_CH CCFG: TB Position               */
#define USIC_CH_CCFG_TB_Msk                   (0x01UL << USIC_CH_CCFG_TB_Pos)                         /*!< USIC_CH CCFG: TB Mask                   */

/* --------------------------------  USIC_CH_KSCFG  ------------------------------- */
#define USIC_CH_KSCFG_MODEN_Pos               0                                                       /*!< USIC_CH KSCFG: MODEN Position           */
#define USIC_CH_KSCFG_MODEN_Msk               (0x01UL << USIC_CH_KSCFG_MODEN_Pos)                     /*!< USIC_CH KSCFG: MODEN Mask               */
#define USIC_CH_KSCFG_BPMODEN_Pos             1                                                       /*!< USIC_CH KSCFG: BPMODEN Position         */
#define USIC_CH_KSCFG_BPMODEN_Msk             (0x01UL << USIC_CH_KSCFG_BPMODEN_Pos)                   /*!< USIC_CH KSCFG: BPMODEN Mask             */
#define USIC_CH_KSCFG_NOMCFG_Pos              4                                                       /*!< USIC_CH KSCFG: NOMCFG Position          */
#define USIC_CH_KSCFG_NOMCFG_Msk              (0x03UL << USIC_CH_KSCFG_NOMCFG_Pos)                    /*!< USIC_CH KSCFG: NOMCFG Mask              */
#define USIC_CH_KSCFG_BPNOM_Pos               7                                                       /*!< USIC_CH KSCFG: BPNOM Position           */
#define USIC_CH_KSCFG_BPNOM_Msk               (0x01UL << USIC_CH_KSCFG_BPNOM_Pos)                     /*!< USIC_CH KSCFG: BPNOM Mask               */
#define USIC_CH_KSCFG_SUMCFG_Pos              8                                                       /*!< USIC_CH KSCFG: SUMCFG Position          */
#define USIC_CH_KSCFG_SUMCFG_Msk              (0x03UL << USIC_CH_KSCFG_SUMCFG_Pos)                    /*!< USIC_CH KSCFG: SUMCFG Mask              */
#define USIC_CH_KSCFG_BPSUM_Pos               11                                                      /*!< USIC_CH KSCFG: BPSUM Position           */
#define USIC_CH_KSCFG_BPSUM_Msk               (0x01UL << USIC_CH_KSCFG_BPSUM_Pos)                     /*!< USIC_CH KSCFG: BPSUM Mask               */

/* ---------------------------------  USIC_CH_FDR  -------------------------------- */
#define USIC_CH_FDR_STEP_Pos                  0                                                       /*!< USIC_CH FDR: STEP Position              */
#define USIC_CH_FDR_STEP_Msk                  (0x000003ffUL << USIC_CH_FDR_STEP_Pos)                  /*!< USIC_CH FDR: STEP Mask                  */
#define USIC_CH_FDR_DM_Pos                    14                                                      /*!< USIC_CH FDR: DM Position                */
#define USIC_CH_FDR_DM_Msk                    (0x03UL << USIC_CH_FDR_DM_Pos)                          /*!< USIC_CH FDR: DM Mask                    */
#define USIC_CH_FDR_RESULT_Pos                16                                                      /*!< USIC_CH FDR: RESULT Position            */
#define USIC_CH_FDR_RESULT_Msk                (0x000003ffUL << USIC_CH_FDR_RESULT_Pos)                /*!< USIC_CH FDR: RESULT Mask                */

/* ---------------------------------  USIC_CH_BRG  -------------------------------- */
#define USIC_CH_BRG_CLKSEL_Pos                0                                                       /*!< USIC_CH BRG: CLKSEL Position            */
#define USIC_CH_BRG_CLKSEL_Msk                (0x03UL << USIC_CH_BRG_CLKSEL_Pos)                      /*!< USIC_CH BRG: CLKSEL Mask                */
#define USIC_CH_BRG_TMEN_Pos                  3                                                       /*!< USIC_CH BRG: TMEN Position              */
#define USIC_CH_BRG_TMEN_Msk                  (0x01UL << USIC_CH_BRG_TMEN_Pos)                        /*!< USIC_CH BRG: TMEN Mask                  */
#define USIC_CH_BRG_PPPEN_Pos                 4                                                       /*!< USIC_CH BRG: PPPEN Position             */
#define USIC_CH_BRG_PPPEN_Msk                 (0x01UL << USIC_CH_BRG_PPPEN_Pos)                       /*!< USIC_CH BRG: PPPEN Mask                 */
#define USIC_CH_BRG_CTQSEL_Pos                6                                                       /*!< USIC_CH BRG: CTQSEL Position            */
#define USIC_CH_BRG_CTQSEL_Msk                (0x03UL << USIC_CH_BRG_CTQSEL_Pos)                      /*!< USIC_CH BRG: CTQSEL Mask                */
#define USIC_CH_BRG_PCTQ_Pos                  8                                                       /*!< USIC_CH BRG: PCTQ Position              */
#define USIC_CH_BRG_PCTQ_Msk                  (0x03UL << USIC_CH_BRG_PCTQ_Pos)                        /*!< USIC_CH BRG: PCTQ Mask                  */
#define USIC_CH_BRG_DCTQ_Pos                  10                                                      /*!< USIC_CH BRG: DCTQ Position              */
#define USIC_CH_BRG_DCTQ_Msk                  (0x1fUL << USIC_CH_BRG_DCTQ_Pos)                        /*!< USIC_CH BRG: DCTQ Mask                  */
#define USIC_CH_BRG_PDIV_Pos                  16                                                      /*!< USIC_CH BRG: PDIV Position              */
#define USIC_CH_BRG_PDIV_Msk                  (0x000003ffUL << USIC_CH_BRG_PDIV_Pos)                  /*!< USIC_CH BRG: PDIV Mask                  */
#define USIC_CH_BRG_SCLKOSEL_Pos              28                                                      /*!< USIC_CH BRG: SCLKOSEL Position          */
#define USIC_CH_BRG_SCLKOSEL_Msk              (0x01UL << USIC_CH_BRG_SCLKOSEL_Pos)                    /*!< USIC_CH BRG: SCLKOSEL Mask              */
#define USIC_CH_BRG_MCLKCFG_Pos               29                                                      /*!< USIC_CH BRG: MCLKCFG Position           */
#define USIC_CH_BRG_MCLKCFG_Msk               (0x01UL << USIC_CH_BRG_MCLKCFG_Pos)                     /*!< USIC_CH BRG: MCLKCFG Mask               */
#define USIC_CH_BRG_SCLKCFG_Pos               30                                                      /*!< USIC_CH BRG: SCLKCFG Position           */
#define USIC_CH_BRG_SCLKCFG_Msk               (0x03UL << USIC_CH_BRG_SCLKCFG_Pos)                     /*!< USIC_CH BRG: SCLKCFG Mask               */

/* --------------------------------  USIC_CH_INPR  -------------------------------- */
#define USIC_CH_INPR_TSINP_Pos                0                                                       /*!< USIC_CH INPR: TSINP Position            */
#define USIC_CH_INPR_TSINP_Msk                (0x07UL << USIC_CH_INPR_TSINP_Pos)                      /*!< USIC_CH INPR: TSINP Mask                */
#define USIC_CH_INPR_TBINP_Pos                4                                                       /*!< USIC_CH INPR: TBINP Position            */
#define USIC_CH_INPR_TBINP_Msk                (0x07UL << USIC_CH_INPR_TBINP_Pos)                      /*!< USIC_CH INPR: TBINP Mask                */
#define USIC_CH_INPR_RINP_Pos                 8                                                       /*!< USIC_CH INPR: RINP Position             */
#define USIC_CH_INPR_RINP_Msk                 (0x07UL << USIC_CH_INPR_RINP_Pos)                       /*!< USIC_CH INPR: RINP Mask                 */
#define USIC_CH_INPR_AINP_Pos                 12                                                      /*!< USIC_CH INPR: AINP Position             */
#define USIC_CH_INPR_AINP_Msk                 (0x07UL << USIC_CH_INPR_AINP_Pos)                       /*!< USIC_CH INPR: AINP Mask                 */
#define USIC_CH_INPR_PINP_Pos                 16                                                      /*!< USIC_CH INPR: PINP Position             */
#define USIC_CH_INPR_PINP_Msk                 (0x07UL << USIC_CH_INPR_PINP_Pos)                       /*!< USIC_CH INPR: PINP Mask                 */

/* --------------------------------  USIC_CH_DX0CR  ------------------------------- */
#define USIC_CH_DX0CR_DSEL_Pos                0                                                       /*!< USIC_CH DX0CR: DSEL Position            */
#define USIC_CH_DX0CR_DSEL_Msk                (0x07UL << USIC_CH_DX0CR_DSEL_Pos)                      /*!< USIC_CH DX0CR: DSEL Mask                */
#define USIC_CH_DX0CR_INSW_Pos                4                                                       /*!< USIC_CH DX0CR: INSW Position            */
#define USIC_CH_DX0CR_INSW_Msk                (0x01UL << USIC_CH_DX0CR_INSW_Pos)                      /*!< USIC_CH DX0CR: INSW Mask                */
#define USIC_CH_DX0CR_DFEN_Pos                5                                                       /*!< USIC_CH DX0CR: DFEN Position            */
#define USIC_CH_DX0CR_DFEN_Msk                (0x01UL << USIC_CH_DX0CR_DFEN_Pos)                      /*!< USIC_CH DX0CR: DFEN Mask                */
#define USIC_CH_DX0CR_DSEN_Pos                6                                                       /*!< USIC_CH DX0CR: DSEN Position            */
#define USIC_CH_DX0CR_DSEN_Msk                (0x01UL << USIC_CH_DX0CR_DSEN_Pos)                      /*!< USIC_CH DX0CR: DSEN Mask                */
#define USIC_CH_DX0CR_DPOL_Pos                8                                                       /*!< USIC_CH DX0CR: DPOL Position            */
#define USIC_CH_DX0CR_DPOL_Msk                (0x01UL << USIC_CH_DX0CR_DPOL_Pos)                      /*!< USIC_CH DX0CR: DPOL Mask                */
#define USIC_CH_DX0CR_SFSEL_Pos               9                                                       /*!< USIC_CH DX0CR: SFSEL Position           */
#define USIC_CH_DX0CR_SFSEL_Msk               (0x01UL << USIC_CH_DX0CR_SFSEL_Pos)                     /*!< USIC_CH DX0CR: SFSEL Mask               */
#define USIC_CH_DX0CR_CM_Pos                  10                                                      /*!< USIC_CH DX0CR: CM Position              */
#define USIC_CH_DX0CR_CM_Msk                  (0x03UL << USIC_CH_DX0CR_CM_Pos)                        /*!< USIC_CH DX0CR: CM Mask                  */
#define USIC_CH_DX0CR_DXS_Pos                 15                                                      /*!< USIC_CH DX0CR: DXS Position             */
#define USIC_CH_DX0CR_DXS_Msk                 (0x01UL << USIC_CH_DX0CR_DXS_Pos)                       /*!< USIC_CH DX0CR: DXS Mask                 */

/* --------------------------------  USIC_CH_DX1CR  ------------------------------- */
#define USIC_CH_DX1CR_DSEL_Pos                0                                                       /*!< USIC_CH DX1CR: DSEL Position            */
#define USIC_CH_DX1CR_DSEL_Msk                (0x07UL << USIC_CH_DX1CR_DSEL_Pos)                      /*!< USIC_CH DX1CR: DSEL Mask                */
#define USIC_CH_DX1CR_DCEN_Pos                3                                                       /*!< USIC_CH DX1CR: DCEN Position            */
#define USIC_CH_DX1CR_DCEN_Msk                (0x01UL << USIC_CH_DX1CR_DCEN_Pos)                      /*!< USIC_CH DX1CR: DCEN Mask                */
#define USIC_CH_DX1CR_INSW_Pos                4                                                       /*!< USIC_CH DX1CR: INSW Position            */
#define USIC_CH_DX1CR_INSW_Msk                (0x01UL << USIC_CH_DX1CR_INSW_Pos)                      /*!< USIC_CH DX1CR: INSW Mask                */
#define USIC_CH_DX1CR_DFEN_Pos                5                                                       /*!< USIC_CH DX1CR: DFEN Position            */
#define USIC_CH_DX1CR_DFEN_Msk                (0x01UL << USIC_CH_DX1CR_DFEN_Pos)                      /*!< USIC_CH DX1CR: DFEN Mask                */
#define USIC_CH_DX1CR_DSEN_Pos                6                                                       /*!< USIC_CH DX1CR: DSEN Position            */
#define USIC_CH_DX1CR_DSEN_Msk                (0x01UL << USIC_CH_DX1CR_DSEN_Pos)                      /*!< USIC_CH DX1CR: DSEN Mask                */
#define USIC_CH_DX1CR_DPOL_Pos                8                                                       /*!< USIC_CH DX1CR: DPOL Position            */
#define USIC_CH_DX1CR_DPOL_Msk                (0x01UL << USIC_CH_DX1CR_DPOL_Pos)                      /*!< USIC_CH DX1CR: DPOL Mask                */
#define USIC_CH_DX1CR_SFSEL_Pos               9                                                       /*!< USIC_CH DX1CR: SFSEL Position           */
#define USIC_CH_DX1CR_SFSEL_Msk               (0x01UL << USIC_CH_DX1CR_SFSEL_Pos)                     /*!< USIC_CH DX1CR: SFSEL Mask               */
#define USIC_CH_DX1CR_CM_Pos                  10                                                      /*!< USIC_CH DX1CR: CM Position              */
#define USIC_CH_DX1CR_CM_Msk                  (0x03UL << USIC_CH_DX1CR_CM_Pos)                        /*!< USIC_CH DX1CR: CM Mask                  */
#define USIC_CH_DX1CR_DXS_Pos                 15                                                      /*!< USIC_CH DX1CR: DXS Position             */
#define USIC_CH_DX1CR_DXS_Msk                 (0x01UL << USIC_CH_DX1CR_DXS_Pos)                       /*!< USIC_CH DX1CR: DXS Mask                 */

/* --------------------------------  USIC_CH_DX2CR  ------------------------------- */
#define USIC_CH_DX2CR_DSEL_Pos                0                                                       /*!< USIC_CH DX2CR: DSEL Position            */
#define USIC_CH_DX2CR_DSEL_Msk                (0x07UL << USIC_CH_DX2CR_DSEL_Pos)                      /*!< USIC_CH DX2CR: DSEL Mask                */
#define USIC_CH_DX2CR_INSW_Pos                4                                                       /*!< USIC_CH DX2CR: INSW Position            */
#define USIC_CH_DX2CR_INSW_Msk                (0x01UL << USIC_CH_DX2CR_INSW_Pos)                      /*!< USIC_CH DX2CR: INSW Mask                */
#define USIC_CH_DX2CR_DFEN_Pos                5                                                       /*!< USIC_CH DX2CR: DFEN Position            */
#define USIC_CH_DX2CR_DFEN_Msk                (0x01UL << USIC_CH_DX2CR_DFEN_Pos)                      /*!< USIC_CH DX2CR: DFEN Mask                */
#define USIC_CH_DX2CR_DSEN_Pos                6                                                       /*!< USIC_CH DX2CR: DSEN Position            */
#define USIC_CH_DX2CR_DSEN_Msk                (0x01UL << USIC_CH_DX2CR_DSEN_Pos)                      /*!< USIC_CH DX2CR: DSEN Mask                */
#define USIC_CH_DX2CR_DPOL_Pos                8                                                       /*!< USIC_CH DX2CR: DPOL Position            */
#define USIC_CH_DX2CR_DPOL_Msk                (0x01UL << USIC_CH_DX2CR_DPOL_Pos)                      /*!< USIC_CH DX2CR: DPOL Mask                */
#define USIC_CH_DX2CR_SFSEL_Pos               9                                                       /*!< USIC_CH DX2CR: SFSEL Position           */
#define USIC_CH_DX2CR_SFSEL_Msk               (0x01UL << USIC_CH_DX2CR_SFSEL_Pos)                     /*!< USIC_CH DX2CR: SFSEL Mask               */
#define USIC_CH_DX2CR_CM_Pos                  10                                                      /*!< USIC_CH DX2CR: CM Position              */
#define USIC_CH_DX2CR_CM_Msk                  (0x03UL << USIC_CH_DX2CR_CM_Pos)                        /*!< USIC_CH DX2CR: CM Mask                  */
#define USIC_CH_DX2CR_DXS_Pos                 15                                                      /*!< USIC_CH DX2CR: DXS Position             */
#define USIC_CH_DX2CR_DXS_Msk                 (0x01UL << USIC_CH_DX2CR_DXS_Pos)                       /*!< USIC_CH DX2CR: DXS Mask                 */

/* --------------------------------  USIC_CH_DX3CR  ------------------------------- */
#define USIC_CH_DX3CR_DSEL_Pos                0                                                       /*!< USIC_CH DX3CR: DSEL Position            */
#define USIC_CH_DX3CR_DSEL_Msk                (0x07UL << USIC_CH_DX3CR_DSEL_Pos)                      /*!< USIC_CH DX3CR: DSEL Mask                */
#define USIC_CH_DX3CR_INSW_Pos                4                                                       /*!< USIC_CH DX3CR: INSW Position            */
#define USIC_CH_DX3CR_INSW_Msk                (0x01UL << USIC_CH_DX3CR_INSW_Pos)                      /*!< USIC_CH DX3CR: INSW Mask                */
#define USIC_CH_DX3CR_DFEN_Pos                5                                                       /*!< USIC_CH DX3CR: DFEN Position            */
#define USIC_CH_DX3CR_DFEN_Msk                (0x01UL << USIC_CH_DX3CR_DFEN_Pos)                      /*!< USIC_CH DX3CR: DFEN Mask                */
#define USIC_CH_DX3CR_DSEN_Pos                6                                                       /*!< USIC_CH DX3CR: DSEN Position            */
#define USIC_CH_DX3CR_DSEN_Msk                (0x01UL << USIC_CH_DX3CR_DSEN_Pos)                      /*!< USIC_CH DX3CR: DSEN Mask                */
#define USIC_CH_DX3CR_DPOL_Pos                8                                                       /*!< USIC_CH DX3CR: DPOL Position            */
#define USIC_CH_DX3CR_DPOL_Msk                (0x01UL << USIC_CH_DX3CR_DPOL_Pos)                      /*!< USIC_CH DX3CR: DPOL Mask                */
#define USIC_CH_DX3CR_SFSEL_Pos               9                                                       /*!< USIC_CH DX3CR: SFSEL Position           */
#define USIC_CH_DX3CR_SFSEL_Msk               (0x01UL << USIC_CH_DX3CR_SFSEL_Pos)                     /*!< USIC_CH DX3CR: SFSEL Mask               */
#define USIC_CH_DX3CR_CM_Pos                  10                                                      /*!< USIC_CH DX3CR: CM Position              */
#define USIC_CH_DX3CR_CM_Msk                  (0x03UL << USIC_CH_DX3CR_CM_Pos)                        /*!< USIC_CH DX3CR: CM Mask                  */
#define USIC_CH_DX3CR_DXS_Pos                 15                                                      /*!< USIC_CH DX3CR: DXS Position             */
#define USIC_CH_DX3CR_DXS_Msk                 (0x01UL << USIC_CH_DX3CR_DXS_Pos)                       /*!< USIC_CH DX3CR: DXS Mask                 */

/* --------------------------------  USIC_CH_DX4CR  ------------------------------- */
#define USIC_CH_DX4CR_DSEL_Pos                0                                                       /*!< USIC_CH DX4CR: DSEL Position            */
#define USIC_CH_DX4CR_DSEL_Msk                (0x07UL << USIC_CH_DX4CR_DSEL_Pos)                      /*!< USIC_CH DX4CR: DSEL Mask                */
#define USIC_CH_DX4CR_INSW_Pos                4                                                       /*!< USIC_CH DX4CR: INSW Position            */
#define USIC_CH_DX4CR_INSW_Msk                (0x01UL << USIC_CH_DX4CR_INSW_Pos)                      /*!< USIC_CH DX4CR: INSW Mask                */
#define USIC_CH_DX4CR_DFEN_Pos                5                                                       /*!< USIC_CH DX4CR: DFEN Position            */
#define USIC_CH_DX4CR_DFEN_Msk                (0x01UL << USIC_CH_DX4CR_DFEN_Pos)                      /*!< USIC_CH DX4CR: DFEN Mask                */
#define USIC_CH_DX4CR_DSEN_Pos                6                                                       /*!< USIC_CH DX4CR: DSEN Position            */
#define USIC_CH_DX4CR_DSEN_Msk                (0x01UL << USIC_CH_DX4CR_DSEN_Pos)                      /*!< USIC_CH DX4CR: DSEN Mask                */
#define USIC_CH_DX4CR_DPOL_Pos                8                                                       /*!< USIC_CH DX4CR: DPOL Position            */
#define USIC_CH_DX4CR_DPOL_Msk                (0x01UL << USIC_CH_DX4CR_DPOL_Pos)                      /*!< USIC_CH DX4CR: DPOL Mask                */
#define USIC_CH_DX4CR_SFSEL_Pos               9                                                       /*!< USIC_CH DX4CR: SFSEL Position           */
#define USIC_CH_DX4CR_SFSEL_Msk               (0x01UL << USIC_CH_DX4CR_SFSEL_Pos)                     /*!< USIC_CH DX4CR: SFSEL Mask               */
#define USIC_CH_DX4CR_CM_Pos                  10                                                      /*!< USIC_CH DX4CR: CM Position              */
#define USIC_CH_DX4CR_CM_Msk                  (0x03UL << USIC_CH_DX4CR_CM_Pos)                        /*!< USIC_CH DX4CR: CM Mask                  */
#define USIC_CH_DX4CR_DXS_Pos                 15                                                      /*!< USIC_CH DX4CR: DXS Position             */
#define USIC_CH_DX4CR_DXS_Msk                 (0x01UL << USIC_CH_DX4CR_DXS_Pos)                       /*!< USIC_CH DX4CR: DXS Mask                 */

/* --------------------------------  USIC_CH_DX5CR  ------------------------------- */
#define USIC_CH_DX5CR_DSEL_Pos                0                                                       /*!< USIC_CH DX5CR: DSEL Position            */
#define USIC_CH_DX5CR_DSEL_Msk                (0x07UL << USIC_CH_DX5CR_DSEL_Pos)                      /*!< USIC_CH DX5CR: DSEL Mask                */
#define USIC_CH_DX5CR_INSW_Pos                4                                                       /*!< USIC_CH DX5CR: INSW Position            */
#define USIC_CH_DX5CR_INSW_Msk                (0x01UL << USIC_CH_DX5CR_INSW_Pos)                      /*!< USIC_CH DX5CR: INSW Mask                */
#define USIC_CH_DX5CR_DFEN_Pos                5                                                       /*!< USIC_CH DX5CR: DFEN Position            */
#define USIC_CH_DX5CR_DFEN_Msk                (0x01UL << USIC_CH_DX5CR_DFEN_Pos)                      /*!< USIC_CH DX5CR: DFEN Mask                */
#define USIC_CH_DX5CR_DSEN_Pos                6                                                       /*!< USIC_CH DX5CR: DSEN Position            */
#define USIC_CH_DX5CR_DSEN_Msk                (0x01UL << USIC_CH_DX5CR_DSEN_Pos)                      /*!< USIC_CH DX5CR: DSEN Mask                */
#define USIC_CH_DX5CR_DPOL_Pos                8                                                       /*!< USIC_CH DX5CR: DPOL Position            */
#define USIC_CH_DX5CR_DPOL_Msk                (0x01UL << USIC_CH_DX5CR_DPOL_Pos)                      /*!< USIC_CH DX5CR: DPOL Mask                */
#define USIC_CH_DX5CR_SFSEL_Pos               9                                                       /*!< USIC_CH DX5CR: SFSEL Position           */
#define USIC_CH_DX5CR_SFSEL_Msk               (0x01UL << USIC_CH_DX5CR_SFSEL_Pos)                     /*!< USIC_CH DX5CR: SFSEL Mask               */
#define USIC_CH_DX5CR_CM_Pos                  10                                                      /*!< USIC_CH DX5CR: CM Position              */
#define USIC_CH_DX5CR_CM_Msk                  (0x03UL << USIC_CH_DX5CR_CM_Pos)                        /*!< USIC_CH DX5CR: CM Mask                  */
#define USIC_CH_DX5CR_DXS_Pos                 15                                                      /*!< USIC_CH DX5CR: DXS Position             */
#define USIC_CH_DX5CR_DXS_Msk                 (0x01UL << USIC_CH_DX5CR_DXS_Pos)                       /*!< USIC_CH DX5CR: DXS Mask                 */

/* --------------------------------  USIC_CH_SCTR  -------------------------------- */
#define USIC_CH_SCTR_SDIR_Pos                 0                                                       /*!< USIC_CH SCTR: SDIR Position             */
#define USIC_CH_SCTR_SDIR_Msk                 (0x01UL << USIC_CH_SCTR_SDIR_Pos)                       /*!< USIC_CH SCTR: SDIR Mask                 */
#define USIC_CH_SCTR_PDL_Pos                  1                                                       /*!< USIC_CH SCTR: PDL Position              */
#define USIC_CH_SCTR_PDL_Msk                  (0x01UL << USIC_CH_SCTR_PDL_Pos)                        /*!< USIC_CH SCTR: PDL Mask                  */
#define USIC_CH_SCTR_DSM_Pos                  2                                                       /*!< USIC_CH SCTR: DSM Position              */
#define USIC_CH_SCTR_DSM_Msk                  (0x03UL << USIC_CH_SCTR_DSM_Pos)                        /*!< USIC_CH SCTR: DSM Mask                  */
#define USIC_CH_SCTR_HPCDIR_Pos               4                                                       /*!< USIC_CH SCTR: HPCDIR Position           */
#define USIC_CH_SCTR_HPCDIR_Msk               (0x01UL << USIC_CH_SCTR_HPCDIR_Pos)                     /*!< USIC_CH SCTR: HPCDIR Mask               */
#define USIC_CH_SCTR_DOCFG_Pos                6                                                       /*!< USIC_CH SCTR: DOCFG Position            */
#define USIC_CH_SCTR_DOCFG_Msk                (0x03UL << USIC_CH_SCTR_DOCFG_Pos)                      /*!< USIC_CH SCTR: DOCFG Mask                */
#define USIC_CH_SCTR_TRM_Pos                  8                                                       /*!< USIC_CH SCTR: TRM Position              */
#define USIC_CH_SCTR_TRM_Msk                  (0x03UL << USIC_CH_SCTR_TRM_Pos)                        /*!< USIC_CH SCTR: TRM Mask                  */
#define USIC_CH_SCTR_FLE_Pos                  16                                                      /*!< USIC_CH SCTR: FLE Position              */
#define USIC_CH_SCTR_FLE_Msk                  (0x3fUL << USIC_CH_SCTR_FLE_Pos)                        /*!< USIC_CH SCTR: FLE Mask                  */
#define USIC_CH_SCTR_WLE_Pos                  24                                                      /*!< USIC_CH SCTR: WLE Position              */
#define USIC_CH_SCTR_WLE_Msk                  (0x0fUL << USIC_CH_SCTR_WLE_Pos)                        /*!< USIC_CH SCTR: WLE Mask                  */

/* --------------------------------  USIC_CH_TCSR  -------------------------------- */
#define USIC_CH_TCSR_WLEMD_Pos                0                                                       /*!< USIC_CH TCSR: WLEMD Position            */
#define USIC_CH_TCSR_WLEMD_Msk                (0x01UL << USIC_CH_TCSR_WLEMD_Pos)                      /*!< USIC_CH TCSR: WLEMD Mask                */
#define USIC_CH_TCSR_SELMD_Pos                1                                                       /*!< USIC_CH TCSR: SELMD Position            */
#define USIC_CH_TCSR_SELMD_Msk                (0x01UL << USIC_CH_TCSR_SELMD_Pos)                      /*!< USIC_CH TCSR: SELMD Mask                */
#define USIC_CH_TCSR_FLEMD_Pos                2                                                       /*!< USIC_CH TCSR: FLEMD Position            */
#define USIC_CH_TCSR_FLEMD_Msk                (0x01UL << USIC_CH_TCSR_FLEMD_Pos)                      /*!< USIC_CH TCSR: FLEMD Mask                */
#define USIC_CH_TCSR_WAMD_Pos                 3                                                       /*!< USIC_CH TCSR: WAMD Position             */
#define USIC_CH_TCSR_WAMD_Msk                 (0x01UL << USIC_CH_TCSR_WAMD_Pos)                       /*!< USIC_CH TCSR: WAMD Mask                 */
#define USIC_CH_TCSR_HPCMD_Pos                4                                                       /*!< USIC_CH TCSR: HPCMD Position            */
#define USIC_CH_TCSR_HPCMD_Msk                (0x01UL << USIC_CH_TCSR_HPCMD_Pos)                      /*!< USIC_CH TCSR: HPCMD Mask                */
#define USIC_CH_TCSR_SOF_Pos                  5                                                       /*!< USIC_CH TCSR: SOF Position              */
#define USIC_CH_TCSR_SOF_Msk                  (0x01UL << USIC_CH_TCSR_SOF_Pos)                        /*!< USIC_CH TCSR: SOF Mask                  */
#define USIC_CH_TCSR_EOF_Pos                  6                                                       /*!< USIC_CH TCSR: EOF Position              */
#define USIC_CH_TCSR_EOF_Msk                  (0x01UL << USIC_CH_TCSR_EOF_Pos)                        /*!< USIC_CH TCSR: EOF Mask                  */
#define USIC_CH_TCSR_TDV_Pos                  7                                                       /*!< USIC_CH TCSR: TDV Position              */
#define USIC_CH_TCSR_TDV_Msk                  (0x01UL << USIC_CH_TCSR_TDV_Pos)                        /*!< USIC_CH TCSR: TDV Mask                  */
#define USIC_CH_TCSR_TDSSM_Pos                8                                                       /*!< USIC_CH TCSR: TDSSM Position            */
#define USIC_CH_TCSR_TDSSM_Msk                (0x01UL << USIC_CH_TCSR_TDSSM_Pos)                      /*!< USIC_CH TCSR: TDSSM Mask                */
#define USIC_CH_TCSR_TDEN_Pos                 10                                                      /*!< USIC_CH TCSR: TDEN Position             */
#define USIC_CH_TCSR_TDEN_Msk                 (0x03UL << USIC_CH_TCSR_TDEN_Pos)                       /*!< USIC_CH TCSR: TDEN Mask                 */
#define USIC_CH_TCSR_TDVTR_Pos                12                                                      /*!< USIC_CH TCSR: TDVTR Position            */
#define USIC_CH_TCSR_TDVTR_Msk                (0x01UL << USIC_CH_TCSR_TDVTR_Pos)                      /*!< USIC_CH TCSR: TDVTR Mask                */
#define USIC_CH_TCSR_WA_Pos                   13                                                      /*!< USIC_CH TCSR: WA Position               */
#define USIC_CH_TCSR_WA_Msk                   (0x01UL << USIC_CH_TCSR_WA_Pos)                         /*!< USIC_CH TCSR: WA Mask                   */
#define USIC_CH_TCSR_TSOF_Pos                 24                                                      /*!< USIC_CH TCSR: TSOF Position             */
#define USIC_CH_TCSR_TSOF_Msk                 (0x01UL << USIC_CH_TCSR_TSOF_Pos)                       /*!< USIC_CH TCSR: TSOF Mask                 */
#define USIC_CH_TCSR_TV_Pos                   26                                                      /*!< USIC_CH TCSR: TV Position               */
#define USIC_CH_TCSR_TV_Msk                   (0x01UL << USIC_CH_TCSR_TV_Pos)                         /*!< USIC_CH TCSR: TV Mask                   */
#define USIC_CH_TCSR_TVC_Pos                  27                                                      /*!< USIC_CH TCSR: TVC Position              */
#define USIC_CH_TCSR_TVC_Msk                  (0x01UL << USIC_CH_TCSR_TVC_Pos)                        /*!< USIC_CH TCSR: TVC Mask                  */
#define USIC_CH_TCSR_TE_Pos                   28                                                      /*!< USIC_CH TCSR: TE Position               */
#define USIC_CH_TCSR_TE_Msk                   (0x01UL << USIC_CH_TCSR_TE_Pos)                         /*!< USIC_CH TCSR: TE Mask                   */

/* ---------------------------------  USIC_CH_PCR  -------------------------------- */
#define USIC_CH_PCR_CTR0_Pos                  0                                                       /*!< USIC_CH PCR: CTR0 Position              */
#define USIC_CH_PCR_CTR0_Msk                  (0x01UL << USIC_CH_PCR_CTR0_Pos)                        /*!< USIC_CH PCR: CTR0 Mask                  */
#define USIC_CH_PCR_CTR1_Pos                  1                                                       /*!< USIC_CH PCR: CTR1 Position              */
#define USIC_CH_PCR_CTR1_Msk                  (0x01UL << USIC_CH_PCR_CTR1_Pos)                        /*!< USIC_CH PCR: CTR1 Mask                  */
#define USIC_CH_PCR_CTR2_Pos                  2                                                       /*!< USIC_CH PCR: CTR2 Position              */
#define USIC_CH_PCR_CTR2_Msk                  (0x01UL << USIC_CH_PCR_CTR2_Pos)                        /*!< USIC_CH PCR: CTR2 Mask                  */
#define USIC_CH_PCR_CTR3_Pos                  3                                                       /*!< USIC_CH PCR: CTR3 Position              */
#define USIC_CH_PCR_CTR3_Msk                  (0x01UL << USIC_CH_PCR_CTR3_Pos)                        /*!< USIC_CH PCR: CTR3 Mask                  */
#define USIC_CH_PCR_CTR4_Pos                  4                                                       /*!< USIC_CH PCR: CTR4 Position              */
#define USIC_CH_PCR_CTR4_Msk                  (0x01UL << USIC_CH_PCR_CTR4_Pos)                        /*!< USIC_CH PCR: CTR4 Mask                  */
#define USIC_CH_PCR_CTR5_Pos                  5                                                       /*!< USIC_CH PCR: CTR5 Position              */
#define USIC_CH_PCR_CTR5_Msk                  (0x01UL << USIC_CH_PCR_CTR5_Pos)                        /*!< USIC_CH PCR: CTR5 Mask                  */
#define USIC_CH_PCR_CTR6_Pos                  6                                                       /*!< USIC_CH PCR: CTR6 Position              */
#define USIC_CH_PCR_CTR6_Msk                  (0x01UL << USIC_CH_PCR_CTR6_Pos)                        /*!< USIC_CH PCR: CTR6 Mask                  */
#define USIC_CH_PCR_CTR7_Pos                  7                                                       /*!< USIC_CH PCR: CTR7 Position              */
#define USIC_CH_PCR_CTR7_Msk                  (0x01UL << USIC_CH_PCR_CTR7_Pos)                        /*!< USIC_CH PCR: CTR7 Mask                  */
#define USIC_CH_PCR_CTR8_Pos                  8                                                       /*!< USIC_CH PCR: CTR8 Position              */
#define USIC_CH_PCR_CTR8_Msk                  (0x01UL << USIC_CH_PCR_CTR8_Pos)                        /*!< USIC_CH PCR: CTR8 Mask                  */
#define USIC_CH_PCR_CTR9_Pos                  9                                                       /*!< USIC_CH PCR: CTR9 Position              */
#define USIC_CH_PCR_CTR9_Msk                  (0x01UL << USIC_CH_PCR_CTR9_Pos)                        /*!< USIC_CH PCR: CTR9 Mask                  */
#define USIC_CH_PCR_CTR10_Pos                 10                                                      /*!< USIC_CH PCR: CTR10 Position             */
#define USIC_CH_PCR_CTR10_Msk                 (0x01UL << USIC_CH_PCR_CTR10_Pos)                       /*!< USIC_CH PCR: CTR10 Mask                 */
#define USIC_CH_PCR_CTR11_Pos                 11                                                      /*!< USIC_CH PCR: CTR11 Position             */
#define USIC_CH_PCR_CTR11_Msk                 (0x01UL << USIC_CH_PCR_CTR11_Pos)                       /*!< USIC_CH PCR: CTR11 Mask                 */
#define USIC_CH_PCR_CTR12_Pos                 12                                                      /*!< USIC_CH PCR: CTR12 Position             */
#define USIC_CH_PCR_CTR12_Msk                 (0x01UL << USIC_CH_PCR_CTR12_Pos)                       /*!< USIC_CH PCR: CTR12 Mask                 */
#define USIC_CH_PCR_CTR13_Pos                 13                                                      /*!< USIC_CH PCR: CTR13 Position             */
#define USIC_CH_PCR_CTR13_Msk                 (0x01UL << USIC_CH_PCR_CTR13_Pos)                       /*!< USIC_CH PCR: CTR13 Mask                 */
#define USIC_CH_PCR_CTR14_Pos                 14                                                      /*!< USIC_CH PCR: CTR14 Position             */
#define USIC_CH_PCR_CTR14_Msk                 (0x01UL << USIC_CH_PCR_CTR14_Pos)                       /*!< USIC_CH PCR: CTR14 Mask                 */
#define USIC_CH_PCR_CTR15_Pos                 15                                                      /*!< USIC_CH PCR: CTR15 Position             */
#define USIC_CH_PCR_CTR15_Msk                 (0x01UL << USIC_CH_PCR_CTR15_Pos)                       /*!< USIC_CH PCR: CTR15 Mask                 */
#define USIC_CH_PCR_CTR16_Pos                 16                                                      /*!< USIC_CH PCR: CTR16 Position             */
#define USIC_CH_PCR_CTR16_Msk                 (0x01UL << USIC_CH_PCR_CTR16_Pos)                       /*!< USIC_CH PCR: CTR16 Mask                 */
#define USIC_CH_PCR_CTR17_Pos                 17                                                      /*!< USIC_CH PCR: CTR17 Position             */
#define USIC_CH_PCR_CTR17_Msk                 (0x01UL << USIC_CH_PCR_CTR17_Pos)                       /*!< USIC_CH PCR: CTR17 Mask                 */
#define USIC_CH_PCR_CTR18_Pos                 18                                                      /*!< USIC_CH PCR: CTR18 Position             */
#define USIC_CH_PCR_CTR18_Msk                 (0x01UL << USIC_CH_PCR_CTR18_Pos)                       /*!< USIC_CH PCR: CTR18 Mask                 */
#define USIC_CH_PCR_CTR19_Pos                 19                                                      /*!< USIC_CH PCR: CTR19 Position             */
#define USIC_CH_PCR_CTR19_Msk                 (0x01UL << USIC_CH_PCR_CTR19_Pos)                       /*!< USIC_CH PCR: CTR19 Mask                 */
#define USIC_CH_PCR_CTR20_Pos                 20                                                      /*!< USIC_CH PCR: CTR20 Position             */
#define USIC_CH_PCR_CTR20_Msk                 (0x01UL << USIC_CH_PCR_CTR20_Pos)                       /*!< USIC_CH PCR: CTR20 Mask                 */
#define USIC_CH_PCR_CTR21_Pos                 21                                                      /*!< USIC_CH PCR: CTR21 Position             */
#define USIC_CH_PCR_CTR21_Msk                 (0x01UL << USIC_CH_PCR_CTR21_Pos)                       /*!< USIC_CH PCR: CTR21 Mask                 */
#define USIC_CH_PCR_CTR22_Pos                 22                                                      /*!< USIC_CH PCR: CTR22 Position             */
#define USIC_CH_PCR_CTR22_Msk                 (0x01UL << USIC_CH_PCR_CTR22_Pos)                       /*!< USIC_CH PCR: CTR22 Mask                 */
#define USIC_CH_PCR_CTR23_Pos                 23                                                      /*!< USIC_CH PCR: CTR23 Position             */
#define USIC_CH_PCR_CTR23_Msk                 (0x01UL << USIC_CH_PCR_CTR23_Pos)                       /*!< USIC_CH PCR: CTR23 Mask                 */
#define USIC_CH_PCR_CTR24_Pos                 24                                                      /*!< USIC_CH PCR: CTR24 Position             */
#define USIC_CH_PCR_CTR24_Msk                 (0x01UL << USIC_CH_PCR_CTR24_Pos)                       /*!< USIC_CH PCR: CTR24 Mask                 */
#define USIC_CH_PCR_CTR25_Pos                 25                                                      /*!< USIC_CH PCR: CTR25 Position             */
#define USIC_CH_PCR_CTR25_Msk                 (0x01UL << USIC_CH_PCR_CTR25_Pos)                       /*!< USIC_CH PCR: CTR25 Mask                 */
#define USIC_CH_PCR_CTR26_Pos                 26                                                      /*!< USIC_CH PCR: CTR26 Position             */
#define USIC_CH_PCR_CTR26_Msk                 (0x01UL << USIC_CH_PCR_CTR26_Pos)                       /*!< USIC_CH PCR: CTR26 Mask                 */
#define USIC_CH_PCR_CTR27_Pos                 27                                                      /*!< USIC_CH PCR: CTR27 Position             */
#define USIC_CH_PCR_CTR27_Msk                 (0x01UL << USIC_CH_PCR_CTR27_Pos)                       /*!< USIC_CH PCR: CTR27 Mask                 */
#define USIC_CH_PCR_CTR28_Pos                 28                                                      /*!< USIC_CH PCR: CTR28 Position             */
#define USIC_CH_PCR_CTR28_Msk                 (0x01UL << USIC_CH_PCR_CTR28_Pos)                       /*!< USIC_CH PCR: CTR28 Mask                 */
#define USIC_CH_PCR_CTR29_Pos                 29                                                      /*!< USIC_CH PCR: CTR29 Position             */
#define USIC_CH_PCR_CTR29_Msk                 (0x01UL << USIC_CH_PCR_CTR29_Pos)                       /*!< USIC_CH PCR: CTR29 Mask                 */
#define USIC_CH_PCR_CTR30_Pos                 30                                                      /*!< USIC_CH PCR: CTR30 Position             */
#define USIC_CH_PCR_CTR30_Msk                 (0x01UL << USIC_CH_PCR_CTR30_Pos)                       /*!< USIC_CH PCR: CTR30 Mask                 */
#define USIC_CH_PCR_CTR31_Pos                 31                                                      /*!< USIC_CH PCR: CTR31 Position             */
#define USIC_CH_PCR_CTR31_Msk                 (0x01UL << USIC_CH_PCR_CTR31_Pos)                       /*!< USIC_CH PCR: CTR31 Mask                 */

/* -----------------------------  USIC_CH_PCR_ASCMode  ---------------------------- */
#define USIC_CH_PCR_ASCMode_SMD_Pos           0                                                       /*!< USIC_CH PCR_ASCMode: SMD Position       */
#define USIC_CH_PCR_ASCMode_SMD_Msk           (0x01UL << USIC_CH_PCR_ASCMode_SMD_Pos)                 /*!< USIC_CH PCR_ASCMode: SMD Mask           */
#define USIC_CH_PCR_ASCMode_STPB_Pos          1                                                       /*!< USIC_CH PCR_ASCMode: STPB Position      */
#define USIC_CH_PCR_ASCMode_STPB_Msk          (0x01UL << USIC_CH_PCR_ASCMode_STPB_Pos)                /*!< USIC_CH PCR_ASCMode: STPB Mask          */
#define USIC_CH_PCR_ASCMode_IDM_Pos           2                                                       /*!< USIC_CH PCR_ASCMode: IDM Position       */
#define USIC_CH_PCR_ASCMode_IDM_Msk           (0x01UL << USIC_CH_PCR_ASCMode_IDM_Pos)                 /*!< USIC_CH PCR_ASCMode: IDM Mask           */
#define USIC_CH_PCR_ASCMode_SBIEN_Pos         3                                                       /*!< USIC_CH PCR_ASCMode: SBIEN Position     */
#define USIC_CH_PCR_ASCMode_SBIEN_Msk         (0x01UL << USIC_CH_PCR_ASCMode_SBIEN_Pos)               /*!< USIC_CH PCR_ASCMode: SBIEN Mask         */
#define USIC_CH_PCR_ASCMode_CDEN_Pos          4                                                       /*!< USIC_CH PCR_ASCMode: CDEN Position      */
#define USIC_CH_PCR_ASCMode_CDEN_Msk          (0x01UL << USIC_CH_PCR_ASCMode_CDEN_Pos)                /*!< USIC_CH PCR_ASCMode: CDEN Mask          */
#define USIC_CH_PCR_ASCMode_RNIEN_Pos         5                                                       /*!< USIC_CH PCR_ASCMode: RNIEN Position     */
#define USIC_CH_PCR_ASCMode_RNIEN_Msk         (0x01UL << USIC_CH_PCR_ASCMode_RNIEN_Pos)               /*!< USIC_CH PCR_ASCMode: RNIEN Mask         */
#define USIC_CH_PCR_ASCMode_FEIEN_Pos         6                                                       /*!< USIC_CH PCR_ASCMode: FEIEN Position     */
#define USIC_CH_PCR_ASCMode_FEIEN_Msk         (0x01UL << USIC_CH_PCR_ASCMode_FEIEN_Pos)               /*!< USIC_CH PCR_ASCMode: FEIEN Mask         */
#define USIC_CH_PCR_ASCMode_FFIEN_Pos         7                                                       /*!< USIC_CH PCR_ASCMode: FFIEN Position     */
#define USIC_CH_PCR_ASCMode_FFIEN_Msk         (0x01UL << USIC_CH_PCR_ASCMode_FFIEN_Pos)               /*!< USIC_CH PCR_ASCMode: FFIEN Mask         */
#define USIC_CH_PCR_ASCMode_SP_Pos            8                                                       /*!< USIC_CH PCR_ASCMode: SP Position        */
#define USIC_CH_PCR_ASCMode_SP_Msk            (0x1fUL << USIC_CH_PCR_ASCMode_SP_Pos)                  /*!< USIC_CH PCR_ASCMode: SP Mask            */
#define USIC_CH_PCR_ASCMode_PL_Pos            13                                                      /*!< USIC_CH PCR_ASCMode: PL Position        */
#define USIC_CH_PCR_ASCMode_PL_Msk            (0x07UL << USIC_CH_PCR_ASCMode_PL_Pos)                  /*!< USIC_CH PCR_ASCMode: PL Mask            */
#define USIC_CH_PCR_ASCMode_RSTEN_Pos         16                                                      /*!< USIC_CH PCR_ASCMode: RSTEN Position     */
#define USIC_CH_PCR_ASCMode_RSTEN_Msk         (0x01UL << USIC_CH_PCR_ASCMode_RSTEN_Pos)               /*!< USIC_CH PCR_ASCMode: RSTEN Mask         */
#define USIC_CH_PCR_ASCMode_TSTEN_Pos         17                                                      /*!< USIC_CH PCR_ASCMode: TSTEN Position     */
#define USIC_CH_PCR_ASCMode_TSTEN_Msk         (0x01UL << USIC_CH_PCR_ASCMode_TSTEN_Pos)               /*!< USIC_CH PCR_ASCMode: TSTEN Mask         */
#define USIC_CH_PCR_ASCMode_MCLK_Pos          31                                                      /*!< USIC_CH PCR_ASCMode: MCLK Position      */
#define USIC_CH_PCR_ASCMode_MCLK_Msk          (0x01UL << USIC_CH_PCR_ASCMode_MCLK_Pos)                /*!< USIC_CH PCR_ASCMode: MCLK Mask          */

/* -----------------------------  USIC_CH_PCR_SSCMode  ---------------------------- */
#define USIC_CH_PCR_SSCMode_MSLSEN_Pos        0                                                       /*!< USIC_CH PCR_SSCMode: MSLSEN Position    */
#define USIC_CH_PCR_SSCMode_MSLSEN_Msk        (0x01UL << USIC_CH_PCR_SSCMode_MSLSEN_Pos)              /*!< USIC_CH PCR_SSCMode: MSLSEN Mask        */
#define USIC_CH_PCR_SSCMode_SELCTR_Pos        1                                                       /*!< USIC_CH PCR_SSCMode: SELCTR Position    */
#define USIC_CH_PCR_SSCMode_SELCTR_Msk        (0x01UL << USIC_CH_PCR_SSCMode_SELCTR_Pos)              /*!< USIC_CH PCR_SSCMode: SELCTR Mask        */
#define USIC_CH_PCR_SSCMode_SELINV_Pos        2                                                       /*!< USIC_CH PCR_SSCMode: SELINV Position    */
#define USIC_CH_PCR_SSCMode_SELINV_Msk        (0x01UL << USIC_CH_PCR_SSCMode_SELINV_Pos)              /*!< USIC_CH PCR_SSCMode: SELINV Mask        */
#define USIC_CH_PCR_SSCMode_FEM_Pos           3                                                       /*!< USIC_CH PCR_SSCMode: FEM Position       */
#define USIC_CH_PCR_SSCMode_FEM_Msk           (0x01UL << USIC_CH_PCR_SSCMode_FEM_Pos)                 /*!< USIC_CH PCR_SSCMode: FEM Mask           */
#define USIC_CH_PCR_SSCMode_CTQSEL1_Pos       4                                                       /*!< USIC_CH PCR_SSCMode: CTQSEL1 Position   */
#define USIC_CH_PCR_SSCMode_CTQSEL1_Msk       (0x03UL << USIC_CH_PCR_SSCMode_CTQSEL1_Pos)             /*!< USIC_CH PCR_SSCMode: CTQSEL1 Mask       */
#define USIC_CH_PCR_SSCMode_PCTQ1_Pos         6                                                       /*!< USIC_CH PCR_SSCMode: PCTQ1 Position     */
#define USIC_CH_PCR_SSCMode_PCTQ1_Msk         (0x03UL << USIC_CH_PCR_SSCMode_PCTQ1_Pos)               /*!< USIC_CH PCR_SSCMode: PCTQ1 Mask         */
#define USIC_CH_PCR_SSCMode_DCTQ1_Pos         8                                                       /*!< USIC_CH PCR_SSCMode: DCTQ1 Position     */
#define USIC_CH_PCR_SSCMode_DCTQ1_Msk         (0x1fUL << USIC_CH_PCR_SSCMode_DCTQ1_Pos)               /*!< USIC_CH PCR_SSCMode: DCTQ1 Mask         */
#define USIC_CH_PCR_SSCMode_PARIEN_Pos        13                                                      /*!< USIC_CH PCR_SSCMode: PARIEN Position    */
#define USIC_CH_PCR_SSCMode_PARIEN_Msk        (0x01UL << USIC_CH_PCR_SSCMode_PARIEN_Pos)              /*!< USIC_CH PCR_SSCMode: PARIEN Mask        */
#define USIC_CH_PCR_SSCMode_MSLSIEN_Pos       14                                                      /*!< USIC_CH PCR_SSCMode: MSLSIEN Position   */
#define USIC_CH_PCR_SSCMode_MSLSIEN_Msk       (0x01UL << USIC_CH_PCR_SSCMode_MSLSIEN_Pos)             /*!< USIC_CH PCR_SSCMode: MSLSIEN Mask       */
#define USIC_CH_PCR_SSCMode_DX2TIEN_Pos       15                                                      /*!< USIC_CH PCR_SSCMode: DX2TIEN Position   */
#define USIC_CH_PCR_SSCMode_DX2TIEN_Msk       (0x01UL << USIC_CH_PCR_SSCMode_DX2TIEN_Pos)             /*!< USIC_CH PCR_SSCMode: DX2TIEN Mask       */
#define USIC_CH_PCR_SSCMode_SELO_Pos          16                                                      /*!< USIC_CH PCR_SSCMode: SELO Position      */
#define USIC_CH_PCR_SSCMode_SELO_Msk          (0x000000ffUL << USIC_CH_PCR_SSCMode_SELO_Pos)          /*!< USIC_CH PCR_SSCMode: SELO Mask          */
#define USIC_CH_PCR_SSCMode_TIWEN_Pos         24                                                      /*!< USIC_CH PCR_SSCMode: TIWEN Position     */
#define USIC_CH_PCR_SSCMode_TIWEN_Msk         (0x01UL << USIC_CH_PCR_SSCMode_TIWEN_Pos)               /*!< USIC_CH PCR_SSCMode: TIWEN Mask         */
#define USIC_CH_PCR_SSCMode_MCLK_Pos          31                                                      /*!< USIC_CH PCR_SSCMode: MCLK Position      */
#define USIC_CH_PCR_SSCMode_MCLK_Msk          (0x01UL << USIC_CH_PCR_SSCMode_MCLK_Pos)                /*!< USIC_CH PCR_SSCMode: MCLK Mask          */

/* -----------------------------  USIC_CH_PCR_IICMode  ---------------------------- */
#define USIC_CH_PCR_IICMode_SLAD_Pos          0                                                       /*!< USIC_CH PCR_IICMode: SLAD Position      */
#define USIC_CH_PCR_IICMode_SLAD_Msk          (0x0000ffffUL << USIC_CH_PCR_IICMode_SLAD_Pos)          /*!< USIC_CH PCR_IICMode: SLAD Mask          */
#define USIC_CH_PCR_IICMode_ACK00_Pos         16                                                      /*!< USIC_CH PCR_IICMode: ACK00 Position     */
#define USIC_CH_PCR_IICMode_ACK00_Msk         (0x01UL << USIC_CH_PCR_IICMode_ACK00_Pos)               /*!< USIC_CH PCR_IICMode: ACK00 Mask         */
#define USIC_CH_PCR_IICMode_STIM_Pos          17                                                      /*!< USIC_CH PCR_IICMode: STIM Position      */
#define USIC_CH_PCR_IICMode_STIM_Msk          (0x01UL << USIC_CH_PCR_IICMode_STIM_Pos)                /*!< USIC_CH PCR_IICMode: STIM Mask          */
#define USIC_CH_PCR_IICMode_SCRIEN_Pos        18                                                      /*!< USIC_CH PCR_IICMode: SCRIEN Position    */
#define USIC_CH_PCR_IICMode_SCRIEN_Msk        (0x01UL << USIC_CH_PCR_IICMode_SCRIEN_Pos)              /*!< USIC_CH PCR_IICMode: SCRIEN Mask        */
#define USIC_CH_PCR_IICMode_RSCRIEN_Pos       19                                                      /*!< USIC_CH PCR_IICMode: RSCRIEN Position   */
#define USIC_CH_PCR_IICMode_RSCRIEN_Msk       (0x01UL << USIC_CH_PCR_IICMode_RSCRIEN_Pos)             /*!< USIC_CH PCR_IICMode: RSCRIEN Mask       */
#define USIC_CH_PCR_IICMode_PCRIEN_Pos        20                                                      /*!< USIC_CH PCR_IICMode: PCRIEN Position    */
#define USIC_CH_PCR_IICMode_PCRIEN_Msk        (0x01UL << USIC_CH_PCR_IICMode_PCRIEN_Pos)              /*!< USIC_CH PCR_IICMode: PCRIEN Mask        */
#define USIC_CH_PCR_IICMode_NACKIEN_Pos       21                                                      /*!< USIC_CH PCR_IICMode: NACKIEN Position   */
#define USIC_CH_PCR_IICMode_NACKIEN_Msk       (0x01UL << USIC_CH_PCR_IICMode_NACKIEN_Pos)             /*!< USIC_CH PCR_IICMode: NACKIEN Mask       */
#define USIC_CH_PCR_IICMode_ARLIEN_Pos        22                                                      /*!< USIC_CH PCR_IICMode: ARLIEN Position    */
#define USIC_CH_PCR_IICMode_ARLIEN_Msk        (0x01UL << USIC_CH_PCR_IICMode_ARLIEN_Pos)              /*!< USIC_CH PCR_IICMode: ARLIEN Mask        */
#define USIC_CH_PCR_IICMode_SRRIEN_Pos        23                                                      /*!< USIC_CH PCR_IICMode: SRRIEN Position    */
#define USIC_CH_PCR_IICMode_SRRIEN_Msk        (0x01UL << USIC_CH_PCR_IICMode_SRRIEN_Pos)              /*!< USIC_CH PCR_IICMode: SRRIEN Mask        */
#define USIC_CH_PCR_IICMode_ERRIEN_Pos        24                                                      /*!< USIC_CH PCR_IICMode: ERRIEN Position    */
#define USIC_CH_PCR_IICMode_ERRIEN_Msk        (0x01UL << USIC_CH_PCR_IICMode_ERRIEN_Pos)              /*!< USIC_CH PCR_IICMode: ERRIEN Mask        */
#define USIC_CH_PCR_IICMode_SACKDIS_Pos       25                                                      /*!< USIC_CH PCR_IICMode: SACKDIS Position   */
#define USIC_CH_PCR_IICMode_SACKDIS_Msk       (0x01UL << USIC_CH_PCR_IICMode_SACKDIS_Pos)             /*!< USIC_CH PCR_IICMode: SACKDIS Mask       */
#define USIC_CH_PCR_IICMode_HDEL_Pos          26                                                      /*!< USIC_CH PCR_IICMode: HDEL Position      */
#define USIC_CH_PCR_IICMode_HDEL_Msk          (0x0fUL << USIC_CH_PCR_IICMode_HDEL_Pos)                /*!< USIC_CH PCR_IICMode: HDEL Mask          */
#define USIC_CH_PCR_IICMode_ACKIEN_Pos        30                                                      /*!< USIC_CH PCR_IICMode: ACKIEN Position    */
#define USIC_CH_PCR_IICMode_ACKIEN_Msk        (0x01UL << USIC_CH_PCR_IICMode_ACKIEN_Pos)              /*!< USIC_CH PCR_IICMode: ACKIEN Mask        */
#define USIC_CH_PCR_IICMode_MCLK_Pos          31                                                      /*!< USIC_CH PCR_IICMode: MCLK Position      */
#define USIC_CH_PCR_IICMode_MCLK_Msk          (0x01UL << USIC_CH_PCR_IICMode_MCLK_Pos)                /*!< USIC_CH PCR_IICMode: MCLK Mask          */

/* -----------------------------  USIC_CH_PCR_IISMode  ---------------------------- */
#define USIC_CH_PCR_IISMode_WAGEN_Pos         0                                                       /*!< USIC_CH PCR_IISMode: WAGEN Position     */
#define USIC_CH_PCR_IISMode_WAGEN_Msk         (0x01UL << USIC_CH_PCR_IISMode_WAGEN_Pos)               /*!< USIC_CH PCR_IISMode: WAGEN Mask         */
#define USIC_CH_PCR_IISMode_DTEN_Pos          1                                                       /*!< USIC_CH PCR_IISMode: DTEN Position      */
#define USIC_CH_PCR_IISMode_DTEN_Msk          (0x01UL << USIC_CH_PCR_IISMode_DTEN_Pos)                /*!< USIC_CH PCR_IISMode: DTEN Mask          */
#define USIC_CH_PCR_IISMode_SELINV_Pos        2                                                       /*!< USIC_CH PCR_IISMode: SELINV Position    */
#define USIC_CH_PCR_IISMode_SELINV_Msk        (0x01UL << USIC_CH_PCR_IISMode_SELINV_Pos)              /*!< USIC_CH PCR_IISMode: SELINV Mask        */
#define USIC_CH_PCR_IISMode_WAFEIEN_Pos       4                                                       /*!< USIC_CH PCR_IISMode: WAFEIEN Position   */
#define USIC_CH_PCR_IISMode_WAFEIEN_Msk       (0x01UL << USIC_CH_PCR_IISMode_WAFEIEN_Pos)             /*!< USIC_CH PCR_IISMode: WAFEIEN Mask       */
#define USIC_CH_PCR_IISMode_WAREIEN_Pos       5                                                       /*!< USIC_CH PCR_IISMode: WAREIEN Position   */
#define USIC_CH_PCR_IISMode_WAREIEN_Msk       (0x01UL << USIC_CH_PCR_IISMode_WAREIEN_Pos)             /*!< USIC_CH PCR_IISMode: WAREIEN Mask       */
#define USIC_CH_PCR_IISMode_ENDIEN_Pos        6                                                       /*!< USIC_CH PCR_IISMode: ENDIEN Position    */
#define USIC_CH_PCR_IISMode_ENDIEN_Msk        (0x01UL << USIC_CH_PCR_IISMode_ENDIEN_Pos)              /*!< USIC_CH PCR_IISMode: ENDIEN Mask        */
#define USIC_CH_PCR_IISMode_DX2TIEN_Pos       15                                                      /*!< USIC_CH PCR_IISMode: DX2TIEN Position   */
#define USIC_CH_PCR_IISMode_DX2TIEN_Msk       (0x01UL << USIC_CH_PCR_IISMode_DX2TIEN_Pos)             /*!< USIC_CH PCR_IISMode: DX2TIEN Mask       */
#define USIC_CH_PCR_IISMode_TDEL_Pos          16                                                      /*!< USIC_CH PCR_IISMode: TDEL Position      */
#define USIC_CH_PCR_IISMode_TDEL_Msk          (0x3fUL << USIC_CH_PCR_IISMode_TDEL_Pos)                /*!< USIC_CH PCR_IISMode: TDEL Mask          */
#define USIC_CH_PCR_IISMode_MCLK_Pos          31                                                      /*!< USIC_CH PCR_IISMode: MCLK Position      */
#define USIC_CH_PCR_IISMode_MCLK_Msk          (0x01UL << USIC_CH_PCR_IISMode_MCLK_Pos)                /*!< USIC_CH PCR_IISMode: MCLK Mask          */

/* ---------------------------------  USIC_CH_CCR  -------------------------------- */
#define USIC_CH_CCR_MODE_Pos                  0                                                       /*!< USIC_CH CCR: MODE Position              */
#define USIC_CH_CCR_MODE_Msk                  (0x0fUL << USIC_CH_CCR_MODE_Pos)                        /*!< USIC_CH CCR: MODE Mask                  */
#define USIC_CH_CCR_HPCEN_Pos                 6                                                       /*!< USIC_CH CCR: HPCEN Position             */
#define USIC_CH_CCR_HPCEN_Msk                 (0x03UL << USIC_CH_CCR_HPCEN_Pos)                       /*!< USIC_CH CCR: HPCEN Mask                 */
#define USIC_CH_CCR_PM_Pos                    8                                                       /*!< USIC_CH CCR: PM Position                */
#define USIC_CH_CCR_PM_Msk                    (0x03UL << USIC_CH_CCR_PM_Pos)                          /*!< USIC_CH CCR: PM Mask                    */
#define USIC_CH_CCR_RSIEN_Pos                 10                                                      /*!< USIC_CH CCR: RSIEN Position             */
#define USIC_CH_CCR_RSIEN_Msk                 (0x01UL << USIC_CH_CCR_RSIEN_Pos)                       /*!< USIC_CH CCR: RSIEN Mask                 */
#define USIC_CH_CCR_DLIEN_Pos                 11                                                      /*!< USIC_CH CCR: DLIEN Position             */
#define USIC_CH_CCR_DLIEN_Msk                 (0x01UL << USIC_CH_CCR_DLIEN_Pos)                       /*!< USIC_CH CCR: DLIEN Mask                 */
#define USIC_CH_CCR_TSIEN_Pos                 12                                                      /*!< USIC_CH CCR: TSIEN Position             */
#define USIC_CH_CCR_TSIEN_Msk                 (0x01UL << USIC_CH_CCR_TSIEN_Pos)                       /*!< USIC_CH CCR: TSIEN Mask                 */
#define USIC_CH_CCR_TBIEN_Pos                 13                                                      /*!< USIC_CH CCR: TBIEN Position             */
#define USIC_CH_CCR_TBIEN_Msk                 (0x01UL << USIC_CH_CCR_TBIEN_Pos)                       /*!< USIC_CH CCR: TBIEN Mask                 */
#define USIC_CH_CCR_RIEN_Pos                  14                                                      /*!< USIC_CH CCR: RIEN Position              */
#define USIC_CH_CCR_RIEN_Msk                  (0x01UL << USIC_CH_CCR_RIEN_Pos)                        /*!< USIC_CH CCR: RIEN Mask                  */
#define USIC_CH_CCR_AIEN_Pos                  15                                                      /*!< USIC_CH CCR: AIEN Position              */
#define USIC_CH_CCR_AIEN_Msk                  (0x01UL << USIC_CH_CCR_AIEN_Pos)                        /*!< USIC_CH CCR: AIEN Mask                  */
#define USIC_CH_CCR_BRGIEN_Pos                16                                                      /*!< USIC_CH CCR: BRGIEN Position            */
#define USIC_CH_CCR_BRGIEN_Msk                (0x01UL << USIC_CH_CCR_BRGIEN_Pos)                      /*!< USIC_CH CCR: BRGIEN Mask                */

/* --------------------------------  USIC_CH_CMTR  -------------------------------- */
#define USIC_CH_CMTR_CTV_Pos                  0                                                       /*!< USIC_CH CMTR: CTV Position              */
#define USIC_CH_CMTR_CTV_Msk                  (0x000003ffUL << USIC_CH_CMTR_CTV_Pos)                  /*!< USIC_CH CMTR: CTV Mask                  */

/* ---------------------------------  USIC_CH_PSR  -------------------------------- */
#define USIC_CH_PSR_ST0_Pos                   0                                                       /*!< USIC_CH PSR: ST0 Position               */
#define USIC_CH_PSR_ST0_Msk                   (0x01UL << USIC_CH_PSR_ST0_Pos)                         /*!< USIC_CH PSR: ST0 Mask                   */
#define USIC_CH_PSR_ST1_Pos                   1                                                       /*!< USIC_CH PSR: ST1 Position               */
#define USIC_CH_PSR_ST1_Msk                   (0x01UL << USIC_CH_PSR_ST1_Pos)                         /*!< USIC_CH PSR: ST1 Mask                   */
#define USIC_CH_PSR_ST2_Pos                   2                                                       /*!< USIC_CH PSR: ST2 Position               */
#define USIC_CH_PSR_ST2_Msk                   (0x01UL << USIC_CH_PSR_ST2_Pos)                         /*!< USIC_CH PSR: ST2 Mask                   */
#define USIC_CH_PSR_ST3_Pos                   3                                                       /*!< USIC_CH PSR: ST3 Position               */
#define USIC_CH_PSR_ST3_Msk                   (0x01UL << USIC_CH_PSR_ST3_Pos)                         /*!< USIC_CH PSR: ST3 Mask                   */
#define USIC_CH_PSR_ST4_Pos                   4                                                       /*!< USIC_CH PSR: ST4 Position               */
#define USIC_CH_PSR_ST4_Msk                   (0x01UL << USIC_CH_PSR_ST4_Pos)                         /*!< USIC_CH PSR: ST4 Mask                   */
#define USIC_CH_PSR_ST5_Pos                   5                                                       /*!< USIC_CH PSR: ST5 Position               */
#define USIC_CH_PSR_ST5_Msk                   (0x01UL << USIC_CH_PSR_ST5_Pos)                         /*!< USIC_CH PSR: ST5 Mask                   */
#define USIC_CH_PSR_ST6_Pos                   6                                                       /*!< USIC_CH PSR: ST6 Position               */
#define USIC_CH_PSR_ST6_Msk                   (0x01UL << USIC_CH_PSR_ST6_Pos)                         /*!< USIC_CH PSR: ST6 Mask                   */
#define USIC_CH_PSR_ST7_Pos                   7                                                       /*!< USIC_CH PSR: ST7 Position               */
#define USIC_CH_PSR_ST7_Msk                   (0x01UL << USIC_CH_PSR_ST7_Pos)                         /*!< USIC_CH PSR: ST7 Mask                   */
#define USIC_CH_PSR_ST8_Pos                   8                                                       /*!< USIC_CH PSR: ST8 Position               */
#define USIC_CH_PSR_ST8_Msk                   (0x01UL << USIC_CH_PSR_ST8_Pos)                         /*!< USIC_CH PSR: ST8 Mask                   */
#define USIC_CH_PSR_ST9_Pos                   9                                                       /*!< USIC_CH PSR: ST9 Position               */
#define USIC_CH_PSR_ST9_Msk                   (0x01UL << USIC_CH_PSR_ST9_Pos)                         /*!< USIC_CH PSR: ST9 Mask                   */
#define USIC_CH_PSR_RSIF_Pos                  10                                                      /*!< USIC_CH PSR: RSIF Position              */
#define USIC_CH_PSR_RSIF_Msk                  (0x01UL << USIC_CH_PSR_RSIF_Pos)                        /*!< USIC_CH PSR: RSIF Mask                  */
#define USIC_CH_PSR_DLIF_Pos                  11                                                      /*!< USIC_CH PSR: DLIF Position              */
#define USIC_CH_PSR_DLIF_Msk                  (0x01UL << USIC_CH_PSR_DLIF_Pos)                        /*!< USIC_CH PSR: DLIF Mask                  */
#define USIC_CH_PSR_TSIF_Pos                  12                                                      /*!< USIC_CH PSR: TSIF Position              */
#define USIC_CH_PSR_TSIF_Msk                  (0x01UL << USIC_CH_PSR_TSIF_Pos)                        /*!< USIC_CH PSR: TSIF Mask                  */
#define USIC_CH_PSR_TBIF_Pos                  13                                                      /*!< USIC_CH PSR: TBIF Position              */
#define USIC_CH_PSR_TBIF_Msk                  (0x01UL << USIC_CH_PSR_TBIF_Pos)                        /*!< USIC_CH PSR: TBIF Mask                  */
#define USIC_CH_PSR_RIF_Pos                   14                                                      /*!< USIC_CH PSR: RIF Position               */
#define USIC_CH_PSR_RIF_Msk                   (0x01UL << USIC_CH_PSR_RIF_Pos)                         /*!< USIC_CH PSR: RIF Mask                   */
#define USIC_CH_PSR_AIF_Pos                   15                                                      /*!< USIC_CH PSR: AIF Position               */
#define USIC_CH_PSR_AIF_Msk                   (0x01UL << USIC_CH_PSR_AIF_Pos)                         /*!< USIC_CH PSR: AIF Mask                   */
#define USIC_CH_PSR_BRGIF_Pos                 16                                                      /*!< USIC_CH PSR: BRGIF Position             */
#define USIC_CH_PSR_BRGIF_Msk                 (0x01UL << USIC_CH_PSR_BRGIF_Pos)                       /*!< USIC_CH PSR: BRGIF Mask                 */

/* -----------------------------  USIC_CH_PSR_ASCMode  ---------------------------- */
#define USIC_CH_PSR_ASCMode_TXIDLE_Pos        0                                                       /*!< USIC_CH PSR_ASCMode: TXIDLE Position    */
#define USIC_CH_PSR_ASCMode_TXIDLE_Msk        (0x01UL << USIC_CH_PSR_ASCMode_TXIDLE_Pos)              /*!< USIC_CH PSR_ASCMode: TXIDLE Mask        */
#define USIC_CH_PSR_ASCMode_RXIDLE_Pos        1                                                       /*!< USIC_CH PSR_ASCMode: RXIDLE Position    */
#define USIC_CH_PSR_ASCMode_RXIDLE_Msk        (0x01UL << USIC_CH_PSR_ASCMode_RXIDLE_Pos)              /*!< USIC_CH PSR_ASCMode: RXIDLE Mask        */
#define USIC_CH_PSR_ASCMode_SBD_Pos           2                                                       /*!< USIC_CH PSR_ASCMode: SBD Position       */
#define USIC_CH_PSR_ASCMode_SBD_Msk           (0x01UL << USIC_CH_PSR_ASCMode_SBD_Pos)                 /*!< USIC_CH PSR_ASCMode: SBD Mask           */
#define USIC_CH_PSR_ASCMode_COL_Pos           3                                                       /*!< USIC_CH PSR_ASCMode: COL Position       */
#define USIC_CH_PSR_ASCMode_COL_Msk           (0x01UL << USIC_CH_PSR_ASCMode_COL_Pos)                 /*!< USIC_CH PSR_ASCMode: COL Mask           */
#define USIC_CH_PSR_ASCMode_RNS_Pos           4                                                       /*!< USIC_CH PSR_ASCMode: RNS Position       */
#define USIC_CH_PSR_ASCMode_RNS_Msk           (0x01UL << USIC_CH_PSR_ASCMode_RNS_Pos)                 /*!< USIC_CH PSR_ASCMode: RNS Mask           */
#define USIC_CH_PSR_ASCMode_FER0_Pos          5                                                       /*!< USIC_CH PSR_ASCMode: FER0 Position      */
#define USIC_CH_PSR_ASCMode_FER0_Msk          (0x01UL << USIC_CH_PSR_ASCMode_FER0_Pos)                /*!< USIC_CH PSR_ASCMode: FER0 Mask          */
#define USIC_CH_PSR_ASCMode_FER1_Pos          6                                                       /*!< USIC_CH PSR_ASCMode: FER1 Position      */
#define USIC_CH_PSR_ASCMode_FER1_Msk          (0x01UL << USIC_CH_PSR_ASCMode_FER1_Pos)                /*!< USIC_CH PSR_ASCMode: FER1 Mask          */
#define USIC_CH_PSR_ASCMode_RFF_Pos           7                                                       /*!< USIC_CH PSR_ASCMode: RFF Position       */
#define USIC_CH_PSR_ASCMode_RFF_Msk           (0x01UL << USIC_CH_PSR_ASCMode_RFF_Pos)                 /*!< USIC_CH PSR_ASCMode: RFF Mask           */
#define USIC_CH_PSR_ASCMode_TFF_Pos           8                                                       /*!< USIC_CH PSR_ASCMode: TFF Position       */
#define USIC_CH_PSR_ASCMode_TFF_Msk           (0x01UL << USIC_CH_PSR_ASCMode_TFF_Pos)                 /*!< USIC_CH PSR_ASCMode: TFF Mask           */
#define USIC_CH_PSR_ASCMode_BUSY_Pos          9                                                       /*!< USIC_CH PSR_ASCMode: BUSY Position      */
#define USIC_CH_PSR_ASCMode_BUSY_Msk          (0x01UL << USIC_CH_PSR_ASCMode_BUSY_Pos)                /*!< USIC_CH PSR_ASCMode: BUSY Mask          */
#define USIC_CH_PSR_ASCMode_RSIF_Pos          10                                                      /*!< USIC_CH PSR_ASCMode: RSIF Position      */
#define USIC_CH_PSR_ASCMode_RSIF_Msk          (0x01UL << USIC_CH_PSR_ASCMode_RSIF_Pos)                /*!< USIC_CH PSR_ASCMode: RSIF Mask          */
#define USIC_CH_PSR_ASCMode_DLIF_Pos          11                                                      /*!< USIC_CH PSR_ASCMode: DLIF Position      */
#define USIC_CH_PSR_ASCMode_DLIF_Msk          (0x01UL << USIC_CH_PSR_ASCMode_DLIF_Pos)                /*!< USIC_CH PSR_ASCMode: DLIF Mask          */
#define USIC_CH_PSR_ASCMode_TSIF_Pos          12                                                      /*!< USIC_CH PSR_ASCMode: TSIF Position      */
#define USIC_CH_PSR_ASCMode_TSIF_Msk          (0x01UL << USIC_CH_PSR_ASCMode_TSIF_Pos)                /*!< USIC_CH PSR_ASCMode: TSIF Mask          */
#define USIC_CH_PSR_ASCMode_TBIF_Pos          13                                                      /*!< USIC_CH PSR_ASCMode: TBIF Position      */
#define USIC_CH_PSR_ASCMode_TBIF_Msk          (0x01UL << USIC_CH_PSR_ASCMode_TBIF_Pos)                /*!< USIC_CH PSR_ASCMode: TBIF Mask          */
#define USIC_CH_PSR_ASCMode_RIF_Pos           14                                                      /*!< USIC_CH PSR_ASCMode: RIF Position       */
#define USIC_CH_PSR_ASCMode_RIF_Msk           (0x01UL << USIC_CH_PSR_ASCMode_RIF_Pos)                 /*!< USIC_CH PSR_ASCMode: RIF Mask           */
#define USIC_CH_PSR_ASCMode_AIF_Pos           15                                                      /*!< USIC_CH PSR_ASCMode: AIF Position       */
#define USIC_CH_PSR_ASCMode_AIF_Msk           (0x01UL << USIC_CH_PSR_ASCMode_AIF_Pos)                 /*!< USIC_CH PSR_ASCMode: AIF Mask           */
#define USIC_CH_PSR_ASCMode_BRGIF_Pos         16                                                      /*!< USIC_CH PSR_ASCMode: BRGIF Position     */
#define USIC_CH_PSR_ASCMode_BRGIF_Msk         (0x01UL << USIC_CH_PSR_ASCMode_BRGIF_Pos)               /*!< USIC_CH PSR_ASCMode: BRGIF Mask         */

/* -----------------------------  USIC_CH_PSR_SSCMode  ---------------------------- */
#define USIC_CH_PSR_SSCMode_MSLS_Pos          0                                                       /*!< USIC_CH PSR_SSCMode: MSLS Position      */
#define USIC_CH_PSR_SSCMode_MSLS_Msk          (0x01UL << USIC_CH_PSR_SSCMode_MSLS_Pos)                /*!< USIC_CH PSR_SSCMode: MSLS Mask          */
#define USIC_CH_PSR_SSCMode_DX2S_Pos          1                                                       /*!< USIC_CH PSR_SSCMode: DX2S Position      */
#define USIC_CH_PSR_SSCMode_DX2S_Msk          (0x01UL << USIC_CH_PSR_SSCMode_DX2S_Pos)                /*!< USIC_CH PSR_SSCMode: DX2S Mask          */
#define USIC_CH_PSR_SSCMode_MSLSEV_Pos        2                                                       /*!< USIC_CH PSR_SSCMode: MSLSEV Position    */
#define USIC_CH_PSR_SSCMode_MSLSEV_Msk        (0x01UL << USIC_CH_PSR_SSCMode_MSLSEV_Pos)              /*!< USIC_CH PSR_SSCMode: MSLSEV Mask        */
#define USIC_CH_PSR_SSCMode_DX2TEV_Pos        3                                                       /*!< USIC_CH PSR_SSCMode: DX2TEV Position    */
#define USIC_CH_PSR_SSCMode_DX2TEV_Msk        (0x01UL << USIC_CH_PSR_SSCMode_DX2TEV_Pos)              /*!< USIC_CH PSR_SSCMode: DX2TEV Mask        */
#define USIC_CH_PSR_SSCMode_PARERR_Pos        4                                                       /*!< USIC_CH PSR_SSCMode: PARERR Position    */
#define USIC_CH_PSR_SSCMode_PARERR_Msk        (0x01UL << USIC_CH_PSR_SSCMode_PARERR_Pos)              /*!< USIC_CH PSR_SSCMode: PARERR Mask        */
#define USIC_CH_PSR_SSCMode_RSIF_Pos          10                                                      /*!< USIC_CH PSR_SSCMode: RSIF Position      */
#define USIC_CH_PSR_SSCMode_RSIF_Msk          (0x01UL << USIC_CH_PSR_SSCMode_RSIF_Pos)                /*!< USIC_CH PSR_SSCMode: RSIF Mask          */
#define USIC_CH_PSR_SSCMode_DLIF_Pos          11                                                      /*!< USIC_CH PSR_SSCMode: DLIF Position      */
#define USIC_CH_PSR_SSCMode_DLIF_Msk          (0x01UL << USIC_CH_PSR_SSCMode_DLIF_Pos)                /*!< USIC_CH PSR_SSCMode: DLIF Mask          */
#define USIC_CH_PSR_SSCMode_TSIF_Pos          12                                                      /*!< USIC_CH PSR_SSCMode: TSIF Position      */
#define USIC_CH_PSR_SSCMode_TSIF_Msk          (0x01UL << USIC_CH_PSR_SSCMode_TSIF_Pos)                /*!< USIC_CH PSR_SSCMode: TSIF Mask          */
#define USIC_CH_PSR_SSCMode_TBIF_Pos          13                                                      /*!< USIC_CH PSR_SSCMode: TBIF Position      */
#define USIC_CH_PSR_SSCMode_TBIF_Msk          (0x01UL << USIC_CH_PSR_SSCMode_TBIF_Pos)                /*!< USIC_CH PSR_SSCMode: TBIF Mask          */
#define USIC_CH_PSR_SSCMode_RIF_Pos           14                                                      /*!< USIC_CH PSR_SSCMode: RIF Position       */
#define USIC_CH_PSR_SSCMode_RIF_Msk           (0x01UL << USIC_CH_PSR_SSCMode_RIF_Pos)                 /*!< USIC_CH PSR_SSCMode: RIF Mask           */
#define USIC_CH_PSR_SSCMode_AIF_Pos           15                                                      /*!< USIC_CH PSR_SSCMode: AIF Position       */
#define USIC_CH_PSR_SSCMode_AIF_Msk           (0x01UL << USIC_CH_PSR_SSCMode_AIF_Pos)                 /*!< USIC_CH PSR_SSCMode: AIF Mask           */
#define USIC_CH_PSR_SSCMode_BRGIF_Pos         16                                                      /*!< USIC_CH PSR_SSCMode: BRGIF Position     */
#define USIC_CH_PSR_SSCMode_BRGIF_Msk         (0x01UL << USIC_CH_PSR_SSCMode_BRGIF_Pos)               /*!< USIC_CH PSR_SSCMode: BRGIF Mask         */

/* -----------------------------  USIC_CH_PSR_IICMode  ---------------------------- */
#define USIC_CH_PSR_IICMode_SLSEL_Pos         0                                                       /*!< USIC_CH PSR_IICMode: SLSEL Position     */
#define USIC_CH_PSR_IICMode_SLSEL_Msk         (0x01UL << USIC_CH_PSR_IICMode_SLSEL_Pos)               /*!< USIC_CH PSR_IICMode: SLSEL Mask         */
#define USIC_CH_PSR_IICMode_WTDF_Pos          1                                                       /*!< USIC_CH PSR_IICMode: WTDF Position      */
#define USIC_CH_PSR_IICMode_WTDF_Msk          (0x01UL << USIC_CH_PSR_IICMode_WTDF_Pos)                /*!< USIC_CH PSR_IICMode: WTDF Mask          */
#define USIC_CH_PSR_IICMode_SCR_Pos           2                                                       /*!< USIC_CH PSR_IICMode: SCR Position       */
#define USIC_CH_PSR_IICMode_SCR_Msk           (0x01UL << USIC_CH_PSR_IICMode_SCR_Pos)                 /*!< USIC_CH PSR_IICMode: SCR Mask           */
#define USIC_CH_PSR_IICMode_RSCR_Pos          3                                                       /*!< USIC_CH PSR_IICMode: RSCR Position      */
#define USIC_CH_PSR_IICMode_RSCR_Msk          (0x01UL << USIC_CH_PSR_IICMode_RSCR_Pos)                /*!< USIC_CH PSR_IICMode: RSCR Mask          */
#define USIC_CH_PSR_IICMode_PCR_Pos           4                                                       /*!< USIC_CH PSR_IICMode: PCR Position       */
#define USIC_CH_PSR_IICMode_PCR_Msk           (0x01UL << USIC_CH_PSR_IICMode_PCR_Pos)                 /*!< USIC_CH PSR_IICMode: PCR Mask           */
#define USIC_CH_PSR_IICMode_NACK_Pos          5                                                       /*!< USIC_CH PSR_IICMode: NACK Position      */
#define USIC_CH_PSR_IICMode_NACK_Msk          (0x01UL << USIC_CH_PSR_IICMode_NACK_Pos)                /*!< USIC_CH PSR_IICMode: NACK Mask          */
#define USIC_CH_PSR_IICMode_ARL_Pos           6                                                       /*!< USIC_CH PSR_IICMode: ARL Position       */
#define USIC_CH_PSR_IICMode_ARL_Msk           (0x01UL << USIC_CH_PSR_IICMode_ARL_Pos)                 /*!< USIC_CH PSR_IICMode: ARL Mask           */
#define USIC_CH_PSR_IICMode_SRR_Pos           7                                                       /*!< USIC_CH PSR_IICMode: SRR Position       */
#define USIC_CH_PSR_IICMode_SRR_Msk           (0x01UL << USIC_CH_PSR_IICMode_SRR_Pos)                 /*!< USIC_CH PSR_IICMode: SRR Mask           */
#define USIC_CH_PSR_IICMode_ERR_Pos           8                                                       /*!< USIC_CH PSR_IICMode: ERR Position       */
#define USIC_CH_PSR_IICMode_ERR_Msk           (0x01UL << USIC_CH_PSR_IICMode_ERR_Pos)                 /*!< USIC_CH PSR_IICMode: ERR Mask           */
#define USIC_CH_PSR_IICMode_ACK_Pos           9                                                       /*!< USIC_CH PSR_IICMode: ACK Position       */
#define USIC_CH_PSR_IICMode_ACK_Msk           (0x01UL << USIC_CH_PSR_IICMode_ACK_Pos)                 /*!< USIC_CH PSR_IICMode: ACK Mask           */
#define USIC_CH_PSR_IICMode_RSIF_Pos          10                                                      /*!< USIC_CH PSR_IICMode: RSIF Position      */
#define USIC_CH_PSR_IICMode_RSIF_Msk          (0x01UL << USIC_CH_PSR_IICMode_RSIF_Pos)                /*!< USIC_CH PSR_IICMode: RSIF Mask          */
#define USIC_CH_PSR_IICMode_DLIF_Pos          11                                                      /*!< USIC_CH PSR_IICMode: DLIF Position      */
#define USIC_CH_PSR_IICMode_DLIF_Msk          (0x01UL << USIC_CH_PSR_IICMode_DLIF_Pos)                /*!< USIC_CH PSR_IICMode: DLIF Mask          */
#define USIC_CH_PSR_IICMode_TSIF_Pos          12                                                      /*!< USIC_CH PSR_IICMode: TSIF Position      */
#define USIC_CH_PSR_IICMode_TSIF_Msk          (0x01UL << USIC_CH_PSR_IICMode_TSIF_Pos)                /*!< USIC_CH PSR_IICMode: TSIF Mask          */
#define USIC_CH_PSR_IICMode_TBIF_Pos          13                                                      /*!< USIC_CH PSR_IICMode: TBIF Position      */
#define USIC_CH_PSR_IICMode_TBIF_Msk          (0x01UL << USIC_CH_PSR_IICMode_TBIF_Pos)                /*!< USIC_CH PSR_IICMode: TBIF Mask          */
#define USIC_CH_PSR_IICMode_RIF_Pos           14                                                      /*!< USIC_CH PSR_IICMode: RIF Position       */
#define USIC_CH_PSR_IICMode_RIF_Msk           (0x01UL << USIC_CH_PSR_IICMode_RIF_Pos)                 /*!< USIC_CH PSR_IICMode: RIF Mask           */
#define USIC_CH_PSR_IICMode_AIF_Pos           15                                                      /*!< USIC_CH PSR_IICMode: AIF Position       */
#define USIC_CH_PSR_IICMode_AIF_Msk           (0x01UL << USIC_CH_PSR_IICMode_AIF_Pos)                 /*!< USIC_CH PSR_IICMode: AIF Mask           */
#define USIC_CH_PSR_IICMode_BRGIF_Pos         16                                                      /*!< USIC_CH PSR_IICMode: BRGIF Position     */
#define USIC_CH_PSR_IICMode_BRGIF_Msk         (0x01UL << USIC_CH_PSR_IICMode_BRGIF_Pos)               /*!< USIC_CH PSR_IICMode: BRGIF Mask         */

/* -----------------------------  USIC_CH_PSR_IISMode  ---------------------------- */
#define USIC_CH_PSR_IISMode_WA_Pos            0                                                       /*!< USIC_CH PSR_IISMode: WA Position        */
#define USIC_CH_PSR_IISMode_WA_Msk            (0x01UL << USIC_CH_PSR_IISMode_WA_Pos)                  /*!< USIC_CH PSR_IISMode: WA Mask            */
#define USIC_CH_PSR_IISMode_DX2S_Pos          1                                                       /*!< USIC_CH PSR_IISMode: DX2S Position      */
#define USIC_CH_PSR_IISMode_DX2S_Msk          (0x01UL << USIC_CH_PSR_IISMode_DX2S_Pos)                /*!< USIC_CH PSR_IISMode: DX2S Mask          */
#define USIC_CH_PSR_IISMode_DX2TEV_Pos        3                                                       /*!< USIC_CH PSR_IISMode: DX2TEV Position    */
#define USIC_CH_PSR_IISMode_DX2TEV_Msk        (0x01UL << USIC_CH_PSR_IISMode_DX2TEV_Pos)              /*!< USIC_CH PSR_IISMode: DX2TEV Mask        */
#define USIC_CH_PSR_IISMode_WAFE_Pos          4                                                       /*!< USIC_CH PSR_IISMode: WAFE Position      */
#define USIC_CH_PSR_IISMode_WAFE_Msk          (0x01UL << USIC_CH_PSR_IISMode_WAFE_Pos)                /*!< USIC_CH PSR_IISMode: WAFE Mask          */
#define USIC_CH_PSR_IISMode_WARE_Pos          5                                                       /*!< USIC_CH PSR_IISMode: WARE Position      */
#define USIC_CH_PSR_IISMode_WARE_Msk          (0x01UL << USIC_CH_PSR_IISMode_WARE_Pos)                /*!< USIC_CH PSR_IISMode: WARE Mask          */
#define USIC_CH_PSR_IISMode_END_Pos           6                                                       /*!< USIC_CH PSR_IISMode: END Position       */
#define USIC_CH_PSR_IISMode_END_Msk           (0x01UL << USIC_CH_PSR_IISMode_END_Pos)                 /*!< USIC_CH PSR_IISMode: END Mask           */
#define USIC_CH_PSR_IISMode_RSIF_Pos          10                                                      /*!< USIC_CH PSR_IISMode: RSIF Position      */
#define USIC_CH_PSR_IISMode_RSIF_Msk          (0x01UL << USIC_CH_PSR_IISMode_RSIF_Pos)                /*!< USIC_CH PSR_IISMode: RSIF Mask          */
#define USIC_CH_PSR_IISMode_DLIF_Pos          11                                                      /*!< USIC_CH PSR_IISMode: DLIF Position      */
#define USIC_CH_PSR_IISMode_DLIF_Msk          (0x01UL << USIC_CH_PSR_IISMode_DLIF_Pos)                /*!< USIC_CH PSR_IISMode: DLIF Mask          */
#define USIC_CH_PSR_IISMode_TSIF_Pos          12                                                      /*!< USIC_CH PSR_IISMode: TSIF Position      */
#define USIC_CH_PSR_IISMode_TSIF_Msk          (0x01UL << USIC_CH_PSR_IISMode_TSIF_Pos)                /*!< USIC_CH PSR_IISMode: TSIF Mask          */
#define USIC_CH_PSR_IISMode_TBIF_Pos          13                                                      /*!< USIC_CH PSR_IISMode: TBIF Position      */
#define USIC_CH_PSR_IISMode_TBIF_Msk          (0x01UL << USIC_CH_PSR_IISMode_TBIF_Pos)                /*!< USIC_CH PSR_IISMode: TBIF Mask          */
#define USIC_CH_PSR_IISMode_RIF_Pos           14                                                      /*!< USIC_CH PSR_IISMode: RIF Position       */
#define USIC_CH_PSR_IISMode_RIF_Msk           (0x01UL << USIC_CH_PSR_IISMode_RIF_Pos)                 /*!< USIC_CH PSR_IISMode: RIF Mask           */
#define USIC_CH_PSR_IISMode_AIF_Pos           15                                                      /*!< USIC_CH PSR_IISMode: AIF Position       */
#define USIC_CH_PSR_IISMode_AIF_Msk           (0x01UL << USIC_CH_PSR_IISMode_AIF_Pos)                 /*!< USIC_CH PSR_IISMode: AIF Mask           */
#define USIC_CH_PSR_IISMode_BRGIF_Pos         16                                                      /*!< USIC_CH PSR_IISMode: BRGIF Position     */
#define USIC_CH_PSR_IISMode_BRGIF_Msk         (0x01UL << USIC_CH_PSR_IISMode_BRGIF_Pos)               /*!< USIC_CH PSR_IISMode: BRGIF Mask         */

/* --------------------------------  USIC_CH_PSCR  -------------------------------- */
#define USIC_CH_PSCR_CST0_Pos                 0                                                       /*!< USIC_CH PSCR: CST0 Position             */
#define USIC_CH_PSCR_CST0_Msk                 (0x01UL << USIC_CH_PSCR_CST0_Pos)                       /*!< USIC_CH PSCR: CST0 Mask                 */
#define USIC_CH_PSCR_CST1_Pos                 1                                                       /*!< USIC_CH PSCR: CST1 Position             */
#define USIC_CH_PSCR_CST1_Msk                 (0x01UL << USIC_CH_PSCR_CST1_Pos)                       /*!< USIC_CH PSCR: CST1 Mask                 */
#define USIC_CH_PSCR_CST2_Pos                 2                                                       /*!< USIC_CH PSCR: CST2 Position             */
#define USIC_CH_PSCR_CST2_Msk                 (0x01UL << USIC_CH_PSCR_CST2_Pos)                       /*!< USIC_CH PSCR: CST2 Mask                 */
#define USIC_CH_PSCR_CST3_Pos                 3                                                       /*!< USIC_CH PSCR: CST3 Position             */
#define USIC_CH_PSCR_CST3_Msk                 (0x01UL << USIC_CH_PSCR_CST3_Pos)                       /*!< USIC_CH PSCR: CST3 Mask                 */
#define USIC_CH_PSCR_CST4_Pos                 4                                                       /*!< USIC_CH PSCR: CST4 Position             */
#define USIC_CH_PSCR_CST4_Msk                 (0x01UL << USIC_CH_PSCR_CST4_Pos)                       /*!< USIC_CH PSCR: CST4 Mask                 */
#define USIC_CH_PSCR_CST5_Pos                 5                                                       /*!< USIC_CH PSCR: CST5 Position             */
#define USIC_CH_PSCR_CST5_Msk                 (0x01UL << USIC_CH_PSCR_CST5_Pos)                       /*!< USIC_CH PSCR: CST5 Mask                 */
#define USIC_CH_PSCR_CST6_Pos                 6                                                       /*!< USIC_CH PSCR: CST6 Position             */
#define USIC_CH_PSCR_CST6_Msk                 (0x01UL << USIC_CH_PSCR_CST6_Pos)                       /*!< USIC_CH PSCR: CST6 Mask                 */
#define USIC_CH_PSCR_CST7_Pos                 7                                                       /*!< USIC_CH PSCR: CST7 Position             */
#define USIC_CH_PSCR_CST7_Msk                 (0x01UL << USIC_CH_PSCR_CST7_Pos)                       /*!< USIC_CH PSCR: CST7 Mask                 */
#define USIC_CH_PSCR_CST8_Pos                 8                                                       /*!< USIC_CH PSCR: CST8 Position             */
#define USIC_CH_PSCR_CST8_Msk                 (0x01UL << USIC_CH_PSCR_CST8_Pos)                       /*!< USIC_CH PSCR: CST8 Mask                 */
#define USIC_CH_PSCR_CST9_Pos                 9                                                       /*!< USIC_CH PSCR: CST9 Position             */
#define USIC_CH_PSCR_CST9_Msk                 (0x01UL << USIC_CH_PSCR_CST9_Pos)                       /*!< USIC_CH PSCR: CST9 Mask                 */
#define USIC_CH_PSCR_CRSIF_Pos                10                                                      /*!< USIC_CH PSCR: CRSIF Position            */
#define USIC_CH_PSCR_CRSIF_Msk                (0x01UL << USIC_CH_PSCR_CRSIF_Pos)                      /*!< USIC_CH PSCR: CRSIF Mask                */
#define USIC_CH_PSCR_CDLIF_Pos                11                                                      /*!< USIC_CH PSCR: CDLIF Position            */
#define USIC_CH_PSCR_CDLIF_Msk                (0x01UL << USIC_CH_PSCR_CDLIF_Pos)                      /*!< USIC_CH PSCR: CDLIF Mask                */
#define USIC_CH_PSCR_CTSIF_Pos                12                                                      /*!< USIC_CH PSCR: CTSIF Position            */
#define USIC_CH_PSCR_CTSIF_Msk                (0x01UL << USIC_CH_PSCR_CTSIF_Pos)                      /*!< USIC_CH PSCR: CTSIF Mask                */
#define USIC_CH_PSCR_CTBIF_Pos                13                                                      /*!< USIC_CH PSCR: CTBIF Position            */
#define USIC_CH_PSCR_CTBIF_Msk                (0x01UL << USIC_CH_PSCR_CTBIF_Pos)                      /*!< USIC_CH PSCR: CTBIF Mask                */
#define USIC_CH_PSCR_CRIF_Pos                 14                                                      /*!< USIC_CH PSCR: CRIF Position             */
#define USIC_CH_PSCR_CRIF_Msk                 (0x01UL << USIC_CH_PSCR_CRIF_Pos)                       /*!< USIC_CH PSCR: CRIF Mask                 */
#define USIC_CH_PSCR_CAIF_Pos                 15                                                      /*!< USIC_CH PSCR: CAIF Position             */
#define USIC_CH_PSCR_CAIF_Msk                 (0x01UL << USIC_CH_PSCR_CAIF_Pos)                       /*!< USIC_CH PSCR: CAIF Mask                 */
#define USIC_CH_PSCR_CBRGIF_Pos               16                                                      /*!< USIC_CH PSCR: CBRGIF Position           */
#define USIC_CH_PSCR_CBRGIF_Msk               (0x01UL << USIC_CH_PSCR_CBRGIF_Pos)                     /*!< USIC_CH PSCR: CBRGIF Mask               */

/* -------------------------------  USIC_CH_RBUFSR  ------------------------------- */
#define USIC_CH_RBUFSR_WLEN_Pos               0                                                       /*!< USIC_CH RBUFSR: WLEN Position           */
#define USIC_CH_RBUFSR_WLEN_Msk               (0x0fUL << USIC_CH_RBUFSR_WLEN_Pos)                     /*!< USIC_CH RBUFSR: WLEN Mask               */
#define USIC_CH_RBUFSR_SOF_Pos                6                                                       /*!< USIC_CH RBUFSR: SOF Position            */
#define USIC_CH_RBUFSR_SOF_Msk                (0x01UL << USIC_CH_RBUFSR_SOF_Pos)                      /*!< USIC_CH RBUFSR: SOF Mask                */
#define USIC_CH_RBUFSR_PAR_Pos                8                                                       /*!< USIC_CH RBUFSR: PAR Position            */
#define USIC_CH_RBUFSR_PAR_Msk                (0x01UL << USIC_CH_RBUFSR_PAR_Pos)                      /*!< USIC_CH RBUFSR: PAR Mask                */
#define USIC_CH_RBUFSR_PERR_Pos               9                                                       /*!< USIC_CH RBUFSR: PERR Position           */
#define USIC_CH_RBUFSR_PERR_Msk               (0x01UL << USIC_CH_RBUFSR_PERR_Pos)                     /*!< USIC_CH RBUFSR: PERR Mask               */
#define USIC_CH_RBUFSR_RDV0_Pos               13                                                      /*!< USIC_CH RBUFSR: RDV0 Position           */
#define USIC_CH_RBUFSR_RDV0_Msk               (0x01UL << USIC_CH_RBUFSR_RDV0_Pos)                     /*!< USIC_CH RBUFSR: RDV0 Mask               */
#define USIC_CH_RBUFSR_RDV1_Pos               14                                                      /*!< USIC_CH RBUFSR: RDV1 Position           */
#define USIC_CH_RBUFSR_RDV1_Msk               (0x01UL << USIC_CH_RBUFSR_RDV1_Pos)                     /*!< USIC_CH RBUFSR: RDV1 Mask               */
#define USIC_CH_RBUFSR_DS_Pos                 15                                                      /*!< USIC_CH RBUFSR: DS Position             */
#define USIC_CH_RBUFSR_DS_Msk                 (0x01UL << USIC_CH_RBUFSR_DS_Pos)                       /*!< USIC_CH RBUFSR: DS Mask                 */

/* --------------------------------  USIC_CH_RBUF  -------------------------------- */
#define USIC_CH_RBUF_DSR_Pos                  0                                                       /*!< USIC_CH RBUF: DSR Position              */
#define USIC_CH_RBUF_DSR_Msk                  (0x0000ffffUL << USIC_CH_RBUF_DSR_Pos)                  /*!< USIC_CH RBUF: DSR Mask                  */

/* --------------------------------  USIC_CH_RBUFD  ------------------------------- */
#define USIC_CH_RBUFD_DSR_Pos                 0                                                       /*!< USIC_CH RBUFD: DSR Position             */
#define USIC_CH_RBUFD_DSR_Msk                 (0x0000ffffUL << USIC_CH_RBUFD_DSR_Pos)                 /*!< USIC_CH RBUFD: DSR Mask                 */

/* --------------------------------  USIC_CH_RBUF0  ------------------------------- */
#define USIC_CH_RBUF0_DSR0_Pos                0                                                       /*!< USIC_CH RBUF0: DSR0 Position            */
#define USIC_CH_RBUF0_DSR0_Msk                (0x0000ffffUL << USIC_CH_RBUF0_DSR0_Pos)                /*!< USIC_CH RBUF0: DSR0 Mask                */

/* --------------------------------  USIC_CH_RBUF1  ------------------------------- */
#define USIC_CH_RBUF1_DSR1_Pos                0                                                       /*!< USIC_CH RBUF1: DSR1 Position            */
#define USIC_CH_RBUF1_DSR1_Msk                (0x0000ffffUL << USIC_CH_RBUF1_DSR1_Pos)                /*!< USIC_CH RBUF1: DSR1 Mask                */

/* ------------------------------  USIC_CH_RBUF01SR  ------------------------------ */
#define USIC_CH_RBUF01SR_WLEN0_Pos            0                                                       /*!< USIC_CH RBUF01SR: WLEN0 Position        */
#define USIC_CH_RBUF01SR_WLEN0_Msk            (0x0fUL << USIC_CH_RBUF01SR_WLEN0_Pos)                  /*!< USIC_CH RBUF01SR: WLEN0 Mask            */
#define USIC_CH_RBUF01SR_SOF0_Pos             6                                                       /*!< USIC_CH RBUF01SR: SOF0 Position         */
#define USIC_CH_RBUF01SR_SOF0_Msk             (0x01UL << USIC_CH_RBUF01SR_SOF0_Pos)                   /*!< USIC_CH RBUF01SR: SOF0 Mask             */
#define USIC_CH_RBUF01SR_PAR0_Pos             8                                                       /*!< USIC_CH RBUF01SR: PAR0 Position         */
#define USIC_CH_RBUF01SR_PAR0_Msk             (0x01UL << USIC_CH_RBUF01SR_PAR0_Pos)                   /*!< USIC_CH RBUF01SR: PAR0 Mask             */
#define USIC_CH_RBUF01SR_PERR0_Pos            9                                                       /*!< USIC_CH RBUF01SR: PERR0 Position        */
#define USIC_CH_RBUF01SR_PERR0_Msk            (0x01UL << USIC_CH_RBUF01SR_PERR0_Pos)                  /*!< USIC_CH RBUF01SR: PERR0 Mask            */
#define USIC_CH_RBUF01SR_RDV00_Pos            13                                                      /*!< USIC_CH RBUF01SR: RDV00 Position        */
#define USIC_CH_RBUF01SR_RDV00_Msk            (0x01UL << USIC_CH_RBUF01SR_RDV00_Pos)                  /*!< USIC_CH RBUF01SR: RDV00 Mask            */
#define USIC_CH_RBUF01SR_RDV01_Pos            14                                                      /*!< USIC_CH RBUF01SR: RDV01 Position        */
#define USIC_CH_RBUF01SR_RDV01_Msk            (0x01UL << USIC_CH_RBUF01SR_RDV01_Pos)                  /*!< USIC_CH RBUF01SR: RDV01 Mask            */
#define USIC_CH_RBUF01SR_DS0_Pos              15                                                      /*!< USIC_CH RBUF01SR: DS0 Position          */
#define USIC_CH_RBUF01SR_DS0_Msk              (0x01UL << USIC_CH_RBUF01SR_DS0_Pos)                    /*!< USIC_CH RBUF01SR: DS0 Mask              */
#define USIC_CH_RBUF01SR_WLEN1_Pos            16                                                      /*!< USIC_CH RBUF01SR: WLEN1 Position        */
#define USIC_CH_RBUF01SR_WLEN1_Msk            (0x0fUL << USIC_CH_RBUF01SR_WLEN1_Pos)                  /*!< USIC_CH RBUF01SR: WLEN1 Mask            */
#define USIC_CH_RBUF01SR_SOF1_Pos             22                                                      /*!< USIC_CH RBUF01SR: SOF1 Position         */
#define USIC_CH_RBUF01SR_SOF1_Msk             (0x01UL << USIC_CH_RBUF01SR_SOF1_Pos)                   /*!< USIC_CH RBUF01SR: SOF1 Mask             */
#define USIC_CH_RBUF01SR_PAR1_Pos             24                                                      /*!< USIC_CH RBUF01SR: PAR1 Position         */
#define USIC_CH_RBUF01SR_PAR1_Msk             (0x01UL << USIC_CH_RBUF01SR_PAR1_Pos)                   /*!< USIC_CH RBUF01SR: PAR1 Mask             */
#define USIC_CH_RBUF01SR_PERR1_Pos            25                                                      /*!< USIC_CH RBUF01SR: PERR1 Position        */
#define USIC_CH_RBUF01SR_PERR1_Msk            (0x01UL << USIC_CH_RBUF01SR_PERR1_Pos)                  /*!< USIC_CH RBUF01SR: PERR1 Mask            */
#define USIC_CH_RBUF01SR_RDV10_Pos            29                                                      /*!< USIC_CH RBUF01SR: RDV10 Position        */
#define USIC_CH_RBUF01SR_RDV10_Msk            (0x01UL << USIC_CH_RBUF01SR_RDV10_Pos)                  /*!< USIC_CH RBUF01SR: RDV10 Mask            */
#define USIC_CH_RBUF01SR_RDV11_Pos            30                                                      /*!< USIC_CH RBUF01SR: RDV11 Position        */
#define USIC_CH_RBUF01SR_RDV11_Msk            (0x01UL << USIC_CH_RBUF01SR_RDV11_Pos)                  /*!< USIC_CH RBUF01SR: RDV11 Mask            */
#define USIC_CH_RBUF01SR_DS1_Pos              31                                                      /*!< USIC_CH RBUF01SR: DS1 Position          */
#define USIC_CH_RBUF01SR_DS1_Msk              (0x01UL << USIC_CH_RBUF01SR_DS1_Pos)                    /*!< USIC_CH RBUF01SR: DS1 Mask              */

/* ---------------------------------  USIC_CH_FMR  -------------------------------- */
#define USIC_CH_FMR_MTDV_Pos                  0                                                       /*!< USIC_CH FMR: MTDV Position              */
#define USIC_CH_FMR_MTDV_Msk                  (0x03UL << USIC_CH_FMR_MTDV_Pos)                        /*!< USIC_CH FMR: MTDV Mask                  */
#define USIC_CH_FMR_ATVC_Pos                  4                                                       /*!< USIC_CH FMR: ATVC Position              */
#define USIC_CH_FMR_ATVC_Msk                  (0x01UL << USIC_CH_FMR_ATVC_Pos)                        /*!< USIC_CH FMR: ATVC Mask                  */
#define USIC_CH_FMR_CRDV0_Pos                 14                                                      /*!< USIC_CH FMR: CRDV0 Position             */
#define USIC_CH_FMR_CRDV0_Msk                 (0x01UL << USIC_CH_FMR_CRDV0_Pos)                       /*!< USIC_CH FMR: CRDV0 Mask                 */
#define USIC_CH_FMR_CRDV1_Pos                 15                                                      /*!< USIC_CH FMR: CRDV1 Position             */
#define USIC_CH_FMR_CRDV1_Msk                 (0x01UL << USIC_CH_FMR_CRDV1_Pos)                       /*!< USIC_CH FMR: CRDV1 Mask                 */
#define USIC_CH_FMR_SIO0_Pos                  16                                                      /*!< USIC_CH FMR: SIO0 Position              */
#define USIC_CH_FMR_SIO0_Msk                  (0x01UL << USIC_CH_FMR_SIO0_Pos)                        /*!< USIC_CH FMR: SIO0 Mask                  */
#define USIC_CH_FMR_SIO1_Pos                  17                                                      /*!< USIC_CH FMR: SIO1 Position              */
#define USIC_CH_FMR_SIO1_Msk                  (0x01UL << USIC_CH_FMR_SIO1_Pos)                        /*!< USIC_CH FMR: SIO1 Mask                  */
#define USIC_CH_FMR_SIO2_Pos                  18                                                      /*!< USIC_CH FMR: SIO2 Position              */
#define USIC_CH_FMR_SIO2_Msk                  (0x01UL << USIC_CH_FMR_SIO2_Pos)                        /*!< USIC_CH FMR: SIO2 Mask                  */
#define USIC_CH_FMR_SIO3_Pos                  19                                                      /*!< USIC_CH FMR: SIO3 Position              */
#define USIC_CH_FMR_SIO3_Msk                  (0x01UL << USIC_CH_FMR_SIO3_Pos)                        /*!< USIC_CH FMR: SIO3 Mask                  */
#define USIC_CH_FMR_SIO4_Pos                  20                                                      /*!< USIC_CH FMR: SIO4 Position              */
#define USIC_CH_FMR_SIO4_Msk                  (0x01UL << USIC_CH_FMR_SIO4_Pos)                        /*!< USIC_CH FMR: SIO4 Mask                  */
#define USIC_CH_FMR_SIO5_Pos                  21                                                      /*!< USIC_CH FMR: SIO5 Position              */
#define USIC_CH_FMR_SIO5_Msk                  (0x01UL << USIC_CH_FMR_SIO5_Pos)                        /*!< USIC_CH FMR: SIO5 Mask                  */

/* --------------------------------  USIC_CH_TBUF  -------------------------------- */
#define USIC_CH_TBUF_TDATA_Pos                0                                                       /*!< USIC_CH TBUF: TDATA Position            */
#define USIC_CH_TBUF_TDATA_Msk                (0x0000ffffUL << USIC_CH_TBUF_TDATA_Pos)                /*!< USIC_CH TBUF: TDATA Mask                */

/* ---------------------------------  USIC_CH_BYP  -------------------------------- */
#define USIC_CH_BYP_BDATA_Pos                 0                                                       /*!< USIC_CH BYP: BDATA Position             */
#define USIC_CH_BYP_BDATA_Msk                 (0x0000ffffUL << USIC_CH_BYP_BDATA_Pos)                 /*!< USIC_CH BYP: BDATA Mask                 */

/* --------------------------------  USIC_CH_BYPCR  ------------------------------- */
#define USIC_CH_BYPCR_BWLE_Pos                0                                                       /*!< USIC_CH BYPCR: BWLE Position            */
#define USIC_CH_BYPCR_BWLE_Msk                (0x0fUL << USIC_CH_BYPCR_BWLE_Pos)                      /*!< USIC_CH BYPCR: BWLE Mask                */
#define USIC_CH_BYPCR_BDSSM_Pos               8                                                       /*!< USIC_CH BYPCR: BDSSM Position           */
#define USIC_CH_BYPCR_BDSSM_Msk               (0x01UL << USIC_CH_BYPCR_BDSSM_Pos)                     /*!< USIC_CH BYPCR: BDSSM Mask               */
#define USIC_CH_BYPCR_BDEN_Pos                10                                                      /*!< USIC_CH BYPCR: BDEN Position            */
#define USIC_CH_BYPCR_BDEN_Msk                (0x03UL << USIC_CH_BYPCR_BDEN_Pos)                      /*!< USIC_CH BYPCR: BDEN Mask                */
#define USIC_CH_BYPCR_BDVTR_Pos               12                                                      /*!< USIC_CH BYPCR: BDVTR Position           */
#define USIC_CH_BYPCR_BDVTR_Msk               (0x01UL << USIC_CH_BYPCR_BDVTR_Pos)                     /*!< USIC_CH BYPCR: BDVTR Mask               */
#define USIC_CH_BYPCR_BPRIO_Pos               13                                                      /*!< USIC_CH BYPCR: BPRIO Position           */
#define USIC_CH_BYPCR_BPRIO_Msk               (0x01UL << USIC_CH_BYPCR_BPRIO_Pos)                     /*!< USIC_CH BYPCR: BPRIO Mask               */
#define USIC_CH_BYPCR_BDV_Pos                 15                                                      /*!< USIC_CH BYPCR: BDV Position             */
#define USIC_CH_BYPCR_BDV_Msk                 (0x01UL << USIC_CH_BYPCR_BDV_Pos)                       /*!< USIC_CH BYPCR: BDV Mask                 */
#define USIC_CH_BYPCR_BSELO_Pos               16                                                      /*!< USIC_CH BYPCR: BSELO Position           */
#define USIC_CH_BYPCR_BSELO_Msk               (0x1fUL << USIC_CH_BYPCR_BSELO_Pos)                     /*!< USIC_CH BYPCR: BSELO Mask               */
#define USIC_CH_BYPCR_BHPC_Pos                21                                                      /*!< USIC_CH BYPCR: BHPC Position            */
#define USIC_CH_BYPCR_BHPC_Msk                (0x07UL << USIC_CH_BYPCR_BHPC_Pos)                      /*!< USIC_CH BYPCR: BHPC Mask                */

/* --------------------------------  USIC_CH_TBCTR  ------------------------------- */
#define USIC_CH_TBCTR_DPTR_Pos                0                                                       /*!< USIC_CH TBCTR: DPTR Position            */
#define USIC_CH_TBCTR_DPTR_Msk                (0x3fUL << USIC_CH_TBCTR_DPTR_Pos)                      /*!< USIC_CH TBCTR: DPTR Mask                */
#define USIC_CH_TBCTR_LIMIT_Pos               8                                                       /*!< USIC_CH TBCTR: LIMIT Position           */
#define USIC_CH_TBCTR_LIMIT_Msk               (0x3fUL << USIC_CH_TBCTR_LIMIT_Pos)                     /*!< USIC_CH TBCTR: LIMIT Mask               */
#define USIC_CH_TBCTR_STBTM_Pos               14                                                      /*!< USIC_CH TBCTR: STBTM Position           */
#define USIC_CH_TBCTR_STBTM_Msk               (0x01UL << USIC_CH_TBCTR_STBTM_Pos)                     /*!< USIC_CH TBCTR: STBTM Mask               */
#define USIC_CH_TBCTR_STBTEN_Pos              15                                                      /*!< USIC_CH TBCTR: STBTEN Position          */
#define USIC_CH_TBCTR_STBTEN_Msk              (0x01UL << USIC_CH_TBCTR_STBTEN_Pos)                    /*!< USIC_CH TBCTR: STBTEN Mask              */
#define USIC_CH_TBCTR_STBINP_Pos              16                                                      /*!< USIC_CH TBCTR: STBINP Position          */
#define USIC_CH_TBCTR_STBINP_Msk              (0x07UL << USIC_CH_TBCTR_STBINP_Pos)                    /*!< USIC_CH TBCTR: STBINP Mask              */
#define USIC_CH_TBCTR_ATBINP_Pos              19                                                      /*!< USIC_CH TBCTR: ATBINP Position          */
#define USIC_CH_TBCTR_ATBINP_Msk              (0x07UL << USIC_CH_TBCTR_ATBINP_Pos)                    /*!< USIC_CH TBCTR: ATBINP Mask              */
#define USIC_CH_TBCTR_SIZE_Pos                24                                                      /*!< USIC_CH TBCTR: SIZE Position            */
#define USIC_CH_TBCTR_SIZE_Msk                (0x07UL << USIC_CH_TBCTR_SIZE_Pos)                      /*!< USIC_CH TBCTR: SIZE Mask                */
#define USIC_CH_TBCTR_LOF_Pos                 28                                                      /*!< USIC_CH TBCTR: LOF Position             */
#define USIC_CH_TBCTR_LOF_Msk                 (0x01UL << USIC_CH_TBCTR_LOF_Pos)                       /*!< USIC_CH TBCTR: LOF Mask                 */
#define USIC_CH_TBCTR_STBIEN_Pos              30                                                      /*!< USIC_CH TBCTR: STBIEN Position          */
#define USIC_CH_TBCTR_STBIEN_Msk              (0x01UL << USIC_CH_TBCTR_STBIEN_Pos)                    /*!< USIC_CH TBCTR: STBIEN Mask              */
#define USIC_CH_TBCTR_TBERIEN_Pos             31                                                      /*!< USIC_CH TBCTR: TBERIEN Position         */
#define USIC_CH_TBCTR_TBERIEN_Msk             (0x01UL << USIC_CH_TBCTR_TBERIEN_Pos)                   /*!< USIC_CH TBCTR: TBERIEN Mask             */

/* --------------------------------  USIC_CH_RBCTR  ------------------------------- */
#define USIC_CH_RBCTR_DPTR_Pos                0                                                       /*!< USIC_CH RBCTR: DPTR Position            */
#define USIC_CH_RBCTR_DPTR_Msk                (0x3fUL << USIC_CH_RBCTR_DPTR_Pos)                      /*!< USIC_CH RBCTR: DPTR Mask                */
#define USIC_CH_RBCTR_LIMIT_Pos               8                                                       /*!< USIC_CH RBCTR: LIMIT Position           */
#define USIC_CH_RBCTR_LIMIT_Msk               (0x3fUL << USIC_CH_RBCTR_LIMIT_Pos)                     /*!< USIC_CH RBCTR: LIMIT Mask               */
#define USIC_CH_RBCTR_SRBTM_Pos               14                                                      /*!< USIC_CH RBCTR: SRBTM Position           */
#define USIC_CH_RBCTR_SRBTM_Msk               (0x01UL << USIC_CH_RBCTR_SRBTM_Pos)                     /*!< USIC_CH RBCTR: SRBTM Mask               */
#define USIC_CH_RBCTR_SRBTEN_Pos              15                                                      /*!< USIC_CH RBCTR: SRBTEN Position          */
#define USIC_CH_RBCTR_SRBTEN_Msk              (0x01UL << USIC_CH_RBCTR_SRBTEN_Pos)                    /*!< USIC_CH RBCTR: SRBTEN Mask              */
#define USIC_CH_RBCTR_SRBINP_Pos              16                                                      /*!< USIC_CH RBCTR: SRBINP Position          */
#define USIC_CH_RBCTR_SRBINP_Msk              (0x07UL << USIC_CH_RBCTR_SRBINP_Pos)                    /*!< USIC_CH RBCTR: SRBINP Mask              */
#define USIC_CH_RBCTR_ARBINP_Pos              19                                                      /*!< USIC_CH RBCTR: ARBINP Position          */
#define USIC_CH_RBCTR_ARBINP_Msk              (0x07UL << USIC_CH_RBCTR_ARBINP_Pos)                    /*!< USIC_CH RBCTR: ARBINP Mask              */
#define USIC_CH_RBCTR_RCIM_Pos                22                                                      /*!< USIC_CH RBCTR: RCIM Position            */
#define USIC_CH_RBCTR_RCIM_Msk                (0x03UL << USIC_CH_RBCTR_RCIM_Pos)                      /*!< USIC_CH RBCTR: RCIM Mask                */
#define USIC_CH_RBCTR_SIZE_Pos                24                                                      /*!< USIC_CH RBCTR: SIZE Position            */
#define USIC_CH_RBCTR_SIZE_Msk                (0x07UL << USIC_CH_RBCTR_SIZE_Pos)                      /*!< USIC_CH RBCTR: SIZE Mask                */
#define USIC_CH_RBCTR_RNM_Pos                 27                                                      /*!< USIC_CH RBCTR: RNM Position             */
#define USIC_CH_RBCTR_RNM_Msk                 (0x01UL << USIC_CH_RBCTR_RNM_Pos)                       /*!< USIC_CH RBCTR: RNM Mask                 */
#define USIC_CH_RBCTR_LOF_Pos                 28                                                      /*!< USIC_CH RBCTR: LOF Position             */
#define USIC_CH_RBCTR_LOF_Msk                 (0x01UL << USIC_CH_RBCTR_LOF_Pos)                       /*!< USIC_CH RBCTR: LOF Mask                 */
#define USIC_CH_RBCTR_ARBIEN_Pos              29                                                      /*!< USIC_CH RBCTR: ARBIEN Position          */
#define USIC_CH_RBCTR_ARBIEN_Msk              (0x01UL << USIC_CH_RBCTR_ARBIEN_Pos)                    /*!< USIC_CH RBCTR: ARBIEN Mask              */
#define USIC_CH_RBCTR_SRBIEN_Pos              30                                                      /*!< USIC_CH RBCTR: SRBIEN Position          */
#define USIC_CH_RBCTR_SRBIEN_Msk              (0x01UL << USIC_CH_RBCTR_SRBIEN_Pos)                    /*!< USIC_CH RBCTR: SRBIEN Mask              */
#define USIC_CH_RBCTR_RBERIEN_Pos             31                                                      /*!< USIC_CH RBCTR: RBERIEN Position         */
#define USIC_CH_RBCTR_RBERIEN_Msk             (0x01UL << USIC_CH_RBCTR_RBERIEN_Pos)                   /*!< USIC_CH RBCTR: RBERIEN Mask             */

/* -------------------------------  USIC_CH_TRBPTR  ------------------------------- */
#define USIC_CH_TRBPTR_TDIPTR_Pos             0                                                       /*!< USIC_CH TRBPTR: TDIPTR Position         */
#define USIC_CH_TRBPTR_TDIPTR_Msk             (0x3fUL << USIC_CH_TRBPTR_TDIPTR_Pos)                   /*!< USIC_CH TRBPTR: TDIPTR Mask             */
#define USIC_CH_TRBPTR_TDOPTR_Pos             8                                                       /*!< USIC_CH TRBPTR: TDOPTR Position         */
#define USIC_CH_TRBPTR_TDOPTR_Msk             (0x3fUL << USIC_CH_TRBPTR_TDOPTR_Pos)                   /*!< USIC_CH TRBPTR: TDOPTR Mask             */
#define USIC_CH_TRBPTR_RDIPTR_Pos             16                                                      /*!< USIC_CH TRBPTR: RDIPTR Position         */
#define USIC_CH_TRBPTR_RDIPTR_Msk             (0x3fUL << USIC_CH_TRBPTR_RDIPTR_Pos)                   /*!< USIC_CH TRBPTR: RDIPTR Mask             */
#define USIC_CH_TRBPTR_RDOPTR_Pos             24                                                      /*!< USIC_CH TRBPTR: RDOPTR Position         */
#define USIC_CH_TRBPTR_RDOPTR_Msk             (0x3fUL << USIC_CH_TRBPTR_RDOPTR_Pos)                   /*!< USIC_CH TRBPTR: RDOPTR Mask             */

/* --------------------------------  USIC_CH_TRBSR  ------------------------------- */
#define USIC_CH_TRBSR_SRBI_Pos                0                                                       /*!< USIC_CH TRBSR: SRBI Position            */
#define USIC_CH_TRBSR_SRBI_Msk                (0x01UL << USIC_CH_TRBSR_SRBI_Pos)                      /*!< USIC_CH TRBSR: SRBI Mask                */
#define USIC_CH_TRBSR_RBERI_Pos               1                                                       /*!< USIC_CH TRBSR: RBERI Position           */
#define USIC_CH_TRBSR_RBERI_Msk               (0x01UL << USIC_CH_TRBSR_RBERI_Pos)                     /*!< USIC_CH TRBSR: RBERI Mask               */
#define USIC_CH_TRBSR_ARBI_Pos                2                                                       /*!< USIC_CH TRBSR: ARBI Position            */
#define USIC_CH_TRBSR_ARBI_Msk                (0x01UL << USIC_CH_TRBSR_ARBI_Pos)                      /*!< USIC_CH TRBSR: ARBI Mask                */
#define USIC_CH_TRBSR_REMPTY_Pos              3                                                       /*!< USIC_CH TRBSR: REMPTY Position          */
#define USIC_CH_TRBSR_REMPTY_Msk              (0x01UL << USIC_CH_TRBSR_REMPTY_Pos)                    /*!< USIC_CH TRBSR: REMPTY Mask              */
#define USIC_CH_TRBSR_RFULL_Pos               4                                                       /*!< USIC_CH TRBSR: RFULL Position           */
#define USIC_CH_TRBSR_RFULL_Msk               (0x01UL << USIC_CH_TRBSR_RFULL_Pos)                     /*!< USIC_CH TRBSR: RFULL Mask               */
#define USIC_CH_TRBSR_RBUS_Pos                5                                                       /*!< USIC_CH TRBSR: RBUS Position            */
#define USIC_CH_TRBSR_RBUS_Msk                (0x01UL << USIC_CH_TRBSR_RBUS_Pos)                      /*!< USIC_CH TRBSR: RBUS Mask                */
#define USIC_CH_TRBSR_SRBT_Pos                6                                                       /*!< USIC_CH TRBSR: SRBT Position            */
#define USIC_CH_TRBSR_SRBT_Msk                (0x01UL << USIC_CH_TRBSR_SRBT_Pos)                      /*!< USIC_CH TRBSR: SRBT Mask                */
#define USIC_CH_TRBSR_STBI_Pos                8                                                       /*!< USIC_CH TRBSR: STBI Position            */
#define USIC_CH_TRBSR_STBI_Msk                (0x01UL << USIC_CH_TRBSR_STBI_Pos)                      /*!< USIC_CH TRBSR: STBI Mask                */
#define USIC_CH_TRBSR_TBERI_Pos               9                                                       /*!< USIC_CH TRBSR: TBERI Position           */
#define USIC_CH_TRBSR_TBERI_Msk               (0x01UL << USIC_CH_TRBSR_TBERI_Pos)                     /*!< USIC_CH TRBSR: TBERI Mask               */
#define USIC_CH_TRBSR_TEMPTY_Pos              11                                                      /*!< USIC_CH TRBSR: TEMPTY Position          */
#define USIC_CH_TRBSR_TEMPTY_Msk              (0x01UL << USIC_CH_TRBSR_TEMPTY_Pos)                    /*!< USIC_CH TRBSR: TEMPTY Mask              */
#define USIC_CH_TRBSR_TFULL_Pos               12                                                      /*!< USIC_CH TRBSR: TFULL Position           */
#define USIC_CH_TRBSR_TFULL_Msk               (0x01UL << USIC_CH_TRBSR_TFULL_Pos)                     /*!< USIC_CH TRBSR: TFULL Mask               */
#define USIC_CH_TRBSR_TBUS_Pos                13                                                      /*!< USIC_CH TRBSR: TBUS Position            */
#define USIC_CH_TRBSR_TBUS_Msk                (0x01UL << USIC_CH_TRBSR_TBUS_Pos)                      /*!< USIC_CH TRBSR: TBUS Mask                */
#define USIC_CH_TRBSR_STBT_Pos                14                                                      /*!< USIC_CH TRBSR: STBT Position            */
#define USIC_CH_TRBSR_STBT_Msk                (0x01UL << USIC_CH_TRBSR_STBT_Pos)                      /*!< USIC_CH TRBSR: STBT Mask                */
#define USIC_CH_TRBSR_RBFLVL_Pos              16                                                      /*!< USIC_CH TRBSR: RBFLVL Position          */
#define USIC_CH_TRBSR_RBFLVL_Msk              (0x7fUL << USIC_CH_TRBSR_RBFLVL_Pos)                    /*!< USIC_CH TRBSR: RBFLVL Mask              */
#define USIC_CH_TRBSR_TBFLVL_Pos              24                                                      /*!< USIC_CH TRBSR: TBFLVL Position          */
#define USIC_CH_TRBSR_TBFLVL_Msk              (0x7fUL << USIC_CH_TRBSR_TBFLVL_Pos)                    /*!< USIC_CH TRBSR: TBFLVL Mask              */

/* -------------------------------  USIC_CH_TRBSCR  ------------------------------- */
#define USIC_CH_TRBSCR_CSRBI_Pos              0                                                       /*!< USIC_CH TRBSCR: CSRBI Position          */
#define USIC_CH_TRBSCR_CSRBI_Msk              (0x01UL << USIC_CH_TRBSCR_CSRBI_Pos)                    /*!< USIC_CH TRBSCR: CSRBI Mask              */
#define USIC_CH_TRBSCR_CRBERI_Pos             1                                                       /*!< USIC_CH TRBSCR: CRBERI Position         */
#define USIC_CH_TRBSCR_CRBERI_Msk             (0x01UL << USIC_CH_TRBSCR_CRBERI_Pos)                   /*!< USIC_CH TRBSCR: CRBERI Mask             */
#define USIC_CH_TRBSCR_CARBI_Pos              2                                                       /*!< USIC_CH TRBSCR: CARBI Position          */
#define USIC_CH_TRBSCR_CARBI_Msk              (0x01UL << USIC_CH_TRBSCR_CARBI_Pos)                    /*!< USIC_CH TRBSCR: CARBI Mask              */
#define USIC_CH_TRBSCR_CSTBI_Pos              8                                                       /*!< USIC_CH TRBSCR: CSTBI Position          */
#define USIC_CH_TRBSCR_CSTBI_Msk              (0x01UL << USIC_CH_TRBSCR_CSTBI_Pos)                    /*!< USIC_CH TRBSCR: CSTBI Mask              */
#define USIC_CH_TRBSCR_CTBERI_Pos             9                                                       /*!< USIC_CH TRBSCR: CTBERI Position         */
#define USIC_CH_TRBSCR_CTBERI_Msk             (0x01UL << USIC_CH_TRBSCR_CTBERI_Pos)                   /*!< USIC_CH TRBSCR: CTBERI Mask             */
#define USIC_CH_TRBSCR_CBDV_Pos               10                                                      /*!< USIC_CH TRBSCR: CBDV Position           */
#define USIC_CH_TRBSCR_CBDV_Msk               (0x01UL << USIC_CH_TRBSCR_CBDV_Pos)                     /*!< USIC_CH TRBSCR: CBDV Mask               */
#define USIC_CH_TRBSCR_FLUSHRB_Pos            14                                                      /*!< USIC_CH TRBSCR: FLUSHRB Position        */
#define USIC_CH_TRBSCR_FLUSHRB_Msk            (0x01UL << USIC_CH_TRBSCR_FLUSHRB_Pos)                  /*!< USIC_CH TRBSCR: FLUSHRB Mask            */
#define USIC_CH_TRBSCR_FLUSHTB_Pos            15                                                      /*!< USIC_CH TRBSCR: FLUSHTB Position        */
#define USIC_CH_TRBSCR_FLUSHTB_Msk            (0x01UL << USIC_CH_TRBSCR_FLUSHTB_Pos)                  /*!< USIC_CH TRBSCR: FLUSHTB Mask            */

/* --------------------------------  USIC_CH_OUTR  -------------------------------- */
#define USIC_CH_OUTR_DSR_Pos                  0                                                       /*!< USIC_CH OUTR: DSR Position              */
#define USIC_CH_OUTR_DSR_Msk                  (0x0000ffffUL << USIC_CH_OUTR_DSR_Pos)                  /*!< USIC_CH OUTR: DSR Mask                  */
#define USIC_CH_OUTR_RCI_Pos                  16                                                      /*!< USIC_CH OUTR: RCI Position              */
#define USIC_CH_OUTR_RCI_Msk                  (0x1fUL << USIC_CH_OUTR_RCI_Pos)                        /*!< USIC_CH OUTR: RCI Mask                  */

/* --------------------------------  USIC_CH_OUTDR  ------------------------------- */
#define USIC_CH_OUTDR_DSR_Pos                 0                                                       /*!< USIC_CH OUTDR: DSR Position             */
#define USIC_CH_OUTDR_DSR_Msk                 (0x0000ffffUL << USIC_CH_OUTDR_DSR_Pos)                 /*!< USIC_CH OUTDR: DSR Mask                 */
#define USIC_CH_OUTDR_RCI_Pos                 16                                                      /*!< USIC_CH OUTDR: RCI Position             */
#define USIC_CH_OUTDR_RCI_Msk                 (0x1fUL << USIC_CH_OUTDR_RCI_Pos)                       /*!< USIC_CH OUTDR: RCI Mask                 */

/* ---------------------------------  USIC_CH_IN  --------------------------------- */
#define USIC_CH_IN_TDATA_Pos                  0                                                       /*!< USIC_CH IN: TDATA Position              */
#define USIC_CH_IN_TDATA_Msk                  (0x0000ffffUL << USIC_CH_IN_TDATA_Pos)                  /*!< USIC_CH IN: TDATA Mask                  */


/* ================================================================================ */
/* ================          struct 'CAN' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  CAN_CLC  ---------------------------------- */
#define CAN_CLC_DISR_Pos                      0                                                       /*!< CAN CLC: DISR Position                  */
#define CAN_CLC_DISR_Msk                      (0x01UL << CAN_CLC_DISR_Pos)                            /*!< CAN CLC: DISR Mask                      */
#define CAN_CLC_DISS_Pos                      1                                                       /*!< CAN CLC: DISS Position                  */
#define CAN_CLC_DISS_Msk                      (0x01UL << CAN_CLC_DISS_Pos)                            /*!< CAN CLC: DISS Mask                      */
#define CAN_CLC_EDIS_Pos                      3                                                       /*!< CAN CLC: EDIS Position                  */
#define CAN_CLC_EDIS_Msk                      (0x01UL << CAN_CLC_EDIS_Pos)                            /*!< CAN CLC: EDIS Mask                      */
#define CAN_CLC_SBWE_Pos                      4                                                       /*!< CAN CLC: SBWE Position                  */
#define CAN_CLC_SBWE_Msk                      (0x01UL << CAN_CLC_SBWE_Pos)                            /*!< CAN CLC: SBWE Mask                      */

/* -----------------------------------  CAN_ID  ----------------------------------- */
#define CAN_ID_MOD_REV_Pos                    0                                                       /*!< CAN ID: MOD_REV Position                */
#define CAN_ID_MOD_REV_Msk                    (0x000000ffUL << CAN_ID_MOD_REV_Pos)                    /*!< CAN ID: MOD_REV Mask                    */
#define CAN_ID_MOD_TYPE_Pos                   8                                                       /*!< CAN ID: MOD_TYPE Position               */
#define CAN_ID_MOD_TYPE_Msk                   (0x000000ffUL << CAN_ID_MOD_TYPE_Pos)                   /*!< CAN ID: MOD_TYPE Mask                   */
#define CAN_ID_MOD_NUMBER_Pos                 16                                                      /*!< CAN ID: MOD_NUMBER Position             */
#define CAN_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << CAN_ID_MOD_NUMBER_Pos)                 /*!< CAN ID: MOD_NUMBER Mask                 */

/* -----------------------------------  CAN_FDR  ---------------------------------- */
#define CAN_FDR_STEP_Pos                      0                                                       /*!< CAN FDR: STEP Position                  */
#define CAN_FDR_STEP_Msk                      (0x000003ffUL << CAN_FDR_STEP_Pos)                      /*!< CAN FDR: STEP Mask                      */
#define CAN_FDR_SM_Pos                        11                                                      /*!< CAN FDR: SM Position                    */
#define CAN_FDR_SM_Msk                        (0x01UL << CAN_FDR_SM_Pos)                              /*!< CAN FDR: SM Mask                        */
#define CAN_FDR_SC_Pos                        12                                                      /*!< CAN FDR: SC Position                    */
#define CAN_FDR_SC_Msk                        (0x03UL << CAN_FDR_SC_Pos)                              /*!< CAN FDR: SC Mask                        */
#define CAN_FDR_DM_Pos                        14                                                      /*!< CAN FDR: DM Position                    */
#define CAN_FDR_DM_Msk                        (0x03UL << CAN_FDR_DM_Pos)                              /*!< CAN FDR: DM Mask                        */
#define CAN_FDR_RESULT_Pos                    16                                                      /*!< CAN FDR: RESULT Position                */
#define CAN_FDR_RESULT_Msk                    (0x000003ffUL << CAN_FDR_RESULT_Pos)                    /*!< CAN FDR: RESULT Mask                    */
#define CAN_FDR_SUSACK_Pos                    28                                                      /*!< CAN FDR: SUSACK Position                */
#define CAN_FDR_SUSACK_Msk                    (0x01UL << CAN_FDR_SUSACK_Pos)                          /*!< CAN FDR: SUSACK Mask                    */
#define CAN_FDR_SUSREQ_Pos                    29                                                      /*!< CAN FDR: SUSREQ Position                */
#define CAN_FDR_SUSREQ_Msk                    (0x01UL << CAN_FDR_SUSREQ_Pos)                          /*!< CAN FDR: SUSREQ Mask                    */
#define CAN_FDR_ENHW_Pos                      30                                                      /*!< CAN FDR: ENHW Position                  */
#define CAN_FDR_ENHW_Msk                      (0x01UL << CAN_FDR_ENHW_Pos)                            /*!< CAN FDR: ENHW Mask                      */
#define CAN_FDR_DISCLK_Pos                    31                                                      /*!< CAN FDR: DISCLK Position                */
#define CAN_FDR_DISCLK_Msk                    (0x01UL << CAN_FDR_DISCLK_Pos)                          /*!< CAN FDR: DISCLK Mask                    */

/* ----------------------------------  CAN_LIST  ---------------------------------- */
#define CAN_LIST_BEGIN_Pos                    0                                                       /*!< CAN LIST: BEGIN Position                */
#define CAN_LIST_BEGIN_Msk                    (0x000000ffUL << CAN_LIST_BEGIN_Pos)                    /*!< CAN LIST: BEGIN Mask                    */
#define CAN_LIST_END_Pos                      8                                                       /*!< CAN LIST: END Position                  */
#define CAN_LIST_END_Msk                      (0x000000ffUL << CAN_LIST_END_Pos)                      /*!< CAN LIST: END Mask                      */
#define CAN_LIST_SIZE_Pos                     16                                                      /*!< CAN LIST: SIZE Position                 */
#define CAN_LIST_SIZE_Msk                     (0x000000ffUL << CAN_LIST_SIZE_Pos)                     /*!< CAN LIST: SIZE Mask                     */
#define CAN_LIST_EMPTY_Pos                    24                                                      /*!< CAN LIST: EMPTY Position                */
#define CAN_LIST_EMPTY_Msk                    (0x01UL << CAN_LIST_EMPTY_Pos)                          /*!< CAN LIST: EMPTY Mask                    */

/* ----------------------------------  CAN_MSPND  --------------------------------- */
#define CAN_MSPND_PND_Pos                     0                                                       /*!< CAN MSPND: PND Position                 */
#define CAN_MSPND_PND_Msk                     (0xffffffffUL << CAN_MSPND_PND_Pos)                     /*!< CAN MSPND: PND Mask                     */

/* ----------------------------------  CAN_MSID  ---------------------------------- */
#define CAN_MSID_INDEX_Pos                    0                                                       /*!< CAN MSID: INDEX Position                */
#define CAN_MSID_INDEX_Msk                    (0x3fUL << CAN_MSID_INDEX_Pos)                          /*!< CAN MSID: INDEX Mask                    */

/* ---------------------------------  CAN_MSIMASK  -------------------------------- */
#define CAN_MSIMASK_IM_Pos                    0                                                       /*!< CAN MSIMASK: IM Position                */
#define CAN_MSIMASK_IM_Msk                    (0xffffffffUL << CAN_MSIMASK_IM_Pos)                    /*!< CAN MSIMASK: IM Mask                    */

/* ---------------------------------  CAN_PANCTR  --------------------------------- */
#define CAN_PANCTR_PANCMD_Pos                 0                                                       /*!< CAN PANCTR: PANCMD Position             */
#define CAN_PANCTR_PANCMD_Msk                 (0x000000ffUL << CAN_PANCTR_PANCMD_Pos)                 /*!< CAN PANCTR: PANCMD Mask                 */
#define CAN_PANCTR_BUSY_Pos                   8                                                       /*!< CAN PANCTR: BUSY Position               */
#define CAN_PANCTR_BUSY_Msk                   (0x01UL << CAN_PANCTR_BUSY_Pos)                         /*!< CAN PANCTR: BUSY Mask                   */
#define CAN_PANCTR_RBUSY_Pos                  9                                                       /*!< CAN PANCTR: RBUSY Position              */
#define CAN_PANCTR_RBUSY_Msk                  (0x01UL << CAN_PANCTR_RBUSY_Pos)                        /*!< CAN PANCTR: RBUSY Mask                  */
#define CAN_PANCTR_PANAR1_Pos                 16                                                      /*!< CAN PANCTR: PANAR1 Position             */
#define CAN_PANCTR_PANAR1_Msk                 (0x000000ffUL << CAN_PANCTR_PANAR1_Pos)                 /*!< CAN PANCTR: PANAR1 Mask                 */
#define CAN_PANCTR_PANAR2_Pos                 24                                                      /*!< CAN PANCTR: PANAR2 Position             */
#define CAN_PANCTR_PANAR2_Msk                 (0x000000ffUL << CAN_PANCTR_PANAR2_Pos)                 /*!< CAN PANCTR: PANAR2 Mask                 */

/* -----------------------------------  CAN_MCR  ---------------------------------- */
#define CAN_MCR_MPSEL_Pos                     12                                                      /*!< CAN MCR: MPSEL Position                 */
#define CAN_MCR_MPSEL_Msk                     (0x0fUL << CAN_MCR_MPSEL_Pos)                           /*!< CAN MCR: MPSEL Mask                     */

/* ----------------------------------  CAN_MITR  ---------------------------------- */
#define CAN_MITR_IT_Pos                       0                                                       /*!< CAN MITR: IT Position                   */
#define CAN_MITR_IT_Msk                       (0x000000ffUL << CAN_MITR_IT_Pos)                       /*!< CAN MITR: IT Mask                       */


/* ================================================================================ */
/* ================        Group 'CAN_NODE' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  CAN_NODE_NCR  -------------------------------- */
#define CAN_NODE_NCR_INIT_Pos                 0                                                       /*!< CAN_NODE NCR: INIT Position             */
#define CAN_NODE_NCR_INIT_Msk                 (0x01UL << CAN_NODE_NCR_INIT_Pos)                       /*!< CAN_NODE NCR: INIT Mask                 */
#define CAN_NODE_NCR_TRIE_Pos                 1                                                       /*!< CAN_NODE NCR: TRIE Position             */
#define CAN_NODE_NCR_TRIE_Msk                 (0x01UL << CAN_NODE_NCR_TRIE_Pos)                       /*!< CAN_NODE NCR: TRIE Mask                 */
#define CAN_NODE_NCR_LECIE_Pos                2                                                       /*!< CAN_NODE NCR: LECIE Position            */
#define CAN_NODE_NCR_LECIE_Msk                (0x01UL << CAN_NODE_NCR_LECIE_Pos)                      /*!< CAN_NODE NCR: LECIE Mask                */
#define CAN_NODE_NCR_ALIE_Pos                 3                                                       /*!< CAN_NODE NCR: ALIE Position             */
#define CAN_NODE_NCR_ALIE_Msk                 (0x01UL << CAN_NODE_NCR_ALIE_Pos)                       /*!< CAN_NODE NCR: ALIE Mask                 */
#define CAN_NODE_NCR_CANDIS_Pos               4                                                       /*!< CAN_NODE NCR: CANDIS Position           */
#define CAN_NODE_NCR_CANDIS_Msk               (0x01UL << CAN_NODE_NCR_CANDIS_Pos)                     /*!< CAN_NODE NCR: CANDIS Mask               */
#define CAN_NODE_NCR_CCE_Pos                  6                                                       /*!< CAN_NODE NCR: CCE Position              */
#define CAN_NODE_NCR_CCE_Msk                  (0x01UL << CAN_NODE_NCR_CCE_Pos)                        /*!< CAN_NODE NCR: CCE Mask                  */
#define CAN_NODE_NCR_CALM_Pos                 7                                                       /*!< CAN_NODE NCR: CALM Position             */
#define CAN_NODE_NCR_CALM_Msk                 (0x01UL << CAN_NODE_NCR_CALM_Pos)                       /*!< CAN_NODE NCR: CALM Mask                 */
#define CAN_NODE_NCR_SUSEN_Pos                8                                                       /*!< CAN_NODE NCR: SUSEN Position            */
#define CAN_NODE_NCR_SUSEN_Msk                (0x01UL << CAN_NODE_NCR_SUSEN_Pos)                      /*!< CAN_NODE NCR: SUSEN Mask                */

/* --------------------------------  CAN_NODE_NSR  -------------------------------- */
#define CAN_NODE_NSR_LEC_Pos                  0                                                       /*!< CAN_NODE NSR: LEC Position              */
#define CAN_NODE_NSR_LEC_Msk                  (0x07UL << CAN_NODE_NSR_LEC_Pos)                        /*!< CAN_NODE NSR: LEC Mask                  */
#define CAN_NODE_NSR_TXOK_Pos                 3                                                       /*!< CAN_NODE NSR: TXOK Position             */
#define CAN_NODE_NSR_TXOK_Msk                 (0x01UL << CAN_NODE_NSR_TXOK_Pos)                       /*!< CAN_NODE NSR: TXOK Mask                 */
#define CAN_NODE_NSR_RXOK_Pos                 4                                                       /*!< CAN_NODE NSR: RXOK Position             */
#define CAN_NODE_NSR_RXOK_Msk                 (0x01UL << CAN_NODE_NSR_RXOK_Pos)                       /*!< CAN_NODE NSR: RXOK Mask                 */
#define CAN_NODE_NSR_ALERT_Pos                5                                                       /*!< CAN_NODE NSR: ALERT Position            */
#define CAN_NODE_NSR_ALERT_Msk                (0x01UL << CAN_NODE_NSR_ALERT_Pos)                      /*!< CAN_NODE NSR: ALERT Mask                */
#define CAN_NODE_NSR_EWRN_Pos                 6                                                       /*!< CAN_NODE NSR: EWRN Position             */
#define CAN_NODE_NSR_EWRN_Msk                 (0x01UL << CAN_NODE_NSR_EWRN_Pos)                       /*!< CAN_NODE NSR: EWRN Mask                 */
#define CAN_NODE_NSR_BOFF_Pos                 7                                                       /*!< CAN_NODE NSR: BOFF Position             */
#define CAN_NODE_NSR_BOFF_Msk                 (0x01UL << CAN_NODE_NSR_BOFF_Pos)                       /*!< CAN_NODE NSR: BOFF Mask                 */
#define CAN_NODE_NSR_LLE_Pos                  8                                                       /*!< CAN_NODE NSR: LLE Position              */
#define CAN_NODE_NSR_LLE_Msk                  (0x01UL << CAN_NODE_NSR_LLE_Pos)                        /*!< CAN_NODE NSR: LLE Mask                  */
#define CAN_NODE_NSR_LOE_Pos                  9                                                       /*!< CAN_NODE NSR: LOE Position              */
#define CAN_NODE_NSR_LOE_Msk                  (0x01UL << CAN_NODE_NSR_LOE_Pos)                        /*!< CAN_NODE NSR: LOE Mask                  */
#define CAN_NODE_NSR_SUSACK_Pos               10                                                      /*!< CAN_NODE NSR: SUSACK Position           */
#define CAN_NODE_NSR_SUSACK_Msk               (0x01UL << CAN_NODE_NSR_SUSACK_Pos)                     /*!< CAN_NODE NSR: SUSACK Mask               */

/* --------------------------------  CAN_NODE_NIPR  ------------------------------- */
#define CAN_NODE_NIPR_ALINP_Pos               0                                                       /*!< CAN_NODE NIPR: ALINP Position           */
#define CAN_NODE_NIPR_ALINP_Msk               (0x07UL << CAN_NODE_NIPR_ALINP_Pos)                     /*!< CAN_NODE NIPR: ALINP Mask               */
#define CAN_NODE_NIPR_LECINP_Pos              4                                                       /*!< CAN_NODE NIPR: LECINP Position          */
#define CAN_NODE_NIPR_LECINP_Msk              (0x07UL << CAN_NODE_NIPR_LECINP_Pos)                    /*!< CAN_NODE NIPR: LECINP Mask              */
#define CAN_NODE_NIPR_TRINP_Pos               8                                                       /*!< CAN_NODE NIPR: TRINP Position           */
#define CAN_NODE_NIPR_TRINP_Msk               (0x07UL << CAN_NODE_NIPR_TRINP_Pos)                     /*!< CAN_NODE NIPR: TRINP Mask               */
#define CAN_NODE_NIPR_CFCINP_Pos              12                                                      /*!< CAN_NODE NIPR: CFCINP Position          */
#define CAN_NODE_NIPR_CFCINP_Msk              (0x07UL << CAN_NODE_NIPR_CFCINP_Pos)                    /*!< CAN_NODE NIPR: CFCINP Mask              */

/* --------------------------------  CAN_NODE_NPCR  ------------------------------- */
#define CAN_NODE_NPCR_RXSEL_Pos               0                                                       /*!< CAN_NODE NPCR: RXSEL Position           */
#define CAN_NODE_NPCR_RXSEL_Msk               (0x07UL << CAN_NODE_NPCR_RXSEL_Pos)                     /*!< CAN_NODE NPCR: RXSEL Mask               */
#define CAN_NODE_NPCR_LBM_Pos                 8                                                       /*!< CAN_NODE NPCR: LBM Position             */
#define CAN_NODE_NPCR_LBM_Msk                 (0x01UL << CAN_NODE_NPCR_LBM_Pos)                       /*!< CAN_NODE NPCR: LBM Mask                 */

/* --------------------------------  CAN_NODE_NBTR  ------------------------------- */
#define CAN_NODE_NBTR_BRP_Pos                 0                                                       /*!< CAN_NODE NBTR: BRP Position             */
#define CAN_NODE_NBTR_BRP_Msk                 (0x3fUL << CAN_NODE_NBTR_BRP_Pos)                       /*!< CAN_NODE NBTR: BRP Mask                 */
#define CAN_NODE_NBTR_SJW_Pos                 6                                                       /*!< CAN_NODE NBTR: SJW Position             */
#define CAN_NODE_NBTR_SJW_Msk                 (0x03UL << CAN_NODE_NBTR_SJW_Pos)                       /*!< CAN_NODE NBTR: SJW Mask                 */
#define CAN_NODE_NBTR_TSEG1_Pos               8                                                       /*!< CAN_NODE NBTR: TSEG1 Position           */
#define CAN_NODE_NBTR_TSEG1_Msk               (0x0fUL << CAN_NODE_NBTR_TSEG1_Pos)                     /*!< CAN_NODE NBTR: TSEG1 Mask               */
#define CAN_NODE_NBTR_TSEG2_Pos               12                                                      /*!< CAN_NODE NBTR: TSEG2 Position           */
#define CAN_NODE_NBTR_TSEG2_Msk               (0x07UL << CAN_NODE_NBTR_TSEG2_Pos)                     /*!< CAN_NODE NBTR: TSEG2 Mask               */
#define CAN_NODE_NBTR_DIV8_Pos                15                                                      /*!< CAN_NODE NBTR: DIV8 Position            */
#define CAN_NODE_NBTR_DIV8_Msk                (0x01UL << CAN_NODE_NBTR_DIV8_Pos)                      /*!< CAN_NODE NBTR: DIV8 Mask                */

/* -------------------------------  CAN_NODE_NECNT  ------------------------------- */
#define CAN_NODE_NECNT_REC_Pos                0                                                       /*!< CAN_NODE NECNT: REC Position            */
#define CAN_NODE_NECNT_REC_Msk                (0x000000ffUL << CAN_NODE_NECNT_REC_Pos)                /*!< CAN_NODE NECNT: REC Mask                */
#define CAN_NODE_NECNT_TEC_Pos                8                                                       /*!< CAN_NODE NECNT: TEC Position            */
#define CAN_NODE_NECNT_TEC_Msk                (0x000000ffUL << CAN_NODE_NECNT_TEC_Pos)                /*!< CAN_NODE NECNT: TEC Mask                */
#define CAN_NODE_NECNT_EWRNLVL_Pos            16                                                      /*!< CAN_NODE NECNT: EWRNLVL Position        */
#define CAN_NODE_NECNT_EWRNLVL_Msk            (0x000000ffUL << CAN_NODE_NECNT_EWRNLVL_Pos)            /*!< CAN_NODE NECNT: EWRNLVL Mask            */
#define CAN_NODE_NECNT_LETD_Pos               24                                                      /*!< CAN_NODE NECNT: LETD Position           */
#define CAN_NODE_NECNT_LETD_Msk               (0x01UL << CAN_NODE_NECNT_LETD_Pos)                     /*!< CAN_NODE NECNT: LETD Mask               */
#define CAN_NODE_NECNT_LEINC_Pos              25                                                      /*!< CAN_NODE NECNT: LEINC Position          */
#define CAN_NODE_NECNT_LEINC_Msk              (0x01UL << CAN_NODE_NECNT_LEINC_Pos)                    /*!< CAN_NODE NECNT: LEINC Mask              */

/* --------------------------------  CAN_NODE_NFCR  ------------------------------- */
#define CAN_NODE_NFCR_CFC_Pos                 0                                                       /*!< CAN_NODE NFCR: CFC Position             */
#define CAN_NODE_NFCR_CFC_Msk                 (0x0000ffffUL << CAN_NODE_NFCR_CFC_Pos)                 /*!< CAN_NODE NFCR: CFC Mask                 */
#define CAN_NODE_NFCR_CFSEL_Pos               16                                                      /*!< CAN_NODE NFCR: CFSEL Position           */
#define CAN_NODE_NFCR_CFSEL_Msk               (0x07UL << CAN_NODE_NFCR_CFSEL_Pos)                     /*!< CAN_NODE NFCR: CFSEL Mask               */
#define CAN_NODE_NFCR_CFMOD_Pos               19                                                      /*!< CAN_NODE NFCR: CFMOD Position           */
#define CAN_NODE_NFCR_CFMOD_Msk               (0x03UL << CAN_NODE_NFCR_CFMOD_Pos)                     /*!< CAN_NODE NFCR: CFMOD Mask               */
#define CAN_NODE_NFCR_CFCIE_Pos               22                                                      /*!< CAN_NODE NFCR: CFCIE Position           */
#define CAN_NODE_NFCR_CFCIE_Msk               (0x01UL << CAN_NODE_NFCR_CFCIE_Pos)                     /*!< CAN_NODE NFCR: CFCIE Mask               */
#define CAN_NODE_NFCR_CFCOV_Pos               23                                                      /*!< CAN_NODE NFCR: CFCOV Position           */
#define CAN_NODE_NFCR_CFCOV_Msk               (0x01UL << CAN_NODE_NFCR_CFCOV_Pos)                     /*!< CAN_NODE NFCR: CFCOV Mask               */


/* ================================================================================ */
/* ================         Group 'CAN_MO' Position & Mask         ================ */
/* ================================================================================ */


/* --------------------------------  CAN_MO_MOFCR  -------------------------------- */
#define CAN_MO_MOFCR_MMC_Pos                  0                                                       /*!< CAN_MO MOFCR: MMC Position              */
#define CAN_MO_MOFCR_MMC_Msk                  (0x0fUL << CAN_MO_MOFCR_MMC_Pos)                        /*!< CAN_MO MOFCR: MMC Mask                  */
#define CAN_MO_MOFCR_GDFS_Pos                 8                                                       /*!< CAN_MO MOFCR: GDFS Position             */
#define CAN_MO_MOFCR_GDFS_Msk                 (0x01UL << CAN_MO_MOFCR_GDFS_Pos)                       /*!< CAN_MO MOFCR: GDFS Mask                 */
#define CAN_MO_MOFCR_IDC_Pos                  9                                                       /*!< CAN_MO MOFCR: IDC Position              */
#define CAN_MO_MOFCR_IDC_Msk                  (0x01UL << CAN_MO_MOFCR_IDC_Pos)                        /*!< CAN_MO MOFCR: IDC Mask                  */
#define CAN_MO_MOFCR_DLCC_Pos                 10                                                      /*!< CAN_MO MOFCR: DLCC Position             */
#define CAN_MO_MOFCR_DLCC_Msk                 (0x01UL << CAN_MO_MOFCR_DLCC_Pos)                       /*!< CAN_MO MOFCR: DLCC Mask                 */
#define CAN_MO_MOFCR_DATC_Pos                 11                                                      /*!< CAN_MO MOFCR: DATC Position             */
#define CAN_MO_MOFCR_DATC_Msk                 (0x01UL << CAN_MO_MOFCR_DATC_Pos)                       /*!< CAN_MO MOFCR: DATC Mask                 */
#define CAN_MO_MOFCR_RXIE_Pos                 16                                                      /*!< CAN_MO MOFCR: RXIE Position             */
#define CAN_MO_MOFCR_RXIE_Msk                 (0x01UL << CAN_MO_MOFCR_RXIE_Pos)                       /*!< CAN_MO MOFCR: RXIE Mask                 */
#define CAN_MO_MOFCR_TXIE_Pos                 17                                                      /*!< CAN_MO MOFCR: TXIE Position             */
#define CAN_MO_MOFCR_TXIE_Msk                 (0x01UL << CAN_MO_MOFCR_TXIE_Pos)                       /*!< CAN_MO MOFCR: TXIE Mask                 */
#define CAN_MO_MOFCR_OVIE_Pos                 18                                                      /*!< CAN_MO MOFCR: OVIE Position             */
#define CAN_MO_MOFCR_OVIE_Msk                 (0x01UL << CAN_MO_MOFCR_OVIE_Pos)                       /*!< CAN_MO MOFCR: OVIE Mask                 */
#define CAN_MO_MOFCR_FRREN_Pos                20                                                      /*!< CAN_MO MOFCR: FRREN Position            */
#define CAN_MO_MOFCR_FRREN_Msk                (0x01UL << CAN_MO_MOFCR_FRREN_Pos)                      /*!< CAN_MO MOFCR: FRREN Mask                */
#define CAN_MO_MOFCR_RMM_Pos                  21                                                      /*!< CAN_MO MOFCR: RMM Position              */
#define CAN_MO_MOFCR_RMM_Msk                  (0x01UL << CAN_MO_MOFCR_RMM_Pos)                        /*!< CAN_MO MOFCR: RMM Mask                  */
#define CAN_MO_MOFCR_SDT_Pos                  22                                                      /*!< CAN_MO MOFCR: SDT Position              */
#define CAN_MO_MOFCR_SDT_Msk                  (0x01UL << CAN_MO_MOFCR_SDT_Pos)                        /*!< CAN_MO MOFCR: SDT Mask                  */
#define CAN_MO_MOFCR_STT_Pos                  23                                                      /*!< CAN_MO MOFCR: STT Position              */
#define CAN_MO_MOFCR_STT_Msk                  (0x01UL << CAN_MO_MOFCR_STT_Pos)                        /*!< CAN_MO MOFCR: STT Mask                  */
#define CAN_MO_MOFCR_DLC_Pos                  24                                                      /*!< CAN_MO MOFCR: DLC Position              */
#define CAN_MO_MOFCR_DLC_Msk                  (0x0fUL << CAN_MO_MOFCR_DLC_Pos)                        /*!< CAN_MO MOFCR: DLC Mask                  */

/* --------------------------------  CAN_MO_MOFGPR  ------------------------------- */
#define CAN_MO_MOFGPR_BOT_Pos                 0                                                       /*!< CAN_MO MOFGPR: BOT Position             */
#define CAN_MO_MOFGPR_BOT_Msk                 (0x000000ffUL << CAN_MO_MOFGPR_BOT_Pos)                 /*!< CAN_MO MOFGPR: BOT Mask                 */
#define CAN_MO_MOFGPR_TOP_Pos                 8                                                       /*!< CAN_MO MOFGPR: TOP Position             */
#define CAN_MO_MOFGPR_TOP_Msk                 (0x000000ffUL << CAN_MO_MOFGPR_TOP_Pos)                 /*!< CAN_MO MOFGPR: TOP Mask                 */
#define CAN_MO_MOFGPR_CUR_Pos                 16                                                      /*!< CAN_MO MOFGPR: CUR Position             */
#define CAN_MO_MOFGPR_CUR_Msk                 (0x000000ffUL << CAN_MO_MOFGPR_CUR_Pos)                 /*!< CAN_MO MOFGPR: CUR Mask                 */
#define CAN_MO_MOFGPR_SEL_Pos                 24                                                      /*!< CAN_MO MOFGPR: SEL Position             */
#define CAN_MO_MOFGPR_SEL_Msk                 (0x000000ffUL << CAN_MO_MOFGPR_SEL_Pos)                 /*!< CAN_MO MOFGPR: SEL Mask                 */

/* --------------------------------  CAN_MO_MOIPR  -------------------------------- */
#define CAN_MO_MOIPR_RXINP_Pos                0                                                       /*!< CAN_MO MOIPR: RXINP Position            */
#define CAN_MO_MOIPR_RXINP_Msk                (0x07UL << CAN_MO_MOIPR_RXINP_Pos)                      /*!< CAN_MO MOIPR: RXINP Mask                */
#define CAN_MO_MOIPR_TXINP_Pos                4                                                       /*!< CAN_MO MOIPR: TXINP Position            */
#define CAN_MO_MOIPR_TXINP_Msk                (0x07UL << CAN_MO_MOIPR_TXINP_Pos)                      /*!< CAN_MO MOIPR: TXINP Mask                */
#define CAN_MO_MOIPR_MPN_Pos                  8                                                       /*!< CAN_MO MOIPR: MPN Position              */
#define CAN_MO_MOIPR_MPN_Msk                  (0x000000ffUL << CAN_MO_MOIPR_MPN_Pos)                  /*!< CAN_MO MOIPR: MPN Mask                  */
#define CAN_MO_MOIPR_CFCVAL_Pos               16                                                      /*!< CAN_MO MOIPR: CFCVAL Position           */
#define CAN_MO_MOIPR_CFCVAL_Msk               (0x0000ffffUL << CAN_MO_MOIPR_CFCVAL_Pos)               /*!< CAN_MO MOIPR: CFCVAL Mask               */

/* --------------------------------  CAN_MO_MOAMR  -------------------------------- */
#define CAN_MO_MOAMR_AM_Pos                   0                                                       /*!< CAN_MO MOAMR: AM Position               */
#define CAN_MO_MOAMR_AM_Msk                   (0x1fffffffUL << CAN_MO_MOAMR_AM_Pos)                   /*!< CAN_MO MOAMR: AM Mask                   */
#define CAN_MO_MOAMR_MIDE_Pos                 29                                                      /*!< CAN_MO MOAMR: MIDE Position             */
#define CAN_MO_MOAMR_MIDE_Msk                 (0x01UL << CAN_MO_MOAMR_MIDE_Pos)                       /*!< CAN_MO MOAMR: MIDE Mask                 */

/* -------------------------------  CAN_MO_MODATAL  ------------------------------- */
#define CAN_MO_MODATAL_DB0_Pos                0                                                       /*!< CAN_MO MODATAL: DB0 Position            */
#define CAN_MO_MODATAL_DB0_Msk                (0x000000ffUL << CAN_MO_MODATAL_DB0_Pos)                /*!< CAN_MO MODATAL: DB0 Mask                */
#define CAN_MO_MODATAL_DB1_Pos                8                                                       /*!< CAN_MO MODATAL: DB1 Position            */
#define CAN_MO_MODATAL_DB1_Msk                (0x000000ffUL << CAN_MO_MODATAL_DB1_Pos)                /*!< CAN_MO MODATAL: DB1 Mask                */
#define CAN_MO_MODATAL_DB2_Pos                16                                                      /*!< CAN_MO MODATAL: DB2 Position            */
#define CAN_MO_MODATAL_DB2_Msk                (0x000000ffUL << CAN_MO_MODATAL_DB2_Pos)                /*!< CAN_MO MODATAL: DB2 Mask                */
#define CAN_MO_MODATAL_DB3_Pos                24                                                      /*!< CAN_MO MODATAL: DB3 Position            */
#define CAN_MO_MODATAL_DB3_Msk                (0x000000ffUL << CAN_MO_MODATAL_DB3_Pos)                /*!< CAN_MO MODATAL: DB3 Mask                */

/* -------------------------------  CAN_MO_MODATAH  ------------------------------- */
#define CAN_MO_MODATAH_DB4_Pos                0                                                       /*!< CAN_MO MODATAH: DB4 Position            */
#define CAN_MO_MODATAH_DB4_Msk                (0x000000ffUL << CAN_MO_MODATAH_DB4_Pos)                /*!< CAN_MO MODATAH: DB4 Mask                */
#define CAN_MO_MODATAH_DB5_Pos                8                                                       /*!< CAN_MO MODATAH: DB5 Position            */
#define CAN_MO_MODATAH_DB5_Msk                (0x000000ffUL << CAN_MO_MODATAH_DB5_Pos)                /*!< CAN_MO MODATAH: DB5 Mask                */
#define CAN_MO_MODATAH_DB6_Pos                16                                                      /*!< CAN_MO MODATAH: DB6 Position            */
#define CAN_MO_MODATAH_DB6_Msk                (0x000000ffUL << CAN_MO_MODATAH_DB6_Pos)                /*!< CAN_MO MODATAH: DB6 Mask                */
#define CAN_MO_MODATAH_DB7_Pos                24                                                      /*!< CAN_MO MODATAH: DB7 Position            */
#define CAN_MO_MODATAH_DB7_Msk                (0x000000ffUL << CAN_MO_MODATAH_DB7_Pos)                /*!< CAN_MO MODATAH: DB7 Mask                */

/* ---------------------------------  CAN_MO_MOAR  -------------------------------- */
#define CAN_MO_MOAR_ID_Pos                    0                                                       /*!< CAN_MO MOAR: ID Position                */
#define CAN_MO_MOAR_ID_Msk                    (0x1fffffffUL << CAN_MO_MOAR_ID_Pos)                    /*!< CAN_MO MOAR: ID Mask                    */
#define CAN_MO_MOAR_IDE_Pos                   29                                                      /*!< CAN_MO MOAR: IDE Position               */
#define CAN_MO_MOAR_IDE_Msk                   (0x01UL << CAN_MO_MOAR_IDE_Pos)                         /*!< CAN_MO MOAR: IDE Mask                   */
#define CAN_MO_MOAR_PRI_Pos                   30                                                      /*!< CAN_MO MOAR: PRI Position               */
#define CAN_MO_MOAR_PRI_Msk                   (0x03UL << CAN_MO_MOAR_PRI_Pos)                         /*!< CAN_MO MOAR: PRI Mask                   */

/* --------------------------------  CAN_MO_MOCTR  -------------------------------- */
#define CAN_MO_MOCTR_RESRXPND_Pos             0                                                       /*!< CAN_MO MOCTR: RESRXPND Position         */
#define CAN_MO_MOCTR_RESRXPND_Msk             (0x01UL << CAN_MO_MOCTR_RESRXPND_Pos)                   /*!< CAN_MO MOCTR: RESRXPND Mask             */
#define CAN_MO_MOCTR_RESTXPND_Pos             1                                                       /*!< CAN_MO MOCTR: RESTXPND Position         */
#define CAN_MO_MOCTR_RESTXPND_Msk             (0x01UL << CAN_MO_MOCTR_RESTXPND_Pos)                   /*!< CAN_MO MOCTR: RESTXPND Mask             */
#define CAN_MO_MOCTR_RESRXUPD_Pos             2                                                       /*!< CAN_MO MOCTR: RESRXUPD Position         */
#define CAN_MO_MOCTR_RESRXUPD_Msk             (0x01UL << CAN_MO_MOCTR_RESRXUPD_Pos)                   /*!< CAN_MO MOCTR: RESRXUPD Mask             */
#define CAN_MO_MOCTR_RESNEWDAT_Pos            3                                                       /*!< CAN_MO MOCTR: RESNEWDAT Position        */
#define CAN_MO_MOCTR_RESNEWDAT_Msk            (0x01UL << CAN_MO_MOCTR_RESNEWDAT_Pos)                  /*!< CAN_MO MOCTR: RESNEWDAT Mask            */
#define CAN_MO_MOCTR_RESMSGLST_Pos            4                                                       /*!< CAN_MO MOCTR: RESMSGLST Position        */
#define CAN_MO_MOCTR_RESMSGLST_Msk            (0x01UL << CAN_MO_MOCTR_RESMSGLST_Pos)                  /*!< CAN_MO MOCTR: RESMSGLST Mask            */
#define CAN_MO_MOCTR_RESMSGVAL_Pos            5                                                       /*!< CAN_MO MOCTR: RESMSGVAL Position        */
#define CAN_MO_MOCTR_RESMSGVAL_Msk            (0x01UL << CAN_MO_MOCTR_RESMSGVAL_Pos)                  /*!< CAN_MO MOCTR: RESMSGVAL Mask            */
#define CAN_MO_MOCTR_RESRTSEL_Pos             6                                                       /*!< CAN_MO MOCTR: RESRTSEL Position         */
#define CAN_MO_MOCTR_RESRTSEL_Msk             (0x01UL << CAN_MO_MOCTR_RESRTSEL_Pos)                   /*!< CAN_MO MOCTR: RESRTSEL Mask             */
#define CAN_MO_MOCTR_RESRXEN_Pos              7                                                       /*!< CAN_MO MOCTR: RESRXEN Position          */
#define CAN_MO_MOCTR_RESRXEN_Msk              (0x01UL << CAN_MO_MOCTR_RESRXEN_Pos)                    /*!< CAN_MO MOCTR: RESRXEN Mask              */
#define CAN_MO_MOCTR_RESTXRQ_Pos              8                                                       /*!< CAN_MO MOCTR: RESTXRQ Position          */
#define CAN_MO_MOCTR_RESTXRQ_Msk              (0x01UL << CAN_MO_MOCTR_RESTXRQ_Pos)                    /*!< CAN_MO MOCTR: RESTXRQ Mask              */
#define CAN_MO_MOCTR_RESTXEN0_Pos             9                                                       /*!< CAN_MO MOCTR: RESTXEN0 Position         */
#define CAN_MO_MOCTR_RESTXEN0_Msk             (0x01UL << CAN_MO_MOCTR_RESTXEN0_Pos)                   /*!< CAN_MO MOCTR: RESTXEN0 Mask             */
#define CAN_MO_MOCTR_RESTXEN1_Pos             10                                                      /*!< CAN_MO MOCTR: RESTXEN1 Position         */
#define CAN_MO_MOCTR_RESTXEN1_Msk             (0x01UL << CAN_MO_MOCTR_RESTXEN1_Pos)                   /*!< CAN_MO MOCTR: RESTXEN1 Mask             */
#define CAN_MO_MOCTR_RESDIR_Pos               11                                                      /*!< CAN_MO MOCTR: RESDIR Position           */
#define CAN_MO_MOCTR_RESDIR_Msk               (0x01UL << CAN_MO_MOCTR_RESDIR_Pos)                     /*!< CAN_MO MOCTR: RESDIR Mask               */
#define CAN_MO_MOCTR_SETRXPND_Pos             16                                                      /*!< CAN_MO MOCTR: SETRXPND Position         */
#define CAN_MO_MOCTR_SETRXPND_Msk             (0x01UL << CAN_MO_MOCTR_SETRXPND_Pos)                   /*!< CAN_MO MOCTR: SETRXPND Mask             */
#define CAN_MO_MOCTR_SETTXPND_Pos             17                                                      /*!< CAN_MO MOCTR: SETTXPND Position         */
#define CAN_MO_MOCTR_SETTXPND_Msk             (0x01UL << CAN_MO_MOCTR_SETTXPND_Pos)                   /*!< CAN_MO MOCTR: SETTXPND Mask             */
#define CAN_MO_MOCTR_SETRXUPD_Pos             18                                                      /*!< CAN_MO MOCTR: SETRXUPD Position         */
#define CAN_MO_MOCTR_SETRXUPD_Msk             (0x01UL << CAN_MO_MOCTR_SETRXUPD_Pos)                   /*!< CAN_MO MOCTR: SETRXUPD Mask             */
#define CAN_MO_MOCTR_SETNEWDAT_Pos            19                                                      /*!< CAN_MO MOCTR: SETNEWDAT Position        */
#define CAN_MO_MOCTR_SETNEWDAT_Msk            (0x01UL << CAN_MO_MOCTR_SETNEWDAT_Pos)                  /*!< CAN_MO MOCTR: SETNEWDAT Mask            */
#define CAN_MO_MOCTR_SETMSGLST_Pos            20                                                      /*!< CAN_MO MOCTR: SETMSGLST Position        */
#define CAN_MO_MOCTR_SETMSGLST_Msk            (0x01UL << CAN_MO_MOCTR_SETMSGLST_Pos)                  /*!< CAN_MO MOCTR: SETMSGLST Mask            */
#define CAN_MO_MOCTR_SETMSGVAL_Pos            21                                                      /*!< CAN_MO MOCTR: SETMSGVAL Position        */
#define CAN_MO_MOCTR_SETMSGVAL_Msk            (0x01UL << CAN_MO_MOCTR_SETMSGVAL_Pos)                  /*!< CAN_MO MOCTR: SETMSGVAL Mask            */
#define CAN_MO_MOCTR_SETRTSEL_Pos             22                                                      /*!< CAN_MO MOCTR: SETRTSEL Position         */
#define CAN_MO_MOCTR_SETRTSEL_Msk             (0x01UL << CAN_MO_MOCTR_SETRTSEL_Pos)                   /*!< CAN_MO MOCTR: SETRTSEL Mask             */
#define CAN_MO_MOCTR_SETRXEN_Pos              23                                                      /*!< CAN_MO MOCTR: SETRXEN Position          */
#define CAN_MO_MOCTR_SETRXEN_Msk              (0x01UL << CAN_MO_MOCTR_SETRXEN_Pos)                    /*!< CAN_MO MOCTR: SETRXEN Mask              */
#define CAN_MO_MOCTR_SETTXRQ_Pos              24                                                      /*!< CAN_MO MOCTR: SETTXRQ Position          */
#define CAN_MO_MOCTR_SETTXRQ_Msk              (0x01UL << CAN_MO_MOCTR_SETTXRQ_Pos)                    /*!< CAN_MO MOCTR: SETTXRQ Mask              */
#define CAN_MO_MOCTR_SETTXEN0_Pos             25                                                      /*!< CAN_MO MOCTR: SETTXEN0 Position         */
#define CAN_MO_MOCTR_SETTXEN0_Msk             (0x01UL << CAN_MO_MOCTR_SETTXEN0_Pos)                   /*!< CAN_MO MOCTR: SETTXEN0 Mask             */
#define CAN_MO_MOCTR_SETTXEN1_Pos             26                                                      /*!< CAN_MO MOCTR: SETTXEN1 Position         */
#define CAN_MO_MOCTR_SETTXEN1_Msk             (0x01UL << CAN_MO_MOCTR_SETTXEN1_Pos)                   /*!< CAN_MO MOCTR: SETTXEN1 Mask             */
#define CAN_MO_MOCTR_SETDIR_Pos               27                                                      /*!< CAN_MO MOCTR: SETDIR Position           */
#define CAN_MO_MOCTR_SETDIR_Msk               (0x01UL << CAN_MO_MOCTR_SETDIR_Pos)                     /*!< CAN_MO MOCTR: SETDIR Mask               */

/* --------------------------------  CAN_MO_MOSTAT  ------------------------------- */
#define CAN_MO_MOSTAT_RXPND_Pos               0                                                       /*!< CAN_MO MOSTAT: RXPND Position           */
#define CAN_MO_MOSTAT_RXPND_Msk               (0x01UL << CAN_MO_MOSTAT_RXPND_Pos)                     /*!< CAN_MO MOSTAT: RXPND Mask               */
#define CAN_MO_MOSTAT_TXPND_Pos               1                                                       /*!< CAN_MO MOSTAT: TXPND Position           */
#define CAN_MO_MOSTAT_TXPND_Msk               (0x01UL << CAN_MO_MOSTAT_TXPND_Pos)                     /*!< CAN_MO MOSTAT: TXPND Mask               */
#define CAN_MO_MOSTAT_RXUPD_Pos               2                                                       /*!< CAN_MO MOSTAT: RXUPD Position           */
#define CAN_MO_MOSTAT_RXUPD_Msk               (0x01UL << CAN_MO_MOSTAT_RXUPD_Pos)                     /*!< CAN_MO MOSTAT: RXUPD Mask               */
#define CAN_MO_MOSTAT_NEWDAT_Pos              3                                                       /*!< CAN_MO MOSTAT: NEWDAT Position          */
#define CAN_MO_MOSTAT_NEWDAT_Msk              (0x01UL << CAN_MO_MOSTAT_NEWDAT_Pos)                    /*!< CAN_MO MOSTAT: NEWDAT Mask              */
#define CAN_MO_MOSTAT_MSGLST_Pos              4                                                       /*!< CAN_MO MOSTAT: MSGLST Position          */
#define CAN_MO_MOSTAT_MSGLST_Msk              (0x01UL << CAN_MO_MOSTAT_MSGLST_Pos)                    /*!< CAN_MO MOSTAT: MSGLST Mask              */
#define CAN_MO_MOSTAT_MSGVAL_Pos              5                                                       /*!< CAN_MO MOSTAT: MSGVAL Position          */
#define CAN_MO_MOSTAT_MSGVAL_Msk              (0x01UL << CAN_MO_MOSTAT_MSGVAL_Pos)                    /*!< CAN_MO MOSTAT: MSGVAL Mask              */
#define CAN_MO_MOSTAT_RTSEL_Pos               6                                                       /*!< CAN_MO MOSTAT: RTSEL Position           */
#define CAN_MO_MOSTAT_RTSEL_Msk               (0x01UL << CAN_MO_MOSTAT_RTSEL_Pos)                     /*!< CAN_MO MOSTAT: RTSEL Mask               */
#define CAN_MO_MOSTAT_RXEN_Pos                7                                                       /*!< CAN_MO MOSTAT: RXEN Position            */
#define CAN_MO_MOSTAT_RXEN_Msk                (0x01UL << CAN_MO_MOSTAT_RXEN_Pos)                      /*!< CAN_MO MOSTAT: RXEN Mask                */
#define CAN_MO_MOSTAT_TXRQ_Pos                8                                                       /*!< CAN_MO MOSTAT: TXRQ Position            */
#define CAN_MO_MOSTAT_TXRQ_Msk                (0x01UL << CAN_MO_MOSTAT_TXRQ_Pos)                      /*!< CAN_MO MOSTAT: TXRQ Mask                */
#define CAN_MO_MOSTAT_TXEN0_Pos               9                                                       /*!< CAN_MO MOSTAT: TXEN0 Position           */
#define CAN_MO_MOSTAT_TXEN0_Msk               (0x01UL << CAN_MO_MOSTAT_TXEN0_Pos)                     /*!< CAN_MO MOSTAT: TXEN0 Mask               */
#define CAN_MO_MOSTAT_TXEN1_Pos               10                                                      /*!< CAN_MO MOSTAT: TXEN1 Position           */
#define CAN_MO_MOSTAT_TXEN1_Msk               (0x01UL << CAN_MO_MOSTAT_TXEN1_Pos)                     /*!< CAN_MO MOSTAT: TXEN1 Mask               */
#define CAN_MO_MOSTAT_DIR_Pos                 11                                                      /*!< CAN_MO MOSTAT: DIR Position             */
#define CAN_MO_MOSTAT_DIR_Msk                 (0x01UL << CAN_MO_MOSTAT_DIR_Pos)                       /*!< CAN_MO MOSTAT: DIR Mask                 */
#define CAN_MO_MOSTAT_LIST_Pos                12                                                      /*!< CAN_MO MOSTAT: LIST Position            */
#define CAN_MO_MOSTAT_LIST_Msk                (0x0fUL << CAN_MO_MOSTAT_LIST_Pos)                      /*!< CAN_MO MOSTAT: LIST Mask                */
#define CAN_MO_MOSTAT_PPREV_Pos               16                                                      /*!< CAN_MO MOSTAT: PPREV Position           */
#define CAN_MO_MOSTAT_PPREV_Msk               (0x000000ffUL << CAN_MO_MOSTAT_PPREV_Pos)               /*!< CAN_MO MOSTAT: PPREV Mask               */
#define CAN_MO_MOSTAT_PNEXT_Pos               24                                                      /*!< CAN_MO MOSTAT: PNEXT Position           */
#define CAN_MO_MOSTAT_PNEXT_Msk               (0x000000ffUL << CAN_MO_MOSTAT_PNEXT_Pos)               /*!< CAN_MO MOSTAT: PNEXT Mask               */


/* ================================================================================ */
/* ================          struct 'VADC' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  VADC_CLC  ---------------------------------- */
#define VADC_CLC_DISR_Pos                     0                                                       /*!< VADC CLC: DISR Position                 */
#define VADC_CLC_DISR_Msk                     (0x01UL << VADC_CLC_DISR_Pos)                           /*!< VADC CLC: DISR Mask                     */
#define VADC_CLC_DISS_Pos                     1                                                       /*!< VADC CLC: DISS Position                 */
#define VADC_CLC_DISS_Msk                     (0x01UL << VADC_CLC_DISS_Pos)                           /*!< VADC CLC: DISS Mask                     */
#define VADC_CLC_EDIS_Pos                     3                                                       /*!< VADC CLC: EDIS Position                 */
#define VADC_CLC_EDIS_Msk                     (0x01UL << VADC_CLC_EDIS_Pos)                           /*!< VADC CLC: EDIS Mask                     */

/* -----------------------------------  VADC_ID  ---------------------------------- */
#define VADC_ID_MOD_REV_Pos                   0                                                       /*!< VADC ID: MOD_REV Position               */
#define VADC_ID_MOD_REV_Msk                   (0x000000ffUL << VADC_ID_MOD_REV_Pos)                   /*!< VADC ID: MOD_REV Mask                   */
#define VADC_ID_MOD_TYPE_Pos                  8                                                       /*!< VADC ID: MOD_TYPE Position              */
#define VADC_ID_MOD_TYPE_Msk                  (0x000000ffUL << VADC_ID_MOD_TYPE_Pos)                  /*!< VADC ID: MOD_TYPE Mask                  */
#define VADC_ID_MOD_NUMBER_Pos                16                                                      /*!< VADC ID: MOD_NUMBER Position            */
#define VADC_ID_MOD_NUMBER_Msk                (0x0000ffffUL << VADC_ID_MOD_NUMBER_Pos)                /*!< VADC ID: MOD_NUMBER Mask                */

/* ----------------------------------  VADC_OCS  ---------------------------------- */
#define VADC_OCS_TGS_Pos                      0                                                       /*!< VADC OCS: TGS Position                  */
#define VADC_OCS_TGS_Msk                      (0x03UL << VADC_OCS_TGS_Pos)                            /*!< VADC OCS: TGS Mask                      */
#define VADC_OCS_TGB_Pos                      2                                                       /*!< VADC OCS: TGB Position                  */
#define VADC_OCS_TGB_Msk                      (0x01UL << VADC_OCS_TGB_Pos)                            /*!< VADC OCS: TGB Mask                      */
#define VADC_OCS_TG_P_Pos                     3                                                       /*!< VADC OCS: TG_P Position                 */
#define VADC_OCS_TG_P_Msk                     (0x01UL << VADC_OCS_TG_P_Pos)                           /*!< VADC OCS: TG_P Mask                     */
#define VADC_OCS_SUS_Pos                      24                                                      /*!< VADC OCS: SUS Position                  */
#define VADC_OCS_SUS_Msk                      (0x0fUL << VADC_OCS_SUS_Pos)                            /*!< VADC OCS: SUS Mask                      */
#define VADC_OCS_SUS_P_Pos                    28                                                      /*!< VADC OCS: SUS_P Position                */
#define VADC_OCS_SUS_P_Msk                    (0x01UL << VADC_OCS_SUS_P_Pos)                          /*!< VADC OCS: SUS_P Mask                    */
#define VADC_OCS_SUSSTA_Pos                   29                                                      /*!< VADC OCS: SUSSTA Position               */
#define VADC_OCS_SUSSTA_Msk                   (0x01UL << VADC_OCS_SUSSTA_Pos)                         /*!< VADC OCS: SUSSTA Mask                   */

/* --------------------------------  VADC_GLOBCFG  -------------------------------- */
#define VADC_GLOBCFG_DIVA_Pos                 0                                                       /*!< VADC GLOBCFG: DIVA Position             */
#define VADC_GLOBCFG_DIVA_Msk                 (0x1fUL << VADC_GLOBCFG_DIVA_Pos)                       /*!< VADC GLOBCFG: DIVA Mask                 */
#define VADC_GLOBCFG_DCMSB_Pos                7                                                       /*!< VADC GLOBCFG: DCMSB Position            */
#define VADC_GLOBCFG_DCMSB_Msk                (0x01UL << VADC_GLOBCFG_DCMSB_Pos)                      /*!< VADC GLOBCFG: DCMSB Mask                */
#define VADC_GLOBCFG_DIVD_Pos                 8                                                       /*!< VADC GLOBCFG: DIVD Position             */
#define VADC_GLOBCFG_DIVD_Msk                 (0x03UL << VADC_GLOBCFG_DIVD_Pos)                       /*!< VADC GLOBCFG: DIVD Mask                 */
#define VADC_GLOBCFG_DIVWC_Pos                15                                                      /*!< VADC GLOBCFG: DIVWC Position            */
#define VADC_GLOBCFG_DIVWC_Msk                (0x01UL << VADC_GLOBCFG_DIVWC_Pos)                      /*!< VADC GLOBCFG: DIVWC Mask                */
#define VADC_GLOBCFG_DPCAL0_Pos               16                                                      /*!< VADC GLOBCFG: DPCAL0 Position           */
#define VADC_GLOBCFG_DPCAL0_Msk               (0x01UL << VADC_GLOBCFG_DPCAL0_Pos)                     /*!< VADC GLOBCFG: DPCAL0 Mask               */
#define VADC_GLOBCFG_DPCAL1_Pos               17                                                      /*!< VADC GLOBCFG: DPCAL1 Position           */
#define VADC_GLOBCFG_DPCAL1_Msk               (0x01UL << VADC_GLOBCFG_DPCAL1_Pos)                     /*!< VADC GLOBCFG: DPCAL1 Mask               */
#define VADC_GLOBCFG_DPCAL2_Pos               18                                                      /*!< VADC GLOBCFG: DPCAL2 Position           */
#define VADC_GLOBCFG_DPCAL2_Msk               (0x01UL << VADC_GLOBCFG_DPCAL2_Pos)                     /*!< VADC GLOBCFG: DPCAL2 Mask               */
#define VADC_GLOBCFG_DPCAL3_Pos               19                                                      /*!< VADC GLOBCFG: DPCAL3 Position           */
#define VADC_GLOBCFG_DPCAL3_Msk               (0x01UL << VADC_GLOBCFG_DPCAL3_Pos)                     /*!< VADC GLOBCFG: DPCAL3 Mask               */
#define VADC_GLOBCFG_SUCAL_Pos                31                                                      /*!< VADC GLOBCFG: SUCAL Position            */
#define VADC_GLOBCFG_SUCAL_Msk                (0x01UL << VADC_GLOBCFG_SUCAL_Pos)                      /*!< VADC GLOBCFG: SUCAL Mask                */

/* -------------------------------  VADC_GLOBICLASS  ------------------------------ */
#define VADC_GLOBICLASS_STCS_Pos              0                                                       /*!< VADC GLOBICLASS: STCS Position          */
#define VADC_GLOBICLASS_STCS_Msk              (0x1fUL << VADC_GLOBICLASS_STCS_Pos)                    /*!< VADC GLOBICLASS: STCS Mask              */
#define VADC_GLOBICLASS_CMS_Pos               8                                                       /*!< VADC GLOBICLASS: CMS Position           */
#define VADC_GLOBICLASS_CMS_Msk               (0x07UL << VADC_GLOBICLASS_CMS_Pos)                     /*!< VADC GLOBICLASS: CMS Mask               */
#define VADC_GLOBICLASS_STCE_Pos              16                                                      /*!< VADC GLOBICLASS: STCE Position          */
#define VADC_GLOBICLASS_STCE_Msk              (0x1fUL << VADC_GLOBICLASS_STCE_Pos)                    /*!< VADC GLOBICLASS: STCE Mask              */
#define VADC_GLOBICLASS_CME_Pos               24                                                      /*!< VADC GLOBICLASS: CME Position           */
#define VADC_GLOBICLASS_CME_Msk               (0x07UL << VADC_GLOBICLASS_CME_Pos)                     /*!< VADC GLOBICLASS: CME Mask               */

/* -------------------------------  VADC_GLOBBOUND  ------------------------------- */
#define VADC_GLOBBOUND_BOUNDARY0_Pos          0                                                       /*!< VADC GLOBBOUND: BOUNDARY0 Position      */
#define VADC_GLOBBOUND_BOUNDARY0_Msk          (0x00000fffUL << VADC_GLOBBOUND_BOUNDARY0_Pos)          /*!< VADC GLOBBOUND: BOUNDARY0 Mask          */
#define VADC_GLOBBOUND_BOUNDARY1_Pos          16                                                      /*!< VADC GLOBBOUND: BOUNDARY1 Position      */
#define VADC_GLOBBOUND_BOUNDARY1_Msk          (0x00000fffUL << VADC_GLOBBOUND_BOUNDARY1_Pos)          /*!< VADC GLOBBOUND: BOUNDARY1 Mask          */

/* -------------------------------  VADC_GLOBEFLAG  ------------------------------- */
#define VADC_GLOBEFLAG_SEVGLB_Pos             0                                                       /*!< VADC GLOBEFLAG: SEVGLB Position         */
#define VADC_GLOBEFLAG_SEVGLB_Msk             (0x01UL << VADC_GLOBEFLAG_SEVGLB_Pos)                   /*!< VADC GLOBEFLAG: SEVGLB Mask             */
#define VADC_GLOBEFLAG_REVGLB_Pos             8                                                       /*!< VADC GLOBEFLAG: REVGLB Position         */
#define VADC_GLOBEFLAG_REVGLB_Msk             (0x01UL << VADC_GLOBEFLAG_REVGLB_Pos)                   /*!< VADC GLOBEFLAG: REVGLB Mask             */
#define VADC_GLOBEFLAG_SEVGLBCLR_Pos          16                                                      /*!< VADC GLOBEFLAG: SEVGLBCLR Position      */
#define VADC_GLOBEFLAG_SEVGLBCLR_Msk          (0x01UL << VADC_GLOBEFLAG_SEVGLBCLR_Pos)                /*!< VADC GLOBEFLAG: SEVGLBCLR Mask          */
#define VADC_GLOBEFLAG_REVGLBCLR_Pos          24                                                      /*!< VADC GLOBEFLAG: REVGLBCLR Position      */
#define VADC_GLOBEFLAG_REVGLBCLR_Msk          (0x01UL << VADC_GLOBEFLAG_REVGLBCLR_Pos)                /*!< VADC GLOBEFLAG: REVGLBCLR Mask          */

/* --------------------------------  VADC_GLOBEVNP  ------------------------------- */
#define VADC_GLOBEVNP_SEV0NP_Pos              0                                                       /*!< VADC GLOBEVNP: SEV0NP Position          */
#define VADC_GLOBEVNP_SEV0NP_Msk              (0x0fUL << VADC_GLOBEVNP_SEV0NP_Pos)                    /*!< VADC GLOBEVNP: SEV0NP Mask              */
#define VADC_GLOBEVNP_REV0NP_Pos              16                                                      /*!< VADC GLOBEVNP: REV0NP Position          */
#define VADC_GLOBEVNP_REV0NP_Msk              (0x0fUL << VADC_GLOBEVNP_REV0NP_Pos)                    /*!< VADC GLOBEVNP: REV0NP Mask              */

/* ---------------------------------  VADC_GLOBTF  -------------------------------- */
#define VADC_GLOBTF_CDGR_Pos                  4                                                       /*!< VADC GLOBTF: CDGR Position              */
#define VADC_GLOBTF_CDGR_Msk                  (0x0fUL << VADC_GLOBTF_CDGR_Pos)                        /*!< VADC GLOBTF: CDGR Mask                  */
#define VADC_GLOBTF_CDEN_Pos                  8                                                       /*!< VADC GLOBTF: CDEN Position              */
#define VADC_GLOBTF_CDEN_Msk                  (0x01UL << VADC_GLOBTF_CDEN_Pos)                        /*!< VADC GLOBTF: CDEN Mask                  */
#define VADC_GLOBTF_CDSEL_Pos                 9                                                       /*!< VADC GLOBTF: CDSEL Position             */
#define VADC_GLOBTF_CDSEL_Msk                 (0x03UL << VADC_GLOBTF_CDSEL_Pos)                       /*!< VADC GLOBTF: CDSEL Mask                 */
#define VADC_GLOBTF_CDWC_Pos                  15                                                      /*!< VADC GLOBTF: CDWC Position              */
#define VADC_GLOBTF_CDWC_Msk                  (0x01UL << VADC_GLOBTF_CDWC_Pos)                        /*!< VADC GLOBTF: CDWC Mask                  */
#define VADC_GLOBTF_PDD_Pos                   16                                                      /*!< VADC GLOBTF: PDD Position               */
#define VADC_GLOBTF_PDD_Msk                   (0x01UL << VADC_GLOBTF_PDD_Pos)                         /*!< VADC GLOBTF: PDD Mask                   */
#define VADC_GLOBTF_MDWC_Pos                  23                                                      /*!< VADC GLOBTF: MDWC Position              */
#define VADC_GLOBTF_MDWC_Msk                  (0x01UL << VADC_GLOBTF_MDWC_Pos)                        /*!< VADC GLOBTF: MDWC Mask                  */

/* ---------------------------------  VADC_BRSSEL  -------------------------------- */
#define VADC_BRSSEL_CHSELG0_Pos               0                                                       /*!< VADC BRSSEL: CHSELG0 Position           */
#define VADC_BRSSEL_CHSELG0_Msk               (0x01UL << VADC_BRSSEL_CHSELG0_Pos)                     /*!< VADC BRSSEL: CHSELG0 Mask               */
#define VADC_BRSSEL_CHSELG1_Pos               1                                                       /*!< VADC BRSSEL: CHSELG1 Position           */
#define VADC_BRSSEL_CHSELG1_Msk               (0x01UL << VADC_BRSSEL_CHSELG1_Pos)                     /*!< VADC BRSSEL: CHSELG1 Mask               */
#define VADC_BRSSEL_CHSELG2_Pos               2                                                       /*!< VADC BRSSEL: CHSELG2 Position           */
#define VADC_BRSSEL_CHSELG2_Msk               (0x01UL << VADC_BRSSEL_CHSELG2_Pos)                     /*!< VADC BRSSEL: CHSELG2 Mask               */
#define VADC_BRSSEL_CHSELG3_Pos               3                                                       /*!< VADC BRSSEL: CHSELG3 Position           */
#define VADC_BRSSEL_CHSELG3_Msk               (0x01UL << VADC_BRSSEL_CHSELG3_Pos)                     /*!< VADC BRSSEL: CHSELG3 Mask               */
#define VADC_BRSSEL_CHSELG4_Pos               4                                                       /*!< VADC BRSSEL: CHSELG4 Position           */
#define VADC_BRSSEL_CHSELG4_Msk               (0x01UL << VADC_BRSSEL_CHSELG4_Pos)                     /*!< VADC BRSSEL: CHSELG4 Mask               */
#define VADC_BRSSEL_CHSELG5_Pos               5                                                       /*!< VADC BRSSEL: CHSELG5 Position           */
#define VADC_BRSSEL_CHSELG5_Msk               (0x01UL << VADC_BRSSEL_CHSELG5_Pos)                     /*!< VADC BRSSEL: CHSELG5 Mask               */
#define VADC_BRSSEL_CHSELG6_Pos               6                                                       /*!< VADC BRSSEL: CHSELG6 Position           */
#define VADC_BRSSEL_CHSELG6_Msk               (0x01UL << VADC_BRSSEL_CHSELG6_Pos)                     /*!< VADC BRSSEL: CHSELG6 Mask               */
#define VADC_BRSSEL_CHSELG7_Pos               7                                                       /*!< VADC BRSSEL: CHSELG7 Position           */
#define VADC_BRSSEL_CHSELG7_Msk               (0x01UL << VADC_BRSSEL_CHSELG7_Pos)                     /*!< VADC BRSSEL: CHSELG7 Mask               */

/* ---------------------------------  VADC_BRSPND  -------------------------------- */
#define VADC_BRSPND_CHPNDG0_Pos               0                                                       /*!< VADC BRSPND: CHPNDG0 Position           */
#define VADC_BRSPND_CHPNDG0_Msk               (0x01UL << VADC_BRSPND_CHPNDG0_Pos)                     /*!< VADC BRSPND: CHPNDG0 Mask               */
#define VADC_BRSPND_CHPNDG1_Pos               1                                                       /*!< VADC BRSPND: CHPNDG1 Position           */
#define VADC_BRSPND_CHPNDG1_Msk               (0x01UL << VADC_BRSPND_CHPNDG1_Pos)                     /*!< VADC BRSPND: CHPNDG1 Mask               */
#define VADC_BRSPND_CHPNDG2_Pos               2                                                       /*!< VADC BRSPND: CHPNDG2 Position           */
#define VADC_BRSPND_CHPNDG2_Msk               (0x01UL << VADC_BRSPND_CHPNDG2_Pos)                     /*!< VADC BRSPND: CHPNDG2 Mask               */
#define VADC_BRSPND_CHPNDG3_Pos               3                                                       /*!< VADC BRSPND: CHPNDG3 Position           */
#define VADC_BRSPND_CHPNDG3_Msk               (0x01UL << VADC_BRSPND_CHPNDG3_Pos)                     /*!< VADC BRSPND: CHPNDG3 Mask               */
#define VADC_BRSPND_CHPNDG4_Pos               4                                                       /*!< VADC BRSPND: CHPNDG4 Position           */
#define VADC_BRSPND_CHPNDG4_Msk               (0x01UL << VADC_BRSPND_CHPNDG4_Pos)                     /*!< VADC BRSPND: CHPNDG4 Mask               */
#define VADC_BRSPND_CHPNDG5_Pos               5                                                       /*!< VADC BRSPND: CHPNDG5 Position           */
#define VADC_BRSPND_CHPNDG5_Msk               (0x01UL << VADC_BRSPND_CHPNDG5_Pos)                     /*!< VADC BRSPND: CHPNDG5 Mask               */
#define VADC_BRSPND_CHPNDG6_Pos               6                                                       /*!< VADC BRSPND: CHPNDG6 Position           */
#define VADC_BRSPND_CHPNDG6_Msk               (0x01UL << VADC_BRSPND_CHPNDG6_Pos)                     /*!< VADC BRSPND: CHPNDG6 Mask               */
#define VADC_BRSPND_CHPNDG7_Pos               7                                                       /*!< VADC BRSPND: CHPNDG7 Position           */
#define VADC_BRSPND_CHPNDG7_Msk               (0x01UL << VADC_BRSPND_CHPNDG7_Pos)                     /*!< VADC BRSPND: CHPNDG7 Mask               */

/* --------------------------------  VADC_BRSCTRL  -------------------------------- */
#define VADC_BRSCTRL_XTSEL_Pos                8                                                       /*!< VADC BRSCTRL: XTSEL Position            */
#define VADC_BRSCTRL_XTSEL_Msk                (0x0fUL << VADC_BRSCTRL_XTSEL_Pos)                      /*!< VADC BRSCTRL: XTSEL Mask                */
#define VADC_BRSCTRL_XTLVL_Pos                12                                                      /*!< VADC BRSCTRL: XTLVL Position            */
#define VADC_BRSCTRL_XTLVL_Msk                (0x01UL << VADC_BRSCTRL_XTLVL_Pos)                      /*!< VADC BRSCTRL: XTLVL Mask                */
#define VADC_BRSCTRL_XTMODE_Pos               13                                                      /*!< VADC BRSCTRL: XTMODE Position           */
#define VADC_BRSCTRL_XTMODE_Msk               (0x03UL << VADC_BRSCTRL_XTMODE_Pos)                     /*!< VADC BRSCTRL: XTMODE Mask               */
#define VADC_BRSCTRL_XTWC_Pos                 15                                                      /*!< VADC BRSCTRL: XTWC Position             */
#define VADC_BRSCTRL_XTWC_Msk                 (0x01UL << VADC_BRSCTRL_XTWC_Pos)                       /*!< VADC BRSCTRL: XTWC Mask                 */
#define VADC_BRSCTRL_GTSEL_Pos                16                                                      /*!< VADC BRSCTRL: GTSEL Position            */
#define VADC_BRSCTRL_GTSEL_Msk                (0x0fUL << VADC_BRSCTRL_GTSEL_Pos)                      /*!< VADC BRSCTRL: GTSEL Mask                */
#define VADC_BRSCTRL_GTLVL_Pos                20                                                      /*!< VADC BRSCTRL: GTLVL Position            */
#define VADC_BRSCTRL_GTLVL_Msk                (0x01UL << VADC_BRSCTRL_GTLVL_Pos)                      /*!< VADC BRSCTRL: GTLVL Mask                */
#define VADC_BRSCTRL_GTWC_Pos                 23                                                      /*!< VADC BRSCTRL: GTWC Position             */
#define VADC_BRSCTRL_GTWC_Msk                 (0x01UL << VADC_BRSCTRL_GTWC_Pos)                       /*!< VADC BRSCTRL: GTWC Mask                 */

/* ---------------------------------  VADC_BRSMR  --------------------------------- */
#define VADC_BRSMR_ENGT_Pos                   0                                                       /*!< VADC BRSMR: ENGT Position               */
#define VADC_BRSMR_ENGT_Msk                   (0x03UL << VADC_BRSMR_ENGT_Pos)                         /*!< VADC BRSMR: ENGT Mask                   */
#define VADC_BRSMR_ENTR_Pos                   2                                                       /*!< VADC BRSMR: ENTR Position               */
#define VADC_BRSMR_ENTR_Msk                   (0x01UL << VADC_BRSMR_ENTR_Pos)                         /*!< VADC BRSMR: ENTR Mask                   */
#define VADC_BRSMR_ENSI_Pos                   3                                                       /*!< VADC BRSMR: ENSI Position               */
#define VADC_BRSMR_ENSI_Msk                   (0x01UL << VADC_BRSMR_ENSI_Pos)                         /*!< VADC BRSMR: ENSI Mask                   */
#define VADC_BRSMR_SCAN_Pos                   4                                                       /*!< VADC BRSMR: SCAN Position               */
#define VADC_BRSMR_SCAN_Msk                   (0x01UL << VADC_BRSMR_SCAN_Pos)                         /*!< VADC BRSMR: SCAN Mask                   */
#define VADC_BRSMR_LDM_Pos                    5                                                       /*!< VADC BRSMR: LDM Position                */
#define VADC_BRSMR_LDM_Msk                    (0x01UL << VADC_BRSMR_LDM_Pos)                          /*!< VADC BRSMR: LDM Mask                    */
#define VADC_BRSMR_REQGT_Pos                  7                                                       /*!< VADC BRSMR: REQGT Position              */
#define VADC_BRSMR_REQGT_Msk                  (0x01UL << VADC_BRSMR_REQGT_Pos)                        /*!< VADC BRSMR: REQGT Mask                  */
#define VADC_BRSMR_CLRPND_Pos                 8                                                       /*!< VADC BRSMR: CLRPND Position             */
#define VADC_BRSMR_CLRPND_Msk                 (0x01UL << VADC_BRSMR_CLRPND_Pos)                       /*!< VADC BRSMR: CLRPND Mask                 */
#define VADC_BRSMR_LDEV_Pos                   9                                                       /*!< VADC BRSMR: LDEV Position               */
#define VADC_BRSMR_LDEV_Msk                   (0x01UL << VADC_BRSMR_LDEV_Pos)                         /*!< VADC BRSMR: LDEV Mask                   */
#define VADC_BRSMR_RPTDIS_Pos                 16                                                      /*!< VADC BRSMR: RPTDIS Position             */
#define VADC_BRSMR_RPTDIS_Msk                 (0x01UL << VADC_BRSMR_RPTDIS_Pos)                       /*!< VADC BRSMR: RPTDIS Mask                 */

/* --------------------------------  VADC_GLOBRCR  -------------------------------- */
#define VADC_GLOBRCR_DRCTR_Pos                16                                                      /*!< VADC GLOBRCR: DRCTR Position            */
#define VADC_GLOBRCR_DRCTR_Msk                (0x0fUL << VADC_GLOBRCR_DRCTR_Pos)                      /*!< VADC GLOBRCR: DRCTR Mask                */
#define VADC_GLOBRCR_WFR_Pos                  24                                                      /*!< VADC GLOBRCR: WFR Position              */
#define VADC_GLOBRCR_WFR_Msk                  (0x01UL << VADC_GLOBRCR_WFR_Pos)                        /*!< VADC GLOBRCR: WFR Mask                  */
#define VADC_GLOBRCR_SRGEN_Pos                31                                                      /*!< VADC GLOBRCR: SRGEN Position            */
#define VADC_GLOBRCR_SRGEN_Msk                (0x01UL << VADC_GLOBRCR_SRGEN_Pos)                      /*!< VADC GLOBRCR: SRGEN Mask                */

/* --------------------------------  VADC_GLOBRES  -------------------------------- */
#define VADC_GLOBRES_RESULT_Pos               0                                                       /*!< VADC GLOBRES: RESULT Position           */
#define VADC_GLOBRES_RESULT_Msk               (0x0000ffffUL << VADC_GLOBRES_RESULT_Pos)               /*!< VADC GLOBRES: RESULT Mask               */
#define VADC_GLOBRES_GNR_Pos                  16                                                      /*!< VADC GLOBRES: GNR Position              */
#define VADC_GLOBRES_GNR_Msk                  (0x0fUL << VADC_GLOBRES_GNR_Pos)                        /*!< VADC GLOBRES: GNR Mask                  */
#define VADC_GLOBRES_CHNR_Pos                 20                                                      /*!< VADC GLOBRES: CHNR Position             */
#define VADC_GLOBRES_CHNR_Msk                 (0x1fUL << VADC_GLOBRES_CHNR_Pos)                       /*!< VADC GLOBRES: CHNR Mask                 */
#define VADC_GLOBRES_EMUX_Pos                 25                                                      /*!< VADC GLOBRES: EMUX Position             */
#define VADC_GLOBRES_EMUX_Msk                 (0x07UL << VADC_GLOBRES_EMUX_Pos)                       /*!< VADC GLOBRES: EMUX Mask                 */
#define VADC_GLOBRES_CRS_Pos                  28                                                      /*!< VADC GLOBRES: CRS Position              */
#define VADC_GLOBRES_CRS_Msk                  (0x03UL << VADC_GLOBRES_CRS_Pos)                        /*!< VADC GLOBRES: CRS Mask                  */
#define VADC_GLOBRES_FCR_Pos                  30                                                      /*!< VADC GLOBRES: FCR Position              */
#define VADC_GLOBRES_FCR_Msk                  (0x01UL << VADC_GLOBRES_FCR_Pos)                        /*!< VADC GLOBRES: FCR Mask                  */
#define VADC_GLOBRES_VF_Pos                   31                                                      /*!< VADC GLOBRES: VF Position               */
#define VADC_GLOBRES_VF_Msk                   (0x01UL << VADC_GLOBRES_VF_Pos)                         /*!< VADC GLOBRES: VF Mask                   */

/* --------------------------------  VADC_GLOBRESD  ------------------------------- */
#define VADC_GLOBRESD_RESULT_Pos              0                                                       /*!< VADC GLOBRESD: RESULT Position          */
#define VADC_GLOBRESD_RESULT_Msk              (0x0000ffffUL << VADC_GLOBRESD_RESULT_Pos)              /*!< VADC GLOBRESD: RESULT Mask              */
#define VADC_GLOBRESD_GNR_Pos                 16                                                      /*!< VADC GLOBRESD: GNR Position             */
#define VADC_GLOBRESD_GNR_Msk                 (0x0fUL << VADC_GLOBRESD_GNR_Pos)                       /*!< VADC GLOBRESD: GNR Mask                 */
#define VADC_GLOBRESD_CHNR_Pos                20                                                      /*!< VADC GLOBRESD: CHNR Position            */
#define VADC_GLOBRESD_CHNR_Msk                (0x1fUL << VADC_GLOBRESD_CHNR_Pos)                      /*!< VADC GLOBRESD: CHNR Mask                */
#define VADC_GLOBRESD_EMUX_Pos                25                                                      /*!< VADC GLOBRESD: EMUX Position            */
#define VADC_GLOBRESD_EMUX_Msk                (0x07UL << VADC_GLOBRESD_EMUX_Pos)                      /*!< VADC GLOBRESD: EMUX Mask                */
#define VADC_GLOBRESD_CRS_Pos                 28                                                      /*!< VADC GLOBRESD: CRS Position             */
#define VADC_GLOBRESD_CRS_Msk                 (0x03UL << VADC_GLOBRESD_CRS_Pos)                       /*!< VADC GLOBRESD: CRS Mask                 */
#define VADC_GLOBRESD_FCR_Pos                 30                                                      /*!< VADC GLOBRESD: FCR Position             */
#define VADC_GLOBRESD_FCR_Msk                 (0x01UL << VADC_GLOBRESD_FCR_Pos)                       /*!< VADC GLOBRESD: FCR Mask                 */
#define VADC_GLOBRESD_VF_Pos                  31                                                      /*!< VADC GLOBRESD: VF Position              */
#define VADC_GLOBRESD_VF_Msk                  (0x01UL << VADC_GLOBRESD_VF_Pos)                        /*!< VADC GLOBRESD: VF Mask                  */

/* --------------------------------  VADC_EMUXSEL  -------------------------------- */
#define VADC_EMUXSEL_EMUXGRP0_Pos             0                                                       /*!< VADC EMUXSEL: EMUXGRP0 Position         */
#define VADC_EMUXSEL_EMUXGRP0_Msk             (0x0fUL << VADC_EMUXSEL_EMUXGRP0_Pos)                   /*!< VADC EMUXSEL: EMUXGRP0 Mask             */
#define VADC_EMUXSEL_EMUXGRP1_Pos             4                                                       /*!< VADC EMUXSEL: EMUXGRP1 Position         */
#define VADC_EMUXSEL_EMUXGRP1_Msk             (0x0fUL << VADC_EMUXSEL_EMUXGRP1_Pos)                   /*!< VADC EMUXSEL: EMUXGRP1 Mask             */


/* ================================================================================ */
/* ================         Group 'VADC_G' Position & Mask         ================ */
/* ================================================================================ */


/* --------------------------------  VADC_G_ARBCFG  ------------------------------- */
#define VADC_G_ARBCFG_ANONC_Pos               0                                                       /*!< VADC_G ARBCFG: ANONC Position           */
#define VADC_G_ARBCFG_ANONC_Msk               (0x03UL << VADC_G_ARBCFG_ANONC_Pos)                     /*!< VADC_G ARBCFG: ANONC Mask               */
#define VADC_G_ARBCFG_ARBRND_Pos              4                                                       /*!< VADC_G ARBCFG: ARBRND Position          */
#define VADC_G_ARBCFG_ARBRND_Msk              (0x03UL << VADC_G_ARBCFG_ARBRND_Pos)                    /*!< VADC_G ARBCFG: ARBRND Mask              */
#define VADC_G_ARBCFG_ARBM_Pos                7                                                       /*!< VADC_G ARBCFG: ARBM Position            */
#define VADC_G_ARBCFG_ARBM_Msk                (0x01UL << VADC_G_ARBCFG_ARBM_Pos)                      /*!< VADC_G ARBCFG: ARBM Mask                */
#define VADC_G_ARBCFG_ANONS_Pos               16                                                      /*!< VADC_G ARBCFG: ANONS Position           */
#define VADC_G_ARBCFG_ANONS_Msk               (0x03UL << VADC_G_ARBCFG_ANONS_Pos)                     /*!< VADC_G ARBCFG: ANONS Mask               */
#define VADC_G_ARBCFG_CAL_Pos                 28                                                      /*!< VADC_G ARBCFG: CAL Position             */
#define VADC_G_ARBCFG_CAL_Msk                 (0x01UL << VADC_G_ARBCFG_CAL_Pos)                       /*!< VADC_G ARBCFG: CAL Mask                 */
#define VADC_G_ARBCFG_BUSY_Pos                30                                                      /*!< VADC_G ARBCFG: BUSY Position            */
#define VADC_G_ARBCFG_BUSY_Msk                (0x01UL << VADC_G_ARBCFG_BUSY_Pos)                      /*!< VADC_G ARBCFG: BUSY Mask                */
#define VADC_G_ARBCFG_SAMPLE_Pos              31                                                      /*!< VADC_G ARBCFG: SAMPLE Position          */
#define VADC_G_ARBCFG_SAMPLE_Msk              (0x01UL << VADC_G_ARBCFG_SAMPLE_Pos)                    /*!< VADC_G ARBCFG: SAMPLE Mask              */

/* --------------------------------  VADC_G_ARBPR  -------------------------------- */
#define VADC_G_ARBPR_PRIO0_Pos                0                                                       /*!< VADC_G ARBPR: PRIO0 Position            */
#define VADC_G_ARBPR_PRIO0_Msk                (0x03UL << VADC_G_ARBPR_PRIO0_Pos)                      /*!< VADC_G ARBPR: PRIO0 Mask                */
#define VADC_G_ARBPR_CSM0_Pos                 3                                                       /*!< VADC_G ARBPR: CSM0 Position             */
#define VADC_G_ARBPR_CSM0_Msk                 (0x01UL << VADC_G_ARBPR_CSM0_Pos)                       /*!< VADC_G ARBPR: CSM0 Mask                 */
#define VADC_G_ARBPR_PRIO1_Pos                4                                                       /*!< VADC_G ARBPR: PRIO1 Position            */
#define VADC_G_ARBPR_PRIO1_Msk                (0x03UL << VADC_G_ARBPR_PRIO1_Pos)                      /*!< VADC_G ARBPR: PRIO1 Mask                */
#define VADC_G_ARBPR_CSM1_Pos                 7                                                       /*!< VADC_G ARBPR: CSM1 Position             */
#define VADC_G_ARBPR_CSM1_Msk                 (0x01UL << VADC_G_ARBPR_CSM1_Pos)                       /*!< VADC_G ARBPR: CSM1 Mask                 */
#define VADC_G_ARBPR_PRIO2_Pos                8                                                       /*!< VADC_G ARBPR: PRIO2 Position            */
#define VADC_G_ARBPR_PRIO2_Msk                (0x03UL << VADC_G_ARBPR_PRIO2_Pos)                      /*!< VADC_G ARBPR: PRIO2 Mask                */
#define VADC_G_ARBPR_CSM2_Pos                 11                                                      /*!< VADC_G ARBPR: CSM2 Position             */
#define VADC_G_ARBPR_CSM2_Msk                 (0x01UL << VADC_G_ARBPR_CSM2_Pos)                       /*!< VADC_G ARBPR: CSM2 Mask                 */
#define VADC_G_ARBPR_ASEN0_Pos                24                                                      /*!< VADC_G ARBPR: ASEN0 Position            */
#define VADC_G_ARBPR_ASEN0_Msk                (0x01UL << VADC_G_ARBPR_ASEN0_Pos)                      /*!< VADC_G ARBPR: ASEN0 Mask                */
#define VADC_G_ARBPR_ASEN1_Pos                25                                                      /*!< VADC_G ARBPR: ASEN1 Position            */
#define VADC_G_ARBPR_ASEN1_Msk                (0x01UL << VADC_G_ARBPR_ASEN1_Pos)                      /*!< VADC_G ARBPR: ASEN1 Mask                */
#define VADC_G_ARBPR_ASEN2_Pos                26                                                      /*!< VADC_G ARBPR: ASEN2 Position            */
#define VADC_G_ARBPR_ASEN2_Msk                (0x01UL << VADC_G_ARBPR_ASEN2_Pos)                      /*!< VADC_G ARBPR: ASEN2 Mask                */

/* --------------------------------  VADC_G_CHASS  -------------------------------- */
#define VADC_G_CHASS_ASSCH0_Pos               0                                                       /*!< VADC_G CHASS: ASSCH0 Position           */
#define VADC_G_CHASS_ASSCH0_Msk               (0x01UL << VADC_G_CHASS_ASSCH0_Pos)                     /*!< VADC_G CHASS: ASSCH0 Mask               */
#define VADC_G_CHASS_ASSCH1_Pos               1                                                       /*!< VADC_G CHASS: ASSCH1 Position           */
#define VADC_G_CHASS_ASSCH1_Msk               (0x01UL << VADC_G_CHASS_ASSCH1_Pos)                     /*!< VADC_G CHASS: ASSCH1 Mask               */
#define VADC_G_CHASS_ASSCH2_Pos               2                                                       /*!< VADC_G CHASS: ASSCH2 Position           */
#define VADC_G_CHASS_ASSCH2_Msk               (0x01UL << VADC_G_CHASS_ASSCH2_Pos)                     /*!< VADC_G CHASS: ASSCH2 Mask               */
#define VADC_G_CHASS_ASSCH3_Pos               3                                                       /*!< VADC_G CHASS: ASSCH3 Position           */
#define VADC_G_CHASS_ASSCH3_Msk               (0x01UL << VADC_G_CHASS_ASSCH3_Pos)                     /*!< VADC_G CHASS: ASSCH3 Mask               */
#define VADC_G_CHASS_ASSCH4_Pos               4                                                       /*!< VADC_G CHASS: ASSCH4 Position           */
#define VADC_G_CHASS_ASSCH4_Msk               (0x01UL << VADC_G_CHASS_ASSCH4_Pos)                     /*!< VADC_G CHASS: ASSCH4 Mask               */
#define VADC_G_CHASS_ASSCH5_Pos               5                                                       /*!< VADC_G CHASS: ASSCH5 Position           */
#define VADC_G_CHASS_ASSCH5_Msk               (0x01UL << VADC_G_CHASS_ASSCH5_Pos)                     /*!< VADC_G CHASS: ASSCH5 Mask               */
#define VADC_G_CHASS_ASSCH6_Pos               6                                                       /*!< VADC_G CHASS: ASSCH6 Position           */
#define VADC_G_CHASS_ASSCH6_Msk               (0x01UL << VADC_G_CHASS_ASSCH6_Pos)                     /*!< VADC_G CHASS: ASSCH6 Mask               */
#define VADC_G_CHASS_ASSCH7_Pos               7                                                       /*!< VADC_G CHASS: ASSCH7 Position           */
#define VADC_G_CHASS_ASSCH7_Msk               (0x01UL << VADC_G_CHASS_ASSCH7_Pos)                     /*!< VADC_G CHASS: ASSCH7 Mask               */

/* --------------------------------  VADC_G_ICLASS  ------------------------------- */
#define VADC_G_ICLASS_STCS_Pos                0                                                       /*!< VADC_G ICLASS: STCS Position            */
#define VADC_G_ICLASS_STCS_Msk                (0x1fUL << VADC_G_ICLASS_STCS_Pos)                      /*!< VADC_G ICLASS: STCS Mask                */
#define VADC_G_ICLASS_CMS_Pos                 8                                                       /*!< VADC_G ICLASS: CMS Position             */
#define VADC_G_ICLASS_CMS_Msk                 (0x07UL << VADC_G_ICLASS_CMS_Pos)                       /*!< VADC_G ICLASS: CMS Mask                 */
#define VADC_G_ICLASS_STCE_Pos                16                                                      /*!< VADC_G ICLASS: STCE Position            */
#define VADC_G_ICLASS_STCE_Msk                (0x1fUL << VADC_G_ICLASS_STCE_Pos)                      /*!< VADC_G ICLASS: STCE Mask                */
#define VADC_G_ICLASS_CME_Pos                 24                                                      /*!< VADC_G ICLASS: CME Position             */
#define VADC_G_ICLASS_CME_Msk                 (0x07UL << VADC_G_ICLASS_CME_Pos)                       /*!< VADC_G ICLASS: CME Mask                 */

/* --------------------------------  VADC_G_ALIAS  -------------------------------- */
#define VADC_G_ALIAS_ALIAS0_Pos               0                                                       /*!< VADC_G ALIAS: ALIAS0 Position           */
#define VADC_G_ALIAS_ALIAS0_Msk               (0x1fUL << VADC_G_ALIAS_ALIAS0_Pos)                     /*!< VADC_G ALIAS: ALIAS0 Mask               */
#define VADC_G_ALIAS_ALIAS1_Pos               8                                                       /*!< VADC_G ALIAS: ALIAS1 Position           */
#define VADC_G_ALIAS_ALIAS1_Msk               (0x1fUL << VADC_G_ALIAS_ALIAS1_Pos)                     /*!< VADC_G ALIAS: ALIAS1 Mask               */

/* --------------------------------  VADC_G_BOUND  -------------------------------- */
#define VADC_G_BOUND_BOUNDARY0_Pos            0                                                       /*!< VADC_G BOUND: BOUNDARY0 Position        */
#define VADC_G_BOUND_BOUNDARY0_Msk            (0x00000fffUL << VADC_G_BOUND_BOUNDARY0_Pos)            /*!< VADC_G BOUND: BOUNDARY0 Mask            */
#define VADC_G_BOUND_BOUNDARY1_Pos            16                                                      /*!< VADC_G BOUND: BOUNDARY1 Position        */
#define VADC_G_BOUND_BOUNDARY1_Msk            (0x00000fffUL << VADC_G_BOUND_BOUNDARY1_Pos)            /*!< VADC_G BOUND: BOUNDARY1 Mask            */

/* --------------------------------  VADC_G_SYNCTR  ------------------------------- */
#define VADC_G_SYNCTR_STSEL_Pos               0                                                       /*!< VADC_G SYNCTR: STSEL Position           */
#define VADC_G_SYNCTR_STSEL_Msk               (0x03UL << VADC_G_SYNCTR_STSEL_Pos)                     /*!< VADC_G SYNCTR: STSEL Mask               */
#define VADC_G_SYNCTR_EVALR1_Pos              4                                                       /*!< VADC_G SYNCTR: EVALR1 Position          */
#define VADC_G_SYNCTR_EVALR1_Msk              (0x01UL << VADC_G_SYNCTR_EVALR1_Pos)                    /*!< VADC_G SYNCTR: EVALR1 Mask              */
#define VADC_G_SYNCTR_EVALR2_Pos              5                                                       /*!< VADC_G SYNCTR: EVALR2 Position          */
#define VADC_G_SYNCTR_EVALR2_Msk              (0x01UL << VADC_G_SYNCTR_EVALR2_Pos)                    /*!< VADC_G SYNCTR: EVALR2 Mask              */
#define VADC_G_SYNCTR_EVALR3_Pos              6                                                       /*!< VADC_G SYNCTR: EVALR3 Position          */
#define VADC_G_SYNCTR_EVALR3_Msk              (0x01UL << VADC_G_SYNCTR_EVALR3_Pos)                    /*!< VADC_G SYNCTR: EVALR3 Mask              */

/* ---------------------------------  VADC_G_BFL  --------------------------------- */
#define VADC_G_BFL_BFL0_Pos                   0                                                       /*!< VADC_G BFL: BFL0 Position               */
#define VADC_G_BFL_BFL0_Msk                   (0x01UL << VADC_G_BFL_BFL0_Pos)                         /*!< VADC_G BFL: BFL0 Mask                   */
#define VADC_G_BFL_BFL1_Pos                   1                                                       /*!< VADC_G BFL: BFL1 Position               */
#define VADC_G_BFL_BFL1_Msk                   (0x01UL << VADC_G_BFL_BFL1_Pos)                         /*!< VADC_G BFL: BFL1 Mask                   */
#define VADC_G_BFL_BFL2_Pos                   2                                                       /*!< VADC_G BFL: BFL2 Position               */
#define VADC_G_BFL_BFL2_Msk                   (0x01UL << VADC_G_BFL_BFL2_Pos)                         /*!< VADC_G BFL: BFL2 Mask                   */
#define VADC_G_BFL_BFL3_Pos                   3                                                       /*!< VADC_G BFL: BFL3 Position               */
#define VADC_G_BFL_BFL3_Msk                   (0x01UL << VADC_G_BFL_BFL3_Pos)                         /*!< VADC_G BFL: BFL3 Mask                   */
#define VADC_G_BFL_BFE0_Pos                   16                                                      /*!< VADC_G BFL: BFE0 Position               */
#define VADC_G_BFL_BFE0_Msk                   (0x01UL << VADC_G_BFL_BFE0_Pos)                         /*!< VADC_G BFL: BFE0 Mask                   */
#define VADC_G_BFL_BFE1_Pos                   17                                                      /*!< VADC_G BFL: BFE1 Position               */
#define VADC_G_BFL_BFE1_Msk                   (0x01UL << VADC_G_BFL_BFE1_Pos)                         /*!< VADC_G BFL: BFE1 Mask                   */
#define VADC_G_BFL_BFE2_Pos                   18                                                      /*!< VADC_G BFL: BFE2 Position               */
#define VADC_G_BFL_BFE2_Msk                   (0x01UL << VADC_G_BFL_BFE2_Pos)                         /*!< VADC_G BFL: BFE2 Mask                   */
#define VADC_G_BFL_BFE3_Pos                   19                                                      /*!< VADC_G BFL: BFE3 Position               */
#define VADC_G_BFL_BFE3_Msk                   (0x01UL << VADC_G_BFL_BFE3_Pos)                         /*!< VADC_G BFL: BFE3 Mask                   */

/* --------------------------------  VADC_G_QCTRL0  ------------------------------- */
#define VADC_G_QCTRL0_XTSEL_Pos               8                                                       /*!< VADC_G QCTRL0: XTSEL Position           */
#define VADC_G_QCTRL0_XTSEL_Msk               (0x0fUL << VADC_G_QCTRL0_XTSEL_Pos)                     /*!< VADC_G QCTRL0: XTSEL Mask               */
#define VADC_G_QCTRL0_XTLVL_Pos               12                                                      /*!< VADC_G QCTRL0: XTLVL Position           */
#define VADC_G_QCTRL0_XTLVL_Msk               (0x01UL << VADC_G_QCTRL0_XTLVL_Pos)                     /*!< VADC_G QCTRL0: XTLVL Mask               */
#define VADC_G_QCTRL0_XTMODE_Pos              13                                                      /*!< VADC_G QCTRL0: XTMODE Position          */
#define VADC_G_QCTRL0_XTMODE_Msk              (0x03UL << VADC_G_QCTRL0_XTMODE_Pos)                    /*!< VADC_G QCTRL0: XTMODE Mask              */
#define VADC_G_QCTRL0_XTWC_Pos                15                                                      /*!< VADC_G QCTRL0: XTWC Position            */
#define VADC_G_QCTRL0_XTWC_Msk                (0x01UL << VADC_G_QCTRL0_XTWC_Pos)                      /*!< VADC_G QCTRL0: XTWC Mask                */
#define VADC_G_QCTRL0_GTSEL_Pos               16                                                      /*!< VADC_G QCTRL0: GTSEL Position           */
#define VADC_G_QCTRL0_GTSEL_Msk               (0x0fUL << VADC_G_QCTRL0_GTSEL_Pos)                     /*!< VADC_G QCTRL0: GTSEL Mask               */
#define VADC_G_QCTRL0_GTLVL_Pos               20                                                      /*!< VADC_G QCTRL0: GTLVL Position           */
#define VADC_G_QCTRL0_GTLVL_Msk               (0x01UL << VADC_G_QCTRL0_GTLVL_Pos)                     /*!< VADC_G QCTRL0: GTLVL Mask               */
#define VADC_G_QCTRL0_GTWC_Pos                23                                                      /*!< VADC_G QCTRL0: GTWC Position            */
#define VADC_G_QCTRL0_GTWC_Msk                (0x01UL << VADC_G_QCTRL0_GTWC_Pos)                      /*!< VADC_G QCTRL0: GTWC Mask                */
#define VADC_G_QCTRL0_TMEN_Pos                28                                                      /*!< VADC_G QCTRL0: TMEN Position            */
#define VADC_G_QCTRL0_TMEN_Msk                (0x01UL << VADC_G_QCTRL0_TMEN_Pos)                      /*!< VADC_G QCTRL0: TMEN Mask                */
#define VADC_G_QCTRL0_TMWC_Pos                31                                                      /*!< VADC_G QCTRL0: TMWC Position            */
#define VADC_G_QCTRL0_TMWC_Msk                (0x01UL << VADC_G_QCTRL0_TMWC_Pos)                      /*!< VADC_G QCTRL0: TMWC Mask                */

/* ---------------------------------  VADC_G_QMR0  -------------------------------- */
#define VADC_G_QMR0_ENGT_Pos                  0                                                       /*!< VADC_G QMR0: ENGT Position              */
#define VADC_G_QMR0_ENGT_Msk                  (0x03UL << VADC_G_QMR0_ENGT_Pos)                        /*!< VADC_G QMR0: ENGT Mask                  */
#define VADC_G_QMR0_ENTR_Pos                  2                                                       /*!< VADC_G QMR0: ENTR Position              */
#define VADC_G_QMR0_ENTR_Msk                  (0x01UL << VADC_G_QMR0_ENTR_Pos)                        /*!< VADC_G QMR0: ENTR Mask                  */
#define VADC_G_QMR0_CLRV_Pos                  8                                                       /*!< VADC_G QMR0: CLRV Position              */
#define VADC_G_QMR0_CLRV_Msk                  (0x01UL << VADC_G_QMR0_CLRV_Pos)                        /*!< VADC_G QMR0: CLRV Mask                  */
#define VADC_G_QMR0_TREV_Pos                  9                                                       /*!< VADC_G QMR0: TREV Position              */
#define VADC_G_QMR0_TREV_Msk                  (0x01UL << VADC_G_QMR0_TREV_Pos)                        /*!< VADC_G QMR0: TREV Mask                  */
#define VADC_G_QMR0_FLUSH_Pos                 10                                                      /*!< VADC_G QMR0: FLUSH Position             */
#define VADC_G_QMR0_FLUSH_Msk                 (0x01UL << VADC_G_QMR0_FLUSH_Pos)                       /*!< VADC_G QMR0: FLUSH Mask                 */
#define VADC_G_QMR0_CEV_Pos                   11                                                      /*!< VADC_G QMR0: CEV Position               */
#define VADC_G_QMR0_CEV_Msk                   (0x01UL << VADC_G_QMR0_CEV_Pos)                         /*!< VADC_G QMR0: CEV Mask                   */
#define VADC_G_QMR0_RPTDIS_Pos                16                                                      /*!< VADC_G QMR0: RPTDIS Position            */
#define VADC_G_QMR0_RPTDIS_Msk                (0x01UL << VADC_G_QMR0_RPTDIS_Pos)                      /*!< VADC_G QMR0: RPTDIS Mask                */

/* ---------------------------------  VADC_G_QSR0  -------------------------------- */
#define VADC_G_QSR0_FILL_Pos                  0                                                       /*!< VADC_G QSR0: FILL Position              */
#define VADC_G_QSR0_FILL_Msk                  (0x0fUL << VADC_G_QSR0_FILL_Pos)                        /*!< VADC_G QSR0: FILL Mask                  */
#define VADC_G_QSR0_EMPTY_Pos                 5                                                       /*!< VADC_G QSR0: EMPTY Position             */
#define VADC_G_QSR0_EMPTY_Msk                 (0x01UL << VADC_G_QSR0_EMPTY_Pos)                       /*!< VADC_G QSR0: EMPTY Mask                 */
#define VADC_G_QSR0_REQGT_Pos                 7                                                       /*!< VADC_G QSR0: REQGT Position             */
#define VADC_G_QSR0_REQGT_Msk                 (0x01UL << VADC_G_QSR0_REQGT_Pos)                       /*!< VADC_G QSR0: REQGT Mask                 */
#define VADC_G_QSR0_EV_Pos                    8                                                       /*!< VADC_G QSR0: EV Position                */
#define VADC_G_QSR0_EV_Msk                    (0x01UL << VADC_G_QSR0_EV_Pos)                          /*!< VADC_G QSR0: EV Mask                    */

/* ---------------------------------  VADC_G_Q0R0  -------------------------------- */
#define VADC_G_Q0R0_REQCHNR_Pos               0                                                       /*!< VADC_G Q0R0: REQCHNR Position           */
#define VADC_G_Q0R0_REQCHNR_Msk               (0x1fUL << VADC_G_Q0R0_REQCHNR_Pos)                     /*!< VADC_G Q0R0: REQCHNR Mask               */
#define VADC_G_Q0R0_RF_Pos                    5                                                       /*!< VADC_G Q0R0: RF Position                */
#define VADC_G_Q0R0_RF_Msk                    (0x01UL << VADC_G_Q0R0_RF_Pos)                          /*!< VADC_G Q0R0: RF Mask                    */
#define VADC_G_Q0R0_ENSI_Pos                  6                                                       /*!< VADC_G Q0R0: ENSI Position              */
#define VADC_G_Q0R0_ENSI_Msk                  (0x01UL << VADC_G_Q0R0_ENSI_Pos)                        /*!< VADC_G Q0R0: ENSI Mask                  */
#define VADC_G_Q0R0_EXTR_Pos                  7                                                       /*!< VADC_G Q0R0: EXTR Position              */
#define VADC_G_Q0R0_EXTR_Msk                  (0x01UL << VADC_G_Q0R0_EXTR_Pos)                        /*!< VADC_G Q0R0: EXTR Mask                  */
#define VADC_G_Q0R0_V_Pos                     8                                                       /*!< VADC_G Q0R0: V Position                 */
#define VADC_G_Q0R0_V_Msk                     (0x01UL << VADC_G_Q0R0_V_Pos)                           /*!< VADC_G Q0R0: V Mask                     */

/* --------------------------------  VADC_G_QINR0  -------------------------------- */
#define VADC_G_QINR0_REQCHNR_Pos              0                                                       /*!< VADC_G QINR0: REQCHNR Position          */
#define VADC_G_QINR0_REQCHNR_Msk              (0x1fUL << VADC_G_QINR0_REQCHNR_Pos)                    /*!< VADC_G QINR0: REQCHNR Mask              */
#define VADC_G_QINR0_RF_Pos                   5                                                       /*!< VADC_G QINR0: RF Position               */
#define VADC_G_QINR0_RF_Msk                   (0x01UL << VADC_G_QINR0_RF_Pos)                         /*!< VADC_G QINR0: RF Mask                   */
#define VADC_G_QINR0_ENSI_Pos                 6                                                       /*!< VADC_G QINR0: ENSI Position             */
#define VADC_G_QINR0_ENSI_Msk                 (0x01UL << VADC_G_QINR0_ENSI_Pos)                       /*!< VADC_G QINR0: ENSI Mask                 */
#define VADC_G_QINR0_EXTR_Pos                 7                                                       /*!< VADC_G QINR0: EXTR Position             */
#define VADC_G_QINR0_EXTR_Msk                 (0x01UL << VADC_G_QINR0_EXTR_Pos)                       /*!< VADC_G QINR0: EXTR Mask                 */

/* --------------------------------  VADC_G_QBUR0  -------------------------------- */
#define VADC_G_QBUR0_REQCHNR_Pos              0                                                       /*!< VADC_G QBUR0: REQCHNR Position          */
#define VADC_G_QBUR0_REQCHNR_Msk              (0x1fUL << VADC_G_QBUR0_REQCHNR_Pos)                    /*!< VADC_G QBUR0: REQCHNR Mask              */
#define VADC_G_QBUR0_RF_Pos                   5                                                       /*!< VADC_G QBUR0: RF Position               */
#define VADC_G_QBUR0_RF_Msk                   (0x01UL << VADC_G_QBUR0_RF_Pos)                         /*!< VADC_G QBUR0: RF Mask                   */
#define VADC_G_QBUR0_ENSI_Pos                 6                                                       /*!< VADC_G QBUR0: ENSI Position             */
#define VADC_G_QBUR0_ENSI_Msk                 (0x01UL << VADC_G_QBUR0_ENSI_Pos)                       /*!< VADC_G QBUR0: ENSI Mask                 */
#define VADC_G_QBUR0_EXTR_Pos                 7                                                       /*!< VADC_G QBUR0: EXTR Position             */
#define VADC_G_QBUR0_EXTR_Msk                 (0x01UL << VADC_G_QBUR0_EXTR_Pos)                       /*!< VADC_G QBUR0: EXTR Mask                 */
#define VADC_G_QBUR0_V_Pos                    8                                                       /*!< VADC_G QBUR0: V Position                */
#define VADC_G_QBUR0_V_Msk                    (0x01UL << VADC_G_QBUR0_V_Pos)                          /*!< VADC_G QBUR0: V Mask                    */

/* --------------------------------  VADC_G_ASCTRL  ------------------------------- */
#define VADC_G_ASCTRL_XTSEL_Pos               8                                                       /*!< VADC_G ASCTRL: XTSEL Position           */
#define VADC_G_ASCTRL_XTSEL_Msk               (0x0fUL << VADC_G_ASCTRL_XTSEL_Pos)                     /*!< VADC_G ASCTRL: XTSEL Mask               */
#define VADC_G_ASCTRL_XTLVL_Pos               12                                                      /*!< VADC_G ASCTRL: XTLVL Position           */
#define VADC_G_ASCTRL_XTLVL_Msk               (0x01UL << VADC_G_ASCTRL_XTLVL_Pos)                     /*!< VADC_G ASCTRL: XTLVL Mask               */
#define VADC_G_ASCTRL_XTMODE_Pos              13                                                      /*!< VADC_G ASCTRL: XTMODE Position          */
#define VADC_G_ASCTRL_XTMODE_Msk              (0x03UL << VADC_G_ASCTRL_XTMODE_Pos)                    /*!< VADC_G ASCTRL: XTMODE Mask              */
#define VADC_G_ASCTRL_XTWC_Pos                15                                                      /*!< VADC_G ASCTRL: XTWC Position            */
#define VADC_G_ASCTRL_XTWC_Msk                (0x01UL << VADC_G_ASCTRL_XTWC_Pos)                      /*!< VADC_G ASCTRL: XTWC Mask                */
#define VADC_G_ASCTRL_GTSEL_Pos               16                                                      /*!< VADC_G ASCTRL: GTSEL Position           */
#define VADC_G_ASCTRL_GTSEL_Msk               (0x0fUL << VADC_G_ASCTRL_GTSEL_Pos)                     /*!< VADC_G ASCTRL: GTSEL Mask               */
#define VADC_G_ASCTRL_GTLVL_Pos               20                                                      /*!< VADC_G ASCTRL: GTLVL Position           */
#define VADC_G_ASCTRL_GTLVL_Msk               (0x01UL << VADC_G_ASCTRL_GTLVL_Pos)                     /*!< VADC_G ASCTRL: GTLVL Mask               */
#define VADC_G_ASCTRL_GTWC_Pos                23                                                      /*!< VADC_G ASCTRL: GTWC Position            */
#define VADC_G_ASCTRL_GTWC_Msk                (0x01UL << VADC_G_ASCTRL_GTWC_Pos)                      /*!< VADC_G ASCTRL: GTWC Mask                */
#define VADC_G_ASCTRL_TMEN_Pos                28                                                      /*!< VADC_G ASCTRL: TMEN Position            */
#define VADC_G_ASCTRL_TMEN_Msk                (0x01UL << VADC_G_ASCTRL_TMEN_Pos)                      /*!< VADC_G ASCTRL: TMEN Mask                */
#define VADC_G_ASCTRL_TMWC_Pos                31                                                      /*!< VADC_G ASCTRL: TMWC Position            */
#define VADC_G_ASCTRL_TMWC_Msk                (0x01UL << VADC_G_ASCTRL_TMWC_Pos)                      /*!< VADC_G ASCTRL: TMWC Mask                */

/* ---------------------------------  VADC_G_ASMR  -------------------------------- */
#define VADC_G_ASMR_ENGT_Pos                  0                                                       /*!< VADC_G ASMR: ENGT Position              */
#define VADC_G_ASMR_ENGT_Msk                  (0x03UL << VADC_G_ASMR_ENGT_Pos)                        /*!< VADC_G ASMR: ENGT Mask                  */
#define VADC_G_ASMR_ENTR_Pos                  2                                                       /*!< VADC_G ASMR: ENTR Position              */
#define VADC_G_ASMR_ENTR_Msk                  (0x01UL << VADC_G_ASMR_ENTR_Pos)                        /*!< VADC_G ASMR: ENTR Mask                  */
#define VADC_G_ASMR_ENSI_Pos                  3                                                       /*!< VADC_G ASMR: ENSI Position              */
#define VADC_G_ASMR_ENSI_Msk                  (0x01UL << VADC_G_ASMR_ENSI_Pos)                        /*!< VADC_G ASMR: ENSI Mask                  */
#define VADC_G_ASMR_SCAN_Pos                  4                                                       /*!< VADC_G ASMR: SCAN Position              */
#define VADC_G_ASMR_SCAN_Msk                  (0x01UL << VADC_G_ASMR_SCAN_Pos)                        /*!< VADC_G ASMR: SCAN Mask                  */
#define VADC_G_ASMR_LDM_Pos                   5                                                       /*!< VADC_G ASMR: LDM Position               */
#define VADC_G_ASMR_LDM_Msk                   (0x01UL << VADC_G_ASMR_LDM_Pos)                         /*!< VADC_G ASMR: LDM Mask                   */
#define VADC_G_ASMR_REQGT_Pos                 7                                                       /*!< VADC_G ASMR: REQGT Position             */
#define VADC_G_ASMR_REQGT_Msk                 (0x01UL << VADC_G_ASMR_REQGT_Pos)                       /*!< VADC_G ASMR: REQGT Mask                 */
#define VADC_G_ASMR_CLRPND_Pos                8                                                       /*!< VADC_G ASMR: CLRPND Position            */
#define VADC_G_ASMR_CLRPND_Msk                (0x01UL << VADC_G_ASMR_CLRPND_Pos)                      /*!< VADC_G ASMR: CLRPND Mask                */
#define VADC_G_ASMR_LDEV_Pos                  9                                                       /*!< VADC_G ASMR: LDEV Position              */
#define VADC_G_ASMR_LDEV_Msk                  (0x01UL << VADC_G_ASMR_LDEV_Pos)                        /*!< VADC_G ASMR: LDEV Mask                  */
#define VADC_G_ASMR_RPTDIS_Pos                16                                                      /*!< VADC_G ASMR: RPTDIS Position            */
#define VADC_G_ASMR_RPTDIS_Msk                (0x01UL << VADC_G_ASMR_RPTDIS_Pos)                      /*!< VADC_G ASMR: RPTDIS Mask                */

/* --------------------------------  VADC_G_ASSEL  -------------------------------- */
#define VADC_G_ASSEL_CHSEL0_Pos               0                                                       /*!< VADC_G ASSEL: CHSEL0 Position           */
#define VADC_G_ASSEL_CHSEL0_Msk               (0x01UL << VADC_G_ASSEL_CHSEL0_Pos)                     /*!< VADC_G ASSEL: CHSEL0 Mask               */
#define VADC_G_ASSEL_CHSEL1_Pos               1                                                       /*!< VADC_G ASSEL: CHSEL1 Position           */
#define VADC_G_ASSEL_CHSEL1_Msk               (0x01UL << VADC_G_ASSEL_CHSEL1_Pos)                     /*!< VADC_G ASSEL: CHSEL1 Mask               */
#define VADC_G_ASSEL_CHSEL2_Pos               2                                                       /*!< VADC_G ASSEL: CHSEL2 Position           */
#define VADC_G_ASSEL_CHSEL2_Msk               (0x01UL << VADC_G_ASSEL_CHSEL2_Pos)                     /*!< VADC_G ASSEL: CHSEL2 Mask               */
#define VADC_G_ASSEL_CHSEL3_Pos               3                                                       /*!< VADC_G ASSEL: CHSEL3 Position           */
#define VADC_G_ASSEL_CHSEL3_Msk               (0x01UL << VADC_G_ASSEL_CHSEL3_Pos)                     /*!< VADC_G ASSEL: CHSEL3 Mask               */
#define VADC_G_ASSEL_CHSEL4_Pos               4                                                       /*!< VADC_G ASSEL: CHSEL4 Position           */
#define VADC_G_ASSEL_CHSEL4_Msk               (0x01UL << VADC_G_ASSEL_CHSEL4_Pos)                     /*!< VADC_G ASSEL: CHSEL4 Mask               */
#define VADC_G_ASSEL_CHSEL5_Pos               5                                                       /*!< VADC_G ASSEL: CHSEL5 Position           */
#define VADC_G_ASSEL_CHSEL5_Msk               (0x01UL << VADC_G_ASSEL_CHSEL5_Pos)                     /*!< VADC_G ASSEL: CHSEL5 Mask               */
#define VADC_G_ASSEL_CHSEL6_Pos               6                                                       /*!< VADC_G ASSEL: CHSEL6 Position           */
#define VADC_G_ASSEL_CHSEL6_Msk               (0x01UL << VADC_G_ASSEL_CHSEL6_Pos)                     /*!< VADC_G ASSEL: CHSEL6 Mask               */
#define VADC_G_ASSEL_CHSEL7_Pos               7                                                       /*!< VADC_G ASSEL: CHSEL7 Position           */
#define VADC_G_ASSEL_CHSEL7_Msk               (0x01UL << VADC_G_ASSEL_CHSEL7_Pos)                     /*!< VADC_G ASSEL: CHSEL7 Mask               */

/* --------------------------------  VADC_G_ASPND  -------------------------------- */
#define VADC_G_ASPND_CHPND0_Pos               0                                                       /*!< VADC_G ASPND: CHPND0 Position           */
#define VADC_G_ASPND_CHPND0_Msk               (0x01UL << VADC_G_ASPND_CHPND0_Pos)                     /*!< VADC_G ASPND: CHPND0 Mask               */
#define VADC_G_ASPND_CHPND1_Pos               1                                                       /*!< VADC_G ASPND: CHPND1 Position           */
#define VADC_G_ASPND_CHPND1_Msk               (0x01UL << VADC_G_ASPND_CHPND1_Pos)                     /*!< VADC_G ASPND: CHPND1 Mask               */
#define VADC_G_ASPND_CHPND2_Pos               2                                                       /*!< VADC_G ASPND: CHPND2 Position           */
#define VADC_G_ASPND_CHPND2_Msk               (0x01UL << VADC_G_ASPND_CHPND2_Pos)                     /*!< VADC_G ASPND: CHPND2 Mask               */
#define VADC_G_ASPND_CHPND3_Pos               3                                                       /*!< VADC_G ASPND: CHPND3 Position           */
#define VADC_G_ASPND_CHPND3_Msk               (0x01UL << VADC_G_ASPND_CHPND3_Pos)                     /*!< VADC_G ASPND: CHPND3 Mask               */
#define VADC_G_ASPND_CHPND4_Pos               4                                                       /*!< VADC_G ASPND: CHPND4 Position           */
#define VADC_G_ASPND_CHPND4_Msk               (0x01UL << VADC_G_ASPND_CHPND4_Pos)                     /*!< VADC_G ASPND: CHPND4 Mask               */
#define VADC_G_ASPND_CHPND5_Pos               5                                                       /*!< VADC_G ASPND: CHPND5 Position           */
#define VADC_G_ASPND_CHPND5_Msk               (0x01UL << VADC_G_ASPND_CHPND5_Pos)                     /*!< VADC_G ASPND: CHPND5 Mask               */
#define VADC_G_ASPND_CHPND6_Pos               6                                                       /*!< VADC_G ASPND: CHPND6 Position           */
#define VADC_G_ASPND_CHPND6_Msk               (0x01UL << VADC_G_ASPND_CHPND6_Pos)                     /*!< VADC_G ASPND: CHPND6 Mask               */
#define VADC_G_ASPND_CHPND7_Pos               7                                                       /*!< VADC_G ASPND: CHPND7 Position           */
#define VADC_G_ASPND_CHPND7_Msk               (0x01UL << VADC_G_ASPND_CHPND7_Pos)                     /*!< VADC_G ASPND: CHPND7 Mask               */

/* --------------------------------  VADC_G_CEFLAG  ------------------------------- */
#define VADC_G_CEFLAG_CEV0_Pos                0                                                       /*!< VADC_G CEFLAG: CEV0 Position            */
#define VADC_G_CEFLAG_CEV0_Msk                (0x01UL << VADC_G_CEFLAG_CEV0_Pos)                      /*!< VADC_G CEFLAG: CEV0 Mask                */
#define VADC_G_CEFLAG_CEV1_Pos                1                                                       /*!< VADC_G CEFLAG: CEV1 Position            */
#define VADC_G_CEFLAG_CEV1_Msk                (0x01UL << VADC_G_CEFLAG_CEV1_Pos)                      /*!< VADC_G CEFLAG: CEV1 Mask                */
#define VADC_G_CEFLAG_CEV2_Pos                2                                                       /*!< VADC_G CEFLAG: CEV2 Position            */
#define VADC_G_CEFLAG_CEV2_Msk                (0x01UL << VADC_G_CEFLAG_CEV2_Pos)                      /*!< VADC_G CEFLAG: CEV2 Mask                */
#define VADC_G_CEFLAG_CEV3_Pos                3                                                       /*!< VADC_G CEFLAG: CEV3 Position            */
#define VADC_G_CEFLAG_CEV3_Msk                (0x01UL << VADC_G_CEFLAG_CEV3_Pos)                      /*!< VADC_G CEFLAG: CEV3 Mask                */
#define VADC_G_CEFLAG_CEV4_Pos                4                                                       /*!< VADC_G CEFLAG: CEV4 Position            */
#define VADC_G_CEFLAG_CEV4_Msk                (0x01UL << VADC_G_CEFLAG_CEV4_Pos)                      /*!< VADC_G CEFLAG: CEV4 Mask                */
#define VADC_G_CEFLAG_CEV5_Pos                5                                                       /*!< VADC_G CEFLAG: CEV5 Position            */
#define VADC_G_CEFLAG_CEV5_Msk                (0x01UL << VADC_G_CEFLAG_CEV5_Pos)                      /*!< VADC_G CEFLAG: CEV5 Mask                */
#define VADC_G_CEFLAG_CEV6_Pos                6                                                       /*!< VADC_G CEFLAG: CEV6 Position            */
#define VADC_G_CEFLAG_CEV6_Msk                (0x01UL << VADC_G_CEFLAG_CEV6_Pos)                      /*!< VADC_G CEFLAG: CEV6 Mask                */
#define VADC_G_CEFLAG_CEV7_Pos                7                                                       /*!< VADC_G CEFLAG: CEV7 Position            */
#define VADC_G_CEFLAG_CEV7_Msk                (0x01UL << VADC_G_CEFLAG_CEV7_Pos)                      /*!< VADC_G CEFLAG: CEV7 Mask                */

/* --------------------------------  VADC_G_REFLAG  ------------------------------- */
#define VADC_G_REFLAG_REV0_Pos                0                                                       /*!< VADC_G REFLAG: REV0 Position            */
#define VADC_G_REFLAG_REV0_Msk                (0x01UL << VADC_G_REFLAG_REV0_Pos)                      /*!< VADC_G REFLAG: REV0 Mask                */
#define VADC_G_REFLAG_REV1_Pos                1                                                       /*!< VADC_G REFLAG: REV1 Position            */
#define VADC_G_REFLAG_REV1_Msk                (0x01UL << VADC_G_REFLAG_REV1_Pos)                      /*!< VADC_G REFLAG: REV1 Mask                */
#define VADC_G_REFLAG_REV2_Pos                2                                                       /*!< VADC_G REFLAG: REV2 Position            */
#define VADC_G_REFLAG_REV2_Msk                (0x01UL << VADC_G_REFLAG_REV2_Pos)                      /*!< VADC_G REFLAG: REV2 Mask                */
#define VADC_G_REFLAG_REV3_Pos                3                                                       /*!< VADC_G REFLAG: REV3 Position            */
#define VADC_G_REFLAG_REV3_Msk                (0x01UL << VADC_G_REFLAG_REV3_Pos)                      /*!< VADC_G REFLAG: REV3 Mask                */
#define VADC_G_REFLAG_REV4_Pos                4                                                       /*!< VADC_G REFLAG: REV4 Position            */
#define VADC_G_REFLAG_REV4_Msk                (0x01UL << VADC_G_REFLAG_REV4_Pos)                      /*!< VADC_G REFLAG: REV4 Mask                */
#define VADC_G_REFLAG_REV5_Pos                5                                                       /*!< VADC_G REFLAG: REV5 Position            */
#define VADC_G_REFLAG_REV5_Msk                (0x01UL << VADC_G_REFLAG_REV5_Pos)                      /*!< VADC_G REFLAG: REV5 Mask                */
#define VADC_G_REFLAG_REV6_Pos                6                                                       /*!< VADC_G REFLAG: REV6 Position            */
#define VADC_G_REFLAG_REV6_Msk                (0x01UL << VADC_G_REFLAG_REV6_Pos)                      /*!< VADC_G REFLAG: REV6 Mask                */
#define VADC_G_REFLAG_REV7_Pos                7                                                       /*!< VADC_G REFLAG: REV7 Position            */
#define VADC_G_REFLAG_REV7_Msk                (0x01UL << VADC_G_REFLAG_REV7_Pos)                      /*!< VADC_G REFLAG: REV7 Mask                */
#define VADC_G_REFLAG_REV8_Pos                8                                                       /*!< VADC_G REFLAG: REV8 Position            */
#define VADC_G_REFLAG_REV8_Msk                (0x01UL << VADC_G_REFLAG_REV8_Pos)                      /*!< VADC_G REFLAG: REV8 Mask                */
#define VADC_G_REFLAG_REV9_Pos                9                                                       /*!< VADC_G REFLAG: REV9 Position            */
#define VADC_G_REFLAG_REV9_Msk                (0x01UL << VADC_G_REFLAG_REV9_Pos)                      /*!< VADC_G REFLAG: REV9 Mask                */
#define VADC_G_REFLAG_REV10_Pos               10                                                      /*!< VADC_G REFLAG: REV10 Position           */
#define VADC_G_REFLAG_REV10_Msk               (0x01UL << VADC_G_REFLAG_REV10_Pos)                     /*!< VADC_G REFLAG: REV10 Mask               */
#define VADC_G_REFLAG_REV11_Pos               11                                                      /*!< VADC_G REFLAG: REV11 Position           */
#define VADC_G_REFLAG_REV11_Msk               (0x01UL << VADC_G_REFLAG_REV11_Pos)                     /*!< VADC_G REFLAG: REV11 Mask               */
#define VADC_G_REFLAG_REV12_Pos               12                                                      /*!< VADC_G REFLAG: REV12 Position           */
#define VADC_G_REFLAG_REV12_Msk               (0x01UL << VADC_G_REFLAG_REV12_Pos)                     /*!< VADC_G REFLAG: REV12 Mask               */
#define VADC_G_REFLAG_REV13_Pos               13                                                      /*!< VADC_G REFLAG: REV13 Position           */
#define VADC_G_REFLAG_REV13_Msk               (0x01UL << VADC_G_REFLAG_REV13_Pos)                     /*!< VADC_G REFLAG: REV13 Mask               */
#define VADC_G_REFLAG_REV14_Pos               14                                                      /*!< VADC_G REFLAG: REV14 Position           */
#define VADC_G_REFLAG_REV14_Msk               (0x01UL << VADC_G_REFLAG_REV14_Pos)                     /*!< VADC_G REFLAG: REV14 Mask               */
#define VADC_G_REFLAG_REV15_Pos               15                                                      /*!< VADC_G REFLAG: REV15 Position           */
#define VADC_G_REFLAG_REV15_Msk               (0x01UL << VADC_G_REFLAG_REV15_Pos)                     /*!< VADC_G REFLAG: REV15 Mask               */

/* --------------------------------  VADC_G_SEFLAG  ------------------------------- */
#define VADC_G_SEFLAG_SEV0_Pos                0                                                       /*!< VADC_G SEFLAG: SEV0 Position            */
#define VADC_G_SEFLAG_SEV0_Msk                (0x01UL << VADC_G_SEFLAG_SEV0_Pos)                      /*!< VADC_G SEFLAG: SEV0 Mask                */
#define VADC_G_SEFLAG_SEV1_Pos                1                                                       /*!< VADC_G SEFLAG: SEV1 Position            */
#define VADC_G_SEFLAG_SEV1_Msk                (0x01UL << VADC_G_SEFLAG_SEV1_Pos)                      /*!< VADC_G SEFLAG: SEV1 Mask                */

/* --------------------------------  VADC_G_CEFCLR  ------------------------------- */
#define VADC_G_CEFCLR_CEV0_Pos                0                                                       /*!< VADC_G CEFCLR: CEV0 Position            */
#define VADC_G_CEFCLR_CEV0_Msk                (0x01UL << VADC_G_CEFCLR_CEV0_Pos)                      /*!< VADC_G CEFCLR: CEV0 Mask                */
#define VADC_G_CEFCLR_CEV1_Pos                1                                                       /*!< VADC_G CEFCLR: CEV1 Position            */
#define VADC_G_CEFCLR_CEV1_Msk                (0x01UL << VADC_G_CEFCLR_CEV1_Pos)                      /*!< VADC_G CEFCLR: CEV1 Mask                */
#define VADC_G_CEFCLR_CEV2_Pos                2                                                       /*!< VADC_G CEFCLR: CEV2 Position            */
#define VADC_G_CEFCLR_CEV2_Msk                (0x01UL << VADC_G_CEFCLR_CEV2_Pos)                      /*!< VADC_G CEFCLR: CEV2 Mask                */
#define VADC_G_CEFCLR_CEV3_Pos                3                                                       /*!< VADC_G CEFCLR: CEV3 Position            */
#define VADC_G_CEFCLR_CEV3_Msk                (0x01UL << VADC_G_CEFCLR_CEV3_Pos)                      /*!< VADC_G CEFCLR: CEV3 Mask                */
#define VADC_G_CEFCLR_CEV4_Pos                4                                                       /*!< VADC_G CEFCLR: CEV4 Position            */
#define VADC_G_CEFCLR_CEV4_Msk                (0x01UL << VADC_G_CEFCLR_CEV4_Pos)                      /*!< VADC_G CEFCLR: CEV4 Mask                */
#define VADC_G_CEFCLR_CEV5_Pos                5                                                       /*!< VADC_G CEFCLR: CEV5 Position            */
#define VADC_G_CEFCLR_CEV5_Msk                (0x01UL << VADC_G_CEFCLR_CEV5_Pos)                      /*!< VADC_G CEFCLR: CEV5 Mask                */
#define VADC_G_CEFCLR_CEV6_Pos                6                                                       /*!< VADC_G CEFCLR: CEV6 Position            */
#define VADC_G_CEFCLR_CEV6_Msk                (0x01UL << VADC_G_CEFCLR_CEV6_Pos)                      /*!< VADC_G CEFCLR: CEV6 Mask                */
#define VADC_G_CEFCLR_CEV7_Pos                7                                                       /*!< VADC_G CEFCLR: CEV7 Position            */
#define VADC_G_CEFCLR_CEV7_Msk                (0x01UL << VADC_G_CEFCLR_CEV7_Pos)                      /*!< VADC_G CEFCLR: CEV7 Mask                */

/* --------------------------------  VADC_G_REFCLR  ------------------------------- */
#define VADC_G_REFCLR_REV0_Pos                0                                                       /*!< VADC_G REFCLR: REV0 Position            */
#define VADC_G_REFCLR_REV0_Msk                (0x01UL << VADC_G_REFCLR_REV0_Pos)                      /*!< VADC_G REFCLR: REV0 Mask                */
#define VADC_G_REFCLR_REV1_Pos                1                                                       /*!< VADC_G REFCLR: REV1 Position            */
#define VADC_G_REFCLR_REV1_Msk                (0x01UL << VADC_G_REFCLR_REV1_Pos)                      /*!< VADC_G REFCLR: REV1 Mask                */
#define VADC_G_REFCLR_REV2_Pos                2                                                       /*!< VADC_G REFCLR: REV2 Position            */
#define VADC_G_REFCLR_REV2_Msk                (0x01UL << VADC_G_REFCLR_REV2_Pos)                      /*!< VADC_G REFCLR: REV2 Mask                */
#define VADC_G_REFCLR_REV3_Pos                3                                                       /*!< VADC_G REFCLR: REV3 Position            */
#define VADC_G_REFCLR_REV3_Msk                (0x01UL << VADC_G_REFCLR_REV3_Pos)                      /*!< VADC_G REFCLR: REV3 Mask                */
#define VADC_G_REFCLR_REV4_Pos                4                                                       /*!< VADC_G REFCLR: REV4 Position            */
#define VADC_G_REFCLR_REV4_Msk                (0x01UL << VADC_G_REFCLR_REV4_Pos)                      /*!< VADC_G REFCLR: REV4 Mask                */
#define VADC_G_REFCLR_REV5_Pos                5                                                       /*!< VADC_G REFCLR: REV5 Position            */
#define VADC_G_REFCLR_REV5_Msk                (0x01UL << VADC_G_REFCLR_REV5_Pos)                      /*!< VADC_G REFCLR: REV5 Mask                */
#define VADC_G_REFCLR_REV6_Pos                6                                                       /*!< VADC_G REFCLR: REV6 Position            */
#define VADC_G_REFCLR_REV6_Msk                (0x01UL << VADC_G_REFCLR_REV6_Pos)                      /*!< VADC_G REFCLR: REV6 Mask                */
#define VADC_G_REFCLR_REV7_Pos                7                                                       /*!< VADC_G REFCLR: REV7 Position            */
#define VADC_G_REFCLR_REV7_Msk                (0x01UL << VADC_G_REFCLR_REV7_Pos)                      /*!< VADC_G REFCLR: REV7 Mask                */
#define VADC_G_REFCLR_REV8_Pos                8                                                       /*!< VADC_G REFCLR: REV8 Position            */
#define VADC_G_REFCLR_REV8_Msk                (0x01UL << VADC_G_REFCLR_REV8_Pos)                      /*!< VADC_G REFCLR: REV8 Mask                */
#define VADC_G_REFCLR_REV9_Pos                9                                                       /*!< VADC_G REFCLR: REV9 Position            */
#define VADC_G_REFCLR_REV9_Msk                (0x01UL << VADC_G_REFCLR_REV9_Pos)                      /*!< VADC_G REFCLR: REV9 Mask                */
#define VADC_G_REFCLR_REV10_Pos               10                                                      /*!< VADC_G REFCLR: REV10 Position           */
#define VADC_G_REFCLR_REV10_Msk               (0x01UL << VADC_G_REFCLR_REV10_Pos)                     /*!< VADC_G REFCLR: REV10 Mask               */
#define VADC_G_REFCLR_REV11_Pos               11                                                      /*!< VADC_G REFCLR: REV11 Position           */
#define VADC_G_REFCLR_REV11_Msk               (0x01UL << VADC_G_REFCLR_REV11_Pos)                     /*!< VADC_G REFCLR: REV11 Mask               */
#define VADC_G_REFCLR_REV12_Pos               12                                                      /*!< VADC_G REFCLR: REV12 Position           */
#define VADC_G_REFCLR_REV12_Msk               (0x01UL << VADC_G_REFCLR_REV12_Pos)                     /*!< VADC_G REFCLR: REV12 Mask               */
#define VADC_G_REFCLR_REV13_Pos               13                                                      /*!< VADC_G REFCLR: REV13 Position           */
#define VADC_G_REFCLR_REV13_Msk               (0x01UL << VADC_G_REFCLR_REV13_Pos)                     /*!< VADC_G REFCLR: REV13 Mask               */
#define VADC_G_REFCLR_REV14_Pos               14                                                      /*!< VADC_G REFCLR: REV14 Position           */
#define VADC_G_REFCLR_REV14_Msk               (0x01UL << VADC_G_REFCLR_REV14_Pos)                     /*!< VADC_G REFCLR: REV14 Mask               */
#define VADC_G_REFCLR_REV15_Pos               15                                                      /*!< VADC_G REFCLR: REV15 Position           */
#define VADC_G_REFCLR_REV15_Msk               (0x01UL << VADC_G_REFCLR_REV15_Pos)                     /*!< VADC_G REFCLR: REV15 Mask               */

/* --------------------------------  VADC_G_SEFCLR  ------------------------------- */
#define VADC_G_SEFCLR_SEV0_Pos                0                                                       /*!< VADC_G SEFCLR: SEV0 Position            */
#define VADC_G_SEFCLR_SEV0_Msk                (0x01UL << VADC_G_SEFCLR_SEV0_Pos)                      /*!< VADC_G SEFCLR: SEV0 Mask                */
#define VADC_G_SEFCLR_SEV1_Pos                1                                                       /*!< VADC_G SEFCLR: SEV1 Position            */
#define VADC_G_SEFCLR_SEV1_Msk                (0x01UL << VADC_G_SEFCLR_SEV1_Pos)                      /*!< VADC_G SEFCLR: SEV1 Mask                */

/* --------------------------------  VADC_G_CEVNP0  ------------------------------- */
#define VADC_G_CEVNP0_CEV0NP_Pos              0                                                       /*!< VADC_G CEVNP0: CEV0NP Position          */
#define VADC_G_CEVNP0_CEV0NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV0NP_Pos)                    /*!< VADC_G CEVNP0: CEV0NP Mask              */
#define VADC_G_CEVNP0_CEV1NP_Pos              4                                                       /*!< VADC_G CEVNP0: CEV1NP Position          */
#define VADC_G_CEVNP0_CEV1NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV1NP_Pos)                    /*!< VADC_G CEVNP0: CEV1NP Mask              */
#define VADC_G_CEVNP0_CEV2NP_Pos              8                                                       /*!< VADC_G CEVNP0: CEV2NP Position          */
#define VADC_G_CEVNP0_CEV2NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV2NP_Pos)                    /*!< VADC_G CEVNP0: CEV2NP Mask              */
#define VADC_G_CEVNP0_CEV3NP_Pos              12                                                      /*!< VADC_G CEVNP0: CEV3NP Position          */
#define VADC_G_CEVNP0_CEV3NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV3NP_Pos)                    /*!< VADC_G CEVNP0: CEV3NP Mask              */
#define VADC_G_CEVNP0_CEV4NP_Pos              16                                                      /*!< VADC_G CEVNP0: CEV4NP Position          */
#define VADC_G_CEVNP0_CEV4NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV4NP_Pos)                    /*!< VADC_G CEVNP0: CEV4NP Mask              */
#define VADC_G_CEVNP0_CEV5NP_Pos              20                                                      /*!< VADC_G CEVNP0: CEV5NP Position          */
#define VADC_G_CEVNP0_CEV5NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV5NP_Pos)                    /*!< VADC_G CEVNP0: CEV5NP Mask              */
#define VADC_G_CEVNP0_CEV6NP_Pos              24                                                      /*!< VADC_G CEVNP0: CEV6NP Position          */
#define VADC_G_CEVNP0_CEV6NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV6NP_Pos)                    /*!< VADC_G CEVNP0: CEV6NP Mask              */
#define VADC_G_CEVNP0_CEV7NP_Pos              28                                                      /*!< VADC_G CEVNP0: CEV7NP Position          */
#define VADC_G_CEVNP0_CEV7NP_Msk              (0x0fUL << VADC_G_CEVNP0_CEV7NP_Pos)                    /*!< VADC_G CEVNP0: CEV7NP Mask              */

/* --------------------------------  VADC_G_REVNP0  ------------------------------- */
#define VADC_G_REVNP0_REV0NP_Pos              0                                                       /*!< VADC_G REVNP0: REV0NP Position          */
#define VADC_G_REVNP0_REV0NP_Msk              (0x0fUL << VADC_G_REVNP0_REV0NP_Pos)                    /*!< VADC_G REVNP0: REV0NP Mask              */
#define VADC_G_REVNP0_REV1NP_Pos              4                                                       /*!< VADC_G REVNP0: REV1NP Position          */
#define VADC_G_REVNP0_REV1NP_Msk              (0x0fUL << VADC_G_REVNP0_REV1NP_Pos)                    /*!< VADC_G REVNP0: REV1NP Mask              */
#define VADC_G_REVNP0_REV2NP_Pos              8                                                       /*!< VADC_G REVNP0: REV2NP Position          */
#define VADC_G_REVNP0_REV2NP_Msk              (0x0fUL << VADC_G_REVNP0_REV2NP_Pos)                    /*!< VADC_G REVNP0: REV2NP Mask              */
#define VADC_G_REVNP0_REV3NP_Pos              12                                                      /*!< VADC_G REVNP0: REV3NP Position          */
#define VADC_G_REVNP0_REV3NP_Msk              (0x0fUL << VADC_G_REVNP0_REV3NP_Pos)                    /*!< VADC_G REVNP0: REV3NP Mask              */
#define VADC_G_REVNP0_REV4NP_Pos              16                                                      /*!< VADC_G REVNP0: REV4NP Position          */
#define VADC_G_REVNP0_REV4NP_Msk              (0x0fUL << VADC_G_REVNP0_REV4NP_Pos)                    /*!< VADC_G REVNP0: REV4NP Mask              */
#define VADC_G_REVNP0_REV5NP_Pos              20                                                      /*!< VADC_G REVNP0: REV5NP Position          */
#define VADC_G_REVNP0_REV5NP_Msk              (0x0fUL << VADC_G_REVNP0_REV5NP_Pos)                    /*!< VADC_G REVNP0: REV5NP Mask              */
#define VADC_G_REVNP0_REV6NP_Pos              24                                                      /*!< VADC_G REVNP0: REV6NP Position          */
#define VADC_G_REVNP0_REV6NP_Msk              (0x0fUL << VADC_G_REVNP0_REV6NP_Pos)                    /*!< VADC_G REVNP0: REV6NP Mask              */
#define VADC_G_REVNP0_REV7NP_Pos              28                                                      /*!< VADC_G REVNP0: REV7NP Position          */
#define VADC_G_REVNP0_REV7NP_Msk              (0x0fUL << VADC_G_REVNP0_REV7NP_Pos)                    /*!< VADC_G REVNP0: REV7NP Mask              */

/* --------------------------------  VADC_G_REVNP1  ------------------------------- */
#define VADC_G_REVNP1_REV8NP_Pos              0                                                       /*!< VADC_G REVNP1: REV8NP Position          */
#define VADC_G_REVNP1_REV8NP_Msk              (0x0fUL << VADC_G_REVNP1_REV8NP_Pos)                    /*!< VADC_G REVNP1: REV8NP Mask              */
#define VADC_G_REVNP1_REV9NP_Pos              4                                                       /*!< VADC_G REVNP1: REV9NP Position          */
#define VADC_G_REVNP1_REV9NP_Msk              (0x0fUL << VADC_G_REVNP1_REV9NP_Pos)                    /*!< VADC_G REVNP1: REV9NP Mask              */
#define VADC_G_REVNP1_REV10NP_Pos             8                                                       /*!< VADC_G REVNP1: REV10NP Position         */
#define VADC_G_REVNP1_REV10NP_Msk             (0x0fUL << VADC_G_REVNP1_REV10NP_Pos)                   /*!< VADC_G REVNP1: REV10NP Mask             */
#define VADC_G_REVNP1_REV11NP_Pos             12                                                      /*!< VADC_G REVNP1: REV11NP Position         */
#define VADC_G_REVNP1_REV11NP_Msk             (0x0fUL << VADC_G_REVNP1_REV11NP_Pos)                   /*!< VADC_G REVNP1: REV11NP Mask             */
#define VADC_G_REVNP1_REV12NP_Pos             16                                                      /*!< VADC_G REVNP1: REV12NP Position         */
#define VADC_G_REVNP1_REV12NP_Msk             (0x0fUL << VADC_G_REVNP1_REV12NP_Pos)                   /*!< VADC_G REVNP1: REV12NP Mask             */
#define VADC_G_REVNP1_REV13NP_Pos             20                                                      /*!< VADC_G REVNP1: REV13NP Position         */
#define VADC_G_REVNP1_REV13NP_Msk             (0x0fUL << VADC_G_REVNP1_REV13NP_Pos)                   /*!< VADC_G REVNP1: REV13NP Mask             */
#define VADC_G_REVNP1_REV14NP_Pos             24                                                      /*!< VADC_G REVNP1: REV14NP Position         */
#define VADC_G_REVNP1_REV14NP_Msk             (0x0fUL << VADC_G_REVNP1_REV14NP_Pos)                   /*!< VADC_G REVNP1: REV14NP Mask             */
#define VADC_G_REVNP1_REV15NP_Pos             28                                                      /*!< VADC_G REVNP1: REV15NP Position         */
#define VADC_G_REVNP1_REV15NP_Msk             (0x0fUL << VADC_G_REVNP1_REV15NP_Pos)                   /*!< VADC_G REVNP1: REV15NP Mask             */

/* --------------------------------  VADC_G_SEVNP  -------------------------------- */
#define VADC_G_SEVNP_SEV0NP_Pos               0                                                       /*!< VADC_G SEVNP: SEV0NP Position           */
#define VADC_G_SEVNP_SEV0NP_Msk               (0x0fUL << VADC_G_SEVNP_SEV0NP_Pos)                     /*!< VADC_G SEVNP: SEV0NP Mask               */
#define VADC_G_SEVNP_SEV1NP_Pos               4                                                       /*!< VADC_G SEVNP: SEV1NP Position           */
#define VADC_G_SEVNP_SEV1NP_Msk               (0x0fUL << VADC_G_SEVNP_SEV1NP_Pos)                     /*!< VADC_G SEVNP: SEV1NP Mask               */

/* --------------------------------  VADC_G_SRACT  -------------------------------- */
#define VADC_G_SRACT_AGSR0_Pos                0                                                       /*!< VADC_G SRACT: AGSR0 Position            */
#define VADC_G_SRACT_AGSR0_Msk                (0x01UL << VADC_G_SRACT_AGSR0_Pos)                      /*!< VADC_G SRACT: AGSR0 Mask                */
#define VADC_G_SRACT_AGSR1_Pos                1                                                       /*!< VADC_G SRACT: AGSR1 Position            */
#define VADC_G_SRACT_AGSR1_Msk                (0x01UL << VADC_G_SRACT_AGSR1_Pos)                      /*!< VADC_G SRACT: AGSR1 Mask                */
#define VADC_G_SRACT_AGSR2_Pos                2                                                       /*!< VADC_G SRACT: AGSR2 Position            */
#define VADC_G_SRACT_AGSR2_Msk                (0x01UL << VADC_G_SRACT_AGSR2_Pos)                      /*!< VADC_G SRACT: AGSR2 Mask                */
#define VADC_G_SRACT_AGSR3_Pos                3                                                       /*!< VADC_G SRACT: AGSR3 Position            */
#define VADC_G_SRACT_AGSR3_Msk                (0x01UL << VADC_G_SRACT_AGSR3_Pos)                      /*!< VADC_G SRACT: AGSR3 Mask                */
#define VADC_G_SRACT_ASSR0_Pos                8                                                       /*!< VADC_G SRACT: ASSR0 Position            */
#define VADC_G_SRACT_ASSR0_Msk                (0x01UL << VADC_G_SRACT_ASSR0_Pos)                      /*!< VADC_G SRACT: ASSR0 Mask                */
#define VADC_G_SRACT_ASSR1_Pos                9                                                       /*!< VADC_G SRACT: ASSR1 Position            */
#define VADC_G_SRACT_ASSR1_Msk                (0x01UL << VADC_G_SRACT_ASSR1_Pos)                      /*!< VADC_G SRACT: ASSR1 Mask                */
#define VADC_G_SRACT_ASSR2_Pos                10                                                      /*!< VADC_G SRACT: ASSR2 Position            */
#define VADC_G_SRACT_ASSR2_Msk                (0x01UL << VADC_G_SRACT_ASSR2_Pos)                      /*!< VADC_G SRACT: ASSR2 Mask                */
#define VADC_G_SRACT_ASSR3_Pos                11                                                      /*!< VADC_G SRACT: ASSR3 Position            */
#define VADC_G_SRACT_ASSR3_Msk                (0x01UL << VADC_G_SRACT_ASSR3_Pos)                      /*!< VADC_G SRACT: ASSR3 Mask                */

/* -------------------------------  VADC_G_EMUXCTR  ------------------------------- */
#define VADC_G_EMUXCTR_EMUXSET_Pos            0                                                       /*!< VADC_G EMUXCTR: EMUXSET Position        */
#define VADC_G_EMUXCTR_EMUXSET_Msk            (0x07UL << VADC_G_EMUXCTR_EMUXSET_Pos)                  /*!< VADC_G EMUXCTR: EMUXSET Mask            */
#define VADC_G_EMUXCTR_EMUXACT_Pos            8                                                       /*!< VADC_G EMUXCTR: EMUXACT Position        */
#define VADC_G_EMUXCTR_EMUXACT_Msk            (0x07UL << VADC_G_EMUXCTR_EMUXACT_Pos)                  /*!< VADC_G EMUXCTR: EMUXACT Mask            */
#define VADC_G_EMUXCTR_EMUXCH_Pos             16                                                      /*!< VADC_G EMUXCTR: EMUXCH Position         */
#define VADC_G_EMUXCTR_EMUXCH_Msk             (0x000003ffUL << VADC_G_EMUXCTR_EMUXCH_Pos)             /*!< VADC_G EMUXCTR: EMUXCH Mask             */
#define VADC_G_EMUXCTR_EMUXMODE_Pos           26                                                      /*!< VADC_G EMUXCTR: EMUXMODE Position       */
#define VADC_G_EMUXCTR_EMUXMODE_Msk           (0x03UL << VADC_G_EMUXCTR_EMUXMODE_Pos)                 /*!< VADC_G EMUXCTR: EMUXMODE Mask           */
#define VADC_G_EMUXCTR_EMXCOD_Pos             28                                                      /*!< VADC_G EMUXCTR: EMXCOD Position         */
#define VADC_G_EMUXCTR_EMXCOD_Msk             (0x01UL << VADC_G_EMUXCTR_EMXCOD_Pos)                   /*!< VADC_G EMUXCTR: EMXCOD Mask             */
#define VADC_G_EMUXCTR_EMXST_Pos              29                                                      /*!< VADC_G EMUXCTR: EMXST Position          */
#define VADC_G_EMUXCTR_EMXST_Msk              (0x01UL << VADC_G_EMUXCTR_EMXST_Pos)                    /*!< VADC_G EMUXCTR: EMXST Mask              */
#define VADC_G_EMUXCTR_EMXCSS_Pos             30                                                      /*!< VADC_G EMUXCTR: EMXCSS Position         */
#define VADC_G_EMUXCTR_EMXCSS_Msk             (0x01UL << VADC_G_EMUXCTR_EMXCSS_Pos)                   /*!< VADC_G EMUXCTR: EMXCSS Mask             */
#define VADC_G_EMUXCTR_EMXWC_Pos              31                                                      /*!< VADC_G EMUXCTR: EMXWC Position          */
#define VADC_G_EMUXCTR_EMXWC_Msk              (0x01UL << VADC_G_EMUXCTR_EMXWC_Pos)                    /*!< VADC_G EMUXCTR: EMXWC Mask              */

/* ---------------------------------  VADC_G_VFR  --------------------------------- */
#define VADC_G_VFR_VF0_Pos                    0                                                       /*!< VADC_G VFR: VF0 Position                */
#define VADC_G_VFR_VF0_Msk                    (0x01UL << VADC_G_VFR_VF0_Pos)                          /*!< VADC_G VFR: VF0 Mask                    */
#define VADC_G_VFR_VF1_Pos                    1                                                       /*!< VADC_G VFR: VF1 Position                */
#define VADC_G_VFR_VF1_Msk                    (0x01UL << VADC_G_VFR_VF1_Pos)                          /*!< VADC_G VFR: VF1 Mask                    */
#define VADC_G_VFR_VF2_Pos                    2                                                       /*!< VADC_G VFR: VF2 Position                */
#define VADC_G_VFR_VF2_Msk                    (0x01UL << VADC_G_VFR_VF2_Pos)                          /*!< VADC_G VFR: VF2 Mask                    */
#define VADC_G_VFR_VF3_Pos                    3                                                       /*!< VADC_G VFR: VF3 Position                */
#define VADC_G_VFR_VF3_Msk                    (0x01UL << VADC_G_VFR_VF3_Pos)                          /*!< VADC_G VFR: VF3 Mask                    */
#define VADC_G_VFR_VF4_Pos                    4                                                       /*!< VADC_G VFR: VF4 Position                */
#define VADC_G_VFR_VF4_Msk                    (0x01UL << VADC_G_VFR_VF4_Pos)                          /*!< VADC_G VFR: VF4 Mask                    */
#define VADC_G_VFR_VF5_Pos                    5                                                       /*!< VADC_G VFR: VF5 Position                */
#define VADC_G_VFR_VF5_Msk                    (0x01UL << VADC_G_VFR_VF5_Pos)                          /*!< VADC_G VFR: VF5 Mask                    */
#define VADC_G_VFR_VF6_Pos                    6                                                       /*!< VADC_G VFR: VF6 Position                */
#define VADC_G_VFR_VF6_Msk                    (0x01UL << VADC_G_VFR_VF6_Pos)                          /*!< VADC_G VFR: VF6 Mask                    */
#define VADC_G_VFR_VF7_Pos                    7                                                       /*!< VADC_G VFR: VF7 Position                */
#define VADC_G_VFR_VF7_Msk                    (0x01UL << VADC_G_VFR_VF7_Pos)                          /*!< VADC_G VFR: VF7 Mask                    */
#define VADC_G_VFR_VF8_Pos                    8                                                       /*!< VADC_G VFR: VF8 Position                */
#define VADC_G_VFR_VF8_Msk                    (0x01UL << VADC_G_VFR_VF8_Pos)                          /*!< VADC_G VFR: VF8 Mask                    */
#define VADC_G_VFR_VF9_Pos                    9                                                       /*!< VADC_G VFR: VF9 Position                */
#define VADC_G_VFR_VF9_Msk                    (0x01UL << VADC_G_VFR_VF9_Pos)                          /*!< VADC_G VFR: VF9 Mask                    */
#define VADC_G_VFR_VF10_Pos                   10                                                      /*!< VADC_G VFR: VF10 Position               */
#define VADC_G_VFR_VF10_Msk                   (0x01UL << VADC_G_VFR_VF10_Pos)                         /*!< VADC_G VFR: VF10 Mask                   */
#define VADC_G_VFR_VF11_Pos                   11                                                      /*!< VADC_G VFR: VF11 Position               */
#define VADC_G_VFR_VF11_Msk                   (0x01UL << VADC_G_VFR_VF11_Pos)                         /*!< VADC_G VFR: VF11 Mask                   */
#define VADC_G_VFR_VF12_Pos                   12                                                      /*!< VADC_G VFR: VF12 Position               */
#define VADC_G_VFR_VF12_Msk                   (0x01UL << VADC_G_VFR_VF12_Pos)                         /*!< VADC_G VFR: VF12 Mask                   */
#define VADC_G_VFR_VF13_Pos                   13                                                      /*!< VADC_G VFR: VF13 Position               */
#define VADC_G_VFR_VF13_Msk                   (0x01UL << VADC_G_VFR_VF13_Pos)                         /*!< VADC_G VFR: VF13 Mask                   */
#define VADC_G_VFR_VF14_Pos                   14                                                      /*!< VADC_G VFR: VF14 Position               */
#define VADC_G_VFR_VF14_Msk                   (0x01UL << VADC_G_VFR_VF14_Pos)                         /*!< VADC_G VFR: VF14 Mask                   */
#define VADC_G_VFR_VF15_Pos                   15                                                      /*!< VADC_G VFR: VF15 Position               */
#define VADC_G_VFR_VF15_Msk                   (0x01UL << VADC_G_VFR_VF15_Pos)                         /*!< VADC_G VFR: VF15 Mask                   */

/* --------------------------------  VADC_G_CHCTR  -------------------------------- */
#define VADC_G_CHCTR_ICLSEL_Pos               0                                                       /*!< VADC_G CHCTR: ICLSEL Position           */
#define VADC_G_CHCTR_ICLSEL_Msk               (0x03UL << VADC_G_CHCTR_ICLSEL_Pos)                     /*!< VADC_G CHCTR: ICLSEL Mask               */
#define VADC_G_CHCTR_BNDSELL_Pos              4                                                       /*!< VADC_G CHCTR: BNDSELL Position          */
#define VADC_G_CHCTR_BNDSELL_Msk              (0x03UL << VADC_G_CHCTR_BNDSELL_Pos)                    /*!< VADC_G CHCTR: BNDSELL Mask              */
#define VADC_G_CHCTR_BNDSELU_Pos              6                                                       /*!< VADC_G CHCTR: BNDSELU Position          */
#define VADC_G_CHCTR_BNDSELU_Msk              (0x03UL << VADC_G_CHCTR_BNDSELU_Pos)                    /*!< VADC_G CHCTR: BNDSELU Mask              */
#define VADC_G_CHCTR_CHEVMODE_Pos             8                                                       /*!< VADC_G CHCTR: CHEVMODE Position         */
#define VADC_G_CHCTR_CHEVMODE_Msk             (0x03UL << VADC_G_CHCTR_CHEVMODE_Pos)                   /*!< VADC_G CHCTR: CHEVMODE Mask             */
#define VADC_G_CHCTR_SYNC_Pos                 10                                                      /*!< VADC_G CHCTR: SYNC Position             */
#define VADC_G_CHCTR_SYNC_Msk                 (0x01UL << VADC_G_CHCTR_SYNC_Pos)                       /*!< VADC_G CHCTR: SYNC Mask                 */
#define VADC_G_CHCTR_REFSEL_Pos               11                                                      /*!< VADC_G CHCTR: REFSEL Position           */
#define VADC_G_CHCTR_REFSEL_Msk               (0x01UL << VADC_G_CHCTR_REFSEL_Pos)                     /*!< VADC_G CHCTR: REFSEL Mask               */
#define VADC_G_CHCTR_RESREG_Pos               16                                                      /*!< VADC_G CHCTR: RESREG Position           */
#define VADC_G_CHCTR_RESREG_Msk               (0x0fUL << VADC_G_CHCTR_RESREG_Pos)                     /*!< VADC_G CHCTR: RESREG Mask               */
#define VADC_G_CHCTR_RESTBS_Pos               20                                                      /*!< VADC_G CHCTR: RESTBS Position           */
#define VADC_G_CHCTR_RESTBS_Msk               (0x01UL << VADC_G_CHCTR_RESTBS_Pos)                     /*!< VADC_G CHCTR: RESTBS Mask               */
#define VADC_G_CHCTR_RESPOS_Pos               21                                                      /*!< VADC_G CHCTR: RESPOS Position           */
#define VADC_G_CHCTR_RESPOS_Msk               (0x01UL << VADC_G_CHCTR_RESPOS_Pos)                     /*!< VADC_G CHCTR: RESPOS Mask               */
#define VADC_G_CHCTR_BWDCH_Pos                28                                                      /*!< VADC_G CHCTR: BWDCH Position            */
#define VADC_G_CHCTR_BWDCH_Msk                (0x03UL << VADC_G_CHCTR_BWDCH_Pos)                      /*!< VADC_G CHCTR: BWDCH Mask                */
#define VADC_G_CHCTR_BWDEN_Pos                30                                                      /*!< VADC_G CHCTR: BWDEN Position            */
#define VADC_G_CHCTR_BWDEN_Msk                (0x01UL << VADC_G_CHCTR_BWDEN_Pos)                      /*!< VADC_G CHCTR: BWDEN Mask                */

/* ---------------------------------  VADC_G_RCR  --------------------------------- */
#define VADC_G_RCR_DRCTR_Pos                  16                                                      /*!< VADC_G RCR: DRCTR Position              */
#define VADC_G_RCR_DRCTR_Msk                  (0x0fUL << VADC_G_RCR_DRCTR_Pos)                        /*!< VADC_G RCR: DRCTR Mask                  */
#define VADC_G_RCR_DMM_Pos                    20                                                      /*!< VADC_G RCR: DMM Position                */
#define VADC_G_RCR_DMM_Msk                    (0x03UL << VADC_G_RCR_DMM_Pos)                          /*!< VADC_G RCR: DMM Mask                    */
#define VADC_G_RCR_WFR_Pos                    24                                                      /*!< VADC_G RCR: WFR Position                */
#define VADC_G_RCR_WFR_Msk                    (0x01UL << VADC_G_RCR_WFR_Pos)                          /*!< VADC_G RCR: WFR Mask                    */
#define VADC_G_RCR_FEN_Pos                    25                                                      /*!< VADC_G RCR: FEN Position                */
#define VADC_G_RCR_FEN_Msk                    (0x03UL << VADC_G_RCR_FEN_Pos)                          /*!< VADC_G RCR: FEN Mask                    */
#define VADC_G_RCR_SRGEN_Pos                  31                                                      /*!< VADC_G RCR: SRGEN Position              */
#define VADC_G_RCR_SRGEN_Msk                  (0x01UL << VADC_G_RCR_SRGEN_Pos)                        /*!< VADC_G RCR: SRGEN Mask                  */

/* ---------------------------------  VADC_G_RES  --------------------------------- */
#define VADC_G_RES_RESULT_Pos                 0                                                       /*!< VADC_G RES: RESULT Position             */
#define VADC_G_RES_RESULT_Msk                 (0x0000ffffUL << VADC_G_RES_RESULT_Pos)                 /*!< VADC_G RES: RESULT Mask                 */
#define VADC_G_RES_DRC_Pos                    16                                                      /*!< VADC_G RES: DRC Position                */
#define VADC_G_RES_DRC_Msk                    (0x0fUL << VADC_G_RES_DRC_Pos)                          /*!< VADC_G RES: DRC Mask                    */
#define VADC_G_RES_CHNR_Pos                   20                                                      /*!< VADC_G RES: CHNR Position               */
#define VADC_G_RES_CHNR_Msk                   (0x1fUL << VADC_G_RES_CHNR_Pos)                         /*!< VADC_G RES: CHNR Mask                   */
#define VADC_G_RES_EMUX_Pos                   25                                                      /*!< VADC_G RES: EMUX Position               */
#define VADC_G_RES_EMUX_Msk                   (0x07UL << VADC_G_RES_EMUX_Pos)                         /*!< VADC_G RES: EMUX Mask                   */
#define VADC_G_RES_CRS_Pos                    28                                                      /*!< VADC_G RES: CRS Position                */
#define VADC_G_RES_CRS_Msk                    (0x03UL << VADC_G_RES_CRS_Pos)                          /*!< VADC_G RES: CRS Mask                    */
#define VADC_G_RES_FCR_Pos                    30                                                      /*!< VADC_G RES: FCR Position                */
#define VADC_G_RES_FCR_Msk                    (0x01UL << VADC_G_RES_FCR_Pos)                          /*!< VADC_G RES: FCR Mask                    */
#define VADC_G_RES_VF_Pos                     31                                                      /*!< VADC_G RES: VF Position                 */
#define VADC_G_RES_VF_Msk                     (0x01UL << VADC_G_RES_VF_Pos)                           /*!< VADC_G RES: VF Mask                     */

/* ---------------------------------  VADC_G_RESD  -------------------------------- */
#define VADC_G_RESD_RESULT_Pos                0                                                       /*!< VADC_G RESD: RESULT Position            */
#define VADC_G_RESD_RESULT_Msk                (0x0000ffffUL << VADC_G_RESD_RESULT_Pos)                /*!< VADC_G RESD: RESULT Mask                */
#define VADC_G_RESD_DRC_Pos                   16                                                      /*!< VADC_G RESD: DRC Position               */
#define VADC_G_RESD_DRC_Msk                   (0x0fUL << VADC_G_RESD_DRC_Pos)                         /*!< VADC_G RESD: DRC Mask                   */
#define VADC_G_RESD_CHNR_Pos                  20                                                      /*!< VADC_G RESD: CHNR Position              */
#define VADC_G_RESD_CHNR_Msk                  (0x1fUL << VADC_G_RESD_CHNR_Pos)                        /*!< VADC_G RESD: CHNR Mask                  */
#define VADC_G_RESD_EMUX_Pos                  25                                                      /*!< VADC_G RESD: EMUX Position              */
#define VADC_G_RESD_EMUX_Msk                  (0x07UL << VADC_G_RESD_EMUX_Pos)                        /*!< VADC_G RESD: EMUX Mask                  */
#define VADC_G_RESD_CRS_Pos                   28                                                      /*!< VADC_G RESD: CRS Position               */
#define VADC_G_RESD_CRS_Msk                   (0x03UL << VADC_G_RESD_CRS_Pos)                         /*!< VADC_G RESD: CRS Mask                   */
#define VADC_G_RESD_FCR_Pos                   30                                                      /*!< VADC_G RESD: FCR Position               */
#define VADC_G_RESD_FCR_Msk                   (0x01UL << VADC_G_RESD_FCR_Pos)                         /*!< VADC_G RESD: FCR Mask                   */
#define VADC_G_RESD_VF_Pos                    31                                                      /*!< VADC_G RESD: VF Position                */
#define VADC_G_RESD_VF_Msk                    (0x01UL << VADC_G_RESD_VF_Pos)                          /*!< VADC_G RESD: VF Mask                    */


/* ================================================================================ */
/* ================          struct 'DAC' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  DAC_ID  ----------------------------------- */
#define DAC_ID_MODR_Pos                       0                                                       /*!< DAC ID: MODR Position                   */
#define DAC_ID_MODR_Msk                       (0x000000ffUL << DAC_ID_MODR_Pos)                       /*!< DAC ID: MODR Mask                       */
#define DAC_ID_MODT_Pos                       8                                                       /*!< DAC ID: MODT Position                   */
#define DAC_ID_MODT_Msk                       (0x000000ffUL << DAC_ID_MODT_Pos)                       /*!< DAC ID: MODT Mask                       */
#define DAC_ID_MODN_Pos                       16                                                      /*!< DAC ID: MODN Position                   */
#define DAC_ID_MODN_Msk                       (0x0000ffffUL << DAC_ID_MODN_Pos)                       /*!< DAC ID: MODN Mask                       */

/* --------------------------------  DAC_DAC0CFG0  -------------------------------- */
#define DAC_DAC0CFG0_FREQ_Pos                 0                                                       /*!< DAC DAC0CFG0: FREQ Position             */
#define DAC_DAC0CFG0_FREQ_Msk                 (0x000fffffUL << DAC_DAC0CFG0_FREQ_Pos)                 /*!< DAC DAC0CFG0: FREQ Mask                 */
#define DAC_DAC0CFG0_MODE_Pos                 20                                                      /*!< DAC DAC0CFG0: MODE Position             */
#define DAC_DAC0CFG0_MODE_Msk                 (0x07UL << DAC_DAC0CFG0_MODE_Pos)                       /*!< DAC DAC0CFG0: MODE Mask                 */
#define DAC_DAC0CFG0_SIGN_Pos                 23                                                      /*!< DAC DAC0CFG0: SIGN Position             */
#define DAC_DAC0CFG0_SIGN_Msk                 (0x01UL << DAC_DAC0CFG0_SIGN_Pos)                       /*!< DAC DAC0CFG0: SIGN Mask                 */
#define DAC_DAC0CFG0_FIFOIND_Pos              24                                                      /*!< DAC DAC0CFG0: FIFOIND Position          */
#define DAC_DAC0CFG0_FIFOIND_Msk              (0x03UL << DAC_DAC0CFG0_FIFOIND_Pos)                    /*!< DAC DAC0CFG0: FIFOIND Mask              */
#define DAC_DAC0CFG0_FIFOEMP_Pos              26                                                      /*!< DAC DAC0CFG0: FIFOEMP Position          */
#define DAC_DAC0CFG0_FIFOEMP_Msk              (0x01UL << DAC_DAC0CFG0_FIFOEMP_Pos)                    /*!< DAC DAC0CFG0: FIFOEMP Mask              */
#define DAC_DAC0CFG0_FIFOFUL_Pos              27                                                      /*!< DAC DAC0CFG0: FIFOFUL Position          */
#define DAC_DAC0CFG0_FIFOFUL_Msk              (0x01UL << DAC_DAC0CFG0_FIFOFUL_Pos)                    /*!< DAC DAC0CFG0: FIFOFUL Mask              */
#define DAC_DAC0CFG0_NEGATE_Pos               28                                                      /*!< DAC DAC0CFG0: NEGATE Position           */
#define DAC_DAC0CFG0_NEGATE_Msk               (0x01UL << DAC_DAC0CFG0_NEGATE_Pos)                     /*!< DAC DAC0CFG0: NEGATE Mask               */
#define DAC_DAC0CFG0_SIGNEN_Pos               29                                                      /*!< DAC DAC0CFG0: SIGNEN Position           */
#define DAC_DAC0CFG0_SIGNEN_Msk               (0x01UL << DAC_DAC0CFG0_SIGNEN_Pos)                     /*!< DAC DAC0CFG0: SIGNEN Mask               */
#define DAC_DAC0CFG0_SREN_Pos                 30                                                      /*!< DAC DAC0CFG0: SREN Position             */
#define DAC_DAC0CFG0_SREN_Msk                 (0x01UL << DAC_DAC0CFG0_SREN_Pos)                       /*!< DAC DAC0CFG0: SREN Mask                 */
#define DAC_DAC0CFG0_RUN_Pos                  31                                                      /*!< DAC DAC0CFG0: RUN Position              */
#define DAC_DAC0CFG0_RUN_Msk                  (0x01UL << DAC_DAC0CFG0_RUN_Pos)                        /*!< DAC DAC0CFG0: RUN Mask                  */

/* --------------------------------  DAC_DAC0CFG1  -------------------------------- */
#define DAC_DAC0CFG1_SCALE_Pos                0                                                       /*!< DAC DAC0CFG1: SCALE Position            */
#define DAC_DAC0CFG1_SCALE_Msk                (0x07UL << DAC_DAC0CFG1_SCALE_Pos)                      /*!< DAC DAC0CFG1: SCALE Mask                */
#define DAC_DAC0CFG1_MULDIV_Pos               3                                                       /*!< DAC DAC0CFG1: MULDIV Position           */
#define DAC_DAC0CFG1_MULDIV_Msk               (0x01UL << DAC_DAC0CFG1_MULDIV_Pos)                     /*!< DAC DAC0CFG1: MULDIV Mask               */
#define DAC_DAC0CFG1_OFFS_Pos                 4                                                       /*!< DAC DAC0CFG1: OFFS Position             */
#define DAC_DAC0CFG1_OFFS_Msk                 (0x000000ffUL << DAC_DAC0CFG1_OFFS_Pos)                 /*!< DAC DAC0CFG1: OFFS Mask                 */
#define DAC_DAC0CFG1_TRIGSEL_Pos              12                                                      /*!< DAC DAC0CFG1: TRIGSEL Position          */
#define DAC_DAC0CFG1_TRIGSEL_Msk              (0x07UL << DAC_DAC0CFG1_TRIGSEL_Pos)                    /*!< DAC DAC0CFG1: TRIGSEL Mask              */
#define DAC_DAC0CFG1_DATMOD_Pos               15                                                      /*!< DAC DAC0CFG1: DATMOD Position           */
#define DAC_DAC0CFG1_DATMOD_Msk               (0x01UL << DAC_DAC0CFG1_DATMOD_Pos)                     /*!< DAC DAC0CFG1: DATMOD Mask               */
#define DAC_DAC0CFG1_SWTRIG_Pos               16                                                      /*!< DAC DAC0CFG1: SWTRIG Position           */
#define DAC_DAC0CFG1_SWTRIG_Msk               (0x01UL << DAC_DAC0CFG1_SWTRIG_Pos)                     /*!< DAC DAC0CFG1: SWTRIG Mask               */
#define DAC_DAC0CFG1_TRIGMOD_Pos              17                                                      /*!< DAC DAC0CFG1: TRIGMOD Position          */
#define DAC_DAC0CFG1_TRIGMOD_Msk              (0x03UL << DAC_DAC0CFG1_TRIGMOD_Pos)                    /*!< DAC DAC0CFG1: TRIGMOD Mask              */
#define DAC_DAC0CFG1_ANACFG_Pos               19                                                      /*!< DAC DAC0CFG1: ANACFG Position           */
#define DAC_DAC0CFG1_ANACFG_Msk               (0x1fUL << DAC_DAC0CFG1_ANACFG_Pos)                     /*!< DAC DAC0CFG1: ANACFG Mask               */
#define DAC_DAC0CFG1_ANAEN_Pos                24                                                      /*!< DAC DAC0CFG1: ANAEN Position            */
#define DAC_DAC0CFG1_ANAEN_Msk                (0x01UL << DAC_DAC0CFG1_ANAEN_Pos)                      /*!< DAC DAC0CFG1: ANAEN Mask                */
#define DAC_DAC0CFG1_REFCFGL_Pos              28                                                      /*!< DAC DAC0CFG1: REFCFGL Position          */
#define DAC_DAC0CFG1_REFCFGL_Msk              (0x0fUL << DAC_DAC0CFG1_REFCFGL_Pos)                    /*!< DAC DAC0CFG1: REFCFGL Mask              */

/* --------------------------------  DAC_DAC1CFG0  -------------------------------- */
#define DAC_DAC1CFG0_FREQ_Pos                 0                                                       /*!< DAC DAC1CFG0: FREQ Position             */
#define DAC_DAC1CFG0_FREQ_Msk                 (0x000fffffUL << DAC_DAC1CFG0_FREQ_Pos)                 /*!< DAC DAC1CFG0: FREQ Mask                 */
#define DAC_DAC1CFG0_MODE_Pos                 20                                                      /*!< DAC DAC1CFG0: MODE Position             */
#define DAC_DAC1CFG0_MODE_Msk                 (0x07UL << DAC_DAC1CFG0_MODE_Pos)                       /*!< DAC DAC1CFG0: MODE Mask                 */
#define DAC_DAC1CFG0_SIGN_Pos                 23                                                      /*!< DAC DAC1CFG0: SIGN Position             */
#define DAC_DAC1CFG0_SIGN_Msk                 (0x01UL << DAC_DAC1CFG0_SIGN_Pos)                       /*!< DAC DAC1CFG0: SIGN Mask                 */
#define DAC_DAC1CFG0_FIFOIND_Pos              24                                                      /*!< DAC DAC1CFG0: FIFOIND Position          */
#define DAC_DAC1CFG0_FIFOIND_Msk              (0x03UL << DAC_DAC1CFG0_FIFOIND_Pos)                    /*!< DAC DAC1CFG0: FIFOIND Mask              */
#define DAC_DAC1CFG0_FIFOEMP_Pos              26                                                      /*!< DAC DAC1CFG0: FIFOEMP Position          */
#define DAC_DAC1CFG0_FIFOEMP_Msk              (0x01UL << DAC_DAC1CFG0_FIFOEMP_Pos)                    /*!< DAC DAC1CFG0: FIFOEMP Mask              */
#define DAC_DAC1CFG0_FIFOFUL_Pos              27                                                      /*!< DAC DAC1CFG0: FIFOFUL Position          */
#define DAC_DAC1CFG0_FIFOFUL_Msk              (0x01UL << DAC_DAC1CFG0_FIFOFUL_Pos)                    /*!< DAC DAC1CFG0: FIFOFUL Mask              */
#define DAC_DAC1CFG0_NEGATE_Pos               28                                                      /*!< DAC DAC1CFG0: NEGATE Position           */
#define DAC_DAC1CFG0_NEGATE_Msk               (0x01UL << DAC_DAC1CFG0_NEGATE_Pos)                     /*!< DAC DAC1CFG0: NEGATE Mask               */
#define DAC_DAC1CFG0_SIGNEN_Pos               29                                                      /*!< DAC DAC1CFG0: SIGNEN Position           */
#define DAC_DAC1CFG0_SIGNEN_Msk               (0x01UL << DAC_DAC1CFG0_SIGNEN_Pos)                     /*!< DAC DAC1CFG0: SIGNEN Mask               */
#define DAC_DAC1CFG0_SREN_Pos                 30                                                      /*!< DAC DAC1CFG0: SREN Position             */
#define DAC_DAC1CFG0_SREN_Msk                 (0x01UL << DAC_DAC1CFG0_SREN_Pos)                       /*!< DAC DAC1CFG0: SREN Mask                 */
#define DAC_DAC1CFG0_RUN_Pos                  31                                                      /*!< DAC DAC1CFG0: RUN Position              */
#define DAC_DAC1CFG0_RUN_Msk                  (0x01UL << DAC_DAC1CFG0_RUN_Pos)                        /*!< DAC DAC1CFG0: RUN Mask                  */

/* --------------------------------  DAC_DAC1CFG1  -------------------------------- */
#define DAC_DAC1CFG1_SCALE_Pos                0                                                       /*!< DAC DAC1CFG1: SCALE Position            */
#define DAC_DAC1CFG1_SCALE_Msk                (0x07UL << DAC_DAC1CFG1_SCALE_Pos)                      /*!< DAC DAC1CFG1: SCALE Mask                */
#define DAC_DAC1CFG1_MULDIV_Pos               3                                                       /*!< DAC DAC1CFG1: MULDIV Position           */
#define DAC_DAC1CFG1_MULDIV_Msk               (0x01UL << DAC_DAC1CFG1_MULDIV_Pos)                     /*!< DAC DAC1CFG1: MULDIV Mask               */
#define DAC_DAC1CFG1_OFFS_Pos                 4                                                       /*!< DAC DAC1CFG1: OFFS Position             */
#define DAC_DAC1CFG1_OFFS_Msk                 (0x000000ffUL << DAC_DAC1CFG1_OFFS_Pos)                 /*!< DAC DAC1CFG1: OFFS Mask                 */
#define DAC_DAC1CFG1_TRIGSEL_Pos              12                                                      /*!< DAC DAC1CFG1: TRIGSEL Position          */
#define DAC_DAC1CFG1_TRIGSEL_Msk              (0x07UL << DAC_DAC1CFG1_TRIGSEL_Pos)                    /*!< DAC DAC1CFG1: TRIGSEL Mask              */
#define DAC_DAC1CFG1_SWTRIG_Pos               16                                                      /*!< DAC DAC1CFG1: SWTRIG Position           */
#define DAC_DAC1CFG1_SWTRIG_Msk               (0x01UL << DAC_DAC1CFG1_SWTRIG_Pos)                     /*!< DAC DAC1CFG1: SWTRIG Mask               */
#define DAC_DAC1CFG1_TRIGMOD_Pos              17                                                      /*!< DAC DAC1CFG1: TRIGMOD Position          */
#define DAC_DAC1CFG1_TRIGMOD_Msk              (0x03UL << DAC_DAC1CFG1_TRIGMOD_Pos)                    /*!< DAC DAC1CFG1: TRIGMOD Mask              */
#define DAC_DAC1CFG1_ANACFG_Pos               19                                                      /*!< DAC DAC1CFG1: ANACFG Position           */
#define DAC_DAC1CFG1_ANACFG_Msk               (0x1fUL << DAC_DAC1CFG1_ANACFG_Pos)                     /*!< DAC DAC1CFG1: ANACFG Mask               */
#define DAC_DAC1CFG1_ANAEN_Pos                24                                                      /*!< DAC DAC1CFG1: ANAEN Position            */
#define DAC_DAC1CFG1_ANAEN_Msk                (0x01UL << DAC_DAC1CFG1_ANAEN_Pos)                      /*!< DAC DAC1CFG1: ANAEN Mask                */
#define DAC_DAC1CFG1_REFCFGH_Pos              28                                                      /*!< DAC DAC1CFG1: REFCFGH Position          */
#define DAC_DAC1CFG1_REFCFGH_Msk              (0x0fUL << DAC_DAC1CFG1_REFCFGH_Pos)                    /*!< DAC DAC1CFG1: REFCFGH Mask              */

/* --------------------------------  DAC_DAC0DATA  -------------------------------- */
#define DAC_DAC0DATA_DATA0_Pos                0                                                       /*!< DAC DAC0DATA: DATA0 Position            */
#define DAC_DAC0DATA_DATA0_Msk                (0x00000fffUL << DAC_DAC0DATA_DATA0_Pos)                /*!< DAC DAC0DATA: DATA0 Mask                */

/* --------------------------------  DAC_DAC1DATA  -------------------------------- */
#define DAC_DAC1DATA_DATA1_Pos                0                                                       /*!< DAC DAC1DATA: DATA1 Position            */
#define DAC_DAC1DATA_DATA1_Msk                (0x00000fffUL << DAC_DAC1DATA_DATA1_Pos)                /*!< DAC DAC1DATA: DATA1 Mask                */

/* --------------------------------  DAC_DAC01DATA  ------------------------------- */
#define DAC_DAC01DATA_DATA0_Pos               0                                                       /*!< DAC DAC01DATA: DATA0 Position           */
#define DAC_DAC01DATA_DATA0_Msk               (0x00000fffUL << DAC_DAC01DATA_DATA0_Pos)               /*!< DAC DAC01DATA: DATA0 Mask               */
#define DAC_DAC01DATA_DATA1_Pos               16                                                      /*!< DAC DAC01DATA: DATA1 Position           */
#define DAC_DAC01DATA_DATA1_Msk               (0x00000fffUL << DAC_DAC01DATA_DATA1_Pos)               /*!< DAC DAC01DATA: DATA1 Mask               */

/* --------------------------------  DAC_DAC0PATL  -------------------------------- */
#define DAC_DAC0PATL_PAT0_Pos                 0                                                       /*!< DAC DAC0PATL: PAT0 Position             */
#define DAC_DAC0PATL_PAT0_Msk                 (0x1fUL << DAC_DAC0PATL_PAT0_Pos)                       /*!< DAC DAC0PATL: PAT0 Mask                 */
#define DAC_DAC0PATL_PAT1_Pos                 5                                                       /*!< DAC DAC0PATL: PAT1 Position             */
#define DAC_DAC0PATL_PAT1_Msk                 (0x1fUL << DAC_DAC0PATL_PAT1_Pos)                       /*!< DAC DAC0PATL: PAT1 Mask                 */
#define DAC_DAC0PATL_PAT2_Pos                 10                                                      /*!< DAC DAC0PATL: PAT2 Position             */
#define DAC_DAC0PATL_PAT2_Msk                 (0x1fUL << DAC_DAC0PATL_PAT2_Pos)                       /*!< DAC DAC0PATL: PAT2 Mask                 */
#define DAC_DAC0PATL_PAT3_Pos                 15                                                      /*!< DAC DAC0PATL: PAT3 Position             */
#define DAC_DAC0PATL_PAT3_Msk                 (0x1fUL << DAC_DAC0PATL_PAT3_Pos)                       /*!< DAC DAC0PATL: PAT3 Mask                 */
#define DAC_DAC0PATL_PAT4_Pos                 20                                                      /*!< DAC DAC0PATL: PAT4 Position             */
#define DAC_DAC0PATL_PAT4_Msk                 (0x1fUL << DAC_DAC0PATL_PAT4_Pos)                       /*!< DAC DAC0PATL: PAT4 Mask                 */
#define DAC_DAC0PATL_PAT5_Pos                 25                                                      /*!< DAC DAC0PATL: PAT5 Position             */
#define DAC_DAC0PATL_PAT5_Msk                 (0x1fUL << DAC_DAC0PATL_PAT5_Pos)                       /*!< DAC DAC0PATL: PAT5 Mask                 */

/* --------------------------------  DAC_DAC0PATH  -------------------------------- */
#define DAC_DAC0PATH_PAT6_Pos                 0                                                       /*!< DAC DAC0PATH: PAT6 Position             */
#define DAC_DAC0PATH_PAT6_Msk                 (0x1fUL << DAC_DAC0PATH_PAT6_Pos)                       /*!< DAC DAC0PATH: PAT6 Mask                 */
#define DAC_DAC0PATH_PAT7_Pos                 5                                                       /*!< DAC DAC0PATH: PAT7 Position             */
#define DAC_DAC0PATH_PAT7_Msk                 (0x1fUL << DAC_DAC0PATH_PAT7_Pos)                       /*!< DAC DAC0PATH: PAT7 Mask                 */
#define DAC_DAC0PATH_PAT8_Pos                 10                                                      /*!< DAC DAC0PATH: PAT8 Position             */
#define DAC_DAC0PATH_PAT8_Msk                 (0x1fUL << DAC_DAC0PATH_PAT8_Pos)                       /*!< DAC DAC0PATH: PAT8 Mask                 */

/* --------------------------------  DAC_DAC1PATL  -------------------------------- */
#define DAC_DAC1PATL_PAT0_Pos                 0                                                       /*!< DAC DAC1PATL: PAT0 Position             */
#define DAC_DAC1PATL_PAT0_Msk                 (0x1fUL << DAC_DAC1PATL_PAT0_Pos)                       /*!< DAC DAC1PATL: PAT0 Mask                 */
#define DAC_DAC1PATL_PAT1_Pos                 5                                                       /*!< DAC DAC1PATL: PAT1 Position             */
#define DAC_DAC1PATL_PAT1_Msk                 (0x1fUL << DAC_DAC1PATL_PAT1_Pos)                       /*!< DAC DAC1PATL: PAT1 Mask                 */
#define DAC_DAC1PATL_PAT2_Pos                 10                                                      /*!< DAC DAC1PATL: PAT2 Position             */
#define DAC_DAC1PATL_PAT2_Msk                 (0x1fUL << DAC_DAC1PATL_PAT2_Pos)                       /*!< DAC DAC1PATL: PAT2 Mask                 */
#define DAC_DAC1PATL_PAT3_Pos                 15                                                      /*!< DAC DAC1PATL: PAT3 Position             */
#define DAC_DAC1PATL_PAT3_Msk                 (0x1fUL << DAC_DAC1PATL_PAT3_Pos)                       /*!< DAC DAC1PATL: PAT3 Mask                 */
#define DAC_DAC1PATL_PAT4_Pos                 20                                                      /*!< DAC DAC1PATL: PAT4 Position             */
#define DAC_DAC1PATL_PAT4_Msk                 (0x1fUL << DAC_DAC1PATL_PAT4_Pos)                       /*!< DAC DAC1PATL: PAT4 Mask                 */
#define DAC_DAC1PATL_PAT5_Pos                 25                                                      /*!< DAC DAC1PATL: PAT5 Position             */
#define DAC_DAC1PATL_PAT5_Msk                 (0x1fUL << DAC_DAC1PATL_PAT5_Pos)                       /*!< DAC DAC1PATL: PAT5 Mask                 */

/* --------------------------------  DAC_DAC1PATH  -------------------------------- */
#define DAC_DAC1PATH_PAT6_Pos                 0                                                       /*!< DAC DAC1PATH: PAT6 Position             */
#define DAC_DAC1PATH_PAT6_Msk                 (0x1fUL << DAC_DAC1PATH_PAT6_Pos)                       /*!< DAC DAC1PATH: PAT6 Mask                 */
#define DAC_DAC1PATH_PAT7_Pos                 5                                                       /*!< DAC DAC1PATH: PAT7 Position             */
#define DAC_DAC1PATH_PAT7_Msk                 (0x1fUL << DAC_DAC1PATH_PAT7_Pos)                       /*!< DAC DAC1PATH: PAT7 Mask                 */
#define DAC_DAC1PATH_PAT8_Pos                 10                                                      /*!< DAC DAC1PATH: PAT8 Position             */
#define DAC_DAC1PATH_PAT8_Msk                 (0x1fUL << DAC_DAC1PATH_PAT8_Pos)                       /*!< DAC DAC1PATH: PAT8 Mask                 */


/* ================================================================================ */
/* ================          Group 'CCU4' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  CCU4_GCTRL  --------------------------------- */
#define CCU4_GCTRL_PRBC_Pos                   0                                                       /*!< CCU4 GCTRL: PRBC Position               */
#define CCU4_GCTRL_PRBC_Msk                   (0x07UL << CCU4_GCTRL_PRBC_Pos)                         /*!< CCU4 GCTRL: PRBC Mask                   */
#define CCU4_GCTRL_PCIS_Pos                   4                                                       /*!< CCU4 GCTRL: PCIS Position               */
#define CCU4_GCTRL_PCIS_Msk                   (0x03UL << CCU4_GCTRL_PCIS_Pos)                         /*!< CCU4 GCTRL: PCIS Mask                   */
#define CCU4_GCTRL_SUSCFG_Pos                 8                                                       /*!< CCU4 GCTRL: SUSCFG Position             */
#define CCU4_GCTRL_SUSCFG_Msk                 (0x03UL << CCU4_GCTRL_SUSCFG_Pos)                       /*!< CCU4 GCTRL: SUSCFG Mask                 */
#define CCU4_GCTRL_MSE0_Pos                   10                                                      /*!< CCU4 GCTRL: MSE0 Position               */
#define CCU4_GCTRL_MSE0_Msk                   (0x01UL << CCU4_GCTRL_MSE0_Pos)                         /*!< CCU4 GCTRL: MSE0 Mask                   */
#define CCU4_GCTRL_MSE1_Pos                   11                                                      /*!< CCU4 GCTRL: MSE1 Position               */
#define CCU4_GCTRL_MSE1_Msk                   (0x01UL << CCU4_GCTRL_MSE1_Pos)                         /*!< CCU4 GCTRL: MSE1 Mask                   */
#define CCU4_GCTRL_MSE2_Pos                   12                                                      /*!< CCU4 GCTRL: MSE2 Position               */
#define CCU4_GCTRL_MSE2_Msk                   (0x01UL << CCU4_GCTRL_MSE2_Pos)                         /*!< CCU4 GCTRL: MSE2 Mask                   */
#define CCU4_GCTRL_MSE3_Pos                   13                                                      /*!< CCU4 GCTRL: MSE3 Position               */
#define CCU4_GCTRL_MSE3_Msk                   (0x01UL << CCU4_GCTRL_MSE3_Pos)                         /*!< CCU4 GCTRL: MSE3 Mask                   */
#define CCU4_GCTRL_MSDE_Pos                   14                                                      /*!< CCU4 GCTRL: MSDE Position               */
#define CCU4_GCTRL_MSDE_Msk                   (0x03UL << CCU4_GCTRL_MSDE_Pos)                         /*!< CCU4 GCTRL: MSDE Mask                   */

/* ---------------------------------  CCU4_GSTAT  --------------------------------- */
#define CCU4_GSTAT_S0I_Pos                    0                                                       /*!< CCU4 GSTAT: S0I Position                */
#define CCU4_GSTAT_S0I_Msk                    (0x01UL << CCU4_GSTAT_S0I_Pos)                          /*!< CCU4 GSTAT: S0I Mask                    */
#define CCU4_GSTAT_S1I_Pos                    1                                                       /*!< CCU4 GSTAT: S1I Position                */
#define CCU4_GSTAT_S1I_Msk                    (0x01UL << CCU4_GSTAT_S1I_Pos)                          /*!< CCU4 GSTAT: S1I Mask                    */
#define CCU4_GSTAT_S2I_Pos                    2                                                       /*!< CCU4 GSTAT: S2I Position                */
#define CCU4_GSTAT_S2I_Msk                    (0x01UL << CCU4_GSTAT_S2I_Pos)                          /*!< CCU4 GSTAT: S2I Mask                    */
#define CCU4_GSTAT_S3I_Pos                    3                                                    