
/****************************************************************************************************//**
 * @file     XMC4400.h
 *
 * @brief    CMSIS Cortex-M4 Peripheral Access Layer Header File for
 *           XMC4400 from Infineon.
 *
 * @version  V1.1.0 (Reference Manual v1.1)
 * @date     13. December 2012
 *
 * @note     Generated with SVDConv V2.78b 
 *           from CMSIS SVD File 'XMC4400_Processed_SVD.xml' Version 1.1.0 (Reference Manual v1.1),
 *******************************************************************************************************/



/** @addtogroup Infineon
  * @{
  */

/** @addtogroup XMC4400
  * @{
  */

#ifndef XMC4400_H
#define XMC4400_H

#ifdef __cplusplus
extern "C" {
#endif


/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum {
/* -------------------  Cortex-M4 Processor Exceptions Numbers  ------------------- */
  Reset_IRQn                    = -15,              /*!<   1  Reset Vector, invoked on Power up and warm reset                 */
  NonMaskableInt_IRQn           = -14,              /*!<   2  Non maskable Interrupt, cannot be stopped or preempted           */
  HardFault_IRQn                = -13,              /*!<   3  Hard Fault, all classes of Fault                                 */
  MemoryManagement_IRQn         = -12,              /*!<   4  Memory Management, MPU mismatch, including Access Violation
                                                         and No Match                                                          */
  BusFault_IRQn                 = -11,              /*!<   5  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                         related Fault                                                         */
  UsageFault_IRQn               = -10,              /*!<   6  Usage Fault, i.e. Undef Instruction, Illegal State Transition    */
  SVCall_IRQn                   =  -5,              /*!<  11  System Service Call via SVC instruction                          */
  DebugMonitor_IRQn             =  -4,              /*!<  12  Debug Monitor                                                    */
  PendSV_IRQn                   =  -2,              /*!<  14  Pendable request for system service                              */
  SysTick_IRQn                  =  -1,              /*!<  15  System Tick Timer                                                */
/* ---------------------  XMC4400 Specific Interrupt Numbers  --------------------- */
  SCU_0_IRQn                    =   0,              /*!<   0  SCU_0                                                            */
  ERU0_0_IRQn                   =   1,              /*!<   1  ERU0_0                                                           */
  ERU0_1_IRQn                   =   2,              /*!<   2  ERU0_1                                                           */
  ERU0_2_IRQn                   =   3,              /*!<   3  ERU0_2                                                           */
  ERU0_3_IRQn                   =   4,              /*!<   4  ERU0_3                                                           */
  ERU1_0_IRQn                   =   5,              /*!<   5  ERU1_0                                                           */
  ERU1_1_IRQn                   =   6,              /*!<   6  ERU1_1                                                           */
  ERU1_2_IRQn                   =   7,              /*!<   7  ERU1_2                                                           */
  ERU1_3_IRQn                   =   8,              /*!<   8  ERU1_3                                                           */
  PMU0_0_IRQn                   =  12,              /*!<  12  PMU0_0                                                           */
  VADC0_C0_0_IRQn               =  14,              /*!<  14  VADC0_C0_0                                                       */
  VADC0_C0_1_IRQn               =  15,              /*!<  15  VADC0_C0_1                                                       */
  VADC0_C0_2_IRQn               =  16,              /*!<  16  VADC0_C0_2                                                       */
  VADC0_C0_3_IRQn               =  17,              /*!<  17  VADC0_C0_3                                                       */
  VADC0_G0_0_IRQn               =  18,              /*!<  18  VADC0_G0_0                                                       */
  VADC0_G0_1_IRQn               =  19,              /*!<  19  VADC0_G0_1                                                       */
  VADC0_G0_2_IRQn               =  20,              /*!<  20  VADC0_G0_2                                                       */
  VADC0_G0_3_IRQn               =  21,              /*!<  21  VADC0_G0_3                                                       */
  VADC0_G1_0_IRQn               =  22,              /*!<  22  VADC0_G1_0                                                       */
  VADC0_G1_1_IRQn               =  23,              /*!<  23  VADC0_G1_1                                                       */
  VADC0_G1_2_IRQn               =  24,              /*!<  24  VADC0_G1_2                                                       */
  VADC0_G1_3_IRQn               =  25,              /*!<  25  VADC0_G1_3                                                       */
  VADC0_G2_0_IRQn               =  26,              /*!<  26  VADC0_G2_0                                                       */
  VADC0_G2_1_IRQn               =  27,              /*!<  27  VADC0_G2_1                                                       */
  VADC0_G2_2_IRQn               =  28,              /*!<  28  VADC0_G2_2                                                       */
  VADC0_G2_3_IRQn               =  29,              /*!<  29  VADC0_G2_3                                                       */
  VADC0_G3_0_IRQn               =  30,              /*!<  30  VADC0_G3_0                                                       */
  VADC0_G3_1_IRQn               =  31,              /*!<  31  VADC0_G3_1                                                       */
  VADC0_G3_2_IRQn               =  32,              /*!<  32  VADC0_G3_2                                                       */
  VADC0_G3_3_IRQn               =  33,              /*!<  33  VADC0_G3_3                                                       */
  DSD0_M_0_IRQn                 =  34,              /*!<  34  DSD0_M_0                                                         */
  DSD0_M_1_IRQn                 =  35,              /*!<  35  DSD0_M_1                                                         */
  DSD0_M_2_IRQn                 =  36,              /*!<  36  DSD0_M_2                                                         */
  DSD0_M_3_IRQn                 =  37,              /*!<  37  DSD0_M_3                                                         */
  DSD0_A_4_IRQn                 =  38,              /*!<  38  DSD0_A_4                                                         */
  DSD0_A_5_IRQn                 =  39,              /*!<  39  DSD0_A_5                                                         */
  DSD0_A_6_IRQn                 =  40,              /*!<  40  DSD0_A_6                                                         */
  DSD0_A_7_IRQn                 =  41,              /*!<  41  DSD0_A_7                                                         */
  DAC0_0_IRQn                   =  42,              /*!<  42  DAC0_0                                                           */
  DAC0_1_IRQn                   =  43,              /*!<  43  DAC0_1                                                           */
  CCU40_0_IRQn                  =  44,              /*!<  44  CCU40_0                                                          */
  CCU40_1_IRQn                  =  45,              /*!<  45  CCU40_1                                                          */
  CCU40_2_IRQn                  =  46,              /*!<  46  CCU40_2                                                          */
  CCU40_3_IRQn                  =  47,              /*!<  47  CCU40_3                                                          */
  CCU41_0_IRQn                  =  48,              /*!<  48  CCU41_0                                                          */
  CCU41_1_IRQn                  =  49,              /*!<  49  CCU41_1                                                          */
  CCU41_2_IRQn                  =  50,              /*!<  50  CCU41_2                                                          */
  CCU41_3_IRQn                  =  51,              /*!<  51  CCU41_3                                                          */
  CCU42_0_IRQn                  =  52,              /*!<  52  CCU42_0                                                          */
  CCU42_1_IRQn                  =  53,              /*!<  53  CCU42_1                                                          */
  CCU42_2_IRQn                  =  54,              /*!<  54  CCU42_2                                                          */
  CCU42_3_IRQn                  =  55,              /*!<  55  CCU42_3                                                          */
  CCU43_0_IRQn                  =  56,              /*!<  56  CCU43_0                                                          */
  CCU43_1_IRQn                  =  57,              /*!<  57  CCU43_1                                                          */
  CCU43_2_IRQn                  =  58,              /*!<  58  CCU43_2                                                          */
  CCU43_3_IRQn                  =  59,              /*!<  59  CCU43_3                                                          */
  CCU80_0_IRQn                  =  60,              /*!<  60  CCU80_0                                                          */
  CCU80_1_IRQn                  =  61,              /*!<  61  CCU80_1                                                          */
  CCU80_2_IRQn                  =  62,              /*!<  62  CCU80_2                                                          */
  CCU80_3_IRQn                  =  63,              /*!<  63  CCU80_3                                                          */
  CCU81_0_IRQn                  =  64,              /*!<  64  CCU81_0                                                          */
  CCU81_1_IRQn                  =  65,              /*!<  65  CCU81_1                                                          */
  CCU81_2_IRQn                  =  66,              /*!<  66  CCU81_2                                                          */
  CCU81_3_IRQn                  =  67,              /*!<  67  CCU81_3                                                          */
  POSIF0_0_IRQn                 =  68,              /*!<  68  POSIF0_0                                                         */
  POSIF0_1_IRQn                 =  69,              /*!<  69  POSIF0_1                                                         */
  POSIF1_0_IRQn                 =  70,              /*!<  70  POSIF1_0                                                         */
  POSIF1_1_IRQn                 =  71,              /*!<  71  POSIF1_1                                                         */
  HRPWM_0_IRQn                  =  72,              /*!<  72  HRPWM_0                                                          */
  HRPWM_1_IRQn                  =  73,              /*!<  73  HRPWM_1                                                          */ 
  HRPWM_2_IRQn                  =  74,              /*!<  72  HRPWM_2                                                          */
  HRPWM_3_IRQn                  =  75,              /*!<  73  HRPWM_3                                                          */ 
  CAN0_0_IRQn                   =  76,              /*!<  76  CAN0_0                                                           */
  CAN0_1_IRQn                   =  77,              /*!<  77  CAN0_1                                                           */
  CAN0_2_IRQn                   =  78,              /*!<  78  CAN0_2                                                           */
  CAN0_3_IRQn                   =  79,              /*!<  79  CAN0_3                                                           */
  CAN0_4_IRQn                   =  80,              /*!<  80  CAN0_4                                                           */
  CAN0_5_IRQn                   =  81,              /*!<  81  CAN0_5                                                           */
  CAN0_6_IRQn                   =  82,              /*!<  82  CAN0_6                                                           */
  CAN0_7_IRQn                   =  83,              /*!<  83  CAN0_7                                                           */
  USIC0_0_IRQn                  =  84,              /*!<  84  USIC0_0                                                          */
  USIC0_1_IRQn                  =  85,              /*!<  85  USIC0_1                                                          */
  USIC0_2_IRQn                  =  86,              /*!<  86  USIC0_2                                                          */
  USIC0_3_IRQn                  =  87,              /*!<  87  USIC0_3                                                          */
  USIC0_4_IRQn                  =  88,              /*!<  88  USIC0_4                                                          */
  USIC0_5_IRQn                  =  89,              /*!<  89  USIC0_5                                                          */
  USIC1_0_IRQn                  =  90,              /*!<  90  USIC1_0                                                          */
  USIC1_1_IRQn                  =  91,              /*!<  91  USIC1_1                                                          */
  USIC1_2_IRQn                  =  92,              /*!<  92  USIC1_2                                                          */
  USIC1_3_IRQn                  =  93,              /*!<  93  USIC1_3                                                          */
  USIC1_4_IRQn                  =  94,              /*!<  94  USIC1_4                                                          */
  USIC1_5_IRQn                  =  95,              /*!<  95  USIC1_5                                                          */
  LEDTS0_0_IRQn                 = 102,              /*!< 102  LEDTS0_0                                                         */
  FCE0_0_IRQn                   = 104,              /*!< 104  FCE0_0                                                           */
  GPDMA0_0_IRQn                 = 105,              /*!< 105  GPDMA0_0                                                         */
  USB0_0_IRQn                   = 107,              /*!< 107  USB0_0                                                           */
  ETH0_0_IRQn                   = 108,              /*!< 108  ETH0_0                                                           */
} IRQn_Type;


/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

/* ----------------Configuration of the Cortex-M4 Processor and Core Peripherals---------------- */
#define __CM4_REV                 0x0200            /*!< Cortex-M4 Core Revision                                               */
#define __MPU_PRESENT                  1            /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS               6            /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig         0            /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT                  1            /*!< FPU present or not                                                    */
/** @} */ /* End of group Configuration_of_CMSIS */

#include <core_cm4.h>                               /*!< Cortex-M4 processor and core peripherals                              */
#include "system_XMC4400.h"                         /*!< XMC4400 System                                                        */


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */
/* Macro to modify desired bitfields of a register */
#define WR_REG(reg, mask, pos, val) reg = (((uint32_t)val << pos) & \
		                                         ((uint32_t)mask)) | \
                                          (reg & ((uint32_t)~((uint32_t)mask)))

/* Macro to modify desired bitfields of a register */
#define WR_REG_SIZE(reg, mask, pos, val, size) {  \
uint##size##_t VAL1 = (uint##size##_t)((uint##size##_t)val << pos); \
uint##size##_t VAL2 = (uint##size##_t) (VAL1 & (uint##size##_t)mask); \
uint##size##_t VAL3 = (uint##size##_t)~((uint##size##_t)mask); \
uint##size##_t VAL4 = (uint##size##_t) ((uint##size##_t)reg & VAL3); \
reg = (uint##size##_t) (VAL2 | VAL4);\
}

/** Macro to read bitfields from a register */
#define RD_REG(reg, mask, pos) (((uint32_t)reg & (uint32_t)mask) >> pos)

/** Macro to read bitfields from a register */
#define RD_REG_SIZE(reg, mask, pos,size) ((uint##size##_t)(((uint32_t)reg & \
                                                      (uint32_t)mask) >> pos) )

/** Macro to set a bit in register */
#define SET_BIT(reg, pos)     (reg |= ((uint32_t)1<<pos))

/** Macro to clear a bit in register */
#define CLR_BIT(reg, pos)     (reg = reg & (uint32_t)(~((uint32_t)1<<pos)) )
/*
* ==========================================================================
* ---------- Interrupt Handler Definition ----------------------------------
* ==========================================================================
*/
#define IRQ_Hdlr_0   SCU_0_IRQHandler
#define IRQ_Hdlr_1   ERU0_0_IRQHandler
#define IRQ_Hdlr_2   ERU0_1_IRQHandler
#define IRQ_Hdlr_3   ERU0_2_IRQHandler
#define IRQ_Hdlr_4   ERU0_3_IRQHandler
#define IRQ_Hdlr_5   ERU1_0_IRQHandler
#define IRQ_Hdlr_6   ERU1_1_IRQHandler
#define IRQ_Hdlr_7   ERU1_2_IRQHandler
#define IRQ_Hdlr_8   ERU1_3_IRQHandler
#define IRQ_Hdlr_12  PMU0_0_IRQHandler
#define IRQ_Hdlr_14  VADC0_C0_0_IRQHandler
#define IRQ_Hdlr_15  VADC0_C0_1_IRQHandler
#define IRQ_Hdlr_16  VADC0_C0_2_IRQHandler
#define IRQ_Hdlr_17  VADC0_C0_3_IRQHandler
#define IRQ_Hdlr_18  VADC0_G0_0_IRQHandler
#define IRQ_Hdlr_19  VADC0_G0_1_IRQHandler
#define IRQ_Hdlr_20  VADC0_G0_2_IRQHandler
#define IRQ_Hdlr_21  VADC0_G0_3_IRQHandler
#define IRQ_Hdlr_22  VADC0_G1_0_IRQHandler
#define IRQ_Hdlr_23  VADC0_G1_1_IRQHandler
#define IRQ_Hdlr_24  VADC0_G1_2_IRQHandler
#define IRQ_Hdlr_25  VADC0_G1_3_IRQHandler
#define IRQ_Hdlr_26  VADC0_G2_0_IRQHandler
#define IRQ_Hdlr_27  VADC0_G2_1_IRQHandler
#define IRQ_Hdlr_28  VADC0_G2_2_IRQHandler
#define IRQ_Hdlr_29  VADC0_G2_3_IRQHandler
#define IRQ_Hdlr_30  VADC0_G3_0_IRQHandler
#define IRQ_Hdlr_31  VADC0_G3_1_IRQHandler
#define IRQ_Hdlr_32  VADC0_G3_2_IRQHandler
#define IRQ_Hdlr_33  VADC0_G3_3_IRQHandler
#define IRQ_Hdlr_34  DSD0_0_IRQHandler
#define IRQ_Hdlr_35  DSD0_1_IRQHandler
#define IRQ_Hdlr_36  DSD0_2_IRQHandler
#define IRQ_Hdlr_37  DSD0_3_IRQHandler
#define IRQ_Hdlr_38  DSD0_4_IRQHandler
#define IRQ_Hdlr_39  DSD0_5_IRQHandler
#define IRQ_Hdlr_40  DSD0_6_IRQHandler
#define IRQ_Hdlr_41  DSD0_7_IRQHandler
#define IRQ_Hdlr_42  DAC0_0_IRQHandler
#define IRQ_Hdlr_43  DAC0_1_IRQHandler
#define IRQ_Hdlr_44  CCU40_0_IRQHandler
#define IRQ_Hdlr_45  CCU40_1_IRQHandler
#define IRQ_Hdlr_46  CCU40_2_IRQHandler
#define IRQ_Hdlr_47  CCU40_3_IRQHandler
#define IRQ_Hdlr_48  CCU41_0_IRQHandler
#define IRQ_Hdlr_49  CCU41_1_IRQHandler
#define IRQ_Hdlr_50  CCU41_2_IRQHandler
#define IRQ_Hdlr_51  CCU41_3_IRQHandler
#define IRQ_Hdlr_52  CCU42_0_IRQHandler
#define IRQ_Hdlr_53  CCU42_1_IRQHandler
#define IRQ_Hdlr_54  CCU42_2_IRQHandler
#define IRQ_Hdlr_55  CCU42_3_IRQHandler
#define IRQ_Hdlr_56  CCU43_0_IRQHandler
#define IRQ_Hdlr_57  CCU43_1_IRQHandler
#define IRQ_Hdlr_58  CCU43_2_IRQHandler
#define IRQ_Hdlr_59  CCU43_3_IRQHandler
#define IRQ_Hdlr_60  CCU80_0_IRQHandler
#define IRQ_Hdlr_61  CCU80_1_IRQHandler
#define IRQ_Hdlr_62  CCU80_2_IRQHandler
#define IRQ_Hdlr_63  CCU80_3_IRQHandler
#define IRQ_Hdlr_64  CCU81_0_IRQHandler
#define IRQ_Hdlr_65  CCU81_1_IRQHandler
#define IRQ_Hdlr_66  CCU81_2_IRQHandler
#define IRQ_Hdlr_67  CCU81_3_IRQHandler
#define IRQ_Hdlr_68  POSIF0_0_IRQHandler
#define IRQ_Hdlr_69  POSIF0_1_IRQHandler
#define IRQ_Hdlr_70  POSIF1_0_IRQHandler
#define IRQ_Hdlr_71  POSIF1_1_IRQHandler
#define IRQ_Hdlr_72  HRPWM_0_IRQHandler
#define IRQ_Hdlr_73  HRPWM_1_IRQHandler
#define IRQ_Hdlr_74  HRPWM_2_IRQHandler
#define IRQ_Hdlr_75  HRPWM_3_IRQHandler
#define IRQ_Hdlr_76  CAN0_0_IRQHandler
#define IRQ_Hdlr_77  CAN0_1_IRQHandler
#define IRQ_Hdlr_78  CAN0_2_IRQHandler
#define IRQ_Hdlr_79  CAN0_3_IRQHandler
#define IRQ_Hdlr_80  CAN0_4_IRQHandler
#define IRQ_Hdlr_81  CAN0_5_IRQHandler
#define IRQ_Hdlr_82  CAN0_6_IRQHandler
#define IRQ_Hdlr_83  CAN0_7_IRQHandler
#define IRQ_Hdlr_84  USIC0_0_IRQHandler
#define IRQ_Hdlr_85  USIC0_1_IRQHandler
#define IRQ_Hdlr_86  USIC0_2_IRQHandler
#define IRQ_Hdlr_87  USIC0_3_IRQHandler
#define IRQ_Hdlr_88  USIC0_4_IRQHandler
#define IRQ_Hdlr_89  USIC0_5_IRQHandler
#define IRQ_Hdlr_90  USIC1_0_IRQHandler
#define IRQ_Hdlr_91  USIC1_1_IRQHandler
#define IRQ_Hdlr_92  USIC1_2_IRQHandler
#define IRQ_Hdlr_93  USIC1_3_IRQHandler
#define IRQ_Hdlr_94  USIC1_4_IRQHandler
#define IRQ_Hdlr_95  USIC1_5_IRQHandler
#define IRQ_Hdlr_101 USIC2_5_IRQHandler
#define IRQ_Hdlr_102 LEDTS0_0_IRQHandler
#define IRQ_Hdlr_104 FCE0_0_IRQHandler
#define IRQ_Hdlr_105 GPDMA0_0_IRQHandler
#define IRQ_Hdlr_107 USB0_0_IRQHandler
#define IRQ_Hdlr_108 ETH0_0_IRQHandler

/*
* ==========================================================================
* ---------- Interrupt Handler retrieval macro -----------------------------
* ==========================================================================
*/
#define GET_IRQ_HANDLER(N) IRQ_Hdlr_##N

/** @addtogroup Device_Peripheral_Registers
  * @{
  */


/* -------------------  Start of section using anonymous unions  ------------------ */
#if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined(__ICCARM__)
  #pragma language=extended
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning 586
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================                       PPB                      ================ */
/* ================================================================================ */


/**
  * @brief Cortex-M4 Private Peripheral Block (PPB)
  */

typedef struct {                                    /*!< (@ 0xE000E000) PPB Structure                                          */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  ACTLR;                             /*!< (@ 0xE000E008) Auxiliary Control Register                             */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  SYST_CSR;                          /*!< (@ 0xE000E010) SysTick Control and Status Register                    */
  __IO uint32_t  SYST_RVR;                          /*!< (@ 0xE000E014) SysTick Reload Value Register                          */
  __IO uint32_t  SYST_CVR;                          /*!< (@ 0xE000E018) SysTick Current Value Register                         */
  __IO uint32_t  SYST_CALIB;                        /*!< (@ 0xE000E01C) SysTick Calibration Value Register r                   */
  __I  uint32_t  RESERVED2[56];
  __IO uint32_t  NVIC_ISER0;                        /*!< (@ 0xE000E100) Interrupt Set-enable Register 0                        */
  __IO uint32_t  NVIC_ISER1;                        /*!< (@ 0xE000E104) Interrupt Set-enable Register 1                        */
  __IO uint32_t  NVIC_ISER2;                        /*!< (@ 0xE000E108) Interrupt Set-enable Register 2                        */
  __IO uint32_t  NVIC_ISER3;                        /*!< (@ 0xE000E10C) Interrupt Set-enable Register 3                        */
  __I  uint32_t  RESERVED3[28];
  __IO uint32_t  NVIC_ICER0;                        /*!< (@ 0xE000E180) Interrupt Clear-enable Register 0                      */
  __IO uint32_t  NVIC_ICER1;                        /*!< (@ 0xE000E184) Interrupt Clear-enable Register 1                      */
  __IO uint32_t  NVIC_ICER2;                        /*!< (@ 0xE000E188) Interrupt Clear-enable Register 2                      */
  __IO uint32_t  NVIC_ICER3;                        /*!< (@ 0xE000E18C) Interrupt Clear-enable Register 3                      */
  __I  uint32_t  RESERVED4[28];
  __IO uint32_t  NVIC_ISPR0;                        /*!< (@ 0xE000E200) Interrupt Set-pending Register 0                       */
  __IO uint32_t  NVIC_ISPR1;                        /*!< (@ 0xE000E204) Interrupt Set-pending Register 1                       */
  __IO uint32_t  NVIC_ISPR2;                        /*!< (@ 0xE000E208) Interrupt Set-pending Register 2                       */
  __IO uint32_t  NVIC_ISPR3;                        /*!< (@ 0xE000E20C) Interrupt Set-pending Register 3                       */
  __I  uint32_t  RESERVED5[28];
  __IO uint32_t  NVIC_ICPR0;                        /*!< (@ 0xE000E280) Interrupt Clear-pending Register 0                     */
  __IO uint32_t  NVIC_ICPR1;                        /*!< (@ 0xE000E284) Interrupt Clear-pending Register 1                     */
  __IO uint32_t  NVIC_ICPR2;                        /*!< (@ 0xE000E288) Interrupt Clear-pending Register 2                     */
  __IO uint32_t  NVIC_ICPR3;                        /*!< (@ 0xE000E28C) Interrupt Clear-pending Register 3                     */
  __I  uint32_t  RESERVED6[28];
  __IO uint32_t  NVIC_IABR0;                        /*!< (@ 0xE000E300) Interrupt Active Bit Register 0                        */
  __IO uint32_t  NVIC_IABR1;                        /*!< (@ 0xE000E304) Interrupt Active Bit Register 1                        */
  __IO uint32_t  NVIC_IABR2;                        /*!< (@ 0xE000E308) Interrupt Active Bit Register 2                        */
  __IO uint32_t  NVIC_IABR3;                        /*!< (@ 0xE000E30C) Interrupt Active Bit Register 3                        */
  __I  uint32_t  RESERVED7[60];
  __IO uint32_t  NVIC_IPR0;                         /*!< (@ 0xE000E400) Interrupt Priority Register 0                          */
  __IO uint32_t  NVIC_IPR1;                         /*!< (@ 0xE000E404) Interrupt Priority Register 1                          */
  __IO uint32_t  NVIC_IPR2;                         /*!< (@ 0xE000E408) Interrupt Priority Register 2                          */
  __IO uint32_t  NVIC_IPR3;                         /*!< (@ 0xE000E40C) Interrupt Priority Register 3                          */
  __IO uint32_t  NVIC_IPR4;                         /*!< (@ 0xE000E410) Interrupt Priority Register 4                          */
  __IO uint32_t  NVIC_IPR5;                         /*!< (@ 0xE000E414) Interrupt Priority Register 5                          */
  __IO uint32_t  NVIC_IPR6;                         /*!< (@ 0xE000E418) Interrupt Priority Register 6                          */
  __IO uint32_t  NVIC_IPR7;                         /*!< (@ 0xE000E41C) Interrupt Priority Register 7                          */
  __IO uint32_t  NVIC_IPR8;                         /*!< (@ 0xE000E420) Interrupt Priority Register 8                          */
  __IO uint32_t  NVIC_IPR9;                         /*!< (@ 0xE000E424) Interrupt Priority Register 9                          */
  __IO uint32_t  NVIC_IPR10;                        /*!< (@ 0xE000E428) Interrupt Priority Register 10                         */
  __IO uint32_t  NVIC_IPR11;                        /*!< (@ 0xE000E42C) Interrupt Priority Register 11                         */
  __IO uint32_t  NVIC_IPR12;                        /*!< (@ 0xE000E430) Interrupt Priority Register 12                         */
  __IO uint32_t  NVIC_IPR13;                        /*!< (@ 0xE000E434) Interrupt Priority Register 13                         */
  __IO uint32_t  NVIC_IPR14;                        /*!< (@ 0xE000E438) Interrupt Priority Register 14                         */
  __IO uint32_t  NVIC_IPR15;                        /*!< (@ 0xE000E43C) Interrupt Priority Register 15                         */
  __IO uint32_t  NVIC_IPR16;                        /*!< (@ 0xE000E440) Interrupt Priority Register 16                         */
  __IO uint32_t  NVIC_IPR17;                        /*!< (@ 0xE000E444) Interrupt Priority Register 17                         */
  __IO uint32_t  NVIC_IPR18;                        /*!< (@ 0xE000E448) Interrupt Priority Register 18                         */
  __IO uint32_t  NVIC_IPR19;                        /*!< (@ 0xE000E44C) Interrupt Priority Register 19                         */
  __IO uint32_t  NVIC_IPR20;                        /*!< (@ 0xE000E450) Interrupt Priority Register 20                         */
  __IO uint32_t  NVIC_IPR21;                        /*!< (@ 0xE000E454) Interrupt Priority Register 21                         */
  __IO uint32_t  NVIC_IPR22;                        /*!< (@ 0xE000E458) Interrupt Priority Register 22                         */
  __IO uint32_t  NVIC_IPR23;                        /*!< (@ 0xE000E45C) Interrupt Priority Register 23                         */
  __IO uint32_t  NVIC_IPR24;                        /*!< (@ 0xE000E460) Interrupt Priority Register 24                         */
  __IO uint32_t  NVIC_IPR25;                        /*!< (@ 0xE000E464) Interrupt Priority Register 25                         */
  __IO uint32_t  NVIC_IPR26;                        /*!< (@ 0xE000E468) Interrupt Priority Register 26                         */
  __IO uint32_t  NVIC_IPR27;                        /*!< (@ 0xE000E46C) Interrupt Priority Register 27                         */
  __I  uint32_t  RESERVED8[548];
  __I  uint32_t  CPUID;                             /*!< (@ 0xE000ED00) CPUID Base Register                                    */
  __IO uint32_t  ICSR;                              /*!< (@ 0xE000ED04) Interrupt Control and State Register                   */
  __IO uint32_t  VTOR;                              /*!< (@ 0xE000ED08) Vector Table Offset Register                           */
  __IO uint32_t  AIRCR;                             /*!< (@ 0xE000ED0C) Application Interrupt and Reset Control Register       */
  __IO uint32_t  SCR;                               /*!< (@ 0xE000ED10) System Control Register                                */
  __IO uint32_t  CCR;                               /*!< (@ 0xE000ED14) Configuration and Control Register                     */
  __IO uint32_t  SHPR1;                             /*!< (@ 0xE000ED18) System Handler Priority Register 1                     */
  __IO uint32_t  SHPR2;                             /*!< (@ 0xE000ED1C) System Handler Priority Register 2                     */
  __IO uint32_t  SHPR3;                             /*!< (@ 0xE000ED20) System Handler Priority Register 3                     */
  __IO uint32_t  SHCSR;                             /*!< (@ 0xE000ED24) System Handler Control and State Register              */
  __IO uint32_t  CFSR;                              /*!< (@ 0xE000ED28) Configurable Fault Status Register                     */
  __IO uint32_t  HFSR;                              /*!< (@ 0xE000ED2C) HardFault Status Register                              */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MMFAR;                             /*!< (@ 0xE000ED34) MemManage Fault Address Register                       */
  __IO uint32_t  BFAR;                              /*!< (@ 0xE000ED38) BusFault Address Register                              */
  __IO uint32_t  AFSR;                              /*!< (@ 0xE000ED3C) Auxiliary Fault Status Register                        */
  __I  uint32_t  RESERVED10[18];
  __IO uint32_t  CPACR;                             /*!< (@ 0xE000ED88) Coprocessor Access Control Register                    */
  __I  uint32_t  RESERVED11;
  __I  uint32_t  MPU_TYPE;                          /*!< (@ 0xE000ED90) MPU Type Register                                      */
  __IO uint32_t  MPU_CTRL;                          /*!< (@ 0xE000ED94) MPU Control Register                                   */
  __IO uint32_t  MPU_RNR;                           /*!< (@ 0xE000ED98) MPU Region Number Register                             */
  __IO uint32_t  MPU_RBAR;                          /*!< (@ 0xE000ED9C) MPU Region Base Address Register                       */
  __IO uint32_t  MPU_RASR;                          /*!< (@ 0xE000EDA0) MPU Region Attribute and Size Register                 */
  __IO uint32_t  MPU_RBAR_A1;                       /*!< (@ 0xE000EDA4) MPU Region Base Address Register A1                    */
  __IO uint32_t  MPU_RASR_A1;                       /*!< (@ 0xE000EDA8) MPU Region Attribute and Size Register A1              */
  __IO uint32_t  MPU_RBAR_A2;                       /*!< (@ 0xE000EDAC) MPU Region Base Address Register A2                    */
  __IO uint32_t  MPU_RASR_A2;                       /*!< (@ 0xE000EDB0) MPU Region Attribute and Size Register A2              */
  __IO uint32_t  MPU_RBAR_A3;                       /*!< (@ 0xE000EDB4) MPU Region Base Address Register A3                    */
  __IO uint32_t  MPU_RASR_A3;                       /*!< (@ 0xE000EDB8) MPU Region Attribute and Size Register A3              */
  __I  uint32_t  RESERVED12[81];
  __O  uint32_t  STIR;                              /*!< (@ 0xE000EF00) Software Trigger Interrupt Register                    */
  __I  uint32_t  RESERVED13[12];
  __IO uint32_t  FPCCR;                             /*!< (@ 0xE000EF34) Floating-point Context Control Register                */
  __IO uint32_t  FPCAR;                             /*!< (@ 0xE000EF38) Floating-point Context Address Register                */
  __IO uint32_t  FPDSCR;                            /*!< (@ 0xE000EF3C) Floating-point Default Status Control Register         */
} PPB_Type;


/* ================================================================================ */
/* ================                       DLR                      ================ */
/* ================================================================================ */


/**
  * @brief DMA Line Router (DLR)
  */

typedef struct {                                    /*!< (@ 0x50004900) DLR Structure                                          */
  __I  uint32_t  OVRSTAT;                           /*!< (@ 0x50004900) Overrun Status                                         */
  __O  uint32_t  OVRCLR;                            /*!< (@ 0x50004904) Overrun Clear                                          */
  __IO uint32_t  SRSEL0;                            /*!< (@ 0x50004908) Service Request Selection 0                            */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  LNEN;                              /*!< (@ 0x50004910) Line Enable                                            */
} DLR_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   ERU [ERU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Event Request Unit 0 (ERU)
  */

typedef struct {                                    /*!< (@ 0x50004800) ERU Structure                                          */
  __IO uint32_t  EXISEL;                            /*!< (@ 0x50004800) Event Input Select                                     */
  __I  uint32_t  RESERVED0[3];
  __IO uint32_t  EXICON[4];                         /*!< (@ 0x50004810) Event Input Control                                    */
  __IO uint32_t  EXOCON[4];                         /*!< (@ 0x50004820) Event Output Trigger Control                           */
} ERU_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     GPDMA0                     ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0)
  */

typedef struct {                                    /*!< (@ 0x500142C0) GPDMA0 Structure                                       */
  __IO uint32_t  RAWTFR;                            /*!< (@ 0x500142C0) Raw IntTfr Status                                      */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  RAWBLOCK;                          /*!< (@ 0x500142C8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  RAWSRCTRAN;                        /*!< (@ 0x500142D0) Raw IntSrcTran Status                                  */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  RAWDSTTRAN;                        /*!< (@ 0x500142D8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  RAWERR;                            /*!< (@ 0x500142E0) Raw IntErr Status                                      */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  STATUSTFR;                         /*!< (@ 0x500142E8) IntTfr Status                                          */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  STATUSBLOCK;                       /*!< (@ 0x500142F0) IntBlock Status                                        */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  STATUSSRCTRAN;                     /*!< (@ 0x500142F8) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED7;
  __I  uint32_t  STATUSDSTTRAN;                     /*!< (@ 0x50014300) IntBlock Status                                        */
  __I  uint32_t  RESERVED8;
  __I  uint32_t  STATUSERR;                         /*!< (@ 0x50014308) IntErr Status                                          */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MASKTFR;                           /*!< (@ 0x50014310) Mask for Raw IntTfr Status                             */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  MASKBLOCK;                         /*!< (@ 0x50014318) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED11;
  __IO uint32_t  MASKSRCTRAN;                       /*!< (@ 0x50014320) Mask for Raw IntSrcTran Status                         */
  __I  uint32_t  RESERVED12;
  __IO uint32_t  MASKDSTTRAN;                       /*!< (@ 0x50014328) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED13;
  __IO uint32_t  MASKERR;                           /*!< (@ 0x50014330) Mask for Raw IntErr Status                             */
  __I  uint32_t  RESERVED14;
  __O  uint32_t  CLEARTFR;                          /*!< (@ 0x50014338) IntTfr Status                                          */
  __I  uint32_t  RESERVED15;
  __O  uint32_t  CLEARBLOCK;                        /*!< (@ 0x50014340) IntBlock Status                                        */
  __I  uint32_t  RESERVED16;
  __O  uint32_t  CLEARSRCTRAN;                      /*!< (@ 0x50014348) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED17;
  __O  uint32_t  CLEARDSTTRAN;                      /*!< (@ 0x50014350) IntBlock Status                                        */
  __I  uint32_t  RESERVED18;
  __O  uint32_t  CLEARERR;                          /*!< (@ 0x50014358) IntErr Status                                          */
  __I  uint32_t  RESERVED19;
  __I  uint32_t  STATUSINT;                         /*!< (@ 0x50014360) Combined Interrupt Status Register                     */
  __I  uint32_t  RESERVED20;
  __IO uint32_t  REQSRCREG;                         /*!< (@ 0x50014368) Source Software Transaction Request Register           */
  __I  uint32_t  RESERVED21;
  __IO uint32_t  REQDSTREG;                         /*!< (@ 0x50014370) Destination Software Transaction Request Register      */
  __I  uint32_t  RESERVED22;
  __IO uint32_t  SGLREQSRCREG;                      /*!< (@ 0x50014378) Single Source Transaction Request Register             */
  __I  uint32_t  RESERVED23;
  __IO uint32_t  SGLREQDSTREG;                      /*!< (@ 0x50014380) Single Destination Transaction Request Register        */
  __I  uint32_t  RESERVED24;
  __IO uint32_t  LSTSRCREG;                         /*!< (@ 0x50014388) Last Source Transaction Request Register               */
  __I  uint32_t  RESERVED25;
  __IO uint32_t  LSTDSTREG;                         /*!< (@ 0x50014390) Last Destination Transaction Request Register          */
  __I  uint32_t  RESERVED26;
  __IO uint32_t  DMACFGREG;                         /*!< (@ 0x50014398) GPDMA Configuration Register                           */
  __I  uint32_t  RESERVED27;
  __IO uint32_t  CHENREG;                           /*!< (@ 0x500143A0) GPDMA Channel Enable Register                          */
  __I  uint32_t  RESERVED28;
  __I  uint32_t  ID;                                /*!< (@ 0x500143A8) GPDMA0 ID Register                                     */
  __I  uint32_t  RESERVED29[19];
  __I  uint32_t  TYPE;                              /*!< (@ 0x500143F8) GPDMA Component Type                                   */
  __I  uint32_t  VERSION;                           /*!< (@ 0x500143FC) DMA Component Version                                  */
} GPDMA0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH0_1 [GPDMA0_CH0]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH0_1)
  */

typedef struct {                                    /*!< (@ 0x50014000) GPDMA0_CH0_1 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x50014000) Source Address Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DAR;                               /*!< (@ 0x50014008) Destination Address Register                           */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  LLP;                               /*!< (@ 0x50014010) Linked List Pointer Register                           */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  CTLL;                              /*!< (@ 0x50014018) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x5001401C) Control Register High                                  */
  __IO uint32_t  SSTAT;                             /*!< (@ 0x50014020) Source Status Register                                 */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DSTAT;                             /*!< (@ 0x50014028) Destination Status Register                            */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SSTATAR;                           /*!< (@ 0x50014030) Source Status Address Register                         */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  DSTATAR;                           /*!< (@ 0x50014038) Destination Status Address Register                    */
  __I  uint32_t  RESERVED6;
  __IO uint32_t  CFGL;                              /*!< (@ 0x50014040) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x50014044) Configuration Register High                            */
  __IO uint32_t  SGR;                               /*!< (@ 0x50014048) Source Gather Register                                 */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DSR;                               /*!< (@ 0x50014050) Destination Scatter Register                           */
} GPDMA0_CH_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH2_7 [GPDMA0_CH2]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH2_7)
  */

typedef struct {                                    /*!< (@ 0x500140B0) GPDMA0_CH2_7 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x500140B0) Source Address Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DAR;                               /*!< (@ 0x500140B8) Destination Address Register                           */
  __I  uint32_t  RESERVED1[3];
  __IO uint32_t  CTLL;                              /*!< (@ 0x500140C8) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x500140CC) Control Register High                                  */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  CFGL;                              /*!< (@ 0x500140F0) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x500140F4) Configuration Register High                            */
} GPDMA0_CH2_7_Type;


/* ================================================================================ */
/* ================                       FCE                      ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE)
  */

typedef struct {                                    /*!< (@ 0x50020000) FCE Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x50020000) Clock Control Register                                 */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  ID;                                /*!< (@ 0x50020008) Module Identification Register                         */
} FCE_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                FCE_KE [FCE_KE0]                ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE_KE)
  */

typedef struct {                                    /*!< (@ 0x50020020) FCE_KE Structure                                       */
  __IO uint32_t  IR;                                /*!< (@ 0x50020020) Input Register                                         */
  __I  uint32_t  RES;                               /*!< (@ 0x50020024) CRC Result Register                                    */
  __IO uint32_t  CFG;                               /*!< (@ 0x50020028) CRC Configuration Register                             */
  __IO uint32_t  STS;                               /*!< (@ 0x5002002C) CRC Status Register                                    */
  __IO uint32_t  LENGTH;                            /*!< (@ 0x50020030) CRC Length Register                                    */
  __IO uint32_t  CHECK;                             /*!< (@ 0x50020034) CRC Check Register                                     */
  __IO uint32_t  CRC;                               /*!< (@ 0x50020038) CRC Register                                           */
  __IO uint32_t  CTR;                               /*!< (@ 0x5002003C) CRC Test Register                                      */
} FCE_KE_TypeDef;


/* ================================================================================ */
/* ================                   PBA [PBA0]                   ================ */
/* ================================================================================ */


/**
  * @brief Peripheral Bridge AHB 0 (PBA)
  */

typedef struct {                                    /*!< (@ 0x40000000) PBA Structure                                          */
  __IO uint32_t  STS;                               /*!< (@ 0x40000000) Peripheral Bridge Status Register                      */
  __I  uint32_t  WADDR;                             /*!< (@ 0x40000004) PBA Write Error Address Register                       */
} PBA_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                 FLASH [FLASH0]                 ================ */
/* ================================================================================ */


/**
  * @brief Flash Memory Controller (FLASH)
  */

typedef struct {                                    /*!< (@ 0x58001000) FLASH Structure                                        */
  __I  uint32_t  RESERVED0[1026];
  __I  uint32_t  ID;                                /*!< (@ 0x58002008) Flash Module Identification Register                   */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  FSR;                               /*!< (@ 0x58002010) Flash Status Register                                  */
  __IO uint32_t  FCON;                              /*!< (@ 0x58002014) Flash Configuration Register                           */
  __IO uint32_t  MARP;                              /*!< (@ 0x58002018) Margin Control Register PFLASH                         */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  PROCON0;                           /*!< (@ 0x58002020) Flash Protection Configuration Register User
                                                         0                                                                     */
  __I  uint32_t  PROCON1;                           /*!< (@ 0x58002024) Flash Protection Configuration Register User
                                                         1                                                                     */
  __I  uint32_t  PROCON2;                           /*!< (@ 0x58002028) Flash Protection Configuration Register User
                                                         2                                                                     */
} FLASH0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PREF                      ================ */
/* ================================================================================ */


/**
  * @brief Prefetch Unit (PREF)
  */

typedef struct {                                    /*!< (@ 0x58004000) PREF Structure                                         */
  __IO uint32_t  PCON;                              /*!< (@ 0x58004000) Prefetch Configuration Register                        */
} PREF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   PMU [PMU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Program Management Unit (PMU)
  */

typedef struct {                                    /*!< (@ 0x58000508) PMU Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x58000508) PMU0 Identification Register                           */
} PMU0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       WDT                      ================ */
/* ================================================================================ */


/**
  * @brief Watch Dog Timer (WDT)
  */

typedef struct {                                    /*!< (@ 0x50008000) WDT Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50008000) WDT ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50008004) WDT Control Register                                   */
  __O  uint32_t  SRV;                               /*!< (@ 0x50008008) WDT Service Register                                   */
  __I  uint32_t  TIM;                               /*!< (@ 0x5000800C) WDT Timer Register                                     */
  __IO uint32_t  WLB;                               /*!< (@ 0x50008010) WDT Window Lower Bound Register                        */
  __IO uint32_t  WUB;                               /*!< (@ 0x50008014) WDT Window Upper Bound Register                        */
  __I  uint32_t  WDTSTS;                            /*!< (@ 0x50008018) WDT Status Register                                    */
  __O  uint32_t  WDTCLR;                            /*!< (@ 0x5000801C) WDT Clear Register                                     */
} WDT_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       RTC                      ================ */
/* ================================================================================ */


/**
  * @brief Real Time Clock (RTC)
  */

typedef struct {                                    /*!< (@ 0x50004A00) RTC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50004A00) RTC ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50004A04) RTC Control Register                                   */
  __I  uint32_t  RAWSTAT;                           /*!< (@ 0x50004A08) RTC Raw Service Request Register                       */
  __I  uint32_t  STSSR;                             /*!< (@ 0x50004A0C) RTC Service Request Status Register                    */
  __IO uint32_t  MSKSR;                             /*!< (@ 0x50004A10) RTC Service Request Mask Register                      */
  __O  uint32_t  CLRSR;                             /*!< (@ 0x50004A14) RTC Clear Service Request Register                     */
  __IO uint32_t  ATIM0;                             /*!< (@ 0x50004A18) RTC Alarm Time Register 0                              */
  __IO uint32_t  ATIM1;                             /*!< (@ 0x50004A1C) RTC Alarm Time Register 1                              */
  __IO uint32_t  TIM0;                              /*!< (@ 0x50004A20) RTC Time Register 0                                    */
  __IO uint32_t  TIM1;                              /*!< (@ 0x50004A24) RTC Time Register 1                                    */
} RTC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     SCU_CLK                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_CLK)
  */

typedef struct {                                    /*!< (@ 0x50004600) SCU_CLK Structure                                      */
  __I  uint32_t  CLKSTAT;                           /*!< (@ 0x50004600) Clock Status Register                                  */
  __O  uint32_t  CLKSET;                            /*!< (@ 0x50004604) CLK Set Register                                       */
  __O  uint32_t  CLKCLR;                            /*!< (@ 0x50004608) CLK Clear Register                                     */
  __IO uint32_t  SYSCLKCR;                          /*!< (@ 0x5000460C) System Clock Control Register                          */
  __IO uint32_t  CPUCLKCR;                          /*!< (@ 0x50004610) CPU Clock Control Register                             */
  __IO uint32_t  PBCLKCR;                           /*!< (@ 0x50004614) Peripheral Bus Clock Control Register                  */
  __IO uint32_t  USBCLKCR;                          /*!< (@ 0x50004618) USB Clock Control Register                             */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  CCUCLKCR;                          /*!< (@ 0x50004620) CCU Clock Control Register                             */
  __IO uint32_t  WDTCLKCR;                          /*!< (@ 0x50004624) WDT Clock Control Register                             */
  __IO uint32_t  EXTCLKCR;                          /*!< (@ 0x50004628) External Clock Control                                 */
  __IO uint32_t  MLINKCLKCR;                        /*!< (@ 0x5000462C) Multi-Link Clock Control                               */
  __IO uint32_t  SLEEPCR;                           /*!< (@ 0x50004630) Sleep Control Register                                 */
  __IO uint32_t  DSLEEPCR;                          /*!< (@ 0x50004634) Deep Sleep Control Register                            */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  CGATSTAT0;                         /*!< (@ 0x50004640) Peripheral 0 Clock Gating Status                       */
  __O  uint32_t  CGATSET0;                          /*!< (@ 0x50004644) Peripheral 0 Clock Gating Set                          */
  __O  uint32_t  CGATCLR0;                          /*!< (@ 0x50004648) Peripheral 0 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT1;                         /*!< (@ 0x5000464C) Peripheral 1 Clock Gating Status                       */
  __O  uint32_t  CGATSET1;                          /*!< (@ 0x50004650) Peripheral 1 Clock Gating Set                          */
  __O  uint32_t  CGATCLR1;                          /*!< (@ 0x50004654) Peripheral 1 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT2;                         /*!< (@ 0x50004658) Peripheral 2 Clock Gating Status                       */
  __O  uint32_t  CGATSET2;                          /*!< (@ 0x5000465C) Peripheral 2 Clock Gating Set                          */
  __O  uint32_t  CGATCLR2;                          /*!< (@ 0x50004660) Peripheral 2 Clock Gating Clear                        */
} SCU_CLK_TypeDef;


/* ================================================================================ */
/* ================                     SCU_OSC                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_OSC)
  */

typedef struct {                                    /*!< (@ 0x50004700) SCU_OSC Structure                                      */
  __I  uint32_t  OSCHPSTAT;                         /*!< (@ 0x50004700) OSC_HP Status Register                                 */
  __IO uint32_t  OSCHPCTRL;                         /*!< (@ 0x50004704) OSC_HP Control Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  CLKCALCONST;                       /*!< (@ 0x5000470C) Clock Calibration Constant Register                    */
} SCU_OSC_TypeDef;


/* ================================================================================ */
/* ================                     SCU_PLL                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PLL)
  */

typedef struct {                                    /*!< (@ 0x50004710) SCU_PLL Structure                                      */
  __I  uint32_t  PLLSTAT;                           /*!< (@ 0x50004710) PLL Status Register                                    */
  __IO uint32_t  PLLCON0;                           /*!< (@ 0x50004714) PLL Configuration 0 Register                           */
  __IO uint32_t  PLLCON1;                           /*!< (@ 0x50004718) PLL Configuration 1 Register                           */
  __IO uint32_t  PLLCON2;                           /*!< (@ 0x5000471C) PLL Configuration 2 Register                           */
  __I  uint32_t  USBPLLSTAT;                        /*!< (@ 0x50004720) USB PLL Status Register                                */
  __IO uint32_t  USBPLLCON;                         /*!< (@ 0x50004724) USB PLL Configuration Register                         */
  __I  uint32_t  RESERVED0[4];
  __I  uint32_t  CLKMXSTAT;                         /*!< (@ 0x50004738) Clock Multiplexing Status Register                     */
} SCU_PLL_TypeDef;


/* ================================================================================ */
/* ================                   SCU_GENERAL                  ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_GENERAL)
  */

typedef struct {                                    /*!< (@ 0x50004000) SCU_GENERAL Structure                                  */
  __I  uint32_t  ID;                                /*!< (@ 0x50004000) SCU Module ID Register                                 */
  __I  uint32_t  IDCHIP;                            /*!< (@ 0x50004004) Chip ID Register                                       */
  __I  uint32_t  IDMANUF;                           /*!< (@ 0x50004008) Manufactory ID Register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  STCON;                             /*!< (@ 0x50004010) Startup Configuration Register                         */
  __I  uint32_t  RESERVED1[6];
  __IO uint32_t  GPR[2];                            /*!< (@ 0x5000402C) General Purpose Register 0                             */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  CCUCON;                            /*!< (@ 0x5000404C) CCU Control Register                                   */
  __I  uint32_t  RESERVED3[15];
  __IO uint32_t  DTSCON;                            /*!< (@ 0x5000408C) Die Temperature Sensor Control Register                */
  __I  uint32_t  DTSSTAT;                           /*!< (@ 0x50004090) Die Temperature Sensor Status Register                 */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  GORCEN[2];                         /*!< (@ 0x500040A0) Out of Range Comparator Enable Register 0              */
  __IO uint32_t  DTEMPLIM;                          /*!< (@ 0x500040A8) Die Temperature Sensor Limit Register                  */
  __I  uint32_t  DTEMPALARM;                        /*!< (@ 0x500040AC) Die Temperature Sensor Alarm Register                  */
  __I  uint32_t  RESERVED5[5];
  __I  uint32_t  MIRRSTS;                           /*!< (@ 0x500040C4) Mirror Write Status Register                           */
  __IO uint32_t  RMACR;                             /*!< (@ 0x500040C8) Retention Memory Access Control Register               */
  __IO uint32_t  RMDATA;                            /*!< (@ 0x500040CC) Retention Memory Access Data Register                  */
  __I  uint32_t  MIRRALLSTAT;                       /*!< (@ 0x500040D0) Mirror All Status                                      */
  __O  uint32_t  MIRRALLREQ;                        /*!< (@ 0x500040D4) Mirror All Request                                     */
} SCU_GENERAL_TypeDef;


/* ================================================================================ */
/* ================                  SCU_INTERRUPT                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_INTERRUPT)
  */

typedef struct {                                    /*!< (@ 0x50004074) SCU_INTERRUPT Structure                                */
  __I  uint32_t  SRSTAT;                            /*!< (@ 0x50004074) SCU Service Request Status                             */
  __I  uint32_t  SRRAW;                             /*!< (@ 0x50004078) SCU Raw Service Request Status                         */
  __IO uint32_t  SRMSK;                             /*!< (@ 0x5000407C) SCU Service Request Mask                               */
  __O  uint32_t  SRCLR;                             /*!< (@ 0x50004080) SCU Service Request Clear                              */
  __O  uint32_t  SRSET;                             /*!< (@ 0x50004084) SCU Service Request Set                                */
  __IO uint32_t  NMIREQEN;                          /*!< (@ 0x50004088) SCU Service Request Mask                               */
} SCU_INTERRUPT_TypeDef;


/* ================================================================================ */
/* ================                   SCU_PARITY                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PARITY)
  */

typedef struct {                                    /*!< (@ 0x5000413C) SCU_PARITY Structure                                   */
  __IO uint32_t  PEEN;                              /*!< (@ 0x5000413C) Parity Error Enable Register                           */
  __IO uint32_t  MCHKCON;                           /*!< (@ 0x50004140) Memory Checking Control Register                       */
  __IO uint32_t  PETE;                              /*!< (@ 0x50004144) Parity Error Trap Enable Register                      */
  __IO uint32_t  PERSTEN;                           /*!< (@ 0x50004148) Parity Error Reset Enable Register                     */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  PEFLAG;                            /*!< (@ 0x50004150) Parity Error Flag Register                             */
  __IO uint32_t  PMTPR;                             /*!< (@ 0x50004154) Parity Memory Test Pattern Register                    */
  __IO uint32_t  PMTSR;                             /*!< (@ 0x50004158) Parity Memory Test Select Register                     */
} SCU_PARITY_TypeDef;


/* ================================================================================ */
/* ================                    SCU_TRAP                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_TRAP)
  */

typedef struct {                                    /*!< (@ 0x50004160) SCU_TRAP Structure                                     */
  __I  uint32_t  TRAPSTAT;                          /*!< (@ 0x50004160) Trap Status Register                                   */
  __I  uint32_t  TRAPRAW;                           /*!< (@ 0x50004164) Trap Raw Status Register                               */
  __IO uint32_t  TRAPDIS;                           /*!< (@ 0x50004168) Trap Disable Register                                  */
  __O  uint32_t  TRAPCLR;                           /*!< (@ 0x5000416C) Trap Clear Register                                    */
  __O  uint32_t  TRAPSET;                           /*!< (@ 0x50004170) Trap Set Register                                      */
} SCU_TRAP_TypeDef;


/* ================================================================================ */
/* ================                  SCU_HIBERNATE                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_HIBERNATE)
  */

typedef struct {                                    /*!< (@ 0x50004300) SCU_HIBERNATE Structure                                */
  __I  uint32_t  HDSTAT;                            /*!< (@ 0x50004300) Hibernate Domain Status Register                       */
  __O  uint32_t  HDCLR;                             /*!< (@ 0x50004304) Hibernate Domain Status Clear Register                 */
  __O  uint32_t  HDSET;                             /*!< (@ 0x50004308) Hibernate Domain Status Set Register                   */
  __IO uint32_t  HDCR;                              /*!< (@ 0x5000430C) Hibernate Domain Control Register                      */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  OSCSICTRL;                         /*!< (@ 0x50004314) fOSI Control Register                                  */
  __I  uint32_t  OSCULSTAT;                         /*!< (@ 0x50004318) OSC_ULP Status Register                                */
  __IO uint32_t  OSCULCTRL;                         /*!< (@ 0x5000431C) OSC_ULP Control Register                               */
  __IO uint32_t  LPACCONF;                          /*!< (@ 0x50004320) Analog Wake-up Configuration Register                  */
  __IO uint32_t  LPACTH0;                           /*!< (@ 0x50004324) LPAC Threshold Register 0                              */
  __IO uint32_t  LPACTH1;                           /*!< (@ 0x50004328) LPAC Threshold Register 1                              */
  __I  uint32_t  LPACST;                            /*!< (@ 0x5000432C) Hibernate Analog Control State Register                */
  __O  uint32_t  LPACCLR;                           /*!< (@ 0x50004330) LPAC Control Clear Register                            */
  __O  uint32_t  LPACSET;                           /*!< (@ 0x50004334) LPAC Control Set Register                              */
  __I  uint32_t  HINTST;                            /*!< (@ 0x50004338) Hibernate Internal Control State Register              */
  __O  uint32_t  HINTCLR;                           /*!< (@ 0x5000433C) Hibernate Internal Control Clear Register              */
  __O  uint32_t  HINTSET;                           /*!< (@ 0x50004340) Hibernate Internal Control Set Register                */
} SCU_HIBERNATE_TypeDef;


/* ================================================================================ */
/* ================                    SCU_POWER                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_POWER)
  */

typedef struct {                                    /*!< (@ 0x50004200) SCU_POWER Structure                                    */
  __I  uint32_t  PWRSTAT;                           /*!< (@ 0x50004200) PCU Status Register                                    */
  __O  uint32_t  PWRSET;                            /*!< (@ 0x50004204) PCU Set Control Register                               */
  __O  uint32_t  PWRCLR;                            /*!< (@ 0x50004208) PCU Clear Control Register                             */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  EVRSTAT;                           /*!< (@ 0x50004210) EVR Status Register                                    */
  __I  uint32_t  EVRVADCSTAT;                       /*!< (@ 0x50004214) EVR VADC Status Register                               */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  PWRMON;                            /*!< (@ 0x5000422C) Power Monitor Control                                  */
} SCU_POWER_TypeDef;


/* ================================================================================ */
/* ================                    SCU_RESET                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_RESET)
  */

typedef struct {                                    /*!< (@ 0x50004400) SCU_RESET Structure                                    */
  __I  uint32_t  RSTSTAT;                           /*!< (@ 0x50004400) RCU Reset Status                                       */
  __O  uint32_t  RSTSET;                            /*!< (@ 0x50004404) RCU Reset Set Register                                 */
  __O  uint32_t  RSTCLR;                            /*!< (@ 0x50004408) RCU Reset Clear Register                               */
  __I  uint32_t  PRSTAT0;                           /*!< (@ 0x5000440C) RCU Peripheral 0 Reset Status                          */
  __O  uint32_t  PRSET0;                            /*!< (@ 0x50004410) RCU Peripheral 0 Reset Set                             */
  __O  uint32_t  PRCLR0;                            /*!< (@ 0x50004414) RCU Peripheral 0 Reset Clear                           */
  __I  uint32_t  PRSTAT1;                           /*!< (@ 0x50004418) RCU Peripheral 1 Reset Status                          */
  __O  uint32_t  PRSET1;                            /*!< (@ 0x5000441C) RCU Peripheral 1 Reset Set                             */
  __O  uint32_t  PRCLR1;                            /*!< (@ 0x50004420) RCU Peripheral 1 Reset Clear                           */
  __I  uint32_t  PRSTAT2;                           /*!< (@ 0x50004424) RCU Peripheral 2 Reset Status                          */
  __O  uint32_t  PRSET2;                            /*!< (@ 0x50004428) RCU Peripheral 2 Reset Set                             */
  __O  uint32_t  PRCLR2;                            /*!< (@ 0x5000442C) RCU Peripheral 2 Reset Clear                           */
} SCU_RESET_TypeDef;


/* ================================================================================ */
/* ================                 LEDTS [LEDTS0]                 ================ */
/* ================================================================================ */


/**
  * @brief LED and Touch Sense Unit 0 (LEDTS)
  */

typedef struct {                                    /*!< (@ 0x48010000) LEDTS Structure                                        */
  __I  uint32_t  ID;                                /*!< (@ 0x48010000) Module Identification Register                         */
  __IO uint32_t  GLOBCTL;                           /*!< (@ 0x48010004) Global Control Register                                */
  __IO uint32_t  FNCTL;                             /*!< (@ 0x48010008) Function Control Register                              */
  __O  uint32_t  EVFR;                              /*!< (@ 0x4801000C) Event Flag Register                                    */
  __IO uint32_t  TSVAL;                             /*!< (@ 0x48010010) Touch-sense TS-Counter Value                           */
  __IO uint32_t  LINE0;                             /*!< (@ 0x48010014) Line Pattern Register 0                                */
  __IO uint32_t  LINE1;                             /*!< (@ 0x48010018) Line Pattern Register 1                                */
  __IO uint32_t  LDCMP0;                            /*!< (@ 0x4801001C) LED Compare Register 0                                 */
  __IO uint32_t  LDCMP1;                            /*!< (@ 0x48010020) LED Compare Register 1                                 */
  __IO uint32_t  TSCMP0;                            /*!< (@ 0x48010024) Touch-sense Compare Register 0                         */
  __IO uint32_t  TSCMP1;                            /*!< (@ 0x48010028) Touch-sense Compare Register 1                         */
} LEDTS0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    ETH0_CON                    ================ */
/* ================================================================================ */


/**
  * @brief Ethernet Control Register (ETH0_CON)
  */

typedef struct {                                    /*!< (@ 0x50004040) ETH0_CON Structure                                     */
  __IO uint32_t  CON;                          /*!< (@ 0x50004040) Ethernet 0 Port Control Register                       */
} ETH0_CON_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   ETH [ETH0]                   ================ */
/* ================================================================================ */


/**
  * @brief Ethernet Unit 0 (ETH)
  */

typedef struct {                                    /*!< (@ 0x5000C000) ETH Structure                                          */
  __IO uint32_t  MAC_CONFIGURATION;                 /*!< (@ 0x5000C000) MAC Configuration Register                             */
  __IO uint32_t  MAC_FRAME_FILTER;                  /*!< (@ 0x5000C004) MAC Frame Filter                                       */
  __IO uint32_t  HASH_TABLE_HIGH;                   /*!< (@ 0x5000C008) Hash Table High Register                               */
  __IO uint32_t  HASH_TABLE_LOW;                    /*!< (@ 0x5000C00C) Hash Table Low Register                                */
  __IO uint32_t  GMII_ADDRESS;                      /*!< (@ 0x5000C010) MII Address Register                                   */
  __IO uint32_t  GMII_DATA;                         /*!< (@ 0x5000C014) MII Data Register                                      */
  __IO uint32_t  FLOW_CONTROL;                      /*!< (@ 0x5000C018) Flow Control Register                                  */
  __IO uint32_t  VLAN_TAG;                          /*!< (@ 0x5000C01C) VLAN Tag Register                                      */
  __I  uint32_t  VERSION;                           /*!< (@ 0x5000C020) Version Register                                       */
  __I  uint32_t  DEBUG;                             /*!< (@ 0x5000C024) Debug Register                                         */
  __IO uint32_t  REMOTE_WAKE_UP_FRAME_FILTER;       /*!< (@ 0x5000C028) Remote Wake Up Frame Filter Register                   */
  __IO uint32_t  PMT_CONTROL_STATUS;                /*!< (@ 0x5000C02C) PMT Control and Status Register                        */
  __I  uint32_t  RESERVED0[2];
  __I  uint32_t  INTERRUPT_STATUS;                  /*!< (@ 0x5000C038) Interrupt Register                                     */
  __IO uint32_t  INTERRUPT_MASK;                    /*!< (@ 0x5000C03C) Interrupt Mask Register                                */
  __IO uint32_t  MAC_ADDRESS0_HIGH;                 /*!< (@ 0x5000C040) MAC Address0 High Register                             */
  __IO uint32_t  MAC_ADDRESS0_LOW;                  /*!< (@ 0x5000C044) MAC Address0 Low Register                              */
  __IO uint32_t  MAC_ADDRESS1_HIGH;                 /*!< (@ 0x5000C048) MAC Address1 High Register                             */
  __IO uint32_t  MAC_ADDRESS1_LOW;                  /*!< (@ 0x5000C04C) MAC Address1 Low Register                              */
  __IO uint32_t  MAC_ADDRESS2_HIGH;                 /*!< (@ 0x5000C050) MAC Address2 High Register                             */
  __IO uint32_t  MAC_ADDRESS2_LOW;                  /*!< (@ 0x5000C054) MAC Address2 Low Register                              */
  __IO uint32_t  MAC_ADDRESS3_HIGH;                 /*!< (@ 0x5000C058) MAC Address3 High Register                             */
  __IO uint32_t  MAC_ADDRESS3_LOW;                  /*!< (@ 0x5000C05C) MAC Address3 Low Register                              */
  __I  uint32_t  RESERVED1[40];
  __IO uint32_t  MMC_CONTROL;                       /*!< (@ 0x5000C100) MMC Control Register                                   */
  __I  uint32_t  MMC_RECEIVE_INTERRUPT;             /*!< (@ 0x5000C104) MMC Receive Interrupt Register                         */
  __I  uint32_t  MMC_TRANSMIT_INTERRUPT;            /*!< (@ 0x5000C108) MMC Transmit Interrupt Register                        */
  __IO uint32_t  MMC_RECEIVE_INTERRUPT_MASK;        /*!< (@ 0x5000C10C) MMC Reveive Interrupt Mask Register                    */
  __IO uint32_t  MMC_TRANSMIT_INTERRUPT_MASK;       /*!< (@ 0x5000C110) MMC Transmit Interrupt Mask Register                   */
  __I  uint32_t  TX_OCTET_COUNT_GOOD_BAD;           /*!< (@ 0x5000C114) Transmit Octet Count for Good and Bad Frames
                                                         Register                                                              */
  __I  uint32_t  TX_FRAME_COUNT_GOOD_BAD;           /*!< (@ 0x5000C118) Transmit Frame Count for Goodand Bad Frames Register   */
  __I  uint32_t  TX_BROADCAST_FRAMES_GOOD;          /*!< (@ 0x5000C11C) Transmit Frame Count for Good Broadcast Frames         */
  __I  uint32_t  TX_MULTICAST_FRAMES_GOOD;          /*!< (@ 0x5000C120) Transmit Frame Count for Good Multicast Frames         */
  __I  uint32_t  TX_64OCTETS_FRAMES_GOOD_BAD;       /*!< (@ 0x5000C124) Transmit Octet Count for Good and Bad 64 Byte
                                                         Frames                                                                */
  __I  uint32_t  TX_65TO127OCTETS_FRAMES_GOOD_BAD;  /*!< (@ 0x5000C128) Transmit Octet Count for Good and Bad 65 to 127
                                                         Bytes Frames                                                          */
  __I  uint32_t  TX_128TO255OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C12C) Transmit Octet Count for Good and Bad 128 to
                                                         255 Bytes Frames                                                      */
  __I  uint32_t  TX_256TO511OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C130) Transmit Octet Count for Good and Bad 256 to
                                                         511 Bytes Frames                                                      */
  __I  uint32_t  TX_512TO1023OCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C134) Transmit Octet Count for Good and Bad 512 to
                                                         1023 Bytes Frames                                                     */
  __I  uint32_t  TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C138) Transmit Octet Count for Good and Bad 1024 to
                                                         Maxsize Bytes Frames                                                  */
  __I  uint32_t  TX_UNICAST_FRAMES_GOOD_BAD;        /*!< (@ 0x5000C13C) Transmit Frame Count for Good and Bad Unicast
                                                         Frames                                                                */
  __I  uint32_t  TX_MULTICAST_FRAMES_GOOD_BAD;      /*!< (@ 0x5000C140) Transmit Frame Count for Good and Bad Multicast
                                                         Frames                                                                */
  __I  uint32_t  TX_BROADCAST_FRAMES_GOOD_BAD;      /*!< (@ 0x5000C144) Transmit Frame Count for Good and Bad Broadcast
                                                         Frames                                                                */
  __I  uint32_t  TX_UNDERFLOW_ERROR_FRAMES;         /*!< (@ 0x5000C148) Transmit Frame Count for Underflow Error Frames        */
  __I  uint32_t  TX_SINGLE_COLLISION_GOOD_FRAMES;   /*!< (@ 0x5000C14C) Transmit Frame Count for Frames Transmitted after
                                                         Single Collision                                                      */
  __I  uint32_t  TX_MULTIPLE_COLLISION_GOOD_FRAMES; /*!< (@ 0x5000C150) Transmit Frame Count for Frames Transmitted after
                                                         Multiple Collision                                                    */
  __I  uint32_t  TX_DEFERRED_FRAMES;                /*!< (@ 0x5000C154) Tx Deferred Frames Register                            */
  __I  uint32_t  TX_LATE_COLLISION_FRAMES;          /*!< (@ 0x5000C158) Transmit Frame Count for Late Collision Error
                                                         Frames                                                                */
  __I  uint32_t  TX_EXCESSIVE_COLLISION_FRAMES;     /*!< (@ 0x5000C15C) Transmit Frame Count for Excessive Collision
                                                         Error Frames                                                          */
  __I  uint32_t  TX_CARRIER_ERROR_FRAMES;           /*!< (@ 0x5000C160) Transmit Frame Count for Carrier Sense Error
                                                         Frames                                                                */
  __I  uint32_t  TX_OCTET_COUNT_GOOD;               /*!< (@ 0x5000C164) Tx Octet Count Good Register                           */
  __I  uint32_t  TX_FRAME_COUNT_GOOD;               /*!< (@ 0x5000C168) Tx Frame Count Good Register                           */
  __I  uint32_t  TX_EXCESSIVE_DEFERRAL_ERROR;       /*!< (@ 0x5000C16C) Transmit Frame Count for Excessive Deferral Error
                                                         Frames                                                                */
  __I  uint32_t  TX_PAUSE_FRAMES;                   /*!< (@ 0x5000C170) Transmit Frame Count for Good PAUSE Frames             */
  __I  uint32_t  TX_VLAN_FRAMES_GOOD;               /*!< (@ 0x5000C174) Transmit Frame Count for Good VLAN Frames              */
  __I  uint32_t  TX_OSIZE_FRAMES_GOOD;              /*!< (@ 0x5000C178) Transmit Frame Count for Good Oversize Frames          */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  RX_FRAMES_COUNT_GOOD_BAD;          /*!< (@ 0x5000C180) Receive Frame Count for Good and Bad Frames            */
  __I  uint32_t  RX_OCTET_COUNT_GOOD_BAD;           /*!< (@ 0x5000C184) Receive Octet Count for Good and Bad Frames            */
  __I  uint32_t  RX_OCTET_COUNT_GOOD;               /*!< (@ 0x5000C188) Rx Octet Count Good Register                           */
  __I  uint32_t  RX_BROADCAST_FRAMES_GOOD;          /*!< (@ 0x5000C18C) Receive Frame Count for Good Broadcast Frames          */
  __I  uint32_t  RX_MULTICAST_FRAMES_GOOD;          /*!< (@ 0x5000C190) Receive Frame Count for Good Multicast Frames          */
  __I  uint32_t  RX_CRC_ERROR_FRAMES;               /*!< (@ 0x5000C194) Receive Frame Count for CRC Error Frames               */
  __I  uint32_t  RX_ALIGNMENT_ERROR_FRAMES;         /*!< (@ 0x5000C198) Receive Frame Count for Alignment Error Frames         */
  __I  uint32_t  RX_RUNT_ERROR_FRAMES;              /*!< (@ 0x5000C19C) Receive Frame Count for Runt Error Frames              */
  __I  uint32_t  RX_JABBER_ERROR_FRAMES;            /*!< (@ 0x5000C1A0) Receive Frame Count for Jabber Error Frames            */
  __I  uint32_t  RX_UNDERSIZE_FRAMES_GOOD;          /*!< (@ 0x5000C1A4) Receive Frame Count for Undersize Frames               */
  __I  uint32_t  RX_OVERSIZE_FRAMES_GOOD;           /*!< (@ 0x5000C1A8) Rx Oversize Frames Good Register                       */
  __I  uint32_t  RX_64OCTETS_FRAMES_GOOD_BAD;       /*!< (@ 0x5000C1AC) Receive Frame Count for Good and Bad 64 Byte
                                                         Frames                                                                */
  __I  uint32_t  RX_65TO127OCTETS_FRAMES_GOOD_BAD;  /*!< (@ 0x5000C1B0) Receive Frame Count for Good and Bad 65 to 127
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_128TO255OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C1B4) Receive Frame Count for Good and Bad 128 to 255
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_256TO511OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C1B8) Receive Frame Count for Good and Bad 256 to 511
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_512TO1023OCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C1BC) Receive Frame Count for Good and Bad 512 to 1,023
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C1C0) Receive Frame Count for Good and Bad 1,024 to
                                                         Maxsize Bytes Frames                                                  */
  __I  uint32_t  RX_UNICAST_FRAMES_GOOD;            /*!< (@ 0x5000C1C4) Receive Frame Count for Good Unicast Frames            */
  __I  uint32_t  RX_LENGTH_ERROR_FRAMES;            /*!< (@ 0x5000C1C8) Receive Frame Count for Length Error Frames            */
  __I  uint32_t  RX_OUT_OF_RANGE_TYPE_FRAMES;       /*!< (@ 0x5000C1CC) Receive Frame Count for Out of Range Frames            */
  __I  uint32_t  RX_PAUSE_FRAMES;                   /*!< (@ 0x5000C1D0) Receive Frame Count for PAUSE Frames                   */
  __I  uint32_t  RX_FIFO_OVERFLOW_FRAMES;           /*!< (@ 0x5000C1D4) Receive Frame Count for FIFO Overflow Frames           */
  __I  uint32_t  RX_VLAN_FRAMES_GOOD_BAD;           /*!< (@ 0x5000C1D8) Receive Frame Count for Good and Bad VLAN Frames       */
  __I  uint32_t  RX_WATCHDOG_ERROR_FRAMES;          /*!< (@ 0x5000C1DC) Receive Frame Count for Watchdog Error Frames          */
  __I  uint32_t  RX_RECEIVE_ERROR_FRAMES;           /*!< (@ 0x5000C1E0) Receive Frame Count for Receive Error Frames           */
  __I  uint32_t  RX_CONTROL_FRAMES_GOOD;            /*!< (@ 0x5000C1E4) Receive Frame Count for Good Control Frames Frames     */
  __I  uint32_t  RESERVED3[6];
  __IO uint32_t  MMC_IPC_RECEIVE_INTERRUPT_MASK;    /*!< (@ 0x5000C200) MMC Receive Checksum Offload Interrupt Mask Register   */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  MMC_IPC_RECEIVE_INTERRUPT;         /*!< (@ 0x5000C208) MMC Receive Checksum Offload Interrupt Register        */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  RXIPV4_GOOD_FRAMES;                /*!< (@ 0x5000C210) RxIPv4 Good Frames Register                            */
  __I  uint32_t  RXIPV4_HEADER_ERROR_FRAMES;        /*!< (@ 0x5000C214) Receive IPV4 Header Error Frame Counter Register       */
  __I  uint32_t  RXIPV4_NO_PAYLOAD_FRAMES;          /*!< (@ 0x5000C218) Receive IPV4 No Payload Frame Counter Register         */
  __I  uint32_t  RXIPV4_FRAGMENTED_FRAMES;          /*!< (@ 0x5000C21C) Receive IPV4 Fragmented Frame Counter Register         */
  __I  uint32_t  RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES;/*!< (@ 0x5000C220) Receive IPV4 UDP Checksum Disabled Frame Counter
                                                         Register                                                              */
  __I  uint32_t  RXIPV6_GOOD_FRAMES;                /*!< (@ 0x5000C224) RxIPv6 Good Frames Register                            */
  __I  uint32_t  RXIPV6_HEADER_ERROR_FRAMES;        /*!< (@ 0x5000C228) Receive IPV6 Header Error Frame Counter Register       */
  __I  uint32_t  RXIPV6_NO_PAYLOAD_FRAMES;          /*!< (@ 0x5000C22C) Receive IPV6 No Payload Frame Counter Register         */
  __I  uint32_t  RXUDP_GOOD_FRAMES;                 /*!< (@ 0x5000C230) RxUDP Good Frames Register                             */
  __I  uint32_t  RXUDP_ERROR_FRAMES;                /*!< (@ 0x5000C234) RxUDP Error Frames Register                            */
  __I  uint32_t  RXTCP_GOOD_FRAMES;                 /*!< (@ 0x5000C238) RxTCP Good Frames Register                             */
  __I  uint32_t  RXTCP_ERROR_FRAMES;                /*!< (@ 0x5000C23C) RxTCP Error Frames Register                            */
  __I  uint32_t  RXICMP_GOOD_FRAMES;                /*!< (@ 0x5000C240) RxICMP Good Frames Register                            */
  __I  uint32_t  RXICMP_ERROR_FRAMES;               /*!< (@ 0x5000C244) RxICMP Error Frames Register                           */
  __I  uint32_t  RESERVED6[2];
  __I  uint32_t  RXIPV4_GOOD_OCTETS;                /*!< (@ 0x5000C250) RxIPv4 Good Octets Register                            */
  __I  uint32_t  RXIPV4_HEADER_ERROR_OCTETS;        /*!< (@ 0x5000C254) Receive IPV4 Header Error Octet Counter Register       */
  __I  uint32_t  RXIPV4_NO_PAYLOAD_OCTETS;          /*!< (@ 0x5000C258) Receive IPV4 No Payload Octet Counter Register         */
  __I  uint32_t  RXIPV4_FRAGMENTED_OCTETS;          /*!< (@ 0x5000C25C) Receive IPV4 Fragmented Octet Counter Register         */
  __I  uint32_t  RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS;/*!< (@ 0x5000C260) Receive IPV4 Fragmented Octet Counter Register         */
  __I  uint32_t  RXIPV6_GOOD_OCTETS;                /*!< (@ 0x5000C264) RxIPv6 Good Octets Register                            */
  __I  uint32_t  RXIPV6_HEADER_ERROR_OCTETS;        /*!< (@ 0x5000C268) Receive IPV6 Header Error Octet Counter Register       */
  __I  uint32_t  RXIPV6_NO_PAYLOAD_OCTETS;          /*!< (@ 0x5000C26C) Receive IPV6 No Payload Octet Counter Register         */
  __I  uint32_t  RXUDP_GOOD_OCTETS;                 /*!< (@ 0x5000C270) Receive UDP Good Octets Register                       */
  __I  uint32_t  RXUDP_ERROR_OCTETS;                /*!< (@ 0x5000C274) Receive UDP Error Octets Register                      */
  __I  uint32_t  RXTCP_GOOD_OCTETS;                 /*!< (@ 0x5000C278) Receive TCP Good Octets Register                       */
  __I  uint32_t  RXTCP_ERROR_OCTETS;                /*!< (@ 0x5000C27C) Receive TCP Error Octets Register                      */
  __I  uint32_t  RXICMP_GOOD_OCTETS;                /*!< (@ 0x5000C280) Receive ICMP Good Octets Register                      */
  __I  uint32_t  RXICMP_ERROR_OCTETS;               /*!< (@ 0x5000C284) Receive ICMP Error Octets Register                     */
  __I  uint32_t  RESERVED7[286];
  __IO uint32_t  TIMESTAMP_CONTROL;                 /*!< (@ 0x5000C700) Timestamp Control Register                             */
  __IO uint32_t  SUB_SECOND_INCREMENT;              /*!< (@ 0x5000C704) Sub-Second Increment Register                          */
  __I  uint32_t  SYSTEM_TIME_SECONDS;               /*!< (@ 0x5000C708) System Time - Seconds Register                         */
  __I  uint32_t  SYSTEM_TIME_NANOSECONDS;           /*!< (@ 0x5000C70C) System Time Nanoseconds Register                       */
  __IO uint32_t  SYSTEM_TIME_SECONDS_UPDATE;        /*!< (@ 0x5000C710) System Time - Seconds Update Register                  */
  __IO uint32_t  SYSTEM_TIME_NANOSECONDS_UPDATE;    /*!< (@ 0x5000C714) System Time Nanoseconds Update Register                */
  __IO uint32_t  TIMESTAMP_ADDEND;                  /*!< (@ 0x5000C718) Timestamp Addend Register                              */
  __IO uint32_t  TARGET_TIME_SECONDS;               /*!< (@ 0x5000C71C) Target Time Seconds Register                           */
  __IO uint32_t  TARGET_TIME_NANOSECONDS;           /*!< (@ 0x5000C720) Target Time Nanoseconds Register                       */
  __IO uint32_t  SYSTEM_TIME_HIGHER_WORD_SECONDS;   /*!< (@ 0x5000C724) System Time - Higher Word Seconds Register             */
  __I  uint32_t  TIMESTAMP_STATUS;                  /*!< (@ 0x5000C728) Timestamp Status Register                              */
  __IO uint32_t  PPS_CONTROL;                       /*!< (@ 0x5000C72C) PPS Control Register                                   */
  __I  uint32_t  RESERVED8[564];
  __IO uint32_t  BUS_MODE;                          /*!< (@ 0x5000D000) Bus Mode Register                                      */
  __IO uint32_t  TRANSMIT_POLL_DEMAND;              /*!< (@ 0x5000D004) Transmit Poll Demand Register                          */
  __IO uint32_t  RECEIVE_POLL_DEMAND;               /*!< (@ 0x5000D008) Receive Poll Demand Register                           */
  __IO uint32_t  RECEIVE_DESCRIPTOR_LIST_ADDRESS;   /*!< (@ 0x5000D00C) Receive Descriptor Address Register                    */
  __IO uint32_t  TRANSMIT_DESCRIPTOR_LIST_ADDRESS;  /*!< (@ 0x5000D010) Transmit descripter Address Register                   */
  __IO uint32_t  STATUS;                            /*!< (@ 0x5000D014) Status Register                                        */
  __IO uint32_t  OPERATION_MODE;                    /*!< (@ 0x5000D018) Operation Mode Register                                */
  __IO uint32_t  INTERRUPT_ENABLE;                  /*!< (@ 0x5000D01C) Interrupt Enable Register                              */
  __I  uint32_t  MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER;/*!< (@ 0x5000D020) Missed Frame and Buffer Overflow Counter Register */
  __IO uint32_t  RECEIVE_INTERRUPT_WATCHDOG_TIMER;  /*!< (@ 0x5000D024) Receive Interrupt Watchdog Timer Register              */
  __I  uint32_t  RESERVED9;
  __I  uint32_t  AHB_STATUS;                        /*!< (@ 0x5000D02C) AHB Status Register                                    */
  __I  uint32_t  RESERVED10[6];
  __I  uint32_t  CURRENT_HOST_TRANSMIT_DESCRIPTOR;  /*!< (@ 0x5000D048) Current Host Transmit Descriptor Register              */
  __I  uint32_t  CURRENT_HOST_RECEIVE_DESCRIPTOR;   /*!< (@ 0x5000D04C) Current Host Receive Descriptor Register               */
  __I  uint32_t  CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS;/*!< (@ 0x5000D050) Current Host Transmit Buffer Address Register        */
  __I  uint32_t  CURRENT_HOST_RECEIVE_BUFFER_ADDRESS;/*!< (@ 0x5000D054) Current Host Receive Buffer Address Register          */
  __IO uint32_t  HW_FEATURE;                        /*!< (@ 0x5000D058) HW Feature Register                                    */
} ETH_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   USB [USB0]                   ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB)
  */

typedef struct {                                    /*!< (@ 0x50040000) USB Structure                                          */
  __IO uint32_t  GOTGCTL;                           /*!< (@ 0x50040000) Control and Status Register                            */
  __IO uint32_t  GOTGINT;                           /*!< (@ 0x50040004) OTG Interrupt Register                                 */
  __IO uint32_t  GAHBCFG;                           /*!< (@ 0x50040008) AHB Configuration Register                             */
  __IO uint32_t  GUSBCFG;                           /*!< (@ 0x5004000C) USB Configuration Register                             */
  __IO uint32_t  GRSTCTL;                           /*!< (@ 0x50040010) Reset Register                                         */
  
  union {
    __IO uint32_t  GINTSTS_DEVICEMODE;              /*!< (@ 0x50040014) Interrupt Register [DEVICEMODE]                        */
    __IO uint32_t  GINTSTS_HOSTMODE;                /*!< (@ 0x50040014) Interrupt Register [HOSTMODE]                          */
  };
  
  union {
    __IO uint32_t  GINTMSK_DEVICEMODE;              /*!< (@ 0x50040018) Interrupt Mask Register [DEVICEMODE]                   */
    __IO uint32_t  GINTMSK_HOSTMODE;                /*!< (@ 0x50040018) Interrupt Mask Register [HOSTMODE]                     */
  };
  
  union {
    __I  uint32_t  GRXSTSR_DEVICEMODE;              /*!< (@ 0x5004001C) Receive Status Debug Read Register [DEVICEMODE]        */
    __I  uint32_t  GRXSTSR_HOSTMODE;                /*!< (@ 0x5004001C) Receive Status Debug Read Register [HOSTMODE]          */
  };
  
  union {
    __I  uint32_t  GRXSTSP_HOSTMODE;                /*!< (@ 0x50040020) Receive Status Read and Pop Register [HOSTMODE]        */
    __I  uint32_t  GRXSTSP_DEVICEMODE;              /*!< (@ 0x50040020) Receive Status Read and Pop Register [DEVICEMODE]      */
  };
  __IO uint32_t  GRXFSIZ;                           /*!< (@ 0x50040024) Receive FIFO Size Register                             */
  
  union {
    __IO uint32_t  GNPTXFSIZ_DEVICEMODE;            /*!< (@ 0x50040028) Non-Periodic Transmit FIFO Size Register [DEVICEMODE]  */
    __IO uint32_t  GNPTXFSIZ_HOSTMODE;              /*!< (@ 0x50040028) Non-Periodic Transmit FIFO Size Register [HOSTMODE]    */
  };
  __I  uint32_t  GNPTXSTS;                          /*!< (@ 0x5004002C) Non-Periodic Transmit FIFO/Queue Status Register       */
  __I  uint32_t  RESERVED0[3];
  __IO uint32_t  GUID;                              /*!< (@ 0x5004003C) USB Module Identification Register                     */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  GDFIFOCFG;                         /*!< (@ 0x5004005C) Global DFIFO Software Config Register                  */
  __I  uint32_t  RESERVED2[40];
  __IO uint32_t  HPTXFSIZ;                          /*!< (@ 0x50040100) Host Periodic Transmit FIFO Size Register              */
  __IO uint32_t  DIEPTXF1;                          /*!< (@ 0x50040104) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF2;                          /*!< (@ 0x50040108) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF3;                          /*!< (@ 0x5004010C) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF4;                          /*!< (@ 0x50040110) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF5;                          /*!< (@ 0x50040114) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF6;                          /*!< (@ 0x50040118) Device IN Endpoint Transmit FIFO Size Register         */
  __I  uint32_t  RESERVED3[185];
  __IO uint32_t  HCFG;                              /*!< (@ 0x50040400) Host Configuration Register                            */
  __IO uint32_t  HFIR;                              /*!< (@ 0x50040404) Host Frame Interval Register                           */
  __IO uint32_t  HFNUM;                             /*!< (@ 0x50040408) Host Frame Number/Frame Time Remaining Register        */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  HPTXSTS;                           /*!< (@ 0x50040410) Host Periodic Transmit FIFO/ Queue Status Register     */
  __I  uint32_t  HAINT;                             /*!< (@ 0x50040414) Host All Channels Interrupt Register                   */
  __IO uint32_t  HAINTMSK;                          /*!< (@ 0x50040418) Host All Channels Interrupt Mask Register              */
  __IO uint32_t  HFLBADDR;                          /*!< (@ 0x5004041C) Host Frame List Base Address Register                  */
  __I  uint32_t  RESERVED5[8];
  __IO uint32_t  HPRT;                              /*!< (@ 0x50040440) Host Port Control and Status Register                  */
  __I  uint32_t  RESERVED6[239];
  __IO uint32_t  DCFG;                              /*!< (@ 0x50040800) Device Configuration Register                          */
  __IO uint32_t  DCTL;                              /*!< (@ 0x50040804) Device Control Register                                */
  __I  uint32_t  DSTS;                              /*!< (@ 0x50040808) Device Status Register                                 */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DIEPMSK;                           /*!< (@ 0x50040810) Device IN Endpoint Common Interrupt Mask Register      */
  __IO uint32_t  DOEPMSK;                           /*!< (@ 0x50040814) Device OUT Endpoint Common Interrupt Mask Register     */
  __I  uint32_t  DAINT;                             /*!< (@ 0x50040818) Device All Endpoints Interrupt Register                */
  __IO uint32_t  DAINTMSK;                          /*!< (@ 0x5004081C) Device All Endpoints Interrupt Mask Register           */
  __I  uint32_t  RESERVED8[2];
  __IO uint32_t  DVBUSDIS;                          /*!< (@ 0x50040828) Device VBUS Discharge Time Register                    */
  __IO uint32_t  DVBUSPULSE;                        /*!< (@ 0x5004082C) Device VBUS Pulsing Time Register                      */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  DIEPEMPMSK;                        /*!< (@ 0x50040834) Device IN Endpoint FIFO Empty Interrupt Mask
                                                         Register                                                              */
  __I  uint32_t  RESERVED10[370];
  __IO uint32_t  PCGCCTL;                           /*!< (@ 0x50040E00) Power and Clock Gating Control Register                */
} USB0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    USB0_EP0                    ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB0_EP0)
  */

typedef struct {                                    /*!< (@ 0x50040900) USB0_EP0 Structure                                     */
  __IO uint32_t  DIEPCTL0;                          /*!< (@ 0x50040900) Device Control IN Endpoint Control Register            */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DIEPINT0;                          /*!< (@ 0x50040908) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ0;                         /*!< (@ 0x50040910) Device IN Endpoint Transfer Size Register              */
  __IO uint32_t  DIEPDMA0;                          /*!< (@ 0x50040914) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS0;                          /*!< (@ 0x50040918) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB0;                         /*!< (@ 0x5004091C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  __IO uint32_t  DOEPCTL0;                          /*!< (@ 0x50040B00) Device Control OUT Endpoint Control Register           */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT0;                          /*!< (@ 0x50040B08) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  DOEPTSIZ0;                         /*!< (@ 0x50040B10) Device OUT Endpoint Transfer Size Register             */
  __IO uint32_t  DOEPDMA0;                          /*!< (@ 0x50040B14) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB0;                         /*!< (@ 0x50040B1C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP0_TypeDef;


/* ================================================================================ */
/* ================                USB_EP [USB0_EP1]               ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB_EP)
  */

typedef struct {                                    /*!< (@ 0x50040920) USB_EP Structure                                       */
  
  union {
    __IO uint32_t  DIEPCTL_INTBULK;                 /*!< (@ 0x50040920) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DIEPCTL_ISOCONT;                 /*!< (@ 0x50040920) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DIEPINT;                           /*!< (@ 0x50040928) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ;                          /*!< (@ 0x50040930) Device Endpoint Transfer Size Register                 */
  __IO uint32_t  DIEPDMA;                           /*!< (@ 0x50040934) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS;                           /*!< (@ 0x50040938) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB;                          /*!< (@ 0x5004093C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  
  union {
    __IO uint32_t  DOEPCTL_INTBULK;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DOEPCTL_ISOCONT;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT;                           /*!< (@ 0x50040B28) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  
  union {
    __IO uint32_t  DOEPTSIZ_CONTROL;                /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [CONT]          */
    __IO uint32_t  DOEPTSIZ_ISO;                    /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [ISO]           */
  };
  __IO uint32_t  DOEPDMA;                           /*!< (@ 0x50040B34) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB;                          /*!< (@ 0x50040B3C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP_TypeDef;


/* ================================================================================ */
/* ================                USB_CH [USB0_CH0]               ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB_CH)
  */

typedef struct {                                    /*!< (@ 0x50040500) USB_CH Structure                                       */
  __IO uint32_t  HCCHAR;                            /*!< (@ 0x50040500) Host Channel Characteristics Register                  */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  HCINT;                             /*!< (@ 0x50040508) Host Channel Interrupt Register                        */
  __IO uint32_t  HCINTMSK;                          /*!< (@ 0x5004050C) Host Channel Interrupt Mask Register                   */
  
  union {
    __IO uint32_t  HCTSIZ_SCATGATHER;               /*!< (@ 0x50040510) Host Channel Transfer Size Register [SCATGATHER]       */
    __IO uint32_t  HCTSIZ_BUFFERMODE;               /*!< (@ 0x50040510) Host Channel Transfer Size Register [BUFFERMODE]       */
  };
  
  union {
    __IO uint32_t  HCDMA_SCATGATHER;                /*!< (@ 0x50040514) Host Channel DMA Address Register [SCATGATHER]         */
    __IO uint32_t  HCDMA_BUFFERMODE;                /*!< (@ 0x50040514) Host Channel DMA Address Register [BUFFERMODE]         */
  };
  __I  uint32_t  RESERVED1;
  __I  uint32_t  HCDMAB;                            /*!< (@ 0x5004051C) Host Channel DMA Buffer Address Register               */
} USB0_CH_TypeDef;


/* ================================================================================ */
/* ================                  USIC [USIC0]                  ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC)
  */

typedef struct {                                    /*!< (@ 0x40030008) USIC Structure                                         */
  __I  uint32_t  ID;                                /*!< (@ 0x40030008) Module Identification Register                         */
} USIC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================               USIC_CH [USIC0_CH0]              ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC_CH)
  */

typedef struct {                                    /*!< (@ 0x40030000) USIC_CH Structure                                      */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  CCFG;                              /*!< (@ 0x40030004) Channel Configuration Register                         */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  KSCFG;                             /*!< (@ 0x4003000C) Kernel State Configuration Register                    */
  __IO uint32_t  FDR;                               /*!< (@ 0x40030010) Fractional Divider Register                            */
  __IO uint32_t  BRG;                               /*!< (@ 0x40030014) Baud Rate Generator Register                           */
  __IO uint32_t  INPR;                              /*!< (@ 0x40030018) Interrupt Node Pointer Register                        */
  __IO uint32_t  DX0CR;                             /*!< (@ 0x4003001C) Input Control Register 0                               */
  __IO uint32_t  DX1CR;                             /*!< (@ 0x40030020) Input Control Register 1                               */
  __IO uint32_t  DX2CR;                             /*!< (@ 0x40030024) Input Control Register 2                               */
  __IO uint32_t  DX3CR;                             /*!< (@ 0x40030028) Input Control Register 3                               */
  __IO uint32_t  DX4CR;                             /*!< (@ 0x4003002C) Input Control Register 4                               */
  __IO uint32_t  DX5CR;                             /*!< (@ 0x40030030) Input Control Register 5                               */
  __IO uint32_t  SCTR;                              /*!< (@ 0x40030034) Shift Control Register                                 */
  __IO uint32_t  TCSR;                              /*!< (@ 0x40030038) Transmit Control/Status Register                       */
  
  union {
    __IO uint32_t  PCR_IICMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIC Mode]                   */
    __IO uint32_t  PCR_IISMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIS Mode]                   */
    __IO uint32_t  PCR_SSCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [SSC Mode]                   */
    __IO uint32_t  PCR;                             /*!< (@ 0x4003003C) Protocol Control Register                              */
    __IO uint32_t  PCR_ASCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [ASC Mode]                   */
  };
  __IO uint32_t  CCR;                               /*!< (@ 0x40030040) Channel Control Register                               */
  __IO uint32_t  CMTR;                              /*!< (@ 0x40030044) Capture Mode Timer Register                            */
  
  union {
    __IO uint32_t  PSR_IICMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIC Mode]                    */
    __IO uint32_t  PSR_IISMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIS Mode]                    */
    __IO uint32_t  PSR_SSCMode;                     /*!< (@ 0x40030048) Protocol Status Register [SSC Mode]                    */
    __IO uint32_t  PSR;                             /*!< (@ 0x40030048) Protocol Status Register                               */
    __IO uint32_t  PSR_ASCMode;                     /*!< (@ 0x40030048) Protocol Status Register [ASC Mode]                    */
  };
  __O  uint32_t  PSCR;                              /*!< (@ 0x4003004C) Protocol Status Clear Register                         */
  __I  uint32_t  RBUFSR;                            /*!< (@ 0x40030050) Receiver Buffer Status Register                        */
  __I  uint32_t  RBUF;                              /*!< (@ 0x40030054) Receiver Buffer Register                               */
  __I  uint32_t  RBUFD;                             /*!< (@ 0x40030058) Receiver Buffer Register for Debugger                  */
  __I  uint32_t  RBUF0;                             /*!< (@ 0x4003005C) Receiver Buffer Register 0                             */
  __I  uint32_t  RBUF1;                             /*!< (@ 0x40030060) Receiver Buffer Register 1                             */
  __I  uint32_t  RBUF01SR;                          /*!< (@ 0x40030064) Receiver Buffer 01 Status Register                     */
  __O  uint32_t  FMR;                               /*!< (@ 0x40030068) Flag Modification Register                             */
  __I  uint32_t  RESERVED2[5];
  __IO uint32_t  TBUF[32];                          /*!< (@ 0x40030080) Transmit Buffer                                        */
  __IO uint32_t  BYP;                               /*!< (@ 0x40030100) Bypass Data Register                                   */
  __IO uint32_t  BYPCR;                             /*!< (@ 0x40030104) Bypass Control Register                                */
  __IO uint32_t  TBCTR;                             /*!< (@ 0x40030108) Transmitter Buffer Control Register                    */
  __IO uint32_t  RBCTR;                             /*!< (@ 0x4003010C) Receiver Buffer Control Register                       */
  __I  uint32_t  TRBPTR;                            /*!< (@ 0x40030110) Transmit/Receive Buffer Pointer Register               */
  __IO uint32_t  TRBSR;                             /*!< (@ 0x40030114) Transmit/Receive Buffer Status Register                */
  __O  uint32_t  TRBSCR;                            /*!< (@ 0x40030118) Transmit/Receive Buffer Status Clear Register          */
  __I  uint32_t  OUTR;                              /*!< (@ 0x4003011C) Receiver Buffer Output Register                        */
  __I  uint32_t  OUTDR;                             /*!< (@ 0x40030120) Receiver Buffer Output Register L for Debugger         */
  __I  uint32_t  RESERVED3[23];
  __O  uint32_t  IN[32];                            /*!< (@ 0x40030180) Transmit FIFO Buffer                                   */
} USIC_CH_TypeDef;


/* ================================================================================ */
/* ================                       CAN                      ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN)
  */

typedef struct {                                    /*!< (@ 0x48014000) CAN Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x48014000) CAN Clock Control Register                             */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  ID;                                /*!< (@ 0x48014008) Module Identification Register                         */
  __IO uint32_t  FDR;                               /*!< (@ 0x4801400C) CAN Fractional Divider Register                        */
  __I  uint32_t  RESERVED1[60];
  __I  uint32_t  LIST[8];                           /*!< (@ 0x48014100) List Register                                          */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  MSPND[8];                          /*!< (@ 0x48014140) Message Pending Register                               */
  __I  uint32_t  RESERVED3[8];
  __I  uint32_t  MSID[8];                           /*!< (@ 0x48014180) Message Index Register                                 */
  __I  uint32_t  RESERVED4[8];
  __IO uint32_t  MSIMASK;                           /*!< (@ 0x480141C0) Message Index Mask Register                            */
  __IO uint32_t  PANCTR;                            /*!< (@ 0x480141C4) Panel Control Register                                 */
  __IO uint32_t  MCR;                               /*!< (@ 0x480141C8) Module Control Register                                */
  __O  uint32_t  MITR;                              /*!< (@ 0x480141CC) Module Interrupt Trigger Register                      */
} CAN_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CAN_NODE [CAN_NODE0]              ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_NODE)
  */

typedef struct {                                    /*!< (@ 0x48014200) CAN_NODE Structure                                     */
  __IO uint32_t  NCR;                               /*!< (@ 0x48014200) Node Control Register                                  */
  __IO uint32_t  NSR;                               /*!< (@ 0x48014204) Node Status Register                                   */
  __IO uint32_t  NIPR;                              /*!< (@ 0x48014208) Node Interrupt Pointer Register                        */
  __IO uint32_t  NPCR;                              /*!< (@ 0x4801420C) Node Port Control Register                             */
  __IO uint32_t  NBTR;                              /*!< (@ 0x48014210) Node Bit Timing Register                               */
  __IO uint32_t  NECNT;                             /*!< (@ 0x48014214) Node Error Counter Register                            */
  __IO uint32_t  NFCR;                              /*!< (@ 0x48014218) Node Frame Counter Register                            */
} CAN_NODE_TypeDef;


/* ================================================================================ */
/* ================                CAN_MO [CAN_MO0]                ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_MO)
  */

typedef struct {                                    /*!< (@ 0x48015000) CAN_MO Structure                                       */
  __IO uint32_t  MOFCR;                             /*!< (@ 0x48015000) Message Object Function Control Register               */
  __IO uint32_t  MOFGPR;                            /*!< (@ 0x48015004) Message Object FIFO/Gateway Pointer Register           */
  __IO uint32_t  MOIPR;                             /*!< (@ 0x48015008) Message Object Interrupt Pointer Register              */
  __IO uint32_t  MOAMR;                             /*!< (@ 0x4801500C) Message Object Acceptance Mask Register                */
  __IO uint32_t  MODATAL;                           /*!< (@ 0x48015010) Message Object Data Register Low                       */
  __IO uint32_t  MODATAH;                           /*!< (@ 0x48015014) Message Object Data Register High                      */
  __IO uint32_t  MOAR;                              /*!< (@ 0x48015018) Message Object Arbitration Register                    */
  
  union {
    __I  uint32_t  MOSTAT;                          /*!< (@ 0x4801501C) Message Object Status Register                         */
    __O  uint32_t  MOCTR;                           /*!< (@ 0x4801501C) Message Object Control Register                        */
  };
} CAN_MO_TypeDef;


/* ================================================================================ */
/* ================                      VADC                      ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC)
  */

typedef struct {                                    /*!< (@ 0x40004000) VADC Structure                                         */
  __IO uint32_t  CLC;                               /*!< (@ 0x40004000) Clock Control Register                                 */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  ID;                                /*!< (@ 0x40004008) Module Identification Register                         */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  OCS;                               /*!< (@ 0x40004028) OCDS Control and Status Register                       */
  __I  uint32_t  RESERVED2[21];
  __IO uint32_t  GLOBCFG;                           /*!< (@ 0x40004080) Global Configuration Register                          */
  __I  uint32_t  RESERVED3[7];
  __IO uint32_t  GLOBICLASS[2];                     /*!< (@ 0x400040A0) Input Class Register, Global                           */
  __I  uint32_t  RESERVED4[4];
  __IO uint32_t  GLOBBOUND;                         /*!< (@ 0x400040B8) Global Boundary Select Register                        */
  __I  uint32_t  RESERVED5[9];
  __IO uint32_t  GLOBEFLAG;                         /*!< (@ 0x400040E0) Global Event Flag Register                             */
  __I  uint32_t  RESERVED6[23];
  __IO uint32_t  GLOBEVNP;                          /*!< (@ 0x40004140) Global Event Node Pointer Register                     */
  __I  uint32_t  RESERVED7[7];
  __IO uint32_t  GLOBTF;                            /*!< (@ 0x40004160) Global Test Functions Register                         */
  __I  uint32_t  RESERVED8[7];
  __IO uint32_t  BRSSEL[4];                         /*!< (@ 0x40004180) Background Request Source Channel Select Register      */
  __I  uint32_t  RESERVED9[12];
  __IO uint32_t  BRSPND[4];                         /*!< (@ 0x400041C0) Background Request Source Pending Register             */
  __I  uint32_t  RESERVED10[12];
  __IO uint32_t  BRSCTRL;                           /*!< (@ 0x40004200) Background Request Source Control Register             */
  __IO uint32_t  BRSMR;                             /*!< (@ 0x40004204) Background Request Source Mode Register                */
  __I  uint32_t  RESERVED11[30];
  __IO uint32_t  GLOBRCR;                           /*!< (@ 0x40004280) Global Result Control Register                         */
  __I  uint32_t  RESERVED12[31];
  __IO uint32_t  GLOBRES;                           /*!< (@ 0x40004300) Global Result Register                                 */
  __I  uint32_t  RESERVED13[31];
  __IO uint32_t  GLOBRESD;                          /*!< (@ 0x40004380) Global Result Register, Debug                          */
  __I  uint32_t  RESERVED14[27];
  __IO uint32_t  EMUXSEL;                           /*!< (@ 0x400043F0) External Multiplexer Select Register                   */
} VADC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                VADC_G [VADC_G0]                ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC_G)
  */

typedef struct {                                    /*!< (@ 0x40004400) VADC_G Structure                                       */
  __I  uint32_t  RESERVED0[32];
  __IO uint32_t  ARBCFG;                            /*!< (@ 0x40004480) Arbitration Configuration Register                     */
  __IO uint32_t  ARBPR;                             /*!< (@ 0x40004484) Arbitration Priority Register                          */
  __IO uint32_t  CHASS;                             /*!< (@ 0x40004488) Channel Assignment Register                            */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  ICLASS[2];                         /*!< (@ 0x400044A0) Input Class Register                                   */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  ALIAS;                             /*!< (@ 0x400044B0) Alias Register                                         */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  BOUND;                             /*!< (@ 0x400044B8) Boundary Select Register                               */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SYNCTR;                            /*!< (@ 0x400044C0) Synchronization Control Register                       */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  BFL;                               /*!< (@ 0x400044C8) Boundary Flag Register                                 */
  __I  uint32_t  RESERVED6[13];
  __IO uint32_t  QCTRL0;                            /*!< (@ 0x40004500) Queue 0 Source Control Register                        */
  __IO uint32_t  QMR0;                              /*!< (@ 0x40004504) Queue 0 Mode Register                                  */
  __I  uint32_t  QSR0;                              /*!< (@ 0x40004508) Queue 0 Status Register                                */
  __I  uint32_t  Q0R0;                              /*!< (@ 0x4000450C) Queue 0 Register 0                                     */
  
  union {
    __I  uint32_t  QBUR0;                           /*!< (@ 0x40004510) Queue 0 Backup Register                                */
    __O  uint32_t  QINR0;                           /*!< (@ 0x40004510) Queue 0 Input Register                                 */
  };
  __I  uint32_t  RESERVED7[3];
  __IO uint32_t  ASCTRL;                            /*!< (@ 0x40004520) Autoscan Source Control Register                       */
  __IO uint32_t  ASMR;                              /*!< (@ 0x40004524) Autoscan Source Mode Register                          */
  __IO uint32_t  ASSEL;                             /*!< (@ 0x40004528) Autoscan Source Channel Select Register                */
  __IO uint32_t  ASPND;                             /*!< (@ 0x4000452C) Autoscan Source Pending Register                       */
  __I  uint32_t  RESERVED8[20];
  __IO uint32_t  CEFLAG;                            /*!< (@ 0x40004580) Channel Event Flag Register                            */
  __IO uint32_t  REFLAG;                            /*!< (@ 0x40004584) Result Event Flag Register                             */
  __IO uint32_t  SEFLAG;                            /*!< (@ 0x40004588) Source Event Flag Register                             */
  __I  uint32_t  RESERVED9;
  __O  uint32_t  CEFCLR;                            /*!< (@ 0x40004590) Channel Event Flag Clear Register                      */
  __O  uint32_t  REFCLR;                            /*!< (@ 0x40004594) Result Event Flag Clear Register                       */
  __O  uint32_t  SEFCLR;                            /*!< (@ 0x40004598) Source Event Flag Clear Register                       */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  CEVNP0;                            /*!< (@ 0x400045A0) Channel Event Node Pointer Register 0                  */
  __I  uint32_t  RESERVED11[3];
  __IO uint32_t  REVNP0;                            /*!< (@ 0x400045B0) Result Event Node Pointer Register 0                   */
  __IO uint32_t  REVNP1;                            /*!< (@ 0x400045B4) Result Event Node Pointer Register 1                   */
  __I  uint32_t  RESERVED12[2];
  __IO uint32_t  SEVNP;                             /*!< (@ 0x400045C0) Source Event Node Pointer Register                     */
  __I  uint32_t  RESERVED13;
  __O  uint32_t  SRACT;                             /*!< (@ 0x400045C8) Service Request Software Activation Trigger            */
  __I  uint32_t  RESERVED14[9];
  __IO uint32_t  EMUXCTR;                           /*!< (@ 0x400045F0) E0ternal Multiplexer Control Register                  */
  __I  uint32_t  RESERVED15;
  __IO uint32_t  VFR;                               /*!< (@ 0x400045F8) Valid Flag Register                                    */
  __I  uint32_t  RESERVED16;
  __IO uint32_t  CHCTR[8];                          /*!< (@ 0x40004600) Channel Ctrl. Reg.                                     */
  __I  uint32_t  RESERVED17[24];
  __IO uint32_t  RCR[16];                           /*!< (@ 0x40004680) Result Control Register                                */
  __I  uint32_t  RESERVED18[16];
  __IO uint32_t  RES[16];                           /*!< (@ 0x40004700) Result Register                                        */
  __I  uint32_t  RESERVED19[16];
  __I  uint32_t  RESD[16];                          /*!< (@ 0x40004780) Result Register, Debug                                 */
} VADC_G_TypeDef;


/* ================================================================================ */
/* ================                       DSD                      ================ */
/* ================================================================================ */


/**
  * @brief Delta Sigma Demodulator (DSD)
  */

typedef struct {                                    /*!< (@ 0x40008000) DSD Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x40008000) Clock Control Register                                 */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  ID;                                /*!< (@ 0x40008008) Module Identification Register                         */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  OCS;                               /*!< (@ 0x40008028) OCDS Control and Status Register                       */
  __I  uint32_t  RESERVED2[21];
  __IO uint32_t  GLOBCFG;                           /*!< (@ 0x40008080) Global Configuration Register                          */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  GLOBRC;                            /*!< (@ 0x40008088) Global Run Control Register                            */
  __I  uint32_t  RESERVED4[5];
  __IO uint32_t  CGCFG;                             /*!< (@ 0x400080A0) Carrier Generator Configuration Register               */
  __I  uint32_t  RESERVED5[15];
  __IO uint32_t  EVFLAG;                            /*!< (@ 0x400080E0) Event Flag Register                                    */
  __O  uint32_t  EVFLAGCLR;                         /*!< (@ 0x400080E4) Event Flag Clear Register                              */
} DSD_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                DSD_CH [DSD_CH0]                ================ */
/* ================================================================================ */


/**
  * @brief Delta Sigma Demodulator (DSD_CH)
  */

typedef struct {                                    /*!< (@ 0x40008100) DSD_CH Structure                                       */
  __IO uint32_t  MODCFG;                            /*!< (@ 0x40008100) Modulator Configuration Register                       */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  DICFG;                             /*!< (@ 0x40008108) Demodulator Input Configuration Register               */
  __I  uint32_t  RESERVED1[2];
  __IO uint32_t  FCFGC;                             /*!< (@ 0x40008114) Filter Configuration Register, Main CIC Filter         */
  __IO uint32_t  FCFGA;                             /*!< (@ 0x40008118) Filter Configuration Register, Auxiliary Filter        */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  IWCTR;                             /*!< (@ 0x40008120) Integration Window Control Register                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  BOUNDSEL;                          /*!< (@ 0x40008128) Boundary Select Register                               */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  RESM;                              /*!< (@ 0x40008130) Result Register, Main Filter                           */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  OFFM;                              /*!< (@ 0x40008138) Offset Register, Main Filter                           */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  RESA;                              /*!< (@ 0x40008140) Result Register, Auxiliary Filter                      */
  __I  uint32_t  RESERVED7[3];
  __I  uint32_t  TSTMP;                             /*!< (@ 0x40008150) Time-Stamp Register                                    */
  __I  uint32_t  RESERVED8[19];
  __IO uint32_t  CGSYNC;                            /*!< (@ 0x400081A0) Carrier Generator Synchronization Register             */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  RECTCFG;                           /*!< (@ 0x400081A8) Rectification Configuration Register                   */
} DSD_CH_TypeDef;


/* ================================================================================ */
/* ================                       DAC                      ================ */
/* ================================================================================ */


/**
  * @brief Digital to Analog Converter (DAC)
  */

typedef struct {                                    /*!< (@ 0x48018000) DAC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x48018000) Module Identification Register                         */
  __IO uint32_t  DAC0CFG0;                          /*!< (@ 0x48018004) DAC0 Configuration Register 0                          */
  __IO uint32_t  DAC0CFG1;                          /*!< (@ 0x48018008) DAC0 Configuration Register 1                          */
  __IO uint32_t  DAC1CFG0;                          /*!< (@ 0x4801800C) DAC1 Configuration Register 0                          */
  __IO uint32_t  DAC1CFG1;                          /*!< (@ 0x48018010) DAC1 Configuration Register 1                          */
  __IO uint32_t  DAC0DATA;                          /*!< (@ 0x48018014) DAC0 Data Register                                     */
  __IO uint32_t  DAC1DATA;                          /*!< (@ 0x48018018) DAC1 Data Register                                     */
  __IO uint32_t  DAC01DATA;                         /*!< (@ 0x4801801C) DAC01 Data Register                                    */
  __IO uint32_t  DAC0PATL;                          /*!< (@ 0x48018020) DAC0 Lower Pattern Register                            */
  __IO uint32_t  DAC0PATH;                          /*!< (@ 0x48018024) DAC0 Higher Pattern Register                           */
  __IO uint32_t  DAC1PATL;                          /*!< (@ 0x48018028) DAC1 Lower Pattern Register                            */
  __IO uint32_t  DAC1PATH;                          /*!< (@ 0x4801802C) DAC1 Higher Pattern Register                           */
} DAC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                  CCU4 [CCU40]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4)
  */

typedef struct {                                    /*!< (@ 0x4000C000) CCU4 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x4000C000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x4000C004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x4000C008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4000C00C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x4000C010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x4000C014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x4000C018) Global Channel Status                                  */
  __I  uint32_t  RESERVED0[13];
  __I  uint32_t  ECRD;                              /*!< (@ 0x4000C050) Extended Capture Mode Read                             */
  __I  uint32_t  RESERVED1[11];
  __I  uint32_t  MIDR;                              /*!< (@ 0x4000C080) Module Identification                                  */
} CCU4_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU4_CC4 [CCU40_CC40]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4_CC4)
  */

typedef struct {                                    /*!< (@ 0x4000C100) CCU4_CC4 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x4000C100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x4000C104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x4000C108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4000C10C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x4000C110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x4000C114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x4000C118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4000C11C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x4000C120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x4000C124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x4000C128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4000C12C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x4000C130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x4000C134) Timer Shadow Period Value                              */
  __I  uint32_t  CR;                                /*!< (@ 0x4000C138) Timer Compare Value                                    */
  __IO uint32_t  CRS;                               /*!< (@ 0x4000C13C) Timer Shadow Compare Value                             */
  __I  uint32_t  RESERVED0[12];
  __IO uint32_t  TIMER;                             /*!< (@ 0x4000C170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x4000C174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x4000C1A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x4000C1A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x4000C1A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x4000C1AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x4000C1B0) Interrupt Status Clear                                 */
} CCU4_CC4_TypeDef;


/* ================================================================================ */
/* ================                  CCU8 [CCU80]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8)
  */

typedef struct {                                    /*!< (@ 0x40020000) CCU8 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x40020000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x40020004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x40020008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4002000C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x40020010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x40020014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x40020018) Global Channel status                                  */
  __IO uint32_t  GPCHK;                             /*!< (@ 0x4002001C) Parity Checker Configuration                           */
  __I  uint32_t  RESERVED0[12];
  __I  uint32_t  ECRD;                              /*!< (@ 0x40020050) Extended Capture Mode Read                             */
  __I  uint32_t  RESERVED1[11];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40020080) Module Identification                                  */
} CCU8_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU8_CC8 [CCU80_CC80]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8_CC8)
  */

typedef struct {                                    /*!< (@ 0x40020100) CCU8_CC8 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x40020100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x40020104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x40020108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4002010C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x40020110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x40020114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x40020118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4002011C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x40020120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x40020124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x40020128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4002012C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x40020130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x40020134) Timer Shadow Period Value                              */
  __I  uint32_t  CR1;                               /*!< (@ 0x40020138) Channel 1 Compare Value                                */
  __IO uint32_t  CR1S;                              /*!< (@ 0x4002013C) Channel 1 Compare Shadow Value                         */
  __I  uint32_t  CR2;                               /*!< (@ 0x40020140) Channel 2 Compare Value                                */
  __IO uint32_t  CR2S;                              /*!< (@ 0x40020144) Channel 2 Compare Shadow Value                         */
  __IO uint32_t  CHC;                               /*!< (@ 0x40020148) Channel Control                                        */
  __IO uint32_t  DTC;                               /*!< (@ 0x4002014C) Dead Time Control                                      */
  __IO uint32_t  DC1R;                              /*!< (@ 0x40020150) Channel 1 Dead Time Values                             */
  __IO uint32_t  DC2R;                              /*!< (@ 0x40020154) Channel 2 Dead Time Values                             */
  __I  uint32_t  RESERVED0[6];
  __IO uint32_t  TIMER;                             /*!< (@ 0x40020170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x40020174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x400201A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x400201A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x400201A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x400201AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x400201B0) Interrupt Status Clear                                 */
} CCU8_CC8_TypeDef;


/* ================================================================================ */
/* ================                     HRPWM0                     ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0)
  */

typedef struct {                                    /*!< (@ 0x40020900) HRPWM0 Structure                                       */
  __IO uint32_t  HRBSC;                             /*!< (@ 0x40020900) Bias and suspend configuration                         */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  MIDR;                              /*!< (@ 0x40020908) Module identification register                         */
  __I  uint32_t  RESERVED1[2];
  __IO uint32_t  GLBANA;                            /*!< (@ 0x40020914) Global Analog Configuration                            */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  CSGCFG;                            /*!< (@ 0x40020920) Global CSG configuration                               */
  __O  uint32_t  CSGSETG;                           /*!< (@ 0x40020924) Global CSG run bit set                                 */
  __O  uint32_t  CSGCLRG;                           /*!< (@ 0x40020928) Global CSG run bit clear                               */
  __I  uint32_t  CSGSTATG;                          /*!< (@ 0x4002092C) Global CSG run bit status                              */
  __O  uint32_t  CSGFCG;                            /*!< (@ 0x40020930) Global CSG slope/prescaler control                     */
  __I  uint32_t  CSGFSG;                            /*!< (@ 0x40020934) Global CSG slope/prescaler status                      */
  __O  uint32_t  CSGTRG;                            /*!< (@ 0x40020938) Global CSG shadow/switch trigger                       */
  __O  uint32_t  CSGTRC;                            /*!< (@ 0x4002093C) Global CSG shadow trigger clear                        */
  __I  uint32_t  CSGTRSG;                           /*!< (@ 0x40020940) Global CSG shadow/switch status                        */
  __I  uint32_t  RESERVED3[7];
  __IO uint32_t  HRCCFG;                            /*!< (@ 0x40020960) Global HRC configuration                               */
  __O  uint32_t  HRCSTRG;                           /*!< (@ 0x40020964) Global HRC shadow trigger set                          */
  __O  uint32_t  HRCCTRG;                           /*!< (@ 0x40020968) Global HRC shadow trigger clear                        */
  __I  uint32_t  HRCSTSG;                           /*!< (@ 0x4002096C) Global HRC shadow transfer status                      */
  __I  uint32_t  HRGHRS;                            /*!< (@ 0x40020970) High Resolution Generation Status                      */
} HRPWM0_Type;


/* ================================================================================ */
/* ================            HRPWM0_CSG [HRPWM0_CSG0]            ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0_CSG)
  */

typedef struct {                                    /*!< (@ 0x40020A00) HRPWM0_CSG Structure                                   */
  __IO uint32_t  DCI;                               /*!< (@ 0x40020A00) External input selection                               */
  __IO uint32_t  IES;                               /*!< (@ 0x40020A04) External input selection                               */
  __IO uint32_t  SC;                                /*!< (@ 0x40020A08) Slope generation control                               */
  __I  uint32_t  PC;                                /*!< (@ 0x40020A0C) Pulse swallow configuration                            */
  __I  uint32_t  DSV1;                              /*!< (@ 0x40020A10) DAC reference value 1                                  */
  __IO uint32_t  DSV2;                              /*!< (@ 0x40020A14) DAC reference value 1                                  */
  __IO uint32_t  SDSV1;                             /*!< (@ 0x40020A18) Shadow reference value 1                               */
  __IO uint32_t  SPC;                               /*!< (@ 0x40020A1C) Shadow Pulse swallow value                             */
  __IO uint32_t  CC;                                /*!< (@ 0x40020A20) Comparator configuration                               */
  __IO uint32_t  PLC;                               /*!< (@ 0x40020A24) Passive level configuration                            */
  __IO uint32_t  BLV;                               /*!< (@ 0x40020A28) Comparator blanking value                              */
  __IO uint32_t  SRE;                               /*!< (@ 0x40020A2C) Service request enable                                 */
  __IO uint32_t  SRS;                               /*!< (@ 0x40020A30) Service request line selector                          */
  __O  uint32_t  SWS;                               /*!< (@ 0x40020A34) Service request SW set                                 */
  __O  uint32_t  SWC;                               /*!< (@ 0x40020A38) Service request SW clear                               */
  __I  uint32_t  ISTAT;                             /*!< (@ 0x40020A3C) Service request status                                 */
} HRPWM0_CSG_Type;


/* ================================================================================ */
/* ================            HRPWM0_HRC [HRPWM0_HRC0]            ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0_HRC)
  */

typedef struct {                                    /*!< (@ 0x40021300) HRPWM0_HRC Structure                                   */
  __IO uint32_t  GC;                                /*!< (@ 0x40021300) HRC mode configuration                                 */
  __IO uint32_t  PL;                                /*!< (@ 0x40021304) HRC output passive level                               */
  __IO uint32_t  GSEL;                              /*!< (@ 0x40021308) HRC global control selection                           */
  __IO uint32_t  TSEL;                              /*!< (@ 0x4002130C) HRC timer selection                                    */
  __I  uint32_t  SC;                                /*!< (@ 0x40021310) HRC current source for shadow                          */
  __I  uint32_t  DCR;                               /*!< (@ 0x40021314) HRC dead time rising value                             */
  __I  uint32_t  DCF;                               /*!< (@ 0x40021318) HRC dead time falling value                            */
  __I  uint32_t  CR1;                               /*!< (@ 0x4002131C) HRC rising edge value                                  */
  __I  uint32_t  CR2;                               /*!< (@ 0x40021320) HRC falling edge value                                 */
  __IO uint32_t  SSC;                               /*!< (@ 0x40021324) HRC next source for shadow                             */
  __IO uint32_t  SDCR;                              /*!< (@ 0x40021328) HRC shadow dead time rising                            */
  __IO uint32_t  SDCF;                              /*!< (@ 0x4002132C) HRC shadow dead time falling                           */
  __IO uint32_t  SCR1;                              /*!< (@ 0x40021330) HRC shadow rising edge value                           */
  __IO uint32_t  SCR2;                              /*!< (@ 0x40021334) HRC shadow falling edge value                          */
} HRPWM0_HRC_Type;


/* ================================================================================ */
/* ================                 POSIF [POSIF0]                 ================ */
/* ================================================================================ */


/**
  * @brief Position Interface 0 (POSIF)
  */

typedef struct {                                    /*!< (@ 0x40028000) POSIF Structure                                        */
  __IO uint32_t  PCONF;                             /*!< (@ 0x40028000) Service Request Processing configuration               */
  __IO uint32_t  PSUS;                              /*!< (@ 0x40028004) Service Request Processing Suspend Config              */
  __O  uint32_t  PRUNS;                             /*!< (@ 0x40028008) Service Request Processing Run Bit Set                 */
  __O  uint32_t  PRUNC;                             /*!< (@ 0x4002800C) Service Request Processing Run Bit Clear               */
  __I  uint32_t  PRUN;                              /*!< (@ 0x40028010) Service Request Processing Run Bit Status              */
  __I  uint32_t  RESERVED0[3];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40028020) Module Identification register                         */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  HALP;                              /*!< (@ 0x40028030) Hall Sensor Patterns                                   */
  __IO uint32_t  HALPS;                             /*!< (@ 0x40028034) Hall Sensor Shadow Patterns                            */
  __I  uint32_t  RESERVED2[2];
  __I  uint32_t  MCM;                               /*!< (@ 0x40028040) Multi-Channel Pattern                                  */
  __IO uint32_t  MCSM;                              /*!< (@ 0x40028044) Multi-Channel Shadow Pattern                           */
  __O  uint32_t  MCMS;                              /*!< (@ 0x40028048) Multi-Channel Pattern Control set                      */
  __O  uint32_t  MCMC;                              /*!< (@ 0x4002804C) Multi-Channel Pattern Control clear                    */
  __I  uint32_t  MCMF;                              /*!< (@ 0x40028050) Multi-Channel Pattern Control flag                     */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  QDC;                               /*!< (@ 0x40028060) Quadrature Decoder Control                             */
  __I  uint32_t  RESERVED4[3];
  __I  uint32_t  PFLG;                              /*!< (@ 0x40028070) Service Request Processing Interrupt Flags             */
  __IO uint32_t  PFLGE;                             /*!< (@ 0x40028074) Service Request Processing Interrupt Enable            */
  __O  uint32_t  SPFLG;                             /*!< (@ 0x40028078) Service Request Processing Interrupt Set               */
  __O  uint32_t  RPFLG;                             /*!< (@ 0x4002807C) Service Request Processing Interrupt Clear             */
  __I  uint32_t  RESERVED5[32];
  __I  uint32_t  PDBG;                              /*!< (@ 0x40028100) POSIF Debug register                                   */
} POSIF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PORT0                     ================ */
/* ================================================================================ */


/**
  * @brief Port 0 (PORT0)
  */

typedef struct {                                    /*!< (@ 0x48028000) PORT0 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028000) Port 0 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028004) Port 0 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028010) Port 0 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028014) Port 0 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028018) Port 0 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802801C) Port 0 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028024) Port 0 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028040) Port 0 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028044) Port 0 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028060) Port 0 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028070) Port 0 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028074) Port 0 Pin Hardware Select Register                    */
} PORT0_Type;


/* ================================================================================ */
/* ================                      PORT1                     ================ */
/* ================================================================================ */


/**
  * @brief Port 1 (PORT1)
  */

typedef struct {                                    /*!< (@ 0x48028100) PORT1 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028100) Port 1 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028104) Port 1 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028110) Port 1 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028114) Port 1 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028118) Port 1 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802811C) Port 1 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028124) Port 1 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028140) Port 1 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028144) Port 1 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028160) Port 1 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028170) Port 1 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028174) Port 1 Pin Hardware Select Register                    */
} PORT1_Type;


/* ================================================================================ */
/* ================                      PORT2                     ================ */
/* ================================================================================ */


/**
  * @brief Port 2 (PORT2)
  */

typedef struct {                                    /*!< (@ 0x48028200) PORT2 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028200) Port 2 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028204) Port 2 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028210) Port 2 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028214) Port 2 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028218) Port 2 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802821C) Port 2 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028224) Port 2 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028240) Port 2 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028244) Port 2 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028260) Port 2 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028270) Port 2 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028274) Port 2 Pin Hardware Select Register                    */
} PORT2_Type;


/* ================================================================================ */
/* ================                      PORT3                     ================ */
/* ================================================================================ */


/**
  * @brief Port 3 (PORT3)
  */

typedef struct {                                    /*!< (@ 0x48028300) PORT3 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028300) Port 3 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028304) Port 3 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028310) Port 3 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028314) Port 3 Input/Output Control Register 4                 */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  IN;                                /*!< (@ 0x48028324) Port 3 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028340) Port 3 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028360) Port 3 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028370) Port 3 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028374) Port 3 Pin Hardware Select Register                    */
} PORT3_Type;


/* ================================================================================ */
/* ================                      PORT4                     ================ */
/* ================================================================================ */


/**
  * @brief Port 4 (PORT4)
  */

typedef struct {                                    /*!< (@ 0x48028400) PORT4 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028400) Port 4 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028404) Port 4 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028410) Port 4 Input/Output Control Register 0                 */
  __I  uint32_t  RESERVED1[4];
  __I  uint32_t  IN;                                /*!< (@ 0x48028424) Port 4 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028440) Port 4 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028460) Port 4 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028470) Port 4 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028474) Port 4 Pin Hardware Select Register                    */
} PORT4_Type;


/* ================================================================================ */
/* ================                      PORT5                     ================ */
/* ================================================================================ */


/**
  * @brief Port 5 (PORT5)
  */

typedef struct {                                    /*!< (@ 0x48028500) PORT5 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028500) Port 5 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028504) Port 5 Output Modification Register                    */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028510) Port 5 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028514) Port 5 Input/Output Control Register 4                 */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  IN;                                /*!< (@ 0x48028524) Port 5 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028540) Port 5 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028560) Port 5 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028570) Port 5 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028574) Port 5 Pin Hardware Select Register                    */
} PORT5_Type;


/* ================================================================================ */
/* ================                     PORT14                     ================ */
/* ================================================================================ */


/**
  * @brief Port 14 (PORT14)
  */

typedef struct {                                    /*!< (@ 0x48028E00) PORT14 Structure                                       */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028E00) Port 14 Output Register                                */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028E04) Port 14 Output Modification Register                   */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028E10) Port 14 Input/Output Control Register 0                */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028E14) Port 14 Input/Output Control Register 4                */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028E18) Port 14 Input/Output Control Register 8                */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x48028E1C) Port 14 Input/Output Control Register 12               */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028E24) Port 14 Input Register                                 */
  __I  uint32_t  RESERVED2[14];
  __IO uint32_t  PDISC;                             /*!< (@ 0x48028E60) Port 14 Pin Function Decision Control Register         */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028E70) Port 14 Pin Power Save Register                        */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028E74) Port 14 Pin Hardware Select Register                   */
} PORT14_Type;


/* ================================================================================ */
/* ================                     PORT15                     ================ */
/* ================================================================================ */


/**
  * @brief Port 15 (PORT15)
  */

typedef struct {                                    /*!< (@ 0x48028F00) PORT15 Structure                                       */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028F00) Port 15 Output Register                                */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028F04) Port 15 Output Modification Register                   */
  __I  uint32_t  RESERVED0[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028F10) Port 15 Input/Output Control Register 0                */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028F14) Port 15 Input/Output Control Register 4                */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028F18) Port 15 Input/Output Control Register 8                */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028F24) Port 15 Input Register                                 */
  __I  uint32_t  RESERVED2[14];
  __IO uint32_t  PDISC;                             /*!< (@ 0x48028F60) Port 15 Pin Function Decision Control Register         */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028F70) Port 15 Pin Power Save Register                        */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028F74) Port 15 Pin Hardware Select Register                   */
} PORT15_Type;


/* --------------------  End of section using anonymous unions  ------------------- */
#if defined(__CC_ARM)
  #pragma pop
#elif defined(__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning restore
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================          struct 'PPB' Position & Mask          ================ */
/* ================================================================================ */


/* ----------------------------------  PPB_ACTLR  --------------------------------- */
#define PPB_ACTLR_DISMCYCINT_Pos              0                                                       /*!< PPB ACTLR: DISMCYCINT Position          */
#define PPB_ACTLR_DISMCYCINT_Msk              (0x01UL << PPB_ACTLR_DISMCYCINT_Pos)                    /*!< PPB ACTLR: DISMCYCINT Mask              */
#define PPB_ACTLR_DISDEFWBUF_Pos              1                                                       /*!< PPB ACTLR: DISDEFWBUF Position          */
#define PPB_ACTLR_DISDEFWBUF_Msk              (0x01UL << PPB_ACTLR_DISDEFWBUF_Pos)                    /*!< PPB ACTLR: DISDEFWBUF Mask              */
#define PPB_ACTLR_DISFOLD_Pos                 2                                                       /*!< PPB ACTLR: DISFOLD Position             */
#define PPB_ACTLR_DISFOLD_Msk                 (0x01UL << PPB_ACTLR_DISFOLD_Pos)                       /*!< PPB ACTLR: DISFOLD Mask                 */
#define PPB_ACTLR_DISFPCA_Pos                 8                                                       /*!< PPB ACTLR: DISFPCA Position             */
#define PPB_ACTLR_DISFPCA_Msk                 (0x01UL << PPB_ACTLR_DISFPCA_Pos)                       /*!< PPB ACTLR: DISFPCA Mask                 */
#define PPB_ACTLR_DISOOFP_Pos                 9                                                       /*!< PPB ACTLR: DISOOFP Position             */
#define PPB_ACTLR_DISOOFP_Msk                 (0x01UL << PPB_ACTLR_DISOOFP_Pos)                       /*!< PPB ACTLR: DISOOFP Mask                 */

/* --------------------------------  PPB_SYST_CSR  -------------------------------- */
#define PPB_SYST_CSR_ENABLE_Pos               0                                                       /*!< PPB SYST_CSR: ENABLE Position           */
#define PPB_SYST_CSR_ENABLE_Msk               (0x01UL << PPB_SYST_CSR_ENABLE_Pos)                     /*!< PPB SYST_CSR: ENABLE Mask               */
#define PPB_SYST_CSR_TICKINT_Pos              1                                                       /*!< PPB SYST_CSR: TICKINT Position          */
#define PPB_SYST_CSR_TICKINT_Msk              (0x01UL << PPB_SYST_CSR_TICKINT_Pos)                    /*!< PPB SYST_CSR: TICKINT Mask              */
#define PPB_SYST_CSR_CLKSOURCE_Pos            2                                                       /*!< PPB SYST_CSR: CLKSOURCE Position        */
#define PPB_SYST_CSR_CLKSOURCE_Msk            (0x01UL << PPB_SYST_CSR_CLKSOURCE_Pos)                  /*!< PPB SYST_CSR: CLKSOURCE Mask            */
#define PPB_SYST_CSR_COUNTFLAG_Pos            16                                                      /*!< PPB SYST_CSR: COUNTFLAG Position        */
#define PPB_SYST_CSR_COUNTFLAG_Msk            (0x01UL << PPB_SYST_CSR_COUNTFLAG_Pos)                  /*!< PPB SYST_CSR: COUNTFLAG Mask            */

/* --------------------------------  PPB_SYST_RVR  -------------------------------- */
#define PPB_SYST_RVR_RELOAD_Pos               0                                                       /*!< PPB SYST_RVR: RELOAD Position           */
#define PPB_SYST_RVR_RELOAD_Msk               (0x00ffffffUL << PPB_SYST_RVR_RELOAD_Pos)               /*!< PPB SYST_RVR: RELOAD Mask               */

/* --------------------------------  PPB_SYST_CVR  -------------------------------- */
#define PPB_SYST_CVR_CURRENT_Pos              0                                                       /*!< PPB SYST_CVR: CURRENT Position          */
#define PPB_SYST_CVR_CURRENT_Msk              (0x00ffffffUL << PPB_SYST_CVR_CURRENT_Pos)              /*!< PPB SYST_CVR: CURRENT Mask              */

/* -------------------------------  PPB_SYST_CALIB  ------------------------------- */
#define PPB_SYST_CALIB_TENMS_Pos              0                                                       /*!< PPB SYST_CALIB: TENMS Position          */
#define PPB_SYST_CALIB_TENMS_Msk              (0x00ffffffUL << PPB_SYST_CALIB_TENMS_Pos)              /*!< PPB SYST_CALIB: TENMS Mask              */
#define PPB_SYST_CALIB_SKEW_Pos               30                                                      /*!< PPB SYST_CALIB: SKEW Position           */
#define PPB_SYST_CALIB_SKEW_Msk               (0x01UL << PPB_SYST_CALIB_SKEW_Pos)                     /*!< PPB SYST_CALIB: SKEW Mask               */
#define PPB_SYST_CALIB_NOREF_Pos              31                                                      /*!< PPB SYST_CALIB: NOREF Position          */
#define PPB_SYST_CALIB_NOREF_Msk              (0x01UL << PPB_SYST_CALIB_NOREF_Pos)                    /*!< PPB SYST_CALIB: NOREF Mask              */

/* -------------------------------  PPB_NVIC_ISER0  ------------------------------- */
#define PPB_NVIC_ISER0_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER0: SETENA Position         */
#define PPB_NVIC_ISER0_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER0_SETENA_Pos)             /*!< PPB NVIC_ISER0: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ISER1  ------------------------------- */
#define PPB_NVIC_ISER1_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER1: SETENA Position         */
#define PPB_NVIC_ISER1_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER1_SETENA_Pos)             /*!< PPB NVIC_ISER1: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ISER2  ------------------------------- */
#define PPB_NVIC_ISER2_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER2: SETENA Position         */
#define PPB_NVIC_ISER2_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER2_SETENA_Pos)             /*!< PPB NVIC_ISER2: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ISER3  ------------------------------- */
#define PPB_NVIC_ISER3_SETENA_Pos             0                                                       /*!< PPB NVIC_ISER3: SETENA Position         */
#define PPB_NVIC_ISER3_SETENA_Msk             (0xffffffffUL << PPB_NVIC_ISER3_SETENA_Pos)             /*!< PPB NVIC_ISER3: SETENA Mask             */

/* -------------------------------  PPB_NVIC_ICER0  ------------------------------- */
#define PPB_NVIC_ICER0_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER0: CLRENA Position         */
#define PPB_NVIC_ICER0_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER0_CLRENA_Pos)             /*!< PPB NVIC_ICER0: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ICER1  ------------------------------- */
#define PPB_NVIC_ICER1_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER1: CLRENA Position         */
#define PPB_NVIC_ICER1_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER1_CLRENA_Pos)             /*!< PPB NVIC_ICER1: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ICER2  ------------------------------- */
#define PPB_NVIC_ICER2_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER2: CLRENA Position         */
#define PPB_NVIC_ICER2_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER2_CLRENA_Pos)             /*!< PPB NVIC_ICER2: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ICER3  ------------------------------- */
#define PPB_NVIC_ICER3_CLRENA_Pos             0                                                       /*!< PPB NVIC_ICER3: CLRENA Position         */
#define PPB_NVIC_ICER3_CLRENA_Msk             (0xffffffffUL << PPB_NVIC_ICER3_CLRENA_Pos)             /*!< PPB NVIC_ICER3: CLRENA Mask             */

/* -------------------------------  PPB_NVIC_ISPR0  ------------------------------- */
#define PPB_NVIC_ISPR0_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR0: SETPEND Position        */
#define PPB_NVIC_ISPR0_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR0_SETPEND_Pos)            /*!< PPB NVIC_ISPR0: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ISPR1  ------------------------------- */
#define PPB_NVIC_ISPR1_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR1: SETPEND Position        */
#define PPB_NVIC_ISPR1_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR1_SETPEND_Pos)            /*!< PPB NVIC_ISPR1: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ISPR2  ------------------------------- */
#define PPB_NVIC_ISPR2_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR2: SETPEND Position        */
#define PPB_NVIC_ISPR2_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR2_SETPEND_Pos)            /*!< PPB NVIC_ISPR2: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ISPR3  ------------------------------- */
#define PPB_NVIC_ISPR3_SETPEND_Pos            0                                                       /*!< PPB NVIC_ISPR3: SETPEND Position        */
#define PPB_NVIC_ISPR3_SETPEND_Msk            (0xffffffffUL << PPB_NVIC_ISPR3_SETPEND_Pos)            /*!< PPB NVIC_ISPR3: SETPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR0  ------------------------------- */
#define PPB_NVIC_ICPR0_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR0: CLRPEND Position        */
#define PPB_NVIC_ICPR0_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR0_CLRPEND_Pos)            /*!< PPB NVIC_ICPR0: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR1  ------------------------------- */
#define PPB_NVIC_ICPR1_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR1: CLRPEND Position        */
#define PPB_NVIC_ICPR1_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR1_CLRPEND_Pos)            /*!< PPB NVIC_ICPR1: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR2  ------------------------------- */
#define PPB_NVIC_ICPR2_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR2: CLRPEND Position        */
#define PPB_NVIC_ICPR2_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR2_CLRPEND_Pos)            /*!< PPB NVIC_ICPR2: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_ICPR3  ------------------------------- */
#define PPB_NVIC_ICPR3_CLRPEND_Pos            0                                                       /*!< PPB NVIC_ICPR3: CLRPEND Position        */
#define PPB_NVIC_ICPR3_CLRPEND_Msk            (0xffffffffUL << PPB_NVIC_ICPR3_CLRPEND_Pos)            /*!< PPB NVIC_ICPR3: CLRPEND Mask            */

/* -------------------------------  PPB_NVIC_IABR0  ------------------------------- */
#define PPB_NVIC_IABR0_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR0: ACTIVE Position         */
#define PPB_NVIC_IABR0_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR0_ACTIVE_Pos)             /*!< PPB NVIC_IABR0: ACTIVE Mask             */

/* -------------------------------  PPB_NVIC_IABR1  ------------------------------- */
#define PPB_NVIC_IABR1_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR1: ACTIVE Position         */
#define PPB_NVIC_IABR1_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR1_ACTIVE_Pos)             /*!< PPB NVIC_IABR1: ACTIVE Mask             */

/* -------------------------------  PPB_NVIC_IABR2  ------------------------------- */
#define PPB_NVIC_IABR2_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR2: ACTIVE Position         */
#define PPB_NVIC_IABR2_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR2_ACTIVE_Pos)             /*!< PPB NVIC_IABR2: ACTIVE Mask             */

/* -------------------------------  PPB_NVIC_IABR3  ------------------------------- */
#define PPB_NVIC_IABR3_ACTIVE_Pos             0                                                       /*!< PPB NVIC_IABR3: ACTIVE Position         */
#define PPB_NVIC_IABR3_ACTIVE_Msk             (0xffffffffUL << PPB_NVIC_IABR3_ACTIVE_Pos)             /*!< PPB NVIC_IABR3: ACTIVE Mask             */

/* --------------------------------  PPB_NVIC_IPR0  ------------------------------- */
#define PPB_NVIC_IPR0_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR0: PRI_0 Position           */
#define PPB_NVIC_IPR0_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_0_Pos)               /*!< PPB NVIC_IPR0: PRI_0 Mask               */
#define PPB_NVIC_IPR0_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR0: PRI_1 Position           */
#define PPB_NVIC_IPR0_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_1_Pos)               /*!< PPB NVIC_IPR0: PRI_1 Mask               */
#define PPB_NVIC_IPR0_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR0: PRI_2 Position           */
#define PPB_NVIC_IPR0_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_2_Pos)               /*!< PPB NVIC_IPR0: PRI_2 Mask               */
#define PPB_NVIC_IPR0_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR0: PRI_3 Position           */
#define PPB_NVIC_IPR0_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR0_PRI_3_Pos)               /*!< PPB NVIC_IPR0: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR1  ------------------------------- */
#define PPB_NVIC_IPR1_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR1: PRI_0 Position           */
#define PPB_NVIC_IPR1_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_0_Pos)               /*!< PPB NVIC_IPR1: PRI_0 Mask               */
#define PPB_NVIC_IPR1_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR1: PRI_1 Position           */
#define PPB_NVIC_IPR1_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_1_Pos)               /*!< PPB NVIC_IPR1: PRI_1 Mask               */
#define PPB_NVIC_IPR1_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR1: PRI_2 Position           */
#define PPB_NVIC_IPR1_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_2_Pos)               /*!< PPB NVIC_IPR1: PRI_2 Mask               */
#define PPB_NVIC_IPR1_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR1: PRI_3 Position           */
#define PPB_NVIC_IPR1_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR1_PRI_3_Pos)               /*!< PPB NVIC_IPR1: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR2  ------------------------------- */
#define PPB_NVIC_IPR2_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR2: PRI_0 Position           */
#define PPB_NVIC_IPR2_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_0_Pos)               /*!< PPB NVIC_IPR2: PRI_0 Mask               */
#define PPB_NVIC_IPR2_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR2: PRI_1 Position           */
#define PPB_NVIC_IPR2_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_1_Pos)               /*!< PPB NVIC_IPR2: PRI_1 Mask               */
#define PPB_NVIC_IPR2_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR2: PRI_2 Position           */
#define PPB_NVIC_IPR2_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_2_Pos)               /*!< PPB NVIC_IPR2: PRI_2 Mask               */
#define PPB_NVIC_IPR2_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR2: PRI_3 Position           */
#define PPB_NVIC_IPR2_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR2_PRI_3_Pos)               /*!< PPB NVIC_IPR2: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR3  ------------------------------- */
#define PPB_NVIC_IPR3_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR3: PRI_0 Position           */
#define PPB_NVIC_IPR3_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_0_Pos)               /*!< PPB NVIC_IPR3: PRI_0 Mask               */
#define PPB_NVIC_IPR3_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR3: PRI_1 Position           */
#define PPB_NVIC_IPR3_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_1_Pos)               /*!< PPB NVIC_IPR3: PRI_1 Mask               */
#define PPB_NVIC_IPR3_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR3: PRI_2 Position           */
#define PPB_NVIC_IPR3_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_2_Pos)               /*!< PPB NVIC_IPR3: PRI_2 Mask               */
#define PPB_NVIC_IPR3_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR3: PRI_3 Position           */
#define PPB_NVIC_IPR3_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR3_PRI_3_Pos)               /*!< PPB NVIC_IPR3: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR4  ------------------------------- */
#define PPB_NVIC_IPR4_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR4: PRI_0 Position           */
#define PPB_NVIC_IPR4_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_0_Pos)               /*!< PPB NVIC_IPR4: PRI_0 Mask               */
#define PPB_NVIC_IPR4_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR4: PRI_1 Position           */
#define PPB_NVIC_IPR4_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_1_Pos)               /*!< PPB NVIC_IPR4: PRI_1 Mask               */
#define PPB_NVIC_IPR4_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR4: PRI_2 Position           */
#define PPB_NVIC_IPR4_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_2_Pos)               /*!< PPB NVIC_IPR4: PRI_2 Mask               */
#define PPB_NVIC_IPR4_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR4: PRI_3 Position           */
#define PPB_NVIC_IPR4_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR4_PRI_3_Pos)               /*!< PPB NVIC_IPR4: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR5  ------------------------------- */
#define PPB_NVIC_IPR5_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR5: PRI_0 Position           */
#define PPB_NVIC_IPR5_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_0_Pos)               /*!< PPB NVIC_IPR5: PRI_0 Mask               */
#define PPB_NVIC_IPR5_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR5: PRI_1 Position           */
#define PPB_NVIC_IPR5_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_1_Pos)               /*!< PPB NVIC_IPR5: PRI_1 Mask               */
#define PPB_NVIC_IPR5_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR5: PRI_2 Position           */
#define PPB_NVIC_IPR5_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_2_Pos)               /*!< PPB NVIC_IPR5: PRI_2 Mask               */
#define PPB_NVIC_IPR5_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR5: PRI_3 Position           */
#define PPB_NVIC_IPR5_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR5_PRI_3_Pos)               /*!< PPB NVIC_IPR5: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR6  ------------------------------- */
#define PPB_NVIC_IPR6_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR6: PRI_0 Position           */
#define PPB_NVIC_IPR6_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_0_Pos)               /*!< PPB NVIC_IPR6: PRI_0 Mask               */
#define PPB_NVIC_IPR6_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR6: PRI_1 Position           */
#define PPB_NVIC_IPR6_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_1_Pos)               /*!< PPB NVIC_IPR6: PRI_1 Mask               */
#define PPB_NVIC_IPR6_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR6: PRI_2 Position           */
#define PPB_NVIC_IPR6_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_2_Pos)               /*!< PPB NVIC_IPR6: PRI_2 Mask               */
#define PPB_NVIC_IPR6_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR6: PRI_3 Position           */
#define PPB_NVIC_IPR6_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR6_PRI_3_Pos)               /*!< PPB NVIC_IPR6: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR7  ------------------------------- */
#define PPB_NVIC_IPR7_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR7: PRI_0 Position           */
#define PPB_NVIC_IPR7_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_0_Pos)               /*!< PPB NVIC_IPR7: PRI_0 Mask               */
#define PPB_NVIC_IPR7_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR7: PRI_1 Position           */
#define PPB_NVIC_IPR7_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_1_Pos)               /*!< PPB NVIC_IPR7: PRI_1 Mask               */
#define PPB_NVIC_IPR7_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR7: PRI_2 Position           */
#define PPB_NVIC_IPR7_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_2_Pos)               /*!< PPB NVIC_IPR7: PRI_2 Mask               */
#define PPB_NVIC_IPR7_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR7: PRI_3 Position           */
#define PPB_NVIC_IPR7_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR7_PRI_3_Pos)               /*!< PPB NVIC_IPR7: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR8  ------------------------------- */
#define PPB_NVIC_IPR8_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR8: PRI_0 Position           */
#define PPB_NVIC_IPR8_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_0_Pos)               /*!< PPB NVIC_IPR8: PRI_0 Mask               */
#define PPB_NVIC_IPR8_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR8: PRI_1 Position           */
#define PPB_NVIC_IPR8_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_1_Pos)               /*!< PPB NVIC_IPR8: PRI_1 Mask               */
#define PPB_NVIC_IPR8_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR8: PRI_2 Position           */
#define PPB_NVIC_IPR8_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_2_Pos)               /*!< PPB NVIC_IPR8: PRI_2 Mask               */
#define PPB_NVIC_IPR8_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR8: PRI_3 Position           */
#define PPB_NVIC_IPR8_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR8_PRI_3_Pos)               /*!< PPB NVIC_IPR8: PRI_3 Mask               */

/* --------------------------------  PPB_NVIC_IPR9  ------------------------------- */
#define PPB_NVIC_IPR9_PRI_0_Pos               0                                                       /*!< PPB NVIC_IPR9: PRI_0 Position           */
#define PPB_NVIC_IPR9_PRI_0_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_0_Pos)               /*!< PPB NVIC_IPR9: PRI_0 Mask               */
#define PPB_NVIC_IPR9_PRI_1_Pos               8                                                       /*!< PPB NVIC_IPR9: PRI_1 Position           */
#define PPB_NVIC_IPR9_PRI_1_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_1_Pos)               /*!< PPB NVIC_IPR9: PRI_1 Mask               */
#define PPB_NVIC_IPR9_PRI_2_Pos               16                                                      /*!< PPB NVIC_IPR9: PRI_2 Position           */
#define PPB_NVIC_IPR9_PRI_2_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_2_Pos)               /*!< PPB NVIC_IPR9: PRI_2 Mask               */
#define PPB_NVIC_IPR9_PRI_3_Pos               24                                                      /*!< PPB NVIC_IPR9: PRI_3 Position           */
#define PPB_NVIC_IPR9_PRI_3_Msk               (0x000000ffUL << PPB_NVIC_IPR9_PRI_3_Pos)               /*!< PPB NVIC_IPR9: PRI_3 Mask               */

/* -------------------------------  PPB_NVIC_IPR10  ------------------------------- */
#define PPB_NVIC_IPR10_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR10: PRI_0 Position          */
#define PPB_NVIC_IPR10_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_0_Pos)              /*!< PPB NVIC_IPR10: PRI_0 Mask              */
#define PPB_NVIC_IPR10_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR10: PRI_1 Position          */
#define PPB_NVIC_IPR10_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_1_Pos)              /*!< PPB NVIC_IPR10: PRI_1 Mask              */
#define PPB_NVIC_IPR10_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR10: PRI_2 Position          */
#define PPB_NVIC_IPR10_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_2_Pos)              /*!< PPB NVIC_IPR10: PRI_2 Mask              */
#define PPB_NVIC_IPR10_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR10: PRI_3 Position          */
#define PPB_NVIC_IPR10_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR10_PRI_3_Pos)              /*!< PPB NVIC_IPR10: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR11  ------------------------------- */
#define PPB_NVIC_IPR11_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR11: PRI_0 Position          */
#define PPB_NVIC_IPR11_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_0_Pos)              /*!< PPB NVIC_IPR11: PRI_0 Mask              */
#define PPB_NVIC_IPR11_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR11: PRI_1 Position          */
#define PPB_NVIC_IPR11_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_1_Pos)              /*!< PPB NVIC_IPR11: PRI_1 Mask              */
#define PPB_NVIC_IPR11_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR11: PRI_2 Position          */
#define PPB_NVIC_IPR11_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_2_Pos)              /*!< PPB NVIC_IPR11: PRI_2 Mask              */
#define PPB_NVIC_IPR11_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR11: PRI_3 Position          */
#define PPB_NVIC_IPR11_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR11_PRI_3_Pos)              /*!< PPB NVIC_IPR11: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR12  ------------------------------- */
#define PPB_NVIC_IPR12_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR12: PRI_0 Position          */
#define PPB_NVIC_IPR12_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_0_Pos)              /*!< PPB NVIC_IPR12: PRI_0 Mask              */
#define PPB_NVIC_IPR12_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR12: PRI_1 Position          */
#define PPB_NVIC_IPR12_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_1_Pos)              /*!< PPB NVIC_IPR12: PRI_1 Mask              */
#define PPB_NVIC_IPR12_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR12: PRI_2 Position          */
#define PPB_NVIC_IPR12_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_2_Pos)              /*!< PPB NVIC_IPR12: PRI_2 Mask              */
#define PPB_NVIC_IPR12_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR12: PRI_3 Position          */
#define PPB_NVIC_IPR12_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR12_PRI_3_Pos)              /*!< PPB NVIC_IPR12: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR13  ------------------------------- */
#define PPB_NVIC_IPR13_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR13: PRI_0 Position          */
#define PPB_NVIC_IPR13_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_0_Pos)              /*!< PPB NVIC_IPR13: PRI_0 Mask              */
#define PPB_NVIC_IPR13_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR13: PRI_1 Position          */
#define PPB_NVIC_IPR13_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_1_Pos)              /*!< PPB NVIC_IPR13: PRI_1 Mask              */
#define PPB_NVIC_IPR13_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR13: PRI_2 Position          */
#define PPB_NVIC_IPR13_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_2_Pos)              /*!< PPB NVIC_IPR13: PRI_2 Mask              */
#define PPB_NVIC_IPR13_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR13: PRI_3 Position          */
#define PPB_NVIC_IPR13_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR13_PRI_3_Pos)              /*!< PPB NVIC_IPR13: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR14  ------------------------------- */
#define PPB_NVIC_IPR14_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR14: PRI_0 Position          */
#define PPB_NVIC_IPR14_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_0_Pos)              /*!< PPB NVIC_IPR14: PRI_0 Mask              */
#define PPB_NVIC_IPR14_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR14: PRI_1 Position          */
#define PPB_NVIC_IPR14_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_1_Pos)              /*!< PPB NVIC_IPR14: PRI_1 Mask              */
#define PPB_NVIC_IPR14_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR14: PRI_2 Position          */
#define PPB_NVIC_IPR14_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_2_Pos)              /*!< PPB NVIC_IPR14: PRI_2 Mask              */
#define PPB_NVIC_IPR14_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR14: PRI_3 Position          */
#define PPB_NVIC_IPR14_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR14_PRI_3_Pos)              /*!< PPB NVIC_IPR14: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR15  ------------------------------- */
#define PPB_NVIC_IPR15_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR15: PRI_0 Position          */
#define PPB_NVIC_IPR15_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_0_Pos)              /*!< PPB NVIC_IPR15: PRI_0 Mask              */
#define PPB_NVIC_IPR15_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR15: PRI_1 Position          */
#define PPB_NVIC_IPR15_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_1_Pos)              /*!< PPB NVIC_IPR15: PRI_1 Mask              */
#define PPB_NVIC_IPR15_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR15: PRI_2 Position          */
#define PPB_NVIC_IPR15_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_2_Pos)              /*!< PPB NVIC_IPR15: PRI_2 Mask              */
#define PPB_NVIC_IPR15_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR15: PRI_3 Position          */
#define PPB_NVIC_IPR15_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR15_PRI_3_Pos)              /*!< PPB NVIC_IPR15: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR16  ------------------------------- */
#define PPB_NVIC_IPR16_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR16: PRI_0 Position          */
#define PPB_NVIC_IPR16_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_0_Pos)              /*!< PPB NVIC_IPR16: PRI_0 Mask              */
#define PPB_NVIC_IPR16_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR16: PRI_1 Position          */
#define PPB_NVIC_IPR16_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_1_Pos)              /*!< PPB NVIC_IPR16: PRI_1 Mask              */
#define PPB_NVIC_IPR16_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR16: PRI_2 Position          */
#define PPB_NVIC_IPR16_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_2_Pos)              /*!< PPB NVIC_IPR16: PRI_2 Mask              */
#define PPB_NVIC_IPR16_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR16: PRI_3 Position          */
#define PPB_NVIC_IPR16_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR16_PRI_3_Pos)              /*!< PPB NVIC_IPR16: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR17  ------------------------------- */
#define PPB_NVIC_IPR17_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR17: PRI_0 Position          */
#define PPB_NVIC_IPR17_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_0_Pos)              /*!< PPB NVIC_IPR17: PRI_0 Mask              */
#define PPB_NVIC_IPR17_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR17: PRI_1 Position          */
#define PPB_NVIC_IPR17_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_1_Pos)              /*!< PPB NVIC_IPR17: PRI_1 Mask              */
#define PPB_NVIC_IPR17_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR17: PRI_2 Position          */
#define PPB_NVIC_IPR17_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_2_Pos)              /*!< PPB NVIC_IPR17: PRI_2 Mask              */
#define PPB_NVIC_IPR17_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR17: PRI_3 Position          */
#define PPB_NVIC_IPR17_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR17_PRI_3_Pos)              /*!< PPB NVIC_IPR17: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR18  ------------------------------- */
#define PPB_NVIC_IPR18_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR18: PRI_0 Position          */
#define PPB_NVIC_IPR18_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_0_Pos)              /*!< PPB NVIC_IPR18: PRI_0 Mask              */
#define PPB_NVIC_IPR18_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR18: PRI_1 Position          */
#define PPB_NVIC_IPR18_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_1_Pos)              /*!< PPB NVIC_IPR18: PRI_1 Mask              */
#define PPB_NVIC_IPR18_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR18: PRI_2 Position          */
#define PPB_NVIC_IPR18_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_2_Pos)              /*!< PPB NVIC_IPR18: PRI_2 Mask              */
#define PPB_NVIC_IPR18_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR18: PRI_3 Position          */
#define PPB_NVIC_IPR18_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR18_PRI_3_Pos)              /*!< PPB NVIC_IPR18: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR19  ------------------------------- */
#define PPB_NVIC_IPR19_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR19: PRI_0 Position          */
#define PPB_NVIC_IPR19_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_0_Pos)              /*!< PPB NVIC_IPR19: PRI_0 Mask              */
#define PPB_NVIC_IPR19_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR19: PRI_1 Position          */
#define PPB_NVIC_IPR19_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_1_Pos)              /*!< PPB NVIC_IPR19: PRI_1 Mask              */
#define PPB_NVIC_IPR19_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR19: PRI_2 Position          */
#define PPB_NVIC_IPR19_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_2_Pos)              /*!< PPB NVIC_IPR19: PRI_2 Mask              */
#define PPB_NVIC_IPR19_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR19: PRI_3 Position          */
#define PPB_NVIC_IPR19_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR19_PRI_3_Pos)              /*!< PPB NVIC_IPR19: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR20  ------------------------------- */
#define PPB_NVIC_IPR20_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR20: PRI_0 Position          */
#define PPB_NVIC_IPR20_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_0_Pos)              /*!< PPB NVIC_IPR20: PRI_0 Mask              */
#define PPB_NVIC_IPR20_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR20: PRI_1 Position          */
#define PPB_NVIC_IPR20_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_1_Pos)              /*!< PPB NVIC_IPR20: PRI_1 Mask              */
#define PPB_NVIC_IPR20_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR20: PRI_2 Position          */
#define PPB_NVIC_IPR20_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_2_Pos)              /*!< PPB NVIC_IPR20: PRI_2 Mask              */
#define PPB_NVIC_IPR20_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR20: PRI_3 Position          */
#define PPB_NVIC_IPR20_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR20_PRI_3_Pos)              /*!< PPB NVIC_IPR20: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR21  ------------------------------- */
#define PPB_NVIC_IPR21_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR21: PRI_0 Position          */
#define PPB_NVIC_IPR21_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_0_Pos)              /*!< PPB NVIC_IPR21: PRI_0 Mask              */
#define PPB_NVIC_IPR21_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR21: PRI_1 Position          */
#define PPB_NVIC_IPR21_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_1_Pos)              /*!< PPB NVIC_IPR21: PRI_1 Mask              */
#define PPB_NVIC_IPR21_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR21: PRI_2 Position          */
#define PPB_NVIC_IPR21_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_2_Pos)              /*!< PPB NVIC_IPR21: PRI_2 Mask              */
#define PPB_NVIC_IPR21_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR21: PRI_3 Position          */
#define PPB_NVIC_IPR21_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR21_PRI_3_Pos)              /*!< PPB NVIC_IPR21: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR22  ------------------------------- */
#define PPB_NVIC_IPR22_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR22: PRI_0 Position          */
#define PPB_NVIC_IPR22_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_0_Pos)              /*!< PPB NVIC_IPR22: PRI_0 Mask              */
#define PPB_NVIC_IPR22_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR22: PRI_1 Position          */
#define PPB_NVIC_IPR22_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_1_Pos)              /*!< PPB NVIC_IPR22: PRI_1 Mask              */
#define PPB_NVIC_IPR22_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR22: PRI_2 Position          */
#define PPB_NVIC_IPR22_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_2_Pos)              /*!< PPB NVIC_IPR22: PRI_2 Mask              */
#define PPB_NVIC_IPR22_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR22: PRI_3 Position          */
#define PPB_NVIC_IPR22_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR22_PRI_3_Pos)              /*!< PPB NVIC_IPR22: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR23  ------------------------------- */
#define PPB_NVIC_IPR23_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR23: PRI_0 Position          */
#define PPB_NVIC_IPR23_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_0_Pos)              /*!< PPB NVIC_IPR23: PRI_0 Mask              */
#define PPB_NVIC_IPR23_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR23: PRI_1 Position          */
#define PPB_NVIC_IPR23_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_1_Pos)              /*!< PPB NVIC_IPR23: PRI_1 Mask              */
#define PPB_NVIC_IPR23_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR23: PRI_2 Position          */
#define PPB_NVIC_IPR23_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_2_Pos)              /*!< PPB NVIC_IPR23: PRI_2 Mask              */
#define PPB_NVIC_IPR23_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR23: PRI_3 Position          */
#define PPB_NVIC_IPR23_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR23_PRI_3_Pos)              /*!< PPB NVIC_IPR23: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR24  ------------------------------- */
#define PPB_NVIC_IPR24_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR24: PRI_0 Position          */
#define PPB_NVIC_IPR24_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_0_Pos)              /*!< PPB NVIC_IPR24: PRI_0 Mask              */
#define PPB_NVIC_IPR24_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR24: PRI_1 Position          */
#define PPB_NVIC_IPR24_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_1_Pos)              /*!< PPB NVIC_IPR24: PRI_1 Mask              */
#define PPB_NVIC_IPR24_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR24: PRI_2 Position          */
#define PPB_NVIC_IPR24_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_2_Pos)              /*!< PPB NVIC_IPR24: PRI_2 Mask              */
#define PPB_NVIC_IPR24_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR24: PRI_3 Position          */
#define PPB_NVIC_IPR24_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR24_PRI_3_Pos)              /*!< PPB NVIC_IPR24: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR25  ------------------------------- */
#define PPB_NVIC_IPR25_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR25: PRI_0 Position          */
#define PPB_NVIC_IPR25_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_0_Pos)              /*!< PPB NVIC_IPR25: PRI_0 Mask              */
#define PPB_NVIC_IPR25_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR25: PRI_1 Position          */
#define PPB_NVIC_IPR25_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_1_Pos)              /*!< PPB NVIC_IPR25: PRI_1 Mask              */
#define PPB_NVIC_IPR25_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR25: PRI_2 Position          */
#define PPB_NVIC_IPR25_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_2_Pos)              /*!< PPB NVIC_IPR25: PRI_2 Mask              */
#define PPB_NVIC_IPR25_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR25: PRI_3 Position          */
#define PPB_NVIC_IPR25_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR25_PRI_3_Pos)              /*!< PPB NVIC_IPR25: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR26  ------------------------------- */
#define PPB_NVIC_IPR26_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR26: PRI_0 Position          */
#define PPB_NVIC_IPR26_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_0_Pos)              /*!< PPB NVIC_IPR26: PRI_0 Mask              */
#define PPB_NVIC_IPR26_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR26: PRI_1 Position          */
#define PPB_NVIC_IPR26_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_1_Pos)              /*!< PPB NVIC_IPR26: PRI_1 Mask              */
#define PPB_NVIC_IPR26_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR26: PRI_2 Position          */
#define PPB_NVIC_IPR26_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_2_Pos)              /*!< PPB NVIC_IPR26: PRI_2 Mask              */
#define PPB_NVIC_IPR26_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR26: PRI_3 Position          */
#define PPB_NVIC_IPR26_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR26_PRI_3_Pos)              /*!< PPB NVIC_IPR26: PRI_3 Mask              */

/* -------------------------------  PPB_NVIC_IPR27  ------------------------------- */
#define PPB_NVIC_IPR27_PRI_0_Pos              0                                                       /*!< PPB NVIC_IPR27: PRI_0 Position          */
#define PPB_NVIC_IPR27_PRI_0_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_0_Pos)              /*!< PPB NVIC_IPR27: PRI_0 Mask              */
#define PPB_NVIC_IPR27_PRI_1_Pos              8                                                       /*!< PPB NVIC_IPR27: PRI_1 Position          */
#define PPB_NVIC_IPR27_PRI_1_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_1_Pos)              /*!< PPB NVIC_IPR27: PRI_1 Mask              */
#define PPB_NVIC_IPR27_PRI_2_Pos              16                                                      /*!< PPB NVIC_IPR27: PRI_2 Position          */
#define PPB_NVIC_IPR27_PRI_2_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_2_Pos)              /*!< PPB NVIC_IPR27: PRI_2 Mask              */
#define PPB_NVIC_IPR27_PRI_3_Pos              24                                                      /*!< PPB NVIC_IPR27: PRI_3 Position          */
#define PPB_NVIC_IPR27_PRI_3_Msk              (0x000000ffUL << PPB_NVIC_IPR27_PRI_3_Pos)              /*!< PPB NVIC_IPR27: PRI_3 Mask              */

/* ----------------------------------  PPB_CPUID  --------------------------------- */
#define PPB_CPUID_Revision_Pos                0                                                       /*!< PPB CPUID: Revision Position            */
#define PPB_CPUID_Revision_Msk                (0x0fUL << PPB_CPUID_Revision_Pos)                      /*!< PPB CPUID: Revision Mask                */
#define PPB_CPUID_PartNo_Pos                  4                                                       /*!< PPB CPUID: PartNo Position              */
#define PPB_CPUID_PartNo_Msk                  (0x00000fffUL << PPB_CPUID_PartNo_Pos)                  /*!< PPB CPUID: PartNo Mask                  */
#define PPB_CPUID_Constant_Pos                16                                                      /*!< PPB CPUID: Constant Position            */
#define PPB_CPUID_Constant_Msk                (0x0fUL << PPB_CPUID_Constant_Pos)                      /*!< PPB CPUID: Constant Mask                */
#define PPB_CPUID_Variant_Pos                 20                                                      /*!< PPB CPUID: Variant Position             */
#define PPB_CPUID_Variant_Msk                 (0x0fUL << PPB_CPUID_Variant_Pos)                       /*!< PPB CPUID: Variant Mask                 */
#define PPB_CPUID_Implementer_Pos             24                                                      /*!< PPB CPUID: Implementer Position         */
#define PPB_CPUID_Implementer_Msk             (0x000000ffUL << PPB_CPUID_Implementer_Pos)             /*!< PPB CPUID: Implementer Mask             */

/* ----------------------------------  PPB_ICSR  ---------------------------------- */
#define PPB_ICSR_VECTACTIVE_Pos               0                                                       /*!< PPB ICSR: VECTACTIVE Position           */
#define PPB_ICSR_VECTACTIVE_Msk               (0x000001ffUL << PPB_ICSR_VECTACTIVE_Pos)               /*!< PPB ICSR: VECTACTIVE Mask               */
#define PPB_ICSR_RETTOBASE_Pos                11                                                      /*!< PPB ICSR: RETTOBASE Position            */
#define PPB_ICSR_RETTOBASE_Msk                (0x01UL << PPB_ICSR_RETTOBASE_Pos)                      /*!< PPB ICSR: RETTOBASE Mask                */
#define PPB_ICSR_VECTPENDING_Pos              12                                                      /*!< PPB ICSR: VECTPENDING Position          */
#define PPB_ICSR_VECTPENDING_Msk              (0x3fUL << PPB_ICSR_VECTPENDING_Pos)                    /*!< PPB ICSR: VECTPENDING Mask              */
#define PPB_ICSR_ISRPENDING_Pos               22                                                      /*!< PPB ICSR: ISRPENDING Position           */
#define PPB_ICSR_ISRPENDING_Msk               (0x01UL << PPB_ICSR_ISRPENDING_Pos)                     /*!< PPB ICSR: ISRPENDING Mask               */
#define PPB_ICSR_Res_Pos                      23                                                      /*!< PPB ICSR: Res Position                  */
#define PPB_ICSR_Res_Msk                      (0x01UL << PPB_ICSR_Res_Pos)                            /*!< PPB ICSR: Res Mask                      */
#define PPB_ICSR_PENDSTCLR_Pos                25                                                      /*!< PPB ICSR: PENDSTCLR Position            */
#define PPB_ICSR_PENDSTCLR_Msk                (0x01UL << PPB_ICSR_PENDSTCLR_Pos)                      /*!< PPB ICSR: PENDSTCLR Mask                */
#define PPB_ICSR_PENDSTSET_Pos                26                                                      /*!< PPB ICSR: PENDSTSET Position            */
#define PPB_ICSR_PENDSTSET_Msk                (0x01UL << PPB_ICSR_PENDSTSET_Pos)                      /*!< PPB ICSR: PENDSTSET Mask                */
#define PPB_ICSR_PENDSVCLR_Pos                27                                                      /*!< PPB ICSR: PENDSVCLR Position            */
#define PPB_ICSR_PENDSVCLR_Msk                (0x01UL << PPB_ICSR_PENDSVCLR_Pos)                      /*!< PPB ICSR: PENDSVCLR Mask                */
#define PPB_ICSR_PENDSVSET_Pos                28                                                      /*!< PPB ICSR: PENDSVSET Position            */
#define PPB_ICSR_PENDSVSET_Msk                (0x01UL << PPB_ICSR_PENDSVSET_Pos)                      /*!< PPB ICSR: PENDSVSET Mask                */
#define PPB_ICSR_NMIPENDSET_Pos               31                                                      /*!< PPB ICSR: NMIPENDSET Position           */
#define PPB_ICSR_NMIPENDSET_Msk               (0x01UL << PPB_ICSR_NMIPENDSET_Pos)                     /*!< PPB ICSR: NMIPENDSET Mask               */

/* ----------------------------------  PPB_VTOR  ---------------------------------- */
#define PPB_VTOR_TBLOFF_Pos                   10                                                      /*!< PPB VTOR: TBLOFF Position               */
#define PPB_VTOR_TBLOFF_Msk                   (0x003fffffUL << PPB_VTOR_TBLOFF_Pos)                   /*!< PPB VTOR: TBLOFF Mask                   */

/* ----------------------------------  PPB_AIRCR  --------------------------------- */
#define PPB_AIRCR_VECTRESET_Pos               0                                                       /*!< PPB AIRCR: VECTRESET Position           */
#define PPB_AIRCR_VECTRESET_Msk               (0x01UL << PPB_AIRCR_VECTRESET_Pos)                     /*!< PPB AIRCR: VECTRESET Mask               */
#define PPB_AIRCR_VECTCLRACTIVE_Pos           1                                                       /*!< PPB AIRCR: VECTCLRACTIVE Position       */
#define PPB_AIRCR_VECTCLRACTIVE_Msk           (0x01UL << PPB_AIRCR_VECTCLRACTIVE_Pos)                 /*!< PPB AIRCR: VECTCLRACTIVE Mask           */
#define PPB_AIRCR_SYSRESETREQ_Pos             2                                                       /*!< PPB AIRCR: SYSRESETREQ Position         */
#define PPB_AIRCR_SYSRESETREQ_Msk             (0x01UL << PPB_AIRCR_SYSRESETREQ_Pos)                   /*!< PPB AIRCR: SYSRESETREQ Mask             */
#define PPB_AIRCR_PRIGROUP_Pos                8                                                       /*!< PPB AIRCR: PRIGROUP Position            */
#define PPB_AIRCR_PRIGROUP_Msk                (0x07UL << PPB_AIRCR_PRIGROUP_Pos)                      /*!< PPB AIRCR: PRIGROUP Mask                */
#define PPB_AIRCR_ENDIANNESS_Pos              15                                                      /*!< PPB AIRCR: ENDIANNESS Position          */
#define PPB_AIRCR_ENDIANNESS_Msk              (0x01UL << PPB_AIRCR_ENDIANNESS_Pos)                    /*!< PPB AIRCR: ENDIANNESS Mask              */
#define PPB_AIRCR_VECTKEY_Pos                 16                                                      /*!< PPB AIRCR: VECTKEY Position             */
#define PPB_AIRCR_VECTKEY_Msk                 (0x0000ffffUL << PPB_AIRCR_VECTKEY_Pos)                 /*!< PPB AIRCR: VECTKEY Mask                 */

/* -----------------------------------  PPB_SCR  ---------------------------------- */
#define PPB_SCR_SLEEPONEXIT_Pos               1                                                       /*!< PPB SCR: SLEEPONEXIT Position           */
#define PPB_SCR_SLEEPONEXIT_Msk               (0x01UL << PPB_SCR_SLEEPONEXIT_Pos)                     /*!< PPB SCR: SLEEPONEXIT Mask               */
#define PPB_SCR_SLEEPDEEP_Pos                 2                                                       /*!< PPB SCR: SLEEPDEEP Position             */
#define PPB_SCR_SLEEPDEEP_Msk                 (0x01UL << PPB_SCR_SLEEPDEEP_Pos)                       /*!< PPB SCR: SLEEPDEEP Mask                 */
#define PPB_SCR_SEVONPEND_Pos                 4                                                       /*!< PPB SCR: SEVONPEND Position             */
#define PPB_SCR_SEVONPEND_Msk                 (0x01UL << PPB_SCR_SEVONPEND_Pos)                       /*!< PPB SCR: SEVONPEND Mask                 */

/* -----------------------------------  PPB_CCR  ---------------------------------- */
#define PPB_CCR_NONBASETHRDENA_Pos            0                                                       /*!< PPB CCR: NONBASETHRDENA Position        */
#define PPB_CCR_NONBASETHRDENA_Msk            (0x01UL << PPB_CCR_NONBASETHRDENA_Pos)                  /*!< PPB CCR: NONBASETHRDENA Mask            */
#define PPB_CCR_USERSETMPEND_Pos              1                                                       /*!< PPB CCR: USERSETMPEND Position          */
#define PPB_CCR_USERSETMPEND_Msk              (0x01UL << PPB_CCR_USERSETMPEND_Pos)                    /*!< PPB CCR: USERSETMPEND Mask              */
#define PPB_CCR_UNALIGN_TRP_Pos               3                                                       /*!< PPB CCR: UNALIGN_TRP Position           */
#define PPB_CCR_UNALIGN_TRP_Msk               (0x01UL << PPB_CCR_UNALIGN_TRP_Pos)                     /*!< PPB CCR: UNALIGN_TRP Mask               */
#define PPB_CCR_DIV_0_TRP_Pos                 4                                                       /*!< PPB CCR: DIV_0_TRP Position             */
#define PPB_CCR_DIV_0_TRP_Msk                 (0x01UL << PPB_CCR_DIV_0_TRP_Pos)                       /*!< PPB CCR: DIV_0_TRP Mask                 */
#define PPB_CCR_BFHFNMIGN_Pos                 8                                                       /*!< PPB CCR: BFHFNMIGN Position             */
#define PPB_CCR_BFHFNMIGN_Msk                 (0x01UL << PPB_CCR_BFHFNMIGN_Pos)                       /*!< PPB CCR: BFHFNMIGN Mask                 */
#define PPB_CCR_STKALIGN_Pos                  9                                                       /*!< PPB CCR: STKALIGN Position              */
#define PPB_CCR_STKALIGN_Msk                  (0x01UL << PPB_CCR_STKALIGN_Pos)                        /*!< PPB CCR: STKALIGN Mask                  */

/* ----------------------------------  PPB_SHPR1  --------------------------------- */
#define PPB_SHPR1_PRI_4_Pos                   0                                                       /*!< PPB SHPR1: PRI_4 Position               */
#define PPB_SHPR1_PRI_4_Msk                   (0x000000ffUL << PPB_SHPR1_PRI_4_Pos)                   /*!< PPB SHPR1: PRI_4 Mask                   */
#define PPB_SHPR1_PRI_5_Pos                   8                                                       /*!< PPB SHPR1: PRI_5 Position               */
#define PPB_SHPR1_PRI_5_Msk                   (0x000000ffUL << PPB_SHPR1_PRI_5_Pos)                   /*!< PPB SHPR1: PRI_5 Mask                   */
#define PPB_SHPR1_PRI_6_Pos                   16                                                      /*!< PPB SHPR1: PRI_6 Position               */
#define PPB_SHPR1_PRI_6_Msk                   (0x000000ffUL << PPB_SHPR1_PRI_6_Pos)                   /*!< PPB SHPR1: PRI_6 Mask                   */

/* ----------------------------------  PPB_SHPR2  --------------------------------- */
#define PPB_SHPR2_PRI_11_Pos                  24                                                      /*!< PPB SHPR2: PRI_11 Position              */
#define PPB_SHPR2_PRI_11_Msk                  (0x000000ffUL << PPB_SHPR2_PRI_11_Pos)                  /*!< PPB SHPR2: PRI_11 Mask                  */

/* ----------------------------------  PPB_SHPR3  --------------------------------- */
#define PPB_SHPR3_PRI_14_Pos                  16                                                      /*!< PPB SHPR3: PRI_14 Position              */
#define PPB_SHPR3_PRI_14_Msk                  (0x000000ffUL << PPB_SHPR3_PRI_14_Pos)                  /*!< PPB SHPR3: PRI_14 Mask                  */
#define PPB_SHPR3_PRI_15_Pos                  24                                                      /*!< PPB SHPR3: PRI_15 Position              */
#define PPB_SHPR3_PRI_15_Msk                  (0x000000ffUL << PPB_SHPR3_PRI_15_Pos)                  /*!< PPB SHPR3: PRI_15 Mask                  */

/* ----------------------------------  PPB_SHCSR  --------------------------------- */
#define PPB_SHCSR_MEMFAULTACT_Pos             0                                                       /*!< PPB SHCSR: MEMFAULTACT Position         */
#define PPB_SHCSR_MEMFAULTACT_Msk             (0x01UL << PPB_SHCSR_MEMFAULTACT_Pos)                   /*!< PPB SHCSR: MEMFAULTACT Mask             */
#define PPB_SHCSR_BUSFAULTACT_Pos             1                                                       /*!< PPB SHCSR: BUSFAULTACT Position         */
#define PPB_SHCSR_BUSFAULTACT_Msk             (0x01UL << PPB_SHCSR_BUSFAULTACT_Pos)                   /*!< PPB SHCSR: BUSFAULTACT Mask             */
#define PPB_SHCSR_USGFAULTACT_Pos             3                                                       /*!< PPB SHCSR: USGFAULTACT Position         */
#define PPB_SHCSR_USGFAULTACT_Msk             (0x01UL << PPB_SHCSR_USGFAULTACT_Pos)                   /*!< PPB SHCSR: USGFAULTACT Mask             */
#define PPB_SHCSR_SVCALLACT_Pos               7                                                       /*!< PPB SHCSR: SVCALLACT Position           */
#define PPB_SHCSR_SVCALLACT_Msk               (0x01UL << PPB_SHCSR_SVCALLACT_Pos)                     /*!< PPB SHCSR: SVCALLACT Mask               */
#define PPB_SHCSR_MONITORACT_Pos              8                                                       /*!< PPB SHCSR: MONITORACT Position          */
#define PPB_SHCSR_MONITORACT_Msk              (0x01UL << PPB_SHCSR_MONITORACT_Pos)                    /*!< PPB SHCSR: MONITORACT Mask              */
#define PPB_SHCSR_PENDSVACT_Pos               10                                                      /*!< PPB SHCSR: PENDSVACT Position           */
#define PPB_SHCSR_PENDSVACT_Msk               (0x01UL << PPB_SHCSR_PENDSVACT_Pos)                     /*!< PPB SHCSR: PENDSVACT Mask               */
#define PPB_SHCSR_SYSTICKACT_Pos              11                                                      /*!< PPB SHCSR: SYSTICKACT Position          */
#define PPB_SHCSR_SYSTICKACT_Msk              (0x01UL << PPB_SHCSR_SYSTICKACT_Pos)                    /*!< PPB SHCSR: SYSTICKACT Mask              */
#define PPB_SHCSR_USGFAULTPENDED_Pos          12                                                      /*!< PPB SHCSR: USGFAULTPENDED Position      */
#define PPB_SHCSR_USGFAULTPENDED_Msk          (0x01UL << PPB_SHCSR_USGFAULTPENDED_Pos)                /*!< PPB SHCSR: USGFAULTPENDED Mask          */
#define PPB_SHCSR_MEMFAULTPENDED_Pos          13                                                      /*!< PPB SHCSR: MEMFAULTPENDED Position      */
#define PPB_SHCSR_MEMFAULTPENDED_Msk          (0x01UL << PPB_SHCSR_MEMFAULTPENDED_Pos)                /*!< PPB SHCSR: MEMFAULTPENDED Mask          */
#define PPB_SHCSR_BUSFAULTPENDED_Pos          14                                                      /*!< PPB SHCSR: BUSFAULTPENDED Position      */
#define PPB_SHCSR_BUSFAULTPENDED_Msk          (0x01UL << PPB_SHCSR_BUSFAULTPENDED_Pos)                /*!< PPB SHCSR: BUSFAULTPENDED Mask          */
#define PPB_SHCSR_SVCALLPENDED_Pos            15                                                      /*!< PPB SHCSR: SVCALLPENDED Position        */
#define PPB_SHCSR_SVCALLPENDED_Msk            (0x01UL << PPB_SHCSR_SVCALLPENDED_Pos)                  /*!< PPB SHCSR: SVCALLPENDED Mask            */
#define PPB_SHCSR_MEMFAULTENA_Pos             16                                                      /*!< PPB SHCSR: MEMFAULTENA Position         */
#define PPB_SHCSR_MEMFAULTENA_Msk             (0x01UL << PPB_SHCSR_MEMFAULTENA_Pos)                   /*!< PPB SHCSR: MEMFAULTENA Mask             */
#define PPB_SHCSR_BUSFAULTENA_Pos             17                                                      /*!< PPB SHCSR: BUSFAULTENA Position         */
#define PPB_SHCSR_BUSFAULTENA_Msk             (0x01UL << PPB_SHCSR_BUSFAULTENA_Pos)                   /*!< PPB SHCSR: BUSFAULTENA Mask             */
#define PPB_SHCSR_USGFAULTENA_Pos             18                                                      /*!< PPB SHCSR: USGFAULTENA Position         */
#define PPB_SHCSR_USGFAULTENA_Msk             (0x01UL << PPB_SHCSR_USGFAULTENA_Pos)                   /*!< PPB SHCSR: USGFAULTENA Mask             */

/* ----------------------------------  PPB_CFSR  ---------------------------------- */
#define PPB_CFSR_IACCVIOL_Pos                 0                                                       /*!< PPB CFSR: IACCVIOL Position             */
#define PPB_CFSR_IACCVIOL_Msk                 (0x01UL << PPB_CFSR_IACCVIOL_Pos)                       /*!< PPB CFSR: IACCVIOL Mask                 */
#define PPB_CFSR_DACCVIOL_Pos                 1                                                       /*!< PPB CFSR: DACCVIOL Position             */
#define PPB_CFSR_DACCVIOL_Msk                 (0x01UL << PPB_CFSR_DACCVIOL_Pos)                       /*!< PPB CFSR: DACCVIOL Mask                 */
#define PPB_CFSR_MUNSTKERR_Pos                3                                                       /*!< PPB CFSR: MUNSTKERR Position            */
#define PPB_CFSR_MUNSTKERR_Msk                (0x01UL << PPB_CFSR_MUNSTKERR_Pos)                      /*!< PPB CFSR: MUNSTKERR Mask                */
#define PPB_CFSR_MSTKERR_Pos                  4                                                       /*!< PPB CFSR: MSTKERR Position              */
#define PPB_CFSR_MSTKERR_Msk                  (0x01UL << PPB_CFSR_MSTKERR_Pos)                        /*!< PPB CFSR: MSTKERR Mask                  */
#define PPB_CFSR_MLSPERR_Pos                  5                                                       /*!< PPB CFSR: MLSPERR Position              */
#define PPB_CFSR_MLSPERR_Msk                  (0x01UL << PPB_CFSR_MLSPERR_Pos)                        /*!< PPB CFSR: MLSPERR Mask                  */
#define PPB_CFSR_MMARVALID_Pos                7                                                       /*!< PPB CFSR: MMARVALID Position            */
#define PPB_CFSR_MMARVALID_Msk                (0x01UL << PPB_CFSR_MMARVALID_Pos)                      /*!< PPB CFSR: MMARVALID Mask                */
#define PPB_CFSR_IBUSERR_Pos                  8                                                       /*!< PPB CFSR: IBUSERR Position              */
#define PPB_CFSR_IBUSERR_Msk                  (0x01UL << PPB_CFSR_IBUSERR_Pos)                        /*!< PPB CFSR: IBUSERR Mask                  */
#define PPB_CFSR_PRECISERR_Pos                9                                                       /*!< PPB CFSR: PRECISERR Position            */
#define PPB_CFSR_PRECISERR_Msk                (0x01UL << PPB_CFSR_PRECISERR_Pos)                      /*!< PPB CFSR: PRECISERR Mask                */
#define PPB_CFSR_IMPRECISERR_Pos              10                                                      /*!< PPB CFSR: IMPRECISERR Position          */
#define PPB_CFSR_IMPRECISERR_Msk              (0x01UL << PPB_CFSR_IMPRECISERR_Pos)                    /*!< PPB CFSR: IMPRECISERR Mask              */
#define PPB_CFSR_UNSTKERR_Pos                 11                                                      /*!< PPB CFSR: UNSTKERR Position             */
#define PPB_CFSR_UNSTKERR_Msk                 (0x01UL << PPB_CFSR_UNSTKERR_Pos)                       /*!< PPB CFSR: UNSTKERR Mask                 */
#define PPB_CFSR_STKERR_Pos                   12                                                      /*!< PPB CFSR: STKERR Position               */
#define PPB_CFSR_STKERR_Msk                   (0x01UL << PPB_CFSR_STKERR_Pos)                         /*!< PPB CFSR: STKERR Mask                   */
#define PPB_CFSR_LSPERR_Pos                   13                                                      /*!< PPB CFSR: LSPERR Position               */
#define PPB_CFSR_LSPERR_Msk                   (0x01UL << PPB_CFSR_LSPERR_Pos)                         /*!< PPB CFSR: LSPERR Mask                   */
#define PPB_CFSR_BFARVALID_Pos                15                                                      /*!< PPB CFSR: BFARVALID Position            */
#define PPB_CFSR_BFARVALID_Msk                (0x01UL << PPB_CFSR_BFARVALID_Pos)                      /*!< PPB CFSR: BFARVALID Mask                */
#define PPB_CFSR_UNDEFINSTR_Pos               16                                                      /*!< PPB CFSR: UNDEFINSTR Position           */
#define PPB_CFSR_UNDEFINSTR_Msk               (0x01UL << PPB_CFSR_UNDEFINSTR_Pos)                     /*!< PPB CFSR: UNDEFINSTR Mask               */
#define PPB_CFSR_INVSTATE_Pos                 17                                                      /*!< PPB CFSR: INVSTATE Position             */
#define PPB_CFSR_INVSTATE_Msk                 (0x01UL << PPB_CFSR_INVSTATE_Pos)                       /*!< PPB CFSR: INVSTATE Mask                 */
#define PPB_CFSR_INVPC_Pos                    18                                                      /*!< PPB CFSR: INVPC Position                */
#define PPB_CFSR_INVPC_Msk                    (0x01UL << PPB_CFSR_INVPC_Pos)                          /*!< PPB CFSR: INVPC Mask                    */
#define PPB_CFSR_NOCP_Pos                     19                                                      /*!< PPB CFSR: NOCP Position                 */
#define PPB_CFSR_NOCP_Msk                     (0x01UL << PPB_CFSR_NOCP_Pos)                           /*!< PPB CFSR: NOCP Mask                     */
#define PPB_CFSR_UNALIGNED_Pos                24                                                      /*!< PPB CFSR: UNALIGNED Position            */
#define PPB_CFSR_UNALIGNED_Msk                (0x01UL << PPB_CFSR_UNALIGNED_Pos)                      /*!< PPB CFSR: UNALIGNED Mask                */
#define PPB_CFSR_DIVBYZERO_Pos                25                                                      /*!< PPB CFSR: DIVBYZERO Position            */
#define PPB_CFSR_DIVBYZERO_Msk                (0x01UL << PPB_CFSR_DIVBYZERO_Pos)                      /*!< PPB CFSR: DIVBYZERO Mask                */

/* ----------------------------------  PPB_HFSR  ---------------------------------- */
#define PPB_HFSR_VECTTBL_Pos                  1                                                       /*!< PPB HFSR: VECTTBL Position              */
#define PPB_HFSR_VECTTBL_Msk                  (0x01UL << PPB_HFSR_VECTTBL_Pos)                        /*!< PPB HFSR: VECTTBL Mask                  */
#define PPB_HFSR_FORCED_Pos                   30                                                      /*!< PPB HFSR: FORCED Position               */
#define PPB_HFSR_FORCED_Msk                   (0x01UL << PPB_HFSR_FORCED_Pos)                         /*!< PPB HFSR: FORCED Mask                   */
#define PPB_HFSR_DEBUGEVT_Pos                 31                                                      /*!< PPB HFSR: DEBUGEVT Position             */
#define PPB_HFSR_DEBUGEVT_Msk                 (0x01UL << PPB_HFSR_DEBUGEVT_Pos)                       /*!< PPB HFSR: DEBUGEVT Mask                 */

/* ----------------------------------  PPB_MMFAR  --------------------------------- */
#define PPB_MMFAR_ADDRESS_Pos                 0                                                       /*!< PPB MMFAR: ADDRESS Position             */
#define PPB_MMFAR_ADDRESS_Msk                 (0xffffffffUL << PPB_MMFAR_ADDRESS_Pos)                 /*!< PPB MMFAR: ADDRESS Mask                 */

/* ----------------------------------  PPB_BFAR  ---------------------------------- */
#define PPB_BFAR_ADDRESS_Pos                  0                                                       /*!< PPB BFAR: ADDRESS Position              */
#define PPB_BFAR_ADDRESS_Msk                  (0xffffffffUL << PPB_BFAR_ADDRESS_Pos)                  /*!< PPB BFAR: ADDRESS Mask                  */

/* ----------------------------------  PPB_AFSR  ---------------------------------- */
#define PPB_AFSR_VALUE_Pos                    0                                                       /*!< PPB AFSR: VALUE Position                */
#define PPB_AFSR_VALUE_Msk                    (0xffffffffUL << PPB_AFSR_VALUE_Pos)                    /*!< PPB AFSR: VALUE Mask                    */

/* ----------------------------------  PPB_CPACR  --------------------------------- */
#define PPB_CPACR_CP10_Pos                    20                                                      /*!< PPB CPACR: CP10 Position                */
#define PPB_CPACR_CP10_Msk                    (0x03UL << PPB_CPACR_CP10_Pos)                          /*!< PPB CPACR: CP10 Mask                    */
#define PPB_CPACR_CP11_Pos                    22                                                      /*!< PPB CPACR: CP11 Position                */
#define PPB_CPACR_CP11_Msk                    (0x03UL << PPB_CPACR_CP11_Pos)                          /*!< PPB CPACR: CP11 Mask                    */

/* --------------------------------  PPB_MPU_TYPE  -------------------------------- */
#define PPB_MPU_TYPE_SEPARATE_Pos             0                                                       /*!< PPB MPU_TYPE: SEPARATE Position         */
#define PPB_MPU_TYPE_SEPARATE_Msk             (0x01UL << PPB_MPU_TYPE_SEPARATE_Pos)                   /*!< PPB MPU_TYPE: SEPARATE Mask             */
#define PPB_MPU_TYPE_DREGION_Pos              8                                                       /*!< PPB MPU_TYPE: DREGION Position          */
#define PPB_MPU_TYPE_DREGION_Msk              (0x000000ffUL << PPB_MPU_TYPE_DREGION_Pos)              /*!< PPB MPU_TYPE: DREGION Mask              */
#define PPB_MPU_TYPE_IREGION_Pos              16                                                      /*!< PPB MPU_TYPE: IREGION Position          */
#define PPB_MPU_TYPE_IREGION_Msk              (0x000000ffUL << PPB_MPU_TYPE_IREGION_Pos)              /*!< PPB MPU_TYPE: IREGION Mask              */

/* --------------------------------  PPB_MPU_CTRL  -------------------------------- */
#define PPB_MPU_CTRL_ENABLE_Pos               0                                                       /*!< PPB MPU_CTRL: ENABLE Position           */
#define PPB_MPU_CTRL_ENABLE_Msk               (0x01UL << PPB_MPU_CTRL_ENABLE_Pos)                     /*!< PPB MPU_CTRL: ENABLE Mask               */
#define PPB_MPU_CTRL_HFNMIENA_Pos             1                                                       /*!< PPB MPU_CTRL: HFNMIENA Position         */
#define PPB_MPU_CTRL_HFNMIENA_Msk             (0x01UL << PPB_MPU_CTRL_HFNMIENA_Pos)                   /*!< PPB MPU_CTRL: HFNMIENA Mask             */
#define PPB_MPU_CTRL_PRIVDEFENA_Pos           2                                                       /*!< PPB MPU_CTRL: PRIVDEFENA Position       */
#define PPB_MPU_CTRL_PRIVDEFENA_Msk           (0x01UL << PPB_MPU_CTRL_PRIVDEFENA_Pos)                 /*!< PPB MPU_CTRL: PRIVDEFENA Mask           */

/* ---------------------------------  PPB_MPU_RNR  -------------------------------- */
#define PPB_MPU_RNR_REGION_Pos                0                                                       /*!< PPB MPU_RNR: REGION Position            */
#define PPB_MPU_RNR_REGION_Msk                (0x000000ffUL << PPB_MPU_RNR_REGION_Pos)                /*!< PPB MPU_RNR: REGION Mask                */

/* --------------------------------  PPB_MPU_RBAR  -------------------------------- */
#define PPB_MPU_RBAR_REGION_Pos               0                                                       /*!< PPB MPU_RBAR: REGION Position           */
#define PPB_MPU_RBAR_REGION_Msk               (0x0fUL << PPB_MPU_RBAR_REGION_Pos)                     /*!< PPB MPU_RBAR: REGION Mask               */
#define PPB_MPU_RBAR_VALID_Pos                4                                                       /*!< PPB MPU_RBAR: VALID Position            */
#define PPB_MPU_RBAR_VALID_Msk                (0x01UL << PPB_MPU_RBAR_VALID_Pos)                      /*!< PPB MPU_RBAR: VALID Mask                */
#define PPB_MPU_RBAR_ADDR_Pos                 9                                                       /*!< PPB MPU_RBAR: ADDR Position             */
#define PPB_MPU_RBAR_ADDR_Msk                 (0x007fffffUL << PPB_MPU_RBAR_ADDR_Pos)                 /*!< PPB MPU_RBAR: ADDR Mask                 */

/* --------------------------------  PPB_MPU_RASR  -------------------------------- */
#define PPB_MPU_RASR_ENABLE_Pos               0                                                       /*!< PPB MPU_RASR: ENABLE Position           */
#define PPB_MPU_RASR_ENABLE_Msk               (0x01UL << PPB_MPU_RASR_ENABLE_Pos)                     /*!< PPB MPU_RASR: ENABLE Mask               */
#define PPB_MPU_RASR_SIZE_Pos                 1                                                       /*!< PPB MPU_RASR: SIZE Position             */
#define PPB_MPU_RASR_SIZE_Msk                 (0x1fUL << PPB_MPU_RASR_SIZE_Pos)                       /*!< PPB MPU_RASR: SIZE Mask                 */
#define PPB_MPU_RASR_SRD_Pos                  8                                                       /*!< PPB MPU_RASR: SRD Position              */
#define PPB_MPU_RASR_SRD_Msk                  (0x000000ffUL << PPB_MPU_RASR_SRD_Pos)                  /*!< PPB MPU_RASR: SRD Mask                  */
#define PPB_MPU_RASR_B_Pos                    16                                                      /*!< PPB MPU_RASR: B Position                */
#define PPB_MPU_RASR_B_Msk                    (0x01UL << PPB_MPU_RASR_B_Pos)                          /*!< PPB MPU_RASR: B Mask                    */
#define PPB_MPU_RASR_C_Pos                    17                                                      /*!< PPB MPU_RASR: C Position                */
#define PPB_MPU_RASR_C_Msk                    (0x01UL << PPB_MPU_RASR_C_Pos)                          /*!< PPB MPU_RASR: C Mask                    */
#define PPB_MPU_RASR_S_Pos                    18                                                      /*!< PPB MPU_RASR: S Position                */
#define PPB_MPU_RASR_S_Msk                    (0x01UL << PPB_MPU_RASR_S_Pos)                          /*!< PPB MPU_RASR: S Mask                    */
#define PPB_MPU_RASR_TEX_Pos                  19                                                      /*!< PPB MPU_RASR: TEX Position              */
#define PPB_MPU_RASR_TEX_Msk                  (0x07UL << PPB_MPU_RASR_TEX_Pos)                        /*!< PPB MPU_RASR: TEX Mask                  */
#define PPB_MPU_RASR_AP_Pos                   24                                                      /*!< PPB MPU_RASR: AP Position               */
#define PPB_MPU_RASR_AP_Msk                   (0x07UL << PPB_MPU_RASR_AP_Pos)                         /*!< PPB MPU_RASR: AP Mask                   */
#define PPB_MPU_RASR_XN_Pos                   28                                                      /*!< PPB MPU_RASR: XN Position               */
#define PPB_MPU_RASR_XN_Msk                   (0x01UL << PPB_MPU_RASR_XN_Pos)                         /*!< PPB MPU_RASR: XN Mask                   */

/* -------------------------------  PPB_MPU_RBAR_A1  ------------------------------ */
#define PPB_MPU_RBAR_A1_REGION_Pos            0                                                       /*!< PPB MPU_RBAR_A1: REGION Position        */
#define PPB_MPU_RBAR_A1_REGION_Msk            (0x0fUL << PPB_MPU_RBAR_A1_REGION_Pos)                  /*!< PPB MPU_RBAR_A1: REGION Mask            */
#define PPB_MPU_RBAR_A1_VALID_Pos             4                                                       /*!< PPB MPU_RBAR_A1: VALID Position         */
#define PPB_MPU_RBAR_A1_VALID_Msk             (0x01UL << PPB_MPU_RBAR_A1_VALID_Pos)                   /*!< PPB MPU_RBAR_A1: VALID Mask             */
#define PPB_MPU_RBAR_A1_ADDR_Pos              9                                                       /*!< PPB MPU_RBAR_A1: ADDR Position          */
#define PPB_MPU_RBAR_A1_ADDR_Msk              (0x007fffffUL << PPB_MPU_RBAR_A1_ADDR_Pos)              /*!< PPB MPU_RBAR_A1: ADDR Mask              */

/* -------------------------------  PPB_MPU_RASR_A1  ------------------------------ */
#define PPB_MPU_RASR_A1_ENABLE_Pos            0                                                       /*!< PPB MPU_RASR_A1: ENABLE Position        */
#define PPB_MPU_RASR_A1_ENABLE_Msk            (0x01UL << PPB_MPU_RASR_A1_ENABLE_Pos)                  /*!< PPB MPU_RASR_A1: ENABLE Mask            */
#define PPB_MPU_RASR_A1_SIZE_Pos              1                                                       /*!< PPB MPU_RASR_A1: SIZE Position          */
#define PPB_MPU_RASR_A1_SIZE_Msk              (0x1fUL << PPB_MPU_RASR_A1_SIZE_Pos)                    /*!< PPB MPU_RASR_A1: SIZE Mask              */
#define PPB_MPU_RASR_A1_SRD_Pos               8                                                       /*!< PPB MPU_RASR_A1: SRD Position           */
#define PPB_MPU_RASR_A1_SRD_Msk               (0x000000ffUL << PPB_MPU_RASR_A1_SRD_Pos)               /*!< PPB MPU_RASR_A1: SRD Mask               */
#define PPB_MPU_RASR_A1_B_Pos                 16                                                      /*!< PPB MPU_RASR_A1: B Position             */
#define PPB_MPU_RASR_A1_B_Msk                 (0x01UL << PPB_MPU_RASR_A1_B_Pos)                       /*!< PPB MPU_RASR_A1: B Mask                 */
#define PPB_MPU_RASR_A1_C_Pos                 17                                                      /*!< PPB MPU_RASR_A1: C Position             */
#define PPB_MPU_RASR_A1_C_Msk                 (0x01UL << PPB_MPU_RASR_A1_C_Pos)                       /*!< PPB MPU_RASR_A1: C Mask                 */
#define PPB_MPU_RASR_A1_S_Pos                 18                                                      /*!< PPB MPU_RASR_A1: S Position             */
#define PPB_MPU_RASR_A1_S_Msk                 (0x01UL << PPB_MPU_RASR_A1_S_Pos)                       /*!< PPB MPU_RASR_A1: S Mask                 */
#define PPB_MPU_RASR_A1_TEX_Pos               19                                                      /*!< PPB MPU_RASR_A1: TEX Position           */
#define PPB_MPU_RASR_A1_TEX_Msk               (0x07UL << PPB_MPU_RASR_A1_TEX_Pos)                     /*!< PPB MPU_RASR_A1: TEX Mask               */
#define PPB_MPU_RASR_A1_AP_Pos                24                                                      /*!< PPB MPU_RASR_A1: AP Position            */
#define PPB_MPU_RASR_A1_AP_Msk                (0x07UL << PPB_MPU_RASR_A1_AP_Pos)                      /*!< PPB MPU_RASR_A1: AP Mask                */
#define PPB_MPU_RASR_A1_XN_Pos                28                                                      /*!< PPB MPU_RASR_A1: XN Position            */
#define PPB_MPU_RASR_A1_XN_Msk                (0x01UL << PPB_MPU_RASR_A1_XN_Pos)                      /*!< PPB MPU_RASR_A1: XN Mask                */

/* -------------------------------  PPB_MPU_RBAR_A2  ------------------------------ */
#define PPB_MPU_RBAR_A2_REGION_Pos            0                                                       /*!< PPB MPU_RBAR_A2: REGION Position        */
#define PPB_MPU_RBAR_A2_REGION_Msk            (0x0fUL << PPB_MPU_RBAR_A2_REGION_Pos)                  /*!< PPB MPU_RBAR_A2: REGION Mask            */
#define PPB_MPU_RBAR_A2_VALID_Pos             4                                                       /*!< PPB MPU_RBAR_A2: VALID Position         */
#define PPB_MPU_RBAR_A2_VALID_Msk             (0x01UL << PPB_MPU_RBAR_A2_VALID_Pos)                   /*!< PPB MPU_RBAR_A2: VALID Mask             */
#define PPB_MPU_RBAR_A2_ADDR_Pos              9                                                       /*!< PPB MPU_RBAR_A2: ADDR Position          */
#define PPB_MPU_RBAR_A2_ADDR_Msk              (0x007fffffUL << PPB_MPU_RBAR_A2_ADDR_Pos)              /*!< PPB MPU_RBAR_A2: ADDR Mask              */

/* -------------------------------  PPB_MPU_RASR_A2  ------------------------------ */
#define PPB_MPU_RASR_A2_ENABLE_Pos            0                                                       /*!< PPB MPU_RASR_A2: ENABLE Position        */
#define PPB_MPU_RASR_A2_ENABLE_Msk            (0x01UL << PPB_MPU_RASR_A2_ENABLE_Pos)                  /*!< PPB MPU_RASR_A2: ENABLE Mask            */
#define PPB_MPU_RASR_A2_SIZE_Pos              1                                                       /*!< PPB MPU_RASR_A2: SIZE Position          */
#define PPB_MPU_RASR_A2_SIZE_Msk              (0x1fUL << PPB_MPU_RASR_A2_SIZE_Pos)                    /*!< PPB MPU_RASR_A2: SIZE Mask              */
#define PPB_MPU_RASR_A2_SRD_Pos               8                                                       /*!< PPB MPU_RASR_A2: SRD Position           */
#define PPB_MPU_RASR_A2_SRD_Msk               (0x000000ffUL << PPB_MPU_RASR_A2_SRD_Pos)               /*!< PPB MPU_RASR_A2: SRD Mask               */
#define PPB_MPU_RASR_A2_B_Pos                 16                                                      /*!< PPB MPU_RASR_A2: B Position             */
#define PPB_MPU_RASR_A2_B_Msk                 (0x01UL << PPB_MPU_RASR_A2_B_Pos)                       /*!< PPB MPU_RASR_A2: B Mask                 */
#define PPB_MPU_RASR_A2_C_Pos                 17                                                      /*!< PPB MPU_RASR_A2: C Position             */
#define PPB_MPU_RASR_A2_C_Msk                 (0x01UL << PPB_MPU_RASR_A2_C_Pos)                       /*!< PPB MPU_RASR_A2: C Mask                 */
#define PPB_MPU_RASR_A2_S_Pos                 18                                                      /*!< PPB MPU_RASR_A2: S Position             */
#define PPB_MPU_RASR_A2_S_Msk                 (0x01UL << PPB_MPU_RASR_A2_S_Pos)                       /*!< PPB MPU_RASR_A2: S Mask                 */
#define PPB_MPU_RASR_A2_TEX_Pos               19                                                      /*!< PPB MPU_RASR_A2: TEX Position           */
#define PPB_MPU_RASR_A2_TEX_Msk               (0x07UL << PPB_MPU_RASR_A2_TEX_Pos)                     /*!< PPB MPU_RASR_A2: TEX Mask               */
#define PPB_MPU_RASR_A2_AP_Pos                24                                                      /*!< PPB MPU_RASR_A2: AP Position            */
#define PPB_MPU_RASR_A2_AP_Msk                (0x07UL << PPB_MPU_RASR_A2_AP_Pos)                      /*!< PPB MPU_RASR_A2: AP Mask                */
#define PPB_MPU_RASR_A2_XN_Pos                28                                                      /*!< PPB MPU_RASR_A2: XN Position            */
#define PPB_MPU_RASR_A2_XN_Msk                (0x01UL << PPB_MPU_RASR_A2_XN_Pos)                      /*!< PPB MPU_RASR_A2: XN Mask                */

/* -------------------------------  PPB_MPU_RBAR_A3  ------------------------------ */
#define PPB_MPU_RBAR_A3_REGION_Pos            0                                                       /*!< PPB MPU_RBAR_A3: REGION Position        */
#define PPB_MPU_RBAR_A3_REGION_Msk            (0x0fUL << PPB_MPU_RBAR_A3_REGION_Pos)                  /*!< PPB MPU_RBAR_A3: REGION Mask            */
#define PPB_MPU_RBAR_A3_VALID_Pos             4                                                       /*!< PPB MPU_RBAR_A3: VALID Position         */
#define PPB_MPU_RBAR_A3_VALID_Msk             (0x01UL << PPB_MPU_RBAR_A3_VALID_Pos)                   /*!< PPB MPU_RBAR_A3: VALID Mask             */
#define PPB_MPU_RBAR_A3_ADDR_Pos              9                                                       /*!< PPB MPU_RBAR_A3: ADDR Position          */
#define PPB_MPU_RBAR_A3_ADDR_Msk              (0x007fffffUL << PPB_MPU_RBAR_A3_ADDR_Pos)              /*!< PPB MPU_RBAR_A3: ADDR Mask              */

/* -------------------------------  PPB_MPU_RASR_A3  ------------------------------ */
#define PPB_MPU_RASR_A3_ENABLE_Pos            0                                                       /*!< PPB MPU_RASR_A3: ENABLE Position        */
#define PPB_MPU_RASR_A3_ENABLE_Msk            (0x01UL << PPB_MPU_RASR_A3_ENABLE_Pos)                  /*!< PPB MPU_RASR_A3: ENABLE Mask            */
#define PPB_MPU_RASR_A3_SIZE_Pos              1                                                       /*!< PPB MPU_RASR_A3: SIZE Position          */
#define PPB_MPU_RASR_A3_SIZE_Msk              (0x1fUL << PPB_MPU_RASR_A3_SIZE_Pos)                    /*!< PPB MPU_RASR_A3: SIZE Mask              */
#define PPB_MPU_RASR_A3_SRD_Pos               8                                                       /*!< PPB MPU_RASR_A3: SRD Position           */
#define PPB_MPU_RASR_A3_SRD_Msk               (0x000000ffUL << PPB_MPU_RASR_A3_SRD_Pos)               /*!< PPB MPU_RASR_A3: SRD Mask               */
#define PPB_MPU_RASR_A3_B_Pos                 16                                                      /*!< PPB MPU_RASR_A3: B Position             */
#define PPB_MPU_RASR_A3_B_Msk                 (0x01UL << PPB_MPU_RASR_A3_B_Pos)                       /*!< PPB MPU_RASR_A3: B Mask                 */
#define PPB_MPU_RASR_A3_C_Pos                 17                                                      /*!< PPB MPU_RASR_A3: C Position             */
#define PPB_MPU_RASR_A3_C_Msk                 (0x01UL << PPB_MPU_RASR_A3_C_Pos)                       /*!< PPB MPU_RASR_A3: C Mask                 */
#define PPB_MPU_RASR_A3_S_Pos                 18                                                      /*!< PPB MPU_RASR_A3: S Position             */
#define PPB_MPU_RASR_A3_S_Msk                 (0x01UL << PPB_MPU_RASR_A3_S_Pos)                       /*!< PPB MPU_RASR_A3: S Mask                 */
#define PPB_MPU_RASR_A3_TEX_Pos               19                                                      /*!< PPB MPU_RASR_A3: TEX Position           */
#define PPB_MPU_RASR_A3_TEX_Msk               (0x07UL << PPB_MPU_RASR_A3_TEX_Pos)                     /*!< PPB MPU_RASR_A3: TEX Mask               */
#define PPB_MPU_RASR_A3_AP_Pos                24                                                      /*!< PPB MPU_RASR_A3: AP Position            */
#define PPB_MPU_RASR_A3_AP_Msk                (0x07UL << PPB_MPU_RASR_A3_AP_Pos)                      /*!< PPB MPU_RASR_A3: AP Mask                */
#define PPB_MPU_RASR_A3_XN_Pos                28                                                      /*!< PPB MPU_RASR_A3: XN Position            */
#define PPB_MPU_RASR_A3_XN_Msk                (0x01UL << PPB_MPU_RASR_A3_XN_Pos)                      /*!< PPB MPU_RASR_A3: XN Mask                */

/* ----------------------------------  PPB_STIR  ---------------------------------- */
#define PPB_STIR_INTID_Pos                    0                                                       /*!< PPB STIR: INTID Position                */
#define PPB_STIR_INTID_Msk                    (0x000001ffUL << PPB_STIR_INTID_Pos)                    /*!< PPB STIR: INTID Mask                    */

/* ----------------------------------  PPB_FPCCR  --------------------------------- */
#define PPB_FPCCR_LSPACT_Pos                  0                                                       /*!< PPB FPCCR: LSPACT Position              */
#define PPB_FPCCR_LSPACT_Msk                  (0x01UL << PPB_FPCCR_LSPACT_Pos)                        /*!< PPB FPCCR: LSPACT Mask                  */
#define PPB_FPCCR_USER_Pos                    1                                                       /*!< PPB FPCCR: USER Position                */
#define PPB_FPCCR_USER_Msk                    (0x01UL << PPB_FPCCR_USER_Pos)                          /*!< PPB FPCCR: USER Mask                    */
#define PPB_FPCCR_THREAD_Pos                  3                                                       /*!< PPB FPCCR: THREAD Position              */
#define PPB_FPCCR_THREAD_Msk                  (0x01UL << PPB_FPCCR_THREAD_Pos)                        /*!< PPB FPCCR: THREAD Mask                  */
#define PPB_FPCCR_HFRDY_Pos                   4                                                       /*!< PPB FPCCR: HFRDY Position               */
#define PPB_FPCCR_HFRDY_Msk                   (0x01UL << PPB_FPCCR_HFRDY_Pos)                         /*!< PPB FPCCR: HFRDY Mask                   */
#define PPB_FPCCR_MMRDY_Pos                   5                                                       /*!< PPB FPCCR: MMRDY Position               */
#define PPB_FPCCR_MMRDY_Msk                   (0x01UL << PPB_FPCCR_MMRDY_Pos)                         /*!< PPB FPCCR: MMRDY Mask                   */
#define PPB_FPCCR_BFRDY_Pos                   6                                                       /*!< PPB FPCCR: BFRDY Position               */
#define PPB_FPCCR_BFRDY_Msk                   (0x01UL << PPB_FPCCR_BFRDY_Pos)                         /*!< PPB FPCCR: BFRDY Mask                   */
#define PPB_FPCCR_MONRDY_Pos                  8                                                       /*!< PPB FPCCR: MONRDY Position              */
#define PPB_FPCCR_MONRDY_Msk                  (0x01UL << PPB_FPCCR_MONRDY_Pos)                        /*!< PPB FPCCR: MONRDY Mask                  */
#define PPB_FPCCR_LSPEN_Pos                   30                                                      /*!< PPB FPCCR: LSPEN Position               */
#define PPB_FPCCR_LSPEN_Msk                   (0x01UL << PPB_FPCCR_LSPEN_Pos)                         /*!< PPB FPCCR: LSPEN Mask                   */
#define PPB_FPCCR_ASPEN_Pos                   31                                                      /*!< PPB FPCCR: ASPEN Position               */
#define PPB_FPCCR_ASPEN_Msk                   (0x01UL << PPB_FPCCR_ASPEN_Pos)                         /*!< PPB FPCCR: ASPEN Mask                   */

/* ----------------------------------  PPB_FPCAR  --------------------------------- */
#define PPB_FPCAR_ADDRESS_Pos                 3                                                       /*!< PPB FPCAR: ADDRESS Position             */
#define PPB_FPCAR_ADDRESS_Msk                 (0x1fffffffUL << PPB_FPCAR_ADDRESS_Pos)                 /*!< PPB FPCAR: ADDRESS Mask                 */

/* ---------------------------------  PPB_FPDSCR  --------------------------------- */
#define PPB_FPDSCR_RMode_Pos                  22                                                      /*!< PPB FPDSCR: RMode Position              */
#define PPB_FPDSCR_RMode_Msk                  (0x03UL << PPB_FPDSCR_RMode_Pos)                        /*!< PPB FPDSCR: RMode Mask                  */
#define PPB_FPDSCR_FZ_Pos                     24                                                      /*!< PPB FPDSCR: FZ Position                 */
#define PPB_FPDSCR_FZ_Msk                     (0x01UL << PPB_FPDSCR_FZ_Pos)                           /*!< PPB FPDSCR: FZ Mask                     */
#define PPB_FPDSCR_DN_Pos                     25                                                      /*!< PPB FPDSCR: DN Position                 */
#define PPB_FPDSCR_DN_Msk                     (0x01UL << PPB_FPDSCR_DN_Pos)                           /*!< PPB FPDSCR: DN Mask                     */
#define PPB_FPDSCR_AHP_Pos                    26                                                      /*!< PPB FPDSCR: AHP Position                */
#define PPB_FPDSCR_AHP_Msk                    (0x01UL << PPB_FPDSCR_AHP_Pos)                          /*!< PPB FPDSCR: AHP Mask                    */


/* ================================================================================ */
/* ================          struct 'DLR' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  DLR_OVRSTAT  -------------------------------- */
#define DLR_OVRSTAT_LN0_Pos                   0                                                       /*!< DLR OVRSTAT: LN0 Position               */
#define DLR_OVRSTAT_LN0_Msk                   (0x01UL << DLR_OVRSTAT_LN0_Pos)                         /*!< DLR OVRSTAT: LN0 Mask                   */
#define DLR_OVRSTAT_LN1_Pos                   1                                                       /*!< DLR OVRSTAT: LN1 Position               */
#define DLR_OVRSTAT_LN1_Msk                   (0x01UL << DLR_OVRSTAT_LN1_Pos)                         /*!< DLR OVRSTAT: LN1 Mask                   */
#define DLR_OVRSTAT_LN2_Pos                   2                                                       /*!< DLR OVRSTAT: LN2 Position               */
#define DLR_OVRSTAT_LN2_Msk                   (0x01UL << DLR_OVRSTAT_LN2_Pos)                         /*!< DLR OVRSTAT: LN2 Mask                   */
#define DLR_OVRSTAT_LN3_Pos                   3                                                       /*!< DLR OVRSTAT: LN3 Position               */
#define DLR_OVRSTAT_LN3_Msk                   (0x01UL << DLR_OVRSTAT_LN3_Pos)                         /*!< DLR OVRSTAT: LN3 Mask                   */
#define DLR_OVRSTAT_LN4_Pos                   4                                                       /*!< DLR OVRSTAT: LN4 Position               */
#define DLR_OVRSTAT_LN4_Msk                   (0x01UL << DLR_OVRSTAT_LN4_Pos)                         /*!< DLR OVRSTAT: LN4 Mask                   */
#define DLR_OVRSTAT_LN5_Pos                   5                                                       /*!< DLR OVRSTAT: LN5 Position               */
#define DLR_OVRSTAT_LN5_Msk                   (0x01UL << DLR_OVRSTAT_LN5_Pos)                         /*!< DLR OVRSTAT: LN5 Mask                   */
#define DLR_OVRSTAT_LN6_Pos                   6                                                       /*!< DLR OVRSTAT: LN6 Position               */
#define DLR_OVRSTAT_LN6_Msk                   (0x01UL << DLR_OVRSTAT_LN6_Pos)                         /*!< DLR OVRSTAT: LN6 Mask                   */
#define DLR_OVRSTAT_LN7_Pos                   7                                                       /*!< DLR OVRSTAT: LN7 Position               */
#define DLR_OVRSTAT_LN7_Msk                   (0x01UL << DLR_OVRSTAT_LN7_Pos)                         /*!< DLR OVRSTAT: LN7 Mask                   */

/* ---------------------------------  DLR_OVRCLR  --------------------------------- */
#define DLR_OVRCLR_LN0_Pos                    0                                                       /*!< DLR OVRCLR: LN0 Position                */
#define DLR_OVRCLR_LN0_Msk                    (0x01UL << DLR_OVRCLR_LN0_Pos)                          /*!< DLR OVRCLR: LN0 Mask                    */
#define DLR_OVRCLR_LN1_Pos                    1                                                       /*!< DLR OVRCLR: LN1 Position                */
#define DLR_OVRCLR_LN1_Msk                    (0x01UL << DLR_OVRCLR_LN1_Pos)                          /*!< DLR OVRCLR: LN1 Mask                    */
#define DLR_OVRCLR_LN2_Pos                    2                                                       /*!< DLR OVRCLR: LN2 Position                */
#define DLR_OVRCLR_LN2_Msk                    (0x01UL << DLR_OVRCLR_LN2_Pos)                          /*!< DLR OVRCLR: LN2 Mask                    */
#define DLR_OVRCLR_LN3_Pos                    3                                                       /*!< DLR OVRCLR: LN3 Position                */
#define DLR_OVRCLR_LN3_Msk                    (0x01UL << DLR_OVRCLR_LN3_Pos)                          /*!< DLR OVRCLR: LN3 Mask                    */
#define DLR_OVRCLR_LN4_Pos                    4                                                       /*!< DLR OVRCLR: LN4 Position                */
#define DLR_OVRCLR_LN4_Msk                    (0x01UL << DLR_OVRCLR_LN4_Pos)                          /*!< DLR OVRCLR: LN4 Mask                    */
#define DLR_OVRCLR_LN5_Pos                    5                                                       /*!< DLR OVRCLR: LN5 Position                */
#define DLR_OVRCLR_LN5_Msk                    (0x01UL << DLR_OVRCLR_LN5_Pos)                          /*!< DLR OVRCLR: LN5 Mask                    */
#define DLR_OVRCLR_LN6_Pos                    6                                                       /*!< DLR OVRCLR: LN6 Position                */
#define DLR_OVRCLR_LN6_Msk                    (0x01UL << DLR_OVRCLR_LN6_Pos)                          /*!< DLR OVRCLR: LN6 Mask                    */
#define DLR_OVRCLR_LN7_Pos                    7                                                       /*!< DLR OVRCLR: LN7 Position                */
#define DLR_OVRCLR_LN7_Msk                    (0x01UL << DLR_OVRCLR_LN7_Pos)                          /*!< DLR OVRCLR: LN7 Mask                    */

/* ---------------------------------  DLR_SRSEL0  --------------------------------- */
#define DLR_SRSEL0_RS0_Pos                    0                                                       /*!< DLR SRSEL0: RS0 Position                */
#define DLR_SRSEL0_RS0_Msk                    (0x0fUL << DLR_SRSEL0_RS0_Pos)                          /*!< DLR SRSEL0: RS0 Mask                    */
#define DLR_SRSEL0_RS1_Pos                    4                                                       /*!< DLR SRSEL0: RS1 Position                */
#define DLR_SRSEL0_RS1_Msk                    (0x0fUL << DLR_SRSEL0_RS1_Pos)                          /*!< DLR SRSEL0: RS1 Mask                    */
#define DLR_SRSEL0_RS2_Pos                    8                                                       /*!< DLR SRSEL0: RS2 Position                */
#define DLR_SRSEL0_RS2_Msk                    (0x0fUL << DLR_SRSEL0_RS2_Pos)                          /*!< DLR SRSEL0: RS2 Mask                    */
#define DLR_SRSEL0_RS3_Pos                    12                                                      /*!< DLR SRSEL0: RS3 Position                */
#define DLR_SRSEL0_RS3_Msk                    (0x0fUL << DLR_SRSEL0_RS3_Pos)                          /*!< DLR SRSEL0: RS3 Mask                    */
#define DLR_SRSEL0_RS4_Pos                    16                                                      /*!< DLR SRSEL0: RS4 Position                */
#define DLR_SRSEL0_RS4_Msk                    (0x0fUL << DLR_SRSEL0_RS4_Pos)                          /*!< DLR SRSEL0: RS4 Mask                    */
#define DLR_SRSEL0_RS5_Pos                    20                                                      /*!< DLR SRSEL0: RS5 Position                */
#define DLR_SRSEL0_RS5_Msk                    (0x0fUL << DLR_SRSEL0_RS5_Pos)                          /*!< DLR SRSEL0: RS5 Mask                    */
#define DLR_SRSEL0_RS6_Pos                    24                                                      /*!< DLR SRSEL0: RS6 Position                */
#define DLR_SRSEL0_RS6_Msk                    (0x0fUL << DLR_SRSEL0_RS6_Pos)                          /*!< DLR SRSEL0: RS6 Mask                    */
#define DLR_SRSEL0_RS7_Pos                    28                                                      /*!< DLR SRSEL0: RS7 Position                */
#define DLR_SRSEL0_RS7_Msk                    (0x0fUL << DLR_SRSEL0_RS7_Pos)                          /*!< DLR SRSEL0: RS7 Mask                    */

/* ----------------------------------  DLR_LNEN  ---------------------------------- */
#define DLR_LNEN_LN0_Pos                      0                                                       /*!< DLR LNEN: LN0 Position                  */
#define DLR_LNEN_LN0_Msk                      (0x01UL << DLR_LNEN_LN0_Pos)                            /*!< DLR LNEN: LN0 Mask                      */
#define DLR_LNEN_LN1_Pos                      1                                                       /*!< DLR LNEN: LN1 Position                  */
#define DLR_LNEN_LN1_Msk                      (0x01UL << DLR_LNEN_LN1_Pos)                            /*!< DLR LNEN: LN1 Mask                      */
#define DLR_LNEN_LN2_Pos                      2                                                       /*!< DLR LNEN: LN2 Position                  */
#define DLR_LNEN_LN2_Msk                      (0x01UL << DLR_LNEN_LN2_Pos)                            /*!< DLR LNEN: LN2 Mask                      */
#define DLR_LNEN_LN3_Pos                      3                                                       /*!< DLR LNEN: LN3 Position                  */
#define DLR_LNEN_LN3_Msk                      (0x01UL << DLR_LNEN_LN3_Pos)                            /*!< DLR LNEN: LN3 Mask                      */
#define DLR_LNEN_LN4_Pos                      4                                                       /*!< DLR LNEN: LN4 Position                  */
#define DLR_LNEN_LN4_Msk                      (0x01UL << DLR_LNEN_LN4_Pos)                            /*!< DLR LNEN: LN4 Mask                      */
#define DLR_LNEN_LN5_Pos                      5                                                       /*!< DLR LNEN: LN5 Position                  */
#define DLR_LNEN_LN5_Msk                      (0x01UL << DLR_LNEN_LN5_Pos)                            /*!< DLR LNEN: LN5 Mask                      */
#define DLR_LNEN_LN6_Pos                      6                                                       /*!< DLR LNEN: LN6 Position                  */
#define DLR_LNEN_LN6_Msk                      (0x01UL << DLR_LNEN_LN6_Pos)                            /*!< DLR LNEN: LN6 Mask                      */
#define DLR_LNEN_LN7_Pos                      7                                                       /*!< DLR LNEN: LN7 Position                  */
#define DLR_LNEN_LN7_Msk                      (0x01UL << DLR_LNEN_LN7_Pos)                            /*!< DLR LNEN: LN7 Mask                      */


/* ================================================================================ */
/* ================           Group 'ERU' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  ERU_EXISEL  --------------------------------- */
#define ERU_EXISEL_EXS0A_Pos                  0                                                       /*!< ERU EXISEL: EXS0A Position              */
#define ERU_EXISEL_EXS0A_Msk                  (0x03UL << ERU_EXISEL_EXS0A_Pos)                        /*!< ERU EXISEL: EXS0A Mask                  */
#define ERU_EXISEL_EXS0B_Pos                  2                                                       /*!< ERU EXISEL: EXS0B Position              */
#define ERU_EXISEL_EXS0B_Msk                  (0x03UL << ERU_EXISEL_EXS0B_Pos)                        /*!< ERU EXISEL: EXS0B Mask                  */
#define ERU_EXISEL_EXS1A_Pos                  4                                                       /*!< ERU EXISEL: EXS1A Position              */
#define ERU_EXISEL_EXS1A_Msk                  (0x03UL << ERU_EXISEL_EXS1A_Pos)                        /*!< ERU EXISEL: EXS1A Mask                  */
#define ERU_EXISEL_EXS1B_Pos                  6                                                       /*!< ERU EXISEL: EXS1B Position              */
#define ERU_EXISEL_EXS1B_Msk                  (0x03UL << ERU_EXISEL_EXS1B_Pos)                        /*!< ERU EXISEL: EXS1B Mask                  */
#define ERU_EXISEL_EXS2A_Pos                  8                                                       /*!< ERU EXISEL: EXS2A Position              */
#define ERU_EXISEL_EXS2A_Msk                  (0x03UL << ERU_EXISEL_EXS2A_Pos)                        /*!< ERU EXISEL: EXS2A Mask                  */
#define ERU_EXISEL_EXS2B_Pos                  10                                                      /*!< ERU EXISEL: EXS2B Position              */
#define ERU_EXISEL_EXS2B_Msk                  (0x03UL << ERU_EXISEL_EXS2B_Pos)                        /*!< ERU EXISEL: EXS2B Mask                  */
#define ERU_EXISEL_EXS3A_Pos                  12                                                      /*!< ERU EXISEL: EXS3A Position              */
#define ERU_EXISEL_EXS3A_Msk                  (0x03UL << ERU_EXISEL_EXS3A_Pos)                        /*!< ERU EXISEL: EXS3A Mask                  */
#define ERU_EXISEL_EXS3B_Pos                  14                                                      /*!< ERU EXISEL: EXS3B Position              */
#define ERU_EXISEL_EXS3B_Msk                  (0x03UL << ERU_EXISEL_EXS3B_Pos)                        /*!< ERU EXISEL: EXS3B Mask                  */

/* ---------------------------------  ERU_EXICON  --------------------------------- */
#define ERU_EXICON_PE_Pos                     0                                                       /*!< ERU EXICON: PE Position                 */
#define ERU_EXICON_PE_Msk                     (0x01UL << ERU_EXICON_PE_Pos)                           /*!< ERU EXICON: PE Mask                     */
#define ERU_EXICON_LD_Pos                     1                                                       /*!< ERU EXICON: LD Position                 */
#define ERU_EXICON_LD_Msk                     (0x01UL << ERU_EXICON_LD_Pos)                           /*!< ERU EXICON: LD Mask                     */
#define ERU_EXICON_RE_Pos                     2                                                       /*!< ERU EXICON: RE Position                 */
#define ERU_EXICON_RE_Msk                     (0x01UL << ERU_EXICON_RE_Pos)                           /*!< ERU EXICON: RE Mask                     */
#define ERU_EXICON_FE_Pos                     3                                                       /*!< ERU EXICON: FE Position                 */
#define ERU_EXICON_FE_Msk                     (0x01UL << ERU_EXICON_FE_Pos)                           /*!< ERU EXICON: FE Mask                     */
#define ERU_EXICON_OCS_Pos                    4                                                       /*!< ERU EXICON: OCS Position                */
#define ERU_EXICON_OCS_Msk                    (0x07UL << ERU_EXICON_OCS_Pos)                          /*!< ERU EXICON: OCS Mask                    */
#define ERU_EXICON_FL_Pos                     7                                                       /*!< ERU EXICON: FL Position                 */
#define ERU_EXICON_FL_Msk                     (0x01UL << ERU_EXICON_FL_Pos)                           /*!< ERU EXICON: FL Mask                     */
#define ERU_EXICON_SS_Pos                     8                                                       /*!< ERU EXICON: SS Position                 */
#define ERU_EXICON_SS_Msk                     (0x03UL << ERU_EXICON_SS_Pos)                           /*!< ERU EXICON: SS Mask                     */
#define ERU_EXICON_NA_Pos                     10                                                      /*!< ERU EXICON: NA Position                 */
#define ERU_EXICON_NA_Msk                     (0x01UL << ERU_EXICON_NA_Pos)                           /*!< ERU EXICON: NA Mask                     */
#define ERU_EXICON_NB_Pos                     11                                                      /*!< ERU EXICON: NB Position                 */
#define ERU_EXICON_NB_Msk                     (0x01UL << ERU_EXICON_NB_Pos)                           /*!< ERU EXICON: NB Mask                     */

/* ---------------------------------  ERU_EXOCON  --------------------------------- */
#define ERU_EXOCON_ISS_Pos                    0                                                       /*!< ERU EXOCON: ISS Position                */
#define ERU_EXOCON_ISS_Msk                    (0x03UL << ERU_EXOCON_ISS_Pos)                          /*!< ERU EXOCON: ISS Mask                    */
#define ERU_EXOCON_GEEN_Pos                   2                                                       /*!< ERU EXOCON: GEEN Position               */
#define ERU_EXOCON_GEEN_Msk                   (0x01UL << ERU_EXOCON_GEEN_Pos)                         /*!< ERU EXOCON: GEEN Mask                   */
#define ERU_EXOCON_PDR_Pos                    3                                                       /*!< ERU EXOCON: PDR Position                */
#define ERU_EXOCON_PDR_Msk                    (0x01UL << ERU_EXOCON_PDR_Pos)                          /*!< ERU EXOCON: PDR Mask                    */
#define ERU_EXOCON_GP_Pos                     4                                                       /*!< ERU EXOCON: GP Position                 */
#define ERU_EXOCON_GP_Msk                     (0x03UL << ERU_EXOCON_GP_Pos)                           /*!< ERU EXOCON: GP Mask                     */
#define ERU_EXOCON_IPEN0_Pos                  12                                                      /*!< ERU EXOCON: IPEN0 Position              */
#define ERU_EXOCON_IPEN0_Msk                  (0x01UL << ERU_EXOCON_IPEN0_Pos)                        /*!< ERU EXOCON: IPEN0 Mask                  */
#define ERU_EXOCON_IPEN1_Pos                  13                                                      /*!< ERU EXOCON: IPEN1 Position              */
#define ERU_EXOCON_IPEN1_Msk                  (0x01UL << ERU_EXOCON_IPEN1_Pos)                        /*!< ERU EXOCON: IPEN1 Mask                  */
#define ERU_EXOCON_IPEN2_Pos                  14                                                      /*!< ERU EXOCON: IPEN2 Position              */
#define ERU_EXOCON_IPEN2_Msk                  (0x01UL << ERU_EXOCON_IPEN2_Pos)                        /*!< ERU EXOCON: IPEN2 Mask                  */
#define ERU_EXOCON_IPEN3_Pos                  15                                                      /*!< ERU EXOCON: IPEN3 Position              */
#define ERU_EXOCON_IPEN3_Msk                  (0x01UL << ERU_EXOCON_IPEN3_Pos)                        /*!< ERU EXOCON: IPEN3 Mask                  */


/* ================================================================================ */
/* ================         struct 'GPDMA0' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  GPDMA0_RAWTFR  ------------------------------- */
#define GPDMA0_RAWTFR_CH0_Pos                 0                                                       /*!< GPDMA0 RAWTFR: CH0 Position             */
#define GPDMA0_RAWTFR_CH0_Msk                 (0x01UL << GPDMA0_RAWTFR_CH0_Pos)                       /*!< GPDMA0 RAWTFR: CH0 Mask                 */
#define GPDMA0_RAWTFR_CH1_Pos                 1                                                       /*!< GPDMA0 RAWTFR: CH1 Position             */
#define GPDMA0_RAWTFR_CH1_Msk                 (0x01UL << GPDMA0_RAWTFR_CH1_Pos)                       /*!< GPDMA0 RAWTFR: CH1 Mask                 */
#define GPDMA0_RAWTFR_CH2_Pos                 2                                                       /*!< GPDMA0 RAWTFR: CH2 Position             */
#define GPDMA0_RAWTFR_CH2_Msk                 (0x01UL << GPDMA0_RAWTFR_CH2_Pos)                       /*!< GPDMA0 RAWTFR: CH2 Mask                 */
#define GPDMA0_RAWTFR_CH3_Pos                 3                                                       /*!< GPDMA0 RAWTFR: CH3 Position             */
#define GPDMA0_RAWTFR_CH3_Msk                 (0x01UL << GPDMA0_RAWTFR_CH3_Pos)                       /*!< GPDMA0 RAWTFR: CH3 Mask                 */
#define GPDMA0_RAWTFR_CH4_Pos                 4                                                       /*!< GPDMA0 RAWTFR: CH4 Position             */
#define GPDMA0_RAWTFR_CH4_Msk                 (0x01UL << GPDMA0_RAWTFR_CH4_Pos)                       /*!< GPDMA0 RAWTFR: CH4 Mask                 */
#define GPDMA0_RAWTFR_CH5_Pos                 5                                                       /*!< GPDMA0 RAWTFR: CH5 Position             */
#define GPDMA0_RAWTFR_CH5_Msk                 (0x01UL << GPDMA0_RAWTFR_CH5_Pos)                       /*!< GPDMA0 RAWTFR: CH5 Mask                 */
#define GPDMA0_RAWTFR_CH6_Pos                 6                                                       /*!< GPDMA0 RAWTFR: CH6 Position             */
#define GPDMA0_RAWTFR_CH6_Msk                 (0x01UL << GPDMA0_RAWTFR_CH6_Pos)                       /*!< GPDMA0 RAWTFR: CH6 Mask                 */
#define GPDMA0_RAWTFR_CH7_Pos                 7                                                       /*!< GPDMA0 RAWTFR: CH7 Position             */
#define GPDMA0_RAWTFR_CH7_Msk                 (0x01UL << GPDMA0_RAWTFR_CH7_Pos)                       /*!< GPDMA0 RAWTFR: CH7 Mask                 */

/* -------------------------------  GPDMA0_RAWBLOCK  ------------------------------ */
#define GPDMA0_RAWBLOCK_CH0_Pos               0                                                       /*!< GPDMA0 RAWBLOCK: CH0 Position           */
#define GPDMA0_RAWBLOCK_CH0_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH0_Pos)                     /*!< GPDMA0 RAWBLOCK: CH0 Mask               */
#define GPDMA0_RAWBLOCK_CH1_Pos               1                                                       /*!< GPDMA0 RAWBLOCK: CH1 Position           */
#define GPDMA0_RAWBLOCK_CH1_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH1_Pos)                     /*!< GPDMA0 RAWBLOCK: CH1 Mask               */
#define GPDMA0_RAWBLOCK_CH2_Pos               2                                                       /*!< GPDMA0 RAWBLOCK: CH2 Position           */
#define GPDMA0_RAWBLOCK_CH2_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH2_Pos)                     /*!< GPDMA0 RAWBLOCK: CH2 Mask               */
#define GPDMA0_RAWBLOCK_CH3_Pos               3                                                       /*!< GPDMA0 RAWBLOCK: CH3 Position           */
#define GPDMA0_RAWBLOCK_CH3_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH3_Pos)                     /*!< GPDMA0 RAWBLOCK: CH3 Mask               */
#define GPDMA0_RAWBLOCK_CH4_Pos               4                                                       /*!< GPDMA0 RAWBLOCK: CH4 Position           */
#define GPDMA0_RAWBLOCK_CH4_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH4_Pos)                     /*!< GPDMA0 RAWBLOCK: CH4 Mask               */
#define GPDMA0_RAWBLOCK_CH5_Pos               5                                                       /*!< GPDMA0 RAWBLOCK: CH5 Position           */
#define GPDMA0_RAWBLOCK_CH5_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH5_Pos)                     /*!< GPDMA0 RAWBLOCK: CH5 Mask               */
#define GPDMA0_RAWBLOCK_CH6_Pos               6                                                       /*!< GPDMA0 RAWBLOCK: CH6 Position           */
#define GPDMA0_RAWBLOCK_CH6_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH6_Pos)                     /*!< GPDMA0 RAWBLOCK: CH6 Mask               */
#define GPDMA0_RAWBLOCK_CH7_Pos               7                                                       /*!< GPDMA0 RAWBLOCK: CH7 Position           */
#define GPDMA0_RAWBLOCK_CH7_Msk               (0x01UL << GPDMA0_RAWBLOCK_CH7_Pos)                     /*!< GPDMA0 RAWBLOCK: CH7 Mask               */

/* ------------------------------  GPDMA0_RAWSRCTRAN  ----------------------------- */
#define GPDMA0_RAWSRCTRAN_CH0_Pos             0                                                       /*!< GPDMA0 RAWSRCTRAN: CH0 Position         */
#define GPDMA0_RAWSRCTRAN_CH0_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH0_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH0 Mask             */
#define GPDMA0_RAWSRCTRAN_CH1_Pos             1                                                       /*!< GPDMA0 RAWSRCTRAN: CH1 Position         */
#define GPDMA0_RAWSRCTRAN_CH1_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH1_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH1 Mask             */
#define GPDMA0_RAWSRCTRAN_CH2_Pos             2                                                       /*!< GPDMA0 RAWSRCTRAN: CH2 Position         */
#define GPDMA0_RAWSRCTRAN_CH2_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH2_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH2 Mask             */
#define GPDMA0_RAWSRCTRAN_CH3_Pos             3                                                       /*!< GPDMA0 RAWSRCTRAN: CH3 Position         */
#define GPDMA0_RAWSRCTRAN_CH3_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH3_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH3 Mask             */
#define GPDMA0_RAWSRCTRAN_CH4_Pos             4                                                       /*!< GPDMA0 RAWSRCTRAN: CH4 Position         */
#define GPDMA0_RAWSRCTRAN_CH4_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH4_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH4 Mask             */
#define GPDMA0_RAWSRCTRAN_CH5_Pos             5                                                       /*!< GPDMA0 RAWSRCTRAN: CH5 Position         */
#define GPDMA0_RAWSRCTRAN_CH5_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH5_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH5 Mask             */
#define GPDMA0_RAWSRCTRAN_CH6_Pos             6                                                       /*!< GPDMA0 RAWSRCTRAN: CH6 Position         */
#define GPDMA0_RAWSRCTRAN_CH6_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH6_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH6 Mask             */
#define GPDMA0_RAWSRCTRAN_CH7_Pos             7                                                       /*!< GPDMA0 RAWSRCTRAN: CH7 Position         */
#define GPDMA0_RAWSRCTRAN_CH7_Msk             (0x01UL << GPDMA0_RAWSRCTRAN_CH7_Pos)                   /*!< GPDMA0 RAWSRCTRAN: CH7 Mask             */

/* ------------------------------  GPDMA0_RAWDSTTRAN  ----------------------------- */
#define GPDMA0_RAWDSTTRAN_CH0_Pos             0                                                       /*!< GPDMA0 RAWDSTTRAN: CH0 Position         */
#define GPDMA0_RAWDSTTRAN_CH0_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH0_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH0 Mask             */
#define GPDMA0_RAWDSTTRAN_CH1_Pos             1                                                       /*!< GPDMA0 RAWDSTTRAN: CH1 Position         */
#define GPDMA0_RAWDSTTRAN_CH1_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH1_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH1 Mask             */
#define GPDMA0_RAWDSTTRAN_CH2_Pos             2                                                       /*!< GPDMA0 RAWDSTTRAN: CH2 Position         */
#define GPDMA0_RAWDSTTRAN_CH2_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH2_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH2 Mask             */
#define GPDMA0_RAWDSTTRAN_CH3_Pos             3                                                       /*!< GPDMA0 RAWDSTTRAN: CH3 Position         */
#define GPDMA0_RAWDSTTRAN_CH3_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH3_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH3 Mask             */
#define GPDMA0_RAWDSTTRAN_CH4_Pos             4                                                       /*!< GPDMA0 RAWDSTTRAN: CH4 Position         */
#define GPDMA0_RAWDSTTRAN_CH4_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH4_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH4 Mask             */
#define GPDMA0_RAWDSTTRAN_CH5_Pos             5                                                       /*!< GPDMA0 RAWDSTTRAN: CH5 Position         */
#define GPDMA0_RAWDSTTRAN_CH5_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH5_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH5 Mask             */
#define GPDMA0_RAWDSTTRAN_CH6_Pos             6                                                       /*!< GPDMA0 RAWDSTTRAN: CH6 Position         */
#define GPDMA0_RAWDSTTRAN_CH6_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH6_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH6 Mask             */
#define GPDMA0_RAWDSTTRAN_CH7_Pos             7                                                       /*!< GPDMA0 RAWDSTTRAN: CH7 Position         */
#define GPDMA0_RAWDSTTRAN_CH7_Msk             (0x01UL << GPDMA0_RAWDSTTRAN_CH7_Pos)                   /*!< GPDMA0 RAWDSTTRAN: CH7 Mask             */

/* --------------------------------  GPDMA0_RAWERR  ------------------------------- */
#define GPDMA0_RAWERR_CH0_Pos                 0                                                       /*!< GPDMA0 RAWERR: CH0 Position             */
#define GPDMA0_RAWERR_CH0_Msk                 (0x01UL << GPDMA0_RAWERR_CH0_Pos)                       /*!< GPDMA0 RAWERR: CH0 Mask                 */
#define GPDMA0_RAWERR_CH1_Pos                 1                                                       /*!< GPDMA0 RAWERR: CH1 Position             */
#define GPDMA0_RAWERR_CH1_Msk                 (0x01UL << GPDMA0_RAWERR_CH1_Pos)                       /*!< GPDMA0 RAWERR: CH1 Mask                 */
#define GPDMA0_RAWERR_CH2_Pos                 2                                                       /*!< GPDMA0 RAWERR: CH2 Position             */
#define GPDMA0_RAWERR_CH2_Msk                 (0x01UL << GPDMA0_RAWERR_CH2_Pos)                       /*!< GPDMA0 RAWERR: CH2 Mask                 */
#define GPDMA0_RAWERR_CH3_Pos                 3                                                       /*!< GPDMA0 RAWERR: CH3 Position             */
#define GPDMA0_RAWERR_CH3_Msk                 (0x01UL << GPDMA0_RAWERR_CH3_Pos)                       /*!< GPDMA0 RAWERR: CH3 Mask                 */
#define GPDMA0_RAWERR_CH4_Pos                 4                                                       /*!< GPDMA0 RAWERR: CH4 Position             */
#define GPDMA0_RAWERR_CH4_Msk                 (0x01UL << GPDMA0_RAWERR_CH4_Pos)                       /*!< GPDMA0 RAWERR: CH4 Mask                 */
#define GPDMA0_RAWERR_CH5_Pos                 5                                                       /*!< GPDMA0 RAWERR: CH5 Position             */
#define GPDMA0_RAWERR_CH5_Msk                 (0x01UL << GPDMA0_RAWERR_CH5_Pos)                       /*!< GPDMA0 RAWERR: CH5 Mask                 */
#define GPDMA0_RAWERR_CH6_Pos                 6                                                       /*!< GPDMA0 RAWERR: CH6 Position             */
#define GPDMA0_RAWERR_CH6_Msk                 (0x01UL << GPDMA0_RAWERR_CH6_Pos)                       /*!< GPDMA0 RAWERR: CH6 Mask                 */
#define GPDMA0_RAWERR_CH7_Pos                 7                                                       /*!< GPDMA0 RAWERR: CH7 Position             */
#define GPDMA0_RAWERR_CH7_Msk                 (0x01UL << GPDMA0_RAWERR_CH7_Pos)                       /*!< GPDMA0 RAWERR: CH7 Mask                 */

/* ------------------------------  GPDMA0_STATUSTFR  ------------------------------ */
#define GPDMA0_STATUSTFR_CH0_Pos              0                                                       /*!< GPDMA0 STATUSTFR: CH0 Position          */
#define GPDMA0_STATUSTFR_CH0_Msk              (0x01UL << GPDMA0_STATUSTFR_CH0_Pos)                    /*!< GPDMA0 STATUSTFR: CH0 Mask              */
#define GPDMA0_STATUSTFR_CH1_Pos              1                                                       /*!< GPDMA0 STATUSTFR: CH1 Position          */
#define GPDMA0_STATUSTFR_CH1_Msk              (0x01UL << GPDMA0_STATUSTFR_CH1_Pos)                    /*!< GPDMA0 STATUSTFR: CH1 Mask              */
#define GPDMA0_STATUSTFR_CH2_Pos              2                                                       /*!< GPDMA0 STATUSTFR: CH2 Position          */
#define GPDMA0_STATUSTFR_CH2_Msk              (0x01UL << GPDMA0_STATUSTFR_CH2_Pos)                    /*!< GPDMA0 STATUSTFR: CH2 Mask              */
#define GPDMA0_STATUSTFR_CH3_Pos              3                                                       /*!< GPDMA0 STATUSTFR: CH3 Position          */
#define GPDMA0_STATUSTFR_CH3_Msk              (0x01UL << GPDMA0_STATUSTFR_CH3_Pos)                    /*!< GPDMA0 STATUSTFR: CH3 Mask              */
#define GPDMA0_STATUSTFR_CH4_Pos              4                                                       /*!< GPDMA0 STATUSTFR: CH4 Position          */
#define GPDMA0_STATUSTFR_CH4_Msk              (0x01UL << GPDMA0_STATUSTFR_CH4_Pos)                    /*!< GPDMA0 STATUSTFR: CH4 Mask              */
#define GPDMA0_STATUSTFR_CH5_Pos              5                                                       /*!< GPDMA0 STATUSTFR: CH5 Position          */
#define GPDMA0_STATUSTFR_CH5_Msk              (0x01UL << GPDMA0_STATUSTFR_CH5_Pos)                    /*!< GPDMA0 STATUSTFR: CH5 Mask              */
#define GPDMA0_STATUSTFR_CH6_Pos              6                                                       /*!< GPDMA0 STATUSTFR: CH6 Position          */
#define GPDMA0_STATUSTFR_CH6_Msk              (0x01UL << GPDMA0_STATUSTFR_CH6_Pos)                    /*!< GPDMA0 STATUSTFR: CH6 Mask              */
#define GPDMA0_STATUSTFR_CH7_Pos              7                                                       /*!< GPDMA0 STATUSTFR: CH7 Position          */
#define GPDMA0_STATUSTFR_CH7_Msk              (0x01UL << GPDMA0_STATUSTFR_CH7_Pos)                    /*!< GPDMA0 STATUSTFR: CH7 Mask              */

/* -----------------------------  GPDMA0_STATUSBLOCK  ----------------------------- */
#define GPDMA0_STATUSBLOCK_CH0_Pos            0                                                       /*!< GPDMA0 STATUSBLOCK: CH0 Position        */
#define GPDMA0_STATUSBLOCK_CH0_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH0_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH0 Mask            */
#define GPDMA0_STATUSBLOCK_CH1_Pos            1                                                       /*!< GPDMA0 STATUSBLOCK: CH1 Position        */
#define GPDMA0_STATUSBLOCK_CH1_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH1_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH1 Mask            */
#define GPDMA0_STATUSBLOCK_CH2_Pos            2                                                       /*!< GPDMA0 STATUSBLOCK: CH2 Position        */
#define GPDMA0_STATUSBLOCK_CH2_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH2_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH2 Mask            */
#define GPDMA0_STATUSBLOCK_CH3_Pos            3                                                       /*!< GPDMA0 STATUSBLOCK: CH3 Position        */
#define GPDMA0_STATUSBLOCK_CH3_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH3_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH3 Mask            */
#define GPDMA0_STATUSBLOCK_CH4_Pos            4                                                       /*!< GPDMA0 STATUSBLOCK: CH4 Position        */
#define GPDMA0_STATUSBLOCK_CH4_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH4_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH4 Mask            */
#define GPDMA0_STATUSBLOCK_CH5_Pos            5                                                       /*!< GPDMA0 STATUSBLOCK: CH5 Position        */
#define GPDMA0_STATUSBLOCK_CH5_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH5_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH5 Mask            */
#define GPDMA0_STATUSBLOCK_CH6_Pos            6                                                       /*!< GPDMA0 STATUSBLOCK: CH6 Position        */
#define GPDMA0_STATUSBLOCK_CH6_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH6_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH6 Mask            */
#define GPDMA0_STATUSBLOCK_CH7_Pos            7                                                       /*!< GPDMA0 STATUSBLOCK: CH7 Position        */
#define GPDMA0_STATUSBLOCK_CH7_Msk            (0x01UL << GPDMA0_STATUSBLOCK_CH7_Pos)                  /*!< GPDMA0 STATUSBLOCK: CH7 Mask            */

/* ----------------------------  GPDMA0_STATUSSRCTRAN  ---------------------------- */
#define GPDMA0_STATUSSRCTRAN_CH0_Pos          0                                                       /*!< GPDMA0 STATUSSRCTRAN: CH0 Position      */
#define GPDMA0_STATUSSRCTRAN_CH0_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH0_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH0 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH1_Pos          1                                                       /*!< GPDMA0 STATUSSRCTRAN: CH1 Position      */
#define GPDMA0_STATUSSRCTRAN_CH1_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH1_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH1 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH2_Pos          2                                                       /*!< GPDMA0 STATUSSRCTRAN: CH2 Position      */
#define GPDMA0_STATUSSRCTRAN_CH2_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH2_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH2 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH3_Pos          3                                                       /*!< GPDMA0 STATUSSRCTRAN: CH3 Position      */
#define GPDMA0_STATUSSRCTRAN_CH3_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH3_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH3 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH4_Pos          4                                                       /*!< GPDMA0 STATUSSRCTRAN: CH4 Position      */
#define GPDMA0_STATUSSRCTRAN_CH4_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH4_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH4 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH5_Pos          5                                                       /*!< GPDMA0 STATUSSRCTRAN: CH5 Position      */
#define GPDMA0_STATUSSRCTRAN_CH5_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH5_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH5 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH6_Pos          6                                                       /*!< GPDMA0 STATUSSRCTRAN: CH6 Position      */
#define GPDMA0_STATUSSRCTRAN_CH6_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH6_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH6 Mask          */
#define GPDMA0_STATUSSRCTRAN_CH7_Pos          7                                                       /*!< GPDMA0 STATUSSRCTRAN: CH7 Position      */
#define GPDMA0_STATUSSRCTRAN_CH7_Msk          (0x01UL << GPDMA0_STATUSSRCTRAN_CH7_Pos)                /*!< GPDMA0 STATUSSRCTRAN: CH7 Mask          */

/* ----------------------------  GPDMA0_STATUSDSTTRAN  ---------------------------- */
#define GPDMA0_STATUSDSTTRAN_CH0_Pos          0                                                       /*!< GPDMA0 STATUSDSTTRAN: CH0 Position      */
#define GPDMA0_STATUSDSTTRAN_CH0_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH0_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH0 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH1_Pos          1                                                       /*!< GPDMA0 STATUSDSTTRAN: CH1 Position      */
#define GPDMA0_STATUSDSTTRAN_CH1_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH1_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH1 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH2_Pos          2                                                       /*!< GPDMA0 STATUSDSTTRAN: CH2 Position      */
#define GPDMA0_STATUSDSTTRAN_CH2_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH2_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH2 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH3_Pos          3                                                       /*!< GPDMA0 STATUSDSTTRAN: CH3 Position      */
#define GPDMA0_STATUSDSTTRAN_CH3_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH3_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH3 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH4_Pos          4                                                       /*!< GPDMA0 STATUSDSTTRAN: CH4 Position      */
#define GPDMA0_STATUSDSTTRAN_CH4_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH4_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH4 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH5_Pos          5                                                       /*!< GPDMA0 STATUSDSTTRAN: CH5 Position      */
#define GPDMA0_STATUSDSTTRAN_CH5_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH5_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH5 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH6_Pos          6                                                       /*!< GPDMA0 STATUSDSTTRAN: CH6 Position      */
#define GPDMA0_STATUSDSTTRAN_CH6_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH6_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH6 Mask          */
#define GPDMA0_STATUSDSTTRAN_CH7_Pos          7                                                       /*!< GPDMA0 STATUSDSTTRAN: CH7 Position      */
#define GPDMA0_STATUSDSTTRAN_CH7_Msk          (0x01UL << GPDMA0_STATUSDSTTRAN_CH7_Pos)                /*!< GPDMA0 STATUSDSTTRAN: CH7 Mask          */

/* ------------------------------  GPDMA0_STATUSERR  ------------------------------ */
#define GPDMA0_STATUSERR_CH0_Pos              0                                                       /*!< GPDMA0 STATUSERR: CH0 Position          */
#define GPDMA0_STATUSERR_CH0_Msk              (0x01UL << GPDMA0_STATUSERR_CH0_Pos)                    /*!< GPDMA0 STATUSERR: CH0 Mask              */
#define GPDMA0_STATUSERR_CH1_Pos              1                                                       /*!< GPDMA0 STATUSERR: CH1 Position          */
#define GPDMA0_STATUSERR_CH1_Msk              (0x01UL << GPDMA0_STATUSERR_CH1_Pos)                    /*!< GPDMA0 STATUSERR: CH1 Mask              */
#define GPDMA0_STATUSERR_CH2_Pos              2                                                       /*!< GPDMA0 STATUSERR: CH2 Position          */
#define GPDMA0_STATUSERR_CH2_Msk              (0x01UL << GPDMA0_STATUSERR_CH2_Pos)                    /*!< GPDMA0 STATUSERR: CH2 Mask              */
#define GPDMA0_STATUSERR_CH3_Pos              3                                                       /*!< GPDMA0 STATUSERR: CH3 Position          */
#define GPDMA0_STATUSERR_CH3_Msk              (0x01UL << GPDMA0_STATUSERR_CH3_Pos)                    /*!< GPDMA0 STATUSERR: CH3 Mask              */
#define GPDMA0_STATUSERR_CH4_Pos              4                                                       /*!< GPDMA0 STATUSERR: CH4 Position          */
#define GPDMA0_STATUSERR_CH4_Msk              (0x01UL << GPDMA0_STATUSERR_CH4_Pos)                    /*!< GPDMA0 STATUSERR: CH4 Mask              */
#define GPDMA0_STATUSERR_CH5_Pos              5                                                       /*!< GPDMA0 STATUSERR: CH5 Position          */
#define GPDMA0_STATUSERR_CH5_Msk              (0x01UL << GPDMA0_STATUSERR_CH5_Pos)                    /*!< GPDMA0 STATUSERR: CH5 Mask              */
#define GPDMA0_STATUSERR_CH6_Pos              6                                                       /*!< GPDMA0 STATUSERR: CH6 Position          */
#define GPDMA0_STATUSERR_CH6_Msk              (0x01UL << GPDMA0_STATUSERR_CH6_Pos)                    /*!< GPDMA0 STATUSERR: CH6 Mask              */
#define GPDMA0_STATUSERR_CH7_Pos              7                                                       /*!< GPDMA0 STATUSERR: CH7 Position          */
#define GPDMA0_STATUSERR_CH7_Msk              (0x01UL << GPDMA0_STATUSERR_CH7_Pos)                    /*!< GPDMA0 STATUSERR: CH7 Mask              */

/* -------------------------------  GPDMA0_MASKTFR  ------------------------------- */
#define GPDMA0_MASKTFR_CH0_Pos                0                                                       /*!< GPDMA0 MASKTFR: CH0 Position            */
#define GPDMA0_MASKTFR_CH0_Msk                (0x01UL << GPDMA0_MASKTFR_CH0_Pos)                      /*!< GPDMA0 MASKTFR: CH0 Mask                */
#define GPDMA0_MASKTFR_CH1_Pos                1                                                       /*!< GPDMA0 MASKTFR: CH1 Position            */
#define GPDMA0_MASKTFR_CH1_Msk                (0x01UL << GPDMA0_MASKTFR_CH1_Pos)                      /*!< GPDMA0 MASKTFR: CH1 Mask                */
#define GPDMA0_MASKTFR_CH2_Pos                2                                                       /*!< GPDMA0 MASKTFR: CH2 Position            */
#define GPDMA0_MASKTFR_CH2_Msk                (0x01UL << GPDMA0_MASKTFR_CH2_Pos)                      /*!< GPDMA0 MASKTFR: CH2 Mask                */
#define GPDMA0_MASKTFR_CH3_Pos                3                                                       /*!< GPDMA0 MASKTFR: CH3 Position            */
#define GPDMA0_MASKTFR_CH3_Msk                (0x01UL << GPDMA0_MASKTFR_CH3_Pos)                      /*!< GPDMA0 MASKTFR: CH3 Mask                */
#define GPDMA0_MASKTFR_CH4_Pos                4                                                       /*!< GPDMA0 MASKTFR: CH4 Position            */
#define GPDMA0_MASKTFR_CH4_Msk                (0x01UL << GPDMA0_MASKTFR_CH4_Pos)                      /*!< GPDMA0 MASKTFR: CH4 Mask                */
#define GPDMA0_MASKTFR_CH5_Pos                5                                                       /*!< GPDMA0 MASKTFR: CH5 Position            */
#define GPDMA0_MASKTFR_CH5_Msk                (0x01UL << GPDMA0_MASKTFR_CH5_Pos)                      /*!< GPDMA0 MASKTFR: CH5 Mask                */
#define GPDMA0_MASKTFR_CH6_Pos                6                                                       /*!< GPDMA0 MASKTFR: CH6 Position            */
#define GPDMA0_MASKTFR_CH6_Msk                (0x01UL << GPDMA0_MASKTFR_CH6_Pos)                      /*!< GPDMA0 MASKTFR: CH6 Mask                */
#define GPDMA0_MASKTFR_CH7_Pos                7                                                       /*!< GPDMA0 MASKTFR: CH7 Position            */
#define GPDMA0_MASKTFR_CH7_Msk                (0x01UL << GPDMA0_MASKTFR_CH7_Pos)                      /*!< GPDMA0 MASKTFR: CH7 Mask                */
#define GPDMA0_MASKTFR_WE_CH0_Pos             8                                                       /*!< GPDMA0 MASKTFR: WE_CH0 Position         */
#define GPDMA0_MASKTFR_WE_CH0_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH0_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH0 Mask             */
#define GPDMA0_MASKTFR_WE_CH1_Pos             9                                                       /*!< GPDMA0 MASKTFR: WE_CH1 Position         */
#define GPDMA0_MASKTFR_WE_CH1_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH1_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH1 Mask             */
#define GPDMA0_MASKTFR_WE_CH2_Pos             10                                                      /*!< GPDMA0 MASKTFR: WE_CH2 Position         */
#define GPDMA0_MASKTFR_WE_CH2_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH2_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH2 Mask             */
#define GPDMA0_MASKTFR_WE_CH3_Pos             11                                                      /*!< GPDMA0 MASKTFR: WE_CH3 Position         */
#define GPDMA0_MASKTFR_WE_CH3_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH3_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH3 Mask             */
#define GPDMA0_MASKTFR_WE_CH4_Pos             12                                                      /*!< GPDMA0 MASKTFR: WE_CH4 Position         */
#define GPDMA0_MASKTFR_WE_CH4_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH4_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH4 Mask             */
#define GPDMA0_MASKTFR_WE_CH5_Pos             13                                                      /*!< GPDMA0 MASKTFR: WE_CH5 Position         */
#define GPDMA0_MASKTFR_WE_CH5_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH5_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH5 Mask             */
#define GPDMA0_MASKTFR_WE_CH6_Pos             14                                                      /*!< GPDMA0 MASKTFR: WE_CH6 Position         */
#define GPDMA0_MASKTFR_WE_CH6_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH6_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH6 Mask             */
#define GPDMA0_MASKTFR_WE_CH7_Pos             15                                                      /*!< GPDMA0 MASKTFR: WE_CH7 Position         */
#define GPDMA0_MASKTFR_WE_CH7_Msk             (0x01UL << GPDMA0_MASKTFR_WE_CH7_Pos)                   /*!< GPDMA0 MASKTFR: WE_CH7 Mask             */

/* ------------------------------  GPDMA0_MASKBLOCK  ------------------------------ */
#define GPDMA0_MASKBLOCK_CH0_Pos              0                                                       /*!< GPDMA0 MASKBLOCK: CH0 Position          */
#define GPDMA0_MASKBLOCK_CH0_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH0_Pos)                    /*!< GPDMA0 MASKBLOCK: CH0 Mask              */
#define GPDMA0_MASKBLOCK_CH1_Pos              1                                                       /*!< GPDMA0 MASKBLOCK: CH1 Position          */
#define GPDMA0_MASKBLOCK_CH1_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH1_Pos)                    /*!< GPDMA0 MASKBLOCK: CH1 Mask              */
#define GPDMA0_MASKBLOCK_CH2_Pos              2                                                       /*!< GPDMA0 MASKBLOCK: CH2 Position          */
#define GPDMA0_MASKBLOCK_CH2_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH2_Pos)                    /*!< GPDMA0 MASKBLOCK: CH2 Mask              */
#define GPDMA0_MASKBLOCK_CH3_Pos              3                                                       /*!< GPDMA0 MASKBLOCK: CH3 Position          */
#define GPDMA0_MASKBLOCK_CH3_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH3_Pos)                    /*!< GPDMA0 MASKBLOCK: CH3 Mask              */
#define GPDMA0_MASKBLOCK_CH4_Pos              4                                                       /*!< GPDMA0 MASKBLOCK: CH4 Position          */
#define GPDMA0_MASKBLOCK_CH4_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH4_Pos)                    /*!< GPDMA0 MASKBLOCK: CH4 Mask              */
#define GPDMA0_MASKBLOCK_CH5_Pos              5                                                       /*!< GPDMA0 MASKBLOCK: CH5 Position          */
#define GPDMA0_MASKBLOCK_CH5_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH5_Pos)                    /*!< GPDMA0 MASKBLOCK: CH5 Mask              */
#define GPDMA0_MASKBLOCK_CH6_Pos              6                                                       /*!< GPDMA0 MASKBLOCK: CH6 Position          */
#define GPDMA0_MASKBLOCK_CH6_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH6_Pos)                    /*!< GPDMA0 MASKBLOCK: CH6 Mask              */
#define GPDMA0_MASKBLOCK_CH7_Pos              7                                                       /*!< GPDMA0 MASKBLOCK: CH7 Position          */
#define GPDMA0_MASKBLOCK_CH7_Msk              (0x01UL << GPDMA0_MASKBLOCK_CH7_Pos)                    /*!< GPDMA0 MASKBLOCK: CH7 Mask              */
#define GPDMA0_MASKBLOCK_WE_CH0_Pos           8                                                       /*!< GPDMA0 MASKBLOCK: WE_CH0 Position       */
#define GPDMA0_MASKBLOCK_WE_CH0_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH0_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH0 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH1_Pos           9                                                       /*!< GPDMA0 MASKBLOCK: WE_CH1 Position       */
#define GPDMA0_MASKBLOCK_WE_CH1_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH1_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH1 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH2_Pos           10                                                      /*!< GPDMA0 MASKBLOCK: WE_CH2 Position       */
#define GPDMA0_MASKBLOCK_WE_CH2_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH2_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH2 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH3_Pos           11                                                      /*!< GPDMA0 MASKBLOCK: WE_CH3 Position       */
#define GPDMA0_MASKBLOCK_WE_CH3_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH3_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH3 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH4_Pos           12                                                      /*!< GPDMA0 MASKBLOCK: WE_CH4 Position       */
#define GPDMA0_MASKBLOCK_WE_CH4_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH4_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH4 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH5_Pos           13                                                      /*!< GPDMA0 MASKBLOCK: WE_CH5 Position       */
#define GPDMA0_MASKBLOCK_WE_CH5_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH5_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH5 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH6_Pos           14                                                      /*!< GPDMA0 MASKBLOCK: WE_CH6 Position       */
#define GPDMA0_MASKBLOCK_WE_CH6_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH6_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH6 Mask           */
#define GPDMA0_MASKBLOCK_WE_CH7_Pos           15                                                      /*!< GPDMA0 MASKBLOCK: WE_CH7 Position       */
#define GPDMA0_MASKBLOCK_WE_CH7_Msk           (0x01UL << GPDMA0_MASKBLOCK_WE_CH7_Pos)                 /*!< GPDMA0 MASKBLOCK: WE_CH7 Mask           */

/* -----------------------------  GPDMA0_MASKSRCTRAN  ----------------------------- */
#define GPDMA0_MASKSRCTRAN_CH0_Pos            0                                                       /*!< GPDMA0 MASKSRCTRAN: CH0 Position        */
#define GPDMA0_MASKSRCTRAN_CH0_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH0_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH0 Mask            */
#define GPDMA0_MASKSRCTRAN_CH1_Pos            1                                                       /*!< GPDMA0 MASKSRCTRAN: CH1 Position        */
#define GPDMA0_MASKSRCTRAN_CH1_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH1_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH1 Mask            */
#define GPDMA0_MASKSRCTRAN_CH2_Pos            2                                                       /*!< GPDMA0 MASKSRCTRAN: CH2 Position        */
#define GPDMA0_MASKSRCTRAN_CH2_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH2_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH2 Mask            */
#define GPDMA0_MASKSRCTRAN_CH3_Pos            3                                                       /*!< GPDMA0 MASKSRCTRAN: CH3 Position        */
#define GPDMA0_MASKSRCTRAN_CH3_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH3_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH3 Mask            */
#define GPDMA0_MASKSRCTRAN_CH4_Pos            4                                                       /*!< GPDMA0 MASKSRCTRAN: CH4 Position        */
#define GPDMA0_MASKSRCTRAN_CH4_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH4_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH4 Mask            */
#define GPDMA0_MASKSRCTRAN_CH5_Pos            5                                                       /*!< GPDMA0 MASKSRCTRAN: CH5 Position        */
#define GPDMA0_MASKSRCTRAN_CH5_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH5_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH5 Mask            */
#define GPDMA0_MASKSRCTRAN_CH6_Pos            6                                                       /*!< GPDMA0 MASKSRCTRAN: CH6 Position        */
#define GPDMA0_MASKSRCTRAN_CH6_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH6_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH6 Mask            */
#define GPDMA0_MASKSRCTRAN_CH7_Pos            7                                                       /*!< GPDMA0 MASKSRCTRAN: CH7 Position        */
#define GPDMA0_MASKSRCTRAN_CH7_Msk            (0x01UL << GPDMA0_MASKSRCTRAN_CH7_Pos)                  /*!< GPDMA0 MASKSRCTRAN: CH7 Mask            */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Pos         8                                                       /*!< GPDMA0 MASKSRCTRAN: WE_CH0 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH0_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH0 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Pos         9                                                       /*!< GPDMA0 MASKSRCTRAN: WE_CH1 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH1_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH1 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Pos         10                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH2 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH2_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH2 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Pos         11                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH3 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH3_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH3 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Pos         12                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH4 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH4_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH4 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Pos         13                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH5 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH5_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH5 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Pos         14                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH6 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH6_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH6 Mask         */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Pos         15                                                      /*!< GPDMA0 MASKSRCTRAN: WE_CH7 Position     */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Msk         (0x01UL << GPDMA0_MASKSRCTRAN_WE_CH7_Pos)               /*!< GPDMA0 MASKSRCTRAN: WE_CH7 Mask         */

/* -----------------------------  GPDMA0_MASKDSTTRAN  ----------------------------- */
#define GPDMA0_MASKDSTTRAN_CH0_Pos            0                                                       /*!< GPDMA0 MASKDSTTRAN: CH0 Position        */
#define GPDMA0_MASKDSTTRAN_CH0_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH0_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH0 Mask            */
#define GPDMA0_MASKDSTTRAN_CH1_Pos            1                                                       /*!< GPDMA0 MASKDSTTRAN: CH1 Position        */
#define GPDMA0_MASKDSTTRAN_CH1_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH1_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH1 Mask            */
#define GPDMA0_MASKDSTTRAN_CH2_Pos            2                                                       /*!< GPDMA0 MASKDSTTRAN: CH2 Position        */
#define GPDMA0_MASKDSTTRAN_CH2_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH2_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH2 Mask            */
#define GPDMA0_MASKDSTTRAN_CH3_Pos            3                                                       /*!< GPDMA0 MASKDSTTRAN: CH3 Position        */
#define GPDMA0_MASKDSTTRAN_CH3_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH3_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH3 Mask            */
#define GPDMA0_MASKDSTTRAN_CH4_Pos            4                                                       /*!< GPDMA0 MASKDSTTRAN: CH4 Position        */
#define GPDMA0_MASKDSTTRAN_CH4_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH4_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH4 Mask            */
#define GPDMA0_MASKDSTTRAN_CH5_Pos            5                                                       /*!< GPDMA0 MASKDSTTRAN: CH5 Position        */
#define GPDMA0_MASKDSTTRAN_CH5_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH5_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH5 Mask            */
#define GPDMA0_MASKDSTTRAN_CH6_Pos            6                                                       /*!< GPDMA0 MASKDSTTRAN: CH6 Position        */
#define GPDMA0_MASKDSTTRAN_CH6_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH6_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH6 Mask            */
#define GPDMA0_MASKDSTTRAN_CH7_Pos            7                                                       /*!< GPDMA0 MASKDSTTRAN: CH7 Position        */
#define GPDMA0_MASKDSTTRAN_CH7_Msk            (0x01UL << GPDMA0_MASKDSTTRAN_CH7_Pos)                  /*!< GPDMA0 MASKDSTTRAN: CH7 Mask            */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Pos         8                                                       /*!< GPDMA0 MASKDSTTRAN: WE_CH0 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH0_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH0 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Pos         9                                                       /*!< GPDMA0 MASKDSTTRAN: WE_CH1 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH1_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH1 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Pos         10                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH2 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH2_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH2 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Pos         11                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH3 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH3_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH3 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Pos         12                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH4 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH4_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH4 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Pos         13                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH5 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH5_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH5 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Pos         14                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH6 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH6_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH6 Mask         */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Pos         15                                                      /*!< GPDMA0 MASKDSTTRAN: WE_CH7 Position     */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Msk         (0x01UL << GPDMA0_MASKDSTTRAN_WE_CH7_Pos)               /*!< GPDMA0 MASKDSTTRAN: WE_CH7 Mask         */

/* -------------------------------  GPDMA0_MASKERR  ------------------------------- */
#define GPDMA0_MASKERR_CH0_Pos                0                                                       /*!< GPDMA0 MASKERR: CH0 Position            */
#define GPDMA0_MASKERR_CH0_Msk                (0x01UL << GPDMA0_MASKERR_CH0_Pos)                      /*!< GPDMA0 MASKERR: CH0 Mask                */
#define GPDMA0_MASKERR_CH1_Pos                1                                                       /*!< GPDMA0 MASKERR: CH1 Position            */
#define GPDMA0_MASKERR_CH1_Msk                (0x01UL << GPDMA0_MASKERR_CH1_Pos)                      /*!< GPDMA0 MASKERR: CH1 Mask                */
#define GPDMA0_MASKERR_CH2_Pos                2                                                       /*!< GPDMA0 MASKERR: CH2 Position            */
#define GPDMA0_MASKERR_CH2_Msk                (0x01UL << GPDMA0_MASKERR_CH2_Pos)                      /*!< GPDMA0 MASKERR: CH2 Mask                */
#define GPDMA0_MASKERR_CH3_Pos                3                                                       /*!< GPDMA0 MASKERR: CH3 Position            */
#define GPDMA0_MASKERR_CH3_Msk                (0x01UL << GPDMA0_MASKERR_CH3_Pos)                      /*!< GPDMA0 MASKERR: CH3 Mask                */
#define GPDMA0_MASKERR_CH4_Pos                4                                                       /*!< GPDMA0 MASKERR: CH4 Position            */
#define GPDMA0_MASKERR_CH4_Msk                (0x01UL << GPDMA0_MASKERR_CH4_Pos)                      /*!< GPDMA0 MASKERR: CH4 Mask                */
#define GPDMA0_MASKERR_CH5_Pos                5                                                       /*!< GPDMA0 MASKERR: CH5 Position            */
#define GPDMA0_MASKERR_CH5_Msk                (0x01UL << GPDMA0_MASKERR_CH5_Pos)                      /*!< GPDMA0 MASKERR: CH5 Mask                */
#define GPDMA0_MASKERR_CH6_Pos                6                                                       /*!< GPDMA0 MASKERR: CH6 Position            */
#define GPDMA0_MASKERR_CH6_Msk                (0x01UL << GPDMA0_MASKERR_CH6_Pos)                      /*!< GPDMA0 MASKERR: CH6 Mask                */
#define GPDMA0_MASKERR_CH7_Pos                7                                                       /*!< GPDMA0 MASKERR: CH7 Position            */
#define GPDMA0_MASKERR_CH7_Msk                (0x01UL << GPDMA0_MASKERR_CH7_Pos)                      /*!< GPDMA0 MASKERR: CH7 Mask                */
#define GPDMA0_MASKERR_WE_CH0_Pos             8                                                       /*!< GPDMA0 MASKERR: WE_CH0 Position         */
#define GPDMA0_MASKERR_WE_CH0_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH0_Pos)                   /*!< GPDMA0 MASKERR: WE_CH0 Mask             */
#define GPDMA0_MASKERR_WE_CH1_Pos             9                                                       /*!< GPDMA0 MASKERR: WE_CH1 Position         */
#define GPDMA0_MASKERR_WE_CH1_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH1_Pos)                   /*!< GPDMA0 MASKERR: WE_CH1 Mask             */
#define GPDMA0_MASKERR_WE_CH2_Pos             10                                                      /*!< GPDMA0 MASKERR: WE_CH2 Position         */
#define GPDMA0_MASKERR_WE_CH2_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH2_Pos)                   /*!< GPDMA0 MASKERR: WE_CH2 Mask             */
#define GPDMA0_MASKERR_WE_CH3_Pos             11                                                      /*!< GPDMA0 MASKERR: WE_CH3 Position         */
#define GPDMA0_MASKERR_WE_CH3_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH3_Pos)                   /*!< GPDMA0 MASKERR: WE_CH3 Mask             */
#define GPDMA0_MASKERR_WE_CH4_Pos             12                                                      /*!< GPDMA0 MASKERR: WE_CH4 Position         */
#define GPDMA0_MASKERR_WE_CH4_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH4_Pos)                   /*!< GPDMA0 MASKERR: WE_CH4 Mask             */
#define GPDMA0_MASKERR_WE_CH5_Pos             13                                                      /*!< GPDMA0 MASKERR: WE_CH5 Position         */
#define GPDMA0_MASKERR_WE_CH5_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH5_Pos)                   /*!< GPDMA0 MASKERR: WE_CH5 Mask             */
#define GPDMA0_MASKERR_WE_CH6_Pos             14                                                      /*!< GPDMA0 MASKERR: WE_CH6 Position         */
#define GPDMA0_MASKERR_WE_CH6_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH6_Pos)                   /*!< GPDMA0 MASKERR: WE_CH6 Mask             */
#define GPDMA0_MASKERR_WE_CH7_Pos             15                                                      /*!< GPDMA0 MASKERR: WE_CH7 Position         */
#define GPDMA0_MASKERR_WE_CH7_Msk             (0x01UL << GPDMA0_MASKERR_WE_CH7_Pos)                   /*!< GPDMA0 MASKERR: WE_CH7 Mask             */

/* -------------------------------  GPDMA0_CLEARTFR  ------------------------------ */
#define GPDMA0_CLEARTFR_CH0_Pos               0                                                       /*!< GPDMA0 CLEARTFR: CH0 Position           */
#define GPDMA0_CLEARTFR_CH0_Msk               (0x01UL << GPDMA0_CLEARTFR_CH0_Pos)                     /*!< GPDMA0 CLEARTFR: CH0 Mask               */
#define GPDMA0_CLEARTFR_CH1_Pos               1                                                       /*!< GPDMA0 CLEARTFR: CH1 Position           */
#define GPDMA0_CLEARTFR_CH1_Msk               (0x01UL << GPDMA0_CLEARTFR_CH1_Pos)                     /*!< GPDMA0 CLEARTFR: CH1 Mask               */
#define GPDMA0_CLEARTFR_CH2_Pos               2                                                       /*!< GPDMA0 CLEARTFR: CH2 Position           */
#define GPDMA0_CLEARTFR_CH2_Msk               (0x01UL << GPDMA0_CLEARTFR_CH2_Pos)                     /*!< GPDMA0 CLEARTFR: CH2 Mask               */
#define GPDMA0_CLEARTFR_CH3_Pos               3                                                       /*!< GPDMA0 CLEARTFR: CH3 Position           */
#define GPDMA0_CLEARTFR_CH3_Msk               (0x01UL << GPDMA0_CLEARTFR_CH3_Pos)                     /*!< GPDMA0 CLEARTFR: CH3 Mask               */
#define GPDMA0_CLEARTFR_CH4_Pos               4                                                       /*!< GPDMA0 CLEARTFR: CH4 Position           */
#define GPDMA0_CLEARTFR_CH4_Msk               (0x01UL << GPDMA0_CLEARTFR_CH4_Pos)                     /*!< GPDMA0 CLEARTFR: CH4 Mask               */
#define GPDMA0_CLEARTFR_CH5_Pos               5                                                       /*!< GPDMA0 CLEARTFR: CH5 Position           */
#define GPDMA0_CLEARTFR_CH5_Msk               (0x01UL << GPDMA0_CLEARTFR_CH5_Pos)                     /*!< GPDMA0 CLEARTFR: CH5 Mask               */
#define GPDMA0_CLEARTFR_CH6_Pos               6                                                       /*!< GPDMA0 CLEARTFR: CH6 Position           */
#define GPDMA0_CLEARTFR_CH6_Msk               (0x01UL << GPDMA0_CLEARTFR_CH6_Pos)                     /*!< GPDMA0 CLEARTFR: CH6 Mask               */
#define GPDMA0_CLEARTFR_CH7_Pos               7                                                       /*!< GPDMA0 CLEARTFR: CH7 Position           */
#define GPDMA0_CLEARTFR_CH7_Msk               (0x01UL << GPDMA0_CLEARTFR_CH7_Pos)                     /*!< GPDMA0 CLEARTFR: CH7 Mask               */

/* ------------------------------  GPDMA0_CLEARBLOCK  ----------------------------- */
#define GPDMA0_CLEARBLOCK_CH0_Pos             0                                                       /*!< GPDMA0 CLEARBLOCK: CH0 Position         */
#define GPDMA0_CLEARBLOCK_CH0_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH0_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH0 Mask             */
#define GPDMA0_CLEARBLOCK_CH1_Pos             1                                                       /*!< GPDMA0 CLEARBLOCK: CH1 Position         */
#define GPDMA0_CLEARBLOCK_CH1_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH1_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH1 Mask             */
#define GPDMA0_CLEARBLOCK_CH2_Pos             2                                                       /*!< GPDMA0 CLEARBLOCK: CH2 Position         */
#define GPDMA0_CLEARBLOCK_CH2_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH2_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH2 Mask             */
#define GPDMA0_CLEARBLOCK_CH3_Pos             3                                                       /*!< GPDMA0 CLEARBLOCK: CH3 Position         */
#define GPDMA0_CLEARBLOCK_CH3_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH3_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH3 Mask             */
#define GPDMA0_CLEARBLOCK_CH4_Pos             4                                                       /*!< GPDMA0 CLEARBLOCK: CH4 Position         */
#define GPDMA0_CLEARBLOCK_CH4_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH4_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH4 Mask             */
#define GPDMA0_CLEARBLOCK_CH5_Pos             5                                                       /*!< GPDMA0 CLEARBLOCK: CH5 Position         */
#define GPDMA0_CLEARBLOCK_CH5_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH5_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH5 Mask             */
#define GPDMA0_CLEARBLOCK_CH6_Pos             6                                                       /*!< GPDMA0 CLEARBLOCK: CH6 Position         */
#define GPDMA0_CLEARBLOCK_CH6_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH6_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH6 Mask             */
#define GPDMA0_CLEARBLOCK_CH7_Pos             7                                                       /*!< GPDMA0 CLEARBLOCK: CH7 Position         */
#define GPDMA0_CLEARBLOCK_CH7_Msk             (0x01UL << GPDMA0_CLEARBLOCK_CH7_Pos)                   /*!< GPDMA0 CLEARBLOCK: CH7 Mask             */

/* -----------------------------  GPDMA0_CLEARSRCTRAN  ---------------------------- */
#define GPDMA0_CLEARSRCTRAN_CH0_Pos           0                                                       /*!< GPDMA0 CLEARSRCTRAN: CH0 Position       */
#define GPDMA0_CLEARSRCTRAN_CH0_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH0_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH0 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH1_Pos           1                                                       /*!< GPDMA0 CLEARSRCTRAN: CH1 Position       */
#define GPDMA0_CLEARSRCTRAN_CH1_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH1_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH1 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH2_Pos           2                                                       /*!< GPDMA0 CLEARSRCTRAN: CH2 Position       */
#define GPDMA0_CLEARSRCTRAN_CH2_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH2_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH2 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH3_Pos           3                                                       /*!< GPDMA0 CLEARSRCTRAN: CH3 Position       */
#define GPDMA0_CLEARSRCTRAN_CH3_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH3_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH3 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH4_Pos           4                                                       /*!< GPDMA0 CLEARSRCTRAN: CH4 Position       */
#define GPDMA0_CLEARSRCTRAN_CH4_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH4_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH4 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH5_Pos           5                                                       /*!< GPDMA0 CLEARSRCTRAN: CH5 Position       */
#define GPDMA0_CLEARSRCTRAN_CH5_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH5_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH5 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH6_Pos           6                                                       /*!< GPDMA0 CLEARSRCTRAN: CH6 Position       */
#define GPDMA0_CLEARSRCTRAN_CH6_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH6_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH6 Mask           */
#define GPDMA0_CLEARSRCTRAN_CH7_Pos           7                                                       /*!< GPDMA0 CLEARSRCTRAN: CH7 Position       */
#define GPDMA0_CLEARSRCTRAN_CH7_Msk           (0x01UL << GPDMA0_CLEARSRCTRAN_CH7_Pos)                 /*!< GPDMA0 CLEARSRCTRAN: CH7 Mask           */

/* -----------------------------  GPDMA0_CLEARDSTTRAN  ---------------------------- */
#define GPDMA0_CLEARDSTTRAN_CH0_Pos           0                                                       /*!< GPDMA0 CLEARDSTTRAN: CH0 Position       */
#define GPDMA0_CLEARDSTTRAN_CH0_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH0_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH0 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH1_Pos           1                                                       /*!< GPDMA0 CLEARDSTTRAN: CH1 Position       */
#define GPDMA0_CLEARDSTTRAN_CH1_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH1_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH1 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH2_Pos           2                                                       /*!< GPDMA0 CLEARDSTTRAN: CH2 Position       */
#define GPDMA0_CLEARDSTTRAN_CH2_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH2_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH2 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH3_Pos           3                                                       /*!< GPDMA0 CLEARDSTTRAN: CH3 Position       */
#define GPDMA0_CLEARDSTTRAN_CH3_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH3_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH3 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH4_Pos           4                                                       /*!< GPDMA0 CLEARDSTTRAN: CH4 Position       */
#define GPDMA0_CLEARDSTTRAN_CH4_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH4_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH4 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH5_Pos           5                                                       /*!< GPDMA0 CLEARDSTTRAN: CH5 Position       */
#define GPDMA0_CLEARDSTTRAN_CH5_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH5_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH5 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH6_Pos           6                                                       /*!< GPDMA0 CLEARDSTTRAN: CH6 Position       */
#define GPDMA0_CLEARDSTTRAN_CH6_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH6_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH6 Mask           */
#define GPDMA0_CLEARDSTTRAN_CH7_Pos           7                                                       /*!< GPDMA0 CLEARDSTTRAN: CH7 Position       */
#define GPDMA0_CLEARDSTTRAN_CH7_Msk           (0x01UL << GPDMA0_CLEARDSTTRAN_CH7_Pos)                 /*!< GPDMA0 CLEARDSTTRAN: CH7 Mask           */

/* -------------------------------  GPDMA0_CLEARERR  ------------------------------ */
#define GPDMA0_CLEARERR_CH0_Pos               0                                                       /*!< GPDMA0 CLEARERR: CH0 Position           */
#define GPDMA0_CLEARERR_CH0_Msk               (0x01UL << GPDMA0_CLEARERR_CH0_Pos)                     /*!< GPDMA0 CLEARERR: CH0 Mask               */
#define GPDMA0_CLEARERR_CH1_Pos               1                                                       /*!< GPDMA0 CLEARERR: CH1 Position           */
#define GPDMA0_CLEARERR_CH1_Msk               (0x01UL << GPDMA0_CLEARERR_CH1_Pos)                     /*!< GPDMA0 CLEARERR: CH1 Mask               */
#define GPDMA0_CLEARERR_CH2_Pos               2                                                       /*!< GPDMA0 CLEARERR: CH2 Position           */
#define GPDMA0_CLEARERR_CH2_Msk               (0x01UL << GPDMA0_CLEARERR_CH2_Pos)                     /*!< GPDMA0 CLEARERR: CH2 Mask               */
#define GPDMA0_CLEARERR_CH3_Pos               3                                                       /*!< GPDMA0 CLEARERR: CH3 Position           */
#define GPDMA0_CLEARERR_CH3_Msk               (0x01UL << GPDMA0_CLEARERR_CH3_Pos)                     /*!< GPDMA0 CLEARERR: CH3 Mask               */
#define GPDMA0_CLEARERR_CH4_Pos               4                                                       /*!< GPDMA0 CLEARERR: CH4 Position           */
#define GPDMA0_CLEARERR_CH4_Msk               (0x01UL << GPDMA0_CLEARERR_CH4_Pos)                     /*!< GPDMA0 CLEARERR: CH4 Mask               */
#define GPDMA0_CLEARERR_CH5_Pos               5                                                       /*!< GPDMA0 CLEARERR: CH5 Position           */
#define GPDMA0_CLEARERR_CH5_Msk               (0x01UL << GPDMA0_CLEARERR_CH5_Pos)                     /*!< GPDMA0 CLEARERR: CH5 Mask               */
#define GPDMA0_CLEARERR_CH6_Pos               6                                                       /*!< GPDMA0 CLEARERR: CH6 Position           */
#define GPDMA0_CLEARERR_CH6_Msk               (0x01UL << GPDMA0_CLEARERR_CH6_Pos)                     /*!< GPDMA0 CLEARERR: CH6 Mask               */
#define GPDMA0_CLEARERR_CH7_Pos               7                                                       /*!< GPDMA0 CLEARERR: CH7 Position           */
#define GPDMA0_CLEARERR_CH7_Msk               (0x01UL << GPDMA0_CLEARERR_CH7_Pos)                     /*!< GPDMA0 CLEARERR: CH7 Mask               */

/* ------------------------------  GPDMA0_STATUSINT  ------------------------------ */
#define GPDMA0_STATUSINT_TFR_Pos              0                                                       /*!< GPDMA0 STATUSINT: TFR Position          */
#define GPDMA0_STATUSINT_TFR_Msk              (0x01UL << GPDMA0_STATUSINT_TFR_Pos)                    /*!< GPDMA0 STATUSINT: TFR Mask              */
#define GPDMA0_STATUSINT_BLOCK_Pos            1                                                       /*!< GPDMA0 STATUSINT: BLOCK Position        */
#define GPDMA0_STATUSINT_BLOCK_Msk            (0x01UL << GPDMA0_STATUSINT_BLOCK_Pos)                  /*!< GPDMA0 STATUSINT: BLOCK Mask            */
#define GPDMA0_STATUSINT_SRCT_Pos             2                                                       /*!< GPDMA0 STATUSINT: SRCT Position         */
#define GPDMA0_STATUSINT_SRCT_Msk             (0x01UL << GPDMA0_STATUSINT_SRCT_Pos)                   /*!< GPDMA0 STATUSINT: SRCT Mask             */
#define GPDMA0_STATUSINT_DSTT_Pos             3                                                       /*!< GPDMA0 STATUSINT: DSTT Position         */
#define GPDMA0_STATUSINT_DSTT_Msk             (0x01UL << GPDMA0_STATUSINT_DSTT_Pos)                   /*!< GPDMA0 STATUSINT: DSTT Mask             */
#define GPDMA0_STATUSINT_ERR_Pos              4                                                       /*!< GPDMA0 STATUSINT: ERR Position          */
#define GPDMA0_STATUSINT_ERR_Msk              (0x01UL << GPDMA0_STATUSINT_ERR_Pos)                    /*!< GPDMA0 STATUSINT: ERR Mask              */

/* ------------------------------  GPDMA0_REQSRCREG  ------------------------------ */
#define GPDMA0_REQSRCREG_CH0_Pos              0                                                       /*!< GPDMA0 REQSRCREG: CH0 Position          */
#define GPDMA0_REQSRCREG_CH0_Msk              (0x01UL << GPDMA0_REQSRCREG_CH0_Pos)                    /*!< GPDMA0 REQSRCREG: CH0 Mask              */
#define GPDMA0_REQSRCREG_CH1_Pos              1                                                       /*!< GPDMA0 REQSRCREG: CH1 Position          */
#define GPDMA0_REQSRCREG_CH1_Msk              (0x01UL << GPDMA0_REQSRCREG_CH1_Pos)                    /*!< GPDMA0 REQSRCREG: CH1 Mask              */
#define GPDMA0_REQSRCREG_CH2_Pos              2                                                       /*!< GPDMA0 REQSRCREG: CH2 Position          */
#define GPDMA0_REQSRCREG_CH2_Msk              (0x01UL << GPDMA0_REQSRCREG_CH2_Pos)                    /*!< GPDMA0 REQSRCREG: CH2 Mask              */
#define GPDMA0_REQSRCREG_CH3_Pos              3                                                       /*!< GPDMA0 REQSRCREG: CH3 Position          */
#define GPDMA0_REQSRCREG_CH3_Msk              (0x01UL << GPDMA0_REQSRCREG_CH3_Pos)                    /*!< GPDMA0 REQSRCREG: CH3 Mask              */
#define GPDMA0_REQSRCREG_CH4_Pos              4                                                       /*!< GPDMA0 REQSRCREG: CH4 Position          */
#define GPDMA0_REQSRCREG_CH4_Msk              (0x01UL << GPDMA0_REQSRCREG_CH4_Pos)                    /*!< GPDMA0 REQSRCREG: CH4 Mask              */
#define GPDMA0_REQSRCREG_CH5_Pos              5                                                       /*!< GPDMA0 REQSRCREG: CH5 Position          */
#define GPDMA0_REQSRCREG_CH5_Msk              (0x01UL << GPDMA0_REQSRCREG_CH5_Pos)                    /*!< GPDMA0 REQSRCREG: CH5 Mask              */
#define GPDMA0_REQSRCREG_CH6_Pos              6                                                       /*!< GPDMA0 REQSRCREG: CH6 Position          */
#define GPDMA0_REQSRCREG_CH6_Msk              (0x01UL << GPDMA0_REQSRCREG_CH6_Pos)                    /*!< GPDMA0 REQSRCREG: CH6 Mask              */
#define GPDMA0_REQSRCREG_CH7_Pos              7                                                       /*!< GPDMA0 REQSRCREG: CH7 Position          */
#define GPDMA0_REQSRCREG_CH7_Msk              (0x01UL << GPDMA0_REQSRCREG_CH7_Pos)                    /*!< GPDMA0 REQSRCREG: CH7 Mask              */
#define GPDMA0_REQSRCREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 REQSRCREG: WE_CH0 Position       */
#define GPDMA0_REQSRCREG_WE_CH0_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH0_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH0 Mask           */
#define GPDMA0_REQSRCREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 REQSRCREG: WE_CH1 Position       */
#define GPDMA0_REQSRCREG_WE_CH1_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH1_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH1 Mask           */
#define GPDMA0_REQSRCREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 REQSRCREG: WE_CH2 Position       */
#define GPDMA0_REQSRCREG_WE_CH2_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH2_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH2 Mask           */
#define GPDMA0_REQSRCREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 REQSRCREG: WE_CH3 Position       */
#define GPDMA0_REQSRCREG_WE_CH3_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH3_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH3 Mask           */
#define GPDMA0_REQSRCREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 REQSRCREG: WE_CH4 Position       */
#define GPDMA0_REQSRCREG_WE_CH4_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH4_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH4 Mask           */
#define GPDMA0_REQSRCREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 REQSRCREG: WE_CH5 Position       */
#define GPDMA0_REQSRCREG_WE_CH5_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH5_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH5 Mask           */
#define GPDMA0_REQSRCREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 REQSRCREG: WE_CH6 Position       */
#define GPDMA0_REQSRCREG_WE_CH6_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH6_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH6 Mask           */
#define GPDMA0_REQSRCREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 REQSRCREG: WE_CH7 Position       */
#define GPDMA0_REQSRCREG_WE_CH7_Msk           (0x01UL << GPDMA0_REQSRCREG_WE_CH7_Pos)                 /*!< GPDMA0 REQSRCREG: WE_CH7 Mask           */

/* ------------------------------  GPDMA0_REQDSTREG  ------------------------------ */
#define GPDMA0_REQDSTREG_CH0_Pos              0                                                       /*!< GPDMA0 REQDSTREG: CH0 Position          */
#define GPDMA0_REQDSTREG_CH0_Msk              (0x01UL << GPDMA0_REQDSTREG_CH0_Pos)                    /*!< GPDMA0 REQDSTREG: CH0 Mask              */
#define GPDMA0_REQDSTREG_CH1_Pos              1                                                       /*!< GPDMA0 REQDSTREG: CH1 Position          */
#define GPDMA0_REQDSTREG_CH1_Msk              (0x01UL << GPDMA0_REQDSTREG_CH1_Pos)                    /*!< GPDMA0 REQDSTREG: CH1 Mask              */
#define GPDMA0_REQDSTREG_CH2_Pos              2                                                       /*!< GPDMA0 REQDSTREG: CH2 Position          */
#define GPDMA0_REQDSTREG_CH2_Msk              (0x01UL << GPDMA0_REQDSTREG_CH2_Pos)                    /*!< GPDMA0 REQDSTREG: CH2 Mask              */
#define GPDMA0_REQDSTREG_CH3_Pos              3                                                       /*!< GPDMA0 REQDSTREG: CH3 Position          */
#define GPDMA0_REQDSTREG_CH3_Msk              (0x01UL << GPDMA0_REQDSTREG_CH3_Pos)                    /*!< GPDMA0 REQDSTREG: CH3 Mask              */
#define GPDMA0_REQDSTREG_CH4_Pos              4                                                       /*!< GPDMA0 REQDSTREG: CH4 Position          */
#define GPDMA0_REQDSTREG_CH4_Msk              (0x01UL << GPDMA0_REQDSTREG_CH4_Pos)                    /*!< GPDMA0 REQDSTREG: CH4 Mask              */
#define GPDMA0_REQDSTREG_CH5_Pos              5                                                       /*!< GPDMA0 REQDSTREG: CH5 Position          */
#define GPDMA0_REQDSTREG_CH5_Msk              (0x01UL << GPDMA0_REQDSTREG_CH5_Pos)                    /*!< GPDMA0 REQDSTREG: CH5 Mask              */
#define GPDMA0_REQDSTREG_CH6_Pos              6                                                       /*!< GPDMA0 REQDSTREG: CH6 Position          */
#define GPDMA0_REQDSTREG_CH6_Msk              (0x01UL << GPDMA0_REQDSTREG_CH6_Pos)                    /*!< GPDMA0 REQDSTREG: CH6 Mask              */
#define GPDMA0_REQDSTREG_CH7_Pos              7                                                       /*!< GPDMA0 REQDSTREG: CH7 Position          */
#define GPDMA0_REQDSTREG_CH7_Msk              (0x01UL << GPDMA0_REQDSTREG_CH7_Pos)                    /*!< GPDMA0 REQDSTREG: CH7 Mask              */
#define GPDMA0_REQDSTREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 REQDSTREG: WE_CH0 Position       */
#define GPDMA0_REQDSTREG_WE_CH0_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH0_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH0 Mask           */
#define GPDMA0_REQDSTREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 REQDSTREG: WE_CH1 Position       */
#define GPDMA0_REQDSTREG_WE_CH1_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH1_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH1 Mask           */
#define GPDMA0_REQDSTREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 REQDSTREG: WE_CH2 Position       */
#define GPDMA0_REQDSTREG_WE_CH2_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH2_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH2 Mask           */
#define GPDMA0_REQDSTREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 REQDSTREG: WE_CH3 Position       */
#define GPDMA0_REQDSTREG_WE_CH3_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH3_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH3 Mask           */
#define GPDMA0_REQDSTREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 REQDSTREG: WE_CH4 Position       */
#define GPDMA0_REQDSTREG_WE_CH4_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH4_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH4 Mask           */
#define GPDMA0_REQDSTREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 REQDSTREG: WE_CH5 Position       */
#define GPDMA0_REQDSTREG_WE_CH5_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH5_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH5 Mask           */
#define GPDMA0_REQDSTREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 REQDSTREG: WE_CH6 Position       */
#define GPDMA0_REQDSTREG_WE_CH6_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH6_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH6 Mask           */
#define GPDMA0_REQDSTREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 REQDSTREG: WE_CH7 Position       */
#define GPDMA0_REQDSTREG_WE_CH7_Msk           (0x01UL << GPDMA0_REQDSTREG_WE_CH7_Pos)                 /*!< GPDMA0 REQDSTREG: WE_CH7 Mask           */

/* -----------------------------  GPDMA0_SGLREQSRCREG  ---------------------------- */
#define GPDMA0_SGLREQSRCREG_CH0_Pos           0                                                       /*!< GPDMA0 SGLREQSRCREG: CH0 Position       */
#define GPDMA0_SGLREQSRCREG_CH0_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH0_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH0 Mask           */
#define GPDMA0_SGLREQSRCREG_CH1_Pos           1                                                       /*!< GPDMA0 SGLREQSRCREG: CH1 Position       */
#define GPDMA0_SGLREQSRCREG_CH1_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH1_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH1 Mask           */
#define GPDMA0_SGLREQSRCREG_CH2_Pos           2                                                       /*!< GPDMA0 SGLREQSRCREG: CH2 Position       */
#define GPDMA0_SGLREQSRCREG_CH2_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH2_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH2 Mask           */
#define GPDMA0_SGLREQSRCREG_CH3_Pos           3                                                       /*!< GPDMA0 SGLREQSRCREG: CH3 Position       */
#define GPDMA0_SGLREQSRCREG_CH3_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH3_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH3 Mask           */
#define GPDMA0_SGLREQSRCREG_CH4_Pos           4                                                       /*!< GPDMA0 SGLREQSRCREG: CH4 Position       */
#define GPDMA0_SGLREQSRCREG_CH4_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH4_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH4 Mask           */
#define GPDMA0_SGLREQSRCREG_CH5_Pos           5                                                       /*!< GPDMA0 SGLREQSRCREG: CH5 Position       */
#define GPDMA0_SGLREQSRCREG_CH5_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH5_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH5 Mask           */
#define GPDMA0_SGLREQSRCREG_CH6_Pos           6                                                       /*!< GPDMA0 SGLREQSRCREG: CH6 Position       */
#define GPDMA0_SGLREQSRCREG_CH6_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH6_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH6 Mask           */
#define GPDMA0_SGLREQSRCREG_CH7_Pos           7                                                       /*!< GPDMA0 SGLREQSRCREG: CH7 Position       */
#define GPDMA0_SGLREQSRCREG_CH7_Msk           (0x01UL << GPDMA0_SGLREQSRCREG_CH7_Pos)                 /*!< GPDMA0 SGLREQSRCREG: CH7 Mask           */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Pos        8                                                       /*!< GPDMA0 SGLREQSRCREG: WE_CH0 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH0_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH0 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Pos        9                                                       /*!< GPDMA0 SGLREQSRCREG: WE_CH1 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH1_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH1 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Pos        10                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH2 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH2_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH2 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Pos        11                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH3 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH3_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH3 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Pos        12                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH4 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH4_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH4 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Pos        13                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH5 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH5_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH5 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Pos        14                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH6 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH6_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH6 Mask        */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Pos        15                                                      /*!< GPDMA0 SGLREQSRCREG: WE_CH7 Position    */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Msk        (0x01UL << GPDMA0_SGLREQSRCREG_WE_CH7_Pos)              /*!< GPDMA0 SGLREQSRCREG: WE_CH7 Mask        */

/* -----------------------------  GPDMA0_SGLREQDSTREG  ---------------------------- */
#define GPDMA0_SGLREQDSTREG_CH0_Pos           0                                                       /*!< GPDMA0 SGLREQDSTREG: CH0 Position       */
#define GPDMA0_SGLREQDSTREG_CH0_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH0_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH0 Mask           */
#define GPDMA0_SGLREQDSTREG_CH1_Pos           1                                                       /*!< GPDMA0 SGLREQDSTREG: CH1 Position       */
#define GPDMA0_SGLREQDSTREG_CH1_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH1_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH1 Mask           */
#define GPDMA0_SGLREQDSTREG_CH2_Pos           2                                                       /*!< GPDMA0 SGLREQDSTREG: CH2 Position       */
#define GPDMA0_SGLREQDSTREG_CH2_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH2_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH2 Mask           */
#define GPDMA0_SGLREQDSTREG_CH3_Pos           3                                                       /*!< GPDMA0 SGLREQDSTREG: CH3 Position       */
#define GPDMA0_SGLREQDSTREG_CH3_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH3_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH3 Mask           */
#define GPDMA0_SGLREQDSTREG_CH4_Pos           4                                                       /*!< GPDMA0 SGLREQDSTREG: CH4 Position       */
#define GPDMA0_SGLREQDSTREG_CH4_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH4_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH4 Mask           */
#define GPDMA0_SGLREQDSTREG_CH5_Pos           5                                                       /*!< GPDMA0 SGLREQDSTREG: CH5 Position       */
#define GPDMA0_SGLREQDSTREG_CH5_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH5_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH5 Mask           */
#define GPDMA0_SGLREQDSTREG_CH6_Pos           6                                                       /*!< GPDMA0 SGLREQDSTREG: CH6 Position       */
#define GPDMA0_SGLREQDSTREG_CH6_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH6_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH6 Mask           */
#define GPDMA0_SGLREQDSTREG_CH7_Pos           7                                                       /*!< GPDMA0 SGLREQDSTREG: CH7 Position       */
#define GPDMA0_SGLREQDSTREG_CH7_Msk           (0x01UL << GPDMA0_SGLREQDSTREG_CH7_Pos)                 /*!< GPDMA0 SGLREQDSTREG: CH7 Mask           */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Pos        8                                                       /*!< GPDMA0 SGLREQDSTREG: WE_CH0 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH0_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH0 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Pos        9                                                       /*!< GPDMA0 SGLREQDSTREG: WE_CH1 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH1_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH1 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Pos        10                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH2 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH2_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH2 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Pos        11                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH3 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH3_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH3 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Pos        12                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH4 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH4_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH4 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Pos        13                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH5 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH5_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH5 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Pos        14                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH6 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH6_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH6 Mask        */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Pos        15                                                      /*!< GPDMA0 SGLREQDSTREG: WE_CH7 Position    */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Msk        (0x01UL << GPDMA0_SGLREQDSTREG_WE_CH7_Pos)              /*!< GPDMA0 SGLREQDSTREG: WE_CH7 Mask        */

/* ------------------------------  GPDMA0_LSTSRCREG  ------------------------------ */
#define GPDMA0_LSTSRCREG_CH0_Pos              0                                                       /*!< GPDMA0 LSTSRCREG: CH0 Position          */
#define GPDMA0_LSTSRCREG_CH0_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH0_Pos)                    /*!< GPDMA0 LSTSRCREG: CH0 Mask              */
#define GPDMA0_LSTSRCREG_CH1_Pos              1                                                       /*!< GPDMA0 LSTSRCREG: CH1 Position          */
#define GPDMA0_LSTSRCREG_CH1_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH1_Pos)                    /*!< GPDMA0 LSTSRCREG: CH1 Mask              */
#define GPDMA0_LSTSRCREG_CH2_Pos              2                                                       /*!< GPDMA0 LSTSRCREG: CH2 Position          */
#define GPDMA0_LSTSRCREG_CH2_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH2_Pos)                    /*!< GPDMA0 LSTSRCREG: CH2 Mask              */
#define GPDMA0_LSTSRCREG_CH3_Pos              3                                                       /*!< GPDMA0 LSTSRCREG: CH3 Position          */
#define GPDMA0_LSTSRCREG_CH3_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH3_Pos)                    /*!< GPDMA0 LSTSRCREG: CH3 Mask              */
#define GPDMA0_LSTSRCREG_CH4_Pos              4                                                       /*!< GPDMA0 LSTSRCREG: CH4 Position          */
#define GPDMA0_LSTSRCREG_CH4_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH4_Pos)                    /*!< GPDMA0 LSTSRCREG: CH4 Mask              */
#define GPDMA0_LSTSRCREG_CH5_Pos              5                                                       /*!< GPDMA0 LSTSRCREG: CH5 Position          */
#define GPDMA0_LSTSRCREG_CH5_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH5_Pos)                    /*!< GPDMA0 LSTSRCREG: CH5 Mask              */
#define GPDMA0_LSTSRCREG_CH6_Pos              6                                                       /*!< GPDMA0 LSTSRCREG: CH6 Position          */
#define GPDMA0_LSTSRCREG_CH6_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH6_Pos)                    /*!< GPDMA0 LSTSRCREG: CH6 Mask              */
#define GPDMA0_LSTSRCREG_CH7_Pos              7                                                       /*!< GPDMA0 LSTSRCREG: CH7 Position          */
#define GPDMA0_LSTSRCREG_CH7_Msk              (0x01UL << GPDMA0_LSTSRCREG_CH7_Pos)                    /*!< GPDMA0 LSTSRCREG: CH7 Mask              */
#define GPDMA0_LSTSRCREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 LSTSRCREG: WE_CH0 Position       */
#define GPDMA0_LSTSRCREG_WE_CH0_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH0_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH0 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 LSTSRCREG: WE_CH1 Position       */
#define GPDMA0_LSTSRCREG_WE_CH1_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH1_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH1 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 LSTSRCREG: WE_CH2 Position       */
#define GPDMA0_LSTSRCREG_WE_CH2_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH2_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH2 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 LSTSRCREG: WE_CH3 Position       */
#define GPDMA0_LSTSRCREG_WE_CH3_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH3_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH3 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 LSTSRCREG: WE_CH4 Position       */
#define GPDMA0_LSTSRCREG_WE_CH4_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH4_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH4 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 LSTSRCREG: WE_CH5 Position       */
#define GPDMA0_LSTSRCREG_WE_CH5_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH5_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH5 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 LSTSRCREG: WE_CH6 Position       */
#define GPDMA0_LSTSRCREG_WE_CH6_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH6_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH6 Mask           */
#define GPDMA0_LSTSRCREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 LSTSRCREG: WE_CH7 Position       */
#define GPDMA0_LSTSRCREG_WE_CH7_Msk           (0x01UL << GPDMA0_LSTSRCREG_WE_CH7_Pos)                 /*!< GPDMA0 LSTSRCREG: WE_CH7 Mask           */

/* ------------------------------  GPDMA0_LSTDSTREG  ------------------------------ */
#define GPDMA0_LSTDSTREG_CH0_Pos              0                                                       /*!< GPDMA0 LSTDSTREG: CH0 Position          */
#define GPDMA0_LSTDSTREG_CH0_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH0_Pos)                    /*!< GPDMA0 LSTDSTREG: CH0 Mask              */
#define GPDMA0_LSTDSTREG_CH1_Pos              1                                                       /*!< GPDMA0 LSTDSTREG: CH1 Position          */
#define GPDMA0_LSTDSTREG_CH1_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH1_Pos)                    /*!< GPDMA0 LSTDSTREG: CH1 Mask              */
#define GPDMA0_LSTDSTREG_CH2_Pos              2                                                       /*!< GPDMA0 LSTDSTREG: CH2 Position          */
#define GPDMA0_LSTDSTREG_CH2_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH2_Pos)                    /*!< GPDMA0 LSTDSTREG: CH2 Mask              */
#define GPDMA0_LSTDSTREG_CH3_Pos              3                                                       /*!< GPDMA0 LSTDSTREG: CH3 Position          */
#define GPDMA0_LSTDSTREG_CH3_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH3_Pos)                    /*!< GPDMA0 LSTDSTREG: CH3 Mask              */
#define GPDMA0_LSTDSTREG_CH4_Pos              4                                                       /*!< GPDMA0 LSTDSTREG: CH4 Position          */
#define GPDMA0_LSTDSTREG_CH4_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH4_Pos)                    /*!< GPDMA0 LSTDSTREG: CH4 Mask              */
#define GPDMA0_LSTDSTREG_CH5_Pos              5                                                       /*!< GPDMA0 LSTDSTREG: CH5 Position          */
#define GPDMA0_LSTDSTREG_CH5_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH5_Pos)                    /*!< GPDMA0 LSTDSTREG: CH5 Mask              */
#define GPDMA0_LSTDSTREG_CH6_Pos              6                                                       /*!< GPDMA0 LSTDSTREG: CH6 Position          */
#define GPDMA0_LSTDSTREG_CH6_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH6_Pos)                    /*!< GPDMA0 LSTDSTREG: CH6 Mask              */
#define GPDMA0_LSTDSTREG_CH7_Pos              7                                                       /*!< GPDMA0 LSTDSTREG: CH7 Position          */
#define GPDMA0_LSTDSTREG_CH7_Msk              (0x01UL << GPDMA0_LSTDSTREG_CH7_Pos)                    /*!< GPDMA0 LSTDSTREG: CH7 Mask              */
#define GPDMA0_LSTDSTREG_WE_CH0_Pos           8                                                       /*!< GPDMA0 LSTDSTREG: WE_CH0 Position       */
#define GPDMA0_LSTDSTREG_WE_CH0_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH0_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH0 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH1_Pos           9                                                       /*!< GPDMA0 LSTDSTREG: WE_CH1 Position       */
#define GPDMA0_LSTDSTREG_WE_CH1_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH1_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH1 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH2_Pos           10                                                      /*!< GPDMA0 LSTDSTREG: WE_CH2 Position       */
#define GPDMA0_LSTDSTREG_WE_CH2_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH2_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH2 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH3_Pos           11                                                      /*!< GPDMA0 LSTDSTREG: WE_CH3 Position       */
#define GPDMA0_LSTDSTREG_WE_CH3_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH3_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH3 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH4_Pos           12                                                      /*!< GPDMA0 LSTDSTREG: WE_CH4 Position       */
#define GPDMA0_LSTDSTREG_WE_CH4_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH4_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH4 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH5_Pos           13                                                      /*!< GPDMA0 LSTDSTREG: WE_CH5 Position       */
#define GPDMA0_LSTDSTREG_WE_CH5_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH5_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH5 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH6_Pos           14                                                      /*!< GPDMA0 LSTDSTREG: WE_CH6 Position       */
#define GPDMA0_LSTDSTREG_WE_CH6_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH6_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH6 Mask           */
#define GPDMA0_LSTDSTREG_WE_CH7_Pos           15                                                      /*!< GPDMA0 LSTDSTREG: WE_CH7 Position       */
#define GPDMA0_LSTDSTREG_WE_CH7_Msk           (0x01UL << GPDMA0_LSTDSTREG_WE_CH7_Pos)                 /*!< GPDMA0 LSTDSTREG: WE_CH7 Mask           */

/* ------------------------------  GPDMA0_DMACFGREG  ------------------------------ */
#define GPDMA0_DMACFGREG_DMA_EN_Pos           0                                                       /*!< GPDMA0 DMACFGREG: DMA_EN Position       */
#define GPDMA0_DMACFGREG_DMA_EN_Msk           (0x01UL << GPDMA0_DMACFGREG_DMA_EN_Pos)                 /*!< GPDMA0 DMACFGREG: DMA_EN Mask           */

/* -------------------------------  GPDMA0_CHENREG  ------------------------------- */
#define GPDMA0_CHENREG_CH_Pos                 0                                                       /*!< GPDMA0 CHENREG: CH Position             */
#define GPDMA0_CHENREG_CH_Msk                 (0x000000ffUL << GPDMA0_CHENREG_CH_Pos)                 /*!< GPDMA0 CHENREG: CH Mask                 */
#define GPDMA0_CHENREG_WE_CH_Pos              8                                                       /*!< GPDMA0 CHENREG: WE_CH Position          */
#define GPDMA0_CHENREG_WE_CH_Msk              (0x000000ffUL << GPDMA0_CHENREG_WE_CH_Pos)              /*!< GPDMA0 CHENREG: WE_CH Mask              */

/* ----------------------------------  GPDMA0_ID  --------------------------------- */
#define GPDMA0_ID_VALUE_Pos                   0                                                       /*!< GPDMA0 ID: VALUE Position               */
#define GPDMA0_ID_VALUE_Msk                   (0xffffffffUL << GPDMA0_ID_VALUE_Pos)                   /*!< GPDMA0 ID: VALUE Mask                   */

/* ---------------------------------  GPDMA0_TYPE  -------------------------------- */
#define GPDMA0_TYPE_VALUE_Pos                 0                                                       /*!< GPDMA0 TYPE: VALUE Position             */
#define GPDMA0_TYPE_VALUE_Msk                 (0xffffffffUL << GPDMA0_TYPE_VALUE_Pos)                 /*!< GPDMA0 TYPE: VALUE Mask                 */

/* -------------------------------  GPDMA0_VERSION  ------------------------------- */
#define GPDMA0_VERSION_VALUE_Pos              0                                                       /*!< GPDMA0 VERSION: VALUE Position          */
#define GPDMA0_VERSION_VALUE_Msk              (0xffffffffUL << GPDMA0_VERSION_VALUE_Pos)              /*!< GPDMA0 VERSION: VALUE Mask              */


/* ================================================================================ */
/* ================      Group 'GPDMA0_CH0_1' Position & Mask      ================ */
/* ================================================================================ */


/* ------------------------------  GPDMA0_CH_SAR  ------------------------------ */
#define GPDMA0_CH_SAR_SAR_Pos              0                                                       /*!< GPDMA0_CH0_1 SAR: SAR Position          */
#define GPDMA0_CH_SAR_SAR_Msk              (0xffffffffUL << GPDMA0_CH_SAR_SAR_Pos)              /*!< GPDMA0_CH0_1 SAR: SAR Mask              */

/* ------------------------------  GPDMA0_CH_DAR  ------------------------------ */
#define GPDMA0_CH_DAR_DAR_Pos              0                                                       /*!< GPDMA0_CH0_1 DAR: DAR Position          */
#define GPDMA0_CH_DAR_DAR_Msk              (0xffffffffUL << GPDMA0_CH_DAR_DAR_Pos)              /*!< GPDMA0_CH0_1 DAR: DAR Mask              */

/* ------------------------------  GPDMA0_CH_LLP  ------------------------------ */
#define GPDMA0_CH_LLP_LOC_Pos              2                                                       /*!< GPDMA0_CH0_1 LLP: LOC Position          */
#define GPDMA0_CH_LLP_LOC_Msk              (0x3fffffffUL << GPDMA0_CH_LLP_LOC_Pos)              /*!< GPDMA0_CH0_1 LLP: LOC Mask              */

/* ------------------------------  GPDMA0_CH_CTLL  ----------------------------- */
#define GPDMA0_CH_CTLL_INT_EN_Pos          0                                                       /*!< GPDMA0_CH0_1 CTLL: INT_EN Position      */
#define GPDMA0_CH_CTLL_INT_EN_Msk          (0x01UL << GPDMA0_CH_CTLL_INT_EN_Pos)                /*!< GPDMA0_CH0_1 CTLL: INT_EN Mask          */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Pos    1                                                       /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH Position */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Msk    (0x07UL << GPDMA0_CH_CTLL_DST_TR_WIDTH_Pos)          /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH Mask    */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Pos    4                                                       /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH Position */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Msk    (0x07UL << GPDMA0_CH_CTLL_SRC_TR_WIDTH_Pos)          /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH Mask    */
#define GPDMA0_CH_CTLL_DINC_Pos            7                                                       /*!< GPDMA0_CH0_1 CTLL: DINC Position        */
#define GPDMA0_CH_CTLL_DINC_Msk            (0x03UL << GPDMA0_CH_CTLL_DINC_Pos)                  /*!< GPDMA0_CH0_1 CTLL: DINC Mask            */
#define GPDMA0_CH_CTLL_SINC_Pos            9                                                       /*!< GPDMA0_CH0_1 CTLL: SINC Position        */
#define GPDMA0_CH_CTLL_SINC_Msk            (0x03UL << GPDMA0_CH_CTLL_SINC_Pos)                  /*!< GPDMA0_CH0_1 CTLL: SINC Mask            */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Pos      11                                                      /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE Position  */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Msk      (0x07UL << GPDMA0_CH_CTLL_DEST_MSIZE_Pos)            /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE Mask      */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Pos       14                                                      /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE Position   */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Msk       (0x07UL << GPDMA0_CH_CTLL_SRC_MSIZE_Pos)             /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE Mask       */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Pos   17                                                      /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN Position */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Msk   (0x01UL << GPDMA0_CH_CTLL_SRC_GATHER_EN_Pos)         /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN Mask   */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Pos  18                                                      /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN Position */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Msk  (0x01UL << GPDMA0_CH_CTLL_DST_SCATTER_EN_Pos)        /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN Mask  */
#define GPDMA0_CH_CTLL_TT_FC_Pos           20                                                      /*!< GPDMA0_CH0_1 CTLL: TT_FC Position       */
#define GPDMA0_CH_CTLL_TT_FC_Msk           (0x07UL << GPDMA0_CH_CTLL_TT_FC_Pos)                 /*!< GPDMA0_CH0_1 CTLL: TT_FC Mask           */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Pos      27                                                      /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN Position  */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Msk      (0x01UL << GPDMA0_CH_CTLL_LLP_DST_EN_Pos)            /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN Mask      */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Pos      28                                                      /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN Position  */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Msk      (0x01UL << GPDMA0_CH_CTLL_LLP_SRC_EN_Pos)            /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN Mask      */

/* ------------------------------  GPDMA0_CH_CTLH  ----------------------------- */
#define GPDMA0_CH_CTLH_BLOCK_TS_Pos        0                                                       /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS Position    */
#define GPDMA0_CH_CTLH_BLOCK_TS_Msk        (0x00000fffUL << GPDMA0_CH_CTLH_BLOCK_TS_Pos)        /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS Mask        */
#define GPDMA0_CH_CTLH_DONE_Pos            12                                                      /*!< GPDMA0_CH0_1 CTLH: DONE Position        */
#define GPDMA0_CH_CTLH_DONE_Msk            (0x01UL << GPDMA0_CH_CTLH_DONE_Pos)                  /*!< GPDMA0_CH0_1 CTLH: DONE Mask            */

/* -----------------------------  GPDMA0_CH_SSTAT  ----------------------------- */
#define GPDMA0_CH_SSTAT_SSTAT_Pos          0                                                       /*!< GPDMA0_CH0_1 SSTAT: SSTAT Position      */
#define GPDMA0_CH_SSTAT_SSTAT_Msk          (0xffffffffUL << GPDMA0_CH_SSTAT_SSTAT_Pos)          /*!< GPDMA0_CH0_1 SSTAT: SSTAT Mask          */

/* -----------------------------  GPDMA0_CH_DSTAT  ----------------------------- */
#define GPDMA0_CH_DSTAT_DSTAT_Pos          0                                                       /*!< GPDMA0_CH0_1 DSTAT: DSTAT Position      */
#define GPDMA0_CH_DSTAT_DSTAT_Msk          (0xffffffffUL << GPDMA0_CH_DSTAT_DSTAT_Pos)          /*!< GPDMA0_CH0_1 DSTAT: DSTAT Mask          */

/* ----------------------------  GPDMA0_CH_SSTATAR  ---------------------------- */
#define GPDMA0_CH_SSTATAR_SSTATAR_Pos      0                                                       /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR Position  */
#define GPDMA0_CH_SSTATAR_SSTATAR_Msk      (0xffffffffUL << GPDMA0_CH_SSTATAR_SSTATAR_Pos)      /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR Mask      */

/* ----------------------------  GPDMA0_CH_DSTATAR  ---------------------------- */
#define GPDMA0_CH_DSTATAR_DSTATAR_Pos      0                                                       /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR Position  */
#define GPDMA0_CH_DSTATAR_DSTATAR_Msk      (0xffffffffUL << GPDMA0_CH_DSTATAR_DSTATAR_Pos)      /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR Mask      */

/* ------------------------------  GPDMA0_CH_CFGL  ----------------------------- */
#define GPDMA0_CH_CFGL_CH_PRIOR_Pos        5                                                       /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR Position    */
#define GPDMA0_CH_CFGL_CH_PRIOR_Msk        (0x07UL << GPDMA0_CH_CFGL_CH_PRIOR_Pos)              /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR Mask        */
#define GPDMA0_CH_CFGL_CH_SUSP_Pos         8                                                       /*!< GPDMA0_CH0_1 CFGL: CH_SUSP Position     */
#define GPDMA0_CH_CFGL_CH_SUSP_Msk         (0x01UL << GPDMA0_CH_CFGL_CH_SUSP_Pos)               /*!< GPDMA0_CH0_1 CFGL: CH_SUSP Mask         */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Pos      9                                                       /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY Position  */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Msk      (0x01UL << GPDMA0_CH_CFGL_FIFO_EMPTY_Pos)            /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY Mask      */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Pos      10                                                      /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST Position  */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Msk      (0x01UL << GPDMA0_CH_CFGL_HS_SEL_DST_Pos)            /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST Mask      */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Pos      11                                                      /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC Position  */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Msk      (0x01UL << GPDMA0_CH_CFGL_HS_SEL_SRC_Pos)            /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC Mask      */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Pos       12                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L Position   */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Msk       (0x03UL << GPDMA0_CH_CFGL_LOCK_CH_L_Pos)             /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L Mask       */
#define GPDMA0_CH_CFGL_LOCK_B_L_Pos        14                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L Position    */
#define GPDMA0_CH_CFGL_LOCK_B_L_Msk        (0x03UL << GPDMA0_CH_CFGL_LOCK_B_L_Pos)              /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L Mask        */
#define GPDMA0_CH_CFGL_LOCK_CH_Pos         16                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_CH Position     */
#define GPDMA0_CH_CFGL_LOCK_CH_Msk         (0x01UL << GPDMA0_CH_CFGL_LOCK_CH_Pos)               /*!< GPDMA0_CH0_1 CFGL: LOCK_CH Mask         */
#define GPDMA0_CH_CFGL_LOCK_B_Pos          17                                                      /*!< GPDMA0_CH0_1 CFGL: LOCK_B Position      */
#define GPDMA0_CH_CFGL_LOCK_B_Msk          (0x01UL << GPDMA0_CH_CFGL_LOCK_B_Pos)                /*!< GPDMA0_CH0_1 CFGL: LOCK_B Mask          */
#define GPDMA0_CH_CFGL_DST_HS_POL_Pos      18                                                      /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL Position  */
#define GPDMA0_CH_CFGL_DST_HS_POL_Msk      (0x01UL << GPDMA0_CH_CFGL_DST_HS_POL_Pos)            /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL Mask      */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Pos      19                                                      /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL Position  */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Msk      (0x01UL << GPDMA0_CH_CFGL_SRC_HS_POL_Pos)            /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL Mask      */
#define GPDMA0_CH_CFGL_MAX_ABRST_Pos       20                                                      /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST Position   */
#define GPDMA0_CH_CFGL_MAX_ABRST_Msk       (0x000003ffUL << GPDMA0_CH_CFGL_MAX_ABRST_Pos)       /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST Mask       */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Pos      30                                                      /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC Position  */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Msk      (0x01UL << GPDMA0_CH_CFGL_RELOAD_SRC_Pos)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC Mask      */
#define GPDMA0_CH_CFGL_RELOAD_DST_Pos      31                                                      /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST Position  */
#define GPDMA0_CH_CFGL_RELOAD_DST_Msk      (0x01UL << GPDMA0_CH_CFGL_RELOAD_DST_Pos)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST Mask      */

/* ------------------------------  GPDMA0_CH_CFGH  ----------------------------- */
#define GPDMA0_CH_CFGH_FCMODE_Pos          0                                                       /*!< GPDMA0_CH0_1 CFGH: FCMODE Position      */
#define GPDMA0_CH_CFGH_FCMODE_Msk          (0x01UL << GPDMA0_CH_CFGH_FCMODE_Pos)                /*!< GPDMA0_CH0_1 CFGH: FCMODE Mask          */
#define GPDMA0_CH_CFGH_FIFO_MODE_Pos       1                                                       /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE Position   */
#define GPDMA0_CH_CFGH_FIFO_MODE_Msk       (0x01UL << GPDMA0_CH_CFGH_FIFO_MODE_Pos)             /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE Mask       */
#define GPDMA0_CH_CFGH_PROTCTL_Pos         2                                                       /*!< GPDMA0_CH0_1 CFGH: PROTCTL Position     */
#define GPDMA0_CH_CFGH_PROTCTL_Msk         (0x07UL << GPDMA0_CH_CFGH_PROTCTL_Pos)               /*!< GPDMA0_CH0_1 CFGH: PROTCTL Mask         */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Pos       5                                                       /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN Position   */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Msk       (0x01UL << GPDMA0_CH_CFGH_DS_UPD_EN_Pos)             /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN Mask       */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Pos       6                                                       /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN Position   */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Msk       (0x01UL << GPDMA0_CH_CFGH_SS_UPD_EN_Pos)             /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN Mask       */
#define GPDMA0_CH_CFGH_SRC_PER_Pos         7                                                       /*!< GPDMA0_CH0_1 CFGH: SRC_PER Position     */
#define GPDMA0_CH_CFGH_SRC_PER_Msk         (0x0fUL << GPDMA0_CH_CFGH_SRC_PER_Pos)               /*!< GPDMA0_CH0_1 CFGH: SRC_PER Mask         */
#define GPDMA0_CH_CFGH_DEST_PER_Pos        11                                                      /*!< GPDMA0_CH0_1 CFGH: DEST_PER Position    */
#define GPDMA0_CH_CFGH_DEST_PER_Msk        (0x0fUL << GPDMA0_CH_CFGH_DEST_PER_Pos)              /*!< GPDMA0_CH0_1 CFGH: DEST_PER Mask        */

/* ------------------------------  GPDMA0_CH_SGR  ------------------------------ */
#define GPDMA0_CH_SGR_SGI_Pos              0                                                       /*!< GPDMA0_CH0_1 SGR: SGI Position          */
#define GPDMA0_CH_SGR_SGI_Msk              (0x000fffffUL << GPDMA0_CH_SGR_SGI_Pos)              /*!< GPDMA0_CH0_1 SGR: SGI Mask              */
#define GPDMA0_CH_SGR_SGC_Pos              20                                                      /*!< GPDMA0_CH0_1 SGR: SGC Position          */
#define GPDMA0_CH_SGR_SGC_Msk              (0x00000fffUL << GPDMA0_CH_SGR_SGC_Pos)              /*!< GPDMA0_CH0_1 SGR: SGC Mask              */

/* ------------------------------  GPDMA0_CH_DSR  ------------------------------ */
#define GPDMA0_CH_DSR_DSI_Pos              0                                                       /*!< GPDMA0_CH0_1 DSR: DSI Position          */
#define GPDMA0_CH_DSR_DSI_Msk              (0x000fffffUL << GPDMA0_CH_DSR_DSI_Pos)              /*!< GPDMA0_CH0_1 DSR: DSI Mask              */
#define GPDMA0_CH_DSR_DSC_Pos              20                                                      /*!< GPDMA0_CH0_1 DSR: DSC Position          */
#define GPDMA0_CH_DSR_DSC_Msk              (0x00000fffUL << GPDMA0_CH_DSR_DSC_Pos)              /*!< GPDMA0_CH0_1 DSR: DSC Mask              */


/* ================================================================================ */
/* ================          struct 'FCE' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  FCE_CLC  ---------------------------------- */
#define FCE_CLC_DISR_Pos                      0                                                       /*!< FCE CLC: DISR Position                  */
#define FCE_CLC_DISR_Msk                      (0x01UL << FCE_CLC_DISR_Pos)                            /*!< FCE CLC: DISR Mask                      */
#define FCE_CLC_DISS_Pos                      1                                                       /*!< FCE CLC: DISS Position                  */
#define FCE_CLC_DISS_Msk                      (0x01UL << FCE_CLC_DISS_Pos)                            /*!< FCE CLC: DISS Mask                      */

/* -----------------------------------  FCE_ID  ----------------------------------- */
#define FCE_ID_MOD_REV_Pos                    0                                                       /*!< FCE ID: MOD_REV Position                */
#define FCE_ID_MOD_REV_Msk                    (0x000000ffUL << FCE_ID_MOD_REV_Pos)                    /*!< FCE ID: MOD_REV Mask                    */
#define FCE_ID_MOD_TYPE_Pos                   8                                                       /*!< FCE ID: MOD_TYPE Position               */
#define FCE_ID_MOD_TYPE_Msk                   (0x000000ffUL << FCE_ID_MOD_TYPE_Pos)                   /*!< FCE ID: MOD_TYPE Mask                   */
#define FCE_ID_MOD_NUMBER_Pos                 16                                                      /*!< FCE ID: MOD_NUMBER Position             */
#define FCE_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << FCE_ID_MOD_NUMBER_Pos)                 /*!< FCE ID: MOD_NUMBER Mask                 */


/* ================================================================================ */
/* ================         Group 'FCE_KE' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FCE_KE_IR  --------------------------------- */
#define FCE_KE_IR_IR_Pos                      0                                                       /*!< FCE_KE IR: IR Position                  */
#define FCE_KE_IR_IR_Msk                      (0xffffffffUL << FCE_KE_IR_IR_Pos)                      /*!< FCE_KE IR: IR Mask                      */

/* ---------------------------------  FCE_KE_RES  --------------------------------- */
#define FCE_KE_RES_RES_Pos                    0                                                       /*!< FCE_KE RES: RES Position                */
#define FCE_KE_RES_RES_Msk                    (0xffffffffUL << FCE_KE_RES_RES_Pos)                    /*!< FCE_KE RES: RES Mask                    */

/* ---------------------------------  FCE_KE_CFG  --------------------------------- */
#define FCE_KE_CFG_CMI_Pos                    0                                                       /*!< FCE_KE CFG: CMI Position                */
#define FCE_KE_CFG_CMI_Msk                    (0x01UL << FCE_KE_CFG_CMI_Pos)                          /*!< FCE_KE CFG: CMI Mask                    */
#define FCE_KE_CFG_CEI_Pos                    1                                                       /*!< FCE_KE CFG: CEI Position                */
#define FCE_KE_CFG_CEI_Msk                    (0x01UL << FCE_KE_CFG_CEI_Pos)                          /*!< FCE_KE CFG: CEI Mask                    */
#define FCE_KE_CFG_LEI_Pos                    2                                                       /*!< FCE_KE CFG: LEI Position                */
#define FCE_KE_CFG_LEI_Msk                    (0x01UL << FCE_KE_CFG_LEI_Pos)                          /*!< FCE_KE CFG: LEI Mask                    */
#define FCE_KE_CFG_BEI_Pos                    3                                                       /*!< FCE_KE CFG: BEI Position                */
#define FCE_KE_CFG_BEI_Msk                    (0x01UL << FCE_KE_CFG_BEI_Pos)                          /*!< FCE_KE CFG: BEI Mask                    */
#define FCE_KE_CFG_CCE_Pos                    4                                                       /*!< FCE_KE CFG: CCE Position                */
#define FCE_KE_CFG_CCE_Msk                    (0x01UL << FCE_KE_CFG_CCE_Pos)                          /*!< FCE_KE CFG: CCE Mask                    */
#define FCE_KE_CFG_ALR_Pos                    5                                                       /*!< FCE_KE CFG: ALR Position                */
#define FCE_KE_CFG_ALR_Msk                    (0x01UL << FCE_KE_CFG_ALR_Pos)                          /*!< FCE_KE CFG: ALR Mask                    */
#define FCE_KE_CFG_REFIN_Pos                  8                                                       /*!< FCE_KE CFG: REFIN Position              */
#define FCE_KE_CFG_REFIN_Msk                  (0x01UL << FCE_KE_CFG_REFIN_Pos)                        /*!< FCE_KE CFG: REFIN Mask                  */
#define FCE_KE_CFG_REFOUT_Pos                 9                                                       /*!< FCE_KE CFG: REFOUT Position             */
#define FCE_KE_CFG_REFOUT_Msk                 (0x01UL << FCE_KE_CFG_REFOUT_Pos)                       /*!< FCE_KE CFG: REFOUT Mask                 */
#define FCE_KE_CFG_XSEL_Pos                   10                                                      /*!< FCE_KE CFG: XSEL Position               */
#define FCE_KE_CFG_XSEL_Msk                   (0x01UL << FCE_KE_CFG_XSEL_Pos)                         /*!< FCE_KE CFG: XSEL Mask                   */

/* ---------------------------------  FCE_KE_STS  --------------------------------- */
#define FCE_KE_STS_CMF_Pos                    0                                                       /*!< FCE_KE STS: CMF Position                */
#define FCE_KE_STS_CMF_Msk                    (0x01UL << FCE_KE_STS_CMF_Pos)                          /*!< FCE_KE STS: CMF Mask                    */
#define FCE_KE_STS_CEF_Pos                    1                                                       /*!< FCE_KE STS: CEF Position                */
#define FCE_KE_STS_CEF_Msk                    (0x01UL << FCE_KE_STS_CEF_Pos)                          /*!< FCE_KE STS: CEF Mask                    */
#define FCE_KE_STS_LEF_Pos                    2                                                       /*!< FCE_KE STS: LEF Position                */
#define FCE_KE_STS_LEF_Msk                    (0x01UL << FCE_KE_STS_LEF_Pos)                          /*!< FCE_KE STS: LEF Mask                    */
#define FCE_KE_STS_BEF_Pos                    3                                                       /*!< FCE_KE STS: BEF Position                */
#define FCE_KE_STS_BEF_Msk                    (0x01UL << FCE_KE_STS_BEF_Pos)                          /*!< FCE_KE STS: BEF Mask                    */

/* --------------------------------  FCE_KE_LENGTH  ------------------------------- */
#define FCE_KE_LENGTH_LENGTH_Pos              0                                                       /*!< FCE_KE LENGTH: LENGTH Position          */
#define FCE_KE_LENGTH_LENGTH_Msk              (0x0000ffffUL << FCE_KE_LENGTH_LENGTH_Pos)              /*!< FCE_KE LENGTH: LENGTH Mask              */

/* --------------------------------  FCE_KE_CHECK  -------------------------------- */
#define FCE_KE_CHECK_CHECK_Pos                0                                                       /*!< FCE_KE CHECK: CHECK Position            */
#define FCE_KE_CHECK_CHECK_Msk                (0xffffffffUL << FCE_KE_CHECK_CHECK_Pos)                /*!< FCE_KE CHECK: CHECK Mask                */

/* ---------------------------------  FCE_KE_CRC  --------------------------------- */
#define FCE_KE_CRC_CRC_Pos                    0                                                       /*!< FCE_KE CRC: CRC Position                */
#define FCE_KE_CRC_CRC_Msk                    (0xffffffffUL << FCE_KE_CRC_CRC_Pos)                    /*!< FCE_KE CRC: CRC Mask                    */

/* ---------------------------------  FCE_KE_CTR  --------------------------------- */
#define FCE_KE_CTR_FCM_Pos                    0                                                       /*!< FCE_KE CTR: FCM Position                */
#define FCE_KE_CTR_FCM_Msk                    (0x01UL << FCE_KE_CTR_FCM_Pos)                          /*!< FCE_KE CTR: FCM Mask                    */
#define FCE_KE_CTR_FRM_CFG_Pos                1                                                       /*!< FCE_KE CTR: FRM_CFG Position            */
#define FCE_KE_CTR_FRM_CFG_Msk                (0x01UL << FCE_KE_CTR_FRM_CFG_Pos)                      /*!< FCE_KE CTR: FRM_CFG Mask                */
#define FCE_KE_CTR_FRM_CHECK_Pos              2                                                       /*!< FCE_KE CTR: FRM_CHECK Position          */
#define FCE_KE_CTR_FRM_CHECK_Msk              (0x01UL << FCE_KE_CTR_FRM_CHECK_Pos)                    /*!< FCE_KE CTR: FRM_CHECK Mask              */


/* ================================================================================ */
/* ================           Group 'PBA' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PBA_STS  ---------------------------------- */
#define PBA_STS_WERR_Pos                      0                                                       /*!< PBA STS: WERR Position                  */
#define PBA_STS_WERR_Msk                      (0x01UL << PBA_STS_WERR_Pos)                            /*!< PBA STS: WERR Mask                      */

/* ----------------------------------  PBA_WADDR  --------------------------------- */
#define PBA_WADDR_WADDR_Pos                   0                                                       /*!< PBA WADDR: WADDR Position               */
#define PBA_WADDR_WADDR_Msk                   (0xffffffffUL << PBA_WADDR_WADDR_Pos)                   /*!< PBA WADDR: WADDR Mask                   */


/* ================================================================================ */
/* ================          Group 'FLASH' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FLASH_ID  ---------------------------------- */
#define FLASH_ID_MOD_REV_Pos                  0                                                       /*!< FLASH ID: MOD_REV Position              */
#define FLASH_ID_MOD_REV_Msk                  (0x000000ffUL << FLASH_ID_MOD_REV_Pos)                  /*!< FLASH ID: MOD_REV Mask                  */
#define FLASH_ID_MOD_TYPE_Pos                 8                                                       /*!< FLASH ID: MOD_TYPE Position             */
#define FLASH_ID_MOD_TYPE_Msk                 (0x000000ffUL << FLASH_ID_MOD_TYPE_Pos)                 /*!< FLASH ID: MOD_TYPE Mask                 */
#define FLASH_ID_MOD_NUMBER_Pos               16                                                      /*!< FLASH ID: MOD_NUMBER Position           */
#define FLASH_ID_MOD_NUMBER_Msk               (0x0000ffffUL << FLASH_ID_MOD_NUMBER_Pos)               /*!< FLASH ID: MOD_NUMBER Mask               */

/* ----------------------------------  FLASH_FSR  --------------------------------- */
#define FLASH_FSR_PBUSY_Pos                   0                                                       /*!< FLASH FSR: PBUSY Position               */
#define FLASH_FSR_PBUSY_Msk                   (0x01UL << FLASH_FSR_PBUSY_Pos)                         /*!< FLASH FSR: PBUSY Mask                   */
#define FLASH_FSR_FABUSY_Pos                  1                                                       /*!< FLASH FSR: FABUSY Position              */
#define FLASH_FSR_FABUSY_Msk                  (0x01UL << FLASH_FSR_FABUSY_Pos)                        /*!< FLASH FSR: FABUSY Mask                  */
#define FLASH_FSR_PROG_Pos                    4                                                       /*!< FLASH FSR: PROG Position                */
#define FLASH_FSR_PROG_Msk                    (0x01UL << FLASH_FSR_PROG_Pos)                          /*!< FLASH FSR: PROG Mask                    */
#define FLASH_FSR_ERASE_Pos                   5                                                       /*!< FLASH FSR: ERASE Position               */
#define FLASH_FSR_ERASE_Msk                   (0x01UL << FLASH_FSR_ERASE_Pos)                         /*!< FLASH FSR: ERASE Mask                   */
#define FLASH_FSR_PFPAGE_Pos                  6                                                       /*!< FLASH FSR: PFPAGE Position              */
#define FLASH_FSR_PFPAGE_Msk                  (0x01UL << FLASH_FSR_PFPAGE_Pos)                        /*!< FLASH FSR: PFPAGE Mask                  */
#define FLASH_FSR_PFOPER_Pos                  8                                                       /*!< FLASH FSR: PFOPER Position              */
#define FLASH_FSR_PFOPER_Msk                  (0x01UL << FLASH_FSR_PFOPER_Pos)                        /*!< FLASH FSR: PFOPER Mask                  */
#define FLASH_FSR_SQER_Pos                    10                                                      /*!< FLASH FSR: SQER Position                */
#define FLASH_FSR_SQER_Msk                    (0x01UL << FLASH_FSR_SQER_Pos)                          /*!< FLASH FSR: SQER Mask                    */
#define FLASH_FSR_PROER_Pos                   11                                                      /*!< FLASH FSR: PROER Position               */
#define FLASH_FSR_PROER_Msk                   (0x01UL << FLASH_FSR_PROER_Pos)                         /*!< FLASH FSR: PROER Mask                   */
#define FLASH_FSR_PFSBER_Pos                  12                                                      /*!< FLASH FSR: PFSBER Position              */
#define FLASH_FSR_PFSBER_Msk                  (0x01UL << FLASH_FSR_PFSBER_Pos)                        /*!< FLASH FSR: PFSBER Mask                  */
#define FLASH_FSR_PFDBER_Pos                  14                                                      /*!< FLASH FSR: PFDBER Position              */
#define FLASH_FSR_PFDBER_Msk                  (0x01UL << FLASH_FSR_PFDBER_Pos)                        /*!< FLASH FSR: PFDBER Mask                  */
#define FLASH_FSR_PROIN_Pos                   16                                                      /*!< FLASH FSR: PROIN Position               */
#define FLASH_FSR_PROIN_Msk                   (0x01UL << FLASH_FSR_PROIN_Pos)                         /*!< FLASH FSR: PROIN Mask                   */
#define FLASH_FSR_RPROIN_Pos                  18                                                      /*!< FLASH FSR: RPROIN Position              */
#define FLASH_FSR_RPROIN_Msk                  (0x01UL << FLASH_FSR_RPROIN_Pos)                        /*!< FLASH FSR: RPROIN Mask                  */
#define FLASH_FSR_RPRODIS_Pos                 19                                                      /*!< FLASH FSR: RPRODIS Position             */
#define FLASH_FSR_RPRODIS_Msk                 (0x01UL << FLASH_FSR_RPRODIS_Pos)                       /*!< FLASH FSR: RPRODIS Mask                 */
#define FLASH_FSR_WPROIN0_Pos                 21                                                      /*!< FLASH FSR: WPROIN0 Position             */
#define FLASH_FSR_WPROIN0_Msk                 (0x01UL << FLASH_FSR_WPROIN0_Pos)                       /*!< FLASH FSR: WPROIN0 Mask                 */
#define FLASH_FSR_WPROIN1_Pos                 22                                                      /*!< FLASH FSR: WPROIN1 Position             */
#define FLASH_FSR_WPROIN1_Msk                 (0x01UL << FLASH_FSR_WPROIN1_Pos)                       /*!< FLASH FSR: WPROIN1 Mask                 */
#define FLASH_FSR_WPROIN2_Pos                 23                                                      /*!< FLASH FSR: WPROIN2 Position             */
#define FLASH_FSR_WPROIN2_Msk                 (0x01UL << FLASH_FSR_WPROIN2_Pos)                       /*!< FLASH FSR: WPROIN2 Mask                 */
#define FLASH_FSR_WPRODIS0_Pos                25                                                      /*!< FLASH FSR: WPRODIS0 Position            */
#define FLASH_FSR_WPRODIS0_Msk                (0x01UL << FLASH_FSR_WPRODIS0_Pos)                      /*!< FLASH FSR: WPRODIS0 Mask                */
#define FLASH_FSR_WPRODIS1_Pos                26                                                      /*!< FLASH FSR: WPRODIS1 Position            */
#define FLASH_FSR_WPRODIS1_Msk                (0x01UL << FLASH_FSR_WPRODIS1_Pos)                      /*!< FLASH FSR: WPRODIS1 Mask                */
#define FLASH_FSR_SLM_Pos                     28                                                      /*!< FLASH FSR: SLM Position                 */
#define FLASH_FSR_SLM_Msk                     (0x01UL << FLASH_FSR_SLM_Pos)                           /*!< FLASH FSR: SLM Mask                     */
#define FLASH_FSR_X_Pos                       30                                                      /*!< FLASH FSR: X Position                   */
#define FLASH_FSR_X_Msk                       (0x01UL << FLASH_FSR_X_Pos)                             /*!< FLASH FSR: X Mask                       */
#define FLASH_FSR_VER_Pos                     31                                                      /*!< FLASH FSR: VER Position                 */
#define FLASH_FSR_VER_Msk                     (0x01UL << FLASH_FSR_VER_Pos)                           /*!< FLASH FSR: VER Mask                     */

/* ---------------------------------  FLASH_FCON  --------------------------------- */
#define FLASH_FCON_WSPFLASH_Pos               0                                                       /*!< FLASH FCON: WSPFLASH Position           */
#define FLASH_FCON_WSPFLASH_Msk               (0x0fUL << FLASH_FCON_WSPFLASH_Pos)                     /*!< FLASH FCON: WSPFLASH Mask               */
#define FLASH_FCON_WSECPF_Pos                 4                                                       /*!< FLASH FCON: WSECPF Position             */
#define FLASH_FCON_WSECPF_Msk                 (0x01UL << FLASH_FCON_WSECPF_Pos)                       /*!< FLASH FCON: WSECPF Mask                 */
#define FLASH_FCON_IDLE_Pos                   13                                                      /*!< FLASH FCON: IDLE Position               */
#define FLASH_FCON_IDLE_Msk                   (0x01UL << FLASH_FCON_IDLE_Pos)                         /*!< FLASH FCON: IDLE Mask                   */
#define FLASH_FCON_ESLDIS_Pos                 14                                                      /*!< FLASH FCON: ESLDIS Position             */
#define FLASH_FCON_ESLDIS_Msk                 (0x01UL << FLASH_FCON_ESLDIS_Pos)                       /*!< FLASH FCON: ESLDIS Mask                 */
#define FLASH_FCON_SLEEP_Pos                  15                                                      /*!< FLASH FCON: SLEEP Position              */
#define FLASH_FCON_SLEEP_Msk                  (0x01UL << FLASH_FCON_SLEEP_Pos)                        /*!< FLASH FCON: SLEEP Mask                  */
#define FLASH_FCON_RPA_Pos                    16                                                      /*!< FLASH FCON: RPA Position                */
#define FLASH_FCON_RPA_Msk                    (0x01UL << FLASH_FCON_RPA_Pos)                          /*!< FLASH FCON: RPA Mask                    */
#define FLASH_FCON_DCF_Pos                    17                                                      /*!< FLASH FCON: DCF Position                */
#define FLASH_FCON_DCF_Msk                    (0x01UL << FLASH_FCON_DCF_Pos)                          /*!< FLASH FCON: DCF Mask                    */
#define FLASH_FCON_DDF_Pos                    18                                                      /*!< FLASH FCON: DDF Position                */
#define FLASH_FCON_DDF_Msk                    (0x01UL << FLASH_FCON_DDF_Pos)                          /*!< FLASH FCON: DDF Mask                    */
#define FLASH_FCON_VOPERM_Pos                 24                                                      /*!< FLASH FCON: VOPERM Position             */
#define FLASH_FCON_VOPERM_Msk                 (0x01UL << FLASH_FCON_VOPERM_Pos)                       /*!< FLASH FCON: VOPERM Mask                 */
#define FLASH_FCON_SQERM_Pos                  25                                                      /*!< FLASH FCON: SQERM Position              */
#define FLASH_FCON_SQERM_Msk                  (0x01UL << FLASH_FCON_SQERM_Pos)                        /*!< FLASH FCON: SQERM Mask                  */
#define FLASH_FCON_PROERM_Pos                 26                                                      /*!< FLASH FCON: PROERM Position             */
#define FLASH_FCON_PROERM_Msk                 (0x01UL << FLASH_FCON_PROERM_Pos)                       /*!< FLASH FCON: PROERM Mask                 */
#define FLASH_FCON_PFSBERM_Pos                27                                                      /*!< FLASH FCON: PFSBERM Position            */
#define FLASH_FCON_PFSBERM_Msk                (0x01UL << FLASH_FCON_PFSBERM_Pos)                      /*!< FLASH FCON: PFSBERM Mask                */
#define FLASH_FCON_PFDBERM_Pos                29                                                      /*!< FLASH FCON: PFDBERM Position            */
#define FLASH_FCON_PFDBERM_Msk                (0x01UL << FLASH_FCON_PFDBERM_Pos)                      /*!< FLASH FCON: PFDBERM Mask                */
#define FLASH_FCON_EOBM_Pos                   31                                                      /*!< FLASH FCON: EOBM Position               */
#define FLASH_FCON_EOBM_Msk                   (0x01UL << FLASH_FCON_EOBM_Pos)                         /*!< FLASH FCON: EOBM Mask                   */

/* ---------------------------------  FLASH_MARP  --------------------------------- */
#define FLASH_MARP_MARGIN_Pos                 0                                                       /*!< FLASH MARP: MARGIN Position             */
#define FLASH_MARP_MARGIN_Msk                 (0x0fUL << FLASH_MARP_MARGIN_Pos)                       /*!< FLASH MARP: MARGIN Mask                 */
#define FLASH_MARP_TRAPDIS_Pos                15                                                      /*!< FLASH MARP: TRAPDIS Position            */
#define FLASH_MARP_TRAPDIS_Msk                (0x01UL << FLASH_MARP_TRAPDIS_Pos)                      /*!< FLASH MARP: TRAPDIS Mask                */

/* --------------------------------  FLASH_PROCON0  ------------------------------- */
#define FLASH_PROCON0_S0L_Pos                 0                                                       /*!< FLASH PROCON0: S0L Position             */
#define FLASH_PROCON0_S0L_Msk                 (0x01UL << FLASH_PROCON0_S0L_Pos)                       /*!< FLASH PROCON0: S0L Mask                 */
#define FLASH_PROCON0_S1L_Pos                 1                                                       /*!< FLASH PROCON0: S1L Position             */
#define FLASH_PROCON0_S1L_Msk                 (0x01UL << FLASH_PROCON0_S1L_Pos)                       /*!< FLASH PROCON0: S1L Mask                 */
#define FLASH_PROCON0_S2L_Pos                 2                                                       /*!< FLASH PROCON0: S2L Position             */
#define FLASH_PROCON0_S2L_Msk                 (0x01UL << FLASH_PROCON0_S2L_Pos)                       /*!< FLASH PROCON0: S2L Mask                 */
#define FLASH_PROCON0_S3L_Pos                 3                                                       /*!< FLASH PROCON0: S3L Position             */
#define FLASH_PROCON0_S3L_Msk                 (0x01UL << FLASH_PROCON0_S3L_Pos)                       /*!< FLASH PROCON0: S3L Mask                 */
#define FLASH_PROCON0_S4L_Pos                 4                                                       /*!< FLASH PROCON0: S4L Position             */
#define FLASH_PROCON0_S4L_Msk                 (0x01UL << FLASH_PROCON0_S4L_Pos)                       /*!< FLASH PROCON0: S4L Mask                 */
#define FLASH_PROCON0_S5L_Pos                 5                                                       /*!< FLASH PROCON0: S5L Position             */
#define FLASH_PROCON0_S5L_Msk                 (0x01UL << FLASH_PROCON0_S5L_Pos)                       /*!< FLASH PROCON0: S5L Mask                 */
#define FLASH_PROCON0_S6L_Pos                 6                                                       /*!< FLASH PROCON0: S6L Position             */
#define FLASH_PROCON0_S6L_Msk                 (0x01UL << FLASH_PROCON0_S6L_Pos)                       /*!< FLASH PROCON0: S6L Mask                 */
#define FLASH_PROCON0_S7L_Pos                 7                                                       /*!< FLASH PROCON0: S7L Position             */
#define FLASH_PROCON0_S7L_Msk                 (0x01UL << FLASH_PROCON0_S7L_Pos)                       /*!< FLASH PROCON0: S7L Mask                 */
#define FLASH_PROCON0_S8L_Pos                 8                                                       /*!< FLASH PROCON0: S8L Position             */
#define FLASH_PROCON0_S8L_Msk                 (0x01UL << FLASH_PROCON0_S8L_Pos)                       /*!< FLASH PROCON0: S8L Mask                 */
#define FLASH_PROCON0_S9L_Pos                 9                                                       /*!< FLASH PROCON0: S9L Position             */
#define FLASH_PROCON0_S9L_Msk                 (0x01UL << FLASH_PROCON0_S9L_Pos)                       /*!< FLASH PROCON0: S9L Mask                 */
#define FLASH_PROCON0_RPRO_Pos                15                                                      /*!< FLASH PROCON0: RPRO Position            */
#define FLASH_PROCON0_RPRO_Msk                (0x01UL << FLASH_PROCON0_RPRO_Pos)                      /*!< FLASH PROCON0: RPRO Mask                */

/* --------------------------------  FLASH_PROCON1  ------------------------------- */
#define FLASH_PROCON1_S0L_Pos                 0                                                       /*!< FLASH PROCON1: S0L Position             */
#define FLASH_PROCON1_S0L_Msk                 (0x01UL << FLASH_PROCON1_S0L_Pos)                       /*!< FLASH PROCON1: S0L Mask                 */
#define FLASH_PROCON1_S1L_Pos                 1                                                       /*!< FLASH PROCON1: S1L Position             */
#define FLASH_PROCON1_S1L_Msk                 (0x01UL << FLASH_PROCON1_S1L_Pos)                       /*!< FLASH PROCON1: S1L Mask                 */
#define FLASH_PROCON1_S2L_Pos                 2                                                       /*!< FLASH PROCON1: S2L Position             */
#define FLASH_PROCON1_S2L_Msk                 (0x01UL << FLASH_PROCON1_S2L_Pos)                       /*!< FLASH PROCON1: S2L Mask                 */
#define FLASH_PROCON1_S3L_Pos                 3                                                       /*!< FLASH PROCON1: S3L Position             */
#define FLASH_PROCON1_S3L_Msk                 (0x01UL << FLASH_PROCON1_S3L_Pos)                       /*!< FLASH PROCON1: S3L Mask                 */
#define FLASH_PROCON1_S4L_Pos                 4                                                       /*!< FLASH PROCON1: S4L Position             */
#define FLASH_PROCON1_S4L_Msk                 (0x01UL << FLASH_PROCON1_S4L_Pos)                       /*!< FLASH PROCON1: S4L Mask                 */
#define FLASH_PROCON1_S5L_Pos                 5                                                       /*!< FLASH PROCON1: S5L Position             */
#define FLASH_PROCON1_S5L_Msk                 (0x01UL << FLASH_PROCON1_S5L_Pos)                       /*!< FLASH PROCON1: S5L Mask                 */
#define FLASH_PROCON1_S6L_Pos                 6                                                       /*!< FLASH PROCON1: S6L Position             */
#define FLASH_PROCON1_S6L_Msk                 (0x01UL << FLASH_PROCON1_S6L_Pos)                       /*!< FLASH PROCON1: S6L Mask                 */
#define FLASH_PROCON1_S7L_Pos                 7                                                       /*!< FLASH PROCON1: S7L Position             */
#define FLASH_PROCON1_S7L_Msk                 (0x01UL << FLASH_PROCON1_S7L_Pos)                       /*!< FLASH PROCON1: S7L Mask                 */
#define FLASH_PROCON1_S8L_Pos                 8                                                       /*!< FLASH PROCON1: S8L Position             */
#define FLASH_PROCON1_S8L_Msk                 (0x01UL << FLASH_PROCON1_S8L_Pos)                       /*!< FLASH PROCON1: S8L Mask                 */
#define FLASH_PROCON1_S9L_Pos                 9                                                       /*!< FLASH PROCON1: S9L Position             */
#define FLASH_PROCON1_S9L_Msk                 (0x01UL << FLASH_PROCON1_S9L_Pos)                       /*!< FLASH PROCON1: S9L Mask                 */

/* --------------------------------  FLASH_PROCON2  ------------------------------- */
#define FLASH_PROCON2_S0ROM_Pos               0                                                       /*!< FLASH PROCON2: S0ROM Position           */
#define FLASH_PROCON2_S0ROM_Msk               (0x01UL << FLASH_PROCON2_S0ROM_Pos)                     /*!< FLASH PROCON2: S0ROM Mask               */
#define FLASH_PROCON2_S1ROM_Pos               1                                                       /*!< FLASH PROCON2: S1ROM Position           */
#define FLASH_PROCON2_S1ROM_Msk               (0x01UL << FLASH_PROCON2_S1ROM_Pos)                     /*!< FLASH PROCON2: S1ROM Mask               */
#define FLASH_PROCON2_S2ROM_Pos               2                                                       /*!< FLASH PROCON2: S2ROM Position           */
#define FLASH_PROCON2_S2ROM_Msk               (0x01UL << FLASH_PROCON2_S2ROM_Pos)                     /*!< FLASH PROCON2: S2ROM Mask               */
#define FLASH_PROCON2_S3ROM_Pos               3                                                       /*!< FLASH PROCON2: S3ROM Position           */
#define FLASH_PROCON2_S3ROM_Msk               (0x01UL << FLASH_PROCON2_S3ROM_Pos)                     /*!< FLASH PROCON2: S3ROM Mask               */
#define FLASH_PROCON2_S4ROM_Pos               4                                                       /*!< FLASH PROCON2: S4ROM Position           */
#define FLASH_PROCON2_S4ROM_Msk               (0x01UL << FLASH_PROCON2_S4ROM_Pos)                     /*!< FLASH PROCON2: S4ROM Mask               */
#define FLASH_PROCON2_S5ROM_Pos               5                                                       /*!< FLASH PROCON2: S5ROM Position           */
#define FLASH_PROCON2_S5ROM_Msk               (0x01UL << FLASH_PROCON2_S5ROM_Pos)                     /*!< FLASH PROCON2: S5ROM Mask               */
#define FLASH_PROCON2_S6ROM_Pos               6                                                       /*!< FLASH PROCON2: S6ROM Position           */
#define FLASH_PROCON2_S6ROM_Msk               (0x01UL << FLASH_PROCON2_S6ROM_Pos)                     /*!< FLASH PROCON2: S6ROM Mask               */
#define FLASH_PROCON2_S7ROM_Pos               7                                                       /*!< FLASH PROCON2: S7ROM Position           */
#define FLASH_PROCON2_S7ROM_Msk               (0x01UL << FLASH_PROCON2_S7ROM_Pos)                     /*!< FLASH PROCON2: S7ROM Mask               */
#define FLASH_PROCON2_S8ROM_Pos               8                                                       /*!< FLASH PROCON2: S8ROM Position           */
#define FLASH_PROCON2_S8ROM_Msk               (0x01UL << FLASH_PROCON2_S8ROM_Pos)                     /*!< FLASH PROCON2: S8ROM Mask               */
#define FLASH_PROCON2_S9ROM_Pos               9                                                       /*!< FLASH PROCON2: S9ROM Position           */
#define FLASH_PROCON2_S9ROM_Msk               (0x01UL << FLASH_PROCON2_S9ROM_Pos)                     /*!< FLASH PROCON2: S9ROM Mask               */


/* ================================================================================ */
/* ================          struct 'PREF' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  PREF_PCON  --------------------------------- */
#define PREF_PCON_IBYP_Pos                    0                                                       /*!< PREF PCON: IBYP Position                */
#define PREF_PCON_IBYP_Msk                    (0x01UL << PREF_PCON_IBYP_Pos)                          /*!< PREF PCON: IBYP Mask                    */
#define PREF_PCON_IINV_Pos                    1                                                       /*!< PREF PCON: IINV Position                */
#define PREF_PCON_IINV_Msk                    (0x01UL << PREF_PCON_IINV_Pos)                          /*!< PREF PCON: IINV Mask                    */


/* ================================================================================ */
/* ================           Group 'PMU' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PMU_ID  ----------------------------------- */
#define PMU_ID_MOD_REV_Pos                    0                                                       /*!< PMU ID: MOD_REV Position                */
#define PMU_ID_MOD_REV_Msk                    (0x000000ffUL << PMU_ID_MOD_REV_Pos)                    /*!< PMU ID: MOD_REV Mask                    */
#define PMU_ID_MOD_TYPE_Pos                   8                                                       /*!< PMU ID: MOD_TYPE Position               */
#define PMU_ID_MOD_TYPE_Msk                   (0x000000ffUL << PMU_ID_MOD_TYPE_Pos)                   /*!< PMU ID: MOD_TYPE Mask                   */
#define PMU_ID_MOD_NUMBER_Pos                 16                                                      /*!< PMU ID: MOD_NUMBER Position             */
#define PMU_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << PMU_ID_MOD_NUMBER_Pos)                 /*!< PMU ID: MOD_NUMBER Mask                 */


/* ================================================================================ */
/* ================          struct 'WDT' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  WDT_ID  ----------------------------------- */
#define WDT_ID_MOD_REV_Pos                    0                                                       /*!< WDT ID: MOD_REV Position                */
#define WDT_ID_MOD_REV_Msk                    (0x000000ffUL << WDT_ID_MOD_REV_Pos)                    /*!< WDT ID: MOD_REV Mask                    */
#define WDT_ID_MOD_TYPE_Pos                   8                                                       /*!< WDT ID: MOD_TYPE Position               */
#define WDT_ID_MOD_TYPE_Msk                   (0x000000ffUL << WDT_ID_MOD_TYPE_Pos)                   /*!< WDT ID: MOD_TYPE Mask                   */
#define WDT_ID_MOD_NUMBER_Pos                 16                                                      /*!< WDT ID: MOD_NUMBER Position             */
#define WDT_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << WDT_ID_MOD_NUMBER_Pos)                 /*!< WDT ID: MOD_NUMBER Mask                 */

/* -----------------------------------  WDT_CTR  ---------------------------------- */
#define WDT_CTR_ENB_Pos                       0                                                       /*!< WDT CTR: ENB Position                   */
#define WDT_CTR_ENB_Msk                       (0x01UL << WDT_CTR_ENB_Pos)                             /*!< WDT CTR: ENB Mask                       */
#define WDT_CTR_PRE_Pos                       1                                                       /*!< WDT CTR: PRE Position                   */
#define WDT_CTR_PRE_Msk                       (0x01UL << WDT_CTR_PRE_Pos)                             /*!< WDT CTR: PRE Mask                       */
#define WDT_CTR_DSP_Pos                       4                                                       /*!< WDT CTR: DSP Position                   */
#define WDT_CTR_DSP_Msk                       (0x01UL << WDT_CTR_DSP_Pos)                             /*!< WDT CTR: DSP Mask                       */
#define WDT_CTR_SPW_Pos                       8                                                       /*!< WDT CTR: SPW Position                   */
#define WDT_CTR_SPW_Msk                       (0x000000ffUL << WDT_CTR_SPW_Pos)                       /*!< WDT CTR: SPW Mask                       */

/* -----------------------------------  WDT_SRV  ---------------------------------- */
#define WDT_SRV_SRV_Pos                       0                                                       /*!< WDT SRV: SRV Position                   */
#define WDT_SRV_SRV_Msk                       (0xffffffffUL << WDT_SRV_SRV_Pos)                       /*!< WDT SRV: SRV Mask                       */

/* -----------------------------------  WDT_TIM  ---------------------------------- */
#define WDT_TIM_TIM_Pos                       0                                                       /*!< WDT TIM: TIM Position                   */
#define WDT_TIM_TIM_Msk                       (0xffffffffUL << WDT_TIM_TIM_Pos)                       /*!< WDT TIM: TIM Mask                       */

/* -----------------------------------  WDT_WLB  ---------------------------------- */
#define WDT_WLB_WLB_Pos                       0                                                       /*!< WDT WLB: WLB Position                   */
#define WDT_WLB_WLB_Msk                       (0xffffffffUL << WDT_WLB_WLB_Pos)                       /*!< WDT WLB: WLB Mask                       */

/* -----------------------------------  WDT_WUB  ---------------------------------- */
#define WDT_WUB_WUB_Pos                       0                                                       /*!< WDT WUB: WUB Position                   */
#define WDT_WUB_WUB_Msk                       (0xffffffffUL << WDT_WUB_WUB_Pos)                       /*!< WDT WUB: WUB Mask                       */

/* ---------------------------------  WDT_WDTSTS  --------------------------------- */
#define WDT_WDTSTS_ALMS_Pos                   0                                                       /*!< WDT WDTSTS: ALMS Position               */
#define WDT_WDTSTS_ALMS_Msk                   (0x01UL << WDT_WDTSTS_ALMS_Pos)                         /*!< WDT WDTSTS: ALMS Mask                   */

/* ---------------------------------  WDT_WDTCLR  --------------------------------- */
#define WDT_WDTCLR_ALMC_Pos                   0                                                       /*!< WDT WDTCLR: ALMC Position               */
#define WDT_WDTCLR_ALMC_Msk                   (0x01UL << WDT_WDTCLR_ALMC_Pos)                         /*!< WDT WDTCLR: ALMC Mask                   */


/* ================================================================================ */
/* ================          struct 'RTC' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  RTC_ID  ----------------------------------- */
#define RTC_ID_MOD_REV_Pos                    0                                                       /*!< RTC ID: MOD_REV Position                */
#define RTC_ID_MOD_REV_Msk                    (0x000000ffUL << RTC_ID_MOD_REV_Pos)                    /*!< RTC ID: MOD_REV Mask                    */
#define RTC_ID_MOD_TYPE_Pos                   8                                                       /*!< RTC ID: MOD_TYPE Position               */
#define RTC_ID_MOD_TYPE_Msk                   (0x000000ffUL << RTC_ID_MOD_TYPE_Pos)                   /*!< RTC ID: MOD_TYPE Mask                   */
#define RTC_ID_MOD_NUMBER_Pos                 16                                                      /*!< RTC ID: MOD_NUMBER Position             */
#define RTC_ID_MOD_NUMBER_Msk                 (0x0000ffffUL << RTC_ID_MOD_NUMBER_Pos)                 /*!< RTC ID: MOD_NUMBER Mask                 */

/* -----------------------------------  RTC_CTR  ---------------------------------- */
#define RTC_CTR_ENB_Pos                       0                                                       /*!< RTC CTR: ENB Position                   */
#define RTC_CTR_ENB_Msk                       (0x01UL << RTC_CTR_ENB_Pos)                             /*!< RTC CTR: ENB Mask                       */
#define RTC_CTR_TAE_Pos                       2                                                       /*!< RTC CTR: TAE Position                   */
#define RTC_CTR_TAE_Msk                       (0x01UL << RTC_CTR_TAE_Pos)                             /*!< RTC CTR: TAE Mask                       */
#define RTC_CTR_ESEC_Pos                      8                                                       /*!< RTC CTR: ESEC Position                  */
#define RTC_CTR_ESEC_Msk                      (0x01UL << RTC_CTR_ESEC_Pos)                            /*!< RTC CTR: ESEC Mask                      */
#define RTC_CTR_EMIC_Pos                      9                                                       /*!< RTC CTR: EMIC Position                  */
#define RTC_CTR_EMIC_Msk                      (0x01UL << RTC_CTR_EMIC_Pos)                            /*!< RTC CTR: EMIC Mask                      */
#define RTC_CTR_EHOC_Pos                      10                                                      /*!< RTC CTR: EHOC Position                  */
#define RTC_CTR_EHOC_Msk                      (0x01UL << RTC_CTR_EHOC_Pos)                            /*!< RTC CTR: EHOC Mask                      */
#define RTC_CTR_EDAC_Pos                      11                                                      /*!< RTC CTR: EDAC Position                  */
#define RTC_CTR_EDAC_Msk                      (0x01UL << RTC_CTR_EDAC_Pos)                            /*!< RTC CTR: EDAC Mask                      */
#define RTC_CTR_EMOC_Pos                      13                                                      /*!< RTC CTR: EMOC Position                  */
#define RTC_CTR_EMOC_Msk                      (0x01UL << RTC_CTR_EMOC_Pos)                            /*!< RTC CTR: EMOC Mask                      */
#define RTC_CTR_EYEC_Pos                      14                                                      /*!< RTC CTR: EYEC Position                  */
#define RTC_CTR_EYEC_Msk                      (0x01UL << RTC_CTR_EYEC_Pos)                            /*!< RTC CTR: EYEC Mask                      */
#define RTC_CTR_DIV_Pos                       16                                                      /*!< RTC CTR: DIV Position                   */
#define RTC_CTR_DIV_Msk                       (0x0000ffffUL << RTC_CTR_DIV_Pos)                       /*!< RTC CTR: DIV Mask                       */

/* ---------------------------------  RTC_RAWSTAT  -------------------------------- */
#define RTC_RAWSTAT_RPSE_Pos                  0                                                       /*!< RTC RAWSTAT: RPSE Position              */
#define RTC_RAWSTAT_RPSE_Msk                  (0x01UL << RTC_RAWSTAT_RPSE_Pos)                        /*!< RTC RAWSTAT: RPSE Mask                  */
#define RTC_RAWSTAT_RPMI_Pos                  1                                                       /*!< RTC RAWSTAT: RPMI Position              */
#define RTC_RAWSTAT_RPMI_Msk                  (0x01UL << RTC_RAWSTAT_RPMI_Pos)                        /*!< RTC RAWSTAT: RPMI Mask                  */
#define RTC_RAWSTAT_RPHO_Pos                  2                                                       /*!< RTC RAWSTAT: RPHO Position              */
#define RTC_RAWSTAT_RPHO_Msk                  (0x01UL << RTC_RAWSTAT_RPHO_Pos)                        /*!< RTC RAWSTAT: RPHO Mask                  */
#define RTC_RAWSTAT_RPDA_Pos                  3                                                       /*!< RTC RAWSTAT: RPDA Position              */
#define RTC_RAWSTAT_RPDA_Msk                  (0x01UL << RTC_RAWSTAT_RPDA_Pos)                        /*!< RTC RAWSTAT: RPDA Mask                  */
#define RTC_RAWSTAT_RPMO_Pos                  5                                                       /*!< RTC RAWSTAT: RPMO Position              */
#define RTC_RAWSTAT_RPMO_Msk                  (0x01UL << RTC_RAWSTAT_RPMO_Pos)                        /*!< RTC RAWSTAT: RPMO Mask                  */
#define RTC_RAWSTAT_RPYE_Pos                  6                                                       /*!< RTC RAWSTAT: RPYE Position              */
#define RTC_RAWSTAT_RPYE_Msk                  (0x01UL << RTC_RAWSTAT_RPYE_Pos)                        /*!< RTC RAWSTAT: RPYE Mask                  */
#define RTC_RAWSTAT_RAI_Pos                   8                                                       /*!< RTC RAWSTAT: RAI Position               */
#define RTC_RAWSTAT_RAI_Msk                   (0x01UL << RTC_RAWSTAT_RAI_Pos)                         /*!< RTC RAWSTAT: RAI Mask                   */

/* ----------------------------------  RTC_STSSR  --------------------------------- */
#define RTC_STSSR_SPSE_Pos                    0                                                       /*!< RTC STSSR: SPSE Position                */
#define RTC_STSSR_SPSE_Msk                    (0x01UL << RTC_STSSR_SPSE_Pos)                          /*!< RTC STSSR: SPSE Mask                    */
#define RTC_STSSR_SPMI_Pos                    1                                                       /*!< RTC STSSR: SPMI Position                */
#define RTC_STSSR_SPMI_Msk                    (0x01UL << RTC_STSSR_SPMI_Pos)                          /*!< RTC STSSR: SPMI Mask                    */
#define RTC_STSSR_SPHO_Pos                    2                                                       /*!< RTC STSSR: SPHO Position                */
#define RTC_STSSR_SPHO_Msk                    (0x01UL << RTC_STSSR_SPHO_Pos)                          /*!< RTC STSSR: SPHO Mask                    */
#define RTC_STSSR_SPDA_Pos                    3                                                       /*!< RTC STSSR: SPDA Position                */
#define RTC_STSSR_SPDA_Msk                    (0x01UL << RTC_STSSR_SPDA_Pos)                          /*!< RTC STSSR: SPDA Mask                    */
#define RTC_STSSR_SPMO_Pos                    5                                                       /*!< RTC STSSR: SPMO Position                */
#define RTC_STSSR_SPMO_Msk                    (0x01UL << RTC_STSSR_SPMO_Pos)                          /*!< RTC STSSR: SPMO Mask                    */
#define RTC_STSSR_SPYE_Pos                    6                                                       /*!< RTC STSSR: SPYE Position                */
#define RTC_STSSR_SPYE_Msk                    (0x01UL << RTC_STSSR_SPYE_Pos)                          /*!< RTC STSSR: SPYE Mask                    */
#define RTC_STSSR_SAI_Pos                     8                                                       /*!< RTC STSSR: SAI Position                 */
#define RTC_STSSR_SAI_Msk                     (0x01UL << RTC_STSSR_SAI_Pos)                           /*!< RTC STSSR: SAI Mask                     */

/* ----------------------------------  RTC_MSKSR  --------------------------------- */
#define RTC_MSKSR_MPSE_Pos                    0                                                       /*!< RTC MSKSR: MPSE Position                */
#define RTC_MSKSR_MPSE_Msk                    (0x01UL << RTC_MSKSR_MPSE_Pos)                          /*!< RTC MSKSR: MPSE Mask                    */
#define RTC_MSKSR_MPMI_Pos                    1                                                       /*!< RTC MSKSR: MPMI Position                */
#define RTC_MSKSR_MPMI_Msk                    (0x01UL << RTC_MSKSR_MPMI_Pos)                          /*!< RTC MSKSR: MPMI Mask                    */
#define RTC_MSKSR_MPHO_Pos                    2                                                       /*!< RTC MSKSR: MPHO Position                */
#define RTC_MSKSR_MPHO_Msk                    (0x01UL << RTC_MSKSR_MPHO_Pos)                          /*!< RTC MSKSR: MPHO Mask                    */
#define RTC_MSKSR_MPDA_Pos                    3                                                       /*!< RTC MSKSR: MPDA Position                */
#define RTC_MSKSR_MPDA_Msk                    (0x01UL << RTC_MSKSR_MPDA_Pos)                          /*!< RTC MSKSR: MPDA Mask                    */
#define RTC_MSKSR_MPMO_Pos                    5                                                       /*!< RTC MSKSR: MPMO Position                */
#define RTC_MSKSR_MPMO_Msk                    (0x01UL << RTC_MSKSR_MPMO_Pos)                          /*!< RTC MSKSR: MPMO Mask                    */
#define RTC_MSKSR_MPYE_Pos                    6                                                       /*!< RTC MSKSR: MPYE Position                */
#define RTC_MSKSR_MPYE_Msk                    (0x01UL << RTC_MSKSR_MPYE_Pos)                          /*!< RTC MSKSR: MPYE Mask                    */
#define RTC_MSKSR_MAI_Pos                     8                                                       /*!< RTC MSKSR: MAI Position                 */
#define RTC_MSKSR_MAI_Msk                     (0x01UL << RTC_MSKSR_MAI_Pos)                           /*!< RTC MSKSR: MAI Mask                     */

/* ----------------------------------  RTC_CLRSR  --------------------------------- */
#define RTC_CLRSR_RPSE_Pos                    0                                                       /*!< RTC CLRSR: RPSE Position                */
#define RTC_CLRSR_RPSE_Msk                    (0x01UL << RTC_CLRSR_RPSE_Pos)                          /*!< RTC CLRSR: RPSE Mask                    */
#define RTC_CLRSR_RPMI_Pos                    1                                                       /*!< RTC CLRSR: RPMI Position                */
#define RTC_CLRSR_RPMI_Msk                    (0x01UL << RTC_CLRSR_RPMI_Pos)                          /*!< RTC CLRSR: RPMI Mask                    */
#define RTC_CLRSR_RPHO_Pos                    2                                                       /*!< RTC CLRSR: RPHO Position                */
#define RTC_CLRSR_RPHO_Msk                    (0x01UL << RTC_CLRSR_RPHO_Pos)                          /*!< RTC CLRSR: RPHO Mask                    */
#define RTC_CLRSR_RPDA_Pos                    3                                                       /*!< RTC CLRSR: RPDA Position                */
#define RTC_CLRSR_RPDA_Msk                    (0x01UL << RTC_CLRSR_RPDA_Pos)                          /*!< RTC CLRSR: RPDA Mask                    */
#define RTC_CLRSR_RPMO_Pos                    5                                                       /*!< RTC CLRSR: RPMO Position                */
#define RTC_CLRSR_RPMO_Msk                    (0x01UL << RTC_CLRSR_RPMO_Pos)                          /*!< RTC CLRSR: RPMO Mask                    */
#define RTC_CLRSR_RPYE_Pos                    6                                                       /*!< RTC CLRSR: RPYE Position                */
#define RTC_CLRSR_RPYE_Msk                    (0x01UL << RTC_CLRSR_RPYE_Pos)                          /*!< RTC CLRSR: RPYE Mask                    */
#define RTC_CLRSR_RAI_Pos                     8                                                       /*!< RTC CLRSR: RAI Position                 */
#define RTC_CLRSR_RAI_Msk                     (0x01UL << RTC_CLRSR_RAI_Pos)                           /*!< RTC CLRSR: RAI Mask                     */

/* ----------------------------------  RTC_ATIM0  --------------------------------- */
#define RTC_ATIM0_ASE_Pos                     0                                                       /*!< RTC ATIM0: ASE Position                 */
#define RTC_ATIM0_ASE_Msk                     (0x3fUL << RTC_ATIM0_ASE_Pos)                           /*!< RTC ATIM0: ASE Mask                     */
#define RTC_ATIM0_AMI_Pos                     8                                                       /*!< RTC ATIM0: AMI Position                 */
#define RTC_ATIM0_AMI_Msk                     (0x3fUL << RTC_ATIM0_AMI_Pos)                           /*!< RTC ATIM0: AMI Mask                     */
#define RTC_ATIM0_AHO_Pos                     16                                                      /*!< RTC ATIM0: AHO Position                 */
#define RTC_ATIM0_AHO_Msk                     (0x1fUL << RTC_ATIM0_AHO_Pos)                           /*!< RTC ATIM0: AHO Mask                     */
#define RTC_ATIM0_ADA_Pos                     24                                                      /*!< RTC ATIM0: ADA Position                 */
#define RTC_ATIM0_ADA_Msk                     (0x1fUL << RTC_ATIM0_ADA_Pos)                           /*!< RTC ATIM0: ADA Mask                     */

/* ----------------------------------  RTC_ATIM1  --------------------------------- */
#define RTC_ATIM1_AMO_Pos                     8                                                       /*!< RTC ATIM1: AMO Position                 */
#define RTC_ATIM1_AMO_Msk                     (0x0fUL << RTC_ATIM1_AMO_Pos)                           /*!< RTC ATIM1: AMO Mask                     */
#define RTC_ATIM1_AYE_Pos                     16                                                      /*!< RTC ATIM1: AYE Position                 */
#define RTC_ATIM1_AYE_Msk                     (0x0000ffffUL << RTC_ATIM1_AYE_Pos)                     /*!< RTC ATIM1: AYE Mask                     */

/* ----------------------------------  RTC_TIM0  ---------------------------------- */
#define RTC_TIM0_SE_Pos                       0                                                       /*!< RTC TIM0: SE Position                   */
#define RTC_TIM0_SE_Msk                       (0x3fUL << RTC_TIM0_SE_Pos)                             /*!< RTC TIM0: SE Mask                       */
#define RTC_TIM0_MI_Pos                       8                                                       /*!< RTC TIM0: MI Position                   */
#define RTC_TIM0_MI_Msk                       (0x3fUL << RTC_TIM0_MI_Pos)                             /*!< RTC TIM0: MI Mask                       */
#define RTC_TIM0_HO_Pos                       16                                                      /*!< RTC TIM0: HO Position                   */
#define RTC_TIM0_HO_Msk                       (0x1fUL << RTC_TIM0_HO_Pos)                             /*!< RTC TIM0: HO Mask                       */
#define RTC_TIM0_DA_Pos                       24                                                      /*!< RTC TIM0: DA Position                   */
#define RTC_TIM0_DA_Msk                       (0x1fUL << RTC_TIM0_DA_Pos)                             /*!< RTC TIM0: DA Mask                       */

/* ----------------------------------  RTC_TIM1  ---------------------------------- */
#define RTC_TIM1_DAWE_Pos                     0                                                       /*!< RTC TIM1: DAWE Position                 */
#define RTC_TIM1_DAWE_Msk                     (0x07UL << RTC_TIM1_DAWE_Pos)                           /*!< RTC TIM1: DAWE Mask                     */
#define RTC_TIM1_MO_Pos                       8                                                       /*!< RTC TIM1: MO Position                   */
#define RTC_TIM1_MO_Msk                       (0x0fUL << RTC_TIM1_MO_Pos)                             /*!< RTC TIM1: MO Mask                       */
#define RTC_TIM1_YE_Pos                       16                                                      /*!< RTC TIM1: YE Position                   */
#define RTC_TIM1_YE_Msk                       (0x0000ffffUL << RTC_TIM1_YE_Pos)                       /*!< RTC TIM1: YE Mask                       */


/* ================================================================================ */
/* ================        struct 'SCU_CLK' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_CLK_CLKSTAT  ------------------------------ */
#define SCU_CLK_CLKSTAT_USBCST_Pos            0                                                       /*!< SCU_CLK CLKSTAT: USBCST Position        */
#define SCU_CLK_CLKSTAT_USBCST_Msk            (0x01UL << SCU_CLK_CLKSTAT_USBCST_Pos)                  /*!< SCU_CLK CLKSTAT: USBCST Mask            */
#define SCU_CLK_CLKSTAT_ETH0CST_Pos           2                                                       /*!< SCU_CLK CLKSTAT: ETH0CST Position       */
#define SCU_CLK_CLKSTAT_ETH0CST_Msk           (0x01UL << SCU_CLK_CLKSTAT_ETH0CST_Pos)                 /*!< SCU_CLK CLKSTAT: ETH0CST Mask           */
#define SCU_CLK_CLKSTAT_CCUCST_Pos            4                                                       /*!< SCU_CLK CLKSTAT: CCUCST Position        */
#define SCU_CLK_CLKSTAT_CCUCST_Msk            (0x01UL << SCU_CLK_CLKSTAT_CCUCST_Pos)                  /*!< SCU_CLK CLKSTAT: CCUCST Mask            */
#define SCU_CLK_CLKSTAT_WDTCST_Pos            5                                                       /*!< SCU_CLK CLKSTAT: WDTCST Position        */
#define SCU_CLK_CLKSTAT_WDTCST_Msk            (0x01UL << SCU_CLK_CLKSTAT_WDTCST_Pos)                  /*!< SCU_CLK CLKSTAT: WDTCST Mask            */

/* -------------------------------  SCU_CLK_CLKSET  ------------------------------- */
#define SCU_CLK_CLKSET_USBCEN_Pos             0                                                       /*!< SCU_CLK CLKSET: USBCEN Position         */
#define SCU_CLK_CLKSET_USBCEN_Msk             (0x01UL << SCU_CLK_CLKSET_USBCEN_Pos)                   /*!< SCU_CLK CLKSET: USBCEN Mask             */
#define SCU_CLK_CLKSET_ETH0CEN_Pos            2                                                       /*!< SCU_CLK CLKSET: ETH0CEN Position        */
#define SCU_CLK_CLKSET_ETH0CEN_Msk            (0x01UL << SCU_CLK_CLKSET_ETH0CEN_Pos)                  /*!< SCU_CLK CLKSET: ETH0CEN Mask            */
#define SCU_CLK_CLKSET_CCUCEN_Pos             4                                                       /*!< SCU_CLK CLKSET: CCUCEN Position         */
#define SCU_CLK_CLKSET_CCUCEN_Msk             (0x01UL << SCU_CLK_CLKSET_CCUCEN_Pos)                   /*!< SCU_CLK CLKSET: CCUCEN Mask             */
#define SCU_CLK_CLKSET_WDTCEN_Pos             5                                                       /*!< SCU_CLK CLKSET: WDTCEN Position         */
#define SCU_CLK_CLKSET_WDTCEN_Msk             (0x01UL << SCU_CLK_CLKSET_WDTCEN_Pos)                   /*!< SCU_CLK CLKSET: WDTCEN Mask             */

/* -------------------------------  SCU_CLK_CLKCLR  ------------------------------- */
#define SCU_CLK_CLKCLR_USBCDI_Pos             0                                                       /*!< SCU_CLK CLKCLR: USBCDI Position         */
#define SCU_CLK_CLKCLR_USBCDI_Msk             (0x01UL << SCU_CLK_CLKCLR_USBCDI_Pos)                   /*!< SCU_CLK CLKCLR: USBCDI Mask             */
#define SCU_CLK_CLKCLR_ETH0CDI_Pos            2                                                       /*!< SCU_CLK CLKCLR: ETH0CDI Position        */
#define SCU_CLK_CLKCLR_ETH0CDI_Msk            (0x01UL << SCU_CLK_CLKCLR_ETH0CDI_Pos)                  /*!< SCU_CLK CLKCLR: ETH0CDI Mask            */
#define SCU_CLK_CLKCLR_CCUCDI_Pos             4                                                       /*!< SCU_CLK CLKCLR: CCUCDI Position         */
#define SCU_CLK_CLKCLR_CCUCDI_Msk             (0x01UL << SCU_CLK_CLKCLR_CCUCDI_Pos)                   /*!< SCU_CLK CLKCLR: CCUCDI Mask             */
#define SCU_CLK_CLKCLR_WDTCDI_Pos             5                                                       /*!< SCU_CLK CLKCLR: WDTCDI Position         */
#define SCU_CLK_CLKCLR_WDTCDI_Msk             (0x01UL << SCU_CLK_CLKCLR_WDTCDI_Pos)                   /*!< SCU_CLK CLKCLR: WDTCDI Mask             */

/* ------------------------------  SCU_CLK_SYSCLKCR  ------------------------------ */
#define SCU_CLK_SYSCLKCR_SYSDIV_Pos           0                                                       /*!< SCU_CLK SYSCLKCR: SYSDIV Position       */
#define SCU_CLK_SYSCLKCR_SYSDIV_Msk           (0x000000ffUL << SCU_CLK_SYSCLKCR_SYSDIV_Pos)           /*!< SCU_CLK SYSCLKCR: SYSDIV Mask           */
#define SCU_CLK_SYSCLKCR_SYSSEL_Pos           16                                                      /*!< SCU_CLK SYSCLKCR: SYSSEL Position       */
#define SCU_CLK_SYSCLKCR_SYSSEL_Msk           (0x01UL << SCU_CLK_SYSCLKCR_SYSSEL_Pos)                 /*!< SCU_CLK SYSCLKCR: SYSSEL Mask           */

/* ------------------------------  SCU_CLK_CPUCLKCR  ------------------------------ */
#define SCU_CLK_CPUCLKCR_CPUDIV_Pos           0                                                       /*!< SCU_CLK CPUCLKCR: CPUDIV Position       */
#define SCU_CLK_CPUCLKCR_CPUDIV_Msk           (0x01UL << SCU_CLK_CPUCLKCR_CPUDIV_Pos)                 /*!< SCU_CLK CPUCLKCR: CPUDIV Mask           */

/* -------------------------------  SCU_CLK_PBCLKCR  ------------------------------ */
#define SCU_CLK_PBCLKCR_PBDIV_Pos             0                                                       /*!< SCU_CLK PBCLKCR: PBDIV Position         */
#define SCU_CLK_PBCLKCR_PBDIV_Msk             (0x01UL << SCU_CLK_PBCLKCR_PBDIV_Pos)                   /*!< SCU_CLK PBCLKCR: PBDIV Mask             */

/* ------------------------------  SCU_CLK_USBCLKCR  ------------------------------ */
#define SCU_CLK_USBCLKCR_USBDIV_Pos           0                                                       /*!< SCU_CLK USBCLKCR: USBDIV Position       */
#define SCU_CLK_USBCLKCR_USBDIV_Msk           (0x07UL << SCU_CLK_USBCLKCR_USBDIV_Pos)                 /*!< SCU_CLK USBCLKCR: USBDIV Mask           */
#define SCU_CLK_USBCLKCR_USBSEL_Pos           16                                                      /*!< SCU_CLK USBCLKCR: USBSEL Position       */
#define SCU_CLK_USBCLKCR_USBSEL_Msk           (0x01UL << SCU_CLK_USBCLKCR_USBSEL_Pos)                 /*!< SCU_CLK USBCLKCR: USBSEL Mask           */

/* ------------------------------  SCU_CLK_CCUCLKCR  ------------------------------ */
#define SCU_CLK_CCUCLKCR_CCUDIV_Pos           0                                                       /*!< SCU_CLK CCUCLKCR: CCUDIV Position       */
#define SCU_CLK_CCUCLKCR_CCUDIV_Msk           (0x01UL << SCU_CLK_CCUCLKCR_CCUDIV_Pos)                 /*!< SCU_CLK CCUCLKCR: CCUDIV Mask           */

/* ------------------------------  SCU_CLK_WDTCLKCR  ------------------------------ */
#define SCU_CLK_WDTCLKCR_WDTDIV_Pos           0                                                       /*!< SCU_CLK WDTCLKCR: WDTDIV Position       */
#define SCU_CLK_WDTCLKCR_WDTDIV_Msk           (0x000000ffUL << SCU_CLK_WDTCLKCR_WDTDIV_Pos)           /*!< SCU_CLK WDTCLKCR: WDTDIV Mask           */
#define SCU_CLK_WDTCLKCR_WDTSEL_Pos           16                                                      /*!< SCU_CLK WDTCLKCR: WDTSEL Position       */
#define SCU_CLK_WDTCLKCR_WDTSEL_Msk           (0x03UL << SCU_CLK_WDTCLKCR_WDTSEL_Pos)                 /*!< SCU_CLK WDTCLKCR: WDTSEL Mask           */

/* ------------------------------  SCU_CLK_EXTCLKCR  ------------------------------ */
#define SCU_CLK_EXTCLKCR_ECKSEL_Pos           0                                                       /*!< SCU_CLK EXTCLKCR: ECKSEL Position       */
#define SCU_CLK_EXTCLKCR_ECKSEL_Msk           (0x07UL << SCU_CLK_EXTCLKCR_ECKSEL_Pos)                 /*!< SCU_CLK EXTCLKCR: ECKSEL Mask           */
#define SCU_CLK_EXTCLKCR_ECKDIV_Pos           16                                                      /*!< SCU_CLK EXTCLKCR: ECKDIV Position       */
#define SCU_CLK_EXTCLKCR_ECKDIV_Msk           (0x000001ffUL << SCU_CLK_EXTCLKCR_ECKDIV_Pos)           /*!< SCU_CLK EXTCLKCR: ECKDIV Mask           */

/* -----------------------------  SCU_CLK_MLINKCLKCR  ----------------------------- */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Pos         0                                                       /*!< SCU_CLK MLINKCLKCR: SYSDIV Position     */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Msk         (0x000000ffUL << SCU_CLK_MLINKCLKCR_SYSDIV_Pos)         /*!< SCU_CLK MLINKCLKCR: SYSDIV Mask         */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Pos         8                                                       /*!< SCU_CLK MLINKCLKCR: SYSSEL Position     */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Msk         (0x01UL << SCU_CLK_MLINKCLKCR_SYSSEL_Pos)               /*!< SCU_CLK MLINKCLKCR: SYSSEL Mask         */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Pos         10                                                      /*!< SCU_CLK MLINKCLKCR: CPUDIV Position     */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Msk         (0x01UL << SCU_CLK_MLINKCLKCR_CPUDIV_Pos)               /*!< SCU_CLK MLINKCLKCR: CPUDIV Mask         */
#define SCU_CLK_MLINKCLKCR_PBDIV_Pos          12                                                      /*!< SCU_CLK MLINKCLKCR: PBDIV Position      */
#define SCU_CLK_MLINKCLKCR_PBDIV_Msk          (0x01UL << SCU_CLK_MLINKCLKCR_PBDIV_Pos)                /*!< SCU_CLK MLINKCLKCR: PBDIV Mask          */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Pos         14                                                      /*!< SCU_CLK MLINKCLKCR: CCUDIV Position     */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Msk         (0x01UL << SCU_CLK_MLINKCLKCR_CCUDIV_Pos)               /*!< SCU_CLK MLINKCLKCR: CCUDIV Mask         */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Pos         16                                                      /*!< SCU_CLK MLINKCLKCR: WDTDIV Position     */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Msk         (0x000000ffUL << SCU_CLK_MLINKCLKCR_WDTDIV_Pos)         /*!< SCU_CLK MLINKCLKCR: WDTDIV Mask         */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Pos         24                                                      /*!< SCU_CLK MLINKCLKCR: WDTSEL Position     */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Msk         (0x03UL << SCU_CLK_MLINKCLKCR_WDTSEL_Pos)               /*!< SCU_CLK MLINKCLKCR: WDTSEL Mask         */

/* -------------------------------  SCU_CLK_SLEEPCR  ------------------------------ */
#define SCU_CLK_SLEEPCR_SYSSEL_Pos            0                                                       /*!< SCU_CLK SLEEPCR: SYSSEL Position        */
#define SCU_CLK_SLEEPCR_SYSSEL_Msk            (0x01UL << SCU_CLK_SLEEPCR_SYSSEL_Pos)                  /*!< SCU_CLK SLEEPCR: SYSSEL Mask            */
#define SCU_CLK_SLEEPCR_USBCR_Pos             16                                                      /*!< SCU_CLK SLEEPCR: USBCR Position         */
#define SCU_CLK_SLEEPCR_USBCR_Msk             (0x01UL << SCU_CLK_SLEEPCR_USBCR_Pos)                   /*!< SCU_CLK SLEEPCR: USBCR Mask             */
#define SCU_CLK_SLEEPCR_ETH0CR_Pos            18                                                      /*!< SCU_CLK SLEEPCR: ETH0CR Position        */
#define SCU_CLK_SLEEPCR_ETH0CR_Msk            (0x01UL << SCU_CLK_SLEEPCR_ETH0CR_Pos)                  /*!< SCU_CLK SLEEPCR: ETH0CR Mask            */
#define SCU_CLK_SLEEPCR_CCUCR_Pos             20                                                      /*!< SCU_CLK SLEEPCR: CCUCR Position         */
#define SCU_CLK_SLEEPCR_CCUCR_Msk             (0x01UL << SCU_CLK_SLEEPCR_CCUCR_Pos)                   /*!< SCU_CLK SLEEPCR: CCUCR Mask             */
#define SCU_CLK_SLEEPCR_WDTCR_Pos             21                                                      /*!< SCU_CLK SLEEPCR: WDTCR Position         */
#define SCU_CLK_SLEEPCR_WDTCR_Msk             (0x01UL << SCU_CLK_SLEEPCR_WDTCR_Pos)                   /*!< SCU_CLK SLEEPCR: WDTCR Mask             */

/* ------------------------------  SCU_CLK_DSLEEPCR  ------------------------------ */
#define SCU_CLK_DSLEEPCR_SYSSEL_Pos           0                                                       /*!< SCU_CLK DSLEEPCR: SYSSEL Position       */
#define SCU_CLK_DSLEEPCR_SYSSEL_Msk           (0x01UL << SCU_CLK_DSLEEPCR_SYSSEL_Pos)                 /*!< SCU_CLK DSLEEPCR: SYSSEL Mask           */
#define SCU_CLK_DSLEEPCR_FPDN_Pos             11                                                      /*!< SCU_CLK DSLEEPCR: FPDN Position         */
#define SCU_CLK_DSLEEPCR_FPDN_Msk             (0x01UL << SCU_CLK_DSLEEPCR_FPDN_Pos)                   /*!< SCU_CLK DSLEEPCR: FPDN Mask             */
#define SCU_CLK_DSLEEPCR_PLLPDN_Pos           12                                                      /*!< SCU_CLK DSLEEPCR: PLLPDN Position       */
#define SCU_CLK_DSLEEPCR_PLLPDN_Msk           (0x01UL << SCU_CLK_DSLEEPCR_PLLPDN_Pos)                 /*!< SCU_CLK DSLEEPCR: PLLPDN Mask           */
#define SCU_CLK_DSLEEPCR_VCOPDN_Pos           13                                                      /*!< SCU_CLK DSLEEPCR: VCOPDN Position       */
#define SCU_CLK_DSLEEPCR_VCOPDN_Msk           (0x01UL << SCU_CLK_DSLEEPCR_VCOPDN_Pos)                 /*!< SCU_CLK DSLEEPCR: VCOPDN Mask           */
#define SCU_CLK_DSLEEPCR_USBCR_Pos            16                                                      /*!< SCU_CLK DSLEEPCR: USBCR Position        */
#define SCU_CLK_DSLEEPCR_USBCR_Msk            (0x01UL << SCU_CLK_DSLEEPCR_USBCR_Pos)                  /*!< SCU_CLK DSLEEPCR: USBCR Mask            */
#define SCU_CLK_DSLEEPCR_ETH0CR_Pos           18                                                      /*!< SCU_CLK DSLEEPCR: ETH0CR Position       */
#define SCU_CLK_DSLEEPCR_ETH0CR_Msk           (0x01UL << SCU_CLK_DSLEEPCR_ETH0CR_Pos)                 /*!< SCU_CLK DSLEEPCR: ETH0CR Mask           */
#define SCU_CLK_DSLEEPCR_CCUCR_Pos            20                                                      /*!< SCU_CLK DSLEEPCR: CCUCR Position        */
#define SCU_CLK_DSLEEPCR_CCUCR_Msk            (0x01UL << SCU_CLK_DSLEEPCR_CCUCR_Pos)                  /*!< SCU_CLK DSLEEPCR: CCUCR Mask            */
#define SCU_CLK_DSLEEPCR_WDTCR_Pos            21                                                      /*!< SCU_CLK DSLEEPCR: WDTCR Position        */
#define SCU_CLK_DSLEEPCR_WDTCR_Msk            (0x01UL << SCU_CLK_DSLEEPCR_WDTCR_Pos)                  /*!< SCU_CLK DSLEEPCR: WDTCR Mask            */

/* ------------------------------  SCU_CLK_CGATSTAT0  ----------------------------- */
#define SCU_CLK_CGATSTAT0_VADC_Pos            0                                                       /*!< SCU_CLK CGATSTAT0: VADC Position        */
#define SCU_CLK_CGATSTAT0_VADC_Msk            (0x01UL << SCU_CLK_CGATSTAT0_VADC_Pos)                  /*!< SCU_CLK CGATSTAT0: VADC Mask            */
#define SCU_CLK_CGATSTAT0_DSD_Pos             1                                                       /*!< SCU_CLK CGATSTAT0: DSD Position         */
#define SCU_CLK_CGATSTAT0_DSD_Msk             (0x01UL << SCU_CLK_CGATSTAT0_DSD_Pos)                   /*!< SCU_CLK CGATSTAT0: DSD Mask             */
#define SCU_CLK_CGATSTAT0_CCU40_Pos           2                                                       /*!< SCU_CLK CGATSTAT0: CCU40 Position       */
#define SCU_CLK_CGATSTAT0_CCU40_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU40_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU40 Mask           */
#define SCU_CLK_CGATSTAT0_CCU41_Pos           3                                                       /*!< SCU_CLK CGATSTAT0: CCU41 Position       */
#define SCU_CLK_CGATSTAT0_CCU41_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU41_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU41 Mask           */
#define SCU_CLK_CGATSTAT0_CCU42_Pos           4                                                       /*!< SCU_CLK CGATSTAT0: CCU42 Position       */
#define SCU_CLK_CGATSTAT0_CCU42_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU42_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU42 Mask           */
#define SCU_CLK_CGATSTAT0_CCU80_Pos           7                                                       /*!< SCU_CLK CGATSTAT0: CCU80 Position       */
#define SCU_CLK_CGATSTAT0_CCU80_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU80_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU80 Mask           */
#define SCU_CLK_CGATSTAT0_CCU81_Pos           8                                                       /*!< SCU_CLK CGATSTAT0: CCU81 Position       */
#define SCU_CLK_CGATSTAT0_CCU81_Msk           (0x01UL << SCU_CLK_CGATSTAT0_CCU81_Pos)                 /*!< SCU_CLK CGATSTAT0: CCU81 Mask           */
#define SCU_CLK_CGATSTAT0_POSIF0_Pos          9                                                       /*!< SCU_CLK CGATSTAT0: POSIF0 Position      */
#define SCU_CLK_CGATSTAT0_POSIF0_Msk          (0x01UL << SCU_CLK_CGATSTAT0_POSIF0_Pos)                /*!< SCU_CLK CGATSTAT0: POSIF0 Mask          */
#define SCU_CLK_CGATSTAT0_POSIF1_Pos          10                                                      /*!< SCU_CLK CGATSTAT0: POSIF1 Position      */
#define SCU_CLK_CGATSTAT0_POSIF1_Msk          (0x01UL << SCU_CLK_CGATSTAT0_POSIF1_Pos)                /*!< SCU_CLK CGATSTAT0: POSIF1 Mask          */
#define SCU_CLK_CGATSTAT0_USIC0_Pos           11                                                      /*!< SCU_CLK CGATSTAT0: USIC0 Position       */
#define SCU_CLK_CGATSTAT0_USIC0_Msk           (0x01UL << SCU_CLK_CGATSTAT0_USIC0_Pos)                 /*!< SCU_CLK CGATSTAT0: USIC0 Mask           */
#define SCU_CLK_CGATSTAT0_ERU1_Pos            16                                                      /*!< SCU_CLK CGATSTAT0: ERU1 Position        */
#define SCU_CLK_CGATSTAT0_ERU1_Msk            (0x01UL << SCU_CLK_CGATSTAT0_ERU1_Pos)                  /*!< SCU_CLK CGATSTAT0: ERU1 Mask            */
#define SCU_CLK_CGATSTAT0_HRPWM0_Pos          23                                                      /*!< SCU_CLK CGATSTAT0: HRPWM0 Position      */
#define SCU_CLK_CGATSTAT0_HRPWM0_Msk          (0x01UL << SCU_CLK_CGATSTAT0_HRPWM0_Pos)                /*!< SCU_CLK CGATSTAT0: HRPWM0 Mask          */

/* ------------------------------  SCU_CLK_CGATSET0  ------------------------------ */
#define SCU_CLK_CGATSET0_VADC_Pos             0                                                       /*!< SCU_CLK CGATSET0: VADC Position         */
#define SCU_CLK_CGATSET0_VADC_Msk             (0x01UL << SCU_CLK_CGATSET0_VADC_Pos)                   /*!< SCU_CLK CGATSET0: VADC Mask             */
#define SCU_CLK_CGATSET0_DSD_Pos              1                                                       /*!< SCU_CLK CGATSET0: DSD Position          */
#define SCU_CLK_CGATSET0_DSD_Msk              (0x01UL << SCU_CLK_CGATSET0_DSD_Pos)                    /*!< SCU_CLK CGATSET0: DSD Mask              */
#define SCU_CLK_CGATSET0_CCU40_Pos            2                                                       /*!< SCU_CLK CGATSET0: CCU40 Position        */
#define SCU_CLK_CGATSET0_CCU40_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU40_Pos)                  /*!< SCU_CLK CGATSET0: CCU40 Mask            */
#define SCU_CLK_CGATSET0_CCU41_Pos            3                                                       /*!< SCU_CLK CGATSET0: CCU41 Position        */
#define SCU_CLK_CGATSET0_CCU41_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU41_Pos)                  /*!< SCU_CLK CGATSET0: CCU41 Mask            */
#define SCU_CLK_CGATSET0_CCU42_Pos            4                                                       /*!< SCU_CLK CGATSET0: CCU42 Position        */
#define SCU_CLK_CGATSET0_CCU42_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU42_Pos)                  /*!< SCU_CLK CGATSET0: CCU42 Mask            */
#define SCU_CLK_CGATSET0_CCU80_Pos            7                                                       /*!< SCU_CLK CGATSET0: CCU80 Position        */
#define SCU_CLK_CGATSET0_CCU80_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU80_Pos)                  /*!< SCU_CLK CGATSET0: CCU80 Mask            */
#define SCU_CLK_CGATSET0_CCU81_Pos            8                                                       /*!< SCU_CLK CGATSET0: CCU81 Position        */
#define SCU_CLK_CGATSET0_CCU81_Msk            (0x01UL << SCU_CLK_CGATSET0_CCU81_Pos)                  /*!< SCU_CLK CGATSET0: CCU81 Mask            */
#define SCU_CLK_CGATSET0_POSIF0_Pos           9                                                       /*!< SCU_CLK CGATSET0: POSIF0 Position       */
#define SCU_CLK_CGATSET0_POSIF0_Msk           (0x01UL << SCU_CLK_CGATSET0_POSIF0_Pos)                 /*!< SCU_CLK CGATSET0: POSIF0 Mask           */
#define SCU_CLK_CGATSET0_POSIF1_Pos           10                                                      /*!< SCU_CLK CGATSET0: POSIF1 Position       */
#define SCU_CLK_CGATSET0_POSIF1_Msk           (0x01UL << SCU_CLK_CGATSET0_POSIF1_Pos)                 /*!< SCU_CLK CGATSET0: POSIF1 Mask           */
#define SCU_CLK_CGATSET0_USIC0_Pos            11                                                      /*!< SCU_CLK CGATSET0: USIC0 Position        */
#define SCU_CLK_CGATSET0_USIC0_Msk            (0x01UL << SCU_CLK_CGATSET0_USIC0_Pos)                  /*!< SCU_CLK CGATSET0: USIC0 Mask            */
#define SCU_CLK_CGATSET0_ERU1_Pos             16                                                      /*!< SCU_CLK CGATSET0: ERU1 Position         */
#define SCU_CLK_CGATSET0_ERU1_Msk             (0x01UL << SCU_CLK_CGATSET0_ERU1_Pos)                   /*!< SCU_CLK CGATSET0: ERU1 Mask             */
#define SCU_CLK_CGATSET0_HRPWM0_Pos           23                                                      /*!< SCU_CLK CGATSET0: HRPWM0 Position       */
#define SCU_CLK_CGATSET0_HRPWM0_Msk           (0x01UL << SCU_CLK_CGATSET0_HRPWM0_Pos)                 /*!< SCU_CLK CGATSET0: HRPWM0 Mask           */

/* ------------------------------  SCU_CLK_CGATCLR0  ------------------------------ */
#define SCU_CLK_CGATCLR0_VADC_Pos             0                                                       /*!< SCU_CLK CGATCLR0: VADC Position         */
#define SCU_CLK_CGATCLR0_VADC_Msk             (0x01UL << SCU_CLK_CGATCLR0_VADC_Pos)                   /*!< SCU_CLK CGATCLR0: VADC Mask             */
#define SCU_CLK_CGATCLR0_DSD_Pos              1                                                       /*!< SCU_CLK CGATCLR0: DSD Position          */
#define SCU_CLK_CGATCLR0_DSD_Msk              (0x01UL << SCU_CLK_CGATCLR0_DSD_Pos)                    /*!< SCU_CLK CGATCLR0: DSD Mask              */
#define SCU_CLK_CGATCLR0_CCU40_Pos            2                                                       /*!< SCU_CLK CGATCLR0: CCU40 Position        */
#define SCU_CLK_CGATCLR0_CCU40_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU40_Pos)                  /*!< SCU_CLK CGATCLR0: CCU40 Mask            */
#define SCU_CLK_CGATCLR0_CCU41_Pos            3                                                       /*!< SCU_CLK CGATCLR0: CCU41 Position        */
#define SCU_CLK_CGATCLR0_CCU41_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU41_Pos)                  /*!< SCU_CLK CGATCLR0: CCU41 Mask            */
#define SCU_CLK_CGATCLR0_CCU42_Pos            4                                                       /*!< SCU_CLK CGATCLR0: CCU42 Position        */
#define SCU_CLK_CGATCLR0_CCU42_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU42_Pos)                  /*!< SCU_CLK CGATCLR0: CCU42 Mask            */
#define SCU_CLK_CGATCLR0_CCU80_Pos            7                                                       /*!< SCU_CLK CGATCLR0: CCU80 Position        */
#define SCU_CLK_CGATCLR0_CCU80_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU80_Pos)                  /*!< SCU_CLK CGATCLR0: CCU80 Mask            */
#define SCU_CLK_CGATCLR0_CCU81_Pos            8                                                       /*!< SCU_CLK CGATCLR0: CCU81 Position        */
#define SCU_CLK_CGATCLR0_CCU81_Msk            (0x01UL << SCU_CLK_CGATCLR0_CCU81_Pos)                  /*!< SCU_CLK CGATCLR0: CCU81 Mask            */
#define SCU_CLK_CGATCLR0_POSIF0_Pos           9                                                       /*!< SCU_CLK CGATCLR0: POSIF0 Position       */
#define SCU_CLK_CGATCLR0_POSIF0_Msk           (0x01UL << SCU_CLK_CGATCLR0_POSIF0_Pos)                 /*!< SCU_CLK CGATCLR0: POSIF0 Mask           */
#define SCU_CLK_CGATCLR0_POSIF1_Pos           10                                                      /*!< SCU_CLK CGATCLR0: POSIF1 Position       */
#define SCU_CLK_CGATCLR0_POSIF1_Msk           (0x01UL << SCU_CLK_CGATCLR0_POSIF1_Pos)                 /*!< SCU_CLK CGATCLR0: POSIF1 Mask           */
#define SCU_CLK_CGATCLR0_USIC0_Pos            11                                                      /*!< SCU_CLK CGATCLR0: USIC0 Position        */
#define SCU_CLK_CGATCLR0_USIC0_Msk            (0x01UL << SCU_CLK_CGATCLR0_USIC0_Pos)                  /*!< SCU_CLK CGATCLR0: USIC0 Mask            */
#define SCU_CLK_CGATCLR0_ERU1_Pos             16                                                      /*!< SCU_CLK CGATCLR0: ERU1 Position         */
#define SCU_CLK_CGATCLR0_ERU1_Msk             (0x01UL << SCU_CLK_CGATCLR0_ERU1_Pos)                   /*!< SCU_CLK CGATCLR0: ERU1 Mask             */
#define SCU_CLK_CGATCLR0_HRPWM0_Pos           23                                                      /*!< SCU_CLK CGATCLR0: HRPWM0 Position       */
#define SCU_CLK_CGATCLR0_HRPWM0_Msk           (0x01UL << SCU_CLK_CGATCLR0_HRPWM0_Pos)                 /*!< SCU_CLK CGATCLR0: HRPWM0 Mask           */

/* ------------------------------  SCU_CLK_CGATSTAT1  ----------------------------- */
#define SCU_CLK_CGATSTAT1_CCU43_Pos           0                                                       /*!< SCU_CLK CGATSTAT1: CCU43 Position       */
#define SCU_CLK_CGATSTAT1_CCU43_Msk           (0x01UL << SCU_CLK_CGATSTAT1_CCU43_Pos)                 /*!< SCU_CLK CGATSTAT1: CCU43 Mask           */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Pos        3                                                       /*!< SCU_CLK CGATSTAT1: LEDTSCU0 Position    */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Msk        (0x01UL << SCU_CLK_CGATSTAT1_LEDTSCU0_Pos)              /*!< SCU_CLK CGATSTAT1: LEDTSCU0 Mask        */
#define SCU_CLK_CGATSTAT1_MCAN0_Pos           4                                                       /*!< SCU_CLK CGATSTAT1: MCAN0 Position       */
#define SCU_CLK_CGATSTAT1_MCAN0_Msk           (0x01UL << SCU_CLK_CGATSTAT1_MCAN0_Pos)                 /*!< SCU_CLK CGATSTAT1: MCAN0 Mask           */
#define SCU_CLK_CGATSTAT1_DAC_Pos             5                                                       /*!< SCU_CLK CGATSTAT1: DAC Position         */
#define SCU_CLK_CGATSTAT1_DAC_Msk             (0x01UL << SCU_CLK_CGATSTAT1_DAC_Pos)                   /*!< SCU_CLK CGATSTAT1: DAC Mask             */
#define SCU_CLK_CGATSTAT1_USIC1_Pos           7                                                       /*!< SCU_CLK CGATSTAT1: USIC1 Position       */
#define SCU_CLK_CGATSTAT1_USIC1_Msk           (0x01UL << SCU_CLK_CGATSTAT1_USIC1_Pos)                 /*!< SCU_CLK CGATSTAT1: USIC1 Mask           */
#define SCU_CLK_CGATSTAT1_PPORTS_Pos          9                                                       /*!< SCU_CLK CGATSTAT1: PPORTS Position      */
#define SCU_CLK_CGATSTAT1_PPORTS_Msk          (0x01UL << SCU_CLK_CGATSTAT1_PPORTS_Pos)                /*!< SCU_CLK CGATSTAT1: PPORTS Mask          */

/* ------------------------------  SCU_CLK_CGATSET1  ------------------------------ */
#define SCU_CLK_CGATSET1_CCU43_Pos            0                                                       /*!< SCU_CLK CGATSET1: CCU43 Position        */
#define SCU_CLK_CGATSET1_CCU43_Msk            (0x01UL << SCU_CLK_CGATSET1_CCU43_Pos)                  /*!< SCU_CLK CGATSET1: CCU43 Mask            */
#define SCU_CLK_CGATSET1_LEDTSCU0_Pos         3                                                       /*!< SCU_CLK CGATSET1: LEDTSCU0 Position     */
#define SCU_CLK_CGATSET1_LEDTSCU0_Msk         (0x01UL << SCU_CLK_CGATSET1_LEDTSCU0_Pos)               /*!< SCU_CLK CGATSET1: LEDTSCU0 Mask         */
#define SCU_CLK_CGATSET1_MCAN0_Pos            4                                                       /*!< SCU_CLK CGATSET1: MCAN0 Position        */
#define SCU_CLK_CGATSET1_MCAN0_Msk            (0x01UL << SCU_CLK_CGATSET1_MCAN0_Pos)                  /*!< SCU_CLK CGATSET1: MCAN0 Mask            */
#define SCU_CLK_CGATSET1_DAC_Pos              5                                                       /*!< SCU_CLK CGATSET1: DAC Position          */
#define SCU_CLK_CGATSET1_DAC_Msk              (0x01UL << SCU_CLK_CGATSET1_DAC_Pos)                    /*!< SCU_CLK CGATSET1: DAC Mask              */
#define SCU_CLK_CGATSET1_USIC1_Pos            7                                                       /*!< SCU_CLK CGATSET1: USIC1 Position        */
#define SCU_CLK_CGATSET1_USIC1_Msk            (0x01UL << SCU_CLK_CGATSET1_USIC1_Pos)                  /*!< SCU_CLK CGATSET1: USIC1 Mask            */
#define SCU_CLK_CGATSET1_PPORTS_Pos           9                                                       /*!< SCU_CLK CGATSET1: PPORTS Position       */
#define SCU_CLK_CGATSET1_PPORTS_Msk           (0x01UL << SCU_CLK_CGATSET1_PPORTS_Pos)                 /*!< SCU_CLK CGATSET1: PPORTS Mask           */

/* ------------------------------  SCU_CLK_CGATCLR1  ------------------------------ */
#define SCU_CLK_CGATCLR1_CCU43_Pos            0                                                       /*!< SCU_CLK CGATCLR1: CCU43 Position        */
#define SCU_CLK_CGATCLR1_CCU43_Msk            (0x01UL << SCU_CLK_CGATCLR1_CCU43_Pos)                  /*!< SCU_CLK CGATCLR1: CCU43 Mask            */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Pos         3                                                       /*!< SCU_CLK CGATCLR1: LEDTSCU0 Position     */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Msk         (0x01UL << SCU_CLK_CGATCLR1_LEDTSCU0_Pos)               /*!< SCU_CLK CGATCLR1: LEDTSCU0 Mask         */
#define SCU_CLK_CGATCLR1_MCAN0_Pos            4                                                       /*!< SCU_CLK CGATCLR1: MCAN0 Position        */
#define SCU_CLK_CGATCLR1_MCAN0_Msk            (0x01UL << SCU_CLK_CGATCLR1_MCAN0_Pos)                  /*!< SCU_CLK CGATCLR1: MCAN0 Mask            */
#define SCU_CLK_CGATCLR1_DAC_Pos              5                                                       /*!< SCU_CLK CGATCLR1: DAC Position          */
#define SCU_CLK_CGATCLR1_DAC_Msk              (0x01UL << SCU_CLK_CGATCLR1_DAC_Pos)                    /*!< SCU_CLK CGATCLR1: DAC Mask              */
#define SCU_CLK_CGATCLR1_USIC1_Pos            7                                                       /*!< SCU_CLK CGATCLR1: USIC1 Position        */
#define SCU_CLK_CGATCLR1_USIC1_Msk            (0x01UL << SCU_CLK_CGATCLR1_USIC1_Pos)                  /*!< SCU_CLK CGATCLR1: USIC1 Mask            */
#define SCU_CLK_CGATCLR1_PPORTS_Pos           9                                                       /*!< SCU_CLK CGATCLR1: PPORTS Position       */
#define SCU_CLK_CGATCLR1_PPORTS_Msk           (0x01UL << SCU_CLK_CGATCLR1_PPORTS_Pos)                 /*!< SCU_CLK CGATCLR1: PPORTS Mask           */

/* ------------------------------  SCU_CLK_CGATSTAT2  ----------------------------- */
#define SCU_CLK_CGATSTAT2_WDT_Pos             1                                                       /*!< SCU_CLK CGATSTAT2: WDT Position         */
#define SCU_CLK_CGATSTAT2_WDT_Msk             (0x01UL << SCU_CLK_CGATSTAT2_WDT_Pos)                   /*!< SCU_CLK CGATSTAT2: WDT Mask             */
#define SCU_CLK_CGATSTAT2_ETH0_Pos            2                                                       /*!< SCU_CLK CGATSTAT2: ETH0 Position        */
#define SCU_CLK_CGATSTAT2_ETH0_Msk            (0x01UL << SCU_CLK_CGATSTAT2_ETH0_Pos)                  /*!< SCU_CLK CGATSTAT2: ETH0 Mask            */
#define SCU_CLK_CGATSTAT2_DMA0_Pos            4                                                       /*!< SCU_CLK CGATSTAT2: DMA0 Position        */
#define SCU_CLK_CGATSTAT2_DMA0_Msk            (0x01UL << SCU_CLK_CGATSTAT2_DMA0_Pos)                  /*!< SCU_CLK CGATSTAT2: DMA0 Mask            */
#define SCU_CLK_CGATSTAT2_FCE_Pos             6                                                       /*!< SCU_CLK CGATSTAT2: FCE Position         */
#define SCU_CLK_CGATSTAT2_FCE_Msk             (0x01UL << SCU_CLK_CGATSTAT2_FCE_Pos)                   /*!< SCU_CLK CGATSTAT2: FCE Mask             */
#define SCU_CLK_CGATSTAT2_USB_Pos             7                                                       /*!< SCU_CLK CGATSTAT2: USB Position         */
#define SCU_CLK_CGATSTAT2_USB_Msk             (0x01UL << SCU_CLK_CGATSTAT2_USB_Pos)                   /*!< SCU_CLK CGATSTAT2: USB Mask             */

/* ------------------------------  SCU_CLK_CGATSET2  ------------------------------ */
#define SCU_CLK_CGATSET2_WDT_Pos              1                                                       /*!< SCU_CLK CGATSET2: WDT Position          */
#define SCU_CLK_CGATSET2_WDT_Msk              (0x01UL << SCU_CLK_CGATSET2_WDT_Pos)                    /*!< SCU_CLK CGATSET2: WDT Mask              */
#define SCU_CLK_CGATSET2_ETH0_Pos             2                                                       /*!< SCU_CLK CGATSET2: ETH0 Position         */
#define SCU_CLK_CGATSET2_ETH0_Msk             (0x01UL << SCU_CLK_CGATSET2_ETH0_Pos)                   /*!< SCU_CLK CGATSET2: ETH0 Mask             */
#define SCU_CLK_CGATSET2_DMA0_Pos             4                                                       /*!< SCU_CLK CGATSET2: DMA0 Position         */
#define SCU_CLK_CGATSET2_DMA0_Msk             (0x01UL << SCU_CLK_CGATSET2_DMA0_Pos)                   /*!< SCU_CLK CGATSET2: DMA0 Mask             */
#define SCU_CLK_CGATSET2_FCE_Pos              6                                                       /*!< SCU_CLK CGATSET2: FCE Position          */
#define SCU_CLK_CGATSET2_FCE_Msk              (0x01UL << SCU_CLK_CGATSET2_FCE_Pos)                    /*!< SCU_CLK CGATSET2: FCE Mask              */
#define SCU_CLK_CGATSET2_USB_Pos              7                                                       /*!< SCU_CLK CGATSET2: USB Position          */
#define SCU_CLK_CGATSET2_USB_Msk              (0x01UL << SCU_CLK_CGATSET2_USB_Pos)                    /*!< SCU_CLK CGATSET2: USB Mask              */

/* ------------------------------  SCU_CLK_CGATCLR2  ------------------------------ */
#define SCU_CLK_CGATCLR2_WDT_Pos              1                                                       /*!< SCU_CLK CGATCLR2: WDT Position          */
#define SCU_CLK_CGATCLR2_WDT_Msk              (0x01UL << SCU_CLK_CGATCLR2_WDT_Pos)                    /*!< SCU_CLK CGATCLR2: WDT Mask              */
#define SCU_CLK_CGATCLR2_ETH0_Pos             2                                                       /*!< SCU_CLK CGATCLR2: ETH0 Position         */
#define SCU_CLK_CGATCLR2_ETH0_Msk             (0x01UL << SCU_CLK_CGATCLR2_ETH0_Pos)                   /*!< SCU_CLK CGATCLR2: ETH0 Mask             */
#define SCU_CLK_CGATCLR2_DMA0_Pos             4                                                       /*!< SCU_CLK CGATCLR2: DMA0 Position         */
#define SCU_CLK_CGATCLR2_DMA0_Msk             (0x01UL << SCU_CLK_CGATCLR2_DMA0_Pos)                   /*!< SCU_CLK CGATCLR2: DMA0 Mask             */
#define SCU_CLK_CGATCLR2_FCE_Pos              6                                                       /*!< SCU_CLK CGATCLR2: FCE Position          */
#define SCU_CLK_CGATCLR2_FCE_Msk              (0x01UL << SCU_CLK_CGATCLR2_FCE_Pos)                    /*!< SCU_CLK CGATCLR2: FCE Mask              */
#define SCU_CLK_CGATCLR2_USB_Pos              7                                                       /*!< SCU_CLK CGATCLR2: USB Position          */
#define SCU_CLK_CGATCLR2_USB_Msk              (0x01UL << SCU_CLK_CGATCLR2_USB_Pos)                    /*!< SCU_CLK CGATCLR2: USB Mask              */


/* ================================================================================ */
/* ================        struct 'SCU_OSC' Position & Mask        ================ */
/* ================================================================================ */


/* ------------------------------  SCU_OSC_OSCHPSTAT  ----------------------------- */
#define SCU_OSC_OSCHPSTAT_X1D_Pos             0                                                       /*!< SCU_OSC OSCHPSTAT: X1D Position         */
#define SCU_OSC_OSCHPSTAT_X1D_Msk             (0x01UL << SCU_OSC_OSCHPSTAT_X1D_Pos)                   /*!< SCU_OSC OSCHPSTAT: X1D Mask             */

/* ------------------------------  SCU_OSC_OSCHPCTRL  ----------------------------- */
#define SCU_OSC_OSCHPCTRL_X1DEN_Pos           0                                                       /*!< SCU_OSC OSCHPCTRL: X1DEN Position       */
#define SCU_OSC_OSCHPCTRL_X1DEN_Msk           (0x01UL << SCU_OSC_OSCHPCTRL_X1DEN_Pos)                 /*!< SCU_OSC OSCHPCTRL: X1DEN Mask           */
#define SCU_OSC_OSCHPCTRL_SHBY_Pos            1                                                       /*!< SCU_OSC OSCHPCTRL: SHBY Position        */
#define SCU_OSC_OSCHPCTRL_SHBY_Msk            (0x01UL << SCU_OSC_OSCHPCTRL_SHBY_Pos)                  /*!< SCU_OSC OSCHPCTRL: SHBY Mask            */
#define SCU_OSC_OSCHPCTRL_MODE_Pos            4                                                       /*!< SCU_OSC OSCHPCTRL: MODE Position        */
#define SCU_OSC_OSCHPCTRL_MODE_Msk            (0x03UL << SCU_OSC_OSCHPCTRL_MODE_Pos)                  /*!< SCU_OSC OSCHPCTRL: MODE Mask            */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Pos          16                                                      /*!< SCU_OSC OSCHPCTRL: OSCVAL Position      */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Msk          (0x1fUL << SCU_OSC_OSCHPCTRL_OSCVAL_Pos)                /*!< SCU_OSC OSCHPCTRL: OSCVAL Mask          */

/* -----------------------------  SCU_OSC_CLKCALCONST  ---------------------------- */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Pos    0                                                       /*!< SCU_OSC CLKCALCONST: CALIBCONST Position */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Msk    (0x0fUL << SCU_OSC_CLKCALCONST_CALIBCONST_Pos)          /*!< SCU_OSC CLKCALCONST: CALIBCONST Mask    */


/* ================================================================================ */
/* ================        struct 'SCU_PLL' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PLL_PLLSTAT  ------------------------------ */
#define SCU_PLL_PLLSTAT_VCOBYST_Pos           0                                                       /*!< SCU_PLL PLLSTAT: VCOBYST Position       */
#define SCU_PLL_PLLSTAT_VCOBYST_Msk           (0x01UL << SCU_PLL_PLLSTAT_VCOBYST_Pos)                 /*!< SCU_PLL PLLSTAT: VCOBYST Mask           */
#define SCU_PLL_PLLSTAT_PWDSTAT_Pos           1                                                       /*!< SCU_PLL PLLSTAT: PWDSTAT Position       */
#define SCU_PLL_PLLSTAT_PWDSTAT_Msk           (0x01UL << SCU_PLL_PLLSTAT_PWDSTAT_Pos)                 /*!< SCU_PLL PLLSTAT: PWDSTAT Mask           */
#define SCU_PLL_PLLSTAT_VCOLOCK_Pos           2                                                       /*!< SCU_PLL PLLSTAT: VCOLOCK Position       */
#define SCU_PLL_PLLSTAT_VCOLOCK_Msk           (0x01UL << SCU_PLL_PLLSTAT_VCOLOCK_Pos)                 /*!< SCU_PLL PLLSTAT: VCOLOCK Mask           */
#define SCU_PLL_PLLSTAT_K1RDY_Pos             4                                                       /*!< SCU_PLL PLLSTAT: K1RDY Position         */
#define SCU_PLL_PLLSTAT_K1RDY_Msk             (0x01UL << SCU_PLL_PLLSTAT_K1RDY_Pos)                   /*!< SCU_PLL PLLSTAT: K1RDY Mask             */
#define SCU_PLL_PLLSTAT_K2RDY_Pos             5                                                       /*!< SCU_PLL PLLSTAT: K2RDY Position         */
#define SCU_PLL_PLLSTAT_K2RDY_Msk             (0x01UL << SCU_PLL_PLLSTAT_K2RDY_Pos)                   /*!< SCU_PLL PLLSTAT: K2RDY Mask             */
#define SCU_PLL_PLLSTAT_BY_Pos                6                                                       /*!< SCU_PLL PLLSTAT: BY Position            */
#define SCU_PLL_PLLSTAT_BY_Msk                (0x01UL << SCU_PLL_PLLSTAT_BY_Pos)                      /*!< SCU_PLL PLLSTAT: BY Mask                */
#define SCU_PLL_PLLSTAT_PLLLV_Pos             7                                                       /*!< SCU_PLL PLLSTAT: PLLLV Position         */
#define SCU_PLL_PLLSTAT_PLLLV_Msk             (0x01UL << SCU_PLL_PLLSTAT_PLLLV_Pos)                   /*!< SCU_PLL PLLSTAT: PLLLV Mask             */
#define SCU_PLL_PLLSTAT_PLLHV_Pos             8                                                       /*!< SCU_PLL PLLSTAT: PLLHV Position         */
#define SCU_PLL_PLLSTAT_PLLHV_Msk             (0x01UL << SCU_PLL_PLLSTAT_PLLHV_Pos)                   /*!< SCU_PLL PLLSTAT: PLLHV Mask             */
#define SCU_PLL_PLLSTAT_PLLSP_Pos             9                                                       /*!< SCU_PLL PLLSTAT: PLLSP Position         */
#define SCU_PLL_PLLSTAT_PLLSP_Msk             (0x01UL << SCU_PLL_PLLSTAT_PLLSP_Pos)                   /*!< SCU_PLL PLLSTAT: PLLSP Mask             */

/* -------------------------------  SCU_PLL_PLLCON0  ------------------------------ */
#define SCU_PLL_PLLCON0_VCOBYP_Pos            0                                                       /*!< SCU_PLL PLLCON0: VCOBYP Position        */
#define SCU_PLL_PLLCON0_VCOBYP_Msk            (0x01UL << SCU_PLL_PLLCON0_VCOBYP_Pos)                  /*!< SCU_PLL PLLCON0: VCOBYP Mask            */
#define SCU_PLL_PLLCON0_VCOPWD_Pos            1                                                       /*!< SCU_PLL PLLCON0: VCOPWD Position        */
#define SCU_PLL_PLLCON0_VCOPWD_Msk            (0x01UL << SCU_PLL_PLLCON0_VCOPWD_Pos)                  /*!< SCU_PLL PLLCON0: VCOPWD Mask            */
#define SCU_PLL_PLLCON0_VCOTR_Pos             2                                                       /*!< SCU_PLL PLLCON0: VCOTR Position         */
#define SCU_PLL_PLLCON0_VCOTR_Msk             (0x01UL << SCU_PLL_PLLCON0_VCOTR_Pos)                   /*!< SCU_PLL PLLCON0: VCOTR Mask             */
#define SCU_PLL_PLLCON0_FINDIS_Pos            4                                                       /*!< SCU_PLL PLLCON0: FINDIS Position        */
#define SCU_PLL_PLLCON0_FINDIS_Msk            (0x01UL << SCU_PLL_PLLCON0_FINDIS_Pos)                  /*!< SCU_PLL PLLCON0: FINDIS Mask            */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Pos        6                                                       /*!< SCU_PLL PLLCON0: OSCDISCDIS Position    */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Msk        (0x01UL << SCU_PLL_PLLCON0_OSCDISCDIS_Pos)              /*!< SCU_PLL PLLCON0: OSCDISCDIS Mask        */
#define SCU_PLL_PLLCON0_PLLPWD_Pos            16                                                      /*!< SCU_PLL PLLCON0: PLLPWD Position        */
#define SCU_PLL_PLLCON0_PLLPWD_Msk            (0x01UL << SCU_PLL_PLLCON0_PLLPWD_Pos)                  /*!< SCU_PLL PLLCON0: PLLPWD Mask            */
#define SCU_PLL_PLLCON0_OSCRES_Pos            17                                                      /*!< SCU_PLL PLLCON0: OSCRES Position        */
#define SCU_PLL_PLLCON0_OSCRES_Msk            (0x01UL << SCU_PLL_PLLCON0_OSCRES_Pos)                  /*!< SCU_PLL PLLCON0: OSCRES Mask            */
#define SCU_PLL_PLLCON0_RESLD_Pos             18                                                      /*!< SCU_PLL PLLCON0: RESLD Position         */
#define SCU_PLL_PLLCON0_RESLD_Msk             (0x01UL << SCU_PLL_PLLCON0_RESLD_Pos)                   /*!< SCU_PLL PLLCON0: RESLD Mask             */
#define SCU_PLL_PLLCON0_AOTREN_Pos            19                                                      /*!< SCU_PLL PLLCON0: AOTREN Position        */
#define SCU_PLL_PLLCON0_AOTREN_Msk            (0x01UL << SCU_PLL_PLLCON0_AOTREN_Pos)                  /*!< SCU_PLL PLLCON0: AOTREN Mask            */
#define SCU_PLL_PLLCON0_FOTR_Pos              20                                                      /*!< SCU_PLL PLLCON0: FOTR Position          */
#define SCU_PLL_PLLCON0_FOTR_Msk              (0x01UL << SCU_PLL_PLLCON0_FOTR_Pos)                    /*!< SCU_PLL PLLCON0: FOTR Mask              */

/* -------------------------------  SCU_PLL_PLLCON1  ------------------------------ */
#define SCU_PLL_PLLCON1_K1DIV_Pos             0                                                       /*!< SCU_PLL PLLCON1: K1DIV Position         */
#define SCU_PLL_PLLCON1_K1DIV_Msk             (0x7fUL << SCU_PLL_PLLCON1_K1DIV_Pos)                   /*!< SCU_PLL PLLCON1: K1DIV Mask             */
#define SCU_PLL_PLLCON1_NDIV_Pos              8                                                       /*!< SCU_PLL PLLCON1: NDIV Position          */
#define SCU_PLL_PLLCON1_NDIV_Msk              (0x7fUL << SCU_PLL_PLLCON1_NDIV_Pos)                    /*!< SCU_PLL PLLCON1: NDIV Mask              */
#define SCU_PLL_PLLCON1_K2DIV_Pos             16                                                      /*!< SCU_PLL PLLCON1: K2DIV Position         */
#define SCU_PLL_PLLCON1_K2DIV_Msk             (0x7fUL << SCU_PLL_PLLCON1_K2DIV_Pos)                   /*!< SCU_PLL PLLCON1: K2DIV Mask             */
#define SCU_PLL_PLLCON1_PDIV_Pos              24                                                      /*!< SCU_PLL PLLCON1: PDIV Position          */
#define SCU_PLL_PLLCON1_PDIV_Msk              (0x0fUL << SCU_PLL_PLLCON1_PDIV_Pos)                    /*!< SCU_PLL PLLCON1: PDIV Mask              */

/* -------------------------------  SCU_PLL_PLLCON2  ------------------------------ */
#define SCU_PLL_PLLCON2_PINSEL_Pos            0                                                       /*!< SCU_PLL PLLCON2: PINSEL Position        */
#define SCU_PLL_PLLCON2_PINSEL_Msk            (0x01UL << SCU_PLL_PLLCON2_PINSEL_Pos)                  /*!< SCU_PLL PLLCON2: PINSEL Mask            */
#define SCU_PLL_PLLCON2_K1INSEL_Pos           8                                                       /*!< SCU_PLL PLLCON2: K1INSEL Position       */
#define SCU_PLL_PLLCON2_K1INSEL_Msk           (0x01UL << SCU_PLL_PLLCON2_K1INSEL_Pos)                 /*!< SCU_PLL PLLCON2: K1INSEL Mask           */

/* -----------------------------  SCU_PLL_USBPLLSTAT  ----------------------------- */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Pos        0                                                       /*!< SCU_PLL USBPLLSTAT: VCOBYST Position    */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Msk        (0x01UL << SCU_PLL_USBPLLSTAT_VCOBYST_Pos)              /*!< SCU_PLL USBPLLSTAT: VCOBYST Mask        */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Pos        1                                                       /*!< SCU_PLL USBPLLSTAT: PWDSTAT Position    */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Msk        (0x01UL << SCU_PLL_USBPLLSTAT_PWDSTAT_Pos)              /*!< SCU_PLL USBPLLSTAT: PWDSTAT Mask        */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Pos        2                                                       /*!< SCU_PLL USBPLLSTAT: VCOLOCK Position    */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Msk        (0x01UL << SCU_PLL_USBPLLSTAT_VCOLOCK_Pos)              /*!< SCU_PLL USBPLLSTAT: VCOLOCK Mask        */
#define SCU_PLL_USBPLLSTAT_BY_Pos             6                                                       /*!< SCU_PLL USBPLLSTAT: BY Position         */
#define SCU_PLL_USBPLLSTAT_BY_Msk             (0x01UL << SCU_PLL_USBPLLSTAT_BY_Pos)                   /*!< SCU_PLL USBPLLSTAT: BY Mask             */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Pos      7                                                       /*!< SCU_PLL USBPLLSTAT: VCOLOCKED Position  */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Msk      (0x01UL << SCU_PLL_USBPLLSTAT_VCOLOCKED_Pos)            /*!< SCU_PLL USBPLLSTAT: VCOLOCKED Mask      */

/* ------------------------------  SCU_PLL_USBPLLCON  ----------------------------- */
#define SCU_PLL_USBPLLCON_VCOBYP_Pos          0                                                       /*!< SCU_PLL USBPLLCON: VCOBYP Position      */
#define SCU_PLL_USBPLLCON_VCOBYP_Msk          (0x01UL << SCU_PLL_USBPLLCON_VCOBYP_Pos)                /*!< SCU_PLL USBPLLCON: VCOBYP Mask          */
#define SCU_PLL_USBPLLCON_VCOPWD_Pos          1                                                       /*!< SCU_PLL USBPLLCON: VCOPWD Position      */
#define SCU_PLL_USBPLLCON_VCOPWD_Msk          (0x01UL << SCU_PLL_USBPLLCON_VCOPWD_Pos)                /*!< SCU_PLL USBPLLCON: VCOPWD Mask          */
#define SCU_PLL_USBPLLCON_VCOTR_Pos           2                                                       /*!< SCU_PLL USBPLLCON: VCOTR Position       */
#define SCU_PLL_USBPLLCON_VCOTR_Msk           (0x01UL << SCU_PLL_USBPLLCON_VCOTR_Pos)                 /*!< SCU_PLL USBPLLCON: VCOTR Mask           */
#define SCU_PLL_USBPLLCON_FINDIS_Pos          4                                                       /*!< SCU_PLL USBPLLCON: FINDIS Position      */
#define SCU_PLL_USBPLLCON_FINDIS_Msk          (0x01UL << SCU_PLL_USBPLLCON_FINDIS_Pos)                /*!< SCU_PLL USBPLLCON: FINDIS Mask          */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Pos      6                                                       /*!< SCU_PLL USBPLLCON: OSCDISCDIS Position  */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Msk      (0x01UL << SCU_PLL_USBPLLCON_OSCDISCDIS_Pos)            /*!< SCU_PLL USBPLLCON: OSCDISCDIS Mask      */
#define SCU_PLL_USBPLLCON_NDIV_Pos            8                                                       /*!< SCU_PLL USBPLLCON: NDIV Position        */
#define SCU_PLL_USBPLLCON_NDIV_Msk            (0x7fUL << SCU_PLL_USBPLLCON_NDIV_Pos)                  /*!< SCU_PLL USBPLLCON: NDIV Mask            */
#define SCU_PLL_USBPLLCON_PLLPWD_Pos          16                                                      /*!< SCU_PLL USBPLLCON: PLLPWD Position      */
#define SCU_PLL_USBPLLCON_PLLPWD_Msk          (0x01UL << SCU_PLL_USBPLLCON_PLLPWD_Pos)                /*!< SCU_PLL USBPLLCON: PLLPWD Mask          */
#define SCU_PLL_USBPLLCON_RESLD_Pos           18                                                      /*!< SCU_PLL USBPLLCON: RESLD Position       */
#define SCU_PLL_USBPLLCON_RESLD_Msk           (0x01UL << SCU_PLL_USBPLLCON_RESLD_Pos)                 /*!< SCU_PLL USBPLLCON: RESLD Mask           */
#define SCU_PLL_USBPLLCON_PDIV_Pos            24                                                      /*!< SCU_PLL USBPLLCON: PDIV Position        */
#define SCU_PLL_USBPLLCON_PDIV_Msk            (0x0fUL << SCU_PLL_USBPLLCON_PDIV_Pos)                  /*!< SCU_PLL USBPLLCON: PDIV Mask            */

/* ------------------------------  SCU_PLL_CLKMXSTAT  ----------------------------- */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Pos       0                                                       /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX Position   */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Msk       (0x03UL << SCU_PLL_CLKMXSTAT_SYSCLKMUX_Pos)             /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX Mask       */


/* ================================================================================ */
/* ================      struct 'SCU_GENERAL' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_GENERAL_ID  ------------------------------- */
#define SCU_GENERAL_ID_MOD_REV_Pos            0                                                       /*!< SCU_GENERAL ID: MOD_REV Position        */
#define SCU_GENERAL_ID_MOD_REV_Msk            (0x000000ffUL << SCU_GENERAL_ID_MOD_REV_Pos)            /*!< SCU_GENERAL ID: MOD_REV Mask            */
#define SCU_GENERAL_ID_MOD_TYPE_Pos           8                                                       /*!< SCU_GENERAL ID: MOD_TYPE Position       */
#define SCU_GENERAL_ID_MOD_TYPE_Msk           (0x000000ffUL << SCU_GENERAL_ID_MOD_TYPE_Pos)           /*!< SCU_GENERAL ID: MOD_TYPE Mask           */
#define SCU_GENERAL_ID_MOD_NUMBER_Pos         16                                                      /*!< SCU_GENERAL ID: MOD_NUMBER Position     */
#define SCU_GENERAL_ID_MOD_NUMBER_Msk         (0x0000ffffUL << SCU_GENERAL_ID_MOD_NUMBER_Pos)         /*!< SCU_GENERAL ID: MOD_NUMBER Mask         */

/* -----------------------------  SCU_GENERAL_IDCHIP  ----------------------------- */
#define SCU_GENERAL_IDCHIP_IDCHIP_Pos         0                                                       /*!< SCU_GENERAL IDCHIP: IDCHIP Position     */
#define SCU_GENERAL_IDCHIP_IDCHIP_Msk         (0xffffffffUL << SCU_GENERAL_IDCHIP_IDCHIP_Pos)         /*!< SCU_GENERAL IDCHIP: IDCHIP Mask         */

/* -----------------------------  SCU_GENERAL_IDMANUF  ---------------------------- */
#define SCU_GENERAL_IDMANUF_DEPT_Pos          0                                                       /*!< SCU_GENERAL IDMANUF: DEPT Position      */
#define SCU_GENERAL_IDMANUF_DEPT_Msk          (0x1fUL << SCU_GENERAL_IDMANUF_DEPT_Pos)                /*!< SCU_GENERAL IDMANUF: DEPT Mask          */
#define SCU_GENERAL_IDMANUF_MANUF_Pos         5                                                       /*!< SCU_GENERAL IDMANUF: MANUF Position     */
#define SCU_GENERAL_IDMANUF_MANUF_Msk         (0x000007ffUL << SCU_GENERAL_IDMANUF_MANUF_Pos)         /*!< SCU_GENERAL IDMANUF: MANUF Mask         */

/* ------------------------------  SCU_GENERAL_STCON  ----------------------------- */
#define SCU_GENERAL_STCON_HWCON_Pos           0                                                       /*!< SCU_GENERAL STCON: HWCON Position       */
#define SCU_GENERAL_STCON_HWCON_Msk           (0x03UL << SCU_GENERAL_STCON_HWCON_Pos)                 /*!< SCU_GENERAL STCON: HWCON Mask           */
#define SCU_GENERAL_STCON_SWCON_Pos           8                                                       /*!< SCU_GENERAL STCON: SWCON Position       */
#define SCU_GENERAL_STCON_SWCON_Msk           (0x0fUL << SCU_GENERAL_STCON_SWCON_Pos)                 /*!< SCU_GENERAL STCON: SWCON Mask           */

/* -------------------------------  SCU_GENERAL_GPR  ------------------------------ */
#define SCU_GENERAL_GPR_DAT_Pos               0                                                       /*!< SCU_GENERAL GPR: DAT Position           */
#define SCU_GENERAL_GPR_DAT_Msk               (0xffffffffUL << SCU_GENERAL_GPR_DAT_Pos)               /*!< SCU_GENERAL GPR: DAT Mask               */

/* -----------------------------  SCU_GENERAL_CCUCON  ----------------------------- */
#define SCU_GENERAL_CCUCON_GSC40_Pos          0                                                       /*!< SCU_GENERAL CCUCON: GSC40 Position      */
#define SCU_GENERAL_CCUCON_GSC40_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC40_Pos)                /*!< SCU_GENERAL CCUCON: GSC40 Mask          */
#define SCU_GENERAL_CCUCON_GSC41_Pos          1                                                       /*!< SCU_GENERAL CCUCON: GSC41 Position      */
#define SCU_GENERAL_CCUCON_GSC41_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC41_Pos)                /*!< SCU_GENERAL CCUCON: GSC41 Mask          */
#define SCU_GENERAL_CCUCON_GSC42_Pos          2                                                       /*!< SCU_GENERAL CCUCON: GSC42 Position      */
#define SCU_GENERAL_CCUCON_GSC42_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC42_Pos)                /*!< SCU_GENERAL CCUCON: GSC42 Mask          */
#define SCU_GENERAL_CCUCON_GSC43_Pos          3                                                       /*!< SCU_GENERAL CCUCON: GSC43 Position      */
#define SCU_GENERAL_CCUCON_GSC43_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC43_Pos)                /*!< SCU_GENERAL CCUCON: GSC43 Mask          */
#define SCU_GENERAL_CCUCON_GSC80_Pos          8                                                       /*!< SCU_GENERAL CCUCON: GSC80 Position      */
#define SCU_GENERAL_CCUCON_GSC80_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC80_Pos)                /*!< SCU_GENERAL CCUCON: GSC80 Mask          */
#define SCU_GENERAL_CCUCON_GSC81_Pos          9                                                       /*!< SCU_GENERAL CCUCON: GSC81 Position      */
#define SCU_GENERAL_CCUCON_GSC81_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSC81_Pos)                /*!< SCU_GENERAL CCUCON: GSC81 Mask          */
#define SCU_GENERAL_CCUCON_GSHR0_Pos          24                                                      /*!< SCU_GENERAL CCUCON: GSHR0 Position      */
#define SCU_GENERAL_CCUCON_GSHR0_Msk          (0x01UL << SCU_GENERAL_CCUCON_GSHR0_Pos)                /*!< SCU_GENERAL CCUCON: GSHR0 Mask          */

/* -----------------------------  SCU_GENERAL_DTSCON  ----------------------------- */
#define SCU_GENERAL_DTSCON_PWD_Pos            0                                                       /*!< SCU_GENERAL DTSCON: PWD Position        */
#define SCU_GENERAL_DTSCON_PWD_Msk            (0x01UL << SCU_GENERAL_DTSCON_PWD_Pos)                  /*!< SCU_GENERAL DTSCON: PWD Mask            */
#define SCU_GENERAL_DTSCON_START_Pos          1                                                       /*!< SCU_GENERAL DTSCON: START Position      */
#define SCU_GENERAL_DTSCON_START_Msk          (0x01UL << SCU_GENERAL_DTSCON_START_Pos)                /*!< SCU_GENERAL DTSCON: START Mask          */
#define SCU_GENERAL_DTSCON_OFFSET_Pos         4                                                       /*!< SCU_GENERAL DTSCON: OFFSET Position     */
#define SCU_GENERAL_DTSCON_OFFSET_Msk         (0x7fUL << SCU_GENERAL_DTSCON_OFFSET_Pos)               /*!< SCU_GENERAL DTSCON: OFFSET Mask         */
#define SCU_GENERAL_DTSCON_GAIN_Pos           11                                                      /*!< SCU_GENERAL DTSCON: GAIN Position       */
#define SCU_GENERAL_DTSCON_GAIN_Msk           (0x3fUL << SCU_GENERAL_DTSCON_GAIN_Pos)                 /*!< SCU_GENERAL DTSCON: GAIN Mask           */
#define SCU_GENERAL_DTSCON_REFTRIM_Pos        17                                                      /*!< SCU_GENERAL DTSCON: REFTRIM Position    */
#define SCU_GENERAL_DTSCON_REFTRIM_Msk        (0x07UL << SCU_GENERAL_DTSCON_REFTRIM_Pos)              /*!< SCU_GENERAL DTSCON: REFTRIM Mask        */
#define SCU_GENERAL_DTSCON_BGTRIM_Pos         20                                                      /*!< SCU_GENERAL DTSCON: BGTRIM Position     */
#define SCU_GENERAL_DTSCON_BGTRIM_Msk         (0x0fUL << SCU_GENERAL_DTSCON_BGTRIM_Pos)               /*!< SCU_GENERAL DTSCON: BGTRIM Mask         */

/* -----------------------------  SCU_GENERAL_DTSSTAT  ---------------------------- */
#define SCU_GENERAL_DTSSTAT_RESULT_Pos        0                                                       /*!< SCU_GENERAL DTSSTAT: RESULT Position    */
#define SCU_GENERAL_DTSSTAT_RESULT_Msk        (0x000003ffUL << SCU_GENERAL_DTSSTAT_RESULT_Pos)        /*!< SCU_GENERAL DTSSTAT: RESULT Mask        */
#define SCU_GENERAL_DTSSTAT_RDY_Pos           14                                                      /*!< SCU_GENERAL DTSSTAT: RDY Position       */
#define SCU_GENERAL_DTSSTAT_RDY_Msk           (0x01UL << SCU_GENERAL_DTSSTAT_RDY_Pos)                 /*!< SCU_GENERAL DTSSTAT: RDY Mask           */
#define SCU_GENERAL_DTSSTAT_BUSY_Pos          15                                                      /*!< SCU_GENERAL DTSSTAT: BUSY Position      */
#define SCU_GENERAL_DTSSTAT_BUSY_Msk          (0x01UL << SCU_GENERAL_DTSSTAT_BUSY_Pos)                /*!< SCU_GENERAL DTSSTAT: BUSY Mask          */

/* -----------------------------  SCU_GENERAL_GORCEN  ----------------------------- */
#define SCU_GENERAL_GORCEN_ENORC6_Pos         6                                                       /*!< SCU_GENERAL GORCEN: ENORC6 Position     */
#define SCU_GENERAL_GORCEN_ENORC6_Msk         (0x01UL << SCU_GENERAL_GORCEN_ENORC6_Pos)               /*!< SCU_GENERAL GORCEN: ENORC6 Mask         */
#define SCU_GENERAL_GORCEN_ENORC7_Pos         7                                                       /*!< SCU_GENERAL GORCEN: ENORC7 Position     */
#define SCU_GENERAL_GORCEN_ENORC7_Msk         (0x01UL << SCU_GENERAL_GORCEN_ENORC7_Pos)               /*!< SCU_GENERAL GORCEN: ENORC7 Mask         */

/* ----------------------------  SCU_GENERAL_DTEMPLIM  ---------------------------- */
#define SCU_GENERAL_DTEMPLIM_LOWER_Pos        0                                                       /*!< SCU_GENERAL DTEMPLIM: LOWER Position    */
#define SCU_GENERAL_DTEMPLIM_LOWER_Msk        (0x000003ffUL << SCU_GENERAL_DTEMPLIM_LOWER_Pos)        /*!< SCU_GENERAL DTEMPLIM: LOWER Mask        */
#define SCU_GENERAL_DTEMPLIM_UPPER_Pos        16                                                      /*!< SCU_GENERAL DTEMPLIM: UPPER Position    */
#define SCU_GENERAL_DTEMPLIM_UPPER_Msk        (0x000003ffUL << SCU_GENERAL_DTEMPLIM_UPPER_Pos)        /*!< SCU_GENERAL DTEMPLIM: UPPER Mask        */

/* ---------------------------  SCU_GENERAL_DTEMPALARM  --------------------------- */
#define SCU_GENERAL_DTEMPALARM_UNDERFL_Pos    0                                                       /*!< SCU_GENERAL DTEMPALARM: UNDERFL Position */
#define SCU_GENERAL_DTEMPALARM_UNDERFL_Msk    (0x01UL << SCU_GENERAL_DTEMPALARM_UNDERFL_Pos)          /*!< SCU_GENERAL DTEMPALARM: UNDERFL Mask    */
#define SCU_GENERAL_DTEMPALARM_OVERFL_Pos     16                                                      /*!< SCU_GENERAL DTEMPALARM: OVERFL Position */
#define SCU_GENERAL_DTEMPALARM_OVERFL_Msk     (0x01UL << SCU_GENERAL_DTEMPALARM_OVERFL_Pos)           /*!< SCU_GENERAL DTEMPALARM: OVERFL Mask     */

/* -----------------------------  SCU_GENERAL_MIRRSTS  ---------------------------- */
#define SCU_GENERAL_MIRRSTS_HDCLR_Pos         1                                                       /*!< SCU_GENERAL MIRRSTS: HDCLR Position     */
#define SCU_GENERAL_MIRRSTS_HDCLR_Msk         (0x01UL << SCU_GENERAL_MIRRSTS_HDCLR_Pos)               /*!< SCU_GENERAL MIRRSTS: HDCLR Mask         */
#define SCU_GENERAL_MIRRSTS_HDSET_Pos         2                                                       /*!< SCU_GENERAL MIRRSTS: HDSET Position     */
#define SCU_GENERAL_MIRRSTS_HDSET_Msk         (0x01UL << SCU_GENERAL_MIRRSTS_HDSET_Pos)               /*!< SCU_GENERAL MIRRSTS: HDSET Mask         */
#define SCU_GENERAL_MIRRSTS_HDCR_Pos          3                                                       /*!< SCU_GENERAL MIRRSTS: HDCR Position      */
#define SCU_GENERAL_MIRRSTS_HDCR_Msk          (0x01UL << SCU_GENERAL_MIRRSTS_HDCR_Pos)                /*!< SCU_GENERAL MIRRSTS: HDCR Mask          */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Pos     5                                                       /*!< SCU_GENERAL MIRRSTS: OSCSICTRL Position */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_OSCSICTRL_Pos)           /*!< SCU_GENERAL MIRRSTS: OSCSICTRL Mask     */
#define SCU_GENERAL_MIRRSTS_OSCULSTAT_Pos     6                                                       /*!< SCU_GENERAL MIRRSTS: OSCULSTAT Position */
#define SCU_GENERAL_MIRRSTS_OSCULSTAT_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_OSCULSTAT_Pos)           /*!< SCU_GENERAL MIRRSTS: OSCULSTAT Mask     */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Pos     7                                                       /*!< SCU_GENERAL MIRRSTS: OSCULCTRL Position */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_OSCULCTRL_Pos)           /*!< SCU_GENERAL MIRRSTS: OSCULCTRL Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Pos       8                                                       /*!< SCU_GENERAL MIRRSTS: RTC_CTR Position   */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_RTC_CTR_Pos)             /*!< SCU_GENERAL MIRRSTS: RTC_CTR Mask       */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Pos     9                                                       /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 Position */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_ATIM0_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Pos     10                                                      /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 Position */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_ATIM1_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Pos      11                                                      /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 Position  */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Msk      (0x01UL << SCU_GENERAL_MIRRSTS_RTC_TIM0_Pos)            /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 Mask      */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Pos      12                                                      /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 Position  */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Msk      (0x01UL << SCU_GENERAL_MIRRSTS_RTC_TIM1_Pos)            /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 Mask      */
#define SCU_GENERAL_MIRRSTS_RMX_Pos           13                                                      /*!< SCU_GENERAL MIRRSTS: RMX Position       */
#define SCU_GENERAL_MIRRSTS_RMX_Msk           (0x01UL << SCU_GENERAL_MIRRSTS_RMX_Pos)                 /*!< SCU_GENERAL MIRRSTS: RMX Mask           */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Pos     14                                                      /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR Position */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_MSKSR_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR Mask     */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Pos     15                                                      /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR Position */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Msk     (0x01UL << SCU_GENERAL_MIRRSTS_RTC_CLRSR_Pos)           /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR Mask     */
#define SCU_GENERAL_MIRRSTS_LPACCONF_Pos      16                                                      /*!< SCU_GENERAL MIRRSTS: LPACCONF Position  */
#define SCU_GENERAL_MIRRSTS_LPACCONF_Msk      (0x01UL << SCU_GENERAL_MIRRSTS_LPACCONF_Pos)            /*!< SCU_GENERAL MIRRSTS: LPACCONF Mask      */
#define SCU_GENERAL_MIRRSTS_LPACTH0_Pos       17                                                      /*!< SCU_GENERAL MIRRSTS: LPACTH0 Position   */
#define SCU_GENERAL_MIRRSTS_LPACTH0_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_LPACTH0_Pos)             /*!< SCU_GENERAL MIRRSTS: LPACTH0 Mask       */
#define SCU_GENERAL_MIRRSTS_LPACTH1_Pos       18                                                      /*!< SCU_GENERAL MIRRSTS: LPACTH1 Position   */
#define SCU_GENERAL_MIRRSTS_LPACTH1_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_LPACTH1_Pos)             /*!< SCU_GENERAL MIRRSTS: LPACTH1 Mask       */
#define SCU_GENERAL_MIRRSTS_LPACCLR_Pos       20                                                      /*!< SCU_GENERAL MIRRSTS: LPACCLR Position   */
#define SCU_GENERAL_MIRRSTS_LPACCLR_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_LPACCLR_Pos)             /*!< SCU_GENERAL MIRRSTS: LPACCLR Mask       */
#define SCU_GENERAL_MIRRSTS_LPACSET_Pos       21                                                      /*!< SCU_GENERAL MIRRSTS: LPACSET Position   */
#define SCU_GENERAL_MIRRSTS_LPACSET_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_LPACSET_Pos)             /*!< SCU_GENERAL MIRRSTS: LPACSET Mask       */
#define SCU_GENERAL_MIRRSTS_HINTCLR_Pos       23                                                      /*!< SCU_GENERAL MIRRSTS: HINTCLR Position   */
#define SCU_GENERAL_MIRRSTS_HINTCLR_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_HINTCLR_Pos)             /*!< SCU_GENERAL MIRRSTS: HINTCLR Mask       */
#define SCU_GENERAL_MIRRSTS_HINTSET_Pos       24                                                      /*!< SCU_GENERAL MIRRSTS: HINTSET Position   */
#define SCU_GENERAL_MIRRSTS_HINTSET_Msk       (0x01UL << SCU_GENERAL_MIRRSTS_HINTSET_Pos)             /*!< SCU_GENERAL MIRRSTS: HINTSET Mask       */

/* ------------------------------  SCU_GENERAL_RMACR  ----------------------------- */
#define SCU_GENERAL_RMACR_RDWR_Pos            0                                                       /*!< SCU_GENERAL RMACR: RDWR Position        */
#define SCU_GENERAL_RMACR_RDWR_Msk            (0x01UL << SCU_GENERAL_RMACR_RDWR_Pos)                  /*!< SCU_GENERAL RMACR: RDWR Mask            */
#define SCU_GENERAL_RMACR_ADDR_Pos            16                                                      /*!< SCU_GENERAL RMACR: ADDR Position        */
#define SCU_GENERAL_RMACR_ADDR_Msk            (0x0fUL << SCU_GENERAL_RMACR_ADDR_Pos)                  /*!< SCU_GENERAL RMACR: ADDR Mask            */

/* -----------------------------  SCU_GENERAL_RMDATA  ----------------------------- */
#define SCU_GENERAL_RMDATA_DATA_Pos           0                                                       /*!< SCU_GENERAL RMDATA: DATA Position       */
#define SCU_GENERAL_RMDATA_DATA_Msk           (0xffffffffUL << SCU_GENERAL_RMDATA_DATA_Pos)           /*!< SCU_GENERAL RMDATA: DATA Mask           */

/* ---------------------------  SCU_GENERAL_MIRRALLSTAT  -------------------------- */
#define SCU_GENERAL_MIRRALLSTAT_BUSY_Pos      0                                                       /*!< SCU_GENERAL MIRRALLSTAT: BUSY Position  */
#define SCU_GENERAL_MIRRALLSTAT_BUSY_Msk      (0x01UL << SCU_GENERAL_MIRRALLSTAT_BUSY_Pos)            /*!< SCU_GENERAL MIRRALLSTAT: BUSY Mask      */

/* ---------------------------  SCU_GENERAL_MIRRALLREQ  --------------------------- */
#define SCU_GENERAL_MIRRALLREQ_REQ_Pos        0                                                       /*!< SCU_GENERAL MIRRALLREQ: REQ Position    */
#define SCU_GENERAL_MIRRALLREQ_REQ_Msk        (0x01UL << SCU_GENERAL_MIRRALLREQ_REQ_Pos)              /*!< SCU_GENERAL MIRRALLREQ: REQ Mask        */


/* ================================================================================ */
/* ================     struct 'SCU_INTERRUPT' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_INTERRUPT_SRSTAT  ---------------------------- */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Pos       0                                                       /*!< SCU_INTERRUPT SRSTAT: PRWARN Position   */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_PRWARN_Pos)             /*!< SCU_INTERRUPT SRSTAT: PRWARN Mask       */
#define SCU_INTERRUPT_SRSTAT_PI_Pos           1                                                       /*!< SCU_INTERRUPT SRSTAT: PI Position       */
#define SCU_INTERRUPT_SRSTAT_PI_Msk           (0x01UL << SCU_INTERRUPT_SRSTAT_PI_Pos)                 /*!< SCU_INTERRUPT SRSTAT: PI Mask           */
#define SCU_INTERRUPT_SRSTAT_AI_Pos           2                                                       /*!< SCU_INTERRUPT SRSTAT: AI Position       */
#define SCU_INTERRUPT_SRSTAT_AI_Msk           (0x01UL << SCU_INTERRUPT_SRSTAT_AI_Pos)                 /*!< SCU_INTERRUPT SRSTAT: AI Mask           */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Pos       3                                                       /*!< SCU_INTERRUPT SRSTAT: DLROVR Position   */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_DLROVR_Pos)             /*!< SCU_INTERRUPT SRSTAT: DLROVR Mask       */
#define SCU_INTERRUPT_SRSTAT_LPACCR_Pos       6                                                       /*!< SCU_INTERRUPT SRSTAT: LPACCR Position   */
#define SCU_INTERRUPT_SRSTAT_LPACCR_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_LPACCR_Pos)             /*!< SCU_INTERRUPT SRSTAT: LPACCR Mask       */
#define SCU_INTERRUPT_SRSTAT_LPACTH0_Pos      7                                                       /*!< SCU_INTERRUPT SRSTAT: LPACTH0 Position  */
#define SCU_INTERRUPT_SRSTAT_LPACTH0_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_LPACTH0_Pos)            /*!< SCU_INTERRUPT SRSTAT: LPACTH0 Mask      */
#define SCU_INTERRUPT_SRSTAT_LPACTH1_Pos      8                                                       /*!< SCU_INTERRUPT SRSTAT: LPACTH1 Position  */
#define SCU_INTERRUPT_SRSTAT_LPACTH1_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_LPACTH1_Pos)            /*!< SCU_INTERRUPT SRSTAT: LPACTH1 Mask      */
#define SCU_INTERRUPT_SRSTAT_LPACST_Pos       9                                                       /*!< SCU_INTERRUPT SRSTAT: LPACST Position   */
#define SCU_INTERRUPT_SRSTAT_LPACST_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_LPACST_Pos)             /*!< SCU_INTERRUPT SRSTAT: LPACST Mask       */
#define SCU_INTERRUPT_SRSTAT_LPACCLR_Pos      10                                                      /*!< SCU_INTERRUPT SRSTAT: LPACCLR Position  */
#define SCU_INTERRUPT_SRSTAT_LPACCLR_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_LPACCLR_Pos)            /*!< SCU_INTERRUPT SRSTAT: LPACCLR Mask      */
#define SCU_INTERRUPT_SRSTAT_LPACSET_Pos      11                                                      /*!< SCU_INTERRUPT SRSTAT: LPACSET Position  */
#define SCU_INTERRUPT_SRSTAT_LPACSET_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_LPACSET_Pos)            /*!< SCU_INTERRUPT SRSTAT: LPACSET Mask      */
#define SCU_INTERRUPT_SRSTAT_HINTST_Pos       12                                                      /*!< SCU_INTERRUPT SRSTAT: HINTST Position   */
#define SCU_INTERRUPT_SRSTAT_HINTST_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_HINTST_Pos)             /*!< SCU_INTERRUPT SRSTAT: HINTST Mask       */
#define SCU_INTERRUPT_SRSTAT_HINTCLR_Pos      13                                                      /*!< SCU_INTERRUPT SRSTAT: HINTCLR Position  */
#define SCU_INTERRUPT_SRSTAT_HINTCLR_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_HINTCLR_Pos)            /*!< SCU_INTERRUPT SRSTAT: HINTCLR Mask      */
#define SCU_INTERRUPT_SRSTAT_HINTSET_Pos      14                                                      /*!< SCU_INTERRUPT SRSTAT: HINTSET Position  */
#define SCU_INTERRUPT_SRSTAT_HINTSET_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_HINTSET_Pos)            /*!< SCU_INTERRUPT SRSTAT: HINTSET Mask      */
#define SCU_INTERRUPT_SRSTAT_HDSTAT_Pos       16                                                      /*!< SCU_INTERRUPT SRSTAT: HDSTAT Position   */
#define SCU_INTERRUPT_SRSTAT_HDSTAT_Msk       (0x01UL << SCU_INTERRUPT_SRSTAT_HDSTAT_Pos)             /*!< SCU_INTERRUPT SRSTAT: HDSTAT Mask       */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Pos        17                                                      /*!< SCU_INTERRUPT SRSTAT: HDCLR Position    */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Msk        (0x01UL << SCU_INTERRUPT_SRSTAT_HDCLR_Pos)              /*!< SCU_INTERRUPT SRSTAT: HDCLR Mask        */
#define SCU_INTERRUPT_SRSTAT_HDSET_Pos        18                                                      /*!< SCU_INTERRUPT SRSTAT: HDSET Position    */
#define SCU_INTERRUPT_SRSTAT_HDSET_Msk        (0x01UL << SCU_INTERRUPT_SRSTAT_HDSET_Pos)              /*!< SCU_INTERRUPT SRSTAT: HDSET Mask        */
#define SCU_INTERRUPT_SRSTAT_HDCR_Pos         19                                                      /*!< SCU_INTERRUPT SRSTAT: HDCR Position     */
#define SCU_INTERRUPT_SRSTAT_HDCR_Msk         (0x01UL << SCU_INTERRUPT_SRSTAT_HDCR_Pos)               /*!< SCU_INTERRUPT SRSTAT: HDCR Mask         */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Pos    21                                                      /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL Position */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_OSCSICTRL_Pos)          /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL Mask    */
#define SCU_INTERRUPT_SRSTAT_OSCULSTAT_Pos    22                                                      /*!< SCU_INTERRUPT SRSTAT: OSCULSTAT Position */
#define SCU_INTERRUPT_SRSTAT_OSCULSTAT_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_OSCULSTAT_Pos)          /*!< SCU_INTERRUPT SRSTAT: OSCULSTAT Mask    */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Pos    23                                                      /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL Position */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_OSCULCTRL_Pos)          /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL Mask    */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Pos      24                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_CTR Position  */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Msk      (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_CTR_Pos)            /*!< SCU_INTERRUPT SRSTAT: RTC_CTR Mask      */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Pos    25                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Pos)          /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 Mask    */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Pos    26                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Msk    (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Pos)          /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 Mask    */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Pos     27                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Msk     (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_TIM0_Pos)           /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 Mask     */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Pos     28                                                      /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 Position */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Msk     (0x01UL << SCU_INTERRUPT_SRSTAT_RTC_TIM1_Pos)           /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 Mask     */
#define SCU_INTERRUPT_SRSTAT_RMX_Pos          29                                                      /*!< SCU_INTERRUPT SRSTAT: RMX Position      */
#define SCU_INTERRUPT_SRSTAT_RMX_Msk          (0x01UL << SCU_INTERRUPT_SRSTAT_RMX_Pos)                /*!< SCU_INTERRUPT SRSTAT: RMX Mask          */

/* -----------------------------  SCU_INTERRUPT_SRRAW  ---------------------------- */
#define SCU_INTERRUPT_SRRAW_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRRAW: PRWARN Position    */
#define SCU_INTERRUPT_SRRAW_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_PRWARN_Pos)              /*!< SCU_INTERRUPT SRRAW: PRWARN Mask        */
#define SCU_INTERRUPT_SRRAW_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRRAW: PI Position        */
#define SCU_INTERRUPT_SRRAW_PI_Msk            (0x01UL << SCU_INTERRUPT_SRRAW_PI_Pos)                  /*!< SCU_INTERRUPT SRRAW: PI Mask            */
#define SCU_INTERRUPT_SRRAW_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRRAW: AI Position        */
#define SCU_INTERRUPT_SRRAW_AI_Msk            (0x01UL << SCU_INTERRUPT_SRRAW_AI_Pos)                  /*!< SCU_INTERRUPT SRRAW: AI Mask            */
#define SCU_INTERRUPT_SRRAW_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRRAW: DLROVR Position    */
#define SCU_INTERRUPT_SRRAW_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_DLROVR_Pos)              /*!< SCU_INTERRUPT SRRAW: DLROVR Mask        */
#define SCU_INTERRUPT_SRRAW_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRRAW: LPACCR Position    */
#define SCU_INTERRUPT_SRRAW_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_LPACCR_Pos)              /*!< SCU_INTERRUPT SRRAW: LPACCR Mask        */
#define SCU_INTERRUPT_SRRAW_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRRAW: LPACTH0 Position   */
#define SCU_INTERRUPT_SRRAW_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRRAW: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRRAW_LPACTH1_Pos       8                                                       /*!< SCU_INTERRUPT SRRAW: LPACTH1 Position   */
#define SCU_INTERRUPT_SRRAW_LPACTH1_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_LPACTH1_Pos)             /*!< SCU_INTERRUPT SRRAW: LPACTH1 Mask       */
#define SCU_INTERRUPT_SRRAW_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRRAW: LPACST Position    */
#define SCU_INTERRUPT_SRRAW_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_LPACST_Pos)              /*!< SCU_INTERRUPT SRRAW: LPACST Mask        */
#define SCU_INTERRUPT_SRRAW_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRRAW: LPACCLR Position   */
#define SCU_INTERRUPT_SRRAW_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRRAW: LPACCLR Mask       */
#define SCU_INTERRUPT_SRRAW_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRRAW: LPACSET Position   */
#define SCU_INTERRUPT_SRRAW_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_LPACSET_Pos)             /*!< SCU_INTERRUPT SRRAW: LPACSET Mask       */
#define SCU_INTERRUPT_SRRAW_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRRAW: HINTST Position    */
#define SCU_INTERRUPT_SRRAW_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_HINTST_Pos)              /*!< SCU_INTERRUPT SRRAW: HINTST Mask        */
#define SCU_INTERRUPT_SRRAW_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRRAW: HINTCLR Position   */
#define SCU_INTERRUPT_SRRAW_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRRAW: HINTCLR Mask       */
#define SCU_INTERRUPT_SRRAW_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRRAW: HINTSET Position   */
#define SCU_INTERRUPT_SRRAW_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_HINTSET_Pos)             /*!< SCU_INTERRUPT SRRAW: HINTSET Mask       */
#define SCU_INTERRUPT_SRRAW_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRRAW: HDSTAT Position    */
#define SCU_INTERRUPT_SRRAW_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRRAW_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRRAW: HDSTAT Mask        */
#define SCU_INTERRUPT_SRRAW_HDCLR_Pos         17                                                      /*!< SCU_INTERRUPT SRRAW: HDCLR Position     */
#define SCU_INTERRUPT_SRRAW_HDCLR_Msk         (0x01UL << SCU_INTERRUPT_SRRAW_HDCLR_Pos)               /*!< SCU_INTERRUPT SRRAW: HDCLR Mask         */
#define SCU_INTERRUPT_SRRAW_HDSET_Pos         18                                                      /*!< SCU_INTERRUPT SRRAW: HDSET Position     */
#define SCU_INTERRUPT_SRRAW_HDSET_Msk         (0x01UL << SCU_INTERRUPT_SRRAW_HDSET_Pos)               /*!< SCU_INTERRUPT SRRAW: HDSET Mask         */
#define SCU_INTERRUPT_SRRAW_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRRAW: HDCR Position      */
#define SCU_INTERRUPT_SRRAW_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRRAW_HDCR_Pos)                /*!< SCU_INTERRUPT SRRAW: HDCR Mask          */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRRAW: OSCSICTRL Position */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRRAW: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRRAW_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRRAW: OSCULSTAT Position */
#define SCU_INTERRUPT_SRRAW_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRRAW: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRRAW: OSCULCTRL Position */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRRAW: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRRAW: RTC_CTR Position   */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRRAW_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRRAW: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRRAW_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRRAW_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRRAW_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRRAW_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRRAW: RMX Position       */
#define SCU_INTERRUPT_SRRAW_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRRAW_RMX_Pos)                 /*!< SCU_INTERRUPT SRRAW: RMX Mask           */

/* -----------------------------  SCU_INTERRUPT_SRMSK  ---------------------------- */
#define SCU_INTERRUPT_SRMSK_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRMSK: PRWARN Position    */
#define SCU_INTERRUPT_SRMSK_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_PRWARN_Pos)              /*!< SCU_INTERRUPT SRMSK: PRWARN Mask        */
#define SCU_INTERRUPT_SRMSK_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRMSK: PI Position        */
#define SCU_INTERRUPT_SRMSK_PI_Msk            (0x01UL << SCU_INTERRUPT_SRMSK_PI_Pos)                  /*!< SCU_INTERRUPT SRMSK: PI Mask            */
#define SCU_INTERRUPT_SRMSK_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRMSK: AI Position        */
#define SCU_INTERRUPT_SRMSK_AI_Msk            (0x01UL << SCU_INTERRUPT_SRMSK_AI_Pos)                  /*!< SCU_INTERRUPT SRMSK: AI Mask            */
#define SCU_INTERRUPT_SRMSK_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRMSK: DLROVR Position    */
#define SCU_INTERRUPT_SRMSK_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_DLROVR_Pos)              /*!< SCU_INTERRUPT SRMSK: DLROVR Mask        */
#define SCU_INTERRUPT_SRMSK_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRMSK: LPACCR Position    */
#define SCU_INTERRUPT_SRMSK_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_LPACCR_Pos)              /*!< SCU_INTERRUPT SRMSK: LPACCR Mask        */
#define SCU_INTERRUPT_SRMSK_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRMSK: LPACTH0 Position   */
#define SCU_INTERRUPT_SRMSK_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRMSK: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRMSK_LPACTH1_Pos       8                                                       /*!< SCU_INTERRUPT SRMSK: LPACTH1 Position   */
#define SCU_INTERRUPT_SRMSK_LPACTH1_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_LPACTH1_Pos)             /*!< SCU_INTERRUPT SRMSK: LPACTH1 Mask       */
#define SCU_INTERRUPT_SRMSK_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRMSK: LPACST Position    */
#define SCU_INTERRUPT_SRMSK_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_LPACST_Pos)              /*!< SCU_INTERRUPT SRMSK: LPACST Mask        */
#define SCU_INTERRUPT_SRMSK_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRMSK: LPACCLR Position   */
#define SCU_INTERRUPT_SRMSK_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRMSK: LPACCLR Mask       */
#define SCU_INTERRUPT_SRMSK_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRMSK: LPACSET Position   */
#define SCU_INTERRUPT_SRMSK_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_LPACSET_Pos)             /*!< SCU_INTERRUPT SRMSK: LPACSET Mask       */
#define SCU_INTERRUPT_SRMSK_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRMSK: HINTST Position    */
#define SCU_INTERRUPT_SRMSK_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_HINTST_Pos)              /*!< SCU_INTERRUPT SRMSK: HINTST Mask        */
#define SCU_INTERRUPT_SRMSK_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRMSK: HINTCLR Position   */
#define SCU_INTERRUPT_SRMSK_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRMSK: HINTCLR Mask       */
#define SCU_INTERRUPT_SRMSK_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRMSK: HINTSET Position   */
#define SCU_INTERRUPT_SRMSK_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_HINTSET_Pos)             /*!< SCU_INTERRUPT SRMSK: HINTSET Mask       */
#define SCU_INTERRUPT_SRMSK_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRMSK: HDSTAT Position    */
#define SCU_INTERRUPT_SRMSK_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRMSK_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRMSK: HDSTAT Mask        */
#define SCU_INTERRUPT_SRMSK_HDCLR_Pos         17                                                      /*!< SCU_INTERRUPT SRMSK: HDCLR Position     */
#define SCU_INTERRUPT_SRMSK_HDCLR_Msk         (0x01UL << SCU_INTERRUPT_SRMSK_HDCLR_Pos)               /*!< SCU_INTERRUPT SRMSK: HDCLR Mask         */
#define SCU_INTERRUPT_SRMSK_HDSET_Pos         18                                                      /*!< SCU_INTERRUPT SRMSK: HDSET Position     */
#define SCU_INTERRUPT_SRMSK_HDSET_Msk         (0x01UL << SCU_INTERRUPT_SRMSK_HDSET_Pos)               /*!< SCU_INTERRUPT SRMSK: HDSET Mask         */
#define SCU_INTERRUPT_SRMSK_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRMSK: HDCR Position      */
#define SCU_INTERRUPT_SRMSK_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRMSK_HDCR_Pos)                /*!< SCU_INTERRUPT SRMSK: HDCR Mask          */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRMSK: OSCSICTRL Position */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRMSK: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRMSK_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRMSK: OSCULSTAT Position */
#define SCU_INTERRUPT_SRMSK_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRMSK: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRMSK: OSCULCTRL Position */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRMSK: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRMSK: RTC_CTR Position   */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRMSK_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRMSK: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRMSK_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRMSK_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRMSK_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRMSK_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRMSK: RMX Position       */
#define SCU_INTERRUPT_SRMSK_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRMSK_RMX_Pos)                 /*!< SCU_INTERRUPT SRMSK: RMX Mask           */

/* -----------------------------  SCU_INTERRUPT_SRCLR  ---------------------------- */
#define SCU_INTERRUPT_SRCLR_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRCLR: PRWARN Position    */
#define SCU_INTERRUPT_SRCLR_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_PRWARN_Pos)              /*!< SCU_INTERRUPT SRCLR: PRWARN Mask        */
#define SCU_INTERRUPT_SRCLR_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRCLR: PI Position        */
#define SCU_INTERRUPT_SRCLR_PI_Msk            (0x01UL << SCU_INTERRUPT_SRCLR_PI_Pos)                  /*!< SCU_INTERRUPT SRCLR: PI Mask            */
#define SCU_INTERRUPT_SRCLR_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRCLR: AI Position        */
#define SCU_INTERRUPT_SRCLR_AI_Msk            (0x01UL << SCU_INTERRUPT_SRCLR_AI_Pos)                  /*!< SCU_INTERRUPT SRCLR: AI Mask            */
#define SCU_INTERRUPT_SRCLR_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRCLR: DLROVR Position    */
#define SCU_INTERRUPT_SRCLR_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_DLROVR_Pos)              /*!< SCU_INTERRUPT SRCLR: DLROVR Mask        */
#define SCU_INTERRUPT_SRCLR_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRCLR: LPACCR Position    */
#define SCU_INTERRUPT_SRCLR_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_LPACCR_Pos)              /*!< SCU_INTERRUPT SRCLR: LPACCR Mask        */
#define SCU_INTERRUPT_SRCLR_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRCLR: LPACTH0 Position   */
#define SCU_INTERRUPT_SRCLR_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRCLR: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRCLR_LPACTH1_Pos       8                                                       /*!< SCU_INTERRUPT SRCLR: LPACTH1 Position   */
#define SCU_INTERRUPT_SRCLR_LPACTH1_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_LPACTH1_Pos)             /*!< SCU_INTERRUPT SRCLR: LPACTH1 Mask       */
#define SCU_INTERRUPT_SRCLR_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRCLR: LPACST Position    */
#define SCU_INTERRUPT_SRCLR_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_LPACST_Pos)              /*!< SCU_INTERRUPT SRCLR: LPACST Mask        */
#define SCU_INTERRUPT_SRCLR_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRCLR: LPACCLR Position   */
#define SCU_INTERRUPT_SRCLR_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRCLR: LPACCLR Mask       */
#define SCU_INTERRUPT_SRCLR_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRCLR: LPACSET Position   */
#define SCU_INTERRUPT_SRCLR_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_LPACSET_Pos)             /*!< SCU_INTERRUPT SRCLR: LPACSET Mask       */
#define SCU_INTERRUPT_SRCLR_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRCLR: HINTST Position    */
#define SCU_INTERRUPT_SRCLR_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_HINTST_Pos)              /*!< SCU_INTERRUPT SRCLR: HINTST Mask        */
#define SCU_INTERRUPT_SRCLR_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRCLR: HINTCLR Position   */
#define SCU_INTERRUPT_SRCLR_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRCLR: HINTCLR Mask       */
#define SCU_INTERRUPT_SRCLR_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRCLR: HINTSET Position   */
#define SCU_INTERRUPT_SRCLR_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_HINTSET_Pos)             /*!< SCU_INTERRUPT SRCLR: HINTSET Mask       */
#define SCU_INTERRUPT_SRCLR_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRCLR: HDSTAT Position    */
#define SCU_INTERRUPT_SRCLR_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRCLR_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRCLR: HDSTAT Mask        */
#define SCU_INTERRUPT_SRCLR_HDCLR_Pos         17                                                      /*!< SCU_INTERRUPT SRCLR: HDCLR Position     */
#define SCU_INTERRUPT_SRCLR_HDCLR_Msk         (0x01UL << SCU_INTERRUPT_SRCLR_HDCLR_Pos)               /*!< SCU_INTERRUPT SRCLR: HDCLR Mask         */
#define SCU_INTERRUPT_SRCLR_HDSET_Pos         18                                                      /*!< SCU_INTERRUPT SRCLR: HDSET Position     */
#define SCU_INTERRUPT_SRCLR_HDSET_Msk         (0x01UL << SCU_INTERRUPT_SRCLR_HDSET_Pos)               /*!< SCU_INTERRUPT SRCLR: HDSET Mask         */
#define SCU_INTERRUPT_SRCLR_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRCLR: HDCR Position      */
#define SCU_INTERRUPT_SRCLR_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRCLR_HDCR_Pos)                /*!< SCU_INTERRUPT SRCLR: HDCR Mask          */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRCLR: OSCSICTRL Position */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRCLR: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRCLR_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRCLR: OSCULSTAT Position */
#define SCU_INTERRUPT_SRCLR_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRCLR: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRCLR: OSCULCTRL Position */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRCLR: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRCLR: RTC_CTR Position   */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRCLR_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRCLR: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRCLR_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRCLR_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRCLR_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRCLR_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRCLR: RMX Position       */
#define SCU_INTERRUPT_SRCLR_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRCLR_RMX_Pos)                 /*!< SCU_INTERRUPT SRCLR: RMX Mask           */

/* -----------------------------  SCU_INTERRUPT_SRSET  ---------------------------- */
#define SCU_INTERRUPT_SRSET_PRWARN_Pos        0                                                       /*!< SCU_INTERRUPT SRSET: PRWARN Position    */
#define SCU_INTERRUPT_SRSET_PRWARN_Msk        (0x01UL << SCU_INTERRUPT_SRSET_PRWARN_Pos)              /*!< SCU_INTERRUPT SRSET: PRWARN Mask        */
#define SCU_INTERRUPT_SRSET_PI_Pos            1                                                       /*!< SCU_INTERRUPT SRSET: PI Position        */
#define SCU_INTERRUPT_SRSET_PI_Msk            (0x01UL << SCU_INTERRUPT_SRSET_PI_Pos)                  /*!< SCU_INTERRUPT SRSET: PI Mask            */
#define SCU_INTERRUPT_SRSET_AI_Pos            2                                                       /*!< SCU_INTERRUPT SRSET: AI Position        */
#define SCU_INTERRUPT_SRSET_AI_Msk            (0x01UL << SCU_INTERRUPT_SRSET_AI_Pos)                  /*!< SCU_INTERRUPT SRSET: AI Mask            */
#define SCU_INTERRUPT_SRSET_DLROVR_Pos        3                                                       /*!< SCU_INTERRUPT SRSET: DLROVR Position    */
#define SCU_INTERRUPT_SRSET_DLROVR_Msk        (0x01UL << SCU_INTERRUPT_SRSET_DLROVR_Pos)              /*!< SCU_INTERRUPT SRSET: DLROVR Mask        */
#define SCU_INTERRUPT_SRSET_LPACCR_Pos        6                                                       /*!< SCU_INTERRUPT SRSET: LPACCR Position    */
#define SCU_INTERRUPT_SRSET_LPACCR_Msk        (0x01UL << SCU_INTERRUPT_SRSET_LPACCR_Pos)              /*!< SCU_INTERRUPT SRSET: LPACCR Mask        */
#define SCU_INTERRUPT_SRSET_LPACTH0_Pos       7                                                       /*!< SCU_INTERRUPT SRSET: LPACTH0 Position   */
#define SCU_INTERRUPT_SRSET_LPACTH0_Msk       (0x01UL << SCU_INTERRUPT_SRSET_LPACTH0_Pos)             /*!< SCU_INTERRUPT SRSET: LPACTH0 Mask       */
#define SCU_INTERRUPT_SRSET_LPACTH1_Pos       8                                                       /*!< SCU_INTERRUPT SRSET: LPACTH1 Position   */
#define SCU_INTERRUPT_SRSET_LPACTH1_Msk       (0x01UL << SCU_INTERRUPT_SRSET_LPACTH1_Pos)             /*!< SCU_INTERRUPT SRSET: LPACTH1 Mask       */
#define SCU_INTERRUPT_SRSET_LPACST_Pos        9                                                       /*!< SCU_INTERRUPT SRSET: LPACST Position    */
#define SCU_INTERRUPT_SRSET_LPACST_Msk        (0x01UL << SCU_INTERRUPT_SRSET_LPACST_Pos)              /*!< SCU_INTERRUPT SRSET: LPACST Mask        */
#define SCU_INTERRUPT_SRSET_LPACCLR_Pos       10                                                      /*!< SCU_INTERRUPT SRSET: LPACCLR Position   */
#define SCU_INTERRUPT_SRSET_LPACCLR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_LPACCLR_Pos)             /*!< SCU_INTERRUPT SRSET: LPACCLR Mask       */
#define SCU_INTERRUPT_SRSET_LPACSET_Pos       11                                                      /*!< SCU_INTERRUPT SRSET: LPACSET Position   */
#define SCU_INTERRUPT_SRSET_LPACSET_Msk       (0x01UL << SCU_INTERRUPT_SRSET_LPACSET_Pos)             /*!< SCU_INTERRUPT SRSET: LPACSET Mask       */
#define SCU_INTERRUPT_SRSET_HINTST_Pos        12                                                      /*!< SCU_INTERRUPT SRSET: HINTST Position    */
#define SCU_INTERRUPT_SRSET_HINTST_Msk        (0x01UL << SCU_INTERRUPT_SRSET_HINTST_Pos)              /*!< SCU_INTERRUPT SRSET: HINTST Mask        */
#define SCU_INTERRUPT_SRSET_HINTCLR_Pos       13                                                      /*!< SCU_INTERRUPT SRSET: HINTCLR Position   */
#define SCU_INTERRUPT_SRSET_HINTCLR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HINTCLR_Pos)             /*!< SCU_INTERRUPT SRSET: HINTCLR Mask       */
#define SCU_INTERRUPT_SRSET_HINTSET_Pos       14                                                      /*!< SCU_INTERRUPT SRSET: HINTSET Position   */
#define SCU_INTERRUPT_SRSET_HINTSET_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HINTSET_Pos)             /*!< SCU_INTERRUPT SRSET: HINTSET Mask       */
#define SCU_INTERRUPT_SRSET_HDSTAT_Pos        16                                                      /*!< SCU_INTERRUPT SRSET: HDSTAT Position    */
#define SCU_INTERRUPT_SRSET_HDSTAT_Msk        (0x01UL << SCU_INTERRUPT_SRSET_HDSTAT_Pos)              /*!< SCU_INTERRUPT SRSET: HDSTAT Mask        */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Pos       17                                                      /*!< SCU_INTERRUPT SRSET: HDCRCLR Position   */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HDCRCLR_Pos)             /*!< SCU_INTERRUPT SRSET: HDCRCLR Mask       */
#define SCU_INTERRUPT_SRSET_HDCRSET_Pos       18                                                      /*!< SCU_INTERRUPT SRSET: HDCRSET Position   */
#define SCU_INTERRUPT_SRSET_HDCRSET_Msk       (0x01UL << SCU_INTERRUPT_SRSET_HDCRSET_Pos)             /*!< SCU_INTERRUPT SRSET: HDCRSET Mask       */
#define SCU_INTERRUPT_SRSET_HDCR_Pos          19                                                      /*!< SCU_INTERRUPT SRSET: HDCR Position      */
#define SCU_INTERRUPT_SRSET_HDCR_Msk          (0x01UL << SCU_INTERRUPT_SRSET_HDCR_Pos)                /*!< SCU_INTERRUPT SRSET: HDCR Mask          */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Pos     21                                                      /*!< SCU_INTERRUPT SRSET: OSCSICTRL Position */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Msk     (0x01UL << SCU_INTERRUPT_SRSET_OSCSICTRL_Pos)           /*!< SCU_INTERRUPT SRSET: OSCSICTRL Mask     */
#define SCU_INTERRUPT_SRSET_OSCULSTAT_Pos     22                                                      /*!< SCU_INTERRUPT SRSET: OSCULSTAT Position */
#define SCU_INTERRUPT_SRSET_OSCULSTAT_Msk     (0x01UL << SCU_INTERRUPT_SRSET_OSCULSTAT_Pos)           /*!< SCU_INTERRUPT SRSET: OSCULSTAT Mask     */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Pos     23                                                      /*!< SCU_INTERRUPT SRSET: OSCULCTRL Position */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Msk     (0x01UL << SCU_INTERRUPT_SRSET_OSCULCTRL_Pos)           /*!< SCU_INTERRUPT SRSET: OSCULCTRL Mask     */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Pos       24                                                      /*!< SCU_INTERRUPT SRSET: RTC_CTR Position   */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Msk       (0x01UL << SCU_INTERRUPT_SRSET_RTC_CTR_Pos)             /*!< SCU_INTERRUPT SRSET: RTC_CTR Mask       */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Pos     25                                                      /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 Position */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Msk     (0x01UL << SCU_INTERRUPT_SRSET_RTC_ATIM0_Pos)           /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 Mask     */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Pos     26                                                      /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 Position */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Msk     (0x01UL << SCU_INTERRUPT_SRSET_RTC_ATIM1_Pos)           /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 Mask     */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Pos      27                                                      /*!< SCU_INTERRUPT SRSET: RTC_TIM0 Position  */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Msk      (0x01UL << SCU_INTERRUPT_SRSET_RTC_TIM0_Pos)            /*!< SCU_INTERRUPT SRSET: RTC_TIM0 Mask      */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Pos      28                                                      /*!< SCU_INTERRUPT SRSET: RTC_TIM1 Position  */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Msk      (0x01UL << SCU_INTERRUPT_SRSET_RTC_TIM1_Pos)            /*!< SCU_INTERRUPT SRSET: RTC_TIM1 Mask      */
#define SCU_INTERRUPT_SRSET_RMX_Pos           29                                                      /*!< SCU_INTERRUPT SRSET: RMX Position       */
#define SCU_INTERRUPT_SRSET_RMX_Msk           (0x01UL << SCU_INTERRUPT_SRSET_RMX_Pos)                 /*!< SCU_INTERRUPT SRSET: RMX Mask           */

/* ---------------------------  SCU_INTERRUPT_NMIREQEN  --------------------------- */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Pos     0                                                       /*!< SCU_INTERRUPT NMIREQEN: PRWARN Position */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Msk     (0x01UL << SCU_INTERRUPT_NMIREQEN_PRWARN_Pos)           /*!< SCU_INTERRUPT NMIREQEN: PRWARN Mask     */
#define SCU_INTERRUPT_NMIREQEN_PI_Pos         1                                                       /*!< SCU_INTERRUPT NMIREQEN: PI Position     */
#define SCU_INTERRUPT_NMIREQEN_PI_Msk         (0x01UL << SCU_INTERRUPT_NMIREQEN_PI_Pos)               /*!< SCU_INTERRUPT NMIREQEN: PI Mask         */
#define SCU_INTERRUPT_NMIREQEN_AI_Pos         2                                                       /*!< SCU_INTERRUPT NMIREQEN: AI Position     */
#define SCU_INTERRUPT_NMIREQEN_AI_Msk         (0x01UL << SCU_INTERRUPT_NMIREQEN_AI_Pos)               /*!< SCU_INTERRUPT NMIREQEN: AI Mask         */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Pos      16                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU00 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU00_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU00 Mask      */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Pos      17                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU01 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU01_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU01 Mask      */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Pos      18                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU02 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU02_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU02 Mask      */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Pos      19                                                      /*!< SCU_INTERRUPT NMIREQEN: ERU03 Position  */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Msk      (0x01UL << SCU_INTERRUPT_NMIREQEN_ERU03_Pos)            /*!< SCU_INTERRUPT NMIREQEN: ERU03 Mask      */


/* ================================================================================ */
/* ================       struct 'SCU_PARITY' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PARITY_PEEN  ------------------------------ */
#define SCU_PARITY_PEEN_PEENPS_Pos            0                                                       /*!< SCU_PARITY PEEN: PEENPS Position        */
#define SCU_PARITY_PEEN_PEENPS_Msk            (0x01UL << SCU_PARITY_PEEN_PEENPS_Pos)                  /*!< SCU_PARITY PEEN: PEENPS Mask            */
#define SCU_PARITY_PEEN_PEENDS1_Pos           1                                                       /*!< SCU_PARITY PEEN: PEENDS1 Position       */
#define SCU_PARITY_PEEN_PEENDS1_Msk           (0x01UL << SCU_PARITY_PEEN_PEENDS1_Pos)                 /*!< SCU_PARITY PEEN: PEENDS1 Mask           */
#define SCU_PARITY_PEEN_PEENDS2_Pos           2                                                       /*!< SCU_PARITY PEEN: PEENDS2 Position       */
#define SCU_PARITY_PEEN_PEENDS2_Msk           (0x01UL << SCU_PARITY_PEEN_PEENDS2_Pos)                 /*!< SCU_PARITY PEEN: PEENDS2 Mask           */
#define SCU_PARITY_PEEN_PEENU0_Pos            8                                                       /*!< SCU_PARITY PEEN: PEENU0 Position        */
#define SCU_PARITY_PEEN_PEENU0_Msk            (0x01UL << SCU_PARITY_PEEN_PEENU0_Pos)                  /*!< SCU_PARITY PEEN: PEENU0 Mask            */
#define SCU_PARITY_PEEN_PEENU1_Pos            9                                                       /*!< SCU_PARITY PEEN: PEENU1 Position        */
#define SCU_PARITY_PEEN_PEENU1_Msk            (0x01UL << SCU_PARITY_PEEN_PEENU1_Pos)                  /*!< SCU_PARITY PEEN: PEENU1 Mask            */
#define SCU_PARITY_PEEN_PEENMC_Pos            12                                                      /*!< SCU_PARITY PEEN: PEENMC Position        */
#define SCU_PARITY_PEEN_PEENMC_Msk            (0x01UL << SCU_PARITY_PEEN_PEENMC_Pos)                  /*!< SCU_PARITY PEEN: PEENMC Mask            */
#define SCU_PARITY_PEEN_PEENPPRF_Pos          13                                                      /*!< SCU_PARITY PEEN: PEENPPRF Position      */
#define SCU_PARITY_PEEN_PEENPPRF_Msk          (0x01UL << SCU_PARITY_PEEN_PEENPPRF_Pos)                /*!< SCU_PARITY PEEN: PEENPPRF Mask          */
#define SCU_PARITY_PEEN_PEENUSB_Pos           16                                                      /*!< SCU_PARITY PEEN: PEENUSB Position       */
#define SCU_PARITY_PEEN_PEENUSB_Msk           (0x01UL << SCU_PARITY_PEEN_PEENUSB_Pos)                 /*!< SCU_PARITY PEEN: PEENUSB Mask           */
#define SCU_PARITY_PEEN_PEENETH0TX_Pos        17                                                      /*!< SCU_PARITY PEEN: PEENETH0TX Position    */
#define SCU_PARITY_PEEN_PEENETH0TX_Msk        (0x01UL << SCU_PARITY_PEEN_PEENETH0TX_Pos)              /*!< SCU_PARITY PEEN: PEENETH0TX Mask        */
#define SCU_PARITY_PEEN_PEENETH0RX_Pos        18                                                      /*!< SCU_PARITY PEEN: PEENETH0RX Position    */
#define SCU_PARITY_PEEN_PEENETH0RX_Msk        (0x01UL << SCU_PARITY_PEEN_PEENETH0RX_Pos)              /*!< SCU_PARITY PEEN: PEENETH0RX Mask        */

/* -----------------------------  SCU_PARITY_MCHKCON  ----------------------------- */
#define SCU_PARITY_MCHKCON_SELPS_Pos          0                                                       /*!< SCU_PARITY MCHKCON: SELPS Position      */
#define SCU_PARITY_MCHKCON_SELPS_Msk          (0x01UL << SCU_PARITY_MCHKCON_SELPS_Pos)                /*!< SCU_PARITY MCHKCON: SELPS Mask          */
#define SCU_PARITY_MCHKCON_SELDS1_Pos         1                                                       /*!< SCU_PARITY MCHKCON: SELDS1 Position     */
#define SCU_PARITY_MCHKCON_SELDS1_Msk         (0x01UL << SCU_PARITY_MCHKCON_SELDS1_Pos)               /*!< SCU_PARITY MCHKCON: SELDS1 Mask         */
#define SCU_PARITY_MCHKCON_SELDS2_Pos         2                                                       /*!< SCU_PARITY MCHKCON: SELDS2 Position     */
#define SCU_PARITY_MCHKCON_SELDS2_Msk         (0x01UL << SCU_PARITY_MCHKCON_SELDS2_Pos)               /*!< SCU_PARITY MCHKCON: SELDS2 Mask         */
#define SCU_PARITY_MCHKCON_USIC0DRA_Pos       8                                                       /*!< SCU_PARITY MCHKCON: USIC0DRA Position   */
#define SCU_PARITY_MCHKCON_USIC0DRA_Msk       (0x01UL << SCU_PARITY_MCHKCON_USIC0DRA_Pos)             /*!< SCU_PARITY MCHKCON: USIC0DRA Mask       */
#define SCU_PARITY_MCHKCON_USIC1DRA_Pos       9                                                       /*!< SCU_PARITY MCHKCON: USIC1DRA Position   */
#define SCU_PARITY_MCHKCON_USIC1DRA_Msk       (0x01UL << SCU_PARITY_MCHKCON_USIC1DRA_Pos)             /*!< SCU_PARITY MCHKCON: USIC1DRA Mask       */
#define SCU_PARITY_MCHKCON_MCANDRA_Pos        12                                                      /*!< SCU_PARITY MCHKCON: MCANDRA Position    */
#define SCU_PARITY_MCHKCON_MCANDRA_Msk        (0x01UL << SCU_PARITY_MCHKCON_MCANDRA_Pos)              /*!< SCU_PARITY MCHKCON: MCANDRA Mask        */
#define SCU_PARITY_MCHKCON_PPRFDRA_Pos        13                                                      /*!< SCU_PARITY MCHKCON: PPRFDRA Position    */
#define SCU_PARITY_MCHKCON_PPRFDRA_Msk        (0x01UL << SCU_PARITY_MCHKCON_PPRFDRA_Pos)              /*!< SCU_PARITY MCHKCON: PPRFDRA Mask        */
#define SCU_PARITY_MCHKCON_SELUSB_Pos         16                                                      /*!< SCU_PARITY MCHKCON: SELUSB Position     */
#define SCU_PARITY_MCHKCON_SELUSB_Msk         (0x01UL << SCU_PARITY_MCHKCON_SELUSB_Pos)               /*!< SCU_PARITY MCHKCON: SELUSB Mask         */
#define SCU_PARITY_MCHKCON_SELETH0TX_Pos      17                                                      /*!< SCU_PARITY MCHKCON: SELETH0TX Position  */
#define SCU_PARITY_MCHKCON_SELETH0TX_Msk      (0x01UL << SCU_PARITY_MCHKCON_SELETH0TX_Pos)            /*!< SCU_PARITY MCHKCON: SELETH0TX Mask      */
#define SCU_PARITY_MCHKCON_SELETH0RX_Pos      18                                                      /*!< SCU_PARITY MCHKCON: SELETH0RX Position  */
#define SCU_PARITY_MCHKCON_SELETH0RX_Msk      (0x01UL << SCU_PARITY_MCHKCON_SELETH0RX_Pos)            /*!< SCU_PARITY MCHKCON: SELETH0RX Mask      */

/* -------------------------------  SCU_PARITY_PETE  ------------------------------ */
#define SCU_PARITY_PETE_PETEPS_Pos            0                                                       /*!< SCU_PARITY PETE: PETEPS Position        */
#define SCU_PARITY_PETE_PETEPS_Msk            (0x01UL << SCU_PARITY_PETE_PETEPS_Pos)                  /*!< SCU_PARITY PETE: PETEPS Mask            */
#define SCU_PARITY_PETE_PETEDS1_Pos           1                                                       /*!< SCU_PARITY PETE: PETEDS1 Position       */
#define SCU_PARITY_PETE_PETEDS1_Msk           (0x01UL << SCU_PARITY_PETE_PETEDS1_Pos)                 /*!< SCU_PARITY PETE: PETEDS1 Mask           */
#define SCU_PARITY_PETE_PETEDS2_Pos           2                                                       /*!< SCU_PARITY PETE: PETEDS2 Position       */
#define SCU_PARITY_PETE_PETEDS2_Msk           (0x01UL << SCU_PARITY_PETE_PETEDS2_Pos)                 /*!< SCU_PARITY PETE: PETEDS2 Mask           */
#define SCU_PARITY_PETE_PETEU0_Pos            8                                                       /*!< SCU_PARITY PETE: PETEU0 Position        */
#define SCU_PARITY_PETE_PETEU0_Msk            (0x01UL << SCU_PARITY_PETE_PETEU0_Pos)                  /*!< SCU_PARITY PETE: PETEU0 Mask            */
#define SCU_PARITY_PETE_PETEU1_Pos            9                                                       /*!< SCU_PARITY PETE: PETEU1 Position        */
#define SCU_PARITY_PETE_PETEU1_Msk            (0x01UL << SCU_PARITY_PETE_PETEU1_Pos)                  /*!< SCU_PARITY PETE: PETEU1 Mask            */
#define SCU_PARITY_PETE_PETEMC_Pos            12                                                      /*!< SCU_PARITY PETE: PETEMC Position        */
#define SCU_PARITY_PETE_PETEMC_Msk            (0x01UL << SCU_PARITY_PETE_PETEMC_Pos)                  /*!< SCU_PARITY PETE: PETEMC Mask            */
#define SCU_PARITY_PETE_PETEPPRF_Pos          13                                                      /*!< SCU_PARITY PETE: PETEPPRF Position      */
#define SCU_PARITY_PETE_PETEPPRF_Msk          (0x01UL << SCU_PARITY_PETE_PETEPPRF_Pos)                /*!< SCU_PARITY PETE: PETEPPRF Mask          */
#define SCU_PARITY_PETE_PETEUSB_Pos           16                                                      /*!< SCU_PARITY PETE: PETEUSB Position       */
#define SCU_PARITY_PETE_PETEUSB_Msk           (0x01UL << SCU_PARITY_PETE_PETEUSB_Pos)                 /*!< SCU_PARITY PETE: PETEUSB Mask           */
#define SCU_PARITY_PETE_PETEETH0TX_Pos        17                                                      /*!< SCU_PARITY PETE: PETEETH0TX Position    */
#define SCU_PARITY_PETE_PETEETH0TX_Msk        (0x01UL << SCU_PARITY_PETE_PETEETH0TX_Pos)              /*!< SCU_PARITY PETE: PETEETH0TX Mask        */
#define SCU_PARITY_PETE_PETEETH0RX_Pos        18                                                      /*!< SCU_PARITY PETE: PETEETH0RX Position    */
#define SCU_PARITY_PETE_PETEETH0RX_Msk        (0x01UL << SCU_PARITY_PETE_PETEETH0RX_Pos)              /*!< SCU_PARITY PETE: PETEETH0RX Mask        */

/* -----------------------------  SCU_PARITY_PERSTEN  ----------------------------- */
#define SCU_PARITY_PERSTEN_RSEN_Pos           0                                                       /*!< SCU_PARITY PERSTEN: RSEN Position       */
#define SCU_PARITY_PERSTEN_RSEN_Msk           (0x01UL << SCU_PARITY_PERSTEN_RSEN_Pos)                 /*!< SCU_PARITY PERSTEN: RSEN Mask           */

/* ------------------------------  SCU_PARITY_PEFLAG  ----------------------------- */
#define SCU_PARITY_PEFLAG_PEFPS_Pos           0                                                       /*!< SCU_PARITY PEFLAG: PEFPS Position       */
#define SCU_PARITY_PEFLAG_PEFPS_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFPS_Pos)                 /*!< SCU_PARITY PEFLAG: PEFPS Mask           */
#define SCU_PARITY_PEFLAG_PEFDS1_Pos          1                                                       /*!< SCU_PARITY PEFLAG: PEFDS1 Position      */
#define SCU_PARITY_PEFLAG_PEFDS1_Msk          (0x01UL << SCU_PARITY_PEFLAG_PEFDS1_Pos)                /*!< SCU_PARITY PEFLAG: PEFDS1 Mask          */
#define SCU_PARITY_PEFLAG_PEFDS2_Pos          2                                                       /*!< SCU_PARITY PEFLAG: PEFDS2 Position      */
#define SCU_PARITY_PEFLAG_PEFDS2_Msk          (0x01UL << SCU_PARITY_PEFLAG_PEFDS2_Pos)                /*!< SCU_PARITY PEFLAG: PEFDS2 Mask          */
#define SCU_PARITY_PEFLAG_PEFU0_Pos           8                                                       /*!< SCU_PARITY PEFLAG: PEFU0 Position       */
#define SCU_PARITY_PEFLAG_PEFU0_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFU0_Pos)                 /*!< SCU_PARITY PEFLAG: PEFU0 Mask           */
#define SCU_PARITY_PEFLAG_PEFU1_Pos           9                                                       /*!< SCU_PARITY PEFLAG: PEFU1 Position       */
#define SCU_PARITY_PEFLAG_PEFU1_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFU1_Pos)                 /*!< SCU_PARITY PEFLAG: PEFU1 Mask           */
#define SCU_PARITY_PEFLAG_PEFMC_Pos           12                                                      /*!< SCU_PARITY PEFLAG: PEFMC Position       */
#define SCU_PARITY_PEFLAG_PEFMC_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEFMC_Pos)                 /*!< SCU_PARITY PEFLAG: PEFMC Mask           */
#define SCU_PARITY_PEFLAG_PEFPPRF_Pos         13                                                      /*!< SCU_PARITY PEFLAG: PEFPPRF Position     */
#define SCU_PARITY_PEFLAG_PEFPPRF_Msk         (0x01UL << SCU_PARITY_PEFLAG_PEFPPRF_Pos)               /*!< SCU_PARITY PEFLAG: PEFPPRF Mask         */
#define SCU_PARITY_PEFLAG_PEUSB_Pos           16                                                      /*!< SCU_PARITY PEFLAG: PEUSB Position       */
#define SCU_PARITY_PEFLAG_PEUSB_Msk           (0x01UL << SCU_PARITY_PEFLAG_PEUSB_Pos)                 /*!< SCU_PARITY PEFLAG: PEUSB Mask           */
#define SCU_PARITY_PEFLAG_PEETH0TX_Pos        17                                                      /*!< SCU_PARITY PEFLAG: PEETH0TX Position    */
#define SCU_PARITY_PEFLAG_PEETH0TX_Msk        (0x01UL << SCU_PARITY_PEFLAG_PEETH0TX_Pos)              /*!< SCU_PARITY PEFLAG: PEETH0TX Mask        */
#define SCU_PARITY_PEFLAG_PEETH0RX_Pos        18                                                      /*!< SCU_PARITY PEFLAG: PEETH0RX Position    */
#define SCU_PARITY_PEFLAG_PEETH0RX_Msk        (0x01UL << SCU_PARITY_PEFLAG_PEETH0RX_Pos)              /*!< SCU_PARITY PEFLAG: PEETH0RX Mask        */

/* ------------------------------  SCU_PARITY_PMTPR  ------------------------------ */
#define SCU_PARITY_PMTPR_PWR_Pos              0                                                       /*!< SCU_PARITY PMTPR: PWR Position          */
#define SCU_PARITY_PMTPR_PWR_Msk              (0x000000ffUL << SCU_PARITY_PMTPR_PWR_Pos)              /*!< SCU_PARITY PMTPR: PWR Mask              */
#define SCU_PARITY_PMTPR_PRD_Pos              8                                                       /*!< SCU_PARITY PMTPR: PRD Position          */
#define SCU_PARITY_PMTPR_PRD_Msk              (0x000000ffUL << SCU_PARITY_PMTPR_PRD_Pos)              /*!< SCU_PARITY PMTPR: PRD Mask              */

/* ------------------------------  SCU_PARITY_PMTSR  ------------------------------ */
#define SCU_PARITY_PMTSR_MTENPS_Pos           0                                                       /*!< SCU_PARITY PMTSR: MTENPS Position       */
#define SCU_PARITY_PMTSR_MTENPS_Msk           (0x01UL << SCU_PARITY_PMTSR_MTENPS_Pos)                 /*!< SCU_PARITY PMTSR: MTENPS Mask           */
#define SCU_PARITY_PMTSR_MTENDS1_Pos          1                                                       /*!< SCU_PARITY PMTSR: MTENDS1 Position      */
#define SCU_PARITY_PMTSR_MTENDS1_Msk          (0x01UL << SCU_PARITY_PMTSR_MTENDS1_Pos)                /*!< SCU_PARITY PMTSR: MTENDS1 Mask          */
#define SCU_PARITY_PMTSR_MTENDS2_Pos          2                                                       /*!< SCU_PARITY PMTSR: MTENDS2 Position      */
#define SCU_PARITY_PMTSR_MTENDS2_Msk          (0x01UL << SCU_PARITY_PMTSR_MTENDS2_Pos)                /*!< SCU_PARITY PMTSR: MTENDS2 Mask          */
#define SCU_PARITY_PMTSR_MTEU0_Pos            8                                                       /*!< SCU_PARITY PMTSR: MTEU0 Position        */
#define SCU_PARITY_PMTSR_MTEU0_Msk            (0x01UL << SCU_PARITY_PMTSR_MTEU0_Pos)                  /*!< SCU_PARITY PMTSR: MTEU0 Mask            */
#define SCU_PARITY_PMTSR_MTEU1_Pos            9                                                       /*!< SCU_PARITY PMTSR: MTEU1 Position        */
#define SCU_PARITY_PMTSR_MTEU1_Msk            (0x01UL << SCU_PARITY_PMTSR_MTEU1_Pos)                  /*!< SCU_PARITY PMTSR: MTEU1 Mask            */
#define SCU_PARITY_PMTSR_MTEMC_Pos            12                                                      /*!< SCU_PARITY PMTSR: MTEMC Position        */
#define SCU_PARITY_PMTSR_MTEMC_Msk            (0x01UL << SCU_PARITY_PMTSR_MTEMC_Pos)                  /*!< SCU_PARITY PMTSR: MTEMC Mask            */
#define SCU_PARITY_PMTSR_MTEPPRF_Pos          13                                                      /*!< SCU_PARITY PMTSR: MTEPPRF Position      */
#define SCU_PARITY_PMTSR_MTEPPRF_Msk          (0x01UL << SCU_PARITY_PMTSR_MTEPPRF_Pos)                /*!< SCU_PARITY PMTSR: MTEPPRF Mask          */
#define SCU_PARITY_PMTSR_MTUSB_Pos            16                                                      /*!< SCU_PARITY PMTSR: MTUSB Position        */
#define SCU_PARITY_PMTSR_MTUSB_Msk            (0x01UL << SCU_PARITY_PMTSR_MTUSB_Pos)                  /*!< SCU_PARITY PMTSR: MTUSB Mask            */
#define SCU_PARITY_PMTSR_MTETH0TX_Pos         17                                                      /*!< SCU_PARITY PMTSR: MTETH0TX Position     */
#define SCU_PARITY_PMTSR_MTETH0TX_Msk         (0x01UL << SCU_PARITY_PMTSR_MTETH0TX_Pos)               /*!< SCU_PARITY PMTSR: MTETH0TX Mask         */
#define SCU_PARITY_PMTSR_MTETH0RX_Pos         18                                                      /*!< SCU_PARITY PMTSR: MTETH0RX Position     */
#define SCU_PARITY_PMTSR_MTETH0RX_Msk         (0x01UL << SCU_PARITY_PMTSR_MTETH0RX_Pos)               /*!< SCU_PARITY PMTSR: MTETH0RX Mask         */


/* ================================================================================ */
/* ================        struct 'SCU_TRAP' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_TRAP_TRAPSTAT  ----------------------------- */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Pos        0                                                       /*!< SCU_TRAP TRAPSTAT: SOSCWDGT Position    */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Msk        (0x01UL << SCU_TRAP_TRAPSTAT_SOSCWDGT_Pos)              /*!< SCU_TRAP TRAPSTAT: SOSCWDGT Mask        */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Pos        2                                                       /*!< SCU_TRAP TRAPSTAT: SVCOLCKT Position    */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Msk        (0x01UL << SCU_TRAP_TRAPSTAT_SVCOLCKT_Pos)              /*!< SCU_TRAP TRAPSTAT: SVCOLCKT Mask        */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Pos        3                                                       /*!< SCU_TRAP TRAPSTAT: UVCOLCKT Position    */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Msk        (0x01UL << SCU_TRAP_TRAPSTAT_UVCOLCKT_Pos)              /*!< SCU_TRAP TRAPSTAT: UVCOLCKT Mask        */
#define SCU_TRAP_TRAPSTAT_PET_Pos             4                                                       /*!< SCU_TRAP TRAPSTAT: PET Position         */
#define SCU_TRAP_TRAPSTAT_PET_Msk             (0x01UL << SCU_TRAP_TRAPSTAT_PET_Pos)                   /*!< SCU_TRAP TRAPSTAT: PET Mask             */
#define SCU_TRAP_TRAPSTAT_BRWNT_Pos           5                                                       /*!< SCU_TRAP TRAPSTAT: BRWNT Position       */
#define SCU_TRAP_TRAPSTAT_BRWNT_Msk           (0x01UL << SCU_TRAP_TRAPSTAT_BRWNT_Pos)                 /*!< SCU_TRAP TRAPSTAT: BRWNT Mask           */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Pos         6                                                       /*!< SCU_TRAP TRAPSTAT: ULPWDGT Position     */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_ULPWDGT_Pos)               /*!< SCU_TRAP TRAPSTAT: ULPWDGT Mask         */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Pos         7                                                       /*!< SCU_TRAP TRAPSTAT: BWERR0T Position     */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_BWERR0T_Pos)               /*!< SCU_TRAP TRAPSTAT: BWERR0T Mask         */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Pos         8                                                       /*!< SCU_TRAP TRAPSTAT: BWERR1T Position     */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_BWERR1T_Pos)               /*!< SCU_TRAP TRAPSTAT: BWERR1T Mask         */
#define SCU_TRAP_TRAPSTAT_TEMPHIT_Pos         12                                                      /*!< SCU_TRAP TRAPSTAT: TEMPHIT Position     */
#define SCU_TRAP_TRAPSTAT_TEMPHIT_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_TEMPHIT_Pos)               /*!< SCU_TRAP TRAPSTAT: TEMPHIT Mask         */
#define SCU_TRAP_TRAPSTAT_TEMPLOT_Pos         13                                                      /*!< SCU_TRAP TRAPSTAT: TEMPLOT Position     */
#define SCU_TRAP_TRAPSTAT_TEMPLOT_Msk         (0x01UL << SCU_TRAP_TRAPSTAT_TEMPLOT_Pos)               /*!< SCU_TRAP TRAPSTAT: TEMPLOT Mask         */

/* ------------------------------  SCU_TRAP_TRAPRAW  ------------------------------ */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPRAW: SOSCWDGT Position     */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPRAW_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPRAW: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPRAW: SVCOLCKT Position     */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPRAW_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPRAW: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPRAW: UVCOLCKT Position     */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPRAW_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPRAW: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPRAW_PET_Pos              4                                                       /*!< SCU_TRAP TRAPRAW: PET Position          */
#define SCU_TRAP_TRAPRAW_PET_Msk              (0x01UL << SCU_TRAP_TRAPRAW_PET_Pos)                    /*!< SCU_TRAP TRAPRAW: PET Mask              */
#define SCU_TRAP_TRAPRAW_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPRAW: BRWNT Position        */
#define SCU_TRAP_TRAPRAW_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPRAW_BRWNT_Pos)                  /*!< SCU_TRAP TRAPRAW: BRWNT Mask            */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Pos          6                                                       /*!< SCU_TRAP TRAPRAW: ULPWDGT Position      */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Msk          (0x01UL << SCU_TRAP_TRAPRAW_ULPWDGT_Pos)                /*!< SCU_TRAP TRAPRAW: ULPWDGT Mask          */
#define SCU_TRAP_TRAPRAW_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPRAW: BWERR0T Position      */
#define SCU_TRAP_TRAPRAW_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPRAW_BWERR0T_Pos)                /*!< SCU_TRAP TRAPRAW: BWERR0T Mask          */
#define SCU_TRAP_TRAPRAW_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPRAW: BWERR1T Position      */
#define SCU_TRAP_TRAPRAW_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPRAW_BWERR1T_Pos)                /*!< SCU_TRAP TRAPRAW: BWERR1T Mask          */
#define SCU_TRAP_TRAPRAW_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPRAW: TEMPHIT Position      */
#define SCU_TRAP_TRAPRAW_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPRAW_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPRAW: TEMPHIT Mask          */
#define SCU_TRAP_TRAPRAW_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPRAW: TEMPLOT Position      */
#define SCU_TRAP_TRAPRAW_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPRAW_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPRAW: TEMPLOT Mask          */

/* ------------------------------  SCU_TRAP_TRAPDIS  ------------------------------ */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPDIS: SOSCWDGT Position     */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPDIS_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPDIS: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPDIS: SVCOLCKT Position     */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPDIS_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPDIS: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPDIS: UVCOLCKT Position     */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPDIS_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPDIS: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPDIS_PET_Pos              4                                                       /*!< SCU_TRAP TRAPDIS: PET Position          */
#define SCU_TRAP_TRAPDIS_PET_Msk              (0x01UL << SCU_TRAP_TRAPDIS_PET_Pos)                    /*!< SCU_TRAP TRAPDIS: PET Mask              */
#define SCU_TRAP_TRAPDIS_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPDIS: BRWNT Position        */
#define SCU_TRAP_TRAPDIS_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPDIS_BRWNT_Pos)                  /*!< SCU_TRAP TRAPDIS: BRWNT Mask            */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Pos          6                                                       /*!< SCU_TRAP TRAPDIS: ULPWDGT Position      */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Msk          (0x01UL << SCU_TRAP_TRAPDIS_ULPWDGT_Pos)                /*!< SCU_TRAP TRAPDIS: ULPWDGT Mask          */
#define SCU_TRAP_TRAPDIS_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPDIS: BWERR0T Position      */
#define SCU_TRAP_TRAPDIS_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPDIS_BWERR0T_Pos)                /*!< SCU_TRAP TRAPDIS: BWERR0T Mask          */
#define SCU_TRAP_TRAPDIS_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPDIS: BWERR1T Position      */
#define SCU_TRAP_TRAPDIS_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPDIS_BWERR1T_Pos)                /*!< SCU_TRAP TRAPDIS: BWERR1T Mask          */
#define SCU_TRAP_TRAPDIS_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPDIS: TEMPHIT Position      */
#define SCU_TRAP_TRAPDIS_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPDIS_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPDIS: TEMPHIT Mask          */
#define SCU_TRAP_TRAPDIS_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPDIS: TEMPLOT Position      */
#define SCU_TRAP_TRAPDIS_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPDIS_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPDIS: TEMPLOT Mask          */

/* ------------------------------  SCU_TRAP_TRAPCLR  ------------------------------ */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPCLR: SOSCWDGT Position     */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPCLR_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPCLR: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPCLR: SVCOLCKT Position     */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPCLR_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPCLR: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPCLR: UVCOLCKT Position     */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPCLR_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPCLR: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPCLR_PET_Pos              4                                                       /*!< SCU_TRAP TRAPCLR: PET Position          */
#define SCU_TRAP_TRAPCLR_PET_Msk              (0x01UL << SCU_TRAP_TRAPCLR_PET_Pos)                    /*!< SCU_TRAP TRAPCLR: PET Mask              */
#define SCU_TRAP_TRAPCLR_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPCLR: BRWNT Position        */
#define SCU_TRAP_TRAPCLR_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPCLR_BRWNT_Pos)                  /*!< SCU_TRAP TRAPCLR: BRWNT Mask            */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Pos          6                                                       /*!< SCU_TRAP TRAPCLR: ULPWDGT Position      */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Msk          (0x01UL << SCU_TRAP_TRAPCLR_ULPWDGT_Pos)                /*!< SCU_TRAP TRAPCLR: ULPWDGT Mask          */
#define SCU_TRAP_TRAPCLR_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPCLR: BWERR0T Position      */
#define SCU_TRAP_TRAPCLR_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPCLR_BWERR0T_Pos)                /*!< SCU_TRAP TRAPCLR: BWERR0T Mask          */
#define SCU_TRAP_TRAPCLR_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPCLR: BWERR1T Position      */
#define SCU_TRAP_TRAPCLR_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPCLR_BWERR1T_Pos)                /*!< SCU_TRAP TRAPCLR: BWERR1T Mask          */
#define SCU_TRAP_TRAPCLR_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPCLR: TEMPHIT Position      */
#define SCU_TRAP_TRAPCLR_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPCLR_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPCLR: TEMPHIT Mask          */
#define SCU_TRAP_TRAPCLR_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPCLR: TEMPLOT Position      */
#define SCU_TRAP_TRAPCLR_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPCLR_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPCLR: TEMPLOT Mask          */

/* ------------------------------  SCU_TRAP_TRAPSET  ------------------------------ */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Pos         0                                                       /*!< SCU_TRAP TRAPSET: SOSCWDGT Position     */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Msk         (0x01UL << SCU_TRAP_TRAPSET_SOSCWDGT_Pos)               /*!< SCU_TRAP TRAPSET: SOSCWDGT Mask         */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Pos         2                                                       /*!< SCU_TRAP TRAPSET: SVCOLCKT Position     */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPSET_SVCOLCKT_Pos)               /*!< SCU_TRAP TRAPSET: SVCOLCKT Mask         */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Pos         3                                                       /*!< SCU_TRAP TRAPSET: UVCOLCKT Position     */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Msk         (0x01UL << SCU_TRAP_TRAPSET_UVCOLCKT_Pos)               /*!< SCU_TRAP TRAPSET: UVCOLCKT Mask         */
#define SCU_TRAP_TRAPSET_PET_Pos              4                                                       /*!< SCU_TRAP TRAPSET: PET Position          */
#define SCU_TRAP_TRAPSET_PET_Msk              (0x01UL << SCU_TRAP_TRAPSET_PET_Pos)                    /*!< SCU_TRAP TRAPSET: PET Mask              */
#define SCU_TRAP_TRAPSET_BRWNT_Pos            5                                                       /*!< SCU_TRAP TRAPSET: BRWNT Position        */
#define SCU_TRAP_TRAPSET_BRWNT_Msk            (0x01UL << SCU_TRAP_TRAPSET_BRWNT_Pos)                  /*!< SCU_TRAP TRAPSET: BRWNT Mask            */
#define SCU_TRAP_TRAPSET_ULPWDT_Pos           6                                                       /*!< SCU_TRAP TRAPSET: ULPWDT Position       */
#define SCU_TRAP_TRAPSET_ULPWDT_Msk           (0x01UL << SCU_TRAP_TRAPSET_ULPWDT_Pos)                 /*!< SCU_TRAP TRAPSET: ULPWDT Mask           */
#define SCU_TRAP_TRAPSET_BWERR0T_Pos          7                                                       /*!< SCU_TRAP TRAPSET: BWERR0T Position      */
#define SCU_TRAP_TRAPSET_BWERR0T_Msk          (0x01UL << SCU_TRAP_TRAPSET_BWERR0T_Pos)                /*!< SCU_TRAP TRAPSET: BWERR0T Mask          */
#define SCU_TRAP_TRAPSET_BWERR1T_Pos          8                                                       /*!< SCU_TRAP TRAPSET: BWERR1T Position      */
#define SCU_TRAP_TRAPSET_BWERR1T_Msk          (0x01UL << SCU_TRAP_TRAPSET_BWERR1T_Pos)                /*!< SCU_TRAP TRAPSET: BWERR1T Mask          */
#define SCU_TRAP_TRAPSET_TEMPHIT_Pos          12                                                      /*!< SCU_TRAP TRAPSET: TEMPHIT Position      */
#define SCU_TRAP_TRAPSET_TEMPHIT_Msk          (0x01UL << SCU_TRAP_TRAPSET_TEMPHIT_Pos)                /*!< SCU_TRAP TRAPSET: TEMPHIT Mask          */
#define SCU_TRAP_TRAPSET_TEMPLOT_Pos          13                                                      /*!< SCU_TRAP TRAPSET: TEMPLOT Position      */
#define SCU_TRAP_TRAPSET_TEMPLOT_Msk          (0x01UL << SCU_TRAP_TRAPSET_TEMPLOT_Pos)                /*!< SCU_TRAP TRAPSET: TEMPLOT Mask          */


/* ================================================================================ */
/* ================     struct 'SCU_HIBERNATE' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_HIBERNATE_HDSTAT  ---------------------------- */
#define SCU_HIBERNATE_HDSTAT_EPEV_Pos         0                                                       /*!< SCU_HIBERNATE HDSTAT: EPEV Position     */
#define SCU_HIBERNATE_HDSTAT_EPEV_Msk         (0x01UL << SCU_HIBERNATE_HDSTAT_EPEV_Pos)               /*!< SCU_HIBERNATE HDSTAT: EPEV Mask         */
#define SCU_HIBERNATE_HDSTAT_ENEV_Pos         1                                                       /*!< SCU_HIBERNATE HDSTAT: ENEV Position     */
#define SCU_HIBERNATE_HDSTAT_ENEV_Msk         (0x01UL << SCU_HIBERNATE_HDSTAT_ENEV_Pos)               /*!< SCU_HIBERNATE HDSTAT: ENEV Mask         */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Pos        2                                                       /*!< SCU_HIBERNATE HDSTAT: RTCEV Position    */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Msk        (0x01UL << SCU_HIBERNATE_HDSTAT_RTCEV_Pos)              /*!< SCU_HIBERNATE HDSTAT: RTCEV Mask        */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Pos       3                                                       /*!< SCU_HIBERNATE HDSTAT: ULPWDG Position   */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Msk       (0x01UL << SCU_HIBERNATE_HDSTAT_ULPWDG_Pos)             /*!< SCU_HIBERNATE HDSTAT: ULPWDG Mask       */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Pos      4                                                       /*!< SCU_HIBERNATE HDSTAT: HIBNOUT Position  */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Msk      (0x01UL << SCU_HIBERNATE_HDSTAT_HIBNOUT_Pos)            /*!< SCU_HIBERNATE HDSTAT: HIBNOUT Mask      */
#define SCU_HIBERNATE_HDSTAT_VBATPEV_Pos      8                                                       /*!< SCU_HIBERNATE HDSTAT: VBATPEV Position  */
#define SCU_HIBERNATE_HDSTAT_VBATPEV_Msk      (0x01UL << SCU_HIBERNATE_HDSTAT_VBATPEV_Pos)            /*!< SCU_HIBERNATE HDSTAT: VBATPEV Mask      */
#define SCU_HIBERNATE_HDSTAT_VBATNEV_Pos      9                                                       /*!< SCU_HIBERNATE HDSTAT: VBATNEV Position  */
#define SCU_HIBERNATE_HDSTAT_VBATNEV_Msk      (0x01UL << SCU_HIBERNATE_HDSTAT_VBATNEV_Pos)            /*!< SCU_HIBERNATE HDSTAT: VBATNEV Mask      */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Pos   10                                                      /*!< SCU_HIBERNATE HDSTAT: AHIBIO0PEV Position */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Msk   (0x01UL << SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Pos)         /*!< SCU_HIBERNATE HDSTAT: AHIBIO0PEV Mask   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Pos   11                                                      /*!< SCU_HIBERNATE HDSTAT: AHIBIO0NEV Position */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Msk   (0x01UL << SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Pos)         /*!< SCU_HIBERNATE HDSTAT: AHIBIO0NEV Mask   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1PEV_Pos   12                                                      /*!< SCU_HIBERNATE HDSTAT: AHIBIO1PEV Position */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1PEV_Msk   (0x01UL << SCU_HIBERNATE_HDSTAT_AHIBIO1PEV_Pos)         /*!< SCU_HIBERNATE HDSTAT: AHIBIO1PEV Mask   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1NEV_Pos   13                                                      /*!< SCU_HIBERNATE HDSTAT: AHIBIO1NEV Position */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1NEV_Msk   (0x01UL << SCU_HIBERNATE_HDSTAT_AHIBIO1NEV_Pos)         /*!< SCU_HIBERNATE HDSTAT: AHIBIO1NEV Mask   */

/* -----------------------------  SCU_HIBERNATE_HDCLR  ---------------------------- */
#define SCU_HIBERNATE_HDCLR_EPEV_Pos          0                                                       /*!< SCU_HIBERNATE HDCLR: EPEV Position      */
#define SCU_HIBERNATE_HDCLR_EPEV_Msk          (0x01UL << SCU_HIBERNATE_HDCLR_EPEV_Pos)                /*!< SCU_HIBERNATE HDCLR: EPEV Mask          */
#define SCU_HIBERNATE_HDCLR_ENEV_Pos          1                                                       /*!< SCU_HIBERNATE HDCLR: ENEV Position      */
#define SCU_HIBERNATE_HDCLR_ENEV_Msk          (0x01UL << SCU_HIBERNATE_HDCLR_ENEV_Pos)                /*!< SCU_HIBERNATE HDCLR: ENEV Mask          */
#define SCU_HIBERNATE_HDCLR_RTCEV_Pos         2                                                       /*!< SCU_HIBERNATE HDCLR: RTCEV Position     */
#define SCU_HIBERNATE_HDCLR_RTCEV_Msk         (0x01UL << SCU_HIBERNATE_HDCLR_RTCEV_Pos)               /*!< SCU_HIBERNATE HDCLR: RTCEV Mask         */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Pos        3                                                       /*!< SCU_HIBERNATE HDCLR: ULPWDG Position    */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Msk        (0x01UL << SCU_HIBERNATE_HDCLR_ULPWDG_Pos)              /*!< SCU_HIBERNATE HDCLR: ULPWDG Mask        */
#define SCU_HIBERNATE_HDCLR_VBATPEV_Pos       8                                                       /*!< SCU_HIBERNATE HDCLR: VBATPEV Position   */
#define SCU_HIBERNATE_HDCLR_VBATPEV_Msk       (0x01UL << SCU_HIBERNATE_HDCLR_VBATPEV_Pos)             /*!< SCU_HIBERNATE HDCLR: VBATPEV Mask       */
#define SCU_HIBERNATE_HDCLR_VBATNEV_Pos       9                                                       /*!< SCU_HIBERNATE HDCLR: VBATNEV Position   */
#define SCU_HIBERNATE_HDCLR_VBATNEV_Msk       (0x01UL << SCU_HIBERNATE_HDCLR_VBATNEV_Pos)             /*!< SCU_HIBERNATE HDCLR: VBATNEV Mask       */
#define SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Pos    10                                                      /*!< SCU_HIBERNATE HDCLR: AHIBIO0PEV Position */
#define SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Msk    (0x01UL << SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Pos)          /*!< SCU_HIBERNATE HDCLR: AHIBIO0PEV Mask    */
#define SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Pos    11                                                      /*!< SCU_HIBERNATE HDCLR: AHIBIO0NEV Position */
#define SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Msk    (0x01UL << SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Pos)          /*!< SCU_HIBERNATE HDCLR: AHIBIO0NEV Mask    */
#define SCU_HIBERNATE_HDCLR_AHIBIO1PEV_Pos    12                                                      /*!< SCU_HIBERNATE HDCLR: AHIBIO1PEV Position */
#define SCU_HIBERNATE_HDCLR_AHIBIO1PEV_Msk    (0x01UL << SCU_HIBERNATE_HDCLR_AHIBIO1PEV_Pos)          /*!< SCU_HIBERNATE HDCLR: AHIBIO1PEV Mask    */
#define SCU_HIBERNATE_HDCLR_AHIBIO1NEV_Pos    13                                                      /*!< SCU_HIBERNATE HDCLR: AHIBIO1NEV Position */
#define SCU_HIBERNATE_HDCLR_AHIBIO1NEV_Msk    (0x01UL << SCU_HIBERNATE_HDCLR_AHIBIO1NEV_Pos)          /*!< SCU_HIBERNATE HDCLR: AHIBIO1NEV Mask    */

/* -----------------------------  SCU_HIBERNATE_HDSET  ---------------------------- */
#define SCU_HIBERNATE_HDSET_EPEV_Pos          0                                                       /*!< SCU_HIBERNATE HDSET: EPEV Position      */
#define SCU_HIBERNATE_HDSET_EPEV_Msk          (0x01UL << SCU_HIBERNATE_HDSET_EPEV_Pos)                /*!< SCU_HIBERNATE HDSET: EPEV Mask          */
#define SCU_HIBERNATE_HDSET_ENEV_Pos          1                                                       /*!< SCU_HIBERNATE HDSET: ENEV Position      */
#define SCU_HIBERNATE_HDSET_ENEV_Msk          (0x01UL << SCU_HIBERNATE_HDSET_ENEV_Pos)                /*!< SCU_HIBERNATE HDSET: ENEV Mask          */
#define SCU_HIBERNATE_HDSET_RTCEV_Pos         2                                                       /*!< SCU_HIBERNATE HDSET: RTCEV Position     */
#define SCU_HIBERNATE_HDSET_RTCEV_Msk         (0x01UL << SCU_HIBERNATE_HDSET_RTCEV_Pos)               /*!< SCU_HIBERNATE HDSET: RTCEV Mask         */
#define SCU_HIBERNATE_HDSET_ULPWDG_Pos        3                                                       /*!< SCU_HIBERNATE HDSET: ULPWDG Position    */
#define SCU_HIBERNATE_HDSET_ULPWDG_Msk        (0x01UL << SCU_HIBERNATE_HDSET_ULPWDG_Pos)              /*!< SCU_HIBERNATE HDSET: ULPWDG Mask        */
#define SCU_HIBERNATE_HDSET_VBATPEV_Pos       8                                                       /*!< SCU_HIBERNATE HDSET: VBATPEV Position   */
#define SCU_HIBERNATE_HDSET_VBATPEV_Msk       (0x01UL << SCU_HIBERNATE_HDSET_VBATPEV_Pos)             /*!< SCU_HIBERNATE HDSET: VBATPEV Mask       */
#define SCU_HIBERNATE_HDSET_VBATNEV_Pos       9                                                       /*!< SCU_HIBERNATE HDSET: VBATNEV Position   */
#define SCU_HIBERNATE_HDSET_VBATNEV_Msk       (0x01UL << SCU_HIBERNATE_HDSET_VBATNEV_Pos)             /*!< SCU_HIBERNATE HDSET: VBATNEV Mask       */
#define SCU_HIBERNATE_HDSET_AHIBIO0PEV_Pos    10                                                      /*!< SCU_HIBERNATE HDSET: AHIBIO0PEV Position */
#define SCU_HIBERNATE_HDSET_AHIBIO0PEV_Msk    (0x01UL << SCU_HIBERNATE_HDSET_AHIBIO0PEV_Pos)          /*!< SCU_HIBERNATE HDSET: AHIBIO0PEV Mask    */
#define SCU_HIBERNATE_HDSET_AHIBIO0NEV_Pos    11                                                      /*!< SCU_HIBERNATE HDSET: AHIBIO0NEV Position */
#define SCU_HIBERNATE_HDSET_AHIBIO0NEV_Msk    (0x01UL << SCU_HIBERNATE_HDSET_AHIBIO0NEV_Pos)          /*!< SCU_HIBERNATE HDSET: AHIBIO0NEV Mask    */
#define SCU_HIBERNATE_HDSET_AHIBIO1PEV_Pos    12                                                      /*!< SCU_HIBERNATE HDSET: AHIBIO1PEV Position */
#define SCU_HIBERNATE_HDSET_AHIBIO1PEV_Msk    (0x01UL << SCU_HIBERNATE_HDSET_AHIBIO1PEV_Pos)          /*!< SCU_HIBERNATE HDSET: AHIBIO1PEV Mask    */
#define SCU_HIBERNATE_HDSET_AHIBIO1NEV_Pos    13                                                      /*!< SCU_HIBERNATE HDSET: AHIBIO1NEV Position */
#define SCU_HIBERNATE_HDSET_AHIBIO1NEV_Msk    (0x01UL << SCU_HIBERNATE_HDSET_AHIBIO1NEV_Pos)          /*!< SCU_HIBERNATE HDSET: AHIBIO1NEV Mask    */

/* -----------------------------  SCU_HIBERNATE_HDCR  ----------------------------- */
#define SCU_HIBERNATE_HDCR_WKPEP_Pos          0                                                       /*!< SCU_HIBERNATE HDCR: WKPEP Position      */
#define SCU_HIBERNATE_HDCR_WKPEP_Msk          (0x01UL << SCU_HIBERNATE_HDCR_WKPEP_Pos)                /*!< SCU_HIBERNATE HDCR: WKPEP Mask          */
#define SCU_HIBERNATE_HDCR_WKPEN_Pos          1                                                       /*!< SCU_HIBERNATE HDCR: WKPEN Position      */
#define SCU_HIBERNATE_HDCR_WKPEN_Msk          (0x01UL << SCU_HIBERNATE_HDCR_WKPEN_Pos)                /*!< SCU_HIBERNATE HDCR: WKPEN Mask          */
#define SCU_HIBERNATE_HDCR_RTCE_Pos           2                                                       /*!< SCU_HIBERNATE HDCR: RTCE Position       */
#define SCU_HIBERNATE_HDCR_RTCE_Msk           (0x01UL << SCU_HIBERNATE_HDCR_RTCE_Pos)                 /*!< SCU_HIBERNATE HDCR: RTCE Mask           */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Pos       3                                                       /*!< SCU_HIBERNATE HDCR: ULPWDGEN Position   */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Msk       (0x01UL << SCU_HIBERNATE_HDCR_ULPWDGEN_Pos)             /*!< SCU_HIBERNATE HDCR: ULPWDGEN Mask       */
#define SCU_HIBERNATE_HDCR_HIB_Pos            4                                                       /*!< SCU_HIBERNATE HDCR: HIB Position        */
#define SCU_HIBERNATE_HDCR_HIB_Msk            (0x01UL << SCU_HIBERNATE_HDCR_HIB_Pos)                  /*!< SCU_HIBERNATE HDCR: HIB Mask            */
#define SCU_HIBERNATE_HDCR_XTALGPI1SEL_Pos    5                                                       /*!< SCU_HIBERNATE HDCR: XTALGPI1SEL Position */
#define SCU_HIBERNATE_HDCR_XTALGPI1SEL_Msk    (0x01UL << SCU_HIBERNATE_HDCR_XTALGPI1SEL_Pos)          /*!< SCU_HIBERNATE HDCR: XTALGPI1SEL Mask    */
#define SCU_HIBERNATE_HDCR_RCS_Pos            6                                                       /*!< SCU_HIBERNATE HDCR: RCS Position        */
#define SCU_HIBERNATE_HDCR_RCS_Msk            (0x01UL << SCU_HIBERNATE_HDCR_RCS_Pos)                  /*!< SCU_HIBERNATE HDCR: RCS Mask            */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Pos       7                                                       /*!< SCU_HIBERNATE HDCR: STDBYSEL Position   */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Msk       (0x01UL << SCU_HIBERNATE_HDCR_STDBYSEL_Pos)             /*!< SCU_HIBERNATE HDCR: STDBYSEL Mask       */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Pos        8                                                       /*!< SCU_HIBERNATE HDCR: WKUPSEL Position    */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Msk        (0x01UL << SCU_HIBERNATE_HDCR_WKUPSEL_Pos)              /*!< SCU_HIBERNATE HDCR: WKUPSEL Mask        */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Pos        10                                                      /*!< SCU_HIBERNATE HDCR: GPI0SEL Position    */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Msk        (0x01UL << SCU_HIBERNATE_HDCR_GPI0SEL_Pos)              /*!< SCU_HIBERNATE HDCR: GPI0SEL Mask        */
#define SCU_HIBERNATE_HDCR_GPI1SEL_Pos        11                                                      /*!< SCU_HIBERNATE HDCR: GPI1SEL Position    */
#define SCU_HIBERNATE_HDCR_GPI1SEL_Msk        (0x01UL << SCU_HIBERNATE_HDCR_GPI1SEL_Pos)              /*!< SCU_HIBERNATE HDCR: GPI1SEL Mask        */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Pos      12                                                      /*!< SCU_HIBERNATE HDCR: HIBIO0POL Position  */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Msk      (0x01UL << SCU_HIBERNATE_HDCR_HIBIO0POL_Pos)            /*!< SCU_HIBERNATE HDCR: HIBIO0POL Mask      */
#define SCU_HIBERNATE_HDCR_HIBIO1POL_Pos      13                                                      /*!< SCU_HIBERNATE HDCR: HIBIO1POL Position  */
#define SCU_HIBERNATE_HDCR_HIBIO1POL_Msk      (0x01UL << SCU_HIBERNATE_HDCR_HIBIO1POL_Pos)            /*!< SCU_HIBERNATE HDCR: HIBIO1POL Mask      */
#define SCU_HIBERNATE_HDCR_ADIG0SEL_Pos       14                                                      /*!< SCU_HIBERNATE HDCR: ADIG0SEL Position   */
#define SCU_HIBERNATE_HDCR_ADIG0SEL_Msk       (0x01UL << SCU_HIBERNATE_HDCR_ADIG0SEL_Pos)             /*!< SCU_HIBERNATE HDCR: ADIG0SEL Mask       */
#define SCU_HIBERNATE_HDCR_ADIG1SEL_Pos       15                                                      /*!< SCU_HIBERNATE HDCR: ADIG1SEL Position   */
#define SCU_HIBERNATE_HDCR_ADIG1SEL_Msk       (0x01UL << SCU_HIBERNATE_HDCR_ADIG1SEL_Pos)             /*!< SCU_HIBERNATE HDCR: ADIG1SEL Mask       */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Pos      16                                                      /*!< SCU_HIBERNATE HDCR: HIBIO0SEL Position  */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Msk      (0x0fUL << SCU_HIBERNATE_HDCR_HIBIO0SEL_Pos)            /*!< SCU_HIBERNATE HDCR: HIBIO0SEL Mask      */
#define SCU_HIBERNATE_HDCR_HIBIO1SEL_Pos      20                                                      /*!< SCU_HIBERNATE HDCR: HIBIO1SEL Position  */
#define SCU_HIBERNATE_HDCR_HIBIO1SEL_Msk      (0x0fUL << SCU_HIBERNATE_HDCR_HIBIO1SEL_Pos)            /*!< SCU_HIBERNATE HDCR: HIBIO1SEL Mask      */
#define SCU_HIBERNATE_HDCR_VBATLO_Pos         24                                                      /*!< SCU_HIBERNATE HDCR: VBATLO Position     */
#define SCU_HIBERNATE_HDCR_VBATLO_Msk         (0x01UL << SCU_HIBERNATE_HDCR_VBATLO_Pos)               /*!< SCU_HIBERNATE HDCR: VBATLO Mask         */
#define SCU_HIBERNATE_HDCR_VBATHI_Pos         25                                                      /*!< SCU_HIBERNATE HDCR: VBATHI Position     */
#define SCU_HIBERNATE_HDCR_VBATHI_Msk         (0x01UL << SCU_HIBERNATE_HDCR_VBATHI_Pos)               /*!< SCU_HIBERNATE HDCR: VBATHI Mask         */
#define SCU_HIBERNATE_HDCR_AHIBIO0LO_Pos      26                                                      /*!< SCU_HIBERNATE HDCR: AHIBIO0LO Position  */
#define SCU_HIBERNATE_HDCR_AHIBIO0LO_Msk      (0x01UL << SCU_HIBERNATE_HDCR_AHIBIO0LO_Pos)            /*!< SCU_HIBERNATE HDCR: AHIBIO0LO Mask      */
#define SCU_HIBERNATE_HDCR_AHIBIO0HI_Pos      27                                                      /*!< SCU_HIBERNATE HDCR: AHIBIO0HI Position  */
#define SCU_HIBERNATE_HDCR_AHIBIO0HI_Msk      (0x01UL << SCU_HIBERNATE_HDCR_AHIBIO0HI_Pos)            /*!< SCU_HIBERNATE HDCR: AHIBIO0HI Mask      */
#define SCU_HIBERNATE_HDCR_AHIBIO1LO_Pos      28                                                      /*!< SCU_HIBERNATE HDCR: AHIBIO1LO Position  */
#define SCU_HIBERNATE_HDCR_AHIBIO1LO_Msk      (0x01UL << SCU_HIBERNATE_HDCR_AHIBIO1LO_Pos)            /*!< SCU_HIBERNATE HDCR: AHIBIO1LO Mask      */
#define SCU_HIBERNATE_HDCR_AHIBIO1HI_Pos      29                                                      /*!< SCU_HIBERNATE HDCR: AHIBIO1HI Position  */
#define SCU_HIBERNATE_HDCR_AHIBIO1HI_Msk      (0x01UL << SCU_HIBERNATE_HDCR_AHIBIO1HI_Pos)            /*!< SCU_HIBERNATE HDCR: AHIBIO1HI Mask      */

/* ---------------------------  SCU_HIBERNATE_OSCSICTRL  -------------------------- */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Pos       0                                                       /*!< SCU_HIBERNATE OSCSICTRL: PWD Position   */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Msk       (0x01UL << SCU_HIBERNATE_OSCSICTRL_PWD_Pos)             /*!< SCU_HIBERNATE OSCSICTRL: PWD Mask       */

/* ---------------------------  SCU_HIBERNATE_OSCULSTAT  -------------------------- */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Pos       0                                                       /*!< SCU_HIBERNATE OSCULSTAT: X1D Position   */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Msk       (0x01UL << SCU_HIBERNATE_OSCULSTAT_X1D_Pos)             /*!< SCU_HIBERNATE OSCULSTAT: X1D Mask       */

/* ---------------------------  SCU_HIBERNATE_OSCULCTRL  -------------------------- */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Pos     0                                                       /*!< SCU_HIBERNATE OSCULCTRL: X1DEN Position */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Msk     (0x01UL << SCU_HIBERNATE_OSCULCTRL_X1DEN_Pos)           /*!< SCU_HIBERNATE OSCULCTRL: X1DEN Mask     */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Pos      4                                                       /*!< SCU_HIBERNATE OSCULCTRL: MODE Position  */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Msk      (0x03UL << SCU_HIBERNATE_OSCULCTRL_MODE_Pos)            /*!< SCU_HIBERNATE OSCULCTRL: MODE Mask      */

/* ---------------------------  SCU_HIBERNATE_LPACCONF  --------------------------- */
#define SCU_HIBERNATE_LPACCONF_CMPEN_Pos      0                                                       /*!< SCU_HIBERNATE LPACCONF: CMPEN Position  */
#define SCU_HIBERNATE_LPACCONF_CMPEN_Msk      (0x07UL << SCU_HIBERNATE_LPACCONF_CMPEN_Pos)            /*!< SCU_HIBERNATE LPACCONF: CMPEN Mask      */
#define SCU_HIBERNATE_LPACCONF_TRIGSEL_Pos    4                                                       /*!< SCU_HIBERNATE LPACCONF: TRIGSEL Position */
#define SCU_HIBERNATE_LPACCONF_TRIGSEL_Msk    (0x07UL << SCU_HIBERNATE_LPACCONF_TRIGSEL_Pos)          /*!< SCU_HIBERNATE LPACCONF: TRIGSEL Mask    */
#define SCU_HIBERNATE_LPACCONF_CONVDEL_Pos    12                                                      /*!< SCU_HIBERNATE LPACCONF: CONVDEL Position */
#define SCU_HIBERNATE_LPACCONF_CONVDEL_Msk    (0x01UL << SCU_HIBERNATE_LPACCONF_CONVDEL_Pos)          /*!< SCU_HIBERNATE LPACCONF: CONVDEL Mask    */
#define SCU_HIBERNATE_LPACCONF_INTERVCNT_Pos  16                                                      /*!< SCU_HIBERNATE LPACCONF: INTERVCNT Position */
#define SCU_HIBERNATE_LPACCONF_INTERVCNT_Msk  (0x00000fffUL << SCU_HIBERNATE_LPACCONF_INTERVCNT_Pos)  /*!< SCU_HIBERNATE LPACCONF: INTERVCNT Mask  */
#define SCU_HIBERNATE_LPACCONF_SETTLECNT_Pos  28                                                      /*!< SCU_HIBERNATE LPACCONF: SETTLECNT Position */
#define SCU_HIBERNATE_LPACCONF_SETTLECNT_Msk  (0x0fUL << SCU_HIBERNATE_LPACCONF_SETTLECNT_Pos)        /*!< SCU_HIBERNATE LPACCONF: SETTLECNT Mask  */

/* ----------------------------  SCU_HIBERNATE_LPACTH0  --------------------------- */
#define SCU_HIBERNATE_LPACTH0_VBATLO_Pos      0                                                       /*!< SCU_HIBERNATE LPACTH0: VBATLO Position  */
#define SCU_HIBERNATE_LPACTH0_VBATLO_Msk      (0x3fUL << SCU_HIBERNATE_LPACTH0_VBATLO_Pos)            /*!< SCU_HIBERNATE LPACTH0: VBATLO Mask      */
#define SCU_HIBERNATE_LPACTH0_VBATHI_Pos      8                                                       /*!< SCU_HIBERNATE LPACTH0: VBATHI Position  */
#define SCU_HIBERNATE_LPACTH0_VBATHI_Msk      (0x3fUL << SCU_HIBERNATE_LPACTH0_VBATHI_Pos)            /*!< SCU_HIBERNATE LPACTH0: VBATHI Mask      */

/* ----------------------------  SCU_HIBERNATE_LPACTH1  --------------------------- */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0LO_Pos   0                                                       /*!< SCU_HIBERNATE LPACTH1: AHIBIO0LO Position */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0LO_Msk   (0x3fUL << SCU_HIBERNATE_LPACTH1_AHIBIO0LO_Pos)         /*!< SCU_HIBERNATE LPACTH1: AHIBIO0LO Mask   */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0HI_Pos   8                                                       /*!< SCU_HIBERNATE LPACTH1: AHIBIO0HI Position */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0HI_Msk   (0x3fUL << SCU_HIBERNATE_LPACTH1_AHIBIO0HI_Pos)         /*!< SCU_HIBERNATE LPACTH1: AHIBIO0HI Mask   */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1LO_Pos   16                                                      /*!< SCU_HIBERNATE LPACTH1: AHIBIO1LO Position */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1LO_Msk   (0x3fUL << SCU_HIBERNATE_LPACTH1_AHIBIO1LO_Pos)         /*!< SCU_HIBERNATE LPACTH1: AHIBIO1LO Mask   */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1HI_Pos   24                                                      /*!< SCU_HIBERNATE LPACTH1: AHIBIO1HI Position */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1HI_Msk   (0x3fUL << SCU_HIBERNATE_LPACTH1_AHIBIO1HI_Pos)         /*!< SCU_HIBERNATE LPACTH1: AHIBIO1HI Mask   */

/* ----------------------------  SCU_HIBERNATE_LPACST  ---------------------------- */
#define SCU_HIBERNATE_LPACST_VBATSCMP_Pos     0                                                       /*!< SCU_HIBERNATE LPACST: VBATSCMP Position */
#define SCU_HIBERNATE_LPACST_VBATSCMP_Msk     (0x01UL << SCU_HIBERNATE_LPACST_VBATSCMP_Pos)           /*!< SCU_HIBERNATE LPACST: VBATSCMP Mask     */
#define SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Pos  1                                                       /*!< SCU_HIBERNATE LPACST: AHIBIO0SCMP Position */
#define SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Msk  (0x01UL << SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Pos)        /*!< SCU_HIBERNATE LPACST: AHIBIO0SCMP Mask  */
#define SCU_HIBERNATE_LPACST_AHIBIO1SCMP_Pos  2                                                       /*!< SCU_HIBERNATE LPACST: AHIBIO1SCMP Position */
#define SCU_HIBERNATE_LPACST_AHIBIO1SCMP_Msk  (0x01UL << SCU_HIBERNATE_LPACST_AHIBIO1SCMP_Pos)        /*!< SCU_HIBERNATE LPACST: AHIBIO1SCMP Mask  */
#define SCU_HIBERNATE_LPACST_VBATVAL_Pos      16                                                      /*!< SCU_HIBERNATE LPACST: VBATVAL Position  */
#define SCU_HIBERNATE_LPACST_VBATVAL_Msk      (0x01UL << SCU_HIBERNATE_LPACST_VBATVAL_Pos)            /*!< SCU_HIBERNATE LPACST: VBATVAL Mask      */
#define SCU_HIBERNATE_LPACST_AHIBIO0VAL_Pos   17                                                      /*!< SCU_HIBERNATE LPACST: AHIBIO0VAL Position */
#define SCU_HIBERNATE_LPACST_AHIBIO0VAL_Msk   (0x01UL << SCU_HIBERNATE_LPACST_AHIBIO0VAL_Pos)         /*!< SCU_HIBERNATE LPACST: AHIBIO0VAL Mask   */
#define SCU_HIBERNATE_LPACST_AHIBIO1VAL_Pos   18                                                      /*!< SCU_HIBERNATE LPACST: AHIBIO1VAL Position */
#define SCU_HIBERNATE_LPACST_AHIBIO1VAL_Msk   (0x01UL << SCU_HIBERNATE_LPACST_AHIBIO1VAL_Pos)         /*!< SCU_HIBERNATE LPACST: AHIBIO1VAL Mask   */

/* ----------------------------  SCU_HIBERNATE_LPACCLR  --------------------------- */
#define SCU_HIBERNATE_LPACCLR_VBATSCMP_Pos    0                                                       /*!< SCU_HIBERNATE LPACCLR: VBATSCMP Position */
#define SCU_HIBERNATE_LPACCLR_VBATSCMP_Msk    (0x01UL << SCU_HIBERNATE_LPACCLR_VBATSCMP_Pos)          /*!< SCU_HIBERNATE LPACCLR: VBATSCMP Mask    */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Pos 1                                                       /*!< SCU_HIBERNATE LPACCLR: AHIBIO0SCMP Position */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Msk (0x01UL << SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Pos)       /*!< SCU_HIBERNATE LPACCLR: AHIBIO0SCMP Mask */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1SCMP_Pos 2                                                       /*!< SCU_HIBERNATE LPACCLR: AHIBIO1SCMP Position */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1SCMP_Msk (0x01UL << SCU_HIBERNATE_LPACCLR_AHIBIO1SCMP_Pos)       /*!< SCU_HIBERNATE LPACCLR: AHIBIO1SCMP Mask */
#define SCU_HIBERNATE_LPACCLR_VBATVAL_Pos     16                                                      /*!< SCU_HIBERNATE LPACCLR: VBATVAL Position */
#define SCU_HIBERNATE_LPACCLR_VBATVAL_Msk     (0x01UL << SCU_HIBERNATE_LPACCLR_VBATVAL_Pos)           /*!< SCU_HIBERNATE LPACCLR: VBATVAL Mask     */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Pos  17                                                      /*!< SCU_HIBERNATE LPACCLR: AHIBIO0VAL Position */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Msk  (0x01UL << SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Pos)        /*!< SCU_HIBERNATE LPACCLR: AHIBIO0VAL Mask  */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1VAL_Pos  18                                                      /*!< SCU_HIBERNATE LPACCLR: AHIBIO1VAL Position */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1VAL_Msk  (0x01UL << SCU_HIBERNATE_LPACCLR_AHIBIO1VAL_Pos)        /*!< SCU_HIBERNATE LPACCLR: AHIBIO1VAL Mask  */

/* ----------------------------  SCU_HIBERNATE_LPACSET  --------------------------- */
#define SCU_HIBERNATE_LPACSET_VBATSCMP_Pos    0                                                       /*!< SCU_HIBERNATE LPACSET: VBATSCMP Position */
#define SCU_HIBERNATE_LPACSET_VBATSCMP_Msk    (0x01UL << SCU_HIBERNATE_LPACSET_VBATSCMP_Pos)          /*!< SCU_HIBERNATE LPACSET: VBATSCMP Mask    */
#define SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Pos 1                                                       /*!< SCU_HIBERNATE LPACSET: AHIBIO0SCMP Position */
#define SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Msk (0x01UL << SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Pos)       /*!< SCU_HIBERNATE LPACSET: AHIBIO0SCMP Mask */
#define SCU_HIBERNATE_LPACSET_AHIBIO1SCMP_Pos 2                                                       /*!< SCU_HIBERNATE LPACSET: AHIBIO1SCMP Position */
#define SCU_HIBERNATE_LPACSET_AHIBIO1SCMP_Msk (0x01UL << SCU_HIBERNATE_LPACSET_AHIBIO1SCMP_Pos)       /*!< SCU_HIBERNATE LPACSET: AHIBIO1SCMP Mask */
#define SCU_HIBERNATE_LPACSET_VBATVAL_Pos     16                                                      /*!< SCU_HIBERNATE LPACSET: VBATVAL Position */
#define SCU_HIBERNATE_LPACSET_VBATVAL_Msk     (0x01UL << SCU_HIBERNATE_LPACSET_VBATVAL_Pos)           /*!< SCU_HIBERNATE LPACSET: VBATVAL Mask     */
#define SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Pos  17                                                      /*!< SCU_HIBERNATE LPACSET: AHIBIO0VAL Position */
#define SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Msk  (0x01UL << SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Pos)        /*!< SCU_HIBERNATE LPACSET: AHIBIO0VAL Mask  */
#define SCU_HIBERNATE_LPACSET_AHIBIO1VAL_Pos  18                                                      /*!< SCU_HIBERNATE LPACSET: AHIBIO1VAL Position */
#define SCU_HIBERNATE_LPACSET_AHIBIO1VAL_Msk  (0x01UL << SCU_HIBERNATE_LPACSET_AHIBIO1VAL_Pos)        /*!< SCU_HIBERNATE LPACSET: AHIBIO1VAL Mask  */

/* ----------------------------  SCU_HIBERNATE_HINTST  ---------------------------- */
#define SCU_HIBERNATE_HINTST_HIBNINT_Pos      0                                                       /*!< SCU_HIBERNATE HINTST: HIBNINT Position  */
#define SCU_HIBERNATE_HINTST_HIBNINT_Msk      (0x01UL << SCU_HIBERNATE_HINTST_HIBNINT_Pos)            /*!< SCU_HIBERNATE HINTST: HIBNINT Mask      */
#define SCU_HIBERNATE_HINTST_FLASHOFF_Pos     2                                                       /*!< SCU_HIBERNATE HINTST: FLASHOFF Position */
#define SCU_HIBERNATE_HINTST_FLASHOFF_Msk     (0x01UL << SCU_HIBERNATE_HINTST_FLASHOFF_Pos)           /*!< SCU_HIBERNATE HINTST: FLASHOFF Mask     */
#define SCU_HIBERNATE_HINTST_FLASHPD_Pos      3                                                       /*!< SCU_HIBERNATE HINTST: FLASHPD Position  */
#define SCU_HIBERNATE_HINTST_FLASHPD_Msk      (0x01UL << SCU_HIBERNATE_HINTST_FLASHPD_Pos)            /*!< SCU_HIBERNATE HINTST: FLASHPD Mask      */
#define SCU_HIBERNATE_HINTST_POFFD_Pos        4                                                       /*!< SCU_HIBERNATE HINTST: POFFD Position    */
#define SCU_HIBERNATE_HINTST_POFFD_Msk        (0x01UL << SCU_HIBERNATE_HINTST_POFFD_Pos)              /*!< SCU_HIBERNATE HINTST: POFFD Mask        */
#define SCU_HIBERNATE_HINTST_PPODEL_Pos       16                                                      /*!< SCU_HIBERNATE HINTST: PPODEL Position   */
#define SCU_HIBERNATE_HINTST_PPODEL_Msk       (0x03UL << SCU_HIBERNATE_HINTST_PPODEL_Pos)             /*!< SCU_HIBERNATE HINTST: PPODEL Mask       */
#define SCU_HIBERNATE_HINTST_POFFH_Pos        20                                                      /*!< SCU_HIBERNATE HINTST: POFFH Position    */
#define SCU_HIBERNATE_HINTST_POFFH_Msk        (0x01UL << SCU_HIBERNATE_HINTST_POFFH_Pos)              /*!< SCU_HIBERNATE HINTST: POFFH Mask        */

/* ----------------------------  SCU_HIBERNATE_HINTCLR  --------------------------- */
#define SCU_HIBERNATE_HINTCLR_HIBNINT_Pos     0                                                       /*!< SCU_HIBERNATE HINTCLR: HIBNINT Position */
#define SCU_HIBERNATE_HINTCLR_HIBNINT_Msk     (0x01UL << SCU_HIBERNATE_HINTCLR_HIBNINT_Pos)           /*!< SCU_HIBERNATE HINTCLR: HIBNINT Mask     */
#define SCU_HIBERNATE_HINTCLR_FLASHOFF_Pos    2                                                       /*!< SCU_HIBERNATE HINTCLR: FLASHOFF Position */
#define SCU_HIBERNATE_HINTCLR_FLASHOFF_Msk    (0x01UL << SCU_HIBERNATE_HINTCLR_FLASHOFF_Pos)          /*!< SCU_HIBERNATE HINTCLR: FLASHOFF Mask    */
#define SCU_HIBERNATE_HINTCLR_FLASHPD_Pos     3                                                       /*!< SCU_HIBERNATE HINTCLR: FLASHPD Position */
#define SCU_HIBERNATE_HINTCLR_FLASHPD_Msk     (0x01UL << SCU_HIBERNATE_HINTCLR_FLASHPD_Pos)           /*!< SCU_HIBERNATE HINTCLR: FLASHPD Mask     */
#define SCU_HIBERNATE_HINTCLR_POFFD_Pos       4                                                       /*!< SCU_HIBERNATE HINTCLR: POFFD Position   */
#define SCU_HIBERNATE_HINTCLR_POFFD_Msk       (0x01UL << SCU_HIBERNATE_HINTCLR_POFFD_Pos)             /*!< SCU_HIBERNATE HINTCLR: POFFD Mask       */
#define SCU_HIBERNATE_HINTCLR_PPODEL_Pos      16                                                      /*!< SCU_HIBERNATE HINTCLR: PPODEL Position  */
#define SCU_HIBERNATE_HINTCLR_PPODEL_Msk      (0x03UL << SCU_HIBERNATE_HINTCLR_PPODEL_Pos)            /*!< SCU_HIBERNATE HINTCLR: PPODEL Mask      */
#define SCU_HIBERNATE_HINTCLR_POFFH_Pos       20                                                      /*!< SCU_HIBERNATE HINTCLR: POFFH Position   */
#define SCU_HIBERNATE_HINTCLR_POFFH_Msk       (0x01UL << SCU_HIBERNATE_HINTCLR_POFFH_Pos)             /*!< SCU_HIBERNATE HINTCLR: POFFH Mask       */

/* ----------------------------  SCU_HIBERNATE_HINTSET  --------------------------- */
#define SCU_HIBERNATE_HINTSET_HIBNINT_Pos     0                                                       /*!< SCU_HIBERNATE HINTSET: HIBNINT Position */
#define SCU_HIBERNATE_HINTSET_HIBNINT_Msk     (0x01UL << SCU_HIBERNATE_HINTSET_HIBNINT_Pos)           /*!< SCU_HIBERNATE HINTSET: HIBNINT Mask     */
#define SCU_HIBERNATE_HINTSET_VCOREOFF_Pos    1                                                       /*!< SCU_HIBERNATE HINTSET: VCOREOFF Position */
#define SCU_HIBERNATE_HINTSET_VCOREOFF_Msk    (0x01UL << SCU_HIBERNATE_HINTSET_VCOREOFF_Pos)          /*!< SCU_HIBERNATE HINTSET: VCOREOFF Mask    */
#define SCU_HIBERNATE_HINTSET_FLASHOFF_Pos    2                                                       /*!< SCU_HIBERNATE HINTSET: FLASHOFF Position */
#define SCU_HIBERNATE_HINTSET_FLASHOFF_Msk    (0x01UL << SCU_HIBERNATE_HINTSET_FLASHOFF_Pos)          /*!< SCU_HIBERNATE HINTSET: FLASHOFF Mask    */
#define SCU_HIBERNATE_HINTSET_FLASHPD_Pos     3                                                       /*!< SCU_HIBERNATE HINTSET: FLASHPD Position */
#define SCU_HIBERNATE_HINTSET_FLASHPD_Msk     (0x01UL << SCU_HIBERNATE_HINTSET_FLASHPD_Pos)           /*!< SCU_HIBERNATE HINTSET: FLASHPD Mask     */
#define SCU_HIBERNATE_HINTSET_POFFD_Pos       4                                                       /*!< SCU_HIBERNATE HINTSET: POFFD Position   */
#define SCU_HIBERNATE_HINTSET_POFFD_Msk       (0x01UL << SCU_HIBERNATE_HINTSET_POFFD_Pos)             /*!< SCU_HIBERNATE HINTSET: POFFD Mask       */
#define SCU_HIBERNATE_HINTSET_PPODEL_Pos      16                                                      /*!< SCU_HIBERNATE HINTSET: PPODEL Position  */
#define SCU_HIBERNATE_HINTSET_PPODEL_Msk      (0x03UL << SCU_HIBERNATE_HINTSET_PPODEL_Pos)            /*!< SCU_HIBERNATE HINTSET: PPODEL Mask      */
#define SCU_HIBERNATE_HINTSET_POFFH_Pos       20                                                      /*!< SCU_HIBERNATE HINTSET: POFFH Position   */
#define SCU_HIBERNATE_HINTSET_POFFH_Msk       (0x01UL << SCU_HIBERNATE_HINTSET_POFFH_Pos)             /*!< SCU_HIBERNATE HINTSET: POFFH Mask       */


/* ================================================================================ */
/* ================       struct 'SCU_POWER' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_POWER_PWRSTAT  ----------------------------- */
#define SCU_POWER_PWRSTAT_HIBEN_Pos           0                                                       /*!< SCU_POWER PWRSTAT: HIBEN Position       */
#define SCU_POWER_PWRSTAT_HIBEN_Msk           (0x01UL << SCU_POWER_PWRSTAT_HIBEN_Pos)                 /*!< SCU_POWER PWRSTAT: HIBEN Mask           */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Pos       16                                                      /*!< SCU_POWER PWRSTAT: USBPHYPDQ Position   */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Msk       (0x01UL << SCU_POWER_PWRSTAT_USBPHYPDQ_Pos)             /*!< SCU_POWER PWRSTAT: USBPHYPDQ Mask       */
#define SCU_POWER_PWRSTAT_USBOTGEN_Pos        17                                                      /*!< SCU_POWER PWRSTAT: USBOTGEN Position    */
#define SCU_POWER_PWRSTAT_USBOTGEN_Msk        (0x01UL << SCU_POWER_PWRSTAT_USBOTGEN_Pos)              /*!< SCU_POWER PWRSTAT: USBOTGEN Mask        */
#define SCU_POWER_PWRSTAT_USBPUWQ_Pos         18                                                      /*!< SCU_POWER PWRSTAT: USBPUWQ Position     */
#define SCU_POWER_PWRSTAT_USBPUWQ_Msk         (0x01UL << SCU_POWER_PWRSTAT_USBPUWQ_Pos)               /*!< SCU_POWER PWRSTAT: USBPUWQ Mask         */

/* ------------------------------  SCU_POWER_PWRSET  ------------------------------ */
#define SCU_POWER_PWRSET_HIB_Pos              0                                                       /*!< SCU_POWER PWRSET: HIB Position          */
#define SCU_POWER_PWRSET_HIB_Msk              (0x01UL << SCU_POWER_PWRSET_HIB_Pos)                    /*!< SCU_POWER PWRSET: HIB Mask              */
#define SCU_POWER_PWRSET_USBPHYPDQ_Pos        16                                                      /*!< SCU_POWER PWRSET: USBPHYPDQ Position    */
#define SCU_POWER_PWRSET_USBPHYPDQ_Msk        (0x01UL << SCU_POWER_PWRSET_USBPHYPDQ_Pos)              /*!< SCU_POWER PWRSET: USBPHYPDQ Mask        */
#define SCU_POWER_PWRSET_USBOTGEN_Pos         17                                                      /*!< SCU_POWER PWRSET: USBOTGEN Position     */
#define SCU_POWER_PWRSET_USBOTGEN_Msk         (0x01UL << SCU_POWER_PWRSET_USBOTGEN_Pos)               /*!< SCU_POWER PWRSET: USBOTGEN Mask         */
#define SCU_POWER_PWRSET_USBPUWQ_Pos          18                                                      /*!< SCU_POWER PWRSET: USBPUWQ Position      */
#define SCU_POWER_PWRSET_USBPUWQ_Msk          (0x01UL << SCU_POWER_PWRSET_USBPUWQ_Pos)                /*!< SCU_POWER PWRSET: USBPUWQ Mask          */

/* ------------------------------  SCU_POWER_PWRCLR  ------------------------------ */
#define SCU_POWER_PWRCLR_HIB_Pos              0                                                       /*!< SCU_POWER PWRCLR: HIB Position          */
#define SCU_POWER_PWRCLR_HIB_Msk              (0x01UL << SCU_POWER_PWRCLR_HIB_Pos)                    /*!< SCU_POWER PWRCLR: HIB Mask              */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Pos        16                                                      /*!< SCU_POWER PWRCLR: USBPHYPDQ Position    */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Msk        (0x01UL << SCU_POWER_PWRCLR_USBPHYPDQ_Pos)              /*!< SCU_POWER PWRCLR: USBPHYPDQ Mask        */
#define SCU_POWER_PWRCLR_USBOTGEN_Pos         17                                                      /*!< SCU_POWER PWRCLR: USBOTGEN Position     */
#define SCU_POWER_PWRCLR_USBOTGEN_Msk         (0x01UL << SCU_POWER_PWRCLR_USBOTGEN_Pos)               /*!< SCU_POWER PWRCLR: USBOTGEN Mask         */
#define SCU_POWER_PWRCLR_USBPUWQ_Pos          18                                                      /*!< SCU_POWER PWRCLR: USBPUWQ Position      */
#define SCU_POWER_PWRCLR_USBPUWQ_Msk          (0x01UL << SCU_POWER_PWRCLR_USBPUWQ_Pos)                /*!< SCU_POWER PWRCLR: USBPUWQ Mask          */

/* ------------------------------  SCU_POWER_EVRSTAT  ----------------------------- */
#define SCU_POWER_EVRSTAT_OV13_Pos            1                                                       /*!< SCU_POWER EVRSTAT: OV13 Position        */
#define SCU_POWER_EVRSTAT_OV13_Msk            (0x01UL << SCU_POWER_EVRSTAT_OV13_Pos)                  /*!< SCU_POWER EVRSTAT: OV13 Mask            */

/* ----------------------------  SCU_POWER_EVRVADCSTAT  --------------------------- */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Pos     0                                                       /*!< SCU_POWER EVRVADCSTAT: VADC13V Position */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Msk     (0x000000ffUL << SCU_POWER_EVRVADCSTAT_VADC13V_Pos)     /*!< SCU_POWER EVRVADCSTAT: VADC13V Mask     */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Pos     8                                                       /*!< SCU_POWER EVRVADCSTAT: VADC33V Position */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Msk     (0x000000ffUL << SCU_POWER_EVRVADCSTAT_VADC33V_Pos)     /*!< SCU_POWER EVRVADCSTAT: VADC33V Mask     */

/* ------------------------------  SCU_POWER_PWRMON  ------------------------------ */
#define SCU_POWER_PWRMON_THRS_Pos             0                                                       /*!< SCU_POWER PWRMON: THRS Position         */
#define SCU_POWER_PWRMON_THRS_Msk             (0x000000ffUL << SCU_POWER_PWRMON_THRS_Pos)             /*!< SCU_POWER PWRMON: THRS Mask             */
#define SCU_POWER_PWRMON_INTV_Pos             8                                                       /*!< SCU_POWER PWRMON: INTV Position         */
#define SCU_POWER_PWRMON_INTV_Msk             (0x000000ffUL << SCU_POWER_PWRMON_INTV_Pos)             /*!< SCU_POWER PWRMON: INTV Mask             */
#define SCU_POWER_PWRMON_ENB_Pos              16                                                      /*!< SCU_POWER PWRMON: ENB Position          */
#define SCU_POWER_PWRMON_ENB_Msk              (0x01UL << SCU_POWER_PWRMON_ENB_Pos)                    /*!< SCU_POWER PWRMON: ENB Mask              */


/* ================================================================================ */
/* ================       struct 'SCU_RESET' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_RESET_RSTSTAT  ----------------------------- */
#define SCU_RESET_RSTSTAT_RSTSTAT_Pos         0                                                       /*!< SCU_RESET RSTSTAT: RSTSTAT Position     */
#define SCU_RESET_RSTSTAT_RSTSTAT_Msk         (0x000000ffUL << SCU_RESET_RSTSTAT_RSTSTAT_Pos)         /*!< SCU_RESET RSTSTAT: RSTSTAT Mask         */
#define SCU_RESET_RSTSTAT_HIBWK_Pos           8                                                       /*!< SCU_RESET RSTSTAT: HIBWK Position       */
#define SCU_RESET_RSTSTAT_HIBWK_Msk           (0x01UL << SCU_RESET_RSTSTAT_HIBWK_Pos)                 /*!< SCU_RESET RSTSTAT: HIBWK Mask           */
#define SCU_RESET_RSTSTAT_HIBRS_Pos           9                                                       /*!< SCU_RESET RSTSTAT: HIBRS Position       */
#define SCU_RESET_RSTSTAT_HIBRS_Msk           (0x01UL << SCU_RESET_RSTSTAT_HIBRS_Pos)                 /*!< SCU_RESET RSTSTAT: HIBRS Mask           */
#define SCU_RESET_RSTSTAT_LCKEN_Pos           10                                                      /*!< SCU_RESET RSTSTAT: LCKEN Position       */
#define SCU_RESET_RSTSTAT_LCKEN_Msk           (0x01UL << SCU_RESET_RSTSTAT_LCKEN_Pos)                 /*!< SCU_RESET RSTSTAT: LCKEN Mask           */

/* ------------------------------  SCU_RESET_RSTSET  ------------------------------ */
#define SCU_RESET_RSTSET_HIBWK_Pos            8                                                       /*!< SCU_RESET RSTSET: HIBWK Position        */
#define SCU_RESET_RSTSET_HIBWK_Msk            (0x01UL << SCU_RESET_RSTSET_HIBWK_Pos)                  /*!< SCU_RESET RSTSET: HIBWK Mask            */
#define SCU_RESET_RSTSET_HIBRS_Pos            9                                                       /*!< SCU_RESET RSTSET: HIBRS Position        */
#define SCU_RESET_RSTSET_HIBRS_Msk            (0x01UL << SCU_RESET_RSTSET_HIBRS_Pos)                  /*!< SCU_RESET RSTSET: HIBRS Mask            */
#define SCU_RESET_RSTSET_LCKEN_Pos            10                                                      /*!< SCU_RESET RSTSET: LCKEN Position        */
#define SCU_RESET_RSTSET_LCKEN_Msk            (0x01UL << SCU_RESET_RSTSET_LCKEN_Pos)                  /*!< SCU_RESET RSTSET: LCKEN Mask            */

/* ------------------------------  SCU_RESET_RSTCLR  ------------------------------ */
#define SCU_RESET_RSTCLR_RSCLR_Pos            0                                                       /*!< SCU_RESET RSTCLR: RSCLR Position        */
#define SCU_RESET_RSTCLR_RSCLR_Msk            (0x01UL << SCU_RESET_RSTCLR_RSCLR_Pos)                  /*!< SCU_RESET RSTCLR: RSCLR Mask            */
#define SCU_RESET_RSTCLR_HIBWK_Pos            8                                                       /*!< SCU_RESET RSTCLR: HIBWK Position        */
#define SCU_RESET_RSTCLR_HIBWK_Msk            (0x01UL << SCU_RESET_RSTCLR_HIBWK_Pos)                  /*!< SCU_RESET RSTCLR: HIBWK Mask            */
#define SCU_RESET_RSTCLR_HIBRS_Pos            9                                                       /*!< SCU_RESET RSTCLR: HIBRS Position        */
#define SCU_RESET_RSTCLR_HIBRS_Msk            (0x01UL << SCU_RESET_RSTCLR_HIBRS_Pos)                  /*!< SCU_RESET RSTCLR: HIBRS Mask            */
#define SCU_RESET_RSTCLR_LCKEN_Pos            10                                                      /*!< SCU_RESET RSTCLR: LCKEN Position        */
#define SCU_RESET_RSTCLR_LCKEN_Msk            (0x01UL << SCU_RESET_RSTCLR_LCKEN_Pos)                  /*!< SCU_RESET RSTCLR: LCKEN Mask            */

/* ------------------------------  SCU_RESET_PRSTAT0  ----------------------------- */
#define SCU_RESET_PRSTAT0_VADCRS_Pos          0                                                       /*!< SCU_RESET PRSTAT0: VADCRS Position      */
#define SCU_RESET_PRSTAT0_VADCRS_Msk          (0x01UL << SCU_RESET_PRSTAT0_VADCRS_Pos)                /*!< SCU_RESET PRSTAT0: VADCRS Mask          */
#define SCU_RESET_PRSTAT0_DSDRS_Pos           1                                                       /*!< SCU_RESET PRSTAT0: DSDRS Position       */
#define SCU_RESET_PRSTAT0_DSDRS_Msk           (0x01UL << SCU_RESET_PRSTAT0_DSDRS_Pos)                 /*!< SCU_RESET PRSTAT0: DSDRS Mask           */
#define SCU_RESET_PRSTAT0_CCU40RS_Pos         2                                                       /*!< SCU_RESET PRSTAT0: CCU40RS Position     */
#define SCU_RESET_PRSTAT0_CCU40RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU40RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU40RS Mask         */
#define SCU_RESET_PRSTAT0_CCU41RS_Pos         3                                                       /*!< SCU_RESET PRSTAT0: CCU41RS Position     */
#define SCU_RESET_PRSTAT0_CCU41RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU41RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU41RS Mask         */
#define SCU_RESET_PRSTAT0_CCU42RS_Pos         4                                                       /*!< SCU_RESET PRSTAT0: CCU42RS Position     */
#define SCU_RESET_PRSTAT0_CCU42RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU42RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU42RS Mask         */
#define SCU_RESET_PRSTAT0_CCU80RS_Pos         7                                                       /*!< SCU_RESET PRSTAT0: CCU80RS Position     */
#define SCU_RESET_PRSTAT0_CCU80RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU80RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU80RS Mask         */
#define SCU_RESET_PRSTAT0_CCU81RS_Pos         8                                                       /*!< SCU_RESET PRSTAT0: CCU81RS Position     */
#define SCU_RESET_PRSTAT0_CCU81RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_CCU81RS_Pos)               /*!< SCU_RESET PRSTAT0: CCU81RS Mask         */
#define SCU_RESET_PRSTAT0_POSIF0RS_Pos        9                                                       /*!< SCU_RESET PRSTAT0: POSIF0RS Position    */
#define SCU_RESET_PRSTAT0_POSIF0RS_Msk        (0x01UL << SCU_RESET_PRSTAT0_POSIF0RS_Pos)              /*!< SCU_RESET PRSTAT0: POSIF0RS Mask        */
#define SCU_RESET_PRSTAT0_POSIF1RS_Pos        10                                                      /*!< SCU_RESET PRSTAT0: POSIF1RS Position    */
#define SCU_RESET_PRSTAT0_POSIF1RS_Msk        (0x01UL << SCU_RESET_PRSTAT0_POSIF1RS_Pos)              /*!< SCU_RESET PRSTAT0: POSIF1RS Mask        */
#define SCU_RESET_PRSTAT0_USIC0RS_Pos         11                                                      /*!< SCU_RESET PRSTAT0: USIC0RS Position     */
#define SCU_RESET_PRSTAT0_USIC0RS_Msk         (0x01UL << SCU_RESET_PRSTAT0_USIC0RS_Pos)               /*!< SCU_RESET PRSTAT0: USIC0RS Mask         */
#define SCU_RESET_PRSTAT0_ERU1RS_Pos          16                                                      /*!< SCU_RESET PRSTAT0: ERU1RS Position      */
#define SCU_RESET_PRSTAT0_ERU1RS_Msk          (0x01UL << SCU_RESET_PRSTAT0_ERU1RS_Pos)                /*!< SCU_RESET PRSTAT0: ERU1RS Mask          */
#define SCU_RESET_PRSTAT0_HRPWM0RS_Pos        23                                                      /*!< SCU_RESET PRSTAT0: HRPWM0RS Position    */
#define SCU_RESET_PRSTAT0_HRPWM0RS_Msk        (0x01UL << SCU_RESET_PRSTAT0_HRPWM0RS_Pos)              /*!< SCU_RESET PRSTAT0: HRPWM0RS Mask        */

/* ------------------------------  SCU_RESET_PRSET0  ------------------------------ */
#define SCU_RESET_PRSET0_VADCRS_Pos           0                                                       /*!< SCU_RESET PRSET0: VADCRS Position       */
#define SCU_RESET_PRSET0_VADCRS_Msk           (0x01UL << SCU_RESET_PRSET0_VADCRS_Pos)                 /*!< SCU_RESET PRSET0: VADCRS Mask           */
#define SCU_RESET_PRSET0_DSDRS_Pos            1                                                       /*!< SCU_RESET PRSET0: DSDRS Position        */
#define SCU_RESET_PRSET0_DSDRS_Msk            (0x01UL << SCU_RESET_PRSET0_DSDRS_Pos)                  /*!< SCU_RESET PRSET0: DSDRS Mask            */
#define SCU_RESET_PRSET0_CCU40RS_Pos          2                                                       /*!< SCU_RESET PRSET0: CCU40RS Position      */
#define SCU_RESET_PRSET0_CCU40RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU40RS_Pos)                /*!< SCU_RESET PRSET0: CCU40RS Mask          */
#define SCU_RESET_PRSET0_CCU41RS_Pos          3                                                       /*!< SCU_RESET PRSET0: CCU41RS Position      */
#define SCU_RESET_PRSET0_CCU41RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU41RS_Pos)                /*!< SCU_RESET PRSET0: CCU41RS Mask          */
#define SCU_RESET_PRSET0_CCU42RS_Pos          4                                                       /*!< SCU_RESET PRSET0: CCU42RS Position      */
#define SCU_RESET_PRSET0_CCU42RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU42RS_Pos)                /*!< SCU_RESET PRSET0: CCU42RS Mask          */
#define SCU_RESET_PRSET0_CCU80RS_Pos          7                                                       /*!< SCU_RESET PRSET0: CCU80RS Position      */
#define SCU_RESET_PRSET0_CCU80RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU80RS_Pos)                /*!< SCU_RESET PRSET0: CCU80RS Mask          */
#define SCU_RESET_PRSET0_CCU81RS_Pos          8                                                       /*!< SCU_RESET PRSET0: CCU81RS Position      */
#define SCU_RESET_PRSET0_CCU81RS_Msk          (0x01UL << SCU_RESET_PRSET0_CCU81RS_Pos)                /*!< SCU_RESET PRSET0: CCU81RS Mask          */
#define SCU_RESET_PRSET0_POSIF0RS_Pos         9                                                       /*!< SCU_RESET PRSET0: POSIF0RS Position     */
#define SCU_RESET_PRSET0_POSIF0RS_Msk         (0x01UL << SCU_RESET_PRSET0_POSIF0RS_Pos)               /*!< SCU_RESET PRSET0: POSIF0RS Mask         */
#define SCU_RESET_PRSET0_POSIF1RS_Pos         10                                                      /*!< SCU_RESET PRSET0: POSIF1RS Position     */
#define SCU_RESET_PRSET0_POSIF1RS_Msk         (0x01UL << SCU_RESET_PRSET0_POSIF1RS_Pos)               /*!< SCU_RESET PRSET0: POSIF1RS Mask         */
#define SCU_RESET_PRSET0_USIC0RS_Pos          11                                                      /*!< SCU_RESET PRSET0: USIC0RS Position      */
#define SCU_RESET_PRSET0_USIC0RS_Msk          (0x01UL << SCU_RESET_PRSET0_USIC0RS_Pos)                /*!< SCU_RESET PRSET0: USIC0RS Mask          */
#define SCU_RESET_PRSET0_ERU1RS_Pos           16                                                      /*!< SCU_RESET PRSET0: ERU1RS Position       */
#define SCU_RESET_PRSET0_ERU1RS_Msk           (0x01UL << SCU_RESET_PRSET0_ERU1RS_Pos)                 /*!< SCU_RESET PRSET0: ERU1RS Mask           */
#define SCU_RESET_PRSET0_HRPWM0RS_Pos         23                                                      /*!< SCU_RESET PRSET0: HRPWM0RS Position     */
#define SCU_RESET_PRSET0_HRPWM0RS_Msk         (0x01UL << SCU_RESET_PRSET0_HRPWM0RS_Pos)               /*!< SCU_RESET PRSET0: HRPWM0RS Mask         */

/* ------------------------------  SCU_RESET_PRCLR0  ------------------------------ */
#define SCU_RESET_PRCLR0_VADCRS_Pos           0                                                       /*!< SCU_RESET PRCLR0: VADCRS Position       */
#define SCU_RESET_PRCLR0_VADCRS_Msk           (0x01UL << SCU_RESET_PRCLR0_VADCRS_Pos)                 /*!< SCU_RESET PRCLR0: VADCRS Mask           */
#define SCU_RESET_PRCLR0_DSDRS_Pos            1                                                       /*!< SCU_RESET PRCLR0: DSDRS Position        */
#define SCU_RESET_PRCLR0_DSDRS_Msk            (0x01UL << SCU_RESET_PRCLR0_DSDRS_Pos)                  /*!< SCU_RESET PRCLR0: DSDRS Mask            */
#define SCU_RESET_PRCLR0_CCU40RS_Pos          2                                                       /*!< SCU_RESET PRCLR0: CCU40RS Position      */
#define SCU_RESET_PRCLR0_CCU40RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU40RS_Pos)                /*!< SCU_RESET PRCLR0: CCU40RS Mask          */
#define SCU_RESET_PRCLR0_CCU41RS_Pos          3                                                       /*!< SCU_RESET PRCLR0: CCU41RS Position      */
#define SCU_RESET_PRCLR0_CCU41RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU41RS_Pos)                /*!< SCU_RESET PRCLR0: CCU41RS Mask          */
#define SCU_RESET_PRCLR0_CCU42RS_Pos          4                                                       /*!< SCU_RESET PRCLR0: CCU42RS Position      */
#define SCU_RESET_PRCLR0_CCU42RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU42RS_Pos)                /*!< SCU_RESET PRCLR0: CCU42RS Mask          */
#define SCU_RESET_PRCLR0_CCU80RS_Pos          7                                                       /*!< SCU_RESET PRCLR0: CCU80RS Position      */
#define SCU_RESET_PRCLR0_CCU80RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU80RS_Pos)                /*!< SCU_RESET PRCLR0: CCU80RS Mask          */
#define SCU_RESET_PRCLR0_CCU81RS_Pos          8                                                       /*!< SCU_RESET PRCLR0: CCU81RS Position      */
#define SCU_RESET_PRCLR0_CCU81RS_Msk          (0x01UL << SCU_RESET_PRCLR0_CCU81RS_Pos)                /*!< SCU_RESET PRCLR0: CCU81RS Mask          */
#define SCU_RESET_PRCLR0_POSIF0RS_Pos         9                                                       /*!< SCU_RESET PRCLR0: POSIF0RS Position     */
#define SCU_RESET_PRCLR0_POSIF0RS_Msk         (0x01UL << SCU_RESET_PRCLR0_POSIF0RS_Pos)               /*!< SCU_RESET PRCLR0: POSIF0RS Mask         */
#define SCU_RESET_PRCLR0_POSIF1RS_Pos         10                                                      /*!< SCU_RESET PRCLR0: POSIF1RS Position     */
#define SCU_RESET_PRCLR0_POSIF1RS_Msk         (0x01UL << SCU_RESET_PRCLR0_POSIF1RS_Pos)               /*!< SCU_RESET PRCLR0: POSIF1RS Mask         */
#define SCU_RESET_PRCLR0_USIC0RS_Pos          11                                                      /*!< SCU_RESET PRCLR0: USIC0RS Position      */
#define SCU_RESET_PRCLR0_USIC0RS_Msk          (0x01UL << SCU_RESET_PRCLR0_USIC0RS_Pos)                /*!< SCU_RESET PRCLR0: USIC0RS Mask          */
#define SCU_RESET_PRCLR0_ERU1RS_Pos           16                                                      /*!< SCU_RESET PRCLR0: ERU1RS Position       */
#define SCU_RESET_PRCLR0_ERU1RS_Msk           (0x01UL << SCU_RESET_PRCLR0_ERU1RS_Pos)                 /*!< SCU_RESET PRCLR0: ERU1RS Mask           */
#define SCU_RESET_PRCLR0_HRPWM0RS_Pos         23                                                      /*!< SCU_RESET PRCLR0: HRPWM0RS Position     */
#define SCU_RESET_PRCLR0_HRPWM0RS_Msk         (0x01UL << SCU_RESET_PRCLR0_HRPWM0RS_Pos)               /*!< SCU_RESET PRCLR0: HRPWM0RS Mask         */

/* ------------------------------  SCU_RESET_PRSTAT1  ----------------------------- */
#define SCU_RESET_PRSTAT1_CCU43RS_Pos         0                                                       /*!< SCU_RESET PRSTAT1: CCU43RS Position     */
#define SCU_RESET_PRSTAT1_CCU43RS_Msk         (0x01UL << SCU_RESET_PRSTAT1_CCU43RS_Pos)               /*!< SCU_RESET PRSTAT1: CCU43RS Mask         */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Pos      3                                                       /*!< SCU_RESET PRSTAT1: LEDTSCU0RS Position  */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Msk      (0x01UL << SCU_RESET_PRSTAT1_LEDTSCU0RS_Pos)            /*!< SCU_RESET PRSTAT1: LEDTSCU0RS Mask      */
#define SCU_RESET_PRSTAT1_MCAN0RS_Pos         4                                                       /*!< SCU_RESET PRSTAT1: MCAN0RS Position     */
#define SCU_RESET_PRSTAT1_MCAN0RS_Msk         (0x01UL << SCU_RESET_PRSTAT1_MCAN0RS_Pos)               /*!< SCU_RESET PRSTAT1: MCAN0RS Mask         */
#define SCU_RESET_PRSTAT1_DACRS_Pos           5                                                       /*!< SCU_RESET PRSTAT1: DACRS Position       */
#define SCU_RESET_PRSTAT1_DACRS_Msk           (0x01UL << SCU_RESET_PRSTAT1_DACRS_Pos)                 /*!< SCU_RESET PRSTAT1: DACRS Mask           */
#define SCU_RESET_PRSTAT1_USIC1RS_Pos         7                                                       /*!< SCU_RESET PRSTAT1: USIC1RS Position     */
#define SCU_RESET_PRSTAT1_USIC1RS_Msk         (0x01UL << SCU_RESET_PRSTAT1_USIC1RS_Pos)               /*!< SCU_RESET PRSTAT1: USIC1RS Mask         */
#define SCU_RESET_PRSTAT1_PPORTSRS_Pos        9                                                       /*!< SCU_RESET PRSTAT1: PPORTSRS Position    */
#define SCU_RESET_PRSTAT1_PPORTSRS_Msk        (0x01UL << SCU_RESET_PRSTAT1_PPORTSRS_Pos)              /*!< SCU_RESET PRSTAT1: PPORTSRS Mask        */

/* ------------------------------  SCU_RESET_PRSET1  ------------------------------ */
#define SCU_RESET_PRSET1_CCU43RS_Pos          0                                                       /*!< SCU_RESET PRSET1: CCU43RS Position      */
#define SCU_RESET_PRSET1_CCU43RS_Msk          (0x01UL << SCU_RESET_PRSET1_CCU43RS_Pos)                /*!< SCU_RESET PRSET1: CCU43RS Mask          */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Pos       3                                                       /*!< SCU_RESET PRSET1: LEDTSCU0RS Position   */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Msk       (0x01UL << SCU_RESET_PRSET1_LEDTSCU0RS_Pos)             /*!< SCU_RESET PRSET1: LEDTSCU0RS Mask       */
#define SCU_RESET_PRSET1_MCAN0RS_Pos          4                                                       /*!< SCU_RESET PRSET1: MCAN0RS Position      */
#define SCU_RESET_PRSET1_MCAN0RS_Msk          (0x01UL << SCU_RESET_PRSET1_MCAN0RS_Pos)                /*!< SCU_RESET PRSET1: MCAN0RS Mask          */
#define SCU_RESET_PRSET1_DACRS_Pos            5                                                       /*!< SCU_RESET PRSET1: DACRS Position        */
#define SCU_RESET_PRSET1_DACRS_Msk            (0x01UL << SCU_RESET_PRSET1_DACRS_Pos)                  /*!< SCU_RESET PRSET1: DACRS Mask            */
#define SCU_RESET_PRSET1_USIC1RS_Pos          7                                                       /*!< SCU_RESET PRSET1: USIC1RS Position      */
#define SCU_RESET_PRSET1_USIC1RS_Msk          (0x01UL << SCU_RESET_PRSET1_USIC1RS_Pos)                /*!< SCU_RESET PRSET1: USIC1RS Mask          */
#define SCU_RESET_PRSET1_PPORTSRS_Pos         9                                                       /*!< SCU_RESET PRSET1: PPORTSRS Position     */
#define SCU_RESET_PRSET1_PPORTSRS_Msk         (0x01UL << SCU_RESET_PRSET1_PPORTSRS_Pos)               /*!< SCU_RESET PRSET1: PPORTSRS Mask         */

/* ------------------------------  SCU_RESET_PRCLR1  ------------------------------ */
#define SCU_RESET_PRCLR1_CCU43RS_Pos          0                                                       /*!< SCU_RESET PRCLR1: CCU43RS Position      */
#define SCU_RESET_PRCLR1_CCU43RS_Msk          (0x01UL << SCU_RESET_PRCLR1_CCU43RS_Pos)                /*!< SCU_RESET PRCLR1: CCU43RS Mask          */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Pos       3                                                       /*!< SCU_RESET PRCLR1: LEDTSCU0RS Position   */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Msk       (0x01UL << SCU_RESET_PRCLR1_LEDTSCU0RS_Pos)             /*!< SCU_RESET PRCLR1: LEDTSCU0RS Mask       */
#define SCU_RESET_PRCLR1_MCAN0RS_Pos          4                                                       /*!< SCU_RESET PRCLR1: MCAN0RS Position      */
#define SCU_RESET_PRCLR1_MCAN0RS_Msk          (0x01UL << SCU_RESET_PRCLR1_MCAN0RS_Pos)                /*!< SCU_RESET PRCLR1: MCAN0RS Mask          */
#define SCU_RESET_PRCLR1_DACRS_Pos            5                                                       /*!< SCU_RESET PRCLR1: DACRS Position        */
#define SCU_RESET_PRCLR1_DACRS_Msk            (0x01UL << SCU_RESET_PRCLR1_DACRS_Pos)                  /*!< SCU_RESET PRCLR1: DACRS Mask            */
#define SCU_RESET_PRCLR1_USIC1RS_Pos          7                                                       /*!< SCU_RESET PRCLR1: USIC1RS Position      */
#define SCU_RESET_PRCLR1_USIC1RS_Msk          (0x01UL << SCU_RESET_PRCLR1_USIC1RS_Pos)                /*!< SCU_RESET PRCLR1: USIC1RS Mask          */
#define SCU_RESET_PRCLR1_PPORTSRS_Pos         9                                                       /*!< SCU_RESET PRCLR1: PPORTSRS Position     */
#define SCU_RESET_PRCLR1_PPORTSRS_Msk         (0x01UL << SCU_RESET_PRCLR1_PPORTSRS_Pos)               /*!< SCU_RESET PRCLR1: PPORTSRS Mask         */

/* ------------------------------  SCU_RESET_PRSTAT2  ----------------------------- */
#define SCU_RESET_PRSTAT2_WDTRS_Pos           1                                                       /*!< SCU_RESET PRSTAT2: WDTRS Position       */
#define SCU_RESET_PRSTAT2_WDTRS_Msk           (0x01UL << SCU_RESET_PRSTAT2_WDTRS_Pos)                 /*!< SCU_RESET PRSTAT2: WDTRS Mask           */
#define SCU_RESET_PRSTAT2_ETH0RS_Pos          2                                                       /*!< SCU_RESET PRSTAT2: ETH0RS Position      */
#define SCU_RESET_PRSTAT2_ETH0RS_Msk          (0x01UL << SCU_RESET_PRSTAT2_ETH0RS_Pos)                /*!< SCU_RESET PRSTAT2: ETH0RS Mask          */
#define SCU_RESET_PRSTAT2_DMA0RS_Pos          4                                                       /*!< SCU_RESET PRSTAT2: DMA0RS Position      */
#define SCU_RESET_PRSTAT2_DMA0RS_Msk          (0x01UL << SCU_RESET_PRSTAT2_DMA0RS_Pos)                /*!< SCU_RESET PRSTAT2: DMA0RS Mask          */
#define SCU_RESET_PRSTAT2_FCERS_Pos           6                                                       /*!< SCU_RESET PRSTAT2: FCERS Position       */
#define SCU_RESET_PRSTAT2_FCERS_Msk           (0x01UL << SCU_RESET_PRSTAT2_FCERS_Pos)                 /*!< SCU_RESET PRSTAT2: FCERS Mask           */
#define SCU_RESET_PRSTAT2_USBRS_Pos           7                                                       /*!< SCU_RESET PRSTAT2: USBRS Position       */
#define SCU_RESET_PRSTAT2_USBRS_Msk           (0x01UL << SCU_RESET_PRSTAT2_USBRS_Pos)                 /*!< SCU_RESET PRSTAT2: USBRS Mask           */

/* ------------------------------  SCU_RESET_PRSET2  ------------------------------ */
#define SCU_RESET_PRSET2_WDTRS_Pos            1                                                       /*!< SCU_RESET PRSET2: WDTRS Position        */
#define SCU_RESET_PRSET2_WDTRS_Msk            (0x01UL << SCU_RESET_PRSET2_WDTRS_Pos)                  /*!< SCU_RESET PRSET2: WDTRS Mask            */
#define SCU_RESET_PRSET2_ETH0RS_Pos           2                                                       /*!< SCU_RESET PRSET2: ETH0RS Position       */
#define SCU_RESET_PRSET2_ETH0RS_Msk           (0x01UL << SCU_RESET_PRSET2_ETH0RS_Pos)                 /*!< SCU_RESET PRSET2: ETH0RS Mask           */
#define SCU_RESET_PRSET2_DMA0RS_Pos           4                                                       /*!< SCU_RESET PRSET2: DMA0RS Position       */
#define SCU_RESET_PRSET2_DMA0RS_Msk           (0x01UL << SCU_RESET_PRSET2_DMA0RS_Pos)                 /*!< SCU_RESET PRSET2: DMA0RS Mask           */
#define SCU_RESET_PRSET2_FCERS_Pos            6                                                       /*!< SCU_RESET PRSET2: FCERS Position        */
#define SCU_RESET_PRSET2_FCERS_Msk            (0x01UL << SCU_RESET_PRSET2_FCERS_Pos)                  /*!< SCU_RESET PRSET2: FCERS Mask            */
#define SCU_RESET_PRSET2_USBRS_Pos            7                                                       /*!< SCU_RESET PRSET2: USBRS Position        */
#define SCU_RESET_PRSET2_USBRS_Msk            (0x01UL << SCU_RESET_PRSET2_USBRS_Pos)                  /*!< SCU_RESET PRSET2: USBRS Mask            */

/* ------------------------------  SCU_RESET_PRCLR2  ------------------------------ */
#define SCU_RESET_PRCLR2_WDTRS_Pos            1                                                       /*!< SCU_RESET PRCLR2: WDTRS Position        */
#define SCU_RESET_PRCLR2_WDTRS_Msk            (0x01UL << SCU_RESET_PRCLR2_WDTRS_Pos)                  /*!< SCU_RESET PRCLR2: WDTRS Mask            */
#define SCU_RESET_PRCLR2_ETH0RS_Pos           2                                                       /*!< SCU_RESET PRCLR2: ETH0RS Position       */
#define SCU_RESET_PRCLR2_ETH0RS_Msk           (0x01UL << SCU_RESET_PRCLR2_ETH0RS_Pos)                 /*!< SCU_RESET PRCLR2: ETH0RS Mask           */
#define SCU_RESET_PRCLR2_DMA0RS_Pos           4                                                       /*!< SCU_RESET PRCLR2: DMA0RS Position       */
#define SCU_RESET_PRCLR2_DMA0RS_Msk           (0x01UL << SCU_RESET_PRCLR2_DMA0RS_Pos)                 /*!< SCU_RESET PRCLR2: DMA0RS Mask           */
#define SCU_RESET_PRCLR2_FCERS_Pos            6                                                       /*!< SCU_RESET PRCLR2: FCERS Position        */
#define SCU_RESET_PRCLR2_FCERS_Msk            (0x01UL << SCU_RESET_PRCLR2_FCERS_Pos)                  /*!< SCU_RESET PRCLR2: FCERS Mask            */
#define SCU_RESET_PRCLR2_USBRS_Pos            7                                                       /*!< SCU_RESET PRCLR2: USBRS Position        */
#define SCU_RESET_PRCLR2_USBRS_Msk            (0x01UL << SCU_RESET_PRCLR2_USBRS_Pos)                  /*!< SCU_RESET PRCLR2: USBRS Mask            */


/* ================================================================================ */
/* ================          Group 'LEDTS' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  LEDTS_ID  ---------------------------------- */
#define LEDTS_ID_MOD_REV_Pos                  0                                                       /*!< LEDTS ID: MOD_REV Position              */
#define LEDTS_ID_MOD_REV_Msk                  (0x000000ffUL << LEDTS_ID_MOD_REV_Pos)                  /*!< LEDTS ID: MOD_REV Mask                  */
#define LEDTS_ID_MOD_TYPE_Pos                 8                                                       /*!< LEDTS ID: MOD_TYPE Position             */
#define LEDTS_ID_MOD_TYPE_Msk                 (0x000000ffUL << LEDTS_ID_MOD_TYPE_Pos)                 /*!< LEDTS ID: MOD_TYPE Mask                 */
#define LEDTS_ID_MOD_NUMBER_Pos               16                                                      /*!< LEDTS ID: MOD_NUMBER Position           */
#define LEDTS_ID_MOD_NUMBER_Msk               (0x0000ffffUL << LEDTS_ID_MOD_NUMBER_Pos)               /*!< LEDTS ID: MOD_NUMBER Mask               */

/* --------------------------------  LEDTS_GLOBCTL  ------------------------------- */
#define LEDTS_GLOBCTL_TS_EN_Pos               0                                                       /*!< LEDTS GLOBCTL: TS_EN Position           */
#define LEDTS_GLOBCTL_TS_EN_Msk               (0x01UL << LEDTS_GLOBCTL_TS_EN_Pos)                     /*!< LEDTS GLOBCTL: TS_EN Mask               */
#define LEDTS_GLOBCTL_LD_EN_Pos               1                                                       /*!< LEDTS GLOBCTL: LD_EN Position           */
#define LEDTS_GLOBCTL_LD_EN_Msk               (0x01UL << LEDTS_GLOBCTL_LD_EN_Pos)                     /*!< LEDTS GLOBCTL: LD_EN Mask               */
#define LEDTS_GLOBCTL_CMTR_Pos                2                                                       /*!< LEDTS GLOBCTL: CMTR Position            */
#define LEDTS_GLOBCTL_CMTR_Msk                (0x01UL << LEDTS_GLOBCTL_CMTR_Pos)                      /*!< LEDTS GLOBCTL: CMTR Mask                */
#define LEDTS_GLOBCTL_ENSYNC_Pos              3                                                       /*!< LEDTS GLOBCTL: ENSYNC Position          */
#define LEDTS_GLOBCTL_ENSYNC_Msk              (0x01UL << LEDTS_GLOBCTL_ENSYNC_Pos)                    /*!< LEDTS GLOBCTL: ENSYNC Mask              */
#define LEDTS_GLOBCTL_SUSCFG_Pos              8                                                       /*!< LEDTS GLOBCTL: SUSCFG Position          */
#define LEDTS_GLOBCTL_SUSCFG_Msk              (0x01UL << LEDTS_GLOBCTL_SUSCFG_Pos)                    /*!< LEDTS GLOBCTL: SUSCFG Mask              */
#define LEDTS_GLOBCTL_MASKVAL_Pos             9                                                       /*!< LEDTS GLOBCTL: MASKVAL Position         */
#define LEDTS_GLOBCTL_MASKVAL_Msk             (0x07UL << LEDTS_GLOBCTL_MASKVAL_Pos)                   /*!< LEDTS GLOBCTL: MASKVAL Mask             */
#define LEDTS_GLOBCTL_FENVAL_Pos              12                                                      /*!< LEDTS GLOBCTL: FENVAL Position          */
#define LEDTS_GLOBCTL_FENVAL_Msk              (0x01UL << LEDTS_GLOBCTL_FENVAL_Pos)                    /*!< LEDTS GLOBCTL: FENVAL Mask              */
#define LEDTS_GLOBCTL_ITS_EN_Pos              13                                                      /*!< LEDTS GLOBCTL: ITS_EN Position          */
#define LEDTS_GLOBCTL_ITS_EN_Msk              (0x01UL << LEDTS_GLOBCTL_ITS_EN_Pos)                    /*!< LEDTS GLOBCTL: ITS_EN Mask              */
#define LEDTS_GLOBCTL_ITF_EN_Pos              14                                                      /*!< LEDTS GLOBCTL: ITF_EN Position          */
#define LEDTS_GLOBCTL_ITF_EN_Msk              (0x01UL << LEDTS_GLOBCTL_ITF_EN_Pos)                    /*!< LEDTS GLOBCTL: ITF_EN Mask              */
#define LEDTS_GLOBCTL_ITP_EN_Pos              15                                                      /*!< LEDTS GLOBCTL: ITP_EN Position          */
#define LEDTS_GLOBCTL_ITP_EN_Msk              (0x01UL << LEDTS_GLOBCTL_ITP_EN_Pos)                    /*!< LEDTS GLOBCTL: ITP_EN Mask              */
#define LEDTS_GLOBCTL_CLK_PS_Pos              16                                                      /*!< LEDTS GLOBCTL: CLK_PS Position          */
#define LEDTS_GLOBCTL_CLK_PS_Msk              (0x0000ffffUL << LEDTS_GLOBCTL_CLK_PS_Pos)              /*!< LEDTS GLOBCTL: CLK_PS Mask              */

/* ---------------------------------  LEDTS_FNCTL  -------------------------------- */
#define LEDTS_FNCTL_PADT_Pos                  0                                                       /*!< LEDTS FNCTL: PADT Position              */
#define LEDTS_FNCTL_PADT_Msk                  (0x07UL << LEDTS_FNCTL_PADT_Pos)                        /*!< LEDTS FNCTL: PADT Mask                  */
#define LEDTS_FNCTL_PADTSW_Pos                3                                                       /*!< LEDTS FNCTL: PADTSW Position            */
#define LEDTS_FNCTL_PADTSW_Msk                (0x01UL << LEDTS_FNCTL_PADTSW_Pos)                      /*!< LEDTS FNCTL: PADTSW Mask                */
#define LEDTS_FNCTL_EPULL_Pos                 4                                                       /*!< LEDTS FNCTL: EPULL Position             */
#define LEDTS_FNCTL_EPULL_Msk                 (0x01UL << LEDTS_FNCTL_EPULL_Pos)                       /*!< LEDTS FNCTL: EPULL Mask                 */
#define LEDTS_FNCTL_FNCOL_Pos                 5                                                       /*!< LEDTS FNCTL: FNCOL Position             */
#define LEDTS_FNCTL_FNCOL_Msk                 (0x07UL << LEDTS_FNCTL_FNCOL_Pos)                       /*!< LEDTS FNCTL: FNCOL Mask                 */
#define LEDTS_FNCTL_ACCCNT_Pos                16                                                      /*!< LEDTS FNCTL: ACCCNT Position            */
#define LEDTS_FNCTL_ACCCNT_Msk                (0x0fUL << LEDTS_FNCTL_ACCCNT_Pos)                      /*!< LEDTS FNCTL: ACCCNT Mask                */
#define LEDTS_FNCTL_TSCCMP_Pos                20                                                      /*!< LEDTS FNCTL: TSCCMP Position            */
#define LEDTS_FNCTL_TSCCMP_Msk                (0x01UL << LEDTS_FNCTL_TSCCMP_Pos)                      /*!< LEDTS FNCTL: TSCCMP Mask                */
#define LEDTS_FNCTL_TSOEXT_Pos                21                                                      /*!< LEDTS FNCTL: TSOEXT Position            */
#define LEDTS_FNCTL_TSOEXT_Msk                (0x03UL << LEDTS_FNCTL_TSOEXT_Pos)                      /*!< LEDTS FNCTL: TSOEXT Mask                */
#define LEDTS_FNCTL_TSCTRR_Pos                23                                                      /*!< LEDTS FNCTL: TSCTRR Position            */
#define LEDTS_FNCTL_TSCTRR_Msk                (0x01UL << LEDTS_FNCTL_TSCTRR_Pos)                      /*!< LEDTS FNCTL: TSCTRR Mask                */
#define LEDTS_FNCTL_TSCTRSAT_Pos              24                                                      /*!< LEDTS FNCTL: TSCTRSAT Position          */
#define LEDTS_FNCTL_TSCTRSAT_Msk              (0x01UL << LEDTS_FNCTL_TSCTRSAT_Pos)                    /*!< LEDTS FNCTL: TSCTRSAT Mask              */
#define LEDTS_FNCTL_NR_TSIN_Pos               25                                                      /*!< LEDTS FNCTL: NR_TSIN Position           */
#define LEDTS_FNCTL_NR_TSIN_Msk               (0x07UL << LEDTS_FNCTL_NR_TSIN_Pos)                     /*!< LEDTS FNCTL: NR_TSIN Mask               */
#define LEDTS_FNCTL_COLLEV_Pos                28                                                      /*!< LEDTS FNCTL: COLLEV Position            */
#define LEDTS_FNCTL_COLLEV_Msk                (0x01UL << LEDTS_FNCTL_COLLEV_Pos)                      /*!< LEDTS FNCTL: COLLEV Mask                */
#define LEDTS_FNCTL_NR_LEDCOL_Pos             29                                                      /*!< LEDTS FNCTL: NR_LEDCOL Position         */
#define LEDTS_FNCTL_NR_LEDCOL_Msk             (0x07UL << LEDTS_FNCTL_NR_LEDCOL_Pos)                   /*!< LEDTS FNCTL: NR_LEDCOL Mask             */

/* ---------------------------------  LEDTS_EVFR  --------------------------------- */
#define LEDTS_EVFR_TSF_Pos                    0                                                       /*!< LEDTS EVFR: TSF Position                */
#define LEDTS_EVFR_TSF_Msk                    (0x01UL << LEDTS_EVFR_TSF_Pos)                          /*!< LEDTS EVFR: TSF Mask                    */
#define LEDTS_EVFR_TFF_Pos                    1                                                       /*!< LEDTS EVFR: TFF Position                */
#define LEDTS_EVFR_TFF_Msk                    (0x01UL << LEDTS_EVFR_TFF_Pos)                          /*!< LEDTS EVFR: TFF Mask                    */
#define LEDTS_EVFR_TPF_Pos                    2                                                       /*!< LEDTS EVFR: TPF Position                */
#define LEDTS_EVFR_TPF_Msk                    (0x01UL << LEDTS_EVFR_TPF_Pos)                          /*!< LEDTS EVFR: TPF Mask                    */
#define LEDTS_EVFR_TSCTROVF_Pos               3                                                       /*!< LEDTS EVFR: TSCTROVF Position           */
#define LEDTS_EVFR_TSCTROVF_Msk               (0x01UL << LEDTS_EVFR_TSCTROVF_Pos)                     /*!< LEDTS EVFR: TSCTROVF Mask               */
#define LEDTS_EVFR_CTSF_Pos                   16                                                      /*!< LEDTS EVFR: CTSF Position               */
#define LEDTS_EVFR_CTSF_Msk                   (0x01UL << LEDTS_EVFR_CTSF_Pos)                         /*!< LEDTS EVFR: CTSF Mask                   */
#define LEDTS_EVFR_CTFF_Pos                   17                                                      /*!< LEDTS EVFR: CTFF Position               */
#define LEDTS_EVFR_CTFF_Msk                   (0x01UL << LEDTS_EVFR_CTFF_Pos)                         /*!< LEDTS EVFR: CTFF Mask                   */
#define LEDTS_EVFR_CTPF_Pos                   18                                                      /*!< LEDTS EVFR: CTPF Position               */
#define LEDTS_EVFR_CTPF_Msk                   (0x01UL << LEDTS_EVFR_CTPF_Pos)                         /*!< LEDTS EVFR: CTPF Mask                   */

/* ---------------------------------  LEDTS_TSVAL  -------------------------------- */
#define LEDTS_TSVAL_TSCTRVALR_Pos             0                                                       /*!< LEDTS TSVAL: TSCTRVALR Position         */
#define LEDTS_TSVAL_TSCTRVALR_Msk             (0x0000ffffUL << LEDTS_TSVAL_TSCTRVALR_Pos)             /*!< LEDTS TSVAL: TSCTRVALR Mask             */
#define LEDTS_TSVAL_TSCTRVAL_Pos              16                                                      /*!< LEDTS TSVAL: TSCTRVAL Position          */
#define LEDTS_TSVAL_TSCTRVAL_Msk              (0x0000ffffUL << LEDTS_TSVAL_TSCTRVAL_Pos)              /*!< LEDTS TSVAL: TSCTRVAL Mask              */

/* ---------------------------------  LEDTS_LINE0  -------------------------------- */
#define LEDTS_LINE0_LINE_0_Pos                0                                                       /*!< LEDTS LINE0: LINE_0 Position            */
#define LEDTS_LINE0_LINE_0_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_0_Pos)                /*!< LEDTS LINE0: LINE_0 Mask                */
#define LEDTS_LINE0_LINE_1_Pos                8                                                       /*!< LEDTS LINE0: LINE_1 Position            */
#define LEDTS_LINE0_LINE_1_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_1_Pos)                /*!< LEDTS LINE0: LINE_1 Mask                */
#define LEDTS_LINE0_LINE_2_Pos                16                                                      /*!< LEDTS LINE0: LINE_2 Position            */
#define LEDTS_LINE0_LINE_2_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_2_Pos)                /*!< LEDTS LINE0: LINE_2 Mask                */
#define LEDTS_LINE0_LINE_3_Pos                24                                                      /*!< LEDTS LINE0: LINE_3 Position            */
#define LEDTS_LINE0_LINE_3_Msk                (0x000000ffUL << LEDTS_LINE0_LINE_3_Pos)                /*!< LEDTS LINE0: LINE_3 Mask                */

/* ---------------------------------  LEDTS_LINE1  -------------------------------- */
#define LEDTS_LINE1_LINE_4_Pos                0                                                       /*!< LEDTS LINE1: LINE_4 Position            */
#define LEDTS_LINE1_LINE_4_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_4_Pos)                /*!< LEDTS LINE1: LINE_4 Mask                */
#define LEDTS_LINE1_LINE_5_Pos                8                                                       /*!< LEDTS LINE1: LINE_5 Position            */
#define LEDTS_LINE1_LINE_5_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_5_Pos)                /*!< LEDTS LINE1: LINE_5 Mask                */
#define LEDTS_LINE1_LINE_6_Pos                16                                                      /*!< LEDTS LINE1: LINE_6 Position            */
#define LEDTS_LINE1_LINE_6_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_6_Pos)                /*!< LEDTS LINE1: LINE_6 Mask                */
#define LEDTS_LINE1_LINE_A_Pos                24                                                      /*!< LEDTS LINE1: LINE_A Position            */
#define LEDTS_LINE1_LINE_A_Msk                (0x000000ffUL << LEDTS_LINE1_LINE_A_Pos)                /*!< LEDTS LINE1: LINE_A Mask                */

/* --------------------------------  LEDTS_LDCMP0  -------------------------------- */
#define LEDTS_LDCMP0_CMP_LD0_Pos              0                                                       /*!< LEDTS LDCMP0: CMP_LD0 Position          */
#define LEDTS_LDCMP0_CMP_LD0_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD0_Pos)              /*!< LEDTS LDCMP0: CMP_LD0 Mask              */
#define LEDTS_LDCMP0_CMP_LD1_Pos              8                                                       /*!< LEDTS LDCMP0: CMP_LD1 Position          */
#define LEDTS_LDCMP0_CMP_LD1_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD1_Pos)              /*!< LEDTS LDCMP0: CMP_LD1 Mask              */
#define LEDTS_LDCMP0_CMP_LD2_Pos              16                                                      /*!< LEDTS LDCMP0: CMP_LD2 Position          */
#define LEDTS_LDCMP0_CMP_LD2_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD2_Pos)              /*!< LEDTS LDCMP0: CMP_LD2 Mask              */
#define LEDTS_LDCMP0_CMP_LD3_Pos              24                                                      /*!< LEDTS LDCMP0: CMP_LD3 Position          */
#define LEDTS_LDCMP0_CMP_LD3_Msk              (0x000000ffUL << LEDTS_LDCMP0_CMP_LD3_Pos)              /*!< LEDTS LDCMP0: CMP_LD3 Mask              */

/* --------------------------------  LEDTS_LDCMP1  -------------------------------- */
#define LEDTS_LDCMP1_CMP_LD4_Pos              0                                                       /*!< LEDTS LDCMP1: CMP_LD4 Position          */
#define LEDTS_LDCMP1_CMP_LD4_Msk              (0x000000ffUL << LEDTS_LDCMP1_CMP_LD4_Pos)              /*!< LEDTS LDCMP1: CMP_LD4 Mask              */
#define LEDTS_LDCMP1_CMP_LD5_Pos              8                                                       /*!< LEDTS LDCMP1: CMP_LD5 Position          */
#define LEDTS_LDCMP1_CMP_LD5_Msk              (0x000000ffUL << LEDTS_LDCMP1_CMP_LD5_Pos)              /*!< LEDTS LDCMP1: CMP_LD5 Mask              */
#define LEDTS_LDCMP1_CMP_LD6_Pos              16                                                      /*!< LEDTS LDCMP1: CMP_LD6 Position          */
#define LEDTS_LDCMP1_CMP_LD6_Msk              (0x000000ffUL << LEDTS_LDCMP1_CMP_LD6_Pos)              /*!< LEDTS LDCMP1: CMP_LD6 Mask              */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Pos        24                                                      /*!< LEDTS LDCMP1: CMP_LDA_TSCOM Position    */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Msk        (0x000000ffUL << LEDTS_LDCMP1_CMP_LDA_TSCOM_Pos)        /*!< LEDTS LDCMP1: CMP_LDA_TSCOM Mask        */

/* --------------------------------  LEDTS_TSCMP0  -------------------------------- */
#define LEDTS_TSCMP0_CMP_TS0_Pos              0                                                       /*!< LEDTS TSCMP0: CMP_TS0 Position          */
#define LEDTS_TSCMP0_CMP_TS0_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS0_Pos)              /*!< LEDTS TSCMP0: CMP_TS0 Mask              */
#define LEDTS_TSCMP0_CMP_TS1_Pos              8                                                       /*!< LEDTS TSCMP0: CMP_TS1 Position          */
#define LEDTS_TSCMP0_CMP_TS1_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS1_Pos)              /*!< LEDTS TSCMP0: CMP_TS1 Mask              */
#define LEDTS_TSCMP0_CMP_TS2_Pos              16                                                      /*!< LEDTS TSCMP0: CMP_TS2 Position          */
#define LEDTS_TSCMP0_CMP_TS2_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS2_Pos)              /*!< LEDTS TSCMP0: CMP_TS2 Mask              */
#define LEDTS_TSCMP0_CMP_TS3_Pos              24                                                      /*!< LEDTS TSCMP0: CMP_TS3 Position          */
#define LEDTS_TSCMP0_CMP_TS3_Msk              (0x000000ffUL << LEDTS_TSCMP0_CMP_TS3_Pos)              /*!< LEDTS TSCMP0: CMP_TS3 Mask              */

/* --------------------------------  LEDTS_TSCMP1  -------------------------------- */
#define LEDTS_TSCMP1_CMP_TS4_Pos              0                                                       /*!< LEDTS TSCMP1: CMP_TS4 Position          */
#define LEDTS_TSCMP1_CMP_TS4_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS4_Pos)              /*!< LEDTS TSCMP1: CMP_TS4 Mask              */
#define LEDTS_TSCMP1_CMP_TS5_Pos              8                                                       /*!< LEDTS TSCMP1: CMP_TS5 Position          */
#define LEDTS_TSCMP1_CMP_TS5_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS5_Pos)              /*!< LEDTS TSCMP1: CMP_TS5 Mask              */
#define LEDTS_TSCMP1_CMP_TS6_Pos              16                                                      /*!< LEDTS TSCMP1: CMP_TS6 Position          */
#define LEDTS_TSCMP1_CMP_TS6_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS6_Pos)              /*!< LEDTS TSCMP1: CMP_TS6 Mask              */
#define LEDTS_TSCMP1_CMP_TS7_Pos              24                                                      /*!< LEDTS TSCMP1: CMP_TS7 Position          */
#define LEDTS_TSCMP1_CMP_TS7_Msk              (0x000000ffUL << LEDTS_TSCMP1_CMP_TS7_Pos)              /*!< LEDTS TSCMP1: CMP_TS7 Mask              */


/* ================================================================================ */
/* ================        struct 'ETH0_CON' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  ETH0_CON_ETH0_CON  ----------------------------- */
#define ETH_CON_RXD0_Pos            0                                                       /*!< ETH0_CON ETH0_CON: RXD0 Position        */
#define ETH_CON_RXD0_Msk            (0x03UL << ETH_CON_RXD0_Pos)                  /*!< ETH0_CON ETH0_CON: RXD0 Mask            */
#define ETH_CON_RXD1_Pos            2                                                       /*!< ETH0_CON ETH0_CON: RXD1 Position        */
#define ETH_CON_RXD1_Msk            (0x03UL << ETH_CON_RXD1_Pos)                  /*!< ETH0_CON ETH0_CON: RXD1 Mask            */
#define ETH_CON_RXD2_Pos            4                                                       /*!< ETH0_CON ETH0_CON: RXD2 Position        */
#define ETH_CON_RXD2_Msk            (0x03UL << ETH_CON_RXD2_Pos)                  /*!< ETH0_CON ETH0_CON: RXD2 Mask            */
#define ETH_CON_RXD3_Pos            6                                                       /*!< ETH0_CON ETH0_CON: RXD3 Position        */
#define ETH_CON_RXD3_Msk            (0x03UL << ETH_CON_RXD3_Pos)                  /*!< ETH0_CON ETH0_CON: RXD3 Mask            */
#define ETH_CON_CLK_RMII_Pos        8                                                       /*!< ETH0_CON ETH0_CON: CLK_RMII Position    */
#define ETH_CON_CLK_RMII_Msk        (0x03UL << ETH_CON_CLK_RMII_Pos)              /*!< ETH0_CON ETH0_CON: CLK_RMII Mask        */
#define ETH_CON_CRS_DV_Pos          10                                                      /*!< ETH0_CON ETH0_CON: CRS_DV Position      */
#define ETH_CON_CRS_DV_Msk          (0x03UL << ETH_CON_CRS_DV_Pos)                /*!< ETH0_CON ETH0_CON: CRS_DV Mask          */
#define ETH_CON_CRS_Pos             12                                                      /*!< ETH0_CON ETH0_CON: CRS Position         */
#define ETH_CON_CRS_Msk             (0x03UL << ETH_CON_CRS_Pos)                   /*!< ETH0_CON ETH0_CON: CRS Mask             */
#define ETH_CON_RXER_Pos            14                                                      /*!< ETH0_CON ETH0_CON: RXER Position        */
#define ETH_CON_RXER_Msk            (0x03UL << ETH_CON_RXER_Pos)                  /*!< ETH0_CON ETH0_CON: RXER Mask            */
#define ETH_CON_COL_Pos             16                                                      /*!< ETH0_CON ETH0_CON: COL Position         */
#define ETH_CON_COL_Msk             (0x03UL << ETH_CON_COL_Pos)                   /*!< ETH0_CON ETH0_CON: COL Mask             */
#define ETH_CON_CLK_TX_Pos          18                                                      /*!< ETH0_CON ETH0_CON: CLK_TX Position      */
#define ETH_CON_CLK_TX_Msk          (0x03UL << ETH_CON_CLK_TX_Pos)                /*!< ETH0_CON ETH0_CON: CLK_TX Mask          */
#define ETH_CON_MDIO_Pos            22                                                      /*!< ETH0_CON ETH0_CON: MDIO Position        */
#define ETH_CON_MDIO_Msk            (0x03UL << ETH_CON_MDIO_Pos)                  /*!< ETH0_CON ETH0_CON: MDIO Mask            */
#define ETH_CON_INFSEL_Pos          26                                                      /*!< ETH0_CON ETH0_CON: INFSEL Position      */
#define ETH_CON_INFSEL_Msk          (0x01UL << ETH_CON_INFSEL_Pos)                /*!< ETH0_CON ETH0_CON: INFSEL Mask          */


/* ================================================================================ */
/* ================           Group 'ETH' Position & Mask          ================ */
/* ================================================================================ */


/* ----------------------------  ETH_MAC_CONFIGURATION  --------------------------- */
#define ETH_MAC_CONFIGURATION_PRELEN_Pos      0                                                       /*!< ETH MAC_CONFIGURATION: PRELEN Position  */
#define ETH_MAC_CONFIGURATION_PRELEN_Msk      (0x03UL << ETH_MAC_CONFIGURATION_PRELEN_Pos)            /*!< ETH MAC_CONFIGURATION: PRELEN Mask      */
#define ETH_MAC_CONFIGURATION_RE_Pos          2                                                       /*!< ETH MAC_CONFIGURATION: RE Position      */
#define ETH_MAC_CONFIGURATION_RE_Msk          (0x01UL << ETH_MAC_CONFIGURATION_RE_Pos)                /*!< ETH MAC_CONFIGURATION: RE Mask          */
#define ETH_MAC_CONFIGURATION_TE_Pos          3                                                       /*!< ETH MAC_CONFIGURATION: TE Position      */
#define ETH_MAC_CONFIGURATION_TE_Msk          (0x01UL << ETH_MAC_CONFIGURATION_TE_Pos)                /*!< ETH MAC_CONFIGURATION: TE Mask          */
#define ETH_MAC_CONFIGURATION_DC_Pos          4                                                       /*!< ETH MAC_CONFIGURATION: DC Position      */
#define ETH_MAC_CONFIGURATION_DC_Msk          (0x01UL << ETH_MAC_CONFIGURATION_DC_Pos)                /*!< ETH MAC_CONFIGURATION: DC Mask          */
#define ETH_MAC_CONFIGURATION_BL_Pos          5                                                       /*!< ETH MAC_CONFIGURATION: BL Position      */
#define ETH_MAC_CONFIGURATION_BL_Msk          (0x03UL << ETH_MAC_CONFIGURATION_BL_Pos)                /*!< ETH MAC_CONFIGURATION: BL Mask          */
#define ETH_MAC_CONFIGURATION_ACS_Pos         7                                                       /*!< ETH MAC_CONFIGURATION: ACS Position     */
#define ETH_MAC_CONFIGURATION_ACS_Msk         (0x01UL << ETH_MAC_CONFIGURATION_ACS_Pos)               /*!< ETH MAC_CONFIGURATION: ACS Mask         */
#define ETH_MAC_CONFIGURATION_Reserved_8_Pos  8                                                       /*!< ETH MAC_CONFIGURATION: Reserved_8 Position */
#define ETH_MAC_CONFIGURATION_Reserved_8_Msk  (0x01UL << ETH_MAC_CONFIGURATION_Reserved_8_Pos)        /*!< ETH MAC_CONFIGURATION: Reserved_8 Mask  */
#define ETH_MAC_CONFIGURATION_DR_Pos          9                                                       /*!< ETH MAC_CONFIGURATION: DR Position      */
#define ETH_MAC_CONFIGURATION_DR_Msk          (0x01UL << ETH_MAC_CONFIGURATION_DR_Pos)                /*!< ETH MAC_CONFIGURATION: DR Mask          */
#define ETH_MAC_CONFIGURATION_IPC_Pos         10                                                      /*!< ETH MAC_CONFIGURATION: IPC Position     */
#define ETH_MAC_CONFIGURATION_IPC_Msk         (0x01UL << ETH_MAC_CONFIGURATION_IPC_Pos)               /*!< ETH MAC_CONFIGURATION: IPC Mask         */
#define ETH_MAC_CONFIGURATION_DM_Pos          11                                                      /*!< ETH MAC_CONFIGURATION: DM Position      */
#define ETH_MAC_CONFIGURATION_DM_Msk          (0x01UL << ETH_MAC_CONFIGURATION_DM_Pos)                /*!< ETH MAC_CONFIGURATION: DM Mask          */
#define ETH_MAC_CONFIGURATION_LM_Pos          12                                                      /*!< ETH MAC_CONFIGURATION: LM Position      */
#define ETH_MAC_CONFIGURATION_LM_Msk          (0x01UL << ETH_MAC_CONFIGURATION_LM_Pos)                /*!< ETH MAC_CONFIGURATION: LM Mask          */
#define ETH_MAC_CONFIGURATION_DO_Pos          13                                                      /*!< ETH MAC_CONFIGURATION: DO Position      */
#define ETH_MAC_CONFIGURATION_DO_Msk          (0x01UL << ETH_MAC_CONFIGURATION_DO_Pos)                /*!< ETH MAC_CONFIGURATION: DO Mask          */
#define ETH_MAC_CONFIGURATION_FES_Pos         14                                                      /*!< ETH MAC_CONFIGURATION: FES Position     */
#define ETH_MAC_CONFIGURATION_FES_Msk         (0x01UL << ETH_MAC_CONFIGURATION_FES_Pos)               /*!< ETH MAC_CONFIGURATION: FES Mask         */
#define ETH_MAC_CONFIGURATION_DCRS_Pos        16                                                      /*!< ETH MAC_CONFIGURATION: DCRS Position    */
#define ETH_MAC_CONFIGURATION_DCRS_Msk        (0x01UL << ETH_MAC_CONFIGURATION_DCRS_Pos)              /*!< ETH MAC_CONFIGURATION: DCRS Mask        */
#define ETH_MAC_CONFIGURATION_IFG_Pos         17                                                      /*!< ETH MAC_CONFIGURATION: IFG Position     */
#define ETH_MAC_CONFIGURATION_IFG_Msk         (0x07UL << ETH_MAC_CONFIGURATION_IFG_Pos)               /*!< ETH MAC_CONFIGURATION: IFG Mask         */
#define ETH_MAC_CONFIGURATION_JE_Pos          20                                                      /*!< ETH MAC_CONFIGURATION: JE Position      */
#define ETH_MAC_CONFIGURATION_JE_Msk          (0x01UL << ETH_MAC_CONFIGURATION_JE_Pos)                /*!< ETH MAC_CONFIGURATION: JE Mask          */
#define ETH_MAC_CONFIGURATION_BE_Pos          21                                                      /*!< ETH MAC_CONFIGURATION: BE Position      */
#define ETH_MAC_CONFIGURATION_BE_Msk          (0x01UL << ETH_MAC_CONFIGURATION_BE_Pos)                /*!< ETH MAC_CONFIGURATION: BE Mask          */
#define ETH_MAC_CONFIGURATION_JD_Pos          22                                                      /*!< ETH MAC_CONFIGURATION: JD Position      */
#define ETH_MAC_CONFIGURATION_JD_Msk          (0x01UL << ETH_MAC_CONFIGURATION_JD_Pos)                /*!< ETH MAC_CONFIGURATION: JD Mask          */
#define ETH_MAC_CONFIGURATION_WD_Pos          23                                                      /*!< ETH MAC_CONFIGURATION: WD Position      */
#define ETH_MAC_CONFIGURATION_WD_Msk          (0x01UL << ETH_MAC_CONFIGURATION_WD_Pos)                /*!< ETH MAC_CONFIGURATION: WD Mask          */
#define ETH_MAC_CONFIGURATION_TC_Pos          24                                                      /*!< ETH MAC_CONFIGURATION: TC Position      */
#define ETH_MAC_CONFIGURATION_TC_Msk          (0x01UL << ETH_MAC_CONFIGURATION_TC_Pos)                /*!< ETH MAC_CONFIGURATION: TC Mask          */
#define ETH_MAC_CONFIGURATION_CST_Pos         25                                                      /*!< ETH MAC_CONFIGURATION: CST Position     */
#define ETH_MAC_CONFIGURATION_CST_Msk         (0x01UL << ETH_MAC_CONFIGURATION_CST_Pos)               /*!< ETH MAC_CONFIGURATION: CST Mask         */
#define ETH_MAC_CONFIGURATION_Reserved_26_Pos 26                                                      /*!< ETH MAC_CONFIGURATION: Reserved_26 Position */
#define ETH_MAC_CONFIGURATION_Reserved_26_Msk (0x01UL << ETH_MAC_CONFIGURATION_Reserved_26_Pos)       /*!< ETH MAC_CONFIGURATION: Reserved_26 Mask */
#define ETH_MAC_CONFIGURATION_TWOKPE_Pos      27                                                      /*!< ETH MAC_CONFIGURATION: TWOKPE Position  */
#define ETH_MAC_CONFIGURATION_TWOKPE_Msk      (0x01UL << ETH_MAC_CONFIGURATION_TWOKPE_Pos)            /*!< ETH MAC_CONFIGURATION: TWOKPE Mask      */
#define ETH_MAC_CONFIGURATION_SARC_Pos        28                                                      /*!< ETH MAC_CONFIGURATION: SARC Position    */
#define ETH_MAC_CONFIGURATION_SARC_Msk        (0x07UL << ETH_MAC_CONFIGURATION_SARC_Pos)              /*!< ETH MAC_CONFIGURATION: SARC Mask        */
#define ETH_MAC_CONFIGURATION_Reserved_31_Pos 31                                                      /*!< ETH MAC_CONFIGURATION: Reserved_31 Position */
#define ETH_MAC_CONFIGURATION_Reserved_31_Msk (0x01UL << ETH_MAC_CONFIGURATION_Reserved_31_Pos)       /*!< ETH MAC_CONFIGURATION: Reserved_31 Mask */

/* ----------------------------  ETH_MAC_FRAME_FILTER  ---------------------------- */
#define ETH_MAC_FRAME_FILTER_PR_Pos           0                                                       /*!< ETH MAC_FRAME_FILTER: PR Position       */
#define ETH_MAC_FRAME_FILTER_PR_Msk           (0x01UL << ETH_MAC_FRAME_FILTER_PR_Pos)                 /*!< ETH MAC_FRAME_FILTER: PR Mask           */
#define ETH_MAC_FRAME_FILTER_HUC_Pos          1                                                       /*!< ETH MAC_FRAME_FILTER: HUC Position      */
#define ETH_MAC_FRAME_FILTER_HUC_Msk          (0x01UL << ETH_MAC_FRAME_FILTER_HUC_Pos)                /*!< ETH MAC_FRAME_FILTER: HUC Mask          */
#define ETH_MAC_FRAME_FILTER_HMC_Pos          2                                                       /*!< ETH MAC_FRAME_FILTER: HMC Position      */
#define ETH_MAC_FRAME_FILTER_HMC_Msk          (0x01UL << ETH_MAC_FRAME_FILTER_HMC_Pos)                /*!< ETH MAC_FRAME_FILTER: HMC Mask          */
#define ETH_MAC_FRAME_FILTER_DAIF_Pos         3                                                       /*!< ETH MAC_FRAME_FILTER: DAIF Position     */
#define ETH_MAC_FRAME_FILTER_DAIF_Msk         (0x01UL << ETH_MAC_FRAME_FILTER_DAIF_Pos)               /*!< ETH MAC_FRAME_FILTER: DAIF Mask         */
#define ETH_MAC_FRAME_FILTER_PM_Pos           4                                                       /*!< ETH MAC_FRAME_FILTER: PM Position       */
#define ETH_MAC_FRAME_FILTER_PM_Msk           (0x01UL << ETH_MAC_FRAME_FILTER_PM_Pos)                 /*!< ETH MAC_FRAME_FILTER: PM Mask           */
#define ETH_MAC_FRAME_FILTER_DBF_Pos          5                                                       /*!< ETH MAC_FRAME_FILTER: DBF Position      */
#define ETH_MAC_FRAME_FILTER_DBF_Msk          (0x01UL << ETH_MAC_FRAME_FILTER_DBF_Pos)                /*!< ETH MAC_FRAME_FILTER: DBF Mask          */
#define ETH_MAC_FRAME_FILTER_PCF_Pos          6                                                       /*!< ETH MAC_FRAME_FILTER: PCF Position      */
#define ETH_MAC_FRAME_FILTER_PCF_Msk          (0x03UL << ETH_MAC_FRAME_FILTER_PCF_Pos)                /*!< ETH MAC_FRAME_FILTER: PCF Mask          */
#define ETH_MAC_FRAME_FILTER_SAIF_Pos         8                                                       /*!< ETH MAC_FRAME_FILTER: SAIF Position     */
#define ETH_MAC_FRAME_FILTER_SAIF_Msk         (0x01UL << ETH_MAC_FRAME_FILTER_SAIF_Pos)               /*!< ETH MAC_FRAME_FILTER: SAIF Mask         */
#define ETH_MAC_FRAME_FILTER_SAF_Pos          9                                                       /*!< ETH MAC_FRAME_FILTER: SAF Position      */
#define ETH_MAC_FRAME_FILTER_SAF_Msk          (0x01UL << ETH_MAC_FRAME_FILTER_SAF_Pos)                /*!< ETH MAC_FRAME_FILTER: SAF Mask          */
#define ETH_MAC_FRAME_FILTER_HPF_Pos          10                                                      /*!< ETH MAC_FRAME_FILTER: HPF Position      */
#define ETH_MAC_FRAME_FILTER_HPF_Msk          (0x01UL << ETH_MAC_FRAME_FILTER_HPF_Pos)                /*!< ETH MAC_FRAME_FILTER: HPF Mask          */
#define ETH_MAC_FRAME_FILTER_Reserved_15_11_Pos 11                                                    /*!< ETH MAC_FRAME_FILTER: Reserved_15_11 Position */
#define ETH_MAC_FRAME_FILTER_Reserved_15_11_Msk (0x1fUL << ETH_MAC_FRAME_FILTER_Reserved_15_11_Pos)   /*!< ETH MAC_FRAME_FILTER: Reserved_15_11 Mask */
#define ETH_MAC_FRAME_FILTER_VTFE_Pos         16                                                      /*!< ETH MAC_FRAME_FILTER: VTFE Position     */
#define ETH_MAC_FRAME_FILTER_VTFE_Msk         (0x01UL << ETH_MAC_FRAME_FILTER_VTFE_Pos)               /*!< ETH MAC_FRAME_FILTER: VTFE Mask         */
#define ETH_MAC_FRAME_FILTER_Reserved_19_17_Pos 17                                                    /*!< ETH MAC_FRAME_FILTER: Reserved_19_17 Position */
#define ETH_MAC_FRAME_FILTER_Reserved_19_17_Msk (0x07UL << ETH_MAC_FRAME_FILTER_Reserved_19_17_Pos)   /*!< ETH MAC_FRAME_FILTER: Reserved_19_17 Mask */
#define ETH_MAC_FRAME_FILTER_IPFE_Pos         20                                                      /*!< ETH MAC_FRAME_FILTER: IPFE Position     */
#define ETH_MAC_FRAME_FILTER_IPFE_Msk         (0x01UL << ETH_MAC_FRAME_FILTER_IPFE_Pos)               /*!< ETH MAC_FRAME_FILTER: IPFE Mask         */
#define ETH_MAC_FRAME_FILTER_DNTU_Pos         21                                                      /*!< ETH MAC_FRAME_FILTER: DNTU Position     */
#define ETH_MAC_FRAME_FILTER_DNTU_Msk         (0x01UL << ETH_MAC_FRAME_FILTER_DNTU_Pos)               /*!< ETH MAC_FRAME_FILTER: DNTU Mask         */
#define ETH_MAC_FRAME_FILTER_Reserved_30_22_Pos 22                                                    /*!< ETH MAC_FRAME_FILTER: Reserved_30_22 Position */
#define ETH_MAC_FRAME_FILTER_Reserved_30_22_Msk (0x000001ffUL << ETH_MAC_FRAME_FILTER_Reserved_30_22_Pos)/*!< ETH MAC_FRAME_FILTER: Reserved_30_22 Mask */
#define ETH_MAC_FRAME_FILTER_RA_Pos           31                                                      /*!< ETH MAC_FRAME_FILTER: RA Position       */
#define ETH_MAC_FRAME_FILTER_RA_Msk           (0x01UL << ETH_MAC_FRAME_FILTER_RA_Pos)                 /*!< ETH MAC_FRAME_FILTER: RA Mask           */

/* -----------------------------  ETH_HASH_TABLE_HIGH  ---------------------------- */
#define ETH_HASH_TABLE_HIGH_HTH_Pos           0                                                       /*!< ETH HASH_TABLE_HIGH: HTH Position       */
#define ETH_HASH_TABLE_HIGH_HTH_Msk           (0xffffffffUL << ETH_HASH_TABLE_HIGH_HTH_Pos)           /*!< ETH HASH_TABLE_HIGH: HTH Mask           */

/* -----------------------------  ETH_HASH_TABLE_LOW  ----------------------------- */
#define ETH_HASH_TABLE_LOW_HTL_Pos            0                                                       /*!< ETH HASH_TABLE_LOW: HTL Position        */
#define ETH_HASH_TABLE_LOW_HTL_Msk            (0xffffffffUL << ETH_HASH_TABLE_LOW_HTL_Pos)            /*!< ETH HASH_TABLE_LOW: HTL Mask            */

/* ------------------------------  ETH_GMII_ADDRESS  ------------------------------ */
#define ETH_GMII_ADDRESS_MB_Pos               0                                                       /*!< ETH GMII_ADDRESS: MB Position           */
#define ETH_GMII_ADDRESS_MB_Msk               (0x01UL << ETH_GMII_ADDRESS_MB_Pos)                     /*!< ETH GMII_ADDRESS: MB Mask               */
#define ETH_GMII_ADDRESS_MW_Pos               1                                                       /*!< ETH GMII_ADDRESS: MW Position           */
#define ETH_GMII_ADDRESS_MW_Msk               (0x01UL << ETH_GMII_ADDRESS_MW_Pos)                     /*!< ETH GMII_ADDRESS: MW Mask               */
#define ETH_GMII_ADDRESS_CR_Pos               2                                                       /*!< ETH GMII_ADDRESS: CR Position           */
#define ETH_GMII_ADDRESS_CR_Msk               (0x0fUL << ETH_GMII_ADDRESS_CR_Pos)                     /*!< ETH GMII_ADDRESS: CR Mask               */
#define ETH_GMII_ADDRESS_MR_Pos               6                                                       /*!< ETH GMII_ADDRESS: MR Position           */
#define ETH_GMII_ADDRESS_MR_Msk               (0x1fUL << ETH_GMII_ADDRESS_MR_Pos)                     /*!< ETH GMII_ADDRESS: MR Mask               */
#define ETH_GMII_ADDRESS_PA_Pos               11                                                      /*!< ETH GMII_ADDRESS: PA Position           */
#define ETH_GMII_ADDRESS_PA_Msk               (0x1fUL << ETH_GMII_ADDRESS_PA_Pos)                     /*!< ETH GMII_ADDRESS: PA Mask               */
#define ETH_GMII_ADDRESS_Reserved_31_16_Pos   16                                                      /*!< ETH GMII_ADDRESS: Reserved_31_16 Position */
#define ETH_GMII_ADDRESS_Reserved_31_16_Msk   (0x0000ffffUL << ETH_GMII_ADDRESS_Reserved_31_16_Pos)   /*!< ETH GMII_ADDRESS: Reserved_31_16 Mask   */

/* --------------------------------  ETH_GMII_DATA  ------------------------------- */
#define ETH_GMII_DATA_MD_Pos                  0                                                       /*!< ETH GMII_DATA: MD Position              */
#define ETH_GMII_DATA_MD_Msk                  (0x0000ffffUL << ETH_GMII_DATA_MD_Pos)                  /*!< ETH GMII_DATA: MD Mask                  */
#define ETH_GMII_DATA_Reserved_31_16_Pos      16                                                      /*!< ETH GMII_DATA: Reserved_31_16 Position  */
#define ETH_GMII_DATA_Reserved_31_16_Msk      (0x0000ffffUL << ETH_GMII_DATA_Reserved_31_16_Pos)      /*!< ETH GMII_DATA: Reserved_31_16 Mask      */

/* ------------------------------  ETH_FLOW_CONTROL  ------------------------------ */
#define ETH_FLOW_CONTROL_FCA_BPA_Pos          0                                                       /*!< ETH FLOW_CONTROL: FCA_BPA Position      */
#define ETH_FLOW_CONTROL_FCA_BPA_Msk          (0x01UL << ETH_FLOW_CONTROL_FCA_BPA_Pos)                /*!< ETH FLOW_CONTROL: FCA_BPA Mask          */
#define ETH_FLOW_CONTROL_TFE_Pos              1                                                       /*!< ETH FLOW_CONTROL: TFE Position          */
#define ETH_FLOW_CONTROL_TFE_Msk              (0x01UL << ETH_FLOW_CONTROL_TFE_Pos)                    /*!< ETH FLOW_CONTROL: TFE Mask              */
#define ETH_FLOW_CONTROL_RFE_Pos              2                                                       /*!< ETH FLOW_CONTROL: RFE Position          */
#define ETH_FLOW_CONTROL_RFE_Msk              (0x01UL << ETH_FLOW_CONTROL_RFE_Pos)                    /*!< ETH FLOW_CONTROL: RFE Mask              */
#define ETH_FLOW_CONTROL_UP_Pos               3                                                       /*!< ETH FLOW_CONTROL: UP Position           */
#define ETH_FLOW_CONTROL_UP_Msk               (0x01UL << ETH_FLOW_CONTROL_UP_Pos)                     /*!< ETH FLOW_CONTROL: UP Mask               */
#define ETH_FLOW_CONTROL_PLT_Pos              4                                                       /*!< ETH FLOW_CONTROL: PLT Position          */
#define ETH_FLOW_CONTROL_PLT_Msk              (0x03UL << ETH_FLOW_CONTROL_PLT_Pos)                    /*!< ETH FLOW_CONTROL: PLT Mask              */
#define ETH_FLOW_CONTROL_Reserved_6_Pos       6                                                       /*!< ETH FLOW_CONTROL: Reserved_6 Position   */
#define ETH_FLOW_CONTROL_Reserved_6_Msk       (0x01UL << ETH_FLOW_CONTROL_Reserved_6_Pos)             /*!< ETH FLOW_CONTROL: Reserved_6 Mask       */
#define ETH_FLOW_CONTROL_DZPQ_Pos             7                                                       /*!< ETH FLOW_CONTROL: DZPQ Position         */
#define ETH_FLOW_CONTROL_DZPQ_Msk             (0x01UL << ETH_FLOW_CONTROL_DZPQ_Pos)                   /*!< ETH FLOW_CONTROL: DZPQ Mask             */
#define ETH_FLOW_CONTROL_Reserved_15_8_Pos    8                                                       /*!< ETH FLOW_CONTROL: Reserved_15_8 Position */
#define ETH_FLOW_CONTROL_Reserved_15_8_Msk    (0x000000ffUL << ETH_FLOW_CONTROL_Reserved_15_8_Pos)    /*!< ETH FLOW_CONTROL: Reserved_15_8 Mask    */
#define ETH_FLOW_CONTROL_PT_Pos               16                                                      /*!< ETH FLOW_CONTROL: PT Position           */
#define ETH_FLOW_CONTROL_PT_Msk               (0x0000ffffUL << ETH_FLOW_CONTROL_PT_Pos)               /*!< ETH FLOW_CONTROL: PT Mask               */

/* --------------------------------  ETH_VLAN_TAG  -------------------------------- */
#define ETH_VLAN_TAG_VL_Pos                   0                                                       /*!< ETH VLAN_TAG: VL Position               */
#define ETH_VLAN_TAG_VL_Msk                   (0x0000ffffUL << ETH_VLAN_TAG_VL_Pos)                   /*!< ETH VLAN_TAG: VL Mask                   */
#define ETH_VLAN_TAG_ETV_Pos                  16                                                      /*!< ETH VLAN_TAG: ETV Position              */
#define ETH_VLAN_TAG_ETV_Msk                  (0x01UL << ETH_VLAN_TAG_ETV_Pos)                        /*!< ETH VLAN_TAG: ETV Mask                  */
#define ETH_VLAN_TAG_VTIM_Pos                 17                                                      /*!< ETH VLAN_TAG: VTIM Position             */
#define ETH_VLAN_TAG_VTIM_Msk                 (0x01UL << ETH_VLAN_TAG_VTIM_Pos)                       /*!< ETH VLAN_TAG: VTIM Mask                 */
#define ETH_VLAN_TAG_ESVL_Pos                 18                                                      /*!< ETH VLAN_TAG: ESVL Position             */
#define ETH_VLAN_TAG_ESVL_Msk                 (0x01UL << ETH_VLAN_TAG_ESVL_Pos)                       /*!< ETH VLAN_TAG: ESVL Mask                 */
#define ETH_VLAN_TAG_VTHM_Pos                 19                                                      /*!< ETH VLAN_TAG: VTHM Position             */
#define ETH_VLAN_TAG_VTHM_Msk                 (0x01UL << ETH_VLAN_TAG_VTHM_Pos)                       /*!< ETH VLAN_TAG: VTHM Mask                 */
#define ETH_VLAN_TAG_Reserved_31_20_Pos       20                                                      /*!< ETH VLAN_TAG: Reserved_31_20 Position   */
#define ETH_VLAN_TAG_Reserved_31_20_Msk       (0x00000fffUL << ETH_VLAN_TAG_Reserved_31_20_Pos)       /*!< ETH VLAN_TAG: Reserved_31_20 Mask       */

/* ---------------------------------  ETH_VERSION  -------------------------------- */
#define ETH_VERSION_SNPSVER_Pos               0                                                       /*!< ETH VERSION: SNPSVER Position           */
#define ETH_VERSION_SNPSVER_Msk               (0x000000ffUL << ETH_VERSION_SNPSVER_Pos)               /*!< ETH VERSION: SNPSVER Mask               */
#define ETH_VERSION_USERVER_Pos               8                                                       /*!< ETH VERSION: USERVER Position           */
#define ETH_VERSION_USERVER_Msk               (0x000000ffUL << ETH_VERSION_USERVER_Pos)               /*!< ETH VERSION: USERVER Mask               */
#define ETH_VERSION_Reserved_31_16_Pos        16                                                      /*!< ETH VERSION: Reserved_31_16 Position    */
#define ETH_VERSION_Reserved_31_16_Msk        (0x0000ffffUL << ETH_VERSION_Reserved_31_16_Pos)        /*!< ETH VERSION: Reserved_31_16 Mask        */

/* ----------------------------------  ETH_DEBUG  --------------------------------- */
#define ETH_DEBUG_RPESTS_Pos                  0                                                       /*!< ETH DEBUG: RPESTS Position              */
#define ETH_DEBUG_RPESTS_Msk                  (0x01UL << ETH_DEBUG_RPESTS_Pos)                        /*!< ETH DEBUG: RPESTS Mask                  */
#define ETH_DEBUG_RFCFCSTS_Pos                1                                                       /*!< ETH DEBUG: RFCFCSTS Position            */
#define ETH_DEBUG_RFCFCSTS_Msk                (0x03UL << ETH_DEBUG_RFCFCSTS_Pos)                      /*!< ETH DEBUG: RFCFCSTS Mask                */
#define ETH_DEBUG_Reserved_3_Pos              3                                                       /*!< ETH DEBUG: Reserved_3 Position          */
#define ETH_DEBUG_Reserved_3_Msk              (0x01UL << ETH_DEBUG_Reserved_3_Pos)                    /*!< ETH DEBUG: Reserved_3 Mask              */
#define ETH_DEBUG_RWCSTS_Pos                  4                                                       /*!< ETH DEBUG: RWCSTS Position              */
#define ETH_DEBUG_RWCSTS_Msk                  (0x01UL << ETH_DEBUG_RWCSTS_Pos)                        /*!< ETH DEBUG: RWCSTS Mask                  */
#define ETH_DEBUG_RRCSTS_Pos                  5                                                       /*!< ETH DEBUG: RRCSTS Position              */
#define ETH_DEBUG_RRCSTS_Msk                  (0x03UL << ETH_DEBUG_RRCSTS_Pos)                        /*!< ETH DEBUG: RRCSTS Mask                  */
#define ETH_DEBUG_Reserved_7_Pos              7                                                       /*!< ETH DEBUG: Reserved_7 Position          */
#define ETH_DEBUG_Reserved_7_Msk              (0x01UL << ETH_DEBUG_Reserved_7_Pos)                    /*!< ETH DEBUG: Reserved_7 Mask              */
#define ETH_DEBUG_RXFSTS_Pos                  8                                                       /*!< ETH DEBUG: RXFSTS Position              */
#define ETH_DEBUG_RXFSTS_Msk                  (0x03UL << ETH_DEBUG_RXFSTS_Pos)                        /*!< ETH DEBUG: RXFSTS Mask                  */
#define ETH_DEBUG_Reserved_15_10_Pos          10                                                      /*!< ETH DEBUG: Reserved_15_10 Position      */
#define ETH_DEBUG_Reserved_15_10_Msk          (0x3fUL << ETH_DEBUG_Reserved_15_10_Pos)                /*!< ETH DEBUG: Reserved_15_10 Mask          */
#define ETH_DEBUG_TPESTS_Pos                  16                                                      /*!< ETH DEBUG: TPESTS Position              */
#define ETH_DEBUG_TPESTS_Msk                  (0x01UL << ETH_DEBUG_TPESTS_Pos)                        /*!< ETH DEBUG: TPESTS Mask                  */
#define ETH_DEBUG_TFCSTS_Pos                  17                                                      /*!< ETH DEBUG: TFCSTS Position              */
#define ETH_DEBUG_TFCSTS_Msk                  (0x03UL << ETH_DEBUG_TFCSTS_Pos)                        /*!< ETH DEBUG: TFCSTS Mask                  */
#define ETH_DEBUG_TXPAUSED_Pos                19                                                      /*!< ETH DEBUG: TXPAUSED Position            */
#define ETH_DEBUG_TXPAUSED_Msk                (0x01UL << ETH_DEBUG_TXPAUSED_Pos)                      /*!< ETH DEBUG: TXPAUSED Mask                */
#define ETH_DEBUG_TRCSTS_Pos                  20                                                      /*!< ETH DEBUG: TRCSTS Position              */
#define ETH_DEBUG_TRCSTS_Msk                  (0x03UL << ETH_DEBUG_TRCSTS_Pos)                        /*!< ETH DEBUG: TRCSTS Mask                  */
#define ETH_DEBUG_TWCSTS_Pos                  22                                                      /*!< ETH DEBUG: TWCSTS Position              */
#define ETH_DEBUG_TWCSTS_Msk                  (0x01UL << ETH_DEBUG_TWCSTS_Pos)                        /*!< ETH DEBUG: TWCSTS Mask                  */
#define ETH_DEBUG_Reserved_23_Pos             23                                                      /*!< ETH DEBUG: Reserved_23 Position         */
#define ETH_DEBUG_Reserved_23_Msk             (0x01UL << ETH_DEBUG_Reserved_23_Pos)                   /*!< ETH DEBUG: Reserved_23 Mask             */
#define ETH_DEBUG_TXFSTS_Pos                  24                                                      /*!< ETH DEBUG: TXFSTS Position              */
#define ETH_DEBUG_TXFSTS_Msk                  (0x01UL << ETH_DEBUG_TXFSTS_Pos)                        /*!< ETH DEBUG: TXFSTS Mask                  */
#define ETH_DEBUG_TXSTSFSTS_Pos               25                                                      /*!< ETH DEBUG: TXSTSFSTS Position           */
#define ETH_DEBUG_TXSTSFSTS_Msk               (0x01UL << ETH_DEBUG_TXSTSFSTS_Pos)                     /*!< ETH DEBUG: TXSTSFSTS Mask               */
#define ETH_DEBUG_Reserved_31_26_Pos          26                                                      /*!< ETH DEBUG: Reserved_31_26 Position      */
#define ETH_DEBUG_Reserved_31_26_Msk          (0x3fUL << ETH_DEBUG_Reserved_31_26_Pos)                /*!< ETH DEBUG: Reserved_31_26 Mask          */

/* -----------------------  ETH_REMOTE_WAKE_UP_FRAME_FILTER  ---------------------- */
#define ETH_REMOTE_WAKE_UP_FRAME_FILTER_WKUPFRMFTR_Pos 0                                              /*!< ETH REMOTE_WAKE_UP_FRAME_FILTER: WKUPFRMFTR Position */
#define ETH_REMOTE_WAKE_UP_FRAME_FILTER_WKUPFRMFTR_Msk (0xffffffffUL << ETH_REMOTE_WAKE_UP_FRAME_FILTER_WKUPFRMFTR_Pos)/*!< ETH REMOTE_WAKE_UP_FRAME_FILTER: WKUPFRMFTR Mask */

/* ---------------------------  ETH_PMT_CONTROL_STATUS  --------------------------- */
#define ETH_PMT_CONTROL_STATUS_PWRDWN_Pos     0                                                       /*!< ETH PMT_CONTROL_STATUS: PWRDWN Position */
#define ETH_PMT_CONTROL_STATUS_PWRDWN_Msk     (0x01UL << ETH_PMT_CONTROL_STATUS_PWRDWN_Pos)           /*!< ETH PMT_CONTROL_STATUS: PWRDWN Mask     */
#define ETH_PMT_CONTROL_STATUS_MGKPKTEN_Pos   1                                                       /*!< ETH PMT_CONTROL_STATUS: MGKPKTEN Position */
#define ETH_PMT_CONTROL_STATUS_MGKPKTEN_Msk   (0x01UL << ETH_PMT_CONTROL_STATUS_MGKPKTEN_Pos)         /*!< ETH PMT_CONTROL_STATUS: MGKPKTEN Mask   */
#define ETH_PMT_CONTROL_STATUS_RWKPKTEN_Pos   2                                                       /*!< ETH PMT_CONTROL_STATUS: RWKPKTEN Position */
#define ETH_PMT_CONTROL_STATUS_RWKPKTEN_Msk   (0x01UL << ETH_PMT_CONTROL_STATUS_RWKPKTEN_Pos)         /*!< ETH PMT_CONTROL_STATUS: RWKPKTEN Mask   */
#define ETH_PMT_CONTROL_STATUS_Reserved_4_3_Pos 3                                                     /*!< ETH PMT_CONTROL_STATUS: Reserved_4_3 Position */
#define ETH_PMT_CONTROL_STATUS_Reserved_4_3_Msk (0x03UL << ETH_PMT_CONTROL_STATUS_Reserved_4_3_Pos)   /*!< ETH PMT_CONTROL_STATUS: Reserved_4_3 Mask */
#define ETH_PMT_CONTROL_STATUS_MGKPRCVD_Pos   5                                                       /*!< ETH PMT_CONTROL_STATUS: MGKPRCVD Position */
#define ETH_PMT_CONTROL_STATUS_MGKPRCVD_Msk   (0x01UL << ETH_PMT_CONTROL_STATUS_MGKPRCVD_Pos)         /*!< ETH PMT_CONTROL_STATUS: MGKPRCVD Mask   */
#define ETH_PMT_CONTROL_STATUS_RWKPRCVD_Pos   6                                                       /*!< ETH PMT_CONTROL_STATUS: RWKPRCVD Position */
#define ETH_PMT_CONTROL_STATUS_RWKPRCVD_Msk   (0x01UL << ETH_PMT_CONTROL_STATUS_RWKPRCVD_Pos)         /*!< ETH PMT_CONTROL_STATUS: RWKPRCVD Mask   */
#define ETH_PMT_CONTROL_STATUS_Reserved_8_7_Pos 7                                                     /*!< ETH PMT_CONTROL_STATUS: Reserved_8_7 Position */
#define ETH_PMT_CONTROL_STATUS_Reserved_8_7_Msk (0x03UL << ETH_PMT_CONTROL_STATUS_Reserved_8_7_Pos)   /*!< ETH PMT_CONTROL_STATUS: Reserved_8_7 Mask */
#define ETH_PMT_CONTROL_STATUS_GLBLUCAST_Pos  9                                                       /*!< ETH PMT_CONTROL_STATUS: GLBLUCAST Position */
#define ETH_PMT_CONTROL_STATUS_GLBLUCAST_Msk  (0x01UL << ETH_PMT_CONTROL_STATUS_GLBLUCAST_Pos)        /*!< ETH PMT_CONTROL_STATUS: GLBLUCAST Mask  */
#define ETH_PMT_CONTROL_STATUS_Reserved_30_10_Pos 10                                                  /*!< ETH PMT_CONTROL_STATUS: Reserved_30_10 Position */
#define ETH_PMT_CONTROL_STATUS_Reserved_30_10_Msk (0x001fffffUL << ETH_PMT_CONTROL_STATUS_Reserved_30_10_Pos)/*!< ETH PMT_CONTROL_STATUS: Reserved_30_10 Mask */
#define ETH_PMT_CONTROL_STATUS_RWKFILTRST_Pos 31                                                      /*!< ETH PMT_CONTROL_STATUS: RWKFILTRST Position */
#define ETH_PMT_CONTROL_STATUS_RWKFILTRST_Msk (0x01UL << ETH_PMT_CONTROL_STATUS_RWKFILTRST_Pos)       /*!< ETH PMT_CONTROL_STATUS: RWKFILTRST Mask */

/* ----------------------------  ETH_INTERRUPT_STATUS  ---------------------------- */
#define ETH_INTERRUPT_STATUS_Reserved_2_0_Pos 0                                                       /*!< ETH INTERRUPT_STATUS: Reserved_2_0 Position */
#define ETH_INTERRUPT_STATUS_Reserved_2_0_Msk (0x07UL << ETH_INTERRUPT_STATUS_Reserved_2_0_Pos)       /*!< ETH INTERRUPT_STATUS: Reserved_2_0 Mask */
#define ETH_INTERRUPT_STATUS_PMTIS_Pos        3                                                       /*!< ETH INTERRUPT_STATUS: PMTIS Position    */
#define ETH_INTERRUPT_STATUS_PMTIS_Msk        (0x01UL << ETH_INTERRUPT_STATUS_PMTIS_Pos)              /*!< ETH INTERRUPT_STATUS: PMTIS Mask        */
#define ETH_INTERRUPT_STATUS_MMCIS_Pos        4                                                       /*!< ETH INTERRUPT_STATUS: MMCIS Position    */
#define ETH_INTERRUPT_STATUS_MMCIS_Msk        (0x01UL << ETH_INTERRUPT_STATUS_MMCIS_Pos)              /*!< ETH INTERRUPT_STATUS: MMCIS Mask        */
#define ETH_INTERRUPT_STATUS_MMCRXIS_Pos      5                                                       /*!< ETH INTERRUPT_STATUS: MMCRXIS Position  */
#define ETH_INTERRUPT_STATUS_MMCRXIS_Msk      (0x01UL << ETH_INTERRUPT_STATUS_MMCRXIS_Pos)            /*!< ETH INTERRUPT_STATUS: MMCRXIS Mask      */
#define ETH_INTERRUPT_STATUS_MMCTXIS_Pos      6                                                       /*!< ETH INTERRUPT_STATUS: MMCTXIS Position  */
#define ETH_INTERRUPT_STATUS_MMCTXIS_Msk      (0x01UL << ETH_INTERRUPT_STATUS_MMCTXIS_Pos)            /*!< ETH INTERRUPT_STATUS: MMCTXIS Mask      */
#define ETH_INTERRUPT_STATUS_MMCRXIPIS_Pos    7                                                       /*!< ETH INTERRUPT_STATUS: MMCRXIPIS Position */
#define ETH_INTERRUPT_STATUS_MMCRXIPIS_Msk    (0x01UL << ETH_INTERRUPT_STATUS_MMCRXIPIS_Pos)          /*!< ETH INTERRUPT_STATUS: MMCRXIPIS Mask    */
#define ETH_INTERRUPT_STATUS_Reserved_8_Pos   8                                                       /*!< ETH INTERRUPT_STATUS: Reserved_8 Position */
#define ETH_INTERRUPT_STATUS_Reserved_8_Msk   (0x01UL << ETH_INTERRUPT_STATUS_Reserved_8_Pos)         /*!< ETH INTERRUPT_STATUS: Reserved_8 Mask   */
#define ETH_INTERRUPT_STATUS_TSIS_Pos         9                                                       /*!< ETH INTERRUPT_STATUS: TSIS Position     */
#define ETH_INTERRUPT_STATUS_TSIS_Msk         (0x01UL << ETH_INTERRUPT_STATUS_TSIS_Pos)               /*!< ETH INTERRUPT_STATUS: TSIS Mask         */
#define ETH_INTERRUPT_STATUS_Reserved_10_Pos  10                                                      /*!< ETH INTERRUPT_STATUS: Reserved_10 Position */
#define ETH_INTERRUPT_STATUS_Reserved_10_Msk  (0x01UL << ETH_INTERRUPT_STATUS_Reserved_10_Pos)        /*!< ETH INTERRUPT_STATUS: Reserved_10 Mask  */
#define ETH_INTERRUPT_STATUS_Reserved_31_11_Pos 11                                                    /*!< ETH INTERRUPT_STATUS: Reserved_31_11 Position */
#define ETH_INTERRUPT_STATUS_Reserved_31_11_Msk (0x001fffffUL << ETH_INTERRUPT_STATUS_Reserved_31_11_Pos)/*!< ETH INTERRUPT_STATUS: Reserved_31_11 Mask */

/* -----------------------------  ETH_INTERRUPT_MASK  ----------------------------- */
#define ETH_INTERRUPT_MASK_Reserved_2_0_Pos   0                                                       /*!< ETH INTERRUPT_MASK: Reserved_2_0 Position */
#define ETH_INTERRUPT_MASK_Reserved_2_0_Msk   (0x07UL << ETH_INTERRUPT_MASK_Reserved_2_0_Pos)         /*!< ETH INTERRUPT_MASK: Reserved_2_0 Mask   */
#define ETH_INTERRUPT_MASK_PMTIM_Pos          3                                                       /*!< ETH INTERRUPT_MASK: PMTIM Position      */
#define ETH_INTERRUPT_MASK_PMTIM_Msk          (0x01UL << ETH_INTERRUPT_MASK_PMTIM_Pos)                /*!< ETH INTERRUPT_MASK: PMTIM Mask          */
#define ETH_INTERRUPT_MASK_Reserved_8_4_Pos   4                                                       /*!< ETH INTERRUPT_MASK: Reserved_8_4 Position */
#define ETH_INTERRUPT_MASK_Reserved_8_4_Msk   (0x1fUL << ETH_INTERRUPT_MASK_Reserved_8_4_Pos)         /*!< ETH INTERRUPT_MASK: Reserved_8_4 Mask   */
#define ETH_INTERRUPT_MASK_TSIM_Pos           9                                                       /*!< ETH INTERRUPT_MASK: TSIM Position       */
#define ETH_INTERRUPT_MASK_TSIM_Msk           (0x01UL << ETH_INTERRUPT_MASK_TSIM_Pos)                 /*!< ETH INTERRUPT_MASK: TSIM Mask           */
#define ETH_INTERRUPT_MASK_Reserved_31_10_Pos 10                                                      /*!< ETH INTERRUPT_MASK: Reserved_31_10 Position */
#define ETH_INTERRUPT_MASK_Reserved_31_10_Msk (0x003fffffUL << ETH_INTERRUPT_MASK_Reserved_31_10_Pos) /*!< ETH INTERRUPT_MASK: Reserved_31_10 Mask */

/* ----------------------------  ETH_MAC_ADDRESS0_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS0_HIGH_ADDRHI_Pos      0                                                       /*!< ETH MAC_ADDRESS0_HIGH: ADDRHI Position  */
#define ETH_MAC_ADDRESS0_HIGH_ADDRHI_Msk      (0x0000ffffUL << ETH_MAC_ADDRESS0_HIGH_ADDRHI_Pos)      /*!< ETH MAC_ADDRESS0_HIGH: ADDRHI Mask      */
#define ETH_MAC_ADDRESS0_HIGH_Reserved_30_16_Pos 16                                                   /*!< ETH MAC_ADDRESS0_HIGH: Reserved_30_16 Position */
#define ETH_MAC_ADDRESS0_HIGH_Reserved_30_16_Msk (0x00007fffUL << ETH_MAC_ADDRESS0_HIGH_Reserved_30_16_Pos)/*!< ETH MAC_ADDRESS0_HIGH: Reserved_30_16 Mask */
#define ETH_MAC_ADDRESS0_HIGH_AE_Pos          31                                                      /*!< ETH MAC_ADDRESS0_HIGH: AE Position      */
#define ETH_MAC_ADDRESS0_HIGH_AE_Msk          (0x01UL << ETH_MAC_ADDRESS0_HIGH_AE_Pos)                /*!< ETH MAC_ADDRESS0_HIGH: AE Mask          */

/* ----------------------------  ETH_MAC_ADDRESS0_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS0_LOW_ADDRLO_Pos       0                                                       /*!< ETH MAC_ADDRESS0_LOW: ADDRLO Position   */
#define ETH_MAC_ADDRESS0_LOW_ADDRLO_Msk       (0xffffffffUL << ETH_MAC_ADDRESS0_LOW_ADDRLO_Pos)       /*!< ETH MAC_ADDRESS0_LOW: ADDRLO Mask       */

/* ----------------------------  ETH_MAC_ADDRESS1_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS1_HIGH_ADDRHI_Pos      0                                                       /*!< ETH MAC_ADDRESS1_HIGH: ADDRHI Position  */
#define ETH_MAC_ADDRESS1_HIGH_ADDRHI_Msk      (0x0000ffffUL << ETH_MAC_ADDRESS1_HIGH_ADDRHI_Pos)      /*!< ETH MAC_ADDRESS1_HIGH: ADDRHI Mask      */
#define ETH_MAC_ADDRESS1_HIGH_Reserved_23_16_Pos 16                                                   /*!< ETH MAC_ADDRESS1_HIGH: Reserved_23_16 Position */
#define ETH_MAC_ADDRESS1_HIGH_Reserved_23_16_Msk (0x000000ffUL << ETH_MAC_ADDRESS1_HIGH_Reserved_23_16_Pos)/*!< ETH MAC_ADDRESS1_HIGH: Reserved_23_16 Mask */
#define ETH_MAC_ADDRESS1_HIGH_MBC_Pos         24                                                      /*!< ETH MAC_ADDRESS1_HIGH: MBC Position     */
#define ETH_MAC_ADDRESS1_HIGH_MBC_Msk         (0x3fUL << ETH_MAC_ADDRESS1_HIGH_MBC_Pos)               /*!< ETH MAC_ADDRESS1_HIGH: MBC Mask         */
#define ETH_MAC_ADDRESS1_HIGH_SA_Pos          30                                                      /*!< ETH MAC_ADDRESS1_HIGH: SA Position      */
#define ETH_MAC_ADDRESS1_HIGH_SA_Msk          (0x01UL << ETH_MAC_ADDRESS1_HIGH_SA_Pos)                /*!< ETH MAC_ADDRESS1_HIGH: SA Mask          */
#define ETH_MAC_ADDRESS1_HIGH_AE_Pos          31                                                      /*!< ETH MAC_ADDRESS1_HIGH: AE Position      */
#define ETH_MAC_ADDRESS1_HIGH_AE_Msk          (0x01UL << ETH_MAC_ADDRESS1_HIGH_AE_Pos)                /*!< ETH MAC_ADDRESS1_HIGH: AE Mask          */

/* ----------------------------  ETH_MAC_ADDRESS1_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS1_LOW_ADDRLO_Pos       0                                                       /*!< ETH MAC_ADDRESS1_LOW: ADDRLO Position   */
#define ETH_MAC_ADDRESS1_LOW_ADDRLO_Msk       (0xffffffffUL << ETH_MAC_ADDRESS1_LOW_ADDRLO_Pos)       /*!< ETH MAC_ADDRESS1_LOW: ADDRLO Mask       */

/* ----------------------------  ETH_MAC_ADDRESS2_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS2_HIGH_ADDRHI_Pos      0                                                       /*!< ETH MAC_ADDRESS2_HIGH: ADDRHI Position  */
#define ETH_MAC_ADDRESS2_HIGH_ADDRHI_Msk      (0x0000ffffUL << ETH_MAC_ADDRESS2_HIGH_ADDRHI_Pos)      /*!< ETH MAC_ADDRESS2_HIGH: ADDRHI Mask      */
#define ETH_MAC_ADDRESS2_HIGH_Reserved_23_16_Pos 16                                                   /*!< ETH MAC_ADDRESS2_HIGH: Reserved_23_16 Position */
#define ETH_MAC_ADDRESS2_HIGH_Reserved_23_16_Msk (0x000000ffUL << ETH_MAC_ADDRESS2_HIGH_Reserved_23_16_Pos)/*!< ETH MAC_ADDRESS2_HIGH: Reserved_23_16 Mask */
#define ETH_MAC_ADDRESS2_HIGH_MBC_Pos         24                                                      /*!< ETH MAC_ADDRESS2_HIGH: MBC Position     */
#define ETH_MAC_ADDRESS2_HIGH_MBC_Msk         (0x3fUL << ETH_MAC_ADDRESS2_HIGH_MBC_Pos)               /*!< ETH MAC_ADDRESS2_HIGH: MBC Mask         */
#define ETH_MAC_ADDRESS2_HIGH_SA_Pos          30                                                      /*!< ETH MAC_ADDRESS2_HIGH: SA Position      */
#define ETH_MAC_ADDRESS2_HIGH_SA_Msk          (0x01UL << ETH_MAC_ADDRESS2_HIGH_SA_Pos)                /*!< ETH MAC_ADDRESS2_HIGH: SA Mask          */
#define ETH_MAC_ADDRESS2_HIGH_AE_Pos          31                                                      /*!< ETH MAC_ADDRESS2_HIGH: AE Position      */
#define ETH_MAC_ADDRESS2_HIGH_AE_Msk          (0x01UL << ETH_MAC_ADDRESS2_HIGH_AE_Pos)                /*!< ETH MAC_ADDRESS2_HIGH: AE Mask          */

/* ----------------------------  ETH_MAC_ADDRESS2_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS2_LOW_ADDRLO_Pos       0                                                       /*!< ETH MAC_ADDRESS2_LOW: ADDRLO Position   */
#define ETH_MAC_ADDRESS2_LOW_ADDRLO_Msk       (0xffffffffUL << ETH_MAC_ADDRESS2_LOW_ADDRLO_Pos)       /*!< ETH MAC_ADDRESS2_LOW: ADDRLO Mask       */

/* ----------------------------  ETH_MAC_ADDRESS3_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS3_HIGH_ADDRHI_Pos      0                                                       /*!< ETH MAC_ADDRESS3_HIGH: ADDRHI Position  */
#define ETH_MAC_ADDRESS3_HIGH_ADDRHI_Msk      (0x0000ffffUL << ETH_MAC_ADDRESS3_HIGH_ADDRHI_Pos)      /*!< ETH MAC_ADDRESS3_HIGH: ADDRHI Mask      */
#define ETH_MAC_ADDRESS3_HIGH_Reserved_23_16_Pos 16                                                   /*!< ETH MAC_ADDRESS3_HIGH: Reserved_23_16 Position */
#define ETH_MAC_ADDRESS3_HIGH_Reserved_23_16_Msk (0x000000ffUL << ETH_MAC_ADDRESS3_HIGH_Reserved_23_16_Pos)/*!< ETH MAC_ADDRESS3_HIGH: Reserved_23_16 Mask */
#define ETH_MAC_ADDRESS3_HIGH_MBC_Pos         24                                                      /*!< ETH MAC_ADDRESS3_HIGH: MBC Position     */
#define ETH_MAC_ADDRESS3_HIGH_MBC_Msk         (0x3fUL << ETH_MAC_ADDRESS3_HIGH_MBC_Pos)               /*!< ETH MAC_ADDRESS3_HIGH: MBC Mask         */
#define ETH_MAC_ADDRESS3_HIGH_SA_Pos          30                                                      /*!< ETH MAC_ADDRESS3_HIGH: SA Position      */
#define ETH_MAC_ADDRESS3_HIGH_SA_Msk          (0x01UL << ETH_MAC_ADDRESS3_HIGH_SA_Pos)                /*!< ETH MAC_ADDRESS3_HIGH: SA Mask          */
#define ETH_MAC_ADDRESS3_HIGH_AE_Pos          31                                                      /*!< ETH MAC_ADDRESS3_HIGH: AE Position      */
#define ETH_MAC_ADDRESS3_HIGH_AE_Msk          (0x01UL << ETH_MAC_ADDRESS3_HIGH_AE_Pos)                /*!< ETH MAC_ADDRESS3_HIGH: AE Mask          */

/* ----------------------------  ETH_MAC_ADDRESS3_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS3_LOW_ADDRLO_Pos       0                                                       /*!< ETH MAC_ADDRESS3_LOW: ADDRLO Position   */
#define ETH_MAC_ADDRESS3_LOW_ADDRLO_Msk       (0xffffffffUL << ETH_MAC_ADDRESS3_LOW_ADDRLO_Pos)       /*!< ETH MAC_ADDRESS3_LOW: ADDRLO Mask       */

/* -------------------------------  ETH_MMC_CONTROL  ------------------------------ */
#define ETH_MMC_CONTROL_CNTRST_Pos            0                                                       /*!< ETH MMC_CONTROL: CNTRST Position        */
#define ETH_MMC_CONTROL_CNTRST_Msk            (0x01UL << ETH_MMC_CONTROL_CNTRST_Pos)                  /*!< ETH MMC_CONTROL: CNTRST Mask            */
#define ETH_MMC_CONTROL_CNTSTOPRO_Pos         1                                                       /*!< ETH MMC_CONTROL: CNTSTOPRO Position     */
#define ETH_MMC_CONTROL_CNTSTOPRO_Msk         (0x01UL << ETH_MMC_CONTROL_CNTSTOPRO_Pos)               /*!< ETH MMC_CONTROL: CNTSTOPRO Mask         */
#define ETH_MMC_CONTROL_RSTONRD_Pos           2                                                       /*!< ETH MMC_CONTROL: RSTONRD Position       */
#define ETH_MMC_CONTROL_RSTONRD_Msk           (0x01UL << ETH_MMC_CONTROL_RSTONRD_Pos)                 /*!< ETH MMC_CONTROL: RSTONRD Mask           */
#define ETH_MMC_CONTROL_CNTFREEZ_Pos          3                                                       /*!< ETH MMC_CONTROL: CNTFREEZ Position      */
#define ETH_MMC_CONTROL_CNTFREEZ_Msk          (0x01UL << ETH_MMC_CONTROL_CNTFREEZ_Pos)                /*!< ETH MMC_CONTROL: CNTFREEZ Mask          */
#define ETH_MMC_CONTROL_CNTPRST_Pos           4                                                       /*!< ETH MMC_CONTROL: CNTPRST Position       */
#define ETH_MMC_CONTROL_CNTPRST_Msk           (0x01UL << ETH_MMC_CONTROL_CNTPRST_Pos)                 /*!< ETH MMC_CONTROL: CNTPRST Mask           */
#define ETH_MMC_CONTROL_CNTPRSTLVL_Pos        5                                                       /*!< ETH MMC_CONTROL: CNTPRSTLVL Position    */
#define ETH_MMC_CONTROL_CNTPRSTLVL_Msk        (0x01UL << ETH_MMC_CONTROL_CNTPRSTLVL_Pos)              /*!< ETH MMC_CONTROL: CNTPRSTLVL Mask        */
#define ETH_MMC_CONTROL_Reserved_7_6_Pos      6                                                       /*!< ETH MMC_CONTROL: Reserved_7_6 Position  */
#define ETH_MMC_CONTROL_Reserved_7_6_Msk      (0x03UL << ETH_MMC_CONTROL_Reserved_7_6_Pos)            /*!< ETH MMC_CONTROL: Reserved_7_6 Mask      */
#define ETH_MMC_CONTROL_UCDBC_Pos             8                                                       /*!< ETH MMC_CONTROL: UCDBC Position         */
#define ETH_MMC_CONTROL_UCDBC_Msk             (0x01UL << ETH_MMC_CONTROL_UCDBC_Pos)                   /*!< ETH MMC_CONTROL: UCDBC Mask             */
#define ETH_MMC_CONTROL_Reserved_31_9_Pos     9                                                       /*!< ETH MMC_CONTROL: Reserved_31_9 Position */
#define ETH_MMC_CONTROL_Reserved_31_9_Msk     (0x007fffffUL << ETH_MMC_CONTROL_Reserved_31_9_Pos)     /*!< ETH MMC_CONTROL: Reserved_31_9 Mask     */

/* --------------------------  ETH_MMC_RECEIVE_INTERRUPT  ------------------------- */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBFRMIS_Pos 0                                                     /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBFRMIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBFRMIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXGBFRMIS_Pos)   /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBFRMIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBOCTIS_Pos 1                                                     /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBOCTIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBOCTIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXGBOCTIS_Pos)   /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBOCTIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGOCTIS_Pos 2                                                      /*!< ETH MMC_RECEIVE_INTERRUPT: RXGOCTIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGOCTIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXGOCTIS_Pos)     /*!< ETH MMC_RECEIVE_INTERRUPT: RXGOCTIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXBCGFIS_Pos 3                                                      /*!< ETH MMC_RECEIVE_INTERRUPT: RXBCGFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXBCGFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXBCGFIS_Pos)     /*!< ETH MMC_RECEIVE_INTERRUPT: RXBCGFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXMCGFIS_Pos 4                                                      /*!< ETH MMC_RECEIVE_INTERRUPT: RXMCGFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXMCGFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXMCGFIS_Pos)     /*!< ETH MMC_RECEIVE_INTERRUPT: RXMCGFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCRCERFIS_Pos 5                                                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXCRCERFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCRCERFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXCRCERFIS_Pos) /*!< ETH MMC_RECEIVE_INTERRUPT: RXCRCERFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXALGNERFIS_Pos 6                                                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXALGNERFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXALGNERFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXALGNERFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RXALGNERFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRUNTFIS_Pos 7                                                     /*!< ETH MMC_RECEIVE_INTERRUPT: RXRUNTFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRUNTFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXRUNTFIS_Pos)   /*!< ETH MMC_RECEIVE_INTERRUPT: RXRUNTFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXJABERFIS_Pos 8                                                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXJABERFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXJABERFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXJABERFIS_Pos) /*!< ETH MMC_RECEIVE_INTERRUPT: RXJABERFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUSIZEGFIS_Pos 9                                                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXUSIZEGFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUSIZEGFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXUSIZEGFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RXUSIZEGFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXOSIZEGFIS_Pos 10                                                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXOSIZEGFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXOSIZEGFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXOSIZEGFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RXOSIZEGFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RX64OCTGBFIS_Pos 11                                                 /*!< ETH MMC_RECEIVE_INTERRUPT: RX64OCTGBFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RX64OCTGBFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RX64OCTGBFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RX64OCTGBFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RX65T127OCTGBFIS_Pos 12                                             /*!< ETH MMC_RECEIVE_INTERRUPT: RX65T127OCTGBFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RX65T127OCTGBFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RX65T127OCTGBFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RX65T127OCTGBFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RX128T255OCTGBFIS_Pos 13                                            /*!< ETH MMC_RECEIVE_INTERRUPT: RX128T255OCTGBFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RX128T255OCTGBFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RX128T255OCTGBFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RX128T255OCTGBFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RX256T511OCTGBFIS_Pos 14                                            /*!< ETH MMC_RECEIVE_INTERRUPT: RX256T511OCTGBFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RX256T511OCTGBFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RX256T511OCTGBFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RX256T511OCTGBFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RX512T1023OCTGBFIS_Pos 15                                           /*!< ETH MMC_RECEIVE_INTERRUPT: RX512T1023OCTGBFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RX512T1023OCTGBFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RX512T1023OCTGBFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RX512T1023OCTGBFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RX1024TMAXOCTGBFIS_Pos 16                                           /*!< ETH MMC_RECEIVE_INTERRUPT: RX1024TMAXOCTGBFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RX1024TMAXOCTGBFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RX1024TMAXOCTGBFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RX1024TMAXOCTGBFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUCGFIS_Pos 17                                                     /*!< ETH MMC_RECEIVE_INTERRUPT: RXUCGFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUCGFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXUCGFIS_Pos)     /*!< ETH MMC_RECEIVE_INTERRUPT: RXUCGFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXLENERFIS_Pos 18                                                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXLENERFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXLENERFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXLENERFIS_Pos) /*!< ETH MMC_RECEIVE_INTERRUPT: RXLENERFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXORANGEFIS_Pos 19                                                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXORANGEFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXORANGEFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXORANGEFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RXORANGEFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXPAUSFIS_Pos 20                                                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXPAUSFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXPAUSFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXPAUSFIS_Pos)   /*!< ETH MMC_RECEIVE_INTERRUPT: RXPAUSFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXFOVFIS_Pos 21                                                     /*!< ETH MMC_RECEIVE_INTERRUPT: RXFOVFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXFOVFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXFOVFIS_Pos)     /*!< ETH MMC_RECEIVE_INTERRUPT: RXFOVFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXVLANGBFIS_Pos 22                                                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXVLANGBFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXVLANGBFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXVLANGBFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RXVLANGBFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXWDOGFIS_Pos 23                                                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXWDOGFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXWDOGFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXWDOGFIS_Pos)   /*!< ETH MMC_RECEIVE_INTERRUPT: RXWDOGFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRCVERRFIS_Pos 24                                                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXRCVERRFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRCVERRFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXRCVERRFIS_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: RXRCVERRFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCTRLFIS_Pos 25                                                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXCTRLFIS Position */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCTRLFIS_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_RXCTRLFIS_Pos)   /*!< ETH MMC_RECEIVE_INTERRUPT: RXCTRLFIS Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_Reserved_31_26_Pos 26                                               /*!< ETH MMC_RECEIVE_INTERRUPT: Reserved_31_26 Position */
#define ETH_MMC_RECEIVE_INTERRUPT_Reserved_31_26_Msk (0x3fUL << ETH_MMC_RECEIVE_INTERRUPT_Reserved_31_26_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT: Reserved_31_26 Mask */

/* -------------------------  ETH_MMC_TRANSMIT_INTERRUPT  ------------------------- */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBOCTIS_Pos 0                                                    /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBOCTIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBOCTIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXGBOCTIS_Pos) /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBOCTIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBFRMIS_Pos 1                                                    /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBFRMIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBFRMIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXGBFRMIS_Pos) /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBFRMIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGFIS_Pos 2                                                     /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXBCGFIS_Pos)   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGFIS_Pos 3                                                     /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXMCGFIS_Pos)   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX64OCTGBFIS_Pos 4                                                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TX64OCTGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX64OCTGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TX64OCTGBFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TX64OCTGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX65T127OCTGBFIS_Pos 5                                             /*!< ETH MMC_TRANSMIT_INTERRUPT: TX65T127OCTGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX65T127OCTGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TX65T127OCTGBFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TX65T127OCTGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX128T255OCTGBFIS_Pos 6                                            /*!< ETH MMC_TRANSMIT_INTERRUPT: TX128T255OCTGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX128T255OCTGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TX128T255OCTGBFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TX128T255OCTGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX256T511OCTGBFIS_Pos 7                                            /*!< ETH MMC_TRANSMIT_INTERRUPT: TX256T511OCTGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX256T511OCTGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TX256T511OCTGBFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TX256T511OCTGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX512T1023OCTGBFIS_Pos 8                                           /*!< ETH MMC_TRANSMIT_INTERRUPT: TX512T1023OCTGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX512T1023OCTGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TX512T1023OCTGBFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TX512T1023OCTGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX1024TMAXOCTGBFIS_Pos 9                                           /*!< ETH MMC_TRANSMIT_INTERRUPT: TX1024TMAXOCTGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX1024TMAXOCTGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TX1024TMAXOCTGBFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TX1024TMAXOCTGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUCGBFIS_Pos 10                                                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUCGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUCGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXUCGBFIS_Pos) /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUCGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGBFIS_Pos 11                                                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXMCGBFIS_Pos) /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGBFIS_Pos 12                                                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGBFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGBFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXBCGBFIS_Pos) /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGBFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUFLOWERFIS_Pos 13                                                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUFLOWERFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUFLOWERFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXUFLOWERFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXUFLOWERFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXSCOLGFIS_Pos 14                                                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXSCOLGFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXSCOLGFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXSCOLGFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXSCOLGFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCOLGFIS_Pos 15                                                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCOLGFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCOLGFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXMCOLGFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCOLGFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXDEFFIS_Pos 16                                                    /*!< ETH MMC_TRANSMIT_INTERRUPT: TXDEFFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXDEFFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXDEFFIS_Pos)   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXDEFFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXLATCOLFIS_Pos 17                                                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXLATCOLFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXLATCOLFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXLATCOLFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXLATCOLFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXCOLFIS_Pos 18                                                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXCOLFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXCOLFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXEXCOLFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXCOLFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXCARERFIS_Pos 19                                                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXCARERFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXCARERFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXCARERFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXCARERFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGOCTIS_Pos 20                                                    /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGOCTIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGOCTIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXGOCTIS_Pos)   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGOCTIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGFRMIS_Pos 21                                                    /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGFRMIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGFRMIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXGFRMIS_Pos)   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGFRMIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXDEFFIS_Pos 22                                                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXDEFFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXDEFFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXEXDEFFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXDEFFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXPAUSFIS_Pos 23                                                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXPAUSFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXPAUSFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXPAUSFIS_Pos) /*!< ETH MMC_TRANSMIT_INTERRUPT: TXPAUSFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXVLANGFIS_Pos 24                                                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXVLANGFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXVLANGFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXVLANGFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXVLANGFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXOSIZEGFIS_Pos 25                                                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXOSIZEGFIS Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXOSIZEGFIS_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_TXOSIZEGFIS_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: TXOSIZEGFIS Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_Reserved_31_26_Pos 26                                              /*!< ETH MMC_TRANSMIT_INTERRUPT: Reserved_31_26 Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_Reserved_31_26_Msk (0x3fUL << ETH_MMC_TRANSMIT_INTERRUPT_Reserved_31_26_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT: Reserved_31_26 Mask */

/* -----------------------  ETH_MMC_RECEIVE_INTERRUPT_MASK  ----------------------- */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBFRMIM_Pos 0                                                /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBFRMIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBFRMIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBFRMIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBFRMIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBOCTIM_Pos 1                                                /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBOCTIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBOCTIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBOCTIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBOCTIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGOCTIM_Pos 2                                                 /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGOCTIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGOCTIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGOCTIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGOCTIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXBCGFIM_Pos 3                                                 /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXBCGFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXBCGFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXBCGFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXBCGFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXMCGFIM_Pos 4                                                 /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXMCGFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXMCGFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXMCGFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXMCGFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCRCERFIM_Pos 5                                               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCRCERFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCRCERFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCRCERFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCRCERFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXALGNERFIM_Pos 6                                              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXALGNERFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXALGNERFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXALGNERFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXALGNERFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRUNTFIM_Pos 7                                                /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRUNTFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRUNTFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRUNTFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRUNTFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXJABERFIM_Pos 8                                               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXJABERFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXJABERFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXJABERFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXJABERFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUSIZEGFIM_Pos 9                                              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUSIZEGFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUSIZEGFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUSIZEGFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUSIZEGFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXOSIZEGFIM_Pos 10                                             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXOSIZEGFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXOSIZEGFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXOSIZEGFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXOSIZEGFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX64OCTGBFIM_Pos 11                                            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX64OCTGBFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX64OCTGBFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RX64OCTGBFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX64OCTGBFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX65T127OCTGBFIM_Pos 12                                        /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX65T127OCTGBFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX65T127OCTGBFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RX65T127OCTGBFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX65T127OCTGBFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX128T255OCTGBFIM_Pos 13                                       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX128T255OCTGBFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX128T255OCTGBFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RX128T255OCTGBFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX128T255OCTGBFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX256T511OCTGBFIM_Pos 14                                       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX256T511OCTGBFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX256T511OCTGBFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RX256T511OCTGBFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX256T511OCTGBFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX512T1023OCTGBFIM_Pos 15                                      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX512T1023OCTGBFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX512T1023OCTGBFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RX512T1023OCTGBFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX512T1023OCTGBFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX1024TMAXOCTGBFIM_Pos 16                                      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX1024TMAXOCTGBFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX1024TMAXOCTGBFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RX1024TMAXOCTGBFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX1024TMAXOCTGBFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUCGFIM_Pos 17                                                /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUCGFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUCGFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUCGFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUCGFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXLENERFIM_Pos 18                                              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXLENERFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXLENERFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXLENERFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXLENERFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXORANGEFIM_Pos 19                                             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXORANGEFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXORANGEFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXORANGEFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXORANGEFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXPAUSFIM_Pos 20                                               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXPAUSFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXPAUSFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXPAUSFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXPAUSFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXFOVFIM_Pos 21                                                /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXFOVFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXFOVFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXFOVFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXFOVFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXVLANGBFIM_Pos 22                                             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXVLANGBFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXVLANGBFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXVLANGBFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXVLANGBFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXWDOGFIM_Pos 23                                               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXWDOGFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXWDOGFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXWDOGFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXWDOGFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRCVERRFIM_Pos 24                                             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRCVERRFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRCVERRFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRCVERRFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRCVERRFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCTRLFIM_Pos 25                                               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCTRLFIM Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCTRLFIM_Msk (0x01UL << ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCTRLFIM_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCTRLFIM Mask */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_Reserved_31_26_Pos 26                                          /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: Reserved_31_26 Position */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_Reserved_31_26_Msk (0x3fUL << ETH_MMC_RECEIVE_INTERRUPT_MASK_Reserved_31_26_Pos)/*!< ETH MMC_RECEIVE_INTERRUPT_MASK: Reserved_31_26 Mask */

/* -----------------------  ETH_MMC_TRANSMIT_INTERRUPT_MASK  ---------------------- */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBOCTIM_Pos 0                                               /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBOCTIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBOCTIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBOCTIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBOCTIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBFRMIM_Pos 1                                               /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBFRMIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBFRMIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBFRMIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBFRMIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGFIM_Pos 2                                                /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGFIM_Pos 3                                                /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX64OCTGBFIM_Pos 4                                            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX64OCTGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX64OCTGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX64OCTGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX64OCTGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX65T127OCTGBFIM_Pos 5                                        /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX65T127OCTGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX65T127OCTGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX65T127OCTGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX65T127OCTGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX128T255OCTGBFIM_Pos 6                                       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX128T255OCTGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX128T255OCTGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX128T255OCTGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX128T255OCTGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX256T511OCTGBFIM_Pos 7                                       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX256T511OCTGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX256T511OCTGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX256T511OCTGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX256T511OCTGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX512T1023OCTGBFIM_Pos 8                                      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX512T1023OCTGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX512T1023OCTGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX512T1023OCTGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX512T1023OCTGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX1024TMAXOCTGBFIM_Pos 9                                      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX1024TMAXOCTGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX1024TMAXOCTGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX1024TMAXOCTGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX1024TMAXOCTGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUCGBFIM_Pos 10                                              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUCGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUCGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUCGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUCGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGBFIM_Pos 11                                              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGBFIM_Pos 12                                              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGBFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGBFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGBFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGBFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUFLOWERFIM_Pos 13                                           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUFLOWERFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUFLOWERFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUFLOWERFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUFLOWERFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXSCOLGFIM_Pos 14                                             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXSCOLGFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXSCOLGFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXSCOLGFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXSCOLGFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCOLGFIM_Pos 15                                             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCOLGFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCOLGFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCOLGFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCOLGFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXDEFFIM_Pos 16                                               /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXDEFFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXDEFFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXDEFFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXDEFFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXLATCOLFIM_Pos 17                                            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXLATCOLFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXLATCOLFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXLATCOLFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXLATCOLFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXCOLFIM_Pos 18                                             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXCOLFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXCOLFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXCOLFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXCOLFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXCARERFIM_Pos 19                                             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXCARERFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXCARERFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXCARERFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXCARERFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGOCTIM_Pos 20                                               /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGOCTIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGOCTIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGOCTIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGOCTIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGFRMIM_Pos 21                                               /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGFRMIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGFRMIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGFRMIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGFRMIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXDEFFIM_Pos 22                                             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXDEFFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXDEFFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXDEFFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXDEFFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXPAUSFIM_Pos 23                                              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXPAUSFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXPAUSFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXPAUSFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXPAUSFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXVLANGFIM_Pos 24                                             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXVLANGFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXVLANGFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXVLANGFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXVLANGFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXOSIZEGFIM_Pos 25                                            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXOSIZEGFIM Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXOSIZEGFIM_Msk (0x01UL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXOSIZEGFIM_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXOSIZEGFIM Mask */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_Reserved_31_26_Pos 26                                         /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: Reserved_31_26 Position */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_Reserved_31_26_Msk (0x3fUL << ETH_MMC_TRANSMIT_INTERRUPT_MASK_Reserved_31_26_Pos)/*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: Reserved_31_26 Mask */

/* -------------------------  ETH_TX_OCTET_COUNT_GOOD_BAD  ------------------------ */
#define ETH_TX_OCTET_COUNT_GOOD_BAD_TXOCTGB_Pos 0                                                     /*!< ETH TX_OCTET_COUNT_GOOD_BAD: TXOCTGB Position */
#define ETH_TX_OCTET_COUNT_GOOD_BAD_TXOCTGB_Msk (0xffffffffUL << ETH_TX_OCTET_COUNT_GOOD_BAD_TXOCTGB_Pos)/*!< ETH TX_OCTET_COUNT_GOOD_BAD: TXOCTGB Mask */

/* -------------------------  ETH_TX_FRAME_COUNT_GOOD_BAD  ------------------------ */
#define ETH_TX_FRAME_COUNT_GOOD_BAD_TXFRMGB_Pos 0                                                     /*!< ETH TX_FRAME_COUNT_GOOD_BAD: TXFRMGB Position */
#define ETH_TX_FRAME_COUNT_GOOD_BAD_TXFRMGB_Msk (0xffffffffUL << ETH_TX_FRAME_COUNT_GOOD_BAD_TXFRMGB_Pos)/*!< ETH TX_FRAME_COUNT_GOOD_BAD: TXFRMGB Mask */

/* ------------------------  ETH_TX_BROADCAST_FRAMES_GOOD  ------------------------ */
#define ETH_TX_BROADCAST_FRAMES_GOOD_TXBCASTG_Pos 0                                                   /*!< ETH TX_BROADCAST_FRAMES_GOOD: TXBCASTG Position */
#define ETH_TX_BROADCAST_FRAMES_GOOD_TXBCASTG_Msk (0xffffffffUL << ETH_TX_BROADCAST_FRAMES_GOOD_TXBCASTG_Pos)/*!< ETH TX_BROADCAST_FRAMES_GOOD: TXBCASTG Mask */

/* ------------------------  ETH_TX_MULTICAST_FRAMES_GOOD  ------------------------ */
#define ETH_TX_MULTICAST_FRAMES_GOOD_TXMCASTG_Pos 0                                                   /*!< ETH TX_MULTICAST_FRAMES_GOOD: TXMCASTG Position */
#define ETH_TX_MULTICAST_FRAMES_GOOD_TXMCASTG_Msk (0xffffffffUL << ETH_TX_MULTICAST_FRAMES_GOOD_TXMCASTG_Pos)/*!< ETH TX_MULTICAST_FRAMES_GOOD: TXMCASTG Mask */

/* -----------------------  ETH_TX_64OCTETS_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_64OCTETS_FRAMES_GOOD_BAD_TX64OCTGB_Pos 0                                               /*!< ETH TX_64OCTETS_FRAMES_GOOD_BAD: TX64OCTGB Position */
#define ETH_TX_64OCTETS_FRAMES_GOOD_BAD_TX64OCTGB_Msk (0xffffffffUL << ETH_TX_64OCTETS_FRAMES_GOOD_BAD_TX64OCTGB_Pos)/*!< ETH TX_64OCTETS_FRAMES_GOOD_BAD: TX64OCTGB Mask */

/* --------------------  ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD  -------------------- */
#define ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD_TX65_127OCTGB_Pos 0                                      /*!< ETH TX_65TO127OCTETS_FRAMES_GOOD_BAD: TX65_127OCTGB Position */
#define ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD_TX65_127OCTGB_Msk (0xffffffffUL << ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD_TX65_127OCTGB_Pos)/*!< ETH TX_65TO127OCTETS_FRAMES_GOOD_BAD: TX65_127OCTGB Mask */

/* --------------------  ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD_TX128_255OCTGB_Pos 0                                    /*!< ETH TX_128TO255OCTETS_FRAMES_GOOD_BAD: TX128_255OCTGB Position */
#define ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD_TX128_255OCTGB_Msk (0xffffffffUL << ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD_TX128_255OCTGB_Pos)/*!< ETH TX_128TO255OCTETS_FRAMES_GOOD_BAD: TX128_255OCTGB Mask */

/* --------------------  ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD_TX256_511OCTGB_Pos 0                                    /*!< ETH TX_256TO511OCTETS_FRAMES_GOOD_BAD: TX256_511OCTGB Position */
#define ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD_TX256_511OCTGB_Msk (0xffffffffUL << ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD_TX256_511OCTGB_Pos)/*!< ETH TX_256TO511OCTETS_FRAMES_GOOD_BAD: TX256_511OCTGB Mask */

/* -------------------  ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD_TX512_1023OCTGB_Pos 0                                  /*!< ETH TX_512TO1023OCTETS_FRAMES_GOOD_BAD: TX512_1023OCTGB Position */
#define ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD_TX512_1023OCTGB_Msk (0xffffffffUL << ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD_TX512_1023OCTGB_Pos)/*!< ETH TX_512TO1023OCTETS_FRAMES_GOOD_BAD: TX512_1023OCTGB Mask */

/* -------------------  ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_TX1024_MAXOCTGB_Pos 0                                  /*!< ETH TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: TX1024_MAXOCTGB Position */
#define ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_TX1024_MAXOCTGB_Msk (0xffffffffUL << ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_TX1024_MAXOCTGB_Pos)/*!< ETH TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: TX1024_MAXOCTGB Mask */

/* -----------------------  ETH_TX_UNICAST_FRAMES_GOOD_BAD  ----------------------- */
#define ETH_TX_UNICAST_FRAMES_GOOD_BAD_TXUCASTGB_Pos 0                                                /*!< ETH TX_UNICAST_FRAMES_GOOD_BAD: TXUCASTGB Position */
#define ETH_TX_UNICAST_FRAMES_GOOD_BAD_TXUCASTGB_Msk (0xffffffffUL << ETH_TX_UNICAST_FRAMES_GOOD_BAD_TXUCASTGB_Pos)/*!< ETH TX_UNICAST_FRAMES_GOOD_BAD: TXUCASTGB Mask */

/* ----------------------  ETH_TX_MULTICAST_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_MULTICAST_FRAMES_GOOD_BAD_TXMCASTGB_Pos 0                                              /*!< ETH TX_MULTICAST_FRAMES_GOOD_BAD: TXMCASTGB Position */
#define ETH_TX_MULTICAST_FRAMES_GOOD_BAD_TXMCASTGB_Msk (0xffffffffUL << ETH_TX_MULTICAST_FRAMES_GOOD_BAD_TXMCASTGB_Pos)/*!< ETH TX_MULTICAST_FRAMES_GOOD_BAD: TXMCASTGB Mask */

/* ----------------------  ETH_TX_BROADCAST_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_BROADCAST_FRAMES_GOOD_BAD_TXBCASTGB_Pos 0                                              /*!< ETH TX_BROADCAST_FRAMES_GOOD_BAD: TXBCASTGB Position */
#define ETH_TX_BROADCAST_FRAMES_GOOD_BAD_TXBCASTGB_Msk (0xffffffffUL << ETH_TX_BROADCAST_FRAMES_GOOD_BAD_TXBCASTGB_Pos)/*!< ETH TX_BROADCAST_FRAMES_GOOD_BAD: TXBCASTGB Mask */

/* ------------------------  ETH_TX_UNDERFLOW_ERROR_FRAMES  ----------------------- */
#define ETH_TX_UNDERFLOW_ERROR_FRAMES_TXUNDRFLW_Pos 0                                                 /*!< ETH TX_UNDERFLOW_ERROR_FRAMES: TXUNDRFLW Position */
#define ETH_TX_UNDERFLOW_ERROR_FRAMES_TXUNDRFLW_Msk (0xffffffffUL << ETH_TX_UNDERFLOW_ERROR_FRAMES_TXUNDRFLW_Pos)/*!< ETH TX_UNDERFLOW_ERROR_FRAMES: TXUNDRFLW Mask */

/* ---------------------  ETH_TX_SINGLE_COLLISION_GOOD_FRAMES  -------------------- */
#define ETH_TX_SINGLE_COLLISION_GOOD_FRAMES_TXSNGLCOLG_Pos 0                                          /*!< ETH TX_SINGLE_COLLISION_GOOD_FRAMES: TXSNGLCOLG Position */
#define ETH_TX_SINGLE_COLLISION_GOOD_FRAMES_TXSNGLCOLG_Msk (0xffffffffUL << ETH_TX_SINGLE_COLLISION_GOOD_FRAMES_TXSNGLCOLG_Pos)/*!< ETH TX_SINGLE_COLLISION_GOOD_FRAMES: TXSNGLCOLG Mask */

/* --------------------  ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES  ------------------- */
#define ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES_TXMULTCOLG_Pos 0                                        /*!< ETH TX_MULTIPLE_COLLISION_GOOD_FRAMES: TXMULTCOLG Position */
#define ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES_TXMULTCOLG_Msk (0xffffffffUL << ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES_TXMULTCOLG_Pos)/*!< ETH TX_MULTIPLE_COLLISION_GOOD_FRAMES: TXMULTCOLG Mask */

/* ---------------------------  ETH_TX_DEFERRED_FRAMES  --------------------------- */
#define ETH_TX_DEFERRED_FRAMES_TXDEFRD_Pos    0                                                       /*!< ETH TX_DEFERRED_FRAMES: TXDEFRD Position */
#define ETH_TX_DEFERRED_FRAMES_TXDEFRD_Msk    (0xffffffffUL << ETH_TX_DEFERRED_FRAMES_TXDEFRD_Pos)    /*!< ETH TX_DEFERRED_FRAMES: TXDEFRD Mask    */

/* ------------------------  ETH_TX_LATE_COLLISION_FRAMES  ------------------------ */
#define ETH_TX_LATE_COLLISION_FRAMES_TXLATECOL_Pos 0                                                  /*!< ETH TX_LATE_COLLISION_FRAMES: TXLATECOL Position */
#define ETH_TX_LATE_COLLISION_FRAMES_TXLATECOL_Msk (0xffffffffUL << ETH_TX_LATE_COLLISION_FRAMES_TXLATECOL_Pos)/*!< ETH TX_LATE_COLLISION_FRAMES: TXLATECOL Mask */

/* ----------------------  ETH_TX_EXCESSIVE_COLLISION_FRAMES  --------------------- */
#define ETH_TX_EXCESSIVE_COLLISION_FRAMES_TXEXSCOL_Pos 0                                              /*!< ETH TX_EXCESSIVE_COLLISION_FRAMES: TXEXSCOL Position */
#define ETH_TX_EXCESSIVE_COLLISION_FRAMES_TXEXSCOL_Msk (0xffffffffUL << ETH_TX_EXCESSIVE_COLLISION_FRAMES_TXEXSCOL_Pos)/*!< ETH TX_EXCESSIVE_COLLISION_FRAMES: TXEXSCOL Mask */

/* -------------------------  ETH_TX_CARRIER_ERROR_FRAMES  ------------------------ */
#define ETH_TX_CARRIER_ERROR_FRAMES_TXCARR_Pos 0                                                      /*!< ETH TX_CARRIER_ERROR_FRAMES: TXCARR Position */
#define ETH_TX_CARRIER_ERROR_FRAMES_TXCARR_Msk (0xffffffffUL << ETH_TX_CARRIER_ERROR_FRAMES_TXCARR_Pos)/*!< ETH TX_CARRIER_ERROR_FRAMES: TXCARR Mask */

/* ---------------------------  ETH_TX_OCTET_COUNT_GOOD  -------------------------- */
#define ETH_TX_OCTET_COUNT_GOOD_TXOCTG_Pos    0                                                       /*!< ETH TX_OCTET_COUNT_GOOD: TXOCTG Position */
#define ETH_TX_OCTET_COUNT_GOOD_TXOCTG_Msk    (0xffffffffUL << ETH_TX_OCTET_COUNT_GOOD_TXOCTG_Pos)    /*!< ETH TX_OCTET_COUNT_GOOD: TXOCTG Mask    */

/* ---------------------------  ETH_TX_FRAME_COUNT_GOOD  -------------------------- */
#define ETH_TX_FRAME_COUNT_GOOD_TXFRMG_Pos    0                                                       /*!< ETH TX_FRAME_COUNT_GOOD: TXFRMG Position */
#define ETH_TX_FRAME_COUNT_GOOD_TXFRMG_Msk    (0xffffffffUL << ETH_TX_FRAME_COUNT_GOOD_TXFRMG_Pos)    /*!< ETH TX_FRAME_COUNT_GOOD: TXFRMG Mask    */

/* -----------------------  ETH_TX_EXCESSIVE_DEFERRAL_ERROR  ---------------------- */
#define ETH_TX_EXCESSIVE_DEFERRAL_ERROR_TXEXSDEF_Pos 0                                                /*!< ETH TX_EXCESSIVE_DEFERRAL_ERROR: TXEXSDEF Position */
#define ETH_TX_EXCESSIVE_DEFERRAL_ERROR_TXEXSDEF_Msk (0xffffffffUL << ETH_TX_EXCESSIVE_DEFERRAL_ERROR_TXEXSDEF_Pos)/*!< ETH TX_EXCESSIVE_DEFERRAL_ERROR: TXEXSDEF Mask */

/* -----------------------------  ETH_TX_PAUSE_FRAMES  ---------------------------- */
#define ETH_TX_PAUSE_FRAMES_TXPAUSE_Pos       0                                                       /*!< ETH TX_PAUSE_FRAMES: TXPAUSE Position   */
#define ETH_TX_PAUSE_FRAMES_TXPAUSE_Msk       (0xffffffffUL << ETH_TX_PAUSE_FRAMES_TXPAUSE_Pos)       /*!< ETH TX_PAUSE_FRAMES: TXPAUSE Mask       */

/* ---------------------------  ETH_TX_VLAN_FRAMES_GOOD  -------------------------- */
#define ETH_TX_VLAN_FRAMES_GOOD_TXVLANG_Pos   0                                                       /*!< ETH TX_VLAN_FRAMES_GOOD: TXVLANG Position */
#define ETH_TX_VLAN_FRAMES_GOOD_TXVLANG_Msk   (0xffffffffUL << ETH_TX_VLAN_FRAMES_GOOD_TXVLANG_Pos)   /*!< ETH TX_VLAN_FRAMES_GOOD: TXVLANG Mask   */

/* --------------------------  ETH_TX_OSIZE_FRAMES_GOOD  -------------------------- */
#define ETH_TX_OSIZE_FRAMES_GOOD_TXOSIZG_Pos  0                                                       /*!< ETH TX_OSIZE_FRAMES_GOOD: TXOSIZG Position */
#define ETH_TX_OSIZE_FRAMES_GOOD_TXOSIZG_Msk  (0xffffffffUL << ETH_TX_OSIZE_FRAMES_GOOD_TXOSIZG_Pos)  /*!< ETH TX_OSIZE_FRAMES_GOOD: TXOSIZG Mask  */

/* ------------------------  ETH_RX_FRAMES_COUNT_GOOD_BAD  ------------------------ */
#define ETH_RX_FRAMES_COUNT_GOOD_BAD_RXFRMGB_Pos 0                                                    /*!< ETH RX_FRAMES_COUNT_GOOD_BAD: RXFRMGB Position */
#define ETH_RX_FRAMES_COUNT_GOOD_BAD_RXFRMGB_Msk (0xffffffffUL << ETH_RX_FRAMES_COUNT_GOOD_BAD_RXFRMGB_Pos)/*!< ETH RX_FRAMES_COUNT_GOOD_BAD: RXFRMGB Mask */

/* -------------------------  ETH_RX_OCTET_COUNT_GOOD_BAD  ------------------------ */
#define ETH_RX_OCTET_COUNT_GOOD_BAD_RXOCTGB_Pos 0                                                     /*!< ETH RX_OCTET_COUNT_GOOD_BAD: RXOCTGB Position */
#define ETH_RX_OCTET_COUNT_GOOD_BAD_RXOCTGB_Msk (0xffffffffUL << ETH_RX_OCTET_COUNT_GOOD_BAD_RXOCTGB_Pos)/*!< ETH RX_OCTET_COUNT_GOOD_BAD: RXOCTGB Mask */

/* ---------------------------  ETH_RX_OCTET_COUNT_GOOD  -------------------------- */
#define ETH_RX_OCTET_COUNT_GOOD_RXOCTG_Pos    0                                                       /*!< ETH RX_OCTET_COUNT_GOOD: RXOCTG Position */
#define ETH_RX_OCTET_COUNT_GOOD_RXOCTG_Msk    (0xffffffffUL << ETH_RX_OCTET_COUNT_GOOD_RXOCTG_Pos)    /*!< ETH RX_OCTET_COUNT_GOOD: RXOCTG Mask    */

/* ------------------------  ETH_RX_BROADCAST_FRAMES_GOOD  ------------------------ */
#define ETH_RX_BROADCAST_FRAMES_GOOD_RXBCASTG_Pos 0                                                   /*!< ETH RX_BROADCAST_FRAMES_GOOD: RXBCASTG Position */
#define ETH_RX_BROADCAST_FRAMES_GOOD_RXBCASTG_Msk (0xffffffffUL << ETH_RX_BROADCAST_FRAMES_GOOD_RXBCASTG_Pos)/*!< ETH RX_BROADCAST_FRAMES_GOOD: RXBCASTG Mask */

/* ------------------------  ETH_RX_MULTICAST_FRAMES_GOOD  ------------------------ */
#define ETH_RX_MULTICAST_FRAMES_GOOD_RXMCASTG_Pos 0                                                   /*!< ETH RX_MULTICAST_FRAMES_GOOD: RXMCASTG Position */
#define ETH_RX_MULTICAST_FRAMES_GOOD_RXMCASTG_Msk (0xffffffffUL << ETH_RX_MULTICAST_FRAMES_GOOD_RXMCASTG_Pos)/*!< ETH RX_MULTICAST_FRAMES_GOOD: RXMCASTG Mask */

/* ---------------------------  ETH_RX_CRC_ERROR_FRAMES  -------------------------- */
#define ETH_RX_CRC_ERROR_FRAMES_RXCRCERR_Pos  0                                                       /*!< ETH RX_CRC_ERROR_FRAMES: RXCRCERR Position */
#define ETH_RX_CRC_ERROR_FRAMES_RXCRCERR_Msk  (0xffffffffUL << ETH_RX_CRC_ERROR_FRAMES_RXCRCERR_Pos)  /*!< ETH RX_CRC_ERROR_FRAMES: RXCRCERR Mask  */

/* ------------------------  ETH_RX_ALIGNMENT_ERROR_FRAMES  ----------------------- */
#define ETH_RX_ALIGNMENT_ERROR_FRAMES_RXALGNERR_Pos 0                                                 /*!< ETH RX_ALIGNMENT_ERROR_FRAMES: RXALGNERR Position */
#define ETH_RX_ALIGNMENT_ERROR_FRAMES_RXALGNERR_Msk (0xffffffffUL << ETH_RX_ALIGNMENT_ERROR_FRAMES_RXALGNERR_Pos)/*!< ETH RX_ALIGNMENT_ERROR_FRAMES: RXALGNERR Mask */

/* --------------------------  ETH_RX_RUNT_ERROR_FRAMES  -------------------------- */
#define ETH_RX_RUNT_ERROR_FRAMES_RXRUNTERR_Pos 0                                                      /*!< ETH RX_RUNT_ERROR_FRAMES: RXRUNTERR Position */
#define ETH_RX_RUNT_ERROR_FRAMES_RXRUNTERR_Msk (0xffffffffUL << ETH_RX_RUNT_ERROR_FRAMES_RXRUNTERR_Pos)/*!< ETH RX_RUNT_ERROR_FRAMES: RXRUNTERR Mask */

/* -------------------------  ETH_RX_JABBER_ERROR_FRAMES  ------------------------- */
#define ETH_RX_JABBER_ERROR_FRAMES_RXJABERR_Pos 0                                                     /*!< ETH RX_JABBER_ERROR_FRAMES: RXJABERR Position */
#define ETH_RX_JABBER_ERROR_FRAMES_RXJABERR_Msk (0xffffffffUL << ETH_RX_JABBER_ERROR_FRAMES_RXJABERR_Pos)/*!< ETH RX_JABBER_ERROR_FRAMES: RXJABERR Mask */

/* ------------------------  ETH_RX_UNDERSIZE_FRAMES_GOOD  ------------------------ */
#define ETH_RX_UNDERSIZE_FRAMES_GOOD_RXUNDERSZG_Pos 0                                                 /*!< ETH RX_UNDERSIZE_FRAMES_GOOD: RXUNDERSZG Position */
#define ETH_RX_UNDERSIZE_FRAMES_GOOD_RXUNDERSZG_Msk (0xffffffffUL << ETH_RX_UNDERSIZE_FRAMES_GOOD_RXUNDERSZG_Pos)/*!< ETH RX_UNDERSIZE_FRAMES_GOOD: RXUNDERSZG Mask */

/* -------------------------  ETH_RX_OVERSIZE_FRAMES_GOOD  ------------------------ */
#define ETH_RX_OVERSIZE_FRAMES_GOOD_RXOVERSZG_Pos 0                                                   /*!< ETH RX_OVERSIZE_FRAMES_GOOD: RXOVERSZG Position */
#define ETH_RX_OVERSIZE_FRAMES_GOOD_RXOVERSZG_Msk (0xffffffffUL << ETH_RX_OVERSIZE_FRAMES_GOOD_RXOVERSZG_Pos)/*!< ETH RX_OVERSIZE_FRAMES_GOOD: RXOVERSZG Mask */

/* -----------------------  ETH_RX_64OCTETS_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_RX_64OCTETS_FRAMES_GOOD_BAD_RX64OCTGB_Pos 0                                               /*!< ETH RX_64OCTETS_FRAMES_GOOD_BAD: RX64OCTGB Position */
#define ETH_RX_64OCTETS_FRAMES_GOOD_BAD_RX64OCTGB_Msk (0xffffffffUL << ETH_RX_64OCTETS_FRAMES_GOOD_BAD_RX64OCTGB_Pos)/*!< ETH RX_64OCTETS_FRAMES_GOOD_BAD: RX64OCTGB Mask */

/* --------------------  ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD  -------------------- */
#define ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD_RX65_127OCTGB_Pos 0                                      /*!< ETH RX_65TO127OCTETS_FRAMES_GOOD_BAD: RX65_127OCTGB Position */
#define ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD_RX65_127OCTGB_Msk (0xffffffffUL << ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD_RX65_127OCTGB_Pos)/*!< ETH RX_65TO127OCTETS_FRAMES_GOOD_BAD: RX65_127OCTGB Mask */

/* --------------------  ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD_RX128_255OCTGB_Pos 0                                    /*!< ETH RX_128TO255OCTETS_FRAMES_GOOD_BAD: RX128_255OCTGB Position */
#define ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD_RX128_255OCTGB_Msk (0xffffffffUL << ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD_RX128_255OCTGB_Pos)/*!< ETH RX_128TO255OCTETS_FRAMES_GOOD_BAD: RX128_255OCTGB Mask */

/* --------------------  ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD_RX256_511OCTGB_Pos 0                                    /*!< ETH RX_256TO511OCTETS_FRAMES_GOOD_BAD: RX256_511OCTGB Position */
#define ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD_RX256_511OCTGB_Msk (0xffffffffUL << ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD_RX256_511OCTGB_Pos)/*!< ETH RX_256TO511OCTETS_FRAMES_GOOD_BAD: RX256_511OCTGB Mask */

/* -------------------  ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD_RX512_1023OCTGB_Pos 0                                  /*!< ETH RX_512TO1023OCTETS_FRAMES_GOOD_BAD: RX512_1023OCTGB Position */
#define ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD_RX512_1023OCTGB_Msk (0xffffffffUL << ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD_RX512_1023OCTGB_Pos)/*!< ETH RX_512TO1023OCTETS_FRAMES_GOOD_BAD: RX512_1023OCTGB Mask */

/* -------------------  ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_RX1024_MAXOCTGB_Pos 0                                  /*!< ETH RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: RX1024_MAXOCTGB Position */
#define ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_RX1024_MAXOCTGB_Msk (0xffffffffUL << ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_RX1024_MAXOCTGB_Pos)/*!< ETH RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: RX1024_MAXOCTGB Mask */

/* -------------------------  ETH_RX_UNICAST_FRAMES_GOOD  ------------------------- */
#define ETH_RX_UNICAST_FRAMES_GOOD_RXUCASTG_Pos 0                                                     /*!< ETH RX_UNICAST_FRAMES_GOOD: RXUCASTG Position */
#define ETH_RX_UNICAST_FRAMES_GOOD_RXUCASTG_Msk (0xffffffffUL << ETH_RX_UNICAST_FRAMES_GOOD_RXUCASTG_Pos)/*!< ETH RX_UNICAST_FRAMES_GOOD: RXUCASTG Mask */

/* -------------------------  ETH_RX_LENGTH_ERROR_FRAMES  ------------------------- */
#define ETH_RX_LENGTH_ERROR_FRAMES_RXLENERR_Pos 0                                                     /*!< ETH RX_LENGTH_ERROR_FRAMES: RXLENERR Position */
#define ETH_RX_LENGTH_ERROR_FRAMES_RXLENERR_Msk (0xffffffffUL << ETH_RX_LENGTH_ERROR_FRAMES_RXLENERR_Pos)/*!< ETH RX_LENGTH_ERROR_FRAMES: RXLENERR Mask */

/* -----------------------  ETH_RX_OUT_OF_RANGE_TYPE_FRAMES  ---------------------- */
#define ETH_RX_OUT_OF_RANGE_TYPE_FRAMES_RXOUTOFRNG_Pos 0                                              /*!< ETH RX_OUT_OF_RANGE_TYPE_FRAMES: RXOUTOFRNG Position */
#define ETH_RX_OUT_OF_RANGE_TYPE_FRAMES_RXOUTOFRNG_Msk (0xffffffffUL << ETH_RX_OUT_OF_RANGE_TYPE_FRAMES_RXOUTOFRNG_Pos)/*!< ETH RX_OUT_OF_RANGE_TYPE_FRAMES: RXOUTOFRNG Mask */

/* -----------------------------  ETH_RX_PAUSE_FRAMES  ---------------------------- */
#define ETH_RX_PAUSE_FRAMES_RXPAUSEFRM_Pos    0                                                       /*!< ETH RX_PAUSE_FRAMES: RXPAUSEFRM Position */
#define ETH_RX_PAUSE_FRAMES_RXPAUSEFRM_Msk    (0xffffffffUL << ETH_RX_PAUSE_FRAMES_RXPAUSEFRM_Pos)    /*!< ETH RX_PAUSE_FRAMES: RXPAUSEFRM Mask    */

/* -------------------------  ETH_RX_FIFO_OVERFLOW_FRAMES  ------------------------ */
#define ETH_RX_FIFO_OVERFLOW_FRAMES_RXFIFOOVFL_Pos 0                                                  /*!< ETH RX_FIFO_OVERFLOW_FRAMES: RXFIFOOVFL Position */
#define ETH_RX_FIFO_OVERFLOW_FRAMES_RXFIFOOVFL_Msk (0xffffffffUL << ETH_RX_FIFO_OVERFLOW_FRAMES_RXFIFOOVFL_Pos)/*!< ETH RX_FIFO_OVERFLOW_FRAMES: RXFIFOOVFL Mask */

/* -------------------------  ETH_RX_VLAN_FRAMES_GOOD_BAD  ------------------------ */
#define ETH_RX_VLAN_FRAMES_GOOD_BAD_RXVLANFRGB_Pos 0                                                  /*!< ETH RX_VLAN_FRAMES_GOOD_BAD: RXVLANFRGB Position */
#define ETH_RX_VLAN_FRAMES_GOOD_BAD_RXVLANFRGB_Msk (0xffffffffUL << ETH_RX_VLAN_FRAMES_GOOD_BAD_RXVLANFRGB_Pos)/*!< ETH RX_VLAN_FRAMES_GOOD_BAD: RXVLANFRGB Mask */

/* ------------------------  ETH_RX_WATCHDOG_ERROR_FRAMES  ------------------------ */
#define ETH_RX_WATCHDOG_ERROR_FRAMES_RXWDGERR_Pos 0                                                   /*!< ETH RX_WATCHDOG_ERROR_FRAMES: RXWDGERR Position */
#define ETH_RX_WATCHDOG_ERROR_FRAMES_RXWDGERR_Msk (0xffffffffUL << ETH_RX_WATCHDOG_ERROR_FRAMES_RXWDGERR_Pos)/*!< ETH RX_WATCHDOG_ERROR_FRAMES: RXWDGERR Mask */

/* -------------------------  ETH_RX_RECEIVE_ERROR_FRAMES  ------------------------ */
#define ETH_RX_RECEIVE_ERROR_FRAMES_RXRCVERR_Pos 0                                                    /*!< ETH RX_RECEIVE_ERROR_FRAMES: RXRCVERR Position */
#define ETH_RX_RECEIVE_ERROR_FRAMES_RXRCVERR_Msk (0xffffffffUL << ETH_RX_RECEIVE_ERROR_FRAMES_RXRCVERR_Pos)/*!< ETH RX_RECEIVE_ERROR_FRAMES: RXRCVERR Mask */

/* -------------------------  ETH_RX_CONTROL_FRAMES_GOOD  ------------------------- */
#define ETH_RX_CONTROL_FRAMES_GOOD_RXCTRLG_Pos 0                                                      /*!< ETH RX_CONTROL_FRAMES_GOOD: RXCTRLG Position */
#define ETH_RX_CONTROL_FRAMES_GOOD_RXCTRLG_Msk (0xffffffffUL << ETH_RX_CONTROL_FRAMES_GOOD_RXCTRLG_Pos)/*!< ETH RX_CONTROL_FRAMES_GOOD: RXCTRLG Mask */

/* ---------------------  ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK  --------------------- */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GFIM_Pos 0                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HERFIM_Pos 1                                         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HERFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HERFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HERFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HERFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYFIM_Pos 2                                       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGFIM_Pos 3                                        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLFIM_Pos 4                                       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GFIM_Pos 5                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HERFIM_Pos 6                                         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HERFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HERFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HERFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HERFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYFIM_Pos 7                                       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGFIM_Pos 8                                            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPERFIM_Pos 9                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPERFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPERFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPERFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPERFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGFIM_Pos 10                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPERFIM_Pos 11                                          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPERFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPERFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPERFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPERFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGFIM_Pos 12                                          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPERFIM_Pos 13                                         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPERFIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPERFIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPERFIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPERFIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_Reserved_15_14_Pos 14                                      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: Reserved_15_14 Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_Reserved_15_14_Msk (0x03UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_Reserved_15_14_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: Reserved_15_14 Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GOIM_Pos 16                                          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HEROIM_Pos 17                                        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HEROIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HEROIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HEROIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HEROIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYOIM_Pos 18                                      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGOIM_Pos 19                                       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLOIM_Pos 20                                      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GOIM_Pos 21                                          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HEROIM_Pos 22                                        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HEROIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HEROIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HEROIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HEROIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYOIM_Pos 23                                      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGOIM_Pos 24                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPEROIM_Pos 25                                          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPEROIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPEROIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPEROIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPEROIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGOIM_Pos 26                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPEROIM_Pos 27                                          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPEROIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPEROIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPEROIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPEROIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGOIM_Pos 28                                          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGOIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGOIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGOIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGOIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPEROIM_Pos 29                                         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPEROIM Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPEROIM_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPEROIM_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPEROIM Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_Reserved_31_30_Pos 30                                      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: Reserved_31_30 Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_Reserved_31_30_Msk (0x03UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_Reserved_31_30_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: Reserved_31_30 Mask */

/* ------------------------  ETH_MMC_IPC_RECEIVE_INTERRUPT  ----------------------- */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GFIS_Pos 0                                                /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HERFIS_Pos 1                                              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HERFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HERFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HERFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HERFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYFIS_Pos 2                                            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGFIS_Pos 3                                             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLFIS_Pos 4                                            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GFIS_Pos 5                                                /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HERFIS_Pos 6                                              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HERFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HERFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HERFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HERFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYFIS_Pos 7                                            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGFIS_Pos 8                                                 /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPERFIS_Pos 9                                                /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPERFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPERFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPERFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPERFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGFIS_Pos 10                                                /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPERFIS_Pos 11                                               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPERFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPERFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPERFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPERFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGFIS_Pos 12                                               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPERFIS_Pos 13                                              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPERFIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPERFIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPERFIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPERFIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_Reserved_15_14_Pos 14                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: Reserved_15_14 Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_Reserved_15_14_Msk (0x03UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_Reserved_15_14_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: Reserved_15_14 Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GOIS_Pos 16                                               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HEROIS_Pos 17                                             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HEROIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HEROIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HEROIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HEROIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYOIS_Pos 18                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGOIS_Pos 19                                            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLOIS_Pos 20                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GOIS_Pos 21                                               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HEROIS_Pos 22                                             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HEROIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HEROIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HEROIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HEROIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYOIS_Pos 23                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGOIS_Pos 24                                                /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPEROIS_Pos 25                                               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPEROIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPEROIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPEROIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPEROIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGOIS_Pos 26                                                /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPEROIS_Pos 27                                               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPEROIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPEROIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPEROIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPEROIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGOIS_Pos 28                                               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGOIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGOIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGOIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGOIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPEROIS_Pos 29                                              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPEROIS Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPEROIS_Msk (0x01UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPEROIS_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPEROIS Mask */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_Reserved_31_30_Pos 30                                           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: Reserved_31_30 Position */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_Reserved_31_30_Msk (0x03UL << ETH_MMC_IPC_RECEIVE_INTERRUPT_Reserved_31_30_Pos)/*!< ETH MMC_IPC_RECEIVE_INTERRUPT: Reserved_31_30 Mask */

/* ---------------------------  ETH_RXIPV4_GOOD_FRAMES  --------------------------- */
#define ETH_RXIPV4_GOOD_FRAMES_RXIPV4GDFRM_Pos 0                                                      /*!< ETH RXIPV4_GOOD_FRAMES: RXIPV4GDFRM Position */
#define ETH_RXIPV4_GOOD_FRAMES_RXIPV4GDFRM_Msk (0xffffffffUL << ETH_RXIPV4_GOOD_FRAMES_RXIPV4GDFRM_Pos)/*!< ETH RXIPV4_GOOD_FRAMES: RXIPV4GDFRM Mask */

/* -----------------------  ETH_RXIPV4_HEADER_ERROR_FRAMES  ----------------------- */
#define ETH_RXIPV4_HEADER_ERROR_FRAMES_RXIPV4HDRERRFRM_Pos 0                                          /*!< ETH RXIPV4_HEADER_ERROR_FRAMES: RXIPV4HDRERRFRM Position */
#define ETH_RXIPV4_HEADER_ERROR_FRAMES_RXIPV4HDRERRFRM_Msk (0xffffffffUL << ETH_RXIPV4_HEADER_ERROR_FRAMES_RXIPV4HDRERRFRM_Pos)/*!< ETH RXIPV4_HEADER_ERROR_FRAMES: RXIPV4HDRERRFRM Mask */

/* ------------------------  ETH_RXIPV4_NO_PAYLOAD_FRAMES  ------------------------ */
#define ETH_RXIPV4_NO_PAYLOAD_FRAMES_RXIPV4NOPAYFRM_Pos 0                                             /*!< ETH RXIPV4_NO_PAYLOAD_FRAMES: RXIPV4NOPAYFRM Position */
#define ETH_RXIPV4_NO_PAYLOAD_FRAMES_RXIPV4NOPAYFRM_Msk (0xffffffffUL << ETH_RXIPV4_NO_PAYLOAD_FRAMES_RXIPV4NOPAYFRM_Pos)/*!< ETH RXIPV4_NO_PAYLOAD_FRAMES: RXIPV4NOPAYFRM Mask */

/* ------------------------  ETH_RXIPV4_FRAGMENTED_FRAMES  ------------------------ */
#define ETH_RXIPV4_FRAGMENTED_FRAMES_RXIPV4FRAGFRM_Pos 0                                              /*!< ETH RXIPV4_FRAGMENTED_FRAMES: RXIPV4FRAGFRM Position */
#define ETH_RXIPV4_FRAGMENTED_FRAMES_RXIPV4FRAGFRM_Msk (0xffffffffUL << ETH_RXIPV4_FRAGMENTED_FRAMES_RXIPV4FRAGFRM_Pos)/*!< ETH RXIPV4_FRAGMENTED_FRAMES: RXIPV4FRAGFRM Mask */

/* -------------------  ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES  ------------------ */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES_RXIPV4UDSBLFRM_Pos 0                                  /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES: RXIPV4UDSBLFRM Position */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES_RXIPV4UDSBLFRM_Msk (0xffffffffUL << ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES_RXIPV4UDSBLFRM_Pos)/*!< ETH RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES: RXIPV4UDSBLFRM Mask */

/* ---------------------------  ETH_RXIPV6_GOOD_FRAMES  --------------------------- */
#define ETH_RXIPV6_GOOD_FRAMES_RXIPV6GDFRM_Pos 0                                                      /*!< ETH RXIPV6_GOOD_FRAMES: RXIPV6GDFRM Position */
#define ETH_RXIPV6_GOOD_FRAMES_RXIPV6GDFRM_Msk (0xffffffffUL << ETH_RXIPV6_GOOD_FRAMES_RXIPV6GDFRM_Pos)/*!< ETH RXIPV6_GOOD_FRAMES: RXIPV6GDFRM Mask */

/* -----------------------  ETH_RXIPV6_HEADER_ERROR_FRAMES  ----------------------- */
#define ETH_RXIPV6_HEADER_ERROR_FRAMES_RXIPV6HDRERRFRM_Pos 0                                          /*!< ETH RXIPV6_HEADER_ERROR_FRAMES: RXIPV6HDRERRFRM Position */
#define ETH_RXIPV6_HEADER_ERROR_FRAMES_RXIPV6HDRERRFRM_Msk (0xffffffffUL << ETH_RXIPV6_HEADER_ERROR_FRAMES_RXIPV6HDRERRFRM_Pos)/*!< ETH RXIPV6_HEADER_ERROR_FRAMES: RXIPV6HDRERRFRM Mask */

/* ------------------------  ETH_RXIPV6_NO_PAYLOAD_FRAMES  ------------------------ */
#define ETH_RXIPV6_NO_PAYLOAD_FRAMES_RXIPV6NOPAYFRM_Pos 0                                             /*!< ETH RXIPV6_NO_PAYLOAD_FRAMES: RXIPV6NOPAYFRM Position */
#define ETH_RXIPV6_NO_PAYLOAD_FRAMES_RXIPV6NOPAYFRM_Msk (0xffffffffUL << ETH_RXIPV6_NO_PAYLOAD_FRAMES_RXIPV6NOPAYFRM_Pos)/*!< ETH RXIPV6_NO_PAYLOAD_FRAMES: RXIPV6NOPAYFRM Mask */

/* ----------------------------  ETH_RXUDP_GOOD_FRAMES  --------------------------- */
#define ETH_RXUDP_GOOD_FRAMES_RXUDPGDFRM_Pos  0                                                       /*!< ETH RXUDP_GOOD_FRAMES: RXUDPGDFRM Position */
#define ETH_RXUDP_GOOD_FRAMES_RXUDPGDFRM_Msk  (0xffffffffUL << ETH_RXUDP_GOOD_FRAMES_RXUDPGDFRM_Pos)  /*!< ETH RXUDP_GOOD_FRAMES: RXUDPGDFRM Mask  */

/* ---------------------------  ETH_RXUDP_ERROR_FRAMES  --------------------------- */
#define ETH_RXUDP_ERROR_FRAMES_RXUDPERRFRM_Pos 0                                                      /*!< ETH RXUDP_ERROR_FRAMES: RXUDPERRFRM Position */
#define ETH_RXUDP_ERROR_FRAMES_RXUDPERRFRM_Msk (0xffffffffUL << ETH_RXUDP_ERROR_FRAMES_RXUDPERRFRM_Pos)/*!< ETH RXUDP_ERROR_FRAMES: RXUDPERRFRM Mask */

/* ----------------------------  ETH_RXTCP_GOOD_FRAMES  --------------------------- */
#define ETH_RXTCP_GOOD_FRAMES_RXTCPGDFRM_Pos  0                                                       /*!< ETH RXTCP_GOOD_FRAMES: RXTCPGDFRM Position */
#define ETH_RXTCP_GOOD_FRAMES_RXTCPGDFRM_Msk  (0xffffffffUL << ETH_RXTCP_GOOD_FRAMES_RXTCPGDFRM_Pos)  /*!< ETH RXTCP_GOOD_FRAMES: RXTCPGDFRM Mask  */

/* ---------------------------  ETH_RXTCP_ERROR_FRAMES  --------------------------- */
#define ETH_RXTCP_ERROR_FRAMES_RXTCPERRFRM_Pos 0                                                      /*!< ETH RXTCP_ERROR_FRAMES: RXTCPERRFRM Position */
#define ETH_RXTCP_ERROR_FRAMES_RXTCPERRFRM_Msk (0xffffffffUL << ETH_RXTCP_ERROR_FRAMES_RXTCPERRFRM_Pos)/*!< ETH RXTCP_ERROR_FRAMES: RXTCPERRFRM Mask */

/* ---------------------------  ETH_RXICMP_GOOD_FRAMES  --------------------------- */
#define ETH_RXICMP_GOOD_FRAMES_RXICMPGDFRM_Pos 0                                                      /*!< ETH RXICMP_GOOD_FRAMES: RXICMPGDFRM Position */
#define ETH_RXICMP_GOOD_FRAMES_RXICMPGDFRM_Msk (0xffffffffUL << ETH_RXICMP_GOOD_FRAMES_RXICMPGDFRM_Pos)/*!< ETH RXICMP_GOOD_FRAMES: RXICMPGDFRM Mask */

/* ---------------------------  ETH_RXICMP_ERROR_FRAMES  -------------------------- */
#define ETH_RXICMP_ERROR_FRAMES_RXICMPERRFRM_Pos 0                                                    /*!< ETH RXICMP_ERROR_FRAMES: RXICMPERRFRM Position */
#define ETH_RXICMP_ERROR_FRAMES_RXICMPERRFRM_Msk (0xffffffffUL << ETH_RXICMP_ERROR_FRAMES_RXICMPERRFRM_Pos)/*!< ETH RXICMP_ERROR_FRAMES: RXICMPERRFRM Mask */

/* ---------------------------  ETH_RXIPV4_GOOD_OCTETS  --------------------------- */
#define ETH_RXIPV4_GOOD_OCTETS_RXIPV4GDOCT_Pos 0                                                      /*!< ETH RXIPV4_GOOD_OCTETS: RXIPV4GDOCT Position */
#define ETH_RXIPV4_GOOD_OCTETS_RXIPV4GDOCT_Msk (0xffffffffUL << ETH_RXIPV4_GOOD_OCTETS_RXIPV4GDOCT_Pos)/*!< ETH RXIPV4_GOOD_OCTETS: RXIPV4GDOCT Mask */

/* -----------------------  ETH_RXIPV4_HEADER_ERROR_OCTETS  ----------------------- */
#define ETH_RXIPV4_HEADER_ERROR_OCTETS_RXIPV4HDRERROCT_Pos 0                                          /*!< ETH RXIPV4_HEADER_ERROR_OCTETS: RXIPV4HDRERROCT Position */
#define ETH_RXIPV4_HEADER_ERROR_OCTETS_RXIPV4HDRERROCT_Msk (0xffffffffUL << ETH_RXIPV4_HEADER_ERROR_OCTETS_RXIPV4HDRERROCT_Pos)/*!< ETH RXIPV4_HEADER_ERROR_OCTETS: RXIPV4HDRERROCT Mask */

/* ------------------------  ETH_RXIPV4_NO_PAYLOAD_OCTETS  ------------------------ */
#define ETH_RXIPV4_NO_PAYLOAD_OCTETS_RXIPV4NOPAYOCT_Pos 0                                             /*!< ETH RXIPV4_NO_PAYLOAD_OCTETS: RXIPV4NOPAYOCT Position */
#define ETH_RXIPV4_NO_PAYLOAD_OCTETS_RXIPV4NOPAYOCT_Msk (0xffffffffUL << ETH_RXIPV4_NO_PAYLOAD_OCTETS_RXIPV4NOPAYOCT_Pos)/*!< ETH RXIPV4_NO_PAYLOAD_OCTETS: RXIPV4NOPAYOCT Mask */

/* ------------------------  ETH_RXIPV4_FRAGMENTED_OCTETS  ------------------------ */
#define ETH_RXIPV4_FRAGMENTED_OCTETS_RXIPV4FRAGOCT_Pos 0                                              /*!< ETH RXIPV4_FRAGMENTED_OCTETS: RXIPV4FRAGOCT Position */
#define ETH_RXIPV4_FRAGMENTED_OCTETS_RXIPV4FRAGOCT_Msk (0xffffffffUL << ETH_RXIPV4_FRAGMENTED_OCTETS_RXIPV4FRAGOCT_Pos)/*!< ETH RXIPV4_FRAGMENTED_OCTETS: RXIPV4FRAGOCT Mask */

/* -------------------  ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS  ------------------- */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_RXIPV4UDSBLOCT_Pos 0                                   /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS: RXIPV4UDSBLOCT Position */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_RXIPV4UDSBLOCT_Msk (0xffffffffUL << ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_RXIPV4UDSBLOCT_Pos)/*!< ETH RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS: RXIPV4UDSBLOCT Mask */

/* ---------------------------  ETH_RXIPV6_GOOD_OCTETS  --------------------------- */
#define ETH_RXIPV6_GOOD_OCTETS_RXIPV6GDOCT_Pos 0                                                      /*!< ETH RXIPV6_GOOD_OCTETS: RXIPV6GDOCT Position */
#define ETH_RXIPV6_GOOD_OCTETS_RXIPV6GDOCT_Msk (0xffffffffUL << ETH_RXIPV6_GOOD_OCTETS_RXIPV6GDOCT_Pos)/*!< ETH RXIPV6_GOOD_OCTETS: RXIPV6GDOCT Mask */

/* -----------------------  ETH_RXIPV6_HEADER_ERROR_OCTETS  ----------------------- */
#define ETH_RXIPV6_HEADER_ERROR_OCTETS_RXIPV6HDRERROCT_Pos 0                                          /*!< ETH RXIPV6_HEADER_ERROR_OCTETS: RXIPV6HDRERROCT Position */
#define ETH_RXIPV6_HEADER_ERROR_OCTETS_RXIPV6HDRERROCT_Msk (0xffffffffUL << ETH_RXIPV6_HEADER_ERROR_OCTETS_RXIPV6HDRERROCT_Pos)/*!< ETH RXIPV6_HEADER_ERROR_OCTETS: RXIPV6HDRERROCT Mask */

/* ------------------------  ETH_RXIPV6_NO_PAYLOAD_OCTETS  ------------------------ */
#define ETH_RXIPV6_NO_PAYLOAD_OCTETS_RXIPV6NOPAYOCT_Pos 0                                             /*!< ETH RXIPV6_NO_PAYLOAD_OCTETS: RXIPV6NOPAYOCT Position */
#define ETH_RXIPV6_NO_PAYLOAD_OCTETS_RXIPV6NOPAYOCT_Msk (0xffffffffUL << ETH_RXIPV6_NO_PAYLOAD_OCTETS_RXIPV6NOPAYOCT_Pos)/*!< ETH RXIPV6_NO_PAYLOAD_OCTETS: RXIPV6NOPAYOCT Mask */

/* ----------------------------  ETH_RXUDP_GOOD_OCTETS  --------------------------- */
#define ETH_RXUDP_GOOD_OCTETS_RXUDPGDOCT_Pos  0                                                       /*!< ETH RXUDP_GOOD_OCTETS: RXUDPGDOCT Position */
#define ETH_RXUDP_GOOD_OCTETS_RXUDPGDOCT_Msk  (0xffffffffUL << ETH_RXUDP_GOOD_OCTETS_RXUDPGDOCT_Pos)  /*!< ETH RXUDP_GOOD_OCTETS: RXUDPGDOCT Mask  */

/* ---------------------------  ETH_RXUDP_ERROR_OCTETS  --------------------------- */
#define ETH_RXUDP_ERROR_OCTETS_RXUDPERROCT_Pos 0                                                      /*!< ETH RXUDP_ERROR_OCTETS: RXUDPERROCT Position */
#define ETH_RXUDP_ERROR_OCTETS_RXUDPERROCT_Msk (0xffffffffUL << ETH_RXUDP_ERROR_OCTETS_RXUDPERROCT_Pos)/*!< ETH RXUDP_ERROR_OCTETS: RXUDPERROCT Mask */

/* ----------------------------  ETH_RXTCP_GOOD_OCTETS  --------------------------- */
#define ETH_RXTCP_GOOD_OCTETS_RXTCPGDOCT_Pos  0                                                       /*!< ETH RXTCP_GOOD_OCTETS: RXTCPGDOCT Position */
#define ETH_RXTCP_GOOD_OCTETS_RXTCPGDOCT_Msk  (0xffffffffUL << ETH_RXTCP_GOOD_OCTETS_RXTCPGDOCT_Pos)  /*!< ETH RXTCP_GOOD_OCTETS: RXTCPGDOCT Mask  */

/* ---------------------------  ETH_RXTCP_ERROR_OCTETS  --------------------------- */
#define ETH_RXTCP_ERROR_OCTETS_RXTCPERROCT_Pos 0                                                      /*!< ETH RXTCP_ERROR_OCTETS: RXTCPERROCT Position */
#define ETH_RXTCP_ERROR_OCTETS_RXTCPERROCT_Msk (0xffffffffUL << ETH_RXTCP_ERROR_OCTETS_RXTCPERROCT_Pos)/*!< ETH RXTCP_ERROR_OCTETS: RXTCPERROCT Mask */

/* ---------------------------  ETH_RXICMP_GOOD_OCTETS  --------------------------- */
#define ETH_RXICMP_GOOD_OCTETS_RXICMPGDOCT_Pos 0                                                      /*!< ETH RXICMP_GOOD_OCTETS: RXICMPGDOCT Position */
#define ETH_RXICMP_GOOD_OCTETS_RXICMPGDOCT_Msk (0xffffffffUL << ETH_RXICMP_GOOD_OCTETS_RXICMPGDOCT_Pos)/*!< ETH RXICMP_GOOD_OCTETS: RXICMPGDOCT Mask */

/* ---------------------------  ETH_RXICMP_ERROR_OCTETS  -------------------------- */
#define ETH_RXICMP_ERROR_OCTETS_RXICMPERROCT_Pos 0                                                    /*!< ETH RXICMP_ERROR_OCTETS: RXICMPERROCT Position */
#define ETH_RXICMP_ERROR_OCTETS_RXICMPERROCT_Msk (0xffffffffUL << ETH_RXICMP_ERROR_OCTETS_RXICMPERROCT_Pos)/*!< ETH RXICMP_ERROR_OCTETS: RXICMPERROCT Mask */

/* ----------------------------  ETH_TIMESTAMP_CONTROL  --------------------------- */
#define ETH_TIMESTAMP_CONTROL_TSENA_Pos       0                                                       /*!< ETH TIMESTAMP_CONTROL: TSENA Position   */
#define ETH_TIMESTAMP_CONTROL_TSENA_Msk       (0x01UL << ETH_TIMESTAMP_CONTROL_TSENA_Pos)             /*!< ETH TIMESTAMP_CONTROL: TSENA Mask       */
#define ETH_TIMESTAMP_CONTROL_TSCFUPDT_Pos    1                                                       /*!< ETH TIMESTAMP_CONTROL: TSCFUPDT Position */
#define ETH_TIMESTAMP_CONTROL_TSCFUPDT_Msk    (0x01UL << ETH_TIMESTAMP_CONTROL_TSCFUPDT_Pos)          /*!< ETH TIMESTAMP_CONTROL: TSCFUPDT Mask    */
#define ETH_TIMESTAMP_CONTROL_TSINIT_Pos      2                                                       /*!< ETH TIMESTAMP_CONTROL: TSINIT Position  */
#define ETH_TIMESTAMP_CONTROL_TSINIT_Msk      (0x01UL << ETH_TIMESTAMP_CONTROL_TSINIT_Pos)            /*!< ETH TIMESTAMP_CONTROL: TSINIT Mask      */
#define ETH_TIMESTAMP_CONTROL_TSUPDT_Pos      3                                                       /*!< ETH TIMESTAMP_CONTROL: TSUPDT Position  */
#define ETH_TIMESTAMP_CONTROL_TSUPDT_Msk      (0x01UL << ETH_TIMESTAMP_CONTROL_TSUPDT_Pos)            /*!< ETH TIMESTAMP_CONTROL: TSUPDT Mask      */
#define ETH_TIMESTAMP_CONTROL_TSTRIG_Pos      4                                                       /*!< ETH TIMESTAMP_CONTROL: TSTRIG Position  */
#define ETH_TIMESTAMP_CONTROL_TSTRIG_Msk      (0x01UL << ETH_TIMESTAMP_CONTROL_TSTRIG_Pos)            /*!< ETH TIMESTAMP_CONTROL: TSTRIG Mask      */
#define ETH_TIMESTAMP_CONTROL_TSADDREG_Pos    5                                                       /*!< ETH TIMESTAMP_CONTROL: TSADDREG Position */
#define ETH_TIMESTAMP_CONTROL_TSADDREG_Msk    (0x01UL << ETH_TIMESTAMP_CONTROL_TSADDREG_Pos)          /*!< ETH TIMESTAMP_CONTROL: TSADDREG Mask    */
#define ETH_TIMESTAMP_CONTROL_Reserved_7_6_Pos 6                                                      /*!< ETH TIMESTAMP_CONTROL: Reserved_7_6 Position */
#define ETH_TIMESTAMP_CONTROL_Reserved_7_6_Msk (0x03UL << ETH_TIMESTAMP_CONTROL_Reserved_7_6_Pos)     /*!< ETH TIMESTAMP_CONTROL: Reserved_7_6 Mask */
#define ETH_TIMESTAMP_CONTROL_TSENALL_Pos     8                                                       /*!< ETH TIMESTAMP_CONTROL: TSENALL Position */
#define ETH_TIMESTAMP_CONTROL_TSENALL_Msk     (0x01UL << ETH_TIMESTAMP_CONTROL_TSENALL_Pos)           /*!< ETH TIMESTAMP_CONTROL: TSENALL Mask     */
#define ETH_TIMESTAMP_CONTROL_TSCTRLSSR_Pos   9                                                       /*!< ETH TIMESTAMP_CONTROL: TSCTRLSSR Position */
#define ETH_TIMESTAMP_CONTROL_TSCTRLSSR_Msk   (0x01UL << ETH_TIMESTAMP_CONTROL_TSCTRLSSR_Pos)         /*!< ETH TIMESTAMP_CONTROL: TSCTRLSSR Mask   */
#define ETH_TIMESTAMP_CONTROL_TSVER2ENA_Pos   10                                                      /*!< ETH TIMESTAMP_CONTROL: TSVER2ENA Position */
#define ETH_TIMESTAMP_CONTROL_TSVER2ENA_Msk   (0x01UL << ETH_TIMESTAMP_CONTROL_TSVER2ENA_Pos)         /*!< ETH TIMESTAMP_CONTROL: TSVER2ENA Mask   */
#define ETH_TIMESTAMP_CONTROL_TSIPENA_Pos     11                                                      /*!< ETH TIMESTAMP_CONTROL: TSIPENA Position */
#define ETH_TIMESTAMP_CONTROL_TSIPENA_Msk     (0x01UL << ETH_TIMESTAMP_CONTROL_TSIPENA_Pos)           /*!< ETH TIMESTAMP_CONTROL: TSIPENA Mask     */
#define ETH_TIMESTAMP_CONTROL_TSIPV6ENA_Pos   12                                                      /*!< ETH TIMESTAMP_CONTROL: TSIPV6ENA Position */
#define ETH_TIMESTAMP_CONTROL_TSIPV6ENA_Msk   (0x01UL << ETH_TIMESTAMP_CONTROL_TSIPV6ENA_Pos)         /*!< ETH TIMESTAMP_CONTROL: TSIPV6ENA Mask   */
#define ETH_TIMESTAMP_CONTROL_TSIPV4ENA_Pos   13                                                      /*!< ETH TIMESTAMP_CONTROL: TSIPV4ENA Position */
#define ETH_TIMESTAMP_CONTROL_TSIPV4ENA_Msk   (0x01UL << ETH_TIMESTAMP_CONTROL_TSIPV4ENA_Pos)         /*!< ETH TIMESTAMP_CONTROL: TSIPV4ENA Mask   */
#define ETH_TIMESTAMP_CONTROL_TSEVNTENA_Pos   14                                                      /*!< ETH TIMESTAMP_CONTROL: TSEVNTENA Position */
#define ETH_TIMESTAMP_CONTROL_TSEVNTENA_Msk   (0x01UL << ETH_TIMESTAMP_CONTROL_TSEVNTENA_Pos)         /*!< ETH TIMESTAMP_CONTROL: TSEVNTENA Mask   */
#define ETH_TIMESTAMP_CONTROL_TSMSTRENA_Pos   15                                                      /*!< ETH TIMESTAMP_CONTROL: TSMSTRENA Position */
#define ETH_TIMESTAMP_CONTROL_TSMSTRENA_Msk   (0x01UL << ETH_TIMESTAMP_CONTROL_TSMSTRENA_Pos)         /*!< ETH TIMESTAMP_CONTROL: TSMSTRENA Mask   */
#define ETH_TIMESTAMP_CONTROL_SNAPTYPSEL_Pos  16                                                      /*!< ETH TIMESTAMP_CONTROL: SNAPTYPSEL Position */
#define ETH_TIMESTAMP_CONTROL_SNAPTYPSEL_Msk  (0x03UL << ETH_TIMESTAMP_CONTROL_SNAPTYPSEL_Pos)        /*!< ETH TIMESTAMP_CONTROL: SNAPTYPSEL Mask  */
#define ETH_TIMESTAMP_CONTROL_TSENMACADDR_Pos 18                                                      /*!< ETH TIMESTAMP_CONTROL: TSENMACADDR Position */
#define ETH_TIMESTAMP_CONTROL_TSENMACADDR_Msk (0x01UL << ETH_TIMESTAMP_CONTROL_TSENMACADDR_Pos)       /*!< ETH TIMESTAMP_CONTROL: TSENMACADDR Mask */
#define ETH_TIMESTAMP_CONTROL_Reserved_23_19_Pos 19                                                   /*!< ETH TIMESTAMP_CONTROL: Reserved_23_19 Position */
#define ETH_TIMESTAMP_CONTROL_Reserved_23_19_Msk (0x00001fffUL << ETH_TIMESTAMP_CONTROL_Reserved_23_19_Pos)/*!< ETH TIMESTAMP_CONTROL: Reserved_23_19 Mask */

/* --------------------------  ETH_SUB_SECOND_INCREMENT  -------------------------- */
#define ETH_SUB_SECOND_INCREMENT_SSINC_Pos    0                                                       /*!< ETH SUB_SECOND_INCREMENT: SSINC Position */
#define ETH_SUB_SECOND_INCREMENT_SSINC_Msk    (0x000000ffUL << ETH_SUB_SECOND_INCREMENT_SSINC_Pos)    /*!< ETH SUB_SECOND_INCREMENT: SSINC Mask    */
#define ETH_SUB_SECOND_INCREMENT_Reserved_31_8_Pos 8                                                  /*!< ETH SUB_SECOND_INCREMENT: Reserved_31_8 Position */
#define ETH_SUB_SECOND_INCREMENT_Reserved_31_8_Msk (0x00ffffffUL << ETH_SUB_SECOND_INCREMENT_Reserved_31_8_Pos)/*!< ETH SUB_SECOND_INCREMENT: Reserved_31_8 Mask */

/* ---------------------------  ETH_SYSTEM_TIME_SECONDS  -------------------------- */
#define ETH_SYSTEM_TIME_SECONDS_TSS_Pos       0                                                       /*!< ETH SYSTEM_TIME_SECONDS: TSS Position   */
#define ETH_SYSTEM_TIME_SECONDS_TSS_Msk       (0xffffffffUL << ETH_SYSTEM_TIME_SECONDS_TSS_Pos)       /*!< ETH SYSTEM_TIME_SECONDS: TSS Mask       */

/* -------------------------  ETH_SYSTEM_TIME_NANOSECONDS  ------------------------ */
#define ETH_SYSTEM_TIME_NANOSECONDS_TSSS_Pos  0                                                       /*!< ETH SYSTEM_TIME_NANOSECONDS: TSSS Position */
#define ETH_SYSTEM_TIME_NANOSECONDS_TSSS_Msk  (0x7fffffffUL << ETH_SYSTEM_TIME_NANOSECONDS_TSSS_Pos)  /*!< ETH SYSTEM_TIME_NANOSECONDS: TSSS Mask  */
#define ETH_SYSTEM_TIME_NANOSECONDS_Reserved_31_Pos 31                                                /*!< ETH SYSTEM_TIME_NANOSECONDS: Reserved_31 Position */
#define ETH_SYSTEM_TIME_NANOSECONDS_Reserved_31_Msk (0x01UL << ETH_SYSTEM_TIME_NANOSECONDS_Reserved_31_Pos)/*!< ETH SYSTEM_TIME_NANOSECONDS: Reserved_31 Mask */

/* -----------------------  ETH_SYSTEM_TIME_SECONDS_UPDATE  ----------------------- */
#define ETH_SYSTEM_TIME_SECONDS_UPDATE_TSS_Pos 0                                                      /*!< ETH SYSTEM_TIME_SECONDS_UPDATE: TSS Position */
#define ETH_SYSTEM_TIME_SECONDS_UPDATE_TSS_Msk (0xffffffffUL << ETH_SYSTEM_TIME_SECONDS_UPDATE_TSS_Pos)/*!< ETH SYSTEM_TIME_SECONDS_UPDATE: TSS Mask */

/* ---------------------  ETH_SYSTEM_TIME_NANOSECONDS_UPDATE  --------------------- */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_Pos 0                                                 /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: TSSS Position */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_Msk (0x7fffffffUL << ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_Pos)/*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: TSSS Mask */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_Pos 31                                              /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: ADDSUB Position */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_Msk (0x01UL << ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_Pos)/*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: ADDSUB Mask */

/* ----------------------------  ETH_TIMESTAMP_ADDEND  ---------------------------- */
#define ETH_TIMESTAMP_ADDEND_TSAR_Pos         0                                                       /*!< ETH TIMESTAMP_ADDEND: TSAR Position     */
#define ETH_TIMESTAMP_ADDEND_TSAR_Msk         (0xffffffffUL << ETH_TIMESTAMP_ADDEND_TSAR_Pos)         /*!< ETH TIMESTAMP_ADDEND: TSAR Mask         */

/* ---------------------------  ETH_TARGET_TIME_SECONDS  -------------------------- */
#define ETH_TARGET_TIME_SECONDS_TSTR_Pos      0                                                       /*!< ETH TARGET_TIME_SECONDS: TSTR Position  */
#define ETH_TARGET_TIME_SECONDS_TSTR_Msk      (0xffffffffUL << ETH_TARGET_TIME_SECONDS_TSTR_Pos)      /*!< ETH TARGET_TIME_SECONDS: TSTR Mask      */

/* -------------------------  ETH_TARGET_TIME_NANOSECONDS  ------------------------ */
#define ETH_TARGET_TIME_NANOSECONDS_TTSLO_Pos 0                                                       /*!< ETH TARGET_TIME_NANOSECONDS: TTSLO Position */
#define ETH_TARGET_TIME_NANOSECONDS_TTSLO_Msk (0x7fffffffUL << ETH_TARGET_TIME_NANOSECONDS_TTSLO_Pos) /*!< ETH TARGET_TIME_NANOSECONDS: TTSLO Mask */
#define ETH_TARGET_TIME_NANOSECONDS_TRGTBUSY_Pos 31                                                   /*!< ETH TARGET_TIME_NANOSECONDS: TRGTBUSY Position */
#define ETH_TARGET_TIME_NANOSECONDS_TRGTBUSY_Msk (0x01UL << ETH_TARGET_TIME_NANOSECONDS_TRGTBUSY_Pos) /*!< ETH TARGET_TIME_NANOSECONDS: TRGTBUSY Mask */

/* ---------------------  ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS  -------------------- */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_TSHWR_Pos 0                                               /*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: TSHWR Position */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_TSHWR_Msk (0x0000ffffUL << ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_TSHWR_Pos)/*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: TSHWR Mask */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_Reserved_31_16_Pos 16                                     /*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: Reserved_31_16 Position */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_Reserved_31_16_Msk (0x0000ffffUL << ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_Reserved_31_16_Pos)/*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: Reserved_31_16 Mask */

/* ----------------------------  ETH_TIMESTAMP_STATUS  ---------------------------- */
#define ETH_TIMESTAMP_STATUS_TSSOVF_Pos       0                                                       /*!< ETH TIMESTAMP_STATUS: TSSOVF Position   */
#define ETH_TIMESTAMP_STATUS_TSSOVF_Msk       (0x01UL << ETH_TIMESTAMP_STATUS_TSSOVF_Pos)             /*!< ETH TIMESTAMP_STATUS: TSSOVF Mask       */
#define ETH_TIMESTAMP_STATUS_TSTARGT_Pos      1                                                       /*!< ETH TIMESTAMP_STATUS: TSTARGT Position  */
#define ETH_TIMESTAMP_STATUS_TSTARGT_Msk      (0x01UL << ETH_TIMESTAMP_STATUS_TSTARGT_Pos)            /*!< ETH TIMESTAMP_STATUS: TSTARGT Mask      */
#define ETH_TIMESTAMP_STATUS_Reserved_2_Pos   2                                                       /*!< ETH TIMESTAMP_STATUS: Reserved_2 Position */
#define ETH_TIMESTAMP_STATUS_Reserved_2_Msk   (0x01UL << ETH_TIMESTAMP_STATUS_Reserved_2_Pos)         /*!< ETH TIMESTAMP_STATUS: Reserved_2 Mask   */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR_Pos    3                                                       /*!< ETH TIMESTAMP_STATUS: TSTRGTERR Position */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR_Msk    (0x01UL << ETH_TIMESTAMP_STATUS_TSTRGTERR_Pos)          /*!< ETH TIMESTAMP_STATUS: TSTRGTERR Mask    */
#define ETH_TIMESTAMP_STATUS_TSTARGT1_Pos     4                                                       /*!< ETH TIMESTAMP_STATUS: TSTARGT1 Position */
#define ETH_TIMESTAMP_STATUS_TSTARGT1_Msk     (0x01UL << ETH_TIMESTAMP_STATUS_TSTARGT1_Pos)           /*!< ETH TIMESTAMP_STATUS: TSTARGT1 Mask     */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR1_Pos   5                                                       /*!< ETH TIMESTAMP_STATUS: TSTRGTERR1 Position */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR1_Msk   (0x01UL << ETH_TIMESTAMP_STATUS_TSTRGTERR1_Pos)         /*!< ETH TIMESTAMP_STATUS: TSTRGTERR1 Mask   */
#define ETH_TIMESTAMP_STATUS_TSTARGT2_Pos     6                                                       /*!< ETH TIMESTAMP_STATUS: TSTARGT2 Position */
#define ETH_TIMESTAMP_STATUS_TSTARGT2_Msk     (0x01UL << ETH_TIMESTAMP_STATUS_TSTARGT2_Pos)           /*!< ETH TIMESTAMP_STATUS: TSTARGT2 Mask     */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR2_Pos   7                                                       /*!< ETH TIMESTAMP_STATUS: TSTRGTERR2 Position */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR2_Msk   (0x01UL << ETH_TIMESTAMP_STATUS_TSTRGTERR2_Pos)         /*!< ETH TIMESTAMP_STATUS: TSTRGTERR2 Mask   */
#define ETH_TIMESTAMP_STATUS_TSTARGT3_Pos     8                                                       /*!< ETH TIMESTAMP_STATUS: TSTARGT3 Position */
#define ETH_TIMESTAMP_STATUS_TSTARGT3_Msk     (0x01UL << ETH_TIMESTAMP_STATUS_TSTARGT3_Pos)           /*!< ETH TIMESTAMP_STATUS: TSTARGT3 Mask     */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR3_Pos   9                                                       /*!< ETH TIMESTAMP_STATUS: TSTRGTERR3 Position */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR3_Msk   (0x01UL << ETH_TIMESTAMP_STATUS_TSTRGTERR3_Pos)         /*!< ETH TIMESTAMP_STATUS: TSTRGTERR3 Mask   */
#define ETH_TIMESTAMP_STATUS_Reserved_15_10_Pos 10                                                    /*!< ETH TIMESTAMP_STATUS: Reserved_15_10 Position */
#define ETH_TIMESTAMP_STATUS_Reserved_15_10_Msk (0x3fUL << ETH_TIMESTAMP_STATUS_Reserved_15_10_Pos)   /*!< ETH TIMESTAMP_STATUS: Reserved_15_10 Mask */
#define ETH_TIMESTAMP_STATUS_Reserved_19_16_Pos 16                                                    /*!< ETH TIMESTAMP_STATUS: Reserved_19_16 Position */
#define ETH_TIMESTAMP_STATUS_Reserved_19_16_Msk (0x0fUL << ETH_TIMESTAMP_STATUS_Reserved_19_16_Pos)   /*!< ETH TIMESTAMP_STATUS: Reserved_19_16 Mask */
#define ETH_TIMESTAMP_STATUS_Reserved_23_20_Pos 20                                                    /*!< ETH TIMESTAMP_STATUS: Reserved_23_20 Position */
#define ETH_TIMESTAMP_STATUS_Reserved_23_20_Msk (0x0fUL << ETH_TIMESTAMP_STATUS_Reserved_23_20_Pos)   /*!< ETH TIMESTAMP_STATUS: Reserved_23_20 Mask */
#define ETH_TIMESTAMP_STATUS_Reserved_24_Pos  24                                                      /*!< ETH TIMESTAMP_STATUS: Reserved_24 Position */
#define ETH_TIMESTAMP_STATUS_Reserved_24_Msk  (0x01UL << ETH_TIMESTAMP_STATUS_Reserved_24_Pos)        /*!< ETH TIMESTAMP_STATUS: Reserved_24 Mask  */
#define ETH_TIMESTAMP_STATUS_Reserved_29_25_Pos 25                                                    /*!< ETH TIMESTAMP_STATUS: Reserved_29_25 Position */
#define ETH_TIMESTAMP_STATUS_Reserved_29_25_Msk (0x1fUL << ETH_TIMESTAMP_STATUS_Reserved_29_25_Pos)   /*!< ETH TIMESTAMP_STATUS: Reserved_29_25 Mask */
#define ETH_TIMESTAMP_STATUS_Reserved_31_30_Pos 30                                                    /*!< ETH TIMESTAMP_STATUS: Reserved_31_30 Position */
#define ETH_TIMESTAMP_STATUS_Reserved_31_30_Msk (0x03UL << ETH_TIMESTAMP_STATUS_Reserved_31_30_Pos)   /*!< ETH TIMESTAMP_STATUS: Reserved_31_30 Mask */

/* -------------------------------  ETH_PPS_CONTROL  ------------------------------ */
#define ETH_PPS_CONTROL_PPSCTRL_PPSCMD_Pos    0                                                       /*!< ETH PPS_CONTROL: PPSCTRL_PPSCMD Position */
#define ETH_PPS_CONTROL_PPSCTRL_PPSCMD_Msk    (0x0fUL << ETH_PPS_CONTROL_PPSCTRL_PPSCMD_Pos)          /*!< ETH PPS_CONTROL: PPSCTRL_PPSCMD Mask    */
#define ETH_PPS_CONTROL_PPSEN0_Pos            4                                                       /*!< ETH PPS_CONTROL: PPSEN0 Position        */
#define ETH_PPS_CONTROL_PPSEN0_Msk            (0x01UL << ETH_PPS_CONTROL_PPSEN0_Pos)                  /*!< ETH PPS_CONTROL: PPSEN0 Mask            */
#define ETH_PPS_CONTROL_TRGTMODSEL0_Pos       5                                                       /*!< ETH PPS_CONTROL: TRGTMODSEL0 Position   */
#define ETH_PPS_CONTROL_TRGTMODSEL0_Msk       (0x03UL << ETH_PPS_CONTROL_TRGTMODSEL0_Pos)             /*!< ETH PPS_CONTROL: TRGTMODSEL0 Mask       */
#define ETH_PPS_CONTROL_Reserved_7_Pos        7                                                       /*!< ETH PPS_CONTROL: Reserved_7 Position    */
#define ETH_PPS_CONTROL_Reserved_7_Msk        (0x01UL << ETH_PPS_CONTROL_Reserved_7_Pos)              /*!< ETH PPS_CONTROL: Reserved_7 Mask        */
#define ETH_PPS_CONTROL_PPSCMD1_Pos           8                                                       /*!< ETH PPS_CONTROL: PPSCMD1 Position       */
#define ETH_PPS_CONTROL_PPSCMD1_Msk           (0x07UL << ETH_PPS_CONTROL_PPSCMD1_Pos)                 /*!< ETH PPS_CONTROL: PPSCMD1 Mask           */
#define ETH_PPS_CONTROL_Reserved_12_11_Pos    11                                                      /*!< ETH PPS_CONTROL: Reserved_12_11 Position */
#define ETH_PPS_CONTROL_Reserved_12_11_Msk    (0x03UL << ETH_PPS_CONTROL_Reserved_12_11_Pos)          /*!< ETH PPS_CONTROL: Reserved_12_11 Mask    */
#define ETH_PPS_CONTROL_TRGTMODSEL1_Pos       13                                                      /*!< ETH PPS_CONTROL: TRGTMODSEL1 Position   */
#define ETH_PPS_CONTROL_TRGTMODSEL1_Msk       (0x03UL << ETH_PPS_CONTROL_TRGTMODSEL1_Pos)             /*!< ETH PPS_CONTROL: TRGTMODSEL1 Mask       */
#define ETH_PPS_CONTROL_Reserved_15_Pos       15                                                      /*!< ETH PPS_CONTROL: Reserved_15 Position   */
#define ETH_PPS_CONTROL_Reserved_15_Msk       (0x01UL << ETH_PPS_CONTROL_Reserved_15_Pos)             /*!< ETH PPS_CONTROL: Reserved_15 Mask       */
#define ETH_PPS_CONTROL_PPSCMD2_Pos           16                                                      /*!< ETH PPS_CONTROL: PPSCMD2 Position       */
#define ETH_PPS_CONTROL_PPSCMD2_Msk           (0x07UL << ETH_PPS_CONTROL_PPSCMD2_Pos)                 /*!< ETH PPS_CONTROL: PPSCMD2 Mask           */
#define ETH_PPS_CONTROL_Reserved_20_19_Pos    19                                                      /*!< ETH PPS_CONTROL: Reserved_20_19 Position */
#define ETH_PPS_CONTROL_Reserved_20_19_Msk    (0x03UL << ETH_PPS_CONTROL_Reserved_20_19_Pos)          /*!< ETH PPS_CONTROL: Reserved_20_19 Mask    */
#define ETH_PPS_CONTROL_TRGTMODSEL2_Pos       21                                                      /*!< ETH PPS_CONTROL: TRGTMODSEL2 Position   */
#define ETH_PPS_CONTROL_TRGTMODSEL2_Msk       (0x03UL << ETH_PPS_CONTROL_TRGTMODSEL2_Pos)             /*!< ETH PPS_CONTROL: TRGTMODSEL2 Mask       */
#define ETH_PPS_CONTROL_Reserved_23_Pos       23                                                      /*!< ETH PPS_CONTROL: Reserved_23 Position   */
#define ETH_PPS_CONTROL_Reserved_23_Msk       (0x01UL << ETH_PPS_CONTROL_Reserved_23_Pos)             /*!< ETH PPS_CONTROL: Reserved_23 Mask       */
#define ETH_PPS_CONTROL_PPSCMD3_Pos           24                                                      /*!< ETH PPS_CONTROL: PPSCMD3 Position       */
#define ETH_PPS_CONTROL_PPSCMD3_Msk           (0x07UL << ETH_PPS_CONTROL_PPSCMD3_Pos)                 /*!< ETH PPS_CONTROL: PPSCMD3 Mask           */
#define ETH_PPS_CONTROL_Reserved_28_27_Pos    27                                                      /*!< ETH PPS_CONTROL: Reserved_28_27 Position */
#define ETH_PPS_CONTROL_Reserved_28_27_Msk    (0x03UL << ETH_PPS_CONTROL_Reserved_28_27_Pos)          /*!< ETH PPS_CONTROL: Reserved_28_27 Mask    */
#define ETH_PPS_CONTROL_TRGTMODSEL3_Pos       29                                                      /*!< ETH PPS_CONTROL: TRGTMODSEL3 Position   */
#define ETH_PPS_CONTROL_TRGTMODSEL3_Msk       (0x03UL << ETH_PPS_CONTROL_TRGTMODSEL3_Pos)             /*!< ETH PPS_CONTROL: TRGTMODSEL3 Mask       */
#define ETH_PPS_CONTROL_Reserved_31_Pos       31                                                      /*!< ETH PPS_CONTROL: Reserved_31 Position   */
#define ETH_PPS_CONTROL_Reserved_31_Msk       (0x01UL << ETH_PPS_CONTROL_Reserved_31_Pos)             /*!< ETH PPS_CONTROL: Reserved_31 Mask       */

/* --------------------------------  ETH_BUS_MODE  -------------------------------- */
#define ETH_BUS_MODE_SWR_Pos                  0                                                       /*!< ETH BUS_MODE: SWR Position              */
#define ETH_BUS_MODE_SWR_Msk                  (0x01UL << ETH_BUS_MODE_SWR_Pos)                        /*!< ETH BUS_MODE: SWR Mask                  */
#define ETH_BUS_MODE_DA_Pos                   1                                                       /*!< ETH BUS_MODE: DA Position               */
#define ETH_BUS_MODE_DA_Msk                   (0x01UL << ETH_BUS_MODE_DA_Pos)                         /*!< ETH BUS_MODE: DA Mask                   */
#define ETH_BUS_MODE_DSL_Pos                  2                                                       /*!< ETH BUS_MODE: DSL Position              */
#define ETH_BUS_MODE_DSL_Msk                  (0x1fUL << ETH_BUS_MODE_DSL_Pos)                        /*!< ETH BUS_MODE: DSL Mask                  */
#define ETH_BUS_MODE_Reserved_7_Pos           7                                                       /*!< ETH BUS_MODE: Reserved_7 Position       */
#define ETH_BUS_MODE_Reserved_7_Msk           (0x01UL << ETH_BUS_MODE_Reserved_7_Pos)                 /*!< ETH BUS_MODE: Reserved_7 Mask           */
#define ETH_BUS_MODE_PBL_Pos                  8                                                       /*!< ETH BUS_MODE: PBL Position              */
#define ETH_BUS_MODE_PBL_Msk                  (0x3fUL << ETH_BUS_MODE_PBL_Pos)                        /*!< ETH BUS_MODE: PBL Mask                  */
#define ETH_BUS_MODE_PR_Pos                   14                                                      /*!< ETH BUS_MODE: PR Position               */
#define ETH_BUS_MODE_PR_Msk                   (0x03UL << ETH_BUS_MODE_PR_Pos)                         /*!< ETH BUS_MODE: PR Mask                   */
#define ETH_BUS_MODE_FB_Pos                   16                                                      /*!< ETH BUS_MODE: FB Position               */
#define ETH_BUS_MODE_FB_Msk                   (0x01UL << ETH_BUS_MODE_FB_Pos)                         /*!< ETH BUS_MODE: FB Mask                   */
#define ETH_BUS_MODE_RPBL_Pos                 17                                                      /*!< ETH BUS_MODE: RPBL Position             */
#define ETH_BUS_MODE_RPBL_Msk                 (0x3fUL << ETH_BUS_MODE_RPBL_Pos)                       /*!< ETH BUS_MODE: RPBL Mask                 */
#define ETH_BUS_MODE_USP_Pos                  23                                                      /*!< ETH BUS_MODE: USP Position              */
#define ETH_BUS_MODE_USP_Msk                  (0x01UL << ETH_BUS_MODE_USP_Pos)                        /*!< ETH BUS_MODE: USP Mask                  */
#define ETH_BUS_MODE_EIGHTxPBL_Pos            24                                                      /*!< ETH BUS_MODE: EIGHTxPBL Position        */
#define ETH_BUS_MODE_EIGHTxPBL_Msk            (0x01UL << ETH_BUS_MODE_EIGHTxPBL_Pos)                  /*!< ETH BUS_MODE: EIGHTxPBL Mask            */
#define ETH_BUS_MODE_AAL_Pos                  25                                                      /*!< ETH BUS_MODE: AAL Position              */
#define ETH_BUS_MODE_AAL_Msk                  (0x01UL << ETH_BUS_MODE_AAL_Pos)                        /*!< ETH BUS_MODE: AAL Mask                  */
#define ETH_BUS_MODE_MB_Pos                   26                                                      /*!< ETH BUS_MODE: MB Position               */
#define ETH_BUS_MODE_MB_Msk                   (0x01UL << ETH_BUS_MODE_MB_Pos)                         /*!< ETH BUS_MODE: MB Mask                   */
#define ETH_BUS_MODE_TXPR_Pos                 27                                                      /*!< ETH BUS_MODE: TXPR Position             */
#define ETH_BUS_MODE_TXPR_Msk                 (0x01UL << ETH_BUS_MODE_TXPR_Pos)                       /*!< ETH BUS_MODE: TXPR Mask                 */
#define ETH_BUS_MODE_PRWG_Pos                 28                                                      /*!< ETH BUS_MODE: PRWG Position             */
#define ETH_BUS_MODE_PRWG_Msk                 (0x03UL << ETH_BUS_MODE_PRWG_Pos)                       /*!< ETH BUS_MODE: PRWG Mask                 */
#define ETH_BUS_MODE_Reserved_31_30_Pos       30                                                      /*!< ETH BUS_MODE: Reserved_31_30 Position   */
#define ETH_BUS_MODE_Reserved_31_30_Msk       (0x03UL << ETH_BUS_MODE_Reserved_31_30_Pos)             /*!< ETH BUS_MODE: Reserved_31_30 Mask       */

/* --------------------------  ETH_TRANSMIT_POLL_DEMAND  -------------------------- */
#define ETH_TRANSMIT_POLL_DEMAND_TPD_Pos      0                                                       /*!< ETH TRANSMIT_POLL_DEMAND: TPD Position  */
#define ETH_TRANSMIT_POLL_DEMAND_TPD_Msk      (0xffffffffUL << ETH_TRANSMIT_POLL_DEMAND_TPD_Pos)      /*!< ETH TRANSMIT_POLL_DEMAND: TPD Mask      */

/* ---------------------------  ETH_RECEIVE_POLL_DEMAND  -------------------------- */
#define ETH_RECEIVE_POLL_DEMAND_RPD_Pos       0                                                       /*!< ETH RECEIVE_POLL_DEMAND: RPD Position   */
#define ETH_RECEIVE_POLL_DEMAND_RPD_Msk       (0xffffffffUL << ETH_RECEIVE_POLL_DEMAND_RPD_Pos)       /*!< ETH RECEIVE_POLL_DEMAND: RPD Mask       */

/* ---------------------  ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS  -------------------- */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_Reserved_1_0_Pos 0                                        /*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: Reserved_1_0 Position */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_Reserved_1_0_Msk (0x03UL << ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_Reserved_1_0_Pos)/*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: Reserved_1_0 Mask */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_RDESLA_32bit_Pos 2                                        /*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: RDESLA_32bit Position */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_RDESLA_32bit_Msk (0x3fffffffUL << ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_RDESLA_32bit_Pos)/*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: RDESLA_32bit Mask */

/* --------------------  ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS  -------------------- */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_Reserved_1_0_Pos 0                                       /*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: Reserved_1_0 Position */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_Reserved_1_0_Msk (0x03UL << ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_Reserved_1_0_Pos)/*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: Reserved_1_0 Mask */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_TDESLA_32bit_Pos 2                                       /*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: TDESLA_32bit Position */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_TDESLA_32bit_Msk (0x3fffffffUL << ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_TDESLA_32bit_Pos)/*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: TDESLA_32bit Mask */

/* ---------------------------------  ETH_STATUS  --------------------------------- */
#define ETH_STATUS_TI_Pos                     0                                                       /*!< ETH STATUS: TI Position                 */
#define ETH_STATUS_TI_Msk                     (0x01UL << ETH_STATUS_TI_Pos)                           /*!< ETH STATUS: TI Mask                     */
#define ETH_STATUS_TPS_Pos                    1                                                       /*!< ETH STATUS: TPS Position                */
#define ETH_STATUS_TPS_Msk                    (0x01UL << ETH_STATUS_TPS_Pos)                          /*!< ETH STATUS: TPS Mask                    */
#define ETH_STATUS_TU_Pos                     2                                                       /*!< ETH STATUS: TU Position                 */
#define ETH_STATUS_TU_Msk                     (0x01UL << ETH_STATUS_TU_Pos)                           /*!< ETH STATUS: TU Mask                     */
#define ETH_STATUS_TJT_Pos                    3                                                       /*!< ETH STATUS: TJT Position                */
#define ETH_STATUS_TJT_Msk                    (0x01UL << ETH_STATUS_TJT_Pos)                          /*!< ETH STATUS: TJT Mask                    */
#define ETH_STATUS_OVF_Pos                    4                                                       /*!< ETH STATUS: OVF Position                */
#define ETH_STATUS_OVF_Msk                    (0x01UL << ETH_STATUS_OVF_Pos)                          /*!< ETH STATUS: OVF Mask                    */
#define ETH_STATUS_UNF_Pos                    5                                                       /*!< ETH STATUS: UNF Position                */
#define ETH_STATUS_UNF_Msk                    (0x01UL << ETH_STATUS_UNF_Pos)                          /*!< ETH STATUS: UNF Mask                    */
#define ETH_STATUS_RI_Pos                     6                                                       /*!< ETH STATUS: RI Position                 */
#define ETH_STATUS_RI_Msk                     (0x01UL << ETH_STATUS_RI_Pos)                           /*!< ETH STATUS: RI Mask                     */
#define ETH_STATUS_RU_Pos                     7                                                       /*!< ETH STATUS: RU Position                 */
#define ETH_STATUS_RU_Msk                     (0x01UL << ETH_STATUS_RU_Pos)                           /*!< ETH STATUS: RU Mask                     */
#define ETH_STATUS_RPS_Pos                    8                                                       /*!< ETH STATUS: RPS Position                */
#define ETH_STATUS_RPS_Msk                    (0x01UL << ETH_STATUS_RPS_Pos)                          /*!< ETH STATUS: RPS Mask                    */
#define ETH_STATUS_RWT_Pos                    9                                                       /*!< ETH STATUS: RWT Position                */
#define ETH_STATUS_RWT_Msk                    (0x01UL << ETH_STATUS_RWT_Pos)                          /*!< ETH STATUS: RWT Mask                    */
#define ETH_STATUS_ETI_Pos                    10                                                      /*!< ETH STATUS: ETI Position                */
#define ETH_STATUS_ETI_Msk                    (0x01UL << ETH_STATUS_ETI_Pos)                          /*!< ETH STATUS: ETI Mask                    */
#define ETH_STATUS_Reserved_12_11_Pos         11                                                      /*!< ETH STATUS: Reserved_12_11 Position     */
#define ETH_STATUS_Reserved_12_11_Msk         (0x03UL << ETH_STATUS_Reserved_12_11_Pos)               /*!< ETH STATUS: Reserved_12_11 Mask         */
#define ETH_STATUS_FBI_Pos                    13                                                      /*!< ETH STATUS: FBI Position                */
#define ETH_STATUS_FBI_Msk                    (0x01UL << ETH_STATUS_FBI_Pos)                          /*!< ETH STATUS: FBI Mask                    */
#define ETH_STATUS_ERI_Pos                    14                                                      /*!< ETH STATUS: ERI Position                */
#define ETH_STATUS_ERI_Msk                    (0x01UL << ETH_STATUS_ERI_Pos)                          /*!< ETH STATUS: ERI Mask                    */
#define ETH_STATUS_AIS_Pos                    15                                                      /*!< ETH STATUS: AIS Position                */
#define ETH_STATUS_AIS_Msk                    (0x01UL << ETH_STATUS_AIS_Pos)                          /*!< ETH STATUS: AIS Mask                    */
#define ETH_STATUS_NIS_Pos                    16                                                      /*!< ETH STATUS: NIS Position                */
#define ETH_STATUS_NIS_Msk                    (0x01UL << ETH_STATUS_NIS_Pos)                          /*!< ETH STATUS: NIS Mask                    */
#define ETH_STATUS_RS_Pos                     17                                                      /*!< ETH STATUS: RS Position                 */
#define ETH_STATUS_RS_Msk                     (0x07UL << ETH_STATUS_RS_Pos)                           /*!< ETH STATUS: RS Mask                     */
#define ETH_STATUS_TS_Pos                     20                                                      /*!< ETH STATUS: TS Position                 */
#define ETH_STATUS_TS_Msk                     (0x07UL << ETH_STATUS_TS_Pos)                           /*!< ETH STATUS: TS Mask                     */
#define ETH_STATUS_EB_Pos                     23                                                      /*!< ETH STATUS: EB Position                 */
#define ETH_STATUS_EB_Msk                     (0x07UL << ETH_STATUS_EB_Pos)                           /*!< ETH STATUS: EB Mask                     */
#define ETH_STATUS_Reserved_26_Pos            26                                                      /*!< ETH STATUS: Reserved_26 Position        */
#define ETH_STATUS_Reserved_26_Msk            (0x01UL << ETH_STATUS_Reserved_26_Pos)                  /*!< ETH STATUS: Reserved_26 Mask            */
#define ETH_STATUS_EMI_Pos                    27                                                      /*!< ETH STATUS: EMI Position                */
#define ETH_STATUS_EMI_Msk                    (0x01UL << ETH_STATUS_EMI_Pos)                          /*!< ETH STATUS: EMI Mask                    */
#define ETH_STATUS_EPI_Pos                    28                                                      /*!< ETH STATUS: EPI Position                */
#define ETH_STATUS_EPI_Msk                    (0x01UL << ETH_STATUS_EPI_Pos)                          /*!< ETH STATUS: EPI Mask                    */
#define ETH_STATUS_TTI_Pos                    29                                                      /*!< ETH STATUS: TTI Position                */
#define ETH_STATUS_TTI_Msk                    (0x01UL << ETH_STATUS_TTI_Pos)                          /*!< ETH STATUS: TTI Mask                    */
#define ETH_STATUS_Reserved_30_Pos            30                                                      /*!< ETH STATUS: Reserved_30 Position        */
#define ETH_STATUS_Reserved_30_Msk            (0x01UL << ETH_STATUS_Reserved_30_Pos)                  /*!< ETH STATUS: Reserved_30 Mask            */
#define ETH_STATUS_Reserved_31_Pos            31                                                      /*!< ETH STATUS: Reserved_31 Position        */
#define ETH_STATUS_Reserved_31_Msk            (0x01UL << ETH_STATUS_Reserved_31_Pos)                  /*!< ETH STATUS: Reserved_31 Mask            */

/* -----------------------------  ETH_OPERATION_MODE  ----------------------------- */
#define ETH_OPERATION_MODE_Reserved_0_Pos     0                                                       /*!< ETH OPERATION_MODE: Reserved_0 Position */
#define ETH_OPERATION_MODE_Reserved_0_Msk     (0x01UL << ETH_OPERATION_MODE_Reserved_0_Pos)           /*!< ETH OPERATION_MODE: Reserved_0 Mask     */
#define ETH_OPERATION_MODE_SR_Pos             1                                                       /*!< ETH OPERATION_MODE: SR Position         */
#define ETH_OPERATION_MODE_SR_Msk             (0x01UL << ETH_OPERATION_MODE_SR_Pos)                   /*!< ETH OPERATION_MODE: SR Mask             */
#define ETH_OPERATION_MODE_OSF_Pos            2                                                       /*!< ETH OPERATION_MODE: OSF Position        */
#define ETH_OPERATION_MODE_OSF_Msk            (0x01UL << ETH_OPERATION_MODE_OSF_Pos)                  /*!< ETH OPERATION_MODE: OSF Mask            */
#define ETH_OPERATION_MODE_RTC_Pos            3                                                       /*!< ETH OPERATION_MODE: RTC Position        */
#define ETH_OPERATION_MODE_RTC_Msk            (0x03UL << ETH_OPERATION_MODE_RTC_Pos)                  /*!< ETH OPERATION_MODE: RTC Mask            */
#define ETH_OPERATION_MODE_Reserved_5_Pos     5                                                       /*!< ETH OPERATION_MODE: Reserved_5 Position */
#define ETH_OPERATION_MODE_Reserved_5_Msk     (0x01UL << ETH_OPERATION_MODE_Reserved_5_Pos)           /*!< ETH OPERATION_MODE: Reserved_5 Mask     */
#define ETH_OPERATION_MODE_FUF_Pos            6                                                       /*!< ETH OPERATION_MODE: FUF Position        */
#define ETH_OPERATION_MODE_FUF_Msk            (0x01UL << ETH_OPERATION_MODE_FUF_Pos)                  /*!< ETH OPERATION_MODE: FUF Mask            */
#define ETH_OPERATION_MODE_FEF_Pos            7                                                       /*!< ETH OPERATION_MODE: FEF Position        */
#define ETH_OPERATION_MODE_FEF_Msk            (0x01UL << ETH_OPERATION_MODE_FEF_Pos)                  /*!< ETH OPERATION_MODE: FEF Mask            */
#define ETH_OPERATION_MODE_Reserved_12_8_Pos  8                                                       /*!< ETH OPERATION_MODE: Reserved_12_8 Position */
#define ETH_OPERATION_MODE_Reserved_12_8_Msk  (0x1fUL << ETH_OPERATION_MODE_Reserved_12_8_Pos)        /*!< ETH OPERATION_MODE: Reserved_12_8 Mask  */
#define ETH_OPERATION_MODE_ST_Pos             13                                                      /*!< ETH OPERATION_MODE: ST Position         */
#define ETH_OPERATION_MODE_ST_Msk             (0x01UL << ETH_OPERATION_MODE_ST_Pos)                   /*!< ETH OPERATION_MODE: ST Mask             */
#define ETH_OPERATION_MODE_TTC_Pos            14                                                      /*!< ETH OPERATION_MODE: TTC Position        */
#define ETH_OPERATION_MODE_TTC_Msk            (0x07UL << ETH_OPERATION_MODE_TTC_Pos)                  /*!< ETH OPERATION_MODE: TTC Mask            */
#define ETH_OPERATION_MODE_Reserved_19_17_Pos 17                                                      /*!< ETH OPERATION_MODE: Reserved_19_17 Position */
#define ETH_OPERATION_MODE_Reserved_19_17_Msk (0x07UL << ETH_OPERATION_MODE_Reserved_19_17_Pos)       /*!< ETH OPERATION_MODE: Reserved_19_17 Mask */
#define ETH_OPERATION_MODE_FTF_Pos            20                                                      /*!< ETH OPERATION_MODE: FTF Position        */
#define ETH_OPERATION_MODE_FTF_Msk            (0x01UL << ETH_OPERATION_MODE_FTF_Pos)                  /*!< ETH OPERATION_MODE: FTF Mask            */
#define ETH_OPERATION_MODE_TSF_Pos            21                                                      /*!< ETH OPERATION_MODE: TSF Position        */
#define ETH_OPERATION_MODE_TSF_Msk            (0x01UL << ETH_OPERATION_MODE_TSF_Pos)                  /*!< ETH OPERATION_MODE: TSF Mask            */
#define ETH_OPERATION_MODE_Reserved_23_22_Pos 22                                                      /*!< ETH OPERATION_MODE: Reserved_23_22 Position */
#define ETH_OPERATION_MODE_Reserved_23_22_Msk (0x03UL << ETH_OPERATION_MODE_Reserved_23_22_Pos)       /*!< ETH OPERATION_MODE: Reserved_23_22 Mask */
#define ETH_OPERATION_MODE_DFF_Pos            24                                                      /*!< ETH OPERATION_MODE: DFF Position        */
#define ETH_OPERATION_MODE_DFF_Msk            (0x01UL << ETH_OPERATION_MODE_DFF_Pos)                  /*!< ETH OPERATION_MODE: DFF Mask            */
#define ETH_OPERATION_MODE_RSF_Pos            25                                                      /*!< ETH OPERATION_MODE: RSF Position        */
#define ETH_OPERATION_MODE_RSF_Msk            (0x01UL << ETH_OPERATION_MODE_RSF_Pos)                  /*!< ETH OPERATION_MODE: RSF Mask            */
#define ETH_OPERATION_MODE_DT_Pos             26                                                      /*!< ETH OPERATION_MODE: DT Position         */
#define ETH_OPERATION_MODE_DT_Msk             (0x01UL << ETH_OPERATION_MODE_DT_Pos)                   /*!< ETH OPERATION_MODE: DT Mask             */
#define ETH_OPERATION_MODE_Reserved_31_27_Pos 27                                                      /*!< ETH OPERATION_MODE: Reserved_31_27 Position */
#define ETH_OPERATION_MODE_Reserved_31_27_Msk (0x1fUL << ETH_OPERATION_MODE_Reserved_31_27_Pos)       /*!< ETH OPERATION_MODE: Reserved_31_27 Mask */

/* ----------------------------  ETH_INTERRUPT_ENABLE  ---------------------------- */
#define ETH_INTERRUPT_ENABLE_TIE_Pos          0                                                       /*!< ETH INTERRUPT_ENABLE: TIE Position      */
#define ETH_INTERRUPT_ENABLE_TIE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_TIE_Pos)                /*!< ETH INTERRUPT_ENABLE: TIE Mask          */
#define ETH_INTERRUPT_ENABLE_TSE_Pos          1                                                       /*!< ETH INTERRUPT_ENABLE: TSE Position      */
#define ETH_INTERRUPT_ENABLE_TSE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_TSE_Pos)                /*!< ETH INTERRUPT_ENABLE: TSE Mask          */
#define ETH_INTERRUPT_ENABLE_TUE_Pos          2                                                       /*!< ETH INTERRUPT_ENABLE: TUE Position      */
#define ETH_INTERRUPT_ENABLE_TUE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_TUE_Pos)                /*!< ETH INTERRUPT_ENABLE: TUE Mask          */
#define ETH_INTERRUPT_ENABLE_TJE_Pos          3                                                       /*!< ETH INTERRUPT_ENABLE: TJE Position      */
#define ETH_INTERRUPT_ENABLE_TJE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_TJE_Pos)                /*!< ETH INTERRUPT_ENABLE: TJE Mask          */
#define ETH_INTERRUPT_ENABLE_OVE_Pos          4                                                       /*!< ETH INTERRUPT_ENABLE: OVE Position      */
#define ETH_INTERRUPT_ENABLE_OVE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_OVE_Pos)                /*!< ETH INTERRUPT_ENABLE: OVE Mask          */
#define ETH_INTERRUPT_ENABLE_UNE_Pos          5                                                       /*!< ETH INTERRUPT_ENABLE: UNE Position      */
#define ETH_INTERRUPT_ENABLE_UNE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_UNE_Pos)                /*!< ETH INTERRUPT_ENABLE: UNE Mask          */
#define ETH_INTERRUPT_ENABLE_RIE_Pos          6                                                       /*!< ETH INTERRUPT_ENABLE: RIE Position      */
#define ETH_INTERRUPT_ENABLE_RIE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_RIE_Pos)                /*!< ETH INTERRUPT_ENABLE: RIE Mask          */
#define ETH_INTERRUPT_ENABLE_RUE_Pos          7                                                       /*!< ETH INTERRUPT_ENABLE: RUE Position      */
#define ETH_INTERRUPT_ENABLE_RUE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_RUE_Pos)                /*!< ETH INTERRUPT_ENABLE: RUE Mask          */
#define ETH_INTERRUPT_ENABLE_RSE_Pos          8                                                       /*!< ETH INTERRUPT_ENABLE: RSE Position      */
#define ETH_INTERRUPT_ENABLE_RSE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_RSE_Pos)                /*!< ETH INTERRUPT_ENABLE: RSE Mask          */
#define ETH_INTERRUPT_ENABLE_RWE_Pos          9                                                       /*!< ETH INTERRUPT_ENABLE: RWE Position      */
#define ETH_INTERRUPT_ENABLE_RWE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_RWE_Pos)                /*!< ETH INTERRUPT_ENABLE: RWE Mask          */
#define ETH_INTERRUPT_ENABLE_ETE_Pos          10                                                      /*!< ETH INTERRUPT_ENABLE: ETE Position      */
#define ETH_INTERRUPT_ENABLE_ETE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_ETE_Pos)                /*!< ETH INTERRUPT_ENABLE: ETE Mask          */
#define ETH_INTERRUPT_ENABLE_Reserved_12_11_Pos 11                                                    /*!< ETH INTERRUPT_ENABLE: Reserved_12_11 Position */
#define ETH_INTERRUPT_ENABLE_Reserved_12_11_Msk (0x03UL << ETH_INTERRUPT_ENABLE_Reserved_12_11_Pos)   /*!< ETH INTERRUPT_ENABLE: Reserved_12_11 Mask */
#define ETH_INTERRUPT_ENABLE_FBE_Pos          13                                                      /*!< ETH INTERRUPT_ENABLE: FBE Position      */
#define ETH_INTERRUPT_ENABLE_FBE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_FBE_Pos)                /*!< ETH INTERRUPT_ENABLE: FBE Mask          */
#define ETH_INTERRUPT_ENABLE_ERE_Pos          14                                                      /*!< ETH INTERRUPT_ENABLE: ERE Position      */
#define ETH_INTERRUPT_ENABLE_ERE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_ERE_Pos)                /*!< ETH INTERRUPT_ENABLE: ERE Mask          */
#define ETH_INTERRUPT_ENABLE_AIE_Pos          15                                                      /*!< ETH INTERRUPT_ENABLE: AIE Position      */
#define ETH_INTERRUPT_ENABLE_AIE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_AIE_Pos)                /*!< ETH INTERRUPT_ENABLE: AIE Mask          */
#define ETH_INTERRUPT_ENABLE_NIE_Pos          16                                                      /*!< ETH INTERRUPT_ENABLE: NIE Position      */
#define ETH_INTERRUPT_ENABLE_NIE_Msk          (0x01UL << ETH_INTERRUPT_ENABLE_NIE_Pos)                /*!< ETH INTERRUPT_ENABLE: NIE Mask          */
#define ETH_INTERRUPT_ENABLE_Reserved_31_17_Pos 17                                                    /*!< ETH INTERRUPT_ENABLE: Reserved_31_17 Position */
#define ETH_INTERRUPT_ENABLE_Reserved_31_17_Msk (0x00007fffUL << ETH_INTERRUPT_ENABLE_Reserved_31_17_Pos)/*!< ETH INTERRUPT_ENABLE: Reserved_31_17 Mask */

/* ----------------  ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER  ---------------- */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISFRMCNT_Pos 0                                  /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISFRMCNT Position */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISFRMCNT_Msk (0x0000ffffUL << ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISFRMCNT_Pos)/*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISFRMCNT Mask */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISCNTOVF_Pos 16                                 /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISCNTOVF Position */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISCNTOVF_Msk (0x01UL << ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISCNTOVF_Pos)/*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISCNTOVF Mask */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFFRMCNT_Pos 17                                 /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFFRMCNT Position */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFFRMCNT_Msk (0x000007ffUL << ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFFRMCNT_Pos)/*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFFRMCNT Mask */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFCNTOVF_Pos 28                                 /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFCNTOVF Position */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFCNTOVF_Msk (0x01UL << ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFCNTOVF_Pos)/*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFCNTOVF Mask */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_Reserved_31_29_Pos 29                            /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: Reserved_31_29
                                                         Position                                                                                  */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_Reserved_31_29_Msk (0x07UL << ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_Reserved_31_29_Pos)/*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: Reserved_31_29
                                                         Mask                                                                                      */

/* --------------------  ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER  -------------------- */
#define ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_RIWT_Pos 0                                               /*!< ETH RECEIVE_INTERRUPT_WATCHDOG_TIMER: RIWT Position */
#define ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_RIWT_Msk (0x000000ffUL << ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_RIWT_Pos)/*!< ETH RECEIVE_INTERRUPT_WATCHDOG_TIMER: RIWT Mask */
#define ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_Reserved_31_8_Pos 8                                      /*!< ETH RECEIVE_INTERRUPT_WATCHDOG_TIMER: Reserved_31_8 Position */
#define ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_Reserved_31_8_Msk (0x00ffffffUL << ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_Reserved_31_8_Pos)/*!< ETH RECEIVE_INTERRUPT_WATCHDOG_TIMER: Reserved_31_8 Mask */

/* -------------------------------  ETH_AHB_STATUS  ------------------------------- */
#define ETH_AHB_STATUS_AHBMS_Pos              0                                                       /*!< ETH AHB_STATUS: AHBMS Position          */
#define ETH_AHB_STATUS_AHBMS_Msk              (0x01UL << ETH_AHB_STATUS_AHBMS_Pos)                    /*!< ETH AHB_STATUS: AHBMS Mask              */
#define ETH_AHB_STATUS_Reserved_1_Pos         1                                                       /*!< ETH AHB_STATUS: Reserved_1 Position     */
#define ETH_AHB_STATUS_Reserved_1_Msk         (0x01UL << ETH_AHB_STATUS_Reserved_1_Pos)               /*!< ETH AHB_STATUS: Reserved_1 Mask         */
#define ETH_AHB_STATUS_Reserved_31_2_Pos      2                                                       /*!< ETH AHB_STATUS: Reserved_31_2 Position  */
#define ETH_AHB_STATUS_Reserved_31_2_Msk      (0x3fffffffUL << ETH_AHB_STATUS_Reserved_31_2_Pos)      /*!< ETH AHB_STATUS: Reserved_31_2 Mask      */

/* --------------------  ETH_CURRENT_HOST_TRANSMIT_DESCRIPTOR  -------------------- */
#define ETH_CURRENT_HOST_TRANSMIT_DESCRIPTOR_CURTDESAPTR_Pos 0                                        /*!< ETH CURRENT_HOST_TRANSMIT_DESCRIPTOR: CURTDESAPTR Position */
#define ETH_CURRENT_HOST_TRANSMIT_DESCRIPTOR_CURTDESAPTR_Msk (0xffffffffUL << ETH_CURRENT_HOST_TRANSMIT_DESCRIPTOR_CURTDESAPTR_Pos)/*!< ETH CURRENT_HOST_TRANSMIT_DESCRIPTOR: CURTDESAPTR Mask */

/* ---------------------  ETH_CURRENT_HOST_RECEIVE_DESCRIPTOR  -------------------- */
#define ETH_CURRENT_HOST_RECEIVE_DESCRIPTOR_CURRDESAPTR_Pos 0                                         /*!< ETH CURRENT_HOST_RECEIVE_DESCRIPTOR: CURRDESAPTR Position */
#define ETH_CURRENT_HOST_RECEIVE_DESCRIPTOR_CURRDESAPTR_Msk (0xffffffffUL << ETH_CURRENT_HOST_RECEIVE_DESCRIPTOR_CURRDESAPTR_Pos)/*!< ETH CURRENT_HOST_RECEIVE_DESCRIPTOR: CURRDESAPTR Mask */

/* ------------------  ETH_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS  ------------------ */
#define ETH_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS_CURTBUFAPTR_Pos 0                                    /*!< ETH CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS: CURTBUFAPTR Position */
#define ETH_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS_CURTBUFAPTR_Msk (0xffffffffUL << ETH_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS_CURTBUFAPTR_Pos)/*!< ETH CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS: CURTBUFAPTR Mask */

/* -------------------  ETH_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS  ------------------ */
#define ETH_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS_CURRBUFAPTR_Pos 0                                     /*!< ETH CURRENT_HOST_RECEIVE_BUFFER_ADDRESS: CURRBUFAPTR Position */
#define ETH_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS_CURRBUFAPTR_Msk (0xffffffffUL << ETH_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS_CURRBUFAPTR_Pos)/*!< ETH CURRENT_HOST_RECEIVE_BUFFER_ADDRESS: CURRBUFAPTR Mask */

/* -------------------------------  ETH_HW_FEATURE  ------------------------------- */
#define ETH_HW_FEATURE_MIISEL_Pos             0                                                       /*!< ETH HW_FEATURE: MIISEL Position         */
#define ETH_HW_FEATURE_MIISEL_Msk             (0x01UL << ETH_HW_FEATURE_MIISEL_Pos)                   /*!< ETH HW_FEATURE: MIISEL Mask             */
#define ETH_HW_FEATURE_GMIISEL_Pos            1                                                       /*!< ETH HW_FEATURE: GMIISEL Position        */
#define ETH_HW_FEATURE_GMIISEL_Msk            (0x01UL << ETH_HW_FEATURE_GMIISEL_Pos)                  /*!< ETH HW_FEATURE: GMIISEL Mask            */
#define ETH_HW_FEATURE_HDSEL_Pos              2                                                       /*!< ETH HW_FEATURE: HDSEL Position          */
#define ETH_HW_FEATURE_HDSEL_Msk              (0x01UL << ETH_HW_FEATURE_HDSEL_Pos)                    /*!< ETH HW_FEATURE: HDSEL Mask              */
#define ETH_HW_FEATURE_EXTHASHEN_Pos          3                                                       /*!< ETH HW_FEATURE: EXTHASHEN Position      */
#define ETH_HW_FEATURE_EXTHASHEN_Msk          (0x01UL << ETH_HW_FEATURE_EXTHASHEN_Pos)                /*!< ETH HW_FEATURE: EXTHASHEN Mask          */
#define ETH_HW_FEATURE_HASHSEL_Pos            4                                                       /*!< ETH HW_FEATURE: HASHSEL Position        */
#define ETH_HW_FEATURE_HASHSEL_Msk            (0x01UL << ETH_HW_FEATURE_HASHSEL_Pos)                  /*!< ETH HW_FEATURE: HASHSEL Mask            */
#define ETH_HW_FEATURE_ADDMACADRSEL_Pos       5                                                       /*!< ETH HW_FEATURE: ADDMACADRSEL Position   */
#define ETH_HW_FEATURE_ADDMACADRSEL_Msk       (0x01UL << ETH_HW_FEATURE_ADDMACADRSEL_Pos)             /*!< ETH HW_FEATURE: ADDMACADRSEL Mask       */
#define ETH_HW_FEATURE_PCSSEL_Pos             6                                                       /*!< ETH HW_FEATURE: PCSSEL Position         */
#define ETH_HW_FEATURE_PCSSEL_Msk             (0x01UL << ETH_HW_FEATURE_PCSSEL_Pos)                   /*!< ETH HW_FEATURE: PCSSEL Mask             */
#define ETH_HW_FEATURE_L3L4FLTREN_Pos         7                                                       /*!< ETH HW_FEATURE: L3L4FLTREN Position     */
#define ETH_HW_FEATURE_L3L4FLTREN_Msk         (0x01UL << ETH_HW_FEATURE_L3L4FLTREN_Pos)               /*!< ETH HW_FEATURE: L3L4FLTREN Mask         */
#define ETH_HW_FEATURE_SMASEL_Pos             8                                                       /*!< ETH HW_FEATURE: SMASEL Position         */
#define ETH_HW_FEATURE_SMASEL_Msk             (0x01UL << ETH_HW_FEATURE_SMASEL_Pos)                   /*!< ETH HW_FEATURE: SMASEL Mask             */
#define ETH_HW_FEATURE_RWKSEL_Pos             9                                                       /*!< ETH HW_FEATURE: RWKSEL Position         */
#define ETH_HW_FEATURE_RWKSEL_Msk             (0x01UL << ETH_HW_FEATURE_RWKSEL_Pos)                   /*!< ETH HW_FEATURE: RWKSEL Mask             */
#define ETH_HW_FEATURE_MGKSEL_Pos             10                                                      /*!< ETH HW_FEATURE: MGKSEL Position         */
#define ETH_HW_FEATURE_MGKSEL_Msk             (0x01UL << ETH_HW_FEATURE_MGKSEL_Pos)                   /*!< ETH HW_FEATURE: MGKSEL Mask             */
#define ETH_HW_FEATURE_MMCSEL_Pos             11                                                      /*!< ETH HW_FEATURE: MMCSEL Position         */
#define ETH_HW_FEATURE_MMCSEL_Msk             (0x01UL << ETH_HW_FEATURE_MMCSEL_Pos)                   /*!< ETH HW_FEATURE: MMCSEL Mask             */
#define ETH_HW_FEATURE_TSVER1SEL_Pos          12                                                      /*!< ETH HW_FEATURE: TSVER1SEL Position      */
#define ETH_HW_FEATURE_TSVER1SEL_Msk          (0x01UL << ETH_HW_FEATURE_TSVER1SEL_Pos)                /*!< ETH HW_FEATURE: TSVER1SEL Mask          */
#define ETH_HW_FEATURE_TSVER2SEL_Pos          13                                                      /*!< ETH HW_FEATURE: TSVER2SEL Position      */
#define ETH_HW_FEATURE_TSVER2SEL_Msk          (0x01UL << ETH_HW_FEATURE_TSVER2SEL_Pos)                /*!< ETH HW_FEATURE: TSVER2SEL Mask          */
#define ETH_HW_FEATURE_EEESEL_Pos             14                                                      /*!< ETH HW_FEATURE: EEESEL Position         */
#define ETH_HW_FEATURE_EEESEL_Msk             (0x01UL << ETH_HW_FEATURE_EEESEL_Pos)                   /*!< ETH HW_FEATURE: EEESEL Mask             */
#define ETH_HW_FEATURE_AVSEL_Pos              15                                                      /*!< ETH HW_FEATURE: AVSEL Position          */
#define ETH_HW_FEATURE_AVSEL_Msk              (0x01UL << ETH_HW_FEATURE_AVSEL_Pos)                    /*!< ETH HW_FEATURE: AVSEL Mask              */
#define ETH_HW_FEATURE_TXCOESEL_Pos           16                                                      /*!< ETH HW_FEATURE: TXCOESEL Position       */
#define ETH_HW_FEATURE_TXCOESEL_Msk           (0x01UL << ETH_HW_FEATURE_TXCOESEL_Pos)                 /*!< ETH HW_FEATURE: TXCOESEL Mask           */
#define ETH_HW_FEATURE_RXTYP1COE_Pos          17                                                      /*!< ETH HW_FEATURE: RXTYP1COE Position      */
#define ETH_HW_FEATURE_RXTYP1COE_Msk          (0x01UL << ETH_HW_FEATURE_RXTYP1COE_Pos)                /*!< ETH HW_FEATURE: RXTYP1COE Mask          */
#define ETH_HW_FEATURE_RXTYP2COE_Pos          18                                                      /*!< ETH HW_FEATURE: RXTYP2COE Position      */
#define ETH_HW_FEATURE_RXTYP2COE_Msk          (0x01UL << ETH_HW_FEATURE_RXTYP2COE_Pos)                /*!< ETH HW_FEATURE: RXTYP2COE Mask          */
#define ETH_HW_FEATURE_RXFIFOSIZE_Pos         19                                                      /*!< ETH HW_FEATURE: RXFIFOSIZE Position     */
#define ETH_HW_FEATURE_RXFIFOSIZE_Msk         (0x01UL << ETH_HW_FEATURE_RXFIFOSIZE_Pos)               /*!< ETH HW_FEATURE: RXFIFOSIZE Mask         */
#define ETH_HW_FEATURE_RXCHCNT_Pos            20                                                      /*!< ETH HW_FEATURE: RXCHCNT Position        */
#define ETH_HW_FEATURE_RXCHCNT_Msk            (0x03UL << ETH_HW_FEATURE_RXCHCNT_Pos)                  /*!< ETH HW_FEATURE: RXCHCNT Mask            */
#define ETH_HW_FEATURE_TXCHCNT_Pos            22                                                      /*!< ETH HW_FEATURE: TXCHCNT Position        */
#define ETH_HW_FEATURE_TXCHCNT_Msk            (0x03UL << ETH_HW_FEATURE_TXCHCNT_Pos)                  /*!< ETH HW_FEATURE: TXCHCNT Mask            */
#define ETH_HW_FEATURE_ENHDESSEL_Pos          24                                                      /*!< ETH HW_FEATURE: ENHDESSEL Position      */
#define ETH_HW_FEATURE_ENHDESSEL_Msk          (0x01UL << ETH_HW_FEATURE_ENHDESSEL_Pos)                /*!< ETH HW_FEATURE: ENHDESSEL Mask          */
#define ETH_HW_FEATURE_INTTSEN_Pos            25                                                      /*!< ETH HW_FEATURE: INTTSEN Position        */
#define ETH_HW_FEATURE_INTTSEN_Msk            (0x01UL << ETH_HW_FEATURE_INTTSEN_Pos)                  /*!< ETH HW_FEATURE: INTTSEN Mask            */
#define ETH_HW_FEATURE_FLEXIPPSEN_Pos         26                                                      /*!< ETH HW_FEATURE: FLEXIPPSEN Position     */
#define ETH_HW_FEATURE_FLEXIPPSEN_Msk         (0x01UL << ETH_HW_FEATURE_FLEXIPPSEN_Pos)               /*!< ETH HW_FEATURE: FLEXIPPSEN Mask         */
#define ETH_HW_FEATURE_SAVLANINS_Pos          27                                                      /*!< ETH HW_FEATURE: SAVLANINS Position      */
#define ETH_HW_FEATURE_SAVLANINS_Msk          (0x01UL << ETH_HW_FEATURE_SAVLANINS_Pos)                /*!< ETH HW_FEATURE: SAVLANINS Mask          */
#define ETH_HW_FEATURE_ACTPHYIF_Pos           28                                                      /*!< ETH HW_FEATURE: ACTPHYIF Position       */
#define ETH_HW_FEATURE_ACTPHYIF_Msk           (0x07UL << ETH_HW_FEATURE_ACTPHYIF_Pos)                 /*!< ETH HW_FEATURE: ACTPHYIF Mask           */
#define ETH_HW_FEATURE_Reserved_31_Pos        31                                                      /*!< ETH HW_FEATURE: Reserved_31 Position    */
#define ETH_HW_FEATURE_Reserved_31_Msk        (0x01UL << ETH_HW_FEATURE_Reserved_31_Pos)              /*!< ETH HW_FEATURE: Reserved_31 Mask        */


/* ================================================================================ */
/* ================           Group 'USB' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  USB_GOTGCTL  -------------------------------- */
#define USB_GOTGCTL_SesReqScs_Pos             0                                                       /*!< USB GOTGCTL: SesReqScs Position         */
#define USB_GOTGCTL_SesReqScs_Msk             (0x01UL << USB_GOTGCTL_SesReqScs_Pos)                   /*!< USB GOTGCTL: SesReqScs Mask             */
#define USB_GOTGCTL_SesReq_Pos                1                                                       /*!< USB GOTGCTL: SesReq Position            */
#define USB_GOTGCTL_SesReq_Msk                (0x01UL << USB_GOTGCTL_SesReq_Pos)                      /*!< USB GOTGCTL: SesReq Mask                */
#define USB_GOTGCTL_VbvalidOvEn_Pos           2                                                       /*!< USB GOTGCTL: VbvalidOvEn Position       */
#define USB_GOTGCTL_VbvalidOvEn_Msk           (0x01UL << USB_GOTGCTL_VbvalidOvEn_Pos)                 /*!< USB GOTGCTL: VbvalidOvEn Mask           */
#define USB_GOTGCTL_VbvalidOvVal_Pos          3                                                       /*!< USB GOTGCTL: VbvalidOvVal Position      */
#define USB_GOTGCTL_VbvalidOvVal_Msk          (0x01UL << USB_GOTGCTL_VbvalidOvVal_Pos)                /*!< USB GOTGCTL: VbvalidOvVal Mask          */
#define USB_GOTGCTL_AvalidOvEn_Pos            4                                                       /*!< USB GOTGCTL: AvalidOvEn Position        */
#define USB_GOTGCTL_AvalidOvEn_Msk            (0x01UL << USB_GOTGCTL_AvalidOvEn_Pos)                  /*!< USB GOTGCTL: AvalidOvEn Mask            */
#define USB_GOTGCTL_AvalidOvVal_Pos           5                                                       /*!< USB GOTGCTL: AvalidOvVal Position       */
#define USB_GOTGCTL_AvalidOvVal_Msk           (0x01UL << USB_GOTGCTL_AvalidOvVal_Pos)                 /*!< USB GOTGCTL: AvalidOvVal Mask           */
#define USB_GOTGCTL_BvalidOvEn_Pos            6                                                       /*!< USB GOTGCTL: BvalidOvEn Position        */
#define USB_GOTGCTL_BvalidOvEn_Msk            (0x01UL << USB_GOTGCTL_BvalidOvEn_Pos)                  /*!< USB GOTGCTL: BvalidOvEn Mask            */
#define USB_GOTGCTL_BvalidOvVal_Pos           7                                                       /*!< USB GOTGCTL: BvalidOvVal Position       */
#define USB_GOTGCTL_BvalidOvVal_Msk           (0x01UL << USB_GOTGCTL_BvalidOvVal_Pos)                 /*!< USB GOTGCTL: BvalidOvVal Mask           */
#define USB_GOTGCTL_HstNegScs_Pos             8                                                       /*!< USB GOTGCTL: HstNegScs Position         */
#define USB_GOTGCTL_HstNegScs_Msk             (0x01UL << USB_GOTGCTL_HstNegScs_Pos)                   /*!< USB GOTGCTL: HstNegScs Mask             */
#define USB_GOTGCTL_HNPReq_Pos                9                                                       /*!< USB GOTGCTL: HNPReq Position            */
#define USB_GOTGCTL_HNPReq_Msk                (0x01UL << USB_GOTGCTL_HNPReq_Pos)                      /*!< USB GOTGCTL: HNPReq Mask                */
#define USB_GOTGCTL_HstSetHNPEn_Pos           10                                                      /*!< USB GOTGCTL: HstSetHNPEn Position       */
#define USB_GOTGCTL_HstSetHNPEn_Msk           (0x01UL << USB_GOTGCTL_HstSetHNPEn_Pos)                 /*!< USB GOTGCTL: HstSetHNPEn Mask           */
#define USB_GOTGCTL_DevHNPEn_Pos              11                                                      /*!< USB GOTGCTL: DevHNPEn Position          */
#define USB_GOTGCTL_DevHNPEn_Msk              (0x01UL << USB_GOTGCTL_DevHNPEn_Pos)                    /*!< USB GOTGCTL: DevHNPEn Mask              */
#define USB_GOTGCTL_ConlDSts_Pos              16                                                      /*!< USB GOTGCTL: ConlDSts Position          */
#define USB_GOTGCTL_ConlDSts_Msk              (0x01UL << USB_GOTGCTL_ConlDSts_Pos)                    /*!< USB GOTGCTL: ConlDSts Mask              */
#define USB_GOTGCTL_DbncTime_Pos              17                                                      /*!< USB GOTGCTL: DbncTime Position          */
#define USB_GOTGCTL_DbncTime_Msk              (0x01UL << USB_GOTGCTL_DbncTime_Pos)                    /*!< USB GOTGCTL: DbncTime Mask              */
#define USB_GOTGCTL_ASesVId_Pos               18                                                      /*!< USB GOTGCTL: ASesVId Position           */
#define USB_GOTGCTL_ASesVId_Msk               (0x01UL << USB_GOTGCTL_ASesVId_Pos)                     /*!< USB GOTGCTL: ASesVId Mask               */
#define USB_GOTGCTL_BSesVld_Pos               19                                                      /*!< USB GOTGCTL: BSesVld Position           */
#define USB_GOTGCTL_BSesVld_Msk               (0x01UL << USB_GOTGCTL_BSesVld_Pos)                     /*!< USB GOTGCTL: BSesVld Mask               */
#define USB_GOTGCTL_OTGVer_Pos                20                                                      /*!< USB GOTGCTL: OTGVer Position            */
#define USB_GOTGCTL_OTGVer_Msk                (0x01UL << USB_GOTGCTL_OTGVer_Pos)                      /*!< USB GOTGCTL: OTGVer Mask                */

/* ---------------------------------  USB_GOTGINT  -------------------------------- */
#define USB_GOTGINT_SesEndDet_Pos             2                                                       /*!< USB GOTGINT: SesEndDet Position         */
#define USB_GOTGINT_SesEndDet_Msk             (0x01UL << USB_GOTGINT_SesEndDet_Pos)                   /*!< USB GOTGINT: SesEndDet Mask             */
#define USB_GOTGINT_SesReqSucStsChng_Pos      8                                                       /*!< USB GOTGINT: SesReqSucStsChng Position  */
#define USB_GOTGINT_SesReqSucStsChng_Msk      (0x01UL << USB_GOTGINT_SesReqSucStsChng_Pos)            /*!< USB GOTGINT: SesReqSucStsChng Mask      */
#define USB_GOTGINT_HstNegSucStsChng_Pos      9                                                       /*!< USB GOTGINT: HstNegSucStsChng Position  */
#define USB_GOTGINT_HstNegSucStsChng_Msk      (0x01UL << USB_GOTGINT_HstNegSucStsChng_Pos)            /*!< USB GOTGINT: HstNegSucStsChng Mask      */
#define USB_GOTGINT_HstNegDet_Pos             17                                                      /*!< USB GOTGINT: HstNegDet Position         */
#define USB_GOTGINT_HstNegDet_Msk             (0x01UL << USB_GOTGINT_HstNegDet_Pos)                   /*!< USB GOTGINT: HstNegDet Mask             */
#define USB_GOTGINT_ADevTOUTChg_Pos           18                                                      /*!< USB GOTGINT: ADevTOUTChg Position       */
#define USB_GOTGINT_ADevTOUTChg_Msk           (0x01UL << USB_GOTGINT_ADevTOUTChg_Pos)                 /*!< USB GOTGINT: ADevTOUTChg Mask           */
#define USB_GOTGINT_DbnceDone_Pos             19                                                      /*!< USB GOTGINT: DbnceDone Position         */
#define USB_GOTGINT_DbnceDone_Msk             (0x01UL << USB_GOTGINT_DbnceDone_Pos)                   /*!< USB GOTGINT: DbnceDone Mask             */

/* ---------------------------------  USB_GAHBCFG  -------------------------------- */
#define USB_GAHBCFG_GlblIntrMsk_Pos           0                                                       /*!< USB GAHBCFG: GlblIntrMsk Position       */
#define USB_GAHBCFG_GlblIntrMsk_Msk           (0x01UL << USB_GAHBCFG_GlblIntrMsk_Pos)                 /*!< USB GAHBCFG: GlblIntrMsk Mask           */
#define USB_GAHBCFG_HBstLen_Pos               1                                                       /*!< USB GAHBCFG: HBstLen Position           */
#define USB_GAHBCFG_HBstLen_Msk               (0x0fUL << USB_GAHBCFG_HBstLen_Pos)                     /*!< USB GAHBCFG: HBstLen Mask               */
#define USB_GAHBCFG_DMAEn_Pos                 5                                                       /*!< USB GAHBCFG: DMAEn Position             */
#define USB_GAHBCFG_DMAEn_Msk                 (0x01UL << USB_GAHBCFG_DMAEn_Pos)                       /*!< USB GAHBCFG: DMAEn Mask                 */
#define USB_GAHBCFG_NPTxFEmpLvl_Pos           7                                                       /*!< USB GAHBCFG: NPTxFEmpLvl Position       */
#define USB_GAHBCFG_NPTxFEmpLvl_Msk           (0x01UL << USB_GAHBCFG_NPTxFEmpLvl_Pos)                 /*!< USB GAHBCFG: NPTxFEmpLvl Mask           */
#define USB_GAHBCFG_PTxFEmpLvl_Pos            8                                                       /*!< USB GAHBCFG: PTxFEmpLvl Position        */
#define USB_GAHBCFG_PTxFEmpLvl_Msk            (0x01UL << USB_GAHBCFG_PTxFEmpLvl_Pos)                  /*!< USB GAHBCFG: PTxFEmpLvl Mask            */
#define USB_GAHBCFG_AHBSingle_Pos             23                                                      /*!< USB GAHBCFG: AHBSingle Position         */
#define USB_GAHBCFG_AHBSingle_Msk             (0x01UL << USB_GAHBCFG_AHBSingle_Pos)                   /*!< USB GAHBCFG: AHBSingle Mask             */

/* ---------------------------------  USB_GUSBCFG  -------------------------------- */
#define USB_GUSBCFG_TOutCal_Pos               0                                                       /*!< USB GUSBCFG: TOutCal Position           */
#define USB_GUSBCFG_TOutCal_Msk               (0x07UL << USB_GUSBCFG_TOutCal_Pos)                     /*!< USB GUSBCFG: TOutCal Mask               */
#define USB_GUSBCFG_PHYSel_Pos                6                                                       /*!< USB GUSBCFG: PHYSel Position            */
#define USB_GUSBCFG_PHYSel_Msk                (0x01UL << USB_GUSBCFG_PHYSel_Pos)                      /*!< USB GUSBCFG: PHYSel Mask                */
#define USB_GUSBCFG_SRPCap_Pos                8                                                       /*!< USB GUSBCFG: SRPCap Position            */
#define USB_GUSBCFG_SRPCap_Msk                (0x01UL << USB_GUSBCFG_SRPCap_Pos)                      /*!< USB GUSBCFG: SRPCap Mask                */
#define USB_GUSBCFG_HNPCap_Pos                9                                                       /*!< USB GUSBCFG: HNPCap Position            */
#define USB_GUSBCFG_HNPCap_Msk                (0x01UL << USB_GUSBCFG_HNPCap_Pos)                      /*!< USB GUSBCFG: HNPCap Mask                */
#define USB_GUSBCFG_USBTrdTim_Pos             10                                                      /*!< USB GUSBCFG: USBTrdTim Position         */
#define USB_GUSBCFG_USBTrdTim_Msk             (0x0fUL << USB_GUSBCFG_USBTrdTim_Pos)                   /*!< USB GUSBCFG: USBTrdTim Mask             */
#define USB_GUSBCFG_OtgI2CSel_Pos             16                                                      /*!< USB GUSBCFG: OtgI2CSel Position         */
#define USB_GUSBCFG_OtgI2CSel_Msk             (0x01UL << USB_GUSBCFG_OtgI2CSel_Pos)                   /*!< USB GUSBCFG: OtgI2CSel Mask             */
#define USB_GUSBCFG_TxEndDelay_Pos            28                                                      /*!< USB GUSBCFG: TxEndDelay Position        */
#define USB_GUSBCFG_TxEndDelay_Msk            (0x01UL << USB_GUSBCFG_TxEndDelay_Pos)                  /*!< USB GUSBCFG: TxEndDelay Mask            */
#define USB_GUSBCFG_ForceHstMode_Pos          29                                                      /*!< USB GUSBCFG: ForceHstMode Position      */
#define USB_GUSBCFG_ForceHstMode_Msk          (0x01UL << USB_GUSBCFG_ForceHstMode_Pos)                /*!< USB GUSBCFG: ForceHstMode Mask          */
#define USB_GUSBCFG_ForceDevMode_Pos          30                                                      /*!< USB GUSBCFG: ForceDevMode Position      */
#define USB_GUSBCFG_ForceDevMode_Msk          (0x01UL << USB_GUSBCFG_ForceDevMode_Pos)                /*!< USB GUSBCFG: ForceDevMode Mask          */
#define USB_GUSBCFG_CTP_Pos                   31                                                      /*!< USB GUSBCFG: CTP Position               */
#define USB_GUSBCFG_CTP_Msk                   (0x01UL << USB_GUSBCFG_CTP_Pos)                         /*!< USB GUSBCFG: CTP Mask                   */

/* ---------------------------------  USB_GRSTCTL  -------------------------------- */
#define USB_GRSTCTL_CSftRst_Pos               0                                                       /*!< USB GRSTCTL: CSftRst Position           */
#define USB_GRSTCTL_CSftRst_Msk               (0x01UL << USB_GRSTCTL_CSftRst_Pos)                     /*!< USB GRSTCTL: CSftRst Mask               */
#define USB_GRSTCTL_FrmCntrRst_Pos            2                                                       /*!< USB GRSTCTL: FrmCntrRst Position        */
#define USB_GRSTCTL_FrmCntrRst_Msk            (0x01UL << USB_GRSTCTL_FrmCntrRst_Pos)                  /*!< USB GRSTCTL: FrmCntrRst Mask            */
#define USB_GRSTCTL_RxFFlsh_Pos               4                                                       /*!< USB GRSTCTL: RxFFlsh Position           */
#define USB_GRSTCTL_RxFFlsh_Msk               (0x01UL << USB_GRSTCTL_RxFFlsh_Pos)                     /*!< USB GRSTCTL: RxFFlsh Mask               */
#define USB_GRSTCTL_TxFFlsh_Pos               5                                                       /*!< USB GRSTCTL: TxFFlsh Position           */
#define USB_GRSTCTL_TxFFlsh_Msk               (0x01UL << USB_GRSTCTL_TxFFlsh_Pos)                     /*!< USB GRSTCTL: TxFFlsh Mask               */
#define USB_GRSTCTL_TxFNum_Pos                6                                                       /*!< USB GRSTCTL: TxFNum Position            */
#define USB_GRSTCTL_TxFNum_Msk                (0x1fUL << USB_GRSTCTL_TxFNum_Pos)                      /*!< USB GRSTCTL: TxFNum Mask                */
#define USB_GRSTCTL_DMAReq_Pos                30                                                      /*!< USB GRSTCTL: DMAReq Position            */
#define USB_GRSTCTL_DMAReq_Msk                (0x01UL << USB_GRSTCTL_DMAReq_Pos)                      /*!< USB GRSTCTL: DMAReq Mask                */
#define USB_GRSTCTL_AHBIdle_Pos               31                                                      /*!< USB GRSTCTL: AHBIdle Position           */
#define USB_GRSTCTL_AHBIdle_Msk               (0x01UL << USB_GRSTCTL_AHBIdle_Pos)                     /*!< USB GRSTCTL: AHBIdle Mask               */

/* ----------------------------  USB_GINTSTS_HOSTMODE  ---------------------------- */
#define USB_GINTSTS_HOSTMODE_CurMod_Pos       0                                                       /*!< USB GINTSTS_HOSTMODE: CurMod Position   */
#define USB_GINTSTS_HOSTMODE_CurMod_Msk       (0x01UL << USB_GINTSTS_HOSTMODE_CurMod_Pos)             /*!< USB GINTSTS_HOSTMODE: CurMod Mask       */
#define USB_GINTSTS_HOSTMODE_ModeMis_Pos      1                                                       /*!< USB GINTSTS_HOSTMODE: ModeMis Position  */
#define USB_GINTSTS_HOSTMODE_ModeMis_Msk      (0x01UL << USB_GINTSTS_HOSTMODE_ModeMis_Pos)            /*!< USB GINTSTS_HOSTMODE: ModeMis Mask      */
#define USB_GINTSTS_HOSTMODE_OTGInt_Pos       2                                                       /*!< USB GINTSTS_HOSTMODE: OTGInt Position   */
#define USB_GINTSTS_HOSTMODE_OTGInt_Msk       (0x01UL << USB_GINTSTS_HOSTMODE_OTGInt_Pos)             /*!< USB GINTSTS_HOSTMODE: OTGInt Mask       */
#define USB_GINTSTS_HOSTMODE_Sof_Pos          3                                                       /*!< USB GINTSTS_HOSTMODE: Sof Position      */
#define USB_GINTSTS_HOSTMODE_Sof_Msk          (0x01UL << USB_GINTSTS_HOSTMODE_Sof_Pos)                /*!< USB GINTSTS_HOSTMODE: Sof Mask          */
#define USB_GINTSTS_HOSTMODE_RxFLvl_Pos       4                                                       /*!< USB GINTSTS_HOSTMODE: RxFLvl Position   */
#define USB_GINTSTS_HOSTMODE_RxFLvl_Msk       (0x01UL << USB_GINTSTS_HOSTMODE_RxFLvl_Pos)             /*!< USB GINTSTS_HOSTMODE: RxFLvl Mask       */
#define USB_GINTSTS_HOSTMODE_incomplP_Pos     21                                                      /*!< USB GINTSTS_HOSTMODE: incomplP Position */
#define USB_GINTSTS_HOSTMODE_incomplP_Msk     (0x01UL << USB_GINTSTS_HOSTMODE_incomplP_Pos)           /*!< USB GINTSTS_HOSTMODE: incomplP Mask     */
#define USB_GINTSTS_HOSTMODE_PrtInt_Pos       24                                                      /*!< USB GINTSTS_HOSTMODE: PrtInt Position   */
#define USB_GINTSTS_HOSTMODE_PrtInt_Msk       (0x01UL << USB_GINTSTS_HOSTMODE_PrtInt_Pos)             /*!< USB GINTSTS_HOSTMODE: PrtInt Mask       */
#define USB_GINTSTS_HOSTMODE_HChInt_Pos       25                                                      /*!< USB GINTSTS_HOSTMODE: HChInt Position   */
#define USB_GINTSTS_HOSTMODE_HChInt_Msk       (0x01UL << USB_GINTSTS_HOSTMODE_HChInt_Pos)             /*!< USB GINTSTS_HOSTMODE: HChInt Mask       */
#define USB_GINTSTS_HOSTMODE_PTxFEmp_Pos      26                                                      /*!< USB GINTSTS_HOSTMODE: PTxFEmp Position  */
#define USB_GINTSTS_HOSTMODE_PTxFEmp_Msk      (0x01UL << USB_GINTSTS_HOSTMODE_PTxFEmp_Pos)            /*!< USB GINTSTS_HOSTMODE: PTxFEmp Mask      */
#define USB_GINTSTS_HOSTMODE_ConIDStsChng_Pos 28                                                      /*!< USB GINTSTS_HOSTMODE: ConIDStsChng Position */
#define USB_GINTSTS_HOSTMODE_ConIDStsChng_Msk (0x01UL << USB_GINTSTS_HOSTMODE_ConIDStsChng_Pos)       /*!< USB GINTSTS_HOSTMODE: ConIDStsChng Mask */
#define USB_GINTSTS_HOSTMODE_DisconnInt_Pos   29                                                      /*!< USB GINTSTS_HOSTMODE: DisconnInt Position */
#define USB_GINTSTS_HOSTMODE_DisconnInt_Msk   (0x01UL << USB_GINTSTS_HOSTMODE_DisconnInt_Pos)         /*!< USB GINTSTS_HOSTMODE: DisconnInt Mask   */
#define USB_GINTSTS_HOSTMODE_SessReqInt_Pos   30                                                      /*!< USB GINTSTS_HOSTMODE: SessReqInt Position */
#define USB_GINTSTS_HOSTMODE_SessReqInt_Msk   (0x01UL << USB_GINTSTS_HOSTMODE_SessReqInt_Pos)         /*!< USB GINTSTS_HOSTMODE: SessReqInt Mask   */
#define USB_GINTSTS_HOSTMODE_WkUpInt_Pos      31                                                      /*!< USB GINTSTS_HOSTMODE: WkUpInt Position  */
#define USB_GINTSTS_HOSTMODE_WkUpInt_Msk      (0x01UL << USB_GINTSTS_HOSTMODE_WkUpInt_Pos)            /*!< USB GINTSTS_HOSTMODE: WkUpInt Mask      */

/* ---------------------------  USB_GINTSTS_DEVICEMODE  --------------------------- */
#define USB_GINTSTS_DEVICEMODE_CurMod_Pos     0                                                       /*!< USB GINTSTS_DEVICEMODE: CurMod Position */
#define USB_GINTSTS_DEVICEMODE_CurMod_Msk     (0x01UL << USB_GINTSTS_DEVICEMODE_CurMod_Pos)           /*!< USB GINTSTS_DEVICEMODE: CurMod Mask     */
#define USB_GINTSTS_DEVICEMODE_ModeMis_Pos    1                                                       /*!< USB GINTSTS_DEVICEMODE: ModeMis Position */
#define USB_GINTSTS_DEVICEMODE_ModeMis_Msk    (0x01UL << USB_GINTSTS_DEVICEMODE_ModeMis_Pos)          /*!< USB GINTSTS_DEVICEMODE: ModeMis Mask    */
#define USB_GINTSTS_DEVICEMODE_OTGInt_Pos     2                                                       /*!< USB GINTSTS_DEVICEMODE: OTGInt Position */
#define USB_GINTSTS_DEVICEMODE_OTGInt_Msk     (0x01UL << USB_GINTSTS_DEVICEMODE_OTGInt_Pos)           /*!< USB GINTSTS_DEVICEMODE: OTGInt Mask     */
#define USB_GINTSTS_DEVICEMODE_Sof_Pos        3                                                       /*!< USB GINTSTS_DEVICEMODE: Sof Position    */
#define USB_GINTSTS_DEVICEMODE_Sof_Msk        (0x01UL << USB_GINTSTS_DEVICEMODE_Sof_Pos)              /*!< USB GINTSTS_DEVICEMODE: Sof Mask        */
#define USB_GINTSTS_DEVICEMODE_RxFLvl_Pos     4                                                       /*!< USB GINTSTS_DEVICEMODE: RxFLvl Position */
#define USB_GINTSTS_DEVICEMODE_RxFLvl_Msk     (0x01UL << USB_GINTSTS_DEVICEMODE_RxFLvl_Pos)           /*!< USB GINTSTS_DEVICEMODE: RxFLvl Mask     */
#define USB_GINTSTS_DEVICEMODE_GINNakEff_Pos  6                                                       /*!< USB GINTSTS_DEVICEMODE: GINNakEff Position */
#define USB_GINTSTS_DEVICEMODE_GINNakEff_Msk  (0x01UL << USB_GINTSTS_DEVICEMODE_GINNakEff_Pos)        /*!< USB GINTSTS_DEVICEMODE: GINNakEff Mask  */
#define USB_GINTSTS_DEVICEMODE_GOUTNakEff_Pos 7                                                       /*!< USB GINTSTS_DEVICEMODE: GOUTNakEff Position */
#define USB_GINTSTS_DEVICEMODE_GOUTNakEff_Msk (0x01UL << USB_GINTSTS_DEVICEMODE_GOUTNakEff_Pos)       /*!< USB GINTSTS_DEVICEMODE: GOUTNakEff Mask */
#define USB_GINTSTS_DEVICEMODE_ErlySusp_Pos   10                                                      /*!< USB GINTSTS_DEVICEMODE: ErlySusp Position */
#define USB_GINTSTS_DEVICEMODE_ErlySusp_Msk   (0x01UL << USB_GINTSTS_DEVICEMODE_ErlySusp_Pos)         /*!< USB GINTSTS_DEVICEMODE: ErlySusp Mask   */
#define USB_GINTSTS_DEVICEMODE_USBSusp_Pos    11                                                      /*!< USB GINTSTS_DEVICEMODE: USBSusp Position */
#define USB_GINTSTS_DEVICEMODE_USBSusp_Msk    (0x01UL << USB_GINTSTS_DEVICEMODE_USBSusp_Pos)          /*!< USB GINTSTS_DEVICEMODE: USBSusp Mask    */
#define USB_GINTSTS_DEVICEMODE_USBRst_Pos     12                                                      /*!< USB GINTSTS_DEVICEMODE: USBRst Position */
#define USB_GINTSTS_DEVICEMODE_USBRst_Msk     (0x01UL << USB_GINTSTS_DEVICEMODE_USBRst_Pos)           /*!< USB GINTSTS_DEVICEMODE: USBRst Mask     */
#define USB_GINTSTS_DEVICEMODE_EnumDone_Pos   13                                                      /*!< USB GINTSTS_DEVICEMODE: EnumDone Position */
#define USB_GINTSTS_DEVICEMODE_EnumDone_Msk   (0x01UL << USB_GINTSTS_DEVICEMODE_EnumDone_Pos)         /*!< USB GINTSTS_DEVICEMODE: EnumDone Mask   */
#define USB_GINTSTS_DEVICEMODE_ISOOutDrop_Pos 14                                                      /*!< USB GINTSTS_DEVICEMODE: ISOOutDrop Position */
#define USB_GINTSTS_DEVICEMODE_ISOOutDrop_Msk (0x01UL << USB_GINTSTS_DEVICEMODE_ISOOutDrop_Pos)       /*!< USB GINTSTS_DEVICEMODE: ISOOutDrop Mask */
#define USB_GINTSTS_DEVICEMODE_EOPF_Pos       15                                                      /*!< USB GINTSTS_DEVICEMODE: EOPF Position   */
#define USB_GINTSTS_DEVICEMODE_EOPF_Msk       (0x01UL << USB_GINTSTS_DEVICEMODE_EOPF_Pos)             /*!< USB GINTSTS_DEVICEMODE: EOPF Mask       */
#define USB_GINTSTS_DEVICEMODE_IEPInt_Pos     18                                                      /*!< USB GINTSTS_DEVICEMODE: IEPInt Position */
#define USB_GINTSTS_DEVICEMODE_IEPInt_Msk     (0x01UL << USB_GINTSTS_DEVICEMODE_IEPInt_Pos)           /*!< USB GINTSTS_DEVICEMODE: IEPInt Mask     */
#define USB_GINTSTS_DEVICEMODE_OEPInt_Pos     19                                                      /*!< USB GINTSTS_DEVICEMODE: OEPInt Position */
#define USB_GINTSTS_DEVICEMODE_OEPInt_Msk     (0x01UL << USB_GINTSTS_DEVICEMODE_OEPInt_Pos)           /*!< USB GINTSTS_DEVICEMODE: OEPInt Mask     */
#define USB_GINTSTS_DEVICEMODE_incompISOIN_Pos 20                                                     /*!< USB GINTSTS_DEVICEMODE: incompISOIN Position */
#define USB_GINTSTS_DEVICEMODE_incompISOIN_Msk (0x01UL << USB_GINTSTS_DEVICEMODE_incompISOIN_Pos)     /*!< USB GINTSTS_DEVICEMODE: incompISOIN Mask */
#define USB_GINTSTS_DEVICEMODE_incomplSOOUT_Pos 21                                                    /*!< USB GINTSTS_DEVICEMODE: incomplSOOUT Position */
#define USB_GINTSTS_DEVICEMODE_incomplSOOUT_Msk (0x01UL << USB_GINTSTS_DEVICEMODE_incomplSOOUT_Pos)   /*!< USB GINTSTS_DEVICEMODE: incomplSOOUT Mask */
#define USB_GINTSTS_DEVICEMODE_ConIDStsChng_Pos 28                                                    /*!< USB GINTSTS_DEVICEMODE: ConIDStsChng Position */
#define USB_GINTSTS_DEVICEMODE_ConIDStsChng_Msk (0x01UL << USB_GINTSTS_DEVICEMODE_ConIDStsChng_Pos)   /*!< USB GINTSTS_DEVICEMODE: ConIDStsChng Mask */
#define USB_GINTSTS_DEVICEMODE_SessReqInt_Pos 30                                                      /*!< USB GINTSTS_DEVICEMODE: SessReqInt Position */
#define USB_GINTSTS_DEVICEMODE_SessReqInt_Msk (0x01UL << USB_GINTSTS_DEVICEMODE_SessReqInt_Pos)       /*!< USB GINTSTS_DEVICEMODE: SessReqInt Mask */
#define USB_GINTSTS_DEVICEMODE_WkUpInt_Pos    31                                                      /*!< USB GINTSTS_DEVICEMODE: WkUpInt Position */
#define USB_GINTSTS_DEVICEMODE_WkUpInt_Msk    (0x01UL << USB_GINTSTS_DEVICEMODE_WkUpInt_Pos)          /*!< USB GINTSTS_DEVICEMODE: WkUpInt Mask    */

/* ----------------------------  USB_GINTMSK_HOSTMODE  ---------------------------- */
#define USB_GINTMSK_HOSTMODE_ModeMisMsk_Pos   1                                                       /*!< USB GINTMSK_HOSTMODE: ModeMisMsk Position */
#define USB_GINTMSK_HOSTMODE_ModeMisMsk_Msk   (0x01UL << USB_GINTMSK_HOSTMODE_ModeMisMsk_Pos)         /*!< USB GINTMSK_HOSTMODE: ModeMisMsk Mask   */
#define USB_GINTMSK_HOSTMODE_OTGIntMsk_Pos    2                                                       /*!< USB GINTMSK_HOSTMODE: OTGIntMsk Position */
#define USB_GINTMSK_HOSTMODE_OTGIntMsk_Msk    (0x01UL << USB_GINTMSK_HOSTMODE_OTGIntMsk_Pos)          /*!< USB GINTMSK_HOSTMODE: OTGIntMsk Mask    */
#define USB_GINTMSK_HOSTMODE_SofMsk_Pos       3                                                       /*!< USB GINTMSK_HOSTMODE: SofMsk Position   */
#define USB_GINTMSK_HOSTMODE_SofMsk_Msk       (0x01UL << USB_GINTMSK_HOSTMODE_SofMsk_Pos)             /*!< USB GINTMSK_HOSTMODE: SofMsk Mask       */
#define USB_GINTMSK_HOSTMODE_RxFLvlMsk_Pos    4                                                       /*!< USB GINTMSK_HOSTMODE: RxFLvlMsk Position */
#define USB_GINTMSK_HOSTMODE_RxFLvlMsk_Msk    (0x01UL << USB_GINTMSK_HOSTMODE_RxFLvlMsk_Pos)          /*!< USB GINTMSK_HOSTMODE: RxFLvlMsk Mask    */
#define USB_GINTMSK_HOSTMODE_incomplPMsk_Pos  21                                                      /*!< USB GINTMSK_HOSTMODE: incomplPMsk Position */
#define USB_GINTMSK_HOSTMODE_incomplPMsk_Msk  (0x01UL << USB_GINTMSK_HOSTMODE_incomplPMsk_Pos)        /*!< USB GINTMSK_HOSTMODE: incomplPMsk Mask  */
#define USB_GINTMSK_HOSTMODE_PrtIntMsk_Pos    24                                                      /*!< USB GINTMSK_HOSTMODE: PrtIntMsk Position */
#define USB_GINTMSK_HOSTMODE_PrtIntMsk_Msk    (0x01UL << USB_GINTMSK_HOSTMODE_PrtIntMsk_Pos)          /*!< USB GINTMSK_HOSTMODE: PrtIntMsk Mask    */
#define USB_GINTMSK_HOSTMODE_HChIntMsk_Pos    25                                                      /*!< USB GINTMSK_HOSTMODE: HChIntMsk Position */
#define USB_GINTMSK_HOSTMODE_HChIntMsk_Msk    (0x01UL << USB_GINTMSK_HOSTMODE_HChIntMsk_Pos)          /*!< USB GINTMSK_HOSTMODE: HChIntMsk Mask    */
#define USB_GINTMSK_HOSTMODE_PTxFEmpMsk_Pos   26                                                      /*!< USB GINTMSK_HOSTMODE: PTxFEmpMsk Position */
#define USB_GINTMSK_HOSTMODE_PTxFEmpMsk_Msk   (0x01UL << USB_GINTMSK_HOSTMODE_PTxFEmpMsk_Pos)         /*!< USB GINTMSK_HOSTMODE: PTxFEmpMsk Mask   */
#define USB_GINTMSK_HOSTMODE_ConIDStsChngMsk_Pos 28                                                   /*!< USB GINTMSK_HOSTMODE: ConIDStsChngMsk Position */
#define USB_GINTMSK_HOSTMODE_ConIDStsChngMsk_Msk (0x01UL << USB_GINTMSK_HOSTMODE_ConIDStsChngMsk_Pos) /*!< USB GINTMSK_HOSTMODE: ConIDStsChngMsk Mask */
#define USB_GINTMSK_HOSTMODE_DisconnIntMsk_Pos 29                                                     /*!< USB GINTMSK_HOSTMODE: DisconnIntMsk Position */
#define USB_GINTMSK_HOSTMODE_DisconnIntMsk_Msk (0x01UL << USB_GINTMSK_HOSTMODE_DisconnIntMsk_Pos)     /*!< USB GINTMSK_HOSTMODE: DisconnIntMsk Mask */
#define USB_GINTMSK_HOSTMODE_SessReqIntMsk_Pos 30                                                     /*!< USB GINTMSK_HOSTMODE: SessReqIntMsk Position */
#define USB_GINTMSK_HOSTMODE_SessReqIntMsk_Msk (0x01UL << USB_GINTMSK_HOSTMODE_SessReqIntMsk_Pos)     /*!< USB GINTMSK_HOSTMODE: SessReqIntMsk Mask */
#define USB_GINTMSK_HOSTMODE_WkUpIntMsk_Pos   31                                                      /*!< USB GINTMSK_HOSTMODE: WkUpIntMsk Position */
#define USB_GINTMSK_HOSTMODE_WkUpIntMsk_Msk   (0x01UL << USB_GINTMSK_HOSTMODE_WkUpIntMsk_Pos)         /*!< USB GINTMSK_HOSTMODE: WkUpIntMsk Mask   */

/* ---------------------------  USB_GINTMSK_DEVICEMODE  --------------------------- */
#define USB_GINTMSK_DEVICEMODE_ModeMisMsk_Pos 1                                                       /*!< USB GINTMSK_DEVICEMODE: ModeMisMsk Position */
#define USB_GINTMSK_DEVICEMODE_ModeMisMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_ModeMisMsk_Pos)       /*!< USB GINTMSK_DEVICEMODE: ModeMisMsk Mask */
#define USB_GINTMSK_DEVICEMODE_OTGIntMsk_Pos  2                                                       /*!< USB GINTMSK_DEVICEMODE: OTGIntMsk Position */
#define USB_GINTMSK_DEVICEMODE_OTGIntMsk_Msk  (0x01UL << USB_GINTMSK_DEVICEMODE_OTGIntMsk_Pos)        /*!< USB GINTMSK_DEVICEMODE: OTGIntMsk Mask  */
#define USB_GINTMSK_DEVICEMODE_SofMsk_Pos     3                                                       /*!< USB GINTMSK_DEVICEMODE: SofMsk Position */
#define USB_GINTMSK_DEVICEMODE_SofMsk_Msk     (0x01UL << USB_GINTMSK_DEVICEMODE_SofMsk_Pos)           /*!< USB GINTMSK_DEVICEMODE: SofMsk Mask     */
#define USB_GINTMSK_DEVICEMODE_RxFLvlMsk_Pos  4                                                       /*!< USB GINTMSK_DEVICEMODE: RxFLvlMsk Position */
#define USB_GINTMSK_DEVICEMODE_RxFLvlMsk_Msk  (0x01UL << USB_GINTMSK_DEVICEMODE_RxFLvlMsk_Pos)        /*!< USB GINTMSK_DEVICEMODE: RxFLvlMsk Mask  */
#define USB_GINTMSK_DEVICEMODE_GINNakEffMsk_Pos 6                                                     /*!< USB GINTMSK_DEVICEMODE: GINNakEffMsk Position */
#define USB_GINTMSK_DEVICEMODE_GINNakEffMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_GINNakEffMsk_Pos)   /*!< USB GINTMSK_DEVICEMODE: GINNakEffMsk Mask */
#define USB_GINTMSK_DEVICEMODE_GOUTNakEffMsk_Pos 7                                                    /*!< USB GINTMSK_DEVICEMODE: GOUTNakEffMsk Position */
#define USB_GINTMSK_DEVICEMODE_GOUTNakEffMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_GOUTNakEffMsk_Pos) /*!< USB GINTMSK_DEVICEMODE: GOUTNakEffMsk Mask */
#define USB_GINTMSK_DEVICEMODE_ErlySuspMsk_Pos 10                                                     /*!< USB GINTMSK_DEVICEMODE: ErlySuspMsk Position */
#define USB_GINTMSK_DEVICEMODE_ErlySuspMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_ErlySuspMsk_Pos)     /*!< USB GINTMSK_DEVICEMODE: ErlySuspMsk Mask */
#define USB_GINTMSK_DEVICEMODE_USBSuspMsk_Pos 11                                                      /*!< USB GINTMSK_DEVICEMODE: USBSuspMsk Position */
#define USB_GINTMSK_DEVICEMODE_USBSuspMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_USBSuspMsk_Pos)       /*!< USB GINTMSK_DEVICEMODE: USBSuspMsk Mask */
#define USB_GINTMSK_DEVICEMODE_USBRstMsk_Pos  12                                                      /*!< USB GINTMSK_DEVICEMODE: USBRstMsk Position */
#define USB_GINTMSK_DEVICEMODE_USBRstMsk_Msk  (0x01UL << USB_GINTMSK_DEVICEMODE_USBRstMsk_Pos)        /*!< USB GINTMSK_DEVICEMODE: USBRstMsk Mask  */
#define USB_GINTMSK_DEVICEMODE_EnumDoneMsk_Pos 13                                                     /*!< USB GINTMSK_DEVICEMODE: EnumDoneMsk Position */
#define USB_GINTMSK_DEVICEMODE_EnumDoneMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_EnumDoneMsk_Pos)     /*!< USB GINTMSK_DEVICEMODE: EnumDoneMsk Mask */
#define USB_GINTMSK_DEVICEMODE_ISOOutDropMsk_Pos 14                                                   /*!< USB GINTMSK_DEVICEMODE: ISOOutDropMsk Position */
#define USB_GINTMSK_DEVICEMODE_ISOOutDropMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_ISOOutDropMsk_Pos) /*!< USB GINTMSK_DEVICEMODE: ISOOutDropMsk Mask */
#define USB_GINTMSK_DEVICEMODE_EOPFMsk_Pos    15                                                      /*!< USB GINTMSK_DEVICEMODE: EOPFMsk Position */
#define USB_GINTMSK_DEVICEMODE_EOPFMsk_Msk    (0x01UL << USB_GINTMSK_DEVICEMODE_EOPFMsk_Pos)          /*!< USB GINTMSK_DEVICEMODE: EOPFMsk Mask    */
#define USB_GINTMSK_DEVICEMODE_IEPIntMsk_Pos  18                                                      /*!< USB GINTMSK_DEVICEMODE: IEPIntMsk Position */
#define USB_GINTMSK_DEVICEMODE_IEPIntMsk_Msk  (0x01UL << USB_GINTMSK_DEVICEMODE_IEPIntMsk_Pos)        /*!< USB GINTMSK_DEVICEMODE: IEPIntMsk Mask  */
#define USB_GINTMSK_DEVICEMODE_OEPIntMsk_Pos  19                                                      /*!< USB GINTMSK_DEVICEMODE: OEPIntMsk Position */
#define USB_GINTMSK_DEVICEMODE_OEPIntMsk_Msk  (0x01UL << USB_GINTMSK_DEVICEMODE_OEPIntMsk_Pos)        /*!< USB GINTMSK_DEVICEMODE: OEPIntMsk Mask  */
#define USB_GINTMSK_DEVICEMODE_incompISOINMsk_Pos 20                                                  /*!< USB GINTMSK_DEVICEMODE: incompISOINMsk Position */
#define USB_GINTMSK_DEVICEMODE_incompISOINMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_incompISOINMsk_Pos)/*!< USB GINTMSK_DEVICEMODE: incompISOINMsk Mask */
#define USB_GINTMSK_DEVICEMODE_incomplSOOUTMsk_Pos 21                                                 /*!< USB GINTMSK_DEVICEMODE: incomplSOOUTMsk Position */
#define USB_GINTMSK_DEVICEMODE_incomplSOOUTMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_incomplSOOUTMsk_Pos)/*!< USB GINTMSK_DEVICEMODE: incomplSOOUTMsk Mask */
#define USB_GINTMSK_DEVICEMODE_ConIDStsChngMsk_Pos 28                                                 /*!< USB GINTMSK_DEVICEMODE: ConIDStsChngMsk Position */
#define USB_GINTMSK_DEVICEMODE_ConIDStsChngMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_ConIDStsChngMsk_Pos)/*!< USB GINTMSK_DEVICEMODE: ConIDStsChngMsk Mask */
#define USB_GINTMSK_DEVICEMODE_DisconnIntMsk_Pos 29                                                   /*!< USB GINTMSK_DEVICEMODE: DisconnIntMsk Position */
#define USB_GINTMSK_DEVICEMODE_DisconnIntMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_DisconnIntMsk_Pos) /*!< USB GINTMSK_DEVICEMODE: DisconnIntMsk Mask */
#define USB_GINTMSK_DEVICEMODE_SessReqIntMsk_Pos 30                                                   /*!< USB GINTMSK_DEVICEMODE: SessReqIntMsk Position */
#define USB_GINTMSK_DEVICEMODE_SessReqIntMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_SessReqIntMsk_Pos) /*!< USB GINTMSK_DEVICEMODE: SessReqIntMsk Mask */
#define USB_GINTMSK_DEVICEMODE_WkUpIntMsk_Pos 31                                                      /*!< USB GINTMSK_DEVICEMODE: WkUpIntMsk Position */
#define USB_GINTMSK_DEVICEMODE_WkUpIntMsk_Msk (0x01UL << USB_GINTMSK_DEVICEMODE_WkUpIntMsk_Pos)       /*!< USB GINTMSK_DEVICEMODE: WkUpIntMsk Mask */

/* ----------------------------  USB_GRXSTSR_HOSTMODE  ---------------------------- */
#define USB_GRXSTSR_HOSTMODE_ChNum_Pos        0                                                       /*!< USB GRXSTSR_HOSTMODE: ChNum Position    */
#define USB_GRXSTSR_HOSTMODE_ChNum_Msk        (0x0fUL << USB_GRXSTSR_HOSTMODE_ChNum_Pos)              /*!< USB GRXSTSR_HOSTMODE: ChNum Mask        */
#define USB_GRXSTSR_HOSTMODE_BCnt_Pos         4                                                       /*!< USB GRXSTSR_HOSTMODE: BCnt Position     */
#define USB_GRXSTSR_HOSTMODE_BCnt_Msk         (0x000007ffUL << USB_GRXSTSR_HOSTMODE_BCnt_Pos)         /*!< USB GRXSTSR_HOSTMODE: BCnt Mask         */
#define USB_GRXSTSR_HOSTMODE_DPID_Pos         15                                                      /*!< USB GRXSTSR_HOSTMODE: DPID Position     */
#define USB_GRXSTSR_HOSTMODE_DPID_Msk         (0x03UL << USB_GRXSTSR_HOSTMODE_DPID_Pos)               /*!< USB GRXSTSR_HOSTMODE: DPID Mask         */
#define USB_GRXSTSR_HOSTMODE_PktSts_Pos       17                                                      /*!< USB GRXSTSR_HOSTMODE: PktSts Position   */
#define USB_GRXSTSR_HOSTMODE_PktSts_Msk       (0x0fUL << USB_GRXSTSR_HOSTMODE_PktSts_Pos)             /*!< USB GRXSTSR_HOSTMODE: PktSts Mask       */

/* ---------------------------  USB_GRXSTSR_DEVICEMODE  --------------------------- */
#define USB_GRXSTSR_DEVICEMODE_EPNum_Pos      0                                                       /*!< USB GRXSTSR_DEVICEMODE: EPNum Position  */
#define USB_GRXSTSR_DEVICEMODE_EPNum_Msk      (0x0fUL << USB_GRXSTSR_DEVICEMODE_EPNum_Pos)            /*!< USB GRXSTSR_DEVICEMODE: EPNum Mask      */
#define USB_GRXSTSR_DEVICEMODE_BCnt_Pos       4                                                       /*!< USB GRXSTSR_DEVICEMODE: BCnt Position   */
#define USB_GRXSTSR_DEVICEMODE_BCnt_Msk       (0x000007ffUL << USB_GRXSTSR_DEVICEMODE_BCnt_Pos)       /*!< USB GRXSTSR_DEVICEMODE: BCnt Mask       */
#define USB_GRXSTSR_DEVICEMODE_DPID_Pos       15                                                      /*!< USB GRXSTSR_DEVICEMODE: DPID Position   */
#define USB_GRXSTSR_DEVICEMODE_DPID_Msk       (0x03UL << USB_GRXSTSR_DEVICEMODE_DPID_Pos)             /*!< USB GRXSTSR_DEVICEMODE: DPID Mask       */
#define USB_GRXSTSR_DEVICEMODE_PktSts_Pos     17                                                      /*!< USB GRXSTSR_DEVICEMODE: PktSts Position */
#define USB_GRXSTSR_DEVICEMODE_PktSts_Msk     (0x0fUL << USB_GRXSTSR_DEVICEMODE_PktSts_Pos)           /*!< USB GRXSTSR_DEVICEMODE: PktSts Mask     */
#define USB_GRXSTSR_DEVICEMODE_FN_Pos         21                                                      /*!< USB GRXSTSR_DEVICEMODE: FN Position     */
#define USB_GRXSTSR_DEVICEMODE_FN_Msk         (0x0fUL << USB_GRXSTSR_DEVICEMODE_FN_Pos)               /*!< USB GRXSTSR_DEVICEMODE: FN Mask         */

/* ---------------------------  USB_GRXSTSP_DEVICEMODE  --------------------------- */
#define USB_GRXSTSP_DEVICEMODE_EPNum_Pos      0                                                       /*!< USB GRXSTSP_DEVICEMODE: EPNum Position  */
#define USB_GRXSTSP_DEVICEMODE_EPNum_Msk      (0x0fUL << USB_GRXSTSP_DEVICEMODE_EPNum_Pos)            /*!< USB GRXSTSP_DEVICEMODE: EPNum Mask      */
#define USB_GRXSTSP_DEVICEMODE_BCnt_Pos       4                                                       /*!< USB GRXSTSP_DEVICEMODE: BCnt Position   */
#define USB_GRXSTSP_DEVICEMODE_BCnt_Msk       (0x000007ffUL << USB_GRXSTSP_DEVICEMODE_BCnt_Pos)       /*!< USB GRXSTSP_DEVICEMODE: BCnt Mask       */
#define USB_GRXSTSP_DEVICEMODE_DPID_Pos       15                                                      /*!< USB GRXSTSP_DEVICEMODE: DPID Position   */
#define USB_GRXSTSP_DEVICEMODE_DPID_Msk       (0x03UL << USB_GRXSTSP_DEVICEMODE_DPID_Pos)             /*!< USB GRXSTSP_DEVICEMODE: DPID Mask       */
#define USB_GRXSTSP_DEVICEMODE_PktSts_Pos     17                                                      /*!< USB GRXSTSP_DEVICEMODE: PktSts Position */
#define USB_GRXSTSP_DEVICEMODE_PktSts_Msk     (0x0fUL << USB_GRXSTSP_DEVICEMODE_PktSts_Pos)           /*!< USB GRXSTSP_DEVICEMODE: PktSts Mask     */
#define USB_GRXSTSP_DEVICEMODE_FN_Pos         21                                                      /*!< USB GRXSTSP_DEVICEMODE: FN Position     */
#define USB_GRXSTSP_DEVICEMODE_FN_Msk         (0x0fUL << USB_GRXSTSP_DEVICEMODE_FN_Pos)               /*!< USB GRXSTSP_DEVICEMODE: FN Mask         */

/* ----------------------------  USB_GRXSTSP_HOSTMODE  ---------------------------- */
#define USB_GRXSTSP_HOSTMODE_ChNum_Pos        0                                                       /*!< USB GRXSTSP_HOSTMODE: ChNum Position    */
#define USB_GRXSTSP_HOSTMODE_ChNum_Msk        (0x0fUL << USB_GRXSTSP_HOSTMODE_ChNum_Pos)              /*!< USB GRXSTSP_HOSTMODE: ChNum Mask        */
#define USB_GRXSTSP_HOSTMODE_BCnt_Pos         4                                                       /*!< USB GRXSTSP_HOSTMODE: BCnt Position     */
#define USB_GRXSTSP_HOSTMODE_BCnt_Msk         (0x000007ffUL << USB_GRXSTSP_HOSTMODE_BCnt_Pos)         /*!< USB GRXSTSP_HOSTMODE: BCnt Mask         */
#define USB_GRXSTSP_HOSTMODE_DPID_Pos         15                                                      /*!< USB GRXSTSP_HOSTMODE: DPID Position     */
#define USB_GRXSTSP_HOSTMODE_DPID_Msk         (0x03UL << USB_GRXSTSP_HOSTMODE_DPID_Pos)               /*!< USB GRXSTSP_HOSTMODE: DPID Mask         */
#define USB_GRXSTSP_HOSTMODE_PktSts_Pos       17                                                      /*!< USB GRXSTSP_HOSTMODE: PktSts Position   */
#define USB_GRXSTSP_HOSTMODE_PktSts_Msk       (0x0fUL << USB_GRXSTSP_HOSTMODE_PktSts_Pos)             /*!< USB GRXSTSP_HOSTMODE: PktSts Mask       */

/* ---------------------------------  USB_GRXFSIZ  -------------------------------- */
#define USB_GRXFSIZ_RxFDep_Pos                0                                                       /*!< USB GRXFSIZ: RxFDep Position            */
#define USB_GRXFSIZ_RxFDep_Msk                (0x0000ffffUL << USB_GRXFSIZ_RxFDep_Pos)                /*!< USB GRXFSIZ: RxFDep Mask                */

/* ---------------------------  USB_GNPTXFSIZ_HOSTMODE  --------------------------- */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFStAddr_Pos 0                                                      /*!< USB GNPTXFSIZ_HOSTMODE: NPTxFStAddr Position */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFStAddr_Msk (0x0000ffffUL << USB_GNPTXFSIZ_HOSTMODE_NPTxFStAddr_Pos)/*!< USB GNPTXFSIZ_HOSTMODE: NPTxFStAddr Mask */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFDep_Pos   16                                                      /*!< USB GNPTXFSIZ_HOSTMODE: NPTxFDep Position */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFDep_Msk   (0x0000ffffUL << USB_GNPTXFSIZ_HOSTMODE_NPTxFDep_Pos)   /*!< USB GNPTXFSIZ_HOSTMODE: NPTxFDep Mask   */

/* --------------------------  USB_GNPTXFSIZ_DEVICEMODE  -------------------------- */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0StAddr_Pos 0                                                 /*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0StAddr Position */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0StAddr_Msk (0x0000ffffUL << USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0StAddr_Pos)/*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0StAddr Mask */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0Dep_Pos 16                                                   /*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0Dep Position */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0Dep_Msk (0x0000ffffUL << USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0Dep_Pos)/*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0Dep Mask */

/* --------------------------------  USB_GNPTXSTS  -------------------------------- */
#define USB_GNPTXSTS_NPTxFSpcAvail_Pos        0                                                       /*!< USB GNPTXSTS: NPTxFSpcAvail Position    */
#define USB_GNPTXSTS_NPTxFSpcAvail_Msk        (0x0000ffffUL << USB_GNPTXSTS_NPTxFSpcAvail_Pos)        /*!< USB GNPTXSTS: NPTxFSpcAvail Mask        */
#define USB_GNPTXSTS_NPTxQSpcAvail_Pos        16                                                      /*!< USB GNPTXSTS: NPTxQSpcAvail Position    */
#define USB_GNPTXSTS_NPTxQSpcAvail_Msk        (0x000000ffUL << USB_GNPTXSTS_NPTxQSpcAvail_Pos)        /*!< USB GNPTXSTS: NPTxQSpcAvail Mask        */
#define USB_GNPTXSTS_NPTxQTop_Pos             24                                                      /*!< USB GNPTXSTS: NPTxQTop Position         */
#define USB_GNPTXSTS_NPTxQTop_Msk             (0x7fUL << USB_GNPTXSTS_NPTxQTop_Pos)                   /*!< USB GNPTXSTS: NPTxQTop Mask             */

/* ----------------------------------  USB_GUID  ---------------------------------- */
#define USB_GUID_MOD_REV_Pos                  0                                                       /*!< USB GUID: MOD_REV Position              */
#define USB_GUID_MOD_REV_Msk                  (0x000000ffUL << USB_GUID_MOD_REV_Pos)                  /*!< USB GUID: MOD_REV Mask                  */
#define USB_GUID_MOD_TYPE_Pos                 8                                                       /*!< USB GUID: MOD_TYPE Position             */
#define USB_GUID_MOD_TYPE_Msk                 (0x000000ffUL << USB_GUID_MOD_TYPE_Pos)                 /*!< USB GUID: MOD_TYPE Mask                 */
#define USB_GUID_MOD_NUMBER_Pos               16                                                      /*!< USB GUID: MOD_NUMBER Position           */
#define USB_GUID_MOD_NUMBER_Msk               (0x0000ffffUL << USB_GUID_MOD_NUMBER_Pos)               /*!< USB GUID: MOD_NUMBER Mask               */

/* --------------------------------  USB_GDFIFOCFG  ------------------------------- */
#define USB_GDFIFOCFG_GDFIFOCfg_Pos           0                                                       /*!< USB GDFIFOCFG: GDFIFOCfg Position       */
#define USB_GDFIFOCFG_GDFIFOCfg_Msk           (0x0000ffffUL << USB_GDFIFOCFG_GDFIFOCfg_Pos)           /*!< USB GDFIFOCFG: GDFIFOCfg Mask           */
#define USB_GDFIFOCFG_EPInfoBaseAddr_Pos      16                                                      /*!< USB GDFIFOCFG: EPInfoBaseAddr Position  */
#define USB_GDFIFOCFG_EPInfoBaseAddr_Msk      (0x0000ffffUL << USB_GDFIFOCFG_EPInfoBaseAddr_Pos)      /*!< USB GDFIFOCFG: EPInfoBaseAddr Mask      */

/* --------------------------------  USB_HPTXFSIZ  -------------------------------- */
#define USB_HPTXFSIZ_PTxFStAddr_Pos           0                                                       /*!< USB HPTXFSIZ: PTxFStAddr Position       */
#define USB_HPTXFSIZ_PTxFStAddr_Msk           (0x0000ffffUL << USB_HPTXFSIZ_PTxFStAddr_Pos)           /*!< USB HPTXFSIZ: PTxFStAddr Mask           */
#define USB_HPTXFSIZ_PTxFSize_Pos             16                                                      /*!< USB HPTXFSIZ: PTxFSize Position         */
#define USB_HPTXFSIZ_PTxFSize_Msk             (0x0000ffffUL << USB_HPTXFSIZ_PTxFSize_Pos)             /*!< USB HPTXFSIZ: PTxFSize Mask             */

/* --------------------------------  USB_DIEPTXF1  -------------------------------- */
#define USB_DIEPTXF1_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF1: INEPnTxFStAddr Position   */
#define USB_DIEPTXF1_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF1_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF1: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF1_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF1: INEPnTxFDep Position      */
#define USB_DIEPTXF1_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF1_INEPnTxFDep_Pos)          /*!< USB DIEPTXF1: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF2  -------------------------------- */
#define USB_DIEPTXF2_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF2: INEPnTxFStAddr Position   */
#define USB_DIEPTXF2_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF2_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF2: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF2_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF2: INEPnTxFDep Position      */
#define USB_DIEPTXF2_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF2_INEPnTxFDep_Pos)          /*!< USB DIEPTXF2: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF3  -------------------------------- */
#define USB_DIEPTXF3_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF3: INEPnTxFStAddr Position   */
#define USB_DIEPTXF3_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF3_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF3: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF3_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF3: INEPnTxFDep Position      */
#define USB_DIEPTXF3_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF3_INEPnTxFDep_Pos)          /*!< USB DIEPTXF3: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF4  -------------------------------- */
#define USB_DIEPTXF4_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF4: INEPnTxFStAddr Position   */
#define USB_DIEPTXF4_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF4_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF4: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF4_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF4: INEPnTxFDep Position      */
#define USB_DIEPTXF4_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF4_INEPnTxFDep_Pos)          /*!< USB DIEPTXF4: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF5  -------------------------------- */
#define USB_DIEPTXF5_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF5: INEPnTxFStAddr Position   */
#define USB_DIEPTXF5_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF5_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF5: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF5_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF5: INEPnTxFDep Position      */
#define USB_DIEPTXF5_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF5_INEPnTxFDep_Pos)          /*!< USB DIEPTXF5: INEPnTxFDep Mask          */

/* --------------------------------  USB_DIEPTXF6  -------------------------------- */
#define USB_DIEPTXF6_INEPnTxFStAddr_Pos       0                                                       /*!< USB DIEPTXF6: INEPnTxFStAddr Position   */
#define USB_DIEPTXF6_INEPnTxFStAddr_Msk       (0x0000ffffUL << USB_DIEPTXF6_INEPnTxFStAddr_Pos)       /*!< USB DIEPTXF6: INEPnTxFStAddr Mask       */
#define USB_DIEPTXF6_INEPnTxFDep_Pos          16                                                      /*!< USB DIEPTXF6: INEPnTxFDep Position      */
#define USB_DIEPTXF6_INEPnTxFDep_Msk          (0x0000ffffUL << USB_DIEPTXF6_INEPnTxFDep_Pos)          /*!< USB DIEPTXF6: INEPnTxFDep Mask          */

/* ----------------------------------  USB_HCFG  ---------------------------------- */
#define USB_HCFG_FSLSPclkSel_Pos              0                                                       /*!< USB HCFG: FSLSPclkSel Position          */
#define USB_HCFG_FSLSPclkSel_Msk              (0x03UL << USB_HCFG_FSLSPclkSel_Pos)                    /*!< USB HCFG: FSLSPclkSel Mask              */
#define USB_HCFG_FSLSSupp_Pos                 2                                                       /*!< USB HCFG: FSLSSupp Position             */
#define USB_HCFG_FSLSSupp_Msk                 (0x01UL << USB_HCFG_FSLSSupp_Pos)                       /*!< USB HCFG: FSLSSupp Mask                 */
#define USB_HCFG_DescDMA_Pos                  23                                                      /*!< USB HCFG: DescDMA Position              */
#define USB_HCFG_DescDMA_Msk                  (0x01UL << USB_HCFG_DescDMA_Pos)                        /*!< USB HCFG: DescDMA Mask                  */
#define USB_HCFG_FrListEn_Pos                 24                                                      /*!< USB HCFG: FrListEn Position             */
#define USB_HCFG_FrListEn_Msk                 (0x03UL << USB_HCFG_FrListEn_Pos)                       /*!< USB HCFG: FrListEn Mask                 */
#define USB_HCFG_PerSchedEna_Pos              26                                                      /*!< USB HCFG: PerSchedEna Position          */
#define USB_HCFG_PerSchedEna_Msk              (0x01UL << USB_HCFG_PerSchedEna_Pos)                    /*!< USB HCFG: PerSchedEna Mask              */

/* ----------------------------------  USB_HFIR  ---------------------------------- */
#define USB_HFIR_FrInt_Pos                    0                                                       /*!< USB HFIR: FrInt Position                */
#define USB_HFIR_FrInt_Msk                    (0x0000ffffUL << USB_HFIR_FrInt_Pos)                    /*!< USB HFIR: FrInt Mask                    */
#define USB_HFIR_HFIRRldCtrl_Pos              16                                                      /*!< USB HFIR: HFIRRldCtrl Position          */
#define USB_HFIR_HFIRRldCtrl_Msk              (0x01UL << USB_HFIR_HFIRRldCtrl_Pos)                    /*!< USB HFIR: HFIRRldCtrl Mask              */

/* ----------------------------------  USB_HFNUM  --------------------------------- */
#define USB_HFNUM_FrNum_Pos                   0                                                       /*!< USB HFNUM: FrNum Position               */
#define USB_HFNUM_FrNum_Msk                   (0x0000ffffUL << USB_HFNUM_FrNum_Pos)                   /*!< USB HFNUM: FrNum Mask                   */
#define USB_HFNUM_FrRem_Pos                   16                                                      /*!< USB HFNUM: FrRem Position               */
#define USB_HFNUM_FrRem_Msk                   (0x0000ffffUL << USB_HFNUM_FrRem_Pos)                   /*!< USB HFNUM: FrRem Mask                   */

/* ---------------------------------  USB_HPTXSTS  -------------------------------- */
#define USB_HPTXSTS_PTxFSpcAvail_Pos          0                                                       /*!< USB HPTXSTS: PTxFSpcAvail Position      */
#define USB_HPTXSTS_PTxFSpcAvail_Msk          (0x0000ffffUL << USB_HPTXSTS_PTxFSpcAvail_Pos)          /*!< USB HPTXSTS: PTxFSpcAvail Mask          */
#define USB_HPTXSTS_PTxQSpcAvail_Pos          16                                                      /*!< USB HPTXSTS: PTxQSpcAvail Position      */
#define USB_HPTXSTS_PTxQSpcAvail_Msk          (0x000000ffUL << USB_HPTXSTS_PTxQSpcAvail_Pos)          /*!< USB HPTXSTS: PTxQSpcAvail Mask          */
#define USB_HPTXSTS_PTxQTop_Pos               24                                                      /*!< USB HPTXSTS: PTxQTop Position           */
#define USB_HPTXSTS_PTxQTop_Msk               (0x000000ffUL << USB_HPTXSTS_PTxQTop_Pos)               /*!< USB HPTXSTS: PTxQTop Mask               */

/* ----------------------------------  USB_HAINT  --------------------------------- */
#define USB_HAINT_HAINT_Pos                   0                                                       /*!< USB HAINT: HAINT Position               */
#define USB_HAINT_HAINT_Msk                   (0x00003fffUL << USB_HAINT_HAINT_Pos)                   /*!< USB HAINT: HAINT Mask                   */

/* --------------------------------  USB_HAINTMSK  -------------------------------- */
#define USB_HAINTMSK_HAINTMsk_Pos             0                                                       /*!< USB HAINTMSK: HAINTMsk Position         */
#define USB_HAINTMSK_HAINTMsk_Msk             (0x00003fffUL << USB_HAINTMSK_HAINTMsk_Pos)             /*!< USB HAINTMSK: HAINTMsk Mask             */

/* --------------------------------  USB_HFLBADDR  -------------------------------- */
#define USB_HFLBADDR_Starting_Address_Pos     0                                                       /*!< USB HFLBADDR: Starting_Address Position */
#define USB_HFLBADDR_Starting_Address_Msk     (0xffffffffUL << USB_HFLBADDR_Starting_Address_Pos)     /*!< USB HFLBADDR: Starting_Address Mask     */

/* ----------------------------------  USB_HPRT  ---------------------------------- */
#define USB_HPRT_PrtConnSts_Pos               0                                                       /*!< USB HPRT: PrtConnSts Position           */
#define USB_HPRT_PrtConnSts_Msk               (0x01UL << USB_HPRT_PrtConnSts_Pos)                     /*!< USB HPRT: PrtConnSts Mask               */
#define USB_HPRT_PrtConnDet_Pos               1                                                       /*!< USB HPRT: PrtConnDet Position           */
#define USB_HPRT_PrtConnDet_Msk               (0x01UL << USB_HPRT_PrtConnDet_Pos)                     /*!< USB HPRT: PrtConnDet Mask               */
#define USB_HPRT_PrtEna_Pos                   2                                                       /*!< USB HPRT: PrtEna Position               */
#define USB_HPRT_PrtEna_Msk                   (0x01UL << USB_HPRT_PrtEna_Pos)                         /*!< USB HPRT: PrtEna Mask                   */
#define USB_HPRT_PrtEnChng_Pos                3                                                       /*!< USB HPRT: PrtEnChng Position            */
#define USB_HPRT_PrtEnChng_Msk                (0x01UL << USB_HPRT_PrtEnChng_Pos)                      /*!< USB HPRT: PrtEnChng Mask                */
#define USB_HPRT_PrtOvrCurrAct_Pos            4                                                       /*!< USB HPRT: PrtOvrCurrAct Position        */
#define USB_HPRT_PrtOvrCurrAct_Msk            (0x01UL << USB_HPRT_PrtOvrCurrAct_Pos)                  /*!< USB HPRT: PrtOvrCurrAct Mask            */
#define USB_HPRT_PrtOvrCurrChng_Pos           5                                                       /*!< USB HPRT: PrtOvrCurrChng Position       */
#define USB_HPRT_PrtOvrCurrChng_Msk           (0x01UL << USB_HPRT_PrtOvrCurrChng_Pos)                 /*!< USB HPRT: PrtOvrCurrChng Mask           */
#define USB_HPRT_PrtRes_Pos                   6                                                       /*!< USB HPRT: PrtRes Position               */
#define USB_HPRT_PrtRes_Msk                   (0x01UL << USB_HPRT_PrtRes_Pos)                         /*!< USB HPRT: PrtRes Mask                   */
#define USB_HPRT_PrtSusp_Pos                  7                                                       /*!< USB HPRT: PrtSusp Position              */
#define USB_HPRT_PrtSusp_Msk                  (0x01UL << USB_HPRT_PrtSusp_Pos)                        /*!< USB HPRT: PrtSusp Mask                  */
#define USB_HPRT_PrtRst_Pos                   8                                                       /*!< USB HPRT: PrtRst Position               */
#define USB_HPRT_PrtRst_Msk                   (0x01UL << USB_HPRT_PrtRst_Pos)                         /*!< USB HPRT: PrtRst Mask                   */
#define USB_HPRT_PrtLnSts_Pos                 10                                                      /*!< USB HPRT: PrtLnSts Position             */
#define USB_HPRT_PrtLnSts_Msk                 (0x03UL << USB_HPRT_PrtLnSts_Pos)                       /*!< USB HPRT: PrtLnSts Mask                 */
#define USB_HPRT_PrtPwr_Pos                   12                                                      /*!< USB HPRT: PrtPwr Position               */
#define USB_HPRT_PrtPwr_Msk                   (0x01UL << USB_HPRT_PrtPwr_Pos)                         /*!< USB HPRT: PrtPwr Mask                   */
#define USB_HPRT_PrtSpd_Pos                   17                                                      /*!< USB HPRT: PrtSpd Position               */
#define USB_HPRT_PrtSpd_Msk                   (0x03UL << USB_HPRT_PrtSpd_Pos)                         /*!< USB HPRT: PrtSpd Mask                   */

/* ----------------------------------  USB_DCFG  ---------------------------------- */
#define USB_DCFG_DevSpd_Pos                   0                                                       /*!< USB DCFG: DevSpd Position               */
#define USB_DCFG_DevSpd_Msk                   (0x03UL << USB_DCFG_DevSpd_Pos)                         /*!< USB DCFG: DevSpd Mask                   */
#define USB_DCFG_NZStsOUTHShk_Pos             2                                                       /*!< USB DCFG: NZStsOUTHShk Position         */
#define USB_DCFG_NZStsOUTHShk_Msk             (0x01UL << USB_DCFG_NZStsOUTHShk_Pos)                   /*!< USB DCFG: NZStsOUTHShk Mask             */
#define USB_DCFG_DevAddr_Pos                  4                                                       /*!< USB DCFG: DevAddr Position              */
#define USB_DCFG_DevAddr_Msk                  (0x7fUL << USB_DCFG_DevAddr_Pos)                        /*!< USB DCFG: DevAddr Mask                  */
#define USB_DCFG_PerFrInt_Pos                 11                                                      /*!< USB DCFG: PerFrInt Position             */
#define USB_DCFG_PerFrInt_Msk                 (0x03UL << USB_DCFG_PerFrInt_Pos)                       /*!< USB DCFG: PerFrInt Mask                 */
#define USB_DCFG_DescDMA_Pos                  23                                                      /*!< USB DCFG: DescDMA Position              */
#define USB_DCFG_DescDMA_Msk                  (0x01UL << USB_DCFG_DescDMA_Pos)                        /*!< USB DCFG: DescDMA Mask                  */
#define USB_DCFG_PerSchIntvl_Pos              24                                                      /*!< USB DCFG: PerSchIntvl Position          */
#define USB_DCFG_PerSchIntvl_Msk              (0x03UL << USB_DCFG_PerSchIntvl_Pos)                    /*!< USB DCFG: PerSchIntvl Mask              */

/* ----------------------------------  USB_DCTL  ---------------------------------- */
#define USB_DCTL_RmtWkUpSig_Pos               0                                                       /*!< USB DCTL: RmtWkUpSig Position           */
#define USB_DCTL_RmtWkUpSig_Msk               (0x01UL << USB_DCTL_RmtWkUpSig_Pos)                     /*!< USB DCTL: RmtWkUpSig Mask               */
#define USB_DCTL_SftDiscon_Pos                1                                                       /*!< USB DCTL: SftDiscon Position            */
#define USB_DCTL_SftDiscon_Msk                (0x01UL << USB_DCTL_SftDiscon_Pos)                      /*!< USB DCTL: SftDiscon Mask                */
#define USB_DCTL_GNPINNakSts_Pos              2                                                       /*!< USB DCTL: GNPINNakSts Position          */
#define USB_DCTL_GNPINNakSts_Msk              (0x01UL << USB_DCTL_GNPINNakSts_Pos)                    /*!< USB DCTL: GNPINNakSts Mask              */
#define USB_DCTL_GOUTNakSts_Pos               3                                                       /*!< USB DCTL: GOUTNakSts Position           */
#define USB_DCTL_GOUTNakSts_Msk               (0x01UL << USB_DCTL_GOUTNakSts_Pos)                     /*!< USB DCTL: GOUTNakSts Mask               */
#define USB_DCTL_SGNPInNak_Pos                7                                                       /*!< USB DCTL: SGNPInNak Position            */
#define USB_DCTL_SGNPInNak_Msk                (0x01UL << USB_DCTL_SGNPInNak_Pos)                      /*!< USB DCTL: SGNPInNak Mask                */
#define USB_DCTL_CGNPInNak_Pos                8                                                       /*!< USB DCTL: CGNPInNak Position            */
#define USB_DCTL_CGNPInNak_Msk                (0x01UL << USB_DCTL_CGNPInNak_Pos)                      /*!< USB DCTL: CGNPInNak Mask                */
#define USB_DCTL_SGOUTNak_Pos                 9                                                       /*!< USB DCTL: SGOUTNak Position             */
#define USB_DCTL_SGOUTNak_Msk                 (0x01UL << USB_DCTL_SGOUTNak_Pos)                       /*!< USB DCTL: SGOUTNak Mask                 */
#define USB_DCTL_CGOUTNak_Pos                 10                                                      /*!< USB DCTL: CGOUTNak Position             */
#define USB_DCTL_CGOUTNak_Msk                 (0x01UL << USB_DCTL_CGOUTNak_Pos)                       /*!< USB DCTL: CGOUTNak Mask                 */
#define USB_DCTL_GMC_Pos                      13                                                      /*!< USB DCTL: GMC Position                  */
#define USB_DCTL_GMC_Msk                      (0x03UL << USB_DCTL_GMC_Pos)                            /*!< USB DCTL: GMC Mask                      */
#define USB_DCTL_IgnrFrmNum_Pos               15                                                      /*!< USB DCTL: IgnrFrmNum Position           */
#define USB_DCTL_IgnrFrmNum_Msk               (0x01UL << USB_DCTL_IgnrFrmNum_Pos)                     /*!< USB DCTL: IgnrFrmNum Mask               */
#define USB_DCTL_NakOnBble_Pos                16                                                      /*!< USB DCTL: NakOnBble Position            */
#define USB_DCTL_NakOnBble_Msk                (0x01UL << USB_DCTL_NakOnBble_Pos)                      /*!< USB DCTL: NakOnBble Mask                */
#define USB_DCTL_EnContOnBNA_Pos              17                                                      /*!< USB DCTL: EnContOnBNA Position          */
#define USB_DCTL_EnContOnBNA_Msk              (0x01UL << USB_DCTL_EnContOnBNA_Pos)                    /*!< USB DCTL: EnContOnBNA Mask              */

/* ----------------------------------  USB_DSTS  ---------------------------------- */
#define USB_DSTS_SuspSts_Pos                  0                                                       /*!< USB DSTS: SuspSts Position              */
#define USB_DSTS_SuspSts_Msk                  (0x01UL << USB_DSTS_SuspSts_Pos)                        /*!< USB DSTS: SuspSts Mask                  */
#define USB_DSTS_EnumSpd_Pos                  1                                                       /*!< USB DSTS: EnumSpd Position              */
#define USB_DSTS_EnumSpd_Msk                  (0x03UL << USB_DSTS_EnumSpd_Pos)                        /*!< USB DSTS: EnumSpd Mask                  */
#define USB_DSTS_ErrticErr_Pos                3                                                       /*!< USB DSTS: ErrticErr Position            */
#define USB_DSTS_ErrticErr_Msk                (0x01UL << USB_DSTS_ErrticErr_Pos)                      /*!< USB DSTS: ErrticErr Mask                */
#define USB_DSTS_SOFFN_Pos                    8                                                       /*!< USB DSTS: SOFFN Position                */
#define USB_DSTS_SOFFN_Msk                    (0x00003fffUL << USB_DSTS_SOFFN_Pos)                    /*!< USB DSTS: SOFFN Mask                    */

/* ---------------------------------  USB_DIEPMSK  -------------------------------- */
#define USB_DIEPMSK_XferComplMsk_Pos          0                                                       /*!< USB DIEPMSK: XferComplMsk Position      */
#define USB_DIEPMSK_XferComplMsk_Msk          (0x01UL << USB_DIEPMSK_XferComplMsk_Pos)                /*!< USB DIEPMSK: XferComplMsk Mask          */
#define USB_DIEPMSK_EPDisbldMsk_Pos           1                                                       /*!< USB DIEPMSK: EPDisbldMsk Position       */
#define USB_DIEPMSK_EPDisbldMsk_Msk           (0x01UL << USB_DIEPMSK_EPDisbldMsk_Pos)                 /*!< USB DIEPMSK: EPDisbldMsk Mask           */
#define USB_DIEPMSK_AHBErrMsk_Pos             2                                                       /*!< USB DIEPMSK: AHBErrMsk Position         */
#define USB_DIEPMSK_AHBErrMsk_Msk             (0x01UL << USB_DIEPMSK_AHBErrMsk_Pos)                   /*!< USB DIEPMSK: AHBErrMsk Mask             */
#define USB_DIEPMSK_TimeOUTMsk_Pos            3                                                       /*!< USB DIEPMSK: TimeOUTMsk Position        */
#define USB_DIEPMSK_TimeOUTMsk_Msk            (0x01UL << USB_DIEPMSK_TimeOUTMsk_Pos)                  /*!< USB DIEPMSK: TimeOUTMsk Mask            */
#define USB_DIEPMSK_INTknTXFEmpMsk_Pos        4                                                       /*!< USB DIEPMSK: INTknTXFEmpMsk Position    */
#define USB_DIEPMSK_INTknTXFEmpMsk_Msk        (0x01UL << USB_DIEPMSK_INTknTXFEmpMsk_Pos)              /*!< USB DIEPMSK: INTknTXFEmpMsk Mask        */
#define USB_DIEPMSK_INEPNakEffMsk_Pos         6                                                       /*!< USB DIEPMSK: INEPNakEffMsk Position     */
#define USB_DIEPMSK_INEPNakEffMsk_Msk         (0x01UL << USB_DIEPMSK_INEPNakEffMsk_Pos)               /*!< USB DIEPMSK: INEPNakEffMsk Mask         */
#define USB_DIEPMSK_TxfifoUndrnMsk_Pos        8                                                       /*!< USB DIEPMSK: TxfifoUndrnMsk Position    */
#define USB_DIEPMSK_TxfifoUndrnMsk_Msk        (0x01UL << USB_DIEPMSK_TxfifoUndrnMsk_Pos)              /*!< USB DIEPMSK: TxfifoUndrnMsk Mask        */
#define USB_DIEPMSK_BNAInIntrMsk_Pos          9                                                       /*!< USB DIEPMSK: BNAInIntrMsk Position      */
#define USB_DIEPMSK_BNAInIntrMsk_Msk          (0x01UL << USB_DIEPMSK_BNAInIntrMsk_Pos)                /*!< USB DIEPMSK: BNAInIntrMsk Mask          */
#define USB_DIEPMSK_NAKMsk_Pos                13                                                      /*!< USB DIEPMSK: NAKMsk Position            */
#define USB_DIEPMSK_NAKMsk_Msk                (0x01UL << USB_DIEPMSK_NAKMsk_Pos)                      /*!< USB DIEPMSK: NAKMsk Mask                */

/* ---------------------------------  USB_DOEPMSK  -------------------------------- */
#define USB_DOEPMSK_XferComplMsk_Pos          0                                                       /*!< USB DOEPMSK: XferComplMsk Position      */
#define USB_DOEPMSK_XferComplMsk_Msk          (0x01UL << USB_DOEPMSK_XferComplMsk_Pos)                /*!< USB DOEPMSK: XferComplMsk Mask          */
#define USB_DOEPMSK_EPDisbldMsk_Pos           1                                                       /*!< USB DOEPMSK: EPDisbldMsk Position       */
#define USB_DOEPMSK_EPDisbldMsk_Msk           (0x01UL << USB_DOEPMSK_EPDisbldMsk_Pos)                 /*!< USB DOEPMSK: EPDisbldMsk Mask           */
#define USB_DOEPMSK_AHBErrMsk_Pos             2                                                       /*!< USB DOEPMSK: AHBErrMsk Position         */
#define USB_DOEPMSK_AHBErrMsk_Msk             (0x01UL << USB_DOEPMSK_AHBErrMsk_Pos)                   /*!< USB DOEPMSK: AHBErrMsk Mask             */
#define USB_DOEPMSK_SetUPMsk_Pos              3                                                       /*!< USB DOEPMSK: SetUPMsk Position          */
#define USB_DOEPMSK_SetUPMsk_Msk              (0x01UL << USB_DOEPMSK_SetUPMsk_Pos)                    /*!< USB DOEPMSK: SetUPMsk Mask              */
#define USB_DOEPMSK_OUTTknEPdisMsk_Pos        4                                                       /*!< USB DOEPMSK: OUTTknEPdisMsk Position    */
#define USB_DOEPMSK_OUTTknEPdisMsk_Msk        (0x01UL << USB_DOEPMSK_OUTTknEPdisMsk_Pos)              /*!< USB DOEPMSK: OUTTknEPdisMsk Mask        */
#define USB_DOEPMSK_Back2BackSETup_Pos        6                                                       /*!< USB DOEPMSK: Back2BackSETup Position    */
#define USB_DOEPMSK_Back2BackSETup_Msk        (0x01UL << USB_DOEPMSK_Back2BackSETup_Pos)              /*!< USB DOEPMSK: Back2BackSETup Mask        */
#define USB_DOEPMSK_OutPktErrMsk_Pos          8                                                       /*!< USB DOEPMSK: OutPktErrMsk Position      */
#define USB_DOEPMSK_OutPktErrMsk_Msk          (0x01UL << USB_DOEPMSK_OutPktErrMsk_Pos)                /*!< USB DOEPMSK: OutPktErrMsk Mask          */
#define USB_DOEPMSK_BnaOutIntrMsk_Pos         9                                                       /*!< USB DOEPMSK: BnaOutIntrMsk Position     */
#define USB_DOEPMSK_BnaOutIntrMsk_Msk         (0x01UL << USB_DOEPMSK_BnaOutIntrMsk_Pos)               /*!< USB DOEPMSK: BnaOutIntrMsk Mask         */
#define USB_DOEPMSK_BbleErrMsk_Pos            12                                                      /*!< USB DOEPMSK: BbleErrMsk Position        */
#define USB_DOEPMSK_BbleErrMsk_Msk            (0x01UL << USB_DOEPMSK_BbleErrMsk_Pos)                  /*!< USB DOEPMSK: BbleErrMsk Mask            */
#define USB_DOEPMSK_NAKMsk_Pos                13                                                      /*!< USB DOEPMSK: NAKMsk Position            */
#define USB_DOEPMSK_NAKMsk_Msk                (0x01UL << USB_DOEPMSK_NAKMsk_Pos)                      /*!< USB DOEPMSK: NAKMsk Mask                */
#define USB_DOEPMSK_NYETMsk_Pos               14                                                      /*!< USB DOEPMSK: NYETMsk Position           */
#define USB_DOEPMSK_NYETMsk_Msk               (0x01UL << USB_DOEPMSK_NYETMsk_Pos)                     /*!< USB DOEPMSK: NYETMsk Mask               */

/* ----------------------------------  USB_DAINT  --------------------------------- */
#define USB_DAINT_InEpInt_Pos                 0                                                       /*!< USB DAINT: InEpInt Position             */
#define USB_DAINT_InEpInt_Msk                 (0x0000ffffUL << USB_DAINT_InEpInt_Pos)                 /*!< USB DAINT: InEpInt Mask                 */
#define USB_DAINT_OutEPInt_Pos                16                                                      /*!< USB DAINT: OutEPInt Position            */
#define USB_DAINT_OutEPInt_Msk                (0x0000ffffUL << USB_DAINT_OutEPInt_Pos)                /*!< USB DAINT: OutEPInt Mask                */

/* --------------------------------  USB_DAINTMSK  -------------------------------- */
#define USB_DAINTMSK_InEpMsk_Pos              0                                                       /*!< USB DAINTMSK: InEpMsk Position          */
#define USB_DAINTMSK_InEpMsk_Msk              (0x0000ffffUL << USB_DAINTMSK_InEpMsk_Pos)              /*!< USB DAINTMSK: InEpMsk Mask              */
#define USB_DAINTMSK_OutEpMsk_Pos             16                                                      /*!< USB DAINTMSK: OutEpMsk Position         */
#define USB_DAINTMSK_OutEpMsk_Msk             (0x0000ffffUL << USB_DAINTMSK_OutEpMsk_Pos)             /*!< USB DAINTMSK: OutEpMsk Mask             */

/* --------------------------------  USB_DVBUSDIS  -------------------------------- */
#define USB_DVBUSDIS_DVBUSDis_Pos             0                                                       /*!< USB DVBUSDIS: DVBUSDis Position         */
#define USB_DVBUSDIS_DVBUSDis_Msk             (0x0000ffffUL << USB_DVBUSDIS_DVBUSDis_Pos)             /*!< USB DVBUSDIS: DVBUSDis Mask             */

/* -------------------------------  USB_DVBUSPULSE  ------------------------------- */
#define USB_DVBUSPULSE_DVBUSPulse_Pos         0                                                       /*!< USB DVBUSPULSE: DVBUSPulse Position     */
#define USB_DVBUSPULSE_DVBUSPulse_Msk         (0x00000fffUL << USB_DVBUSPULSE_DVBUSPulse_Pos)         /*!< USB DVBUSPULSE: DVBUSPulse Mask         */

/* -------------------------------  USB_DIEPEMPMSK  ------------------------------- */
#define USB_DIEPEMPMSK_InEpTxfEmpMsk_Pos      0                                                       /*!< USB DIEPEMPMSK: InEpTxfEmpMsk Position  */
#define USB_DIEPEMPMSK_InEpTxfEmpMsk_Msk      (0x0000ffffUL << USB_DIEPEMPMSK_InEpTxfEmpMsk_Pos)      /*!< USB DIEPEMPMSK: InEpTxfEmpMsk Mask      */

/* ---------------------------------  USB_PCGCCTL  -------------------------------- */
#define USB_PCGCCTL_StopPclk_Pos              0                                                       /*!< USB PCGCCTL: StopPclk Position          */
#define USB_PCGCCTL_StopPclk_Msk              (0x01UL << USB_PCGCCTL_StopPclk_Pos)                    /*!< USB PCGCCTL: StopPclk Mask              */
#define USB_PCGCCTL_GateHclk_Pos              1                                                       /*!< USB PCGCCTL: GateHclk Position          */
#define USB_PCGCCTL_GateHclk_Msk              (0x01UL << USB_PCGCCTL_GateHclk_Pos)                    /*!< USB PCGCCTL: GateHclk Mask              */


/* ================================================================================ */
/* ================        struct 'USB0_EP0' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  USB_EP_DIEPCTL0  ----------------------------- */
#define USB_EP_DIEPCTL0_MPS_Pos             0                                                       /*!< USB0_EP0 DIEPCTL0: MPS Position         */
#define USB_EP_DIEPCTL0_MPS_Msk             (0x03UL << USB_EP_DIEPCTL0_MPS_Pos)                   /*!< USB0_EP0 DIEPCTL0: MPS Mask             */
#define USB_EP_DIEPCTL0_USBActEP_Pos        15                                                      /*!< USB0_EP0 DIEPCTL0: USBActEP Position    */
#define USB_EP_DIEPCTL0_USBActEP_Msk        (0x01UL << USB_EP_DIEPCTL0_USBActEP_Pos)              /*!< USB0_EP0 DIEPCTL0: USBActEP Mask        */
#define USB_EP_DIEPCTL0_NAKSts_Pos          17                                                      /*!< USB0_EP0 DIEPCTL0: NAKSts Position      */
#define USB_EP_DIEPCTL0_NAKSts_Msk          (0x01UL << USB_EP_DIEPCTL0_NAKSts_Pos)                /*!< USB0_EP0 DIEPCTL0: NAKSts Mask          */
#define USB_EP_DIEPCTL0_EPType_Pos          18                                                      /*!< USB0_EP0 DIEPCTL0: EPType Position      */
#define USB_EP_DIEPCTL0_EPType_Msk          (0x03UL << USB_EP_DIEPCTL0_EPType_Pos)                /*!< USB0_EP0 DIEPCTL0: EPType Mask          */
#define USB_EP_DIEPCTL0_Stall_Pos           21                                                      /*!< USB0_EP0 DIEPCTL0: Stall Position       */
#define USB_EP_DIEPCTL0_Stall_Msk           (0x01UL << USB_EP_DIEPCTL0_Stall_Pos)                 /*!< USB0_EP0 DIEPCTL0: Stall Mask           */
#define USB_EP_DIEPCTL0_TxFNum_Pos          22                                                      /*!< USB0_EP0 DIEPCTL0: TxFNum Position      */
#define USB_EP_DIEPCTL0_TxFNum_Msk          (0x0fUL << USB_EP_DIEPCTL0_TxFNum_Pos)                /*!< USB0_EP0 DIEPCTL0: TxFNum Mask          */
#define USB_EP_DIEPCTL0_CNAK_Pos            26                                                      /*!< USB0_EP0 DIEPCTL0: CNAK Position        */
#define USB_EP_DIEPCTL0_CNAK_Msk            (0x01UL << USB_EP_DIEPCTL0_CNAK_Pos)                  /*!< USB0_EP0 DIEPCTL0: CNAK Mask            */
#define USB_EP_DIEPCTL0_SNAK_Pos            27                                                      /*!< USB0_EP0 DIEPCTL0: SNAK Position        */
#define USB_EP_DIEPCTL0_SNAK_Msk            (0x01UL << USB_EP_DIEPCTL0_SNAK_Pos)                  /*!< USB0_EP0 DIEPCTL0: SNAK Mask            */
#define USB_EP_DIEPCTL0_EPDis_Pos           30                                                      /*!< USB0_EP0 DIEPCTL0: EPDis Position       */
#define USB_EP_DIEPCTL0_EPDis_Msk           (0x01UL << USB_EP_DIEPCTL0_EPDis_Pos)                 /*!< USB0_EP0 DIEPCTL0: EPDis Mask           */
#define USB_EP_DIEPCTL0_EPEna_Pos           31                                                      /*!< USB0_EP0 DIEPCTL0: EPEna Position       */
#define USB_EP_DIEPCTL0_EPEna_Msk           (0x01UL << USB_EP_DIEPCTL0_EPEna_Pos)                 /*!< USB0_EP0 DIEPCTL0: EPEna Mask           */

/* ------------------------------  USB_EP_DIEPINT0  ----------------------------- */
#define USB_EP_DIEPINT0_XferCompl_Pos       0                                                       /*!< USB0_EP0 DIEPINT0: XferCompl Position   */
#define USB_EP_DIEPINT0_XferCompl_Msk       (0x01UL << USB_EP_DIEPINT0_XferCompl_Pos)             /*!< USB0_EP0 DIEPINT0: XferCompl Mask       */
#define USB_EP_DIEPINT0_EPDisbld_Pos        1                                                       /*!< USB0_EP0 DIEPINT0: EPDisbld Position    */
#define USB_EP_DIEPINT0_EPDisbld_Msk        (0x01UL << USB_EP_DIEPINT0_EPDisbld_Pos)              /*!< USB0_EP0 DIEPINT0: EPDisbld Mask        */
#define USB_EP_DIEPINT0_AHBErr_Pos          2                                                       /*!< USB0_EP0 DIEPINT0: AHBErr Position      */
#define USB_EP_DIEPINT0_AHBErr_Msk          (0x01UL << USB_EP_DIEPINT0_AHBErr_Pos)                /*!< USB0_EP0 DIEPINT0: AHBErr Mask          */
#define USB_EP_DIEPINT0_TimeOUT_Pos         3                                                       /*!< USB0_EP0 DIEPINT0: TimeOUT Position     */
#define USB_EP_DIEPINT0_TimeOUT_Msk         (0x01UL << USB_EP_DIEPINT0_TimeOUT_Pos)               /*!< USB0_EP0 DIEPINT0: TimeOUT Mask         */
#define USB_EP_DIEPINT0_INTknTXFEmp_Pos     4                                                       /*!< USB0_EP0 DIEPINT0: INTknTXFEmp Position */
#define USB_EP_DIEPINT0_INTknTXFEmp_Msk     (0x01UL << USB_EP_DIEPINT0_INTknTXFEmp_Pos)           /*!< USB0_EP0 DIEPINT0: INTknTXFEmp Mask     */
#define USB_EP_DIEPINT0_INEPNakEff_Pos      6                                                       /*!< USB0_EP0 DIEPINT0: INEPNakEff Position  */
#define USB_EP_DIEPINT0_INEPNakEff_Msk      (0x01UL << USB_EP_DIEPINT0_INEPNakEff_Pos)            /*!< USB0_EP0 DIEPINT0: INEPNakEff Mask      */
#define USB_EP_DIEPINT0_TxFEmp_Pos          7                                                       /*!< USB0_EP0 DIEPINT0: TxFEmp Position      */
#define USB_EP_DIEPINT0_TxFEmp_Msk          (0x01UL << USB_EP_DIEPINT0_TxFEmp_Pos)                /*!< USB0_EP0 DIEPINT0: TxFEmp Mask          */
#define USB_EP_DIEPINT0_BNAIntr_Pos         9                                                       /*!< USB0_EP0 DIEPINT0: BNAIntr Position     */
#define USB_EP_DIEPINT0_BNAIntr_Msk         (0x01UL << USB_EP_DIEPINT0_BNAIntr_Pos)               /*!< USB0_EP0 DIEPINT0: BNAIntr Mask         */

/* -----------------------------  USB_EP_DIEPTSIZ0  ----------------------------- */
#define USB_EP_DIEPTSIZ0_XferSize_Pos       0                                                       /*!< USB0_EP0 DIEPTSIZ0: XferSize Position   */
#define USB_EP_DIEPTSIZ0_XferSize_Msk       (0x7fUL << USB_EP_DIEPTSIZ0_XferSize_Pos)             /*!< USB0_EP0 DIEPTSIZ0: XferSize Mask       */
#define USB_EP_DIEPTSIZ0_PktCnt_Pos         19                                                      /*!< USB0_EP0 DIEPTSIZ0: PktCnt Position     */
#define USB_EP_DIEPTSIZ0_PktCnt_Msk         (0x03UL << USB_EP_DIEPTSIZ0_PktCnt_Pos)               /*!< USB0_EP0 DIEPTSIZ0: PktCnt Mask         */

/* ------------------------------  USB_EP_DIEPDMA0  ----------------------------- */
#define USB_EP_DIEPDMA0_DMAAddr_Pos         0                                                       /*!< USB0_EP0 DIEPDMA0: DMAAddr Position     */
#define USB_EP_DIEPDMA0_DMAAddr_Msk         (0xffffffffUL << USB_EP_DIEPDMA0_DMAAddr_Pos)         /*!< USB0_EP0 DIEPDMA0: DMAAddr Mask         */

/* ------------------------------  USB_EP_DTXFSTS0  ----------------------------- */
#define USB_EP_DTXFSTS0_INEPTxFSpcAvail_Pos 0                                                       /*!< USB0_EP0 DTXFSTS0: INEPTxFSpcAvail Position */
#define USB_EP_DTXFSTS0_INEPTxFSpcAvail_Msk (0x0000ffffUL << USB_EP_DTXFSTS0_INEPTxFSpcAvail_Pos) /*!< USB0_EP0 DTXFSTS0: INEPTxFSpcAvail Mask */

/* -----------------------------  USB_EP_DIEPDMAB0  ----------------------------- */
#define USB_EP_DIEPDMAB0_DMABufferAddr_Pos  0                                                       /*!< USB0_EP0 DIEPDMAB0: DMABufferAddr Position */
#define USB_EP_DIEPDMAB0_DMABufferAddr_Msk  (0xffffffffUL << USB_EP_DIEPDMAB0_DMABufferAddr_Pos)  /*!< USB0_EP0 DIEPDMAB0: DMABufferAddr Mask  */

/* ------------------------------  USB_EP_DOEPCTL0  ----------------------------- */
#define USB_EP_DOEPCTL0_MPS_Pos             0                                                       /*!< USB0_EP0 DOEPCTL0: MPS Position         */
#define USB_EP_DOEPCTL0_MPS_Msk             (0x03UL << USB_EP_DOEPCTL0_MPS_Pos)                   /*!< USB0_EP0 DOEPCTL0: MPS Mask             */
#define USB_EP_DOEPCTL0_USBActEP_Pos        15                                                      /*!< USB0_EP0 DOEPCTL0: USBActEP Position    */
#define USB_EP_DOEPCTL0_USBActEP_Msk        (0x01UL << USB_EP_DOEPCTL0_USBActEP_Pos)              /*!< USB0_EP0 DOEPCTL0: USBActEP Mask        */
#define USB_EP_DOEPCTL0_NAKSts_Pos          17                                                      /*!< USB0_EP0 DOEPCTL0: NAKSts Position      */
#define USB_EP_DOEPCTL0_NAKSts_Msk          (0x01UL << USB_EP_DOEPCTL0_NAKSts_Pos)                /*!< USB0_EP0 DOEPCTL0: NAKSts Mask          */
#define USB_EP_DOEPCTL0_EPType_Pos          18                                                      /*!< USB0_EP0 DOEPCTL0: EPType Position      */
#define USB_EP_DOEPCTL0_EPType_Msk          (0x03UL << USB_EP_DOEPCTL0_EPType_Pos)                /*!< USB0_EP0 DOEPCTL0: EPType Mask          */
#define USB_EP_DOEPCTL0_Snp_Pos             20                                                      /*!< USB0_EP0 DOEPCTL0: Snp Position         */
#define USB_EP_DOEPCTL0_Snp_Msk             (0x01UL << USB_EP_DOEPCTL0_Snp_Pos)                   /*!< USB0_EP0 DOEPCTL0: Snp Mask             */
#define USB_EP_DOEPCTL0_Stall_Pos           21                                                      /*!< USB0_EP0 DOEPCTL0: Stall Position       */
#define USB_EP_DOEPCTL0_Stall_Msk           (0x01UL << USB_EP_DOEPCTL0_Stall_Pos)                 /*!< USB0_EP0 DOEPCTL0: Stall Mask           */
#define USB_EP_DOEPCTL0_CNAK_Pos            26                                                      /*!< USB0_EP0 DOEPCTL0: CNAK Position        */
#define USB_EP_DOEPCTL0_CNAK_Msk            (0x01UL << USB_EP_DOEPCTL0_CNAK_Pos)                  /*!< USB0_EP0 DOEPCTL0: CNAK Mask            */
#define USB_EP_DOEPCTL0_SNAK_Pos            27                                                      /*!< USB0_EP0 DOEPCTL0: SNAK Position        */
#define USB_EP_DOEPCTL0_SNAK_Msk            (0x01UL << USB_EP_DOEPCTL0_SNAK_Pos)                  /*!< USB0_EP0 DOEPCTL0: SNAK Mask            */
#define USB_EP_DOEPCTL0_EPDis_Pos           30                                                      /*!< USB0_EP0 DOEPCTL0: EPDis Position       */
#define USB_EP_DOEPCTL0_EPDis_Msk           (0x01UL << USB_EP_DOEPCTL0_EPDis_Pos)                 /*!< USB0_EP0 DOEPCTL0: EPDis Mask           */
#define USB_EP_DOEPCTL0_EPEna_Pos           31                                                      /*!< USB0_EP0 DOEPCTL0: EPEna Position       */
#define USB_EP_DOEPCTL0_EPEna_Msk           (0x01UL << USB_EP_DOEPCTL0_EPEna_Pos)                 /*!< USB0_EP0 DOEPCTL0: EPEna Mask           */

/* ------------------------------  USB_EP_DOEPINT0  ----------------------------- */
#define USB_EP_DOEPINT0_XferCompl_Pos       0                                                       /*!< USB0_EP0 DOEPINT0: XferCompl Position   */
#define USB_EP_DOEPINT0_XferCompl_Msk       (0x01UL << USB_EP_DOEPINT0_XferCompl_Pos)             /*!< USB0_EP0 DOEPINT0: XferCompl Mask       */
#define USB_EP_DOEPINT0_EPDisbld_Pos        1                                                       /*!< USB0_EP0 DOEPINT0: EPDisbld Position    */
#define USB_EP_DOEPINT0_EPDisbld_Msk        (0x01UL << USB_EP_DOEPINT0_EPDisbld_Pos)              /*!< USB0_EP0 DOEPINT0: EPDisbld Mask        */
#define USB_EP_DOEPINT0_AHBErr_Pos          2                                                       /*!< USB0_EP0 DOEPINT0: AHBErr Position      */
#define USB_EP_DOEPINT0_AHBErr_Msk          (0x01UL << USB_EP_DOEPINT0_AHBErr_Pos)                /*!< USB0_EP0 DOEPINT0: AHBErr Mask          */
#define USB_EP_DOEPINT0_SetUp_Pos           3                                                       /*!< USB0_EP0 DOEPINT0: SetUp Position       */
#define USB_EP_DOEPINT0_SetUp_Msk           (0x01UL << USB_EP_DOEPINT0_SetUp_Pos)                 /*!< USB0_EP0 DOEPINT0: SetUp Mask           */
#define USB_EP_DOEPINT0_OUTTknEPdis_Pos     4                                                       /*!< USB0_EP0 DOEPINT0: OUTTknEPdis Position */
#define USB_EP_DOEPINT0_OUTTknEPdis_Msk     (0x01UL << USB_EP_DOEPINT0_OUTTknEPdis_Pos)           /*!< USB0_EP0 DOEPINT0: OUTTknEPdis Mask     */
#define USB_EP_DOEPINT0_StsPhseRcvd_Pos     5                                                       /*!< USB0_EP0 DOEPINT0: StsPhseRcvd Position */
#define USB_EP_DOEPINT0_StsPhseRcvd_Msk     (0x01UL << USB_EP_DOEPINT0_StsPhseRcvd_Pos)           /*!< USB0_EP0 DOEPINT0: StsPhseRcvd Mask     */
#define USB_EP_DOEPINT0_Back2BackSETup_Pos  6                                                       /*!< USB0_EP0 DOEPINT0: Back2BackSETup Position */
#define USB_EP_DOEPINT0_Back2BackSETup_Msk  (0x01UL << USB_EP_DOEPINT0_Back2BackSETup_Pos)        /*!< USB0_EP0 DOEPINT0: Back2BackSETup Mask  */
#define USB_EP_DOEPINT0_BNAIntr_Pos         9                                                       /*!< USB0_EP0 DOEPINT0: BNAIntr Position     */
#define USB_EP_DOEPINT0_BNAIntr_Msk         (0x01UL << USB_EP_DOEPINT0_BNAIntr_Pos)               /*!< USB0_EP0 DOEPINT0: BNAIntr Mask         */
#define USB_EP_DOEPINT0_PktDrpSts_Pos       11                                                      /*!< USB0_EP0 DOEPINT0: PktDrpSts Position   */
#define USB_EP_DOEPINT0_PktDrpSts_Msk       (0x01UL << USB_EP_DOEPINT0_PktDrpSts_Pos)             /*!< USB0_EP0 DOEPINT0: PktDrpSts Mask       */
#define USB_EP_DOEPINT0_BbleErrIntrpt_Pos   12                                                      /*!< USB0_EP0 DOEPINT0: BbleErrIntrpt Position */
#define USB_EP_DOEPINT0_BbleErrIntrpt_Msk   (0x01UL << USB_EP_DOEPINT0_BbleErrIntrpt_Pos)         /*!< USB0_EP0 DOEPINT0: BbleErrIntrpt Mask   */
#define USB_EP_DOEPINT0_NAKIntrpt_Pos       13                                                      /*!< USB0_EP0 DOEPINT0: NAKIntrpt Position   */
#define USB_EP_DOEPINT0_NAKIntrpt_Msk       (0x01UL << USB_EP_DOEPINT0_NAKIntrpt_Pos)             /*!< USB0_EP0 DOEPINT0: NAKIntrpt Mask       */
#define USB_EP_DOEPINT0_NYETIntrpt_Pos      14                                                      /*!< USB0_EP0 DOEPINT0: NYETIntrpt Position  */
#define USB_EP_DOEPINT0_NYETIntrpt_Msk      (0x01UL << USB_EP_DOEPINT0_NYETIntrpt_Pos)            /*!< USB0_EP0 DOEPINT0: NYETIntrpt Mask      */

/* -----------------------------  USB_EP_DOEPTSIZ0  ----------------------------- */
#define USB_EP_DOEPTSIZ0_XferSize_Pos       0                                                       /*!< USB0_EP0 DOEPTSIZ0: XferSize Position   */
#define USB_EP_DOEPTSIZ0_XferSize_Msk       (0x7fUL << USB_EP_DOEPTSIZ0_XferSize_Pos)             /*!< USB0_EP0 DOEPTSIZ0: XferSize Mask       */
#define USB_EP_DOEPTSIZ0_PktCnt_Pos         19                                                      /*!< USB0_EP0 DOEPTSIZ0: PktCnt Position     */
#define USB_EP_DOEPTSIZ0_PktCnt_Msk         (0x03UL << USB_EP_DOEPTSIZ0_PktCnt_Pos)               /*!< USB0_EP0 DOEPTSIZ0: PktCnt Mask         */
#define USB_EP_DOEPTSIZ0_SUPCnt_Pos         29                                                      /*!< USB0_EP0 DOEPTSIZ0: SUPCnt Position     */
#define USB_EP_DOEPTSIZ0_SUPCnt_Msk         (0x03UL << USB_EP_DOEPTSIZ0_SUPCnt_Pos)               /*!< USB0_EP0 DOEPTSIZ0: SUPCnt Mask         */

/* ------------------------------  USB_EP_DOEPDMA0  ----------------------------- */
#define USB_EP_DOEPDMA0_DMAAddr_Pos         0                                                       /*!< USB0_EP0 DOEPDMA0: DMAAddr Position     */
#define USB_EP_DOEPDMA0_DMAAddr_Msk         (0xffffffffUL << USB_EP_DOEPDMA0_DMAAddr_Pos)         /*!< USB0_EP0 DOEPDMA0: DMAAddr Mask         */

/* -----------------------------  USB_EP_DOEPDMAB0  ----------------------------- */
#define USB_EP_DOEPDMAB0_DMABufferAddr_Pos  0                                                       /*!< USB0_EP0 DOEPDMAB0: DMABufferAddr Position */
#define USB_EP_DOEPDMAB0_DMABufferAddr_Msk  (0xffffffffUL << USB_EP_DOEPDMAB0_DMABufferAddr_Pos)  /*!< USB0_EP0 DOEPDMAB0: DMABufferAddr Mask  */


/* ================================================================================ */
/* ================         Group 'USB_EP' Position & Mask         ================ */
/* ================================================================================ */


/* ---------------------------  USB_EP_DIEPCTL_ISOCONT  --------------------------- */
#define USB_EP_DIEPCTL_ISOCONT_MPS_Pos        0                                                       /*!< USB_EP DIEPCTL_ISOCONT: MPS Position    */
#define USB_EP_DIEPCTL_ISOCONT_MPS_Msk        (0x000007ffUL << USB_EP_DIEPCTL_ISOCONT_MPS_Pos)        /*!< USB_EP DIEPCTL_ISOCONT: MPS Mask        */
#define USB_EP_DIEPCTL_ISOCONT_USBActEP_Pos   15                                                      /*!< USB_EP DIEPCTL_ISOCONT: USBActEP Position */
#define USB_EP_DIEPCTL_ISOCONT_USBActEP_Msk   (0x01UL << USB_EP_DIEPCTL_ISOCONT_USBActEP_Pos)         /*!< USB_EP DIEPCTL_ISOCONT: USBActEP Mask   */
#define USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Pos   16                                                      /*!< USB_EP DIEPCTL_ISOCONT: EO_FrNum Position */
#define USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Msk   (0x01UL << USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Pos)         /*!< USB_EP DIEPCTL_ISOCONT: EO_FrNum Mask   */
#define USB_EP_DIEPCTL_ISOCONT_NAKSts_Pos     17                                                      /*!< USB_EP DIEPCTL_ISOCONT: NAKSts Position */
#define USB_EP_DIEPCTL_ISOCONT_NAKSts_Msk     (0x01UL << USB_EP_DIEPCTL_ISOCONT_NAKSts_Pos)           /*!< USB_EP DIEPCTL_ISOCONT: NAKSts Mask     */
#define USB_EP_DIEPCTL_ISOCONT_EPType_Pos     18                                                      /*!< USB_EP DIEPCTL_ISOCONT: EPType Position */
#define USB_EP_DIEPCTL_ISOCONT_EPType_Msk     (0x03UL << USB_EP_DIEPCTL_ISOCONT_EPType_Pos)           /*!< USB_EP DIEPCTL_ISOCONT: EPType Mask     */
#define USB_EP_DIEPCTL_ISOCONT_Snp_Pos        20                                                      /*!< USB_EP DIEPCTL_ISOCONT: Snp Position    */
#define USB_EP_DIEPCTL_ISOCONT_Snp_Msk        (0x01UL << USB_EP_DIEPCTL_ISOCONT_Snp_Pos)              /*!< USB_EP DIEPCTL_ISOCONT: Snp Mask        */
#define USB_EP_DIEPCTL_ISOCONT_Stall_Pos      21                                                      /*!< USB_EP DIEPCTL_ISOCONT: Stall Position  */
#define USB_EP_DIEPCTL_ISOCONT_Stall_Msk      (0x01UL << USB_EP_DIEPCTL_ISOCONT_Stall_Pos)            /*!< USB_EP DIEPCTL_ISOCONT: Stall Mask      */
#define USB_EP_DIEPCTL_ISOCONT_TxFNum_Pos     22                                                      /*!< USB_EP DIEPCTL_ISOCONT: TxFNum Position */
#define USB_EP_DIEPCTL_ISOCONT_TxFNum_Msk     (0x0fUL << USB_EP_DIEPCTL_ISOCONT_TxFNum_Pos)           /*!< USB_EP DIEPCTL_ISOCONT: TxFNum Mask     */
#define USB_EP_DIEPCTL_ISOCONT_CNAK_Pos       26                                                      /*!< USB_EP DIEPCTL_ISOCONT: CNAK Position   */
#define USB_EP_DIEPCTL_ISOCONT_CNAK_Msk       (0x01UL << USB_EP_DIEPCTL_ISOCONT_CNAK_Pos)             /*!< USB_EP DIEPCTL_ISOCONT: CNAK Mask       */
#define USB_EP_DIEPCTL_ISOCONT_SNAK_Pos       27                                                      /*!< USB_EP DIEPCTL_ISOCONT: SNAK Position   */
#define USB_EP_DIEPCTL_ISOCONT_SNAK_Msk       (0x01UL << USB_EP_DIEPCTL_ISOCONT_SNAK_Pos)             /*!< USB_EP DIEPCTL_ISOCONT: SNAK Mask       */
#define USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Pos  28                                                      /*!< USB_EP DIEPCTL_ISOCONT: SetEvenFr Position */
#define USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Msk  (0x01UL << USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Pos)        /*!< USB_EP DIEPCTL_ISOCONT: SetEvenFr Mask  */
#define USB_EP_DIEPCTL_ISOCONT_SetOddFr_Pos   29                                                      /*!< USB_EP DIEPCTL_ISOCONT: SetOddFr Position */
#define USB_EP_DIEPCTL_ISOCONT_SetOddFr_Msk   (0x01UL << USB_EP_DIEPCTL_ISOCONT_SetOddFr_Pos)         /*!< USB_EP DIEPCTL_ISOCONT: SetOddFr Mask   */
#define USB_EP_DIEPCTL_ISOCONT_EPDis_Pos      30                                                      /*!< USB_EP DIEPCTL_ISOCONT: EPDis Position  */
#define USB_EP_DIEPCTL_ISOCONT_EPDis_Msk      (0x01UL << USB_EP_DIEPCTL_ISOCONT_EPDis_Pos)            /*!< USB_EP DIEPCTL_ISOCONT: EPDis Mask      */
#define USB_EP_DIEPCTL_ISOCONT_EPEna_Pos      31                                                      /*!< USB_EP DIEPCTL_ISOCONT: EPEna Position  */
#define USB_EP_DIEPCTL_ISOCONT_EPEna_Msk      (0x01UL << USB_EP_DIEPCTL_ISOCONT_EPEna_Pos)            /*!< USB_EP DIEPCTL_ISOCONT: EPEna Mask      */

/* ---------------------------  USB_EP_DIEPCTL_INTBULK  --------------------------- */
#define USB_EP_DIEPCTL_INTBULK_MPS_Pos        0                                                       /*!< USB_EP DIEPCTL_INTBULK: MPS Position    */
#define USB_EP_DIEPCTL_INTBULK_MPS_Msk        (0x000007ffUL << USB_EP_DIEPCTL_INTBULK_MPS_Pos)        /*!< USB_EP DIEPCTL_INTBULK: MPS Mask        */
#define USB_EP_DIEPCTL_INTBULK_USBActEP_Pos   15                                                      /*!< USB_EP DIEPCTL_INTBULK: USBActEP Position */
#define USB_EP_DIEPCTL_INTBULK_USBActEP_Msk   (0x01UL << USB_EP_DIEPCTL_INTBULK_USBActEP_Pos)         /*!< USB_EP DIEPCTL_INTBULK: USBActEP Mask   */
#define USB_EP_DIEPCTL_INTBULK_DPID_Pos       16                                                      /*!< USB_EP DIEPCTL_INTBULK: DPID Position   */
#define USB_EP_DIEPCTL_INTBULK_DPID_Msk       (0x01UL << USB_EP_DIEPCTL_INTBULK_DPID_Pos)             /*!< USB_EP DIEPCTL_INTBULK: DPID Mask       */
#define USB_EP_DIEPCTL_INTBULK_NAKSts_Pos     17                                                      /*!< USB_EP DIEPCTL_INTBULK: NAKSts Position */
#define USB_EP_DIEPCTL_INTBULK_NAKSts_Msk     (0x01UL << USB_EP_DIEPCTL_INTBULK_NAKSts_Pos)           /*!< USB_EP DIEPCTL_INTBULK: NAKSts Mask     */
#define USB_EP_DIEPCTL_INTBULK_EPType_Pos     18                                                      /*!< USB_EP DIEPCTL_INTBULK: EPType Position */
#define USB_EP_DIEPCTL_INTBULK_EPType_Msk     (0x03UL << USB_EP_DIEPCTL_INTBULK_EPType_Pos)           /*!< USB_EP DIEPCTL_INTBULK: EPType Mask     */
#define USB_EP_DIEPCTL_INTBULK_Snp_Pos        20                                                      /*!< USB_EP DIEPCTL_INTBULK: Snp Position    */
#define USB_EP_DIEPCTL_INTBULK_Snp_Msk        (0x01UL << USB_EP_DIEPCTL_INTBULK_Snp_Pos)              /*!< USB_EP DIEPCTL_INTBULK: Snp Mask        */
#define USB_EP_DIEPCTL_INTBULK_Stall_Pos      21                                                      /*!< USB_EP DIEPCTL_INTBULK: Stall Position  */
#define USB_EP_DIEPCTL_INTBULK_Stall_Msk      (0x01UL << USB_EP_DIEPCTL_INTBULK_Stall_Pos)            /*!< USB_EP DIEPCTL_INTBULK: Stall Mask      */
#define USB_EP_DIEPCTL_INTBULK_TxFNum_Pos     22                                                      /*!< USB_EP DIEPCTL_INTBULK: TxFNum Position */
#define USB_EP_DIEPCTL_INTBULK_TxFNum_Msk     (0x0fUL << USB_EP_DIEPCTL_INTBULK_TxFNum_Pos)           /*!< USB_EP DIEPCTL_INTBULK: TxFNum Mask     */
#define USB_EP_DIEPCTL_INTBULK_CNAK_Pos       26                                                      /*!< USB_EP DIEPCTL_INTBULK: CNAK Position   */
#define USB_EP_DIEPCTL_INTBULK_CNAK_Msk       (0x01UL << USB_EP_DIEPCTL_INTBULK_CNAK_Pos)             /*!< USB_EP DIEPCTL_INTBULK: CNAK Mask       */
#define USB_EP_DIEPCTL_INTBULK_SNAK_Pos       27                                                      /*!< USB_EP DIEPCTL_INTBULK: SNAK Position   */
#define USB_EP_DIEPCTL_INTBULK_SNAK_Msk       (0x01UL << USB_EP_DIEPCTL_INTBULK_SNAK_Pos)             /*!< USB_EP DIEPCTL_INTBULK: SNAK Mask       */
#define USB_EP_DIEPCTL_INTBULK_SetD0PID_Pos   28                                                      /*!< USB_EP DIEPCTL_INTBULK: SetD0PID Position */
#define USB_EP_DIEPCTL_INTBULK_SetD0PID_Msk   (0x01UL << USB_EP_DIEPCTL_INTBULK_SetD0PID_Pos)         /*!< USB_EP DIEPCTL_INTBULK: SetD0PID Mask   */
#define USB_EP_DIEPCTL_INTBULK_SetD1PID_Pos   29                                                      /*!< USB_EP DIEPCTL_INTBULK: SetD1PID Position */
#define USB_EP_DIEPCTL_INTBULK_SetD1PID_Msk   (0x01UL << USB_EP_DIEPCTL_INTBULK_SetD1PID_Pos)         /*!< USB_EP DIEPCTL_INTBULK: SetD1PID Mask   */
#define USB_EP_DIEPCTL_INTBULK_EPDis_Pos      30                                                      /*!< USB_EP DIEPCTL_INTBULK: EPDis Position  */
#define USB_EP_DIEPCTL_INTBULK_EPDis_Msk      (0x01UL << USB_EP_DIEPCTL_INTBULK_EPDis_Pos)            /*!< USB_EP DIEPCTL_INTBULK: EPDis Mask      */
#define USB_EP_DIEPCTL_INTBULK_EPEna_Pos      31                                                      /*!< USB_EP DIEPCTL_INTBULK: EPEna Position  */
#define USB_EP_DIEPCTL_INTBULK_EPEna_Msk      (0x01UL << USB_EP_DIEPCTL_INTBULK_EPEna_Pos)            /*!< USB_EP DIEPCTL_INTBULK: EPEna Mask      */

/* -------------------------------  USB_EP_DIEPINT  ------------------------------- */
#define USB_EP_DIEPINT_XferCompl_Pos          0                                                       /*!< USB_EP DIEPINT: XferCompl Position      */
#define USB_EP_DIEPINT_XferCompl_Msk          (0x01UL << USB_EP_DIEPINT_XferCompl_Pos)                /*!< USB_EP DIEPINT: XferCompl Mask          */
#define USB_EP_DIEPINT_EPDisbld_Pos           1                                                       /*!< USB_EP DIEPINT: EPDisbld Position       */
#define USB_EP_DIEPINT_EPDisbld_Msk           (0x01UL << USB_EP_DIEPINT_EPDisbld_Pos)                 /*!< USB_EP DIEPINT: EPDisbld Mask           */
#define USB_EP_DIEPINT_AHBErr_Pos             2                                                       /*!< USB_EP DIEPINT: AHBErr Position         */
#define USB_EP_DIEPINT_AHBErr_Msk             (0x01UL << USB_EP_DIEPINT_AHBErr_Pos)                   /*!< USB_EP DIEPINT: AHBErr Mask             */
#define USB_EP_DIEPINT_TimeOUT_Pos            3                                                       /*!< USB_EP DIEPINT: TimeOUT Position        */
#define USB_EP_DIEPINT_TimeOUT_Msk            (0x01UL << USB_EP_DIEPINT_TimeOUT_Pos)                  /*!< USB_EP DIEPINT: TimeOUT Mask            */
#define USB_EP_DIEPINT_INTknTXFEmp_Pos        4                                                       /*!< USB_EP DIEPINT: INTknTXFEmp Position    */
#define USB_EP_DIEPINT_INTknTXFEmp_Msk        (0x01UL << USB_EP_DIEPINT_INTknTXFEmp_Pos)              /*!< USB_EP DIEPINT: INTknTXFEmp Mask        */
#define USB_EP_DIEPINT_INEPNakEff_Pos         6                                                       /*!< USB_EP DIEPINT: INEPNakEff Position     */
#define USB_EP_DIEPINT_INEPNakEff_Msk         (0x01UL << USB_EP_DIEPINT_INEPNakEff_Pos)               /*!< USB_EP DIEPINT: INEPNakEff Mask         */
#define USB_EP_DIEPINT_TxFEmp_Pos             7                                                       /*!< USB_EP DIEPINT: TxFEmp Position         */
#define USB_EP_DIEPINT_TxFEmp_Msk             (0x01UL << USB_EP_DIEPINT_TxFEmp_Pos)                   /*!< USB_EP DIEPINT: TxFEmp Mask             */
#define USB_EP_DIEPINT_BNAIntr_Pos            9                                                       /*!< USB_EP DIEPINT: BNAIntr Position        */
#define USB_EP_DIEPINT_BNAIntr_Msk            (0x01UL << USB_EP_DIEPINT_BNAIntr_Pos)                  /*!< USB_EP DIEPINT: BNAIntr Mask            */

/* -------------------------------  USB_EP_DIEPTSIZ  ------------------------------ */
#define USB_EP_DIEPTSIZ_XferSize_Pos          0                                                       /*!< USB_EP DIEPTSIZ: XferSize Position      */
#define USB_EP_DIEPTSIZ_XferSize_Msk          (0x0007ffffUL << USB_EP_DIEPTSIZ_XferSize_Pos)          /*!< USB_EP DIEPTSIZ: XferSize Mask          */
#define USB_EP_DIEPTSIZ_PktCnt_Pos            19                                                      /*!< USB_EP DIEPTSIZ: PktCnt Position        */
#define USB_EP_DIEPTSIZ_PktCnt_Msk            (0x000003ffUL << USB_EP_DIEPTSIZ_PktCnt_Pos)            /*!< USB_EP DIEPTSIZ: PktCnt Mask            */

/* -------------------------------  USB_EP_DIEPDMA  ------------------------------- */
#define USB_EP_DIEPDMA_DMAAddr_Pos            0                                                       /*!< USB_EP DIEPDMA: DMAAddr Position        */
#define USB_EP_DIEPDMA_DMAAddr_Msk            (0xffffffffUL << USB_EP_DIEPDMA_DMAAddr_Pos)            /*!< USB_EP DIEPDMA: DMAAddr Mask            */

/* -------------------------------  USB_EP_DTXFSTS  ------------------------------- */
#define USB_EP_DTXFSTS_INEPTxFSpcAvail_Pos    0                                                       /*!< USB_EP DTXFSTS: INEPTxFSpcAvail Position */
#define USB_EP_DTXFSTS_INEPTxFSpcAvail_Msk    (0x0000ffffUL << USB_EP_DTXFSTS_INEPTxFSpcAvail_Pos)    /*!< USB_EP DTXFSTS: INEPTxFSpcAvail Mask    */

/* -------------------------------  USB_EP_DIEPDMAB  ------------------------------ */
#define USB_EP_DIEPDMAB_DMABufferAddr_Pos     0                                                       /*!< USB_EP DIEPDMAB: DMABufferAddr Position */
#define USB_EP_DIEPDMAB_DMABufferAddr_Msk     (0xffffffffUL << USB_EP_DIEPDMAB_DMABufferAddr_Pos)     /*!< USB_EP DIEPDMAB: DMABufferAddr Mask     */

/* ---------------------------  USB_EP_DOEPCTL_ISOCONT  --------------------------- */
#define USB_EP_DOEPCTL_ISOCONT_MPS_Pos        0                                                       /*!< USB_EP DOEPCTL_ISOCONT: MPS Position    */
#define USB_EP_DOEPCTL_ISOCONT_MPS_Msk        (0x000007ffUL << USB_EP_DOEPCTL_ISOCONT_MPS_Pos)        /*!< USB_EP DOEPCTL_ISOCONT: MPS Mask        */
#define USB_EP_DOEPCTL_ISOCONT_USBActEP_Pos   15                                                      /*!< USB_EP DOEPCTL_ISOCONT: USBActEP Position */
#define USB_EP_DOEPCTL_ISOCONT_USBActEP_Msk   (0x01UL << USB_EP_DOEPCTL_ISOCONT_USBActEP_Pos)         /*!< USB_EP DOEPCTL_ISOCONT: USBActEP Mask   */
#define USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Pos   16                                                      /*!< USB_EP DOEPCTL_ISOCONT: EO_FrNum Position */
#define USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Msk   (0x01UL << USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Pos)         /*!< USB_EP DOEPCTL_ISOCONT: EO_FrNum Mask   */
#define USB_EP_DOEPCTL_ISOCONT_NAKSts_Pos     17                                                      /*!< USB_EP DOEPCTL_ISOCONT: NAKSts Position */
#define USB_EP_DOEPCTL_ISOCONT_NAKSts_Msk     (0x01UL << USB_EP_DOEPCTL_ISOCONT_NAKSts_Pos)           /*!< USB_EP DOEPCTL_ISOCONT: NAKSts Mask     */
#define USB_EP_DOEPCTL_ISOCONT_EPType_Pos     18                                                      /*!< USB_EP DOEPCTL_ISOCONT: EPType Position */
#define USB_EP_DOEPCTL_ISOCONT_EPType_Msk     (0x03UL << USB_EP_DOEPCTL_ISOCONT_EPType_Pos)           /*!< USB_EP DOEPCTL_ISOCONT: EPType Mask     */
#define USB_EP_DOEPCTL_ISOCONT_Snp_Pos        20                                                      /*!< USB_EP DOEPCTL_ISOCONT: Snp Position    */
#define USB_EP_DOEPCTL_ISOCONT_Snp_Msk        (0x01UL << USB_EP_DOEPCTL_ISOCONT_Snp_Pos)              /*!< USB_EP DOEPCTL_ISOCONT: Snp Mask        */
#define USB_EP_DOEPCTL_ISOCONT_Stall_Pos      21                                                      /*!< USB_EP DOEPCTL_ISOCONT: Stall Position  */
#define USB_EP_DOEPCTL_ISOCONT_Stall_Msk      (0x01UL << USB_EP_DOEPCTL_ISOCONT_Stall_Pos)            /*!< USB_EP DOEPCTL_ISOCONT: Stall Mask      */
#define USB_EP_DOEPCTL_ISOCONT_TxFNum_Pos     22                                                      /*!< USB_EP DOEPCTL_ISOCONT: TxFNum Position */
#define USB_EP_DOEPCTL_ISOCONT_TxFNum_Msk     (0x0fUL << USB_EP_DOEPCTL_ISOCONT_TxFNum_Pos)           /*!< USB_EP DOEPCTL_ISOCONT: TxFNum Mask     */
#define USB_EP_DOEPCTL_ISOCONT_CNAK_Pos       26                                                      /*!< USB_EP DOEPCTL_ISOCONT: CNAK Position   */
#define USB_EP_DOEPCTL_ISOCONT_CNAK_Msk       (0x01UL << USB_EP_DOEPCTL_ISOCONT_CNAK_Pos)             /*!< USB_EP DOEPCTL_ISOCONT: CNAK Mask       */
#define USB_EP_DOEPCTL_ISOCONT_SNAK_Pos       27                                                      /*!< USB_EP DOEPCTL_ISOCONT: SNAK Position   */
#define USB_EP_DOEPCTL_ISOCONT_SNAK_Msk       (0x01UL << USB_EP_DOEPCTL_ISOCONT_SNAK_Pos)             /*!< USB_EP DOEPCTL_ISOCONT: SNAK Mask       */
#define USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Pos  28                                                      /*!< USB_EP DOEPCTL_ISOCONT: SetEvenFr Position */
#define USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Msk  (0x01UL << USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Pos)        /*!< USB_EP DOEPCTL_ISOCONT: SetEvenFr Mask  */
#define USB_EP_DOEPCTL_ISOCONT_SetOddFr_Pos   29                                                      /*!< USB_EP DOEPCTL_ISOCONT: SetOddFr Position */
#define USB_EP_DOEPCTL_ISOCONT_SetOddFr_Msk   (0x01UL << USB_EP_DOEPCTL_ISOCONT_SetOddFr_Pos)         /*!< USB_EP DOEPCTL_ISOCONT: SetOddFr Mask   */
#define USB_EP_DOEPCTL_ISOCONT_EPDis_Pos      30                                                      /*!< USB_EP DOEPCTL_ISOCONT: EPDis Position  */
#define USB_EP_DOEPCTL_ISOCONT_EPDis_Msk      (0x01UL << USB_EP_DOEPCTL_ISOCONT_EPDis_Pos)            /*!< USB_EP DOEPCTL_ISOCONT: EPDis Mask      */
#define USB_EP_DOEPCTL_ISOCONT_EPEna_Pos      31                                                      /*!< USB_EP DOEPCTL_ISOCONT: EPEna Position  */
#define USB_EP_DOEPCTL_ISOCONT_EPEna_Msk      (0x01UL << USB_EP_DOEPCTL_ISOCONT_EPEna_Pos)            /*!< USB_EP DOEPCTL_ISOCONT: EPEna Mask      */

/* ---------------------------  USB_EP_DOEPCTL_INTBULK  --------------------------- */
#define USB_EP_DOEPCTL_INTBULK_MPS_Pos        0                                                       /*!< USB_EP DOEPCTL_INTBULK: MPS Position    */
#define USB_EP_DOEPCTL_INTBULK_MPS_Msk        (0x000007ffUL << USB_EP_DOEPCTL_INTBULK_MPS_Pos)        /*!< USB_EP DOEPCTL_INTBULK: MPS Mask        */
#define USB_EP_DOEPCTL_INTBULK_USBActEP_Pos   15                                                      /*!< USB_EP DOEPCTL_INTBULK: USBActEP Position */
#define USB_EP_DOEPCTL_INTBULK_USBActEP_Msk   (0x01UL << USB_EP_DOEPCTL_INTBULK_USBActEP_Pos)         /*!< USB_EP DOEPCTL_INTBULK: USBActEP Mask   */
#define USB_EP_DOEPCTL_INTBULK_DPID_Pos       16                                                      /*!< USB_EP DOEPCTL_INTBULK: DPID Position   */
#define USB_EP_DOEPCTL_INTBULK_DPID_Msk       (0x01UL << USB_EP_DOEPCTL_INTBULK_DPID_Pos)             /*!< USB_EP DOEPCTL_INTBULK: DPID Mask       */
#define USB_EP_DOEPCTL_INTBULK_NAKSts_Pos     17                                                      /*!< USB_EP DOEPCTL_INTBULK: NAKSts Position */
#define USB_EP_DOEPCTL_INTBULK_NAKSts_Msk     (0x01UL << USB_EP_DOEPCTL_INTBULK_NAKSts_Pos)           /*!< USB_EP DOEPCTL_INTBULK: NAKSts Mask     */
#define USB_EP_DOEPCTL_INTBULK_EPType_Pos     18                                                      /*!< USB_EP DOEPCTL_INTBULK: EPType Position */
#define USB_EP_DOEPCTL_INTBULK_EPType_Msk     (0x03UL << USB_EP_DOEPCTL_INTBULK_EPType_Pos)           /*!< USB_EP DOEPCTL_INTBULK: EPType Mask     */
#define USB_EP_DOEPCTL_INTBULK_Snp_Pos        20                                                      /*!< USB_EP DOEPCTL_INTBULK: Snp Position    */
#define USB_EP_DOEPCTL_INTBULK_Snp_Msk        (0x01UL << USB_EP_DOEPCTL_INTBULK_Snp_Pos)              /*!< USB_EP DOEPCTL_INTBULK: Snp Mask        */
#define USB_EP_DOEPCTL_INTBULK_Stall_Pos      21                                                      /*!< USB_EP DOEPCTL_INTBULK: Stall Position  */
#define USB_EP_DOEPCTL_INTBULK_Stall_Msk      (0x01UL << USB_EP_DOEPCTL_INTBULK_Stall_Pos)            /*!< USB_EP DOEPCTL_INTBULK: Stall Mask      */
#define USB_EP_DOEPCTL_INTBULK_TxFNum_Pos     22                                                      /*!< USB_EP DOEPCTL_INTBULK: TxFNum Position */
#define USB_EP_DOEPCTL_INTBULK_TxFNum_Msk     (0x0fUL << USB_EP_DOEPCTL_INTBULK_TxFNum_Pos)           /*!< USB_EP DOEPCTL_INTBULK: TxFNum Mask     */
#define USB_EP_DOEPCTL_INTBULK_CNAK_Pos       26                                                      /*!< USB_EP DOEPCTL_INTBULK: CNAK Position   */
#define USB_EP_DOEPCTL_INTBULK_CNAK_Msk       (0x01UL << USB_EP_DOEPCTL_INTBULK_CNAK_Pos)             /*!< USB_EP DOEPCTL_INTBULK: CNAK Mask       */
#define USB_EP_DOEPCTL_INTBULK_SNAK_Pos       27                                                      /*!< USB_EP DOEPCTL_INTBULK: SNAK Position   */
#define USB_EP_DOEPCTL_INTBULK_SNAK_Msk       (0x01UL << USB_EP_DOEPCTL_INTBULK_SNAK_Pos)             /*!< USB_EP DOEPCTL_INTBULK: SNAK Mask       */
#define USB_EP_DOEPCTL_INTBULK_SetD0PID_Pos   28                                                      /*!< USB_EP DOEPCTL_INTBULK: SetD0PID Position */
#define USB_EP_DOEPCTL_INTBULK_SetD0PID_Msk   (0x01UL << USB_EP_DOEPCTL_INTBULK_SetD0PID_Pos)         /*!< USB_EP DOEPCTL_INTBULK: SetD0PID Mask   */
#define USB_EP_DOEPCTL_INTBULK_SetD1PID_Pos   29                                                      /*!< USB_EP DOEPCTL_INTBULK: SetD1PID Position */
#define USB_EP_DOEPCTL_INTBULK_SetD1PID_Msk   (0x01UL << USB_EP_DOEPCTL_INTBULK_SetD1PID_Pos)         /*!< USB_EP DOEPCTL_INTBULK: SetD1PID Mask   */
#define USB_EP_DOEPCTL_INTBULK_EPDis_Pos      30                                                      /*!< USB_EP DOEPCTL_INTBULK: EPDis Position  */
#define USB_EP_DOEPCTL_INTBULK_EPDis_Msk      (0x01UL << USB_EP_DOEPCTL_INTBULK_EPDis_Pos)            /*!< USB_EP DOEPCTL_INTBULK: EPDis Mask      */
#define USB_EP_DOEPCTL_INTBULK_EPEna_Pos      31                                                      /*!< USB_EP DOEPCTL_INTBULK: EPEna Position  */
#define USB_EP_DOEPCTL_INTBULK_EPEna_Msk      (0x01UL << USB_EP_DOEPCTL_INTBULK_EPEna_Pos)            /*!< USB_EP DOEPCTL_INTBULK: EPEna Mask      */

/* -------------------------------  USB_EP_DOEPINT  ------------------------------- */
#define USB_EP_DOEPINT_XferCompl_Pos          0                                                       /*!< USB_EP DOEPINT: XferCompl Position      */
#define USB_EP_DOEPINT_XferCompl_Msk          (0x01UL << USB_EP_DOEPINT_XferCompl_Pos)                /*!< USB_EP DOEPINT: XferCompl Mask          */
#define USB_EP_DOEPINT_EPDisbld_Pos           1                                                       /*!< USB_EP DOEPINT: EPDisbld Position       */
#define USB_EP_DOEPINT_EPDisbld_Msk           (0x01UL << USB_EP_DOEPINT_EPDisbld_Pos)                 /*!< USB_EP DOEPINT: EPDisbld Mask           */
#define USB_EP_DOEPINT_AHBErr_Pos             2                                                       /*!< USB_EP DOEPINT: AHBErr Position         */
#define USB_EP_DOEPINT_AHBErr_Msk             (0x01UL << USB_EP_DOEPINT_AHBErr_Pos)                   /*!< USB_EP DOEPINT: AHBErr Mask             */
#define USB_EP_DOEPINT_SetUp_Pos              3                                                       /*!< USB_EP DOEPINT: SetUp Position          */
#define USB_EP_DOEPINT_SetUp_Msk              (0x01UL << USB_EP_DOEPINT_SetUp_Pos)                    /*!< USB_EP DOEPINT: SetUp Mask              */
#define USB_EP_DOEPINT_OUTTknEPdis_Pos        4                                                       /*!< USB_EP DOEPINT: OUTTknEPdis Position    */
#define USB_EP_DOEPINT_OUTTknEPdis_Msk        (0x01UL << USB_EP_DOEPINT_OUTTknEPdis_Pos)              /*!< USB_EP DOEPINT: OUTTknEPdis Mask        */
#define USB_EP_DOEPINT_StsPhseRcvd_Pos        5                                                       /*!< USB_EP DOEPINT: StsPhseRcvd Position    */
#define USB_EP_DOEPINT_StsPhseRcvd_Msk        (0x01UL << USB_EP_DOEPINT_StsPhseRcvd_Pos)              /*!< USB_EP DOEPINT: StsPhseRcvd Mask        */
#define USB_EP_DOEPINT_Back2BackSETup_Pos     6                                                       /*!< USB_EP DOEPINT: Back2BackSETup Position */
#define USB_EP_DOEPINT_Back2BackSETup_Msk     (0x01UL << USB_EP_DOEPINT_Back2BackSETup_Pos)           /*!< USB_EP DOEPINT: Back2BackSETup Mask     */
#define USB_EP_DOEPINT_BNAIntr_Pos            9                                                       /*!< USB_EP DOEPINT: BNAIntr Position        */
#define USB_EP_DOEPINT_BNAIntr_Msk            (0x01UL << USB_EP_DOEPINT_BNAIntr_Pos)                  /*!< USB_EP DOEPINT: BNAIntr Mask            */
#define USB_EP_DOEPINT_PktDrpSts_Pos          11                                                      /*!< USB_EP DOEPINT: PktDrpSts Position      */
#define USB_EP_DOEPINT_PktDrpSts_Msk          (0x01UL << USB_EP_DOEPINT_PktDrpSts_Pos)                /*!< USB_EP DOEPINT: PktDrpSts Mask          */
#define USB_EP_DOEPINT_BbleErrIntrpt_Pos      12                                                      /*!< USB_EP DOEPINT: BbleErrIntrpt Position  */
#define USB_EP_DOEPINT_BbleErrIntrpt_Msk      (0x01UL << USB_EP_DOEPINT_BbleErrIntrpt_Pos)            /*!< USB_EP DOEPINT: BbleErrIntrpt Mask      */
#define USB_EP_DOEPINT_NAKIntrpt_Pos          13                                                      /*!< USB_EP DOEPINT: NAKIntrpt Position      */
#define USB_EP_DOEPINT_NAKIntrpt_Msk          (0x01UL << USB_EP_DOEPINT_NAKIntrpt_Pos)                /*!< USB_EP DOEPINT: NAKIntrpt Mask          */
#define USB_EP_DOEPINT_NYETIntrpt_Pos         14                                                      /*!< USB_EP DOEPINT: NYETIntrpt Position     */
#define USB_EP_DOEPINT_NYETIntrpt_Msk         (0x01UL << USB_EP_DOEPINT_NYETIntrpt_Pos)               /*!< USB_EP DOEPINT: NYETIntrpt Mask         */

/* -----------------------------  USB_EP_DOEPTSIZ_ISO  ---------------------------- */
#define USB_EP_DOEPTSIZ_ISO_XferSize_Pos      0                                                       /*!< USB_EP DOEPTSIZ_ISO: XferSize Position  */
#define USB_EP_DOEPTSIZ_ISO_XferSize_Msk      (0x0007ffffUL << USB_EP_DOEPTSIZ_ISO_XferSize_Pos)      /*!< USB_EP DOEPTSIZ_ISO: XferSize Mask      */
#define USB_EP_DOEPTSIZ_ISO_PktCnt_Pos        19                                                      /*!< USB_EP DOEPTSIZ_ISO: PktCnt Position    */
#define USB_EP_DOEPTSIZ_ISO_PktCnt_Msk        (0x000003ffUL << USB_EP_DOEPTSIZ_ISO_PktCnt_Pos)        /*!< USB_EP DOEPTSIZ_ISO: PktCnt Mask        */
#define USB_EP_DOEPTSIZ_ISO_RxDPID_Pos        29                                                      /*!< USB_EP DOEPTSIZ_ISO: RxDPID Position    */
#define USB_EP_DOEPTSIZ_ISO_RxDPID_Msk        (0x03UL << USB_EP_DOEPTSIZ_ISO_RxDPID_Pos)              /*!< USB_EP DOEPTSIZ_ISO: RxDPID Mask        */

/* ---------------------------  USB_EP_DOEPTSIZ_CONTROL  -------------