/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Byte1.C
**     Project   : RTOSDemo
**     Processor : MC9S12C32CFU
**     Beantype  : ByteIO
**     Version   : Bean 02.019, Driver 01.03, CPU db: 2.87.276
**     Compiler  : Metrowerks HC12 C Compiler
**     Date/Time : 10/05/2005, 11:49
**     Abstract  :
**         This bean "ByteIO" implements an one-byte input/output.
**         It uses one 8-bit port.
**         Note: This bean is set to work in Output direction only.
**         Methods of this bean are mostly implemented as a macros 
**         (if supported by target langauage and compiler).
**     Settings  :
**         Port name                   : B
**
**         Initial direction           : Output (direction cannot be changed)
**         Initial output value        : 0 = 000H
**         Initial pull option         : off
**
**         8-bit data register         : PORTB     [1]
**         8-bit control register      : DDRB      [3]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    16   |   PB0_ADDR0_DATA0
**                    1      |    17   |   PB1_ADDR1_DATA1
**                    2      |    18   |   PB2_ADDR2_DATA2
**                    3      |    19   |   PB3_ADDR3_DATA3
**                    4      |    20   |   PB4_ADDR4_DATA4
**                    5      |    21   |   PB5_ADDR5_DATA5
**                    6      |    22   |   PB6_ADDR6_DATA6
**                    7      |    23   |   PB7_ADDR7_DATA7
**             ----------------------------------------------------
**     Contents  :
**         PutBit - void Byte1_PutBit(byte Bit,bool Val);
**         NegBit - void Byte1_NegBit(byte Bit);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2002
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/


/* MODULE Byte1. */

#include "Byte1.h"
/*Including shared modules, which are used for all project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"

/* Definition of DATA and CODE segments for this bean. User can specify where
   these segments will be located on "Build options" tab of the selected CPU bean. */
#pragma DATA_SEG Byte1_DATA            /* Data section for this module. */
#pragma CODE_SEG Byte1_CODE            /* Code section for this module. */

/*
** ===================================================================
**     Method      :  Byte1_GetMsk (bean ByteIO)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
byte Byte1_Table[8]={ 1, 2, 4, 8, 16, 32, 64, 128 }; /* Table of mask constants */

byte Byte1_GetMsk(byte Value)
{
  return((Value<8)?Byte1_Table[Value]:0); /* Return appropriate bit mask */
}

/*
** ===================================================================
**     Method      :  Byte1_PutBit (bean ByteIO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bitnum     - Number of the bit (0 to 7)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_PutBit(byte BitNum, byte Value)
{
  byte Mask=Byte1_GetMsk(BitNum);      /* Temporary variable - bit mask */

  if (Mask)                            /* Is bit mask correct? */
    if (Value) {                       /* Is it one to be written? */
      PORTB |= Mask;                   /* Set appropriate bit on port */
    }
    else {                             /* Is it zero to be written? */
      PORTB &= ~Mask;                  /* Clear appropriate bit on port */
    }
}

/*
** ===================================================================
**     Method      :  Byte1_NegBit (bean ByteIO)
**
**     Description :
**         This method negates (invertes) the specified bit of the
**         output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 7)
**     Returns     : Nothing
** ===================================================================
*/
void Byte1_NegBit(byte BitNum)
{
  byte Mask=Byte1_GetMsk(BitNum);      /* Temporary variable - bit mask */

  if (Mask) {                          /* Is bit mask correct? */
    PORTB ^= Mask;                     /* Negate appropriate bit on port */
  }
}


/* END Byte1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.33 for 
**     the Motorola HCS12 series of microcontrollers.
**
** ###################################################################
*/
