/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Cpu.C
**     Project   : RTOSDemo
**     Processor : MC9S12C32CFU
**     Beantype  : MC9S12C32_80
**     Version   : Bean 01.002, Driver 01.09, CPU db: 2.87.276
**     Compiler  : Metrowerks HC12 C Compiler
**     Date/Time : 18/06/2005, 18:00
**     Abstract  :
**         This bean "MC9S12C32_80" implements properties, methods,
**         and events of the CPU.
**     Settings  :
**
**     Contents  :
**         EnableInt   - void Cpu_EnableInt(void);
**         DisableInt  - void Cpu_DisableInt(void);
**         SetWaitMode - void Cpu_SetWaitMode(void);
**         SetStopMode - void Cpu_SetStopMode(void);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2002
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE Cpu. */

#include "Byte1.h"
#include "TickTimer.h"
#include "ButtonInterrupt.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "PE_Timer.h"
#include "Events.h"
#include "Cpu.h"

#define CGM_DELAY  3071UL


/* Global variables */
volatile byte CCR_reg;                 /* Current CCR reegister */
byte CpuMode = HIGH_SPEED;             /* Current speed mode */


/*
** ===================================================================
**     Method      :  Cpu_Interrupt (bean MC9S12C32_80)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
#pragma CODE_SEG __NEAR_SEG NON_BANKED /* Interrupt section for this module. Placement will be in NON_BANKED area. */

__interrupt void Cpu_Interrupt(void)
{
}

#pragma CODE_SEG DEFAULT               /* Change code section to DEFAULT. */

/*
** ===================================================================
**     Method      :  Cpu_DisableInt (bean MC9S12C32_80)
**
**     Description :
**         Disable maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (bean MC9S12C32_80)
**
**     Description :
**         Enable maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetStopMode (bean MC9S12C32_80)
**
**     Description :
**         Set low power mode - Stop mode. For more information
**         about the stop mode see documentation of this CPU.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetStopMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetWaitMode (bean MC9S12C32_80)
**
**     Description :
**         Set low power mode - Wait mode. For more information
**         about the wait mode see documentation of this CPU.
**         Release from Watch mode: Reset or interrupt
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetWaitMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (bean MC9S12C32_80)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
extern void _Startup(void);            /* Forward declaration of external startup function declared in file Start12.c */
#define INITRG_ADR  0x0011             /* Register map position register */
#pragma NO_FRAME
#pragma NO_EXIT
void _EntryPoint(void)
{
  /*** ### MC9S12C32_80 "Cpu" init code ... ***/
  /*** PE initialization code after reset ***/
  /* Initialization of the registers INITRG, INITRM, INITEE is done to protect them to be written accidentally later by the application */
  *(byte*)INITRG_ADR = 0;              /* Set the register map position */
  asm nop;                             /* nop instruction */
  INITRM=8;                            /* Set the RAM map position */
  /* MISC: ??=0,??=0,??=0,??=0,EXSTR1=0,EXSTR0=0,ROMHM=0,ROMON=1 */
  MISC=1;
  /* System clock initialization */
  CLKSEL=0;
  CLKSEL_PLLSEL = 0;                   /* Select clock source from XTAL */
  PLLCTL_PLLON = 0;                    /* Disable the PLL */
  SYNR = 23;                           /* Set the multiplier register */
  REFDV = 15;                          /* Set the divider register */
  PLLCTL = 192;
  PLLCTL_PLLON = 1;                    /* Enable the PLL */
  while(!CRGFLG_LOCK);                 /* Wait */
  CLKSEL_PLLSEL = 1;                   /* Select clock source from PLL */
  /*** End of PE initialization code after reset ***/

  __asm   jmp _Startup;                /* Jump to C startup code */
}

/*
** ===================================================================
**     Method      :  PE_low_level_init (bean MC9S12C32_80)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /* Common initialization of the CPU registers */
/* TSCR1: TEN=0,TSWAI=0,TSFRZ=1 */
  output( TSCR1, input( TSCR1 ) & ~192 | 32 );
/* TCTL2: OM0=0,OL0=0 */
  output( TCTL2, input( TCTL2 ) & ~3 );
/* TCTL1: OM7=0,OL7=0 */
  output( TCTL1, input( TCTL1 ) & ~192 );
/* TIE: C0I=0 */
  output( TIE, input( TIE ) & ~1 );
/* TTOV: TOV0=0 */
  output( TTOV, input( TTOV ) & ~1 );
/* TSCR2: TOI=0,TCRE=1 */
  output( TSCR2, input( TSCR2 ) & ~128 | 8 );
/* TIOS: IOS7=1,IOS0=1 */
  output( TIOS, input( TIOS ) | 129 );
/* PPSP: PPSP0=0 */
  output( PPSP, input( PPSP ) & ~1 );
/* PERP: PERP0=1 */
  output( PERP, input( PERP ) | 1 );
/* DDRP: DDRP0=0 */
  output( DDRP, input( DDRP ) & ~1 );
/* PWMCTL: PSWAI=0,PFRZ=0 */
  output( PWMCTL, input( PWMCTL ) & ~12 );
/* PWMSDN: PWMIF=0,PWMIE=0,PWMRSTRT=0,PWMLVL=0,??=0,PWM7IN=0,PWM7INL=0,PWM7ENA=0 */
  output( PWMSDN, 0 );
  /* ### MC9S12C32_80 "Cpu" init code ... */
  /* ### ByteIO "Byte1" init code ... */
  PORTB = 0;                           /* Prepare value for output */
  DDRB = 255;                          /* Set direction to output */
  /* ### TimerInt "TickTimer" init code ... */
  TickTimer_Init();
  /* ### External interrupt "ButtonInterrupt" init code ... */
  PIEP_PIEP0 = 0;                      /* Disable interrupt */
 /* Common peripheral initialization - ENABLE */
/* TSCR1: TEN=1 */
  output( TSCR1, input( TSCR1 ) | 128 );
  INTCR_IRQEN = 0;                     /* Disable the IRQ interrupt. IRQ interrupt is enabled after CPU reset by default. */
  __DI();                              /* Disable interrupts */
}

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.33 for 
**     the Motorola HCS12 series of microcontrollers.
**
** ###################################################################
*/
